/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package com.android.camera.burst;

import java.io.File;

/**
 * Represents a media item generated by a burst.
 */
public interface BurstMediaItem {
    /**
     * Gets width of the media in pixels.
     *
     * @return width of the media in pixels
     */
    public int getWidth();

    /**
     * Gets height of the media in pixels.
     *
     * @return height of the media in pixels
     */
    public int getHeight();

    /**
     * Gets timestamp of the media in nanoseconds.
     *
     * @return timestamp of the media in nanoseconds
     */
    public long getTimestamp();

    /**
     * Gets the path to the media.
     *
     * @return the path to media file.
     */
    public File getFilePath();

    /**
     * Gets the mime type of the media.
     *
     * @return mime type of the media
     */
    public String getMimeType();

    /**
     * Gets the file extension of the media.
     *
     * @return file extension of the media
     */
    public String getExtension();

    /**
     * Returns whether the media file will support Exif data.
     *
     * @return true if the media type supports exif data, false otherwise
     */
    public boolean isSupportingExifData();
}