/*
 * Copyright (C) 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.camera.processing;

import android.content.Context;
import android.location.Location;

import com.android.camera.app.CameraServices;
import com.android.camera.session.CaptureSession;

/**
 * An interface for tasks to be processed by a {@code ProcessingService}.
 */
public interface ProcessingTaskConsumer {
    public void enqueueTask(ProcessingTask task);
}
