/*
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.harmony.luni.internal.net.www.protocol.http;

import java.io.IOException;
import java.io.OutputStream;

/**
 * An output stream for the body of an HTTP request.
 *
 * <p>Since a single socket's output stream may be used to write multiple HTTP
 * requests to the same server, subclasses should not close the socket stream.
 */
abstract class AbstractHttpOutputStream extends OutputStream {
    protected boolean closed;

    @Override public final void write(int data) throws IOException {
        write(new byte[] { (byte) data });
    }

    protected final void checkBounds(byte[] buffer, int offset, int count) {
        if (offset < 0|| offset > buffer.length || count < 0 || buffer.length - offset < count) {
            throw new ArrayIndexOutOfBoundsException(
                    "offset=" + offset + ", buffer.length=" + buffer.length + ", count=" + count);
        }
    }

    protected final void checkNotClosed() throws IOException {
        if (closed) {
            throw new IOException("stream closed");
        }
    }
}
