
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *       Testing Element.setAttributeNodeNS: If an attribute with that local name 
 *       and that namespace URI is already present in the element, it is replaced
 *       by the new one.
 *       Create a new element and two new attribute nodes (in the same namespace
 *       and same localNames).  
 *       Add the two new attribute nodes to the element node using the 
 *       setAttributeNodeNS method.  Check that only one attribute is added, check
 *       the value of this attribute.
 *     
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAtNodeNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAtNodeNS</a>
*/
public final class elementsetattributenodens01 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public elementsetattributenodens01(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "staff", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      Element element;
      Attr attribute1;
      Attr attribute2;
      Attr attrNode;
      String attrName;
      String attrNS;
      String attrValue;
      NamedNodeMap attributes;
      Attr newAttribute;
      int length;
      doc = (Document) load("staff", true);
      element = doc.createElementNS("http://www.w3.org/DOM/Test/Level2", "new:element");
      attribute1 = doc.createAttributeNS("http://www.w3.org/DOM/Test/att1", "p1:att");
      attribute2 = doc.createAttributeNS("http://www.w3.org/DOM/Test/att1", "p2:att");
      attribute2.setValue("value2");
      newAttribute = element.setAttributeNodeNS(attribute1);
      newAttribute = element.setAttributeNodeNS(attribute2);
      attrNode = element.getAttributeNodeNS("http://www.w3.org/DOM/Test/att1", "att");
      attrName = attrNode.getNodeName();
      attrNS = attrNode.getNamespaceURI();
      assertEquals("elementsetattributenodens01_attrName", "p2:att", attrName);
      assertEquals("elementsetattributenodens01_attrNS", "http://www.w3.org/DOM/Test/att1", attrNS);
      attributes = element.getAttributes();
      length = (int) attributes.getLength();
      assertEquals("length", 1, length);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/elementsetattributenodens01";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(elementsetattributenodens01.class, args);
   }
}

