/*
 * Decompiled with CFR 0.152.
 */
package org.junit;

import java.lang.reflect.Array;
import org.junit.ComparisonFailure;
import org.junit.internal.ArrayComparisonFailure;

public class Assert {
    protected Assert() {
    }

    public static void assertTrue(String message, boolean condition) {
        if (!condition) {
            Assert.fail(message);
        }
    }

    public static void assertTrue(boolean condition) {
        Assert.assertTrue(null, condition);
    }

    public static void assertFalse(String message, boolean condition) {
        Assert.assertTrue(message, !condition);
    }

    public static void assertFalse(boolean condition) {
        Assert.assertFalse(null, condition);
    }

    public static void fail(String message) {
        throw new AssertionError((Object)(message == null ? "" : message));
    }

    public static void fail() {
        Assert.fail(null);
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && Assert.isEquals(expected, actual)) {
            return;
        }
        if (expected instanceof String && actual instanceof String) {
            String cleanMessage = message == null ? "" : message;
            throw new ComparisonFailure(cleanMessage, (String)expected, (String)actual);
        }
        Assert.failNotEquals(message, expected, actual);
    }

    private static boolean isEquals(Object expected, Object actual) {
        if (expected instanceof Number && actual instanceof Number) {
            return ((Number)expected).longValue() == ((Number)actual).longValue();
        }
        return expected.equals(actual);
    }

    public static void assertEquals(Object expected, Object actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertArrayEquals(String message, Object[] expecteds, Object[] actuals) throws ArrayComparisonFailure {
        Assert.internalArrayEquals(message, expecteds, actuals);
    }

    public static void assertArrayEquals(Object[] expecteds, Object[] actuals) {
        Assert.assertArrayEquals(null, expecteds, actuals);
    }

    public static void assertArrayEquals(String message, byte[] expecteds, byte[] actuals) throws ArrayComparisonFailure {
        Assert.internalArrayEquals(message, expecteds, actuals);
    }

    public static void assertArrayEquals(byte[] expecteds, byte[] actuals) {
        Assert.assertArrayEquals(null, expecteds, actuals);
    }

    public static void assertArrayEquals(String message, char[] expecteds, char[] actuals) throws ArrayComparisonFailure {
        Assert.internalArrayEquals(message, expecteds, actuals);
    }

    public static void assertArrayEquals(char[] expecteds, char[] actuals) {
        Assert.assertArrayEquals(null, expecteds, actuals);
    }

    public static void assertArrayEquals(String message, short[] expecteds, short[] actuals) throws ArrayComparisonFailure {
        Assert.internalArrayEquals(message, expecteds, actuals);
    }

    public static void assertArrayEquals(short[] expecteds, short[] actuals) {
        Assert.assertArrayEquals(null, expecteds, actuals);
    }

    public static void assertArrayEquals(String message, int[] expecteds, int[] actuals) throws ArrayComparisonFailure {
        Assert.internalArrayEquals(message, expecteds, actuals);
    }

    public static void assertArrayEquals(int[] expecteds, int[] actuals) {
        Assert.assertArrayEquals(null, expecteds, actuals);
    }

    public static void assertArrayEquals(long[] expecteds, long[] actuals) {
        Assert.assertArrayEquals(null, expecteds, actuals);
    }

    public static void assertArrayEquals(String message, long[] expecteds, long[] actuals) throws ArrayComparisonFailure {
        Assert.internalArrayEquals(message, expecteds, actuals);
    }

    private static void internalArrayEquals(String message, Object expecteds, Object actuals) throws ArrayComparisonFailure {
        int expectedsLength;
        int actualsLength;
        String header;
        if (expecteds == actuals) {
            return;
        }
        String string = header = message == null ? "" : String.valueOf(message) + ": ";
        if (expecteds == null) {
            Assert.fail(String.valueOf(header) + "expected array was null");
        }
        if (actuals == null) {
            Assert.fail(String.valueOf(header) + "actual array was null");
        }
        if ((actualsLength = Array.getLength(actuals)) != (expectedsLength = Array.getLength(expecteds))) {
            Assert.fail(String.valueOf(header) + "array lengths differed, expected.length=" + expectedsLength + " actual.length=" + actualsLength);
        }
        int i = 0;
        while (i < expectedsLength) {
            Object expected = Array.get(expecteds, i);
            Object actual = Array.get(actuals, i);
            if (Assert.isArray(expected) && Assert.isArray(actual)) {
                try {
                    Assert.internalArrayEquals(message, expected, actual);
                }
                catch (ArrayComparisonFailure e) {
                    e.addDimension(i);
                    throw e;
                }
            }
            try {
                Assert.assertEquals(expected, actual);
            }
            catch (AssertionError e) {
                throw new ArrayComparisonFailure(header, e, i);
            }
            ++i;
        }
    }

    private static boolean isArray(Object expected) {
        return expected != null && expected.getClass().isArray();
    }

    public static void assertEquals(String message, double expected, double actual, double delta) {
        if (Double.compare(expected, actual) == 0) {
            return;
        }
        if (!(Math.abs(expected - actual) <= delta)) {
            Assert.failNotEquals(message, new Double(expected), new Double(actual));
        }
    }

    public static void assertEquals(double expected, double actual, double delta) {
        Assert.assertEquals(null, expected, actual, delta);
    }

    public static void assertNotNull(String message, Object object) {
        Assert.assertTrue(message, object != null);
    }

    public static void assertNotNull(Object object) {
        Assert.assertNotNull(null, object);
    }

    public static void assertNull(String message, Object object) {
        Assert.assertTrue(message, object == null);
    }

    public static void assertNull(Object object) {
        Assert.assertNull(null, object);
    }

    public static void assertSame(String message, Object expected, Object actual) {
        if (expected == actual) {
            return;
        }
        Assert.failNotSame(message, expected, actual);
    }

    public static void assertSame(Object expected, Object actual) {
        Assert.assertSame(null, expected, actual);
    }

    public static void assertNotSame(String message, Object unexpected, Object actual) {
        if (unexpected == actual) {
            Assert.failSame(message);
        }
    }

    public static void assertNotSame(Object unexpected, Object actual) {
        Assert.assertNotSame(null, unexpected, actual);
    }

    private static void failSame(String message) {
        String formatted = "";
        if (message != null) {
            formatted = String.valueOf(message) + " ";
        }
        Assert.fail(String.valueOf(formatted) + "expected not same");
    }

    private static void failNotSame(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = String.valueOf(message) + " ";
        }
        Assert.fail(String.valueOf(formatted) + "expected same:<" + expected + "> was not:<" + actual + ">");
    }

    private static void failNotEquals(String message, Object expected, Object actual) {
        Assert.fail(Assert.format(message, expected, actual));
    }

    static String format(String message, Object expected, Object actual) {
        String actualString;
        String expectedString;
        String formatted = "";
        if (message != null && !message.equals("")) {
            formatted = String.valueOf(message) + " ";
        }
        if ((expectedString = String.valueOf(expected)).equals(actualString = String.valueOf(actual))) {
            return String.valueOf(formatted) + "expected: " + expected.getClass().getName() + "<" + expectedString + "> but was: " + actual.getClass().getName() + "<" + actualString + ">";
        }
        return String.valueOf(formatted) + "expected:<" + expectedString + "> but was:<" + actualString + ">";
    }

    @Deprecated
    public static void assertEquals(String message, Object[] expecteds, Object[] actuals) {
        Assert.assertArrayEquals(message, expecteds, actuals);
    }

    @Deprecated
    public static void assertEquals(Object[] expecteds, Object[] actuals) {
        Assert.assertArrayEquals(expecteds, actuals);
    }
}

