
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:


Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University). All
Rights Reserved. This program is distributed under the W3C's Software
Intellectual Property License. This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.
See W3C License http://www.w3.org/Consortium/Legal/ for more details.

*/

package org.w3c.domts.level1.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *     If the cloneNode method is used to clone an
 *     Element node, all the attributes of the Element are
 *     copied along with their values.
 *     
 *     Retrieve the last child of the second employee and invoke
 *     the cloneNode method.   The
 *     duplicate node returned by the method should copy the
 *     attributes associated with this node.
* @author NIST
* @author Mary Brady
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096</a>
*/
public final class nodecloneattributescopied extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public nodecloneattributescopied(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "staff", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      NodeList elementList;
      Node addressNode;
      Node clonedNode;
      NamedNodeMap attributes;
      Node attributeNode;
      String attributeName;
      java.util.Collection result = new java.util.ArrayList();
      
      java.util.Collection expectedResult = new java.util.ArrayList();
      expectedResult.add("domestic");
      expectedResult.add("street");
      
      doc = (Document) load("staff", true);
      elementList = doc.getElementsByTagName("address");
      addressNode = elementList.item(1);
      clonedNode = addressNode.cloneNode(false);
      attributes = clonedNode.getAttributes();
      for (int indexN10065 = 0; indexN10065 < attributes.getLength(); indexN10065++) {
          attributeNode = (Node) attributes.item(indexN10065);
    attributeName = attributeNode.getNodeName();
      result.add(attributeName);
        }
      assertEquals("nodeCloneAttributesCopiedAssert1", expectedResult, result);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level1/core/nodecloneattributescopied";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(nodecloneattributescopied.class, args);
   }
}

