/******************************************************************************
 *
 * Copyright(c) 2007 - 2011 Realtek Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 ******************************************************************************/

//============================================================
// include files
//============================================================

#include "odm_precomp.h"
//
// ODM IO Relative API.
//

u8
ODM_Read1Byte(
	PDM_ODM_T		pDM_Odm,
	u32			RegAddr
	)
{
	PADAPTER		Adapter = pDM_Odm->Adapter;

	return rtw_read8(Adapter,RegAddr);
}


u16
ODM_Read2Byte(
	PDM_ODM_T		pDM_Odm,
	u32			RegAddr
	)
{
	PADAPTER		Adapter = pDM_Odm->Adapter;

	return rtw_read16(Adapter,RegAddr);
}

u32
ODM_Read4Byte(
	PDM_ODM_T		pDM_Odm,
	u32			RegAddr
	)
{
	PADAPTER		Adapter = pDM_Odm->Adapter;

	return rtw_read32(Adapter,RegAddr);
}


void
ODM_Write1Byte(
	PDM_ODM_T		pDM_Odm,
	u32			RegAddr,
	u8			Data
	)
{
	PADAPTER		Adapter = pDM_Odm->Adapter;

	rtw_write8(Adapter,RegAddr, Data);
}


void
ODM_Write2Byte(
	PDM_ODM_T		pDM_Odm,
	u32			RegAddr,
	u16			Data
	)
{
	PADAPTER		Adapter = pDM_Odm->Adapter;

	rtw_write16(Adapter,RegAddr, Data);
}


void
ODM_Write4Byte(
	PDM_ODM_T		pDM_Odm,
	u32			RegAddr,
	u32			Data
	)
{
	PADAPTER		Adapter = pDM_Odm->Adapter;

	rtw_write32(Adapter,RegAddr, Data);
}

void
ODM_SetMACReg(
	PDM_ODM_T	pDM_Odm,
	u32		RegAddr,
	u32		BitMask,
	u32		Data
	)
{
	PADAPTER		Adapter = pDM_Odm->Adapter;

	PHY_SetBBReg(Adapter, RegAddr, BitMask, Data);
}

u32
ODM_GetMACReg(
	PDM_ODM_T	pDM_Odm,
	u32		RegAddr,
	u32		BitMask
	)
{
	PADAPTER		Adapter = pDM_Odm->Adapter;

	return PHY_QueryBBReg(Adapter, RegAddr, BitMask);
}

void
ODM_SetBBReg(
	PDM_ODM_T	pDM_Odm,
	u32		RegAddr,
	u32		BitMask,
	u32		Data
	)
{
	PADAPTER		Adapter = pDM_Odm->Adapter;

	PHY_SetBBReg(Adapter, RegAddr, BitMask, Data);
}

u32
ODM_GetBBReg(
	PDM_ODM_T	pDM_Odm,
	u32		RegAddr,
	u32		BitMask
	)
{
	PADAPTER		Adapter = pDM_Odm->Adapter;

	return PHY_QueryBBReg(Adapter, RegAddr, BitMask);
}


void
ODM_SetRFReg(
	PDM_ODM_T			pDM_Odm,
	ODM_RF_RADIO_PATH_E	eRFPath,
	u32				RegAddr,
	u32				BitMask,
	u32				Data
	)
{
	PADAPTER		Adapter = pDM_Odm->Adapter;

	PHY_SetRFReg(Adapter, eRFPath, RegAddr, BitMask, Data);
}


u32
ODM_GetRFReg(
	PDM_ODM_T			pDM_Odm,
	ODM_RF_RADIO_PATH_E	eRFPath,
	u32				RegAddr,
	u32				BitMask
	)
{
	PADAPTER		Adapter = pDM_Odm->Adapter;

	return PHY_QueryRFReg(Adapter, eRFPath, RegAddr, BitMask);
}

//
// ODM Memory relative API.
//
void
ODM_AllocateMemory(
	PDM_ODM_T	pDM_Odm,
	void *		*pPtr,
	u32		length
	)
{
	*pPtr = rtw_zvmalloc(length);
}

// length could be ignored, used to detect memory leakage.
void
ODM_FreeMemory(
	PDM_ODM_T	pDM_Odm,
	void *		pPtr,
	u32		length
	)
{
	rtw_vmfree(pPtr, length);
}

void
ODM_MoveMemory(
	PDM_ODM_T	pDM_Odm,
	void *		pDest,
	const void *		pSrc,
	u32		Length
	)
{
	_rtw_memcpy(pDest, (void *)pSrc, Length);
}

s4Byte ODM_CompareMemory(
	PDM_ODM_T	pDM_Odm,
	void *           pBuf1,
      void *           pBuf2,
      u32          length
       )
{
	return _rtw_memcmp(pBuf1,pBuf2,length);
}

//
// ODM MISC relative API.
//
void
ODM_AcquireSpinLock(
	PDM_ODM_T			pDM_Odm,
	RT_SPINLOCK_TYPE	type
	)
{
}

void
ODM_ReleaseSpinLock(
	PDM_ODM_T			pDM_Odm,
	RT_SPINLOCK_TYPE	type
	)
{
}

//
// Work item relative API. FOr MP driver only~!
//
void
ODM_InitializeWorkItem(
	PDM_ODM_T					pDM_Odm,
	PRT_WORK_ITEM				pRtWorkItem,
	RT_WORKITEM_CALL_BACK		RtWorkItemCallback,
	void *						pContext,
	const char*					szID
	)
{
}

void
ODM_StartWorkItem(
	PRT_WORK_ITEM	pRtWorkItem
	)
{
}


void
ODM_StopWorkItem(
	PRT_WORK_ITEM	pRtWorkItem
	)
{
}

void
ODM_FreeWorkItem(
	PRT_WORK_ITEM	pRtWorkItem
	)
{
}

void
ODM_ScheduleWorkItem(
	PRT_WORK_ITEM	pRtWorkItem
	)
{
}

void
ODM_IsWorkItemScheduled(
	PRT_WORK_ITEM	pRtWorkItem
	)
{
}

//
// ODM Timer relative API.
//
void
ODM_StallExecution(
	u32	usDelay
	)
{
	rtw_udelay_os(usDelay);
}

void
ODM_delay_ms(u32	ms)
{
	rtw_mdelay_os(ms);
}

void
ODM_delay_us(u32	us)
{
	rtw_udelay_os(us);
}

void
ODM_sleep_ms(u32	ms)
{
	rtw_msleep_os(ms);
}

void
ODM_sleep_us(u32	us)
{
	rtw_usleep_os(us);
}

void
ODM_SetTimer(
	PDM_ODM_T		pDM_Odm,
	PRT_TIMER		pTimer,
	u32			msDelay
	)
{
	_set_timer(pTimer,msDelay ); //ms
}

#if LINUX_VERSION_CODE < KERNEL_VERSION(4, 15, 0)
void
ODM_InitializeTimer(
	PDM_ODM_T			pDM_Odm,
	PRT_TIMER			pTimer,
	RT_TIMER_CALL_BACK	CallBackFunc,
	void *				pContext,
	const char*			szID
	)
{
	PADAPTER Adapter = pDM_Odm->Adapter;

	_init_timer(pTimer,Adapter->pnetdev,CallBackFunc,pDM_Odm);
}
#endif

void
ODM_CancelTimer(
	PDM_ODM_T		pDM_Odm,
	PRT_TIMER		pTimer
	)
{
	_cancel_timer_ex(pTimer);
}

void
ODM_ReleaseTimer(
	PDM_ODM_T		pDM_Odm,
	PRT_TIMER		pTimer
	)
{
}

//
// ODM FW relative API.
//
u32
ODM_FillH2CCmd(
	u8 *		pH2CBuffer,
	u32		H2CBufferLen,
	u32		CmdNum,
	u32 *		pElementID,
	u32 *		pCmdLen,
	u8 **		pCmbBuffer,
	u8 *		CmdStartSeq
	)
{
	return	true;
}
