# Bugreport file format

This document specifies the format of the bugreport files generated by the
bugreport services (like `bugreport` and `bugreportplus`) and delivered to the
end user (i.e., it doesn’t include other tools like `adb bugreport`).

A _bugreport_ is initially generated by dumpstate, then processed by **Shell**,
which in turn delivers it to the end user through a `ACTION_SEND_MULTIPLE`
intent; the end user then select which app (like an email client) handles such
intent.

## Text file (Pre-M)
Prior to _Android M (Marshmallow)_, `dumpstate` generates a flat .txt file named
_bugreport-DATE.txt_ (where _DATE_ is date the bugreport was generated, in the
format _YYYY-MM-DD-HH-MM-SS_), and Shell simply propagates it as an attachment
in the `ACTION_SEND_MULTIPLE` intent.

## Version v0 (Android M)
On _Android M (Marshmallow)_, dumpstate still generates a flat
_bugreport-DATE.txt_ file, but then **Shell** creates a zip file called
_bugreport-DATE.zip_ containing a _bugreport-DATE.txt_ entry and sends that
file as the `ACTION_SEND_MULTIPLE` attachment.

## Version v1 (Android N)
On _Android N (TBD)_, `dumpstate` generates a zip file directly (unless there
is a failure, in which case it reverts to the flat file that is zipped by
**Shell** and hence the end result is the _v0_ format).

The zip file is by default called _bugreport-DATE.zip_ and it contains a
_bugreport-DATE.txt_ entry, although the end user can change the name (through
**Shell**), in which case they would be called _bugreport-NEW_NAME.zip_ and
_bugreport-NEW_NAME.txt_ respectively.

The zip file also contains 2 metadata entries generated by `dumpstate`:

- `version.txt`:  whose value is **v1**.
- `main-entry.txt`: whose value is the name of the flat text entry (i.e.,
  _bugreport-DATE.txt_ or _bugreport-NEW_NAME.txt_).

`dumpstate` can also copy files from the device’s filesystem into the zip file
under the `FS` folder. For example, a `/dirA/dirB/fileC` file in the device
would generate a `FS/dirA/dirB/fileC` entry in the zip file.

The flat file also has some minor changes:

- Tombstone files were removed and added to the zip file.
- The duration of each section is printed in the report.
- Some dumpsys sections (memory and cpuinfo) are reported earlier in the file.

Besides the files generated by `dumpstate`, **Shell** can also add 2 other
files upon the end user’s request:

- `title.txt`: whose value is a single-line summary of the problem.
- `description.txt`: whose value is a multi-line, detailed description of the problem.

## Intermediate versions
During development, the versions will be suffixed with _-devX_ or
_-devX-EXPERIMENTAL_FEATURE_, where _X_ is a number that increases as the
changes become stable.

For example, the initial version during _Android N_ development was
**v1-dev1**. When `dumpsys` was split in 2 sections but not all tools were
ready to parse that format, the version was named **v1-dev1-dumpsys-split**,
which had to be passed do `dumpsys` explicitly (i.e., trhough a
`-V v1-dev1-dumpsys-split` argument). Once that format became stable and tools
knew how to parse it, the default version became **v1-dev2**.

Similarly, if changes in the file format are made after the initial release of
Android defining that format, then a new _sub-version_ will be used.
For example, if after _Android N_ launches changes are made for the next _N_
release, the version will be called **v1.1** or something like that.

Determining version and main entry
-----------------------------------------------

Tools parsing the zipped bugreport file can use the following algorithm to
determine the bugreport format version and its main entry:

```
If [entries contain "version.txt"]
   version = read("version.txt")
   main_entry = read("main_entry.txt")
else
   version = v0
   main_entry = entries[0]
fi
```
