/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#include <utils/String16.h>
#include "StatsPuller.h"

namespace android {
namespace os {
namespace statsd {

class StatsCompanionServicePuller : public StatsPuller {
public:
    StatsCompanionServicePuller(int tagId);
    bool PullInternal(vector<std::shared_ptr<LogEvent> >* data) override;

    void SetStatsCompanionService(sp<IStatsCompanionService> statsCompanionService) override;

private:
    Mutex mStatsCompanionServiceLock;
    sp<IStatsCompanionService> mStatsCompanionService = nullptr;
};

}  // namespace statsd
}  // namespace os
}  // namespace android
