<ul id="nav">
  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/index.html">
        Getting Started
      </a>
    </div>

    <ul>
      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/basics/firstapp/index.html"
             description=
             "After you've installed the Android SDK, start with this class
             to learn the basics about Android app development."
            >It worked!!</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/basics/firstapp/creating-project.html">
            Creating an Android Project
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/firstapp/running-app.html">
            Running Your Application
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/firstapp/building-ui.html">
            Building a Simple User Interface
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/firstapp/starting-activity.html">
            Starting Another Activity
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/basics/supporting-devices/index.html"
             description=
             "How to build your app with alternative resources that provide an
             optimized user experience on multiple device form factors using a single APK."
            >Supporting Different Devices</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/basics/supporting-devices/languages.html">
            Supporting Different Languages
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/supporting-devices/screens.html">
            Supporting Different Screens
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/supporting-devices/platforms.html">
            Supporting Different Platform Versions
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/basics/activity-lifecycle/index.html"
             ja-lang="アクティビティのライフサイクル 管理"
             ko-lang="액티비티 수명 주기 관리하기"
             pt-br-lang="Como gerenciar o ciclo de vida da atividade"
             ru-lang="Управление жизненным циклом операций"
             zh-cn-lang="管理活动生命周期"
             zh-tw-lang="管理應用行為顯示生命週期"
             description=
             "How Android activities live and die and how to create
             a seamless user experience by implementing lifecycle callback methods."
            >Managing the Activity Lifecycle</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/basics/activity-lifecycle/starting.html"
             ja-lang="アクティビティを開始する"
             ko-lang="액티비티 시작하기"
             pt-br-lang="Iniciando uma atividade"
             ru-lang="Запуск операции"
             zh-cn-lang="开始活动"
             zh-tw-lang="啟動應用行為顯示">
            Starting an Activity
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/activity-lifecycle/pausing.html">
            Pausing and Resuming an Activity
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/activity-lifecycle/stopping.html"
             ja-lang="アクティビティの一時停止と再開"
             ko-lang="액티비티 일시정지 및 재개하기"
             pt-br-lang="Pausando e reiniciando uma atividade"
             ru-lang="Приостановка и возобновление операции"
             zh-cn-lang="暂停和继续活动"
             zh-tw-lang="暫停並繼續應用行為顯示">
            Stopping and Restarting an Activity
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/activity-lifecycle/recreating.html"
             ja-lang="アクティビティを再作成する"
             ko-lang="액티비티 재생성하기"
             pt-br-lang="Recriando uma atividade"
             ru-lang="Воссоздание операции"
             zh-cn-lang="重新创建活动"
             zh-tw-lang="重新建立應用行為顯示">
            Recreating an Activity
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/basics/fragments/index.html"
             description=
             "How to build a user interface for your app that is flexible enough
             to present multiple UI components on large screens and a more constrained set of
             UI components on smaller screens&mdash;essential for building a single APK for both
             phones and tablets."
            >Building a Dynamic UI with Fragments</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/basics/fragments/creating.html">
            Creating a Fragment
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/fragments/fragment-ui.html" zh-cn-lang="构建灵活的界面">
            Building a Flexible UI
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/fragments/communicating.html">
            Communicating with Other Fragments
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header"><a href="<?cs var:toroot?>training/basics/data-storage/index.html"
             ja-lang="データの保存"
             ko-lang="데이터 저장하기"
             pt-br-lang="Salvando dados"
             ru-lang="Сохранение данных"
             zh-cn-lang="保存数据"
             zh-tw-lang="儲存資料"
             description=
             "How to save data on the device, whether it's temporary files, downloaded
             app assets, user media, structured data, or something else."
            >Saving Data</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/basics/data-storage/shared-preferences.html"
             ja-lang="キー値セットを保存する"
             ko-lang="키-값 세트 저장하기"
             pt-br-lang="Salvando conjuntos de valor-chave"
             ru-lang="Сохранение наборов "\"ключ-значение\""
             zh-cn-lang="保存键值集"
             zh-tw-lang="儲存索引鍵值組">
            Saving Key-Value Sets
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/data-storage/files.html"
             ja-lang="ファイルを保存する"
             ko-lang="파일 저장하기"
             pt-br-lang="Salvando arquivos"
             ru-lang="Сохранение файлов"
             zh-cn-lang="保存文件"
             zh-tw-lang="儲存檔案">
            Saving Files
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/data-storage/databases.html"
             ja-lang="SQL データベースにデータを保存する"
             ko-lang="SQL 데이터베이스에 데이터 저장하기"
             pt-br-lang="Salvando dados em bancos de dados do SQL"
             ru-lang="Сохранение данных в базах данных SQL"
             zh-cn-lang="在 SQL 数据库中保存数据"
             zh-tw-lang="在 SQL 資料庫中儲存資料">
            Saving Data in SQL Databases
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/basics/intents/index.html"
             ja-lang="他のアプリとの相互操作"
             ko-lang="액티비티 수명 주기 관리하기"
             pt-br-lang="Interagindo com outros aplicativos"
             ru-lang="Взаимодействие с другими приложениями"
             zh-cn-lang="与其他应用交互"
             zh-tw-lang="與其他應用程式互動"
             description=
             "How to build a user experience that leverages other apps available
             on the device to perform advanced user tasks, such as capture a photo or view
             an address on a map."
            >Interacting with Other Apps</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/basics/intents/sending.html"
             ja-lang="別のアプリにユーザーを送る"
             ko-lang="다른 앱으로 사용자 보내기"
             pt-br-lang="Enviando o usuário para outro aplicativo"
             ru-lang="Направление пользователя в другое приложение"
             zh-cn-lang="向另一个应用发送用户"
             zh-tw-lang="將使用者傳送至其他應用程式">
            Sending the User to Another App
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/intents/result.html"
             ja-lang="アクティビティから結果を取得する"
             ko-lang="액티비티로부터 결과 가져오기"
             pt-br-lang="Obtendo resultados de uma atividade"
             ru-lang="Получение результата операции"
             zh-cn-lang="获取活动的结果"
             zh-tw-lang="從應用行為顯示取得結果">
            Getting a Result from the Activity
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/intents/filters.html"
             ja-lang="他のアプリからのアクティビティの開始を許可する"
             ko-lang="다른 앱이 자신의 액티비티를 시작하도록 허용하기"
             pt-br-lang="Permitindo que outros aplicativos iniciem sua atividade"
             ru-lang="Разрешение другим приложениям на запуск вашей операции"
             zh-cn-lang="允许其他应用开始您的活动"
             zh-tw-lang="允許其他應用程式啟動您的應用行為顯示">
            Allowing Other Apps to Start Your Activity
          </a>
          </li>
        </ul>
      </li>
      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/permissions/index.html"
             description=
             "How to declare that your app needs access to features and
             resources outside of its 'sandbox', and how to request those
             privileges at runtime."
            >Working with System Permissions</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/permissions/declaring.html">
            Declaring Permissions
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/permissions/requesting.html">
            Requesting Permissions at Run Time
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/permissions/best-practices.html">
            Best Practices for Runtime Permissions
          </a>
          </li>
        </ul>
      </li>

    </ul>
  </li><!-- end getting started -->
    <li class="nav-section">
        <div class="nav-section-header">
            <a href="<?cs var:toroot ?>training/building-content-sharing.html">
            <span class="small">Building Apps with</span><br/>Content Sharing
            </a>
        </div>
        <ul>
            <li class="nav-section">
                <div class="nav-section-header">
                    <a href="<?cs var:toroot ?>training/sharing/index.html"
                    description=
                    "How to take your app interaction to the next level by sharing
                    information with other apps, receive information back, and provide a simple and
                    scalable way to perform Share actions with user content."
                    >Sharing Simple Data</a>
                </div>
                <ul>
                    <li>
                        <a href="<?cs var:toroot ?>training/sharing/send.html">
                        Sending Simple Data to Other Apps
                        </a>
                    </li>
                    <li>
                        <a href="<?cs var:toroot ?>training/sharing/receive.html">
                        Receiving Simple Data from Other Apps
                        </a>
                    </li>
                    <li>
                        <a href="<?cs var:toroot ?>training/sharing/shareaction.html">
                        Adding an Easy Share Action
                        </a>
                    </li>
                </ul>
            </li>
            <li class="nav-section">
                <div class="nav-section-header">
                    <a href="<?cs var:toroot?>training/secure-file-sharing/index.html"
                    description=
                    "How to provide secure access to a file associated with your app using a content
                    URI and temporary access permissions."
                    >Sharing Files</a>
                </div>
                <ul>
                    <li>
                        <a href="<?cs var:toroot ?>training/secure-file-sharing/setup-sharing.html">
                        Setting Up File Sharing
                        </a>
                    </li>
                    <li>
                        <a href="<?cs var:toroot ?>training/secure-file-sharing/share-file.html">
                        Sharing a File
                        </a>
                    </li>
                    <li>
                        <a href="<?cs var:toroot ?>training/secure-file-sharing/request-file.html">
                        Requesting a Shared File
                        </a>
                    </li>
                    <li>
                        <a href="<?cs var:toroot ?>training/secure-file-sharing/retrieve-info.html">
                        Retrieving File Information
                        </a>
                    </li>
                </ul>
            </li>
            <li class="nav-section">
                <div class="nav-section-header">
                    <a href="<?cs var:toroot ?>training/beam-files/index.html"
                    description=
                    "How to transfer files between devices using the NFC Android Beam feature."
                    >Sharing Files with NFC</a>
                </div>
                <ul>
                    <li>
                        <a href="<?cs var:toroot ?>training/beam-files/send-files.html"
                        >Sending Files to Another Device</a>
                    </li>
                    <li><a href="<?cs var:toroot ?>training/beam-files/receive-files.html"
                    >Receiving Files from Another Device</a></li>
                </ul>
            </li>
        </ul>
    </li>



  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/building-multimedia.html">
      <span class="small">Building Apps with</span><br/>Multimedia
      </a>
    </div>
    <ul>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/managing-audio/index.html"
             description=
             "How to respond to hardware audio key presses, request audio focus
             when playing audio, and respond appropriately to changes in audio focus."
            >Managing Audio Playback</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/managing-audio/volume-playback.html">
            Controlling Your App's Volume and Playback
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/managing-audio/audio-focus.html">
            Managing Audio Focus
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/managing-audio/audio-output.html">
            Dealing with Audio Output Hardware
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/camera/index.html"
             description=
             "How to leverage existing camera apps on the user's device to capture
             photos or control the camera hardware directly and build your own camera app."
            >Capturing Photos</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/camera/photobasics.html">
            Taking Photos Simply
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/camera/videobasics.html">
            Recording Videos Simply
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/camera/cameradirect.html">
            Controlling the Camera
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/printing/index.html"
             description=
             "How to print photos, HTML documents, and custom documents from your app."
            >Printing Content</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/printing/photos.html">
            Photos
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/printing/html-docs.html">
            HTML Documents
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/printing/custom-docs.html">
            Custom Documents
          </a>
          </li>
        </ul>
      </li>

    </ul>
  </li>
  <!-- End multimedia -->



  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/building-graphics.html">
      <span class="small">Building Apps with</span><br/>Graphics &amp; Animation
      </a>
    </div>
    <ul>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/displaying-bitmaps/index.html"
             description=
             "How to load and process bitmaps while keeping your user interface
             responsive and avoid exceeding memory limits."
            >Displaying Bitmaps Efficiently</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/displaying-bitmaps/load-bitmap.html">
            Loading Large Bitmaps Efficiently
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/displaying-bitmaps/process-bitmap.html">
            Processing Bitmaps Off the UI Thread
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/displaying-bitmaps/cache-bitmap.html">
            Caching Bitmaps
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/displaying-bitmaps/manage-memory.html">
            Managing Bitmap Memory
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/displaying-bitmaps/display-bitmap.html">
            Displaying Bitmaps in Your UI
          </a></li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot?>training/graphics/opengl/index.html"
             description=
             "How to create OpenGL graphics within the Android app framework
             and respond to touch input."
            >Displaying Graphics with OpenGL ES</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/graphics/opengl/environment.html">
            Building an OpenGL ES Environment
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/graphics/opengl/shapes.html">
            Defining Shapes
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/graphics/opengl/draw.html">
            Drawing Shapes
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/graphics/opengl/projection.html">
            Applying Projection and Camera Views
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/graphics/opengl/motion.html">
            Adding Motion
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/graphics/opengl/touch.html">
            Responding to Touch Events
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot?>training/transitions/index.html"
             description=
             "How to animate state changes in a view hierarchy using transitions."
            >Animating Views Using Scenes and Transitions</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/transitions/overview.html">
            The Transitions Framework
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/transitions/scenes.html">
            Creating a Scene
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/transitions/transitions.html">
            Applying a Transition
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/transitions/custom-transitions.html">
            Creating Custom Transitions
          </a>
          </li>

        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header"><a href="<?cs var:toroot ?>training/animation/index.html"
             description=
             "How to add transitional animations to your user interface.">
            Adding Animations
          </a></div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/animation/crossfade.html">
            Crossfading Two Views
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/animation/screen-slide.html">
            Using ViewPager for Screen Slide
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/animation/cardflip.html">
            Displaying Card Flip Animations
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/animation/zoom.html">
            Zooming a View
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/animation/layout.html">
            Animating Layout Changes
          </a>
          </li>
        </ul>
      </li>
    </ul>
  </li>
  <!-- End graphics and animation -->


  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/building-connectivity.html">
      <span class="small">Building Apps with</span><br/>
              Connectivity &amp; the Cloud
      </a>
    </div>
    <ul>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/connect-devices-wirelessly/index.html"
             description=
             "How to find and connect to local devices using Network Service
             Discovery and how to create peer-to-peer connections with Wi-Fi."
             >Connecting Devices Wirelessly</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/connect-devices-wirelessly/nsd.html">
            Using Network Service Discovery
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/connect-devices-wirelessly/wifi-direct.html">
            Creating P2P Connections with Wi-Fi
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/connect-devices-wirelessly/nsd-wifi-direct.html">
            Using Wi-Fi P2P for Service Discovery
          </a>
          </li>
        </ul>
      </li>
       <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/basics/network-ops/index.html"
             description=
             "How to create a network connection, monitor the connection for changes
             in connectivity, and perform transactions with XML data."
            >Performing Network Operations</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/basics/network-ops/connecting.html">
            Connecting to the Network
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/network-ops/managing.html">
            Managing Network Usage
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/network-ops/xml.html">
            Parsing XML Data
          </a>
          </li>
        </ul>
      </li>
      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/efficient-downloads/index.html"
             description=
             "How to minimize your app's impact on the battery when performing downloads
             and other network transactions."
            >Transferring Data Without Draining the Battery</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/efficient-downloads/efficient-network-access.html">
            Optimizing Downloads for Efficient Network Access
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/efficient-downloads/regular_updates.html">
            Minimizing the Effect of Regular Updates
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/efficient-downloads/redundant_redundant.html">
            Redundant Downloads are Redundant
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/efficient-downloads/connectivity_patterns.html">
            Modifying Patterns Based on the Connectivity Type
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/backup/index.html"
             description=
             "How to sync and back up app and user data to remote web services in the
              cloud and how to restore the data back to multiple devices."
            >Backing up App Data to the Cloud</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/backup/autosyncapi.html">
            Configuring Auto Backup
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/backup/backupapi.html">
            Using the Backup API
          </a>
          </li>
        </ul>
        <li><a href="<?cs var:toroot ?>training/cloudsave/conflict-res.html"
           description=
           "How to design a robust conflict resolution strategy for apps that save data to the cloud."
           >Resolving Cloud Save Conflicts
          </a>
        </li>
      </li>
      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/sync-adapters/index.html"
             description="How to transfer data between the cloud and the device using the Android
             sync adapter framework"
             >Transferring Data Using Sync Adapters</a>
        </div>
        <ul>
            <li>
                <a href="<?cs var:toroot ?>training/sync-adapters/creating-authenticator.html">
                Creating a Stub Authenticator
                </a>
            </li>
            <li>
                <a href="<?cs var:toroot ?>training/sync-adapters/creating-stub-provider.html">
                Creating a Stub Content Provider
                </a>
            </li>
            <li>
                <a href="<?cs var:toroot ?>training/sync-adapters/creating-sync-adapter.html">
                Creating a Sync Adapter
                </a>
            </li>
            <li>
                <a href="<?cs var:toroot ?>training/sync-adapters/running-sync-adapter.html">
                Running a Sync Adapter
                </a>
            </li>
        </ul>
      </li>
      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/volley/index.html"
             description="How to perform fast, scalable UI operations over the network using Volley"
             >Transmitting Network Data Using Volley</a>
        </div>
        <ul>
            <li>
                <a href="<?cs var:toroot ?>training/volley/simple.html">
                Sending a Simple Request
                </a>
            </li>
            <li>
                <a href="<?cs var:toroot ?>training/volley/requestqueue.html">
                Setting Up a RequestQueue
                </a>
            </li>
            <li>
                <a href="<?cs var:toroot ?>training/volley/request.html">
                Making a Standard Request
                </a>
            </li>
            <li>
                <a href="<?cs var:toroot ?>training/volley/request-custom.html">
                Implementing a Custom Request
                </a>
            </li>
        </ul>
      </li>
    </ul>
  </li>
  <!-- End connectivity and cloud -->


  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/building-location.html">
      <span class="small">Building Apps with</span><br/>
              Location &amp; Maps
      </a>
    </div>
    <ul>
      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/location/index.html"
             description="How to add location-aware features to your app by getting the user's current location.">
             Making Your App Location-Aware
          </a>
        </div>
        <ul>
          <li>
            <a href="<?cs var:toroot ?>training/location/retrieve-current.html">
            Getting the Last Known Location
            </a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/location/change-location-settings.html">
            Changing Location Settings
            </a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/location/receive-location-updates.html">
            Receiving Location Updates
            </a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/location/display-address.html">
            Displaying a Location Address
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/location/geofencing.html">
            Creating and Monitoring Geofences
          </a>
          </li>
        </ul>
      </li>
      <li class="nav-section">
        <a href="<?cs var:toroot ?>training/maps/index.html"
           description="How to add maps and mapping information to your app.">
           Adding Maps
        </a>
      </li>
    </ul>
  </li>
  <!-- End location and maps -->


  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/building-userinfo.html">
      <span class="small">Building Apps with</span><br/>
              User Info &amp; Sign-In
      </a>
    </div>
    <ul>
      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/contacts-provider/index.html"
             description=
             "How to use Android's central address book, the Contacts Provider, to
             display contacts and their details and modify contact information.">
          Accessing Contacts Data</a>
        </div>
        <ul>
          <li>
                <a href="<?cs var:toroot ?>training/contacts-provider/retrieve-names.html">
                Retrieving a List of Contacts
                </a>
          </li>
          <li>
                <a href="<?cs var:toroot ?>training/contacts-provider/retrieve-details.html">
                Retrieving Details for a Contact
                </a>
          </li>
          <li>
                <a href="<?cs var:toroot ?>training/contacts-provider/modify-data.html">
                Modifying Contacts Using Intents
                </a>
          </li>
          <li>
                <a href="<?cs var:toroot ?>training/contacts-provider/display-contact-badge.html">
                Displaying the Quick Contact Badge
                </a>
          </li>
        </ul>
      </li>
      <li class="nav-section">
        <a href="<?cs var:toroot ?>training/sign-in/index.html"
           description="How to add user sign-in functionality to your app.">
           Adding Sign-In
        </a>
      </li>
    </ul>
  </li>
  <!-- End user info and sign-in -->


  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/building-wearables.html">
      <span class="small">Building Apps for</span><br/>
              Wearables
      </a>
    </div>
    <ul>
      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/wearables/notifications/index.html"
             description="How to build handheld notifications that are synced to
             and look great on wearables."
            >Adding Wearable Features to Notifications</a>
        </div>
        <ul>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/notifications/creating.html">Creating a Notification</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/notifications/voice-input.html">Receiving Voice Input in a Notification</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/notifications/pages.html">Adding Pages to a Notification</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/notifications/stacks.html">Stacking Notifications</a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/wearables/apps/index.html"
             description="How to build apps that run directly on wearables."
            >Creating Wearable Apps</a>
        </div>
        <ul>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/apps/creating.html">Creating and Running a Wearable App</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/apps/layouts.html">Creating Custom Layouts</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/apps/always-on.html">Keeping Your App Visible</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/apps/voice.html">Adding Voice Capabilities</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/apps/packaging.html">Packaging Wearable Apps</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/apps/bt-debugging.html">Debugging over Bluetooth</a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/wearables/ui/index.html"
             description="How to create custom user interfaces for wearable apps."
            >Creating Custom UIs</a>
        </div>
        <ul>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/ui/layouts.html">Defining Layouts</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/ui/cards.html">Creating Cards</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/ui/lists.html">Creating Lists</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/ui/2d-picker.html">Creating a 2D Picker</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/ui/confirm.html">Showing Confirmations</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/ui/exit.html">Exiting Full-Screen Activities</a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/wearables/data-layer/index.html"
             description="How to sync data between handhelds and wearables."
            >Sending and Syncing Data</a>
        </div>
        <ul>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/data-layer/accessing.html">Accessing the Wearable Data Layer</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/data-layer/data-items.html">Syncing Data Items</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/data-layer/assets.html">Transferring Assets</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/data-layer/messages.html">Sending and Receiving Messages</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/data-layer/events.html">Handling Data Layer Events</a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/wearables/watch-faces/index.html"
             description="How to create watch faces for wearables."
            >Creating Watch Faces</a>
        </div>
        <ul>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/watch-faces/designing.html">Designing Watch Faces</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/watch-faces/service.html">Building a Watch Face Service</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/watch-faces/drawing.html">Drawing Watch Faces</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/watch-faces/information.html">Showing Information in Watch Faces</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/watch-faces/interacting.html">Creating Interactive Watch Faces</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/watch-faces/configuration.html">Providing Configuration Activities</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/watch-faces/issues.html">Addressing Common Issues</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/watch-faces/performance.html">Optimizing Performance and Battery Life</a>
          </li>
        </ul>
      </li>

      <li>
        <a href="<?cs var:toroot ?>training/articles/wear-location-detection.html"
           description=
           "How to detect location data on Android Wear devices."
          >Detecting Location</a>
      </li>

      <li>
        <a href="<?cs var:toroot ?>training/articles/wear-permissions.html"
           description=
           "How to request permissions on Android Wear devices."
          >Requesting Permissions</a>
      </li>

      <li>
        <a href="<?cs var:toroot ?>training/wearables/wearable-sounds.html"
           description=
           "How to use the speaker on Android Wear devices."
          >Using the Speaker</a>
      </li>

    </ul>
  </li>
  <!-- End Building for wearables -->


  <!-- Start: Building for TV -->
  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/tv/index.html">
      <span class="small">Building Apps for</span><br/>
              TV
      </a>
    </div>
    <ul>

      <li class="nav-section">
        <div class="nav-section-header">

          <a href="<?cs var:toroot ?>training/tv/start/index.html"
             ja-lang="TV アプリのビルド"
             description="How to start building TV apps or extend your existing app to run on TV
             devices.">
             Building TV Apps</a>
        </div>
        <ul>
          <li>
            <a href="<?cs var:toroot ?>training/tv/start/start.html"
               ja-lang="TV アプリのビルドを開始する">
              Getting Started with TV Apps</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/tv/start/hardware.html"
               ja-lang="TV ハードウェアを処理する">
              Handling TV Hardware</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/tv/start/layouts.html"
               ja-lang="TV 向けレイアウトをビルドする">
              Building TV Layouts</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/tv/start/navigation.html"
               ja-lang="TV 用のナビゲーションを作成する">
              Creating TV Navigation</a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/tv/playback/index.html"
             ja-lang="TV 再生アプリのビルド"
             description="How to build apps that provide media catalogs and play content.">
             Building TV Playback Apps</a>
        </div>
        <ul>
          <li>
            <a href="<?cs var:toroot ?>training/tv/playback/browse.html"
               ja-lang="カタログ ブラウザを作成する">
              Creating a Catalog Browser</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/tv/playback/card.html">
              Providing a Card View</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/tv/playback/details.html"
               ja-lang="詳細ビューをビルドする">
              Building a Details View</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/tv/playback/now-playing.html"
               ja-lang="再生中カードを表示する">
              Displaying a Now Playing Card</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/tv/playback/guided-step.html">
              Adding a Guided Step</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/tv/playback/options.html">
              Enabling Background Playback</a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/tv/discovery/index.html"
             description="How to help users discover content from your app.">
             Helping Users Find Content on TV</a>
        </div>
        <ul>
          <li>
            <a href="<?cs var:toroot ?>training/tv/discovery/recommendations.html">
              Recommending TV Content</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/tv/discovery/searchable.html">
              Making TV Apps Searchable</a>
          <li>
            <a href="<?cs var:toroot ?>training/tv/discovery/in-app-search.html">
              Searching within TV Apps</a>
          </li>
        </ul>
      </li>

      <li>
        <a href="<?cs var:toroot ?>training/tv/games/index.html"
           description="How to build games for TV.">
           Building TV Games</a>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/tv/tif/index.html"
           description="How to build channels for TV.">
           Building TV Channels</a>
        </div>
        <ul>
          <li>
            <a href="<?cs var:toroot ?>training/tv/tif/tvinput.html">
              Developing a TV Input Service</a>
          <li>
            <a href="<?cs var:toroot ?>training/tv/tif/channel.html">
              Working with Channel Data</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/tv/tif/ui.html">
              Managing User Interaction</a>
          </li>
        </ul>
      </li>

      <li>
        <a href="<?cs var:toroot ?>training/tv/publishing/checklist.html"
           description="An itemized list of requirements for TV apps.">
           TV Apps Checklist</a>
      </li>
    </ul>
  </li>
  <!-- End: Building for TV -->


  <!-- Start: Building for Auto -->
  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/auto/index.html">
      <span class="small">Building Apps for</span><br/>
              Auto
      </a>
    </div>
    <ul>
      <li>
        <a href="<?cs var:toroot ?>training/auto/start/index.html"
             description="How to start building or extending apps that work
             with Auto devices.">
             Getting Started with Auto</a>
      </li>
      <li>
        <a href="<?cs var:toroot ?>training/auto/audio/index.html"
             description="How to extend audio apps to play content on Auto devices.">
             Playing Audio for Auto</a>
      </li>
      <li>
        <a href="<?cs var:toroot ?>training/auto/messaging/index.html"
             description="How to extend text messaging apps to work with Auto devices.">
             Messaging for Auto</a>
      </li>
    </ul>
  </li>
  <!-- End: Building for Auto -->


  <!-- Start: Building for Work -->
  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/enterprise/index.html">
      <span class="small">Building Apps for</span><br/>
              Work
      </a>
    </div>
    <ul>
      <li><a href="<?cs var:toroot ?>training/enterprise/app-compatibility.html">
        Ensuring Compatibility with Managed Profiles
      </a>
      </li>
      <li><a href="<?cs var:toroot ?>training/enterprise/app-restrictions.html">
        Implementing App Restrictions
      </a>
      </li>
      <li><a href="<?cs var:toroot ?>training/enterprise/work-policy-ctrl.html">
        Building a Device Policy Controller
      </a>
      </li>
      <li><a href="<?cs var:toroot ?>training/enterprise/cosu.html">
        Configuring Corporate-Owned, Single-Use Devices
      </a>
      </li>
    </ul>
  </li>
  <!-- End: Building for Work -->


  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/best-ux.html">
      <span class="small">Best Practices for</span><br/>
              Interaction &amp; Engagement
      </a>
    </div>
    <ul>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/design-navigation/index.html"
             description=
             "How to plan your app's screen hierarchy and forms of navigation so users can
             effectively and intuitively traverse your app content using various navigation
             patterns."
            >Designing Effective Navigation</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/design-navigation/screen-planning.html">
            Planning Screens and Their Relationships
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/design-navigation/multiple-sizes.html">
            Planning for Multiple Touchscreen Sizes
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/design-navigation/descendant-lateral.html">
            Providing Descendant and Lateral Navigation
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/design-navigation/ancestral-temporal.html">
            Providing Ancestral and Temporal Navigation
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/design-navigation/wireframing.html">
            Putting it All Together: Wireframing the Example App
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/implementing-navigation/index.html"
             description=
             "How to implement various navigation patterns such as swipe views,
             a navigation drawer, and up navigation."
            >Implementing Effective Navigation</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/implementing-navigation/lateral.html">
            Creating Swipe Views with Tabs
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/implementing-navigation/nav-drawer.html">
            Creating a Navigation Drawer
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/implementing-navigation/ancestral.html">
            Providing Up Navigation
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/implementing-navigation/temporal.html">
            Providing Proper Back Navigation
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/implementing-navigation/descendant.html">
            Implementing Descendant Navigation
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
          <div class="nav-section-header">
              <a href="<?cs var:toroot ?>training/notify-user/index.html"
                 description=
                 "How to display messages called notifications outside of
                 your application's UI."
               >Notifying the User</a>
          </div>
          <ul>
              <li>
                  <a href="<?cs var:toroot ?>training/notify-user/build-notification.html">
                  Building a Notification
                  </a>
              </li>
              <li>
                  <a href="<?cs var:toroot ?>training/notify-user/navigation.html">
                  Preserving Navigation when Starting an Activity
                  </a>
              </li>
              <li>
                  <a href="<?cs var:toroot ?>training/notify-user/managing.html">
                  Updating Notifications
                  </a>
              </li>
              <li>
                  <a href="<?cs var:toroot ?>training/notify-user/expanded.html">
                  Using Big View Styles
                  </a>
              </li>
              <li>
                  <a href="<?cs var:toroot ?>training/notify-user/display-progress.html">
                  Displaying Progress in a Notification
                  </a>
              </li>
          </ul>
      </li>


      <li class="nav-section">
        <div class="nav-section-header">
            <a href="<?cs var:toroot ?>training/swipe/index.html"
            description=
            "How to modify your app's layout to support manual content updates triggered by the
             swipe-to-refresh gesture."
            >Supporting Swipe-to-Refresh</a>
        </div>
        <ul>
            <li>
                <a href="<?cs var:toroot ?>training/swipe/add-swipe-interface.html"
                >Adding Swipe-to-Refresh To Your App</a></li>
            <li>
                <a href="<?cs var:toroot ?>training/swipe/respond-refresh-request.html"
                >Responding to a Refresh Gesture</a>
            </li>
        </ul>
      </li>


      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/search/index.html"
             description=
             "How to properly add a search interface to your app and create a searchable database."
            >Adding Search Functionality</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/search/setup.html">
            Setting up the Search Interface
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/search/search.html">
            Storing and Searching for Data
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/search/backward-compat.html">
            Remaining Backward Compatible
          </a>
          </li>
        </ul>
      </li>

     <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/app-indexing/index.html"
             description=
             "How to enable deep linking and indexing of your application
content so that users can open this content directly from their mobile search
results."
            >Making Your App Content Searchable by Google</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/app-indexing/deep-linking.html">
            Enabling Deep Links for App Content
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/app-indexing/enabling-app-indexing.html">
            Specifying App Content for Indexing
          </a>
          </li>
        </ul>
  </li>

      <li>
        <a href="<?cs var:toroot ?>training/articles/assistant.html"
           description=
           "Support contextually relevant actions through the Assist API."
          >Optimizing Content for the Assistant</a>
      </li>
       <li class="nav-section">
        <div class="nav-section">
          <a href="<?cs var:toroot ?>training/app-links/index.html"
             description=
             "How to enable the system to handle web requests by taking the user directly
             to your app instead of your website."
            >Handling App Links</a>
        </div>
      </li>
  <!-- End Interaction and Engagement -->

</ul>

  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/best-ui.html">
      <span class="small">Best Practices for</span><br/>
              User Interface
      </a>
    </div>
    <ul>


      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/multiscreen/index.html"
             zh-cn-lang="针对多种屏幕进行设计"
             ja-lang="複数画面のデザイン"
             es-lang="Cómo diseñar aplicaciones para varias pantallas"
             description=
             "How to build a user interface that's flexible enough to
             fit perfectly on any screen and how to create different interaction
             patterns that are optimized for different screen sizes."
            >Designing for Multiple Screens</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/multiscreen/screensizes.html"
            zh-cn-lang="支持各种屏幕尺寸"
            ko-lang="다양한 화면 크기 지원"
            ja-lang="さまざまな画面サイズのサポート"
            es-lang="Cómo admitir varios tamaños de pantalla"
            >Supporting Different Screen Sizes</a>
          </li>
          <li><a href="<?cs var:toroot ?>training/multiscreen/screendensities.html"
            zh-cn-lang="支持各种屏幕密度"
            ja-lang="さまざまな画面密度のサポート"
            es-lang="Cómo admitir varias densidades de pantalla"
            >Supporting Different Screen Densities</a>
          </li>
          <li><a href="<?cs var:toroot ?>training/multiscreen/adaptui.html"
            zh-cn-lang="实施自适应用户界面流程"
            ja-lang="順応性のある UI フローの実装"
            es-lang="Cómo implementar interfaces de usuario adaptables"
            >Implementing Adaptive UI Flows</a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/appbar/index.html"
             description=
             "How to use the support library's toolbar widget to implement an
             app bar that displays properly on a wide range of devices."
            >Adding the App Bar</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/appbar/setting-up.html"
            >Setting Up the App Bar</a>
          </li>
          <li><a href="<?cs var:toroot ?>training/appbar/actions.html"
            >Adding and Handling Actions</a>
          </li>
          <li><a href="<?cs var:toroot ?>training/appbar/up-action.html"
            >Adding an Up Action</a>
          </li>
          <li><a href="<?cs var:toroot ?>training/appbar/action-views.html"
            >Action Views and Action Providers</a>
          </li>
        </ul>
      </li>

            <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/snackbar/index.html"
             description=
             "How to use the support library's Snackbar widget to display a
             brief pop-up message."
            >Showing Pop-Up Messages</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/snackbar/showing.html"
            >Building and Displaying a Pop-Up Message</a>
          </li>
          <li><a href="<?cs var:toroot ?>training/snackbar/action.html"
            >Adding an Action to a Message</a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/custom-views/index.html"
             description=
             "How to build custom UI widgets that are interactive and smooth."
            >Creating Custom Views</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/custom-views/create-view.html">
            Creating a Custom View Class
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/custom-views/custom-drawing.html">
            Implementing Custom Drawing
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/custom-views/making-interactive.html">
            Making the View Interactive
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/custom-views/optimizing-view.html">
            Optimizing the View
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/backward-compatible-ui/index.html"
             description=
             "How to use UI components and other APIs from the more recent versions of Android
             while remaining compatible with older versions of the platform."
            >Creating Backward-Compatible UIs</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/backward-compatible-ui/abstracting.html">
            Abstracting the New APIs
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/backward-compatible-ui/new-implementation.html">
            Proxying to the New APIs
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/backward-compatible-ui/older-implementation.html">
            Creating an Implementation with Older APIs
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/backward-compatible-ui/using-component.html">
            Using the Version-Aware Component
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/accessibility/index.html"
             description=
             "How to make your app accessible to users with vision
             impairment or other physical disabilities."
            >Implementing Accessibility</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/accessibility/accessible-app.html">
            Developing Accessible Applications
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/accessibility/service.html">
            Developing Accessibility Services
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/accessibility/testing.html">
            Accessibility Testing Checklist
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/system-ui/index.html"
             description=
             "How to hide and show status and navigation bars across different versions of Android,
              while managing the display of other screen components."
            >Managing the System UI</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/system-ui/dim.html">
            Dimming the System Bars
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/system-ui/status.html">
            Hiding the Status Bar
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/system-ui/navigation.html">
            Hiding the Navigation Bar
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/system-ui/immersive.html">
            Using Immersive Full-Screen Mode
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/system-ui/visibility.html">
            Responding to UI Visibility Changes
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/material/index.html"
             description=
             "How to implement material design on Android."
            zh-cn-lang="面向开发者的材料设计"
            zh-tw-lang="開發人員材料設計"
            ja-lang="マテリアル デザインでのアプリ作成"
            es-lang="Crear aplicaciones con Material Design"
            pt-br-lang="Material Design para desenvolvedores"
            ko-lang="개발자를 위한 머티리얼 디자인"
            ru-lang="Создание приложений с помощью Material Design"
            in-lang="Desain Bahan untuk Pengembang"
            vi-lang="Material Design cho Nhà phát triển"
            >Creating Apps with Material Design</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/material/get-started.html"
            zh-cn-lang="入门指南"
            zh-tw-lang="開始使用"
            ja-lang="スタート ガイド"
            es-lang="Comencemos"
            pt-br-lang="Como iniciar"
            ko-lang="시작하기"
            ru-lang="Начало работы"
            in-lang="Memulai"
            vi-lang="Bắt đầu"
            >
            Getting Started
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/material/theme.html"
            zh-cn-lang="使用材料主题"
            zh-tw-lang="使用材料設計風格"
            ja-lang="マテリアル テーマの使用"
            es-lang="Usar el tema Material"
            pt-br-lang="Como usar o tema do Material"
            ko-lang="머티어리얼 테마 사용"
            ru-lang="Использование темы Material Design"
            in-lang="Menggunakan Tema Bahan"
            vi-lang="Sử dụng Chủ đề Material"
            >
            Using the Material Theme
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/material/lists-cards.html"
            zh-cn-lang="创建列表与卡片"
            zh-tw-lang="建立清單和卡片"
            ja-lang="リストとカードの作成"
            es-lang="Crear listas y tarjetas"
            pt-br-lang="Como criar listas e cartões"
            ko-lang="목록 및 카드 생성"
            ru-lang="Создание списков и подсказок"
            in-lang="Membuat Daftar dan Kartu"
            vi-lang="Tạo Danh sách và Thẻ"
            >
            Creating Lists and Cards
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/material/shadows-clipping.html"
            zh-cn-lang="定义阴影与裁剪视图"
            zh-tw-lang="定義陰影和裁剪檢視"
            ja-lang="シャドウとクリッピング ビューの定義"
            es-lang="Definir vistas de recorte y sombras"
            pt-br-lang="Como definir sombras e recortar visualizações"
            ko-lang="그림자 정의 및 뷰 클리핑"
            ru-lang="Определение теней и обрезка представлений"
            in-lang="Mendefinisikan Bayangan dan Memangkas Tampilan"
            vi-lang="Định nghĩa Đổ bóng và Dạng xem Cắt hình"
            >
            Defining Shadows and Clipping Views
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/material/drawables.html"
            zh-cn-lang="使用 Drawables"
            zh-tw-lang="使用可繪項目"
            ja-lang="ドローアブルの使用"
            es-lang="Trabajar con interfaces dibujables"
            pt-br-lang="Como trabalhar com desenháveis"
            ko-lang="Drawable 사용"
            ru-lang="Работа с элементами дизайна"
            in-lang="Bekerja dengan Drawable"
            vi-lang="Làm việc với Nội dung vẽ được"
            >
            Working with Drawables
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/material/animations.html"
            zh-cn-lang="定义定制动画"
            zh-tw-lang="定義自訂動畫"
            ja-lang="カスタム アニメーションの定義"
            es-lang="Definir animaciones personalizadas"
            pt-br-lang="Como definir animações personalizadas"
            ko-lang="사용자지정 애니메이션 정의"
            ru-lang="Определение настраиваемой анимации"
            in-lang="Mendefinisikan Animasi Custom"
            vi-lang="Định nghĩa Hoạt hình Tùy chỉnh"
            >
            Defining Custom Animations
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/material/compatibility.html"
            zh-cn-lang="维护兼容性"
            zh-tw-lang="維持相容性"
            ja-lang="互換性の維持"
            es-lang="Mantener la compatibilidad"
            pt-br-lang="Como manter a compatibilidade"
            ko-lang="호환성 유지"
            ru-lang="Обеспечение совместимости"
            in-lang="Mempertahankan Kompatibilitas"
            vi-lang="Duy trì Tính tương thích"
            >
            Maintaining Compatibility
          </a>
          </li>
        </ul>
      </li>

    </ul>
  </li>
  <!-- End User Interface -->




  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/best-user-input.html">
      <span class="small">Best Practices for</span><br/>
              User Input
      </a>
    </div>
    <ul>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/gestures/index.html"
             description=
             "How to write apps that allow users to interact with the touch screen via touch gestures."
            >Using Touch Gestures</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/gestures/detector.html">
            Detecting Common Gestures
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/gestures/movement.html">
            Tracking Movement
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/gestures/scroll.html">
            Animating a Scroll Gesture
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/gestures/multi.html">
            Handling Multi-Touch Gestures
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/gestures/scale.html">
            Dragging and Scaling
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/gestures/viewgroup.html">
            Managing Touch Events in a ViewGroup
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/keyboard-input/index.html"
             description=
             "How to specify the appearance and behaviors of soft input methods (such
             as on-screen keyboards) and how to optimize the experience with
             hardware keyboards."
            >Handling Keyboard Input</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/keyboard-input/style.html">
            Specifying the Input Method Type
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/keyboard-input/visibility.html">
            Handling Input Method Visibility
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/keyboard-input/navigation.html">
            Supporting Keyboard Navigation
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/keyboard-input/commands.html">
            Handling Keyboard Actions
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/game-controllers/index.html"
             description=
             "How to write apps that support game controllers."
            >Supporting Game Controllers</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/game-controllers/controller-input.html">
            Handling Controller Actions
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/game-controllers/compatibility.html">
            Supporting Controllers Across Android Versions
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/game-controllers/multiple-controllers.html">
            Supporting Multiple Game Controllers
          </a>
          </li>
        </ul>
      </li>
    </ul>
  </li> <!-- end of User Input -->

  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/best-background.html">
      <span class="small">Best Practices for</span><br/>
              Background Jobs
      </a>
    </div>
    <ul>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/run-background-service/index.html"
             description=
             "How to improve UI performance and responsiveness by sending work to a
             Service running in the background"
            >Running in a Background Service</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/run-background-service/create-service.html">
            Creating a Background Service
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/run-background-service/send-request.html">
            Sending Work Requests to the Background Service
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/run-background-service/report-status.html">
            Reporting Work Status
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/load-data-background/index.html"
             description="How to use CursorLoader to query data without
             affecting UI responsiveness."
            >Loading Data in the Background</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/load-data-background/setup-loader.html">
            Running a Query with a CursorLoader</a>
          </li>
          <li><a href="<?cs var:toroot ?>training/load-data-background/handle-results.html">
            Handling the Results</a>
          </li>
        </ul>
      </li>

       <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/scheduling/index.html"
             description="How to use repeating alarms and wake locks
             to run background jobs."
            >Managing Device Awake State</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/scheduling/wakelock.html">
            Keeping the Device Awake</a>
          </li>
          <li><a href="<?cs var:toroot ?>training/scheduling/alarms.html">
            Scheduling Repeating Alarms</a>
          </li>
        </ul>
      </li>
    </ul>
  </li> <!-- end of Background Jobs -->

  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/best-performance.html">
      <span class="small">Best Practices for</span><br/>
              Performance
      </a>
    </div>
    <ul>
      <li>
        <a href="<?cs var:toroot ?>training/articles/memory.html"
          description=
          "How to keep your app's memory footprint small in order to improve performance
          on a variety of mobile devices."
          >Managing Your App's Memory</a>
      </li>
      <li>
        <a href="<?cs var:toroot ?>training/articles/perf-tips.html"
           description=
           "How to optimize your app's performance in various ways to improve its
           responsiveness and battery efficiency."
          >Performance Tips</a>
      </li>
      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/improving-layouts/index.html"
             description=
             "How to identify problems in your app's layout performance and improve the UI
             responsiveness."
            >Improving Layout Performance</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/improving-layouts/optimizing-layout.html">
            Optimizing Layout Hierarchies
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/improving-layouts/reusing-layouts.html">
            Re-using Layouts with &lt;include/&gt;
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/improving-layouts/loading-ondemand.html">
            Loading Views On Demand
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/improving-layouts/smooth-scrolling.html">
            Making ListView Scrolling Smooth
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/monitoring-device-state/index.html"
             zh-cn-lang="优化电池使用时间"
             ja-lang="電池消費量の最適化"
             es-lang="Cómo optimizar la duración de la batería"
             description=
             "How to minimize the amount of power your app requires by adapting to current
             power conditions and performing power-hungry tasks at proper intervals."
            >Optimizing Battery Life
            </a>
        </div>
        <ul>

          <li class="nav-section">
            <div class="nav-section-header">
              <a href="<?cs var:toroot ?>training/performance/battery/network/index.html">
                Reducing Network Battery Drain
              </a>
            </div>
            <ul>
              <li><a href="<?cs var:toroot ?>training/performance/battery/network/gather-data.html">
                Collecting Network Traffic Data
              </a>
              </li>
              <li><a href="<?cs var:toroot ?>training/performance/battery/network/analyze-data.html">
                Analyzing Network Traffic Data
              </a>
              </li>
              <li><a href="<?cs var:toroot ?>training/performance/battery/network/action-user-traffic.html">
                Optimizing User-Initiated Network Use
              </a>
              </li>
              <li><a href="<?cs var:toroot ?>training/performance/battery/network/action-app-traffic.html">
                Optimizing App-Initiated Network Use
              </a>
              </li>
              <li><a href="<?cs var:toroot ?>training/performance/battery/network/action-server-traffic.html">
                Optimizing Server-Initiated Network Use
              </a>
              </li>
              <li><a href="<?cs var:toroot ?>training/performance/battery/network/action-any-traffic.html">
                Optimizing General Network Use
              </a>
              </li>
            </ul>
          </li> <!-- End of Reducing Network Battery Drain -->

          <li><a href="<?cs var:toroot ?>training/monitoring-device-state/doze-standby.html"
            >Optimizing for Doze and App Standby</a>
          </li>
          <li><a href="<?cs var:toroot ?>training/monitoring-device-state/battery-monitoring.html"
            zh-cn-lang="监控电池电量和充电状态"
            ja-lang="電池残量と充電状態の監視"
            es-lang="Cómo controlar el nivel de batería y el estado de carga"
            >Monitoring the Battery Level and Charging State</a>
          </li>
          <li><a href="<?cs var:toroot ?>training/monitoring-device-state/docking-monitoring.html"
            zh-cn-lang="确定和监控基座对接状态和类型"
            ja-lang="ホルダーの装着状態とタイプの特定と監視"
            es-lang="Cómo determinar y controlar el tipo de conector y el estado de la conexión"
            >Determining and Monitoring the Docking State and Type</a>
          </li>
          <li><a href="<?cs var:toroot ?>training/monitoring-device-state/connectivity-monitoring.html"
            zh-cn-lang="确定和监控网络连接状态"
            ja-lang="接続状態の特定と監視"
            es-lang="Cómo determinar y controlar el estado de la conectividad"
            >Determining and Monitoring the Connectivity Status</a>
          </li>
          <li><a href="<?cs var:toroot ?>training/monitoring-device-state/manifest-receivers.html"
            zh-cn-lang="根据需要操作广播接收器"
            ja-lang="オンデマンドでのブロードキャスト レシーバ操作"
            es-lang="Cómo manipular los receptores de emisión bajo demanda"
            >Manipulating Broadcast Receivers On Demand</a>
          </li>
        </ul>
      </li>
      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/multiple-threads/index.html"
             description=
             "How to improve the performance and scalability of long-running operations by
              dispatching work to multiple threads.">
             Sending Operations to Multiple Threads</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/multiple-threads/define-runnable.html">
            Specifying the Code to Run on a Thread
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/multiple-threads/create-threadpool.html">
            Creating a Manager for Multiple Threads
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/multiple-threads/run-code.html">
            Running Code on a Thread Pool Thread
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/multiple-threads/communicate-ui.html">
            Communicating with the UI Thread
          </a>
          </li>
        </ul>
      </li>
      <li>
        <a href="<?cs var:toroot ?>training/articles/perf-anr.html"
           description=
           "How to keep your app responsive to user interaction so the UI does not lock-up and
           display an &quot;Application Not Responding&quot; dialog."
          >Keeping Your App Responsive</a>
      </li>
      <li>
        <a href="<?cs var:toroot ?>training/articles/perf-jni.html"
           description=
           "How to efficiently use the Java Native Interface with the Android NDK."
          >JNI Tips</a>
      </li>
      <li>
        <a href="<?cs var:toroot ?>training/articles/smp.html"
           description=
           "Tips for coding Android apps on symmetric multiprocessor systems."
          >SMP Primer for Android</a>
      </li>
    </ul>
  </li> <!-- end of Performance -->

  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/best-security.html">
      <span class="small">Best Practices for</span><br/>
              Security &amp; Privacy
      </a>
    </div>
    <ul>
      <li>
        <a href="<?cs var:toroot ?>training/articles/security-tips.html"
           description=
           "How to perform various tasks and keep your app's data and your user's data secure."
          >Security Tips</a>
      </li>

      <li>
        <a href="<?cs var:toroot ?>training/articles/security-ssl.html"
           description=
           "How to ensure that your app is secure when performing network transactions."
          >Security with HTTPS and SSL</a>
      </li>

      <li>
        <a href="<?cs var:toroot ?>training/articles/security-gms-provider.html"
           description=
           "How to use and update Google Play services security provider, to
           protect against SSL exploits."
          >Updating Your Security Provider to Protect Against SSL Exploits</a>
      </li>

      <li>
        <a href="<?cs var:toroot ?>training/safetynet/index.html"
           description=
           "How to use the SafetyNet service to analyze a device where your app is running
            and get information about its compatibility with your app."
          >Checking Device Compatibility with SafetyNet</a>
      </li>

      <li>
        <a href="<?cs var:toroot ?>training/enterprise/device-management-policy.html"
            description="How to create an application that enforces security policies on devices."
            >Enhancing Security with Device Management Policies</a>
      </li>
    </ul>
  </li>
  <!-- End security and user info -->

  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/best-permissions-ids.html">
      <span class="small">Best Practices for</span><br/>
              Permissions &amp; Identifiers
      </a>
    </div>
    <ul>
      <li>
        <a href="<?cs var:toroot ?>training/articles/user-data-overview.html"
           description=
           "Overview of app permissions on Android and how they affect your users."
          >Permissions and User Data</a>
      </li>
      <li>
        <a href="<?cs var:toroot ?>training/articles/user-data-permissions.html"
           description=
           "How to manage permissions the right way for users."
          >Best Practices for App Permissions</a>
      </li>
      <li>
        <a href="<?cs var:toroot ?>training/articles/user-data-ids.html"
           description=
           "Unique identifiers available and how to choose the right one for your use case."
          >Best Practices for Unique Identifiers</a>
      </li>
    </ul>
  </li>
  <!-- End Permissions and identifiers -->

  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/testing/index.html">
      <span class="small">Best Practices for</span><br/>
              Testing
      </a>
    </div>
    <ul>
      <li>
      <a href="<?cs var:toroot ?>training/testing/start/index.html"
         description="How to get started with testing your Android applications.">
            Getting Started with Testing
          </a>
      </li>
      <li class="nav-section">
      <div class="nav-section-header"><a href="<?cs var:toroot ?>training/testing/unit-testing/index.html"
         description="How to build effective unit tests for Android apps.">
            Building Effective Unit Tests
          </a></div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/testing/unit-testing/local-unit-tests.html">
            <span class="en">Building Local Unit Tests</span>
            </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/testing/unit-testing/instrumented-unit-tests.html">
            <span class="en">Building Instrumented Unit Tests</span>
            </a>
          </li>
        </ul>
      </li>
      <li class="nav-section">
      <div class="nav-section-header"><a href="<?cs var:toroot ?>training/testing/ui-testing/index.html"
         description="How to automate your user interface tests for Android apps.">
            Automating UI Tests
          </a></div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/testing/ui-testing/espresso-testing.html">
            <span class="en">Testing UI for a Single App</span>
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/testing/ui-testing/uiautomator-testing.html">
            <span class="en">Testing UI for Multiple Apps</span>
          </a>
          </li>
        </ul>
      </li>
      <li class="nav-section">
      <div class="nav-section-header"><a href="<?cs var:toroot ?>training/testing/integration-testing/index.html"
         description="How to build effective integration tests for Android apps.">
            Testing App Component Integrations
          </a></div>
        <ul>
         <li><a href="<?cs var:toroot ?>training/testing/integration-testing/service-testing.html">
           <span class="en">Testing Your Service</span></a></li>
         <li><a href="<?cs var:toroot ?>training/testing/integration-testing/content-provider-testing.html">
           <span class="en">Testing Your Content Provider</span></a></li>
        </ul>
      </li>
      <li><a href="<?cs var:toroot ?>training/testing/performance.html"
          description="How to automate UI performance testing.">Testing Display Performance</a>
      </li>
    </ul>
  </li>
  <!-- End best Testing -->

  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/distribute.html">
      <span class="small">Using Google Play to</span><br/>
              Distribute &amp; Monetize
      </a>
    </div>
    <ul>
      <li class="nav-section">
      <div class="nav-section-header"><a href="<?cs var:toroot ?>training/in-app-billing/index.html"
         description="How to sell in-app products from your application using In-app Billing.">
            Selling In-app Products
          </a></div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/in-app-billing/preparing-iab-app.html">
            <span class="en">Preparing Your App</span>
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/in-app-billing/list-iab-products.html">
            <span class="en">Establishing Products for Sale</span>
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/in-app-billing/purchase-iab-products.html">
            <span class="en">Purchasing Products</span>
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/in-app-billing/test-iab-app.html">
            <span class="en">Testing Your App</span>
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/multiple-apks/index.html"
             description=
             "How to publish your app on Google Play with separate APKs that target
             different devices, while using a single app listing."
            >Maintaining Multiple APKs</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/multiple-apks/api.html">
            Creating Multiple APKs for Different API Levels
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/multiple-apks/screensize.html">
            Creating Multiple APKs for Different Screen Sizes
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/multiple-apks/texture.html">
            Creating Multiple APKs for Different GL Textures
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/multiple-apks/multiple.html">
            Creating Multiple APKs with 2+ Dimensions
          </a>
          </li>
        </ul>
      </li>
    </ul>
  </li>
  <!-- End best Publishing -->

</ul><!-- nav -->
<script type="text/javascript">
<!--
    buildToggleLists();
    changeNavLang(getLangPref());
//-->
</script>
