/* Metadata extensions for the specified language
   as well as resource collection definitions.

   'Extras' defined in this file are metadata represendations of
   resources that are outside the autogenerated local resource lists,
   or representations that override the default representations.
   (Overriding the default is not recommended)

   'Collections' are a predefined set of resources that pages can
   display by referencing the collection name in a data query. Urls
   listed in a collection must map exactly to urls in local metadata
   resources (either default or extras).

   'Carousel overrides' are extras that override a default resource
   for the purpose of customizing the text and display in carousels/heros.
   Urls referenced must map exactly to urls in local metadata
   resources (either default or extras).

   'Static search results' are metadata objects that are returned in
   the search results page when the user enters the object's keyword.

   The extras, collections, carousel overrides, and static search results
   listed here are referenced from dynamic content queries, matched by
   url string.
  */

METADATA['en'].extras = METADATA['en'].extras.concat([
 /* TODO Remove standard resources from here, such as below
 */
  {
    "title":"Meet Android Studio",
    "summary":"The basics of working with Android Studio, from projects to build and performance.",
    "url":"studio/intro/index.html",
    "image":"studio/images/intro/main-window_2-1_2x.png",
    "type":"studio",
    "keywords": ["studio","sdk","tools","firstapp"],
    "tags": ["studio","sdk","tools","firstapp"],
    "lang":"en"
  },
  {
    "title":"Configure Your Build",
    "summary":"Learn about Android Studio's build configuration.",
    "url":"studio/build/index.html",
    "image":"images/tools/studio/build-process_2x.png",
    "type":"studio",
    "keywords": ["studio","configuration"],
    "tags": ["studio","configuration"],
    "lang":"en"
  },
  {
    "title":"Android Studio Features",
    "summary":"A quick look at key Android Studio features.",
    "url":"studio/features.html",
    "image":"images/cards/card-studio-modules_crop_2x.png",
    "type":"studio",
    "keywords": ["studio","tools","sdk"],
    "tags": ["studio"],
    "lang":"en"
  },
  {
    "title":"Using Code Templates",
    "summary":"Quickly create Android app projects with various UI or functional components.",
    "url":"studio/projects/templates.html",
    "image":"images/cards/card-using-code-templates_16x9_2x.png",
    "type":"studio",
    "keywords": ["studio","templates","firstapp"],
    "tags": ["studio","templates","firstapp"],
    "lang":"en"
  },
  {
    "title":"Publishing Overview",
    "summary":"Start here for an overview of publishing options for Android apps.",
    "url":"studio/publish/index.html",
    "image":"images/publishing/publishing_overview.png",
    "type":"studio",
    "keywords": [],
    "tags": [],
    "lang":"en"
  },
  {
    "title":"Preparing for Release",
    "summary":"Developer documentation on how to build the signed, release-ready APK. This process is the same for all Android apps.",
    "url":"studio/publish/preparing.html",
    "image":"images/publishing/publishing_overview_prep.png",
    "type":"studio",
    "keywords": [],
    "tags": [],
    "lang":"en"
  },
  {
    "title":"Network Monitor",
    "summary":"Use the Network Monitor to analyze network requests, including how and when your app transfers data. Preserve battery life by optimizing network use.",
    "url":"studio/profile/am-network.html",
    "image":"images/tools/thumbnails/am-networkmon.png",
    "type":"studio",
    "keywords": ["monitor"],
    "tags": ["monitor"],
    "lang":"en"
  },
  {
    "title":"Memory Monitor",
    "summary":"Use the Memory Monitor to evaluate memory usage and find deallocated objects, locate memory leaks, and track the amount of memory the connected device is using.",
    "url":"studio/profile/am-memory.html",
    "image":"images/tools/thumbnails/am-memorymon.png",
    "type":"studio",
    "keywords": ["monitor"],
    "tags": ["monitor"],
    "lang":"en"
  },
  {
    "title":"UI&#47;Application Exerciser Monkey",
    "summary":"The Monkey is a program that runs on your emulator or device and generates pseudo-random streams of user events such as clicks, touches, or gestures, as well as a number of system-level events. You can use the Monkey to stress-test applications that you\u2026",
    "url":"studio/test/monkey.html",
    "type":"studio",
    "keywords": [],
    "tags": [],
    "lang":"en"
  },
  {
    "title":"CPU Monitor",
    "summary":"Use the CPU Monitor to display CPU usage in real time and the percentage of total CPU time (including all cores) used in user and kernel mode.",
    "url":"studio/profile/am-cpu.html",
    "image":"images/tools/thumbnails/am-cpumon.png",
    "type":"studio",
    "keywords": ["monitor"],
    "tags": ["monitor"],
    "lang":"en"
  },
  {
    "title":"Shrink Your Code and Resources",
    "summary":"Make your APK file smaller and more secure by shrinking your code and resources.",
    "url":"studio/build/shrink-code.html",
    "type":"studio",
    "keywords": [],
    "tags": [],
    "lang":"en"
  },
  {
    "title":"logcat Monitor",
    "summary":"Use the logcat Monitor to view system and user-defined log messages. You can filter the messages to display just the items that interest you.",
    "url":"studio/debug/am-logcat.html",
    "image":"images/tools/thumbnails/am-logcatmon2.png",
    "type":"studio",
    "keywords": ["monitor"],
    "tags": ["monitor"],
    "lang":"en"
  },
  {
    "title":"GPU Monitor",
    "summary":"Use the GPU Monitor for a visual representation of how much time it takes to render the frames of a UI window. Use this information to optimize the code that displays graphics and conserve memory.",
    "url":"studio/profile/am-gpu.html",
    "image":"images/tools/thumbnails/am-gpumon.png",
    "type":"studio",
    "keywords": ["monitor"],
    "tags": ["monitor"],
    "lang":"en"
  },
  {
    "title":"GPU Debugger",
    "summary":"Use the GPU Debugger to analyze and debug your OpenGL ES apps. Inspect the GPU state and understand what caused a specific rendering outcome.",
    "url":"studio/debug/am-gpu-debugger.html",
    "image":"images/tools/thumbnails/am-gpu-debugger_2-2_2x.png",
    "type":"tools",
    "keywords": ["android","performance","profiling","tools","monitor","debug"],
    "tags": ["android","performance","profiling","tools","monitor","debug"],
    "lang":"en"
  },
  {
    "title":"HPROF Viewer and Analyzer",
    "summary":"Use the Memory Monitor to dump the Java heap to an HPROF file. The HPROF Viewer displays classes, instances of each class, and a reference tree to help you track memory usage and find memory leaks.",
    "url":"studio/profile/am-hprof.html",
    "image":"images/tools/thumbnails/am_hprofviewer.png",
    "type":"tools",
    "keywords": ["android","performance","profiling","tools","monitor"],
    "tags": ["android","performance","profiling","tools","monitor"],
    "lang":"en"
  },
  {
    "title":"Video Capture",
    "summary":"Use the Video tool to make a video of the display on a hardware device.",
    "url":"studio/debug/am-video.html",
    "image":"images/tools/thumbnails/am_video.png",
    "type":"tools",
    "keywords": ["android","performance","profiling","tools","monitor"],
    "tags": ["android","performance","profiling","tools","monitor"],
    "lang":"en"
  },
  {
    "title":"Screen Capture",
    "summary":"Use the Screen Capture tool to take a screenshot of the display on a hardware device or the emulator. Optionally display the screenshot within a graphic of a device.",
    "url":"studio/debug/am-screenshot.html",
    "image":"images/tools/thumbnails/am_screenshot.png",
    "type":"tools",
    "keywords": ["android","performance","profiling","tools","monitor"],
    "tags": ["android","performance","profiling","tools","monitor"],
    "lang":"en"
  },
  {
    "title":"Allocation Tracker",
    "summary":"Use the Memory Monitor to capture allocation data about your app. The Allocation Tracker displays each method responsible for an allocation, as well as the allocation size and number of instances.",
    "url":"studio/profile/am-allocation.html",
    "image":"images/tools/thumbnails/am_alloctracker.png",
    "type":"tools",
    "keywords": ["android","performance","profiling","tools","monitor"],
    "tags": ["android","performance","profiling","tools","monitor"],
    "lang":"en"
  },
  {
    "title":"Method Trace",
    "summary":"Use the CPU Monitor to perform a method trace on your app. View call stack and timing information in the method trace display.",
    "url":"studio/profile/am-methodtrace.html",
    "image":"images/tools/thumbnails/am_methodtrace.png",
    "type":"tools",
    "keywords": ["android","performance","profiling","tools","monitor"],
    "tags": ["android","performance","profiling","tools","monitor"],
    "lang":"en"
  },
  {
    "title":"System Information",
    "summary":"Use the System Information tool to capture <code>dumpsys</code> information about your app. View activity manager, package, memory usage, and graphics state information.",
    "url":"studio/profile/am-sysinfo.html",
    "image":"images/tools/thumbnails/am_sysinfo.png",
    "type":"tools",
    "keywords": ["android","performance","profiling","tools","monitor"],
    "tags": ["android","performance","profiling","tools","monitor"],
    "lang":"en"
  },
  {
    "title":"monkeyrunner",
    "summary":"The monkeyrunner tool provides an API for writing programs that control an Android device or emulator from outside of Android code. With monkeyrunner, you can write a Python program that installs an Android application or test package, runs it, sends \u2026",
    "url":"studio/test/monkeyrunner/index.html",
    "type":"studio",
    "keywords": [],
    "tags": [],
    "lang":"en"
  },
  {
    "title":"Testing from the Command-Line",
    "summary":"This document describes how to create and run tests directly from the command line. This document assumes that you already know how to create a Android application in your programming environment. You can run tests from the command-line, either with Gradle\u2026",
    "url":"studio/test/command-line.html",
    "type":"studio",
    "keywords": [],
    "tags": [],
    "lang":"en"
  },
  {
    "title":"Test Your App",
    "summary":"This document describes key concepts related to Android app testing. It assumes you have a basic knowledge of the JUnit testing framework. Android testing is based on JUnit. In general, a JUnit test is a method whose statements test a part of the application\u2026",
    "url":"studio/test/index.html",
    "image":"studio/images/test/test-framework.png",
    "type":"studio",
    "keywords": [],
    "tags": [],
    "lang":"en"
  },
  {
    "title":"Android Studio 2.0",
    "category":"",
    "summary":"Android Studio 2.0 is the fastest way to build high quality, performant apps for the Android platform, including phones and tablets, Android Auto, Android Wear, and Android TV. As the official IDE from Google, Android Studio includes everything you…",
    "url":"http://android-developers.blogspot.com/2016/04/android-studio-2-0.html",
    "group":"",
    "keywords": [],
    "tags": ['studio'],
    "image":"https://1.bp.blogspot.com/-vxXg6Inv_WA/VwaJ0uzSf_I/AAAAAAAACr4/xzszbcRzWRgSaHXpOpYroG7u6bgsFJjqw/s200/image03.png",
    "type":"blog"
  },
  {
    "title":"Writing More Code by Writing Less Code with Android Studio Live Templates",
    "category":"",
    "summary":"Unless you’re getting paid by the keystroke, no one wants to write repetitive boilerplate code.",
    "url":"https://medium.com/google-developers/writing-more-code-by-writing-less-code-with-android-studio-live-templates-244f648d17c7#.hczcm02du",
    "group":"",
    "keywords": [],
    "tags": ['studio'],
    "image":"https://cdn-images-1.medium.com/max/800/1*JkrYXGs1AxZAbK0sCLrJAQ.gif",
    "type":"medium"
  },
  {
    "title":"How Often Should You Update Android Studio?",
    "category":"",
    "summary":"One of the beauties of Android Studio is how quickly is evolves and improves.",
    "url":"https://medium.com/google-developers/how-often-should-you-update-android-studio-db25785c488e#.8blbql35x",
    "group":"",
    "keywords": [],
    "tags": ['studio'],
    "image":"https://cdn-images-1.medium.com/max/2000/1*chMiA9mGa_FBUOoesHHk3Q.png",
    "type":"medium"
  },
  {
    "title":"SmallerAPK, Part 6: Image optimization, Zopfli & WebP",
    "category":"",
    "summary":"Series of posts on minimizing your APK size.",
    "url":"https://medium.com/@wkalicinski/smallerapk-part-6-image-optimization-zopfli-webp-4c462955647d#.23hlddo3x",
    "group":"",
    "keywords": [],
    "tags": [],
    "image":"https://cdn-images-1.medium.com/max/2000/1*chMiA9mGa_FBUOoesHHk3Q.png",
    "type":"medium"
  },

  {
    "title":"Measure your app’s user acquisition channels",
    "category":"google",
    "summary":"Get details on how to use the Developer Console User Acquisitions reports to discover where your users come from.",
    "url":"https://support.google.com/googleplay/android-developer/answer/6263332",
    "group":"",
    "keywords": [],
    "tags": [],
    "image":"images/cards/google-play_2x.png",
    "type":"distribute"
  },
  {
    "title":"Set up native app install banners in Chrome",
    "category":"google",
    "summary":"Get the details you need to add your native app or game to your site’s web app manifest file.",
    "url":"https://developers.google.com/web/updates/2015/03/increasing-engagement-with-app-install-banners-in-chrome-for-android#native",
    "group":"",
    "keywords": [],
    "tags": [],
    "image":"images/cards/google-play_2x.png",
    "type":"distribute"
  },
  {
    "title":"Optimize your store listing pages with experiments",
    "category":"google",
    "summary":"You can run experiments to find the most effective graphics and localized text for your app.",
    "url":"https://support.google.com/googleplay/android-developer/answer/6227309",
    "group":"",
    "keywords": [],
    "tags": [],
    "image":"images/cards/google-play_2x.png",
    "type":"distribute"
  },
  {
    "title":"Content Experiments for Mobile Apps",
    "category":"google",
    "summary":"Google Analytics Content Experiments allows you to test multiple variations of a given web page.",
    "url":"https://support.google.com/tagmanager/answer/6003007",
    "group":"",
    "keywords": [],
    "tags": [],
    "image":"images/cards/google-play_2x.png",
    "type":"distribute"
  },
  {
    "title":"Use alpha/beta testing & staged rollouts",
    "category":"google play",
    "summary":"Using the Google Play Developer Console, you can choose groups of users to test different versions of your app.",
    "url":"https://support.google.com/googleplay/android-developer/answer/3131213",
    "group":"",
    "keywords": [],
    "tags": [],
    "image":"images/cards/google-play_2x.png",
    "type":"distribute"
  },
  {
    "title":"Quizlet Developer Story",
    "category":"google play",
    "summary":"Quizlet is an extremely popular online learning tool for students. See how they optimized for the classroom with Android and the power of Google Play for Education.",
    "url":"https://www.youtube.com/watch?v=Idu7VcTTXfk",
    "group":"",
    "keywords": [],
    "tags": [
      "#gpfe",
      "#googleplay"
    ],
    "image":"https://i1.ytimg.com/vi/Idu7VcTTXfk/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"What's New in GPFE",
    "category":"google play",
    "summary":"Learn about the vision and philosophy behind Google Play for Education",
    "url":"https://www.youtube.com/watch?v=IKhU180eJMo",
    "group":"",
    "keywords": [],
    "tags": [
      "#gpfe",
      "#googleplay"
    ],
    "image":"https://i1.ytimg.com/vi/IKhU180eJMo/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"Get started with Google Cast",
    "category":"google",
    "summary":"Build multi-screen experiences, let the user send video and audio content to TVs and speakers.",
    "url":"https://developers.google.com/cast/docs/ux_guidelines",
    "group":"",
    "keywords": ["cast", "chromecast", "video", "audio"],
    "tags": [],
    "image":"images/cards/card-cast_2x.jpg",
    "type":"develop"
  },
  {
    "title":"Android Sender Applications",
    "category":"google",
    "summary":"Get an overview of how your Android app can act as a Google Cast sender app.",
    "url":"https://developers.google.com/cast/docs/android_sender",
    "group":"",
    "keywords": ["cast", "sender"],
    "tags": [],
    "image":"images/cards/card-cast_2x.jpg",
    "type":"develop"
  },
  {
    "title":"Cast sample apps",
    "category":"google",
    "summary":"Get example Google Cast applications for both senders and receivers.",
    "url":"https://www.github.com/googlecast",
    "group":"",
    "keywords": ["cast", "samples"],
    "tags": [],
    "image":"images/cards/card-cast_2x.jpg",
    "type":"Samples"
  },
  {
    "title":"Get Cardboard",
    "category":"Google",
    "summary":"Get your own Cardboard, today. Buy one from a manufacturer or build your own, and start developing.",
    "url":"https://www.google.com/get/cardboard/get-cardboard/",
    "group":"",
    "keywords": ["carboard","vr"],
    "tags": [],
    "image":"images/cards/card-cardboard_2x.png",
    "type":"develop"
  },
    {
    "title":"Download the Cardboard SDK",
    "category":"google",
    "summary":"Grab the Cardboard libraries from GitHub and start creating VR apps in your favorite development environment.",
    "url":"https://developers.google.com/cardboard/android/download",
    "group":"",
    "keywords": ["carboard","vr"],
    "tags": [],
    "image":"images/cards/card-cardboard_2x.png",
    "type":"develop"
  },
  {
    "title":"Cardboard design guidelines",
    "category":"design",
    "summary":"Focus on overall usability and avoiding common VR pitfalls while creating an immersive experience of your own.",
    "url":"https://www.google.com/design/spec-vr",
    "group":"",
    "keywords": ["carboard","vr"],
    "tags": [],
    "image":"images/cards/card-cardboard_2x.png",
    "type":"Design"
  },
  {
    "title":"Maps",
    "category":"google",
    "summary":"Give users the map that more than a billion people use every month.",
    "url":"https://developers.google.com/maps/documentation/android/",
    "group":"",
    "keywords": ["maps"],
    "tags": [],
    "image":"images/google/gps-maps.png",
    "type":"develop"
  },
    {
    "title":"Places API",
    "category":"google",
    "summary":"give your users contextual information about where they are, when they’re there.",
    "url":"https://developers.google.com/places/android/",
    "group":"",
    "keywords": ["places","location", "context"],
    "tags": [],
    "image":"images/cards/card-places_2x.png",
    "type":"develop"
  },
  {
    "title":"GCM Client for Android",
    "category":"google",
    "summary":"Send push notifications and pubsub from your server to Android devices around the world.",
    "url":"https://developers.google.com/cloud-messaging/android/client",
    "group":"",
    "keywords": ["push","gcm"],
    "tags": [],
    "image":"images/cards/card-google-cloud-messaging_16-9_2x.png",
    "type":"develop"
  },
  {
    "title":"Google Cloud Messaging",
    "category":"google",
    "summary":"Learn about GCM and the kinds of services you can offer to users through push notifications",
    "url":"https://developers.google.com/cloud-messaging/gcm",
    "group":"",
    "keywords": ["push","gcm"],
    "tags": [],
    "image":"images/cards/card-google-cloud-messaging_16-9_2x.png",
    "type":"develop"
  },
  {
    "title":"ClassDojo Developer Story",
    "category":"developer story",
    "summary":"ClassDojo is a classroom tool that helps teachers improve behavior in their classrooms quickly and easily. See how they optimized for the classroom with Android and the power of Google Play for Education.",
    "url":"https://www.youtube.com/watch?v=iokH4SAIfRw",
    "group":"",
    "keywords": [],
    "tags": [
      "#gpfe",
      "#googleplay"
    ],
    "image":"https://i1.ytimg.com/vi/iokH4SAIfRw/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"Plan for Success",
    "category":"google play",
    "summary":"5 tips from developers on creating great EDU apps.",
    "url":"https://www.youtube.com/watch?v=Eh2adsAyTKc",
    "group":"",
    "keywords": [],
    "tags": [
      "#gpfe",
      "#googleplay"
    ],
    "image":"https://i1.ytimg.com/vi/Eh2adsAyTKc/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"Optimizing Apps for Education",
    "category":"google play",
    "summary":"Learn how to optimize your app for teachers and students.",
    "url":"https://www.youtube.com/watch?v=_AZ6UcPz-_g",
    "group":"",
    "keywords": [],
    "tags": [
      "#gpfe",
      "#googleplay"
    ],
    "image":"https://i1.ytimg.com/vi/_AZ6UcPz-_g/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"Ideas and Tools for Building Innovative Education Apps",
    "category":"google play",
    "summary":"Are you hungry to build an awesome app for education but don't quite know where to start? Come hear about apps that teachers want, and the APIs you're going to need to build them! In particular, we'll talk about app ideas that combine APIs for Google Drive, Google Login, Android Single Task Mode and more to build transformative Educational apps that will delight educators and kids in and out of the classroom.",
    "url":"https://www.youtube.com/watch?v=iulXz8QTD1g",
    "group":"",
    "keywords": [],
    "tags": [
      "#gpfe",
      "#googleplay"
    ],
    "image":"https://i1.ytimg.com/vi/iulXz8QTD1g/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"DesignBytes: Intro To Material Design",
    "category":"material design",
    "summary":"These days, UI designers need to be thinking about phones, tablets, laptops, TVs, smartwatches, and beyond. In this DesignByte we talk about how Google designers have been working on making cross-platform and multi-screen design easier. We wanted to build a design system that felt at home on every screen, from the smallest watch to the largest TV.",
    "url":"https://www.youtube.com/watch?v=p4gmvHyuZzw",
    "group":"",
    "keywords": [],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/p4gmvHyuZzw/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"DesignBytes: Paper and Ink: The Materials that Matter",
    "category":"material design",
    "summary":"Join Rich Fulcher to learn about the materials of material design. See how virtual paper and ink form the foundation of your tactile user interface and master the rules that govern their behaviour.",
    "url":"https://www.youtube.com/watch?v=YaG_ljfzeUw",
    "group":"",
    "keywords": [],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/YaG_ljfzeUw/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"DesignBytes: Material Design in the Google I/O App",
    "category":"",
    "summary":"Roman Nurik shares details on the design process for the Google I/O 2014 app. To check out the app's source code, visit github.com/google/iosched.",
    "url":"https://www.youtube.com/watch?v=XOcCOBe8PTc",
    "group":"",
    "keywords": [],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/XOcCOBe8PTc/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"Toolbars for a flexible Action Bar & more",
    "category":"",
    "summary":"Toolbars are a flexible View you can add to your Android app which provides many of the same APIs as the system provided Action Bar, but can also do so much more such as reacting to scrolling or being integrated directly into your layouts.",
    "url":"https://www.youtube.com/watch?v=kmUGLURRPkI",
    "group":"",
    "keywords": [],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/kmUGLURRPkI/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"Protecting Implicit Intents with Runtime Checks",
    "category":"",
    "summary":"Make sure you protect your implicit intents with a simple runtime check.",
    "url":"https://www.youtube.com/watch?v=HGElAW224dE",
    "group":"",
    "keywords": [],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/HGElAW224dE/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"Tabs and ViewPager",
    "category":"",
    "summary":"Showing multiple screens or pages of content is easy with the help of ViewPager and a PagerAdapter. Combining that with tabs make for an effective top level navigation strategy for your app or for moving between content at the same level of hierarchy within your app.",
    "url":"https://www.youtube.com/watch?v=zQekzaAgIlQ",
    "group":"",
    "keywords": [],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/zQekzaAgIlQ/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"Battery Drain and Networking",
    "category":"",
    "summary":"Let’s take a moment to make something insanely clear: As far as battery is concerned, NETWORKING is the biggest, baddest, dirtiest offender there is. And optimizing performance here isn’t easy. Since the chip isn’t always awake and draining power, means you can optimize how it wakes up, sends traffic, and saves battery.",
    "url":"https://www.youtube.com/watch?v=fEEulSk1kNY",
    "group":"",
    "keywords": [],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/fEEulSk1kNY/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"Batching Background Work Until Later",
    "category":"",
    "summary":"Yes, your app is special. But when it comes to battery use, sometimes it’s better to be part of the crowd. Why not spread the battery blame around a bit? Ian Ni-Lewis shows you how ridiculously easy it is to go from battery hog to team player in this video.",
    "url":"https://www.youtube.com/watch?v=-3ry8PxcJJA",
    "group":"",
    "keywords": [],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/-3ry8PxcJJA/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"The Performance Lifecycle",
    "category":"",
    "summary":"Performance problems surface in your application at the least-wanted times (like right before you’re about to ship your first build). But don’t freak out: There’s a simple process that you can follow to help get your performance back under control.",
    "url":"https://www.youtube.com/watch?v=_kKTGK-Cb_4",
    "group":"",
    "keywords": [],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/_kKTGK-Cb_4/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"Introduction to Android Studio",
    "category":"",
    "summary":"Learn why you should migrate your projects to Android Studio now and how it can help you be more productive as a developer. Rich layout editor, handy suggestions and fixes, new Android project view - these are just some of the things you can expect from the IDE, which is built on the successful IntelliJ IDEA.",
    "url":"https://www.youtube.com/watch?v=K2dodTXARqc&list=PLWz5rJ2EKKc8I9gHTMh5yKkwRRGE8BjbQ",
    "group":"",
    "keywords": ["studio", "tools"],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/K2dodTXARqc/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"Instant Run: An Android Tool Time Deep Dive",
    "category":"",
    "summary":"Instant Run is an Android Studio feature that significantly reduces the time for building and deploying incremental code changes during your coding / testing / debugging lifecycle.",
    "url":"https://www.youtube.com/watch?v=StqAZ1OQbqA&list=PLWz5rJ2EKKc_w6fodMGrA1_tsI3pqPbqa",
    "group":"",
    "keywords": ["studio", "tools"],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/StqAZ1OQbqA/maxresdefault.jpg",
    "type":"youtube"
  },
  {
    "title":"What’s New in Android Studio 2.1",
    "category":"",
    "summary":"Android Studio 2.1 is required to try out new features and APIs of the Android N developer preview including the new Jack compiler and Java 8 language support. It also includes performance improvements to Instant Run, and a number of bug fixes and stability improvements.",
    "url":"https://www.youtube.com/watch?v=ZOz_yr8Yxq8&list=PLWz5rJ2EKKc_w6fodMGrA1_tsI3pqPbqa",
    "group":"",
    "keywords": ["studio", "tools"],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/ZOz_yr8Yxq8/maxresdefault.jpg",
    "type":"youtube"
  },
  {
    "title":"10 Things You Didn’t Know You Could Do",
    "category":"",
    "summary":"This Android Tool Time pro-tip roundup with Reto Meier shows off expert Android Studio tips designed to help you write less code, and make every keystroke count",
    "url":"https://www.youtube.com/watch?v=eOV2owswDkE&list=PLWz5rJ2EKKc_w6fodMGrA1_tsI3pqPbqa",
    "group":"",
    "keywords": ["studio", "tools"],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/eOV2owswDkE/maxresdefault.jpg",
    "type":"youtube"
  },
  {
    "title":"Live Templates in Android Studio",
    "category":"",
    "summary":"Android Tool Time Protip: Use and create your own Live Templates in Android Studio to write more code with less keystrokes using Live Templates to insert common, templatized code snippets.",
    "url":"https://www.youtube.com/watch?v=4rI4tTd7-J8&list=PLWz5rJ2EKKc_w6fodMGrA1_tsI3pqPbqa",
    "group":"",
    "keywords": ["studio", "tools"],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/4rI4tTd7-J8/maxresdefault.jpg",
    "type":"youtube"
  },
  {
    "title":"Enable Android Studio's &quot;Dex In Process&quot; for Faster App Builds",
    "category":"",
    "summary":"Android Studio 2.1 enables Dex In Process, a feature that can dramatically improve all your build times. To take advantage of Dex In Process, you’ll need to modify your gradle.properties file and increase the amount of memory allocated to the Gradle Daemon VM by 1 Gb, to a minimum of 2 Gb, using the org.gradle.jvmargs property.",
    "url":"https://www.youtube.com/watch?v=-SY5nkNVUn0&list=PLWz5rJ2EKKc_w6fodMGrA1_tsI3pqPbqa",
    "group":"",
    "keywords": ["studio", "tools"],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/-SY5nkNVUn0/maxresdefault.jpg",
    "type":"youtube"
  },
  {
    "title":"Configuring Parallel Canary / Stable Android Studio Installations",
    "category":"",
    "summary":"Android Tool Time Protip: Maintain parallel Android Studio installations on canary and stable channels to take advantage of all the new hotness, without risking your stable dev environment.",
    "url":"https://www.youtube.com/watch?v=SBbWGxXCMqQ&list=PLWz5rJ2EKKc_w6fodMGrA1_tsI3pqPbqa",
    "group":"",
    "keywords": ["studio", "tools"],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/SBbWGxXCMqQ/maxresdefault.jpg",
    "type":"youtube"
  },
  {
    "title":"What’s New in Android Studio 2.0",
    "category":"",
    "summary":"Android Studio 2.0 is focused on making your workflow faster. Faster builds, faster deployment, faster emulators. Everything. Faster.",
    "url":"https://www.youtube.com/watch?v=xxx3Fn7EowU&list=PLWz5rJ2EKKc_w6fodMGrA1_tsI3pqPbqa",
    "group":"",
    "keywords": ["studio", "tools"],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/xxx3Fn7EowU/maxresdefault.jpg",
    "type":"youtube"
  },
  {
    "title":"Google Play Services 7.5",
    "category":"",
    "summary":"This update brings App Invites, topics to GCM, GCMNetworkManager, Cast Remote Display API, Smart Lock for Passwords, Maps API for Android Wear, Google Fit extensions and more.",
    "url":"https://www.youtube.com/watch?v=M3Udfu6qidk&list=PLWz5rJ2EKKc9Qk1_iCZNbBp6adYnJf9Vf",
    "group":"",
    "keywords": ["google play services"],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/M3Udfu6qidk/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"Google Play Services 7.3",
    "category":"",
    "summary":"This update brings the ability to connect multiple wearables simultaneously to a single phone. There are also some great new updates to Google Fit, including nutrition types, and to Location.",
    "url":"https://www.youtube.com/watch?v=FOn64iqlphk&list=PLWz5rJ2EKKc9Qk1_iCZNbBp6adYnJf9Vf",
    "group":"",
    "keywords": ["google play services"],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/FOn64iqlphk/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"Google Play Services 6.5",
    "category":"",
    "summary":"Google Play services 6.5 includes new features in Google Maps, Google Drive and Google Wallet as well as the recently launched Google Fit API. ",
    "url":"https://www.youtube.com/watch?v=fvtMtfCuEpw&list=PLWz5rJ2EKKc9Qk1_iCZNbBp6adYnJf9Vf",
    "group":"",
    "keywords": ["google play services"],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/fvtMtfCuEpw/maxresdefault.jpg",
    "type":"video"
  },
    {
    "title":"Google Play Services 7.0",
    "category":"",
    "summary":"Google Play services 7.0 is here! we've added the Places API, made enhancements to Location and Google Fit, and you can also remote control your Android TV through the new Nearby Connections API.",
    "url":"https://www.youtube.com/watch?v=F0Kh_RnSM0w&list=PLWz5rJ2EKKc9Qk1_iCZNbBp6adYnJf9Vf",
    "group":"",
    "keywords": ["google play services"],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/F0Kh_RnSM0w/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"Running a Successful Games Business with Google",
    "category":"",
    "summary":"Sure, we all want to make the next great gaming masterpiece. But we also want to feed our families and/or dogs. Join Bob Meese from the Google Play team as he gives you some key pointers on how to make sure you're best taking advantage of Google Play and running a successful games business.",
    "url":"https://www.youtube.com/watch?v=tDmnGNkTtlE",
    "group":"",
    "keywords": [],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/tDmnGNkTtlE/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"Introduction to Android TV",
    "category":"",
    "summary":"Android TV brings the Android platform to the living room with rich content and entertaining app experiences. In this video, Timothy introduces the design philosophy and developer components that make building TV experiences easier than ever before.",
    "url":"https://www.youtube.com/watch?v=6K_jxccHv5M&index=1&list=PLOU2XLYxmsILFBfx66ens76VMLMEPJAB0",
    "group":"",
    "keywords": ["tv"],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/6K_jxccHv5M/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"Introduction to Android Auto",
    "category":"",
    "summary":"Android Auto brings the Android platform to the car in a way that's optimized for the driving experience. It's the same platform you already use for phones, tablets, televisions, wearables, and more. ",
    "url":"https://www.youtube.com/watch?v=ctiaVxgclsg&list=PLWz5rJ2EKKc9BdE_PSLNIGjXXr3h_orXM",
    "group":"",
    "keywords": ["auto"],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/ctiaVxgclsg/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"Debugging and testing in Android Studio",
    "titleFriendly":"",
    "summary":"This video introduces the state of unit testing support in Studio and Google’s new Android Testing Support Library for functional UI testing and running instrumented tests on a device.",
    "url":"https://www.youtube.com/watch?v=2I6fuD20qlY",
    "group":"",
    "keywords": ["testing"],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/2I6fuD20qlY/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"Android Testing (Android Dev Summit 2015)",
    "titleFriendly":"",
    "summary":"Overview of the testing tools and frameworks provided by Google and how they can help you to iterate more quickly and maintain a more healthy codebase.",
    "url":"https://www.youtube.com/watch?v=vdasFFfXKOY",
    "group":"",
    "keywords": ["testing"],
    "tags": [
    ],
    "image":"https://i1.ytimg.com/vi/vdasFFfXKOY/maxresdefault.jpg",
    "type":"video"
  },
  {
    "title":"dumpsys",
    "titleFriendly":"",
    "summary":"A tool that runs on the device and provides information about the status of system services.",
    "url":"https://source.android.com/devices/tech/debug/dumpsys.html",
    "group":"",
    "keywords": ["testing"],
    "tags": [
    ],
    "image":"",
    "type":"google"
  },
  {
    "title":"Android Testing Samples",
    "titleFriendly":"",
    "summary":"A collection of samples demonstrating different frameworks and techniques for automated testing.",
    "url":"https://github.com/googlesamples/android-testing",
    "group":"",
    "keywords": ["testing"],
    "tags": [
    ],
    "image":"images/testing/testing-icon.png",
    "type":"Samples"
  },
  {
    "title":"Android Testing Templates",
    "titleFriendly":"",
    "summary":"A collection of Google's Android testing tools and frameworks, all integrated in a single application project.",
    "url":"https://github.com/googlesamples/android-testing-templates",
    "group":"",
    "keywords": ["testing"],
    "tags": [
    ],
    "image":"images/testing/testing-icon.png",
    "type":"Samples"
  },
   {
    "title":"Android Testing Support Library (GitHub)",
    "titleFriendly":"",
    "summary":"A resource page on GitHub for the Android Testing Support Library.",
    "url":"https://google.github.io/android-testing-support-library",
    "group":"",
    "keywords": ["testing"],
    "tags": [
    ],
    "image":"images/testing/testing-icon.png",
    "type":"Samples"
  },
  {
    "title":"Android Testing Codelab",
    "titleFriendly":"",
    "summary":"This codelab shows how to build an Android app from the ground up in Android Studio, using a Model View Presenter architecture, Unit Tests and Instrumentation Tests.",
    "url":"https://codelabs.developers.google.com/codelabs/android-testing/index.html",
    "group":"",
    "keywords": ["testing"],
    "tags": [
    ],
    "image":"images/testing/testing-icon.png",
    "type":"google"
  },
  {
    "title":"Developer Registration",
    "category":"google play",
    "summary":"Additional information about the registration process.",
    "url":"https://support.google.com/googleplay/android-developer/answer/113468",
    "group":"",
    "keywords": [],
    "tags": [],
    "image":"images/cards/google-play_2x.png",
    "type":"distribute"
  },
  {
    "title": "Google Play Distribution and Seller Countries",
    "category":"google play",
    "summary": "List of countries and territories where you can distribute your apps in Google Play.",
    "url":"https://support.google.com/googleplay/android-developer/answer/138294",
    "group":"",
    "keywords": [],
    "tags": [],
    "image":"images/cards/google-play_2x.png",
    "type":"distribute"
  },
  {
    "title":"Google Play Content Policies",
    "category":"google play",
    "summary":"Details on policies relating to your developer account and app distribution is governed.",
    "url":"https://support.google.com/googleplay/android-developer/topic/3453577",
    "group":"",
    "keywords": [],
    "tags": ["#developersupport"],
    "image":"images/cards/google-play_2x.png",
    "type":"distribute"
  },
  {
    "title":"Google Play Badge Generator",
    "category":"google play",
    "summary":"Build badges for your app in just a few clicks, or download hi-res badge assets localized for a variety of languages.",
    "url":"https://play.google.com/intl/en_us/badges/",
    "group":"",
    "keywords": [],
    "tags": ["#developersupport"],
    "image":"images/gp-badges-set.png",
    "type":"distribute"
  },
  {
    "lang": "en",
    "group": "",
    "tags": ["#developersupport #termsandpolicies"],
    "url": "https://support.google.com/googleplay/android-developer/answer/4407611",
    "timestamp": 1194884220000,
    "image": 'images/play_dev.jpg',
    "title": "Google Play Terms and Policies",
    "summary": "Developer terms and policies that apply when you distribute apps in Google Play.",
    "keywords": [],
    "type": "distribute",
    "category": "google play"
  },
  {
    "title":"Google Play Policy Center",
    "category":"google play",
    "summary":"A central resource for you to learn about Google Play policies and guidelines.",
    "url":"https://support.google.com/googleplay/android-developer/answer/4430948",
    "group":"",
    "keywords": [],
    "tags": [],
    "image":"https://storage.googleapis.com/support-kms-prod/SNP_712EA2784949DDF085C46E3BE7B1DC618A09_4389397_en_v0",
    "type":"distribute"
  },
  {
    "title":"Developer Help Center",
    "category":"Support",
    "summary":"Complete details on getting started, publishing, troubleshooting, and more.",
    "url":"https://support.google.com/googleplay/android-developer",
    "group":"",
    "keywords": [],
    "tags": [],
    "image":"images/cards/google-play_2x.png",
    "type":"distribute"
  },
  {
    "title":"Google for Education",
    "category":"google play",
    "summary":"Find out more about how Google can support your work with apps and tablets.",
    "url":"https://www.google.com/edu/tablets/",
    "group":"",
    "keywords": [],
    "tags": [],
    "image":"distribute/images/gp-edu-apps-image.jpg",
    "type":"google"
  },
  {
    "title":"Keeping Your App Responsive",
    "category":"performance",
    "summary":"This document describes how the Android system determines whether an application is not responding and provides guidelines for ensuring that your application stays responsive.",
    "url":"training/articles/perf-anr.html",
    "group":"",
    "keywords": [],
    "tags": [],
    "image":"",
    "type":"google"
  },
  {
    "title":"Google Play Game Services",
    "category":"google",
    "summary":"Make your games social with Google Play game services. Add achievements, leaderboards, real-time multiplayer, and other popular features using the Google Play game services SDK.",
    "url":"https://developers.google.com/games/services/",
    "group":"",
    "keywords": ["games","play games"],
    "tags": [],
    "image":"images/google/gps-play_games_logo.png",
    "type":"distribute"
  },
  {
    "title": "Play Games Quality",
    "category": "google",
    "summary": "Meet the basic expectations of game players through compelling features and an intuitive, well-designed UI.",
    "url": "https://developers.google.com/games/services/checklist",
    "group": "",
    "keywords": ["games", "play games", "quality"],
    "tags": [],
    "image": "images/cards/distribute/engage/card-game-services.png",
    "type": "distribute"
  },
  {
    "title":"Get Started with Analytics",
    "category":"google",
    "summary":"Get advanced insight into how players discover and play your games.",
    "url":"distribute/analyze/start.html",
    "group":"",
    "keywords": ["analytics"],
    "tags": [],
    "image": "images/cards/analytics-mobile_2x.jpg",
    "type": "distribute"
  },
  {
    "title":"Monetize your apps intelligently",
    "category":"google",
    "summary":"Generate revenue from your free games with ads tailored to match your game's look and feel.",
    "url":"https://www.google.com/admob/",
    "group":"",
    "keywords": ["AdMob"],
    "tags": [],
    "image":"images/cards/admob-analytics_2x.png",
    "type": "distribute"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [
      "versions", "blog", "googleplay"
    ],
    "url": "https://android-developers.blogspot.com/",
    "timestamp": 1004884220000,
    "image": "images/blog.jpg",
    "title": "Android Developers Blog",
    "summary": "Follow the latest news on Android design, development, and distribution.",
    "keywords": [],
    "type": "blog",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://android-developers.blogspot.com/2011/11/making-android-games-that-play-nice.html",
    "timestamp": 1194884220000,
    "image": null,
    "title": "Making Android Apps that Play Nice",
    "summary": "Audio lifecycle and expected audio behaviors for Android apps.",
    "keywords": [],
    "type": "blog",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://android-developers.blogspot.com/2010/07/multithreading-for-performance.html",
    "timestamp": 1194884220000,
    "image": null,
    "title": "Multithreading for Performance",
    "summary": "Ways to improve performance through multi-threading.",
    "keywords": [],
    "type": "blog",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://play.google.com/about/developer-content-policy.html",
    "timestamp": 1194884220000,
    "image": "images/cards/google-play_2x.png",
    "title": "Developer Program Policies",
    "summary": "Guidelines acceptable content in Google Play. Please read and understand the policies before publishing.",
    "keywords": [],
    "type": "distribute",
    "category": "google play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/googleplay/android-developer/answer/188189",
    "timestamp": 1194884220000,
    "image": "images/cards/google-play_2x.png",
    "title": "Rating your application content for Google Play",
    "summary": "How to choose the appropriate content ratings level for your apps.",
    "keywords": [],
    "type": "distribute",
    "category": "Support"
  },
  {
    "lang": "en",
    "group": "",
    "tags": ["devices", "nexus", "testing"],
    "url": "https://developers.google.com/android/nexus/images",
    "timestamp": 1194884220000,
    "image": "images/cards/card-download_16-9_2x.png",
    "title": "Factory Images for Nexus Devices",
    "summary": "System image files for Android 6.0 and other Android releases.",
    "keywords": ["nexus, downloads"],
    "type": "develop",
    "category": "Tools"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://android-developers.blogspot.com/2011/10/android-market-featured-image.html",
    "timestamp": 1194884220000,
    "image": "images/cards/google-play_2x.png",
    "title": "Google Play Featured Image Guidelines",
    "summary": "How to create attractive, effective Featured Images for your apps.",
    "keywords": [],
    "type": "distribute",
    "category": "google play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/googleplay/android-developer/answer/113477",
    "timestamp": 1194884220000,
    "image": "images/cards/google-play_2x.png",
    "title": "Supporting your users",
    "summary": "Options for supporting users.",
    "keywords": [],
    "type": "distribute",
    "category": "Support"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "guide/practices/screens_support.html#ConfigurationExamples",
    "timestamp": 1194884220000,
    "image": null,
    "title": "Configuration examples",
    "summary": "How to declare layouts and other resources for specific screen sizes.",
    "keywords": [],
    "type": "develop",
    "category": "guide"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "training/design-navigation/multiple-sizes.html",
    "timestamp": 1194884220000,
    "image": null,
    "title": "Planning for Multiple Touchscreen Sizes",
    "summary": "",
    "keywords": [],
    "type": "develop",
    "category": "guide"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "training/multiscreen/index.html",
    "timestamp": 1194884220000,
    "image": null,
    "title": "Designing for Multiple Screens",
    "summary": "Designing an intuitive, effective navigation for tablets and other devices.",
    "keywords": [],
    "type": "develop",
    "category": "guide"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "guide/topics/resources/providing-resources.html",
    "timestamp": 1194884220000,
    "image": null,
    "title": "Providing Resources",
    "summary": "Layouts and drawable resources for specific ranges of device screens.",
    "keywords": [],
    "type": "develop",
    "category": "guide"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "training/basics/supporting-devices/screens.html",
    "timestamp": 1194884220000,
    "image": null,
    "title": "Supporting Different Screens",
    "summary": "Optimizing the user experience for different screen sizes and densities.",
    "keywords": [],
    "type": "develop",
    "category": "guide"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "guide/topics/appwidgets/index.html#MetaData",
    "timestamp": 1194884220000,
    "image": null,
    "title": "Adding the AppWidgetProviderInfo Metadata",
    "summary": "How to set the height and width dimensions of a widget.",
    "keywords": [],
    "type": "develop",
    "category": "guide"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "guide/topics/manifest/uses-sdk-element.html#ApiLevels",
    "timestamp": 1194884220000,
    "image": null,
    "title": "Android API Levels",
    "summary": "Introduction to API levels and how they relate to compatibility.",
    "keywords": [],
    "type": "develop",
    "category": "compatibility"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "guide/practices/screens_support.html#DeclaringScreenSizeSupport",
    "timestamp": 1194884220000,
    "image": null,
    "title": "Declaring screen size support",
    "summary": "How to declare support for screen sizes in your app\'s manifest.",
    "keywords": [],
    "type": "develop",
    "category": "compatibility"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "training/material/animations.html#Touch",
    "timestamp": 1194884220000,
    "image": null,
    "title": "Customize Touch Feedback",
    "summary": "Provide visual confirmation when users interact with your UI.",
    "keywords": [],
    "type": "develop",
    "category": "guide"
  },

  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "guide/topics/manifest/uses-feature-element.html#testing",
    "timestamp": 1194884220000,
    "image": null,
    "title": "Checking for hardware feature requirements",
    "summary": "Determining an app’s hardware and software requirements.",
    "keywords": [],
    "type": "develop",
    "category": "compatibility"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://play.google.com/apps/publish/",
    "timestamp": 1194884220000,
    "image": null,
    "title": "Google Play Developer Console",
    "summary": "The tools console for publishing your app.",
    "keywords": [],
    "type": "distribute",
    "category": "Google Play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://youtu.be/SkHHPf3EdzE",
    "timestamp": 1194884220000,
    "image": "https://i1.ytimg.com/vi/SkHHPf3EdzE/maxresdefault.jpg",
    "title": "Level Up Your Android Game",
    "summary": "Learn how to take your game to the next level on Google Play.",
    "keywords": [],
    "type": "video",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/+/mobile/android/share/interactive-post",
    "timestamp": 1194884220000,
    "image": 'images/google/gps-googleplus.png',
    "title": "Sharing interactive posts to Google+ from your Android app",
    "summary": "Interactive posts provide an easy and prominent way to allow users to share your site or app with their friends and invite them to take a specific action.",
    "keywords": ["Interactive", "Google+"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://play.google.com/about/developer-distribution-agreement.html",
    "timestamp": 1194884220000,
    "image": "images/cards/google-play_2x.png",
    "title": "Developer Distribution Agreement",
    "summary": "Terms for distributing and selling apps and in-app products in Google Play.",
    "keywords": [],
    "type": "distribute",
    "category": "google play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/googleplay/android-developer/answer/113417",
    "timestamp": 1194884220000,
    "image": null,
    "title": "Inappropriate content in comments and applications",
    "summary": "More details on what content is appropriate.",
    "keywords": [],
    "type": "distribute",
    "category": "google play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/legal/troubleshooter/1114905",
    "timestamp": 1194884220000,
    "image": null,
    "title": "Removing content from Google",
    "summary": "Find how how to request the removal of content that infringes on your trademark.",
    "keywords": [],
    "type": "distribute",
    "category": "google play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://play.google.com/about/developer-distribution-agreement-addendum.html",
    "timestamp": 1194884220000,
    "image": "images/cards/google-play_2x.png",
    "title": "Google Play for Education Addendum",
    "summary": "Review the education-specific requirements.",
    "keywords": [],
    "type": "distribute",
    "category": "google play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://android-developers.blogspot.com/2013/03/native-rtl-support-in-android-42.html",
    "timestamp": null,
    "image": null,
    "title": "Native RTL Support in Android 4.2",
    "summary": "Blog post that explains how to support RTL in your UI.",
    "keywords": [],
    "type": "blog",
    "category": "Localization"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "guide/topics/resources/string-resource.html#Plurals",
    "timestamp": 1194884220000,
    "image": null,
    "title": "Quantity Strings (Plurals)",
    "summary": "How to work with string plurals according to rules of grammar in a given locale.",
    "keywords": [],
    "type": "develop",
    "category": "Localization"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "reference/java/util/Locale.html",
    "timestamp": 1194884220000,
    "image": null,
    "title": "Locale",
    "summary": "Determine what CLDR data or version of the Unicode spec a particular Android platform version uses.",
    "keywords": [],
    "type": "develop",
    "category": "Localization"
  },
    {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "guide/topics/resources/string-resource.html",
    "timestamp": 1194884220000,
    "image": null,
    "title": "String Resources",
    "summary": "Explains how to use string resources in your UI.",
    "keywords": ["localization"],
    "type": "develop",
    "category": "guide"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "distribute/tools/localization-checklist.html#strings",
    "timestamp": 1194884220000,
    "image": null,
    "title": "Manage strings for localization",
    "summary": "Guidance on having your strings translation ready.",
    "keywords": [],
    "type": "distribute",
    "category": "localization"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "distribute/googleplay/policies/index.html",
    "timestamp": 1194884220000,
    "image": "images/cards/google-play_2x.png",
    "title": "Google Play Policies and Guidelines",
    "summary": "An overview of Google Play policies for spam, intellectual property, and ads, with examples of common problems.",
    "keywords": [],
    "type": "distribute",
    "category": "google play "
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/googleplay/android-developer/topic/2364761",
    "timestamp": 1194884220000,
    "image": "images/cards/google-play_2x.png",
    "title": "Policy and Best Practices",
    "summary": "Help Center document describing various content policies and processes.",
    "keywords": [],
    "type": "distribute",
    "category": "google play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/wallet/instant-buy/",
    "timestamp": 1194884220000,
    "image": "",
    "title": "Android Pay APIs",
    "summary": "Developer documentation describing Instant Buy and how to support it in your apps.",
    "keywords": [],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/googleplay/android-developer/answer/1169947",
    "timestamp": 1194884220000,
    "image": "images/cards/google-play_2x.png",
    "title": "Selling Apps in Multiple Currencies",
    "summary": "Help Center document describing how pricing works in Google Play.",
    "keywords": [],
    "type": "distribute",
    "category": "google play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/googleplay/android-developer/answer/138412",
    "timestamp": 1194884220000,
    "image": "images/cards/google-play_2x.png",
    "title": "Prices and supported currencies",
    "summary": "Help Center document listing supported currencies for pricing your apps.",
    "keywords": [],
    "type": "distribute",
    "category": "google play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/googleplay/android-developer/answer/112622",
    "timestamp": 1194884220000,
    "image": "images/cards/google-play_2x.png",
    "title": "Transaction Fees",
    "summary": "Help Center document describing transaction fees for priced apps and in-app products.",
    "keywords": [],
    "type": "distribute",
    "category": "google play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/googleplay/android-developer/answer/138000",
    "timestamp": 1194884220000,
    "image": "images/cards/google-play_2x.png",
    "title": "Specifying tax rates",
    "summary": "Help Center document describing how to set tax rates for different countries.",
    "keywords": [],
    "type": "distribute",
    "category": "google play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "guide/topics/resources/localization.html",
    "timestamp": 1194884220000,
    "image": "images/cards/google-play_2x.png",
    "title": "Localizing with Resources",
    "summary": "Developer guide to localizing resources in your app.",
    "keywords": [],
    "type": "develop",
    "category": "localization"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/googleplay/android-developer/answer/113475",
    "timestamp": 1194884220000,
    "image": "images/cards/google-play_2x.png",
    "title": "Category types",
    "summary": "Help Center document listing available categories for apps.",
    "keywords": [],
    "type": "distribute",
    "category": "google play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/googleplay/android-developer/answer/113476",
    "timestamp": 1194884220000,
    "image": "images/cards/google-play_2x.png",
    "title": "Updates",
    "summary": "Requirements for app updates in Google Play.",
    "keywords": [],
    "type": "distribute",
    "category": "google play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/googleplay/android-developer/answer/1153479",
    "timestamp": 1194884220000,
    "image": "images/cards/google-play_2x.png",
    "title": "In-app Billing",
    "summary": "Help Center document describing how to correctly set up In-app Billing.",
    "keywords": [],
    "type": "distribute",
    "category": "google play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [
      "#gpfe",
      "#googleplay"
    ],
    "url": "https://youtu.be/vzvpcEffvaE",
    "timestamp": 1383243492000,
    "image": "https://i1.ytimg.com/vi/vzvpcEffvaE/maxresdefault.jpg",
    "title": "Introducing Tablets with Google Play for Education",
    "summary": "Schools in Hillsborough, New Jersey were among the first to try out Nexus 7 tablets with Google Play for Education. See the difference it made for students, teachers, and administrators.",
    "keywords": [],
    "type": "video",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [
      "#engagement",
    ],
    "url": "https://www.youtube.com/yt/dev/",
    "timestamp": 1383243492000,
    "image": "https://www.youtube.com/yt/dev/media/images/yt-dev-home-hero.jpg",
    "title": "YouTube for Developers",
    "summary": "The YouTube APIs and Tools enable you to integrate YouTube's video content and functionality into your website, app, or device.",
    "keywords": [],
    "type": "video",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [
      "#engagement",
    ],
    "url": "https://www.google.com/analytics/mobile/",
    "timestamp": 1383243492000,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "Mobile App Analytics",
    "summary": "Mobile App Analytics measures what matters most at all key stages: from first discovery and download to in-app purchases. ",
    "keywords": ["analytics,user behavior"],
    "type": "distribute",
    "category": "google"
  },


  {
    "lang": "en",
    "group": "",
    "tags": [
      "#gcm",
    ],
    "url": "https://www.youtube.com/watch?v=y76rjidm8cU",
    "timestamp": 1383243492000,
    "image": "https://1.bp.blogspot.com/-IF-1-1kA0sg/UYwTidxdi3I/AAAAAAAAAEU/ellLeQ-E1vs/s800/google-io-lockup-2.png",
    "title": "Google Cloud Messaging at I/O 2013",
    "summary": "Google Cloud Messaging allows your services to efficiently send data to applications on Android devices. See what's new, and learn how to use GCM to make your apps more efficient.",
    "keywords": ["gcm"],
    "type": "youtube",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [
      "gcm",
    ],
    "url": "https://developer.chrome.com/apps/cloudMessagingV2",
    "timestamp": 1383243492000,
    "image": "images/kk-chromium-icon.png",
    "title": "Google Cloud Messaging for Chrome",
    "summary": "Google Cloud Messaging for Chrome (GCM) is a service for signed-in Chrome users that helps developers send message data from servers to their Chrome apps and extensions.",
    "keywords": ["gcm"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [
      ""
    ],
    "url": "https://android-developers.blogspot.com/2013/07/making-beautiful-android-app-icons.html",
    "timestamp": 1194884220000,
    "image": null,
    "title": "Make Beautiful Android App Icons",
    "summary": "Follow these in-depth launcher icon tips on the Android Developers blog.",
    "keywords": [],
    "type": "blog",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [
      ""
    ],
    "url": "https://android-developers.blogspot.com/2012/12/localize-your-promotional-graphics-on.html",
    "timestamp": 1194884220000,
    "image": null,
    "title": "Localize Your Promotional Graphics",
    "summary": "Learn how to capitalise on international audiences.",
    "keywords": [],
    "type": "blog",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [
      ""
    ],
    "url": "https://android-developers.blogspot.com/2013/10/making-your-app-content-more-accessible.html",
    "timestamp": 1194884220000,
    "image": null,
    "title": "Make your App Content more Accessible with App Linking",
    "summary": "About using search and deep linking to get more users.",
    "keywords": [],
    "type": "blog",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/+/mobile/android/share/interactive-post",
    "timestamp": 1194884220000,
    "image": 'images/google/gps-googleplus.png',
    "title": "Sharing interactive posts to Google+ from your Android app",
    "summary": "Interactive posts provide an easy and prominent way to allow users to share your site or app with their friends and invite them to take a specific action.",
    "keywords": ["Interactive", "Google+"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/+/mobile/android/",
    "timestamp": 1194884220000,
    "image": 'images/google/gps-googleplus.png',
    "title": "Google+ Platform",
    "summary": "Find out about features such as interactive posts, Hangouts, accessing basic user details and their social graphs to make your app more personal.",
    "keywords": ["Google+"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/googleplay/android-developer/answer/2528691",
    "timestamp": 1194884220000,
    "image": "images/cards/google-play_2x.png",
    "title": "How to add multiple user accounts to your Developer Console for testing and more.",
    "summary": "",
    "keywords": [],
    "type": "distribute",
    "category": "google play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "google/play/licensing/index.html",
    "timestamp": 1194884220000,
    "image": null,
    "title": "Application Licensing",
    "summary": "Information on the features of Google Play to protect your apps’ licences.",
    "keywords": [],
    "type": "distribute",
    "category": "google play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "design/style/writing.html",
    "timestamp": 1194884220000,
    "image": null,
    "title": "Writing Style",
    "summary": "Design guidelines for voice and style in your UI.",
    "keywords": [],
    "type": "design",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://en.wikipedia.org/wiki/XLIFF",
    "timestamp": 1194884220000,
    "image": null,
    "title": "XML Localisation Interchange File Format (XLIFF)",
    "summary": "Background information on XLIFF.",
    "keywords": [],
    "type": "develop",
    "category": "localization"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/googleplay/android-developer/answer/1078870",
    "timestamp": 1194884220000,
    "image": "images/cards/google-play_2x.png",
    "title": "Graphic Assets for your Application",
    "summary": "Details about the graphics you can add to your product listing.",
    "keywords": [],
    "type": "distribute",
    "category": "google play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/payments/answer/2741495",
    "timestamp": null,
    "image": null,
    "title": "Issuing Refunds",
    "summary": "Help Center document describing how to issue refunds.",
    "keywords": [],
    "type": "distribute",
    "category": "google play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://android-developers.blogspot.com/2013/11/bring-your-apps-into-classroom-with.html",
    "timestamp": null,
    "image": "distribute/images/gp-edu-apps-image.jpg",
    "title": "Google play for education",
    "summary": " ",
    "keywords": [],
    "type": "distribute",
    "category": "google play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": ["localization", "pricing", "developer support"],
    "url": "https://support.google.com/googleplay/android-developer/table/3541286",
    "timestamp": null,
    "image": "images/cards/google-play_2x.png",
    "title": "Supported locations for distributing your apps in Google Play",
    "summary": "Countries and regions where you can distribute your app in Google Play.",
    "keywords": [],
    "type": "distribute",
    "category": "google play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": ["games", "localization", "quality"],
    "url": "https://www.youtube.com/watch?v=SkHHPf3EdzE",
    "timestamp": null,
    "image": "https://developers.google.com/apps/images/io_2013/google-io-logo.png",
    "title": "Level Up Your Android Game",
    "summary": "Learn how to take your game to the next level in this Google I/O session.",
    "keywords": [],
    "type": "distribute",
    "category": "google play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": ["support"],
    "url": "https://support.google.com/plus/topic/2888488",
    "timestamp": null,
    "image": null,
    "title": "Google+ Communities",
    "summary": "Host a Google+ community for testers or users.",
    "keywords": [],
    "type": "distribute",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": ["monetize", "ads"],
    "url": "https://www.google.com/doubleclick/publishers/small-business/index.html",
    "timestamp": null,
    "image": "https://www.google.com/doubleclick/publishers/small-business/images/define_ad.png",
    "title": "DoubleClick for Publishers",
    "summary": "A free ad management solution that helps growing publishers sell, schedule, deliver, and measure all of their digital ad inventory.",
    "keywords": ["ads"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": ["monetize", "ads"],
    "url": "https://support.google.com/googleplay/android-developer/topic/2985714",
    "timestamp": null,
    "image":"images/cards/google-play_2x.png",
    "title": "Policy Center: Ads",
    "summary": "Introduction to ads and system interference policies in Google Play.",
    "keywords": ["ads"],
    "type": "distribute",
    "category": "google play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/analytics/answer/2611404",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "Create Audience lists in Google Analytics",
    "summary": "Find out how to use your analytics data to discover high value users and create remarketing audiences to use in AdMob.",
    "keywords": ["ads, analytics, monetize"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://admob.blogspot.com/",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "Inside Admob",
    "summary": "Google’s official blog for news, tips, and information on the AdMob developer platform.",
    "keywords": ["ads, analytics, monetize"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/admob/answer/3111064",
    "timestamp": null,
    "image": "distribute/images/advertising.jpg",
    "title": "AdMob in-app conversion tracking",
    "summary": "Use in-app conversion tracking to attribute revenue back to your IAP promotion campaigns and determine which ones earn you the most.",
    "keywords": ["ads, analytics, conversions"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": ["monetize", "giftcards"],
    "url": "https://play.google.com/about/giftcards/",
    "timestamp": null,
    "image": "images/gp-balance.png",
    "title": "Google Play Gift Cards",
    "summary": "Buy Google Play gift cards online or at a variety of retail stores.",
    "keywords": ["gift card"],
    "type": "distribute",
    "category": "google play"
  },
  {
    "lang": "en",
    "group": "",
    "tags": ["monetize", "paymentmethods"],
    "url": "https://support.google.com/googleplay/answer/2651410",
    "timestamp": null,
    "image": "images/cards/google-play_2x.png",
    "title": "Google Play accepted payment methods",
    "summary": "Support details on the payment methods supported in Google Play.",
    "keywords": ["gift card"],
    "type": "distribute",
    "category": "google play"
  },
  {
   "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/adwords/answer/2471188",
    "timestamp": null,
    "image": "images/play_dev.jpg",
    "title": "AdWords Conversion Optimizer",
    "summary": "Learn how Conversion Optimizer works to find the users who are most likely to convert and to serve them your conversion ads.",
    "keywords": [],
    "type": "distribute",
    "titleFriendly": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/app-conversion-tracking/",
    "timestamp": null,
    "image": "images/play_dev.jpg",
    "title": "Track conversions with the AdWords SDK or server API",
    "summary": "Use the lightweight AdWords app SDK or server-to-server API to track remarketing conversions.",
    "keywords": [],
    "type": "distribute",
    "titleFriendly": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/analytics/answer/2611404",
    "timestamp": null,
    "image": "images/play_dev.jpg",
    "title": "Create Remarketing Audiences in Google Analytics",
    "summary": "Learn how to use preconfigured audiences created by the Analytics team or create your own to use in your conversion campaigns.",
    "keywords": [],
    "type": "distribute",
    "titleFriendly": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/adwords/answer/1704341",
    "timestamp": null,
    "image": "images/play_dev.jpg",
    "title": "Link your Google Analytics and AdWords accounts",
    "summary": "Gain greater insight into how AdWords is driving app engagement and conversions, and use this insight to improve your ads and app.",
    "keywords": [],
    "type": "distribute",
    "titleFriendly": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": ["plus", "social"],
    "url": "https://plus.google.com/+AndroidDevelopers/",
    "timestamp": null,
    "image": "images/plus.jpg",
    "title": "+Android Developers",
    "summary": "Sharing news, ideas, and techniques for success.",
    "keywords": ["+AndroidDevelopers"],
    "type": "develop",
    "category": "Social"
  },
  {
    "lang": "en",
    "group": "",
    "tags": ["plus", "social"],
    "url": "https://plus.google.com/+GooglePlay",
    "timestamp": null,
    "image": "images/cards/google-play_2x.png",
    "title": "+Google Play",
    "summary": "News and discussion about Google Play, apps, and other content in Google+.",
    "keywords": ["+GooglePlay"],
    "type": "distribute",
    "category": "Social"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/analytics/devguides/collection/android/",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "Mobile App Analytics SDK",
    "summary": "Measure everything about your app. Get started with the Google Analytics SDK for Android.",
    "keywords": ["analytics, user behavior"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/edu/guidelines",
    "timestamp": null,
    "image": "https://developer.android.com/distribute/images/edu-guidelines.jpg",
    "title": "Education Guidelines",
    "summary": "These guidelines and requirements help you develop great apps for students, which offer compelling content and an intuitive user experience on Android tablets.",
    "keywords": [],
    "type": "",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/edu/faq",
    "timestamp": null,
    "image": "https://developer.android.com/distribute/images/gpfe-faq.jpg",
    "title": "Education FAQ",
    "summary": "Answers to common questions you might have about Google Play for Education.",
    "keywords": [],
    "type": "",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/edu/",
    "timestamp": null,
    "image": "https://developers.google.com/edu/images/home-android.png",
    "title": "Chrome Apps in Google Play for Education",
    "summary": "Find out more about Chrome apps in Google Play for Education.",
    "keywords": [],
    "type": "",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://www.google.com/edu/tablets/#tablets-family",
    "timestamp": null,
    "image": "https://www.google.com/edu/images/tablets/big-tablet.png",
    "title": "Google Play for Education Tablets",
    "summary": "Google Play for Education leverages a diverse set up tablets approved for the classroom which may help inform you how to build educational apps.",
    "keywords": [],
    "type": "",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://storage.googleapis.com/androiddevelopers/shareables/stories/Glu_Deerhunter2014_gpgs.pdf",
    "timestamp": null,
    "image": "https://storage.googleapis.com/androiddevelopers/shareables/stories/Glu_Deerhunter2014_gpgs.png",
    "title": "Deer Hunter 2014 by Glu &mdash; Sign-in",
    "summary": "Glu finds that Google Play Game Services helps improve the user experience which leads to increased player happiness. They also find that Play Games Services signed in users tend to play longer and have a higher lifetime value.",
    "keywords": ["stories"],
    "type": "Case Study Deck",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://storage.googleapis.com/androiddevelopers/shareables/stories/ConcreteSoftware_PBABowling_gpgs.pdf",
    "timestamp": null,
    "image": "https://storage.googleapis.com/androiddevelopers/shareables/stories/ConcreteSoftware_PBABowling_gpgs.png",
    "title": "PBA® Bowling Challenge by Concrete Software &mdash; Quests",
    "summary": "Concrete Software finds that Google Play Game Services' quests are a great way to create new content for users that leads to higher engagement.",
    "keywords": ["stories"],
    "type": "Case Study Deck",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://storage.googleapis.com/androiddevelopers/shareables/stories/Dragonplay_DragonplaySlots_gpgs.pdf",
    "timestamp": null,
    "image": "https://storage.googleapis.com/androiddevelopers/shareables/stories/Dragonplay_DragonplaySlots_gpgs.png",
    "title": "Dragonplay Slots by Dragonplay &mdash; Sign-in",
    "summary": "Dragonplay finds that players who sign in with Google Play Games services tend to be high quality users who were highly engaged. They also tend to be easier to convert to paying users.",
    "keywords": ["stories"],
    "type": "Case Study Deck",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://storage.googleapis.com/androiddevelopers/shareables/stories/Gameloft_Asphalt8_gpgs.pdf",
    "timestamp": null,
    "image": "https://storage.googleapis.com/androiddevelopers/shareables/stories/Gameloft_Asphalt8_gpgs.png",
    "title": "Asphalt 8 by Gameloft &mdash; Friends invitations",
    "summary": "Gameloft finds that Google Play Game Services users are more engaged than the average Android user and more likely to convert to paying players.",
    "keywords": ["stories"],
    "type": "Case Study Deck",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://storage.googleapis.com/androiddevelopers/shareables/stories/Glu_EternityWarriors3_gpgs.pdf",
    "timestamp": null,
    "image": "https://storage.googleapis.com/androiddevelopers/shareables/stories/Glu_EternityWarriors3_gpgs.png",
    "title": "Eternity Warriors 3 by Glu &mdash; Gifting",
    "summary": "Glu finds that Google Play Game Services gifting outperforms other implementations (including those with incentives) because of its seamless flow and consistent performance.",
    "keywords": ["stories"],
    "type": "Case Study Deck",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://storage.googleapis.com/androiddevelopers/shareables/stories/HotheadGames_RivalsatWar_gpgs.pdf",
    "timestamp": null,
    "image": "https://storage.googleapis.com/androiddevelopers/shareables/stories/HotheadGames_RivalsatWar_gpgs.jpg",
    "title": "Rivals at War: Firefight by Hothead Games &mdash; Leaderboards",
    "summary": "Hothead Games is planning to include Google Play Game Services features in all their games going forwards after seeing that players that signed in with Play Games Services tend to show higher retention and a higher average revenue.",
    "keywords": ["stories"],
    "type": "Case Study Deck",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://storage.googleapis.com/androiddevelopers/shareables/stories/TMSOFT_Compulsive_gpgs.pdf",
    "timestamp": null,
    "image": "https://storage.googleapis.com/androiddevelopers/shareables/stories/TMSOFT_Compulsive_gpgs.png",
    "title": "Compulsive by TMSOFT &mdash; Cross-platform",
    "summary": "TMSOFT finds that users who authenticate with Play Games Services on Android and iOS play Compulsive twice as much and purchase in-app products over four times as much.",
    "keywords": ["stories"],
    "type": "Case Study Deck",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://storage.googleapis.com/androiddevelopers/shareables/stories/Noodlecake_SuperStickmanGolf2_gpgs.pdf",
    "timestamp": null,
    "image": "https://storage.googleapis.com/androiddevelopers/shareables/stories/Noodlecake_SuperStickmanGolf2_gpgs.png",
    "title": "Super Stickman Golf 2 by Noodlecake Studios &mdash; Multiplayer",
    "summary": "Noodlecake Studios finds that Google Play Game Services’ multiplayer feature helps reduce attrition.",
    "keywords": ["stories"],
    "type": "Case Study Deck",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://storage.googleapis.com/androiddevelopers/shareables/stories/TinyRebel_DoctorWhoLegacy_gpgs.pdf",
    "timestamp": null,
    "image": "https://storage.googleapis.com/androiddevelopers/shareables/stories/TinyRebelGames_DrWhoLegacy_pgps.png",
    "title": "Dr. Doctor Who: Legacy by Tiny Rebel Games &mdash; Achievements",
    "summary": "After integrating achievements and cloud services from Google Play Game Services, Tiny Rebel Games saw a dramatic increase in daily revenues as a result of an increase in daily installs and an increase in the average revenue per install.",
    "keywords": ["stories"],
    "type": "Case Study Deck",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://storage.googleapis.com/androiddevelopers/shareables/stories/Senri_LeosFortune_gpgs.pdf",
    "timestamp": null,
    "image": "https://storage.googleapis.com/androiddevelopers/shareables/stories/Senri_LeosFortune_gpgs.png",
    "title": "Leo’s Fortune by 1337 &amp; Senri &mdash; Saved games",
    "summary": "1337 + Senri finds that Google Play Game Services is easy to integrate and provides essential game functions like cloud saved games, achievements and leaderboards which have a very large adoption rate amongst players.",
    "keywords": ["stories"],
    "type": "Case Study Deck",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "shareables/auto/AndroidAuto-audio-apps.pdf",
    "timestamp": null,
    "image": "auto/images/assets/icons/media_app_playback.png",
    "title": "Android Auto Audio Apps UI Guidelines",
    "summary": "Guidelines for designing audio apps that work with Auto. ",
    "keywords": ["design", "Auto", "Automotive"],
    "type": "Design",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "shareables/auto/AndroidAuto-messaging-apps.pdf",
    "timestamp": null,
    "image": "auto/images/assets/icons/messaging_app_notifications.png",
    "title": "Android Auto Messaging Apps UI Guidelines",
    "summary": "Guidelines for designing messaging apps that work with Auto. ",
    "keywords": ["design", "Auto", "Automotive"],
    "type": "Design",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "shareables/auto/AndroidAuto-custom-colors.pdf",
    "timestamp": null,
    "image": "auto/images/ui/gearhead_generic_UI.png",
    "title": "Android Auto Color Customization UI Guidelines",
    "summary": "Guidelines for color-customizing apps that work with Auto. ",
    "keywords": ["design", "Auto", "Automotive"],
    "type": "Design",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "http://www.youtube.com/watch?v=RRelFvc6Czo",
    "timestamp": null,
    "image": "https://i1.ytimg.com/vi/RRelFvc6Czo/maxresdefault.jpg",
    "title": "Android Developer Story: Smule",
    "summary": "The creators of AutoRap, Magic Piano, and Songify talk about their experiences launching on Android and the explosive global growth they've seen on Google Play.",
    "keywords": ["success", "users"],
    "type": "video",
    "titleFriendly": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/analytics/solutions/mobile-implementation-guide",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "Mobile Analytics Implementation Guide",
    "summary": "Learn how you can implement additional Google Analytics features to better understand your users and their behavior.",
    "keywords": ["analytics", "Play", "users"],
    "type": "distribute",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://www.google.com/tagmanager/",
    "timestamp": null,
    "image": "https://www.google.com/tagmanager/images/gtm-hero-illustration-small.png",
    "title": "Google Tag Manager",
    "summary": "Google Tag Manager enables you to change configuration values in your mobile apps using the Google Tag Manager interface, without having to rebuild and resubmit application binaries to app marketplaces.",
    "keywords": ["analytics", "tagmanager"],
    "type": "distribute",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://analyticsacademy.withgoogle.com/course04",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "Mobile App Analytics Fundamentals",
    "summary": "This self-paced online course on mobile app measurement shows you how Google Analytics data can help you make your app more discoverable and profitable.",
    "keywords": ["analytics"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://github.com/googleanalytics/google-analytics-plugin-for-unity",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "Analytics Plugin for Unity",
    "summary": "If you're building games with Unity, you can now implement Analytics once and ship it on multiple platforms automatically.",
    "keywords": ["analytics", "unity"],
    "type": "Open Source Project",
    "category": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/analytics/devguides/collection/android/v4/enhanced-ecommerce",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "In-App Purchases & Ecommerce",
    "summary": "If your app sells virtual or real goods, ecommerce tracking can help you understand what behaviors lead to purchases.",
    "keywords": ["analytics, ecommerce"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/analytics/answer/1032415",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "Goals",
    "summary": "Track important actions in your app as goals and measure performance against your objectives.",
    "keywords": ["analytics"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/analytics/answer/2568874?ref_topic=6012392",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "Active Users",
    "summary": "The active user report displays your 1-day, 7-day, 14-day and 30-day trailing active users next to each other, to help you analyze performance over time.",
    "keywords": ["analytics"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/analytics/devguides/collection/android/v4/events",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "Events",
    "summary": "Events let you measure granular in-app activities and understand user journeys.",
    "keywords": ["analytics"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/analytics/devguides/collection/android/v4/customdimsmets",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "Custom Dimensions",
    "summary": "Custom dimensions enable the association of metadata with hits, users, and sessions in Google Analytics.",
    "keywords": ["analytics"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/analytics/devguides/collection/android/v4/user-id",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "User ID",
    "summary": "The User ID feature enables Google Analytics to measure user activities that span across devices.",
    "keywords": ["analytics"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/analytics/devguides/collection/android/v4/display-features",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "Demographic Reporting",
    "summary": "By enabling display features, you can see just how different user segments engage and monetize.",
    "keywords": ["analytics"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/analytics/answer/3123906",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "User Segmentation",
    "summary": "Segments let you compare metrics for different subsets of users to identify trends and opportunities for your apps.",
    "keywords": ["analytics"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/analytics/devguides/collection/android/v4/campaigns",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "Campaign Tracking",
    "summary": "Measuring campaigns in Google Analytics enables the attribution of campaigns and traffic sources to user activity within your app.",
    "keywords": ["analytics"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/analytics/answer/2956981",
    "timestamp": null,
    "image": "images/cards/google-play_2x.png",
    "title": "Google Play Integration",
    "summary": "By linking Analytics and the Play Developer Console, you can gain additional insights into the acquisition flow.",
    "keywords": ["play, analytics"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/analytics/answer/1033961",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "AdWords Integration",
    "summary": "Link Analytics and AdWords to see the entire picture of customer behavior, from ad click or impression through your site to conversion. ",
    "keywords": ["adwords, analytics"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/analytics/devguides/collection/android/v4/campaigns#google-play-url-builder",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "Campaign URL builder for Google Play",
    "summary": "Easily create your URLs to track install campaigns.",
    "keywords": ["play, analytics"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/tagmanager/answer/6003007",
    "timestamp": null,
    "image": "https://www.google.com/tagmanager/images/gtm-hero-illustration-small.png",
    "title": "In-App A/B Testing",
    "summary": "With content experiments in Google Tag Manager you can test multiple variations of your app to find which works best.",
    "keywords": ["tagmanager"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/analytics/answer/2785577",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "Behavior Flow",
    "summary": "The Behavior Flow report visualizes the path users traveled from one Screen or Event to the next. This report can help you discover what content keeps users engaged with your app.",
    "keywords": ["analytics"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/analytics/answer/1151300",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "Custom Reports",
    "summary": "Custom Reports let you create your own reports in your Google Analytics account.",
    "keywords": ["analytics"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/analytics/answer/2611268",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "Audience Lists &amp; Remarketing",
    "summary": "Remarketing with Google Analytics lets you deliver targeted ads to users who've already been to your site or app. You can even base those ads on the behavior those users displayed during their sessions.",
    "keywords": ["analytics"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/admob/answer/3508177",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "AdMob Integration",
    "summary": "With Google Analytics in AdMob, you can view Google Analytics data for your linked apps from within your AdMob account.",
    "keywords": ["analytics"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/analytics/solutions/mobile-campaign-deep-link",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "Deep-Linking",
    "summary": "Google Analytics gives you a full view of how returning users are interacting with your app, for a holistic view beyond the install.",
    "keywords": ["analytics"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/admob/answer/3508177",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "AdMob Integration",
    "summary": "With Google Analytics in AdMob, you can view Google Analytics data for your linked apps from within your AdMob account.",
    "keywords": ["analytics"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/analytics/answer/2568874",
    "timestamp": null,
    "image": "images/cards/analytics-mobile_2x.jpg",
    "title": "Active User Report",
    "summary": "Active user report displays your 1-day, 7-day, 14-day and 30-day trailing active users next to each other, to help you run benchmark analyses of their performance over time.",
    "keywords": ["analytics"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://www.google.com/design/spec/animation/",
    "timestamp": null,
    "image": "images/cards/material-animation_2x.png",
    "title": "Animation",
    "summary": "",
    "keywords": [],
    "type": "design",
    "category": "material design"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://www.google.com/design/spec/style/",
    "timestamp": null,
    "image": "images/cards/material-style_2x.jpg",
    "title": "Style",
    "summary": "",
    "keywords": [],
    "type": "design",
    "category": "material design"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://www.google.com/design/spec/layout/",
    "timestamp": null,
    "image": "images/cards/material-layout_2x.png",
    "title": "Layout",
    "summary": "",
    "keywords": [],
    "type": "design",
    "category": "material design"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://www.google.com/design/spec/components/",
    "timestamp": null,
    "image": "images/cards/material-components_2x.jpg",
    "title": "Components",
    "summary": "",
    "keywords": [],
    "type": "design",
    "category": "material design"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://www.google.com/design/spec/patterns/",
    "timestamp": null,
    "image": "images/cards/material-patterns_2x.png",
    "title": "Patterns",
    "summary": "",
    "keywords": [],
    "type": "design",
    "category": "material design"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://material.google.com/patterns/notifications.html",
    "timestamp": "1469639720",
    "image": "images/cards/card-notifications_2x.png",
    "title": "Notifications",
    "summary": "Notifications inform your app’s users about relevant and timely events in your app.",
    "keywords": ["notifications", "design"],
    "type": "design",
    "category": "material design"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://www.google.com/design/spec/usability/",
    "timestamp": null,
    "image": "images/cards/material-usability_2x.png",
    "title": "Usability",
    "summary": "",
    "keywords": [],
    "type": "design",
    "category": "material design"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://www.google.com/design/spec/resources/color-palettes.html",
    "timestamp": null,
    "image": "images/cards/material-color-palette_2x.jpg",
    "title": "Color Palettes",
    "summary": "",
    "keywords": [],
    "type": "design",
    "category": "material design"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://www.google.com/design/spec/resources/layout-templates.html",
    "timestamp": null,
    "image": "images/cards/material-layout-template_2x.jpg",
    "title": "Layout Templates",
    "summary": "",
    "keywords": [],
    "type": "design",
    "category": "material design"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://www.google.com/design/spec/resources/sticker-sheets-icons.html",
    "timestamp": null,
    "image": "images/cards/material-sticker-sheet_2x.jpg",
    "title": "Sticker Sheets & Icons",
    "summary": "",
    "keywords": [],
    "type": "design",
    "category": "material design"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://www.google.com/design/spec/resources/roboto-noto-fonts.html",
    "timestamp": null,
    "image": "images/cards/material-typography_2x.jpg",
    "title": "Typography: Roboto and Noto Sans fonts",
    "summary": "",
    "keywords": [],
    "type": "design",
    "category": "material design"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [
      "icons",
      "material",
      "iconography"
    ],
    "url": "https://www.google.com/design/icons/index.html",
    "timestamp": null,
    "image": "images/cards/card-material-icons-16x9_2x.jpg",
    "title": "Material icon collection",
    "summary": "",
    "keywords": ["icons"],
    "type": "design",
    "category": "material design"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/adwords/answer/6032059",
    "timestamp": null,
    "image": "distribute/images/advertising.jpg",
    "title": "Setting up Mobile App Install Ads",
    "summary": "With Mobile app installs campaigns on the Search and Display Networks, and TrueView for mobile app promotion on YouTube, you can create custom app install ads that run exclusively on phones and tablets.",
    "keywords": ["marketing", "admob"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/nearby/",
    "timestamp": null,
    "image": "images/play_dev.jpg",
    "title": "Create features based on proximity",
    "summary": "Build simple interactions between nearby devices and people.",
    "keywords": ["nearby", "engage"],
    "type": "distribute",
    "titleFriendly": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://www.youtube.com/watch?v=hultDpBS22s",
    "timestamp": null,
    "image": "images/play_dev.jpg",
    "title": "Use Nearby Messages to collaborate",
    "summary": "Nearby Messages is perfect for setting up ad-hoc groups, collaborative sessions, or sharing resources with people in a co-located space.",
    "keywords": ["nearby", "engage"],
    "type": "distribute",
    "titleFriendly": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/beacons",
    "timestamp": null,
    "image": "images/play_dev.jpg",
    "title": "Mark up the world using beacons",
    "summary": "Give your users better location and proximity experiences by providing a strong context signal for their devices in the form of Bluetooth low energy (BLE) beacons with Eddystone.",
    "keywords": ["nearby", "engage"],
    "type": "distribute",
    "titleFriendly": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/adwords/answer/6167164",
    "timestamp": null,
    "image": "distribute/images/advertising.jpg",
    "title": "Best practices for Mobile App Engagement",
    "summary": "Learn how to market to your user base to drive re-engagement with your app. ",
    "keywords": ["marketing", "admob"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [
      "marketing",
      "engagement",
      "adwords1"
    ],
    "url": "https://support.google.com/adwords/answer/6032073",
    "timestamp": null,
    "image": "https://www.gstatic.com/images/icons/material/product/2x/adwords_64dp.png",
    "title": "Setting up Mobile App Engagement Ads",
    "summary": "Mobile app engagement campaigns are a great choice for advertisers focused on connecting with people who already have their app.",
    "keywords": [
      "marketing",
      "engagement",
      "adwords"
    ],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [
      "marketing",
      "engagement",
      "translate"
    ],
    "url": "https://support.google.com/l10n/answer/6359997",
    "timestamp": null,
    "image": "images/play_dev.jpg",
    "title": "Use the App Translation Service",
    "summary": "The App Translation Service is a human translation service. It makes it easy to order translations for app UI strings, Play Store text, in-app purchase products, and universal app campaign ads.",
    "keywords": [
      "marketing",
      "engagement",
      "translate"
    ],
    "type": "distribute",
    "titleFriendly": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [
      "marketing",
      "engagement"
    ],
    "url": "https://support.google.com/adwords/answer/6167162",
    "timestamp": null,
    "image": "https://www.gstatic.com/images/icons/material/product/2x/adwords_64dp.png",
    "title": "Best Practices for Mobile App Installs",
    "summary": "Getting your mobile app discovered can be challenging. Learn how to drive downloads of your app and grow a valuable user base.",
    "keywords": ["marketing", "adwords"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/admob/topic/2784623",
    "timestamp": null,
    "image": "distribute/images/advertising.jpg",
    "title": "Set up your AdMob account",
    "summary": "Setting up your AdMob account in the right way will help you get the most value, check out the Setup and Basics guide.",
    "keywords": ["marketing", "admob"],
    "type": "distribute",
    "category": "google"
    },
    {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://analyticsacademy.withgoogle.com/mobile-app",
    "timestamp": null,
    "image": "distribute/images/advertising.jpg",
    "title": "Analytics Academy for Mobile Apps",
    "summary": "Learn how to use Google Analytics to make your app more discoverable and profitable.",
    "keywords": ["marketing", "analytics"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://www.udacity.com/courses/ud876-3",
    "timestamp": null,
    "image": "distribute/images/advertising.jpg",
    "title": "Learn how to show ads in your Android app",
    "summary": "Take this online course to learn how to use AdMob to display ads in your Android app.",
    "keywords": ["marketing", "analytics"],
    "type": "distribute",
    "titleFriendly": ""
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/mobile-ads-sdk/download",
    "timestamp": null,
    "image": "distribute/images/advertising.jpg",
    "title": "Admob Ads",
    "summary": "Use the Mobile Ads SDK to start showing AdMob ads in your apps.",
    "keywords": ["marketing", "adwords"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/admob/",
    "timestamp": null,
    "image": "distribute/images/advertising.jpg",
    "title": "AdMob Help Center",
    "summary": "For setup assistance, general info, and fixes for specific problems check out the AdMob Help Center.",
    "keywords": ["admob"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://support.google.com/admob/answer/2753860",
    "timestamp": null,
    "image": "distribute/images/advertising.jpg",
    "title": "AdMob Policy Guidelines",
    "summary": "Learn about best practices for displaying AdMob ads in your apps to maximize revenue.",
    "keywords": ["admob"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/app-invites/",
    "timestamp": 1383243492000,
    "image": "images/cards/google-search_2x.png",
    "title": "Set up App Invites",
    "summary": "Bring new users to your apps with personal recommendations, incentives, and offers.",
    "keywords": ["invites", "appinvites", "engagement", "getusers"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/app-indexing/",
    "timestamp": 1383243492000,
    "image": "images/cards/google-search_2x.png",
    "title": "Set Up App Indexing",
    "summary": "Surface your app content in Google search. Deep link direct to your apps.",
    "keywords": ["search", "appindexing", "engagement", "getusers"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/app-indexing/webmasters/details",
    "timestamp": null,
    "image": "images/cards/google-search_2x.png",
    "title": "Index your app",
    "summary": "Index your app today by adding deep links and verifying its official web site to ensure it starts appearing in Google Search results. ",
    "keywords": ["appindexing","search","getusers"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/identity/sign-in/android/people",
    "timestamp": 1383243492000,
    "image": "images/cards/google-sign-in_2x.png",
    "title": "Get User Profile Details",
    "summary": "After users sign-in with Google, you can access their age range, language, and public profile information.",
    "keywords": ["signin", "identity", "google"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/identity/sign-in/android/",
    "timestamp": "",
    "image": "images/cards/google-sign-in_2x.png",
    "title": "Google Sign-In",
    "summary": "Discover how you can enhance user experiences on your website or in your app using information provided by their Google identity.",
    "keywords": ["signin", "identity", "google"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/+/features/play-installs",
    "timestamp": 1383243492000,
    "image": "images/cards/google-sign-in_2x.png",
    "title": "Over-the-air installs",
    "summary": "Follow this step-by-step guide to quickly add Google Sign-in and over-the-air app installs to your website.",
    "keywords": ["signin", "google", "installs"],
    "type": "distribute",
    "category": "google"
  },
  {
    "lang": "en",
    "group": "",
    "tags": [],
    "url": "https://developers.google.com/+/features/analytics",
    "timestamp": 1383243492000,
    "image": 'images/google/gps-googleplus.png',
    "title": "Google+ Insights",
    "summary": "Measure impressions of the over-the-air install prompt, resulting installs, and success rate by day, week, and month.",
    "keywords": ["signin", "identity"],
    "type": "distribute",
    "category": "google"
  },

 // Online courses

 {
    "title":"UX Design for Mobile Developers",
    "category":"online course",
    "summary":"Learn how to design a 5-star app.",
    "url":"https://www.udacity.com/course/ud849",
    "group":"",
    "keywords": ["mobile","ux","design"],
    "tags": ["courses, start"],
    "image":"images/cards/courses/mobile_ux_course.jpg",
    "lang":"en",
    "type":"design"
  },
  {
    "title":"Developing Android Apps",
    "category":"online course",
    "summary":"Learn Android and build an app!",
    "url":"https://www.udacity.com/course/ud853",
    "group":"",
    "keywords": ["android", "start","firstapp","sdk"],
    "tags": ["courses, start"],
    "image":"images/cards/courses/android_fundamentals_course.jpg",
    "lang":"en",
    "type":"develop"
  },
  {
    "title":"Android Performance",
    "category":"online course",
    "summary":"Optimize your apps for speed and usability.",
    "url":"https://www.udacity.com/course/ud825",
    "group":"",
    "keywords": ["android, performance","battery"],
    "tags": ["courses, performance"],
    "image":"images/cards/courses/android_performance_course.jpg",
    "lang":"en",
    "type":"develop"
  },
  {
    "title":"Enroll in the Android Nanodegree",
    "category":"online course",
    "summary":"Enroll in the Android Nanodegree to build the skills to work as an Android developer.",
    "url":"https://www.udacity.com/android",
    "group":"",
    "keywords": ["android, nanodegree"],
    "tags": ["courses"],
    "image":"images/cards/courses/android_nanodegree.png",
    "lang":"en",
    "type":"develop"
  },
  {
    "title":"Advanced Android App Development",
    "category":"online course",
    "summary":"Productionize and publish your apps.",
    "url":"https://www.udacity.com/course/ud855",
    "group":"",
    "keywords": ["android, experts"],
    "tags": ["courses, expert"],
    "image":"images/cards/courses/advanced_android_course.jpg",
    "lang":"en",
    "type":"develop"
  },
  {
    "title":"Material Design for Android Developers",
    "category":"online course",
    "summary":"Learn how to make your apps material.",
    "url":"https://www.udacity.com/course/ud862",
    "group":"",
    "keywords": ["android, design, pure, material"],
    "tags": ["courses, start, material"],
    "image":"images/cards/courses/android_design_course.jpg",
    "lang":"en",
    "type":"design"
  },
  {
    "title":"Android for Beginners",
    "category":"online course",
    "summary":"Make your first Android app, even if you don't write code.",
    "url":"https://www.udacity.com/course/ud837",
    "group":"",
    "keywords": ["android, sdk, firstapp"],
    "tags": ["courses, start"],
    "image":"images/cards/courses/beginning_android_course.jpg",
    "lang":"en",
    "type":"develop"
  },
  {
    "title":"Gradle for Android and Java",
    "category":"online course",
    "summary":"Build better apps through automation",
    "url":"https://www.udacity.com/course/ud867",
    "group":"",
    "keywords": ["gradle","studio", "sdk"],
    "tags": ["courses, gradle, sdk"],
    "image":"images/cards/courses/gradle_course.jpg",
    "lang":"en",
    "type":"develop"
  },
  {
    "title":"Add Location and Context to your app",
    "category":"online course",
    "summary":"Make Your Android App Location Aware.",
    "url":"https://www.udacity.com/course/ud876-1",
    "group":"",
    "keywords": ["google services, context, location"],
    "tags": ["courses, google, location, context"],
    "image":"images/cards/courses/android_location_course.png",
    "lang":"en",
    "type":"develop"
  },
  {
    "title":"Analytics and Tag Manager for Android",
    "category":"online course",
    "summary":"Use Analytics and Tag Manager in Your Apps.",
    "url":"https://www.udacity.com/course/ud876-2",
    "group":"",
    "keywords": ["google services, analytics, tag manager"],
    "tags": ["courses, google, analytics"],
    "image":"images/cards/courses/android_analytics_course.png",
    "lang":"en",
    "type":"distribute"
  },
  {
    "title":"AdMob for Android",
    "category":"online course",
    "summary":"Monetize Your App by Displaying Ads.",
    "url":"https://www.udacity.com/course/ud876-3",
    "group":"",
    "keywords": ["monetize, google services, ads, admob"],
    "tags": ["courses, google, ads, admob"],
    "image":"images/cards/courses/admob_course.png",
    "lang":"en",
    "type":"distribute"
  },
  {
    "title":"Add Maps to your Android app",
    "category":"online course",
    "summary":"Use maps, cameras, markers and more in your app.",
    "url":"https://www.udacity.com/course/ud876-4",
    "group":"",
    "keywords": ["google, maps, marker, camera"],
    "tags": ["courses, google, maps"],
    "image":"images/cards/courses/android_maps_course.png",
    "lang":"en",
    "type":"develop"
  },
  {
    "title":"Add Sign-in to your Android app",
    "category":"online course",
    "summary":"Build a Seamless Sign-In Experience.",
    "url":"https://www.udacity.com/course/ud876-5",
    "group":"",
    "keywords": ["google services, signin, authorization"],
    "tags": ["courses, google, auth"],
    "image":"images/cards/courses/android_identity_course.png",
    "lang":"en",
    "type":"develop"
  },
  {
    "title":"Android Wear Development",
    "category":"online course",
    "summary":"Extend your Apps to Android Smartwatches.",
    "url":"https://www.udacity.com/course/ud875A",
    "group":"",
    "keywords": ["wear, wearables, smartwatch"],
    "tags": ["courses, wear, wearable"],
    "image":"images/cards/courses/android_wear_course.jpg",
    "lang":"en",
    "type":"develop"
  },
  {
    "title":"Android TV and Google Cast Development",
    "category":"online course",
    "summary":"Extend your Apps to the Big Screen.",
    "url":"https://www.udacity.com/course/ud875B",
    "group":"",
    "keywords": ["cast, living room"],
    "tags": ["courses, cast, tv"],
    "image":"images/cards/courses/android_tv_cast_course.jpg",
    "lang":"en",
    "type":"develop"
  },
  {
    "title":"Android Auto Development",
    "category":"online course",
    "summary":"Put your apps in the driver's seat.",
    "url":"https://www.udacity.com/course/ud875C",
    "group":"",
    "keywords": ["auto"],
    "tags": ["courses, auto"],
    "image":"images/cards/courses/android_auto_course.jpg",
    "lang":"en",
    "type":"develop"
  },


 // TODO remove this?
  {
    "title":"Android Wear Materials",
    "category":"design",
    "summary":"Drag and drop your way to beautifully designed Android Wear apps.",
    "url":"design/downloads/index.html#Wear",
    "group":"",
    "keywords": ["icons","stencils","color swatches"],
    "tags": ["icons","stencils","colorswatches"],
    "image":"images/cards/android-wear-materials_2x.jpg",
    "lang":"en",
    "type":"video"
  },
  {
    "title":"Watch Faces for Android Wear",
    "category":"design",
    "summary":"Watch faces let you customize the most prominent UI feature of Android wearables. The API is simple enough for rapid development and flexible enough to build something awesome.",
    "url":"https://www.youtube.com/watch?v=AK38PJZmIW8&list=PLWz5rJ2EKKc-kIrPiq098QH9dOle-fLef",
    "group":"",
    "keywords": ["wear", "wearable", "watch face"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/AK38PJZmIW8/maxresdefault.jpg",
    "lang":"en",
    "type":"video"
  },
  {
    "title":"Android Support Library",
    "category":"Tools",
    "summary":"These essential components help you build a great app that works on the huge variety of Android devices, faster.",
    "url":"https://www.youtube.com/watch?v=3PIc-DuEU2s&list=PLWz5rJ2EKKc9e0d55YHgJFHXNZbGHEXJX",
    "group":"",
    "keywords": ["support", "compatibility"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/3PIc-DuEU2s/maxresdefault.jpg",
    "lang":"en",
    "type":"video"
  },
  {
    "title":"Consistent Design with the AppCompat Support Library",
    "category":"design",
    "summary":"Getting a great looking app doesn't have to be hard: AppCompat, part of the Android Support Library, gives you a consistent design baseline that works on all Android 2.1 or higher devices.",
    "url":"https://www.youtube.com/watch?v=5Be2mJzP-Uw&list=PLWz5rJ2EKKc9e0d55YHgJFHXNZbGHEXJX",
    "group":"",
    "keywords": ["support", "compatibility","design-code"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/5Be2mJzP-Uw/maxresdefault.jpg",
    "lang":"en",
    "type":"video"
  },
  {
    "title":"Introducing Gradle",
    "category":"tools",
    "summary":"Android Studio uses an entirely new and flexible Gradle-based build system. You will be able to create multiple build variants for a single project, manage library dependencies and always be sure that your application builds correctly across different environments.",
    "url":"https://www.youtube.com/watch?v=cD7NPxuuXYY&list=PLWz5rJ2EKKc8I9gHTMh5yKkwRRGE8BjbQ",
    "group":"",
    "keywords": ["tools", "studio","gradle"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/cD7NPxuuXYY/maxresdefault.jpg",
    "lang":"en",
    "type":"video"
  },
  {
    "title":"Android Studio Layout Editor",
    "category":"tools",
    "summary":"Android Studio includes a rich, visual layout editor that helps developers create better user interfaces. It eliminates the need to deploy the APK on a real device with each change, making iterations faster and helping eliminate common errors earlier in the development process.",
    "url":"https://www.youtube.com/watch?v=JLLnhwtDoHw&list=PLWz5rJ2EKKc8I9gHTMh5yKkwRRGE8BjbQ",
    "group":"",
    "keywords": ["tools", "studio","layout"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/JLLnhwtDoHw/maxresdefault.jpg",
    "lang":"en",
    "type":"video"
  },
  {
    "title":"Debugging and testing in Android Studio",
    "category":"tools",
    "summary":"Learn about new debugger features in Android Studio 1.2: value inlining, quick access to referring objects and a Java .class decompiler, just to name a few. See some new tools and views that let you monitor the CPU and memory performance of your app from within the IDE. ",
    "url":"https://www.youtube.com/watch?v=2I6fuD20qlY&list=PLWz5rJ2EKKc8I9gHTMh5yKkwRRGE8BjbQ",
    "group":"",
    "keywords": ["tools", "studio","debugging","profiling","performance"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/2I6fuD20qlY/maxresdefault.jpg",
    "lang":"en",
    "type":"video"
  },
  {
    "title":"Scale with Google Cloud Platform",
    "category":"google",
    "summary":"Build, test, and deploy applications on Google's highly-scalable and reliable infrastructure for your web, mobile and backend solutions.",
    "url":"https://cloud.google.com/docs/",
    "group":"",
    "keywords": [],
    "tags": [],
    "image":"images/cards/cloud-platform_2x.png",
    "lang":"en",
    "type":"distribute"
  },
  {
    "title":"Opportunities & Programs",
    "category":"Google Play",
    "summary":"Take advantage of the many ways you can distribute your app to consumers, students, and businesses through Google Play.",
    "url":"distribute/googleplay/index.html#opportunities",
    "group":"",
    "keywords": [],
    "tags": [],
    "image":"images/cards/program-edu_2x.jpg",
    "lang":"en",
    "type":"distribute"
  },
  {
    "title":"Android for Work",
    "titleFriendly":"",
    "summary": "Develop apps for Android for Work to take advantage of security and management features built into Android.",
    "url":"https://developer.android.com/work",
    "group":"",
    "keywords": ["work", "enterprise", "emm"],
    "tags": [],
    "image":"images/work/cards/briefcase_600px.png",
    "lang":"en",
    "type":"work"
  },
  {
    "title":"Android for Work Developer Overview",
    "titleFriendly":"",
    "summary": "Learn how to build Android apps for the enterprise and take advantage of Google's Android for Work program.",
    "url":"https://developer.android.com/work/overview.html",
    "group":"",
    "keywords": ["work", "enterprise", "emm"],
    "tags": [],
    "image":"images/work/cards/briefcase_600px.png",
    "lang":"en",
    "type":"guide"
  },
  {
    "title":"Android for Work Developer Guide",
    "titleFriendly":"",
    "summary": "Android for Work provides organizations with a secure, flexible, and unified Android mobility platform combining devices, applications, and management.",
    "url":"https://developer.android.com/work/guide.html",
    "group":"",
    "keywords": ["work", "enterprise", "emm"],
    "tags": [],
    "image":"images/work/cards/android-studio_600px.png",
    "lang":"en",
    "type":"guide"
  },
  {
    "title":"Set up Managed Configurations",
    "titleFriendly":"",
    "summary": "Learn how to implement managed configurations that can be changed by other apps on the same device.",
    "url":"https://developer.android.com/work/managed-restrictions.html",
    "group":"",
    "keywords": ["work", "enterprise", "emm"],
    "tags": [],
    "image":"images/work/cards/briefcase_600px.png",
    "lang":"en",
    "type":"guide"
  },
  {
    "title":"Set up Managed Profiles",
    "titleFriendly":"",
    "summary": "Learn how to make sure your apps operate smoothly in a corporate environment by following some best practices.",
    "url":"https://developer.android.com/work/managed-profiles.html",
    "group":"",
    "keywords": ["work", "enterprise", "emm"],
    "tags": [],
    "image":"images/work/cards/briefcase_600px.png",
    "lang":"en",
    "type":"guide"
  },
  {
    "title":"Set up Single-Purpose Devices",
    "titleFriendly":"",
    "summary": "Learn how to develop single-use solutions for Android devices.",
    "url":"https://developer.android.com/work/cosu.html",
    "group":"",
    "keywords": ["work", "enterprise", "emm"],
    "tags": [],
    "image":"images/work/cards/briefcase_600px.png",
    "lang":"en",
    "type":"guide"
  },
  {
    "title":"Join the Android for Work DevHub",
    "titleFriendly":"",
    "summary":"The Android for Work DevHub is a place to help developers keep up with Android in the workplace.",
    "url":"https://www.google.com/work/android/developers/applyDevHub/",
    "group":"",
    "keywords": ["work", "enterprise", "isv", "devhub"],
    "tags": [],
    "image":"images/work/cards/work-devhub_600px.png",
    "lang":"en",
    "type":"Community"
  },
  {
    "title":"Enterprise Mobility Managers",
    "titleFriendly":"",
    "summary":"Integrate Android for Work into your enterprise mobility management (EMM) solution.",
    "url":"https://developers.google.com/android/work/",
    "group":"",
    "keywords": ["work", "enterprise", "emm"],
    "tags": [],
    "image":"images/work/cards/work-cloud_600px.png",
    "lang":"en",
    "type":"guide"
  },
  {
    "title":"Learn More About Android for Work",
    "titleFriendly":"",
    "summary":"Learn more about how Android for Work makes your favorite phones and tablets the perfect business tools.",
    "url":"https://www.google.com/work/android/",
    "group":"",
    "keywords": ["work", "enterprise", "emm"],
    "tags": [],
    "image":"images/work/cards/work-profile_600px.png",
    "lang":"en",
    "type":"about"
  },
  {
    "title":"Build a Device Policy Controller",
    "titleFriendly":"",
    "summary":"Learn how to develop a Device Policy Controller to create and administer a managed profile on an employee's device.",
    "url":"https://developers.google.com/android/work/build-dpc",
    "group":"",
    "keywords": ["work", "enterprise", "emm"],
    "tags": [],
    "image":"images/work/cards/work-folder_600px.png",
    "lang":"en",
    "type":"guide"
  },
  {
    "title":"Android for Work for Developers",
    "titleFriendly":"",
    "summary":"Watch the videos in this playlist to understand more about Android for Work and get tips on developing enterprise apps.",
    "url":"https://www.youtube.com/watch?v=jQWB_-o1kz4&list=PLOU2XLYxmsIKAK2Bhv19H2THwF-22O5WX",
    "group":"",
    "keywords": ["work", "enterprise", "emm"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/jQWB_-o1kz4/maxresdefault.jpg",
    "lang":"en",
    "type":"youtube"
  },
  {
    "title":"App Configurations, Testing and Launchers",
    "titleFriendly":"",
    "summary":"With Android for Work you can make your apps remotely configurable. We also cover how to test your app in a managed environment.",
    "url":"https://www.youtube.com/watch?v=39NkpWkaH8M&index=2&list=PLOU2XLYxmsIKAK2Bhv19H2THwF-22O5WX",
    "group":"",
    "keywords": ["work", "enterprise", "emm"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/39NkpWkaH8M/maxresdefault.jpg",
    "lang":"en",
    "type":"youtube"
  },
  {
    "title":"Building an Enterprise Ready App",
    "titleFriendly":"",
    "summary":"A holistic view of Android for Work for developers.",
    "url":"https://www.youtube.com/watch?v=dH41OutAMNM&list=PLOU2XLYxmsIKAK2Bhv19H2THwF-22O5WX",
    "group":"",
    "keywords": ["work", "enterprise", "emm"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/dH41OutAMNM/maxresdefault.jpg",
    "lang":"en",
    "type":"youtube"
  },
  {
    "title":"Android for Work: Single Use Devices",
    "titleFriendly":"",
    "summary":"Single-purpose computers are everywhere, and Android can meet that need.",
    "url":"https://www.youtube.com/watch?v=j3QC6hcpy90",
    "group":"",
    "keywords": ["work", "enterprise", "emm"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/j3QC6hcpy90/maxresdefault.jpg",
    "lang":"en",
    "type":"youtube"
  },
  {
    "title":"Your Apps at Work",
    "titleFriendly":"",
    "summary":"In this Google I/O 2016 session we’ll give you details for making your app more attractive to businesses.",
    "url":"https://www.youtube.com/watch?v=Za0OQo8DRM4",
    "group":"",
    "keywords": ["work", "enterprise", "emm"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/Za0OQo8DRM4/maxresdefault.jpg",
    "lang":"en",
    "type":"youtube"
  },
  {
    "title":"Discover YouTube cards",
    "category":"google",
    "summary":"Find out more about YouTube cards, the options available, and how to use them to get the most from your YouTube content.",
    "url":"https://support.google.com/youtube/answer/6140493",
    "group":"",
    "keywords": ["youtube", "video", "users", "installs"],
    "tags": [],
    "image":"images/cards/card-youtube_2x.png",
    "lang":"en",
    "type":"distribute"
  },
    {
    "title":"What is YouTube account good standing?",
    "category":"Google",
    "summary":"Learn what it means for an account to be in good standing from the YouTube Help Center.",
    "url":"https://support.google.com/youtube/answer/2797387",
    "group":"",
    "keywords": ["youtube", "video", "users", "installs"],
    "tags": [],
    "image":"images/cards/card-youtube_2x.png",
    "lang":"en",
    "type":"distribute"
  },
  {
    "title":"What’s New in Android N Developer Preview",
    "category":"preview",
    "summary":"Learn all about the new features in the Android N Preview.",
    "url":"https://www.youtube.com/watch?v=CsulIu3UaUM",
    "group":"",
    "keywords": ["androidn"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/CsulIu3UaUM/maxresdefault.jpg",
    "lang":"en",
    "type":"youtube"
  },
  {
    "title":"Developing for Android 6.0 (Marshmallow)",
    "category":"",
    "summary":"This video covers how to get started with the preview, important APIs to test and how to provide feedback on the preview.",
    "url":"https://www.youtube.com/watch?v=yYU4DHLwoRk",
    "group":"",
    "keywords": ["Marshmallow"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/yYU4DHLwoRk/maxresdefault.jpg",
    "lang":"en",
    "type":"video"
  },
  {
    "title":"Google I/O 2015 - What's new in Android",
    "category":"",
    "summary":"This session will highlight the most exciting new developer features of the Android platform.",
    "url":"https://www.youtube.com/watch?v=ndBdf1_oOGA",
    "group":"",
    "keywords": ["Marshmallow"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/ndBdf1_oOGA/maxresdefault.jpg",
    "lang":"en",
    "type":"video"
  },
  {
    "title":"Fingerprint and payments APIs",
    "category":"",
    "summary":"New fingerprint and payments APIs are introduced in M, to enable enhanced UX and security for online purchasing, banking, and retail payments.",
    "url":"https://www.youtube.com/watch?v=VOn7VrTRlA4",
    "group":"",
    "keywords": ["Marshmallow"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/VOn7VrTRlA4/maxresdefault.jpg",
    "lang":"en",
    "type":"video"
  },
  {
    "title":"Introduction to Voice Interaction API",
    "category":"",
    "summary":"This video covers how to use the Voice Interaction API to support system or custom voice actions.",
    "url":"https://www.youtube.com/watch?v=OW1A4XFRuyc",
    "group":"",
    "keywords": ["Marshmallow"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/OW1A4XFRuyc/maxresdefault.jpg",
    "lang":"en",
    "type":"video"
  },
  {
    "title":"Android Auto Backup for Apps",
    "category":"",
    "summary":"Android Backup is the automatic, cloud-based backup and restore of users’ apps when they set up a new device.",
    "url":"https://www.youtube.com/watch?v=HXacyy0HSW0",
    "group":"",
    "keywords": ["Marshmallow"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/HXacyy0HSW0/maxresdefault.jpg",
    "lang":"en",
    "type":"video"
  },
  {
    "title":"New APIs in M for Android for Work",
    "category":"",
    "summary":"Android M extends Android for Work functionality with a new set of APIs for Enterprise Mobility Management providers to offer new features and policy controls to IT Departments.",
    "url":"https://www.youtube.com/watch?v=vcSj8ln-BlE",
    "group":"",
    "keywords": ["Marshmallow"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/vcSj8ln-BlE/maxresdefault.jpg",
    "lang":"en",
    "type":"Video"
  },
  {
    "title":"Android for Work: Single Use Devices",
    "category":"",
    "summary":"Android M is bringing the power of Android to all kinds of workplaces.",
    "url":"https://www.youtube.com/watch?v=j3QC6hcpy90",
    "group":"",
    "keywords": ["Marshmallow"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/j3QC6hcpy90/maxresdefault.jpg",
    "lang":"en",
    "type":"Video"
  },
  {
    "title":"Runtime Permissions in Android 6.0 Marshmallow",
    "category":"",
    "summary":"Learn how to integrate runtime permissions into your Android app.",
    "url":"https://www.youtube.com/watch?v=C8lUdPVSzDk",
    "group":"",
    "keywords": ["Marshmallow"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/C8lUdPVSzDk/maxresdefault.jpg",
    "lang":"en",
    "type":"Video"
  },
  {
    "title":"Introduction to Doze",
    "category":"",
    "summary":"An overview of Doze and how to make sure that your app behaves as expected both in and out of Doze mode. ",
    "url":"https://youtu.be/N72ksDKrX6c",
    "group":"",
    "keywords": ["Marshmallow"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/N72ksDKrX6c/maxresdefault.jpg",
    "lang":"en",
    "type":"Video"
  },
  {
    "title":"The Nexus 5X, Nexus 6P and Android Marshmallow",
    "category":"",
    "summary":"The new Nexus 5X and Nexus 6P along with some of the most significant developer features in the latest Android release,.",
    "url":"https://youtu.be/U9tw5ypqEN0",
    "group":"",
    "keywords": ["Marshmallow"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/U9tw5ypqEN0/maxresdefault.jpg",
    "lang":"en",
    "type":"Video"
  },
  {
    "title":"Asking For Permission",
    "category":"",
    "summary":"Picking the right way and time to ask for a permission is critical to it being granted. ",
    "url":"https://youtu.be/iZqDdvhTZj0",
    "group":"",
    "keywords": ["Marshmallow"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/iZqDdvhTZj0/maxresdefault.jpg",
    "lang":"en",
    "type":"Video"
  },
  {
    "title":"Data Binding Library",
    "category":"",
    "summary":"Data Binding Library is a way to write declarative layouts and minimize the glue code necessary to bind your application logic and layouts. ",
    "url":"https://youtu.be/5sCQjeGoE7M",
    "group":"",
    "keywords": ["Marshmallow"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/5sCQjeGoE7M/maxresdefault.jpg",
    "lang":"en",
    "type":"Video"
  },
  {
    "title":"App Links",
    "category":"",
    "summary":"App Links is a new feature of Android Marshmallow that brings a faster way of opening website links for domains that you own.",
    "url":"https://youtu.be/LQoohRwojmw",
    "group":"",
    "keywords": ["Marshmallow"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/LQoohRwojmw/maxresdefault.jpg",
    "lang":"en",
    "type":"Video"
  },
  {
    "title":"Android M Permissions",
    "category":"",
    "summary":"An introduction to Android M runtime permissions in Android M from Google I/O 2015. ",
    "url":"https://www.youtube.com/watch?v=f17qe9vZ8RM",
    "group":"",
    "keywords": ["Marshmallow"],
    "tags": [],
    "image":"https://i1.ytimg.com/vi/f17qe9vZ8RM/maxresdefault.jpg",
    "lang":"en",
    "type":"Video"
  },

  {
    "title":"Android Performance Testing Codelab",
    "titleFriendly":"",
    "summary":"This codelab shows how to create a stable and reusable testing harness to run performance tests on a very simple existing app.",
    "url":"https://codelabs.developers.google.com/codelabs/android-perf-testing/index.html",
    "group":"",
    "keywords": ["testing"],
    "tags": [
    ],
    "image":"images/testing/testing-icon.png",
    "type":"google"
  },

  {
    "title":"Introduction to Doze",
    "category":"android developers",
    "summary":"A new way for the device to preserve battery by entering into an idle state.",
    "url":"https://www.youtube.com/watch?v=N72ksDKrX6c",
    "group":"",
    "keywords": ["android, performance","battery"],
    "tags": ["video, performance"],
    "image":"https://i1.ytimg.com/vi/N72ksDKrX6c/maxresdefault.jpg",
    "lang":"en",
    "type":"develop"
  },

  {
    "title":"Performance Profiling Tools",
    "category":"training",
    "summary":"Take a look under the hood to identify performance bottlenecks.",
    "url":"https://developer.android.com/tools/performance/index.html",
    "group":"",
    "keywords": ["android, performance","profiling"],
    "tags": ["android, performance"],
    "image": null,
    "lang":"en",
    "type":"develop"
  },

  {
    "title":"Managing Your App's Memory",
    "category":"training",
    "summary":"Learn how you can proactively reduce memory usage while developing for Android.",
    "url":"https://developer.android.com/training/articles/memory.html",
    "group":"",
    "keywords": ["android, performance","profiling"],
    "tags": ["android, performance"],
    "image": null,
    "lang":"en",
    "type":"develop"
  },

  {
    "url":"https://www.youtube.com/watch?v=QDM52bblwlg",
    "image": "images/distribute/hero-family-discovery.jpg",
    "title": "Introducing the new family discovery experience on Google Play",
    "summary": "Help families create little moments on Google Play. Opt-in your apps now.",
    "tags":["families","googleplay"],
    "type":"video"
  },
  {
    "url":"https://www.youtube.com/watch?v=wcjqBSei3a0&list=PLOU2XLYxmsIKLNUPiFCWVtcO7mZRZ9MmS",
    "image": "https://i1.ytimg.com/vi/wcjqBSei3a0/maxresdefault.jpg",
    "title": "Developers connecting the world through Google Play",
    "summary": "The mobile ecosystem is empowering developers to make good on the dream of connecting the world through technology to improve people's lives.",
    "tags":["io15","googleplay"],
    "keywords":["Google I/O 2015","io"],
    "type":"video"
  },
  {
    "url":"https://www.youtube.com/watch?v=B6ydLpkhq04&list=PLOU2XLYxmsIKLNUPiFCWVtcO7mZRZ9MmS",
    "image": "https://i1.ytimg.com/vi/B6ydLpkhq04/maxresdefault.jpg",
    "title": "Store Listing Experiments for Google Play",
    "summary": "Learn how to use Google Play’s new store listing optimization feature to get more installs of your app, and how to test different graphics and text to find out which options perform the best. ",
    "tags":["io15","googleplay","store listing"],
    "tags":["google i/o","google play","store listing"],
    "type":"video"
  },
  {
    "url":"https://www.youtube.com/watch?v=jyO3-rF4Mu0&list=PLOU2XLYxmsIKLNUPiFCWVtcO7mZRZ9MmS",
    "image": "https://i1.ytimg.com/vi/jyO3-rF4Mu0/maxresdefault.jpg",
    "title": "Growing games with Google",
    "summary": "The games industry has never been more promising and full of opportunities. This talk covers how Google is helping developers across a broad range of existing and emerging platforms.",
    "tags":["io15","android", "googleplay","games"],
    "keywords":["Google I/O","google play","games"],
    "type":"video"
  },
  {
    "url":"https://www.youtube.com/watch?v=yJisuP94lHU",
    "image": "images/distribute/hero-playtime-opener.jpg",
    "title": "Playtime 2015: Innovation happens everywhere",
    "type":"Video",
    "tags":["googleplay"],
    "summary": "Watch the opening video from Google Play's annual event series, Playtime, which celebrates inspirational developers who are changing the world around them.",
  },
  {
    "url":"https://www.youtube.com/watch?v=JrR6o5tYMWQ",
    "image": "images/distribute/hero-acquisition-devbyte.jpg",
    "title": "User acquisition and tracking on Google Play",
    "type" : "Video",
    "tags" : "users,googleplay,googleio",
    "summary": "Learn how to get new users, using Universal app campaigns directly within the Google Play Developer Console to increase your installs from ads, and find out how your acquisition channels perform.",
  },
  {
    "lang": "en",
    "group": "",
    "tags": ["play,protips"],
    "url": "shareables/distribute/secrets_play/v2/web/secrets_to_app_success_v2_en.pdf",
    "timestamp": 1447437450,
    "image": "images/distribute/secrets_v2_banner.jpg",
    "title": "The Secrets to App Success on Google Play",
    "summary": "Get the updated guide full of useful features, tips, and best practices that will help you grow a successful app or game business on Google Play.",
    "keywords": ["secrets, success, play, google"],
    "type": "Book",
    "category": "distribute"
  },
  {
    "lang": "en",
    "group": "",
    "tags": ["studio,sdk"],
    "url": "studio/index.html",
    "timestamp": 1462292883,
    "image": "images/cards/android-studio_2x.png",
    "title": "Download Android Studio and SDK Tools",
    "summary": "Get the official Android IDE and developer tools to build apps for Android.",
    "type": "develop",
    "category": "studio"
  },
  {
    "url":"panel1",
    "image": "",
    "title": "",
    "type" : "",
    "tags" : "",
    "summary": "",
  },
  {
    "url":"panel2",
    "image": "",
    "title": "",
    "type" : "",
    "tags" : "",
    "summary": "",
  },
  {
    "url":"panel3",
    "image": "",
    "title": "",
    "type" : "",
    "tags" : "",
    "summary": "",
  },
  {
    "url":"panel4",
    "image": "",
    "title": "",
    "type" : "",
    "tags" : "",
    "summary": "",
  }
]);

/**
 * Metadata overrides for carousels/heros.
 */
METADATA['en'].carousel = {
  "panel2": {
    "image": "images/tools/and-studio_shortcuts-included_2x.png",
    "title": "Shortcuts included",
    "type":"Android Studio",
    "heroColor": "#fff",
    "url":"",
    "summary": "No need to start from scratch, Android Studio includes prebuilt template patterns &nbsp; from navigation drawers to view pagers and GitHub integration to help guide you along quickly.",
  },
  "panel4": {
    "image": "images/tools/and-studio_feat-gradle_2x.png",
    "title": "Evolved Android builds, with Gradle",
    "type":"Android Studio",
    "heroColor": "#fff",
    "summary": "Create multiple APKs for your Android app with different features using the same project. Manage app dependencies with Maven. Build APKs from Android Studio or the command line.",
  },
  "panel1": {
    "image": "images/tools/codeeditor-low.gif",
    "title": "Fast, intelligent coding",
    "type":"Android Studio",
    "heroColor": "#fff",
    "summary": "Advanced code completion, refactoring and code analysis in an environment that’s purpose-built for Android, the powerful code editor helps you be a more productive Android app developer.",
  },
  "panel3": {
    "image": "images/tools/studio-hero-screens_2x.png",
    "title": " All shapes, sizes and scenarios",
    "type":"Android Studio",
    "heroColor": "#fff",
    "summary": "Create multiple APKs for your Android app with different features using the same project. Manage app dependencies with Maven. Build APKs from Android Studio or the command line.",
  },
  "distribute/googleplay/guide.html": {
    "image": "images/distribute/hero-secrets-to-app-success.jpg",
    "title": "Playbook for Developers",
    "summary": "Stay up to date with features, best practices, and strategies to help you grow your business and find success on Google Play.",
  },
  "about/versions/lollipop.html": {
    "image": "images/home/hero-lollipop_2x.png",
    "heroColor": "#263238",
    "heroInvert": true,
    "title": "Android 5.0 Lollipop",
    "summary": "The Android 5.0 update adds a variety of new features for your apps, such as notifications on the lock screen, an all-new camera API, OpenGL ES 3.1, the new naterial design interface, and much more.",
  },
  "https://www.youtube.com/watch?v=Pms0pcyPbAM": {
    "url":"https://www.youtube.com/watch?v=Pms0pcyPbAM&list=PLWz5rJ2EKKc9ofd2f-_-xmUi07wIGZa1c]",
    "image": "images/distribute/hero-carousel-giftedmom.jpg",
    "title": "Gifted Mom reaches more mothers across Africa with Android",
    "type":"youtube",
    "summary": "Gifted Mom is an app developed in Cameroon which provides users with critical information about pregnancy, breastfeeding and child vaccinations. Hear the creators explain how they built their business and launched on Google Play.",
  },
  "https://www.youtube.com/watch?v=9m6MoBM-sFI": {
    "url":"https://www.youtube.com/watch?v=9m6MoBM-sFI&list=PLWz5rJ2EKKc9ofd2f-_-xmUi07wIGZa1c&index=3",
    "image": "images/distribute/hero-carousel-sgn.jpg",
    "title": "SGN increases installs with Store Listing Experiments",
    "type" : "youtube",
    "summary": "Watch mobile game developer SGN talk about how using Store Listing Experiments to test multiple variants across their portfolio of games helped improve their ROI, conversion rates and gamer retention.",
  },
  "https://www.youtube.com/watch?v=e7t3svG9PTk": {
    "url":"https://www.youtube.com/watch?v=e7t3svG9PTk&index=2&list=PLWz5rJ2EKKc9ofd2f-_-xmUi07wIGZa1c",
    "image": "images/distribute/hero-carousel-djit.jpg",
    "title": "DJiT builds higher quality experiences on Android",
    "type" : "youtube",
    "summary": "Learn how Music app developer DJiT create higher quality apps with improved latency on Android Marshmallow, as well as other Android and Google Play features.",
  },
  "https://www.youtube.com/watch?v=J3IvOfvH1ys": {
    "url":"https://www.youtube.com/watch?v=J3IvOfvH1ys&list=PLWz5rJ2EKKc9ofd2f-_-xmUi07wIGZa1c&index=1",
    "image": "images/distribute/hero-carousel-wego.jpg",
    "title": "Wego increases user retention with material design",
    "type" : "youtube",
    "summary": "Hear how online travel marketplace Wego, increased monthly user retention by 300% and reduced uninstall rates by up to 25% with material design.",
  },
  "https://www.youtube.com/watch?v=QDM52bblwlg": {
    "url":"distribute/googleplay/families/about.html",
    "image": "images/distribute/hero-family-discovery.jpg",
    "title": "Designed for families",
    "summary": "Introducing the new family discovery experience in Google Play. Your apps can benefit from enhanced discoverability and maintain their existing categories, rankings, and reviews elsewhere in the store. Opt-in your apps today.",
    "type":"distribute",
  },
  "https://www.youtube.com/watch?v=wcjqBSei3a0&list=PLOU2XLYxmsIKLNUPiFCWVtcO7mZRZ9MmS": {
    "url":"https://www.youtube.com/watch?v=wcjqBSei3a0&list=PLOU2XLYxmsIKLNUPiFCWVtcO7mZRZ9MmS",
    "image": "images/distribute/hero-IO15-google-play.jpg",
    "title": "Connecting the world through Google Play",
    "tags":["io15"],
    "summary": "In this this Google I/O talk, hear how the mobile ecosystem is empowering developers to connect the world through technology and improve people's lives.",
  },
  "https://www.youtube.com/watch?v=B6ydLpkhq04&list=PLOU2XLYxmsIKLNUPiFCWVtcO7mZRZ9MmS": {
    "image": "images/distribute/hero-store-listing-experience.jpg",
    "title": "Using Google Play store listing experiments",
    "tags":["io15"],
    "summary": "Learn how to use Google Play store listing experiments to get more installs in this Google I/O talk. Test different graphics and text to find out which options perform the best. ",
  },
  "https://www.youtube.com/watch?v=jyO3-rF4Mu0&list=PLOU2XLYxmsIKLNUPiFCWVtcO7mZRZ9MmS": {
    "image": "images/distribute/hero-IO15-growing-games.jpg",
    "title": "Growing games with Google",
    "tags":["io15"],
    "summary": "The games industry has never been more promising and full of opportunities. This talk from Google I/O 2015 covers how Google is helping developers across a broad range of existing and emerging platforms.",
  },
};

/**
 * Static metadata collections.
 */
METADATA['en'].collections = {
  "index/carousel": {
    "title": "",
    "resources": [
      "about/versions/lollipop.html"
    ]
  },
  "index/primary": {
    "title": "",
    "resources": [
      "training/building-wearables.html",
      "training/material/index.html",
      "studio/index.html"
    ]
  },
  "index/secondary/carousel": {
    "title": "",
    "resources": [
      "https://www.youtube.com/watch?v=9m6MoBM-sFI",
      "https://www.youtube.com/watch?v=Pms0pcyPbAM",
      "https://www.youtube.com/watch?v=e7t3svG9PTk",
      "https://www.youtube.com/watch?v=J3IvOfvH1ys"
    ]
  },
  "index/multiscreen": {
    "title": "",
    "resources": [
      "wear/index.html",
      "tv/index.html",
      "auto/index.html"
    ]
  },
  "design/landing/latest": {
    "title": "",
    "resources": [
      "https://www.youtube.com/watch?v=p4gmvHyuZzw",
      "https://www.youtube.com/watch?v=YaG_ljfzeUw",
      "https://www.youtube.com/watch?v=XOcCOBe8PTc"
    ]
  },
  "design/landing/materialdesign": {
    "title": "",
    "resources": [
      "https://www.google.com/design/spec/animation/",
      "https://www.google.com/design/spec/style/",
      "https://www.google.com/design/spec/layout/",
      "https://www.google.com/design/spec/components/",
      "https://www.google.com/design/spec/patterns/",
      "https://www.google.com/design/spec/usability/"
    ]
  },
  "design/landing/pureandroid": {
    "title": "",
    "resources": [
      "design/get-started/creative-vision.html",
      "design/material/index.html",
      "training/material/index.html",
      "design/patterns/pure-android.html",
      "design/patterns/new.html",
      "design/devices.html"
    ]
  },
  "design/landing/resources": {
    "title": "",
    "resources": [
      "https://www.google.com/design/spec/resources/color-palettes.html",
      "https://www.google.com/design/spec/resources/layout-templates.html",
      "https://www.google.com/design/spec/resources/sticker-sheets-icons.html",
      "https://www.google.com/design/spec/resources/roboto-noto-fonts.html",
      "https://www.google.com/design/icons/index.html",
      "design/downloads/index.html#Wear"
    ]
  },
  "develop/landing/mainlinks": {
    "title": "",
    "resources": [
      "studio/index.html",
      "samples/new/index.html",
      "studio/projects/templates.html"
    ]
  },
  "develop/landing/latest": {
    "title": "",
    "resources": [
      "https://android-developers.blogspot.com/2015/04/new-android-code-samples.html",
      "https://android-developers.blogspot.com/2015/04/android-support-library-221.html",
      "https://android-developers.blogspot.com/2015/03/a-new-reference-app-for-multi-device.html"
    ]
  },
  "develop/landing/devpatterns": {
    "title": "",
    "resources": [
      "https://www.youtube.com/watch?v=kmUGLURRPkI",
      "https://www.youtube.com/watch?v=HGElAW224dE",
      "https://www.youtube.com/watch?v=zQekzaAgIlQ"
    ]
  },
  "develop/landing/performance": {
    "title": "",
    "resources": [
      "https://www.youtube.com/watch?v=fEEulSk1kNY",
      "https://www.youtube.com/watch?v=-3ry8PxcJJA",
      "https://www.youtube.com/watch?v=_kKTGK-Cb_4"
    ]
  },
  "develop/landing/buildwithgoogle": {
    "title": "",
    "resources": [
    ]
  },
  "develop/landing/ubicomp": {
    "title": "",
    "resources": [
      "https://www.youtube.com/watch?v=AK38PJZmIW8&list=PLWz5rJ2EKKc-kIrPiq098QH9dOle-fLef",
      "https://www.youtube.com/watch?v=6K_jxccHv5M&index=1&list=PLOU2XLYxmsILFBfx66ens76VMLMEPJAB0",
      "https://www.youtube.com/watch?v=ctiaVxgclsg&list=PLWz5rJ2EKKc9BdE_PSLNIGjXXr3h_orXM"
    ]
  },
  "develop/landing/tools": {
    "title": "",
    "resources": [
      "https://www.youtube.com/watch?v=NbHsi3-uR8E&list=PLWz5rJ2EKKc_w6fodMGrA1_tsI3pqPbqa",
      "https://www.youtube.com/watch?v=-SY5nkNVUn0&list=PLWz5rJ2EKKc_w6fodMGrA1_tsI3pqPbqa",
      "https://www.youtube.com/watch?v=StqAZ1OQbqA&list=PLWz5rJ2EKKc_w6fodMGrA1_tsI3pqPbqa",
      "https://www.youtube.com/watch?v=-SY5nkNVUn0&list=PLWz5rJ2EKKc_w6fodMGrA1_tsI3pqPbqa",
      "https://www.youtube.com/watch?v=4rI4tTd7-J8&list=PLWz5rJ2EKKc_w6fodMGrA1_tsI3pqPbqa",
      "https://www.youtube.com/watch?v=SBbWGxXCMqQ&list=PLWz5rJ2EKKc_w6fodMGrA1_tsI3pqPbqa",
      "https://www.youtube.com/watch?v=xxx3Fn7EowU&list=PLWz5rJ2EKKc_w6fodMGrA1_tsI3pqPbqa",
      "https://www.youtube.com/watch?v=cD7NPxuuXYY&list=PLWz5rJ2EKKc8I9gHTMh5yKkwRRGE8BjbQ",
      "https://www.youtube.com/watch?v=2I6fuD20qlY&list=PLWz5rJ2EKKc8I9gHTMh5yKkwRRGE8BjbQ",
      "https://www.youtube.com/watch?v=5Be2mJzP-Uw&list=PLWz5rJ2EKKc9e0d55YHgJFHXNZbGHEXJX"
    ]
  },
  "google/landing/googleplay": {
    "title": "",
    "resources": [
      "google/play/billing/index.html",
      "google/play/billing/billing_subscriptions.html",
      "google/play/developer-api.html"
    ]
  },
  "develop/landing/courses": {
    "title": "",
    "resources": [
      "https://www.udacity.com/course/ud849",
      "https://www.udacity.com/course/ud853",
      "https://www.udacity.com/course/ud825",
      "https://www.udacity.com/android",
      "https://www.udacity.com/course/ud855",
      "https://www.udacity.com/course/ud875A",
      "https://www.udacity.com/course/ud875B",
      "https://www.udacity.com/course/ud875C",
      "https://www.udacity.com/course/ud876--1",
      "https://www.udacity.com/course/ud876--2",
      "https://www.udacity.com/course/ud876--3",
      "https://www.udacity.com/course/ud876--4",
      "https://www.udacity.com/course/ud876--5",
      "https://www.udacity.com/course/ud862",
      "https://www.udacity.com/course/ud837",
      "https://www.udacity.com/course/ud867"
    ]
  },
  "distribute/landing/carousel": {
    "title": "",
    "resources": [
    "distribute/googleplay/guide.html",
    "https://www.youtube.com/watch?v=JrR6o5tYMWQ",
    "https://www.youtube.com/watch?v=B6ydLpkhq04&list=PLOU2XLYxmsIKLNUPiFCWVtcO7mZRZ9MmS",
    "https://www.youtube.com/watch?v=yJisuP94lHU",
    ]
  },
  "distribute/landing/googleplay": {
    "title": "",
    "resources": [
      "distribute/googleplay/about.html",
      "distribute/googleplay/developer-console.html",
      "distribute/googleplay/index.html#opportunities"
    ]
  },
  "distribute/landing/more": {
    "title": "",
    "resources": [
      "distribute/users/promote-with-ads.html",
      "distribute/monetize/ads.html",
      "distribute/analyze/index.html",
      "distribute/engage/deep-linking.html",
      "distribute/engage/easy-signin.html",
      "https://cloud.google.com/docs/"
    ]
  },
  "distribute/edu/videos/stories": {
    "title": "",
    "resources": [
      "https://www.youtube.com/watch?v=Idu7VcTTXfk",
      "https://www.youtube.com/watch?v=iokH4SAIfRw"
    ]
  },
  "distribute/edu/videos/bestpractices": {
    "title": "",
    "resources": [
      "https://www.youtube.com/watch?v=iulXz8QTD1g",
      "https://www.youtube.com/watch?v=IKhU180eJMo",
      "https://www.youtube.com/watch?v=_AZ6UcPz-_g",
      "https://www.youtube.com/watch?v=Eh2adsAyTKc"
    ]
  },
  "distribute/edu/videos/experience": {
    "title": "",
    "resources": [
      "https://youtu.be/vzvpcEffvaE"
    ]
  },
  "distribute/gp/gplanding": {
    "resources": [
      "distribute/googleplay/about.html",
      "distribute/googleplay/start.html",
      "distribute/googleplay/developer-console.html"
    ]
  },
  "distribute/gp/gpfelanding": {
    "resources": [
      "distribute/googleplay/wear.html",
      "distribute/googleplay/tv.html",
      "distribute/googleplay/auto.html",
      "distribute/googleplay/families/about.html",
      "distribute/googleplay/work/about.html",
      "distribute/googleplay/edu/about.html",
      "distribute/googleplay/cast.html",
      "distribute/googleplay/cardboard.html",
      "distribute/googleplay/guide.html"
    ]
  },
  "distribute/googleplay/gpfw": {
    "resources": [
      "https://www.android.com/work/",
      "https://www.youtube.com/watch?v=jQWB_-o1kz4&list=PLOU2XLYxmsIKAK2Bhv19H2THwF-22O5WX",
      "work/index.html"
    ]
  },
  "distribute/essentials": {
    "resources": [
      "distribute/essentials/quality/core.html",
      "distribute/essentials/quality/tablets.html",
      "distribute/essentials/quality/tv.html",
      "distribute/essentials/quality/wear.html",
      "distribute/essentials/quality/auto.html",
      "distribute/essentials/quality/billions.html",
    ]
  },
  "distribute/users": {
    "title": "",
    "resources": [
      "distribute/users/your-listing.html",
      "distribute/users/promote-with-ads.html",
      "distribute/googleplay/index.html#opportunities",
      "distribute/analyze/improve-roi.html",
      "distribute/users/expand-to-new-markets.html",
      "distribute/analyze/index.html",
      "distribute/users/app-invites.html",
      "distribute/users/ota-installs.html",
      "distribute/users/youtube.html",
      "distribute/users/house-ads.html",
      "distribute/users/experiments.html",
      "distribute/users/user-acquisition.html",
      "distribute/users/banners.html",
      "distribute/users/beta.html"
    ]
  },
  "distribute/engagelanding": {
    "resources": [
      "distribute/engage/intents.html",
      "distribute/engage/widgets.html",
      "distribute/engage/translate.html",
      "distribute/engage/notifications.html",
      "distribute/engage/deep-linking.html",
      "distribute/engage/ads.html",
      "distribute/engage/game-services.html",
      "distribute/engage/easy-signin.html",
      "distribute/analyze/build-better-apps.html",
      "distribute/engage/gcm.html",
      "distribute/engage/beta.html",
      "distribute/engage/nearby.html"
    ]
  },
  "distribute/monetize": {
    "resources": [
      "distribute/monetize/premium.html",
      "distribute/monetize/freemium.html",
      "distribute/monetize/subscriptions.html",
      "distribute/monetize/ads.html",
      "distribute/monetize/ecommerce.html",
      "distribute/monetize/payments.html",
      "distribute/monetize/conversions.html",
      "distribute/analyze/understand-user-value.html",
    ]
  },
  "distribute/analyzelanding": {
    "resources": [
      "distribute/analyze/start.html",
      "distribute/analyze/measure.html",
      "distribute/analyze/understand-user-value.html",
      "distribute/analyze/improve-roi.html",
      "distribute/analyze/build-better-apps.html",
      "distribute/analyze/google-services.html"
    ]
  },
  "distribute/analyzestart": {
    "resources": [
      "https://analyticsacademy.withgoogle.com/course04",
      "google/play-services/index.html",
      "https://developers.google.com/analytics/solutions/mobile-implementation-guide",
      "https://developers.google.com/analytics/devguides/collection/android/",
      "https://www.google.com/tagmanager/",
      "https://github.com/googleanalytics/google-analytics-plugin-for-unity"
    ]
  },
  "distribute/analyzemeasure": {
    "resources": [

      "https://developers.google.com/analytics/solutions/mobile-implementation-guide",
      "https://developers.google.com/analytics/devguides/collection/android/v4/enhanced-ecommerce",
      "https://support.google.com/analytics/answer/1032415",
      "https://developers.google.com/analytics/devguides/collection/android/v4/events",
      "https://developers.google.com/analytics/devguides/collection/android/v4/customdimsmets",
      "https://developers.google.com/analytics/devguides/collection/android/v4/user-id"
    ]
  },
  "distribute/analyzeunderstand": {
    "resources": [
      "https://developers.google.com/analytics/devguides/collection/android/v4/display-features",
      "https://support.google.com/analytics/answer/3123906",
      "https://support.google.com/analytics/answer/2568874?ref_topic=6012392",
      "https://developers.google.com/analytics/devguides/collection/android/v4/enhanced-ecommerce",
      "https://support.google.com/analytics/answer/1032415",
    ]
  },
  "distribute/analyzeimprove": {
    "resources": [

      "https://developers.google.com/analytics/devguides/collection/android/v4/campaigns",
      "https://support.google.com/analytics/answer/2956981",
      "https://support.google.com/analytics/answer/1033961",
      "https://developers.google.com/analytics/devguides/collection/android/v4/campaigns#google-play-url-builder",
      "https://developers.google.com/analytics/solutions/mobile-campaign-deep-link"
    ]
  },
  "distribute/analyzebuild": {
    "resources": [
      "https://support.google.com/tagmanager/answer/6003007",
      "https://support.google.com/analytics/answer/2785577",
      "https://support.google.com/analytics/answer/1151300"
    ]
  },
  "distribute/analyzeact": {
    "resources": [
      "https://support.google.com/analytics/answer/2611268",
      "https://support.google.com/analytics/answer/1033961",
      "https://support.google.com/admob/answer/3508177",
      "https://support.google.com/analytics/answer/2956981",
      "https://support.google.com/tagmanager/answer/6003007"
    ]
  },
  "distribute/essentials/guidelines": {
    "title": "",
    "resources": [
      "distribute/essentials/quality/core.html",
      "distribute/essentials/quality/tablets.html",
      "distribute/essentials/quality/wear.html",
      "distribute/essentials/quality/tv.html",
      "distribute/essentials/quality/auto.html",
      "https://developers.google.com/games/services/checklist",
      "distribute/essentials/quality/billions.html",
      "https://developers.google.com/edu/guidelines"
    ]
  },
  "distribute/essentials/tools": {
    "title": "",
    "resources": [
      "distribute/tools/launch-checklist.html",
      "distribute/tools/localization-checklist.html",
      "https://support.google.com/googleplay/android-developer",
      "distribute/tools/promote/brand.html",
      "distribute/tools/promote/device-art.html",
      "https://play.google.com/intl/en_us/badges/",
      "distribute/tools/promote/linking.html",
      "distribute/tools/open-distribution.html",
      "about/dashboards/index.html"
    ]
  },
  "distribute/tools/checklists": {
    "title": "",
    "resources": [
      "distribute/tools/launch-checklist.html",
      "distribute/tools/localization-checklist.html"
    ]
  },
  "distribute/tools/promote": {
    "resources": [
      "distribute/tools/promote/device-art.html",
      "https://play.google.com/intl/en_us/badges/",
      "distribute/tools/promote/linking.html"
    ]
  },
  "distribute/tools/support": {
    "title": "Google Play",
    "resources": [
      "https://support.google.com/googleplay/android-developer",
      "https://support.google.com/googleplay/android-developer/answer/4430948",
      "support.html"
    ]
  },
  "distribute/tools/news": {
    "title": "",
    "resources": [
      "https://android-developers.blogspot.com/",
      "https://plus.google.com/+AndroidDevelopers/"
    ]
  },
  "distribute/tools/more": {
    "title": "Google Play",
    "resources": [
      "distribute/tools/promote/brand.html",
      "distribute/tools/open-distribution.html",
      "about/dashboards/index.html"
    ]
  },
  "distribute/googleplay": {
    "title": "Google Play",
    "resources": [
      "distribute/googleplay/developer-console.html",
      "distribute/essentials/best-practices/apps.html",
      "distribute/tools/launch-checklist.html",
      "distribute/essentials/best-practices/games.html",
    ]
  },
  "distribute/googleplay/gettingstarted": {
    "title": "Get Started",
    "resources": [
      "distribute/googleplay/developer-console.html",
      "https://support.google.com/googleplay/android-developer/answer/113468",
      "https://support.google.com/googleplay/android-developer/answer/138294",
      "https://support.google.com/googleplay/android-developer"
    ]
  },
  "distribute/googleplay/developerconsole/related": {
    "title": "Developer Console",
    "resources": [
      "google/play/billing/index.html",
      "https://support.google.com/googleplay/android-developer/answer/138294"
    ]
  },
  "distribute/googleplay/developerconsole": {
    "title": "Developer Console",
    "resources": [
      "google/play/billing/index.html",
      "https://support.google.com/googleplay/android-developer/answer/138294"
    ]
  },
  "distribute/googleplay/beta": {
    "title": "Alpha and Beta Testing",
    "resources": [
      "https://support.google.com/googleplay/android-developer/answer/3131213",
      "https://support.google.com/googleplay/android-developer/answer/3131213#games",
      "distribute/googleplay/experiments.html"
    ]
  },
  "distribute/googleplay/experiments/successes": {
    "title": "Store Listing Experiment successes",
    "resources": [
    ]
  },
  "distribute/googleplay/experiments/related": {
    "title": "Store Listing Experiments",
    "resources": [
      "https://support.google.com/googleplay/android-developer/answer/6227309",
      "https://www.youtube.com/watch?v=B6ydLpkhq04",
      "https://support.google.com/tagmanager/answer/6003007"
    ]
  },
  "distribute/googleplay/banners/related": {
    "title": "App Install Banners",
    "resources": [
      "https://developers.google.com/web/updates/2015/03/increasing-engagement-with-app-install-banners-in-chrome-for-android#native"
    ]
  },
  "distribute/googleplay/useracquisition/related": {
    "title": "User Acquisition",
    "resources": [
      "https://support.google.com/googleplay/android-developer/answer/6263332"
    ]
  },
  "distribute/googleplay/cast": {
    "title": "Google Cast",
    "resources": [
      "https://developers.google.com/cast/docs/ux_guidelines",
      "https://developers.google.com/cast/docs/android_sender",
      "https://www.github.com/googlecast"
    ]
  },
  "distribute/googleplay/cardboard": {
    "title": "Google Cast",
    "resources": [
      "https://www.google.com/get/cardboard/get-cardboard/",
      "https://developers.google.com/cardboard/android/download",
      "https://www.google.com/design/spec-vr"
    ]
  },
  "distribute/googleplay/gpfe/highlight": {
    "title": "About Google Play for Education",
    "resources": [
      "https://youtu.be/vzvpcEffvaE"
    ]
  },
  "distribute/googleplay/gpfe/dev/about": {
    "title": "About Google Play for Education / Developers",
    "resources": [
      "distribute/googleplay/edu/start.html",
      "https://developers.google.com/edu/guidelines",
      "https://developers.google.com/edu/faq",
      "distribute/essentials/quality/tablets.html",
      "https://developers.google.com/edu/",
      "https://www.google.com/edu/tablets/#tablets-family"
    ]
  },
  "distribute/googleplay/gpfe/dev": {
    "title": "About Google Play for Education / Developers",
    "resources": [
      "distribute/googleplay/edu/about.html",
      "https://developers.google.com/edu/guidelines",
      "distribute/essentials/quality/tablets.html",
      "distribute/googleplay/developer-console.html",
      "https://play.google.com/about/developer-distribution-agreement-addendum.html",
    ]
  },
  "distribute/googleplay/aboutgpfe/educators/about": {
    "title": "About Google Play for Education / Educators",
    "resources": [
      "https://www.google.com/edu/tablets/",
      "https://www.youtube.com/watch?v=haEmsMo0f3w"
    ]
  },
  "distribute/googleplay/aboutgpfe/educators": {
    "title": "About Google Play for Education / Educators",
    "resources": [
      "https://www.google.com/edu/tablets/",
      "https://youtu.be/vzvpcEffvaE"
    ]
  },
  "distribute/googleplay/gettingstartedgpfe/educators": {
    "title": "About Google Play for Education / Educators",
    "resources": [
      "https://www.google.com/edu/tablets/",
      "https://youtu.be/vzvpcEffvaE"
    ]
  },
  "distribute/essentials/eduessentials/developers": {
    "title": "",
    "resources": [
      "distribute/googleplay/developer-console.html",
      "distribute/googleplay/edu/start.html",
      "https://developers.google.com/edu/faq"
    ]
  },
  "distribute/essentials/eduessentials/educators": {
    "title": "",
    "resources": [
      "https://www.google.com/edu/tablets/",
      "distribute/essentials/quality/tablets.html",
    ]
  },
  "distribute/essentials/optimizing": {
    "title": "Optimizing Your App",
    "resources": [
      "design/index.html",
      "training/articles/perf-anr.html",
      "https://android-developers.blogspot.com/2013/10/improved-app-insight-by-linking-google.html"
    ]
  },
  "distribute/users/appinvites": {
    "title": "",
    "resources": [
      "https://developers.google.com/app-invites/",
      "https://developers.google.com/identity/sign-in/android/",
      "https://developers.google.com/app-indexing/"
    ]
  },
  "distribute/users/knowyouruser": {
    "title": "",
    "resources": [
      "distribute/essentials/optimizing-your-app.html",
      "http://www.youtube.com/watch?v=RRelFvc6Czo",
      "distribute/stories/games/rvappstudios-zombie.html"
    ]
  },
  "distribute/users/promotewithads": {
    "title": "",
    "resources": [
      "https://support.google.com/adwords/answer/6032059",
      "https://support.google.com/adwords/answer/6032073",
      "https://support.google.com/adwords/answer/6167164",
      "https://support.google.com/adwords/answer/6167162"
    ]
  },
  "distribute/users/nearby": {
    "title": "",
    "resources": [
      "https://developers.google.com/nearby/",
      "https://www.youtube.com/watch?v=hultDpBS22s",
      "https://developers.google.com/beacons"
    ]
  },
  "distribute/users/buildbuzz": {
    "title": "",
    "resources": [
      "https://play.google.com/intl/en_us/badges/",
      "distribute/tools/promote/linking.html",
      "distribute/tools/promote/device-art.html",
      "https://plus.google.com/+GooglePlay"
    ]
  },
  "distribute/users/createagreatlisting": {
    "title": "",
    "resources": [
      "https://support.google.com/googleplay/android-developer/answer/1078870",
      "https://android-developers.blogspot.com/2011/10/android-market-featured-image.html",
      "distribute/tools/launch-checklist.html",
      "https://android-developers.blogspot.com/2013/07/making-beautiful-android-app-icons.html",
      "https://android-developers.blogspot.com/2012/12/localize-your-promotional-graphics-on.html",
      "https://android-developers.blogspot.com/2013/10/making-your-app-content-more-accessible.html"
    ]
  },
  "distribute/users/appindexing": {
    "title": "",
    "resources": [
      "https://developers.google.com/app-indexing/",
      "https://developers.google.com/app-indexing/webmasters/details",
      "distribute/engage/deep-linking.html",
      "training/app-indexing/index.html"
    ]
  },
  "distribute/users/otas": {
    "title": "",
    "resources": [
      "https://developers.google.com/identity/sign-in/android/",
      "https://developers.google.com/+/features/play-installs",
      "https://developers.google.com/+/features/analytics"
    ]
  },
  "distribute/users/houseads": {
    "title": "",
    "resources": [
      "https://support.google.com/admob/topic/2784623",
      "https://developers.google.com/mobile-ads-sdk/download",
      "https://support.google.com/googleplay/android-developer/topic/2985714",
      "https://analyticsacademy.withgoogle.com/mobile-app",
      "https://support.google.com/analytics/answer/2611404",
      "https://support.google.com/admob/answer/3111064"
    ]
  },
  "distribute/users/youtube": {
    "title": "",
    "resources": [
      "https://support.google.com/youtube/answer/6140493",
      "https://support.google.com/youtube/answer/2797387"
    ]
  },
  "distribute/toolsreference/bestpractices/apps": {
    "title": "",
    "resources": [
      "distribute/googleplay/developer-console.html",
      "https://android-developers.blogspot.com/"
    ]
  },
  "distribute/toolsreference/bestpractices/games": {
    "title": "",
    "resources": [
      "google/play-services/games.html",
      "https://android-developers.blogspot.com/",
      "distribute/googleplay/developer-console.html",
      "https://www.youtube.com/watch?v=1RIz-cmTQB4"
    ]
  },
  "distribute/essentials/corequalityguidelines/visualdesign": {
    "title": "",
    "resources": [
      "design/index.html",
      "design/patterns/navigation.html",
      "design/patterns/actionbar.html",
      "design/style/iconography.html",
      "https://material.google.com/patterns/notifications.html"
    ]
  },
  "distribute/essentials/corequalityguidelines/functionality": {
    "title": "",
    "resources": [
      "https://android-developers.blogspot.com/2011/11/making-android-games-that-play-nice.html",
      "guide/components/tasks-and-back-stack.html",
      "training/basics/activity-lifecycle/recreating.html"
    ]
  },
  "distribute/essentials/tvqualityguidelines/visualdesign": {
    "title": "",
    "resources": [
      "design/tv/index.html",
      "training/tv/start/index.html"
    ]
  },
  "distribute/essentials/tvqualityguidelines/functionality": {
    "title": "",
    "resources": [
      "training/tv/start/hardware.html",
      "training/tv/games/index.html"
    ]
  },
  "distribute/essentials/wearqualityguidelines/visualdesign": {
    "title": "",
    "resources": [
      "design/wear/index.html",
      "training/building-wearables.html",
      "training/wearables/ui/index.html"
    ]
  },
  "distribute/essentials/wearqualityguidelines/functionality": {
    "title": "",
    "resources": [
      "training/wearables/notifications/index.html",
      "training/wearables/apps/index.html",
      "training/wearables/notifications/voice-input.html"
    ]
  },
  "distribute/essentials/autoqualityguidelines/visualdesign": {
    "title": "",
    "resources": [
      "training/auto/messaging/index.html",
      "training/auto/start/index.html"
    ]
  },
  "distribute/essentials/core/performance": {
    "title": "",
    "resources": [
      "https://android-developers.blogspot.com/2010/12/new-gingerbread-api-strictmode.html",
      "training/articles/perf-anr.html",
      "https://android-developers.blogspot.com/2010/07/multithreading-for-performance.html"
    ]
  },
  "distribute/essentials/core/play": {
    "title": "",
    "resources": [
      "distribute/tools/launch-checklist.html",
      "https://play.google.com/about/developer-content-policy.html",
      "https://support.google.com/googleplay/android-developer/answer/188189",
      "https://support.google.com/googleplay/android-developer/answer/1078870",
      "https://android-developers.blogspot.com/2011/10/android-market-featured-image.html",
      "https://support.google.com/googleplay/android-developer/answer/113477"
    ]
  },
  "distribute/essentials/tabletguidelines/optimize": {
    "title": "",
    "resources": [
      "design/style/metrics-grids.html",
      "design/style/devices-displays.html",
      "guide/practices/screens_support.html",
    ]
  },
  "distribute/essentials/tabletguidelines/extrascreen": {
    "title": "",
    "resources": [
      "design/patterns/multi-pane-layouts.html",
      "training/design-navigation/multiple-sizes.html",
      "training/multiscreen/index.html",
    ]
  },
  "distribute/essentials/tabletguidelines/assets": {
    "title": "",
    "resources": [
      "design/style/iconography.html",
      "guide/topics/resources/providing-resources.html",
      "guide/practices/screens_support.html",
      "training/basics/supporting-devices/screens.html"
    ]
  },
  "distribute/essentials/tabletguidelines/fonts": {
    "title": "",
    "resources": [
      "design/style/metrics-grids.html",
      "design/style/typography.html",
      "guide/practices/screens_support.html",
      "training/multiscreen/screendensities.html"
    ]
  },
  "distribute/essentials/tabletguidelines/widgets": {
    "title": "",
    "resources": [
      "guide/topics/appwidgets/index.html#MetaData",
      "guide/topics/appwidgets/index.html",
      "design/patterns/widgets.html"
    ]
  },
  "distribute/essentials/tabletguidelines/versions": {
    "title": "",
    "resources": [
      "guide/topics/manifest/uses-sdk-element.html#ApiLevels",
      "guide/topics/manifest/uses-sdk-element.html",
      "training/basics/supporting-devices/platforms.html"
    ]
  },
  "distribute/essentials/tabletguidelines/hardware": {
    "title": "",
    "resources": [
      "guide/topics/manifest/uses-feature-element.html",
      "guide/topics/manifest/uses-feature-element.html#testing"
    ]
  },
  "distribute/essentials/tabletguidelines/tabletscreens": {
    "title": "",
    "resources": [
      "guide/practices/screens_support.html#DeclaringScreenSizeSupport",
      "guide/practices/screens_support.html"
    ]
  },
  "distribute/essentials/tabletguidelines/showcase": {
    "title": "",
    "resources": [
      "distribute/tools/launch-checklist.html",
      "https://play.google.com/apps/publish/",
      "https://play.google.com/intl/en_us/badges/",
      "distribute/tools/promote/device-art.html"
    ]
  },
  "distribute/essentials/tabletguidelines/googleplay": {
    "title": "",
    "resources": [
      "https://android-developers.blogspot.com/2013/10/more-visibility-for-tablet-apps-in.html",
      "google/play/filters.html"
    ]
  },
  "distribute/essentials/tabletguidelines": {
    "title": "",
    "resources": [
      "distribute/essentials/quality/core.html",
      "https://android-developers.blogspot.com/2013/10/more-visibility-for-tablet-apps-in.html",
      "distribute/tools/launch-checklist.html",
      "distribute/tools/promote/device-art.html"
    ]
  },
 "distribute/essentials/billionsquality/connectivity": {
    "title": "",
    "resources": [
      "training/basics/network-ops/managing.html",
      "training/monitoring-device-state/connectivity-monitoring.html",
      "guide/topics/providers/content-providers.html"
    ]
  },
  "distribute/essentials/billionsquality/capability": {
    "title": "",
    "resources": [
      "guide/practices/screens_support.html",
      "training/multiscreen/screendensities.html",
      "training/articles/memory.html"
    ]
  },
  "distribute/essentials/billionsquality/cost": {
    "title": "",
    "resources": [
      "https://medium.com/@wkalicinski/smallerapk-part-4-multi-apk-through-abi-and-density-splits-477083989006#.23hlddo3x",
      "training/basics/network-ops/managing.html"
    ]
  },
  "distribute/essentials/billionsquality/consumption": {
    "title": "",
    "resources": [
      "training/efficient-downloads/efficient-network-access.html",
      "training/monitoring-device-state/index.html"
    ]
  },
  "distribute/essentials/billionsquality/content": {
    "title": "",
    "resources": [
      "training/material/animations.html#Touch",
      "training/articles/perf-anr.html",
      "training/improving-layouts/index.html"
    ]
  },
  "distribute/getusers/notifications": {
    "title": "",
    "resources": [
      "https://material.google.com/patterns/notifications.html",
      "distribute/engage/gcm.html",
      "https://play.google.com/about/developer-content-policy.html"
    ]
  },
  "distribute/engage/analytics": {
    "title": "",
    "resources": [
      "https://www.google.com/analytics/mobile/",
      "https://android-developers.blogspot.com/2013/10/improved-app-insight-by-linking-google.html",
      "https://developers.google.com/analytics/devguides/collection/android/"
    ]
  },
  "distribute/engage/widgets": {
    "title": "",
    "resources": [
      "design/patterns/widgets.html",
      "guide/topics/appwidgets/index.html"
    ]
  },
  "distribute/engage/translate": {
    "title": "",
    "resources": [
      "https://support.google.com/l10n/answer/6359997"
    ]
  },
  "distribute/engage/reengage": {
    "title": "",
    "resources": [
      "https://support.google.com/adwords/answer/6032073",
      "distribute/engage/deep-linking.html",
      "https://support.google.com/adwords/answer/6167162",
      "distribute/users/promote-with-ads.html"
    ]
  },
  "distribute/engage/appindexing": {
    "title": "",
    "resources": [
      "distribute/engage/intents.html",
      "distribute/engage/deep-linking.html",
      "training/app-indexing/index.html"
    ]
  },
  "distribute/engage/intents": {
    "title": "",
    "resources": [
      "guide/components/intents-filters.html",
      "distribute/engage/deep-linking.html",
      "distribute/engage/ads.html"
    ]
  },
  "distribute/getusers/expandnewmarkets": {
    "title": "",
    "resources": [
      "distribute/tools/localization-checklist.html",
      "https://support.google.com/googleplay/android-developer/table/3541286",
      "distribute/stories/localization.html",
      "https://play.google.com/intl/en_us/badges/",
      "distribute/tools/promote/device-art.html",
      "https://www.youtube.com/watch?v=SkHHPf3EdzE"
    ]
  },
  "distribute/engage/gcm": {
    "title": "",
    "resources": [
      "https://developers.google.com/cloud-messaging/gcm",
      "https://developers.google.com/cloud-messaging/android/client",
    ]
  },
  "distribute/engage/gamesservices/related": {
    "title": "",
    "resources": [
      "https://developers.google.com/games/services/",
      "distribute/analyze/start.html",
      "distribute/googleplay/cardboard.html",
      "https://www.google.com/admob/"
    ]
  },
  "distribute/engage/googleplaygames": {
    "title": "",
    "resources": [
      "https://developers.google.com/games/services/",
      "distribute/analyze/start.html",
      "distribute/googleplay/cardboard.html",
      "https://www.google.com/admob/"
    ]
  },
  "distribute/engage/gplus": {
    "title": "",
    "resources": [
      "distribute/users/ota-installs.html",
      "https://developers.google.com/identity/sign-in/android/people",
      "https://developers.google.com/+/mobile/android/"
    ]
  },
  "distribute/engage/community": {
    "title": "",
    "resources": [
      "distribute/users/build-community.html",
      "distribute/engage/video.html"
    ]
  },
  "distribute/engage/deeplinks": {
    "title": "",
    "resources": [
      "distribute/engage/easy-signin.html",
      "https://developers.google.com/app-indexing/",
      "https://developers.google.com/+/mobile/android/share/interactive-post"
    ]
  },
  "distribute/engage/appupdates": {
    "title": "",
    "resources": [
      "distribute/essentials/optimizing-your-app.html",
      "distribute/tools/launch-checklist.html",
      "distribute/googleplay/developer-console.html",
      "https://material.google.com/patterns/notifications.html"
    ]
  },
  "distribute/engage/video/more": {
    "title": "",
    "resources": [
      "https://www.youtube.com/yt/dev/",
      "distribute/essentials/best-practices/games.html",
      "https://www.youtube.com/watch?v=RRelFvc6Czo"
    ]
  },
  "distribute/engage/community": {
    "title": "",
    "resources": [
      "distribute/users/build-community.html",
      "distribute/engage/video.html"
    ]
  },
  "distribute/engage/kiwi": {
    "title": "",
    "resources": [
      "https://www.youtube.com/watch?v=WWArLD6nqrk"
    ]
  },
  "distribute/toolsreference/gpfefaq": {
    "title": "",
    "resources": [
      "https://www.google.com/edu/tablets/",
      "distribute/googleplay/edu/start.html",
      "https://play.google.com/about/developer-distribution-agreement-addendum.html",
      "distribute/essentials/quality/core.html",
      "distribute/essentials/quality/tablets.html"
    ]
  },
  "distribute/toolsreference/localizationchecklist/identifylocales": {
    "title": "",
    "resources": [
      "https://support.google.com/googleplay/android-developer/answer/138294"
    ]
  },
  "distribute/tools/loc/designforloc": {
    "title": "",
    "resources": [
      "https://android-developers.blogspot.com/2013/03/native-rtl-support-in-android-42.html",
      "guide/topics/resources/string-resource.html#Plurals",
      "guide/topics/resources/string-resource.html",
      "reference/java/util/Locale.html"
    ]
  },
  "distribute/toolsreference/localizationchecklist/managestrings": {
    "title": "",
    "resources": [
      "guide/topics/resources/string-resource.html",
      "design/style/writing.html",
      "https://en.wikipedia.org/wiki/XLIFF"
    ]
  },
  "distribute/toolsreference/localizationchecklist/translatestrings": {
    "title": "",
    "resources": [
      "distribute/stories/localization.html",
    ]
  },
  "distribute/toolsreference/localizationchecklist/preplaunch": {
    "title": "",
    "resources": [
      "https://play.google.com/intl/en_us/badges/",
      "distribute/tools/promote/device-art.html"
    ]
  },
  "distribute/toolsreference/localizationchecklist/supportlaunch": {
    "title": "",
    "resources": [
      "distribute/tools/launch-checklist.html",
    ]
  },
  "distribute/toolsreference/launchchecklist/understanding": {
    "title": "",
    "resources": [
      "studio/publish/index.html",
      "studio/publish/preparing.html"
    ]
  },
  "distribute/toolsreference/launchchecklist/policies": {
    "title": "",
    "resources": [
      "https://support.google.com/googleplay/android-developer/answer/4430948",
      "https://support.google.com/googleplay/android-developer/topic/2364761",
      "https://support.google.com/googleplay/android-developer"
    ]
  },
  "distribute/toolsreference/launchchecklist/quality": {
    "title": "",
    "resources": [
      "distribute/essentials/quality/core.html",
      "distribute/essentials/quality/tablets.html",
      "https://developers.google.com/edu/guidelines"
    ]
  },
  "distribute/toolsreference/launchchecklist/rating": {
    "title": "",
    "resources": [
      "https://support.google.com/googleplay/android-developer/answer/188189",
    ]
  },
  "distribute/toolsreference/launchchecklist/country": {
    "title": "",
    "resources": [
      "https://support.google.com/googleplay/android-developer/answer/138294"
    ]
  },
  "distribute/toolsreference/launchchecklist/size": {
    "title": "",
    "resources": [
      "google/play/expansion-files.html",
      "studio/build/shrink-code.html"
    ]
  },
  "distribute/toolsreference/launchchecklist/platform": {
    "title": "",
    "resources": [
      "guide/practices/screens_support.html",
      "about/dashboards/index.html",
      "guide/topics/manifest/uses-sdk-element.html"
    ]
  },
  "distribute/toolsreference/launchchecklist/price": {
    "title": "",
    "resources": [
      "https://support.google.com/googleplay/android-developer/table/3541286",
    ]
  },
  "distribute/toolsreference/launchchecklist/purchasemethod": {
    "title": "",
    "resources": [
      "google/play/billing/index.html",
      "google/play/billing/billing_subscriptions.html"
    ]
  },
  "distribute/toolsreference/launchchecklist/setprice": {
    "title": "",
    "resources": [
      "https://support.google.com/googleplay/android-developer/answer/1169947",
      "https://support.google.com/googleplay/android-developer/answer/138412",
      "https://support.google.com/googleplay/android-developer/answer/112622",
      "https://support.google.com/googleplay/android-developer/answer/138000"
    ]
  },
  "distribute/toolsreference/launchchecklist/localization": {
    "title": "",
    "resources": [
      "distribute/tools/localization-checklist.html",
      "guide/topics/resources/localization.html",
    ]
  },
  "distribute/toolsreference/launchchecklist/graphics": {
    "title": "",
    "resources": [
      "https://support.google.com/googleplay/android-developer/answer/1078870",
      "https://android-developers.blogspot.com/2011/10/android-market-featured-image.html"
    ]
  },
  "distribute/toolsreference/launchchecklist/productdetails": {
    "title": "",
    "resources": [
      "https://support.google.com/googleplay/android-developer/answer/113475",
      "https://support.google.com/googleplay/android-developer/answer/1078870"
    ]
  },
  "distribute/toolsreference/launchchecklist/badges": {
    "title": "",
    "resources": [
      "https://play.google.com/intl/en_us/badges/",
      "distribute/tools/promote/linking.html"
    ]
  },
  "distribute/toolsreference/launchchecklist/finalchecks": {
    "title": "",
    "resources": [
      "https://play.google.com/about/developer-content-policy.html",
      "https://support.google.com/googleplay/android-developer/answer/113476",
      "support.html"
    ]
  },
  "distribute/toolsreference/launchchecklist/afterlaunch": {
    "title": "",
    "resources": [
      "https://support.google.com/googleplay/android-developer/answer/113477",
      "https://support.google.com/googleplay/android-developer/answer/1153479",
      "https://support.google.com/payments/answer/2741495",
      "distribute/essentials/optimizing-your-app.html"
    ]
  },
  "distribute/monetize/premium": {
    "title": "",
    "resources": [
      "google/play/billing/index.html",
      "https://support.google.com/googleplay/android-developer/answer/4407611"
    ]
  },
  "distribute/monetize/freemium": {
    "title": "",
    "resources": [
      "google/play/billing/index.html",
      "https://support.google.com/googleplay/android-developer/answer/4407611"
    ]
  },
  "distribute/monetize/subscriptions": {
    "title": "",
    "resources": [
      "google/play/billing/billing_subscriptions.html",
      "https://support.google.com/googleplay/android-developer/answer/4407611"
    ]
  },
  "distribute/monetize/ecommerce": {
    "title": "",
    "resources": [
      "https://developers.google.com/wallet/instant-buy/",
      "https://support.google.com/googleplay/android-developer/answer/4407611"
    ]
  },
  "distribute/monetize/advertising": {
    "title": "",
    "resources": [
      "https://www.google.com/ads/admob/#subid=us-en-et-dac",
      "https://www.google.com/doubleclick/publishers/small-business/index.html",
      "https://support.google.com/googleplay/android-developer/topic/2985714",
      "training/monetization/ads-and-ux.html"
    ]
  },
  "distribute/monetize/admob": {
    "title": "",
    "resources": [
      "https://support.google.com/admob/topic/2784623",
      "https://admob.blogspot.com/",
      "https://analyticsacademy.withgoogle.com/mobile-app",
      "https://www.udacity.com/courses/ud876-3"
    ]
  },
  "distribute/monetize/paymentmethods": {
    "title": "",
    "resources": [
      "https://play.google.com/about/giftcards/",
      "https://support.google.com/googleplay/answer/2651410"
    ]
  },
  "distribute/monetize/conversions": {
     "title": "",
     "resources": [
       "https://support.google.com/adwords/answer/2471188",
       "https://developers.google.com/app-conversion-tracking/",
       "https://support.google.com/analytics/answer/2611404",
       "https://support.google.com/adwords/answer/1704341"
     ]
   },
  "topic/libraries": {
    "title": "",
    "resources": [
      "topic/libraries/support-library/index.html",
      "topic/libraries/testing-support-library/index.html",
      "topic/libraries/data-binding/index.html"
    ]
  },
  "autolanding": {
    "title": "",
    "resources": [
      "auto/index.html",
      "design/auto/index.html",
      "training/auto/index.html"
    ]
  },
  "tvlanding": {
    "title": "",
    "resources": [
      "tv/index.html",
      "design/tv/index.html",
      "training/tv/index.html"
    ]
  },
  "wearlanding": {
    "title": "",
    "resources": [
      "design/wear/index.html",
      "training/building-wearables.html",
      "training/wearables/ui/index.html"
    ]
  },
  "wear/preview/landing": {
    "title": "",
    "resources": [
      "wear/preview/api-overview.html",
      "wear/preview/downloads.html",
      "wear/preview/start.html"
    ]
  },
  "wear/preview/landing/resources": {
    "title": "",
    "resources": [
      "wear/preview/features/complications.html",
      "wear/preview/features/notifications.html",
      "wear/preview/features/ui-nav-actions.html"
    ]
  },
  "design/auto/auto_ui_guidelines": {
    "title": "",
    "resources": [
      "shareables/auto/AndroidAuto-audio-apps.pdf",
      "shareables/auto/AndroidAuto-messaging-apps.pdf",
      "shareables/auto/AndroidAuto-custom-colors.pdf"
    ]
  },
  "training/auto/overview": {
    "title": "",
    "resources": [
      "training/auto/start/index.html",
      "design/auto/index.html",
      "shareables/auto/AndroidAuto-custom-colors.pdf"
    ]
  },
  "training/auto/messaging": {
    "title": "",
    "resources": [
      "training/auto/messaging/index.html",
      "shareables/auto/AndroidAuto-messaging-apps.pdf",
      "samples/MessagingService/index.html"
    ]
  },
  "training/auto/media": {
    "title": "",
    "resources": [
      "training/auto/audio/index.html",
      "shareables/auto/AndroidAuto-audio-apps.pdf",
      "samples/MediaBrowserService/index.html"
    ]
  },
  "training/auto/distribute": {
    "title": "",
    "resources": [
      "distribute/essentials/quality/auto.html",
      "distribute/googleplay/auto.html"
    ]
  },
  "distribute/stories/games": {
    "title": "",
    "resources": [
      "https://storage.googleapis.com/androiddevelopers/shareables/stories/Glu_Deerhunter2014_gpgs.pdf",
      "https://storage.googleapis.com/androiddevelopers/shareables/stories/ConcreteSoftware_PBABowling_gpgs.pdf",
      "https://storage.googleapis.com/androiddevelopers/shareables/stories/Dragonplay_DragonplaySlots_gpgs.pdf",
      "https://storage.googleapis.com/androiddevelopers/shareables/stories/Gameloft_Asphalt8_gpgs.pdf",
      "https://storage.googleapis.com/androiddevelopers/shareables/stories/Glu_EternityWarriors3_gpgs.pdf",
      "https://storage.googleapis.com/androiddevelopers/shareables/stories/HotheadGames_RivalsatWar_gpgs.pdf",
      "https://storage.googleapis.com/androiddevelopers/shareables/stories/TMSOFT_Compulsive_gpgs.pdf",
      "https://storage.googleapis.com/androiddevelopers/shareables/stories/Noodlecake_SuperStickmanGolf2_gpgs.pdf",
      "https://storage.googleapis.com/androiddevelopers/shareables/stories/TinyRebel_DoctorWhoLegacy_gpgs.pdf",
      "https://storage.googleapis.com/androiddevelopers/shareables/stories/Senri_LeosFortune_gpgs.pdf"
    ]
  },
  "distribute/stories/games/docs": {
    "title": "",
    "resources": [
      "distribute/stories/games/animoca-star-girl.html",
      "distribute/stories/games/happy-labs-experiment.html",
      "distribute/stories/games/playlab-puzzles.html",
      "distribute/stories/games/upbeat-games.html",
      "distribute/stories/games/tapps.html",
      "distribute/stories/games/noodlecake-super-stickman.html",
      "distribute/stories/games/glu-tap-baseball.html",
      "distribute/stories/games/doctor-who-legacy.html",
      "distribute/stories/games/glu-dh.html",
      "distribute/stories/games/dots.html",
      "distribute/stories/games/kongregate-adv-cap.html",
      "distribute/stories/games/kongregate-global-assault.html",
      "distribute/stories/games/leos-fortune.html",
      "distribute/stories/games/tiny-co.html",
      "distribute/stories/games/g4a-indian-rummy.html",
      "distribute/stories/games/rvappstudios-zombie.html",
      "distribute/stories/games/glu-eternity-warriors.html",
      "distribute/stories/games/hotheadgames-firefight.html",
      "distribute/stories/games/concrete-bowling.html",
      "distribute/stories/games/gameloft-asphalt8.html"
    ]
  },
  "distribute/stories/apps/docs": {
    "title": "",
    "resources": [
      "distribute/stories/apps/condenast-shopping.html",
      "distribute/stories/apps/economist-espresso.html",
      "distribute/stories/apps/expressen-sports.html",
      "distribute/stories/apps/drupe-communications.html",
      "distribute/stories/apps/noom-health.html",
      "distribute/stories/apps/aftenposten.html",
      "distribute/stories/apps/el-mundo.html",
      "distribute/stories/apps/segundamano.html",
      "distribute/stories/apps/remember-the-milk.html",
      "distribute/stories/apps/intuit-mint.html",
      "distribute/stories/apps/sayhi.html",
    ]
  },
  "training/testing/overview": {
    "title": "",
    "resources": [
      "training/testing/start/index.html",
      "studio/test/index.html",
      "https://www.youtube.com/watch?v=vdasFFfXKOY"
    ]
  },
  "training/testing/tools": {
    "title": "",
    "resources": [
      "topic/libraries/testing-support-library/index.html",
      "studio/test/monkey.html",
      "studio/test/monkeyrunner/index.html",
      "studio/test/command-line.html",
      "https://source.android.com/devices/tech/debug/dumpsys.html"
    ]
  },
  "training/testing/techniques": {
    "title": "",
    "resources": [
      "training/testing/ui-testing/index.html",
      "training/testing/unit-testing/index.html",
      "training/testing/performance.html"
    ]
  },
  "training/testing/resources": {
    "title": "",
    "resources": [
      "https://github.com/googlesamples/android-testing",
      "https://www.youtube.com/watch?v=2I6fuD20qlY",
      "https://codelabs.developers.google.com/codelabs/android-testing/index.html",
      "https://github.com/googlesamples/android-testing-templates",
      "https://google.github.io/android-testing-support-library"
    ]
  },
  "overview/1": {
    "title": "",
    "resources": [
      "distribute/essentials/quality/core.html",
      "distribute/essentials/quality/tablets.html",
      "distribute/tools/launch-checklist.html",
      "studio/publish/index.html",
      "distribute/tools/localization-checklist.html"
    ]
  },
  "overview/2": {
    "title": "",
    "resources": [
      "google/play/billing/index.html",
      "google/play/billing/api.html",
      "google/play/billing/billing_admin.html",
      "google/play/billing/billing_testing.html",
      "google/play/billing/billing_best_practices.html"
    ]
  },
  "overview/3": {
    "title": "",
    "resources": [
      "https://play.google.com/intl/en_us/badges/",
      "distribute/tools/promote/device-art.html",
      "distribute/tools/promote/linking.html",
      "distribute/tools/promote/brand.html",
      "studio/build/shrink-code.html"
    ]
  },
  "overview/4": {
    "title": "",
    "resources": [
      "design/style/writing.html",
      "training/basics/fragments/fragment-ui.html",
      "training/multiscreen/index.html",
      "training/monitoring-device-state/index.html"
    ]
  },
"tools/help/log": {
    "title": "",
    "resources": [
       "studio/debug/am-logcat.html"
    ]
  },
"tools/help/monitor": {
    "title": "",
    "resources": [
       "studio/profile/am-memory.html",
       "studio/profile/am-cpu.html",
       "studio/profile/am-gpu.html",
       "studio/profile/am-network.html"
    ]
  },
 "tools/help/data": {
    "title": "",
    "resources": [
       "studio/profile/am-hprof.html",
       "studio/profile/am-allocation.html",
       "studio/profile/am-methodtrace.html",
       "studio/profile/am-sysinfo.html"
    ]
  },
"tools/help/gpu": {
    "title": "",
    "resources": [
       "studio/debug/am-gpu-debugger.html"
    ]
  },
  "tools/help/shot": {
    "title": "",
    "resources": [
       "studio/debug/am-screenshot.html",
       "studio/debug/am-video.html"
    ]
  },
  "tools/performance/rendering": {
    "title": "",
    "resources": [
      "studio/profile/dev-options-overdraw.html",
      "studio/profile/dev-options-rendering.html",
      "studio/profile/hierarchy-viewer-setup.html",
      "studio/profile/hierarchy-viewer-walkthru.html",
      "studio/profile/hierarchy-viewer-results-walkthru.html"
    ]
  },
  "tools/performance/memory": {
    "title": "",
    "resources": [
      "studio/tools/performance/memory-monitor/index.html",
      "studio/profile/heap-viewer-walkthru.html",
      "studio/profile/allocation-tracker-walkthru.html",
      "studio/tools/performance/comparison.html"
    ]
  },
  "tools/performance/cpu": {
    "title": "",
    "resources": [
      "studio/profile/traceview-walkthru.html",
      "studio/profile/systrace-walkthru.html"
    ]
  },
  "tools/performance/battery": {
    "title": "",
    "resources": [
      "studio/profile/battery-historian.html",
      "studio/profile/battery-historian-charts.html"
    ]
  },
  "marshmallow/landing/resources": {
    "title": "",
    "resources": [
      "about/versions/marshmallow/android-6.0-changes.html",
      "about/versions/marshmallow/android-6.0.html",
      "about/versions/marshmallow/samples.html"
    ]
  },
  "marshmallow/landing/videos": {
    "title": "",
    "resources": [
      "https://youtu.be/U9tw5ypqEN0",
      "https://youtu.be/N72ksDKrX6c",
      "https://youtu.be/iZqDdvhTZj0",
      "https://www.youtube.com/watch?v=vcSj8ln-BlE",
      "https://youtu.be/LQoohRwojmw",
      "https://www.youtube.com/watch?v=VOn7VrTRlA4",
      "https://youtu.be/5sCQjeGoE7M",
      "https://www.youtube.com/watch?v=C8lUdPVSzDk",
      "https://www.youtube.com/watch?v=HXacyy0HSW0",
      "https://www.youtube.com/watch?v=OW1A4XFRuyc",
      "https://www.youtube.com/watch?v=j3QC6hcpy90",
      "https://www.youtube.com/watch?v=f17qe9vZ8RM",
      "https://www.youtube.com/watch?v=ndBdf1_oOGA"
    ]
  },
  "marshmallow/landing/more": {
    "title": "",
    "resources": [
      "training/permissions/requesting.html",
      "training/backup/autosyncapi.html",
      "training/monitoring-device-state/doze-standby.html",
      "training/app-links/index.html",
      "training/articles/assistant.html",
      "training/testing/performance.html",
      "https://developers.google.com/android/nexus/images"
    ]
  },
  "tools/landing/carousel": {
    "title": "",
    "resources": [
    "panel1",
    "panel2",
    "panel3",
    "panel4",
    ]
  },
  "tools/landing/resources": {
    "title": "",
    "resources": [
    "studio/features.html",
    "studio/intro/index.html",
    "studio/build/index.html",
    ]
  },
  "tools/landing/latest": {
    "title": "",
    "resources": [
    "https://medium.com/google-developers/how-often-should-you-update-android-studio-db25785c488e#.8blbql35x",
    "https://android-developers.blogspot.com/2016/09/android-studio-2-2.html",
    "https://medium.com/google-developers/writing-more-code-by-writing-less-code-with-android-studio-live-templates-244f648d17c7#.hczcm02du",
    ]
  },
  "nougat/landing/resources": {
    "title": "",
    "resources": [
      "about/versions/nougat/android-7.0.html",
      "about/versions/nougat/android-7.0-changes.html",
      "about/versions/nougat/android-7.0-samples.html",
    ]
  },

  "nougat/landing/videos/first": {
    "title": "",
    "resources": [
    "https://www.youtube.com/watch?v=CsulIu3UaUM"
    ]
  },

  "develop/performance/landing": {
    "title": "",
    "resources": [
      "https://android-developers.blogspot.com/2010/07/multithreading-for-performance.html",
      "https://www.udacity.com/course/ud825",
      "https://www.youtube.com/watch?v=N72ksDKrX6c",
      "tools/performance/index.html",
      "https://codelabs.developers.google.com/codelabs/android-perf-testing/index.html",
      "training/articles/memory.html",
    ]
  },
  "nougat/landing/more": {
    "title": "",
    "resources": [
      "guide/topics/ui/multi-window.html",
      "guide/topics/ui/notifiers/notifications.html",
      "topic/performance/background-optimization.html",
      "training/basics/network-ops/data-saver.html",
      "training/articles/direct-boot.html",
      "guide/topics/resources/icu4j-framework.html",
      "guide/topics/resources/multilingual-support.html",
      "training/articles/scoped-directory-access.html",
      "training/articles/security-config.html",
      "training/tv/playback/picture-in-picture.html",
      "training/tv/tif/content-recording.html"
    ]
  },
  "work/landing/primary": {
    "title": "",
    "resources": [
      "work/overview.html",
      "work/guide.html",
      "https://www.google.com/work/android/developers/applyDevHub/",
      "work/managed-configurations.html",
      "work/cosu.html",
      "work/managed-profiles.html"
    ]
  },
  "work/landing/resources": {
    "title": "",
    "resources": [
      "https://developers.google.com/android/work/",
      "https://www.google.com/work/android/",
      "https://developers.google.com/android/work/build-dpc",
      "https://www.youtube.com/watch?v=jQWB_-o1kz4&list=PLOU2XLYxmsIKAK2Bhv19H2THwF-22O5WX",
      "https://www.youtube.com/watch?v=Za0OQo8DRM4",
      "https://www.youtube.com/watch?v=dH41OutAMNM&list=PLOU2XLYxmsIKAK2Bhv19H2THwF-22O5WX"
    ]
  },
  "work/apps": {
    "title": "",
    "resources": [
      "work/managed-profiles.html",
      "work/managed-configurations.html",
      "work/cosu.html",
      "https://www.youtube.com/watch?v=39NkpWkaH8M&index=2&list=PLOU2XLYxmsIKAK2Bhv19H2THwF-22O5WX",
      "samples/AppRestrictionSchema/index.html",
      "samples/AppRestrictionEnforcer/index.html"
    ]
  },
  "work/admin": {
    "title": "",
    "resources": [
      "https://developers.google.com/android/work/build-dpc",
      "samples/BasicManagedProfile/index.html",
      "https://www.youtube.com/watch?v=j3QC6hcpy90"
    ]
  }
};

/**
 * Static search results.

   Metadata objects returned in search results page when the user enters
   each object's keyword.
 */
METADATA['en'].searchHeroCollections = {
  "material": {
    "title":"Material Design for Android",
    "category":"",
    "summary":"Material design is a comprehensive guide for visual, motion, and interaction design across platforms and devices. Android now includes support for material design apps.",
    "url":"design/material/index.html",
    "group":"",
    "keywords": ["material","design"],
    "tags": ["material","design"],
    "image":"images/cards/design-material-for-android_2x.jpg",
    "lang":"en",
    "type":"design"
  }
};
