/*
 * Copyright (C) 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef AAPT_PROCESS_IRESOURCETABLECONSUMER_H
#define AAPT_PROCESS_IRESOURCETABLECONSUMER_H

#include "Diagnostics.h"
#include "NameMangler.h"
#include "Resource.h"
#include "ResourceValues.h"
#include "Source.h"

#include <iostream>
#include <list>
#include <sstream>

namespace aapt {

class ResourceTable;
struct ISymbolTable;

struct IAaptContext {
    virtual ~IAaptContext() = default;

    virtual ISymbolTable* getExternalSymbols() = 0;
    virtual IDiagnostics* getDiagnostics() = 0;
    virtual StringPiece16 getCompilationPackage() = 0;
    virtual uint8_t getPackageId() = 0;
    virtual NameMangler* getNameMangler() = 0;
};

struct IResourceTableConsumer {
    virtual ~IResourceTableConsumer() = default;

    virtual bool consume(IAaptContext* context, ResourceTable* table) = 0;
};

namespace xml {
struct XmlResource;
}

struct IXmlResourceConsumer {
    virtual ~IXmlResourceConsumer() = default;

    virtual bool consume(IAaptContext* context, xml::XmlResource* resource) = 0;
};

} // namespace aapt

#endif /* AAPT_PROCESS_IRESOURCETABLECONSUMER_H */
