/*
 * Copyright (C) 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.mediaframeworktest.unit;

import android.hardware.Camera;
import android.test.suitebuilder.annotation.SmallTest;
import android.util.Log;

/**
 * <pre>
 * adb shell am instrument \
 *      -e class 'com.android.mediaframeworktest.unit.CameraOpenTest' \
 *      -w com.android.mediaframeworktest/.MediaFrameworkUnitTestRunner
 * </pre>
 */
public class CameraOpenTest extends junit.framework.TestCase {
    private static String TAG = "CameraOpenTest";

    private Camera mCamera;

    /**
     * Test @hide android.hardware.Camera#openLegacy API that cannot be tested in CTS.
     */
    @SmallTest
    public void testOpenLegacy() {
        int nCameras = Camera.getNumberOfCameras();
        for (int id = 0; id < nCameras; id++) {
            try {
                mCamera.openLegacy(id, Camera.CAMERA_HAL_API_VERSION_1_0);
            } catch (RuntimeException e) {
                Log.i(TAG, "Unable to open camera as HAL1 legacy camera device " + e);
            } finally {
                if (mCamera != null) {
                    mCamera.release();
                }
            }
        }
    }
}
