/* Metadata represendations of resources that are outside of the autogenerated
   local resource lists, or that override local resource representations.

   Resources listed here are referenced from sitemap sections and collections,
   matched by url string if there is no resource existing in ALL_RESOURCES.

   Currently, these articles can override only the generated resources
   in DISTRIBUTE_RESOURCES. A representation defined here will not be applied
   when a collection or section specifies a url that's not in DISTRIBUTE_RESOURCEs.
   Also
   So if a section url refers to a static doc that's
   not in a distribute section, you need to create an item for
   it in this file. Fix is to compare across
   ALL_RESOURCES_BY_URL.  */

METADATA['ja'].extras = METADATA['ja'].extras.concat([
 /* TODO Remove standard resources from here, such as below
 */
  {
    "lang": "ja",
    "title": "Gaming Everywhere",
    "category": "",
    "summary": "東京ゲームショウ 2014 の基調講演より。",
    "url": "https://www.youtube.com/watch?v=xelYnWcYkuE",
    "group": "",
    "keywords": [],
    "tags": [],
    "image": "https://img.youtube.com/vi/xelYnWcYkuE/hqdefault.jpg",
    "type": "youtube"
  },
  {
    "lang": "ja",
    "title": "Playtime Tokyo",
    "category": "",
    "summary": "アプリビジネスのノウハウを各担当者が講演しました。",
    "url": "https://www.youtube.com/playlist?list=PLCOC_kP3nqGIHEgwm9mybvA04Vn4Cg9nn",
    "group": "",
    "keywords": [],
    "tags": [],
    "image": "https://img.youtube.com/vi/lJdjY3z6-LY/hqdefault.jpg",
    "type": "youtube"
  },
  {
    "lang": "ja",
    "title": "Android Wear 関連の動画に日本語字幕が付きました",
    "category": "",
    "summary": "",
    "url": "https://googledevjp.blogspot.jp/2014/12/android-wear.html",
    "group": "",
    "keywords": [],
    "tags": [],
    "image": "https://i1.ytimg.com/vi/4JcDYkgqksY/maxresdefault.jpg",
    "type": "blog"
  },
  {
    "lang": "ja",
    "title": "Android Studio 1.0 をリリースしました",
    "category": "",
    "summary": "",
    "url": "https://googledevjp.blogspot.jp/2014/12/android-studio-10.html",
    "group": "",
    "keywords": [],
    "tags": [],
    "image": "https://3.bp.blogspot.com/-1hV3sD1At74/VIaQSWBasUI/AAAAAAAABAU/9vYLJMsmMuQ/s1600/studio-logo.png",
    "type": "blog"
  },
  {
    "lang": "ja",
    "title": "Google Play 開発者サービス 6.5 のご紹介",
    "category": "",
    "summary": "",
    "url": "https://googledevjp.blogspot.jp/2014/12/google-play-65.html",
    "group": "",
    "keywords": [],
    "tags": [],
    "image": "https://1.bp.blogspot.com/-4BNREC0Jojo/VGo7ahW35wI/AAAAAAAABAc/9thZl94F6fY/s1600/GMS%2B-%2BRelease%2BBlog%2BNacho%2B-%2BMap%2BToolbar.png",
    "type": "blog"
  },
  {
    "lang": "ja",
    "title": "Alpha and Beta Testing",
    "category": "",
    "summary": "アプリのローンチにまつわるリスクを最小限にするために必須のツールです。[英語コンテンツ]",
    "url": "intl/ja/distribute/googleplay/developer-console.html#alpha-beta",
    "group": "",
    "keywords": [],
    "tags": [],
    "image": "images/gp-dc-ab.png",
    "type": "distribute"
  },
  {
    "lang": "ja",
    "title": "Finding Success on Google Play",
    "category": "",
    "summary": "Google Play での成功の秘訣がこの一冊に。[英語コンテンツ]",
    "url": "intl/ja/distribute/googleplay/guide.html",
    "group": "",
    "keywords": [],
    "tags": [],
    "image": "distribute/images/play_dev_guide_b.jpg",
    "type": "distribute"
  },
  {
    "lang": "ja",
    "title": "Google Play アプリ ポリシー センター",
    "category": "",
    "summary": "",
    "url": "https://support.google.com/googleplay/android-developer/answer/4430948?hl=ja",
    "group": "",
    "keywords": [],
    "tags": [],
    "image": "https://storage.googleapis.com/support-kms-prod/SNP_712EA2784949DDF085C46E3BE7B1DC618A09_4389356_en_v0",
    "type": "distribute"
  },
  {
    "lang": "ja",
    "title": "Wear App Quality",
    "category": "",
    "summary": "いよいよウェアラブルの時代が到来。[英語コンテンツ]",
    "url": "intl/ja/distribute/essentials/quality/wear.html",
    "group": "",
    "keywords": [],
    "tags": [],
    "image": "distribute/images/gp-wear-quality.png",
    "type": "distribute"
  },
  {
    "lang": "ja",
    "title": "Google Cloud Platform が支える、新感覚リアルタイム RPG ユニゾンリーグ - 株式会社エイチームの GCP 導入事例",
    "category": "",
    "summary": "スケーラブルなバックエンドを実現する Google Cloud Platform の最新導入事例。",
    "url": "https://googleforwork-japan.blogspot.jp/2014/12/gcp-google-cloud-platform-rpg-gcp.html",
    "group": "",
    "keywords": [],
    "tags": [],
    "image": "https://3.bp.blogspot.com/-xp7KoPkbne4/VI_PfoFil3I/AAAAAAAAA3U/-k1UZ0zjCBc/s1600/unison-league.jpeg",
    "type": "distribute"
  },
  {
    "lang": "ja",
    "title": "Monetize with Ads",
    "category": "",
    "summary": "アプリ内広告成功のコツがここに。[英語コンテンツ]",
    "url": "intl/ja/distribute/monetize/ads.html",
    "group": "",
    "keywords": [],
    "tags": [],
    "image": "distribute/images/advertising.jpg",
    "type": "distribute"
  },
]);

//must use intl/nn url to override a translated resource
METADATA['ja'].carousel = {
  "intl/ja/distribute/googleplay/guide.html": {
    "image": "images/distribute/hero-secrets-to-app-success.jpg",
    "title": "Secrets to App Success on Google Play",
    "summary": "Get the updated guide full of useful features, tips, and best practices that will help you grow a successful app or game business on Google Play.",
  },
};

/**
 * Static metadata collections.
 */
METADATA['ja'].collections = {
  "launch/static/ja": {
    "title": "",
    "resources": [
      "https://www.youtube.com/watch?v=xelYnWcYkuE",
      "https://www.youtube.com/playlist?list=PLCOC_kP3nqGIHEgwm9mybvA04Vn4Cg9nn",
      "https://googledevjp.blogspot.jp/2014/12/android-wear.html",
      "https://googledevjp.blogspot.jp/2014/12/android-studio-10.html",
      "https://googledevjp.blogspot.jp/2014/12/google-play-65.html",
      "distribute/googleplay/developer-console.html#alpha-beta",
      "distribute/googleplay/guide.html",
      "distribute/essentials/quality/core.html",
      "https://support.google.com/googleplay/android-developer/answer/4430948?hl=ja",
      "support.html",
      "distribute/essentials/quality/wear.html",
      "training/tv/start/index.html",
      "https://googleforwork-japan.blogspot.jp/2014/12/gcp-google-cloud-platform-rpg-gcp.html",
      "distribute/monetize/ads.html"
    ]
  },
};