/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.internal.telecomm;

import android.app.PendingIntent;
import android.telecomm.AudioState;
import android.telecomm.ParcelableCall;

import com.android.internal.telecomm.IInCallAdapter;

/**
 * Internal remote interface for in-call services.
 *
 * @see android.telecomm.InCallService
 *
 * {@hide}
 */
oneway interface IInCallService {
    void setInCallAdapter(in IInCallAdapter inCallAdapter);

    void addCall(in ParcelableCall call);

    void updateCall(in ParcelableCall call);

    void setPostDial(String callId, String remaining);

    void setPostDialWait(String callId, String remaining);

    void onAudioStateChanged(in AudioState audioState);

    void bringToForeground(boolean showDialpad);

    void startActivity(String callId, in PendingIntent intent);
}
