<ul id="nav">
  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/index.html">
        Getting Started
      </a>
    </div>

    <ul>
      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/basics/firstapp/index.html"
             description=
             "After you've installed the Android SDK, start with this class
             to learn the basics about Android app development."
            >Building Your First App</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/basics/firstapp/creating-project.html">
            Creating an Android Project
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/firstapp/running-app.html">
            Running Your Application
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/firstapp/building-ui.html">
            Building a Simple User Interface
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/firstapp/starting-activity.html">
            Starting Another Activity
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/basics/actionbar/index.html"
             description=
             "The action bar is one of the most important design elements you can implement for your
app's activities. Although first introduced with API level 11, you can use the Support Library to
include the action bar on devices running Android 2.1 or higher."
            >Adding the Action Bar</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/basics/actionbar/setting-up.html">
            Setting Up the Action Bar
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/actionbar/adding-buttons.html">
            Adding Action Buttons
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/actionbar/styling.html">
            Styling the Action Bar
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/actionbar/overlaying.html">
            Overlaying the Action Bar
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/basics/supporting-devices/index.html"
             description=
             "How to build your app with alternative resources that provide an
             optimized user experience on multiple device form factors using a single APK."
            >Supporting Different Devices</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/basics/supporting-devices/languages.html">
            Supporting Different Languages
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/supporting-devices/screens.html">
            Supporting Different Screens
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/supporting-devices/platforms.html">
            Supporting Different Platform Versions
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/basics/activity-lifecycle/index.html"
             description=
             "How Android activities live and die and how to create
             a seamless user experience by implementing lifecycle callback methods."
            >Managing the Activity Lifecycle</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/basics/activity-lifecycle/starting.html">
            Starting an Activity
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/activity-lifecycle/pausing.html">
            Pausing and Resuming an Activity
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/activity-lifecycle/stopping.html">
            Stopping and Restarting an Activity
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/activity-lifecycle/recreating.html">
            Recreating an Activity
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/basics/fragments/index.html"
             description=
             "How to build a user interface for your app that is flexible enough
             to present multiple UI components on large screens and a more constrained set of
             UI components on smaller screens&mdash;essential for building a single APK for both
             phones and tablets."
            >Building a Dynamic UI with Fragments</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/basics/fragments/creating.html">
            Creating a Fragment
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/fragments/fragment-ui.html">
            Building a Flexible UI
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/fragments/communicating.html">
            Communicating with Other Fragments
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header"><a href="<?cs var:toroot?>training/basics/data-storage/index.html"
             description=
             "How to save data on the device, whether it's temporary files, downloaded
             app assets, user media, structured data, or something else."
            >Saving Data</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/basics/data-storage/shared-preferences.html">
            Saving Key-Value Sets
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/data-storage/files.html">
            Saving Files
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/data-storage/databases.html">
            Saving Data in SQL Databases
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/basics/intents/index.html"
             description=
             "How to build a user experience that leverages other apps available
             on the device to perform advanced user tasks, such as capture a photo or view
             an address on a map."
            >Interacting with Other Apps</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/basics/intents/sending.html">
            Sending the User to Another App
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/intents/result.html">
            Getting a Result from the Activity
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/intents/filters.html">
            Allowing Other Apps to Start Your Activity
          </a>
          </li>
        </ul>
      </li>

    </ul>
  </li><!-- end getting started -->
    <li class="nav-section">
        <div class="nav-section-header">
            <a href="<?cs var:toroot ?>training/building-content-sharing.html">
            <span class="small">Building Apps with</span><br/>Content Sharing
            </a>
        </div>
        <ul>
            <li class="nav-section">
                <div class="nav-section-header">
                    <a href="<?cs var:toroot ?>training/sharing/index.html"
                    description=
                    "How to take your app interaction to the next level by sharing
                    information with other apps, receive information back, and provide a simple and
                    scalable way to perform Share actions with user content."
                    >Sharing Simple Data</a>
                </div>
                <ul>
                    <li>
                        <a href="<?cs var:toroot ?>training/sharing/send.html">
                        Sending Simple Data to Other Apps
                        </a>
                    </li>
                    <li>
                        <a href="<?cs var:toroot ?>training/sharing/receive.html">
                        Receiving Simple Data from Other Apps
                        </a>
                    </li>
                    <li>
                        <a href="<?cs var:toroot ?>training/sharing/shareaction.html">
                        Adding an Easy Share Action
                        </a>
                    </li>
                </ul>
            </li>
            <li class="nav-section">
                <div class="nav-section-header">
                    <a href="<?cs var:toroot?>training/secure-file-sharing/index.html"
                    description=
                    "How to provide secure access to a file associated with your app using a content
                    URI and temporary access permissions."
                    >Sharing Files</a>
                </div>
                <ul>
                    <li>
                        <a href="<?cs var:toroot ?>training/secure-file-sharing/setup-sharing.html">
                        Setting Up File Sharing
                        </a>
                    </li>
                    <li>
                        <a href="<?cs var:toroot ?>training/secure-file-sharing/share-file.html">
                        Sharing a File
                        </a>
                    </li>
                    <li>
                        <a href="<?cs var:toroot ?>training/secure-file-sharing/request-file.html">
                        Requesting a Shared File
                        </a>
                    </li>
                    <li>
                        <a href="<?cs var:toroot ?>training/secure-file-sharing/retrieve-info.html">
                        Retrieving File Information
                        </a>
                    </li>
                </ul>
            </li>
            <li class="nav-section">
                <div class="nav-section-header">
                    <a href="<?cs var:toroot ?>training/beam-files/index.html"
                    description=
                    "How to transfer files between devices using the NFC Android Beam feature."
                    >Sharing Files with NFC</a>
                </div>
                <ul>
                    <li>
                        <a href="<?cs var:toroot ?>training/beam-files/send-files.html"
                        >Sending Files to Another Device</a>
                    </li>
                    <li><a href="<?cs var:toroot ?>training/beam-files/receive-files.html"
                    >Receiving Files from Another Device</a></li>
                </ul>
            </li>
        </ul>
    </li>



  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/building-multimedia.html">
      <span class="small">Building Apps with</span><br/>Multimedia
      </a>
    </div>
    <ul>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/managing-audio/index.html"
             description=
             "How to respond to hardware audio key presses, request audio focus
             when playing audio, and respond appropriately to changes in audio focus."
            >Managing Audio Playback</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/managing-audio/volume-playback.html">
            Controlling Your App's Volume and Playback
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/managing-audio/audio-focus.html">
            Managing Audio Focus
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/managing-audio/audio-output.html">
            Dealing with Audio Output Hardware
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/camera/index.html"
             description=
             "How to leverage existing camera apps on the user's device to capture
             photos or control the camera hardware directly and build your own camera app."
            >Capturing Photos</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/camera/photobasics.html">
            Taking Photos Simply
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/camera/videobasics.html">
            Recording Videos Simply
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/camera/cameradirect.html">
            Controlling the Camera
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/printing/index.html"
             description=
             "How to print photos, HTML documents, and custom documents from your app."
            >Printing Content</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/printing/photos.html">
            Photos
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/printing/html-docs.html">
            HTML Documents
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/printing/custom-docs.html">
            Custom Documents
          </a>
          </li>
        </ul>
      </li>

    </ul>
  </li>
  <!-- End multimedia -->



  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/building-graphics.html">
      <span class="small">Building Apps with</span><br/>Graphics &amp; Animation
      </a>
    </div>
    <ul>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/displaying-bitmaps/index.html"
             description=
             "How to load and process bitmaps while keeping your user interface
             responsive and avoid exceeding memory limits."
            >Displaying Bitmaps Efficiently</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/displaying-bitmaps/load-bitmap.html">
            Loading Large Bitmaps Efficiently
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/displaying-bitmaps/process-bitmap.html">
            Processing Bitmaps Off the UI Thread
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/displaying-bitmaps/cache-bitmap.html">
            Caching Bitmaps
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/displaying-bitmaps/manage-memory.html">
            Managing Bitmap Memory
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/displaying-bitmaps/display-bitmap.html">
            Displaying Bitmaps in Your UI
          </a></li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot?>training/graphics/opengl/index.html"
             description=
             "How to create OpenGL graphics within the Android app framework
             and respond to touch input."
            >Displaying Graphics with OpenGL ES</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/graphics/opengl/environment.html">
            Building an OpenGL ES Environment
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/graphics/opengl/shapes.html">
            Defining Shapes
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/graphics/opengl/draw.html">
            Drawing Shapes
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/graphics/opengl/projection.html">
            Applying Projection and Camera Views
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/graphics/opengl/motion.html">
            Adding Motion
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/graphics/opengl/touch.html">
            Responding to Touch Events
          </a>
          </li>
        </ul>
      </li>
      <li class="nav-section">
        <div class="nav-section-header"><a href="<?cs var:toroot ?>training/animation/index.html"
             description=
             "How to add transitional animations to your user interface.">
            Adding Animations
          </a></div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/animation/crossfade.html">
            Crossfading Two Views
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/animation/screen-slide.html">
            Using ViewPager for Screen Slide
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/animation/cardflip.html">
            Displaying Card Flip Animations
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/animation/zoom.html">
            Zooming a View
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/animation/layout.html">
            Animating Layout Changes
          </a>
          </li>
        </ul>
      </li>
    </ul>
  </li>
  <!-- End graphics and animation -->


  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/building-connectivity.html">
      <span class="small">Building Apps with</span><br/>
              Connectivity &amp; the Cloud
      </a>
    </div>
    <ul>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/connect-devices-wirelessly/index.html"
             description=
             "How to find and connect to local devices using Network Service
             Discovery and how to create peer-to-peer connections with Wi-Fi."
             >Connecting Devices Wirelessly</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/connect-devices-wirelessly/nsd.html">
            Using Network Service Discovery
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/connect-devices-wirelessly/wifi-direct.html">
            Creating P2P Connections with Wi-Fi
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/connect-devices-wirelessly/nsd-wifi-direct.html">
            Using Wi-Fi P2P for Service Discovery
          </a>
          </li>
        </ul>
      </li>
       <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/basics/network-ops/index.html"
             description=
             "How to create a network connection, monitor the connection for changes
             in connectivity, and perform transactions with XML data."
            >Performing Network Operations</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/basics/network-ops/connecting.html">
            Connecting to the Network
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/network-ops/managing.html">
            Managing Network Usage
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/basics/network-ops/xml.html">
            Parsing XML Data
          </a>
          </li>
        </ul>
      </li>
      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/efficient-downloads/index.html"
             description=
             "How to minimize your app's impact on the battery when performing downloads
             and other network transactions."
            >Transferring Data Without Draining the Battery</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/efficient-downloads/efficient-network-access.html">
            Optimizing Downloads for Efficient Network Access
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/efficient-downloads/regular_updates.html">
            Minimizing the Effect of Regular Updates
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/efficient-downloads/redundant_redundant.html">
            Redundant Downloads are Redundant
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/efficient-downloads/connectivity_patterns.html">
            Modifying Patterns Based on the Connectivity Type
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/cloudsync/index.html"
             description=
             "How to sync and back up app and user data to remote web services in the
              cloud and how to restore the data back to multiple devices."
            >Syncing to the Cloud</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/cloudsync/backupapi.html">
            Using the Backup API
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/cloudsync/gcm.html">
            Making the Most of Google Cloud Messaging
          </a>
          </li>
        </ul>
        <li><a href="<?cs var:toroot ?>training/cloudsave/conflict-res.html"
           description=
           "How to design a robust conflict resolution strategy for apps that save data to the cloud."
           >Resolving Cloud Save Conflicts
          </a>
        </li>
      </li>
      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/sync-adapters/index.html"
             description="How to transfer data between the cloud and the device using the Android
             sync adapter framework"
             >Transferring Data Using Sync Adapters</a>
        </div>
        <ul>
            <li>
                <a href="<?cs var:toroot ?>training/sync-adapters/creating-authenticator.html">
                Creating a Stub Authenticator
                </a>
            </li>
            <li>
                <a href="<?cs var:toroot ?>training/sync-adapters/creating-stub-provider.html">
                Creating a Stub Content Provider
                </a>
            </li>
            <li>
                <a href="<?cs var:toroot ?>training/sync-adapters/creating-sync-adapter.html">
                Creating a Sync Adapter
                </a>
            </li>
            <li>
                <a href="<?cs var:toroot ?>training/sync-adapters/running-sync-adapter.html">
                Running a Sync Adapter
                </a>
            </li>
        </ul>
      </li>
      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/volley/index.html"
             description="How to perform fast, scalable UI operations over the network using Volley"
             >Transmitting Network Data Using Volley</a>
        </div>
        <ul>
            <li>
                <a href="<?cs var:toroot ?>training/volley/simple.html">
                Sending a Simple Request
                </a>
            </li>
            <li>
                <a href="<?cs var:toroot ?>training/volley/requestqueue.html">
                Setting Up a RequestQueue
                </a>
            </li>
            <li>
                <a href="<?cs var:toroot ?>training/volley/request.html">
                Making a Standard Request
                </a>
            </li>
            <li>
                <a href="<?cs var:toroot ?>training/volley/request-custom.html">
                Implementing a Custom Request
                </a>
            </li>
        </ul>
      </li>
    </ul>
  </li>
  <!-- End connectivity and cloud -->



  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/building-userinfo.html">
      <span class="small">Building Apps with</span><br/>
              User Info &amp; Location
      </a>
    </div>
    <ul>
      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/contacts-provider/index.html"
             description=
             "How to use Android's central address book, the Contacts Provider, to
             display contacts and their details and modify contact information.">
          Accessing Contacts Data</a>
        </div>
        <ul>
          <li>
                <a href="<?cs var:toroot ?>training/contacts-provider/retrieve-names.html">
                Retrieving a List of Contacts
                </a>
          </li>
          <li>
                <a href="<?cs var:toroot ?>training/contacts-provider/retrieve-details.html">
                Retrieving Details for a Contact
                </a>
          </li>
          <li>
                <a href="<?cs var:toroot ?>training/contacts-provider/modify-data.html">
                Modifying Contacts Using Intents
                </a>
          </li>
          <li>
                <a href="<?cs var:toroot ?>training/contacts-provider/display-contact-badge.html">
                Displaying the Quick Contact Badge
                </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/location/index.html"
             description="How to add location-aware features to your app by getting the user's current location.">
             Making Your App Location-Aware
          </a>
        </div>
        <ul>
          <li>
            <a href="<?cs var:toroot ?>training/location/retrieve-current.html">
            Retrieving the Current Location
            </a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/location/receive-location-updates.html">
            Receiving Location Updates
            </a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/location/display-address.html">
            Displaying a Location Address
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/location/geofencing.html">
            Creating and Monitoring Geofences
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/location/activity-recognition.html">
          Recognizing the User's Current Activity
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/location/location-testing.html">
          Testing Using Mock Locations
          </a>
          </li>
        </ul>
      </li>
    </ul>
  </li>
  <!-- End privacy and location -->


  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/building-wearables.html">
      <span class="small">Building Apps for</span><br/>
              Wearables
      </a>
    </div>
    <ul>
      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/wearables/notifications/index.html"
             description="How to build handheld notifications that are synced to
             and look great on wearables."
            >Adding Wearable Features to Notifications</a>
        </div>
        <ul>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/notifications/creating.html">Creating a Notification</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/notifications/voice-input.html">Receiving Voice Input in a Notification</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/notifications/pages.html">Adding Pages to a Notification</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/notifications/stacks.html">Stacking Notifications</a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/wearables/apps/index.html"
             description="How to build apps that run directly on wearables."
            >Creating Wearable Apps</a>
        </div>
        <ul>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/apps/creating.html">Creating and Running a Wearable App</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/apps/layouts.html">Creating Custom Layouts</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/apps/voice.html">Adding Voice Capabilities</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/apps/packaging.html">Packaging Wearable Apps</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/apps/bt-debugging.html">Debugging over Bluetooth</a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/wearables/data-layer/index.html"
             description="How to sync data between handhelds and wearables."
            >Sending and Syncing Data</a>
        </div>
        <ul>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/data-layer/accessing.html">Accessing the Wearable Data Layer</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/data-layer/data-items.html">Syncing Data Items</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/data-layer/assets.html">Transferring Assets</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/data-layer/messages.html">Sending and Receiving Messages</a>
          </li>
          <li>
            <a href="<?cs var:toroot ?>training/wearables/data-layer/events.html">Handling Data Layer Events</a>
          </li>
        </ul>
      </li>
    </ul>
  </li>

  <!-- End Building for wearables -->

  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/best-ux.html">
      <span class="small">Best Practices for</span><br/>
              Interaction &amp; Engagement
      </a>
    </div>
    <ul>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/design-navigation/index.html"
             description=
             "How to plan your app's screen hierarchy and forms of navigation so users can
             effectively and intuitively traverse your app content using various navigation
             patterns."
            >Designing Effective Navigation</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/design-navigation/screen-planning.html">
            Planning Screens and Their Relationships
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/design-navigation/multiple-sizes.html">
            Planning for Multiple Touchscreen Sizes
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/design-navigation/descendant-lateral.html">
            Providing Descendant and Lateral Navigation
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/design-navigation/ancestral-temporal.html">
            Providing Ancestral and Temporal Navigation
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/design-navigation/wireframing.html">
            Putting it All Together: Wireframing the Example App
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/implementing-navigation/index.html"
             description=
             "How to implement various navigation patterns such as swipe views,
             a navigation drawer, and up navigation."
            >Implementing Effective Navigation</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/implementing-navigation/lateral.html">
            Creating Swipe Views with Tabs
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/implementing-navigation/nav-drawer.html">
            Creating a Navigation Drawer
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/implementing-navigation/ancestral.html">
            Providing Up Navigation
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/implementing-navigation/temporal.html">
            Providing Proper Back Navigation
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/implementing-navigation/descendant.html">
            Implementing Descendant Navigation
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
          <div class="nav-section-header">
              <a href="<?cs var:toroot ?>training/notify-user/index.html"
                 description=
                 "How to display messages called notifications outside of
                 your application's UI."
               >Notifying the User</a>
          </div>
          <ul>
              <li>
                  <a href="<?cs var:toroot ?>training/notify-user/build-notification.html">
                  Building a Notification
                  </a>
              </li>
              <li>
                  <a href="<?cs var:toroot ?>training/notify-user/navigation.html">
                  Preserving Navigation when Starting an Activity
                  </a>
              </li>
              <li>
                  <a href="<?cs var:toroot ?>training/notify-user/managing.html">
                  Updating Notifications
                  </a>
              </li>
              <li>
                  <a href="<?cs var:toroot ?>training/notify-user/expanded.html">
                  Using Big View Styles
                  </a>
              </li>
              <li>
                  <a href="<?cs var:toroot ?>training/notify-user/display-progress.html">
                  Displaying Progress in a Notification
                  </a>
              </li>
          </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/search/index.html"
             description=
             "How to properly add a search interface to your app and create a searchable database."
            >Adding Search Functionality</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/search/setup.html">
            Setting up the Search Interface
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/search/search.html">
            Storing and Searching for Data
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/search/backward-compat.html">
            Remaining Backward Compatible
          </a>
          </li>
        </ul>
      </li>

     <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/app-indexing/index.html"
             description=
             "How to enable deep linking and indexing of your application
content so that users can open this content directly from their mobile search
results."
            >Making Your App Content Searchable by Google</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/app-indexing/deep-linking.html">
            Enabling Deep Links for App Content
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/app-indexing/enabling-app-indexing.html">
            Specifying  App Content for Indexing
          </a>
          </li>
        </ul>
      </li>
    </ul>
  </li>
  <!-- End Interaction and Engagement -->




  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/best-ui.html">
      <span class="small">Best Practices for</span><br/>
              User Interface
      </a>
    </div>
    <ul>


      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/multiscreen/index.html"
             zh-cn-lang="针对多种屏幕进行设计"
             ja-lang="複数画面のデザイン"
             es-lang="Cómo diseñar aplicaciones para varias pantallas"
             description=
             "How to build a user interface that's flexible enough to
             fit perfectly on any screen and how to create different interaction
             patterns that are optimized for different screen sizes."
            >Designing for Multiple Screens</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/multiscreen/screensizes.html"
            zh-cn-lang="支持各种屏幕尺寸"
            ko-lang="다양한 화면 크기 지원"
            ja-lang="さまざまな画面サイズのサポート"
            es-lang="Cómo admitir varios tamaños de pantalla"
            >Supporting Different Screen Sizes</a>
          </li>
          <li><a href="<?cs var:toroot ?>training/multiscreen/screendensities.html"
            zh-cn-lang="支持各种屏幕密度"
            ja-lang="さまざまな画面密度のサポート"
            es-lang="Cómo admitir varias densidades de pantalla"
            >Supporting Different Screen Densities</a>
          </li>
          <li><a href="<?cs var:toroot ?>training/multiscreen/adaptui.html"
            zh-cn-lang="实施自适应用户界面流程"
            ja-lang="順応性のある UI フローの実装"
            es-lang="Cómo implementar interfaces de usuario adaptables"
            >Implementing Adaptive UI Flows</a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header"><a href="<?cs var:toroot ?>training/tv/index.html"
             description=
             "How to optimize your app's user interface and user input for
             the &quot;ten foot experience&quot; of a TV screen."
            >Designing for TV</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/tv/optimizing-layouts-tv.html">
            Optimizing Layouts for TV
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/tv/optimizing-navigation-tv.html">
            Optimizing Navigation for TV
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/tv/unsupported-features-tv.html">
            Handling Features Not Supported on TV
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/custom-views/index.html"
             description=
             "How to build custom UI widgets that are interactive and smooth."
            >Creating Custom Views</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/custom-views/create-view.html">
            Creating a Custom View Class
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/custom-views/custom-drawing.html">
            Implementing Custom Drawing
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/custom-views/making-interactive.html">
            Making the View Interactive
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/custom-views/optimizing-view.html">
            Optimizing the View
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/backward-compatible-ui/index.html"
             description=
             "How to use UI components and other APIs from the more recent versions of Android
             while remaining compatible with older versions of the platform."
            >Creating Backward-Compatible UIs</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/backward-compatible-ui/abstracting.html">
            Abstracting the New APIs
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/backward-compatible-ui/new-implementation.html">
            Proxying to the New APIs
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/backward-compatible-ui/older-implementation.html">
            Creating an Implementation with Older APIs
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/backward-compatible-ui/using-component.html">
            Using the Version-Aware Component
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/accessibility/index.html"
             description=
             "How to make your app accessible to users with vision
             impairment or other physical disabilities."
            >Implementing Accessibility</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/accessibility/accessible-app.html">
            Developing Accessible Applications
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/accessibility/service.html">
            Developing Accessibility Services
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/system-ui/index.html"
             description=
             "How to hide and show status and navigation bars across different versions of Android,
              while managing the display of other screen components."
            >Managing the System UI</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/system-ui/dim.html">
            Dimming the System Bars
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/system-ui/status.html">
            Hiding the Status Bar
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/system-ui/navigation.html">
            Hiding the Navigation Bar
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/system-ui/immersive.html">
            Using Immersive Full-Screen Mode
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/system-ui/visibility.html">
            Responding to UI Visibility Changes
          </a>
          </li>
        </ul>
      </li>

    </ul>
  </li>
  <!-- End User Interface -->




  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/best-user-input.html">
      <span class="small">Best Practices for</span><br/>
              User Input
      </a>
    </div>
    <ul>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/gestures/index.html"
             description=
             "How to write apps that allow users to interact with the touch screen via touch gestures."
            >Using Touch Gestures</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/gestures/detector.html">
            Detecting Common Gestures
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/gestures/movement.html">
            Tracking Movement
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/gestures/scroll.html">
            Animating a Scroll Gesture
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/gestures/multi.html">
            Handling Multi-Touch Gestures
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/gestures/scale.html">
            Dragging and Scaling
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/gestures/viewgroup.html">
            Managing Touch Events in a ViewGroup
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/keyboard-input/index.html"
             description=
             "How to specify the appearance and behaviors of soft input methods (such
             as on-screen keyboards) and how to optimize the experience with
             hardware keyboards."
            >Handling Keyboard Input</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/keyboard-input/style.html">
            Specifying the Input Method Type
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/keyboard-input/visibility.html">
            Handling Input Method Visibility
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/keyboard-input/navigation.html">
            Supporting Keyboard Navigation
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/keyboard-input/commands.html">
            Handling Keyboard Actions
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/game-controllers/index.html"
             description=
             "How to write apps that support game controllers."
            >Supporting Game Controllers</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/game-controllers/controller-input.html">
            Handling Controller Actions
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/game-controllers/compatibility.html">
            Supporting Controllers Across Android Versions
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/game-controllers/multiple-controllers.html">
            Supporting Multiple Game Controllers
          </a>
          </li>
        </ul>
      </li>
    </ul>
  </li> <!-- end of User Input -->

  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/best-background.html">
      <span class="small">Best Practices for</span><br/>
              Background Jobs
      </a>
    </div>
    <ul>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/run-background-service/index.html"
             description=
             "How to improve UI performance and responsiveness by sending work to a
             Service running in the background"
            >Running in a Background Service</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/run-background-service/create-service.html">
            Creating a Background Service
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/run-background-service/send-request.html">
            Sending Work Requests to the Background Service
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/run-background-service/report-status.html">
            Reporting Work Status
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/load-data-background/index.html"
             description="How to use CursorLoader to query data without
             affecting UI responsiveness."
            >Loading Data in the Background</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/load-data-background/setup-loader.html">
            Running a Query with a CursorLoader</a>
          </li>
          <li><a href="<?cs var:toroot ?>training/load-data-background/handle-results.html">
            Handling the Results</a>
          </li>
        </ul>
      </li>

       <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/scheduling/index.html"
             description="How to use repeating alarms and wake locks
             to run background jobs."
            >Managing Device Awake State</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/scheduling/wakelock.html">
            Keeping the Device Awake</a>
          </li>
          <li><a href="<?cs var:toroot ?>training/scheduling/alarms.html">
            Scheduling Repeating Alarms</a>
          </li>
        </ul>
      </li>
    </ul>
  </li> <!-- end of Background Jobs -->

  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/best-performance.html">
      <span class="small">Best Practices for</span><br/>
              Performance
      </a>
    </div>
    <ul>

      <li>
        <a href="<?cs var:toroot ?>training/articles/memory.html"
           description=
           "How to keep your app's memory footprint small in order to improve performance
           on a variety of mobile devices."
          >Managing Your App's Memory</a>
      </li>

      <li>
        <a href="<?cs var:toroot ?>training/articles/perf-tips.html"
           description=
           "How to optimize your app's performance in various ways to improve its
           responsiveness and battery efficiency."
          >Performance Tips</a>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/improving-layouts/index.html"
             description=
             "How to identify problems in your app's layout performance and improve the UI
             responsiveness."
            >Improving Layout Performance</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/improving-layouts/optimizing-layout.html">
            Optimizing Layout Hierarchies
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/improving-layouts/reusing-layouts.html">
            Re-using Layouts with &lt;include/&gt;
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/improving-layouts/loading-ondemand.html">
            Loading Views On Demand
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/improving-layouts/smooth-scrolling.html">
            Making ListView Scrolling Smooth
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/monitoring-device-state/index.html"
             zh-cn-lang="优化电池使用时间"
             ja-lang="電池消費量の最適化"
             es-lang="Cómo optimizar la duración de la batería"
             description=
             "How to minimize the amount of power your app requires by adapting to current
             power conditions and performing power-hungry tasks at proper intervals."
            >Optimizing Battery Life</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/monitoring-device-state/battery-monitoring.html"
            zh-cn-lang="监控电池电量和充电状态"
            ja-lang="電池残量と充電状態の監視"
            es-lang="Cómo controlar el nivel de batería y el estado de carga"
            >Monitoring the Battery Level and Charging State</a>
          </li>
          <li><a href="<?cs var:toroot ?>training/monitoring-device-state/docking-monitoring.html"
            zh-cn-lang="确定和监控基座对接状态和类型"
            ja-lang="ホルダーの装着状態とタイプの特定と監視"
            es-lang="Cómo determinar y controlar el tipo de conector y el estado de la conexión"
            >Determining and Monitoring the Docking State and Type</a>
          </li>
          <li><a href="<?cs var:toroot ?>training/monitoring-device-state/connectivity-monitoring.html"
            zh-cn-lang="确定和监控网络连接状态"
            ja-lang="接続状態の特定と監視"
            es-lang="Cómo determinar y controlar el estado de la conectividad"
            >Determining and Monitoring the Connectivity Status</a>
          </li>
          <li><a href="<?cs var:toroot ?>training/monitoring-device-state/manifest-receivers.html"
            zh-cn-lang="根据需要操作广播接收器"
            ja-lang="オンデマンドでのブロードキャスト レシーバ操作"
            es-lang="Cómo manipular los receptores de emisión bajo demanda"
            >Manipulating Broadcast Receivers On Demand</a>
          </li>
        </ul>
      </li>
      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/multiple-threads/index.html"
             description=
             "How to improve the performance and scalability of long-running operations by
              dispatching work to multiple threads.">
             Sending Operations to Multiple Threads</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/multiple-threads/define-runnable.html">
            Specifying the Code to Run on a Thread
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/multiple-threads/create-threadpool.html">
            Creating a Manager for Multiple Threads
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/multiple-threads/run-code.html">
            Running Code on a Thread Pool Thread
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/multiple-threads/communicate-ui.html">
            Communicating with the UI Thread
          </a>
          </li>
        </ul>
      </li>

      <li>
        <a href="<?cs var:toroot ?>training/articles/perf-anr.html"
           description=
           "How to keep your app responsive to user interaction so the UI does not lock-up and
           display an &quot;Application Not Responding&quot; dialog."
          >Keeping Your App Responsive</a>
      </li>

      <li>
        <a href="<?cs var:toroot ?>training/articles/perf-jni.html"
           description=
           "How to efficiently use the Java Native Interface with the Android NDK."
          >JNI Tips</a>
      </li>
      <li>
        <a href="<?cs var:toroot ?>training/articles/smp.html"
           description=
           "Tips for coding Android apps on symmetric multiprocessor systems."
          >SMP Primer for Android</a>
      </li>
    </ul>
  </li> <!-- end of Performance -->



  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/best-security.html">
      <span class="small">Best Practices for</span><br/>
              Security &amp; Privacy
      </a>
    </div>
    <ul>
      <li>
        <a href="<?cs var:toroot ?>training/articles/security-tips.html"
           description=
           "How to perform various tasks and keep your app's data and your user's data secure."
          >Security Tips</a>
      </li>

      <li>
        <a href="<?cs var:toroot ?>training/articles/security-ssl.html"
           description=
           "How to ensure that your app is secure when performing network transactions."
          >Security with HTTPS and SSL</a>
      </li>

      <li>
        <a href="<?cs var:toroot ?>training/articles/security-gms-provider.html"
           description=
           "How to use and update Google Play services security provider, to
           protect against SSL exploits."
          >Updating Your Security Provider to Protect Against SSL Exploits</a>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/enterprise/index.html"
             description=
             "How to implement device management policies for enterprise-oriented apps."
            >Developing for Enterprise</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/enterprise/device-management-policy.html">
            Enhancing Security with Device Management Policies
          </a>
          </li>
        </ul>
      </li>
    </ul>
  </li>
  <!-- End security and user info -->

  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/testing.html">
      <span class="small">Best Practices for</span><br/>
              Testing
      </a>
    </div>
    <ul>
      <li class="nav-section">
      <div class="nav-section-header"><a href="<?cs var:toroot ?>training/activity-testing/index.html"
         description="How to test Activities in your Android applications.">
            Testing Your Activity
          </a></div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/activity-testing/preparing-activity-testing.html">
            <span class="en">Setting Up Your Test Environment</span>
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/activity-testing/activity-basic-testing.html">
            <span class="en">Creating and Running a Test Case</span>
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/activity-testing/activity-ui-testing.html">
            <span class="en">Testing UI Components</span>
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/activity-testing/activity-unit-testing.html">
            <span class="en">Creating Unit Tests</span>
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/activity-testing/activity-functional-testing.html">
            <span class="en">Creating Functional Tests</span>
          </a>
          </li>
        </ul>
      </li>
    </ul>
  </li>
  <!-- End best Testing -->

  <li class="nav-section">
    <div class="nav-section-header">
      <a href="<?cs var:toroot ?>training/distribute.html">
      <span class="small">Using Google Play to</span><br/>
              Distribute &amp; Monetize
      </a>
    </div>
    <ul>
      <li class="nav-section">
      <div class="nav-section-header"><a href="<?cs var:toroot ?>training/in-app-billing/index.html"
         description="How to sell in-app products from your application using In-app Billing.">
            Selling In-app Products
          </a></div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/in-app-billing/preparing-iab-app.html">
            <span class="en">Preparing Your App</span>
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/in-app-billing/list-iab-products.html">
            <span class="en">Establishing Products for Sale</span>
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/in-app-billing/purchase-iab-products.html">
            <span class="en">Purchasing Products</span>
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/in-app-billing/test-iab-app.html">
            <span class="en">Testing Your App</span>
          </a>
          </li>
        </ul>
      </li>

      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/multiple-apks/index.html"
             description=
             "How to publish your app on Google Play with separate APKs that target
             different devices, while using a single app listing."
            >Maintaining Multiple APKs</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/multiple-apks/api.html">
            Creating Multiple APKs for Different API Levels
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/multiple-apks/screensize.html">
            Creating Multiple APKs for Different Screen Sizes
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/multiple-apks/texture.html">
            Creating Multiple APKs for Different GL Textures
          </a>
          </li>
          <li><a href="<?cs var:toroot ?>training/multiple-apks/multiple.html">
            Creating Multiple APKs with 2+ Dimensions
          </a>
          </li>
        </ul>
      </li>
      <li class="nav-section">
        <div class="nav-section-header">
          <a href="<?cs var:toroot ?>training/monetization/index.html"
             description=
             "How to implement monetization strategies for your app without compromising
             the user experience."
            >Monetizing Your App</a>
        </div>
        <ul>
          <li><a href="<?cs var:toroot ?>training/monetization/ads-and-ux.html">
            Advertising without Compromising User Experience
          </a>
          </li>
        </ul>
      </li>
    </ul>
  </li>
  <!-- End best Publishing -->

</ul><!-- nav -->
<script type="text/javascript">
<!--
    buildToggleLists();
    changeNavLang(getLangPref());
//-->
</script>
