/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 */

package com.android.systemui.statusbar.phone;

import com.android.systemui.R;

import android.app.AlertDialog;
import android.content.Context;
import android.view.WindowManager;

/**
 * Base class for dialogs that should appear over panels and keyguard.
 */
public class SystemUIDialog extends AlertDialog {

    private final Context mContext;

    public SystemUIDialog(Context context) {
        super(context, R.style.Theme_SystemUI_Dialog);
        mContext = context;

        makeSystemUIDialog(this);
    }

    public void setShowForAllUsers(boolean show) {
        if (show) {
            getWindow().getAttributes().privateFlags |=
                    WindowManager.LayoutParams.PRIVATE_FLAG_SHOW_FOR_ALL_USERS;
        } else {
            getWindow().getAttributes().privateFlags &=
                    ~WindowManager.LayoutParams.PRIVATE_FLAG_SHOW_FOR_ALL_USERS;
        }
    }

    public void setMessage(int resId) {
        setMessage(mContext.getString(resId));
    }

    public void setPositiveButton(int resId, OnClickListener onClick) {
        setButton(BUTTON_POSITIVE, mContext.getString(resId), onClick);
    }

    public void setNegativeButton(int resId, OnClickListener onClick) {
        setButton(BUTTON_NEGATIVE, mContext.getString(resId), onClick);
    }

    public static void makeSystemUIDialog(AlertDialog d) {
        d.getWindow().setType(WindowManager.LayoutParams.TYPE_STATUS_BAR_PANEL);
        d.getWindow().addFlags(WindowManager.LayoutParams.FLAG_ALT_FOCUSABLE_IM
                | WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED);
        WindowManager.LayoutParams attrs = d.getWindow().getAttributes();
        attrs.setTitle(SystemUIDialog.class.getClass().getSimpleName());
        d.getWindow().setAttributes(attrs);
    }
}
