/*
 * Copyright (C) 2004-2010 NXP Software
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/************************************************************************************/
/*                                                                                  */
/* Mixer library tables                                                             */
/*                                                                                  */
/* Coefficients and table values for the mixer library, generated by the Matlab     */
/* Script: Mixer_GenerateCoeffs.m                                                   */
/*                                                                                  */
/************************************************************************************/

#ifndef __LVM_MIXER_FILTER_COEFFS_H__
#define __LVM_MIXER_FILTER_COEFFS_H__

/************************************************************************************/
/*                                                                                  */
/* Alpha Time Constant table                                                        */
/*                                                                                  */
/************************************************************************************/

#define Alpha_TableSize                        50      /* The number of table entires */
#define ALPHA_0                        2147480769      /* Floating point Alpha = 0.999999 */
#define ALPHA_1                        2147479577      /* Floating point Alpha = 0.999998 */
#define ALPHA_2                        2147477892      /* Floating point Alpha = 0.999997 */
#define ALPHA_3                        2147475510      /* Floating point Alpha = 0.999996 */
#define ALPHA_4                        2147472141      /* Floating point Alpha = 0.999995 */
#define ALPHA_5                        2147467377      /* Floating point Alpha = 0.999992 */
#define ALPHA_6                        2147460642      /* Floating point Alpha = 0.999989 */
#define ALPHA_7                        2147451118      /* Floating point Alpha = 0.999985 */
#define ALPHA_8                        2147437651      /* Floating point Alpha = 0.999979 */
#define ALPHA_9                        2147418608      /* Floating point Alpha = 0.999970 */
#define ALPHA_10                       2147391683      /* Floating point Alpha = 0.999957 */
#define ALPHA_11                       2147353611      /* Floating point Alpha = 0.999939 */
#define ALPHA_12                       2147299779      /* Floating point Alpha = 0.999914 */
#define ALPHA_13                       2147223662      /* Floating point Alpha = 0.999879 */
#define ALPHA_14                       2147116037      /* Floating point Alpha = 0.999829 */
#define ALPHA_15                       2146963865      /* Floating point Alpha = 0.999758 */
#define ALPHA_16                       2146748712      /* Floating point Alpha = 0.999658 */
#define ALPHA_17                       2146444522      /* Floating point Alpha = 0.999516 */
#define ALPHA_18                       2146014472      /* Floating point Alpha = 0.999316 */
#define ALPHA_19                       2145406527      /* Floating point Alpha = 0.999033 */
#define ALPHA_20                       2144547188      /* Floating point Alpha = 0.998633 */
#define ALPHA_21                       2143332669      /* Floating point Alpha = 0.998067 */
#define ALPHA_22                       2141616514      /* Floating point Alpha = 0.997268 */
#define ALPHA_23                       2139192215      /* Floating point Alpha = 0.996139 */
#define ALPHA_24                       2135768939      /* Floating point Alpha = 0.994545 */
#define ALPHA_25                       2130937774      /* Floating point Alpha = 0.992295 */
#define ALPHA_26                       2124125153      /* Floating point Alpha = 0.989123 */
#define ALPHA_27                       2114529263      /* Floating point Alpha = 0.984654 */
#define ALPHA_28                       2101034612      /* Floating point Alpha = 0.978370 */
#define ALPHA_29                       2082100030      /* Floating point Alpha = 0.969553 */
#define ALPHA_30                       2055617398      /* Floating point Alpha = 0.957221 */
#define ALPHA_31                       2018744824      /* Floating point Alpha = 0.940051 */
#define ALPHA_32                       1967733015      /* Floating point Alpha = 0.916297 */
#define ALPHA_33                       1897794587      /* Floating point Alpha = 0.883729 */
#define ALPHA_34                       1803123234      /* Floating point Alpha = 0.839645 */
#define ALPHA_35                       1677262220      /* Floating point Alpha = 0.781036 */
#define ALPHA_36                       1514142675      /* Floating point Alpha = 0.705078 */
#define ALPHA_37                       1310197875      /* Floating point Alpha = 0.610108 */
#define ALPHA_38                       1067813480      /* Floating point Alpha = 0.497239 */
#define ALPHA_39                        799601371      /* Floating point Alpha = 0.372343 */
#define ALPHA_40                        531183049      /* Floating point Alpha = 0.247351 */
#define ALPHA_41                        297904007      /* Floating point Alpha = 0.138722 */
#define ALPHA_42                        131499768      /* Floating point Alpha = 0.061234 */
#define ALPHA_43                         41375282      /* Floating point Alpha = 0.019267 */
#define ALPHA_44                          8065899      /* Floating point Alpha = 0.003756 */
#define ALPHA_45                           799076      /* Floating point Alpha = 0.000372 */
#define ALPHA_46                            30398      /* Floating point Alpha = 0.000014 */
#define ALPHA_47                              299      /* Floating point Alpha = 0.000000 */
#define ALPHA_48                                0      /* Floating point Alpha = 0.000000 */
#define ALPHA_49                                0      /* Floating point Alpha = 0.000000 */
#define ALPHA_50                                0      /* Floating point Alpha = 0.000000 */

#define ALPHA_Float_0                        0.999999f
#define ALPHA_Float_1                        0.999998f
#define ALPHA_Float_2                        0.999997f
#define ALPHA_Float_3                        0.999996f
#define ALPHA_Float_4                        0.999995f
#define ALPHA_Float_5                        0.999992f
#define ALPHA_Float_6                        0.999989f
#define ALPHA_Float_7                        0.999985f
#define ALPHA_Float_8                        0.999979f
#define ALPHA_Float_9                        0.999970f
#define ALPHA_Float_10                       0.999957f
#define ALPHA_Float_11                       0.999939f
#define ALPHA_Float_12                       0.999914f
#define ALPHA_Float_13                       0.999879f
#define ALPHA_Float_14                       0.999829f
#define ALPHA_Float_15                       0.999758f
#define ALPHA_Float_16                       0.999658f
#define ALPHA_Float_17                       0.999516f
#define ALPHA_Float_18                       0.999316f
#define ALPHA_Float_19                       0.999033f
#define ALPHA_Float_20                       0.998633f
#define ALPHA_Float_21                       0.998067f
#define ALPHA_Float_22                       0.997268f
#define ALPHA_Float_23                       0.996139f
#define ALPHA_Float_24                       0.994545f
#define ALPHA_Float_25                       0.992295f
#define ALPHA_Float_26                       0.989123f
#define ALPHA_Float_27                       0.984654f
#define ALPHA_Float_28                       0.978370f
#define ALPHA_Float_29                       0.969553f
#define ALPHA_Float_30                       0.957221f
#define ALPHA_Float_31                       0.940051f
#define ALPHA_Float_32                       0.916297f
#define ALPHA_Float_33                       0.883729f
#define ALPHA_Float_34                       0.839645f
#define ALPHA_Float_35                       0.781036f
#define ALPHA_Float_36                       0.705078f
#define ALPHA_Float_37                       0.610108f
#define ALPHA_Float_38                       0.497239f
#define ALPHA_Float_39                       0.372343f
#define ALPHA_Float_40                       0.247351f
#define ALPHA_Float_41                       0.138722f
#define ALPHA_Float_42                       0.061234f
#define ALPHA_Float_43                       0.019267f
#define ALPHA_Float_44                       0.003756f
#define ALPHA_Float_45                       0.000372f
#define ALPHA_Float_46                       0.000014f
#define ALPHA_Float_47                       0.000000f
#define ALPHA_Float_48                       0.000000f
#define ALPHA_Float_49                       0.000000f
#define ALPHA_Float_50                       0.000000f

#endif
