 /**
 * 
 * File Name:  armVCM4P2_Lookup_Tables.c
 * OpenMAX DL: v1.0.2
 * Revision:   9641
 * Date:       Thursday, February 7, 2008
 * 
 * (c) Copyright 2007-2008 ARM Limited. All Rights Reserved.
 * 
 * 
 *
 * File:        armVCM4P2_Lookup_Tables.c
 * Description: Contains all the Lookup tables used in MPEG4 codec
 *
 */

#include "omxtypes.h"
#include "armOMX.h"

    /* * Table Entries contain Dc Scaler values
       * armVCM4P2_DCScaler[i]= 8           for i=1  to  4 and i=33 to 36
       *                      = 2*i         for i=5  to  8
       *                      = i+8         for i=9  to  25
       *                      = 2*i-16      for i=26 to  31
       *                      = (i-32+13)/2 for i=37 to  59
       *                      = i-6-32      for i=60 to  63
       *                      = 255         for i=0 and i=32
       */
       
const OMX_U8 armVCM4P2_DCScaler[64]={
	0xff, 0x8,  0x8,  0x8,  0x8,  0xa,  0xc,  0xe,  
    0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 
    0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
    0x20, 0x22, 0x24, 0x26, 0x28, 0x2a, 0x2c, 0x2e,
    0xff, 0x8,  0x8,  0x8,  0x8,  0x9,  0x9,  0xa,  
    0xa,  0xb,  0xb,  0xc,  0xc,  0xd,  0xd,  0xe,  
    0xe,  0xf,  0xf,  0x10, 0x10, 0x11, 0x11, 0x12, 
    0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19,

};

              
     /*  Table Entries Contain reciprocal of 1 to 63
      *  armVCM4P2_Reciprocal_QP_S16[i]=round(32767/i)
      *  armVCM4P2_Reciprocal_QP_S16[0]= 0
      */

const OMX_S16 armVCM4P2_Reciprocal_QP_S16[64]={
	0x0000,0x7fff,0x4000,0x2aaa,0x2000,0x1999,0x1555,0x1249,
    0x1000,0x0e39,0x0ccd,0x0ba3,0x0aab,0x09d9,0x0925,0x0888,
    0x0800,0x0787,0x071c,0x06bd,0x0666,0x0618,0x05d1,0x0591,
    0x0555,0x051f,0x04ec,0x04be,0x0492,0x046a,0x0444,0x0421,
    0x0400,0x03e1,0x03c4,0x03a8,0x038e,0x0376,0x035e,0x0348,
    0x0333,0x031f,0x030c,0x02fa,0x02e9,0x02d8,0x02c8,0x02b9,
    0x02ab,0x029d,0x028f,0x0282,0x0276,0x026a,0x025f,0x0254,
    0x0249,0x023f,0x0235,0x022b,0x0222,0x0219,0x0211,0x0208
	   
};
     
      /* Table Entries Contain reciprocal of 1 to 63
       * armVCM4P2_Reciprocal_QP_S32[i]=round(131071/i)
       * armVCM4P2_Reciprocal_QP_S32[0]= 0
       */

const OMX_S32 armVCM4P2_Reciprocal_QP_S32[64]={
	0x00000000,0x0001ffff,0x00010000,0x0000aaaa, 0x00008000, 0x00006666, 0x00005555, 0x00004924,
    0x00004000,0x000038e3,0x00003333,0x00002e8c, 0x00002aab, 0x00002762, 0x00002492, 0x00002222,
    0x00002000,0x00001e1e,0x00001c72,0x00001af2, 0x0000199a, 0x00001861, 0x00001746, 0x00001643,
    0x00001555,0x0000147b,0x000013b1,0x000012f6, 0x00001249, 0x000011a8, 0x00001111, 0x00001084,
    0x00001000,0x00000f84,0x00000f0f,0x00000ea1, 0x00000e39, 0x00000dd6, 0x00000d79, 0x00000d21,
    0x00000ccd,0x00000c7d,0x00000c31,0x00000be8, 0x00000ba3, 0x00000b61, 0x00000b21, 0x00000ae5,
    0x00000aab,0x00000a73,0x00000a3d,0x00000a0a, 0x000009d9, 0x000009a9, 0x0000097b, 0x0000094f,
    0x00000925,0x000008fb,0x000008d4,0x000008ae, 0x00000889, 0x00000865, 0x00000842, 0x00000820
	
};
