// Copyright 2018 The SwiftShader Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef LIBGLESV2_ENTRY_POINTS_H_
#define LIBGLESV2_ENTRY_POINTS_H_

#include <GLES2/gl2.h>
#include <GLES2/gl2ext.h>
#include <GLES3/gl3.h>

namespace gl
{
	void GL_APIENTRY ActiveTexture(GLenum texture);
	void GL_APIENTRY AttachShader(GLuint program, GLuint shader);
	void GL_APIENTRY BeginQueryEXT(GLenum target, GLuint name);
	void GL_APIENTRY BindAttribLocation(GLuint program, GLuint index, const GLchar* name);
	void GL_APIENTRY BindBuffer(GLenum target, GLuint buffer);
	void GL_APIENTRY BindFramebuffer(GLenum target, GLuint framebuffer);
	void GL_APIENTRY BindRenderbuffer(GLenum target, GLuint renderbuffer);
	void GL_APIENTRY BindTexture(GLenum target, GLuint texture);
	void GL_APIENTRY BlendColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
	void GL_APIENTRY BlendEquation(GLenum mode);
	void GL_APIENTRY BlendEquationSeparate(GLenum modeRGB, GLenum modeAlpha);
	void GL_APIENTRY BlendFunc(GLenum sfactor, GLenum dfactor);
	void GL_APIENTRY BlendFuncSeparate(GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha);
	void GL_APIENTRY BufferData(GLenum target, GLsizeiptr size, const GLvoid* data, GLenum usage);
	void GL_APIENTRY BufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid* data);
	GLenum GL_APIENTRY CheckFramebufferStatus(GLenum target);
	void GL_APIENTRY Clear(GLbitfield mask);
	void GL_APIENTRY ClearColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
	void GL_APIENTRY ClearDepthf(GLclampf depth);
	void GL_APIENTRY ClearStencil(GLint s);
	void GL_APIENTRY ColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
	void GL_APIENTRY CompileShader(GLuint shader);
	void GL_APIENTRY CompressedTexImage2D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height,
	                                      GLint border, GLsizei imageSize, const GLvoid* data);
	void GL_APIENTRY CompressedTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height,
	                                         GLenum format, GLsizei imageSize, const GLvoid* data);
	void GL_APIENTRY CopyTexImage2D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
	void GL_APIENTRY CopyTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
	GLuint GL_APIENTRY CreateProgram(void);
	GLuint GL_APIENTRY CreateShader(GLenum type);
	void GL_APIENTRY CullFace(GLenum mode);
	void GL_APIENTRY DeleteBuffers(GLsizei n, const GLuint* buffers);
	void GL_APIENTRY DeleteFencesNV(GLsizei n, const GLuint* fences);
	void GL_APIENTRY DeleteFramebuffers(GLsizei n, const GLuint* framebuffers);
	void GL_APIENTRY DeleteProgram(GLuint program);
	void GL_APIENTRY DeleteQueriesEXT(GLsizei n, const GLuint *ids);
	void GL_APIENTRY DeleteRenderbuffers(GLsizei n, const GLuint* renderbuffers);
	void GL_APIENTRY DeleteShader(GLuint shader);
	void GL_APIENTRY DeleteTextures(GLsizei n, const GLuint* textures);
	void GL_APIENTRY DepthFunc(GLenum func);
	void GL_APIENTRY DepthMask(GLboolean flag);
	void GL_APIENTRY DepthRangef(GLclampf zNear, GLclampf zFar);
	void GL_APIENTRY DetachShader(GLuint program, GLuint shader);
	void GL_APIENTRY Disable(GLenum cap);
	void GL_APIENTRY DisableVertexAttribArray(GLuint index);
	void GL_APIENTRY DrawArrays(GLenum mode, GLint first, GLsizei count);
	void GL_APIENTRY DrawElements(GLenum mode, GLsizei count, GLenum type, const GLvoid* indices);
	void GL_APIENTRY DrawArraysInstancedEXT(GLenum mode, GLint first, GLsizei count, GLsizei instanceCount);
	void GL_APIENTRY DrawElementsInstancedEXT(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instanceCount);
	void GL_APIENTRY VertexAttribDivisorEXT(GLuint index, GLuint divisor);
	void GL_APIENTRY DrawArraysInstancedANGLE(GLenum mode, GLint first, GLsizei count, GLsizei instanceCount);
	void GL_APIENTRY DrawElementsInstancedANGLE(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instanceCount);
	void GL_APIENTRY VertexAttribDivisorANGLE(GLuint index, GLuint divisor);
	void GL_APIENTRY Enable(GLenum cap);
	void GL_APIENTRY EnableVertexAttribArray(GLuint index);
	void GL_APIENTRY EndQueryEXT(GLenum target);
	void GL_APIENTRY FinishFenceNV(GLuint fence);
	void GL_APIENTRY Finish(void);
	void GL_APIENTRY Flush(void);
	void GL_APIENTRY FramebufferRenderbuffer(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
	void GL_APIENTRY FramebufferTexture2D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
	void GL_APIENTRY FrontFace(GLenum mode);
	void GL_APIENTRY GenBuffers(GLsizei n, GLuint* buffers);
	void GL_APIENTRY GenerateMipmap(GLenum target);
	void GL_APIENTRY GenFencesNV(GLsizei n, GLuint* fences);
	void GL_APIENTRY GenFramebuffers(GLsizei n, GLuint* framebuffers);
	void GL_APIENTRY GenQueriesEXT(GLsizei n, GLuint* ids);
	void GL_APIENTRY GenRenderbuffers(GLsizei n, GLuint* renderbuffers);
	void GL_APIENTRY GenTextures(GLsizei n, GLuint* textures);
	void GL_APIENTRY GetActiveAttrib(GLuint program, GLuint index, GLsizei bufsize, GLsizei *length, GLint *size, GLenum *type, GLchar *name);
	void GL_APIENTRY GetActiveUniform(GLuint program, GLuint index, GLsizei bufsize, GLsizei* length, GLint* size, GLenum* type, GLchar* name);
	void GL_APIENTRY GetAttachedShaders(GLuint program, GLsizei maxcount, GLsizei* count, GLuint* shaders);
	int GL_APIENTRY GetAttribLocation(GLuint program, const GLchar* name);
	void GL_APIENTRY GetBooleanv(GLenum pname, GLboolean* params);
	void GL_APIENTRY GetBufferParameteriv(GLenum target, GLenum pname, GLint* params);
	GLenum GL_APIENTRY GetError(void);
	void GL_APIENTRY GetFenceivNV(GLuint fence, GLenum pname, GLint *params);
	void GL_APIENTRY GetFloatv(GLenum pname, GLfloat* params);
	void GL_APIENTRY GetFramebufferAttachmentParameteriv(GLenum target, GLenum attachment, GLenum pname, GLint* params);
	GLenum GL_APIENTRY GetGraphicsResetStatusEXT(void);
	void GL_APIENTRY GetIntegerv(GLenum pname, GLint* params);
	void GL_APIENTRY GetProgramiv(GLuint program, GLenum pname, GLint* params);
	void GL_APIENTRY GetProgramInfoLog(GLuint program, GLsizei bufsize, GLsizei* length, GLchar* infolog);
	void GL_APIENTRY GetQueryivEXT(GLenum target, GLenum pname, GLint *params);
	void GL_APIENTRY GetQueryObjectuivEXT(GLuint name, GLenum pname, GLuint *params);
	void GL_APIENTRY GetRenderbufferParameteriv(GLenum target, GLenum pname, GLint* params);
	void GL_APIENTRY GetShaderiv(GLuint shader, GLenum pname, GLint* params);
	void GL_APIENTRY GetShaderInfoLog(GLuint shader, GLsizei bufsize, GLsizei* length, GLchar* infolog);
	void GL_APIENTRY GetShaderPrecisionFormat(GLenum shadertype, GLenum precisiontype, GLint* range, GLint* precision);
	void GL_APIENTRY GetShaderSource(GLuint shader, GLsizei bufsize, GLsizei* length, GLchar* source);
	const GLubyte* GL_APIENTRY GetString(GLenum name);
	void GL_APIENTRY GetTexParameterfv(GLenum target, GLenum pname, GLfloat* params);
	void GL_APIENTRY GetTexParameteriv(GLenum target, GLenum pname, GLint* params);
	void GL_APIENTRY GetnUniformfvEXT(GLuint program, GLint location, GLsizei bufSize, GLfloat* params);
	void GL_APIENTRY GetUniformfv(GLuint program, GLint location, GLfloat* params);
	void GL_APIENTRY GetnUniformivEXT(GLuint program, GLint location, GLsizei bufSize, GLint* params);
	void GL_APIENTRY GetUniformiv(GLuint program, GLint location, GLint* params);
	int GL_APIENTRY GetUniformLocation(GLuint program, const GLchar* name);
	void GL_APIENTRY GetVertexAttribfv(GLuint index, GLenum pname, GLfloat* params);
	void GL_APIENTRY GetVertexAttribiv(GLuint index, GLenum pname, GLint* params);
	void GL_APIENTRY GetVertexAttribPointerv(GLuint index, GLenum pname, GLvoid** pointer);
	void GL_APIENTRY Hint(GLenum target, GLenum mode);
	GLboolean GL_APIENTRY IsBuffer(GLuint buffer);
	GLboolean GL_APIENTRY IsEnabled(GLenum cap);
	GLboolean GL_APIENTRY IsFenceNV(GLuint fence);
	GLboolean GL_APIENTRY IsFramebuffer(GLuint framebuffer);
	GLboolean GL_APIENTRY IsProgram(GLuint program);
	GLboolean GL_APIENTRY IsQueryEXT(GLuint name);
	GLboolean GL_APIENTRY IsRenderbuffer(GLuint renderbuffer);
	GLboolean GL_APIENTRY IsShader(GLuint shader);
	GLboolean GL_APIENTRY IsTexture(GLuint texture);
	void GL_APIENTRY LineWidth(GLfloat width);
	void GL_APIENTRY LinkProgram(GLuint program);
	void GL_APIENTRY PixelStorei(GLenum pname, GLint param);
	void GL_APIENTRY PolygonOffset(GLfloat factor, GLfloat units);
	void GL_APIENTRY ReadnPixelsEXT(GLint x, GLint y, GLsizei width, GLsizei height,
	                                GLenum format, GLenum type, GLsizei bufSize, GLvoid *data);
	void GL_APIENTRY ReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid* pixels);
	void GL_APIENTRY ReleaseShaderCompiler(void);
	void GL_APIENTRY RenderbufferStorageMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
	void GL_APIENTRY RenderbufferStorageMultisampleANGLE(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
	void GL_APIENTRY RenderbufferStorage(GLenum target, GLenum internalformat, GLsizei width, GLsizei height);
	void GL_APIENTRY SampleCoverage(GLclampf value, GLboolean invert);
	void GL_APIENTRY SetFenceNV(GLuint fence, GLenum condition);
	void GL_APIENTRY Scissor(GLint x, GLint y, GLsizei width, GLsizei height);
	void GL_APIENTRY ShaderBinary(GLsizei n, const GLuint* shaders, GLenum binaryformat, const GLvoid* binary, GLsizei length);
	void GL_APIENTRY ShaderSource(GLuint shader, GLsizei count, const GLchar *const *string, const GLint *length);
	void GL_APIENTRY StencilFunc(GLenum func, GLint ref, GLuint mask);
	void GL_APIENTRY StencilFuncSeparate(GLenum face, GLenum func, GLint ref, GLuint mask);
	void GL_APIENTRY StencilMask(GLuint mask);
	void GL_APIENTRY StencilMaskSeparate(GLenum face, GLuint mask);
	void GL_APIENTRY StencilOp(GLenum fail, GLenum zfail, GLenum zpass);
	void GL_APIENTRY StencilOpSeparate(GLenum face, GLenum fail, GLenum zfail, GLenum zpass);
	GLboolean GL_APIENTRY TestFenceNV(GLuint fence);
	void GL_APIENTRY TexImage2D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height,
	                            GLint border, GLenum format, GLenum type, const GLvoid* pixels);
	void GL_APIENTRY TexParameterf(GLenum target, GLenum pname, GLfloat param);
	void GL_APIENTRY TexParameterfv(GLenum target, GLenum pname, const GLfloat* params);
	void GL_APIENTRY TexParameteri(GLenum target, GLenum pname, GLint param);
	void GL_APIENTRY TexParameteriv(GLenum target, GLenum pname, const GLint* params);
	void GL_APIENTRY TexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height,
	                               GLenum format, GLenum type, const GLvoid* pixels);
	void GL_APIENTRY Uniform1f(GLint location, GLfloat x);
	void GL_APIENTRY Uniform1fv(GLint location, GLsizei count, const GLfloat* v);
	void GL_APIENTRY Uniform1i(GLint location, GLint x);
	void GL_APIENTRY Uniform1iv(GLint location, GLsizei count, const GLint* v);
	void GL_APIENTRY Uniform2f(GLint location, GLfloat x, GLfloat y);
	void GL_APIENTRY Uniform2fv(GLint location, GLsizei count, const GLfloat* v);
	void GL_APIENTRY Uniform2i(GLint location, GLint x, GLint y);
	void GL_APIENTRY Uniform2iv(GLint location, GLsizei count, const GLint* v);
	void GL_APIENTRY Uniform3f(GLint location, GLfloat x, GLfloat y, GLfloat z);
	void GL_APIENTRY Uniform3fv(GLint location, GLsizei count, const GLfloat* v);
	void GL_APIENTRY Uniform3i(GLint location, GLint x, GLint y, GLint z);
	void GL_APIENTRY Uniform3iv(GLint location, GLsizei count, const GLint* v);
	void GL_APIENTRY Uniform4f(GLint location, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
	void GL_APIENTRY Uniform4fv(GLint location, GLsizei count, const GLfloat* v);
	void GL_APIENTRY Uniform4i(GLint location, GLint x, GLint y, GLint z, GLint w);
	void GL_APIENTRY Uniform4iv(GLint location, GLsizei count, const GLint* v);
	void GL_APIENTRY UniformMatrix2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat* value);
	void GL_APIENTRY UniformMatrix3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat* value);
	void GL_APIENTRY UniformMatrix4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat* value);
	void GL_APIENTRY UseProgram(GLuint program);
	void GL_APIENTRY ValidateProgram(GLuint program);
	void GL_APIENTRY VertexAttrib1f(GLuint index, GLfloat x);
	void GL_APIENTRY VertexAttrib1fv(GLuint index, const GLfloat* values);
	void GL_APIENTRY VertexAttrib2f(GLuint index, GLfloat x, GLfloat y);
	void GL_APIENTRY VertexAttrib2fv(GLuint index, const GLfloat* values);
	void GL_APIENTRY VertexAttrib3f(GLuint index, GLfloat x, GLfloat y, GLfloat z);
	void GL_APIENTRY VertexAttrib3fv(GLuint index, const GLfloat* values);
	void GL_APIENTRY VertexAttrib4f(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
	void GL_APIENTRY VertexAttrib4fv(GLuint index, const GLfloat* values);
	void GL_APIENTRY VertexAttribPointer(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid* ptr);
	void GL_APIENTRY Viewport(GLint x, GLint y, GLsizei width, GLsizei height);
	void GL_APIENTRY BlitFramebufferNV(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);
	void GL_APIENTRY BlitFramebufferANGLE(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1,
	                                      GLbitfield mask, GLenum filter);
	void GL_APIENTRY TexImage3DOES(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth,
	                               GLint border, GLenum format, GLenum type, const GLvoid* pixels);
	void GL_APIENTRY TexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels);
	void GL_APIENTRY CopyTexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
	void GL_APIENTRY CompressedTexImage3DOES(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *data);
	void GL_APIENTRY CompressedTexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *data);
	void GL_APIENTRY FramebufferTexture3DOES(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset);
	void GL_APIENTRY EGLImageTargetTexture2DOES(GLenum target, GLeglImageOES image);
	void GL_APIENTRY EGLImageTargetRenderbufferStorageOES(GLenum target, GLeglImageOES image);
	GLboolean GL_APIENTRY IsRenderbufferOES(GLuint renderbuffer);
	void GL_APIENTRY BindRenderbufferOES(GLenum target, GLuint renderbuffer);
	void GL_APIENTRY DeleteRenderbuffersOES(GLsizei n, const GLuint* renderbuffers);
	void GL_APIENTRY GenRenderbuffersOES(GLsizei n, GLuint* renderbuffers);
	void GL_APIENTRY RenderbufferStorageOES(GLenum target, GLenum internalformat, GLsizei width, GLsizei height);
	void GL_APIENTRY GetRenderbufferParameterivOES(GLenum target, GLenum pname, GLint* params);
	GLboolean GL_APIENTRY IsFramebufferOES(GLuint framebuffer);
	void GL_APIENTRY BindFramebufferOES(GLenum target, GLuint framebuffer);
	void GL_APIENTRY DeleteFramebuffersOES(GLsizei n, const GLuint* framebuffers);
	void GL_APIENTRY GenFramebuffersOES(GLsizei n, GLuint* framebuffers);
	GLenum GL_APIENTRY CheckFramebufferStatusOES(GLenum target);
	void GL_APIENTRY FramebufferRenderbufferOES(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
	void GL_APIENTRY FramebufferTexture2DOES(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
	void GL_APIENTRY GetFramebufferAttachmentParameterivOES(GLenum target, GLenum attachment, GLenum pname, GLint* params);
	void GL_APIENTRY GenerateMipmapOES(GLenum target);
	void GL_APIENTRY DrawBuffersEXT(GLsizei n, const GLenum *bufs);
	void GL_APIENTRY ReadBuffer(GLenum src);
	void GL_APIENTRY DrawRangeElements(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices);
	void GL_APIENTRY TexImage3D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *data);
	void GL_APIENTRY TexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *data);
	void GL_APIENTRY CopyTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
	void GL_APIENTRY CompressedTexImage3D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *data);
	void GL_APIENTRY CompressedTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *data);
	void GL_APIENTRY GenQueries(GLsizei n, GLuint *ids);
	void GL_APIENTRY DeleteQueries(GLsizei n, const GLuint *ids);
	GLboolean GL_APIENTRY IsQuery(GLuint id);
	void GL_APIENTRY BeginQuery(GLenum target, GLuint id);
	void GL_APIENTRY EndQuery(GLenum target);
	void GL_APIENTRY GetQueryiv(GLenum target, GLenum pname, GLint *params);
	void GL_APIENTRY GetQueryObjectuiv(GLuint id, GLenum pname, GLuint *params);
	GLboolean GL_APIENTRY UnmapBuffer(GLenum target);
	void GL_APIENTRY GetBufferPointerv(GLenum target, GLenum pname, void **params);
	void GL_APIENTRY DrawBuffers(GLsizei n, const GLenum *bufs);
	void GL_APIENTRY UniformMatrix2x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
	void GL_APIENTRY UniformMatrix3x2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
	void GL_APIENTRY UniformMatrix2x4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
	void GL_APIENTRY UniformMatrix4x2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
	void GL_APIENTRY UniformMatrix3x4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
	void GL_APIENTRY UniformMatrix4x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
	void GL_APIENTRY BlitFramebuffer(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);
	void GL_APIENTRY FramebufferTextureLayer(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer);
	void *GL_APIENTRY MapBufferRange(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access);
	void GL_APIENTRY FlushMappedBufferRange(GLenum target, GLintptr offset, GLsizeiptr length);
	void GL_APIENTRY BindVertexArray(GLuint array);
	void GL_APIENTRY BindVertexArrayOES(GLuint array);
	void GL_APIENTRY DeleteVertexArrays(GLsizei n, const GLuint *arrays);
	void GL_APIENTRY DeleteVertexArraysOES(GLsizei n, const GLuint *arrays);
	void GL_APIENTRY GenVertexArrays(GLsizei n, GLuint *arrays);
	void GL_APIENTRY GenVertexArraysOES(GLsizei n, GLuint *arrays);
	GLboolean GL_APIENTRY IsVertexArray(GLuint array);
	GLboolean GL_APIENTRY IsVertexArrayOES(GLuint array);
	void GL_APIENTRY GetIntegeri_v(GLenum target, GLuint index, GLint *data);
	void GL_APIENTRY BeginTransformFeedback(GLenum primitiveMode);
	void GL_APIENTRY EndTransformFeedback(void);
	void GL_APIENTRY BindBufferRange(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size);
	void GL_APIENTRY BindBufferBase(GLenum target, GLuint index, GLuint buffer);
	void GL_APIENTRY TransformFeedbackVaryings(GLuint program, GLsizei count, const GLchar *const*varyings, GLenum bufferMode);
	void GL_APIENTRY GetTransformFeedbackVarying(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name);
	void GL_APIENTRY VertexAttribIPointer(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer);
	void GL_APIENTRY GetVertexAttribIiv(GLuint index, GLenum pname, GLint *params);
	void GL_APIENTRY GetVertexAttribIuiv(GLuint index, GLenum pname, GLuint *params);
	void GL_APIENTRY VertexAttribI4i(GLuint index, GLint x, GLint y, GLint z, GLint w);
	void GL_APIENTRY VertexAttribI4ui(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w);
	void GL_APIENTRY VertexAttribI4iv(GLuint index, const GLint *v);
	void GL_APIENTRY VertexAttribI4uiv(GLuint index, const GLuint *v);
	void GL_APIENTRY GetUniformuiv(GLuint program, GLint location, GLuint *params);
	GLint GL_APIENTRY GetFragDataLocation(GLuint program, const GLchar *name);
	void GL_APIENTRY Uniform1ui(GLint location, GLuint v0);
	void GL_APIENTRY Uniform2ui(GLint location, GLuint v0, GLuint v1);
	void GL_APIENTRY Uniform3ui(GLint location, GLuint v0, GLuint v1, GLuint v2);
	void GL_APIENTRY Uniform4ui(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3);
	void GL_APIENTRY Uniform1uiv(GLint location, GLsizei count, const GLuint *value);
	void GL_APIENTRY Uniform2uiv(GLint location, GLsizei count, const GLuint *value);
	void GL_APIENTRY Uniform3uiv(GLint location, GLsizei count, const GLuint *value);
	void GL_APIENTRY Uniform4uiv(GLint location, GLsizei count, const GLuint *value);
	void GL_APIENTRY ClearBufferiv(GLenum buffer, GLint drawbuffer, const GLint *value);
	void GL_APIENTRY ClearBufferuiv(GLenum buffer, GLint drawbuffer, const GLuint *value);
	void GL_APIENTRY ClearBufferfv(GLenum buffer, GLint drawbuffer, const GLfloat *value);
	void GL_APIENTRY ClearBufferfi(GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil);
	const GLubyte *GL_APIENTRY GetStringi(GLenum name, GLuint index);
	void GL_APIENTRY CopyBufferSubData(GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size);
	void GL_APIENTRY GetUniformIndices(GLuint program, GLsizei uniformCount, const GLchar *const*uniformNames, GLuint *uniformIndices);
	void GL_APIENTRY GetActiveUniformsiv(GLuint program, GLsizei uniformCount, const GLuint *uniformIndices, GLenum pname, GLint *params);
	GLuint GL_APIENTRY GetUniformBlockIndex(GLuint program, const GLchar *uniformBlockName);
	void GL_APIENTRY GetActiveUniformBlockiv(GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint *params);
	void GL_APIENTRY GetActiveUniformBlockName(GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformBlockName);
	void GL_APIENTRY UniformBlockBinding(GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding);
	void GL_APIENTRY DrawArraysInstanced(GLenum mode, GLint first, GLsizei count, GLsizei instanceCount);
	void GL_APIENTRY DrawElementsInstanced(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instanceCount);
	GLsync GL_APIENTRY FenceSync(GLenum condition, GLbitfield flags);
	GLboolean GL_APIENTRY IsSync(GLsync sync);
	void GL_APIENTRY DeleteSync(GLsync sync);
	GLenum GL_APIENTRY ClientWaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout);
	void GL_APIENTRY WaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout);
	void GL_APIENTRY GetInteger64v(GLenum pname, GLint64 *data);
	void GL_APIENTRY GetSynciv(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values);
	void GL_APIENTRY GetInteger64i_v(GLenum target, GLuint index, GLint64 *data);
	void GL_APIENTRY GetBufferParameteri64v(GLenum target, GLenum pname, GLint64 *params);
	void GL_APIENTRY GenSamplers(GLsizei count, GLuint *samplers);
	void GL_APIENTRY DeleteSamplers(GLsizei count, const GLuint *samplers);
	GLboolean GL_APIENTRY IsSampler(GLuint sampler);
	void GL_APIENTRY BindSampler(GLuint unit, GLuint sampler);
	void GL_APIENTRY SamplerParameteri(GLuint sampler, GLenum pname, GLint param);
	void GL_APIENTRY SamplerParameteriv(GLuint sampler, GLenum pname, const GLint *param);
	void GL_APIENTRY SamplerParameterf(GLuint sampler, GLenum pname, GLfloat param);
	void GL_APIENTRY SamplerParameterfv(GLuint sampler, GLenum pname, const GLfloat *param);
	void GL_APIENTRY GetSamplerParameteriv(GLuint sampler, GLenum pname, GLint *params);
	void GL_APIENTRY GetSamplerParameterfv(GLuint sampler, GLenum pname, GLfloat *params);
	void GL_APIENTRY VertexAttribDivisor(GLuint index, GLuint divisor);
	void GL_APIENTRY BindTransformFeedback(GLenum target, GLuint id);
	void GL_APIENTRY DeleteTransformFeedbacks(GLsizei n, const GLuint *ids);
	void GL_APIENTRY GenTransformFeedbacks(GLsizei n, GLuint *ids);
	GLboolean GL_APIENTRY IsTransformFeedback(GLuint id);
	void GL_APIENTRY PauseTransformFeedback(void);
	void GL_APIENTRY ResumeTransformFeedback(void);
	void GL_APIENTRY GetProgramBinary(GLuint program, GLsizei bufSize, GLsizei *length, GLenum *binaryFormat, void *binary);
	void GL_APIENTRY ProgramBinary(GLuint program, GLenum binaryFormat, const void *binary, GLsizei length);
	void GL_APIENTRY ProgramParameteri(GLuint program, GLenum pname, GLint value);
	void GL_APIENTRY InvalidateFramebuffer(GLenum target, GLsizei numAttachments, const GLenum *attachments);
	void GL_APIENTRY InvalidateSubFramebuffer(GLenum target, GLsizei numAttachments, const GLenum *attachments, GLint x, GLint y, GLsizei width, GLsizei height);
	void GL_APIENTRY TexStorage2D(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);
	void GL_APIENTRY TexStorage3D(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);
	void GL_APIENTRY GetInternalformativ(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint *params);
}

#endif   // LIBGLESV2_ENTRY_POINTS_H_
