/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Subtarget Enumeration Source Fragment                                      *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_SUBTARGETINFO_ENUM
#undef GET_SUBTARGETINFO_ENUM

namespace llvm {
namespace X86 {
enum {
  Feature3DNow = 0,
  Feature3DNowA = 1,
  Feature64Bit = 2,
  FeatureADX = 3,
  FeatureAES = 4,
  FeatureAVX = 5,
  FeatureAVX2 = 6,
  FeatureAVX512 = 7,
  FeatureBITALG = 8,
  FeatureBMI = 9,
  FeatureBMI2 = 10,
  FeatureBWI = 11,
  FeatureCDI = 12,
  FeatureCLDEMOTE = 13,
  FeatureCLFLUSHOPT = 14,
  FeatureCLWB = 15,
  FeatureCLZERO = 16,
  FeatureCMOV = 17,
  FeatureCMPXCHG16B = 18,
  FeatureDQI = 19,
  FeatureERI = 20,
  FeatureERMSB = 21,
  FeatureF16C = 22,
  FeatureFMA = 23,
  FeatureFMA4 = 24,
  FeatureFSGSBase = 25,
  FeatureFXSR = 26,
  FeatureFast11ByteNOP = 27,
  FeatureFast15ByteNOP = 28,
  FeatureFastLZCNT = 29,
  FeatureFastPartialYMMorZMMWrite = 30,
  FeatureFastSHLDRotate = 31,
  FeatureFastScalarFSQRT = 32,
  FeatureFastVariableShuffle = 33,
  FeatureFastVectorFSQRT = 34,
  FeatureGFNI = 35,
  FeatureHasFastGather = 36,
  FeatureIFMA = 37,
  FeatureINVPCID = 38,
  FeatureLAHFSAHF = 39,
  FeatureLEAForSP = 40,
  FeatureLEAUsesAG = 41,
  FeatureLWP = 42,
  FeatureLZCNT = 43,
  FeatureLZCNTFalseDeps = 44,
  FeatureMMX = 45,
  FeatureMOVBE = 46,
  FeatureMOVDIR64B = 47,
  FeatureMOVDIRI = 48,
  FeatureMPX = 49,
  FeatureMWAITX = 50,
  FeatureMacroFusion = 51,
  FeatureNOPL = 52,
  FeaturePCLMUL = 53,
  FeaturePCONFIG = 54,
  FeaturePFI = 55,
  FeaturePKU = 56,
  FeaturePOPCNT = 57,
  FeaturePOPCNTFalseDeps = 58,
  FeaturePREFETCHWT1 = 59,
  FeaturePRFCHW = 60,
  FeaturePTWRITE = 61,
  FeaturePadShortFunctions = 62,
  FeaturePrefer256Bit = 63,
  FeatureRDPID = 64,
  FeatureRDRAND = 65,
  FeatureRDSEED = 66,
  FeatureRTM = 67,
  FeatureRetpoline = 68,
  FeatureRetpolineExternalThunk = 69,
  FeatureSGX = 70,
  FeatureSHA = 71,
  FeatureSHSTK = 72,
  FeatureSSE1 = 73,
  FeatureSSE2 = 74,
  FeatureSSE3 = 75,
  FeatureSSE4A = 76,
  FeatureSSE41 = 77,
  FeatureSSE42 = 78,
  FeatureSSEUnalignedMem = 79,
  FeatureSSSE3 = 80,
  FeatureSlow3OpsLEA = 81,
  FeatureSlowDivide32 = 82,
  FeatureSlowDivide64 = 83,
  FeatureSlowIncDec = 84,
  FeatureSlowLEA = 85,
  FeatureSlowPMULLD = 86,
  FeatureSlowSHLD = 87,
  FeatureSlowTwoMemOps = 88,
  FeatureSlowUAMem16 = 89,
  FeatureSlowUAMem32 = 90,
  FeatureSoftFloat = 91,
  FeatureTBM = 92,
  FeatureVAES = 93,
  FeatureVBMI = 94,
  FeatureVBMI2 = 95,
  FeatureVLX = 96,
  FeatureVNNI = 97,
  FeatureVPCLMULQDQ = 98,
  FeatureVPOPCNTDQ = 99,
  FeatureWAITPKG = 100,
  FeatureWBNOINVD = 101,
  FeatureX87 = 102,
  FeatureXOP = 103,
  FeatureXSAVE = 104,
  FeatureXSAVEC = 105,
  FeatureXSAVEOPT = 106,
  FeatureXSAVES = 107,
  Mode16Bit = 108,
  Mode32Bit = 109,
  Mode64Bit = 110,
  ProcIntelAtom = 111,
  ProcIntelBDW = 112,
  ProcIntelCNL = 113,
  ProcIntelGLM = 114,
  ProcIntelGLP = 115,
  ProcIntelHSW = 116,
  ProcIntelICL = 117,
  ProcIntelICX = 118,
  ProcIntelKNL = 119,
  ProcIntelSKL = 120,
  ProcIntelSKX = 121,
  ProcIntelSLM = 122,
  ProcIntelTRM = 123,
};
} // end namespace X86
} // end namespace llvm

#endif // GET_SUBTARGETINFO_ENUM


#ifdef GET_SUBTARGETINFO_MC_DESC
#undef GET_SUBTARGETINFO_MC_DESC

namespace llvm {
// Sorted (by key) array of values for CPU features.
extern const llvm::SubtargetFeatureKV X86FeatureKV[] = {
  { "16bit-mode", "16-bit mode (i8086)", { X86::Mode16Bit }, { } },
  { "32bit-mode", "32-bit mode (80386)", { X86::Mode32Bit }, { } },
  { "3dnow", "Enable 3DNow! instructions", { X86::Feature3DNow }, { X86::FeatureMMX } },
  { "3dnowa", "Enable 3DNow! Athlon instructions", { X86::Feature3DNowA }, { X86::Feature3DNow } },
  { "64bit", "Support 64-bit instructions", { X86::Feature64Bit }, { X86::FeatureCMOV } },
  { "64bit-mode", "64-bit mode (x86_64)", { X86::Mode64Bit }, { } },
  { "adx", "Support ADX instructions", { X86::FeatureADX }, { } },
  { "aes", "Enable AES instructions", { X86::FeatureAES }, { X86::FeatureSSE2 } },
  { "atom", "Intel Atom processors", { X86::ProcIntelAtom }, { } },
  { "avx", "Enable AVX instructions", { X86::FeatureAVX }, { X86::FeatureSSE42 } },
  { "avx2", "Enable AVX2 instructions", { X86::FeatureAVX2 }, { X86::FeatureAVX } },
  { "avx512bitalg", "Enable AVX-512 Bit Algorithms", { X86::FeatureBITALG }, { X86::FeatureBWI } },
  { "avx512bw", "Enable AVX-512 Byte and Word Instructions", { X86::FeatureBWI }, { X86::FeatureAVX512 } },
  { "avx512cd", "Enable AVX-512 Conflict Detection Instructions", { X86::FeatureCDI }, { X86::FeatureAVX512 } },
  { "avx512dq", "Enable AVX-512 Doubleword and Quadword Instructions", { X86::FeatureDQI }, { X86::FeatureAVX512 } },
  { "avx512er", "Enable AVX-512 Exponential and Reciprocal Instructions", { X86::FeatureERI }, { X86::FeatureAVX512 } },
  { "avx512f", "Enable AVX-512 instructions", { X86::FeatureAVX512 }, { X86::FeatureAVX2, X86::FeatureFMA, X86::FeatureF16C } },
  { "avx512ifma", "Enable AVX-512 Integer Fused Multiple-Add", { X86::FeatureIFMA }, { X86::FeatureAVX512 } },
  { "avx512pf", "Enable AVX-512 PreFetch Instructions", { X86::FeaturePFI }, { X86::FeatureAVX512 } },
  { "avx512vbmi", "Enable AVX-512 Vector Byte Manipulation Instructions", { X86::FeatureVBMI }, { X86::FeatureBWI } },
  { "avx512vbmi2", "Enable AVX-512 further Vector Byte Manipulation Instructions", { X86::FeatureVBMI2 }, { X86::FeatureBWI } },
  { "avx512vl", "Enable AVX-512 Vector Length eXtensions", { X86::FeatureVLX }, { X86::FeatureAVX512 } },
  { "avx512vnni", "Enable AVX-512 Vector Neural Network Instructions", { X86::FeatureVNNI }, { X86::FeatureAVX512 } },
  { "avx512vpopcntdq", "Enable AVX-512 Population Count Instructions", { X86::FeatureVPOPCNTDQ }, { X86::FeatureAVX512 } },
  { "bmi", "Support BMI instructions", { X86::FeatureBMI }, { } },
  { "bmi2", "Support BMI2 instructions", { X86::FeatureBMI2 }, { } },
  { "broadwell", "Intel Broadwell processors", { X86::ProcIntelBDW }, { } },
  { "cannonlake", "Intel Cannonlake processors", { X86::ProcIntelCNL }, { } },
  { "cldemote", "Enable Cache Demote", { X86::FeatureCLDEMOTE }, { } },
  { "clflushopt", "Flush A Cache Line Optimized", { X86::FeatureCLFLUSHOPT }, { } },
  { "clwb", "Cache Line Write Back", { X86::FeatureCLWB }, { } },
  { "clzero", "Enable Cache Line Zero", { X86::FeatureCLZERO }, { } },
  { "cmov", "Enable conditional move instructions", { X86::FeatureCMOV }, { } },
  { "cx16", "64-bit with cmpxchg16b", { X86::FeatureCMPXCHG16B }, { X86::Feature64Bit } },
  { "ermsb", "REP MOVS/STOS are fast", { X86::FeatureERMSB }, { } },
  { "f16c", "Support 16-bit floating point conversion instructions", { X86::FeatureF16C }, { X86::FeatureAVX } },
  { "false-deps-lzcnt-tzcnt", "LZCNT/TZCNT have a false dependency on dest register", { X86::FeatureLZCNTFalseDeps }, { } },
  { "false-deps-popcnt", "POPCNT has a false dependency on dest register", { X86::FeaturePOPCNTFalseDeps }, { } },
  { "fast-11bytenop", "Target can quickly decode up to 11 byte NOPs", { X86::FeatureFast11ByteNOP }, { } },
  { "fast-15bytenop", "Target can quickly decode up to 15 byte NOPs", { X86::FeatureFast15ByteNOP }, { } },
  { "fast-gather", "Indicates if gather is reasonably fast.", { X86::FeatureHasFastGather }, { } },
  { "fast-lzcnt", "LZCNT instructions are as fast as most simple integer ops", { X86::FeatureFastLZCNT }, { } },
  { "fast-partial-ymm-or-zmm-write", "Partial writes to YMM/ZMM registers are fast", { X86::FeatureFastPartialYMMorZMMWrite }, { } },
  { "fast-scalar-fsqrt", "Scalar SQRT is fast (disable Newton-Raphson)", { X86::FeatureFastScalarFSQRT }, { } },
  { "fast-shld-rotate", "SHLD can be used as a faster rotate", { X86::FeatureFastSHLDRotate }, { } },
  { "fast-variable-shuffle", "Shuffles with variable masks are fast", { X86::FeatureFastVariableShuffle }, { } },
  { "fast-vector-fsqrt", "Vector SQRT is fast (disable Newton-Raphson)", { X86::FeatureFastVectorFSQRT }, { } },
  { "fma", "Enable three-operand fused multiple-add", { X86::FeatureFMA }, { X86::FeatureAVX } },
  { "fma4", "Enable four-operand fused multiple-add", { X86::FeatureFMA4 }, { X86::FeatureAVX, X86::FeatureSSE4A } },
  { "fsgsbase", "Support FS/GS Base instructions", { X86::FeatureFSGSBase }, { } },
  { "fxsr", "Support fxsave/fxrestore instructions", { X86::FeatureFXSR }, { } },
  { "gfni", "Enable Galois Field Arithmetic Instructions", { X86::FeatureGFNI }, { X86::FeatureSSE2 } },
  { "glm", "Intel Goldmont processors", { X86::ProcIntelGLM }, { } },
  { "glp", "Intel Goldmont Plus processors", { X86::ProcIntelGLP }, { } },
  { "haswell", "Intel Haswell processors", { X86::ProcIntelHSW }, { } },
  { "icelake-client", "Intel Icelake processors", { X86::ProcIntelICL }, { } },
  { "icelake-server", "Intel Icelake Server processors", { X86::ProcIntelICX }, { } },
  { "idivl-to-divb", "Use 8-bit divide for positive values less than 256", { X86::FeatureSlowDivide32 }, { } },
  { "idivq-to-divl", "Use 32-bit divide for positive values less than 2^32", { X86::FeatureSlowDivide64 }, { } },
  { "invpcid", "Invalidate Process-Context Identifier", { X86::FeatureINVPCID }, { } },
  { "knl", "Intel Knights Landing processors", { X86::ProcIntelKNL }, { } },
  { "lea-sp", "Use LEA for adjusting the stack pointer", { X86::FeatureLEAForSP }, { } },
  { "lea-uses-ag", "LEA instruction needs inputs at AG stage", { X86::FeatureLEAUsesAG }, { } },
  { "lwp", "Enable LWP instructions", { X86::FeatureLWP }, { } },
  { "lzcnt", "Support LZCNT instruction", { X86::FeatureLZCNT }, { } },
  { "macrofusion", "Various instructions can be fused with conditional branches", { X86::FeatureMacroFusion }, { } },
  { "mmx", "Enable MMX instructions", { X86::FeatureMMX }, { } },
  { "movbe", "Support MOVBE instruction", { X86::FeatureMOVBE }, { } },
  { "movdir64b", "Support movdir64b instruction", { X86::FeatureMOVDIR64B }, { } },
  { "movdiri", "Support movdiri instruction", { X86::FeatureMOVDIRI }, { } },
  { "mpx", "Support MPX instructions", { X86::FeatureMPX }, { } },
  { "mwaitx", "Enable MONITORX/MWAITX timer functionality", { X86::FeatureMWAITX }, { } },
  { "nopl", "Enable NOPL instruction", { X86::FeatureNOPL }, { } },
  { "pad-short-functions", "Pad short functions", { X86::FeaturePadShortFunctions }, { } },
  { "pclmul", "Enable packed carry-less multiplication instructions", { X86::FeaturePCLMUL }, { X86::FeatureSSE2 } },
  { "pconfig", "platform configuration instruction", { X86::FeaturePCONFIG }, { } },
  { "pku", "Enable protection keys", { X86::FeaturePKU }, { } },
  { "popcnt", "Support POPCNT instruction", { X86::FeaturePOPCNT }, { } },
  { "prefer-256-bit", "Prefer 256-bit AVX instructions", { X86::FeaturePrefer256Bit }, { } },
  { "prefetchwt1", "Prefetch with Intent to Write and T1 Hint", { X86::FeaturePREFETCHWT1 }, { } },
  { "prfchw", "Support PRFCHW instructions", { X86::FeaturePRFCHW }, { } },
  { "ptwrite", "Support ptwrite instruction", { X86::FeaturePTWRITE }, { } },
  { "rdpid", "Support RDPID instructions", { X86::FeatureRDPID }, { } },
  { "rdrnd", "Support RDRAND instruction", { X86::FeatureRDRAND }, { } },
  { "rdseed", "Support RDSEED instruction", { X86::FeatureRDSEED }, { } },
  { "retpoline", "Remove speculation of indirect branches from the generated code, either by avoiding them entirely or lowering them with a speculation blocking construct.", { X86::FeatureRetpoline }, { } },
  { "retpoline-external-thunk", "Enable retpoline, but with an externally provided thunk.", { X86::FeatureRetpolineExternalThunk }, { X86::FeatureRetpoline } },
  { "rtm", "Support RTM instructions", { X86::FeatureRTM }, { } },
  { "sahf", "Support LAHF and SAHF instructions", { X86::FeatureLAHFSAHF }, { } },
  { "sgx", "Enable Software Guard Extensions", { X86::FeatureSGX }, { } },
  { "sha", "Enable SHA instructions", { X86::FeatureSHA }, { X86::FeatureSSE2 } },
  { "shstk", "Support CET Shadow-Stack instructions", { X86::FeatureSHSTK }, { } },
  { "skx", "Intel Skylake Server processors", { X86::ProcIntelSKX }, { } },
  { "skylake", "Intel Skylake processors", { X86::ProcIntelSKL }, { } },
  { "slm", "Intel Silvermont processors", { X86::ProcIntelSLM }, { } },
  { "slow-3ops-lea", "LEA instruction with 3 ops or certain registers is slow", { X86::FeatureSlow3OpsLEA }, { } },
  { "slow-incdec", "INC and DEC instructions are slower than ADD and SUB", { X86::FeatureSlowIncDec }, { } },
  { "slow-lea", "LEA instruction with certain arguments is slow", { X86::FeatureSlowLEA }, { } },
  { "slow-pmulld", "PMULLD instruction is slow", { X86::FeatureSlowPMULLD }, { } },
  { "slow-shld", "SHLD instruction is slow", { X86::FeatureSlowSHLD }, { } },
  { "slow-two-mem-ops", "Two memory operand instructions are slow", { X86::FeatureSlowTwoMemOps }, { } },
  { "slow-unaligned-mem-16", "Slow unaligned 16-byte memory access", { X86::FeatureSlowUAMem16 }, { } },
  { "slow-unaligned-mem-32", "Slow unaligned 32-byte memory access", { X86::FeatureSlowUAMem32 }, { } },
  { "soft-float", "Use software floating point features.", { X86::FeatureSoftFloat }, { } },
  { "sse", "Enable SSE instructions", { X86::FeatureSSE1 }, { X86::FeatureCMOV } },
  { "sse-unaligned-mem", "Allow unaligned memory operands with SSE instructions", { X86::FeatureSSEUnalignedMem }, { } },
  { "sse2", "Enable SSE2 instructions", { X86::FeatureSSE2 }, { X86::FeatureSSE1 } },
  { "sse3", "Enable SSE3 instructions", { X86::FeatureSSE3 }, { X86::FeatureSSE2 } },
  { "sse4.1", "Enable SSE 4.1 instructions", { X86::FeatureSSE41 }, { X86::FeatureSSSE3 } },
  { "sse4.2", "Enable SSE 4.2 instructions", { X86::FeatureSSE42 }, { X86::FeatureSSE41 } },
  { "sse4a", "Support SSE 4a instructions", { X86::FeatureSSE4A }, { X86::FeatureSSE3 } },
  { "ssse3", "Enable SSSE3 instructions", { X86::FeatureSSSE3 }, { X86::FeatureSSE3 } },
  { "tbm", "Enable TBM instructions", { X86::FeatureTBM }, { } },
  { "tremont", "Intel Tremont processors", { X86::ProcIntelTRM }, { } },
  { "vaes", "Promote selected AES instructions to AVX512/AVX registers", { X86::FeatureVAES }, { X86::FeatureAVX, X86::FeatureAES } },
  { "vpclmulqdq", "Enable vpclmulqdq instructions", { X86::FeatureVPCLMULQDQ }, { X86::FeatureAVX, X86::FeaturePCLMUL } },
  { "waitpkg", "Wait and pause enhancements", { X86::FeatureWAITPKG }, { } },
  { "wbnoinvd", "Write Back No Invalidate", { X86::FeatureWBNOINVD }, { } },
  { "x87", "Enable X87 float instructions", { X86::FeatureX87 }, { } },
  { "xop", "Enable XOP instructions", { X86::FeatureXOP }, { X86::FeatureFMA4 } },
  { "xsave", "Support xsave instructions", { X86::FeatureXSAVE }, { } },
  { "xsavec", "Support xsavec instructions", { X86::FeatureXSAVEC }, { } },
  { "xsaveopt", "Support xsaveopt instructions", { X86::FeatureXSAVEOPT }, { } },
  { "xsaves", "Support xsaves instructions", { X86::FeatureXSAVES }, { } },
};

// Sorted (by key) array of values for CPU subtype.
extern const llvm::SubtargetFeatureKV X86SubTypeKV[] = {
  { "amdfam10", "Select the amdfam10 processor", { X86::FeatureX87, X86::FeatureSSE4A, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeatureLZCNT, X86::FeaturePOPCNT, X86::FeatureSlowSHLD, X86::FeatureLAHFSAHF }, { } },
  { "athlon", "Select the athlon processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::Feature3DNowA, X86::FeatureNOPL, X86::FeatureSlowSHLD }, { } },
  { "athlon-4", "Select the athlon-4 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureSSE1, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureSlowSHLD }, { } },
  { "athlon-fx", "Select the athlon-fx processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureSSE2, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureSlowSHLD }, { } },
  { "athlon-mp", "Select the athlon-mp processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureSSE1, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureSlowSHLD }, { } },
  { "athlon-tbird", "Select the athlon-tbird processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::Feature3DNowA, X86::FeatureNOPL, X86::FeatureSlowSHLD }, { } },
  { "athlon-xp", "Select the athlon-xp processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureSSE1, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureSlowSHLD }, { } },
  { "athlon64", "Select the athlon64 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureSSE2, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureSlowSHLD }, { } },
  { "athlon64-sse3", "Select the athlon64-sse3 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureSSE3, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeatureSlowSHLD }, { } },
  { "atom", "Select the atom processor", { X86::ProcIntelAtom, X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX, X86::FeatureSSSE3, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeatureMOVBE, X86::FeatureLEAForSP, X86::FeatureSlowDivide32, X86::FeatureSlowDivide64, X86::FeatureSlowTwoMemOps, X86::FeatureLEAUsesAG, X86::FeaturePadShortFunctions, X86::FeatureLAHFSAHF }, { } },
  { "barcelona", "Select the barcelona processor", { X86::FeatureX87, X86::FeatureSSE4A, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeatureLZCNT, X86::FeaturePOPCNT, X86::FeatureSlowSHLD, X86::FeatureLAHFSAHF }, { } },
  { "bdver1", "Select the bdver1 processor", { X86::FeatureX87, X86::FeatureXOP, X86::FeatureFMA4, X86::FeatureCMPXCHG16B, X86::FeatureAES, X86::FeaturePRFCHW, X86::FeaturePCLMUL, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureSSE4A, X86::FeatureLZCNT, X86::FeaturePOPCNT, X86::FeatureXSAVE, X86::FeatureLWP, X86::FeatureSlowSHLD, X86::FeatureLAHFSAHF, X86::FeatureFast11ByteNOP, X86::FeatureMacroFusion }, { } },
  { "bdver2", "Select the bdver2 processor", { X86::FeatureX87, X86::FeatureXOP, X86::FeatureFMA4, X86::FeatureCMPXCHG16B, X86::FeatureAES, X86::FeaturePRFCHW, X86::FeaturePCLMUL, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureSSE4A, X86::FeatureF16C, X86::FeatureLZCNT, X86::FeaturePOPCNT, X86::FeatureXSAVE, X86::FeatureBMI, X86::FeatureTBM, X86::FeatureLWP, X86::FeatureFMA, X86::FeatureSlowSHLD, X86::FeatureLAHFSAHF, X86::FeatureFast11ByteNOP, X86::FeatureMacroFusion }, { } },
  { "bdver3", "Select the bdver3 processor", { X86::FeatureX87, X86::FeatureXOP, X86::FeatureFMA4, X86::FeatureCMPXCHG16B, X86::FeatureAES, X86::FeaturePRFCHW, X86::FeaturePCLMUL, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureSSE4A, X86::FeatureF16C, X86::FeatureLZCNT, X86::FeaturePOPCNT, X86::FeatureXSAVE, X86::FeatureBMI, X86::FeatureTBM, X86::FeatureLWP, X86::FeatureFMA, X86::FeatureXSAVEOPT, X86::FeatureSlowSHLD, X86::FeatureFSGSBase, X86::FeatureLAHFSAHF, X86::FeatureFast11ByteNOP, X86::FeatureMacroFusion }, { } },
  { "bdver4", "Select the bdver4 processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureAVX2, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureXOP, X86::FeatureFMA4, X86::FeatureCMPXCHG16B, X86::FeatureAES, X86::FeaturePRFCHW, X86::FeaturePCLMUL, X86::FeatureF16C, X86::FeatureLZCNT, X86::FeaturePOPCNT, X86::FeatureXSAVE, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureTBM, X86::FeatureLWP, X86::FeatureFMA, X86::FeatureXSAVEOPT, X86::FeatureSlowSHLD, X86::FeatureFSGSBase, X86::FeatureLAHFSAHF, X86::FeatureFast11ByteNOP, X86::FeatureMWAITX, X86::FeatureMacroFusion }, { } },
  { "bonnell", "Select the bonnell processor", { X86::ProcIntelAtom, X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX, X86::FeatureSSSE3, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeatureMOVBE, X86::FeatureLEAForSP, X86::FeatureSlowDivide32, X86::FeatureSlowDivide64, X86::FeatureSlowTwoMemOps, X86::FeatureLEAUsesAG, X86::FeaturePadShortFunctions, X86::FeatureLAHFSAHF }, { } },
  { "broadwell", "Select the broadwell processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureAES, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureAVX2, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureERMSB, X86::FeatureFMA, X86::FeatureINVPCID, X86::FeatureLZCNT, X86::FeatureMOVBE, X86::FeatureFastVariableShuffle, X86::FeatureADX, X86::FeatureRDSEED, X86::FeaturePRFCHW, X86::ProcIntelBDW, X86::FeaturePOPCNTFalseDeps, X86::FeatureLZCNTFalseDeps }, { } },
  { "btver1", "Select the btver1 processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureSSSE3, X86::FeatureSSE4A, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeaturePRFCHW, X86::FeatureLZCNT, X86::FeaturePOPCNT, X86::FeatureSlowSHLD, X86::FeatureLAHFSAHF, X86::FeatureFast15ByteNOP }, { } },
  { "btver2", "Select the btver2 processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureSSE4A, X86::FeatureCMPXCHG16B, X86::FeaturePRFCHW, X86::FeatureAES, X86::FeaturePCLMUL, X86::FeatureBMI, X86::FeatureF16C, X86::FeatureMOVBE, X86::FeatureLZCNT, X86::FeatureFastLZCNT, X86::FeaturePOPCNT, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureSlowSHLD, X86::FeatureLAHFSAHF, X86::FeatureFast15ByteNOP, X86::FeatureFastPartialYMMorZMMWrite }, { } },
  { "c3", "Select the c3 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::Feature3DNow }, { } },
  { "c3-2", "Select the c3-2 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX, X86::FeatureSSE1, X86::FeatureFXSR }, { } },
  { "cannonlake", "Select the cannonlake processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureAES, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureAVX2, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureERMSB, X86::FeatureFMA, X86::FeatureINVPCID, X86::FeatureLZCNT, X86::FeatureMOVBE, X86::FeatureFastVariableShuffle, X86::FeatureADX, X86::FeatureRDSEED, X86::FeaturePRFCHW, X86::FeatureMPX, X86::FeatureRTM, X86::FeatureXSAVEC, X86::FeatureXSAVES, X86::FeatureCLFLUSHOPT, X86::FeatureFastVectorFSQRT, X86::FeatureAVX512, X86::FeatureCDI, X86::FeatureDQI, X86::FeatureBWI, X86::FeatureVLX, X86::FeaturePKU, X86::FeatureVBMI, X86::FeatureIFMA, X86::FeatureSHA, X86::FeatureSGX, X86::ProcIntelCNL, X86::FeatureHasFastGather }, { } },
  { "core-avx-i", "Select the core-avx-i processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureAES, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureSlowUAMem32, X86::FeaturePOPCNTFalseDeps }, { } },
  { "core-avx2", "Select the core-avx2 processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureAES, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureAVX2, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureERMSB, X86::FeatureFMA, X86::FeatureINVPCID, X86::FeatureLZCNT, X86::FeatureMOVBE, X86::FeatureFastVariableShuffle, X86::ProcIntelHSW, X86::FeaturePOPCNTFalseDeps, X86::FeatureLZCNTFalseDeps }, { } },
  { "core2", "Select the core2 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX, X86::FeatureSSSE3, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeatureLAHFSAHF, X86::FeatureMacroFusion }, { } },
  { "corei7", "Select the corei7 processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureSSE42, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureLAHFSAHF, X86::FeatureMacroFusion }, { } },
  { "corei7-avx", "Select the corei7-avx processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureAES, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMacroFusion, X86::FeatureSlowUAMem32, X86::FeaturePOPCNTFalseDeps }, { } },
  { "generic", "Select the generic processor", { X86::FeatureX87, X86::FeatureSlowUAMem16 }, { } },
  { "geode", "Select the geode processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::Feature3DNowA }, { } },
  { "goldmont", "Select the goldmont processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureSSE42, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeatureMOVBE, X86::FeaturePOPCNT, X86::FeaturePCLMUL, X86::FeatureAES, X86::FeaturePRFCHW, X86::FeatureSlowTwoMemOps, X86::FeatureSlowLEA, X86::FeatureSlowIncDec, X86::FeatureLAHFSAHF, X86::FeatureMPX, X86::FeatureSHA, X86::FeatureRDRAND, X86::FeatureRDSEED, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureXSAVEC, X86::FeatureXSAVES, X86::FeatureCLFLUSHOPT, X86::FeatureFSGSBase, X86::ProcIntelGLM, X86::FeaturePOPCNTFalseDeps }, { } },
  { "goldmont-plus", "Select the goldmont-plus processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureSSE42, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeatureMOVBE, X86::FeaturePOPCNT, X86::FeaturePCLMUL, X86::FeatureAES, X86::FeaturePRFCHW, X86::FeatureSlowTwoMemOps, X86::FeatureSlowLEA, X86::FeatureSlowIncDec, X86::FeatureLAHFSAHF, X86::FeatureMPX, X86::FeatureSHA, X86::FeatureRDRAND, X86::FeatureRDSEED, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureXSAVEC, X86::FeatureXSAVES, X86::FeatureCLFLUSHOPT, X86::FeatureFSGSBase, X86::FeaturePTWRITE, X86::FeatureRDPID, X86::FeatureSGX, X86::ProcIntelGLP }, { } },
  { "haswell", "Select the haswell processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureAES, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureAVX2, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureERMSB, X86::FeatureFMA, X86::FeatureINVPCID, X86::FeatureLZCNT, X86::FeatureMOVBE, X86::FeatureFastVariableShuffle, X86::ProcIntelHSW, X86::FeaturePOPCNTFalseDeps, X86::FeatureLZCNTFalseDeps }, { } },
  { "i386", "Select the i386 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16 }, { } },
  { "i486", "Select the i486 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16 }, { } },
  { "i586", "Select the i586 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16 }, { } },
  { "i686", "Select the i686 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureCMOV }, { } },
  { "icelake-client", "Select the icelake-client processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureAES, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureAVX2, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureERMSB, X86::FeatureFMA, X86::FeatureINVPCID, X86::FeatureLZCNT, X86::FeatureMOVBE, X86::FeatureFastVariableShuffle, X86::FeatureADX, X86::FeatureRDSEED, X86::FeaturePRFCHW, X86::FeatureMPX, X86::FeatureRTM, X86::FeatureXSAVEC, X86::FeatureXSAVES, X86::FeatureCLFLUSHOPT, X86::FeatureFastVectorFSQRT, X86::FeatureAVX512, X86::FeatureCDI, X86::FeatureDQI, X86::FeatureBWI, X86::FeatureVLX, X86::FeaturePKU, X86::FeatureVBMI, X86::FeatureIFMA, X86::FeatureSHA, X86::FeatureSGX, X86::FeatureBITALG, X86::FeatureVAES, X86::FeatureVBMI2, X86::FeatureVNNI, X86::FeatureVPCLMULQDQ, X86::FeatureVPOPCNTDQ, X86::FeatureGFNI, X86::FeatureCLWB, X86::FeatureRDPID, X86::ProcIntelICL, X86::FeatureHasFastGather }, { } },
  { "icelake-server", "Select the icelake-server processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureAES, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureAVX2, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureERMSB, X86::FeatureFMA, X86::FeatureINVPCID, X86::FeatureLZCNT, X86::FeatureMOVBE, X86::FeatureFastVariableShuffle, X86::FeatureADX, X86::FeatureRDSEED, X86::FeaturePRFCHW, X86::FeatureMPX, X86::FeatureRTM, X86::FeatureXSAVEC, X86::FeatureXSAVES, X86::FeatureCLFLUSHOPT, X86::FeatureFastVectorFSQRT, X86::FeatureAVX512, X86::FeatureCDI, X86::FeatureDQI, X86::FeatureBWI, X86::FeatureVLX, X86::FeaturePKU, X86::FeatureVBMI, X86::FeatureIFMA, X86::FeatureSHA, X86::FeatureSGX, X86::FeatureBITALG, X86::FeatureVAES, X86::FeatureVBMI2, X86::FeatureVNNI, X86::FeatureVPCLMULQDQ, X86::FeatureVPOPCNTDQ, X86::FeatureGFNI, X86::FeatureCLWB, X86::FeatureRDPID, X86::ProcIntelICX, X86::FeaturePCONFIG, X86::FeatureWBNOINVD, X86::FeatureHasFastGather }, { } },
  { "ivybridge", "Select the ivybridge processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureAES, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureSlowUAMem32, X86::FeaturePOPCNTFalseDeps }, { } },
  { "k6", "Select the k6 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX }, { } },
  { "k6-2", "Select the k6-2 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::Feature3DNow }, { } },
  { "k6-3", "Select the k6-3 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::Feature3DNow }, { } },
  { "k8", "Select the k8 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureSSE2, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureSlowSHLD }, { } },
  { "k8-sse3", "Select the k8-sse3 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureSSE3, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeatureSlowSHLD }, { } },
  { "knl", "Select the knl processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureAES, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureAVX512, X86::FeatureERI, X86::FeatureCDI, X86::FeaturePFI, X86::FeaturePREFETCHWT1, X86::FeatureADX, X86::FeatureRDSEED, X86::FeatureMOVBE, X86::FeatureLZCNT, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureFMA, X86::FeaturePRFCHW, X86::ProcIntelKNL, X86::FeatureSlowTwoMemOps, X86::FeatureFastPartialYMMorZMMWrite, X86::FeatureHasFastGather }, { } },
  { "knm", "Select the knm processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureAES, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureAVX512, X86::FeatureERI, X86::FeatureCDI, X86::FeaturePFI, X86::FeaturePREFETCHWT1, X86::FeatureADX, X86::FeatureRDSEED, X86::FeatureMOVBE, X86::FeatureLZCNT, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureFMA, X86::FeaturePRFCHW, X86::ProcIntelKNL, X86::FeatureSlowTwoMemOps, X86::FeatureFastPartialYMMorZMMWrite, X86::FeatureHasFastGather, X86::FeatureVPOPCNTDQ }, { } },
  { "lakemont", "Select the lakemont processor", { }, { } },
  { "nehalem", "Select the nehalem processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureSSE42, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureLAHFSAHF, X86::FeatureMacroFusion }, { } },
  { "nocona", "Select the nocona processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX, X86::FeatureSSE3, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B }, { } },
  { "opteron", "Select the opteron processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureSSE2, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureSlowSHLD }, { } },
  { "opteron-sse3", "Select the opteron-sse3 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureSSE3, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeatureSlowSHLD }, { } },
  { "penryn", "Select the penryn processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX, X86::FeatureSSE41, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeatureLAHFSAHF, X86::FeatureMacroFusion }, { } },
  { "pentium", "Select the pentium processor", { X86::FeatureX87, X86::FeatureSlowUAMem16 }, { } },
  { "pentium-m", "Select the pentium-m processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX, X86::FeatureSSE2, X86::FeatureFXSR, X86::FeatureNOPL }, { } },
  { "pentium-mmx", "Select the pentium-mmx processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX }, { } },
  { "pentium2", "Select the pentium2 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX, X86::FeatureCMOV, X86::FeatureFXSR, X86::FeatureNOPL }, { } },
  { "pentium3", "Select the pentium3 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX, X86::FeatureSSE1, X86::FeatureFXSR, X86::FeatureNOPL }, { } },
  { "pentium3m", "Select the pentium3m processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX, X86::FeatureSSE1, X86::FeatureFXSR, X86::FeatureNOPL }, { } },
  { "pentium4", "Select the pentium4 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX, X86::FeatureSSE2, X86::FeatureFXSR, X86::FeatureNOPL }, { } },
  { "pentium4m", "Select the pentium4m processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX, X86::FeatureSSE2, X86::FeatureFXSR, X86::FeatureNOPL }, { } },
  { "pentiumpro", "Select the pentiumpro processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureCMOV, X86::FeatureNOPL }, { } },
  { "prescott", "Select the prescott processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX, X86::FeatureSSE3, X86::FeatureFXSR, X86::FeatureNOPL }, { } },
  { "sandybridge", "Select the sandybridge processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureAES, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMacroFusion, X86::FeatureSlowUAMem32, X86::FeaturePOPCNTFalseDeps }, { } },
  { "silvermont", "Select the silvermont processor", { X86::ProcIntelSLM, X86::FeatureX87, X86::FeatureMMX, X86::FeatureSSE42, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeatureMOVBE, X86::FeaturePOPCNT, X86::FeaturePCLMUL, X86::FeatureAES, X86::FeatureSlowDivide64, X86::FeatureSlowTwoMemOps, X86::FeaturePRFCHW, X86::FeatureSlowLEA, X86::FeatureSlowIncDec, X86::FeatureSlowPMULLD, X86::FeatureRDRAND, X86::FeatureLAHFSAHF, X86::FeaturePOPCNTFalseDeps }, { } },
  { "skx", "Select the skx processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureAES, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureAVX2, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureERMSB, X86::FeatureFMA, X86::FeatureINVPCID, X86::FeatureLZCNT, X86::FeatureMOVBE, X86::FeatureFastVariableShuffle, X86::FeatureADX, X86::FeatureRDSEED, X86::FeaturePRFCHW, X86::FeatureMPX, X86::FeatureRTM, X86::FeatureXSAVEC, X86::FeatureXSAVES, X86::FeatureCLFLUSHOPT, X86::FeatureFastVectorFSQRT, X86::FeatureAVX512, X86::FeatureCDI, X86::FeatureDQI, X86::FeatureBWI, X86::FeatureVLX, X86::FeaturePKU, X86::FeatureCLWB, X86::ProcIntelSKX, X86::FeatureHasFastGather, X86::FeaturePOPCNTFalseDeps }, { } },
  { "skylake", "Select the skylake processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureAES, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureAVX2, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureERMSB, X86::FeatureFMA, X86::FeatureINVPCID, X86::FeatureLZCNT, X86::FeatureMOVBE, X86::FeatureFastVariableShuffle, X86::FeatureADX, X86::FeatureRDSEED, X86::FeaturePRFCHW, X86::FeatureMPX, X86::FeatureRTM, X86::FeatureXSAVEC, X86::FeatureXSAVES, X86::FeatureCLFLUSHOPT, X86::FeatureFastVectorFSQRT, X86::ProcIntelSKL, X86::FeatureHasFastGather, X86::FeaturePOPCNTFalseDeps, X86::FeatureSGX }, { } },
  { "skylake-avx512", "Select the skylake-avx512 processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureAES, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureAVX2, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureERMSB, X86::FeatureFMA, X86::FeatureINVPCID, X86::FeatureLZCNT, X86::FeatureMOVBE, X86::FeatureFastVariableShuffle, X86::FeatureADX, X86::FeatureRDSEED, X86::FeaturePRFCHW, X86::FeatureMPX, X86::FeatureRTM, X86::FeatureXSAVEC, X86::FeatureXSAVES, X86::FeatureCLFLUSHOPT, X86::FeatureFastVectorFSQRT, X86::FeatureAVX512, X86::FeatureCDI, X86::FeatureDQI, X86::FeatureBWI, X86::FeatureVLX, X86::FeaturePKU, X86::FeatureCLWB, X86::ProcIntelSKX, X86::FeatureHasFastGather, X86::FeaturePOPCNTFalseDeps }, { } },
  { "slm", "Select the slm processor", { X86::ProcIntelSLM, X86::FeatureX87, X86::FeatureMMX, X86::FeatureSSE42, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeatureMOVBE, X86::FeaturePOPCNT, X86::FeaturePCLMUL, X86::FeatureAES, X86::FeatureSlowDivide64, X86::FeatureSlowTwoMemOps, X86::FeaturePRFCHW, X86::FeatureSlowLEA, X86::FeatureSlowIncDec, X86::FeatureSlowPMULLD, X86::FeatureRDRAND, X86::FeatureLAHFSAHF, X86::FeaturePOPCNTFalseDeps }, { } },
  { "tremont", "Select the tremont processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureSSE42, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeatureMOVBE, X86::FeaturePOPCNT, X86::FeaturePCLMUL, X86::FeatureAES, X86::FeaturePRFCHW, X86::FeatureSlowTwoMemOps, X86::FeatureSlowLEA, X86::FeatureSlowIncDec, X86::FeatureLAHFSAHF, X86::FeatureMPX, X86::FeatureSHA, X86::FeatureRDRAND, X86::FeatureRDSEED, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureXSAVEC, X86::FeatureXSAVES, X86::FeatureCLFLUSHOPT, X86::FeatureFSGSBase, X86::FeaturePTWRITE, X86::FeatureRDPID, X86::FeatureSGX, X86::ProcIntelTRM, X86::FeatureCLDEMOTE, X86::FeatureGFNI, X86::FeatureMOVDIRI, X86::FeatureMOVDIR64B, X86::FeatureWAITPKG }, { } },
  { "westmere", "Select the westmere processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureSSE42, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureAES, X86::FeaturePCLMUL, X86::FeatureLAHFSAHF, X86::FeatureMacroFusion }, { } },
  { "winchip-c6", "Select the winchip-c6 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX }, { } },
  { "winchip2", "Select the winchip2 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::Feature3DNow }, { } },
  { "x86-64", "Select the x86-64 processor", { X86::FeatureX87, X86::FeatureMMX, X86::FeatureSSE2, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureSlow3OpsLEA, X86::FeatureSlowIncDec, X86::FeatureMacroFusion }, { } },
  { "yonah", "Select the yonah processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX, X86::FeatureSSE3, X86::FeatureFXSR, X86::FeatureNOPL }, { } },
  { "znver1", "Select the znver1 processor", { X86::FeatureADX, X86::FeatureAES, X86::FeatureAVX2, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureCLFLUSHOPT, X86::FeatureCLZERO, X86::FeatureCMPXCHG16B, X86::FeatureF16C, X86::FeatureFMA, X86::FeatureFSGSBase, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureFastLZCNT, X86::FeatureLAHFSAHF, X86::FeatureLZCNT, X86::FeatureFast15ByteNOP, X86::FeatureMacroFusion, X86::FeatureMMX, X86::FeatureMOVBE, X86::FeatureMWAITX, X86::FeaturePCLMUL, X86::FeaturePOPCNT, X86::FeaturePRFCHW, X86::FeatureRDRAND, X86::FeatureRDSEED, X86::FeatureSHA, X86::FeatureSSE4A, X86::FeatureSlowSHLD, X86::FeatureX87, X86::FeatureXSAVE, X86::FeatureXSAVEC, X86::FeatureXSAVEOPT, X86::FeatureXSAVES }, { } },
};

#ifdef DBGFIELD
#error "<target>GenSubtargetInfo.inc requires a DBGFIELD macro"
#endif
#if !defined(NDEBUG) || defined(LLVM_ENABLE_DUMP)
#define DBGFIELD(x) x,
#else
#define DBGFIELD(x)
#endif

// ===============================================================
// Data tables for the new per-operand machine model.

// {ProcResourceIdx, Cycles}
extern const llvm::MCWriteProcResEntry X86WriteProcResTable[] = {
  { 0,  0}, // Invalid
  { 3,  1}, // #1
  { 1,  2}, // #2
  { 3,  2}, // #3
  { 2,  1}, // #4
  { 3,  1}, // #5
  { 1,  1}, // #6
  { 3,  1}, // #7
  { 3,  7}, // #8
  { 3,  6}, // #9
  { 1,  5}, // #10
  { 3,  5}, // #11
  { 3, 16}, // #12
  { 3,  9}, // #13
  { 3,  8}, // #14
  { 3, 50}, // #15
  { 3, 130}, // #16
  { 3, 68}, // #17
  { 3, 125}, // #18
  { 3, 70}, // #19
  { 3, 34}, // #20
  { 3, 62}, // #21
  { 3, 10}, // #22
  { 3, 12}, // #23
  { 1,  3}, // #24
  { 3,  3}, // #25
  { 3,  4}, // #26
  { 1,  4}, // #27
  { 3,  4}, // #28
  { 3, 71}, // #29
  { 3, 15}, // #30
  { 3, 14}, // #31
  { 2,  5}, // #32
  { 3,  5}, // #33
  { 1,  1}, // #34
  { 2,  1}, // #35
  { 3,  2}, // #36
  { 1,  5}, // #37
  { 2,  5}, // #38
  { 3, 10}, // #39
  { 3, 11}, // #40
  { 3, 13}, // #41
  { 3, 17}, // #42
  { 3, 18}, // #43
  { 3, 20}, // #44
  { 3, 21}, // #45
  { 3, 22}, // #46
  { 3, 23}, // #47
  { 3, 25}, // #48
  { 3, 26}, // #49
  { 3, 29}, // #50
  { 3, 30}, // #51
  { 3, 32}, // #52
  { 3, 45}, // #53
  { 3, 46}, // #54
  { 3, 48}, // #55
  { 3, 55}, // #56
  { 3, 59}, // #57
  { 3, 63}, // #58
  { 3, 72}, // #59
  { 3, 74}, // #60
  { 3, 77}, // #61
  { 3, 78}, // #62
  { 3, 79}, // #63
  { 3, 92}, // #64
  { 3, 94}, // #65
  { 3, 99}, // #66
  { 3, 121}, // #67
  { 3, 127}, // #68
  { 3, 140}, // #69
  { 3, 141}, // #70
  { 3, 146}, // #71
  { 3, 147}, // #72
  { 3, 168}, // #73
  { 3, 174}, // #74
  { 3, 183}, // #75
  { 3, 202}, // #76
  {15,  1}, // #77
  {19,  1}, // #78
  {22,  1}, // #79
  {23,  1}, // #80
  { 7,  1}, // #81
  {12,  1}, // #82
  {17,  1}, // #83
  {21,  2}, // #84
  {22,  1}, // #85
  {23,  4}, // #86
  {14,  1}, // #87
  {17,  1}, // #88
  {20,  1}, // #89
  {21,  1}, // #90
  {22,  1}, // #91
  {23,  2}, // #92
  {14,  1}, // #93
  {20,  1}, // #94
  {22,  1}, // #95
  {23,  1}, // #96
  { 7,  1}, // #97
  {12,  1}, // #98
  {21,  1}, // #99
  {23,  2}, // #100
  {17,  1}, // #101
  {21,  1}, // #102
  {23,  1}, // #103
  { 8,  1}, // #104
  {13,  1}, // #105
  {15,  1}, // #106
  {18,  1}, // #107
  {19,  1}, // #108
  {20,  1}, // #109
  {22,  1}, // #110
  {23,  1}, // #111
  { 7,  1}, // #112
  {12,  1}, // #113
  {14,  2}, // #114
  {17,  1}, // #115
  {20,  2}, // #116
  {21,  2}, // #117
  {22,  3}, // #118
  {23,  6}, // #119
  {17,  1}, // #120
  {21,  1}, // #121
  {22,  1}, // #122
  {23,  2}, // #123
  { 4,  1}, // #124
  {11,  1}, // #125
  {15,  1}, // #126
  {16,  1}, // #127
  {17,  1}, // #128
  {19,  1}, // #129
  {21,  1}, // #130
  {22,  1}, // #131
  {23,  2}, // #132
  { 4,  1}, // #133
  {11,  1}, // #134
  {15,  1}, // #135
  {16,  1}, // #136
  {19,  1}, // #137
  {22,  1}, // #138
  {23,  1}, // #139
  { 8,  1}, // #140
  {13,  1}, // #141
  {15,  1}, // #142
  {17,  1}, // #143
  {18,  1}, // #144
  {19,  1}, // #145
  {20,  1}, // #146
  {21,  1}, // #147
  {22,  1}, // #148
  {23,  2}, // #149
  { 8,  2}, // #150
  {13,  2}, // #151
  {15,  2}, // #152
  {17,  1}, // #153
  {18,  2}, // #154
  {19,  2}, // #155
  {20,  2}, // #156
  {21,  1}, // #157
  {22,  2}, // #158
  {23,  3}, // #159
  { 8,  2}, // #160
  {13,  2}, // #161
  {15,  2}, // #162
  {18,  2}, // #163
  {19,  2}, // #164
  {20,  2}, // #165
  {22,  2}, // #166
  {23,  2}, // #167
  { 3,  2}, // #168
  { 8,  7}, // #169
  {11,  2}, // #170
  {12,  2}, // #171
  {13,  9}, // #172
  {14,  2}, // #173
  {15,  7}, // #174
  {17,  1}, // #175
  {18,  7}, // #176
  {19, 10}, // #177
  {20,  9}, // #178
  {21,  1}, // #179
  {22, 10}, // #180
  {23, 11}, // #181
  { 3,  2}, // #182
  { 8,  7}, // #183
  {11,  2}, // #184
  {12,  2}, // #185
  {13,  9}, // #186
  {14,  2}, // #187
  {15,  7}, // #188
  {18,  7}, // #189
  {19, 11}, // #190
  {20,  9}, // #191
  {22, 11}, // #192
  {23, 11}, // #193
  {14,  1}, // #194
  {15,  1}, // #195
  {17,  1}, // #196
  {19,  1}, // #197
  {20,  1}, // #198
  {21,  1}, // #199
  {22,  2}, // #200
  {23,  3}, // #201
  {14,  1}, // #202
  {15,  1}, // #203
  {19,  1}, // #204
  {20,  1}, // #205
  {22,  2}, // #206
  {23,  2}, // #207
  {15,  1}, // #208
  {17,  1}, // #209
  {19,  1}, // #210
  {21,  1}, // #211
  {22,  1}, // #212
  {23,  2}, // #213
  {14,  1}, // #214
  {17,  1}, // #215
  {20,  1}, // #216
  {21,  1}, // #217
  {22,  2}, // #218
  {23,  3}, // #219
  {14,  1}, // #220
  {20,  1}, // #221
  {22,  2}, // #222
  {23,  2}, // #223
  { 1, 10}, // #224
  { 3,  1}, // #225
  {11,  1}, // #226
  {12,  1}, // #227
  {13,  1}, // #228
  {14,  1}, // #229
  {17,  1}, // #230
  {19,  1}, // #231
  {20,  1}, // #232
  {21,  1}, // #233
  {22,  1}, // #234
  {23,  2}, // #235
  { 1, 10}, // #236
  { 3,  1}, // #237
  {11,  1}, // #238
  {12,  1}, // #239
  {13,  1}, // #240
  {14,  1}, // #241
  {19,  1}, // #242
  {20,  1}, // #243
  {22,  1}, // #244
  {23,  1}, // #245
  { 2,  8}, // #246
  { 3,  1}, // #247
  {11,  1}, // #248
  {12,  1}, // #249
  {13,  1}, // #250
  {14,  1}, // #251
  {17,  1}, // #252
  {19,  1}, // #253
  {20,  1}, // #254
  {21,  1}, // #255
  {22,  1}, // #256
  {23,  2}, // #257
  { 2,  8}, // #258
  { 3,  1}, // #259
  {11,  1}, // #260
  {12,  1}, // #261
  {13,  1}, // #262
  {14,  1}, // #263
  {19,  1}, // #264
  {20,  1}, // #265
  {22,  1}, // #266
  {23,  1}, // #267
  { 2,  5}, // #268
  { 3,  1}, // #269
  {11,  1}, // #270
  {12,  1}, // #271
  {13,  1}, // #272
  {14,  1}, // #273
  {17,  1}, // #274
  {19,  1}, // #275
  {20,  1}, // #276
  {21,  1}, // #277
  {22,  1}, // #278
  {23,  2}, // #279
  { 2,  5}, // #280
  { 3,  1}, // #281
  {11,  1}, // #282
  {12,  1}, // #283
  {13,  1}, // #284
  {14,  1}, // #285
  {19,  1}, // #286
  {20,  1}, // #287
  {22,  1}, // #288
  {23,  1}, // #289
  { 2,  3}, // #290
  { 3,  1}, // #291
  {11,  1}, // #292
  {12,  1}, // #293
  {13,  1}, // #294
  {14,  1}, // #295
  {19,  1}, // #296
  {20,  1}, // #297
  {22,  1}, // #298
  {23,  1}, // #299
  { 2,  4}, // #300
  { 3,  1}, // #301
  {11,  1}, // #302
  {12,  1}, // #303
  {13,  1}, // #304
  {14,  1}, // #305
  {19,  1}, // #306
  {20,  1}, // #307
  {22,  1}, // #308
  {23,  1}, // #309
  { 3,  1}, // #310
  { 4,  1}, // #311
  { 8,  1}, // #312
  {11,  2}, // #313
  {12,  1}, // #314
  {13,  2}, // #315
  {14,  1}, // #316
  {15,  2}, // #317
  {16,  1}, // #318
  {17,  1}, // #319
  {18,  1}, // #320
  {19,  3}, // #321
  {20,  2}, // #322
  {21,  1}, // #323
  {22,  3}, // #324
  {23,  4}, // #325
  { 3,  1}, // #326
  { 4,  1}, // #327
  { 8,  1}, // #328
  {11,  2}, // #329
  {12,  1}, // #330
  {13,  2}, // #331
  {14,  1}, // #332
  {15,  2}, // #333
  {16,  1}, // #334
  {18,  1}, // #335
  {19,  3}, // #336
  {20,  2}, // #337
  {22,  3}, // #338
  {23,  3}, // #339
  { 3,  2}, // #340
  { 4,  1}, // #341
  { 8,  1}, // #342
  {11,  3}, // #343
  {12,  2}, // #344
  {13,  3}, // #345
  {14,  2}, // #346
  {15,  2}, // #347
  {16,  1}, // #348
  {17,  1}, // #349
  {18,  1}, // #350
  {19,  4}, // #351
  {20,  3}, // #352
  {21,  1}, // #353
  {22,  4}, // #354
  {23,  5}, // #355
  { 3,  2}, // #356
  { 4,  1}, // #357
  { 8,  1}, // #358
  {11,  3}, // #359
  {12,  2}, // #360
  {13,  3}, // #361
  {14,  2}, // #362
  {15,  2}, // #363
  {16,  1}, // #364
  {18,  1}, // #365
  {19,  4}, // #366
  {20,  3}, // #367
  {22,  4}, // #368
  {23,  4}, // #369
  { 7,  1}, // #370
  { 8,  1}, // #371
  {12,  1}, // #372
  {13,  1}, // #373
  {15,  1}, // #374
  {18,  1}, // #375
  {19,  1}, // #376
  {20,  1}, // #377
  {21,  1}, // #378
  {22,  1}, // #379
  {23,  3}, // #380
  { 3,  1}, // #381
  { 8,  1}, // #382
  {11,  1}, // #383
  {12,  1}, // #384
  {13,  2}, // #385
  {14,  1}, // #386
  {15,  1}, // #387
  {18,  1}, // #388
  {19,  2}, // #389
  {20,  2}, // #390
  {22,  2}, // #391
  {23,  2}, // #392
  {11,  8}, // #393
  {15,  1}, // #394
  {19, 30}, // #395
  {22, 31}, // #396
  {23, 31}, // #397
  {11,  2}, // #398
  {19,  2}, // #399
  {22,  2}, // #400
  {23,  2}, // #401
  { 4,  1}, // #402
  { 8,  2}, // #403
  {11,  1}, // #404
  {13,  2}, // #405
  {15,  3}, // #406
  {16,  1}, // #407
  {17,  1}, // #408
  {18,  2}, // #409
  {19,  3}, // #410
  {20,  2}, // #411
  {21,  1}, // #412
  {22,  3}, // #413
  {23,  4}, // #414
  { 4,  1}, // #415
  { 8,  2}, // #416
  {11,  1}, // #417
  {13,  2}, // #418
  {15,  3}, // #419
  {16,  1}, // #420
  {18,  2}, // #421
  {19,  3}, // #422
  {20,  2}, // #423
  {22,  3}, // #424
  {23,  3}, // #425
  { 3,  1}, // #426
  {11,  1}, // #427
  {12,  1}, // #428
  {13,  1}, // #429
  {14,  1}, // #430
  {17,  1}, // #431
  {19,  1}, // #432
  {20,  1}, // #433
  {21,  1}, // #434
  {22,  2}, // #435
  {23,  3}, // #436
  {11,  1}, // #437
  {19,  1}, // #438
  {22,  1}, // #439
  {23,  1}, // #440
  { 7,  1}, // #441
  {12,  1}, // #442
  {17,  1}, // #443
  {21,  1}, // #444
  {23,  2}, // #445
  { 8,  2}, // #446
  {13,  2}, // #447
  {15,  3}, // #448
  {17,  1}, // #449
  {18,  2}, // #450
  {19,  3}, // #451
  {20,  2}, // #452
  {21,  1}, // #453
  {22,  3}, // #454
  {23,  4}, // #455
  { 8,  2}, // #456
  {13,  2}, // #457
  {15,  3}, // #458
  {18,  2}, // #459
  {19,  3}, // #460
  {20,  2}, // #461
  {22,  3}, // #462
  {23,  3}, // #463
  { 3,  1}, // #464
  { 8,  2}, // #465
  {11,  1}, // #466
  {12,  1}, // #467
  {13,  3}, // #468
  {14,  1}, // #469
  {15,  2}, // #470
  {17,  1}, // #471
  {18,  2}, // #472
  {19,  3}, // #473
  {20,  3}, // #474
  {21,  1}, // #475
  {22,  3}, // #476
  {23,  4}, // #477
  { 3,  1}, // #478
  { 8,  2}, // #479
  {11,  1}, // #480
  {12,  1}, // #481
  {13,  3}, // #482
  {14,  1}, // #483
  {15,  2}, // #484
  {18,  2}, // #485
  {19,  3}, // #486
  {20,  3}, // #487
  {22,  3}, // #488
  {23,  3}, // #489
  {11,  1}, // #490
  {17,  1}, // #491
  {19,  1}, // #492
  {21,  1}, // #493
  {22,  1}, // #494
  {23,  2}, // #495
  { 3,  4}, // #496
  { 8,  3}, // #497
  {11,  4}, // #498
  {12,  4}, // #499
  {13,  7}, // #500
  {14,  4}, // #501
  {15,  3}, // #502
  {17,  1}, // #503
  {18,  3}, // #504
  {19,  7}, // #505
  {20,  7}, // #506
  {21,  1}, // #507
  {22,  8}, // #508
  {23,  9}, // #509
  { 3,  4}, // #510
  { 8,  3}, // #511
  {11,  4}, // #512
  {12,  4}, // #513
  {13,  7}, // #514
  {14,  4}, // #515
  {15,  3}, // #516
  {18,  3}, // #517
  {19,  7}, // #518
  {20,  7}, // #519
  {22,  8}, // #520
  {23,  8}, // #521
  { 3,  4}, // #522
  { 8,  3}, // #523
  {11,  4}, // #524
  {12,  4}, // #525
  {13,  7}, // #526
  {14,  4}, // #527
  {15,  3}, // #528
  {17,  1}, // #529
  {18,  3}, // #530
  {19,  8}, // #531
  {20,  7}, // #532
  {21,  1}, // #533
  {22,  9}, // #534
  {23, 10}, // #535
  { 3,  4}, // #536
  { 8,  3}, // #537
  {11,  4}, // #538
  {12,  4}, // #539
  {13,  7}, // #540
  {14,  4}, // #541
  {15,  3}, // #542
  {18,  3}, // #543
  {19,  8}, // #544
  {20,  7}, // #545
  {22,  9}, // #546
  {23,  9}, // #547
  { 3,  3}, // #548
  {11,  3}, // #549
  {12,  3}, // #550
  {13,  3}, // #551
  {14,  3}, // #552
  {17,  1}, // #553
  {19,  3}, // #554
  {20,  3}, // #555
  {21,  1}, // #556
  {22,  3}, // #557
  {23,  4}, // #558
  { 3,  3}, // #559
  {11,  3}, // #560
  {12,  3}, // #561
  {13,  3}, // #562
  {14,  3}, // #563
  {19,  3}, // #564
  {20,  3}, // #565
  {22,  3}, // #566
  {23,  3}, // #567
  { 3,  2}, // #568
  {11,  2}, // #569
  {12,  2}, // #570
  {13,  2}, // #571
  {14,  2}, // #572
  {17,  1}, // #573
  {19,  2}, // #574
  {20,  2}, // #575
  {21,  1}, // #576
  {22,  2}, // #577
  {23,  3}, // #578
  { 3,  2}, // #579
  {11,  2}, // #580
  {12,  2}, // #581
  {13,  2}, // #582
  {14,  2}, // #583
  {19,  2}, // #584
  {20,  2}, // #585
  {22,  2}, // #586
  {23,  2}, // #587
  { 3,  1}, // #588
  { 8,  1}, // #589
  {11,  1}, // #590
  {12,  1}, // #591
  {13,  2}, // #592
  {14,  1}, // #593
  {15,  1}, // #594
  {17,  1}, // #595
  {18,  1}, // #596
  {19,  2}, // #597
  {20,  2}, // #598
  {21,  1}, // #599
  {22,  2}, // #600
  {23,  3}, // #601
  { 7,  1}, // #602
  {12,  1}, // #603
  {14,  1}, // #604
  {17,  1}, // #605
  {20,  1}, // #606
  {21,  2}, // #607
  {22,  1}, // #608
  {23,  4}, // #609
  { 4,  2}, // #610
  {11,  2}, // #611
  {15,  2}, // #612
  {16,  2}, // #613
  {17,  1}, // #614
  {19,  2}, // #615
  {21,  1}, // #616
  {22,  2}, // #617
  {23,  3}, // #618
  { 7,  1}, // #619
  {12,  1}, // #620
  {14,  1}, // #621
  {20,  1}, // #622
  {21,  1}, // #623
  {22,  1}, // #624
  {23,  3}, // #625
  { 4,  1}, // #626
  {11,  1}, // #627
  {14,  1}, // #628
  {15,  1}, // #629
  {16,  1}, // #630
  {17,  1}, // #631
  {19,  1}, // #632
  {20,  1}, // #633
  {21,  2}, // #634
  {22,  4}, // #635
  {23,  6}, // #636
  { 4,  1}, // #637
  {11,  1}, // #638
  {15,  1}, // #639
  {16,  1}, // #640
  {17,  1}, // #641
  {19,  1}, // #642
  {21,  2}, // #643
  {22,  2}, // #644
  {23,  4}, // #645
  { 4,  1}, // #646
  {11,  1}, // #647
  {14,  1}, // #648
  {15,  1}, // #649
  {16,  1}, // #650
  {19,  1}, // #651
  {20,  1}, // #652
  {22,  4}, // #653
  {23,  4}, // #654
  { 2, 14}, // #655
  { 3,  1}, // #656
  {11,  1}, // #657
  {12,  1}, // #658
  {13,  1}, // #659
  {14,  1}, // #660
  {17,  1}, // #661
  {19,  1}, // #662
  {20,  1}, // #663
  {21,  1}, // #664
  {22,  1}, // #665
  {23,  2}, // #666
  { 2, 14}, // #667
  { 3,  1}, // #668
  {11,  1}, // #669
  {12,  1}, // #670
  {13,  1}, // #671
  {14,  1}, // #672
  {19,  1}, // #673
  {20,  1}, // #674
  {22,  1}, // #675
  {23,  1}, // #676
  { 2,  7}, // #677
  { 3,  1}, // #678
  {11,  1}, // #679
  {12,  1}, // #680
  {13,  1}, // #681
  {14,  1}, // #682
  {17,  1}, // #683
  {19,  1}, // #684
  {20,  1}, // #685
  {21,  1}, // #686
  {22,  1}, // #687
  {23,  2}, // #688
  { 2,  7}, // #689
  { 3,  1}, // #690
  {11,  1}, // #691
  {12,  1}, // #692
  {13,  1}, // #693
  {14,  1}, // #694
  {19,  1}, // #695
  {20,  1}, // #696
  {22,  1}, // #697
  {23,  1}, // #698
  { 2,  9}, // #699
  { 3,  1}, // #700
  {11,  1}, // #701
  {12,  1}, // #702
  {13,  1}, // #703
  {14,  1}, // #704
  {19,  1}, // #705
  {20,  1}, // #706
  {22,  1}, // #707
  {23,  1}, // #708
  { 4,  1}, // #709
  { 7,  1}, // #710
  {11,  1}, // #711
  {12,  1}, // #712
  {15,  1}, // #713
  {16,  1}, // #714
  {19,  1}, // #715
  {21,  1}, // #716
  {22,  1}, // #717
  {23,  3}, // #718
  { 4,  1}, // #719
  { 8,  1}, // #720
  {11,  1}, // #721
  {13,  1}, // #722
  {15,  2}, // #723
  {16,  1}, // #724
  {18,  1}, // #725
  {19,  2}, // #726
  {20,  1}, // #727
  {22,  2}, // #728
  {23,  2}, // #729
  { 2, 16}, // #730
  { 3,  2}, // #731
  {11,  2}, // #732
  {12,  2}, // #733
  {13,  2}, // #734
  {14,  2}, // #735
  {17,  1}, // #736
  {19,  3}, // #737
  {20,  2}, // #738
  {21,  1}, // #739
  {22,  3}, // #740
  {23,  4}, // #741
  { 2, 16}, // #742
  { 3,  2}, // #743
  {11,  2}, // #744
  {12,  2}, // #745
  {13,  2}, // #746
  {14,  2}, // #747
  {19,  3}, // #748
  {20,  2}, // #749
  {22,  3}, // #750
  {23,  3}, // #751
  { 2, 10}, // #752
  { 3,  2}, // #753
  {11,  2}, // #754
  {12,  2}, // #755
  {13,  2}, // #756
  {14,  2}, // #757
  {17,  1}, // #758
  {19,  3}, // #759
  {20,  2}, // #760
  {21,  1}, // #761
  {22,  3}, // #762
  {23,  4}, // #763
  { 2, 10}, // #764
  { 3,  2}, // #765
  {11,  2}, // #766
  {12,  2}, // #767
  {13,  2}, // #768
  {14,  2}, // #769
  {19,  3}, // #770
  {20,  2}, // #771
  {22,  3}, // #772
  {23,  3}, // #773
  { 3,  1}, // #774
  { 7,  1}, // #775
  {11,  1}, // #776
  {12,  2}, // #777
  {13,  1}, // #778
  {14,  1}, // #779
  {15,  1}, // #780
  {19,  2}, // #781
  {20,  1}, // #782
  {21,  1}, // #783
  {22,  2}, // #784
  {23,  4}, // #785
  { 3,  2}, // #786
  { 8,  1}, // #787
  {11,  2}, // #788
  {12,  2}, // #789
  {13,  3}, // #790
  {14,  2}, // #791
  {15,  1}, // #792
  {17,  1}, // #793
  {18,  1}, // #794
  {19,  3}, // #795
  {20,  3}, // #796
  {21,  1}, // #797
  {22,  3}, // #798
  {23,  4}, // #799
  { 3,  2}, // #800
  { 8,  1}, // #801
  {11,  2}, // #802
  {12,  2}, // #803
  {13,  3}, // #804
  {14,  2}, // #805
  {15,  1}, // #806
  {18,  1}, // #807
  {19,  3}, // #808
  {20,  3}, // #809
  {22,  3}, // #810
  {23,  3}, // #811
  { 2, 28}, // #812
  { 3,  2}, // #813
  {11,  2}, // #814
  {12,  2}, // #815
  {13,  2}, // #816
  {14,  2}, // #817
  {17,  1}, // #818
  {19,  3}, // #819
  {20,  2}, // #820
  {21,  1}, // #821
  {22,  3}, // #822
  {23,  4}, // #823
  { 2, 28}, // #824
  { 3,  2}, // #825
  {11,  2}, // #826
  {12,  2}, // #827
  {13,  2}, // #828
  {14,  2}, // #829
  {19,  3}, // #830
  {20,  2}, // #831
  {22,  3}, // #832
  {23,  3}, // #833
  { 2, 14}, // #834
  { 3,  2}, // #835
  {11,  2}, // #836
  {12,  2}, // #837
  {13,  2}, // #838
  {14,  2}, // #839
  {17,  1}, // #840
  {19,  3}, // #841
  {20,  2}, // #842
  {21,  1}, // #843
  {22,  3}, // #844
  {23,  4}, // #845
  { 2, 14}, // #846
  { 3,  2}, // #847
  {11,  2}, // #848
  {12,  2}, // #849
  {13,  2}, // #850
  {14,  2}, // #851
  {19,  3}, // #852
  {20,  2}, // #853
  {22,  3}, // #854
  {23,  3}, // #855
  { 4,  1}, // #856
  {11,  1}, // #857
  {14,  1}, // #858
  {15,  1}, // #859
  {16,  1}, // #860
  {17,  1}, // #861
  {19,  1}, // #862
  {20,  1}, // #863
  {21,  1}, // #864
  {22,  4}, // #865
  {23,  5}, // #866
  { 4,  1}, // #867
  {11,  1}, // #868
  {14,  1}, // #869
  {15,  1}, // #870
  {16,  1}, // #871
  {19,  1}, // #872
  {20,  1}, // #873
  {22,  3}, // #874
  {23,  3}, // #875
  { 4,  2}, // #876
  {11,  2}, // #877
  {14,  3}, // #878
  {15,  3}, // #879
  {16,  2}, // #880
  {17,  1}, // #881
  {19,  3}, // #882
  {20,  3}, // #883
  {21,  2}, // #884
  {22,  9}, // #885
  {23, 11}, // #886
  { 3,  2}, // #887
  { 4,  1}, // #888
  { 9,  4}, // #889
  {11,  3}, // #890
  {12,  2}, // #891
  {13,  2}, // #892
  {14,  6}, // #893
  {15,  1}, // #894
  {16,  5}, // #895
  {18,  4}, // #896
  {19,  3}, // #897
  {20,  6}, // #898
  {22, 12}, // #899
  {23, 12}, // #900
  {17,  1}, // #901
  {21,  1}, // #902
  {22,  2}, // #903
  {23,  3}, // #904
  { 9,  1}, // #905
  {14,  1}, // #906
  {16,  1}, // #907
  {18,  1}, // #908
  {20,  1}, // #909
  {22,  3}, // #910
  {23,  3}, // #911
  { 7,  1}, // #912
  {12,  1}, // #913
  {17,  1}, // #914
  {21,  2}, // #915
  {22,  3}, // #916
  {23,  6}, // #917
  { 3,  1}, // #918
  {11,  2}, // #919
  {12,  1}, // #920
  {13,  1}, // #921
  {14,  1}, // #922
  {17,  1}, // #923
  {19,  2}, // #924
  {20,  1}, // #925
  {21,  1}, // #926
  {22,  2}, // #927
  {23,  3}, // #928
  {14,  2}, // #929
  {20,  2}, // #930
  {22, 11}, // #931
  {23, 11}, // #932
  { 7,  1}, // #933
  { 9,  1}, // #934
  {12,  1}, // #935
  {14,  1}, // #936
  {16,  1}, // #937
  {18,  1}, // #938
  {20,  1}, // #939
  {21,  1}, // #940
  {22,  1}, // #941
  {23,  3}, // #942
  {14,  2}, // #943
  {20,  2}, // #944
  {22,  5}, // #945
  {23,  5}, // #946
  { 3,  1}, // #947
  { 4,  1}, // #948
  {11,  2}, // #949
  {12,  1}, // #950
  {13,  1}, // #951
  {14,  1}, // #952
  {15,  1}, // #953
  {16,  1}, // #954
  {19,  2}, // #955
  {20,  1}, // #956
  {22,  2}, // #957
  {23,  2}, // #958
  { 9,  1}, // #959
  {14,  1}, // #960
  {16,  1}, // #961
  {18,  1}, // #962
  {20,  1}, // #963
  {22,  5}, // #964
  {23,  5}, // #965
  { 7,  1}, // #966
  {12,  1}, // #967
  {14,  4}, // #968
  {15,  2}, // #969
  {17,  1}, // #970
  {19,  2}, // #971
  {20,  4}, // #972
  {21,  2}, // #973
  {22, 11}, // #974
  {23, 14}, // #975
  { 9,  2}, // #976
  {14,  4}, // #977
  {15,  1}, // #978
  {16,  2}, // #979
  {18,  2}, // #980
  {19,  1}, // #981
  {20,  4}, // #982
  {22,  7}, // #983
  {23,  7}, // #984
  { 9,  1}, // #985
  {14,  1}, // #986
  {16,  1}, // #987
  {18,  1}, // #988
  {20,  1}, // #989
  {22,  6}, // #990
  {23,  6}, // #991
  { 3,  2}, // #992
  { 7,  1}, // #993
  { 8,  4}, // #994
  {11,  2}, // #995
  {12,  3}, // #996
  {13,  6}, // #997
  {14,  6}, // #998
  {15,  4}, // #999
  {17,  1}, // #1000
  {18,  4}, // #1001
  {19,  6}, // #1002
  {20, 10}, // #1003
  {21,  2}, // #1004
  {22, 16}, // #1005
  {23, 19}, // #1006
  { 8,  2}, // #1007
  {13,  2}, // #1008
  {15,  2}, // #1009
  {18,  2}, // #1010
  {19,  2}, // #1011
  {20,  2}, // #1012
  {22, 22}, // #1013
  {23, 22}, // #1014
  { 7,  1}, // #1015
  { 8,  1}, // #1016
  { 9,  1}, // #1017
  {12,  1}, // #1018
  {13,  1}, // #1019
  {14,  2}, // #1020
  {15,  1}, // #1021
  {16,  1}, // #1022
  {17,  1}, // #1023
  {18,  2}, // #1024
  {19,  1}, // #1025
  {20,  3}, // #1026
  {21,  2}, // #1027
  {22,  5}, // #1028
  {23,  8}, // #1029
  { 8,  6}, // #1030
  {11,  3}, // #1031
  {13,  6}, // #1032
  {15,  6}, // #1033
  {18,  6}, // #1034
  {19,  9}, // #1035
  {20,  6}, // #1036
  {22, 15}, // #1037
  {23, 15}, // #1038
  { 8,  1}, // #1039
  { 9,  5}, // #1040
  {13,  1}, // #1041
  {14,  9}, // #1042
  {15,  1}, // #1043
  {16,  5}, // #1044
  {17,  2}, // #1045
  {18,  6}, // #1046
  {19,  1}, // #1047
  {20, 10}, // #1048
  {21,  3}, // #1049
  {22, 20}, // #1050
  {23, 23}, // #1051
  { 8,  1}, // #1052
  { 9,  5}, // #1053
  {13,  1}, // #1054
  {14,  9}, // #1055
  {15,  1}, // #1056
  {16,  5}, // #1057
  {17,  3}, // #1058
  {18,  6}, // #1059
  {19,  1}, // #1060
  {20, 10}, // #1061
  {21,  3}, // #1062
  {22, 20}, // #1063
  {23, 23}, // #1064
  { 8,  1}, // #1065
  { 9,  1}, // #1066
  {13,  1}, // #1067
  {14,  2}, // #1068
  {15,  1}, // #1069
  {16,  1}, // #1070
  {18,  2}, // #1071
  {19,  1}, // #1072
  {20,  3}, // #1073
  {22,  8}, // #1074
  {23,  8}, // #1075
  { 3,  4}, // #1076
  { 9,  2}, // #1077
  {11,  4}, // #1078
  {12,  4}, // #1079
  {13,  5}, // #1080
  {14,  8}, // #1081
  {15,  1}, // #1082
  {16,  2}, // #1083
  {17, 33}, // #1084
  {18,  2}, // #1085
  {19,  6}, // #1086
  {20,  9}, // #1087
  {21, 33}, // #1088
  {22, 57}, // #1089
  {23, 90}, // #1090
  { 9,  1}, // #1091
  {14,  1}, // #1092
  {16,  1}, // #1093
  {17,  1}, // #1094
  {18,  1}, // #1095
  {20,  1}, // #1096
  {21,  1}, // #1097
  {22,  2}, // #1098
  {23,  3}, // #1099
  {14,  2}, // #1100
  {20,  2}, // #1101
  {22,  2}, // #1102
  {23,  2}, // #1103
  { 3,  1}, // #1104
  {11,  1}, // #1105
  {12,  1}, // #1106
  {13,  1}, // #1107
  {14,  1}, // #1108
  {19,  1}, // #1109
  {20,  1}, // #1110
  {22,  2}, // #1111
  {23,  2}, // #1112
  {11,  1}, // #1113
  {19,  2}, // #1114
  {22,  2}, // #1115
  {23,  2}, // #1116
  { 4,  1}, // #1117
  {11,  1}, // #1118
  {15,  1}, // #1119
  {16,  1}, // #1120
  {19,  1}, // #1121
  {22,  2}, // #1122
  {23,  2}, // #1123
  {14,  2}, // #1124
  {20,  2}, // #1125
  {22,  3}, // #1126
  {23,  3}, // #1127
  { 7,  1}, // #1128
  {12,  1}, // #1129
  {21,  1}, // #1130
  {22,  1}, // #1131
  {23,  3}, // #1132
  { 7,  1}, // #1133
  {12,  1}, // #1134
  {14,  1}, // #1135
  {20,  1}, // #1136
  {21,  1}, // #1137
  {22,  2}, // #1138
  {23,  4}, // #1139
  { 7,  1}, // #1140
  { 9,  1}, // #1141
  {12,  1}, // #1142
  {14,  1}, // #1143
  {16,  1}, // #1144
  {18,  1}, // #1145
  {20,  1}, // #1146
  {21,  1}, // #1147
  {22,  2}, // #1148
  {23,  4}, // #1149
  { 7,  1}, // #1150
  {12,  1}, // #1151
  {21,  1}, // #1152
  {22,  4}, // #1153
  {23,  6}, // #1154
  { 9,  1}, // #1155
  {14,  1}, // #1156
  {16,  1}, // #1157
  {18,  1}, // #1158
  {20,  1}, // #1159
  {22,  2}, // #1160
  {23,  2}, // #1161
  { 9,  1}, // #1162
  {14,  1}, // #1163
  {16,  1}, // #1164
  {17,  1}, // #1165
  {18,  1}, // #1166
  {20,  1}, // #1167
  {21,  1}, // #1168
  {22,  1}, // #1169
  {23,  2}, // #1170
  { 3,  1}, // #1171
  { 7,  1}, // #1172
  {11,  1}, // #1173
  {12,  2}, // #1174
  {13,  1}, // #1175
  {14,  1}, // #1176
  {19,  1}, // #1177
  {20,  1}, // #1178
  {21,  1}, // #1179
  {22,  1}, // #1180
  {23,  3}, // #1181
  { 4,  1}, // #1182
  { 9,  1}, // #1183
  {11,  1}, // #1184
  {14,  2}, // #1185
  {15,  1}, // #1186
  {16,  2}, // #1187
  {18,  1}, // #1188
  {19,  1}, // #1189
  {20,  2}, // #1190
  {22,  4}, // #1191
  {23,  4}, // #1192
  { 7,  1}, // #1193
  { 9,  1}, // #1194
  {12,  1}, // #1195
  {14,  1}, // #1196
  {16,  1}, // #1197
  {17,  1}, // #1198
  {18,  1}, // #1199
  {20,  1}, // #1200
  {21,  2}, // #1201
  {22,  2}, // #1202
  {23,  5}, // #1203
  { 7,  1}, // #1204
  {12,  1}, // #1205
  {14,  2}, // #1206
  {17,  1}, // #1207
  {20,  2}, // #1208
  {21,  2}, // #1209
  {22,  2}, // #1210
  {23,  5}, // #1211
  { 7,  1}, // #1212
  {12,  1}, // #1213
  {17,  1}, // #1214
  {21,  2}, // #1215
  {22,  2}, // #1216
  {23,  5}, // #1217
  { 3,  1}, // #1218
  { 4,  1}, // #1219
  {11,  2}, // #1220
  {12,  1}, // #1221
  {13,  1}, // #1222
  {14,  1}, // #1223
  {15,  1}, // #1224
  {16,  1}, // #1225
  {17,  1}, // #1226
  {19,  2}, // #1227
  {20,  1}, // #1228
  {21,  1}, // #1229
  {22,  2}, // #1230
  {23,  3}, // #1231
  { 4,  1}, // #1232
  { 8,  1}, // #1233
  {11,  1}, // #1234
  {13,  1}, // #1235
  {15,  2}, // #1236
  {16,  1}, // #1237
  {17,  1}, // #1238
  {18,  1}, // #1239
  {19,  2}, // #1240
  {20,  1}, // #1241
  {21,  1}, // #1242
  {22,  2}, // #1243
  {23,  3}, // #1244
  { 4,  1}, // #1245
  {11,  1}, // #1246
  {14,  1}, // #1247
  {15,  1}, // #1248
  {16,  1}, // #1249
  {17,  1}, // #1250
  {19,  1}, // #1251
  {20,  1}, // #1252
  {21,  1}, // #1253
  {22,  3}, // #1254
  {23,  4}, // #1255
  { 4,  1}, // #1256
  {11,  1}, // #1257
  {15,  1}, // #1258
  {16,  1}, // #1259
  {17,  1}, // #1260
  {19,  1}, // #1261
  {21,  1}, // #1262
  {22,  2}, // #1263
  {23,  3}, // #1264
  {14,  1}, // #1265
  {17,  1}, // #1266
  {20,  1}, // #1267
  {21,  1}, // #1268
  {22,  4}, // #1269
  {23,  5}, // #1270
  { 9,  1}, // #1271
  {14,  1}, // #1272
  {16,  1}, // #1273
  {18,  1}, // #1274
  {20,  1}, // #1275
  {22,  1}, // #1276
  {23,  1}, // #1277
  { 7,  1}, // #1278
  {12,  1}, // #1279
  {15,  1}, // #1280
  {19,  1}, // #1281
  {21,  1}, // #1282
  {22,  1}, // #1283
  {23,  3}, // #1284
  { 8,  2}, // #1285
  {13,  2}, // #1286
  {15,  2}, // #1287
  {18,  2}, // #1288
  {19,  2}, // #1289
  {20,  2}, // #1290
  {22,  3}, // #1291
  {23,  3}, // #1292
  {14,  1}, // #1293
  {20,  1}, // #1294
  {22,  3}, // #1295
  {23,  3}, // #1296
  {14,  1}, // #1297
  {17,  1}, // #1298
  {20,  1}, // #1299
  {21,  2}, // #1300
  {22,  3}, // #1301
  {23,  5}, // #1302
  {14,  2}, // #1303
  {17,  1}, // #1304
  {20,  2}, // #1305
  {21,  2}, // #1306
  {22,  3}, // #1307
  {23,  5}, // #1308
  { 8,  1}, // #1309
  {13,  1}, // #1310
  {15,  1}, // #1311
  {17,  1}, // #1312
  {18,  1}, // #1313
  {19,  2}, // #1314
  {20,  1}, // #1315
  {21,  1}, // #1316
  {22,  2}, // #1317
  {23,  3}, // #1318
  {19,  1}, // #1319
  {22,  4}, // #1320
  {23,  4}, // #1321
  { 4,  2}, // #1322
  { 9,  2}, // #1323
  {11,  2}, // #1324
  {14,  2}, // #1325
  {15,  2}, // #1326
  {16,  4}, // #1327
  {17,  1}, // #1328
  {18,  2}, // #1329
  {19,  2}, // #1330
  {20,  2}, // #1331
  {21,  1}, // #1332
  {22,  7}, // #1333
  {23,  8}, // #1334
  { 4,  1}, // #1335
  { 9,  2}, // #1336
  {11,  1}, // #1337
  {14,  2}, // #1338
  {15,  1}, // #1339
  {16,  3}, // #1340
  {17,  1}, // #1341
  {18,  2}, // #1342
  {19,  1}, // #1343
  {20,  2}, // #1344
  {21,  1}, // #1345
  {22,  4}, // #1346
  {23,  5}, // #1347
  { 4,  1}, // #1348
  { 9,  1}, // #1349
  {11,  1}, // #1350
  {14,  2}, // #1351
  {15,  1}, // #1352
  {16,  2}, // #1353
  {18,  1}, // #1354
  {19,  1}, // #1355
  {20,  2}, // #1356
  {22,  3}, // #1357
  {23,  3}, // #1358
  {14,  1}, // #1359
  {20,  1}, // #1360
  {22,  5}, // #1361
  {23,  5}, // #1362
  { 4,  1}, // #1363
  {11,  1}, // #1364
  {14,  4}, // #1365
  {15,  2}, // #1366
  {16,  1}, // #1367
  {17,  1}, // #1368
  {19,  2}, // #1369
  {20,  4}, // #1370
  {21,  2}, // #1371
  {22,  8}, // #1372
  {23, 10}, // #1373
  { 4,  2}, // #1374
  {11,  2}, // #1375
  {14,  2}, // #1376
  {15,  2}, // #1377
  {16,  2}, // #1378
  {19,  2}, // #1379
  {20,  2}, // #1380
  {22,  7}, // #1381
  {23,  7}, // #1382
  { 4,  1}, // #1383
  {11,  1}, // #1384
  {14,  4}, // #1385
  {15,  2}, // #1386
  {16,  1}, // #1387
  {19,  2}, // #1388
  {20,  4}, // #1389
  {22,  9}, // #1390
  {23,  9}, // #1391
  { 4,  2}, // #1392
  {11,  2}, // #1393
  {14,  3}, // #1394
  {15,  3}, // #1395
  {16,  2}, // #1396
  {19,  3}, // #1397
  {20,  3}, // #1398
  {22, 10}, // #1399
  {23, 10}, // #1400
  { 8, 16}, // #1401
  {13, 16}, // #1402
  {15, 16}, // #1403
  {18, 16}, // #1404
  {19, 16}, // #1405
  {20, 16}, // #1406
  {22, 16}, // #1407
  {23, 16}, // #1408
  { 9,  3}, // #1409
  {14,  3}, // #1410
  {16,  3}, // #1411
  {17,  1}, // #1412
  {18,  3}, // #1413
  {20,  3}, // #1414
  {21,  1}, // #1415
  {22, 18}, // #1416
  {23, 19}, // #1417
  { 7,  1}, // #1418
  { 9,  5}, // #1419
  {12,  1}, // #1420
  {14,  5}, // #1421
  {16,  5}, // #1422
  {17,  1}, // #1423
  {18,  5}, // #1424
  {20,  5}, // #1425
  {21,  2}, // #1426
  {22, 24}, // #1427
  {23, 27}, // #1428
  { 7,  1}, // #1429
  { 9,  6}, // #1430
  {12,  1}, // #1431
  {14,  6}, // #1432
  {16,  6}, // #1433
  {17,  1}, // #1434
  {18,  6}, // #1435
  {20,  6}, // #1436
  {21,  2}, // #1437
  {22, 25}, // #1438
  {23, 28}, // #1439
  { 3,  2}, // #1440
  {11,  4}, // #1441
  {12,  2}, // #1442
  {13,  3}, // #1443
  {14, 12}, // #1444
  {17,  8}, // #1445
  {19,  7}, // #1446
  {20, 13}, // #1447
  {21,  8}, // #1448
  {22, 56}, // #1449
  {23, 64}, // #1450
  { 3,  4}, // #1451
  { 9,  4}, // #1452
  {11,  4}, // #1453
  {12,  4}, // #1454
  {13,  5}, // #1455
  {14, 10}, // #1456
  {15,  1}, // #1457
  {16,  4}, // #1458
  {17, 31}, // #1459
  {18,  4}, // #1460
  {19,  6}, // #1461
  {20, 11}, // #1462
  {21, 31}, // #1463
  {22, 57}, // #1464
  {23, 88}, // #1465
  { 3,  7}, // #1466
  { 4,  7}, // #1467
  { 8,  3}, // #1468
  { 9,  3}, // #1469
  {11, 15}, // #1470
  {12,  7}, // #1471
  {13, 10}, // #1472
  {14, 10}, // #1473
  {15, 10}, // #1474
  {16, 10}, // #1475
  {18,  6}, // #1476
  {19, 18}, // #1477
  {20, 13}, // #1478
  {22, 32}, // #1479
  {23, 32}, // #1480
  { 3,  9}, // #1481
  { 4,  9}, // #1482
  { 7, 11}, // #1483
  { 8,  8}, // #1484
  { 9,  1}, // #1485
  {11, 18}, // #1486
  {12, 20}, // #1487
  {13, 17}, // #1488
  {14, 31}, // #1489
  {15, 17}, // #1490
  {16, 10}, // #1491
  {18,  9}, // #1492
  {19, 26}, // #1493
  {20, 39}, // #1494
  {21, 11}, // #1495
  {22, 78}, // #1496
  {23, 100}, // #1497
  { 7,  1}, // #1498
  { 8,  5}, // #1499
  {12,  1}, // #1500
  {13,  5}, // #1501
  {15,  5}, // #1502
  {17,  2}, // #1503
  {18,  5}, // #1504
  {19,  5}, // #1505
  {20,  5}, // #1506
  {21,  2}, // #1507
  {22,  6}, // #1508
  {23,  9}, // #1509
  { 9,  1}, // #1510
  {14,  1}, // #1511
  {16,  1}, // #1512
  {17,  1}, // #1513
  {18,  1}, // #1514
  {20,  1}, // #1515
  {21,  1}, // #1516
  {22, 17}, // #1517
  {23, 18}, // #1518
  { 7,  1}, // #1519
  { 8,  3}, // #1520
  {12,  1}, // #1521
  {13,  3}, // #1522
  {15,  3}, // #1523
  {17,  2}, // #1524
  {18,  3}, // #1525
  {19,  3}, // #1526
  {20,  3}, // #1527
  {21,  2}, // #1528
  {22,  4}, // #1529
  {23,  7}, // #1530
  { 7,  1}, // #1531
  { 8,  3}, // #1532
  {12,  1}, // #1533
  {13,  3}, // #1534
  {15,  3}, // #1535
  {17,  4}, // #1536
  {18,  3}, // #1537
  {19,  3}, // #1538
  {20,  3}, // #1539
  {21,  4}, // #1540
  {22,  4}, // #1541
  {23,  9}, // #1542
  { 7,  1}, // #1543
  { 8,  4}, // #1544
  {12,  1}, // #1545
  {13,  4}, // #1546
  {15,  4}, // #1547
  {17,  8}, // #1548
  {18,  4}, // #1549
  {19,  4}, // #1550
  {20,  4}, // #1551
  {21,  8}, // #1552
  {22,  5}, // #1553
  {23, 14}, // #1554
  { 3,  2}, // #1555
  { 4,  2}, // #1556
  { 8,  2}, // #1557
  {11,  4}, // #1558
  {12,  2}, // #1559
  {13,  4}, // #1560
  {14,  2}, // #1561
  {15,  4}, // #1562
  {16,  2}, // #1563
  {17,  1}, // #1564
  {18,  2}, // #1565
  {19,  6}, // #1566
  {20,  4}, // #1567
  {21,  1}, // #1568
  {22,  7}, // #1569
  {23,  8}, // #1570
  { 9,  1}, // #1571
  {16,  1}, // #1572
  { 3,  1}, // #1573
  {11,  1}, // #1574
  {12,  2}, // #1575
  {14,  1}, // #1576
  { 8,  1}, // #1577
  { 9,  1}, // #1578
  {12,  1}, // #1579
  {14,  1}, // #1580
  {15,  1}, // #1581
  { 9,  1}, // #1582
  {10,  1}, // #1583
  {11,  1}, // #1584
  {12,  1}, // #1585
  { 6,  1}, // #1586
  { 8,  1}, // #1587
  { 9,  1}, // #1588
  {10,  1}, // #1589
  { 3,  2}, // #1590
  {11,  1}, // #1591
  {12,  2}, // #1592
  {14,  1}, // #1593
  { 3,  2}, // #1594
  {11,  1}, // #1595
  {12,  1}, // #1596
  { 5,  1}, // #1597
  { 7,  1}, // #1598
  { 9,  1}, // #1599
  {10,  1}, // #1600
  {11,  1}, // #1601
  {12,  1}, // #1602
  { 7,  1}, // #1603
  { 9,  1}, // #1604
  {11,  1}, // #1605
  {12,  1}, // #1606
  {19,  1}, // #1607
  { 7,  1}, // #1608
  { 9,  1}, // #1609
  {19,  1}, // #1610
  { 9,  1}, // #1611
  {10,  4}, // #1612
  {11,  1}, // #1613
  {12,  1}, // #1614
  { 3,  4}, // #1615
  {11,  1}, // #1616
  {12,  1}, // #1617
  { 1,  1}, // #1618
  { 3,  1}, // #1619
  { 5,  1}, // #1620
  { 7,  1}, // #1621
  { 9,  1}, // #1622
  {10,  1}, // #1623
  {11,  1}, // #1624
  {12,  1}, // #1625
  { 8,  1}, // #1626
  { 9,  1}, // #1627
  {11,  1}, // #1628
  {12,  1}, // #1629
  {15,  1}, // #1630
  { 8,  1}, // #1631
  { 9,  1}, // #1632
  {15,  1}, // #1633
  { 1,  1}, // #1634
  { 3,  1}, // #1635
  { 5,  1}, // #1636
  { 8,  1}, // #1637
  { 9,  1}, // #1638
  {10,  1}, // #1639
  {11,  1}, // #1640
  {12,  1}, // #1641
  {15,  1}, // #1642
  { 1,  1}, // #1643
  { 3,  1}, // #1644
  { 5,  1}, // #1645
  { 8,  1}, // #1646
  { 9,  1}, // #1647
  {10,  1}, // #1648
  {15,  1}, // #1649
  { 8,  1}, // #1650
  { 9,  1}, // #1651
  {11,  1}, // #1652
  {12,  1}, // #1653
  {15,  2}, // #1654
  { 8,  1}, // #1655
  { 9,  1}, // #1656
  {15,  2}, // #1657
  { 2,  1}, // #1658
  { 3,  1}, // #1659
  { 4, 17}, // #1660
  {11,  1}, // #1661
  {12,  1}, // #1662
  { 2,  1}, // #1663
  { 3,  1}, // #1664
  { 4, 25}, // #1665
  {11,  1}, // #1666
  {12,  1}, // #1667
  { 2,  1}, // #1668
  { 3,  1}, // #1669
  { 4, 41}, // #1670
  {11,  1}, // #1671
  {12,  1}, // #1672
  { 2,  1}, // #1673
  { 3,  1}, // #1674
  { 4, 12}, // #1675
  {11,  1}, // #1676
  {12,  1}, // #1677
  { 6, 19}, // #1678
  { 8,  1}, // #1679
  { 9,  1}, // #1680
  {10, 19}, // #1681
  {11,  1}, // #1682
  {12,  1}, // #1683
  { 5,  3}, // #1684
  { 6,  3}, // #1685
  { 8,  1}, // #1686
  { 9,  1}, // #1687
  {10,  6}, // #1688
  {11,  1}, // #1689
  {12,  1}, // #1690
  { 9,  1}, // #1691
  {11,  1}, // #1692
  {12,  1}, // #1693
  {16,  1}, // #1694
  { 2,  1}, // #1695
  { 3,  1}, // #1696
  {11,  1}, // #1697
  {12,  1}, // #1698
  {13,  1}, // #1699
  { 2,  1}, // #1700
  { 3,  1}, // #1701
  {13,  1}, // #1702
  { 2,  1}, // #1703
  { 3,  1}, // #1704
  {11,  1}, // #1705
  {12,  1}, // #1706
  {13,  4}, // #1707
  { 2,  1}, // #1708
  { 3,  1}, // #1709
  {13,  4}, // #1710
  { 9,  1}, // #1711
  {11,  1}, // #1712
  {12,  1}, // #1713
  {16,  4}, // #1714
  { 9,  1}, // #1715
  {16,  4}, // #1716
  { 7,  1}, // #1717
  { 9,  1}, // #1718
  {11,  1}, // #1719
  {12,  1}, // #1720
  {19,  2}, // #1721
  { 7,  1}, // #1722
  { 9,  1}, // #1723
  {19,  2}, // #1724
  { 6,  2}, // #1725
  { 8,  1}, // #1726
  { 9,  1}, // #1727
  {10,  2}, // #1728
  {11,  1}, // #1729
  {12,  1}, // #1730
  { 6,  1}, // #1731
  { 8,  1}, // #1732
  { 9,  1}, // #1733
  {10,  1}, // #1734
  {11,  1}, // #1735
  {12,  1}, // #1736
  { 2,  5}, // #1737
  { 3,  5}, // #1738
  {11,  1}, // #1739
  {12,  1}, // #1740
  {13,  1}, // #1741
  { 2,  5}, // #1742
  { 3,  5}, // #1743
  {13,  1}, // #1744
  { 2,  5}, // #1745
  { 3,  5}, // #1746
  {11,  1}, // #1747
  {12,  1}, // #1748
  {13,  4}, // #1749
  { 2,  5}, // #1750
  { 3,  5}, // #1751
  {13,  4}, // #1752
  { 1,  1}, // #1753
  { 3,  1}, // #1754
  { 5,  1}, // #1755
  { 8,  1}, // #1756
  { 9,  1}, // #1757
  {10,  1}, // #1758
  {11,  3}, // #1759
  {12,  5}, // #1760
  {14,  2}, // #1761
  {16, 10}, // #1762
  {18,  4}, // #1763
  { 1,  1}, // #1764
  { 3,  1}, // #1765
  { 5,  1}, // #1766
  { 8,  1}, // #1767
  { 9,  1}, // #1768
  {10,  1}, // #1769
  {11,  2}, // #1770
  {12,  4}, // #1771
  {14,  2}, // #1772
  {16, 10}, // #1773
  {18,  4}, // #1774
  { 1,  1}, // #1775
  { 3,  1}, // #1776
  { 5,  1}, // #1777
  { 8,  1}, // #1778
  { 9,  1}, // #1779
  {10,  1}, // #1780
  {11,  1}, // #1781
  {12,  1}, // #1782
  {16,  2}, // #1783
  {18,  2}, // #1784
  { 1,  1}, // #1785
  { 3,  1}, // #1786
  { 5,  1}, // #1787
  { 8,  1}, // #1788
  { 9,  1}, // #1789
  {10,  1}, // #1790
  {16,  2}, // #1791
  {18,  2}, // #1792
  { 7,  1}, // #1793
  { 9,  1}, // #1794
  {11,  1}, // #1795
  {12,  1}, // #1796
  {16,  1}, // #1797
  { 7,  1}, // #1798
  { 9,  1}, // #1799
  {16,  1}, // #1800
  { 7,  2}, // #1801
  { 9,  3}, // #1802
  {11,  1}, // #1803
  {12,  1}, // #1804
  {16,  1}, // #1805
  {19,  2}, // #1806
  { 7,  2}, // #1807
  { 9,  3}, // #1808
  {16,  1}, // #1809
  {19,  2}, // #1810
  { 3,  1}, // #1811
  {12,  1}, // #1812
  {14,  1}, // #1813
  { 3, 22}, // #1814
  {11,  1}, // #1815
  {12,  1}, // #1816
  { 6, 27}, // #1817
  { 8,  1}, // #1818
  { 9,  1}, // #1819
  {10, 27}, // #1820
  {11,  1}, // #1821
  {12,  1}, // #1822
  { 6, 21}, // #1823
  { 8,  1}, // #1824
  { 9,  1}, // #1825
  {10, 21}, // #1826
  {11,  1}, // #1827
  {12,  1}, // #1828
  { 6, 35}, // #1829
  { 8,  1}, // #1830
  { 9,  1}, // #1831
  {10, 35}, // #1832
  { 5,  2}, // #1833
  { 7,  2}, // #1834
  { 9,  2}, // #1835
  {10,  2}, // #1836
  {11,  2}, // #1837
  {12,  2}, // #1838
  { 9,  2}, // #1839
  {10,  6}, // #1840
  {11,  2}, // #1841
  {12,  2}, // #1842
  { 8,  2}, // #1843
  { 9,  2}, // #1844
  {11,  2}, // #1845
  {12,  2}, // #1846
  {15,  2}, // #1847
  { 8,  2}, // #1848
  { 9,  2}, // #1849
  {15,  2}, // #1850
  { 8,  2}, // #1851
  { 9,  2}, // #1852
  {10,  4}, // #1853
  {11,  2}, // #1854
  {12,  2}, // #1855
  {15,  2}, // #1856
  { 8,  2}, // #1857
  { 9,  2}, // #1858
  {10,  4}, // #1859
  {15,  2}, // #1860
  { 8,  2}, // #1861
  { 9,  2}, // #1862
  {10,  2}, // #1863
  {12,  1}, // #1864
  {14,  1}, // #1865
  {15,  2}, // #1866
  { 8,  2}, // #1867
  { 9,  2}, // #1868
  {10,  2}, // #1869
  {15,  2}, // #1870
  { 6, 38}, // #1871
  { 8,  2}, // #1872
  { 9,  2}, // #1873
  {10, 38}, // #1874
  {11,  2}, // #1875
  {12,  2}, // #1876
  { 5,  6}, // #1877
  { 6,  6}, // #1878
  { 8,  2}, // #1879
  { 9,  2}, // #1880
  {10, 12}, // #1881
  {11,  2}, // #1882
  {12,  2}, // #1883
  { 9,  2}, // #1884
  {10,  4}, // #1885
  {12,  2}, // #1886
  {14,  2}, // #1887
  { 9,  1}, // #1888
  {10,  4}, // #1889
  {12,  1}, // #1890
  {14,  1}, // #1891
  { 9,  2}, // #1892
  {16,  2}, // #1893
  { 8,  2}, // #1894
  { 9,  2}, // #1895
  {12,  2}, // #1896
  {14,  2}, // #1897
  {15,  2}, // #1898
  { 6,  4}, // #1899
  { 8,  2}, // #1900
  { 9,  2}, // #1901
  {10,  4}, // #1902
  {11,  2}, // #1903
  {12,  2}, // #1904
  { 6,  2}, // #1905
  { 8,  2}, // #1906
  { 9,  2}, // #1907
  {10,  2}, // #1908
  {11,  2}, // #1909
  {12,  2}, // #1910
  { 9,  2}, // #1911
  {12,  2}, // #1912
  {14,  2}, // #1913
  {16,  4}, // #1914
  { 9,  2}, // #1915
  {11,  2}, // #1916
  {12,  2}, // #1917
  {16,  4}, // #1918
  { 9,  1}, // #1919
  {12,  1}, // #1920
  {14,  1}, // #1921
  {16,  4}, // #1922
  { 9,  1}, // #1923
  {11,  1}, // #1924
  {12,  1}, // #1925
  {16,  2}, // #1926
  { 1,  1}, // #1927
  { 3,  1}, // #1928
  { 5,  2}, // #1929
  { 9,  2}, // #1930
  {10,  4}, // #1931
  {11,  2}, // #1932
  {12,  2}, // #1933
  { 6, 54}, // #1934
  { 8,  2}, // #1935
  { 9,  2}, // #1936
  {10, 54}, // #1937
  {11,  2}, // #1938
  {12,  2}, // #1939
  { 6, 42}, // #1940
  { 8,  2}, // #1941
  { 9,  2}, // #1942
  {10, 42}, // #1943
  {11,  2}, // #1944
  {12,  2}, // #1945
  { 9,  2}, // #1946
  {10,  4}, // #1947
  {11,  1}, // #1948
  {12,  1}, // #1949
  { 2,  1}, // #1950
  { 3,  1}, // #1951
  {12,  1}, // #1952
  {14,  1}, // #1953
  {13,  1}, // #1954
  {19,  1}, // #1955
  {20,  1}, // #1956
  {22,  1}, // #1957
  {23,  1}, // #1958
  { 3,  3}, // #1959
  { 8,  6}, // #1960
  {11,  3}, // #1961
  {12,  3}, // #1962
  {13,  9}, // #1963
  {14,  3}, // #1964
  {15,  6}, // #1965
  {17,  1}, // #1966
  {18,  6}, // #1967
  {19, 10}, // #1968
  {20,  9}, // #1969
  {21,  1}, // #1970
  {22, 10}, // #1971
  {23, 11}, // #1972
  { 3,  3}, // #1973
  { 8,  6}, // #1974
  {11,  3}, // #1975
  {12,  3}, // #1976
  {13,  9}, // #1977
  {14,  3}, // #1978
  {15,  6}, // #1979
  {18,  6}, // #1980
  {19, 11}, // #1981
  {20,  9}, // #1982
  {22, 11}, // #1983
  {23, 11}, // #1984
  {14,  2}, // #1985
  {17,  1}, // #1986
  {20,  2}, // #1987
  {21,  1}, // #1988
  {22,  2}, // #1989
  {23,  3}, // #1990
  {11,  2}, // #1991
  {17,  1}, // #1992
  {19,  2}, // #1993
  {21,  1}, // #1994
  {22,  2}, // #1995
  {23,  3}, // #1996
  { 2,  4}, // #1997
  { 3,  1}, // #1998
  {11,  1}, // #1999
  {12,  1}, // #2000
  {13,  1}, // #2001
  {14,  1}, // #2002
  {17,  1}, // #2003
  {19,  1}, // #2004
  {20,  1}, // #2005
  {21,  1}, // #2006
  {22,  1}, // #2007
  {23,  2}, // #2008
  { 2,  3}, // #2009
  { 3,  1}, // #2010
  {11,  1}, // #2011
  {12,  1}, // #2012
  {13,  1}, // #2013
  {14,  1}, // #2014
  {17,  1}, // #2015
  {19,  1}, // #2016
  {20,  1}, // #2017
  {21,  1}, // #2018
  {22,  1}, // #2019
  {23,  2}, // #2020
  { 8,  1}, // #2021
  {13,  1}, // #2022
  {15,  1}, // #2023
  {17,  1}, // #2024
  {18,  1}, // #2025
  {19,  3}, // #2026
  {20,  1}, // #2027
  {21,  1}, // #2028
  {22,  3}, // #2029
  {23,  4}, // #2030
  { 8,  1}, // #2031
  {13,  1}, // #2032
  {15,  1}, // #2033
  {18,  1}, // #2034
  {19,  3}, // #2035
  {20,  1}, // #2036
  {22,  3}, // #2037
  {23,  3}, // #2038
  { 8,  1}, // #2039
  {13,  1}, // #2040
  {15,  1}, // #2041
  {17,  1}, // #2042
  {18,  1}, // #2043
  {19,  4}, // #2044
  {20,  1}, // #2045
  {21,  1}, // #2046
  {22,  4}, // #2047
  {23,  5}, // #2048
  { 8,  1}, // #2049
  {13,  1}, // #2050
  {15,  1}, // #2051
  {18,  1}, // #2052
  {19,  4}, // #2053
  {20,  1}, // #2054
  {22,  4}, // #2055
  {23,  4}, // #2056
  {13,  9}, // #2057
  {19,  9}, // #2058
  {20,  9}, // #2059
  {22, 10}, // #2060
  {23, 10}, // #2061
  {13,  2}, // #2062
  {19,  2}, // #2063
  {20,  2}, // #2064
  {22,  2}, // #2065
  {23,  2}, // #2066
  { 8,  2}, // #2067
  {13,  2}, // #2068
  {15,  2}, // #2069
  {17,  1}, // #2070
  {18,  2}, // #2071
  {19,  3}, // #2072
  {20,  2}, // #2073
  {21,  1}, // #2074
  {22,  3}, // #2075
  {23,  4}, // #2076
  { 8,  2}, // #2077
  {13,  2}, // #2078
  {15,  2}, // #2079
  {18,  2}, // #2080
  {19,  3}, // #2081
  {20,  2}, // #2082
  {22,  3}, // #2083
  {23,  3}, // #2084
  {13,  1}, // #2085
  {17,  1}, // #2086
  {19,  1}, // #2087
  {20,  1}, // #2088
  {21,  1}, // #2089
  {22,  1}, // #2090
  {23,  2}, // #2091
  { 8,  2}, // #2092
  {13,  3}, // #2093
  {15,  2}, // #2094
  {17,  1}, // #2095
  {18,  2}, // #2096
  {19,  3}, // #2097
  {20,  3}, // #2098
  {21,  1}, // #2099
  {22,  3}, // #2100
  {23,  4}, // #2101
  { 8,  2}, // #2102
  {13,  3}, // #2103
  {15,  2}, // #2104
  {18,  2}, // #2105
  {19,  3}, // #2106
  {20,  3}, // #2107
  {22,  3}, // #2108
  {23,  3}, // #2109
  { 8,  1}, // #2110
  {11,  1}, // #2111
  {13,  1}, // #2112
  {15,  1}, // #2113
  {18,  1}, // #2114
  {19,  2}, // #2115
  {20,  1}, // #2116
  {22,  2}, // #2117
  {23,  2}, // #2118
  { 4,  1}, // #2119
  {11,  1}, // #2120
  {14,  2}, // #2121
  {15,  1}, // #2122
  {16,  1}, // #2123
  {17,  1}, // #2124
  {19,  1}, // #2125
  {20,  2}, // #2126
  {21,  2}, // #2127
  {22,  4}, // #2128
  {23,  6}, // #2129
  { 4,  1}, // #2130
  {11,  1}, // #2131
  {14,  2}, // #2132
  {15,  1}, // #2133
  {16,  1}, // #2134
  {19,  1}, // #2135
  {20,  2}, // #2136
  {22,  4}, // #2137
  {23,  4}, // #2138
  { 2,  6}, // #2139
  { 3,  1}, // #2140
  {11,  1}, // #2141
  {12,  1}, // #2142
  {13,  1}, // #2143
  {14,  1}, // #2144
  {17,  1}, // #2145
  {19,  1}, // #2146
  {20,  1}, // #2147
  {21,  1}, // #2148
  {22,  1}, // #2149
  {23,  2}, // #2150
  { 2,  6}, // #2151
  { 3,  1}, // #2152
  {11,  1}, // #2153
  {12,  1}, // #2154
  {13,  1}, // #2155
  {14,  1}, // #2156
  {19,  1}, // #2157
  {20,  1}, // #2158
  {22,  1}, // #2159
  {23,  1}, // #2160
  { 8,  1}, // #2161
  {11,  1}, // #2162
  {13,  1}, // #2163
  {15,  1}, // #2164
  {17,  1}, // #2165
  {18,  1}, // #2166
  {19,  2}, // #2167
  {20,  1}, // #2168
  {21,  1}, // #2169
  {22,  2}, // #2170
  {23,  3}, // #2171
  {13,  2}, // #2172
  {17,  1}, // #2173
  {19,  2}, // #2174
  {20,  2}, // #2175
  {21,  1}, // #2176
  {22,  2}, // #2177
  {23,  3}, // #2178
  { 7,  1}, // #2179
  { 8,  1}, // #2180
  {11,  1}, // #2181
  {12,  1}, // #2182
  {13,  1}, // #2183
  {15,  1}, // #2184
  {18,  1}, // #2185
  {19,  2}, // #2186
  {20,  1}, // #2187
  {21,  1}, // #2188
  {22,  2}, // #2189
  {23,  4}, // #2190
  { 7,  1}, // #2191
  { 8,  1}, // #2192
  {12,  1}, // #2193
  {13,  2}, // #2194
  {15,  1}, // #2195
  {18,  1}, // #2196
  {19,  2}, // #2197
  {20,  2}, // #2198
  {21,  1}, // #2199
  {22,  2}, // #2200
  {23,  4}, // #2201
  { 8,  1}, // #2202
  {13,  2}, // #2203
  {15,  1}, // #2204
  {18,  1}, // #2205
  {19,  2}, // #2206
  {20,  2}, // #2207
  {22,  2}, // #2208
  {23,  2}, // #2209
  { 2, 16}, // #2210
  { 3,  2}, // #2211
  { 8,  1}, // #2212
  {11,  2}, // #2213
  {12,  2}, // #2214
  {13,  3}, // #2215
  {14,  2}, // #2216
  {15,  1}, // #2217
  {17,  1}, // #2218
  {18,  1}, // #2219
  {19,  3}, // #2220
  {20,  3}, // #2221
  {21,  1}, // #2222
  {22,  3}, // #2223
  {23,  4}, // #2224
  { 2, 16}, // #2225
  { 3,  2}, // #2226
  { 8,  1}, // #2227
  {11,  2}, // #2228
  {12,  2}, // #2229
  {13,  3}, // #2230
  {14,  2}, // #2231
  {15,  1}, // #2232
  {18,  1}, // #2233
  {19,  3}, // #2234
  {20,  3}, // #2235
  {22,  3}, // #2236
  {23,  3}, // #2237
  { 2, 10}, // #2238
  { 3,  2}, // #2239
  { 8,  1}, // #2240
  {11,  2}, // #2241
  {12,  2}, // #2242
  {13,  3}, // #2243
  {14,  2}, // #2244
  {15,  1}, // #2245
  {17,  1}, // #2246
  {18,  1}, // #2247
  {19,  3}, // #2248
  {20,  3}, // #2249
  {21,  1}, // #2250
  {22,  3}, // #2251
  {23,  4}, // #2252
  { 2, 10}, // #2253
  { 3,  2}, // #2254
  { 8,  1}, // #2255
  {11,  2}, // #2256
  {12,  2}, // #2257
  {13,  3}, // #2258
  {14,  2}, // #2259
  {15,  1}, // #2260
  {18,  1}, // #2261
  {19,  3}, // #2262
  {20,  3}, // #2263
  {22,  3}, // #2264
  {23,  3}, // #2265
  { 3,  1}, // #2266
  {11,  1}, // #2267
  {12,  1}, // #2268
  {13,  1}, // #2269
  {14,  1}, // #2270
  {19,  1}, // #2271
  {20,  1}, // #2272
  {21,  1}, // #2273
  {22,  1}, // #2274
  {23,  2}, // #2275
  { 2, 12}, // #2276
  { 3,  1}, // #2277
  {11,  1}, // #2278
  {12,  1}, // #2279
  {13,  1}, // #2280
  {14,  1}, // #2281
  {17,  1}, // #2282
  {19,  1}, // #2283
  {20,  1}, // #2284
  {21,  1}, // #2285
  {22,  1}, // #2286
  {23,  2}, // #2287
  { 2, 12}, // #2288
  { 3,  1}, // #2289
  {11,  1}, // #2290
  {12,  1}, // #2291
  {13,  1}, // #2292
  {14,  1}, // #2293
  {19,  1}, // #2294
  {20,  1}, // #2295
  {22,  1}, // #2296
  {23,  1}, // #2297
  { 2, 24}, // #2298
  { 3,  2}, // #2299
  { 8,  1}, // #2300
  {11,  2}, // #2301
  {12,  2}, // #2302
  {13,  3}, // #2303
  {14,  2}, // #2304
  {15,  1}, // #2305
  {17,  1}, // #2306
  {18,  1}, // #2307
  {19,  3}, // #2308
  {20,  3}, // #2309
  {21,  1}, // #2310
  {22,  3}, // #2311
  {23,  4}, // #2312
  { 2, 24}, // #2313
  { 3,  2}, // #2314
  { 8,  1}, // #2315
  {11,  2}, // #2316
  {12,  2}, // #2317
  {13,  3}, // #2318
  {14,  2}, // #2319
  {15,  1}, // #2320
  {18,  1}, // #2321
  {19,  3}, // #2322
  {20,  3}, // #2323
  {22,  3}, // #2324
  {23,  3}, // #2325
  { 2, 12}, // #2326
  { 3,  2}, // #2327
  { 8,  1}, // #2328
  {11,  2}, // #2329
  {12,  2}, // #2330
  {13,  3}, // #2331
  {14,  2}, // #2332
  {15,  1}, // #2333
  {17,  1}, // #2334
  {18,  1}, // #2335
  {19,  3}, // #2336
  {20,  3}, // #2337
  {21,  1}, // #2338
  {22,  3}, // #2339
  {23,  4}, // #2340
  { 2, 12}, // #2341
  { 3,  2}, // #2342
  { 8,  1}, // #2343
  {11,  2}, // #2344
  {12,  2}, // #2345
  {13,  3}, // #2346
  {14,  2}, // #2347
  {15,  1}, // #2348
  {18,  1}, // #2349
  {19,  3}, // #2350
  {20,  3}, // #2351
  {22,  3}, // #2352
  {23,  3}, // #2353
  { 4,  2}, // #2354
  {11,  2}, // #2355
  {14,  4}, // #2356
  {15,  3}, // #2357
  {16,  2}, // #2358
  {17,  1}, // #2359
  {19,  3}, // #2360
  {20,  4}, // #2361
  {21,  2}, // #2362
  {22,  9}, // #2363
  {23, 11}, // #2364
  { 8,  1}, // #2365
  {13,  1}, // #2366
  {15,  1}, // #2367
  {18,  1}, // #2368
  {19,  2}, // #2369
  {20,  1}, // #2370
  {22,  2}, // #2371
  {23,  2}, // #2372
  { 3,  2}, // #2373
  { 4,  1}, // #2374
  { 8,  2}, // #2375
  { 9,  4}, // #2376
  {11,  3}, // #2377
  {12,  2}, // #2378
  {13,  6}, // #2379
  {14,  6}, // #2380
  {15,  3}, // #2381
  {16,  5}, // #2382
  {18,  6}, // #2383
  {19,  7}, // #2384
  {20, 10}, // #2385
  {22, 15}, // #2386
  {23, 15}, // #2387
  { 7,  1}, // #2388
  { 9,  1}, // #2389
  {12,  1}, // #2390
  {14,  2}, // #2391
  {16,  1}, // #2392
  {17,  1}, // #2393
  {18,  1}, // #2394
  {20,  2}, // #2395
  {21,  2}, // #2396
  {22,  5}, // #2397
  {23,  8}, // #2398
  { 3,  1}, // #2399
  {11,  1}, // #2400
  {12,  1}, // #2401
  {13,  2}, // #2402
  {14,  1}, // #2403
  {17,  1}, // #2404
  {19,  2}, // #2405
  {20,  2}, // #2406
  {21,  1}, // #2407
  {22,  2}, // #2408
  {23,  3}, // #2409
  { 3,  1}, // #2410
  { 8,  1}, // #2411
  {11,  1}, // #2412
  {12,  1}, // #2413
  {13,  2}, // #2414
  {14,  1}, // #2415
  {15,  1}, // #2416
  {18,  1}, // #2417
  {19,  3}, // #2418
  {20,  2}, // #2419
  {22,  3}, // #2420
  {23,  3}, // #2421
  { 3,  1}, // #2422
  { 8,  1}, // #2423
  {11,  1}, // #2424
  {12,  1}, // #2425
  {13,  2}, // #2426
  {14,  1}, // #2427
  {15,  1}, // #2428
  {17,  1}, // #2429
  {18,  1}, // #2430
  {19,  3}, // #2431
  {20,  2}, // #2432
  {21,  1}, // #2433
  {22,  3}, // #2434
  {23,  4}, // #2435
  { 9,  1}, // #2436
  {14,  1}, // #2437
  {16,  1}, // #2438
  {18,  1}, // #2439
  {20,  1}, // #2440
  {22,  4}, // #2441
  {23,  4}, // #2442
  { 9,  1}, // #2443
  {14,  4}, // #2444
  {15,  1}, // #2445
  {16,  1}, // #2446
  {18,  1}, // #2447
  {19,  1}, // #2448
  {20,  4}, // #2449
  {22,  7}, // #2450
  {23,  7}, // #2451
  { 8,  1}, // #2452
  { 9,  2}, // #2453
  {13,  1}, // #2454
  {14,  2}, // #2455
  {15,  1}, // #2456
  {16,  2}, // #2457
  {18,  3}, // #2458
  {19,  1}, // #2459
  {20,  3}, // #2460
  {22, 10}, // #2461
  {23, 10}, // #2462
  { 8,  6}, // #2463
  {13,  9}, // #2464
  {15,  6}, // #2465
  {18,  6}, // #2466
  {19,  9}, // #2467
  {20,  9}, // #2468
  {22, 15}, // #2469
  {23, 15}, // #2470
  {14,  3}, // #2471
  {20,  3}, // #2472
  {22,  3}, // #2473
  {23,  3}, // #2474
  { 7,  1}, // #2475
  {12,  1}, // #2476
  {14,  2}, // #2477
  {20,  2}, // #2478
  {21,  1}, // #2479
  {22,  2}, // #2480
  {23,  4}, // #2481
  { 7,  1}, // #2482
  {12,  1}, // #2483
  {14,  3}, // #2484
  {17,  1}, // #2485
  {20,  3}, // #2486
  {21,  2}, // #2487
  {22,  3}, // #2488
  {23,  6}, // #2489
  {14,  3}, // #2490
  {17,  1}, // #2491
  {20,  3}, // #2492
  {21,  2}, // #2493
  {22,  3}, // #2494
  {23,  5}, // #2495
  { 4,  1}, // #2496
  { 9,  1}, // #2497
  {11,  1}, // #2498
  {14,  1}, // #2499
  {15,  1}, // #2500
  {16,  2}, // #2501
  {18,  1}, // #2502
  {19,  1}, // #2503
  {20,  1}, // #2504
  {22,  4}, // #2505
  {23,  4}, // #2506
  { 4,  1}, // #2507
  {11,  1}, // #2508
  {14,  5}, // #2509
  {15,  2}, // #2510
  {16,  1}, // #2511
  {17,  1}, // #2512
  {19,  2}, // #2513
  {20,  5}, // #2514
  {21,  2}, // #2515
  {22,  8}, // #2516
  {23, 10}, // #2517
  { 4,  2}, // #2518
  {11,  2}, // #2519
  {14,  3}, // #2520
  {15,  2}, // #2521
  {16,  2}, // #2522
  {19,  2}, // #2523
  {20,  3}, // #2524
  {22,  7}, // #2525
  {23,  7}, // #2526
  { 4,  1}, // #2527
  {11,  1}, // #2528
  {14,  5}, // #2529
  {15,  2}, // #2530
  {16,  1}, // #2531
  {19,  2}, // #2532
  {20,  5}, // #2533
  {22,  9}, // #2534
  {23,  9}, // #2535
  { 4,  2}, // #2536
  {11,  2}, // #2537
  {14,  4}, // #2538
  {15,  3}, // #2539
  {16,  2}, // #2540
  {19,  3}, // #2541
  {20,  4}, // #2542
  {22, 10}, // #2543
  {23, 10}, // #2544
  { 4,  1}, // #2545
  { 9,  8}, // #2546
  {11,  1}, // #2547
  {14,  8}, // #2548
  {15,  1}, // #2549
  {16,  9}, // #2550
  {17,  1}, // #2551
  {18,  8}, // #2552
  {19,  1}, // #2553
  {20,  8}, // #2554
  {21,  1}, // #2555
  {22, 30}, // #2556
  {23, 31}, // #2557
  { 7,  1}, // #2558
  { 9, 10}, // #2559
  {12,  1}, // #2560
  {14, 10}, // #2561
  {16, 10}, // #2562
  {17,  1}, // #2563
  {18, 10}, // #2564
  {20, 10}, // #2565
  {21,  2}, // #2566
  {22, 36}, // #2567
  {23, 39}, // #2568
  { 7,  1}, // #2569
  { 9, 11}, // #2570
  {12,  1}, // #2571
  {14, 11}, // #2572
  {16, 11}, // #2573
  {17,  1}, // #2574
  {18, 11}, // #2575
  {20, 11}, // #2576
  {21,  2}, // #2577
  {22, 37}, // #2578
  {23, 40}, // #2579
  { 4,  1}, // #2580
  { 7,  1}, // #2581
  { 8,  2}, // #2582
  { 9,  3}, // #2583
  {11,  1}, // #2584
  {12,  1}, // #2585
  {13,  2}, // #2586
  {14,  3}, // #2587
  {15,  4}, // #2588
  {16,  4}, // #2589
  {17,  1}, // #2590
  {18,  5}, // #2591
  {19,  4}, // #2592
  {20,  5}, // #2593
  {21,  2}, // #2594
  {22, 15}, // #2595
  {23, 18}, // #2596
  { 3,  2}, // #2597
  {11,  2}, // #2598
  {12,  2}, // #2599
  {13,  7}, // #2600
  {14, 12}, // #2601
  {17,  8}, // #2602
  {19,  7}, // #2603
  {20, 17}, // #2604
  {21,  8}, // #2605
  {22, 56}, // #2606
  {23, 64}, // #2607
  { 3,  7}, // #2608
  { 4,  2}, // #2609
  { 8,  8}, // #2610
  { 9,  3}, // #2611
  {11,  9}, // #2612
  {12,  7}, // #2613
  {13, 16}, // #2614
  {14, 10}, // #2615
  {15, 10}, // #2616
  {16,  5}, // #2617
  {18, 11}, // #2618
  {19, 18}, // #2619
  {20, 19}, // #2620
  {22, 32}, // #2621
  {23, 32}, // #2622
  { 3,  4}, // #2623
  { 4,  2}, // #2624
  { 8,  4}, // #2625
  { 9,  8}, // #2626
  {11,  6}, // #2627
  {12,  4}, // #2628
  {13,  8}, // #2629
  {14, 26}, // #2630
  {15,  6}, // #2631
  {16, 10}, // #2632
  {18, 12}, // #2633
  {19, 10}, // #2634
  {20, 30}, // #2635
  {22, 66}, // #2636
  {23, 66}, // #2637
  { 3,  9}, // #2638
  { 4,  1}, // #2639
  { 7, 11}, // #2640
  { 8, 16}, // #2641
  { 9,  1}, // #2642
  {11, 10}, // #2643
  {12, 20}, // #2644
  {13, 25}, // #2645
  {14, 31}, // #2646
  {15, 17}, // #2647
  {16,  2}, // #2648
  {18, 17}, // #2649
  {19, 26}, // #2650
  {20, 47}, // #2651
  {21, 11}, // #2652
  {22, 78}, // #2653
  {23, 100}, // #2654
  { 3,  1}, // #2655
  { 8,  1}, // #2656
  {11,  1}, // #2657
  {12,  1}, // #2658
  {13,  2}, // #2659
  {14,  1}, // #2660
  {15,  1}, // #2661
  {17,  2}, // #2662
  {18,  1}, // #2663
  {19,  3}, // #2664
  {20,  2}, // #2665
  {21,  2}, // #2666
  {22,  3}, // #2667
  {23,  5}, // #2668
  { 3,  2}, // #2669
  { 8,  4}, // #2670
  {11,  2}, // #2671
  {12,  2}, // #2672
  {13,  6}, // #2673
  {14,  2}, // #2674
  {15,  4}, // #2675
  {17,  1}, // #2676
  {18,  4}, // #2677
  {19,  6}, // #2678
  {20,  6}, // #2679
  {21,  1}, // #2680
  {22,  7}, // #2681
  {23,  8}, // #2682
  { 8,  2}, // #2683
  {11,  1}, // #2684
  {13,  2}, // #2685
  {15,  2}, // #2686
  {18,  2}, // #2687
  {19,  3}, // #2688
  {20,  2}, // #2689
  {22,  3}, // #2690
  {23,  3}, // #2691
  { 8,  2}, // #2692
  {11,  1}, // #2693
  {13,  2}, // #2694
  {15,  2}, // #2695
  {17,  1}, // #2696
  {18,  2}, // #2697
  {19,  3}, // #2698
  {20,  2}, // #2699
  {21,  1}, // #2700
  {22,  3}, // #2701
  {23,  4}, // #2702
  { 7,  2}, // #2703
  {12,  2}, // #2704
  {15,  1}, // #2705
  {19,  1}, // #2706
  {21,  2}, // #2707
  {22,  1}, // #2708
  {23,  5}, // #2709
  { 7,  1}, // #2710
  {12,  1}, // #2711
  {19,  1}, // #2712
  {21,  1}, // #2713
  {22,  1}, // #2714
  {23,  3}, // #2715
  { 7,  1}, // #2716
  { 8,  2}, // #2717
  {12,  1}, // #2718
  {13,  2}, // #2719
  {15,  2}, // #2720
  {18,  2}, // #2721
  {19,  2}, // #2722
  {20,  2}, // #2723
  {21,  1}, // #2724
  {22,  2}, // #2725
  {23,  4}, // #2726
  { 8,  1}, // #2727
  {13,  1}, // #2728
  {15,  1}, // #2729
  {17,  1}, // #2730
  {18,  1}, // #2731
  {19,  1}, // #2732
  {20,  1}, // #2733
  {21,  1}, // #2734
  {22,  2}, // #2735
  {23,  3}, // #2736
  { 3,  1}, // #2737
  { 7,  2}, // #2738
  {11,  1}, // #2739
  {12,  3}, // #2740
  {13,  1}, // #2741
  {14,  1}, // #2742
  {19,  1}, // #2743
  {20,  1}, // #2744
  {21,  2}, // #2745
  {22,  3}, // #2746
  {23,  7}, // #2747
  { 3,  1}, // #2748
  { 7,  4}, // #2749
  {11,  1}, // #2750
  {12,  5}, // #2751
  {13,  1}, // #2752
  {14,  1}, // #2753
  {19,  1}, // #2754
  {20,  1}, // #2755
  {21,  4}, // #2756
  {22,  3}, // #2757
  {23, 11}, // #2758
  { 3,  1}, // #2759
  { 7,  8}, // #2760
  {11,  1}, // #2761
  {12,  9}, // #2762
  {13,  1}, // #2763
  {14,  1}, // #2764
  {19,  1}, // #2765
  {20,  1}, // #2766
  {21,  8}, // #2767
  {22,  3}, // #2768
  {23, 19}, // #2769
  { 3,  1}, // #2770
  { 7, 16}, // #2771
  { 8,  1}, // #2772
  {11,  1}, // #2773
  {12, 17}, // #2774
  {13,  2}, // #2775
  {14,  1}, // #2776
  {15,  1}, // #2777
  {18,  1}, // #2778
  {19,  2}, // #2779
  {20,  2}, // #2780
  {21, 16}, // #2781
  {22,  4}, // #2782
  {23, 36}, // #2783
  { 3,  1}, // #2784
  { 7,  2}, // #2785
  { 8,  1}, // #2786
  {11,  1}, // #2787
  {12,  3}, // #2788
  {13,  2}, // #2789
  {14,  1}, // #2790
  {15,  1}, // #2791
  {18,  1}, // #2792
  {19,  2}, // #2793
  {20,  2}, // #2794
  {21,  2}, // #2795
  {22,  4}, // #2796
  {23,  8}, // #2797
  { 3,  1}, // #2798
  { 7,  4}, // #2799
  { 8,  1}, // #2800
  {11,  1}, // #2801
  {12,  5}, // #2802
  {13,  2}, // #2803
  {14,  1}, // #2804
  {15,  1}, // #2805
  {18,  1}, // #2806
  {19,  2}, // #2807
  {20,  2}, // #2808
  {21,  4}, // #2809
  {22,  4}, // #2810
  {23, 12}, // #2811
  { 3,  1}, // #2812
  { 7,  8}, // #2813
  { 8,  1}, // #2814
  {11,  1}, // #2815
  {12,  9}, // #2816
  {13,  2}, // #2817
  {14,  1}, // #2818
  {15,  1}, // #2819
  {18,  1}, // #2820
  {19,  2}, // #2821
  {20,  2}, // #2822
  {21,  8}, // #2823
  {22,  4}, // #2824
  {23, 20}, // #2825
  {11,  3}, // #2826
  {19,  3}, // #2827
  {22,  3}, // #2828
  {23,  3}, // #2829
  {13,  3}, // #2830
  {19,  3}, // #2831
  {20,  3}, // #2832
  {22,  3}, // #2833
  {23,  3}, // #2834
  { 3,  1}, // #2835
  {11,  1}, // #2836
  {12,  1}, // #2837
  {13,  1}, // #2838
  {14,  1}, // #2839
  {17,  1}, // #2840
  {19,  2}, // #2841
  {20,  1}, // #2842
  {21,  1}, // #2843
  {22,  2}, // #2844
  {23,  3}, // #2845
  { 4,  1}, // #2846
  { 8,  2}, // #2847
  {11,  3}, // #2848
  {13,  2}, // #2849
  {15,  3}, // #2850
  {16,  1}, // #2851
  {17,  1}, // #2852
  {18,  2}, // #2853
  {19,  7}, // #2854
  {20,  2}, // #2855
  {21,  1}, // #2856
  {22,  7}, // #2857
  {23,  8}, // #2858
  {17,  1}, // #2859
  {19,  3}, // #2860
  {21,  1}, // #2861
  {22,  3}, // #2862
  {23,  4}, // #2863
  { 3,  1}, // #2864
  {11,  1}, // #2865
  {12,  1}, // #2866
  {13,  1}, // #2867
  {14,  1}, // #2868
  {17,  2}, // #2869
  {19,  2}, // #2870
  {20,  1}, // #2871
  {21,  2}, // #2872
  {22,  3}, // #2873
  {23,  5}, // #2874
  { 8,  5}, // #2875
  {11,  5}, // #2876
  {13,  5}, // #2877
  {15,  5}, // #2878
  {18,  5}, // #2879
  {19, 14}, // #2880
  {20,  5}, // #2881
  {22, 14}, // #2882
  {23, 14}, // #2883
  { 8,  5}, // #2884
  {11,  5}, // #2885
  {13,  5}, // #2886
  {15,  5}, // #2887
  {17,  1}, // #2888
  {18,  5}, // #2889
  {19, 14}, // #2890
  {20,  5}, // #2891
  {21,  1}, // #2892
  {22, 14}, // #2893
  {23, 15}, // #2894
  { 8,  9}, // #2895
  {11,  7}, // #2896
  {13,  9}, // #2897
  {15,  9}, // #2898
  {18,  9}, // #2899
  {19, 21}, // #2900
  {20,  9}, // #2901
  {22, 21}, // #2902
  {23, 21}, // #2903
  { 8,  9}, // #2904
  {11,  7}, // #2905
  {13,  9}, // #2906
  {15,  9}, // #2907
  {17,  1}, // #2908
  {18,  9}, // #2909
  {19, 21}, // #2910
  {20,  9}, // #2911
  {21,  1}, // #2912
  {22, 21}, // #2913
  {23, 22}, // #2914
  { 8, 17}, // #2915
  {11, 11}, // #2916
  {13, 17}, // #2917
  {15, 17}, // #2918
  {18, 17}, // #2919
  {19, 35}, // #2920
  {20, 17}, // #2921
  {22, 35}, // #2922
  {23, 35}, // #2923
  { 8, 17}, // #2924
  {11, 11}, // #2925
  {13, 17}, // #2926
  {15, 17}, // #2927
  {17,  1}, // #2928
  {18, 17}, // #2929
  {19, 35}, // #2930
  {20, 17}, // #2931
  {21,  1}, // #2932
  {22, 35}, // #2933
  {23, 36}, // #2934
  { 4,  1}, // #2935
  { 7,  1}, // #2936
  { 9,  1}, // #2937
  {11,  1}, // #2938
  {12,  1}, // #2939
  { 5,  1}, // #2940
  {10,  2}, // #2941
  {11,  1}, // #2942
  {12,  4}, // #2943
  { 6,  1}, // #2944
  { 8,  1}, // #2945
  { 9,  1}, // #2946
  {10,  1}, // #2947
  {11,  1}, // #2948
  {12,  2}, // #2949
  { 6,  1}, // #2950
  { 8,  1}, // #2951
  { 9,  1}, // #2952
  {11,  1}, // #2953
  {12,  1}, // #2954
  { 5,  1}, // #2955
  {10,  1}, // #2956
  {12,  2}, // #2957
  {10,  1}, // #2958
  {12,  1}, // #2959
  { 5,  1}, // #2960
  {10,  2}, // #2961
  {11,  3}, // #2962
  {12,  6}, // #2963
  { 8,  1}, // #2964
  {10,  1}, // #2965
  {11,  2}, // #2966
  {12,  3}, // #2967
  { 4,  1}, // #2968
  { 7,  1}, // #2969
  { 9,  1}, // #2970
  {10,  1}, // #2971
  {11,  1}, // #2972
  {12,  2}, // #2973
  { 6,  1}, // #2974
  { 8,  1}, // #2975
  { 9,  1}, // #2976
  {10,  1}, // #2977
  {11,  2}, // #2978
  {12,  3}, // #2979
  { 6,  1}, // #2980
  { 8,  1}, // #2981
  { 9,  1}, // #2982
  {11,  2}, // #2983
  {12,  2}, // #2984
  { 6,  2}, // #2985
  { 8,  2}, // #2986
  { 9,  2}, // #2987
  {10,  1}, // #2988
  {11,  2}, // #2989
  {12,  3}, // #2990
  { 6,  2}, // #2991
  { 8,  2}, // #2992
  { 9,  2}, // #2993
  {11,  2}, // #2994
  {12,  2}, // #2995
  {10,  1}, // #2996
  {11, 10}, // #2997
  {12, 11}, // #2998
  {11, 11}, // #2999
  {12, 11}, // #3000
  { 4,  1}, // #3001
  { 7,  1}, // #3002
  { 8,  1}, // #3003
  { 9,  1}, // #3004
  {10,  1}, // #3005
  {11,  2}, // #3006
  {12,  3}, // #3007
  { 4,  1}, // #3008
  { 7,  1}, // #3009
  { 8,  1}, // #3010
  { 9,  1}, // #3011
  {11,  2}, // #3012
  {12,  2}, // #3013
  { 8,  1}, // #3014
  {10,  1}, // #3015
  {11,  1}, // #3016
  {12,  2}, // #3017
  { 8,  2}, // #3018
  {10,  1}, // #3019
  {11,  2}, // #3020
  {12,  3}, // #3021
  { 8,  2}, // #3022
  {11,  2}, // #3023
  {12,  2}, // #3024
  { 8,  2}, // #3025
  {10,  1}, // #3026
  {11,  3}, // #3027
  {12,  4}, // #3028
  { 8,  2}, // #3029
  {11,  3}, // #3030
  {12,  3}, // #3031
  { 6,  2}, // #3032
  { 8,  3}, // #3033
  { 9,  2}, // #3034
  {11,  3}, // #3035
  {12,  3}, // #3036
  { 4,  1}, // #3037
  { 6,  1}, // #3038
  { 7,  1}, // #3039
  { 8,  1}, // #3040
  { 9,  2}, // #3041
  {10,  1}, // #3042
  {11,  2}, // #3043
  {12,  3}, // #3044
  { 4,  1}, // #3045
  { 6,  1}, // #3046
  { 7,  1}, // #3047
  { 8,  1}, // #3048
  { 9,  2}, // #3049
  {11,  2}, // #3050
  {12,  2}, // #3051
  { 3,  1}, // #3052
  { 7,  1}, // #3053
  { 8,  1}, // #3054
  {10,  1}, // #3055
  {11,  1}, // #3056
  {12,  2}, // #3057
  { 3,  1}, // #3058
  { 6,  1}, // #3059
  { 7,  1}, // #3060
  { 8,  2}, // #3061
  { 9,  1}, // #3062
  {11,  2}, // #3063
  {12,  2}, // #3064
  { 3,  1}, // #3065
  { 4,  1}, // #3066
  { 7,  2}, // #3067
  { 8,  1}, // #3068
  { 9,  1}, // #3069
  {10,  1}, // #3070
  {11,  2}, // #3071
  {12,  3}, // #3072
  { 3,  1}, // #3073
  { 4,  1}, // #3074
  { 7,  2}, // #3075
  { 8,  1}, // #3076
  { 9,  1}, // #3077
  {11,  2}, // #3078
  {12,  2}, // #3079
  { 4,  1}, // #3080
  { 6,  2}, // #3081
  { 7,  1}, // #3082
  { 8,  2}, // #3083
  { 9,  3}, // #3084
  {11,  3}, // #3085
  {12,  3}, // #3086
  { 3,  1}, // #3087
  { 7,  1}, // #3088
  { 8,  1}, // #3089
  {11,  1}, // #3090
  {12,  1}, // #3091
  { 1, 10}, // #3092
  { 3,  1}, // #3093
  { 7,  1}, // #3094
  { 8,  1}, // #3095
  {10,  1}, // #3096
  {11,  1}, // #3097
  {12,  2}, // #3098
  { 1, 10}, // #3099
  { 3,  1}, // #3100
  { 7,  1}, // #3101
  { 8,  1}, // #3102
  {11,  1}, // #3103
  {12,  1}, // #3104
  { 2, 22}, // #3105
  { 3,  1}, // #3106
  { 7,  1}, // #3107
  { 8,  1}, // #3108
  {10,  1}, // #3109
  {11,  1}, // #3110
  {12,  2}, // #3111
  { 2, 22}, // #3112
  { 3,  1}, // #3113
  { 7,  1}, // #3114
  { 8,  1}, // #3115
  {11,  1}, // #3116
  {12,  1}, // #3117
  { 2, 14}, // #3118
  { 3,  1}, // #3119
  { 7,  1}, // #3120
  { 8,  1}, // #3121
  {10,  1}, // #3122
  {11,  1}, // #3123
  {12,  2}, // #3124
  { 2, 14}, // #3125
  { 3,  1}, // #3126
  { 7,  1}, // #3127
  { 8,  1}, // #3128
  {11,  1}, // #3129
  {12,  1}, // #3130
  { 3,  1}, // #3131
  { 4,  1}, // #3132
  { 6,  1}, // #3133
  { 7,  2}, // #3134
  { 8,  2}, // #3135
  { 9,  2}, // #3136
  {10,  1}, // #3137
  {11,  3}, // #3138
  {12,  4}, // #3139
  { 3,  1}, // #3140
  { 4,  1}, // #3141
  { 6,  1}, // #3142
  { 7,  2}, // #3143
  { 8,  2}, // #3144
  { 9,  2}, // #3145
  {11,  3}, // #3146
  {12,  3}, // #3147
  { 3,  1}, // #3148
  { 4,  2}, // #3149
  { 6,  1}, // #3150
  { 7,  3}, // #3151
  { 8,  2}, // #3152
  { 9,  3}, // #3153
  {10,  1}, // #3154
  {11,  4}, // #3155
  {12,  5}, // #3156
  { 3,  1}, // #3157
  { 4,  2}, // #3158
  { 6,  1}, // #3159
  { 7,  3}, // #3160
  { 8,  2}, // #3161
  { 9,  3}, // #3162
  {11,  4}, // #3163
  {12,  4}, // #3164
  { 5,  1}, // #3165
  { 9,  1}, // #3166
  {10,  1}, // #3167
  {11,  1}, // #3168
  {12,  3}, // #3169
  { 3,  1}, // #3170
  { 7,  1}, // #3171
  { 8,  1}, // #3172
  { 9,  1}, // #3173
  {11,  2}, // #3174
  {12,  2}, // #3175
  {11, 31}, // #3176
  {12, 31}, // #3177
  { 4,  1}, // #3178
  { 6,  2}, // #3179
  { 7,  1}, // #3180
  { 8,  2}, // #3181
  { 9,  3}, // #3182
  {10,  1}, // #3183
  {11,  3}, // #3184
  {12,  4}, // #3185
  { 3,  1}, // #3186
  { 5,  1}, // #3187
  { 6,  1}, // #3188
  { 7,  1}, // #3189
  { 8,  2}, // #3190
  { 9,  1}, // #3191
  {10,  1}, // #3192
  {11,  2}, // #3193
  {12,  4}, // #3194
  { 6,  1}, // #3195
  { 8,  1}, // #3196
  { 9,  2}, // #3197
  {11,  2}, // #3198
  {12,  2}, // #3199
  { 3,  1}, // #3200
  { 7,  1}, // #3201
  { 8,  1}, // #3202
  { 9,  2}, // #3203
  {10,  1}, // #3204
  {11,  3}, // #3205
  {12,  4}, // #3206
  { 3,  1}, // #3207
  { 7,  1}, // #3208
  { 8,  1}, // #3209
  { 9,  2}, // #3210
  {11,  3}, // #3211
  {12,  3}, // #3212
  {10,  1}, // #3213
  {11, 17}, // #3214
  {12, 18}, // #3215
  {11, 18}, // #3216
  {12, 18}, // #3217
  {10,  1}, // #3218
  {11,  7}, // #3219
  {12,  8}, // #3220
  {11,  8}, // #3221
  {12,  8}, // #3222
  { 3,  3}, // #3223
  { 7,  3}, // #3224
  { 8,  3}, // #3225
  {10,  1}, // #3226
  {11,  3}, // #3227
  {12,  4}, // #3228
  { 3,  3}, // #3229
  { 7,  3}, // #3230
  { 8,  3}, // #3231
  {11,  3}, // #3232
  {12,  3}, // #3233
  { 3,  1}, // #3234
  { 7,  1}, // #3235
  { 8,  1}, // #3236
  { 9,  1}, // #3237
  {10,  1}, // #3238
  {11,  2}, // #3239
  {12,  3}, // #3240
  { 3,  1}, // #3241
  { 6,  1}, // #3242
  { 7,  1}, // #3243
  { 8,  2}, // #3244
  { 9,  1}, // #3245
  {10,  1}, // #3246
  {11,  2}, // #3247
  {12,  3}, // #3248
  { 5,  1}, // #3249
  { 8,  1}, // #3250
  {10,  2}, // #3251
  {11,  1}, // #3252
  {12,  4}, // #3253
  { 5,  1}, // #3254
  { 8,  1}, // #3255
  {10,  1}, // #3256
  {11,  1}, // #3257
  {12,  3}, // #3258
  { 5,  1}, // #3259
  { 8,  3}, // #3260
  {10,  2}, // #3261
  {11,  4}, // #3262
  {12,  7}, // #3263
  { 5,  1}, // #3264
  { 8,  1}, // #3265
  {10,  2}, // #3266
  {11,  2}, // #3267
  {12,  5}, // #3268
  { 2, 21}, // #3269
  { 3,  1}, // #3270
  { 7,  1}, // #3271
  { 8,  1}, // #3272
  {10,  1}, // #3273
  {11,  1}, // #3274
  {12,  2}, // #3275
  { 2, 21}, // #3276
  { 3,  1}, // #3277
  { 7,  1}, // #3278
  { 8,  1}, // #3279
  {11,  1}, // #3280
  {12,  1}, // #3281
  { 2, 24}, // #3282
  { 3,  1}, // #3283
  { 7,  1}, // #3284
  { 8,  1}, // #3285
  {11,  1}, // #3286
  {12,  1}, // #3287
  { 7,  1}, // #3288
  {10,  1}, // #3289
  {11,  1}, // #3290
  {12,  2}, // #3291
  { 4,  1}, // #3292
  { 5,  1}, // #3293
  { 7,  1}, // #3294
  { 9,  1}, // #3295
  {10,  1}, // #3296
  {11,  1}, // #3297
  {12,  3}, // #3298
  { 2, 44}, // #3299
  { 3,  2}, // #3300
  { 7,  2}, // #3301
  { 8,  3}, // #3302
  {10,  1}, // #3303
  {11,  3}, // #3304
  {12,  4}, // #3305
  { 2, 44}, // #3306
  { 3,  2}, // #3307
  { 7,  2}, // #3308
  { 8,  3}, // #3309
  {11,  3}, // #3310
  {12,  3}, // #3311
  { 2, 28}, // #3312
  { 3,  2}, // #3313
  { 7,  2}, // #3314
  { 8,  3}, // #3315
  {10,  1}, // #3316
  {11,  3}, // #3317
  {12,  4}, // #3318
  { 2, 28}, // #3319
  { 3,  2}, // #3320
  { 7,  2}, // #3321
  { 8,  3}, // #3322
  {11,  3}, // #3323
  {12,  3}, // #3324
  { 5,  1}, // #3325
  { 7,  1}, // #3326
  {10,  1}, // #3327
  {11,  1}, // #3328
  {12,  3}, // #3329
  { 4,  1}, // #3330
  { 7,  1}, // #3331
  { 8,  1}, // #3332
  { 9,  1}, // #3333
  {10,  1}, // #3334
  {11,  4}, // #3335
  {12,  5}, // #3336
  { 4,  1}, // #3337
  { 7,  1}, // #3338
  { 8,  1}, // #3339
  { 9,  1}, // #3340
  {11,  3}, // #3341
  {12,  3}, // #3342
  { 5,  1}, // #3343
  {10,  2}, // #3344
  {12,  3}, // #3345
  { 5,  1}, // #3346
  {10,  2}, // #3347
  {11,  2}, // #3348
  {12,  5}, // #3349
  { 6,  1}, // #3350
  { 7,  1}, // #3351
  { 8,  1}, // #3352
  { 9,  1}, // #3353
  {10,  1}, // #3354
  {11,  2}, // #3355
  {12,  3}, // #3356
  { 5,  1}, // #3357
  { 6,  2}, // #3358
  { 8,  2}, // #3359
  { 9,  2}, // #3360
  {10,  2}, // #3361
  {11,  2}, // #3362
  {12,  5}, // #3363
  { 4,  1}, // #3364
  { 5,  1}, // #3365
  { 7,  1}, // #3366
  { 9,  1}, // #3367
  {10,  2}, // #3368
  {11,  1}, // #3369
  {12,  4}, // #3370
  { 5,  1}, // #3371
  { 6,  1}, // #3372
  { 8,  1}, // #3373
  { 9,  1}, // #3374
  {10,  2}, // #3375
  {11,  1}, // #3376
  {12,  4}, // #3377
  { 5,  1}, // #3378
  { 6,  1}, // #3379
  { 8,  2}, // #3380
  { 9,  1}, // #3381
  {10,  2}, // #3382
  {11,  3}, // #3383
  {12,  6}, // #3384
  { 8,  1}, // #3385
  {11,  4}, // #3386
  {12,  4}, // #3387
  { 6,  1}, // #3388
  { 8,  1}, // #3389
  { 9,  1}, // #3390
  {11,  4}, // #3391
  {12,  4}, // #3392
  { 5,  1}, // #3393
  { 6,  2}, // #3394
  { 7,  1}, // #3395
  { 8,  2}, // #3396
  { 9,  2}, // #3397
  {10,  1}, // #3398
  {11,  3}, // #3399
  {12,  5}, // #3400
  { 3,  1}, // #3401
  { 7,  1}, // #3402
  { 8,  1}, // #3403
  {11,  2}, // #3404
  {12,  2}, // #3405
  { 4,  1}, // #3406
  { 7,  1}, // #3407
  { 9,  1}, // #3408
  {11,  2}, // #3409
  {12,  2}, // #3410
  { 4,  1}, // #3411
  { 7,  1}, // #3412
  { 8,  1}, // #3413
  { 9,  1}, // #3414
  {11,  4}, // #3415
  {12,  4}, // #3416
  { 5,  1}, // #3417
  { 6,  1}, // #3418
  { 8,  1}, // #3419
  { 9,  1}, // #3420
  {10,  1}, // #3421
  {11,  1}, // #3422
  {12,  3}, // #3423
  { 5,  1}, // #3424
  {10,  1}, // #3425
  {11,  1}, // #3426
  {12,  3}, // #3427
  { 5,  1}, // #3428
  { 8,  2}, // #3429
  {10,  1}, // #3430
  {11,  2}, // #3431
  {12,  4}, // #3432
  { 3,  1}, // #3433
  { 5,  1}, // #3434
  { 7,  1}, // #3435
  { 8,  1}, // #3436
  { 9,  1}, // #3437
  {10,  1}, // #3438
  {11,  2}, // #3439
  {12,  4}, // #3440
  { 5,  1}, // #3441
  { 6,  1}, // #3442
  { 7,  1}, // #3443
  { 8,  1}, // #3444
  { 9,  1}, // #3445
  {10,  1}, // #3446
  {11,  2}, // #3447
  {12,  4}, // #3448
  { 3,  1}, // #3449
  { 5,  1}, // #3450
  { 7,  1}, // #3451
  { 8,  1}, // #3452
  {10,  2}, // #3453
  {11,  1}, // #3454
  {12,  4}, // #3455
  { 4,  1}, // #3456
  { 6,  2}, // #3457
  { 7,  1}, // #3458
  { 8,  2}, // #3459
  { 9,  3}, // #3460
  {11,  4}, // #3461
  {12,  4}, // #3462
  {10,  2}, // #3463
  {11,  3}, // #3464
  {12,  5}, // #3465
  { 5,  1}, // #3466
  { 8,  2}, // #3467
  {10,  2}, // #3468
  {11,  2}, // #3469
  {12,  5}, // #3470
  { 5,  1}, // #3471
  { 6,  1}, // #3472
  { 7,  1}, // #3473
  { 8,  1}, // #3474
  { 9,  1}, // #3475
  {10,  2}, // #3476
  {11,  2}, // #3477
  {12,  5}, // #3478
  { 4,  1}, // #3479
  { 7,  1}, // #3480
  { 8,  1}, // #3481
  { 9,  1}, // #3482
  {10,  1}, // #3483
  {11,  3}, // #3484
  {12,  4}, // #3485
  { 4,  1}, // #3486
  { 7,  1}, // #3487
  { 9,  1}, // #3488
  {10,  1}, // #3489
  {11,  2}, // #3490
  {12,  3}, // #3491
  { 5,  1}, // #3492
  { 8,  3}, // #3493
  {10,  2}, // #3494
  {11,  3}, // #3495
  {12,  6}, // #3496
  { 5,  1}, // #3497
  { 8,  2}, // #3498
  {10,  2}, // #3499
  {11,  3}, // #3500
  {12,  6}, // #3501
  { 4,  2}, // #3502
  { 7,  2}, // #3503
  { 9,  2}, // #3504
  {10,  1}, // #3505
  {11,  2}, // #3506
  {12,  3}, // #3507
  {14,  1}, // #3508
  {17,  1}, // #3509
  {20,  1}, // #3510
  {21,  1}, // #3511
  {22,  3}, // #3512
  {23,  4}, // #3513
  { 2, 17}, // #3514
  { 3,  1}, // #3515
  {11,  1}, // #3516
  {12,  1}, // #3517
  {13,  1}, // #3518
  {14,  1}, // #3519
  {19,  1}, // #3520
  {20,  1}, // #3521
  {22,  1}, // #3522
  {23,  1}, // #3523
  { 4,  1}, // #3524
  { 7,  1}, // #3525
  { 8,  1}, // #3526
  {11,  1}, // #3527
  {12,  1}, // #3528
  {13,  1}, // #3529
  {15,  2}, // #3530
  {16,  1}, // #3531
  {18,  1}, // #3532
  {19,  2}, // #3533
  {20,  1}, // #3534
  {21,  1}, // #3535
  {22,  2}, // #3536
  {23,  4}, // #3537
  { 2, 28}, // #3538
  { 3,  2}, // #3539
  {11,  2}, // #3540
  {12,  2}, // #3541
  {13,  2}, // #3542
  {14,  2}, // #3543
  {15,  1}, // #3544
  {17,  1}, // #3545
  {19,  3}, // #3546
  {20,  2}, // #3547
  {21,  1}, // #3548
  {22,  3}, // #3549
  {23,  4}, // #3550
  { 2, 28}, // #3551
  { 3,  2}, // #3552
  {11,  2}, // #3553
  {12,  2}, // #3554
  {13,  2}, // #3555
  {14,  2}, // #3556
  {15,  1}, // #3557
  {19,  3}, // #3558
  {20,  2}, // #3559
  {22,  3}, // #3560
  {23,  3}, // #3561
  { 2, 14}, // #3562
  { 3,  2}, // #3563
  {11,  2}, // #3564
  {12,  2}, // #3565
  {13,  2}, // #3566
  {14,  2}, // #3567
  {15,  1}, // #3568
  {17,  1}, // #3569
  {19,  3}, // #3570
  {20,  2}, // #3571
  {21,  1}, // #3572
  {22,  3}, // #3573
  {23,  4}, // #3574
  { 2, 14}, // #3575
  { 3,  2}, // #3576
  {11,  2}, // #3577
  {12,  2}, // #3578
  {13,  2}, // #3579
  {14,  2}, // #3580
  {15,  1}, // #3581
  {19,  3}, // #3582
  {20,  2}, // #3583
  {22,  3}, // #3584
  {23,  3}, // #3585
  { 4,  2}, // #3586
  {11,  2}, // #3587
  {15,  2}, // #3588
  {16,  2}, // #3589
  {19,  2}, // #3590
  {22,  2}, // #3591
  {23,  2}, // #3592
  { 3,  2}, // #3593
  { 4,  1}, // #3594
  { 8,  2}, // #3595
  { 9,  4}, // #3596
  {11,  5}, // #3597
  {12,  2}, // #3598
  {13,  4}, // #3599
  {14,  6}, // #3600
  {15,  3}, // #3601
  {16,  5}, // #3602
  {18,  6}, // #3603
  {19,  7}, // #3604
  {20,  8}, // #3605
  {22, 15}, // #3606
  {23, 15}, // #3607
  { 7,  1}, // #3608
  {12,  1}, // #3609
  {17,  2}, // #3610
  {21,  2}, // #3611
  {22,  2}, // #3612
  {23,  5}, // #3613
  {17,  1}, // #3614
  {21,  1}, // #3615
  {22, 14}, // #3616
  {23, 15}, // #3617
  { 4,  1}, // #3618
  { 9,  1}, // #3619
  {11,  1}, // #3620
  {14,  1}, // #3621
  {15,  1}, // #3622
  {16,  2}, // #3623
  {18,  1}, // #3624
  {19,  1}, // #3625
  {20,  1}, // #3626
  {22,  2}, // #3627
  {23,  2}, // #3628
  {17,  2}, // #3629
  {21,  2}, // #3630
  {22,  3}, // #3631
  {23,  5}, // #3632
  { 4,  1}, // #3633
  { 9,  1}, // #3634
  {11,  1}, // #3635
  {14,  1}, // #3636
  {15,  1}, // #3637
  {16,  2}, // #3638
  {17,  1}, // #3639
  {18,  1}, // #3640
  {19,  1}, // #3641
  {20,  1}, // #3642
  {21,  1}, // #3643
  {22,  2}, // #3644
  {23,  3}, // #3645
  { 3,  1}, // #3646
  { 4,  1}, // #3647
  { 8,  1}, // #3648
  { 9,  1}, // #3649
  {11,  2}, // #3650
  {12,  1}, // #3651
  {13,  2}, // #3652
  {14,  2}, // #3653
  {15,  2}, // #3654
  {16,  2}, // #3655
  {18,  2}, // #3656
  {19,  3}, // #3657
  {20,  3}, // #3658
  {22,  4}, // #3659
  {23,  4}, // #3660
  { 9,  2}, // #3661
  {14,  2}, // #3662
  {16,  2}, // #3663
  {17,  1}, // #3664
  {18,  2}, // #3665
  {19,  1}, // #3666
  {20,  2}, // #3667
  {21,  1}, // #3668
  {22,  3}, // #3669
  {23,  4}, // #3670
  {17,  1}, // #3671
  {19, 16}, // #3672
  {21,  1}, // #3673
  {22, 16}, // #3674
  {23, 17}, // #3675
  { 3,  2}, // #3676
  { 8,  2}, // #3677
  {11,  2}, // #3678
  {12,  2}, // #3679
  {13,  4}, // #3680
  {14,  4}, // #3681
  {15,  3}, // #3682
  {17,  2}, // #3683
  {18,  2}, // #3684
  {19,  8}, // #3685
  {20,  6}, // #3686
  {21,  2}, // #3687
  {22, 10}, // #3688
  {23, 12}, // #3689
  { 3,  5}, // #3690
  { 8,  3}, // #3691
  {11,  5}, // #3692
  {12,  5}, // #3693
  {13,  8}, // #3694
  {14,  9}, // #3695
  {15,  4}, // #3696
  {17,  4}, // #3697
  {18,  3}, // #3698
  {19, 14}, // #3699
  {20, 12}, // #3700
  {21,  4}, // #3701
  {22, 18}, // #3702
  {23, 22}, // #3703
  { 3,  3}, // #3704
  { 8,  3}, // #3705
  {11,  3}, // #3706
  {12,  3}, // #3707
  {13,  6}, // #3708
  {14,  7}, // #3709
  {15,  4}, // #3710
  {17,  4}, // #3711
  {18,  3}, // #3712
  {19, 12}, // #3713
  {20, 10}, // #3714
  {21,  4}, // #3715
  {22, 16}, // #3716
  {23, 20}, // #3717
  { 3,  5}, // #3718
  { 8,  3}, // #3719
  {11,  5}, // #3720
  {12,  5}, // #3721
  {13,  8}, // #3722
  {14, 13}, // #3723
  {15,  4}, // #3724
  {17,  8}, // #3725
  {18,  3}, // #3726
  {19, 18}, // #3727
  {20, 16}, // #3728
  {21,  8}, // #3729
  {22, 26}, // #3730
  {23, 34}, // #3731
  { 3,  3}, // #3732
  { 8,  3}, // #3733
  {11,  3}, // #3734
  {12,  3}, // #3735
  {13,  6}, // #3736
  {14,  5}, // #3737
  {15,  4}, // #3738
  {17,  2}, // #3739
  {18,  3}, // #3740
  {19, 10}, // #3741
  {20,  8}, // #3742
  {21,  2}, // #3743
  {22, 12}, // #3744
  {23, 14}, // #3745
  { 3,  3}, // #3746
  { 8,  3}, // #3747
  {11,  3}, // #3748
  {12,  3}, // #3749
  {13,  6}, // #3750
  {14,  5}, // #3751
  {15,  4}, // #3752
  {17,  2}, // #3753
  {18,  3}, // #3754
  {19, 11}, // #3755
  {20,  8}, // #3756
  {21,  2}, // #3757
  {22, 13}, // #3758
  {23, 15}, // #3759
  { 5,  1}, // #3760
  { 6,  1}, // #3761
  {10,  1}, // #3762
  { 4,  5}, // #3763
  { 6,  5}, // #3764
  {10,  1}, // #3765
  { 4,  1}, // #3766
  { 6,  1}, // #3767
  {10,  1}, // #3768
  { 9, 20}, // #3769
  {10,  1}, // #3770
  { 1, 25}, // #3771
  { 9,  1}, // #3772
  {10,  1}, // #3773
  { 2, 69}, // #3774
  { 4,  1}, // #3775
  { 6,  1}, // #3776
  {10,  1}, // #3777
  { 2, 39}, // #3778
  { 4,  1}, // #3779
  { 6,  1}, // #3780
  {10,  1}, // #3781
  { 2, 17}, // #3782
  { 4,  1}, // #3783
  { 6,  1}, // #3784
  {10,  1}, // #3785
  { 2, 32}, // #3786
  { 4,  1}, // #3787
  { 6,  1}, // #3788
  {10,  1}, // #3789
  { 4,  1}, // #3790
  { 6,  1}, // #3791
  {10,  2}, // #3792
  { 6, 10}, // #3793
  { 6,  2}, // #3794
  {10,  1}, // #3795
  { 3,  2}, // #3796
  { 4,  1}, // #3797
  { 6,  1}, // #3798
  {10,  1}, // #3799
  { 4,  1}, // #3800
  { 6,  1}, // #3801
  { 8,  1}, // #3802
  { 9,  1}, // #3803
  {10,  1}, // #3804
  { 4, 10}, // #3805
  { 6, 10}, // #3806
  {10,  1}, // #3807
  { 4, 21}, // #3808
  { 6, 21}, // #3809
  {10,  1}, // #3810
  { 4, 17}, // #3811
  { 6, 17}, // #3812
  {10,  1}, // #3813
  { 4, 13}, // #3814
  { 6, 13}, // #3815
  {10,  1}, // #3816
  { 2, 70}, // #3817
  { 4,  1}, // #3818
  { 6,  1}, // #3819
  {10,  1}, // #3820
  { 2, 40}, // #3821
  { 4,  1}, // #3822
  { 6,  1}, // #3823
  {10,  1}, // #3824
  { 2, 35}, // #3825
  { 4,  1}, // #3826
  { 6,  1}, // #3827
  {10,  1}, // #3828
  { 2, 20}, // #3829
  { 4,  1}, // #3830
  { 6,  1}, // #3831
  {10,  1}, // #3832
  { 8,  1}, // #3833
  {11,  2}, // #3834
  {13,  1}, // #3835
  {15,  1}, // #3836
  {17,  1}, // #3837
  {18,  1}, // #3838
  {19,  3}, // #3839
  {20,  1}, // #3840
  {21,  1}, // #3841
  {22,  3}, // #3842
  {23,  4}, // #3843
  { 8,  1}, // #3844
  {11,  2}, // #3845
  {13,  1}, // #3846
  {15,  1}, // #3847
  {18,  1}, // #3848
  {19,  3}, // #3849
  {20,  1}, // #3850
  {22,  3}, // #3851
  {23,  3}, // #3852
  { 8,  1}, // #3853
  {11,  3}, // #3854
  {13,  1}, // #3855
  {15,  1}, // #3856
  {17,  1}, // #3857
  {18,  1}, // #3858
  {19,  4}, // #3859
  {20,  1}, // #3860
  {21,  1}, // #3861
  {22,  4}, // #3862
  {23,  5}, // #3863
  { 8,  1}, // #3864
  {11,  3}, // #3865
  {13,  1}, // #3866
  {15,  1}, // #3867
  {18,  1}, // #3868
  {19,  4}, // #3869
  {20,  1}, // #3870
  {22,  4}, // #3871
  {23,  4}, // #3872
  { 3,  1}, // #3873
  { 8,  1}, // #3874
  {11,  2}, // #3875
  {12,  1}, // #3876
  {13,  2}, // #3877
  {14,  1}, // #3878
  {15,  1}, // #3879
  {18,  1}, // #3880
  {19,  3}, // #3881
  {20,  2}, // #3882
  {22,  3}, // #3883
  {23,  3}, // #3884
  { 3,  1}, // #3885
  { 8,  1}, // #3886
  {11,  2}, // #3887
  {12,  1}, // #3888
  {13,  2}, // #3889
  {14,  1}, // #3890
  {15,  1}, // #3891
  {17,  1}, // #3892
  {18,  1}, // #3893
  {19,  3}, // #3894
  {20,  2}, // #3895
  {21,  1}, // #3896
  {22,  3}, // #3897
  {23,  4}, // #3898
  { 3,  1}, // #3899
  {11,  2}, // #3900
  {12,  1}, // #3901
  {13,  1}, // #3902
  {14,  1}, // #3903
  {19,  2}, // #3904
  {20,  1}, // #3905
  {22,  2}, // #3906
  {23,  2}, // #3907
  { 7,  1}, // #3908
  { 9, 11}, // #3909
  {12,  1}, // #3910
  {14, 11}, // #3911
  {16, 11}, // #3912
  {17,  1}, // #3913
  {18, 11}, // #3914
  {20, 11}, // #3915
  {21,  2}, // #3916
  {22, 41}, // #3917
  {23, 44}, // #3918
  { 1,  2}, // #3919
  { 4,  1}, // #3920
  { 1,  1}, // #3921
  { 4,  1}, // #3922
  {11,  1}, // #3923
  {15,  1}, // #3924
  {18,  1}, // #3925
  {20,  1}, // #3926
  {21,  1}, // #3927
  {22,  1}, // #3928
  { 1,  1}, // #3929
  {11,  1}, // #3930
  {12,  1}, // #3931
  {16,  1}, // #3932
  {17,  1}, // #3933
  {18,  1}, // #3934
  {22,  1}, // #3935
  { 1,  1}, // #3936
  {11,  1}, // #3937
  {16,  1}, // #3938
  {22,  1}, // #3939
  { 4,  4}, // #3940
  { 1,  1}, // #3941
  {11,  1}, // #3942
  {15,  1}, // #3943
  {18,  1}, // #3944
  {20,  1}, // #3945
  {21,  1}, // #3946
  {22,  1}, // #3947
  { 1,  1}, // #3948
  {11,  2}, // #3949
  {18,  2}, // #3950
  {22,  2}, // #3951
  { 1,  1}, // #3952
  {11,  2}, // #3953
  {15,  2}, // #3954
  {18,  2}, // #3955
  {20,  2}, // #3956
  {21,  2}, // #3957
  {22,  2}, // #3958
  { 1,  1}, // #3959
  { 4,  1}, // #3960
  { 7,  1}, // #3961
  {10, 17}, // #3962
  { 1,  1}, // #3963
  { 4,  1}, // #3964
  { 7,  1}, // #3965
  {10, 25}, // #3966
  { 1,  1}, // #3967
  { 4,  1}, // #3968
  { 7,  1}, // #3969
  {10, 41}, // #3970
  { 1,  1}, // #3971
  { 4,  1}, // #3972
  { 7,  1}, // #3973
  {10, 15}, // #3974
  { 1,  1}, // #3975
  {11,  5}, // #3976
  {14,  3}, // #3977
  {17,  3}, // #3978
  {19,  5}, // #3979
  {21,  3}, // #3980
  {11,  3}, // #3981
  {14,  2}, // #3982
  {17,  2}, // #3983
  {19,  3}, // #3984
  {21,  2}, // #3985
  { 1,  1}, // #3986
  { 4,  1}, // #3987
  { 6,  1}, // #3988
  {23,  1}, // #3989
  { 1,  1}, // #3990
  {11,  1}, // #3991
  {19,  1}, // #3992
  { 1,  1}, // #3993
  {11,  1}, // #3994
  {20,  1}, // #3995
  {22,  1}, // #3996
  {11,  1}, // #3997
  {14,  1}, // #3998
  {17,  1}, // #3999
  {19,  1}, // #4000
  {21,  1}, // #4001
  { 1,  1}, // #4002
  {11,  1}, // #4003
  {14,  1}, // #4004
  {17,  1}, // #4005
  {19,  1}, // #4006
  {21,  1}, // #4007
  { 1,  1}, // #4008
  { 4,  2}, // #4009
  { 6,  2}, // #4010
  {23,  2}, // #4011
  { 1,  1}, // #4012
  {11,  2}, // #4013
  {19,  2}, // #4014
  { 1,  1}, // #4015
  {11,  2}, // #4016
  {17,  2}, // #4017
  { 1,  1}, // #4018
  {11, 20}, // #4019
  {15, 20}, // #4020
  {18, 20}, // #4021
  {20, 20}, // #4022
  {21, 20}, // #4023
  {22, 20}, // #4024
  { 1,  1}, // #4025
  {11,  1}, // #4026
  {18,  1}, // #4027
  {22,  1}, // #4028
  { 1,  1}, // #4029
  {11, 22}, // #4030
  {15, 22}, // #4031
  {18, 22}, // #4032
  {20, 22}, // #4033
  {21, 22}, // #4034
  {22, 22}, // #4035
  {11, 15}, // #4036
  {15, 15}, // #4037
  {18, 15}, // #4038
  {20, 15}, // #4039
  {21, 15}, // #4040
  {22, 15}, // #4041
  { 1,  1}, // #4042
  {11, 19}, // #4043
  {15, 19}, // #4044
  {18, 19}, // #4045
  {20, 19}, // #4046
  {21, 19}, // #4047
  {22, 19}, // #4048
  {11, 12}, // #4049
  {15, 12}, // #4050
  {18, 12}, // #4051
  {20, 12}, // #4052
  {21, 12}, // #4053
  {22, 12}, // #4054
  { 1,  1}, // #4055
  {11,  2}, // #4056
  {16,  2}, // #4057
  {22,  2}, // #4058
  { 1,  1}, // #4059
  {11,  3}, // #4060
  {16,  3}, // #4061
  {22,  3}, // #4062
  {11,  2}, // #4063
  {14,  2}, // #4064
  {17,  2}, // #4065
  {19,  2}, // #4066
  {21,  2}, // #4067
  { 1,  1}, // #4068
  {11,  2}, // #4069
  {12,  2}, // #4070
  {16,  2}, // #4071
  {17,  2}, // #4072
  {18,  2}, // #4073
  {22,  2}, // #4074
  { 1,  1}, // #4075
  {11, 40}, // #4076
  {15, 40}, // #4077
  {18, 40}, // #4078
  {20, 40}, // #4079
  {21, 40}, // #4080
  {22, 40}, // #4081
  { 1,  1}, // #4082
  {11, 28}, // #4083
  {15, 28}, // #4084
  {18, 28}, // #4085
  {20, 28}, // #4086
  {21, 28}, // #4087
  {22, 28}, // #4088
  {11,  1}, // #4089
  {21,  1}, // #4090
  { 1,  1}, // #4091
  {11,  1}, // #4092
  {21,  1}, // #4093
  {11,  2}, // #4094
  {15,  1}, // #4095
  {18,  1}, // #4096
  {19,  1}, // #4097
  {20,  1}, // #4098
  {21,  1}, // #4099
  {22,  1}, // #4100
  { 1,  1}, // #4101
  {11,  2}, // #4102
  {15,  1}, // #4103
  {18,  1}, // #4104
  {19,  1}, // #4105
  {20,  1}, // #4106
  {21,  1}, // #4107
  {22,  1}, // #4108
  { 1,  1}, // #4109
  {11,  1}, // #4110
  {17,  1}, // #4111
  { 1,  5}, // #4112
  {11,  3}, // #4113
  {14,  2}, // #4114
  {17,  2}, // #4115
  {19,  3}, // #4116
  {21,  2}, // #4117
  { 1,  1}, // #4118
  {11,  2}, // #4119
  {22,  2}, // #4120
  { 1,  1}, // #4121
  {11,  2}, // #4122
  {14,  1}, // #4123
  {15,  1}, // #4124
  {17,  1}, // #4125
  {18,  1}, // #4126
  {19,  1}, // #4127
  {20,  1}, // #4128
  {21,  2}, // #4129
  {22,  1}, // #4130
  { 1,  1}, // #4131
  {11,  3}, // #4132
  {18,  3}, // #4133
  {22,  3}, // #4134
  {11,  2}, // #4135
  {15,  1}, // #4136
  {18,  1}, // #4137
  {20,  1}, // #4138
  {21,  1}, // #4139
  {22,  2}, // #4140
  { 1,  1}, // #4141
  {11,  2}, // #4142
  {13,  2}, // #4143
  {16,  2}, // #4144
  {19,  2}, // #4145
  {20,  2}, // #4146
  {22,  2}, // #4147
  { 4,  1}, // #4148
  { 6,  1}, // #4149
  {23,  2}, // #4150
  { 1,  1}, // #4151
  { 4,  1}, // #4152
  { 9,  1}, // #4153
  {11,  1}, // #4154
  {22,  1}, // #4155
  { 1,  1}, // #4156
  {11,  1}, // #4157
  {22,  1}, // #4158
  {11,  2}, // #4159
  {14,  1}, // #4160
  {17,  1}, // #4161
  {19,  2}, // #4162
  {21,  1}, // #4163
  {11,  2}, // #4164
  {13,  1}, // #4165
  {16,  1}, // #4166
  {18,  1}, // #4167
  {19,  1}, // #4168
  {20,  1}, // #4169
  {22,  2}, // #4170
  {11,  1}, // #4171
  {13,  1}, // #4172
  {16,  1}, // #4173
  {19,  1}, // #4174
  {20,  1}, // #4175
  {22,  1}, // #4176
  { 1,  1}, // #4177
  {11,  1}, // #4178
  {13,  1}, // #4179
  {16,  1}, // #4180
  {19,  1}, // #4181
  {20,  1}, // #4182
  {22,  1} // #4183
}; // X86WriteProcResTable

// {Cycles, WriteResourceID}
extern const llvm::MCWriteLatencyEntry X86WriteLatencyTable[] = {
  { 0,  0}, // Invalid
  { 1,  0}, // #1 WriteZero_WriteVecALU_WriteJumpLd_WriteALU_WriteMove_WriteFStoreX_WriteFLoadX_WriteFSign_WriteADC_AtomWrite0_1_WriteADCLd_WriteALULd_WriteFLogicLd_WriteBSWAP32_WriteBSWAP64_WriteBitTest_WriteLoad_WriteCMOV2Ld_WriteCMOVLd_WriteNop_WriteVecExtractSt_WriteVecALUX_WriteVecALUXLd_WriteFShuffleLd_WriteStore_WriteVecLogicX_WriteShuffle_WriteVecLoadX_WriteFLD0_WriteLEA_WriteFence_WriteVecStoreX_WriteVecMoveFromGpr_WriteVecMoveX_WriteVecStoreNT_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteVarShuffleLd_WriteVecShiftImm_WriteFMoveX_WriteVecLoadNT_WriteStoreNT_WriteFStoreNTX_WriteShuffleXLd_WriteVecLogicXLd_WriteRMW_WriteVecShiftImmX_WriteVecTestLd_WriteShiftLd_WriteSETCC_WriteVecMaskedStore_WriteVecShiftImmXLd_WriteFTestLd_AtomWrite1_1_AtomWrite0_1_1_AtomWrite01_1_WriteFStoreY_WriteFBlend_WriteBZHI_WriteFLDC_WriteLAHFSAHF_WriteFLD1_WriteVecMoveToGpr_WriteMMXMOVMSK_WriteBlend_WriteVarShuffleX_WriteShuffleY_WriteFLogicY_WriteFBlendY_WriteVecALUY_WriteFMoveY_WriteFShuffleY_WriteVecStoreY_WriteVecMoveY_WriteVecStoreNTY_WriteFStoreNTY_WriteVecLogicY_WriteBlendY_WriteFVarShuffleY_WriteVecShiftImmY_WriteVarShuffleY_WriteFTestY_BWWriteResGroup10_BWWriteResGroup2_BWWriteResGroup5_BWWriteResGroup6_BWWriteResGroup3_BWWriteResGroup4_BWWriteResGroup7_BWWriteResGroup8_BWWriteResGroup9_WriteBEXTR_WriteLZCNT_WritePHAdd_WritePHAddX_WritePOPCNT_WriteVecShiftX_WriteSETCCStore_WriteSTMXCSR_WriteFShuffle256_WriteShuffleZ_WriteFLogicZ_WriteVecALUZ_WriteFShuffleZ_WriteVecLogicZ_WriteFVarShuffleZ_WriteVecShiftImmZ_WriteVarVecShift_WriteVarVecShiftY_WriteVarVecShiftZ_WriteVarShuffleZ_SKXWriteResGroup9_SKXWriteResGroup10_SKXWriteResGroup11_SKXWriteResGroup3_SKXWriteResGroup6_SKXWriteResGroup7_SKXWriteResGroup4_SKXWriteResGroup8_WriteCvtSS2SD_WriteShuffle256_WriteVarShuffle256_WriteFVarShuffle256_SBWriteResGroup2_SBWriteResGroup1_SBWriteResGroup4_SBWriteResGroup5_HWWrite2P1_HWWriteP01_HWWrite2P01_HWWrite2P0156_P23_HWWriteResGroup10_HWWriteINTO_HWWritePushA_HWWriteBTmr_HWWritePopA_HWWriteP1_HWWriteBOUND_HWWriteBTRSCmr_HWWriteResGroup3_HWWriteResGroup6_HWWriteResGroup7_HWWrite3P01_HWWriteP0156_P23_HWWriteRETI_HWWriteRDPMC_HWWriteRDRAND_HWWriteFNSAVE_HWWriteFRSTOR_HWWriteResGroup2_HWWriteResGroup4_HWWriteResGroup5_HWWriteResGroup8_HWWriteResGroup9_WriteFVarBlend_WriteVarBlend_WriteSHDrrcl_WriteSHDrri_WriteFMaskedStoreY_WritePHAddY_WriteVecMaskedStoreY_WriteVecShiftY_WriteVecTestY_SKLWriteResGroup9_SKLWriteResGroup10_SKLWriteResGroup11_SKLWriteResGroup3_SKLWriteResGroup6_SKLWriteResGroup7_SKLWriteResGroup4_SKLWriteResGroup8_WriteFMOVMSK_WriteVecMOVMSK_WriteFVarBlendY_WriteVarBlendY_ZnWriteFPU3Lat1_ZnWriteFLDr_ZnWriteFPU0Lat1_ZnWriteFXCH_ZnWritePShift_ZnWriteJCXZ_ZnWriteLD_F80m_ZnWriteLOOPE_ZnWriteCMPXCHG8B_ZnWriteRET_ZnWritePCMPGTQr_ZnWriteFPU01Y_ZnWriteFPU12m_ZnWriteXCHG_ZnWriteCALLr_ZnWriteFPU12Y_ZnWriteFPU013_ZnWriteSHA1MSG2r_ZnWriteSHA1NEXTEr
  { 1,  0}, // #2 WriteALULd_WriteRMW
  { 1,  0}, // #3 WriteRMW
  {100,  0}, // #4 WriteSystem_WriteMicrocoded_ZnWriteMicrocoded_WriteFShuffle256_WriteFVarShuffle256
  { 7,  0}, // #5 WriteFAdd64XLd_WriteFCmp64XLd_WriteCvtI2PD_WriteCvtI2PSLd_WriteCvtPD2I_WriteCvtPD2PS_WriteCvtPS2ILd_WriteCvtPS2PD_WriteCvtSD2SSLd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteIMulLd_WritePHAddX_WritePHAddY_AtomWrite01_7_WriteStore_WriteAESDecEnc_WriteBEXTRLd_WriteFVarBlendLd_WriteCMOV2Ld_WriteLDMXCSR_WriteMPSAD_WriteVarBlendLd_WriteVecShiftXLd_WriteVecTestLd_WriteShuffleYLd_WriteFLogicYLd_WriteFBlendYLd_WriteCvtPS2PHYSt_WriteVecALUYLd_WriteFMaskedLoad_WriteFShuffleYLd_WriteMPSADY_WriteVecLogicYLd_WriteBlendYLd_WriteFVarShuffleYLd_WriteVecMaskedLoad_WriteVecShiftImmYLd_WriteVarShuffleYLd_WriteVecShiftYLd_WriteFTestYLd_BWWriteResGroup80_BWWriteResGroup82_BWWriteResGroup90_BWWriteResGroup84_BWWriteResGroup89_BWWriteResGroup87_BWWriteResGroup88_BWWriteResGroup73_BWWriteResGroup77_BWWriteResGroup79_BWWriteResGroup74_WriteAESIMCLd_WriteAESKeyGenLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSS2I_WriteVecInsert_WriteVecIMulLd_WritePSADBWLd_WriteVarShuffleLd_WriteFMulXLd_WriteFMulLd_WriteCLMulLd_WritePCmpIStrI_WritePHMINPOSLd_WriteVecIMulXLd_WritePSADBWXLd_WriteVarShuffleXLd_WriteFRcpXLd_WriteFRcpLd_WriteFRsqrtXLd_WriteFRsqrtLd_WriteFCmp64YLd_WriteFCmpYLd_WriteCvtPS2PDYLd_WriteFMulYLd_WriteFVarShuffleLd_WriteFRcpYLd_WriteFRsqrtYLd_WriteFLoadY_WriteFLogicLd_WriteFBlendLd_WriteFComLd_WriteVecALUXLd_WriteFShuffleLd_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WriteCvtPH2PSY_WriteCvtPH2PSZ_WriteCvtPS2PHZ_WriteVecLoadY_WriteVecLoadNTY_WriteVecShiftImmXLd_WriteVarVecShiftLd_SKXWriteResGroup99_SKXWriteResGroup95_SKXWriteResGroup89_SKXWriteResGroup101_SKXWriteResGroup100_SKXWriteResGroup111_SKXWriteResGroup104_SKXWriteResGroup109_SKXWriteResGroup107_SKXWriteResGroup108_SKXWriteResGroup96_SKXWriteResGroup93_SKXWriteResGroup90_SKXWriteResGroup92_SKXWriteResGroup93z_SKXWriteResGroup97_SKXWriteResGroup103_SKXWriteResGroup106_SKXWriteResGroup110_SKXWriteResGroup112_SKXWriteResGroup113_SKXWriteResGroup114_WriteADCLd_WriteCMOVLd_WriteVecInsertLd_WriteCvtPS2PDZLd_WriteFRcpZ_WriteFRsqrtZ_WriteFTestLd_SBWriteResGroup25_1_SBWriteResGroup63_SBWriteResGroup69_SBWriteResGroup68_SBWriteResGroup54_SBWriteResGroup58_SBWriteResGroup59_SBWriteResGroup62_SBWriteResGroup64_SBWriteResGroup66_SBWriteResGroup67_WriteCvtPH2PSYLd_WriteCvtPH2PSZLd_WriteCvtPS2PHZSt_HWWriteResGroup37_HWWriteResGroup26_HWWriteResGroup25_HWWriteResGroup0_1_HWWriteResGroup39_HWWriteXLAT_HWWriteResGroup114_HWWriteResGroup41_HWWriteResGroup17_HWWriteResGroup11_1_HWWriteResGroup36_2_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtSD2ILd_WriteCvtSS2ILd_WritePMULLDLd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPD2IYLd_WriteCvtPD2PSYLd_WriteCvtPS2IYLd_WritePSADBWYLd_WriteVecIMulYLd_WritePMULLDYLd_SKLWriteResGroup94_SKLWriteResGroup91_SKLWriteResGroup85_SKLWriteResGroup96_SKLWriteResGroup95_SKLWriteResGroup103_SKLWriteResGroup98_SKLWriteResGroup102_SKLWriteResGroup100_SKLWriteResGroup101_SKLWriteResGroup92_SKLWriteResGroup89_SKLWriteResGroup86_WriteBSFLd_WriteBSRLd
  { 6,  0}, // #6 WriteFAdd64X_WriteFCmp64X_WriteCvtI2PS_WriteCvtPS2I_WriteCvtSD2SS_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2SD_WriteFLD1_AtomWriteIMul32_AtomWrite01_6_WriteJumpLd_WriteFLoadY_WriteADCLd_WriteALULd_WriteFLogicLd_WriteFBlendLd_WriteBZHILd_WriteCMOVLd_WriteVecALUXLd_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteVarShuffleLd_WriteVecShiftLd_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WriteVarShuffleXLd_WriteShiftLd_WriteFRnd_WriteSHDrrcl_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteCvtPS2PHY_WriteFRndY_WriteVecLoadY_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVecShiftImmXLd_WriteFTestLd_BWWriteResGroup66_BWWriteResGroup70_BWWriteResGroup69_BWWriteResGroup58_BWWriteResGroup71_BWWriteResGroup63_BWWriteResGroup65_BWWriteResGroup62_BWWriteResGroup68_BWWriteResGroup59_BWWriteResGroup64_BWWriteResGroup60_WriteCRC32Ld_WriteIMulLd_WriteIMul64_WritePHAddLd_WritePHAddXLd_WriteVecShiftXLd_WriteFLogicYLd_WriteFBlendYLd_WriteFShuffle256Ld_WriteCvtPD2IY_WriteCvtPD2PSY_WriteFMaskedStoreY_WriteFMaskedLoadY_WriteFShuffleYLd_WriteVecMaskedStoreY_WriteVecMaskedLoadY_JWriteVBROADCASTYLd_WriteFLoadX_WriteCvtSD2I_WriteCvtSS2I_WriteFHAdd_WriteVecLoadX_WriteCLMul_WriteCvtPS2PHSt_WriteFHAddY_SKXWriteResGroup72_SKXWriteResGroup81_SKXWriteResGroup87_SKXWriteResGroup86_SKXWriteResGroup88_SKXWriteResGroup78_SKXWriteResGroup76_SKXWriteResGroup84_SKXWriteResGroup71_SKXWriteResGroup92a_SKXWriteResGroup79_SKXWriteResGroup82_SKXWriteResGroup73_SKXWriteResGroup80_SBWriteResGroup48_SBWriteResGroup53_SBWriteResGroup49_SBWriteResGroup50_SBWriteResGroup51_SBWriteResGroup52_WriteCvtPS2PHZ_WriteFRndZ_HWWriteResGroup18_HWWriteResGroup108_HWWriteResGroup15_HWWriteResGroup14_HWWriteResGroup107_HWWriteResGroup0_HWWriteResGroup11_HWWriteResGroup13_HWWriteResGroup16_HWWriteResGroup102_WriteFAdd64XLd_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteFComLd_WriteDPPDLd_WriteDPPSLd_WriteFHAddLd_WriteIMul64Ld_WriteLZCNTLd_WritePOPCNTLd_WriteFRndLd_WriteTZCNTLd_WriteFAdd64YLd_WriteFAddYLd_WriteFCmp64YLd_WriteFCmpYLd_WriteDPPSYLd_WriteFRndYLd_WriteFHAddYLd_SKLWriteResGroup68_SKLWriteResGroup76_SKLWriteResGroup83_SKLWriteResGroup82_SKLWriteResGroup84_SKLWriteResGroup74_SKLWriteResGroup72_SKLWriteResGroup80_SKLWriteResGroup67_SKLWriteResGroup88_SKLWriteResGroup75_SKLWriteResGroup70_SKLWriteResGroup78_SKLWriteResGroup69_WriteStore_ZnWriteBTRSCm_ZnWriteALULat2Ld_ZnWriteSHA1RNDS4r
  { 5,  0}, // #7 WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteFComLd_WriteEMMS_WriteLDMXCSR_WriteFMulXLd_WriteFMul64Ld_WriteVecIMulXLd_WritePSADBWXLd_WriteVarShuffleXLd_WriteFRndLd_AtomWrite0_5_AtomWrite1_5_AtomWrite0_1_5_AtomWrite01_5_WriteFLoadX_WriteLoad_WriteFHAdd_WriteVecLoadX_WriteVecLoadNT_WriteCLMul_WritePHMINPOS_WriteFRcpX_WriteFRsqrtX_WriteCvtPS2PHSt_WritePSADBWY_WriteFMAY_WriteFMAX_WriteVecIMulY_WriteFHAddY_WriteFMaskedStoreY_WriteVecMaskedStoreY_BWWriteResGroup49_BWWriteResGroup56_BWWriteResGroup54_BWWriteResGroup47_BWWriteResGroup57_BWWriteResGroup50_BWWriteResGroup51_BWWriteResGroup55_WriteFLoadY_WriteStore_WriteBSF_WriteBSR_WriteTZCNTLd_WriteVecLoadY_WriteVecLoadNTY_WriteCvtPH2PS_SKXWriteResGroup61_SKXWriteResGroup58_SKXWriteResGroup68_SKXWriteResGroup69_SKXWriteResGroup63_SKXWriteResGroup67_SKXWriteResGroup62_SKXWriteResGroup65_SKXWriteResGroup66_WriteCvtSD2I_WriteCvtI2SS_WriteCvtSS2I_WriteVecExtractSt_WriteFMul64X_WritePMULLD_WriteSTMXCSR_WritePSADBWZ_WriteFMAZ_WriteVecIMulZ_WriteFMul64Y_WriteFMul64Z_WriteFMulY_WriteFMulZ_WritePMULLDY_WritePMULLDZ_SBWriteResGroup33_SBWriteResGroup31_SBWriteResGroup42_SBWriteResGroup41_SBWriteResGroup47_SBWriteResGroup30_SBWriteResGroup35_SBWriteResGroup35_2_SBWriteResGroup36_SBWriteResGroup40_SBWriteResGroup45_SBWriteResGroup46_HWWriteResGroup0_2_HWWriteResGroup101_HWWriteResGroup99_HWWriteResGroup89_HWWriteResGroup88_HWWriteResGroup93_HWWriteResGroup94_HWWriteResGroup100_WriteCMOV2Ld_WriteCMOVLd_WriteFRcpY_WriteFRsqrtY_SKLWriteResGroup60_SKLWriteResGroup58_SKLWriteResGroup64_SKLWriteResGroup65_SKLWriteResGroup59_SKLWriteResGroup61_SKLWriteResGroup63_WriteJumpLd_WriteADCLd_WriteALULd_WriteBEXTRLd_WriteBZHILd_WriteCvtI2PD_WriteCvtI2PS_WriteCvtPD2I_WriteCvtPS2I_WriteCvtI2SD_WritePOPCNTLd_WriteShiftLd_ZnWriteRSQRTSSr_WriteCvtI2PDY_WriteCvtI2PSY_WriteCvtPD2IY_ZnWriteCVTPD2PSYr_WriteCvtPS2IY_ZnWriteRSQRTPSYr_ZnWriteSTr_ZnWriteXCHGrm_ZnWriteST_FP80m_ZnWriteCVTPD2DQr_ZnWriteEXTRACTPSm_ZnWriteMOVBE_ZnWriteCVSTSI2SIr_ZnWriteCVSTSI2SDr_ZnWriteCVTDQ2PDr_ZnWritePop16r
  {16,  0}, // #8 WriteBSFLd_WriteBSRLd_WriteFDivXLd_BWWriteResGroup150_WritePCmpIStrILd_WritePCmpIStrMLd_WriteFSqrt64X_WriteFSqrtXLd_WriteFSqrtLd_WritePMULLDYLd_BWWriteResGroup153_BWWriteResGroup154_WriteDPPSLd_WriteFDivLd_WritePMULLDLd_WriteFRsqrtZLd_SKXWriteResGroup199_SKXWriteResGroup200_HWWriteResGroup120_HWWriteResGroup145_SKLWriteResGroup177_SKLWriteResGroup178
  { 9,  0}, // #9 WriteFCMOV_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteFHAddLd_WriteFMul64X_WriteFRcpX_WriteFRsqrtX_WriteFHAddYLd_AtomWrite01_9_WriteCvtI2PDLd_WriteCvtI2PSLd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteDPPD_WriteSHDmri_WriteFAdd64YLd_WriteFAddYLd_WriteShuffle256Ld_WriteFShuffle256Ld_WriteFCmp64YLd_WriteFCmpYLd_WriteVarShuffle256Ld_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteFMul64YLd_WriteFMulYLd_WriteFVarShuffle256Ld_WritePHAddYLd_WriteVarVecShiftYLd_BWWriteResGroup91_16_2_BWWriteResGroup101_BWWriteResGroup105_BWWriteResGroup107_BWWriteResGroup121_BWWriteResGroup112_BWWriteResGroup106_BWWriteResGroup108_BWWriteResGroup113_WriteIMul64Ld_WriteFMul64XLd_WriteFMul64Ld_WritePMULLDLd_WriteSHDmrcl_WriteVecTestYLd_WriteFTestYLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64Ld_WriteFCmpLd_WriteVecIMulLd_WriteFMulLd_WritePHAddXLd_WritePSADBWXLd_WriteVecTestLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFVarBlendYLd_WriteFVarBlendZLd_WriteCvtI2PDZLd_WriteCvtI2PSZLd_WriteCvtPH2PSLd_WriteFRsqrtZ_SKXWriteResGroup118_16_2_SKXWriteResGroup135_SKXWriteResGroup137_SKXWriteResGroup142_SKXWriteResGroup156_SKXWriteResGroup136_SKXWriteResGroup146_SKXWriteResGroup143_SBWriteResGroup98_WriteFAdd64XLd_WriteFAddXLd_WriteFCmp64XLd_WriteFCmpXLd_WriteCvtPS2ILd_WritePOPCNTLd_WriteFRndLd_WriteFMaskedLoadY_WriteVarBlendYLd_WriteVarBlendZLd_WriteVecMaskedLoadY_SBWriteResGroup93_3_SBWriteResGroup95_SBWriteResGroup97_SBWriteResGroup100_SBWriteResGroup93_1_SBWriteResGroup93_2_SBWriteResGroup97_2_SBWriteResGroup99_HWWriteResGroup69_WriteVarVecShiftLd_HWWriteResGroup12_2_HWWriteResGroup68_HWWriteResGroup76_HWWriteResGroup79_HWWriteResGroup98_HWWriteResGroup52_HWWriteResGroup53_1_HWWriteResGroup66_HWWriteResGroup67_HWWriteResGroup78_1_HWWriteResGroup80_HWWriteResGroup87_SKLWriteResGroup107_16_2_SKLWriteResGroup120_SKLWriteResGroup123_SKLWriteResGroup127_SKLWriteResGroup142_SKLWriteResGroup121_SKLWriteResGroup131_SKLWriteResGroup128_WriteVecShiftYLd_ZnWriteFPU02_ZnWriteVINSERT128Ld_ZnWriteMul64Ld_ZnWriteFPU01Op2Y_ZnWriteFPU013LdY_ZnWriteSHA1MSG1Ld
  { 8,  0}, // #10 WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSS2I_WriteFHAdd_WritePHAddXLd_WriteFHAddY_WritePHAddYLd_AtomWriteIMul16Ld_AtomWrite01_8_BWWriteResGroup100_WriteFAdd64XLd_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteBSFLd_WriteBSRLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteFComLd_WriteCRC32Ld_WriteCvtPS2ILd_WriteCvtSD2ILd_WriteCvtSD2SSLd_WriteCvtSS2SDLd_WriteCvtSS2ILd_WriteIMulLd_WriteIMul64Ld_WriteLZCNTLd_WritePHAddLd_WriteFMul64XLd_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePOPCNTLd_WriteTZCNTLd_WriteFVarBlendYLd_WriteCvtPD2IYLd_WriteCvtPD2PSYLd_WriteCvtPS2IYLd_WriteCvtPS2PDYLd_WriteFMaskedLoadY_WriteVarBlendYLd_WriteVecMaskedLoadY_WriteVarVecShiftLd_BWWriteResGroup91_BWWriteResGroup99_BWWriteResGroup91_16_BWWriteResGroup92_BWWriteResGroup97_BWWriteResGroup98_WriteAESDecEncLd_WriteCvtI2PSLd_WriteFHAddLd_WriteVecMoveFromGpr_WriteMPSADLd_WritePCmpIStrM_WriteVecTestLd_WriteFRndLd_WriteFAdd64YLd_WriteFAddYLd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteFRndYLd_WriteFHAddYLd_WriteFVarShuffleYLd_WriteFTestLd_SKXWriteResGroup130_WriteAESIMC_WriteFVarBlendLd_WritePSADBWLd_WriteVarBlendLd_WriteShuffleYLd_WriteShuffleZLd_WriteFLogicYLd_WriteFLogicZLd_WriteFBlendYLd_WriteCvtPD2IZLd_WriteCvtPD2PSZLd_WriteCvtPS2IZLd_WriteCvtPS2PDZLd_WriteCvtPS2PHYSt_WriteCvtPS2PHZSt_WriteFRndZ_WriteVecALUYLd_WriteVecALUZLd_WriteFShuffleYLd_WriteFShuffleZLd_WriteVecLogicYLd_WriteVecLogicZLd_WriteBlendYLd_WriteVarBlendZLd_WriteFVarShuffleZLd_WriteVecShiftImmYLd_WriteVecShiftImmZLd_WriteVarVecShiftYLd_WriteVarVecShiftZLd_WriteVarShuffleYLd_WriteVarShuffleZLd_WriteVecShiftYLd_WriteVecShiftZLd_SKXWriteResGroup118_16_1_SKXWriteResGroup128_SKXWriteResGroup119_SKXWriteResGroup121_SKXWriteResGroup127_SKXWriteResGroup126_SKXWriteResGroup123_SKXWriteResGroup131_SKXWriteResGroup132_SKXWriteResGroup133_SKXWriteResGroup134_WriteAESKeyGenLd_WriteCMOV2Ld_WriteVecALULd_WriteVecShiftXLd_WriteSHDmri_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteCvtPH2PSZLd_WriteFVarShuffle256Ld_WriteFTestYLd_SBWriteResGroup86_SBWriteResGroup84_SBWriteResGroup81_SBWriteResGroup77_SBWriteResGroup83_SBWriteResGroup85_SBWriteResGroup87_SBWriteResGroup93_4_HWWriteResGroup12_HWWriteResGroup48_HWWriteResGroup46_HWWriteResGroup47_HWWriteResGroup12_1_HWWriteResGroup11_2_HWWriteResGroup13_1_HWWriteResGroup17_2_WriteAESIMCLd_WriteFRcpXLd_WriteFRcpLd_WriteFRsqrtXLd_WriteFRsqrtLd_WriteFMul64YLd_WriteFMulYLd_WriteFRcpYLd_WriteFRsqrtYLd_SKLWriteResGroup119_SKLWriteResGroup107_16_SKLWriteResGroup117_SKLWriteResGroup108_SKLWriteResGroup110_SKLWriteResGroup116_SKLWriteResGroup115_SKLWriteResGroup112_WriteFLoadX_WriteFLoadY_WriteFLogicLd_WriteFBlendLd_WriteLoad_WriteVecALUXLd_WriteFShuffleLd_WriteVecLoadX_ZnWriteFPU13_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteVarShuffleLd_WriteVecShiftLd_WriteVecLoadNT_WriteFStoreNT_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WriteVarShuffleXLd_WriteVecLoadY_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVecShiftImmXLd_WriteVecTestYLd_ZnWriteMul16Ld_ZnWriteLEAVE_ZnWriteCMPXCHG_ZnWritePushA_ZnWriteMul32Ld_ZnWritePCMPGTQm_ZnWriteBROADCAST_ZnWriteFPU12Ym_ZnWriteFPU01Op2_ZnWriteMulX64Ld_ZnWriteVPBROADCAST256Ld_ZnWritePCMPGTQYm_ZnWriteMulX32Ld_ZnWriteFPU0Lat1Ld_ZnWriteFPU013Ld_ZnWriteVPBROADCAST128Ld_ZnWriteFPU013m_ZnWriteSHA1MSG2Ld_ZnWriteSHA1NEXTELd
  {50,  0}, // #11 WriteDiv16Ld_WriteDiv32Ld_WriteDiv8
  {130,  0}, // #12 WriteDiv64Ld_WriteIDiv64Ld_AtomWrite01_130
  {68,  0}, // #13 WriteDiv8Ld_AtomWrite01_68
  {125,  0}, // #14 WriteFDiv64XLd_WriteFSqrt64XLd
  {70,  0}, // #15 WriteFDivXLd_WriteFSqrtXLd
  {34,  0}, // #16 WriteFDivLd_WriteFSqrtLd_BWWriteResGroup191_BWWriteResGroup190_SBWriteResGroup131_WriteAESKeyGenLd_HWWriteResGroup166_WriteFDiv64
  {62,  0}, // #17 WriteFDiv64Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv8Ld_WriteFSqrt64Ld_SKXWriteResGroup258_SKLWriteResGroup217
  {10,  0}, // #18 AtomWrite01_10_WriteFMul64XLd_WriteFRcpXLd_WriteFRsqrtXLd_WriteFHAddLd_WriteVecIMulLd_WritePSADBWLd_WriteCLMulLd_WritePHMINPOSLd_WriteVecIMulXLd_WritePMULLD_WritePSADBWXLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFMAXLd_WritePMULLDY_WriteVecTestYLd_BWWriteResGroup120_BWWriteResGroup115_BWWriteResGroup117_WriteFAdd64XLd_WriteFAddXLd_WriteAESDecEncLd_WriteFCmp64XLd_WriteFCmpXLd_WriteEMMS_WriteMPSADLd_WriteFMulXLd_WritePCmpIStrI_WritePCmpIStrM_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteCvtPH2PSYLd_WriteCvtPH2PSZLd_WritePSADBWYLd_WritePSADBWZLd_WriteFVarShuffle256Ld_WritePHAddYLd_WritePMULLDZ_SKXWriteResGroup148_SKXWriteResGroup157_SKXWriteResGroup149_SKXWriteResGroup153_SKXWriteResGroup154_SKXWriteResGroup151_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtSD2ILd_WriteCvtSD2SSLd_WriteCvtI2SSLd_WriteCvtSS2ILd_WriteSHDmrcl_WriteFMAZLd_WriteFAdd64YLd_WriteFAdd64ZLd_WriteFAddYLd_WriteFAddZLd_WriteFCmp64YLd_WriteFCmpYLd_WriteFCmpZLd_WriteCvtI2PDYLd_WriteCvtI2PDZLd_WriteCvtI2PSYLd_WriteCvtI2PSZLd_WriteCvtPS2IYLd_WriteCvtPS2IZLd_WriteFMAYLd_WriteFRndYLd_WriteFRndZLd_WriteFCmp64ZLd_SBWriteResGroup101_WriteFMul64Ld_WriteFMulLd_WriteSHDmri_WriteVarVecShiftYLd_WriteVarVecShiftZLd_HWWriteResGroup52_1_HWWriteResGroup97_HWWriteResGroup77_HWWriteResGroup78_WriteBSF_WriteBSR_WriteMPSADYLd_SKLWriteResGroup133_SKLWriteResGroup143_SKLWriteResGroup134_SKLWriteResGroup138_SKLWriteResGroup139_SKLWriteResGroup140_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64Ld_WriteFCmpLd_WriteFComLd_WriteCRC32Ld_ZnWriteCVTPS2PDLd
  {12,  0}, // #19 WriteIMul64Ld_WriteAESDecEncLd_WriteMPSADLd_WriteFRndYLd_BWWriteResGroup135_WriteCvtSD2ILd_WriteCvtSD2SSLd_WriteCvtSS2SDLd_WriteCvtSS2ILd_WriteDiv8_WriteIDiv8_WritePCmpIStrILd_WriteDPPSY_WriteFHAddLd_WriteCLMulLd_WriteFSqrtX_WriteFSqrtY_SKXWriteResGroup179_SKXWriteResGroup174_SKXWriteResGroup174z_SKXWriteResGroup175_SKXWriteResGroup176_SKXWriteResGroup177_WriteAESIMC_WritePSADBWYLd_WritePSADBWZLd_WriteVecIMulYLd_WriteVecIMulZLd_WriteFHAddYLd_WriteFMul64YLd_WriteFMul64ZLd_WriteFMulYLd_WriteFMulZLd_WritePMULLDYLd_WritePMULLDZLd_SBWriteResGroup111_WriteFRndLd_WriteSHDmrcl_WriteFMAZLd_WriteFMAYLd_HWWriteResGroup91_3_HWWriteResGroup104_SKLWriteResGroup160_WriteCvtI2PDLd_WriteCvtI2PSLd_WriteCvtPD2ILd_WriteCvtPS2ILd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteFRcpXLd_WriteFRcpLd_WriteFRsqrtXLd_ZnWriteRSQRTSSLd_WriteFMALd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPD2IYLd_WriteCvtPS2IYLd_ZnWriteVDIVPSYr_WriteFMAXLd_WriteFRcpYLd_ZnWriteRSQRTPSYLd_ZnWriteFIST_ZnWriteCVTPD2DQLd_ZnWriteCVSTSI2SILd_ZnWriteFPU03
  { 2,  0}, // #20 WriteLAHFSAHF_WriteVecShift_WriteVecShiftX_WriteSETCCStore_WriteSHDrrcl_WriteSHDrri_AtomWrite01_2_WriteBEXTR_WriteFVarBlend_WriteBSWAP64_WriteCMOV2_WriteVecExtractSt_WriteVecInsert_WriteVarBlend_WriteVecTest_WriteSTMXCSR_WriteFVarBlendY_WriteCvtPH2PSY_WriteVarBlendY_BWWriteResGroup14_BWWriteResGroup20_BWWriteResGroup22_BWWriteResGroup12_BWWriteResGroup13_BWWriteResGroup17_BWWriteResGroup30_BWWriteResGroup25_BWWriteResGroup16_BWWriteResGroup18_BWWriteResGroup24_BWWriteResGroup15_WriteFSign_WriteAESIMC_WriteAESKeyGen_WriteFCmp64X_WriteFCmpX_WriteCvtPS2PD_WriteEMMS_WriteVecStore_WriteVecStoreNT_WriteVecIMul_WritePSADBW_WriteVarShuffle_WriteFStore_WriteFMulX_WriteCLMul_WritePHMINPOS_WriteVecIMulX_WritePSADBWX_WriteVarShuffleX_WriteFRcpX_WriteFRsqrtX_WriteTZCNT_WriteFCmp64Y_WriteFCmpY_WriteCvtPS2PDY_WriteVecStoreNTY_WriteFMulY_WriteFVarShuffle_WriteFRcpY_WriteFRsqrtY_JWriteINSERTQ_JWrite3OpsLEA_WriteFCom_WriteVecMoveToGpr_WriteMMXMOVMSK_WriteFMOVMSK_WriteVecMOVMSK_WriteFVarBlendZ_WriteFMaskedStoreY_WriteVarBlendZ_WriteVecMaskedStoreY_WriteVecMOVMSKY_WriteFTestY_SKXWriteResGroup17_SKXWriteResGroup23_SKXWriteResGroup25_SKXWriteResGroup14_SKXWriteResGroup15_SKXWriteResGroup36_SKXWriteResGroup28_SKXWriteResGroup20_SKXWriteResGroup13_SKXWriteResGroup21_SKXWriteResGroup27_SKXWriteResGroup29_WriteADC_WriteCvtPS2PDZ_WriteVecTestY_SBWriteResGroup18_SBWriteResGroup9_SBWriteResGroup11_SBWriteResGroup12_SBWriteResGroup15_SBWriteResGroup25_WriteCvtPH2PSZ_HWWriteResGroup30_HWWriteResGroup35_HWWriteResGroup21_HWWriteResGroup28_HWWriteResGroup29_HWWriteResGroup33_HWWriteResGroup54_HWWriteResGroup24_HWWriteResGroup32_HWWriteResGroup19_HWWriteResGroup23_HWWriteResGroup23_16_HWWriteResGroup31_SKLWriteResGroup17_SKLWriteResGroup23_SKLWriteResGroup25_SKLWriteResGroup14_SKLWriteResGroup15_SKLWriteResGroup34_SKLWriteResGroup28_SKLWriteResGroup20_SKLWriteResGroup13_SKLWriteResGroup21_SKLWriteResGroup27_WriteLZCNT_WriteShuffle256_WriteVarShuffle256_WriteVecMoveY_WriteVecShiftY_ZnWriteEXTRACTPSr_ZnWriteBTRSC_ZnWriteALULat2_ZnWriteFPU013Y_ZnWritePShiftY_ZnWriteVINSERT128r_ZnWriteEXTRQ_ZnWriteSHA1MSG1r
  { 3,  0}, // #21 WriteVecMoveToGpr_WritePHAdd_WriteMMXMOVMSK_WriteVecShiftLd_WriteFMOVMSK_WriteVecMOVMSK_WriteVecShiftXLd_AtomWrite01_3_WriteFAdd64X_WriteFAddX_WriteBSF_WriteBSR_WriteFCMOV_WriteFCmp64X_WriteFCmpX_WriteFCom_WriteCRC32_WriteCvtPD2I_WriteCvtPD2PS_WriteCvtPS2I_WriteCvtPS2PD_WriteCvtSD2I_WriteCvtSD2SS_WriteCvtSS2SD_WriteCvtSS2I_WriteIMul_WriteIMul64_WriteLZCNT_WriteFMul64X_WriteFMulX_WritePHAddX_WritePOPCNT_WriteSHDrri_WriteTZCNT_WriteFAdd64Y_WriteFAddY_WriteShuffle256_WriteFShuffle256_WriteFCmp64Y_WriteFCmpY_WriteVarShuffle256_WriteCvtPD2IY_WriteCvtPD2PSY_WriteCvtPS2IY_WriteCvtPS2PDY_WriteFMul64Y_WriteFMulY_WriteFVarShuffle256_WritePHAddY_WriteVecMOVMSKY_WriteVarVecShift_WriteVarVecShiftY_BWWriteResGroup27_BWWriteResGroup34_BWWriteResGroup36_BWWriteResGroup38_BWWriteResGroup37_BWWriteResGroup28_BWWriteResGroup33_BWWriteResGroup35_WriteAESDecEnc_WriteCvtI2PD_WriteCvtI2PS_WriteVecExtractSt_WriteFLDC_WriteFHAdd_WriteFLD0_WriteFLD1_WriteFStoreNTX_WriteMPSAD_WriteVecTest_WriteFRnd_WriteFVarBlendY_WriteCvtI2PDY_WriteCvtI2PSY_WriteCvtPH2PSY_WriteCvtPS2PH_WriteFRndY_WriteFHAddY_WriteFStoreNTY_WriteFVarShuffleY_WriteFTest_JSlowLEA16r_WritePSADBW_WritePSADBWX_WriteCvtPD2IZ_WriteCvtPD2PSZ_WriteCvtPS2IZ_WriteCvtPS2PDZ_WritePSADBWY_WritePSADBWZ_WriteVecTestY_SKXWriteResGroup42_SKXWriteResGroup34_SKXWriteResGroup35_SKXWriteResGroup32_SKXWriteResGroup48_SKXWriteResGroup47_SKXWriteResGroup46_SKXWriteResGroup45_SKXWriteResGroup43_SKXWriteResGroup31_SKXWriteResGroup41_SKXWriteResGroup44_SKXWriteResGroup37_SKXWriteResGroup38_SKXWriteResGroup30_WriteVecALU_WriteCMOV2_WriteFAdd64Z_WriteFAddZ_WriteFCmpZ_WriteCvtI2PSZ_WriteCvtPH2PSZ_WriteCvtPS2PHY_WriteCvtPS2PHZ_WriteFRndZ_WriteFCmp64Z_SBWriteResGroup21_SBWriteResGroup22_SBWriteResGroup23_2_SBWriteResGroup26_2_SBWriteResGroup43_WriteVarVecShiftZ_HWWriteResGroup50_HWWriteResGroup58_HWWriteResGroup60_HWWriteResGroup45_HWWriteResGroup44_HWWriteResGroup51_HWWriteResGroup57_HWWriteResGroup59_WriteFLoadX_WriteFLoadY_WriteLoad_WriteDPPD_WriteDPPS_WriteVecLoadX_WriteLDMXCSR_WriteVecLoadNT_WriteDPPSY_WriteVecLoadY_WriteFMaskedLoadY_WriteVecLoadNTY_WriteVecMaskedLoadY_SKLWriteResGroup40_SKLWriteResGroup32_SKLWriteResGroup33_SKLWriteResGroup30_SKLWriteResGroup46_SKLWriteResGroup45_SKLWriteResGroup44_SKLWriteResGroup43_SKLWriteResGroup41_SKLWriteResGroup29_SKLWriteResGroup39_SKLWriteResGroup42_SKLWriteResGroup35_SKLWriteResGroup36_ZnWriteCVTPS2PDr_WriteVecMoveFromGpr_ZnWriteVCVTPS2PDY_ZnWriteMul32_ZnWriteMul16_ZnWriteMulX64_ZnWriteMulX32
  { 4,  0}, // #22 WritePHAddLd_WriteVecIMulLd_WritePSADBWLd_WriteFMulLd_WriteVarShuffleX_WriteFRcpLd_WriteFRsqrtLd_WriteSHDmrcl_WriteSHDmri_AtomWrite01_4_WriteCvtI2PD_WriteCvtI2PS_WriteCvtI2SD_WriteCvtI2SS_WriteCvtI2PDY_WriteCvtI2PSY_WriteCvtPS2PH_WriteVecShiftY_WriteVecTestY_BWWriteResGroup52_BWWriteResGroup42_BWWriteResGroup44_BWWriteResGroup39_BWWriteResGroup45_BWWriteResGroup41_BWWriteResGroup27_16_BWWriteResGroup42_16_BWWriteResGroup43_BWWriteResGroup40_BWWriteResGroup46_WriteJumpLd_WriteADCLd_WriteALULd_WriteBEXTRLd_WriteCMOV2Ld_WriteCMOVLd_WriteLZCNTLd_WriteVecMoveToGpr_WriteVecInsertLd_WriteFMul64X_WritePMULLD_WritePOPCNTLd_WriteShiftLd_WriteSHDrrcl_WriteCvtPS2PHSt_WriteFMul64Y_WriteFTestY_WriteFAdd64X_WriteFAddX_WriteAESDecEnc_WriteFCmp64X_WriteFCmpX_WriteMPSAD_WriteFMulX_WritePHMINPOS_WriteVecIMulX_WriteFRcpX_WriteFRsqrtX_WriteFAdd64Y_WriteFAdd64Z_WriteFAddY_WriteFAddZ_WriteFCmp64Y_WriteFCmpY_WriteFCmpZ_WriteCvtI2PDZ_WriteCvtI2PSZ_WriteFMAY_WriteFMAX_WriteFMAZ_WriteVecIMulY_WriteVecIMulZ_WriteFCmp64Z_WriteMPSADY_WriteFMul64Z_WriteFMulY_WriteFMulZ_WriteVecShiftZ_WriteFRcpY_WriteFRcpZ_WriteFRsqrtY_SKXWriteResGroup64_SKXWriteResGroup54_SKXWriteResGroup55_SKXWriteResGroup31_16i_SKXWriteResGroup52_SKXWriteResGroup52_16_SKXWriteResGroup50_SKXWriteResGroup56_SKXWriteResGroup57_SKXWriteResGroup49_SKXWriteResGroup50z_SKXWriteResGroup51_WriteCvtPD2I_WriteCvtPD2PS_WriteCvtSD2SS_WritePCmpEStrILd_WriteCvtPD2IY_WriteCvtPD2IZ_WriteCvtPD2PSY_WriteCvtPD2PSZ_WriteCvtPS2PHYSt_WriteCvtPS2PHZSt_SBWriteResGroup27_1_SBWriteResGroup29_2_SBWriteResGroup21_16i_SBWriteResGroup27_2_HWWriteResGroup95_HWWriteResGroup73_HWWriteMOVS_HWWriteResGroup62_HWWriteResGroup70_HWWriteResGroup81_HWWriteResGroup72_HWWriteResGroup50_16i_HWWriteResGroup74_HWWriteResGroup74_16_HWWriteResGroup61_HWWriteCMPS_HWWriteResGroup71_HWWriteResGroup82_HWWriteResGroup83_WriteFLogicLd_WriteFBlendLd_WriteFVarBlendLd_WriteCvtPS2I_WriteCvtPS2PD_WriteCvtSD2I_WriteCvtSS2SD_WriteCvtSS2I_WriteVecExtractSt_WriteVecALUXLd_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteMMXMOVMSK_WriteVarShuffleLd_WriteVecShiftLd_WriteFMOVMSK_WriteShuffleXLd_WriteVecLogicXLd_WriteVarBlendLd_WriteBlendLd_WritePHAddXLd_WriteVecMOVMSK_WritePSADBWX_WriteVarShuffleXLd_WriteVecShiftXLd_WriteVecTestLd_WriteShuffleYLd_WriteFLogicYLd_WriteCvtPS2IY_WriteCvtPS2PDY_WritePSADBWY_WriteVecALUYLd_WriteFShuffleYLd_WriteVecLogicYLd_WriteBlendYLd_WriteFVarShuffleYLd_WriteFVarShuffleLd_WritePHAddYLd_WriteVecMOVMSKY_WritePMULLDY_WriteVecShiftImmXLd_WriteVecShiftImmYLd_WriteVarVecShiftLd_WriteVarShuffleYLd_WriteVecShiftYLd_WriteVecTestYLd_WriteFTestYLd_WriteFTestLd_SKLWriteResGroup62_SKLWriteResGroup53_SKLWriteResGroup55_SKLWriteResGroup54_SKLWriteResGroup29_16i_SKLWriteResGroup51_SKLWriteResGroup51_16_SKLWriteResGroup48_SKLWriteResGroup56_SKLWriteResGroup57_SKLWriteResGroup47_WriteAESIMC_WriteAESKeyGen_ZnWriteCVTPD2PSr_ZnWriteCVTSS2SDr_WriteIMul_WriteIMul64_WriteFRnd_WriteFRndY_WriteFMaskedStore_WriteVecMaskedStore_ZnWriteMul64_ZnWriteCVTPS2PIr_ZnWritePUSH_ZnWriteINSERTQ_ZnWriteSHA256RNDS2r
  {71,  0}, // #23 WriteFSqrt80_AtomWrite01_71_WriteFSqrt64X_WriteFSqrt64Y
  {15,  0}, // #24 WriteSTMXCSR_AtomWrite01_15_WritePMULLDLd_BWWriteResGroup149_BWWriteResGroup147_WriteDiv8Ld_WriteIDiv8Ld_WriteDPPDLd_WriteFRndYLd_WriteFRndZLd_SKXWriteResGroup195_SKXWriteResGroup191_SKXWriteResGroup194_SBWriteResGroup119_HWWriteResGroup115_HWWriteFXTRACT_SKLWriteResGroup174_SKLWriteResGroup171_WriteFDiv64X_WriteFDivX_ZnWriteVDIVPDY
  {14,  0}, // #25 AtomWriteIMul64I_AtomWrite01_14_WriteAESIMC_WriteFDiv64X_BWWriteResGroup139_1_WriteDPPDLd_WriteDPPS_WriteDPPSY_BWWriteResGroup146_BWWriteResGroup141_BWWriteResGroup144_BWWriteResGroup145_WriteCvtI2SDLd_WriteCvtI2SSLd_WritePCmpEStrI_WritePCmpEStrM_WriteAESIMCLd_SKXWriteResGroup184_WriteFRndLd_SKXWriteResGroup184_1_SKXWriteResGroup187_SKXWriteResGroup190_SKXWriteResGroup188_SKXWriteResGroup189_WriteFDivX_WriteCLMulLd_WriteFSqrtX_WriteMPSADYLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_WriteFRsqrtZLd_HWWriteResGroup142_SKLWriteResGroup166_SKLWriteResGroup166_1_SKLWriteResGroup169_SKLWriteResGroup170
  {11,  0}, // #26 AtomWrite01_11_WriteFDivX_BWWriteResGroup122_1_WritePCmpIStrI_WritePCmpIStrM_WriteFRndLd_WriteSHDmrcl_WriteFSqrtX_WritePSADBWYLd_WriteFMAYLd_WriteVecIMulYLd_WriteFHAddYLd_WriteFRcpY_WriteFRsqrtY_BWWriteResGroup133_BWWriteResGroup123_BWWriteResGroup128_BWWriteResGroup131_BWWriteResGroup132_WriteDPPS_WriteCvtPD2IYLd_WriteCvtPD2PSYLd_WriteCvtSD2ILd_WriteCvtSS2ILd_SKXWriteResGroup159_WriteFMAZLd_WriteFAdd64YLd_WriteFAdd64ZLd_WriteFAddYLd_WriteFAddZLd_WriteFCmp64YLd_WriteFCmpYLd_WriteFCmpZLd_WriteFDivY_WriteVecIMulZLd_WriteFCmp64ZLd_WriteMPSADYLd_WriteFMul64YLd_WriteFMul64ZLd_WriteFMulYLd_WriteFMulZLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_SKXWriteResGroup171_SKXWriteResGroup162_SKXWriteResGroup160_SKXWriteResGroup161_SKXWriteResGroup166_SKXWriteResGroup164_SKXWriteResGroup169_SKXWriteResGroup170_SKXWriteResGroup163_SKXWriteResGroup167_WriteFHAddLd_WriteFMul64XLd_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePCmpEStrMLd_WritePHMINPOSLd_WriteVecIMulXLd_WritePMULLDLd_WritePSADBWXLd_WriteFRcpXLd_WriteFRcpLd_WriteFRsqrtXLd_WriteFRsqrtLd_WriteCvtPD2IZLd_WriteCvtPD2PSZLd_WriteVecShiftYLd_WriteVecShiftZLd_SBWriteResGroup104_SBWriteResGroup106_WriteCLMul_WriteFMAXLd_WriteVecTestYLd_WriteFRsqrtZ_HWWriteResGroup131_HWWriteFRNDINT_HWWriteResGroup91_2_HWWriteResGroup75_HWWriteResGroup129_HWWriteResGroup130_SKLWriteResGroup145_SKLWriteResGroup156_SKLWriteResGroup151_SKLWriteResGroup149_SKLWriteResGroup146_SKLWriteResGroup147_SKLWriteResGroup152_SKLWriteResGroup150_SKLWriteResGroup154_SKLWriteResGroup155_WriteAESDecEncLd_WriteAESIMCLd_WriteAESKeyGenLd_ZnWriteCVTPD2PSLd_ZnWriteCVTSS2SDLd_ZnWriteFPU3_WriteVecIMulLd_ZnWriteCVTPD2PSYLd_WriteFRndYLd_ZnWriteFILD_ZnWriteSHA256RNDS2Ld
  {13,  0}, // #27 AtomWrite01_13_WriteMPSADYLd_WritePCmpIStrMLd_WriteDPPS_WriteDPPSY_WriteFHAddYLd_SKXWriteResGroup180_SKXWriteResGroup181_SKXWriteResGroup183_WriteAESDecEncLd_WriteMPSADLd_SBWriteResGroup114_WriteFDivX_WriteFRndYLd_WriteFRndZLd_HWWriteResGroup103_WriteBSFLd_WriteBSRLd_SKLWriteResGroup162_SKLWriteResGroup163_ZnWriteSHA1RNDS4Ld
  {17,  0}, // #28 AtomWrite01_17_WriteFDivY_WriteFRcpYLd_WriteFRsqrtYLd_WriteDiv16_WriteIDiv16_WriteDPPSYLd_SKXWriteResGroup201_WriteFSqrtLd_WritePMULLDYLd_WritePMULLDZLd_SKXWriteResGroup202_WritePCmpIStrILd_WritePCmpIStrMLd_WriteCLMulLd_WriteFSqrtXLd_HWWriteResGroup147_HWWriteResGroup132_WritePCmpEStrMLd_SKLWriteResGroup179_SKLWriteResGroup180
  {18,  0}, // #29 AtomWrite01_18_WritePCmpEStrI_BWWriteResGroup160_BWWriteResGroup159_WriteFSqrt64X_WriteFSqrtXLd_WriteFDivYLd_WriteFDivZ_WriteFSqrt64Y_SKXWriteResGroup208_SKXWriteResGroup207_SKXWriteResGroup205_WriteAESIMCLd_WriteDPPSLd_WriteFDivLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_WriteFRsqrtZLd_HWWriteResGroup149_SKLWriteResGroup185_SKLWriteResGroup184
  {20,  0}, // #30 AtomWrite01_20_WriteDPPSYLd_BWWriteResGroup167_BWWriteResGroup165_WriteDiv16Ld_WriteIDiv16Ld_WriteAESKeyGen_SKXWriteResGroup216_WriteFSqrtZ_SKXWriteResGroup220_SKXWriteResGroup219_SKXWriteResGroup215_SKXWriteResGroup214_SKXWriteResGroup218_WriteFDivXLd_WriteFDivLd_WriteFSqrtXLd_WriteFSqrtLd_WriteAESIMCLd_WriteFDiv64X_WriteDPPSLd_HWWriteResGroup156_HWWriteResGroup154_SKLWriteResGroup190_SKLWriteResGroup193_SKLWriteResGroup192_SKLWriteResGroup189_WriteFSqrt64X_WriteFSqrt80
  {21,  0}, // #31 AtomWrite01_21_WriteFSqrt64XLd_WriteFSqrt64Ld_WriteFSqrtY_BWWriteResGroup171_BWWriteResGroup169_WriteFSqrtX_WriteFSqrt80_SKXWriteResGroup222_WriteFDivY_WriteFDivZ_WriteDPPSYLd_WriteFSqrtZ_HWWriteResGroup144_WritePCmpEStrILd_SKLWriteResGroup195_WriteDiv16Ld_WriteIDiv16Ld
  {22,  0}, // #32 AtomWrite01_22_BWWriteResGroup172_BWWriteResGroup183_1_SKXWriteResGroup223_SKXWriteResGroup224_2_SKXWriteResGroup225_WriteFDiv64X_WriteFSqrt64XLd_HWWriteResGroup146_HWWriteDiv8_WriteFDivLd_SKLWriteResGroup196_SKLWriteResGroup196_1_WriteFDiv64XLd_WriteFDivXLd_WriteFDiv64Ld_ZnWriteVDIVPDYLd
  {23,  0}, // #33 AtomWrite01_23_WritePCmpEStrILd_WriteFSqrt80_WriteFDiv64Y_WriteFDivYLd_BWWriteResGroup176_BWWriteResGroup183_2_WriteFSqrt64Ld_WriteFDiv64Z_SKXWriteResGroup228_HWWriteIDiv8_HWWriteResGroup151_HWWriteResGroup190_WriteFSqrtLd_SKLWriteResGroup198
  {25,  0}, // #34 AtomWrite01_25_WriteDiv16_WriteDiv32_WriteDiv64_WriteDiv8_WriteIDiv16_WriteIDiv32_WriteIDiv64_WriteIDiv8_BWWriteResGroup183_4_WriteAESKeyGenLd_WritePCmpEStrMLd_WriteFDivZLd_WriteFSqrt64YLd_SKXWriteResGroup233_SKXWriteResGroup224_3_SKXWriteResGroup234_WriteFDiv64Ld_HWWriteResGroup187_HWWriteResGroup192_SKLWriteResGroup202_SKLWriteResGroup196_2
  {26,  0}, // #35 AtomWrite01_26_BWWriteResGroup180_BWWriteResGroup183_5_BWWriteResGroup183_6_WriteFSqrtXLd_WriteFSqrtLd_SKXWriteResGroup238_WriteFDiv64XLd_HWWriteResGroup184
  {29,  0}, // #36 AtomWrite01_29_WriteAESKeyGen_WriteFDiv64YLd_WriteFSqrt64Y_BWWriteResGroup182_BWWriteResGroup185_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_SKXWriteResGroup242_WriteFDivY_WriteFDivZ_WriteFSqrtY_WriteFSqrtZ
  {30,  0}, // #37 AtomWrite01_30_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_BWWriteResGroup186_WriteFDiv64ZLd_SKXWriteResGroup243_SKXWriteResGroup245_HWWriteResGroup161_HWWriteResGroup164_SKLWriteResGroup208
  {32,  0}, // #38 AtomWrite01_32_WriteFSqrt64XLd_WriteFSqrt64Ld_WriteFSqrt64Z
  {45,  0}, // #39 AtomWrite01_45_WriteFDiv64Y_WriteFDiv64Z_WriteFSqrt64Y_WriteFSqrt64Z_WriteDiv64Ld_WriteIDiv64Ld
  {46,  0}, // #40 AtomWrite01_46_JWriteJVZEROUPPER_SKLWriteResGroup216
  {48,  0}, // #41 AtomWrite01_48
  {55,  0}, // #42 AtomWrite01_55
  {59,  0}, // #43 AtomWrite01_59_WriteFSqrt64YLd
  {63,  0}, // #44 AtomWrite01_63_BWWriteResGroup199_BWWriteResGroup198_SKXWriteResGroup260_SKXWriteResGroup259_SKLWriteResGroup219_SKLWriteResGroup218
  {72,  0}, // #45 AtomWrite01_72_WriteFDiv64XLd_WriteFDiv64YLd
  {74,  0}, // #46 AtomWrite01_74_SKXWriteResGroup262_WriteFSqrt64XLd_WriteFSqrt64YLd
  {77,  0}, // #47 AtomWrite01_77
  {78,  0}, // #48 AtomWrite01_78
  {79,  0}, // #49 AtomWrite01_79
  {92,  0}, // #50 AtomWrite01_92
  {94,  0}, // #51 AtomWrite01_94
  {99,  0}, // #52 AtomWrite01_99
  {121,  0}, // #53 AtomWrite01_121
  {127,  0}, // #54 AtomWrite01_127
  {140,  0}, // #55 AtomWrite01_140_SKXWriteResGroup267
  {141,  0}, // #56 AtomWrite01_141
  {146,  0}, // #57 AtomWrite01_146
  {147,  0}, // #58 AtomWrite01_147
  {168,  0}, // #59 AtomWrite01_168
  {174,  0}, // #60 AtomWrite01_174
  {183,  0}, // #61 AtomWrite01_183
  {202,  0}, // #62 AtomWrite01_202
  { 6,  0}, // #63 WriteALULd_WriteShiftLd_WriteIMulLd_WriteIMul64Ld
  { 1,  0}, // #64 WriteRMW_WriteIMulH
  {19,  0}, // #65 WriteAESIMCLd_WriteFDiv64XLd_BWWriteResGroup161_WriteDPPSLd_WritePCmpEStrM_WriteFDivX_WritePCmpEStrILd_WritePCmpEStrMLd_SKXWriteResGroup209_WriteFSqrtYLd_SKXWriteResGroup211_WriteDPPSYLd_WriteFDivXLd_HWWriteResGroup135_HWWriteResGroup143_HWWriteFPREM_SKLWriteResGroup186_WriteDiv8Ld_WriteIDiv8Ld_ZnWriteVDIVPSYLd
  {33,  0}, // #66 WriteAESKeyGenLd
  {31,  0}, // #67 WriteEMMS_SBWriteResGroup130_HWWriteResGroup163_HWWriteResGroup165
  { 8,  0}, // #68 WriteIMulLd_WriteIMul64Ld
  { 3,  0}, // #69 WriteIMulH_WriteIMul64
  { 3,  0}, // #70 WriteIMul_WriteIMulH
  { 3,  0}, // #71 WriteIMulH
  {24,  0}, // #72 WritePCmpEStrMLd_BWWriteResGroup177_BWWriteResGroup183_3_WriteFDiv64XLd_WriteFDivXLd_WriteFDivLd_WriteFDiv64Ld_WritePCmpEStrILd_WriteFSqrt64XLd_WriteFSqrt80_HWWriteResGroup162_HWWriteResGroup185
  {35,  0}, // #73 WriteFSqrt64YLd_BWWriteResGroup194_BWWriteResGroup193_WriteFSqrt80_SKXWriteResGroup248_SKXWriteResGroup247_WriteFDiv64Y_WriteFDiv64Z_WriteFSqrt64Z_HWWriteResGroup170_SKLWriteResGroup210_SKLWriteResGroup209_WriteFSqrtYLd
  {27,  0}, // #74 WriteFSqrtYLd_BWWriteResGroup183_7_WriteFSqrt64X_WriteFSqrtZLd_SKXWriteResGroup239_SKXWriteResGroup240_WriteFSqrt64XLd_WriteFSqrt64Ld_HWWriteFPREM1_HWWriteResGroup155_HWWriteResGroup188_HWWriteResGroup189_SKLWriteResGroup206_WriteFSqrtXLd_WriteFSqrtLd
  {42,  0}, // #75 BWWriteResGroup196_WriteFSqrtY_SKXWriteResGroup254_SKXWriteResGroup255_WriteFDiv64YLd_WriteFDiv64ZLd_WriteFSqrt64YLd_WriteFSqrt64ZLd_HWWriteResGroup176_WriteFDivXLd_WriteFDivYLd_SKLWriteResGroup214_SKLWriteResGroup215
  {75,  0}, // #76 BWWriteResGroup200_SKXWriteResGroup263_HWWriteResGroup180_HWWriteFSCALE_SKLWriteResGroup220
  {60,  0}, // #77 BWWriteResGroup197
  {80,  0}, // #78 BWWriteResGroup201
  {115,  0}, // #79 BWWriteResGroup202_HWWriteResGroup183
  { 4,  0}, // #80 WriteALULd_WriteShiftLd
  { 1,  0}, // #81 WriteRMW
  {28,  0}, // #82 WriteDiv32Ld_WriteIDiv32Ld_SKXWriteResGroup241_WriteFDiv64XLd_WriteFDiv64Ld_WriteFDivYLd_WriteFDivZLd_WriteFSqrtYLd_WriteFSqrtZLd_HWWriteResGroup186_HWWriteResGroup191_SKLWriteResGroup207
  {44,  0}, // #83 WriteDiv64Ld_WriteIDiv64Ld_SKXWriteResGroup256_WriteFSqrtXLd_WriteFSqrtYLd
  {41,  0}, // #84 WriteDiv64_WriteIDiv64_SKXWriteResGroup253_HWWriteResGroup175_WriteFSqrtX_WriteFSqrtY_SKLWriteResGroup213
  { 6,  0}, // #85 WriteIMulLd_WriteIMul64
  { 6,  0}, // #86 WriteIMulH
  { 3,  0}, // #87 WriteIMul
  { 6,  0}, // #88 WriteIMulH
  { 9,  0}, // #89 WriteIMul64Ld
  { 6,  0}, // #90 WriteIMulH
  {43,  0}, // #91 WriteFDiv64YLd_WriteFDivYLd
  {38,  0}, // #92 WriteFDiv64Y_WriteFDivY_WriteFSqrt64Ld
  {54,  0}, // #93 WriteFSqrt64Y
  {47,  0}, // #94 WriteFSqrtYLd_HWWriteFBLD_WriteFSqrt64YLd
  {90,  0}, // #95 JWriteJVZEROALL
  {39,  0}, // #96 WriteFSqrt64ZLd_WriteFDivX_WriteFDivY
  {37,  0}, // #97 SKXWriteResGroup250_SKXWriteResGroup249_WriteFDiv64Ld_SKLWriteResGroup211
  {40,  0}, // #98 SKXWriteResGroup252_WriteFSqrt80_SKLWriteResGroup212_WriteFSqrt64Y
  {76,  0}, // #99 SKXWriteResGroup264_SKLWriteResGroup221
  {102,  0}, // #100 SKXWriteResGroup265_SKLWriteResGroup222
  {106,  0}, // #101 SKXWriteResGroup266_SKLWriteResGroup223
  {67,  0}, // #102 SKXWriteResGroup261
  {52,  0}, // #103 WriteFDiv64YLd_WriteFDiv64ZLd_WriteFSqrt64YLd_WriteFSqrt64ZLd
  {36,  0}, // #104 WriteFDivYLd_WriteFDivZLd_WriteFSqrtYLd_WriteFSqrtZLd_HWWriteResGroup171
  {64,  0}, // #105 HWWriteResGroup179_HWWriteResGroup178
  {61,  0}, // #106 HWWriteResGroup177
  {98,  0}, // #107 HWWriteResGroup181
  {112,  0}, // #108 HWWriteResGroup182
  {69,  0}, // #109 WriteFDiv64X_WriteFDiv64Y
  { 3,  0}, // #110 WriteIMul_WriteIMul64
  { 1,  0}, // #111 WriteIMulH
  { 5,  0}, // #112 WriteALULd_WriteShiftLd
  { 1,  0}, // #113 WriteRMW
  { 8,  0}, // #114 WriteIMulLd_WriteIMul64Ld
  { 4,  0}, // #115 WriteIMulH_WriteIMul64
  { 4,  0}, // #116 WriteIMul_WriteIMulH
  { 4,  0}, // #117 WriteIMulH
  {107,  0} // #118 WriteFShuffle256Ld_WriteFVarShuffle256Ld
}; // X86WriteLatencyTable

// {UseIdx, WriteResourceID, Cycles}
extern const llvm::MCReadAdvanceEntry X86ReadAdvanceTable[] = {
  {0,  0,  0}, // Invalid
  {0,  0,  3}, // #1
  {5,  0,  3}, // #2
  {5,  0,  3}, // #3
  {6,  0,  3}, // #4
  {0,  0,  3}, // #5
  {6,  0,  3}, // #6
  {0,  0,  3}, // #7
  {1,  0,  3}, // #8
  {0,  0,  5}, // #9
  {5,  0,  5}, // #10
  {5,  0,  5}, // #11
  {6,  0,  5}, // #12
  {0,  0,  5}, // #13
  {6,  0,  5}, // #14
  {0,  0,  5}, // #15
  {1,  0,  5}, // #16
  {0,  0,  4}, // #17
  {5,  0,  4}, // #18
  {5,  0,  4}, // #19
  {6,  0,  4}, // #20
  {0,  0,  4}, // #21
  {6,  0,  4}, // #22
  {0,  0,  4}, // #23
  {1,  0,  4} // #24
}; // X86ReadAdvanceTable

// {Name, NumMicroOps, BeginGroup, EndGroup, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc AtomModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  16383, false, false,  0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteZero")          1, false, false,  0, 0,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteVecALU")        1, false, false,  1, 1,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteALULd_WriteRMW") 2, false, false,  2, 2,  2, 2,  0, 0}, // #3
  {DBGFIELD("WriteJumpLd")        1, false, false,  4, 2,  1, 1,  0, 0}, // #4
  {DBGFIELD("WriteALU")           1, false, false,  1, 1,  1, 1,  0, 0}, // #5
  {DBGFIELD("WriteMove")          1, false, false,  1, 1,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteJump")          1, false, false,  4, 2,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false,  1, 1,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteFStoreX")       1, false, false,  6, 2,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteFLoadX")        1, false, false,  6, 2,  1, 1,  0, 0}, // #10
  {DBGFIELD("WriteFStoreY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #11
  {DBGFIELD("WriteFLoadY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #12
  {DBGFIELD("WriteMicrocoded")    1, false, false,  1, 1,  4, 1,  0, 0}, // #13
  {DBGFIELD("WriteFSign")         1, false, false,  4, 2,  1, 1,  0, 0}, // #14
  {DBGFIELD("WriteADC")           1, false, false,  1, 1,  1, 1,  0, 0}, // #15
  {DBGFIELD("WriteADCRMW")        1, false, false,  6, 2,  1, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCLd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #17
  {DBGFIELD("WriteALURMW")        1, false, false,  6, 2,  1, 1,  0, 0}, // #18
  {DBGFIELD("WriteALULd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #19
  {DBGFIELD("WriteFAdd64XLd_ReadAfterLd") 1, false, false,  8, 1,  5, 1,  1, 1}, // #20
  {DBGFIELD("WriteFAdd64X")       1, false, false,  9, 1,  6, 1,  0, 0}, // #21
  {DBGFIELD("WriteFAddXLd_ReadAfterLd") 1, false, false, 10, 2,  7, 1,  1, 1}, // #22
  {DBGFIELD("WriteFAddX")         1, false, false, 10, 2,  7, 1,  0, 0}, // #23
  {DBGFIELD("WriteFAdd64Ld_ReadAfterLd") 1, false, false, 10, 2,  7, 1,  1, 1}, // #24
  {DBGFIELD("WriteFAdd64")        1, false, false, 10, 2,  7, 1,  0, 0}, // #25
  {DBGFIELD("WriteFAddLd_ReadAfterLd") 1, false, false, 10, 2,  7, 1,  1, 1}, // #26
  {DBGFIELD("WriteFAdd")          1, false, false, 10, 2,  7, 1,  0, 0}, // #27
  {DBGFIELD("WriteFAddLd")        1, false, false, 10, 2,  7, 1,  0, 0}, // #28
  {DBGFIELD("WriteAESDecEncLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #29
  {DBGFIELD("WriteAESDecEnc")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #30
  {DBGFIELD("WriteAESIMCLd")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #31
  {DBGFIELD("WriteAESIMC")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #32
  {DBGFIELD("WriteAESKeyGenLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #33
  {DBGFIELD("WriteAESKeyGen")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #34
  {DBGFIELD("WriteFLogicLd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #35
  {DBGFIELD("WriteFLogic")        1, false, false,  1, 1,  1, 1,  0, 0}, // #36
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #37
  {DBGFIELD("WriteBEXTR")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #38
  {DBGFIELD("WriteBEXTRLd")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #39
  {DBGFIELD("WriteALULd")         1, false, false,  6, 2,  1, 1,  0, 0}, // #40
  {DBGFIELD("WriteFBlendLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #41
  {DBGFIELD("WriteFBlend")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #42
  {DBGFIELD("WriteFVarBlendLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #43
  {DBGFIELD("WriteFVarBlend")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #44
  {DBGFIELD("WriteBSFLd")         1, false, false, 12, 1,  8, 1,  0, 0}, // #45
  {DBGFIELD("WriteBSF")           1, false, false, 12, 1,  8, 1,  0, 0}, // #46
  {DBGFIELD("WriteBSRLd")         1, false, false, 12, 1,  8, 1,  0, 0}, // #47
  {DBGFIELD("WriteBSR")           1, false, false, 12, 1,  8, 1,  0, 0}, // #48
  {DBGFIELD("WriteBSWAP32")       1, false, false,  6, 2,  1, 1,  0, 0}, // #49
  {DBGFIELD("WriteBSWAP64")       1, false, false,  6, 2,  1, 1,  0, 0}, // #50
  {DBGFIELD("WriteBitTest")       1, false, false,  1, 1,  1, 1,  0, 0}, // #51
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #52
  {DBGFIELD("WriteBZHI")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #53
  {DBGFIELD("WriteLoad")          1, false, false,  6, 2,  1, 1,  0, 0}, // #54
  {DBGFIELD("WriteCMOV2Ld_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #55
  {DBGFIELD("WriteCMOV2")         1, false, false,  1, 1,  1, 1,  0, 0}, // #56
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #57
  {DBGFIELD("WriteCMOV")          1, false, false,  1, 1,  1, 1,  0, 0}, // #58
  {DBGFIELD("WriteFCMOV")         1, false, false, 13, 1,  9, 1,  0, 0}, // #59
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  2, 1}, // #60
  {DBGFIELD("WriteFCmp64XLd_ReadAfterLd") 1, false, false,  8, 1,  5, 1,  1, 1}, // #61
  {DBGFIELD("WriteFCmp64X")       1, false, false,  9, 1,  6, 1,  0, 0}, // #62
  {DBGFIELD("WriteFCmpXLd_ReadAfterLd") 1, false, false, 10, 2,  7, 1,  1, 1}, // #63
  {DBGFIELD("WriteFCmpX")         1, false, false, 10, 2,  7, 1,  0, 0}, // #64
  {DBGFIELD("WriteFCmp64Ld_ReadAfterLd") 1, false, false, 10, 2,  7, 1,  1, 1}, // #65
  {DBGFIELD("WriteFCmp64")        1, false, false, 10, 2,  7, 1,  0, 0}, // #66
  {DBGFIELD("WriteFCmpLd_ReadAfterLd") 1, false, false, 10, 2,  7, 1,  1, 1}, // #67
  {DBGFIELD("WriteFCmp")          1, false, false, 10, 2,  7, 1,  0, 0}, // #68
  {DBGFIELD("WriteFComLd_ReadAfterLd") 1, false, false, 10, 2,  7, 1,  1, 1}, // #69
  {DBGFIELD("WriteFCom")          1, false, false, 10, 2,  7, 1,  0, 0}, // #70
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #71
  {DBGFIELD("WriteCRC32")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #72
  {DBGFIELD("WriteNop")           1, false, false,  1, 1,  1, 1,  0, 0}, // #73
  {DBGFIELD("WriteCvtI2PDLd")     1, false, false, 14, 1, 10, 1,  0, 0}, // #74
  {DBGFIELD("WriteCvtI2PD")       1, false, false,  8, 1,  5, 1,  0, 0}, // #75
  {DBGFIELD("WriteCvtI2PSLd")     1, false, false,  8, 1,  5, 1,  0, 0}, // #76
  {DBGFIELD("WriteCvtI2PS")       1, false, false,  9, 1,  6, 1,  0, 0}, // #77
  {DBGFIELD("WriteCvtPD2ILd")     1, false, false, 14, 1, 10, 1,  0, 0}, // #78
  {DBGFIELD("WriteCvtPD2I")       1, false, false,  8, 1,  5, 1,  0, 0}, // #79
  {DBGFIELD("WriteCvtPD2PSLd")    1, false, false, 14, 1, 10, 1,  0, 0}, // #80
  {DBGFIELD("WriteCvtPD2PS")      1, false, false,  8, 1,  5, 1,  0, 0}, // #81
  {DBGFIELD("WriteCvtPS2ILd")     1, false, false,  8, 1,  5, 1,  0, 0}, // #82
  {DBGFIELD("WriteCvtPS2I")       1, false, false,  9, 1,  6, 1,  0, 0}, // #83
  {DBGFIELD("WriteCvtPS2PDLd")    1, false, false, 14, 1, 10, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtPS2PD")      1, false, false,  8, 1,  5, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtSD2ILd")     1, false, false, 13, 1,  9, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtSD2I")       1, false, false, 14, 1, 10, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtSD2SSLd")    1, false, false,  8, 1,  5, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterLd") 1, false, false,  8, 1,  5, 1,  1, 1}, // #89
  {DBGFIELD("WriteCvtSD2SS")      1, false, false,  9, 1,  6, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtI2SDLd")     1, false, false,  8, 1,  5, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterLd") 1, false, false,  8, 1,  5, 1,  1, 1}, // #92
  {DBGFIELD("WriteCvtI2SD")       1, false, false,  9, 1,  6, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtI2SSLd")     1, false, false,  8, 1,  5, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterLd") 1, false, false,  8, 1,  5, 1,  1, 1}, // #95
  {DBGFIELD("WriteCvtI2SS")       1, false, false,  9, 1,  6, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtSS2SDLd")    1, false, false,  8, 1,  5, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterLd") 1, false, false,  8, 1,  5, 1,  1, 1}, // #98
  {DBGFIELD("WriteCvtSS2SD")      1, false, false,  9, 1,  6, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtSS2ILd")     1, false, false, 13, 1,  9, 1,  0, 0}, // #100
  {DBGFIELD("WriteCvtSS2I")       1, false, false, 14, 1, 10, 1,  0, 0}, // #101
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 15, 1, 11, 1,  3, 2}, // #102
  {DBGFIELD("WriteDiv16")         1, false, false, 15, 1, 11, 1,  0, 0}, // #103
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 15, 1, 11, 1,  3, 2}, // #104
  {DBGFIELD("WriteDiv32")         1, false, false, 15, 1, 11, 1,  0, 0}, // #105
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 16, 1, 12, 1,  3, 2}, // #106
  {DBGFIELD("WriteDiv64")         1, false, false, 16, 1, 12, 1,  0, 0}, // #107
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 17, 1, 13, 1,  3, 2}, // #108
  {DBGFIELD("WriteDiv8")          1, false, false, 15, 1, 11, 1,  0, 0}, // #109
  {DBGFIELD("WriteFDiv64XLd_ReadAfterLd") 1, false, false, 18, 1, 14, 1,  1, 1}, // #110
  {DBGFIELD("WriteFDiv64X")       1, false, false, 18, 1, 14, 1,  0, 0}, // #111
  {DBGFIELD("WriteFDivXLd_ReadAfterLd") 1, false, false, 19, 1, 15, 1,  1, 1}, // #112
  {DBGFIELD("WriteFDivX")         1, false, false, 19, 1, 15, 1,  0, 0}, // #113
  {DBGFIELD("WriteFDivLd")        1, false, false, 20, 1, 16, 1,  0, 0}, // #114
  {DBGFIELD("WriteFDiv")          1, false, false, 20, 1, 16, 1,  0, 0}, // #115
  {DBGFIELD("WriteFDiv64Ld_ReadAfterLd") 1, false, false, 21, 1, 17, 1,  1, 1}, // #116
  {DBGFIELD("WriteFDiv64")        1, false, false, 21, 1, 17, 1,  0, 0}, // #117
  {DBGFIELD("WriteFDivLd_ReadAfterLd") 1, false, false, 20, 1, 16, 1,  1, 1}, // #118
  {DBGFIELD("WriteDPPDLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #119
  {DBGFIELD("WriteDPPD")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #120
  {DBGFIELD("WriteDPPSLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #121
  {DBGFIELD("WriteDPPS")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #122
  {DBGFIELD("WriteVecExtractSt")  1, false, false,  6, 2,  1, 1,  0, 0}, // #123
  {DBGFIELD("WriteVecExtract")    1, false, false,  6, 2,  1, 1,  0, 0}, // #124
  {DBGFIELD("WriteVecALUX")       1, false, false,  1, 1,  1, 1,  0, 0}, // #125
  {DBGFIELD("WriteFComLd")        1, false, false, 10, 2,  7, 1,  0, 0}, // #126
  {DBGFIELD("WriteEMMS")          1, false, false, 11, 1,  7, 1,  0, 0}, // #127
  {DBGFIELD("WriteFLDC")          1, false, false, 22, 1, 18, 1,  0, 0}, // #128
  {DBGFIELD("WriteVecALUXLd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #129
  {DBGFIELD("WriteFHAddLd_ReadAfterLd") 1, false, false, 13, 1,  9, 1,  1, 1}, // #130
  {DBGFIELD("WriteFHAdd")         1, false, false, 14, 1, 10, 1,  0, 0}, // #131
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 21, 1, 17, 1,  3, 2}, // #132
  {DBGFIELD("WriteIDiv16")        1, false, false, 21, 1, 17, 1,  0, 0}, // #133
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 21, 1, 17, 1,  3, 2}, // #134
  {DBGFIELD("WriteIDiv32")        1, false, false, 21, 1, 17, 1,  0, 0}, // #135
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 16, 1, 12, 1,  3, 2}, // #136
  {DBGFIELD("WriteIDiv64")        1, false, false, 16, 1, 12, 1,  0, 0}, // #137
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 21, 1, 17, 1,  3, 2}, // #138
  {DBGFIELD("WriteIDiv8")         1, false, false, 21, 1, 17, 1,  0, 0}, // #139
  {DBGFIELD("WriteIMulLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false,  8, 1,  5, 1,  3, 2}, // #140
  {DBGFIELD("WriteIMul")          1, false, false,  8, 1,  5, 1,  0, 0}, // #141
  {DBGFIELD("WriteIMulLd_ReadAfterLd") 1, false, false,  8, 1,  5, 1,  1, 1}, // #142
  {DBGFIELD("WriteIMulLd")        1, false, false,  8, 1,  5, 1,  0, 0}, // #143
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 23, 1, 19, 1,  3, 2}, // #144
  {DBGFIELD("WriteIMul64")        1, false, false, 23, 1, 19, 1,  0, 0}, // #145
  {DBGFIELD("WriteIMul64Ld_ReadAfterLd") 1, false, false, 23, 1, 19, 1,  1, 1}, // #146
  {DBGFIELD("WriteIMul64Ld")      1, false, false, 23, 1, 19, 1,  0, 0}, // #147
  {DBGFIELD("WriteFShuffleLd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #148
  {DBGFIELD("WriteFShuffle")      1, false, false,  6, 2,  1, 1,  0, 0}, // #149
  {DBGFIELD("WriteStore")         1, false, false,  6, 2,  1, 1,  0, 0}, // #150
  {DBGFIELD("WriteVecLogicX")     1, false, false,  1, 1,  1, 1,  0, 0}, // #151
  {DBGFIELD("WriteShuffle")       1, false, false,  6, 2,  1, 1,  0, 0}, // #152
  {DBGFIELD("WriteLAHFSAHF")      1, false, false,  3, 1, 20, 1,  0, 0}, // #153
  {DBGFIELD("WriteVecLoadX")      1, false, false,  6, 2,  1, 1,  0, 0}, // #154
  {DBGFIELD("WriteLDMXCSR")       1, false, false, 11, 1,  7, 1,  0, 0}, // #155
  {DBGFIELD("WriteFLD0")          1, false, false,  1, 1,  1, 1,  0, 0}, // #156
  {DBGFIELD("WriteFLD1")          1, false, false,  9, 1,  6, 1,  0, 0}, // #157
  {DBGFIELD("WriteLEA")           1, false, false,  4, 2,  1, 1,  0, 0}, // #158
  {DBGFIELD("WriteFence")         1, false, false,  6, 2,  1, 1,  0, 0}, // #159
  {DBGFIELD("WriteLZCNTLd")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #160
  {DBGFIELD("WriteLZCNT")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #161
  {DBGFIELD("WriteVecStoreX")     1, false, false,  6, 2,  1, 1,  0, 0}, // #162
  {DBGFIELD("WriteVecStore")      1, false, false,  6, 2,  1, 1,  0, 0}, // #163
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, 24, 2, 21, 1,  0, 0}, // #164
  {DBGFIELD("WriteVecLoad")       1, false, false,  6, 2,  1, 1,  0, 0}, // #165
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #166
  {DBGFIELD("WriteVecMoveX")      1, false, false,  1, 1,  1, 1,  0, 0}, // #167
  {DBGFIELD("WriteVecStoreNT")    1, false, false,  6, 2,  1, 1,  0, 0}, // #168
  {DBGFIELD("WriteVecMove")       1, false, false,  6, 2,  1, 1,  0, 0}, // #169
  {DBGFIELD("WriteVecALULd")      1, false, false,  6, 2,  1, 1,  0, 0}, // #170
  {DBGFIELD("WriteShuffleLd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #171
  {DBGFIELD("WriteVecALULd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #172
  {DBGFIELD("WriteVecLogicLd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #173
  {DBGFIELD("WriteVecLogic")      1, false, false,  1, 1,  1, 1,  0, 0}, // #174
  {DBGFIELD("WritePHAddLd_ReadAfterLd") 1, false, false, 26, 1, 22, 1,  1, 1}, // #175
  {DBGFIELD("WritePHAdd")         1, false, false, 25, 1, 21, 1,  0, 0}, // #176
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #177
  {DBGFIELD("WriteVecInsert")     1, false, false,  6, 2,  1, 1,  0, 0}, // #178
  {DBGFIELD("WriteVecIMulLd_ReadAfterLd") 1, false, false, 27, 2, 22, 1,  1, 1}, // #179
  {DBGFIELD("WriteVecIMul")       1, false, false, 27, 2, 22, 1,  0, 0}, // #180
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, 24, 2, 21, 1,  0, 0}, // #181
  {DBGFIELD("WritePSADBWLd_ReadAfterLd") 1, false, false, 26, 1, 22, 1,  1, 1}, // #182
  {DBGFIELD("WritePSADBW")        1, false, false, 26, 1, 22, 1,  0, 0}, // #183
  {DBGFIELD("WriteVarShuffleLd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #184
  {DBGFIELD("WriteVarShuffle")    1, false, false,  6, 2,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteShuffleLd")     1, false, false,  6, 2,  1, 1,  0, 0}, // #186
  {DBGFIELD("WriteVecShiftImm")   1, false, false,  1, 1,  1, 1,  0, 0}, // #187
  {DBGFIELD("WriteVecShiftLd_ReadAfterLd") 1, false, false, 25, 1, 21, 1,  1, 1}, // #188
  {DBGFIELD("WriteVecShift")      1, false, false,  3, 1, 20, 1,  0, 0}, // #189
  {DBGFIELD("WriteFMoveX")        1, false, false,  1, 1,  1, 1,  0, 0}, // #190
  {DBGFIELD("WriteFShuffleLd")    1, false, false,  6, 2,  1, 1,  0, 0}, // #191
  {DBGFIELD("WriteFStore")        1, false, false,  6, 2,  1, 1,  0, 0}, // #192
  {DBGFIELD("WriteFMOVMSK")       1, false, false, 24, 2, 21, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecLoadNT")     1, false, false,  6, 2,  1, 1,  0, 0}, // #194
  {DBGFIELD("WriteStoreNT")       1, false, false,  6, 2,  1, 1,  0, 0}, // #195
  {DBGFIELD("WriteFStoreNTX")     1, false, false,  6, 2,  1, 1,  0, 0}, // #196
  {DBGFIELD("WriteFStoreNT")      1, false, false,  6, 2,  1, 1,  0, 0}, // #197
  {DBGFIELD("WriteFLoad")         1, false, false,  6, 2,  1, 1,  0, 0}, // #198
  {DBGFIELD("WriteMPSADLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #199
  {DBGFIELD("WriteMPSAD")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #200
  {DBGFIELD("WriteFMul64XLd_ReadAfterLd") 1, false, false, 22, 1, 18, 1,  1, 1}, // #201
  {DBGFIELD("WriteFMul64X")       1, false, false, 13, 1,  9, 1,  0, 0}, // #202
  {DBGFIELD("WriteFMulXLd_ReadAfterLd") 1, false, false, 10, 2,  7, 1,  1, 1}, // #203
  {DBGFIELD("WriteFMulX")         1, false, false, 10, 2,  7, 1,  0, 0}, // #204
  {DBGFIELD("WriteFMul64Ld_ReadAfterLd") 1, false, false, 10, 2,  7, 1,  1, 1}, // #205
  {DBGFIELD("WriteFMul64")        1, false, false, 10, 2,  7, 1,  0, 0}, // #206
  {DBGFIELD("WriteFMulLd_ReadAfterLd") 1, false, false, 27, 2, 22, 1,  1, 1}, // #207
  {DBGFIELD("WriteFMul")          1, false, false, 27, 2, 22, 1,  0, 0}, // #208
  {DBGFIELD("WriteIMulLd_WriteIMulH") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #209
  {DBGFIELD("WriteIMul_WriteIMulH") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #210
  {DBGFIELD("WriteIMul64Ld_WriteIMulH") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #211
  {DBGFIELD("WriteIMul64_WriteIMulH") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #212
  {DBGFIELD("WriteFMulLd")        1, false, false, 27, 2, 22, 1,  0, 0}, // #213
  {DBGFIELD("WriteVecALUXLd")     1, false, false,  6, 2,  1, 1,  0, 0}, // #214
  {DBGFIELD("WriteShuffleXLd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #215
  {DBGFIELD("WriteShuffleX")      1, false, false,  6, 2,  1, 1,  0, 0}, // #216
  {DBGFIELD("WriteVecLogicXLd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #217
  {DBGFIELD("WriteVarBlendLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #218
  {DBGFIELD("WriteVarBlend")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #219
  {DBGFIELD("WriteBlendLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #220
  {DBGFIELD("WriteBlend")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #221
  {DBGFIELD("WriteCLMulLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #222
  {DBGFIELD("WriteCLMul")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #223
  {DBGFIELD("WritePCmpEStrILd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #224
  {DBGFIELD("WritePCmpEStrI")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #225
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #226
  {DBGFIELD("WritePCmpEStrM")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #227
  {DBGFIELD("WritePCmpIStrILd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #228
  {DBGFIELD("WritePCmpIStrI")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #229
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #230
  {DBGFIELD("WritePCmpIStrM")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #231
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterLd") 1, false, false,  8, 1,  5, 1,  1, 1}, // #232
  {DBGFIELD("WritePHAddXLd_ReadAfterLd") 1, false, false, 14, 1, 10, 1,  1, 1}, // #233
  {DBGFIELD("WritePHAddX")        1, false, false,  8, 1,  5, 1,  0, 0}, // #234
  {DBGFIELD("WritePHMINPOSLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #235
  {DBGFIELD("WritePHMINPOS")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #236
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterLd") 1, false, false,  8, 1,  5, 1,  1, 1}, // #237
  {DBGFIELD("WriteVecIMulXLd_ReadAfterLd") 1, false, false, 10, 2,  7, 1,  1, 1}, // #238
  {DBGFIELD("WriteVecIMulX")      1, false, false, 10, 2,  7, 1,  0, 0}, // #239
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, 24, 2, 21, 1,  0, 0}, // #240
  {DBGFIELD("WriteShuffleXLd")    1, false, false,  6, 2,  1, 1,  0, 0}, // #241
  {DBGFIELD("WritePMULLDLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #242
  {DBGFIELD("WritePMULLD")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #243
  {DBGFIELD("WriteRMW")           1, false, false,  6, 2,  1, 1,  0, 0}, // #244
  {DBGFIELD("WritePOPCNTLd")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #245
  {DBGFIELD("WritePOPCNT")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #246
  {DBGFIELD("WritePSADBWXLd_ReadAfterLd") 1, false, false, 10, 2,  7, 1,  1, 1}, // #247
  {DBGFIELD("WritePSADBWX")       1, false, false, 10, 2,  7, 1,  0, 0}, // #248
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterLd") 1, false, false, 11, 1,  7, 1,  1, 1}, // #249
  {DBGFIELD("WriteVarShuffleX")   1, false, false, 26, 1, 22, 1,  0, 0}, // #250
  {DBGFIELD("WriteVecShiftImmX")  1, false, false,  1, 1,  1, 1,  0, 0}, // #251
  {DBGFIELD("WriteVecShiftXLd_ReadAfterLd") 1, false, false, 25, 1, 21, 1,  1, 1}, // #252
  {DBGFIELD("WriteVecShiftX")     1, false, false,  3, 1, 20, 1,  0, 0}, // #253
  {DBGFIELD("WriteVecTestLd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #254
  {DBGFIELD("WriteVecTest")       1, false, false,  1, 1,  1, 1,  0, 0}, // #255
  {DBGFIELD("WriteShiftLd_WriteRMW") 2, false, false,  2, 2,  1, 2,  0, 0}, // #256
  {DBGFIELD("WriteShift")         1, false, false,  6, 2,  1, 1,  0, 0}, // #257
  {DBGFIELD("WriteFRcpXLd")       1, false, false, 22, 1, 18, 1,  0, 0}, // #258
  {DBGFIELD("WriteFRcpX")         1, false, false, 13, 1,  9, 1,  0, 0}, // #259
  {DBGFIELD("WriteFRcpLd_ReadAfterLd") 1, false, false, 27, 2, 22, 1,  1, 1}, // #260
  {DBGFIELD("WriteFRcp")          1, false, false, 27, 2, 22, 1,  0, 0}, // #261
  {DBGFIELD("WriteShiftLd")       1, false, false,  6, 2,  1, 1,  0, 0}, // #262
  {DBGFIELD("WriteFRndLd")        1, false, false, 10, 2,  7, 1,  0, 0}, // #263
  {DBGFIELD("WriteFRnd")          1, false, false, 10, 2,  7, 1,  0, 0}, // #264
  {DBGFIELD("WriteFRndLd_ReadAfterLd") 1, false, false, 10, 2,  7, 1,  1, 1}, // #265
  {DBGFIELD("WriteFRsqrtXLd")     1, false, false, 22, 1, 18, 1,  0, 0}, // #266
  {DBGFIELD("WriteFRsqrtX")       1, false, false, 13, 1,  9, 1,  0, 0}, // #267
  {DBGFIELD("WriteFRsqrtLd_ReadAfterLd") 1, false, false, 27, 2, 22, 1,  1, 1}, // #268
  {DBGFIELD("WriteFRsqrt")        1, false, false, 27, 2, 22, 1,  0, 0}, // #269
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  2, 1}, // #270
  {DBGFIELD("WriteSETCCStore")    1, false, false,  3, 1, 20, 1,  0, 0}, // #271
  {DBGFIELD("WriteSETCC")         1, false, false,  1, 1,  1, 1,  0, 0}, // #272
  {DBGFIELD("WriteSHDmrcl")       1, false, false, 26, 1, 22, 1,  0, 0}, // #273
  {DBGFIELD("WriteSHDmri")        1, false, false, 26, 1, 22, 1,  0, 0}, // #274
  {DBGFIELD("WriteSHDrrcl")       1, false, false,  3, 1, 20, 1,  0, 0}, // #275
  {DBGFIELD("WriteSHDrri")        1, false, false,  3, 1, 20, 1,  0, 0}, // #276
  {DBGFIELD("WriteFSqrt64XLd")    1, false, false, 18, 1, 14, 1,  0, 0}, // #277
  {DBGFIELD("WriteFSqrt64X")      1, false, false, 18, 1, 14, 1,  0, 0}, // #278
  {DBGFIELD("WriteFSqrtXLd")      1, false, false, 19, 1, 15, 1,  0, 0}, // #279
  {DBGFIELD("WriteFSqrtX")        1, false, false, 19, 1, 15, 1,  0, 0}, // #280
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterLd") 1, false, false, 21, 1, 17, 1,  1, 1}, // #281
  {DBGFIELD("WriteFSqrt64")       1, false, false, 21, 1, 17, 1,  0, 0}, // #282
  {DBGFIELD("WriteFSqrtLd_ReadAfterLd") 1, false, false, 20, 1, 16, 1,  1, 1}, // #283
  {DBGFIELD("WriteFSqrt")         1, false, false, 20, 1, 16, 1,  0, 0}, // #284
  {DBGFIELD("WriteFSqrt80")       1, false, false, 29, 1, 23, 1,  0, 0}, // #285
  {DBGFIELD("WriteSTMXCSR")       1, false, false, 30, 1, 24, 1,  0, 0}, // #286
  {DBGFIELD("WriteTZCNTLd")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #287
  {DBGFIELD("WriteTZCNT")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #288
  {DBGFIELD("WriteFMAZLd")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #289
  {DBGFIELD("WriteFMALd")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #290
  {DBGFIELD("WriteFAdd64YLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #291
  {DBGFIELD("WriteFAdd64Y")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #292
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #293
  {DBGFIELD("WriteFAdd64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #294
  {DBGFIELD("WriteFAddYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #295
  {DBGFIELD("WriteFAddY")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #296
  {DBGFIELD("WriteFAddZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #297
  {DBGFIELD("WriteFAddZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #298
  {DBGFIELD("WriteShuffleYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #299
  {DBGFIELD("WriteShuffleY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #300
  {DBGFIELD("WriteShuffleZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #301
  {DBGFIELD("WriteShuffleZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #302
  {DBGFIELD("WriteFLogicYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #303
  {DBGFIELD("WriteFLogicY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #304
  {DBGFIELD("WriteFLogicZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #305
  {DBGFIELD("WriteFLogicZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #306
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #307
  {DBGFIELD("WriteFVarBlendY")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #308
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #309
  {DBGFIELD("WriteFVarBlendZ")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #310
  {DBGFIELD("WriteFBlendYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #311
  {DBGFIELD("WriteFBlendY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #312
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #313
  {DBGFIELD("WriteFVarBlendLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #314
  {DBGFIELD("WriteShuffle256Ld")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #315
  {DBGFIELD("WriteShuffle256")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #316
  {DBGFIELD("WriteShuffleYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #317
  {DBGFIELD("WriteFShuffle256")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #318
  {DBGFIELD("WriteFShuffle256Ld") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #319
  {DBGFIELD("WriteFCmp64YLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #320
  {DBGFIELD("WriteFCmp64Y")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #321
  {DBGFIELD("WriteFCmpYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #322
  {DBGFIELD("WriteFCmpY")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #323
  {DBGFIELD("WriteFCmpZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #324
  {DBGFIELD("WriteFCmpZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #325
  {DBGFIELD("WriteVarShuffle256Ld") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #326
  {DBGFIELD("WriteVarShuffle256") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #327
  {DBGFIELD("WriteCvtI2PDYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #328
  {DBGFIELD("WriteCvtI2PDY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #329
  {DBGFIELD("WriteCvtI2PDZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #330
  {DBGFIELD("WriteCvtI2PDZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #331
  {DBGFIELD("WriteCvtI2PSYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #332
  {DBGFIELD("WriteCvtI2PSY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD("WriteCvtI2PSZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #334
  {DBGFIELD("WriteCvtI2PSZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #335
  {DBGFIELD("WriteCvtPD2IYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #336
  {DBGFIELD("WriteCvtPD2IY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #337
  {DBGFIELD("WriteCvtPD2IZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("WriteCvtPD2IZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #339
  {DBGFIELD("WriteCvtPD2PSYLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #340
  {DBGFIELD("WriteCvtPD2PSY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #341
  {DBGFIELD("WriteCvtPD2PSZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD("WriteCvtPD2PSZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #343
  {DBGFIELD("WriteCvtPH2PSYLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #344
  {DBGFIELD("WriteCvtPH2PSY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #345
  {DBGFIELD("WriteCvtPH2PSLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #346
  {DBGFIELD("WriteCvtPH2PS")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #347
  {DBGFIELD("WriteCvtPH2PSZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #348
  {DBGFIELD("WriteCvtPH2PSZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #349
  {DBGFIELD("WriteCvtPS2IYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #350
  {DBGFIELD("WriteCvtPS2IY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #351
  {DBGFIELD("WriteCvtPS2IZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #352
  {DBGFIELD("WriteCvtPS2IZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #353
  {DBGFIELD("WriteCvtPS2PDYLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #354
  {DBGFIELD("WriteCvtPS2PDY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #355
  {DBGFIELD("WriteCvtPS2PDZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #356
  {DBGFIELD("WriteCvtPS2PDZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #357
  {DBGFIELD("WriteCvtPS2PHYSt")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #358
  {DBGFIELD("WriteCvtPS2PHY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #359
  {DBGFIELD("WriteCvtPS2PHSt")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #360
  {DBGFIELD("WriteCvtPS2PH")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #361
  {DBGFIELD("WriteCvtPS2PHZSt")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #362
  {DBGFIELD("WriteCvtPS2PHZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #363
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterLd") 1, false, false, 13, 1,  9, 1,  1, 1}, // #364
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterLd") 1, false, false, 13, 1,  9, 1,  1, 1}, // #365
  {DBGFIELD("WritePSADBWYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #366
  {DBGFIELD("WritePSADBWY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #367
  {DBGFIELD("WritePSADBWZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #368
  {DBGFIELD("WritePSADBWZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #369
  {DBGFIELD("WriteFDiv64YLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #370
  {DBGFIELD("WriteFDiv64Y")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #371
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #372
  {DBGFIELD("WriteFDiv64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #373
  {DBGFIELD("WriteFDivYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #374
  {DBGFIELD("WriteFDivY")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("WriteFDivZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #376
  {DBGFIELD("WriteFDivZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #377
  {DBGFIELD("WriteDPPSYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #378
  {DBGFIELD("WriteDPPSY")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteFMAYLd_ReadAfterLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #381
  {DBGFIELD("WriteFMAY")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #382
  {DBGFIELD("WriteFMAXLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #383
  {DBGFIELD("WriteFMAX")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #384
  {DBGFIELD("WriteFMAYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #385
  {DBGFIELD("WriteFMAZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #386
  {DBGFIELD("WriteFMAZ")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #387
  {DBGFIELD("WriteFMAXLd_ReadAfterLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #388
  {DBGFIELD("WriteFMALd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #389
  {DBGFIELD("WriteFMA")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #390
  {DBGFIELD("WriteFMALd_ReadAfterLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #391
  {DBGFIELD("WriteFMAYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #392
  {DBGFIELD("WriteFMAXLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteFMALd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteFRndYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #395
  {DBGFIELD("WriteFRndY")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #396
  {DBGFIELD("WriteFRndZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #397
  {DBGFIELD("WriteFRndZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #398
  {DBGFIELD("WriteVecIMulYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WriteVecIMulY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #400
  {DBGFIELD("WriteVecIMulZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #401
  {DBGFIELD("WriteVecIMulZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #402
  {DBGFIELD("WriteVecALUYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #403
  {DBGFIELD("WriteVecALUY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #404
  {DBGFIELD("WriteVecALUZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteVecALUZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #406
  {DBGFIELD("WriteFHAddYLd_ReadAfterLd") 1, false, false, 13, 1,  9, 1,  1, 1}, // #407
  {DBGFIELD("WriteFHAddY")        1, false, false, 14, 1, 10, 1,  0, 0}, // #408
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #409
  {DBGFIELD("WriteShuffle256Ld_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #410
  {DBGFIELD("WriteVecLoadY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #411
  {DBGFIELD("WriteFMaskedStoreY") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #412
  {DBGFIELD("WriteFMaskedLoadY")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #413
  {DBGFIELD("WriteFMaskedStore")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #414
  {DBGFIELD("WriteFMaskedLoad")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #415
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #416
  {DBGFIELD("WriteFCmp64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #417
  {DBGFIELD("WriteFMoveY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #418
  {DBGFIELD("WriteFShuffleYLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #419
  {DBGFIELD("WriteFShuffleY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #420
  {DBGFIELD("WriteFShuffleZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #421
  {DBGFIELD("WriteFShuffleZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #422
  {DBGFIELD("WriteVecStoreY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #423
  {DBGFIELD("WriteVecMoveY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #424
  {DBGFIELD("WriteVecLoadNTY")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteVecStoreNTY")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #426
  {DBGFIELD("WriteFStoreNTY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #427
  {DBGFIELD("WriteMPSADYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #428
  {DBGFIELD("WriteMPSADY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #429
  {DBGFIELD("WriteFMul64YLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #430
  {DBGFIELD("WriteFMul64Y")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #431
  {DBGFIELD("WriteFMul64ZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #432
  {DBGFIELD("WriteFMul64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #433
  {DBGFIELD("WriteFMulYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #434
  {DBGFIELD("WriteFMulY")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #435
  {DBGFIELD("WriteFMulZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #436
  {DBGFIELD("WriteFMulZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #437
  {DBGFIELD("WriteVecALUYLd")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #438
  {DBGFIELD("WriteVecALUZLd")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #439
  {DBGFIELD("WriteVecLogicYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #440
  {DBGFIELD("WriteVecLogicY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteVecLogicZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("WriteVecLogicZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #443
  {DBGFIELD("WriteBlendYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #444
  {DBGFIELD("WriteBlendY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #445
  {DBGFIELD("WriteVarBlendYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #446
  {DBGFIELD("WriteVarBlendY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #447
  {DBGFIELD("WriteVarBlendZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #448
  {DBGFIELD("WriteVarBlendZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #449
  {DBGFIELD("WriteVarBlendYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #450
  {DBGFIELD("WriteVarBlendLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #451
  {DBGFIELD("WriteShuffleYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #452
  {DBGFIELD("WriteShuffleYLd_ReadAfterLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #453
  {DBGFIELD("WriteShuffleXLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  5, 2}, // #454
  {DBGFIELD("WriteShuffleXLd_ReadAfterLd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  7, 2}, // #455
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #456
  {DBGFIELD("WriteFVarShuffle256") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #457
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #458
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #459
  {DBGFIELD("WriteFVarShuffleY")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #460
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #461
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #462
  {DBGFIELD("WriteFVarShuffle")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #463
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #464
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #465
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #466
  {DBGFIELD("WriteFVarShuffleZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #467
  {DBGFIELD("WritePHAddYLd_ReadAfterLd") 1, false, false, 14, 1, 10, 1,  1, 1}, // #468
  {DBGFIELD("WritePHAddY")        1, false, false,  8, 1,  5, 1,  0, 0}, // #469
  {DBGFIELD("WriteVecIMulXLd")    1, false, false, 10, 2,  7, 1,  0, 0}, // #470
  {DBGFIELD("WriteVecIMulYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #471
  {DBGFIELD("WriteVecIMulZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #472
  {DBGFIELD("WriteVecMaskedStoreY") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #473
  {DBGFIELD("WriteVecMaskedLoadY") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #474
  {DBGFIELD("WriteVecMaskedStore") 1, false, false,  6, 2,  1, 1,  0, 0}, // #475
  {DBGFIELD("WriteVecMaskedLoad") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #476
  {DBGFIELD("WriteVecMOVMSKY")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #477
  {DBGFIELD("WritePMULLDYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #478
  {DBGFIELD("WritePMULLDY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #479
  {DBGFIELD("WritePMULLDZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WritePMULLDZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #481
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, 11, 1,  7, 1,  5, 2}, // #482
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterLd_ReadAfterLd") 1, false, false, 11, 1,  7, 1,  7, 2}, // #483
  {DBGFIELD("WriteVecShiftImmXLd") 1, false, false,  1, 1,  1, 1,  0, 0}, // #484
  {DBGFIELD("WriteVecShiftImmYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #485
  {DBGFIELD("WriteVecShiftImmY")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #486
  {DBGFIELD("WriteVecShiftImmZLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteVecShiftImmZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #488
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #489
  {DBGFIELD("WriteVarVecShift")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #491
  {DBGFIELD("WriteVarVecShiftY")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #492
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #493
  {DBGFIELD("WriteVarVecShiftZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #494
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterLd") 1, false, false,  1, 1,  1, 1,  1, 1}, // #495
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD("WriteVarShuffleY")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #498
  {DBGFIELD("WriteVarShuffleZ")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #499
  {DBGFIELD("WriteShuffleZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #500
  {DBGFIELD("WriteVecShiftYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #501
  {DBGFIELD("WriteVecShiftY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #502
  {DBGFIELD("WriteVecShiftZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #503
  {DBGFIELD("WriteVecShiftZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #504
  {DBGFIELD("WriteVecTestYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #505
  {DBGFIELD("WriteVecTestY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #506
  {DBGFIELD("WriteFRcpXLd_ReadAfterLd") 1, false, false, 22, 1, 18, 1,  1, 1}, // #507
  {DBGFIELD("WriteFRcpYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #508
  {DBGFIELD("WriteFRcpY")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #509
  {DBGFIELD("WriteFRcpZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #510
  {DBGFIELD("WriteFRcpZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #511
  {DBGFIELD("WriteFRcpYLd")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #512
  {DBGFIELD("WriteFRndYLd")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #513
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterLd") 1, false, false, 22, 1, 18, 1,  1, 1}, // #514
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #515
  {DBGFIELD("WriteFRsqrtY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #516
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #517
  {DBGFIELD("WriteFRsqrtZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #518
  {DBGFIELD("WriteFRsqrtYLd")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #519
  {DBGFIELD("WriteFShuffleYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #520
  {DBGFIELD("WriteFShuffleZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #521
  {DBGFIELD("WriteFSqrt64YLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #522
  {DBGFIELD("WriteFSqrt64Y")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #523
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterLd") 1, false, false, 18, 1, 14, 1,  1, 1}, // #524
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #525
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #526
  {DBGFIELD("WriteFSqrt64Z")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #527
  {DBGFIELD("WriteFSqrtYLd")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #528
  {DBGFIELD("WriteFSqrtY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #529
  {DBGFIELD("WriteFSqrtXLd_ReadAfterLd") 1, false, false, 19, 1, 15, 1,  1, 1}, // #530
  {DBGFIELD("WriteFSqrtYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #531
  {DBGFIELD("WriteFSqrtZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #532
  {DBGFIELD("WriteFSqrtZ")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WriteFTestYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #534
  {DBGFIELD("WriteFTestY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #535
  {DBGFIELD("WriteFTestLd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #536
  {DBGFIELD("WriteFTest")         1, false, false,  1, 1,  1, 1,  0, 0}, // #537
  {DBGFIELD("MUL16m_IMUL16m")     1, false, false, 14, 1, 10, 1,  0, 0}, // #538
  {DBGFIELD("MUL32r_IMUL32r")     1, false, false,  9, 1,  6, 1,  0, 0}, // #539
  {DBGFIELD("IMUL64rri8_IMUL64rri32") 1, false, false, 31, 1, 25, 1,  0, 0}, // #540
  {DBGFIELD("IMUL64rmi8_IMUL64rmi32") 1, false, false, 31, 1, 25, 1,  0, 0}, // #541
  {DBGFIELD("COPY")               1, false, false,  1, 1,  1, 1,  0, 0}, // #542
  {DBGFIELD("FXAM")               1, false, false,  6, 2,  1, 1,  0, 0}, // #543
  {DBGFIELD("LD_Frr")             1, false, false,  6, 2,  1, 1,  0, 0}, // #544
  {DBGFIELD("MOVSX64rr32")        1, false, false,  6, 2,  1, 1,  0, 0}, // #545
  {DBGFIELD("RCL16m1_RCL16mCL_RCL16mi_RCL32m1_RCL32mCL_RCL32mi_RCL64m1_RCL64mCL_RCL64mi_RCL8m1_RCL8mCL_RCL8mi_RCR16m1_RCR16mCL_RCR16mi_RCR32m1_RCR32mCL_RCR32mi_RCR64m1_RCR64mCL_RCR64mi_RCR8m1_RCR8mCL_RCR8mi_ROL16m1_ROL16mCL_ROL16mi_ROL32m1_ROL32mCL_ROL32mi_ROL64m1_ROL64mCL_ROL64mi_ROL8m1_ROL8mCL_ROL8mi_ROR16m1_ROR16mCL_ROR16mi_ROR32m1_ROR32mCL_ROR32mi_ROR64m1_ROR64mCL_ROR64mi_ROR8m1_ROR8mCL_ROR8mi_SAR16m1_SAR16mCL_SAR16mi_SAR32m1_SAR32mCL_SAR32mi_SAR64m1_SAR64mCL_SAR64mi_SAR8m1_SAR8mCL_SAR8mi_SHL16m1_SHL16mCL_SHL16mi_SHL32m1_SHL32mCL_SHL32mi_SHL64m1_SHL64mCL_SHL64mi_SHL8m1_SHL8mCL_SHL8mi_SHR16m1_SHR16mCL_SHR16mi_SHR32m1_SHR32mCL_SHR32mi_SHR64m1_SHR64mCL_SHR64mi_SHR8m1_SHR8mCL_SHR8mi") 1, false, false,  6, 2,  1, 1,  0, 0}, // #546
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false,  6, 2,  1, 1,  0, 0}, // #547
  {DBGFIELD("IMUL32rm")           1, false, false, 10, 2,  7, 1,  0, 0}, // #548
  {DBGFIELD("IMUL32rmi_IMUL32rmi8") 1, false, false, 10, 2,  7, 1,  0, 0}, // #549
  {DBGFIELD("IMUL32rr_IMUL32rri_IMUL32rri8") 1, false, false, 10, 2,  7, 1,  0, 0}, // #550
  {DBGFIELD("FCOMPP")             1, false, false,  4, 2,  1, 1,  0, 0}, // #551
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false,  4, 2,  1, 1,  0, 0}, // #552
  {DBGFIELD("BT16ri8_BT16rr_BT32ri8_BT32rr_BT64ri8_BT64rr_BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 1, false, false,  4, 2,  1, 1,  0, 0}, // #553
  {DBGFIELD("MMX_CVTPI2PSirr")    1, false, false, 32, 2,  7, 1,  0, 0}, // #554
  {DBGFIELD("MMX_CVTPI2PSirm")    1, false, false, 32, 2,  7, 1,  0, 0}, // #555
  {DBGFIELD("MMX_CVTPS2PIirr_MMX_CVTTPS2PIirr") 1, false, false, 32, 2,  7, 1,  0, 0}, // #556
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, 34, 3,  1, 1,  0, 0}, // #557
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, 34, 3,  1, 1,  0, 0}, // #558
  {DBGFIELD("XCH_F")              1, false, false, 34, 3,  1, 1,  0, 0}, // #559
  {DBGFIELD("RETIL_RETIQ_RETIW_IRET_IRET16_IRET32_IRET64") 1, false, false, 34, 3,  1, 1,  0, 0}, // #560
  {DBGFIELD("MMX_CVTPS2PIirm_MMX_CVTTPS2PIirm") 1, false, false, 37, 3,  7, 1,  0, 0}, // #561
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 1, false, false, 37, 3,  7, 1,  0, 0}, // #562
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 1, false, false,  1, 1,  1, 1,  0, 0}, // #563
  {DBGFIELD("LFENCE")             1, false, false,  1, 1,  1, 1,  0, 0}, // #564
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false,  1, 1,  1, 1,  0, 0}, // #565
  {DBGFIELD("PSLLDQri_PSRLDQri")  1, false, false,  1, 1,  1, 1,  0, 0}, // #566
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr_MMX_PUNPCKHBWirr_MMX_PUNPCKHDQirr_MMX_PUNPCKHWDirr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #567
  {DBGFIELD("LEAVE_LEAVE64")      1, false, false,  3, 1, 20, 1,  0, 0}, // #568
  {DBGFIELD("POP16r")             1, false, false,  3, 1, 20, 1,  0, 0}, // #569
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 1, false, false,  3, 1, 20, 1,  0, 0}, // #570
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false,  3, 1, 20, 1,  0, 0}, // #571
  {DBGFIELD("BTC16mi8_BTC32mi8_BTC64mi8_BTR16mi8_BTR32mi8_BTR64mi8_BTS16mi8_BTS32mi8_BTS64mi8") 1, false, false,  3, 1, 20, 1,  0, 0}, // #572
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false,  3, 1, 20, 1,  0, 0}, // #573
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr_XCHG16ar_XCHG16rr_XCHG32ar_XCHG32rr_XCHG64ar_XCHG64rr_XCHG8rr_MOVSX16rr8_MOVZX16rr8") 1, false, false,  3, 1, 20, 1,  0, 0}, // #574
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false,  3, 1, 20, 1,  0, 0}, // #575
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false,  3, 1, 20, 1,  0, 0}, // #576
  {DBGFIELD("MMX_PADDQirr_MMX_PSUBQirr") 1, false, false,  3, 1, 20, 1,  0, 0}, // #577
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 1, false, false,  3, 1, 20, 1,  0, 0}, // #578
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  1, false, false,  3, 1, 20, 1,  0, 0}, // #579
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false,  3, 1, 20, 1,  0, 0}, // #580
  {DBGFIELD("CLD")                1, false, false, 25, 1, 21, 1,  0, 0}, // #581
  {DBGFIELD("LDDQUrm")            1, false, false, 25, 1, 21, 1,  0, 0}, // #582
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, 25, 1, 21, 1,  0, 0}, // #583
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 1, false, false, 25, 1, 21, 1,  0, 0}, // #584
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 1, false, false, 25, 1, 21, 1,  0, 0}, // #585
  {DBGFIELD("PHADDDrr_PHSUBDrr")  1, false, false, 25, 1, 21, 1,  0, 0}, // #586
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, 25, 1, 21, 1,  0, 0}, // #587
  {DBGFIELD("MMX_PADDQirm_MMX_PSUBQirm") 1, false, false, 25, 1, 21, 1,  0, 0}, // #588
  {DBGFIELD("MOVDQUrm")           1, false, false, 25, 1, 21, 1,  0, 0}, // #589
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, 25, 1, 21, 1,  0, 0}, // #590
  {DBGFIELD("PADDQrm_PSUBQrm")    1, false, false, 25, 1, 21, 1,  0, 0}, // #591
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, 26, 1, 22, 1,  0, 0}, // #592
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   1, false, false, 26, 1, 22, 1,  0, 0}, // #593
  {DBGFIELD("LD_F80m")            1, false, false, 26, 1, 22, 1,  0, 0}, // #594
  {DBGFIELD("PHADDDrm_PHSUBDrm")  1, false, false, 26, 1, 22, 1,  0, 0}, // #595
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 1, false, false, 26, 1, 22, 1,  0, 0}, // #596
  {DBGFIELD("FLDCW16m")           1, false, false, 11, 1,  7, 1,  0, 0}, // #597
  {DBGFIELD("ST_FP80m")           1, false, false, 11, 1,  7, 1,  0, 0}, // #598
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 1, false, false, 11, 1,  7, 1,  0, 0}, // #599
  {DBGFIELD("CMPXCHG8rm")         1, false, false,  9, 1,  6, 1,  0, 0}, // #600
  {DBGFIELD("INTO")               1, false, false,  9, 1,  6, 1,  0, 0}, // #601
  {DBGFIELD("XLAT")               1, false, false,  9, 1,  6, 1,  0, 0}, // #602
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 1, false, false,  9, 1,  6, 1,  0, 0}, // #603
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false,  9, 1,  6, 1,  0, 0}, // #604
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 1, false, false,  9, 1,  6, 1,  0, 0}, // #605
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 1, false, false,  9, 1,  6, 1,  0, 0}, // #606
  {DBGFIELD("IMUL16rr_IMUL16rri_IMUL16rri8") 1, false, false,  9, 1,  6, 1,  0, 0}, // #607
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 1, false, false,  9, 1,  6, 1,  0, 0}, // #608
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 1, false, false,  9, 1,  6, 1,  0, 0}, // #609
  {DBGFIELD("AAD8i8")             1, false, false,  8, 1,  5, 1,  0, 0}, // #610
  {DBGFIELD("LOOPE")              1, false, false, 14, 1, 10, 1,  0, 0}, // #611
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, 14, 1, 10, 1,  0, 0}, // #612
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 1, false, false, 14, 1, 10, 1,  0, 0}, // #613
  {DBGFIELD("FNSTCW16m")          1, false, false, 14, 1, 10, 1,  0, 0}, // #614
  {DBGFIELD("BT16mr_BT32mr_BT64mr") 1, false, false, 13, 1,  9, 1,  0, 0}, // #615
  {DBGFIELD("POPA16_POPA32")      1, false, false, 13, 1,  9, 1,  0, 0}, // #616
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, 13, 1,  9, 1,  0, 0}, // #617
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 1, false, false, 13, 1,  9, 1,  0, 0}, // #618
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 1, false, false, 13, 1,  9, 1,  0, 0}, // #619
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, 13, 1,  9, 1,  0, 0}, // #620
  {DBGFIELD("CMPXCHG8rr")         1, false, false, 13, 1,  9, 1,  0, 0}, // #621
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80_COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 13, 1,  9, 1,  0, 0}, // #622
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_CVTTSS2SI64rr_Int") 1, false, false, 13, 1,  9, 1,  0, 0}, // #623
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int") 1, false, false, 22, 1, 18, 1,  0, 0}, // #624
  {DBGFIELD("CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 1, false, false, 22, 1, 18, 1,  0, 0}, // #625
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, 40, 1, 26, 1,  0, 0}, // #626
  {DBGFIELD("BTC16mr_BTC32mr_BTC64mr_BTR16mr_BTR32mr_BTR64mr_BTS16mr_BTS32mr_BTS64mr") 1, false, false, 40, 1, 26, 1,  0, 0}, // #627
  {DBGFIELD("AAA_AAS")            1, false, false, 41, 1, 27, 1,  0, 0}, // #628
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 1, false, false, 31, 1, 25, 1,  0, 0}, // #629
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 1, false, false, 30, 1, 24, 1,  0, 0}, // #630
  {DBGFIELD("LOOPNE")             1, false, false, 42, 1, 28, 1,  0, 0}, // #631
  {DBGFIELD("PAUSE")              1, false, false, 42, 1, 28, 1,  0, 0}, // #632
  {DBGFIELD("CMPXCHG8B")          1, false, false, 43, 1, 29, 1,  0, 0}, // #633
  {DBGFIELD("DAA")                1, false, false, 43, 1, 29, 1,  0, 0}, // #634
  {DBGFIELD("LOOP")               1, false, false, 43, 1, 29, 1,  0, 0}, // #635
  {DBGFIELD("DAS")                1, false, false, 44, 1, 30, 1,  0, 0}, // #636
  {DBGFIELD("AAM8i8")             1, false, false, 45, 1, 31, 1,  0, 0}, // #637
  {DBGFIELD("STD")                1, false, false, 45, 1, 31, 1,  0, 0}, // #638
  {DBGFIELD("CMPXCHG16B")         1, false, false, 46, 1, 32, 1,  0, 0}, // #639
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, 47, 1, 33, 1,  0, 0}, // #640
  {DBGFIELD("FNCLEX_FXTRACT")     1, false, false, 48, 1, 34, 1,  0, 0}, // #641
  {DBGFIELD("POPF32_POPF64")      1, false, false, 49, 1, 35, 1,  0, 0}, // #642
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, 50, 1, 36, 1,  0, 0}, // #643
  {DBGFIELD("RDTSC_RDTSCP")       1, false, false, 51, 1, 37, 1,  0, 0}, // #644
  {DBGFIELD("ENTER")              1, false, false, 52, 1, 38, 1,  0, 0}, // #645
  {DBGFIELD("POPF16")             1, false, false, 52, 1, 38, 1,  0, 0}, // #646
  {DBGFIELD("MONITORrrr")         1, false, false, 53, 1, 39, 1,  0, 0}, // #647
  {DBGFIELD("FRNDINT")            1, false, false, 54, 1, 40, 1,  0, 0}, // #648
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false, 54, 1, 40, 1,  0, 0}, // #649
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, 55, 1, 41, 1,  0, 0}, // #650
  {DBGFIELD("FPREM")              1, false, false, 56, 1, 42, 1,  0, 0}, // #651
  {DBGFIELD("INSB_INSL_INSW")     1, false, false, 57, 1, 43, 1,  0, 0}, // #652
  {DBGFIELD("FNINIT")             1, false, false, 58, 1, 44, 1,  0, 0}, // #653
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 1, false, false, 17, 1, 13, 1,  0, 0}, // #654
  {DBGFIELD("FPREM1")             1, false, false, 29, 1, 23, 1,  0, 0}, // #655
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, 29, 1, 23, 1,  0, 0}, // #656
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 1, false, false, 59, 1, 45, 1,  0, 0}, // #657
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, 60, 1, 46, 1,  0, 0}, // #658
  {DBGFIELD("FSCALE")             1, false, false, 61, 1, 47, 1,  0, 0}, // #659
  {DBGFIELD("RDMSR")              1, false, false, 62, 1, 48, 1,  0, 0}, // #660
  {DBGFIELD("RET_RETL_RETQ_RETW_LRETIL_LRETIQ_LRETIW_LRETL_LRETQ_LRETW") 1, false, false, 63, 1, 49, 1,  0, 0}, // #661
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 1, false, false, 64, 1, 50, 1,  0, 0}, // #662
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 1, false, false, 65, 1, 51, 1,  0, 0}, // #663
  {DBGFIELD("F2XM1")              1, false, false, 66, 1, 52, 1,  0, 0}, // #664
  {DBGFIELD("CPUID")              1, false, false, 67, 1, 53, 1,  0, 0}, // #665
  {DBGFIELD("INT")                1, false, false, 68, 1, 54, 1,  0, 0}, // #666
  {DBGFIELD("INT3")               1, false, false, 16, 1, 12, 1,  0, 0}, // #667
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, 69, 1, 55, 1,  0, 0}, // #668
  {DBGFIELD("FXRSTOR_FXRSTOR64")  1, false, false, 70, 1, 56, 1,  0, 0}, // #669
  {DBGFIELD("FYL2X")              1, false, false, 71, 1, 57, 1,  0, 0}, // #670
  {DBGFIELD("FYL2XP1")            1, false, false, 72, 1, 58, 1,  0, 0}, // #671
  {DBGFIELD("FPTAN")              1, false, false, 73, 1, 59, 1,  0, 0}, // #672
  {DBGFIELD("FSINCOS")            1, false, false, 74, 1, 60, 1,  0, 0}, // #673
  {DBGFIELD("COS_F_COS_Fp32_COS_Fp64_COS_Fp80_SIN_F_SIN_Fp32_SIN_Fp64_SIN_Fp80") 1, false, false, 74, 1, 60, 1,  0, 0}, // #674
  {DBGFIELD("FPATAN")             1, false, false, 75, 1, 61, 1,  0, 0}, // #675
  {DBGFIELD("WRMSR")              1, false, false, 76, 1, 62, 1,  0, 0}, // #676
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, 10, 2,  7, 1,  0, 0}, // #677
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false,  4, 2,  1, 1,  0, 0}, // #678
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 1, false, false,  1, 1,  1, 1,  0, 0}, // #679
  {DBGFIELD("FNOP")               1, false, false,  1, 1,  1, 1,  0, 0}, // #680
  {DBGFIELD("RETQ")               1, false, false, 63, 1, 49, 1,  0, 0}, // #681
  {DBGFIELD("CDQ_CQO")            1, false, false, 26, 1, 22, 1,  0, 0}, // #682
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #683
  {DBGFIELD("MMX_PADDQirr")       1, false, false,  3, 1, 20, 1,  0, 0}, // #684
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false,  6, 2,  1, 1,  0, 0}, // #685
  {DBGFIELD("ROL16r1_ROL32r1_ROL64r1_ROL8r1_ROL16ri_ROL32ri_ROL64ri_ROL8ri_ROR16r1_ROR32r1_ROR64r1_ROR8r1_ROR16ri_ROR32ri_ROR64ri_ROR8ri") 1, false, false,  6, 2,  1, 1,  0, 0}, // #686
  {DBGFIELD("SETAr_SETBEr")       1, false, false,  1, 1,  1, 1,  0, 0}, // #687
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 1, false, false,  3, 1, 20, 1,  0, 0}, // #688
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 13, 1,  9, 1,  0, 0}, // #689
  {DBGFIELD("VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 1, false, false, 10, 2,  7, 1,  0, 0}, // #690
  {DBGFIELD("CWD")                1, false, false, 26, 1, 22, 1,  0, 0}, // #691
  {DBGFIELD("FNSTSW16r")          1, false, false,  1, 1,  1, 1,  0, 0}, // #692
  {DBGFIELD("MMX_MOVDQ2Qrr")      1, false, false,  1, 1,  1, 1,  0, 0}, // #693
  {DBGFIELD("PUSHFS64")           1, false, false,  3, 1, 20, 1,  0, 0}, // #694
  {DBGFIELD("IMUL16rri_IMUL16rri8") 1, false, false,  9, 1,  6, 1,  0, 0}, // #695
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #696
  {DBGFIELD("ROL16rCL_ROL32rCL_ROL64rCL_ROL8rCL_ROR16rCL_ROR32rCL_ROR64rCL_ROR8rCL_SAR16rCL_SAR32rCL_SAR64rCL_SAR8rCL_SHL16rCL_SHL32rCL_SHL64rCL_SHL8rCL_SHR16rCL_SHR32rCL_SHR64rCL_SHR8rCL") 1, false, false,  6, 2,  1, 1,  0, 0}, // #697
  {DBGFIELD("XADD8rr_XADD16rr_XADD32rr_XADD64rr_XCHG8rr_XCHG16rr_XCHG32rr_XCHG64rr_XCHG16ar_XCHG32ar_XCHG64ar") 1, false, false,  3, 1, 20, 1,  0, 0}, // #698
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, 13, 1,  9, 1,  0, 0}, // #699
  {DBGFIELD("IMUL64r_MUL64r")     1, false, false, 23, 1, 19, 1,  0, 0}, // #700
  {DBGFIELD("IMUL16r_MUL16r")     1, false, false,  8, 1,  5, 1,  0, 0}, // #701
  {DBGFIELD("MOV64sr")            1, false, false,  1, 1,  1, 1,  0, 0}, // #702
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #703
  {DBGFIELD("MOVSX16rm16_MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVSX64rm16_MOVSX64rm32_MOVSX64rm8_MOVZX16rm16_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX_MOVZX64rm16_MOVZX64rm8") 1, false, false,  6, 2,  1, 1,  0, 0}, // #704
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 1, false, false, 34, 3,  1, 1,  0, 0}, // #705
  {DBGFIELD("CLI")                1, false, false,  1, 1,  4, 1,  0, 0}, // #706
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 1, false, false,  3, 1, 20, 1,  0, 0}, // #707
  {DBGFIELD("PUSHGS64")           1, false, false,  3, 1, 20, 1,  0, 0}, // #708
  {DBGFIELD("CALL64pcrel32")      1, false, false,  4, 2,  1, 1,  0, 0}, // #709
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 1, false, false,  4, 2,  1, 1,  0, 0}, // #710
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #711
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 1, false, false,  1, 1,  1, 1,  0, 0}, // #712
  {DBGFIELD("SETAm_SETBEm")       1, false, false,  3, 1, 20, 1,  0, 0}, // #713
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #714
  {DBGFIELD("PUSHF16_PUSHF64")    1, false, false, 13, 1,  9, 1,  0, 0}, // #715
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 1, false, false,  6, 2,  1, 1,  0, 0}, // #716
  {DBGFIELD("MMX_MOVD64from64rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #717
  {DBGFIELD("VBROADCASTSSrm_MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #718
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #719
  {DBGFIELD("MOVSDrm_VMOVSDrm_MOVSSrm_VMOVSSrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #720
  {DBGFIELD("MOV16sm")            1, false, false,  1, 1,  1, 1,  0, 0}, // #721
  {DBGFIELD("BT16mi8_BT32mi8_BT64mi8") 1, false, false,  1, 1,  1, 1,  0, 0}, // #722
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #723
  {DBGFIELD("MMX_PALIGNRrmi")     1, false, false,  6, 2,  1, 1,  1, 1}, // #724
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 1, false, false,  6, 2,  1, 1,  1, 1}, // #725
  {DBGFIELD("LODSL_LODSQ")        1, false, false,  3, 1, 20, 1,  0, 0}, // #726
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #727
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #728
  {DBGFIELD("VINSERTF128rm")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #729
  {DBGFIELD("MMX_PADDQirm")       1, false, false, 25, 1, 21, 1,  0, 0}, // #730
  {DBGFIELD("VERRm_VERWm")        1, false, false,  1, 1,  4, 1,  0, 0}, // #731
  {DBGFIELD("FARJMP64")           1, false, false,  4, 2,  1, 1,  0, 0}, // #732
  {DBGFIELD("FNSTSWm")            1, false, false,  1, 1,  4, 1,  0, 0}, // #733
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 1, false, false,  1, 1,  4, 1,  0, 0}, // #734
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 1, false, false,  4, 2,  1, 1,  0, 0}, // #735
  {DBGFIELD("CALL64m_CALL64m_NT") 1, false, false,  4, 2,  1, 1,  0, 0}, // #736
  {DBGFIELD("SAR16m1_SAR32m1_SAR64m1_SAR8m1_SAR16mi_SAR32mi_SAR64mi_SAR8mi_SHL16m1_SHL32m1_SHL64m1_SHL8m1_SHL16mi_SHL32mi_SHL64mi_SHL8mi_SHR16m1_SHR32m1_SHR64m1_SHR8m1_SHR16mi_SHR32mi_SHR64mi_SHR8mi") 1, false, false,  6, 2,  1, 1,  0, 0}, // #737
  {DBGFIELD("VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 1, false, false, 10, 2,  7, 1,  1, 1}, // #738
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, 25, 1, 21, 1,  0, 0}, // #739
  {DBGFIELD("ROL16m1_ROL32m1_ROL64m1_ROL8m1_ROL16mi_ROL32mi_ROL64mi_ROL8mi_ROR16m1_ROR32m1_ROR64m1_ROR8m1_ROR16mi_ROR32mi_ROR64mi_ROR8mi") 1, false, false,  6, 2,  1, 1,  0, 0}, // #740
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 1, false, false, 25, 1, 21, 1,  0, 0}, // #741
  {DBGFIELD("FARCALL64")          1, false, false,  4, 2,  1, 1,  0, 0}, // #742
  {DBGFIELD("CVTSD2SI64rm_Int_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int") 1, false, false, 13, 1,  9, 1,  0, 0}, // #743
  {DBGFIELD("CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int") 1, false, false, 13, 1,  9, 1,  0, 0}, // #744
  {DBGFIELD("IMUL64m_MUL64m")     1, false, false, 23, 1, 19, 1,  3, 2}, // #745
  {DBGFIELD("IMUL32m_MUL32m")     1, false, false,  8, 1,  5, 1,  3, 2}, // #746
  {DBGFIELD("IMUL16rmi_IMUL16rmi8") 1, false, false,  8, 1,  5, 1,  0, 0}, // #747
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false,  6, 2,  1, 1,  0, 0}, // #748
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL_SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 1, false, false,  6, 2,  1, 1,  0, 0}, // #749
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #750
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 1, false, false, 10, 2,  7, 1,  0, 0}, // #751
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 1, false, false,  6, 2,  1, 1,  1, 1}, // #752
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 1, false, false, 10, 2,  7, 1,  0, 0}, // #753
  {DBGFIELD("MUL_F32m_MUL_F64m")  1, false, false, 27, 2, 22, 1,  0, 0}, // #754
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 1, false, false, 10, 2,  7, 1,  0, 0}, // #755
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 1, false, false, 27, 2, 22, 1,  0, 0}, // #756
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 1, false, false, 20, 1, 16, 1,  0, 0}, // #757
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 1, false, false, 20, 1, 16, 1,  0, 0}, // #758
  {DBGFIELD("CLC")                1, false, false,  1, 1,  1, 1,  0, 0}, // #759
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 1, false, false,  6, 2,  1, 1,  1, 1}, // #760
  {DBGFIELD("DIV8r")              1, false, false, 15, 1, 11, 1,  0, 0}, // #761
  {DBGFIELD("IDIV8r")             1, false, false, 21, 1, 17, 1,  0, 0}, // #762
  {DBGFIELD("RETIL_RETIQ_RETIW")  1, false, false, 34, 3,  1, 1,  0, 0}, // #763
  {DBGFIELD("LRETIL_LRETIQ_LRETIW") 1, false, false, 63, 1, 49, 1,  0, 0}, // #764
  {DBGFIELD("RDPMC")              1, false, false, 54, 1, 40, 1,  0, 0}, // #765
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false,  1, 1,  4, 1,  0, 0}, // #766
  {DBGFIELD("FBLDm")              1, false, false,  1, 1,  4, 1,  0, 0}, // #767
  {DBGFIELD("FFREE_FFREEP")       1, false, false,  1, 1,  1, 1,  0, 0}, // #768
  {DBGFIELD("FSAVEm")             1, false, false,  1, 1,  4, 1,  0, 0}, // #769
  {DBGFIELD("FRSTORm")            1, false, false,  1, 1,  4, 1,  0, 0}, // #770
  {DBGFIELD("FXTRACT")            1, false, false, 48, 1, 34, 1,  0, 0}, // #771
  {DBGFIELD("VBROADCASTSSrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #772
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #773
  {DBGFIELD("VBROADCASTF128")     1, false, false,  6, 2,  1, 1,  0, 0}, // #774
  {DBGFIELD("VBROADCASTI128")     1, false, false,  6, 2,  1, 1,  0, 0}, // #775
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #776
  {DBGFIELD("FBSTPm")             1, false, false,  1, 1,  4, 1,  0, 0}, // #777
  {DBGFIELD("ST_FP32m_ST_FP64m")  1, false, false,  3, 1, 20, 1,  0, 0}, // #778
  {DBGFIELD("VMPTRSTm")           1, false, false,  1, 1,  4, 1,  0, 0}, // #779
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #780
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #781
  {DBGFIELD("MMX_MOVQ2DQrr")      1, false, false,  1, 1,  1, 1,  0, 0}, // #782
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT") 1, false, false,  4, 2,  1, 1,  0, 0}, // #783
  {DBGFIELD("FINCSTP")            1, false, false,  1, 1,  1, 1,  0, 0}, // #784
  {DBGFIELD("ANDN32rr_ANDN64rr_BLSI32rr_BLSI64rr_BLSMSK32rr_BLSMSK64rr_BLSR32rr_BLSR64rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #785
  {DBGFIELD("VPBLENDDYrri")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #786
  {DBGFIELD("VPBLENDDrri")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #787
  {DBGFIELD("CMC_STC")            1, false, false,  1, 1,  1, 1,  0, 0}, // #788
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false,  1, 1,  4, 1,  0, 0}, // #789
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 1, false, false, 14, 1, 10, 1,  0, 0}, // #790
  {DBGFIELD("CVTSS2SDrm")         1, false, false,  8, 1,  5, 1,  0, 0}, // #791
  {DBGFIELD("CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 1, false, false,  8, 1,  5, 1,  1, 1}, // #792
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #793
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #794
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 1, false, false,  6, 2,  1, 1,  1, 1}, // #795
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #796
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #797
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT") 1, false, false,  4, 2,  1, 1,  0, 0}, // #798
  {DBGFIELD("ANDN32rm_ANDN64rm")  1, false, false,  6, 2,  1, 1,  1, 1}, // #799
  {DBGFIELD("BLSI32rm_BLSI64rm_BLSMSK32rm_BLSMSK64rm_BLSR32rm_BLSR64rm_MOVBE16rm_MOVBE32rm_MOVBE64rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #800
  {DBGFIELD("VINSERTI128rm")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #801
  {DBGFIELD("VPBLENDDrmi")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #802
  {DBGFIELD("VPBLENDDYrmi")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #803
  {DBGFIELD("POP32r_POP64r")      1, false, false, 34, 3,  1, 1,  0, 0}, // #804
  {DBGFIELD("SFENCE")             1, false, false,  6, 2,  1, 1,  0, 0}, // #805
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #806
  {DBGFIELD("MOVBE16mr")          1, false, false,  6, 2,  1, 1,  0, 0}, // #807
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r") 1, false, false, 34, 3,  1, 1,  0, 0}, // #808
  {DBGFIELD("MFENCE")             1, false, false,  6, 2,  1, 1,  0, 0}, // #809
  {DBGFIELD("XGETBV")             1, false, false,  1, 1,  4, 1,  0, 0}, // #810
  {DBGFIELD("CVTPS2PDrr_VCVTPS2PDrr") 1, false, false,  8, 1,  5, 1,  0, 0}, // #811
  {DBGFIELD("CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 1, false, false,  9, 1,  6, 1,  0, 0}, // #812
  {DBGFIELD("MMX_PACKSSDWirm_MMX_PACKSSWBirm_MMX_PACKUSWBirm") 1, false, false,  6, 2,  1, 1,  1, 1}, // #813
  {DBGFIELD("LRETQ_RETL")         1, false, false, 63, 1, 49, 1,  0, 0}, // #814
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #815
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false,  9, 1,  6, 1,  0, 0}, // #816
  {DBGFIELD("VCVTDQ2PSYrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #817
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #818
  {DBGFIELD("CVTPS2DQrm_VCVTPS2DQrm_CVTTPS2DQrm_VCVTTPS2DQrm") 1, false, false,  8, 1,  5, 1,  0, 0}, // #819
  {DBGFIELD("VCVTDQ2PSYrm")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #820
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #821
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #822
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #823
  {DBGFIELD("CLDEMOTE")           1, false, false,  6, 2,  1, 1,  0, 0}, // #824
  {DBGFIELD("RCL16r1_RCL32r1_RCL64r1_RCL8r1_RCL16ri_RCL32ri_RCL64ri_RCL8ri_RCR16r1_RCR32r1_RCR64r1_RCR8r1_RCR16ri_RCR32ri_RCR64ri_RCR8ri") 1, false, false,  6, 2,  1, 1,  0, 0}, // #825
  {DBGFIELD("RCL16m1_RCL32m1_RCL64m1_RCL8m1_RCL16mi_RCL32mi_RCL64mi_RCL8mi_RCR16m1_RCR32m1_RCR64m1_RCR8m1_RCR16mi_RCR32mi_RCR64mi_RCR8mi") 1, false, false,  6, 2,  1, 1,  0, 0}, // #826
  {DBGFIELD("ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 1, false, false,  6, 2,  1, 1,  0, 0}, // #827
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_CVTTSD2SI64rr_Int_CVTTSD2SIrr_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int_VCVTTSD2SI64rr_VCVTTSD2SIrr") 1, false, false, 14, 1, 10, 1,  0, 0}, // #828
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int_CVTSS2SIrr_Int_CVTTSS2SIrr_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_VCVTTSS2SIrr_Int") 1, false, false, 14, 1, 10, 1,  0, 0}, // #829
  {DBGFIELD("VCVTPS2PDYrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #830
  {DBGFIELD("MMX_CVTPI2PDirr_CVTDQ2PDrr_VCVTDQ2PDrr") 1, false, false,  8, 1,  5, 1,  0, 0}, // #831
  {DBGFIELD("MMX_CVTPD2PIirr_MMX_CVTTPD2PIirr_CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 1, false, false,  8, 1,  5, 1,  0, 0}, // #832
  {DBGFIELD("CVTPD2PSrr_VCVTPD2PSrr") 1, false, false,  8, 1,  5, 1,  0, 0}, // #833
  {DBGFIELD("CVTSD2SSrr_CVTSD2SSrr_Int_VCVTSD2SSrr_VCVTSD2SSrr_Int") 1, false, false,  9, 1,  6, 1,  0, 0}, // #834
  {DBGFIELD("CVTSI2SDrr_CVTSI2SDrr_Int_CVTSI642SDrr_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 1, false, false,  9, 1,  6, 1,  0, 0}, // #835
  {DBGFIELD("CVTSI2SSrr_CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int") 1, false, false,  9, 1,  6, 1,  0, 0}, // #836
  {DBGFIELD("MULX64rr")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #837
  {DBGFIELD("VCVTSD2SI64rm_Int_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 1, false, false, 13, 1,  9, 1,  0, 0}, // #838
  {DBGFIELD("CVTSS2SI64rm_Int")   1, false, false, 22, 1, 18, 1,  0, 0}, // #839
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 1, false, false, 13, 1,  9, 1,  0, 0}, // #840
  {DBGFIELD("VCVTPS2PDYrm")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #841
  {DBGFIELD("CVTPD2PSrm")         1, false, false, 14, 1, 10, 1,  0, 0}, // #842
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_MMX_CVTPD2PIirm_MMX_CVTTPD2PIirm") 1, false, false, 14, 1, 10, 1,  0, 0}, // #843
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 1, false, false, 14, 1, 10, 1,  0, 0}, // #844
  {DBGFIELD("MMX_CVTPI2PDirm")    1, false, false, 14, 1, 10, 1,  0, 0}, // #845
  {DBGFIELD("CVTSD2SSrm")         1, false, false,  8, 1,  5, 1,  0, 0}, // #846
  {DBGFIELD("CVTSD2SSrm_Int_VCVTSD2SSrm_VCVTSD2SSrm_Int") 1, false, false,  8, 1,  5, 1,  1, 1}, // #847
  {DBGFIELD("MULX64rm")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #848
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #849
  {DBGFIELD("VZEROUPPER")         1, false, false,  1, 1,  4, 1,  0, 0}, // #850
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 1, false, false,  1, 1,  4, 1,  0, 0}, // #851
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 1, false, false,  1, 1,  4, 1,  0, 0}, // #852
  {DBGFIELD("VPCMPGTQYrr")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #853
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, 27, 2, 22, 1,  0, 0}, // #854
  {DBGFIELD("VPCMPGTQYrm")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #855
  {DBGFIELD("CVTSI642SSrr_CVTSI642SSrr_Int_VCVTSI642SSrr_VCVTSI642SSrr_Int") 1, false, false,  9, 1,  6, 1,  0, 0}, // #856
  {DBGFIELD("STR16r_STR32r_STR64r") 1, false, false,  1, 1,  4, 1,  0, 0}, // #857
  {DBGFIELD("MULX32rr")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #858
  {DBGFIELD("MULX32rm")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #859
  {DBGFIELD("XSETBV")             1, false, false,  1, 1,  4, 1,  0, 0}, // #860
  {DBGFIELD("VCVTDQ2PDYrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #861
  {DBGFIELD("VCVTPD2PSYrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #862
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #863
  {DBGFIELD("VCVTDQ2PDYrm")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #864
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 1, false, false,  6, 2,  1, 1,  0, 0}, // #865
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 1, false, false,  6, 2,  1, 1,  0, 0}, // #866
  {DBGFIELD("RCL8rCL")            1, false, false,  6, 2,  1, 1,  0, 0}, // #867
  {DBGFIELD("RCR8rCL")            1, false, false,  6, 2,  1, 1,  0, 0}, // #868
  {DBGFIELD("VZEROALL")           1, false, false,  1, 1,  4, 1,  0, 0}, // #869
  {DBGFIELD("RDTSC")              1, false, false, 51, 1, 37, 1,  0, 0}, // #870
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 1, false, false,  1, 1,  4, 1,  0, 0}, // #871
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, 20, 1, 16, 1,  0, 0}, // #872
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 1, false, false, 20, 1, 16, 1,  0, 0}, // #873
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 1, false, false, 20, 1, 16, 1,  0, 0}, // #874
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, 20, 1, 16, 1,  0, 0}, // #875
  {DBGFIELD("XSAVE64")            1, false, false,  1, 1,  4, 1,  0, 0}, // #876
  {DBGFIELD("XSAVE")              1, false, false,  1, 1,  4, 1,  0, 0}, // #877
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 1, false, false,  1, 1,  4, 1,  0, 0}, // #878
  {DBGFIELD("VMCLEARm")           1, false, false,  1, 1,  4, 1,  0, 0}, // #879
  {DBGFIELD("FLDENVm")            1, false, false,  1, 1,  4, 1,  0, 0}, // #880
  {DBGFIELD("FXRSTOR64")          1, false, false, 70, 1, 56, 1,  0, 0}, // #881
  {DBGFIELD("DIV16r")             1, false, false, 15, 1, 11, 1,  0, 0}, // #882
  {DBGFIELD("DIV32r")             1, false, false, 15, 1, 11, 1,  0, 0}, // #883
  {DBGFIELD("DIV64r")             1, false, false, 16, 1, 12, 1,  0, 0}, // #884
  {DBGFIELD("IDIV16r")            1, false, false, 21, 1, 17, 1,  0, 0}, // #885
  {DBGFIELD("IDIV32r")            1, false, false, 21, 1, 17, 1,  0, 0}, // #886
  {DBGFIELD("IDIV64r")            1, false, false, 16, 1, 12, 1,  0, 0}, // #887
  {DBGFIELD("FSTENVm")            1, false, false,  1, 1,  4, 1,  0, 0}, // #888
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm_VPGATHERDDrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #889
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #890
  {DBGFIELD("VPGATHERQDYrm")      1, false, false,  6, 2,  1, 1,  0, 0}, // #891
  {DBGFIELD("VPGATHERQDrm")       1, false, false,  6, 2,  1, 1,  0, 0}, // #892
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #893
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #894
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #895
  {DBGFIELD("VGATHERQPSYrm")      1, false, false,  6, 2,  1, 1,  0, 0}, // #896
  {DBGFIELD("VGATHERQPSrm_VGATHERDPSrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #897
  {DBGFIELD("ADC8i8_ADC8ri_ADC8ri8_SBB8i8_SBB8ri_SBB8ri8") 1, false, false,  1, 1,  1, 1,  0, 0}, // #898
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 1, false, false, 10, 2,  7, 1,  0, 0}, // #899
  {DBGFIELD("LRETQ")              1, false, false, 63, 1, 49, 1,  0, 0}, // #900
  {DBGFIELD("CVTDQ2PSrm_VCVTDQ2PSrm") 1, false, false,  8, 1,  5, 1,  0, 0}, // #901
  {DBGFIELD("POPF64")             1, false, false, 49, 1, 35, 1,  0, 0}, // #902
  {DBGFIELD("VGATHERQPDrm")       1, false, false,  6, 2,  1, 1,  0, 0}, // #903
  {DBGFIELD("VGATHERQPDYrm")      1, false, false,  6, 2,  1, 1,  0, 0}, // #904
  {DBGFIELD("VGATHERDPDrm")       1, false, false,  6, 2,  1, 1,  0, 0}, // #905
  {DBGFIELD("VGATHERDPSrm")       1, false, false,  6, 2,  1, 1,  0, 0}, // #906
  {DBGFIELD("VGATHERDPDYrm")      1, false, false,  6, 2,  1, 1,  0, 0}, // #907
  {DBGFIELD("VGATHERDPSYrm")      1, false, false,  6, 2,  1, 1,  0, 0}, // #908
  {DBGFIELD("DIV16m")             1, false, false, 15, 1, 11, 1,  3, 2}, // #909
  {DBGFIELD("DIV32m")             1, false, false, 15, 1, 11, 1,  3, 2}, // #910
  {DBGFIELD("DIV64m")             1, false, false, 16, 1, 12, 1,  3, 2}, // #911
  {DBGFIELD("DIV8m")              1, false, false, 17, 1, 13, 1,  3, 2}, // #912
  {DBGFIELD("IDIV16m")            1, false, false, 21, 1, 17, 1,  3, 2}, // #913
  {DBGFIELD("IDIV32m")            1, false, false, 21, 1, 17, 1,  3, 2}, // #914
  {DBGFIELD("IDIV64m")            1, false, false, 16, 1, 12, 1,  3, 2}, // #915
  {DBGFIELD("IDIV8m")             1, false, false, 21, 1, 17, 1,  3, 2}, // #916
  {DBGFIELD("MOV16rm")            1, false, false,  6, 2,  1, 1,  0, 0}, // #917
  {DBGFIELD("MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX") 1, false, false,  6, 2,  1, 1,  0, 0}, // #918
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 1, false, false,  3, 1, 20, 1,  0, 0}, // #919
  {DBGFIELD("POP16rmm")           1, false, false, 25, 1, 21, 1,  0, 0}, // #920
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 1, false, false,  3, 1, 20, 1,  0, 0}, // #921
  {DBGFIELD("PUSHF16")            1, false, false, 13, 1,  9, 1,  0, 0}, // #922
  {DBGFIELD("LAHF")               1, false, false,  3, 1, 20, 1,  0, 0}, // #923
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #924
  {DBGFIELD("ADD16mi_ADD16mi8_ADD16mr_ADD32mi_ADD32mi8_ADD32mr_ADD64mi32_ADD64mi8_ADD64mr_ADD8mi_ADD8mi8_ADD8mr_SUB16mi_SUB16mi8_SUB16mr_SUB32mi_SUB32mi8_SUB32mr_SUB64mi32_SUB64mi8_SUB64mr_SUB8mi_SUB8mi8_SUB8mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #925
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 1, false, false,  6, 2,  1, 1,  0, 0}, // #926
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 1, false, false,  6, 2,  1, 1,  0, 0}, // #927
  {DBGFIELD("IMUL16rm")           1, false, false,  8, 1,  5, 1,  1, 1}, // #928
  {DBGFIELD("IMUL64rr")           1, false, false, 23, 1, 19, 1,  0, 0}, // #929
  {DBGFIELD("IMUL64rm")           1, false, false, 23, 1, 19, 1,  1, 1}, // #930
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 1, false, false,  4, 2,  1, 1,  0, 0}, // #931
  {DBGFIELD("RETW_LRETL_LRETW")   1, false, false, 63, 1, 49, 1,  0, 0}, // #932
  {DBGFIELD("IRET16_IRET32_IRET64") 1, false, false, 34, 3,  1, 1,  0, 0}, // #933
  {DBGFIELD("AND16mi_AND16mi8_AND16mr_AND32mi_AND32mi8_AND32mr_AND64mi32_AND64mi8_AND64mr_AND8mi_AND8mi8_AND8mr_OR16mi_OR16mi8_OR16mr_OR32mi_OR32mi8_OR32mr_OR64mi32_OR64mi8_OR64mr_OR8mi_OR8mi8_OR8mr_XOR16mi_XOR16mi8_XOR16mr_XOR32mi_XOR32mi8_XOR32mr_XOR64mi32_XOR64mi8_XOR64mr_XOR8mi_XOR8mi8_XOR8mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #934
  {DBGFIELD("OR32mrLocked")       2, false, false,  2, 2,  1, 2,  0, 0}, // #935
  {DBGFIELD("BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 1, false, false,  4, 2,  1, 1,  0, 0}, // #936
  {DBGFIELD("BLSI32rr_BLSI64rr_BLSMSK32rr_BLSMSK64rr_BLSR32rr_BLSR64rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #937
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 1, false, false, 26, 1, 22, 1,  0, 0}, // #938
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 1, false, false,  3, 1, 20, 1,  0, 0}, // #939
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 1, false, false, 26, 1, 22, 1,  0, 0}, // #940
  {DBGFIELD("MOVSLDUPrm")         1, false, false,  6, 2,  1, 1,  0, 0}, // #941
  {DBGFIELD("MOVSLDUPrr")         1, false, false,  6, 2,  1, 1,  0, 0}, // #942
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false,  4, 2,  1, 1,  0, 0}, // #943
  {DBGFIELD("VPMOVSXBDYrr_VPMOVSXBQYrr_VPMOVSXBWYrr_VPMOVSXDQYrr_VPMOVSXWDYrr_VPMOVSXWQYrr_VPMOVZXBDYrr_VPMOVZXBQYrr_VPMOVZXBWYrr_VPMOVZXDQYrr_VPMOVZXWDYrr_VPMOVZXWQYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #944
  {DBGFIELD("VPMOVZXBDYrm_VPMOVZXBQYrm_VPMOVZXBWYrm_VPMOVZXDQYrm_VPMOVZXWQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #945
  {DBGFIELD("PBLENDWrri_VPBLENDWrri") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #946
  {DBGFIELD("VPBLENDWYrri")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #947
  {DBGFIELD("PBLENDWrmi_VPBLENDWrmi") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #948
  {DBGFIELD("VPBLENDWYrmi")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #949
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false,  6, 2,  1, 1,  0, 0}, // #950
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 1, false, false,  3, 1, 20, 1,  0, 0}, // #951
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 1, false, false,  6, 2,  1, 1,  0, 0}, // #952
  {DBGFIELD("VPMASKMOVDYrm")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #953
  {DBGFIELD("VPMASKMOVDrm")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #954
  {DBGFIELD("VPMASKMOVDYmr_VPMASKMOVQYmr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #955
  {DBGFIELD("VPMASKMOVDmr_VPMASKMOVQmr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #956
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #957
  {DBGFIELD("VPSLLDQri_VPSRLDQri") 1, false, false,  6, 2,  1, 1,  0, 0}, // #958
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #959
  {DBGFIELD("VPERM2F128rr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #960
  {DBGFIELD("VPERM2F128rm")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #961
  {DBGFIELD("VEXTRACTF128rr")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #962
  {DBGFIELD("VEXTRACTF128mr")     1, false, false,  6, 2,  1, 1,  0, 0}, // #963
  {DBGFIELD("VINSERTF128rr")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #964
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 1, false, false,  8, 1,  5, 1,  0, 0}, // #965
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 1, false, false,  8, 1,  5, 1,  0, 0}, // #966
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 1, false, false, 14, 1, 10, 1,  0, 0}, // #967
  {DBGFIELD("VCVTPD2DQrm_VCVTTPD2DQrm") 1, false, false, 14, 1, 10, 1,  0, 0}, // #968
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #969
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_VCVTTSS2SIrr_Int") 1, false, false, 14, 1, 10, 1,  0, 0}, // #970
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 1, false, false, 13, 1,  9, 1,  0, 0}, // #971
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false,  1, 1,  1, 1,  0, 0}, // #972
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false,  1, 1,  1, 1,  0, 0}, // #973
  {DBGFIELD("SHA256MSG2rm")       1, false, false, 10, 2,  7, 1,  1, 1}, // #974
  {DBGFIELD("SHA256MSG2rr")       1, false, false, 10, 2,  7, 1,  0, 0}, // #975
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, 10, 2,  7, 1,  0, 0}, // #976
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 1, false, false, 10, 2,  7, 1,  1, 1}, // #977
  {DBGFIELD("SHA1MSG2rr")         1, false, false, 10, 2,  7, 1,  0, 0}, // #978
  {DBGFIELD("SHA1MSG2rm")         1, false, false, 10, 2,  7, 1,  1, 1}, // #979
  {DBGFIELD("SHA1NEXTErr")        1, false, false, 10, 2,  7, 1,  0, 0}, // #980
  {DBGFIELD("SHA1NEXTErm")        1, false, false, 10, 2,  7, 1,  1, 1}, // #981
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, 10, 2,  7, 1,  0, 0}, // #982
  {DBGFIELD("SHA1RNDS4rmi")       1, false, false, 10, 2,  7, 1,  1, 1}, // #983
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, 10, 2,  7, 1,  0, 0}, // #984
  {DBGFIELD("SHA256RNDS2rm")      1, false, false, 10, 2,  7, 1,  1, 1}, // #985
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #986
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr_ANDNPSrr_VANDNPSrr_ANDNPDrr_VANDNPDrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #987
  {DBGFIELD("MMX_PXORirr_MMX_PANDNirr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #988
  {DBGFIELD("PXORrr_VPXORrr_PANDNrr_VPANDNrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #989
  {DBGFIELD("MMX_PSUBBirr_MMX_PSUBDirr_MMX_PSUBWirr_MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #990
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #991
  {DBGFIELD("PSUBQrr")            1, false, false,  3, 1, 20, 1,  0, 0}, // #992
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false,  4, 2,  1, 1,  0, 0}, // #993
  {DBGFIELD("LEA16r")             1, false, false,  4, 2,  1, 1,  0, 0}, // #994
  {DBGFIELD("MMX_PADDSBirr_MMX_PADDSWirr_MMX_PADDUSBirr_MMX_PADDUSWirr_MMX_PAVGBirr_MMX_PAVGWirr_MMX_PCMPEQBirr_MMX_PCMPEQDirr_MMX_PCMPEQWirr_MMX_PMAXSWirr_MMX_PMINSWirr_MMX_PMAXUBirr_MMX_PMINUBirr_MMX_PSUBSBirr_MMX_PSUBSWirr_MMX_PSUBUSBirr_MMX_PSUBUSWirr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #995
  {DBGFIELD("MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #996
  {DBGFIELD("CLAC_STAC")          1, false, false,  1, 1,  4, 1,  0, 0}, // #997
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #998
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr_VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #999
  {DBGFIELD("PSUBBrr_PSUBDrr_PSUBWrr_VPSUBBrr_VPSUBDrr_VPSUBQrr_VPSUBWrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1000
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, 10, 2,  7, 1,  0, 0}, // #1001
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 1, false, false, 11, 1,  7, 1,  0, 0}, // #1002
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 1, false, false,  8, 1,  5, 1,  0, 0}, // #1003
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 1, false, false,  8, 1,  5, 1,  0, 0}, // #1004
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false,  9, 1,  6, 1,  0, 0}, // #1005
  {DBGFIELD("VCVTPS2DQYrr_VCVTTPS2DQYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1006
  {DBGFIELD("MMX_PADDSBirm_MMX_PADDSWirm_MMX_PADDUSBirm_MMX_PADDUSWirm_MMX_PAVGBirm_MMX_PAVGWirm_MMX_PCMPEQBirm_MMX_PCMPEQDirm_MMX_PCMPEQWirm_MMX_PCMPGTBirm_MMX_PCMPGTDirm_MMX_PCMPGTWirm_MMX_PMAXSWirm_MMX_PMAXUBirm_MMX_PMINSWirm_MMX_PMINUBirm_MMX_PSUBSBirm_MMX_PSUBSWirm_MMX_PSUBUSBirm_MMX_PSUBUSWirm") 1, false, false,  6, 2,  1, 1,  1, 1}, // #1007
  {DBGFIELD("CVTSS2SI64rr_Int")   1, false, false, 13, 1,  9, 1,  0, 0}, // #1008
  {DBGFIELD("CVTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int") 1, false, false, 14, 1, 10, 1,  0, 0}, // #1009
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 1, false, false,  6, 2,  1, 1,  1, 1}, // #1010
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1011
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 1, false, false,  9, 1,  6, 1,  0, 0}, // #1012
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 1, false, false, 14, 1, 10, 1,  1, 1}, // #1013
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 1, false, false, 14, 1, 10, 1,  1, 1}, // #1014
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 1, false, false,  1, 1,  4, 1,  0, 0}, // #1015
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1016
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1017
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1018
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1019
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1020
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rr_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rr_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rr_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rr_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1021
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rr_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rr_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rr_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rr_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1022
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrr_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrr_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrr_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrr_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1023
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1024
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1025
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1026
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1027
  {DBGFIELD("KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1028
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1029
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_VPTESTMBZ128rr_VPTESTMBZ128rrk_VPTESTMDZ128rr_VPTESTMDZ128rrk_VPTESTMQZ128rr_VPTESTMQZ128rrk_VPTESTMWZ128rr_VPTESTMWZ128rrk_VPTESTNMBZ128rr_VPTESTNMBZ128rrk_VPTESTNMDZ128rr_VPTESTNMDZ128rrk_VPTESTNMQZ128rr_VPTESTNMQZ128rrk_VPTESTNMWZ128rr_VPTESTNMWZ128rrk") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1030
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri_KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1031
  {DBGFIELD("VALIGNDZ128rri_VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rri_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1032
  {DBGFIELD("VALIGNDZ256rri_VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rri_VALIGNQZ256rrik_VALIGNQZ256rrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1033
  {DBGFIELD("VALIGNDZrri_VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrri_VALIGNQZrrik_VALIGNQZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1034
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rri_alt_VCMPPDZ128rri_altk_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rri_alt_VCMPPSZ128rri_altk_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, 10, 2,  7, 1,  0, 0}, // #1035
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rri_alt_VCMPPDZ256rri_altk_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rri_alt_VCMPPSZ256rri_altk_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1036
  {DBGFIELD("VCMPPDZrri_VCMPPDZrri_alt_VCMPPDZrri_altk_VCMPPDZrrib_VCMPPDZrrib_alt_VCMPPDZrrib_altk_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrri_alt_VCMPPSZrri_altk_VCMPPSZrrib_VCMPPSZrrib_alt_VCMPPSZrrib_altk_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1037
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSDZrrb_alt_VCMPSDZrrb_altk_VCMPSDZrri_alt_VCMPSDZrri_altk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VCMPSSZrrb_alt_VCMPSSZrrb_altk_VCMPSSZrri_alt_VCMPSSZrri_altk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, 10, 2,  7, 1,  0, 0}, // #1038
  {DBGFIELD("VDBPSADBWZrri_VDBPSADBWZrrik_VDBPSADBWZrrikz_VPSADBWZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1039
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rri_alt_VPCMPBZ128rrik_VPCMPBZ128rrik_alt_VPCMPDZ128rri_VPCMPDZ128rri_alt_VPCMPDZ128rrik_VPCMPDZ128rrik_alt_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rri_alt_VPCMPQZ128rrik_VPCMPQZ128rrik_alt_VPCMPUBZ128rri_VPCMPUBZ128rri_alt_VPCMPUBZ128rrik_VPCMPUBZ128rrik_alt_VPCMPUDZ128rri_VPCMPUDZ128rri_alt_VPCMPUDZ128rrik_VPCMPUDZ128rrik_alt_VPCMPUQZ128rri_VPCMPUQZ128rri_alt_VPCMPUQZ128rrik_VPCMPUQZ128rrik_alt_VPCMPUWZ128rri_VPCMPUWZ128rri_alt_VPCMPUWZ128rrik_VPCMPUWZ128rrik_alt_VPCMPWZ128rri_VPCMPWZ128rri_alt_VPCMPWZ128rrik_VPCMPWZ128rrik_alt_VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1040
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rri_alt_VPCMPBZ256rrik_VPCMPBZ256rrik_alt_VPCMPDZ256rri_VPCMPDZ256rri_alt_VPCMPDZ256rrik_VPCMPDZ256rrik_alt_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rri_alt_VPCMPQZ256rrik_VPCMPQZ256rrik_alt_VPCMPUBZ256rri_VPCMPUBZ256rri_alt_VPCMPUBZ256rrik_VPCMPUBZ256rrik_alt_VPCMPUDZ256rri_VPCMPUDZ256rri_alt_VPCMPUDZ256rrik_VPCMPUDZ256rrik_alt_VPCMPUQZ256rri_VPCMPUQZ256rri_alt_VPCMPUQZ256rrik_VPCMPUQZ256rrik_alt_VPCMPUWZ256rri_VPCMPUWZ256rri_alt_VPCMPUWZ256rrik_VPCMPUWZ256rrik_alt_VPCMPWZ256rri_VPCMPWZ256rri_alt_VPCMPWZ256rrik_VPCMPWZ256rrik_alt_VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1041
  {DBGFIELD("VPCMPBZrri_VPCMPBZrri_alt_VPCMPBZrrik_VPCMPBZrrik_alt_VPCMPDZrri_VPCMPDZrri_alt_VPCMPDZrrik_VPCMPDZrrik_alt_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrri_alt_VPCMPQZrrik_VPCMPQZrrik_alt_VPCMPUBZrri_VPCMPUBZrri_alt_VPCMPUBZrrik_VPCMPUBZrrik_alt_VPCMPUDZrri_VPCMPUDZrri_alt_VPCMPUDZrrik_VPCMPUDZrrik_alt_VPCMPUQZrri_VPCMPUQZrri_alt_VPCMPUQZrrik_VPCMPUQZrrik_alt_VPCMPUWZrri_VPCMPUWZrri_alt_VPCMPUWZrrik_VPCMPUWZrrik_alt_VPCMPWZrri_VPCMPWZrri_alt_VPCMPWZrrik_VPCMPWZrrik_alt_VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1042
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1043
  {DBGFIELD("VPTESTMBZrr_VPTESTMBZrrk_VPTESTMDZrr_VPTESTMDZrrk_VPTESTMQZrr_VPTESTMQZrrk_VPTESTMWZrr_VPTESTMWZrrk_VPTESTNMBZrr_VPTESTNMBZrrk_VPTESTNMDZrr_VPTESTNMDZrrk_VPTESTNMQZrr_VPTESTNMQZrrk_VPTESTNMWZrr_VPTESTNMWZrrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1044
  {DBGFIELD("VCVTDQ2PSZ128rr_VCVTDQ2PSZ128rrk_VCVTDQ2PSZ128rrkz_VCVTUDQ2PSZ128rr_VCVTUDQ2PSZ128rrk_VCVTUDQ2PSZ128rrkz") 1, false, false,  9, 1,  6, 1,  0, 0}, // #1045
  {DBGFIELD("VCVTDQ2PSZ256rr_VCVTDQ2PSZ256rrk_VCVTDQ2PSZ256rrkz_VCVTUDQ2PSZ256rr_VCVTUDQ2PSZ256rrk_VCVTUDQ2PSZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1046
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 1, false, false,  8, 1,  5, 1,  0, 0}, // #1047
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1048
  {DBGFIELD("VCVTPS2DQYrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1049
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false,  9, 1,  6, 1,  0, 0}, // #1050
  {DBGFIELD("VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1051
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 1, false, false,  8, 1,  5, 1,  0, 0}, // #1052
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1053
  {DBGFIELD("VCVTDQ2PSZrr_VCVTUDQ2PSZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1054
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1055
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1056
  {DBGFIELD("VCVTQQ2PDZrr_VCVTUQQ2PDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1057
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1058
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1059
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1060
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 1, false, false,  8, 1,  5, 1,  0, 0}, // #1061
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 1, false, false,  8, 1,  5, 1,  0, 0}, // #1062
  {DBGFIELD("VCVTPD2PSZ128rr_VCVTPD2PSZ128rrk_VCVTPD2PSZ128rrkz") 1, false, false,  8, 1,  5, 1,  0, 0}, // #1063
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz") 1, false, false,  8, 1,  5, 1,  0, 0}, // #1064
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false,  9, 1,  6, 1,  0, 0}, // #1065
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false,  9, 1,  6, 1,  0, 0}, // #1066
  {DBGFIELD("VCVTSD2SSZrr_VCVTSD2SSZrr_Int_VCVTSD2SSZrr_Intk_VCVTSD2SSZrr_Intkz_VCVTSD2SSZrrb_Int_VCVTSD2SSZrrb_Intk_VCVTSD2SSZrrb_Intkz") 1, false, false,  9, 1,  6, 1,  0, 0}, // #1067
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 1, false, false,  9, 1,  6, 1,  0, 0}, // #1068
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI2SDZrrb_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 1, false, false,  9, 1,  6, 1,  0, 0}, // #1069
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz") 1, false, false,  9, 1,  6, 1,  0, 0}, // #1070
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1071
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1072
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1073
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1074
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1075
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1076
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm_VMOVDI2PDIZrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1077
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 1, false, false,  9, 1,  6, 1,  0, 0}, // #1078
  {DBGFIELD("VMOVSDZrm_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1079
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1080
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1081
  {DBGFIELD("VCVTPD2PSZ256rr_VCVTPD2PSZ256rrk_VCVTPD2PSZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1082
  {DBGFIELD("VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1083
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1084
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1085
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1086
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1087
  {DBGFIELD("VCVTPD2PSZrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1088
  {DBGFIELD("VCVTPS2PDZrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1089
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1090
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1091
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1092
  {DBGFIELD("VBROADCASTI32X2Z128m_VBROADCASTI32X2Z128mk_VBROADCASTI32X2Z128mkz_VPBROADCASTDZ128m_VPBROADCASTDZ128mk_VPBROADCASTDZ128mkz_VPBROADCASTQZ128m_VPBROADCASTQZ128mk_VPBROADCASTQZ128mkz") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1093
  {DBGFIELD("VBROADCASTSSZ128m_VBROADCASTSSZ128mk_VBROADCASTSSZ128mkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1094
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1095
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1096
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz_VMOVNTDQAZ128rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1097
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 1, false, false,  6, 2,  1, 1,  1, 1}, // #1098
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1099
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1100
  {DBGFIELD("VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 1, false, false, 14, 1, 10, 1,  0, 0}, // #1101
  {DBGFIELD("VCVTSS2SI64rr_Int")  1, false, false, 14, 1, 10, 1,  0, 0}, // #1102
  {DBGFIELD("VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int") 1, false, false, 14, 1, 10, 1,  0, 0}, // #1103
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1104
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1105
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1106
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1107
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1108
  {DBGFIELD("VSCATTERDPSZmr")     1, false, false,  6, 2,  1, 1,  0, 0}, // #1109
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk") 1, false, false, 10, 2,  7, 1,  1, 1}, // #1110
  {DBGFIELD("VPBROADCASTBZ256m_VPBROADCASTBZ256mk_VPBROADCASTBZ256mkz_VPBROADCASTBZm_VPBROADCASTBZmk_VPBROADCASTBZmkz_VPBROADCASTWZ256m_VPBROADCASTWZ256mk_VPBROADCASTWZ256mkz_VPBROADCASTWZm_VPBROADCASTWZmk_VPBROADCASTWZmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1111
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1112
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1113
  {DBGFIELD("VBROADCASTF32X2Z256m_VBROADCASTF32X2Z256mk_VBROADCASTF32X2Z256mkz_VBROADCASTF32X2Zm_VBROADCASTF32X2Zmk_VBROADCASTF32X2Zmkz_VBROADCASTI32X2Z256m_VBROADCASTI32X2Z256mk_VBROADCASTI32X2Z256mkz_VBROADCASTI32X2Zm_VBROADCASTI32X2Zmk_VBROADCASTI32X2Zmkz_VPBROADCASTDZ256m_VPBROADCASTDZ256mk_VPBROADCASTDZ256mkz_VPBROADCASTDZm_VPBROADCASTDZmk_VPBROADCASTDZmkz_VPBROADCASTQZ256m_VPBROADCASTQZ256mk_VPBROADCASTQZ256mkz_VPBROADCASTQZm_VPBROADCASTQZmk_VPBROADCASTQZmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1114
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1115
  {DBGFIELD("VBROADCASTSDZ256m_VBROADCASTSDZ256mk_VBROADCASTSDZ256mkz_VBROADCASTSDZm_VBROADCASTSDZmk_VBROADCASTSDZmkz_VBROADCASTSSZ256m_VBROADCASTSSZ256mk_VBROADCASTSSZ256mkz_VBROADCASTSSZm_VBROADCASTSSZmk_VBROADCASTSSZmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1116
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1117
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1118
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1119
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1120
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1121
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz_VMOVNTDQAZ256rm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1122
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1123
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1124
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1125
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1126
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1127
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1128
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1129
  {DBGFIELD("VPSCATTERDDZmr")     1, false, false,  6, 2,  1, 1,  0, 0}, // #1130
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 1, false, false,  6, 2,  1, 1,  1, 1}, // #1131
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbi_alt_VCMPPDZ128rmbi_altk_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmi_alt_VCMPPDZ128rmi_altk_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbi_alt_VCMPPSZ128rmbi_altk_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmi_alt_VCMPPSZ128rmi_altk_VCMPPSZ128rmik") 1, false, false, 10, 2,  7, 1,  1, 1}, // #1132
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSDZrmi_alt_VCMPSDZrmi_altk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk_VCMPSSZrmi_alt_VCMPSSZrmi_altk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 1, false, false, 10, 2,  7, 1,  1, 1}, // #1133
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmi_alt_VPCMPBZ128rmik_VPCMPBZ128rmik_alt_VPCMPDZ128rmi_VPCMPDZ128rmi_alt_VPCMPDZ128rmib_VPCMPDZ128rmib_alt_VPCMPDZ128rmibk_VPCMPDZ128rmibk_alt_VPCMPDZ128rmik_VPCMPDZ128rmik_alt_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmi_alt_VPCMPQZ128rmib_VPCMPQZ128rmib_alt_VPCMPQZ128rmibk_VPCMPQZ128rmibk_alt_VPCMPQZ128rmik_VPCMPQZ128rmik_alt_VPCMPUBZ128rmi_VPCMPUBZ128rmi_alt_VPCMPUBZ128rmik_VPCMPUBZ128rmik_alt_VPCMPUDZ128rmi_VPCMPUDZ128rmi_alt_VPCMPUDZ128rmib_VPCMPUDZ128rmib_alt_VPCMPUDZ128rmibk_VPCMPUDZ128rmibk_alt_VPCMPUDZ128rmik_VPCMPUDZ128rmik_alt_VPCMPUQZ128rmi_VPCMPUQZ128rmi_alt_VPCMPUQZ128rmib_VPCMPUQZ128rmib_alt_VPCMPUQZ128rmibk_VPCMPUQZ128rmibk_alt_VPCMPUQZ128rmik_VPCMPUQZ128rmik_alt_VPCMPUWZ128rmi_VPCMPUWZ128rmi_alt_VPCMPUWZ128rmik_VPCMPUWZ128rmik_alt_VPCMPWZ128rmi_VPCMPWZ128rmi_alt_VPCMPWZ128rmik_VPCMPWZ128rmik_alt_VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 1, false, false,  6, 2,  1, 1,  1, 1}, // #1134
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1135
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1136
  {DBGFIELD("VPMOVSXBDZ128rm_VPMOVSXBDZ128rmk_VPMOVSXBDZ128rmkz_VPMOVSXBQZ128rm_VPMOVSXBQZ128rmk_VPMOVSXBQZ128rmkz_VPMOVSXBWZ128rm_VPMOVSXBWZ128rmk_VPMOVSXBWZ128rmkz_VPMOVSXDQZ128rm_VPMOVSXDQZ128rmk_VPMOVSXDQZ128rmkz_VPMOVSXWDZ128rm_VPMOVSXWDZ128rmk_VPMOVSXWDZ128rmkz_VPMOVSXWQZ128rm_VPMOVSXWQZ128rmk_VPMOVSXWQZ128rmkz_VPMOVZXBDZ128rm_VPMOVZXBDZ128rmk_VPMOVZXBDZ128rmkz_VPMOVZXBQZ128rm_VPMOVZXBQZ128rmk_VPMOVZXBQZ128rmkz_VPMOVZXBWZ128rm_VPMOVZXBWZ128rmk_VPMOVZXBWZ128rmkz_VPMOVZXDQZ128rm_VPMOVZXDQZ128rmk_VPMOVZXDQZ128rmkz_VPMOVZXWDZ128rm_VPMOVZXWDZ128rmk_VPMOVZXWDZ128rmkz_VPMOVZXWQZ128rm_VPMOVZXWQZ128rmk_VPMOVZXWQZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1137
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 1, false, false,  6, 2,  1, 1,  1, 1}, // #1138
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1139
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1140
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbi_alt_VCMPPDZ256rmbi_altk_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmi_alt_VCMPPDZ256rmi_altk_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbi_alt_VCMPPSZ256rmbi_altk_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmi_alt_VCMPPSZ256rmi_altk_VCMPPSZ256rmik") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1141
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbi_alt_VCMPPDZrmbi_altk_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmi_alt_VCMPPDZrmi_altk_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbi_alt_VCMPPSZrmbi_altk_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmi_alt_VCMPPSZrmi_altk_VCMPPSZrmik") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1142
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmi_alt_VPCMPBZ256rmik_VPCMPBZ256rmik_alt_VPCMPDZ256rmi_VPCMPDZ256rmi_alt_VPCMPDZ256rmib_VPCMPDZ256rmib_alt_VPCMPDZ256rmibk_VPCMPDZ256rmibk_alt_VPCMPDZ256rmik_VPCMPDZ256rmik_alt_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmi_alt_VPCMPQZ256rmib_VPCMPQZ256rmib_alt_VPCMPQZ256rmibk_VPCMPQZ256rmibk_alt_VPCMPQZ256rmik_VPCMPQZ256rmik_alt_VPCMPUBZ256rmi_VPCMPUBZ256rmi_alt_VPCMPUBZ256rmik_VPCMPUBZ256rmik_alt_VPCMPUDZ256rmi_VPCMPUDZ256rmi_alt_VPCMPUDZ256rmib_VPCMPUDZ256rmib_alt_VPCMPUDZ256rmibk_VPCMPUDZ256rmibk_alt_VPCMPUDZ256rmik_VPCMPUDZ256rmik_alt_VPCMPUQZ256rmi_VPCMPUQZ256rmi_alt_VPCMPUQZ256rmib_VPCMPUQZ256rmib_alt_VPCMPUQZ256rmibk_VPCMPUQZ256rmibk_alt_VPCMPUQZ256rmik_VPCMPUQZ256rmik_alt_VPCMPUWZ256rmi_VPCMPUWZ256rmi_alt_VPCMPUWZ256rmik_VPCMPUWZ256rmik_alt_VPCMPWZ256rmi_VPCMPWZ256rmi_alt_VPCMPWZ256rmik_VPCMPWZ256rmik_alt_VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1143
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmi_alt_VPCMPBZrmik_VPCMPBZrmik_alt_VPCMPDZrmi_VPCMPDZrmi_alt_VPCMPDZrmib_VPCMPDZrmib_alt_VPCMPDZrmibk_VPCMPDZrmibk_alt_VPCMPDZrmik_VPCMPDZrmik_alt_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmi_alt_VPCMPQZrmib_VPCMPQZrmib_alt_VPCMPQZrmibk_VPCMPQZrmibk_alt_VPCMPQZrmik_VPCMPQZrmik_alt_VPCMPUBZrmi_VPCMPUBZrmi_alt_VPCMPUBZrmik_VPCMPUBZrmik_alt_VPCMPUDZrmi_VPCMPUDZrmi_alt_VPCMPUDZrmib_VPCMPUDZrmib_alt_VPCMPUDZrmibk_VPCMPUDZrmibk_alt_VPCMPUDZrmik_VPCMPUDZrmik_alt_VPCMPUQZrmi_VPCMPUQZrmi_alt_VPCMPUQZrmib_VPCMPUQZrmib_alt_VPCMPUQZrmibk_VPCMPUQZrmibk_alt_VPCMPUQZrmik_VPCMPUQZrmik_alt_VPCMPUWZrmi_VPCMPUWZrmi_alt_VPCMPUWZrmik_VPCMPUWZrmik_alt_VPCMPWZrmi_VPCMPWZrmi_alt_VPCMPWZrmik_VPCMPWZrmik_alt_VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1144
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1145
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1146
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 1, false, false, 14, 1, 10, 1,  0, 0}, // #1147
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 1, false, false,  8, 1,  5, 1,  0, 0}, // #1148
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 1, false, false, 14, 1, 10, 1,  0, 0}, // #1149
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1150
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 1, false, false,  8, 1,  5, 1,  0, 0}, // #1151
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 1, false, false, 14, 1, 10, 1,  0, 0}, // #1152
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz") 1, false, false,  8, 1,  5, 1,  1, 1}, // #1153
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1154
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1155
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1156
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1157
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1158
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1159
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1160
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1161
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1162
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1163
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1164
  {DBGFIELD("VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1165
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1166
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1167
  {DBGFIELD("VCVTSD2SSZrm_VCVTSD2SSZrm_Int_VCVTSD2SSZrm_Intk_VCVTSD2SSZrm_Intkz") 1, false, false,  8, 1,  5, 1,  1, 1}, // #1168
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1169
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, 10, 2,  7, 1,  0, 0}, // #1170
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1171
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1172
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1173
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 1, false, false, 13, 1,  9, 1,  1, 1}, // #1174
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 1, false, false, 13, 1,  9, 1,  1, 1}, // #1175
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1176
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1177
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1178
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1179
  {DBGFIELD("VCVTPD2PSZrm_VCVTPD2PSZrmb_VCVTPD2PSZrmbk_VCVTPD2PSZrmbkz_VCVTPD2PSZrmk_VCVTPD2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1180
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1181
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1182
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1183
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 1, false, false, 10, 2,  7, 1,  1, 1}, // #1184
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1185
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1186
  {DBGFIELD("VGATHERDPSZ128rm_VGATHERQPSZrm_VPGATHERDDZ128rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1187
  {DBGFIELD("VGATHERQPSZ128rm_VGATHERQPSZ256rm_VPGATHERQDZ128rm_VPGATHERQDZ256rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1188
  {DBGFIELD("VGATHERDPDZ128rm_VGATHERQPDZ128rm_VPGATHERDQZ128rm_VPGATHERQQZ128rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1189
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1190
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1191
  {DBGFIELD("VGATHERDPDZ256rm_VGATHERQPDZ256rm_VPGATHERDQZ256rm_VPGATHERQDZrm_VPGATHERQQZ256rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1192
  {DBGFIELD("VGATHERDPDZrm_VGATHERQPDZrm_VPGATHERDQZrm_VPGATHERQQZrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1193
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1194
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1195
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1196
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1197
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1198
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1199
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1200
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1201
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1202
  {DBGFIELD("JWriteZeroLatency")  0, false, false,  0, 0,  0, 0,  0, 0}, // #1203
  {DBGFIELD("WriteVecALU")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1204
  {DBGFIELD("WriteVecALUX")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1205
  {DBGFIELD("WriteALU")           0, false, false,  0, 0,  0, 0,  0, 0}, // #1206
  {DBGFIELD("WriteFLogic")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1207
  {DBGFIELD("WriteVecLogic")      0, false, false,  0, 0,  0, 0,  0, 0}, // #1208
  {DBGFIELD("WriteVecLogicX")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1209
  {DBGFIELD("JWrite3OpsLEA")      0, false, false,  0, 0,  0, 0,  0, 0}, // #1210
  {DBGFIELD("WriteLEA")           0, false, false,  0, 0,  0, 0,  0, 0}, // #1211
}; // AtomModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc BroadwellModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  16383, false, false,  0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteZero")          1, false, false,  0, 0,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteVecALU")        1, false, false, 77, 4,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteALULd_WriteRMW") 3, false, false, 81, 6, 63, 2,  0, 0}, // #3
  {DBGFIELD("WriteJumpLd")        2, false, false, 87, 6,  6, 1,  0, 0}, // #4
  {DBGFIELD("WriteALU")           1, false, false, 79, 2,  1, 1,  0, 0}, // #5
  {DBGFIELD("WriteMove")          1, false, false, 79, 2,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteJump")          1, false, false, 93, 4,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, 79, 2,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteFStoreX")       2, false, false, 97, 4,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteFLoadX")        1, false, false, 101, 3,  7, 1,  0, 0}, // #10
  {DBGFIELD("WriteFStoreY")       2, false, false, 97, 4,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteFLoadY")        1, false, false, 101, 3,  6, 1,  0, 0}, // #12
  {DBGFIELD("WriteMicrocoded")    1, false, false, 79, 2,  4, 1,  0, 0}, // #13
  {DBGFIELD("WriteFSign")         1, false, false, 104, 8,  1, 1,  0, 0}, // #14
  {DBGFIELD("WriteADC")           1, false, false, 93, 4,  1, 1,  0, 0}, // #15
  {DBGFIELD("WriteADCRMW")        6, false, false, 112, 8, 10, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCLd_ReadAfterLd") 2, false, false, 87, 6,  6, 1,  9, 1}, // #17
  {DBGFIELD("WriteALURMW")        3, false, false, 81, 6,  5, 1,  0, 0}, // #18
  {DBGFIELD("WriteALULd_ReadAfterLd") 2, false, false, 120, 4,  6, 1,  9, 1}, // #19
  {DBGFIELD("WriteFAdd64XLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #20
  {DBGFIELD("WriteFAdd64X")       1, false, false, 133, 7, 21, 1,  0, 0}, // #21
  {DBGFIELD("WriteFAddXLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #22
  {DBGFIELD("WriteFAddX")         1, false, false, 133, 7, 21, 1,  0, 0}, // #23
  {DBGFIELD("WriteFAdd64Ld_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #24
  {DBGFIELD("WriteFAdd64")        1, false, false, 133, 7, 21, 1,  0, 0}, // #25
  {DBGFIELD("WriteFAddLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #26
  {DBGFIELD("WriteFAdd")          1, false, false, 133, 7, 21, 1,  0, 0}, // #27
  {DBGFIELD("WriteFAddLd")        2, false, false, 124, 9, 10, 1,  0, 0}, // #28
  {DBGFIELD("WriteAESDecEncLd_ReadAfterLd") 2, false, false, 140, 10, 19, 1,  9, 1}, // #29
  {DBGFIELD("WriteAESDecEnc")     1, false, false, 104, 8,  5, 1,  0, 0}, // #30
  {DBGFIELD("WriteAESIMCLd")      3, false, false, 150, 10, 65, 1,  0, 0}, // #31
  {DBGFIELD("WriteAESIMC")        2, false, false, 160, 8, 25, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESKeyGenLd")   11, false, false, 168, 14, 66, 1,  0, 0}, // #33
  {DBGFIELD("WriteAESKeyGen")     11, false, false, 182, 12, 36, 1,  0, 0}, // #34
  {DBGFIELD("WriteFLogicLd_ReadAfterLd") 2, false, false, 140, 10,  6, 1,  9, 1}, // #35
  {DBGFIELD("WriteFLogic")        1, false, false, 104, 8,  1, 1,  0, 0}, // #36
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 194, 8,  5, 1, 10, 1}, // #37
  {DBGFIELD("WriteBEXTR")         2, false, false, 202, 6, 20, 1,  0, 0}, // #38
  {DBGFIELD("WriteBEXTRLd")       3, false, false, 194, 8,  5, 1,  0, 0}, // #39
  {DBGFIELD("WriteALULd")         2, false, false, 120, 4,  6, 1,  0, 0}, // #40
  {DBGFIELD("WriteFBlendLd_ReadAfterLd") 2, false, false, 128, 5,  6, 1,  9, 1}, // #41
  {DBGFIELD("WriteFBlend")        1, false, false, 78, 3,  1, 1,  0, 0}, // #42
  {DBGFIELD("WriteFVarBlendLd_ReadAfterLd") 3, false, false, 150, 10,  5, 1,  9, 1}, // #43
  {DBGFIELD("WriteFVarBlend")     2, false, false, 160, 8, 20, 1,  0, 0}, // #44
  {DBGFIELD("WriteBSFLd")         2, false, false, 124, 9, 10, 1,  0, 0}, // #45
  {DBGFIELD("WriteBSF")           1, false, false, 133, 7, 21, 1,  0, 0}, // #46
  {DBGFIELD("WriteBSRLd")         2, false, false, 124, 9, 10, 1,  0, 0}, // #47
  {DBGFIELD("WriteBSR")           1, false, false, 133, 7, 21, 1,  0, 0}, // #48
  {DBGFIELD("WriteBSWAP32")       1, false, false, 77, 4,  1, 1,  0, 0}, // #49
  {DBGFIELD("WriteBSWAP64")       2, false, false, 202, 6, 20, 1,  0, 0}, // #50
  {DBGFIELD("WriteBitTest")       1, false, false, 93, 4,  1, 1,  0, 0}, // #51
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 208, 6,  6, 1, 10, 1}, // #52
  {DBGFIELD("WriteBZHI")          1, false, false, 77, 4,  1, 1,  0, 0}, // #53
  {DBGFIELD("WriteLoad")          1, false, false, 101, 3,  7, 1,  0, 0}, // #54
  {DBGFIELD("WriteCMOV2Ld_ReadAfterLd") 3, false, false, 214, 6,  5, 1,  9, 1}, // #55
  {DBGFIELD("WriteCMOV2")         2, false, false, 220, 4, 20, 1,  0, 0}, // #56
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 2, false, false, 87, 6,  6, 1,  9, 1}, // #57
  {DBGFIELD("WriteCMOV")          1, false, false, 93, 4,  1, 1,  0, 0}, // #58
  {DBGFIELD("WriteFCMOV")         1, false, false, 133, 7, 21, 1,  0, 0}, // #59
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 120, 4,  6, 1, 10, 1}, // #60
  {DBGFIELD("WriteFCmp64XLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #61
  {DBGFIELD("WriteFCmp64X")       1, false, false, 133, 7, 21, 1,  0, 0}, // #62
  {DBGFIELD("WriteFCmpXLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #63
  {DBGFIELD("WriteFCmpX")         1, false, false, 133, 7, 21, 1,  0, 0}, // #64
  {DBGFIELD("WriteFCmp64Ld_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #65
  {DBGFIELD("WriteFCmp64")        1, false, false, 133, 7, 21, 1,  0, 0}, // #66
  {DBGFIELD("WriteFCmpLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #67
  {DBGFIELD("WriteFCmp")          1, false, false, 133, 7, 21, 1,  0, 0}, // #68
  {DBGFIELD("WriteFComLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #69
  {DBGFIELD("WriteFCom")          1, false, false, 133, 7, 21, 1,  0, 0}, // #70
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #71
  {DBGFIELD("WriteCRC32")         1, false, false, 133, 7, 21, 1,  0, 0}, // #72
  {DBGFIELD("WriteNop")           1, false, false,  0, 0,  1, 1,  0, 0}, // #73
  {DBGFIELD("WriteCvtI2PDLd")     2, false, false, 124, 9,  9, 1,  0, 0}, // #74
  {DBGFIELD("WriteCvtI2PD")       1, false, false, 133, 7, 22, 1,  0, 0}, // #75
  {DBGFIELD("WriteCvtI2PSLd")     2, false, false, 124, 9,  9, 1,  0, 0}, // #76
  {DBGFIELD("WriteCvtI2PS")       1, false, false, 133, 7, 22, 1,  0, 0}, // #77
  {DBGFIELD("WriteCvtPD2ILd")     2, false, false, 124, 9, 10, 1,  0, 0}, // #78
  {DBGFIELD("WriteCvtPD2I")       1, false, false, 133, 7, 21, 1,  0, 0}, // #79
  {DBGFIELD("WriteCvtPD2PSLd")    2, false, false, 124, 9, 10, 1,  0, 0}, // #80
  {DBGFIELD("WriteCvtPD2PS")      1, false, false, 133, 7, 21, 1,  0, 0}, // #81
  {DBGFIELD("WriteCvtPS2ILd")     2, false, false, 124, 9, 10, 1,  0, 0}, // #82
  {DBGFIELD("WriteCvtPS2I")       1, false, false, 133, 7, 21, 1,  0, 0}, // #83
  {DBGFIELD("WriteCvtPS2PDLd")    2, false, false, 124, 9, 10, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtPS2PD")      1, false, false, 133, 7, 21, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtSD2ILd")     2, false, false, 124, 9, 10, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtSD2I")       1, false, false, 133, 7, 21, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtSD2SSLd")    2, false, false, 124, 9, 10, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #89
  {DBGFIELD("WriteCvtSD2SS")      1, false, false, 133, 7, 21, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, 124, 9,  9, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterLd") 2, false, false, 124, 9,  9, 1,  9, 1}, // #92
  {DBGFIELD("WriteCvtI2SD")       1, false, false, 133, 7, 22, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtI2SSLd")     2, false, false, 124, 9,  9, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterLd") 2, false, false, 124, 9,  9, 1,  9, 1}, // #95
  {DBGFIELD("WriteCvtI2SS")       1, false, false, 133, 7, 22, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtSS2SDLd")    2, false, false, 124, 9, 10, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #98
  {DBGFIELD("WriteCvtSS2SD")      1, false, false, 133, 7, 21, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtSS2ILd")     2, false, false, 124, 9, 10, 1,  0, 0}, // #100
  {DBGFIELD("WriteCvtSS2I")       1, false, false, 133, 7, 21, 1,  0, 0}, // #101
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 37, 1, 11, 2}, // #102
  {DBGFIELD("WriteDiv16")         1, false, false, 236, 10, 34, 1,  0, 0}, // #103
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 37, 1, 11, 2}, // #104
  {DBGFIELD("WriteDiv32")         1, false, false, 236, 10, 34, 1,  0, 0}, // #105
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 37, 1, 11, 2}, // #106
  {DBGFIELD("WriteDiv64")         1, false, false, 236, 10, 34, 1,  0, 0}, // #107
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 37, 1, 11, 2}, // #108
  {DBGFIELD("WriteDiv8")          1, false, false, 236, 10, 34, 1,  0, 0}, // #109
  {DBGFIELD("WriteFDiv64XLd_ReadAfterLd") 2, false, false, 246, 12, 65, 1,  9, 1}, // #110
  {DBGFIELD("WriteFDiv64X")       1, false, false, 258, 10, 25, 1,  0, 0}, // #111
  {DBGFIELD("WriteFDivXLd_ReadAfterLd") 2, false, false, 268, 12,  8, 1,  9, 1}, // #112
  {DBGFIELD("WriteFDivX")         1, false, false, 280, 10, 26, 1,  0, 0}, // #113
  {DBGFIELD("WriteFDivLd")        2, false, false, 268, 12,  8, 1,  0, 0}, // #114
  {DBGFIELD("WriteFDiv")          1, false, false, 290, 10, 26, 1,  0, 0}, // #115
  {DBGFIELD("WriteFDiv64Ld_ReadAfterLd") 2, false, false, 246, 12, 65, 1,  9, 1}, // #116
  {DBGFIELD("WriteFDiv64")        1, false, false, 300, 10, 25, 1,  0, 0}, // #117
  {DBGFIELD("WriteFDivLd_ReadAfterLd") 2, false, false, 268, 12,  8, 1,  9, 1}, // #118
  {DBGFIELD("WriteDPPDLd_ReadAfterLd") 4, false, false, 310, 16, 25, 1,  9, 1}, // #119
  {DBGFIELD("WriteDPPD")          3, false, false, 326, 14,  9, 1,  0, 0}, // #120
  {DBGFIELD("WriteDPPSLd_ReadAfterLd") 5, false, false, 340, 16, 65, 1,  9, 1}, // #121
  {DBGFIELD("WriteDPPS")          4, false, false, 356, 14, 25, 1,  0, 0}, // #122
  {DBGFIELD("WriteVecExtractSt")  3, false, false, 370, 11, 20, 1,  0, 0}, // #123
  {DBGFIELD("WriteVecExtract")    2, false, false, 381, 12, 20, 1,  0, 0}, // #124
  {DBGFIELD("WriteVecALUX")       1, false, false, 77, 4,  1, 1,  0, 0}, // #125
  {DBGFIELD("WriteFComLd")        2, false, false, 124, 9, 10, 1,  0, 0}, // #126
  {DBGFIELD("WriteEMMS")          31, false, false, 393, 5, 67, 1,  0, 0}, // #127
  {DBGFIELD("WriteFLDC")          2, false, false, 398, 4,  1, 1,  0, 0}, // #128
  {DBGFIELD("WriteVecALUXLd_ReadAfterLd") 2, false, false, 208, 6,  6, 1,  9, 1}, // #129
  {DBGFIELD("WriteFHAddLd_ReadAfterLd") 4, false, false, 402, 13, 18, 1,  9, 1}, // #130
  {DBGFIELD("WriteFHAdd")         3, false, false, 415, 11,  7, 1,  0, 0}, // #131
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 37, 1, 11, 2}, // #132
  {DBGFIELD("WriteIDiv16")        1, false, false, 236, 10, 34, 1,  0, 0}, // #133
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 37, 1, 11, 2}, // #134
  {DBGFIELD("WriteIDiv32")        1, false, false, 236, 10, 34, 1,  0, 0}, // #135
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 37, 1, 11, 2}, // #136
  {DBGFIELD("WriteIDiv64")        1, false, false, 236, 10, 34, 1,  0, 0}, // #137
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 37, 1, 11, 2}, // #138
  {DBGFIELD("WriteIDiv8")         1, false, false, 236, 10, 34, 1,  0, 0}, // #139
  {DBGFIELD("WriteIMulLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1, 11, 2}, // #140
  {DBGFIELD("WriteIMul")          1, false, false, 133, 7, 21, 1,  0, 0}, // #141
  {DBGFIELD("WriteIMulLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #142
  {DBGFIELD("WriteIMulLd")        2, false, false, 124, 9, 10, 1,  0, 0}, // #143
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1, 11, 2}, // #144
  {DBGFIELD("WriteIMul64")        1, false, false, 133, 7, 21, 1,  0, 0}, // #145
  {DBGFIELD("WriteIMul64Ld_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #146
  {DBGFIELD("WriteIMul64Ld")      2, false, false, 124, 9, 10, 1,  0, 0}, // #147
  {DBGFIELD("WriteFShuffleLd_ReadAfterLd") 2, false, false, 140, 10,  6, 1,  9, 1}, // #148
  {DBGFIELD("WriteFShuffle")      1, false, false, 104, 8,  1, 1,  0, 0}, // #149
  {DBGFIELD("WriteStore")         1, false, false, 97, 4,  1, 1,  0, 0}, // #150
  {DBGFIELD("WriteVecLogicX")     1, false, false, 78, 3,  1, 1,  0, 0}, // #151
  {DBGFIELD("WriteShuffle")       1, false, false, 104, 8,  1, 1,  0, 0}, // #152
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, 93, 4,  1, 1,  0, 0}, // #153
  {DBGFIELD("WriteVecLoadX")      1, false, false, 101, 3,  7, 1,  0, 0}, // #154
  {DBGFIELD("WriteLDMXCSR")       3, false, false, 426, 11,  5, 1,  0, 0}, // #155
  {DBGFIELD("WriteFLD0")          1, false, false, 437, 4,  1, 1,  0, 0}, // #156
  {DBGFIELD("WriteFLD1")          2, false, false, 398, 4,  1, 1,  0, 0}, // #157
  {DBGFIELD("WriteLEA")           1, false, false, 77, 4,  1, 1,  0, 0}, // #158
  {DBGFIELD("WriteFence")         1, false, false, 441, 5,  1, 1,  0, 0}, // #159
  {DBGFIELD("WriteLZCNTLd")       2, false, false, 124, 9, 10, 1,  0, 0}, // #160
  {DBGFIELD("WriteLZCNT")         1, false, false, 133, 7, 21, 1,  0, 0}, // #161
  {DBGFIELD("WriteVecStoreX")     2, false, false, 97, 4,  1, 1,  0, 0}, // #162
  {DBGFIELD("WriteVecStore")      2, false, false, 97, 4,  1, 1,  0, 0}, // #163
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, 237, 9,  1, 1,  0, 0}, // #164
  {DBGFIELD("WriteVecLoad")       1, false, false, 101, 3,  7, 1,  0, 0}, // #165
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, 104, 8,  1, 1,  0, 0}, // #166
  {DBGFIELD("WriteVecMoveX")      1, false, false, 78, 3,  1, 1,  0, 0}, // #167
  {DBGFIELD("WriteVecStoreNT")    2, false, false, 97, 4,  1, 1,  0, 0}, // #168
  {DBGFIELD("WriteVecMove")       1, false, false, 78, 3,  1, 1,  0, 0}, // #169
  {DBGFIELD("WriteVecALULd")      2, false, false, 208, 6,  6, 1,  0, 0}, // #170
  {DBGFIELD("WriteShuffleLd_ReadAfterLd") 2, false, false, 140, 10,  6, 1,  9, 1}, // #171
  {DBGFIELD("WriteVecALULd_ReadAfterLd") 2, false, false, 208, 6,  6, 1,  9, 1}, // #172
  {DBGFIELD("WriteVecLogicLd_ReadAfterLd") 2, false, false, 128, 5,  6, 1,  9, 1}, // #173
  {DBGFIELD("WriteVecLogic")      1, false, false, 78, 3,  1, 1,  0, 0}, // #174
  {DBGFIELD("WritePHAddLd_ReadAfterLd") 4, false, false, 446, 10, 10, 1,  9, 1}, // #175
  {DBGFIELD("WritePHAdd")         3, false, false, 456, 8, 21, 1,  0, 0}, // #176
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 2, false, false, 140, 10,  6, 1,  9, 1}, // #177
  {DBGFIELD("WriteVecInsert")     2, false, false, 160, 8, 20, 1,  0, 0}, // #178
  {DBGFIELD("WriteVecIMulLd_ReadAfterLd") 2, false, false, 225, 11, 18, 1,  9, 1}, // #179
  {DBGFIELD("WriteVecIMul")       1, false, false, 237, 9,  7, 1,  0, 0}, // #180
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, 237, 9,  1, 1,  0, 0}, // #181
  {DBGFIELD("WritePSADBWLd_ReadAfterLd") 2, false, false, 225, 11, 18, 1,  9, 1}, // #182
  {DBGFIELD("WritePSADBW")        1, false, false, 237, 9,  7, 1,  0, 0}, // #183
  {DBGFIELD("WriteVarShuffleLd_ReadAfterLd") 2, false, false, 140, 10,  6, 1,  9, 1}, // #184
  {DBGFIELD("WriteVarShuffle")    1, false, false, 104, 8,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteShuffleLd")     2, false, false, 140, 10,  6, 1,  0, 0}, // #186
  {DBGFIELD("WriteVecShiftImm")   1, false, false, 237, 9,  1, 1,  0, 0}, // #187
  {DBGFIELD("WriteVecShiftLd_ReadAfterLd") 2, false, false, 225, 11,  6, 1,  9, 1}, // #188
  {DBGFIELD("WriteVecShift")      1, false, false, 237, 9,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteFMoveX")        1, false, false, 104, 8,  1, 1,  0, 0}, // #190
  {DBGFIELD("WriteFShuffleLd")    2, false, false, 140, 10,  6, 1,  0, 0}, // #191
  {DBGFIELD("WriteFStore")        2, false, false, 97, 4,  1, 1,  0, 0}, // #192
  {DBGFIELD("WriteFMOVMSK")       1, false, false, 237, 9, 21, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecLoadNT")     1, false, false, 101, 3,  7, 1,  0, 0}, // #194
  {DBGFIELD("WriteStoreNT")       2, false, false, 97, 4,  1, 1,  0, 0}, // #195
  {DBGFIELD("WriteFStoreNTX")     2, false, false, 97, 4,  1, 1,  0, 0}, // #196
  {DBGFIELD("WriteFStoreNT")      2, false, false, 97, 4,  1, 1,  0, 0}, // #197
  {DBGFIELD("WriteFLoad")         1, false, false, 101, 3,  7, 1,  0, 0}, // #198
  {DBGFIELD("WriteMPSADLd_ReadAfterLd") 4, false, false, 464, 14, 19, 1,  9, 1}, // #199
  {DBGFIELD("WriteMPSAD")         3, false, false, 478, 12,  5, 1,  0, 0}, // #200
  {DBGFIELD("WriteFMul64XLd_ReadAfterLd") 2, false, false, 490, 6, 10, 1,  9, 1}, // #201
  {DBGFIELD("WriteFMul64X")       1, false, false, 437, 4, 21, 1,  0, 0}, // #202
  {DBGFIELD("WriteFMulXLd_ReadAfterLd") 2, false, false, 490, 6, 10, 1,  9, 1}, // #203
  {DBGFIELD("WriteFMulX")         1, false, false, 437, 4, 21, 1,  0, 0}, // #204
  {DBGFIELD("WriteFMul64Ld_ReadAfterLd") 2, false, false, 490, 6, 10, 1,  9, 1}, // #205
  {DBGFIELD("WriteFMul64")        1, false, false, 437, 4, 21, 1,  0, 0}, // #206
  {DBGFIELD("WriteFMulLd_ReadAfterLd") 2, false, false, 490, 6, 10, 1,  9, 1}, // #207
  {DBGFIELD("WriteFMul")          1, false, false, 437, 4, 21, 1,  0, 0}, // #208
  {DBGFIELD("WriteIMulLd_WriteIMulH") 3, false, false, 124, 9, 68, 2,  0, 0}, // #209
  {DBGFIELD("WriteIMul_WriteIMulH") 2, false, false, 133, 7, 70, 2,  0, 0}, // #210
  {DBGFIELD("WriteIMul64Ld_WriteIMulH") 3, false, false, 124, 9, 68, 2,  0, 0}, // #211
  {DBGFIELD("WriteIMul64_WriteIMulH") 2, false, false, 133, 7, 69, 2,  0, 0}, // #212
  {DBGFIELD("WriteFMulLd")        2, false, false, 490, 6, 10, 1,  0, 0}, // #213
  {DBGFIELD("WriteVecALUXLd")     2, false, false, 208, 6,  6, 1,  0, 0}, // #214
  {DBGFIELD("WriteShuffleXLd_ReadAfterLd") 2, false, false, 140, 10,  6, 1,  9, 1}, // #215
  {DBGFIELD("WriteShuffleX")      1, false, false, 104, 8,  1, 1,  0, 0}, // #216
  {DBGFIELD("WriteVecLogicXLd_ReadAfterLd") 2, false, false, 128, 5,  6, 1,  9, 1}, // #217
  {DBGFIELD("WriteVarBlendLd_ReadAfterLd") 3, false, false, 150, 10,  5, 1,  9, 1}, // #218
  {DBGFIELD("WriteVarBlend")      2, false, false, 160, 8, 20, 1,  0, 0}, // #219
  {DBGFIELD("WriteBlendLd_ReadAfterLd") 2, false, false, 140, 10,  6, 1,  9, 1}, // #220
  {DBGFIELD("WriteBlend")         1, false, false, 104, 8,  1, 1,  0, 0}, // #221
  {DBGFIELD("WriteCLMulLd_ReadAfterLd") 2, false, false, 225, 11, 18, 1,  9, 1}, // #222
  {DBGFIELD("WriteCLMul")         1, false, false, 237, 9,  7, 1,  0, 0}, // #223
  {DBGFIELD("WritePCmpEStrILd_ReadAfterLd") 9, false, false, 496, 14, 33, 1,  9, 1}, // #224
  {DBGFIELD("WritePCmpEStrI")     8, false, false, 510, 12, 29, 1,  0, 0}, // #225
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterLd") 10, false, false, 522, 14, 72, 1,  9, 1}, // #226
  {DBGFIELD("WritePCmpEStrM")     9, false, false, 536, 12, 65, 1,  0, 0}, // #227
  {DBGFIELD("WritePCmpIStrILd_ReadAfterLd") 4, false, false, 548, 11,  8, 1,  9, 1}, // #228
  {DBGFIELD("WritePCmpIStrI")     3, false, false, 559, 9, 26, 1,  0, 0}, // #229
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterLd") 4, false, false, 548, 11,  8, 1,  9, 1}, // #230
  {DBGFIELD("WritePCmpIStrM")     3, false, false, 559, 9, 26, 1,  0, 0}, // #231
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #232
  {DBGFIELD("WritePHAddXLd_ReadAfterLd") 4, false, false, 446, 10, 10, 1,  9, 1}, // #233
  {DBGFIELD("WritePHAddX")        3, false, false, 456, 8, 21, 1,  0, 0}, // #234
  {DBGFIELD("WritePHMINPOSLd")    2, false, false, 225, 11, 18, 1,  0, 0}, // #235
  {DBGFIELD("WritePHMINPOS")      1, false, false, 237, 9,  7, 1,  0, 0}, // #236
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterLd") 2, false, false, 124, 9,  9, 1,  9, 1}, // #237
  {DBGFIELD("WriteVecIMulXLd_ReadAfterLd") 2, false, false, 225, 11, 18, 1,  9, 1}, // #238
  {DBGFIELD("WriteVecIMulX")      1, false, false, 237, 9,  7, 1,  0, 0}, // #239
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, 237, 9, 21, 1,  0, 0}, // #240
  {DBGFIELD("WriteShuffleXLd")    2, false, false, 140, 10,  6, 1,  0, 0}, // #241
  {DBGFIELD("WritePMULLDLd_ReadAfterLd") 3, false, false, 568, 11, 24, 1,  9, 1}, // #242
  {DBGFIELD("WritePMULLD")        2, false, false, 579, 9, 18, 1,  0, 0}, // #243
  {DBGFIELD("WriteRMW")           1, false, false, 97, 4,  1, 1,  0, 0}, // #244
  {DBGFIELD("WritePOPCNTLd")      2, false, false, 124, 9, 10, 1,  0, 0}, // #245
  {DBGFIELD("WritePOPCNT")        1, false, false, 133, 7, 21, 1,  0, 0}, // #246
  {DBGFIELD("WritePSADBWXLd_ReadAfterLd") 2, false, false, 225, 11, 18, 1,  9, 1}, // #247
  {DBGFIELD("WritePSADBWX")       1, false, false, 237, 9,  7, 1,  0, 0}, // #248
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterLd") 2, false, false, 140, 10,  6, 1,  9, 1}, // #249
  {DBGFIELD("WriteVarShuffleX")   1, false, false, 104, 8,  1, 1,  0, 0}, // #250
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, 237, 9,  1, 1,  0, 0}, // #251
  {DBGFIELD("WriteVecShiftXLd_ReadAfterLd") 3, false, false, 588, 14,  5, 1,  9, 1}, // #252
  {DBGFIELD("WriteVecShiftX")     2, false, false, 381, 12, 20, 1,  0, 0}, // #253
  {DBGFIELD("WriteVecTestLd_ReadAfterLd") 3, false, false, 588, 14,  5, 1,  9, 1}, // #254
  {DBGFIELD("WriteVecTest")       2, false, false, 381, 12, 20, 1,  0, 0}, // #255
  {DBGFIELD("WriteShiftLd_WriteRMW") 3, false, false, 602, 8, 63, 2,  0, 0}, // #256
  {DBGFIELD("WriteShift")         1, false, false, 93, 4,  1, 1,  0, 0}, // #257
  {DBGFIELD("WriteFRcpXLd")       2, false, false, 225, 11, 18, 1,  0, 0}, // #258
  {DBGFIELD("WriteFRcpX")         1, false, false, 237, 9,  7, 1,  0, 0}, // #259
  {DBGFIELD("WriteFRcpLd_ReadAfterLd") 2, false, false, 225, 11, 18, 1,  9, 1}, // #260
  {DBGFIELD("WriteFRcp")          1, false, false, 237, 9,  7, 1,  0, 0}, // #261
  {DBGFIELD("WriteShiftLd")       2, false, false, 87, 6,  6, 1,  0, 0}, // #262
  {DBGFIELD("WriteFRndLd")        3, false, false, 610, 9, 26, 1,  0, 0}, // #263
  {DBGFIELD("WriteFRnd")          1, false, false, 101, 3,  6, 1,  0, 0}, // #264
  {DBGFIELD("WriteFRndLd_ReadAfterLd") 3, false, false, 610, 9, 26, 1,  9, 1}, // #265
  {DBGFIELD("WriteFRsqrtXLd")     2, false, false, 225, 11, 18, 1,  0, 0}, // #266
  {DBGFIELD("WriteFRsqrtX")       1, false, false, 237, 9,  7, 1,  0, 0}, // #267
  {DBGFIELD("WriteFRsqrtLd_ReadAfterLd") 2, false, false, 225, 11, 18, 1,  9, 1}, // #268
  {DBGFIELD("WriteFRsqrt")        1, false, false, 237, 9,  7, 1,  0, 0}, // #269
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 87, 6,  6, 1, 10, 1}, // #270
  {DBGFIELD("WriteSETCCStore")    3, false, false, 619, 7, 20, 1,  0, 0}, // #271
  {DBGFIELD("WriteSETCC")         1, false, false, 93, 4,  1, 1,  0, 0}, // #272
  {DBGFIELD("WriteSHDmrcl")       6, false, false, 626, 11, 26, 1,  0, 0}, // #273
  {DBGFIELD("WriteSHDmri")        4, false, false, 637, 9,  9, 1,  0, 0}, // #274
  {DBGFIELD("WriteSHDrrcl")       4, false, false, 646, 9,  6, 1,  0, 0}, // #275
  {DBGFIELD("WriteSHDrri")        1, false, false, 133, 7, 21, 1,  0, 0}, // #276
  {DBGFIELD("WriteFSqrt64XLd")    2, false, false, 655, 12, 31, 1,  0, 0}, // #277
  {DBGFIELD("WriteFSqrt64X")      1, false, false, 667, 10,  8, 1,  0, 0}, // #278
  {DBGFIELD("WriteFSqrtXLd")      2, false, false, 677, 12,  8, 1,  0, 0}, // #279
  {DBGFIELD("WriteFSqrtX")        1, false, false, 689, 10, 26, 1,  0, 0}, // #280
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterLd") 2, false, false, 655, 12, 31, 1,  9, 1}, // #281
  {DBGFIELD("WriteFSqrt64")       1, false, false, 258, 10,  8, 1,  0, 0}, // #282
  {DBGFIELD("WriteFSqrtLd_ReadAfterLd") 2, false, false, 677, 12,  8, 1,  9, 1}, // #283
  {DBGFIELD("WriteFSqrt")         1, false, false, 300, 10, 26, 1,  0, 0}, // #284
  {DBGFIELD("WriteFSqrt80")       1, false, false, 699, 10, 33, 1,  0, 0}, // #285
  {DBGFIELD("WriteSTMXCSR")       3, false, false, 370, 11, 20, 1,  0, 0}, // #286
  {DBGFIELD("WriteTZCNTLd")       2, false, false, 124, 9, 10, 1,  0, 0}, // #287
  {DBGFIELD("WriteTZCNT")         1, false, false, 133, 7, 21, 1,  0, 0}, // #288
  {DBGFIELD("WriteFMAZLd")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #289
  {DBGFIELD("WriteFMALd")         2, false, false, 490, 6, 18, 1,  0, 0}, // #290
  {DBGFIELD("WriteFAdd64YLd_ReadAfterLd") 2, false, false, 124, 9,  9, 1,  9, 1}, // #291
  {DBGFIELD("WriteFAdd64Y")       1, false, false, 133, 7, 21, 1,  0, 0}, // #292
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #293
  {DBGFIELD("WriteFAdd64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #294
  {DBGFIELD("WriteFAddYLd_ReadAfterLd") 2, false, false, 124, 9,  9, 1,  9, 1}, // #295
  {DBGFIELD("WriteFAddY")         1, false, false, 133, 7, 21, 1,  0, 0}, // #296
  {DBGFIELD("WriteFAddZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #297
  {DBGFIELD("WriteFAddZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #298
  {DBGFIELD("WriteShuffleYLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1,  9, 1}, // #299
  {DBGFIELD("WriteShuffleY")      1, false, false, 104, 8,  1, 1,  0, 0}, // #300
  {DBGFIELD("WriteShuffleZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #301
  {DBGFIELD("WriteShuffleZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #302
  {DBGFIELD("WriteFLogicYLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1,  9, 1}, // #303
  {DBGFIELD("WriteFLogicY")       1, false, false, 104, 8,  1, 1,  0, 0}, // #304
  {DBGFIELD("WriteFLogicZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #305
  {DBGFIELD("WriteFLogicZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #306
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterLd") 3, false, false, 150, 10, 10, 1,  9, 1}, // #307
  {DBGFIELD("WriteFVarBlendY")    2, false, false, 160, 8, 20, 1,  0, 0}, // #308
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #309
  {DBGFIELD("WriteFVarBlendZ")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #310
  {DBGFIELD("WriteFBlendYLd_ReadAfterLd") 2, false, false, 128, 5,  5, 1,  9, 1}, // #311
  {DBGFIELD("WriteFBlendY")       1, false, false, 78, 3,  1, 1,  0, 0}, // #312
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 150, 10, 10, 1, 13, 2}, // #313
  {DBGFIELD("WriteFVarBlendLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 150, 10,  5, 1, 13, 2}, // #314
  {DBGFIELD("WriteShuffle256Ld")  2, false, false, 140, 10,  9, 1,  0, 0}, // #315
  {DBGFIELD("WriteShuffle256")    1, false, false, 104, 8, 21, 1,  0, 0}, // #316
  {DBGFIELD("WriteShuffleYLd")    2, false, false, 140, 10,  5, 1,  0, 0}, // #317
  {DBGFIELD("WriteFShuffle256")   1, false, false, 104, 8, 21, 1,  0, 0}, // #318
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, 140, 10,  9, 1,  0, 0}, // #319
  {DBGFIELD("WriteFCmp64YLd_ReadAfterLd") 2, false, false, 124, 9,  9, 1,  9, 1}, // #320
  {DBGFIELD("WriteFCmp64Y")       1, false, false, 133, 7, 21, 1,  0, 0}, // #321
  {DBGFIELD("WriteFCmpYLd_ReadAfterLd") 2, false, false, 124, 9,  9, 1,  9, 1}, // #322
  {DBGFIELD("WriteFCmpY")         1, false, false, 133, 7, 21, 1,  0, 0}, // #323
  {DBGFIELD("WriteFCmpZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #324
  {DBGFIELD("WriteFCmpZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #325
  {DBGFIELD("WriteVarShuffle256Ld") 2, false, false, 140, 10,  9, 1,  0, 0}, // #326
  {DBGFIELD("WriteVarShuffle256") 1, false, false, 104, 8, 21, 1,  0, 0}, // #327
  {DBGFIELD("WriteCvtI2PDYLd")    2, false, false, 124, 9,  9, 1,  0, 0}, // #328
  {DBGFIELD("WriteCvtI2PDY")      1, false, false, 133, 7, 22, 1,  0, 0}, // #329
  {DBGFIELD("WriteCvtI2PDZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #330
  {DBGFIELD("WriteCvtI2PDZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #331
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, 124, 9,  9, 1,  0, 0}, // #332
  {DBGFIELD("WriteCvtI2PSY")      1, false, false, 133, 7, 22, 1,  0, 0}, // #333
  {DBGFIELD("WriteCvtI2PSZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #334
  {DBGFIELD("WriteCvtI2PSZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #335
  {DBGFIELD("WriteCvtPD2IYLd")    2, false, false, 124, 9, 10, 1,  0, 0}, // #336
  {DBGFIELD("WriteCvtPD2IY")      1, false, false, 133, 7, 21, 1,  0, 0}, // #337
  {DBGFIELD("WriteCvtPD2IZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("WriteCvtPD2IZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #339
  {DBGFIELD("WriteCvtPD2PSYLd")   2, false, false, 124, 9, 10, 1,  0, 0}, // #340
  {DBGFIELD("WriteCvtPD2PSY")     1, false, false, 133, 7, 21, 1,  0, 0}, // #341
  {DBGFIELD("WriteCvtPD2PSZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD("WriteCvtPD2PSZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #343
  {DBGFIELD("WriteCvtPH2PSYLd")   2, false, false, 225, 11,  6, 1,  0, 0}, // #344
  {DBGFIELD("WriteCvtPH2PSY")     2, false, false, 381, 12, 20, 1,  0, 0}, // #345
  {DBGFIELD("WriteCvtPH2PSLd")    2, false, false, 225, 11,  6, 1,  0, 0}, // #346
  {DBGFIELD("WriteCvtPH2PS")      2, false, false, 381, 12, 20, 1,  0, 0}, // #347
  {DBGFIELD("WriteCvtPH2PSZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #348
  {DBGFIELD("WriteCvtPH2PSZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #349
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, 124, 9, 10, 1,  0, 0}, // #350
  {DBGFIELD("WriteCvtPS2IY")      1, false, false, 133, 7, 21, 1,  0, 0}, // #351
  {DBGFIELD("WriteCvtPS2IZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #352
  {DBGFIELD("WriteCvtPS2IZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #353
  {DBGFIELD("WriteCvtPS2PDYLd")   2, false, false, 124, 9, 10, 1,  0, 0}, // #354
  {DBGFIELD("WriteCvtPS2PDY")     1, false, false, 133, 7, 21, 1,  0, 0}, // #355
  {DBGFIELD("WriteCvtPS2PDZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #356
  {DBGFIELD("WriteCvtPS2PDZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #357
  {DBGFIELD("WriteCvtPS2PHYSt")   3, false, false, 709, 10,  5, 1,  0, 0}, // #358
  {DBGFIELD("WriteCvtPS2PHY")     2, false, false, 719, 11,  6, 1,  0, 0}, // #359
  {DBGFIELD("WriteCvtPS2PHSt")    3, false, false, 709, 10,  7, 1,  0, 0}, // #360
  {DBGFIELD("WriteCvtPS2PH")      2, false, false, 719, 11, 22, 1,  0, 0}, // #361
  {DBGFIELD("WriteCvtPS2PHZSt")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #362
  {DBGFIELD("WriteCvtPS2PHZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #363
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #364
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #365
  {DBGFIELD("WritePSADBWYLd_ReadAfterLd") 2, false, false, 225, 11, 26, 1,  9, 1}, // #366
  {DBGFIELD("WritePSADBWY")       1, false, false, 237, 9,  7, 1,  0, 0}, // #367
  {DBGFIELD("WritePSADBWZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #368
  {DBGFIELD("WritePSADBWZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #369
  {DBGFIELD("WriteFDiv64YLd_ReadAfterLd") 4, false, false, 730, 12, 36, 1,  9, 1}, // #370
  {DBGFIELD("WriteFDiv64Y")       3, false, false, 742, 10, 33, 1,  0, 0}, // #371
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #372
  {DBGFIELD("WriteFDiv64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #373
  {DBGFIELD("WriteFDivYLd_ReadAfterLd") 4, false, false, 752, 12, 33, 1,  9, 1}, // #374
  {DBGFIELD("WriteFDivY")         3, false, false, 764, 10, 28, 1,  0, 0}, // #375
  {DBGFIELD("WriteFDivZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #376
  {DBGFIELD("WriteFDivZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #377
  {DBGFIELD("WriteDPPSYLd_ReadAfterLd") 5, false, false, 340, 16, 30, 1,  9, 1}, // #378
  {DBGFIELD("WriteDPPSY")         4, false, false, 356, 14, 25, 1,  0, 0}, // #379
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterLd") 2, false, false, 140, 10,  9, 1,  9, 1}, // #380
  {DBGFIELD("WriteFMAYLd_ReadAfterLd_ReadAfterLd") 2, false, false, 490, 6, 26, 1, 15, 2}, // #381
  {DBGFIELD("WriteFMAY")          1, false, false, 437, 4,  7, 1,  0, 0}, // #382
  {DBGFIELD("WriteFMAXLd_ReadAfterLd") 2, false, false, 490, 6, 18, 1,  9, 1}, // #383
  {DBGFIELD("WriteFMAX")          1, false, false, 437, 4,  7, 1,  0, 0}, // #384
  {DBGFIELD("WriteFMAYLd_ReadAfterLd") 2, false, false, 490, 6, 26, 1,  9, 1}, // #385
  {DBGFIELD("WriteFMAZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #386
  {DBGFIELD("WriteFMAZ")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #387
  {DBGFIELD("WriteFMAXLd_ReadAfterLd_ReadAfterLd") 2, false, false, 490, 6, 18, 1, 15, 2}, // #388
  {DBGFIELD("WriteFMALd_ReadAfterLd") 2, false, false, 490, 6, 18, 1,  9, 1}, // #389
  {DBGFIELD("WriteFMA")           1, false, false, 437, 4,  7, 1,  0, 0}, // #390
  {DBGFIELD("WriteFMALd_ReadAfterLd_ReadAfterLd") 2, false, false, 490, 6, 18, 1, 15, 2}, // #391
  {DBGFIELD("WriteFMAYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 490, 6, 26, 1, 13, 2}, // #392
  {DBGFIELD("WriteFMAXLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 490, 6, 18, 1, 13, 2}, // #393
  {DBGFIELD("WriteFMALd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 490, 6, 18, 1, 13, 2}, // #394
  {DBGFIELD("WriteFRndYLd_ReadAfterLd") 3, false, false, 610, 9, 19, 1,  9, 1}, // #395
  {DBGFIELD("WriteFRndY")         1, false, false, 101, 3,  6, 1,  0, 0}, // #396
  {DBGFIELD("WriteFRndZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #397
  {DBGFIELD("WriteFRndZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #398
  {DBGFIELD("WriteVecIMulYLd_ReadAfterLd") 2, false, false, 225, 11, 26, 1,  9, 1}, // #399
  {DBGFIELD("WriteVecIMulY")      1, false, false, 237, 9,  7, 1,  0, 0}, // #400
  {DBGFIELD("WriteVecIMulZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #401
  {DBGFIELD("WriteVecIMulZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #402
  {DBGFIELD("WriteVecALUYLd_ReadAfterLd") 2, false, false, 208, 6,  5, 1,  9, 1}, // #403
  {DBGFIELD("WriteVecALUY")       1, false, false, 77, 4,  1, 1,  0, 0}, // #404
  {DBGFIELD("WriteVecALUZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteVecALUZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #406
  {DBGFIELD("WriteFHAddYLd_ReadAfterLd") 4, false, false, 402, 13, 26, 1,  9, 1}, // #407
  {DBGFIELD("WriteFHAddY")        3, false, false, 415, 11,  7, 1,  0, 0}, // #408
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterLd") 2, false, false, 140, 10,  9, 1,  9, 1}, // #409
  {DBGFIELD("WriteShuffle256Ld_ReadAfterLd") 2, false, false, 140, 10,  9, 1,  9, 1}, // #410
  {DBGFIELD("WriteVecLoadY")      1, false, false, 101, 3,  6, 1,  0, 0}, // #411
  {DBGFIELD("WriteFMaskedStoreY") 4, false, false, 774, 12,  7, 1,  0, 0}, // #412
  {DBGFIELD("WriteFMaskedLoadY")  3, false, false, 150, 10, 10, 1,  0, 0}, // #413
  {DBGFIELD("WriteFMaskedStore")  4, false, false, 774, 12,  7, 1,  0, 0}, // #414
  {DBGFIELD("WriteFMaskedLoad")   3, false, false, 150, 10,  5, 1,  0, 0}, // #415
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #416
  {DBGFIELD("WriteFCmp64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #417
  {DBGFIELD("WriteFMoveY")        1, false, false, 104, 8,  1, 1,  0, 0}, // #418
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, 140, 10,  5, 1,  0, 0}, // #419
  {DBGFIELD("WriteFShuffleY")     1, false, false, 104, 8,  1, 1,  0, 0}, // #420
  {DBGFIELD("WriteFShuffleZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #421
  {DBGFIELD("WriteFShuffleZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #422
  {DBGFIELD("WriteVecStoreY")     2, false, false, 97, 4,  1, 1,  0, 0}, // #423
  {DBGFIELD("WriteVecMoveY")      1, false, false, 78, 3,  1, 1,  0, 0}, // #424
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, 101, 3,  6, 1,  0, 0}, // #425
  {DBGFIELD("WriteVecStoreNTY")   2, false, false, 97, 4,  1, 1,  0, 0}, // #426
  {DBGFIELD("WriteFStoreNTY")     2, false, false, 97, 4,  1, 1,  0, 0}, // #427
  {DBGFIELD("WriteMPSADYLd_ReadAfterLd") 4, false, false, 464, 14, 27, 1,  9, 1}, // #428
  {DBGFIELD("WriteMPSADY")        3, false, false, 478, 12,  5, 1,  0, 0}, // #429
  {DBGFIELD("WriteFMul64YLd_ReadAfterLd") 2, false, false, 490, 6,  9, 1,  9, 1}, // #430
  {DBGFIELD("WriteFMul64Y")       1, false, false, 437, 4, 21, 1,  0, 0}, // #431
  {DBGFIELD("WriteFMul64ZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #432
  {DBGFIELD("WriteFMul64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #433
  {DBGFIELD("WriteFMulYLd_ReadAfterLd") 2, false, false, 490, 6,  9, 1,  9, 1}, // #434
  {DBGFIELD("WriteFMulY")         1, false, false, 437, 4, 21, 1,  0, 0}, // #435
  {DBGFIELD("WriteFMulZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #436
  {DBGFIELD("WriteFMulZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #437
  {DBGFIELD("WriteVecALUYLd")     2, false, false, 208, 6,  5, 1,  0, 0}, // #438
  {DBGFIELD("WriteVecALUZLd")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #439
  {DBGFIELD("WriteVecLogicYLd_ReadAfterLd") 2, false, false, 128, 5,  5, 1,  9, 1}, // #440
  {DBGFIELD("WriteVecLogicY")     1, false, false, 78, 3,  1, 1,  0, 0}, // #441
  {DBGFIELD("WriteVecLogicZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("WriteVecLogicZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #443
  {DBGFIELD("WriteBlendYLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1,  9, 1}, // #444
  {DBGFIELD("WriteBlendY")        1, false, false, 104, 8,  1, 1,  0, 0}, // #445
  {DBGFIELD("WriteVarBlendYLd_ReadAfterLd") 3, false, false, 150, 10, 10, 1,  9, 1}, // #446
  {DBGFIELD("WriteVarBlendY")     2, false, false, 160, 8, 20, 1,  0, 0}, // #447
  {DBGFIELD("WriteVarBlendZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #448
  {DBGFIELD("WriteVarBlendZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #449
  {DBGFIELD("WriteVarBlendYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 150, 10, 10, 1, 13, 2}, // #450
  {DBGFIELD("WriteVarBlendLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 150, 10,  5, 1, 13, 2}, // #451
  {DBGFIELD("WriteShuffleYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 140, 10,  5, 1, 13, 2}, // #452
  {DBGFIELD("WriteShuffleYLd_ReadAfterLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1, 15, 2}, // #453
  {DBGFIELD("WriteShuffleXLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 140, 10,  6, 1, 13, 2}, // #454
  {DBGFIELD("WriteShuffleXLd_ReadAfterLd_ReadAfterLd") 2, false, false, 140, 10,  6, 1, 15, 2}, // #455
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterLd") 2, false, false, 140, 10,  9, 1,  9, 1}, // #456
  {DBGFIELD("WriteFVarShuffle256") 1, false, false, 104, 8, 21, 1,  0, 0}, // #457
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 140, 10,  5, 1, 13, 2}, // #458
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1, 15, 2}, // #459
  {DBGFIELD("WriteFVarShuffleY")  1, false, false, 104, 8,  1, 1,  0, 0}, // #460
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 140, 10,  6, 1, 13, 2}, // #461
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterLd_ReadAfterLd") 2, false, false, 140, 10,  6, 1, 15, 2}, // #462
  {DBGFIELD("WriteFVarShuffle")   1, false, false, 104, 8,  1, 1,  0, 0}, // #463
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1,  9, 1}, // #464
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterLd") 2, false, false, 140, 10,  6, 1,  9, 1}, // #465
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #466
  {DBGFIELD("WriteFVarShuffleZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #467
  {DBGFIELD("WritePHAddYLd_ReadAfterLd") 4, false, false, 446, 10,  9, 1,  9, 1}, // #468
  {DBGFIELD("WritePHAddY")        3, false, false, 456, 8, 21, 1,  0, 0}, // #469
  {DBGFIELD("WriteVecIMulXLd")    2, false, false, 225, 11, 18, 1,  0, 0}, // #470
  {DBGFIELD("WriteVecIMulYLd")    2, false, false, 225, 11, 26, 1,  0, 0}, // #471
  {DBGFIELD("WriteVecIMulZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #472
  {DBGFIELD("WriteVecMaskedStoreY") 4, false, false, 774, 12,  7, 1,  0, 0}, // #473
  {DBGFIELD("WriteVecMaskedLoadY") 3, false, false, 150, 10, 10, 1,  0, 0}, // #474
  {DBGFIELD("WriteVecMaskedStore") 4, false, false, 774, 12,  7, 1,  0, 0}, // #475
  {DBGFIELD("WriteVecMaskedLoad") 3, false, false, 150, 10,  5, 1,  0, 0}, // #476
  {DBGFIELD("WriteVecMOVMSKY")    1, false, false, 237, 9, 21, 1,  0, 0}, // #477
  {DBGFIELD("WritePMULLDYLd_ReadAfterLd") 3, false, false, 568, 11,  8, 1,  9, 1}, // #478
  {DBGFIELD("WritePMULLDY")       2, false, false, 579, 9, 18, 1,  0, 0}, // #479
  {DBGFIELD("WritePMULLDZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WritePMULLDZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #481
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 140, 10,  6, 1, 13, 2}, // #482
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterLd_ReadAfterLd") 2, false, false, 140, 10,  6, 1, 15, 2}, // #483
  {DBGFIELD("WriteVecShiftImmXLd") 2, false, false, 225, 11,  6, 1,  0, 0}, // #484
  {DBGFIELD("WriteVecShiftImmYLd") 2, false, false, 225, 11,  5, 1,  0, 0}, // #485
  {DBGFIELD("WriteVecShiftImmY")  1, false, false, 237, 9,  1, 1,  0, 0}, // #486
  {DBGFIELD("WriteVecShiftImmZLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteVecShiftImmZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #488
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterLd") 4, false, false, 786, 14, 10, 1,  9, 1}, // #489
  {DBGFIELD("WriteVarVecShift")   3, false, false, 800, 12, 21, 1,  0, 0}, // #490
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterLd") 4, false, false, 786, 14,  9, 1,  9, 1}, // #491
  {DBGFIELD("WriteVarVecShiftY")  3, false, false, 800, 12, 21, 1,  0, 0}, // #492
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #493
  {DBGFIELD("WriteVarVecShiftZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #494
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterLd") 2, false, false, 225, 11,  6, 1,  9, 1}, // #495
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1,  9, 1}, // #496
  {DBGFIELD("WriteVarShuffleY")   1, false, false, 104, 8,  1, 1,  0, 0}, // #497
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #498
  {DBGFIELD("WriteVarShuffleZ")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #499
  {DBGFIELD("WriteShuffleZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #500
  {DBGFIELD("WriteVecShiftYLd_ReadAfterLd") 2, false, false, 225, 11,  5, 1,  9, 1}, // #501
  {DBGFIELD("WriteVecShiftY")     2, false, false, 381, 12, 22, 1,  0, 0}, // #502
  {DBGFIELD("WriteVecShiftZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #503
  {DBGFIELD("WriteVecShiftZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #504
  {DBGFIELD("WriteVecTestYLd_ReadAfterLd") 3, false, false, 588, 14, 18, 1,  9, 1}, // #505
  {DBGFIELD("WriteVecTestY")      2, false, false, 381, 12, 22, 1,  0, 0}, // #506
  {DBGFIELD("WriteFRcpXLd_ReadAfterLd") 2, false, false, 225, 11, 18, 1,  9, 1}, // #507
  {DBGFIELD("WriteFRcpYLd_ReadAfterLd") 4, false, false, 731, 11, 28, 1,  9, 1}, // #508
  {DBGFIELD("WriteFRcpY")         3, false, false, 743, 9, 26, 1,  0, 0}, // #509
  {DBGFIELD("WriteFRcpZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #510
  {DBGFIELD("WriteFRcpZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #511
  {DBGFIELD("WriteFRcpYLd")       4, false, false, 731, 11, 28, 1,  0, 0}, // #512
  {DBGFIELD("WriteFRndYLd")       3, false, false, 610, 9, 19, 1,  0, 0}, // #513
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterLd") 2, false, false, 225, 11, 18, 1,  9, 1}, // #514
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterLd") 4, false, false, 731, 11, 28, 1,  9, 1}, // #515
  {DBGFIELD("WriteFRsqrtY")       3, false, false, 743, 9, 26, 1,  0, 0}, // #516
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #517
  {DBGFIELD("WriteFRsqrtZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #518
  {DBGFIELD("WriteFRsqrtYLd")     4, false, false, 731, 11, 28, 1,  0, 0}, // #519
  {DBGFIELD("WriteFShuffleYLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1,  9, 1}, // #520
  {DBGFIELD("WriteFShuffleZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #521
  {DBGFIELD("WriteFSqrt64YLd")    4, false, false, 812, 12, 73, 1,  0, 0}, // #522
  {DBGFIELD("WriteFSqrt64Y")      3, false, false, 824, 10, 36, 1,  0, 0}, // #523
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterLd") 2, false, false, 655, 12, 31, 1,  9, 1}, // #524
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterLd") 4, false, false, 812, 12, 73, 1,  9, 1}, // #525
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #526
  {DBGFIELD("WriteFSqrt64Z")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #527
  {DBGFIELD("WriteFSqrtYLd")      4, false, false, 834, 12, 74, 1,  0, 0}, // #528
  {DBGFIELD("WriteFSqrtY")        3, false, false, 846, 10, 31, 1,  0, 0}, // #529
  {DBGFIELD("WriteFSqrtXLd_ReadAfterLd") 2, false, false, 677, 12,  8, 1,  9, 1}, // #530
  {DBGFIELD("WriteFSqrtYLd_ReadAfterLd") 4, false, false, 834, 12, 74, 1,  9, 1}, // #531
  {DBGFIELD("WriteFSqrtZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #532
  {DBGFIELD("WriteFSqrtZ")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WriteFTestYLd_ReadAfterLd") 2, false, false, 225, 11,  5, 1,  9, 1}, // #534
  {DBGFIELD("WriteFTestY")        1, false, false, 237, 9,  1, 1,  0, 0}, // #535
  {DBGFIELD("WriteFTestLd_ReadAfterLd") 2, false, false, 225, 11,  6, 1,  9, 1}, // #536
  {DBGFIELD("WriteFTest")         1, false, false, 237, 9,  1, 1,  0, 0}, // #537
  {DBGFIELD("MUL16m_IMUL16m")     5, false, false, 856, 11,  9, 1,  0, 0}, // #538
  {DBGFIELD("MUL32r_IMUL32r")     3, false, false, 867, 9, 22, 1,  0, 0}, // #539
  {DBGFIELD("IMUL64rri8_IMUL64rri32") 1, false, false, 133, 7, 21, 1,  0, 0}, // #540
  {DBGFIELD("IMUL64rmi8_IMUL64rmi32") 2, false, false, 124, 9, 10, 1,  0, 0}, // #541
  {DBGFIELD("COPY")               1, false, false, 79, 2,  1, 1,  0, 0}, // #542
  {DBGFIELD("FXAM")               1, false, false, 79, 2,  4, 1,  0, 0}, // #543
  {DBGFIELD("LD_Frr")             1, false, false, 79, 2,  1, 1,  0, 0}, // #544
  {DBGFIELD("MOVSX64rr32")        1, false, false, 79, 2,  1, 1,  0, 0}, // #545
  {DBGFIELD("RCL16m1_RCL16mCL_RCL16mi_RCL32m1_RCL32mCL_RCL32mi_RCL64m1_RCL64mCL_RCL64mi_RCL8m1_RCL8mCL_RCL8mi_RCR16m1_RCR16mCL_RCR16mi_RCR32m1_RCR32mCL_RCR32mi_RCR64m1_RCR64mCL_RCR64mi_RCR8m1_RCR8mCL_RCR8mi_ROL16m1_ROL16mCL_ROL16mi_ROL32m1_ROL32mCL_ROL32mi_ROL64m1_ROL64mCL_ROL64mi_ROL8m1_ROL8mCL_ROL8mi_ROR16m1_ROR16mCL_ROR16mi_ROR32m1_ROR32mCL_ROR32mi_ROR64m1_ROR64mCL_ROR64mi_ROR8m1_ROR8mCL_ROR8mi_SAR16m1_SAR16mCL_SAR16mi_SAR32m1_SAR32mCL_SAR32mi_SAR64m1_SAR64mCL_SAR64mi_SAR8m1_SAR8mCL_SAR8mi_SHL16m1_SHL16mCL_SHL16mi_SHL32m1_SHL32mCL_SHL32mi_SHL64m1_SHL64mCL_SHL64mi_SHL8m1_SHL8mCL_SHL8mi_SHR16m1_SHR16mCL_SHR16mi_SHR32m1_SHR32mCL_SHR32mi_SHR64m1_SHR64mCL_SHR64mi_SHR8m1_SHR8mCL_SHR8mi") 11, false, false, 876, 11, 29, 1,  0, 0}, // #546
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, 79, 2,  1, 1,  0, 0}, // #547
  {DBGFIELD("IMUL32rm")           2, false, false, 124, 9, 10, 1,  9, 1}, // #548
  {DBGFIELD("IMUL32rmi_IMUL32rmi8") 2, false, false, 124, 9, 10, 1,  0, 0}, // #549
  {DBGFIELD("IMUL32rr_IMUL32rri_IMUL32rri8") 1, false, false, 133, 7, 21, 1,  0, 0}, // #550
  {DBGFIELD("FCOMPP")             1, false, false, 79, 2,  4, 1,  0, 0}, // #551
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, 133, 7, 21, 1,  0, 0}, // #552
  {DBGFIELD("BT16ri8_BT16rr_BT32ri8_BT32rr_BT64ri8_BT64rr_BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 1, false, false, 93, 4,  1, 1,  0, 0}, // #553
  {DBGFIELD("MMX_CVTPI2PSirr")    1, false, false, 133, 7, 21, 1,  0, 0}, // #554
  {DBGFIELD("MMX_CVTPI2PSirm")    2, false, false, 124, 9, 10, 1,  0, 0}, // #555
  {DBGFIELD("MMX_CVTPS2PIirr_MMX_CVTTPS2PIirr") 2, false, false, 719, 11, 22, 1,  0, 0}, // #556
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 2, false, false, 120, 4,  6, 1,  0, 0}, // #557
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, 97, 4,  1, 1,  0, 0}, // #558
  {DBGFIELD("XCH_F")              12, false, false, 887, 14, 25, 1,  0, 0}, // #559
  {DBGFIELD("RETIL_RETIQ_RETIW_IRET_IRET16_IRET32_IRET64") 2, false, false, 87, 6,  6, 1,  0, 0}, // #560
  {DBGFIELD("MMX_CVTPS2PIirm_MMX_CVTTPS2PIirm") 2, false, false, 124, 9, 10, 1,  0, 0}, // #561
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 2, false, false, 124, 9,  9, 1,  0, 0}, // #562
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 2, false, false, 166, 2, 20, 1,  0, 0}, // #563
  {DBGFIELD("LFENCE")             2, false, false, 166, 2, 20, 1,  0, 0}, // #564
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, 104, 8,  1, 1,  0, 0}, // #565
  {DBGFIELD("PSLLDQri_PSRLDQri")  1, false, false, 104, 8,  1, 1,  0, 0}, // #566
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr_MMX_PUNPCKHBWirr_MMX_PUNPCKHDQirr_MMX_PUNPCKHWDirr") 1, false, false, 104, 8,  1, 1,  0, 0}, // #567
  {DBGFIELD("LEAVE_LEAVE64")      3, false, false, 901, 4,  5, 1,  0, 0}, // #568
  {DBGFIELD("POP16r")             2, false, false, 120, 4,  6, 1,  0, 0}, // #569
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 4, false, false, 81, 6,  6, 1,  0, 0}, // #570
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false, 79, 2,  4, 1,  0, 0}, // #571
  {DBGFIELD("BTC16mi8_BTC32mi8_BTC64mi8_BTR16mi8_BTR32mi8_BTR64mi8_BTS16mi8_BTS32mi8_BTS64mi8") 4, false, false, 602, 8,  6, 1,  0, 0}, // #572
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, 79, 2,  4, 1,  0, 0}, // #573
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr_XCHG16ar_XCHG16rr_XCHG32ar_XCHG32rr_XCHG64ar_XCHG64rr_XCHG8rr_MOVSX16rr8_MOVZX16rr8") 1, false, false, 79, 2,  1, 1,  0, 0}, // #574
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, 97, 4,  1, 1,  0, 0}, // #575
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, 79, 2,  1, 1,  0, 0}, // #576
  {DBGFIELD("MMX_PADDQirr_MMX_PSUBQirr") 1, false, false, 77, 4,  1, 1,  0, 0}, // #577
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 2, false, false, 97, 4,  1, 1,  0, 0}, // #578
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  2, false, false, 97, 4,  1, 1,  0, 0}, // #579
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, 77, 4,  1, 1,  0, 0}, // #580
  {DBGFIELD("CLD")                3, false, false, 905, 7, 21, 1,  0, 0}, // #581
  {DBGFIELD("LDDQUrm")            1, false, false, 101, 3,  7, 1,  0, 0}, // #582
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, 79, 2,  4, 1,  0, 0}, // #583
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 4, false, false, 81, 6,  6, 1,  0, 0}, // #584
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 6, false, false, 912, 6, 10, 1,  0, 0}, // #585
  {DBGFIELD("PHADDDrr_PHSUBDrr")  3, false, false, 456, 8, 21, 1,  0, 0}, // #586
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, 101, 3,  7, 1,  0, 0}, // #587
  {DBGFIELD("MMX_PADDQirm_MMX_PSUBQirm") 2, false, false, 208, 6,  6, 1,  9, 1}, // #588
  {DBGFIELD("MOVDQUrm")           1, false, false, 101, 3,  7, 1,  0, 0}, // #589
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, 101, 3,  7, 1,  0, 0}, // #590
  {DBGFIELD("PADDQrm_PSUBQrm")    2, false, false, 208, 6,  6, 1,  9, 1}, // #591
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, 79, 2,  1, 1,  0, 0}, // #592
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   2, false, false, 220, 4, 20, 1,  0, 0}, // #593
  {DBGFIELD("LD_F80m")            1, false, false, 101, 3,  6, 1,  0, 0}, // #594
  {DBGFIELD("PHADDDrm_PHSUBDrm")  4, false, false, 446, 10, 10, 1,  9, 1}, // #595
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 2, false, false, 381, 12, 20, 1,  0, 0}, // #596
  {DBGFIELD("FLDCW16m")           3, false, false, 918, 11,  5, 1,  0, 0}, // #597
  {DBGFIELD("ST_FP80m")           2, false, false, 97, 4,  1, 1,  0, 0}, // #598
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 3, false, false, 456, 8, 21, 1,  0, 0}, // #599
  {DBGFIELD("CMPXCHG8rm")         6, false, false, 112, 8, 10, 1,  0, 0}, // #600
  {DBGFIELD("INTO")               1, false, false, 79, 2,  4, 1,  0, 0}, // #601
  {DBGFIELD("XLAT")               1, false, false, 101, 3,  7, 1,  0, 0}, // #602
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 4, false, false, 646, 9,  6, 1,  0, 0}, // #603
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false, 133, 7, 21, 1,  0, 0}, // #604
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 6, false, false, 626, 11, 26, 1,  0, 0}, // #605
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 4, false, false, 637, 9,  9, 1,  0, 0}, // #606
  {DBGFIELD("IMUL16rr_IMUL16rri_IMUL16rri8") 1, false, false, 133, 7, 21, 1,  0, 0}, // #607
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 3, false, false, 709, 10, 22, 1,  0, 0}, // #608
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 4, false, false, 446, 10, 10, 1,  9, 1}, // #609
  {DBGFIELD("AAD8i8")             1, false, false, 79, 2,  4, 1,  0, 0}, // #610
  {DBGFIELD("LOOPE")              11, false, false, 929, 4, 26, 1,  0, 0}, // #611
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, 97, 4,  1, 1,  0, 0}, // #612
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 4, false, false, 646, 9,  6, 1,  0, 0}, // #613
  {DBGFIELD("FNSTCW16m")          3, false, false, 933, 10, 20, 1,  0, 0}, // #614
  {DBGFIELD("BT16mr_BT32mr_BT64mr") 2, false, false, 120, 4,  6, 1,  0, 0}, // #615
  {DBGFIELD("POPA16_POPA32")      1, false, false, 101, 3,  7, 1,  0, 0}, // #616
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, 97, 4,  1, 1,  0, 0}, // #617
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 6, false, false, 626, 11, 26, 1,  0, 0}, // #618
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 4, false, false, 637, 9,  9, 1,  0, 0}, // #619
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, 133, 7, 21, 1,  0, 0}, // #620
  {DBGFIELD("CMPXCHG8rr")         5, false, false, 943, 4,  7, 1,  0, 0}, // #621
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80_COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 133, 7, 21, 1,  0, 0}, // #622
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_CVTTSS2SI64rr_Int") 2, false, false, 947, 12, 22, 1,  0, 0}, // #623
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int") 2, false, false, 124, 9, 10, 1,  9, 1}, // #624
  {DBGFIELD("CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 4, false, false, 310, 16, 18, 1,  0, 0}, // #625
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, 79, 2,  4, 1,  0, 0}, // #626
  {DBGFIELD("BTC16mr_BTC32mr_BTC64mr_BTR16mr_BTR32mr_BTR64mr_BTS16mr_BTS32mr_BTS64mr") 3, false, false, 81, 6, 63, 2,  0, 0}, // #627
  {DBGFIELD("AAA_AAS")            1, false, false, 79, 2,  4, 1,  0, 0}, // #628
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 6, false, false, 112, 8, 10, 1,  0, 0}, // #629
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 5, false, false, 943, 4,  7, 1,  0, 0}, // #630
  {DBGFIELD("LOOPNE")             11, false, false, 929, 4, 26, 1,  0, 0}, // #631
  {DBGFIELD("PAUSE")              5, false, false, 959, 7,  7, 1,  0, 0}, // #632
  {DBGFIELD("CMPXCHG8B")          14, false, false, 966, 10,  8, 1,  0, 0}, // #633
  {DBGFIELD("DAA")                1, false, false, 79, 2,  4, 1,  0, 0}, // #634
  {DBGFIELD("LOOP")               7, false, false, 976, 9,  5, 1,  0, 0}, // #635
  {DBGFIELD("DAS")                1, false, false, 79, 2,  4, 1,  0, 0}, // #636
  {DBGFIELD("AAM8i8")             1, false, false, 79, 2,  4, 1,  0, 0}, // #637
  {DBGFIELD("STD")                6, false, false, 985, 7,  6, 1,  0, 0}, // #638
  {DBGFIELD("CMPXCHG16B")         19, false, false, 992, 15, 31, 1,  0, 0}, // #639
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, 79, 2,  4, 1,  0, 0}, // #640
  {DBGFIELD("FNCLEX_FXTRACT")     4, false, false, 368, 2, 22, 1,  0, 0}, // #641
  {DBGFIELD("POPF32_POPF64")      1, false, false, 101, 3,  7, 1,  0, 0}, // #642
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, 79, 2,  4, 1,  0, 0}, // #643
  {DBGFIELD("RDTSC_RDTSCP")       22, false, false, 1007, 8, 75, 1,  0, 0}, // #644
  {DBGFIELD("ENTER")              1, false, false, 79, 2,  4, 1,  0, 0}, // #645
  {DBGFIELD("POPF16")             1, false, false, 101, 3,  7, 1,  0, 0}, // #646
  {DBGFIELD("MONITORrrr")         1, false, false, 79, 2,  4, 1,  0, 0}, // #647
  {DBGFIELD("FRNDINT")            1, false, false, 79, 2,  4, 1,  0, 0}, // #648
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false, 79, 2,  4, 1,  0, 0}, // #649
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, 79, 2,  4, 1,  0, 0}, // #650
  {DBGFIELD("FPREM")              1, false, false, 79, 2,  4, 1,  0, 0}, // #651
  {DBGFIELD("INSB_INSL_INSW")     8, false, false, 1015, 15, 30, 1,  0, 0}, // #652
  {DBGFIELD("FNINIT")             15, false, false, 1030, 9, 76, 1,  0, 0}, // #653
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 23, false, false, 1039, 13, 73, 1,  0, 0}, // #654
  {DBGFIELD("FPREM1")             1, false, false, 79, 2,  4, 1,  0, 0}, // #655
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, 79, 2,  4, 1,  0, 0}, // #656
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 23, false, false, 1039, 13, 73, 1,  0, 0}, // #657
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, 79, 2,  4, 1,  0, 0}, // #658
  {DBGFIELD("FSCALE")             1, false, false, 79, 2,  4, 1,  0, 0}, // #659
  {DBGFIELD("RDMSR")              1, false, false, 79, 2,  4, 1,  0, 0}, // #660
  {DBGFIELD("RET_RETL_RETQ_RETW_LRETIL_LRETIQ_LRETIW_LRETL_LRETQ_LRETW") 2, false, false, 87, 6,  6, 1,  0, 0}, // #661
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 23, false, false, 1052, 13, 16, 1,  0, 0}, // #662
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 23, false, false, 1052, 13, 16, 1,  0, 0}, // #663
  {DBGFIELD("F2XM1")              1, false, false, 79, 2,  4, 1,  0, 0}, // #664
  {DBGFIELD("CPUID")              8, false, false, 1065, 11, 29, 1,  0, 0}, // #665
  {DBGFIELD("INT")                1, false, false, 79, 2,  4, 1,  0, 0}, // #666
  {DBGFIELD("INT3")               1, false, false, 79, 2,  4, 1,  0, 0}, // #667
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, 79, 2,  4, 1,  0, 0}, // #668
  {DBGFIELD("FXRSTOR_FXRSTOR64")  90, false, false, 1076, 15, 44, 1,  0, 0}, // #669
  {DBGFIELD("FYL2X")              1, false, false, 79, 2,  4, 1,  0, 0}, // #670
  {DBGFIELD("FYL2XP1")            1, false, false, 79, 2,  4, 1,  0, 0}, // #671
  {DBGFIELD("FPTAN")              1, false, false, 79, 2,  4, 1,  0, 0}, // #672
  {DBGFIELD("FSINCOS")            1, false, false, 79, 2,  4, 1,  0, 0}, // #673
  {DBGFIELD("COS_F_COS_Fp32_COS_Fp64_COS_Fp80_SIN_F_SIN_Fp32_SIN_Fp64_SIN_Fp80") 1, false, false, 79, 2,  4, 1,  0, 0}, // #674
  {DBGFIELD("FPATAN")             1, false, false, 79, 2,  4, 1,  0, 0}, // #675
  {DBGFIELD("WRMSR")              1, false, false, 79, 2,  4, 1,  0, 0}, // #676
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, 133, 7,  1, 1,  0, 0}, // #677
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, 133, 7,  1, 1,  0, 0}, // #678
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 2, false, false, 398, 4, 20, 1,  0, 0}, // #679
  {DBGFIELD("FNOP")               1, false, false, 437, 4,  1, 1,  0, 0}, // #680
  {DBGFIELD("RETQ")               3, false, false, 1091, 9,  5, 1,  0, 0}, // #681
  {DBGFIELD("CDQ_CQO")            1, false, false, 93, 4,  1, 1,  0, 0}, // #682
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, 77, 4,  1, 1,  0, 0}, // #683
  {DBGFIELD("MMX_PADDQirr")       1, false, false, 77, 4,  1, 1,  0, 0}, // #684
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, 104, 8,  1, 1,  0, 0}, // #685
  {DBGFIELD("ROL16r1_ROL32r1_ROL64r1_ROL8r1_ROL16ri_ROL32ri_ROL64ri_ROL8ri_ROR16r1_ROR32r1_ROR64r1_ROR8r1_ROR16ri_ROR32ri_ROR64ri_ROR8ri") 2, false, false, 1100, 4, 20, 1,  0, 0}, // #686
  {DBGFIELD("SETAr_SETBEr")       2, false, false, 220, 4, 20, 1,  0, 0}, // #687
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 3, false, false, 901, 4,  5, 1,  0, 0}, // #688
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 133, 7, 21, 1,  0, 0}, // #689
  {DBGFIELD("VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 1, false, false, 133, 7, 21, 1,  0, 0}, // #690
  {DBGFIELD("CWD")                2, false, false, 220, 4, 20, 1,  0, 0}, // #691
  {DBGFIELD("FNSTSW16r")          2, false, false, 1104, 9, 22, 1,  0, 0}, // #692
  {DBGFIELD("MMX_MOVDQ2Qrr")      2, false, false, 1113, 4, 20, 1,  0, 0}, // #693
  {DBGFIELD("PUSHFS64")           1, false, false, 79, 2,  4, 1,  0, 0}, // #694
  {DBGFIELD("IMUL16rri_IMUL16rri8") 2, false, false, 1117, 7, 22, 1,  0, 0}, // #695
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 2, false, false, 381, 12, 20, 1,  0, 0}, // #696
  {DBGFIELD("ROL16rCL_ROL32rCL_ROL64rCL_ROL8rCL_ROR16rCL_ROR32rCL_ROR64rCL_ROR8rCL_SAR16rCL_SAR32rCL_SAR64rCL_SAR8rCL_SHL16rCL_SHL32rCL_SHL64rCL_SHL8rCL_SHR16rCL_SHR32rCL_SHR64rCL_SHR8rCL") 3, false, false, 1124, 4, 21, 1,  0, 0}, // #697
  {DBGFIELD("XADD8rr_XADD16rr_XADD32rr_XADD64rr_XCHG8rr_XCHG16rr_XCHG32rr_XCHG64rr_XCHG16ar_XCHG32ar_XCHG64ar") 3, false, false, 338, 2, 20, 1,  0, 0}, // #698
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, 133, 7, 21, 1,  0, 0}, // #699
  {DBGFIELD("IMUL64r_MUL64r")     2, false, false, 719, 11, 22, 1,  0, 0}, // #700
  {DBGFIELD("IMUL16r_MUL16r")     4, false, false, 646, 9, 22, 1,  0, 0}, // #701
  {DBGFIELD("MOV64sr")            1, false, false, 79, 2,  1, 1,  0, 0}, // #702
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false, 237, 9,  7, 1,  0, 0}, // #703
  {DBGFIELD("MOVSX16rm16_MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVSX64rm16_MOVSX64rm32_MOVSX64rm8_MOVZX16rm16_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX_MOVZX64rm16_MOVZX64rm8") 1, false, false, 101, 3,  7, 1,  0, 0}, // #704
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 3, false, false, 1128, 5, 20, 1,  0, 0}, // #705
  {DBGFIELD("CLI")                1, false, false, 79, 2,  4, 1,  0, 0}, // #706
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 3, false, false, 709, 10, 22, 1,  0, 0}, // #707
  {DBGFIELD("PUSHGS64")           1, false, false, 79, 2,  4, 1,  0, 0}, // #708
  {DBGFIELD("CALL64pcrel32")      4, false, false, 1133, 7, 21, 1,  0, 0}, // #709
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 4, false, false, 1140, 10, 21, 1,  0, 0}, // #710
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 3, false, false, 370, 11, 20, 1,  0, 0}, // #711
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 3, false, false, 1128, 5, 20, 1,  0, 0}, // #712
  {DBGFIELD("SETAm_SETBEm")       4, false, false, 1133, 7, 21, 1,  0, 0}, // #713
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 3, false, false, 370, 11, 20, 1,  0, 0}, // #714
  {DBGFIELD("PUSHF16_PUSHF64")    6, false, false, 1150, 5,  7, 1,  0, 0}, // #715
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 2, false, false, 1155, 7, 20, 1,  0, 0}, // #716
  {DBGFIELD("MMX_MOVD64from64rm") 2, false, false, 97, 4,  1, 1,  0, 0}, // #717
  {DBGFIELD("VBROADCASTSSrm_MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 101, 3,  7, 1,  0, 0}, // #718
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, 101, 3,  7, 1,  0, 0}, // #719
  {DBGFIELD("MOVSDrm_VMOVSDrm_MOVSSrm_VMOVSSrm") 1, false, false, 101, 3,  7, 1,  0, 0}, // #720
  {DBGFIELD("MOV16sm")            1, false, false, 79, 2,  1, 1,  0, 0}, // #721
  {DBGFIELD("BT16mi8_BT32mi8_BT64mi8") 2, false, false, 87, 6,  6, 1,  0, 0}, // #722
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 2, false, false, 208, 6,  6, 1,  0, 0}, // #723
  {DBGFIELD("MMX_PALIGNRrmi")     2, false, false, 140, 10,  6, 1,  9, 1}, // #724
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 2, false, false, 208, 6,  6, 1,  9, 1}, // #725
  {DBGFIELD("LODSL_LODSQ")        1, false, false, 79, 2,  4, 1,  0, 0}, // #726
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false, 101, 3,  6, 1,  0, 0}, // #727
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 1, false, false, 101, 3,  6, 1,  0, 0}, // #728
  {DBGFIELD("VINSERTF128rm")      2, false, false, 128, 5,  6, 1,  0, 0}, // #729
  {DBGFIELD("MMX_PADDQirm")       2, false, false, 208, 6,  6, 1,  9, 1}, // #730
  {DBGFIELD("VERRm_VERWm")        1, false, false, 79, 2,  4, 1,  0, 0}, // #731
  {DBGFIELD("FARJMP64")           2, false, false, 1162, 9,  6, 1,  0, 0}, // #732
  {DBGFIELD("FNSTSWm")            3, false, false, 1171, 11, 22, 1,  0, 0}, // #733
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 4, false, false, 1182, 11,  6, 1,  0, 0}, // #734
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 5, false, false, 1193, 11,  5, 1,  0, 0}, // #735
  {DBGFIELD("CALL64m_CALL64m_NT") 5, false, false, 1193, 11,  5, 1,  0, 0}, // #736
  {DBGFIELD("SAR16m1_SAR32m1_SAR64m1_SAR8m1_SAR16mi_SAR32mi_SAR64mi_SAR8mi_SHL16m1_SHL32m1_SHL64m1_SHL8m1_SHL16mi_SHL32mi_SHL64mi_SHL8mi_SHR16m1_SHR32m1_SHR64m1_SHR8m1_SHR16mi_SHR32mi_SHR64mi_SHR8mi") 4, false, false, 602, 8,  6, 1,  0, 0}, // #737
  {DBGFIELD("VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 2, false, false, 124, 9, 10, 1,  9, 1}, // #738
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, 79, 2,  4, 1,  0, 0}, // #739
  {DBGFIELD("ROL16m1_ROL32m1_ROL64m1_ROL8m1_ROL16mi_ROL32mi_ROL64mi_ROL8mi_ROR16m1_ROR32m1_ROR64m1_ROR8m1_ROR16mi_ROR32mi_ROR64mi_ROR8mi") 5, false, false, 1204, 8,  5, 1,  0, 0}, // #740
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 5, false, false, 1212, 6,  5, 1,  0, 0}, // #741
  {DBGFIELD("FARCALL64")          5, false, false, 1193, 11,  5, 1,  0, 0}, // #742
  {DBGFIELD("CVTSD2SI64rm_Int_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int") 3, false, false, 1218, 14,  9, 1,  0, 0}, // #743
  {DBGFIELD("CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int") 3, false, false, 1218, 14,  9, 1,  0, 0}, // #744
  {DBGFIELD("IMUL64m_MUL64m")     3, false, false, 1232, 13,  9, 1,  0, 0}, // #745
  {DBGFIELD("IMUL32m_MUL32m")     4, false, false, 1245, 11,  9, 1,  0, 0}, // #746
  {DBGFIELD("IMUL16rmi_IMUL16rmi8") 3, false, false, 1256, 9, 10, 1,  0, 0}, // #747
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, 101, 3,  6, 1,  0, 0}, // #748
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL_SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 6, false, false, 112, 8, 10, 1,  0, 0}, // #749
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 6, false, false, 112, 8, 10, 1,  0, 0}, // #750
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 2, false, false, 124, 9,  9, 1,  0, 0}, // #751
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 2, false, false, 225, 11, 18, 1,  0, 0}, // #752
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 3, false, false, 610, 9, 18, 1,  0, 0}, // #753
  {DBGFIELD("MUL_F32m_MUL_F64m")  2, false, false, 225, 11, 26, 1,  0, 0}, // #754
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 3, false, false, 610, 9, 19, 1,  0, 0}, // #755
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 3, false, false, 1218, 14, 25, 1,  0, 0}, // #756
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 2, false, false, 225, 11, 31, 1,  0, 0}, // #757
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 3, false, false, 1218, 14, 72, 1,  0, 0}, // #758
  {DBGFIELD("CLC")                1, false, false,  0, 0,  1, 1,  0, 0}, // #759
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 2, false, false, 140, 10,  6, 1,  9, 1}, // #760
  {DBGFIELD("DIV8r")              1, false, false, 236, 10, 34, 1,  0, 0}, // #761
  {DBGFIELD("IDIV8r")             1, false, false, 236, 10, 34, 1,  0, 0}, // #762
  {DBGFIELD("RETIL_RETIQ_RETIW")  2, false, false, 87, 6,  6, 1,  0, 0}, // #763
  {DBGFIELD("LRETIL_LRETIQ_LRETIW") 2, false, false, 87, 6,  6, 1,  0, 0}, // #764
  {DBGFIELD("RDPMC")              1, false, false, 79, 2,  4, 1,  0, 0}, // #765
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 5, false, false, 1265, 6,  9, 1,  0, 0}, // #766
  {DBGFIELD("FBLDm")              1, false, false, 79, 2,  4, 1,  0, 0}, // #767
  {DBGFIELD("FFREE_FFREEP")       1, false, false, 79, 2,  4, 1,  0, 0}, // #768
  {DBGFIELD("FSAVEm")             1, false, false, 79, 2,  4, 1,  0, 0}, // #769
  {DBGFIELD("FRSTORm")            1, false, false, 79, 2,  4, 1,  0, 0}, // #770
  {DBGFIELD("FXTRACT")            1, false, false, 79, 2,  4, 1,  0, 0}, // #771
  {DBGFIELD("VBROADCASTSSrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 101, 3,  7, 1,  0, 0}, // #772
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, 101, 3,  7, 1,  0, 0}, // #773
  {DBGFIELD("VBROADCASTF128")     1, false, false, 101, 3,  6, 1,  0, 0}, // #774
  {DBGFIELD("VBROADCASTI128")     1, false, false, 101, 3,  6, 1,  0, 0}, // #775
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, 101, 3,  6, 1,  0, 0}, // #776
  {DBGFIELD("FBSTPm")             2, false, false, 97, 4,  1, 1,  0, 0}, // #777
  {DBGFIELD("ST_FP32m_ST_FP64m")  2, false, false, 97, 4,  1, 1,  0, 0}, // #778
  {DBGFIELD("VMPTRSTm")           1, false, false, 79, 2,  4, 1,  0, 0}, // #779
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 1, false, false, 237, 9,  1, 1,  0, 0}, // #780
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 1, false, false, 237, 9,  1, 1,  0, 0}, // #781
  {DBGFIELD("MMX_MOVQ2DQrr")      1, false, false, 104, 8,  1, 1,  0, 0}, // #782
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT") 1, false, false, 1271, 7,  1, 1,  0, 0}, // #783
  {DBGFIELD("FINCSTP")            1, false, false, 437, 4,  1, 1,  0, 0}, // #784
  {DBGFIELD("ANDN32rr_ANDN64rr_BLSI32rr_BLSI64rr_BLSMSK32rr_BLSMSK64rr_BLSR32rr_BLSR64rr") 1, false, false, 77, 4,  1, 1,  0, 0}, // #785
  {DBGFIELD("VPBLENDDYrri")       1, false, false, 78, 3,  1, 1,  0, 0}, // #786
  {DBGFIELD("VPBLENDDrri")        1, false, false, 78, 3,  1, 1,  0, 0}, // #787
  {DBGFIELD("CMC_STC")            1, false, false, 79, 2,  1, 1,  0, 0}, // #788
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false, 79, 2,  1, 1,  0, 0}, // #789
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 2, false, false, 225, 11,  6, 1,  0, 0}, // #790
  {DBGFIELD("CVTSS2SDrm")         2, false, false, 225, 11,  6, 1,  0, 0}, // #791
  {DBGFIELD("CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 2, false, false, 225, 11,  6, 1,  0, 0}, // #792
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 2, false, false, 225, 11,  6, 1,  0, 0}, // #793
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 2, false, false, 225, 11,  5, 1,  0, 0}, // #794
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 2, false, false, 124, 9, 10, 1,  0, 0}, // #795
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 2, false, false, 140, 10,  6, 1,  0, 0}, // #796
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 2, false, false, 140, 10, 10, 1,  0, 0}, // #797
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT") 2, false, false, 1162, 9,  6, 1,  0, 0}, // #798
  {DBGFIELD("ANDN32rm_ANDN64rm")  2, false, false, 208, 6,  6, 1,  0, 0}, // #799
  {DBGFIELD("BLSI32rm_BLSI64rm_BLSMSK32rm_BLSMSK64rm_BLSR32rm_BLSR64rm_MOVBE16rm_MOVBE32rm_MOVBE64rm") 2, false, false, 208, 6,  6, 1,  0, 0}, // #800
  {DBGFIELD("VINSERTI128rm")      2, false, false, 128, 5,  6, 1,  0, 0}, // #801
  {DBGFIELD("VPBLENDDrmi")        2, false, false, 128, 5,  6, 1,  0, 0}, // #802
  {DBGFIELD("VPBLENDDYrmi")       2, false, false, 128, 5,  5, 1,  0, 0}, // #803
  {DBGFIELD("POP32r_POP64r")      2, false, false, 120, 4,  6, 1,  0, 0}, // #804
  {DBGFIELD("SFENCE")             2, false, false, 90, 3, 20, 1,  0, 0}, // #805
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 3, false, false, 1278, 7, 20, 1,  0, 0}, // #806
  {DBGFIELD("MOVBE16mr")          3, false, false, 1278, 7, 20, 1,  0, 0}, // #807
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r") 3, false, false, 1128, 5, 20, 1,  0, 0}, // #808
  {DBGFIELD("MFENCE")             2, false, false, 166, 2, 20, 1,  0, 0}, // #809
  {DBGFIELD("XGETBV")             2, false, false, 166, 2, 20, 1,  0, 0}, // #810
  {DBGFIELD("CVTPS2PDrr_VCVTPS2PDrr") 2, false, false, 381, 12, 20, 1,  0, 0}, // #811
  {DBGFIELD("CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 2, false, false, 381, 12, 20, 1,  0, 0}, // #812
  {DBGFIELD("MMX_PACKSSDWirm_MMX_PACKSSWBirm_MMX_PACKUSWBirm") 3, false, false, 150, 10,  5, 1,  0, 0}, // #813
  {DBGFIELD("LRETQ_RETL")         2, false, false, 87, 6,  6, 1,  0, 0}, // #814
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, 133, 7, 21, 1,  0, 0}, // #815
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, 133, 7, 21, 1,  0, 0}, // #816
  {DBGFIELD("VCVTDQ2PSYrr")       1, false, false, 133, 7, 21, 1,  0, 0}, // #817
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, 104, 8, 21, 1,  0, 0}, // #818
  {DBGFIELD("CVTPS2DQrm_VCVTPS2DQrm_CVTTPS2DQrm_VCVTTPS2DQrm") 2, false, false, 124, 9, 10, 1,  0, 0}, // #819
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, 124, 9,  9, 1,  0, 0}, // #820
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm") 2, false, false, 124, 9,  9, 1,  0, 0}, // #821
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 2, false, false, 140, 10, 10, 1,  0, 0}, // #822
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr") 3, false, false, 1285, 8, 21, 1,  0, 0}, // #823
  {DBGFIELD("CLDEMOTE")           3, false, false, 905, 7, 21, 1,  0, 0}, // #824
  {DBGFIELD("RCL16r1_RCL32r1_RCL64r1_RCL8r1_RCL16ri_RCL32ri_RCL64ri_RCL8ri_RCR16r1_RCR32r1_RCR64r1_RCR8r1_RCR16ri_RCR32ri_RCR64ri_RCR8ri") 3, false, false, 1293, 4, 21, 1,  0, 0}, // #825
  {DBGFIELD("RCL16m1_RCL32m1_RCL64m1_RCL8m1_RCL16mi_RCL32mi_RCL64mi_RCL8mi_RCR16m1_RCR32m1_RCR64m1_RCR8m1_RCR16mi_RCR32mi_RCR64mi_RCR8mi") 5, false, false, 1297, 6, 10, 1,  0, 0}, // #826
  {DBGFIELD("ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 5, false, false, 1303, 6, 10, 1,  0, 0}, // #827
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_CVTTSD2SI64rr_Int_CVTTSD2SIrr_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, 947, 12, 22, 1,  0, 0}, // #828
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int_CVTSS2SIrr_Int_CVTTSS2SIrr_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_VCVTTSS2SIrr_Int") 2, false, false, 947, 12, 22, 1,  0, 0}, // #829
  {DBGFIELD("VCVTPS2PDYrr")       2, false, false, 381, 12, 22, 1,  0, 0}, // #830
  {DBGFIELD("MMX_CVTPI2PDirr_CVTDQ2PDrr_VCVTDQ2PDrr") 2, false, false, 719, 11, 22, 1,  0, 0}, // #831
  {DBGFIELD("MMX_CVTPD2PIirr_MMX_CVTTPD2PIirr_CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, 719, 11, 22, 1,  0, 0}, // #832
  {DBGFIELD("CVTPD2PSrr_VCVTPD2PSrr") 2, false, false, 719, 11, 22, 1,  0, 0}, // #833
  {DBGFIELD("CVTSD2SSrr_CVTSD2SSrr_Int_VCVTSD2SSrr_VCVTSD2SSrr_Int") 2, false, false, 719, 11, 22, 1,  0, 0}, // #834
  {DBGFIELD("CVTSI2SDrr_CVTSI2SDrr_Int_CVTSI642SDrr_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, 719, 11, 22, 1,  0, 0}, // #835
  {DBGFIELD("CVTSI2SSrr_CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int") 2, false, false, 719, 11, 22, 1,  0, 0}, // #836
  {DBGFIELD("MULX64rr")           2, false, false, 719, 11, 22, 1,  0, 0}, // #837
  {DBGFIELD("VCVTSD2SI64rm_Int_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 3, false, false, 1218, 14,  9, 1,  0, 0}, // #838
  {DBGFIELD("CVTSS2SI64rm_Int")   3, false, false, 1218, 14,  9, 1,  0, 0}, // #839
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, 1218, 14,  9, 1,  0, 0}, // #840
  {DBGFIELD("VCVTPS2PDYrm")       3, false, false, 588, 14,  9, 1,  0, 0}, // #841
  {DBGFIELD("CVTPD2PSrm")         3, false, false, 1232, 13,  9, 1,  0, 0}, // #842
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_MMX_CVTPD2PIirm_MMX_CVTTPD2PIirm") 3, false, false, 1232, 13,  9, 1,  0, 0}, // #843
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 3, false, false, 1232, 13,  9, 1,  0, 0}, // #844
  {DBGFIELD("MMX_CVTPI2PDirm")    3, false, false, 1232, 13,  9, 1,  0, 0}, // #845
  {DBGFIELD("CVTSD2SSrm")         3, false, false, 1232, 13,  9, 1,  0, 0}, // #846
  {DBGFIELD("CVTSD2SSrm_Int_VCVTSD2SSrm_VCVTSD2SSrm_Int") 3, false, false, 1232, 13,  9, 1,  0, 0}, // #847
  {DBGFIELD("MULX64rm")           3, false, false, 1232, 13,  9, 1,  0, 0}, // #848
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 3, false, false, 1309, 10,  9, 1,  0, 0}, // #849
  {DBGFIELD("VZEROUPPER")         4, false, false, 1319, 3, 22, 1,  0, 0}, // #850
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 8, false, false, 1322, 13, 25, 1,  0, 0}, // #851
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 5, false, false, 1335, 13,  9, 1,  0, 0}, // #852
  {DBGFIELD("VPCMPGTQYrr")        1, false, false, 237, 9,  7, 1,  0, 0}, // #853
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, 237, 9,  7, 1,  0, 0}, // #854
  {DBGFIELD("VPCMPGTQYrm")        2, false, false, 225, 11, 26, 1,  0, 0}, // #855
  {DBGFIELD("CVTSI642SSrr_CVTSI642SSrr_Int_VCVTSI642SSrr_VCVTSI642SSrr_Int") 3, false, false, 415, 11,  7, 1,  0, 0}, // #856
  {DBGFIELD("STR16r_STR32r_STR64r") 3, false, false, 1348, 11,  7, 1,  0, 0}, // #857
  {DBGFIELD("MULX32rr")           3, false, false, 867, 9, 22, 1,  0, 0}, // #858
  {DBGFIELD("MULX32rm")           4, false, false, 1245, 11,  9, 1,  0, 0}, // #859
  {DBGFIELD("XSETBV")             5, false, false, 1359, 4,  7, 1,  0, 0}, // #860
  {DBGFIELD("VCVTDQ2PDYrr")       2, false, false, 719, 11,  6, 1,  0, 0}, // #861
  {DBGFIELD("VCVTPD2PSYrr")       2, false, false, 719, 11,  6, 1,  0, 0}, // #862
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 2, false, false, 719, 11,  6, 1,  0, 0}, // #863
  {DBGFIELD("VCVTDQ2PDYrm")       3, false, false, 1232, 13, 26, 1,  0, 0}, // #864
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 10, false, false, 1363, 11, 24, 1,  0, 0}, // #865
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 7, false, false, 1374, 9, 26, 1,  0, 0}, // #866
  {DBGFIELD("RCL8rCL")            9, false, false, 1383, 9, 26, 1,  0, 0}, // #867
  {DBGFIELD("RCR8rCL")            10, false, false, 1392, 9, 25, 1,  0, 0}, // #868
  {DBGFIELD("VZEROALL")           16, false, false, 1401, 8,  8, 1,  0, 0}, // #869
  {DBGFIELD("RDTSC")              8, false, false, 1065, 11, 29, 1,  0, 0}, // #870
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 19, false, false, 1409, 9, 33, 1,  0, 0}, // #871
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, 237, 9, 30, 1,  0, 0}, // #872
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 2, false, false, 225, 11, 35, 1,  0, 0}, // #873
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 3, false, false, 1218, 14, 36, 1,  0, 0}, // #874
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, 237, 9, 24, 1,  0, 0}, // #875
  {DBGFIELD("XSAVE64")            27, false, false, 1418, 11, 36, 1,  0, 0}, // #876
  {DBGFIELD("XSAVE")              28, false, false, 1429, 11, 37, 1,  0, 0}, // #877
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 28, false, false, 1429, 11, 37, 1,  0, 0}, // #878
  {DBGFIELD("VMCLEARm")           1, false, false, 79, 2,  4, 1,  0, 0}, // #879
  {DBGFIELD("FLDENVm")            64, false, false, 1440, 11, 77, 1,  0, 0}, // #880
  {DBGFIELD("FXRSTOR64")          88, false, false, 1451, 15, 44, 1,  0, 0}, // #881
  {DBGFIELD("DIV16r")             32, false, false, 1466, 15, 78, 1,  0, 0}, // #882
  {DBGFIELD("DIV32r")             32, false, false, 1466, 15, 78, 1,  0, 0}, // #883
  {DBGFIELD("DIV64r")             32, false, false, 1466, 15, 78, 1,  0, 0}, // #884
  {DBGFIELD("IDIV16r")            1, false, false, 236, 10, 34, 1,  0, 0}, // #885
  {DBGFIELD("IDIV32r")            1, false, false, 236, 10, 34, 1,  0, 0}, // #886
  {DBGFIELD("IDIV64r")            1, false, false, 236, 10, 34, 1,  0, 0}, // #887
  {DBGFIELD("FSTENVm")            100, false, false, 1481, 17, 79, 1,  0, 0}, // #888
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm_VPGATHERDDrm") 1, false, false, 101, 3,  7, 1,  0, 0}, // #889
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 1, false, false, 101, 3,  7, 1,  0, 0}, // #890
  {DBGFIELD("VPGATHERQDYrm")      1, false, false, 101, 3,  7, 1,  0, 0}, // #891
  {DBGFIELD("VPGATHERQDrm")       1, false, false, 101, 3,  7, 1,  0, 0}, // #892
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 1, false, false, 101, 3,  7, 1,  0, 0}, // #893
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 1, false, false, 101, 3,  7, 1,  0, 0}, // #894
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 1, false, false, 101, 3,  7, 1,  0, 0}, // #895
  {DBGFIELD("VGATHERQPSYrm")      9, false, false, 1498, 12, 72, 1,  0, 0}, // #896
  {DBGFIELD("VGATHERQPSrm_VGATHERDPSrm") 9, false, false, 1498, 12, 74, 1,  0, 0}, // #897
  {DBGFIELD("ADC8i8_ADC8ri_ADC8ri8_SBB8i8_SBB8ri_SBB8ri8") 2, false, false, 220, 4, 20, 1,  0, 0}, // #898
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 2, false, false, 124, 9,  5, 1,  0, 0}, // #899
  {DBGFIELD("LRETQ")              3, false, false, 1091, 9,  5, 1,  0, 0}, // #900
  {DBGFIELD("CVTDQ2PSrm_VCVTDQ2PSrm") 2, false, false, 124, 9, 10, 1,  0, 0}, // #901
  {DBGFIELD("POPF64")             18, false, false, 1510, 9, 32, 1,  0, 0}, // #902
  {DBGFIELD("VGATHERQPDrm")       7, false, false, 1519, 12, 32, 1,  0, 0}, // #903
  {DBGFIELD("VGATHERQPDYrm")      9, false, false, 1531, 12, 33, 1,  0, 0}, // #904
  {DBGFIELD("VGATHERDPDrm")       7, false, false, 1519, 12, 34, 1,  0, 0}, // #905
  {DBGFIELD("VGATHERDPSrm")       7, false, false, 1519, 12, 34, 1,  0, 0}, // #906
  {DBGFIELD("VGATHERDPDYrm")      9, false, false, 1498, 12, 35, 1,  0, 0}, // #907
  {DBGFIELD("VGATHERDPSYrm")      14, false, false, 1543, 12, 35, 1,  0, 0}, // #908
  {DBGFIELD("DIV16m")             8, false, false, 1555, 16, 16, 1,  0, 0}, // #909
  {DBGFIELD("DIV32m")             8, false, false, 1555, 16, 16, 1,  0, 0}, // #910
  {DBGFIELD("DIV64m")             8, false, false, 1555, 16, 16, 1,  0, 0}, // #911
  {DBGFIELD("DIV8m")              8, false, false, 1555, 16, 16, 1,  0, 0}, // #912
  {DBGFIELD("IDIV16m")            8, false, false, 1555, 16, 73, 1,  0, 0}, // #913
  {DBGFIELD("IDIV32m")            8, false, false, 1555, 16, 73, 1,  0, 0}, // #914
  {DBGFIELD("IDIV64m")            8, false, false, 1555, 16, 73, 1,  0, 0}, // #915
  {DBGFIELD("IDIV8m")             8, false, false, 1555, 16, 73, 1,  0, 0}, // #916
  {DBGFIELD("MOV16rm")            1, false, false, 101, 3,  7, 1,  0, 0}, // #917
  {DBGFIELD("MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX") 1, false, false, 101, 3,  7, 1,  0, 0}, // #918
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 3, false, false, 338, 2, 20, 1,  0, 0}, // #919
  {DBGFIELD("POP16rmm")           4, false, false, 81, 6,  6, 1,  0, 0}, // #920
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 4, false, false, 81, 6,  6, 1,  0, 0}, // #921
  {DBGFIELD("PUSHF16")            6, false, false, 1150, 5,  7, 1,  0, 0}, // #922
  {DBGFIELD("LAHF")               1, false, false, 93, 4,  1, 1,  0, 0}, // #923
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 2, false, false, 208, 6,  6, 1,  0, 0}, // #924
  {DBGFIELD("ADD16mi_ADD16mi8_ADD16mr_ADD32mi_ADD32mi8_ADD32mr_ADD64mi32_ADD64mi8_ADD64mr_ADD8mi_ADD8mi8_ADD8mr_SUB16mi_SUB16mi8_SUB16mr_SUB32mi_SUB32mi8_SUB32mr_SUB64mi32_SUB64mi8_SUB64mr_SUB8mi_SUB8mi8_SUB8mr") 3, false, false, 81, 6,  5, 1,  0, 0}, // #925
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 6, false, false, 112, 8, 10, 1,  0, 0}, // #926
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 3, false, false, 81, 6,  5, 1,  0, 0}, // #927
  {DBGFIELD("IMUL16rm")           2, false, false, 124, 9, 10, 1,  9, 1}, // #928
  {DBGFIELD("IMUL64rr")           1, false, false, 133, 7, 21, 1,  0, 0}, // #929
  {DBGFIELD("IMUL64rm")           2, false, false, 124, 9, 10, 1,  9, 1}, // #930
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 4, false, false, 1140, 10, 21, 1,  0, 0}, // #931
  {DBGFIELD("RETW_LRETL_LRETW")   2, false, false, 87, 6,  6, 1,  0, 0}, // #932
  {DBGFIELD("IRET16_IRET32_IRET64") 2, false, false, 87, 6,  6, 1,  0, 0}, // #933
  {DBGFIELD("AND16mi_AND16mi8_AND16mr_AND32mi_AND32mi8_AND32mr_AND64mi32_AND64mi8_AND64mr_AND8mi_AND8mi8_AND8mr_OR16mi_OR16mi8_OR16mr_OR32mi_OR32mi8_OR32mr_OR64mi32_OR64mi8_OR64mr_OR8mi_OR8mi8_OR8mr_XOR16mi_XOR16mi8_XOR16mr_XOR32mi_XOR32mi8_XOR32mr_XOR64mi32_XOR64mi8_XOR64mr_XOR8mi_XOR8mi8_XOR8mr") 3, false, false, 81, 6,  5, 1,  0, 0}, // #934
  {DBGFIELD("OR32mrLocked")       3, false, false, 81, 6, 63, 2,  0, 0}, // #935
  {DBGFIELD("BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 1, false, false, 93, 4,  1, 1,  0, 0}, // #936
  {DBGFIELD("BLSI32rr_BLSI64rr_BLSMSK32rr_BLSMSK64rr_BLSR32rr_BLSR64rr") 1, false, false, 77, 4,  1, 1,  0, 0}, // #937
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 4, false, false, 637, 9,  9, 1,  0, 0}, // #938
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 4, false, false, 646, 9,  6, 1,  0, 0}, // #939
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 6, false, false, 626, 11, 26, 1,  0, 0}, // #940
  {DBGFIELD("MOVSLDUPrm")         1, false, false, 101, 3,  7, 1,  0, 0}, // #941
  {DBGFIELD("MOVSLDUPrr")         1, false, false, 104, 8,  1, 1,  0, 0}, // #942
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, 104, 8,  1, 1,  0, 0}, // #943
  {DBGFIELD("VPMOVSXBDYrr_VPMOVSXBQYrr_VPMOVSXBWYrr_VPMOVSXDQYrr_VPMOVSXWDYrr_VPMOVSXWQYrr_VPMOVZXBDYrr_VPMOVZXBQYrr_VPMOVZXBWYrr_VPMOVZXDQYrr_VPMOVZXWDYrr_VPMOVZXWQYrr") 1, false, false, 104, 8, 21, 1,  0, 0}, // #944
  {DBGFIELD("VPMOVZXBDYrm_VPMOVZXBQYrm_VPMOVZXBWYrm_VPMOVZXDQYrm_VPMOVZXWQYrm") 2, false, false, 140, 10,  9, 1,  0, 0}, // #945
  {DBGFIELD("PBLENDWrri_VPBLENDWrri") 1, false, false, 104, 8,  1, 1,  0, 0}, // #946
  {DBGFIELD("VPBLENDWYrri")       1, false, false, 104, 8,  1, 1,  0, 0}, // #947
  {DBGFIELD("PBLENDWrmi_VPBLENDWrmi") 2, false, false, 140, 10,  6, 1,  9, 1}, // #948
  {DBGFIELD("VPBLENDWYrmi")       2, false, false, 140, 10,  5, 1,  9, 1}, // #949
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, 104, 8,  1, 1,  0, 0}, // #950
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 2, false, false, 97, 4,  1, 1,  0, 0}, // #951
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 2, false, false, 97, 4,  1, 1,  0, 0}, // #952
  {DBGFIELD("VPMASKMOVDYrm")      3, false, false, 150, 10, 10, 1,  0, 0}, // #953
  {DBGFIELD("VPMASKMOVDrm")       3, false, false, 150, 10,  5, 1,  0, 0}, // #954
  {DBGFIELD("VPMASKMOVDYmr_VPMASKMOVQYmr") 4, false, false, 774, 12,  7, 1,  0, 0}, // #955
  {DBGFIELD("VPMASKMOVDmr_VPMASKMOVQmr") 4, false, false, 774, 12,  7, 1,  0, 0}, // #956
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 3, false, false, 1309, 10,  9, 1,  0, 0}, // #957
  {DBGFIELD("VPSLLDQri_VPSRLDQri") 1, false, false, 104, 8,  1, 1,  0, 0}, // #958
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri") 1, false, false, 104, 8,  1, 1,  0, 0}, // #959
  {DBGFIELD("VPERM2F128rr")       1, false, false, 104, 8, 21, 1,  0, 0}, // #960
  {DBGFIELD("VPERM2F128rm")       2, false, false, 140, 10,  9, 1,  9, 1}, // #961
  {DBGFIELD("VEXTRACTF128rr")     1, false, false, 104, 8, 21, 1,  0, 0}, // #962
  {DBGFIELD("VEXTRACTF128mr")     2, false, false, 97, 4,  1, 1,  0, 0}, // #963
  {DBGFIELD("VINSERTF128rr")      1, false, false, 104, 8, 21, 1,  0, 0}, // #964
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 2, false, false, 719, 11, 22, 1,  0, 0}, // #965
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, 719, 11, 22, 1,  0, 0}, // #966
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 3, false, false, 1232, 13,  9, 1,  0, 0}, // #967
  {DBGFIELD("VCVTPD2DQrm_VCVTTPD2DQrm") 2, false, false, 124, 9, 10, 1,  0, 0}, // #968
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 2, false, false, 124, 9, 10, 1,  0, 0}, // #969
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_VCVTTSS2SIrr_Int") 2, false, false, 947, 12, 22, 1,  0, 0}, // #970
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, 1218, 14,  9, 1,  0, 0}, // #971
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, 77, 4,  1, 1,  0, 0}, // #972
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, 77, 4,  1, 1,  0, 0}, // #973
  {DBGFIELD("SHA256MSG2rm")       2, false, false, 225, 11, 18, 1,  9, 1}, // #974
  {DBGFIELD("SHA256MSG2rr")       1, false, false, 237, 9,  7, 1,  0, 0}, // #975
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, 237, 9,  7, 1,  0, 0}, // #976
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 2, false, false, 225, 11, 18, 1,  9, 1}, // #977
  {DBGFIELD("SHA1MSG2rr")         1, false, false, 237, 9,  7, 1,  0, 0}, // #978
  {DBGFIELD("SHA1MSG2rm")         2, false, false, 225, 11, 18, 1,  9, 1}, // #979
  {DBGFIELD("SHA1NEXTErr")        1, false, false, 237, 9,  7, 1,  0, 0}, // #980
  {DBGFIELD("SHA1NEXTErm")        2, false, false, 225, 11, 18, 1,  9, 1}, // #981
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, 237, 9,  7, 1,  0, 0}, // #982
  {DBGFIELD("SHA1RNDS4rmi")       2, false, false, 225, 11, 18, 1,  9, 1}, // #983
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, 237, 9,  7, 1,  0, 0}, // #984
  {DBGFIELD("SHA256RNDS2rm")      2, false, false, 225, 11, 18, 1,  9, 1}, // #985
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 1, false, false, 79, 2,  1, 1,  0, 0}, // #986
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr_ANDNPSrr_VANDNPSrr_ANDNPDrr_VANDNPDrr") 1, false, false, 104, 8,  1, 1,  0, 0}, // #987
  {DBGFIELD("MMX_PXORirr_MMX_PANDNirr") 1, false, false, 78, 3,  1, 1,  0, 0}, // #988
  {DBGFIELD("PXORrr_VPXORrr_PANDNrr_VPANDNrr") 1, false, false, 78, 3,  1, 1,  0, 0}, // #989
  {DBGFIELD("MMX_PSUBBirr_MMX_PSUBDirr_MMX_PSUBWirr_MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 1, false, false, 77, 4,  1, 1,  0, 0}, // #990
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 1, false, false, 77, 4,  1, 1,  0, 0}, // #991
  {DBGFIELD("PSUBQrr")            1, false, false, 77, 4,  1, 1,  0, 0}, // #992
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false, 77, 4,  1, 1,  0, 0}, // #993
  {DBGFIELD("LEA16r")             1, false, false, 77, 4,  1, 1,  0, 0}, // #994
  {DBGFIELD("MMX_PADDSBirr_MMX_PADDSWirr_MMX_PADDUSBirr_MMX_PADDUSWirr_MMX_PAVGBirr_MMX_PAVGWirr_MMX_PCMPEQBirr_MMX_PCMPEQDirr_MMX_PCMPEQWirr_MMX_PMAXSWirr_MMX_PMINSWirr_MMX_PMAXUBirr_MMX_PMINUBirr_MMX_PSUBSBirr_MMX_PSUBSWirr_MMX_PSUBUSBirr_MMX_PSUBUSWirr") 1, false, false, 77, 4,  1, 1,  0, 0}, // #995
  {DBGFIELD("MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 1, false, false, 77, 4,  1, 1,  0, 0}, // #996
  {DBGFIELD("CLAC_STAC")          1, false, false, 79, 2,  4, 1,  0, 0}, // #997
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, 77, 4,  1, 1,  0, 0}, // #998
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr_VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr") 1, false, false, 77, 4,  1, 1,  0, 0}, // #999
  {DBGFIELD("PSUBBrr_PSUBDrr_PSUBWrr_VPSUBBrr_VPSUBDrr_VPSUBQrr_VPSUBWrr") 1, false, false, 77, 4,  1, 1,  0, 0}, // #1000
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, 133, 7, 21, 1,  0, 0}, // #1001
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 3, false, false, 456, 8, 21, 1,  0, 0}, // #1002
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, 456, 8, 21, 1,  0, 0}, // #1003
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 3, false, false, 456, 8, 21, 1,  0, 0}, // #1004
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, 133, 7, 21, 1,  0, 0}, // #1005
  {DBGFIELD("VCVTPS2DQYrr_VCVTTPS2DQYrr") 1, false, false, 133, 7, 21, 1,  0, 0}, // #1006
  {DBGFIELD("MMX_PADDSBirm_MMX_PADDSWirm_MMX_PADDUSBirm_MMX_PADDUSWirm_MMX_PAVGBirm_MMX_PAVGWirm_MMX_PCMPEQBirm_MMX_PCMPEQDirm_MMX_PCMPEQWirm_MMX_PCMPGTBirm_MMX_PCMPGTDirm_MMX_PCMPGTWirm_MMX_PMAXSWirm_MMX_PMAXUBirm_MMX_PMINSWirm_MMX_PMINUBirm_MMX_PSUBSBirm_MMX_PSUBSWirm_MMX_PSUBUSBirm_MMX_PSUBUSWirm") 2, false, false, 208, 6,  6, 1,  9, 1}, // #1007
  {DBGFIELD("CVTSS2SI64rr_Int")   2, false, false, 947, 12, 22, 1,  0, 0}, // #1008
  {DBGFIELD("CVTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int") 2, false, false, 947, 12, 22, 1,  0, 0}, // #1009
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 2, false, false, 208, 6,  6, 1,  9, 1}, // #1010
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 2, false, false, 208, 6,  5, 1,  9, 1}, // #1011
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 4, false, false, 446, 10, 10, 1,  9, 1}, // #1012
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, 446, 10, 10, 1,  9, 1}, // #1013
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 4, false, false, 446, 10,  9, 1,  9, 1}, // #1014
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 28, false, false, 1429, 11, 37, 1,  0, 0}, // #1015
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, 78, 3,  1, 1,  0, 0}, // #1016
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, 79, 2,  1, 1,  0, 0}, // #1017
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, 79, 2,  1, 1,  0, 0}, // #1018
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 2, false, false, 160, 8, 20, 1,  0, 0}, // #1019
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 2, false, false, 160, 8, 20, 1,  0, 0}, // #1020
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rr_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rr_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rr_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rr_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, 77, 4,  1, 1,  0, 0}, // #1021
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rr_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rr_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rr_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rr_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 1, false, false, 77, 4,  1, 1,  0, 0}, // #1022
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrr_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrr_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrr_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrr_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1023
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 2, false, false, 160, 8, 20, 1,  0, 0}, // #1024
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 2, false, false, 160, 8, 20, 1,  0, 0}, // #1025
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false, 97, 4,  1, 1,  0, 0}, // #1026
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 2, false, false, 97, 4,  1, 1,  0, 0}, // #1027
  {DBGFIELD("KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, 79, 2,  1, 1,  0, 0}, // #1028
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, 78, 3,  1, 1,  0, 0}, // #1029
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_VPTESTMBZ128rr_VPTESTMBZ128rrk_VPTESTMDZ128rr_VPTESTMDZ128rrk_VPTESTMQZ128rr_VPTESTMQZ128rrk_VPTESTMWZ128rr_VPTESTMWZ128rrk_VPTESTNMBZ128rr_VPTESTNMBZ128rrk_VPTESTNMDZ128rr_VPTESTNMDZ128rrk_VPTESTNMQZ128rr_VPTESTNMQZ128rrk_VPTESTNMWZ128rr_VPTESTNMWZ128rrk") 1, false, false, 78, 3,  1, 1,  0, 0}, // #1030
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri_KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, 104, 8,  1, 1,  0, 0}, // #1031
  {DBGFIELD("VALIGNDZ128rri_VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rri_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, 104, 8,  1, 1,  0, 0}, // #1032
  {DBGFIELD("VALIGNDZ256rri_VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rri_VALIGNQZ256rrik_VALIGNQZ256rrikz") 1, false, false, 104, 8,  1, 1,  0, 0}, // #1033
  {DBGFIELD("VALIGNDZrri_VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrri_VALIGNQZrrik_VALIGNQZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1034
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rri_alt_VCMPPDZ128rri_altk_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rri_alt_VCMPPSZ128rri_altk_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, 133, 7, 21, 1,  0, 0}, // #1035
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rri_alt_VCMPPDZ256rri_altk_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rri_alt_VCMPPSZ256rri_altk_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 1, false, false, 133, 7, 21, 1,  0, 0}, // #1036
  {DBGFIELD("VCMPPDZrri_VCMPPDZrri_alt_VCMPPDZrri_altk_VCMPPDZrrib_VCMPPDZrrib_alt_VCMPPDZrrib_altk_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrri_alt_VCMPPSZrri_altk_VCMPPSZrrib_VCMPPSZrrib_alt_VCMPPSZrrib_altk_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1037
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSDZrrb_alt_VCMPSDZrrb_altk_VCMPSDZrri_alt_VCMPSDZrri_altk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VCMPSSZrrb_alt_VCMPSSZrrb_altk_VCMPSSZrri_alt_VCMPSSZrri_altk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, 133, 7, 21, 1,  0, 0}, // #1038
  {DBGFIELD("VDBPSADBWZrri_VDBPSADBWZrrik_VDBPSADBWZrrikz_VPSADBWZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1039
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rri_alt_VPCMPBZ128rrik_VPCMPBZ128rrik_alt_VPCMPDZ128rri_VPCMPDZ128rri_alt_VPCMPDZ128rrik_VPCMPDZ128rrik_alt_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rri_alt_VPCMPQZ128rrik_VPCMPQZ128rrik_alt_VPCMPUBZ128rri_VPCMPUBZ128rri_alt_VPCMPUBZ128rrik_VPCMPUBZ128rrik_alt_VPCMPUDZ128rri_VPCMPUDZ128rri_alt_VPCMPUDZ128rrik_VPCMPUDZ128rrik_alt_VPCMPUQZ128rri_VPCMPUQZ128rri_alt_VPCMPUQZ128rrik_VPCMPUQZ128rrik_alt_VPCMPUWZ128rri_VPCMPUWZ128rri_alt_VPCMPUWZ128rrik_VPCMPUWZ128rrik_alt_VPCMPWZ128rri_VPCMPWZ128rri_alt_VPCMPWZ128rrik_VPCMPWZ128rrik_alt_VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, 77, 4,  1, 1,  0, 0}, // #1040
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rri_alt_VPCMPBZ256rrik_VPCMPBZ256rrik_alt_VPCMPDZ256rri_VPCMPDZ256rri_alt_VPCMPDZ256rrik_VPCMPDZ256rrik_alt_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rri_alt_VPCMPQZ256rrik_VPCMPQZ256rrik_alt_VPCMPUBZ256rri_VPCMPUBZ256rri_alt_VPCMPUBZ256rrik_VPCMPUBZ256rrik_alt_VPCMPUDZ256rri_VPCMPUDZ256rri_alt_VPCMPUDZ256rrik_VPCMPUDZ256rrik_alt_VPCMPUQZ256rri_VPCMPUQZ256rri_alt_VPCMPUQZ256rrik_VPCMPUQZ256rrik_alt_VPCMPUWZ256rri_VPCMPUWZ256rri_alt_VPCMPUWZ256rrik_VPCMPUWZ256rrik_alt_VPCMPWZ256rri_VPCMPWZ256rri_alt_VPCMPWZ256rrik_VPCMPWZ256rrik_alt_VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 1, false, false, 77, 4,  1, 1,  0, 0}, // #1041
  {DBGFIELD("VPCMPBZrri_VPCMPBZrri_alt_VPCMPBZrrik_VPCMPBZrrik_alt_VPCMPDZrri_VPCMPDZrri_alt_VPCMPDZrrik_VPCMPDZrrik_alt_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrri_alt_VPCMPQZrrik_VPCMPQZrrik_alt_VPCMPUBZrri_VPCMPUBZrri_alt_VPCMPUBZrrik_VPCMPUBZrrik_alt_VPCMPUDZrri_VPCMPUDZrri_alt_VPCMPUDZrrik_VPCMPUDZrrik_alt_VPCMPUQZrri_VPCMPUQZrri_alt_VPCMPUQZrrik_VPCMPUQZrrik_alt_VPCMPUWZrri_VPCMPUWZrri_alt_VPCMPUWZrrik_VPCMPUWZrrik_alt_VPCMPWZrri_VPCMPWZrri_alt_VPCMPWZrrik_VPCMPWZrrik_alt_VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1042
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 1, false, false, 78, 3,  1, 1,  0, 0}, // #1043
  {DBGFIELD("VPTESTMBZrr_VPTESTMBZrrk_VPTESTMDZrr_VPTESTMDZrrk_VPTESTMQZrr_VPTESTMQZrrk_VPTESTMWZrr_VPTESTMWZrrk_VPTESTNMBZrr_VPTESTNMBZrrk_VPTESTNMDZrr_VPTESTNMDZrrk_VPTESTNMQZrr_VPTESTNMQZrrk_VPTESTNMWZrr_VPTESTNMWZrrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1044
  {DBGFIELD("VCVTDQ2PSZ128rr_VCVTDQ2PSZ128rrk_VCVTDQ2PSZ128rrkz_VCVTUDQ2PSZ128rr_VCVTUDQ2PSZ128rrk_VCVTUDQ2PSZ128rrkz") 1, false, false, 133, 7, 22, 1,  0, 0}, // #1045
  {DBGFIELD("VCVTDQ2PSZ256rr_VCVTDQ2PSZ256rrk_VCVTDQ2PSZ256rrkz_VCVTUDQ2PSZ256rr_VCVTUDQ2PSZ256rrk_VCVTUDQ2PSZ256rrkz") 1, false, false, 133, 7, 22, 1,  0, 0}, // #1046
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 1, false, false, 133, 7, 21, 1,  0, 0}, // #1047
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 1, false, false, 133, 7, 21, 1,  0, 0}, // #1048
  {DBGFIELD("VCVTPS2DQYrr")       1, false, false, 133, 7, 21, 1,  0, 0}, // #1049
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, 133, 7, 21, 1,  0, 0}, // #1050
  {DBGFIELD("VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 1, false, false, 133, 7, 21, 1,  0, 0}, // #1051
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 1, false, false, 133, 7, 22, 1,  0, 0}, // #1052
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 1, false, false, 133, 7, 22, 1,  0, 0}, // #1053
  {DBGFIELD("VCVTDQ2PSZrr_VCVTUDQ2PSZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1054
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1055
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1056
  {DBGFIELD("VCVTQQ2PDZrr_VCVTUQQ2PDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1057
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 1, false, false, 104, 8, 21, 1,  0, 0}, // #1058
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 1, false, false, 104, 8, 21, 1,  0, 0}, // #1059
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 2, false, false, 140, 10,  9, 1,  0, 0}, // #1060
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 1, false, false, 133, 7, 22, 1,  0, 0}, // #1061
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 1, false, false, 133, 7, 21, 1,  0, 0}, // #1062
  {DBGFIELD("VCVTPD2PSZ128rr_VCVTPD2PSZ128rrk_VCVTPD2PSZ128rrkz") 1, false, false, 133, 7, 21, 1,  0, 0}, // #1063
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz") 1, false, false, 133, 7, 21, 1,  0, 0}, // #1064
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false, 133, 7, 21, 1,  0, 0}, // #1065
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false, 133, 7, 22, 1,  0, 0}, // #1066
  {DBGFIELD("VCVTSD2SSZrr_VCVTSD2SSZrr_Int_VCVTSD2SSZrr_Intk_VCVTSD2SSZrr_Intkz_VCVTSD2SSZrrb_Int_VCVTSD2SSZrrb_Intk_VCVTSD2SSZrrb_Intkz") 1, false, false, 133, 7, 21, 1,  0, 0}, // #1067
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 1, false, false, 133, 7, 22, 1,  0, 0}, // #1068
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI2SDZrrb_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 1, false, false, 133, 7, 22, 1,  0, 0}, // #1069
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz") 1, false, false, 133, 7, 21, 1,  0, 0}, // #1070
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, 77, 4,  1, 1,  0, 0}, // #1071
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 3, false, false, 709, 10,  7, 1,  0, 0}, // #1072
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 3, false, false, 709, 10,  5, 1,  0, 0}, // #1073
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1074
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 2, false, false, 140, 10,  9, 1,  0, 0}, // #1075
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 1, false, false, 104, 8, 21, 1,  0, 0}, // #1076
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm_VMOVDI2PDIZrm") 1, false, false, 101, 3,  7, 1,  0, 0}, // #1077
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 1, false, false, 133, 7, 22, 1,  0, 0}, // #1078
  {DBGFIELD("VMOVSDZrm_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, 101, 3,  7, 1,  0, 0}, // #1079
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 1, false, false, 133, 7, 22, 1,  0, 0}, // #1080
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 1, false, false, 133, 7, 21, 1,  0, 0}, // #1081
  {DBGFIELD("VCVTPD2PSZ256rr_VCVTPD2PSZ256rrk_VCVTPD2PSZ256rrkz") 1, false, false, 133, 7, 21, 1,  0, 0}, // #1082
  {DBGFIELD("VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 1, false, false, 133, 7, 21, 1,  0, 0}, // #1083
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 1, false, false, 133, 7, 21, 1,  0, 0}, // #1084
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 1, false, false, 133, 7, 22, 1,  0, 0}, // #1085
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1086
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1087
  {DBGFIELD("VCVTPD2PSZrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1088
  {DBGFIELD("VCVTPS2PDZrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1089
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1090
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1091
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 3, false, false, 150, 10,  5, 1,  9, 1}, // #1092
  {DBGFIELD("VBROADCASTI32X2Z128m_VBROADCASTI32X2Z128mk_VBROADCASTI32X2Z128mkz_VPBROADCASTDZ128m_VPBROADCASTDZ128mk_VPBROADCASTDZ128mkz_VPBROADCASTQZ128m_VPBROADCASTQZ128mk_VPBROADCASTQZ128mkz") 2, false, false, 140, 10,  6, 1,  0, 0}, // #1093
  {DBGFIELD("VBROADCASTSSZ128m_VBROADCASTSSZ128mk_VBROADCASTSSZ128mkz") 2, false, false, 140, 10,  9, 1,  0, 0}, // #1094
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, 101, 3,  7, 1,  0, 0}, // #1095
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 2, false, false, 140, 10,  6, 1,  0, 0}, // #1096
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz_VMOVNTDQAZ128rm") 1, false, false, 101, 3,  7, 1,  0, 0}, // #1097
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 2, false, false, 208, 6,  6, 1,  9, 1}, // #1098
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 3, false, false, 150, 10,  5, 1,  9, 1}, // #1099
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 1, false, false, 104, 8, 21, 1,  0, 0}, // #1100
  {DBGFIELD("VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 1, false, false, 133, 7, 21, 1,  0, 0}, // #1101
  {DBGFIELD("VCVTSS2SI64rr_Int")  2, false, false, 947, 12, 22, 1,  0, 0}, // #1102
  {DBGFIELD("VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int") 2, false, false, 947, 12, 22, 1,  0, 0}, // #1103
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, 101, 3,  7, 1,  0, 0}, // #1104
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 2, false, false, 140, 10,  9, 1,  0, 0}, // #1105
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 1, false, false, 97, 4,  1, 1,  0, 0}, // #1106
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 1, false, false, 97, 4,  1, 1,  0, 0}, // #1107
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 1, false, false, 97, 4,  1, 1,  0, 0}, // #1108
  {DBGFIELD("VSCATTERDPSZmr")     1, false, false, 97, 4,  1, 1,  0, 0}, // #1109
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk") 2, false, false, 124, 9, 10, 1,  9, 1}, // #1110
  {DBGFIELD("VPBROADCASTBZ256m_VPBROADCASTBZ256mk_VPBROADCASTBZ256mkz_VPBROADCASTBZm_VPBROADCASTBZmk_VPBROADCASTBZmkz_VPBROADCASTWZ256m_VPBROADCASTWZ256mk_VPBROADCASTWZ256mkz_VPBROADCASTWZm_VPBROADCASTWZmk_VPBROADCASTWZmkz") 2, false, false, 140, 10,  9, 1,  0, 0}, // #1111
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 3, false, false, 150, 10, 10, 1,  9, 1}, // #1112
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1113
  {DBGFIELD("VBROADCASTF32X2Z256m_VBROADCASTF32X2Z256mk_VBROADCASTF32X2Z256mkz_VBROADCASTF32X2Zm_VBROADCASTF32X2Zmk_VBROADCASTF32X2Zmkz_VBROADCASTI32X2Z256m_VBROADCASTI32X2Z256mk_VBROADCASTI32X2Z256mkz_VBROADCASTI32X2Zm_VBROADCASTI32X2Zmk_VBROADCASTI32X2Zmkz_VPBROADCASTDZ256m_VPBROADCASTDZ256mk_VPBROADCASTDZ256mkz_VPBROADCASTDZm_VPBROADCASTDZmk_VPBROADCASTDZmkz_VPBROADCASTQZ256m_VPBROADCASTQZ256mk_VPBROADCASTQZ256mkz_VPBROADCASTQZm_VPBROADCASTQZmk_VPBROADCASTQZmkz") 2, false, false, 140, 10,  9, 1,  0, 0}, // #1114
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 2, false, false, 140, 10,  5, 1,  0, 0}, // #1115
  {DBGFIELD("VBROADCASTSDZ256m_VBROADCASTSDZ256mk_VBROADCASTSDZ256mkz_VBROADCASTSDZm_VBROADCASTSDZmk_VBROADCASTSDZmkz_VBROADCASTSSZ256m_VBROADCASTSSZ256mk_VBROADCASTSSZ256mkz_VBROADCASTSSZm_VBROADCASTSSZmk_VBROADCASTSSZmkz") 2, false, false, 140, 10,  9, 1,  0, 0}, // #1116
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 2, false, false, 140, 10,  9, 1,  9, 1}, // #1117
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 2, false, false, 140, 10,  9, 1,  9, 1}, // #1118
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 1, false, false, 101, 3,  6, 1,  0, 0}, // #1119
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, 140, 10,  5, 1,  0, 0}, // #1120
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1121
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz_VMOVNTDQAZ256rm") 1, false, false, 101, 3,  6, 1,  0, 0}, // #1122
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 2, false, false, 208, 6,  5, 1,  9, 1}, // #1123
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1124
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 3, false, false, 150, 10, 10, 1,  9, 1}, // #1125
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1126
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 1, false, false, 97, 4,  1, 1,  0, 0}, // #1127
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 1, false, false, 97, 4,  1, 1,  0, 0}, // #1128
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 1, false, false, 97, 4,  1, 1,  0, 0}, // #1129
  {DBGFIELD("VPSCATTERDDZmr")     1, false, false, 97, 4,  1, 1,  0, 0}, // #1130
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 2, false, false, 140, 10,  6, 1,  9, 1}, // #1131
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbi_alt_VCMPPDZ128rmbi_altk_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmi_alt_VCMPPDZ128rmi_altk_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbi_alt_VCMPPSZ128rmbi_altk_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmi_alt_VCMPPSZ128rmi_altk_VCMPPSZ128rmik") 2, false, false, 124, 9, 10, 1,  9, 1}, // #1132
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSDZrmi_alt_VCMPSDZrmi_altk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk_VCMPSSZrmi_alt_VCMPSSZrmi_altk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 2, false, false, 124, 9, 10, 1,  9, 1}, // #1133
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmi_alt_VPCMPBZ128rmik_VPCMPBZ128rmik_alt_VPCMPDZ128rmi_VPCMPDZ128rmi_alt_VPCMPDZ128rmib_VPCMPDZ128rmib_alt_VPCMPDZ128rmibk_VPCMPDZ128rmibk_alt_VPCMPDZ128rmik_VPCMPDZ128rmik_alt_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmi_alt_VPCMPQZ128rmib_VPCMPQZ128rmib_alt_VPCMPQZ128rmibk_VPCMPQZ128rmibk_alt_VPCMPQZ128rmik_VPCMPQZ128rmik_alt_VPCMPUBZ128rmi_VPCMPUBZ128rmi_alt_VPCMPUBZ128rmik_VPCMPUBZ128rmik_alt_VPCMPUDZ128rmi_VPCMPUDZ128rmi_alt_VPCMPUDZ128rmib_VPCMPUDZ128rmib_alt_VPCMPUDZ128rmibk_VPCMPUDZ128rmibk_alt_VPCMPUDZ128rmik_VPCMPUDZ128rmik_alt_VPCMPUQZ128rmi_VPCMPUQZ128rmi_alt_VPCMPUQZ128rmib_VPCMPUQZ128rmib_alt_VPCMPUQZ128rmibk_VPCMPUQZ128rmibk_alt_VPCMPUQZ128rmik_VPCMPUQZ128rmik_alt_VPCMPUWZ128rmi_VPCMPUWZ128rmi_alt_VPCMPUWZ128rmik_VPCMPUWZ128rmik_alt_VPCMPWZ128rmi_VPCMPWZ128rmi_alt_VPCMPWZ128rmik_VPCMPWZ128rmik_alt_VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 2, false, false, 208, 6,  6, 1,  9, 1}, // #1134
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 2, false, false, 140, 10,  9, 1,  9, 1}, // #1135
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 2, false, false, 140, 10,  9, 1,  9, 1}, // #1136
  {DBGFIELD("VPMOVSXBDZ128rm_VPMOVSXBDZ128rmk_VPMOVSXBDZ128rmkz_VPMOVSXBQZ128rm_VPMOVSXBQZ128rmk_VPMOVSXBQZ128rmkz_VPMOVSXBWZ128rm_VPMOVSXBWZ128rmk_VPMOVSXBWZ128rmkz_VPMOVSXDQZ128rm_VPMOVSXDQZ128rmk_VPMOVSXDQZ128rmkz_VPMOVSXWDZ128rm_VPMOVSXWDZ128rmk_VPMOVSXWDZ128rmkz_VPMOVSXWQZ128rm_VPMOVSXWQZ128rmk_VPMOVSXWQZ128rmkz_VPMOVZXBDZ128rm_VPMOVZXBDZ128rmk_VPMOVZXBDZ128rmkz_VPMOVZXBQZ128rm_VPMOVZXBQZ128rmk_VPMOVZXBQZ128rmkz_VPMOVZXBWZ128rm_VPMOVZXBWZ128rmk_VPMOVZXBWZ128rmkz_VPMOVZXDQZ128rm_VPMOVZXDQZ128rmk_VPMOVZXDQZ128rmkz_VPMOVZXWDZ128rm_VPMOVZXWDZ128rmk_VPMOVZXWDZ128rmkz_VPMOVZXWQZ128rm_VPMOVZXWQZ128rmk_VPMOVZXWQZ128rmkz") 2, false, false, 140, 10,  9, 1,  0, 0}, // #1137
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 2, false, false, 128, 5,  6, 1,  9, 1}, // #1138
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 2, false, false, 140, 10,  5, 1,  9, 1}, // #1139
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1140
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbi_alt_VCMPPDZ256rmbi_altk_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmi_alt_VCMPPDZ256rmi_altk_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbi_alt_VCMPPSZ256rmbi_altk_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmi_alt_VCMPPSZ256rmi_altk_VCMPPSZ256rmik") 2, false, false, 124, 9,  9, 1,  9, 1}, // #1141
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbi_alt_VCMPPDZrmbi_altk_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmi_alt_VCMPPDZrmi_altk_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbi_alt_VCMPPSZrmbi_altk_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmi_alt_VCMPPSZrmi_altk_VCMPPSZrmik") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1142
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmi_alt_VPCMPBZ256rmik_VPCMPBZ256rmik_alt_VPCMPDZ256rmi_VPCMPDZ256rmi_alt_VPCMPDZ256rmib_VPCMPDZ256rmib_alt_VPCMPDZ256rmibk_VPCMPDZ256rmibk_alt_VPCMPDZ256rmik_VPCMPDZ256rmik_alt_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmi_alt_VPCMPQZ256rmib_VPCMPQZ256rmib_alt_VPCMPQZ256rmibk_VPCMPQZ256rmibk_alt_VPCMPQZ256rmik_VPCMPQZ256rmik_alt_VPCMPUBZ256rmi_VPCMPUBZ256rmi_alt_VPCMPUBZ256rmik_VPCMPUBZ256rmik_alt_VPCMPUDZ256rmi_VPCMPUDZ256rmi_alt_VPCMPUDZ256rmib_VPCMPUDZ256rmib_alt_VPCMPUDZ256rmibk_VPCMPUDZ256rmibk_alt_VPCMPUDZ256rmik_VPCMPUDZ256rmik_alt_VPCMPUQZ256rmi_VPCMPUQZ256rmi_alt_VPCMPUQZ256rmib_VPCMPUQZ256rmib_alt_VPCMPUQZ256rmibk_VPCMPUQZ256rmibk_alt_VPCMPUQZ256rmik_VPCMPUQZ256rmik_alt_VPCMPUWZ256rmi_VPCMPUWZ256rmi_alt_VPCMPUWZ256rmik_VPCMPUWZ256rmik_alt_VPCMPWZ256rmi_VPCMPWZ256rmi_alt_VPCMPWZ256rmik_VPCMPWZ256rmik_alt_VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 2, false, false, 208, 6,  5, 1,  9, 1}, // #1143
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmi_alt_VPCMPBZrmik_VPCMPBZrmik_alt_VPCMPDZrmi_VPCMPDZrmi_alt_VPCMPDZrmib_VPCMPDZrmib_alt_VPCMPDZrmibk_VPCMPDZrmibk_alt_VPCMPDZrmik_VPCMPDZrmik_alt_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmi_alt_VPCMPQZrmib_VPCMPQZrmib_alt_VPCMPQZrmibk_VPCMPQZrmibk_alt_VPCMPQZrmik_VPCMPQZrmik_alt_VPCMPUBZrmi_VPCMPUBZrmi_alt_VPCMPUBZrmik_VPCMPUBZrmik_alt_VPCMPUDZrmi_VPCMPUDZrmi_alt_VPCMPUDZrmib_VPCMPUDZrmib_alt_VPCMPUDZrmibk_VPCMPUDZrmibk_alt_VPCMPUDZrmik_VPCMPUDZrmik_alt_VPCMPUQZrmi_VPCMPUQZrmi_alt_VPCMPUQZrmib_VPCMPUQZrmib_alt_VPCMPUQZrmibk_VPCMPUQZrmibk_alt_VPCMPUQZrmik_VPCMPUQZrmik_alt_VPCMPUWZrmi_VPCMPUWZrmi_alt_VPCMPUWZrmik_VPCMPUWZrmik_alt_VPCMPWZrmi_VPCMPWZrmi_alt_VPCMPWZrmik_VPCMPWZrmik_alt_VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1144
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 2, false, false, 128, 5,  5, 1,  9, 1}, // #1145
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1146
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 2, false, false, 124, 9,  9, 1,  0, 0}, // #1147
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 2, false, false, 124, 9,  9, 1,  0, 0}, // #1148
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 2, false, false, 124, 9, 10, 1,  0, 0}, // #1149
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 2, false, false, 225, 11,  6, 1,  0, 0}, // #1150
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 2, false, false, 124, 9, 10, 1,  0, 0}, // #1151
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 2, false, false, 124, 9, 10, 1,  0, 0}, // #1152
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz") 2, false, false, 124, 9, 10, 1,  9, 1}, // #1153
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 2, false, false, 140, 10,  9, 1,  9, 1}, // #1154
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 2, false, false, 124, 9,  9, 1,  0, 0}, // #1155
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1156
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 2, false, false, 124, 9,  9, 1,  0, 0}, // #1157
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1158
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 2, false, false, 225, 11,  6, 1,  0, 0}, // #1159
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1160
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 2, false, false, 124, 9, 10, 1,  0, 0}, // #1161
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1162
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 2, false, false, 124, 9, 10, 1,  0, 0}, // #1163
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1164
  {DBGFIELD("VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 2, false, false, 124, 9, 10, 1,  0, 0}, // #1165
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1166
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 2, false, false, 140, 10,  9, 1,  9, 1}, // #1167
  {DBGFIELD("VCVTSD2SSZrm_VCVTSD2SSZrm_Int_VCVTSD2SSZrm_Intk_VCVTSD2SSZrm_Intkz") 2, false, false, 124, 9, 10, 1,  9, 1}, // #1168
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 2, false, false, 208, 6,  6, 1,  0, 0}, // #1169
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, 237, 9,  7, 1,  0, 0}, // #1170
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 1, false, false, 237, 9,  7, 1,  0, 0}, // #1171
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1172
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 2, false, false, 140, 10,  9, 1,  9, 1}, // #1173
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 2, false, false, 124, 9, 10, 1,  9, 1}, // #1174
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 2, false, false, 124, 9, 10, 1,  9, 1}, // #1175
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1176
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 2, false, false, 140, 10,  9, 1,  9, 1}, // #1177
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 2, false, false, 140, 10,  9, 1,  9, 1}, // #1178
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1179
  {DBGFIELD("VCVTPD2PSZrm_VCVTPD2PSZrmb_VCVTPD2PSZrmbk_VCVTPD2PSZrmbkz_VCVTPD2PSZrmk_VCVTPD2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1180
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1181
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 2, false, false, 140, 10,  9, 1,  9, 1}, // #1182
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 2, false, false, 208, 6,  6, 1,  0, 0}, // #1183
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 2, false, false, 225, 11, 18, 1,  9, 1}, // #1184
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 2, false, false, 225, 11, 26, 1,  9, 1}, // #1185
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1186
  {DBGFIELD("VGATHERDPSZ128rm_VGATHERQPSZrm_VPGATHERDDZ128rm") 1, false, false, 101, 3,  7, 1,  0, 0}, // #1187
  {DBGFIELD("VGATHERQPSZ128rm_VGATHERQPSZ256rm_VPGATHERQDZ128rm_VPGATHERQDZ256rm") 1, false, false, 101, 3,  7, 1,  0, 0}, // #1188
  {DBGFIELD("VGATHERDPDZ128rm_VGATHERQPDZ128rm_VPGATHERDQZ128rm_VPGATHERQQZ128rm") 1, false, false, 101, 3,  7, 1,  0, 0}, // #1189
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz") 1, false, false, 77, 4,  1, 1,  0, 0}, // #1190
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 1, false, false, 77, 4,  1, 1,  0, 0}, // #1191
  {DBGFIELD("VGATHERDPDZ256rm_VGATHERQPDZ256rm_VPGATHERDQZ256rm_VPGATHERQDZrm_VPGATHERQQZ256rm") 1, false, false, 101, 3,  7, 1,  0, 0}, // #1192
  {DBGFIELD("VGATHERDPDZrm_VGATHERQPDZrm_VPGATHERDQZrm_VPGATHERQQZrm") 1, false, false, 101, 3,  7, 1,  0, 0}, // #1193
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm") 1, false, false, 101, 3,  7, 1,  0, 0}, // #1194
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 2, false, false, 208, 6,  5, 1,  0, 0}, // #1195
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 1, false, false, 101, 3,  7, 1,  0, 0}, // #1196
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz") 1, false, false, 77, 4,  1, 1,  0, 0}, // #1197
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1198
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 2, false, false, 208, 6,  5, 1,  0, 0}, // #1199
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1200
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1201
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1202
  {DBGFIELD("JWriteZeroLatency")  0, false, false,  0, 0,  0, 0,  0, 0}, // #1203
  {DBGFIELD("WriteVecALU")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1204
  {DBGFIELD("WriteVecALUX")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1205
  {DBGFIELD("WriteALU")           0, false, false,  0, 0,  0, 0,  0, 0}, // #1206
  {DBGFIELD("WriteFLogic")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1207
  {DBGFIELD("WriteVecLogic")      0, false, false,  0, 0,  0, 0,  0, 0}, // #1208
  {DBGFIELD("WriteVecLogicX")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1209
  {DBGFIELD("JWrite3OpsLEA")      0, false, false,  0, 0,  0, 0,  0, 0}, // #1210
  {DBGFIELD("WriteLEA")           0, false, false,  0, 0,  0, 0,  0, 0}, // #1211
}; // BroadwellModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc BtVer2ModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  16383, false, false,  0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteZero")          1, false, false,  0, 0,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteVecALU")        1, false, false, 1571, 2,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteALULd_WriteRMW") 2, false, false, 1573, 4, 80, 2,  0, 0}, // #3
  {DBGFIELD("WriteJumpLd")        1, false, false, 225, 3, 22, 1,  0, 0}, // #4
  {DBGFIELD("WriteALU")           1, false, false,  1, 1,  1, 1,  0, 0}, // #5
  {DBGFIELD("WriteMove")          1, false, false,  1, 1,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteJump")          1, false, false,  1, 1,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false,  1, 1,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteFStoreX")       1, false, false, 1577, 5,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteFLoadX")        1, false, false, 1582, 4,  7, 1,  0, 0}, // #10
  {DBGFIELD("WriteFStoreY")       1, false, false, 1577, 5,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteFLoadY")        1, false, false, 1582, 4,  7, 1,  0, 0}, // #12
  {DBGFIELD("WriteMicrocoded")    1, false, false,  1, 1,  4, 1,  0, 0}, // #13
  {DBGFIELD("WriteFSign")         1, false, false, 1586, 4, 20, 1,  0, 0}, // #14
  {DBGFIELD("WriteADC")           1, false, false,  3, 1,  1, 1,  0, 0}, // #15
  {DBGFIELD("WriteADCRMW")        2, false, false, 1590, 4,  7, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCLd_ReadAfterLd") 1, false, false, 1594, 3, 22, 1,  1, 1}, // #17
  {DBGFIELD("WriteALURMW")        2, false, false, 1573, 4,  7, 1,  0, 0}, // #18
  {DBGFIELD("WriteALULd_ReadAfterLd") 1, false, false, 225, 3, 22, 1,  1, 1}, // #19
  {DBGFIELD("WriteFAdd64XLd_ReadAfterLd") 1, false, false, 1597, 6, 10, 1,  1, 1}, // #20
  {DBGFIELD("WriteFAdd64X")       1, false, false, 1597, 4, 21, 1,  0, 0}, // #21
  {DBGFIELD("WriteFAddXLd_ReadAfterLd") 1, false, false, 1597, 6, 10, 1,  1, 1}, // #22
  {DBGFIELD("WriteFAddX")         1, false, false, 1597, 4, 21, 1,  0, 0}, // #23
  {DBGFIELD("WriteFAdd64Ld_ReadAfterLd") 1, false, false, 1597, 6, 10, 1,  1, 1}, // #24
  {DBGFIELD("WriteFAdd64")        1, false, false, 1597, 4, 21, 1,  0, 0}, // #25
  {DBGFIELD("WriteFAddLd_ReadAfterLd") 1, false, false, 1597, 6, 10, 1,  1, 1}, // #26
  {DBGFIELD("WriteFAdd")          1, false, false, 1597, 4, 21, 1,  0, 0}, // #27
  {DBGFIELD("WriteFAddLd")        1, false, false, 1597, 6, 10, 1,  0, 0}, // #28
  {DBGFIELD("WriteAESDecEncLd_ReadAfterLd") 2, false, false, 1603, 5, 10, 1,  1, 1}, // #29
  {DBGFIELD("WriteAESDecEnc")     2, false, false, 1608, 3, 21, 1,  0, 0}, // #30
  {DBGFIELD("WriteAESIMCLd")      1, false, false, 1603, 5,  5, 1,  0, 0}, // #31
  {DBGFIELD("WriteAESIMC")        1, false, false, 1608, 3, 20, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESKeyGenLd")   1, false, false, 1603, 5,  5, 1,  0, 0}, // #33
  {DBGFIELD("WriteAESKeyGen")     1, false, false, 1608, 3, 20, 1,  0, 0}, // #34
  {DBGFIELD("WriteFLogicLd_ReadAfterLd") 1, false, false, 1582, 4,  6, 1,  1, 1}, // #35
  {DBGFIELD("WriteFLogic")        1, false, false, 1582, 2,  1, 1,  0, 0}, // #36
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, 225, 3, 22, 1,  2, 1}, // #37
  {DBGFIELD("WriteBEXTR")         1, false, false,  1, 1,  1, 1,  0, 0}, // #38
  {DBGFIELD("WriteBEXTRLd")       1, false, false, 225, 3, 22, 1,  0, 0}, // #39
  {DBGFIELD("WriteALULd")         1, false, false, 225, 3, 22, 1,  0, 0}, // #40
  {DBGFIELD("WriteFBlendLd_ReadAfterLd") 1, false, false, 1582, 4,  6, 1,  1, 1}, // #41
  {DBGFIELD("WriteFBlend")        1, false, false, 1582, 2,  1, 1,  0, 0}, // #42
  {DBGFIELD("WriteFVarBlendLd_ReadAfterLd") 3, false, false, 1611, 4,  5, 1,  1, 1}, // #43
  {DBGFIELD("WriteFVarBlend")     3, false, false, 1611, 2, 20, 1,  0, 0}, // #44
  {DBGFIELD("WriteBSFLd")         8, false, false, 1615, 3, 10, 1,  0, 0}, // #45
  {DBGFIELD("WriteBSF")           8, false, false, 26, 1,  7, 1,  0, 0}, // #46
  {DBGFIELD("WriteBSRLd")         8, false, false, 1615, 3, 10, 1,  0, 0}, // #47
  {DBGFIELD("WriteBSR")           8, false, false, 26, 1,  7, 1,  0, 0}, // #48
  {DBGFIELD("WriteBSWAP32")       1, false, false,  1, 1,  1, 1,  0, 0}, // #49
  {DBGFIELD("WriteBSWAP64")       1, false, false,  1, 1,  1, 1,  0, 0}, // #50
  {DBGFIELD("WriteBitTest")       1, false, false,  1, 1,  1, 1,  0, 0}, // #51
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #52
  {DBGFIELD("WriteBZHI")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #53
  {DBGFIELD("WriteLoad")          1, false, false, 226, 2,  7, 1,  0, 0}, // #54
  {DBGFIELD("WriteCMOV2Ld_ReadAfterLd") 1, false, false, 225, 3, 22, 1,  1, 1}, // #55
  {DBGFIELD("WriteCMOV2")         1, false, false,  1, 1,  1, 1,  0, 0}, // #56
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 1, false, false, 225, 3, 22, 1,  1, 1}, // #57
  {DBGFIELD("WriteCMOV")          1, false, false,  1, 1,  1, 1,  0, 0}, // #58
  {DBGFIELD("WriteFCMOV")         1, false, false, 1597, 4, 21, 1,  0, 0}, // #59
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, 225, 3, 22, 1,  2, 1}, // #60
  {DBGFIELD("WriteFCmp64XLd_ReadAfterLd") 1, false, false, 1597, 6,  5, 1,  1, 1}, // #61
  {DBGFIELD("WriteFCmp64X")       1, false, false, 1597, 4, 20, 1,  0, 0}, // #62
  {DBGFIELD("WriteFCmpXLd_ReadAfterLd") 1, false, false, 1597, 6,  5, 1,  1, 1}, // #63
  {DBGFIELD("WriteFCmpX")         1, false, false, 1597, 4, 20, 1,  0, 0}, // #64
  {DBGFIELD("WriteFCmp64Ld_ReadAfterLd") 1, false, false, 1597, 6,  5, 1,  1, 1}, // #65
  {DBGFIELD("WriteFCmp64")        1, false, false, 1597, 4, 20, 1,  0, 0}, // #66
  {DBGFIELD("WriteFCmpLd_ReadAfterLd") 1, false, false, 1597, 6,  5, 1,  1, 1}, // #67
  {DBGFIELD("WriteFCmp")          1, false, false, 1597, 4, 20, 1,  0, 0}, // #68
  {DBGFIELD("WriteFComLd_ReadAfterLd") 1, false, false, 1618, 8, 10, 1,  1, 1}, // #69
  {DBGFIELD("WriteFCom")          1, false, false, 1618, 6, 21, 1,  0, 0}, // #70
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 3, false, false, 1615, 3,  6, 1,  1, 1}, // #71
  {DBGFIELD("WriteCRC32")         3, false, false, 26, 1, 21, 1,  0, 0}, // #72
  {DBGFIELD("WriteNop")           1, false, false,  1, 1,  1, 1,  0, 0}, // #73
  {DBGFIELD("WriteCvtI2PDLd")     1, false, false, 1626, 5, 10, 1,  0, 0}, // #74
  {DBGFIELD("WriteCvtI2PD")       1, false, false, 1631, 3, 21, 1,  0, 0}, // #75
  {DBGFIELD("WriteCvtI2PSLd")     1, false, false, 1626, 5, 10, 1,  0, 0}, // #76
  {DBGFIELD("WriteCvtI2PS")       1, false, false, 1631, 3, 21, 1,  0, 0}, // #77
  {DBGFIELD("WriteCvtPD2ILd")     1, false, false, 1626, 5, 10, 1,  0, 0}, // #78
  {DBGFIELD("WriteCvtPD2I")       1, false, false, 1631, 3, 21, 1,  0, 0}, // #79
  {DBGFIELD("WriteCvtPD2PSLd")    1, false, false, 1626, 5, 10, 1,  0, 0}, // #80
  {DBGFIELD("WriteCvtPD2PS")      1, false, false, 1631, 3, 21, 1,  0, 0}, // #81
  {DBGFIELD("WriteCvtPS2ILd")     1, false, false, 1626, 5, 10, 1,  0, 0}, // #82
  {DBGFIELD("WriteCvtPS2I")       1, false, false, 1631, 3, 21, 1,  0, 0}, // #83
  {DBGFIELD("WriteCvtPS2PDLd")    1, false, false, 1626, 5,  5, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtPS2PD")      1, false, false, 1631, 3, 20, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtSD2ILd")     2, false, false, 1634, 9, 19, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtSD2I")       2, false, false, 1643, 7,  5, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtSD2SSLd")    2, false, false, 1650, 5, 19, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterLd") 2, false, false, 1650, 5, 19, 1,  1, 1}, // #89
  {DBGFIELD("WriteCvtSD2SS")      2, false, false, 1655, 3,  5, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, 1626, 5, 25, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterLd") 2, false, false, 1626, 5, 25, 1,  1, 1}, // #92
  {DBGFIELD("WriteCvtI2SD")       2, false, false, 1631, 3,  9, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtI2SSLd")     2, false, false, 1626, 5, 25, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterLd") 2, false, false, 1626, 5, 25, 1,  1, 1}, // #95
  {DBGFIELD("WriteCvtI2SS")       2, false, false, 1631, 3,  9, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtSS2SDLd")    2, false, false, 1650, 5, 19, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterLd") 2, false, false, 1650, 5, 19, 1,  1, 1}, // #98
  {DBGFIELD("WriteCvtSS2SD")      2, false, false, 1655, 3,  5, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtSS2ILd")     2, false, false, 1634, 9, 19, 1,  0, 0}, // #100
  {DBGFIELD("WriteCvtSS2I")       2, false, false, 1643, 7,  5, 1,  0, 0}, // #101
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 1658, 5, 30, 1,  3, 2}, // #102
  {DBGFIELD("WriteDiv16")         2, false, false, 1658, 3, 28, 1,  0, 0}, // #103
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 1663, 5, 82, 1,  3, 2}, // #104
  {DBGFIELD("WriteDiv32")         2, false, false, 1663, 3, 34, 1,  0, 0}, // #105
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 1668, 5, 83, 1,  3, 2}, // #106
  {DBGFIELD("WriteDiv64")         2, false, false, 1668, 3, 84, 1,  0, 0}, // #107
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 1673, 5, 24, 1,  3, 2}, // #108
  {DBGFIELD("WriteDiv8")          1, false, false, 1673, 3, 19, 1,  0, 0}, // #109
  {DBGFIELD("WriteFDiv64XLd_ReadAfterLd") 1, false, false, 1678, 6, 72, 1,  1, 1}, // #110
  {DBGFIELD("WriteFDiv64X")       1, false, false, 1678, 4, 65, 1,  0, 0}, // #111
  {DBGFIELD("WriteFDivXLd_ReadAfterLd") 1, false, false, 1678, 6, 72, 1,  1, 1}, // #112
  {DBGFIELD("WriteFDivX")         1, false, false, 1678, 4, 65, 1,  0, 0}, // #113
  {DBGFIELD("WriteFDivLd")        1, false, false, 1678, 6, 72, 1,  0, 0}, // #114
  {DBGFIELD("WriteFDiv")          1, false, false, 1678, 4, 65, 1,  0, 0}, // #115
  {DBGFIELD("WriteFDiv64Ld_ReadAfterLd") 1, false, false, 1678, 6, 72, 1,  1, 1}, // #116
  {DBGFIELD("WriteFDiv64")        1, false, false, 1678, 4, 65, 1,  0, 0}, // #117
  {DBGFIELD("WriteFDivLd_ReadAfterLd") 1, false, false, 1678, 6, 72, 1,  1, 1}, // #118
  {DBGFIELD("WriteDPPDLd_ReadAfterLd") 3, false, false, 1684, 7, 25, 1,  1, 1}, // #119
  {DBGFIELD("WriteDPPD")          3, false, false, 1684, 5,  9, 1,  0, 0}, // #120
  {DBGFIELD("WriteDPPSLd_ReadAfterLd") 5, false, false, 1684, 7,  8, 1,  1, 1}, // #121
  {DBGFIELD("WriteDPPS")          5, false, false, 1684, 5, 26, 1,  0, 0}, // #122
  {DBGFIELD("WriteVecExtractSt")  1, false, false, 1577, 5, 21, 1,  0, 0}, // #123
  {DBGFIELD("WriteVecExtract")    1, false, false, 1618, 6, 21, 1,  0, 0}, // #124
  {DBGFIELD("WriteVecALUX")       1, false, false, 1571, 2,  1, 1,  0, 0}, // #125
  {DBGFIELD("WriteFComLd")        1, false, false, 1618, 8, 10, 1,  0, 0}, // #126
  {DBGFIELD("WriteEMMS")          1, false, false, 1582, 2, 20, 1,  0, 0}, // #127
  {DBGFIELD("WriteFLDC")          1, false, false, 1631, 3, 21, 1,  0, 0}, // #128
  {DBGFIELD("WriteVecALUXLd_ReadAfterLd") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #129
  {DBGFIELD("WriteFHAddLd_ReadAfterLd") 1, false, false, 1597, 6, 10, 1,  1, 1}, // #130
  {DBGFIELD("WriteFHAdd")         1, false, false, 1597, 4, 21, 1,  0, 0}, // #131
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 1658, 5, 30, 1,  3, 2}, // #132
  {DBGFIELD("WriteIDiv16")        2, false, false, 1658, 3, 28, 1,  0, 0}, // #133
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 1663, 5, 82, 1,  3, 2}, // #134
  {DBGFIELD("WriteIDiv32")        2, false, false, 1663, 3, 34, 1,  0, 0}, // #135
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 1668, 5, 83, 1,  3, 2}, // #136
  {DBGFIELD("WriteIDiv64")        2, false, false, 1668, 3, 84, 1,  0, 0}, // #137
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 1673, 5, 24, 1,  3, 2}, // #138
  {DBGFIELD("WriteIDiv8")         1, false, false, 1673, 3, 19, 1,  0, 0}, // #139
  {DBGFIELD("WriteIMulLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 1695, 5,  6, 1,  3, 2}, // #140
  {DBGFIELD("WriteIMul")          2, false, false, 1700, 3, 21, 1,  0, 0}, // #141
  {DBGFIELD("WriteIMulLd_ReadAfterLd") 2, false, false, 1695, 5,  6, 1,  1, 1}, // #142
  {DBGFIELD("WriteIMulLd")        2, false, false, 1695, 5,  6, 1,  0, 0}, // #143
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 1703, 5,  9, 1,  3, 2}, // #144
  {DBGFIELD("WriteIMul64")        2, false, false, 1708, 3,  6, 1,  0, 0}, // #145
  {DBGFIELD("WriteIMul64Ld_ReadAfterLd") 2, false, false, 1703, 5,  9, 1,  1, 1}, // #146
  {DBGFIELD("WriteIMul64Ld")      2, false, false, 1703, 5,  9, 1,  0, 0}, // #147
  {DBGFIELD("WriteFShuffleLd_ReadAfterLd") 1, false, false, 1582, 4,  6, 1,  1, 1}, // #148
  {DBGFIELD("WriteFShuffle")      1, false, false, 1582, 2,  1, 1,  0, 0}, // #149
  {DBGFIELD("WriteStore")         1, false, false, 603, 2,  1, 1,  0, 0}, // #150
  {DBGFIELD("WriteVecLogicX")     1, false, false, 1571, 2,  1, 1,  0, 0}, // #151
  {DBGFIELD("WriteShuffle")       1, false, false, 1571, 2,  1, 1,  0, 0}, // #152
  {DBGFIELD("WriteLAHFSAHF")      1, false, false,  1, 1,  1, 1,  0, 0}, // #153
  {DBGFIELD("WriteVecLoadX")      1, false, false, 1691, 4,  7, 1,  0, 0}, // #154
  {DBGFIELD("WriteLDMXCSR")       1, false, false, 226, 2,  7, 1,  0, 0}, // #155
  {DBGFIELD("WriteFLD0")          1, false, false, 1631, 3, 21, 1,  0, 0}, // #156
  {DBGFIELD("WriteFLD1")          1, false, false, 1631, 3, 21, 1,  0, 0}, // #157
  {DBGFIELD("WriteLEA")           1, false, false,  1, 1,  1, 1,  0, 0}, // #158
  {DBGFIELD("WriteFence")         1, false, false, 603, 2,  1, 1,  0, 0}, // #159
  {DBGFIELD("WriteLZCNTLd")       1, false, false, 225, 3, 22, 1,  0, 0}, // #160
  {DBGFIELD("WriteLZCNT")         1, false, false,  1, 1,  1, 1,  0, 0}, // #161
  {DBGFIELD("WriteVecStoreX")     1, false, false, 1577, 5,  1, 1,  0, 0}, // #162
  {DBGFIELD("WriteVecStore")      1, false, false, 1577, 5, 20, 1,  0, 0}, // #163
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, 1618, 6, 22, 1,  0, 0}, // #164
  {DBGFIELD("WriteVecLoad")       1, false, false, 1691, 4,  7, 1,  0, 0}, // #165
  {DBGFIELD("WriteVecMoveFromGpr") 2, false, false, 1582, 2, 10, 1,  0, 0}, // #166
  {DBGFIELD("WriteVecMoveX")      1, false, false, 1571, 2,  1, 1,  0, 0}, // #167
  {DBGFIELD("WriteVecStoreNT")    1, false, false, 1577, 5, 20, 1,  0, 0}, // #168
  {DBGFIELD("WriteVecMove")       1, false, false, 1571, 2,  1, 1,  0, 0}, // #169
  {DBGFIELD("WriteVecALULd")      1, false, false, 1691, 4,  6, 1,  0, 0}, // #170
  {DBGFIELD("WriteShuffleLd_ReadAfterLd") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #171
  {DBGFIELD("WriteVecALULd_ReadAfterLd") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #172
  {DBGFIELD("WriteVecLogicLd_ReadAfterLd") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #173
  {DBGFIELD("WriteVecLogic")      1, false, false, 1571, 2,  1, 1,  0, 0}, // #174
  {DBGFIELD("WritePHAddLd_ReadAfterLd") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #175
  {DBGFIELD("WritePHAdd")         1, false, false, 1571, 2,  1, 1,  0, 0}, // #176
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 1, false, false, 1691, 4, 22, 1,  1, 1}, // #177
  {DBGFIELD("WriteVecInsert")     2, false, false, 1571, 2,  5, 1,  0, 0}, // #178
  {DBGFIELD("WriteVecIMulLd_ReadAfterLd") 1, false, false, 1603, 5,  5, 1,  1, 1}, // #179
  {DBGFIELD("WriteVecIMul")       1, false, false, 1608, 3, 20, 1,  0, 0}, // #180
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, 1618, 6, 21, 1,  0, 0}, // #181
  {DBGFIELD("WritePSADBWLd_ReadAfterLd") 1, false, false, 1691, 4,  5, 1,  1, 1}, // #182
  {DBGFIELD("WritePSADBW")        1, false, false, 1571, 2, 20, 1,  0, 0}, // #183
  {DBGFIELD("WriteVarShuffleLd_ReadAfterLd") 3, false, false, 1711, 4,  5, 1,  1, 1}, // #184
  {DBGFIELD("WriteVarShuffle")    3, false, false, 1715, 2, 20, 1,  0, 0}, // #185
  {DBGFIELD("WriteShuffleLd")     1, false, false, 1691, 4,  6, 1,  0, 0}, // #186
  {DBGFIELD("WriteVecShiftImm")   1, false, false, 1571, 2,  1, 1,  0, 0}, // #187
  {DBGFIELD("WriteVecShiftLd_ReadAfterLd") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #188
  {DBGFIELD("WriteVecShift")      1, false, false, 1571, 2,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteFMoveX")        1, false, false, 1582, 2,  1, 1,  0, 0}, // #190
  {DBGFIELD("WriteFShuffleLd")    1, false, false, 1582, 4,  6, 1,  0, 0}, // #191
  {DBGFIELD("WriteFStore")        1, false, false, 1577, 5, 20, 1,  0, 0}, // #192
  {DBGFIELD("WriteFMOVMSK")       1, false, false, 1618, 6, 21, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecLoadNT")     1, false, false, 1691, 4,  7, 1,  0, 0}, // #194
  {DBGFIELD("WriteStoreNT")       1, false, false, 603, 2,  1, 1,  0, 0}, // #195
  {DBGFIELD("WriteFStoreNTX")     1, false, false, 1577, 5, 21, 1,  0, 0}, // #196
  {DBGFIELD("WriteFStoreNT")      1, false, false, 1577, 5, 21, 1,  0, 0}, // #197
  {DBGFIELD("WriteFLoad")         1, false, false, 1582, 4,  7, 1,  0, 0}, // #198
  {DBGFIELD("WriteMPSADLd_ReadAfterLd") 1, false, false, 1717, 5, 10, 1,  1, 1}, // #199
  {DBGFIELD("WriteMPSAD")         1, false, false, 1722, 3, 21, 1,  0, 0}, // #200
  {DBGFIELD("WriteFMul64XLd_ReadAfterLd") 1, false, false, 1725, 6,  9, 1,  1, 1}, // #201
  {DBGFIELD("WriteFMul64X")       1, false, false, 1725, 4, 22, 1,  0, 0}, // #202
  {DBGFIELD("WriteFMulXLd_ReadAfterLd") 1, false, false, 1731, 6,  5, 1,  1, 1}, // #203
  {DBGFIELD("WriteFMulX")         1, false, false, 1586, 4, 20, 1,  0, 0}, // #204
  {DBGFIELD("WriteFMul64Ld_ReadAfterLd") 1, false, false, 1725, 6,  9, 1,  1, 1}, // #205
  {DBGFIELD("WriteFMul64")        1, false, false, 1725, 4, 22, 1,  0, 0}, // #206
  {DBGFIELD("WriteFMulLd_ReadAfterLd") 1, false, false, 1731, 6,  5, 1,  1, 1}, // #207
  {DBGFIELD("WriteFMul")          1, false, false, 1586, 4, 20, 1,  0, 0}, // #208
  {DBGFIELD("WriteIMulLd_WriteIMulH") 3, false, false, 1737, 5, 85, 2,  0, 0}, // #209
  {DBGFIELD("WriteIMul_WriteIMulH") 3, false, false, 1742, 3, 87, 2,  0, 0}, // #210
  {DBGFIELD("WriteIMul64Ld_WriteIMulH") 3, false, false, 1745, 5, 89, 2,  0, 0}, // #211
  {DBGFIELD("WriteIMul64_WriteIMulH") 3, false, false, 1750, 3, 85, 2,  0, 0}, // #212
  {DBGFIELD("WriteFMulLd")        1, false, false, 1731, 6,  5, 1,  0, 0}, // #213
  {DBGFIELD("WriteVecALUXLd")     1, false, false, 1691, 4,  6, 1,  0, 0}, // #214
  {DBGFIELD("WriteShuffleXLd_ReadAfterLd") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #215
  {DBGFIELD("WriteShuffleX")      1, false, false, 1571, 2,  1, 1,  0, 0}, // #216
  {DBGFIELD("WriteVecLogicXLd_ReadAfterLd") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #217
  {DBGFIELD("WriteVarBlendLd_ReadAfterLd") 3, false, false, 1711, 4,  5, 1,  1, 1}, // #218
  {DBGFIELD("WriteVarBlend")      3, false, false, 1715, 2, 20, 1,  0, 0}, // #219
  {DBGFIELD("WriteBlendLd_ReadAfterLd") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #220
  {DBGFIELD("WriteBlend")         1, false, false, 1571, 2,  1, 1,  0, 0}, // #221
  {DBGFIELD("WriteCLMulLd_ReadAfterLd") 1, false, false, 1603, 5,  5, 1,  1, 1}, // #222
  {DBGFIELD("WriteCLMul")         1, false, false, 1608, 3, 20, 1,  0, 0}, // #223
  {DBGFIELD("WritePCmpEStrILd_ReadAfterLd") 9, false, false, 1753, 11, 65, 1,  1, 1}, // #224
  {DBGFIELD("WritePCmpEStrI")     9, false, false, 1764, 11, 25, 1,  0, 0}, // #225
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterLd") 9, false, false, 1753, 11, 65, 1,  1, 1}, // #226
  {DBGFIELD("WritePCmpEStrM")     9, false, false, 1764, 11, 25, 1,  0, 0}, // #227
  {DBGFIELD("WritePCmpIStrILd_ReadAfterLd") 3, false, false, 1775, 10, 19, 1,  1, 1}, // #228
  {DBGFIELD("WritePCmpIStrI")     3, false, false, 1785, 8,  5, 1,  0, 0}, // #229
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterLd") 3, false, false, 1775, 10, 27, 1,  1, 1}, // #230
  {DBGFIELD("WritePCmpIStrM")     3, false, false, 1785, 8, 10, 1,  0, 0}, // #231
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterLd") 1, false, false, 1626, 5, 10, 1,  1, 1}, // #232
  {DBGFIELD("WritePHAddXLd_ReadAfterLd") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #233
  {DBGFIELD("WritePHAddX")        1, false, false, 1571, 2,  1, 1,  0, 0}, // #234
  {DBGFIELD("WritePHMINPOSLd")    1, false, false, 1793, 5,  5, 1,  0, 0}, // #235
  {DBGFIELD("WritePHMINPOS")      1, false, false, 1798, 3, 20, 1,  0, 0}, // #236
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterLd") 1, false, false, 1626, 5, 10, 1,  1, 1}, // #237
  {DBGFIELD("WriteVecIMulXLd_ReadAfterLd") 1, false, false, 1603, 5,  5, 1,  1, 1}, // #238
  {DBGFIELD("WriteVecIMulX")      1, false, false, 1608, 3, 20, 1,  0, 0}, // #239
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, 1618, 6, 21, 1,  0, 0}, // #240
  {DBGFIELD("WriteShuffleXLd")    1, false, false, 1691, 4,  6, 1,  0, 0}, // #241
  {DBGFIELD("WritePMULLDLd_ReadAfterLd") 3, false, false, 1801, 6,  9, 1,  1, 1}, // #242
  {DBGFIELD("WritePMULLD")        3, false, false, 1807, 4, 22, 1,  0, 0}, // #243
  {DBGFIELD("WriteRMW")           1, false, false, 603, 2,  1, 1,  0, 0}, // #244
  {DBGFIELD("WritePOPCNTLd")      1, false, false, 225, 3, 22, 1,  0, 0}, // #245
  {DBGFIELD("WritePOPCNT")        1, false, false,  1, 1,  1, 1,  0, 0}, // #246
  {DBGFIELD("WritePSADBWXLd_ReadAfterLd") 1, false, false, 1691, 4,  5, 1,  1, 1}, // #247
  {DBGFIELD("WritePSADBWX")       1, false, false, 1571, 2, 20, 1,  0, 0}, // #248
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterLd") 3, false, false, 1711, 4,  5, 1,  1, 1}, // #249
  {DBGFIELD("WriteVarShuffleX")   3, false, false, 1715, 2, 20, 1,  0, 0}, // #250
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, 1571, 2,  1, 1,  0, 0}, // #251
  {DBGFIELD("WriteVecShiftXLd_ReadAfterLd") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #252
  {DBGFIELD("WriteVecShiftX")     1, false, false, 1571, 2,  1, 1,  0, 0}, // #253
  {DBGFIELD("WriteVecTestLd_ReadAfterLd") 1, false, false, 1618, 8, 10, 1,  1, 1}, // #254
  {DBGFIELD("WriteVecTest")       1, false, false, 1618, 6, 21, 1,  0, 0}, // #255
  {DBGFIELD("WriteShiftLd_WriteRMW") 2, false, false, 1573, 4, 80, 2,  0, 0}, // #256
  {DBGFIELD("WriteShift")         1, false, false,  1, 1,  1, 1,  0, 0}, // #257
  {DBGFIELD("WriteFRcpXLd")       1, false, false, 1731, 6,  5, 1,  0, 0}, // #258
  {DBGFIELD("WriteFRcpX")         1, false, false, 1586, 4, 20, 1,  0, 0}, // #259
  {DBGFIELD("WriteFRcpLd_ReadAfterLd") 1, false, false, 1731, 6,  5, 1,  1, 1}, // #260
  {DBGFIELD("WriteFRcp")          1, false, false, 1586, 4, 20, 1,  0, 0}, // #261
  {DBGFIELD("WriteShiftLd")       1, false, false, 225, 3, 22, 1,  0, 0}, // #262
  {DBGFIELD("WriteFRndLd")        1, false, false, 1626, 5, 10, 1,  0, 0}, // #263
  {DBGFIELD("WriteFRnd")          1, false, false, 1631, 3, 21, 1,  0, 0}, // #264
  {DBGFIELD("WriteFRndLd_ReadAfterLd") 1, false, false, 1626, 5, 10, 1,  1, 1}, // #265
  {DBGFIELD("WriteFRsqrtXLd")     1, false, false, 1731, 6,  5, 1,  0, 0}, // #266
  {DBGFIELD("WriteFRsqrtX")       1, false, false, 1586, 4, 20, 1,  0, 0}, // #267
  {DBGFIELD("WriteFRsqrtLd_ReadAfterLd") 1, false, false, 1731, 6,  5, 1,  1, 1}, // #268
  {DBGFIELD("WriteFRsqrt")        1, false, false, 1586, 4, 20, 1,  0, 0}, // #269
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, 225, 3, 22, 1,  2, 1}, // #270
  {DBGFIELD("WriteSETCCStore")    1, false, false, 1811, 3,  1, 1,  0, 0}, // #271
  {DBGFIELD("WriteSETCC")         1, false, false,  1, 1,  1, 1,  0, 0}, // #272
  {DBGFIELD("WriteSHDmrcl")       8, false, false, 1814, 3,  9, 1,  0, 0}, // #273
  {DBGFIELD("WriteSHDmri")        8, false, false, 1814, 3,  9, 1,  0, 0}, // #274
  {DBGFIELD("WriteSHDrrcl")       7, false, false, 14, 1, 22, 1,  0, 0}, // #275
  {DBGFIELD("WriteSHDrri")        6, false, false,  9, 1, 21, 1,  0, 0}, // #276
  {DBGFIELD("WriteFSqrt64XLd")    1, false, false, 1817, 6, 38, 1,  0, 0}, // #277
  {DBGFIELD("WriteFSqrt64X")      1, false, false, 1817, 4, 74, 1,  0, 0}, // #278
  {DBGFIELD("WriteFSqrtXLd")      1, false, false, 1823, 6, 35, 1,  0, 0}, // #279
  {DBGFIELD("WriteFSqrtX")        1, false, false, 1823, 4, 31, 1,  0, 0}, // #280
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterLd") 1, false, false, 1817, 6, 38, 1,  1, 1}, // #281
  {DBGFIELD("WriteFSqrt64")       1, false, false, 1817, 4, 74, 1,  0, 0}, // #282
  {DBGFIELD("WriteFSqrtLd_ReadAfterLd") 1, false, false, 1823, 6, 35, 1,  1, 1}, // #283
  {DBGFIELD("WriteFSqrt")         1, false, false, 1823, 4, 31, 1,  0, 0}, // #284
  {DBGFIELD("WriteFSqrt80")       1, false, false, 1829, 4, 73, 1,  0, 0}, // #285
  {DBGFIELD("WriteSTMXCSR")       1, false, false, 603, 2,  1, 1,  0, 0}, // #286
  {DBGFIELD("WriteTZCNTLd")       1, false, false, 1594, 3,  7, 1,  0, 0}, // #287
  {DBGFIELD("WriteTZCNT")         1, false, false,  3, 1, 20, 1,  0, 0}, // #288
  {DBGFIELD("WriteFMAZLd")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #289
  {DBGFIELD("WriteFMALd")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #290
  {DBGFIELD("WriteFAdd64YLd_ReadAfterLd") 2, false, false, 1833, 6, 10, 1,  1, 1}, // #291
  {DBGFIELD("WriteFAdd64Y")       2, false, false, 1833, 4, 21, 1,  0, 0}, // #292
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #293
  {DBGFIELD("WriteFAdd64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #294
  {DBGFIELD("WriteFAddYLd_ReadAfterLd") 2, false, false, 1833, 6, 10, 1,  1, 1}, // #295
  {DBGFIELD("WriteFAddY")         2, false, false, 1833, 4, 21, 1,  0, 0}, // #296
  {DBGFIELD("WriteFAddZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #297
  {DBGFIELD("WriteFAddZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #298
  {DBGFIELD("WriteShuffleYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #299
  {DBGFIELD("WriteShuffleY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #300
  {DBGFIELD("WriteShuffleZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #301
  {DBGFIELD("WriteShuffleZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #302
  {DBGFIELD("WriteFLogicYLd_ReadAfterLd") 2, false, false, 1835, 4,  6, 1,  1, 1}, // #303
  {DBGFIELD("WriteFLogicY")       2, false, false, 1835, 2,  1, 1,  0, 0}, // #304
  {DBGFIELD("WriteFLogicZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #305
  {DBGFIELD("WriteFLogicZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #306
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterLd") 6, false, false, 1839, 4, 10, 1,  1, 1}, // #307
  {DBGFIELD("WriteFVarBlendY")    6, false, false, 1839, 2, 21, 1,  0, 0}, // #308
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #309
  {DBGFIELD("WriteFVarBlendZ")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #310
  {DBGFIELD("WriteFBlendYLd_ReadAfterLd") 2, false, false, 1835, 4,  6, 1,  1, 1}, // #311
  {DBGFIELD("WriteFBlendY")       2, false, false, 1835, 2,  1, 1,  0, 0}, // #312
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 6, false, false, 1839, 4, 10, 1,  5, 2}, // #313
  {DBGFIELD("WriteFVarBlendLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 1611, 4,  5, 1,  5, 2}, // #314
  {DBGFIELD("WriteShuffle256Ld")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #315
  {DBGFIELD("WriteShuffle256")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #316
  {DBGFIELD("WriteShuffleYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #317
  {DBGFIELD("WriteFShuffle256")   1, false, false, 1582, 2,  1, 1,  0, 0}, // #318
  {DBGFIELD("WriteFShuffle256Ld") 1, false, false, 1582, 4,  6, 1,  0, 0}, // #319
  {DBGFIELD("WriteFCmp64YLd_ReadAfterLd") 2, false, false, 1833, 6,  5, 1,  1, 1}, // #320
  {DBGFIELD("WriteFCmp64Y")       2, false, false, 1833, 4, 20, 1,  0, 0}, // #321
  {DBGFIELD("WriteFCmpYLd_ReadAfterLd") 2, false, false, 1833, 6,  5, 1,  1, 1}, // #322
  {DBGFIELD("WriteFCmpY")         2, false, false, 1833, 4, 20, 1,  0, 0}, // #323
  {DBGFIELD("WriteFCmpZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #324
  {DBGFIELD("WriteFCmpZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #325
  {DBGFIELD("WriteVarShuffle256Ld") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #326
  {DBGFIELD("WriteVarShuffle256") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #327
  {DBGFIELD("WriteCvtI2PDYLd")    2, false, false, 1843, 5, 10, 1,  0, 0}, // #328
  {DBGFIELD("WriteCvtI2PDY")      2, false, false, 1848, 3, 21, 1,  0, 0}, // #329
  {DBGFIELD("WriteCvtI2PDZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #330
  {DBGFIELD("WriteCvtI2PDZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #331
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, 1843, 5, 10, 1,  0, 0}, // #332
  {DBGFIELD("WriteCvtI2PSY")      2, false, false, 1848, 3, 21, 1,  0, 0}, // #333
  {DBGFIELD("WriteCvtI2PSZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #334
  {DBGFIELD("WriteCvtI2PSZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #335
  {DBGFIELD("WriteCvtPD2IYLd")    3, false, false, 1851, 6, 26, 1,  0, 0}, // #336
  {DBGFIELD("WriteCvtPD2IY")      3, false, false, 1857, 4,  6, 1,  0, 0}, // #337
  {DBGFIELD("WriteCvtPD2IZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("WriteCvtPD2IZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #339
  {DBGFIELD("WriteCvtPD2PSYLd")   3, false, false, 1851, 6, 26, 1,  0, 0}, // #340
  {DBGFIELD("WriteCvtPD2PSY")     3, false, false, 1857, 4,  6, 1,  0, 0}, // #341
  {DBGFIELD("WriteCvtPD2PSZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD("WriteCvtPD2PSZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #343
  {DBGFIELD("WriteCvtPH2PSYLd")   2, false, false, 1843, 5, 10, 1,  0, 0}, // #344
  {DBGFIELD("WriteCvtPH2PSY")     2, false, false, 1848, 3, 21, 1,  0, 0}, // #345
  {DBGFIELD("WriteCvtPH2PSLd")    1, false, false, 1626, 5, 10, 1,  0, 0}, // #346
  {DBGFIELD("WriteCvtPH2PS")      1, false, false, 1631, 3, 21, 1,  0, 0}, // #347
  {DBGFIELD("WriteCvtPH2PSZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #348
  {DBGFIELD("WriteCvtPH2PSZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #349
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, 1843, 5, 10, 1,  0, 0}, // #350
  {DBGFIELD("WriteCvtPS2IY")      2, false, false, 1848, 3, 21, 1,  0, 0}, // #351
  {DBGFIELD("WriteCvtPS2IZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #352
  {DBGFIELD("WriteCvtPS2IZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #353
  {DBGFIELD("WriteCvtPS2PDYLd")   2, false, false, 1843, 5,  5, 1,  0, 0}, // #354
  {DBGFIELD("WriteCvtPS2PDY")     2, false, false, 1848, 3, 20, 1,  0, 0}, // #355
  {DBGFIELD("WriteCvtPS2PDZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #356
  {DBGFIELD("WriteCvtPS2PDZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #357
  {DBGFIELD("WriteCvtPS2PHYSt")   3, false, false, 1861, 6,  5, 1,  0, 0}, // #358
  {DBGFIELD("WriteCvtPS2PHY")     3, false, false, 1867, 4,  6, 1,  0, 0}, // #359
  {DBGFIELD("WriteCvtPS2PHSt")    1, false, false, 1577, 5, 22, 1,  0, 0}, // #360
  {DBGFIELD("WriteCvtPS2PH")      1, false, false, 1631, 3, 21, 1,  0, 0}, // #361
  {DBGFIELD("WriteCvtPS2PHZSt")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #362
  {DBGFIELD("WriteCvtPS2PHZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #363
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterLd") 2, false, false, 1634, 9, 19, 1,  1, 1}, // #364
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterLd") 2, false, false, 1634, 9, 19, 1,  1, 1}, // #365
  {DBGFIELD("WritePSADBWYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #366
  {DBGFIELD("WritePSADBWY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #367
  {DBGFIELD("WritePSADBWZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #368
  {DBGFIELD("WritePSADBWZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #369
  {DBGFIELD("WriteFDiv64YLd_ReadAfterLd") 2, false, false, 1871, 6, 91, 1,  1, 1}, // #370
  {DBGFIELD("WriteFDiv64Y")       2, false, false, 1871, 4, 92, 1,  0, 0}, // #371
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #372
  {DBGFIELD("WriteFDiv64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #373
  {DBGFIELD("WriteFDivYLd_ReadAfterLd") 2, false, false, 1871, 6, 91, 1,  1, 1}, // #374
  {DBGFIELD("WriteFDivY")         2, false, false, 1871, 4, 92, 1,  0, 0}, // #375
  {DBGFIELD("WriteFDivZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #376
  {DBGFIELD("WriteFDivZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #377
  {DBGFIELD("WriteDPPSYLd_ReadAfterLd") 10, false, false, 1877, 7, 28, 1,  1, 1}, // #378
  {DBGFIELD("WriteDPPSY")         10, false, false, 1877, 5, 19, 1,  0, 0}, // #379
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteFMAYLd_ReadAfterLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #381
  {DBGFIELD("WriteFMAY")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #382
  {DBGFIELD("WriteFMAXLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #383
  {DBGFIELD("WriteFMAX")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #384
  {DBGFIELD("WriteFMAYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #385
  {DBGFIELD("WriteFMAZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #386
  {DBGFIELD("WriteFMAZ")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #387
  {DBGFIELD("WriteFMAXLd_ReadAfterLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #388
  {DBGFIELD("WriteFMALd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #389
  {DBGFIELD("WriteFMA")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #390
  {DBGFIELD("WriteFMALd_ReadAfterLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #391
  {DBGFIELD("WriteFMAYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #392
  {DBGFIELD("WriteFMAXLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteFMALd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteFRndYLd_ReadAfterLd") 2, false, false, 1843, 5, 10, 1,  1, 1}, // #395
  {DBGFIELD("WriteFRndY")         2, false, false, 1848, 3, 21, 1,  0, 0}, // #396
  {DBGFIELD("WriteFRndZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #397
  {DBGFIELD("WriteFRndZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #398
  {DBGFIELD("WriteVecIMulYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WriteVecIMulY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #400
  {DBGFIELD("WriteVecIMulZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #401
  {DBGFIELD("WriteVecIMulZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #402
  {DBGFIELD("WriteVecALUYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #403
  {DBGFIELD("WriteVecALUY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #404
  {DBGFIELD("WriteVecALUZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteVecALUZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #406
  {DBGFIELD("WriteFHAddYLd_ReadAfterLd") 2, false, false, 1833, 6, 10, 1,  1, 1}, // #407
  {DBGFIELD("WriteFHAddY")        2, false, false, 1833, 4, 21, 1,  0, 0}, // #408
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterLd") 1, false, false, 1582, 4,  6, 1,  1, 1}, // #409
  {DBGFIELD("WriteShuffle256Ld_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #410
  {DBGFIELD("WriteVecLoadY")      1, false, false, 1691, 4,  7, 1,  0, 0}, // #411
  {DBGFIELD("WriteFMaskedStoreY") 2, false, false, 1884, 4,  6, 1,  0, 0}, // #412
  {DBGFIELD("WriteFMaskedLoadY")  2, false, false, 1852, 4,  6, 1,  0, 0}, // #413
  {DBGFIELD("WriteFMaskedStore")  1, false, false, 1888, 4,  6, 1,  0, 0}, // #414
  {DBGFIELD("WriteFMaskedLoad")   1, false, false, 1727, 4,  6, 1,  0, 0}, // #415
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #416
  {DBGFIELD("WriteFCmp64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #417
  {DBGFIELD("WriteFMoveY")        2, false, false, 1835, 2,  1, 1,  0, 0}, // #418
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, 1835, 4,  6, 1,  0, 0}, // #419
  {DBGFIELD("WriteFShuffleY")     2, false, false, 1835, 2,  1, 1,  0, 0}, // #420
  {DBGFIELD("WriteFShuffleZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #421
  {DBGFIELD("WriteFShuffleZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #422
  {DBGFIELD("WriteVecStoreY")     1, false, false, 1577, 5,  1, 1,  0, 0}, // #423
  {DBGFIELD("WriteVecMoveY")      2, false, false, 1892, 2,  1, 1,  0, 0}, // #424
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, 1691, 4,  7, 1,  0, 0}, // #425
  {DBGFIELD("WriteVecStoreNTY")   1, false, false, 1894, 5, 20, 1,  0, 0}, // #426
  {DBGFIELD("WriteFStoreNTY")     1, false, false, 1894, 5, 21, 1,  0, 0}, // #427
  {DBGFIELD("WriteMPSADYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #428
  {DBGFIELD("WriteMPSADY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #429
  {DBGFIELD("WriteFMul64YLd_ReadAfterLd") 2, false, false, 1899, 6,  9, 1,  1, 1}, // #430
  {DBGFIELD("WriteFMul64Y")       2, false, false, 1899, 4, 22, 1,  0, 0}, // #431
  {DBGFIELD("WriteFMul64ZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #432
  {DBGFIELD("WriteFMul64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #433
  {DBGFIELD("WriteFMulYLd_ReadAfterLd") 2, false, false, 1905, 6,  5, 1,  1, 1}, // #434
  {DBGFIELD("WriteFMulY")         2, false, false, 1905, 4, 20, 1,  0, 0}, // #435
  {DBGFIELD("WriteFMulZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #436
  {DBGFIELD("WriteFMulZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #437
  {DBGFIELD("WriteVecALUYLd")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #438
  {DBGFIELD("WriteVecALUZLd")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #439
  {DBGFIELD("WriteVecLogicYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #440
  {DBGFIELD("WriteVecLogicY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteVecLogicZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("WriteVecLogicZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #443
  {DBGFIELD("WriteBlendYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #444
  {DBGFIELD("WriteBlendY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #445
  {DBGFIELD("WriteVarBlendYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #446
  {DBGFIELD("WriteVarBlendY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #447
  {DBGFIELD("WriteVarBlendZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #448
  {DBGFIELD("WriteVarBlendZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #449
  {DBGFIELD("WriteVarBlendYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #450
  {DBGFIELD("WriteVarBlendLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 1711, 4,  5, 1,  5, 2}, // #451
  {DBGFIELD("WriteShuffleYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #452
  {DBGFIELD("WriteShuffleYLd_ReadAfterLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #453
  {DBGFIELD("WriteShuffleXLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, 1691, 4,  6, 1,  5, 2}, // #454
  {DBGFIELD("WriteShuffleXLd_ReadAfterLd_ReadAfterLd") 1, false, false, 1691, 4,  6, 1,  7, 2}, // #455
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #456
  {DBGFIELD("WriteFVarShuffle256") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #457
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 6, false, false, 1839, 4, 10, 1,  5, 2}, // #458
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterLd_ReadAfterLd") 6, false, false, 1839, 4, 10, 1,  7, 2}, // #459
  {DBGFIELD("WriteFVarShuffleY")  6, false, false, 1839, 2, 21, 1,  0, 0}, // #460
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 1611, 4,  5, 1,  5, 2}, // #461
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterLd_ReadAfterLd") 3, false, false, 1611, 4,  5, 1,  7, 2}, // #462
  {DBGFIELD("WriteFVarShuffle")   3, false, false, 1611, 2, 20, 1,  0, 0}, // #463
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterLd") 6, false, false, 1839, 4, 10, 1,  1, 1}, // #464
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterLd") 3, false, false, 1611, 4,  5, 1,  1, 1}, // #465
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #466
  {DBGFIELD("WriteFVarShuffleZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #467
  {DBGFIELD("WritePHAddYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WritePHAddY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #469
  {DBGFIELD("WriteVecIMulXLd")    1, false, false, 1603, 5,  5, 1,  0, 0}, // #470
  {DBGFIELD("WriteVecIMulYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #471
  {DBGFIELD("WriteVecIMulZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #472
  {DBGFIELD("WriteVecMaskedStoreY") 2, false, false, 1911, 4,  6, 1,  0, 0}, // #473
  {DBGFIELD("WriteVecMaskedLoadY") 2, false, false, 1915, 4,  6, 1,  0, 0}, // #474
  {DBGFIELD("WriteVecMaskedStore") 1, false, false, 1919, 4,  6, 1,  0, 0}, // #475
  {DBGFIELD("WriteVecMaskedLoad") 1, false, false, 1923, 4,  6, 1,  0, 0}, // #476
  {DBGFIELD("WriteVecMOVMSKY")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #477
  {DBGFIELD("WritePMULLDYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #478
  {DBGFIELD("WritePMULLDY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #479
  {DBGFIELD("WritePMULLDZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WritePMULLDZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #481
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 1711, 4,  5, 1,  5, 2}, // #482
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterLd_ReadAfterLd") 3, false, false, 1711, 4,  5, 1,  7, 2}, // #483
  {DBGFIELD("WriteVecShiftImmXLd") 1, false, false, 1691, 4,  6, 1,  0, 0}, // #484
  {DBGFIELD("WriteVecShiftImmYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #485
  {DBGFIELD("WriteVecShiftImmY")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #486
  {DBGFIELD("WriteVecShiftImmZLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteVecShiftImmZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #488
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #489
  {DBGFIELD("WriteVarVecShift")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #491
  {DBGFIELD("WriteVarVecShiftY")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #492
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #493
  {DBGFIELD("WriteVarVecShiftZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #494
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterLd") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #495
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD("WriteVarShuffleY")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #498
  {DBGFIELD("WriteVarShuffleZ")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #499
  {DBGFIELD("WriteShuffleZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #500
  {DBGFIELD("WriteVecShiftYLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #501
  {DBGFIELD("WriteVecShiftY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #502
  {DBGFIELD("WriteVecShiftZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #503
  {DBGFIELD("WriteVecShiftZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #504
  {DBGFIELD("WriteVecTestYLd_ReadAfterLd") 3, false, false, 1927, 7,  9, 1,  1, 1}, // #505
  {DBGFIELD("WriteVecTestY")      3, false, false, 1927, 5, 22, 1,  0, 0}, // #506
  {DBGFIELD("WriteFRcpXLd_ReadAfterLd") 1, false, false, 1731, 6,  5, 1,  1, 1}, // #507
  {DBGFIELD("WriteFRcpYLd_ReadAfterLd") 2, false, false, 1905, 6,  5, 1,  1, 1}, // #508
  {DBGFIELD("WriteFRcpY")         2, false, false, 1905, 4, 20, 1,  0, 0}, // #509
  {DBGFIELD("WriteFRcpZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #510
  {DBGFIELD("WriteFRcpZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #511
  {DBGFIELD("WriteFRcpYLd")       2, false, false, 1905, 6,  5, 1,  0, 0}, // #512
  {DBGFIELD("WriteFRndYLd")       2, false, false, 1843, 5, 10, 1,  0, 0}, // #513
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterLd") 1, false, false, 1731, 6,  5, 1,  1, 1}, // #514
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterLd") 2, false, false, 1905, 6,  5, 1,  1, 1}, // #515
  {DBGFIELD("WriteFRsqrtY")       2, false, false, 1905, 4, 20, 1,  0, 0}, // #516
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #517
  {DBGFIELD("WriteFRsqrtZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #518
  {DBGFIELD("WriteFRsqrtYLd")     2, false, false, 1905, 6,  5, 1,  0, 0}, // #519
  {DBGFIELD("WriteFShuffleYLd_ReadAfterLd") 2, false, false, 1835, 4,  6, 1,  1, 1}, // #520
  {DBGFIELD("WriteFShuffleZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #521
  {DBGFIELD("WriteFSqrt64YLd")    2, false, false, 1934, 6, 43, 1,  0, 0}, // #522
  {DBGFIELD("WriteFSqrt64Y")      2, false, false, 1934, 4, 93, 1,  0, 0}, // #523
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterLd") 1, false, false, 1817, 6, 38, 1,  1, 1}, // #524
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterLd") 2, false, false, 1934, 6, 43, 1,  1, 1}, // #525
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #526
  {DBGFIELD("WriteFSqrt64Z")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #527
  {DBGFIELD("WriteFSqrtYLd")      2, false, false, 1940, 6, 94, 1,  0, 0}, // #528
  {DBGFIELD("WriteFSqrtY")        2, false, false, 1940, 4, 75, 1,  0, 0}, // #529
  {DBGFIELD("WriteFSqrtXLd_ReadAfterLd") 1, false, false, 1823, 6, 35, 1,  1, 1}, // #530
  {DBGFIELD("WriteFSqrtYLd_ReadAfterLd") 2, false, false, 1940, 6, 94, 1,  1, 1}, // #531
  {DBGFIELD("WriteFSqrtZLd_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #532
  {DBGFIELD("WriteFSqrtZ")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WriteFTestYLd_ReadAfterLd") 3, false, false, 1927, 7,  9, 1,  1, 1}, // #534
  {DBGFIELD("WriteFTestY")        3, false, false, 1927, 5, 22, 1,  0, 0}, // #535
  {DBGFIELD("WriteFTestLd_ReadAfterLd") 1, false, false, 1618, 8, 10, 1,  1, 1}, // #536
  {DBGFIELD("WriteFTest")         1, false, false, 1618, 6, 21, 1,  0, 0}, // #537
  {DBGFIELD("MUL16m_IMUL16m")     2, false, false, 1695, 5,  6, 1,  3, 2}, // #538
  {DBGFIELD("MUL32r_IMUL32r")     2, false, false, 1700, 3, 21, 1,  0, 0}, // #539
  {DBGFIELD("IMUL64rri8_IMUL64rri32") 2, false, false, 1708, 3,  6, 1,  0, 0}, // #540
  {DBGFIELD("IMUL64rmi8_IMUL64rmi32") 2, false, false, 1703, 5,  9, 1,  0, 0}, // #541
  {DBGFIELD("COPY")               1, false, false,  1, 1,  1, 1,  0, 0}, // #542
  {DBGFIELD("FXAM")               1, false, false,  1, 1,  4, 1,  0, 0}, // #543
  {DBGFIELD("LD_Frr")             1, false, false,  1, 1,  1, 1,  0, 0}, // #544
  {DBGFIELD("MOVSX64rr32")        1, false, false,  1, 1,  1, 1,  0, 0}, // #545
  {DBGFIELD("RCL16m1_RCL16mCL_RCL16mi_RCL32m1_RCL32mCL_RCL32mi_RCL64m1_RCL64mCL_RCL64mi_RCL8m1_RCL8mCL_RCL8mi_RCR16m1_RCR16mCL_RCR16mi_RCR32m1_RCR32mCL_RCR32mi_RCR64m1_RCR64mCL_RCR64mi_RCR8m1_RCR8mCL_RCR8mi_ROL16m1_ROL16mCL_ROL16mi_ROL32m1_ROL32mCL_ROL32mi_ROL64m1_ROL64mCL_ROL64mi_ROL8m1_ROL8mCL_ROL8mi_ROR16m1_ROR16mCL_ROR16mi_ROR32m1_ROR32mCL_ROR32mi_ROR64m1_ROR64mCL_ROR64mi_ROR8m1_ROR8mCL_ROR8mi_SAR16m1_SAR16mCL_SAR16mi_SAR32m1_SAR32mCL_SAR32mi_SAR64m1_SAR64mCL_SAR64mi_SAR8m1_SAR8mCL_SAR8mi_SHL16m1_SHL16mCL_SHL16mi_SHL32m1_SHL32mCL_SHL32mi_SHL64m1_SHL64mCL_SHL64mi_SHL8m1_SHL8mCL_SHL8mi_SHR16m1_SHR16mCL_SHR16mi_SHR32m1_SHR32mCL_SHR32mi_SHR64m1_SHR64mCL_SHR64mi_SHR8m1_SHR8mCL_SHR8mi") 2, false, false, 1573, 4, 80, 2,  0, 0}, // #546
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false,  1, 1,  1, 1,  0, 0}, // #547
  {DBGFIELD("IMUL32rm")           2, false, false, 1695, 5,  6, 1,  1, 1}, // #548
  {DBGFIELD("IMUL32rmi_IMUL32rmi8") 2, false, false, 1695, 5,  6, 1,  0, 0}, // #549
  {DBGFIELD("IMUL32rr_IMUL32rri_IMUL32rri8") 2, false, false, 1700, 3, 21, 1,  0, 0}, // #550
  {DBGFIELD("FCOMPP")             1, false, false,  1, 1,  4, 1,  0, 0}, // #551
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, 1618, 6, 21, 1,  0, 0}, // #552
  {DBGFIELD("BT16ri8_BT16rr_BT32ri8_BT32rr_BT64ri8_BT64rr_BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #553
  {DBGFIELD("MMX_CVTPI2PSirr")    1, false, false, 1631, 3, 21, 1,  0, 0}, // #554
  {DBGFIELD("MMX_CVTPI2PSirm")    1, false, false, 1626, 5, 10, 1,  0, 0}, // #555
  {DBGFIELD("MMX_CVTPS2PIirr_MMX_CVTTPS2PIirr") 1, false, false, 1631, 3, 21, 1,  0, 0}, // #556
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, 226, 2,  7, 1,  0, 0}, // #557
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, 603, 2,  1, 1,  0, 0}, // #558
  {DBGFIELD("XCH_F")              1, false, false,  1, 1,  1, 1,  0, 0}, // #559
  {DBGFIELD("RETIL_RETIQ_RETIW_IRET_IRET16_IRET32_IRET64") 1, false, false, 225, 3, 22, 1,  0, 0}, // #560
  {DBGFIELD("MMX_CVTPS2PIirm_MMX_CVTTPS2PIirm") 1, false, false, 1626, 5, 10, 1,  0, 0}, // #561
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 1, false, false, 226, 2,  7, 1,  0, 0}, // #562
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 1, false, false,  1, 1,  4, 1,  0, 0}, // #563
  {DBGFIELD("LFENCE")             1, false, false, 603, 2,  1, 1,  0, 0}, // #564
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, 1582, 2,  1, 1,  0, 0}, // #565
  {DBGFIELD("PSLLDQri_PSRLDQri")  1, false, false, 1571, 2,  1, 1,  0, 0}, // #566
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr_MMX_PUNPCKHBWirr_MMX_PUNPCKHDQirr_MMX_PUNPCKHWDirr") 1, false, false, 1571, 2,  1, 1,  0, 0}, // #567
  {DBGFIELD("LEAVE_LEAVE64")      1, false, false,  1, 1,  1, 1,  0, 0}, // #568
  {DBGFIELD("POP16r")             1, false, false, 226, 2,  7, 1,  0, 0}, // #569
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 1, false, false, 603, 2,  1, 1,  0, 0}, // #570
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false,  1, 1,  4, 1,  0, 0}, // #571
  {DBGFIELD("BTC16mi8_BTC32mi8_BTC64mi8_BTR16mi8_BTR32mi8_BTR64mi8_BTS16mi8_BTS32mi8_BTS64mi8") 2, false, false, 1573, 4, 80, 2,  0, 0}, // #572
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false,  1, 1,  4, 1,  0, 0}, // #573
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr_XCHG16ar_XCHG16rr_XCHG32ar_XCHG32rr_XCHG64ar_XCHG64rr_XCHG8rr_MOVSX16rr8_MOVZX16rr8") 1, false, false,  1, 1,  1, 1,  0, 0}, // #574
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, 603, 2,  1, 1,  0, 0}, // #575
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false,  1, 1,  1, 1,  0, 0}, // #576
  {DBGFIELD("MMX_PADDQirr_MMX_PSUBQirr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #577
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 1, false, false, 1577, 5,  1, 1,  0, 0}, // #578
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  1, false, false, 1577, 5,  1, 1,  0, 0}, // #579
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, 1571, 2,  1, 1,  0, 0}, // #580
  {DBGFIELD("CLD")                1, false, false,  1, 1,  1, 1,  0, 0}, // #581
  {DBGFIELD("LDDQUrm")            1, false, false, 1691, 4,  7, 1,  0, 0}, // #582
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false,  1, 1,  4, 1,  0, 0}, // #583
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 1, false, false, 603, 2,  1, 1,  0, 0}, // #584
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 2, false, false, 1573, 4, 80, 2,  0, 0}, // #585
  {DBGFIELD("PHADDDrr_PHSUBDrr")  1, false, false, 1571, 2,  1, 1,  0, 0}, // #586
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, 225, 3, 22, 1,  0, 0}, // #587
  {DBGFIELD("MMX_PADDQirm_MMX_PSUBQirm") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #588
  {DBGFIELD("MOVDQUrm")           1, false, false, 1691, 4,  7, 1,  0, 0}, // #589
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, 1582, 4,  7, 1,  0, 0}, // #590
  {DBGFIELD("PADDQrm_PSUBQrm")    1, false, false, 1691, 4,  6, 1,  1, 1}, // #591
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false,  1, 1,  1, 1,  0, 0}, // #592
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   1, false, false,  1, 1,  1, 1,  0, 0}, // #593
  {DBGFIELD("LD_F80m")            1, false, false, 226, 2,  7, 1,  0, 0}, // #594
  {DBGFIELD("PHADDDrm_PHSUBDrm")  1, false, false, 1691, 4,  6, 1,  1, 1}, // #595
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 1, false, false, 1618, 6, 21, 1,  0, 0}, // #596
  {DBGFIELD("FLDCW16m")           1, false, false, 226, 2,  7, 1,  0, 0}, // #597
  {DBGFIELD("ST_FP80m")           1, false, false, 603, 2,  1, 1,  0, 0}, // #598
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 1, false, false, 1571, 2,  1, 1,  0, 0}, // #599
  {DBGFIELD("CMPXCHG8rm")         2, false, false, 1573, 4, 80, 2,  0, 0}, // #600
  {DBGFIELD("INTO")               1, false, false,  1, 1,  4, 1,  0, 0}, // #601
  {DBGFIELD("XLAT")               1, false, false, 226, 2,  7, 1,  0, 0}, // #602
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 7, false, false, 14, 1, 22, 1,  0, 0}, // #603
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 6, false, false,  9, 1, 21, 1,  0, 0}, // #604
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 8, false, false, 1814, 3,  9, 1,  0, 0}, // #605
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 8, false, false, 1814, 3,  9, 1,  0, 0}, // #606
  {DBGFIELD("IMUL16rr_IMUL16rri_IMUL16rri8") 2, false, false, 1700, 3, 21, 1,  0, 0}, // #607
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 1, false, false, 603, 2,  1, 1,  0, 0}, // #608
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #609
  {DBGFIELD("AAD8i8")             1, false, false,  1, 1,  4, 1,  0, 0}, // #610
  {DBGFIELD("LOOPE")              1, false, false,  1, 1,  1, 1,  0, 0}, // #611
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, 603, 2,  1, 1,  0, 0}, // #612
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 7, false, false, 14, 1, 22, 1,  0, 0}, // #613
  {DBGFIELD("FNSTCW16m")          1, false, false,  1, 1,  1, 1,  0, 0}, // #614
  {DBGFIELD("BT16mr_BT32mr_BT64mr") 1, false, false, 225, 3, 22, 1,  0, 0}, // #615
  {DBGFIELD("POPA16_POPA32")      1, false, false, 226, 2,  7, 1,  0, 0}, // #616
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, 603, 2,  1, 1,  0, 0}, // #617
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 8, false, false, 1814, 3,  9, 1,  0, 0}, // #618
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 8, false, false, 1814, 3,  9, 1,  0, 0}, // #619
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 6, false, false,  9, 1, 21, 1,  0, 0}, // #620
  {DBGFIELD("CMPXCHG8rr")         1, false, false,  1, 1,  1, 1,  0, 0}, // #621
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80_COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 1618, 6, 21, 1,  0, 0}, // #622
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_CVTTSS2SI64rr_Int") 2, false, false, 1643, 7,  5, 1,  0, 0}, // #623
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int") 1, false, false, 1618, 8, 10, 1,  1, 1}, // #624
  {DBGFIELD("CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 2, false, false, 1634, 9, 19, 1,  0, 0}, // #625
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false,  1, 1,  4, 1,  0, 0}, // #626
  {DBGFIELD("BTC16mr_BTC32mr_BTC64mr_BTR16mr_BTR32mr_BTR64mr_BTS16mr_BTS32mr_BTS64mr") 2, false, false, 1573, 4, 80, 2,  0, 0}, // #627
  {DBGFIELD("AAA_AAS")            1, false, false,  1, 1,  4, 1,  0, 0}, // #628
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 2, false, false, 1573, 4, 80, 2,  0, 0}, // #629
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #630
  {DBGFIELD("LOOPNE")             1, false, false,  1, 1,  1, 1,  0, 0}, // #631
  {DBGFIELD("PAUSE")              1, false, false,  1, 1,  1, 1,  0, 0}, // #632
  {DBGFIELD("CMPXCHG8B")          2, false, false, 1573, 4, 80, 2,  0, 0}, // #633
  {DBGFIELD("DAA")                1, false, false,  1, 1,  4, 1,  0, 0}, // #634
  {DBGFIELD("LOOP")               1, false, false,  1, 1,  1, 1,  0, 0}, // #635
  {DBGFIELD("DAS")                1, false, false,  1, 1,  4, 1,  0, 0}, // #636
  {DBGFIELD("AAM8i8")             1, false, false,  1, 1,  4, 1,  0, 0}, // #637
  {DBGFIELD("STD")                1, false, false,  1, 1,  1, 1,  0, 0}, // #638
  {DBGFIELD("CMPXCHG16B")         2, false, false, 1573, 4, 80, 2,  0, 0}, // #639
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false,  1, 1,  4, 1,  0, 0}, // #640
  {DBGFIELD("FNCLEX_FXTRACT")     1, false, false,  1, 1,  4, 1,  0, 0}, // #641
  {DBGFIELD("POPF32_POPF64")      1, false, false, 226, 2,  7, 1,  0, 0}, // #642
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false,  1, 1,  4, 1,  0, 0}, // #643
  {DBGFIELD("RDTSC_RDTSCP")       1, false, false,  1, 1,  4, 1,  0, 0}, // #644
  {DBGFIELD("ENTER")              1, false, false,  1, 1,  4, 1,  0, 0}, // #645
  {DBGFIELD("POPF16")             1, false, false, 226, 2,  7, 1,  0, 0}, // #646
  {DBGFIELD("MONITORrrr")         1, false, false,  1, 1,  4, 1,  0, 0}, // #647
  {DBGFIELD("FRNDINT")            1, false, false,  1, 1,  4, 1,  0, 0}, // #648
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false,  1, 1,  4, 1,  0, 0}, // #649
  {DBGFIELD("POPSS16_POPSS32")    1, false, false,  1, 1,  4, 1,  0, 0}, // #650
  {DBGFIELD("FPREM")              1, false, false,  1, 1,  4, 1,  0, 0}, // #651
  {DBGFIELD("INSB_INSL_INSW")     1, false, false,  1, 1,  4, 1,  0, 0}, // #652
  {DBGFIELD("FNINIT")             1, false, false,  1, 1,  4, 1,  0, 0}, // #653
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 1, false, false,  1, 1,  4, 1,  0, 0}, // #654
  {DBGFIELD("FPREM1")             1, false, false,  1, 1,  4, 1,  0, 0}, // #655
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false,  1, 1,  4, 1,  0, 0}, // #656
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 1, false, false,  1, 1,  4, 1,  0, 0}, // #657
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false,  1, 1,  4, 1,  0, 0}, // #658
  {DBGFIELD("FSCALE")             1, false, false,  1, 1,  4, 1,  0, 0}, // #659
  {DBGFIELD("RDMSR")              1, false, false,  1, 1,  4, 1,  0, 0}, // #660
  {DBGFIELD("RET_RETL_RETQ_RETW_LRETIL_LRETIQ_LRETIW_LRETL_LRETQ_LRETW") 1, false, false, 225, 3, 22, 1,  0, 0}, // #661
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 1, false, false,  1, 1,  4, 1,  0, 0}, // #662
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 1, false, false,  1, 1,  4, 1,  0, 0}, // #663
  {DBGFIELD("F2XM1")              1, false, false,  1, 1,  4, 1,  0, 0}, // #664
  {DBGFIELD("CPUID")              1, false, false,  1, 1,  4, 1,  0, 0}, // #665
  {DBGFIELD("INT")                1, false, false,  1, 1,  4, 1,  0, 0}, // #666
  {DBGFIELD("INT3")               1, false, false,  1, 1,  4, 1,  0, 0}, // #667
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false,  1, 1,  4, 1,  0, 0}, // #668
  {DBGFIELD("FXRSTOR_FXRSTOR64")  1, false, false,  1, 1,  4, 1,  0, 0}, // #669
  {DBGFIELD("FYL2X")              1, false, false,  1, 1,  4, 1,  0, 0}, // #670
  {DBGFIELD("FYL2XP1")            1, false, false,  1, 1,  4, 1,  0, 0}, // #671
  {DBGFIELD("FPTAN")              1, false, false,  1, 1,  4, 1,  0, 0}, // #672
  {DBGFIELD("FSINCOS")            1, false, false,  1, 1,  4, 1,  0, 0}, // #673
  {DBGFIELD("COS_F_COS_Fp32_COS_Fp64_COS_Fp80_SIN_F_SIN_Fp32_SIN_Fp64_SIN_Fp80") 1, false, false,  1, 1,  4, 1,  0, 0}, // #674
  {DBGFIELD("FPATAN")             1, false, false,  1, 1,  4, 1,  0, 0}, // #675
  {DBGFIELD("WRMSR")              1, false, false,  1, 1,  4, 1,  0, 0}, // #676
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, 1618, 6, 21, 1,  0, 0}, // #677
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, 1618, 6, 21, 1,  0, 0}, // #678
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 1, false, false,  1, 1,  4, 1,  0, 0}, // #679
  {DBGFIELD("FNOP")               1, false, false,  1, 1,  1, 1,  0, 0}, // #680
  {DBGFIELD("RETQ")               1, false, false, 225, 3, 22, 1,  0, 0}, // #681
  {DBGFIELD("CDQ_CQO")            1, false, false,  1, 1,  1, 1,  0, 0}, // #682
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, 1571, 2,  1, 1,  0, 0}, // #683
  {DBGFIELD("MMX_PADDQirr")       1, false, false, 1571, 2,  1, 1,  0, 0}, // #684
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, 1571, 2,  1, 1,  0, 0}, // #685
  {DBGFIELD("ROL16r1_ROL32r1_ROL64r1_ROL8r1_ROL16ri_ROL32ri_ROL64ri_ROL8ri_ROR16r1_ROR32r1_ROR64r1_ROR8r1_ROR16ri_ROR32ri_ROR64ri_ROR8ri") 1, false, false,  1, 1,  1, 1,  0, 0}, // #686
  {DBGFIELD("SETAr_SETBEr")       1, false, false,  1, 1,  1, 1,  0, 0}, // #687
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 1, false, false,  1, 1,  4, 1,  0, 0}, // #688
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 1618, 6, 21, 1,  0, 0}, // #689
  {DBGFIELD("VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 1, false, false, 1618, 6, 21, 1,  0, 0}, // #690
  {DBGFIELD("CWD")                1, false, false,  1, 1,  1, 1,  0, 0}, // #691
  {DBGFIELD("FNSTSW16r")          1, false, false,  1, 1,  1, 1,  0, 0}, // #692
  {DBGFIELD("MMX_MOVDQ2Qrr")      1, false, false, 1571, 2,  1, 1,  0, 0}, // #693
  {DBGFIELD("PUSHFS64")           1, false, false,  1, 1,  4, 1,  0, 0}, // #694
  {DBGFIELD("IMUL16rri_IMUL16rri8") 2, false, false, 1700, 3, 21, 1,  0, 0}, // #695
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 1, false, false, 1618, 6, 21, 1,  0, 0}, // #696
  {DBGFIELD("ROL16rCL_ROL32rCL_ROL64rCL_ROL8rCL_ROR16rCL_ROR32rCL_ROR64rCL_ROR8rCL_SAR16rCL_SAR32rCL_SAR64rCL_SAR8rCL_SHL16rCL_SHL32rCL_SHL64rCL_SHL8rCL_SHR16rCL_SHR32rCL_SHR64rCL_SHR8rCL") 1, false, false,  1, 1,  1, 1,  0, 0}, // #697
  {DBGFIELD("XADD8rr_XADD16rr_XADD32rr_XADD64rr_XCHG8rr_XCHG16rr_XCHG32rr_XCHG64rr_XCHG16ar_XCHG32ar_XCHG64ar") 1, false, false,  1, 1,  1, 1,  0, 0}, // #698
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, 1618, 6, 21, 1,  0, 0}, // #699
  {DBGFIELD("IMUL64r_MUL64r")     2, false, false, 1708, 3,  6, 1,  0, 0}, // #700
  {DBGFIELD("IMUL16r_MUL16r")     2, false, false, 1700, 3, 21, 1,  0, 0}, // #701
  {DBGFIELD("MOV64sr")            1, false, false,  1, 1,  1, 1,  0, 0}, // #702
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #703
  {DBGFIELD("MOVSX16rm16_MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVSX64rm16_MOVSX64rm32_MOVSX64rm8_MOVZX16rm16_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX_MOVZX64rm16_MOVZX64rm8") 1, false, false, 225, 3, 22, 1,  0, 0}, // #704
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 1, false, false, 603, 2,  1, 1,  0, 0}, // #705
  {DBGFIELD("CLI")                1, false, false,  1, 1,  4, 1,  0, 0}, // #706
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 1, false, false, 603, 2,  1, 1,  0, 0}, // #707
  {DBGFIELD("PUSHGS64")           1, false, false,  1, 1,  4, 1,  0, 0}, // #708
  {DBGFIELD("CALL64pcrel32")      1, false, false,  1, 1,  1, 1,  0, 0}, // #709
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 1, false, false,  1, 1,  1, 1,  0, 0}, // #710
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 1, false, false, 1577, 5, 21, 1,  0, 0}, // #711
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 1, false, false,  1, 1,  4, 1,  0, 0}, // #712
  {DBGFIELD("SETAm_SETBEm")       1, false, false, 1811, 3,  1, 1,  0, 0}, // #713
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 1, false, false, 1577, 5, 21, 1,  0, 0}, // #714
  {DBGFIELD("PUSHF16_PUSHF64")    1, false, false, 603, 2,  1, 1,  0, 0}, // #715
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 1, false, false, 226, 2,  7, 1,  0, 0}, // #716
  {DBGFIELD("MMX_MOVD64from64rm") 1, false, false, 1577, 5, 20, 1,  0, 0}, // #717
  {DBGFIELD("VBROADCASTSSrm_MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 1582, 4,  6, 1,  0, 0}, // #718
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, 1691, 4,  7, 1,  0, 0}, // #719
  {DBGFIELD("MOVSDrm_VMOVSDrm_MOVSSrm_VMOVSSrm") 1, false, false, 1582, 4,  7, 1,  0, 0}, // #720
  {DBGFIELD("MOV16sm")            1, false, false,  1, 1,  1, 1,  0, 0}, // #721
  {DBGFIELD("BT16mi8_BT32mi8_BT64mi8") 1, false, false,  1, 1,  1, 1,  0, 0}, // #722
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 1, false, false, 1691, 4,  6, 1,  0, 0}, // #723
  {DBGFIELD("MMX_PALIGNRrmi")     1, false, false, 1691, 4,  6, 1,  1, 1}, // #724
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #725
  {DBGFIELD("LODSL_LODSQ")        1, false, false,  1, 1,  4, 1,  0, 0}, // #726
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 2, false, false, 1946, 4,  6, 1,  1, 1}, // #727
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 2, false, false, 1835, 4,  6, 1,  0, 0}, // #728
  {DBGFIELD("VINSERTF128rm")      1, false, false, 1582, 4,  6, 1,  1, 1}, // #729
  {DBGFIELD("MMX_PADDQirm")       1, false, false, 1691, 4,  6, 1,  1, 1}, // #730
  {DBGFIELD("VERRm_VERWm")        1, false, false,  1, 1,  4, 1,  0, 0}, // #731
  {DBGFIELD("FARJMP64")           1, false, false,  1, 1,  1, 1,  0, 0}, // #732
  {DBGFIELD("FNSTSWm")            1, false, false,  1, 1,  4, 1,  0, 0}, // #733
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 1, false, false,  1, 1,  4, 1,  0, 0}, // #734
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 1, false, false, 225, 3, 22, 1,  0, 0}, // #735
  {DBGFIELD("CALL64m_CALL64m_NT") 1, false, false,  1, 1,  1, 1,  0, 0}, // #736
  {DBGFIELD("SAR16m1_SAR32m1_SAR64m1_SAR8m1_SAR16mi_SAR32mi_SAR64mi_SAR8mi_SHL16m1_SHL32m1_SHL64m1_SHL8m1_SHL16mi_SHL32mi_SHL64mi_SHL8mi_SHR16m1_SHR32m1_SHR64m1_SHR8m1_SHR16mi_SHR32mi_SHR64mi_SHR8mi") 2, false, false, 1573, 4, 80, 2,  0, 0}, // #737
  {DBGFIELD("VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 1, false, false, 1618, 8, 10, 1,  1, 1}, // #738
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false,  1, 1,  4, 1,  0, 0}, // #739
  {DBGFIELD("ROL16m1_ROL32m1_ROL64m1_ROL8m1_ROL16mi_ROL32mi_ROL64mi_ROL8mi_ROR16m1_ROR32m1_ROR64m1_ROR8m1_ROR16mi_ROR32mi_ROR64mi_ROR8mi") 2, false, false, 1573, 4, 80, 2,  0, 0}, // #740
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 2, false, false, 1573, 4, 80, 2,  0, 0}, // #741
  {DBGFIELD("FARCALL64")          1, false, false,  1, 1,  1, 1,  0, 0}, // #742
  {DBGFIELD("CVTSD2SI64rm_Int_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int") 2, false, false, 1634, 9, 19, 1,  0, 0}, // #743
  {DBGFIELD("CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int") 2, false, false, 1634, 9, 19, 1,  0, 0}, // #744
  {DBGFIELD("IMUL64m_MUL64m")     2, false, false, 1703, 5,  9, 1,  3, 2}, // #745
  {DBGFIELD("IMUL32m_MUL32m")     2, false, false, 1695, 5,  6, 1,  3, 2}, // #746
  {DBGFIELD("IMUL16rmi_IMUL16rmi8") 2, false, false, 1695, 5,  6, 1,  0, 0}, // #747
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, 226, 2,  7, 1,  0, 0}, // #748
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL_SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 2, false, false, 1573, 4, 80, 2,  0, 0}, // #749
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 2, false, false, 1590, 4,  7, 1,  0, 0}, // #750
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 1, false, false, 1597, 6, 10, 1,  0, 0}, // #751
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #752
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 1, false, false, 1618, 8, 10, 1,  0, 0}, // #753
  {DBGFIELD("MUL_F32m_MUL_F64m")  1, false, false, 1731, 6,  5, 1,  0, 0}, // #754
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 1, false, false, 1597, 6, 10, 1,  0, 0}, // #755
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 1, false, false, 1731, 6,  5, 1,  0, 0}, // #756
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 1, false, false, 1678, 6, 72, 1,  0, 0}, // #757
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 1, false, false, 1678, 6, 72, 1,  0, 0}, // #758
  {DBGFIELD("CLC")                1, false, false,  1, 1,  1, 1,  0, 0}, // #759
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 1, false, false, 1582, 4,  6, 1,  1, 1}, // #760
  {DBGFIELD("DIV8r")              1, false, false, 1673, 3, 19, 1,  0, 0}, // #761
  {DBGFIELD("IDIV8r")             1, false, false, 1673, 3, 19, 1,  0, 0}, // #762
  {DBGFIELD("RETIL_RETIQ_RETIW")  1, false, false, 225, 3, 22, 1,  0, 0}, // #763
  {DBGFIELD("LRETIL_LRETIQ_LRETIW") 1, false, false, 225, 3, 22, 1,  0, 0}, // #764
  {DBGFIELD("RDPMC")              1, false, false,  1, 1,  4, 1,  0, 0}, // #765
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false,  1, 1,  4, 1,  0, 0}, // #766
  {DBGFIELD("FBLDm")              1, false, false,  1, 1,  4, 1,  0, 0}, // #767
  {DBGFIELD("FFREE_FFREEP")       1, false, false,  1, 1,  4, 1,  0, 0}, // #768
  {DBGFIELD("FSAVEm")             1, false, false,  1, 1,  4, 1,  0, 0}, // #769
  {DBGFIELD("FRSTORm")            1, false, false,  1, 1,  4, 1,  0, 0}, // #770
  {DBGFIELD("FXTRACT")            1, false, false,  1, 1,  4, 1,  0, 0}, // #771
  {DBGFIELD("VBROADCASTSSrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 1582, 4,  6, 1,  0, 0}, // #772
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, 1691, 4,  6, 1,  0, 0}, // #773
  {DBGFIELD("VBROADCASTF128")     1, false, false, 1582, 4,  6, 1,  0, 0}, // #774
  {DBGFIELD("VBROADCASTI128")     1, false, false, 1691, 4,  6, 1,  0, 0}, // #775
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, 1691, 4,  6, 1,  0, 0}, // #776
  {DBGFIELD("FBSTPm")             1, false, false,  1, 1,  4, 1,  0, 0}, // #777
  {DBGFIELD("ST_FP32m_ST_FP64m")  1, false, false, 603, 2,  1, 1,  0, 0}, // #778
  {DBGFIELD("VMPTRSTm")           1, false, false,  1, 1,  4, 1,  0, 0}, // #779
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #780
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #781
  {DBGFIELD("MMX_MOVQ2DQrr")      1, false, false, 1571, 2,  1, 1,  0, 0}, // #782
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT") 1, false, false,  1, 1,  1, 1,  0, 0}, // #783
  {DBGFIELD("FINCSTP")            1, false, false,  1, 1,  4, 1,  0, 0}, // #784
  {DBGFIELD("ANDN32rr_ANDN64rr_BLSI32rr_BLSI64rr_BLSMSK32rr_BLSMSK64rr_BLSR32rr_BLSR64rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #785
  {DBGFIELD("VPBLENDDYrri")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #786
  {DBGFIELD("VPBLENDDrri")        1, false, false, 1571, 2,  1, 1,  0, 0}, // #787
  {DBGFIELD("CMC_STC")            1, false, false,  1, 1,  1, 1,  0, 0}, // #788
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false,  1, 1,  4, 1,  0, 0}, // #789
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 1, false, false, 1626, 5,  5, 1,  0, 0}, // #790
  {DBGFIELD("CVTSS2SDrm")         2, false, false, 1650, 5, 19, 1,  0, 0}, // #791
  {DBGFIELD("CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 2, false, false, 1650, 5, 19, 1,  1, 1}, // #792
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #793
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #794
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 1, false, false, 225, 3, 22, 1,  1, 1}, // #795
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 1, false, false, 1691, 4,  6, 1,  0, 0}, // #796
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #797
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT") 1, false, false, 225, 3, 22, 1,  0, 0}, // #798
  {DBGFIELD("ANDN32rm_ANDN64rm")  1, false, false, 225, 3, 22, 1,  1, 1}, // #799
  {DBGFIELD("BLSI32rm_BLSI64rm_BLSMSK32rm_BLSMSK64rm_BLSR32rm_BLSR64rm_MOVBE16rm_MOVBE32rm_MOVBE64rm") 1, false, false, 225, 3, 22, 1,  0, 0}, // #800
  {DBGFIELD("VINSERTI128rm")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #801
  {DBGFIELD("VPBLENDDrmi")        1, false, false, 1691, 4,  6, 1,  1, 1}, // #802
  {DBGFIELD("VPBLENDDYrmi")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #803
  {DBGFIELD("POP32r_POP64r")      1, false, false, 226, 2,  7, 1,  0, 0}, // #804
  {DBGFIELD("SFENCE")             1, false, false, 603, 2,  1, 1,  0, 0}, // #805
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 1, false, false, 603, 2,  1, 1,  0, 0}, // #806
  {DBGFIELD("MOVBE16mr")          1, false, false, 603, 2,  1, 1,  0, 0}, // #807
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r") 1, false, false, 603, 2,  1, 1,  0, 0}, // #808
  {DBGFIELD("MFENCE")             1, false, false, 603, 2,  1, 1,  0, 0}, // #809
  {DBGFIELD("XGETBV")             1, false, false,  1, 1,  4, 1,  0, 0}, // #810
  {DBGFIELD("CVTPS2PDrr_VCVTPS2PDrr") 1, false, false, 1631, 3, 20, 1,  0, 0}, // #811
  {DBGFIELD("CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 2, false, false, 1655, 3,  5, 1,  0, 0}, // #812
  {DBGFIELD("MMX_PACKSSDWirm_MMX_PACKSSWBirm_MMX_PACKUSWBirm") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #813
  {DBGFIELD("LRETQ_RETL")         1, false, false, 225, 3, 22, 1,  0, 0}, // #814
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #815
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, 1631, 3, 21, 1,  0, 0}, // #816
  {DBGFIELD("VCVTDQ2PSYrr")       2, false, false, 1848, 3, 21, 1,  0, 0}, // #817
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, 1571, 2,  1, 1,  0, 0}, // #818
  {DBGFIELD("CVTPS2DQrm_VCVTPS2DQrm_CVTTPS2DQrm_VCVTTPS2DQrm") 1, false, false, 1626, 5, 10, 1,  0, 0}, // #819
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, 1843, 5, 10, 1,  0, 0}, // #820
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm") 2, false, false, 1843, 5, 10, 1,  0, 0}, // #821
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #822
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr") 1, false, false, 1571, 2,  1, 1,  0, 0}, // #823
  {DBGFIELD("CLDEMOTE")           1, false, false, 226, 2,  7, 1,  0, 0}, // #824
  {DBGFIELD("RCL16r1_RCL32r1_RCL64r1_RCL8r1_RCL16ri_RCL32ri_RCL64ri_RCL8ri_RCR16r1_RCR32r1_RCR64r1_RCR8r1_RCR16ri_RCR32ri_RCR64ri_RCR8ri") 1, false, false,  1, 1,  1, 1,  0, 0}, // #825
  {DBGFIELD("RCL16m1_RCL32m1_RCL64m1_RCL8m1_RCL16mi_RCL32mi_RCL64mi_RCL8mi_RCR16m1_RCR32m1_RCR64m1_RCR8m1_RCR16mi_RCR32mi_RCR64mi_RCR8mi") 2, false, false, 1573, 4, 80, 2,  0, 0}, // #826
  {DBGFIELD("ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 2, false, false, 1573, 4, 80, 2,  0, 0}, // #827
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_CVTTSD2SI64rr_Int_CVTTSD2SIrr_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, 1643, 7,  5, 1,  0, 0}, // #828
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int_CVTSS2SIrr_Int_CVTTSS2SIrr_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_VCVTTSS2SIrr_Int") 2, false, false, 1643, 7,  5, 1,  0, 0}, // #829
  {DBGFIELD("VCVTPS2PDYrr")       2, false, false, 1848, 3, 20, 1,  0, 0}, // #830
  {DBGFIELD("MMX_CVTPI2PDirr_CVTDQ2PDrr_VCVTDQ2PDrr") 1, false, false, 1631, 3, 21, 1,  0, 0}, // #831
  {DBGFIELD("MMX_CVTPD2PIirr_MMX_CVTTPD2PIirr_CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 1, false, false, 1631, 3, 21, 1,  0, 0}, // #832
  {DBGFIELD("CVTPD2PSrr_VCVTPD2PSrr") 1, false, false, 1631, 3, 21, 1,  0, 0}, // #833
  {DBGFIELD("CVTSD2SSrr_CVTSD2SSrr_Int_VCVTSD2SSrr_VCVTSD2SSrr_Int") 2, false, false, 1655, 3,  5, 1,  0, 0}, // #834
  {DBGFIELD("CVTSI2SDrr_CVTSI2SDrr_Int_CVTSI642SDrr_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, 1631, 3,  9, 1,  0, 0}, // #835
  {DBGFIELD("CVTSI2SSrr_CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int") 2, false, false, 1631, 3,  9, 1,  0, 0}, // #836
  {DBGFIELD("MULX64rr")           3, false, false, 1750, 3, 85, 2,  0, 0}, // #837
  {DBGFIELD("VCVTSD2SI64rm_Int_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 2, false, false, 1634, 9, 19, 1,  0, 0}, // #838
  {DBGFIELD("CVTSS2SI64rm_Int")   2, false, false, 1634, 9, 19, 1,  0, 0}, // #839
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 2, false, false, 1634, 9, 19, 1,  0, 0}, // #840
  {DBGFIELD("VCVTPS2PDYrm")       2, false, false, 1843, 5,  5, 1,  0, 0}, // #841
  {DBGFIELD("CVTPD2PSrm")         1, false, false, 1626, 5, 10, 1,  0, 0}, // #842
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_MMX_CVTPD2PIirm_MMX_CVTTPD2PIirm") 1, false, false, 1626, 5, 10, 1,  0, 0}, // #843
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 1, false, false, 1626, 5, 10, 1,  0, 0}, // #844
  {DBGFIELD("MMX_CVTPI2PDirm")    1, false, false, 1626, 5, 10, 1,  0, 0}, // #845
  {DBGFIELD("CVTSD2SSrm")         2, false, false, 1650, 5, 19, 1,  0, 0}, // #846
  {DBGFIELD("CVTSD2SSrm_Int_VCVTSD2SSrm_VCVTSD2SSrm_Int") 2, false, false, 1650, 5, 19, 1,  1, 1}, // #847
  {DBGFIELD("MULX64rm")           3, false, false, 1745, 5, 89, 2,  0, 0}, // #848
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 1, false, false, 1691, 4,  6, 1,  0, 0}, // #849
  {DBGFIELD("VZEROUPPER")         37, false, false,  0, 0, 40, 1,  0, 0}, // #850
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 1, false, false,  1, 1,  4, 1,  0, 0}, // #851
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 1, false, false,  1, 1,  4, 1,  0, 0}, // #852
  {DBGFIELD("VPCMPGTQYrr")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #853
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, 1586, 4, 20, 1,  0, 0}, // #854
  {DBGFIELD("VPCMPGTQYrm")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #855
  {DBGFIELD("CVTSI642SSrr_CVTSI642SSrr_Int_VCVTSI642SSrr_VCVTSI642SSrr_Int") 2, false, false, 1631, 3,  9, 1,  0, 0}, // #856
  {DBGFIELD("STR16r_STR32r_STR64r") 1, false, false,  1, 1,  4, 1,  0, 0}, // #857
  {DBGFIELD("MULX32rr")           3, false, false, 1742, 3, 87, 2,  0, 0}, // #858
  {DBGFIELD("MULX32rm")           3, false, false, 1737, 5, 85, 2,  0, 0}, // #859
  {DBGFIELD("XSETBV")             1, false, false,  1, 1,  4, 1,  0, 0}, // #860
  {DBGFIELD("VCVTDQ2PDYrr")       2, false, false, 1848, 3, 21, 1,  0, 0}, // #861
  {DBGFIELD("VCVTPD2PSYrr")       3, false, false, 1857, 4,  6, 1,  0, 0}, // #862
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 3, false, false, 1857, 4,  6, 1,  0, 0}, // #863
  {DBGFIELD("VCVTDQ2PDYrm")       2, false, false, 1843, 5, 10, 1,  0, 0}, // #864
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 2, false, false, 1573, 4, 80, 2,  0, 0}, // #865
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 1, false, false,  1, 1,  1, 1,  0, 0}, // #866
  {DBGFIELD("RCL8rCL")            1, false, false,  1, 1,  1, 1,  0, 0}, // #867
  {DBGFIELD("RCR8rCL")            1, false, false,  1, 1,  1, 1,  0, 0}, // #868
  {DBGFIELD("VZEROALL")           73, false, false,  0, 0, 95, 1,  0, 0}, // #869
  {DBGFIELD("RDTSC")              1, false, false,  1, 1,  4, 1,  0, 0}, // #870
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 1, false, false,  1, 1,  4, 1,  0, 0}, // #871
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, 1678, 4, 65, 1,  0, 0}, // #872
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 1, false, false, 1678, 6, 72, 1,  0, 0}, // #873
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 1, false, false, 1678, 6, 72, 1,  0, 0}, // #874
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, 1678, 4, 65, 1,  0, 0}, // #875
  {DBGFIELD("XSAVE64")            1, false, false,  1, 1,  4, 1,  0, 0}, // #876
  {DBGFIELD("XSAVE")              1, false, false,  1, 1,  4, 1,  0, 0}, // #877
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 1, false, false,  1, 1,  4, 1,  0, 0}, // #878
  {DBGFIELD("VMCLEARm")           1, false, false,  1, 1,  4, 1,  0, 0}, // #879
  {DBGFIELD("FLDENVm")            1, false, false,  1, 1,  4, 1,  0, 0}, // #880
  {DBGFIELD("FXRSTOR64")          1, false, false,  1, 1,  4, 1,  0, 0}, // #881
  {DBGFIELD("DIV16r")             2, false, false, 1658, 3, 28, 1,  0, 0}, // #882
  {DBGFIELD("DIV32r")             2, false, false, 1663, 3, 34, 1,  0, 0}, // #883
  {DBGFIELD("DIV64r")             2, false, false, 1668, 3, 84, 1,  0, 0}, // #884
  {DBGFIELD("IDIV16r")            2, false, false, 1658, 3, 28, 1,  0, 0}, // #885
  {DBGFIELD("IDIV32r")            2, false, false, 1663, 3, 34, 1,  0, 0}, // #886
  {DBGFIELD("IDIV64r")            2, false, false, 1668, 3, 84, 1,  0, 0}, // #887
  {DBGFIELD("FSTENVm")            1, false, false,  1, 1,  4, 1,  0, 0}, // #888
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm_VPGATHERDDrm") 1, false, false, 226, 2,  7, 1,  0, 0}, // #889
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 1, false, false, 226, 2,  7, 1,  0, 0}, // #890
  {DBGFIELD("VPGATHERQDYrm")      1, false, false, 226, 2,  7, 1,  0, 0}, // #891
  {DBGFIELD("VPGATHERQDrm")       1, false, false, 226, 2,  7, 1,  0, 0}, // #892
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 1, false, false, 226, 2,  7, 1,  0, 0}, // #893
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 1, false, false, 226, 2,  7, 1,  0, 0}, // #894
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 1, false, false, 226, 2,  7, 1,  0, 0}, // #895
  {DBGFIELD("VGATHERQPSYrm")      1, false, false, 226, 2,  7, 1,  0, 0}, // #896
  {DBGFIELD("VGATHERQPSrm_VGATHERDPSrm") 1, false, false, 226, 2,  7, 1,  0, 0}, // #897
  {DBGFIELD("ADC8i8_ADC8ri_ADC8ri8_SBB8i8_SBB8ri_SBB8ri8") 1, false, false,  3, 1,  1, 1,  0, 0}, // #898
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 1, false, false, 1618, 8, 10, 1,  0, 0}, // #899
  {DBGFIELD("LRETQ")              1, false, false, 225, 3, 22, 1,  0, 0}, // #900
  {DBGFIELD("CVTDQ2PSrm_VCVTDQ2PSrm") 1, false, false, 1626, 5, 10, 1,  0, 0}, // #901
  {DBGFIELD("POPF64")             1, false, false, 226, 2,  7, 1,  0, 0}, // #902
  {DBGFIELD("VGATHERQPDrm")       1, false, false, 226, 2,  7, 1,  0, 0}, // #903
  {DBGFIELD("VGATHERQPDYrm")      1, false, false, 226, 2,  7, 1,  0, 0}, // #904
  {DBGFIELD("VGATHERDPDrm")       1, false, false, 226, 2,  7, 1,  0, 0}, // #905
  {DBGFIELD("VGATHERDPSrm")       1, false, false, 226, 2,  7, 1,  0, 0}, // #906
  {DBGFIELD("VGATHERDPDYrm")      1, false, false, 226, 2,  7, 1,  0, 0}, // #907
  {DBGFIELD("VGATHERDPSYrm")      1, false, false, 226, 2,  7, 1,  0, 0}, // #908
  {DBGFIELD("DIV16m")             2, false, false, 1658, 5, 30, 1,  3, 2}, // #909
  {DBGFIELD("DIV32m")             2, false, false, 1663, 5, 82, 1,  3, 2}, // #910
  {DBGFIELD("DIV64m")             2, false, false, 1668, 5, 83, 1,  3, 2}, // #911
  {DBGFIELD("DIV8m")              1, false, false, 1673, 5, 24, 1,  3, 2}, // #912
  {DBGFIELD("IDIV16m")            2, false, false, 1658, 5, 30, 1,  3, 2}, // #913
  {DBGFIELD("IDIV32m")            2, false, false, 1663, 5, 82, 1,  3, 2}, // #914
  {DBGFIELD("IDIV64m")            2, false, false, 1668, 5, 83, 1,  3, 2}, // #915
  {DBGFIELD("IDIV8m")             1, false, false, 1673, 5, 24, 1,  3, 2}, // #916
  {DBGFIELD("MOV16rm")            1, false, false, 226, 2,  7, 1,  0, 0}, // #917
  {DBGFIELD("MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX") 1, false, false, 225, 3, 22, 1,  0, 0}, // #918
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 1, false, false,  1, 1,  1, 1,  0, 0}, // #919
  {DBGFIELD("POP16rmm")           1, false, false, 603, 2,  1, 1,  0, 0}, // #920
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 1, false, false, 603, 2,  1, 1,  0, 0}, // #921
  {DBGFIELD("PUSHF16")            1, false, false, 603, 2,  1, 1,  0, 0}, // #922
  {DBGFIELD("LAHF")               1, false, false,  1, 1,  1, 1,  0, 0}, // #923
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 1, false, false, 225, 3, 22, 1,  0, 0}, // #924
  {DBGFIELD("ADD16mi_ADD16mi8_ADD16mr_ADD32mi_ADD32mi8_ADD32mr_ADD64mi32_ADD64mi8_ADD64mr_ADD8mi_ADD8mi8_ADD8mr_SUB16mi_SUB16mi8_SUB16mr_SUB32mi_SUB32mi8_SUB32mr_SUB64mi32_SUB64mi8_SUB64mr_SUB8mi_SUB8mi8_SUB8mr") 2, false, false, 1573, 4,  7, 1,  0, 0}, // #925
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 2, false, false, 1590, 4,  7, 1,  0, 0}, // #926
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 2, false, false, 1573, 4,  7, 1,  0, 0}, // #927
  {DBGFIELD("IMUL16rm")           2, false, false, 1695, 5,  6, 1,  1, 1}, // #928
  {DBGFIELD("IMUL64rr")           2, false, false, 1708, 3,  6, 1,  0, 0}, // #929
  {DBGFIELD("IMUL64rm")           2, false, false, 1703, 5,  9, 1,  1, 1}, // #930
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 1, false, false,  1, 1,  1, 1,  0, 0}, // #931
  {DBGFIELD("RETW_LRETL_LRETW")   1, false, false, 225, 3, 22, 1,  0, 0}, // #932
  {DBGFIELD("IRET16_IRET32_IRET64") 1, false, false, 225, 3, 22, 1,  0, 0}, // #933
  {DBGFIELD("AND16mi_AND16mi8_AND16mr_AND32mi_AND32mi8_AND32mr_AND64mi32_AND64mi8_AND64mr_AND8mi_AND8mi8_AND8mr_OR16mi_OR16mi8_OR16mr_OR32mi_OR32mi8_OR32mr_OR64mi32_OR64mi8_OR64mr_OR8mi_OR8mi8_OR8mr_XOR16mi_XOR16mi8_XOR16mr_XOR32mi_XOR32mi8_XOR32mr_XOR64mi32_XOR64mi8_XOR64mr_XOR8mi_XOR8mi8_XOR8mr") 2, false, false, 1573, 4,  7, 1,  0, 0}, // #934
  {DBGFIELD("OR32mrLocked")       2, false, false, 1573, 4, 80, 2,  0, 0}, // #935
  {DBGFIELD("BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #936
  {DBGFIELD("BLSI32rr_BLSI64rr_BLSMSK32rr_BLSMSK64rr_BLSR32rr_BLSR64rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #937
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 8, false, false, 1814, 3,  9, 1,  0, 0}, // #938
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 7, false, false, 14, 1, 22, 1,  0, 0}, // #939
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 8, false, false, 1814, 3,  9, 1,  0, 0}, // #940
  {DBGFIELD("MOVSLDUPrm")         1, false, false, 1582, 4,  6, 1,  0, 0}, // #941
  {DBGFIELD("MOVSLDUPrr")         1, false, false, 1582, 2,  1, 1,  0, 0}, // #942
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, 1586, 4, 20, 1,  0, 0}, // #943
  {DBGFIELD("VPMOVSXBDYrr_VPMOVSXBQYrr_VPMOVSXBWYrr_VPMOVSXDQYrr_VPMOVSXWDYrr_VPMOVSXWQYrr_VPMOVZXBDYrr_VPMOVZXBQYrr_VPMOVZXBWYrr_VPMOVZXDQYrr_VPMOVZXWDYrr_VPMOVZXWQYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #944
  {DBGFIELD("VPMOVZXBDYrm_VPMOVZXBQYrm_VPMOVZXBWYrm_VPMOVZXDQYrm_VPMOVZXWQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #945
  {DBGFIELD("PBLENDWrri_VPBLENDWrri") 1, false, false, 1571, 2,  1, 1,  0, 0}, // #946
  {DBGFIELD("VPBLENDWYrri")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #947
  {DBGFIELD("PBLENDWrmi_VPBLENDWrmi") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #948
  {DBGFIELD("VPBLENDWYrmi")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #949
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, 1571, 2,  1, 1,  0, 0}, // #950
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 1, false, false, 1577, 5,  1, 1,  0, 0}, // #951
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 1, false, false, 1577, 5,  1, 1,  0, 0}, // #952
  {DBGFIELD("VPMASKMOVDYrm")      2, false, false, 1915, 4,  6, 1,  0, 0}, // #953
  {DBGFIELD("VPMASKMOVDrm")       1, false, false, 1923, 4,  6, 1,  0, 0}, // #954
  {DBGFIELD("VPMASKMOVDYmr_VPMASKMOVQYmr") 2, false, false, 1911, 4,  6, 1,  0, 0}, // #955
  {DBGFIELD("VPMASKMOVDmr_VPMASKMOVQmr") 1, false, false, 1919, 4,  6, 1,  0, 0}, // #956
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 1, false, false, 1691, 4,  6, 1,  0, 0}, // #957
  {DBGFIELD("VPSLLDQri_VPSRLDQri") 1, false, false, 1571, 2,  1, 1,  0, 0}, // #958
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #959
  {DBGFIELD("VPERM2F128rr")       1, false, false, 1582, 2,  1, 1,  0, 0}, // #960
  {DBGFIELD("VPERM2F128rm")       1, false, false, 1582, 4,  6, 1,  1, 1}, // #961
  {DBGFIELD("VEXTRACTF128rr")     1, false, false, 1582, 2,  1, 1,  0, 0}, // #962
  {DBGFIELD("VEXTRACTF128mr")     1, false, false, 1577, 5,  1, 1,  0, 0}, // #963
  {DBGFIELD("VINSERTF128rr")      1, false, false, 1582, 2,  1, 1,  0, 0}, // #964
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 1, false, false, 1631, 3, 21, 1,  0, 0}, // #965
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 1, false, false, 1631, 3, 21, 1,  0, 0}, // #966
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 1, false, false, 1626, 5, 10, 1,  0, 0}, // #967
  {DBGFIELD("VCVTPD2DQrm_VCVTTPD2DQrm") 1, false, false, 1626, 5, 10, 1,  0, 0}, // #968
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 3, false, false, 1851, 6, 26, 1,  0, 0}, // #969
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_VCVTTSS2SIrr_Int") 2, false, false, 1643, 7,  5, 1,  0, 0}, // #970
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 2, false, false, 1634, 9, 19, 1,  0, 0}, // #971
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, 1571, 2,  1, 1,  0, 0}, // #972
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, 1715, 2, 20, 1,  0, 0}, // #973
  {DBGFIELD("SHA256MSG2rm")       1, false, false, 1603, 5,  5, 1,  1, 1}, // #974
  {DBGFIELD("SHA256MSG2rr")       1, false, false, 1608, 3, 20, 1,  0, 0}, // #975
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, 1608, 3, 20, 1,  0, 0}, // #976
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 1, false, false, 1603, 5,  5, 1,  1, 1}, // #977
  {DBGFIELD("SHA1MSG2rr")         1, false, false, 1608, 3, 20, 1,  0, 0}, // #978
  {DBGFIELD("SHA1MSG2rm")         1, false, false, 1603, 5,  5, 1,  1, 1}, // #979
  {DBGFIELD("SHA1NEXTErr")        1, false, false, 1608, 3, 20, 1,  0, 0}, // #980
  {DBGFIELD("SHA1NEXTErm")        1, false, false, 1603, 5,  5, 1,  1, 1}, // #981
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, 1608, 3, 20, 1,  0, 0}, // #982
  {DBGFIELD("SHA1RNDS4rmi")       1, false, false, 1603, 5,  5, 1,  1, 1}, // #983
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, 1608, 3, 20, 1,  0, 0}, // #984
  {DBGFIELD("SHA256RNDS2rm")      1, false, false, 1603, 5,  5, 1,  1, 1}, // #985
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #986
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr_ANDNPSrr_VANDNPSrr_ANDNPDrr_VANDNPDrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #987
  {DBGFIELD("MMX_PXORirr_MMX_PANDNirr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #988
  {DBGFIELD("PXORrr_VPXORrr_PANDNrr_VPANDNrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #989
  {DBGFIELD("MMX_PSUBBirr_MMX_PSUBDirr_MMX_PSUBWirr_MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #990
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #991
  {DBGFIELD("PSUBQrr")            16382, false, false,  0, 0,  0, 0,  0, 0}, // #992
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #993
  {DBGFIELD("LEA16r")             1, false, false, 26, 1, 21, 1,  0, 0}, // #994
  {DBGFIELD("MMX_PADDSBirr_MMX_PADDSWirr_MMX_PADDUSBirr_MMX_PADDUSWirr_MMX_PAVGBirr_MMX_PAVGWirr_MMX_PCMPEQBirr_MMX_PCMPEQDirr_MMX_PCMPEQWirr_MMX_PMAXSWirr_MMX_PMINSWirr_MMX_PMAXUBirr_MMX_PMINUBirr_MMX_PSUBSBirr_MMX_PSUBSWirr_MMX_PSUBUSBirr_MMX_PSUBUSWirr") 1, false, false, 1571, 2,  1, 1,  0, 0}, // #995
  {DBGFIELD("MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #996
  {DBGFIELD("CLAC_STAC")          1, false, false,  1, 1,  4, 1,  0, 0}, // #997
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, 1571, 2,  1, 1,  0, 0}, // #998
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr_VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #999
  {DBGFIELD("PSUBBrr_PSUBDrr_PSUBWrr_VPSUBBrr_VPSUBDrr_VPSUBQrr_VPSUBWrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1000
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, 1597, 4, 21, 1,  0, 0}, // #1001
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 1, false, false, 1571, 2,  1, 1,  0, 0}, // #1002
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 1, false, false, 1571, 2,  1, 1,  0, 0}, // #1003
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1004
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, 1631, 3, 21, 1,  0, 0}, // #1005
  {DBGFIELD("VCVTPS2DQYrr_VCVTTPS2DQYrr") 2, false, false, 1848, 3, 21, 1,  0, 0}, // #1006
  {DBGFIELD("MMX_PADDSBirm_MMX_PADDSWirm_MMX_PADDUSBirm_MMX_PADDUSWirm_MMX_PAVGBirm_MMX_PAVGWirm_MMX_PCMPEQBirm_MMX_PCMPEQDirm_MMX_PCMPEQWirm_MMX_PCMPGTBirm_MMX_PCMPGTDirm_MMX_PCMPGTWirm_MMX_PMAXSWirm_MMX_PMAXUBirm_MMX_PMINSWirm_MMX_PMINUBirm_MMX_PSUBSBirm_MMX_PSUBSWirm_MMX_PSUBUSBirm_MMX_PSUBUSWirm") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #1007
  {DBGFIELD("CVTSS2SI64rr_Int")   2, false, false, 1643, 7,  5, 1,  0, 0}, // #1008
  {DBGFIELD("CVTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int") 2, false, false, 1643, 7,  5, 1,  0, 0}, // #1009
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #1010
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1011
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #1012
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #1013
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1014
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 1, false, false,  1, 1,  4, 1,  0, 0}, // #1015
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, 1571, 2,  1, 1,  0, 0}, // #1016
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1017
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1018
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 3, false, false, 1611, 2, 20, 1,  0, 0}, // #1019
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 6, false, false, 1839, 2, 21, 1,  0, 0}, // #1020
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rr_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rr_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rr_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rr_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, 1571, 2,  1, 1,  0, 0}, // #1021
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rr_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rr_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rr_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rr_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1022
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrr_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrr_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrr_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrr_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1023
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 3, false, false, 1715, 2, 20, 1,  0, 0}, // #1024
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1025
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false, 603, 2,  1, 1,  0, 0}, // #1026
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 1, false, false, 1577, 5,  1, 1,  0, 0}, // #1027
  {DBGFIELD("KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1028
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, 1571, 2,  1, 1,  0, 0}, // #1029
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_VPTESTMBZ128rr_VPTESTMBZ128rrk_VPTESTMDZ128rr_VPTESTMDZ128rrk_VPTESTMQZ128rr_VPTESTMQZ128rrk_VPTESTMWZ128rr_VPTESTMWZ128rrk_VPTESTNMBZ128rr_VPTESTNMBZ128rrk_VPTESTNMDZ128rr_VPTESTNMDZ128rrk_VPTESTNMQZ128rr_VPTESTNMQZ128rrk_VPTESTNMWZ128rr_VPTESTNMWZ128rrk") 1, false, false, 1571, 2,  1, 1,  0, 0}, // #1030
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri_KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, 1571, 2,  1, 1,  0, 0}, // #1031
  {DBGFIELD("VALIGNDZ128rri_VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rri_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, 1571, 2,  1, 1,  0, 0}, // #1032
  {DBGFIELD("VALIGNDZ256rri_VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rri_VALIGNQZ256rrik_VALIGNQZ256rrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1033
  {DBGFIELD("VALIGNDZrri_VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrri_VALIGNQZrrik_VALIGNQZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1034
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rri_alt_VCMPPDZ128rri_altk_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rri_alt_VCMPPSZ128rri_altk_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, 1597, 4, 20, 1,  0, 0}, // #1035
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rri_alt_VCMPPDZ256rri_altk_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rri_alt_VCMPPSZ256rri_altk_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 2, false, false, 1833, 4, 20, 1,  0, 0}, // #1036
  {DBGFIELD("VCMPPDZrri_VCMPPDZrri_alt_VCMPPDZrri_altk_VCMPPDZrrib_VCMPPDZrrib_alt_VCMPPDZrrib_altk_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrri_alt_VCMPPSZrri_altk_VCMPPSZrrib_VCMPPSZrrib_alt_VCMPPSZrrib_altk_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1037
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSDZrrb_alt_VCMPSDZrrb_altk_VCMPSDZrri_alt_VCMPSDZrri_altk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VCMPSSZrrb_alt_VCMPSSZrrb_altk_VCMPSSZrri_alt_VCMPSSZrri_altk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, 1597, 4, 20, 1,  0, 0}, // #1038
  {DBGFIELD("VDBPSADBWZrri_VDBPSADBWZrrik_VDBPSADBWZrrikz_VPSADBWZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1039
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rri_alt_VPCMPBZ128rrik_VPCMPBZ128rrik_alt_VPCMPDZ128rri_VPCMPDZ128rri_alt_VPCMPDZ128rrik_VPCMPDZ128rrik_alt_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rri_alt_VPCMPQZ128rrik_VPCMPQZ128rrik_alt_VPCMPUBZ128rri_VPCMPUBZ128rri_alt_VPCMPUBZ128rrik_VPCMPUBZ128rrik_alt_VPCMPUDZ128rri_VPCMPUDZ128rri_alt_VPCMPUDZ128rrik_VPCMPUDZ128rrik_alt_VPCMPUQZ128rri_VPCMPUQZ128rri_alt_VPCMPUQZ128rrik_VPCMPUQZ128rrik_alt_VPCMPUWZ128rri_VPCMPUWZ128rri_alt_VPCMPUWZ128rrik_VPCMPUWZ128rrik_alt_VPCMPWZ128rri_VPCMPWZ128rri_alt_VPCMPWZ128rrik_VPCMPWZ128rrik_alt_VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, 1571, 2,  1, 1,  0, 0}, // #1040
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rri_alt_VPCMPBZ256rrik_VPCMPBZ256rrik_alt_VPCMPDZ256rri_VPCMPDZ256rri_alt_VPCMPDZ256rrik_VPCMPDZ256rrik_alt_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rri_alt_VPCMPQZ256rrik_VPCMPQZ256rrik_alt_VPCMPUBZ256rri_VPCMPUBZ256rri_alt_VPCMPUBZ256rrik_VPCMPUBZ256rrik_alt_VPCMPUDZ256rri_VPCMPUDZ256rri_alt_VPCMPUDZ256rrik_VPCMPUDZ256rrik_alt_VPCMPUQZ256rri_VPCMPUQZ256rri_alt_VPCMPUQZ256rrik_VPCMPUQZ256rrik_alt_VPCMPUWZ256rri_VPCMPUWZ256rri_alt_VPCMPUWZ256rrik_VPCMPUWZ256rrik_alt_VPCMPWZ256rri_VPCMPWZ256rri_alt_VPCMPWZ256rrik_VPCMPWZ256rrik_alt_VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1041
  {DBGFIELD("VPCMPBZrri_VPCMPBZrri_alt_VPCMPBZrrik_VPCMPBZrrik_alt_VPCMPDZrri_VPCMPDZrri_alt_VPCMPDZrrik_VPCMPDZrrik_alt_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrri_alt_VPCMPQZrrik_VPCMPQZrrik_alt_VPCMPUBZrri_VPCMPUBZrri_alt_VPCMPUBZrrik_VPCMPUBZrrik_alt_VPCMPUDZrri_VPCMPUDZrri_alt_VPCMPUDZrrik_VPCMPUDZrrik_alt_VPCMPUQZrri_VPCMPUQZrri_alt_VPCMPUQZrrik_VPCMPUQZrrik_alt_VPCMPUWZrri_VPCMPUWZrri_alt_VPCMPUWZrrik_VPCMPUWZrrik_alt_VPCMPWZrri_VPCMPWZrri_alt_VPCMPWZrrik_VPCMPWZrrik_alt_VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1042
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1043
  {DBGFIELD("VPTESTMBZrr_VPTESTMBZrrk_VPTESTMDZrr_VPTESTMDZrrk_VPTESTMQZrr_VPTESTMQZrrk_VPTESTMWZrr_VPTESTMWZrrk_VPTESTNMBZrr_VPTESTNMBZrrk_VPTESTNMDZrr_VPTESTNMDZrrk_VPTESTNMQZrr_VPTESTNMQZrrk_VPTESTNMWZrr_VPTESTNMWZrrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1044
  {DBGFIELD("VCVTDQ2PSZ128rr_VCVTDQ2PSZ128rrk_VCVTDQ2PSZ128rrkz_VCVTUDQ2PSZ128rr_VCVTUDQ2PSZ128rrk_VCVTUDQ2PSZ128rrkz") 1, false, false, 1631, 3, 21, 1,  0, 0}, // #1045
  {DBGFIELD("VCVTDQ2PSZ256rr_VCVTDQ2PSZ256rrk_VCVTDQ2PSZ256rrkz_VCVTUDQ2PSZ256rr_VCVTUDQ2PSZ256rrk_VCVTUDQ2PSZ256rrkz") 2, false, false, 1848, 3, 21, 1,  0, 0}, // #1046
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 1, false, false, 1631, 3, 21, 1,  0, 0}, // #1047
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 3, false, false, 1857, 4,  6, 1,  0, 0}, // #1048
  {DBGFIELD("VCVTPS2DQYrr")       2, false, false, 1848, 3, 21, 1,  0, 0}, // #1049
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, 1631, 3, 21, 1,  0, 0}, // #1050
  {DBGFIELD("VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 2, false, false, 1848, 3, 21, 1,  0, 0}, // #1051
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 1, false, false, 1631, 3, 21, 1,  0, 0}, // #1052
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 2, false, false, 1848, 3, 21, 1,  0, 0}, // #1053
  {DBGFIELD("VCVTDQ2PSZrr_VCVTUDQ2PSZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1054
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1055
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1056
  {DBGFIELD("VCVTQQ2PDZrr_VCVTUQQ2PDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1057
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1058
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1059
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1060
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 1, false, false, 1631, 3, 21, 1,  0, 0}, // #1061
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 1, false, false, 1631, 3, 21, 1,  0, 0}, // #1062
  {DBGFIELD("VCVTPD2PSZ128rr_VCVTPD2PSZ128rrk_VCVTPD2PSZ128rrkz") 1, false, false, 1631, 3, 21, 1,  0, 0}, // #1063
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz") 1, false, false, 1631, 3, 20, 1,  0, 0}, // #1064
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false, 1631, 3, 21, 1,  0, 0}, // #1065
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false, 1631, 3, 21, 1,  0, 0}, // #1066
  {DBGFIELD("VCVTSD2SSZrr_VCVTSD2SSZrr_Int_VCVTSD2SSZrr_Intk_VCVTSD2SSZrr_Intkz_VCVTSD2SSZrrb_Int_VCVTSD2SSZrrb_Intk_VCVTSD2SSZrrb_Intkz") 2, false, false, 1655, 3,  5, 1,  0, 0}, // #1067
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 2, false, false, 1631, 3,  9, 1,  0, 0}, // #1068
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI2SDZrrb_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 2, false, false, 1631, 3,  9, 1,  0, 0}, // #1069
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz") 2, false, false, 1655, 3,  5, 1,  0, 0}, // #1070
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, 1571, 2,  1, 1,  0, 0}, // #1071
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 1, false, false, 1577, 5, 22, 1,  0, 0}, // #1072
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 3, false, false, 1861, 6,  5, 1,  0, 0}, // #1073
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1074
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1075
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1076
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm_VMOVDI2PDIZrm") 1, false, false, 1691, 4,  7, 1,  0, 0}, // #1077
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 2, false, false, 1631, 3,  9, 1,  0, 0}, // #1078
  {DBGFIELD("VMOVSDZrm_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, 1582, 4,  7, 1,  0, 0}, // #1079
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 2, false, false, 1848, 3, 21, 1,  0, 0}, // #1080
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 3, false, false, 1857, 4,  6, 1,  0, 0}, // #1081
  {DBGFIELD("VCVTPD2PSZ256rr_VCVTPD2PSZ256rrk_VCVTPD2PSZ256rrkz") 3, false, false, 1857, 4,  6, 1,  0, 0}, // #1082
  {DBGFIELD("VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 2, false, false, 1848, 3, 20, 1,  0, 0}, // #1083
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 2, false, false, 1848, 3, 21, 1,  0, 0}, // #1084
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 2, false, false, 1848, 3, 21, 1,  0, 0}, // #1085
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1086
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1087
  {DBGFIELD("VCVTPD2PSZrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1088
  {DBGFIELD("VCVTPS2PDZrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1089
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1090
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1091
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 3, false, false, 1611, 4,  5, 1,  1, 1}, // #1092
  {DBGFIELD("VBROADCASTI32X2Z128m_VBROADCASTI32X2Z128mk_VBROADCASTI32X2Z128mkz_VPBROADCASTDZ128m_VPBROADCASTDZ128mk_VPBROADCASTDZ128mkz_VPBROADCASTQZ128m_VPBROADCASTQZ128mk_VPBROADCASTQZ128mkz") 1, false, false, 1691, 4,  6, 1,  0, 0}, // #1093
  {DBGFIELD("VBROADCASTSSZ128m_VBROADCASTSSZ128mk_VBROADCASTSSZ128mkz") 1, false, false, 1582, 4,  6, 1,  0, 0}, // #1094
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, 1582, 4,  7, 1,  0, 0}, // #1095
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 1, false, false, 1582, 4,  6, 1,  0, 0}, // #1096
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz_VMOVNTDQAZ128rm") 1, false, false, 1691, 4,  7, 1,  0, 0}, // #1097
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #1098
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 3, false, false, 1711, 4,  5, 1,  1, 1}, // #1099
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1100
  {DBGFIELD("VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 2, false, false, 1643, 7,  5, 1,  0, 0}, // #1101
  {DBGFIELD("VCVTSS2SI64rr_Int")  2, false, false, 1643, 7,  5, 1,  0, 0}, // #1102
  {DBGFIELD("VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int") 2, false, false, 1643, 7,  5, 1,  0, 0}, // #1103
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, 226, 2,  7, 1,  0, 0}, // #1104
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1105
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 1, false, false, 603, 2,  1, 1,  0, 0}, // #1106
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 1, false, false, 603, 2,  1, 1,  0, 0}, // #1107
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 1, false, false, 603, 2,  1, 1,  0, 0}, // #1108
  {DBGFIELD("VSCATTERDPSZmr")     1, false, false, 603, 2,  1, 1,  0, 0}, // #1109
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk") 1, false, false, 1597, 6,  5, 1,  1, 1}, // #1110
  {DBGFIELD("VPBROADCASTBZ256m_VPBROADCASTBZ256mk_VPBROADCASTBZ256mkz_VPBROADCASTBZm_VPBROADCASTBZmk_VPBROADCASTBZmkz_VPBROADCASTWZ256m_VPBROADCASTWZ256mk_VPBROADCASTWZ256mkz_VPBROADCASTWZm_VPBROADCASTWZmk_VPBROADCASTWZmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1111
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 6, false, false, 1839, 4, 10, 1,  1, 1}, // #1112
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1113
  {DBGFIELD("VBROADCASTF32X2Z256m_VBROADCASTF32X2Z256mk_VBROADCASTF32X2Z256mkz_VBROADCASTF32X2Zm_VBROADCASTF32X2Zmk_VBROADCASTF32X2Zmkz_VBROADCASTI32X2Z256m_VBROADCASTI32X2Z256mk_VBROADCASTI32X2Z256mkz_VBROADCASTI32X2Zm_VBROADCASTI32X2Zmk_VBROADCASTI32X2Zmkz_VPBROADCASTDZ256m_VPBROADCASTDZ256mk_VPBROADCASTDZ256mkz_VPBROADCASTDZm_VPBROADCASTDZmk_VPBROADCASTDZmkz_VPBROADCASTQZ256m_VPBROADCASTQZ256mk_VPBROADCASTQZ256mkz_VPBROADCASTQZm_VPBROADCASTQZmk_VPBROADCASTQZmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1114
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1115
  {DBGFIELD("VBROADCASTSDZ256m_VBROADCASTSDZ256mk_VBROADCASTSDZ256mkz_VBROADCASTSDZm_VBROADCASTSDZmk_VBROADCASTSDZmkz_VBROADCASTSSZ256m_VBROADCASTSSZ256mk_VBROADCASTSSZ256mkz_VBROADCASTSSZm_VBROADCASTSSZmk_VBROADCASTSSZmkz") 1, false, false, 1582, 4,  6, 1,  0, 0}, // #1116
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 1, false, false, 1582, 4,  6, 1,  1, 1}, // #1117
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1118
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 1, false, false, 1582, 4,  7, 1,  0, 0}, // #1119
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, 1835, 4,  6, 1,  0, 0}, // #1120
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1121
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz_VMOVNTDQAZ256rm") 1, false, false, 1691, 4,  7, 1,  0, 0}, // #1122
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1123
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1124
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1125
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1126
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 1, false, false, 603, 2,  1, 1,  0, 0}, // #1127
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 1, false, false, 603, 2,  1, 1,  0, 0}, // #1128
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 1, false, false, 603, 2,  1, 1,  0, 0}, // #1129
  {DBGFIELD("VPSCATTERDDZmr")     1, false, false, 603, 2,  1, 1,  0, 0}, // #1130
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #1131
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbi_alt_VCMPPDZ128rmbi_altk_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmi_alt_VCMPPDZ128rmi_altk_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbi_alt_VCMPPSZ128rmbi_altk_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmi_alt_VCMPPSZ128rmi_altk_VCMPPSZ128rmik") 1, false, false, 1597, 6,  5, 1,  1, 1}, // #1132
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSDZrmi_alt_VCMPSDZrmi_altk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk_VCMPSSZrmi_alt_VCMPSSZrmi_altk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 1, false, false, 1597, 6,  5, 1,  1, 1}, // #1133
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmi_alt_VPCMPBZ128rmik_VPCMPBZ128rmik_alt_VPCMPDZ128rmi_VPCMPDZ128rmi_alt_VPCMPDZ128rmib_VPCMPDZ128rmib_alt_VPCMPDZ128rmibk_VPCMPDZ128rmibk_alt_VPCMPDZ128rmik_VPCMPDZ128rmik_alt_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmi_alt_VPCMPQZ128rmib_VPCMPQZ128rmib_alt_VPCMPQZ128rmibk_VPCMPQZ128rmibk_alt_VPCMPQZ128rmik_VPCMPQZ128rmik_alt_VPCMPUBZ128rmi_VPCMPUBZ128rmi_alt_VPCMPUBZ128rmik_VPCMPUBZ128rmik_alt_VPCMPUDZ128rmi_VPCMPUDZ128rmi_alt_VPCMPUDZ128rmib_VPCMPUDZ128rmib_alt_VPCMPUDZ128rmibk_VPCMPUDZ128rmibk_alt_VPCMPUDZ128rmik_VPCMPUDZ128rmik_alt_VPCMPUQZ128rmi_VPCMPUQZ128rmi_alt_VPCMPUQZ128rmib_VPCMPUQZ128rmib_alt_VPCMPUQZ128rmibk_VPCMPUQZ128rmibk_alt_VPCMPUQZ128rmik_VPCMPUQZ128rmik_alt_VPCMPUWZ128rmi_VPCMPUWZ128rmi_alt_VPCMPUWZ128rmik_VPCMPUWZ128rmik_alt_VPCMPWZ128rmi_VPCMPWZ128rmi_alt_VPCMPWZ128rmik_VPCMPWZ128rmik_alt_VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #1134
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1135
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1136
  {DBGFIELD("VPMOVSXBDZ128rm_VPMOVSXBDZ128rmk_VPMOVSXBDZ128rmkz_VPMOVSXBQZ128rm_VPMOVSXBQZ128rmk_VPMOVSXBQZ128rmkz_VPMOVSXBWZ128rm_VPMOVSXBWZ128rmk_VPMOVSXBWZ128rmkz_VPMOVSXDQZ128rm_VPMOVSXDQZ128rmk_VPMOVSXDQZ128rmkz_VPMOVSXWDZ128rm_VPMOVSXWDZ128rmk_VPMOVSXWDZ128rmkz_VPMOVSXWQZ128rm_VPMOVSXWQZ128rmk_VPMOVSXWQZ128rmkz_VPMOVZXBDZ128rm_VPMOVZXBDZ128rmk_VPMOVZXBDZ128rmkz_VPMOVZXBQZ128rm_VPMOVZXBQZ128rmk_VPMOVZXBQZ128rmkz_VPMOVZXBWZ128rm_VPMOVZXBWZ128rmk_VPMOVZXBWZ128rmkz_VPMOVZXDQZ128rm_VPMOVZXDQZ128rmk_VPMOVZXDQZ128rmkz_VPMOVZXWDZ128rm_VPMOVZXWDZ128rmk_VPMOVZXWDZ128rmkz_VPMOVZXWQZ128rm_VPMOVZXWQZ128rmk_VPMOVZXWQZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1137
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 1, false, false, 1691, 4,  6, 1,  1, 1}, // #1138
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1139
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1140
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbi_alt_VCMPPDZ256rmbi_altk_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmi_alt_VCMPPDZ256rmi_altk_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbi_alt_VCMPPSZ256rmbi_altk_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmi_alt_VCMPPSZ256rmi_altk_VCMPPSZ256rmik") 2, false, false, 1833, 6,  5, 1,  1, 1}, // #1141
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbi_alt_VCMPPDZrmbi_altk_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmi_alt_VCMPPDZrmi_altk_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbi_alt_VCMPPSZrmbi_altk_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmi_alt_VCMPPSZrmi_altk_VCMPPSZrmik") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1142
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmi_alt_VPCMPBZ256rmik_VPCMPBZ256rmik_alt_VPCMPDZ256rmi_VPCMPDZ256rmi_alt_VPCMPDZ256rmib_VPCMPDZ256rmib_alt_VPCMPDZ256rmibk_VPCMPDZ256rmibk_alt_VPCMPDZ256rmik_VPCMPDZ256rmik_alt_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmi_alt_VPCMPQZ256rmib_VPCMPQZ256rmib_alt_VPCMPQZ256rmibk_VPCMPQZ256rmibk_alt_VPCMPQZ256rmik_VPCMPQZ256rmik_alt_VPCMPUBZ256rmi_VPCMPUBZ256rmi_alt_VPCMPUBZ256rmik_VPCMPUBZ256rmik_alt_VPCMPUDZ256rmi_VPCMPUDZ256rmi_alt_VPCMPUDZ256rmib_VPCMPUDZ256rmib_alt_VPCMPUDZ256rmibk_VPCMPUDZ256rmibk_alt_VPCMPUDZ256rmik_VPCMPUDZ256rmik_alt_VPCMPUQZ256rmi_VPCMPUQZ256rmi_alt_VPCMPUQZ256rmib_VPCMPUQZ256rmib_alt_VPCMPUQZ256rmibk_VPCMPUQZ256rmibk_alt_VPCMPUQZ256rmik_VPCMPUQZ256rmik_alt_VPCMPUWZ256rmi_VPCMPUWZ256rmi_alt_VPCMPUWZ256rmik_VPCMPUWZ256rmik_alt_VPCMPWZ256rmi_VPCMPWZ256rmi_alt_VPCMPWZ256rmik_VPCMPWZ256rmik_alt_VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1143
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmi_alt_VPCMPBZrmik_VPCMPBZrmik_alt_VPCMPDZrmi_VPCMPDZrmi_alt_VPCMPDZrmib_VPCMPDZrmib_alt_VPCMPDZrmibk_VPCMPDZrmibk_alt_VPCMPDZrmik_VPCMPDZrmik_alt_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmi_alt_VPCMPQZrmib_VPCMPQZrmib_alt_VPCMPQZrmibk_VPCMPQZrmibk_alt_VPCMPQZrmik_VPCMPQZrmik_alt_VPCMPUBZrmi_VPCMPUBZrmi_alt_VPCMPUBZrmik_VPCMPUBZrmik_alt_VPCMPUDZrmi_VPCMPUDZrmi_alt_VPCMPUDZrmib_VPCMPUDZrmib_alt_VPCMPUDZrmibk_VPCMPUDZrmibk_alt_VPCMPUDZrmik_VPCMPUDZrmik_alt_VPCMPUQZrmi_VPCMPUQZrmi_alt_VPCMPUQZrmib_VPCMPUQZrmib_alt_VPCMPUQZrmibk_VPCMPUQZrmibk_alt_VPCMPUQZrmik_VPCMPUQZrmik_alt_VPCMPUWZrmi_VPCMPUWZrmi_alt_VPCMPUWZrmik_VPCMPUWZrmik_alt_VPCMPWZrmi_VPCMPWZrmi_alt_VPCMPWZrmik_VPCMPWZrmik_alt_VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1144
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1145
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1146
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 1, false, false, 1626, 5, 10, 1,  0, 0}, // #1147
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 1, false, false, 1626, 5, 10, 1,  0, 0}, // #1148
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 1, false, false, 1626, 5, 10, 1,  0, 0}, // #1149
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 1, false, false, 1626, 5, 10, 1,  0, 0}, // #1150
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 1, false, false, 1626, 5, 10, 1,  0, 0}, // #1151
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 1, false, false, 1626, 5,  5, 1,  0, 0}, // #1152
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz") 2, false, false, 1650, 5, 19, 1,  1, 1}, // #1153
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1154
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 2, false, false, 1843, 5, 10, 1,  0, 0}, // #1155
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1156
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 2, false, false, 1843, 5, 10, 1,  0, 0}, // #1157
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1158
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 2, false, false, 1843, 5, 10, 1,  0, 0}, // #1159
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1160
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 2, false, false, 1843, 5,  5, 1,  0, 0}, // #1161
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1162
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 3, false, false, 1851, 6, 26, 1,  0, 0}, // #1163
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1164
  {DBGFIELD("VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 2, false, false, 1843, 5, 10, 1,  0, 0}, // #1165
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1166
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1167
  {DBGFIELD("VCVTSD2SSZrm_VCVTSD2SSZrm_Int_VCVTSD2SSZrm_Intk_VCVTSD2SSZrm_Intkz") 2, false, false, 1650, 5, 19, 1,  1, 1}, // #1168
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 1, false, false, 1691, 4,  6, 1,  0, 0}, // #1169
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, 1608, 3, 20, 1,  0, 0}, // #1170
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1171
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1172
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1173
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 2, false, false, 1634, 9, 19, 1,  1, 1}, // #1174
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 2, false, false, 1634, 9, 19, 1,  1, 1}, // #1175
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1176
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1177
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1178
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1179
  {DBGFIELD("VCVTPD2PSZrm_VCVTPD2PSZrmb_VCVTPD2PSZrmbk_VCVTPD2PSZrmbkz_VCVTPD2PSZrmk_VCVTPD2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1180
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1181
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1182
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 1, false, false, 1691, 4,  6, 1,  0, 0}, // #1183
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 1, false, false, 1603, 5,  5, 1,  1, 1}, // #1184
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1185
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1186
  {DBGFIELD("VGATHERDPSZ128rm_VGATHERQPSZrm_VPGATHERDDZ128rm") 1, false, false, 226, 2,  7, 1,  0, 0}, // #1187
  {DBGFIELD("VGATHERQPSZ128rm_VGATHERQPSZ256rm_VPGATHERQDZ128rm_VPGATHERQDZ256rm") 1, false, false, 226, 2,  7, 1,  0, 0}, // #1188
  {DBGFIELD("VGATHERDPDZ128rm_VGATHERQPDZ128rm_VPGATHERDQZ128rm_VPGATHERQQZ128rm") 1, false, false, 226, 2,  7, 1,  0, 0}, // #1189
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz") 1, false, false, 1571, 2,  1, 1,  0, 0}, // #1190
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1191
  {DBGFIELD("VGATHERDPDZ256rm_VGATHERQPDZ256rm_VPGATHERDQZ256rm_VPGATHERQDZrm_VPGATHERQQZ256rm") 1, false, false, 226, 2,  7, 1,  0, 0}, // #1192
  {DBGFIELD("VGATHERDPDZrm_VGATHERQPDZrm_VPGATHERDQZrm_VPGATHERQQZrm") 1, false, false, 226, 2,  7, 1,  0, 0}, // #1193
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm") 1, false, false, 226, 2,  7, 1,  0, 0}, // #1194
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1195
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 1, false, false, 226, 2,  7, 1,  0, 0}, // #1196
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1197
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1198
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1199
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1200
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1201
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1202
  {DBGFIELD("JWriteZeroLatency")  1, false, false,  0, 0,  0, 1,  0, 0}, // #1203
  {DBGFIELD("WriteVecALU")        1, false, false, 1571, 2,  1, 1,  0, 0}, // #1204
  {DBGFIELD("WriteVecALUX")       1, false, false, 1571, 2,  1, 1,  0, 0}, // #1205
  {DBGFIELD("WriteALU")           1, false, false,  1, 1,  1, 1,  0, 0}, // #1206
  {DBGFIELD("WriteFLogic")        1, false, false, 1582, 2,  1, 1,  0, 0}, // #1207
  {DBGFIELD("WriteVecLogic")      1, false, false, 1571, 2,  1, 1,  0, 0}, // #1208
  {DBGFIELD("WriteVecLogicX")     1, false, false, 1571, 2,  1, 1,  0, 0}, // #1209
  {DBGFIELD("JWrite3OpsLEA")      1, false, false, 1950, 4, 20, 1,  0, 0}, // #1210
  {DBGFIELD("WriteLEA")           1, false, false,  1, 1,  1, 1,  0, 0}, // #1211
}; // BtVer2ModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc SkylakeServerModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  16383, false, false,  0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteZero")          1, false, false,  0, 0,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteVecALU")        1, false, false, 1954, 5,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteALULd_WriteRMW") 3, false, false, 81, 6, 63, 2,  0, 0}, // #3
  {DBGFIELD("WriteJumpLd")        2, false, false, 87, 6,  6, 1,  0, 0}, // #4
  {DBGFIELD("WriteALU")           1, false, false, 79, 2,  1, 1,  0, 0}, // #5
  {DBGFIELD("WriteMove")          1, false, false, 79, 2,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteJump")          1, false, false, 93, 4,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, 79, 2,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteFStoreX")       2, false, false, 97, 4,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteFLoadX")        1, false, false, 101, 3,  6, 1,  0, 0}, // #10
  {DBGFIELD("WriteFStoreY")       2, false, false, 97, 4,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteFLoadY")        1, false, false, 101, 3,  5, 1,  0, 0}, // #12
  {DBGFIELD("WriteMicrocoded")    1, false, false, 79, 2,  4, 1,  0, 0}, // #13
  {DBGFIELD("WriteFSign")         1, false, false, 237, 9,  1, 1,  0, 0}, // #14
  {DBGFIELD("WriteADC")           1, false, false, 93, 4,  1, 1,  0, 0}, // #15
  {DBGFIELD("WriteADCRMW")        6, false, false, 112, 8, 10, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCLd_ReadAfterLd") 2, false, false, 87, 6,  6, 1,  9, 1}, // #17
  {DBGFIELD("WriteALURMW")        3, false, false, 81, 6,  5, 1,  0, 0}, // #18
  {DBGFIELD("WriteALULd_ReadAfterLd") 2, false, false, 120, 4,  6, 1,  9, 1}, // #19
  {DBGFIELD("WriteFAdd64XLd_ReadAfterLd") 2, false, false, 490, 6, 18, 1,  9, 1}, // #20
  {DBGFIELD("WriteFAdd64X")       1, false, false, 437, 4, 22, 1,  0, 0}, // #21
  {DBGFIELD("WriteFAddXLd_ReadAfterLd") 2, false, false, 490, 6, 18, 1,  9, 1}, // #22
  {DBGFIELD("WriteFAddX")         1, false, false, 437, 4, 22, 1,  0, 0}, // #23
  {DBGFIELD("WriteFAdd64Ld_ReadAfterLd") 2, false, false, 490, 6,  9, 1,  9, 1}, // #24
  {DBGFIELD("WriteFAdd64")        1, false, false, 437, 4, 22, 1,  0, 0}, // #25
  {DBGFIELD("WriteFAddLd_ReadAfterLd") 2, false, false, 490, 6,  9, 1,  9, 1}, // #26
  {DBGFIELD("WriteFAdd")          1, false, false, 437, 4, 22, 1,  0, 0}, // #27
  {DBGFIELD("WriteFAddLd")        2, false, false, 490, 6,  9, 1,  0, 0}, // #28
  {DBGFIELD("WriteAESDecEncLd_ReadAfterLd") 2, false, false, 225, 11, 18, 1,  9, 1}, // #29
  {DBGFIELD("WriteAESDecEnc")     1, false, false, 237, 9, 22, 1,  0, 0}, // #30
  {DBGFIELD("WriteAESIMCLd")      3, false, false, 568, 11, 25, 1,  0, 0}, // #31
  {DBGFIELD("WriteAESIMC")        2, false, false, 579, 9, 10, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESKeyGenLd")   11, false, false, 1959, 14, 34, 1,  0, 0}, // #33
  {DBGFIELD("WriteAESKeyGen")     11, false, false, 1973, 12, 30, 1,  0, 0}, // #34
  {DBGFIELD("WriteFLogicLd_ReadAfterLd") 2, false, false, 128, 5,  5, 1,  9, 1}, // #35
  {DBGFIELD("WriteFLogic")        1, false, false, 78, 3,  1, 1,  0, 0}, // #36
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 194, 8,  5, 1, 10, 1}, // #37
  {DBGFIELD("WriteBEXTR")         2, false, false, 202, 6, 20, 1,  0, 0}, // #38
  {DBGFIELD("WriteBEXTRLd")       3, false, false, 194, 8,  5, 1,  0, 0}, // #39
  {DBGFIELD("WriteALULd")         2, false, false, 120, 4,  6, 1,  0, 0}, // #40
  {DBGFIELD("WriteFBlendLd_ReadAfterLd") 2, false, false, 128, 5,  5, 1,  9, 1}, // #41
  {DBGFIELD("WriteFBlend")        1, false, false, 78, 3,  1, 1,  0, 0}, // #42
  {DBGFIELD("WriteFVarBlendLd_ReadAfterLd") 3, false, false, 614, 5, 10, 1,  9, 1}, // #43
  {DBGFIELD("WriteFVarBlend")     2, false, false, 399, 3, 20, 1,  0, 0}, // #44
  {DBGFIELD("WriteBSFLd")         2, false, false, 124, 9, 10, 1,  0, 0}, // #45
  {DBGFIELD("WriteBSF")           1, false, false, 133, 7, 21, 1,  0, 0}, // #46
  {DBGFIELD("WriteBSRLd")         2, false, false, 124, 9, 10, 1,  0, 0}, // #47
  {DBGFIELD("WriteBSR")           1, false, false, 133, 7, 21, 1,  0, 0}, // #48
  {DBGFIELD("WriteBSWAP32")       1, false, false, 77, 4,  1, 1,  0, 0}, // #49
  {DBGFIELD("WriteBSWAP64")       2, false, false, 202, 6, 20, 1,  0, 0}, // #50
  {DBGFIELD("WriteBitTest")       1, false, false, 93, 4,  1, 1,  0, 0}, // #51
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 208, 6,  6, 1, 10, 1}, // #52
  {DBGFIELD("WriteBZHI")          1, false, false, 77, 4,  1, 1,  0, 0}, // #53
  {DBGFIELD("WriteLoad")          1, false, false, 101, 3,  7, 1,  0, 0}, // #54
  {DBGFIELD("WriteCMOV2Ld_ReadAfterLd") 3, false, false, 1985, 6,  5, 1,  9, 1}, // #55
  {DBGFIELD("WriteCMOV2")         2, false, false, 1100, 4, 20, 1,  0, 0}, // #56
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 2, false, false, 87, 6,  6, 1,  9, 1}, // #57
  {DBGFIELD("WriteCMOV")          1, false, false, 93, 4,  1, 1,  0, 0}, // #58
  {DBGFIELD("WriteFCMOV")         1, false, false, 133, 7, 21, 1,  0, 0}, // #59
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 120, 4,  6, 1, 10, 1}, // #60
  {DBGFIELD("WriteFCmp64XLd_ReadAfterLd") 2, false, false, 490, 6, 18, 1,  9, 1}, // #61
  {DBGFIELD("WriteFCmp64X")       1, false, false, 437, 4, 22, 1,  0, 0}, // #62
  {DBGFIELD("WriteFCmpXLd_ReadAfterLd") 2, false, false, 490, 6, 18, 1,  9, 1}, // #63
  {DBGFIELD("WriteFCmpX")         1, false, false, 437, 4, 22, 1,  0, 0}, // #64
  {DBGFIELD("WriteFCmp64Ld_ReadAfterLd") 2, false, false, 490, 6,  9, 1,  9, 1}, // #65
  {DBGFIELD("WriteFCmp64")        1, false, false, 437, 4, 22, 1,  0, 0}, // #66
  {DBGFIELD("WriteFCmpLd_ReadAfterLd") 2, false, false, 490, 6,  9, 1,  9, 1}, // #67
  {DBGFIELD("WriteFCmp")          1, false, false, 437, 4, 22, 1,  0, 0}, // #68
  {DBGFIELD("WriteFComLd_ReadAfterLd") 2, false, false, 225, 11,  5, 1,  9, 1}, // #69
  {DBGFIELD("WriteFCom")          1, false, false, 237, 9, 20, 1,  0, 0}, // #70
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #71
  {DBGFIELD("WriteCRC32")         1, false, false, 133, 7, 21, 1,  0, 0}, // #72
  {DBGFIELD("WriteNop")           1, false, false,  0, 0,  1, 1,  0, 0}, // #73
  {DBGFIELD("WriteCvtI2PDLd")     2, false, false, 490, 6,  9, 1,  0, 0}, // #74
  {DBGFIELD("WriteCvtI2PD")       1, false, false, 437, 4, 22, 1,  0, 0}, // #75
  {DBGFIELD("WriteCvtI2PSLd")     2, false, false, 490, 6,  9, 1,  0, 0}, // #76
  {DBGFIELD("WriteCvtI2PS")       1, false, false, 437, 4, 22, 1,  0, 0}, // #77
  {DBGFIELD("WriteCvtPD2ILd")     2, false, false, 490, 6, 10, 1,  0, 0}, // #78
  {DBGFIELD("WriteCvtPD2I")       1, false, false, 437, 4, 21, 1,  0, 0}, // #79
  {DBGFIELD("WriteCvtPD2PSLd")    2, false, false, 124, 9, 10, 1,  0, 0}, // #80
  {DBGFIELD("WriteCvtPD2PS")      1, false, false, 133, 7, 21, 1,  0, 0}, // #81
  {DBGFIELD("WriteCvtPS2ILd")     2, false, false, 490, 6, 10, 1,  0, 0}, // #82
  {DBGFIELD("WriteCvtPS2I")       1, false, false, 437, 4, 21, 1,  0, 0}, // #83
  {DBGFIELD("WriteCvtPS2PDLd")    2, false, false, 124, 9, 10, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtPS2PD")      1, false, false, 133, 7, 21, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtSD2ILd")     3, false, false, 1991, 6, 26, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtSD2I")       2, false, false, 398, 4,  6, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtSD2SSLd")    2, false, false, 124, 9, 10, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #89
  {DBGFIELD("WriteCvtSD2SS")      1, false, false, 133, 7, 21, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, 124, 9,  9, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterLd") 2, false, false, 124, 9,  9, 1,  9, 1}, // #92
  {DBGFIELD("WriteCvtI2SD")       1, false, false, 133, 7, 22, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtI2SSLd")     2, false, false, 124, 9,  9, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterLd") 2, false, false, 124, 9,  9, 1,  9, 1}, // #95
  {DBGFIELD("WriteCvtI2SS")       1, false, false, 133, 7, 22, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtSS2SDLd")    2, false, false, 124, 9, 10, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #98
  {DBGFIELD("WriteCvtSS2SD")      1, false, false, 133, 7, 21, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtSS2ILd")     3, false, false, 1991, 6, 26, 1,  0, 0}, // #100
  {DBGFIELD("WriteCvtSS2I")       2, false, false, 398, 4,  6, 1,  0, 0}, // #101
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 36, 1, 11, 2}, // #102
  {DBGFIELD("WriteDiv16")         1, false, false, 236, 10, 34, 1,  0, 0}, // #103
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 36, 1, 11, 2}, // #104
  {DBGFIELD("WriteDiv32")         1, false, false, 236, 10, 34, 1,  0, 0}, // #105
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 36, 1, 11, 2}, // #106
  {DBGFIELD("WriteDiv64")         1, false, false, 236, 10, 34, 1,  0, 0}, // #107
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 36, 1, 11, 2}, // #108
  {DBGFIELD("WriteDiv8")          1, false, false, 236, 10, 34, 1,  0, 0}, // #109
  {DBGFIELD("WriteFDiv64XLd_ReadAfterLd") 2, false, false, 1997, 12, 30, 1,  9, 1}, // #110
  {DBGFIELD("WriteFDiv64X")       1, false, false, 290, 10, 25, 1,  0, 0}, // #111
  {DBGFIELD("WriteFDivXLd_ReadAfterLd") 2, false, false, 268, 12, 28, 1,  9, 1}, // #112
  {DBGFIELD("WriteFDivX")         1, false, false, 290, 10, 26, 1,  0, 0}, // #113
  {DBGFIELD("WriteFDivLd")        2, false, false, 2009, 12,  8, 1,  0, 0}, // #114
  {DBGFIELD("WriteFDiv")          1, false, false, 290, 10, 26, 1,  0, 0}, // #115
  {DBGFIELD("WriteFDiv64Ld_ReadAfterLd") 2, false, false, 1997, 12, 65, 1,  9, 1}, // #116
  {DBGFIELD("WriteFDiv64")        1, false, false, 290, 10, 25, 1,  0, 0}, // #117
  {DBGFIELD("WriteFDivLd_ReadAfterLd") 2, false, false, 2009, 12,  8, 1,  9, 1}, // #118
  {DBGFIELD("WriteDPPDLd_ReadAfterLd") 4, false, false, 2021, 10, 24, 1,  9, 1}, // #119
  {DBGFIELD("WriteDPPD")          3, false, false, 2031, 8,  9, 1,  0, 0}, // #120
  {DBGFIELD("WriteDPPSLd_ReadAfterLd") 5, false, false, 2039, 10, 65, 1,  9, 1}, // #121
  {DBGFIELD("WriteDPPS")          4, false, false, 2049, 8, 27, 1,  0, 0}, // #122
  {DBGFIELD("WriteVecExtractSt")  3, false, false, 370, 11, 20, 1,  0, 0}, // #123
  {DBGFIELD("WriteVecExtract")    2, false, false, 381, 12, 21, 1,  0, 0}, // #124
  {DBGFIELD("WriteVecALUX")       1, false, false, 437, 4,  1, 1,  0, 0}, // #125
  {DBGFIELD("WriteFComLd")        2, false, false, 225, 11,  5, 1,  0, 0}, // #126
  {DBGFIELD("WriteEMMS")          10, false, false, 2057, 5, 18, 1,  0, 0}, // #127
  {DBGFIELD("WriteFLDC")          2, false, false, 2062, 5,  1, 1,  0, 0}, // #128
  {DBGFIELD("WriteVecALUXLd_ReadAfterLd") 2, false, false, 490, 6,  5, 1,  9, 1}, // #129
  {DBGFIELD("WriteFHAddLd_ReadAfterLd") 4, false, false, 2067, 10, 19, 1,  9, 1}, // #130
  {DBGFIELD("WriteFHAdd")         3, false, false, 2077, 8,  6, 1,  0, 0}, // #131
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 36, 1, 11, 2}, // #132
  {DBGFIELD("WriteIDiv16")        1, false, false, 236, 10, 34, 1,  0, 0}, // #133
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 36, 1, 11, 2}, // #134
  {DBGFIELD("WriteIDiv32")        1, false, false, 236, 10, 34, 1,  0, 0}, // #135
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 36, 1, 11, 2}, // #136
  {DBGFIELD("WriteIDiv64")        1, false, false, 236, 10, 34, 1,  0, 0}, // #137
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 36, 1, 11, 2}, // #138
  {DBGFIELD("WriteIDiv8")         1, false, false, 236, 10, 34, 1,  0, 0}, // #139
  {DBGFIELD("WriteIMulLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1, 11, 2}, // #140
  {DBGFIELD("WriteIMul")          1, false, false, 133, 7, 21, 1,  0, 0}, // #141
  {DBGFIELD("WriteIMulLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #142
  {DBGFIELD("WriteIMulLd")        2, false, false, 124, 9, 10, 1,  0, 0}, // #143
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1, 11, 2}, // #144
  {DBGFIELD("WriteIMul64")        1, false, false, 133, 7, 21, 1,  0, 0}, // #145
  {DBGFIELD("WriteIMul64Ld_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #146
  {DBGFIELD("WriteIMul64Ld")      2, false, false, 124, 9, 10, 1,  0, 0}, // #147
  {DBGFIELD("WriteFShuffleLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1,  9, 1}, // #148
  {DBGFIELD("WriteFShuffle")      1, false, false, 104, 8,  1, 1,  0, 0}, // #149
  {DBGFIELD("WriteStore")         1, false, false, 97, 4,  1, 1,  0, 0}, // #150
  {DBGFIELD("WriteVecLogicX")     1, false, false, 78, 3,  1, 1,  0, 0}, // #151
  {DBGFIELD("WriteShuffle")       1, false, false, 104, 8,  1, 1,  0, 0}, // #152
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, 93, 4,  1, 1,  0, 0}, // #153
  {DBGFIELD("WriteVecLoadX")      1, false, false, 101, 3,  6, 1,  0, 0}, // #154
  {DBGFIELD("WriteLDMXCSR")       3, false, false, 426, 11,  5, 1,  0, 0}, // #155
  {DBGFIELD("WriteFLD0")          1, false, false, 1954, 5,  1, 1,  0, 0}, // #156
  {DBGFIELD("WriteFLD1")          2, false, false, 2062, 5,  1, 1,  0, 0}, // #157
  {DBGFIELD("WriteLEA")           1, false, false, 77, 4,  1, 1,  0, 0}, // #158
  {DBGFIELD("WriteFence")         1, false, false, 441, 5,  1, 1,  0, 0}, // #159
  {DBGFIELD("WriteLZCNTLd")       2, false, false, 124, 9, 10, 1,  0, 0}, // #160
  {DBGFIELD("WriteLZCNT")         1, false, false, 133, 7, 21, 1,  0, 0}, // #161
  {DBGFIELD("WriteVecStoreX")     2, false, false, 97, 4,  1, 1,  0, 0}, // #162
  {DBGFIELD("WriteVecStore")      2, false, false, 97, 4,  1, 1,  0, 0}, // #163
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, 237, 9, 20, 1,  0, 0}, // #164
  {DBGFIELD("WriteVecLoad")       1, false, false, 101, 3,  7, 1,  0, 0}, // #165
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, 104, 8,  1, 1,  0, 0}, // #166
  {DBGFIELD("WriteVecMoveX")      1, false, false, 78, 3,  1, 1,  0, 0}, // #167
  {DBGFIELD("WriteVecStoreNT")    2, false, false, 97, 4,  1, 1,  0, 0}, // #168
  {DBGFIELD("WriteVecMove")       1, false, false, 1954, 5,  1, 1,  0, 0}, // #169
  {DBGFIELD("WriteVecALULd")      2, false, false, 2085, 7,  6, 1,  0, 0}, // #170
  {DBGFIELD("WriteShuffleLd_ReadAfterLd") 2, false, false, 140, 10,  6, 1,  9, 1}, // #171
  {DBGFIELD("WriteVecALULd_ReadAfterLd") 2, false, false, 2085, 7,  6, 1,  9, 1}, // #172
  {DBGFIELD("WriteVecLogicLd_ReadAfterLd") 2, false, false, 2085, 7,  6, 1,  9, 1}, // #173
  {DBGFIELD("WriteVecLogic")      1, false, false, 1954, 5,  1, 1,  0, 0}, // #174
  {DBGFIELD("WritePHAddLd_ReadAfterLd") 4, false, false, 2092, 10, 10, 1,  9, 1}, // #175
  {DBGFIELD("WritePHAdd")         3, false, false, 2102, 8, 21, 1,  0, 0}, // #176
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 2, false, false, 140, 10,  6, 1,  9, 1}, // #177
  {DBGFIELD("WriteVecInsert")     2, false, false, 160, 8, 20, 1,  0, 0}, // #178
  {DBGFIELD("WriteVecIMulLd_ReadAfterLd") 2, false, false, 225, 11,  9, 1,  9, 1}, // #179
  {DBGFIELD("WriteVecIMul")       1, false, false, 237, 9, 22, 1,  0, 0}, // #180
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, 237, 9, 20, 1,  0, 0}, // #181
  {DBGFIELD("WritePSADBWLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1,  9, 1}, // #182
  {DBGFIELD("WritePSADBW")        1, false, false, 104, 8, 21, 1,  0, 0}, // #183
  {DBGFIELD("WriteVarShuffleLd_ReadAfterLd") 2, false, false, 140, 10,  6, 1,  9, 1}, // #184
  {DBGFIELD("WriteVarShuffle")    1, false, false, 104, 8,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteShuffleLd")     2, false, false, 140, 10,  6, 1,  0, 0}, // #186
  {DBGFIELD("WriteVecShiftImm")   1, false, false, 237, 9,  1, 1,  0, 0}, // #187
  {DBGFIELD("WriteVecShiftLd_ReadAfterLd") 2, false, false, 225, 11,  6, 1,  9, 1}, // #188
  {DBGFIELD("WriteVecShift")      1, false, false, 237, 9,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteFMoveX")        1, false, false, 78, 3,  1, 1,  0, 0}, // #190
  {DBGFIELD("WriteFShuffleLd")    2, false, false, 140, 10,  5, 1,  0, 0}, // #191
  {DBGFIELD("WriteFStore")        2, false, false, 97, 4,  1, 1,  0, 0}, // #192
  {DBGFIELD("WriteFMOVMSK")       1, false, false, 237, 9, 20, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecLoadNT")     1, false, false, 101, 3,  6, 1,  0, 0}, // #194
  {DBGFIELD("WriteStoreNT")       2, false, false, 97, 4,  1, 1,  0, 0}, // #195
  {DBGFIELD("WriteFStoreNTX")     2, false, false, 97, 4,  1, 1,  0, 0}, // #196
  {DBGFIELD("WriteFStoreNT")      2, false, false, 97, 4,  1, 1,  0, 0}, // #197
  {DBGFIELD("WriteFLoad")         1, false, false, 101, 3,  7, 1,  0, 0}, // #198
  {DBGFIELD("WriteMPSADLd_ReadAfterLd") 3, false, false, 150, 10, 18, 1,  9, 1}, // #199
  {DBGFIELD("WriteMPSAD")         2, false, false, 160, 8, 22, 1,  0, 0}, // #200
  {DBGFIELD("WriteFMul64XLd_ReadAfterLd") 2, false, false, 490, 6, 18, 1,  9, 1}, // #201
  {DBGFIELD("WriteFMul64X")       1, false, false, 437, 4, 22, 1,  0, 0}, // #202
  {DBGFIELD("WriteFMulXLd_ReadAfterLd") 2, false, false, 490, 6, 18, 1,  9, 1}, // #203
  {DBGFIELD("WriteFMulX")         1, false, false, 437, 4, 22, 1,  0, 0}, // #204
  {DBGFIELD("WriteFMul64Ld_ReadAfterLd") 2, false, false, 490, 6,  9, 1,  9, 1}, // #205
  {DBGFIELD("WriteFMul64")        1, false, false, 437, 4, 22, 1,  0, 0}, // #206
  {DBGFIELD("WriteFMulLd_ReadAfterLd") 2, false, false, 490, 6,  9, 1,  9, 1}, // #207
  {DBGFIELD("WriteFMul")          1, false, false, 437, 4, 22, 1,  0, 0}, // #208
  {DBGFIELD("WriteIMulLd_WriteIMulH") 3, false, false, 124, 9, 68, 2,  0, 0}, // #209
  {DBGFIELD("WriteIMul_WriteIMulH") 2, false, false, 133, 7, 69, 2,  0, 0}, // #210
  {DBGFIELD("WriteIMul64Ld_WriteIMulH") 3, false, false, 124, 9, 68, 2,  0, 0}, // #211
  {DBGFIELD("WriteIMul64_WriteIMulH") 2, false, false, 133, 7, 69, 2,  0, 0}, // #212
  {DBGFIELD("WriteFMulLd")        2, false, false, 490, 6,  9, 1,  0, 0}, // #213
  {DBGFIELD("WriteVecALUXLd")     2, false, false, 490, 6,  5, 1,  0, 0}, // #214
  {DBGFIELD("WriteShuffleXLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1,  9, 1}, // #215
  {DBGFIELD("WriteShuffleX")      1, false, false, 104, 8,  1, 1,  0, 0}, // #216
  {DBGFIELD("WriteVecLogicXLd_ReadAfterLd") 2, false, false, 128, 5,  5, 1,  9, 1}, // #217
  {DBGFIELD("WriteVarBlendLd_ReadAfterLd") 3, false, false, 614, 5, 10, 1,  9, 1}, // #218
  {DBGFIELD("WriteVarBlend")      2, false, false, 399, 3, 20, 1,  0, 0}, // #219
  {DBGFIELD("WriteBlendLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1,  9, 1}, // #220
  {DBGFIELD("WriteBlend")         1, false, false, 104, 8,  1, 1,  0, 0}, // #221
  {DBGFIELD("WriteCLMulLd_ReadAfterLd") 2, false, false, 140, 10, 19, 1,  9, 1}, // #222
  {DBGFIELD("WriteCLMul")         1, false, false, 104, 8,  6, 1,  0, 0}, // #223
  {DBGFIELD("WritePCmpEStrILd_ReadAfterLd") 9, false, false, 496, 14, 72, 1,  9, 1}, // #224
  {DBGFIELD("WritePCmpEStrI")     8, false, false, 510, 12, 29, 1,  0, 0}, // #225
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterLd") 10, false, false, 522, 14, 34, 1,  9, 1}, // #226
  {DBGFIELD("WritePCmpEStrM")     9, false, false, 536, 12, 65, 1,  0, 0}, // #227
  {DBGFIELD("WritePCmpIStrILd_ReadAfterLd") 4, false, false, 548, 11,  8, 1,  9, 1}, // #228
  {DBGFIELD("WritePCmpIStrI")     3, false, false, 559, 9, 18, 1,  0, 0}, // #229
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterLd") 4, false, false, 548, 11,  8, 1,  9, 1}, // #230
  {DBGFIELD("WritePCmpIStrM")     3, false, false, 559, 9, 18, 1,  0, 0}, // #231
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterLd") 2, false, false, 490, 6, 10, 1,  9, 1}, // #232
  {DBGFIELD("WritePHAddXLd_ReadAfterLd") 4, false, false, 2067, 10,  9, 1,  9, 1}, // #233
  {DBGFIELD("WritePHAddX")        3, false, false, 2077, 8, 21, 1,  0, 0}, // #234
  {DBGFIELD("WritePHMINPOSLd")    2, false, false, 225, 11, 18, 1,  0, 0}, // #235
  {DBGFIELD("WritePHMINPOS")      1, false, false, 237, 9, 22, 1,  0, 0}, // #236
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterLd") 2, false, false, 490, 6,  9, 1,  9, 1}, // #237
  {DBGFIELD("WriteVecIMulXLd_ReadAfterLd") 2, false, false, 490, 6, 18, 1,  9, 1}, // #238
  {DBGFIELD("WriteVecIMulX")      1, false, false, 437, 4, 22, 1,  0, 0}, // #239
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, 237, 9, 20, 1,  0, 0}, // #240
  {DBGFIELD("WriteShuffleXLd")    2, false, false, 140, 10,  5, 1,  0, 0}, // #241
  {DBGFIELD("WritePMULLDLd_ReadAfterLd") 3, false, false, 1991, 6,  8, 1,  9, 1}, // #242
  {DBGFIELD("WritePMULLD")        2, false, false, 398, 4, 18, 1,  0, 0}, // #243
  {DBGFIELD("WriteRMW")           1, false, false, 97, 4,  1, 1,  0, 0}, // #244
  {DBGFIELD("WritePOPCNTLd")      2, false, false, 124, 9, 10, 1,  0, 0}, // #245
  {DBGFIELD("WritePOPCNT")        1, false, false, 133, 7, 21, 1,  0, 0}, // #246
  {DBGFIELD("WritePSADBWXLd_ReadAfterLd") 2, false, false, 140, 10,  9, 1,  9, 1}, // #247
  {DBGFIELD("WritePSADBWX")       1, false, false, 104, 8, 21, 1,  0, 0}, // #248
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1,  9, 1}, // #249
  {DBGFIELD("WriteVarShuffleX")   1, false, false, 104, 8,  1, 1,  0, 0}, // #250
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, 437, 4,  1, 1,  0, 0}, // #251
  {DBGFIELD("WriteVecShiftXLd_ReadAfterLd") 2, false, false, 490, 6,  5, 1,  9, 1}, // #252
  {DBGFIELD("WriteVecShiftX")     2, false, false, 2110, 9, 20, 1,  0, 0}, // #253
  {DBGFIELD("WriteVecTestLd_ReadAfterLd") 3, false, false, 588, 14,  9, 1,  9, 1}, // #254
  {DBGFIELD("WriteVecTest")       2, false, false, 381, 12, 21, 1,  0, 0}, // #255
  {DBGFIELD("WriteShiftLd_WriteRMW") 3, false, false, 602, 8, 63, 2,  0, 0}, // #256
  {DBGFIELD("WriteShift")         1, false, false, 93, 4,  1, 1,  0, 0}, // #257
  {DBGFIELD("WriteFRcpXLd")       2, false, false, 225, 11, 18, 1,  0, 0}, // #258
  {DBGFIELD("WriteFRcpX")         1, false, false, 237, 9, 22, 1,  0, 0}, // #259
  {DBGFIELD("WriteFRcpLd_ReadAfterLd") 2, false, false, 225, 11,  9, 1,  9, 1}, // #260
  {DBGFIELD("WriteFRcp")          1, false, false, 237, 9, 22, 1,  0, 0}, // #261
  {DBGFIELD("WriteShiftLd")       2, false, false, 87, 6,  6, 1,  0, 0}, // #262
  {DBGFIELD("WriteFRndLd")        3, false, false, 1991, 6, 25, 1,  0, 0}, // #263
  {DBGFIELD("WriteFRnd")          2, false, false, 398, 4, 10, 1,  0, 0}, // #264
  {DBGFIELD("WriteFRndLd_ReadAfterLd") 3, false, false, 1991, 6, 25, 1,  9, 1}, // #265
  {DBGFIELD("WriteFRsqrtXLd")     2, false, false, 225, 11, 18, 1,  0, 0}, // #266
  {DBGFIELD("WriteFRsqrtX")       1, false, false, 237, 9, 22, 1,  0, 0}, // #267
  {DBGFIELD("WriteFRsqrtLd_ReadAfterLd") 2, false, false, 225, 11,  9, 1,  9, 1}, // #268
  {DBGFIELD("WriteFRsqrt")        1, false, false, 237, 9, 22, 1,  0, 0}, // #269
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 87, 6,  6, 1, 10, 1}, // #270
  {DBGFIELD("WriteSETCCStore")    3, false, false, 619, 7, 20, 1,  0, 0}, // #271
  {DBGFIELD("WriteSETCC")         1, false, false, 93, 4,  1, 1,  0, 0}, // #272
  {DBGFIELD("WriteSHDmrcl")       6, false, false, 2119, 11, 26, 1,  0, 0}, // #273
  {DBGFIELD("WriteSHDmri")        4, false, false, 637, 9,  9, 1,  0, 0}, // #274
  {DBGFIELD("WriteSHDrrcl")       4, false, false, 2130, 9,  6, 1,  0, 0}, // #275
  {DBGFIELD("WriteSHDrri")        1, false, false, 133, 7, 21, 1,  0, 0}, // #276
  {DBGFIELD("WriteFSqrt64XLd")    2, false, false, 2139, 12, 72, 1,  0, 0}, // #277
  {DBGFIELD("WriteFSqrt64X")      1, false, false, 2151, 10, 29, 1,  0, 0}, // #278
  {DBGFIELD("WriteFSqrtXLd")      2, false, false, 2009, 12, 29, 1,  0, 0}, // #279
  {DBGFIELD("WriteFSqrtX")        1, false, false, 290, 10, 19, 1,  0, 0}, // #280
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterLd") 2, false, false, 2139, 12, 33, 1,  9, 1}, // #281
  {DBGFIELD("WriteFSqrt64")       1, false, false, 2151, 10, 29, 1,  0, 0}, // #282
  {DBGFIELD("WriteFSqrtLd_ReadAfterLd") 2, false, false, 2009, 12, 28, 1,  9, 1}, // #283
  {DBGFIELD("WriteFSqrt")         1, false, false, 290, 10, 19, 1,  0, 0}, // #284
  {DBGFIELD("WriteFSqrt80")       1, false, false, 689, 10, 31, 1,  0, 0}, // #285
  {DBGFIELD("WriteSTMXCSR")       3, false, false, 370, 11, 20, 1,  0, 0}, // #286
  {DBGFIELD("WriteTZCNTLd")       2, false, false, 124, 9, 10, 1,  0, 0}, // #287
  {DBGFIELD("WriteTZCNT")         1, false, false, 133, 7, 21, 1,  0, 0}, // #288
  {DBGFIELD("WriteFMAZLd")        2, false, false, 2085, 7, 26, 1,  0, 0}, // #289
  {DBGFIELD("WriteFMALd")         2, false, false, 490, 6,  9, 1,  0, 0}, // #290
  {DBGFIELD("WriteFAdd64YLd_ReadAfterLd") 2, false, false, 490, 6, 26, 1,  9, 1}, // #291
  {DBGFIELD("WriteFAdd64Y")       1, false, false, 437, 4, 22, 1,  0, 0}, // #292
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterLd") 2, false, false, 2085, 7, 26, 1,  9, 1}, // #293
  {DBGFIELD("WriteFAdd64Z")       1, false, false, 1954, 5, 22, 1,  0, 0}, // #294
  {DBGFIELD("WriteFAddYLd_ReadAfterLd") 2, false, false, 490, 6, 26, 1,  9, 1}, // #295
  {DBGFIELD("WriteFAddY")         1, false, false, 437, 4, 22, 1,  0, 0}, // #296
  {DBGFIELD("WriteFAddZLd_ReadAfterLd") 2, false, false, 2085, 7, 26, 1,  9, 1}, // #297
  {DBGFIELD("WriteFAddZ")         1, false, false, 1954, 5, 22, 1,  0, 0}, // #298
  {DBGFIELD("WriteShuffleYLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1,  9, 1}, // #299
  {DBGFIELD("WriteShuffleY")      1, false, false, 104, 8,  1, 1,  0, 0}, // #300
  {DBGFIELD("WriteShuffleZLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1,  9, 1}, // #301
  {DBGFIELD("WriteShuffleZ")      1, false, false, 104, 8,  1, 1,  0, 0}, // #302
  {DBGFIELD("WriteFLogicYLd_ReadAfterLd") 2, false, false, 128, 5, 10, 1,  9, 1}, // #303
  {DBGFIELD("WriteFLogicY")       1, false, false, 78, 3,  1, 1,  0, 0}, // #304
  {DBGFIELD("WriteFLogicZLd_ReadAfterLd") 2, false, false, 2085, 7, 10, 1,  9, 1}, // #305
  {DBGFIELD("WriteFLogicZ")       1, false, false, 1954, 5,  1, 1,  0, 0}, // #306
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterLd") 3, false, false, 614, 5,  9, 1,  9, 1}, // #307
  {DBGFIELD("WriteFVarBlendY")    2, false, false, 399, 3, 20, 1,  0, 0}, // #308
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterLd") 3, false, false, 614, 5,  9, 1,  9, 1}, // #309
  {DBGFIELD("WriteFVarBlendZ")    2, false, false, 399, 3, 20, 1,  0, 0}, // #310
  {DBGFIELD("WriteFBlendYLd_ReadAfterLd") 2, false, false, 128, 5, 10, 1,  9, 1}, // #311
  {DBGFIELD("WriteFBlendY")       1, false, false, 78, 3,  1, 1,  0, 0}, // #312
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 614, 5,  9, 1, 13, 2}, // #313
  {DBGFIELD("WriteFVarBlendLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 614, 5, 10, 1, 13, 2}, // #314
  {DBGFIELD("WriteShuffle256Ld")  2, false, false, 140, 10, 18, 1,  0, 0}, // #315
  {DBGFIELD("WriteShuffle256")    1, false, false, 104, 8, 21, 1,  0, 0}, // #316
  {DBGFIELD("WriteShuffleYLd")    2, false, false, 140, 10, 10, 1,  0, 0}, // #317
  {DBGFIELD("WriteFShuffle256")   1, false, false, 104, 8, 21, 1,  0, 0}, // #318
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, 140, 10, 18, 1,  0, 0}, // #319
  {DBGFIELD("WriteFCmp64YLd_ReadAfterLd") 2, false, false, 490, 6, 26, 1,  9, 1}, // #320
  {DBGFIELD("WriteFCmp64Y")       1, false, false, 437, 4, 22, 1,  0, 0}, // #321
  {DBGFIELD("WriteFCmpYLd_ReadAfterLd") 2, false, false, 490, 6, 26, 1,  9, 1}, // #322
  {DBGFIELD("WriteFCmpY")         1, false, false, 437, 4, 22, 1,  0, 0}, // #323
  {DBGFIELD("WriteFCmpZLd_ReadAfterLd") 2, false, false, 2085, 7, 26, 1,  9, 1}, // #324
  {DBGFIELD("WriteFCmpZ")         1, false, false, 1954, 5, 22, 1,  0, 0}, // #325
  {DBGFIELD("WriteVarShuffle256Ld") 2, false, false, 140, 10, 18, 1,  0, 0}, // #326
  {DBGFIELD("WriteVarShuffle256") 1, false, false, 104, 8, 21, 1,  0, 0}, // #327
  {DBGFIELD("WriteCvtI2PDYLd")    2, false, false, 490, 6,  9, 1,  0, 0}, // #328
  {DBGFIELD("WriteCvtI2PDY")      1, false, false, 437, 4, 22, 1,  0, 0}, // #329
  {DBGFIELD("WriteCvtI2PDZLd")    2, false, false, 2085, 7,  9, 1,  0, 0}, // #330
  {DBGFIELD("WriteCvtI2PDZ")      1, false, false, 1954, 5, 22, 1,  0, 0}, // #331
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, 490, 6,  9, 1,  0, 0}, // #332
  {DBGFIELD("WriteCvtI2PSY")      1, false, false, 437, 4, 22, 1,  0, 0}, // #333
  {DBGFIELD("WriteCvtI2PSZLd")    2, false, false, 2085, 7,  9, 1,  0, 0}, // #334
  {DBGFIELD("WriteCvtI2PSZ")      1, false, false, 1954, 5, 22, 1,  0, 0}, // #335
  {DBGFIELD("WriteCvtPD2IYLd")    2, false, false, 490, 6, 10, 1,  0, 0}, // #336
  {DBGFIELD("WriteCvtPD2IY")      1, false, false, 437, 4, 21, 1,  0, 0}, // #337
  {DBGFIELD("WriteCvtPD2IZLd")    2, false, false, 2085, 7, 10, 1,  0, 0}, // #338
  {DBGFIELD("WriteCvtPD2IZ")      1, false, false, 1954, 5, 21, 1,  0, 0}, // #339
  {DBGFIELD("WriteCvtPD2PSYLd")   3, false, false, 2161, 11, 10, 1,  0, 0}, // #340
  {DBGFIELD("WriteCvtPD2PSY")     2, false, false, 2110, 9, 21, 1,  0, 0}, // #341
  {DBGFIELD("WriteCvtPD2PSZLd")   3, false, false, 2172, 7, 10, 1,  0, 0}, // #342
  {DBGFIELD("WriteCvtPD2PSZ")     2, false, false, 2062, 5, 21, 1,  0, 0}, // #343
  {DBGFIELD("WriteCvtPH2PSYLd")   2, false, false, 490, 6, 18, 1,  0, 0}, // #344
  {DBGFIELD("WriteCvtPH2PSY")     2, false, false, 2110, 9,  5, 1,  0, 0}, // #345
  {DBGFIELD("WriteCvtPH2PSLd")    2, false, false, 490, 6,  9, 1,  0, 0}, // #346
  {DBGFIELD("WriteCvtPH2PS")      2, false, false, 2110, 9,  7, 1,  0, 0}, // #347
  {DBGFIELD("WriteCvtPH2PSZLd")   2, false, false, 2085, 7, 18, 1,  0, 0}, // #348
  {DBGFIELD("WriteCvtPH2PSZ")     2, false, false, 381, 12,  5, 1,  0, 0}, // #349
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, 490, 6, 10, 1,  0, 0}, // #350
  {DBGFIELD("WriteCvtPS2IY")      1, false, false, 437, 4, 21, 1,  0, 0}, // #351
  {DBGFIELD("WriteCvtPS2IZLd")    2, false, false, 2085, 7, 10, 1,  0, 0}, // #352
  {DBGFIELD("WriteCvtPS2IZ")      1, false, false, 1954, 5, 21, 1,  0, 0}, // #353
  {DBGFIELD("WriteCvtPS2PDYLd")   3, false, false, 2161, 11, 10, 1,  0, 0}, // #354
  {DBGFIELD("WriteCvtPS2PDY")     2, false, false, 2110, 9, 21, 1,  0, 0}, // #355
  {DBGFIELD("WriteCvtPS2PDZLd")   3, false, false, 2172, 7, 10, 1,  0, 0}, // #356
  {DBGFIELD("WriteCvtPS2PDZ")     2, false, false, 2062, 5, 21, 1,  0, 0}, // #357
  {DBGFIELD("WriteCvtPS2PHYSt")   4, false, false, 2179, 12, 10, 1,  0, 0}, // #358
  {DBGFIELD("WriteCvtPS2PHY")     2, false, false, 2110, 9,  5, 1,  0, 0}, // #359
  {DBGFIELD("WriteCvtPS2PHSt")    4, false, false, 2179, 12,  6, 1,  0, 0}, // #360
  {DBGFIELD("WriteCvtPS2PH")      2, false, false, 2110, 9,  7, 1,  0, 0}, // #361
  {DBGFIELD("WriteCvtPS2PHZSt")   4, false, false, 2191, 11, 10, 1,  0, 0}, // #362
  {DBGFIELD("WriteCvtPS2PHZ")     2, false, false, 2202, 8,  5, 1,  0, 0}, // #363
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterLd") 3, false, false, 1991, 6, 26, 1,  9, 1}, // #364
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterLd") 3, false, false, 1991, 6, 26, 1,  9, 1}, // #365
  {DBGFIELD("WritePSADBWYLd_ReadAfterLd") 2, false, false, 140, 10, 18, 1,  9, 1}, // #366
  {DBGFIELD("WritePSADBWY")       1, false, false, 104, 8, 21, 1,  0, 0}, // #367
  {DBGFIELD("WritePSADBWZLd_ReadAfterLd") 2, false, false, 140, 10, 18, 1,  9, 1}, // #368
  {DBGFIELD("WritePSADBWZ")       1, false, false, 104, 8, 21, 1,  0, 0}, // #369
  {DBGFIELD("WriteFDiv64YLd_ReadAfterLd") 2, false, false, 246, 12, 31, 1,  9, 1}, // #370
  {DBGFIELD("WriteFDiv64Y")       1, false, false, 280, 10, 25, 1,  0, 0}, // #371
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterLd") 4, false, false, 2210, 15, 37, 1,  9, 1}, // #372
  {DBGFIELD("WriteFDiv64Z")       3, false, false, 2225, 13, 33, 1,  0, 0}, // #373
  {DBGFIELD("WriteFDivYLd_ReadAfterLd") 2, false, false, 268, 12, 29, 1,  9, 1}, // #374
  {DBGFIELD("WriteFDivY")         1, false, false, 280, 10, 26, 1,  0, 0}, // #375
  {DBGFIELD("WriteFDivZLd_ReadAfterLd") 4, false, false, 2238, 15, 34, 1,  9, 1}, // #376
  {DBGFIELD("WriteFDivZ")         3, false, false, 2253, 13, 29, 1,  0, 0}, // #377
  {DBGFIELD("WriteDPPSYLd_ReadAfterLd") 5, false, false, 2039, 10, 30, 1,  9, 1}, // #378
  {DBGFIELD("WriteDPPSY")         4, false, false, 2049, 8, 27, 1,  0, 0}, // #379
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterLd") 2, false, false, 140, 10, 18, 1,  9, 1}, // #380
  {DBGFIELD("WriteFMAYLd_ReadAfterLd_ReadAfterLd") 2, false, false, 490, 6, 26, 1, 15, 2}, // #381
  {DBGFIELD("WriteFMAY")          1, false, false, 437, 4, 22, 1,  0, 0}, // #382
  {DBGFIELD("WriteFMAXLd_ReadAfterLd") 2, false, false, 490, 6, 18, 1,  9, 1}, // #383
  {DBGFIELD("WriteFMAX")          1, false, false, 437, 4, 22, 1,  0, 0}, // #384
  {DBGFIELD("WriteFMAYLd_ReadAfterLd") 2, false, false, 490, 6, 26, 1,  9, 1}, // #385
  {DBGFIELD("WriteFMAZLd_ReadAfterLd") 2, false, false, 2085, 7, 26, 1,  9, 1}, // #386
  {DBGFIELD("WriteFMAZ")          1, false, false, 1954, 5, 22, 1,  0, 0}, // #387
  {DBGFIELD("WriteFMAXLd_ReadAfterLd_ReadAfterLd") 2, false, false, 490, 6, 18, 1, 15, 2}, // #388
  {DBGFIELD("WriteFMALd_ReadAfterLd") 2, false, false, 490, 6,  9, 1,  9, 1}, // #389
  {DBGFIELD("WriteFMA")           1, false, false, 437, 4, 22, 1,  0, 0}, // #390
  {DBGFIELD("WriteFMALd_ReadAfterLd_ReadAfterLd") 2, false, false, 490, 6,  9, 1, 15, 2}, // #391
  {DBGFIELD("WriteFMAYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 490, 6, 26, 1, 13, 2}, // #392
  {DBGFIELD("WriteFMAXLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 490, 6, 18, 1, 13, 2}, // #393
  {DBGFIELD("WriteFMALd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 490, 6,  9, 1, 13, 2}, // #394
  {DBGFIELD("WriteFRndYLd_ReadAfterLd") 3, false, false, 1991, 6, 24, 1,  9, 1}, // #395
  {DBGFIELD("WriteFRndY")         2, false, false, 398, 4, 10, 1,  0, 0}, // #396
  {DBGFIELD("WriteFRndZLd_ReadAfterLd") 3, false, false, 2172, 7, 24, 1,  9, 1}, // #397
  {DBGFIELD("WriteFRndZ")         2, false, false, 2062, 5, 10, 1,  0, 0}, // #398
  {DBGFIELD("WriteVecIMulYLd_ReadAfterLd") 2, false, false, 490, 6, 26, 1,  9, 1}, // #399
  {DBGFIELD("WriteVecIMulY")      1, false, false, 437, 4, 22, 1,  0, 0}, // #400
  {DBGFIELD("WriteVecIMulZLd_ReadAfterLd") 2, false, false, 2085, 7, 26, 1,  9, 1}, // #401
  {DBGFIELD("WriteVecIMulZ")      1, false, false, 1954, 5, 22, 1,  0, 0}, // #402
  {DBGFIELD("WriteVecALUYLd_ReadAfterLd") 2, false, false, 490, 6, 10, 1,  9, 1}, // #403
  {DBGFIELD("WriteVecALUY")       1, false, false, 437, 4,  1, 1,  0, 0}, // #404
  {DBGFIELD("WriteVecALUZLd_ReadAfterLd") 2, false, false, 225, 11, 10, 1,  9, 1}, // #405
  {DBGFIELD("WriteVecALUZ")       1, false, false, 237, 9,  1, 1,  0, 0}, // #406
  {DBGFIELD("WriteFHAddYLd_ReadAfterLd") 4, false, false, 2067, 10, 27, 1,  9, 1}, // #407
  {DBGFIELD("WriteFHAddY")        3, false, false, 2077, 8,  6, 1,  0, 0}, // #408
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterLd") 2, false, false, 140, 10, 18, 1,  9, 1}, // #409
  {DBGFIELD("WriteShuffle256Ld_ReadAfterLd") 2, false, false, 140, 10, 18, 1,  9, 1}, // #410
  {DBGFIELD("WriteVecLoadY")      1, false, false, 101, 3,  5, 1,  0, 0}, // #411
  {DBGFIELD("WriteFMaskedStoreY") 2, false, false, 2266, 10, 20, 1,  0, 0}, // #412
  {DBGFIELD("WriteFMaskedLoadY")  2, false, false, 128, 5, 10, 1,  0, 0}, // #413
  {DBGFIELD("WriteFMaskedStore")  2, false, false, 2266, 10, 20, 1,  0, 0}, // #414
  {DBGFIELD("WriteFMaskedLoad")   2, false, false, 128, 5,  5, 1,  0, 0}, // #415
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterLd") 2, false, false, 2085, 7, 26, 1,  9, 1}, // #416
  {DBGFIELD("WriteFCmp64Z")       1, false, false, 1954, 5, 22, 1,  0, 0}, // #417
  {DBGFIELD("WriteFMoveY")        1, false, false, 78, 3,  1, 1,  0, 0}, // #418
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, 140, 10, 10, 1,  0, 0}, // #419
  {DBGFIELD("WriteFShuffleY")     1, false, false, 104, 8,  1, 1,  0, 0}, // #420
  {DBGFIELD("WriteFShuffleZLd")   2, false, false, 140, 10, 10, 1,  0, 0}, // #421
  {DBGFIELD("WriteFShuffleZ")     1, false, false, 104, 8,  1, 1,  0, 0}, // #422
  {DBGFIELD("WriteVecStoreY")     2, false, false, 97, 4,  1, 1,  0, 0}, // #423
  {DBGFIELD("WriteVecMoveY")      1, false, false, 78, 3,  1, 1,  0, 0}, // #424
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, 101, 3,  5, 1,  0, 0}, // #425
  {DBGFIELD("WriteVecStoreNTY")   2, false, false, 97, 4,  1, 1,  0, 0}, // #426
  {DBGFIELD("WriteFStoreNTY")     2, false, false, 97, 4,  1, 1,  0, 0}, // #427
  {DBGFIELD("WriteMPSADYLd_ReadAfterLd") 3, false, false, 150, 10, 26, 1,  9, 1}, // #428
  {DBGFIELD("WriteMPSADY")        2, false, false, 160, 8, 22, 1,  0, 0}, // #429
  {DBGFIELD("WriteFMul64YLd_ReadAfterLd") 2, false, false, 490, 6, 26, 1,  9, 1}, // #430
  {DBGFIELD("WriteFMul64Y")       1, false, false, 437, 4, 22, 1,  0, 0}, // #431
  {DBGFIELD("WriteFMul64ZLd_ReadAfterLd") 2, false, false, 2085, 7, 26, 1,  9, 1}, // #432
  {DBGFIELD("WriteFMul64Z")       1, false, false, 1954, 5, 22, 1,  0, 0}, // #433
  {DBGFIELD("WriteFMulYLd_ReadAfterLd") 2, false, false, 490, 6, 26, 1,  9, 1}, // #434
  {DBGFIELD("WriteFMulY")         1, false, false, 437, 4, 22, 1,  0, 0}, // #435
  {DBGFIELD("WriteFMulZLd_ReadAfterLd") 2, false, false, 2085, 7, 26, 1,  9, 1}, // #436
  {DBGFIELD("WriteFMulZ")         1, false, false, 1954, 5, 22, 1,  0, 0}, // #437
  {DBGFIELD("WriteVecALUYLd")     2, false, false, 490, 6, 10, 1,  0, 0}, // #438
  {DBGFIELD("WriteVecALUZLd")     2, false, false, 225, 11, 10, 1,  0, 0}, // #439
  {DBGFIELD("WriteVecLogicYLd_ReadAfterLd") 2, false, false, 128, 5, 10, 1,  9, 1}, // #440
  {DBGFIELD("WriteVecLogicY")     1, false, false, 78, 3,  1, 1,  0, 0}, // #441
  {DBGFIELD("WriteVecLogicZLd_ReadAfterLd") 2, false, false, 2085, 7, 10, 1,  9, 1}, // #442
  {DBGFIELD("WriteVecLogicZ")     1, false, false, 1954, 5,  1, 1,  0, 0}, // #443
  {DBGFIELD("WriteBlendYLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1,  9, 1}, // #444
  {DBGFIELD("WriteBlendY")        1, false, false, 104, 8,  1, 1,  0, 0}, // #445
  {DBGFIELD("WriteVarBlendYLd_ReadAfterLd") 3, false, false, 614, 5, 10, 1,  9, 1}, // #446
  {DBGFIELD("WriteVarBlendY")     2, false, false, 399, 3, 20, 1,  0, 0}, // #447
  {DBGFIELD("WriteVarBlendZLd_ReadAfterLd") 2, false, false, 2085, 7, 10, 1,  9, 1}, // #448
  {DBGFIELD("WriteVarBlendZ")     1, false, false, 1954, 5, 20, 1,  0, 0}, // #449
  {DBGFIELD("WriteVarBlendYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 614, 5, 10, 1, 13, 2}, // #450
  {DBGFIELD("WriteVarBlendLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 614, 5, 10, 1, 13, 2}, // #451
  {DBGFIELD("WriteShuffleYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 140, 10, 10, 1, 13, 2}, // #452
  {DBGFIELD("WriteShuffleYLd_ReadAfterLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1, 15, 2}, // #453
  {DBGFIELD("WriteShuffleXLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 140, 10,  5, 1, 13, 2}, // #454
  {DBGFIELD("WriteShuffleXLd_ReadAfterLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1, 15, 2}, // #455
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterLd") 2, false, false, 140, 10, 18, 1,  9, 1}, // #456
  {DBGFIELD("WriteFVarShuffle256") 1, false, false, 104, 8, 21, 1,  0, 0}, // #457
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 140, 10, 10, 1, 13, 2}, // #458
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1, 15, 2}, // #459
  {DBGFIELD("WriteFVarShuffleY")  1, false, false, 104, 8,  1, 1,  0, 0}, // #460
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 140, 10,  5, 1, 13, 2}, // #461
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1, 15, 2}, // #462
  {DBGFIELD("WriteFVarShuffle")   1, false, false, 104, 8,  1, 1,  0, 0}, // #463
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1,  9, 1}, // #464
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1,  9, 1}, // #465
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1,  9, 1}, // #466
  {DBGFIELD("WriteFVarShuffleZ")  1, false, false, 104, 8,  1, 1,  0, 0}, // #467
  {DBGFIELD("WritePHAddYLd_ReadAfterLd") 4, false, false, 2067, 10, 18, 1,  9, 1}, // #468
  {DBGFIELD("WritePHAddY")        3, false, false, 2077, 8, 21, 1,  0, 0}, // #469
  {DBGFIELD("WriteVecIMulXLd")    2, false, false, 490, 6, 18, 1,  0, 0}, // #470
  {DBGFIELD("WriteVecIMulYLd")    2, false, false, 490, 6, 26, 1,  0, 0}, // #471
  {DBGFIELD("WriteVecIMulZLd")    2, false, false, 2085, 7, 26, 1,  0, 0}, // #472
  {DBGFIELD("WriteVecMaskedStoreY") 2, false, false, 2266, 10, 20, 1,  0, 0}, // #473
  {DBGFIELD("WriteVecMaskedLoadY") 2, false, false, 128, 5, 10, 1,  0, 0}, // #474
  {DBGFIELD("WriteVecMaskedStore") 2, false, false, 2266, 10, 20, 1,  0, 0}, // #475
  {DBGFIELD("WriteVecMaskedLoad") 2, false, false, 128, 5,  5, 1,  0, 0}, // #476
  {DBGFIELD("WriteVecMOVMSKY")    1, false, false, 237, 9, 20, 1,  0, 0}, // #477
  {DBGFIELD("WritePMULLDYLd_ReadAfterLd") 3, false, false, 1991, 6, 28, 1,  9, 1}, // #478
  {DBGFIELD("WritePMULLDY")       2, false, false, 398, 4, 18, 1,  0, 0}, // #479
  {DBGFIELD("WritePMULLDZLd_ReadAfterLd") 3, false, false, 2172, 7, 28, 1,  9, 1}, // #480
  {DBGFIELD("WritePMULLDZ")       2, false, false, 2062, 5, 18, 1,  0, 0}, // #481
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 140, 10,  5, 1, 13, 2}, // #482
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1, 15, 2}, // #483
  {DBGFIELD("WriteVecShiftImmXLd") 2, false, false, 490, 6,  5, 1,  0, 0}, // #484
  {DBGFIELD("WriteVecShiftImmYLd") 2, false, false, 490, 6, 10, 1,  0, 0}, // #485
  {DBGFIELD("WriteVecShiftImmY")  1, false, false, 437, 4,  1, 1,  0, 0}, // #486
  {DBGFIELD("WriteVecShiftImmZLd") 2, false, false, 225, 11, 10, 1,  0, 0}, // #487
  {DBGFIELD("WriteVecShiftImmZ")  1, false, false, 237, 9,  1, 1,  0, 0}, // #488
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterLd") 2, false, false, 490, 6,  5, 1,  9, 1}, // #489
  {DBGFIELD("WriteVarVecShift")   1, false, false, 437, 4,  1, 1,  0, 0}, // #490
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterLd") 2, false, false, 490, 6, 10, 1,  9, 1}, // #491
  {DBGFIELD("WriteVarVecShiftY")  1, false, false, 437, 4,  1, 1,  0, 0}, // #492
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterLd") 2, false, false, 225, 11, 10, 1,  9, 1}, // #493
  {DBGFIELD("WriteVarVecShiftZ")  1, false, false, 237, 9,  1, 1,  0, 0}, // #494
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterLd") 2, false, false, 490, 6,  5, 1,  9, 1}, // #495
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1,  9, 1}, // #496
  {DBGFIELD("WriteVarShuffleY")   1, false, false, 104, 8,  1, 1,  0, 0}, // #497
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1,  9, 1}, // #498
  {DBGFIELD("WriteVarShuffleZ")   1, false, false, 104, 8,  1, 1,  0, 0}, // #499
  {DBGFIELD("WriteShuffleZLd")    2, false, false, 140, 10, 10, 1,  0, 0}, // #500
  {DBGFIELD("WriteVecShiftYLd_ReadAfterLd") 2, false, false, 490, 6, 10, 1,  9, 1}, // #501
  {DBGFIELD("WriteVecShiftY")     2, false, false, 2110, 9, 22, 1,  0, 0}, // #502
  {DBGFIELD("WriteVecShiftZLd_ReadAfterLd") 2, false, false, 225, 11, 10, 1,  9, 1}, // #503
  {DBGFIELD("WriteVecShiftZ")     2, false, false, 381, 12, 22, 1,  0, 0}, // #504
  {DBGFIELD("WriteVecTestYLd_ReadAfterLd") 3, false, false, 588, 14, 18, 1,  9, 1}, // #505
  {DBGFIELD("WriteVecTestY")      2, false, false, 381, 12, 21, 1,  0, 0}, // #506
  {DBGFIELD("WriteFRcpXLd_ReadAfterLd") 2, false, false, 225, 11, 18, 1,  9, 1}, // #507
  {DBGFIELD("WriteFRcpYLd_ReadAfterLd") 2, false, false, 225, 11, 26, 1,  9, 1}, // #508
  {DBGFIELD("WriteFRcpY")         1, false, false, 237, 9, 22, 1,  0, 0}, // #509
  {DBGFIELD("WriteFRcpZLd_ReadAfterLd") 4, false, false, 786, 14, 26, 1,  9, 1}, // #510
  {DBGFIELD("WriteFRcpZ")         3, false, false, 800, 12, 22, 1,  0, 0}, // #511
  {DBGFIELD("WriteFRcpYLd")       2, false, false, 225, 11, 26, 1,  0, 0}, // #512
  {DBGFIELD("WriteFRndYLd")       3, false, false, 1991, 6, 24, 1,  0, 0}, // #513
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterLd") 2, false, false, 225, 11, 18, 1,  9, 1}, // #514
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterLd") 2, false, false, 225, 11, 26, 1,  9, 1}, // #515
  {DBGFIELD("WriteFRsqrtY")       1, false, false, 237, 9, 22, 1,  0, 0}, // #516
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterLd") 4, false, false, 786, 14,  8, 1,  9, 1}, // #517
  {DBGFIELD("WriteFRsqrtZ")       3, false, false, 800, 12,  9, 1,  0, 0}, // #518
  {DBGFIELD("WriteFRsqrtYLd")     2, false, false, 225, 11, 26, 1,  0, 0}, // #519
  {DBGFIELD("WriteFShuffleYLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1,  9, 1}, // #520
  {DBGFIELD("WriteFShuffleZLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1,  9, 1}, // #521
  {DBGFIELD("WriteFSqrt64YLd")    2, false, false, 2276, 12, 34, 1,  0, 0}, // #522
  {DBGFIELD("WriteFSqrt64Y")      1, false, false, 2288, 10, 29, 1,  0, 0}, // #523
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterLd") 2, false, false, 2139, 12, 72, 1,  9, 1}, // #524
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterLd") 2, false, false, 2276, 12, 34, 1,  9, 1}, // #525
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterLd") 4, false, false, 2298, 15, 96, 1,  9, 1}, // #526
  {DBGFIELD("WriteFSqrt64Z")      3, false, false, 2313, 13, 38, 1,  0, 0}, // #527
  {DBGFIELD("WriteFSqrtYLd")      2, false, false, 2139, 12, 65, 1,  0, 0}, // #528
  {DBGFIELD("WriteFSqrtY")        1, false, false, 2151, 10, 19, 1,  0, 0}, // #529
  {DBGFIELD("WriteFSqrtXLd_ReadAfterLd") 2, false, false, 2009, 12, 29, 1,  9, 1}, // #530
  {DBGFIELD("WriteFSqrtYLd_ReadAfterLd") 2, false, false, 2139, 12, 65, 1,  9, 1}, // #531
  {DBGFIELD("WriteFSqrtZLd_ReadAfterLd") 4, false, false, 2326, 15, 74, 1,  9, 1}, // #532
  {DBGFIELD("WriteFSqrtZ")        3, false, false, 2341, 13, 30, 1,  0, 0}, // #533
  {DBGFIELD("WriteFTestYLd_ReadAfterLd") 2, false, false, 225, 11,  9, 1,  9, 1}, // #534
  {DBGFIELD("WriteFTestY")        1, false, false, 237, 9, 20, 1,  0, 0}, // #535
  {DBGFIELD("WriteFTestLd_ReadAfterLd") 2, false, false, 225, 11, 10, 1,  9, 1}, // #536
  {DBGFIELD("WriteFTest")         1, false, false, 237, 9, 20, 1,  0, 0}, // #537
  {DBGFIELD("MUL16m_IMUL16m")     5, false, false, 856, 11,  9, 1,  0, 0}, // #538
  {DBGFIELD("MUL32r_IMUL32r")     3, false, false, 867, 9, 22, 1,  0, 0}, // #539
  {DBGFIELD("IMUL64rri8_IMUL64rri32") 1, false, false, 133, 7, 21, 1,  0, 0}, // #540
  {DBGFIELD("IMUL64rmi8_IMUL64rmi32") 2, false, false, 124, 9, 10, 1,  0, 0}, // #541
  {DBGFIELD("COPY")               0, false, false,  0, 0,  0, 0,  0, 0}, // #542
  {DBGFIELD("FXAM")               1, false, false, 79, 2,  4, 1,  0, 0}, // #543
  {DBGFIELD("LD_Frr")             1, false, false, 79, 2,  1, 1,  0, 0}, // #544
  {DBGFIELD("MOVSX64rr32")        1, false, false, 79, 2,  1, 1,  0, 0}, // #545
  {DBGFIELD("RCL16m1_RCL16mCL_RCL16mi_RCL32m1_RCL32mCL_RCL32mi_RCL64m1_RCL64mCL_RCL64mi_RCL8m1_RCL8mCL_RCL8mi_RCR16m1_RCR16mCL_RCR16mi_RCR32m1_RCR32mCL_RCR32mi_RCR64m1_RCR64mCL_RCR64mi_RCR8m1_RCR8mCL_RCR8mi_ROL16m1_ROL16mCL_ROL16mi_ROL32m1_ROL32mCL_ROL32mi_ROL64m1_ROL64mCL_ROL64mi_ROL8m1_ROL8mCL_ROL8mi_ROR16m1_ROR16mCL_ROR16mi_ROR32m1_ROR32mCL_ROR32mi_ROR64m1_ROR64mCL_ROR64mi_ROR8m1_ROR8mCL_ROR8mi_SAR16m1_SAR16mCL_SAR16mi_SAR32m1_SAR32mCL_SAR32mi_SAR64m1_SAR64mCL_SAR64mi_SAR8m1_SAR8mCL_SAR8mi_SHL16m1_SHL16mCL_SHL16mi_SHL32m1_SHL32mCL_SHL32mi_SHL64m1_SHL64mCL_SHL64mi_SHL8m1_SHL8mCL_SHL8mi_SHR16m1_SHR16mCL_SHR16mi_SHR32m1_SHR32mCL_SHR32mi_SHR64m1_SHR64mCL_SHR64mi_SHR8m1_SHR8mCL_SHR8mi") 11, false, false, 2354, 11, 29, 1,  0, 0}, // #546
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, 79, 2,  1, 1,  0, 0}, // #547
  {DBGFIELD("IMUL32rm")           2, false, false, 124, 9, 10, 1,  9, 1}, // #548
  {DBGFIELD("IMUL32rmi_IMUL32rmi8") 2, false, false, 124, 9, 10, 1,  0, 0}, // #549
  {DBGFIELD("IMUL32rr_IMUL32rri_IMUL32rri8") 1, false, false, 133, 7, 21, 1,  0, 0}, // #550
  {DBGFIELD("FCOMPP")             1, false, false, 79, 2,  4, 1,  0, 0}, // #551
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, 237, 9, 20, 1,  0, 0}, // #552
  {DBGFIELD("BT16ri8_BT16rr_BT32ri8_BT32rr_BT64ri8_BT64rr_BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 1, false, false, 93, 4,  1, 1,  0, 0}, // #553
  {DBGFIELD("MMX_CVTPI2PSirr")    2, false, false, 160, 8,  6, 1,  0, 0}, // #554
  {DBGFIELD("MMX_CVTPI2PSirm")    2, false, false, 225, 11,  9, 1,  0, 0}, // #555
  {DBGFIELD("MMX_CVTPS2PIirr_MMX_CVTTPS2PIirr") 2, false, false, 2365, 8,  7, 1,  0, 0}, // #556
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 2, false, false, 120, 4,  6, 1,  0, 0}, // #557
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, 97, 4,  1, 1,  0, 0}, // #558
  {DBGFIELD("XCH_F")              15, false, false, 2373, 15, 28, 1,  0, 0}, // #559
  {DBGFIELD("RETIL_RETIQ_RETIW_IRET_IRET16_IRET32_IRET64") 2, false, false, 87, 6,  6, 1,  0, 0}, // #560
  {DBGFIELD("MMX_CVTPS2PIirm_MMX_CVTTPS2PIirm") 2, false, false, 128, 5,  9, 1,  0, 0}, // #561
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 2, false, false, 140, 10, 18, 1,  0, 0}, // #562
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 2, false, false, 166, 2, 20, 1,  0, 0}, // #563
  {DBGFIELD("LFENCE")             2, false, false, 166, 2, 20, 1,  0, 0}, // #564
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, 104, 8,  1, 1,  0, 0}, // #565
  {DBGFIELD("PSLLDQri_PSRLDQri")  1, false, false, 104, 8,  1, 1,  0, 0}, // #566
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr_MMX_PUNPCKHBWirr_MMX_PUNPCKHDQirr_MMX_PUNPCKHWDirr") 1, false, false, 104, 8,  1, 1,  0, 0}, // #567
  {DBGFIELD("LEAVE_LEAVE64")      3, false, false, 901, 4,  5, 1,  0, 0}, // #568
  {DBGFIELD("POP16r")             2, false, false, 120, 4,  6, 1,  0, 0}, // #569
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 4, false, false, 81, 6,  6, 1,  0, 0}, // #570
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false, 79, 2,  4, 1,  0, 0}, // #571
  {DBGFIELD("BTC16mi8_BTC32mi8_BTC64mi8_BTR16mi8_BTR32mi8_BTR64mi8_BTS16mi8_BTS32mi8_BTS64mi8") 4, false, false, 602, 8,  6, 1,  0, 0}, // #572
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, 79, 2,  4, 1,  0, 0}, // #573
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr_XCHG16ar_XCHG16rr_XCHG32ar_XCHG32rr_XCHG64ar_XCHG64rr_XCHG8rr_MOVSX16rr8_MOVZX16rr8") 1, false, false, 79, 2,  1, 1,  0, 0}, // #574
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, 97, 4,  1, 1,  0, 0}, // #575
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, 79, 2,  1, 1,  0, 0}, // #576
  {DBGFIELD("MMX_PADDQirr_MMX_PSUBQirr") 1, false, false, 1954, 5,  1, 1,  0, 0}, // #577
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 2, false, false, 97, 4,  1, 1,  0, 0}, // #578
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  2, false, false, 97, 4,  1, 1,  0, 0}, // #579
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, 78, 3,  1, 1,  0, 0}, // #580
  {DBGFIELD("CLD")                3, false, false, 905, 7, 21, 1,  0, 0}, // #581
  {DBGFIELD("LDDQUrm")            1, false, false, 101, 3,  6, 1,  0, 0}, // #582
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, 79, 2,  4, 1,  0, 0}, // #583
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 4, false, false, 81, 6,  6, 1,  0, 0}, // #584
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 8, false, false, 2388, 11, 18, 1,  0, 0}, // #585
  {DBGFIELD("PHADDDrr_PHSUBDrr")  3, false, false, 2077, 8, 21, 1,  0, 0}, // #586
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, 101, 3,  7, 1,  0, 0}, // #587
  {DBGFIELD("MMX_PADDQirm_MMX_PSUBQirm") 2, false, false, 2085, 7,  6, 1,  9, 1}, // #588
  {DBGFIELD("MOVDQUrm")           1, false, false, 101, 3,  6, 1,  0, 0}, // #589
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, 101, 3,  6, 1,  0, 0}, // #590
  {DBGFIELD("PADDQrm_PSUBQrm")    2, false, false, 128, 5,  5, 1,  0, 0}, // #591
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, 79, 2,  1, 1,  0, 0}, // #592
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   2, false, false, 220, 4, 20, 1,  0, 0}, // #593
  {DBGFIELD("LD_F80m")            1, false, false, 101, 3,  5, 1,  0, 0}, // #594
  {DBGFIELD("PHADDDrm_PHSUBDrm")  4, false, false, 2067, 10,  9, 1,  9, 1}, // #595
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 2, false, false, 381, 12, 21, 1,  0, 0}, // #596
  {DBGFIELD("FLDCW16m")           3, false, false, 2399, 11,  5, 1,  0, 0}, // #597
  {DBGFIELD("ST_FP80m")           2, false, false, 97, 4,  1, 1,  0, 0}, // #598
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 3, false, false, 2102, 8, 21, 1,  0, 0}, // #599
  {DBGFIELD("CMPXCHG8rm")         6, false, false, 112, 8, 10, 1,  0, 0}, // #600
  {DBGFIELD("INTO")               1, false, false, 79, 2,  4, 1,  0, 0}, // #601
  {DBGFIELD("XLAT")               1, false, false, 101, 3,  7, 1,  0, 0}, // #602
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 4, false, false, 2130, 9,  6, 1,  0, 0}, // #603
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false, 133, 7, 21, 1,  0, 0}, // #604
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 6, false, false, 2119, 11, 26, 1,  0, 0}, // #605
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 4, false, false, 637, 9,  9, 1,  0, 0}, // #606
  {DBGFIELD("IMUL16rr_IMUL16rri_IMUL16rri8") 1, false, false, 133, 7, 21, 1,  0, 0}, // #607
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 3, false, false, 370, 11, 22, 1,  0, 0}, // #608
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 4, false, false, 2092, 10, 10, 1,  9, 1}, // #609
  {DBGFIELD("AAD8i8")             1, false, false, 79, 2,  4, 1,  0, 0}, // #610
  {DBGFIELD("LOOPE")              11, false, false, 929, 4, 26, 1,  0, 0}, // #611
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, 97, 4,  1, 1,  0, 0}, // #612
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 4, false, false, 2130, 9,  6, 1,  0, 0}, // #613
  {DBGFIELD("FNSTCW16m")          3, false, false, 933, 10, 20, 1,  0, 0}, // #614
  {DBGFIELD("BT16mr_BT32mr_BT64mr") 2, false, false, 120, 4,  6, 1,  0, 0}, // #615
  {DBGFIELD("POPA16_POPA32")      1, false, false, 101, 3,  7, 1,  0, 0}, // #616
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, 97, 4,  1, 1,  0, 0}, // #617
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 6, false, false, 2119, 11, 26, 1,  0, 0}, // #618
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 4, false, false, 637, 9,  9, 1,  0, 0}, // #619
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, 133, 7, 21, 1,  0, 0}, // #620
  {DBGFIELD("CMPXCHG8rr")         5, false, false, 943, 4,  7, 1,  0, 0}, // #621
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80_COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 237, 9, 20, 1,  0, 0}, // #622
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_CVTTSS2SI64rr_Int") 3, false, false, 2410, 12,  5, 1,  0, 0}, // #623
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int") 2, false, false, 225, 11,  5, 1,  9, 1}, // #624
  {DBGFIELD("CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 4, false, false, 2422, 14, 19, 1,  0, 0}, // #625
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, 79, 2,  4, 1,  0, 0}, // #626
  {DBGFIELD("BTC16mr_BTC32mr_BTC64mr_BTR16mr_BTR32mr_BTR64mr_BTS16mr_BTS32mr_BTS64mr") 3, false, false, 81, 6, 63, 2,  0, 0}, // #627
  {DBGFIELD("AAA_AAS")            1, false, false, 79, 2,  4, 1,  0, 0}, // #628
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 6, false, false, 112, 8, 10, 1,  0, 0}, // #629
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 5, false, false, 943, 4,  7, 1,  0, 0}, // #630
  {DBGFIELD("LOOPNE")             11, false, false, 929, 4, 26, 1,  0, 0}, // #631
  {DBGFIELD("PAUSE")              4, false, false, 2436, 7, 55, 1,  0, 0}, // #632
  {DBGFIELD("CMPXCHG8B")          14, false, false, 966, 10,  8, 1,  0, 0}, // #633
  {DBGFIELD("DAA")                1, false, false, 79, 2,  4, 1,  0, 0}, // #634
  {DBGFIELD("LOOP")               7, false, false, 2443, 9,  5, 1,  0, 0}, // #635
  {DBGFIELD("DAS")                1, false, false, 79, 2,  4, 1,  0, 0}, // #636
  {DBGFIELD("AAM8i8")             1, false, false, 79, 2,  4, 1,  0, 0}, // #637
  {DBGFIELD("STD")                6, false, false, 985, 7,  6, 1,  0, 0}, // #638
  {DBGFIELD("CMPXCHG16B")         19, false, false, 992, 15, 33, 1,  0, 0}, // #639
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, 79, 2,  4, 1,  0, 0}, // #640
  {DBGFIELD("FNCLEX_FXTRACT")     4, false, false, 368, 2, 22, 1,  0, 0}, // #641
  {DBGFIELD("POPF32_POPF64")      1, false, false, 101, 3,  7, 1,  0, 0}, // #642
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, 79, 2,  4, 1,  0, 0}, // #643
  {DBGFIELD("RDTSC_RDTSCP")       22, false, false, 1007, 8, 75, 1,  0, 0}, // #644
  {DBGFIELD("ENTER")              1, false, false, 79, 2,  4, 1,  0, 0}, // #645
  {DBGFIELD("POPF16")             1, false, false, 101, 3,  7, 1,  0, 0}, // #646
  {DBGFIELD("MONITORrrr")         1, false, false, 79, 2,  4, 1,  0, 0}, // #647
  {DBGFIELD("FRNDINT")            1, false, false, 79, 2,  4, 1,  0, 0}, // #648
  {DBGFIELD("MWAITrr_RDPMC")      10, false, false, 2452, 11, 30, 1,  0, 0}, // #649
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, 79, 2,  4, 1,  0, 0}, // #650
  {DBGFIELD("FPREM")              1, false, false, 79, 2,  4, 1,  0, 0}, // #651
  {DBGFIELD("INSB_INSL_INSW")     8, false, false, 1015, 15, 30, 1,  0, 0}, // #652
  {DBGFIELD("FNINIT")             15, false, false, 2463, 8, 76, 1,  0, 0}, // #653
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 23, false, false, 1039, 13, 73, 1,  0, 0}, // #654
  {DBGFIELD("FPREM1")             1, false, false, 79, 2,  4, 1,  0, 0}, // #655
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, 79, 2,  4, 1,  0, 0}, // #656
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 23, false, false, 1039, 13, 73, 1,  0, 0}, // #657
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, 79, 2,  4, 1,  0, 0}, // #658
  {DBGFIELD("FSCALE")             1, false, false, 79, 2,  4, 1,  0, 0}, // #659
  {DBGFIELD("RDMSR")              1, false, false, 79, 2,  4, 1,  0, 0}, // #660
  {DBGFIELD("RET_RETL_RETQ_RETW_LRETIL_LRETIQ_LRETIW_LRETL_LRETQ_LRETW") 2, false, false, 87, 6,  6, 1,  0, 0}, // #661
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 23, false, false, 1052, 13, 73, 1,  0, 0}, // #662
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 23, false, false, 1052, 13, 73, 1,  0, 0}, // #663
  {DBGFIELD("F2XM1")              1, false, false, 79, 2,  4, 1,  0, 0}, // #664
  {DBGFIELD("CPUID")              8, false, false, 1065, 11, 29, 1,  0, 0}, // #665
  {DBGFIELD("INT")                1, false, false, 79, 2,  4, 1,  0, 0}, // #666
  {DBGFIELD("INT3")               1, false, false, 79, 2,  4, 1,  0, 0}, // #667
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, 79, 2,  4, 1,  0, 0}, // #668
  {DBGFIELD("FXRSTOR_FXRSTOR64")  90, false, false, 1076, 15, 44, 1,  0, 0}, // #669
  {DBGFIELD("FYL2X")              1, false, false, 79, 2,  4, 1,  0, 0}, // #670
  {DBGFIELD("FYL2XP1")            1, false, false, 79, 2,  4, 1,  0, 0}, // #671
  {DBGFIELD("FPTAN")              1, false, false, 79, 2,  4, 1,  0, 0}, // #672
  {DBGFIELD("FSINCOS")            1, false, false, 79, 2,  4, 1,  0, 0}, // #673
  {DBGFIELD("COS_F_COS_Fp32_COS_Fp64_COS_Fp80_SIN_F_SIN_Fp32_SIN_Fp64_SIN_Fp80") 1, false, false, 79, 2,  4, 1,  0, 0}, // #674
  {DBGFIELD("FPATAN")             1, false, false, 79, 2,  4, 1,  0, 0}, // #675
  {DBGFIELD("WRMSR")              1, false, false, 79, 2,  4, 1,  0, 0}, // #676
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, 104, 8,  1, 1,  0, 0}, // #677
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, 104, 8,  1, 1,  0, 0}, // #678
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 2, false, false, 2062, 5, 20, 1,  0, 0}, // #679
  {DBGFIELD("FNOP")               1, false, false, 1954, 5,  1, 1,  0, 0}, // #680
  {DBGFIELD("RETQ")               3, false, false, 1091, 9,  5, 1,  0, 0}, // #681
  {DBGFIELD("CDQ_CQO")            1, false, false, 93, 4,  1, 1,  0, 0}, // #682
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, 1954, 5,  1, 1,  0, 0}, // #683
  {DBGFIELD("MMX_PADDQirr")       1, false, false, 1954, 5,  1, 1,  0, 0}, // #684
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, 104, 8,  1, 1,  0, 0}, // #685
  {DBGFIELD("ROL16r1_ROL32r1_ROL64r1_ROL8r1_ROL16ri_ROL32ri_ROL64ri_ROL8ri_ROR16r1_ROR32r1_ROR64r1_ROR8r1_ROR16ri_ROR32ri_ROR64ri_ROR8ri") 2, false, false, 1100, 4, 20, 1,  0, 0}, // #686
  {DBGFIELD("SETAr_SETBEr")       2, false, false, 1100, 4, 20, 1,  0, 0}, // #687
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 3, false, false, 901, 4,  5, 1,  0, 0}, // #688
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 237, 9, 20, 1,  0, 0}, // #689
  {DBGFIELD("VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 1, false, false, 237, 9, 20, 1,  0, 0}, // #690
  {DBGFIELD("CWD")                2, false, false, 220, 4, 20, 1,  0, 0}, // #691
  {DBGFIELD("FNSTSW16r")          2, false, false, 1104, 9, 21, 1,  0, 0}, // #692
  {DBGFIELD("MMX_MOVDQ2Qrr")      2, false, false, 2062, 5, 20, 1,  0, 0}, // #693
  {DBGFIELD("PUSHFS64")           1, false, false, 79, 2,  4, 1,  0, 0}, // #694
  {DBGFIELD("IMUL16rri_IMUL16rri8") 2, false, false, 1117, 7, 22, 1,  0, 0}, // #695
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 2, false, false, 381, 12, 21, 1,  0, 0}, // #696
  {DBGFIELD("ROL16rCL_ROL32rCL_ROL64rCL_ROL8rCL_ROR16rCL_ROR32rCL_ROR64rCL_ROR8rCL_SAR16rCL_SAR32rCL_SAR64rCL_SAR8rCL_SHL16rCL_SHL32rCL_SHL64rCL_SHL8rCL_SHR16rCL_SHR32rCL_SHR64rCL_SHR8rCL") 3, false, false, 2471, 4, 21, 1,  0, 0}, // #697
  {DBGFIELD("XADD8rr_XADD16rr_XADD32rr_XADD64rr_XCHG8rr_XCHG16rr_XCHG32rr_XCHG64rr_XCHG16ar_XCHG32ar_XCHG64ar") 3, false, false, 338, 2, 20, 1,  0, 0}, // #698
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, 237, 9, 20, 1,  0, 0}, // #699
  {DBGFIELD("IMUL64r_MUL64r")     2, false, false, 719, 11, 22, 1,  0, 0}, // #700
  {DBGFIELD("IMUL16r_MUL16r")     4, false, false, 646, 9, 22, 1,  0, 0}, // #701
  {DBGFIELD("MOV64sr")            1, false, false, 79, 2,  1, 1,  0, 0}, // #702
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false, 104, 8, 21, 1,  0, 0}, // #703
  {DBGFIELD("MOVSX16rm16_MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVSX64rm16_MOVSX64rm32_MOVSX64rm8_MOVZX16rm16_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX_MOVZX64rm16_MOVZX64rm8") 1, false, false, 101, 3,  7, 1,  0, 0}, // #704
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 3, false, false, 1128, 5, 20, 1,  0, 0}, // #705
  {DBGFIELD("CLI")                1, false, false, 79, 2,  4, 1,  0, 0}, // #706
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 3, false, false, 370, 11, 22, 1,  0, 0}, // #707
  {DBGFIELD("PUSHGS64")           1, false, false, 79, 2,  4, 1,  0, 0}, // #708
  {DBGFIELD("CALL64pcrel32")      4, false, false, 1133, 7, 21, 1,  0, 0}, // #709
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 4, false, false, 1140, 10, 21, 1,  0, 0}, // #710
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 3, false, false, 370, 11, 20, 1,  0, 0}, // #711
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 3, false, false, 1128, 5, 20, 1,  0, 0}, // #712
  {DBGFIELD("SETAm_SETBEm")       4, false, false, 2475, 7, 21, 1,  0, 0}, // #713
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 3, false, false, 370, 11, 20, 1,  0, 0}, // #714
  {DBGFIELD("PUSHF16_PUSHF64")    6, false, false, 1150, 5,  7, 1,  0, 0}, // #715
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 2, false, false, 1155, 7, 20, 1,  0, 0}, // #716
  {DBGFIELD("MMX_MOVD64from64rm") 2, false, false, 97, 4,  1, 1,  0, 0}, // #717
  {DBGFIELD("VBROADCASTSSrm_MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 101, 3,  7, 1,  0, 0}, // #718
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, 101, 3,  7, 1,  0, 0}, // #719
  {DBGFIELD("MOVSDrm_VMOVSDrm_MOVSSrm_VMOVSSrm") 1, false, false, 101, 3,  7, 1,  0, 0}, // #720
  {DBGFIELD("MOV16sm")            1, false, false, 79, 2,  1, 1,  0, 0}, // #721
  {DBGFIELD("BT16mi8_BT32mi8_BT64mi8") 2, false, false, 87, 6,  6, 1,  0, 0}, // #722
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 2, false, false, 2085, 7,  6, 1,  0, 0}, // #723
  {DBGFIELD("MMX_PALIGNRrmi")     2, false, false, 140, 10,  6, 1,  9, 1}, // #724
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 2, false, false, 2085, 7,  6, 1,  9, 1}, // #725
  {DBGFIELD("LODSL_LODSQ")        1, false, false, 79, 2,  4, 1,  0, 0}, // #726
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false, 101, 3,  5, 1,  0, 0}, // #727
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 1, false, false, 101, 3,  5, 1,  0, 0}, // #728
  {DBGFIELD("VINSERTF128rm")      2, false, false, 128, 5,  5, 1,  0, 0}, // #729
  {DBGFIELD("MMX_PADDQirm")       2, false, false, 2085, 7,  6, 1,  9, 1}, // #730
  {DBGFIELD("VERRm_VERWm")        1, false, false, 79, 2,  4, 1,  0, 0}, // #731
  {DBGFIELD("FARJMP64")           2, false, false, 1162, 9,  6, 1,  0, 0}, // #732
  {DBGFIELD("FNSTSWm")            3, false, false, 1171, 11, 21, 1,  0, 0}, // #733
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 4, false, false, 1182, 11,  6, 1,  0, 0}, // #734
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 5, false, false, 1193, 11,  5, 1,  0, 0}, // #735
  {DBGFIELD("CALL64m_CALL64m_NT") 5, false, false, 1193, 11,  5, 1,  0, 0}, // #736
  {DBGFIELD("SAR16m1_SAR32m1_SAR64m1_SAR8m1_SAR16mi_SAR32mi_SAR64mi_SAR8mi_SHL16m1_SHL32m1_SHL64m1_SHL8m1_SHL16mi_SHL32mi_SHL64mi_SHL8mi_SHR16m1_SHR32m1_SHR64m1_SHR8m1_SHR16mi_SHR32mi_SHR64mi_SHR8mi") 4, false, false, 602, 8,  6, 1,  0, 0}, // #737
  {DBGFIELD("VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 2, false, false, 225, 11,  5, 1,  9, 1}, // #738
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, 79, 2,  4, 1,  0, 0}, // #739
  {DBGFIELD("ROL16m1_ROL32m1_ROL64m1_ROL8m1_ROL16mi_ROL32mi_ROL64mi_ROL8mi_ROR16m1_ROR32m1_ROR64m1_ROR8m1_ROR16mi_ROR32mi_ROR64mi_ROR8mi") 5, false, false, 1204, 8,  5, 1,  0, 0}, // #740
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 5, false, false, 1212, 6,  5, 1,  0, 0}, // #741
  {DBGFIELD("FARCALL64")          5, false, false, 1193, 11,  5, 1,  0, 0}, // #742
  {DBGFIELD("CVTSD2SI64rm_Int_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int") 3, false, false, 1991, 6, 26, 1,  0, 0}, // #743
  {DBGFIELD("CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int") 3, false, false, 1991, 6, 26, 1,  0, 0}, // #744
  {DBGFIELD("IMUL64m_MUL64m")     3, false, false, 1232, 13,  9, 1,  0, 0}, // #745
  {DBGFIELD("IMUL32m_MUL32m")     4, false, false, 1245, 11,  9, 1,  0, 0}, // #746
  {DBGFIELD("IMUL16rmi_IMUL16rmi8") 3, false, false, 1256, 9, 10, 1,  0, 0}, // #747
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, 101, 3,  5, 1,  0, 0}, // #748
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL_SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 6, false, false, 2482, 8, 10, 1,  0, 0}, // #749
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 6, false, false, 112, 8, 10, 1,  0, 0}, // #750
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 2, false, false, 140, 10, 18, 1,  0, 0}, // #751
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 2, false, false, 140, 10,  9, 1,  0, 0}, // #752
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 3, false, false, 150, 10, 26, 1,  0, 0}, // #753
  {DBGFIELD("MUL_F32m_MUL_F64m")  2, false, false, 225, 11, 26, 1,  0, 0}, // #754
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 3, false, false, 150, 10, 27, 1,  0, 0}, // #755
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 3, false, false, 588, 14, 25, 1,  0, 0}, // #756
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 2, false, false, 225, 11, 32, 1,  0, 0}, // #757
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 3, false, false, 588, 14, 34, 1,  0, 0}, // #758
  {DBGFIELD("CLC")                1, false, false,  0, 0,  1, 1,  0, 0}, // #759
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 2, false, false, 140, 10,  6, 1,  0, 0}, // #760
  {DBGFIELD("DIV8r")              1, false, false, 236, 10, 34, 1,  0, 0}, // #761
  {DBGFIELD("IDIV8r")             1, false, false, 236, 10, 34, 1,  0, 0}, // #762
  {DBGFIELD("RETIL_RETIQ_RETIW")  2, false, false, 87, 6,  6, 1,  0, 0}, // #763
  {DBGFIELD("LRETIL_LRETIQ_LRETIW") 2, false, false, 87, 6,  6, 1,  0, 0}, // #764
  {DBGFIELD("RDPMC")              1, false, false, 79, 2,  4, 1,  0, 0}, // #765
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false, 79, 2,  4, 1,  0, 0}, // #766
  {DBGFIELD("FBLDm")              1, false, false, 79, 2,  4, 1,  0, 0}, // #767
  {DBGFIELD("FFREE_FFREEP")       1, false, false, 79, 2,  4, 1,  0, 0}, // #768
  {DBGFIELD("FSAVEm")             1, false, false, 79, 2,  4, 1,  0, 0}, // #769
  {DBGFIELD("FRSTORm")            1, false, false, 79, 2,  4, 1,  0, 0}, // #770
  {DBGFIELD("FXTRACT")            1, false, false, 79, 2,  4, 1,  0, 0}, // #771
  {DBGFIELD("VBROADCASTSSrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 101, 3,  6, 1,  0, 0}, // #772
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, 101, 3,  6, 1,  0, 0}, // #773
  {DBGFIELD("VBROADCASTF128")     1, false, false, 101, 3,  5, 1,  0, 0}, // #774
  {DBGFIELD("VBROADCASTI128")     1, false, false, 101, 3,  5, 1,  0, 0}, // #775
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, 101, 3,  5, 1,  0, 0}, // #776
  {DBGFIELD("FBSTPm")             2, false, false, 97, 4,  1, 1,  0, 0}, // #777
  {DBGFIELD("ST_FP32m_ST_FP64m")  2, false, false, 97, 4,  1, 1,  0, 0}, // #778
  {DBGFIELD("VMPTRSTm")           2, false, false, 97, 4,  1, 1,  0, 0}, // #779
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 1, false, false, 437, 4,  1, 1,  0, 0}, // #780
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 1, false, false, 437, 4,  1, 1,  0, 0}, // #781
  {DBGFIELD("MMX_MOVQ2DQrr")      2, false, false, 160, 8, 20, 1,  0, 0}, // #782
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT") 1, false, false, 1271, 7,  1, 1,  0, 0}, // #783
  {DBGFIELD("FINCSTP")            1, false, false, 1954, 5,  1, 1,  0, 0}, // #784
  {DBGFIELD("ANDN32rr_ANDN64rr_BLSI32rr_BLSI64rr_BLSMSK32rr_BLSMSK64rr_BLSR32rr_BLSR64rr") 1, false, false, 77, 4,  1, 1,  0, 0}, // #785
  {DBGFIELD("VPBLENDDYrri")       1, false, false, 78, 3,  1, 1,  0, 0}, // #786
  {DBGFIELD("VPBLENDDrri")        1, false, false, 78, 3,  1, 1,  0, 0}, // #787
  {DBGFIELD("CMC_STC")            1, false, false, 79, 2,  1, 1,  0, 0}, // #788
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false, 79, 2,  1, 1,  0, 0}, // #789
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 2, false, false, 128, 5,  9, 1,  0, 0}, // #790
  {DBGFIELD("CVTSS2SDrm")         2, false, false, 128, 5, 18, 1,  0, 0}, // #791
  {DBGFIELD("CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 2, false, false, 128, 5, 18, 1,  0, 0}, // #792
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 2, false, false, 490, 6,  5, 1,  9, 1}, // #793
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 2, false, false, 490, 6, 10, 1,  9, 1}, // #794
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 2, false, false, 124, 9, 10, 1,  0, 0}, // #795
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 2, false, false, 140, 10,  6, 1,  0, 0}, // #796
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 2, false, false, 140, 10, 10, 1,  0, 0}, // #797
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT") 2, false, false, 1162, 9,  6, 1,  0, 0}, // #798
  {DBGFIELD("ANDN32rm_ANDN64rm")  2, false, false, 208, 6,  6, 1,  0, 0}, // #799
  {DBGFIELD("BLSI32rm_BLSI64rm_BLSMSK32rm_BLSMSK64rm_BLSR32rm_BLSR64rm_MOVBE16rm_MOVBE32rm_MOVBE64rm") 2, false, false, 208, 6,  6, 1,  0, 0}, // #800
  {DBGFIELD("VINSERTI128rm")      2, false, false, 128, 5,  5, 1,  0, 0}, // #801
  {DBGFIELD("VPBLENDDrmi")        2, false, false, 128, 5,  5, 1,  0, 0}, // #802
  {DBGFIELD("VPBLENDDYrmi")       2, false, false, 128, 5, 10, 1,  0, 0}, // #803
  {DBGFIELD("POP32r_POP64r")      2, false, false, 120, 4,  6, 1,  0, 0}, // #804
  {DBGFIELD("SFENCE")             2, false, false, 90, 3, 20, 1,  0, 0}, // #805
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 3, false, false, 1278, 7, 20, 1,  0, 0}, // #806
  {DBGFIELD("MOVBE16mr")          3, false, false, 1278, 7, 20, 1,  0, 0}, // #807
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r") 3, false, false, 1128, 5, 20, 1,  0, 0}, // #808
  {DBGFIELD("MFENCE")             3, false, false, 157, 3, 21, 1,  0, 0}, // #809
  {DBGFIELD("XGETBV")             2, false, false, 166, 2, 20, 1,  0, 0}, // #810
  {DBGFIELD("CVTPS2PDrr_VCVTPS2PDrr") 2, false, false, 2365, 8,  7, 1,  0, 0}, // #811
  {DBGFIELD("CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 2, false, false, 2365, 8,  7, 1,  0, 0}, // #812
  {DBGFIELD("MMX_PACKSSDWirm_MMX_PACKSSWBirm_MMX_PACKUSWBirm") 3, false, false, 150, 10,  5, 1,  0, 0}, // #813
  {DBGFIELD("LRETQ_RETL")         2, false, false, 87, 6,  6, 1,  0, 0}, // #814
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, 133, 7, 21, 1,  0, 0}, // #815
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, 437, 4, 22, 1,  0, 0}, // #816
  {DBGFIELD("VCVTDQ2PSYrr")       1, false, false, 437, 4, 22, 1,  0, 0}, // #817
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, 104, 8, 21, 1,  0, 0}, // #818
  {DBGFIELD("CVTPS2DQrm_VCVTPS2DQrm_CVTTPS2DQrm_VCVTTPS2DQrm") 2, false, false, 128, 5, 18, 1,  0, 0}, // #819
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, 128, 5, 26, 1,  0, 0}, // #820
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm") 2, false, false, 128, 5, 26, 1,  0, 0}, // #821
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 2, false, false, 140, 10,  9, 1,  0, 0}, // #822
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr") 3, false, false, 1285, 8, 21, 1,  0, 0}, // #823
  {DBGFIELD("CLDEMOTE")           3, false, false, 905, 7, 21, 1,  0, 0}, // #824
  {DBGFIELD("RCL16r1_RCL32r1_RCL64r1_RCL8r1_RCL16ri_RCL32ri_RCL64ri_RCL8ri_RCR16r1_RCR32r1_RCR64r1_RCR8r1_RCR16ri_RCR32ri_RCR64ri_RCR8ri") 3, false, false, 1293, 4, 21, 1,  0, 0}, // #825
  {DBGFIELD("RCL16m1_RCL32m1_RCL64m1_RCL8m1_RCL16mi_RCL32mi_RCL64mi_RCL8mi_RCR16m1_RCR32m1_RCR64m1_RCR8m1_RCR16mi_RCR32mi_RCR64mi_RCR8mi") 5, false, false, 1297, 6, 10, 1,  0, 0}, // #826
  {DBGFIELD("ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 5, false, false, 2490, 6, 10, 1,  0, 0}, // #827
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_CVTTSD2SI64rr_Int_CVTTSD2SIrr_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, 398, 4,  6, 1,  0, 0}, // #828
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int_CVTSS2SIrr_Int_CVTTSS2SIrr_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_VCVTTSS2SIrr_Int") 2, false, false, 398, 4,  6, 1,  0, 0}, // #829
  {DBGFIELD("VCVTPS2PDYrr")       2, false, false, 2365, 8,  5, 1,  0, 0}, // #830
  {DBGFIELD("MMX_CVTPI2PDirr_CVTDQ2PDrr_VCVTDQ2PDrr") 1, false, false, 437, 4, 22, 1,  0, 0}, // #831
  {DBGFIELD("MMX_CVTPD2PIirr_MMX_CVTTPD2PIirr_CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, 2365, 8,  7, 1,  0, 0}, // #832
  {DBGFIELD("CVTPD2PSrr_VCVTPD2PSrr") 2, false, false, 2365, 8,  7, 1,  0, 0}, // #833
  {DBGFIELD("CVTSD2SSrr_CVTSD2SSrr_Int_VCVTSD2SSrr_VCVTSD2SSrr_Int") 2, false, false, 2365, 8,  7, 1,  0, 0}, // #834
  {DBGFIELD("CVTSI2SDrr_CVTSI2SDrr_Int_CVTSI642SDrr_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, 2365, 8,  7, 1,  0, 0}, // #835
  {DBGFIELD("CVTSI2SSrr_CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int") 2, false, false, 2365, 8,  7, 1,  0, 0}, // #836
  {DBGFIELD("MULX64rr")           2, false, false, 719, 11, 22, 1,  0, 0}, // #837
  {DBGFIELD("VCVTSD2SI64rm_Int_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 3, false, false, 1991, 6, 26, 1,  0, 0}, // #838
  {DBGFIELD("CVTSS2SI64rm_Int")   3, false, false, 1991, 6, 26, 1,  0, 0}, // #839
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, 1991, 6, 26, 1,  0, 0}, // #840
  {DBGFIELD("VCVTPS2PDYrm")       2, false, false, 128, 5, 26, 1,  0, 0}, // #841
  {DBGFIELD("CVTPD2PSrm")         3, false, false, 1309, 10, 26, 1,  0, 0}, // #842
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_MMX_CVTPD2PIirm_MMX_CVTTPD2PIirm") 3, false, false, 1309, 10, 26, 1,  0, 0}, // #843
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 3, false, false, 588, 14, 26, 1,  0, 0}, // #844
  {DBGFIELD("MMX_CVTPI2PDirm")    2, false, false, 490, 6,  9, 1,  0, 0}, // #845
  {DBGFIELD("CVTSD2SSrm")         3, false, false, 1309, 10, 18, 1,  0, 0}, // #846
  {DBGFIELD("CVTSD2SSrm_Int_VCVTSD2SSrm_VCVTSD2SSrm_Int") 3, false, false, 1309, 10, 18, 1,  0, 0}, // #847
  {DBGFIELD("MULX64rm")           3, false, false, 1232, 13,  9, 1,  0, 0}, // #848
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 2, false, false, 140, 10, 10, 1,  0, 0}, // #849
  {DBGFIELD("VZEROUPPER")         4, false, false, 1319, 3, 22, 1,  0, 0}, // #850
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 4, false, false, 2496, 11, 22, 1,  0, 0}, // #851
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 5, false, false, 1335, 13,  9, 1,  0, 0}, // #852
  {DBGFIELD("VPCMPGTQYrr")        1, false, false, 104, 8, 21, 1,  0, 0}, // #853
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, 237, 9, 22, 1,  0, 0}, // #854
  {DBGFIELD("VPCMPGTQYrm")        2, false, false, 140, 10, 18, 1,  0, 0}, // #855
  {DBGFIELD("CVTSI642SSrr_CVTSI642SSrr_Int_VCVTSI642SSrr_VCVTSI642SSrr_Int") 3, false, false, 2077, 8,  6, 1,  0, 0}, // #856
  {DBGFIELD("STR16r_STR32r_STR64r") 3, false, false, 1348, 11,  7, 1,  0, 0}, // #857
  {DBGFIELD("MULX32rr")           3, false, false, 867, 9, 22, 1,  0, 0}, // #858
  {DBGFIELD("MULX32rm")           4, false, false, 1245, 11,  9, 1,  0, 0}, // #859
  {DBGFIELD("XSETBV")             5, false, false, 1359, 4,  7, 1,  0, 0}, // #860
  {DBGFIELD("VCVTDQ2PDYrr")       2, false, false, 2110, 9,  5, 1,  0, 0}, // #861
  {DBGFIELD("VCVTPD2PSYrr")       2, false, false, 2365, 8,  5, 1,  0, 0}, // #862
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 2, false, false, 2365, 8,  5, 1,  0, 0}, // #863
  {DBGFIELD("VCVTDQ2PDYrm")       3, false, false, 588, 14, 27, 1,  0, 0}, // #864
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 10, false, false, 2507, 11, 24, 1,  0, 0}, // #865
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 7, false, false, 2518, 9, 26, 1,  0, 0}, // #866
  {DBGFIELD("RCL8rCL")            9, false, false, 2527, 9, 26, 1,  0, 0}, // #867
  {DBGFIELD("RCR8rCL")            10, false, false, 2536, 9, 25, 1,  0, 0}, // #868
  {DBGFIELD("VZEROALL")           16, false, false, 1407, 2,  8, 1,  0, 0}, // #869
  {DBGFIELD("RDTSC")              8, false, false, 1065, 11, 29, 1,  0, 0}, // #870
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 31, false, false, 2545, 13, 97, 1,  0, 0}, // #871
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, 237, 9, 30, 1,  0, 0}, // #872
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 2, false, false, 225, 11, 74, 1,  0, 0}, // #873
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 3, false, false, 588, 14, 37, 1,  0, 0}, // #874
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, 237, 9, 24, 1,  0, 0}, // #875
  {DBGFIELD("XSAVE64")            39, false, false, 2558, 11, 84, 1,  0, 0}, // #876
  {DBGFIELD("XSAVE")              40, false, false, 2569, 11, 75, 1,  0, 0}, // #877
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 40, false, false, 2569, 11, 75, 1,  0, 0}, // #878
  {DBGFIELD("VMCLEARm")           18, false, false, 2580, 17, 98, 1,  0, 0}, // #879
  {DBGFIELD("FLDENVm")            64, false, false, 2597, 11, 17, 1,  0, 0}, // #880
  {DBGFIELD("FXRSTOR64")          88, false, false, 1451, 15, 44, 1,  0, 0}, // #881
  {DBGFIELD("DIV16r")             32, false, false, 2608, 15, 99, 1,  0, 0}, // #882
  {DBGFIELD("DIV32r")             32, false, false, 2608, 15, 99, 1,  0, 0}, // #883
  {DBGFIELD("DIV64r")             32, false, false, 2608, 15, 99, 1,  0, 0}, // #884
  {DBGFIELD("IDIV16r")            66, false, false, 2623, 15, 100, 1,  0, 0}, // #885
  {DBGFIELD("IDIV32r")            66, false, false, 2623, 15, 100, 1,  0, 0}, // #886
  {DBGFIELD("IDIV64r")            66, false, false, 2623, 15, 100, 1,  0, 0}, // #887
  {DBGFIELD("FSTENVm")            100, false, false, 2638, 17, 101, 1,  0, 0}, // #888
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm_VPGATHERDDrm") 5, false, false, 2655, 14, 32, 1,  0, 0}, // #889
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 5, false, false, 2655, 14, 34, 1,  0, 0}, // #890
  {DBGFIELD("VPGATHERQDYrm")      5, false, false, 2655, 14, 34, 1,  0, 0}, // #891
  {DBGFIELD("VPGATHERQDrm")       5, false, false, 2655, 14, 32, 1,  0, 0}, // #892
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 5, false, false, 2655, 14, 34, 1,  0, 0}, // #893
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 5, false, false, 2655, 14, 34, 1,  0, 0}, // #894
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 5, false, false, 2655, 14, 32, 1,  0, 0}, // #895
  {DBGFIELD("VGATHERQPSYrm")      5, false, false, 2655, 14, 34, 1,  0, 0}, // #896
  {DBGFIELD("VGATHERQPSrm_VGATHERDPSrm") 5, false, false, 2655, 14, 32, 1,  0, 0}, // #897
  {DBGFIELD("ADC8i8_ADC8ri_ADC8ri8_SBB8i8_SBB8ri_SBB8ri8") 2, false, false, 220, 4, 20, 1,  0, 0}, // #898
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 2, false, false, 140, 10, 10, 1,  0, 0}, // #899
  {DBGFIELD("LRETQ")              3, false, false, 1091, 9,  5, 1,  0, 0}, // #900
  {DBGFIELD("CVTDQ2PSrm_VCVTDQ2PSrm") 2, false, false, 128, 5, 18, 1,  0, 0}, // #901
  {DBGFIELD("POPF64")             1, false, false, 101, 3,  7, 1,  0, 0}, // #902
  {DBGFIELD("VGATHERQPDrm")       5, false, false, 2655, 14, 32, 1,  0, 0}, // #903
  {DBGFIELD("VGATHERQPDYrm")      5, false, false, 2655, 14, 34, 1,  0, 0}, // #904
  {DBGFIELD("VGATHERDPDrm")       5, false, false, 2655, 14, 32, 1,  0, 0}, // #905
  {DBGFIELD("VGATHERDPSrm")       5, false, false, 2655, 14, 32, 1,  0, 0}, // #906
  {DBGFIELD("VGATHERDPDYrm")      5, false, false, 2655, 14, 34, 1,  0, 0}, // #907
  {DBGFIELD("VGATHERDPSYrm")      5, false, false, 2655, 14, 34, 1,  0, 0}, // #908
  {DBGFIELD("DIV16m")             2, false, false, 224, 12, 36, 1, 11, 2}, // #909
  {DBGFIELD("DIV32m")             2, false, false, 224, 12, 36, 1, 11, 2}, // #910
  {DBGFIELD("DIV64m")             2, false, false, 224, 12, 36, 1, 11, 2}, // #911
  {DBGFIELD("DIV8m")              2, false, false, 224, 12, 36, 1, 11, 2}, // #912
  {DBGFIELD("IDIV16m")            8, false, false, 2669, 14, 82, 1,  0, 0}, // #913
  {DBGFIELD("IDIV32m")            8, false, false, 2669, 14, 82, 1,  0, 0}, // #914
  {DBGFIELD("IDIV64m")            8, false, false, 2669, 14, 82, 1,  0, 0}, // #915
  {DBGFIELD("IDIV8m")             8, false, false, 2669, 14, 82, 1,  0, 0}, // #916
  {DBGFIELD("MOV16rm")            1, false, false, 101, 3,  7, 1,  0, 0}, // #917
  {DBGFIELD("MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX") 1, false, false, 101, 3,  7, 1,  0, 0}, // #918
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 3, false, false, 338, 2, 20, 1,  0, 0}, // #919
  {DBGFIELD("POP16rmm")           4, false, false, 81, 6,  6, 1,  0, 0}, // #920
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 4, false, false, 81, 6,  6, 1,  0, 0}, // #921
  {DBGFIELD("PUSHF16")            6, false, false, 1150, 5,  7, 1,  0, 0}, // #922
  {DBGFIELD("LAHF")               1, false, false, 93, 4,  1, 1,  0, 0}, // #923
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 2, false, false, 208, 6,  6, 1,  0, 0}, // #924
  {DBGFIELD("ADD16mi_ADD16mi8_ADD16mr_ADD32mi_ADD32mi8_ADD32mr_ADD64mi32_ADD64mi8_ADD64mr_ADD8mi_ADD8mi8_ADD8mr_SUB16mi_SUB16mi8_SUB16mr_SUB32mi_SUB32mi8_SUB32mr_SUB64mi32_SUB64mi8_SUB64mr_SUB8mi_SUB8mi8_SUB8mr") 3, false, false, 81, 6,  5, 1,  0, 0}, // #925
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 6, false, false, 112, 8, 10, 1,  0, 0}, // #926
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 3, false, false, 81, 6,  5, 1,  0, 0}, // #927
  {DBGFIELD("IMUL16rm")           3, false, false, 1256, 9, 10, 1,  0, 0}, // #928
  {DBGFIELD("IMUL64rr")           1, false, false, 133, 7, 21, 1,  0, 0}, // #929
  {DBGFIELD("IMUL64rm")           2, false, false, 124, 9, 10, 1,  9, 1}, // #930
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 4, false, false, 1140, 10, 21, 1,  0, 0}, // #931
  {DBGFIELD("RETW_LRETL_LRETW")   2, false, false, 87, 6,  6, 1,  0, 0}, // #932
  {DBGFIELD("IRET16_IRET32_IRET64") 2, false, false, 87, 6,  6, 1,  0, 0}, // #933
  {DBGFIELD("AND16mi_AND16mi8_AND16mr_AND32mi_AND32mi8_AND32mr_AND64mi32_AND64mi8_AND64mr_AND8mi_AND8mi8_AND8mr_OR16mi_OR16mi8_OR16mr_OR32mi_OR32mi8_OR32mr_OR64mi32_OR64mi8_OR64mr_OR8mi_OR8mi8_OR8mr_XOR16mi_XOR16mi8_XOR16mr_XOR32mi_XOR32mi8_XOR32mr_XOR64mi32_XOR64mi8_XOR64mr_XOR8mi_XOR8mi8_XOR8mr") 3, false, false, 81, 6,  5, 1,  0, 0}, // #934
  {DBGFIELD("OR32mrLocked")       3, false, false, 81, 6, 63, 2,  0, 0}, // #935
  {DBGFIELD("BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 1, false, false, 93, 4,  1, 1,  0, 0}, // #936
  {DBGFIELD("BLSI32rr_BLSI64rr_BLSMSK32rr_BLSMSK64rr_BLSR32rr_BLSR64rr") 1, false, false, 77, 4,  1, 1,  0, 0}, // #937
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 4, false, false, 637, 9,  9, 1,  0, 0}, // #938
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 4, false, false, 2130, 9,  6, 1,  0, 0}, // #939
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 6, false, false, 2119, 11, 26, 1,  0, 0}, // #940
  {DBGFIELD("MOVSLDUPrm")         1, false, false, 101, 3,  6, 1,  0, 0}, // #941
  {DBGFIELD("MOVSLDUPrr")         1, false, false, 104, 8,  1, 1,  0, 0}, // #942
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, 237, 9,  1, 1,  0, 0}, // #943
  {DBGFIELD("VPMOVSXBDYrr_VPMOVSXBQYrr_VPMOVSXBWYrr_VPMOVSXDQYrr_VPMOVSXWDYrr_VPMOVSXWQYrr_VPMOVZXBDYrr_VPMOVZXBQYrr_VPMOVZXBWYrr_VPMOVZXDQYrr_VPMOVZXWDYrr_VPMOVZXWQYrr") 1, false, false, 104, 8, 21, 1,  0, 0}, // #944
  {DBGFIELD("VPMOVZXBDYrm_VPMOVZXBQYrm_VPMOVZXBWYrm_VPMOVZXDQYrm_VPMOVZXWQYrm") 2, false, false, 140, 10, 18, 1,  0, 0}, // #945
  {DBGFIELD("PBLENDWrri_VPBLENDWrri") 1, false, false, 104, 8,  1, 1,  0, 0}, // #946
  {DBGFIELD("VPBLENDWYrri")       1, false, false, 104, 8,  1, 1,  0, 0}, // #947
  {DBGFIELD("PBLENDWrmi_VPBLENDWrmi") 2, false, false, 140, 10,  5, 1,  9, 1}, // #948
  {DBGFIELD("VPBLENDWYrmi")       2, false, false, 140, 10, 10, 1,  9, 1}, // #949
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, 104, 8,  1, 1,  0, 0}, // #950
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 2, false, false, 97, 4,  1, 1,  0, 0}, // #951
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 2, false, false, 97, 4,  1, 1,  0, 0}, // #952
  {DBGFIELD("VPMASKMOVDYrm")      2, false, false, 128, 5, 10, 1,  0, 0}, // #953
  {DBGFIELD("VPMASKMOVDrm")       2, false, false, 128, 5,  5, 1,  0, 0}, // #954
  {DBGFIELD("VPMASKMOVDYmr_VPMASKMOVQYmr") 2, false, false, 2266, 10, 20, 1,  0, 0}, // #955
  {DBGFIELD("VPMASKMOVDmr_VPMASKMOVQmr") 2, false, false, 2266, 10, 20, 1,  0, 0}, // #956
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 2, false, false, 140, 10,  5, 1,  0, 0}, // #957
  {DBGFIELD("VPSLLDQri_VPSRLDQri") 1, false, false, 104, 8,  1, 1,  0, 0}, // #958
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri") 1, false, false, 104, 8,  1, 1,  0, 0}, // #959
  {DBGFIELD("VPERM2F128rr")       1, false, false, 104, 8, 21, 1,  0, 0}, // #960
  {DBGFIELD("VPERM2F128rm")       2, false, false, 140, 10, 18, 1,  9, 1}, // #961
  {DBGFIELD("VEXTRACTF128rr")     1, false, false, 104, 8, 21, 1,  0, 0}, // #962
  {DBGFIELD("VEXTRACTF128mr")     2, false, false, 97, 4,  1, 1,  0, 0}, // #963
  {DBGFIELD("VINSERTF128rr")      1, false, false, 104, 8, 21, 1,  0, 0}, // #964
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 1, false, false, 437, 4, 22, 1,  0, 0}, // #965
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, 2365, 8,  7, 1,  0, 0}, // #966
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 3, false, false, 1309, 10, 26, 1,  0, 0}, // #967
  {DBGFIELD("VCVTPD2DQrm_VCVTTPD2DQrm") 2, false, false, 490, 6, 10, 1,  0, 0}, // #968
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 2, false, false, 490, 6, 10, 1,  0, 0}, // #969
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_VCVTTSS2SIrr_Int") 2, false, false, 398, 4,  6, 1,  0, 0}, // #970
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, 1991, 6, 26, 1,  0, 0}, // #971
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, 437, 4,  1, 1,  0, 0}, // #972
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, 437, 4,  1, 1,  0, 0}, // #973
  {DBGFIELD("SHA256MSG2rm")       2, false, false, 490, 6, 18, 1,  9, 1}, // #974
  {DBGFIELD("SHA256MSG2rr")       1, false, false, 437, 4, 22, 1,  0, 0}, // #975
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, 437, 4, 22, 1,  0, 0}, // #976
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 2, false, false, 490, 6, 18, 1,  9, 1}, // #977
  {DBGFIELD("SHA1MSG2rr")         1, false, false, 437, 4, 22, 1,  0, 0}, // #978
  {DBGFIELD("SHA1MSG2rm")         2, false, false, 490, 6, 18, 1,  9, 1}, // #979
  {DBGFIELD("SHA1NEXTErr")        1, false, false, 437, 4, 22, 1,  0, 0}, // #980
  {DBGFIELD("SHA1NEXTErm")        2, false, false, 490, 6, 18, 1,  9, 1}, // #981
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, 437, 4, 22, 1,  0, 0}, // #982
  {DBGFIELD("SHA1RNDS4rmi")       2, false, false, 490, 6, 18, 1,  9, 1}, // #983
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, 437, 4, 22, 1,  0, 0}, // #984
  {DBGFIELD("SHA256RNDS2rm")      2, false, false, 490, 6, 18, 1,  9, 1}, // #985
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 1, false, false, 79, 2,  1, 1,  0, 0}, // #986
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr_ANDNPSrr_VANDNPSrr_ANDNPDrr_VANDNPDrr") 1, false, false, 78, 3,  1, 1,  0, 0}, // #987
  {DBGFIELD("MMX_PXORirr_MMX_PANDNirr") 1, false, false, 1954, 5,  1, 1,  0, 0}, // #988
  {DBGFIELD("PXORrr_VPXORrr_PANDNrr_VPANDNrr") 1, false, false, 78, 3,  1, 1,  0, 0}, // #989
  {DBGFIELD("MMX_PSUBBirr_MMX_PSUBDirr_MMX_PSUBWirr_MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 1, false, false, 1954, 5,  1, 1,  0, 0}, // #990
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 1, false, false, 437, 4,  1, 1,  0, 0}, // #991
  {DBGFIELD("PSUBQrr")            1, false, false, 78, 3,  1, 1,  0, 0}, // #992
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false, 77, 4,  1, 1,  0, 0}, // #993
  {DBGFIELD("LEA16r")             1, false, false, 77, 4,  1, 1,  0, 0}, // #994
  {DBGFIELD("MMX_PADDSBirr_MMX_PADDSWirr_MMX_PADDUSBirr_MMX_PADDUSWirr_MMX_PAVGBirr_MMX_PAVGWirr_MMX_PCMPEQBirr_MMX_PCMPEQDirr_MMX_PCMPEQWirr_MMX_PMAXSWirr_MMX_PMINSWirr_MMX_PMAXUBirr_MMX_PMINUBirr_MMX_PSUBSBirr_MMX_PSUBSWirr_MMX_PSUBUSBirr_MMX_PSUBUSWirr") 1, false, false, 237, 9,  1, 1,  0, 0}, // #995
  {DBGFIELD("MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 1, false, false, 237, 9,  1, 1,  0, 0}, // #996
  {DBGFIELD("CLAC_STAC")          1, false, false, 93, 4,  1, 1,  0, 0}, // #997
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, 78, 3,  1, 1,  0, 0}, // #998
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr_VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr") 1, false, false, 78, 3,  1, 1,  0, 0}, // #999
  {DBGFIELD("PSUBBrr_PSUBDrr_PSUBWrr_VPSUBBrr_VPSUBDrr_VPSUBQrr_VPSUBWrr") 1, false, false, 78, 3,  1, 1,  0, 0}, // #1000
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, 104, 8, 21, 1,  0, 0}, // #1001
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 3, false, false, 478, 12, 21, 1,  0, 0}, // #1002
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, 2683, 9, 21, 1,  0, 0}, // #1003
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 3, false, false, 2683, 9, 21, 1,  0, 0}, // #1004
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, 437, 4, 22, 1,  0, 0}, // #1005
  {DBGFIELD("VCVTPS2DQYrr_VCVTTPS2DQYrr") 1, false, false, 437, 4, 21, 1,  0, 0}, // #1006
  {DBGFIELD("MMX_PADDSBirm_MMX_PADDSWirm_MMX_PADDUSBirm_MMX_PADDUSWirm_MMX_PAVGBirm_MMX_PAVGWirm_MMX_PCMPEQBirm_MMX_PCMPEQDirm_MMX_PCMPEQWirm_MMX_PCMPGTBirm_MMX_PCMPGTDirm_MMX_PCMPGTWirm_MMX_PMAXSWirm_MMX_PMAXUBirm_MMX_PMINSWirm_MMX_PMINUBirm_MMX_PSUBSBirm_MMX_PSUBSWirm_MMX_PSUBUSBirm_MMX_PSUBUSWirm") 2, false, false, 225, 11,  6, 1,  0, 0}, // #1007
  {DBGFIELD("CVTSS2SI64rr_Int")   3, false, false, 2410, 12,  5, 1,  0, 0}, // #1008
  {DBGFIELD("CVTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int") 2, false, false, 398, 4,  6, 1,  0, 0}, // #1009
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 2, false, false, 128, 5,  5, 1,  0, 0}, // #1010
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 2, false, false, 128, 5, 10, 1,  0, 0}, // #1011
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 4, false, false, 464, 14, 10, 1,  0, 0}, // #1012
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, 2692, 11,  9, 1,  0, 0}, // #1013
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 4, false, false, 2692, 11, 18, 1,  0, 0}, // #1014
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 40, false, false, 2569, 11, 75, 1,  0, 0}, // #1015
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, 237, 9,  1, 1,  0, 0}, // #1016
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, 237, 9,  1, 1,  0, 0}, // #1017
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, 104, 8,  1, 1,  0, 0}, // #1018
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 1, false, false, 78, 3,  1, 1,  0, 0}, // #1019
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 1, false, false, 78, 3,  1, 1,  0, 0}, // #1020
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rr_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rr_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rr_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rr_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, 78, 3,  1, 1,  0, 0}, // #1021
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rr_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rr_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rr_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rr_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 1, false, false, 78, 3,  1, 1,  0, 0}, // #1022
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrr_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrr_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrr_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrr_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 1, false, false, 78, 3,  1, 1,  0, 0}, // #1023
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 1, false, false, 78, 3,  1, 1,  0, 0}, // #1024
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 1, false, false, 78, 3,  1, 1,  0, 0}, // #1025
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 2, false, false, 97, 4,  1, 1,  0, 0}, // #1026
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 5, false, false, 2703, 7, 20, 1,  0, 0}, // #1027
  {DBGFIELD("KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, 237, 9, 21, 1,  0, 0}, // #1028
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, 237, 9, 21, 1,  0, 0}, // #1029
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_VPTESTMBZ128rr_VPTESTMBZ128rrk_VPTESTMDZ128rr_VPTESTMDZ128rrk_VPTESTMQZ128rr_VPTESTMQZ128rrk_VPTESTMWZ128rr_VPTESTMWZ128rrk_VPTESTNMBZ128rr_VPTESTNMBZ128rrk_VPTESTNMDZ128rr_VPTESTNMDZ128rrk_VPTESTNMQZ128rr_VPTESTNMQZ128rrk_VPTESTNMWZ128rr_VPTESTNMWZ128rrk") 1, false, false, 104, 8, 21, 1,  0, 0}, // #1030
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri_KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, 104, 8, 21, 1,  0, 0}, // #1031
  {DBGFIELD("VALIGNDZ128rri_VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rri_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, 104, 8, 21, 1,  0, 0}, // #1032
  {DBGFIELD("VALIGNDZ256rri_VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rri_VALIGNQZ256rrik_VALIGNQZ256rrikz") 1, false, false, 104, 8, 21, 1,  0, 0}, // #1033
  {DBGFIELD("VALIGNDZrri_VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrri_VALIGNQZrrik_VALIGNQZrrikz") 1, false, false, 104, 8, 21, 1,  0, 0}, // #1034
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rri_alt_VCMPPDZ128rri_altk_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rri_alt_VCMPPSZ128rri_altk_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, 104, 8, 21, 1,  0, 0}, // #1035
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rri_alt_VCMPPDZ256rri_altk_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rri_alt_VCMPPSZ256rri_altk_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 1, false, false, 104, 8, 21, 1,  0, 0}, // #1036
  {DBGFIELD("VCMPPDZrri_VCMPPDZrri_alt_VCMPPDZrri_altk_VCMPPDZrrib_VCMPPDZrrib_alt_VCMPPDZrrib_altk_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrri_alt_VCMPPSZrri_altk_VCMPPSZrrib_VCMPPSZrrib_alt_VCMPPSZrrib_altk_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 1, false, false, 104, 8, 21, 1,  0, 0}, // #1037
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSDZrrb_alt_VCMPSDZrrb_altk_VCMPSDZrri_alt_VCMPSDZrri_altk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VCMPSSZrrb_alt_VCMPSSZrrb_altk_VCMPSSZrri_alt_VCMPSSZrri_altk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, 104, 8, 21, 1,  0, 0}, // #1038
  {DBGFIELD("VDBPSADBWZrri_VDBPSADBWZrrik_VDBPSADBWZrrikz_VPSADBWZrr") 1, false, false, 104, 8, 21, 1,  0, 0}, // #1039
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rri_alt_VPCMPBZ128rrik_VPCMPBZ128rrik_alt_VPCMPDZ128rri_VPCMPDZ128rri_alt_VPCMPDZ128rrik_VPCMPDZ128rrik_alt_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rri_alt_VPCMPQZ128rrik_VPCMPQZ128rrik_alt_VPCMPUBZ128rri_VPCMPUBZ128rri_alt_VPCMPUBZ128rrik_VPCMPUBZ128rrik_alt_VPCMPUDZ128rri_VPCMPUDZ128rri_alt_VPCMPUDZ128rrik_VPCMPUDZ128rrik_alt_VPCMPUQZ128rri_VPCMPUQZ128rri_alt_VPCMPUQZ128rrik_VPCMPUQZ128rrik_alt_VPCMPUWZ128rri_VPCMPUWZ128rri_alt_VPCMPUWZ128rrik_VPCMPUWZ128rrik_alt_VPCMPWZ128rri_VPCMPWZ128rri_alt_VPCMPWZ128rrik_VPCMPWZ128rrik_alt_VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, 104, 8, 21, 1,  0, 0}, // #1040
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rri_alt_VPCMPBZ256rrik_VPCMPBZ256rrik_alt_VPCMPDZ256rri_VPCMPDZ256rri_alt_VPCMPDZ256rrik_VPCMPDZ256rrik_alt_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rri_alt_VPCMPQZ256rrik_VPCMPQZ256rrik_alt_VPCMPUBZ256rri_VPCMPUBZ256rri_alt_VPCMPUBZ256rrik_VPCMPUBZ256rrik_alt_VPCMPUDZ256rri_VPCMPUDZ256rri_alt_VPCMPUDZ256rrik_VPCMPUDZ256rrik_alt_VPCMPUQZ256rri_VPCMPUQZ256rri_alt_VPCMPUQZ256rrik_VPCMPUQZ256rrik_alt_VPCMPUWZ256rri_VPCMPUWZ256rri_alt_VPCMPUWZ256rrik_VPCMPUWZ256rrik_alt_VPCMPWZ256rri_VPCMPWZ256rri_alt_VPCMPWZ256rrik_VPCMPWZ256rrik_alt_VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 1, false, false, 104, 8, 21, 1,  0, 0}, // #1041
  {DBGFIELD("VPCMPBZrri_VPCMPBZrri_alt_VPCMPBZrrik_VPCMPBZrrik_alt_VPCMPDZrri_VPCMPDZrri_alt_VPCMPDZrrik_VPCMPDZrrik_alt_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrri_alt_VPCMPQZrrik_VPCMPQZrrik_alt_VPCMPUBZrri_VPCMPUBZrri_alt_VPCMPUBZrrik_VPCMPUBZrrik_alt_VPCMPUDZrri_VPCMPUDZrri_alt_VPCMPUDZrrik_VPCMPUDZrrik_alt_VPCMPUQZrri_VPCMPUQZrri_alt_VPCMPUQZrrik_VPCMPUQZrrik_alt_VPCMPUWZrri_VPCMPUWZrri_alt_VPCMPUWZrrik_VPCMPUWZrrik_alt_VPCMPWZrri_VPCMPWZrri_alt_VPCMPWZrrik_VPCMPWZrrik_alt_VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 1, false, false, 104, 8, 21, 1,  0, 0}, // #1042
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 1, false, false, 104, 8, 21, 1,  0, 0}, // #1043
  {DBGFIELD("VPTESTMBZrr_VPTESTMBZrrk_VPTESTMDZrr_VPTESTMDZrrk_VPTESTMQZrr_VPTESTMQZrrk_VPTESTMWZrr_VPTESTMWZrrk_VPTESTNMBZrr_VPTESTNMBZrrk_VPTESTNMDZrr_VPTESTNMDZrrk_VPTESTNMQZrr_VPTESTNMQZrrk_VPTESTNMWZrr_VPTESTNMWZrrk") 1, false, false, 104, 8, 21, 1,  0, 0}, // #1044
  {DBGFIELD("VCVTDQ2PSZ128rr_VCVTDQ2PSZ128rrk_VCVTDQ2PSZ128rrkz_VCVTUDQ2PSZ128rr_VCVTUDQ2PSZ128rrk_VCVTUDQ2PSZ128rrkz") 1, false, false, 437, 4, 22, 1,  0, 0}, // #1045
  {DBGFIELD("VCVTDQ2PSZ256rr_VCVTDQ2PSZ256rrk_VCVTDQ2PSZ256rrkz_VCVTUDQ2PSZ256rr_VCVTUDQ2PSZ256rrk_VCVTUDQ2PSZ256rrkz") 1, false, false, 437, 4, 22, 1,  0, 0}, // #1046
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 1, false, false, 437, 4, 22, 1,  0, 0}, // #1047
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 1, false, false, 437, 4, 22, 1,  0, 0}, // #1048
  {DBGFIELD("VCVTPS2DQYrr")       1, false, false, 437, 4, 22, 1,  0, 0}, // #1049
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, 437, 4, 22, 1,  0, 0}, // #1050
  {DBGFIELD("VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 1, false, false, 437, 4, 22, 1,  0, 0}, // #1051
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 1, false, false, 437, 4, 22, 1,  0, 0}, // #1052
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 1, false, false, 437, 4, 22, 1,  0, 0}, // #1053
  {DBGFIELD("VCVTDQ2PSZrr_VCVTUDQ2PSZrr") 1, false, false, 1954, 5, 22, 1,  0, 0}, // #1054
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 1, false, false, 1954, 5, 22, 1,  0, 0}, // #1055
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 1, false, false, 1954, 5, 22, 1,  0, 0}, // #1056
  {DBGFIELD("VCVTQQ2PDZrr_VCVTUQQ2PDZrr") 1, false, false, 1954, 5, 22, 1,  0, 0}, // #1057
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 2, false, false, 160, 8, 22, 1,  0, 0}, // #1058
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 2, false, false, 160, 8, 22, 1,  0, 0}, // #1059
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 3, false, false, 370, 11, 22, 1,  0, 0}, // #1060
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 2, false, false, 2365, 8,  7, 1,  0, 0}, // #1061
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 2, false, false, 2365, 8,  7, 1,  0, 0}, // #1062
  {DBGFIELD("VCVTPD2PSZ128rr_VCVTPD2PSZ128rrk_VCVTPD2PSZ128rrkz") 2, false, false, 2365, 8,  7, 1,  0, 0}, // #1063
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz") 2, false, false, 2365, 8,  7, 1,  0, 0}, // #1064
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 2, false, false, 2365, 8,  7, 1,  0, 0}, // #1065
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 2, false, false, 2365, 8,  7, 1,  0, 0}, // #1066
  {DBGFIELD("VCVTSD2SSZrr_VCVTSD2SSZrr_Int_VCVTSD2SSZrr_Intk_VCVTSD2SSZrr_Intkz_VCVTSD2SSZrrb_Int_VCVTSD2SSZrrb_Intk_VCVTSD2SSZrrb_Intkz") 2, false, false, 2365, 8,  7, 1,  0, 0}, // #1067
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 2, false, false, 2365, 8,  7, 1,  0, 0}, // #1068
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI2SDZrrb_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 2, false, false, 2365, 8,  7, 1,  0, 0}, // #1069
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz") 2, false, false, 2365, 8,  7, 1,  0, 0}, // #1070
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 3, false, false, 2077, 8,  7, 1,  0, 0}, // #1071
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 3, false, false, 2710, 6,  7, 1,  0, 0}, // #1072
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 3, false, false, 2710, 6,  7, 1,  0, 0}, // #1073
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 3, false, false, 2710, 6,  7, 1,  0, 0}, // #1074
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 4, false, false, 2716, 11,  7, 1,  0, 0}, // #1075
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 2, false, false, 160, 8,  6, 1,  0, 0}, // #1076
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm_VMOVDI2PDIZrm") 2, false, false, 128, 5,  6, 1,  0, 0}, // #1077
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 3, false, false, 2077, 8,  6, 1,  0, 0}, // #1078
  {DBGFIELD("VMOVSDZrm_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrmk_VMOVSSZrmkz") 2, false, false, 140, 10,  5, 1,  0, 0}, // #1079
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 2, false, false, 2365, 8,  5, 1,  0, 0}, // #1080
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 2, false, false, 2365, 8,  5, 1,  0, 0}, // #1081
  {DBGFIELD("VCVTPD2PSZ256rr_VCVTPD2PSZ256rrk_VCVTPD2PSZ256rrkz") 2, false, false, 2365, 8,  5, 1,  0, 0}, // #1082
  {DBGFIELD("VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 2, false, false, 2365, 8,  5, 1,  0, 0}, // #1083
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 2, false, false, 2365, 8,  5, 1,  0, 0}, // #1084
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 2, false, false, 2365, 8,  5, 1,  0, 0}, // #1085
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 2, false, false, 2202, 8,  5, 1,  0, 0}, // #1086
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 2, false, false, 2202, 8,  5, 1,  0, 0}, // #1087
  {DBGFIELD("VCVTPD2PSZrr")       2, false, false, 2202, 8,  5, 1,  0, 0}, // #1088
  {DBGFIELD("VCVTPS2PDZrr")       2, false, false, 2202, 8,  5, 1,  0, 0}, // #1089
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 2, false, false, 2202, 8,  5, 1,  0, 0}, // #1090
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 2, false, false, 2202, 8,  5, 1,  0, 0}, // #1091
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 2, false, false, 128, 5,  5, 1,  0, 0}, // #1092
  {DBGFIELD("VBROADCASTI32X2Z128m_VBROADCASTI32X2Z128mk_VBROADCASTI32X2Z128mkz_VPBROADCASTDZ128m_VPBROADCASTDZ128mk_VPBROADCASTDZ128mkz_VPBROADCASTQZ128m_VPBROADCASTQZ128mk_VPBROADCASTQZ128mkz") 2, false, false, 128, 5,  5, 1,  0, 0}, // #1093
  {DBGFIELD("VBROADCASTSSZ128m_VBROADCASTSSZ128mk_VBROADCASTSSZ128mkz") 2, false, false, 128, 5,  5, 1,  0, 0}, // #1094
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 2, false, false, 128, 5,  5, 1,  0, 0}, // #1095
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 2, false, false, 128, 5,  5, 1,  0, 0}, // #1096
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz_VMOVNTDQAZ128rm") 2, false, false, 128, 5,  5, 1,  0, 0}, // #1097
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 2, false, false, 128, 5,  5, 1,  0, 0}, // #1098
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 2, false, false, 128, 5,  5, 1,  0, 0}, // #1099
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 3, false, false, 2077, 8,  5, 1,  0, 0}, // #1100
  {DBGFIELD("VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 3, false, false, 2410, 12,  5, 1,  0, 0}, // #1101
  {DBGFIELD("VCVTSS2SI64rr_Int")  3, false, false, 2410, 12,  5, 1,  0, 0}, // #1102
  {DBGFIELD("VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int") 3, false, false, 2410, 12,  5, 1,  0, 0}, // #1103
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 3, false, false, 2727, 10,  5, 1,  0, 0}, // #1104
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 4, false, false, 2716, 11,  5, 1,  0, 0}, // #1105
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 7, false, false, 2737, 11,  5, 1,  0, 0}, // #1106
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 11, false, false, 2748, 11,  5, 1,  0, 0}, // #1107
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 19, false, false, 2759, 11,  5, 1,  0, 0}, // #1108
  {DBGFIELD("VSCATTERDPSZmr")     36, false, false, 2770, 14,  5, 1,  0, 0}, // #1109
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk") 2, false, false, 140, 10, 10, 1,  0, 0}, // #1110
  {DBGFIELD("VPBROADCASTBZ256m_VPBROADCASTBZ256mk_VPBROADCASTBZ256mkz_VPBROADCASTBZm_VPBROADCASTBZmk_VPBROADCASTBZmkz_VPBROADCASTWZ256m_VPBROADCASTWZ256mk_VPBROADCASTWZ256mkz_VPBROADCASTWZm_VPBROADCASTWZmk_VPBROADCASTWZmkz") 2, false, false, 140, 10, 10, 1,  0, 0}, // #1111
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 2, false, false, 128, 5, 10, 1,  0, 0}, // #1112
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 2, false, false, 128, 5, 10, 1,  0, 0}, // #1113
  {DBGFIELD("VBROADCASTF32X2Z256m_VBROADCASTF32X2Z256mk_VBROADCASTF32X2Z256mkz_VBROADCASTF32X2Zm_VBROADCASTF32X2Zmk_VBROADCASTF32X2Zmkz_VBROADCASTI32X2Z256m_VBROADCASTI32X2Z256mk_VBROADCASTI32X2Z256mkz_VBROADCASTI32X2Zm_VBROADCASTI32X2Zmk_VBROADCASTI32X2Zmkz_VPBROADCASTDZ256m_VPBROADCASTDZ256mk_VPBROADCASTDZ256mkz_VPBROADCASTDZm_VPBROADCASTDZmk_VPBROADCASTDZmkz_VPBROADCASTQZ256m_VPBROADCASTQZ256mk_VPBROADCASTQZ256mkz_VPBROADCASTQZm_VPBROADCASTQZmk_VPBROADCASTQZmkz") 2, false, false, 128, 5, 10, 1,  0, 0}, // #1114
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 2, false, false, 128, 5, 10, 1,  0, 0}, // #1115
  {DBGFIELD("VBROADCASTSDZ256m_VBROADCASTSDZ256mk_VBROADCASTSDZ256mkz_VBROADCASTSDZm_VBROADCASTSDZmk_VBROADCASTSDZmkz_VBROADCASTSSZ256m_VBROADCASTSSZ256mk_VBROADCASTSSZ256mkz_VBROADCASTSSZm_VBROADCASTSSZmk_VBROADCASTSSZmkz") 2, false, false, 128, 5, 10, 1,  0, 0}, // #1116
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 2, false, false, 128, 5, 10, 1,  0, 0}, // #1117
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 2, false, false, 128, 5, 10, 1,  0, 0}, // #1118
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 2, false, false, 128, 5, 10, 1,  0, 0}, // #1119
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, 128, 5, 10, 1,  0, 0}, // #1120
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 2, false, false, 128, 5, 10, 1,  0, 0}, // #1121
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz_VMOVNTDQAZ256rm") 2, false, false, 128, 5, 10, 1,  0, 0}, // #1122
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 2, false, false, 128, 5, 10, 1,  0, 0}, // #1123
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 2, false, false, 128, 5, 10, 1,  0, 0}, // #1124
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 2, false, false, 128, 5, 10, 1,  0, 0}, // #1125
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 2, false, false, 128, 5, 10, 1,  0, 0}, // #1126
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 8, false, false, 2784, 14, 10, 1,  0, 0}, // #1127
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 12, false, false, 2798, 14, 10, 1,  0, 0}, // #1128
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 20, false, false, 2812, 14, 10, 1,  0, 0}, // #1129
  {DBGFIELD("VPSCATTERDDZmr")     36, false, false, 2770, 14, 10, 1,  0, 0}, // #1130
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 2, false, false, 140, 10,  9, 1,  0, 0}, // #1131
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbi_alt_VCMPPDZ128rmbi_altk_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmi_alt_VCMPPDZ128rmi_altk_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbi_alt_VCMPPSZ128rmbi_altk_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmi_alt_VCMPPSZ128rmi_altk_VCMPPSZ128rmik") 2, false, false, 140, 10,  9, 1,  0, 0}, // #1132
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSDZrmi_alt_VCMPSDZrmi_altk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk_VCMPSSZrmi_alt_VCMPSSZrmi_altk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 2, false, false, 140, 10,  9, 1,  0, 0}, // #1133
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmi_alt_VPCMPBZ128rmik_VPCMPBZ128rmik_alt_VPCMPDZ128rmi_VPCMPDZ128rmi_alt_VPCMPDZ128rmib_VPCMPDZ128rmib_alt_VPCMPDZ128rmibk_VPCMPDZ128rmibk_alt_VPCMPDZ128rmik_VPCMPDZ128rmik_alt_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmi_alt_VPCMPQZ128rmib_VPCMPQZ128rmib_alt_VPCMPQZ128rmibk_VPCMPQZ128rmibk_alt_VPCMPQZ128rmik_VPCMPQZ128rmik_alt_VPCMPUBZ128rmi_VPCMPUBZ128rmi_alt_VPCMPUBZ128rmik_VPCMPUBZ128rmik_alt_VPCMPUDZ128rmi_VPCMPUDZ128rmi_alt_VPCMPUDZ128rmib_VPCMPUDZ128rmib_alt_VPCMPUDZ128rmibk_VPCMPUDZ128rmibk_alt_VPCMPUDZ128rmik_VPCMPUDZ128rmik_alt_VPCMPUQZ128rmi_VPCMPUQZ128rmi_alt_VPCMPUQZ128rmib_VPCMPUQZ128rmib_alt_VPCMPUQZ128rmibk_VPCMPUQZ128rmibk_alt_VPCMPUQZ128rmik_VPCMPUQZ128rmik_alt_VPCMPUWZ128rmi_VPCMPUWZ128rmi_alt_VPCMPUWZ128rmik_VPCMPUWZ128rmik_alt_VPCMPWZ128rmi_VPCMPWZ128rmi_alt_VPCMPWZ128rmik_VPCMPWZ128rmik_alt_VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 2, false, false, 140, 10,  9, 1,  0, 0}, // #1134
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 2, false, false, 140, 10,  9, 1,  0, 0}, // #1135
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 2, false, false, 140, 10,  9, 1,  0, 0}, // #1136
  {DBGFIELD("VPMOVSXBDZ128rm_VPMOVSXBDZ128rmk_VPMOVSXBDZ128rmkz_VPMOVSXBQZ128rm_VPMOVSXBQZ128rmk_VPMOVSXBQZ128rmkz_VPMOVSXBWZ128rm_VPMOVSXBWZ128rmk_VPMOVSXBWZ128rmkz_VPMOVSXDQZ128rm_VPMOVSXDQZ128rmk_VPMOVSXDQZ128rmkz_VPMOVSXWDZ128rm_VPMOVSXWDZ128rmk_VPMOVSXWDZ128rmkz_VPMOVSXWQZ128rm_VPMOVSXWQZ128rmk_VPMOVSXWQZ128rmkz_VPMOVZXBDZ128rm_VPMOVZXBDZ128rmk_VPMOVZXBDZ128rmkz_VPMOVZXBQZ128rm_VPMOVZXBQZ128rmk_VPMOVZXBQZ128rmkz_VPMOVZXBWZ128rm_VPMOVZXBWZ128rmk_VPMOVZXBWZ128rmkz_VPMOVZXDQZ128rm_VPMOVZXDQZ128rmk_VPMOVZXDQZ128rmkz_VPMOVZXWDZ128rm_VPMOVZXWDZ128rmk_VPMOVZXWDZ128rmkz_VPMOVZXWQZ128rm_VPMOVZXWQZ128rmk_VPMOVZXWQZ128rmkz") 2, false, false, 140, 10,  9, 1,  0, 0}, // #1137
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 2, false, false, 140, 10,  9, 1,  0, 0}, // #1138
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 2, false, false, 140, 10, 18, 1,  0, 0}, // #1139
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 2, false, false, 140, 10, 18, 1,  0, 0}, // #1140
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbi_alt_VCMPPDZ256rmbi_altk_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmi_alt_VCMPPDZ256rmi_altk_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbi_alt_VCMPPSZ256rmbi_altk_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmi_alt_VCMPPSZ256rmi_altk_VCMPPSZ256rmik") 2, false, false, 140, 10, 18, 1,  0, 0}, // #1141
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbi_alt_VCMPPDZrmbi_altk_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmi_alt_VCMPPDZrmi_altk_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbi_alt_VCMPPSZrmbi_altk_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmi_alt_VCMPPSZrmi_altk_VCMPPSZrmik") 2, false, false, 140, 10, 18, 1,  0, 0}, // #1142
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmi_alt_VPCMPBZ256rmik_VPCMPBZ256rmik_alt_VPCMPDZ256rmi_VPCMPDZ256rmi_alt_VPCMPDZ256rmib_VPCMPDZ256rmib_alt_VPCMPDZ256rmibk_VPCMPDZ256rmibk_alt_VPCMPDZ256rmik_VPCMPDZ256rmik_alt_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmi_alt_VPCMPQZ256rmib_VPCMPQZ256rmib_alt_VPCMPQZ256rmibk_VPCMPQZ256rmibk_alt_VPCMPQZ256rmik_VPCMPQZ256rmik_alt_VPCMPUBZ256rmi_VPCMPUBZ256rmi_alt_VPCMPUBZ256rmik_VPCMPUBZ256rmik_alt_VPCMPUDZ256rmi_VPCMPUDZ256rmi_alt_VPCMPUDZ256rmib_VPCMPUDZ256rmib_alt_VPCMPUDZ256rmibk_VPCMPUDZ256rmibk_alt_VPCMPUDZ256rmik_VPCMPUDZ256rmik_alt_VPCMPUQZ256rmi_VPCMPUQZ256rmi_alt_VPCMPUQZ256rmib_VPCMPUQZ256rmib_alt_VPCMPUQZ256rmibk_VPCMPUQZ256rmibk_alt_VPCMPUQZ256rmik_VPCMPUQZ256rmik_alt_VPCMPUWZ256rmi_VPCMPUWZ256rmi_alt_VPCMPUWZ256rmik_VPCMPUWZ256rmik_alt_VPCMPWZ256rmi_VPCMPWZ256rmi_alt_VPCMPWZ256rmik_VPCMPWZ256rmik_alt_VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 2, false, false, 140, 10, 18, 1,  0, 0}, // #1143
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmi_alt_VPCMPBZrmik_VPCMPBZrmik_alt_VPCMPDZrmi_VPCMPDZrmi_alt_VPCMPDZrmib_VPCMPDZrmib_alt_VPCMPDZrmibk_VPCMPDZrmibk_alt_VPCMPDZrmik_VPCMPDZrmik_alt_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmi_alt_VPCMPQZrmib_VPCMPQZrmib_alt_VPCMPQZrmibk_VPCMPQZrmibk_alt_VPCMPQZrmik_VPCMPQZrmik_alt_VPCMPUBZrmi_VPCMPUBZrmi_alt_VPCMPUBZrmik_VPCMPUBZrmik_alt_VPCMPUDZrmi_VPCMPUDZrmi_alt_VPCMPUDZrmib_VPCMPUDZrmib_alt_VPCMPUDZrmibk_VPCMPUDZrmibk_alt_VPCMPUDZrmik_VPCMPUDZrmik_alt_VPCMPUQZrmi_VPCMPUQZrmi_alt_VPCMPUQZrmib_VPCMPUQZrmib_alt_VPCMPUQZrmibk_VPCMPUQZrmibk_alt_VPCMPUQZrmik_VPCMPUQZrmik_alt_VPCMPUWZrmi_VPCMPUWZrmi_alt_VPCMPUWZrmik_VPCMPUWZrmik_alt_VPCMPWZrmi_VPCMPWZrmi_alt_VPCMPWZrmik_VPCMPWZrmik_alt_VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 2, false, false, 140, 10, 18, 1,  0, 0}, // #1144
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 2, false, false, 140, 10, 18, 1,  0, 0}, // #1145
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 2, false, false, 140, 10, 18, 1,  0, 0}, // #1146
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 2, false, false, 128, 5, 18, 1,  0, 0}, // #1147
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 2, false, false, 128, 5, 18, 1,  0, 0}, // #1148
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 2, false, false, 128, 5, 18, 1,  0, 0}, // #1149
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 2, false, false, 128, 5, 18, 1,  0, 0}, // #1150
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 2, false, false, 128, 5, 18, 1,  0, 0}, // #1151
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 2, false, false, 128, 5, 18, 1,  0, 0}, // #1152
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz") 2, false, false, 128, 5, 18, 1,  0, 0}, // #1153
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 3, false, false, 150, 10, 18, 1,  0, 0}, // #1154
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 2, false, false, 128, 5, 26, 1,  0, 0}, // #1155
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 2, false, false, 128, 5, 26, 1,  0, 0}, // #1156
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 2, false, false, 128, 5, 26, 1,  0, 0}, // #1157
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 2, false, false, 128, 5, 26, 1,  0, 0}, // #1158
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 2, false, false, 128, 5, 26, 1,  0, 0}, // #1159
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 2, false, false, 128, 5, 26, 1,  0, 0}, // #1160
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 2, false, false, 128, 5, 26, 1,  0, 0}, // #1161
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 2, false, false, 128, 5, 26, 1,  0, 0}, // #1162
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 2, false, false, 128, 5, 26, 1,  0, 0}, // #1163
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 2, false, false, 128, 5, 26, 1,  0, 0}, // #1164
  {DBGFIELD("VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 2, false, false, 128, 5, 26, 1,  0, 0}, // #1165
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 2, false, false, 128, 5, 26, 1,  0, 0}, // #1166
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 3, false, false, 150, 10, 26, 1,  0, 0}, // #1167
  {DBGFIELD("VCVTSD2SSZrm_VCVTSD2SSZrm_Int_VCVTSD2SSZrm_Intk_VCVTSD2SSZrm_Intkz") 3, false, false, 614, 5, 26, 1,  0, 0}, // #1168
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 4, false, false, 2067, 10, 26, 1,  0, 0}, // #1169
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 3, false, false, 2826, 4, 19, 1,  0, 0}, // #1170
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 3, false, false, 2826, 4, 19, 1,  0, 0}, // #1171
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 3, false, false, 2830, 5, 19, 1,  0, 0}, // #1172
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 3, false, false, 150, 10, 19, 1,  0, 0}, // #1173
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 3, false, false, 2835, 11, 19, 1,  0, 0}, // #1174
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 3, false, false, 2835, 11, 19, 1,  0, 0}, // #1175
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 3, false, false, 1309, 10, 19, 1,  0, 0}, // #1176
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 3, false, false, 150, 10, 27, 1,  0, 0}, // #1177
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 4, false, false, 2067, 10, 27, 1,  0, 0}, // #1178
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 3, false, false, 1309, 10, 25, 1,  0, 0}, // #1179
  {DBGFIELD("VCVTPD2PSZrm_VCVTPD2PSZrmb_VCVTPD2PSZrmbk_VCVTPD2PSZrmbkz_VCVTPD2PSZrmk_VCVTPD2PSZrmkz") 3, false, false, 1309, 10, 25, 1,  0, 0}, // #1180
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 3, false, false, 1309, 10, 25, 1,  0, 0}, // #1181
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 4, false, false, 2067, 10, 25, 1,  0, 0}, // #1182
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 8, false, false, 2846, 13, 24, 1,  0, 0}, // #1183
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 4, false, false, 2859, 5, 29, 1,  0, 0}, // #1184
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 4, false, false, 2859, 5, 65, 1,  0, 0}, // #1185
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 4, false, false, 2859, 5, 65, 1,  0, 0}, // #1186
  {DBGFIELD("VGATHERDPSZ128rm_VGATHERQPSZrm_VPGATHERDDZ128rm") 0, false, false,  0, 0, 30, 1,  0, 0}, // #1187
  {DBGFIELD("VGATHERQPSZ128rm_VGATHERQPSZ256rm_VPGATHERQDZ128rm_VPGATHERQDZ256rm") 5, false, false, 2864, 11, 30, 1,  0, 0}, // #1188
  {DBGFIELD("VGATHERDPDZ128rm_VGATHERQPDZ128rm_VPGATHERDQZ128rm_VPGATHERQQZ128rm") 5, false, false, 2864, 11, 32, 1,  0, 0}, // #1189
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz") 14, false, false, 2875, 9, 32, 1,  0, 0}, // #1190
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 14, false, false, 2875, 9, 32, 1,  0, 0}, // #1191
  {DBGFIELD("VGATHERDPDZ256rm_VGATHERQPDZ256rm_VPGATHERDQZ256rm_VPGATHERQDZrm_VPGATHERQQZ256rm") 5, false, false, 2864, 11, 34, 1,  0, 0}, // #1192
  {DBGFIELD("VGATHERDPDZrm_VGATHERQPDZrm_VPGATHERDQZrm_VPGATHERQQZrm") 5, false, false, 2864, 11, 35, 1,  0, 0}, // #1193
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm") 5, false, false, 2864, 11, 74, 1,  0, 0}, // #1194
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 15, false, false, 2884, 11, 36, 1,  0, 0}, // #1195
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 5, false, false, 2864, 11, 37, 1,  0, 0}, // #1196
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz") 21, false, false, 2895, 9, 97, 1,  0, 0}, // #1197
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 21, false, false, 2895, 9, 97, 1,  0, 0}, // #1198
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 22, false, false, 2904, 11, 83, 1,  0, 0}, // #1199
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 22, false, false, 2904, 11, 83, 1,  0, 0}, // #1200
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz") 35, false, false, 2915, 9, 102, 1,  0, 0}, // #1201
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 36, false, false, 2924, 11, 46, 1,  0, 0}, // #1202
  {DBGFIELD("JWriteZeroLatency")  0, false, false,  0, 0,  0, 0,  0, 0}, // #1203
  {DBGFIELD("WriteVecALU")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1204
  {DBGFIELD("WriteVecALUX")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1205
  {DBGFIELD("WriteALU")           0, false, false,  0, 0,  0, 0,  0, 0}, // #1206
  {DBGFIELD("WriteFLogic")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1207
  {DBGFIELD("WriteVecLogic")      0, false, false,  0, 0,  0, 0,  0, 0}, // #1208
  {DBGFIELD("WriteVecLogicX")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1209
  {DBGFIELD("JWrite3OpsLEA")      0, false, false,  0, 0,  0, 0,  0, 0}, // #1210
  {DBGFIELD("WriteLEA")           0, false, false,  0, 0,  0, 0,  0, 0}, // #1211
}; // SkylakeServerModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc SandyBridgeModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  16383, false, false,  0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteZero")          1, false, false,  0, 0,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteVecALU")        1, false, false, 2935, 5, 21, 1,  0, 0}, // #2
  {DBGFIELD("WriteALULd_WriteRMW") 3, false, false, 2940, 4, 63, 2,  0, 0}, // #3
  {DBGFIELD("WriteJumpLd")        2, false, false, 2944, 6,  6, 1,  0, 0}, // #4
  {DBGFIELD("WriteALU")           1, false, false, 226, 2,  1, 1,  0, 0}, // #5
  {DBGFIELD("WriteMove")          1, false, false, 226, 2,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteJump")          1, false, false, 2950, 5,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, 226, 2,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteFStoreX")       1, false, false, 2955, 3,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteFLoadX")        1, false, false, 2958, 2,  6, 1,  0, 0}, // #10
  {DBGFIELD("WriteFStoreY")       1, false, false, 2955, 3,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteFLoadY")        1, false, false, 2958, 2,  5, 1,  0, 0}, // #12
  {DBGFIELD("WriteMicrocoded")    1, false, false, 226, 2,  4, 1,  0, 0}, // #13
  {DBGFIELD("WriteFSign")         1, false, false, 2950, 5,  1, 1,  0, 0}, // #14
  {DBGFIELD("WriteADC")           2, false, false, 787, 3, 20, 1,  0, 0}, // #15
  {DBGFIELD("WriteADCRMW")        6, false, false, 2960, 4,  9, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCLd_ReadAfterLd") 3, false, false, 2964, 4,  5, 1,  9, 1}, // #17
  {DBGFIELD("WriteALURMW")        3, false, false, 2940, 4,  5, 1,  0, 0}, // #18
  {DBGFIELD("WriteALULd_ReadAfterLd") 2, false, false, 2947, 3,  6, 1,  9, 1}, // #19
  {DBGFIELD("WriteFAdd64XLd_ReadAfterLd") 2, false, false, 2968, 6,  9, 1,  9, 1}, // #20
  {DBGFIELD("WriteFAdd64X")       1, false, false, 2935, 5, 21, 1,  0, 0}, // #21
  {DBGFIELD("WriteFAddXLd_ReadAfterLd") 2, false, false, 2968, 6,  9, 1,  9, 1}, // #22
  {DBGFIELD("WriteFAddX")         1, false, false, 2935, 5, 21, 1,  0, 0}, // #23
  {DBGFIELD("WriteFAdd64Ld_ReadAfterLd") 2, false, false, 2968, 6,  9, 1,  9, 1}, // #24
  {DBGFIELD("WriteFAdd64")        1, false, false, 2935, 5, 21, 1,  0, 0}, // #25
  {DBGFIELD("WriteFAddLd_ReadAfterLd") 2, false, false, 2968, 6,  9, 1,  9, 1}, // #26
  {DBGFIELD("WriteFAdd")          1, false, false, 2935, 5, 21, 1,  0, 0}, // #27
  {DBGFIELD("WriteFAddLd")        2, false, false, 2968, 6,  9, 1,  0, 0}, // #28
  {DBGFIELD("WriteAESDecEncLd_ReadAfterLd") 3, false, false, 2974, 6, 27, 1,  9, 1}, // #29
  {DBGFIELD("WriteAESDecEnc")     2, false, false, 2980, 5,  5, 1,  0, 0}, // #30
  {DBGFIELD("WriteAESIMCLd")      3, false, false, 2985, 6, 29, 1,  0, 0}, // #31
  {DBGFIELD("WriteAESIMC")        2, false, false, 2991, 5, 19, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESKeyGenLd")   1, false, false, 2996, 3, 10, 1,  0, 0}, // #33
  {DBGFIELD("WriteAESKeyGen")     1, false, false, 2999, 2, 10, 1,  0, 0}, // #34
  {DBGFIELD("WriteFLogicLd_ReadAfterLd") 2, false, false, 2944, 6,  5, 1,  9, 1}, // #35
  {DBGFIELD("WriteFLogic")        1, false, false, 2950, 5,  1, 1,  0, 0}, // #36
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 3001, 7,  5, 1, 10, 1}, // #37
  {DBGFIELD("WriteBEXTR")         2, false, false, 3008, 6, 20, 1,  0, 0}, // #38
  {DBGFIELD("WriteBEXTRLd")       3, false, false, 3001, 7,  5, 1,  0, 0}, // #39
  {DBGFIELD("WriteALULd")         2, false, false, 2947, 3,  6, 1,  0, 0}, // #40
  {DBGFIELD("WriteFBlendLd_ReadAfterLd") 2, false, false, 3014, 4,  5, 1,  9, 1}, // #41
  {DBGFIELD("WriteFBlend")        1, false, false, 382, 3,  1, 1,  0, 0}, // #42
  {DBGFIELD("WriteFVarBlendLd_ReadAfterLd") 3, false, false, 3018, 4, 10, 1,  9, 1}, // #43
  {DBGFIELD("WriteFVarBlend")     2, false, false, 3022, 3, 20, 1,  0, 0}, // #44
  {DBGFIELD("WriteBSFLd")         2, false, false, 2968, 6, 10, 1,  0, 0}, // #45
  {DBGFIELD("WriteBSF")           1, false, false, 2935, 5, 21, 1,  0, 0}, // #46
  {DBGFIELD("WriteBSRLd")         2, false, false, 2968, 6, 10, 1,  0, 0}, // #47
  {DBGFIELD("WriteBSR")           1, false, false, 2935, 5, 21, 1,  0, 0}, // #48
  {DBGFIELD("WriteBSWAP32")       1, false, false, 2935, 5,  1, 1,  0, 0}, // #49
  {DBGFIELD("WriteBSWAP64")       2, false, false, 3008, 6, 20, 1,  0, 0}, // #50
  {DBGFIELD("WriteBitTest")       1, false, false, 382, 3,  1, 1,  0, 0}, // #51
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 2968, 6,  6, 1, 10, 1}, // #52
  {DBGFIELD("WriteBZHI")          1, false, false, 2935, 5,  1, 1,  0, 0}, // #53
  {DBGFIELD("WriteLoad")          1, false, false, 2958, 2,  7, 1,  0, 0}, // #54
  {DBGFIELD("WriteCMOV2Ld_ReadAfterLd") 4, false, false, 3025, 4, 10, 1,  9, 1}, // #55
  {DBGFIELD("WriteCMOV2")         3, false, false, 3029, 3, 21, 1,  0, 0}, // #56
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 3, false, false, 2964, 4,  5, 1,  9, 1}, // #57
  {DBGFIELD("WriteCMOV")          2, false, false, 787, 3, 20, 1,  0, 0}, // #58
  {DBGFIELD("WriteFCMOV")         3, false, false, 3032, 5, 21, 1,  0, 0}, // #59
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 2947, 3,  6, 1, 10, 1}, // #60
  {DBGFIELD("WriteFCmp64XLd_ReadAfterLd") 2, false, false, 2968, 6,  9, 1,  9, 1}, // #61
  {DBGFIELD("WriteFCmp64X")       1, false, false, 2935, 5, 21, 1,  0, 0}, // #62
  {DBGFIELD("WriteFCmpXLd_ReadAfterLd") 2, false, false, 2968, 6,  9, 1,  9, 1}, // #63
  {DBGFIELD("WriteFCmpX")         1, false, false, 2935, 5, 21, 1,  0, 0}, // #64
  {DBGFIELD("WriteFCmp64Ld_ReadAfterLd") 2, false, false, 2968, 6,  9, 1,  9, 1}, // #65
  {DBGFIELD("WriteFCmp64")        1, false, false, 2935, 5, 21, 1,  0, 0}, // #66
  {DBGFIELD("WriteFCmpLd_ReadAfterLd") 2, false, false, 2968, 6,  9, 1,  9, 1}, // #67
  {DBGFIELD("WriteFCmp")          1, false, false, 2935, 5, 21, 1,  0, 0}, // #68
  {DBGFIELD("WriteFComLd_ReadAfterLd") 2, false, false, 2968, 6, 10, 1,  9, 1}, // #69
  {DBGFIELD("WriteFCom")          1, false, false, 2935, 5, 21, 1,  0, 0}, // #70
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 2, false, false, 2968, 6, 10, 1,  9, 1}, // #71
  {DBGFIELD("WriteCRC32")         1, false, false, 2935, 5, 21, 1,  0, 0}, // #72
  {DBGFIELD("WriteNop")           1, false, false,  0, 0,  1, 1,  0, 0}, // #73
  {DBGFIELD("WriteCvtI2PDLd")     3, false, false, 3037, 8, 18, 1,  0, 0}, // #74
  {DBGFIELD("WriteCvtI2PD")       2, false, false, 3045, 7, 22, 1,  0, 0}, // #75
  {DBGFIELD("WriteCvtI2PSLd")     2, false, false, 2968, 6,  9, 1,  0, 0}, // #76
  {DBGFIELD("WriteCvtI2PS")       1, false, false, 2935, 5, 21, 1,  0, 0}, // #77
  {DBGFIELD("WriteCvtPD2ILd")     3, false, false, 3037, 8, 18, 1,  0, 0}, // #78
  {DBGFIELD("WriteCvtPD2I")       2, false, false, 3045, 7, 22, 1,  0, 0}, // #79
  {DBGFIELD("WriteCvtPD2PSLd")    3, false, false, 3037, 8, 18, 1,  0, 0}, // #80
  {DBGFIELD("WriteCvtPD2PS")      2, false, false, 3045, 7, 22, 1,  0, 0}, // #81
  {DBGFIELD("WriteCvtPS2ILd")     2, false, false, 2968, 6,  9, 1,  0, 0}, // #82
  {DBGFIELD("WriteCvtPS2I")       1, false, false, 2935, 5, 21, 1,  0, 0}, // #83
  {DBGFIELD("WriteCvtPS2PDLd")    2, false, false, 3052, 6,  5, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtPS2PD")      2, false, false, 3058, 7, 20, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtSD2ILd")     3, false, false, 3065, 8, 18, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtSD2I")       2, false, false, 3073, 7,  7, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtSD2SSLd")    3, false, false, 3037, 8, 18, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterLd") 3, false, false, 3037, 8, 18, 1,  9, 1}, // #89
  {DBGFIELD("WriteCvtSD2SS")      2, false, false, 3045, 7, 22, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, 2968, 6,  9, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterLd") 2, false, false, 2968, 6,  9, 1,  9, 1}, // #92
  {DBGFIELD("WriteCvtI2SD")       2, false, false, 3045, 7, 22, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtI2SSLd")     3, false, false, 3037, 8, 18, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterLd") 3, false, false, 3037, 8, 18, 1,  9, 1}, // #95
  {DBGFIELD("WriteCvtI2SS")       3, false, false, 3080, 7,  7, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtSS2SDLd")    2, false, false, 3052, 6,  5, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterLd") 2, false, false, 3052, 6,  5, 1,  9, 1}, // #98
  {DBGFIELD("WriteCvtSS2SD")      1, false, false, 3087, 5,  1, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtSS2ILd")     3, false, false, 3065, 8, 18, 1,  0, 0}, // #100
  {DBGFIELD("WriteCvtSS2I")       2, false, false, 3073, 7,  7, 1,  0, 0}, // #101
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 3092, 7, 37, 1, 11, 2}, // #102
  {DBGFIELD("WriteDiv16")         1, false, false, 3099, 6, 34, 1,  0, 0}, // #103
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 3092, 7, 37, 1, 11, 2}, // #104
  {DBGFIELD("WriteDiv32")         1, false, false, 3099, 6, 34, 1,  0, 0}, // #105
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 3092, 7, 37, 1, 11, 2}, // #106
  {DBGFIELD("WriteDiv64")         1, false, false, 3099, 6, 34, 1,  0, 0}, // #107
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 3092, 7, 37, 1, 11, 2}, // #108
  {DBGFIELD("WriteDiv8")          1, false, false, 3099, 6, 34, 1,  0, 0}, // #109
  {DBGFIELD("WriteFDiv64XLd_ReadAfterLd") 2, false, false, 3105, 7, 82, 1,  9, 1}, // #110
  {DBGFIELD("WriteFDiv64X")       1, false, false, 3112, 6, 32, 1,  0, 0}, // #111
  {DBGFIELD("WriteFDivXLd_ReadAfterLd") 2, false, false, 3118, 7, 30, 1,  9, 1}, // #112
  {DBGFIELD("WriteFDivX")         1, false, false, 3125, 6, 25, 1,  0, 0}, // #113
  {DBGFIELD("WriteFDivLd")        2, false, false, 3118, 7, 30, 1,  0, 0}, // #114
  {DBGFIELD("WriteFDiv")          1, false, false, 3125, 6, 25, 1,  0, 0}, // #115
  {DBGFIELD("WriteFDiv64Ld_ReadAfterLd") 2, false, false, 3105, 7, 82, 1,  9, 1}, // #116
  {DBGFIELD("WriteFDiv64")        1, false, false, 3112, 6, 32, 1,  0, 0}, // #117
  {DBGFIELD("WriteFDivLd_ReadAfterLd") 2, false, false, 3118, 7, 30, 1,  9, 1}, // #118
  {DBGFIELD("WriteDPPDLd_ReadAfterLd") 4, false, false, 3131, 9, 24, 1,  9, 1}, // #119
  {DBGFIELD("WriteDPPD")          3, false, false, 3140, 8,  9, 1,  0, 0}, // #120
  {DBGFIELD("WriteDPPSLd_ReadAfterLd") 5, false, false, 3148, 9, 29, 1,  9, 1}, // #121
  {DBGFIELD("WriteDPPS")          4, false, false, 3157, 8, 19, 1,  0, 0}, // #122
  {DBGFIELD("WriteVecExtractSt")  3, false, false, 3165, 5,  7, 1,  0, 0}, // #123
  {DBGFIELD("WriteVecExtract")    2, false, false, 3170, 6, 21, 1,  0, 0}, // #124
  {DBGFIELD("WriteVecALUX")       1, false, false, 1604, 3,  1, 1,  0, 0}, // #125
  {DBGFIELD("WriteFComLd")        2, false, false, 2968, 6, 10, 1,  0, 0}, // #126
  {DBGFIELD("WriteEMMS")          31, false, false, 3176, 2, 67, 1,  0, 0}, // #127
  {DBGFIELD("WriteFLDC")          2, false, false, 3073, 7,  1, 1,  0, 0}, // #128
  {DBGFIELD("WriteVecALUXLd_ReadAfterLd") 2, false, false, 2946, 4,  5, 1,  9, 1}, // #129
  {DBGFIELD("WriteFHAddLd_ReadAfterLd") 4, false, false, 3178, 8, 26, 1,  9, 1}, // #130
  {DBGFIELD("WriteFHAdd")         3, false, false, 3080, 7,  7, 1,  0, 0}, // #131
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 3092, 7, 37, 1, 11, 2}, // #132
  {DBGFIELD("WriteIDiv16")        1, false, false, 3099, 6, 34, 1,  0, 0}, // #133
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 3092, 7, 37, 1, 11, 2}, // #134
  {DBGFIELD("WriteIDiv32")        1, false, false, 3099, 6, 34, 1,  0, 0}, // #135
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 3092, 7, 37, 1, 11, 2}, // #136
  {DBGFIELD("WriteIDiv64")        1, false, false, 3099, 6, 34, 1,  0, 0}, // #137
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 3092, 7, 37, 1, 11, 2}, // #138
  {DBGFIELD("WriteIDiv8")         1, false, false, 3099, 6, 34, 1,  0, 0}, // #139
  {DBGFIELD("WriteIMulLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2968, 6, 10, 1, 11, 2}, // #140
  {DBGFIELD("WriteIMul")          1, false, false, 2935, 5, 21, 1,  0, 0}, // #141
  {DBGFIELD("WriteIMulLd_ReadAfterLd") 2, false, false, 2968, 6, 10, 1,  9, 1}, // #142
  {DBGFIELD("WriteIMulLd")        2, false, false, 2968, 6, 10, 1,  0, 0}, // #143
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2968, 6, 10, 1, 11, 2}, // #144
  {DBGFIELD("WriteIMul64")        1, false, false, 2935, 5, 21, 1,  0, 0}, // #145
  {DBGFIELD("WriteIMul64Ld_ReadAfterLd") 2, false, false, 2968, 6, 10, 1,  9, 1}, // #146
  {DBGFIELD("WriteIMul64Ld")      2, false, false, 2968, 6, 10, 1,  0, 0}, // #147
  {DBGFIELD("WriteFShuffleLd_ReadAfterLd") 2, false, false, 2944, 6,  5, 1,  9, 1}, // #148
  {DBGFIELD("WriteFShuffle")      1, false, false, 2950, 5,  1, 1,  0, 0}, // #149
  {DBGFIELD("WriteStore")         1, false, false, 2955, 3,  1, 1,  0, 0}, // #150
  {DBGFIELD("WriteVecLogicX")     1, false, false, 226, 2,  1, 1,  0, 0}, // #151
  {DBGFIELD("WriteShuffle")       1, false, false, 2950, 5,  1, 1,  0, 0}, // #152
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, 382, 3,  1, 1,  0, 0}, // #153
  {DBGFIELD("WriteVecLoadX")      1, false, false, 2958, 2,  6, 1,  0, 0}, // #154
  {DBGFIELD("WriteLDMXCSR")       4, false, false, 3186, 9,  7, 1,  0, 0}, // #155
  {DBGFIELD("WriteFLD0")          1, false, false, 2950, 5,  1, 1,  0, 0}, // #156
  {DBGFIELD("WriteFLD1")          2, false, false, 3058, 7,  1, 1,  0, 0}, // #157
  {DBGFIELD("WriteLEA")           1, false, false, 710, 3,  1, 1,  0, 0}, // #158
  {DBGFIELD("WriteFence")         1, false, false, 2955, 3,  1, 1,  0, 0}, // #159
  {DBGFIELD("WriteLZCNTLd")       2, false, false, 2968, 6, 10, 1,  0, 0}, // #160
  {DBGFIELD("WriteLZCNT")         1, false, false, 2935, 5, 21, 1,  0, 0}, // #161
  {DBGFIELD("WriteVecStoreX")     1, false, false, 2955, 3,  1, 1,  0, 0}, // #162
  {DBGFIELD("WriteVecStore")      1, false, false, 2955, 3,  1, 1,  0, 0}, // #163
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, 3087, 5, 20, 1,  0, 0}, // #164
  {DBGFIELD("WriteVecLoad")       1, false, false, 2958, 2,  7, 1,  0, 0}, // #165
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, 2950, 5,  1, 1,  0, 0}, // #166
  {DBGFIELD("WriteVecMoveX")      1, false, false, 226, 2,  1, 1,  0, 0}, // #167
  {DBGFIELD("WriteVecStoreNT")    1, false, false, 2955, 3,  1, 1,  0, 0}, // #168
  {DBGFIELD("WriteVecMove")       1, false, false, 382, 3,  1, 1,  0, 0}, // #169
  {DBGFIELD("WriteVecALULd")      2, false, false, 2968, 6, 10, 1,  0, 0}, // #170
  {DBGFIELD("WriteShuffleLd_ReadAfterLd") 2, false, false, 2944, 6,  6, 1,  9, 1}, // #171
  {DBGFIELD("WriteVecALULd_ReadAfterLd") 2, false, false, 2968, 6, 10, 1,  9, 1}, // #172
  {DBGFIELD("WriteVecLogicLd_ReadAfterLd") 2, false, false, 2947, 3,  6, 1,  9, 1}, // #173
  {DBGFIELD("WriteVecLogic")      1, false, false, 226, 2,  1, 1,  0, 0}, // #174
  {DBGFIELD("WritePHAddLd_ReadAfterLd") 4, false, false, 3182, 4, 10, 1,  9, 1}, // #175
  {DBGFIELD("WritePHAdd")         3, false, false, 3084, 3, 21, 1,  0, 0}, // #176
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 2, false, false, 2946, 4,  5, 1,  9, 1}, // #177
  {DBGFIELD("WriteVecInsert")     2, false, false, 3195, 5, 20, 1,  0, 0}, // #178
  {DBGFIELD("WriteVecIMulLd_ReadAfterLd") 2, false, false, 3052, 6, 18, 1,  9, 1}, // #179
  {DBGFIELD("WriteVecIMul")       1, false, false, 3087, 5,  7, 1,  0, 0}, // #180
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, 3087, 5,  1, 1,  0, 0}, // #181
  {DBGFIELD("WritePSADBWLd_ReadAfterLd") 2, false, false, 3052, 6, 18, 1,  9, 1}, // #182
  {DBGFIELD("WritePSADBW")        1, false, false, 3087, 5,  7, 1,  0, 0}, // #183
  {DBGFIELD("WriteVarShuffleLd_ReadAfterLd") 2, false, false, 2946, 4,  6, 1,  9, 1}, // #184
  {DBGFIELD("WriteVarShuffle")    1, false, false, 1604, 3,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteShuffleLd")     2, false, false, 2944, 6,  6, 1,  0, 0}, // #186
  {DBGFIELD("WriteVecShiftImm")   1, false, false, 2950, 5,  1, 1,  0, 0}, // #187
  {DBGFIELD("WriteVecShiftLd_ReadAfterLd") 2, false, false, 2944, 6,  6, 1,  9, 1}, // #188
  {DBGFIELD("WriteVecShift")      1, false, false, 2950, 5,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteFMoveX")        1, false, false, 2950, 5,  1, 1,  0, 0}, // #190
  {DBGFIELD("WriteFShuffleLd")    2, false, false, 2944, 6,  5, 1,  0, 0}, // #191
  {DBGFIELD("WriteFStore")        1, false, false, 2955, 3,  1, 1,  0, 0}, // #192
  {DBGFIELD("WriteFMOVMSK")       1, false, false, 3087, 5, 20, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecLoadNT")     1, false, false, 2958, 2,  6, 1,  0, 0}, // #194
  {DBGFIELD("WriteStoreNT")       1, false, false, 2955, 3,  1, 1,  0, 0}, // #195
  {DBGFIELD("WriteFStoreNTX")     1, false, false, 2955, 3,  1, 1,  0, 0}, // #196
  {DBGFIELD("WriteFStoreNT")      1, false, false, 2955, 3,  1, 1,  0, 0}, // #197
  {DBGFIELD("WriteFLoad")         1, false, false, 2958, 2,  7, 1,  0, 0}, // #198
  {DBGFIELD("WriteMPSADLd_ReadAfterLd") 4, false, false, 3200, 7, 27, 1,  9, 1}, // #199
  {DBGFIELD("WriteMPSAD")         3, false, false, 3207, 6,  5, 1,  0, 0}, // #200
  {DBGFIELD("WriteFMul64XLd_ReadAfterLd") 2, false, false, 3052, 6, 26, 1,  9, 1}, // #201
  {DBGFIELD("WriteFMul64X")       1, false, false, 3087, 5,  7, 1,  0, 0}, // #202
  {DBGFIELD("WriteFMulXLd_ReadAfterLd") 2, false, false, 3052, 6, 26, 1,  9, 1}, // #203
  {DBGFIELD("WriteFMulX")         1, false, false, 3087, 5,  7, 1,  0, 0}, // #204
  {DBGFIELD("WriteFMul64Ld_ReadAfterLd") 2, false, false, 3052, 6, 26, 1,  9, 1}, // #205
  {DBGFIELD("WriteFMul64")        1, false, false, 3087, 5,  7, 1,  0, 0}, // #206
  {DBGFIELD("WriteFMulLd_ReadAfterLd") 2, false, false, 3052, 6, 26, 1,  9, 1}, // #207
  {DBGFIELD("WriteFMul")          1, false, false, 3087, 5,  7, 1,  0, 0}, // #208
  {DBGFIELD("WriteIMulLd_WriteIMulH") 3, false, false, 2968, 6, 68, 2,  0, 0}, // #209
  {DBGFIELD("WriteIMul_WriteIMulH") 2, false, false, 2935, 5, 69, 2,  0, 0}, // #210
  {DBGFIELD("WriteIMul64Ld_WriteIMulH") 3, false, false, 2968, 6, 68, 2,  0, 0}, // #211
  {DBGFIELD("WriteIMul64_WriteIMulH") 2, false, false, 2935, 5, 69, 2,  0, 0}, // #212
  {DBGFIELD("WriteFMulLd")        2, false, false, 3052, 6, 26, 1,  0, 0}, // #213
  {DBGFIELD("WriteVecALUXLd")     2, false, false, 2946, 4,  5, 1,  0, 0}, // #214
  {DBGFIELD("WriteShuffleXLd_ReadAfterLd") 2, false, false, 2946, 4,  5, 1,  9, 1}, // #215
  {DBGFIELD("WriteShuffleX")      1, false, false, 1604, 3,  1, 1,  0, 0}, // #216
  {DBGFIELD("WriteVecLogicXLd_ReadAfterLd") 2, false, false, 2947, 3,  5, 1,  9, 1}, // #217
  {DBGFIELD("WriteVarBlendLd_ReadAfterLd") 3, false, false, 2987, 4, 10, 1,  9, 1}, // #218
  {DBGFIELD("WriteVarBlend")      2, false, false, 1844, 3, 20, 1,  0, 0}, // #219
  {DBGFIELD("WriteBlendLd_ReadAfterLd") 2, false, false, 2946, 4,  5, 1,  9, 1}, // #220
  {DBGFIELD("WriteBlend")         1, false, false, 1604, 3,  1, 1,  0, 0}, // #221
  {DBGFIELD("WriteCLMulLd_ReadAfterLd") 1, false, false, 3213, 3, 25, 1,  9, 1}, // #222
  {DBGFIELD("WriteCLMul")         1, false, false, 3216, 2, 25, 1,  0, 0}, // #223
  {DBGFIELD("WritePCmpEStrILd_ReadAfterLd") 1, false, false, 3218, 3, 22, 1,  9, 1}, // #224
  {DBGFIELD("WritePCmpEStrI")     1, false, false, 3221, 2, 22, 1,  0, 0}, // #225
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterLd") 1, false, false, 3218, 3, 26, 1,  9, 1}, // #226
  {DBGFIELD("WritePCmpEStrM")     1, false, false, 3221, 2, 26, 1,  0, 0}, // #227
  {DBGFIELD("WritePCmpIStrILd_ReadAfterLd") 4, false, false, 3223, 6, 28, 1,  9, 1}, // #228
  {DBGFIELD("WritePCmpIStrI")     3, false, false, 3229, 5, 26, 1,  0, 0}, // #229
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterLd") 4, false, false, 3223, 6, 28, 1,  9, 1}, // #230
  {DBGFIELD("WritePCmpIStrM")     3, false, false, 3229, 5, 26, 1,  0, 0}, // #231
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterLd") 2, false, false, 2968, 6,  9, 1,  9, 1}, // #232
  {DBGFIELD("WritePHAddXLd_ReadAfterLd") 4, false, false, 3182, 4,  9, 1,  9, 1}, // #233
  {DBGFIELD("WritePHAddX")        3, false, false, 3084, 3, 21, 1,  0, 0}, // #234
  {DBGFIELD("WritePHMINPOSLd")    2, false, false, 3052, 6, 26, 1,  0, 0}, // #235
  {DBGFIELD("WritePHMINPOS")      1, false, false, 3087, 5,  7, 1,  0, 0}, // #236
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterLd") 2, false, false, 2968, 6,  9, 1,  9, 1}, // #237
  {DBGFIELD("WriteVecIMulXLd_ReadAfterLd") 2, false, false, 3052, 6, 26, 1,  9, 1}, // #238
  {DBGFIELD("WriteVecIMulX")      1, false, false, 3087, 5,  7, 1,  0, 0}, // #239
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, 3087, 5, 20, 1,  0, 0}, // #240
  {DBGFIELD("WriteShuffleXLd")    2, false, false, 2946, 4,  5, 1,  0, 0}, // #241
  {DBGFIELD("WritePMULLDLd_ReadAfterLd") 2, false, false, 3052, 6, 26, 1,  9, 1}, // #242
  {DBGFIELD("WritePMULLD")        1, false, false, 3087, 5,  7, 1,  0, 0}, // #243
  {DBGFIELD("WriteRMW")           1, false, false, 2955, 3,  1, 1,  0, 0}, // #244
  {DBGFIELD("WritePOPCNTLd")      2, false, false, 2968, 6,  9, 1,  0, 0}, // #245
  {DBGFIELD("WritePOPCNT")        1, false, false, 2935, 5, 21, 1,  0, 0}, // #246
  {DBGFIELD("WritePSADBWXLd_ReadAfterLd") 2, false, false, 3052, 6, 26, 1,  9, 1}, // #247
  {DBGFIELD("WritePSADBWX")       1, false, false, 3087, 5,  7, 1,  0, 0}, // #248
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterLd") 2, false, false, 2946, 4,  5, 1,  9, 1}, // #249
  {DBGFIELD("WriteVarShuffleX")   1, false, false, 1604, 3,  1, 1,  0, 0}, // #250
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, 3087, 5,  1, 1,  0, 0}, // #251
  {DBGFIELD("WriteVecShiftXLd_ReadAfterLd") 3, false, false, 3234, 7, 10, 1,  9, 1}, // #252
  {DBGFIELD("WriteVecShiftX")     2, false, false, 3170, 6, 20, 1,  0, 0}, // #253
  {DBGFIELD("WriteVecTestLd_ReadAfterLd") 3, false, false, 3241, 8, 10, 1,  9, 1}, // #254
  {DBGFIELD("WriteVecTest")       2, false, false, 3058, 7, 20, 1,  0, 0}, // #255
  {DBGFIELD("WriteShiftLd_WriteRMW") 3, false, false, 3249, 5, 63, 2,  0, 0}, // #256
  {DBGFIELD("WriteShift")         1, false, false, 382, 3,  1, 1,  0, 0}, // #257
  {DBGFIELD("WriteFRcpXLd")       2, false, false, 3052, 6, 26, 1,  0, 0}, // #258
  {DBGFIELD("WriteFRcpX")         1, false, false, 3087, 5,  7, 1,  0, 0}, // #259
  {DBGFIELD("WriteFRcpLd_ReadAfterLd") 2, false, false, 3052, 6, 26, 1,  9, 1}, // #260
  {DBGFIELD("WriteFRcp")          1, false, false, 3087, 5,  7, 1,  0, 0}, // #261
  {DBGFIELD("WriteShiftLd")       2, false, false, 3014, 4,  6, 1,  0, 0}, // #262
  {DBGFIELD("WriteFRndLd")        2, false, false, 2968, 6,  9, 1,  0, 0}, // #263
  {DBGFIELD("WriteFRnd")          1, false, false, 2935, 5, 21, 1,  0, 0}, // #264
  {DBGFIELD("WriteFRndLd_ReadAfterLd") 2, false, false, 2968, 6,  9, 1,  9, 1}, // #265
  {DBGFIELD("WriteFRsqrtXLd")     2, false, false, 3052, 6, 26, 1,  0, 0}, // #266
  {DBGFIELD("WriteFRsqrtX")       1, false, false, 3087, 5,  7, 1,  0, 0}, // #267
  {DBGFIELD("WriteFRsqrtLd_ReadAfterLd") 2, false, false, 3052, 6, 26, 1,  9, 1}, // #268
  {DBGFIELD("WriteFRsqrt")        1, false, false, 3087, 5,  7, 1,  0, 0}, // #269
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 3014, 4,  6, 1, 10, 1}, // #270
  {DBGFIELD("WriteSETCCStore")    3, false, false, 3254, 5, 20, 1,  0, 0}, // #271
  {DBGFIELD("WriteSETCC")         1, false, false, 382, 3,  1, 1,  0, 0}, // #272
  {DBGFIELD("WriteSHDmrcl")       7, false, false, 3259, 5, 18, 1,  0, 0}, // #273
  {DBGFIELD("WriteSHDmri")        5, false, false, 3264, 5, 10, 1,  0, 0}, // #274
  {DBGFIELD("WriteSHDrrcl")       4, false, false, 497, 3, 22, 1,  0, 0}, // #275
  {DBGFIELD("WriteSHDrri")        2, false, false, 787, 3, 20, 1,  0, 0}, // #276
  {DBGFIELD("WriteFSqrt64XLd")    2, false, false, 3269, 7, 74, 1,  0, 0}, // #277
  {DBGFIELD("WriteFSqrt64X")      1, false, false, 3276, 6, 31, 1,  0, 0}, // #278
  {DBGFIELD("WriteFSqrtXLd")      2, false, false, 3118, 7, 30, 1,  0, 0}, // #279
  {DBGFIELD("WriteFSqrtX")        1, false, false, 3125, 6, 25, 1,  0, 0}, // #280
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterLd") 2, false, false, 3269, 7, 74, 1,  9, 1}, // #281
  {DBGFIELD("WriteFSqrt64")       1, false, false, 3276, 6, 31, 1,  0, 0}, // #282
  {DBGFIELD("WriteFSqrtLd_ReadAfterLd") 2, false, false, 3118, 7, 30, 1,  9, 1}, // #283
  {DBGFIELD("WriteFSqrt")         1, false, false, 3125, 6, 25, 1,  0, 0}, // #284
  {DBGFIELD("WriteFSqrt80")       1, false, false, 3282, 6, 72, 1,  0, 0}, // #285
  {DBGFIELD("WriteSTMXCSR")       4, false, false, 3186, 9,  7, 1,  0, 0}, // #286
  {DBGFIELD("WriteTZCNTLd")       2, false, false, 2968, 6, 10, 1,  0, 0}, // #287
  {DBGFIELD("WriteTZCNT")         1, false, false, 2935, 5, 21, 1,  0, 0}, // #288
  {DBGFIELD("WriteFMAZLd")        2, false, false, 3288, 4, 18, 1,  0, 0}, // #289
  {DBGFIELD("WriteFMALd")         2, false, false, 3288, 4, 18, 1,  0, 0}, // #290
  {DBGFIELD("WriteFAdd64YLd_ReadAfterLd") 2, false, false, 2968, 6, 18, 1,  9, 1}, // #291
  {DBGFIELD("WriteFAdd64Y")       1, false, false, 2935, 5, 21, 1,  0, 0}, // #292
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterLd") 2, false, false, 2968, 6, 18, 1,  9, 1}, // #293
  {DBGFIELD("WriteFAdd64Z")       1, false, false, 2935, 5, 21, 1,  0, 0}, // #294
  {DBGFIELD("WriteFAddYLd_ReadAfterLd") 2, false, false, 2968, 6, 18, 1,  9, 1}, // #295
  {DBGFIELD("WriteFAddY")         1, false, false, 2935, 5, 21, 1,  0, 0}, // #296
  {DBGFIELD("WriteFAddZLd_ReadAfterLd") 2, false, false, 2968, 6, 18, 1,  9, 1}, // #297
  {DBGFIELD("WriteFAddZ")         1, false, false, 2935, 5, 21, 1,  0, 0}, // #298
  {DBGFIELD("WriteShuffleYLd_ReadAfterLd") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #299
  {DBGFIELD("WriteShuffleY")      1, false, false, 2950, 5,  1, 1,  0, 0}, // #300
  {DBGFIELD("WriteShuffleZLd_ReadAfterLd") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #301
  {DBGFIELD("WriteShuffleZ")      1, false, false, 2950, 5,  1, 1,  0, 0}, // #302
  {DBGFIELD("WriteFLogicYLd_ReadAfterLd") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #303
  {DBGFIELD("WriteFLogicY")       1, false, false, 2950, 5,  1, 1,  0, 0}, // #304
  {DBGFIELD("WriteFLogicZLd_ReadAfterLd") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #305
  {DBGFIELD("WriteFLogicZ")       1, false, false, 2950, 5,  1, 1,  0, 0}, // #306
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterLd") 3, false, false, 3018, 4,  9, 1,  9, 1}, // #307
  {DBGFIELD("WriteFVarBlendY")    2, false, false, 3022, 3, 20, 1,  0, 0}, // #308
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterLd") 3, false, false, 3018, 4,  9, 1,  9, 1}, // #309
  {DBGFIELD("WriteFVarBlendZ")    2, false, false, 3022, 3, 20, 1,  0, 0}, // #310
  {DBGFIELD("WriteFBlendYLd_ReadAfterLd") 2, false, false, 3014, 4, 10, 1,  9, 1}, // #311
  {DBGFIELD("WriteFBlendY")       1, false, false, 382, 3,  1, 1,  0, 0}, // #312
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 3018, 4,  9, 1, 13, 2}, // #313
  {DBGFIELD("WriteFVarBlendLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 3018, 4, 10, 1, 13, 2}, // #314
  {DBGFIELD("WriteShuffle256Ld")  2, false, false, 2944, 6, 10, 1,  0, 0}, // #315
  {DBGFIELD("WriteShuffle256")    1, false, false, 2950, 5,  1, 1,  0, 0}, // #316
  {DBGFIELD("WriteShuffleYLd")    2, false, false, 2944, 6, 10, 1,  0, 0}, // #317
  {DBGFIELD("WriteFShuffle256")   1, false, false, 2950, 5,  1, 1,  0, 0}, // #318
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, 2944, 6, 10, 1,  0, 0}, // #319
  {DBGFIELD("WriteFCmp64YLd_ReadAfterLd") 2, false, false, 2968, 6, 18, 1,  9, 1}, // #320
  {DBGFIELD("WriteFCmp64Y")       1, false, false, 2935, 5, 21, 1,  0, 0}, // #321
  {DBGFIELD("WriteFCmpYLd_ReadAfterLd") 2, false, false, 2968, 6, 18, 1,  9, 1}, // #322
  {DBGFIELD("WriteFCmpY")         1, false, false, 2935, 5, 21, 1,  0, 0}, // #323
  {DBGFIELD("WriteFCmpZLd_ReadAfterLd") 2, false, false, 2968, 6, 18, 1,  9, 1}, // #324
  {DBGFIELD("WriteFCmpZ")         1, false, false, 2935, 5, 21, 1,  0, 0}, // #325
  {DBGFIELD("WriteVarShuffle256Ld") 2, false, false, 2944, 6, 10, 1,  0, 0}, // #326
  {DBGFIELD("WriteVarShuffle256") 1, false, false, 2950, 5,  1, 1,  0, 0}, // #327
  {DBGFIELD("WriteCvtI2PDYLd")    3, false, false, 3037, 8, 18, 1,  0, 0}, // #328
  {DBGFIELD("WriteCvtI2PDY")      2, false, false, 3045, 7, 22, 1,  0, 0}, // #329
  {DBGFIELD("WriteCvtI2PDZLd")    3, false, false, 3037, 8, 18, 1,  0, 0}, // #330
  {DBGFIELD("WriteCvtI2PDZ")      2, false, false, 3045, 7, 22, 1,  0, 0}, // #331
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, 2968, 6, 18, 1,  0, 0}, // #332
  {DBGFIELD("WriteCvtI2PSY")      1, false, false, 2935, 5, 21, 1,  0, 0}, // #333
  {DBGFIELD("WriteCvtI2PSZLd")    2, false, false, 2968, 6, 18, 1,  0, 0}, // #334
  {DBGFIELD("WriteCvtI2PSZ")      1, false, false, 2935, 5, 21, 1,  0, 0}, // #335
  {DBGFIELD("WriteCvtPD2IYLd")    3, false, false, 3037, 8, 26, 1,  0, 0}, // #336
  {DBGFIELD("WriteCvtPD2IY")      2, false, false, 3045, 7, 22, 1,  0, 0}, // #337
  {DBGFIELD("WriteCvtPD2IZLd")    3, false, false, 3037, 8, 26, 1,  0, 0}, // #338
  {DBGFIELD("WriteCvtPD2IZ")      2, false, false, 3045, 7, 22, 1,  0, 0}, // #339
  {DBGFIELD("WriteCvtPD2PSYLd")   3, false, false, 3037, 8, 26, 1,  0, 0}, // #340
  {DBGFIELD("WriteCvtPD2PSY")     2, false, false, 3045, 7, 22, 1,  0, 0}, // #341
  {DBGFIELD("WriteCvtPD2PSZLd")   3, false, false, 3037, 8, 26, 1,  0, 0}, // #342
  {DBGFIELD("WriteCvtPD2PSZ")     2, false, false, 3045, 7, 22, 1,  0, 0}, // #343
  {DBGFIELD("WriteCvtPH2PSYLd")   2, false, false, 2968, 6, 10, 1,  0, 0}, // #344
  {DBGFIELD("WriteCvtPH2PSY")     1, false, false, 2935, 5, 21, 1,  0, 0}, // #345
  {DBGFIELD("WriteCvtPH2PSLd")    2, false, false, 2968, 6, 10, 1,  0, 0}, // #346
  {DBGFIELD("WriteCvtPH2PS")      1, false, false, 2935, 5, 21, 1,  0, 0}, // #347
  {DBGFIELD("WriteCvtPH2PSZLd")   2, false, false, 2968, 6, 10, 1,  0, 0}, // #348
  {DBGFIELD("WriteCvtPH2PSZ")     1, false, false, 2935, 5, 21, 1,  0, 0}, // #349
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, 2968, 6, 18, 1,  0, 0}, // #350
  {DBGFIELD("WriteCvtPS2IY")      1, false, false, 2935, 5, 21, 1,  0, 0}, // #351
  {DBGFIELD("WriteCvtPS2IZLd")    2, false, false, 2968, 6, 18, 1,  0, 0}, // #352
  {DBGFIELD("WriteCvtPS2IZ")      1, false, false, 2935, 5, 21, 1,  0, 0}, // #353
  {DBGFIELD("WriteCvtPS2PDYLd")   2, false, false, 3052, 6,  5, 1,  0, 0}, // #354
  {DBGFIELD("WriteCvtPS2PDY")     2, false, false, 3058, 7, 20, 1,  0, 0}, // #355
  {DBGFIELD("WriteCvtPS2PDZLd")   2, false, false, 3052, 6,  5, 1,  0, 0}, // #356
  {DBGFIELD("WriteCvtPS2PDZ")     2, false, false, 3058, 7, 20, 1,  0, 0}, // #357
  {DBGFIELD("WriteCvtPS2PHYSt")   1, false, false, 3292, 7, 22, 1,  0, 0}, // #358
  {DBGFIELD("WriteCvtPS2PHY")     1, false, false, 2935, 5, 21, 1,  0, 0}, // #359
  {DBGFIELD("WriteCvtPS2PHSt")    1, false, false, 3292, 7, 22, 1,  0, 0}, // #360
  {DBGFIELD("WriteCvtPS2PH")      1, false, false, 2935, 5, 21, 1,  0, 0}, // #361
  {DBGFIELD("WriteCvtPS2PHZSt")   1, false, false, 3292, 7, 22, 1,  0, 0}, // #362
  {DBGFIELD("WriteCvtPS2PHZ")     1, false, false, 2935, 5, 21, 1,  0, 0}, // #363
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterLd") 3, false, false, 3065, 8, 18, 1,  9, 1}, // #364
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterLd") 3, false, false, 3065, 8, 18, 1,  9, 1}, // #365
  {DBGFIELD("WritePSADBWYLd_ReadAfterLd") 2, false, false, 3052, 6, 19, 1,  9, 1}, // #366
  {DBGFIELD("WritePSADBWY")       1, false, false, 3087, 5,  7, 1,  0, 0}, // #367
  {DBGFIELD("WritePSADBWZLd_ReadAfterLd") 2, false, false, 3052, 6, 19, 1,  9, 1}, // #368
  {DBGFIELD("WritePSADBWZ")       1, false, false, 3087, 5,  7, 1,  0, 0}, // #369
  {DBGFIELD("WriteFDiv64YLd_ReadAfterLd") 4, false, false, 3299, 7, 103, 1,  9, 1}, // #370
  {DBGFIELD("WriteFDiv64Y")       3, false, false, 3306, 6, 39, 1,  0, 0}, // #371
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterLd") 4, false, false, 3299, 7, 103, 1,  9, 1}, // #372
  {DBGFIELD("WriteFDiv64Z")       3, false, false, 3306, 6, 39, 1,  0, 0}, // #373
  {DBGFIELD("WriteFDivYLd_ReadAfterLd") 4, false, false, 3312, 7, 104, 1,  9, 1}, // #374
  {DBGFIELD("WriteFDivY")         3, false, false, 3319, 6, 36, 1,  0, 0}, // #375
  {DBGFIELD("WriteFDivZLd_ReadAfterLd") 4, false, false, 3312, 7, 104, 1,  9, 1}, // #376
  {DBGFIELD("WriteFDivZ")         3, false, false, 3319, 6, 36, 1,  0, 0}, // #377
  {DBGFIELD("WriteDPPSYLd_ReadAfterLd") 5, false, false, 3148, 9, 65, 1,  9, 1}, // #378
  {DBGFIELD("WriteDPPSY")         4, false, false, 3157, 8, 19, 1,  0, 0}, // #379
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterLd") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #380
  {DBGFIELD("WriteFMAYLd_ReadAfterLd_ReadAfterLd") 2, false, false, 3288, 4, 18, 1, 15, 2}, // #381
  {DBGFIELD("WriteFMAY")          1, false, false, 710, 3,  7, 1,  0, 0}, // #382
  {DBGFIELD("WriteFMAXLd_ReadAfterLd") 2, false, false, 3288, 4, 18, 1,  9, 1}, // #383
  {DBGFIELD("WriteFMAX")          1, false, false, 710, 3,  7, 1,  0, 0}, // #384
  {DBGFIELD("WriteFMAYLd_ReadAfterLd") 2, false, false, 3288, 4, 18, 1,  9, 1}, // #385
  {DBGFIELD("WriteFMAZLd_ReadAfterLd") 2, false, false, 3288, 4, 18, 1,  9, 1}, // #386
  {DBGFIELD("WriteFMAZ")          1, false, false, 710, 3,  7, 1,  0, 0}, // #387
  {DBGFIELD("WriteFMAXLd_ReadAfterLd_ReadAfterLd") 2, false, false, 3288, 4, 18, 1, 15, 2}, // #388
  {DBGFIELD("WriteFMALd_ReadAfterLd") 2, false, false, 3288, 4, 18, 1,  9, 1}, // #389
  {DBGFIELD("WriteFMA")           1, false, false, 710, 3,  7, 1,  0, 0}, // #390
  {DBGFIELD("WriteFMALd_ReadAfterLd_ReadAfterLd") 2, false, false, 3288, 4, 18, 1, 15, 2}, // #391
  {DBGFIELD("WriteFMAYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 3288, 4, 18, 1, 13, 2}, // #392
  {DBGFIELD("WriteFMAXLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 3288, 4, 18, 1, 13, 2}, // #393
  {DBGFIELD("WriteFMALd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 3288, 4, 18, 1, 13, 2}, // #394
  {DBGFIELD("WriteFRndYLd_ReadAfterLd") 2, false, false, 2968, 6, 18, 1,  9, 1}, // #395
  {DBGFIELD("WriteFRndY")         1, false, false, 2935, 5, 21, 1,  0, 0}, // #396
  {DBGFIELD("WriteFRndZLd_ReadAfterLd") 2, false, false, 2968, 6, 18, 1,  9, 1}, // #397
  {DBGFIELD("WriteFRndZ")         1, false, false, 2935, 5, 21, 1,  0, 0}, // #398
  {DBGFIELD("WriteVecIMulYLd_ReadAfterLd") 2, false, false, 3052, 6, 19, 1,  9, 1}, // #399
  {DBGFIELD("WriteVecIMulY")      1, false, false, 3087, 5,  7, 1,  0, 0}, // #400
  {DBGFIELD("WriteVecIMulZLd_ReadAfterLd") 2, false, false, 3052, 6, 19, 1,  9, 1}, // #401
  {DBGFIELD("WriteVecIMulZ")      1, false, false, 3087, 5,  7, 1,  0, 0}, // #402
  {DBGFIELD("WriteVecALUYLd_ReadAfterLd") 2, false, false, 2946, 4, 10, 1,  9, 1}, // #403
  {DBGFIELD("WriteVecALUY")       1, false, false, 1604, 3,  1, 1,  0, 0}, // #404
  {DBGFIELD("WriteVecALUZLd_ReadAfterLd") 2, false, false, 2946, 4, 10, 1,  9, 1}, // #405
  {DBGFIELD("WriteVecALUZ")       1, false, false, 1604, 3,  1, 1,  0, 0}, // #406
  {DBGFIELD("WriteFHAddYLd_ReadAfterLd") 4, false, false, 3178, 8, 19, 1,  9, 1}, // #407
  {DBGFIELD("WriteFHAddY")        3, false, false, 3080, 7,  7, 1,  0, 0}, // #408
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterLd") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #409
  {DBGFIELD("WriteShuffle256Ld_ReadAfterLd") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #410
  {DBGFIELD("WriteVecLoadY")      1, false, false, 2958, 2,  5, 1,  0, 0}, // #411
  {DBGFIELD("WriteFMaskedStoreY") 3, false, false, 3325, 5,  7, 1,  0, 0}, // #412
  {DBGFIELD("WriteFMaskedLoadY")  3, false, false, 3018, 4,  9, 1,  0, 0}, // #413
  {DBGFIELD("WriteFMaskedStore")  3, false, false, 3325, 5,  7, 1,  0, 0}, // #414
  {DBGFIELD("WriteFMaskedLoad")   3, false, false, 3018, 4, 10, 1,  0, 0}, // #415
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterLd") 2, false, false, 2968, 6, 18, 1,  9, 1}, // #416
  {DBGFIELD("WriteFCmp64Z")       1, false, false, 2935, 5, 21, 1,  0, 0}, // #417
  {DBGFIELD("WriteFMoveY")        1, false, false, 2950, 5,  1, 1,  0, 0}, // #418
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, 2944, 6, 10, 1,  0, 0}, // #419
  {DBGFIELD("WriteFShuffleY")     1, false, false, 2950, 5,  1, 1,  0, 0}, // #420
  {DBGFIELD("WriteFShuffleZLd")   2, false, false, 2944, 6, 10, 1,  0, 0}, // #421
  {DBGFIELD("WriteFShuffleZ")     1, false, false, 2950, 5,  1, 1,  0, 0}, // #422
  {DBGFIELD("WriteVecStoreY")     1, false, false, 2955, 3,  1, 1,  0, 0}, // #423
  {DBGFIELD("WriteVecMoveY")      1, false, false, 382, 3,  1, 1,  0, 0}, // #424
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, 2958, 2,  5, 1,  0, 0}, // #425
  {DBGFIELD("WriteVecStoreNTY")   1, false, false, 2955, 3,  1, 1,  0, 0}, // #426
  {DBGFIELD("WriteFStoreNTY")     1, false, false, 2955, 3,  1, 1,  0, 0}, // #427
  {DBGFIELD("WriteMPSADYLd_ReadAfterLd") 4, false, false, 3200, 7, 25, 1,  9, 1}, // #428
  {DBGFIELD("WriteMPSADY")        3, false, false, 3207, 6,  5, 1,  0, 0}, // #429
  {DBGFIELD("WriteFMul64YLd_ReadAfterLd") 2, false, false, 3052, 6, 19, 1,  9, 1}, // #430
  {DBGFIELD("WriteFMul64Y")       1, false, false, 3087, 5,  7, 1,  0, 0}, // #431
  {DBGFIELD("WriteFMul64ZLd_ReadAfterLd") 2, false, false, 3052, 6, 19, 1,  9, 1}, // #432
  {DBGFIELD("WriteFMul64Z")       1, false, false, 3087, 5,  7, 1,  0, 0}, // #433
  {DBGFIELD("WriteFMulYLd_ReadAfterLd") 2, false, false, 3052, 6, 19, 1,  9, 1}, // #434
  {DBGFIELD("WriteFMulY")         1, false, false, 3087, 5,  7, 1,  0, 0}, // #435
  {DBGFIELD("WriteFMulZLd_ReadAfterLd") 2, false, false, 3052, 6, 19, 1,  9, 1}, // #436
  {DBGFIELD("WriteFMulZ")         1, false, false, 3087, 5,  7, 1,  0, 0}, // #437
  {DBGFIELD("WriteVecALUYLd")     2, false, false, 2946, 4, 10, 1,  0, 0}, // #438
  {DBGFIELD("WriteVecALUZLd")     2, false, false, 2946, 4, 10, 1,  0, 0}, // #439
  {DBGFIELD("WriteVecLogicYLd_ReadAfterLd") 2, false, false, 2947, 3, 10, 1,  9, 1}, // #440
  {DBGFIELD("WriteVecLogicY")     1, false, false, 226, 2,  1, 1,  0, 0}, // #441
  {DBGFIELD("WriteVecLogicZLd_ReadAfterLd") 2, false, false, 2947, 3, 10, 1,  9, 1}, // #442
  {DBGFIELD("WriteVecLogicZ")     1, false, false, 226, 2,  1, 1,  0, 0}, // #443
  {DBGFIELD("WriteBlendYLd_ReadAfterLd") 2, false, false, 2946, 4, 10, 1,  9, 1}, // #444
  {DBGFIELD("WriteBlendY")        1, false, false, 1604, 3,  1, 1,  0, 0}, // #445
  {DBGFIELD("WriteVarBlendYLd_ReadAfterLd") 3, false, false, 2987, 4,  9, 1,  9, 1}, // #446
  {DBGFIELD("WriteVarBlendY")     2, false, false, 1844, 3, 20, 1,  0, 0}, // #447
  {DBGFIELD("WriteVarBlendZLd_ReadAfterLd") 3, false, false, 2987, 4,  9, 1,  9, 1}, // #448
  {DBGFIELD("WriteVarBlendZ")     2, false, false, 1844, 3, 20, 1,  0, 0}, // #449
  {DBGFIELD("WriteVarBlendYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 2987, 4,  9, 1, 13, 2}, // #450
  {DBGFIELD("WriteVarBlendLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 2987, 4, 10, 1, 13, 2}, // #451
  {DBGFIELD("WriteShuffleYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 2944, 6, 10, 1, 13, 2}, // #452
  {DBGFIELD("WriteShuffleYLd_ReadAfterLd_ReadAfterLd") 2, false, false, 2944, 6, 10, 1, 15, 2}, // #453
  {DBGFIELD("WriteShuffleXLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 2946, 4,  5, 1, 13, 2}, // #454
  {DBGFIELD("WriteShuffleXLd_ReadAfterLd_ReadAfterLd") 2, false, false, 2946, 4,  5, 1, 15, 2}, // #455
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterLd") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #456
  {DBGFIELD("WriteFVarShuffle256") 1, false, false, 2950, 5,  1, 1,  0, 0}, // #457
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 2944, 6, 10, 1, 13, 2}, // #458
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterLd_ReadAfterLd") 2, false, false, 2944, 6, 10, 1, 15, 2}, // #459
  {DBGFIELD("WriteFVarShuffleY")  1, false, false, 2950, 5,  1, 1,  0, 0}, // #460
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 2944, 6,  5, 1, 13, 2}, // #461
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterLd_ReadAfterLd") 2, false, false, 2944, 6,  5, 1, 15, 2}, // #462
  {DBGFIELD("WriteFVarShuffle")   1, false, false, 2950, 5,  1, 1,  0, 0}, // #463
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterLd") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #464
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterLd") 2, false, false, 2944, 6,  5, 1,  9, 1}, // #465
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterLd") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #466
  {DBGFIELD("WriteFVarShuffleZ")  1, false, false, 2950, 5,  1, 1,  0, 0}, // #467
  {DBGFIELD("WritePHAddYLd_ReadAfterLd") 4, false, false, 3182, 4, 18, 1,  9, 1}, // #468
  {DBGFIELD("WritePHAddY")        3, false, false, 3084, 3, 21, 1,  0, 0}, // #469
  {DBGFIELD("WriteVecIMulXLd")    2, false, false, 3052, 6, 26, 1,  0, 0}, // #470
  {DBGFIELD("WriteVecIMulYLd")    2, false, false, 3052, 6, 19, 1,  0, 0}, // #471
  {DBGFIELD("WriteVecIMulZLd")    2, false, false, 3052, 6, 19, 1,  0, 0}, // #472
  {DBGFIELD("WriteVecMaskedStoreY") 3, false, false, 3325, 5,  7, 1,  0, 0}, // #473
  {DBGFIELD("WriteVecMaskedLoadY") 3, false, false, 3018, 4,  9, 1,  0, 0}, // #474
  {DBGFIELD("WriteVecMaskedStore") 3, false, false, 3325, 5,  7, 1,  0, 0}, // #475
  {DBGFIELD("WriteVecMaskedLoad") 3, false, false, 3018, 4, 10, 1,  0, 0}, // #476
  {DBGFIELD("WriteVecMOVMSKY")    1, false, false, 3087, 5, 20, 1,  0, 0}, // #477
  {DBGFIELD("WritePMULLDYLd_ReadAfterLd") 2, false, false, 3052, 6, 19, 1,  9, 1}, // #478
  {DBGFIELD("WritePMULLDY")       1, false, false, 3087, 5,  7, 1,  0, 0}, // #479
  {DBGFIELD("WritePMULLDZLd_ReadAfterLd") 2, false, false, 3052, 6, 19, 1,  9, 1}, // #480
  {DBGFIELD("WritePMULLDZ")       1, false, false, 3087, 5,  7, 1,  0, 0}, // #481
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 2946, 4,  5, 1, 13, 2}, // #482
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterLd_ReadAfterLd") 2, false, false, 2946, 4,  5, 1, 15, 2}, // #483
  {DBGFIELD("WriteVecShiftImmXLd") 2, false, false, 3052, 6,  5, 1,  0, 0}, // #484
  {DBGFIELD("WriteVecShiftImmYLd") 2, false, false, 3052, 6, 10, 1,  0, 0}, // #485
  {DBGFIELD("WriteVecShiftImmY")  1, false, false, 3087, 5,  1, 1,  0, 0}, // #486
  {DBGFIELD("WriteVecShiftImmZLd") 2, false, false, 3052, 6, 10, 1,  0, 0}, // #487
  {DBGFIELD("WriteVecShiftImmZ")  1, false, false, 3087, 5,  1, 1,  0, 0}, // #488
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterLd") 2, false, false, 3052, 6,  5, 1,  9, 1}, // #489
  {DBGFIELD("WriteVarVecShift")   1, false, false, 3087, 5,  1, 1,  0, 0}, // #490
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterLd") 2, false, false, 3052, 6, 10, 1,  9, 1}, // #491
  {DBGFIELD("WriteVarVecShiftY")  1, false, false, 3087, 5,  1, 1,  0, 0}, // #492
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterLd") 2, false, false, 3052, 6, 10, 1,  9, 1}, // #493
  {DBGFIELD("WriteVarVecShiftZ")  1, false, false, 3087, 5,  1, 1,  0, 0}, // #494
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterLd") 2, false, false, 3052, 6,  5, 1,  9, 1}, // #495
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterLd") 2, false, false, 2946, 4, 10, 1,  9, 1}, // #496
  {DBGFIELD("WriteVarShuffleY")   1, false, false, 1604, 3,  1, 1,  0, 0}, // #497
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterLd") 2, false, false, 2946, 4, 10, 1,  9, 1}, // #498
  {DBGFIELD("WriteVarShuffleZ")   1, false, false, 1604, 3,  1, 1,  0, 0}, // #499
  {DBGFIELD("WriteShuffleZLd")    2, false, false, 2944, 6, 10, 1,  0, 0}, // #500
  {DBGFIELD("WriteVecShiftYLd_ReadAfterLd") 3, false, false, 3234, 7, 26, 1,  9, 1}, // #501
  {DBGFIELD("WriteVecShiftY")     2, false, false, 3170, 6, 22, 1,  0, 0}, // #502
  {DBGFIELD("WriteVecShiftZLd_ReadAfterLd") 3, false, false, 3234, 7, 26, 1,  9, 1}, // #503
  {DBGFIELD("WriteVecShiftZ")     2, false, false, 3170, 6, 22, 1,  0, 0}, // #504
  {DBGFIELD("WriteVecTestYLd_ReadAfterLd") 3, false, false, 3241, 8,  9, 1,  9, 1}, // #505
  {DBGFIELD("WriteVecTestY")      2, false, false, 3058, 7, 20, 1,  0, 0}, // #506
  {DBGFIELD("WriteFRcpXLd_ReadAfterLd") 2, false, false, 3052, 6, 26, 1,  9, 1}, // #507
  {DBGFIELD("WriteFRcpYLd_ReadAfterLd") 4, false, false, 3300, 6, 25, 1,  9, 1}, // #508
  {DBGFIELD("WriteFRcpY")         3, false, false, 3307, 5,  5, 1,  0, 0}, // #509
  {DBGFIELD("WriteFRcpZLd_ReadAfterLd") 4, false, false, 3300, 6, 25, 1,  9, 1}, // #510
  {DBGFIELD("WriteFRcpZ")         3, false, false, 3307, 5,  5, 1,  0, 0}, // #511
  {DBGFIELD("WriteFRcpYLd")       4, false, false, 3300, 6, 25, 1,  0, 0}, // #512
  {DBGFIELD("WriteFRndYLd")       2, false, false, 2968, 6, 18, 1,  0, 0}, // #513
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterLd") 2, false, false, 3052, 6, 26, 1,  9, 1}, // #514
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterLd") 4, false, false, 3300, 6, 25, 1,  9, 1}, // #515
  {DBGFIELD("WriteFRsqrtY")       3, false, false, 3307, 5,  5, 1,  0, 0}, // #516
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterLd") 4, false, false, 3300, 6, 25, 1,  9, 1}, // #517
  {DBGFIELD("WriteFRsqrtZ")       3, false, false, 3307, 5,  5, 1,  0, 0}, // #518
  {DBGFIELD("WriteFRsqrtYLd")     4, false, false, 3300, 6, 25, 1,  0, 0}, // #519
  {DBGFIELD("WriteFShuffleYLd_ReadAfterLd") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #520
  {DBGFIELD("WriteFShuffleZLd_ReadAfterLd") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #521
  {DBGFIELD("WriteFSqrt64YLd")    4, false, false, 3299, 7, 103, 1,  0, 0}, // #522
  {DBGFIELD("WriteFSqrt64Y")      3, false, false, 3306, 6, 39, 1,  0, 0}, // #523
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterLd") 2, false, false, 3269, 7, 74, 1,  9, 1}, // #524
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterLd") 4, false, false, 3299, 7, 103, 1,  9, 1}, // #525
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterLd") 4, false, false, 3299, 7, 103, 1,  9, 1}, // #526
  {DBGFIELD("WriteFSqrt64Z")      3, false, false, 3306, 6, 39, 1,  0, 0}, // #527
  {DBGFIELD("WriteFSqrtYLd")      4, false, false, 3312, 7, 104, 1,  0, 0}, // #528
  {DBGFIELD("WriteFSqrtY")        3, false, false, 3319, 6, 36, 1,  0, 0}, // #529
  {DBGFIELD("WriteFSqrtXLd_ReadAfterLd") 2, false, false, 3118, 7, 30, 1,  9, 1}, // #530
  {DBGFIELD("WriteFSqrtYLd_ReadAfterLd") 4, false, false, 3312, 7, 104, 1,  9, 1}, // #531
  {DBGFIELD("WriteFSqrtZLd_ReadAfterLd") 4, false, false, 3312, 7, 104, 1,  9, 1}, // #532
  {DBGFIELD("WriteFSqrtZ")        3, false, false, 3319, 6, 36, 1,  0, 0}, // #533
  {DBGFIELD("WriteFTestYLd_ReadAfterLd") 2, false, false, 3052, 6, 10, 1,  9, 1}, // #534
  {DBGFIELD("WriteFTestY")        1, false, false, 3087, 5,  1, 1,  0, 0}, // #535
  {DBGFIELD("WriteFTestLd_ReadAfterLd") 2, false, false, 3052, 6,  5, 1,  9, 1}, // #536
  {DBGFIELD("WriteFTest")         1, false, false, 3087, 5,  1, 1,  0, 0}, // #537
  {DBGFIELD("MUL16m_IMUL16m")     5, false, false, 3330, 7,  9, 1,  0, 0}, // #538
  {DBGFIELD("MUL32r_IMUL32r")     3, false, false, 3337, 6, 22, 1,  0, 0}, // #539
  {DBGFIELD("IMUL64rri8_IMUL64rri32") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #540
  {DBGFIELD("IMUL64rmi8_IMUL64rmi32") 2, false, false, 2968, 6, 10, 1,  0, 0}, // #541
  {DBGFIELD("COPY")               0, false, false,  0, 0,  0, 0,  0, 0}, // #542
  {DBGFIELD("FXAM")               1, false, false, 226, 2,  4, 1,  0, 0}, // #543
  {DBGFIELD("LD_Frr")             1, false, false, 2950, 5,  1, 1,  0, 0}, // #544
  {DBGFIELD("MOVSX64rr32")        1, false, false, 226, 2,  1, 1,  0, 0}, // #545
  {DBGFIELD("RCL16m1_RCL16mCL_RCL16mi_RCL32m1_RCL32mCL_RCL32mi_RCL64m1_RCL64mCL_RCL64mi_RCL8m1_RCL8mCL_RCL8mi_RCR16m1_RCR16mCL_RCR16mi_RCR32m1_RCR32mCL_RCR32mi_RCR64m1_RCR64mCL_RCR64mi_RCR8m1_RCR8mCL_RCR8mi_ROL16m1_ROL16mCL_ROL16mi_ROL32m1_ROL32mCL_ROL32mi_ROL64m1_ROL64mCL_ROL64mi_ROL8m1_ROL8mCL_ROL8mi_ROR16m1_ROR16mCL_ROR16mi_ROR32m1_ROR32mCL_ROR32mi_ROR64m1_ROR64mCL_ROR64mi_ROR8m1_ROR8mCL_ROR8mi_SAR16m1_SAR16mCL_SAR16mi_SAR32m1_SAR32mCL_SAR32mi_SAR64m1_SAR64mCL_SAR64mi_SAR8m1_SAR8mCL_SAR8mi_SHL16m1_SHL16mCL_SHL16mi_SHL32m1_SHL32mCL_SHL32mi_SHL64m1_SHL64mCL_SHL64mi_SHL8m1_SHL8mCL_SHL8mi_SHR16m1_SHR16mCL_SHR16mi_SHR32m1_SHR32mCL_SHR32mi_SHR64m1_SHR64mCL_SHR64mi_SHR8m1_SHR8mCL_SHR8mi") 3, false, false, 3249, 5, 63, 2,  0, 0}, // #546
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, 226, 2,  1, 1,  0, 0}, // #547
  {DBGFIELD("IMUL32rm")           2, false, false, 2968, 6, 10, 1,  9, 1}, // #548
  {DBGFIELD("IMUL32rmi_IMUL32rmi8") 2, false, false, 2968, 6, 10, 1,  0, 0}, // #549
  {DBGFIELD("IMUL32rr_IMUL32rri_IMUL32rri8") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #550
  {DBGFIELD("FCOMPP")             1, false, false, 226, 2,  4, 1,  0, 0}, // #551
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #552
  {DBGFIELD("BT16ri8_BT16rr_BT32ri8_BT32rr_BT64ri8_BT64rr_BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 1, false, false, 382, 3,  1, 1,  0, 0}, // #553
  {DBGFIELD("MMX_CVTPI2PSirr")    1, false, false, 2935, 5, 21, 1,  0, 0}, // #554
  {DBGFIELD("MMX_CVTPI2PSirm")    2, false, false, 2968, 6,  9, 1,  0, 0}, // #555
  {DBGFIELD("MMX_CVTPS2PIirr_MMX_CVTTPS2PIirr") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #556
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, 2958, 2,  6, 1,  0, 0}, // #557
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, 2955, 3,  1, 1,  0, 0}, // #558
  {DBGFIELD("XCH_F")              1, false, false, 226, 2,  1, 1,  0, 0}, // #559
  {DBGFIELD("RETIL_RETIQ_RETIW_IRET_IRET16_IRET32_IRET64") 2, false, false, 2944, 6,  6, 1,  0, 0}, // #560
  {DBGFIELD("MMX_CVTPS2PIirm_MMX_CVTTPS2PIirm") 2, false, false, 2968, 6,  9, 1,  0, 0}, // #561
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 2, false, false, 2968, 6, 18, 1,  0, 0}, // #562
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 1, false, false, 226, 2,  4, 1,  0, 0}, // #563
  {DBGFIELD("LFENCE")             1, false, false, 2955, 3,  1, 1,  0, 0}, // #564
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, 2950, 5,  1, 1,  0, 0}, // #565
  {DBGFIELD("PSLLDQri_PSRLDQri")  1, false, false, 1604, 3,  1, 1,  0, 0}, // #566
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr_MMX_PUNPCKHBWirr_MMX_PUNPCKHDQirr_MMX_PUNPCKHWDirr") 1, false, false, 2950, 5,  1, 1,  0, 0}, // #567
  {DBGFIELD("LEAVE_LEAVE64")      3, false, false, 2965, 3,  5, 1,  0, 0}, // #568
  {DBGFIELD("POP16r")             1, false, false, 2958, 2,  6, 1,  0, 0}, // #569
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 2, false, false, 2955, 3,  7, 1,  0, 0}, // #570
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 3, false, false, 2965, 3,  5, 1,  0, 0}, // #571
  {DBGFIELD("BTC16mi8_BTC32mi8_BTC64mi8_BTR16mi8_BTR32mi8_BTR64mi8_BTS16mi8_BTS32mi8_BTS64mi8") 4, false, false, 3249, 5,  5, 1,  0, 0}, // #572
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, 226, 2,  4, 1,  0, 0}, // #573
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr_XCHG16ar_XCHG16rr_XCHG32ar_XCHG32rr_XCHG64ar_XCHG64rr_XCHG8rr_MOVSX16rr8_MOVZX16rr8") 1, false, false, 226, 2,  1, 1,  0, 0}, // #574
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 3, false, false, 3343, 3,  6, 1,  0, 0}, // #575
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, 2950, 5,  1, 1,  0, 0}, // #576
  {DBGFIELD("MMX_PADDQirr_MMX_PSUBQirr") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #577
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 1, false, false, 2955, 3,  1, 1,  0, 0}, // #578
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  1, false, false, 2955, 3,  1, 1,  0, 0}, // #579
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, 1604, 3,  1, 1,  0, 0}, // #580
  {DBGFIELD("CLD")                1, false, false, 226, 2,  1, 1,  0, 0}, // #581
  {DBGFIELD("LDDQUrm")            1, false, false, 2958, 2,  6, 1,  0, 0}, // #582
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 5, false, false, 3346, 4, 10, 1,  0, 0}, // #583
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 1, false, false, 2958, 2,  6, 1,  0, 0}, // #584
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 3, false, false, 2940, 4, 63, 2,  0, 0}, // #585
  {DBGFIELD("PHADDDrr_PHSUBDrr")  3, false, false, 3084, 3, 21, 1,  0, 0}, // #586
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, 2958, 2,  7, 1,  0, 0}, // #587
  {DBGFIELD("MMX_PADDQirm_MMX_PSUBQirm") 2, false, false, 2968, 6, 10, 1,  9, 1}, // #588
  {DBGFIELD("MOVDQUrm")           1, false, false, 2958, 2,  6, 1,  0, 0}, // #589
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, 2958, 2,  6, 1,  0, 0}, // #590
  {DBGFIELD("PADDQrm_PSUBQrm")    2, false, false, 2946, 4,  5, 1,  9, 1}, // #591
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, 226, 2,  1, 1,  0, 0}, // #592
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   2, false, false, 2980, 5, 20, 1,  0, 0}, // #593
  {DBGFIELD("LD_F80m")            3, false, false, 3350, 7,  9, 1,  0, 0}, // #594
  {DBGFIELD("PHADDDrm_PHSUBDrm")  4, false, false, 3182, 4,  9, 1,  9, 1}, // #595
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 2, false, false, 3170, 6, 21, 1,  0, 0}, // #596
  {DBGFIELD("FLDCW16m")           5, false, false, 3357, 7, 10, 1,  0, 0}, // #597
  {DBGFIELD("ST_FP80m")           3, false, false, 3343, 3,  6, 1,  0, 0}, // #598
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 3, false, false, 3084, 3, 21, 1,  0, 0}, // #599
  {DBGFIELD("CMPXCHG8rm")         4, false, false, 3026, 3, 10, 1,  0, 0}, // #600
  {DBGFIELD("INTO")               1, false, false, 226, 2,  4, 1,  0, 0}, // #601
  {DBGFIELD("XLAT")               1, false, false, 2958, 2,  7, 1,  0, 0}, // #602
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 4, false, false, 497, 3, 22, 1,  0, 0}, // #603
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 2, false, false, 787, 3, 20, 1,  0, 0}, // #604
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 7, false, false, 3259, 5, 18, 1,  0, 0}, // #605
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 5, false, false, 3264, 5, 10, 1,  0, 0}, // #606
  {DBGFIELD("IMUL16rr_IMUL16rri_IMUL16rri8") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #607
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 4, false, false, 3364, 7,  9, 1,  0, 0}, // #608
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 4, false, false, 3182, 4, 10, 1,  9, 1}, // #609
  {DBGFIELD("AAD8i8")             1, false, false, 226, 2,  4, 1,  0, 0}, // #610
  {DBGFIELD("LOOPE")              1, false, false, 2950, 5,  1, 1,  0, 0}, // #611
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, 2955, 3,  1, 1,  0, 0}, // #612
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 4, false, false, 497, 3, 22, 1,  0, 0}, // #613
  {DBGFIELD("FNSTCW16m")          4, false, false, 3371, 7,  5, 1,  0, 0}, // #614
  {DBGFIELD("BT16mr_BT32mr_BT64mr") 6, false, false, 3378, 7,  9, 1,  0, 0}, // #615
  {DBGFIELD("POPA16_POPA32")      1, false, false, 2958, 2,  7, 1,  0, 0}, // #616
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, 2955, 3,  1, 1,  0, 0}, // #617
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 7, false, false, 3259, 5, 18, 1,  0, 0}, // #618
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 5, false, false, 3264, 5, 10, 1,  0, 0}, // #619
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 2, false, false, 787, 3, 20, 1,  0, 0}, // #620
  {DBGFIELD("CMPXCHG8rr")         4, false, false, 3385, 3,  7, 1,  0, 0}, // #621
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80_COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #622
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_CVTTSS2SI64rr_Int") 2, false, false, 3073, 7,  7, 1,  0, 0}, // #623
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int") 3, false, false, 3065, 8, 10, 1,  0, 0}, // #624
  {DBGFIELD("CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 3, false, false, 3065, 8,  9, 1,  0, 0}, // #625
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, 226, 2,  4, 1,  0, 0}, // #626
  {DBGFIELD("BTC16mr_BTC32mr_BTC64mr_BTR16mr_BTR32mr_BTR64mr_BTS16mr_BTS32mr_BTS64mr") 6, false, false, 3378, 7,  9, 1,  0, 0}, // #627
  {DBGFIELD("AAA_AAS")            1, false, false, 226, 2,  4, 1,  0, 0}, // #628
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 4, false, false, 3026, 3, 10, 1,  0, 0}, // #629
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 4, false, false, 3385, 3,  7, 1,  0, 0}, // #630
  {DBGFIELD("LOOPNE")             1, false, false, 2950, 5,  1, 1,  0, 0}, // #631
  {DBGFIELD("PAUSE")              4, false, false, 3388, 5, 22, 1,  0, 0}, // #632
  {DBGFIELD("CMPXCHG8B")          3, false, false, 2940, 4, 63, 2,  0, 0}, // #633
  {DBGFIELD("DAA")                1, false, false, 226, 2,  4, 1,  0, 0}, // #634
  {DBGFIELD("LOOP")               1, false, false, 2950, 5,  1, 1,  0, 0}, // #635
  {DBGFIELD("DAS")                1, false, false, 226, 2,  4, 1,  0, 0}, // #636
  {DBGFIELD("AAM8i8")             1, false, false, 226, 2,  4, 1,  0, 0}, // #637
  {DBGFIELD("STD")                1, false, false, 226, 2,  1, 1,  0, 0}, // #638
  {DBGFIELD("CMPXCHG16B")         3, false, false, 2940, 4, 63, 2,  0, 0}, // #639
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, 226, 2,  4, 1,  0, 0}, // #640
  {DBGFIELD("FNCLEX_FXTRACT")     1, false, false, 226, 2,  4, 1,  0, 0}, // #641
  {DBGFIELD("POPF32_POPF64")      1, false, false, 2958, 2,  7, 1,  0, 0}, // #642
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, 226, 2,  4, 1,  0, 0}, // #643
  {DBGFIELD("RDTSC_RDTSCP")       1, false, false, 226, 2,  4, 1,  0, 0}, // #644
  {DBGFIELD("ENTER")              1, false, false, 226, 2,  4, 1,  0, 0}, // #645
  {DBGFIELD("POPF16")             1, false, false, 2958, 2,  7, 1,  0, 0}, // #646
  {DBGFIELD("MONITORrrr")         1, false, false, 226, 2,  4, 1,  0, 0}, // #647
  {DBGFIELD("FRNDINT")            1, false, false, 226, 2,  4, 1,  0, 0}, // #648
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false, 226, 2,  4, 1,  0, 0}, // #649
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, 226, 2,  4, 1,  0, 0}, // #650
  {DBGFIELD("FPREM")              1, false, false, 226, 2,  4, 1,  0, 0}, // #651
  {DBGFIELD("INSB_INSL_INSW")     1, false, false, 226, 2,  4, 1,  0, 0}, // #652
  {DBGFIELD("FNINIT")             4, false, false, 3388, 5,  7, 1,  0, 0}, // #653
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 1, false, false, 226, 2,  4, 1,  0, 0}, // #654
  {DBGFIELD("FPREM1")             1, false, false, 226, 2,  4, 1,  0, 0}, // #655
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, 226, 2,  4, 1,  0, 0}, // #656
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 1, false, false, 226, 2,  4, 1,  0, 0}, // #657
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, 226, 2,  4, 1,  0, 0}, // #658
  {DBGFIELD("FSCALE")             1, false, false, 226, 2,  4, 1,  0, 0}, // #659
  {DBGFIELD("RDMSR")              1, false, false, 226, 2,  4, 1,  0, 0}, // #660
  {DBGFIELD("RET_RETL_RETQ_RETW_LRETIL_LRETIQ_LRETIW_LRETL_LRETQ_LRETW") 2, false, false, 2944, 6,  6, 1,  0, 0}, // #661
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 1, false, false, 226, 2,  4, 1,  0, 0}, // #662
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 1, false, false, 226, 2,  4, 1,  0, 0}, // #663
  {DBGFIELD("F2XM1")              1, false, false, 226, 2,  4, 1,  0, 0}, // #664
  {DBGFIELD("CPUID")              1, false, false, 226, 2,  4, 1,  0, 0}, // #665
  {DBGFIELD("INT")                1, false, false, 226, 2,  4, 1,  0, 0}, // #666
  {DBGFIELD("INT3")               1, false, false, 226, 2,  4, 1,  0, 0}, // #667
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, 226, 2,  4, 1,  0, 0}, // #668
  {DBGFIELD("FXRSTOR_FXRSTOR64")  5, false, false, 3393, 8,  7, 1,  0, 0}, // #669
  {DBGFIELD("FYL2X")              1, false, false, 226, 2,  4, 1,  0, 0}, // #670
  {DBGFIELD("FYL2XP1")            1, false, false, 226, 2,  4, 1,  0, 0}, // #671
  {DBGFIELD("FPTAN")              1, false, false, 226, 2,  4, 1,  0, 0}, // #672
  {DBGFIELD("FSINCOS")            1, false, false, 226, 2,  4, 1,  0, 0}, // #673
  {DBGFIELD("COS_F_COS_Fp32_COS_Fp64_COS_Fp80_SIN_F_SIN_Fp32_SIN_Fp64_SIN_Fp80") 1, false, false, 226, 2,  4, 1,  0, 0}, // #674
  {DBGFIELD("FPATAN")             1, false, false, 226, 2,  4, 1,  0, 0}, // #675
  {DBGFIELD("WRMSR")              1, false, false, 226, 2,  4, 1,  0, 0}, // #676
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, 2935, 5,  1, 1,  0, 0}, // #677
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, 2935, 5,  1, 1,  0, 0}, // #678
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 1, false, false, 2950, 5,  1, 1,  0, 0}, // #679
  {DBGFIELD("FNOP")               1, false, false, 2950, 5,  1, 1,  0, 0}, // #680
  {DBGFIELD("RETQ")               1, false, false, 2950, 5,  1, 1,  0, 0}, // #681
  {DBGFIELD("CDQ_CQO")            1, false, false, 382, 3,  1, 1,  0, 0}, // #682
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, 1604, 3,  1, 1,  0, 0}, // #683
  {DBGFIELD("MMX_PADDQirr")       1, false, false, 1604, 3,  1, 1,  0, 0}, // #684
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, 1604, 3,  1, 1,  0, 0}, // #685
  {DBGFIELD("ROL16r1_ROL32r1_ROL64r1_ROL8r1_ROL16ri_ROL32ri_ROL64ri_ROL8ri_ROR16r1_ROR32r1_ROR64r1_ROR8r1_ROR16ri_ROR32ri_ROR64ri_ROR8ri") 2, false, false, 3022, 3, 20, 1,  0, 0}, // #686
  {DBGFIELD("SETAr_SETBEr")       2, false, false, 3022, 3, 20, 1,  0, 0}, // #687
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 2, false, false, 170, 2, 20, 1,  0, 0}, // #688
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 2, false, false, 3073, 7, 20, 1,  0, 0}, // #689
  {DBGFIELD("VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 2, false, false, 3073, 7, 20, 1,  0, 0}, // #690
  {DBGFIELD("CWD")                2, false, false, 3401, 5, 20, 1,  0, 0}, // #691
  {DBGFIELD("FNSTSW16r")          2, false, false, 3401, 5, 20, 1,  0, 0}, // #692
  {DBGFIELD("MMX_MOVDQ2Qrr")      2, false, false, 2980, 5, 20, 1,  0, 0}, // #693
  {DBGFIELD("PUSHFS64")           1, false, false, 2935, 5, 21, 1,  0, 0}, // #694
  {DBGFIELD("IMUL16rri_IMUL16rri8") 2, false, false, 3406, 5, 22, 1,  0, 0}, // #695
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 2, false, false, 3058, 7, 21, 1,  0, 0}, // #696
  {DBGFIELD("ROL16rCL_ROL32rCL_ROL64rCL_ROL8rCL_ROR16rCL_ROR32rCL_ROR64rCL_ROR8rCL_SAR16rCL_SAR32rCL_SAR64rCL_SAR8rCL_SHL16rCL_SHL32rCL_SHL64rCL_SHL8rCL_SHR16rCL_SHR32rCL_SHR64rCL_SHR8rCL") 3, false, false, 3231, 3, 21, 1,  0, 0}, // #697
  {DBGFIELD("XADD8rr_XADD16rr_XADD32rr_XADD64rr_XCHG8rr_XCHG16rr_XCHG32rr_XCHG64rr_XCHG16ar_XCHG32ar_XCHG64ar") 3, false, false, 549, 2, 20, 1,  0, 0}, // #698
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 3, false, false, 3140, 8, 21, 1,  0, 0}, // #699
  {DBGFIELD("IMUL64r_MUL64r")     2, false, false, 3073, 7, 22, 1,  0, 0}, // #700
  {DBGFIELD("IMUL16r_MUL16r")     4, false, false, 3411, 6, 22, 1,  0, 0}, // #701
  {DBGFIELD("MOV64sr")            2, false, false, 3406, 5, 22, 1,  0, 0}, // #702
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false, 3087, 5,  7, 1,  0, 0}, // #703
  {DBGFIELD("MOVSX16rm16_MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVSX64rm16_MOVSX64rm32_MOVSX64rm8_MOVZX16rm16_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX_MOVZX64rm16_MOVZX64rm8") 1, false, false, 2958, 2,  7, 1,  0, 0}, // #704
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 2, false, false, 2955, 3,  7, 1,  0, 0}, // #705
  {DBGFIELD("CLI")                3, false, false, 3080, 7,  7, 1,  0, 0}, // #706
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 3, false, false, 3292, 7,  7, 1,  0, 0}, // #707
  {DBGFIELD("PUSHGS64")           3, false, false, 3292, 7,  7, 1,  0, 0}, // #708
  {DBGFIELD("CALL64pcrel32")      3, false, false, 3417, 7,  7, 1,  0, 0}, // #709
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 3, false, false, 3417, 7,  7, 1,  0, 0}, // #710
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 3, false, false, 3417, 7,  7, 1,  0, 0}, // #711
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 3, false, false, 3424, 4,  7, 1,  0, 0}, // #712
  {DBGFIELD("SETAm_SETBEm")       4, false, false, 3428, 5, 21, 1,  0, 0}, // #713
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 4, false, false, 3433, 8,  7, 1,  0, 0}, // #714
  {DBGFIELD("PUSHF16_PUSHF64")    4, false, false, 3433, 8,  7, 1,  0, 0}, // #715
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 4, false, false, 3441, 8,  7, 1,  0, 0}, // #716
  {DBGFIELD("MMX_MOVD64from64rm") 1, false, false, 2958, 2,  6, 1,  0, 0}, // #717
  {DBGFIELD("VBROADCASTSSrm_MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 2958, 2,  6, 1,  0, 0}, // #718
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, 2958, 2,  6, 1,  0, 0}, // #719
  {DBGFIELD("MOVSDrm_VMOVSDrm_MOVSSrm_VMOVSSrm") 1, false, false, 2958, 2,  6, 1,  0, 0}, // #720
  {DBGFIELD("MOV16sm")            2, false, false, 2944, 6,  6, 1,  0, 0}, // #721
  {DBGFIELD("BT16mi8_BT32mi8_BT64mi8") 2, false, false, 3014, 4,  6, 1,  0, 0}, // #722
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 2, false, false, 2946, 4,  6, 1,  0, 0}, // #723
  {DBGFIELD("MMX_PALIGNRrmi")     2, false, false, 2946, 4,  6, 1,  0, 0}, // #724
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 2, false, false, 2946, 4,  6, 1,  0, 0}, // #725
  {DBGFIELD("LODSL_LODSQ")        2, false, false, 2947, 3,  6, 1,  0, 0}, // #726
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false, 2958, 2,  5, 1,  0, 0}, // #727
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 1, false, false, 2958, 2,  5, 1,  0, 0}, // #728
  {DBGFIELD("VINSERTF128rm")      2, false, false, 3014, 4,  5, 1,  0, 0}, // #729
  {DBGFIELD("MMX_PADDQirm")       2, false, false, 2946, 4,  5, 1,  0, 0}, // #730
  {DBGFIELD("VERRm_VERWm")        3, false, false, 2985, 6,  5, 1,  0, 0}, // #731
  {DBGFIELD("FARJMP64")           3, false, false, 3350, 7,  5, 1,  0, 0}, // #732
  {DBGFIELD("FNSTSWm")            4, false, false, 3449, 7,  5, 1,  0, 0}, // #733
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 4, false, false, 3456, 7,  5, 1,  0, 0}, // #734
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 4, false, false, 3371, 7,  5, 1,  0, 0}, // #735
  {DBGFIELD("CALL64m_CALL64m_NT") 4, false, false, 3371, 7,  5, 1,  0, 0}, // #736
  {DBGFIELD("SAR16m1_SAR32m1_SAR64m1_SAR8m1_SAR16mi_SAR32mi_SAR64mi_SAR8mi_SHL16m1_SHL32m1_SHL64m1_SHL8m1_SHL16mi_SHL32mi_SHL64mi_SHL8mi_SHR16m1_SHR32m1_SHR64m1_SHR8m1_SHR16mi_SHR32mi_SHR64mi_SHR8mi") 4, false, false, 3249, 5,  5, 1,  0, 0}, // #737
  {DBGFIELD("VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 3, false, false, 3065, 8, 10, 1,  0, 0}, // #738
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 5, false, false, 3463, 3, 10, 1,  0, 0}, // #739
  {DBGFIELD("ROL16m1_ROL32m1_ROL64m1_ROL8m1_ROL16mi_ROL32mi_ROL64mi_ROL8mi_ROR16m1_ROR32m1_ROR64m1_ROR8m1_ROR16mi_ROR32mi_ROR64mi_ROR8mi") 5, false, false, 3466, 5, 10, 1,  0, 0}, // #740
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 5, false, false, 3346, 4, 10, 1,  0, 0}, // #741
  {DBGFIELD("FARCALL64")          5, false, false, 3471, 8, 10, 1,  0, 0}, // #742
  {DBGFIELD("CVTSD2SI64rm_Int_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int") 3, false, false, 3065, 8,  9, 1,  0, 0}, // #743
  {DBGFIELD("CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int") 3, false, false, 3065, 8,  9, 1,  0, 0}, // #744
  {DBGFIELD("IMUL64m_MUL64m")     3, false, false, 3065, 8,  9, 1,  0, 0}, // #745
  {DBGFIELD("IMUL32m_MUL32m")     4, false, false, 3479, 7,  9, 1,  0, 0}, // #746
  {DBGFIELD("IMUL16rmi_IMUL16rmi8") 3, false, false, 3486, 6, 10, 1,  0, 0}, // #747
  {DBGFIELD("LD_F32m_LD_F64m")    3, false, false, 3350, 7,  9, 1,  0, 0}, // #748
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL_SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 6, false, false, 3492, 5,  9, 1,  0, 0}, // #749
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 6, false, false, 3497, 5,  9, 1,  9, 1}, // #750
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 2, false, false, 2968, 6, 18, 1,  0, 0}, // #751
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 2, false, false, 3052, 6, 26, 1,  0, 0}, // #752
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 3, false, false, 3502, 6, 26, 1,  0, 0}, // #753
  {DBGFIELD("MUL_F32m_MUL_F64m")  2, false, false, 3052, 6, 19, 1,  0, 0}, // #754
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 3, false, false, 3502, 6, 27, 1,  0, 0}, // #755
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 3, false, false, 3065, 8, 24, 1,  0, 0}, // #756
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 2, false, false, 3052, 6, 67, 1,  0, 0}, // #757
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 3, false, false, 3065, 8, 16, 1,  0, 0}, // #758
  {DBGFIELD("CLC")                1, false, false,  0, 0,  1, 1,  0, 0}, // #759
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 2, false, false, 2944, 6,  5, 1,  9, 1}, // #760
  {DBGFIELD("DIV8r")              1, false, false, 3099, 6, 34, 1,  0, 0}, // #761
  {DBGFIELD("IDIV8r")             1, false, false, 3099, 6, 34, 1,  0, 0}, // #762
  {DBGFIELD("RETIL_RETIQ_RETIW")  2, false, false, 2944, 6,  6, 1,  0, 0}, // #763
  {DBGFIELD("LRETIL_LRETIQ_LRETIW") 2, false, false, 2944, 6,  6, 1,  0, 0}, // #764
  {DBGFIELD("RDPMC")              1, false, false, 226, 2,  4, 1,  0, 0}, // #765
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false, 226, 2,  4, 1,  0, 0}, // #766
  {DBGFIELD("FBLDm")              1, false, false, 226, 2,  4, 1,  0, 0}, // #767
  {DBGFIELD("FFREE_FFREEP")       1, false, false, 2950, 5,  1, 1,  0, 0}, // #768
  {DBGFIELD("FSAVEm")             1, false, false, 226, 2,  4, 1,  0, 0}, // #769
  {DBGFIELD("FRSTORm")            1, false, false, 226, 2,  4, 1,  0, 0}, // #770
  {DBGFIELD("FXTRACT")            1, false, false, 226, 2,  4, 1,  0, 0}, // #771
  {DBGFIELD("VBROADCASTSSrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 2958, 2,  6, 1,  0, 0}, // #772
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 2, false, false, 2946, 4,  5, 1,  0, 0}, // #773
  {DBGFIELD("VBROADCASTF128")     2, false, false, 2944, 6,  5, 1,  0, 0}, // #774
  {DBGFIELD("VBROADCASTI128")     2, false, false, 2944, 6,  6, 1,  0, 0}, // #775
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 2, false, false, 2946, 4,  5, 1,  0, 0}, // #776
  {DBGFIELD("FBSTPm")             1, false, false, 226, 2,  4, 1,  0, 0}, // #777
  {DBGFIELD("ST_FP32m_ST_FP64m")  3, false, false, 3343, 3,  6, 1,  0, 0}, // #778
  {DBGFIELD("VMPTRSTm")           1, false, false, 226, 2,  4, 1,  0, 0}, // #779
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 1, false, false, 3087, 5,  1, 1,  0, 0}, // #780
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 1, false, false, 3087, 5,  1, 1,  0, 0}, // #781
  {DBGFIELD("MMX_MOVQ2DQrr")      1, false, false, 226, 2,  1, 1,  0, 0}, // #782
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT") 1, false, false, 2950, 5,  1, 1,  0, 0}, // #783
  {DBGFIELD("FINCSTP")            1, false, false, 2950, 5,  1, 1,  0, 0}, // #784
  {DBGFIELD("ANDN32rr_ANDN64rr_BLSI32rr_BLSI64rr_BLSMSK32rr_BLSMSK64rr_BLSR32rr_BLSR64rr") 1, false, false, 226, 2,  1, 1,  0, 0}, // #785
  {DBGFIELD("VPBLENDDYrri")       1, false, false, 1604, 3,  1, 1,  0, 0}, // #786
  {DBGFIELD("VPBLENDDrri")        1, false, false, 1604, 3,  1, 1,  0, 0}, // #787
  {DBGFIELD("CMC_STC")            1, false, false, 226, 2,  1, 1,  0, 0}, // #788
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false, 226, 2,  4, 1,  0, 0}, // #789
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 2, false, false, 3052, 6,  5, 1,  0, 0}, // #790
  {DBGFIELD("CVTSS2SDrm")         2, false, false, 3052, 6,  5, 1,  0, 0}, // #791
  {DBGFIELD("CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 2, false, false, 3052, 6,  5, 1,  9, 1}, // #792
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 2, false, false, 3052, 6,  5, 1,  9, 1}, // #793
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 2, false, false, 3052, 6, 10, 1,  9, 1}, // #794
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 2, false, false, 2947, 3,  6, 1,  9, 1}, // #795
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 2, false, false, 2946, 4,  5, 1,  0, 0}, // #796
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 2, false, false, 2944, 6, 10, 1,  0, 0}, // #797
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT") 2, false, false, 2944, 6,  6, 1,  0, 0}, // #798
  {DBGFIELD("ANDN32rm_ANDN64rm")  2, false, false, 2947, 3,  6, 1,  9, 1}, // #799
  {DBGFIELD("BLSI32rm_BLSI64rm_BLSMSK32rm_BLSMSK64rm_BLSR32rm_BLSR64rm_MOVBE16rm_MOVBE32rm_MOVBE64rm") 2, false, false, 2947, 3,  6, 1,  0, 0}, // #800
  {DBGFIELD("VINSERTI128rm")      2, false, false, 2944, 6, 10, 1,  9, 1}, // #801
  {DBGFIELD("VPBLENDDrmi")        2, false, false, 2946, 4,  5, 1,  9, 1}, // #802
  {DBGFIELD("VPBLENDDYrmi")       2, false, false, 2946, 4, 10, 1,  9, 1}, // #803
  {DBGFIELD("POP32r_POP64r")      1, false, false, 2958, 2,  6, 1,  0, 0}, // #804
  {DBGFIELD("SFENCE")             1, false, false, 2955, 3,  1, 1,  0, 0}, // #805
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 1, false, false, 2955, 3,  1, 1,  0, 0}, // #806
  {DBGFIELD("MOVBE16mr")          1, false, false, 2955, 3,  1, 1,  0, 0}, // #807
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r") 2, false, false, 2955, 3,  7, 1,  0, 0}, // #808
  {DBGFIELD("MFENCE")             1, false, false, 2955, 3,  1, 1,  0, 0}, // #809
  {DBGFIELD("XGETBV")             1, false, false, 226, 2,  4, 1,  0, 0}, // #810
  {DBGFIELD("CVTPS2PDrr_VCVTPS2PDrr") 2, false, false, 3058, 7, 20, 1,  0, 0}, // #811
  {DBGFIELD("CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 1, false, false, 3087, 5,  1, 1,  0, 0}, // #812
  {DBGFIELD("MMX_PACKSSDWirm_MMX_PACKSSWBirm_MMX_PACKUSWBirm") 2, false, false, 2944, 6,  6, 1,  9, 1}, // #813
  {DBGFIELD("LRETQ_RETL")         2, false, false, 2944, 6,  6, 1,  0, 0}, // #814
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, 226, 2,  1, 1,  0, 0}, // #815
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #816
  {DBGFIELD("VCVTDQ2PSYrr")       1, false, false, 2935, 5, 21, 1,  0, 0}, // #817
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, 1604, 3,  1, 1,  0, 0}, // #818
  {DBGFIELD("CVTPS2DQrm_VCVTPS2DQrm_CVTTPS2DQrm_VCVTTPS2DQrm") 2, false, false, 2968, 6,  9, 1,  0, 0}, // #819
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, 2968, 6, 18, 1,  0, 0}, // #820
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm") 2, false, false, 2968, 6, 18, 1,  0, 0}, // #821
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 2, false, false, 2944, 6, 10, 1,  0, 0}, // #822
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr") 1, false, false, 2950, 5,  1, 1,  0, 0}, // #823
  {DBGFIELD("CLDEMOTE")           1, false, false, 2958, 2,  7, 1,  0, 0}, // #824
  {DBGFIELD("RCL16r1_RCL32r1_RCL64r1_RCL8r1_RCL16ri_RCL32ri_RCL64ri_RCL8ri_RCR16r1_RCR32r1_RCR64r1_RCR8r1_RCR16ri_RCR32ri_RCR64ri_RCR8ri") 1, false, false, 382, 3,  1, 1,  0, 0}, // #825
  {DBGFIELD("RCL16m1_RCL32m1_RCL64m1_RCL8m1_RCL16mi_RCL32mi_RCL64mi_RCL8mi_RCR16m1_RCR32m1_RCR64m1_RCR8m1_RCR16mi_RCR32mi_RCR64mi_RCR8mi") 3, false, false, 3249, 5, 63, 2,  0, 0}, // #826
  {DBGFIELD("ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 6, false, false, 3492, 5,  9, 1,  0, 0}, // #827
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_CVTTSD2SI64rr_Int_CVTTSD2SIrr_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, 3073, 7,  7, 1,  0, 0}, // #828
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int_CVTSS2SIrr_Int_CVTTSS2SIrr_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_VCVTTSS2SIrr_Int") 2, false, false, 3073, 7,  7, 1,  0, 0}, // #829
  {DBGFIELD("VCVTPS2PDYrr")       2, false, false, 3058, 7, 20, 1,  0, 0}, // #830
  {DBGFIELD("MMX_CVTPI2PDirr_CVTDQ2PDrr_VCVTDQ2PDrr") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #831
  {DBGFIELD("MMX_CVTPD2PIirr_MMX_CVTTPD2PIirr_CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #832
  {DBGFIELD("CVTPD2PSrr_VCVTPD2PSrr") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #833
  {DBGFIELD("CVTSD2SSrr_CVTSD2SSrr_Int_VCVTSD2SSrr_VCVTSD2SSrr_Int") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #834
  {DBGFIELD("CVTSI2SDrr_CVTSI2SDrr_Int_CVTSI642SDrr_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #835
  {DBGFIELD("CVTSI2SSrr_CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int") 3, false, false, 3080, 7,  7, 1,  0, 0}, // #836
  {DBGFIELD("MULX64rr")           2, false, false, 2935, 5, 69, 2,  0, 0}, // #837
  {DBGFIELD("VCVTSD2SI64rm_Int_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 3, false, false, 3065, 8, 18, 1,  0, 0}, // #838
  {DBGFIELD("CVTSS2SI64rm_Int")   3, false, false, 3065, 8,  9, 1,  0, 0}, // #839
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, 3065, 8, 18, 1,  0, 0}, // #840
  {DBGFIELD("VCVTPS2PDYrm")       2, false, false, 3052, 6,  5, 1,  0, 0}, // #841
  {DBGFIELD("CVTPD2PSrm")         3, false, false, 3037, 8, 18, 1,  0, 0}, // #842
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_MMX_CVTPD2PIirm_MMX_CVTTPD2PIirm") 3, false, false, 3037, 8, 18, 1,  0, 0}, // #843
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 3, false, false, 3037, 8, 18, 1,  0, 0}, // #844
  {DBGFIELD("MMX_CVTPI2PDirm")    3, false, false, 3037, 8, 18, 1,  0, 0}, // #845
  {DBGFIELD("CVTSD2SSrm")         3, false, false, 3037, 8, 18, 1,  0, 0}, // #846
  {DBGFIELD("CVTSD2SSrm_Int_VCVTSD2SSrm_VCVTSD2SSrm_Int") 3, false, false, 3037, 8, 18, 1,  9, 1}, // #847
  {DBGFIELD("MULX64rm")           3, false, false, 2968, 6, 68, 2,  0, 0}, // #848
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 2, false, false, 2946, 4,  5, 1,  0, 0}, // #849
  {DBGFIELD("VZEROUPPER")         1, false, false, 226, 2,  4, 1,  0, 0}, // #850
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 1, false, false, 226, 2,  4, 1,  0, 0}, // #851
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 1, false, false, 226, 2,  4, 1,  0, 0}, // #852
  {DBGFIELD("VPCMPGTQYrr")        1, false, false, 1604, 3,  1, 1,  0, 0}, // #853
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, 3087, 5,  7, 1,  0, 0}, // #854
  {DBGFIELD("VPCMPGTQYrm")        2, false, false, 2946, 4, 10, 1,  9, 1}, // #855
  {DBGFIELD("CVTSI642SSrr_CVTSI642SSrr_Int_VCVTSI642SSrr_VCVTSI642SSrr_Int") 3, false, false, 3080, 7,  7, 1,  0, 0}, // #856
  {DBGFIELD("STR16r_STR32r_STR64r") 4, false, false, 3456, 7,  5, 1,  0, 0}, // #857
  {DBGFIELD("MULX32rr")           2, false, false, 2935, 5, 69, 2,  0, 0}, // #858
  {DBGFIELD("MULX32rm")           3, false, false, 2968, 6, 68, 2,  0, 0}, // #859
  {DBGFIELD("XSETBV")             1, false, false, 226, 2,  4, 1,  0, 0}, // #860
  {DBGFIELD("VCVTDQ2PDYrr")       2, false, false, 3045, 7, 22, 1,  0, 0}, // #861
  {DBGFIELD("VCVTPD2PSYrr")       2, false, false, 3045, 7, 22, 1,  0, 0}, // #862
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #863
  {DBGFIELD("VCVTDQ2PDYrm")       3, false, false, 3037, 8, 18, 1,  0, 0}, // #864
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 3, false, false, 3249, 5, 63, 2,  0, 0}, // #865
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 1, false, false, 382, 3,  1, 1,  0, 0}, // #866
  {DBGFIELD("RCL8rCL")            1, false, false, 382, 3,  1, 1,  0, 0}, // #867
  {DBGFIELD("RCR8rCL")            1, false, false, 382, 3,  1, 1,  0, 0}, // #868
  {DBGFIELD("VZEROALL")           1, false, false, 226, 2,  4, 1,  0, 0}, // #869
  {DBGFIELD("RDTSC")              1, false, false, 226, 2,  4, 1,  0, 0}, // #870
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 1, false, false, 226, 2,  4, 1,  0, 0}, // #871
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, 3125, 6, 25, 1,  0, 0}, // #872
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 2, false, false, 3052, 6, 67, 1,  0, 0}, // #873
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 3, false, false, 3065, 8, 16, 1,  0, 0}, // #874
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, 3125, 6, 25, 1,  0, 0}, // #875
  {DBGFIELD("XSAVE64")            1, false, false, 226, 2,  4, 1,  0, 0}, // #876
  {DBGFIELD("XSAVE")              1, false, false, 226, 2,  4, 1,  0, 0}, // #877
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 1, false, false, 226, 2,  4, 1,  0, 0}, // #878
  {DBGFIELD("VMCLEARm")           1, false, false, 226, 2,  4, 1,  0, 0}, // #879
  {DBGFIELD("FLDENVm")            1, false, false, 226, 2,  4, 1,  0, 0}, // #880
  {DBGFIELD("FXRSTOR64")          5, false, false, 3393, 8,  7, 1,  0, 0}, // #881
  {DBGFIELD("DIV16r")             1, false, false, 3099, 6, 34, 1,  0, 0}, // #882
  {DBGFIELD("DIV32r")             1, false, false, 3099, 6, 34, 1,  0, 0}, // #883
  {DBGFIELD("DIV64r")             1, false, false, 3099, 6, 34, 1,  0, 0}, // #884
  {DBGFIELD("IDIV16r")            1, false, false, 3099, 6, 34, 1,  0, 0}, // #885
  {DBGFIELD("IDIV32r")            1, false, false, 3099, 6, 34, 1,  0, 0}, // #886
  {DBGFIELD("IDIV64r")            1, false, false, 3099, 6, 34, 1,  0, 0}, // #887
  {DBGFIELD("FSTENVm")            1, false, false, 226, 2,  4, 1,  0, 0}, // #888
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm_VPGATHERDDrm") 1, false, false, 2958, 2,  7, 1,  0, 0}, // #889
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 1, false, false, 2958, 2,  7, 1,  0, 0}, // #890
  {DBGFIELD("VPGATHERQDYrm")      1, false, false, 2958, 2,  7, 1,  0, 0}, // #891
  {DBGFIELD("VPGATHERQDrm")       1, false, false, 2958, 2,  7, 1,  0, 0}, // #892
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 1, false, false, 2958, 2,  7, 1,  0, 0}, // #893
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 1, false, false, 2958, 2,  7, 1,  0, 0}, // #894
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 1, false, false, 2958, 2,  7, 1,  0, 0}, // #895
  {DBGFIELD("VGATHERQPSYrm")      1, false, false, 2958, 2,  7, 1,  0, 0}, // #896
  {DBGFIELD("VGATHERQPSrm_VGATHERDPSrm") 1, false, false, 2958, 2,  7, 1,  0, 0}, // #897
  {DBGFIELD("ADC8i8_ADC8ri_ADC8ri8_SBB8i8_SBB8ri_SBB8ri8") 2, false, false, 787, 3, 20, 1,  0, 0}, // #898
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 2, false, false, 2968, 6, 10, 1,  0, 0}, // #899
  {DBGFIELD("LRETQ")              2, false, false, 2944, 6,  6, 1,  0, 0}, // #900
  {DBGFIELD("CVTDQ2PSrm_VCVTDQ2PSrm") 2, false, false, 2968, 6,  9, 1,  0, 0}, // #901
  {DBGFIELD("POPF64")             1, false, false, 2958, 2,  7, 1,  0, 0}, // #902
  {DBGFIELD("VGATHERQPDrm")       1, false, false, 2958, 2,  7, 1,  0, 0}, // #903
  {DBGFIELD("VGATHERQPDYrm")      1, false, false, 2958, 2,  7, 1,  0, 0}, // #904
  {DBGFIELD("VGATHERDPDrm")       1, false, false, 2958, 2,  7, 1,  0, 0}, // #905
  {DBGFIELD("VGATHERDPSrm")       1, false, false, 2958, 2,  7, 1,  0, 0}, // #906
  {DBGFIELD("VGATHERDPDYrm")      1, false, false, 2958, 2,  7, 1,  0, 0}, // #907
  {DBGFIELD("VGATHERDPSYrm")      1, false, false, 2958, 2,  7, 1,  0, 0}, // #908
  {DBGFIELD("DIV16m")             2, false, false, 3092, 7, 37, 1, 11, 2}, // #909
  {DBGFIELD("DIV32m")             2, false, false, 3092, 7, 37, 1, 11, 2}, // #910
  {DBGFIELD("DIV64m")             2, false, false, 3092, 7, 37, 1, 11, 2}, // #911
  {DBGFIELD("DIV8m")              2, false, false, 3092, 7, 37, 1, 11, 2}, // #912
  {DBGFIELD("IDIV16m")            2, false, false, 3092, 7, 37, 1, 11, 2}, // #913
  {DBGFIELD("IDIV32m")            2, false, false, 3092, 7, 37, 1, 11, 2}, // #914
  {DBGFIELD("IDIV64m")            2, false, false, 3092, 7, 37, 1, 11, 2}, // #915
  {DBGFIELD("IDIV8m")             2, false, false, 3092, 7, 37, 1, 11, 2}, // #916
  {DBGFIELD("MOV16rm")            1, false, false, 2958, 2,  7, 1,  0, 0}, // #917
  {DBGFIELD("MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX") 1, false, false, 2958, 2,  7, 1,  0, 0}, // #918
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 3, false, false, 549, 2, 20, 1,  0, 0}, // #919
  {DBGFIELD("POP16rmm")           1, false, false, 2958, 2,  6, 1,  0, 0}, // #920
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 2, false, false, 2955, 3,  7, 1,  0, 0}, // #921
  {DBGFIELD("PUSHF16")            4, false, false, 3433, 8,  7, 1,  0, 0}, // #922
  {DBGFIELD("LAHF")               1, false, false, 382, 3,  1, 1,  0, 0}, // #923
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 2, false, false, 2947, 3,  6, 1,  0, 0}, // #924
  {DBGFIELD("ADD16mi_ADD16mi8_ADD16mr_ADD32mi_ADD32mi8_ADD32mr_ADD64mi32_ADD64mi8_ADD64mr_ADD8mi_ADD8mi8_ADD8mr_SUB16mi_SUB16mi8_SUB16mr_SUB32mi_SUB32mi8_SUB32mr_SUB64mi32_SUB64mi8_SUB64mr_SUB8mi_SUB8mi8_SUB8mr") 3, false, false, 2940, 4,  5, 1,  0, 0}, // #925
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 6, false, false, 2960, 4,  9, 1,  0, 0}, // #926
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 3, false, false, 2940, 4,  5, 1,  0, 0}, // #927
  {DBGFIELD("IMUL16rm")           2, false, false, 2968, 6, 10, 1,  9, 1}, // #928
  {DBGFIELD("IMUL64rr")           1, false, false, 2935, 5, 21, 1,  0, 0}, // #929
  {DBGFIELD("IMUL64rm")           2, false, false, 2968, 6, 10, 1,  9, 1}, // #930
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 3, false, false, 3417, 7,  7, 1,  0, 0}, // #931
  {DBGFIELD("RETW_LRETL_LRETW")   2, false, false, 2944, 6,  6, 1,  0, 0}, // #932
  {DBGFIELD("IRET16_IRET32_IRET64") 2, false, false, 2944, 6,  6, 1,  0, 0}, // #933
  {DBGFIELD("AND16mi_AND16mi8_AND16mr_AND32mi_AND32mi8_AND32mr_AND64mi32_AND64mi8_AND64mr_AND8mi_AND8mi8_AND8mr_OR16mi_OR16mi8_OR16mr_OR32mi_OR32mi8_OR32mr_OR64mi32_OR64mi8_OR64mr_OR8mi_OR8mi8_OR8mr_XOR16mi_XOR16mi8_XOR16mr_XOR32mi_XOR32mi8_XOR32mr_XOR64mi32_XOR64mi8_XOR64mr_XOR8mi_XOR8mi8_XOR8mr") 3, false, false, 2940, 4,  5, 1,  0, 0}, // #934
  {DBGFIELD("OR32mrLocked")       3, false, false, 2940, 4, 63, 2,  0, 0}, // #935
  {DBGFIELD("BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 1, false, false, 382, 3,  1, 1,  0, 0}, // #936
  {DBGFIELD("BLSI32rr_BLSI64rr_BLSMSK32rr_BLSMSK64rr_BLSR32rr_BLSR64rr") 1, false, false, 226, 2,  1, 1,  0, 0}, // #937
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 5, false, false, 3264, 5, 10, 1,  0, 0}, // #938
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 4, false, false, 497, 3, 22, 1,  0, 0}, // #939
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 7, false, false, 3259, 5, 18, 1,  0, 0}, // #940
  {DBGFIELD("MOVSLDUPrm")         1, false, false, 2958, 2,  6, 1,  0, 0}, // #941
  {DBGFIELD("MOVSLDUPrr")         1, false, false, 2950, 5,  1, 1,  0, 0}, // #942
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, 2950, 5,  1, 1,  0, 0}, // #943
  {DBGFIELD("VPMOVSXBDYrr_VPMOVSXBQYrr_VPMOVSXBWYrr_VPMOVSXDQYrr_VPMOVSXWDYrr_VPMOVSXWQYrr_VPMOVZXBDYrr_VPMOVZXBQYrr_VPMOVZXBWYrr_VPMOVZXDQYrr_VPMOVZXWDYrr_VPMOVZXWQYrr") 1, false, false, 2950, 5,  1, 1,  0, 0}, // #944
  {DBGFIELD("VPMOVZXBDYrm_VPMOVZXBQYrm_VPMOVZXBWYrm_VPMOVZXDQYrm_VPMOVZXWQYrm") 2, false, false, 2944, 6, 10, 1,  0, 0}, // #945
  {DBGFIELD("PBLENDWrri_VPBLENDWrri") 1, false, false, 1604, 3,  1, 1,  0, 0}, // #946
  {DBGFIELD("VPBLENDWYrri")       1, false, false, 1604, 3,  1, 1,  0, 0}, // #947
  {DBGFIELD("PBLENDWrmi_VPBLENDWrmi") 2, false, false, 2946, 4,  5, 1,  9, 1}, // #948
  {DBGFIELD("VPBLENDWYrmi")       2, false, false, 2946, 4, 10, 1,  9, 1}, // #949
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, 2950, 5,  1, 1,  0, 0}, // #950
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 1, false, false, 2955, 3,  1, 1,  0, 0}, // #951
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 1, false, false, 2955, 3,  1, 1,  0, 0}, // #952
  {DBGFIELD("VPMASKMOVDYrm")      3, false, false, 3018, 4,  9, 1,  0, 0}, // #953
  {DBGFIELD("VPMASKMOVDrm")       3, false, false, 3018, 4, 10, 1,  0, 0}, // #954
  {DBGFIELD("VPMASKMOVDYmr_VPMASKMOVQYmr") 3, false, false, 3325, 5,  7, 1,  0, 0}, // #955
  {DBGFIELD("VPMASKMOVDmr_VPMASKMOVQmr") 3, false, false, 3325, 5,  7, 1,  0, 0}, // #956
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 2, false, false, 2946, 4,  5, 1,  0, 0}, // #957
  {DBGFIELD("VPSLLDQri_VPSRLDQri") 1, false, false, 1604, 3,  1, 1,  0, 0}, // #958
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri") 1, false, false, 2950, 5,  1, 1,  0, 0}, // #959
  {DBGFIELD("VPERM2F128rr")       1, false, false, 2950, 5,  1, 1,  0, 0}, // #960
  {DBGFIELD("VPERM2F128rm")       2, false, false, 2944, 6, 10, 1,  9, 1}, // #961
  {DBGFIELD("VEXTRACTF128rr")     1, false, false, 2950, 5,  1, 1,  0, 0}, // #962
  {DBGFIELD("VEXTRACTF128mr")     1, false, false, 2955, 3,  1, 1,  0, 0}, // #963
  {DBGFIELD("VINSERTF128rr")      1, false, false, 2950, 5,  1, 1,  0, 0}, // #964
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #965
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #966
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 3, false, false, 3037, 8, 18, 1,  0, 0}, // #967
  {DBGFIELD("VCVTPD2DQrm_VCVTTPD2DQrm") 3, false, false, 3037, 8, 18, 1,  0, 0}, // #968
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 3, false, false, 3037, 8, 26, 1,  0, 0}, // #969
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_VCVTTSS2SIrr_Int") 2, false, false, 3073, 7,  7, 1,  0, 0}, // #970
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, 3065, 8, 18, 1,  0, 0}, // #971
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, 1604, 3,  1, 1,  0, 0}, // #972
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, 1604, 3,  1, 1,  0, 0}, // #973
  {DBGFIELD("SHA256MSG2rm")       2, false, false, 3052, 6, 26, 1,  9, 1}, // #974
  {DBGFIELD("SHA256MSG2rr")       1, false, false, 3087, 5,  7, 1,  0, 0}, // #975
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, 3087, 5,  7, 1,  0, 0}, // #976
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 2, false, false, 3052, 6, 26, 1,  9, 1}, // #977
  {DBGFIELD("SHA1MSG2rr")         1, false, false, 3087, 5,  7, 1,  0, 0}, // #978
  {DBGFIELD("SHA1MSG2rm")         2, false, false, 3052, 6, 26, 1,  9, 1}, // #979
  {DBGFIELD("SHA1NEXTErr")        1, false, false, 3087, 5,  7, 1,  0, 0}, // #980
  {DBGFIELD("SHA1NEXTErm")        2, false, false, 3052, 6, 26, 1,  9, 1}, // #981
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, 3087, 5,  7, 1,  0, 0}, // #982
  {DBGFIELD("SHA1RNDS4rmi")       2, false, false, 3052, 6, 26, 1,  9, 1}, // #983
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, 3087, 5,  7, 1,  0, 0}, // #984
  {DBGFIELD("SHA256RNDS2rm")      2, false, false, 3052, 6, 26, 1,  9, 1}, // #985
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 1, false, false, 226, 2,  1, 1,  0, 0}, // #986
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr_ANDNPSrr_VANDNPSrr_ANDNPDrr_VANDNPDrr") 1, false, false, 2950, 5,  1, 1,  0, 0}, // #987
  {DBGFIELD("MMX_PXORirr_MMX_PANDNirr") 1, false, false, 226, 2,  1, 1,  0, 0}, // #988
  {DBGFIELD("PXORrr_VPXORrr_PANDNrr_VPANDNrr") 1, false, false, 226, 2,  1, 1,  0, 0}, // #989
  {DBGFIELD("MMX_PSUBBirr_MMX_PSUBDirr_MMX_PSUBWirr_MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #990
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 1, false, false, 1604, 3,  1, 1,  0, 0}, // #991
  {DBGFIELD("PSUBQrr")            1, false, false, 1604, 3,  1, 1,  0, 0}, // #992
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false, 710, 3,  1, 1,  0, 0}, // #993
  {DBGFIELD("LEA16r")             1, false, false, 710, 3,  1, 1,  0, 0}, // #994
  {DBGFIELD("MMX_PADDSBirr_MMX_PADDSWirr_MMX_PADDUSBirr_MMX_PADDUSWirr_MMX_PAVGBirr_MMX_PAVGWirr_MMX_PCMPEQBirr_MMX_PCMPEQDirr_MMX_PCMPEQWirr_MMX_PMAXSWirr_MMX_PMINSWirr_MMX_PMAXUBirr_MMX_PMINUBirr_MMX_PSUBSBirr_MMX_PSUBSWirr_MMX_PSUBUSBirr_MMX_PSUBUSWirr") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #995
  {DBGFIELD("MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #996
  {DBGFIELD("CLAC_STAC")          1, false, false, 226, 2,  4, 1,  0, 0}, // #997
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, 1604, 3,  1, 1,  0, 0}, // #998
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr_VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr") 1, false, false, 1604, 3,  1, 1,  0, 0}, // #999
  {DBGFIELD("PSUBBrr_PSUBDrr_PSUBWrr_VPSUBBrr_VPSUBDrr_VPSUBQrr_VPSUBWrr") 1, false, false, 1604, 3,  1, 1,  0, 0}, // #1000
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #1001
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 3, false, false, 3084, 3, 21, 1,  0, 0}, // #1002
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, 3084, 3, 21, 1,  0, 0}, // #1003
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 3, false, false, 3084, 3, 21, 1,  0, 0}, // #1004
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #1005
  {DBGFIELD("VCVTPS2DQYrr_VCVTTPS2DQYrr") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #1006
  {DBGFIELD("MMX_PADDSBirm_MMX_PADDSWirm_MMX_PADDUSBirm_MMX_PADDUSWirm_MMX_PAVGBirm_MMX_PAVGWirm_MMX_PCMPEQBirm_MMX_PCMPEQDirm_MMX_PCMPEQWirm_MMX_PCMPGTBirm_MMX_PCMPGTDirm_MMX_PCMPGTWirm_MMX_PMAXSWirm_MMX_PMAXUBirm_MMX_PMINSWirm_MMX_PMINUBirm_MMX_PSUBSBirm_MMX_PSUBSWirm_MMX_PSUBUSBirm_MMX_PSUBUSWirm") 2, false, false, 2968, 6, 10, 1,  9, 1}, // #1007
  {DBGFIELD("CVTSS2SI64rr_Int")   2, false, false, 3073, 7,  7, 1,  0, 0}, // #1008
  {DBGFIELD("CVTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int") 2, false, false, 3073, 7,  7, 1,  0, 0}, // #1009
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 2, false, false, 2946, 4,  5, 1,  9, 1}, // #1010
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 2, false, false, 2946, 4, 10, 1,  9, 1}, // #1011
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 4, false, false, 3182, 4, 10, 1,  9, 1}, // #1012
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, 3182, 4,  9, 1,  9, 1}, // #1013
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 4, false, false, 3182, 4, 18, 1,  9, 1}, // #1014
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 1, false, false, 226, 2,  4, 1,  0, 0}, // #1015
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, 226, 2,  1, 1,  0, 0}, // #1016
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, 226, 2,  1, 1,  0, 0}, // #1017
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, 226, 2,  1, 1,  0, 0}, // #1018
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 2, false, false, 3022, 3, 20, 1,  0, 0}, // #1019
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 2, false, false, 3022, 3, 20, 1,  0, 0}, // #1020
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rr_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rr_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rr_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rr_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, 1604, 3,  1, 1,  0, 0}, // #1021
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rr_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rr_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rr_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rr_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 1, false, false, 1604, 3,  1, 1,  0, 0}, // #1022
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrr_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrr_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrr_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrr_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 1, false, false, 1604, 3,  1, 1,  0, 0}, // #1023
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 2, false, false, 1844, 3, 20, 1,  0, 0}, // #1024
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 2, false, false, 1844, 3, 20, 1,  0, 0}, // #1025
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false, 2955, 3,  1, 1,  0, 0}, // #1026
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 1, false, false, 2955, 3,  1, 1,  0, 0}, // #1027
  {DBGFIELD("KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, 226, 2,  1, 1,  0, 0}, // #1028
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, 226, 2,  1, 1,  0, 0}, // #1029
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_VPTESTMBZ128rr_VPTESTMBZ128rrk_VPTESTMDZ128rr_VPTESTMDZ128rrk_VPTESTMQZ128rr_VPTESTMQZ128rrk_VPTESTMWZ128rr_VPTESTMWZ128rrk_VPTESTNMBZ128rr_VPTESTNMBZ128rrk_VPTESTNMDZ128rr_VPTESTNMDZ128rrk_VPTESTNMQZ128rr_VPTESTNMQZ128rrk_VPTESTNMWZ128rr_VPTESTNMWZ128rrk") 1, false, false, 226, 2,  1, 1,  0, 0}, // #1030
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri_KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, 2950, 5,  1, 1,  0, 0}, // #1031
  {DBGFIELD("VALIGNDZ128rri_VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rri_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, 1604, 3,  1, 1,  0, 0}, // #1032
  {DBGFIELD("VALIGNDZ256rri_VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rri_VALIGNQZ256rrik_VALIGNQZ256rrikz") 1, false, false, 2950, 5,  1, 1,  0, 0}, // #1033
  {DBGFIELD("VALIGNDZrri_VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrri_VALIGNQZrrik_VALIGNQZrrikz") 1, false, false, 2950, 5,  1, 1,  0, 0}, // #1034
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rri_alt_VCMPPDZ128rri_altk_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rri_alt_VCMPPSZ128rri_altk_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #1035
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rri_alt_VCMPPDZ256rri_altk_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rri_alt_VCMPPSZ256rri_altk_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #1036
  {DBGFIELD("VCMPPDZrri_VCMPPDZrri_alt_VCMPPDZrri_altk_VCMPPDZrrib_VCMPPDZrrib_alt_VCMPPDZrrib_altk_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrri_alt_VCMPPSZrri_altk_VCMPPSZrrib_VCMPPSZrrib_alt_VCMPPSZrrib_altk_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #1037
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSDZrrb_alt_VCMPSDZrrb_altk_VCMPSDZrri_alt_VCMPSDZrri_altk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VCMPSSZrrb_alt_VCMPSSZrrb_altk_VCMPSSZrri_alt_VCMPSSZrri_altk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #1038
  {DBGFIELD("VDBPSADBWZrri_VDBPSADBWZrrik_VDBPSADBWZrrikz_VPSADBWZrr") 1, false, false, 3087, 5,  7, 1,  0, 0}, // #1039
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rri_alt_VPCMPBZ128rrik_VPCMPBZ128rrik_alt_VPCMPDZ128rri_VPCMPDZ128rri_alt_VPCMPDZ128rrik_VPCMPDZ128rrik_alt_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rri_alt_VPCMPQZ128rrik_VPCMPQZ128rrik_alt_VPCMPUBZ128rri_VPCMPUBZ128rri_alt_VPCMPUBZ128rrik_VPCMPUBZ128rrik_alt_VPCMPUDZ128rri_VPCMPUDZ128rri_alt_VPCMPUDZ128rrik_VPCMPUDZ128rrik_alt_VPCMPUQZ128rri_VPCMPUQZ128rri_alt_VPCMPUQZ128rrik_VPCMPUQZ128rrik_alt_VPCMPUWZ128rri_VPCMPUWZ128rri_alt_VPCMPUWZ128rrik_VPCMPUWZ128rrik_alt_VPCMPWZ128rri_VPCMPWZ128rri_alt_VPCMPWZ128rrik_VPCMPWZ128rrik_alt_VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, 1604, 3,  1, 1,  0, 0}, // #1040
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rri_alt_VPCMPBZ256rrik_VPCMPBZ256rrik_alt_VPCMPDZ256rri_VPCMPDZ256rri_alt_VPCMPDZ256rrik_VPCMPDZ256rrik_alt_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rri_alt_VPCMPQZ256rrik_VPCMPQZ256rrik_alt_VPCMPUBZ256rri_VPCMPUBZ256rri_alt_VPCMPUBZ256rrik_VPCMPUBZ256rrik_alt_VPCMPUDZ256rri_VPCMPUDZ256rri_alt_VPCMPUDZ256rrik_VPCMPUDZ256rrik_alt_VPCMPUQZ256rri_VPCMPUQZ256rri_alt_VPCMPUQZ256rrik_VPCMPUQZ256rrik_alt_VPCMPUWZ256rri_VPCMPUWZ256rri_alt_VPCMPUWZ256rrik_VPCMPUWZ256rrik_alt_VPCMPWZ256rri_VPCMPWZ256rri_alt_VPCMPWZ256rrik_VPCMPWZ256rrik_alt_VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 1, false, false, 1604, 3,  1, 1,  0, 0}, // #1041
  {DBGFIELD("VPCMPBZrri_VPCMPBZrri_alt_VPCMPBZrrik_VPCMPBZrrik_alt_VPCMPDZrri_VPCMPDZrri_alt_VPCMPDZrrik_VPCMPDZrrik_alt_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrri_alt_VPCMPQZrrik_VPCMPQZrrik_alt_VPCMPUBZrri_VPCMPUBZrri_alt_VPCMPUBZrrik_VPCMPUBZrrik_alt_VPCMPUDZrri_VPCMPUDZrri_alt_VPCMPUDZrrik_VPCMPUDZrrik_alt_VPCMPUQZrri_VPCMPUQZrri_alt_VPCMPUQZrrik_VPCMPUQZrrik_alt_VPCMPUWZrri_VPCMPUWZrri_alt_VPCMPUWZrrik_VPCMPUWZrrik_alt_VPCMPWZrri_VPCMPWZrri_alt_VPCMPWZrrik_VPCMPWZrrik_alt_VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 1, false, false, 1604, 3,  1, 1,  0, 0}, // #1042
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 1, false, false, 226, 2,  1, 1,  0, 0}, // #1043
  {DBGFIELD("VPTESTMBZrr_VPTESTMBZrrk_VPTESTMDZrr_VPTESTMDZrrk_VPTESTMQZrr_VPTESTMQZrrk_VPTESTMWZrr_VPTESTMWZrrk_VPTESTNMBZrr_VPTESTNMBZrrk_VPTESTNMDZrr_VPTESTNMDZrrk_VPTESTNMQZrr_VPTESTNMQZrrk_VPTESTNMWZrr_VPTESTNMWZrrk") 1, false, false, 226, 2,  1, 1,  0, 0}, // #1044
  {DBGFIELD("VCVTDQ2PSZ128rr_VCVTDQ2PSZ128rrk_VCVTDQ2PSZ128rrkz_VCVTUDQ2PSZ128rr_VCVTUDQ2PSZ128rrk_VCVTUDQ2PSZ128rrkz") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #1045
  {DBGFIELD("VCVTDQ2PSZ256rr_VCVTDQ2PSZ256rrk_VCVTDQ2PSZ256rrkz_VCVTUDQ2PSZ256rr_VCVTUDQ2PSZ256rrk_VCVTUDQ2PSZ256rrkz") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #1046
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #1047
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #1048
  {DBGFIELD("VCVTPS2DQYrr")       1, false, false, 2935, 5, 21, 1,  0, 0}, // #1049
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #1050
  {DBGFIELD("VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #1051
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #1052
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #1053
  {DBGFIELD("VCVTDQ2PSZrr_VCVTUDQ2PSZrr") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #1054
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #1055
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #1056
  {DBGFIELD("VCVTQQ2PDZrr_VCVTUQQ2PDZrr") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #1057
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 1, false, false, 2950, 5,  1, 1,  0, 0}, // #1058
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 1, false, false, 2950, 5,  1, 1,  0, 0}, // #1059
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 2, false, false, 2944, 6, 10, 1,  0, 0}, // #1060
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #1061
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #1062
  {DBGFIELD("VCVTPD2PSZ128rr_VCVTPD2PSZ128rrk_VCVTPD2PSZ128rrkz") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #1063
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz") 2, false, false, 3058, 7, 20, 1,  0, 0}, // #1064
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #1065
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #1066
  {DBGFIELD("VCVTSD2SSZrr_VCVTSD2SSZrr_Int_VCVTSD2SSZrr_Intk_VCVTSD2SSZrr_Intkz_VCVTSD2SSZrrb_Int_VCVTSD2SSZrrb_Intk_VCVTSD2SSZrrb_Intkz") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #1067
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 3, false, false, 3080, 7,  7, 1,  0, 0}, // #1068
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI2SDZrrb_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #1069
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz") 1, false, false, 3087, 5,  1, 1,  0, 0}, // #1070
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, 1604, 3,  1, 1,  0, 0}, // #1071
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 1, false, false, 3292, 7, 22, 1,  0, 0}, // #1072
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 1, false, false, 3292, 7, 22, 1,  0, 0}, // #1073
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 1, false, false, 3292, 7, 22, 1,  0, 0}, // #1074
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 2, false, false, 2944, 6, 10, 1,  0, 0}, // #1075
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 1, false, false, 2950, 5,  1, 1,  0, 0}, // #1076
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm_VMOVDI2PDIZrm") 1, false, false, 2958, 2,  7, 1,  0, 0}, // #1077
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 3, false, false, 3080, 7,  7, 1,  0, 0}, // #1078
  {DBGFIELD("VMOVSDZrm_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, 2958, 2,  7, 1,  0, 0}, // #1079
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #1080
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #1081
  {DBGFIELD("VCVTPD2PSZ256rr_VCVTPD2PSZ256rrk_VCVTPD2PSZ256rrkz") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #1082
  {DBGFIELD("VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 2, false, false, 3058, 7, 20, 1,  0, 0}, // #1083
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #1084
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #1085
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #1086
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 2, false, false, 3045, 7, 22, 1,  0, 0}, // #1087
  {DBGFIELD("VCVTPD2PSZrr")       2, false, false, 3045, 7, 22, 1,  0, 0}, // #1088
  {DBGFIELD("VCVTPS2PDZrr")       2, false, false, 3058, 7, 20, 1,  0, 0}, // #1089
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #1090
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 1, false, false, 2935, 5, 21, 1,  0, 0}, // #1091
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 3, false, false, 3018, 4, 10, 1,  9, 1}, // #1092
  {DBGFIELD("VBROADCASTI32X2Z128m_VBROADCASTI32X2Z128mk_VBROADCASTI32X2Z128mkz_VPBROADCASTDZ128m_VPBROADCASTDZ128mk_VPBROADCASTDZ128mkz_VPBROADCASTQZ128m_VPBROADCASTQZ128mk_VPBROADCASTQZ128mkz") 2, false, false, 2946, 4,  5, 1,  0, 0}, // #1093
  {DBGFIELD("VBROADCASTSSZ128m_VBROADCASTSSZ128mk_VBROADCASTSSZ128mkz") 2, false, false, 2944, 6, 10, 1,  0, 0}, // #1094
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, 2958, 2,  6, 1,  0, 0}, // #1095
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 2, false, false, 2944, 6,  5, 1,  0, 0}, // #1096
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz_VMOVNTDQAZ128rm") 1, false, false, 2958, 2,  6, 1,  0, 0}, // #1097
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 2, false, false, 2946, 4,  5, 1,  9, 1}, // #1098
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 3, false, false, 2987, 4, 10, 1,  9, 1}, // #1099
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 1, false, false, 2950, 5,  1, 1,  0, 0}, // #1100
  {DBGFIELD("VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 2, false, false, 3073, 7,  7, 1,  0, 0}, // #1101
  {DBGFIELD("VCVTSS2SI64rr_Int")  2, false, false, 3073, 7,  7, 1,  0, 0}, // #1102
  {DBGFIELD("VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int") 2, false, false, 3073, 7,  7, 1,  0, 0}, // #1103
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, 2958, 2,  7, 1,  0, 0}, // #1104
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 2, false, false, 2944, 6, 10, 1,  0, 0}, // #1105
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 1, false, false, 2955, 3,  1, 1,  0, 0}, // #1106
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 1, false, false, 2955, 3,  1, 1,  0, 0}, // #1107
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 1, false, false, 2955, 3,  1, 1,  0, 0}, // #1108
  {DBGFIELD("VSCATTERDPSZmr")     1, false, false, 2955, 3,  1, 1,  0, 0}, // #1109
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk") 2, false, false, 2968, 6,  9, 1,  9, 1}, // #1110
  {DBGFIELD("VPBROADCASTBZ256m_VPBROADCASTBZ256mk_VPBROADCASTBZ256mkz_VPBROADCASTBZm_VPBROADCASTBZmk_VPBROADCASTBZmkz_VPBROADCASTWZ256m_VPBROADCASTWZ256mk_VPBROADCASTWZ256mkz_VPBROADCASTWZm_VPBROADCASTWZmk_VPBROADCASTWZmkz") 2, false, false, 2944, 6, 10, 1,  0, 0}, // #1111
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 3, false, false, 3018, 4,  9, 1,  9, 1}, // #1112
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 3, false, false, 3018, 4,  9, 1,  9, 1}, // #1113
  {DBGFIELD("VBROADCASTF32X2Z256m_VBROADCASTF32X2Z256mk_VBROADCASTF32X2Z256mkz_VBROADCASTF32X2Zm_VBROADCASTF32X2Zmk_VBROADCASTF32X2Zmkz_VBROADCASTI32X2Z256m_VBROADCASTI32X2Z256mk_VBROADCASTI32X2Z256mkz_VBROADCASTI32X2Zm_VBROADCASTI32X2Zmk_VBROADCASTI32X2Zmkz_VPBROADCASTDZ256m_VPBROADCASTDZ256mk_VPBROADCASTDZ256mkz_VPBROADCASTDZm_VPBROADCASTDZmk_VPBROADCASTDZmkz_VPBROADCASTQZ256m_VPBROADCASTQZ256mk_VPBROADCASTQZ256mkz_VPBROADCASTQZm_VPBROADCASTQZmk_VPBROADCASTQZmkz") 2, false, false, 2944, 6, 10, 1,  0, 0}, // #1114
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 2, false, false, 2944, 6, 10, 1,  0, 0}, // #1115
  {DBGFIELD("VBROADCASTSDZ256m_VBROADCASTSDZ256mk_VBROADCASTSDZ256mkz_VBROADCASTSDZm_VBROADCASTSDZmk_VBROADCASTSDZmkz_VBROADCASTSSZ256m_VBROADCASTSSZ256mk_VBROADCASTSSZ256mkz_VBROADCASTSSZm_VBROADCASTSSZmk_VBROADCASTSSZmkz") 2, false, false, 2944, 6, 10, 1,  0, 0}, // #1116
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #1117
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #1118
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 1, false, false, 2958, 2,  5, 1,  0, 0}, // #1119
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, 2944, 6, 10, 1,  0, 0}, // #1120
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 2, false, false, 2944, 6, 10, 1,  0, 0}, // #1121
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz_VMOVNTDQAZ256rm") 1, false, false, 2958, 2,  5, 1,  0, 0}, // #1122
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 2, false, false, 2946, 4, 10, 1,  9, 1}, // #1123
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 2, false, false, 2946, 4, 10, 1,  9, 1}, // #1124
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 3, false, false, 2987, 4,  9, 1,  9, 1}, // #1125
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 3, false, false, 2987, 4,  9, 1,  9, 1}, // #1126
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 1, false, false, 2955, 3,  1, 1,  0, 0}, // #1127
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 1, false, false, 2955, 3,  1, 1,  0, 0}, // #1128
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 1, false, false, 2955, 3,  1, 1,  0, 0}, // #1129
  {DBGFIELD("VPSCATTERDDZmr")     1, false, false, 2955, 3,  1, 1,  0, 0}, // #1130
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 2, false, false, 2946, 4,  5, 1,  9, 1}, // #1131
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbi_alt_VCMPPDZ128rmbi_altk_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmi_alt_VCMPPDZ128rmi_altk_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbi_alt_VCMPPSZ128rmbi_altk_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmi_alt_VCMPPSZ128rmi_altk_VCMPPSZ128rmik") 2, false, false, 2968, 6,  9, 1,  9, 1}, // #1132
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSDZrmi_alt_VCMPSDZrmi_altk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk_VCMPSSZrmi_alt_VCMPSSZrmi_altk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 2, false, false, 2968, 6,  9, 1,  9, 1}, // #1133
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmi_alt_VPCMPBZ128rmik_VPCMPBZ128rmik_alt_VPCMPDZ128rmi_VPCMPDZ128rmi_alt_VPCMPDZ128rmib_VPCMPDZ128rmib_alt_VPCMPDZ128rmibk_VPCMPDZ128rmibk_alt_VPCMPDZ128rmik_VPCMPDZ128rmik_alt_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmi_alt_VPCMPQZ128rmib_VPCMPQZ128rmib_alt_VPCMPQZ128rmibk_VPCMPQZ128rmibk_alt_VPCMPQZ128rmik_VPCMPQZ128rmik_alt_VPCMPUBZ128rmi_VPCMPUBZ128rmi_alt_VPCMPUBZ128rmik_VPCMPUBZ128rmik_alt_VPCMPUDZ128rmi_VPCMPUDZ128rmi_alt_VPCMPUDZ128rmib_VPCMPUDZ128rmib_alt_VPCMPUDZ128rmibk_VPCMPUDZ128rmibk_alt_VPCMPUDZ128rmik_VPCMPUDZ128rmik_alt_VPCMPUQZ128rmi_VPCMPUQZ128rmi_alt_VPCMPUQZ128rmib_VPCMPUQZ128rmib_alt_VPCMPUQZ128rmibk_VPCMPUQZ128rmibk_alt_VPCMPUQZ128rmik_VPCMPUQZ128rmik_alt_VPCMPUWZ128rmi_VPCMPUWZ128rmi_alt_VPCMPUWZ128rmik_VPCMPUWZ128rmik_alt_VPCMPWZ128rmi_VPCMPWZ128rmi_alt_VPCMPWZ128rmik_VPCMPWZ128rmik_alt_VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 2, false, false, 2946, 4,  5, 1,  9, 1}, // #1134
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #1135
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #1136
  {DBGFIELD("VPMOVSXBDZ128rm_VPMOVSXBDZ128rmk_VPMOVSXBDZ128rmkz_VPMOVSXBQZ128rm_VPMOVSXBQZ128rmk_VPMOVSXBQZ128rmkz_VPMOVSXBWZ128rm_VPMOVSXBWZ128rmk_VPMOVSXBWZ128rmkz_VPMOVSXDQZ128rm_VPMOVSXDQZ128rmk_VPMOVSXDQZ128rmkz_VPMOVSXWDZ128rm_VPMOVSXWDZ128rmk_VPMOVSXWDZ128rmkz_VPMOVSXWQZ128rm_VPMOVSXWQZ128rmk_VPMOVSXWQZ128rmkz_VPMOVZXBDZ128rm_VPMOVZXBDZ128rmk_VPMOVZXBDZ128rmkz_VPMOVZXBQZ128rm_VPMOVZXBQZ128rmk_VPMOVZXBQZ128rmkz_VPMOVZXBWZ128rm_VPMOVZXBWZ128rmk_VPMOVZXBWZ128rmkz_VPMOVZXDQZ128rm_VPMOVZXDQZ128rmk_VPMOVZXDQZ128rmkz_VPMOVZXWDZ128rm_VPMOVZXWDZ128rmk_VPMOVZXWDZ128rmkz_VPMOVZXWQZ128rm_VPMOVZXWQZ128rmk_VPMOVZXWQZ128rmkz") 2, false, false, 2944, 6, 10, 1,  0, 0}, // #1137
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 2, false, false, 2947, 3,  5, 1,  9, 1}, // #1138
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #1139
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #1140
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbi_alt_VCMPPDZ256rmbi_altk_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmi_alt_VCMPPDZ256rmi_altk_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbi_alt_VCMPPSZ256rmbi_altk_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmi_alt_VCMPPSZ256rmi_altk_VCMPPSZ256rmik") 2, false, false, 2968, 6, 18, 1,  9, 1}, // #1141
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbi_alt_VCMPPDZrmbi_altk_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmi_alt_VCMPPDZrmi_altk_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbi_alt_VCMPPSZrmbi_altk_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmi_alt_VCMPPSZrmi_altk_VCMPPSZrmik") 2, false, false, 2968, 6, 18, 1,  9, 1}, // #1142
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmi_alt_VPCMPBZ256rmik_VPCMPBZ256rmik_alt_VPCMPDZ256rmi_VPCMPDZ256rmi_alt_VPCMPDZ256rmib_VPCMPDZ256rmib_alt_VPCMPDZ256rmibk_VPCMPDZ256rmibk_alt_VPCMPDZ256rmik_VPCMPDZ256rmik_alt_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmi_alt_VPCMPQZ256rmib_VPCMPQZ256rmib_alt_VPCMPQZ256rmibk_VPCMPQZ256rmibk_alt_VPCMPQZ256rmik_VPCMPQZ256rmik_alt_VPCMPUBZ256rmi_VPCMPUBZ256rmi_alt_VPCMPUBZ256rmik_VPCMPUBZ256rmik_alt_VPCMPUDZ256rmi_VPCMPUDZ256rmi_alt_VPCMPUDZ256rmib_VPCMPUDZ256rmib_alt_VPCMPUDZ256rmibk_VPCMPUDZ256rmibk_alt_VPCMPUDZ256rmik_VPCMPUDZ256rmik_alt_VPCMPUQZ256rmi_VPCMPUQZ256rmi_alt_VPCMPUQZ256rmib_VPCMPUQZ256rmib_alt_VPCMPUQZ256rmibk_VPCMPUQZ256rmibk_alt_VPCMPUQZ256rmik_VPCMPUQZ256rmik_alt_VPCMPUWZ256rmi_VPCMPUWZ256rmi_alt_VPCMPUWZ256rmik_VPCMPUWZ256rmik_alt_VPCMPWZ256rmi_VPCMPWZ256rmi_alt_VPCMPWZ256rmik_VPCMPWZ256rmik_alt_VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 2, false, false, 2946, 4, 10, 1,  9, 1}, // #1143
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmi_alt_VPCMPBZrmik_VPCMPBZrmik_alt_VPCMPDZrmi_VPCMPDZrmi_alt_VPCMPDZrmib_VPCMPDZrmib_alt_VPCMPDZrmibk_VPCMPDZrmibk_alt_VPCMPDZrmik_VPCMPDZrmik_alt_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmi_alt_VPCMPQZrmib_VPCMPQZrmib_alt_VPCMPQZrmibk_VPCMPQZrmibk_alt_VPCMPQZrmik_VPCMPQZrmik_alt_VPCMPUBZrmi_VPCMPUBZrmi_alt_VPCMPUBZrmik_VPCMPUBZrmik_alt_VPCMPUDZrmi_VPCMPUDZrmi_alt_VPCMPUDZrmib_VPCMPUDZrmib_alt_VPCMPUDZrmibk_VPCMPUDZrmibk_alt_VPCMPUDZrmik_VPCMPUDZrmik_alt_VPCMPUQZrmi_VPCMPUQZrmi_alt_VPCMPUQZrmib_VPCMPUQZrmib_alt_VPCMPUQZrmibk_VPCMPUQZrmibk_alt_VPCMPUQZrmik_VPCMPUQZrmik_alt_VPCMPUWZrmi_VPCMPUWZrmi_alt_VPCMPUWZrmik_VPCMPUWZrmik_alt_VPCMPWZrmi_VPCMPWZrmi_alt_VPCMPWZrmik_VPCMPWZrmik_alt_VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 2, false, false, 2946, 4, 10, 1,  9, 1}, // #1144
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 2, false, false, 2947, 3, 10, 1,  9, 1}, // #1145
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 2, false, false, 2947, 3, 10, 1,  9, 1}, // #1146
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 3, false, false, 3037, 8, 18, 1,  0, 0}, // #1147
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 2, false, false, 2968, 6,  9, 1,  0, 0}, // #1148
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 3, false, false, 3037, 8, 18, 1,  0, 0}, // #1149
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 2, false, false, 2968, 6, 10, 1,  0, 0}, // #1150
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 2, false, false, 2968, 6,  9, 1,  0, 0}, // #1151
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 2, false, false, 3052, 6,  5, 1,  0, 0}, // #1152
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz") 2, false, false, 3052, 6,  5, 1,  9, 1}, // #1153
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #1154
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 3, false, false, 3037, 8, 18, 1,  0, 0}, // #1155
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 3, false, false, 3037, 8, 18, 1,  0, 0}, // #1156
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 2, false, false, 2968, 6, 18, 1,  0, 0}, // #1157
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 2, false, false, 2968, 6, 18, 1,  0, 0}, // #1158
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 2, false, false, 2968, 6, 10, 1,  0, 0}, // #1159
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 2, false, false, 2968, 6, 10, 1,  0, 0}, // #1160
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 2, false, false, 3052, 6,  5, 1,  0, 0}, // #1161
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 2, false, false, 3052, 6,  5, 1,  0, 0}, // #1162
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 3, false, false, 3037, 8, 26, 1,  0, 0}, // #1163
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 3, false, false, 3037, 8, 26, 1,  0, 0}, // #1164
  {DBGFIELD("VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 2, false, false, 2968, 6, 18, 1,  0, 0}, // #1165
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 2, false, false, 2968, 6, 18, 1,  0, 0}, // #1166
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #1167
  {DBGFIELD("VCVTSD2SSZrm_VCVTSD2SSZrm_Int_VCVTSD2SSZrm_Intk_VCVTSD2SSZrm_Intkz") 3, false, false, 3037, 8, 18, 1,  9, 1}, // #1168
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 2, false, false, 2946, 4,  5, 1,  0, 0}, // #1169
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, 3087, 5,  7, 1,  0, 0}, // #1170
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 1, false, false, 3087, 5,  7, 1,  0, 0}, // #1171
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 1, false, false, 3087, 5,  7, 1,  0, 0}, // #1172
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #1173
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 3, false, false, 3065, 8, 18, 1,  9, 1}, // #1174
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 3, false, false, 3065, 8, 18, 1,  9, 1}, // #1175
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 2, false, false, 2968, 6, 18, 1,  0, 0}, // #1176
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #1177
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #1178
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 3, false, false, 3037, 8, 26, 1,  0, 0}, // #1179
  {DBGFIELD("VCVTPD2PSZrm_VCVTPD2PSZrmb_VCVTPD2PSZrmbk_VCVTPD2PSZrmbkz_VCVTPD2PSZrmk_VCVTPD2PSZrmkz") 3, false, false, 3037, 8, 26, 1,  0, 0}, // #1180
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 2, false, false, 2968, 6, 18, 1,  0, 0}, // #1181
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 2, false, false, 2944, 6, 10, 1,  9, 1}, // #1182
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 2, false, false, 2946, 4,  5, 1,  0, 0}, // #1183
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 2, false, false, 3052, 6, 26, 1,  9, 1}, // #1184
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 2, false, false, 3052, 6, 19, 1,  9, 1}, // #1185
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 2, false, false, 3052, 6, 19, 1,  9, 1}, // #1186
  {DBGFIELD("VGATHERDPSZ128rm_VGATHERQPSZrm_VPGATHERDDZ128rm") 1, false, false, 2958, 2,  7, 1,  0, 0}, // #1187
  {DBGFIELD("VGATHERQPSZ128rm_VGATHERQPSZ256rm_VPGATHERQDZ128rm_VPGATHERQDZ256rm") 1, false, false, 2958, 2,  7, 1,  0, 0}, // #1188
  {DBGFIELD("VGATHERDPDZ128rm_VGATHERQPDZ128rm_VPGATHERDQZ128rm_VPGATHERQQZ128rm") 1, false, false, 2958, 2,  7, 1,  0, 0}, // #1189
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz") 1, false, false, 1604, 3,  1, 1,  0, 0}, // #1190
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 1, false, false, 1604, 3,  1, 1,  0, 0}, // #1191
  {DBGFIELD("VGATHERDPDZ256rm_VGATHERQPDZ256rm_VPGATHERDQZ256rm_VPGATHERQDZrm_VPGATHERQQZ256rm") 1, false, false, 2958, 2,  7, 1,  0, 0}, // #1192
  {DBGFIELD("VGATHERDPDZrm_VGATHERQPDZrm_VPGATHERDQZrm_VPGATHERQQZrm") 1, false, false, 2958, 2,  7, 1,  0, 0}, // #1193
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm") 1, false, false, 2958, 2,  7, 1,  0, 0}, // #1194
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 2, false, false, 2946, 4, 10, 1,  0, 0}, // #1195
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 1, false, false, 2958, 2,  7, 1,  0, 0}, // #1196
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz") 1, false, false, 1604, 3,  1, 1,  0, 0}, // #1197
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 1, false, false, 1604, 3,  1, 1,  0, 0}, // #1198
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 2, false, false, 2946, 4, 10, 1,  0, 0}, // #1199
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 2, false, false, 2946, 4, 10, 1,  0, 0}, // #1200
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz") 1, false, false, 1604, 3,  1, 1,  0, 0}, // #1201
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 2, false, false, 2946, 4, 10, 1,  0, 0}, // #1202
  {DBGFIELD("JWriteZeroLatency")  0, false, false,  0, 0,  0, 0,  0, 0}, // #1203
  {DBGFIELD("WriteVecALU")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1204
  {DBGFIELD("WriteVecALUX")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1205
  {DBGFIELD("WriteALU")           0, false, false,  0, 0,  0, 0,  0, 0}, // #1206
  {DBGFIELD("WriteFLogic")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1207
  {DBGFIELD("WriteVecLogic")      0, false, false,  0, 0,  0, 0,  0, 0}, // #1208
  {DBGFIELD("WriteVecLogicX")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1209
  {DBGFIELD("JWrite3OpsLEA")      0, false, false,  0, 0,  0, 0,  0, 0}, // #1210
  {DBGFIELD("WriteLEA")           0, false, false,  0, 0,  0, 0,  0, 0}, // #1211
}; // SandyBridgeModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc HaswellModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  16383, false, false,  0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteZero")          1, false, false,  0, 0,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteVecALU")        1, false, false, 77, 4,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteALULd_WriteRMW") 3, false, false, 81, 6, 63, 2,  0, 0}, // #3
  {DBGFIELD("WriteJumpLd")        2, false, false, 87, 6,  6, 1,  0, 0}, // #4
  {DBGFIELD("WriteALU")           1, false, false, 79, 2,  1, 1,  0, 0}, // #5
  {DBGFIELD("WriteMove")          1, false, false, 79, 2,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteJump")          1, false, false, 93, 4,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, 79, 2,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteFStoreX")       2, false, false, 97, 4,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteFLoadX")        1, false, false, 101, 3,  6, 1,  0, 0}, // #10
  {DBGFIELD("WriteFStoreY")       2, false, false, 97, 4,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteFLoadY")        1, false, false, 101, 3,  5, 1,  0, 0}, // #12
  {DBGFIELD("WriteMicrocoded")    1, false, false, 79, 2,  4, 1,  0, 0}, // #13
  {DBGFIELD("WriteFSign")         1, false, false, 237, 9,  1, 1,  0, 0}, // #14
  {DBGFIELD("WriteADC")           2, false, false, 220, 4, 20, 1,  0, 0}, // #15
  {DBGFIELD("WriteADCRMW")        6, false, false, 112, 8,  9, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCLd_ReadAfterLd") 3, false, false, 214, 6,  5, 1,  9, 1}, // #17
  {DBGFIELD("WriteALURMW")        3, false, false, 81, 6,  5, 1,  0, 0}, // #18
  {DBGFIELD("WriteALULd_ReadAfterLd") 2, false, false, 120, 4,  6, 1,  9, 1}, // #19
  {DBGFIELD("WriteFAdd64XLd_ReadAfterLd") 2, false, false, 124, 9,  9, 1,  9, 1}, // #20
  {DBGFIELD("WriteFAdd64X")       1, false, false, 133, 7, 21, 1,  0, 0}, // #21
  {DBGFIELD("WriteFAddXLd_ReadAfterLd") 2, false, false, 124, 9,  9, 1,  9, 1}, // #22
  {DBGFIELD("WriteFAddX")         1, false, false, 133, 7, 21, 1,  0, 0}, // #23
  {DBGFIELD("WriteFAdd64Ld_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #24
  {DBGFIELD("WriteFAdd64")        1, false, false, 133, 7, 21, 1,  0, 0}, // #25
  {DBGFIELD("WriteFAddLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #26
  {DBGFIELD("WriteFAdd")          1, false, false, 133, 7, 21, 1,  0, 0}, // #27
  {DBGFIELD("WriteFAddLd")        2, false, false, 124, 9, 10, 1,  0, 0}, // #28
  {DBGFIELD("WriteAESDecEncLd_ReadAfterLd") 2, false, false, 140, 10, 27, 1,  9, 1}, // #29
  {DBGFIELD("WriteAESDecEnc")     1, false, false, 104, 8,  5, 1,  0, 0}, // #30
  {DBGFIELD("WriteAESIMCLd")      3, false, false, 150, 10, 30, 1,  0, 0}, // #31
  {DBGFIELD("WriteAESIMC")        2, false, false, 160, 8, 25, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESKeyGenLd")   11, false, false, 168, 14, 16, 1,  0, 0}, // #33
  {DBGFIELD("WriteAESKeyGen")     11, false, false, 182, 12, 36, 1,  0, 0}, // #34
  {DBGFIELD("WriteFLogicLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1,  9, 1}, // #35
  {DBGFIELD("WriteFLogic")        1, false, false, 104, 8,  1, 1,  0, 0}, // #36
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 194, 8,  5, 1, 10, 1}, // #37
  {DBGFIELD("WriteBEXTR")         2, false, false, 202, 6, 20, 1,  0, 0}, // #38
  {DBGFIELD("WriteBEXTRLd")       3, false, false, 194, 8,  5, 1,  0, 0}, // #39
  {DBGFIELD("WriteALULd")         2, false, false, 120, 4,  6, 1,  0, 0}, // #40
  {DBGFIELD("WriteFBlendLd_ReadAfterLd") 2, false, false, 128, 5,  5, 1,  9, 1}, // #41
  {DBGFIELD("WriteFBlend")        1, false, false, 78, 3,  1, 1,  0, 0}, // #42
  {DBGFIELD("WriteFVarBlendLd_ReadAfterLd") 3, false, false, 150, 10, 10, 1,  9, 1}, // #43
  {DBGFIELD("WriteFVarBlend")     2, false, false, 160, 8, 20, 1,  0, 0}, // #44
  {DBGFIELD("WriteBSFLd")         2, false, false, 124, 9, 10, 1,  0, 0}, // #45
  {DBGFIELD("WriteBSF")           1, false, false, 133, 7, 21, 1,  0, 0}, // #46
  {DBGFIELD("WriteBSRLd")         2, false, false, 124, 9, 10, 1,  0, 0}, // #47
  {DBGFIELD("WriteBSR")           1, false, false, 133, 7, 21, 1,  0, 0}, // #48
  {DBGFIELD("WriteBSWAP32")       1, false, false, 77, 4,  1, 1,  0, 0}, // #49
  {DBGFIELD("WriteBSWAP64")       2, false, false, 202, 6, 20, 1,  0, 0}, // #50
  {DBGFIELD("WriteBitTest")       1, false, false, 93, 4,  1, 1,  0, 0}, // #51
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 208, 6,  6, 1, 10, 1}, // #52
  {DBGFIELD("WriteBZHI")          1, false, false, 77, 4,  1, 1,  0, 0}, // #53
  {DBGFIELD("WriteLoad")          1, false, false, 101, 3,  7, 1,  0, 0}, // #54
  {DBGFIELD("WriteCMOV2Ld_ReadAfterLd") 4, false, false, 3508, 6, 10, 1,  9, 1}, // #55
  {DBGFIELD("WriteCMOV2")         3, false, false, 1293, 4, 21, 1,  0, 0}, // #56
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 3, false, false, 214, 6,  5, 1,  9, 1}, // #57
  {DBGFIELD("WriteCMOV")          2, false, false, 220, 4, 20, 1,  0, 0}, // #58
  {DBGFIELD("WriteFCMOV")         1, false, false, 133, 7, 21, 1,  0, 0}, // #59
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 120, 4,  6, 1, 10, 1}, // #60
  {DBGFIELD("WriteFCmp64XLd_ReadAfterLd") 2, false, false, 124, 9,  9, 1,  9, 1}, // #61
  {DBGFIELD("WriteFCmp64X")       1, false, false, 133, 7, 21, 1,  0, 0}, // #62
  {DBGFIELD("WriteFCmpXLd_ReadAfterLd") 2, false, false, 124, 9,  9, 1,  9, 1}, // #63
  {DBGFIELD("WriteFCmpX")         1, false, false, 133, 7, 21, 1,  0, 0}, // #64
  {DBGFIELD("WriteFCmp64Ld_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #65
  {DBGFIELD("WriteFCmp64")        1, false, false, 133, 7, 21, 1,  0, 0}, // #66
  {DBGFIELD("WriteFCmpLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #67
  {DBGFIELD("WriteFCmp")          1, false, false, 133, 7, 21, 1,  0, 0}, // #68
  {DBGFIELD("WriteFComLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #69
  {DBGFIELD("WriteFCom")          1, false, false, 133, 7, 21, 1,  0, 0}, // #70
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #71
  {DBGFIELD("WriteCRC32")         1, false, false, 133, 7, 21, 1,  0, 0}, // #72
  {DBGFIELD("WriteNop")           1, false, false,  0, 0,  1, 1,  0, 0}, // #73
  {DBGFIELD("WriteCvtI2PDLd")     2, false, false, 124, 9,  9, 1,  0, 0}, // #74
  {DBGFIELD("WriteCvtI2PD")       1, false, false, 133, 7, 22, 1,  0, 0}, // #75
  {DBGFIELD("WriteCvtI2PSLd")     2, false, false, 124, 9,  9, 1,  0, 0}, // #76
  {DBGFIELD("WriteCvtI2PS")       1, false, false, 133, 7, 22, 1,  0, 0}, // #77
  {DBGFIELD("WriteCvtPD2ILd")     2, false, false, 124, 9, 10, 1,  0, 0}, // #78
  {DBGFIELD("WriteCvtPD2I")       1, false, false, 133, 7, 21, 1,  0, 0}, // #79
  {DBGFIELD("WriteCvtPD2PSLd")    2, false, false, 124, 9, 10, 1,  0, 0}, // #80
  {DBGFIELD("WriteCvtPD2PS")      1, false, false, 133, 7, 21, 1,  0, 0}, // #81
  {DBGFIELD("WriteCvtPS2ILd")     2, false, false, 124, 9, 10, 1,  0, 0}, // #82
  {DBGFIELD("WriteCvtPS2I")       1, false, false, 133, 7, 21, 1,  0, 0}, // #83
  {DBGFIELD("WriteCvtPS2PDLd")    2, false, false, 124, 9, 10, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtPS2PD")      1, false, false, 133, 7, 21, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtSD2ILd")     2, false, false, 124, 9, 10, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtSD2I")       1, false, false, 133, 7, 21, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtSD2SSLd")    2, false, false, 124, 9, 10, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #89
  {DBGFIELD("WriteCvtSD2SS")      1, false, false, 133, 7, 21, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, 124, 9,  9, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterLd") 2, false, false, 124, 9,  9, 1,  9, 1}, // #92
  {DBGFIELD("WriteCvtI2SD")       1, false, false, 133, 7, 22, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtI2SSLd")     2, false, false, 124, 9,  9, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterLd") 2, false, false, 124, 9,  9, 1,  9, 1}, // #95
  {DBGFIELD("WriteCvtI2SS")       1, false, false, 133, 7, 22, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtSS2SDLd")    2, false, false, 124, 9, 10, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #98
  {DBGFIELD("WriteCvtSS2SD")      1, false, false, 133, 7, 21, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtSS2ILd")     2, false, false, 124, 9, 10, 1,  0, 0}, // #100
  {DBGFIELD("WriteCvtSS2I")       1, false, false, 133, 7, 21, 1,  0, 0}, // #101
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 36, 1, 11, 2}, // #102
  {DBGFIELD("WriteDiv16")         1, false, false, 236, 10, 34, 1,  0, 0}, // #103
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 36, 1, 11, 2}, // #104
  {DBGFIELD("WriteDiv32")         1, false, false, 236, 10, 34, 1,  0, 0}, // #105
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 36, 1, 11, 2}, // #106
  {DBGFIELD("WriteDiv64")         1, false, false, 236, 10, 34, 1,  0, 0}, // #107
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 36, 1, 11, 2}, // #108
  {DBGFIELD("WriteDiv8")          1, false, false, 236, 10, 34, 1,  0, 0}, // #109
  {DBGFIELD("WriteFDiv64XLd_ReadAfterLd") 2, false, false, 655, 12, 35, 1,  9, 1}, // #110
  {DBGFIELD("WriteFDiv64X")       1, false, false, 667, 10, 30, 1,  0, 0}, // #111
  {DBGFIELD("WriteFDivXLd_ReadAfterLd") 2, false, false, 677, 12, 65, 1,  9, 1}, // #112
  {DBGFIELD("WriteFDivX")         1, false, false, 689, 10, 27, 1,  0, 0}, // #113
  {DBGFIELD("WriteFDivLd")        2, false, false, 677, 12, 29, 1,  0, 0}, // #114
  {DBGFIELD("WriteFDiv")          1, false, false, 689, 10, 27, 1,  0, 0}, // #115
  {DBGFIELD("WriteFDiv64Ld_ReadAfterLd") 2, false, false, 655, 12, 34, 1,  9, 1}, // #116
  {DBGFIELD("WriteFDiv64")        1, false, false, 667, 10, 30, 1,  0, 0}, // #117
  {DBGFIELD("WriteFDivLd_ReadAfterLd") 2, false, false, 677, 12, 29, 1,  9, 1}, // #118
  {DBGFIELD("WriteDPPDLd_ReadAfterLd") 4, false, false, 310, 16, 24, 1,  9, 1}, // #119
  {DBGFIELD("WriteDPPD")          3, false, false, 326, 14,  9, 1,  0, 0}, // #120
  {DBGFIELD("WriteDPPSLd_ReadAfterLd") 5, false, false, 340, 16, 30, 1,  9, 1}, // #121
  {DBGFIELD("WriteDPPS")          4, false, false, 356, 14, 25, 1,  0, 0}, // #122
  {DBGFIELD("WriteVecExtractSt")  3, false, false, 370, 11, 20, 1,  0, 0}, // #123
  {DBGFIELD("WriteVecExtract")    2, false, false, 381, 12, 20, 1,  0, 0}, // #124
  {DBGFIELD("WriteVecALUX")       1, false, false, 77, 4,  1, 1,  0, 0}, // #125
  {DBGFIELD("WriteFComLd")        2, false, false, 124, 9, 10, 1,  0, 0}, // #126
  {DBGFIELD("WriteEMMS")          31, false, false, 393, 5, 67, 1,  0, 0}, // #127
  {DBGFIELD("WriteFLDC")          2, false, false, 398, 4,  1, 1,  0, 0}, // #128
  {DBGFIELD("WriteVecALUXLd_ReadAfterLd") 2, false, false, 208, 6,  5, 1,  9, 1}, // #129
  {DBGFIELD("WriteFHAddLd_ReadAfterLd") 4, false, false, 402, 13, 26, 1,  9, 1}, // #130
  {DBGFIELD("WriteFHAdd")         3, false, false, 415, 11,  7, 1,  0, 0}, // #131
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 36, 1, 11, 2}, // #132
  {DBGFIELD("WriteIDiv16")        1, false, false, 236, 10, 34, 1,  0, 0}, // #133
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 36, 1, 11, 2}, // #134
  {DBGFIELD("WriteIDiv32")        1, false, false, 236, 10, 34, 1,  0, 0}, // #135
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 36, 1, 11, 2}, // #136
  {DBGFIELD("WriteIDiv64")        1, false, false, 236, 10, 34, 1,  0, 0}, // #137
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 224, 12, 36, 1, 11, 2}, // #138
  {DBGFIELD("WriteIDiv8")         1, false, false, 236, 10, 34, 1,  0, 0}, // #139
  {DBGFIELD("WriteIMulLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1, 11, 2}, // #140
  {DBGFIELD("WriteIMul")          1, false, false, 133, 7, 21, 1,  0, 0}, // #141
  {DBGFIELD("WriteIMulLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #142
  {DBGFIELD("WriteIMulLd")        2, false, false, 124, 9, 10, 1,  0, 0}, // #143
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 124, 9, 10, 1, 11, 2}, // #144
  {DBGFIELD("WriteIMul64")        1, false, false, 133, 7, 21, 1,  0, 0}, // #145
  {DBGFIELD("WriteIMul64Ld_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #146
  {DBGFIELD("WriteIMul64Ld")      2, false, false, 124, 9, 10, 1,  0, 0}, // #147
  {DBGFIELD("WriteFShuffleLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1,  9, 1}, // #148
  {DBGFIELD("WriteFShuffle")      1, false, false, 104, 8,  1, 1,  0, 0}, // #149
  {DBGFIELD("WriteStore")         1, false, false, 97, 4,  1, 1,  0, 0}, // #150
  {DBGFIELD("WriteVecLogicX")     1, false, false, 78, 3,  1, 1,  0, 0}, // #151
  {DBGFIELD("WriteShuffle")       1, false, false, 104, 8,  1, 1,  0, 0}, // #152
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, 93, 4,  1, 1,  0, 0}, // #153
  {DBGFIELD("WriteVecLoadX")      1, false, false, 101, 3,  6, 1,  0, 0}, // #154
  {DBGFIELD("WriteLDMXCSR")       3, false, false, 426, 11,  5, 1,  0, 0}, // #155
  {DBGFIELD("WriteFLD0")          1, false, false, 437, 4,  1, 1,  0, 0}, // #156
  {DBGFIELD("WriteFLD1")          2, false, false, 398, 4,  1, 1,  0, 0}, // #157
  {DBGFIELD("WriteLEA")           1, false, false, 77, 4,  1, 1,  0, 0}, // #158
  {DBGFIELD("WriteFence")         1, false, false, 441, 5,  1, 1,  0, 0}, // #159
  {DBGFIELD("WriteLZCNTLd")       2, false, false, 124, 9, 10, 1,  0, 0}, // #160
  {DBGFIELD("WriteLZCNT")         1, false, false, 133, 7, 21, 1,  0, 0}, // #161
  {DBGFIELD("WriteVecStoreX")     2, false, false, 97, 4,  1, 1,  0, 0}, // #162
  {DBGFIELD("WriteVecStore")      2, false, false, 97, 4,  1, 1,  0, 0}, // #163
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, 237, 9,  1, 1,  0, 0}, // #164
  {DBGFIELD("WriteVecLoad")       1, false, false, 101, 3,  7, 1,  0, 0}, // #165
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, 104, 8,  1, 1,  0, 0}, // #166
  {DBGFIELD("WriteVecMoveX")      1, false, false, 78, 3,  1, 1,  0, 0}, // #167
  {DBGFIELD("WriteVecStoreNT")    2, false, false, 97, 4,  1, 1,  0, 0}, // #168
  {DBGFIELD("WriteVecMove")       1, false, false, 78, 3,  1, 1,  0, 0}, // #169
  {DBGFIELD("WriteVecALULd")      2, false, false, 208, 6,  6, 1,  0, 0}, // #170
  {DBGFIELD("WriteShuffleLd_ReadAfterLd") 2, false, false, 140, 10,  6, 1,  9, 1}, // #171
  {DBGFIELD("WriteVecALULd_ReadAfterLd") 2, false, false, 208, 6,  6, 1,  9, 1}, // #172
  {DBGFIELD("WriteVecLogicLd_ReadAfterLd") 2, false, false, 128, 5,  6, 1,  9, 1}, // #173
  {DBGFIELD("WriteVecLogic")      1, false, false, 78, 3,  1, 1,  0, 0}, // #174
  {DBGFIELD("WritePHAddLd_ReadAfterLd") 4, false, false, 446, 10, 10, 1,  9, 1}, // #175
  {DBGFIELD("WritePHAdd")         3, false, false, 456, 8, 21, 1,  0, 0}, // #176
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 2, false, false, 140, 10,  6, 1,  9, 1}, // #177
  {DBGFIELD("WriteVecInsert")     2, false, false, 160, 8, 20, 1,  0, 0}, // #178
  {DBGFIELD("WriteVecIMulLd_ReadAfterLd") 2, false, false, 225, 11, 18, 1,  9, 1}, // #179
  {DBGFIELD("WriteVecIMul")       1, false, false, 237, 9,  7, 1,  0, 0}, // #180
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, 237, 9,  1, 1,  0, 0}, // #181
  {DBGFIELD("WritePSADBWLd_ReadAfterLd") 2, false, false, 225, 11, 18, 1,  9, 1}, // #182
  {DBGFIELD("WritePSADBW")        1, false, false, 237, 9,  7, 1,  0, 0}, // #183
  {DBGFIELD("WriteVarShuffleLd_ReadAfterLd") 2, false, false, 140, 10,  6, 1,  9, 1}, // #184
  {DBGFIELD("WriteVarShuffle")    1, false, false, 104, 8,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteShuffleLd")     2, false, false, 140, 10,  6, 1,  0, 0}, // #186
  {DBGFIELD("WriteVecShiftImm")   1, false, false, 237, 9,  1, 1,  0, 0}, // #187
  {DBGFIELD("WriteVecShiftLd_ReadAfterLd") 2, false, false, 225, 11,  6, 1,  9, 1}, // #188
  {DBGFIELD("WriteVecShift")      1, false, false, 237, 9,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteFMoveX")        1, false, false, 104, 8,  1, 1,  0, 0}, // #190
  {DBGFIELD("WriteFShuffleLd")    2, false, false, 140, 10,  5, 1,  0, 0}, // #191
  {DBGFIELD("WriteFStore")        2, false, false, 97, 4,  1, 1,  0, 0}, // #192
  {DBGFIELD("WriteFMOVMSK")       1, false, false, 237, 9, 21, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecLoadNT")     1, false, false, 101, 3,  6, 1,  0, 0}, // #194
  {DBGFIELD("WriteStoreNT")       2, false, false, 97, 4,  1, 1,  0, 0}, // #195
  {DBGFIELD("WriteFStoreNTX")     2, false, false, 97, 4,  1, 1,  0, 0}, // #196
  {DBGFIELD("WriteFStoreNT")      2, false, false, 97, 4,  1, 1,  0, 0}, // #197
  {DBGFIELD("WriteFLoad")         1, false, false, 101, 3,  7, 1,  0, 0}, // #198
  {DBGFIELD("WriteMPSADLd_ReadAfterLd") 4, false, false, 464, 14, 27, 1,  9, 1}, // #199
  {DBGFIELD("WriteMPSAD")         3, false, false, 478, 12,  5, 1,  0, 0}, // #200
  {DBGFIELD("WriteFMul64XLd_ReadAfterLd") 2, false, false, 490, 6, 26, 1,  9, 1}, // #201
  {DBGFIELD("WriteFMul64X")       1, false, false, 437, 4,  7, 1,  0, 0}, // #202
  {DBGFIELD("WriteFMulXLd_ReadAfterLd") 2, false, false, 490, 6, 26, 1,  9, 1}, // #203
  {DBGFIELD("WriteFMulX")         1, false, false, 437, 4,  7, 1,  0, 0}, // #204
  {DBGFIELD("WriteFMul64Ld_ReadAfterLd") 2, false, false, 490, 6, 18, 1,  9, 1}, // #205
  {DBGFIELD("WriteFMul64")        1, false, false, 437, 4,  7, 1,  0, 0}, // #206
  {DBGFIELD("WriteFMulLd_ReadAfterLd") 2, false, false, 490, 6, 18, 1,  9, 1}, // #207
  {DBGFIELD("WriteFMul")          1, false, false, 437, 4,  7, 1,  0, 0}, // #208
  {DBGFIELD("WriteIMulLd_WriteIMulH") 3, false, false, 124, 9, 68, 2,  0, 0}, // #209
  {DBGFIELD("WriteIMul_WriteIMulH") 2, false, false, 133, 7, 69, 2,  0, 0}, // #210
  {DBGFIELD("WriteIMul64Ld_WriteIMulH") 3, false, false, 124, 9, 68, 2,  0, 0}, // #211
  {DBGFIELD("WriteIMul64_WriteIMulH") 2, false, false, 133, 7, 69, 2,  0, 0}, // #212
  {DBGFIELD("WriteFMulLd")        2, false, false, 490, 6, 18, 1,  0, 0}, // #213
  {DBGFIELD("WriteVecALUXLd")     2, false, false, 208, 6,  5, 1,  0, 0}, // #214
  {DBGFIELD("WriteShuffleXLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1,  9, 1}, // #215
  {DBGFIELD("WriteShuffleX")      1, false, false, 104, 8,  1, 1,  0, 0}, // #216
  {DBGFIELD("WriteVecLogicXLd_ReadAfterLd") 2, false, false, 128, 5,  5, 1,  9, 1}, // #217
  {DBGFIELD("WriteVarBlendLd_ReadAfterLd") 3, false, false, 150, 10, 10, 1,  9, 1}, // #218
  {DBGFIELD("WriteVarBlend")      2, false, false, 160, 8, 20, 1,  0, 0}, // #219
  {DBGFIELD("WriteBlendLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1,  9, 1}, // #220
  {DBGFIELD("WriteBlend")         1, false, false, 104, 8,  1, 1,  0, 0}, // #221
  {DBGFIELD("WriteCLMulLd_ReadAfterLd") 4, false, false, 786, 14, 28, 1,  9, 1}, // #222
  {DBGFIELD("WriteCLMul")         3, false, false, 800, 12, 26, 1,  0, 0}, // #223
  {DBGFIELD("WritePCmpEStrILd_ReadAfterLd") 9, false, false, 496, 14, 72, 1,  9, 1}, // #224
  {DBGFIELD("WritePCmpEStrI")     8, false, false, 510, 12, 29, 1,  0, 0}, // #225
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterLd") 10, false, false, 522, 14, 34, 1,  9, 1}, // #226
  {DBGFIELD("WritePCmpEStrM")     9, false, false, 536, 12, 65, 1,  0, 0}, // #227
  {DBGFIELD("WritePCmpIStrILd_ReadAfterLd") 4, false, false, 548, 11, 28, 1,  9, 1}, // #228
  {DBGFIELD("WritePCmpIStrI")     3, false, false, 559, 9, 26, 1,  0, 0}, // #229
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterLd") 4, false, false, 548, 11, 28, 1,  9, 1}, // #230
  {DBGFIELD("WritePCmpIStrM")     3, false, false, 559, 9, 26, 1,  0, 0}, // #231
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #232
  {DBGFIELD("WritePHAddXLd_ReadAfterLd") 4, false, false, 446, 10,  9, 1,  9, 1}, // #233
  {DBGFIELD("WritePHAddX")        3, false, false, 456, 8, 21, 1,  0, 0}, // #234
  {DBGFIELD("WritePHMINPOSLd")    2, false, false, 225, 11, 26, 1,  0, 0}, // #235
  {DBGFIELD("WritePHMINPOS")      1, false, false, 237, 9,  7, 1,  0, 0}, // #236
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterLd") 2, false, false, 124, 9,  9, 1,  9, 1}, // #237
  {DBGFIELD("WriteVecIMulXLd_ReadAfterLd") 2, false, false, 225, 11, 26, 1,  9, 1}, // #238
  {DBGFIELD("WriteVecIMulX")      1, false, false, 237, 9,  7, 1,  0, 0}, // #239
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, 237, 9, 21, 1,  0, 0}, // #240
  {DBGFIELD("WriteShuffleXLd")    2, false, false, 140, 10,  5, 1,  0, 0}, // #241
  {DBGFIELD("WritePMULLDLd_ReadAfterLd") 3, false, false, 568, 11,  8, 1,  9, 1}, // #242
  {DBGFIELD("WritePMULLD")        2, false, false, 579, 9, 18, 1,  0, 0}, // #243
  {DBGFIELD("WriteRMW")           1, false, false, 97, 4,  1, 1,  0, 0}, // #244
  {DBGFIELD("WritePOPCNTLd")      2, false, false, 124, 9, 10, 1,  0, 0}, // #245
  {DBGFIELD("WritePOPCNT")        1, false, false, 133, 7, 21, 1,  0, 0}, // #246
  {DBGFIELD("WritePSADBWXLd_ReadAfterLd") 2, false, false, 225, 11, 26, 1,  9, 1}, // #247
  {DBGFIELD("WritePSADBWX")       1, false, false, 237, 9,  7, 1,  0, 0}, // #248
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1,  9, 1}, // #249
  {DBGFIELD("WriteVarShuffleX")   1, false, false, 104, 8,  1, 1,  0, 0}, // #250
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, 237, 9,  1, 1,  0, 0}, // #251
  {DBGFIELD("WriteVecShiftXLd_ReadAfterLd") 3, false, false, 588, 14, 10, 1,  9, 1}, // #252
  {DBGFIELD("WriteVecShiftX")     2, false, false, 381, 12, 20, 1,  0, 0}, // #253
  {DBGFIELD("WriteVecTestLd_ReadAfterLd") 3, false, false, 588, 14, 10, 1,  9, 1}, // #254
  {DBGFIELD("WriteVecTest")       2, false, false, 381, 12, 20, 1,  0, 0}, // #255
  {DBGFIELD("WriteShiftLd_WriteRMW") 3, false, false, 602, 8, 63, 2,  0, 0}, // #256
  {DBGFIELD("WriteShift")         1, false, false, 93, 4,  1, 1,  0, 0}, // #257
  {DBGFIELD("WriteFRcpXLd")       2, false, false, 225, 11, 26, 1,  0, 0}, // #258
  {DBGFIELD("WriteFRcpX")         1, false, false, 237, 9,  7, 1,  0, 0}, // #259
  {DBGFIELD("WriteFRcpLd_ReadAfterLd") 2, false, false, 225, 11, 18, 1,  9, 1}, // #260
  {DBGFIELD("WriteFRcp")          1, false, false, 237, 9,  7, 1,  0, 0}, // #261
  {DBGFIELD("WriteShiftLd")       2, false, false, 87, 6,  6, 1,  0, 0}, // #262
  {DBGFIELD("WriteFRndLd")        3, false, false, 610, 9, 19, 1,  0, 0}, // #263
  {DBGFIELD("WriteFRnd")          1, false, false, 101, 3,  6, 1,  0, 0}, // #264
  {DBGFIELD("WriteFRndLd_ReadAfterLd") 3, false, false, 610, 9, 19, 1,  9, 1}, // #265
  {DBGFIELD("WriteFRsqrtXLd")     2, false, false, 225, 11, 26, 1,  0, 0}, // #266
  {DBGFIELD("WriteFRsqrtX")       1, false, false, 237, 9,  7, 1,  0, 0}, // #267
  {DBGFIELD("WriteFRsqrtLd_ReadAfterLd") 2, false, false, 225, 11, 18, 1,  9, 1}, // #268
  {DBGFIELD("WriteFRsqrt")        1, false, false, 237, 9,  7, 1,  0, 0}, // #269
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 87, 6,  6, 1, 10, 1}, // #270
  {DBGFIELD("WriteSETCCStore")    3, false, false, 619, 7, 20, 1,  0, 0}, // #271
  {DBGFIELD("WriteSETCC")         1, false, false, 93, 4,  1, 1,  0, 0}, // #272
  {DBGFIELD("WriteSHDmrcl")       6, false, false, 626, 11, 19, 1,  0, 0}, // #273
  {DBGFIELD("WriteSHDmri")        4, false, false, 637, 9, 18, 1,  0, 0}, // #274
  {DBGFIELD("WriteSHDrrcl")       4, false, false, 646, 9,  6, 1,  0, 0}, // #275
  {DBGFIELD("WriteSHDrri")        1, false, false, 133, 7, 21, 1,  0, 0}, // #276
  {DBGFIELD("WriteFSqrt64XLd")    2, false, false, 655, 12, 32, 1,  0, 0}, // #277
  {DBGFIELD("WriteFSqrt64X")      1, false, false, 667, 10,  8, 1,  0, 0}, // #278
  {DBGFIELD("WriteFSqrtXLd")      2, false, false, 677, 12, 28, 1,  0, 0}, // #279
  {DBGFIELD("WriteFSqrtX")        1, false, false, 689, 10, 26, 1,  0, 0}, // #280
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterLd") 2, false, false, 655, 12, 31, 1,  9, 1}, // #281
  {DBGFIELD("WriteFSqrt64")       1, false, false, 667, 10,  8, 1,  0, 0}, // #282
  {DBGFIELD("WriteFSqrtLd_ReadAfterLd") 2, false, false, 677, 12,  8, 1,  9, 1}, // #283
  {DBGFIELD("WriteFSqrt")         1, false, false, 689, 10, 26, 1,  0, 0}, // #284
  {DBGFIELD("WriteFSqrt80")       1, false, false, 3514, 10, 33, 1,  0, 0}, // #285
  {DBGFIELD("WriteSTMXCSR")       3, false, false, 370, 11, 20, 1,  0, 0}, // #286
  {DBGFIELD("WriteTZCNTLd")       2, false, false, 124, 9, 10, 1,  0, 0}, // #287
  {DBGFIELD("WriteTZCNT")         1, false, false, 133, 7, 21, 1,  0, 0}, // #288
  {DBGFIELD("WriteFMAZLd")        2, false, false, 490, 6, 19, 1,  0, 0}, // #289
  {DBGFIELD("WriteFMALd")         2, false, false, 490, 6, 18, 1,  0, 0}, // #290
  {DBGFIELD("WriteFAdd64YLd_ReadAfterLd") 2, false, false, 124, 9, 18, 1,  9, 1}, // #291
  {DBGFIELD("WriteFAdd64Y")       1, false, false, 133, 7, 21, 1,  0, 0}, // #292
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterLd") 2, false, false, 124, 9, 18, 1,  9, 1}, // #293
  {DBGFIELD("WriteFAdd64Z")       1, false, false, 133, 7, 21, 1,  0, 0}, // #294
  {DBGFIELD("WriteFAddYLd_ReadAfterLd") 2, false, false, 124, 9, 18, 1,  9, 1}, // #295
  {DBGFIELD("WriteFAddY")         1, false, false, 133, 7, 21, 1,  0, 0}, // #296
  {DBGFIELD("WriteFAddZLd_ReadAfterLd") 2, false, false, 124, 9, 18, 1,  9, 1}, // #297
  {DBGFIELD("WriteFAddZ")         1, false, false, 133, 7, 21, 1,  0, 0}, // #298
  {DBGFIELD("WriteShuffleYLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1,  9, 1}, // #299
  {DBGFIELD("WriteShuffleY")      1, false, false, 104, 8,  1, 1,  0, 0}, // #300
  {DBGFIELD("WriteShuffleZLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1,  9, 1}, // #301
  {DBGFIELD("WriteShuffleZ")      1, false, false, 104, 8,  1, 1,  0, 0}, // #302
  {DBGFIELD("WriteFLogicYLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1,  9, 1}, // #303
  {DBGFIELD("WriteFLogicY")       1, false, false, 104, 8,  1, 1,  0, 0}, // #304
  {DBGFIELD("WriteFLogicZLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1,  9, 1}, // #305
  {DBGFIELD("WriteFLogicZ")       1, false, false, 104, 8,  1, 1,  0, 0}, // #306
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterLd") 3, false, false, 150, 10,  9, 1,  9, 1}, // #307
  {DBGFIELD("WriteFVarBlendY")    2, false, false, 160, 8, 20, 1,  0, 0}, // #308
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterLd") 3, false, false, 150, 10,  9, 1,  9, 1}, // #309
  {DBGFIELD("WriteFVarBlendZ")    2, false, false, 160, 8, 20, 1,  0, 0}, // #310
  {DBGFIELD("WriteFBlendYLd_ReadAfterLd") 2, false, false, 128, 5, 10, 1,  9, 1}, // #311
  {DBGFIELD("WriteFBlendY")       1, false, false, 78, 3,  1, 1,  0, 0}, // #312
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 150, 10,  9, 1, 13, 2}, // #313
  {DBGFIELD("WriteFVarBlendLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 150, 10, 10, 1, 13, 2}, // #314
  {DBGFIELD("WriteShuffle256Ld")  2, false, false, 140, 10, 18, 1,  0, 0}, // #315
  {DBGFIELD("WriteShuffle256")    1, false, false, 104, 8, 21, 1,  0, 0}, // #316
  {DBGFIELD("WriteShuffleYLd")    2, false, false, 140, 10, 10, 1,  0, 0}, // #317
  {DBGFIELD("WriteFShuffle256")   1, false, false, 104, 8, 21, 1,  0, 0}, // #318
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, 140, 10, 18, 1,  0, 0}, // #319
  {DBGFIELD("WriteFCmp64YLd_ReadAfterLd") 2, false, false, 124, 9, 18, 1,  9, 1}, // #320
  {DBGFIELD("WriteFCmp64Y")       1, false, false, 133, 7, 21, 1,  0, 0}, // #321
  {DBGFIELD("WriteFCmpYLd_ReadAfterLd") 2, false, false, 124, 9, 18, 1,  9, 1}, // #322
  {DBGFIELD("WriteFCmpY")         1, false, false, 133, 7, 21, 1,  0, 0}, // #323
  {DBGFIELD("WriteFCmpZLd_ReadAfterLd") 2, false, false, 124, 9, 18, 1,  9, 1}, // #324
  {DBGFIELD("WriteFCmpZ")         1, false, false, 133, 7, 21, 1,  0, 0}, // #325
  {DBGFIELD("WriteVarShuffle256Ld") 2, false, false, 140, 10, 18, 1,  0, 0}, // #326
  {DBGFIELD("WriteVarShuffle256") 1, false, false, 104, 8, 21, 1,  0, 0}, // #327
  {DBGFIELD("WriteCvtI2PDYLd")    2, false, false, 124, 9,  9, 1,  0, 0}, // #328
  {DBGFIELD("WriteCvtI2PDY")      1, false, false, 133, 7, 22, 1,  0, 0}, // #329
  {DBGFIELD("WriteCvtI2PDZLd")    2, false, false, 124, 9,  9, 1,  0, 0}, // #330
  {DBGFIELD("WriteCvtI2PDZ")      1, false, false, 133, 7, 22, 1,  0, 0}, // #331
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, 124, 9,  9, 1,  0, 0}, // #332
  {DBGFIELD("WriteCvtI2PSY")      1, false, false, 133, 7, 22, 1,  0, 0}, // #333
  {DBGFIELD("WriteCvtI2PSZLd")    2, false, false, 124, 9,  9, 1,  0, 0}, // #334
  {DBGFIELD("WriteCvtI2PSZ")      1, false, false, 133, 7, 22, 1,  0, 0}, // #335
  {DBGFIELD("WriteCvtPD2IYLd")    2, false, false, 124, 9, 10, 1,  0, 0}, // #336
  {DBGFIELD("WriteCvtPD2IY")      1, false, false, 133, 7, 21, 1,  0, 0}, // #337
  {DBGFIELD("WriteCvtPD2IZLd")    2, false, false, 124, 9, 10, 1,  0, 0}, // #338
  {DBGFIELD("WriteCvtPD2IZ")      1, false, false, 133, 7, 21, 1,  0, 0}, // #339
  {DBGFIELD("WriteCvtPD2PSYLd")   2, false, false, 124, 9, 10, 1,  0, 0}, // #340
  {DBGFIELD("WriteCvtPD2PSY")     1, false, false, 133, 7, 21, 1,  0, 0}, // #341
  {DBGFIELD("WriteCvtPD2PSZLd")   2, false, false, 124, 9, 10, 1,  0, 0}, // #342
  {DBGFIELD("WriteCvtPD2PSZ")     1, false, false, 133, 7, 21, 1,  0, 0}, // #343
  {DBGFIELD("WriteCvtPH2PSYLd")   2, false, false, 225, 11,  5, 1,  0, 0}, // #344
  {DBGFIELD("WriteCvtPH2PSY")     2, false, false, 381, 12, 20, 1,  0, 0}, // #345
  {DBGFIELD("WriteCvtPH2PSLd")    2, false, false, 225, 11,  6, 1,  0, 0}, // #346
  {DBGFIELD("WriteCvtPH2PS")      2, false, false, 381, 12, 20, 1,  0, 0}, // #347
  {DBGFIELD("WriteCvtPH2PSZLd")   2, false, false, 225, 11,  5, 1,  0, 0}, // #348
  {DBGFIELD("WriteCvtPH2PSZ")     2, false, false, 381, 12, 20, 1,  0, 0}, // #349
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, 124, 9, 10, 1,  0, 0}, // #350
  {DBGFIELD("WriteCvtPS2IY")      1, false, false, 133, 7, 21, 1,  0, 0}, // #351
  {DBGFIELD("WriteCvtPS2IZLd")    2, false, false, 124, 9, 10, 1,  0, 0}, // #352
  {DBGFIELD("WriteCvtPS2IZ")      1, false, false, 133, 7, 21, 1,  0, 0}, // #353
  {DBGFIELD("WriteCvtPS2PDYLd")   2, false, false, 124, 9, 10, 1,  0, 0}, // #354
  {DBGFIELD("WriteCvtPS2PDY")     1, false, false, 133, 7, 21, 1,  0, 0}, // #355
  {DBGFIELD("WriteCvtPS2PDZLd")   2, false, false, 124, 9, 10, 1,  0, 0}, // #356
  {DBGFIELD("WriteCvtPS2PDZ")     1, false, false, 133, 7, 21, 1,  0, 0}, // #357
  {DBGFIELD("WriteCvtPS2PHYSt")   4, false, false, 3524, 14,  5, 1,  0, 0}, // #358
  {DBGFIELD("WriteCvtPS2PHY")     2, false, false, 719, 11,  6, 1,  0, 0}, // #359
  {DBGFIELD("WriteCvtPS2PHSt")    4, false, false, 3524, 14,  7, 1,  0, 0}, // #360
  {DBGFIELD("WriteCvtPS2PH")      2, false, false, 719, 11, 22, 1,  0, 0}, // #361
  {DBGFIELD("WriteCvtPS2PHZSt")   4, false, false, 3524, 14,  5, 1,  0, 0}, // #362
  {DBGFIELD("WriteCvtPS2PHZ")     2, false, false, 719, 11,  6, 1,  0, 0}, // #363
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #364
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterLd") 2, false, false, 124, 9, 10, 1,  9, 1}, // #365
  {DBGFIELD("WritePSADBWYLd_ReadAfterLd") 2, false, false, 225, 11, 19, 1,  9, 1}, // #366
  {DBGFIELD("WritePSADBWY")       1, false, false, 237, 9,  7, 1,  0, 0}, // #367
  {DBGFIELD("WritePSADBWZLd_ReadAfterLd") 2, false, false, 225, 11, 19, 1,  9, 1}, // #368
  {DBGFIELD("WritePSADBWZ")       1, false, false, 237, 9,  7, 1,  0, 0}, // #369
  {DBGFIELD("WriteFDiv64YLd_ReadAfterLd") 4, false, false, 3538, 13, 75, 1,  9, 1}, // #370
  {DBGFIELD("WriteFDiv64Y")       3, false, false, 3551, 11, 73, 1,  0, 0}, // #371
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterLd") 4, false, false, 3538, 13, 75, 1,  9, 1}, // #372
  {DBGFIELD("WriteFDiv64Z")       3, false, false, 3551, 11, 73, 1,  0, 0}, // #373
  {DBGFIELD("WriteFDivYLd_ReadAfterLd") 4, false, false, 3562, 13, 82, 1,  9, 1}, // #374
  {DBGFIELD("WriteFDivY")         3, false, false, 3575, 11, 31, 1,  0, 0}, // #375
  {DBGFIELD("WriteFDivZLd_ReadAfterLd") 4, false, false, 3562, 13, 82, 1,  9, 1}, // #376
  {DBGFIELD("WriteFDivZ")         3, false, false, 3575, 11, 31, 1,  0, 0}, // #377
  {DBGFIELD("WriteDPPSYLd_ReadAfterLd") 5, false, false, 340, 16, 31, 1,  9, 1}, // #378
  {DBGFIELD("WriteDPPSY")         4, false, false, 356, 14, 25, 1,  0, 0}, // #379
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterLd") 2, false, false, 140, 10, 18, 1,  9, 1}, // #380
  {DBGFIELD("WriteFMAYLd_ReadAfterLd_ReadAfterLd") 2, false, false, 490, 6, 19, 1, 15, 2}, // #381
  {DBGFIELD("WriteFMAY")          1, false, false, 437, 4,  7, 1,  0, 0}, // #382
  {DBGFIELD("WriteFMAXLd_ReadAfterLd") 2, false, false, 490, 6, 26, 1,  9, 1}, // #383
  {DBGFIELD("WriteFMAX")          1, false, false, 437, 4,  7, 1,  0, 0}, // #384
  {DBGFIELD("WriteFMAYLd_ReadAfterLd") 2, false, false, 490, 6, 19, 1,  9, 1}, // #385
  {DBGFIELD("WriteFMAZLd_ReadAfterLd") 2, false, false, 490, 6, 19, 1,  9, 1}, // #386
  {DBGFIELD("WriteFMAZ")          1, false, false, 437, 4,  7, 1,  0, 0}, // #387
  {DBGFIELD("WriteFMAXLd_ReadAfterLd_ReadAfterLd") 2, false, false, 490, 6, 26, 1, 15, 2}, // #388
  {DBGFIELD("WriteFMALd_ReadAfterLd") 2, false, false, 490, 6, 18, 1,  9, 1}, // #389
  {DBGFIELD("WriteFMA")           1, false, false, 437, 4,  7, 1,  0, 0}, // #390
  {DBGFIELD("WriteFMALd_ReadAfterLd_ReadAfterLd") 2, false, false, 490, 6, 18, 1, 15, 2}, // #391
  {DBGFIELD("WriteFMAYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 490, 6, 19, 1, 13, 2}, // #392
  {DBGFIELD("WriteFMAXLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 490, 6, 26, 1, 13, 2}, // #393
  {DBGFIELD("WriteFMALd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 490, 6, 18, 1, 13, 2}, // #394
  {DBGFIELD("WriteFRndYLd_ReadAfterLd") 3, false, false, 610, 9, 27, 1,  9, 1}, // #395
  {DBGFIELD("WriteFRndY")         1, false, false, 101, 3,  6, 1,  0, 0}, // #396
  {DBGFIELD("WriteFRndZLd_ReadAfterLd") 3, false, false, 610, 9, 27, 1,  9, 1}, // #397
  {DBGFIELD("WriteFRndZ")         1, false, false, 101, 3,  6, 1,  0, 0}, // #398
  {DBGFIELD("WriteVecIMulYLd_ReadAfterLd") 2, false, false, 225, 11, 19, 1,  9, 1}, // #399
  {DBGFIELD("WriteVecIMulY")      1, false, false, 237, 9,  7, 1,  0, 0}, // #400
  {DBGFIELD("WriteVecIMulZLd_ReadAfterLd") 2, false, false, 225, 11, 19, 1,  9, 1}, // #401
  {DBGFIELD("WriteVecIMulZ")      1, false, false, 237, 9,  7, 1,  0, 0}, // #402
  {DBGFIELD("WriteVecALUYLd_ReadAfterLd") 2, false, false, 208, 6, 10, 1,  9, 1}, // #403
  {DBGFIELD("WriteVecALUY")       1, false, false, 77, 4,  1, 1,  0, 0}, // #404
  {DBGFIELD("WriteVecALUZLd_ReadAfterLd") 2, false, false, 208, 6, 10, 1,  9, 1}, // #405
  {DBGFIELD("WriteVecALUZ")       1, false, false, 77, 4,  1, 1,  0, 0}, // #406
  {DBGFIELD("WriteFHAddYLd_ReadAfterLd") 4, false, false, 402, 13, 19, 1,  9, 1}, // #407
  {DBGFIELD("WriteFHAddY")        3, false, false, 415, 11,  7, 1,  0, 0}, // #408
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterLd") 2, false, false, 140, 10, 18, 1,  9, 1}, // #409
  {DBGFIELD("WriteShuffle256Ld_ReadAfterLd") 2, false, false, 140, 10, 18, 1,  9, 1}, // #410
  {DBGFIELD("WriteVecLoadY")      1, false, false, 101, 3,  5, 1,  0, 0}, // #411
  {DBGFIELD("WriteFMaskedStoreY") 4, false, false, 774, 12,  7, 1,  0, 0}, // #412
  {DBGFIELD("WriteFMaskedLoadY")  3, false, false, 150, 10,  9, 1,  0, 0}, // #413
  {DBGFIELD("WriteFMaskedStore")  4, false, false, 774, 12,  7, 1,  0, 0}, // #414
  {DBGFIELD("WriteFMaskedLoad")   3, false, false, 150, 10, 10, 1,  0, 0}, // #415
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterLd") 2, false, false, 124, 9, 18, 1,  9, 1}, // #416
  {DBGFIELD("WriteFCmp64Z")       1, false, false, 133, 7, 21, 1,  0, 0}, // #417
  {DBGFIELD("WriteFMoveY")        1, false, false, 104, 8,  1, 1,  0, 0}, // #418
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, 140, 10, 10, 1,  0, 0}, // #419
  {DBGFIELD("WriteFShuffleY")     1, false, false, 104, 8,  1, 1,  0, 0}, // #420
  {DBGFIELD("WriteFShuffleZLd")   2, false, false, 140, 10, 10, 1,  0, 0}, // #421
  {DBGFIELD("WriteFShuffleZ")     1, false, false, 104, 8,  1, 1,  0, 0}, // #422
  {DBGFIELD("WriteVecStoreY")     2, false, false, 97, 4,  1, 1,  0, 0}, // #423
  {DBGFIELD("WriteVecMoveY")      1, false, false, 78, 3,  1, 1,  0, 0}, // #424
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, 101, 3,  5, 1,  0, 0}, // #425
  {DBGFIELD("WriteVecStoreNTY")   2, false, false, 97, 4,  1, 1,  0, 0}, // #426
  {DBGFIELD("WriteFStoreNTY")     2, false, false, 97, 4,  1, 1,  0, 0}, // #427
  {DBGFIELD("WriteMPSADYLd_ReadAfterLd") 4, false, false, 464, 14, 25, 1,  9, 1}, // #428
  {DBGFIELD("WriteMPSADY")        3, false, false, 478, 12,  5, 1,  0, 0}, // #429
  {DBGFIELD("WriteFMul64YLd_ReadAfterLd") 2, false, false, 490, 6, 19, 1,  9, 1}, // #430
  {DBGFIELD("WriteFMul64Y")       1, false, false, 437, 4,  7, 1,  0, 0}, // #431
  {DBGFIELD("WriteFMul64ZLd_ReadAfterLd") 2, false, false, 490, 6, 19, 1,  9, 1}, // #432
  {DBGFIELD("WriteFMul64Z")       1, false, false, 437, 4,  7, 1,  0, 0}, // #433
  {DBGFIELD("WriteFMulYLd_ReadAfterLd") 2, false, false, 490, 6, 19, 1,  9, 1}, // #434
  {DBGFIELD("WriteFMulY")         1, false, false, 437, 4,  7, 1,  0, 0}, // #435
  {DBGFIELD("WriteFMulZLd_ReadAfterLd") 2, false, false, 490, 6, 19, 1,  9, 1}, // #436
  {DBGFIELD("WriteFMulZ")         1, false, false, 437, 4,  7, 1,  0, 0}, // #437
  {DBGFIELD("WriteVecALUYLd")     2, false, false, 208, 6, 10, 1,  0, 0}, // #438
  {DBGFIELD("WriteVecALUZLd")     2, false, false, 208, 6, 10, 1,  0, 0}, // #439
  {DBGFIELD("WriteVecLogicYLd_ReadAfterLd") 2, false, false, 128, 5, 10, 1,  9, 1}, // #440
  {DBGFIELD("WriteVecLogicY")     1, false, false, 78, 3,  1, 1,  0, 0}, // #441
  {DBGFIELD("WriteVecLogicZLd_ReadAfterLd") 2, false, false, 128, 5, 10, 1,  9, 1}, // #442
  {DBGFIELD("WriteVecLogicZ")     1, false, false, 78, 3,  1, 1,  0, 0}, // #443
  {DBGFIELD("WriteBlendYLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1,  9, 1}, // #444
  {DBGFIELD("WriteBlendY")        1, false, false, 104, 8,  1, 1,  0, 0}, // #445
  {DBGFIELD("WriteVarBlendYLd_ReadAfterLd") 3, false, false, 150, 10,  9, 1,  9, 1}, // #446
  {DBGFIELD("WriteVarBlendY")     2, false, false, 160, 8, 20, 1,  0, 0}, // #447
  {DBGFIELD("WriteVarBlendZLd_ReadAfterLd") 3, false, false, 150, 10,  9, 1,  9, 1}, // #448
  {DBGFIELD("WriteVarBlendZ")     2, false, false, 160, 8, 20, 1,  0, 0}, // #449
  {DBGFIELD("WriteVarBlendYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 150, 10,  9, 1, 13, 2}, // #450
  {DBGFIELD("WriteVarBlendLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 150, 10, 10, 1, 13, 2}, // #451
  {DBGFIELD("WriteShuffleYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 140, 10, 10, 1, 13, 2}, // #452
  {DBGFIELD("WriteShuffleYLd_ReadAfterLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1, 15, 2}, // #453
  {DBGFIELD("WriteShuffleXLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 140, 10,  5, 1, 13, 2}, // #454
  {DBGFIELD("WriteShuffleXLd_ReadAfterLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1, 15, 2}, // #455
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterLd") 2, false, false, 140, 10, 18, 1,  9, 1}, // #456
  {DBGFIELD("WriteFVarShuffle256") 1, false, false, 104, 8, 21, 1,  0, 0}, // #457
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 140, 10, 10, 1, 13, 2}, // #458
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1, 15, 2}, // #459
  {DBGFIELD("WriteFVarShuffleY")  1, false, false, 104, 8,  1, 1,  0, 0}, // #460
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 140, 10,  5, 1, 13, 2}, // #461
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1, 15, 2}, // #462
  {DBGFIELD("WriteFVarShuffle")   1, false, false, 104, 8,  1, 1,  0, 0}, // #463
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1,  9, 1}, // #464
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1,  9, 1}, // #465
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1,  9, 1}, // #466
  {DBGFIELD("WriteFVarShuffleZ")  1, false, false, 104, 8,  1, 1,  0, 0}, // #467
  {DBGFIELD("WritePHAddYLd_ReadAfterLd") 4, false, false, 446, 10, 18, 1,  9, 1}, // #468
  {DBGFIELD("WritePHAddY")        3, false, false, 456, 8, 21, 1,  0, 0}, // #469
  {DBGFIELD("WriteVecIMulXLd")    2, false, false, 225, 11, 26, 1,  0, 0}, // #470
  {DBGFIELD("WriteVecIMulYLd")    2, false, false, 225, 11, 19, 1,  0, 0}, // #471
  {DBGFIELD("WriteVecIMulZLd")    2, false, false, 225, 11, 19, 1,  0, 0}, // #472
  {DBGFIELD("WriteVecMaskedStoreY") 4, false, false, 774, 12,  7, 1,  0, 0}, // #473
  {DBGFIELD("WriteVecMaskedLoadY") 3, false, false, 150, 10,  9, 1,  0, 0}, // #474
  {DBGFIELD("WriteVecMaskedStore") 4, false, false, 774, 12,  7, 1,  0, 0}, // #475
  {DBGFIELD("WriteVecMaskedLoad") 3, false, false, 150, 10, 10, 1,  0, 0}, // #476
  {DBGFIELD("WriteVecMOVMSKY")    1, false, false, 237, 9, 21, 1,  0, 0}, // #477
  {DBGFIELD("WritePMULLDYLd_ReadAfterLd") 3, false, false, 568, 11, 28, 1,  9, 1}, // #478
  {DBGFIELD("WritePMULLDY")       2, false, false, 579, 9, 18, 1,  0, 0}, // #479
  {DBGFIELD("WritePMULLDZLd_ReadAfterLd") 3, false, false, 568, 11, 28, 1,  9, 1}, // #480
  {DBGFIELD("WritePMULLDZ")       2, false, false, 579, 9, 18, 1,  0, 0}, // #481
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 140, 10,  5, 1, 13, 2}, // #482
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterLd_ReadAfterLd") 2, false, false, 140, 10,  5, 1, 15, 2}, // #483
  {DBGFIELD("WriteVecShiftImmXLd") 2, false, false, 225, 11,  5, 1,  0, 0}, // #484
  {DBGFIELD("WriteVecShiftImmYLd") 2, false, false, 225, 11, 10, 1,  0, 0}, // #485
  {DBGFIELD("WriteVecShiftImmY")  1, false, false, 237, 9,  1, 1,  0, 0}, // #486
  {DBGFIELD("WriteVecShiftImmZLd") 2, false, false, 225, 11, 10, 1,  0, 0}, // #487
  {DBGFIELD("WriteVecShiftImmZ")  1, false, false, 237, 9,  1, 1,  0, 0}, // #488
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterLd") 4, false, false, 786, 14,  9, 1,  9, 1}, // #489
  {DBGFIELD("WriteVarVecShift")   3, false, false, 800, 12, 21, 1,  0, 0}, // #490
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterLd") 4, false, false, 786, 14, 18, 1,  9, 1}, // #491
  {DBGFIELD("WriteVarVecShiftY")  3, false, false, 800, 12, 21, 1,  0, 0}, // #492
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterLd") 4, false, false, 786, 14, 18, 1,  9, 1}, // #493
  {DBGFIELD("WriteVarVecShiftZ")  3, false, false, 800, 12, 21, 1,  0, 0}, // #494
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterLd") 2, false, false, 225, 11,  5, 1,  9, 1}, // #495
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1,  9, 1}, // #496
  {DBGFIELD("WriteVarShuffleY")   1, false, false, 104, 8,  1, 1,  0, 0}, // #497
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1,  9, 1}, // #498
  {DBGFIELD("WriteVarShuffleZ")   1, false, false, 104, 8,  1, 1,  0, 0}, // #499
  {DBGFIELD("WriteShuffleZLd")    2, false, false, 140, 10, 10, 1,  0, 0}, // #500
  {DBGFIELD("WriteVecShiftYLd_ReadAfterLd") 2, false, false, 225, 11, 10, 1,  9, 1}, // #501
  {DBGFIELD("WriteVecShiftY")     2, false, false, 381, 12, 22, 1,  0, 0}, // #502
  {DBGFIELD("WriteVecShiftZLd_ReadAfterLd") 2, false, false, 225, 11, 10, 1,  9, 1}, // #503
  {DBGFIELD("WriteVecShiftZ")     2, false, false, 381, 12, 22, 1,  0, 0}, // #504
  {DBGFIELD("WriteVecTestYLd_ReadAfterLd") 3, false, false, 588, 14, 26, 1,  9, 1}, // #505
  {DBGFIELD("WriteVecTestY")      2, false, false, 381, 12, 22, 1,  0, 0}, // #506
  {DBGFIELD("WriteFRcpXLd_ReadAfterLd") 2, false, false, 225, 11, 26, 1,  9, 1}, // #507
  {DBGFIELD("WriteFRcpYLd_ReadAfterLd") 4, false, false, 731, 11, 29, 1,  9, 1}, // #508
  {DBGFIELD("WriteFRcpY")         3, false, false, 743, 9, 26, 1,  0, 0}, // #509
  {DBGFIELD("WriteFRcpZLd_ReadAfterLd") 4, false, false, 731, 11, 29, 1,  9, 1}, // #510
  {DBGFIELD("WriteFRcpZ")         3, false, false, 743, 9, 26, 1,  0, 0}, // #511
  {DBGFIELD("WriteFRcpYLd")       4, false, false, 731, 11, 29, 1,  0, 0}, // #512
  {DBGFIELD("WriteFRndYLd")       3, false, false, 610, 9, 27, 1,  0, 0}, // #513
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterLd") 2, false, false, 225, 11, 26, 1,  9, 1}, // #514
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterLd") 4, false, false, 731, 11, 29, 1,  9, 1}, // #515
  {DBGFIELD("WriteFRsqrtY")       3, false, false, 743, 9, 26, 1,  0, 0}, // #516
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterLd") 4, false, false, 731, 11, 29, 1,  9, 1}, // #517
  {DBGFIELD("WriteFRsqrtZ")       3, false, false, 743, 9, 26, 1,  0, 0}, // #518
  {DBGFIELD("WriteFRsqrtYLd")     4, false, false, 731, 11, 29, 1,  0, 0}, // #519
  {DBGFIELD("WriteFShuffleYLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1,  9, 1}, // #520
  {DBGFIELD("WriteFShuffleZLd_ReadAfterLd") 2, false, false, 140, 10, 10, 1,  9, 1}, // #521
  {DBGFIELD("WriteFSqrt64YLd")    4, false, false, 3538, 13, 75, 1,  0, 0}, // #522
  {DBGFIELD("WriteFSqrt64Y")      3, false, false, 3551, 11, 73, 1,  0, 0}, // #523
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterLd") 2, false, false, 655, 12, 32, 1,  9, 1}, // #524
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterLd") 4, false, false, 3538, 13, 75, 1,  9, 1}, // #525
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterLd") 4, false, false, 3538, 13, 75, 1,  9, 1}, // #526
  {DBGFIELD("WriteFSqrt64Z")      3, false, false, 3551, 11, 73, 1,  0, 0}, // #527
  {DBGFIELD("WriteFSqrtYLd")      4, false, false, 3562, 13, 82, 1,  0, 0}, // #528
  {DBGFIELD("WriteFSqrtY")        3, false, false, 3575, 11, 31, 1,  0, 0}, // #529
  {DBGFIELD("WriteFSqrtXLd_ReadAfterLd") 2, false, false, 677, 12, 28, 1,  9, 1}, // #530
  {DBGFIELD("WriteFSqrtYLd_ReadAfterLd") 4, false, false, 3562, 13, 82, 1,  9, 1}, // #531
  {DBGFIELD("WriteFSqrtZLd_ReadAfterLd") 4, false, false, 3562, 13, 82, 1,  9, 1}, // #532
  {DBGFIELD("WriteFSqrtZ")        3, false, false, 3575, 11, 31, 1,  0, 0}, // #533
  {DBGFIELD("WriteFTestYLd_ReadAfterLd") 2, false, false, 225, 11, 10, 1,  9, 1}, // #534
  {DBGFIELD("WriteFTestY")        1, false, false, 237, 9,  1, 1,  0, 0}, // #535
  {DBGFIELD("WriteFTestLd_ReadAfterLd") 2, false, false, 225, 11,  5, 1,  9, 1}, // #536
  {DBGFIELD("WriteFTest")         1, false, false, 237, 9,  1, 1,  0, 0}, // #537
  {DBGFIELD("MUL16m_IMUL16m")     5, false, false, 856, 11,  9, 1,  0, 0}, // #538
  {DBGFIELD("MUL32r_IMUL32r")     3, false, false, 867, 9, 22, 1,  0, 0}, // #539
  {DBGFIELD("IMUL64rri8_IMUL64rri32") 1, false, false, 133, 7, 21, 1,  0, 0}, // #540
  {DBGFIELD("IMUL64rmi8_IMUL64rmi32") 2, false, false, 124, 9, 10, 1,  0, 0}, // #541
  {DBGFIELD("COPY")               0, false, false,  0, 0,  0, 0,  0, 0}, // #542
  {DBGFIELD("FXAM")               2, false, false, 3586, 7,  1, 1,  0, 0}, // #543
  {DBGFIELD("LD_Frr")             1, false, false, 437, 4,  1, 1,  0, 0}, // #544
  {DBGFIELD("MOVSX64rr32")        1, false, false, 79, 2,  1, 1,  0, 0}, // #545
  {DBGFIELD("RCL16m1_RCL16mCL_RCL16mi_RCL32m1_RCL32mCL_RCL32mi_RCL64m1_RCL64mCL_RCL64mi_RCL8m1_RCL8mCL_RCL8mi_RCR16m1_RCR16mCL_RCR16mi_RCR32m1_RCR32mCL_RCR32mi_RCR64m1_RCR64mCL_RCR64mi_RCR8m1_RCR8mCL_RCR8mi_ROL16m1_ROL16mCL_ROL16mi_ROL32m1_ROL32mCL_ROL32mi_ROL64m1_ROL64mCL_ROL64mi_ROL8m1_ROL8mCL_ROL8mi_ROR16m1_ROR16mCL_ROR16mi_ROR32m1_ROR32mCL_ROR32mi_ROR64m1_ROR64mCL_ROR64mi_ROR8m1_ROR8mCL_ROR8mi_SAR16m1_SAR16mCL_SAR16mi_SAR32m1_SAR32mCL_SAR32mi_SAR64m1_SAR64mCL_SAR64mi_SAR8m1_SAR8mCL_SAR8mi_SHL16m1_SHL16mCL_SHL16mi_SHL32m1_SHL32mCL_SHL32mi_SHL64m1_SHL64mCL_SHL64mi_SHL8m1_SHL8mCL_SHL8mi_SHR16m1_SHR16mCL_SHR16mi_SHR32m1_SHR32mCL_SHR32mi_SHR64m1_SHR64mCL_SHR64mi_SHR8m1_SHR8mCL_SHR8mi") 11, false, false, 876, 11, 65, 1,  0, 0}, // #546
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, 79, 2,  1, 1,  0, 0}, // #547
  {DBGFIELD("IMUL32rm")           2, false, false, 124, 9, 10, 1,  9, 1}, // #548
  {DBGFIELD("IMUL32rmi_IMUL32rmi8") 2, false, false, 124, 9, 10, 1,  0, 0}, // #549
  {DBGFIELD("IMUL32rr_IMUL32rri_IMUL32rri8") 1, false, false, 133, 7, 21, 1,  0, 0}, // #550
  {DBGFIELD("FCOMPP")             2, false, false, 437, 4,  1, 1,  0, 0}, // #551
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 2, false, false, 437, 4,  1, 1,  0, 0}, // #552
  {DBGFIELD("BT16ri8_BT16rr_BT32ri8_BT32rr_BT64ri8_BT64rr_BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 1, false, false, 93, 4,  1, 1,  0, 0}, // #553
  {DBGFIELD("MMX_CVTPI2PSirr")    1, false, false, 133, 7, 21, 1,  0, 0}, // #554
  {DBGFIELD("MMX_CVTPI2PSirm")    2, false, false, 124, 9, 10, 1,  0, 0}, // #555
  {DBGFIELD("MMX_CVTPS2PIirr_MMX_CVTTPS2PIirr") 2, false, false, 719, 11, 22, 1,  0, 0}, // #556
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 2, false, false, 120, 4,  6, 1,  0, 0}, // #557
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, 97, 4,  1, 1,  0, 0}, // #558
  {DBGFIELD("XCH_F")              15, false, false, 3593, 15, 28, 1,  0, 0}, // #559
  {DBGFIELD("RETIL_RETIQ_RETIW_IRET_IRET16_IRET32_IRET64") 2, false, false, 87, 6,  6, 1,  0, 0}, // #560
  {DBGFIELD("MMX_CVTPS2PIirm_MMX_CVTTPS2PIirm") 2, false, false, 124, 9, 10, 1,  0, 0}, // #561
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 2, false, false, 124, 9, 18, 1,  0, 0}, // #562
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 2, false, false, 166, 2, 20, 1,  0, 0}, // #563
  {DBGFIELD("LFENCE")             2, false, false, 166, 2, 20, 1,  0, 0}, // #564
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, 104, 8,  1, 1,  0, 0}, // #565
  {DBGFIELD("PSLLDQri_PSRLDQri")  1, false, false, 104, 8,  1, 1,  0, 0}, // #566
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr_MMX_PUNPCKHBWirr_MMX_PUNPCKHDQirr_MMX_PUNPCKHWDirr") 1, false, false, 104, 8,  1, 1,  0, 0}, // #567
  {DBGFIELD("LEAVE_LEAVE64")      3, false, false, 901, 4,  5, 1,  0, 0}, // #568
  {DBGFIELD("POP16r")             2, false, false, 120, 4,  6, 1,  0, 0}, // #569
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 4, false, false, 81, 6,  5, 1,  0, 0}, // #570
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 3, false, false, 901, 4,  1, 1,  0, 0}, // #571
  {DBGFIELD("BTC16mi8_BTC32mi8_BTC64mi8_BTR16mi8_BTR32mi8_BTR64mi8_BTS16mi8_BTS32mi8_BTS64mi8") 4, false, false, 602, 8,  5, 1,  0, 0}, // #572
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, 79, 2,  4, 1,  0, 0}, // #573
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr_XCHG16ar_XCHG16rr_XCHG32ar_XCHG32rr_XCHG64ar_XCHG64rr_XCHG8rr_MOVSX16rr8_MOVZX16rr8") 1, false, false, 79, 2,  1, 1,  0, 0}, // #574
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, 97, 4,  1, 1,  0, 0}, // #575
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, 437, 4,  1, 1,  0, 0}, // #576
  {DBGFIELD("MMX_PADDQirr_MMX_PSUBQirr") 1, false, false, 77, 4,  1, 1,  0, 0}, // #577
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 2, false, false, 97, 4,  1, 1,  0, 0}, // #578
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  2, false, false, 97, 4,  1, 1,  0, 0}, // #579
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, 77, 4,  1, 1,  0, 0}, // #580
  {DBGFIELD("CLD")                3, false, false, 905, 7, 21, 1,  0, 0}, // #581
  {DBGFIELD("LDDQUrm")            1, false, false, 101, 3,  6, 1,  0, 0}, // #582
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 5, false, false, 3608, 6, 22, 1,  0, 0}, // #583
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 4, false, false, 81, 6,  5, 1,  0, 0}, // #584
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 6, false, false, 912, 6,  9, 1,  0, 0}, // #585
  {DBGFIELD("PHADDDrr_PHSUBDrr")  3, false, false, 456, 8, 21, 1,  0, 0}, // #586
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, 101, 3,  7, 1,  0, 0}, // #587
  {DBGFIELD("MMX_PADDQirm_MMX_PSUBQirm") 2, false, false, 208, 6,  6, 1,  9, 1}, // #588
  {DBGFIELD("MOVDQUrm")           1, false, false, 101, 3,  6, 1,  0, 0}, // #589
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, 101, 3,  6, 1,  0, 0}, // #590
  {DBGFIELD("PADDQrm_PSUBQrm")    2, false, false, 208, 6,  5, 1,  9, 1}, // #591
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, 79, 2,  1, 1,  0, 0}, // #592
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   2, false, false, 220, 4, 20, 1,  0, 0}, // #593
  {DBGFIELD("LD_F80m")            1, false, false, 101, 3,  5, 1,  0, 0}, // #594
  {DBGFIELD("PHADDDrm_PHSUBDrm")  4, false, false, 446, 10,  9, 1,  9, 1}, // #595
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 2, false, false, 381, 12, 20, 1,  0, 0}, // #596
  {DBGFIELD("FLDCW16m")           3, false, false, 918, 11,  5, 1,  0, 0}, // #597
  {DBGFIELD("ST_FP80m")           2, false, false, 97, 4,  1, 1,  0, 0}, // #598
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 3, false, false, 456, 8, 21, 1,  0, 0}, // #599
  {DBGFIELD("CMPXCHG8rm")         6, false, false, 112, 8,  9, 1,  0, 0}, // #600
  {DBGFIELD("INTO")               4, false, false,  0, 0,  1, 1,  0, 0}, // #601
  {DBGFIELD("XLAT")               3, false, false,  0, 0,  5, 1,  0, 0}, // #602
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 4, false, false, 646, 9,  6, 1,  0, 0}, // #603
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false, 133, 7, 21, 1,  0, 0}, // #604
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 6, false, false, 626, 11, 19, 1,  0, 0}, // #605
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 4, false, false, 637, 9, 18, 1,  0, 0}, // #606
  {DBGFIELD("IMUL16rr_IMUL16rri_IMUL16rri8") 1, false, false, 133, 7, 21, 1,  0, 0}, // #607
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 3, false, false, 709, 10, 22, 1,  0, 0}, // #608
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 4, false, false, 446, 10, 10, 1,  9, 1}, // #609
  {DBGFIELD("AAD8i8")             1, false, false, 79, 2,  4, 1,  0, 0}, // #610
  {DBGFIELD("LOOPE")              11, false, false, 929, 4, 26, 1,  0, 0}, // #611
  {DBGFIELD("PUSHA16_PUSHA32")    19, false, false,  0, 0,  1, 1,  0, 0}, // #612
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 4, false, false, 646, 9,  6, 1,  0, 0}, // #613
  {DBGFIELD("FNSTCW16m")          3, false, false, 933, 10, 20, 1,  0, 0}, // #614
  {DBGFIELD("BT16mr_BT32mr_BT64mr") 10, false, false,  0, 0,  1, 1,  0, 0}, // #615
  {DBGFIELD("POPA16_POPA32")      18, false, false,  0, 0,  1, 1,  0, 0}, // #616
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, 97, 4,  1, 1,  0, 0}, // #617
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 6, false, false, 626, 11, 19, 1,  0, 0}, // #618
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 4, false, false, 637, 9, 18, 1,  0, 0}, // #619
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, 133, 7, 21, 1,  0, 0}, // #620
  {DBGFIELD("CMPXCHG8rr")         5, false, false, 943, 4,  7, 1,  0, 0}, // #621
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80_COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 133, 7,  1, 1,  0, 0}, // #622
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_CVTTSS2SI64rr_Int") 2, false, false, 947, 12, 22, 1,  0, 0}, // #623
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int") 2, false, false, 124, 9, 10, 1,  9, 1}, // #624
  {DBGFIELD("CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 4, false, false, 310, 16, 18, 1,  0, 0}, // #625
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 15, false, false,  0, 0,  1, 1,  0, 0}, // #626
  {DBGFIELD("BTC16mr_BTC32mr_BTC64mr_BTR16mr_BTR32mr_BTR64mr_BTS16mr_BTS32mr_BTS64mr") 11, false, false,  0, 0,  1, 1,  0, 0}, // #627
  {DBGFIELD("AAA_AAS")            1, false, false, 79, 2,  4, 1,  0, 0}, // #628
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 6, false, false, 112, 8,  9, 1,  0, 0}, // #629
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 5, false, false, 943, 4,  7, 1,  0, 0}, // #630
  {DBGFIELD("LOOPNE")             11, false, false, 929, 4, 26, 1,  0, 0}, // #631
  {DBGFIELD("PAUSE")              5, false, false, 959, 7,  7, 1,  0, 0}, // #632
  {DBGFIELD("CMPXCHG8B")          14, false, false, 966, 10, 28, 1,  0, 0}, // #633
  {DBGFIELD("DAA")                1, false, false, 79, 2,  4, 1,  0, 0}, // #634
  {DBGFIELD("LOOP")               7, false, false, 976, 9,  5, 1,  0, 0}, // #635
  {DBGFIELD("DAS")                1, false, false, 79, 2,  4, 1,  0, 0}, // #636
  {DBGFIELD("AAM8i8")             1, false, false, 79, 2,  4, 1,  0, 0}, // #637
  {DBGFIELD("STD")                6, false, false, 985, 7,  6, 1,  0, 0}, // #638
  {DBGFIELD("CMPXCHG16B")         19, false, false, 992, 15, 32, 1,  0, 0}, // #639
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, 79, 2,  4, 1,  0, 0}, // #640
  {DBGFIELD("FNCLEX_FXTRACT")     4, false, false, 368, 2, 22, 1,  0, 0}, // #641
  {DBGFIELD("POPF32_POPF64")      1, false, false, 101, 3,  7, 1,  0, 0}, // #642
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_