/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Assembly Matcher Source Fragment                                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_ASSEMBLER_HEADER
#undef GET_ASSEMBLER_HEADER
  // This should be included into the middle of the declaration of
  // your subclasses implementation of MCTargetAsmParser.
  uint64_t ComputeAvailableFeatures(const FeatureBitset& FB) const;
  void convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                       const OperandVector &Operands);
  void convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) override;
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                SmallVectorImpl<NearMissInfo> *NearMisses,
                                bool matchingInlineAsm,
                                unsigned VariantID = 0);
  OperandMatchResultTy MatchOperandParserImpl(
    OperandVector &Operands,
    StringRef Mnemonic,
    bool ParseForAllFeatures = false);
  OperandMatchResultTy tryCustomParseOperand(
    OperandVector &Operands,
    unsigned MCK);

#endif // GET_ASSEMBLER_HEADER_INFO


#ifdef GET_OPERAND_DIAGNOSTIC_TYPES
#undef GET_OPERAND_DIAGNOSTIC_TYPES

  Match_AlignedMemory16,
  Match_AlignedMemory32,
  Match_AlignedMemory64,
  Match_AlignedMemory64or128,
  Match_AlignedMemory64or128or256,
  Match_AlignedMemoryNone,
  Match_ComplexRotationEven,
  Match_ComplexRotationOdd,
  Match_DPR,
  Match_DPR_8,
  Match_DPR_RegList,
  Match_DPR_VFP2,
  Match_DupAlignedMemory16,
  Match_DupAlignedMemory32,
  Match_DupAlignedMemory64,
  Match_DupAlignedMemory64or128,
  Match_DupAlignedMemoryNone,
  Match_GPR,
  Match_GPRnopc,
  Match_GPRsp,
  Match_GPRwithAPSR,
  Match_Imm0_1,
  Match_Imm0_15,
  Match_Imm0_239,
  Match_Imm0_255,
  Match_Imm0_3,
  Match_Imm0_31,
  Match_Imm0_32,
  Match_Imm0_4095,
  Match_Imm0_63,
  Match_Imm0_65535,
  Match_Imm0_65535Expr,
  Match_Imm0_7,
  Match_Imm16,
  Match_Imm1_15,
  Match_Imm1_31,
  Match_Imm1_7,
  Match_Imm24bit,
  Match_Imm256_65535Expr,
  Match_Imm32,
  Match_Imm8,
  Match_Imm8_255,
  Match_ImmRange1_16,
  Match_ImmRange1_32,
  Match_ImmThumbSR,
  Match_PKHLSLImm,
  Match_QPR,
  Match_QPR_8,
  Match_QPR_VFP2,
  Match_SPR,
  Match_SPRRegList,
  Match_SPR_8,
  Match_SetEndImm,
  Match_ShrImm16,
  Match_ShrImm32,
  Match_ShrImm64,
  Match_ShrImm8,
  Match_hGPR,
  Match_rGPR,
  Match_tGPR,
  END_OPERAND_DIAGNOSTIC_TYPES
#endif // GET_OPERAND_DIAGNOSTIC_TYPES


#ifdef GET_REGISTER_MATCHER
#undef GET_REGISTER_MATCHER

// Flags for subtarget features that participate in instruction matching.
enum SubtargetFeatureFlag : uint64_t {
  Feature_HasV4T = (1ULL << 20),
  Feature_HasV5T = (1ULL << 21),
  Feature_HasV5TE = (1ULL << 22),
  Feature_HasV6 = (1ULL << 23),
  Feature_HasV6M = (1ULL << 25),
  Feature_HasV8MBaseline = (1ULL << 30),
  Feature_HasV8MMainline = (1ULL << 31),
  Feature_HasV6T2 = (1ULL << 26),
  Feature_HasV6K = (1ULL << 24),
  Feature_HasV7 = (1ULL << 27),
  Feature_HasV8 = (1ULL << 29),
  Feature_PreV8 = (1ULL << 45),
  Feature_HasV8_1a = (1ULL << 32),
  Feature_HasV8_2a = (1ULL << 33),
  Feature_HasV8_3a = (1ULL << 34),
  Feature_HasV8_4a = (1ULL << 35),
  Feature_HasVFP2 = (1ULL << 36),
  Feature_HasVFP3 = (1ULL << 37),
  Feature_HasVFP4 = (1ULL << 38),
  Feature_HasDPVFP = (1ULL << 7),
  Feature_HasFPARMv8 = (1ULL << 13),
  Feature_HasNEON = (1ULL << 16),
  Feature_HasSHA2 = (1ULL << 18),
  Feature_HasAES = (1ULL << 1),
  Feature_HasCrypto = (1ULL << 4),
  Feature_HasDotProd = (1ULL << 11),
  Feature_HasCRC = (1ULL << 3),
  Feature_HasRAS = (1ULL << 17),
  Feature_HasFP16 = (1ULL << 12),
  Feature_HasFullFP16 = (1ULL << 14),
  Feature_HasDivideInThumb = (1ULL << 10),
  Feature_HasDivideInARM = (1ULL << 9),
  Feature_HasDSP = (1ULL << 8),
  Feature_HasDB = (1ULL << 5),
  Feature_HasDFB = (1ULL << 6),
  Feature_HasV7Clrex = (1ULL << 28),
  Feature_HasAcquireRelease = (1ULL << 2),
  Feature_HasMP = (1ULL << 15),
  Feature_HasVirtualization = (1ULL << 39),
  Feature_HasTrustZone = (1ULL << 19),
  Feature_Has8MSecExt = (1ULL << 0),
  Feature_IsThumb = (1ULL << 43),
  Feature_IsThumb2 = (1ULL << 44),
  Feature_IsMClass = (1ULL << 41),
  Feature_IsNotMClass = (1ULL << 42),
  Feature_IsARM = (1ULL << 40),
  Feature_UseNaClTrap = (1ULL << 46),
  Feature_UseNegativeImmediates = (1ULL << 47),
  Feature_None = 0
};

static unsigned MatchRegisterName(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 2:	 // 43 strings to match.
    switch (Name[0]) {
    default: break;
    case 'd':	 // 10 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 1 string to match.
        return 14;	 // "d0"
      case '1':	 // 1 string to match.
        return 15;	 // "d1"
      case '2':	 // 1 string to match.
        return 16;	 // "d2"
      case '3':	 // 1 string to match.
        return 17;	 // "d3"
      case '4':	 // 1 string to match.
        return 18;	 // "d4"
      case '5':	 // 1 string to match.
        return 19;	 // "d5"
      case '6':	 // 1 string to match.
        return 20;	 // "d6"
      case '7':	 // 1 string to match.
        return 21;	 // "d7"
      case '8':	 // 1 string to match.
        return 22;	 // "d8"
      case '9':	 // 1 string to match.
        return 23;	 // "d9"
      }
      break;
    case 'l':	 // 1 string to match.
      if (Name[1] != 'r')
        break;
      return 10;	 // "lr"
    case 'p':	 // 1 string to match.
      if (Name[1] != 'c')
        break;
      return 11;	 // "pc"
    case 'q':	 // 10 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 1 string to match.
        return 50;	 // "q0"
      case '1':	 // 1 string to match.
        return 51;	 // "q1"
      case '2':	 // 1 string to match.
        return 52;	 // "q2"
      case '3':	 // 1 string to match.
        return 53;	 // "q3"
      case '4':	 // 1 string to match.
        return 54;	 // "q4"
      case '5':	 // 1 string to match.
        return 55;	 // "q5"
      case '6':	 // 1 string to match.
        return 56;	 // "q6"
      case '7':	 // 1 string to match.
        return 57;	 // "q7"
      case '8':	 // 1 string to match.
        return 58;	 // "q8"
      case '9':	 // 1 string to match.
        return 59;	 // "q9"
      }
      break;
    case 'r':	 // 10 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 1 string to match.
        return 66;	 // "r0"
      case '1':	 // 1 string to match.
        return 67;	 // "r1"
      case '2':	 // 1 string to match.
        return 68;	 // "r2"
      case '3':	 // 1 string to match.
        return 69;	 // "r3"
      case '4':	 // 1 string to match.
        return 70;	 // "r4"
      case '5':	 // 1 string to match.
        return 71;	 // "r5"
      case '6':	 // 1 string to match.
        return 72;	 // "r6"
      case '7':	 // 1 string to match.
        return 73;	 // "r7"
      case '8':	 // 1 string to match.
        return 74;	 // "r8"
      case '9':	 // 1 string to match.
        return 75;	 // "r9"
      }
      break;
    case 's':	 // 11 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 1 string to match.
        return 79;	 // "s0"
      case '1':	 // 1 string to match.
        return 80;	 // "s1"
      case '2':	 // 1 string to match.
        return 81;	 // "s2"
      case '3':	 // 1 string to match.
        return 82;	 // "s3"
      case '4':	 // 1 string to match.
        return 83;	 // "s4"
      case '5':	 // 1 string to match.
        return 84;	 // "s5"
      case '6':	 // 1 string to match.
        return 85;	 // "s6"
      case '7':	 // 1 string to match.
        return 86;	 // "s7"
      case '8':	 // 1 string to match.
        return 87;	 // "s8"
      case '9':	 // 1 string to match.
        return 88;	 // "s9"
      case 'p':	 // 1 string to match.
        return 12;	 // "sp"
      }
      break;
    }
    break;
  case 3:	 // 53 strings to match.
    switch (Name[0]) {
    default: break;
    case 'd':	 // 22 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 10 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return 24;	 // "d10"
        case '1':	 // 1 string to match.
          return 25;	 // "d11"
        case '2':	 // 1 string to match.
          return 26;	 // "d12"
        case '3':	 // 1 string to match.
          return 27;	 // "d13"
        case '4':	 // 1 string to match.
          return 28;	 // "d14"
        case '5':	 // 1 string to match.
          return 29;	 // "d15"
        case '6':	 // 1 string to match.
          return 30;	 // "d16"
        case '7':	 // 1 string to match.
          return 31;	 // "d17"
        case '8':	 // 1 string to match.
          return 32;	 // "d18"
        case '9':	 // 1 string to match.
          return 33;	 // "d19"
        }
        break;
      case '2':	 // 10 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return 34;	 // "d20"
        case '1':	 // 1 string to match.
          return 35;	 // "d21"
        case '2':	 // 1 string to match.
          return 36;	 // "d22"
        case '3':	 // 1 string to match.
          return 37;	 // "d23"
        case '4':	 // 1 string to match.
          return 38;	 // "d24"
        case '5':	 // 1 string to match.
          return 39;	 // "d25"
        case '6':	 // 1 string to match.
          return 40;	 // "d26"
        case '7':	 // 1 string to match.
          return 41;	 // "d27"
        case '8':	 // 1 string to match.
          return 42;	 // "d28"
        case '9':	 // 1 string to match.
          return 43;	 // "d29"
        }
        break;
      case '3':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return 44;	 // "d30"
        case '1':	 // 1 string to match.
          return 45;	 // "d31"
        }
        break;
      }
      break;
    case 'q':	 // 6 strings to match.
      if (Name[1] != '1')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 1 string to match.
        return 60;	 // "q10"
      case '1':	 // 1 string to match.
        return 61;	 // "q11"
      case '2':	 // 1 string to match.
        return 62;	 // "q12"
      case '3':	 // 1 string to match.
        return 63;	 // "q13"
      case '4':	 // 1 string to match.
        return 64;	 // "q14"
      case '5':	 // 1 string to match.
        return 65;	 // "q15"
      }
      break;
    case 'r':	 // 3 strings to match.
      if (Name[1] != '1')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 1 string to match.
        return 76;	 // "r10"
      case '1':	 // 1 string to match.
        return 77;	 // "r11"
      case '2':	 // 1 string to match.
        return 78;	 // "r12"
      }
      break;
    case 's':	 // 22 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 10 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return 89;	 // "s10"
        case '1':	 // 1 string to match.
          return 90;	 // "s11"
        case '2':	 // 1 string to match.
          return 91;	 // "s12"
        case '3':	 // 1 string to match.
          return 92;	 // "s13"
        case '4':	 // 1 string to match.
          return 93;	 // "s14"
        case '5':	 // 1 string to match.
          return 94;	 // "s15"
        case '6':	 // 1 string to match.
          return 95;	 // "s16"
        case '7':	 // 1 string to match.
          return 96;	 // "s17"
        case '8':	 // 1 string to match.
          return 97;	 // "s18"
        case '9':	 // 1 string to match.
          return 98;	 // "s19"
        }
        break;
      case '2':	 // 10 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return 99;	 // "s20"
        case '1':	 // 1 string to match.
          return 100;	 // "s21"
        case '2':	 // 1 string to match.
          return 101;	 // "s22"
        case '3':	 // 1 string to match.
          return 102;	 // "s23"
        case '4':	 // 1 string to match.
          return 103;	 // "s24"
        case '5':	 // 1 string to match.
          return 104;	 // "s25"
        case '6':	 // 1 string to match.
          return 105;	 // "s26"
        case '7':	 // 1 string to match.
          return 106;	 // "s27"
        case '8':	 // 1 string to match.
          return 107;	 // "s28"
        case '9':	 // 1 string to match.
          return 108;	 // "s29"
        }
        break;
      case '3':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return 109;	 // "s30"
        case '1':	 // 1 string to match.
          return 110;	 // "s31"
        }
        break;
      }
      break;
    }
    break;
  case 4:	 // 3 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(Name.data()+1, "psr", 3) != 0)
        break;
      return 1;	 // "apsr"
    case 'c':	 // 1 string to match.
      if (memcmp(Name.data()+1, "psr", 3) != 0)
        break;
      return 3;	 // "cpsr"
    case 's':	 // 1 string to match.
      if (memcmp(Name.data()+1, "psr", 3) != 0)
        break;
      return 13;	 // "spsr"
    }
    break;
  case 5:	 // 6 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 3 strings to match.
      if (Name[1] != 'p')
        break;
      switch (Name[2]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(Name.data()+3, "xc", 2) != 0)
          break;
        return 4;	 // "fpexc"
      case 's':	 // 2 strings to match.
        switch (Name[3]) {
        default: break;
        case 'c':	 // 1 string to match.
          if (Name[4] != 'r')
            break;
          return 6;	 // "fpscr"
        case 'i':	 // 1 string to match.
          if (Name[4] != 'd')
            break;
          return 8;	 // "fpsid"
        }
        break;
      }
      break;
    case 'm':	 // 3 strings to match.
      if (memcmp(Name.data()+1, "vfr", 3) != 0)
        break;
      switch (Name[4]) {
      default: break;
      case '0':	 // 1 string to match.
        return 47;	 // "mvfr0"
      case '1':	 // 1 string to match.
        return 48;	 // "mvfr1"
      case '2':	 // 1 string to match.
        return 49;	 // "mvfr2"
      }
      break;
    }
    break;
  case 6:	 // 1 string to match.
    if (memcmp(Name.data()+0, "fpinst", 6) != 0)
      break;
    return 5;	 // "fpinst"
  case 7:	 // 2 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(Name.data()+1, "pinst2", 6) != 0)
        break;
      return 46;	 // "fpinst2"
    case 'i':	 // 1 string to match.
      if (memcmp(Name.data()+1, "tstate", 6) != 0)
        break;
      return 9;	 // "itstate"
    }
    break;
  case 9:	 // 1 string to match.
    if (memcmp(Name.data()+0, "apsr_nzcv", 9) != 0)
      break;
    return 2;	 // "apsr_nzcv"
  case 10:	 // 1 string to match.
    if (memcmp(Name.data()+0, "fpscr_nzcv", 10) != 0)
      break;
    return 7;	 // "fpscr_nzcv"
  }
  return 0;
}

#endif // GET_REGISTER_MATCHER


#ifdef GET_SUBTARGET_FEATURE_NAME
#undef GET_SUBTARGET_FEATURE_NAME

// User-level names for subtarget features that participate in
// instruction matching.
static const char *getSubtargetFeatureName(uint64_t Val) {
  switch(Val) {
  case Feature_HasV4T: return "armv4t";
  case Feature_HasV5T: return "armv5t";
  case Feature_HasV5TE: return "armv5te";
  case Feature_HasV6: return "armv6";
  case Feature_HasV6M: return "armv6m or armv6t2";
  case Feature_HasV8MBaseline: return "armv8m.base";
  case Feature_HasV8MMainline: return "armv8m.main";
  case Feature_HasV6T2: return "armv6t2";
  case Feature_HasV6K: return "armv6k";
  case Feature_HasV7: return "armv7";
  case Feature_HasV8: return "armv8";
  case Feature_PreV8: return "armv7 or earlier";
  case Feature_HasV8_1a: return "armv8.1a";
  case Feature_HasV8_2a: return "armv8.2a";
  case Feature_HasV8_3a: return "armv8.3a";
  case Feature_HasV8_4a: return "armv8.4a";
  case Feature_HasVFP2: return "VFP2";
  case Feature_HasVFP3: return "VFP3";
  case Feature_HasVFP4: return "VFP4";
  case Feature_HasDPVFP: return "double precision VFP";
  case Feature_HasFPARMv8: return "FPARMv8";
  case Feature_HasNEON: return "NEON";
  case Feature_HasSHA2: return "sha2";
  case Feature_HasAES: return "aes";
  case Feature_HasCrypto: return "crypto";
  case Feature_HasDotProd: return "dotprod";
  case Feature_HasCRC: return "crc";
  case Feature_HasRAS: return "ras";
  case Feature_HasFP16: return "half-float conversions";
  case Feature_HasFullFP16: return "full half-float";
  case Feature_HasDivideInThumb: return "divide in THUMB";
  case Feature_HasDivideInARM: return "divide in ARM";
  case Feature_HasDSP: return "dsp";
  case Feature_HasDB: return "data-barriers";
  case Feature_HasDFB: return "full-data-barrier";
  case Feature_HasV7Clrex: return "v7 clrex";
  case Feature_HasAcquireRelease: return "acquire/release";
  case Feature_HasMP: return "mp-extensions";
  case Feature_HasVirtualization: return "virtualization-extensions";
  case Feature_HasTrustZone: return "TrustZone";
  case Feature_Has8MSecExt: return "ARMv8-M Security Extensions";
  case Feature_IsThumb: return "thumb";
  case Feature_IsThumb2: return "thumb2";
  case Feature_IsMClass: return "armv*m";
  case Feature_IsNotMClass: return "!armv*m";
  case Feature_IsARM: return "arm-mode";
  case Feature_UseNaClTrap: return "NaCl";
  case Feature_UseNegativeImmediates: return "NegativeImmediates";
  default: return "(unknown)";
  }
}

#endif // GET_SUBTARGET_FEATURE_NAME


#ifdef GET_MATCHER_IMPLEMENTATION
#undef GET_MATCHER_IMPLEMENTATION

static void applyMnemonicAliases(StringRef &Mnemonic, uint64_t Features, unsigned VariantID) {
  switch (VariantID) {
    case 0:
    break;
  }
  switch (Mnemonic.size()) {
  default: break;
  case 3:	 // 4 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'r':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "fe", 2) != 0)
        break;
      Mnemonic = "rfeia";	 // "rfe"
      return;
    case 's':	 // 3 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'm':	 // 1 string to match.
        if (Mnemonic[2] != 'i')
          break;
        Mnemonic = "smc";	 // "smi"
        return;
      case 'r':	 // 1 string to match.
        if (Mnemonic[2] != 's')
          break;
        Mnemonic = "srsia";	 // "srs"
        return;
      case 'w':	 // 1 string to match.
        if (Mnemonic[2] != 'i')
          break;
        Mnemonic = "svc";	 // "swi"
        return;
      }
      break;
    }
    break;
  case 4:	 // 10 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'f':	 // 8 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'l':	 // 2 strings to match.
        if (Mnemonic[2] != 'd')
          break;
        switch (Mnemonic[3]) {
        default: break;
        case 'd':	 // 1 string to match.
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fldd"
            Mnemonic = "vldr";
          return;
        case 's':	 // 1 string to match.
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "flds"
            Mnemonic = "vldr";
          return;
        }
        break;
      case 'm':	 // 4 strings to match.
        switch (Mnemonic[2]) {
        default: break;
        case 'r':	 // 2 strings to match.
          switch (Mnemonic[3]) {
          default: break;
          case 's':	 // 1 string to match.
            if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fmrs"
              Mnemonic = "vmov";
            return;
          case 'x':	 // 1 string to match.
            if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fmrx"
              Mnemonic = "vmrs";
            return;
          }
          break;
        case 's':	 // 1 string to match.
          if (Mnemonic[3] != 'r')
            break;
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fmsr"
            Mnemonic = "vmov";
          return;
        case 'x':	 // 1 string to match.
          if (Mnemonic[3] != 'r')
            break;
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fmxr"
            Mnemonic = "vmsr";
          return;
        }
        break;
      case 's':	 // 2 strings to match.
        if (Mnemonic[2] != 't')
          break;
        switch (Mnemonic[3]) {
        default: break;
        case 'd':	 // 1 string to match.
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fstd"
            Mnemonic = "vstr";
          return;
        case 's':	 // 1 string to match.
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fsts"
            Mnemonic = "vstr";
          return;
        }
        break;
      }
      break;
    case 'v':	 // 2 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'l':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "dm", 2) != 0)
          break;
        Mnemonic = "vldmia";	 // "vldm"
        return;
      case 's':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "tm", 2) != 0)
          break;
        Mnemonic = "vstmia";	 // "vstm"
        return;
      }
      break;
    }
    break;
  case 5:	 // 51 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'f':	 // 18 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'a':	 // 2 strings to match.
        if (memcmp(Mnemonic.data()+2, "dd", 2) != 0)
          break;
        switch (Mnemonic[4]) {
        default: break;
        case 'd':	 // 1 string to match.
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "faddd"
            Mnemonic = "vadd.f64";
          return;
        case 's':	 // 1 string to match.
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fadds"
            Mnemonic = "vadd.f32";
          return;
        }
        break;
      case 'c':	 // 4 strings to match.
        switch (Mnemonic[2]) {
        default: break;
        case 'm':	 // 2 strings to match.
          if (Mnemonic[3] != 'p')
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'd':	 // 1 string to match.
            if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fcmpd"
              Mnemonic = "vcmp.f64";
            return;
          case 's':	 // 1 string to match.
            if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fcmps"
              Mnemonic = "vcmp.f32";
            return;
          }
          break;
        case 'p':	 // 2 strings to match.
          if (Mnemonic[3] != 'y')
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'd':	 // 1 string to match.
            if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fcpyd"
              Mnemonic = "vmov.f64";
            return;
          case 's':	 // 1 string to match.
            if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fcpys"
              Mnemonic = "vmov.f32";
            return;
          }
          break;
        }
        break;
      case 'd':	 // 2 strings to match.
        if (memcmp(Mnemonic.data()+2, "iv", 2) != 0)
          break;
        switch (Mnemonic[4]) {
        default: break;
        case 'd':	 // 1 string to match.
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fdivd"
            Mnemonic = "vdiv.f64";
          return;
        case 's':	 // 1 string to match.
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fdivs"
            Mnemonic = "vdiv.f32";
          return;
        }
        break;
      case 'm':	 // 8 strings to match.
        switch (Mnemonic[2]) {
        default: break;
        case 'a':	 // 2 strings to match.
          if (Mnemonic[3] != 'c')
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'd':	 // 1 string to match.
            if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fmacd"
              Mnemonic = "vmla.f64";
            return;
          case 's':	 // 1 string to match.
            if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fmacs"
              Mnemonic = "vmla.f32";
            return;
          }
          break;
        case 'd':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "rr", 2) != 0)
            break;
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fmdrr"
            Mnemonic = "vmov";
          return;
        case 'r':	 // 3 strings to match.
          switch (Mnemonic[3]) {
          default: break;
          case 'd':	 // 2 strings to match.
            switch (Mnemonic[4]) {
            default: break;
            case 'd':	 // 1 string to match.
              if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fmrdd"
                Mnemonic = "vmov";
              return;
            case 's':	 // 1 string to match.
              if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fmrds"
                Mnemonic = "vmov";
              return;
            }
            break;
          case 'r':	 // 1 string to match.
            if (Mnemonic[4] != 'd')
              break;
            if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fmrrd"
              Mnemonic = "vmov";
            return;
          }
          break;
        case 'u':	 // 2 strings to match.
          if (Mnemonic[3] != 'l')
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'd':	 // 1 string to match.
            if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fmuld"
              Mnemonic = "vmul.f64";
            return;
          case 's':	 // 1 string to match.
            if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fmuls"
              Mnemonic = "vmul.f32";
            return;
          }
          break;
        }
        break;
      case 'n':	 // 2 strings to match.
        if (memcmp(Mnemonic.data()+2, "eg", 2) != 0)
          break;
        switch (Mnemonic[4]) {
        default: break;
        case 'd':	 // 1 string to match.
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fnegd"
            Mnemonic = "vneg.f64";
          return;
        case 's':	 // 1 string to match.
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fnegs"
            Mnemonic = "vneg.f32";
          return;
        }
        break;
      }
      break;
    case 'l':	 // 3 strings to match.
      if (memcmp(Mnemonic.data()+1, "dm", 2) != 0)
        break;
      switch (Mnemonic[3]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (Mnemonic[4] != 'a')
          break;
        Mnemonic = "ldmdb";	 // "ldmea"
        return;
      case 'f':	 // 1 string to match.
        if (Mnemonic[4] != 'd')
          break;
        Mnemonic = "ldm";	 // "ldmfd"
        return;
      case 'i':	 // 1 string to match.
        if (Mnemonic[4] != 'a')
          break;
        Mnemonic = "ldm";	 // "ldmia"
        return;
      }
      break;
    case 'r':	 // 4 strings to match.
      if (memcmp(Mnemonic.data()+1, "fe", 2) != 0)
        break;
      switch (Mnemonic[3]) {
      default: break;
      case 'e':	 // 2 strings to match.
        switch (Mnemonic[4]) {
        default: break;
        case 'a':	 // 1 string to match.
          Mnemonic = "rfedb";	 // "rfeea"
          return;
        case 'd':	 // 1 string to match.
          Mnemonic = "rfeib";	 // "rfeed"
          return;
        }
        break;
      case 'f':	 // 2 strings to match.
        switch (Mnemonic[4]) {
        default: break;
        case 'a':	 // 1 string to match.
          Mnemonic = "rfeda";	 // "rfefa"
          return;
        case 'd':	 // 1 string to match.
          Mnemonic = "rfeia";	 // "rfefd"
          return;
        }
        break;
      }
      break;
    case 's':	 // 7 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'r':	 // 4 strings to match.
        if (Mnemonic[2] != 's')
          break;
        switch (Mnemonic[3]) {
        default: break;
        case 'e':	 // 2 strings to match.
          switch (Mnemonic[4]) {
          default: break;
          case 'a':	 // 1 string to match.
            Mnemonic = "srsia";	 // "srsea"
            return;
          case 'd':	 // 1 string to match.
            Mnemonic = "srsda";	 // "srsed"
            return;
          }
          break;
        case 'f':	 // 2 strings to match.
          switch (Mnemonic[4]) {
          default: break;
          case 'a':	 // 1 string to match.
            Mnemonic = "srsib";	 // "srsfa"
            return;
          case 'd':	 // 1 string to match.
            Mnemonic = "srsdb";	 // "srsfd"
            return;
          }
          break;
        }
        break;
      case 't':	 // 3 strings to match.
        if (Mnemonic[2] != 'm')
          break;
        switch (Mnemonic[3]) {
        default: break;
        case 'e':	 // 1 string to match.
          if (Mnemonic[4] != 'a')
            break;
          Mnemonic = "stm";	 // "stmea"
          return;
        case 'f':	 // 1 string to match.
          if (Mnemonic[4] != 'd')
            break;
          Mnemonic = "stmdb";	 // "stmfd"
          return;
        case 'i':	 // 1 string to match.
          if (Mnemonic[4] != 'a')
            break;
          Mnemonic = "stm";	 // "stmia"
          return;
        }
        break;
      }
      break;
    case 'v':	 // 19 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'a':	 // 3 strings to match.
        switch (Mnemonic[2]) {
        default: break;
        case 'b':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "sq", 2) != 0)
            break;
          if ((Features & Feature_HasNEON) == Feature_HasNEON)	 // "vabsq"
            Mnemonic = "vabs";
          return;
        case 'd':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "dq", 2) != 0)
            break;
          if ((Features & Feature_HasNEON) == Feature_HasNEON)	 // "vaddq"
            Mnemonic = "vadd";
          return;
        case 'n':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "dq", 2) != 0)
            break;
          if ((Features & Feature_HasNEON) == Feature_HasNEON)	 // "vandq"
            Mnemonic = "vand";
          return;
        }
        break;
      case 'b':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "icq", 3) != 0)
          break;
        if ((Features & Feature_HasNEON) == Feature_HasNEON)	 // "vbicq"
          Mnemonic = "vbic";
        return;
      case 'c':	 // 3 strings to match.
        switch (Mnemonic[2]) {
        default: break;
        case 'e':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "qq", 2) != 0)
            break;
          if ((Features & Feature_HasNEON) == Feature_HasNEON)	 // "vceqq"
            Mnemonic = "vceq";
          return;
        case 'l':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "eq", 2) != 0)
            break;
          if ((Features & Feature_HasNEON) == Feature_HasNEON)	 // "vcleq"
            Mnemonic = "vcle";
          return;
        case 'v':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "tq", 2) != 0)
            break;
          if ((Features & Feature_HasNEON) == Feature_HasNEON)	 // "vcvtq"
            Mnemonic = "vcvt";
          return;
        }
        break;
      case 'e':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "orq", 3) != 0)
          break;
        if ((Features & Feature_HasNEON) == Feature_HasNEON)	 // "veorq"
          Mnemonic = "veor";
        return;
      case 'm':	 // 5 strings to match.
        switch (Mnemonic[2]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "xq", 2) != 0)
            break;
          if ((Features & Feature_HasNEON) == Feature_HasNEON)	 // "vmaxq"
            Mnemonic = "vmax";
          return;
        case 'i':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "nq", 2) != 0)
            break;
          if ((Features & Feature_HasNEON) == Feature_HasNEON)	 // "vminq"
            Mnemonic = "vmin";
          return;
        case 'o':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "vq", 2) != 0)
            break;
          if ((Features & Feature_HasNEON) == Feature_HasNEON)	 // "vmovq"
            Mnemonic = "vmov";
          return;
        case 'u':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "lq", 2) != 0)
            break;
          if ((Features & Feature_HasNEON) == Feature_HasNEON)	 // "vmulq"
            Mnemonic = "vmul";
          return;
        case 'v':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "nq", 2) != 0)
            break;
          if ((Features & Feature_HasNEON) == Feature_HasNEON)	 // "vmvnq"
            Mnemonic = "vmvn";
          return;
        }
        break;
      case 'o':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "rrq", 3) != 0)
          break;
        if ((Features & Feature_HasNEON) == Feature_HasNEON)	 // "vorrq"
          Mnemonic = "vorr";
        return;
      case 's':	 // 4 strings to match.
        switch (Mnemonic[2]) {
        default: break;
        case 'h':	 // 2 strings to match.
          switch (Mnemonic[3]) {
          default: break;
          case 'l':	 // 1 string to match.
            if (Mnemonic[4] != 'q')
              break;
            if ((Features & Feature_HasNEON) == Feature_HasNEON)	 // "vshlq"
              Mnemonic = "vshl";
            return;
          case 'r':	 // 1 string to match.
            if (Mnemonic[4] != 'q')
              break;
            if ((Features & Feature_HasNEON) == Feature_HasNEON)	 // "vshrq"
              Mnemonic = "vshr";
            return;
          }
          break;
        case 'u':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "bq", 2) != 0)
            break;
          if ((Features & Feature_HasNEON) == Feature_HasNEON)	 // "vsubq"
            Mnemonic = "vsub";
          return;
        case 'w':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "pq", 2) != 0)
            break;
          if ((Features & Feature_HasNEON) == Feature_HasNEON)	 // "vswpq"
            Mnemonic = "vswp";
          return;
        }
        break;
      case 'z':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "ipq", 3) != 0)
          break;
        if ((Features & Feature_HasNEON) == Feature_HasNEON)	 // "vzipq"
          Mnemonic = "vzip";
        return;
      }
      break;
    }
    break;
  case 6:	 // 10 strings to match.
    if (Mnemonic[0] != 'f')
      break;
    switch (Mnemonic[1]) {
    default: break;
    case 's':	 // 4 strings to match.
      switch (Mnemonic[2]) {
      default: break;
      case 'i':	 // 2 strings to match.
        if (memcmp(Mnemonic.data()+3, "to", 2) != 0)
          break;
        switch (Mnemonic[5]) {
        default: break;
        case 'd':	 // 1 string to match.
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fsitod"
            Mnemonic = "vcvt.f64.s32";
          return;
        case 's':	 // 1 string to match.
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fsitos"
            Mnemonic = "vcvt.f32.s32";
          return;
        }
        break;
      case 'q':	 // 2 strings to match.
        if (memcmp(Mnemonic.data()+3, "rt", 2) != 0)
          break;
        switch (Mnemonic[5]) {
        default: break;
        case 'd':	 // 1 string to match.
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fsqrtd"
            Mnemonic = "vsqrt";
          return;
        case 's':	 // 1 string to match.
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fsqrts"
            Mnemonic = "vsqrt";
          return;
        }
        break;
      }
      break;
    case 't':	 // 4 strings to match.
      if (Mnemonic[2] != 'o')
        break;
      switch (Mnemonic[3]) {
      default: break;
      case 's':	 // 2 strings to match.
        if (Mnemonic[4] != 'i')
          break;
        switch (Mnemonic[5]) {
        default: break;
        case 'd':	 // 1 string to match.
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "ftosid"
            Mnemonic = "vcvtr.s32.f64";
          return;
        case 's':	 // 1 string to match.
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "ftosis"
            Mnemonic = "vcvtr.s32.f32";
          return;
        }
        break;
      case 'u':	 // 2 strings to match.
        if (Mnemonic[4] != 'i')
          break;
        switch (Mnemonic[5]) {
        default: break;
        case 'd':	 // 1 string to match.
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "ftouid"
            Mnemonic = "vcvtr.u32.f64";
          return;
        case 's':	 // 1 string to match.
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "ftouis"
            Mnemonic = "vcvtr.u32.f32";
          return;
        }
        break;
      }
      break;
    case 'u':	 // 2 strings to match.
      if (memcmp(Mnemonic.data()+2, "ito", 3) != 0)
        break;
      switch (Mnemonic[5]) {
      default: break;
      case 'd':	 // 1 string to match.
        if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fuitod"
          Mnemonic = "vcvt.f64.u32";
        return;
      case 's':	 // 1 string to match.
        if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fuitos"
          Mnemonic = "vcvt.f32.u32";
        return;
      }
      break;
    }
    break;
  case 7:	 // 8 strings to match.
    if (Mnemonic[0] != 'f')
      break;
    switch (Mnemonic[1]) {
    default: break;
    case 'l':	 // 2 strings to match.
      if (memcmp(Mnemonic.data()+2, "dm", 2) != 0)
        break;
      switch (Mnemonic[4]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+5, "ax", 2) != 0)
          break;
        if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fldmeax"
          Mnemonic = "fldmdbx";
        return;
      case 'f':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+5, "dx", 2) != 0)
          break;
        if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fldmfdx"
          Mnemonic = "fldmiax";
        return;
      }
      break;
    case 's':	 // 2 strings to match.
      if (memcmp(Mnemonic.data()+2, "tm", 2) != 0)
        break;
      switch (Mnemonic[4]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+5, "ax", 2) != 0)
          break;
        if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fstmeax"
          Mnemonic = "fstmiax";
        return;
      case 'f':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+5, "dx", 2) != 0)
          break;
        if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "fstmfdx"
          Mnemonic = "fstmdbx";
        return;
      }
      break;
    case 't':	 // 4 strings to match.
      if (Mnemonic[2] != 'o')
        break;
      switch (Mnemonic[3]) {
      default: break;
      case 's':	 // 2 strings to match.
        if (memcmp(Mnemonic.data()+4, "iz", 2) != 0)
          break;
        switch (Mnemonic[6]) {
        default: break;
        case 'd':	 // 1 string to match.
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "ftosizd"
            Mnemonic = "vcvt.s32.f64";
          return;
        case 's':	 // 1 string to match.
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "ftosizs"
            Mnemonic = "vcvt.s32.f32";
          return;
        }
        break;
      case 'u':	 // 2 strings to match.
        if (memcmp(Mnemonic.data()+4, "iz", 2) != 0)
          break;
        switch (Mnemonic[6]) {
        default: break;
        case 'd':	 // 1 string to match.
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "ftouizd"
            Mnemonic = "vcvt.u32.f64";
          return;
        case 's':	 // 1 string to match.
          if ((Features & Feature_HasVFP2) == Feature_HasVFP2)	 // "ftouizs"
            Mnemonic = "vcvt.u32.f32";
          return;
        }
        break;
      }
      break;
    }
    break;
  case 8:	 // 5 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'q':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "subaddx", 7) != 0)
        break;
      Mnemonic = "qsax";	 // "qsubaddx"
      return;
    case 's':	 // 2 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "ddsubx", 6) != 0)
          break;
        Mnemonic = "sasx";	 // "saddsubx"
        return;
      case 's':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "ubaddx", 6) != 0)
          break;
        Mnemonic = "ssax";	 // "ssubaddx"
        return;
      }
      break;
    case 'u':	 // 2 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "ddsubx", 6) != 0)
          break;
        Mnemonic = "uasx";	 // "uaddsubx"
        return;
      case 's':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "ubaddx", 6) != 0)
          break;
        Mnemonic = "usax";	 // "usubaddx"
        return;
      }
      break;
    }
    break;
  case 9:	 // 8 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 's':	 // 2 strings to match.
      if (Mnemonic[1] != 'h')
        break;
      switch (Mnemonic[2]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+3, "ddsubx", 6) != 0)
          break;
        Mnemonic = "shasx";	 // "shaddsubx"
        return;
      case 's':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+3, "ubaddx", 6) != 0)
          break;
        Mnemonic = "shsax";	 // "shsubaddx"
        return;
      }
      break;
    case 'u':	 // 4 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'h':	 // 2 strings to match.
        switch (Mnemonic[2]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "ddsubx", 6) != 0)
            break;
          Mnemonic = "uhasx";	 // "uhaddsubx"
          return;
        case 's':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "ubaddx", 6) != 0)
            break;
          Mnemonic = "uhsax";	 // "uhsubaddx"
          return;
        }
        break;
      case 'q':	 // 2 strings to match.
        switch (Mnemonic[2]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "ddsubx", 6) != 0)
            break;
          Mnemonic = "uqasx";	 // "uqaddsubx"
          return;
        case 's':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "ubaddx", 6) != 0)
            break;
          Mnemonic = "uqsax";	 // "uqsubaddx"
          return;
        }
        break;
      }
      break;
    case 'v':	 // 2 strings to match.
      if (memcmp(Mnemonic.data()+1, "movq.f", 6) != 0)
        break;
      switch (Mnemonic[7]) {
      default: break;
      case '3':	 // 1 string to match.
        if (Mnemonic[8] != '2')
          break;
        if ((Features & Feature_HasNEON) == Feature_HasNEON)	 // "vmovq.f32"
          Mnemonic = "vmov.f32";
        return;
      case '6':	 // 1 string to match.
        if (Mnemonic[8] != '4')
          break;
        if ((Features & Feature_HasNEON) == Feature_HasNEON)	 // "vmovq.f64"
          Mnemonic = "vmov.f64";
        return;
      }
      break;
    }
    break;
  case 11:	 // 2 strings to match.
    if (memcmp(Mnemonic.data()+0, "vrecpeq.", 8) != 0)
      break;
    switch (Mnemonic[8]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+9, "32", 2) != 0)
        break;
      if ((Features & Feature_HasNEON) == Feature_HasNEON)	 // "vrecpeq.f32"
        Mnemonic = "vrecpe.f32";
      return;
    case 'u':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+9, "32", 2) != 0)
        break;
      if ((Features & Feature_HasNEON) == Feature_HasNEON)	 // "vrecpeq.u32"
        Mnemonic = "vrecpe.u32";
      return;
    }
    break;
  }
}

enum {
  Tie0_1_1,
  Tie0_2_2,
  Tie0_3_3,
  Tie0_4_4,
  Tie0_4_5,
  Tie1_1_1,
  Tie1_3_3,
  Tie1_4_4,
  Tie2_4_4,
};

static const uint8_t TiedAsmOperandTable[][3] = {
  /* Tie0_1_1 */ { 0, 1, 1 },
  /* Tie0_2_2 */ { 0, 2, 2 },
  /* Tie0_3_3 */ { 0, 3, 3 },
  /* Tie0_4_4 */ { 0, 4, 4 },
  /* Tie0_4_5 */ { 0, 4, 5 },
  /* Tie1_1_1 */ { 1, 1, 1 },
  /* Tie1_3_3 */ { 1, 3, 3 },
  /* Tie1_4_4 */ { 1, 4, 4 },
  /* Tie2_4_4 */ { 2, 4, 4 },
};

namespace {
enum OperatorConversionKind {
  CVT_Done,
  CVT_Reg,
  CVT_Tied,
  CVT_95_Reg,
  CVT_95_addCCOutOperands,
  CVT_95_addCondCodeOperands,
  CVT_95_addRegShiftedRegOperands,
  CVT_95_addModImmOperands,
  CVT_95_addModImmNotOperands,
  CVT_95_addRegShiftedImmOperands,
  CVT_95_addImmOperands,
  CVT_95_addT2SOImmNotOperands,
  CVT_95_addImm0_95_508s4Operands,
  CVT_regSP,
  CVT_95_addImm0_95_508s4NegOperands,
  CVT_95_addImm0_95_4095NegOperands,
  CVT_95_addThumbModImmNeg8_95_255Operands,
  CVT_95_addT2SOImmNegOperands,
  CVT_95_addModImmNegOperands,
  CVT_95_addImm0_95_1020s4Operands,
  CVT_95_addThumbModImmNeg1_95_7Operands,
  CVT_95_addUnsignedOffset_95_b8s2Operands,
  CVT_95_addAdrLabelOperands,
  CVT_95_addARMBranchTargetOperands,
  CVT_cvtThumbBranches,
  CVT_95_addBitfieldOperands,
  CVT_imm_95_0,
  CVT_95_addThumbBranchTargetOperands,
  CVT_95_addCoprocNumOperands,
  CVT_95_addCoprocRegOperands,
  CVT_95_addProcIFlagsOperands,
  CVT_imm_95_20,
  CVT_imm_95_12,
  CVT_imm_95_15,
  CVT_95_addMemBarrierOptOperands,
  CVT_imm_95_16,
  CVT_95_addFPImmOperands,
  CVT_95_addDPRRegListOperands,
  CVT_imm_95_1,
  CVT_95_addInstSyncBarrierOptOperands,
  CVT_95_addITCondCodeOperands,
  CVT_95_addITMaskOperands,
  CVT_95_addMemNoOffsetOperands,
  CVT_95_addAddrMode5Operands,
  CVT_95_addCoprocOptionOperands,
  CVT_95_addPostIdxImm8s4Operands,
  CVT_95_addRegListOperands,
  CVT_95_addThumbMemPCOperands,
  CVT_95_addConstPoolAsmImmOperands,
  CVT_95_addMemThumbRIs4Operands,
  CVT_95_addMemThumbRROperands,
  CVT_95_addMemThumbSPIOperands,
  CVT_95_addMemImm12OffsetOperands,
  CVT_95_addMemNegImm8OffsetOperands,
  CVT_95_addMemRegOffsetOperands,
  CVT_95_addMemUImm12OffsetOperands,
  CVT_95_addT2MemRegOffsetOperands,
  CVT_95_addMemPCRelImm12Operands,
  CVT_95_addMemImm8OffsetOperands,
  CVT_95_addAM2OffsetImmOperands,
  CVT_95_addPostIdxRegShiftedOperands,
  CVT_95_addMemThumbRIs1Operands,
  CVT_95_addMemPosImm8OffsetOperands,
  CVT_95_addMemImm8s4OffsetOperands,
  CVT_95_addAddrMode3Operands,
  CVT_95_addAM3OffsetOperands,
  CVT_95_addMemImm0_95_1020s4OffsetOperands,
  CVT_95_addMemThumbRIs2Operands,
  CVT_95_addPostIdxRegOperands,
  CVT_95_addPostIdxImm8Operands,
  CVT_reg0,
  CVT_regCPSR,
  CVT_imm_95_14,
  CVT_95_addBankedRegOperands,
  CVT_95_addMSRMaskOperands,
  CVT_cvtThumbMultiply,
  CVT_regR8,
  CVT_regR0,
  CVT_95_addPKHASRImmOperands,
  CVT_95_addImm1_95_32Operands,
  CVT_imm_95_4,
  CVT_imm_95_5,
  CVT_95_addShifterImmOperands,
  CVT_95_addImm1_95_16Operands,
  CVT_95_addRotImmOperands,
  CVT_95_addMemTBBOperands,
  CVT_95_addMemTBHOperands,
  CVT_95_addTraceSyncBarrierOptOperands,
  CVT_95_addNEONi16splatNotOperands,
  CVT_95_addNEONi32splatNotOperands,
  CVT_95_addNEONi16splatOperands,
  CVT_95_addNEONi32splatOperands,
  CVT_95_addComplexRotationOddOperands,
  CVT_95_addComplexRotationEvenOperands,
  CVT_95_addVectorIndex64Operands,
  CVT_95_addVectorIndex32Operands,
  CVT_95_addFBits16Operands,
  CVT_95_addFBits32Operands,
  CVT_95_addVectorIndex16Operands,
  CVT_95_addVectorIndex8Operands,
  CVT_95_addVecListOperands,
  CVT_95_addDupAlignedMemory16Operands,
  CVT_95_addAlignedMemory64or128Operands,
  CVT_95_addAlignedMemory64or128or256Operands,
  CVT_95_addAlignedMemory64Operands,
  CVT_95_addVecListIndexedOperands,
  CVT_95_addAlignedMemory16Operands,
  CVT_95_addDupAlignedMemory32Operands,
  CVT_95_addAlignedMemory32Operands,
  CVT_95_addDupAlignedMemoryNoneOperands,
  CVT_95_addAlignedMemoryNoneOperands,
  CVT_95_addAlignedMemoryOperands,
  CVT_95_addDupAlignedMemory64Operands,
  CVT_95_addDupAlignedMemory64or128Operands,
  CVT_95_addSPRRegListOperands,
  CVT_95_addAddrMode5FP16Operands,
  CVT_95_addNEONi32vmovOperands,
  CVT_95_addNEONvmovi8ReplicateOperands,
  CVT_95_addNEONvmovi16ReplicateOperands,
  CVT_95_addNEONi32vmovNegOperands,
  CVT_95_addNEONvmovi32ReplicateOperands,
  CVT_95_addNEONi64splatOperands,
  CVT_95_addNEONi8splatOperands,
  CVT_95_addNEONinvi8ReplicateOperands,
  CVT_imm_95_2,
  CVT_imm_95_3,
  CVT_NUM_CONVERTERS
};

enum InstructionConversionKind {
  Convert_NoOperands,
  Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1,
  Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_2__ModImmNot1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__ModImmNot1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_4__RegShiftedImm2_5__CondCode2_1__CCOut1_0,
  Convert__Reg1_1__Tie0_1_1__Reg1_2__CondCode2_0,
  Convert__Reg1_1__Tie0_1_1__Imm0_508s41_2__CondCode2_0,
  Convert__regSP__Tie0_1_1__Imm0_508s4Neg1_2__CondCode2_0,
  Convert__Reg1_1__Reg1_1__Imm0_40951_2__CondCode2_0,
  Convert__Reg1_1__Reg1_1__Imm0_4095Neg1_2__CondCode2_0,
  Convert__Reg1_2__CCOut1_0__Reg1_2__Reg1_3__CondCode2_1,
  Convert__Reg1_2__CCOut1_0__Tie0_1_1__Imm0_2551_3__CondCode2_1,
  Convert__Reg1_2__CCOut1_0__Tie0_3_3__ThumbModImmNeg8_2551_3__CondCode2_1,
  Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_2__T2SOImmNeg1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_2__ModImmNeg1_3__CondCode2_1__CCOut1_0,
  Convert__regSP__Tie0_1_1__Imm0_508s41_3__CondCode2_0,
  Convert__regSP__Tie0_1_1__Imm0_508s4Neg1_3__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Imm0_1020s41_3__CondCode2_0,
  Convert__Reg1_1__Imm0_40951_3__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Imm0_40951_3__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Imm0_4095Neg1_3__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0,
  Convert__Reg1_3__Reg1_3__T2SOImmNeg1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__CCOut1_0__Reg1_3__Reg1_4__CondCode2_1,
  Convert__Reg1_2__CCOut1_0__Reg1_3__Imm0_71_4__CondCode2_1,
  Convert__Reg1_2__CCOut1_0__Reg1_3__ThumbModImmNeg1_71_4__CondCode2_1,
  Convert__Reg1_2__Reg1_3__T2SOImmNeg1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__ModImmNeg1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_4__T2SOImm1_5__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_4__T2SOImmNeg1_5__CondCode2_1__CCOut1_0,
  Convert__Reg1_1__Reg1_2__T2SOImmNeg1_3__CondCode2_0,
  Convert__Reg1_1__UnsignedOffset_b8s21_2__CondCode2_0,
  Convert__Reg1_1__Imm1_2__CondCode2_0,
  Convert__Reg1_1__AdrLabel1_2__CondCode2_0,
  Convert__Reg1_2__Imm1_3__CondCode2_0,
  Convert__Reg1_1__Tie0_1_1__Reg1_2,
  Convert__Reg1_1__Reg1_2,
  Convert__Reg1_2__Reg1_2__T2SOImmNot1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_4__T2SOImmNot1_5__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__CCOut1_0__Reg1_2__ImmThumbSR1_3__CondCode2_1,
  Convert__Reg1_2__Reg1_2__ImmThumbSR1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_2__Imm0_321_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_3__ImmThumbSR1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__CCOut1_0__Reg1_3__ImmThumbSR1_4__CondCode2_1,
  Convert__Reg1_2__Reg1_3__ImmThumbSR1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__Imm0_321_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_4__ImmThumbSR1_5__CondCode2_1__CCOut1_0,
  Convert__ARMBranchTarget1_1__CondCode2_0,
  ConvertCustom_cvtThumbBranches,
  Convert__Reg1_1__Tie0_1_1__Bitfield1_2__CondCode2_0,
  Convert__Reg1_1__Tie0_1_1__Reg1_2__Bitfield1_3__CondCode2_0,
  Convert__imm_95_0,
  Convert__Imm0_2551_0,
  Convert__Imm0_655351_0,
  Convert__ARMBranchTarget1_0,
  Convert__CondCode2_0__ThumbBranchTarget1_1,
  Convert__Reg1_0,
  Convert__ThumbBranchTarget1_0,
  Convert__Reg1_1__CondCode2_0,
  Convert__CondCode2_0__Reg1_1,
  Convert__CondCode2_0__ARMBranchTarget1_1,
  Convert__CondCode2_0,
  Convert__Reg1_0__ThumbBranchTarget1_1,
  Convert__CoprocNum1_1__Imm0_151_2__CoprocReg1_3__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0,
  Convert__CoprocNum1_0__Imm0_151_1__CoprocReg1_2__CoprocReg1_3__CoprocReg1_4__Imm0_71_5,
  Convert__Reg1_1__Reg1_2__CondCode2_0,
  Convert__Reg1_1__ModImmNeg1_2__CondCode2_0,
  Convert__Reg1_1__T2SOImmNeg1_2__CondCode2_0,
  Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0,
  Convert__Reg1_1__RegShiftedReg3_2__CondCode2_0,
  Convert__Reg1_1__T2SOImm1_2__CondCode2_0,
  Convert__Reg1_1__ModImm1_2__CondCode2_0,
  Convert__Reg1_2__Reg1_3__CondCode2_0,
  Convert__Reg1_2__RegShiftedImm2_3__CondCode2_0,
  Convert__Reg1_2__T2SOImm1_3__CondCode2_0,
  Convert__Reg1_1__Imm0_2551_2__CondCode2_0,
  Convert__Imm0_311_0,
  Convert__Imm0_311_1,
  Convert__Imm1_0__ProcIFlags1_1,
  Convert__Imm1_0__ProcIFlags1_2,
  Convert__Imm1_0__ProcIFlags1_1__Imm0_311_2,
  Convert__Imm1_0__ProcIFlags1_1__Imm1_2,
  Convert__Imm1_0__ProcIFlags1_2__Imm1_3,
  Convert__Reg1_0__Reg1_1__Reg1_2,
  Convert__imm_95_20__CondCode2_0,
  Convert__Imm0_151_1__CondCode2_0,
  Convert__imm_95_12,
  Convert__imm_95_12__CondCode2_0,
  Convert__imm_95_15,
  Convert__imm_95_15__CondCode2_0,
  Convert__MemBarrierOpt1_0,
  Convert__MemBarrierOpt1_1__CondCode2_0,
  Convert__imm_95_0__CondCode2_0,
  Convert__imm_95_16__CondCode2_0,
  Convert__Reg1_1__FPImm1_2__CondCode2_0,
  Convert__Reg1_1__Tie0_2_2__CondCode2_0__DPRRegList1_3,
  Convert__Reg1_1__CondCode2_0__DPRRegList1_2,
  Convert__Reg1_1__Tie0_2_2__Reg1_2__imm_95_1__CondCode2_0,
  Convert__Reg1_1__Tie0_2_2__Reg1_2__imm_95_0__CondCode2_0,
  Convert__Imm0_2391_1__CondCode2_0,
  Convert__Imm0_2391_2__CondCode2_0,
  Convert__Imm0_631_0,
  Convert__Imm0_655351_1,
  Convert__InstSyncBarrierOpt1_0,
  Convert__InstSyncBarrierOpt1_1__CondCode2_0,
  Convert__ITCondCode1_1__ITMask1_0,
  Convert__Reg1_1__MemNoOffset1_2__CondCode2_0,
  Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0,
  Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0,
  Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0,
  Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0,
  Convert__CoprocNum1_0__CoprocReg1_1__AddrMode52_2,
  Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__CoprocOption1_3,
  Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__PostIdxImm8s41_3,
  Convert__Reg1_1__CondCode2_0__RegList1_2,
  Convert__Reg1_2__CondCode2_0__RegList1_3,
  Convert__Reg1_1__CondCode2_0__RegList1_3,
  Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3,
  Convert__Reg1_2__Tie0_3_3__CondCode2_0__RegList1_4,
  Convert__Reg1_1__ThumbMemPC1_2__CondCode2_0,
  Convert__Reg1_1__ConstPoolAsmImm1_2__CondCode2_0,
  Convert__Reg1_1__MemThumbRIs42_2__CondCode2_0,
  Convert__Reg1_1__MemThumbRR2_2__CondCode2_0,
  Convert__Reg1_1__MemThumbSPI2_2__CondCode2_0,
  Convert__Reg1_1__MemImm12Offset2_2__CondCode2_0,
  Convert__Reg1_1__MemNegImm8Offset2_2__CondCode2_0,
  Convert__Reg1_1__MemRegOffset3_2__CondCode2_0,
  Convert__Reg1_1__MemUImm12Offset2_2__CondCode2_0,
  Convert__Reg1_1__T2MemRegOffset3_2__CondCode2_0,
  Convert__Reg1_1__MemPCRelImm121_2__CondCode2_0,
  Convert__Reg1_2__ConstPoolAsmImm1_3__CondCode2_0,
  Convert__Reg1_2__MemUImm12Offset2_3__CondCode2_0,
  Convert__Reg1_2__T2MemRegOffset3_3__CondCode2_0,
  Convert__Reg1_2__MemPCRelImm121_3__CondCode2_0,
  Convert__Reg1_1__imm_95_0__MemImm12Offset2_2__CondCode2_0,
  Convert__Reg1_1__imm_95_0__MemImm8Offset2_2__CondCode2_0,
  Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__AM2OffsetImm2_3__CondCode2_0,
  Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__Imm1_3__CondCode2_0,
  Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxRegShifted2_3__CondCode2_0,
  Convert__Reg1_1__imm_95_0__MemRegOffset3_2__CondCode2_0,
  Convert__Reg1_1__MemThumbRIs12_2__CondCode2_0,
  Convert__Reg1_1__MemPosImm8Offset2_2__CondCode2_0,
  Convert__Reg1_1__Reg1_2__MemImm8s4Offset2_3__CondCode2_0,
  Convert__Reg1_1__Reg1_2__AddrMode33_3__CondCode2_0,
  Convert__Reg1_1__Reg1_2__imm_95_0__MemImm8s4Offset2_3__CondCode2_0,
  Convert__Reg1_1__Reg1_2__MemNoOffset1_3__Tie2_4_4__Imm1_4__CondCode2_0,
  Convert__Reg1_1__Reg1_2__imm_95_0__AddrMode33_3__CondCode2_0,
  Convert__Reg1_1__Reg1_2__MemNoOffset1_3__Tie2_4_4__AM3Offset2_4__CondCode2_0,
  Convert__Reg1_1__MemImm0_1020s4Offset2_2__CondCode2_0,
  Convert__Reg1_1__MemThumbRIs22_2__CondCode2_0,
  Convert__Reg1_1__AddrMode33_2__CondCode2_0,
  Convert__Reg1_1__imm_95_0__AddrMode33_2__CondCode2_0,
  Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__AM3Offset2_3__CondCode2_0,
  Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxReg2_3__CondCode2_0,
  Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxImm81_3__CondCode2_0,
  Convert__Reg1_2__CCOut1_0__Reg1_2__Imm0_311_3__CondCode2_1,
  Convert__Reg1_2__Reg1_2__Imm1_311_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_2__Imm0_311_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_3__Imm1_311_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__CCOut1_0__Reg1_3__Imm0_311_4__CondCode2_1,
  Convert__Reg1_2__Reg1_3__Imm1_311_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__Imm0_311_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_4__Imm1_311_5__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0,
  Convert__CoprocNum1_1__Imm0_71_2__Reg1_3__CoprocReg1_4__CoprocReg1_5__imm_95_0__CondCode2_0,
  Convert__CoprocNum1_1__Imm0_71_2__Reg1_3__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0,
  Convert__CoprocNum1_0__Imm0_71_1__Reg1_2__CoprocReg1_3__CoprocReg1_4__imm_95_0,
  Convert__CoprocNum1_0__Imm0_71_1__Reg1_2__CoprocReg1_3__CoprocReg1_4__Imm0_71_5,
  Convert__CoprocNum1_1__Imm0_151_2__Reg1_3__Reg1_4__CoprocReg1_5__CondCode2_0,
  Convert__CoprocNum1_0__Imm0_151_1__Reg1_2__Reg1_3__CoprocReg1_4,
  Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0,
  Convert__Reg1_1__Imm256_65535Expr1_2__CondCode2_0,
  Convert__Reg1_1__T2SOImm1_2__CondCode2_0__reg0,
  Convert__Reg1_1__T2SOImmNot1_2__CondCode2_0__reg0,
  Convert__Reg1_1__Imm0_65535Expr1_2__CondCode2_0,
  Convert__Reg1_2__CCOut1_0__Imm0_2551_3__CondCode2_1,
  Convert__Reg1_2__ModImmNot1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__RegShiftedReg3_3__CondCode2_0,
  Convert__Reg1_2__T2SOImm1_3__CondCode2_0__reg0,
  Convert__Reg1_2__Reg1_3__CondCode2_0__reg0,
  Convert__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_0__Reg1_1,
  Convert__Reg1_0__regCPSR__Imm0_2551_1__imm_95_14__imm_95_0,
  Convert__Reg1_1__T2SOImm1_2__CondCode2_0__regCPSR,
  Convert__Reg1_1__Reg1_2__CondCode2_0__regCPSR,
  Convert__Reg1_2__T2SOImm1_3__CondCode2_0__regCPSR,
  Convert__Reg1_2__Reg1_3__CondCode2_0__regCPSR,
  Convert__Reg1_1__Tie0_1_1__Imm0_65535Expr1_2__CondCode2_0,
  Convert__Reg1_3__CoprocNum1_1__Imm0_71_2__CoprocReg1_4__CoprocReg1_5__imm_95_0__CondCode2_0,
  Convert__Reg1_3__CoprocNum1_1__Imm0_71_2__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0,
  Convert__Reg1_2__CoprocNum1_0__Imm0_71_1__CoprocReg1_3__CoprocReg1_4__imm_95_0,
  Convert__Reg1_2__CoprocNum1_0__Imm0_71_1__CoprocReg1_3__CoprocReg1_4__Imm0_71_5,
  Convert__Reg1_3__Reg1_4__CoprocNum1_1__Imm0_151_2__CoprocReg1_5__CondCode2_0,
  Convert__Reg1_2__Reg1_3__CoprocNum1_0__Imm0_151_1__CoprocReg1_4,
  Convert__Reg1_1__BankedReg1_2__CondCode2_0,
  Convert__Reg1_1__MSRMask1_2__CondCode2_0,
  Convert__BankedReg1_1__Reg1_2__CondCode2_0,
  Convert__MSRMask1_1__Reg1_2__CondCode2_0,
  Convert__MSRMask1_1__ModImm1_2__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Reg1_1__CondCode2_0,
  ConvertCustom_cvtThumbMultiply,
  Convert__Reg1_2__CCOut1_0__Reg1_3__CondCode2_1,
  Convert__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__T2SOImmNot1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__imm_95_0__CondCode2_1__CCOut1_0,
  Convert__regR8__regR8__imm_95_14__imm_95_0,
  Convert__regR0__regR0__CondCode2_0__reg0,
  Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Reg1_3__PKHLSLImm1_4__CondCode2_0,
  Convert__Reg1_1__Reg1_3__Reg1_2__imm_95_0__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Reg1_3__PKHASRImm1_4__CondCode2_0,
  Convert__MemImm12Offset2_0,
  Convert__MemRegOffset3_0,
  Convert__Imm1_1__CondCode2_0,
  Convert__MemNegImm8Offset2_1__CondCode2_0,
  Convert__MemUImm12Offset2_1__CondCode2_0,
  Convert__T2MemRegOffset3_1__CondCode2_0,
  Convert__MemPCRelImm121_1__CondCode2_0,
  Convert__CondCode2_0__RegList1_1,
  Convert__regSP__Tie0_1_1__CondCode2_0__RegList1_1,
  Convert__regSP__Tie0_1_1__CondCode2_0__RegList1_2,
  Convert__Reg1_3__Reg1_3__Imm0_311_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_4__Imm0_311_5__CondCode2_1__CCOut1_0,
  Convert__Reg1_1__Reg1_2__Imm0_311_3__Imm1_321_4__CondCode2_0,
  Convert__SetEndImm1_0,
  Convert__Imm0_11_0,
  Convert__imm_95_4__CondCode2_0,
  Convert__imm_95_5__CondCode2_0,
  Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3,
  Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__Tie0_1_1__Tie1_1_1__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__Tie0_3_3__Tie1_4_4__CondCode2_1__CCOut1_0,
  Convert__Imm0_311_2,
  Convert__Imm0_311_1__CondCode2_0,
  Convert__Imm0_311_2__CondCode2_0,
  Convert__Imm0_311_3__CondCode2_0,
  Convert__Reg1_1__Imm1_321_2__Reg1_3__imm_95_0__CondCode2_0,
  Convert__Reg1_1__Imm1_321_2__Reg1_3__ShifterImm1_4__CondCode2_0,
  Convert__Reg1_1__Imm1_161_2__Reg1_3__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Reg1_3__MemNoOffset1_4__CondCode2_0,
  Convert__imm_95_0__Reg1_1__MemImm8Offset2_2__CondCode2_0,
  Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__Imm1_3__CondCode2_0,
  Convert__imm_95_0__Reg1_1__MemImm12Offset2_2__CondCode2_0,
  Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__AM2OffsetImm2_3__CondCode2_0,
  Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxRegShifted2_3__CondCode2_0,
  Convert__imm_95_0__Reg1_1__MemRegOffset3_2__CondCode2_0,
  Convert__Reg1_1__MemImm8Offset2_2__CondCode2_0,
  Convert__imm_95_0__Reg1_1__Reg1_2__MemImm8s4Offset2_3__CondCode2_0,
  Convert__MemNoOffset1_3__Reg1_1__Reg1_2__Tie0_4_4__Imm1_4__CondCode2_0,
  Convert__imm_95_0__Reg1_1__Reg1_2__AddrMode33_3__CondCode2_0,
  Convert__MemNoOffset1_3__Reg1_1__Reg1_2__Tie0_4_4__AM3Offset2_4__CondCode2_0,
  Convert__Reg1_1__Reg1_2__MemImm0_1020s4Offset2_3__CondCode2_0,
  Convert__imm_95_0__Reg1_1__AddrMode33_2__CondCode2_0,
  Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__AM3Offset2_3__CondCode2_0,
  Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxImm81_3__CondCode2_0,
  Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxReg2_3__CondCode2_0,
  Convert__Imm0_2551_3__CondCode2_0,
  Convert__Imm0_2551_1__CondCode2_0,
  Convert__Imm24bit1_1__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0,
  Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0,
  Convert__Reg1_2__Reg1_3__imm_95_0__CondCode2_0,
  Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0,
  Convert__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0,
  Convert__MemTBB2_1__CondCode2_0,
  Convert__MemTBH2_1__CondCode2_0,
  Convert__TraceSyncBarrierOpt1_0,
  Convert__TraceSyncBarrierOpt1_1__CondCode2_0,
  Convert__Reg1_1__Imm0_311_2__Reg1_3__imm_95_0__CondCode2_0,
  Convert__Reg1_1__Imm0_311_2__Reg1_3__ShifterImm1_4__CondCode2_0,
  Convert__Reg1_1__Imm0_151_2__Reg1_3__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Reg1_2__CondCode2_0,
  Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0,
  Convert__Reg1_1__Reg1_1__Reg1_2__CondCode2_0,
  Convert__Reg1_2__NEONi16splatNot1_3__Tie0_3_3__CondCode2_0,
  Convert__Reg1_2__NEONi32splatNot1_3__Tie0_3_3__CondCode2_0,
  Convert__Reg1_2__NEONi16splat1_3__Tie0_1_1__CondCode2_0,
  Convert__Reg1_2__NEONi32splat1_3__Tie0_1_1__CondCode2_0,
  Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__CondCode2_0,
  Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Reg1_3__ComplexRotationOdd1_4,
  Convert__Reg1_2__Reg1_2__CondCode2_0,
  Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__ComplexRotationEven1_4,
  Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__VectorIndex641_4__ComplexRotationEven1_5,
  Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__VectorIndex321_4__ComplexRotationEven1_5,
  Convert__Reg1_2__CondCode2_0,
  Convert__Reg1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0,
  Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0,
  Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0,
  Convert__Reg1_2__Reg1_3,
  Convert__Reg1_2__Reg1_3__VectorIndex161_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__VectorIndex321_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__VectorIndex81_4__CondCode2_0,
  Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_151_4__CondCode2_0,
  Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_31_4__CondCode2_0,
  Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_11_4__CondCode2_0,
  Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_71_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_151_5__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_31_5__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_11_5__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_71_5__CondCode2_0,
  Convert__VecListDPairAllLanes1_2__DupAlignedMemory162_3__CondCode2_0,
  Convert__VecListDPair1_2__AlignedMemory64or1282_3__CondCode2_0,
  Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0,
  Convert__VecListOneDAllLanes1_2__DupAlignedMemory162_3__CondCode2_0,
  Convert__VecListOneD1_2__AlignedMemory642_3__CondCode2_0,
  Convert__VecListOneDHWordIndexed2_2__AlignedMemory162_3__CondCode2_0,
  Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0,
  Convert__VecListDPairAllLanes1_2__DupAlignedMemory322_3__CondCode2_0,
  Convert__VecListOneDAllLanes1_2__DupAlignedMemory322_3__CondCode2_0,
  Convert__VecListOneDWordIndexed2_2__AlignedMemory322_3__CondCode2_0,
  Convert__VecListDPairAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListOneDAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListOneDByteIndexed2_2__AlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory162_3__CondCode2_0,
  Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory162_3__Reg1_4__CondCode2_0,
  Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0,
  Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0,
  Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__CondCode2_0,
  Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0,
  Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory162_3__CondCode2_0,
  Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory162_3__Reg1_4__CondCode2_0,
  Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0,
  Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListOneDHWordIndexed2_2__AlignedMemory162_3__Reg1_4__CondCode2_0,
  Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0,
  Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory322_3__CondCode2_0,
  Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory322_3__Reg1_4__CondCode2_0,
  Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory322_3__CondCode2_0,
  Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory322_3__Reg1_4__CondCode2_0,
  Convert__VecListOneDWordIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0,
  Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0,
  Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0,
  Convert__VecListOneDByteIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0,
  Convert__Reg1_3__AlignedMemory2_8__Tie0_1_1__Imm1_5__CondCode2_0,
  Convert__Reg1_3__imm_95_0__AlignedMemory2_8__Imm1_9__Tie0_1_1__Imm1_5__CondCode2_0,
  Convert__Reg1_3__Reg1_8__Imm1_9__Tie0_1_1__Imm1_5__CondCode2_0,
  Convert__VecListDPairSpacedAllLanes1_2__DupAlignedMemory322_3__CondCode2_0,
  Convert__VecListDPairSpaced1_2__AlignedMemory64or1282_3__CondCode2_0,
  Convert__VecListTwoDHWordIndexed2_2__AlignedMemory322_3__CondCode2_0,
  Convert__VecListTwoQHWordIndexed2_2__AlignedMemory322_3__CondCode2_0,
  Convert__VecListDPairAllLanes1_2__DupAlignedMemory642_3__CondCode2_0,
  Convert__VecListDPairSpacedAllLanes1_2__DupAlignedMemory642_3__CondCode2_0,
  Convert__VecListTwoDWordIndexed2_2__AlignedMemory642_3__CondCode2_0,
  Convert__VecListTwoQWordIndexed2_2__AlignedMemory642_3__CondCode2_0,
  Convert__VecListDPairSpacedAllLanes1_2__DupAlignedMemory162_3__CondCode2_0,
  Convert__VecListTwoDByteIndexed2_2__AlignedMemory162_3__CondCode2_0,
  Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory322_3__CondCode2_0,
  Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory322_3__Reg1_4__CondCode2_0,
  Convert__VecListDPairSpaced1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0,
  Convert__VecListDPairSpaced1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0,
  Convert__VecListTwoDHWordIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0,
  Convert__VecListTwoQHWordIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0,
  Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory642_3__CondCode2_0,
  Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory642_3__CondCode2_0,
  Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListTwoDWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListTwoQWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory162_3__CondCode2_0,
  Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory162_3__Reg1_4__CondCode2_0,
  Convert__VecListTwoDByteIndexed2_2__AlignedMemory162_3__Reg1_4__CondCode2_0,
  Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListThreeDHWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListThreeQ1_2__AlignedMemory642_3__CondCode2_0,
  Convert__VecListThreeQHWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListThreeDWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListThreeQWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListThreeDByteIndexed2_2__AlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0,
  Convert__VecListThreeD1_2__AlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListThreeDHWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0,
  Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0,
  Convert__VecListThreeQ1_2__AlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListThreeQHWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0,
  Convert__VecListThreeDWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0,
  Convert__VecListThreeQWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0,
  Convert__VecListThreeDByteIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0,
  Convert__Reg1_3__Reg1_4__Reg1_5__AlignedMemory2_7__CondCode2_0,
  Convert__Reg1_3__Reg1_4__Reg1_5__imm_95_0__AlignedMemory2_7__Imm1_8__CondCode2_0,
  Convert__Reg1_3__Reg1_6__Reg1_9__AlignedMemory2_13__CondCode2_0,
  Convert__Reg1_3__Reg1_6__Reg1_9__imm_95_0__DupAlignedMemory642_13__Imm1_14__CondCode2_0,
  Convert__VecListFourDAllLanes1_2__DupAlignedMemory642_3__CondCode2_0,
  Convert__VecListFourDHWordIndexed2_2__AlignedMemory642_3__CondCode2_0,
  Convert__VecListFourQAllLanes1_2__DupAlignedMemory642_3__CondCode2_0,
  Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__CondCode2_0,
  Convert__VecListFourQHWordIndexed2_2__AlignedMemory642_3__CondCode2_0,
  Convert__VecListFourDAllLanes1_2__DupAlignedMemory64or1282_3__CondCode2_0,
  Convert__VecListFourDWordIndexed2_2__AlignedMemory64or1282_3__CondCode2_0,
  Convert__VecListFourQAllLanes1_2__DupAlignedMemory64or1282_3__CondCode2_0,
  Convert__VecListFourQWordIndexed2_2__AlignedMemory64or1282_3__CondCode2_0,
  Convert__VecListFourDAllLanes1_2__DupAlignedMemory322_3__CondCode2_0,
  Convert__VecListFourDByteIndexed2_2__AlignedMemory322_3__CondCode2_0,
  Convert__VecListFourQAllLanes1_2__DupAlignedMemory322_3__CondCode2_0,
  Convert__VecListFourDAllLanes1_2__DupAlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0,
  Convert__VecListFourDHWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListFourQAllLanes1_2__DupAlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0,
  Convert__VecListFourQHWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListFourDAllLanes1_2__DupAlignedMemory64or1282_3__Reg1_4__CondCode2_0,
  Convert__VecListFourDWordIndexed2_2__AlignedMemory64or1282_3__Reg1_4__CondCode2_0,
  Convert__VecListFourQAllLanes1_2__DupAlignedMemory64or1282_3__Reg1_4__CondCode2_0,
  Convert__VecListFourQWordIndexed2_2__AlignedMemory64or1282_3__Reg1_4__CondCode2_0,
  Convert__VecListFourDAllLanes1_2__DupAlignedMemory322_3__Reg1_4__CondCode2_0,
  Convert__VecListFourDByteIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0,
  Convert__VecListFourQAllLanes1_2__DupAlignedMemory322_3__Reg1_4__CondCode2_0,
  Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__AlignedMemory2_8__CondCode2_0,
  Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__imm_95_0__AlignedMemory2_8__Imm1_9__CondCode2_0,
  Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__AlignedMemory2_16__CondCode2_0,
  Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__imm_95_0__AlignedMemory2_16__Imm1_17__CondCode2_0,
  Convert__Reg1_1__Tie0_2_2__CondCode2_0__SPRRegList1_3,
  Convert__Reg1_1__CondCode2_0__SPRRegList1_2,
  Convert__Reg1_1__AddrMode52_2__CondCode2_0,
  Convert__Reg1_2__AddrMode5FP162_3__CondCode2_0,
  Convert__Reg1_2__AddrMode52_3__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Reg1_3,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Reg1_2__CondCode2_0,
  Convert__Reg1_2__FPImm1_3__CondCode2_0,
  Convert__Reg1_2__NEONi32vmov1_3__CondCode2_0,
  Convert__Reg1_2__NEONi16vmovi8Replicate1_3__CondCode2_0,
  Convert__Reg1_2__NEONi16splat1_3__CondCode2_0,
  Convert__Reg1_2__NEONi32vmovi8Replicate1_3__CondCode2_0,
  Convert__Reg1_2__NEONi32vmovi16Replicate1_3__CondCode2_0,
  Convert__Reg1_2__NEONi32vmovNeg1_3__CondCode2_0,
  Convert__Reg1_2__NEONi64vmovi8Replicate1_3__CondCode2_0,
  Convert__Reg1_2__NEONi64vmovi16Replicate1_3__CondCode2_0,
  Convert__Reg1_2__NEONi64vmovi32Replicate1_3__CondCode2_0,
  Convert__Reg1_2__NEONi64splat1_3__CondCode2_0,
  Convert__Reg1_2__NEONi8splat1_3__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Reg1_3__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__VectorIndex161_3__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__VectorIndex321_3__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__VectorIndex81_3__CondCode2_0,
  Convert__Reg1_2__Reg1_2__Reg1_3__VectorIndex321_4__CondCode2_0,
  Convert__Reg1_2__Reg1_2__Reg1_3__VectorIndex161_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0,
  Convert__Reg1_2__NEONi16invi8Replicate1_3__CondCode2_0,
  Convert__Reg1_2__NEONi32invi8Replicate1_3__CondCode2_0,
  Convert__Reg1_2__NEONi64invi8Replicate1_3__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__CondCode2_0,
  Convert__regSP__Tie0_1_1__CondCode2_0__DPRRegList1_1,
  Convert__regSP__Tie0_1_1__CondCode2_0__SPRRegList1_1,
  Convert__regSP__Tie0_1_1__CondCode2_0__DPRRegList1_2,
  Convert__regSP__Tie0_1_1__CondCode2_0__SPRRegList1_2,
  Convert__Reg1_2__Reg1_3__ShrImm81_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__ShrImm161_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__ShrImm321_4__CondCode2_0,
  Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0,
  Convert__Reg1_2__Reg1_2__ShrImm161_3__CondCode2_0,
  Convert__Reg1_2__Reg1_2__ShrImm321_3__CondCode2_0,
  Convert__Reg1_2__Reg1_2__ShrImm641_3__CondCode2_0,
  Convert__Reg1_2__Reg1_2__ShrImm81_3__CondCode2_0,
  Convert__Reg1_2__Reg1_3__ShrImm641_4__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm161_3__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm321_3__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm641_3__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm81_3__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm161_4__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm321_4__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm641_4__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm81_4__CondCode2_0,
  Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3,
  Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3__VectorIndex321_4,
  Convert__Reg1_2__Reg1_3__Imm1_151_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Imm1_311_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Imm1_71_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Imm161_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Imm321_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Imm81_4__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_2__Imm1_3__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__Imm1_4__CondCode2_0,
  Convert__AlignedMemory64or1282_3__VecListDPair1_2__CondCode2_0,
  Convert__AlignedMemory64or128or2562_3__VecListFourD1_2__CondCode2_0,
  Convert__AlignedMemory642_3__VecListOneD1_2__CondCode2_0,
  Convert__AlignedMemory642_3__VecListThreeD1_2__CondCode2_0,
  Convert__imm_95_0__AlignedMemory64or1282_3__VecListDPair1_2__CondCode2_0,
  Convert__imm_95_0__AlignedMemory64or1282_3__Reg1_4__VecListDPair1_2__CondCode2_0,
  Convert__imm_95_0__AlignedMemory64or128or2562_3__VecListFourD1_2__CondCode2_0,
  Convert__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__VecListFourD1_2__CondCode2_0,
  Convert__imm_95_0__AlignedMemory642_3__VecListOneD1_2__CondCode2_0,
  Convert__imm_95_0__AlignedMemory642_3__Reg1_4__VecListOneD1_2__CondCode2_0,
  Convert__imm_95_0__AlignedMemory642_3__VecListThreeD1_2__CondCode2_0,
  Convert__imm_95_0__AlignedMemory642_3__Reg1_4__VecListThreeD1_2__CondCode2_0,
  Convert__AlignedMemory2_8__Reg1_3__Imm1_5__CondCode2_0,
  Convert__imm_95_0__AlignedMemory2_8__Imm1_9__Reg1_3__Imm1_5__CondCode2_0,
  Convert__Reg1_8__Imm1_9__Reg1_3__Imm1_5__CondCode2_0,
  Convert__imm_95_0__Reg1_8__Imm1_9__Imm1_10__Reg1_3__Imm1_5__CondCode2_0,
  Convert__AlignedMemory64or1282_3__VecListDPairSpaced1_2__CondCode2_0,
  Convert__imm_95_0__AlignedMemory64or1282_3__VecListDPairSpaced1_2__CondCode2_0,
  Convert__imm_95_0__AlignedMemory64or1282_3__Reg1_4__VecListDPairSpaced1_2__CondCode2_0,
  Convert__AlignedMemory2_7__Reg1_3__Reg1_4__Reg1_5__CondCode2_0,
  Convert__imm_95_0__AlignedMemory2_7__Imm1_8__Reg1_3__Reg1_4__Reg1_5__CondCode2_0,
  Convert__AlignedMemory2_8__Reg1_3__Reg1_4__Reg1_5__Reg1_6__CondCode2_0,
  Convert__imm_95_0__AlignedMemory2_8__Imm1_9__Reg1_3__Reg1_4__Reg1_5__Reg1_6__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Tie0_1_1__Tie1_1_1__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Tie0_3_3__Tie1_4_4__CondCode2_0,
  Convert__Reg1_2__VecListDPair1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_2__VecListFourD1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_2__VecListOneD1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_2__VecListThreeD1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__VecListDPair1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__VecListFourD1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__VecListOneD1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__VecListThreeD1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__CondCode2_0,
  Convert__imm_95_2__CondCode2_0,
  Convert__imm_95_3__CondCode2_0,
  Convert__imm_95_1__CondCode2_0,
  CVT_NUM_SIGNATURES
};

} // end anonymous namespace

static const uint8_t ConversionTable[CVT_NUM_SIGNATURES][17] = {
  // Convert_NoOperands
  { CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addCondCodeOperands, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addRegShiftedRegOperands, 4, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addModImmOperands, 4, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__ModImmNot1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addModImmNotOperands, 4, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addRegShiftedImmOperands, 4, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addRegShiftedImmOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addT2SOImmNotOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addRegShiftedRegOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addModImmOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__ModImmNot1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addModImmNotOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__RegShiftedImm2_5__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addRegShiftedImmOperands, 6, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Imm0_508s41_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_addImm0_95_508s4Operands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__regSP__Tie0_1_1__Imm0_508s4Neg1_2__CondCode2_0
  { CVT_regSP, 0, CVT_Tied, Tie0_1_1, CVT_95_addImm0_95_508s4NegOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__Imm0_40951_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__Imm0_4095Neg1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImm0_95_4095NegOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Reg1_2__Reg1_3__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addCondCodeOperands, 2, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Tie0_1_1__Imm0_2551_3__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 2, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Tie0_3_3__ThumbModImmNeg8_2551_3__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands, 1, CVT_Tied, Tie0_3_3, CVT_95_addThumbModImmNeg8_95_255Operands, 4, CVT_95_addCondCodeOperands, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__T2SOImmNeg1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addT2SOImmNegOperands, 4, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__ModImmNeg1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addModImmNegOperands, 4, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__regSP__Tie0_1_1__Imm0_508s41_3__CondCode2_0
  { CVT_regSP, 0, CVT_Tied, Tie0_1_1, CVT_95_addImm0_95_508s4Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__regSP__Tie0_1_1__Imm0_508s4Neg1_3__CondCode2_0
  { CVT_regSP, 0, CVT_Tied, Tie0_1_1, CVT_95_addImm0_95_508s4NegOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Imm0_1020s41_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImm0_95_1020s4Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Imm0_40951_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Imm0_40951_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Imm0_4095Neg1_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImm0_95_4095NegOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_3__T2SOImmNeg1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 4, CVT_95_addT2SOImmNegOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Reg1_3__Reg1_4__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands, 1, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 2, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Reg1_3__Imm0_71_4__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Reg1_3__ThumbModImmNeg1_71_4__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands, 1, CVT_95_Reg, 4, CVT_95_addThumbModImmNeg1_95_7Operands, 5, CVT_95_addCondCodeOperands, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_3__T2SOImmNeg1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addT2SOImmNegOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__ModImmNeg1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addModImmNegOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__T2SOImm1_5__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__T2SOImmNeg1_5__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addT2SOImmNegOperands, 6, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__T2SOImmNeg1_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addT2SOImmNegOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__UnsignedOffset_b8s21_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addUnsignedOffset_95_b8s2Operands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Imm1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__AdrLabel1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addAdrLabelOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Imm1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_2
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_1__Reg1_2
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_2__T2SOImmNot1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addT2SOImmNotOperands, 4, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 4, CVT_95_addRegShiftedImmOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 4, CVT_95_addT2SOImmNotOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__T2SOImmNot1_5__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addT2SOImmNotOperands, 6, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Reg1_2__ImmThumbSR1_3__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands, 1, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_2__ImmThumbSR1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Imm0_321_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_3__ImmThumbSR1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Reg1_3__ImmThumbSR1_4__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_3__ImmThumbSR1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Imm0_321_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__ImmThumbSR1_5__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__ARMBranchTarget1_1__CondCode2_0
  { CVT_95_addARMBranchTargetOperands, 2, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // ConvertCustom_cvtThumbBranches
  { CVT_cvtThumbBranches, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Bitfield1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_addBitfieldOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_2__Bitfield1_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addBitfieldOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_0
  { CVT_imm_95_0, 0, CVT_Done },
  // Convert__Imm0_2551_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm0_655351_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ARMBranchTarget1_0
  { CVT_95_addARMBranchTargetOperands, 1, CVT_Done },
  // Convert__CondCode2_0__ThumbBranchTarget1_1
  { CVT_95_addCondCodeOperands, 1, CVT_95_addThumbBranchTargetOperands, 2, CVT_Done },
  // Convert__Reg1_0
  { CVT_95_Reg, 1, CVT_Done },
  // Convert__ThumbBranchTarget1_0
  { CVT_95_addThumbBranchTargetOperands, 1, CVT_Done },
  // Convert__Reg1_1__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__CondCode2_0__Reg1_1
  { CVT_95_addCondCodeOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__CondCode2_0__ARMBranchTarget1_1
  { CVT_95_addCondCodeOperands, 1, CVT_95_addARMBranchTargetOperands, 2, CVT_Done },
  // Convert__CondCode2_0
  { CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_0__ThumbBranchTarget1_1
  { CVT_95_Reg, 1, CVT_95_addThumbBranchTargetOperands, 2, CVT_Done },
  // Convert__CoprocNum1_1__Imm0_151_2__CoprocReg1_3__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0
  { CVT_95_addCoprocNumOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addCoprocRegOperands, 4, CVT_95_addCoprocRegOperands, 5, CVT_95_addCoprocRegOperands, 6, CVT_95_addImmOperands, 7, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__CoprocNum1_0__Imm0_151_1__CoprocReg1_2__CoprocReg1_3__CoprocReg1_4__Imm0_71_5
  { CVT_95_addCoprocNumOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addCoprocRegOperands, 3, CVT_95_addCoprocRegOperands, 4, CVT_95_addCoprocRegOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__ModImmNeg1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addModImmNegOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__T2SOImmNeg1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addT2SOImmNegOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addRegShiftedImmOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__RegShiftedReg3_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addRegShiftedRegOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__T2SOImm1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__ModImm1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addModImmOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__RegShiftedImm2_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addRegShiftedImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__T2SOImm1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Imm0_2551_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Imm0_311_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm0_311_1
  { CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Imm1_0__ProcIFlags1_1
  { CVT_95_addImmOperands, 1, CVT_95_addProcIFlagsOperands, 2, CVT_Done },
  // Convert__Imm1_0__ProcIFlags1_2
  { CVT_95_addImmOperands, 1, CVT_95_addProcIFlagsOperands, 3, CVT_Done },
  // Convert__Imm1_0__ProcIFlags1_1__Imm0_311_2
  { CVT_95_addImmOperands, 1, CVT_95_addProcIFlagsOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Imm1_0__ProcIFlags1_1__Imm1_2
  { CVT_95_addImmOperands, 1, CVT_95_addProcIFlagsOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Imm1_0__ProcIFlags1_2__Imm1_3
  { CVT_95_addImmOperands, 1, CVT_95_addProcIFlagsOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__imm_95_20__CondCode2_0
  { CVT_imm_95_20, 0, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Imm0_151_1__CondCode2_0
  { CVT_95_addImmOperands, 2, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_12
  { CVT_imm_95_12, 0, CVT_Done },
  // Convert__imm_95_12__CondCode2_0
  { CVT_imm_95_12, 0, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_15
  { CVT_imm_95_15, 0, CVT_Done },
  // Convert__imm_95_15__CondCode2_0
  { CVT_imm_95_15, 0, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__MemBarrierOpt1_0
  { CVT_95_addMemBarrierOptOperands, 1, CVT_Done },
  // Convert__MemBarrierOpt1_1__CondCode2_0
  { CVT_95_addMemBarrierOptOperands, 2, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_0__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_16__CondCode2_0
  { CVT_imm_95_16, 0, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__FPImm1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addFPImmOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__CondCode2_0__DPRRegList1_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addCondCodeOperands, 1, CVT_95_addDPRRegListOperands, 4, CVT_Done },
  // Convert__Reg1_1__CondCode2_0__DPRRegList1_2
  { CVT_95_Reg, 2, CVT_95_addCondCodeOperands, 1, CVT_95_addDPRRegListOperands, 3, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_2__imm_95_1__CondCode2_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 3, CVT_imm_95_1, 0, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_2__imm_95_0__CondCode2_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Imm0_2391_1__CondCode2_0
  { CVT_95_addImmOperands, 2, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Imm0_2391_2__CondCode2_0
  { CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Imm0_631_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm0_655351_1
  { CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__InstSyncBarrierOpt1_0
  { CVT_95_addInstSyncBarrierOptOperands, 1, CVT_Done },
  // Convert__InstSyncBarrierOpt1_1__CondCode2_0
  { CVT_95_addInstSyncBarrierOptOperands, 2, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__ITCondCode1_1__ITMask1_0
  { CVT_95_addITCondCodeOperands, 2, CVT_95_addITMaskOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemNoOffset1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemNoOffsetOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemNoOffsetOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0
  { CVT_95_addCoprocNumOperands, 2, CVT_95_addCoprocRegOperands, 3, CVT_95_addAddrMode5Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0
  { CVT_95_addCoprocNumOperands, 2, CVT_95_addCoprocRegOperands, 3, CVT_95_addMemNoOffsetOperands, 4, CVT_95_addCoprocOptionOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0
  { CVT_95_addCoprocNumOperands, 2, CVT_95_addCoprocRegOperands, 3, CVT_95_addMemNoOffsetOperands, 4, CVT_95_addPostIdxImm8s4Operands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__CoprocNum1_0__CoprocReg1_1__AddrMode52_2
  { CVT_95_addCoprocNumOperands, 1, CVT_95_addCoprocRegOperands, 2, CVT_95_addAddrMode5Operands, 3, CVT_Done },
  // Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__CoprocOption1_3
  { CVT_95_addCoprocNumOperands, 1, CVT_95_addCoprocRegOperands, 2, CVT_95_addMemNoOffsetOperands, 3, CVT_95_addCoprocOptionOperands, 4, CVT_Done },
  // Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__PostIdxImm8s41_3
  { CVT_95_addCoprocNumOperands, 1, CVT_95_addCoprocRegOperands, 2, CVT_95_addMemNoOffsetOperands, 3, CVT_95_addPostIdxImm8s4Operands, 4, CVT_Done },
  // Convert__Reg1_1__CondCode2_0__RegList1_2
  { CVT_95_Reg, 2, CVT_95_addCondCodeOperands, 1, CVT_95_addRegListOperands, 3, CVT_Done },
  // Convert__Reg1_2__CondCode2_0__RegList1_3
  { CVT_95_Reg, 3, CVT_95_addCondCodeOperands, 1, CVT_95_addRegListOperands, 4, CVT_Done },
  // Convert__Reg1_1__CondCode2_0__RegList1_3
  { CVT_95_Reg, 2, CVT_95_addCondCodeOperands, 1, CVT_95_addRegListOperands, 4, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addCondCodeOperands, 1, CVT_95_addRegListOperands, 4, CVT_Done },
  // Convert__Reg1_2__Tie0_3_3__CondCode2_0__RegList1_4
  { CVT_95_Reg, 3, CVT_Tied, Tie0_3_3, CVT_95_addCondCodeOperands, 1, CVT_95_addRegListOperands, 5, CVT_Done },
  // Convert__Reg1_1__ThumbMemPC1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addThumbMemPCOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__ConstPoolAsmImm1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addConstPoolAsmImmOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemThumbRIs42_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemThumbRIs4Operands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemThumbRR2_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemThumbRROperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemThumbSPI2_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemThumbSPIOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemImm12Offset2_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemImm12OffsetOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemNegImm8Offset2_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemNegImm8OffsetOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemRegOffset3_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemRegOffsetOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemUImm12Offset2_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemUImm12OffsetOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__T2MemRegOffset3_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addT2MemRegOffsetOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemPCRelImm121_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemPCRelImm12Operands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__ConstPoolAsmImm1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addConstPoolAsmImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__MemUImm12Offset2_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addMemUImm12OffsetOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__T2MemRegOffset3_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addT2MemRegOffsetOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__MemPCRelImm121_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addMemPCRelImm12Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__imm_95_0__MemImm12Offset2_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_95_addMemImm12OffsetOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__imm_95_0__MemImm8Offset2_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_95_addMemImm8OffsetOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__AM2OffsetImm2_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemNoOffsetOperands, 3, CVT_Tied, Tie1_3_3, CVT_95_addAM2OffsetImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__Imm1_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemNoOffsetOperands, 3, CVT_Tied, Tie1_3_3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxRegShifted2_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemNoOffsetOperands, 3, CVT_Tied, Tie1_3_3, CVT_95_addPostIdxRegShiftedOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__imm_95_0__MemRegOffset3_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_95_addMemRegOffsetOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemThumbRIs12_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemThumbRIs1Operands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemPosImm8Offset2_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemPosImm8OffsetOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__MemImm8s4Offset2_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemImm8s4OffsetOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__AddrMode33_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addAddrMode3Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__imm_95_0__MemImm8s4Offset2_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_95_addMemImm8s4OffsetOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__MemNoOffset1_3__Tie2_4_4__Imm1_4__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemNoOffsetOperands, 4, CVT_Tied, Tie2_4_4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__imm_95_0__AddrMode33_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_95_addAddrMode3Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__MemNoOffset1_3__Tie2_4_4__AM3Offset2_4__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemNoOffsetOperands, 4, CVT_Tied, Tie2_4_4, CVT_95_addAM3OffsetOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemImm0_1020s4Offset2_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemImm0_95_1020s4OffsetOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemThumbRIs22_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemThumbRIs2Operands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__AddrMode33_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addAddrMode3Operands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__imm_95_0__AddrMode33_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_95_addAddrMode3Operands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__AM3Offset2_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemNoOffsetOperands, 3, CVT_Tied, Tie1_3_3, CVT_95_addAM3OffsetOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxReg2_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemNoOffsetOperands, 3, CVT_Tied, Tie1_3_3, CVT_95_addPostIdxRegOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxImm81_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemNoOffsetOperands, 3, CVT_Tied, Tie1_3_3, CVT_95_addPostIdxImm8Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Reg1_2__Imm0_311_3__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands, 1, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Imm1_311_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Imm0_311_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_3__Imm1_311_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Reg1_3__Imm0_311_4__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Imm1_311_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Imm0_311_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__Imm1_311_5__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__CoprocNum1_1__Imm0_71_2__Reg1_3__CoprocReg1_4__CoprocReg1_5__imm_95_0__CondCode2_0
  { CVT_95_addCoprocNumOperands, 2, CVT_95_addImmOperands, 3, CVT_95_Reg, 4, CVT_95_addCoprocRegOperands, 5, CVT_95_addCoprocRegOperands, 6, CVT_imm_95_0, 0, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__CoprocNum1_1__Imm0_71_2__Reg1_3__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0
  { CVT_95_addCoprocNumOperands, 2, CVT_95_addImmOperands, 3, CVT_95_Reg, 4, CVT_95_addCoprocRegOperands, 5, CVT_95_addCoprocRegOperands, 6, CVT_95_addImmOperands, 7, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__CoprocNum1_0__Imm0_71_1__Reg1_2__CoprocReg1_3__CoprocReg1_4__imm_95_0
  { CVT_95_addCoprocNumOperands, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_95_addCoprocRegOperands, 4, CVT_95_addCoprocRegOperands, 5, CVT_imm_95_0, 0, CVT_Done },
  // Convert__CoprocNum1_0__Imm0_71_1__Reg1_2__CoprocReg1_3__CoprocReg1_4__Imm0_71_5
  { CVT_95_addCoprocNumOperands, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_95_addCoprocRegOperands, 4, CVT_95_addCoprocRegOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__CoprocNum1_1__Imm0_151_2__Reg1_3__Reg1_4__CoprocReg1_5__CondCode2_0
  { CVT_95_addCoprocNumOperands, 2, CVT_95_addImmOperands, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addCoprocRegOperands, 6, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__CoprocNum1_0__Imm0_151_1__Reg1_2__Reg1_3__CoprocReg1_4
  { CVT_95_addCoprocNumOperands, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addCoprocRegOperands, 5, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_1__Imm256_65535Expr1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__T2SOImm1_2__CondCode2_0__reg0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_reg0, 0, CVT_Done },
  // Convert__Reg1_1__T2SOImmNot1_2__CondCode2_0__reg0
  { CVT_95_Reg, 2, CVT_95_addT2SOImmNotOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_reg0, 0, CVT_Done },
  // Convert__Reg1_1__Imm0_65535Expr1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Imm0_2551_3__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands, 1, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 2, CVT_Done },
  // Convert__Reg1_2__ModImmNot1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_addModImmNotOperands, 4, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_addRegShiftedRegOperands, 4, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_addModImmOperands, 4, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_addRegShiftedImmOperands, 4, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__RegShiftedReg3_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addRegShiftedRegOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__T2SOImm1_3__CondCode2_0__reg0
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_reg0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_3__CondCode2_0__reg0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addCondCodeOperands, 1, CVT_reg0, 0, CVT_Done },
  // Convert__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__regCPSR__Imm0_2551_1__imm_95_14__imm_95_0
  { CVT_95_Reg, 1, CVT_regCPSR, 0, CVT_95_addImmOperands, 2, CVT_imm_95_14, 0, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__T2SOImm1_2__CondCode2_0__regCPSR
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_regCPSR, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_2__CondCode2_0__regCPSR
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addCondCodeOperands, 1, CVT_regCPSR, 0, CVT_Done },
  // Convert__Reg1_2__T2SOImm1_3__CondCode2_0__regCPSR
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_regCPSR, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_3__CondCode2_0__regCPSR
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addCondCodeOperands, 1, CVT_regCPSR, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Imm0_65535Expr1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_3__CoprocNum1_1__Imm0_71_2__CoprocReg1_4__CoprocReg1_5__imm_95_0__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_addCoprocNumOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addCoprocRegOperands, 5, CVT_95_addCoprocRegOperands, 6, CVT_imm_95_0, 0, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_3__CoprocNum1_1__Imm0_71_2__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_addCoprocNumOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addCoprocRegOperands, 5, CVT_95_addCoprocRegOperands, 6, CVT_95_addImmOperands, 7, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__CoprocNum1_0__Imm0_71_1__CoprocReg1_3__CoprocReg1_4__imm_95_0
  { CVT_95_Reg, 3, CVT_95_addCoprocNumOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addCoprocRegOperands, 4, CVT_95_addCoprocRegOperands, 5, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__CoprocNum1_0__Imm0_71_1__CoprocReg1_3__CoprocReg1_4__Imm0_71_5
  { CVT_95_Reg, 3, CVT_95_addCoprocNumOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addCoprocRegOperands, 4, CVT_95_addCoprocRegOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_3__Reg1_4__CoprocNum1_1__Imm0_151_2__CoprocReg1_5__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addCoprocNumOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addCoprocRegOperands, 6, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__CoprocNum1_0__Imm0_151_1__CoprocReg1_4
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addCoprocNumOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addCoprocRegOperands, 5, CVT_Done },
  // Convert__Reg1_1__BankedReg1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addBankedRegOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__MSRMask1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMSRMaskOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__BankedReg1_1__Reg1_2__CondCode2_0
  { CVT_95_addBankedRegOperands, 2, CVT_95_Reg, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__MSRMask1_1__Reg1_2__CondCode2_0
  { CVT_95_addMSRMaskOperands, 2, CVT_95_Reg, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__MSRMask1_1__ModImm1_2__CondCode2_0
  { CVT_95_addMSRMaskOperands, 2, CVT_95_addModImmOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_1__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // ConvertCustom_cvtThumbMultiply
  { CVT_cvtThumbMultiply, 0, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Reg1_3__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands, 1, CVT_95_Reg, 4, CVT_95_addCondCodeOperands, 2, CVT_Done },
  // Convert__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__T2SOImmNot1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_addT2SOImmNotOperands, 4, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_addRegShiftedImmOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__imm_95_0__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_imm_95_0, 0, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__regR8__regR8__imm_95_14__imm_95_0
  { CVT_regR8, 0, CVT_regR8, 0, CVT_imm_95_14, 0, CVT_imm_95_0, 0, CVT_Done },
  // Convert__regR0__regR0__CondCode2_0__reg0
  { CVT_regR0, 0, CVT_regR0, 0, CVT_95_addCondCodeOperands, 1, CVT_reg0, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_imm_95_0, 0, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3__PKHLSLImm1_4__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Reg1_2__imm_95_0__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3__PKHASRImm1_4__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addPKHASRImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__MemImm12Offset2_0
  { CVT_95_addMemImm12OffsetOperands, 1, CVT_Done },
  // Convert__MemRegOffset3_0
  { CVT_95_addMemRegOffsetOperands, 1, CVT_Done },
  // Convert__Imm1_1__CondCode2_0
  { CVT_95_addImmOperands, 2, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__MemNegImm8Offset2_1__CondCode2_0
  { CVT_95_addMemNegImm8OffsetOperands, 2, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__MemUImm12Offset2_1__CondCode2_0
  { CVT_95_addMemUImm12OffsetOperands, 2, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__T2MemRegOffset3_1__CondCode2_0
  { CVT_95_addT2MemRegOffsetOperands, 2, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__MemPCRelImm121_1__CondCode2_0
  { CVT_95_addMemPCRelImm12Operands, 2, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__CondCode2_0__RegList1_1
  { CVT_95_addCondCodeOperands, 1, CVT_95_addRegListOperands, 2, CVT_Done },
  // Convert__regSP__Tie0_1_1__CondCode2_0__RegList1_1
  { CVT_regSP, 0, CVT_Tied, Tie0_1_1, CVT_95_addCondCodeOperands, 1, CVT_95_addRegListOperands, 2, CVT_Done },
  // Convert__regSP__Tie0_1_1__CondCode2_0__RegList1_2
  { CVT_regSP, 0, CVT_Tied, Tie0_1_1, CVT_95_addCondCodeOperands, 1, CVT_95_addRegListOperands, 3, CVT_Done },
  // Convert__Reg1_3__Reg1_3__Imm0_311_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__Imm0_311_5__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Imm0_311_3__Imm1_321_4__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addImm1_95_32Operands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__SetEndImm1_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm0_11_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__imm_95_4__CondCode2_0
  { CVT_imm_95_4, 0, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_5__CondCode2_0
  { CVT_imm_95_5, 0, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__Tie0_1_1__Tie1_1_1__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__Tie0_3_3__Tie1_4_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_Tied, Tie0_3_3, CVT_Tied, Tie1_4_4, CVT_95_addCondCodeOperands, 2, CVT_95_addCCOutOperands, 1, CVT_Done },
  // Convert__Imm0_311_2
  { CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Imm0_311_1__CondCode2_0
  { CVT_95_addImmOperands, 2, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Imm0_311_2__CondCode2_0
  { CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Imm0_311_3__CondCode2_0
  { CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Imm1_321_2__Reg1_3__imm_95_0__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImm1_95_32Operands, 3, CVT_95_Reg, 4, CVT_imm_95_0, 0, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Imm1_321_2__Reg1_3__ShifterImm1_4__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImm1_95_32Operands, 3, CVT_95_Reg, 4, CVT_95_addShifterImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Imm1_161_2__Reg1_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImm1_95_16Operands, 3, CVT_95_Reg, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3__MemNoOffset1_4__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addMemNoOffsetOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_1__MemImm8Offset2_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 2, CVT_95_addMemImm8OffsetOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__Imm1_3__CondCode2_0
  { CVT_95_addMemNoOffsetOperands, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_1__MemImm12Offset2_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 2, CVT_95_addMemImm12OffsetOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__AM2OffsetImm2_3__CondCode2_0
  { CVT_95_addMemNoOffsetOperands, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_95_addAM2OffsetImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxRegShifted2_3__CondCode2_0
  { CVT_95_addMemNoOffsetOperands, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_95_addPostIdxRegShiftedOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_1__MemRegOffset3_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 2, CVT_95_addMemRegOffsetOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemImm8Offset2_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemImm8OffsetOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_1__Reg1_2__MemImm8s4Offset2_3__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemImm8s4OffsetOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__MemNoOffset1_3__Reg1_1__Reg1_2__Tie0_4_4__Imm1_4__CondCode2_0
  { CVT_95_addMemNoOffsetOperands, 4, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Tied, Tie0_4_4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_1__Reg1_2__AddrMode33_3__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addAddrMode3Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__MemNoOffset1_3__Reg1_1__Reg1_2__Tie0_4_4__AM3Offset2_4__CondCode2_0
  { CVT_95_addMemNoOffsetOperands, 4, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Tied, Tie0_4_4, CVT_95_addAM3OffsetOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__MemImm0_1020s4Offset2_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemImm0_95_1020s4OffsetOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_1__AddrMode33_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 2, CVT_95_addAddrMode3Operands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__AM3Offset2_3__CondCode2_0
  { CVT_95_addMemNoOffsetOperands, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_95_addAM3OffsetOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxImm81_3__CondCode2_0
  { CVT_95_addMemNoOffsetOperands, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_95_addPostIdxImm8Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxReg2_3__CondCode2_0
  { CVT_95_addMemNoOffsetOperands, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_95_addPostIdxRegOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Imm0_2551_3__CondCode2_0
  { CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Imm0_2551_1__CondCode2_0
  { CVT_95_addImmOperands, 2, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Imm24bit1_1__CondCode2_0
  { CVT_95_addImmOperands, 2, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addRotImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__imm_95_0__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_imm_95_0, 0, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addRotImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addRotImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__MemTBB2_1__CondCode2_0
  { CVT_95_addMemTBBOperands, 2, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__MemTBH2_1__CondCode2_0
  { CVT_95_addMemTBHOperands, 2, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__TraceSyncBarrierOpt1_0
  { CVT_95_addTraceSyncBarrierOptOperands, 1, CVT_Done },
  // Convert__TraceSyncBarrierOpt1_1__CondCode2_0
  { CVT_95_addTraceSyncBarrierOptOperands, 2, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Imm0_311_2__Reg1_3__imm_95_0__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_Reg, 4, CVT_imm_95_0, 0, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Imm0_311_2__Reg1_3__ShifterImm1_4__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_Reg, 4, CVT_95_addShifterImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Imm0_151_2__Reg1_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_Reg, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_2__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__Reg1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__NEONi16splatNot1_3__Tie0_3_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONi16splatNotOperands, 4, CVT_Tied, Tie0_3_3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__NEONi32splatNot1_3__Tie0_3_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONi32splatNotOperands, 4, CVT_Tied, Tie0_3_3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__NEONi16splat1_3__Tie0_1_1__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONi16splatOperands, 4, CVT_Tied, Tie0_1_1, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__NEONi32splat1_3__Tie0_1_1__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONi32splatOperands, 4, CVT_Tied, Tie0_1_1, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_3_3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3__ComplexRotationOdd1_4
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addComplexRotationOddOperands, 5, CVT_Done },
  // Convert__Reg1_2__Reg1_2__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__ComplexRotationEven1_4
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addComplexRotationEvenOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__VectorIndex641_4__ComplexRotationEven1_5
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addVectorIndex64Operands, 5, CVT_95_addComplexRotationEvenOperands, 6, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__VectorIndex321_4__ComplexRotationEven1_5
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addVectorIndex32Operands, 5, CVT_95_addComplexRotationEvenOperands, 6, CVT_Done },
  // Convert__Reg1_2__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_4_5, CVT_95_addFBits16Operands, 6, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_4_5, CVT_95_addFBits32Operands, 6, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_2__Reg1_3__VectorIndex161_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addVectorIndex16Operands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__VectorIndex321_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addVectorIndex32Operands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__VectorIndex81_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addVectorIndex8Operands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_151_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_31_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_11_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_71_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_151_5__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_31_5__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_11_5__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_71_5__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__DupAlignedMemory162_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory16Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPair1_2__AlignedMemory64or1282_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addAlignedMemory64or128or256Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListOneDAllLanes1_2__DupAlignedMemory162_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory16Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListOneD1_2__AlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListOneDHWordIndexed2_2__AlignedMemory162_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory16Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__DupAlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListOneDAllLanes1_2__DupAlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListOneDWordIndexed2_2__AlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListOneDAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListOneDByteIndexed2_2__AlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory162_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory16Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory162_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory16Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128or256Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128or256Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory162_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory16Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory162_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory16Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListOneDHWordIndexed2_2__AlignedMemory162_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory16Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory322_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory322_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListOneDWordIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory32Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemoryNoneOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemoryNoneOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListOneDByteIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_3__AlignedMemory2_8__Tie0_1_1__Imm1_5__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_addAlignedMemoryOperands, 9, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_3__imm_95_0__AlignedMemory2_8__Imm1_9__Tie0_1_1__Imm1_5__CondCode2_0
  { CVT_95_Reg, 4, CVT_imm_95_0, 0, CVT_95_addAlignedMemoryOperands, 9, CVT_95_addImmOperands, 10, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_8__Imm1_9__Tie0_1_1__Imm1_5__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 9, CVT_95_addImmOperands, 10, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairSpacedAllLanes1_2__DupAlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairSpaced1_2__AlignedMemory64or1282_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListTwoDHWordIndexed2_2__AlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListTwoQHWordIndexed2_2__AlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__DupAlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairSpacedAllLanes1_2__DupAlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListTwoDWordIndexed2_2__AlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListTwoQWordIndexed2_2__AlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairSpacedAllLanes1_2__DupAlignedMemory162_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory16Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListTwoDByteIndexed2_2__AlignedMemory162_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory16Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory322_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairSpaced1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairSpaced1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListTwoDHWordIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory32Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListTwoQHWordIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory32Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListTwoDWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListTwoQWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory162_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory16Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory162_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory16Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListTwoDByteIndexed2_2__AlignedMemory162_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory16Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListThreeDHWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListThreeQ1_2__AlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListThreeQHWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListThreeDWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListThreeQWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListThreeDByteIndexed2_2__AlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemoryNoneOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListThreeD1_2__AlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListThreeDHWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemoryNoneOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListThreeQ1_2__AlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListThreeQHWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListThreeDWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListThreeQWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListThreeDByteIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__Reg1_5__AlignedMemory2_7__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addAlignedMemoryOperands, 8, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__Reg1_5__imm_95_0__AlignedMemory2_7__Imm1_8__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_imm_95_0, 0, CVT_95_addAlignedMemoryOperands, 8, CVT_95_addImmOperands, 9, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_6__Reg1_9__AlignedMemory2_13__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 7, CVT_95_Reg, 10, CVT_95_addAlignedMemoryOperands, 14, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_6__Reg1_9__imm_95_0__DupAlignedMemory642_13__Imm1_14__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 7, CVT_95_Reg, 10, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory64Operands, 14, CVT_95_addImmOperands, 15, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourDAllLanes1_2__DupAlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourDHWordIndexed2_2__AlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourQAllLanes1_2__DupAlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addAlignedMemory64or128or256Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourQHWordIndexed2_2__AlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourDAllLanes1_2__DupAlignedMemory64or1282_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory64or128Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourDWordIndexed2_2__AlignedMemory64or1282_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourQAllLanes1_2__DupAlignedMemory64or1282_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory64or128Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourQWordIndexed2_2__AlignedMemory64or1282_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourDAllLanes1_2__DupAlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourDByteIndexed2_2__AlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourQAllLanes1_2__DupAlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourDAllLanes1_2__DupAlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addAlignedMemory64or128or256Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourDHWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourQAllLanes1_2__DupAlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addAlignedMemory64or128or256Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourQHWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourDAllLanes1_2__DupAlignedMemory64or1282_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory64or128Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourDWordIndexed2_2__AlignedMemory64or1282_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourQAllLanes1_2__DupAlignedMemory64or1282_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory64or128Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourQWordIndexed2_2__AlignedMemory64or1282_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourDAllLanes1_2__DupAlignedMemory322_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourDByteIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory32Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__VecListFourQAllLanes1_2__DupAlignedMemory322_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__AlignedMemory2_8__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addAlignedMemoryOperands, 9, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__imm_95_0__AlignedMemory2_8__Imm1_9__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_imm_95_0, 0, CVT_95_addAlignedMemoryOperands, 9, CVT_95_addImmOperands, 10, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__AlignedMemory2_16__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 7, CVT_95_Reg, 10, CVT_95_Reg, 13, CVT_95_addAlignedMemoryOperands, 17, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__imm_95_0__AlignedMemory2_16__Imm1_17__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 7, CVT_95_Reg, 10, CVT_95_Reg, 13, CVT_imm_95_0, 0, CVT_95_addAlignedMemoryOperands, 17, CVT_95_addImmOperands, 18, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__CondCode2_0__SPRRegList1_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addCondCodeOperands, 1, CVT_95_addSPRRegListOperands, 4, CVT_Done },
  // Convert__Reg1_1__CondCode2_0__SPRRegList1_2
  { CVT_95_Reg, 2, CVT_95_addCondCodeOperands, 1, CVT_95_addSPRRegListOperands, 3, CVT_Done },
  // Convert__Reg1_1__AddrMode52_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addAddrMode5Operands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__AddrMode5FP162_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addAddrMode5FP16Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__AddrMode52_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addAddrMode5Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addVectorIndex32Operands, 6, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addVectorIndex16Operands, 6, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__FPImm1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addFPImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__NEONi32vmov1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONi32vmovOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__NEONi16vmovi8Replicate1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONvmovi8ReplicateOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__NEONi16splat1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONi16splatOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__NEONi32vmovi8Replicate1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONvmovi8ReplicateOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__NEONi32vmovi16Replicate1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONvmovi16ReplicateOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__NEONi32vmovNeg1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONi32vmovNegOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__NEONi64vmovi8Replicate1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONvmovi8ReplicateOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__NEONi64vmovi16Replicate1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONvmovi16ReplicateOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__NEONi64vmovi32Replicate1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONvmovi32ReplicateOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__NEONi64splat1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONi64splatOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__NEONi8splat1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONi8splatOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__VectorIndex161_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addVectorIndex16Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__VectorIndex321_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addVectorIndex32Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__VectorIndex81_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addVectorIndex8Operands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Reg1_3__VectorIndex321_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addVectorIndex32Operands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Reg1_3__VectorIndex161_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addVectorIndex16Operands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addVectorIndex32Operands, 6, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addVectorIndex16Operands, 6, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__NEONi16invi8Replicate1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONinvi8ReplicateOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__NEONi32invi8Replicate1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONinvi8ReplicateOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__NEONi64invi8Replicate1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONinvi8ReplicateOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__regSP__Tie0_1_1__CondCode2_0__DPRRegList1_1
  { CVT_regSP, 0, CVT_Tied, Tie0_1_1, CVT_95_addCondCodeOperands, 1, CVT_95_addDPRRegListOperands, 2, CVT_Done },
  // Convert__regSP__Tie0_1_1__CondCode2_0__SPRRegList1_1
  { CVT_regSP, 0, CVT_Tied, Tie0_1_1, CVT_95_addCondCodeOperands, 1, CVT_95_addSPRRegListOperands, 2, CVT_Done },
  // Convert__regSP__Tie0_1_1__CondCode2_0__DPRRegList1_2
  { CVT_regSP, 0, CVT_Tied, Tie0_1_1, CVT_95_addCondCodeOperands, 1, CVT_95_addDPRRegListOperands, 3, CVT_Done },
  // Convert__regSP__Tie0_1_1__CondCode2_0__SPRRegList1_2
  { CVT_regSP, 0, CVT_Tied, Tie0_1_1, CVT_95_addCondCodeOperands, 1, CVT_95_addSPRRegListOperands, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_3__ShrImm81_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__ShrImm161_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__ShrImm321_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__ShrImm161_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__ShrImm321_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__ShrImm641_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__ShrImm81_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__ShrImm641_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm161_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm321_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm641_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm81_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm161_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm321_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm641_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm81_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3__VectorIndex321_4
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addVectorIndex32Operands, 5, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Imm1_151_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Imm1_311_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Imm1_71_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Imm161_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Imm321_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Imm81_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_2__Imm1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__Imm1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__AlignedMemory64or1282_3__VecListDPair1_2__CondCode2_0
  { CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__AlignedMemory64or128or2562_3__VecListFourD1_2__CondCode2_0
  { CVT_95_addAlignedMemory64or128or256Operands, 4, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__AlignedMemory642_3__VecListOneD1_2__CondCode2_0
  { CVT_95_addAlignedMemory64Operands, 4, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__AlignedMemory642_3__VecListThreeD1_2__CondCode2_0
  { CVT_95_addAlignedMemory64Operands, 4, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory64or1282_3__VecListDPair1_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory64or1282_3__Reg1_4__VecListDPair1_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_Reg, 5, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory64or128or2562_3__VecListFourD1_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128or256Operands, 4, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__VecListFourD1_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128or256Operands, 4, CVT_95_Reg, 5, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory642_3__VecListOneD1_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemory64Operands, 4, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory642_3__Reg1_4__VecListOneD1_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory642_3__VecListThreeD1_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemory64Operands, 4, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory642_3__Reg1_4__VecListThreeD1_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__AlignedMemory2_8__Reg1_3__Imm1_5__CondCode2_0
  { CVT_95_addAlignedMemoryOperands, 9, CVT_95_Reg, 4, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory2_8__Imm1_9__Reg1_3__Imm1_5__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemoryOperands, 9, CVT_95_addImmOperands, 10, CVT_95_Reg, 4, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_8__Imm1_9__Reg1_3__Imm1_5__CondCode2_0
  { CVT_95_Reg, 9, CVT_95_addImmOperands, 10, CVT_95_Reg, 4, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_8__Imm1_9__Imm1_10__Reg1_3__Imm1_5__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 9, CVT_95_addImmOperands, 10, CVT_95_addImmOperands, 11, CVT_95_Reg, 4, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__AlignedMemory64or1282_3__VecListDPairSpaced1_2__CondCode2_0
  { CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory64or1282_3__VecListDPairSpaced1_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory64or1282_3__Reg1_4__VecListDPairSpaced1_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_Reg, 5, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__AlignedMemory2_7__Reg1_3__Reg1_4__Reg1_5__CondCode2_0
  { CVT_95_addAlignedMemoryOperands, 8, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory2_7__Imm1_8__Reg1_3__Reg1_4__Reg1_5__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemoryOperands, 8, CVT_95_addImmOperands, 9, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__AlignedMemory2_8__Reg1_3__Reg1_4__Reg1_5__Reg1_6__CondCode2_0
  { CVT_95_addAlignedMemoryOperands, 9, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory2_8__Imm1_9__Reg1_3__Reg1_4__Reg1_5__Reg1_6__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemoryOperands, 9, CVT_95_addImmOperands, 10, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Tie0_1_1__Tie1_1_1__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Tie0_3_3__Tie1_4_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Tied, Tie0_3_3, CVT_Tied, Tie1_4_4, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__VecListDPair1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addVecListOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__VecListFourD1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addVecListOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__VecListOneD1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addVecListOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__VecListThreeD1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addVecListOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__VecListDPair1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addVecListOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__VecListFourD1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addVecListOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__VecListOneD1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addVecListOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__VecListThreeD1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addVecListOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_2__CondCode2_0
  { CVT_imm_95_2, 0, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_3__CondCode2_0
  { CVT_imm_95_3, 0, CVT_95_addCondCodeOperands, 1, CVT_Done },
  // Convert__imm_95_1__CondCode2_0
  { CVT_imm_95_1, 0, CVT_95_addCondCodeOperands, 1, CVT_Done },
};

void ARMAsmParser::
convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  unsigned OpIdx;
  Inst.setOpcode(Opcode);
  for (const uint8_t *p = Converter; *p; p+= 2) {
    OpIdx = *(p + 1);
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_Tied: {
      assert(OpIdx < (size_t)(std::end(TiedAsmOperandTable) -
                          std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned TiedResOpnd = TiedAsmOperandTable[OpIdx][0];
      if (TiedResOpnd != (uint8_t) -1)
        Inst.addOperand(Inst.getOperand(TiedResOpnd));
      break;
    }
    case CVT_95_Reg:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_95_addCCOutOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addCCOutOperands(Inst, 1);
      break;
    case CVT_95_addCondCodeOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addCondCodeOperands(Inst, 2);
      break;
    case CVT_95_addRegShiftedRegOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addRegShiftedRegOperands(Inst, 3);
      break;
    case CVT_95_addModImmOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addModImmOperands(Inst, 1);
      break;
    case CVT_95_addModImmNotOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addModImmNotOperands(Inst, 1);
      break;
    case CVT_95_addRegShiftedImmOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addRegShiftedImmOperands(Inst, 2);
      break;
    case CVT_95_addImmOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addImmOperands(Inst, 1);
      break;
    case CVT_95_addT2SOImmNotOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addT2SOImmNotOperands(Inst, 1);
      break;
    case CVT_95_addImm0_95_508s4Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addImm0_508s4Operands(Inst, 1);
      break;
    case CVT_regSP:
      Inst.addOperand(MCOperand::createReg(ARM::SP));
      break;
    case CVT_95_addImm0_95_508s4NegOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addImm0_508s4NegOperands(Inst, 1);
      break;
    case CVT_95_addImm0_95_4095NegOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addImm0_4095NegOperands(Inst, 1);
      break;
    case CVT_95_addThumbModImmNeg8_95_255Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addThumbModImmNeg8_255Operands(Inst, 1);
      break;
    case CVT_95_addT2SOImmNegOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addT2SOImmNegOperands(Inst, 1);
      break;
    case CVT_95_addModImmNegOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addModImmNegOperands(Inst, 1);
      break;
    case CVT_95_addImm0_95_1020s4Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addImm0_1020s4Operands(Inst, 1);
      break;
    case CVT_95_addThumbModImmNeg1_95_7Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addThumbModImmNeg1_7Operands(Inst, 1);
      break;
    case CVT_95_addUnsignedOffset_95_b8s2Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addUnsignedOffset_b8s2Operands(Inst, 1);
      break;
    case CVT_95_addAdrLabelOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addAdrLabelOperands(Inst, 1);
      break;
    case CVT_95_addARMBranchTargetOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addARMBranchTargetOperands(Inst, 1);
      break;
    case CVT_cvtThumbBranches:
      cvtThumbBranches(Inst, Operands);
      break;
    case CVT_95_addBitfieldOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addBitfieldOperands(Inst, 1);
      break;
    case CVT_imm_95_0:
      Inst.addOperand(MCOperand::createImm(0));
      break;
    case CVT_95_addThumbBranchTargetOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addThumbBranchTargetOperands(Inst, 1);
      break;
    case CVT_95_addCoprocNumOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addCoprocNumOperands(Inst, 1);
      break;
    case CVT_95_addCoprocRegOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addCoprocRegOperands(Inst, 1);
      break;
    case CVT_95_addProcIFlagsOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addProcIFlagsOperands(Inst, 1);
      break;
    case CVT_imm_95_20:
      Inst.addOperand(MCOperand::createImm(20));
      break;
    case CVT_imm_95_12:
      Inst.addOperand(MCOperand::createImm(12));
      break;
    case CVT_imm_95_15:
      Inst.addOperand(MCOperand::createImm(15));
      break;
    case CVT_95_addMemBarrierOptOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addMemBarrierOptOperands(Inst, 1);
      break;
    case CVT_imm_95_16:
      Inst.addOperand(MCOperand::createImm(16));
      break;
    case CVT_95_addFPImmOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addFPImmOperands(Inst, 1);
      break;
    case CVT_95_addDPRRegListOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addDPRRegListOperands(Inst, 1);
      break;
    case CVT_imm_95_1:
      Inst.addOperand(MCOperand::createImm(1));
      break;
    case CVT_95_addInstSyncBarrierOptOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addInstSyncBarrierOptOperands(Inst, 1);
      break;
    case CVT_95_addITCondCodeOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addITCondCodeOperands(Inst, 1);
      break;
    case CVT_95_addITMaskOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addITMaskOperands(Inst, 1);
      break;
    case CVT_95_addMemNoOffsetOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addMemNoOffsetOperands(Inst, 1);
      break;
    case CVT_95_addAddrMode5Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addAddrMode5Operands(Inst, 2);
      break;
    case CVT_95_addCoprocOptionOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addCoprocOptionOperands(Inst, 1);
      break;
    case CVT_95_addPostIdxImm8s4Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addPostIdxImm8s4Operands(Inst, 1);
      break;
    case CVT_95_addRegListOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addRegListOperands(Inst, 1);
      break;
    case CVT_95_addThumbMemPCOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addThumbMemPCOperands(Inst, 1);
      break;
    case CVT_95_addConstPoolAsmImmOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addConstPoolAsmImmOperands(Inst, 1);
      break;
    case CVT_95_addMemThumbRIs4Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addMemThumbRIs4Operands(Inst, 2);
      break;
    case CVT_95_addMemThumbRROperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addMemThumbRROperands(Inst, 2);
      break;
    case CVT_95_addMemThumbSPIOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addMemThumbSPIOperands(Inst, 2);
      break;
    case CVT_95_addMemImm12OffsetOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addMemImm12OffsetOperands(Inst, 2);
      break;
    case CVT_95_addMemNegImm8OffsetOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addMemNegImm8OffsetOperands(Inst, 2);
      break;
    case CVT_95_addMemRegOffsetOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addMemRegOffsetOperands(Inst, 3);
      break;
    case CVT_95_addMemUImm12OffsetOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addMemUImm12OffsetOperands(Inst, 2);
      break;
    case CVT_95_addT2MemRegOffsetOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addT2MemRegOffsetOperands(Inst, 3);
      break;
    case CVT_95_addMemPCRelImm12Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addMemPCRelImm12Operands(Inst, 1);
      break;
    case CVT_95_addMemImm8OffsetOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addMemImm8OffsetOperands(Inst, 2);
      break;
    case CVT_95_addAM2OffsetImmOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addAM2OffsetImmOperands(Inst, 2);
      break;
    case CVT_95_addPostIdxRegShiftedOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addPostIdxRegShiftedOperands(Inst, 2);
      break;
    case CVT_95_addMemThumbRIs1Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addMemThumbRIs1Operands(Inst, 2);
      break;
    case CVT_95_addMemPosImm8OffsetOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addMemPosImm8OffsetOperands(Inst, 2);
      break;
    case CVT_95_addMemImm8s4OffsetOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addMemImm8s4OffsetOperands(Inst, 2);
      break;
    case CVT_95_addAddrMode3Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addAddrMode3Operands(Inst, 3);
      break;
    case CVT_95_addAM3OffsetOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addAM3OffsetOperands(Inst, 2);
      break;
    case CVT_95_addMemImm0_95_1020s4OffsetOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addMemImm0_1020s4OffsetOperands(Inst, 2);
      break;
    case CVT_95_addMemThumbRIs2Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addMemThumbRIs2Operands(Inst, 2);
      break;
    case CVT_95_addPostIdxRegOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addPostIdxRegOperands(Inst, 2);
      break;
    case CVT_95_addPostIdxImm8Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addPostIdxImm8Operands(Inst, 1);
      break;
    case CVT_reg0:
      Inst.addOperand(MCOperand::createReg(0));
      break;
    case CVT_regCPSR:
      Inst.addOperand(MCOperand::createReg(ARM::CPSR));
      break;
    case CVT_imm_95_14:
      Inst.addOperand(MCOperand::createImm(14));
      break;
    case CVT_95_addBankedRegOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addBankedRegOperands(Inst, 1);
      break;
    case CVT_95_addMSRMaskOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addMSRMaskOperands(Inst, 1);
      break;
    case CVT_cvtThumbMultiply:
      cvtThumbMultiply(Inst, Operands);
      break;
    case CVT_regR8:
      Inst.addOperand(MCOperand::createReg(ARM::R8));
      break;
    case CVT_regR0:
      Inst.addOperand(MCOperand::createReg(ARM::R0));
      break;
    case CVT_95_addPKHASRImmOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addPKHASRImmOperands(Inst, 1);
      break;
    case CVT_95_addImm1_95_32Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addImm1_32Operands(Inst, 1);
      break;
    case CVT_imm_95_4:
      Inst.addOperand(MCOperand::createImm(4));
      break;
    case CVT_imm_95_5:
      Inst.addOperand(MCOperand::createImm(5));
      break;
    case CVT_95_addShifterImmOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addShifterImmOperands(Inst, 1);
      break;
    case CVT_95_addImm1_95_16Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addImm1_16Operands(Inst, 1);
      break;
    case CVT_95_addRotImmOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addRotImmOperands(Inst, 1);
      break;
    case CVT_95_addMemTBBOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addMemTBBOperands(Inst, 2);
      break;
    case CVT_95_addMemTBHOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addMemTBHOperands(Inst, 2);
      break;
    case CVT_95_addTraceSyncBarrierOptOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addTraceSyncBarrierOptOperands(Inst, 1);
      break;
    case CVT_95_addNEONi16splatNotOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addNEONi16splatNotOperands(Inst, 1);
      break;
    case CVT_95_addNEONi32splatNotOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addNEONi32splatNotOperands(Inst, 1);
      break;
    case CVT_95_addNEONi16splatOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addNEONi16splatOperands(Inst, 1);
      break;
    case CVT_95_addNEONi32splatOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addNEONi32splatOperands(Inst, 1);
      break;
    case CVT_95_addComplexRotationOddOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addComplexRotationOddOperands(Inst, 1);
      break;
    case CVT_95_addComplexRotationEvenOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addComplexRotationEvenOperands(Inst, 1);
      break;
    case CVT_95_addVectorIndex64Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addVectorIndex64Operands(Inst, 1);
      break;
    case CVT_95_addVectorIndex32Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addVectorIndex32Operands(Inst, 1);
      break;
    case CVT_95_addFBits16Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addFBits16Operands(Inst, 1);
      break;
    case CVT_95_addFBits32Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addFBits32Operands(Inst, 1);
      break;
    case CVT_95_addVectorIndex16Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addVectorIndex16Operands(Inst, 1);
      break;
    case CVT_95_addVectorIndex8Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addVectorIndex8Operands(Inst, 1);
      break;
    case CVT_95_addVecListOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addVecListOperands(Inst, 1);
      break;
    case CVT_95_addDupAlignedMemory16Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addDupAlignedMemory16Operands(Inst, 2);
      break;
    case CVT_95_addAlignedMemory64or128Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addAlignedMemory64or128Operands(Inst, 2);
      break;
    case CVT_95_addAlignedMemory64or128or256Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addAlignedMemory64or128or256Operands(Inst, 2);
      break;
    case CVT_95_addAlignedMemory64Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addAlignedMemory64Operands(Inst, 2);
      break;
    case CVT_95_addVecListIndexedOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addVecListIndexedOperands(Inst, 2);
      break;
    case CVT_95_addAlignedMemory16Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addAlignedMemory16Operands(Inst, 2);
      break;
    case CVT_95_addDupAlignedMemory32Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addDupAlignedMemory32Operands(Inst, 2);
      break;
    case CVT_95_addAlignedMemory32Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addAlignedMemory32Operands(Inst, 2);
      break;
    case CVT_95_addDupAlignedMemoryNoneOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addDupAlignedMemoryNoneOperands(Inst, 2);
      break;
    case CVT_95_addAlignedMemoryNoneOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addAlignedMemoryNoneOperands(Inst, 2);
      break;
    case CVT_95_addAlignedMemoryOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addAlignedMemoryOperands(Inst, 2);
      break;
    case CVT_95_addDupAlignedMemory64Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addDupAlignedMemory64Operands(Inst, 2);
      break;
    case CVT_95_addDupAlignedMemory64or128Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addDupAlignedMemory64or128Operands(Inst, 2);
      break;
    case CVT_95_addSPRRegListOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addSPRRegListOperands(Inst, 1);
      break;
    case CVT_95_addAddrMode5FP16Operands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addAddrMode5FP16Operands(Inst, 2);
      break;
    case CVT_95_addNEONi32vmovOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addNEONi32vmovOperands(Inst, 1);
      break;
    case CVT_95_addNEONvmovi8ReplicateOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addNEONvmovi8ReplicateOperands(Inst, 1);
      break;
    case CVT_95_addNEONvmovi16ReplicateOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addNEONvmovi16ReplicateOperands(Inst, 1);
      break;
    case CVT_95_addNEONi32vmovNegOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addNEONi32vmovNegOperands(Inst, 1);
      break;
    case CVT_95_addNEONvmovi32ReplicateOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addNEONvmovi32ReplicateOperands(Inst, 1);
      break;
    case CVT_95_addNEONi64splatOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addNEONi64splatOperands(Inst, 1);
      break;
    case CVT_95_addNEONi8splatOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addNEONi8splatOperands(Inst, 1);
      break;
    case CVT_95_addNEONinvi8ReplicateOperands:
      static_cast<ARMOperand&>(*Operands[OpIdx]).addNEONinvi8ReplicateOperands(Inst, 1);
      break;
    case CVT_imm_95_2:
      Inst.addOperand(MCOperand::createImm(2));
      break;
    case CVT_imm_95_3:
      Inst.addOperand(MCOperand::createImm(3));
      break;
    }
  }
}

void ARMAsmParser::
convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  unsigned NumMCOperands = 0;
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p+= 2) {
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      ++NumMCOperands;
      break;
    case CVT_Tied:
      ++NumMCOperands;
      break;
    case CVT_95_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      NumMCOperands += 1;
      break;
    case CVT_95_addCCOutOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addCondCodeOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addRegShiftedRegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 3;
      break;
    case CVT_95_addModImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addModImmNotOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addRegShiftedImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addT2SOImmNotOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addImm0_95_508s4Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_regSP:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_addImm0_95_508s4NegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addImm0_95_4095NegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addThumbModImmNeg8_95_255Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addT2SOImmNegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addModImmNegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addImm0_95_1020s4Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addThumbModImmNeg1_95_7Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addUnsignedOffset_95_b8s2Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addAdrLabelOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addARMBranchTargetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addBitfieldOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addThumbBranchTargetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addCoprocNumOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addCoprocRegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addProcIFlagsOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_20:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_12:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_15:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addMemBarrierOptOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_16:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addFPImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addDPRRegListOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addInstSyncBarrierOptOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addITCondCodeOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addITMaskOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addMemNoOffsetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addAddrMode5Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addCoprocOptionOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addPostIdxImm8s4Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addRegListOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addThumbMemPCOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addConstPoolAsmImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addMemThumbRIs4Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMemThumbRROperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMemThumbSPIOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMemImm12OffsetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMemNegImm8OffsetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMemRegOffsetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 3;
      break;
    case CVT_95_addMemUImm12OffsetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addT2MemRegOffsetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 3;
      break;
    case CVT_95_addMemPCRelImm12Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addMemImm8OffsetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addAM2OffsetImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addPostIdxRegShiftedOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMemThumbRIs1Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMemPosImm8OffsetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMemImm8s4OffsetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addAddrMode3Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 3;
      break;
    case CVT_95_addAM3OffsetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMemImm0_95_1020s4OffsetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMemThumbRIs2Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addPostIdxRegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addPostIdxImm8Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_reg0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regCPSR:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_imm_95_14:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addBankedRegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addMSRMaskOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_regR8:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regR0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_addPKHASRImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addImm1_95_32Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_4:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_5:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addShifterImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addImm1_95_16Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addRotImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addMemTBBOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMemTBHOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addTraceSyncBarrierOptOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addNEONi16splatNotOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addNEONi32splatNotOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addNEONi16splatOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addNEONi32splatOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addComplexRotationOddOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addComplexRotationEvenOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addVectorIndex64Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addVectorIndex32Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addFBits16Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addFBits32Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addVectorIndex16Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addVectorIndex8Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addVecListOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addDupAlignedMemory16Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addAlignedMemory64or128Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addAlignedMemory64or128or256Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addAlignedMemory64Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addVecListIndexedOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addAlignedMemory16Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addDupAlignedMemory32Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addAlignedMemory32Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addDupAlignedMemoryNoneOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addAlignedMemoryNoneOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addAlignedMemoryOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addDupAlignedMemory64Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addDupAlignedMemory64or128Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addSPRRegListOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addAddrMode5FP16Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addNEONi32vmovOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addNEONvmovi8ReplicateOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addNEONvmovi16ReplicateOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addNEONi32vmovNegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addNEONvmovi32ReplicateOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addNEONi64splatOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addNEONi8splatOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addNEONinvi8ReplicateOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_2:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    }
  }
}

namespace {

/// MatchClassKind - The kinds of classes which participate in
/// instruction matching.
enum MatchClassKind {
  InvalidMatchClass = 0,
  OptionalMatchClass = 1,
  MCK__DOT_d, // '.d'
  MCK__DOT_f, // '.f'
  MCK__DOT_s16, // '.s16'
  MCK__DOT_s32, // '.s32'
  MCK__DOT_s64, // '.s64'
  MCK__DOT_s8, // '.s8'
  MCK__DOT_u16, // '.u16'
  MCK__DOT_u32, // '.u32'
  MCK__DOT_u64, // '.u64'
  MCK__DOT_u8, // '.u8'
  MCK__DOT_f32, // '.f32'
  MCK__DOT_f64, // '.f64'
  MCK__DOT_i16, // '.i16'
  MCK__DOT_i32, // '.i32'
  MCK__DOT_i64, // '.i64'
  MCK__DOT_i8, // '.i8'
  MCK__DOT_p16, // '.p16'
  MCK__DOT_p8, // '.p8'
  MCK__EXCLAIM_, // '!'
  MCK__35_0, // '#0'
  MCK__DOT_16, // '.16'
  MCK__DOT_32, // '.32'
  MCK__DOT_64, // '.64'
  MCK__DOT_8, // '.8'
  MCK__DOT_f16, // '.f16'
  MCK__DOT_p64, // '.p64'
  MCK__DOT_w, // '.w'
  MCK__91_, // '['
  MCK__93_, // ']'
  MCK__94_, // '^'
  MCK__123_, // '{'
  MCK__125_, // '}'
  MCK_LAST_TOKEN = MCK__125_,
  MCK_Reg75, // derived register class
  MCK_Reg59, // derived register class
  MCK_Reg11, // derived register class
  MCK_APSR, // register class 'APSR'
  MCK_APSR_NZCV, // register class 'APSR_NZCV'
  MCK_CCR, // register class 'CCR,CPSR'
  MCK_FPEXC, // register class 'FPEXC'
  MCK_FPINST, // register class 'FPINST'
  MCK_FPINST2, // register class 'FPINST2'
  MCK_FPSCR, // register class 'FPSCR'
  MCK_FPSID, // register class 'FPSID'
  MCK_GPRsp, // register class 'GPRsp,SP'
  MCK_LR, // register class 'LR'
  MCK_MVFR0, // register class 'MVFR0'
  MCK_MVFR1, // register class 'MVFR1'
  MCK_MVFR2, // register class 'MVFR2'
  MCK_PC, // register class 'PC'
  MCK_SPSR, // register class 'SPSR'
  MCK_Reg100, // derived register class
  MCK_Reg73, // derived register class
  MCK_Reg68, // derived register class
  MCK_Reg60, // derived register class
  MCK_Reg101, // derived register class
  MCK_Reg88, // derived register class
  MCK_Reg83, // derived register class
  MCK_Reg74, // derived register class
  MCK_Reg72, // derived register class
  MCK_Reg61, // derived register class
  MCK_Reg45, // derived register class
  MCK_Reg102, // derived register class
  MCK_Reg93, // derived register class
  MCK_Reg89, // derived register class
  MCK_Reg84, // derived register class
  MCK_Reg69, // derived register class
  MCK_Reg62, // derived register class
  MCK_Reg46, // derived register class
  MCK_Reg0, // derived register class
  MCK_QPR_8, // register class 'QPR_8'
  MCK_Reg63, // derived register class
  MCK_Reg57, // derived register class
  MCK_tcGPR, // register class 'tcGPR'
  MCK_Reg103, // derived register class
  MCK_Reg94, // derived register class
  MCK_Reg76, // derived register class
  MCK_Reg70, // derived register class
  MCK_Reg64, // derived register class
  MCK_Reg58, // derived register class
  MCK_Reg40, // derived register class
  MCK_Reg10, // derived register class
  MCK_Reg104, // derived register class
  MCK_Reg90, // derived register class
  MCK_Reg85, // derived register class
  MCK_Reg77, // derived register class
  MCK_Reg65, // derived register class
  MCK_Reg55, // derived register class
  MCK_Reg47, // derived register class
  MCK_Reg26, // derived register class
  MCK_Reg8, // derived register class
  MCK_GPRPair, // register class 'GPRPair'
  MCK_Reg105, // derived register class
  MCK_Reg95, // derived register class
  MCK_Reg91, // derived register class
  MCK_Reg86, // derived register class
  MCK_Reg78, // derived register class
  MCK_Reg66, // derived register class
  MCK_Reg56, // derived register class
  MCK_Reg48, // derived register class
  MCK_Reg41, // derived register class
  MCK_Reg27, // derived register class
  MCK_DPR_8, // register class 'DPR_8'
  MCK_QPR_VFP2, // register class 'QPR_VFP2'
  MCK_hGPR, // register class 'hGPR'
  MCK_tGPR, // register class 'tGPR'
  MCK_tGPRwithpc, // register class 'tGPRwithpc'
  MCK_Reg96, // derived register class
  MCK_Reg53, // derived register class
  MCK_QQQQPR, // register class 'QQQQPR'
  MCK_Reg106, // derived register class
  MCK_Reg97, // derived register class
  MCK_Reg79, // derived register class
  MCK_Reg54, // derived register class
  MCK_Reg42, // derived register class
  MCK_rGPR, // register class 'rGPR'
  MCK_Reg92, // derived register class
  MCK_Reg87, // derived register class
  MCK_Reg80, // derived register class
  MCK_Reg51, // derived register class
  MCK_Reg24, // derived register class
  MCK_GPRnopc, // register class 'GPRnopc'
  MCK_QQPR, // register class 'QQPR'
  MCK_Reg98, // derived register class
  MCK_Reg81, // derived register class
  MCK_Reg52, // derived register class
  MCK_Reg43, // derived register class
  MCK_Reg25, // derived register class
  MCK_DPR_VFP2, // register class 'DPR_VFP2'
  MCK_GPR, // register class 'GPR'
  MCK_GPRwithAPSR, // register class 'GPRwithAPSR'
  MCK_QPR, // register class 'QPR'
  MCK_SPR_8, // register class 'SPR_8'
  MCK_DTripleSpc, // register class 'DTripleSpc,DQuadSpc'
  MCK_DQuad, // register class 'DQuad'
  MCK_DPairSpc, // register class 'DPairSpc'
  MCK_DTriple, // register class 'DTriple'
  MCK_DPair, // register class 'DPair'
  MCK_DPR, // register class 'DPR'
  MCK_HPR, // register class 'HPR,SPR'
  MCK_LAST_REGISTER = MCK_HPR,
  MCK_AM2OffsetImm, // user defined class 'AM2OffsetImmAsmOperand'
  MCK_AM3Offset, // user defined class 'AM3OffsetAsmOperand'
  MCK_ARMBranchTarget, // user defined class 'ARMBranchTarget'
  MCK_AddrMode3, // user defined class 'AddrMode3AsmOperand'
  MCK_AddrMode5, // user defined class 'AddrMode5AsmOperand'
  MCK_AddrMode5FP16, // user defined class 'AddrMode5FP16AsmOperand'
  MCK_AlignedMemory16, // user defined class 'AddrMode6Align16AsmOperand'
  MCK_AlignedMemory32, // user defined class 'AddrMode6Align32AsmOperand'
  MCK_AlignedMemory64, // user defined class 'AddrMode6Align64AsmOperand'
  MCK_AlignedMemory64or128, // user defined class 'AddrMode6Align64or128AsmOperand'
  MCK_AlignedMemory64or128or256, // user defined class 'AddrMode6Align64or128or256AsmOperand'
  MCK_AlignedMemoryNone, // user defined class 'AddrMode6AlignNoneAsmOperand'
  MCK_AlignedMemory, // user defined class 'AddrMode6AsmOperand'
  MCK_DupAlignedMemory16, // user defined class 'AddrMode6dupAlign16AsmOperand'
  MCK_DupAlignedMemory32, // user defined class 'AddrMode6dupAlign32AsmOperand'
  MCK_DupAlignedMemory64, // user defined class 'AddrMode6dupAlign64AsmOperand'
  MCK_DupAlignedMemory64or128, // user defined class 'AddrMode6dupAlign64or128AsmOperand'
  MCK_DupAlignedMemoryNone, // user defined class 'AddrMode6dupAlignNoneAsmOperand'
  MCK_AdrLabel, // user defined class 'AdrLabelAsmOperand'
  MCK_BankedReg, // user defined class 'BankedRegOperand'
  MCK_Bitfield, // user defined class 'BitfieldAsmOperand'
  MCK_CCOut, // user defined class 'CCOutOperand'
  MCK_CondCode, // user defined class 'CondCodeOperand'
  MCK_CoprocNum, // user defined class 'CoprocNumAsmOperand'
  MCK_CoprocOption, // user defined class 'CoprocOptionAsmOperand'
  MCK_CoprocReg, // user defined class 'CoprocRegAsmOperand'
  MCK_DPRRegList, // user defined class 'DPRRegListAsmOperand'
  MCK_FPImm, // user defined class 'FPImmOperand'
  MCK_Imm0_15, // user defined class 'Imm0_15AsmOperand'
  MCK_Imm0_1, // user defined class 'Imm0_1AsmOperand'
  MCK_Imm0_239, // user defined class 'Imm0_239AsmOperand'
  MCK_Imm0_255, // user defined class 'Imm0_255AsmOperand'
  MCK_Imm0_31, // user defined class 'Imm0_31AsmOperand'
  MCK_Imm0_32, // user defined class 'Imm0_32AsmOperand'
  MCK_Imm0_3, // user defined class 'Imm0_3AsmOperand'
  MCK_Imm0_63, // user defined class 'Imm0_63AsmOperand'
  MCK_Imm0_65535, // user defined class 'Imm0_65535AsmOperand'
  MCK_Imm0_65535Expr, // user defined class 'Imm0_65535ExprAsmOperand'
  MCK_Imm0_7, // user defined class 'Imm0_7AsmOperand'
  MCK_Imm16, // user defined class 'Imm16AsmOperand'
  MCK_Imm1_15, // user defined class 'Imm1_15AsmOperand'
  MCK_Imm1_16, // user defined class 'Imm1_16AsmOperand'
  MCK_Imm1_31, // user defined class 'Imm1_31AsmOperand'
  MCK_Imm1_32, // user defined class 'Imm1_32AsmOperand'
  MCK_Imm1_7, // user defined class 'Imm1_7AsmOperand'
  MCK_Imm24bit, // user defined class 'Imm24bitAsmOperand'
  MCK_Imm256_65535Expr, // user defined class 'Imm256_65535ExprAsmOperand'
  MCK_Imm32, // user defined class 'Imm32AsmOperand'
  MCK_Imm8, // user defined class 'Imm8AsmOperand'
  MCK_Imm8_255, // user defined class 'Imm8_255AsmOperand'
  MCK_Imm, // user defined class 'ImmAsmOperand'
  MCK_InstSyncBarrierOpt, // user defined class 'InstSyncBarrierOptOperand'
  MCK_MSRMask, // user defined class 'MSRMaskOperand'
  MCK_MemBarrierOpt, // user defined class 'MemBarrierOptOperand'
  MCK_MemImm0_1020s4Offset, // user defined class 'MemImm0_1020s4OffsetAsmOperand'
  MCK_MemImm12Offset, // user defined class 'MemImm12OffsetAsmOperand'
  MCK_MemImm8Offset, // user defined class 'MemImm8OffsetAsmOperand'
  MCK_MemImm8s4Offset, // user defined class 'MemImm8s4OffsetAsmOperand'
  MCK_MemNegImm8Offset, // user defined class 'MemNegImm8OffsetAsmOperand'
  MCK_MemNoOffset, // user defined class 'MemNoOffsetAsmOperand'
  MCK_MemPosImm8Offset, // user defined class 'MemPosImm8OffsetAsmOperand'
  MCK_MemRegOffset, // user defined class 'MemRegOffsetAsmOperand'
  MCK_ModImm, // user defined class 'ModImmAsmOperand'
  MCK_ModImmNeg, // user defined class 'ModImmNegAsmOperand'
  MCK_ModImmNot, // user defined class 'ModImmNotAsmOperand'
  MCK_PKHASRImm, // user defined class 'PKHASRAsmOperand'
  MCK_PKHLSLImm, // user defined class 'PKHLSLAsmOperand'
  MCK_PostIdxImm8, // user defined class 'PostIdxImm8AsmOperand'
  MCK_PostIdxImm8s4, // user defined class 'PostIdxImm8s4AsmOperand'
  MCK_PostIdxReg, // user defined class 'PostIdxRegAsmOperand'
  MCK_PostIdxRegShifted, // user defined class 'PostIdxRegShiftedAsmOperand'
  MCK_ProcIFlags, // user defined class 'ProcIFlagsOperand'
  MCK_RegList, // user defined class 'RegListAsmOperand'
  MCK_RotImm, // user defined class 'RotImmAsmOperand'
  MCK_SPRRegList, // user defined class 'SPRRegListAsmOperand'
  MCK_SetEndImm, // user defined class 'SetEndAsmOperand'
  MCK_RegShiftedImm, // user defined class 'ShiftedImmAsmOperand'
  MCK_RegShiftedReg, // user defined class 'ShiftedRegAsmOperand'
  MCK_ShifterImm, // user defined class 'ShifterImmAsmOperand'
  MCK_ThumbBranchTarget, // user defined class 'ThumbBranchTarget'
  MCK_ThumbMemPC, // user defined class 'ThumbMemPC'
  MCK_ThumbModImmNeg1_7, // user defined class 'ThumbModImmNeg1_7AsmOperand'
  MCK_ThumbModImmNeg8_255, // user defined class 'ThumbModImmNeg8_255AsmOperand'
  MCK_ImmThumbSR, // user defined class 'ThumbSRImmAsmOperand'
  MCK_TraceSyncBarrierOpt, // user defined class 'TraceSyncBarrierOptOperand'
  MCK_UnsignedOffset_b8s2, // user defined class 'UnsignedOffset_b8s2'
  MCK_VecListDPairAllLanes, // user defined class 'VecListDPairAllLanesAsmOperand'
  MCK_VecListDPair, // user defined class 'VecListDPairAsmOperand'
  MCK_VecListDPairSpacedAllLanes, // user defined class 'VecListDPairSpacedAllLanesAsmOperand'
  MCK_VecListDPairSpaced, // user defined class 'VecListDPairSpacedAsmOperand'
  MCK_VecListFourDAllLanes, // user defined class 'VecListFourDAllLanesAsmOperand'
  MCK_VecListFourD, // user defined class 'VecListFourDAsmOperand'
  MCK_VecListFourDByteIndexed, // user defined class 'VecListFourDByteIndexAsmOperand'
  MCK_VecListFourDHWordIndexed, // user defined class 'VecListFourDHWordIndexAsmOperand'
  MCK_VecListFourDWordIndexed, // user defined class 'VecListFourDWordIndexAsmOperand'
  MCK_VecListFourQAllLanes, // user defined class 'VecListFourQAllLanesAsmOperand'
  MCK_VecListFourQ, // user defined class 'VecListFourQAsmOperand'
  MCK_VecListFourQHWordIndexed, // user defined class 'VecListFourQHWordIndexAsmOperand'
  MCK_VecListFourQWordIndexed, // user defined class 'VecListFourQWordIndexAsmOperand'
  MCK_VecListOneDAllLanes, // user defined class 'VecListOneDAllLanesAsmOperand'
  MCK_VecListOneD, // user defined class 'VecListOneDAsmOperand'
  MCK_VecListOneDByteIndexed, // user defined class 'VecListOneDByteIndexAsmOperand'
  MCK_VecListOneDHWordIndexed, // user defined class 'VecListOneDHWordIndexAsmOperand'
  MCK_VecListOneDWordIndexed, // user defined class 'VecListOneDWordIndexAsmOperand'
  MCK_VecListThreeDAllLanes, // user defined class 'VecListThreeDAllLanesAsmOperand'
  MCK_VecListThreeD, // user defined class 'VecListThreeDAsmOperand'
  MCK_VecListThreeDByteIndexed, // user defined class 'VecListThreeDByteIndexAsmOperand'
  MCK_VecListThreeDHWordIndexed, // user defined class 'VecListThreeDHWordIndexAsmOperand'
  MCK_VecListThreeDWordIndexed, // user defined class 'VecListThreeDWordIndexAsmOperand'
  MCK_VecListThreeQAllLanes, // user defined class 'VecListThreeQAllLanesAsmOperand'
  MCK_VecListThreeQ, // user defined class 'VecListThreeQAsmOperand'
  MCK_VecListThreeQHWordIndexed, // user defined class 'VecListThreeQHWordIndexAsmOperand'
  MCK_VecListThreeQWordIndexed, // user defined class 'VecListThreeQWordIndexAsmOperand'
  MCK_VecListTwoDByteIndexed, // user defined class 'VecListTwoDByteIndexAsmOperand'
  MCK_VecListTwoDHWordIndexed, // user defined class 'VecListTwoDHWordIndexAsmOperand'
  MCK_VecListTwoDWordIndexed, // user defined class 'VecListTwoDWordIndexAsmOperand'
  MCK_VecListTwoQHWordIndexed, // user defined class 'VecListTwoQHWordIndexAsmOperand'
  MCK_VecListTwoQWordIndexed, // user defined class 'VecListTwoQWordIndexAsmOperand'
  MCK_VectorIndex16, // user defined class 'VectorIndex16Operand'
  MCK_VectorIndex32, // user defined class 'VectorIndex32Operand'
  MCK_VectorIndex64, // user defined class 'VectorIndex64Operand'
  MCK_VectorIndex8, // user defined class 'VectorIndex8Operand'
  MCK_MemTBB, // user defined class 'addrmode_tbb_asmoperand'
  MCK_MemTBH, // user defined class 'addrmode_tbh_asmoperand'
  MCK_ComplexRotationEven, // user defined class 'anonymous_3111'
  MCK_ComplexRotationOdd, // user defined class 'anonymous_3112'
  MCK_NEONi16vmovi8Replicate, // user defined class 'anonymous_4141'
  MCK_NEONi16invi8Replicate, // user defined class 'anonymous_4143'
  MCK_NEONi32vmovi8Replicate, // user defined class 'anonymous_4146'
  MCK_NEONi32invi8Replicate, // user defined class 'anonymous_4148'
  MCK_NEONi64vmovi8Replicate, // user defined class 'anonymous_4155'
  MCK_NEONi64invi8Replicate, // user defined class 'anonymous_4157'
  MCK_NEONi32vmovi16Replicate, // user defined class 'anonymous_4168'
  MCK_NEONi64vmovi16Replicate, // user defined class 'anonymous_4171'
  MCK_NEONi64vmovi32Replicate, // user defined class 'anonymous_4178'
  MCK_ConstPoolAsmImm, // user defined class 'const_pool_asm_operand'
  MCK_FBits16, // user defined class 'fbits16_asm_operand'
  MCK_FBits32, // user defined class 'fbits32_asm_operand'
  MCK_Imm0_4095, // user defined class 'imm0_4095_asmoperand'
  MCK_Imm0_4095Neg, // user defined class 'imm0_4095_neg_asmoperand'
  MCK_ITMask, // user defined class 'it_mask_asmoperand'
  MCK_ITCondCode, // user defined class 'it_pred_asmoperand'
  MCK_NEONi16splat, // user defined class 'nImmSplatI16AsmOperand'
  MCK_NEONi32splat, // user defined class 'nImmSplatI32AsmOperand'
  MCK_NEONi64splat, // user defined class 'nImmSplatI64AsmOperand'
  MCK_NEONi8splat, // user defined class 'nImmSplatI8AsmOperand'
  MCK_NEONi16splatNot, // user defined class 'nImmSplatNotI16AsmOperand'
  MCK_NEONi32splatNot, // user defined class 'nImmSplatNotI32AsmOperand'
  MCK_NEONi32vmov, // user defined class 'nImmVMOVI32AsmOperand'
  MCK_NEONi32vmovNeg, // user defined class 'nImmVMOVI32NegAsmOperand'
  MCK_ShrImm16, // user defined class 'shr_imm16_asm_operand'
  MCK_ShrImm32, // user defined class 'shr_imm32_asm_operand'
  MCK_ShrImm64, // user defined class 'shr_imm64_asm_operand'
  MCK_ShrImm8, // user defined class 'shr_imm8_asm_operand'
  MCK_T2SOImm, // user defined class 't2_so_imm_asmoperand'
  MCK_T2SOImmNeg, // user defined class 't2_so_imm_neg_asmoperand'
  MCK_T2SOImmNot, // user defined class 't2_so_imm_not_asmoperand'
  MCK_MemUImm12Offset, // user defined class 't2addrmode_imm12_asmoperand'
  MCK_T2MemRegOffset, // user defined class 't2addrmode_so_reg_asmoperand'
  MCK_Imm8s4, // user defined class 't2am_imm8s4_offset_asmoperand'
  MCK_MemPCRelImm12, // user defined class 't2ldr_pcrel_imm12_asmoperand'
  MCK_MemThumbRIs1, // user defined class 't_addrmode_is1_asm_operand'
  MCK_MemThumbRIs2, // user defined class 't_addrmode_is2_asm_operand'
  MCK_MemThumbRIs4, // user defined class 't_addrmode_is4_asm_operand'
  MCK_MemThumbRR, // user defined class 't_addrmode_rr_asm_operand'
  MCK_MemThumbSPI, // user defined class 't_addrmode_sp_asm_operand'
  MCK_Imm0_1020s4, // user defined class 't_imm0_1020s4_asmoperand'
  MCK_Imm0_508s4, // user defined class 't_imm0_508s4_asmoperand'
  MCK_Imm0_508s4Neg, // user defined class 't_imm0_508s4_neg_asmoperand'
  NumMatchClassKinds
};

}

static const char *getMatchKindDiag(ARMAsmParser::ARMMatchResultTy MatchResult) {
  switch (MatchResult) {
  case ARMAsmParser::Match_GPRsp:
    return "operand must be a register sp";
  case ARMAsmParser::Match_QPR_8:
    return "operand must be a register in range [q0, q3]";
  case ARMAsmParser::Match_DPR_8:
    return "operand must be a register in range [d0, d7]";
  case ARMAsmParser::Match_QPR_VFP2:
    return "operand must be a register in range [q0, q7]";
  case ARMAsmParser::Match_hGPR:
    return "operand must be a register in range [r8, r15]";
  case ARMAsmParser::Match_tGPR:
    return "operand must be a register in range [r0, r7]";
  case ARMAsmParser::Match_GPRnopc:
    return "operand must be a register in range [r0, r14]";
  case ARMAsmParser::Match_DPR_VFP2:
    return "operand must be a register in range [d0, d15]";
  case ARMAsmParser::Match_GPR:
    return "operand must be a register in range [r0, r15]";
  case ARMAsmParser::Match_GPRwithAPSR:
    return "operand must be a register in range [r0, r14] or apsr_nzcv";
  case ARMAsmParser::Match_QPR:
    return "operand must be a register in range [q0, q15]";
  case ARMAsmParser::Match_SPR_8:
    return "operand must be a register in range [s0, s15]";
  case ARMAsmParser::Match_SPR:
    return "operand must be a register in range [s0, s31]";
  case ARMAsmParser::Match_AlignedMemory16:
    return "alignment must be 16 or omitted";
  case ARMAsmParser::Match_AlignedMemory32:
    return "alignment must be 32 or omitted";
  case ARMAsmParser::Match_AlignedMemory64:
    return "alignment must be 64 or omitted";
  case ARMAsmParser::Match_AlignedMemory64or128:
    return "alignment must be 64, 128 or omitted";
  case ARMAsmParser::Match_AlignedMemory64or128or256:
    return "alignment must be 64, 128, 256 or omitted";
  case ARMAsmParser::Match_AlignedMemoryNone:
    return "alignment must be omitted";
  case ARMAsmParser::Match_DupAlignedMemory16:
    return "alignment must be 16 or omitted";
  case ARMAsmParser::Match_DupAlignedMemory32:
    return "alignment must be 32 or omitted";
  case ARMAsmParser::Match_DupAlignedMemory64:
    return "alignment must be 64 or omitted";
  case ARMAsmParser::Match_DupAlignedMemory64or128:
    return "alignment must be 64, 128 or omitted";
  case ARMAsmParser::Match_DupAlignedMemoryNone:
    return "alignment must be omitted";
  case ARMAsmParser::Match_Imm0_15:
    return "operand must be an immediate in the range [0,15]";
  case ARMAsmParser::Match_Imm0_1:
    return "operand must be an immediate in the range [0,1]";
  case ARMAsmParser::Match_Imm0_239:
    return "operand must be an immediate in the range [0,239]";
  case ARMAsmParser::Match_Imm0_255:
    return "operand must be an immediate in the range [0,255]";
  case ARMAsmParser::Match_Imm0_31:
    return "operand must be an immediate in the range [0,31]";
  case ARMAsmParser::Match_Imm0_32:
    return "operand must be an immediate in the range [0,32]";
  case ARMAsmParser::Match_Imm0_3:
    return "operand must be an immediate in the range [0,3]";
  case ARMAsmParser::Match_Imm0_63:
    return "operand must be an immediate in the range [0,63]";
  case ARMAsmParser::Match_Imm0_65535:
    return "operand must be an immediate in the range [0,65535]";
  case ARMAsmParser::Match_Imm0_65535Expr:
    return "operand must be an immediate in the range [0,0xffff] or a relocatable expression";
  case ARMAsmParser::Match_Imm0_7:
    return "operand must be an immediate in the range [0,7]";
  case ARMAsmParser::Match_Imm16:
    return "operand must be an immediate in the range [16,16]";
  case ARMAsmParser::Match_Imm1_15:
    return "operand must be an immediate in the range [1,15]";
  case ARMAsmParser::Match_ImmRange1_16:
    return "operand must be an immediate in the range [1,16]";
  case ARMAsmParser::Match_Imm1_31:
    return "operand must be an immediate in the range [1,31]";
  case ARMAsmParser::Match_ImmRange1_32:
    return "operand must be an immediate in the range [1,32]";
  case ARMAsmParser::Match_Imm1_7:
    return "operand must be an immediate in the range [1,7]";
  case ARMAsmParser::Match_Imm24bit:
    return "operand must be an immediate in the range [0,0xffffff]";
  case ARMAsmParser::Match_Imm256_65535Expr:
    return "operand must be an immediate in the range [256,65535]";
  case ARMAsmParser::Match_Imm32:
    return "operand must be an immediate in the range [32,32]";
  case ARMAsmParser::Match_Imm8:
    return "operand must be an immediate in the range [8,8]";
  case ARMAsmParser::Match_Imm8_255:
    return "operand must be an immediate in the range [8,255]";
  case ARMAsmParser::Match_PKHLSLImm:
    return "operand must be an immediate in the range [0,31]";
  case ARMAsmParser::Match_SPRRegList:
    return "operand must be a list of registers in range [s0, s31]";
  case ARMAsmParser::Match_SetEndImm:
    return "operand must be an immediate in the range [0,1]";
  case ARMAsmParser::Match_ImmThumbSR:
    return "operand must be an immediate in the range [1,32]";
  case ARMAsmParser::Match_ComplexRotationEven:
    return "complex rotation must be 0, 90, 180 or 270";
  case ARMAsmParser::Match_ComplexRotationOdd:
    return "complex rotation must be 90 or 270";
  case ARMAsmParser::Match_Imm0_4095:
    return "operand must be an immediate in the range [0,4095]";
  case ARMAsmParser::Match_ShrImm16:
    return "operand must be an immediate in the range [1,16]";
  case ARMAsmParser::Match_ShrImm32:
    return "operand must be an immediate in the range [1,32]";
  case ARMAsmParser::Match_ShrImm64:
    return "operand must be an immediate in the range [1,64]";
  case ARMAsmParser::Match_ShrImm8:
    return "operand must be an immediate in the range [1,8]";
  default:
    return nullptr;
  }
}

static unsigned getDiagKindFromRegisterClass(MatchClassKind RegisterClass) {
  switch (RegisterClass) {
  case MCK_GPRsp:
    return ARMAsmParser::Match_GPRsp;
  case MCK_QPR_8:
    return ARMAsmParser::Match_QPR_8;
  case MCK_DPR_8:
    return ARMAsmParser::Match_DPR_8;
  case MCK_QPR_VFP2:
    return ARMAsmParser::Match_QPR_VFP2;
  case MCK_hGPR:
    return ARMAsmParser::Match_hGPR;
  case MCK_tGPR:
    return ARMAsmParser::Match_tGPR;
  case MCK_rGPR:
    return ARMAsmParser::Match_rGPR;
  case MCK_GPRnopc:
    return ARMAsmParser::Match_GPRnopc;
  case MCK_DPR_VFP2:
    return ARMAsmParser::Match_DPR_VFP2;
  case MCK_GPR:
    return ARMAsmParser::Match_GPR;
  case MCK_GPRwithAPSR:
    return ARMAsmParser::Match_GPRwithAPSR;
  case MCK_QPR:
    return ARMAsmParser::Match_QPR;
  case MCK_SPR_8:
    return ARMAsmParser::Match_SPR_8;
  case MCK_DPR:
    return ARMAsmParser::Match_DPR;
  case MCK_HPR:
    return ARMAsmParser::Match_SPR;
  default:
    return MCTargetAsmParser::Match_InvalidOperand;
  }
}

static MatchClassKind matchTokenString(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 1:	 // 6 strings to match.
    switch (Name[0]) {
    default: break;
    case '!':	 // 1 string to match.
      return MCK__EXCLAIM_;	 // "!"
    case '[':	 // 1 string to match.
      return MCK__91_;	 // "["
    case ']':	 // 1 string to match.
      return MCK__93_;	 // "]"
    case '^':	 // 1 string to match.
      return MCK__94_;	 // "^"
    case '{':	 // 1 string to match.
      return MCK__123_;	 // "{"
    case '}':	 // 1 string to match.
      return MCK__125_;	 // "}"
    }
    break;
  case 2:	 // 5 strings to match.
    switch (Name[0]) {
    default: break;
    case '#':	 // 1 string to match.
      if (Name[1] != '0')
        break;
      return MCK__35_0;	 // "#0"
    case '.':	 // 4 strings to match.
      switch (Name[1]) {
      default: break;
      case '8':	 // 1 string to match.
        return MCK__DOT_8;	 // ".8"
      case 'd':	 // 1 string to match.
        return MCK__DOT_d;	 // ".d"
      case 'f':	 // 1 string to match.
        return MCK__DOT_f;	 // ".f"
      case 'w':	 // 1 string to match.
        return MCK__DOT_w;	 // ".w"
      }
      break;
    }
    break;
  case 3:	 // 7 strings to match.
    if (Name[0] != '.')
      break;
    switch (Name[1]) {
    default: break;
    case '1':	 // 1 string to match.
      if (Name[2] != '6')
        break;
      return MCK__DOT_16;	 // ".16"
    case '3':	 // 1 string to match.
      if (Name[2] != '2')
        break;
      return MCK__DOT_32;	 // ".32"
    case '6':	 // 1 string to match.
      if (Name[2] != '4')
        break;
      return MCK__DOT_64;	 // ".64"
    case 'i':	 // 1 string to match.
      if (Name[2] != '8')
        break;
      return MCK__DOT_i8;	 // ".i8"
    case 'p':	 // 1 string to match.
      if (Name[2] != '8')
        break;
      return MCK__DOT_p8;	 // ".p8"
    case 's':	 // 1 string to match.
      if (Name[2] != '8')
        break;
      return MCK__DOT_s8;	 // ".s8"
    case 'u':	 // 1 string to match.
      if (Name[2] != '8')
        break;
      return MCK__DOT_u8;	 // ".u8"
    }
    break;
  case 4:	 // 14 strings to match.
    if (Name[0] != '.')
      break;
    switch (Name[1]) {
    default: break;
    case 'f':	 // 3 strings to match.
      switch (Name[2]) {
      default: break;
      case '1':	 // 1 string to match.
        if (Name[3] != '6')
          break;
        return MCK__DOT_f16;	 // ".f16"
      case '3':	 // 1 string to match.
        if (Name[3] != '2')
          break;
        return MCK__DOT_f32;	 // ".f32"
      case '6':	 // 1 string to match.
        if (Name[3] != '4')
          break;
        return MCK__DOT_f64;	 // ".f64"
      }
      break;
    case 'i':	 // 3 strings to match.
      switch (Name[2]) {
      default: break;
      case '1':	 // 1 string to match.
        if (Name[3] != '6')
          break;
        return MCK__DOT_i16;	 // ".i16"
      case '3':	 // 1 string to match.
        if (Name[3] != '2')
          break;
        return MCK__DOT_i32;	 // ".i32"
      case '6':	 // 1 string to match.
        if (Name[3] != '4')
          break;
        return MCK__DOT_i64;	 // ".i64"
      }
      break;
    case 'p':	 // 2 strings to match.
      switch (Name[2]) {
      default: break;
      case '1':	 // 1 string to match.
        if (Name[3] != '6')
          break;
        return MCK__DOT_p16;	 // ".p16"
      case '6':	 // 1 string to match.
        if (Name[3] != '4')
          break;
        return MCK__DOT_p64;	 // ".p64"
      }
      break;
    case 's':	 // 3 strings to match.
      switch (Name[2]) {
      default: break;
      case '1':	 // 1 string to match.
        if (Name[3] != '6')
          break;
        return MCK__DOT_s16;	 // ".s16"
      case '3':	 // 1 string to match.
        if (Name[3] != '2')
          break;
        return MCK__DOT_s32;	 // ".s32"
      case '6':	 // 1 string to match.
        if (Name[3] != '4')
          break;
        return MCK__DOT_s64;	 // ".s64"
      }
      break;
    case 'u':	 // 3 strings to match.
      switch (Name[2]) {
      default: break;
      case '1':	 // 1 string to match.
        if (Name[3] != '6')
          break;
        return MCK__DOT_u16;	 // ".u16"
      case '3':	 // 1 string to match.
        if (Name[3] != '2')
          break;
        return MCK__DOT_u32;	 // ".u32"
      case '6':	 // 1 string to match.
        if (Name[3] != '4')
          break;
        return MCK__DOT_u64;	 // ".u64"
      }
      break;
    }
    break;
  }
  return InvalidMatchClass;
}

/// isSubclass - Compute whether \p A is a subclass of \p B.
static bool isSubclass(MatchClassKind A, MatchClassKind B) {
  if (A == B)
    return true;

  switch (A) {
  default:
    return false;

  case MCK__DOT_d:
    switch (B) {
    default: return false;
    case MCK__DOT_f64: return true;
    case MCK__DOT_64: return true;
    }

  case MCK__DOT_f:
    switch (B) {
    default: return false;
    case MCK__DOT_f32: return true;
    case MCK__DOT_32: return true;
    }

  case MCK__DOT_s16:
    switch (B) {
    default: return false;
    case MCK__DOT_i16: return true;
    case MCK__DOT_16: return true;
    }

  case MCK__DOT_s32:
    switch (B) {
    default: return false;
    case MCK__DOT_i32: return true;
    case MCK__DOT_32: return true;
    }

  case MCK__DOT_s64:
    switch (B) {
    default: return false;
    case MCK__DOT_i64: return true;
    case MCK__DOT_64: return true;
    }

  case MCK__DOT_s8:
    switch (B) {
    default: return false;
    case MCK__DOT_i8: return true;
    case MCK__DOT_8: return true;
    }

  case MCK__DOT_u16:
    switch (B) {
    default: return false;
    case MCK__DOT_i16: return true;
    case MCK__DOT_16: return true;
    }

  case MCK__DOT_u32:
    switch (B) {
    default: return false;
    case MCK__DOT_i32: return true;
    case MCK__DOT_32: return true;
    }

  case MCK__DOT_u64:
    switch (B) {
    default: return false;
    case MCK__DOT_i64: return true;
    case MCK__DOT_64: return true;
    }

  case MCK__DOT_u8:
    switch (B) {
    default: return false;
    case MCK__DOT_i8: return true;
    case MCK__DOT_8: return true;
    }

  case MCK__DOT_f32:
    return B == MCK__DOT_32;

  case MCK__DOT_f64:
    return B == MCK__DOT_64;

  case MCK__DOT_i16:
    return B == MCK__DOT_16;

  case MCK__DOT_i32:
    return B == MCK__DOT_32;

  case MCK__DOT_i64:
    return B == MCK__DOT_64;

  case MCK__DOT_i8:
    return B == MCK__DOT_8;

  case MCK__DOT_p16:
    return B == MCK__DOT_16;

  case MCK__DOT_p8:
    return B == MCK__DOT_8;

  case MCK_Reg75:
    switch (B) {
    default: return false;
    case MCK_Reg74: return true;
    case MCK_Reg72: return true;
    case MCK_GPRPair: return true;
    }

  case MCK_Reg59:
    switch (B) {
    default: return false;
    case MCK_Reg60: return true;
    case MCK_Reg61: return true;
    case MCK_Reg62: return true;
    case MCK_Reg63: return true;
    case MCK_Reg64: return true;
    case MCK_Reg65: return true;
    case MCK_Reg66: return true;
    case MCK_QQQQPR: return true;
    }

  case MCK_Reg11:
    switch (B) {
    default: return false;
    case MCK_tcGPR: return true;
    case MCK_Reg10: return true;
    case MCK_Reg8: return true;
    case MCK_hGPR: return true;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    }

  case MCK_APSR_NZCV:
    return B == MCK_GPRwithAPSR;

  case MCK_GPRsp:
    switch (B) {
    default: return false;
    case MCK_Reg8: return true;
    case MCK_hGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    }

  case MCK_LR:
    switch (B) {
    default: return false;
    case MCK_Reg10: return true;
    case MCK_Reg8: return true;
    case MCK_hGPR: return true;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    }

  case MCK_PC:
    switch (B) {
    default: return false;
    case MCK_hGPR: return true;
    case MCK_tGPRwithpc: return true;
    case MCK_GPR: return true;
    }

  case MCK_Reg100:
    switch (B) {
    default: return false;
    case MCK_Reg101: return true;
    case MCK_Reg102: return true;
    case MCK_Reg57: return true;
    case MCK_Reg103: return true;
    case MCK_Reg58: return true;
    case MCK_Reg104: return true;
    case MCK_Reg55: return true;
    case MCK_Reg105: return true;
    case MCK_Reg56: return true;
    case MCK_Reg53: return true;
    case MCK_Reg106: return true;
    case MCK_Reg54: return true;
    case MCK_Reg51: return true;
    case MCK_Reg52: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg73:
    switch (B) {
    default: return false;
    case MCK_Reg74: return true;
    case MCK_Reg70: return true;
    case MCK_GPRPair: return true;
    }

  case MCK_Reg68:
    switch (B) {
    default: return false;
    case MCK_Reg72: return true;
    case MCK_Reg69: return true;
    case MCK_Reg70: return true;
    case MCK_GPRPair: return true;
    }

  case MCK_Reg60:
    switch (B) {
    default: return false;
    case MCK_Reg61: return true;
    case MCK_Reg62: return true;
    case MCK_Reg63: return true;
    case MCK_Reg64: return true;
    case MCK_Reg65: return true;
    case MCK_Reg66: return true;
    case MCK_QQQQPR: return true;
    }

  case MCK_Reg101:
    switch (B) {
    default: return false;
    case MCK_Reg102: return true;
    case MCK_Reg103: return true;
    case MCK_Reg58: return true;
    case MCK_Reg104: return true;
    case MCK_Reg55: return true;
    case MCK_Reg105: return true;
    case MCK_Reg56: return true;
    case MCK_Reg53: return true;
    case MCK_Reg106: return true;
    case MCK_Reg54: return true;
    case MCK_Reg51: return true;
    case MCK_Reg52: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg88:
    switch (B) {
    default: return false;
    case MCK_Reg89: return true;
    case MCK_Reg76: return true;
    case MCK_Reg90: return true;
    case MCK_Reg77: return true;
    case MCK_Reg91: return true;
    case MCK_Reg78: return true;
    case MCK_Reg79: return true;
    case MCK_Reg92: return true;
    case MCK_Reg80: return true;
    case MCK_Reg81: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg83:
    switch (B) {
    default: return false;
    case MCK_Reg84: return true;
    case MCK_Reg76: return true;
    case MCK_Reg85: return true;
    case MCK_Reg77: return true;
    case MCK_Reg86: return true;
    case MCK_Reg78: return true;
    case MCK_Reg79: return true;
    case MCK_Reg87: return true;
    case MCK_Reg80: return true;
    case MCK_Reg81: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg74:
    return B == MCK_GPRPair;

  case MCK_Reg72:
    return B == MCK_GPRPair;

  case MCK_Reg61:
    switch (B) {
    default: return false;
    case MCK_Reg62: return true;
    case MCK_Reg63: return true;
    case MCK_Reg64: return true;
    case MCK_Reg65: return true;
    case MCK_Reg66: return true;
    case MCK_QQQQPR: return true;
    }

  case MCK_Reg45:
    switch (B) {
    default: return false;
    case MCK_Reg46: return true;
    case MCK_Reg57: return true;
    case MCK_Reg58: return true;
    case MCK_Reg55: return true;
    case MCK_Reg47: return true;
    case MCK_Reg56: return true;
    case MCK_Reg48: return true;
    case MCK_Reg53: return true;
    case MCK_Reg54: return true;
    case MCK_Reg51: return true;
    case MCK_QQPR: return true;
    case MCK_Reg52: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg102:
    switch (B) {
    default: return false;
    case MCK_Reg103: return true;
    case MCK_Reg104: return true;
    case MCK_Reg105: return true;
    case MCK_Reg56: return true;
    case MCK_Reg53: return true;
    case MCK_Reg106: return true;
    case MCK_Reg54: return true;
    case MCK_Reg51: return true;
    case MCK_Reg52: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg93:
    switch (B) {
    default: return false;
    case MCK_Reg94: return true;
    case MCK_Reg95: return true;
    case MCK_Reg96: return true;
    case MCK_Reg97: return true;
    case MCK_Reg98: return true;
    case MCK_DTripleSpc: return true;
    }

  case MCK_Reg89:
    switch (B) {
    default: return false;
    case MCK_Reg90: return true;
    case MCK_Reg91: return true;
    case MCK_Reg78: return true;
    case MCK_Reg79: return true;
    case MCK_Reg92: return true;
    case MCK_Reg80: return true;
    case MCK_Reg81: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg84:
    switch (B) {
    default: return false;
    case MCK_Reg85: return true;
    case MCK_Reg77: return true;
    case MCK_Reg86: return true;
    case MCK_Reg78: return true;
    case MCK_Reg79: return true;
    case MCK_Reg87: return true;
    case MCK_Reg80: return true;
    case MCK_Reg81: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg69:
    switch (B) {
    default: return false;
    case MCK_Reg70: return true;
    case MCK_GPRPair: return true;
    }

  case MCK_Reg62:
    switch (B) {
    default: return false;
    case MCK_Reg63: return true;
    case MCK_Reg64: return true;
    case MCK_Reg65: return true;
    case MCK_Reg66: return true;
    case MCK_QQQQPR: return true;
    }

  case MCK_Reg46:
    switch (B) {
    default: return false;
    case MCK_Reg55: return true;
    case MCK_Reg47: return true;
    case MCK_Reg56: return true;
    case MCK_Reg48: return true;
    case MCK_Reg53: return true;
    case MCK_Reg54: return true;
    case MCK_Reg51: return true;
    case MCK_QQPR: return true;
    case MCK_Reg52: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg0:
    switch (B) {
    default: return false;
    case MCK_tcGPR: return true;
    case MCK_tGPR: return true;
    case MCK_tGPRwithpc: return true;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    }

  case MCK_QPR_8:
    switch (B) {
    default: return false;
    case MCK_Reg26: return true;
    case MCK_Reg27: return true;
    case MCK_QPR_VFP2: return true;
    case MCK_Reg24: return true;
    case MCK_Reg25: return true;
    case MCK_QPR: return true;
    case MCK_DPair: return true;
    }

  case MCK_Reg63:
    switch (B) {
    default: return false;
    case MCK_Reg64: return true;
    case MCK_Reg65: return true;
    case MCK_Reg66: return true;
    case MCK_QQQQPR: return true;
    }

  case MCK_Reg57:
    switch (B) {
    default: return false;
    case MCK_Reg58: return true;
    case MCK_Reg55: return true;
    case MCK_Reg56: return true;
    case MCK_Reg53: return true;
    case MCK_Reg54: return true;
    case MCK_Reg51: return true;
    case MCK_Reg52: return true;
    case MCK_DQuad: return true;
    }

  case MCK_tcGPR:
    switch (B) {
    default: return false;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    }

  case MCK_Reg103:
    switch (B) {
    default: return false;
    case MCK_Reg104: return true;
    case MCK_Reg105: return true;
    case MCK_Reg53: return true;
    case MCK_Reg106: return true;
    case MCK_Reg54: return true;
    case MCK_Reg51: return true;
    case MCK_Reg52: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg94:
    switch (B) {
    default: return false;
    case MCK_Reg95: return true;
    case MCK_Reg96: return true;
    case MCK_Reg97: return true;
    case MCK_Reg98: return true;
    case MCK_DTripleSpc: return true;
    }

  case MCK_Reg76:
    switch (B) {
    default: return false;
    case MCK_Reg77: return true;
    case MCK_Reg78: return true;
    case MCK_Reg79: return true;
    case MCK_Reg80: return true;
    case MCK_Reg81: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg70:
    return B == MCK_GPRPair;

  case MCK_Reg64:
    switch (B) {
    default: return false;
    case MCK_Reg65: return true;
    case MCK_Reg66: return true;
    case MCK_QQQQPR: return true;
    }

  case MCK_Reg58:
    switch (B) {
    default: return false;
    case MCK_Reg55: return true;
    case MCK_Reg56: return true;
    case MCK_Reg53: return true;
    case MCK_Reg54: return true;
    case MCK_Reg51: return true;
    case MCK_Reg52: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg40:
    switch (B) {
    default: return false;
    case MCK_Reg41: return true;
    case MCK_Reg42: return true;
    case MCK_Reg43: return true;
    case MCK_DPairSpc: return true;
    }

  case MCK_Reg10:
    switch (B) {
    default: return false;
    case MCK_Reg8: return true;
    case MCK_hGPR: return true;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    }

  case MCK_Reg104:
    switch (B) {
    default: return false;
    case MCK_Reg105: return true;
    case MCK_Reg106: return true;
    case MCK_Reg54: return true;
    case MCK_Reg51: return true;
    case MCK_Reg52: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg90:
    switch (B) {
    default: return false;
    case MCK_Reg91: return true;
    case MCK_Reg79: return true;
    case MCK_Reg92: return true;
    case MCK_Reg80: return true;
    case MCK_Reg81: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg85:
    switch (B) {
    default: return false;
    case MCK_Reg86: return true;
    case MCK_Reg79: return true;
    case MCK_Reg87: return true;
    case MCK_Reg80: return true;
    case MCK_Reg81: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg77:
    switch (B) {
    default: return false;
    case MCK_Reg78: return true;
    case MCK_Reg79: return true;
    case MCK_Reg80: return true;
    case MCK_Reg81: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg65:
    switch (B) {
    default: return false;
    case MCK_Reg66: return true;
    case MCK_QQQQPR: return true;
    }

  case MCK_Reg55:
    switch (B) {
    default: return false;
    case MCK_Reg56: return true;
    case MCK_Reg53: return true;
    case MCK_Reg54: return true;
    case MCK_Reg51: return true;
    case MCK_Reg52: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg47:
    switch (B) {
    default: return false;
    case MCK_Reg48: return true;
    case MCK_Reg53: return true;
    case MCK_Reg54: return true;
    case MCK_Reg51: return true;
    case MCK_QQPR: return true;
    case MCK_Reg52: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg26:
    switch (B) {
    default: return false;
    case MCK_Reg27: return true;
    case MCK_Reg24: return true;
    case MCK_Reg25: return true;
    case MCK_DPair: return true;
    }

  case MCK_Reg8:
    switch (B) {
    default: return false;
    case MCK_hGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    }

  case MCK_Reg105:
    switch (B) {
    default: return false;
    case MCK_Reg106: return true;
    case MCK_Reg52: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg95:
    switch (B) {
    default: return false;
    case MCK_Reg96: return true;
    case MCK_Reg97: return true;
    case MCK_Reg98: return true;
    case MCK_DTripleSpc: return true;
    }

  case MCK_Reg91:
    switch (B) {
    default: return false;
    case MCK_Reg92: return true;
    case MCK_Reg81: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg86:
    switch (B) {
    default: return false;
    case MCK_Reg87: return true;
    case MCK_Reg80: return true;
    case MCK_Reg81: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg78:
    switch (B) {
    default: return false;
    case MCK_Reg79: return true;
    case MCK_Reg80: return true;
    case MCK_Reg81: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg66:
    return B == MCK_QQQQPR;

  case MCK_Reg56:
    switch (B) {
    default: return false;
    case MCK_Reg53: return true;
    case MCK_Reg54: return true;
    case MCK_Reg51: return true;
    case MCK_Reg52: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg48:
    switch (B) {
    default: return false;
    case MCK_Reg51: return true;
    case MCK_QQPR: return true;
    case MCK_Reg52: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg41:
    switch (B) {
    default: return false;
    case MCK_Reg42: return true;
    case MCK_Reg43: return true;
    case MCK_DPairSpc: return true;
    }

  case MCK_Reg27:
    switch (B) {
    default: return false;
    case MCK_Reg24: return true;
    case MCK_Reg25: return true;
    case MCK_DPair: return true;
    }

  case MCK_DPR_8:
    switch (B) {
    default: return false;
    case MCK_DPR_VFP2: return true;
    case MCK_DPR: return true;
    }

  case MCK_QPR_VFP2:
    switch (B) {
    default: return false;
    case MCK_Reg24: return true;
    case MCK_Reg25: return true;
    case MCK_QPR: return true;
    case MCK_DPair: return true;
    }

  case MCK_hGPR:
    return B == MCK_GPR;

  case MCK_tGPR:
    switch (B) {
    default: return false;
    case MCK_tGPRwithpc: return true;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    }

  case MCK_tGPRwithpc:
    return B == MCK_GPR;

  case MCK_Reg96:
    switch (B) {
    default: return false;
    case MCK_Reg97: return true;
    case MCK_Reg98: return true;
    case MCK_DTripleSpc: return true;
    }

  case MCK_Reg53:
    switch (B) {
    default: return false;
    case MCK_Reg54: return true;
    case MCK_Reg51: return true;
    case MCK_Reg52: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg106:
    return B == MCK_DQuad;

  case MCK_Reg97:
    switch (B) {
    default: return false;
    case MCK_Reg98: return true;
    case MCK_DTripleSpc: return true;
    }

  case MCK_Reg79:
    switch (B) {
    default: return false;
    case MCK_Reg80: return true;
    case MCK_Reg81: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg54:
    switch (B) {
    default: return false;
    case MCK_Reg51: return true;
    case MCK_Reg52: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg42:
    switch (B) {
    default: return false;
    case MCK_Reg43: return true;
    case MCK_DPairSpc: return true;
    }

  case MCK_rGPR:
    switch (B) {
    default: return false;
    case MCK_GPRnopc: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    }

  case MCK_Reg92:
    return B == MCK_DTriple;

  case MCK_Reg87:
    return B == MCK_DTriple;

  case MCK_Reg80:
    switch (B) {
    default: return false;
    case MCK_Reg81: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg51:
    switch (B) {
    default: return false;
    case MCK_Reg52: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg24:
    switch (B) {
    default: return false;
    case MCK_Reg25: return true;
    case MCK_DPair: return true;
    }

  case MCK_GPRnopc:
    switch (B) {
    default: return false;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    }

  case MCK_QQPR:
    return B == MCK_DQuad;

  case MCK_Reg98:
    return B == MCK_DTripleSpc;

  case MCK_Reg81:
    return B == MCK_DTriple;

  case MCK_Reg52:
    return B == MCK_DQuad;

  case MCK_Reg43:
    return B == MCK_DPairSpc;

  case MCK_Reg25:
    return B == MCK_DPair;

  case MCK_DPR_VFP2:
    return B == MCK_DPR;

  case MCK_QPR:
    return B == MCK_DPair;

  case MCK_SPR_8:
    return B == MCK_HPR;
  }
}

static unsigned validateOperandClass(MCParsedAsmOperand &GOp, MatchClassKind Kind) {
  ARMOperand &Operand = (ARMOperand&)GOp;
  if (Kind == InvalidMatchClass)
    return MCTargetAsmParser::Match_InvalidOperand;

  if (Operand.isToken() && Kind <= MCK_LAST_TOKEN)
    return isSubclass(matchTokenString(Operand.getToken()), Kind) ?
             MCTargetAsmParser::Match_Success :
             MCTargetAsmParser::Match_InvalidOperand;

  switch (Kind) {
  default: break;
  // 'AM2OffsetImm' class
  case MCK_AM2OffsetImm: {
    DiagnosticPredicate DP(Operand.isAM2OffsetImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'AM3Offset' class
  case MCK_AM3Offset: {
    DiagnosticPredicate DP(Operand.isAM3Offset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ARMBranchTarget' class
  case MCK_ARMBranchTarget: {
    DiagnosticPredicate DP(Operand.isARMBranchTarget());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'AddrMode3' class
  case MCK_AddrMode3: {
    DiagnosticPredicate DP(Operand.isAddrMode3());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'AddrMode5' class
  case MCK_AddrMode5: {
    DiagnosticPredicate DP(Operand.isAddrMode5());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'AddrMode5FP16' class
  case MCK_AddrMode5FP16: {
    DiagnosticPredicate DP(Operand.isAddrMode5FP16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'AlignedMemory16' class
  case MCK_AlignedMemory16: {
    DiagnosticPredicate DP(Operand.isAlignedMemory16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_AlignedMemory16;
    break;
    }
  // 'AlignedMemory32' class
  case MCK_AlignedMemory32: {
    DiagnosticPredicate DP(Operand.isAlignedMemory32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_AlignedMemory32;
    break;
    }
  // 'AlignedMemory64' class
  case MCK_AlignedMemory64: {
    DiagnosticPredicate DP(Operand.isAlignedMemory64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_AlignedMemory64;
    break;
    }
  // 'AlignedMemory64or128' class
  case MCK_AlignedMemory64or128: {
    DiagnosticPredicate DP(Operand.isAlignedMemory64or128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_AlignedMemory64or128;
    break;
    }
  // 'AlignedMemory64or128or256' class
  case MCK_AlignedMemory64or128or256: {
    DiagnosticPredicate DP(Operand.isAlignedMemory64or128or256());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_AlignedMemory64or128or256;
    break;
    }
  // 'AlignedMemoryNone' class
  case MCK_AlignedMemoryNone: {
    DiagnosticPredicate DP(Operand.isAlignedMemoryNone());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_AlignedMemoryNone;
    break;
    }
  // 'AlignedMemory' class
  case MCK_AlignedMemory: {
    DiagnosticPredicate DP(Operand.isAlignedMemory());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'DupAlignedMemory16' class
  case MCK_DupAlignedMemory16: {
    DiagnosticPredicate DP(Operand.isDupAlignedMemory16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_DupAlignedMemory16;
    break;
    }
  // 'DupAlignedMemory32' class
  case MCK_DupAlignedMemory32: {
    DiagnosticPredicate DP(Operand.isDupAlignedMemory32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_DupAlignedMemory32;
    break;
    }
  // 'DupAlignedMemory64' class
  case MCK_DupAlignedMemory64: {
    DiagnosticPredicate DP(Operand.isDupAlignedMemory64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_DupAlignedMemory64;
    break;
    }
  // 'DupAlignedMemory64or128' class
  case MCK_DupAlignedMemory64or128: {
    DiagnosticPredicate DP(Operand.isDupAlignedMemory64or128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_DupAlignedMemory64or128;
    break;
    }
  // 'DupAlignedMemoryNone' class
  case MCK_DupAlignedMemoryNone: {
    DiagnosticPredicate DP(Operand.isDupAlignedMemoryNone());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_DupAlignedMemoryNone;
    break;
    }
  // 'AdrLabel' class
  case MCK_AdrLabel: {
    DiagnosticPredicate DP(Operand.isAdrLabel());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'BankedReg' class
  case MCK_BankedReg: {
    DiagnosticPredicate DP(Operand.isBankedReg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Bitfield' class
  case MCK_Bitfield: {
    DiagnosticPredicate DP(Operand.isBitfield());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'CCOut' class
  case MCK_CCOut: {
    DiagnosticPredicate DP(Operand.isCCOut());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'CondCode' class
  case MCK_CondCode: {
    DiagnosticPredicate DP(Operand.isCondCode());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'CoprocNum' class
  case MCK_CoprocNum: {
    DiagnosticPredicate DP(Operand.isCoprocNum());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'CoprocOption' class
  case MCK_CoprocOption: {
    DiagnosticPredicate DP(Operand.isCoprocOption());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'CoprocReg' class
  case MCK_CoprocReg: {
    DiagnosticPredicate DP(Operand.isCoprocReg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'DPRRegList' class
  case MCK_DPRRegList: {
    DiagnosticPredicate DP(Operand.isDPRRegList());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_DPR_RegList;
    break;
    }
  // 'FPImm' class
  case MCK_FPImm: {
    DiagnosticPredicate DP(Operand.isFPImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Imm0_15' class
  case MCK_Imm0_15: {
    DiagnosticPredicate DP(Operand.isImmediate<0,15>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_15;
    break;
    }
  // 'Imm0_1' class
  case MCK_Imm0_1: {
    DiagnosticPredicate DP(Operand.isImmediate<0,1>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_1;
    break;
    }
  // 'Imm0_239' class
  case MCK_Imm0_239: {
    DiagnosticPredicate DP(Operand.isImmediate<0,239>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_239;
    break;
    }
  // 'Imm0_255' class
  case MCK_Imm0_255: {
    DiagnosticPredicate DP(Operand.isImmediate<0,255>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_255;
    break;
    }
  // 'Imm0_31' class
  case MCK_Imm0_31: {
    DiagnosticPredicate DP(Operand.isImmediate<0,31>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_31;
    break;
    }
  // 'Imm0_32' class
  case MCK_Imm0_32: {
    DiagnosticPredicate DP(Operand.isImmediate<0,32>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_32;
    break;
    }
  // 'Imm0_3' class
  case MCK_Imm0_3: {
    DiagnosticPredicate DP(Operand.isImmediate<0,3>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_3;
    break;
    }
  // 'Imm0_63' class
  case MCK_Imm0_63: {
    DiagnosticPredicate DP(Operand.isImmediate<0,63>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_63;
    break;
    }
  // 'Imm0_65535' class
  case MCK_Imm0_65535: {
    DiagnosticPredicate DP(Operand.isImmediate<0,65535>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_65535;
    break;
    }
  // 'Imm0_65535Expr' class
  case MCK_Imm0_65535Expr: {
    DiagnosticPredicate DP(Operand.isImm0_65535Expr());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_65535Expr;
    break;
    }
  // 'Imm0_7' class
  case MCK_Imm0_7: {
    DiagnosticPredicate DP(Operand.isImmediate<0,7>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_7;
    break;
    }
  // 'Imm16' class
  case MCK_Imm16: {
    DiagnosticPredicate DP(Operand.isImmediate<16,16>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm16;
    break;
    }
  // 'Imm1_15' class
  case MCK_Imm1_15: {
    DiagnosticPredicate DP(Operand.isImmediate<1,15>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm1_15;
    break;
    }
  // 'Imm1_16' class
  case MCK_Imm1_16: {
    DiagnosticPredicate DP(Operand.isImmediate<1,16>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_ImmRange1_16;
    break;
    }
  // 'Imm1_31' class
  case MCK_Imm1_31: {
    DiagnosticPredicate DP(Operand.isImmediate<1,31>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm1_31;
    break;
    }
  // 'Imm1_32' class
  case MCK_Imm1_32: {
    DiagnosticPredicate DP(Operand.isImmediate<1,32>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_ImmRange1_32;
    break;
    }
  // 'Imm1_7' class
  case MCK_Imm1_7: {
    DiagnosticPredicate DP(Operand.isImmediate<1,7>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm1_7;
    break;
    }
  // 'Imm24bit' class
  case MCK_Imm24bit: {
    DiagnosticPredicate DP(Operand.isImmediate<0,16777215>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm24bit;
    break;
    }
  // 'Imm256_65535Expr' class
  case MCK_Imm256_65535Expr: {
    DiagnosticPredicate DP(Operand.isImmediate<256,65535>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm256_65535Expr;
    break;
    }
  // 'Imm32' class
  case MCK_Imm32: {
    DiagnosticPredicate DP(Operand.isImmediate<32,32>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm32;
    break;
    }
  // 'Imm8' class
  case MCK_Imm8: {
    DiagnosticPredicate DP(Operand.isImmediate<8,8>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm8;
    break;
    }
  // 'Imm8_255' class
  case MCK_Imm8_255: {
    DiagnosticPredicate DP(Operand.isImmediate<8,255>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm8_255;
    break;
    }
  // 'Imm' class
  case MCK_Imm: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'InstSyncBarrierOpt' class
  case MCK_InstSyncBarrierOpt: {
    DiagnosticPredicate DP(Operand.isInstSyncBarrierOpt());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MSRMask' class
  case MCK_MSRMask: {
    DiagnosticPredicate DP(Operand.isMSRMask());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemBarrierOpt' class
  case MCK_MemBarrierOpt: {
    DiagnosticPredicate DP(Operand.isMemBarrierOpt());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemImm0_1020s4Offset' class
  case MCK_MemImm0_1020s4Offset: {
    DiagnosticPredicate DP(Operand.isMemImm0_1020s4Offset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemImm12Offset' class
  case MCK_MemImm12Offset: {
    DiagnosticPredicate DP(Operand.isMemImm12Offset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemImm8Offset' class
  case MCK_MemImm8Offset: {
    DiagnosticPredicate DP(Operand.isMemImm8Offset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemImm8s4Offset' class
  case MCK_MemImm8s4Offset: {
    DiagnosticPredicate DP(Operand.isMemImm8s4Offset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemNegImm8Offset' class
  case MCK_MemNegImm8Offset: {
    DiagnosticPredicate DP(Operand.isMemNegImm8Offset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemNoOffset' class
  case MCK_MemNoOffset: {
    DiagnosticPredicate DP(Operand.isMemNoOffset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemPosImm8Offset' class
  case MCK_MemPosImm8Offset: {
    DiagnosticPredicate DP(Operand.isMemPosImm8Offset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemRegOffset' class
  case MCK_MemRegOffset: {
    DiagnosticPredicate DP(Operand.isMemRegOffset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ModImm' class
  case MCK_ModImm: {
    DiagnosticPredicate DP(Operand.isModImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ModImmNeg' class
  case MCK_ModImmNeg: {
    DiagnosticPredicate DP(Operand.isModImmNeg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ModImmNot' class
  case MCK_ModImmNot: {
    DiagnosticPredicate DP(Operand.isModImmNot());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'PKHASRImm' class
  case MCK_PKHASRImm: {
    DiagnosticPredicate DP(Operand.isPKHASRImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'PKHLSLImm' class
  case MCK_PKHLSLImm: {
    DiagnosticPredicate DP(Operand.isImmediate<0,31>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_PKHLSLImm;
    break;
    }
  // 'PostIdxImm8' class
  case MCK_PostIdxImm8: {
    DiagnosticPredicate DP(Operand.isPostIdxImm8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'PostIdxImm8s4' class
  case MCK_PostIdxImm8s4: {
    DiagnosticPredicate DP(Operand.isPostIdxImm8s4());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'PostIdxReg' class
  case MCK_PostIdxReg: {
    DiagnosticPredicate DP(Operand.isPostIdxReg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'PostIdxRegShifted' class
  case MCK_PostIdxRegShifted: {
    DiagnosticPredicate DP(Operand.isPostIdxRegShifted());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ProcIFlags' class
  case MCK_ProcIFlags: {
    DiagnosticPredicate DP(Operand.isProcIFlags());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'RegList' class
  case MCK_RegList: {
    DiagnosticPredicate DP(Operand.isRegList());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'RotImm' class
  case MCK_RotImm: {
    DiagnosticPredicate DP(Operand.isRotImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'SPRRegList' class
  case MCK_SPRRegList: {
    DiagnosticPredicate DP(Operand.isSPRRegList());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_SPRRegList;
    break;
    }
  // 'SetEndImm' class
  case MCK_SetEndImm: {
    DiagnosticPredicate DP(Operand.isImmediate<0,1>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_SetEndImm;
    break;
    }
  // 'RegShiftedImm' class
  case MCK_RegShiftedImm: {
    DiagnosticPredicate DP(Operand.isRegShiftedImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'RegShiftedReg' class
  case MCK_RegShiftedReg: {
    DiagnosticPredicate DP(Operand.isRegShiftedReg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ShifterImm' class
  case MCK_ShifterImm: {
    DiagnosticPredicate DP(Operand.isShifterImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ThumbBranchTarget' class
  case MCK_ThumbBranchTarget: {
    DiagnosticPredicate DP(Operand.isThumbBranchTarget());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ThumbMemPC' class
  case MCK_ThumbMemPC: {
    DiagnosticPredicate DP(Operand.isThumbMemPC());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ThumbModImmNeg1_7' class
  case MCK_ThumbModImmNeg1_7: {
    DiagnosticPredicate DP(Operand.isThumbModImmNeg1_7());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ThumbModImmNeg8_255' class
  case MCK_ThumbModImmNeg8_255: {
    DiagnosticPredicate DP(Operand.isThumbModImmNeg8_255());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ImmThumbSR' class
  case MCK_ImmThumbSR: {
    DiagnosticPredicate DP(Operand.isImmediate<1,32>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_ImmThumbSR;
    break;
    }
  // 'TraceSyncBarrierOpt' class
  case MCK_TraceSyncBarrierOpt: {
    DiagnosticPredicate DP(Operand.isTraceSyncBarrierOpt());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'UnsignedOffset_b8s2' class
  case MCK_UnsignedOffset_b8s2: {
    DiagnosticPredicate DP(Operand.isUnsignedOffset<8, 2>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListDPairAllLanes' class
  case MCK_VecListDPairAllLanes: {
    DiagnosticPredicate DP(Operand.isVecListDPairAllLanes());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListDPair' class
  case MCK_VecListDPair: {
    DiagnosticPredicate DP(Operand.isVecListDPair());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListDPairSpacedAllLanes' class
  case MCK_VecListDPairSpacedAllLanes: {
    DiagnosticPredicate DP(Operand.isVecListDPairSpacedAllLanes());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListDPairSpaced' class
  case MCK_VecListDPairSpaced: {
    DiagnosticPredicate DP(Operand.isVecListDPairSpaced());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListFourDAllLanes' class
  case MCK_VecListFourDAllLanes: {
    DiagnosticPredicate DP(Operand.isVecListFourDAllLanes());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListFourD' class
  case MCK_VecListFourD: {
    DiagnosticPredicate DP(Operand.isVecListFourD());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListFourDByteIndexed' class
  case MCK_VecListFourDByteIndexed: {
    DiagnosticPredicate DP(Operand.isVecListFourDByteIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListFourDHWordIndexed' class
  case MCK_VecListFourDHWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListFourDHWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListFourDWordIndexed' class
  case MCK_VecListFourDWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListFourDWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListFourQAllLanes' class
  case MCK_VecListFourQAllLanes: {
    DiagnosticPredicate DP(Operand.isVecListFourQAllLanes());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListFourQ' class
  case MCK_VecListFourQ: {
    DiagnosticPredicate DP(Operand.isVecListFourQ());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListFourQHWordIndexed' class
  case MCK_VecListFourQHWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListFourQHWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListFourQWordIndexed' class
  case MCK_VecListFourQWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListFourQWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListOneDAllLanes' class
  case MCK_VecListOneDAllLanes: {
    DiagnosticPredicate DP(Operand.isVecListOneDAllLanes());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListOneD' class
  case MCK_VecListOneD: {
    DiagnosticPredicate DP(Operand.isVecListOneD());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListOneDByteIndexed' class
  case MCK_VecListOneDByteIndexed: {
    DiagnosticPredicate DP(Operand.isVecListOneDByteIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListOneDHWordIndexed' class
  case MCK_VecListOneDHWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListOneDHWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListOneDWordIndexed' class
  case MCK_VecListOneDWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListOneDWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListThreeDAllLanes' class
  case MCK_VecListThreeDAllLanes: {
    DiagnosticPredicate DP(Operand.isVecListThreeDAllLanes());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListThreeD' class
  case MCK_VecListThreeD: {
    DiagnosticPredicate DP(Operand.isVecListThreeD());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListThreeDByteIndexed' class
  case MCK_VecListThreeDByteIndexed: {
    DiagnosticPredicate DP(Operand.isVecListThreeDByteIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListThreeDHWordIndexed' class
  case MCK_VecListThreeDHWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListThreeDHWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListThreeDWordIndexed' class
  case MCK_VecListThreeDWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListThreeDWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListThreeQAllLanes' class
  case MCK_VecListThreeQAllLanes: {
    DiagnosticPredicate DP(Operand.isVecListThreeQAllLanes());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListThreeQ' class
  case MCK_VecListThreeQ: {
    DiagnosticPredicate DP(Operand.isVecListThreeQ());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListThreeQHWordIndexed' class
  case MCK_VecListThreeQHWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListThreeQHWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListThreeQWordIndexed' class
  case MCK_VecListThreeQWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListThreeQWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListTwoDByteIndexed' class
  case MCK_VecListTwoDByteIndexed: {
    DiagnosticPredicate DP(Operand.isVecListTwoDByteIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListTwoDHWordIndexed' class
  case MCK_VecListTwoDHWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListTwoDHWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListTwoDWordIndexed' class
  case MCK_VecListTwoDWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListTwoDWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListTwoQHWordIndexed' class
  case MCK_VecListTwoQHWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListTwoQHWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListTwoQWordIndexed' class
  case MCK_VecListTwoQWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListTwoQWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VectorIndex16' class
  case MCK_VectorIndex16: {
    DiagnosticPredicate DP(Operand.isVectorIndex16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VectorIndex32' class
  case MCK_VectorIndex32: {
    DiagnosticPredicate DP(Operand.isVectorIndex32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VectorIndex64' class
  case MCK_VectorIndex64: {
    DiagnosticPredicate DP(Operand.isVectorIndex64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VectorIndex8' class
  case MCK_VectorIndex8: {
    DiagnosticPredicate DP(Operand.isVectorIndex8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemTBB' class
  case MCK_MemTBB: {
    DiagnosticPredicate DP(Operand.isMemTBB());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemTBH' class
  case MCK_MemTBH: {
    DiagnosticPredicate DP(Operand.isMemTBH());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ComplexRotationEven' class
  case MCK_ComplexRotationEven: {
    DiagnosticPredicate DP(Operand.isComplexRotation<90, 0>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_ComplexRotationEven;
    break;
    }
  // 'ComplexRotationOdd' class
  case MCK_ComplexRotationOdd: {
    DiagnosticPredicate DP(Operand.isComplexRotation<180, 90>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_ComplexRotationOdd;
    break;
    }
  // 'NEONi16vmovi8Replicate' class
  case MCK_NEONi16vmovi8Replicate: {
    DiagnosticPredicate DP(Operand.isNEONmovReplicate<8, 16>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi16invi8Replicate' class
  case MCK_NEONi16invi8Replicate: {
    DiagnosticPredicate DP(Operand.isNEONinvReplicate<8, 16>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi32vmovi8Replicate' class
  case MCK_NEONi32vmovi8Replicate: {
    DiagnosticPredicate DP(Operand.isNEONmovReplicate<8, 32>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi32invi8Replicate' class
  case MCK_NEONi32invi8Replicate: {
    DiagnosticPredicate DP(Operand.isNEONinvReplicate<8, 32>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi64vmovi8Replicate' class
  case MCK_NEONi64vmovi8Replicate: {
    DiagnosticPredicate DP(Operand.isNEONmovReplicate<8, 64>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi64invi8Replicate' class
  case MCK_NEONi64invi8Replicate: {
    DiagnosticPredicate DP(Operand.isNEONinvReplicate<8, 64>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi32vmovi16Replicate' class
  case MCK_NEONi32vmovi16Replicate: {
    DiagnosticPredicate DP(Operand.isNEONmovReplicate<16, 32>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi64vmovi16Replicate' class
  case MCK_NEONi64vmovi16Replicate: {
    DiagnosticPredicate DP(Operand.isNEONmovReplicate<16, 64>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi64vmovi32Replicate' class
  case MCK_NEONi64vmovi32Replicate: {
    DiagnosticPredicate DP(Operand.isNEONmovReplicate<32, 64>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ConstPoolAsmImm' class
  case MCK_ConstPoolAsmImm: {
    DiagnosticPredicate DP(Operand.isConstPoolAsmImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'FBits16' class
  case MCK_FBits16: {
    DiagnosticPredicate DP(Operand.isFBits16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'FBits32' class
  case MCK_FBits32: {
    DiagnosticPredicate DP(Operand.isFBits32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Imm0_4095' class
  case MCK_Imm0_4095: {
    DiagnosticPredicate DP(Operand.isImmediate<0,4095>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_4095;
    break;
    }
  // 'Imm0_4095Neg' class
  case MCK_Imm0_4095Neg: {
    DiagnosticPredicate DP(Operand.isImm0_4095Neg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ITMask' class
  case MCK_ITMask: {
    DiagnosticPredicate DP(Operand.isITMask());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ITCondCode' class
  case MCK_ITCondCode: {
    DiagnosticPredicate DP(Operand.isITCondCode());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi16splat' class
  case MCK_NEONi16splat: {
    DiagnosticPredicate DP(Operand.isNEONi16splat());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi32splat' class
  case MCK_NEONi32splat: {
    DiagnosticPredicate DP(Operand.isNEONi32splat());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi64splat' class
  case MCK_NEONi64splat: {
    DiagnosticPredicate DP(Operand.isNEONi64splat());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi8splat' class
  case MCK_NEONi8splat: {
    DiagnosticPredicate DP(Operand.isNEONi8splat());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi16splatNot' class
  case MCK_NEONi16splatNot: {
    DiagnosticPredicate DP(Operand.isNEONi16splatNot());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi32splatNot' class
  case MCK_NEONi32splatNot: {
    DiagnosticPredicate DP(Operand.isNEONi32splatNot());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi32vmov' class
  case MCK_NEONi32vmov: {
    DiagnosticPredicate DP(Operand.isNEONi32vmov());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi32vmovNeg' class
  case MCK_NEONi32vmovNeg: {
    DiagnosticPredicate DP(Operand.isNEONi32vmovNeg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ShrImm16' class
  case MCK_ShrImm16: {
    DiagnosticPredicate DP(Operand.isImmediate<1,16>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_ShrImm16;
    break;
    }
  // 'ShrImm32' class
  case MCK_ShrImm32: {
    DiagnosticPredicate DP(Operand.isImmediate<1,32>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_ShrImm32;
    break;
    }
  // 'ShrImm64' class
  case MCK_ShrImm64: {
    DiagnosticPredicate DP(Operand.isImmediate<1,64>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_ShrImm64;
    break;
    }
  // 'ShrImm8' class
  case MCK_ShrImm8: {
    DiagnosticPredicate DP(Operand.isImmediate<1,8>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_ShrImm8;
    break;
    }
  // 'T2SOImm' class
  case MCK_T2SOImm: {
    DiagnosticPredicate DP(Operand.isT2SOImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'T2SOImmNeg' class
  case MCK_T2SOImmNeg: {
    DiagnosticPredicate DP(Operand.isT2SOImmNeg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'T2SOImmNot' class
  case MCK_T2SOImmNot: {
    DiagnosticPredicate DP(Operand.isT2SOImmNot());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemUImm12Offset' class
  case MCK_MemUImm12Offset: {
    DiagnosticPredicate DP(Operand.isMemUImm12Offset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'T2MemRegOffset' class
  case MCK_T2MemRegOffset: {
    DiagnosticPredicate DP(Operand.isT2MemRegOffset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Imm8s4' class
  case MCK_Imm8s4: {
    DiagnosticPredicate DP(Operand.isImm8s4());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemPCRelImm12' class
  case MCK_MemPCRelImm12: {
    DiagnosticPredicate DP(Operand.isMemPCRelImm12());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemThumbRIs1' class
  case MCK_MemThumbRIs1: {
    DiagnosticPredicate DP(Operand.isMemThumbRIs1());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemThumbRIs2' class
  case MCK_MemThumbRIs2: {
    DiagnosticPredicate DP(Operand.isMemThumbRIs2());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemThumbRIs4' class
  case MCK_MemThumbRIs4: {
    DiagnosticPredicate DP(Operand.isMemThumbRIs4());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemThumbRR' class
  case MCK_MemThumbRR: {
    DiagnosticPredicate DP(Operand.isMemThumbRR());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemThumbSPI' class
  case MCK_MemThumbSPI: {
    DiagnosticPredicate DP(Operand.isMemThumbSPI());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Imm0_1020s4' class
  case MCK_Imm0_1020s4: {
    DiagnosticPredicate DP(Operand.isImm0_1020s4());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Imm0_508s4' class
  case MCK_Imm0_508s4: {
    DiagnosticPredicate DP(Operand.isImm0_508s4());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Imm0_508s4Neg' class
  case MCK_Imm0_508s4Neg: {
    DiagnosticPredicate DP(Operand.isImm0_508s4Neg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  } // end switch (Kind)

  if (Operand.isReg()) {
    MatchClassKind OpKind;
    switch (Operand.getReg()) {
    default: OpKind = InvalidMatchClass; break;
    case ARM::R0: OpKind = MCK_Reg0; break;
    case ARM::R1: OpKind = MCK_Reg0; break;
    case ARM::R2: OpKind = MCK_Reg0; break;
    case ARM::R3: OpKind = MCK_Reg0; break;
    case ARM::R4: OpKind = MCK_tGPR; break;
    case ARM::R5: OpKind = MCK_tGPR; break;
    case ARM::R6: OpKind = MCK_tGPR; break;
    case ARM::R7: OpKind = MCK_tGPR; break;
    case ARM::R8: OpKind = MCK_Reg10; break;
    case ARM::R9: OpKind = MCK_Reg10; break;
    case ARM::R10: OpKind = MCK_Reg10; break;
    case ARM::R11: OpKind = MCK_Reg10; break;
    case ARM::R12: OpKind = MCK_Reg11; break;
    case ARM::SP: OpKind = MCK_GPRsp; break;
    case ARM::LR: OpKind = MCK_LR; break;
    case ARM::PC: OpKind = MCK_PC; break;
    case ARM::S0: OpKind = MCK_SPR_8; break;
    case ARM::S1: OpKind = MCK_SPR_8; break;
    case ARM::S2: OpKind = MCK_SPR_8; break;
    case ARM::S3: OpKind = MCK_SPR_8; break;
    case ARM::S4: OpKind = MCK_SPR_8; break;
    case ARM::S5: OpKind = MCK_SPR_8; break;
    case ARM::S6: OpKind = MCK_SPR_8; break;
    case ARM::S7: OpKind = MCK_SPR_8; break;
    case ARM::S8: OpKind = MCK_SPR_8; break;
    case ARM::S9: OpKind = MCK_SPR_8; break;
    case ARM::S10: OpKind = MCK_SPR_8; break;
    case ARM::S11: OpKind = MCK_SPR_8; break;
    case ARM::S12: OpKind = MCK_SPR_8; break;
    case ARM::S13: OpKind = MCK_SPR_8; break;
    case ARM::S14: OpKind = MCK_SPR_8; break;
    case ARM::S15: OpKind = MCK_SPR_8; break;
    case ARM::S16: OpKind = MCK_HPR; break;
    case ARM::S17: OpKind = MCK_HPR; break;
    case ARM::S18: OpKind = MCK_HPR; break;
    case ARM::S19: OpKind = MCK_HPR; break;
    case ARM::S20: OpKind = MCK_HPR; break;
    case ARM::S21: OpKind = MCK_HPR; break;
    case ARM::S22: OpKind = MCK_HPR; break;
    case ARM::S23: OpKind = MCK_HPR; break;
    case ARM::S24: OpKind = MCK_HPR; break;
    case ARM::S25: OpKind = MCK_HPR; break;
    case ARM::S26: OpKind = MCK_HPR; break;
    case ARM::S27: OpKind = MCK_HPR; break;
    case ARM::S28: OpKind = MCK_HPR; break;
    case ARM::S29: OpKind = MCK_HPR; break;
    case ARM::S30: OpKind = MCK_HPR; break;
    case ARM::S31: OpKind = MCK_HPR; break;
    case ARM::D0: OpKind = MCK_DPR_8; break;
    case ARM::D1: OpKind = MCK_DPR_8; break;
    case ARM::D2: OpKind = MCK_DPR_8; break;
    case ARM::D3: OpKind = MCK_DPR_8; break;
    case ARM::D4: OpKind = MCK_DPR_8; break;
    case ARM::D5: OpKind = MCK_DPR_8; break;
    case ARM::D6: OpKind = MCK_DPR_8; break;
    case ARM::D7: OpKind = MCK_DPR_8; break;
    case ARM::D8: OpKind = MCK_DPR_VFP2; break;
    case ARM::D9: OpKind = MCK_DPR_VFP2; break;
    case ARM::D10: OpKind = MCK_DPR_VFP2; break;
    case ARM::D11: OpKind = MCK_DPR_VFP2; break;
    case ARM::D12: OpKind = MCK_DPR_VFP2; break;
    case ARM::D13: OpKind = MCK_DPR_VFP2; break;
    case ARM::D14: OpKind = MCK_DPR_VFP2; break;
    case ARM::D15: OpKind = MCK_DPR_VFP2; break;
    case ARM::D16: OpKind = MCK_DPR; break;
    case ARM::D17: OpKind = MCK_DPR; break;
    case ARM::D18: OpKind = MCK_DPR; break;
    case ARM::D19: OpKind = MCK_DPR; break;
    case ARM::D20: OpKind = MCK_DPR; break;
    case ARM::D21: OpKind = MCK_DPR; break;
    case ARM::D22: OpKind = MCK_DPR; break;
    case ARM::D23: OpKind = MCK_DPR; break;
    case ARM::D24: OpKind = MCK_DPR; break;
    case ARM::D25: OpKind = MCK_DPR; break;
    case ARM::D26: OpKind = MCK_DPR; break;
    case ARM::D27: OpKind = MCK_DPR; break;
    case ARM::D28: OpKind = MCK_DPR; break;
    case ARM::D29: OpKind = MCK_DPR; break;
    case ARM::D30: OpKind = MCK_DPR; break;
    case ARM::D31: OpKind = MCK_DPR; break;
    case ARM::Q0: OpKind = MCK_QPR_8; break;
    case ARM::Q1: OpKind = MCK_QPR_8; break;
    case ARM::Q2: OpKind = MCK_QPR_8; break;
    case ARM::Q3: OpKind = MCK_QPR_8; break;
    case ARM::Q4: OpKind = MCK_QPR_VFP2; break;
    case ARM::Q5: OpKind = MCK_QPR_VFP2; break;
    case ARM::Q6: OpKind = MCK_QPR_VFP2; break;
    case ARM::Q7: OpKind = MCK_QPR_VFP2; break;
    case ARM::Q8: OpKind = MCK_QPR; break;
    case ARM::Q9: OpKind = MCK_QPR; break;
    case ARM::Q10: OpKind = MCK_QPR; break;
    case ARM::Q11: OpKind = MCK_QPR; break;
    case ARM::Q12: OpKind = MCK_QPR; break;
    case ARM::Q13: OpKind = MCK_QPR; break;
    case ARM::Q14: OpKind = MCK_QPR; break;
    case ARM::Q15: OpKind = MCK_QPR; break;
    case ARM::CPSR: OpKind = MCK_CCR; break;
    case ARM::APSR: OpKind = MCK_APSR; break;
    case ARM::APSR_NZCV: OpKind = MCK_APSR_NZCV; break;
    case ARM::SPSR: OpKind = MCK_SPSR; break;
    case ARM::FPSCR: OpKind = MCK_FPSCR; break;
    case ARM::FPSID: OpKind = MCK_FPSID; break;
    case ARM::MVFR2: OpKind = MCK_MVFR2; break;
    case ARM::MVFR1: OpKind = MCK_MVFR1; break;
    case ARM::MVFR0: OpKind = MCK_MVFR0; break;
    case ARM::FPEXC: OpKind = MCK_FPEXC; break;
    case ARM::FPINST: OpKind = MCK_FPINST; break;
    case ARM::FPINST2: OpKind = MCK_FPINST2; break;
    case ARM::D0_D2: OpKind = MCK_Reg40; break;
    case ARM::D1_D3: OpKind = MCK_Reg40; break;
    case ARM::D2_D4: OpKind = MCK_Reg40; break;
    case ARM::D3_D5: OpKind = MCK_Reg40; break;
    case ARM::D4_D6: OpKind = MCK_Reg40; break;
    case ARM::D5_D7: OpKind = MCK_Reg40; break;
    case ARM::D6_D8: OpKind = MCK_Reg41; break;
    case ARM::D7_D9: OpKind = MCK_Reg41; break;
    case ARM::D8_D10: OpKind = MCK_Reg42; break;
    case ARM::D9_D11: OpKind = MCK_Reg42; break;
    case ARM::D10_D12: OpKind = MCK_Reg42; break;
    case ARM::D11_D13: OpKind = MCK_Reg42; break;
    case ARM::D12_D14: OpKind = MCK_Reg42; break;
    case ARM::D13_D15: OpKind = MCK_Reg42; break;
    case ARM::D14_D16: OpKind = MCK_Reg43; break;
    case ARM::D15_D17: OpKind = MCK_Reg43; break;
    case ARM::D16_D18: OpKind = MCK_DPairSpc; break;
    case ARM::D17_D19: OpKind = MCK_DPairSpc; break;
    case ARM::D18_D20: OpKind = MCK_DPairSpc; break;
    case ARM::D19_D21: OpKind = MCK_DPairSpc; break;
    case ARM::D20_D22: OpKind = MCK_DPairSpc; break;
    case ARM::D21_D23: OpKind = MCK_DPairSpc; break;
    case ARM::D22_D24: OpKind = MCK_DPairSpc; break;
    case ARM::D23_D25: OpKind = MCK_DPairSpc; break;
    case ARM::D24_D26: OpKind = MCK_DPairSpc; break;
    case ARM::D25_D27: OpKind = MCK_DPairSpc; break;
    case ARM::D26_D28: OpKind = MCK_DPairSpc; break;
    case ARM::D27_D29: OpKind = MCK_DPairSpc; break;
    case ARM::D28_D30: OpKind = MCK_DPairSpc; break;
    case ARM::D29_D31: OpKind = MCK_DPairSpc; break;
    case ARM::Q0_Q1: OpKind = MCK_Reg45; break;
    case ARM::Q1_Q2: OpKind = MCK_Reg45; break;
    case ARM::Q2_Q3: OpKind = MCK_Reg45; break;
    case ARM::Q3_Q4: OpKind = MCK_Reg46; break;
    case ARM::Q4_Q5: OpKind = MCK_Reg47; break;
    case ARM::Q5_Q6: OpKind = MCK_Reg47; break;
    case ARM::Q6_Q7: OpKind = MCK_Reg47; break;
    case ARM::Q7_Q8: OpKind = MCK_Reg48; break;
    case ARM::Q8_Q9: OpKind = MCK_QQPR; break;
    case ARM::Q9_Q10: OpKind = MCK_QQPR; break;
    case ARM::Q10_Q11: OpKind = MCK_QQPR; break;
    case ARM::Q11_Q12: OpKind = MCK_QQPR; break;
    case ARM::Q12_Q13: OpKind = MCK_QQPR; break;
    case ARM::Q13_Q14: OpKind = MCK_QQPR; break;
    case ARM::Q14_Q15: OpKind = MCK_QQPR; break;
    case ARM::Q0_Q1_Q2_Q3: OpKind = MCK_Reg59; break;
    case ARM::Q1_Q2_Q3_Q4: OpKind = MCK_Reg60; break;
    case ARM::Q2_Q3_Q4_Q5: OpKind = MCK_Reg61; break;
    case ARM::Q3_Q4_Q5_Q6: OpKind = MCK_Reg62; break;
    case ARM::Q4_Q5_Q6_Q7: OpKind = MCK_Reg63; break;
    case ARM::Q5_Q6_Q7_Q8: OpKind = MCK_Reg64; break;
    case ARM::Q6_Q7_Q8_Q9: OpKind = MCK_Reg65; break;
    case ARM::Q7_Q8_Q9_Q10: OpKind = MCK_Reg66; break;
    case ARM::Q8_Q9_Q10_Q11: OpKind = MCK_QQQQPR; break;
    case ARM::Q9_Q10_Q11_Q12: OpKind = MCK_QQQQPR; break;
    case ARM::Q10_Q11_Q12_Q13: OpKind = MCK_QQQQPR; break;
    case ARM::Q11_Q12_Q13_Q14: OpKind = MCK_QQQQPR; break;
    case ARM::Q12_Q13_Q14_Q15: OpKind = MCK_QQQQPR; break;
    case ARM::R0_R1: OpKind = MCK_Reg68; break;
    case ARM::R2_R3: OpKind = MCK_Reg68; break;
    case ARM::R4_R5: OpKind = MCK_Reg69; break;
    case ARM::R6_R7: OpKind = MCK_Reg69; break;
    case ARM::R8_R9: OpKind = MCK_Reg73; break;
    case ARM::R10_R11: OpKind = MCK_Reg73; break;
    case ARM::R12_SP: OpKind = MCK_Reg75; break;
    case ARM::D0_D1_D2: OpKind = MCK_Reg83; break;
    case ARM::D1_D2_D3: OpKind = MCK_Reg88; break;
    case ARM::D2_D3_D4: OpKind = MCK_Reg83; break;
    case ARM::D3_D4_D5: OpKind = MCK_Reg88; break;
    case ARM::D4_D5_D6: OpKind = MCK_Reg83; break;
    case ARM::D5_D6_D7: OpKind = MCK_Reg88; break;
    case ARM::D6_D7_D8: OpKind = MCK_Reg84; break;
    case ARM::D7_D8_D9: OpKind = MCK_Reg89; break;
    case ARM::D8_D9_D10: OpKind = MCK_Reg85; break;
    case ARM::D9_D10_D11: OpKind = MCK_Reg90; break;
    case ARM::D10_D11_D12: OpKind = MCK_Reg85; break;
    case ARM::D11_D12_D13: OpKind = MCK_Reg90; break;
    case ARM::D12_D13_D14: OpKind = MCK_Reg85; break;
    case ARM::D13_D14_D15: OpKind = MCK_Reg90; break;
    case ARM::D14_D15_D16: OpKind = MCK_Reg86; break;
    case ARM::D15_D16_D17: OpKind = MCK_Reg91; break;
    case ARM::D16_D17_D18: OpKind = MCK_Reg87; break;
    case ARM::D17_D18_D19: OpKind = MCK_Reg92; break;
    case ARM::D18_D19_D20: OpKind = MCK_Reg87; break;
    case ARM::D19_D20_D21: OpKind = MCK_Reg92; break;
    case ARM::D20_D21_D22: OpKind = MCK_Reg87; break;
    case ARM::D21_D22_D23: OpKind = MCK_Reg92; break;
    case ARM::D22_D23_D24: OpKind = MCK_Reg87; break;
    case ARM::D23_D24_D25: OpKind = MCK_Reg92; break;
    case ARM::D24_D25_D26: OpKind = MCK_Reg87; break;
    case ARM::D25_D26_D27: OpKind = MCK_Reg92; break;
    case ARM::D26_D27_D28: OpKind = MCK_Reg87; break;
    case ARM::D27_D28_D29: OpKind = MCK_Reg92; break;
    case ARM::D28_D29_D30: OpKind = MCK_Reg87; break;
    case ARM::D29_D30_D31: OpKind = MCK_Reg92; break;
    case ARM::D0_D2_D4: OpKind = MCK_Reg93; break;
    case ARM::D1_D3_D5: OpKind = MCK_Reg93; break;
    case ARM::D2_D4_D6: OpKind = MCK_Reg93; break;
    case ARM::D3_D5_D7: OpKind = MCK_Reg93; break;
    case ARM::D4_D6_D8: OpKind = MCK_Reg94; break;
    case ARM::D5_D7_D9: OpKind = MCK_Reg94; break;
    case ARM::D6_D8_D10: OpKind = MCK_Reg95; break;
    case ARM::D7_D9_D11: OpKind = MCK_Reg95; break;
    case ARM::D8_D10_D12: OpKind = MCK_Reg96; break;
    case ARM::D9_D11_D13: OpKind = MCK_Reg96; break;
    case ARM::D10_D12_D14: OpKind = MCK_Reg96; break;
    case ARM::D11_D13_D15: OpKind = MCK_Reg96; break;
    case ARM::D12_D14_D16: OpKind = MCK_Reg97; break;
    case ARM::D13_D15_D17: OpKind = MCK_Reg97; break;
    case ARM::D14_D16_D18: OpKind = MCK_Reg98; break;
    case ARM::D15_D17_D19: OpKind = MCK_Reg98; break;
    case ARM::D16_D18_D20: OpKind = MCK_DTripleSpc; break;
    case ARM::D17_D19_D21: OpKind = MCK_DTripleSpc; break;
    case ARM::D18_D20_D22: OpKind = MCK_DTripleSpc; break;
    case ARM::D19_D21_D23: OpKind = MCK_DTripleSpc; break;
    case ARM::D20_D22_D24: OpKind = MCK_DTripleSpc; break;
    case ARM::D21_D23_D25: OpKind = MCK_DTripleSpc; break;
    case ARM::D22_D24_D26: OpKind = MCK_DTripleSpc; break;
    case ARM::D23_D25_D27: OpKind = MCK_DTripleSpc; break;
    case ARM::D24_D26_D28: OpKind = MCK_DTripleSpc; break;
    case ARM::D25_D27_D29: OpKind = MCK_DTripleSpc; break;
    case ARM::D26_D28_D30: OpKind = MCK_DTripleSpc; break;
    case ARM::D27_D29_D31: OpKind = MCK_DTripleSpc; break;
    case ARM::D1_D2: OpKind = MCK_Reg26; break;
    case ARM::D3_D4: OpKind = MCK_Reg26; break;
    case ARM::D5_D6: OpKind = MCK_Reg26; break;
    case ARM::D7_D8: OpKind = MCK_Reg27; break;
    case ARM::D9_D10: OpKind = MCK_Reg24; break;
    case ARM::D11_D12: OpKind = MCK_Reg24; break;
    case ARM::D13_D14: OpKind = MCK_Reg24; break;
    case ARM::D15_D16: OpKind = MCK_Reg25; break;
    case ARM::D17_D18: OpKind = MCK_DPair; break;
    case ARM::D19_D20: OpKind = MCK_DPair; break;
    case ARM::D21_D22: OpKind = MCK_DPair; break;
    case ARM::D23_D24: OpKind = MCK_DPair; break;
    case ARM::D25_D26: OpKind = MCK_DPair; break;
    case ARM::D27_D28: OpKind = MCK_DPair; break;
    case ARM::D29_D30: OpKind = MCK_DPair; break;
    case ARM::D1_D2_D3_D4: OpKind = MCK_Reg100; break;
    case ARM::D3_D4_D5_D6: OpKind = MCK_Reg100; break;
    case ARM::D5_D6_D7_D8: OpKind = MCK_Reg101; break;
    case ARM::D7_D8_D9_D10: OpKind = MCK_Reg102; break;
    case ARM::D9_D10_D11_D12: OpKind = MCK_Reg103; break;
    case ARM::D11_D12_D13_D14: OpKind = MCK_Reg103; break;
    case ARM::D13_D14_D15_D16: OpKind = MCK_Reg104; break;
    case ARM::D15_D16_D17_D18: OpKind = MCK_Reg105; break;
    case ARM::D17_D18_D19_D20: OpKind = MCK_Reg106; break;
    case ARM::D19_D20_D21_D22: OpKind = MCK_Reg106; break;
    case ARM::D21_D22_D23_D24: OpKind = MCK_Reg106; break;
    case ARM::D23_D24_D25_D26: OpKind = MCK_Reg106; break;
    case ARM::D25_D26_D27_D28: OpKind = MCK_Reg106; break;
    case ARM::D27_D28_D29_D30: OpKind = MCK_Reg106; break;
    }
    return isSubclass(OpKind, Kind) ? (unsigned)MCTargetAsmParser::Match_Success :
                                      getDiagKindFromRegisterClass(Kind);
  }

  if (Kind > MCK_LAST_TOKEN && Kind <= MCK_LAST_REGISTER)
    return getDiagKindFromRegisterClass(Kind);

  return MCTargetAsmParser::Match_InvalidOperand;
}

#ifndef NDEBUG
const char *getMatchClassName(MatchClassKind Kind) {
  switch (Kind) {
  case InvalidMatchClass: return "InvalidMatchClass";
  case OptionalMatchClass: return "OptionalMatchClass";
  case MCK__DOT_d: return "MCK__DOT_d";
  case MCK__DOT_f: return "MCK__DOT_f";
  case MCK__DOT_s16: return "MCK__DOT_s16";
  case MCK__DOT_s32: return "MCK__DOT_s32";
  case MCK__DOT_s64: return "MCK__DOT_s64";
  case MCK__DOT_s8: return "MCK__DOT_s8";
  case MCK__DOT_u16: return "MCK__DOT_u16";
  case MCK__DOT_u32: return "MCK__DOT_u32";
  case MCK__DOT_u64: return "MCK__DOT_u64";
  case MCK__DOT_u8: return "MCK__DOT_u8";
  case MCK__DOT_f32: return "MCK__DOT_f32";
  case MCK__DOT_f64: return "MCK__DOT_f64";
  case MCK__DOT_i16: return "MCK__DOT_i16";
  case MCK__DOT_i32: return "MCK__DOT_i32";
  case MCK__DOT_i64: return "MCK__DOT_i64";
  case MCK__DOT_i8: return "MCK__DOT_i8";
  case MCK__DOT_p16: return "MCK__DOT_p16";
  case MCK__DOT_p8: return "MCK__DOT_p8";
  case MCK__EXCLAIM_: return "MCK__EXCLAIM_";
  case MCK__35_0: return "MCK__35_0";
  case MCK__DOT_16: return "MCK__DOT_16";
  case MCK__DOT_32: return "MCK__DOT_32";
  case MCK__DOT_64: return "MCK__DOT_64";
  case MCK__DOT_8: return "MCK__DOT_8";
  case MCK__DOT_f16: return "MCK__DOT_f16";
  case MCK__DOT_p64: return "MCK__DOT_p64";
  case MCK__DOT_w: return "MCK__DOT_w";
  case MCK__91_: return "MCK__91_";
  case MCK__93_: return "MCK__93_";
  case MCK__94_: return "MCK__94_";
  case MCK__123_: return "MCK__123_";
  case MCK__125_: return "MCK__125_";
  case MCK_Reg75: return "MCK_Reg75";
  case MCK_Reg59: return "MCK_Reg59";
  case MCK_Reg11: return "MCK_Reg11";
  case MCK_APSR: return "MCK_APSR";
  case MCK_APSR_NZCV: return "MCK_APSR_NZCV";
  case MCK_CCR: return "MCK_CCR";
  case MCK_FPEXC: return "MCK_FPEXC";
  case MCK_FPINST: return "MCK_FPINST";
  case MCK_FPINST2: return "MCK_FPINST2";
  case MCK_FPSCR: return "MCK_FPSCR";
  case MCK_FPSID: return "MCK_FPSID";
  case MCK_GPRsp: return "MCK_GPRsp";
  case MCK_LR: return "MCK_LR";
  case MCK_MVFR0: return "MCK_MVFR0";
  case MCK_MVFR1: return "MCK_MVFR1";
  case MCK_MVFR2: return "MCK_MVFR2";
  case MCK_PC: return "MCK_PC";
  case MCK_SPSR: return "MCK_SPSR";
  case MCK_Reg100: return "MCK_Reg100";
  case MCK_Reg73: return "MCK_Reg73";
  case MCK_Reg68: return "MCK_Reg68";
  case MCK_Reg60: return "MCK_Reg60";
  case MCK_Reg101: return "MCK_Reg101";
  case MCK_Reg88: return "MCK_Reg88";
  case MCK_Reg83: return "MCK_Reg83";
  case MCK_Reg74: return "MCK_Reg74";
  case MCK_Reg72: return "MCK_Reg72";
  case MCK_Reg61: return "MCK_Reg61";
  case MCK_Reg45: return "MCK_Reg45";
  case MCK_Reg102: return "MCK_Reg102";
  case MCK_Reg93: return "MCK_Reg93";
  case MCK_Reg89: return "MCK_Reg89";
  case MCK_Reg84: return "MCK_Reg84";
  case MCK_Reg69: return "MCK_Reg69";
  case MCK_Reg62: return "MCK_Reg62";
  case MCK_Reg46: return "MCK_Reg46";
  case MCK_Reg0: return "MCK_Reg0";
  case MCK_QPR_8: return "MCK_QPR_8";
  case MCK_Reg63: return "MCK_Reg63";
  case MCK_Reg57: return "MCK_Reg57";
  case MCK_tcGPR: return "MCK_tcGPR";
  case MCK_Reg103: return "MCK_Reg103";
  case MCK_Reg94: return "MCK_Reg94";
  case MCK_Reg76: return "MCK_Reg76";
  case MCK_Reg70: return "MCK_Reg70";
  case MCK_Reg64: return "MCK_Reg64";
  case MCK_Reg58: return "MCK_Reg58";
  case MCK_Reg40: return "MCK_Reg40";
  case MCK_Reg10: return "MCK_Reg10";
  case MCK_Reg104: return "MCK_Reg104";
  case MCK_Reg90: return "MCK_Reg90";
  case MCK_Reg85: return "MCK_Reg85";
  case MCK_Reg77: return "MCK_Reg77";
  case MCK_Reg65: return "MCK_Reg65";
  case MCK_Reg55: return "MCK_Reg55";
  case MCK_Reg47: return "MCK_Reg47";
  case MCK_Reg26: return "MCK_Reg26";
  case MCK_Reg8: return "MCK_Reg8";
  case MCK_GPRPair: return "MCK_GPRPair";
  case MCK_Reg105: return "MCK_Reg105";
  case MCK_Reg95: return "MCK_Reg95";
  case MCK_Reg91: return "MCK_Reg91";
  case MCK_Reg86: return "MCK_Reg86";
  case MCK_Reg78: return "MCK_Reg78";
  case MCK_Reg66: return "MCK_Reg66";
  case MCK_Reg56: return "MCK_Reg56";
  case MCK_Reg48: return "MCK_Reg48";
  case MCK_Reg41: return "MCK_Reg41";
  case MCK_Reg27: return "MCK_Reg27";
  case MCK_DPR_8: return "MCK_DPR_8";
  case MCK_QPR_VFP2: return "MCK_QPR_VFP2";
  case MCK_hGPR: return "MCK_hGPR";
  case MCK_tGPR: return "MCK_tGPR";
  case MCK_tGPRwithpc: return "MCK_tGPRwithpc";
  case MCK_Reg96: return "MCK_Reg96";
  case MCK_Reg53: return "MCK_Reg53";
  case MCK_QQQQPR: return "MCK_QQQQPR";
  case MCK_Reg106: return "MCK_Reg106";
  case MCK_Reg97: return "MCK_Reg97";
  case MCK_Reg79: return "MCK_Reg79";
  case MCK_Reg54: return "MCK_Reg54";
  case MCK_Reg42: return "MCK_Reg42";
  case MCK_rGPR: return "MCK_rGPR";
  case MCK_Reg92: return "MCK_Reg92";
  case MCK_Reg87: return "MCK_Reg87";
  case MCK_Reg80: return "MCK_Reg80";
  case MCK_Reg51: return "MCK_Reg51";
  case MCK_Reg24: return "MCK_Reg24";
  case MCK_GPRnopc: return "MCK_GPRnopc";
  case MCK_QQPR: return "MCK_QQPR";
  case MCK_Reg98: return "MCK_Reg98";
  case MCK_Reg81: return "MCK_Reg81";
  case MCK_Reg52: return "MCK_Reg52";
  case MCK_Reg43: return "MCK_Reg43";
  case MCK_Reg25: return "MCK_Reg25";
  case MCK_DPR_VFP2: return "MCK_DPR_VFP2";
  case MCK_GPR: return "MCK_GPR";
  case MCK_GPRwithAPSR: return "MCK_GPRwithAPSR";
  case MCK_QPR: return "MCK_QPR";
  case MCK_SPR_8: return "MCK_SPR_8";
  case MCK_DTripleSpc: return "MCK_DTripleSpc";
  case MCK_DQuad: return "MCK_DQuad";
  case MCK_DPairSpc: return "MCK_DPairSpc";
  case MCK_DTriple: return "MCK_DTriple";
  case MCK_DPair: return "MCK_DPair";
  case MCK_DPR: return "MCK_DPR";
  case MCK_HPR: return "MCK_HPR";
  case MCK_AM2OffsetImm: return "MCK_AM2OffsetImm";
  case MCK_AM3Offset: return "MCK_AM3Offset";
  case MCK_ARMBranchTarget: return "MCK_ARMBranchTarget";
  case MCK_AddrMode3: return "MCK_AddrMode3";
  case MCK_AddrMode5: return "MCK_AddrMode5";
  case MCK_AddrMode5FP16: return "MCK_AddrMode5FP16";
  case MCK_AlignedMemory16: return "MCK_AlignedMemory16";
  case MCK_AlignedMemory32: return "MCK_AlignedMemory32";
  case MCK_AlignedMemory64: return "MCK_AlignedMemory64";
  case MCK_AlignedMemory64or128: return "MCK_AlignedMemory64or128";
  case MCK_AlignedMemory64or128or256: return "MCK_AlignedMemory64or128or256";
  case MCK_AlignedMemoryNone: return "MCK_AlignedMemoryNone";
  case MCK_AlignedMemory: return "MCK_AlignedMemory";
  case MCK_DupAlignedMemory16: return "MCK_DupAlignedMemory16";
  case MCK_DupAlignedMemory32: return "MCK_DupAlignedMemory32";
  case MCK_DupAlignedMemory64: return "MCK_DupAlignedMemory64";
  case MCK_DupAlignedMemory64or128: return "MCK_DupAlignedMemory64or128";
  case MCK_DupAlignedMemoryNone: return "MCK_DupAlignedMemoryNone";
  case MCK_AdrLabel: return "MCK_AdrLabel";
  case MCK_BankedReg: return "MCK_BankedReg";
  case MCK_Bitfield: return "MCK_Bitfield";
  case MCK_CCOut: return "MCK_CCOut";
  case MCK_CondCode: return "MCK_CondCode";
  case MCK_CoprocNum: return "MCK_CoprocNum";
  case MCK_CoprocOption: return "MCK_CoprocOption";
  case MCK_CoprocReg: return "MCK_CoprocReg";
  case MCK_DPRRegList: return "MCK_DPRRegList";
  case MCK_FPImm: return "MCK_FPImm";
  case MCK_Imm0_15: return "MCK_Imm0_15";
  case MCK_Imm0_1: return "MCK_Imm0_1";
  case MCK_Imm0_239: return "MCK_Imm0_239";
  case MCK_Imm0_255: return "MCK_Imm0_255";
  case MCK_Imm0_31: return "MCK_Imm0_31";
  case MCK_Imm0_32: return "MCK_Imm0_32";
  case MCK_Imm0_3: return "MCK_Imm0_3";
  case MCK_Imm0_63: return "MCK_Imm0_63";
  case MCK_Imm0_65535: return "MCK_Imm0_65535";
  case MCK_Imm0_65535Expr: return "MCK_Imm0_65535Expr";
  case MCK_Imm0_7: return "MCK_Imm0_7";
  case MCK_Imm16: return "MCK_Imm16";
  case MCK_Imm1_15: return "MCK_Imm1_15";
  case MCK_Imm1_16: return "MCK_Imm1_16";
  case MCK_Imm1_31: return "MCK_Imm1_31";
  case MCK_Imm1_32: return "MCK_Imm1_32";
  case MCK_Imm1_7: return "MCK_Imm1_7";
  case MCK_Imm24bit: return "MCK_Imm24bit";
  case MCK_Imm256_65535Expr: return "MCK_Imm256_65535Expr";
  case MCK_Imm32: return "MCK_Imm32";
  case MCK_Imm8: return "MCK_Imm8";
  case MCK_Imm8_255: return "MCK_Imm8_255";
  case MCK_Imm: return "MCK_Imm";
  case MCK_InstSyncBarrierOpt: return "MCK_InstSyncBarrierOpt";
  case MCK_MSRMask: return "MCK_MSRMask";
  case MCK_MemBarrierOpt: return "MCK_MemBarrierOpt";
  case MCK_MemImm0_1020s4Offset: return "MCK_MemImm0_1020s4Offset";
  case MCK_MemImm12Offset: return "MCK_MemImm12Offset";
  case MCK_MemImm8Offset: return "MCK_MemImm8Offset";
  case MCK_MemImm8s4Offset: return "MCK_MemImm8s4Offset";
  case MCK_MemNegImm8Offset: return "MCK_MemNegImm8Offset";
  case MCK_MemNoOffset: return "MCK_MemNoOffset";
  case MCK_MemPosImm8Offset: return "MCK_MemPosImm8Offset";
  case MCK_MemRegOffset: return "MCK_MemRegOffset";
  case MCK_ModImm: return "MCK_ModImm";
  case MCK_ModImmNeg: return "MCK_ModImmNeg";
  case MCK_ModImmNot: return "MCK_ModImmNot";
  case MCK_PKHASRImm: return "MCK_PKHASRImm";
  case MCK_PKHLSLImm: return "MCK_PKHLSLImm";
  case MCK_PostIdxImm8: return "MCK_PostIdxImm8";
  case MCK_PostIdxImm8s4: return "MCK_PostIdxImm8s4";
  case MCK_PostIdxReg: return "MCK_PostIdxReg";
  case MCK_PostIdxRegShifted: return "MCK_PostIdxRegShifted";
  case MCK_ProcIFlags: return "MCK_ProcIFlags";
  case MCK_RegList: return "MCK_RegList";
  case MCK_RotImm: return "MCK_RotImm";
  case MCK_SPRRegList: return "MCK_SPRRegList";
  case MCK_SetEndImm: return "MCK_SetEndImm";
  case MCK_RegShiftedImm: return "MCK_RegShiftedImm";
  case MCK_RegShiftedReg: return "MCK_RegShiftedReg";
  case MCK_ShifterImm: return "MCK_ShifterImm";
  case MCK_ThumbBranchTarget: return "MCK_ThumbBranchTarget";
  case MCK_ThumbMemPC: return "MCK_ThumbMemPC";
  case MCK_ThumbModImmNeg1_7: return "MCK_ThumbModImmNeg1_7";
  case MCK_ThumbModImmNeg8_255: return "MCK_ThumbModImmNeg8_255";
  case MCK_ImmThumbSR: return "MCK_ImmThumbSR";
  case MCK_TraceSyncBarrierOpt: return "MCK_TraceSyncBarrierOpt";
  case MCK_UnsignedOffset_b8s2: return "MCK_UnsignedOffset_b8s2";
  case MCK_VecListDPairAllLanes: return "MCK_VecListDPairAllLanes";
  case MCK_VecListDPair: return "MCK_VecListDPair";
  case MCK_VecListDPairSpacedAllLanes: return "MCK_VecListDPairSpacedAllLanes";
  case MCK_VecListDPairSpaced: return "MCK_VecListDPairSpaced";
  case MCK_VecListFourDAllLanes: return "MCK_VecListFourDAllLanes";
  case MCK_VecListFourD: return "MCK_VecListFourD";
  case MCK_VecListFourDByteIndexed: return "MCK_VecListFourDByteIndexed";
  case MCK_VecListFourDHWordIndexed: return "MCK_VecListFourDHWordIndexed";
  case MCK_VecListFourDWordIndexed: return "MCK_VecListFourDWordIndexed";
  case MCK_VecListFourQAllLanes: return "MCK_VecListFourQAllLanes";
  case MCK_VecListFourQ: return "MCK_VecListFourQ";
  case MCK_VecListFourQHWordIndexed: return "MCK_VecListFourQHWordIndexed";
  case MCK_VecListFourQWordIndexed: return "MCK_VecListFourQWordIndexed";
  case MCK_VecListOneDAllLanes: return "MCK_VecListOneDAllLanes";
  case MCK_VecListOneD: return "MCK_VecListOneD";
  case MCK_VecListOneDByteIndexed: return "MCK_VecListOneDByteIndexed";
  case MCK_VecListOneDHWordIndexed: return "MCK_VecListOneDHWordIndexed";
  case MCK_VecListOneDWordIndexed: return "MCK_VecListOneDWordIndexed";
  case MCK_VecListThreeDAllLanes: return "MCK_VecListThreeDAllLanes";
  case MCK_VecListThreeD: return "MCK_VecListThreeD";
  case MCK_VecListThreeDByteIndexed: return "MCK_VecListThreeDByteIndexed";
  case MCK_VecListThreeDHWordIndexed: return "MCK_VecListThreeDHWordIndexed";
  case MCK_VecListThreeDWordIndexed: return "MCK_VecListThreeDWordIndexed";
  case MCK_VecListThreeQAllLanes: return "MCK_VecListThreeQAllLanes";
  case MCK_VecListThreeQ: return "MCK_VecListThreeQ";
  case MCK_VecListThreeQHWordIndexed: return "MCK_VecListThreeQHWordIndexed";
  case MCK_VecListThreeQWordIndexed: return "MCK_VecListThreeQWordIndexed";
  case MCK_VecListTwoDByteIndexed: return "MCK_VecListTwoDByteIndexed";
  case MCK_VecListTwoDHWordIndexed: return "MCK_VecListTwoDHWordIndexed";
  case MCK_VecListTwoDWordIndexed: return "MCK_VecListTwoDWordIndexed";
  case MCK_VecListTwoQHWordIndexed: return "MCK_VecListTwoQHWordIndexed";
  case MCK_VecListTwoQWordIndexed: return "MCK_VecListTwoQWordIndexed";
  case MCK_VectorIndex16: return "MCK_VectorIndex16";
  case MCK_VectorIndex32: return "MCK_VectorIndex32";
  case MCK_VectorIndex64: return "MCK_VectorIndex64";
  case MCK_VectorIndex8: return "MCK_VectorIndex8";
  case MCK_MemTBB: return "MCK_MemTBB";
  case MCK_MemTBH: return "MCK_MemTBH";
  case MCK_ComplexRotationEven: return "MCK_ComplexRotationEven";
  case MCK_ComplexRotationOdd: return "MCK_ComplexRotationOdd";
  case MCK_NEONi16vmovi8Replicate: return "MCK_NEONi16vmovi8Replicate";
  case MCK_NEONi16invi8Replicate: return "MCK_NEONi16invi8Replicate";
  case MCK_NEONi32vmovi8Replicate: return "MCK_NEONi32vmovi8Replicate";
  case MCK_NEONi32invi8Replicate: return "MCK_NEONi32invi8Replicate";
  case MCK_NEONi64vmovi8Replicate: return "MCK_NEONi64vmovi8Replicate";
  case MCK_NEONi64invi8Replicate: return "MCK_NEONi64invi8Replicate";
  case MCK_NEONi32vmovi16Replicate: return "MCK_NEONi32vmovi16Replicate";
  case MCK_NEONi64vmovi16Replicate: return "MCK_NEONi64vmovi16Replicate";
  case MCK_NEONi64vmovi32Replicate: return "MCK_NEONi64vmovi32Replicate";
  case MCK_ConstPoolAsmImm: return "MCK_ConstPoolAsmImm";
  case MCK_FBits16: return "MCK_FBits16";
  case MCK_FBits32: return "MCK_FBits32";
  case MCK_Imm0_4095: return "MCK_Imm0_4095";
  case MCK_Imm0_4095Neg: return "MCK_Imm0_4095Neg";
  case MCK_ITMask: return "MCK_ITMask";
  case MCK_ITCondCode: return "MCK_ITCondCode";
  case MCK_NEONi16splat: return "MCK_NEONi16splat";
  case MCK_NEONi32splat: return "MCK_NEONi32splat";
  case MCK_NEONi64splat: return "MCK_NEONi64splat";
  case MCK_NEONi8splat: return "MCK_NEONi8splat";
  case MCK_NEONi16splatNot: return "MCK_NEONi16splatNot";
  case MCK_NEONi32splatNot: return "MCK_NEONi32splatNot";
  case MCK_NEONi32vmov: return "MCK_NEONi32vmov";
  case MCK_NEONi32vmovNeg: return "MCK_NEONi32vmovNeg";
  case MCK_ShrImm16: return "MCK_ShrImm16";
  case MCK_ShrImm32: return "MCK_ShrImm32";
  case MCK_ShrImm64: return "MCK_ShrImm64";
  case MCK_ShrImm8: return "MCK_ShrImm8";
  case MCK_T2SOImm: return "MCK_T2SOImm";
  case MCK_T2SOImmNeg: return "MCK_T2SOImmNeg";
  case MCK_T2SOImmNot: return "MCK_T2SOImmNot";
  case MCK_MemUImm12Offset: return "MCK_MemUImm12Offset";
  case MCK_T2MemRegOffset: return "MCK_T2MemRegOffset";
  case MCK_Imm8s4: return "MCK_Imm8s4";
  case MCK_MemPCRelImm12: return "MCK_MemPCRelImm12";
  case MCK_MemThumbRIs1: return "MCK_MemThumbRIs1";
  case MCK_MemThumbRIs2: return "MCK_MemThumbRIs2";
  case MCK_MemThumbRIs4: return "MCK_MemThumbRIs4";
  case MCK_MemThumbRR: return "MCK_MemThumbRR";
  case MCK_MemThumbSPI: return "MCK_MemThumbSPI";
  case MCK_Imm0_1020s4: return "MCK_Imm0_1020s4";
  case MCK_Imm0_508s4: return "MCK_Imm0_508s4";
  case MCK_Imm0_508s4Neg: return "MCK_Imm0_508s4Neg";
  case NumMatchClassKinds: return "NumMatchClassKinds";
  }
  llvm_unreachable("unhandled MatchClassKind!");
}

#endif // NDEBUG
uint64_t ARMAsmParser::
ComputeAvailableFeatures(const FeatureBitset& FB) const {
  uint64_t Features = 0;
  if ((FB[ARM::HasV4TOps]))
    Features |= Feature_HasV4T;
  if ((FB[ARM::HasV5TOps]))
    Features |= Feature_HasV5T;
  if ((FB[ARM::HasV5TEOps]))
    Features |= Feature_HasV5TE;
  if ((FB[ARM::HasV6Ops]))
    Features |= Feature_HasV6;
  if ((FB[ARM::HasV6MOps]))
    Features |= Feature_HasV6M;
  if ((FB[ARM::HasV8MBaselineOps]))
    Features |= Feature_HasV8MBaseline;
  if ((FB[ARM::HasV8MMainlineOps]))
    Features |= Feature_HasV8MMainline;
  if ((FB[ARM::HasV6T2Ops]))
    Features |= Feature_HasV6T2;
  if ((FB[ARM::HasV6KOps]))
    Features |= Feature_HasV6K;
  if ((FB[ARM::HasV7Ops]))
    Features |= Feature_HasV7;
  if ((FB[ARM::HasV8Ops]))
    Features |= Feature_HasV8;
  if ((!FB[ARM::HasV8Ops]))
    Features |= Feature_PreV8;
  if ((FB[ARM::HasV8_1aOps]))
    Features |= Feature_HasV8_1a;
  if ((FB[ARM::HasV8_2aOps]))
    Features |= Feature_HasV8_2a;
  if ((FB[ARM::HasV8_3aOps]))
    Features |= Feature_HasV8_3a;
  if ((FB[ARM::HasV8_4aOps]))
    Features |= Feature_HasV8_4a;
  if ((FB[ARM::FeatureVFP2]))
    Features |= Feature_HasVFP2;
  if ((FB[ARM::FeatureVFP3]))
    Features |= Feature_HasVFP3;
  if ((FB[ARM::FeatureVFP4]))
    Features |= Feature_HasVFP4;
  if ((!FB[ARM::FeatureVFPOnlySP]))
    Features |= Feature_HasDPVFP;
  if ((FB[ARM::FeatureFPARMv8]))
    Features |= Feature_HasFPARMv8;
  if ((FB[ARM::FeatureNEON]))
    Features |= Feature_HasNEON;
  if ((FB[ARM::FeatureSHA2]))
    Features |= Feature_HasSHA2;
  if ((FB[ARM::FeatureAES]))
    Features |= Feature_HasAES;
  if ((FB[ARM::FeatureCrypto]))
    Features |= Feature_HasCrypto;
  if ((FB[ARM::FeatureDotProd]))
    Features |= Feature_HasDotProd;
  if ((FB[ARM::FeatureCRC]))
    Features |= Feature_HasCRC;
  if ((FB[ARM::FeatureRAS]))
    Features |= Feature_HasRAS;
  if ((FB[ARM::FeatureFP16]))
    Features |= Feature_HasFP16;
  if ((FB[ARM::FeatureFullFP16]))
    Features |= Feature_HasFullFP16;
  if ((FB[ARM::FeatureHWDivThumb]))
    Features |= Feature_HasDivideInThumb;
  if ((FB[ARM::FeatureHWDivARM]))
    Features |= Feature_HasDivideInARM;
  if ((FB[ARM::FeatureDSP]))
    Features |= Feature_HasDSP;
  if ((FB[ARM::FeatureDB]))
    Features |= Feature_HasDB;
  if ((FB[ARM::FeatureDFB]))
    Features |= Feature_HasDFB;
  if ((FB[ARM::FeatureV7Clrex]))
    Features |= Feature_HasV7Clrex;
  if ((FB[ARM::FeatureAcquireRelease]))
    Features |= Feature_HasAcquireRelease;
  if ((FB[ARM::FeatureMP]))
    Features |= Feature_HasMP;
  if ((FB[ARM::FeatureVirtualization]))
    Features |= Feature_HasVirtualization;
  if ((FB[ARM::FeatureTrustZone]))
    Features |= Feature_HasTrustZone;
  if ((FB[ARM::Feature8MSecExt]))
    Features |= Feature_Has8MSecExt;
  if ((FB[ARM::ModeThumb]))
    Features |= Feature_IsThumb;
  if ((FB[ARM::ModeThumb]) && (FB[ARM::FeatureThumb2]))
    Features |= Feature_IsThumb2;
  if ((FB[ARM::FeatureMClass]))
    Features |= Feature_IsMClass;
  if ((!FB[ARM::FeatureMClass]))
    Features |= Feature_IsNotMClass;
  if ((!FB[ARM::ModeThumb]))
    Features |= Feature_IsARM;
  if ((FB[ARM::FeatureNaClTrap]))
    Features |= Feature_UseNaClTrap;
  if ((!FB[ARM::FeatureNoNegativeImmediates]))
    Features |= Feature_UseNegativeImmediates;
  return Features;
}

static const char *const MnemonicTable =
    "\t__brkdiv0\003adc\003add\004addw\003adr\004aesd\004aese\006aesimc\005a"
    "esmc\003and\003asr\001b\003bfc\003bfi\003bic\004bkpt\002bl\003blx\005bl"
    "xns\002bx\003bxj\004bxns\004cbnz\003cbz\003cdp\004cdp2\005clrex\003clz\003"
    "cmn\003cmp\003cps\006crc32b\007crc32cb\007crc32ch\007crc32cw\006crc32h\006"
    "crc32w\004csdb\003dbg\005dcps1\005dcps2\005dcps3\003dfb\003dmb\003dsb\003"
    "eor\004eret\003esb\005faddd\005fadds\006fcmpzd\006fcmpzs\007fconstd\007"
    "fconsts\007fldmdbx\007fldmiax\005fmdhr\005fmdlr\006fmstat\007fstmdbx\007"
    "fstmiax\005fsubd\005fsubs\004hint\003hlt\003hvc\003isb\002it\003lda\004"
    "ldab\005ldaex\006ldaexb\006ldaexd\006ldaexh\004ldah\003ldc\004ldc2\005l"
    "dc2l\004ldcl\003ldm\005ldmda\005ldmdb\005ldmib\003ldr\004ldrb\005ldrbt\004"
    "ldrd\005ldrex\006ldrexb\006ldrexd\006ldrexh\004ldrh\005ldrht\005ldrsb\006"
    "ldrsbt\005ldrsh\006ldrsht\004ldrt\003lsl\003lsr\003mcr\004mcr2\004mcrr\005"
    "mcrr2\003mla\003mls\003mov\004movs\004movt\004movw\003mrc\004mrc2\004mr"
    "rc\005mrrc2\003mrs\003msr\003mul\003mvn\003neg\003nop\003orn\003orr\005"
    "pkhbt\005pkhtb\003pld\004pldw\003pli\003pop\004push\004qadd\006qadd16\005"
    "qadd8\004qasx\005qdadd\005qdsub\004qsax\004qsub\006qsub16\005qsub8\004r"
    "bit\003rev\005rev16\005revsh\005rfeda\005rfedb\005rfeia\005rfeib\003ror"
    "\003rrx\003rsb\003rsc\006sadd16\005sadd8\004sasx\003sbc\004sbfx\004sdiv"
    "\003sel\006setend\006setpan\003sev\004sevl\002sg\005sha1c\005sha1h\005s"
    "ha1m\005sha1p\007sha1su0\007sha1su1\007sha256h\010sha256h2\tsha256su0\t"
    "sha256su1\007shadd16\006shadd8\005shasx\005shsax\007shsub16\006shsub8\003"
    "smc\006smlabb\006smlabt\005smlad\006smladx\005smlal\007smlalbb\007smlal"
    "bt\006smlald\007smlaldx\007smlaltb\007smlaltt\006smlatb\006smlatt\006sm"
    "lawb\006smlawt\005smlsd\006smlsdx\006smlsld\007smlsldx\005smmla\006smml"
    "ar\005smmls\006smmlsr\005smmul\006smmulr\005smuad\006smuadx\006smulbb\006"
    "smulbt\005smull\006smultb\006smultt\006smulwb\006smulwt\005smusd\006smu"
    "sdx\005srsda\005srsdb\005srsia\005srsib\004ssat\006ssat16\004ssax\006ss"
    "ub16\005ssub8\003stc\004stc2\005stc2l\004stcl\003stl\004stlb\005stlex\006"
    "stlexb\006stlexd\006stlexh\004stlh\003stm\005stmda\005stmdb\005stmib\003"
    "str\004strb\005strbt\004strd\005strex\006strexb\006strexd\006strexh\004"
    "strh\005strht\004strt\003sub\004subs\004subw\003svc\003swp\004swpb\005s"
    "xtab\007sxtab16\005sxtah\004sxtb\006sxtb16\004sxth\003tbb\003tbh\003teq"
    "\004trap\003tsb\003tst\002tt\003tta\004ttat\003ttt\006uadd16\005uadd8\004"
    "uasx\004ubfx\003udf\004udiv\007uhadd16\006uhadd8\005uhasx\005uhsax\007u"
    "hsub16\006uhsub8\005umaal\005umlal\005umull\007uqadd16\006uqadd8\005uqa"
    "sx\005uqsax\007uqsub16\006uqsub8\005usad8\006usada8\004usat\006usat16\004"
    "usax\006usub16\005usub8\005uxtab\007uxtab16\005uxtah\004uxtb\006uxtb16\004"
    "uxth\004vaba\005vabal\004vabd\005vabdl\004vabs\005vacge\005vacgt\005vac"
    "le\005vaclt\004vadd\006vaddhn\005vaddl\005vaddw\004vand\004vbic\004vbif"
    "\004vbit\004vbsl\005vcadd\004vceq\004vcge\004vcgt\004vcle\004vcls\004vc"
    "lt\004vclz\005vcmla\004vcmp\005vcmpe\004vcnt\004vcvt\005vcvta\005vcvtb\005"
    "vcvtm\005vcvtn\005vcvtp\005vcvtr\005vcvtt\004vdiv\004vdup\004veor\004ve"
    "xt\004vfma\004vfms\005vfnma\005vfnms\005vhadd\005vhsub\004vins\005vjcvt"
    "\004vld1\004vld2\004vld3\004vld4\006vldmdb\006vldmia\004vldr\005vlldm\005"
    "vlstm\004vmax\006vmaxnm\004vmin\006vminnm\004vmla\005vmlal\004vmls\005v"
    "mlsl\004vmov\005vmovl\005vmovn\005vmovx\004vmrs\004vmsr\004vmul\005vmul"
    "l\004vmvn\004vneg\005vnmla\005vnmls\005vnmul\004vorn\004vorr\006vpadal\005"
    "vpadd\006vpaddl\005vpmax\005vpmin\004vpop\005vpush\005vqabs\005vqadd\007"
    "vqdmlal\007vqdmlsl\007vqdmulh\007vqdmull\006vqmovn\007vqmovun\005vqneg\010"
    "vqrdmlah\010vqrdmlsh\010vqrdmulh\006vqrshl\007vqrshrn\010vqrshrun\005vq"
    "shl\006vqshlu\006vqshrn\007vqshrun\005vqsub\007vraddhn\006vrecpe\006vre"
    "cps\006vrev16\006vrev32\006vrev64\006vrhadd\006vrinta\006vrintm\006vrin"
    "tn\006vrintp\006vrintr\006vrintx\006vrintz\005vrshl\005vrshr\006vrshrn\007"
    "vrsqrte\007vrsqrts\005vrsra\007vrsubhn\005vsdot\006vseleq\006vselge\006"
    "vselgt\006vselvs\004vshl\005vshll\004vshr\005vshrn\004vsli\005vsqrt\004"
    "vsra\004vsri\004vst1\004vst2\004vst3\004vst4\006vstmdb\006vstmia\004vst"
    "r\004vsub\006vsubhn\005vsubl\005vsubw\004vswp\004vtbl\004vtbx\004vtrn\004"
    "vtst\005vudot\004vuzp\004vzip\003wfe\003wfi\005yield";

namespace {
  struct MatchEntry {
    uint16_t Mnemonic;
    uint16_t Opcode;
    uint16_t ConvertFn;
    uint64_t RequiredFeatures;
    uint16_t Classes[18];
    StringRef getMnemonic() const {
      return StringRef(MnemonicTable + Mnemonic + 1,
                       MnemonicTable[Mnemonic]);
    }
  };

  // Predicate for searching for an opcode.
  struct LessOpcode {
    bool operator()(const MatchEntry &LHS, StringRef RHS) {
      return LHS.getMnemonic() < RHS;
    }
    bool operator()(StringRef LHS, const MatchEntry &RHS) {
      return LHS < RHS.getMnemonic();
    }
    bool operator()(const MatchEntry &LHS, const MatchEntry &RHS) {
      return LHS.getMnemonic() < RHS.getMnemonic();
    }
  };
} // end anonymous namespace.

static const MatchEntry MatchTable0[] = {
  { 0 /* __brkdiv0 */, ARM::t__brkdiv0, Convert_NoOperands, Feature_IsThumb, {  }, },
  { 10 /* adc */, ARM::tADC, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 10 /* adc */, ARM::ADCrsr, Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedReg }, },
  { 10 /* adc */, ARM::ADCrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 10 /* adc */, ARM::ADCri, Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 10 /* adc */, ARM::SBCri, Convert__Reg1_2__Reg1_2__ModImmNot1_3__CondCode2_1__CCOut1_0, Feature_IsARM|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImmNot }, },
  { 10 /* adc */, ARM::ADCrsi, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 10 /* adc */, ARM::t2ADCrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 10 /* adc */, ARM::t2ADCrs, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 10 /* adc */, ARM::t2ADCri, Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 10 /* adc */, ARM::t2SBCri, Convert__Reg1_2__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImmNot }, },
  { 10 /* adc */, ARM::ADCrsr, Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_RegShiftedReg }, },
  { 10 /* adc */, ARM::ADCrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10 /* adc */, ARM::ADCri, Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImm }, },
  { 10 /* adc */, ARM::SBCri, Convert__Reg1_2__Reg1_3__ModImmNot1_4__CondCode2_1__CCOut1_0, Feature_IsARM|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImmNot }, },
  { 10 /* adc */, ARM::ADCrsi, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedImm }, },
  { 10 /* adc */, ARM::t2ADCrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 10 /* adc */, ARM::t2ADCrs, Convert__Reg1_3__Reg1_4__RegShiftedImm2_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 14 /* add */, ARM::tADDspr, Convert__Reg1_1__Tie0_1_1__Reg1_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_GPRsp, MCK_GPR }, },
  { 14 /* add */, ARM::tADDspi, Convert__Reg1_1__Tie0_1_1__Imm0_508s41_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_GPRsp, MCK_Imm0_508s4 }, },
  { 14 /* add */, ARM::tSUBspi, Convert__regSP__Tie0_1_1__Imm0_508s4Neg1_2__CondCode2_0, Feature_IsThumb|Feature_UseNegativeImmediates, { MCK_CondCode, MCK_GPRsp, MCK_Imm0_508s4Neg }, },
  { 14 /* add */, ARM::t2ADDri12, Convert__Reg1_1__Reg1_1__Imm0_40951_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_Imm0_4095 }, },
  { 14 /* add */, ARM::t2SUBri12, Convert__Reg1_1__Reg1_1__Imm0_4095Neg1_2__CondCode2_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CondCode, MCK_GPRnopc, MCK_Imm0_4095Neg }, },
  { 14 /* add */, ARM::tADDhirr, Convert__Reg1_1__Tie0_1_1__Reg1_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 14 /* add */, ARM::tADDrr, Convert__Reg1_2__CCOut1_0__Reg1_2__Reg1_3__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 14 /* add */, ARM::tADDi8, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Imm0_2551_3__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_Imm0_255 }, },
  { 14 /* add */, ARM::tSUBi8, Convert__Reg1_2__CCOut1_0__Tie0_3_3__ThumbModImmNeg8_2551_3__CondCode2_1, Feature_IsThumb|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_ThumbModImmNeg8_255 }, },
  { 14 /* add */, ARM::t2ADDrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_rGPR }, },
  { 14 /* add */, ARM::t2ADDrs, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 14 /* add */, ARM::t2ADDri, Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_T2SOImm }, },
  { 14 /* add */, ARM::t2SUBri, Convert__Reg1_2__Reg1_2__T2SOImmNeg1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_T2SOImmNeg }, },
  { 14 /* add */, ARM::t2SUBri, Convert__Reg1_2__Reg1_2__T2SOImmNeg1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_T2SOImmNeg }, },
  { 14 /* add */, ARM::ADDrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 14 /* add */, ARM::ADDri, Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 14 /* add */, ARM::SUBri, Convert__Reg1_2__Reg1_2__ModImmNeg1_3__CondCode2_1__CCOut1_0, Feature_IsARM|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImmNeg }, },
  { 14 /* add */, ARM::ADDrsi, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 14 /* add */, ARM::ADDrsr, Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedReg }, },
  { 14 /* add */, ARM::tADDspi, Convert__regSP__Tie0_1_1__Imm0_508s41_3__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_GPRsp, MCK_GPRsp, MCK_Imm0_508s4 }, },
  { 14 /* add */, ARM::tSUBspi, Convert__regSP__Tie0_1_1__Imm0_508s4Neg1_3__CondCode2_0, Feature_IsThumb|Feature_UseNegativeImmediates, { MCK_CondCode, MCK_GPRsp, MCK_GPRsp, MCK_Imm0_508s4Neg }, },
  { 14 /* add */, ARM::tADDrSPi, Convert__Reg1_1__Reg1_2__Imm0_1020s41_3__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_GPRsp, MCK_Imm0_1020s4 }, },
  { 14 /* add */, ARM::t2ADR, Convert__Reg1_1__Imm0_40951_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_PC, MCK_Imm0_4095 }, },
  { 14 /* add */, ARM::t2ADDri12, Convert__Reg1_1__Reg1_2__Imm0_40951_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_Imm0_4095 }, },
  { 14 /* add */, ARM::t2SUBri12, Convert__Reg1_1__Reg1_2__Imm0_4095Neg1_3__CondCode2_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_Imm0_4095Neg }, },
  { 14 /* add */, ARM::tADDrSP, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_GPR, MCK_GPRsp, MCK_GPR }, },
  { 14 /* add */, ARM::t2SUBri, Convert__Reg1_3__Reg1_3__T2SOImmNeg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_T2SOImmNeg }, },
  { 14 /* add */, ARM::tADDrr, Convert__Reg1_2__CCOut1_0__Reg1_3__Reg1_4__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR, MCK_tGPR }, },
  { 14 /* add */, ARM::tADDi3, Convert__Reg1_2__CCOut1_0__Reg1_3__Imm0_71_4__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR, MCK_Imm0_7 }, },
  { 14 /* add */, ARM::tSUBi3, Convert__Reg1_2__CCOut1_0__Reg1_3__ThumbModImmNeg1_71_4__CondCode2_1, Feature_IsThumb|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR, MCK_ThumbModImmNeg1_7 }, },
  { 14 /* add */, ARM::t2ADDrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_rGPR }, },
  { 14 /* add */, ARM::t2ADDrs, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 14 /* add */, ARM::t2ADDri, Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_T2SOImm }, },
  { 14 /* add */, ARM::t2SUBri, Convert__Reg1_2__Reg1_3__T2SOImmNeg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_T2SOImmNeg }, },
  { 14 /* add */, ARM::t2SUBri, Convert__Reg1_2__Reg1_3__T2SOImmNeg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_T2SOImmNeg }, },
  { 14 /* add */, ARM::ADDrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 14 /* add */, ARM::ADDri, Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImm }, },
  { 14 /* add */, ARM::SUBri, Convert__Reg1_2__Reg1_3__ModImmNeg1_4__CondCode2_1__CCOut1_0, Feature_IsARM|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImmNeg }, },
  { 14 /* add */, ARM::ADDrsi, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedImm }, },
  { 14 /* add */, ARM::ADDrsr, Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedReg }, },
  { 14 /* add */, ARM::t2ADDrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_GPRnopc, MCK_rGPR }, },
  { 14 /* add */, ARM::t2ADDrs, Convert__Reg1_3__Reg1_4__RegShiftedImm2_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 14 /* add */, ARM::t2ADDri, Convert__Reg1_3__Reg1_4__T2SOImm1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_GPRnopc, MCK_T2SOImm }, },
  { 14 /* add */, ARM::t2SUBri, Convert__Reg1_3__Reg1_4__T2SOImmNeg1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_GPRnopc, MCK_T2SOImmNeg }, },
  { 14 /* add */, ARM::t2SUBri, Convert__Reg1_3__Reg1_4__T2SOImmNeg1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_GPRnopc, MCK_T2SOImmNeg }, },
  { 18 /* addw */, ARM::t2SUBri12, Convert__Reg1_1__Reg1_1__Imm0_4095Neg1_2__CondCode2_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CondCode, MCK_GPRnopc, MCK_Imm0_4095Neg }, },
  { 18 /* addw */, ARM::t2ADDri12, Convert__Reg1_1__Reg1_2__Imm0_40951_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_Imm0_4095 }, },
  { 18 /* addw */, ARM::t2SUBri12, Convert__Reg1_1__Reg1_2__Imm0_4095Neg1_3__CondCode2_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_Imm0_4095Neg }, },
  { 18 /* addw */, ARM::t2SUBri12, Convert__Reg1_1__Reg1_2__T2SOImmNeg1_3__CondCode2_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_T2SOImmNeg }, },
  { 23 /* adr */, ARM::tADR, Convert__Reg1_1__UnsignedOffset_b8s21_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_UnsignedOffset_b8s2 }, },
  { 23 /* adr */, ARM::t2ADR, Convert__Reg1_1__Imm1_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Imm }, },
  { 23 /* adr */, ARM::ADR, Convert__Reg1_1__AdrLabel1_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_AdrLabel }, },
  { 23 /* adr */, ARM::t2ADR, Convert__Reg1_2__Imm1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_Imm }, },
  { 27 /* aesd */, ARM::AESD, Convert__Reg1_1__Tie0_1_1__Reg1_2, Feature_HasV8|Feature_HasCrypto, { MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 32 /* aese */, ARM::AESE, Convert__Reg1_1__Tie0_1_1__Reg1_2, Feature_HasV8|Feature_HasCrypto, { MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 37 /* aesimc */, ARM::AESIMC, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasCrypto, { MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 44 /* aesmc */, ARM::AESMC, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasCrypto, { MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 50 /* and */, ARM::tAND, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 50 /* and */, ARM::t2ANDrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 50 /* and */, ARM::t2ANDrs, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_RegShiftedImm }, },
  { 50 /* and */, ARM::t2ANDri, Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 50 /* and */, ARM::t2BICri, Convert__Reg1_2__Reg1_2__T2SOImmNot1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImmNot }, },
  { 50 /* and */, ARM::ANDrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 50 /* and */, ARM::ANDri, Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 50 /* and */, ARM::BICri, Convert__Reg1_2__Reg1_2__ModImmNot1_3__CondCode2_1__CCOut1_0, Feature_IsARM|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImmNot }, },
  { 50 /* and */, ARM::ANDrsi, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 50 /* and */, ARM::ANDrsr, Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedReg }, },
  { 50 /* and */, ARM::t2ANDrr, Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 50 /* and */, ARM::t2ANDrs, Convert__Reg1_3__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_RegShiftedImm }, },
  { 50 /* and */, ARM::t2ANDri, Convert__Reg1_3__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImm }, },
  { 50 /* and */, ARM::t2BICri, Convert__Reg1_3__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImmNot }, },
  { 50 /* and */, ARM::t2ANDrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 50 /* and */, ARM::t2ANDrs, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 50 /* and */, ARM::t2ANDri, Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 50 /* and */, ARM::t2BICri, Convert__Reg1_2__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImmNot }, },
  { 50 /* and */, ARM::ANDrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 50 /* and */, ARM::ANDri, Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImm }, },
  { 50 /* and */, ARM::BICri, Convert__Reg1_2__Reg1_3__ModImmNot1_4__CondCode2_1__CCOut1_0, Feature_IsARM|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImmNot }, },
  { 50 /* and */, ARM::ANDrsi, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedImm }, },
  { 50 /* and */, ARM::ANDrsr, Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedReg }, },
  { 50 /* and */, ARM::t2ANDrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 50 /* and */, ARM::t2ANDrs, Convert__Reg1_3__Reg1_4__RegShiftedImm2_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 50 /* and */, ARM::t2ANDri, Convert__Reg1_3__Reg1_4__T2SOImm1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 50 /* and */, ARM::t2BICri, Convert__Reg1_3__Reg1_4__T2SOImmNot1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_T2SOImmNot }, },
  { 54 /* asr */, ARM::tASRrr, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 54 /* asr */, ARM::tASRri, Convert__Reg1_2__CCOut1_0__Reg1_2__ImmThumbSR1_3__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_ImmThumbSR }, },
  { 54 /* asr */, ARM::t2ASRrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 54 /* asr */, ARM::t2ASRri, Convert__Reg1_2__Reg1_2__ImmThumbSR1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_ImmThumbSR }, },
  { 54 /* asr */, ARM::ASRr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 54 /* asr */, ARM::ASRi, Convert__Reg1_2__Reg1_2__Imm0_321_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_Imm0_32 }, },
  { 54 /* asr */, ARM::t2ASRrr, Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 54 /* asr */, ARM::t2ASRri, Convert__Reg1_3__Reg1_3__ImmThumbSR1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_ImmThumbSR }, },
  { 54 /* asr */, ARM::tASRri, Convert__Reg1_2__CCOut1_0__Reg1_3__ImmThumbSR1_4__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR, MCK_ImmThumbSR }, },
  { 54 /* asr */, ARM::t2ASRrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 54 /* asr */, ARM::t2ASRri, Convert__Reg1_2__Reg1_3__ImmThumbSR1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_ImmThumbSR }, },
  { 54 /* asr */, ARM::ASRr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 54 /* asr */, ARM::ASRi, Convert__Reg1_2__Reg1_3__Imm0_321_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_Imm0_32 }, },
  { 54 /* asr */, ARM::t2ASRrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 54 /* asr */, ARM::t2ASRri, Convert__Reg1_3__Reg1_4__ImmThumbSR1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_ImmThumbSR }, },
  { 58 /* b */, ARM::Bcc, Convert__ARMBranchTarget1_1__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_ARMBranchTarget }, },
  { 58 /* b */, ARM::tB, ConvertCustom_cvtThumbBranches, Feature_IsThumb, { MCK_CondCode, MCK_Imm }, },
  { 58 /* b */, ARM::tBcc, ConvertCustom_cvtThumbBranches, Feature_IsThumb, { MCK_CondCode, MCK_ThumbBranchTarget }, },
  { 58 /* b */, ARM::t2Bcc, ConvertCustom_cvtThumbBranches, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_Imm }, },
  { 58 /* b */, ARM::t2B, ConvertCustom_cvtThumbBranches, Feature_IsThumb|Feature_HasV8MBaseline, { MCK_CondCode, MCK__DOT_w, MCK_ThumbBranchTarget }, },
  { 60 /* bfc */, ARM::t2BFC, Convert__Reg1_1__Tie0_1_1__Bitfield1_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Bitfield }, },
  { 60 /* bfc */, ARM::BFC, Convert__Reg1_1__Tie0_1_1__Bitfield1_2__CondCode2_0, Feature_IsARM|Feature_HasV6T2, { MCK_CondCode, MCK_GPR, MCK_Bitfield }, },
  { 64 /* bfi */, ARM::t2BFI, Convert__Reg1_1__Tie0_1_1__Reg1_2__Bitfield1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_Bitfield }, },
  { 64 /* bfi */, ARM::BFI, Convert__Reg1_1__Tie0_1_1__Reg1_2__Bitfield1_3__CondCode2_0, Feature_IsARM|Feature_HasV6T2, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_Bitfield }, },
  { 68 /* bic */, ARM::tBIC, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 68 /* bic */, ARM::t2BICrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 68 /* bic */, ARM::t2BICrs, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_RegShiftedImm }, },
  { 68 /* bic */, ARM::t2BICri, Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 68 /* bic */, ARM::t2ANDri, Convert__Reg1_2__Reg1_2__T2SOImmNot1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImmNot }, },
  { 68 /* bic */, ARM::BICrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 68 /* bic */, ARM::BICri, Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 68 /* bic */, ARM::ANDri, Convert__Reg1_2__Reg1_2__ModImmNot1_3__CondCode2_1__CCOut1_0, Feature_IsARM|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImmNot }, },
  { 68 /* bic */, ARM::BICrsi, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 68 /* bic */, ARM::BICrsr, Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedReg }, },
  { 68 /* bic */, ARM::t2BICrr, Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 68 /* bic */, ARM::t2BICrs, Convert__Reg1_3__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_RegShiftedImm }, },
  { 68 /* bic */, ARM::t2BICri, Convert__Reg1_3__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImm }, },
  { 68 /* bic */, ARM::t2ANDri, Convert__Reg1_3__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImmNot }, },
  { 68 /* bic */, ARM::t2BICrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 68 /* bic */, ARM::t2BICrs, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 68 /* bic */, ARM::t2BICri, Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 68 /* bic */, ARM::t2ANDri, Convert__Reg1_2__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImmNot }, },
  { 68 /* bic */, ARM::BICrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 68 /* bic */, ARM::BICri, Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImm }, },
  { 68 /* bic */, ARM::ANDri, Convert__Reg1_2__Reg1_3__ModImmNot1_4__CondCode2_1__CCOut1_0, Feature_IsARM|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImmNot }, },
  { 68 /* bic */, ARM::BICrsi, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedImm }, },
  { 68 /* bic */, ARM::BICrsr, Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedReg }, },
  { 68 /* bic */, ARM::t2BICrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 68 /* bic */, ARM::t2BICrs, Convert__Reg1_3__Reg1_4__RegShiftedImm2_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 68 /* bic */, ARM::t2BICri, Convert__Reg1_3__Reg1_4__T2SOImm1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 68 /* bic */, ARM::t2ANDri, Convert__Reg1_3__Reg1_4__T2SOImmNot1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_T2SOImmNot }, },
  { 72 /* bkpt */, ARM::BKPT, Convert__imm_95_0, Feature_IsARM, {  }, },
  { 72 /* bkpt */, ARM::tBKPT, Convert__imm_95_0, Feature_IsThumb, {  }, },
  { 72 /* bkpt */, ARM::tBKPT, Convert__Imm0_2551_0, Feature_IsThumb, { MCK_Imm0_255 }, },
  { 72 /* bkpt */, ARM::BKPT, Convert__Imm0_655351_0, Feature_IsARM, { MCK_Imm0_65535 }, },
  { 77 /* bl */, ARM::BL, Convert__ARMBranchTarget1_0, Feature_IsARM, { MCK_ARMBranchTarget }, },
  { 77 /* bl */, ARM::BL_pred, Convert__ARMBranchTarget1_1__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_ARMBranchTarget }, },
  { 77 /* bl */, ARM::tBL, Convert__CondCode2_0__ThumbBranchTarget1_1, Feature_IsThumb, { MCK_CondCode, MCK_ThumbBranchTarget }, },
  { 80 /* blx */, ARM::BLX, Convert__Reg1_0, Feature_IsARM|Feature_HasV5T, { MCK_GPR }, },
  { 80 /* blx */, ARM::BLXi, Convert__ThumbBranchTarget1_0, Feature_IsARM|Feature_HasV5T, { MCK_ThumbBranchTarget }, },
  { 80 /* blx */, ARM::BLX_pred, Convert__Reg1_1__CondCode2_0, Feature_IsARM|Feature_HasV5T, { MCK_CondCode, MCK_GPR }, },
  { 80 /* blx */, ARM::tBLXr, Convert__CondCode2_0__Reg1_1, Feature_IsThumb|Feature_HasV5T, { MCK_CondCode, MCK_GPR }, },
  { 80 /* blx */, ARM::tBLXi, Convert__CondCode2_0__ARMBranchTarget1_1, Feature_IsThumb|Feature_HasV5T|Feature_IsNotMClass, { MCK_CondCode, MCK_ARMBranchTarget }, },
  { 84 /* blxns */, ARM::tBLXNSr, Convert__CondCode2_0__Reg1_1, Feature_IsThumb|Feature_Has8MSecExt, { MCK_CondCode, MCK_GPRnopc }, },
  { 90 /* bx */, ARM::BX, Convert__Reg1_0, Feature_IsARM|Feature_HasV4T, { MCK_GPR }, },
  { 90 /* bx */, ARM::BX_RET, Convert__CondCode2_0, Feature_IsARM|Feature_HasV4T, { MCK_CondCode, MCK_LR }, },
  { 90 /* bx */, ARM::BX_pred, Convert__Reg1_1__CondCode2_0, Feature_IsARM|Feature_HasV4T, { MCK_CondCode, MCK_GPR }, },
  { 90 /* bx */, ARM::tBX, Convert__Reg1_1__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_GPR }, },
  { 93 /* bxj */, ARM::t2BXJ, Convert__Reg1_1__CondCode2_0, Feature_IsThumb2|Feature_IsNotMClass, { MCK_CondCode, MCK_GPRnopc }, },
  { 93 /* bxj */, ARM::BXJ, Convert__Reg1_1__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR }, },
  { 97 /* bxns */, ARM::tBXNS, Convert__Reg1_1__CondCode2_0, Feature_IsThumb|Feature_Has8MSecExt, { MCK_CondCode, MCK_GPR }, },
  { 102 /* cbnz */, ARM::tCBNZ, Convert__Reg1_0__ThumbBranchTarget1_1, Feature_IsThumb|Feature_HasV8MBaseline, { MCK_tGPR, MCK_ThumbBranchTarget }, },
  { 107 /* cbz */, ARM::tCBZ, Convert__Reg1_0__ThumbBranchTarget1_1, Feature_IsThumb|Feature_HasV8MBaseline, { MCK_tGPR, MCK_ThumbBranchTarget }, },
  { 111 /* cdp */, ARM::CDP, Convert__CoprocNum1_1__Imm0_151_2__CoprocReg1_3__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0, Feature_IsARM|Feature_PreV8, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_15, MCK_CoprocReg, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 111 /* cdp */, ARM::t2CDP, Convert__CoprocNum1_1__Imm0_151_2__CoprocReg1_3__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0, Feature_IsThumb2|Feature_PreV8, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_15, MCK_CoprocReg, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 115 /* cdp2 */, ARM::CDP2, Convert__CoprocNum1_0__Imm0_151_1__CoprocReg1_2__CoprocReg1_3__CoprocReg1_4__Imm0_71_5, Feature_IsARM|Feature_PreV8, { MCK_CoprocNum, MCK_Imm0_15, MCK_CoprocReg, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 115 /* cdp2 */, ARM::t2CDP2, Convert__CoprocNum1_1__Imm0_151_2__CoprocReg1_3__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0, Feature_IsThumb2|Feature_PreV8, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_15, MCK_CoprocReg, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 120 /* clrex */, ARM::CLREX, Convert_NoOperands, Feature_IsARM|Feature_HasV6K, {  }, },
  { 120 /* clrex */, ARM::t2CLREX, Convert__CondCode2_0, Feature_IsThumb|Feature_HasV7Clrex, { MCK_CondCode }, },
  { 126 /* clz */, ARM::t2CLZ, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 126 /* clz */, ARM::CLZ, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsARM|Feature_HasV5T, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 130 /* cmn */, ARM::tCMNz, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 130 /* cmn */, ARM::CMPri, Convert__Reg1_1__ModImmNeg1_2__CondCode2_0, Feature_IsARM|Feature_UseNegativeImmediates, { MCK_CondCode, MCK_rGPR, MCK_ModImmNeg }, },
  { 130 /* cmn */, ARM::t2CMPri, Convert__Reg1_1__T2SOImmNeg1_2__CondCode2_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CondCode, MCK_rGPR, MCK_T2SOImmNeg }, },
  { 130 /* cmn */, ARM::t2CMNzrr, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_rGPR }, },
  { 130 /* cmn */, ARM::t2CMNzrs, Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 130 /* cmn */, ARM::CMNzrsr, Convert__Reg1_1__RegShiftedReg3_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedReg }, },
  { 130 /* cmn */, ARM::t2CMNri, Convert__Reg1_1__T2SOImm1_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_T2SOImm }, },
  { 130 /* cmn */, ARM::CMNzrr, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 130 /* cmn */, ARM::CMNri, Convert__Reg1_1__ModImm1_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 130 /* cmn */, ARM::CMNzrsi, Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 130 /* cmn */, ARM::t2CMNzrr, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_rGPR }, },
  { 130 /* cmn */, ARM::t2CMNzrs, Convert__Reg1_2__RegShiftedImm2_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 130 /* cmn */, ARM::t2CMNri, Convert__Reg1_2__T2SOImm1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_T2SOImm }, },
  { 134 /* cmp */, ARM::tCMPr, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 134 /* cmp */, ARM::tCMPi8, Convert__Reg1_1__Imm0_2551_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_Imm0_255 }, },
  { 134 /* cmp */, ARM::CMNri, Convert__Reg1_1__ModImmNeg1_2__CondCode2_0, Feature_IsARM|Feature_UseNegativeImmediates, { MCK_CondCode, MCK_rGPR, MCK_ModImmNeg }, },
  { 134 /* cmp */, ARM::t2CMNri, Convert__Reg1_1__T2SOImmNeg1_2__CondCode2_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CondCode, MCK_rGPR, MCK_T2SOImmNeg }, },
  { 134 /* cmp */, ARM::t2CMPrs, Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 134 /* cmp */, ARM::CMPrsr, Convert__Reg1_1__RegShiftedReg3_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedReg }, },
  { 134 /* cmp */, ARM::t2CMPri, Convert__Reg1_1__T2SOImm1_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_T2SOImm }, },
  { 134 /* cmp */, ARM::CMPrr, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 134 /* cmp */, ARM::tCMPhir, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 134 /* cmp */, ARM::CMPri, Convert__Reg1_1__ModImm1_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 134 /* cmp */, ARM::CMPrsi, Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 134 /* cmp */, ARM::t2CMPrr, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_rGPR }, },
  { 134 /* cmp */, ARM::t2CMPrs, Convert__Reg1_2__RegShiftedImm2_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 134 /* cmp */, ARM::t2CMPri, Convert__Reg1_2__T2SOImm1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_T2SOImm }, },
  { 138 /* cps */, ARM::t2CPS1p, Convert__Imm0_311_0, Feature_IsThumb2|Feature_IsNotMClass, { MCK_Imm0_31 }, },
  { 138 /* cps */, ARM::CPS1p, Convert__Imm0_311_0, Feature_IsARM, { MCK_Imm0_31 }, },
  { 138 /* cps */, ARM::t2CPS1p, Convert__Imm0_311_1, Feature_IsThumb2, { MCK__DOT_w, MCK_Imm0_31 }, },
  { 138 /* cps */, ARM::CPS2p, Convert__Imm1_0__ProcIFlags1_1, Feature_IsARM, { MCK_Imm, MCK_ProcIFlags }, },
  { 138 /* cps */, ARM::tCPS, Convert__Imm1_0__ProcIFlags1_1, Feature_IsThumb, { MCK_Imm, MCK_ProcIFlags }, },
  { 138 /* cps */, ARM::t2CPS2p, Convert__Imm1_0__ProcIFlags1_2, Feature_IsThumb2|Feature_IsNotMClass, { MCK_Imm, MCK__DOT_w, MCK_ProcIFlags }, },
  { 138 /* cps */, ARM::CPS3p, Convert__Imm1_0__ProcIFlags1_1__Imm0_311_2, Feature_IsARM, { MCK_Imm, MCK_ProcIFlags, MCK_Imm0_31 }, },
  { 138 /* cps */, ARM::t2CPS3p, Convert__Imm1_0__ProcIFlags1_1__Imm1_2, Feature_IsThumb2|Feature_IsNotMClass, { MCK_Imm, MCK_ProcIFlags, MCK_Imm }, },
  { 138 /* cps */, ARM::t2CPS3p, Convert__Imm1_0__ProcIFlags1_2__Imm1_3, Feature_IsThumb2, { MCK_Imm, MCK__DOT_w, MCK_ProcIFlags, MCK_Imm }, },
  { 142 /* crc32b */, ARM::t2CRC32B, Convert__Reg1_0__Reg1_1__Reg1_2, Feature_IsThumb2|Feature_HasV8|Feature_HasCRC, { MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 142 /* crc32b */, ARM::CRC32B, Convert__Reg1_0__Reg1_1__Reg1_2, Feature_IsARM|Feature_HasV8|Feature_HasCRC, { MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 149 /* crc32cb */, ARM::t2CRC32CB, Convert__Reg1_0__Reg1_1__Reg1_2, Feature_IsThumb2|Feature_HasV8|Feature_HasCRC, { MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 149 /* crc32cb */, ARM::CRC32CB, Convert__Reg1_0__Reg1_1__Reg1_2, Feature_IsARM|Feature_HasV8|Feature_HasCRC, { MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 157 /* crc32ch */, ARM::t2CRC32CH, Convert__Reg1_0__Reg1_1__Reg1_2, Feature_IsThumb2|Feature_HasV8|Feature_HasCRC, { MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 157 /* crc32ch */, ARM::CRC32CH, Convert__Reg1_0__Reg1_1__Reg1_2, Feature_IsARM|Feature_HasV8|Feature_HasCRC, { MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 165 /* crc32cw */, ARM::t2CRC32CW, Convert__Reg1_0__Reg1_1__Reg1_2, Feature_IsThumb2|Feature_HasV8|Feature_HasCRC, { MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 165 /* crc32cw */, ARM::CRC32CW, Convert__Reg1_0__Reg1_1__Reg1_2, Feature_IsARM|Feature_HasV8|Feature_HasCRC, { MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 173 /* crc32h */, ARM::t2CRC32H, Convert__Reg1_0__Reg1_1__Reg1_2, Feature_IsThumb2|Feature_HasV8|Feature_HasCRC, { MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 173 /* crc32h */, ARM::CRC32H, Convert__Reg1_0__Reg1_1__Reg1_2, Feature_IsARM|Feature_HasV8|Feature_HasCRC, { MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 180 /* crc32w */, ARM::t2CRC32W, Convert__Reg1_0__Reg1_1__Reg1_2, Feature_IsThumb2|Feature_HasV8|Feature_HasCRC, { MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 180 /* crc32w */, ARM::CRC32W, Convert__Reg1_0__Reg1_1__Reg1_2, Feature_IsARM|Feature_HasV8|Feature_HasCRC, { MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 187 /* csdb */, ARM::HINT, Convert__imm_95_20__CondCode2_0, Feature_IsARM|Feature_HasV6K, { MCK_CondCode }, },
  { 187 /* csdb */, ARM::t2HINT, Convert__imm_95_20__CondCode2_0, Feature_IsThumb2, { MCK_CondCode }, },
  { 187 /* csdb */, ARM::t2HINT, Convert__imm_95_20__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w }, },
  { 192 /* dbg */, ARM::DBG, Convert__Imm0_151_1__CondCode2_0, Feature_IsARM|Feature_HasV7, { MCK_CondCode, MCK_Imm0_15 }, },
  { 192 /* dbg */, ARM::t2DBG, Convert__Imm0_151_1__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_Imm0_15 }, },
  { 196 /* dcps1 */, ARM::t2DCPS1, Convert__CondCode2_0, Feature_IsThumb2|Feature_HasV8, { MCK_CondCode }, },
  { 202 /* dcps2 */, ARM::t2DCPS2, Convert__CondCode2_0, Feature_IsThumb2|Feature_HasV8, { MCK_CondCode }, },
  { 208 /* dcps3 */, ARM::t2DCPS3, Convert__CondCode2_0, Feature_IsThumb2|Feature_HasV8, { MCK_CondCode }, },
  { 214 /* dfb */, ARM::DSB, Convert__imm_95_12, Feature_IsARM|Feature_HasDFB, {  }, },
  { 214 /* dfb */, ARM::t2DSB, Convert__imm_95_12__CondCode2_0, Feature_HasDFB, { MCK_CondCode }, },
  { 218 /* dmb */, ARM::DMB, Convert__imm_95_15, Feature_IsARM|Feature_HasDB, {  }, },
  { 218 /* dmb */, ARM::t2DMB, Convert__imm_95_15__CondCode2_0, Feature_HasDB, { MCK_CondCode }, },
  { 218 /* dmb */, ARM::DMB, Convert__MemBarrierOpt1_0, Feature_IsARM|Feature_HasDB, { MCK_MemBarrierOpt }, },
  { 218 /* dmb */, ARM::t2DMB, Convert__MemBarrierOpt1_1__CondCode2_0, Feature_IsThumb|Feature_HasDB, { MCK_CondCode, MCK_MemBarrierOpt }, },
  { 222 /* dsb */, ARM::DSB, Convert__imm_95_15, Feature_IsARM|Feature_HasDB, {  }, },
  { 222 /* dsb */, ARM::t2DSB, Convert__imm_95_15__CondCode2_0, Feature_HasDB, { MCK_CondCode }, },
  { 222 /* dsb */, ARM::DSB, Convert__MemBarrierOpt1_0, Feature_IsARM|Feature_HasDB, { MCK_MemBarrierOpt }, },
  { 222 /* dsb */, ARM::t2DSB, Convert__MemBarrierOpt1_1__CondCode2_0, Feature_IsThumb|Feature_HasDB, { MCK_CondCode, MCK_MemBarrierOpt }, },
  { 226 /* eor */, ARM::tEOR, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 226 /* eor */, ARM::t2EORrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 226 /* eor */, ARM::t2EORrs, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_RegShiftedImm }, },
  { 226 /* eor */, ARM::t2EORri, Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 226 /* eor */, ARM::EORrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 226 /* eor */, ARM::EORri, Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 226 /* eor */, ARM::EORrsi, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 226 /* eor */, ARM::EORrsr, Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedReg }, },
  { 226 /* eor */, ARM::t2EORrr, Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 226 /* eor */, ARM::t2EORrs, Convert__Reg1_3__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_RegShiftedImm }, },
  { 226 /* eor */, ARM::t2EORri, Convert__Reg1_3__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImm }, },
  { 226 /* eor */, ARM::t2EORrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 226 /* eor */, ARM::t2EORrs, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 226 /* eor */, ARM::t2EORri, Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 226 /* eor */, ARM::EORrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 226 /* eor */, ARM::EORri, Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImm }, },
  { 226 /* eor */, ARM::EORrsi, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedImm }, },
  { 226 /* eor */, ARM::EORrsr, Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedReg }, },
  { 226 /* eor */, ARM::t2EORrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 226 /* eor */, ARM::t2EORrs, Convert__Reg1_3__Reg1_4__RegShiftedImm2_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 226 /* eor */, ARM::t2EORri, Convert__Reg1_3__Reg1_4__T2SOImm1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 230 /* eret */, ARM::ERET, Convert__CondCode2_0, Feature_IsARM|Feature_HasVirtualization, { MCK_CondCode }, },
  { 230 /* eret */, ARM::t2SUBS_PC_LR, Convert__imm_95_0__CondCode2_0, Feature_IsThumb2|Feature_HasVirtualization, { MCK_CondCode }, },
  { 235 /* esb */, ARM::HINT, Convert__imm_95_16__CondCode2_0, Feature_IsARM|Feature_HasRAS, { MCK_CondCode }, },
  { 235 /* esb */, ARM::t2HINT, Convert__imm_95_16__CondCode2_0, Feature_IsThumb2|Feature_HasRAS, { MCK_CondCode }, },
  { 235 /* esb */, ARM::t2HINT, Convert__imm_95_16__CondCode2_0, Feature_IsThumb2|Feature_HasRAS, { MCK_CondCode, MCK__DOT_w }, },
  { 239 /* faddd */, ARM::VADDD, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 245 /* fadds */, ARM::VADDS, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 251 /* fcmpzd */, ARM::VCMPZD, Convert__Reg1_1__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK_DPR }, },
  { 258 /* fcmpzs */, ARM::VCMPZS, Convert__Reg1_1__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_HPR }, },
  { 265 /* fconstd */, ARM::FCONSTD, Convert__Reg1_1__FPImm1_2__CondCode2_0, Feature_HasVFP3, { MCK_CondCode, MCK_DPR, MCK_FPImm }, },
  { 273 /* fconsts */, ARM::FCONSTS, Convert__Reg1_1__FPImm1_2__CondCode2_0, Feature_HasVFP3, { MCK_CondCode, MCK_HPR, MCK_FPImm }, },
  { 281 /* fldmdbx */, ARM::FLDMXDB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__DPRRegList1_3, Feature_HasVFP2, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_DPRRegList }, },
  { 289 /* fldmiax */, ARM::FLDMXIA, Convert__Reg1_1__CondCode2_0__DPRRegList1_2, Feature_HasVFP2, { MCK_CondCode, MCK_GPR, MCK_DPRRegList }, },
  { 289 /* fldmiax */, ARM::FLDMXIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__DPRRegList1_3, Feature_HasVFP2, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_DPRRegList }, },
  { 297 /* fmdhr */, ARM::VSETLNi32, Convert__Reg1_1__Tie0_2_2__Reg1_2__imm_95_1__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_DPR, MCK_GPR }, },
  { 303 /* fmdlr */, ARM::VSETLNi32, Convert__Reg1_1__Tie0_2_2__Reg1_2__imm_95_0__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_DPR, MCK_GPR }, },
  { 309 /* fmstat */, ARM::FMSTAT, Convert__CondCode2_0, Feature_HasVFP2, { MCK_CondCode }, },
  { 316 /* fstmdbx */, ARM::FSTMXDB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__DPRRegList1_3, Feature_HasVFP2, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_DPRRegList }, },
  { 324 /* fstmiax */, ARM::FSTMXIA, Convert__Reg1_1__CondCode2_0__DPRRegList1_2, Feature_HasVFP2, { MCK_CondCode, MCK_GPR, MCK_DPRRegList }, },
  { 324 /* fstmiax */, ARM::FSTMXIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__DPRRegList1_3, Feature_HasVFP2, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_DPRRegList }, },
  { 332 /* fsubd */, ARM::VSUBD, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 338 /* fsubs */, ARM::VSUBS, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 344 /* hint */, ARM::tHINT, Convert__Imm0_151_1__CondCode2_0, Feature_IsThumb|Feature_HasV6M, { MCK_CondCode, MCK_Imm0_15 }, },
  { 344 /* hint */, ARM::HINT, Convert__Imm0_2391_1__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_Imm0_239 }, },
  { 344 /* hint */, ARM::t2HINT, Convert__Imm0_2391_1__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_Imm0_239 }, },
  { 344 /* hint */, ARM::t2HINT, Convert__Imm0_2391_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_Imm0_239 }, },
  { 349 /* hlt */, ARM::tHLT, Convert__Imm0_631_0, Feature_IsThumb|Feature_HasV8, { MCK_Imm0_63 }, },
  { 349 /* hlt */, ARM::HLT, Convert__Imm0_655351_0, Feature_IsARM|Feature_HasV8, { MCK_Imm0_65535 }, },
  { 353 /* hvc */, ARM::HVC, Convert__Imm0_655351_0, Feature_IsARM|Feature_HasVirtualization, { MCK_Imm0_65535 }, },
  { 353 /* hvc */, ARM::t2HVC, Convert__Imm0_655351_0, Feature_IsThumb2, { MCK_Imm0_65535 }, },
  { 353 /* hvc */, ARM::t2HVC, Convert__Imm0_655351_1, Feature_IsThumb2|Feature_HasVirtualization, { MCK__DOT_w, MCK_Imm0_65535 }, },
  { 357 /* isb */, ARM::ISB, Convert__imm_95_15, Feature_IsARM|Feature_HasDB, {  }, },
  { 357 /* isb */, ARM::t2ISB, Convert__imm_95_15__CondCode2_0, Feature_HasDB, { MCK_CondCode }, },
  { 357 /* isb */, ARM::ISB, Convert__InstSyncBarrierOpt1_0, Feature_IsARM|Feature_HasDB, { MCK_InstSyncBarrierOpt }, },
  { 357 /* isb */, ARM::t2ISB, Convert__InstSyncBarrierOpt1_1__CondCode2_0, Feature_IsThumb|Feature_HasDB, { MCK_CondCode, MCK_InstSyncBarrierOpt }, },
  { 361 /* it */, ARM::ITasm, Convert__ITCondCode1_1__ITMask1_0, Feature_IsARM, { MCK_ITMask, MCK_ITCondCode }, },
  { 361 /* it */, ARM::t2IT, Convert__ITCondCode1_1__ITMask1_0, Feature_IsThumb2, { MCK_ITMask, MCK_ITCondCode }, },
  { 364 /* lda */, ARM::t2LDA, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsThumb|Feature_HasAcquireRelease, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset }, },
  { 364 /* lda */, ARM::LDA, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsARM|Feature_HasAcquireRelease, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 368 /* ldab */, ARM::t2LDAB, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsThumb|Feature_HasAcquireRelease, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset }, },
  { 368 /* ldab */, ARM::LDAB, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsARM|Feature_HasAcquireRelease, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 373 /* ldaex */, ARM::t2LDAEX, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsThumb|Feature_HasAcquireRelease|Feature_HasV7Clrex, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset }, },
  { 373 /* ldaex */, ARM::LDAEX, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsARM|Feature_HasAcquireRelease|Feature_HasV7Clrex, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 379 /* ldaexb */, ARM::t2LDAEXB, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsThumb|Feature_HasAcquireRelease|Feature_HasV7Clrex, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset }, },
  { 379 /* ldaexb */, ARM::LDAEXB, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsARM|Feature_HasAcquireRelease|Feature_HasV7Clrex, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 386 /* ldaexd */, ARM::LDAEXD, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsARM|Feature_HasAcquireRelease|Feature_HasV7Clrex, { MCK_CondCode, MCK_GPRPair, MCK_MemNoOffset }, },
  { 386 /* ldaexd */, ARM::t2LDAEXD, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, Feature_IsThumb|Feature_HasAcquireRelease|Feature_HasV7Clrex|Feature_IsNotMClass, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemNoOffset }, },
  { 393 /* ldaexh */, ARM::t2LDAEXH, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsThumb|Feature_HasAcquireRelease|Feature_HasV7Clrex, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset }, },
  { 393 /* ldaexh */, ARM::LDAEXH, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsARM|Feature_HasAcquireRelease|Feature_HasV7Clrex, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 400 /* ldah */, ARM::t2LDAH, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsThumb|Feature_HasAcquireRelease, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset }, },
  { 400 /* ldah */, ARM::LDAH, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsARM|Feature_HasAcquireRelease, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 405 /* ldc */, ARM::LDC_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 405 /* ldc */, ARM::t2LDC_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 405 /* ldc */, ARM::LDC_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 405 /* ldc */, ARM::t2LDC_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 405 /* ldc */, ARM::LDC_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 405 /* ldc */, ARM::t2LDC_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 405 /* ldc */, ARM::LDC_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 405 /* ldc */, ARM::t2LDC_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 409 /* ldc2 */, ARM::LDC2_OFFSET, Convert__CoprocNum1_0__CoprocReg1_1__AddrMode52_2, Feature_IsARM|Feature_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 409 /* ldc2 */, ARM::t2LDC2_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_PreV8|Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 409 /* ldc2 */, ARM::LDC2_PRE, Convert__CoprocNum1_0__CoprocReg1_1__AddrMode52_2, Feature_IsARM|Feature_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 409 /* ldc2 */, ARM::LDC2_OPTION, Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__CoprocOption1_3, Feature_IsARM|Feature_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 409 /* ldc2 */, ARM::LDC2_POST, Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__PostIdxImm8s41_3, Feature_IsARM|Feature_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 409 /* ldc2 */, ARM::t2LDC2_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_PreV8|Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 409 /* ldc2 */, ARM::t2LDC2_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, Feature_PreV8|Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 409 /* ldc2 */, ARM::t2LDC2_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, Feature_PreV8|Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 414 /* ldc2l */, ARM::LDC2L_OFFSET, Convert__CoprocNum1_0__CoprocReg1_1__AddrMode52_2, Feature_IsARM|Feature_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 414 /* ldc2l */, ARM::t2LDC2L_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_PreV8|Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 414 /* ldc2l */, ARM::LDC2L_PRE, Convert__CoprocNum1_0__CoprocReg1_1__AddrMode52_2, Feature_IsARM|Feature_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 414 /* ldc2l */, ARM::LDC2L_OPTION, Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__CoprocOption1_3, Feature_IsARM|Feature_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 414 /* ldc2l */, ARM::LDC2L_POST, Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__PostIdxImm8s41_3, Feature_IsARM|Feature_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 414 /* ldc2l */, ARM::t2LDC2L_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_PreV8|Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 414 /* ldc2l */, ARM::t2LDC2L_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, Feature_PreV8|Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 414 /* ldc2l */, ARM::t2LDC2L_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, Feature_PreV8|Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 420 /* ldcl */, ARM::LDCL_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 420 /* ldcl */, ARM::t2LDCL_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 420 /* ldcl */, ARM::LDCL_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 420 /* ldcl */, ARM::t2LDCL_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 420 /* ldcl */, ARM::LDCL_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 420 /* ldcl */, ARM::t2LDCL_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 420 /* ldcl */, ARM::LDCL_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 420 /* ldcl */, ARM::t2LDCL_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 425 /* ldm */, ARM::tLDMIA, Convert__Reg1_1__CondCode2_0__RegList1_2, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_RegList }, },
  { 425 /* ldm */, ARM::LDMIA, Convert__Reg1_1__CondCode2_0__RegList1_2, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 425 /* ldm */, ARM::t2LDMIA, Convert__Reg1_1__CondCode2_0__RegList1_2, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 425 /* ldm */, ARM::t2LDMIA, Convert__Reg1_2__CondCode2_0__RegList1_3, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_RegList }, },
  { 425 /* ldm */, ARM::tLDMIA, Convert__Reg1_1__CondCode2_0__RegList1_3, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 425 /* ldm */, ARM::LDMIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 425 /* ldm */, ARM::t2LDMIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 425 /* ldm */, ARM::sysLDMIA, Convert__Reg1_1__CondCode2_0__RegList1_2, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList, MCK__94_ }, },
  { 425 /* ldm */, ARM::t2LDMIA_UPD, Convert__Reg1_2__Tie0_3_3__CondCode2_0__RegList1_4, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 425 /* ldm */, ARM::sysLDMIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList, MCK__94_ }, },
  { 429 /* ldmda */, ARM::LDMDA, Convert__Reg1_1__CondCode2_0__RegList1_2, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 429 /* ldmda */, ARM::LDMDA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 429 /* ldmda */, ARM::sysLDMDA, Convert__Reg1_1__CondCode2_0__RegList1_2, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList, MCK__94_ }, },
  { 429 /* ldmda */, ARM::sysLDMDA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList, MCK__94_ }, },
  { 435 /* ldmdb */, ARM::LDMDB, Convert__Reg1_1__CondCode2_0__RegList1_2, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 435 /* ldmdb */, ARM::t2LDMDB, Convert__Reg1_1__CondCode2_0__RegList1_2, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 435 /* ldmdb */, ARM::t2LDMDB, Convert__Reg1_2__CondCode2_0__RegList1_3, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_RegList }, },
  { 435 /* ldmdb */, ARM::LDMDB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 435 /* ldmdb */, ARM::t2LDMDB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 435 /* ldmdb */, ARM::sysLDMDB, Convert__Reg1_1__CondCode2_0__RegList1_2, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList, MCK__94_ }, },
  { 435 /* ldmdb */, ARM::t2LDMDB_UPD, Convert__Reg1_2__Tie0_3_3__CondCode2_0__RegList1_4, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 435 /* ldmdb */, ARM::sysLDMDB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList, MCK__94_ }, },
  { 441 /* ldmib */, ARM::LDMIB, Convert__Reg1_1__CondCode2_0__RegList1_2, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 441 /* ldmib */, ARM::LDMIB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 441 /* ldmib */, ARM::sysLDMIB, Convert__Reg1_1__CondCode2_0__RegList1_2, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList, MCK__94_ }, },
  { 441 /* ldmib */, ARM::sysLDMIB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList, MCK__94_ }, },
  { 447 /* ldr */, ARM::tLDRpci, Convert__Reg1_1__ThumbMemPC1_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_ThumbMemPC }, },
  { 447 /* ldr */, ARM::tLDRConstPool, Convert__Reg1_1__ConstPoolAsmImm1_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_ConstPoolAsmImm }, },
  { 447 /* ldr */, ARM::tLDRi, Convert__Reg1_1__MemThumbRIs42_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRIs4 }, },
  { 447 /* ldr */, ARM::tLDRr, Convert__Reg1_1__MemThumbRR2_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRR }, },
  { 447 /* ldr */, ARM::tLDRspi, Convert__Reg1_1__MemThumbSPI2_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbSPI }, },
  { 447 /* ldr */, ARM::t2LDRpci, Convert__Reg1_1__Imm1_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_Imm }, },
  { 447 /* ldr */, ARM::LDRi12, Convert__Reg1_1__MemImm12Offset2_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemImm12Offset }, },
  { 447 /* ldr */, ARM::t2LDRi8, Convert__Reg1_1__MemNegImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemNegImm8Offset }, },
  { 447 /* ldr */, ARM::LDRrs, Convert__Reg1_1__MemRegOffset3_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemRegOffset }, },
  { 447 /* ldr */, ARM::LDRConstPool, Convert__Reg1_1__ConstPoolAsmImm1_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_ConstPoolAsmImm }, },
  { 447 /* ldr */, ARM::t2LDRConstPool, Convert__Reg1_1__ConstPoolAsmImm1_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_ConstPoolAsmImm }, },
  { 447 /* ldr */, ARM::t2LDRi12, Convert__Reg1_1__MemUImm12Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemUImm12Offset }, },
  { 447 /* ldr */, ARM::t2LDRs, Convert__Reg1_1__T2MemRegOffset3_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_T2MemRegOffset }, },
  { 447 /* ldr */, ARM::t2LDRpcrel, Convert__Reg1_1__MemPCRelImm121_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemPCRelImm12 }, },
  { 447 /* ldr */, ARM::t2LDRConstPool, Convert__Reg1_2__ConstPoolAsmImm1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_ConstPoolAsmImm }, },
  { 447 /* ldr */, ARM::t2LDRpci, Convert__Reg1_2__Imm1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_Imm }, },
  { 447 /* ldr */, ARM::t2LDRi12, Convert__Reg1_2__MemUImm12Offset2_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemUImm12Offset }, },
  { 447 /* ldr */, ARM::t2LDRs, Convert__Reg1_2__T2MemRegOffset3_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_T2MemRegOffset }, },
  { 447 /* ldr */, ARM::t2LDRpcrel, Convert__Reg1_2__MemPCRelImm121_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemPCRelImm12 }, },
  { 447 /* ldr */, ARM::LDR_PRE_IMM, Convert__Reg1_1__imm_95_0__MemImm12Offset2_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemImm12Offset, MCK__EXCLAIM_ }, },
  { 447 /* ldr */, ARM::t2LDR_PRE, Convert__Reg1_1__imm_95_0__MemImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 447 /* ldr */, ARM::LDR_POST_IMM, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__AM2OffsetImm2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM2OffsetImm }, },
  { 447 /* ldr */, ARM::t2LDR_POST, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__Imm1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_Imm }, },
  { 447 /* ldr */, ARM::LDR_POST_REG, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxRegShifted2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxRegShifted }, },
  { 447 /* ldr */, ARM::LDR_PRE_REG, Convert__Reg1_1__imm_95_0__MemRegOffset3_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemRegOffset, MCK__EXCLAIM_ }, },
  { 451 /* ldrb */, ARM::tLDRBi, Convert__Reg1_1__MemThumbRIs12_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRIs1 }, },
  { 451 /* ldrb */, ARM::tLDRBr, Convert__Reg1_1__MemThumbRR2_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRR }, },
  { 451 /* ldrb */, ARM::t2LDRBpci, Convert__Reg1_1__Imm1_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Imm }, },
  { 451 /* ldrb */, ARM::t2LDRBi12, Convert__Reg1_1__MemUImm12Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemUImm12Offset }, },
  { 451 /* ldrb */, ARM::t2LDRBs, Convert__Reg1_1__T2MemRegOffset3_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_T2MemRegOffset }, },
  { 451 /* ldrb */, ARM::LDRBi12, Convert__Reg1_1__MemImm12Offset2_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_MemImm12Offset }, },
  { 451 /* ldrb */, ARM::t2LDRBi8, Convert__Reg1_1__MemNegImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_MemNegImm8Offset }, },
  { 451 /* ldrb */, ARM::LDRBrs, Convert__Reg1_1__MemRegOffset3_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_MemRegOffset }, },
  { 451 /* ldrb */, ARM::t2LDRBpcrel, Convert__Reg1_1__MemPCRelImm121_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_MemPCRelImm12 }, },
  { 451 /* ldrb */, ARM::t2LDRBpci, Convert__Reg1_2__Imm1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_Imm }, },
  { 451 /* ldrb */, ARM::t2LDRBi12, Convert__Reg1_2__MemUImm12Offset2_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_MemUImm12Offset }, },
  { 451 /* ldrb */, ARM::t2LDRBs, Convert__Reg1_2__T2MemRegOffset3_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_T2MemRegOffset }, },
  { 451 /* ldrb */, ARM::t2LDRBpcrel, Convert__Reg1_2__MemPCRelImm121_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_MemPCRelImm12 }, },
  { 451 /* ldrb */, ARM::LDRB_PRE_IMM, Convert__Reg1_1__imm_95_0__MemImm12Offset2_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemImm12Offset, MCK__EXCLAIM_ }, },
  { 451 /* ldrb */, ARM::t2LDRB_PRE, Convert__Reg1_1__imm_95_0__MemImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 451 /* ldrb */, ARM::LDRB_POST_IMM, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__AM2OffsetImm2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM2OffsetImm }, },
  { 451 /* ldrb */, ARM::t2LDRB_POST, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__Imm1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_Imm }, },
  { 451 /* ldrb */, ARM::LDRB_POST_REG, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxRegShifted2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxRegShifted }, },
  { 451 /* ldrb */, ARM::LDRB_PRE_REG, Convert__Reg1_1__imm_95_0__MemRegOffset3_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemRegOffset, MCK__EXCLAIM_ }, },
  { 456 /* ldrbt */, ARM::t2LDRBT, Convert__Reg1_1__MemPosImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemPosImm8Offset }, },
  { 456 /* ldrbt */, ARM::LDRBT_POST, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 456 /* ldrbt */, ARM::LDRBT_POST_IMM, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__AM2OffsetImm2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM2OffsetImm }, },
  { 456 /* ldrbt */, ARM::LDRBT_POST_REG, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxRegShifted2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxRegShifted }, },
  { 462 /* ldrd */, ARM::t2LDRDi8, Convert__Reg1_1__Reg1_2__MemImm8s4Offset2_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemImm8s4Offset }, },
  { 462 /* ldrd */, ARM::LDRD, Convert__Reg1_1__Reg1_2__AddrMode33_3__CondCode2_0, Feature_IsARM|Feature_HasV5TE, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_AddrMode3 }, },
  { 462 /* ldrd */, ARM::t2LDRD_PRE, Convert__Reg1_1__Reg1_2__imm_95_0__MemImm8s4Offset2_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemImm8s4Offset, MCK__EXCLAIM_ }, },
  { 462 /* ldrd */, ARM::t2LDRD_POST, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__Tie2_4_4__Imm1_4__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemNoOffset, MCK_Imm }, },
  { 462 /* ldrd */, ARM::LDRD_PRE, Convert__Reg1_1__Reg1_2__imm_95_0__AddrMode33_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_AddrMode3, MCK__EXCLAIM_ }, },
  { 462 /* ldrd */, ARM::LDRD_POST, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__Tie2_4_4__AM3Offset2_4__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_MemNoOffset, MCK_AM3Offset }, },
  { 467 /* ldrex */, ARM::t2LDREX, Convert__Reg1_1__MemImm0_1020s4Offset2_2__CondCode2_0, Feature_IsThumb|Feature_HasV8MBaseline, { MCK_CondCode, MCK_rGPR, MCK_MemImm0_1020s4Offset }, },
  { 467 /* ldrex */, ARM::LDREX, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 473 /* ldrexb */, ARM::t2LDREXB, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsThumb|Feature_HasV8MBaseline, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset }, },
  { 473 /* ldrexb */, ARM::LDREXB, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 480 /* ldrexd */, ARM::LDREXD, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRPair, MCK_MemNoOffset }, },
  { 480 /* ldrexd */, ARM::t2LDREXD, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, Feature_IsThumb2|Feature_IsNotMClass, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemNoOffset }, },
  { 487 /* ldrexh */, ARM::t2LDREXH, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsThumb|Feature_HasV8MBaseline, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset }, },
  { 487 /* ldrexh */, ARM::LDREXH, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 494 /* ldrh */, ARM::tLDRHi, Convert__Reg1_1__MemThumbRIs22_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRIs2 }, },
  { 494 /* ldrh */, ARM::tLDRHr, Convert__Reg1_1__MemThumbRR2_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRR }, },
  { 494 /* ldrh */, ARM::t2LDRHpci, Convert__Reg1_1__Imm1_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Imm }, },
  { 494 /* ldrh */, ARM::t2LDRHi12, Convert__Reg1_1__MemUImm12Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemUImm12Offset }, },
  { 494 /* ldrh */, ARM::t2LDRHs, Convert__Reg1_1__T2MemRegOffset3_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_T2MemRegOffset }, },
  { 494 /* ldrh */, ARM::t2LDRHi8, Convert__Reg1_1__MemNegImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_MemNegImm8Offset }, },
  { 494 /* ldrh */, ARM::t2LDRHpcrel, Convert__Reg1_1__MemPCRelImm121_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_MemPCRelImm12 }, },
  { 494 /* ldrh */, ARM::LDRH, Convert__Reg1_1__AddrMode33_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_AddrMode3 }, },
  { 494 /* ldrh */, ARM::t2LDRHpci, Convert__Reg1_2__Imm1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_Imm }, },
  { 494 /* ldrh */, ARM::t2LDRHi12, Convert__Reg1_2__MemUImm12Offset2_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_MemUImm12Offset }, },
  { 494 /* ldrh */, ARM::t2LDRHs, Convert__Reg1_2__T2MemRegOffset3_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_T2MemRegOffset }, },
  { 494 /* ldrh */, ARM::t2LDRHpcrel, Convert__Reg1_2__MemPCRelImm121_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_MemPCRelImm12 }, },
  { 494 /* ldrh */, ARM::LDRH_PRE, Convert__Reg1_1__imm_95_0__AddrMode33_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_AddrMode3, MCK__EXCLAIM_ }, },
  { 494 /* ldrh */, ARM::t2LDRH_PRE, Convert__Reg1_1__imm_95_0__MemImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 494 /* ldrh */, ARM::LDRH_POST, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__AM3Offset2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM3Offset }, },
  { 494 /* ldrh */, ARM::t2LDRH_POST, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__Imm1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_Imm }, },
  { 499 /* ldrht */, ARM::t2LDRHT, Convert__Reg1_1__MemPosImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemPosImm8Offset }, },
  { 499 /* ldrht */, ARM::LDRHTr, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxReg2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_MemNoOffset, MCK_PostIdxReg }, },
  { 499 /* ldrht */, ARM::LDRHTi, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxImm81_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxImm8 }, },
  { 505 /* ldrsb */, ARM::tLDRSB, Convert__Reg1_1__MemThumbRR2_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRR }, },
  { 505 /* ldrsb */, ARM::t2LDRSBpci, Convert__Reg1_1__Imm1_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Imm }, },
  { 505 /* ldrsb */, ARM::t2LDRSBi12, Convert__Reg1_1__MemUImm12Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemUImm12Offset }, },
  { 505 /* ldrsb */, ARM::t2LDRSBs, Convert__Reg1_1__T2MemRegOffset3_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_T2MemRegOffset }, },
  { 505 /* ldrsb */, ARM::t2LDRSBi8, Convert__Reg1_1__MemNegImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_MemNegImm8Offset }, },
  { 505 /* ldrsb */, ARM::t2LDRSBpcrel, Convert__Reg1_1__MemPCRelImm121_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_MemPCRelImm12 }, },
  { 505 /* ldrsb */, ARM::LDRSB, Convert__Reg1_1__AddrMode33_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_AddrMode3 }, },
  { 505 /* ldrsb */, ARM::t2LDRSBpci, Convert__Reg1_2__Imm1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_Imm }, },
  { 505 /* ldrsb */, ARM::t2LDRSBi12, Convert__Reg1_2__MemUImm12Offset2_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_MemUImm12Offset }, },
  { 505 /* ldrsb */, ARM::t2LDRSBs, Convert__Reg1_2__T2MemRegOffset3_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_T2MemRegOffset }, },
  { 505 /* ldrsb */, ARM::t2LDRSBpcrel, Convert__Reg1_2__MemPCRelImm121_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_MemPCRelImm12 }, },
  { 505 /* ldrsb */, ARM::LDRSB_PRE, Convert__Reg1_1__imm_95_0__AddrMode33_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_AddrMode3, MCK__EXCLAIM_ }, },
  { 505 /* ldrsb */, ARM::t2LDRSB_PRE, Convert__Reg1_1__imm_95_0__MemImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 505 /* ldrsb */, ARM::LDRSB_POST, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__AM3Offset2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM3Offset }, },
  { 505 /* ldrsb */, ARM::t2LDRSB_POST, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__Imm1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_Imm }, },
  { 511 /* ldrsbt */, ARM::t2LDRSBT, Convert__Reg1_1__MemPosImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemPosImm8Offset }, },
  { 511 /* ldrsbt */, ARM::LDRSBTr, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxReg2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_MemNoOffset, MCK_PostIdxReg }, },
  { 511 /* ldrsbt */, ARM::LDRSBTi, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxImm81_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxImm8 }, },
  { 518 /* ldrsh */, ARM::tLDRSH, Convert__Reg1_1__MemThumbRR2_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRR }, },
  { 518 /* ldrsh */, ARM::t2LDRSHpci, Convert__Reg1_1__Imm1_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Imm }, },
  { 518 /* ldrsh */, ARM::t2LDRSHi12, Convert__Reg1_1__MemUImm12Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemUImm12Offset }, },
  { 518 /* ldrsh */, ARM::t2LDRSHs, Convert__Reg1_1__T2MemRegOffset3_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_T2MemRegOffset }, },
  { 518 /* ldrsh */, ARM::t2LDRSHi8, Convert__Reg1_1__MemNegImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_MemNegImm8Offset }, },
  { 518 /* ldrsh */, ARM::t2LDRSHpcrel, Convert__Reg1_1__MemPCRelImm121_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_MemPCRelImm12 }, },
  { 518 /* ldrsh */, ARM::LDRSH, Convert__Reg1_1__AddrMode33_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_AddrMode3 }, },
  { 518 /* ldrsh */, ARM::t2LDRSHpci, Convert__Reg1_2__Imm1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_Imm }, },
  { 518 /* ldrsh */, ARM::t2LDRSHi12, Convert__Reg1_2__MemUImm12Offset2_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_MemUImm12Offset }, },
  { 518 /* ldrsh */, ARM::t2LDRSHs, Convert__Reg1_2__T2MemRegOffset3_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_T2MemRegOffset }, },
  { 518 /* ldrsh */, ARM::t2LDRSHpcrel, Convert__Reg1_2__MemPCRelImm121_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_MemPCRelImm12 }, },
  { 518 /* ldrsh */, ARM::LDRSH_PRE, Convert__Reg1_1__imm_95_0__AddrMode33_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_AddrMode3, MCK__EXCLAIM_ }, },
  { 518 /* ldrsh */, ARM::t2LDRSH_PRE, Convert__Reg1_1__imm_95_0__MemImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 518 /* ldrsh */, ARM::LDRSH_POST, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__AM3Offset2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM3Offset }, },
  { 518 /* ldrsh */, ARM::t2LDRSH_POST, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__Imm1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_Imm }, },
  { 524 /* ldrsht */, ARM::t2LDRSHT, Convert__Reg1_1__MemPosImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemPosImm8Offset }, },
  { 524 /* ldrsht */, ARM::LDRSHTr, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxReg2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_MemNoOffset, MCK_PostIdxReg }, },
  { 524 /* ldrsht */, ARM::LDRSHTi, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxImm81_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxImm8 }, },
  { 531 /* ldrt */, ARM::t2LDRT, Convert__Reg1_1__MemPosImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemPosImm8Offset }, },
  { 531 /* ldrt */, ARM::LDRT_POST, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 531 /* ldrt */, ARM::LDRT_POST_IMM, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__AM2OffsetImm2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM2OffsetImm }, },
  { 531 /* ldrt */, ARM::LDRT_POST_REG, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxRegShifted2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxRegShifted }, },
  { 536 /* lsl */, ARM::tLSLrr, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 536 /* lsl */, ARM::tLSLri, Convert__Reg1_2__CCOut1_0__Reg1_2__Imm0_311_3__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_Imm0_31 }, },
  { 536 /* lsl */, ARM::t2LSLrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 536 /* lsl */, ARM::t2LSLri, Convert__Reg1_2__Reg1_2__Imm1_311_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_Imm1_31 }, },
  { 536 /* lsl */, ARM::LSLr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 536 /* lsl */, ARM::LSLi, Convert__Reg1_2__Reg1_2__Imm0_311_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_Imm0_31 }, },
  { 536 /* lsl */, ARM::t2LSLrr, Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 536 /* lsl */, ARM::t2LSLri, Convert__Reg1_3__Reg1_3__Imm1_311_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_Imm1_31 }, },
  { 536 /* lsl */, ARM::tLSLri, Convert__Reg1_2__CCOut1_0__Reg1_3__Imm0_311_4__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR, MCK_Imm0_31 }, },
  { 536 /* lsl */, ARM::t2LSLrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 536 /* lsl */, ARM::t2LSLri, Convert__Reg1_2__Reg1_3__Imm1_311_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_Imm1_31 }, },
  { 536 /* lsl */, ARM::t2MOVr, Convert__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK__35_0 }, },
  { 536 /* lsl */, ARM::LSLr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 536 /* lsl */, ARM::LSLi, Convert__Reg1_2__Reg1_3__Imm0_311_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_Imm0_31 }, },
  { 536 /* lsl */, ARM::t2LSLrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 536 /* lsl */, ARM::t2LSLri, Convert__Reg1_3__Reg1_4__Imm1_311_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_Imm1_31 }, },
  { 536 /* lsl */, ARM::t2MOVr, Convert__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_GPRnopc, MCK__35_0 }, },
  { 540 /* lsr */, ARM::tLSRrr, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 540 /* lsr */, ARM::tLSRri, Convert__Reg1_2__CCOut1_0__Reg1_2__ImmThumbSR1_3__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_ImmThumbSR }, },
  { 540 /* lsr */, ARM::t2LSRrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 540 /* lsr */, ARM::t2LSRri, Convert__Reg1_2__Reg1_2__ImmThumbSR1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_ImmThumbSR }, },
  { 540 /* lsr */, ARM::LSRr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 540 /* lsr */, ARM::LSRi, Convert__Reg1_2__Reg1_2__Imm0_321_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_Imm0_32 }, },
  { 540 /* lsr */, ARM::t2LSRrr, Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 540 /* lsr */, ARM::t2LSRri, Convert__Reg1_3__Reg1_3__ImmThumbSR1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_ImmThumbSR }, },
  { 540 /* lsr */, ARM::tLSRri, Convert__Reg1_2__CCOut1_0__Reg1_3__ImmThumbSR1_4__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR, MCK_ImmThumbSR }, },
  { 540 /* lsr */, ARM::t2LSRrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 540 /* lsr */, ARM::t2LSRri, Convert__Reg1_2__Reg1_3__ImmThumbSR1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_ImmThumbSR }, },
  { 540 /* lsr */, ARM::LSRr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 540 /* lsr */, ARM::LSRi, Convert__Reg1_2__Reg1_3__Imm0_321_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_Imm0_32 }, },
  { 540 /* lsr */, ARM::t2LSRrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 540 /* lsr */, ARM::t2LSRri, Convert__Reg1_3__Reg1_4__ImmThumbSR1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_ImmThumbSR }, },
  { 544 /* mcr */, ARM::MCR, Convert__CoprocNum1_1__Imm0_71_2__Reg1_3__CoprocReg1_4__CoprocReg1_5__imm_95_0__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPR, MCK_CoprocReg, MCK_CoprocReg }, },
  { 544 /* mcr */, ARM::t2MCR, Convert__CoprocNum1_1__Imm0_71_2__Reg1_3__CoprocReg1_4__CoprocReg1_5__imm_95_0__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPR, MCK_CoprocReg, MCK_CoprocReg }, },
  { 544 /* mcr */, ARM::MCR, Convert__CoprocNum1_1__Imm0_71_2__Reg1_3__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPR, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 544 /* mcr */, ARM::t2MCR, Convert__CoprocNum1_1__Imm0_71_2__Reg1_3__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPR, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 548 /* mcr2 */, ARM::MCR2, Convert__CoprocNum1_0__Imm0_71_1__Reg1_2__CoprocReg1_3__CoprocReg1_4__imm_95_0, Feature_IsARM, { MCK_CoprocNum, MCK_Imm0_7, MCK_GPR, MCK_CoprocReg, MCK_CoprocReg }, },
  { 548 /* mcr2 */, ARM::t2MCR2, Convert__CoprocNum1_1__Imm0_71_2__Reg1_3__CoprocReg1_4__CoprocReg1_5__imm_95_0__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPR, MCK_CoprocReg, MCK_CoprocReg }, },
  { 548 /* mcr2 */, ARM::MCR2, Convert__CoprocNum1_0__Imm0_71_1__Reg1_2__CoprocReg1_3__CoprocReg1_4__Imm0_71_5, Feature_IsARM|Feature_PreV8, { MCK_CoprocNum, MCK_Imm0_7, MCK_GPR, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 548 /* mcr2 */, ARM::t2MCR2, Convert__CoprocNum1_1__Imm0_71_2__Reg1_3__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0, Feature_IsThumb2|Feature_PreV8, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPR, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 553 /* mcrr */, ARM::MCRR, Convert__CoprocNum1_1__Imm0_151_2__Reg1_3__Reg1_4__CoprocReg1_5__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_15, MCK_GPRnopc, MCK_GPRnopc, MCK_CoprocReg }, },
  { 553 /* mcrr */, ARM::t2MCRR, Convert__CoprocNum1_1__Imm0_151_2__Reg1_3__Reg1_4__CoprocReg1_5__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_15, MCK_GPR, MCK_GPR, MCK_CoprocReg }, },
  { 558 /* mcrr2 */, ARM::MCRR2, Convert__CoprocNum1_0__Imm0_151_1__Reg1_2__Reg1_3__CoprocReg1_4, Feature_IsARM|Feature_PreV8, { MCK_CoprocNum, MCK_Imm0_15, MCK_GPRnopc, MCK_GPRnopc, MCK_CoprocReg }, },
  { 558 /* mcrr2 */, ARM::t2MCRR2, Convert__CoprocNum1_1__Imm0_151_2__Reg1_3__Reg1_4__CoprocReg1_5__CondCode2_0, Feature_IsThumb2|Feature_PreV8, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_15, MCK_GPR, MCK_GPR, MCK_CoprocReg }, },
  { 564 /* mla */, ARM::t2MLA, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 564 /* mla */, ARM::MLA, Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, Feature_IsARM|Feature_HasV6, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 564 /* mla */, ARM::MLA, Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 568 /* mls */, ARM::t2MLS, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 568 /* mls */, ARM::MLS, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsARM|Feature_HasV6T2, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 572 /* mov */, ARM::MOVPCLR, Convert__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_PC, MCK_LR }, },
  { 572 /* mov */, ARM::t2MOVi16, Convert__Reg1_1__Imm256_65535Expr1_2__CondCode2_0, Feature_IsThumb|Feature_HasV8MBaseline, { MCK_CondCode, MCK_rGPR, MCK_Imm256_65535Expr }, },
  { 572 /* mov */, ARM::t2MOVsi, Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_RegShiftedImm }, },
  { 572 /* mov */, ARM::t2MOVsr, Convert__Reg1_1__RegShiftedReg3_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_RegShiftedReg }, },
  { 572 /* mov */, ARM::t2MOVi, Convert__Reg1_1__T2SOImm1_2__CondCode2_0__reg0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 572 /* mov */, ARM::t2MVNi, Convert__Reg1_1__T2SOImmNot1_2__CondCode2_0__reg0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CondCode, MCK_rGPR, MCK_T2SOImmNot }, },
  { 572 /* mov */, ARM::tMOVr, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 572 /* mov */, ARM::MOVi16, Convert__Reg1_1__Imm0_65535Expr1_2__CondCode2_0, Feature_IsARM|Feature_HasV6T2, { MCK_CondCode, MCK_GPR, MCK_Imm0_65535Expr }, },
  { 572 /* mov */, ARM::MOVr_TC, Convert__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_tcGPR, MCK_tcGPR }, },
  { 572 /* mov */, ARM::tMOVi8, Convert__Reg1_2__CCOut1_0__Imm0_2551_3__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_Imm0_255 }, },
  { 572 /* mov */, ARM::MVNi, Convert__Reg1_2__ModImmNot1_3__CondCode2_1__CCOut1_0, Feature_IsARM|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_ModImmNot }, },
  { 572 /* mov */, ARM::MOVsr, Convert__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedReg }, },
  { 572 /* mov */, ARM::MOVr, Convert__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 572 /* mov */, ARM::MOVi, Convert__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 572 /* mov */, ARM::MOVsi, Convert__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 572 /* mov */, ARM::t2MOVsi, Convert__Reg1_2__RegShiftedImm2_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_RegShiftedImm }, },
  { 572 /* mov */, ARM::t2MOVsr, Convert__Reg1_2__RegShiftedReg3_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_RegShiftedReg }, },
  { 572 /* mov */, ARM::t2MOVi, Convert__Reg1_2__T2SOImm1_3__CondCode2_0__reg0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImm }, },
  { 572 /* mov */, ARM::t2MOVr, Convert__Reg1_2__Reg1_3__CondCode2_0__reg0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_GPRnopc }, },
  { 572 /* mov */, ARM::t2MOVi, Convert__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImm }, },
  { 572 /* mov */, ARM::t2MOVr, Convert__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_GPRnopc }, },
  { 576 /* movs */, ARM::tMOVSr, Convert__Reg1_0__Reg1_1, Feature_IsThumb, { MCK_tGPR, MCK_tGPR }, },
  { 576 /* movs */, ARM::tMOVi8, Convert__Reg1_0__regCPSR__Imm0_2551_1__imm_95_14__imm_95_0, Feature_IsThumb, { MCK_tGPR, MCK_Imm0_255 }, },
  { 576 /* movs */, ARM::t2MOVSsi, Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_RegShiftedImm }, },
  { 576 /* movs */, ARM::t2MOVSsr, Convert__Reg1_1__RegShiftedReg3_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_RegShiftedReg }, },
  { 576 /* movs */, ARM::t2MOVi, Convert__Reg1_1__T2SOImm1_2__CondCode2_0__regCPSR, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 576 /* movs */, ARM::t2MOVr, Convert__Reg1_1__Reg1_2__CondCode2_0__regCPSR, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 576 /* movs */, ARM::t2MOVSsi, Convert__Reg1_2__RegShiftedImm2_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_RegShiftedImm }, },
  { 576 /* movs */, ARM::t2MOVSsr, Convert__Reg1_2__RegShiftedReg3_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_RegShiftedReg }, },
  { 576 /* movs */, ARM::t2MOVi, Convert__Reg1_2__T2SOImm1_3__CondCode2_0__regCPSR, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImm }, },
  { 576 /* movs */, ARM::t2MOVr, Convert__Reg1_2__Reg1_3__CondCode2_0__regCPSR, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_GPRnopc }, },
  { 581 /* movt */, ARM::t2MOVTi16, Convert__Reg1_1__Tie0_1_1__Imm0_65535Expr1_2__CondCode2_0, Feature_IsThumb|Feature_HasV8MBaseline, { MCK_CondCode, MCK_rGPR, MCK_Imm0_65535Expr }, },
  { 581 /* movt */, ARM::MOVTi16, Convert__Reg1_1__Tie0_1_1__Imm0_65535Expr1_2__CondCode2_0, Feature_IsARM|Feature_HasV6T2, { MCK_CondCode, MCK_GPRnopc, MCK_Imm0_65535Expr }, },
  { 586 /* movw */, ARM::t2MOVi16, Convert__Reg1_1__Imm0_65535Expr1_2__CondCode2_0, Feature_IsThumb|Feature_HasV8MBaseline, { MCK_CondCode, MCK_rGPR, MCK_Imm0_65535Expr }, },
  { 586 /* movw */, ARM::MOVi16, Convert__Reg1_1__Imm0_65535Expr1_2__CondCode2_0, Feature_IsARM|Feature_HasV6T2, { MCK_CondCode, MCK_GPR, MCK_Imm0_65535Expr }, },
  { 591 /* mrc */, ARM::MRC, Convert__Reg1_3__CoprocNum1_1__Imm0_71_2__CoprocReg1_4__CoprocReg1_5__imm_95_0__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPRwithAPSR, MCK_CoprocReg, MCK_CoprocReg }, },
  { 591 /* mrc */, ARM::t2MRC, Convert__Reg1_3__CoprocNum1_1__Imm0_71_2__CoprocReg1_4__CoprocReg1_5__imm_95_0__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPRwithAPSR, MCK_CoprocReg, MCK_CoprocReg }, },
  { 591 /* mrc */, ARM::MRC, Convert__Reg1_3__CoprocNum1_1__Imm0_71_2__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPRwithAPSR, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 591 /* mrc */, ARM::t2MRC, Convert__Reg1_3__CoprocNum1_1__Imm0_71_2__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPRwithAPSR, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 595 /* mrc2 */, ARM::MRC2, Convert__Reg1_2__CoprocNum1_0__Imm0_71_1__CoprocReg1_3__CoprocReg1_4__imm_95_0, Feature_IsARM, { MCK_CoprocNum, MCK_Imm0_7, MCK_GPRwithAPSR, MCK_CoprocReg, MCK_CoprocReg }, },
  { 595 /* mrc2 */, ARM::t2MRC2, Convert__Reg1_3__CoprocNum1_1__Imm0_71_2__CoprocReg1_4__CoprocReg1_5__imm_95_0__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPRwithAPSR, MCK_CoprocReg, MCK_CoprocReg }, },
  { 595 /* mrc2 */, ARM::MRC2, Convert__Reg1_2__CoprocNum1_0__Imm0_71_1__CoprocReg1_3__CoprocReg1_4__Imm0_71_5, Feature_IsARM|Feature_PreV8, { MCK_CoprocNum, MCK_Imm0_7, MCK_GPRwithAPSR, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 595 /* mrc2 */, ARM::t2MRC2, Convert__Reg1_3__CoprocNum1_1__Imm0_71_2__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0, Feature_IsThumb2|Feature_PreV8, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPRwithAPSR, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 600 /* mrrc */, ARM::MRRC, Convert__Reg1_3__Reg1_4__CoprocNum1_1__Imm0_151_2__CoprocReg1_5__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_15, MCK_GPRnopc, MCK_GPRnopc, MCK_CoprocReg }, },
  { 600 /* mrrc */, ARM::t2MRRC, Convert__Reg1_3__Reg1_4__CoprocNum1_1__Imm0_151_2__CoprocReg1_5__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_15, MCK_GPR, MCK_GPR, MCK_CoprocReg }, },
  { 605 /* mrrc2 */, ARM::MRRC2, Convert__Reg1_2__Reg1_3__CoprocNum1_0__Imm0_151_1__CoprocReg1_4, Feature_IsARM|Feature_PreV8, { MCK_CoprocNum, MCK_Imm0_15, MCK_GPRnopc, MCK_GPRnopc, MCK_CoprocReg }, },
  { 605 /* mrrc2 */, ARM::t2MRRC2, Convert__Reg1_3__Reg1_4__CoprocNum1_1__Imm0_151_2__CoprocReg1_5__CondCode2_0, Feature_IsThumb2|Feature_PreV8, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_15, MCK_GPR, MCK_GPR, MCK_CoprocReg }, },
  { 611 /* mrs */, ARM::t2MRSbanked, Convert__Reg1_1__BankedReg1_2__CondCode2_0, Feature_IsThumb|Feature_HasVirtualization, { MCK_CondCode, MCK_rGPR, MCK_BankedReg }, },
  { 611 /* mrs */, ARM::t2MRS_M, Convert__Reg1_1__MSRMask1_2__CondCode2_0, Feature_IsThumb|Feature_IsMClass, { MCK_CondCode, MCK_rGPR, MCK_MSRMask }, },
  { 611 /* mrs */, ARM::MRS, Convert__Reg1_1__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_APSR }, },
  { 611 /* mrs */, ARM::MRS, Convert__Reg1_1__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_CCR }, },
  { 611 /* mrs */, ARM::MRSsys, Convert__Reg1_1__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_SPSR }, },
  { 611 /* mrs */, ARM::MRSbanked, Convert__Reg1_1__BankedReg1_2__CondCode2_0, Feature_IsARM|Feature_HasVirtualization, { MCK_CondCode, MCK_GPRnopc, MCK_BankedReg }, },
  { 611 /* mrs */, ARM::t2MRS_AR, Convert__Reg1_1__CondCode2_0, Feature_IsThumb2|Feature_IsNotMClass, { MCK_CondCode, MCK_GPR, MCK_APSR }, },
  { 611 /* mrs */, ARM::t2MRS_AR, Convert__Reg1_1__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_CCR }, },
  { 611 /* mrs */, ARM::t2MRSsys_AR, Convert__Reg1_1__CondCode2_0, Feature_IsThumb2|Feature_IsNotMClass, { MCK_CondCode, MCK_GPR, MCK_SPSR }, },
  { 615 /* msr */, ARM::t2MSRbanked, Convert__BankedReg1_1__Reg1_2__CondCode2_0, Feature_IsThumb|Feature_HasVirtualization, { MCK_CondCode, MCK_BankedReg, MCK_rGPR }, },
  { 615 /* msr */, ARM::MSRbanked, Convert__BankedReg1_1__Reg1_2__CondCode2_0, Feature_IsARM|Feature_HasVirtualization, { MCK_CondCode, MCK_BankedReg, MCK_GPRnopc }, },
  { 615 /* msr */, ARM::t2MSR_AR, Convert__MSRMask1_1__Reg1_2__CondCode2_0, Feature_IsThumb2|Feature_IsNotMClass, { MCK_CondCode, MCK_MSRMask, MCK_rGPR }, },
  { 615 /* msr */, ARM::t2MSR_M, Convert__MSRMask1_1__Reg1_2__CondCode2_0, Feature_IsThumb|Feature_IsMClass, { MCK_CondCode, MCK_MSRMask, MCK_rGPR }, },
  { 615 /* msr */, ARM::MSR, Convert__MSRMask1_1__Reg1_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_MSRMask, MCK_GPR }, },
  { 615 /* msr */, ARM::MSRi, Convert__MSRMask1_1__ModImm1_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_MSRMask, MCK_ModImm }, },
  { 619 /* mul */, ARM::t2MUL, Convert__Reg1_1__Reg1_2__Reg1_1__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 619 /* mul */, ARM::tMUL, ConvertCustom_cvtThumbMultiply, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 619 /* mul */, ARM::MUL, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsARM|Feature_HasV6, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 619 /* mul */, ARM::t2MUL, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 619 /* mul */, ARM::tMUL, ConvertCustom_cvtThumbMultiply, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR, MCK_tGPR }, },
  { 619 /* mul */, ARM::MUL, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsARM|Feature_HasV6, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 619 /* mul */, ARM::MUL, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 623 /* mvn */, ARM::tMVN, Convert__Reg1_2__CCOut1_0__Reg1_3__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 623 /* mvn */, ARM::t2MVNr, Convert__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 623 /* mvn */, ARM::MOVi, Convert__Reg1_2__ModImmNot1_3__CondCode2_1__CCOut1_0, Feature_IsARM|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_ModImmNot }, },
  { 623 /* mvn */, ARM::t2MVNs, Convert__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_RegShiftedImm }, },
  { 623 /* mvn */, ARM::t2MVNi, Convert__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 623 /* mvn */, ARM::t2MOVi, Convert__Reg1_2__T2SOImmNot1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImmNot }, },
  { 623 /* mvn */, ARM::MVNsr, Convert__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedReg }, },
  { 623 /* mvn */, ARM::MVNr, Convert__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 623 /* mvn */, ARM::MVNi, Convert__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 623 /* mvn */, ARM::MVNsi, Convert__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 623 /* mvn */, ARM::t2MVNr, Convert__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 623 /* mvn */, ARM::t2MVNs, Convert__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_RegShiftedImm }, },
  { 623 /* mvn */, ARM::t2MVNi, Convert__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImm }, },
  { 627 /* neg */, ARM::tRSB, Convert__Reg1_2__CCOut1_0__Reg1_3__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 627 /* neg */, ARM::t2RSBri, Convert__Reg1_2__Reg1_3__imm_95_0__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 627 /* neg */, ARM::RSBri, Convert__Reg1_2__Reg1_3__imm_95_0__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 631 /* nop */, ARM::tMOVr, Convert__regR8__regR8__imm_95_14__imm_95_0, Feature_IsThumb, {  }, },
  { 631 /* nop */, ARM::HINT, Convert__imm_95_0__CondCode2_0, Feature_IsARM|Feature_HasV6K, { MCK_CondCode }, },
  { 631 /* nop */, ARM::tHINT, Convert__imm_95_0__CondCode2_0, Feature_IsThumb|Feature_HasV6M, { MCK_CondCode }, },
  { 631 /* nop */, ARM::MOVr, Convert__regR0__regR0__CondCode2_0__reg0, Feature_IsARM, { MCK_CondCode }, },
  { 631 /* nop */, ARM::t2HINT, Convert__imm_95_0__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w }, },
  { 635 /* orn */, ARM::t2ORNrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 635 /* orn */, ARM::t2ORNrs, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_RegShiftedImm }, },
  { 635 /* orn */, ARM::t2ORNri, Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 635 /* orn */, ARM::t2ORRri, Convert__Reg1_2__Reg1_2__T2SOImmNot1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImmNot }, },
  { 635 /* orn */, ARM::t2ORNrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 635 /* orn */, ARM::t2ORNrs, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 635 /* orn */, ARM::t2ORNri, Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 635 /* orn */, ARM::t2ORRri, Convert__Reg1_2__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImmNot }, },
  { 639 /* orr */, ARM::tORR, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 639 /* orr */, ARM::t2ORRrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 639 /* orr */, ARM::t2ORRrs, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_RegShiftedImm }, },
  { 639 /* orr */, ARM::t2ORRri, Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 639 /* orr */, ARM::t2ORNri, Convert__Reg1_2__Reg1_2__T2SOImmNot1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImmNot }, },
  { 639 /* orr */, ARM::ORRrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 639 /* orr */, ARM::ORRri, Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 639 /* orr */, ARM::ORRrsi, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 639 /* orr */, ARM::ORRrsr, Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedReg }, },
  { 639 /* orr */, ARM::t2ORRrr, Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 639 /* orr */, ARM::t2ORRrs, Convert__Reg1_3__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_RegShiftedImm }, },
  { 639 /* orr */, ARM::t2ORRri, Convert__Reg1_3__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImm }, },
  { 639 /* orr */, ARM::t2ORRrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 639 /* orr */, ARM::t2ORRrs, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 639 /* orr */, ARM::t2ORRri, Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 639 /* orr */, ARM::t2ORNri, Convert__Reg1_2__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImmNot }, },
  { 639 /* orr */, ARM::ORRrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 639 /* orr */, ARM::ORRri, Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImm }, },
  { 639 /* orr */, ARM::ORRrsi, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedImm }, },
  { 639 /* orr */, ARM::ORRrsr, Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedReg }, },
  { 639 /* orr */, ARM::t2ORRrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 639 /* orr */, ARM::t2ORRrs, Convert__Reg1_3__Reg1_4__RegShiftedImm2_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 639 /* orr */, ARM::t2ORRri, Convert__Reg1_3__Reg1_4__T2SOImm1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 643 /* pkhbt */, ARM::t2PKHBT, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, Feature_HasDSP|Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 643 /* pkhbt */, ARM::PKHBT, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 643 /* pkhbt */, ARM::t2PKHBT, Convert__Reg1_1__Reg1_2__Reg1_3__PKHLSLImm1_4__CondCode2_0, Feature_HasDSP|Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_PKHLSLImm }, },
  { 643 /* pkhbt */, ARM::PKHBT, Convert__Reg1_1__Reg1_2__Reg1_3__PKHLSLImm1_4__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_PKHLSLImm }, },
  { 649 /* pkhtb */, ARM::t2PKHBT, Convert__Reg1_1__Reg1_3__Reg1_2__imm_95_0__CondCode2_0, Feature_HasDSP|Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 649 /* pkhtb */, ARM::PKHBT, Convert__Reg1_1__Reg1_3__Reg1_2__imm_95_0__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 649 /* pkhtb */, ARM::t2PKHTB, Convert__Reg1_1__Reg1_2__Reg1_3__PKHASRImm1_4__CondCode2_0, Feature_HasDSP|Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_PKHASRImm }, },
  { 649 /* pkhtb */, ARM::PKHTB, Convert__Reg1_1__Reg1_2__Reg1_3__PKHASRImm1_4__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_PKHASRImm }, },
  { 655 /* pld */, ARM::PLDi12, Convert__MemImm12Offset2_0, Feature_IsARM, { MCK_MemImm12Offset }, },
  { 655 /* pld */, ARM::PLDrs, Convert__MemRegOffset3_0, Feature_IsARM, { MCK_MemRegOffset }, },
  { 655 /* pld */, ARM::t2PLDpci, Convert__Imm1_1__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_Imm }, },
  { 655 /* pld */, ARM::t2PLDi8, Convert__MemNegImm8Offset2_1__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_MemNegImm8Offset }, },
  { 655 /* pld */, ARM::t2PLDi12, Convert__MemUImm12Offset2_1__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_MemUImm12Offset }, },
  { 655 /* pld */, ARM::t2PLDs, Convert__T2MemRegOffset3_1__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_T2MemRegOffset }, },
  { 655 /* pld */, ARM::t2PLDpci, Convert__MemPCRelImm121_1__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_MemPCRelImm12 }, },
  { 659 /* pldw */, ARM::PLDWi12, Convert__MemImm12Offset2_0, Feature_IsARM|Feature_HasV7|Feature_HasMP, { MCK_MemImm12Offset }, },
  { 659 /* pldw */, ARM::PLDWrs, Convert__MemRegOffset3_0, Feature_IsARM|Feature_HasV7|Feature_HasMP, { MCK_MemRegOffset }, },
  { 659 /* pldw */, ARM::t2PLDWi8, Convert__MemNegImm8Offset2_1__CondCode2_0, Feature_IsThumb2|Feature_HasV7|Feature_HasMP, { MCK_CondCode, MCK_MemNegImm8Offset }, },
  { 659 /* pldw */, ARM::t2PLDWi12, Convert__MemUImm12Offset2_1__CondCode2_0, Feature_IsThumb2|Feature_HasV7|Feature_HasMP, { MCK_CondCode, MCK_MemUImm12Offset }, },
  { 659 /* pldw */, ARM::t2PLDWs, Convert__T2MemRegOffset3_1__CondCode2_0, Feature_IsThumb2|Feature_HasV7|Feature_HasMP, { MCK_CondCode, MCK_T2MemRegOffset }, },
  { 664 /* pli */, ARM::PLIi12, Convert__MemImm12Offset2_0, Feature_IsARM|Feature_HasV7, { MCK_MemImm12Offset }, },
  { 664 /* pli */, ARM::PLIrs, Convert__MemRegOffset3_0, Feature_IsARM|Feature_HasV7, { MCK_MemRegOffset }, },
  { 664 /* pli */, ARM::t2PLIpci, Convert__Imm1_1__CondCode2_0, Feature_IsThumb2|Feature_HasV7, { MCK_CondCode, MCK_Imm }, },
  { 664 /* pli */, ARM::t2PLIi8, Convert__MemNegImm8Offset2_1__CondCode2_0, Feature_IsThumb2|Feature_HasV7, { MCK_CondCode, MCK_MemNegImm8Offset }, },
  { 664 /* pli */, ARM::t2PLIi12, Convert__MemUImm12Offset2_1__CondCode2_0, Feature_IsThumb2|Feature_HasV7, { MCK_CondCode, MCK_MemUImm12Offset }, },
  { 664 /* pli */, ARM::t2PLIs, Convert__T2MemRegOffset3_1__CondCode2_0, Feature_IsThumb2|Feature_HasV7, { MCK_CondCode, MCK_T2MemRegOffset }, },
  { 664 /* pli */, ARM::t2PLIpci, Convert__MemPCRelImm121_1__CondCode2_0, Feature_IsThumb2|Feature_HasV7, { MCK_CondCode, MCK_MemPCRelImm12 }, },
  { 668 /* pop */, ARM::tPOP, Convert__CondCode2_0__RegList1_1, Feature_IsThumb, { MCK_CondCode, MCK_RegList }, },
  { 668 /* pop */, ARM::t2LDMIA_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__RegList1_1, Feature_IsThumb2, { MCK_CondCode, MCK_RegList }, },
  { 668 /* pop */, ARM::LDMIA_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__RegList1_1, Feature_IsARM, { MCK_CondCode, MCK_RegList }, },
  { 668 /* pop */, ARM::t2LDMIA_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__RegList1_2, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_RegList }, },
  { 672 /* push */, ARM::tPUSH, Convert__CondCode2_0__RegList1_1, Feature_IsThumb, { MCK_CondCode, MCK_RegList }, },
  { 672 /* push */, ARM::t2STMDB_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__RegList1_1, Feature_IsThumb2, { MCK_CondCode, MCK_RegList }, },
  { 672 /* push */, ARM::STMDB_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__RegList1_1, Feature_IsARM, { MCK_CondCode, MCK_RegList }, },
  { 672 /* push */, ARM::t2STMDB_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__RegList1_2, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_RegList }, },
  { 677 /* qadd */, ARM::t2QADD, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 677 /* qadd */, ARM::QADD, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 682 /* qadd16 */, ARM::t2QADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 682 /* qadd16 */, ARM::QADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 689 /* qadd8 */, ARM::t2QADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 689 /* qadd8 */, ARM::QADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 695 /* qasx */, ARM::t2QASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 695 /* qasx */, ARM::QASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 700 /* qdadd */, ARM::t2QDADD, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 700 /* qdadd */, ARM::QDADD, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 706 /* qdsub */, ARM::t2QDSUB, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 706 /* qdsub */, ARM::QDSUB, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 712 /* qsax */, ARM::t2QSAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 712 /* qsax */, ARM::QSAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 717 /* qsub */, ARM::t2QSUB, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 717 /* qsub */, ARM::QSUB, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 722 /* qsub16 */, ARM::t2QSUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 722 /* qsub16 */, ARM::QSUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 729 /* qsub8 */, ARM::t2QSUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 729 /* qsub8 */, ARM::QSUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 735 /* rbit */, ARM::t2RBIT, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 735 /* rbit */, ARM::RBIT, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsARM|Feature_HasV6T2, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 740 /* rev */, ARM::tREV, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb|Feature_HasV6, { MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 740 /* rev */, ARM::t2REV, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 740 /* rev */, ARM::REV, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 740 /* rev */, ARM::t2REV, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 744 /* rev16 */, ARM::tREV16, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb|Feature_HasV6, { MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 744 /* rev16 */, ARM::t2REV16, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 744 /* rev16 */, ARM::REV16, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 744 /* rev16 */, ARM::t2REV16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 750 /* revsh */, ARM::tREVSH, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb|Feature_HasV6, { MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 750 /* revsh */, ARM::t2REVSH, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 750 /* revsh */, ARM::REVSH, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 750 /* revsh */, ARM::t2REVSH, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 756 /* rfeda */, ARM::RFEDA, Convert__Reg1_0, Feature_IsARM, { MCK_GPR }, },
  { 756 /* rfeda */, ARM::RFEDA_UPD, Convert__Reg1_0, Feature_IsARM, { MCK_GPR, MCK__EXCLAIM_ }, },
  { 762 /* rfedb */, ARM::RFEDB, Convert__Reg1_0, Feature_IsARM, { MCK_GPR }, },
  { 762 /* rfedb */, ARM::RFEDB_UPD, Convert__Reg1_0, Feature_IsARM, { MCK_GPR, MCK__EXCLAIM_ }, },
  { 762 /* rfedb */, ARM::t2RFEDB, Convert__Reg1_1__CondCode2_0, Feature_IsThumb2|Feature_IsNotMClass, { MCK_CondCode, MCK_GPR }, },
  { 762 /* rfedb */, ARM::t2RFEDBW, Convert__Reg1_1__CondCode2_0, Feature_IsThumb2|Feature_IsNotMClass, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_ }, },
  { 768 /* rfeia */, ARM::RFEIA, Convert__Reg1_0, Feature_IsARM, { MCK_GPR }, },
  { 768 /* rfeia */, ARM::RFEIA_UPD, Convert__Reg1_0, Feature_IsARM, { MCK_GPR, MCK__EXCLAIM_ }, },
  { 768 /* rfeia */, ARM::t2RFEIA, Convert__Reg1_1__CondCode2_0, Feature_IsThumb2|Feature_IsNotMClass, { MCK_CondCode, MCK_GPR }, },
  { 768 /* rfeia */, ARM::t2RFEIAW, Convert__Reg1_1__CondCode2_0, Feature_IsThumb2|Feature_IsNotMClass, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_ }, },
  { 774 /* rfeib */, ARM::RFEIB, Convert__Reg1_0, Feature_IsARM, { MCK_GPR }, },
  { 774 /* rfeib */, ARM::RFEIB_UPD, Convert__Reg1_0, Feature_IsARM, { MCK_GPR, MCK__EXCLAIM_ }, },
  { 780 /* ror */, ARM::tROR, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 780 /* ror */, ARM::t2RORrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 780 /* ror */, ARM::t2RORri, Convert__Reg1_2__Reg1_2__Imm0_311_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_Imm0_31 }, },
  { 780 /* ror */, ARM::RORr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 780 /* ror */, ARM::RORi, Convert__Reg1_2__Reg1_2__Imm0_311_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_Imm0_31 }, },
  { 780 /* ror */, ARM::t2RORrr, Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 780 /* ror */, ARM::t2RORri, Convert__Reg1_3__Reg1_3__Imm0_311_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_Imm0_31 }, },
  { 780 /* ror */, ARM::t2RORrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 780 /* ror */, ARM::t2RORri, Convert__Reg1_2__Reg1_3__Imm0_311_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_Imm0_31 }, },
  { 780 /* ror */, ARM::RORr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 780 /* ror */, ARM::RORi, Convert__Reg1_2__Reg1_3__Imm0_311_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_Imm0_31 }, },
  { 780 /* ror */, ARM::t2RORrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 780 /* ror */, ARM::t2RORri, Convert__Reg1_3__Reg1_4__Imm0_311_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_Imm0_31 }, },
  { 784 /* rrx */, ARM::t2RRX, Convert__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 784 /* rrx */, ARM::RRXi, Convert__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 788 /* rsb */, ARM::t2RSBrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 788 /* rsb */, ARM::t2RSBrs, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_RegShiftedImm }, },
  { 788 /* rsb */, ARM::t2RSBri, Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 788 /* rsb */, ARM::RSBrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 788 /* rsb */, ARM::RSBri, Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 788 /* rsb */, ARM::RSBrsi, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 788 /* rsb */, ARM::RSBrsr, Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedReg }, },
  { 788 /* rsb */, ARM::tRSB, Convert__Reg1_2__CCOut1_0__Reg1_3__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR, MCK__35_0 }, },
  { 788 /* rsb */, ARM::t2RSBrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 788 /* rsb */, ARM::t2RSBrs, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 788 /* rsb */, ARM::t2RSBri, Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 788 /* rsb */, ARM::RSBrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 788 /* rsb */, ARM::RSBri, Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImm }, },
  { 788 /* rsb */, ARM::RSBrsi, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedImm }, },
  { 788 /* rsb */, ARM::RSBrsr, Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedReg }, },
  { 788 /* rsb */, ARM::t2RSBri, Convert__Reg1_3__Reg1_4__T2SOImm1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 792 /* rsc */, ARM::RSCrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 792 /* rsc */, ARM::RSCri, Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 792 /* rsc */, ARM::RSCrsi, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 792 /* rsc */, ARM::RSCrsr, Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedReg }, },
  { 792 /* rsc */, ARM::RSCrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 792 /* rsc */, ARM::RSCri, Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImm }, },
  { 792 /* rsc */, ARM::RSCrsi, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedImm }, },
  { 792 /* rsc */, ARM::RSCrsr, Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedReg }, },
  { 796 /* sadd16 */, ARM::t2SADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 796 /* sadd16 */, ARM::SADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 803 /* sadd8 */, ARM::t2SADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 803 /* sadd8 */, ARM::SADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 809 /* sasx */, ARM::t2SASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 809 /* sasx */, ARM::SASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 814 /* sbc */, ARM::tSBC, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 814 /* sbc */, ARM::SBCrsr, Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedReg }, },
  { 814 /* sbc */, ARM::SBCrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 814 /* sbc */, ARM::SBCri, Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 814 /* sbc */, ARM::ADCri, Convert__Reg1_2__Reg1_2__ModImmNot1_3__CondCode2_1__CCOut1_0, Feature_IsARM|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImmNot }, },
  { 814 /* sbc */, ARM::SBCrsi, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 814 /* sbc */, ARM::t2SBCrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 814 /* sbc */, ARM::t2SBCrs, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 814 /* sbc */, ARM::t2SBCri, Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 814 /* sbc */, ARM::t2ADCri, Convert__Reg1_2__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImmNot }, },
  { 814 /* sbc */, ARM::SBCrsr, Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_RegShiftedReg }, },
  { 814 /* sbc */, ARM::SBCrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 814 /* sbc */, ARM::SBCri, Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImm }, },
  { 814 /* sbc */, ARM::ADCri, Convert__Reg1_2__Reg1_3__ModImmNot1_4__CondCode2_1__CCOut1_0, Feature_IsARM|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImmNot }, },
  { 814 /* sbc */, ARM::SBCrsi, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedImm }, },
  { 814 /* sbc */, ARM::t2SBCrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 814 /* sbc */, ARM::t2SBCrs, Convert__Reg1_3__Reg1_4__RegShiftedImm2_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 818 /* sbfx */, ARM::t2SBFX, Convert__Reg1_1__Reg1_2__Imm0_311_3__Imm1_321_4__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_Imm0_31, MCK_Imm1_32 }, },
  { 818 /* sbfx */, ARM::SBFX, Convert__Reg1_1__Reg1_2__Imm0_311_3__Imm1_321_4__CondCode2_0, Feature_IsARM|Feature_HasV6T2, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_Imm0_31, MCK_Imm1_32 }, },
  { 823 /* sdiv */, ARM::t2SDIV, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasDivideInThumb|Feature_IsThumb|Feature_HasV8MBaseline, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 823 /* sdiv */, ARM::SDIV, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM|Feature_HasDivideInARM, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 828 /* sel */, ARM::SEL, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 828 /* sel */, ARM::t2SEL, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 832 /* setend */, ARM::tSETEND, Convert__SetEndImm1_0, Feature_IsThumb|Feature_IsNotMClass, { MCK_SetEndImm }, },
  { 832 /* setend */, ARM::SETEND, Convert__SetEndImm1_0, Feature_IsARM, { MCK_SetEndImm }, },
  { 839 /* setpan */, ARM::SETPAN, Convert__Imm0_11_0, Feature_IsARM|Feature_HasV8|Feature_HasV8_1a, { MCK_Imm0_1 }, },
  { 839 /* setpan */, ARM::t2SETPAN, Convert__Imm0_11_0, Feature_IsThumb2|Feature_HasV8|Feature_HasV8_1a, { MCK_Imm0_1 }, },
  { 846 /* sev */, ARM::HINT, Convert__imm_95_4__CondCode2_0, Feature_IsARM|Feature_HasV6K, { MCK_CondCode }, },
  { 846 /* sev */, ARM::tHINT, Convert__imm_95_4__CondCode2_0, Feature_IsThumb|Feature_HasV6M, { MCK_CondCode }, },
  { 846 /* sev */, ARM::t2HINT, Convert__imm_95_4__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w }, },
  { 850 /* sevl */, ARM::HINT, Convert__imm_95_5__CondCode2_0, Feature_IsARM|Feature_HasV8, { MCK_CondCode }, },
  { 850 /* sevl */, ARM::tHINT, Convert__imm_95_5__CondCode2_0, Feature_IsThumb2|Feature_HasV8, { MCK_CondCode }, },
  { 850 /* sevl */, ARM::t2HINT, Convert__imm_95_5__CondCode2_0, Feature_IsThumb2|Feature_HasV8, { MCK_CondCode, MCK__DOT_w }, },
  { 855 /* sg */, ARM::t2SG, Convert__CondCode2_0, Feature_Has8MSecExt, { MCK_CondCode }, },
  { 858 /* sha1c */, ARM::SHA1C, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasCrypto, { MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 864 /* sha1h */, ARM::SHA1H, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasCrypto, { MCK__DOT_32, MCK_QPR, MCK_QPR }, },
  { 870 /* sha1m */, ARM::SHA1M, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasCrypto, { MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 876 /* sha1p */, ARM::SHA1P, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasCrypto, { MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 882 /* sha1su0 */, ARM::SHA1SU0, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasCrypto, { MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 890 /* sha1su1 */, ARM::SHA1SU1, Convert__Reg1_1__Tie0_1_1__Reg1_2, Feature_HasV8|Feature_HasCrypto, { MCK__DOT_32, MCK_QPR, MCK_QPR }, },
  { 898 /* sha256h */, ARM::SHA256H, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasCrypto, { MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 906 /* sha256h2 */, ARM::SHA256H2, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasCrypto, { MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 915 /* sha256su0 */, ARM::SHA256SU0, Convert__Reg1_1__Tie0_1_1__Reg1_2, Feature_HasV8|Feature_HasCrypto, { MCK__DOT_32, MCK_QPR, MCK_QPR }, },
  { 925 /* sha256su1 */, ARM::SHA256SU1, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasCrypto, { MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 935 /* shadd16 */, ARM::t2SHADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 935 /* shadd16 */, ARM::SHADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 943 /* shadd8 */, ARM::t2SHADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 943 /* shadd8 */, ARM::SHADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 950 /* shasx */, ARM::t2SHASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 950 /* shasx */, ARM::SHASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 956 /* shsax */, ARM::t2SHSAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 956 /* shsax */, ARM::SHSAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 962 /* shsub16 */, ARM::t2SHSUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 962 /* shsub16 */, ARM::SHSUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 970 /* shsub8 */, ARM::t2SHSUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 970 /* shsub8 */, ARM::SHSUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 977 /* smc */, ARM::SMC, Convert__Imm0_151_1__CondCode2_0, Feature_IsARM|Feature_HasTrustZone, { MCK_CondCode, MCK_Imm0_15 }, },
  { 977 /* smc */, ARM::t2SMC, Convert__Imm0_151_1__CondCode2_0, Feature_IsThumb2|Feature_HasTrustZone, { MCK_CondCode, MCK_Imm0_15 }, },
  { 981 /* smlabb */, ARM::t2SMLABB, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 981 /* smlabb */, ARM::SMLABB, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsARM|Feature_HasV5TE, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPR }, },
  { 988 /* smlabt */, ARM::t2SMLABT, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 988 /* smlabt */, ARM::SMLABT, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsARM|Feature_HasV5TE, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPR }, },
  { 995 /* smlad */, ARM::t2SMLAD, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 995 /* smlad */, ARM::SMLAD, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPR }, },
  { 1001 /* smladx */, ARM::t2SMLADX, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1001 /* smladx */, ARM::SMLADX, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPR }, },
  { 1008 /* smlal */, ARM::t2SMLAL, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1008 /* smlal */, ARM::SMLAL, Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__Tie0_1_1__Tie1_1_1__CondCode2_1__CCOut1_0, Feature_IsARM|Feature_HasV6, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1008 /* smlal */, ARM::SMLAL, Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__Tie0_3_3__Tie1_4_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1014 /* smlalbb */, ARM::t2SMLALBB, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1014 /* smlalbb */, ARM::SMLALBB, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_IsARM|Feature_HasV5TE, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1022 /* smlalbt */, ARM::t2SMLALBT, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1022 /* smlalbt */, ARM::SMLALBT, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_IsARM|Feature_HasV5TE, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1030 /* smlald */, ARM::t2SMLALD, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1030 /* smlald */, ARM::SMLALD, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1037 /* smlaldx */, ARM::t2SMLALDX, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1037 /* smlaldx */, ARM::SMLALDX, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1045 /* smlaltb */, ARM::t2SMLALTB, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1045 /* smlaltb */, ARM::SMLALTB, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_IsARM|Feature_HasV5TE, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1053 /* smlaltt */, ARM::t2SMLALTT, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1053 /* smlaltt */, ARM::SMLALTT, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_IsARM|Feature_HasV5TE, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1061 /* smlatb */, ARM::t2SMLATB, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1061 /* smlatb */, ARM::SMLATB, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsARM|Feature_HasV5TE, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPR }, },
  { 1068 /* smlatt */, ARM::t2SMLATT, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1068 /* smlatt */, ARM::SMLATT, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsARM|Feature_HasV5TE, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPR }, },
  { 1075 /* smlawb */, ARM::t2SMLAWB, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1075 /* smlawb */, ARM::SMLAWB, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsARM|Feature_HasV5TE, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPR }, },
  { 1082 /* smlawt */, ARM::t2SMLAWT, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1082 /* smlawt */, ARM::SMLAWT, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsARM|Feature_HasV5TE, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPR }, },
  { 1089 /* smlsd */, ARM::t2SMLSD, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1089 /* smlsd */, ARM::SMLSD, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPR }, },
  { 1095 /* smlsdx */, ARM::t2SMLSDX, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1095 /* smlsdx */, ARM::SMLSDX, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPR }, },
  { 1102 /* smlsld */, ARM::t2SMLSLD, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1102 /* smlsld */, ARM::SMLSLD, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1109 /* smlsldx */, ARM::t2SMLSLDX, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1109 /* smlsldx */, ARM::SMLSLDX, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1117 /* smmla */, ARM::t2SMMLA, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1117 /* smmla */, ARM::SMMLA, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1123 /* smmlar */, ARM::t2SMMLAR, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1123 /* smmlar */, ARM::SMMLAR, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1130 /* smmls */, ARM::t2SMMLS, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1130 /* smmls */, ARM::SMMLS, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1136 /* smmlsr */, ARM::t2SMMLSR, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1136 /* smmlsr */, ARM::SMMLSR, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1143 /* smmul */, ARM::t2SMMUL, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1143 /* smmul */, ARM::SMMUL, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1149 /* smmulr */, ARM::t2SMMULR, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1149 /* smmulr */, ARM::SMMULR, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1156 /* smuad */, ARM::t2SMUAD, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1156 /* smuad */, ARM::SMUAD, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1162 /* smuadx */, ARM::t2SMUADX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1162 /* smuadx */, ARM::SMUADX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1169 /* smulbb */, ARM::t2SMULBB, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1169 /* smulbb */, ARM::SMULBB, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM|Feature_HasV5TE, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1176 /* smulbt */, ARM::t2SMULBT, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1176 /* smulbt */, ARM::SMULBT, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM|Feature_HasV5TE, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1183 /* smull */, ARM::t2SMULL, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1183 /* smull */, ARM::SMULL, Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, Feature_IsARM|Feature_HasV6, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1183 /* smull */, ARM::SMULL, Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1189 /* smultb */, ARM::t2SMULTB, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1189 /* smultb */, ARM::SMULTB, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM|Feature_HasV5TE, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1196 /* smultt */, ARM::t2SMULTT, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1196 /* smultt */, ARM::SMULTT, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM|Feature_HasV5TE, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1203 /* smulwb */, ARM::t2SMULWB, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1203 /* smulwb */, ARM::SMULWB, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM|Feature_HasV5TE, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1210 /* smulwt */, ARM::t2SMULWT, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1210 /* smulwt */, ARM::SMULWT, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM|Feature_HasV5TE, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1217 /* smusd */, ARM::t2SMUSD, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1217 /* smusd */, ARM::SMUSD, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1223 /* smusdx */, ARM::t2SMUSDX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1223 /* smusdx */, ARM::SMUSDX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1230 /* srsda */, ARM::SRSDA, Convert__Imm0_311_0, Feature_IsARM, { MCK_Imm0_31 }, },
  { 1230 /* srsda */, ARM::SRSDA, Convert__Imm0_311_1, Feature_IsARM, { MCK_GPRsp, MCK_Imm0_31 }, },
  { 1230 /* srsda */, ARM::SRSDA_UPD, Convert__Imm0_311_0, Feature_IsARM, { MCK_Imm0_31, MCK__EXCLAIM_ }, },
  { 1230 /* srsda */, ARM::SRSDA_UPD, Convert__Imm0_311_2, Feature_IsARM, { MCK_GPRsp, MCK__EXCLAIM_, MCK_Imm0_31 }, },
  { 1236 /* srsdb */, ARM::SRSDB, Convert__Imm0_311_0, Feature_IsARM, { MCK_Imm0_31 }, },
  { 1236 /* srsdb */, ARM::SRSDB, Convert__Imm0_311_1, Feature_IsARM, { MCK_GPRsp, MCK_Imm0_31 }, },
  { 1236 /* srsdb */, ARM::t2SRSDB, Convert__Imm0_311_1__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_Imm0_31 }, },
  { 1236 /* srsdb */, ARM::SRSDB_UPD, Convert__Imm0_311_0, Feature_IsARM, { MCK_Imm0_31, MCK__EXCLAIM_ }, },
  { 1236 /* srsdb */, ARM::SRSDB_UPD, Convert__Imm0_311_2, Feature_IsARM, { MCK_GPRsp, MCK__EXCLAIM_, MCK_Imm0_31 }, },
  { 1236 /* srsdb */, ARM::t2SRSDB, Convert__Imm0_311_2__CondCode2_0, Feature_IsThumb2|Feature_IsNotMClass, { MCK_CondCode, MCK_GPRsp, MCK_Imm0_31 }, },
  { 1236 /* srsdb */, ARM::t2SRSDB_UPD, Convert__Imm0_311_1__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_Imm0_31, MCK__EXCLAIM_ }, },
  { 1236 /* srsdb */, ARM::t2SRSDB_UPD, Convert__Imm0_311_3__CondCode2_0, Feature_IsThumb2|Feature_IsNotMClass, { MCK_CondCode, MCK_GPRsp, MCK__EXCLAIM_, MCK_Imm0_31 }, },
  { 1242 /* srsia */, ARM::SRSIA, Convert__Imm0_311_0, Feature_IsARM, { MCK_Imm0_31 }, },
  { 1242 /* srsia */, ARM::SRSIA, Convert__Imm0_311_1, Feature_IsARM, { MCK_GPRsp, MCK_Imm0_31 }, },
  { 1242 /* srsia */, ARM::t2SRSIA, Convert__Imm0_311_1__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_Imm0_31 }, },
  { 1242 /* srsia */, ARM::SRSIA_UPD, Convert__Imm0_311_0, Feature_IsARM, { MCK_Imm0_31, MCK__EXCLAIM_ }, },
  { 1242 /* srsia */, ARM::SRSIA_UPD, Convert__Imm0_311_2, Feature_IsARM, { MCK_GPRsp, MCK__EXCLAIM_, MCK_Imm0_31 }, },
  { 1242 /* srsia */, ARM::t2SRSIA, Convert__Imm0_311_2__CondCode2_0, Feature_IsThumb2|Feature_IsNotMClass, { MCK_CondCode, MCK_GPRsp, MCK_Imm0_31 }, },
  { 1242 /* srsia */, ARM::t2SRSIA_UPD, Convert__Imm0_311_1__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_Imm0_31, MCK__EXCLAIM_ }, },
  { 1242 /* srsia */, ARM::t2SRSIA_UPD, Convert__Imm0_311_3__CondCode2_0, Feature_IsThumb2|Feature_IsNotMClass, { MCK_CondCode, MCK_GPRsp, MCK__EXCLAIM_, MCK_Imm0_31 }, },
  { 1248 /* srsib */, ARM::SRSIB, Convert__Imm0_311_0, Feature_IsARM, { MCK_Imm0_31 }, },
  { 1248 /* srsib */, ARM::SRSIB, Convert__Imm0_311_1, Feature_IsARM, { MCK_GPRsp, MCK_Imm0_31 }, },
  { 1248 /* srsib */, ARM::SRSIB_UPD, Convert__Imm0_311_0, Feature_IsARM, { MCK_Imm0_31, MCK__EXCLAIM_ }, },
  { 1248 /* srsib */, ARM::SRSIB_UPD, Convert__Imm0_311_2, Feature_IsARM, { MCK_GPRsp, MCK__EXCLAIM_, MCK_Imm0_31 }, },
  { 1254 /* ssat */, ARM::t2SSAT, Convert__Reg1_1__Imm1_321_2__Reg1_3__imm_95_0__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Imm1_32, MCK_rGPR }, },
  { 1254 /* ssat */, ARM::SSAT, Convert__Reg1_1__Imm1_321_2__Reg1_3__imm_95_0__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_Imm1_32, MCK_GPRnopc }, },
  { 1254 /* ssat */, ARM::t2SSAT, Convert__Reg1_1__Imm1_321_2__Reg1_3__ShifterImm1_4__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Imm1_32, MCK_rGPR, MCK_ShifterImm }, },
  { 1254 /* ssat */, ARM::SSAT, Convert__Reg1_1__Imm1_321_2__Reg1_3__ShifterImm1_4__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_Imm1_32, MCK_GPRnopc, MCK_ShifterImm }, },
  { 1259 /* ssat16 */, ARM::t2SSAT16, Convert__Reg1_1__Imm1_161_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_Imm1_16, MCK_rGPR }, },
  { 1259 /* ssat16 */, ARM::SSAT16, Convert__Reg1_1__Imm1_161_2__Reg1_3__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_Imm1_16, MCK_GPRnopc }, },
  { 1266 /* ssax */, ARM::t2SSAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1266 /* ssax */, ARM::SSAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1271 /* ssub16 */, ARM::t2SSUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1271 /* ssub16 */, ARM::SSUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1278 /* ssub8 */, ARM::t2SSUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1278 /* ssub8 */, ARM::SSUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1284 /* stc */, ARM::STC_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 1284 /* stc */, ARM::t2STC_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 1284 /* stc */, ARM::STC_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 1284 /* stc */, ARM::t2STC_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 1284 /* stc */, ARM::STC_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 1284 /* stc */, ARM::t2STC_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 1284 /* stc */, ARM::STC_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 1284 /* stc */, ARM::t2STC_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 1288 /* stc2 */, ARM::STC2_OFFSET, Convert__CoprocNum1_0__CoprocReg1_1__AddrMode52_2, Feature_IsARM|Feature_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 1288 /* stc2 */, ARM::t2STC2_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_PreV8|Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 1288 /* stc2 */, ARM::STC2_PRE, Convert__CoprocNum1_0__CoprocReg1_1__AddrMode52_2, Feature_IsARM|Feature_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 1288 /* stc2 */, ARM::STC2_OPTION, Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__CoprocOption1_3, Feature_IsARM|Feature_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 1288 /* stc2 */, ARM::STC2_POST, Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__PostIdxImm8s41_3, Feature_IsARM|Feature_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 1288 /* stc2 */, ARM::t2STC2_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_PreV8|Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 1288 /* stc2 */, ARM::t2STC2_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, Feature_PreV8|Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 1288 /* stc2 */, ARM::t2STC2_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, Feature_PreV8|Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 1293 /* stc2l */, ARM::STC2L_OFFSET, Convert__CoprocNum1_0__CoprocReg1_1__AddrMode52_2, Feature_IsARM|Feature_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 1293 /* stc2l */, ARM::t2STC2L_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_PreV8|Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 1293 /* stc2l */, ARM::STC2L_PRE, Convert__CoprocNum1_0__CoprocReg1_1__AddrMode52_2, Feature_IsARM|Feature_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 1293 /* stc2l */, ARM::STC2L_OPTION, Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__CoprocOption1_3, Feature_IsARM|Feature_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 1293 /* stc2l */, ARM::STC2L_POST, Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__PostIdxImm8s41_3, Feature_IsARM|Feature_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 1293 /* stc2l */, ARM::t2STC2L_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_PreV8|Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 1293 /* stc2l */, ARM::t2STC2L_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, Feature_PreV8|Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 1293 /* stc2l */, ARM::t2STC2L_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, Feature_PreV8|Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 1299 /* stcl */, ARM::STCL_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 1299 /* stcl */, ARM::t2STCL_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 1299 /* stcl */, ARM::STCL_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 1299 /* stcl */, ARM::t2STCL_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 1299 /* stcl */, ARM::STCL_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 1299 /* stcl */, ARM::t2STCL_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 1299 /* stcl */, ARM::STCL_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 1299 /* stcl */, ARM::t2STCL_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 1304 /* stl */, ARM::t2STL, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsThumb|Feature_HasAcquireRelease, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset }, },
  { 1304 /* stl */, ARM::STL, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsARM|Feature_HasAcquireRelease, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 1308 /* stlb */, ARM::t2STLB, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsThumb|Feature_HasAcquireRelease, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset }, },
  { 1308 /* stlb */, ARM::STLB, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsARM|Feature_HasAcquireRelease, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 1313 /* stlex */, ARM::t2STLEX, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, Feature_IsThumb|Feature_HasAcquireRelease|Feature_HasV7Clrex, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemNoOffset }, },
  { 1313 /* stlex */, ARM::STLEX, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, Feature_IsARM|Feature_HasAcquireRelease|Feature_HasV7Clrex, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_MemNoOffset }, },
  { 1319 /* stlexb */, ARM::t2STLEXB, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, Feature_IsThumb|Feature_HasAcquireRelease|Feature_HasV7Clrex, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemNoOffset }, },
  { 1319 /* stlexb */, ARM::STLEXB, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, Feature_IsARM|Feature_HasAcquireRelease|Feature_HasV7Clrex, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_MemNoOffset }, },
  { 1326 /* stlexd */, ARM::STLEXD, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, Feature_IsARM|Feature_HasAcquireRelease|Feature_HasV7Clrex, { MCK_CondCode, MCK_GPR, MCK_GPRPair, MCK_MemNoOffset }, },
  { 1326 /* stlexd */, ARM::t2STLEXD, Convert__Reg1_1__Reg1_2__Reg1_3__MemNoOffset1_4__CondCode2_0, Feature_IsThumb|Feature_HasAcquireRelease|Feature_HasV7Clrex|Feature_IsNotMClass, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_MemNoOffset }, },
  { 1333 /* stlexh */, ARM::t2STLEXH, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, Feature_IsThumb|Feature_HasAcquireRelease|Feature_HasV7Clrex, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemNoOffset }, },
  { 1333 /* stlexh */, ARM::STLEXH, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, Feature_IsARM|Feature_HasAcquireRelease|Feature_HasV7Clrex, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_MemNoOffset }, },
  { 1340 /* stlh */, ARM::t2STLH, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsThumb|Feature_HasAcquireRelease, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset }, },
  { 1340 /* stlh */, ARM::STLH, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsARM|Feature_HasAcquireRelease, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 1345 /* stm */, ARM::STMIA, Convert__Reg1_1__CondCode2_0__RegList1_2, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 1345 /* stm */, ARM::t2STMIA, Convert__Reg1_1__CondCode2_0__RegList1_2, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 1345 /* stm */, ARM::t2STMIA, Convert__Reg1_1__CondCode2_0__RegList1_2, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 1345 /* stm */, ARM::t2STMIA, Convert__Reg1_2__CondCode2_0__RegList1_3, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_RegList }, },
  { 1345 /* stm */, ARM::tSTMIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 1345 /* stm */, ARM::STMIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 1345 /* stm */, ARM::t2STMIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 1345 /* stm */, ARM::sysSTMIA, Convert__Reg1_1__CondCode2_0__RegList1_2, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList, MCK__94_ }, },
  { 1345 /* stm */, ARM::t2STMIA_UPD, Convert__Reg1_2__Tie0_3_3__CondCode2_0__RegList1_4, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 1345 /* stm */, ARM::sysSTMIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList, MCK__94_ }, },
  { 1349 /* stmda */, ARM::STMDA, Convert__Reg1_1__CondCode2_0__RegList1_2, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 1349 /* stmda */, ARM::STMDA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 1349 /* stmda */, ARM::sysSTMDA, Convert__Reg1_1__CondCode2_0__RegList1_2, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList, MCK__94_ }, },
  { 1349 /* stmda */, ARM::sysSTMDA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList, MCK__94_ }, },
  { 1355 /* stmdb */, ARM::STMDB, Convert__Reg1_1__CondCode2_0__RegList1_2, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 1355 /* stmdb */, ARM::t2STMDB, Convert__Reg1_1__CondCode2_0__RegList1_2, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 1355 /* stmdb */, ARM::t2STMDB, Convert__Reg1_2__CondCode2_0__RegList1_3, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_RegList }, },
  { 1355 /* stmdb */, ARM::STMDB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 1355 /* stmdb */, ARM::t2STMDB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 1355 /* stmdb */, ARM::sysSTMDB, Convert__Reg1_1__CondCode2_0__RegList1_2, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList, MCK__94_ }, },
  { 1355 /* stmdb */, ARM::t2STMDB_UPD, Convert__Reg1_2__Tie0_3_3__CondCode2_0__RegList1_4, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 1355 /* stmdb */, ARM::sysSTMDB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList, MCK__94_ }, },
  { 1361 /* stmib */, ARM::STMIB, Convert__Reg1_1__CondCode2_0__RegList1_2, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 1361 /* stmib */, ARM::STMIB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 1361 /* stmib */, ARM::sysSTMIB, Convert__Reg1_1__CondCode2_0__RegList1_2, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList, MCK__94_ }, },
  { 1361 /* stmib */, ARM::sysSTMIB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList, MCK__94_ }, },
  { 1367 /* str */, ARM::tSTRi, Convert__Reg1_1__MemThumbRIs42_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRIs4 }, },
  { 1367 /* str */, ARM::tSTRr, Convert__Reg1_1__MemThumbRR2_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRR }, },
  { 1367 /* str */, ARM::tSTRspi, Convert__Reg1_1__MemThumbSPI2_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbSPI }, },
  { 1367 /* str */, ARM::STRi12, Convert__Reg1_1__MemImm12Offset2_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemImm12Offset }, },
  { 1367 /* str */, ARM::t2STRi8, Convert__Reg1_1__MemNegImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemNegImm8Offset }, },
  { 1367 /* str */, ARM::STRrs, Convert__Reg1_1__MemRegOffset3_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemRegOffset }, },
  { 1367 /* str */, ARM::t2STRi12, Convert__Reg1_1__MemUImm12Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemUImm12Offset }, },
  { 1367 /* str */, ARM::t2STRs, Convert__Reg1_1__T2MemRegOffset3_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_T2MemRegOffset }, },
  { 1367 /* str */, ARM::t2STRi12, Convert__Reg1_2__MemUImm12Offset2_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemUImm12Offset }, },
  { 1367 /* str */, ARM::t2STRs, Convert__Reg1_2__T2MemRegOffset3_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_T2MemRegOffset }, },
  { 1367 /* str */, ARM::t2STR_PRE, Convert__imm_95_0__Reg1_1__MemImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 1367 /* str */, ARM::t2STR_POST, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__Imm1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_MemNoOffset, MCK_Imm }, },
  { 1367 /* str */, ARM::STR_PRE_IMM, Convert__imm_95_0__Reg1_1__MemImm12Offset2_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemImm12Offset, MCK__EXCLAIM_ }, },
  { 1367 /* str */, ARM::STR_POST_IMM, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__AM2OffsetImm2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM2OffsetImm }, },
  { 1367 /* str */, ARM::STR_POST_REG, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxRegShifted2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxRegShifted }, },
  { 1367 /* str */, ARM::STR_PRE_REG, Convert__imm_95_0__Reg1_1__MemRegOffset3_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemRegOffset, MCK__EXCLAIM_ }, },
  { 1371 /* strb */, ARM::tSTRBi, Convert__Reg1_1__MemThumbRIs12_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRIs1 }, },
  { 1371 /* strb */, ARM::tSTRBr, Convert__Reg1_1__MemThumbRR2_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRR }, },
  { 1371 /* strb */, ARM::t2STRBi8, Convert__Reg1_1__MemNegImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemNegImm8Offset }, },
  { 1371 /* strb */, ARM::t2STRBi12, Convert__Reg1_1__MemUImm12Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemUImm12Offset }, },
  { 1371 /* strb */, ARM::t2STRBs, Convert__Reg1_1__T2MemRegOffset3_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_T2MemRegOffset }, },
  { 1371 /* strb */, ARM::STRBi12, Convert__Reg1_1__MemImm12Offset2_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_MemImm12Offset }, },
  { 1371 /* strb */, ARM::STRBrs, Convert__Reg1_1__MemRegOffset3_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_MemRegOffset }, },
  { 1371 /* strb */, ARM::t2STRBi12, Convert__Reg1_2__MemUImm12Offset2_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_MemUImm12Offset }, },
  { 1371 /* strb */, ARM::t2STRBs, Convert__Reg1_2__T2MemRegOffset3_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2MemRegOffset }, },
  { 1371 /* strb */, ARM::t2STRB_PRE, Convert__imm_95_0__Reg1_1__MemImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 1371 /* strb */, ARM::t2STRB_POST, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__Imm1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset, MCK_Imm }, },
  { 1371 /* strb */, ARM::STRB_PRE_IMM, Convert__imm_95_0__Reg1_1__MemImm12Offset2_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemImm12Offset, MCK__EXCLAIM_ }, },
  { 1371 /* strb */, ARM::STRB_POST_IMM, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__AM2OffsetImm2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM2OffsetImm }, },
  { 1371 /* strb */, ARM::STRB_POST_REG, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxRegShifted2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxRegShifted }, },
  { 1371 /* strb */, ARM::STRB_PRE_REG, Convert__imm_95_0__Reg1_1__MemRegOffset3_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemRegOffset, MCK__EXCLAIM_ }, },
  { 1376 /* strbt */, ARM::t2STRBT, Convert__Reg1_1__MemImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemImm8Offset }, },
  { 1376 /* strbt */, ARM::STRBT_POST, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 1376 /* strbt */, ARM::STRBT_POST_IMM, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__AM2OffsetImm2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM2OffsetImm }, },
  { 1376 /* strbt */, ARM::STRBT_POST_REG, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxRegShifted2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxRegShifted }, },
  { 1382 /* strd */, ARM::t2STRDi8, Convert__Reg1_1__Reg1_2__MemImm8s4Offset2_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemImm8s4Offset }, },
  { 1382 /* strd */, ARM::STRD, Convert__Reg1_1__Reg1_2__AddrMode33_3__CondCode2_0, Feature_IsARM|Feature_HasV5TE, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_AddrMode3 }, },
  { 1382 /* strd */, ARM::t2STRD_PRE, Convert__imm_95_0__Reg1_1__Reg1_2__MemImm8s4Offset2_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemImm8s4Offset, MCK__EXCLAIM_ }, },
  { 1382 /* strd */, ARM::t2STRD_POST, Convert__MemNoOffset1_3__Reg1_1__Reg1_2__Tie0_4_4__Imm1_4__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemNoOffset, MCK_Imm }, },
  { 1382 /* strd */, ARM::STRD_PRE, Convert__imm_95_0__Reg1_1__Reg1_2__AddrMode33_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_AddrMode3, MCK__EXCLAIM_ }, },
  { 1382 /* strd */, ARM::STRD_POST, Convert__MemNoOffset1_3__Reg1_1__Reg1_2__Tie0_4_4__AM3Offset2_4__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_MemNoOffset, MCK_AM3Offset }, },
  { 1387 /* strex */, ARM::t2STREX, Convert__Reg1_1__Reg1_2__MemImm0_1020s4Offset2_3__CondCode2_0, Feature_IsThumb|Feature_HasV8MBaseline, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemImm0_1020s4Offset }, },
  { 1387 /* strex */, ARM::STREX, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_MemNoOffset }, },
  { 1393 /* strexb */, ARM::t2STREXB, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, Feature_IsThumb|Feature_HasV8MBaseline, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemNoOffset }, },
  { 1393 /* strexb */, ARM::STREXB, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_MemNoOffset }, },
  { 1400 /* strexd */, ARM::STREXD, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPRPair, MCK_MemNoOffset }, },
  { 1400 /* strexd */, ARM::t2STREXD, Convert__Reg1_1__Reg1_2__Reg1_3__MemNoOffset1_4__CondCode2_0, Feature_IsThumb2|Feature_IsNotMClass, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_MemNoOffset }, },
  { 1407 /* strexh */, ARM::t2STREXH, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, Feature_IsThumb|Feature_HasV8MBaseline, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemNoOffset }, },
  { 1407 /* strexh */, ARM::STREXH, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_MemNoOffset }, },
  { 1414 /* strh */, ARM::tSTRHi, Convert__Reg1_1__MemThumbRIs22_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRIs2 }, },
  { 1414 /* strh */, ARM::tSTRHr, Convert__Reg1_1__MemThumbRR2_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRR }, },
  { 1414 /* strh */, ARM::t2STRHi8, Convert__Reg1_1__MemNegImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemNegImm8Offset }, },
  { 1414 /* strh */, ARM::t2STRHi12, Convert__Reg1_1__MemUImm12Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemUImm12Offset }, },
  { 1414 /* strh */, ARM::t2STRHs, Convert__Reg1_1__T2MemRegOffset3_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_T2MemRegOffset }, },
  { 1414 /* strh */, ARM::STRH, Convert__Reg1_1__AddrMode33_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_AddrMode3 }, },
  { 1414 /* strh */, ARM::t2STRHi12, Convert__Reg1_2__MemUImm12Offset2_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_MemUImm12Offset }, },
  { 1414 /* strh */, ARM::t2STRHs, Convert__Reg1_2__T2MemRegOffset3_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2MemRegOffset }, },
  { 1414 /* strh */, ARM::t2STRH_PRE, Convert__imm_95_0__Reg1_1__MemImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 1414 /* strh */, ARM::t2STRH_POST, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__Imm1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset, MCK_Imm }, },
  { 1414 /* strh */, ARM::STRH_PRE, Convert__imm_95_0__Reg1_1__AddrMode33_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_AddrMode3, MCK__EXCLAIM_ }, },
  { 1414 /* strh */, ARM::STRH_POST, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__AM3Offset2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM3Offset }, },
  { 1419 /* strht */, ARM::t2STRHT, Convert__Reg1_1__MemImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemImm8Offset }, },
  { 1419 /* strht */, ARM::STRHTi, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxImm81_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxImm8 }, },
  { 1419 /* strht */, ARM::STRHTr, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxReg2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxReg }, },
  { 1425 /* strt */, ARM::t2STRT, Convert__Reg1_1__MemImm8Offset2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemImm8Offset }, },
  { 1425 /* strt */, ARM::STRT_POST, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 1425 /* strt */, ARM::STRT_POST_IMM, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__AM2OffsetImm2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM2OffsetImm }, },
  { 1425 /* strt */, ARM::STRT_POST_REG, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxRegShifted2_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxRegShifted }, },
  { 1430 /* sub */, ARM::tSUBspi, Convert__Reg1_1__Tie0_1_1__Imm0_508s41_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_GPRsp, MCK_Imm0_508s4 }, },
  { 1430 /* sub */, ARM::t2SUBri12, Convert__Reg1_1__Reg1_1__Imm0_40951_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_Imm0_4095 }, },
  { 1430 /* sub */, ARM::tSUBrr, Convert__Reg1_2__CCOut1_0__Reg1_2__Reg1_3__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 1430 /* sub */, ARM::tSUBi8, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Imm0_2551_3__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_Imm0_255 }, },
  { 1430 /* sub */, ARM::tADDi8, Convert__Reg1_2__CCOut1_0__Tie0_3_3__ThumbModImmNeg8_2551_3__CondCode2_1, Feature_IsThumb|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_ThumbModImmNeg8_255 }, },
  { 1430 /* sub */, ARM::t2SUBrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_rGPR }, },
  { 1430 /* sub */, ARM::t2SUBrs, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 1430 /* sub */, ARM::t2SUBri, Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_T2SOImm }, },
  { 1430 /* sub */, ARM::SUBrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 1430 /* sub */, ARM::SUBri, Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 1430 /* sub */, ARM::ADDri, Convert__Reg1_2__Reg1_2__ModImmNeg1_3__CondCode2_1__CCOut1_0, Feature_IsARM|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImmNeg }, },
  { 1430 /* sub */, ARM::SUBrsi, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 1430 /* sub */, ARM::SUBrsr, Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedReg }, },
  { 1430 /* sub */, ARM::tSUBspi, Convert__regSP__Tie0_1_1__Imm0_508s41_3__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_GPRsp, MCK_GPRsp, MCK_Imm0_508s4 }, },
  { 1430 /* sub */, ARM::t2SUBri12, Convert__Reg1_1__Reg1_2__Imm0_40951_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_Imm0_4095 }, },
  { 1430 /* sub */, ARM::t2ADDri12, Convert__Reg1_1__Reg1_2__T2SOImmNeg1_3__CondCode2_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_T2SOImmNeg }, },
  { 1430 /* sub */, ARM::t2SUBrr, Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_rGPR }, },
  { 1430 /* sub */, ARM::tSUBrr, Convert__Reg1_2__CCOut1_0__Reg1_3__Reg1_4__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR, MCK_tGPR }, },
  { 1430 /* sub */, ARM::tSUBi3, Convert__Reg1_2__CCOut1_0__Reg1_3__Imm0_71_4__CondCode2_1, Feature_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR, MCK_Imm0_7 }, },
  { 1430 /* sub */, ARM::tADDi3, Convert__Reg1_2__CCOut1_0__Reg1_3__ThumbModImmNeg1_71_4__CondCode2_1, Feature_IsThumb|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR, MCK_ThumbModImmNeg1_7 }, },
  { 1430 /* sub */, ARM::t2SUBrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_rGPR }, },
  { 1430 /* sub */, ARM::t2SUBrs, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 1430 /* sub */, ARM::t2SUBri, Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_T2SOImm }, },
  { 1430 /* sub */, ARM::t2ADDri, Convert__Reg1_2__Reg1_3__T2SOImmNeg1_4__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_T2SOImmNeg }, },
  { 1430 /* sub */, ARM::SUBrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1430 /* sub */, ARM::SUBri, Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImm }, },
  { 1430 /* sub */, ARM::ADDri, Convert__Reg1_2__Reg1_3__ModImmNeg1_4__CondCode2_1__CCOut1_0, Feature_IsARM|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImmNeg }, },
  { 1430 /* sub */, ARM::SUBrsi, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedImm }, },
  { 1430 /* sub */, ARM::SUBrsr, Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedReg }, },
  { 1430 /* sub */, ARM::t2SUBrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_GPRnopc, MCK_rGPR }, },
  { 1430 /* sub */, ARM::t2SUBrs, Convert__Reg1_3__Reg1_4__RegShiftedImm2_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 1430 /* sub */, ARM::t2SUBri, Convert__Reg1_3__Reg1_4__T2SOImm1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_GPRnopc, MCK_T2SOImm }, },
  { 1430 /* sub */, ARM::t2ADDri, Convert__Reg1_3__Reg1_4__T2SOImmNeg1_5__CondCode2_1__CCOut1_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_GPRnopc, MCK_T2SOImmNeg }, },
  { 1434 /* subs */, ARM::t2SUBS_PC_LR, Convert__Imm0_2551_3__CondCode2_0, Feature_IsThumb2|Feature_IsNotMClass, { MCK_CondCode, MCK_PC, MCK_LR, MCK_Imm0_255 }, },
  { 1439 /* subw */, ARM::t2SUBri12, Convert__Reg1_1__Reg1_2__Imm0_40951_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_Imm0_4095 }, },
  { 1439 /* subw */, ARM::t2ADDri12, Convert__Reg1_1__Reg1_2__Imm0_4095Neg1_3__CondCode2_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_Imm0_4095Neg }, },
  { 1439 /* subw */, ARM::t2ADDri12, Convert__Reg1_1__Reg1_2__T2SOImmNeg1_3__CondCode2_0, Feature_IsThumb2|Feature_UseNegativeImmediates, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_T2SOImmNeg }, },
  { 1444 /* svc */, ARM::tSVC, Convert__Imm0_2551_1__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_Imm0_255 }, },
  { 1444 /* svc */, ARM::SVC, Convert__Imm24bit1_1__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_Imm24bit }, },
  { 1448 /* swp */, ARM::SWP, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, Feature_IsARM|Feature_PreV8, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_MemNoOffset }, },
  { 1452 /* swpb */, ARM::SWPB, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, Feature_IsARM|Feature_PreV8, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_MemNoOffset }, },
  { 1457 /* sxtab */, ARM::t2SXTAB, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, Feature_HasDSP|Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1457 /* sxtab */, ARM::SXTAB, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc }, },
  { 1457 /* sxtab */, ARM::t2SXTAB, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, Feature_HasDSP|Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1457 /* sxtab */, ARM::SXTAB, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc, MCK_RotImm }, },
  { 1463 /* sxtab16 */, ARM::t2SXTAB16, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, Feature_HasDSP|Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1463 /* sxtab16 */, ARM::SXTAB16, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc }, },
  { 1463 /* sxtab16 */, ARM::t2SXTAB16, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, Feature_HasDSP|Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1463 /* sxtab16 */, ARM::SXTAB16, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc, MCK_RotImm }, },
  { 1471 /* sxtah */, ARM::t2SXTAH, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, Feature_HasDSP|Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1471 /* sxtah */, ARM::SXTAH, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc }, },
  { 1471 /* sxtah */, ARM::t2SXTAH, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, Feature_HasDSP|Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1471 /* sxtah */, ARM::SXTAH, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc, MCK_RotImm }, },
  { 1477 /* sxtb */, ARM::tSXTB, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb|Feature_HasV6, { MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 1477 /* sxtb */, ARM::t2SXTB, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 1477 /* sxtb */, ARM::SXTB, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1477 /* sxtb */, ARM::t2SXTB, Convert__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 1477 /* sxtb */, ARM::t2SXTB, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1477 /* sxtb */, ARM::SXTB, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_RotImm }, },
  { 1477 /* sxtb */, ARM::t2SXTB, Convert__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1482 /* sxtb16 */, ARM::t2SXTB16, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, Feature_HasDSP|Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 1482 /* sxtb16 */, ARM::SXTB16, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1482 /* sxtb16 */, ARM::t2SXTB16, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, Feature_HasDSP|Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1482 /* sxtb16 */, ARM::t2SXTB16, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, Feature_HasDSP|Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1482 /* sxtb16 */, ARM::SXTB16, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_RotImm }, },
  { 1489 /* sxth */, ARM::tSXTH, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb|Feature_HasV6, { MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 1489 /* sxth */, ARM::t2SXTH, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 1489 /* sxth */, ARM::SXTH, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1489 /* sxth */, ARM::t2SXTH, Convert__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 1489 /* sxth */, ARM::t2SXTH, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1489 /* sxth */, ARM::SXTH, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_RotImm }, },
  { 1489 /* sxth */, ARM::t2SXTH, Convert__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1494 /* tbb */, ARM::t2TBB, Convert__MemTBB2_1__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_MemTBB }, },
  { 1498 /* tbh */, ARM::t2TBH, Convert__MemTBH2_1__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_MemTBH }, },
  { 1502 /* teq */, ARM::t2TEQrr, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_rGPR }, },
  { 1502 /* teq */, ARM::t2TEQrs, Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 1502 /* teq */, ARM::TEQrsr, Convert__Reg1_1__RegShiftedReg3_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedReg }, },
  { 1502 /* teq */, ARM::t2TEQri, Convert__Reg1_1__T2SOImm1_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_T2SOImm }, },
  { 1502 /* teq */, ARM::TEQrr, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 1502 /* teq */, ARM::TEQri, Convert__Reg1_1__ModImm1_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 1502 /* teq */, ARM::TEQrsi, Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 1502 /* teq */, ARM::t2TEQrr, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_rGPR }, },
  { 1502 /* teq */, ARM::t2TEQrs, Convert__Reg1_2__RegShiftedImm2_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 1502 /* teq */, ARM::t2TEQri, Convert__Reg1_2__T2SOImm1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_T2SOImm }, },
  { 1506 /* trap */, ARM::TRAPNaCl, Convert_NoOperands, Feature_IsARM|Feature_UseNaClTrap, {  }, },
  { 1506 /* trap */, ARM::TRAP, Convert_NoOperands, Feature_IsARM, {  }, },
  { 1506 /* trap */, ARM::tTRAP, Convert_NoOperands, Feature_IsThumb, {  }, },
  { 1511 /* tsb */, ARM::TSB, Convert__TraceSyncBarrierOpt1_0, Feature_IsARM|Feature_HasV8_4a, { MCK_TraceSyncBarrierOpt }, },
  { 1511 /* tsb */, ARM::t2TSB, Convert__TraceSyncBarrierOpt1_1__CondCode2_0, Feature_IsThumb|Feature_HasV8_4a, { MCK_CondCode, MCK_TraceSyncBarrierOpt }, },
  { 1515 /* tst */, ARM::tTST, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 1515 /* tst */, ARM::t2TSTrr, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_rGPR }, },
  { 1515 /* tst */, ARM::t2TSTrs, Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 1515 /* tst */, ARM::TSTrsr, Convert__Reg1_1__RegShiftedReg3_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedReg }, },
  { 1515 /* tst */, ARM::t2TSTri, Convert__Reg1_1__T2SOImm1_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_T2SOImm }, },
  { 1515 /* tst */, ARM::TSTrr, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 1515 /* tst */, ARM::TSTri, Convert__Reg1_1__ModImm1_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 1515 /* tst */, ARM::TSTrsi, Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 1515 /* tst */, ARM::t2TSTrr, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_rGPR }, },
  { 1515 /* tst */, ARM::t2TSTrs, Convert__Reg1_2__RegShiftedImm2_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 1515 /* tst */, ARM::t2TSTri, Convert__Reg1_2__T2SOImm1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_T2SOImm }, },
  { 1519 /* tt */, ARM::t2TT, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb|Feature_Has8MSecExt, { MCK_CondCode, MCK_rGPR, MCK_GPRnopc }, },
  { 1522 /* tta */, ARM::t2TTA, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb|Feature_Has8MSecExt, { MCK_CondCode, MCK_rGPR, MCK_GPRnopc }, },
  { 1526 /* ttat */, ARM::t2TTAT, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb|Feature_Has8MSecExt, { MCK_CondCode, MCK_rGPR, MCK_GPRnopc }, },
  { 1531 /* ttt */, ARM::t2TTT, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb|Feature_Has8MSecExt, { MCK_CondCode, MCK_rGPR, MCK_GPRnopc }, },
  { 1535 /* uadd16 */, ARM::t2UADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1535 /* uadd16 */, ARM::UADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1542 /* uadd8 */, ARM::t2UADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1542 /* uadd8 */, ARM::UADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1548 /* uasx */, ARM::t2UASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1548 /* uasx */, ARM::UASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1553 /* ubfx */, ARM::t2UBFX, Convert__Reg1_1__Reg1_2__Imm0_311_3__Imm1_321_4__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_Imm0_31, MCK_Imm1_32 }, },
  { 1553 /* ubfx */, ARM::UBFX, Convert__Reg1_1__Reg1_2__Imm0_311_3__Imm1_321_4__CondCode2_0, Feature_IsARM|Feature_HasV6T2, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_Imm0_31, MCK_Imm1_32 }, },
  { 1558 /* udf */, ARM::tUDF, Convert__Imm0_2551_0, Feature_IsThumb, { MCK_Imm0_255 }, },
  { 1558 /* udf */, ARM::UDF, Convert__Imm0_655351_0, Feature_IsARM, { MCK_Imm0_65535 }, },
  { 1558 /* udf */, ARM::t2UDF, Convert__Imm0_655351_1, Feature_IsThumb2, { MCK__DOT_w, MCK_Imm0_65535 }, },
  { 1562 /* udiv */, ARM::t2UDIV, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasDivideInThumb|Feature_IsThumb|Feature_HasV8MBaseline, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1562 /* udiv */, ARM::UDIV, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM|Feature_HasDivideInARM, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1567 /* uhadd16 */, ARM::t2UHADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1567 /* uhadd16 */, ARM::UHADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1575 /* uhadd8 */, ARM::t2UHADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1575 /* uhadd8 */, ARM::UHADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1582 /* uhasx */, ARM::t2UHASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1582 /* uhasx */, ARM::UHASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1588 /* uhsax */, ARM::t2UHSAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1588 /* uhsax */, ARM::UHSAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1594 /* uhsub16 */, ARM::t2UHSUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1594 /* uhsub16 */, ARM::UHSUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1602 /* uhsub8 */, ARM::t2UHSUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1602 /* uhsub8 */, ARM::UHSUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1609 /* umaal */, ARM::t2UMAAL, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1609 /* umaal */, ARM::UMAAL, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1615 /* umlal */, ARM::t2UMLAL, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1615 /* umlal */, ARM::UMLAL, Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__Tie0_1_1__Tie1_1_1__CondCode2_1__CCOut1_0, Feature_IsARM|Feature_HasV6, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1615 /* umlal */, ARM::UMLAL, Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__Tie0_3_3__Tie1_4_4__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1621 /* umull */, ARM::t2UMULL, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1621 /* umull */, ARM::UMULL, Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, Feature_IsARM|Feature_HasV6, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1621 /* umull */, ARM::UMULL, Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, Feature_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1627 /* uqadd16 */, ARM::t2UQADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1627 /* uqadd16 */, ARM::UQADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1635 /* uqadd8 */, ARM::t2UQADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1635 /* uqadd8 */, ARM::UQADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1642 /* uqasx */, ARM::t2UQASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1642 /* uqasx */, ARM::UQASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1648 /* uqsax */, ARM::t2UQSAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1648 /* uqsax */, ARM::UQSAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1654 /* uqsub16 */, ARM::t2UQSUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1654 /* uqsub16 */, ARM::UQSUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1662 /* uqsub8 */, ARM::t2UQSUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1662 /* uqsub8 */, ARM::UQSUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1669 /* usad8 */, ARM::t2USAD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1669 /* usad8 */, ARM::USAD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1675 /* usada8 */, ARM::t2USADA8, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1675 /* usada8 */, ARM::USADA8, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1682 /* usat */, ARM::t2USAT, Convert__Reg1_1__Imm0_311_2__Reg1_3__imm_95_0__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Imm0_31, MCK_rGPR }, },
  { 1682 /* usat */, ARM::USAT, Convert__Reg1_1__Imm0_311_2__Reg1_3__imm_95_0__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_Imm0_31, MCK_GPRnopc }, },
  { 1682 /* usat */, ARM::t2USAT, Convert__Reg1_1__Imm0_311_2__Reg1_3__ShifterImm1_4__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Imm0_31, MCK_rGPR, MCK_ShifterImm }, },
  { 1682 /* usat */, ARM::USAT, Convert__Reg1_1__Imm0_311_2__Reg1_3__ShifterImm1_4__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_Imm0_31, MCK_GPRnopc, MCK_ShifterImm }, },
  { 1687 /* usat16 */, ARM::t2USAT16, Convert__Reg1_1__Imm0_151_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_Imm0_15, MCK_rGPR }, },
  { 1687 /* usat16 */, ARM::USAT16, Convert__Reg1_1__Imm0_151_2__Reg1_3__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_Imm0_15, MCK_GPRnopc }, },
  { 1694 /* usax */, ARM::t2USAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1694 /* usax */, ARM::USAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1699 /* usub16 */, ARM::t2USUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1699 /* usub16 */, ARM::USUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1706 /* usub8 */, ARM::t2USUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsThumb2|Feature_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1706 /* usub8 */, ARM::USUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1712 /* uxtab */, ARM::t2UXTAB, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, Feature_HasDSP|Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1712 /* uxtab */, ARM::UXTAB, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc }, },
  { 1712 /* uxtab */, ARM::t2UXTAB, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, Feature_HasDSP|Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1712 /* uxtab */, ARM::UXTAB, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc, MCK_RotImm }, },
  { 1718 /* uxtab16 */, ARM::t2UXTAB16, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, Feature_HasDSP|Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1718 /* uxtab16 */, ARM::UXTAB16, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc }, },
  { 1718 /* uxtab16 */, ARM::t2UXTAB16, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, Feature_HasDSP|Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1718 /* uxtab16 */, ARM::UXTAB16, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc, MCK_RotImm }, },
  { 1726 /* uxtah */, ARM::t2UXTAH, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, Feature_HasDSP|Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1726 /* uxtah */, ARM::UXTAH, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc }, },
  { 1726 /* uxtah */, ARM::t2UXTAH, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, Feature_HasDSP|Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1726 /* uxtah */, ARM::UXTAH, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc, MCK_RotImm }, },
  { 1732 /* uxtb */, ARM::tUXTB, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb|Feature_HasV6, { MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 1732 /* uxtb */, ARM::t2UXTB, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 1732 /* uxtb */, ARM::UXTB, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1732 /* uxtb */, ARM::t2UXTB, Convert__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 1732 /* uxtb */, ARM::t2UXTB, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1732 /* uxtb */, ARM::UXTB, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_RotImm }, },
  { 1732 /* uxtb */, ARM::t2UXTB, Convert__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1737 /* uxtb16 */, ARM::t2UXTB16, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, Feature_HasDSP|Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 1737 /* uxtb16 */, ARM::UXTB16, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1737 /* uxtb16 */, ARM::t2UXTB16, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, Feature_HasDSP|Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1737 /* uxtb16 */, ARM::t2UXTB16, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, Feature_HasDSP|Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1737 /* uxtb16 */, ARM::UXTB16, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_RotImm }, },
  { 1744 /* uxth */, ARM::tUXTH, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_IsThumb|Feature_HasV6, { MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 1744 /* uxth */, ARM::t2UXTH, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 1744 /* uxth */, ARM::UXTH, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, Feature_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1744 /* uxth */, ARM::t2UXTH, Convert__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 1744 /* uxth */, ARM::t2UXTH, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1744 /* uxth */, ARM::UXTH, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, Feature_IsARM|Feature_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_RotImm }, },
  { 1744 /* uxth */, ARM::t2UXTH, Convert__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1749 /* vaba */, ARM::VABAsv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1749 /* vaba */, ARM::VABAsv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1749 /* vaba */, ARM::VABAsv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1749 /* vaba */, ARM::VABAsv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1749 /* vaba */, ARM::VABAsv16i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1749 /* vaba */, ARM::VABAsv8i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1749 /* vaba */, ARM::VABAuv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1749 /* vaba */, ARM::VABAuv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1749 /* vaba */, ARM::VABAuv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1749 /* vaba */, ARM::VABAuv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1749 /* vaba */, ARM::VABAuv16i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1749 /* vaba */, ARM::VABAuv8i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1754 /* vabal */, ARM::VABALsv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 1754 /* vabal */, ARM::VABALsv2i64, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 1754 /* vabal */, ARM::VABALsv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 1754 /* vabal */, ARM::VABALuv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 1754 /* vabal */, ARM::VABALuv2i64, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 1754 /* vabal */, ARM::VABALuv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 1760 /* vabd */, ARM::VABDsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 1760 /* vabd */, ARM::VABDsv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 1760 /* vabd */, ARM::VABDsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 1760 /* vabd */, ARM::VABDsv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 1760 /* vabd */, ARM::VABDsv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 1760 /* vabd */, ARM::VABDsv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 1760 /* vabd */, ARM::VABDuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 1760 /* vabd */, ARM::VABDuv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 1760 /* vabd */, ARM::VABDuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 1760 /* vabd */, ARM::VABDuv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 1760 /* vabd */, ARM::VABDuv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR }, },
  { 1760 /* vabd */, ARM::VABDuv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 1760 /* vabd */, ARM::VABDfq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 1760 /* vabd */, ARM::VABDfd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 1760 /* vabd */, ARM::VABDhq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 1760 /* vabd */, ARM::VABDhd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 1760 /* vabd */, ARM::VABDsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1760 /* vabd */, ARM::VABDsv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1760 /* vabd */, ARM::VABDsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1760 /* vabd */, ARM::VABDsv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1760 /* vabd */, ARM::VABDsv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1760 /* vabd */, ARM::VABDsv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1760 /* vabd */, ARM::VABDuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1760 /* vabd */, ARM::VABDuv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1760 /* vabd */, ARM::VABDuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1760 /* vabd */, ARM::VABDuv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1760 /* vabd */, ARM::VABDuv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1760 /* vabd */, ARM::VABDuv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1760 /* vabd */, ARM::VABDfq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1760 /* vabd */, ARM::VABDfd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1760 /* vabd */, ARM::VABDhq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1760 /* vabd */, ARM::VABDhd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1765 /* vabdl */, ARM::VABDLsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 1765 /* vabdl */, ARM::VABDLsv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 1765 /* vabdl */, ARM::VABDLsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 1765 /* vabdl */, ARM::VABDLuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 1765 /* vabdl */, ARM::VABDLuv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 1765 /* vabdl */, ARM::VABDLuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 1771 /* vabs */, ARM::VABSv8i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 1771 /* vabs */, ARM::VABSv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 1771 /* vabs */, ARM::VABSv4i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 1771 /* vabs */, ARM::VABSv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 1771 /* vabs */, ARM::VABSv16i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 1771 /* vabs */, ARM::VABSv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 1771 /* vabs */, ARM::VABSfq, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 1771 /* vabs */, ARM::VABSfd, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 1771 /* vabs */, ARM::VABSS, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 1771 /* vabs */, ARM::VABSD, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 1771 /* vabs */, ARM::VABShq, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 1771 /* vabs */, ARM::VABShd, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 1771 /* vabs */, ARM::VABSH, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 1776 /* vacge */, ARM::VACGEfq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 1776 /* vacge */, ARM::VACGEfd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 1776 /* vacge */, ARM::VACGEhq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 1776 /* vacge */, ARM::VACGEhd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 1776 /* vacge */, ARM::VACGEfq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1776 /* vacge */, ARM::VACGEfd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1776 /* vacge */, ARM::VACGEhq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1776 /* vacge */, ARM::VACGEhd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1782 /* vacgt */, ARM::VACGTfq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 1782 /* vacgt */, ARM::VACGTfd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 1782 /* vacgt */, ARM::VACGThq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 1782 /* vacgt */, ARM::VACGThd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 1782 /* vacgt */, ARM::VACGTfq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1782 /* vacgt */, ARM::VACGTfd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1782 /* vacgt */, ARM::VACGThq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1782 /* vacgt */, ARM::VACGThd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1788 /* vacle */, ARM::VACGEfq, Convert__Reg1_2__Reg1_3__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 1788 /* vacle */, ARM::VACGEfd, Convert__Reg1_2__Reg1_3__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 1788 /* vacle */, ARM::VACGEhq, Convert__Reg1_2__Reg1_3__Reg1_2__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 1788 /* vacle */, ARM::VACGEhd, Convert__Reg1_2__Reg1_3__Reg1_2__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 1788 /* vacle */, ARM::VACGEfq, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1788 /* vacle */, ARM::VACGEfd, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1788 /* vacle */, ARM::VACGEhq, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1788 /* vacle */, ARM::VACGEhd, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1794 /* vaclt */, ARM::VACGTfq, Convert__Reg1_2__Reg1_3__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 1794 /* vaclt */, ARM::VACGTfd, Convert__Reg1_2__Reg1_3__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 1794 /* vaclt */, ARM::VACGThq, Convert__Reg1_2__Reg1_3__Reg1_2__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 1794 /* vaclt */, ARM::VACGThd, Convert__Reg1_2__Reg1_3__Reg1_2__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 1794 /* vaclt */, ARM::VACGTfq, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1794 /* vaclt */, ARM::VACGTfd, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1794 /* vaclt */, ARM::VACGThq, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1794 /* vaclt */, ARM::VACGThd, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1800 /* vadd */, ARM::VADDfq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 1800 /* vadd */, ARM::VADDfd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 1800 /* vadd */, ARM::VADDS, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 1800 /* vadd */, ARM::VADDD, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 1800 /* vadd */, ARM::VADDv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR }, },
  { 1800 /* vadd */, ARM::VADDv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR }, },
  { 1800 /* vadd */, ARM::VADDv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR }, },
  { 1800 /* vadd */, ARM::VADDv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR }, },
  { 1800 /* vadd */, ARM::VADDv2i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_QPR, MCK_QPR }, },
  { 1800 /* vadd */, ARM::VADDv1i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_DPR, MCK_DPR }, },
  { 1800 /* vadd */, ARM::VADDv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK_QPR }, },
  { 1800 /* vadd */, ARM::VADDv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_DPR }, },
  { 1800 /* vadd */, ARM::VADDhq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 1800 /* vadd */, ARM::VADDhd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 1800 /* vadd */, ARM::VADDH, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 1800 /* vadd */, ARM::VADDfq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1800 /* vadd */, ARM::VADDfd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1800 /* vadd */, ARM::VADDS, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 1800 /* vadd */, ARM::VADDD, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1800 /* vadd */, ARM::VADDv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1800 /* vadd */, ARM::VADDv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1800 /* vadd */, ARM::VADDv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1800 /* vadd */, ARM::VADDv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1800 /* vadd */, ARM::VADDv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1800 /* vadd */, ARM::VADDv1i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1800 /* vadd */, ARM::VADDv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1800 /* vadd */, ARM::VADDv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1800 /* vadd */, ARM::VADDhq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1800 /* vadd */, ARM::VADDhd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1800 /* vadd */, ARM::VADDH, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 1805 /* vaddhn */, ARM::VADDHNv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_QPR, MCK_QPR }, },
  { 1805 /* vaddhn */, ARM::VADDHNv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_QPR, MCK_QPR }, },
  { 1805 /* vaddhn */, ARM::VADDHNv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_DPR, MCK_QPR, MCK_QPR }, },
  { 1812 /* vaddl */, ARM::VADDLsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 1812 /* vaddl */, ARM::VADDLsv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 1812 /* vaddl */, ARM::VADDLsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 1812 /* vaddl */, ARM::VADDLuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 1812 /* vaddl */, ARM::VADDLuv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 1812 /* vaddl */, ARM::VADDLuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 1818 /* vaddw */, ARM::VADDWsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR }, },
  { 1818 /* vaddw */, ARM::VADDWsv2i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR }, },
  { 1818 /* vaddw */, ARM::VADDWsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_DPR }, },
  { 1818 /* vaddw */, ARM::VADDWuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_DPR }, },
  { 1818 /* vaddw */, ARM::VADDWuv2i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_DPR }, },
  { 1818 /* vaddw */, ARM::VADDWuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_DPR }, },
  { 1818 /* vaddw */, ARM::VADDWsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_DPR }, },
  { 1818 /* vaddw */, ARM::VADDWsv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_DPR }, },
  { 1818 /* vaddw */, ARM::VADDWsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_DPR }, },
  { 1818 /* vaddw */, ARM::VADDWuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_DPR }, },
  { 1818 /* vaddw */, ARM::VADDWuv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_DPR }, },
  { 1818 /* vaddw */, ARM::VADDWuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_DPR }, },
  { 1824 /* vand */, ARM::VANDq, Convert__Reg1_1__Reg1_1__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR }, },
  { 1824 /* vand */, ARM::VANDd, Convert__Reg1_1__Reg1_1__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR }, },
  { 1824 /* vand */, ARM::VBICiv8i16, Convert__Reg1_2__NEONi16splatNot1_3__Tie0_3_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_NEONi16splatNot }, },
  { 1824 /* vand */, ARM::VBICiv4i16, Convert__Reg1_2__NEONi16splatNot1_3__Tie0_3_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_NEONi16splatNot }, },
  { 1824 /* vand */, ARM::VBICiv4i32, Convert__Reg1_2__NEONi32splatNot1_3__Tie0_3_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_NEONi32splatNot }, },
  { 1824 /* vand */, ARM::VBICiv2i32, Convert__Reg1_2__NEONi32splatNot1_3__Tie0_3_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_NEONi32splatNot }, },
  { 1824 /* vand */, ARM::VANDq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR }, },
  { 1824 /* vand */, ARM::VANDd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR }, },
  { 1824 /* vand */, ARM::VANDq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR }, },
  { 1824 /* vand */, ARM::VANDd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR }, },
  { 1824 /* vand */, ARM::VANDq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR }, },
  { 1824 /* vand */, ARM::VANDd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_DPR }, },
  { 1824 /* vand */, ARM::VANDq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 1824 /* vand */, ARM::VANDd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR }, },
  { 1824 /* vand */, ARM::VANDq, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1824 /* vand */, ARM::VANDd, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1824 /* vand */, ARM::VANDq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1824 /* vand */, ARM::VANDd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1824 /* vand */, ARM::VANDq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1824 /* vand */, ARM::VANDd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1824 /* vand */, ARM::VANDq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1824 /* vand */, ARM::VANDd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1824 /* vand */, ARM::VANDq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1824 /* vand */, ARM::VANDd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1829 /* vbic */, ARM::VBICq, Convert__Reg1_1__Reg1_1__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR }, },
  { 1829 /* vbic */, ARM::VBICd, Convert__Reg1_1__Reg1_1__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR }, },
  { 1829 /* vbic */, ARM::VBICiv8i16, Convert__Reg1_2__NEONi16splat1_3__Tie0_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_NEONi16splat }, },
  { 1829 /* vbic */, ARM::VBICiv4i16, Convert__Reg1_2__NEONi16splat1_3__Tie0_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_NEONi16splat }, },
  { 1829 /* vbic */, ARM::VBICiv4i32, Convert__Reg1_2__NEONi32splat1_3__Tie0_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_NEONi32splat }, },
  { 1829 /* vbic */, ARM::VBICiv2i32, Convert__Reg1_2__NEONi32splat1_3__Tie0_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_NEONi32splat }, },
  { 1829 /* vbic */, ARM::VBICq, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1829 /* vbic */, ARM::VBICd, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1829 /* vbic */, ARM::VBICq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1829 /* vbic */, ARM::VBICd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1829 /* vbic */, ARM::VBICq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1829 /* vbic */, ARM::VBICd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1829 /* vbic */, ARM::VBICq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1829 /* vbic */, ARM::VBICd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1829 /* vbic */, ARM::VBICq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1829 /* vbic */, ARM::VBICd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1834 /* vbif */, ARM::VBIFq, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1834 /* vbif */, ARM::VBIFd, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1834 /* vbif */, ARM::VBIFq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1834 /* vbif */, ARM::VBIFd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1834 /* vbif */, ARM::VBIFq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1834 /* vbif */, ARM::VBIFd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1834 /* vbif */, ARM::VBIFq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1834 /* vbif */, ARM::VBIFd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1834 /* vbif */, ARM::VBIFq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1834 /* vbif */, ARM::VBIFd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1839 /* vbit */, ARM::VBITq, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1839 /* vbit */, ARM::VBITd, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1839 /* vbit */, ARM::VBITq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1839 /* vbit */, ARM::VBITd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1839 /* vbit */, ARM::VBITq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1839 /* vbit */, ARM::VBITd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1839 /* vbit */, ARM::VBITq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1839 /* vbit */, ARM::VBITd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1839 /* vbit */, ARM::VBITq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1839 /* vbit */, ARM::VBITd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1844 /* vbsl */, ARM::VBSLq, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1844 /* vbsl */, ARM::VBSLd, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1844 /* vbsl */, ARM::VBSLq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1844 /* vbsl */, ARM::VBSLd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1844 /* vbsl */, ARM::VBSLq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1844 /* vbsl */, ARM::VBSLd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1844 /* vbsl */, ARM::VBSLq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1844 /* vbsl */, ARM::VBSLd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1844 /* vbsl */, ARM::VBSLq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1844 /* vbsl */, ARM::VBSLd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1849 /* vcadd */, ARM::VCADDv4f32, Convert__Reg1_1__Reg1_2__Reg1_3__ComplexRotationOdd1_4, Feature_HasNEON|Feature_HasV8_3a, { MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR, MCK_ComplexRotationOdd }, },
  { 1849 /* vcadd */, ARM::VCADDv2f32, Convert__Reg1_1__Reg1_2__Reg1_3__ComplexRotationOdd1_4, Feature_HasNEON|Feature_HasV8_3a, { MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR, MCK_ComplexRotationOdd }, },
  { 1849 /* vcadd */, ARM::VCADDv8f16, Convert__Reg1_1__Reg1_2__Reg1_3__ComplexRotationOdd1_4, Feature_HasNEON|Feature_HasV8_3a|Feature_HasFullFP16, { MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR, MCK_ComplexRotationOdd }, },
  { 1849 /* vcadd */, ARM::VCADDv4f16, Convert__Reg1_1__Reg1_2__Reg1_3__ComplexRotationOdd1_4, Feature_HasNEON|Feature_HasV8_3a|Feature_HasFullFP16, { MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR, MCK_ComplexRotationOdd }, },
  { 1855 /* vceq */, ARM::VCEQzv4f32, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK__35_0 }, },
  { 1855 /* vceq */, ARM::VCEQfq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 1855 /* vceq */, ARM::VCEQzv2f32, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK__35_0 }, },
  { 1855 /* vceq */, ARM::VCEQfd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 1855 /* vceq */, ARM::VCEQzv8i16, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK__35_0 }, },
  { 1855 /* vceq */, ARM::VCEQv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR }, },
  { 1855 /* vceq */, ARM::VCEQzv4i16, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK__35_0 }, },
  { 1855 /* vceq */, ARM::VCEQv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR }, },
  { 1855 /* vceq */, ARM::VCEQzv4i32, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK__35_0 }, },
  { 1855 /* vceq */, ARM::VCEQv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR }, },
  { 1855 /* vceq */, ARM::VCEQzv2i32, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK__35_0 }, },
  { 1855 /* vceq */, ARM::VCEQv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR }, },
  { 1855 /* vceq */, ARM::VCEQzv16i8, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK__35_0 }, },
  { 1855 /* vceq */, ARM::VCEQv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK_QPR }, },
  { 1855 /* vceq */, ARM::VCEQzv8i8, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK__35_0 }, },
  { 1855 /* vceq */, ARM::VCEQv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_DPR }, },
  { 1855 /* vceq */, ARM::VCEQzv8f16, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK__35_0 }, },
  { 1855 /* vceq */, ARM::VCEQhq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 1855 /* vceq */, ARM::VCEQzv4f16, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK__35_0 }, },
  { 1855 /* vceq */, ARM::VCEQhd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 1855 /* vceq */, ARM::VCEQzv4f32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1855 /* vceq */, ARM::VCEQfq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1855 /* vceq */, ARM::VCEQzv2f32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1855 /* vceq */, ARM::VCEQfd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1855 /* vceq */, ARM::VCEQzv8i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1855 /* vceq */, ARM::VCEQv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1855 /* vceq */, ARM::VCEQzv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1855 /* vceq */, ARM::VCEQv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1855 /* vceq */, ARM::VCEQzv4i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1855 /* vceq */, ARM::VCEQv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1855 /* vceq */, ARM::VCEQzv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1855 /* vceq */, ARM::VCEQv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1855 /* vceq */, ARM::VCEQzv16i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1855 /* vceq */, ARM::VCEQv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1855 /* vceq */, ARM::VCEQzv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1855 /* vceq */, ARM::VCEQv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1855 /* vceq */, ARM::VCEQzv8f16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1855 /* vceq */, ARM::VCEQhq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1855 /* vceq */, ARM::VCEQzv4f16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1855 /* vceq */, ARM::VCEQhd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1860 /* vcge */, ARM::VCGEzv8i16, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK__35_0 }, },
  { 1860 /* vcge */, ARM::VCGEsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 1860 /* vcge */, ARM::VCGEzv4i16, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK__35_0 }, },
  { 1860 /* vcge */, ARM::VCGEsv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 1860 /* vcge */, ARM::VCGEzv4i32, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK__35_0 }, },
  { 1860 /* vcge */, ARM::VCGEsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 1860 /* vcge */, ARM::VCGEzv2i32, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK__35_0 }, },
  { 1860 /* vcge */, ARM::VCGEsv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 1860 /* vcge */, ARM::VCGEzv16i8, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK__35_0 }, },
  { 1860 /* vcge */, ARM::VCGEsv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 1860 /* vcge */, ARM::VCGEzv8i8, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK__35_0 }, },
  { 1860 /* vcge */, ARM::VCGEsv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 1860 /* vcge */, ARM::VCGEuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 1860 /* vcge */, ARM::VCGEuv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 1860 /* vcge */, ARM::VCGEuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 1860 /* vcge */, ARM::VCGEuv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 1860 /* vcge */, ARM::VCGEuv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR }, },
  { 1860 /* vcge */, ARM::VCGEuv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 1860 /* vcge */, ARM::VCGEzv4f32, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK__35_0 }, },
  { 1860 /* vcge */, ARM::VCGEfq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 1860 /* vcge */, ARM::VCGEzv2f32, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK__35_0 }, },
  { 1860 /* vcge */, ARM::VCGEfd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 1860 /* vcge */, ARM::VCGEzv8f16, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK__35_0 }, },
  { 1860 /* vcge */, ARM::VCGEhq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 1860 /* vcge */, ARM::VCGEzv4f16, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK__35_0 }, },
  { 1860 /* vcge */, ARM::VCGEhd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 1860 /* vcge */, ARM::VCGEzv8i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1860 /* vcge */, ARM::VCGEsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1860 /* vcge */, ARM::VCGEzv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1860 /* vcge */, ARM::VCGEsv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1860 /* vcge */, ARM::VCGEzv4i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1860 /* vcge */, ARM::VCGEsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1860 /* vcge */, ARM::VCGEzv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1860 /* vcge */, ARM::VCGEsv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1860 /* vcge */, ARM::VCGEzv16i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1860 /* vcge */, ARM::VCGEsv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1860 /* vcge */, ARM::VCGEzv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1860 /* vcge */, ARM::VCGEsv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1860 /* vcge */, ARM::VCGEuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1860 /* vcge */, ARM::VCGEuv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1860 /* vcge */, ARM::VCGEuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1860 /* vcge */, ARM::VCGEuv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1860 /* vcge */, ARM::VCGEuv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1860 /* vcge */, ARM::VCGEuv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1860 /* vcge */, ARM::VCGEzv4f32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1860 /* vcge */, ARM::VCGEfq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1860 /* vcge */, ARM::VCGEzv2f32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1860 /* vcge */, ARM::VCGEfd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1860 /* vcge */, ARM::VCGEzv8f16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1860 /* vcge */, ARM::VCGEhq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1860 /* vcge */, ARM::VCGEzv4f16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1860 /* vcge */, ARM::VCGEhd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1865 /* vcgt */, ARM::VCGTzv8i16, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK__35_0 }, },
  { 1865 /* vcgt */, ARM::VCGTsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 1865 /* vcgt */, ARM::VCGTzv4i16, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK__35_0 }, },
  { 1865 /* vcgt */, ARM::VCGTsv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 1865 /* vcgt */, ARM::VCGTzv4i32, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK__35_0 }, },
  { 1865 /* vcgt */, ARM::VCGTsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 1865 /* vcgt */, ARM::VCGTzv2i32, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK__35_0 }, },
  { 1865 /* vcgt */, ARM::VCGTsv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 1865 /* vcgt */, ARM::VCGTzv16i8, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK__35_0 }, },
  { 1865 /* vcgt */, ARM::VCGTsv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 1865 /* vcgt */, ARM::VCGTzv8i8, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK__35_0 }, },
  { 1865 /* vcgt */, ARM::VCGTsv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 1865 /* vcgt */, ARM::VCGTuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 1865 /* vcgt */, ARM::VCGTuv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 1865 /* vcgt */, ARM::VCGTuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 1865 /* vcgt */, ARM::VCGTuv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 1865 /* vcgt */, ARM::VCGTuv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR }, },
  { 1865 /* vcgt */, ARM::VCGTuv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 1865 /* vcgt */, ARM::VCGTzv4f32, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK__35_0 }, },
  { 1865 /* vcgt */, ARM::VCGTfq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 1865 /* vcgt */, ARM::VCGTzv2f32, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK__35_0 }, },
  { 1865 /* vcgt */, ARM::VCGTfd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 1865 /* vcgt */, ARM::VCGTzv8f16, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK__35_0 }, },
  { 1865 /* vcgt */, ARM::VCGThq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 1865 /* vcgt */, ARM::VCGTzv4f16, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK__35_0 }, },
  { 1865 /* vcgt */, ARM::VCGThd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 1865 /* vcgt */, ARM::VCGTzv8i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1865 /* vcgt */, ARM::VCGTsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1865 /* vcgt */, ARM::VCGTzv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1865 /* vcgt */, ARM::VCGTsv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1865 /* vcgt */, ARM::VCGTzv4i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1865 /* vcgt */, ARM::VCGTsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1865 /* vcgt */, ARM::VCGTzv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1865 /* vcgt */, ARM::VCGTsv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1865 /* vcgt */, ARM::VCGTzv16i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1865 /* vcgt */, ARM::VCGTsv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1865 /* vcgt */, ARM::VCGTzv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1865 /* vcgt */, ARM::VCGTsv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1865 /* vcgt */, ARM::VCGTuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1865 /* vcgt */, ARM::VCGTuv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1865 /* vcgt */, ARM::VCGTuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1865 /* vcgt */, ARM::VCGTuv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1865 /* vcgt */, ARM::VCGTuv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1865 /* vcgt */, ARM::VCGTuv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1865 /* vcgt */, ARM::VCGTzv4f32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1865 /* vcgt */, ARM::VCGTfq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1865 /* vcgt */, ARM::VCGTzv2f32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1865 /* vcgt */, ARM::VCGTfd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1865 /* vcgt */, ARM::VCGTzv8f16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1865 /* vcgt */, ARM::VCGThq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1865 /* vcgt */, ARM::VCGTzv4f16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1865 /* vcgt */, ARM::VCGThd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1870 /* vcle */, ARM::VCLEzv8i16, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK__35_0 }, },
  { 1870 /* vcle */, ARM::VCLEzv4i16, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK__35_0 }, },
  { 1870 /* vcle */, ARM::VCLEzv4i32, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK__35_0 }, },
  { 1870 /* vcle */, ARM::VCLEzv2i32, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK__35_0 }, },
  { 1870 /* vcle */, ARM::VCLEzv16i8, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK__35_0 }, },
  { 1870 /* vcle */, ARM::VCLEzv8i8, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK__35_0 }, },
  { 1870 /* vcle */, ARM::VCLEzv4f32, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK__35_0 }, },
  { 1870 /* vcle */, ARM::VCLEzv2f32, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK__35_0 }, },
  { 1870 /* vcle */, ARM::VCLEzv8f16, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK__35_0 }, },
  { 1870 /* vcle */, ARM::VCLEzv4f16, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK__35_0 }, },
  { 1870 /* vcle */, ARM::VCLEzv8i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1870 /* vcle */, ARM::VCGEsv8i16, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1870 /* vcle */, ARM::VCLEzv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1870 /* vcle */, ARM::VCGEsv4i16, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1870 /* vcle */, ARM::VCLEzv4i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1870 /* vcle */, ARM::VCGEsv4i32, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1870 /* vcle */, ARM::VCLEzv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1870 /* vcle */, ARM::VCGEsv2i32, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1870 /* vcle */, ARM::VCLEzv16i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1870 /* vcle */, ARM::VCGEsv16i8, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1870 /* vcle */, ARM::VCLEzv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1870 /* vcle */, ARM::VCGEsv8i8, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1870 /* vcle */, ARM::VCGEuv8i16, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1870 /* vcle */, ARM::VCGEuv4i16, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1870 /* vcle */, ARM::VCGEuv4i32, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1870 /* vcle */, ARM::VCGEuv2i32, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1870 /* vcle */, ARM::VCGEuv16i8, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1870 /* vcle */, ARM::VCGEuv8i8, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1870 /* vcle */, ARM::VCLEzv4f32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1870 /* vcle */, ARM::VCGEfq, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1870 /* vcle */, ARM::VCLEzv2f32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1870 /* vcle */, ARM::VCGEfd, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1870 /* vcle */, ARM::VCLEzv8f16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1870 /* vcle */, ARM::VCGEhq, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1870 /* vcle */, ARM::VCLEzv4f16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1870 /* vcle */, ARM::VCGEhd, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1875 /* vcls */, ARM::VCLSv8i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 1875 /* vcls */, ARM::VCLSv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 1875 /* vcls */, ARM::VCLSv4i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 1875 /* vcls */, ARM::VCLSv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 1875 /* vcls */, ARM::VCLSv16i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 1875 /* vcls */, ARM::VCLSv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 1880 /* vclt */, ARM::VCLTzv8i16, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK__35_0 }, },
  { 1880 /* vclt */, ARM::VCLTzv4i16, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK__35_0 }, },
  { 1880 /* vclt */, ARM::VCLTzv4i32, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK__35_0 }, },
  { 1880 /* vclt */, ARM::VCLTzv2i32, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK__35_0 }, },
  { 1880 /* vclt */, ARM::VCLTzv16i8, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK__35_0 }, },
  { 1880 /* vclt */, ARM::VCLTzv8i8, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK__35_0 }, },
  { 1880 /* vclt */, ARM::VCLTzv4f32, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK__35_0 }, },
  { 1880 /* vclt */, ARM::VCLTzv2f32, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK__35_0 }, },
  { 1880 /* vclt */, ARM::VCLTzv8f16, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK__35_0 }, },
  { 1880 /* vclt */, ARM::VCLTzv4f16, Convert__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK__35_0 }, },
  { 1880 /* vclt */, ARM::VCLTzv8i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1880 /* vclt */, ARM::VCGTsv8i16, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1880 /* vclt */, ARM::VCLTzv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1880 /* vclt */, ARM::VCGTsv4i16, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1880 /* vclt */, ARM::VCLTzv4i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1880 /* vclt */, ARM::VCGTsv4i32, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1880 /* vclt */, ARM::VCLTzv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1880 /* vclt */, ARM::VCGTsv2i32, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1880 /* vclt */, ARM::VCLTzv16i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1880 /* vclt */, ARM::VCGTsv16i8, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1880 /* vclt */, ARM::VCLTzv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1880 /* vclt */, ARM::VCGTsv8i8, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1880 /* vclt */, ARM::VCGTuv8i16, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1880 /* vclt */, ARM::VCGTuv4i16, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1880 /* vclt */, ARM::VCGTuv4i32, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1880 /* vclt */, ARM::VCGTuv2i32, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1880 /* vclt */, ARM::VCGTuv16i8, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1880 /* vclt */, ARM::VCGTuv8i8, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1880 /* vclt */, ARM::VCLTzv4f32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1880 /* vclt */, ARM::VCGTfq, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1880 /* vclt */, ARM::VCLTzv2f32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1880 /* vclt */, ARM::VCGTfd, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1880 /* vclt */, ARM::VCLTzv8f16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1880 /* vclt */, ARM::VCGThq, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1880 /* vclt */, ARM::VCLTzv4f16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1880 /* vclt */, ARM::VCGThd, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1885 /* vclz */, ARM::VCLZv8i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR }, },
  { 1885 /* vclz */, ARM::VCLZv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR }, },
  { 1885 /* vclz */, ARM::VCLZv4i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR }, },
  { 1885 /* vclz */, ARM::VCLZv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR }, },
  { 1885 /* vclz */, ARM::VCLZv16i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK_QPR }, },
  { 1885 /* vclz */, ARM::VCLZv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_DPR }, },
  { 1890 /* vcmla */, ARM::VCMLAv4f32, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__ComplexRotationEven1_4, Feature_HasNEON|Feature_HasV8_3a, { MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR, MCK_ComplexRotationEven }, },
  { 1890 /* vcmla */, ARM::VCMLAv2f32, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__ComplexRotationEven1_4, Feature_HasNEON|Feature_HasV8_3a, { MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR, MCK_ComplexRotationEven }, },
  { 1890 /* vcmla */, ARM::VCMLAv8f16, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__ComplexRotationEven1_4, Feature_HasNEON|Feature_HasV8_3a|Feature_HasFullFP16, { MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR, MCK_ComplexRotationEven }, },
  { 1890 /* vcmla */, ARM::VCMLAv4f16, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__ComplexRotationEven1_4, Feature_HasNEON|Feature_HasV8_3a|Feature_HasFullFP16, { MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR, MCK_ComplexRotationEven }, },
  { 1890 /* vcmla */, ARM::VCMLAv4f32_indexed, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__VectorIndex641_4__ComplexRotationEven1_5, Feature_HasNEON|Feature_HasV8_3a, { MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_DPR, MCK_VectorIndex64, MCK_ComplexRotationEven }, },
  { 1890 /* vcmla */, ARM::VCMLAv2f32_indexed, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__VectorIndex641_4__ComplexRotationEven1_5, Feature_HasNEON|Feature_HasV8_3a, { MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR, MCK_VectorIndex64, MCK_ComplexRotationEven }, },
  { 1890 /* vcmla */, ARM::VCMLAv8f16_indexed, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__VectorIndex321_4__ComplexRotationEven1_5, Feature_HasNEON|Feature_HasV8_3a|Feature_HasFullFP16, { MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_DPR_VFP2, MCK_VectorIndex32, MCK_ComplexRotationEven }, },
  { 1890 /* vcmla */, ARM::VCMLAv4f16_indexed, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__VectorIndex321_4__ComplexRotationEven1_5, Feature_HasNEON|Feature_HasV8_3a|Feature_HasFullFP16, { MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32, MCK_ComplexRotationEven }, },
  { 1896 /* vcmp */, ARM::VCMPZS, Convert__Reg1_2__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK__35_0 }, },
  { 1896 /* vcmp */, ARM::VCMPS, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 1896 /* vcmp */, ARM::VCMPZD, Convert__Reg1_2__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK__35_0 }, },
  { 1896 /* vcmp */, ARM::VCMPD, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 1896 /* vcmp */, ARM::VCMPZH, Convert__Reg1_2__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK__35_0 }, },
  { 1896 /* vcmp */, ARM::VCMPH, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 1901 /* vcmpe */, ARM::VCMPEZS, Convert__Reg1_2__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK__35_0 }, },
  { 1901 /* vcmpe */, ARM::VCMPES, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 1901 /* vcmpe */, ARM::VCMPEZD, Convert__Reg1_2__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK__35_0 }, },
  { 1901 /* vcmpe */, ARM::VCMPED, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 1901 /* vcmpe */, ARM::VCMPEZH, Convert__Reg1_2__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK__35_0 }, },
  { 1901 /* vcmpe */, ARM::VCMPEH, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 1907 /* vcnt */, ARM::VCNTq, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 1907 /* vcnt */, ARM::VCNTd, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR }, },
  { 1912 /* vcvt */, ARM::VCVTh2sq, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_s16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 1912 /* vcvt */, ARM::VCVTh2sd, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_s16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 1912 /* vcvt */, ARM::VCVTf2sq, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 1912 /* vcvt */, ARM::VCVTf2sd, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 1912 /* vcvt */, ARM::VTOSIZS, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 1912 /* vcvt */, ARM::VTOSIZD, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 1912 /* vcvt */, ARM::VTOSIZH, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 1912 /* vcvt */, ARM::VCVTh2uq, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_u16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 1912 /* vcvt */, ARM::VCVTh2ud, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_u16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 1912 /* vcvt */, ARM::VCVTf2uq, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 1912 /* vcvt */, ARM::VCVTf2ud, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 1912 /* vcvt */, ARM::VTOUIZS, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 1912 /* vcvt */, ARM::VTOUIZD, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 1912 /* vcvt */, ARM::VTOUIZH, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 1912 /* vcvt */, ARM::VCVTs2fq, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 1912 /* vcvt */, ARM::VCVTs2fd, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 1912 /* vcvt */, ARM::VSITOS, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_s32, MCK_HPR, MCK_HPR }, },
  { 1912 /* vcvt */, ARM::VCVTu2fq, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 1912 /* vcvt */, ARM::VCVTu2fd, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 1912 /* vcvt */, ARM::VUITOS, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_u32, MCK_HPR, MCK_HPR }, },
  { 1912 /* vcvt */, ARM::VCVTSD, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 1912 /* vcvt */, ARM::VCVTh2f, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFP16, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_f16, MCK_QPR, MCK_DPR }, },
  { 1912 /* vcvt */, ARM::VSITOD, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK__DOT_s32, MCK_DPR, MCK_HPR }, },
  { 1912 /* vcvt */, ARM::VUITOD, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK__DOT_u32, MCK_DPR, MCK_HPR }, },
  { 1912 /* vcvt */, ARM::VCVTDS, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK__DOT_f32, MCK_DPR, MCK_HPR }, },
  { 1912 /* vcvt */, ARM::VCVTs2hq, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 1912 /* vcvt */, ARM::VCVTs2hd, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 1912 /* vcvt */, ARM::VSITOH, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_s32, MCK_HPR, MCK_HPR }, },
  { 1912 /* vcvt */, ARM::VCVTu2hq, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 1912 /* vcvt */, ARM::VCVTu2hd, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 1912 /* vcvt */, ARM::VUITOH, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_u32, MCK_HPR, MCK_HPR }, },
  { 1912 /* vcvt */, ARM::VCVTf2h, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_f32, MCK_DPR, MCK_QPR }, },
  { 1912 /* vcvt */, ARM::VTOSHS, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_s16, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_FBits16 }, },
  { 1912 /* vcvt */, ARM::VTOSHD, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_s16, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_FBits16 }, },
  { 1912 /* vcvt */, ARM::VCVTh2sq, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1912 /* vcvt */, ARM::VCVTh2xsq, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_s16, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 1912 /* vcvt */, ARM::VCVTh2sd, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1912 /* vcvt */, ARM::VCVTh2xsd, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_s16, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 1912 /* vcvt */, ARM::VTOSHH, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_s16, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_FBits16 }, },
  { 1912 /* vcvt */, ARM::VCVTf2sq, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1912 /* vcvt */, ARM::VCVTf2xsq, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 1912 /* vcvt */, ARM::VCVTf2sd, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1912 /* vcvt */, ARM::VCVTf2xsd, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 1912 /* vcvt */, ARM::VTOSLS, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_FBits32 }, },
  { 1912 /* vcvt */, ARM::VTOSLD, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_FBits32 }, },
  { 1912 /* vcvt */, ARM::VTOSLH, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_FBits32 }, },
  { 1912 /* vcvt */, ARM::VTOUHS, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_u16, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_FBits16 }, },
  { 1912 /* vcvt */, ARM::VTOUHD, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_u16, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_FBits16 }, },
  { 1912 /* vcvt */, ARM::VCVTh2uq, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1912 /* vcvt */, ARM::VCVTh2xuq, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_u16, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 1912 /* vcvt */, ARM::VCVTh2ud, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1912 /* vcvt */, ARM::VCVTh2xud, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_u16, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 1912 /* vcvt */, ARM::VTOUHH, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_u16, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_FBits16 }, },
  { 1912 /* vcvt */, ARM::VCVTf2uq, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1912 /* vcvt */, ARM::VCVTf2xuq, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 1912 /* vcvt */, ARM::VCVTf2ud, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1912 /* vcvt */, ARM::VCVTf2xud, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 1912 /* vcvt */, ARM::VTOULS, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_FBits32 }, },
  { 1912 /* vcvt */, ARM::VTOULD, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_FBits32 }, },
  { 1912 /* vcvt */, ARM::VTOULH, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_FBits32 }, },
  { 1912 /* vcvt */, ARM::VSHTOS, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_s16, MCK_HPR, MCK_HPR, MCK_FBits16 }, },
  { 1912 /* vcvt */, ARM::VCVTs2fq, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1912 /* vcvt */, ARM::VCVTxs2fq, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 1912 /* vcvt */, ARM::VCVTs2fd, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1912 /* vcvt */, ARM::VCVTxs2fd, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 1912 /* vcvt */, ARM::VSLTOS, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_s32, MCK_HPR, MCK_HPR, MCK_FBits32 }, },
  { 1912 /* vcvt */, ARM::VUHTOS, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_u16, MCK_HPR, MCK_HPR, MCK_FBits16 }, },
  { 1912 /* vcvt */, ARM::VCVTu2fq, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1912 /* vcvt */, ARM::VCVTxu2fq, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 1912 /* vcvt */, ARM::VCVTu2fd, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1912 /* vcvt */, ARM::VCVTxu2fd, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 1912 /* vcvt */, ARM::VULTOS, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_u32, MCK_HPR, MCK_HPR, MCK_FBits32 }, },
  { 1912 /* vcvt */, ARM::VSHTOD, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_FBits16 }, },
  { 1912 /* vcvt */, ARM::VSLTOD, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_FBits32 }, },
  { 1912 /* vcvt */, ARM::VUHTOD, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_FBits16 }, },
  { 1912 /* vcvt */, ARM::VULTOD, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_FBits32 }, },
  { 1912 /* vcvt */, ARM::VCVTs2hq, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1912 /* vcvt */, ARM::VCVTxs2hq, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 1912 /* vcvt */, ARM::VCVTs2hd, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1912 /* vcvt */, ARM::VCVTxs2hd, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 1912 /* vcvt */, ARM::VSHTOH, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_s16, MCK_HPR, MCK_HPR, MCK_FBits16 }, },
  { 1912 /* vcvt */, ARM::VSLTOH, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_s32, MCK_HPR, MCK_HPR, MCK_FBits32 }, },
  { 1912 /* vcvt */, ARM::VCVTu2hq, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK__35_0 }, },
  { 1912 /* vcvt */, ARM::VCVTxu2hq, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 1912 /* vcvt */, ARM::VCVTu2hd, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK__35_0 }, },
  { 1912 /* vcvt */, ARM::VCVTxu2hd, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 1912 /* vcvt */, ARM::VUHTOH, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_u16, MCK_HPR, MCK_HPR, MCK_FBits16 }, },
  { 1912 /* vcvt */, ARM::VULTOH, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_u32, MCK_HPR, MCK_HPR, MCK_FBits32 }, },
  { 1917 /* vcvta */, ARM::VCVTANSQh, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_s16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 1917 /* vcvta */, ARM::VCVTANSDh, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_s16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 1917 /* vcvta */, ARM::VCVTANSQf, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON, { MCK__DOT_s32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 1917 /* vcvta */, ARM::VCVTANSDf, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON, { MCK__DOT_s32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 1917 /* vcvta */, ARM::VCVTASS, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8, { MCK__DOT_s32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 1917 /* vcvta */, ARM::VCVTASD, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK__DOT_s32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 1917 /* vcvta */, ARM::VCVTASH, Convert__Reg1_2__Reg1_3, Feature_HasFullFP16, { MCK__DOT_s32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 1917 /* vcvta */, ARM::VCVTANUQh, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_u16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 1917 /* vcvta */, ARM::VCVTANUDh, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_u16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 1917 /* vcvta */, ARM::VCVTANUQf, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON, { MCK__DOT_u32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 1917 /* vcvta */, ARM::VCVTANUDf, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON, { MCK__DOT_u32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 1917 /* vcvta */, ARM::VCVTAUS, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8, { MCK__DOT_u32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 1917 /* vcvta */, ARM::VCVTAUD, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK__DOT_u32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 1917 /* vcvta */, ARM::VCVTAUH, Convert__Reg1_2__Reg1_3, Feature_HasFullFP16, { MCK__DOT_u32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 1923 /* vcvtb */, ARM::VCVTBHS, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFP16, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 1923 /* vcvtb */, ARM::VCVTBHD, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK__DOT_f16, MCK_DPR, MCK_HPR }, },
  { 1923 /* vcvtb */, ARM::VCVTBSH, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 1923 /* vcvtb */, ARM::VCVTBDH, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 1929 /* vcvtm */, ARM::VCVTMNSQh, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_s16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 1929 /* vcvtm */, ARM::VCVTMNSDh, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_s16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 1929 /* vcvtm */, ARM::VCVTMNSQf, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON, { MCK__DOT_s32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 1929 /* vcvtm */, ARM::VCVTMNSDf, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON, { MCK__DOT_s32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 1929 /* vcvtm */, ARM::VCVTMSS, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8, { MCK__DOT_s32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 1929 /* vcvtm */, ARM::VCVTMSD, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK__DOT_s32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 1929 /* vcvtm */, ARM::VCVTMSH, Convert__Reg1_2__Reg1_3, Feature_HasFullFP16, { MCK__DOT_s32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 1929 /* vcvtm */, ARM::VCVTMNUQh, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_u16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 1929 /* vcvtm */, ARM::VCVTMNUDh, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_u16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 1929 /* vcvtm */, ARM::VCVTMNUQf, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON, { MCK__DOT_u32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 1929 /* vcvtm */, ARM::VCVTMNUDf, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON, { MCK__DOT_u32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 1929 /* vcvtm */, ARM::VCVTMUS, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8, { MCK__DOT_u32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 1929 /* vcvtm */, ARM::VCVTMUD, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK__DOT_u32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 1929 /* vcvtm */, ARM::VCVTMUH, Convert__Reg1_2__Reg1_3, Feature_HasFullFP16, { MCK__DOT_u32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 1935 /* vcvtn */, ARM::VCVTNNSQh, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_s16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 1935 /* vcvtn */, ARM::VCVTNNSDh, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_s16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 1935 /* vcvtn */, ARM::VCVTNNSQf, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON, { MCK__DOT_s32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 1935 /* vcvtn */, ARM::VCVTNNSDf, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON, { MCK__DOT_s32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 1935 /* vcvtn */, ARM::VCVTNSS, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8, { MCK__DOT_s32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 1935 /* vcvtn */, ARM::VCVTNSD, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK__DOT_s32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 1935 /* vcvtn */, ARM::VCVTNSH, Convert__Reg1_2__Reg1_3, Feature_HasFullFP16, { MCK__DOT_s32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 1935 /* vcvtn */, ARM::VCVTNNUQh, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_u16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 1935 /* vcvtn */, ARM::VCVTNNUDh, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_u16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 1935 /* vcvtn */, ARM::VCVTNNUQf, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON, { MCK__DOT_u32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 1935 /* vcvtn */, ARM::VCVTNNUDf, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON, { MCK__DOT_u32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 1935 /* vcvtn */, ARM::VCVTNUS, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8, { MCK__DOT_u32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 1935 /* vcvtn */, ARM::VCVTNUD, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK__DOT_u32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 1935 /* vcvtn */, ARM::VCVTNUH, Convert__Reg1_2__Reg1_3, Feature_HasFullFP16, { MCK__DOT_u32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 1941 /* vcvtp */, ARM::VCVTPNSQh, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_s16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 1941 /* vcvtp */, ARM::VCVTPNSDh, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_s16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 1941 /* vcvtp */, ARM::VCVTPNSQf, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON, { MCK__DOT_s32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 1941 /* vcvtp */, ARM::VCVTPNSDf, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON, { MCK__DOT_s32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 1941 /* vcvtp */, ARM::VCVTPSS, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8, { MCK__DOT_s32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 1941 /* vcvtp */, ARM::VCVTPSD, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK__DOT_s32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 1941 /* vcvtp */, ARM::VCVTPSH, Convert__Reg1_2__Reg1_3, Feature_HasFullFP16, { MCK__DOT_s32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 1941 /* vcvtp */, ARM::VCVTPNUQh, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_u16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 1941 /* vcvtp */, ARM::VCVTPNUDh, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_u16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 1941 /* vcvtp */, ARM::VCVTPNUQf, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON, { MCK__DOT_u32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 1941 /* vcvtp */, ARM::VCVTPNUDf, Convert__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON, { MCK__DOT_u32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 1941 /* vcvtp */, ARM::VCVTPUS, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8, { MCK__DOT_u32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 1941 /* vcvtp */, ARM::VCVTPUD, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK__DOT_u32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 1941 /* vcvtp */, ARM::VCVTPUH, Convert__Reg1_2__Reg1_3, Feature_HasFullFP16, { MCK__DOT_u32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 1947 /* vcvtr */, ARM::VTOSIRS, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 1947 /* vcvtr */, ARM::VTOSIRD, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 1947 /* vcvtr */, ARM::VTOSIRH, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 1947 /* vcvtr */, ARM::VTOUIRS, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 1947 /* vcvtr */, ARM::VTOUIRD, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 1947 /* vcvtr */, ARM::VTOUIRH, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 1953 /* vcvtt */, ARM::VCVTTHS, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFP16, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 1953 /* vcvtt */, ARM::VCVTTHD, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK__DOT_f16, MCK_DPR, MCK_HPR }, },
  { 1953 /* vcvtt */, ARM::VCVTTSH, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 1953 /* vcvtt */, ARM::VCVTTDH, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 1959 /* vdiv */, ARM::VDIVS, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 1959 /* vdiv */, ARM::VDIVD, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 1959 /* vdiv */, ARM::VDIVH, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 1959 /* vdiv */, ARM::VDIVS, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 1959 /* vdiv */, ARM::VDIVD, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1959 /* vdiv */, ARM::VDIVH, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 1964 /* vdup */, ARM::VDUP16q, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_GPR }, },
  { 1964 /* vdup */, ARM::VDUP16d, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_GPR }, },
  { 1964 /* vdup */, ARM::VDUP32q, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_GPR }, },
  { 1964 /* vdup */, ARM::VDUP32d, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_GPR }, },
  { 1964 /* vdup */, ARM::VDUP8q, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_GPR }, },
  { 1964 /* vdup */, ARM::VDUP8d, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_GPR }, },
  { 1964 /* vdup */, ARM::VDUPLN16q, Convert__Reg1_2__Reg1_3__VectorIndex161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_DPR, MCK_VectorIndex16 }, },
  { 1964 /* vdup */, ARM::VDUPLN16d, Convert__Reg1_2__Reg1_3__VectorIndex161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR, MCK_VectorIndex16 }, },
  { 1964 /* vdup */, ARM::VDUPLN32q, Convert__Reg1_2__Reg1_3__VectorIndex321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_DPR, MCK_VectorIndex32 }, },
  { 1964 /* vdup */, ARM::VDUPLN32d, Convert__Reg1_2__Reg1_3__VectorIndex321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR, MCK_VectorIndex32 }, },
  { 1964 /* vdup */, ARM::VDUPLN8q, Convert__Reg1_2__Reg1_3__VectorIndex81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_DPR, MCK_VectorIndex8 }, },
  { 1964 /* vdup */, ARM::VDUPLN8d, Convert__Reg1_2__Reg1_3__VectorIndex81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR, MCK_VectorIndex8 }, },
  { 1969 /* veor */, ARM::VEORq, Convert__Reg1_1__Reg1_1__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR }, },
  { 1969 /* veor */, ARM::VEORd, Convert__Reg1_1__Reg1_1__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR }, },
  { 1969 /* veor */, ARM::VEORq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR }, },
  { 1969 /* veor */, ARM::VEORd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR }, },
  { 1969 /* veor */, ARM::VEORq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR }, },
  { 1969 /* veor */, ARM::VEORd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR }, },
  { 1969 /* veor */, ARM::VEORq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR }, },
  { 1969 /* veor */, ARM::VEORd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_DPR }, },
  { 1969 /* veor */, ARM::VEORq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 1969 /* veor */, ARM::VEORd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR }, },
  { 1969 /* veor */, ARM::VEORq, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1969 /* veor */, ARM::VEORd, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1969 /* veor */, ARM::VEORq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1969 /* veor */, ARM::VEORd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1969 /* veor */, ARM::VEORq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1969 /* veor */, ARM::VEORd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1969 /* veor */, ARM::VEORq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1969 /* veor */, ARM::VEORd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1969 /* veor */, ARM::VEORq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1969 /* veor */, ARM::VEORd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1974 /* vext */, ARM::VEXTq16, Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_151_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR, MCK_Imm0_15 }, },
  { 1974 /* vext */, ARM::VEXTd16, Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_31_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR, MCK_Imm0_3 }, },
  { 1974 /* vext */, ARM::VEXTq32, Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_151_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_Imm0_15 }, },
  { 1974 /* vext */, ARM::VEXTd32, Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_11_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR, MCK_Imm0_1 }, },
  { 1974 /* vext */, ARM::VEXTq64, Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_151_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR, MCK_Imm0_15 }, },
  { 1974 /* vext */, ARM::VEXTq8, Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_151_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR, MCK_Imm0_15 }, },
  { 1974 /* vext */, ARM::VEXTd8, Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_71_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR, MCK_Imm0_7 }, },
  { 1974 /* vext */, ARM::VEXTq16, Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_151_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR, MCK_QPR, MCK_Imm0_15 }, },
  { 1974 /* vext */, ARM::VEXTd16, Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_31_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR, MCK_DPR, MCK_Imm0_3 }, },
  { 1974 /* vext */, ARM::VEXTq32, Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_151_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR, MCK_Imm0_15 }, },
  { 1974 /* vext */, ARM::VEXTd32, Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_11_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR, MCK_DPR, MCK_Imm0_1 }, },
  { 1974 /* vext */, ARM::VEXTq64, Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_151_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR, MCK_QPR, MCK_Imm0_15 }, },
  { 1974 /* vext */, ARM::VEXTq8, Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_151_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR, MCK_QPR, MCK_Imm0_15 }, },
  { 1974 /* vext */, ARM::VEXTd8, Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_71_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR, MCK_DPR, MCK_Imm0_7 }, },
  { 1979 /* vfma */, ARM::VFMAfq, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasVFP4, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1979 /* vfma */, ARM::VFMAfd, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasVFP4, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1979 /* vfma */, ARM::VFMAS, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP4, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 1979 /* vfma */, ARM::VFMAD, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP4|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1979 /* vfma */, ARM::VFMAhq, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1979 /* vfma */, ARM::VFMAhd, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1979 /* vfma */, ARM::VFMAH, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 1984 /* vfms */, ARM::VFMSfq, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasVFP4, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1984 /* vfms */, ARM::VFMSfd, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasVFP4, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1984 /* vfms */, ARM::VFMSS, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP4, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 1984 /* vfms */, ARM::VFMSD, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP4|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1984 /* vfms */, ARM::VFMShq, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1984 /* vfms */, ARM::VFMShd, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1984 /* vfms */, ARM::VFMSH, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 1989 /* vfnma */, ARM::VFNMAS, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP4, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 1989 /* vfnma */, ARM::VFNMAD, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP4|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1989 /* vfnma */, ARM::VFNMAH, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 1995 /* vfnms */, ARM::VFNMSS, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP4, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 1995 /* vfnms */, ARM::VFNMSD, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP4|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 1995 /* vfnms */, ARM::VFNMSH, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2001 /* vhadd */, ARM::VHADDsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2001 /* vhadd */, ARM::VHADDsv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2001 /* vhadd */, ARM::VHADDsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2001 /* vhadd */, ARM::VHADDsv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2001 /* vhadd */, ARM::VHADDsv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2001 /* vhadd */, ARM::VHADDsv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2001 /* vhadd */, ARM::VHADDuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 2001 /* vhadd */, ARM::VHADDuv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 2001 /* vhadd */, ARM::VHADDuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 2001 /* vhadd */, ARM::VHADDuv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2001 /* vhadd */, ARM::VHADDuv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR }, },
  { 2001 /* vhadd */, ARM::VHADDuv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 2001 /* vhadd */, ARM::VHADDsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2001 /* vhadd */, ARM::VHADDsv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2001 /* vhadd */, ARM::VHADDsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2001 /* vhadd */, ARM::VHADDsv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2001 /* vhadd */, ARM::VHADDsv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2001 /* vhadd */, ARM::VHADDsv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2001 /* vhadd */, ARM::VHADDuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2001 /* vhadd */, ARM::VHADDuv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2001 /* vhadd */, ARM::VHADDuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2001 /* vhadd */, ARM::VHADDuv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2001 /* vhadd */, ARM::VHADDuv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2001 /* vhadd */, ARM::VHADDuv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2007 /* vhsub */, ARM::VHSUBsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2007 /* vhsub */, ARM::VHSUBsv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2007 /* vhsub */, ARM::VHSUBsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2007 /* vhsub */, ARM::VHSUBsv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2007 /* vhsub */, ARM::VHSUBsv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2007 /* vhsub */, ARM::VHSUBsv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2007 /* vhsub */, ARM::VHSUBuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 2007 /* vhsub */, ARM::VHSUBuv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 2007 /* vhsub */, ARM::VHSUBuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 2007 /* vhsub */, ARM::VHSUBuv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2007 /* vhsub */, ARM::VHSUBuv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR }, },
  { 2007 /* vhsub */, ARM::VHSUBuv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 2007 /* vhsub */, ARM::VHSUBsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2007 /* vhsub */, ARM::VHSUBsv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2007 /* vhsub */, ARM::VHSUBsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2007 /* vhsub */, ARM::VHSUBsv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2007 /* vhsub */, ARM::VHSUBsv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2007 /* vhsub */, ARM::VHSUBsv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2007 /* vhsub */, ARM::VHSUBuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2007 /* vhsub */, ARM::VHSUBuv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2007 /* vhsub */, ARM::VHSUBuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2007 /* vhsub */, ARM::VHSUBuv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2007 /* vhsub */, ARM::VHSUBuv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2007 /* vhsub */, ARM::VHSUBuv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2013 /* vins */, ARM::VINSH, Convert__Reg1_1__Reg1_2, Feature_HasFullFP16, { MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2018 /* vjcvt */, ARM::VJCVT, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFPARMv8|Feature_HasV8_3a, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 2024 /* vld1 */, ARM::VLD1DUPq16, Convert__VecListDPairAllLanes1_2__DupAlignedMemory162_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory16 }, },
  { 2024 /* vld1 */, ARM::VLD1q16, Convert__VecListDPair1_2__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPair, MCK_AlignedMemory64or128 }, },
  { 2024 /* vld1 */, ARM::VLD1d16Q, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2024 /* vld1 */, ARM::VLD1DUPd16, Convert__VecListOneDAllLanes1_2__DupAlignedMemory162_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneDAllLanes, MCK_DupAlignedMemory16 }, },
  { 2024 /* vld1 */, ARM::VLD1d16, Convert__VecListOneD1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneD, MCK_AlignedMemory64 }, },
  { 2024 /* vld1 */, ARM::VLD1LNdAsm_16, Convert__VecListOneDHWordIndexed2_2__AlignedMemory162_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneDHWordIndexed, MCK_AlignedMemory16 }, },
  { 2024 /* vld1 */, ARM::VLD1d16T, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeD, MCK_AlignedMemory64 }, },
  { 2024 /* vld1 */, ARM::VLD1DUPq32, Convert__VecListDPairAllLanes1_2__DupAlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory32 }, },
  { 2024 /* vld1 */, ARM::VLD1q32, Convert__VecListDPair1_2__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPair, MCK_AlignedMemory64or128 }, },
  { 2024 /* vld1 */, ARM::VLD1d32Q, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2024 /* vld1 */, ARM::VLD1DUPd32, Convert__VecListOneDAllLanes1_2__DupAlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneDAllLanes, MCK_DupAlignedMemory32 }, },
  { 2024 /* vld1 */, ARM::VLD1d32, Convert__VecListOneD1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneD, MCK_AlignedMemory64 }, },
  { 2024 /* vld1 */, ARM::VLD1LNdAsm_32, Convert__VecListOneDWordIndexed2_2__AlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneDWordIndexed, MCK_AlignedMemory32 }, },
  { 2024 /* vld1 */, ARM::VLD1d32T, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeD, MCK_AlignedMemory64 }, },
  { 2024 /* vld1 */, ARM::VLD1q64, Convert__VecListDPair1_2__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListDPair, MCK_AlignedMemory64or128 }, },
  { 2024 /* vld1 */, ARM::VLD1d64Q, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2024 /* vld1 */, ARM::VLD1d64, Convert__VecListOneD1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListOneD, MCK_AlignedMemory64 }, },
  { 2024 /* vld1 */, ARM::VLD1d64T, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListThreeD, MCK_AlignedMemory64 }, },
  { 2024 /* vld1 */, ARM::VLD1DUPq8, Convert__VecListDPairAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairAllLanes, MCK_DupAlignedMemoryNone }, },
  { 2024 /* vld1 */, ARM::VLD1q8, Convert__VecListDPair1_2__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPair, MCK_AlignedMemory64or128 }, },
  { 2024 /* vld1 */, ARM::VLD1d8Q, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2024 /* vld1 */, ARM::VLD1DUPd8, Convert__VecListOneDAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneDAllLanes, MCK_DupAlignedMemoryNone }, },
  { 2024 /* vld1 */, ARM::VLD1d8, Convert__VecListOneD1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneD, MCK_AlignedMemory64 }, },
  { 2024 /* vld1 */, ARM::VLD1LNdAsm_8, Convert__VecListOneDByteIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneDByteIndexed, MCK_AlignedMemoryNone }, },
  { 2024 /* vld1 */, ARM::VLD1d8T, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeD, MCK_AlignedMemory64 }, },
  { 2024 /* vld1 */, ARM::VLD1DUPq16wb_fixed, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory162_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory16, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1DUPq16wb_register, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory162_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory16, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1q16wb_fixed, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1q16wb_register, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1d16Qwb_fixed, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1d16Qwb_register, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1DUPd16wb_fixed, Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory162_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneDAllLanes, MCK_DupAlignedMemory16, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1DUPd16wb_register, Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory162_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneDAllLanes, MCK_DupAlignedMemory16, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1d16wb_fixed, Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1d16wb_register, Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1LNdWB_fixed_Asm_16, Convert__VecListOneDHWordIndexed2_2__AlignedMemory162_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneDHWordIndexed, MCK_AlignedMemory16, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1LNdWB_register_Asm_16, Convert__VecListOneDHWordIndexed2_2__AlignedMemory162_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneDHWordIndexed, MCK_AlignedMemory16, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1d16Twb_fixed, Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1d16Twb_register, Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1DUPq32wb_fixed, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory32, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1DUPq32wb_register, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory322_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory32, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1q32wb_fixed, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1q32wb_register, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1d32Qwb_fixed, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1d32Qwb_register, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1DUPd32wb_fixed, Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneDAllLanes, MCK_DupAlignedMemory32, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1DUPd32wb_register, Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory322_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneDAllLanes, MCK_DupAlignedMemory32, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1d32wb_fixed, Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1d32wb_register, Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1LNdWB_fixed_Asm_32, Convert__VecListOneDWordIndexed2_2__AlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneDWordIndexed, MCK_AlignedMemory32, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1LNdWB_register_Asm_32, Convert__VecListOneDWordIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneDWordIndexed, MCK_AlignedMemory32, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1d32Twb_fixed, Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1d32Twb_register, Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1q64wb_fixed, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1q64wb_register, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1d64Qwb_fixed, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1d64Qwb_register, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1d64wb_fixed, Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListOneD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1d64wb_register, Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListOneD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1d64Twb_fixed, Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListThreeD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1d64Twb_register, Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListThreeD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1DUPq8wb_fixed, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairAllLanes, MCK_DupAlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1DUPq8wb_register, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairAllLanes, MCK_DupAlignedMemoryNone, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1q8wb_fixed, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1q8wb_register, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1d8Qwb_fixed, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1d8Qwb_register, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1DUPd8wb_fixed, Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneDAllLanes, MCK_DupAlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1DUPd8wb_register, Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneDAllLanes, MCK_DupAlignedMemoryNone, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1d8wb_fixed, Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1d8wb_register, Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1LNdWB_fixed_Asm_8, Convert__VecListOneDByteIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneDByteIndexed, MCK_AlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1LNdWB_register_Asm_8, Convert__VecListOneDByteIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneDByteIndexed, MCK_AlignedMemoryNone, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1d8Twb_fixed, Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2024 /* vld1 */, ARM::VLD1d8Twb_register, Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2024 /* vld1 */, ARM::VLD1LNd16, Convert__Reg1_3__AlignedMemory2_8__Tie0_1_1__Imm1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK__91_, MCK_Imm, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2024 /* vld1 */, ARM::VLD1LNd8, Convert__Reg1_3__AlignedMemory2_8__Tie0_1_1__Imm1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK__91_, MCK_Imm, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2024 /* vld1 */, ARM::VLD1LNd16_UPD, Convert__Reg1_3__imm_95_0__AlignedMemory2_8__Imm1_9__Tie0_1_1__Imm1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK__91_, MCK_Imm, MCK__93_, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2024 /* vld1 */, ARM::VLD1LNd32, Convert__Reg1_3__Reg1_8__Imm1_9__Tie0_1_1__Imm1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK__91_, MCK_Imm, MCK__93_, MCK__125_, MCK_GPR, MCK_Imm }, },
  { 2024 /* vld1 */, ARM::VLD1LNd32_UPD, Convert__Reg1_3__imm_95_0__AlignedMemory2_8__Imm1_9__Tie0_1_1__Imm1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK__91_, MCK_Imm, MCK__93_, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2024 /* vld1 */, ARM::VLD1LNd8_UPD, Convert__Reg1_3__imm_95_0__AlignedMemory2_8__Imm1_9__Tie0_1_1__Imm1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK__91_, MCK_Imm, MCK__93_, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2029 /* vld2 */, ARM::VLD2DUPd16, Convert__VecListDPairAllLanes1_2__DupAlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory32 }, },
  { 2029 /* vld2 */, ARM::VLD2d16, Convert__VecListDPair1_2__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPair, MCK_AlignedMemory64or128 }, },
  { 2029 /* vld2 */, ARM::VLD2DUPd16x2, Convert__VecListDPairSpacedAllLanes1_2__DupAlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairSpacedAllLanes, MCK_DupAlignedMemory32 }, },
  { 2029 /* vld2 */, ARM::VLD2b16, Convert__VecListDPairSpaced1_2__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128 }, },
  { 2029 /* vld2 */, ARM::VLD2q16, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2029 /* vld2 */, ARM::VLD2LNdAsm_16, Convert__VecListTwoDHWordIndexed2_2__AlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListTwoDHWordIndexed, MCK_AlignedMemory32 }, },
  { 2029 /* vld2 */, ARM::VLD2LNqAsm_16, Convert__VecListTwoQHWordIndexed2_2__AlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListTwoQHWordIndexed, MCK_AlignedMemory32 }, },
  { 2029 /* vld2 */, ARM::VLD2DUPd32, Convert__VecListDPairAllLanes1_2__DupAlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory64 }, },
  { 2029 /* vld2 */, ARM::VLD2d32, Convert__VecListDPair1_2__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPair, MCK_AlignedMemory64or128 }, },
  { 2029 /* vld2 */, ARM::VLD2DUPd32x2, Convert__VecListDPairSpacedAllLanes1_2__DupAlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairSpacedAllLanes, MCK_DupAlignedMemory64 }, },
  { 2029 /* vld2 */, ARM::VLD2b32, Convert__VecListDPairSpaced1_2__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128 }, },
  { 2029 /* vld2 */, ARM::VLD2q32, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2029 /* vld2 */, ARM::VLD2LNdAsm_32, Convert__VecListTwoDWordIndexed2_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListTwoDWordIndexed, MCK_AlignedMemory64 }, },
  { 2029 /* vld2 */, ARM::VLD2LNqAsm_32, Convert__VecListTwoQWordIndexed2_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListTwoQWordIndexed, MCK_AlignedMemory64 }, },
  { 2029 /* vld2 */, ARM::VLD2DUPd8, Convert__VecListDPairAllLanes1_2__DupAlignedMemory162_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory16 }, },
  { 2029 /* vld2 */, ARM::VLD2d8, Convert__VecListDPair1_2__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPair, MCK_AlignedMemory64or128 }, },
  { 2029 /* vld2 */, ARM::VLD2DUPd8x2, Convert__VecListDPairSpacedAllLanes1_2__DupAlignedMemory162_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairSpacedAllLanes, MCK_DupAlignedMemory16 }, },
  { 2029 /* vld2 */, ARM::VLD2b8, Convert__VecListDPairSpaced1_2__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128 }, },
  { 2029 /* vld2 */, ARM::VLD2q8, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2029 /* vld2 */, ARM::VLD2LNdAsm_8, Convert__VecListTwoDByteIndexed2_2__AlignedMemory162_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListTwoDByteIndexed, MCK_AlignedMemory16 }, },
  { 2029 /* vld2 */, ARM::VLD2DUPd16wb_fixed, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory32, MCK__EXCLAIM_ }, },
  { 2029 /* vld2 */, ARM::VLD2DUPd16wb_register, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory322_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory32, MCK_rGPR }, },
  { 2029 /* vld2 */, ARM::VLD2d16wb_fixed, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2029 /* vld2 */, ARM::VLD2d16wb_register, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2029 /* vld2 */, ARM::VLD2DUPd16x2wb_fixed, Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairSpacedAllLanes, MCK_DupAlignedMemory32, MCK__EXCLAIM_ }, },
  { 2029 /* vld2 */, ARM::VLD2DUPd16x2wb_register, Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory322_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairSpacedAllLanes, MCK_DupAlignedMemory32, MCK_rGPR }, },
  { 2029 /* vld2 */, ARM::VLD2b16wb_fixed, Convert__VecListDPairSpaced1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2029 /* vld2 */, ARM::VLD2b16wb_register, Convert__VecListDPairSpaced1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2029 /* vld2 */, ARM::VLD2q16wb_fixed, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2029 /* vld2 */, ARM::VLD2q16wb_register, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2029 /* vld2 */, ARM::VLD2LNdWB_fixed_Asm_16, Convert__VecListTwoDHWordIndexed2_2__AlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListTwoDHWordIndexed, MCK_AlignedMemory32, MCK__EXCLAIM_ }, },
  { 2029 /* vld2 */, ARM::VLD2LNdWB_register_Asm_16, Convert__VecListTwoDHWordIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListTwoDHWordIndexed, MCK_AlignedMemory32, MCK_rGPR }, },
  { 2029 /* vld2 */, ARM::VLD2LNqWB_fixed_Asm_16, Convert__VecListTwoQHWordIndexed2_2__AlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListTwoQHWordIndexed, MCK_AlignedMemory32, MCK__EXCLAIM_ }, },
  { 2029 /* vld2 */, ARM::VLD2LNqWB_register_Asm_16, Convert__VecListTwoQHWordIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListTwoQHWordIndexed, MCK_AlignedMemory32, MCK_rGPR }, },
  { 2029 /* vld2 */, ARM::VLD2DUPd32wb_fixed, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory64, MCK__EXCLAIM_ }, },
  { 2029 /* vld2 */, ARM::VLD2DUPd32wb_register, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory64, MCK_rGPR }, },
  { 2029 /* vld2 */, ARM::VLD2d32wb_fixed, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2029 /* vld2 */, ARM::VLD2d32wb_register, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2029 /* vld2 */, ARM::VLD2DUPd32x2wb_fixed, Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairSpacedAllLanes, MCK_DupAlignedMemory64, MCK__EXCLAIM_ }, },
  { 2029 /* vld2 */, ARM::VLD2DUPd32x2wb_register, Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairSpacedAllLanes, MCK_DupAlignedMemory64, MCK_rGPR }, },
  { 2029 /* vld2 */, ARM::VLD2b32wb_fixed, Convert__VecListDPairSpaced1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2029 /* vld2 */, ARM::VLD2b32wb_register, Convert__VecListDPairSpaced1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2029 /* vld2 */, ARM::VLD2q32wb_fixed, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2029 /* vld2 */, ARM::VLD2q32wb_register, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2029 /* vld2 */, ARM::VLD2LNdWB_fixed_Asm_32, Convert__VecListTwoDWordIndexed2_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListTwoDWordIndexed, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2029 /* vld2 */, ARM::VLD2LNdWB_register_Asm_32, Convert__VecListTwoDWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListTwoDWordIndexed, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2029 /* vld2 */, ARM::VLD2LNqWB_fixed_Asm_32, Convert__VecListTwoQWordIndexed2_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListTwoQWordIndexed, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2029 /* vld2 */, ARM::VLD2LNqWB_register_Asm_32, Convert__VecListTwoQWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListTwoQWordIndexed, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2029 /* vld2 */, ARM::VLD2DUPd8wb_fixed, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory162_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory16, MCK__EXCLAIM_ }, },
  { 2029 /* vld2 */, ARM::VLD2DUPd8wb_register, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory162_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory16, MCK_rGPR }, },
  { 2029 /* vld2 */, ARM::VLD2d8wb_fixed, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2029 /* vld2 */, ARM::VLD2d8wb_register, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2029 /* vld2 */, ARM::VLD2DUPd8x2wb_fixed, Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory162_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairSpacedAllLanes, MCK_DupAlignedMemory16, MCK__EXCLAIM_ }, },
  { 2029 /* vld2 */, ARM::VLD2DUPd8x2wb_register, Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory162_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairSpacedAllLanes, MCK_DupAlignedMemory16, MCK_rGPR }, },
  { 2029 /* vld2 */, ARM::VLD2b8wb_fixed, Convert__VecListDPairSpaced1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2029 /* vld2 */, ARM::VLD2b8wb_register, Convert__VecListDPairSpaced1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2029 /* vld2 */, ARM::VLD2q8wb_fixed, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2029 /* vld2 */, ARM::VLD2q8wb_register, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2029 /* vld2 */, ARM::VLD2LNdWB_fixed_Asm_8, Convert__VecListTwoDByteIndexed2_2__AlignedMemory162_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListTwoDByteIndexed, MCK_AlignedMemory16, MCK__EXCLAIM_ }, },
  { 2029 /* vld2 */, ARM::VLD2LNdWB_register_Asm_8, Convert__VecListTwoDByteIndexed2_2__AlignedMemory162_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListTwoDByteIndexed, MCK_AlignedMemory16, MCK_rGPR }, },
  { 2034 /* vld3 */, ARM::VLD3DUPdAsm_16, Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeDAllLanes, MCK_DupAlignedMemoryNone }, },
  { 2034 /* vld3 */, ARM::VLD3dAsm_16, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeD, MCK_AlignedMemory64 }, },
  { 2034 /* vld3 */, ARM::VLD3LNdAsm_16, Convert__VecListThreeDHWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeDHWordIndexed, MCK_AlignedMemoryNone }, },
  { 2034 /* vld3 */, ARM::VLD3DUPqAsm_16, Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQAllLanes, MCK_DupAlignedMemoryNone }, },
  { 2034 /* vld3 */, ARM::VLD3qAsm_16, Convert__VecListThreeQ1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQ, MCK_AlignedMemory64 }, },
  { 2034 /* vld3 */, ARM::VLD3LNqAsm_16, Convert__VecListThreeQHWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQHWordIndexed, MCK_AlignedMemoryNone }, },
  { 2034 /* vld3 */, ARM::VLD3DUPdAsm_32, Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeDAllLanes, MCK_DupAlignedMemoryNone }, },
  { 2034 /* vld3 */, ARM::VLD3dAsm_32, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeD, MCK_AlignedMemory64 }, },
  { 2034 /* vld3 */, ARM::VLD3LNdAsm_32, Convert__VecListThreeDWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeDWordIndexed, MCK_AlignedMemoryNone }, },
  { 2034 /* vld3 */, ARM::VLD3DUPqAsm_32, Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQAllLanes, MCK_DupAlignedMemoryNone }, },
  { 2034 /* vld3 */, ARM::VLD3qAsm_32, Convert__VecListThreeQ1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQ, MCK_AlignedMemory64 }, },
  { 2034 /* vld3 */, ARM::VLD3LNqAsm_32, Convert__VecListThreeQWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQWordIndexed, MCK_AlignedMemoryNone }, },
  { 2034 /* vld3 */, ARM::VLD3DUPdAsm_8, Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeDAllLanes, MCK_DupAlignedMemoryNone }, },
  { 2034 /* vld3 */, ARM::VLD3dAsm_8, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeD, MCK_AlignedMemory64 }, },
  { 2034 /* vld3 */, ARM::VLD3LNdAsm_8, Convert__VecListThreeDByteIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeDByteIndexed, MCK_AlignedMemoryNone }, },
  { 2034 /* vld3 */, ARM::VLD3DUPqAsm_8, Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeQAllLanes, MCK_DupAlignedMemoryNone }, },
  { 2034 /* vld3 */, ARM::VLD3qAsm_8, Convert__VecListThreeQ1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeQ, MCK_AlignedMemory64 }, },
  { 2034 /* vld3 */, ARM::VLD3DUPdWB_fixed_Asm_16, Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeDAllLanes, MCK_DupAlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2034 /* vld3 */, ARM::VLD3DUPdWB_register_Asm_16, Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeDAllLanes, MCK_DupAlignedMemoryNone, MCK_rGPR }, },
  { 2034 /* vld3 */, ARM::VLD3dWB_fixed_Asm_16, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2034 /* vld3 */, ARM::VLD3dWB_register_Asm_16, Convert__VecListThreeD1_2__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2034 /* vld3 */, ARM::VLD3LNdWB_fixed_Asm_16, Convert__VecListThreeDHWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeDHWordIndexed, MCK_AlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2034 /* vld3 */, ARM::VLD3LNdWB_register_Asm_16, Convert__VecListThreeDHWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeDHWordIndexed, MCK_AlignedMemoryNone, MCK_rGPR }, },
  { 2034 /* vld3 */, ARM::VLD3DUPqWB_fixed_Asm_16, Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQAllLanes, MCK_DupAlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2034 /* vld3 */, ARM::VLD3DUPqWB_register_Asm_16, Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQAllLanes, MCK_DupAlignedMemoryNone, MCK_rGPR }, },
  { 2034 /* vld3 */, ARM::VLD3qWB_fixed_Asm_16, Convert__VecListThreeQ1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQ, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2034 /* vld3 */, ARM::VLD3qWB_register_Asm_16, Convert__VecListThreeQ1_2__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQ, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2034 /* vld3 */, ARM::VLD3LNqWB_fixed_Asm_16, Convert__VecListThreeQHWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQHWordIndexed, MCK_AlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2034 /* vld3 */, ARM::VLD3LNqWB_register_Asm_16, Convert__VecListThreeQHWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQHWordIndexed, MCK_AlignedMemoryNone, MCK_rGPR }, },
  { 2034 /* vld3 */, ARM::VLD3DUPdWB_fixed_Asm_32, Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeDAllLanes, MCK_DupAlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2034 /* vld3 */, ARM::VLD3DUPdWB_register_Asm_32, Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeDAllLanes, MCK_DupAlignedMemoryNone, MCK_rGPR }, },
  { 2034 /* vld3 */, ARM::VLD3dWB_fixed_Asm_32, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2034 /* vld3 */, ARM::VLD3dWB_register_Asm_32, Convert__VecListThreeD1_2__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2034 /* vld3 */, ARM::VLD3LNdWB_fixed_Asm_32, Convert__VecListThreeDWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeDWordIndexed, MCK_AlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2034 /* vld3 */, ARM::VLD3LNdWB_register_Asm_32, Convert__VecListThreeDWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeDWordIndexed, MCK_AlignedMemoryNone, MCK_rGPR }, },
  { 2034 /* vld3 */, ARM::VLD3DUPqWB_fixed_Asm_32, Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQAllLanes, MCK_DupAlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2034 /* vld3 */, ARM::VLD3DUPqWB_register_Asm_32, Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQAllLanes, MCK_DupAlignedMemoryNone, MCK_rGPR }, },
  { 2034 /* vld3 */, ARM::VLD3qWB_fixed_Asm_32, Convert__VecListThreeQ1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQ, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2034 /* vld3 */, ARM::VLD3qWB_register_Asm_32, Convert__VecListThreeQ1_2__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQ, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2034 /* vld3 */, ARM::VLD3LNqWB_fixed_Asm_32, Convert__VecListThreeQWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQWordIndexed, MCK_AlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2034 /* vld3 */, ARM::VLD3LNqWB_register_Asm_32, Convert__VecListThreeQWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQWordIndexed, MCK_AlignedMemoryNone, MCK_rGPR }, },
  { 2034 /* vld3 */, ARM::VLD3DUPdWB_fixed_Asm_8, Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeDAllLanes, MCK_DupAlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2034 /* vld3 */, ARM::VLD3DUPdWB_register_Asm_8, Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeDAllLanes, MCK_DupAlignedMemoryNone, MCK_rGPR }, },
  { 2034 /* vld3 */, ARM::VLD3dWB_fixed_Asm_8, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2034 /* vld3 */, ARM::VLD3dWB_register_Asm_8, Convert__VecListThreeD1_2__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2034 /* vld3 */, ARM::VLD3LNdWB_fixed_Asm_8, Convert__VecListThreeDByteIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeDByteIndexed, MCK_AlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2034 /* vld3 */, ARM::VLD3LNdWB_register_Asm_8, Convert__VecListThreeDByteIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeDByteIndexed, MCK_AlignedMemoryNone, MCK_rGPR }, },
  { 2034 /* vld3 */, ARM::VLD3DUPqWB_fixed_Asm_8, Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeQAllLanes, MCK_DupAlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2034 /* vld3 */, ARM::VLD3DUPqWB_register_Asm_8, Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeQAllLanes, MCK_DupAlignedMemoryNone, MCK_rGPR }, },
  { 2034 /* vld3 */, ARM::VLD3qWB_fixed_Asm_8, Convert__VecListThreeQ1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeQ, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2034 /* vld3 */, ARM::VLD3qWB_register_Asm_8, Convert__VecListThreeQ1_2__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeQ, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2034 /* vld3 */, ARM::VLD3d16, Convert__Reg1_3__Reg1_4__Reg1_5__AlignedMemory2_7__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2034 /* vld3 */, ARM::VLD3q16, Convert__Reg1_3__Reg1_4__Reg1_5__AlignedMemory2_7__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2034 /* vld3 */, ARM::VLD3d32, Convert__Reg1_3__Reg1_4__Reg1_5__AlignedMemory2_7__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2034 /* vld3 */, ARM::VLD3q32, Convert__Reg1_3__Reg1_4__Reg1_5__AlignedMemory2_7__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2034 /* vld3 */, ARM::VLD3d8, Convert__Reg1_3__Reg1_4__Reg1_5__AlignedMemory2_7__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2034 /* vld3 */, ARM::VLD3q8, Convert__Reg1_3__Reg1_4__Reg1_5__AlignedMemory2_7__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2034 /* vld3 */, ARM::VLD3d16_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__imm_95_0__AlignedMemory2_7__Imm1_8__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2034 /* vld3 */, ARM::VLD3q16_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__imm_95_0__AlignedMemory2_7__Imm1_8__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2034 /* vld3 */, ARM::VLD3d32_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__imm_95_0__AlignedMemory2_7__Imm1_8__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2034 /* vld3 */, ARM::VLD3q32_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__imm_95_0__AlignedMemory2_7__Imm1_8__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2034 /* vld3 */, ARM::VLD3d8_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__imm_95_0__AlignedMemory2_7__Imm1_8__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2034 /* vld3 */, ARM::VLD3q8_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__imm_95_0__AlignedMemory2_7__Imm1_8__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2034 /* vld3 */, ARM::VLD3DUPd16, Convert__Reg1_3__Reg1_6__Reg1_9__AlignedMemory2_13__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2034 /* vld3 */, ARM::VLD3DUPq16, Convert__Reg1_3__Reg1_6__Reg1_9__AlignedMemory2_13__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2034 /* vld3 */, ARM::VLD3DUPd32, Convert__Reg1_3__Reg1_6__Reg1_9__AlignedMemory2_13__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2034 /* vld3 */, ARM::VLD3DUPq32, Convert__Reg1_3__Reg1_6__Reg1_9__AlignedMemory2_13__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2034 /* vld3 */, ARM::VLD3DUPd8, Convert__Reg1_3__Reg1_6__Reg1_9__AlignedMemory2_13__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2034 /* vld3 */, ARM::VLD3DUPq8, Convert__Reg1_3__Reg1_6__Reg1_9__AlignedMemory2_13__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2034 /* vld3 */, ARM::VLD3DUPd16_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__imm_95_0__DupAlignedMemory642_13__Imm1_14__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_DupAlignedMemory64, MCK_Imm }, },
  { 2034 /* vld3 */, ARM::VLD3DUPq16_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__imm_95_0__DupAlignedMemory642_13__Imm1_14__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_DupAlignedMemory64, MCK_Imm }, },
  { 2034 /* vld3 */, ARM::VLD3DUPd32_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__imm_95_0__DupAlignedMemory642_13__Imm1_14__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_DupAlignedMemory64, MCK_Imm }, },
  { 2034 /* vld3 */, ARM::VLD3DUPq32_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__imm_95_0__DupAlignedMemory642_13__Imm1_14__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_DupAlignedMemory64, MCK_Imm }, },
  { 2034 /* vld3 */, ARM::VLD3DUPd8_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__imm_95_0__DupAlignedMemory642_13__Imm1_14__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_DupAlignedMemory64, MCK_Imm }, },
  { 2034 /* vld3 */, ARM::VLD3DUPq8_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__imm_95_0__DupAlignedMemory642_13__Imm1_14__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_DupAlignedMemory64, MCK_Imm }, },
  { 2039 /* vld4 */, ARM::VLD4DUPdAsm_16, Convert__VecListFourDAllLanes1_2__DupAlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourDAllLanes, MCK_DupAlignedMemory64 }, },
  { 2039 /* vld4 */, ARM::VLD4dAsm_16, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2039 /* vld4 */, ARM::VLD4LNdAsm_16, Convert__VecListFourDHWordIndexed2_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourDHWordIndexed, MCK_AlignedMemory64 }, },
  { 2039 /* vld4 */, ARM::VLD4DUPqAsm_16, Convert__VecListFourQAllLanes1_2__DupAlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQAllLanes, MCK_DupAlignedMemory64 }, },
  { 2039 /* vld4 */, ARM::VLD4qAsm_16, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQ, MCK_AlignedMemory64or128or256 }, },
  { 2039 /* vld4 */, ARM::VLD4LNqAsm_16, Convert__VecListFourQHWordIndexed2_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQHWordIndexed, MCK_AlignedMemory64 }, },
  { 2039 /* vld4 */, ARM::VLD4DUPdAsm_32, Convert__VecListFourDAllLanes1_2__DupAlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourDAllLanes, MCK_DupAlignedMemory64or128 }, },
  { 2039 /* vld4 */, ARM::VLD4dAsm_32, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2039 /* vld4 */, ARM::VLD4LNdAsm_32, Convert__VecListFourDWordIndexed2_2__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourDWordIndexed, MCK_AlignedMemory64or128 }, },
  { 2039 /* vld4 */, ARM::VLD4DUPqAsm_32, Convert__VecListFourQAllLanes1_2__DupAlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQAllLanes, MCK_DupAlignedMemory64or128 }, },
  { 2039 /* vld4 */, ARM::VLD4qAsm_32, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQ, MCK_AlignedMemory64or128or256 }, },
  { 2039 /* vld4 */, ARM::VLD4LNqAsm_32, Convert__VecListFourQWordIndexed2_2__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQWordIndexed, MCK_AlignedMemory64or128 }, },
  { 2039 /* vld4 */, ARM::VLD4DUPdAsm_8, Convert__VecListFourDAllLanes1_2__DupAlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourDAllLanes, MCK_DupAlignedMemory32 }, },
  { 2039 /* vld4 */, ARM::VLD4dAsm_8, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2039 /* vld4 */, ARM::VLD4LNdAsm_8, Convert__VecListFourDByteIndexed2_2__AlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourDByteIndexed, MCK_AlignedMemory32 }, },
  { 2039 /* vld4 */, ARM::VLD4DUPqAsm_8, Convert__VecListFourQAllLanes1_2__DupAlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourQAllLanes, MCK_DupAlignedMemory32 }, },
  { 2039 /* vld4 */, ARM::VLD4qAsm_8, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourQ, MCK_AlignedMemory64or128or256 }, },
  { 2039 /* vld4 */, ARM::VLD4DUPdWB_fixed_Asm_16, Convert__VecListFourDAllLanes1_2__DupAlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourDAllLanes, MCK_DupAlignedMemory64, MCK__EXCLAIM_ }, },
  { 2039 /* vld4 */, ARM::VLD4DUPdWB_register_Asm_16, Convert__VecListFourDAllLanes1_2__DupAlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourDAllLanes, MCK_DupAlignedMemory64, MCK_rGPR }, },
  { 2039 /* vld4 */, ARM::VLD4dWB_fixed_Asm_16, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2039 /* vld4 */, ARM::VLD4dWB_register_Asm_16, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2039 /* vld4 */, ARM::VLD4LNdWB_fixed_Asm_16, Convert__VecListFourDHWordIndexed2_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourDHWordIndexed, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2039 /* vld4 */, ARM::VLD4LNdWB_register_Asm_16, Convert__VecListFourDHWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourDHWordIndexed, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2039 /* vld4 */, ARM::VLD4DUPqWB_fixed_Asm_16, Convert__VecListFourQAllLanes1_2__DupAlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQAllLanes, MCK_DupAlignedMemory64, MCK__EXCLAIM_ }, },
  { 2039 /* vld4 */, ARM::VLD4DUPqWB_register_Asm_16, Convert__VecListFourQAllLanes1_2__DupAlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQAllLanes, MCK_DupAlignedMemory64, MCK_rGPR }, },
  { 2039 /* vld4 */, ARM::VLD4qWB_fixed_Asm_16, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQ, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2039 /* vld4 */, ARM::VLD4qWB_register_Asm_16, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQ, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2039 /* vld4 */, ARM::VLD4LNqWB_fixed_Asm_16, Convert__VecListFourQHWordIndexed2_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQHWordIndexed, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2039 /* vld4 */, ARM::VLD4LNqWB_register_Asm_16, Convert__VecListFourQHWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQHWordIndexed, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2039 /* vld4 */, ARM::VLD4DUPdWB_fixed_Asm_32, Convert__VecListFourDAllLanes1_2__DupAlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourDAllLanes, MCK_DupAlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2039 /* vld4 */, ARM::VLD4DUPdWB_register_Asm_32, Convert__VecListFourDAllLanes1_2__DupAlignedMemory64or1282_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourDAllLanes, MCK_DupAlignedMemory64or128, MCK_rGPR }, },
  { 2039 /* vld4 */, ARM::VLD4dWB_fixed_Asm_32, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2039 /* vld4 */, ARM::VLD4dWB_register_Asm_32, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2039 /* vld4 */, ARM::VLD4LNdWB_fixed_Asm_32, Convert__VecListFourDWordIndexed2_2__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourDWordIndexed, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2039 /* vld4 */, ARM::VLD4LNdWB_register_Asm_32, Convert__VecListFourDWordIndexed2_2__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourDWordIndexed, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2039 /* vld4 */, ARM::VLD4DUPqWB_fixed_Asm_32, Convert__VecListFourQAllLanes1_2__DupAlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQAllLanes, MCK_DupAlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2039 /* vld4 */, ARM::VLD4DUPqWB_register_Asm_32, Convert__VecListFourQAllLanes1_2__DupAlignedMemory64or1282_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQAllLanes, MCK_DupAlignedMemory64or128, MCK_rGPR }, },
  { 2039 /* vld4 */, ARM::VLD4qWB_fixed_Asm_32, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQ, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2039 /* vld4 */, ARM::VLD4qWB_register_Asm_32, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQ, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2039 /* vld4 */, ARM::VLD4LNqWB_fixed_Asm_32, Convert__VecListFourQWordIndexed2_2__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQWordIndexed, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2039 /* vld4 */, ARM::VLD4LNqWB_register_Asm_32, Convert__VecListFourQWordIndexed2_2__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQWordIndexed, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2039 /* vld4 */, ARM::VLD4DUPdWB_fixed_Asm_8, Convert__VecListFourDAllLanes1_2__DupAlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourDAllLanes, MCK_DupAlignedMemory32, MCK__EXCLAIM_ }, },
  { 2039 /* vld4 */, ARM::VLD4DUPdWB_register_Asm_8, Convert__VecListFourDAllLanes1_2__DupAlignedMemory322_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourDAllLanes, MCK_DupAlignedMemory32, MCK_rGPR }, },
  { 2039 /* vld4 */, ARM::VLD4dWB_fixed_Asm_8, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2039 /* vld4 */, ARM::VLD4dWB_register_Asm_8, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2039 /* vld4 */, ARM::VLD4LNdWB_fixed_Asm_8, Convert__VecListFourDByteIndexed2_2__AlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourDByteIndexed, MCK_AlignedMemory32, MCK__EXCLAIM_ }, },
  { 2039 /* vld4 */, ARM::VLD4LNdWB_register_Asm_8, Convert__VecListFourDByteIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourDByteIndexed, MCK_AlignedMemory32, MCK_rGPR }, },
  { 2039 /* vld4 */, ARM::VLD4DUPqWB_fixed_Asm_8, Convert__VecListFourQAllLanes1_2__DupAlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourQAllLanes, MCK_DupAlignedMemory32, MCK__EXCLAIM_ }, },
  { 2039 /* vld4 */, ARM::VLD4DUPqWB_register_Asm_8, Convert__VecListFourQAllLanes1_2__DupAlignedMemory322_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourQAllLanes, MCK_DupAlignedMemory32, MCK_rGPR }, },
  { 2039 /* vld4 */, ARM::VLD4qWB_fixed_Asm_8, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourQ, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2039 /* vld4 */, ARM::VLD4qWB_register_Asm_8, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourQ, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2039 /* vld4 */, ARM::VLD4d16, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__AlignedMemory2_8__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2039 /* vld4 */, ARM::VLD4q16, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__AlignedMemory2_8__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2039 /* vld4 */, ARM::VLD4d32, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__AlignedMemory2_8__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2039 /* vld4 */, ARM::VLD4q32, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__AlignedMemory2_8__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2039 /* vld4 */, ARM::VLD4d8, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__AlignedMemory2_8__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2039 /* vld4 */, ARM::VLD4q8, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__AlignedMemory2_8__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2039 /* vld4 */, ARM::VLD4d16_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__imm_95_0__AlignedMemory2_8__Imm1_9__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2039 /* vld4 */, ARM::VLD4q16_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__imm_95_0__AlignedMemory2_8__Imm1_9__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2039 /* vld4 */, ARM::VLD4d32_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__imm_95_0__AlignedMemory2_8__Imm1_9__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2039 /* vld4 */, ARM::VLD4q32_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__imm_95_0__AlignedMemory2_8__Imm1_9__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2039 /* vld4 */, ARM::VLD4d8_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__imm_95_0__AlignedMemory2_8__Imm1_9__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2039 /* vld4 */, ARM::VLD4q8_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__imm_95_0__AlignedMemory2_8__Imm1_9__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2039 /* vld4 */, ARM::VLD4DUPd16, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__AlignedMemory2_16__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2039 /* vld4 */, ARM::VLD4DUPq16, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__AlignedMemory2_16__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2039 /* vld4 */, ARM::VLD4DUPd32, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__AlignedMemory2_16__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2039 /* vld4 */, ARM::VLD4DUPq32, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__AlignedMemory2_16__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2039 /* vld4 */, ARM::VLD4DUPd8, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__AlignedMemory2_16__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2039 /* vld4 */, ARM::VLD4DUPq8, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__AlignedMemory2_16__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2039 /* vld4 */, ARM::VLD4DUPd16_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__imm_95_0__AlignedMemory2_16__Imm1_17__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2039 /* vld4 */, ARM::VLD4DUPq16_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__imm_95_0__AlignedMemory2_16__Imm1_17__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2039 /* vld4 */, ARM::VLD4DUPd32_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__imm_95_0__AlignedMemory2_16__Imm1_17__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2039 /* vld4 */, ARM::VLD4DUPq32_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__imm_95_0__AlignedMemory2_16__Imm1_17__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2039 /* vld4 */, ARM::VLD4DUPd8_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__imm_95_0__AlignedMemory2_16__Imm1_17__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2039 /* vld4 */, ARM::VLD4DUPq8_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__imm_95_0__AlignedMemory2_16__Imm1_17__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2044 /* vldmdb */, ARM::VLDMDDB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__DPRRegList1_3, Feature_HasVFP2, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_DPRRegList }, },
  { 2044 /* vldmdb */, ARM::VLDMSDB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__SPRRegList1_3, Feature_HasVFP2, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_SPRRegList }, },
  { 2051 /* vldmia */, ARM::VLDMDIA, Convert__Reg1_1__CondCode2_0__DPRRegList1_2, Feature_HasVFP2, { MCK_CondCode, MCK_GPR, MCK_DPRRegList }, },
  { 2051 /* vldmia */, ARM::VLDMSIA, Convert__Reg1_1__CondCode2_0__SPRRegList1_2, Feature_HasVFP2, { MCK_CondCode, MCK_GPR, MCK_SPRRegList }, },
  { 2051 /* vldmia */, ARM::VLDMDIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__DPRRegList1_3, Feature_HasVFP2, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_DPRRegList }, },
  { 2051 /* vldmia */, ARM::VLDMSIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__SPRRegList1_3, Feature_HasVFP2, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_SPRRegList }, },
  { 2058 /* vldr */, ARM::VLDRD, Convert__Reg1_1__AddrMode52_2__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_DPR, MCK_AddrMode5 }, },
  { 2058 /* vldr */, ARM::VLDRS, Convert__Reg1_1__AddrMode52_2__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_HPR, MCK_AddrMode5 }, },
  { 2058 /* vldr */, ARM::VLDRH, Convert__Reg1_2__AddrMode5FP162_3__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_16, MCK_HPR, MCK_AddrMode5FP16 }, },
  { 2058 /* vldr */, ARM::VLDRS, Convert__Reg1_2__AddrMode52_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_32, MCK_HPR, MCK_AddrMode5 }, },
  { 2058 /* vldr */, ARM::VLDRD, Convert__Reg1_2__AddrMode52_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_AddrMode5 }, },
  { 2063 /* vlldm */, ARM::VLLDM, Convert__Reg1_1__CondCode2_0, Feature_HasV8MMainline|Feature_Has8MSecExt, { MCK_CondCode, MCK_GPRnopc }, },
  { 2069 /* vlstm */, ARM::VLSTM, Convert__Reg1_1__CondCode2_0, Feature_HasV8MMainline|Feature_Has8MSecExt, { MCK_CondCode, MCK_GPRnopc }, },
  { 2075 /* vmax */, ARM::VMAXsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2075 /* vmax */, ARM::VMAXsv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2075 /* vmax */, ARM::VMAXsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2075 /* vmax */, ARM::VMAXsv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2075 /* vmax */, ARM::VMAXsv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2075 /* vmax */, ARM::VMAXsv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2075 /* vmax */, ARM::VMAXuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 2075 /* vmax */, ARM::VMAXuv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 2075 /* vmax */, ARM::VMAXuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 2075 /* vmax */, ARM::VMAXuv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2075 /* vmax */, ARM::VMAXuv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR }, },
  { 2075 /* vmax */, ARM::VMAXuv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 2075 /* vmax */, ARM::VMAXfq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2075 /* vmax */, ARM::VMAXfd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2075 /* vmax */, ARM::VMAXhq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2075 /* vmax */, ARM::VMAXhd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2075 /* vmax */, ARM::VMAXsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2075 /* vmax */, ARM::VMAXsv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2075 /* vmax */, ARM::VMAXsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2075 /* vmax */, ARM::VMAXsv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2075 /* vmax */, ARM::VMAXsv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2075 /* vmax */, ARM::VMAXsv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2075 /* vmax */, ARM::VMAXuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2075 /* vmax */, ARM::VMAXuv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2075 /* vmax */, ARM::VMAXuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2075 /* vmax */, ARM::VMAXuv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2075 /* vmax */, ARM::VMAXuv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2075 /* vmax */, ARM::VMAXuv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2075 /* vmax */, ARM::VMAXfq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2075 /* vmax */, ARM::VMAXfd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2075 /* vmax */, ARM::VMAXhq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2075 /* vmax */, ARM::VMAXhd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2080 /* vmaxnm */, ARM::VMAXNMNQf, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON, { MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2080 /* vmaxnm */, ARM::VMAXNMNDf, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON, { MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2080 /* vmaxnm */, ARM::VMAXNMS, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasFPARMv8, { MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2080 /* vmaxnm */, ARM::VMAXNMD, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2080 /* vmaxnm */, ARM::VMAXNMNQh, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2080 /* vmaxnm */, ARM::VMAXNMNDh, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2080 /* vmaxnm */, ARM::VMAXNMH, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasFullFP16, { MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2087 /* vmin */, ARM::VMINsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2087 /* vmin */, ARM::VMINsv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2087 /* vmin */, ARM::VMINsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2087 /* vmin */, ARM::VMINsv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2087 /* vmin */, ARM::VMINsv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2087 /* vmin */, ARM::VMINsv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2087 /* vmin */, ARM::VMINuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 2087 /* vmin */, ARM::VMINuv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 2087 /* vmin */, ARM::VMINuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 2087 /* vmin */, ARM::VMINuv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2087 /* vmin */, ARM::VMINuv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR }, },
  { 2087 /* vmin */, ARM::VMINuv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 2087 /* vmin */, ARM::VMINfq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2087 /* vmin */, ARM::VMINfd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2087 /* vmin */, ARM::VMINhq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2087 /* vmin */, ARM::VMINhd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2087 /* vmin */, ARM::VMINsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2087 /* vmin */, ARM::VMINsv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2087 /* vmin */, ARM::VMINsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2087 /* vmin */, ARM::VMINsv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2087 /* vmin */, ARM::VMINsv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2087 /* vmin */, ARM::VMINsv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2087 /* vmin */, ARM::VMINuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2087 /* vmin */, ARM::VMINuv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2087 /* vmin */, ARM::VMINuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2087 /* vmin */, ARM::VMINuv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2087 /* vmin */, ARM::VMINuv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2087 /* vmin */, ARM::VMINuv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2087 /* vmin */, ARM::VMINfq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2087 /* vmin */, ARM::VMINfd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2087 /* vmin */, ARM::VMINhq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2087 /* vmin */, ARM::VMINhd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2092 /* vminnm */, ARM::VMINNMNQf, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON, { MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2092 /* vminnm */, ARM::VMINNMNDf, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON, { MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2092 /* vminnm */, ARM::VMINNMS, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasFPARMv8, { MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2092 /* vminnm */, ARM::VMINNMD, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2092 /* vminnm */, ARM::VMINNMNQh, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2092 /* vminnm */, ARM::VMINNMNDh, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2092 /* vminnm */, ARM::VMINNMH, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasFullFP16, { MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2099 /* vmla */, ARM::VMLAfq, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2099 /* vmla */, ARM::VMLAfd, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2099 /* vmla */, ARM::VMLAS, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2099 /* vmla */, ARM::VMLAD, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2099 /* vmla */, ARM::VMLAv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2099 /* vmla */, ARM::VMLAv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2099 /* vmla */, ARM::VMLAv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2099 /* vmla */, ARM::VMLAv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2099 /* vmla */, ARM::VMLAv16i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2099 /* vmla */, ARM::VMLAv8i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2099 /* vmla */, ARM::VMLAhq, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2099 /* vmla */, ARM::VMLAhd, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2099 /* vmla */, ARM::VMLAH, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2099 /* vmla */, ARM::VMLAslfq, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2099 /* vmla */, ARM::VMLAslfd, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2099 /* vmla */, ARM::VMLAslv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2099 /* vmla */, ARM::VMLAslv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2099 /* vmla */, ARM::VMLAslv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2099 /* vmla */, ARM::VMLAslv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2099 /* vmla */, ARM::VMLAslhq, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2099 /* vmla */, ARM::VMLAslhd, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2104 /* vmlal */, ARM::VMLALsv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2104 /* vmlal */, ARM::VMLALsv2i64, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2104 /* vmlal */, ARM::VMLALsv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2104 /* vmlal */, ARM::VMLALuv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2104 /* vmlal */, ARM::VMLALuv2i64, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2104 /* vmlal */, ARM::VMLALuv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2104 /* vmlal */, ARM::VMLALslsv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2104 /* vmlal */, ARM::VMLALslsv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2104 /* vmlal */, ARM::VMLALsluv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2104 /* vmlal */, ARM::VMLALsluv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2110 /* vmls */, ARM::VMLSfq, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2110 /* vmls */, ARM::VMLSfd, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2110 /* vmls */, ARM::VMLSS, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2110 /* vmls */, ARM::VMLSD, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2110 /* vmls */, ARM::VMLSv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2110 /* vmls */, ARM::VMLSv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2110 /* vmls */, ARM::VMLSv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2110 /* vmls */, ARM::VMLSv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2110 /* vmls */, ARM::VMLSv16i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2110 /* vmls */, ARM::VMLSv8i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2110 /* vmls */, ARM::VMLShq, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2110 /* vmls */, ARM::VMLShd, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2110 /* vmls */, ARM::VMLSH, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2110 /* vmls */, ARM::VMLSslfq, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2110 /* vmls */, ARM::VMLSslfd, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2110 /* vmls */, ARM::VMLSslv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2110 /* vmls */, ARM::VMLSslv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2110 /* vmls */, ARM::VMLSslv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2110 /* vmls */, ARM::VMLSslv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2110 /* vmls */, ARM::VMLSslhq, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2110 /* vmls */, ARM::VMLSslhd, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2115 /* vmlsl */, ARM::VMLSLsv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2115 /* vmlsl */, ARM::VMLSLsv2i64, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2115 /* vmlsl */, ARM::VMLSLsv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2115 /* vmlsl */, ARM::VMLSLuv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2115 /* vmlsl */, ARM::VMLSLuv2i64, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2115 /* vmlsl */, ARM::VMLSLuv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2115 /* vmlsl */, ARM::VMLSLslsv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2115 /* vmlsl */, ARM::VMLSLslsv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2115 /* vmlsl */, ARM::VMLSLsluv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2115 /* vmlsl */, ARM::VMLSLsluv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2121 /* vmov */, ARM::VMOVRS, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_GPR, MCK_HPR }, },
  { 2121 /* vmov */, ARM::VORRq, Convert__Reg1_1__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR }, },
  { 2121 /* vmov */, ARM::VORRd, Convert__Reg1_1__Reg1_2__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR }, },
  { 2121 /* vmov */, ARM::VMOVSR, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_HPR, MCK_GPR }, },
  { 2121 /* vmov */, ARM::VMOVS, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_HPR, MCK_HPR }, },
  { 2121 /* vmov */, ARM::VMOVv4f32, Convert__Reg1_2__FPImm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_FPImm }, },
  { 2121 /* vmov */, ARM::VMOVv4i32, Convert__Reg1_2__NEONi32vmov1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_NEONi32vmov }, },
  { 2121 /* vmov */, ARM::VMOVv2f32, Convert__Reg1_2__FPImm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_FPImm }, },
  { 2121 /* vmov */, ARM::VMOVv2i32, Convert__Reg1_2__NEONi32vmov1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_NEONi32vmov }, },
  { 2121 /* vmov */, ARM::VMOVS, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2121 /* vmov */, ARM::FCONSTS, Convert__Reg1_2__FPImm1_3__CondCode2_0, Feature_HasVFP3, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_FPImm }, },
  { 2121 /* vmov */, ARM::VMOVD, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2121 /* vmov */, ARM::FCONSTD, Convert__Reg1_2__FPImm1_3__CondCode2_0, Feature_HasVFP3|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_FPImm }, },
  { 2121 /* vmov */, ARM::VMOVv16i8, Convert__Reg1_2__NEONi16vmovi8Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_NEONi16vmovi8Replicate }, },
  { 2121 /* vmov */, ARM::VMOVv8i16, Convert__Reg1_2__NEONi16splat1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_NEONi16splat }, },
  { 2121 /* vmov */, ARM::VMOVv8i8, Convert__Reg1_2__NEONi16vmovi8Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_NEONi16vmovi8Replicate }, },
  { 2121 /* vmov */, ARM::VMOVv4i16, Convert__Reg1_2__NEONi16splat1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_NEONi16splat }, },
  { 2121 /* vmov */, ARM::VMOVv16i8, Convert__Reg1_2__NEONi32vmovi8Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_NEONi32vmovi8Replicate }, },
  { 2121 /* vmov */, ARM::VMOVv8i16, Convert__Reg1_2__NEONi32vmovi16Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_NEONi32vmovi16Replicate }, },
  { 2121 /* vmov */, ARM::VMOVv4i32, Convert__Reg1_2__NEONi32vmov1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_NEONi32vmov }, },
  { 2121 /* vmov */, ARM::VMVNv4i32, Convert__Reg1_2__NEONi32vmovNeg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_NEONi32vmovNeg }, },
  { 2121 /* vmov */, ARM::VMOVv8i8, Convert__Reg1_2__NEONi32vmovi8Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_NEONi32vmovi8Replicate }, },
  { 2121 /* vmov */, ARM::VMOVv4i16, Convert__Reg1_2__NEONi32vmovi16Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_NEONi32vmovi16Replicate }, },
  { 2121 /* vmov */, ARM::VMOVv2i32, Convert__Reg1_2__NEONi32vmov1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_NEONi32vmov }, },
  { 2121 /* vmov */, ARM::VMVNv2i32, Convert__Reg1_2__NEONi32vmovNeg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_NEONi32vmovNeg }, },
  { 2121 /* vmov */, ARM::VMOVv16i8, Convert__Reg1_2__NEONi64vmovi8Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_QPR, MCK_NEONi64vmovi8Replicate }, },
  { 2121 /* vmov */, ARM::VMOVv8i16, Convert__Reg1_2__NEONi64vmovi16Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_QPR, MCK_NEONi64vmovi16Replicate }, },
  { 2121 /* vmov */, ARM::VMOVv4i32, Convert__Reg1_2__NEONi64vmovi32Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_QPR, MCK_NEONi64vmovi32Replicate }, },
  { 2121 /* vmov */, ARM::VMOVv2i64, Convert__Reg1_2__NEONi64splat1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_QPR, MCK_NEONi64splat }, },
  { 2121 /* vmov */, ARM::VMOVv8i8, Convert__Reg1_2__NEONi64vmovi8Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_DPR, MCK_NEONi64vmovi8Replicate }, },
  { 2121 /* vmov */, ARM::VMOVv4i16, Convert__Reg1_2__NEONi64vmovi16Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_DPR, MCK_NEONi64vmovi16Replicate }, },
  { 2121 /* vmov */, ARM::VMOVv2i32, Convert__Reg1_2__NEONi64vmovi32Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_DPR, MCK_NEONi64vmovi32Replicate }, },
  { 2121 /* vmov */, ARM::VMOVv1i64, Convert__Reg1_2__NEONi64splat1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_DPR, MCK_NEONi64splat }, },
  { 2121 /* vmov */, ARM::VMOVv16i8, Convert__Reg1_2__NEONi8splat1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK_NEONi8splat }, },
  { 2121 /* vmov */, ARM::VMOVv8i8, Convert__Reg1_2__NEONi8splat1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_NEONi8splat }, },
  { 2121 /* vmov */, ARM::VMOVRS, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_16, MCK_GPR, MCK_HPR }, },
  { 2121 /* vmov */, ARM::VORRq, Convert__Reg1_2__Reg1_3__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR }, },
  { 2121 /* vmov */, ARM::VORRd, Convert__Reg1_2__Reg1_3__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR }, },
  { 2121 /* vmov */, ARM::VMOVSR, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_16, MCK_HPR, MCK_GPR }, },
  { 2121 /* vmov */, ARM::VMOVRS, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_32, MCK_GPR, MCK_HPR }, },
  { 2121 /* vmov */, ARM::VORRq, Convert__Reg1_2__Reg1_3__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR }, },
  { 2121 /* vmov */, ARM::VORRd, Convert__Reg1_2__Reg1_3__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR }, },
  { 2121 /* vmov */, ARM::VMOVSR, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_32, MCK_HPR, MCK_GPR }, },
  { 2121 /* vmov */, ARM::VORRq, Convert__Reg1_2__Reg1_3__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR }, },
  { 2121 /* vmov */, ARM::VORRd, Convert__Reg1_2__Reg1_3__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_DPR }, },
  { 2121 /* vmov */, ARM::VMOVRS, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_8, MCK_GPR, MCK_HPR }, },
  { 2121 /* vmov */, ARM::VORRq, Convert__Reg1_2__Reg1_3__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 2121 /* vmov */, ARM::VORRd, Convert__Reg1_2__Reg1_3__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR }, },
  { 2121 /* vmov */, ARM::VMOVSR, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_8, MCK_HPR, MCK_GPR }, },
  { 2121 /* vmov */, ARM::VMOVRH, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_GPR, MCK_HPR }, },
  { 2121 /* vmov */, ARM::VMOVHR, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_GPR }, },
  { 2121 /* vmov */, ARM::FCONSTH, Convert__Reg1_2__FPImm1_3__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_FPImm }, },
  { 2121 /* vmov */, ARM::VMOVRRD, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_DPR }, },
  { 2121 /* vmov */, ARM::VMOVDRR, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_DPR, MCK_GPR, MCK_GPR }, },
  { 2121 /* vmov */, ARM::VGETLNs16, Convert__Reg1_2__Reg1_3__VectorIndex161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_GPR, MCK_DPR, MCK_VectorIndex16 }, },
  { 2121 /* vmov */, ARM::VGETLNs8, Convert__Reg1_2__Reg1_3__VectorIndex81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_GPR, MCK_DPR, MCK_VectorIndex8 }, },
  { 2121 /* vmov */, ARM::VGETLNu16, Convert__Reg1_2__Reg1_3__VectorIndex161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_GPR, MCK_DPR, MCK_VectorIndex16 }, },
  { 2121 /* vmov */, ARM::VGETLNu8, Convert__Reg1_2__Reg1_3__VectorIndex81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_GPR, MCK_DPR, MCK_VectorIndex8 }, },
  { 2121 /* vmov */, ARM::VMOVRRD, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f64, MCK_GPR, MCK_GPR, MCK_DPR }, },
  { 2121 /* vmov */, ARM::VMOVDRR, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_GPR, MCK_GPR }, },
  { 2121 /* vmov */, ARM::VSETLNi16, Convert__Reg1_2__Tie0_1_1__Reg1_4__VectorIndex161_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_VectorIndex16, MCK_GPR }, },
  { 2121 /* vmov */, ARM::VGETLNi32, Convert__Reg1_2__Reg1_3__VectorIndex321_4__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_32, MCK_GPR, MCK_DPR, MCK_VectorIndex32 }, },
  { 2121 /* vmov */, ARM::VSETLNi32, Convert__Reg1_2__Tie0_1_1__Reg1_4__VectorIndex321_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_VectorIndex32, MCK_GPR }, },
  { 2121 /* vmov */, ARM::VSETLNi8, Convert__Reg1_2__Tie0_1_1__Reg1_4__VectorIndex81_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_VectorIndex8, MCK_GPR }, },
  { 2121 /* vmov */, ARM::VMOVRRS, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_HPR, MCK_HPR }, },
  { 2121 /* vmov */, ARM::VMOVSRR, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_HPR, MCK_HPR, MCK_GPR, MCK_GPR }, },
  { 2126 /* vmovl */, ARM::VMOVLsv4i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR }, },
  { 2126 /* vmovl */, ARM::VMOVLsv2i64, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR }, },
  { 2126 /* vmovl */, ARM::VMOVLsv8i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_DPR }, },
  { 2126 /* vmovl */, ARM::VMOVLuv4i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_DPR }, },
  { 2126 /* vmovl */, ARM::VMOVLuv2i64, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_DPR }, },
  { 2126 /* vmovl */, ARM::VMOVLuv8i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_DPR }, },
  { 2132 /* vmovn */, ARM::VMOVNv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_QPR }, },
  { 2132 /* vmovn */, ARM::VMOVNv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_QPR }, },
  { 2132 /* vmovn */, ARM::VMOVNv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_DPR, MCK_QPR }, },
  { 2138 /* vmovx */, ARM::VMOVH, Convert__Reg1_1__Reg1_2, Feature_HasFullFP16, { MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2144 /* vmrs */, ARM::FMSTAT, Convert__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_APSR_NZCV, MCK_FPSCR }, },
  { 2144 /* vmrs */, ARM::VMRS_FPEXC, Convert__Reg1_1__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_GPRnopc, MCK_FPEXC }, },
  { 2144 /* vmrs */, ARM::VMRS_FPINST, Convert__Reg1_1__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_GPRnopc, MCK_FPINST }, },
  { 2144 /* vmrs */, ARM::VMRS_FPINST2, Convert__Reg1_1__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_GPRnopc, MCK_FPINST2 }, },
  { 2144 /* vmrs */, ARM::VMRS, Convert__Reg1_1__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_GPRnopc, MCK_FPSCR }, },
  { 2144 /* vmrs */, ARM::VMRS_FPSID, Convert__Reg1_1__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_GPRnopc, MCK_FPSID }, },
  { 2144 /* vmrs */, ARM::VMRS_MVFR0, Convert__Reg1_1__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_GPRnopc, MCK_MVFR0 }, },
  { 2144 /* vmrs */, ARM::VMRS_MVFR1, Convert__Reg1_1__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_GPRnopc, MCK_MVFR1 }, },
  { 2144 /* vmrs */, ARM::VMRS_MVFR2, Convert__Reg1_1__CondCode2_0, Feature_HasFPARMv8, { MCK_CondCode, MCK_GPRnopc, MCK_MVFR2 }, },
  { 2149 /* vmsr */, ARM::VMSR_FPEXC, Convert__Reg1_2__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_FPEXC, MCK_GPRnopc }, },
  { 2149 /* vmsr */, ARM::VMSR_FPINST, Convert__Reg1_2__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_FPINST, MCK_GPRnopc }, },
  { 2149 /* vmsr */, ARM::VMSR_FPINST2, Convert__Reg1_2__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_FPINST2, MCK_GPRnopc }, },
  { 2149 /* vmsr */, ARM::VMSR, Convert__Reg1_2__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_FPSCR, MCK_GPRnopc }, },
  { 2149 /* vmsr */, ARM::VMSR_FPSID, Convert__Reg1_2__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_FPSID, MCK_GPRnopc }, },
  { 2154 /* vmul */, ARM::VMULfq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2154 /* vmul */, ARM::VMULfd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2154 /* vmul */, ARM::VMULS, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2154 /* vmul */, ARM::VMULD, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2154 /* vmul */, ARM::VMULv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR }, },
  { 2154 /* vmul */, ARM::VMULv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR }, },
  { 2154 /* vmul */, ARM::VMULv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR }, },
  { 2154 /* vmul */, ARM::VMULv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR }, },
  { 2154 /* vmul */, ARM::VMULv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK_QPR }, },
  { 2154 /* vmul */, ARM::VMULv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_DPR }, },
  { 2154 /* vmul */, ARM::VMULpq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_p8, MCK_QPR, MCK_QPR }, },
  { 2154 /* vmul */, ARM::VMULpd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_p8, MCK_DPR, MCK_DPR }, },
  { 2154 /* vmul */, ARM::VMULhq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2154 /* vmul */, ARM::VMULhd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2154 /* vmul */, ARM::VMULH, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2154 /* vmul */, ARM::VMULslfq, Convert__Reg1_2__Reg1_2__Reg1_3__VectorIndex321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2154 /* vmul */, ARM::VMULfq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2154 /* vmul */, ARM::VMULslfd, Convert__Reg1_2__Reg1_2__Reg1_3__VectorIndex321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2154 /* vmul */, ARM::VMULfd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2154 /* vmul */, ARM::VMULS, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2154 /* vmul */, ARM::VMULD, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2154 /* vmul */, ARM::VMULslv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__VectorIndex161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2154 /* vmul */, ARM::VMULv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2154 /* vmul */, ARM::VMULslv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__VectorIndex161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2154 /* vmul */, ARM::VMULv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2154 /* vmul */, ARM::VMULslv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__VectorIndex321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2154 /* vmul */, ARM::VMULv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2154 /* vmul */, ARM::VMULslv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__VectorIndex321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2154 /* vmul */, ARM::VMULv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2154 /* vmul */, ARM::VMULv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2154 /* vmul */, ARM::VMULv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2154 /* vmul */, ARM::VMULpq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_p8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2154 /* vmul */, ARM::VMULpd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_p8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2154 /* vmul */, ARM::VMULslhq, Convert__Reg1_2__Reg1_2__Reg1_3__VectorIndex161_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2154 /* vmul */, ARM::VMULhq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2154 /* vmul */, ARM::VMULslhd, Convert__Reg1_2__Reg1_2__Reg1_3__VectorIndex161_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2154 /* vmul */, ARM::VMULhd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2154 /* vmul */, ARM::VMULH, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2154 /* vmul */, ARM::VMULslfq, Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2154 /* vmul */, ARM::VMULslfd, Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2154 /* vmul */, ARM::VMULslv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2154 /* vmul */, ARM::VMULslv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2154 /* vmul */, ARM::VMULslv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2154 /* vmul */, ARM::VMULslv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2154 /* vmul */, ARM::VMULslhq, Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2154 /* vmul */, ARM::VMULslhd, Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2159 /* vmull */, ARM::VMULLp64, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasV8|Feature_HasCrypto, { MCK__DOT_p64, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2159 /* vmull */, ARM::VMULLsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2159 /* vmull */, ARM::VMULLsv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2159 /* vmull */, ARM::VMULLsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2159 /* vmull */, ARM::VMULLuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2159 /* vmull */, ARM::VMULLuv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2159 /* vmull */, ARM::VMULLuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2159 /* vmull */, ARM::VMULLp8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_p8, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2159 /* vmull */, ARM::VMULLslsv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2159 /* vmull */, ARM::VMULLslsv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2159 /* vmull */, ARM::VMULLsluv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2159 /* vmull */, ARM::VMULLsluv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2165 /* vmvn */, ARM::VMVNq, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR }, },
  { 2165 /* vmvn */, ARM::VMVNd, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR }, },
  { 2165 /* vmvn */, ARM::VMOVv16i8, Convert__Reg1_2__NEONi16invi8Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_NEONi16invi8Replicate }, },
  { 2165 /* vmvn */, ARM::VMVNv8i16, Convert__Reg1_2__NEONi16splat1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_NEONi16splat }, },
  { 2165 /* vmvn */, ARM::VMOVv8i8, Convert__Reg1_2__NEONi16invi8Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_NEONi16invi8Replicate }, },
  { 2165 /* vmvn */, ARM::VMVNv4i16, Convert__Reg1_2__NEONi16splat1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_NEONi16splat }, },
  { 2165 /* vmvn */, ARM::VMOVv16i8, Convert__Reg1_2__NEONi32invi8Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_NEONi32invi8Replicate }, },
  { 2165 /* vmvn */, ARM::VMVNv8i16, Convert__Reg1_2__NEONi32vmovi16Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_NEONi32vmovi16Replicate }, },
  { 2165 /* vmvn */, ARM::VMVNv4i32, Convert__Reg1_2__NEONi32vmov1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_NEONi32vmov }, },
  { 2165 /* vmvn */, ARM::VMOVv4i32, Convert__Reg1_2__NEONi32vmovNeg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_NEONi32vmovNeg }, },
  { 2165 /* vmvn */, ARM::VMOVv8i8, Convert__Reg1_2__NEONi32invi8Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_NEONi32invi8Replicate }, },
  { 2165 /* vmvn */, ARM::VMVNv4i16, Convert__Reg1_2__NEONi32vmovi16Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_NEONi32vmovi16Replicate }, },
  { 2165 /* vmvn */, ARM::VMVNv2i32, Convert__Reg1_2__NEONi32vmov1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_NEONi32vmov }, },
  { 2165 /* vmvn */, ARM::VMOVv2i32, Convert__Reg1_2__NEONi32vmovNeg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_NEONi32vmovNeg }, },
  { 2165 /* vmvn */, ARM::VMOVv16i8, Convert__Reg1_2__NEONi64invi8Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_QPR, MCK_NEONi64invi8Replicate }, },
  { 2165 /* vmvn */, ARM::VMVNv8i16, Convert__Reg1_2__NEONi64vmovi16Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_QPR, MCK_NEONi64vmovi16Replicate }, },
  { 2165 /* vmvn */, ARM::VMVNv4i32, Convert__Reg1_2__NEONi64vmovi32Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_QPR, MCK_NEONi64vmovi32Replicate }, },
  { 2165 /* vmvn */, ARM::VMOVv8i8, Convert__Reg1_2__NEONi64invi8Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_DPR, MCK_NEONi64invi8Replicate }, },
  { 2165 /* vmvn */, ARM::VMVNv4i16, Convert__Reg1_2__NEONi64vmovi16Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_DPR, MCK_NEONi64vmovi16Replicate }, },
  { 2165 /* vmvn */, ARM::VMVNv2i32, Convert__Reg1_2__NEONi64vmovi32Replicate1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_DPR, MCK_NEONi64vmovi32Replicate }, },
  { 2165 /* vmvn */, ARM::VMVNq, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR }, },
  { 2165 /* vmvn */, ARM::VMVNd, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR }, },
  { 2165 /* vmvn */, ARM::VMVNq, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR }, },
  { 2165 /* vmvn */, ARM::VMVNd, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR }, },
  { 2165 /* vmvn */, ARM::VMVNq, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR }, },
  { 2165 /* vmvn */, ARM::VMVNd, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_DPR }, },
  { 2165 /* vmvn */, ARM::VMVNq, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 2165 /* vmvn */, ARM::VMVNd, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR }, },
  { 2170 /* vneg */, ARM::VNEGs16q, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2170 /* vneg */, ARM::VNEGs16d, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2170 /* vneg */, ARM::VNEGs32q, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2170 /* vneg */, ARM::VNEGs32d, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2170 /* vneg */, ARM::VNEGs8q, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2170 /* vneg */, ARM::VNEGs8d, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2170 /* vneg */, ARM::VNEGf32q, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2170 /* vneg */, ARM::VNEGfd, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2170 /* vneg */, ARM::VNEGS, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2170 /* vneg */, ARM::VNEGD, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2170 /* vneg */, ARM::VNEGhq, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2170 /* vneg */, ARM::VNEGhd, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2170 /* vneg */, ARM::VNEGH, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2175 /* vnmla */, ARM::VNMLAS, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2175 /* vnmla */, ARM::VNMLAD, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2175 /* vnmla */, ARM::VNMLAH, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2181 /* vnmls */, ARM::VNMLSS, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2181 /* vnmls */, ARM::VNMLSD, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2181 /* vnmls */, ARM::VNMLSH, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2187 /* vnmul */, ARM::VNMULS, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2187 /* vnmul */, ARM::VNMULD, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2187 /* vnmul */, ARM::VNMULH, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2193 /* vorn */, ARM::VORNq, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2193 /* vorn */, ARM::VORNd, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2198 /* vorr */, ARM::VORRq, Convert__Reg1_1__Reg1_1__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR }, },
  { 2198 /* vorr */, ARM::VORRd, Convert__Reg1_1__Reg1_1__Reg1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR }, },
  { 2198 /* vorr */, ARM::VORRiv8i16, Convert__Reg1_2__NEONi16splat1_3__Tie0_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_NEONi16splat }, },
  { 2198 /* vorr */, ARM::VORRiv4i16, Convert__Reg1_2__NEONi16splat1_3__Tie0_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_NEONi16splat }, },
  { 2198 /* vorr */, ARM::VORRiv4i32, Convert__Reg1_2__NEONi32splat1_3__Tie0_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_NEONi32splat }, },
  { 2198 /* vorr */, ARM::VORRiv2i32, Convert__Reg1_2__NEONi32splat1_3__Tie0_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_NEONi32splat }, },
  { 2198 /* vorr */, ARM::VORRq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR }, },
  { 2198 /* vorr */, ARM::VORRd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR }, },
  { 2198 /* vorr */, ARM::VORRq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR }, },
  { 2198 /* vorr */, ARM::VORRd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR }, },
  { 2198 /* vorr */, ARM::VORRq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR }, },
  { 2198 /* vorr */, ARM::VORRd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_DPR }, },
  { 2198 /* vorr */, ARM::VORRq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 2198 /* vorr */, ARM::VORRd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR }, },
  { 2198 /* vorr */, ARM::VORRq, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2198 /* vorr */, ARM::VORRd, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2198 /* vorr */, ARM::VORRq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2198 /* vorr */, ARM::VORRd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2198 /* vorr */, ARM::VORRq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2198 /* vorr */, ARM::VORRd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2198 /* vorr */, ARM::VORRq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2198 /* vorr */, ARM::VORRd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2198 /* vorr */, ARM::VORRq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2198 /* vorr */, ARM::VORRd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2203 /* vpadal */, ARM::VPADALsv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2203 /* vpadal */, ARM::VPADALsv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2203 /* vpadal */, ARM::VPADALsv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2203 /* vpadal */, ARM::VPADALsv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2203 /* vpadal */, ARM::VPADALsv16i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2203 /* vpadal */, ARM::VPADALsv8i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2203 /* vpadal */, ARM::VPADALuv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 2203 /* vpadal */, ARM::VPADALuv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 2203 /* vpadal */, ARM::VPADALuv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 2203 /* vpadal */, ARM::VPADALuv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2203 /* vpadal */, ARM::VPADALuv16i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR }, },
  { 2203 /* vpadal */, ARM::VPADALuv8i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 2210 /* vpadd */, ARM::VPADDf, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2210 /* vpadd */, ARM::VPADDi16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR }, },
  { 2210 /* vpadd */, ARM::VPADDi32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR }, },
  { 2210 /* vpadd */, ARM::VPADDi8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_DPR }, },
  { 2210 /* vpadd */, ARM::VPADDh, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2210 /* vpadd */, ARM::VPADDf, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2210 /* vpadd */, ARM::VPADDi16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2210 /* vpadd */, ARM::VPADDi32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2210 /* vpadd */, ARM::VPADDi8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2210 /* vpadd */, ARM::VPADDh, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2216 /* vpaddl */, ARM::VPADDLsv8i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2216 /* vpaddl */, ARM::VPADDLsv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2216 /* vpaddl */, ARM::VPADDLsv4i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2216 /* vpaddl */, ARM::VPADDLsv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2216 /* vpaddl */, ARM::VPADDLsv16i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2216 /* vpaddl */, ARM::VPADDLsv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2216 /* vpaddl */, ARM::VPADDLuv8i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 2216 /* vpaddl */, ARM::VPADDLuv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 2216 /* vpaddl */, ARM::VPADDLuv4i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 2216 /* vpaddl */, ARM::VPADDLuv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2216 /* vpaddl */, ARM::VPADDLuv16i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR }, },
  { 2216 /* vpaddl */, ARM::VPADDLuv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 2223 /* vpmax */, ARM::VPMAXs16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2223 /* vpmax */, ARM::VPMAXs32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2223 /* vpmax */, ARM::VPMAXs8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2223 /* vpmax */, ARM::VPMAXu16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 2223 /* vpmax */, ARM::VPMAXu32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2223 /* vpmax */, ARM::VPMAXu8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 2223 /* vpmax */, ARM::VPMAXf, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2223 /* vpmax */, ARM::VPMAXh, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2223 /* vpmax */, ARM::VPMAXs16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2223 /* vpmax */, ARM::VPMAXs32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2223 /* vpmax */, ARM::VPMAXs8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2223 /* vpmax */, ARM::VPMAXu16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2223 /* vpmax */, ARM::VPMAXu32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2223 /* vpmax */, ARM::VPMAXu8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2223 /* vpmax */, ARM::VPMAXf, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2223 /* vpmax */, ARM::VPMAXh, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2229 /* vpmin */, ARM::VPMINs16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2229 /* vpmin */, ARM::VPMINs32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2229 /* vpmin */, ARM::VPMINs8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2229 /* vpmin */, ARM::VPMINu16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 2229 /* vpmin */, ARM::VPMINu32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2229 /* vpmin */, ARM::VPMINu8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 2229 /* vpmin */, ARM::VPMINf, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2229 /* vpmin */, ARM::VPMINh, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2229 /* vpmin */, ARM::VPMINs16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2229 /* vpmin */, ARM::VPMINs32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2229 /* vpmin */, ARM::VPMINs8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2229 /* vpmin */, ARM::VPMINu16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2229 /* vpmin */, ARM::VPMINu32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2229 /* vpmin */, ARM::VPMINu8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2229 /* vpmin */, ARM::VPMINf, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2229 /* vpmin */, ARM::VPMINh, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2235 /* vpop */, ARM::VLDMDIA_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__DPRRegList1_1, Feature_HasVFP2, { MCK_CondCode, MCK_DPRRegList }, },
  { 2235 /* vpop */, ARM::VLDMSIA_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__SPRRegList1_1, Feature_HasVFP2, { MCK_CondCode, MCK_SPRRegList }, },
  { 2235 /* vpop */, ARM::VLDMDIA_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__DPRRegList1_2, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_16, MCK_DPRRegList }, },
  { 2235 /* vpop */, ARM::VLDMSIA_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__SPRRegList1_2, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_16, MCK_SPRRegList }, },
  { 2235 /* vpop */, ARM::VLDMDIA_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__DPRRegList1_2, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_32, MCK_DPRRegList }, },
  { 2235 /* vpop */, ARM::VLDMSIA_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__SPRRegList1_2, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_32, MCK_SPRRegList }, },
  { 2235 /* vpop */, ARM::VLDMDIA_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__DPRRegList1_2, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_64, MCK_DPRRegList }, },
  { 2235 /* vpop */, ARM::VLDMSIA_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__SPRRegList1_2, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_64, MCK_SPRRegList }, },
  { 2235 /* vpop */, ARM::VLDMDIA_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__DPRRegList1_2, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_8, MCK_DPRRegList }, },
  { 2235 /* vpop */, ARM::VLDMSIA_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__SPRRegList1_2, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_8, MCK_SPRRegList }, },
  { 2240 /* vpush */, ARM::VSTMDDB_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__DPRRegList1_1, Feature_HasVFP2, { MCK_CondCode, MCK_DPRRegList }, },
  { 2240 /* vpush */, ARM::VSTMSDB_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__SPRRegList1_1, Feature_HasVFP2, { MCK_CondCode, MCK_SPRRegList }, },
  { 2240 /* vpush */, ARM::VSTMDDB_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__DPRRegList1_2, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_16, MCK_DPRRegList }, },
  { 2240 /* vpush */, ARM::VSTMSDB_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__SPRRegList1_2, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_16, MCK_SPRRegList }, },
  { 2240 /* vpush */, ARM::VSTMDDB_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__DPRRegList1_2, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_32, MCK_DPRRegList }, },
  { 2240 /* vpush */, ARM::VSTMSDB_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__SPRRegList1_2, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_32, MCK_SPRRegList }, },
  { 2240 /* vpush */, ARM::VSTMDDB_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__DPRRegList1_2, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_64, MCK_DPRRegList }, },
  { 2240 /* vpush */, ARM::VSTMSDB_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__SPRRegList1_2, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_64, MCK_SPRRegList }, },
  { 2240 /* vpush */, ARM::VSTMDDB_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__DPRRegList1_2, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_8, MCK_DPRRegList }, },
  { 2240 /* vpush */, ARM::VSTMSDB_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__SPRRegList1_2, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_8, MCK_SPRRegList }, },
  { 2246 /* vqabs */, ARM::VQABSv8i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2246 /* vqabs */, ARM::VQABSv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2246 /* vqabs */, ARM::VQABSv4i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2246 /* vqabs */, ARM::VQABSv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2246 /* vqabs */, ARM::VQABSv16i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2246 /* vqabs */, ARM::VQABSv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2252 /* vqadd */, ARM::VQADDsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2252 /* vqadd */, ARM::VQADDsv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2252 /* vqadd */, ARM::VQADDsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2252 /* vqadd */, ARM::VQADDsv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2252 /* vqadd */, ARM::VQADDsv2i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_QPR }, },
  { 2252 /* vqadd */, ARM::VQADDsv1i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_DPR }, },
  { 2252 /* vqadd */, ARM::VQADDsv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2252 /* vqadd */, ARM::VQADDsv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2252 /* vqadd */, ARM::VQADDuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 2252 /* vqadd */, ARM::VQADDuv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 2252 /* vqadd */, ARM::VQADDuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 2252 /* vqadd */, ARM::VQADDuv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2252 /* vqadd */, ARM::VQADDuv2i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_QPR, MCK_QPR }, },
  { 2252 /* vqadd */, ARM::VQADDuv1i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_DPR }, },
  { 2252 /* vqadd */, ARM::VQADDuv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR }, },
  { 2252 /* vqadd */, ARM::VQADDuv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 2252 /* vqadd */, ARM::VQADDsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2252 /* vqadd */, ARM::VQADDsv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2252 /* vqadd */, ARM::VQADDsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2252 /* vqadd */, ARM::VQADDsv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2252 /* vqadd */, ARM::VQADDsv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2252 /* vqadd */, ARM::VQADDsv1i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2252 /* vqadd */, ARM::VQADDsv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2252 /* vqadd */, ARM::VQADDsv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2252 /* vqadd */, ARM::VQADDuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2252 /* vqadd */, ARM::VQADDuv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2252 /* vqadd */, ARM::VQADDuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2252 /* vqadd */, ARM::VQADDuv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2252 /* vqadd */, ARM::VQADDuv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2252 /* vqadd */, ARM::VQADDuv1i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2252 /* vqadd */, ARM::VQADDuv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2252 /* vqadd */, ARM::VQADDuv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2258 /* vqdmlal */, ARM::VQDMLALv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2258 /* vqdmlal */, ARM::VQDMLALv2i64, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2258 /* vqdmlal */, ARM::VQDMLALslv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2258 /* vqdmlal */, ARM::VQDMLALslv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2266 /* vqdmlsl */, ARM::VQDMLSLv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2266 /* vqdmlsl */, ARM::VQDMLSLv2i64, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2266 /* vqdmlsl */, ARM::VQDMLSLslv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2266 /* vqdmlsl */, ARM::VQDMLSLslv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2274 /* vqdmulh */, ARM::VQDMULHv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2274 /* vqdmulh */, ARM::VQDMULHv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2274 /* vqdmulh */, ARM::VQDMULHv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2274 /* vqdmulh */, ARM::VQDMULHv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2274 /* vqdmulh */, ARM::VQDMULHv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2274 /* vqdmulh */, ARM::VQDMULHv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2274 /* vqdmulh */, ARM::VQDMULHv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2274 /* vqdmulh */, ARM::VQDMULHv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2274 /* vqdmulh */, ARM::VQDMULHslv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2274 /* vqdmulh */, ARM::VQDMULHslv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2274 /* vqdmulh */, ARM::VQDMULHslv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2274 /* vqdmulh */, ARM::VQDMULHslv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2282 /* vqdmull */, ARM::VQDMULLv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2282 /* vqdmull */, ARM::VQDMULLv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2282 /* vqdmull */, ARM::VQDMULLslv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2282 /* vqdmull */, ARM::VQDMULLslv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2290 /* vqmovn */, ARM::VQMOVNsv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_QPR }, },
  { 2290 /* vqmovn */, ARM::VQMOVNsv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_QPR }, },
  { 2290 /* vqmovn */, ARM::VQMOVNsv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_QPR }, },
  { 2290 /* vqmovn */, ARM::VQMOVNuv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_QPR }, },
  { 2290 /* vqmovn */, ARM::VQMOVNuv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_QPR }, },
  { 2290 /* vqmovn */, ARM::VQMOVNuv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_QPR }, },
  { 2297 /* vqmovun */, ARM::VQMOVNsuv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_QPR }, },
  { 2297 /* vqmovun */, ARM::VQMOVNsuv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_QPR }, },
  { 2297 /* vqmovun */, ARM::VQMOVNsuv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_QPR }, },
  { 2305 /* vqneg */, ARM::VQNEGv8i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2305 /* vqneg */, ARM::VQNEGv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2305 /* vqneg */, ARM::VQNEGv4i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2305 /* vqneg */, ARM::VQNEGv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2305 /* vqneg */, ARM::VQNEGv16i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2305 /* vqneg */, ARM::VQNEGv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2311 /* vqrdmlah */, ARM::VQRDMLAHv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasV8_1a, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2311 /* vqrdmlah */, ARM::VQRDMLAHv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasV8_1a, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2311 /* vqrdmlah */, ARM::VQRDMLAHv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasV8_1a, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2311 /* vqrdmlah */, ARM::VQRDMLAHv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasV8_1a, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2311 /* vqrdmlah */, ARM::VQRDMLAHslv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON|Feature_HasV8_1a, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2311 /* vqrdmlah */, ARM::VQRDMLAHslv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON|Feature_HasV8_1a, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2311 /* vqrdmlah */, ARM::VQRDMLAHslv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON|Feature_HasV8_1a, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2311 /* vqrdmlah */, ARM::VQRDMLAHslv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON|Feature_HasV8_1a, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2320 /* vqrdmlsh */, ARM::VQRDMLSHv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasV8_1a, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2320 /* vqrdmlsh */, ARM::VQRDMLSHv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasV8_1a, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2320 /* vqrdmlsh */, ARM::VQRDMLSHv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasV8_1a, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2320 /* vqrdmlsh */, ARM::VQRDMLSHv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasV8_1a, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2320 /* vqrdmlsh */, ARM::VQRDMLSHslv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON|Feature_HasV8_1a, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2320 /* vqrdmlsh */, ARM::VQRDMLSHslv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON|Feature_HasV8_1a, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2320 /* vqrdmlsh */, ARM::VQRDMLSHslv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON|Feature_HasV8_1a, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2320 /* vqrdmlsh */, ARM::VQRDMLSHslv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON|Feature_HasV8_1a, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2329 /* vqrdmulh */, ARM::VQRDMULHv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2329 /* vqrdmulh */, ARM::VQRDMULHv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2329 /* vqrdmulh */, ARM::VQRDMULHv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2329 /* vqrdmulh */, ARM::VQRDMULHv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2329 /* vqrdmulh */, ARM::VQRDMULHv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2329 /* vqrdmulh */, ARM::VQRDMULHv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2329 /* vqrdmulh */, ARM::VQRDMULHv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2329 /* vqrdmulh */, ARM::VQRDMULHv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2329 /* vqrdmulh */, ARM::VQRDMULHslv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2329 /* vqrdmulh */, ARM::VQRDMULHslv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2329 /* vqrdmulh */, ARM::VQRDMULHslv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2329 /* vqrdmulh */, ARM::VQRDMULHslv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2338 /* vqrshl */, ARM::VQRSHLsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLsv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLsv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLsv2i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_QPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLsv1i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_DPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLsv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLsv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLuv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLuv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLuv2i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_QPR, MCK_QPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLuv1i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_DPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLuv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLuv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLsv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLsv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLsv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLsv1i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLsv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLsv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLuv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLuv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLuv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLuv1i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLuv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2338 /* vqrshl */, ARM::VQRSHLuv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2345 /* vqrshrn */, ARM::VQRSHRNsv8i8, Convert__Reg1_2__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_QPR, MCK_ShrImm8 }, },
  { 2345 /* vqrshrn */, ARM::VQRSHRNsv4i16, Convert__Reg1_2__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_QPR, MCK_ShrImm16 }, },
  { 2345 /* vqrshrn */, ARM::VQRSHRNsv2i32, Convert__Reg1_2__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_QPR, MCK_ShrImm32 }, },
  { 2345 /* vqrshrn */, ARM::VQRSHRNuv8i8, Convert__Reg1_2__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_QPR, MCK_ShrImm8 }, },
  { 2345 /* vqrshrn */, ARM::VQRSHRNuv4i16, Convert__Reg1_2__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_QPR, MCK_ShrImm16 }, },
  { 2345 /* vqrshrn */, ARM::VQRSHRNuv2i32, Convert__Reg1_2__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_QPR, MCK_ShrImm32 }, },
  { 2353 /* vqrshrun */, ARM::VQRSHRUNv8i8, Convert__Reg1_2__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_QPR, MCK_ShrImm8 }, },
  { 2353 /* vqrshrun */, ARM::VQRSHRUNv4i16, Convert__Reg1_2__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_QPR, MCK_ShrImm16 }, },
  { 2353 /* vqrshrun */, ARM::VQRSHRUNv2i32, Convert__Reg1_2__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_QPR, MCK_ShrImm32 }, },
  { 2362 /* vqshl */, ARM::VQSHLsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2362 /* vqshl */, ARM::VQSHLsiv8i16, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLsv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2362 /* vqshl */, ARM::VQSHLsiv4i16, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2362 /* vqshl */, ARM::VQSHLsiv4i32, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLsv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2362 /* vqshl */, ARM::VQSHLsiv2i32, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLsv2i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_QPR }, },
  { 2362 /* vqshl */, ARM::VQSHLsiv2i64, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLsv1i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_DPR }, },
  { 2362 /* vqshl */, ARM::VQSHLsiv1i64, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLsv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2362 /* vqshl */, ARM::VQSHLsiv16i8, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLsv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2362 /* vqshl */, ARM::VQSHLsiv8i8, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 2362 /* vqshl */, ARM::VQSHLuiv8i16, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLuv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 2362 /* vqshl */, ARM::VQSHLuiv4i16, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 2362 /* vqshl */, ARM::VQSHLuiv4i32, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLuv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2362 /* vqshl */, ARM::VQSHLuiv2i32, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLuv2i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_QPR, MCK_QPR }, },
  { 2362 /* vqshl */, ARM::VQSHLuiv2i64, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_QPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLuv1i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_DPR }, },
  { 2362 /* vqshl */, ARM::VQSHLuiv1i64, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLuv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR }, },
  { 2362 /* vqshl */, ARM::VQSHLuiv16i8, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLuv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 2362 /* vqshl */, ARM::VQSHLuiv8i8, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2362 /* vqshl */, ARM::VQSHLsiv8i16, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLsv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2362 /* vqshl */, ARM::VQSHLsiv4i16, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2362 /* vqshl */, ARM::VQSHLsiv4i32, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLsv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2362 /* vqshl */, ARM::VQSHLsiv2i32, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLsv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2362 /* vqshl */, ARM::VQSHLsiv2i64, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLsv1i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2362 /* vqshl */, ARM::VQSHLsiv1i64, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLsv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2362 /* vqshl */, ARM::VQSHLsiv16i8, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLsv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2362 /* vqshl */, ARM::VQSHLsiv8i8, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2362 /* vqshl */, ARM::VQSHLuiv8i16, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLuv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2362 /* vqshl */, ARM::VQSHLuiv4i16, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2362 /* vqshl */, ARM::VQSHLuiv4i32, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLuv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2362 /* vqshl */, ARM::VQSHLuiv2i32, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLuv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2362 /* vqshl */, ARM::VQSHLuiv2i64, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLuv1i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2362 /* vqshl */, ARM::VQSHLuiv1i64, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLuv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2362 /* vqshl */, ARM::VQSHLuiv16i8, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2362 /* vqshl */, ARM::VQSHLuv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2362 /* vqshl */, ARM::VQSHLuiv8i8, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2368 /* vqshlu */, ARM::VQSHLsuv8i16, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_Imm }, },
  { 2368 /* vqshlu */, ARM::VQSHLsuv4i16, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_Imm }, },
  { 2368 /* vqshlu */, ARM::VQSHLsuv4i32, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_Imm }, },
  { 2368 /* vqshlu */, ARM::VQSHLsuv2i32, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_Imm }, },
  { 2368 /* vqshlu */, ARM::VQSHLsuv2i64, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_Imm }, },
  { 2368 /* vqshlu */, ARM::VQSHLsuv1i64, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_Imm }, },
  { 2368 /* vqshlu */, ARM::VQSHLsuv16i8, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_Imm }, },
  { 2368 /* vqshlu */, ARM::VQSHLsuv8i8, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_Imm }, },
  { 2368 /* vqshlu */, ARM::VQSHLsuv8i16, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2368 /* vqshlu */, ARM::VQSHLsuv4i16, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2368 /* vqshlu */, ARM::VQSHLsuv4i32, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2368 /* vqshlu */, ARM::VQSHLsuv2i32, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2368 /* vqshlu */, ARM::VQSHLsuv2i64, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2368 /* vqshlu */, ARM::VQSHLsuv1i64, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2368 /* vqshlu */, ARM::VQSHLsuv16i8, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2368 /* vqshlu */, ARM::VQSHLsuv8i8, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2375 /* vqshrn */, ARM::VQSHRNsv8i8, Convert__Reg1_2__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_QPR, MCK_ShrImm8 }, },
  { 2375 /* vqshrn */, ARM::VQSHRNsv4i16, Convert__Reg1_2__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_QPR, MCK_ShrImm16 }, },
  { 2375 /* vqshrn */, ARM::VQSHRNsv2i32, Convert__Reg1_2__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_QPR, MCK_ShrImm32 }, },
  { 2375 /* vqshrn */, ARM::VQSHRNuv8i8, Convert__Reg1_2__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_QPR, MCK_ShrImm8 }, },
  { 2375 /* vqshrn */, ARM::VQSHRNuv4i16, Convert__Reg1_2__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_QPR, MCK_ShrImm16 }, },
  { 2375 /* vqshrn */, ARM::VQSHRNuv2i32, Convert__Reg1_2__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_QPR, MCK_ShrImm32 }, },
  { 2382 /* vqshrun */, ARM::VQSHRUNv8i8, Convert__Reg1_2__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_QPR, MCK_ShrImm8 }, },
  { 2382 /* vqshrun */, ARM::VQSHRUNv4i16, Convert__Reg1_2__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_QPR, MCK_ShrImm16 }, },
  { 2382 /* vqshrun */, ARM::VQSHRUNv2i32, Convert__Reg1_2__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_QPR, MCK_ShrImm32 }, },
  { 2390 /* vqsub */, ARM::VQSUBsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2390 /* vqsub */, ARM::VQSUBsv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2390 /* vqsub */, ARM::VQSUBsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2390 /* vqsub */, ARM::VQSUBsv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2390 /* vqsub */, ARM::VQSUBsv2i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_QPR }, },
  { 2390 /* vqsub */, ARM::VQSUBsv1i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_DPR }, },
  { 2390 /* vqsub */, ARM::VQSUBsv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2390 /* vqsub */, ARM::VQSUBsv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2390 /* vqsub */, ARM::VQSUBuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 2390 /* vqsub */, ARM::VQSUBuv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 2390 /* vqsub */, ARM::VQSUBuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 2390 /* vqsub */, ARM::VQSUBuv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2390 /* vqsub */, ARM::VQSUBuv2i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_QPR, MCK_QPR }, },
  { 2390 /* vqsub */, ARM::VQSUBuv1i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_DPR }, },
  { 2390 /* vqsub */, ARM::VQSUBuv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR }, },
  { 2390 /* vqsub */, ARM::VQSUBuv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 2390 /* vqsub */, ARM::VQSUBsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2390 /* vqsub */, ARM::VQSUBsv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2390 /* vqsub */, ARM::VQSUBsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2390 /* vqsub */, ARM::VQSUBsv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2390 /* vqsub */, ARM::VQSUBsv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2390 /* vqsub */, ARM::VQSUBsv1i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2390 /* vqsub */, ARM::VQSUBsv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2390 /* vqsub */, ARM::VQSUBsv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2390 /* vqsub */, ARM::VQSUBuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2390 /* vqsub */, ARM::VQSUBuv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2390 /* vqsub */, ARM::VQSUBuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2390 /* vqsub */, ARM::VQSUBuv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2390 /* vqsub */, ARM::VQSUBuv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2390 /* vqsub */, ARM::VQSUBuv1i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2390 /* vqsub */, ARM::VQSUBuv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2390 /* vqsub */, ARM::VQSUBuv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2396 /* vraddhn */, ARM::VRADDHNv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_QPR, MCK_QPR }, },
  { 2396 /* vraddhn */, ARM::VRADDHNv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_QPR, MCK_QPR }, },
  { 2396 /* vraddhn */, ARM::VRADDHNv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_DPR, MCK_QPR, MCK_QPR }, },
  { 2404 /* vrecpe */, ARM::VRECPEq, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 2404 /* vrecpe */, ARM::VRECPEd, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2404 /* vrecpe */, ARM::VRECPEfq, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2404 /* vrecpe */, ARM::VRECPEfd, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2404 /* vrecpe */, ARM::VRECPEhq, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2404 /* vrecpe */, ARM::VRECPEhd, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2411 /* vrecps */, ARM::VRECPSfq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2411 /* vrecps */, ARM::VRECPSfd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2411 /* vrecps */, ARM::VRECPShq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2411 /* vrecps */, ARM::VRECPShd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2411 /* vrecps */, ARM::VRECPSfq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2411 /* vrecps */, ARM::VRECPSfd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2411 /* vrecps */, ARM::VRECPShq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2411 /* vrecps */, ARM::VRECPShd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2418 /* vrev16 */, ARM::VREV16q8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 2418 /* vrev16 */, ARM::VREV16d8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR }, },
  { 2425 /* vrev32 */, ARM::VREV32q16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR }, },
  { 2425 /* vrev32 */, ARM::VREV32d16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR }, },
  { 2425 /* vrev32 */, ARM::VREV32q8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 2425 /* vrev32 */, ARM::VREV32d8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR }, },
  { 2432 /* vrev64 */, ARM::VREV64q16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR }, },
  { 2432 /* vrev64 */, ARM::VREV64d16, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR }, },
  { 2432 /* vrev64 */, ARM::VREV64q32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR }, },
  { 2432 /* vrev64 */, ARM::VREV64d32, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR }, },
  { 2432 /* vrev64 */, ARM::VREV64q8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 2432 /* vrev64 */, ARM::VREV64d8, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDsv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDsv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDsv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDsv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDuv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDuv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDuv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDuv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDsv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDsv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDsv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDsv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDuv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDuv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDuv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2439 /* vrhadd */, ARM::VRHADDuv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2446 /* vrinta */, ARM::VRINTANQf, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON, { MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2446 /* vrinta */, ARM::VRINTANDf, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON, { MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2446 /* vrinta */, ARM::VRINTAS, Convert__Reg1_1__Reg1_2, Feature_HasFPARMv8, { MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2446 /* vrinta */, ARM::VRINTAD, Convert__Reg1_1__Reg1_2, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2446 /* vrinta */, ARM::VRINTANQh, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2446 /* vrinta */, ARM::VRINTANDh, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2446 /* vrinta */, ARM::VRINTAH, Convert__Reg1_1__Reg1_2, Feature_HasFullFP16, { MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2446 /* vrinta */, ARM::VRINTANQf, Convert__Reg1_2__Reg1_3, Feature_HasNEON, { MCK__DOT_f32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2446 /* vrinta */, ARM::VRINTANDf, Convert__Reg1_2__Reg1_3, Feature_HasNEON, { MCK__DOT_f32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2446 /* vrinta */, ARM::VRINTAS, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8, { MCK__DOT_f32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2446 /* vrinta */, ARM::VRINTAD, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK__DOT_f64, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2446 /* vrinta */, ARM::VRINTANQh, Convert__Reg1_2__Reg1_3, Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2446 /* vrinta */, ARM::VRINTANDh, Convert__Reg1_2__Reg1_3, Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2453 /* vrintm */, ARM::VRINTMNQf, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON, { MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2453 /* vrintm */, ARM::VRINTMNDf, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON, { MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2453 /* vrintm */, ARM::VRINTMS, Convert__Reg1_1__Reg1_2, Feature_HasFPARMv8, { MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2453 /* vrintm */, ARM::VRINTMD, Convert__Reg1_1__Reg1_2, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2453 /* vrintm */, ARM::VRINTMNQh, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2453 /* vrintm */, ARM::VRINTMNDh, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2453 /* vrintm */, ARM::VRINTMH, Convert__Reg1_1__Reg1_2, Feature_HasFullFP16, { MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2453 /* vrintm */, ARM::VRINTMNQf, Convert__Reg1_2__Reg1_3, Feature_HasNEON, { MCK__DOT_f32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2453 /* vrintm */, ARM::VRINTMNDf, Convert__Reg1_2__Reg1_3, Feature_HasNEON, { MCK__DOT_f32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2453 /* vrintm */, ARM::VRINTMS, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8, { MCK__DOT_f32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2453 /* vrintm */, ARM::VRINTMD, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK__DOT_f64, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2453 /* vrintm */, ARM::VRINTMNQh, Convert__Reg1_2__Reg1_3, Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2453 /* vrintm */, ARM::VRINTMNDh, Convert__Reg1_2__Reg1_3, Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2460 /* vrintn */, ARM::VRINTNNQf, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON, { MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2460 /* vrintn */, ARM::VRINTNNDf, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON, { MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2460 /* vrintn */, ARM::VRINTNS, Convert__Reg1_1__Reg1_2, Feature_HasFPARMv8, { MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2460 /* vrintn */, ARM::VRINTND, Convert__Reg1_1__Reg1_2, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2460 /* vrintn */, ARM::VRINTNNQh, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2460 /* vrintn */, ARM::VRINTNNDh, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2460 /* vrintn */, ARM::VRINTNH, Convert__Reg1_1__Reg1_2, Feature_HasFullFP16, { MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2460 /* vrintn */, ARM::VRINTNNQf, Convert__Reg1_2__Reg1_3, Feature_HasNEON, { MCK__DOT_f32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2460 /* vrintn */, ARM::VRINTNNDf, Convert__Reg1_2__Reg1_3, Feature_HasNEON, { MCK__DOT_f32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2460 /* vrintn */, ARM::VRINTNS, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8, { MCK__DOT_f32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2460 /* vrintn */, ARM::VRINTND, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK__DOT_f64, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2460 /* vrintn */, ARM::VRINTNNQh, Convert__Reg1_2__Reg1_3, Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2460 /* vrintn */, ARM::VRINTNNDh, Convert__Reg1_2__Reg1_3, Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2467 /* vrintp */, ARM::VRINTPNQf, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON, { MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2467 /* vrintp */, ARM::VRINTPNDf, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON, { MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2467 /* vrintp */, ARM::VRINTPS, Convert__Reg1_1__Reg1_2, Feature_HasFPARMv8, { MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2467 /* vrintp */, ARM::VRINTPD, Convert__Reg1_1__Reg1_2, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2467 /* vrintp */, ARM::VRINTPNQh, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2467 /* vrintp */, ARM::VRINTPNDh, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2467 /* vrintp */, ARM::VRINTPH, Convert__Reg1_1__Reg1_2, Feature_HasFullFP16, { MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2467 /* vrintp */, ARM::VRINTPNQf, Convert__Reg1_2__Reg1_3, Feature_HasNEON, { MCK__DOT_f32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2467 /* vrintp */, ARM::VRINTPNDf, Convert__Reg1_2__Reg1_3, Feature_HasNEON, { MCK__DOT_f32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2467 /* vrintp */, ARM::VRINTPS, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8, { MCK__DOT_f32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2467 /* vrintp */, ARM::VRINTPD, Convert__Reg1_2__Reg1_3, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK__DOT_f64, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2467 /* vrintp */, ARM::VRINTPNQh, Convert__Reg1_2__Reg1_3, Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2467 /* vrintp */, ARM::VRINTPNDh, Convert__Reg1_2__Reg1_3, Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2474 /* vrintr */, ARM::VRINTRS, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasFPARMv8, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2474 /* vrintr */, ARM::VRINTRD, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2474 /* vrintr */, ARM::VRINTRH, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2474 /* vrintr */, ARM::VRINTRS, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFPARMv8, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2474 /* vrintr */, ARM::VRINTRD, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2474 /* vrintr */, ARM::VRINTRH, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2481 /* vrintx */, ARM::VRINTXNQf, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON, { MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2481 /* vrintx */, ARM::VRINTXNDf, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON, { MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2481 /* vrintx */, ARM::VRINTXNQh, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2481 /* vrintx */, ARM::VRINTXNDh, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2481 /* vrintx */, ARM::VRINTXNQf, Convert__Reg1_2__Reg1_3, Feature_HasNEON, { MCK__DOT_f32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2481 /* vrintx */, ARM::VRINTXNDf, Convert__Reg1_2__Reg1_3, Feature_HasNEON, { MCK__DOT_f32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2481 /* vrintx */, ARM::VRINTXNQh, Convert__Reg1_2__Reg1_3, Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2481 /* vrintx */, ARM::VRINTXNDh, Convert__Reg1_2__Reg1_3, Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2481 /* vrintx */, ARM::VRINTXS, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasFPARMv8, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2481 /* vrintx */, ARM::VRINTXD, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2481 /* vrintx */, ARM::VRINTXH, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2481 /* vrintx */, ARM::VRINTXS, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFPARMv8, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2481 /* vrintx */, ARM::VRINTXD, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2481 /* vrintx */, ARM::VRINTXH, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2488 /* vrintz */, ARM::VRINTZNQf, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON, { MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2488 /* vrintz */, ARM::VRINTZNDf, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON, { MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2488 /* vrintz */, ARM::VRINTZNQh, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2488 /* vrintz */, ARM::VRINTZNDh, Convert__Reg1_1__Reg1_2, Feature_HasV8|Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2488 /* vrintz */, ARM::VRINTZNQf, Convert__Reg1_2__Reg1_3, Feature_HasNEON, { MCK__DOT_f32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2488 /* vrintz */, ARM::VRINTZNDf, Convert__Reg1_2__Reg1_3, Feature_HasNEON, { MCK__DOT_f32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2488 /* vrintz */, ARM::VRINTZNQh, Convert__Reg1_2__Reg1_3, Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2488 /* vrintz */, ARM::VRINTZNDh, Convert__Reg1_2__Reg1_3, Feature_HasNEON|Feature_HasFullFP16, { MCK__DOT_f16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2488 /* vrintz */, ARM::VRINTZS, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasFPARMv8, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2488 /* vrintz */, ARM::VRINTZD, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2488 /* vrintz */, ARM::VRINTZH, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2488 /* vrintz */, ARM::VRINTZS, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFPARMv8, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2488 /* vrintz */, ARM::VRINTZD, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2488 /* vrintz */, ARM::VRINTZH, Convert__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2495 /* vrshl */, ARM::VRSHLsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2495 /* vrshl */, ARM::VRSHLsv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2495 /* vrshl */, ARM::VRSHLsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2495 /* vrshl */, ARM::VRSHLsv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2495 /* vrshl */, ARM::VRSHLsv2i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_QPR }, },
  { 2495 /* vrshl */, ARM::VRSHLsv1i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_DPR }, },
  { 2495 /* vrshl */, ARM::VRSHLsv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2495 /* vrshl */, ARM::VRSHLsv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2495 /* vrshl */, ARM::VRSHLuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 2495 /* vrshl */, ARM::VRSHLuv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 2495 /* vrshl */, ARM::VRSHLuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 2495 /* vrshl */, ARM::VRSHLuv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2495 /* vrshl */, ARM::VRSHLuv2i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_QPR, MCK_QPR }, },
  { 2495 /* vrshl */, ARM::VRSHLuv1i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_DPR }, },
  { 2495 /* vrshl */, ARM::VRSHLuv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR }, },
  { 2495 /* vrshl */, ARM::VRSHLuv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 2495 /* vrshl */, ARM::VRSHLsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2495 /* vrshl */, ARM::VRSHLsv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2495 /* vrshl */, ARM::VRSHLsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2495 /* vrshl */, ARM::VRSHLsv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2495 /* vrshl */, ARM::VRSHLsv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2495 /* vrshl */, ARM::VRSHLsv1i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2495 /* vrshl */, ARM::VRSHLsv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2495 /* vrshl */, ARM::VRSHLsv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2495 /* vrshl */, ARM::VRSHLuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2495 /* vrshl */, ARM::VRSHLuv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2495 /* vrshl */, ARM::VRSHLuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2495 /* vrshl */, ARM::VRSHLuv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2495 /* vrshl */, ARM::VRSHLuv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2495 /* vrshl */, ARM::VRSHLuv1i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2495 /* vrshl */, ARM::VRSHLuv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2495 /* vrshl */, ARM::VRSHLuv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2501 /* vrshr */, ARM::VRSHRsv8i16, Convert__Reg1_2__Reg1_2__ShrImm161_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_ShrImm16 }, },
  { 2501 /* vrshr */, ARM::VRSHRsv4i16, Convert__Reg1_2__Reg1_2__ShrImm161_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_ShrImm16 }, },
  { 2501 /* vrshr */, ARM::VRSHRsv4i32, Convert__Reg1_2__Reg1_2__ShrImm321_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_ShrImm32 }, },
  { 2501 /* vrshr */, ARM::VRSHRsv2i32, Convert__Reg1_2__Reg1_2__ShrImm321_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_ShrImm32 }, },
  { 2501 /* vrshr */, ARM::VRSHRsv2i64, Convert__Reg1_2__Reg1_2__ShrImm641_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_ShrImm64 }, },
  { 2501 /* vrshr */, ARM::VRSHRsv1i64, Convert__Reg1_2__Reg1_2__ShrImm641_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_ShrImm64 }, },
  { 2501 /* vrshr */, ARM::VRSHRsv16i8, Convert__Reg1_2__Reg1_2__ShrImm81_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_ShrImm8 }, },
  { 2501 /* vrshr */, ARM::VRSHRsv8i8, Convert__Reg1_2__Reg1_2__ShrImm81_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_ShrImm8 }, },
  { 2501 /* vrshr */, ARM::VRSHRuv8i16, Convert__Reg1_2__Reg1_2__ShrImm161_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_ShrImm16 }, },
  { 2501 /* vrshr */, ARM::VRSHRuv4i16, Convert__Reg1_2__Reg1_2__ShrImm161_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_ShrImm16 }, },
  { 2501 /* vrshr */, ARM::VRSHRuv4i32, Convert__Reg1_2__Reg1_2__ShrImm321_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_ShrImm32 }, },
  { 2501 /* vrshr */, ARM::VRSHRuv2i32, Convert__Reg1_2__Reg1_2__ShrImm321_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_ShrImm32 }, },
  { 2501 /* vrshr */, ARM::VRSHRuv2i64, Convert__Reg1_2__Reg1_2__ShrImm641_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_QPR, MCK_ShrImm64 }, },
  { 2501 /* vrshr */, ARM::VRSHRuv1i64, Convert__Reg1_2__Reg1_2__ShrImm641_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_ShrImm64 }, },
  { 2501 /* vrshr */, ARM::VRSHRuv16i8, Convert__Reg1_2__Reg1_2__ShrImm81_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_ShrImm8 }, },
  { 2501 /* vrshr */, ARM::VRSHRuv8i8, Convert__Reg1_2__Reg1_2__ShrImm81_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_ShrImm8 }, },
  { 2501 /* vrshr */, ARM::VRSHRsv8i16, Convert__Reg1_2__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_ShrImm16 }, },
  { 2501 /* vrshr */, ARM::VRSHRsv4i16, Convert__Reg1_2__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_ShrImm16 }, },
  { 2501 /* vrshr */, ARM::VRSHRsv4i32, Convert__Reg1_2__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_ShrImm32 }, },
  { 2501 /* vrshr */, ARM::VRSHRsv2i32, Convert__Reg1_2__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_ShrImm32 }, },
  { 2501 /* vrshr */, ARM::VRSHRsv2i64, Convert__Reg1_2__Reg1_3__ShrImm641_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_QPR, MCK_ShrImm64 }, },
  { 2501 /* vrshr */, ARM::VRSHRsv1i64, Convert__Reg1_2__Reg1_3__ShrImm641_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_DPR, MCK_ShrImm64 }, },
  { 2501 /* vrshr */, ARM::VRSHRsv16i8, Convert__Reg1_2__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_ShrImm8 }, },
  { 2501 /* vrshr */, ARM::VRSHRsv8i8, Convert__Reg1_2__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_ShrImm8 }, },
  { 2501 /* vrshr */, ARM::VRSHRuv8i16, Convert__Reg1_2__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_ShrImm16 }, },
  { 2501 /* vrshr */, ARM::VRSHRuv4i16, Convert__Reg1_2__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_ShrImm16 }, },
  { 2501 /* vrshr */, ARM::VRSHRuv4i32, Convert__Reg1_2__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_ShrImm32 }, },
  { 2501 /* vrshr */, ARM::VRSHRuv2i32, Convert__Reg1_2__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_ShrImm32 }, },
  { 2501 /* vrshr */, ARM::VRSHRuv2i64, Convert__Reg1_2__Reg1_3__ShrImm641_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_QPR, MCK_QPR, MCK_ShrImm64 }, },
  { 2501 /* vrshr */, ARM::VRSHRuv1i64, Convert__Reg1_2__Reg1_3__ShrImm641_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_DPR, MCK_ShrImm64 }, },
  { 2501 /* vrshr */, ARM::VRSHRuv16i8, Convert__Reg1_2__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_ShrImm8 }, },
  { 2501 /* vrshr */, ARM::VRSHRuv8i8, Convert__Reg1_2__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_ShrImm8 }, },
  { 2507 /* vrshrn */, ARM::VRSHRNv8i8, Convert__Reg1_2__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_QPR, MCK_ShrImm8 }, },
  { 2507 /* vrshrn */, ARM::VRSHRNv4i16, Convert__Reg1_2__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_QPR, MCK_ShrImm16 }, },
  { 2507 /* vrshrn */, ARM::VRSHRNv2i32, Convert__Reg1_2__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_DPR, MCK_QPR, MCK_ShrImm32 }, },
  { 2514 /* vrsqrte */, ARM::VRSQRTEq, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 2514 /* vrsqrte */, ARM::VRSQRTEd, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2514 /* vrsqrte */, ARM::VRSQRTEfq, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2514 /* vrsqrte */, ARM::VRSQRTEfd, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2514 /* vrsqrte */, ARM::VRSQRTEhq, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2514 /* vrsqrte */, ARM::VRSQRTEhd, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2522 /* vrsqrts */, ARM::VRSQRTSfq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2522 /* vrsqrts */, ARM::VRSQRTSfd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2522 /* vrsqrts */, ARM::VRSQRTShq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2522 /* vrsqrts */, ARM::VRSQRTShd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2522 /* vrsqrts */, ARM::VRSQRTSfq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2522 /* vrsqrts */, ARM::VRSQRTSfd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2522 /* vrsqrts */, ARM::VRSQRTShq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2522 /* vrsqrts */, ARM::VRSQRTShd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2530 /* vrsra */, ARM::VRSRAsv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm161_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_ShrImm16 }, },
  { 2530 /* vrsra */, ARM::VRSRAsv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm161_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_ShrImm16 }, },
  { 2530 /* vrsra */, ARM::VRSRAsv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm321_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_ShrImm32 }, },
  { 2530 /* vrsra */, ARM::VRSRAsv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm321_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_ShrImm32 }, },
  { 2530 /* vrsra */, ARM::VRSRAsv2i64, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm641_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_ShrImm64 }, },
  { 2530 /* vrsra */, ARM::VRSRAsv1i64, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm641_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_ShrImm64 }, },
  { 2530 /* vrsra */, ARM::VRSRAsv16i8, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm81_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_ShrImm8 }, },
  { 2530 /* vrsra */, ARM::VRSRAsv8i8, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm81_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_ShrImm8 }, },
  { 2530 /* vrsra */, ARM::VRSRAuv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm161_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_ShrImm16 }, },
  { 2530 /* vrsra */, ARM::VRSRAuv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm161_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_ShrImm16 }, },
  { 2530 /* vrsra */, ARM::VRSRAuv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm321_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_ShrImm32 }, },
  { 2530 /* vrsra */, ARM::VRSRAuv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm321_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_ShrImm32 }, },
  { 2530 /* vrsra */, ARM::VRSRAuv2i64, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm641_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_QPR, MCK_ShrImm64 }, },
  { 2530 /* vrsra */, ARM::VRSRAuv1i64, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm641_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_ShrImm64 }, },
  { 2530 /* vrsra */, ARM::VRSRAuv16i8, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm81_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_ShrImm8 }, },
  { 2530 /* vrsra */, ARM::VRSRAuv8i8, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm81_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_ShrImm8 }, },
  { 2530 /* vrsra */, ARM::VRSRAsv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_ShrImm16 }, },
  { 2530 /* vrsra */, ARM::VRSRAsv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_ShrImm16 }, },
  { 2530 /* vrsra */, ARM::VRSRAsv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_ShrImm32 }, },
  { 2530 /* vrsra */, ARM::VRSRAsv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_ShrImm32 }, },
  { 2530 /* vrsra */, ARM::VRSRAsv2i64, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm641_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_QPR, MCK_ShrImm64 }, },
  { 2530 /* vrsra */, ARM::VRSRAsv1i64, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm641_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_DPR, MCK_ShrImm64 }, },
  { 2530 /* vrsra */, ARM::VRSRAsv16i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_ShrImm8 }, },
  { 2530 /* vrsra */, ARM::VRSRAsv8i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_ShrImm8 }, },
  { 2530 /* vrsra */, ARM::VRSRAuv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_ShrImm16 }, },
  { 2530 /* vrsra */, ARM::VRSRAuv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_ShrImm16 }, },
  { 2530 /* vrsra */, ARM::VRSRAuv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_ShrImm32 }, },
  { 2530 /* vrsra */, ARM::VRSRAuv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_ShrImm32 }, },
  { 2530 /* vrsra */, ARM::VRSRAuv2i64, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm641_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_QPR, MCK_QPR, MCK_ShrImm64 }, },
  { 2530 /* vrsra */, ARM::VRSRAuv1i64, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm641_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_DPR, MCK_ShrImm64 }, },
  { 2530 /* vrsra */, ARM::VRSRAuv16i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_ShrImm8 }, },
  { 2530 /* vrsra */, ARM::VRSRAuv8i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_ShrImm8 }, },
  { 2536 /* vrsubhn */, ARM::VRSUBHNv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_QPR, MCK_QPR }, },
  { 2536 /* vrsubhn */, ARM::VRSUBHNv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_QPR, MCK_QPR }, },
  { 2536 /* vrsubhn */, ARM::VRSUBHNv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_DPR, MCK_QPR, MCK_QPR }, },
  { 2544 /* vsdot */, ARM::VSDOTQ, Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3, Feature_HasDotProd, { MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2544 /* vsdot */, ARM::VSDOTD, Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3, Feature_HasDotProd, { MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2544 /* vsdot */, ARM::VSDOTQI, Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3__VectorIndex321_4, Feature_HasDotProd, { MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2544 /* vsdot */, ARM::VSDOTDI, Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3__VectorIndex321_4, Feature_HasDotProd, { MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2550 /* vseleq */, ARM::VSELEQS, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasFPARMv8, { MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2550 /* vseleq */, ARM::VSELEQD, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2550 /* vseleq */, ARM::VSELEQH, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasFullFP16, { MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2557 /* vselge */, ARM::VSELGES, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasFPARMv8, { MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2557 /* vselge */, ARM::VSELGED, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2557 /* vselge */, ARM::VSELGEH, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasFullFP16, { MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2564 /* vselgt */, ARM::VSELGTS, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasFPARMv8, { MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2564 /* vselgt */, ARM::VSELGTD, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2564 /* vselgt */, ARM::VSELGTH, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasFullFP16, { MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2571 /* vselvs */, ARM::VSELVSS, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasFPARMv8, { MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2571 /* vselvs */, ARM::VSELVSD, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasFPARMv8|Feature_HasDPVFP, { MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2571 /* vselvs */, ARM::VSELVSH, Convert__Reg1_1__Reg1_2__Reg1_3, Feature_HasFullFP16, { MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2578 /* vshl */, ARM::VSHLsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2578 /* vshl */, ARM::VSHLsv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2578 /* vshl */, ARM::VSHLsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2578 /* vshl */, ARM::VSHLsv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2578 /* vshl */, ARM::VSHLsv2i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_QPR }, },
  { 2578 /* vshl */, ARM::VSHLsv1i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_DPR }, },
  { 2578 /* vshl */, ARM::VSHLsv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2578 /* vshl */, ARM::VSHLsv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2578 /* vshl */, ARM::VSHLuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 2578 /* vshl */, ARM::VSHLuv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 2578 /* vshl */, ARM::VSHLuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 2578 /* vshl */, ARM::VSHLuv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2578 /* vshl */, ARM::VSHLuv2i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_QPR, MCK_QPR }, },
  { 2578 /* vshl */, ARM::VSHLuv1i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_DPR }, },
  { 2578 /* vshl */, ARM::VSHLuv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR }, },
  { 2578 /* vshl */, ARM::VSHLuv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 2578 /* vshl */, ARM::VSHLiv8i16, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_Imm }, },
  { 2578 /* vshl */, ARM::VSHLiv4i16, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_Imm }, },
  { 2578 /* vshl */, ARM::VSHLiv4i32, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_Imm }, },
  { 2578 /* vshl */, ARM::VSHLiv2i32, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_Imm }, },
  { 2578 /* vshl */, ARM::VSHLiv2i64, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_QPR, MCK_Imm }, },
  { 2578 /* vshl */, ARM::VSHLiv1i64, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_DPR, MCK_Imm }, },
  { 2578 /* vshl */, ARM::VSHLiv16i8, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK_Imm }, },
  { 2578 /* vshl */, ARM::VSHLiv8i8, Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_Imm }, },
  { 2578 /* vshl */, ARM::VSHLsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2578 /* vshl */, ARM::VSHLsv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2578 /* vshl */, ARM::VSHLsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2578 /* vshl */, ARM::VSHLsv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2578 /* vshl */, ARM::VSHLsv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2578 /* vshl */, ARM::VSHLsv1i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2578 /* vshl */, ARM::VSHLsv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2578 /* vshl */, ARM::VSHLsv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2578 /* vshl */, ARM::VSHLuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2578 /* vshl */, ARM::VSHLuv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2578 /* vshl */, ARM::VSHLuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2578 /* vshl */, ARM::VSHLuv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2578 /* vshl */, ARM::VSHLuv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2578 /* vshl */, ARM::VSHLuv1i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2578 /* vshl */, ARM::VSHLuv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2578 /* vshl */, ARM::VSHLuv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2578 /* vshl */, ARM::VSHLiv8i16, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2578 /* vshl */, ARM::VSHLiv4i16, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2578 /* vshl */, ARM::VSHLiv4i32, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2578 /* vshl */, ARM::VSHLiv2i32, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2578 /* vshl */, ARM::VSHLiv2i64, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2578 /* vshl */, ARM::VSHLiv1i64, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2578 /* vshl */, ARM::VSHLiv16i8, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2578 /* vshl */, ARM::VSHLiv8i8, Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2583 /* vshll */, ARM::VSHLLsv4i32, Convert__Reg1_2__Reg1_3__Imm1_151_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR, MCK_Imm1_15 }, },
  { 2583 /* vshll */, ARM::VSHLLsv2i64, Convert__Reg1_2__Reg1_3__Imm1_311_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR, MCK_Imm1_31 }, },
  { 2583 /* vshll */, ARM::VSHLLsv8i16, Convert__Reg1_2__Reg1_3__Imm1_71_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_DPR, MCK_Imm1_7 }, },
  { 2583 /* vshll */, ARM::VSHLLuv4i32, Convert__Reg1_2__Reg1_3__Imm1_151_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_DPR, MCK_Imm1_15 }, },
  { 2583 /* vshll */, ARM::VSHLLuv2i64, Convert__Reg1_2__Reg1_3__Imm1_311_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_DPR, MCK_Imm1_31 }, },
  { 2583 /* vshll */, ARM::VSHLLuv8i16, Convert__Reg1_2__Reg1_3__Imm1_71_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_DPR, MCK_Imm1_7 }, },
  { 2583 /* vshll */, ARM::VSHLLi16, Convert__Reg1_2__Reg1_3__Imm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_DPR, MCK_Imm16 }, },
  { 2583 /* vshll */, ARM::VSHLLi32, Convert__Reg1_2__Reg1_3__Imm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_DPR, MCK_Imm32 }, },
  { 2583 /* vshll */, ARM::VSHLLi8, Convert__Reg1_2__Reg1_3__Imm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK_DPR, MCK_Imm8 }, },
  { 2589 /* vshr */, ARM::VSHRsv8i16, Convert__Reg1_2__Reg1_2__ShrImm161_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_ShrImm16 }, },
  { 2589 /* vshr */, ARM::VSHRsv4i16, Convert__Reg1_2__Reg1_2__ShrImm161_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_ShrImm16 }, },
  { 2589 /* vshr */, ARM::VSHRsv4i32, Convert__Reg1_2__Reg1_2__ShrImm321_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_ShrImm32 }, },
  { 2589 /* vshr */, ARM::VSHRsv2i32, Convert__Reg1_2__Reg1_2__ShrImm321_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_ShrImm32 }, },
  { 2589 /* vshr */, ARM::VSHRsv2i64, Convert__Reg1_2__Reg1_2__ShrImm641_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_ShrImm64 }, },
  { 2589 /* vshr */, ARM::VSHRsv1i64, Convert__Reg1_2__Reg1_2__ShrImm641_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_ShrImm64 }, },
  { 2589 /* vshr */, ARM::VSHRsv16i8, Convert__Reg1_2__Reg1_2__ShrImm81_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_ShrImm8 }, },
  { 2589 /* vshr */, ARM::VSHRsv8i8, Convert__Reg1_2__Reg1_2__ShrImm81_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_ShrImm8 }, },
  { 2589 /* vshr */, ARM::VSHRuv8i16, Convert__Reg1_2__Reg1_2__ShrImm161_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_ShrImm16 }, },
  { 2589 /* vshr */, ARM::VSHRuv4i16, Convert__Reg1_2__Reg1_2__ShrImm161_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_ShrImm16 }, },
  { 2589 /* vshr */, ARM::VSHRuv4i32, Convert__Reg1_2__Reg1_2__ShrImm321_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_ShrImm32 }, },
  { 2589 /* vshr */, ARM::VSHRuv2i32, Convert__Reg1_2__Reg1_2__ShrImm321_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_ShrImm32 }, },
  { 2589 /* vshr */, ARM::VSHRuv2i64, Convert__Reg1_2__Reg1_2__ShrImm641_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_QPR, MCK_ShrImm64 }, },
  { 2589 /* vshr */, ARM::VSHRuv1i64, Convert__Reg1_2__Reg1_2__ShrImm641_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_ShrImm64 }, },
  { 2589 /* vshr */, ARM::VSHRuv16i8, Convert__Reg1_2__Reg1_2__ShrImm81_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_ShrImm8 }, },
  { 2589 /* vshr */, ARM::VSHRuv8i8, Convert__Reg1_2__Reg1_2__ShrImm81_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_ShrImm8 }, },
  { 2589 /* vshr */, ARM::VSHRsv8i16, Convert__Reg1_2__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_ShrImm16 }, },
  { 2589 /* vshr */, ARM::VSHRsv4i16, Convert__Reg1_2__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_ShrImm16 }, },
  { 2589 /* vshr */, ARM::VSHRsv4i32, Convert__Reg1_2__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_ShrImm32 }, },
  { 2589 /* vshr */, ARM::VSHRsv2i32, Convert__Reg1_2__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_ShrImm32 }, },
  { 2589 /* vshr */, ARM::VSHRsv2i64, Convert__Reg1_2__Reg1_3__ShrImm641_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_QPR, MCK_ShrImm64 }, },
  { 2589 /* vshr */, ARM::VSHRsv1i64, Convert__Reg1_2__Reg1_3__ShrImm641_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_DPR, MCK_ShrImm64 }, },
  { 2589 /* vshr */, ARM::VSHRsv16i8, Convert__Reg1_2__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_ShrImm8 }, },
  { 2589 /* vshr */, ARM::VSHRsv8i8, Convert__Reg1_2__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_ShrImm8 }, },
  { 2589 /* vshr */, ARM::VSHRuv8i16, Convert__Reg1_2__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_ShrImm16 }, },
  { 2589 /* vshr */, ARM::VSHRuv4i16, Convert__Reg1_2__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_ShrImm16 }, },
  { 2589 /* vshr */, ARM::VSHRuv4i32, Convert__Reg1_2__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_ShrImm32 }, },
  { 2589 /* vshr */, ARM::VSHRuv2i32, Convert__Reg1_2__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_ShrImm32 }, },
  { 2589 /* vshr */, ARM::VSHRuv2i64, Convert__Reg1_2__Reg1_3__ShrImm641_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_QPR, MCK_QPR, MCK_ShrImm64 }, },
  { 2589 /* vshr */, ARM::VSHRuv1i64, Convert__Reg1_2__Reg1_3__ShrImm641_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_DPR, MCK_ShrImm64 }, },
  { 2589 /* vshr */, ARM::VSHRuv16i8, Convert__Reg1_2__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_ShrImm8 }, },
  { 2589 /* vshr */, ARM::VSHRuv8i8, Convert__Reg1_2__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_ShrImm8 }, },
  { 2594 /* vshrn */, ARM::VSHRNv8i8, Convert__Reg1_2__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_QPR, MCK_ShrImm8 }, },
  { 2594 /* vshrn */, ARM::VSHRNv4i16, Convert__Reg1_2__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_QPR, MCK_ShrImm16 }, },
  { 2594 /* vshrn */, ARM::VSHRNv2i32, Convert__Reg1_2__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_DPR, MCK_QPR, MCK_ShrImm32 }, },
  { 2600 /* vsli */, ARM::VSLIv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_Imm }, },
  { 2600 /* vsli */, ARM::VSLIv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_Imm }, },
  { 2600 /* vsli */, ARM::VSLIv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_Imm }, },
  { 2600 /* vsli */, ARM::VSLIv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_Imm }, },
  { 2600 /* vsli */, ARM::VSLIv2i64, Convert__Reg1_2__Tie0_1_1__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_Imm }, },
  { 2600 /* vsli */, ARM::VSLIv1i64, Convert__Reg1_2__Tie0_1_1__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_Imm }, },
  { 2600 /* vsli */, ARM::VSLIv16i8, Convert__Reg1_2__Tie0_1_1__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_Imm }, },
  { 2600 /* vsli */, ARM::VSLIv8i8, Convert__Reg1_2__Tie0_1_1__Reg1_2__Imm1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_Imm }, },
  { 2600 /* vsli */, ARM::VSLIv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2600 /* vsli */, ARM::VSLIv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2600 /* vsli */, ARM::VSLIv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2600 /* vsli */, ARM::VSLIv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2600 /* vsli */, ARM::VSLIv2i64, Convert__Reg1_2__Tie0_1_1__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2600 /* vsli */, ARM::VSLIv1i64, Convert__Reg1_2__Tie0_1_1__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2600 /* vsli */, ARM::VSLIv16i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2600 /* vsli */, ARM::VSLIv8i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__Imm1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2605 /* vsqrt */, ARM::VSQRTD, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK_DPR, MCK_DPR }, },
  { 2605 /* vsqrt */, ARM::VSQRTS, Convert__Reg1_1__Reg1_2__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_HPR, MCK_HPR }, },
  { 2605 /* vsqrt */, ARM::VSQRTS, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2605 /* vsqrt */, ARM::VSQRTD, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2605 /* vsqrt */, ARM::VSQRTH, Convert__Reg1_2__Reg1_3__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2611 /* vsra */, ARM::VSRAsv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm161_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_ShrImm16 }, },
  { 2611 /* vsra */, ARM::VSRAsv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm161_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_ShrImm16 }, },
  { 2611 /* vsra */, ARM::VSRAsv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm321_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_ShrImm32 }, },
  { 2611 /* vsra */, ARM::VSRAsv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm321_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_ShrImm32 }, },
  { 2611 /* vsra */, ARM::VSRAsv2i64, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm641_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_ShrImm64 }, },
  { 2611 /* vsra */, ARM::VSRAsv1i64, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm641_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_ShrImm64 }, },
  { 2611 /* vsra */, ARM::VSRAsv16i8, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm81_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_ShrImm8 }, },
  { 2611 /* vsra */, ARM::VSRAsv8i8, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm81_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_ShrImm8 }, },
  { 2611 /* vsra */, ARM::VSRAuv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm161_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_ShrImm16 }, },
  { 2611 /* vsra */, ARM::VSRAuv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm161_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_ShrImm16 }, },
  { 2611 /* vsra */, ARM::VSRAuv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm321_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_ShrImm32 }, },
  { 2611 /* vsra */, ARM::VSRAuv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm321_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_ShrImm32 }, },
  { 2611 /* vsra */, ARM::VSRAuv2i64, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm641_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_QPR, MCK_ShrImm64 }, },
  { 2611 /* vsra */, ARM::VSRAuv1i64, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm641_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_ShrImm64 }, },
  { 2611 /* vsra */, ARM::VSRAuv16i8, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm81_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_ShrImm8 }, },
  { 2611 /* vsra */, ARM::VSRAuv8i8, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm81_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_ShrImm8 }, },
  { 2611 /* vsra */, ARM::VSRAsv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_ShrImm16 }, },
  { 2611 /* vsra */, ARM::VSRAsv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_ShrImm16 }, },
  { 2611 /* vsra */, ARM::VSRAsv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_ShrImm32 }, },
  { 2611 /* vsra */, ARM::VSRAsv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_ShrImm32 }, },
  { 2611 /* vsra */, ARM::VSRAsv2i64, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm641_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_QPR, MCK_QPR, MCK_ShrImm64 }, },
  { 2611 /* vsra */, ARM::VSRAsv1i64, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm641_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s64, MCK_DPR, MCK_DPR, MCK_ShrImm64 }, },
  { 2611 /* vsra */, ARM::VSRAsv16i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_ShrImm8 }, },
  { 2611 /* vsra */, ARM::VSRAsv8i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_ShrImm8 }, },
  { 2611 /* vsra */, ARM::VSRAuv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_ShrImm16 }, },
  { 2611 /* vsra */, ARM::VSRAuv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_ShrImm16 }, },
  { 2611 /* vsra */, ARM::VSRAuv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_ShrImm32 }, },
  { 2611 /* vsra */, ARM::VSRAuv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_ShrImm32 }, },
  { 2611 /* vsra */, ARM::VSRAuv2i64, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm641_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_QPR, MCK_QPR, MCK_ShrImm64 }, },
  { 2611 /* vsra */, ARM::VSRAuv1i64, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm641_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u64, MCK_DPR, MCK_DPR, MCK_ShrImm64 }, },
  { 2611 /* vsra */, ARM::VSRAuv16i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_ShrImm8 }, },
  { 2611 /* vsra */, ARM::VSRAuv8i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_ShrImm8 }, },
  { 2616 /* vsri */, ARM::VSRIv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm161_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_ShrImm16 }, },
  { 2616 /* vsri */, ARM::VSRIv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm161_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_ShrImm16 }, },
  { 2616 /* vsri */, ARM::VSRIv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm321_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_ShrImm32 }, },
  { 2616 /* vsri */, ARM::VSRIv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm321_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_ShrImm32 }, },
  { 2616 /* vsri */, ARM::VSRIv2i64, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm641_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_ShrImm64 }, },
  { 2616 /* vsri */, ARM::VSRIv1i64, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm641_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_ShrImm64 }, },
  { 2616 /* vsri */, ARM::VSRIv16i8, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm81_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_ShrImm8 }, },
  { 2616 /* vsri */, ARM::VSRIv8i8, Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm81_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_ShrImm8 }, },
  { 2616 /* vsri */, ARM::VSRIv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR, MCK_ShrImm16 }, },
  { 2616 /* vsri */, ARM::VSRIv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm161_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR, MCK_ShrImm16 }, },
  { 2616 /* vsri */, ARM::VSRIv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_ShrImm32 }, },
  { 2616 /* vsri */, ARM::VSRIv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm321_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR, MCK_ShrImm32 }, },
  { 2616 /* vsri */, ARM::VSRIv2i64, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm641_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR, MCK_ShrImm64 }, },
  { 2616 /* vsri */, ARM::VSRIv1i64, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm641_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_DPR, MCK_ShrImm64 }, },
  { 2616 /* vsri */, ARM::VSRIv16i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR, MCK_ShrImm8 }, },
  { 2616 /* vsri */, ARM::VSRIv8i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm81_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR, MCK_ShrImm8 }, },
  { 2621 /* vst1 */, ARM::VST1q16, Convert__AlignedMemory64or1282_3__VecListDPair1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPair, MCK_AlignedMemory64or128 }, },
  { 2621 /* vst1 */, ARM::VST1d16Q, Convert__AlignedMemory64or128or2562_3__VecListFourD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2621 /* vst1 */, ARM::VST1d16, Convert__AlignedMemory642_3__VecListOneD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneD, MCK_AlignedMemory64 }, },
  { 2621 /* vst1 */, ARM::VST1LNdAsm_16, Convert__VecListOneDHWordIndexed2_2__AlignedMemory162_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneDHWordIndexed, MCK_AlignedMemory16 }, },
  { 2621 /* vst1 */, ARM::VST1d16T, Convert__AlignedMemory642_3__VecListThreeD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeD, MCK_AlignedMemory64 }, },
  { 2621 /* vst1 */, ARM::VST1q32, Convert__AlignedMemory64or1282_3__VecListDPair1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPair, MCK_AlignedMemory64or128 }, },
  { 2621 /* vst1 */, ARM::VST1d32Q, Convert__AlignedMemory64or128or2562_3__VecListFourD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2621 /* vst1 */, ARM::VST1d32, Convert__AlignedMemory642_3__VecListOneD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneD, MCK_AlignedMemory64 }, },
  { 2621 /* vst1 */, ARM::VST1LNdAsm_32, Convert__VecListOneDWordIndexed2_2__AlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneDWordIndexed, MCK_AlignedMemory32 }, },
  { 2621 /* vst1 */, ARM::VST1d32T, Convert__AlignedMemory642_3__VecListThreeD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeD, MCK_AlignedMemory64 }, },
  { 2621 /* vst1 */, ARM::VST1q64, Convert__AlignedMemory64or1282_3__VecListDPair1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListDPair, MCK_AlignedMemory64or128 }, },
  { 2621 /* vst1 */, ARM::VST1d64Q, Convert__AlignedMemory64or128or2562_3__VecListFourD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2621 /* vst1 */, ARM::VST1d64, Convert__AlignedMemory642_3__VecListOneD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListOneD, MCK_AlignedMemory64 }, },
  { 2621 /* vst1 */, ARM::VST1d64T, Convert__AlignedMemory642_3__VecListThreeD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListThreeD, MCK_AlignedMemory64 }, },
  { 2621 /* vst1 */, ARM::VST1q8, Convert__AlignedMemory64or1282_3__VecListDPair1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPair, MCK_AlignedMemory64or128 }, },
  { 2621 /* vst1 */, ARM::VST1d8Q, Convert__AlignedMemory64or128or2562_3__VecListFourD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2621 /* vst1 */, ARM::VST1d8, Convert__AlignedMemory642_3__VecListOneD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneD, MCK_AlignedMemory64 }, },
  { 2621 /* vst1 */, ARM::VST1LNdAsm_8, Convert__VecListOneDByteIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneDByteIndexed, MCK_AlignedMemoryNone }, },
  { 2621 /* vst1 */, ARM::VST1d8T, Convert__AlignedMemory642_3__VecListThreeD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeD, MCK_AlignedMemory64 }, },
  { 2621 /* vst1 */, ARM::VST1q16wb_fixed, Convert__imm_95_0__AlignedMemory64or1282_3__VecListDPair1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2621 /* vst1 */, ARM::VST1q16wb_register, Convert__imm_95_0__AlignedMemory64or1282_3__Reg1_4__VecListDPair1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2621 /* vst1 */, ARM::VST1d16Qwb_fixed, Convert__imm_95_0__AlignedMemory64or128or2562_3__VecListFourD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2621 /* vst1 */, ARM::VST1d16Qwb_register, Convert__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__VecListFourD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2621 /* vst1 */, ARM::VST1d16wb_fixed, Convert__imm_95_0__AlignedMemory642_3__VecListOneD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2621 /* vst1 */, ARM::VST1d16wb_register, Convert__imm_95_0__AlignedMemory642_3__Reg1_4__VecListOneD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2621 /* vst1 */, ARM::VST1LNdWB_fixed_Asm_16, Convert__VecListOneDHWordIndexed2_2__AlignedMemory162_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneDHWordIndexed, MCK_AlignedMemory16, MCK__EXCLAIM_ }, },
  { 2621 /* vst1 */, ARM::VST1LNdWB_register_Asm_16, Convert__VecListOneDHWordIndexed2_2__AlignedMemory162_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneDHWordIndexed, MCK_AlignedMemory16, MCK_rGPR }, },
  { 2621 /* vst1 */, ARM::VST1d16Twb_fixed, Convert__imm_95_0__AlignedMemory642_3__VecListThreeD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2621 /* vst1 */, ARM::VST1d16Twb_register, Convert__imm_95_0__AlignedMemory642_3__Reg1_4__VecListThreeD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2621 /* vst1 */, ARM::VST1q32wb_fixed, Convert__imm_95_0__AlignedMemory64or1282_3__VecListDPair1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2621 /* vst1 */, ARM::VST1q32wb_register, Convert__imm_95_0__AlignedMemory64or1282_3__Reg1_4__VecListDPair1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2621 /* vst1 */, ARM::VST1d32Qwb_fixed, Convert__imm_95_0__AlignedMemory64or128or2562_3__VecListFourD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2621 /* vst1 */, ARM::VST1d32Qwb_register, Convert__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__VecListFourD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2621 /* vst1 */, ARM::VST1d32wb_fixed, Convert__imm_95_0__AlignedMemory642_3__VecListOneD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2621 /* vst1 */, ARM::VST1d32wb_register, Convert__imm_95_0__AlignedMemory642_3__Reg1_4__VecListOneD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2621 /* vst1 */, ARM::VST1LNdWB_fixed_Asm_32, Convert__VecListOneDWordIndexed2_2__AlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneDWordIndexed, MCK_AlignedMemory32, MCK__EXCLAIM_ }, },
  { 2621 /* vst1 */, ARM::VST1LNdWB_register_Asm_32, Convert__VecListOneDWordIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneDWordIndexed, MCK_AlignedMemory32, MCK_rGPR }, },
  { 2621 /* vst1 */, ARM::VST1d32Twb_fixed, Convert__imm_95_0__AlignedMemory642_3__VecListThreeD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2621 /* vst1 */, ARM::VST1d32Twb_register, Convert__imm_95_0__AlignedMemory642_3__Reg1_4__VecListThreeD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2621 /* vst1 */, ARM::VST1q64wb_fixed, Convert__imm_95_0__AlignedMemory64or1282_3__VecListDPair1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2621 /* vst1 */, ARM::VST1q64wb_register, Convert__imm_95_0__AlignedMemory64or1282_3__Reg1_4__VecListDPair1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2621 /* vst1 */, ARM::VST1d64Qwb_fixed, Convert__imm_95_0__AlignedMemory64or128or2562_3__VecListFourD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2621 /* vst1 */, ARM::VST1d64Qwb_register, Convert__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__VecListFourD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2621 /* vst1 */, ARM::VST1d64wb_fixed, Convert__imm_95_0__AlignedMemory642_3__VecListOneD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListOneD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2621 /* vst1 */, ARM::VST1d64wb_register, Convert__imm_95_0__AlignedMemory642_3__Reg1_4__VecListOneD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListOneD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2621 /* vst1 */, ARM::VST1d64Twb_fixed, Convert__imm_95_0__AlignedMemory642_3__VecListThreeD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListThreeD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2621 /* vst1 */, ARM::VST1d64Twb_register, Convert__imm_95_0__AlignedMemory642_3__Reg1_4__VecListThreeD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListThreeD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2621 /* vst1 */, ARM::VST1q8wb_fixed, Convert__imm_95_0__AlignedMemory64or1282_3__VecListDPair1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2621 /* vst1 */, ARM::VST1q8wb_register, Convert__imm_95_0__AlignedMemory64or1282_3__Reg1_4__VecListDPair1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2621 /* vst1 */, ARM::VST1d8Qwb_fixed, Convert__imm_95_0__AlignedMemory64or128or2562_3__VecListFourD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2621 /* vst1 */, ARM::VST1d8Qwb_register, Convert__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__VecListFourD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2621 /* vst1 */, ARM::VST1d8wb_fixed, Convert__imm_95_0__AlignedMemory642_3__VecListOneD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2621 /* vst1 */, ARM::VST1d8wb_register, Convert__imm_95_0__AlignedMemory642_3__Reg1_4__VecListOneD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2621 /* vst1 */, ARM::VST1LNdWB_fixed_Asm_8, Convert__VecListOneDByteIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneDByteIndexed, MCK_AlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2621 /* vst1 */, ARM::VST1LNdWB_register_Asm_8, Convert__VecListOneDByteIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneDByteIndexed, MCK_AlignedMemoryNone, MCK_rGPR }, },
  { 2621 /* vst1 */, ARM::VST1d8Twb_fixed, Convert__imm_95_0__AlignedMemory642_3__VecListThreeD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2621 /* vst1 */, ARM::VST1d8Twb_register, Convert__imm_95_0__AlignedMemory642_3__Reg1_4__VecListThreeD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2621 /* vst1 */, ARM::VST1LNd16, Convert__AlignedMemory2_8__Reg1_3__Imm1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK__91_, MCK_Imm, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2621 /* vst1 */, ARM::VST1LNd8, Convert__AlignedMemory2_8__Reg1_3__Imm1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK__91_, MCK_Imm, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2621 /* vst1 */, ARM::VST1LNd16_UPD, Convert__imm_95_0__AlignedMemory2_8__Imm1_9__Reg1_3__Imm1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK__91_, MCK_Imm, MCK__93_, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2621 /* vst1 */, ARM::VST1LNd32, Convert__Reg1_8__Imm1_9__Reg1_3__Imm1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK__91_, MCK_Imm, MCK__93_, MCK__125_, MCK_GPR, MCK_Imm }, },
  { 2621 /* vst1 */, ARM::VST1LNd8_UPD, Convert__imm_95_0__AlignedMemory2_8__Imm1_9__Reg1_3__Imm1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK__91_, MCK_Imm, MCK__93_, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2621 /* vst1 */, ARM::VST1LNd32_UPD, Convert__imm_95_0__Reg1_8__Imm1_9__Imm1_10__Reg1_3__Imm1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK__91_, MCK_Imm, MCK__93_, MCK__125_, MCK_GPR, MCK_Imm, MCK_Imm }, },
  { 2626 /* vst2 */, ARM::VST2d16, Convert__AlignedMemory64or1282_3__VecListDPair1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPair, MCK_AlignedMemory64or128 }, },
  { 2626 /* vst2 */, ARM::VST2b16, Convert__AlignedMemory64or1282_3__VecListDPairSpaced1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128 }, },
  { 2626 /* vst2 */, ARM::VST2q16, Convert__AlignedMemory64or128or2562_3__VecListFourD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2626 /* vst2 */, ARM::VST2LNdAsm_16, Convert__VecListTwoDHWordIndexed2_2__AlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListTwoDHWordIndexed, MCK_AlignedMemory32 }, },
  { 2626 /* vst2 */, ARM::VST2LNqAsm_16, Convert__VecListTwoQHWordIndexed2_2__AlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListTwoQHWordIndexed, MCK_AlignedMemory32 }, },
  { 2626 /* vst2 */, ARM::VST2d32, Convert__AlignedMemory64or1282_3__VecListDPair1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPair, MCK_AlignedMemory64or128 }, },
  { 2626 /* vst2 */, ARM::VST2b32, Convert__AlignedMemory64or1282_3__VecListDPairSpaced1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128 }, },
  { 2626 /* vst2 */, ARM::VST2q32, Convert__AlignedMemory64or128or2562_3__VecListFourD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2626 /* vst2 */, ARM::VST2LNdAsm_32, Convert__VecListTwoDWordIndexed2_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListTwoDWordIndexed, MCK_AlignedMemory64 }, },
  { 2626 /* vst2 */, ARM::VST2LNqAsm_32, Convert__VecListTwoQWordIndexed2_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListTwoQWordIndexed, MCK_AlignedMemory64 }, },
  { 2626 /* vst2 */, ARM::VST2d8, Convert__AlignedMemory64or1282_3__VecListDPair1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPair, MCK_AlignedMemory64or128 }, },
  { 2626 /* vst2 */, ARM::VST2b8, Convert__AlignedMemory64or1282_3__VecListDPairSpaced1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128 }, },
  { 2626 /* vst2 */, ARM::VST2q8, Convert__AlignedMemory64or128or2562_3__VecListFourD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2626 /* vst2 */, ARM::VST2LNdAsm_8, Convert__VecListTwoDByteIndexed2_2__AlignedMemory162_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListTwoDByteIndexed, MCK_AlignedMemory16 }, },
  { 2626 /* vst2 */, ARM::VST2d16wb_fixed, Convert__imm_95_0__AlignedMemory64or1282_3__VecListDPair1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2626 /* vst2 */, ARM::VST2d16wb_register, Convert__imm_95_0__AlignedMemory64or1282_3__Reg1_4__VecListDPair1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2626 /* vst2 */, ARM::VST2b16wb_fixed, Convert__imm_95_0__AlignedMemory64or1282_3__VecListDPairSpaced1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2626 /* vst2 */, ARM::VST2b16wb_register, Convert__imm_95_0__AlignedMemory64or1282_3__Reg1_4__VecListDPairSpaced1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2626 /* vst2 */, ARM::VST2q16wb_fixed, Convert__imm_95_0__AlignedMemory64or128or2562_3__VecListFourD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2626 /* vst2 */, ARM::VST2q16wb_register, Convert__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__VecListFourD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2626 /* vst2 */, ARM::VST2LNdWB_fixed_Asm_16, Convert__VecListTwoDHWordIndexed2_2__AlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListTwoDHWordIndexed, MCK_AlignedMemory32, MCK__EXCLAIM_ }, },
  { 2626 /* vst2 */, ARM::VST2LNdWB_register_Asm_16, Convert__VecListTwoDHWordIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListTwoDHWordIndexed, MCK_AlignedMemory32, MCK_rGPR }, },
  { 2626 /* vst2 */, ARM::VST2LNqWB_fixed_Asm_16, Convert__VecListTwoQHWordIndexed2_2__AlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListTwoQHWordIndexed, MCK_AlignedMemory32, MCK__EXCLAIM_ }, },
  { 2626 /* vst2 */, ARM::VST2LNqWB_register_Asm_16, Convert__VecListTwoQHWordIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListTwoQHWordIndexed, MCK_AlignedMemory32, MCK_rGPR }, },
  { 2626 /* vst2 */, ARM::VST2d32wb_fixed, Convert__imm_95_0__AlignedMemory64or1282_3__VecListDPair1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2626 /* vst2 */, ARM::VST2d32wb_register, Convert__imm_95_0__AlignedMemory64or1282_3__Reg1_4__VecListDPair1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2626 /* vst2 */, ARM::VST2b32wb_fixed, Convert__imm_95_0__AlignedMemory64or1282_3__VecListDPairSpaced1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2626 /* vst2 */, ARM::VST2b32wb_register, Convert__imm_95_0__AlignedMemory64or1282_3__Reg1_4__VecListDPairSpaced1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2626 /* vst2 */, ARM::VST2q32wb_fixed, Convert__imm_95_0__AlignedMemory64or128or2562_3__VecListFourD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2626 /* vst2 */, ARM::VST2q32wb_register, Convert__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__VecListFourD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2626 /* vst2 */, ARM::VST2LNdWB_fixed_Asm_32, Convert__VecListTwoDWordIndexed2_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListTwoDWordIndexed, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2626 /* vst2 */, ARM::VST2LNdWB_register_Asm_32, Convert__VecListTwoDWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListTwoDWordIndexed, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2626 /* vst2 */, ARM::VST2LNqWB_fixed_Asm_32, Convert__VecListTwoQWordIndexed2_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListTwoQWordIndexed, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2626 /* vst2 */, ARM::VST2LNqWB_register_Asm_32, Convert__VecListTwoQWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListTwoQWordIndexed, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2626 /* vst2 */, ARM::VST2d8wb_fixed, Convert__imm_95_0__AlignedMemory64or1282_3__VecListDPair1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2626 /* vst2 */, ARM::VST2d8wb_register, Convert__imm_95_0__AlignedMemory64or1282_3__Reg1_4__VecListDPair1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2626 /* vst2 */, ARM::VST2b8wb_fixed, Convert__imm_95_0__AlignedMemory64or1282_3__VecListDPairSpaced1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2626 /* vst2 */, ARM::VST2b8wb_register, Convert__imm_95_0__AlignedMemory64or1282_3__Reg1_4__VecListDPairSpaced1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2626 /* vst2 */, ARM::VST2q8wb_fixed, Convert__imm_95_0__AlignedMemory64or128or2562_3__VecListFourD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2626 /* vst2 */, ARM::VST2q8wb_register, Convert__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__VecListFourD1_2__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2626 /* vst2 */, ARM::VST2LNdWB_fixed_Asm_8, Convert__VecListTwoDByteIndexed2_2__AlignedMemory162_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListTwoDByteIndexed, MCK_AlignedMemory16, MCK__EXCLAIM_ }, },
  { 2626 /* vst2 */, ARM::VST2LNdWB_register_Asm_8, Convert__VecListTwoDByteIndexed2_2__AlignedMemory162_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListTwoDByteIndexed, MCK_AlignedMemory16, MCK_rGPR }, },
  { 2631 /* vst3 */, ARM::VST3dAsm_16, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeD, MCK_AlignedMemory64 }, },
  { 2631 /* vst3 */, ARM::VST3LNdAsm_16, Convert__VecListThreeDHWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeDHWordIndexed, MCK_AlignedMemoryNone }, },
  { 2631 /* vst3 */, ARM::VST3qAsm_16, Convert__VecListThreeQ1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQ, MCK_AlignedMemory64 }, },
  { 2631 /* vst3 */, ARM::VST3LNqAsm_16, Convert__VecListThreeQHWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQHWordIndexed, MCK_AlignedMemoryNone }, },
  { 2631 /* vst3 */, ARM::VST3dAsm_32, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeD, MCK_AlignedMemory64 }, },
  { 2631 /* vst3 */, ARM::VST3LNdAsm_32, Convert__VecListThreeDWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeDWordIndexed, MCK_AlignedMemoryNone }, },
  { 2631 /* vst3 */, ARM::VST3qAsm_32, Convert__VecListThreeQ1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQ, MCK_AlignedMemory64 }, },
  { 2631 /* vst3 */, ARM::VST3LNqAsm_32, Convert__VecListThreeQWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQWordIndexed, MCK_AlignedMemoryNone }, },
  { 2631 /* vst3 */, ARM::VST3dAsm_8, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeD, MCK_AlignedMemory64 }, },
  { 2631 /* vst3 */, ARM::VST3LNdAsm_8, Convert__VecListThreeDByteIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeDByteIndexed, MCK_AlignedMemoryNone }, },
  { 2631 /* vst3 */, ARM::VST3qAsm_8, Convert__VecListThreeQ1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeQ, MCK_AlignedMemory64 }, },
  { 2631 /* vst3 */, ARM::VST3dWB_fixed_Asm_16, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2631 /* vst3 */, ARM::VST3dWB_register_Asm_16, Convert__VecListThreeD1_2__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2631 /* vst3 */, ARM::VST3LNdWB_fixed_Asm_16, Convert__VecListThreeDHWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeDHWordIndexed, MCK_AlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2631 /* vst3 */, ARM::VST3LNdWB_register_Asm_16, Convert__VecListThreeDHWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeDHWordIndexed, MCK_AlignedMemoryNone, MCK_rGPR }, },
  { 2631 /* vst3 */, ARM::VST3qWB_fixed_Asm_16, Convert__VecListThreeQ1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQ, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2631 /* vst3 */, ARM::VST3qWB_register_Asm_16, Convert__VecListThreeQ1_2__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQ, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2631 /* vst3 */, ARM::VST3LNqWB_fixed_Asm_16, Convert__VecListThreeQHWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQHWordIndexed, MCK_AlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2631 /* vst3 */, ARM::VST3LNqWB_register_Asm_16, Convert__VecListThreeQHWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQHWordIndexed, MCK_AlignedMemoryNone, MCK_rGPR }, },
  { 2631 /* vst3 */, ARM::VST3dWB_fixed_Asm_32, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2631 /* vst3 */, ARM::VST3dWB_register_Asm_32, Convert__VecListThreeD1_2__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2631 /* vst3 */, ARM::VST3LNdWB_fixed_Asm_32, Convert__VecListThreeDWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeDWordIndexed, MCK_AlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2631 /* vst3 */, ARM::VST3LNdWB_register_Asm_32, Convert__VecListThreeDWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeDWordIndexed, MCK_AlignedMemoryNone, MCK_rGPR }, },
  { 2631 /* vst3 */, ARM::VST3qWB_fixed_Asm_32, Convert__VecListThreeQ1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQ, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2631 /* vst3 */, ARM::VST3qWB_register_Asm_32, Convert__VecListThreeQ1_2__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQ, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2631 /* vst3 */, ARM::VST3LNqWB_fixed_Asm_32, Convert__VecListThreeQWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQWordIndexed, MCK_AlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2631 /* vst3 */, ARM::VST3LNqWB_register_Asm_32, Convert__VecListThreeQWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQWordIndexed, MCK_AlignedMemoryNone, MCK_rGPR }, },
  { 2631 /* vst3 */, ARM::VST3dWB_fixed_Asm_8, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2631 /* vst3 */, ARM::VST3dWB_register_Asm_8, Convert__VecListThreeD1_2__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2631 /* vst3 */, ARM::VST3LNdWB_fixed_Asm_8, Convert__VecListThreeDByteIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeDByteIndexed, MCK_AlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2631 /* vst3 */, ARM::VST3LNdWB_register_Asm_8, Convert__VecListThreeDByteIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeDByteIndexed, MCK_AlignedMemoryNone, MCK_rGPR }, },
  { 2631 /* vst3 */, ARM::VST3qWB_fixed_Asm_8, Convert__VecListThreeQ1_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeQ, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2631 /* vst3 */, ARM::VST3qWB_register_Asm_8, Convert__VecListThreeQ1_2__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeQ, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2631 /* vst3 */, ARM::VST3d16, Convert__AlignedMemory2_7__Reg1_3__Reg1_4__Reg1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2631 /* vst3 */, ARM::VST3q16, Convert__AlignedMemory2_7__Reg1_3__Reg1_4__Reg1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2631 /* vst3 */, ARM::VST3d32, Convert__AlignedMemory2_7__Reg1_3__Reg1_4__Reg1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2631 /* vst3 */, ARM::VST3q32, Convert__AlignedMemory2_7__Reg1_3__Reg1_4__Reg1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2631 /* vst3 */, ARM::VST3d8, Convert__AlignedMemory2_7__Reg1_3__Reg1_4__Reg1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2631 /* vst3 */, ARM::VST3q8, Convert__AlignedMemory2_7__Reg1_3__Reg1_4__Reg1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2631 /* vst3 */, ARM::VST3d16_UPD, Convert__imm_95_0__AlignedMemory2_7__Imm1_8__Reg1_3__Reg1_4__Reg1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2631 /* vst3 */, ARM::VST3q16_UPD, Convert__imm_95_0__AlignedMemory2_7__Imm1_8__Reg1_3__Reg1_4__Reg1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2631 /* vst3 */, ARM::VST3d32_UPD, Convert__imm_95_0__AlignedMemory2_7__Imm1_8__Reg1_3__Reg1_4__Reg1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2631 /* vst3 */, ARM::VST3q32_UPD, Convert__imm_95_0__AlignedMemory2_7__Imm1_8__Reg1_3__Reg1_4__Reg1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2631 /* vst3 */, ARM::VST3d8_UPD, Convert__imm_95_0__AlignedMemory2_7__Imm1_8__Reg1_3__Reg1_4__Reg1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2631 /* vst3 */, ARM::VST3q8_UPD, Convert__imm_95_0__AlignedMemory2_7__Imm1_8__Reg1_3__Reg1_4__Reg1_5__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2636 /* vst4 */, ARM::VST4dAsm_16, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2636 /* vst4 */, ARM::VST4LNdAsm_16, Convert__VecListFourDHWordIndexed2_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourDHWordIndexed, MCK_AlignedMemory64 }, },
  { 2636 /* vst4 */, ARM::VST4qAsm_16, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQ, MCK_AlignedMemory64or128or256 }, },
  { 2636 /* vst4 */, ARM::VST4LNqAsm_16, Convert__VecListFourQHWordIndexed2_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQHWordIndexed, MCK_AlignedMemory64 }, },
  { 2636 /* vst4 */, ARM::VST4dAsm_32, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2636 /* vst4 */, ARM::VST4LNdAsm_32, Convert__VecListFourDWordIndexed2_2__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourDWordIndexed, MCK_AlignedMemory64or128 }, },
  { 2636 /* vst4 */, ARM::VST4qAsm_32, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQ, MCK_AlignedMemory64or128or256 }, },
  { 2636 /* vst4 */, ARM::VST4LNqAsm_32, Convert__VecListFourQWordIndexed2_2__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQWordIndexed, MCK_AlignedMemory64or128 }, },
  { 2636 /* vst4 */, ARM::VST4dAsm_8, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2636 /* vst4 */, ARM::VST4LNdAsm_8, Convert__VecListFourDByteIndexed2_2__AlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourDByteIndexed, MCK_AlignedMemory32 }, },
  { 2636 /* vst4 */, ARM::VST4qAsm_8, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourQ, MCK_AlignedMemory64or128or256 }, },
  { 2636 /* vst4 */, ARM::VST4dWB_fixed_Asm_16, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2636 /* vst4 */, ARM::VST4dWB_register_Asm_16, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2636 /* vst4 */, ARM::VST4LNdWB_fixed_Asm_16, Convert__VecListFourDHWordIndexed2_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourDHWordIndexed, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2636 /* vst4 */, ARM::VST4LNdWB_register_Asm_16, Convert__VecListFourDHWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourDHWordIndexed, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2636 /* vst4 */, ARM::VST4qWB_fixed_Asm_16, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQ, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2636 /* vst4 */, ARM::VST4qWB_register_Asm_16, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQ, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2636 /* vst4 */, ARM::VST4LNqWB_fixed_Asm_16, Convert__VecListFourQHWordIndexed2_2__AlignedMemory642_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQHWordIndexed, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2636 /* vst4 */, ARM::VST4LNqWB_register_Asm_16, Convert__VecListFourQHWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQHWordIndexed, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2636 /* vst4 */, ARM::VST4dWB_fixed_Asm_32, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2636 /* vst4 */, ARM::VST4dWB_register_Asm_32, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2636 /* vst4 */, ARM::VST4LNdWB_fixed_Asm_32, Convert__VecListFourDWordIndexed2_2__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourDWordIndexed, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2636 /* vst4 */, ARM::VST4LNdWB_register_Asm_32, Convert__VecListFourDWordIndexed2_2__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourDWordIndexed, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2636 /* vst4 */, ARM::VST4qWB_fixed_Asm_32, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQ, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2636 /* vst4 */, ARM::VST4qWB_register_Asm_32, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQ, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2636 /* vst4 */, ARM::VST4LNqWB_fixed_Asm_32, Convert__VecListFourQWordIndexed2_2__AlignedMemory64or1282_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQWordIndexed, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2636 /* vst4 */, ARM::VST4LNqWB_register_Asm_32, Convert__VecListFourQWordIndexed2_2__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQWordIndexed, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2636 /* vst4 */, ARM::VST4dWB_fixed_Asm_8, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2636 /* vst4 */, ARM::VST4dWB_register_Asm_8, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2636 /* vst4 */, ARM::VST4LNdWB_fixed_Asm_8, Convert__VecListFourDByteIndexed2_2__AlignedMemory322_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourDByteIndexed, MCK_AlignedMemory32, MCK__EXCLAIM_ }, },
  { 2636 /* vst4 */, ARM::VST4LNdWB_register_Asm_8, Convert__VecListFourDByteIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourDByteIndexed, MCK_AlignedMemory32, MCK_rGPR }, },
  { 2636 /* vst4 */, ARM::VST4qWB_fixed_Asm_8, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourQ, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2636 /* vst4 */, ARM::VST4qWB_register_Asm_8, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourQ, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2636 /* vst4 */, ARM::VST4d16, Convert__AlignedMemory2_8__Reg1_3__Reg1_4__Reg1_5__Reg1_6__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2636 /* vst4 */, ARM::VST4q16, Convert__AlignedMemory2_8__Reg1_3__Reg1_4__Reg1_5__Reg1_6__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2636 /* vst4 */, ARM::VST4d32, Convert__AlignedMemory2_8__Reg1_3__Reg1_4__Reg1_5__Reg1_6__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2636 /* vst4 */, ARM::VST4q32, Convert__AlignedMemory2_8__Reg1_3__Reg1_4__Reg1_5__Reg1_6__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2636 /* vst4 */, ARM::VST4d8, Convert__AlignedMemory2_8__Reg1_3__Reg1_4__Reg1_5__Reg1_6__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2636 /* vst4 */, ARM::VST4q8, Convert__AlignedMemory2_8__Reg1_3__Reg1_4__Reg1_5__Reg1_6__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2636 /* vst4 */, ARM::VST4d16_UPD, Convert__imm_95_0__AlignedMemory2_8__Imm1_9__Reg1_3__Reg1_4__Reg1_5__Reg1_6__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2636 /* vst4 */, ARM::VST4q16_UPD, Convert__imm_95_0__AlignedMemory2_8__Imm1_9__Reg1_3__Reg1_4__Reg1_5__Reg1_6__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2636 /* vst4 */, ARM::VST4d32_UPD, Convert__imm_95_0__AlignedMemory2_8__Imm1_9__Reg1_3__Reg1_4__Reg1_5__Reg1_6__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2636 /* vst4 */, ARM::VST4q32_UPD, Convert__imm_95_0__AlignedMemory2_8__Imm1_9__Reg1_3__Reg1_4__Reg1_5__Reg1_6__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2636 /* vst4 */, ARM::VST4d8_UPD, Convert__imm_95_0__AlignedMemory2_8__Imm1_9__Reg1_3__Reg1_4__Reg1_5__Reg1_6__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2636 /* vst4 */, ARM::VST4q8_UPD, Convert__imm_95_0__AlignedMemory2_8__Imm1_9__Reg1_3__Reg1_4__Reg1_5__Reg1_6__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2641 /* vstmdb */, ARM::VSTMDDB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__DPRRegList1_3, Feature_HasVFP2, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_DPRRegList }, },
  { 2641 /* vstmdb */, ARM::VSTMSDB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__SPRRegList1_3, Feature_HasVFP2, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_SPRRegList }, },
  { 2648 /* vstmia */, ARM::VSTMDIA, Convert__Reg1_1__CondCode2_0__DPRRegList1_2, Feature_HasVFP2, { MCK_CondCode, MCK_GPR, MCK_DPRRegList }, },
  { 2648 /* vstmia */, ARM::VSTMSIA, Convert__Reg1_1__CondCode2_0__SPRRegList1_2, Feature_HasVFP2, { MCK_CondCode, MCK_GPR, MCK_SPRRegList }, },
  { 2648 /* vstmia */, ARM::VSTMDIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__DPRRegList1_3, Feature_HasVFP2, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_DPRRegList }, },
  { 2648 /* vstmia */, ARM::VSTMSIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__SPRRegList1_3, Feature_HasVFP2, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_SPRRegList }, },
  { 2655 /* vstr */, ARM::VSTRD, Convert__Reg1_1__AddrMode52_2__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_DPR, MCK_AddrMode5 }, },
  { 2655 /* vstr */, ARM::VSTRS, Convert__Reg1_1__AddrMode52_2__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK_HPR, MCK_AddrMode5 }, },
  { 2655 /* vstr */, ARM::VSTRH, Convert__Reg1_2__AddrMode5FP162_3__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_16, MCK_HPR, MCK_AddrMode5FP16 }, },
  { 2655 /* vstr */, ARM::VSTRS, Convert__Reg1_2__AddrMode52_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_32, MCK_HPR, MCK_AddrMode5 }, },
  { 2655 /* vstr */, ARM::VSTRD, Convert__Reg1_2__AddrMode52_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_AddrMode5 }, },
  { 2660 /* vsub */, ARM::VSUBfq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2660 /* vsub */, ARM::VSUBfd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2660 /* vsub */, ARM::VSUBS, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2660 /* vsub */, ARM::VSUBD, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2660 /* vsub */, ARM::VSUBv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR }, },
  { 2660 /* vsub */, ARM::VSUBv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR }, },
  { 2660 /* vsub */, ARM::VSUBv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR }, },
  { 2660 /* vsub */, ARM::VSUBv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR }, },
  { 2660 /* vsub */, ARM::VSUBv2i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_QPR, MCK_QPR }, },
  { 2660 /* vsub */, ARM::VSUBv1i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_DPR, MCK_DPR }, },
  { 2660 /* vsub */, ARM::VSUBv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK_QPR }, },
  { 2660 /* vsub */, ARM::VSUBv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_DPR }, },
  { 2660 /* vsub */, ARM::VSUBhq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2660 /* vsub */, ARM::VSUBhd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2660 /* vsub */, ARM::VSUBH, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2660 /* vsub */, ARM::VSUBfq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2660 /* vsub */, ARM::VSUBfd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2660 /* vsub */, ARM::VSUBS, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2660 /* vsub */, ARM::VSUBD, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasVFP2|Feature_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2660 /* vsub */, ARM::VSUBv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2660 /* vsub */, ARM::VSUBv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2660 /* vsub */, ARM::VSUBv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2660 /* vsub */, ARM::VSUBv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2660 /* vsub */, ARM::VSUBv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2660 /* vsub */, ARM::VSUBv1i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2660 /* vsub */, ARM::VSUBv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2660 /* vsub */, ARM::VSUBv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2660 /* vsub */, ARM::VSUBhq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2660 /* vsub */, ARM::VSUBhd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON|Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2660 /* vsub */, ARM::VSUBH, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2665 /* vsubhn */, ARM::VSUBHNv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_QPR, MCK_QPR }, },
  { 2665 /* vsubhn */, ARM::VSUBHNv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_QPR, MCK_QPR }, },
  { 2665 /* vsubhn */, ARM::VSUBHNv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_DPR, MCK_QPR, MCK_QPR }, },
  { 2672 /* vsubl */, ARM::VSUBLsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2672 /* vsubl */, ARM::VSUBLsv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2672 /* vsubl */, ARM::VSUBLsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2672 /* vsubl */, ARM::VSUBLuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2672 /* vsubl */, ARM::VSUBLuv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2672 /* vsubl */, ARM::VSUBLuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2678 /* vsubw */, ARM::VSUBWsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR }, },
  { 2678 /* vsubw */, ARM::VSUBWsv2i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR }, },
  { 2678 /* vsubw */, ARM::VSUBWsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_DPR }, },
  { 2678 /* vsubw */, ARM::VSUBWuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_DPR }, },
  { 2678 /* vsubw */, ARM::VSUBWuv2i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_DPR }, },
  { 2678 /* vsubw */, ARM::VSUBWuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_DPR }, },
  { 2678 /* vsubw */, ARM::VSUBWsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_DPR }, },
  { 2678 /* vsubw */, ARM::VSUBWsv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_DPR }, },
  { 2678 /* vsubw */, ARM::VSUBWsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_DPR }, },
  { 2678 /* vsubw */, ARM::VSUBWuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_DPR }, },
  { 2678 /* vsubw */, ARM::VSUBWuv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_DPR }, },
  { 2678 /* vsubw */, ARM::VSUBWuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_DPR }, },
  { 2684 /* vswp */, ARM::VSWPq, Convert__Reg1_1__Reg1_2__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR }, },
  { 2684 /* vswp */, ARM::VSWPd, Convert__Reg1_1__Reg1_2__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR }, },
  { 2684 /* vswp */, ARM::VSWPq, Convert__Reg1_2__Reg1_3__Tie0_3_3__Tie1_4_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR }, },
  { 2684 /* vswp */, ARM::VSWPd, Convert__Reg1_2__Reg1_3__Tie0_3_3__Tie1_4_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR }, },
  { 2684 /* vswp */, ARM::VSWPq, Convert__Reg1_2__Reg1_3__Tie0_3_3__Tie1_4_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR }, },
  { 2684 /* vswp */, ARM::VSWPd, Convert__Reg1_2__Reg1_3__Tie0_3_3__Tie1_4_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR }, },
  { 2684 /* vswp */, ARM::VSWPq, Convert__Reg1_2__Reg1_3__Tie0_3_3__Tie1_4_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR }, },
  { 2684 /* vswp */, ARM::VSWPd, Convert__Reg1_2__Reg1_3__Tie0_3_3__Tie1_4_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_DPR }, },
  { 2684 /* vswp */, ARM::VSWPq, Convert__Reg1_2__Reg1_3__Tie0_3_3__Tie1_4_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 2684 /* vswp */, ARM::VSWPd, Convert__Reg1_2__Reg1_3__Tie0_3_3__Tie1_4_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR }, },
  { 2689 /* vtbl */, ARM::VTBL2, Convert__Reg1_2__VecListDPair1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_VecListDPair, MCK_DPR }, },
  { 2689 /* vtbl */, ARM::VTBL4, Convert__Reg1_2__VecListFourD1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_VecListFourD, MCK_DPR }, },
  { 2689 /* vtbl */, ARM::VTBL1, Convert__Reg1_2__VecListOneD1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_VecListOneD, MCK_DPR }, },
  { 2689 /* vtbl */, ARM::VTBL3, Convert__Reg1_2__VecListThreeD1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_VecListThreeD, MCK_DPR }, },
  { 2694 /* vtbx */, ARM::VTBX2, Convert__Reg1_2__Tie0_1_1__VecListDPair1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_VecListDPair, MCK_DPR }, },
  { 2694 /* vtbx */, ARM::VTBX4, Convert__Reg1_2__Tie0_1_1__VecListFourD1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_VecListFourD, MCK_DPR }, },
  { 2694 /* vtbx */, ARM::VTBX1, Convert__Reg1_2__Tie0_1_1__VecListOneD1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_VecListOneD, MCK_DPR }, },
  { 2694 /* vtbx */, ARM::VTBX3, Convert__Reg1_2__Tie0_1_1__VecListThreeD1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_VecListThreeD, MCK_DPR }, },
  { 2699 /* vtrn */, ARM::VTRNq16, Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR }, },
  { 2699 /* vtrn */, ARM::VTRNd16, Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR }, },
  { 2699 /* vtrn */, ARM::VTRNq32, Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR }, },
  { 2699 /* vtrn */, ARM::VTRNd32, Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR }, },
  { 2699 /* vtrn */, ARM::VTRNq8, Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 2699 /* vtrn */, ARM::VTRNd8, Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR }, },
  { 2704 /* vtst */, ARM::VTSTv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR }, },
  { 2704 /* vtst */, ARM::VTSTv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR }, },
  { 2704 /* vtst */, ARM::VTSTv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR }, },
  { 2704 /* vtst */, ARM::VTSTv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR }, },
  { 2704 /* vtst */, ARM::VTSTv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 2704 /* vtst */, ARM::VTSTv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR }, },
  { 2704 /* vtst */, ARM::VTSTv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2704 /* vtst */, ARM::VTSTv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2704 /* vtst */, ARM::VTSTv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2704 /* vtst */, ARM::VTSTv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2704 /* vtst */, ARM::VTSTv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2704 /* vtst */, ARM::VTSTv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2709 /* vudot */, ARM::VUDOTQ, Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3, Feature_HasDotProd, { MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2709 /* vudot */, ARM::VUDOTD, Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3, Feature_HasDotProd, { MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2709 /* vudot */, ARM::VUDOTQI, Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3__VectorIndex321_4, Feature_HasDotProd, { MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2709 /* vudot */, ARM::VUDOTDI, Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3__VectorIndex321_4, Feature_HasDotProd, { MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2715 /* vuzp */, ARM::VUZPq16, Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR }, },
  { 2715 /* vuzp */, ARM::VUZPd16, Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR }, },
  { 2715 /* vuzp */, ARM::VUZPq32, Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR }, },
  { 2715 /* vuzp */, ARM::VTRNd32, Convert__Reg1_2__Reg1_3__Tie0_3_3__Tie1_4_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR }, },
  { 2715 /* vuzp */, ARM::VUZPq8, Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 2715 /* vuzp */, ARM::VUZPd8, Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR }, },
  { 2720 /* vzip */, ARM::VZIPq16, Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR }, },
  { 2720 /* vzip */, ARM::VZIPd16, Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR }, },
  { 2720 /* vzip */, ARM::VZIPq32, Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR }, },
  { 2720 /* vzip */, ARM::VTRNd32, Convert__Reg1_2__Reg1_3__Tie0_3_3__Tie1_4_4__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR }, },
  { 2720 /* vzip */, ARM::VZIPq8, Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 2720 /* vzip */, ARM::VZIPd8, Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__CondCode2_0, Feature_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR }, },
  { 2725 /* wfe */, ARM::HINT, Convert__imm_95_2__CondCode2_0, Feature_IsARM|Feature_HasV6K, { MCK_CondCode }, },
  { 2725 /* wfe */, ARM::tHINT, Convert__imm_95_2__CondCode2_0, Feature_IsThumb|Feature_HasV6M, { MCK_CondCode }, },
  { 2725 /* wfe */, ARM::t2HINT, Convert__imm_95_2__CondCode2_0, Feature_IsThumb2, { MCK_CondCode, MCK__DOT_w }, },
  { 2729 /* wfi */, ARM::HINT, Convert__imm_95_3__CondCode2_0, Feature_IsARM|Feature_HasV6K, { MCK_CondCode }, },
  { 272