/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Subtarget Enumeration Source Fragment                                      *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_SUBTARGETINFO_ENUM
#undef GET_SUBTARGETINFO_ENUM

namespace llvm {
namespace X86 {
enum {
  Feature3DNow = 0,
  Feature3DNowA = 1,
  Feature64Bit = 2,
  FeatureADX = 3,
  FeatureAES = 4,
  FeatureAVX = 5,
  FeatureAVX2 = 6,
  FeatureAVX512 = 7,
  FeatureBF16 = 8,
  FeatureBITALG = 9,
  FeatureBMI = 10,
  FeatureBMI2 = 11,
  FeatureBWI = 12,
  FeatureBranchFusion = 13,
  FeatureCDI = 14,
  FeatureCLDEMOTE = 15,
  FeatureCLFLUSHOPT = 16,
  FeatureCLWB = 17,
  FeatureCLZERO = 18,
  FeatureCMOV = 19,
  FeatureCMPXCHG8B = 20,
  FeatureCMPXCHG16B = 21,
  FeatureDQI = 22,
  FeatureDeprecatedMPX = 23,
  FeatureENQCMD = 24,
  FeatureERI = 25,
  FeatureERMSB = 26,
  FeatureF16C = 27,
  FeatureFMA = 28,
  FeatureFMA4 = 29,
  FeatureFSGSBase = 30,
  FeatureFXSR = 31,
  FeatureFast11ByteNOP = 32,
  FeatureFast15ByteNOP = 33,
  FeatureFastBEXTR = 34,
  FeatureFastHorizontalOps = 35,
  FeatureFastLZCNT = 36,
  FeatureFastSHLDRotate = 37,
  FeatureFastScalarFSQRT = 38,
  FeatureFastScalarShiftMasks = 39,
  FeatureFastVariableShuffle = 40,
  FeatureFastVectorFSQRT = 41,
  FeatureFastVectorShiftMasks = 42,
  FeatureGFNI = 43,
  FeatureHasFastGather = 44,
  FeatureIFMA = 45,
  FeatureINVPCID = 46,
  FeatureInsertVZEROUPPER = 47,
  FeatureLAHFSAHF = 48,
  FeatureLEAForSP = 49,
  FeatureLEAUsesAG = 50,
  FeatureLWP = 51,
  FeatureLZCNT = 52,
  FeatureLZCNTFalseDeps = 53,
  FeatureMMX = 54,
  FeatureMOVBE = 55,
  FeatureMOVDIR64B = 56,
  FeatureMOVDIRI = 57,
  FeatureMWAITX = 58,
  FeatureMacroFusion = 59,
  FeatureMergeToThreeWayBranch = 60,
  FeatureNOPL = 61,
  FeaturePCLMUL = 62,
  FeaturePCONFIG = 63,
  FeaturePFI = 64,
  FeaturePKU = 65,
  FeaturePOPCNT = 66,
  FeaturePOPCNTFalseDeps = 67,
  FeaturePREFETCHWT1 = 68,
  FeaturePRFCHW = 69,
  FeaturePTWRITE = 70,
  FeaturePadShortFunctions = 71,
  FeaturePrefer128Bit = 72,
  FeaturePrefer256Bit = 73,
  FeaturePreferMaskRegisters = 74,
  FeatureRDPID = 75,
  FeatureRDRAND = 76,
  FeatureRDSEED = 77,
  FeatureRTM = 78,
  FeatureRetpoline = 79,
  FeatureRetpolineExternalThunk = 80,
  FeatureRetpolineIndirectBranches = 81,
  FeatureRetpolineIndirectCalls = 82,
  FeatureSGX = 83,
  FeatureSHA = 84,
  FeatureSHSTK = 85,
  FeatureSSE1 = 86,
  FeatureSSE2 = 87,
  FeatureSSE3 = 88,
  FeatureSSE4A = 89,
  FeatureSSE41 = 90,
  FeatureSSE42 = 91,
  FeatureSSEUnalignedMem = 92,
  FeatureSSSE3 = 93,
  FeatureSlow3OpsLEA = 94,
  FeatureSlowDivide32 = 95,
  FeatureSlowDivide64 = 96,
  FeatureSlowIncDec = 97,
  FeatureSlowLEA = 98,
  FeatureSlowPMADDWD = 99,
  FeatureSlowPMULLD = 100,
  FeatureSlowSHLD = 101,
  FeatureSlowTwoMemOps = 102,
  FeatureSlowUAMem16 = 103,
  FeatureSlowUAMem32 = 104,
  FeatureSoftFloat = 105,
  FeatureTBM = 106,
  FeatureUseAA = 107,
  FeatureUseGLMDivSqrtCosts = 108,
  FeatureVAES = 109,
  FeatureVBMI = 110,
  FeatureVBMI2 = 111,
  FeatureVLX = 112,
  FeatureVNNI = 113,
  FeatureVP2INTERSECT = 114,
  FeatureVPCLMULQDQ = 115,
  FeatureVPOPCNTDQ = 116,
  FeatureWAITPKG = 117,
  FeatureWBNOINVD = 118,
  FeatureX87 = 119,
  FeatureXOP = 120,
  FeatureXSAVE = 121,
  FeatureXSAVEC = 122,
  FeatureXSAVEOPT = 123,
  FeatureXSAVES = 124,
  Mode16Bit = 125,
  Mode32Bit = 126,
  Mode64Bit = 127,
  ProcIntelAtom = 128,
  ProcIntelSLM = 129,
  NumSubtargetFeatures = 130
};
} // end namespace X86
} // end namespace llvm

#endif // GET_SUBTARGETINFO_ENUM


#ifdef GET_SUBTARGETINFO_MC_DESC
#undef GET_SUBTARGETINFO_MC_DESC

namespace llvm {
// Sorted (by key) array of values for CPU features.
extern const llvm::SubtargetFeatureKV X86FeatureKV[] = {
  { "16bit-mode", "16-bit mode (i8086)", X86::Mode16Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "32bit-mode", "32-bit mode (80386)", X86::Mode32Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "3dnow", "Enable 3DNow! instructions", X86::Feature3DNow, { { { 0x40000000000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "3dnowa", "Enable 3DNow! Athlon instructions", X86::Feature3DNowA, { { { 0x1ULL, 0x0ULL, 0x0ULL, } } } },
  { "64bit", "Support 64-bit instructions", X86::Feature64Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "64bit-mode", "64-bit mode (x86_64)", X86::Mode64Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "adx", "Support ADX instructions", X86::FeatureADX, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "aes", "Enable AES instructions", X86::FeatureAES, { { { 0x0ULL, 0x800000ULL, 0x0ULL, } } } },
  { "avx", "Enable AVX instructions", X86::FeatureAVX, { { { 0x0ULL, 0x8000000ULL, 0x0ULL, } } } },
  { "avx2", "Enable AVX2 instructions", X86::FeatureAVX2, { { { 0x20ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bf16", "Support bfloat16 floating point", X86::FeatureBF16, { { { 0x1000ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bitalg", "Enable AVX-512 Bit Algorithms", X86::FeatureBITALG, { { { 0x1000ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bw", "Enable AVX-512 Byte and Word Instructions", X86::FeatureBWI, { { { 0x80ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512cd", "Enable AVX-512 Conflict Detection Instructions", X86::FeatureCDI, { { { 0x80ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512dq", "Enable AVX-512 Doubleword and Quadword Instructions", X86::FeatureDQI, { { { 0x80ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512er", "Enable AVX-512 Exponential and Reciprocal Instructions", X86::FeatureERI, { { { 0x80ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512f", "Enable AVX-512 instructions", X86::FeatureAVX512, { { { 0x18000040ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512ifma", "Enable AVX-512 Integer Fused Multiple-Add", X86::FeatureIFMA, { { { 0x80ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512pf", "Enable AVX-512 PreFetch Instructions", X86::FeaturePFI, { { { 0x80ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vbmi", "Enable AVX-512 Vector Byte Manipulation Instructions", X86::FeatureVBMI, { { { 0x1000ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vbmi2", "Enable AVX-512 further Vector Byte Manipulation Instructions", X86::FeatureVBMI2, { { { 0x1000ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vl", "Enable AVX-512 Vector Length eXtensions", X86::FeatureVLX, { { { 0x80ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vnni", "Enable AVX-512 Vector Neural Network Instructions", X86::FeatureVNNI, { { { 0x80ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vp2intersect", "Enable AVX-512 vp2intersect", X86::FeatureVP2INTERSECT, { { { 0x80ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vpopcntdq", "Enable AVX-512 Population Count Instructions", X86::FeatureVPOPCNTDQ, { { { 0x80ULL, 0x0ULL, 0x0ULL, } } } },
  { "bmi", "Support BMI instructions", X86::FeatureBMI, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "bmi2", "Support BMI2 instructions", X86::FeatureBMI2, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "branchfusion", "CMP/TEST can be fused with conditional branches", X86::FeatureBranchFusion, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cldemote", "Enable Cache Demote", X86::FeatureCLDEMOTE, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clflushopt", "Flush A Cache Line Optimized", X86::FeatureCLFLUSHOPT, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clwb", "Cache Line Write Back", X86::FeatureCLWB, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clzero", "Enable Cache Line Zero", X86::FeatureCLZERO, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cmov", "Enable conditional move instructions", X86::FeatureCMOV, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cx16", "64-bit with cmpxchg16b", X86::FeatureCMPXCHG16B, { { { 0x100000ULL, 0x0ULL, 0x0ULL, } } } },
  { "cx8", "Support CMPXCHG8B instructions", X86::FeatureCMPXCHG8B, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "enqcmd", "Has ENQCMD instructions", X86::FeatureENQCMD, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ermsb", "REP MOVS/STOS are fast", X86::FeatureERMSB, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "f16c", "Support 16-bit floating point conversion instructions", X86::FeatureF16C, { { { 0x20ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-lzcnt-tzcnt", "LZCNT/TZCNT have a false dependency on dest register", X86::FeatureLZCNTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-popcnt", "POPCNT has a false dependency on dest register", X86::FeaturePOPCNTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-11bytenop", "Target can quickly decode up to 11 byte NOPs", X86::FeatureFast11ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-15bytenop", "Target can quickly decode up to 15 byte NOPs", X86::FeatureFast15ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-bextr", "Indicates that the BEXTR instruction is implemented as a single uop with good throughput", X86::FeatureFastBEXTR, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-gather", "Indicates if gather is reasonably fast", X86::FeatureHasFastGather, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-hops", "Prefer horizontal vector math instructions (haddp, phsub, etc.) over normal vector instructions with shuffles", X86::FeatureFastHorizontalOps, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-lzcnt", "LZCNT instructions are as fast as most simple integer ops", X86::FeatureFastLZCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-scalar-fsqrt", "Scalar SQRT is fast (disable Newton-Raphson)", X86::FeatureFastScalarFSQRT, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-scalar-shift-masks", "Prefer a left/right scalar logical shift pair over a shift+and pair", X86::FeatureFastScalarShiftMasks, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-shld-rotate", "SHLD can be used as a faster rotate", X86::FeatureFastSHLDRotate, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-variable-shuffle", "Shuffles with variable masks are fast", X86::FeatureFastVariableShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-vector-fsqrt", "Vector SQRT is fast (disable Newton-Raphson)", X86::FeatureFastVectorFSQRT, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-vector-shift-masks", "Prefer a left/right vector logical shift pair over a shift+and pair", X86::FeatureFastVectorShiftMasks, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fma", "Enable three-operand fused multiple-add", X86::FeatureFMA, { { { 0x20ULL, 0x0ULL, 0x0ULL, } } } },
  { "fma4", "Enable four-operand fused multiple-add", X86::FeatureFMA4, { { { 0x20ULL, 0x2000000ULL, 0x0ULL, } } } },
  { "fsgsbase", "Support FS/GS Base instructions", X86::FeatureFSGSBase, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fxsr", "Support fxsave/fxrestore instructions", X86::FeatureFXSR, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "gfni", "Enable Galois Field Arithmetic Instructions", X86::FeatureGFNI, { { { 0x0ULL, 0x800000ULL, 0x0ULL, } } } },
  { "idivl-to-divb", "Use 8-bit divide for positive values less than 256", X86::FeatureSlowDivide32, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "idivq-to-divl", "Use 32-bit divide for positive values less than 2^32", X86::FeatureSlowDivide64, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "invpcid", "Invalidate Process-Context Identifier", X86::FeatureINVPCID, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lea-sp", "Use LEA for adjusting the stack pointer", X86::FeatureLEAForSP, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lea-uses-ag", "LEA instruction needs inputs at AG stage", X86::FeatureLEAUsesAG, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lwp", "Enable LWP instructions", X86::FeatureLWP, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lzcnt", "Support LZCNT instruction", X86::FeatureLZCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "macrofusion", "Various instructions can be fused with conditional branches", X86::FeatureMacroFusion, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "merge-to-threeway-branch", "Merge branches to a three-way conditional branch", X86::FeatureMergeToThreeWayBranch, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "mmx", "Enable MMX instructions", X86::FeatureMMX, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movbe", "Support MOVBE instruction", X86::FeatureMOVBE, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movdir64b", "Support movdir64b instruction", X86::FeatureMOVDIR64B, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movdiri", "Support movdiri instruction", X86::FeatureMOVDIRI, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "mpx", "Deprecated. Support MPX instructions", X86::FeatureDeprecatedMPX, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "mwaitx", "Enable MONITORX/MWAITX timer functionality", X86::FeatureMWAITX, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "nopl", "Enable NOPL instruction", X86::FeatureNOPL, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pad-short-functions", "Pad short functions", X86::FeaturePadShortFunctions, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pclmul", "Enable packed carry-less multiplication instructions", X86::FeaturePCLMUL, { { { 0x0ULL, 0x800000ULL, 0x0ULL, } } } },
  { "pconfig", "platform configuration instruction", X86::FeaturePCONFIG, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pku", "Enable protection keys", X86::FeaturePKU, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "popcnt", "Support POPCNT instruction", X86::FeaturePOPCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-128-bit", "Prefer 128-bit AVX instructions", X86::FeaturePrefer128Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-256-bit", "Prefer 256-bit AVX instructions", X86::FeaturePrefer256Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-mask-registers", "Prefer AVX512 mask registers over PTEST/MOVMSK", X86::FeaturePreferMaskRegisters, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefetchwt1", "Prefetch with Intent to Write and T1 Hint", X86::FeaturePREFETCHWT1, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prfchw", "Support PRFCHW instructions", X86::FeaturePRFCHW, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ptwrite", "Support ptwrite instruction", X86::FeaturePTWRITE, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdpid", "Support RDPID instructions", X86::FeatureRDPID, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdrnd", "Support RDRAND instruction", X86::FeatureRDRAND, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdseed", "Support RDSEED instruction", X86::FeatureRDSEED, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline", "Remove speculation of indirect branches from the generated code, either by avoiding them entirely or lowering them with a speculation blocking construct", X86::FeatureRetpoline, { { { 0x0ULL, 0x60000ULL, 0x0ULL, } } } },
  { "retpoline-external-thunk", "When lowering an indirect call or branch using a `retpoline`, rely on the specified user provided thunk rather than emitting one ourselves. Only has effect when combined with some other retpoline feature", X86::FeatureRetpolineExternalThunk, { { { 0x0ULL, 0x40000ULL, 0x0ULL, } } } },
  { "retpoline-indirect-branches", "Remove speculation of indirect branches from the generated code", X86::FeatureRetpolineIndirectBranches, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-indirect-calls", "Remove speculation of indirect calls from the generated code", X86::FeatureRetpolineIndirectCalls, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rtm", "Support RTM instructions", X86::FeatureRTM, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sahf", "Support LAHF and SAHF instructions", X86::FeatureLAHFSAHF, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sgx", "Enable Software Guard Extensions", X86::FeatureSGX, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sha", "Enable SHA instructions", X86::FeatureSHA, { { { 0x0ULL, 0x800000ULL, 0x0ULL, } } } },
  { "shstk", "Support CET Shadow-Stack instructions", X86::FeatureSHSTK, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-3ops-lea", "LEA instruction with 3 ops or certain registers is slow", X86::FeatureSlow3OpsLEA, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-incdec", "INC and DEC instructions are slower than ADD and SUB", X86::FeatureSlowIncDec, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-lea", "LEA instruction with certain arguments is slow", X86::FeatureSlowLEA, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-pmaddwd", "PMADDWD is slower than PMULLD", X86::FeatureSlowPMADDWD, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-pmulld", "PMULLD instruction is slow", X86::FeatureSlowPMULLD, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-shld", "SHLD instruction is slow", X86::FeatureSlowSHLD, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-two-mem-ops", "Two memory operand instructions are slow", X86::FeatureSlowTwoMemOps, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-unaligned-mem-16", "Slow unaligned 16-byte memory access", X86::FeatureSlowUAMem16, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-unaligned-mem-32", "Slow unaligned 32-byte memory access", X86::FeatureSlowUAMem32, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "soft-float", "Use software floating point features", X86::FeatureSoftFloat, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse", "Enable SSE instructions", X86::FeatureSSE1, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse-unaligned-mem", "Allow unaligned memory operands with SSE instructions", X86::FeatureSSEUnalignedMem, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse2", "Enable SSE2 instructions", X86::FeatureSSE2, { { { 0x0ULL, 0x400000ULL, 0x0ULL, } } } },
  { "sse3", "Enable SSE3 instructions", X86::FeatureSSE3, { { { 0x0ULL, 0x800000ULL, 0x0ULL, } } } },
  { "sse4.1", "Enable SSE 4.1 instructions", X86::FeatureSSE41, { { { 0x0ULL, 0x20000000ULL, 0x0ULL, } } } },
  { "sse4.2", "Enable SSE 4.2 instructions", X86::FeatureSSE42, { { { 0x0ULL, 0x4000000ULL, 0x0ULL, } } } },
  { "sse4a", "Support SSE 4a instructions", X86::FeatureSSE4A, { { { 0x0ULL, 0x1000000ULL, 0x0ULL, } } } },
  { "ssse3", "Enable SSSE3 instructions", X86::FeatureSSSE3, { { { 0x0ULL, 0x1000000ULL, 0x0ULL, } } } },
  { "tbm", "Enable TBM instructions", X86::FeatureTBM, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "use-aa", "Use alias analysis during codegen", X86::FeatureUseAA, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "use-glm-div-sqrt-costs", "Use Goldmont specific floating point div/sqrt costs", X86::FeatureUseGLMDivSqrtCosts, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vaes", "Promote selected AES instructions to AVX512/AVX registers", X86::FeatureVAES, { { { 0x30ULL, 0x0ULL, 0x0ULL, } } } },
  { "vpclmulqdq", "Enable vpclmulqdq instructions", X86::FeatureVPCLMULQDQ, { { { 0x4000000000000020ULL, 0x0ULL, 0x0ULL, } } } },
  { "vzeroupper", "Should insert vzeroupper instructions", X86::FeatureInsertVZEROUPPER, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "waitpkg", "Wait and pause enhancements", X86::FeatureWAITPKG, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "wbnoinvd", "Write Back No Invalidate", X86::FeatureWBNOINVD, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "x87", "Enable X87 float instructions", X86::FeatureX87, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xop", "Enable XOP instructions", X86::FeatureXOP, { { { 0x20000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsave", "Support xsave instructions", X86::FeatureXSAVE, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsavec", "Support xsavec instructions", X86::FeatureXSAVEC, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsaveopt", "Support xsaveopt instructions", X86::FeatureXSAVEOPT, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsaves", "Support xsaves instructions", X86::FeatureXSAVES, { { { 0x0ULL, 0x0ULL, 0x0ULL, } } } },
};

#ifdef DBGFIELD
#error "<target>GenSubtargetInfo.inc requires a DBGFIELD macro"
#endif
#if !defined(NDEBUG) || defined(LLVM_ENABLE_DUMP)
#define DBGFIELD(x) x,
#else
#define DBGFIELD(x)
#endif

// ===============================================================
// Data tables for the new per-operand machine model.

// {ProcResourceIdx, Cycles}
extern const llvm::MCWriteProcResEntry X86WriteProcResTable[] = {
  { 0,  0}, // Invalid
  { 3,  1}, // #1
  { 1,  1}, // #2
  { 3,  2}, // #3
  { 2,  1}, // #4
  { 3,  1}, // #5
  { 1,  1}, // #6
  { 3,  1}, // #7
  { 3,  7}, // #8
  { 3,  6}, // #9
  { 1,  5}, // #10
  { 3,  5}, // #11
  { 3, 16}, // #12
  { 3,  9}, // #13
  { 3, 11}, // #14
  { 3, 15}, // #15
  { 3,  8}, // #16
  { 3, 50}, // #17
  { 3, 130}, // #18
  { 3, 68}, // #19
  { 3, 125}, // #20
  { 3, 70}, // #21
  { 3, 34}, // #22
  { 3, 62}, // #23
  { 3, 10}, // #24
  { 3, 12}, // #25
  { 3, 14}, // #26
  { 1,  3}, // #27
  { 3,  3}, // #28
  { 3,  4}, // #29
  { 1,  4}, // #30
  { 3,  4}, // #31
  { 1,  2}, // #32
  { 3,  2}, // #33
  { 3, 71}, // #34
  { 2,  5}, // #35
  { 3,  5}, // #36
  { 1,  1}, // #37
  { 2,  1}, // #38
  { 3,  2}, // #39
  { 1,  5}, // #40
  { 2,  5}, // #41
  { 3, 10}, // #42
  { 3, 13}, // #43
  { 3, 17}, // #44
  { 3, 18}, // #45
  { 3, 20}, // #46
  { 3, 21}, // #47
  { 3, 22}, // #48
  { 3, 23}, // #49
  { 3, 25}, // #50
  { 3, 26}, // #51
  { 3, 29}, // #52
  { 3, 30}, // #53
  { 3, 32}, // #54
  { 3, 45}, // #55
  { 3, 46}, // #56
  { 3, 48}, // #57
  { 3, 55}, // #58
  { 3, 59}, // #59
  { 3, 63}, // #60
  { 3, 72}, // #61
  { 3, 74}, // #62
  { 3, 77}, // #63
  { 3, 78}, // #64
  { 3, 79}, // #65
  { 3, 92}, // #66
  { 3, 94}, // #67
  { 3, 99}, // #68
  { 3, 121}, // #69
  { 3, 127}, // #70
  { 3, 140}, // #71
  { 3, 141}, // #72
  { 3, 146}, // #73
  { 3, 147}, // #74
  { 3, 168}, // #75
  { 3, 174}, // #76
  { 3, 183}, // #77
  { 3, 202}, // #78
  { 5,  2}, // #79
  { 8,  2}, // #80
  {11,  1}, // #81
  {14,  1}, // #82
  {19,  1}, // #83
  { 1,  2}, // #84
  { 5, 44}, // #85
  { 7, 44}, // #86
  { 8, 44}, // #87
  {22,  1}, // #88
  {24,  1}, // #89
  { 1,  3}, // #90
  { 2,  1}, // #91
  { 5,  1}, // #92
  { 7,  1}, // #93
  { 8,  1}, // #94
  {22,  3}, // #95
  { 5,  1}, // #96
  { 8,  1}, // #97
  { 5,  6}, // #98
  { 8,  6}, // #99
  { 1,  1}, // #100
  {13,  1}, // #101
  {14,  3}, // #102
  {20,  3}, // #103
  {24,  1}, // #104
  { 1,  3}, // #105
  {10,  3}, // #106
  {14,  1}, // #107
  {19,  1}, // #108
  {22,  3}, // #109
  { 1,  1}, // #110
  {13,  2}, // #111
  {14, 36}, // #112
  {20, 36}, // #113
  {24,  1}, // #114
  {10,  4}, // #115
  {14,  1}, // #116
  {16,  1}, // #117
  {19,  1}, // #118
  { 1,  4}, // #119
  { 5,  2}, // #120
  { 8,  2}, // #121
  {22,  3}, // #122
  {24,  1}, // #123
  { 1,  3}, // #124
  { 5,  2}, // #125
  { 8,  2}, // #126
  {22,  3}, // #127
  { 1,  3}, // #128
  {10,  1}, // #129
  {14,  1}, // #130
  {15,  1}, // #131
  {19,  1}, // #132
  {22,  3}, // #133
  { 1,  3}, // #134
  {12,  1}, // #135
  {14,  1}, // #136
  {15,  1}, // #137
  {19,  1}, // #138
  {22,  3}, // #139
  { 1,  3}, // #140
  {10,  2}, // #141
  {14,  1}, // #142
  {19,  1}, // #143
  {22,  3}, // #144
  { 1,  3}, // #145
  { 5,  6}, // #146
  { 8,  6}, // #147
  {22,  3}, // #148
  { 1,  3}, // #149
  { 5,  8}, // #150
  { 8,  8}, // #151
  {22,  3}, // #152
  { 1,  2}, // #153
  { 5,  7}, // #154
  { 8,  7}, // #155
  {22,  2}, // #156
  { 1,  1}, // #157
  { 5, 42}, // #158
  { 8, 42}, // #159
  {22,  1}, // #160
  { 1,  1}, // #161
  { 5, 44}, // #162
  { 8, 44}, // #163
  {22,  1}, // #164
  { 1,  3}, // #165
  { 5,  1}, // #166
  { 8,  1}, // #167
  {22,  3}, // #168
  { 1,  2}, // #169
  {22,  2}, // #170
  { 5,  3}, // #171
  { 7,  3}, // #172
  { 8,  3}, // #173
  { 1,  3}, // #174
  { 5,  1}, // #175
  { 6,  1}, // #176
  { 8,  1}, // #177
  {10,  1}, // #178
  {14,  1}, // #179
  {15,  1}, // #180
  {19,  1}, // #181
  {22,  3}, // #182
  { 1,  3}, // #183
  { 5,  4}, // #184
  { 8,  4}, // #185
  {22,  3}, // #186
  { 1,  3}, // #187
  { 9,  1}, // #188
  {13,  1}, // #189
  {14,  1}, // #190
  {15,  1}, // #191
  {19,  1}, // #192
  {22,  3}, // #193
  { 1,  3}, // #194
  { 5,  1}, // #195
  { 6,  1}, // #196
  { 8,  1}, // #197
  { 9,  1}, // #198
  {10,  1}, // #199
  {13,  1}, // #200
  {14,  1}, // #201
  {15,  1}, // #202
  {19,  1}, // #203
  {22,  3}, // #204
  { 1,  3}, // #205
  { 9,  2}, // #206
  {13,  1}, // #207
  {14,  1}, // #208
  {15,  1}, // #209
  {19,  1}, // #210
  {22,  3}, // #211
  { 1,  3}, // #212
  { 4, 15}, // #213
  { 5,  1}, // #214
  { 7,  1}, // #215
  { 8,  1}, // #216
  {22,  3}, // #217
  { 1,  3}, // #218
  { 4, 14}, // #219
  { 5,  1}, // #220
  { 7,  1}, // #221
  { 8,  1}, // #222
  {22,  3}, // #223
  { 1,  3}, // #224
  { 4, 12}, // #225
  { 5,  1}, // #226
  { 7,  1}, // #227
  { 8,  1}, // #228
  {22,  3}, // #229
  { 1,  3}, // #230
  {10,  9}, // #231
  {14,  1}, // #232
  {16,  1}, // #233
  {19,  1}, // #234
  {22,  3}, // #235
  { 1,  3}, // #236
  {10, 10}, // #237
  {14,  1}, // #238
  {16,  1}, // #239
  {19,  1}, // #240
  {22,  3}, // #241
  { 1,  3}, // #242
  {10, 14}, // #243
  {14,  1}, // #244
  {16,  1}, // #245
  {19,  1}, // #246
  {22,  3}, // #247
  { 1,  1}, // #248
  {24,  1}, // #249
  { 1,  1}, // #250
  {13,  1}, // #251
  {14,  2}, // #252
  {16,  2}, // #253
  {19,  2}, // #254
  {24,  1}, // #255
  { 5,  1}, // #256
  { 6,  1}, // #257
  { 8,  1}, // #258
  {10,  3}, // #259
  {14,  1}, // #260
  {15,  1}, // #261
  {19,  1}, // #262
  {11,  2}, // #263
  {14,  1}, // #264
  {19,  1}, // #265
  {10,  1}, // #266
  {14,  1}, // #267
  {19,  1}, // #268
  {13,  1}, // #269
  {14,  1}, // #270
  {16,  1}, // #271
  {19,  1}, // #272
  { 1,  3}, // #273
  {11,  2}, // #274
  {14,  1}, // #275
  {19,  1}, // #276
  {22,  3}, // #277
  { 1,  3}, // #278
  {10,  5}, // #279
  {14,  1}, // #280
  {15,  1}, // #281
  {19,  1}, // #282
  {22,  3}, // #283
  { 1,  3}, // #284
  { 4, 17}, // #285
  { 5,  1}, // #286
  { 7,  1}, // #287
  { 8,  1}, // #288
  {22,  3}, // #289
  { 1,  3}, // #290
  { 4, 25}, // #291
  { 5,  1}, // #292
  { 7,  1}, // #293
  { 8,  1}, // #294
  {22,  3}, // #295
  { 1,  3}, // #296
  { 5,  1}, // #297
  { 7,  1}, // #298
  { 8,  1}, // #299
  {22,  3}, // #300
  {23,  5}, // #301
  { 5,  1}, // #302
  { 7,  1}, // #303
  { 8,  1}, // #304
  {23,  5}, // #305
  { 1,  3}, // #306
  { 5,  1}, // #307
  { 7,  1}, // #308
  { 8,  1}, // #309
  {22,  3}, // #310
  {23,  2}, // #311
  { 5,  1}, // #312
  { 7,  1}, // #313
  { 8,  1}, // #314
  {23,  2}, // #315
  { 1,  3}, // #316
  { 5,  1}, // #317
  { 7,  1}, // #318
  { 8,  1}, // #319
  {22,  3}, // #320
  {23,  4}, // #321
  { 5,  1}, // #322
  { 7,  1}, // #323
  { 8,  1}, // #324
  {23,  4}, // #325
  { 1,  3}, // #326
  { 5,  1}, // #327
  { 7,  1}, // #328
  { 8,  1}, // #329
  {22,  3}, // #330
  {23,  6}, // #331
  { 5,  1}, // #332
  { 7,  1}, // #333
  { 8,  1}, // #334
  {23,  6}, // #335
  { 1,  3}, // #336
  {11,  3}, // #337
  {14,  1}, // #338
  {19,  1}, // #339
  {22,  3}, // #340
  { 1,  1}, // #341
  {22,  1}, // #342
  { 1,  3}, // #343
  { 5,  2}, // #344
  { 6,  2}, // #345
  { 8,  2}, // #346
  {22,  3}, // #347
  { 1,  1}, // #348
  {13,  1}, // #349
  {14,  1}, // #350
  {16,  1}, // #351
  {19,  1}, // #352
  {24,  1}, // #353
  { 1,  3}, // #354
  {11,  1}, // #355
  {14,  1}, // #356
  {19,  1}, // #357
  {22,  3}, // #358
  { 1,  3}, // #359
  {11,  4}, // #360
  {14,  1}, // #361
  {19,  1}, // #362
  {22,  3}, // #363
  { 1,  3}, // #364
  {12,  4}, // #365
  {14,  1}, // #366
  {15,  1}, // #367
  {19,  1}, // #368
  {22,  3}, // #369
  { 1,  3}, // #370
  {10,  1}, // #371
  {14,  1}, // #372
  {16,  1}, // #373
  {19,  1}, // #374
  {22,  3}, // #375
  { 1,  3}, // #376
  {12,  7}, // #377
  {14,  1}, // #378
  {15,  1}, // #379
  {19,  1}, // #380
  {22,  3}, // #381
  { 1, 23}, // #382
  { 5,  1}, // #383
  { 6,  1}, // #384
  { 8,  1}, // #385
  {10,  1}, // #386
  {11, 10}, // #387
  {14,  1}, // #388
  {16,  1}, // #389
  {19,  1}, // #390
  {22, 13}, // #391
  {24, 10}, // #392
  { 1, 20}, // #393
  { 5,  1}, // #394
  { 6,  1}, // #395
  { 8,  1}, // #396
  {10,  1}, // #397
  {11, 10}, // #398
  {14,  1}, // #399
  {16,  1}, // #400
  {19,  1}, // #401
  {22, 10}, // #402
  {24, 10}, // #403
  { 1,  3}, // #404
  { 5,  1}, // #405
  { 6,  1}, // #406
  { 8,  1}, // #407
  {10,  6}, // #408
  {14,  1}, // #409
  {16,  1}, // #410
  {19,  1}, // #411
  {22,  3}, // #412
  { 1,  3}, // #413
  { 5,  1}, // #414
  { 6,  1}, // #415
  { 8,  1}, // #416
  {10,  8}, // #417
  {14,  1}, // #418
  {16,  1}, // #419
  {19,  1}, // #420
  {22,  3}, // #421
  { 1,  3}, // #422
  {11,  1}, // #423
  {14,  1}, // #424
  {15,  1}, // #425
  {19,  1}, // #426
  {22,  3}, // #427
  { 1,  3}, // #428
  {11,  1}, // #429
  {12,  2}, // #430
  {14,  3}, // #431
  {15,  2}, // #432
  {19,  3}, // #433
  {22,  3}, // #434
  { 1,  3}, // #435
  {22,  2}, // #436
  {24,  1}, // #437
  { 1,  4}, // #438
  { 5,  1}, // #439
  { 8,  1}, // #440
  {22,  3}, // #441
  {24,  1}, // #442
  { 1,  3}, // #443
  {13,  1}, // #444
  {14,  1}, // #445
  {16,  1}, // #446
  {19,  1}, // #447
  {22,  3}, // #448
  { 1,  3}, // #449
  {10,  2}, // #450
  {14,  1}, // #451
  {16,  1}, // #452
  {19,  1}, // #453
  {22,  3}, // #454
  { 1,  1}, // #455
  { 5,  1}, // #456
  { 8,  1}, // #457
  {24,  1}, // #458
  { 1,  1}, // #459
  { 5, 22}, // #460
  { 8, 22}, // #461
  {22,  1}, // #462
  {10, 18}, // #463
  {14,  1}, // #464
  {16,  1}, // #465
  {19,  1}, // #466
  { 1, 18}, // #467
  {24, 18}, // #468
  { 1,  3}, // #469
  {10,  3}, // #470
  {14,  1}, // #471
  {22,  3}, // #472
  { 1,  3}, // #473
  {10,  2}, // #474
  {14,  1}, // #475
  {15,  1}, // #476
  {19,  1}, // #477
  {22,  3}, // #478
  { 1,  3}, // #479
  {10,  2}, // #480
  {14,  2}, // #481
  {19,  2}, // #482
  {22,  3}, // #483
  { 1,  3}, // #484
  {10,  4}, // #485
  {14,  2}, // #486
  {19,  2}, // #487
  {22,  3}, // #488
  { 1,  3}, // #489
  {10,  3}, // #490
  {14,  2}, // #491
  {19,  2}, // #492
  {22,  3}, // #493
  { 1,  3}, // #494
  { 9,  2}, // #495
  {10,  1}, // #496
  {13,  1}, // #497
  {14,  1}, // #498
  {15,  1}, // #499
  {19,  1}, // #500
  {22,  3}, // #501
  { 1,  1}, // #502
  { 9,  2}, // #503
  {10,  1}, // #504
  {13,  1}, // #505
  {14,  1}, // #506
  {15,  1}, // #507
  {19,  1}, // #508
  {24,  1}, // #509
  { 1,  1}, // #510
  { 9,  2}, // #511
  {13,  1}, // #512
  {14,  1}, // #513
  {15,  1}, // #514
  {19,  1}, // #515
  {24,  1}, // #516
  { 1,  3}, // #517
  {10, 18}, // #518
  {14,  2}, // #519
  {16,  2}, // #520
  {19,  2}, // #521
  {22,  3}, // #522
  { 1,  3}, // #523
  {10, 25}, // #524
  {14,  2}, // #525
  {16,  2}, // #526
  {19,  2}, // #527
  {22,  3}, // #528
  { 1,  3}, // #529
  {13,  1}, // #530
  {14,  2}, // #531
  {16,  2}, // #532
  {19,  2}, // #533
  {22,  3}, // #534
  { 1,  3}, // #535
  {10,  8}, // #536
  {14,  1}, // #537
  {15,  1}, // #538
  {19,  1}, // #539
  {22,  3}, // #540
  { 1,  3}, // #541
  {11,  3}, // #542
  {14,  2}, // #543
  {19,  2}, // #544
  {22,  3}, // #545
  { 1,  2}, // #546
  {10, 376}, // #547
  {14,  2}, // #548
  {19,  2}, // #549
  {24,  2}, // #550
  { 1,  1}, // #551
  {10, 188}, // #552
  {14,  1}, // #553
  {19,  1}, // #554
  {24,  1}, // #555
  { 1,  3}, // #556
  {10,  4}, // #557
  {14,  1}, // #558
  {19,  1}, // #559
  {22,  3}, // #560
  { 1,  2}, // #561
  {13,  2}, // #562
  {14, 36}, // #563
  {20, 36}, // #564
  {24,  2}, // #565
  {11,  2}, // #566
  {14,  2}, // #567
  {19,  2}, // #568
  { 1,  3}, // #569
  {11,  4}, // #570
  {14,  2}, // #571
  {19,  2}, // #572
  {22,  3}, // #573
  { 1,  2}, // #574
  {13,  2}, // #575
  {14,  2}, // #576
  {16,  2}, // #577
  {19,  2}, // #578
  {24,  2}, // #579
  { 1,  2}, // #580
  {11,  4}, // #581
  {14,  2}, // #582
  {19,  2}, // #583
  {24,  2}, // #584
  { 1,  1}, // #585
  {11,  4}, // #586
  {14,  1}, // #587
  {19,  1}, // #588
  {24,  1}, // #589
  { 1,  3}, // #590
  { 5,  1}, // #591
  { 6,  1}, // #592
  { 8,  1}, // #593
  {10,  4}, // #594
  {14,  2}, // #595
  {19,  2}, // #596
  {22,  3}, // #597
  { 1,  3}, // #598
  {10,  1}, // #599
  {14,  2}, // #600
  {16,  2}, // #601
  {19,  2}, // #602
  {22,  3}, // #603
  { 1,  3}, // #604
  {10,  2}, // #605
  {14,  2}, // #606
  {16,  2}, // #607
  {19,  2}, // #608
  {22,  3}, // #609
  { 1,  3}, // #610
  { 5,  1}, // #611
  { 6,  1}, // #612
  { 8,  1}, // #613
  {10,  4}, // #614
  {14,  4}, // #615
  {19,  4}, // #616
  {22,  3}, // #617
  { 5, 23}, // #618
  { 7, 23}, // #619
  { 8, 23}, // #620
  { 5, 21}, // #621
  { 7, 21}, // #622
  { 8, 21}, // #623
  { 5, 26}, // #624
  { 7, 26}, // #625
  { 8, 26}, // #626
  { 5, 69}, // #627
  { 7, 69}, // #628
  { 8, 69}, // #629
  { 5, 25}, // #630
  { 8, 25}, // #631
  { 1,  1}, // #632
  {10,  4}, // #633
  {14,  2}, // #634
  {19,  2}, // #635
  {22,  1}, // #636
  { 5, 20}, // #637
  { 7, 20}, // #638
  { 8, 20}, // #639
  { 1,  3}, // #640
  {10, 10}, // #641
  {14,  1}, // #642
  {15,  1}, // #643
  {19,  1}, // #644
  {22,  3}, // #645
  { 1,  3}, // #646
  {10, 18}, // #647
  {14,  1}, // #648
  {15,  1}, // #649
  {19,  1}, // #650
  {22,  3}, // #651
  { 9,  3}, // #652
  {13,  1}, // #653
  {14,  1}, // #654
  {15,  1}, // #655
  {19,  1}, // #656
  { 5, 375}, // #657
  { 8, 375}, // #658
  { 5, 18}, // #659
  { 8, 18}, // #660
  { 5, 24}, // #661
  { 8, 24}, // #662
  {10,  6}, // #663
  {14,  1}, // #664
  {19,  1}, // #665
  {10,  8}, // #666
  {14,  1}, // #667
  {19,  1}, // #668
  { 5, 88}, // #669
  { 8, 88}, // #670
  { 1,  3}, // #671
  { 5,  3}, // #672
  { 8,  3}, // #673
  {22,  3}, // #674
  { 5, 10}, // #675
  { 8, 10}, // #676
  { 5, 12}, // #677
  { 8, 12}, // #678
  { 5, 17}, // #679
  { 8, 17}, // #680
  { 5,  5}, // #681
  { 8,  5}, // #682
  { 5, 23}, // #683
  { 8, 23}, // #684
  { 5, 20}, // #685
  { 8, 20}, // #686
  { 5, 19}, // #687
  { 8, 19}, // #688
  { 5, 14}, // #689
  { 8, 14}, // #690
  { 5, 13}, // #691
  { 8, 13}, // #692
  { 5, 21}, // #693
  { 8, 21}, // #694
  { 5, 15}, // #695
  { 8, 15}, // #696
  {13,  1}, // #697
  {14, 10}, // #698
  {16, 10}, // #699
  {19, 10}, // #700
  {13,  1}, // #701
  {14,  3}, // #702
  {16,  3}, // #703
  {19,  3}, // #704
  {13,  1}, // #705
  {14,  4}, // #706
  {16,  4}, // #707
  {19,  4}, // #708
  {11,  1}, // #709
  {12,  1}, // #710
  {14,  1}, // #711
  {15,  1}, // #712
  {19,  1}, // #713
  {22,  1}, // #714
  {23,  1}, // #715
  { 7,  1}, // #716
  {12,  1}, // #717
  {14,  2}, // #718
  {17,  1}, // #719
  {20,  2}, // #720
  {21,  2}, // #721
  {22,  3}, // #722
  {23,  6}, // #723
  {14,  1}, // #724
  {17,  1}, // #725
  {20,  1}, // #726
  {21,  1}, // #727
  {22,  1}, // #728
  {23,  2}, // #729
  {14,  1}, // #730
  {20,  1}, // #731
  {22,  1}, // #732
  {23,  1}, // #733
  { 4,  1}, // #734
  {11,  1}, // #735
  {15,  1}, // #736
  {16,  1}, // #737
  {19,  1}, // #738
  {22,  1}, // #739
  {23,  1}, // #740
  { 7,  1}, // #741
  {12,  1}, // #742
  {21,  1}, // #743
  {23,  2}, // #744
  {17,  1}, // #745
  {21,  1}, // #746
  {23,  1}, // #747
  { 8,  1}, // #748
  {13,  1}, // #749
  {15,  1}, // #750
  {18,  1}, // #751
  {19,  1}, // #752
  {20,  1}, // #753
  {22,  1}, // #754
  {23,  1}, // #755
  { 7,  1}, // #756
  {12,  1}, // #757
  {17,  1}, // #758
  {21,  2}, // #759
  {22,  1}, // #760
  {23,  4}, // #761
  {17,  1}, // #762
  {21,  1}, // #763
  {22,  1}, // #764
  {23,  2}, // #765
  { 4,  1}, // #766
  {11,  1}, // #767
  {15,  1}, // #768
  {16,  1}, // #769
  {17,  1}, // #770
  {19,  1}, // #771
  {21,  1}, // #772
  {22,  1}, // #773
  {23,  2}, // #774
  { 8,  1}, // #775
  {13,  1}, // #776
  {15,  1}, // #777
  {17,  1}, // #778
  {18,  1}, // #779
  {19,  1}, // #780
  {20,  1}, // #781
  {21,  1}, // #782
  {22,  1}, // #783
  {23,  2}, // #784
  { 8,  2}, // #785
  {13,  2}, // #786
  {15,  2}, // #787
  {17,  1}, // #788
  {18,  2}, // #789
  {19,  2}, // #790
  {20,  2}, // #791
  {21,  1}, // #792
  {22,  2}, // #793
  {23,  3}, // #794
  { 8,  2}, // #795
  {13,  2}, // #796
  {15,  2}, // #797
  {18,  2}, // #798
  {19,  2}, // #799
  {20,  2}, // #800
  {22,  2}, // #801
  {23,  2}, // #802
  { 3,  2}, // #803
  { 8,  7}, // #804
  {11,  2}, // #805
  {12,  2}, // #806
  {13,  9}, // #807
  {14,  2}, // #808
  {15,  7}, // #809
  {17,  1}, // #810
  {18,  7}, // #811
  {19, 10}, // #812
  {20,  9}, // #813
  {21,  1}, // #814
  {22, 10}, // #815
  {23, 11}, // #816
  { 3,  2}, // #817
  { 8,  7}, // #818
  {11,  2}, // #819
  {12,  2}, // #820
  {13,  9}, // #821
  {14,  2}, // #822
  {15,  7}, // #823
  {18,  7}, // #824
  {19, 11}, // #825
  {20,  9}, // #826
  {22, 11}, // #827
  {23, 11}, // #828
  {14,  1}, // #829
  {15,  1}, // #830
  {17,  1}, // #831
  {19,  1}, // #832
  {20,  1}, // #833
  {21,  1}, // #834
  {22,  2}, // #835
  {23,  3}, // #836
  {14,  1}, // #837
  {15,  1}, // #838
  {19,  1}, // #839
  {20,  1}, // #840
  {22,  2}, // #841
  {23,  2}, // #842
  {15,  1}, // #843
  {17,  1}, // #844
  {19,  1}, // #845
  {21,  1}, // #846
  {22,  1}, // #847
  {23,  2}, // #848
  { 7,  1}, // #849
  {12,  1}, // #850
  {14,  1}, // #851
  {17,  1}, // #852
  {20,  1}, // #853
  {21,  2}, // #854
  {22,  1}, // #855
  {23,  4}, // #856
  {14,  2}, // #857
  {20,  2}, // #858
  {22,  5}, // #859
  {23,  5}, // #860
  { 3,  2}, // #861
  { 4,  2}, // #862
  { 8,  2}, // #863
  {11,  4}, // #864
  {12,  2}, // #865
  {13,  4}, // #866
  {14,  2}, // #867
  {15,  4}, // #868
  {16,  2}, // #869
  {17,  1}, // #870
  {18,  2}, // #871
  {19,  6}, // #872
  {20,  4}, // #873
  {21,  1}, // #874
  {22,  7}, // #875
  {23,  8}, // #876
  { 3,  7}, // #877
  { 4,  7}, // #878
  { 8,  3}, // #879
  { 9,  3}, // #880
  {11, 15}, // #881
  {12,  7}, // #882
  {13, 10}, // #883
  {14, 10}, // #884
  {15, 10}, // #885
  {16, 10}, // #886
  {18,  6}, // #887
  {19, 18}, // #888
  {20, 13}, // #889
  {22, 32}, // #890
  {23, 32}, // #891
  { 1, 10}, // #892
  { 3,  1}, // #893
  {11,  1}, // #894
  {12,  1}, // #895
  {13,  1}, // #896
  {14,  1}, // #897
  {19,  1}, // #898
  {20,  1}, // #899
  {22,  1}, // #900
  {23,  1}, // #901
  { 2,  8}, // #902
  { 3,  1}, // #903
  {11,  1}, // #904
  {12,  1}, // #905
  {13,  1}, // #906
  {14,  1}, // #907
  {17,  1}, // #908
  {19,  1}, // #909
  {20,  1}, // #910
  {21,  1}, // #911
  {22,  1}, // #912
  {23,  2}, // #913
  { 2,  8}, // #914
  { 3,  1}, // #915
  {11,  1}, // #916
  {12,  1}, // #917
  {13,  1}, // #918
  {14,  1}, // #919
  {19,  1}, // #920
  {20,  1}, // #921
  {22,  1}, // #922
  {23,  1}, // #923
  { 2,  5}, // #924
  { 3,  1}, // #925
  {11,  1}, // #926
  {12,  1}, // #927
  {13,  1}, // #928
  {14,  1}, // #929
  {17,  1}, // #930
  {19,  1}, // #931
  {20,  1}, // #932
  {21,  1}, // #933
  {22,  1}, // #934
  {23,  2}, // #935
  { 2,  5}, // #936
  { 3,  1}, // #937
  {11,  1}, // #938
  {12,  1}, // #939
  {13,  1}, // #940
  {14,  1}, // #941
  {19,  1}, // #942
  {20,  1}, // #943
  {22,  1}, // #944
  {23,  1}, // #945
  { 2,  3}, // #946
  { 3,  1}, // #947
  {11,  1}, // #948
  {12,  1}, // #949
  {13,  1}, // #950
  {14,  1}, // #951
  {19,  1}, // #952
  {20,  1}, // #953
  {22,  1}, // #954
  {23,  1}, // #955
  { 2,  4}, // #956
  { 3,  1}, // #957
  {11,  1}, // #958
  {12,  1}, // #959
  {13,  1}, // #960
  {14,  1}, // #961
  {19,  1}, // #962
  {20,  1}, // #963
  {22,  1}, // #964
  {23,  1}, // #965
  { 3,  1}, // #966
  { 4,  1}, // #967
  { 8,  1}, // #968
  {11,  2}, // #969
  {12,  1}, // #970
  {13,  2}, // #971
  {14,  1}, // #972
  {15,  2}, // #973
  {16,  1}, // #974
  {17,  1}, // #975
  {18,  1}, // #976
  {19,  3}, // #977
  {20,  2}, // #978
  {21,  1}, // #979
  {22,  3}, // #980
  {23,  4}, // #981
  { 3,  1}, // #982
  { 4,  1}, // #983
  { 8,  1}, // #984
  {11,  2}, // #985
  {12,  1}, // #986
  {13,  2}, // #987
  {14,  1}, // #988
  {15,  2}, // #989
  {16,  1}, // #990
  {18,  1}, // #991
  {19,  3}, // #992
  {20,  2}, // #993
  {22,  3}, // #994
  {23,  3}, // #995
  { 3,  2}, // #996
  { 4,  1}, // #997
  { 8,  1}, // #998
  {11,  3}, // #999
  {12,  2}, // #1000
  {13,  3}, // #1001
  {14,  2}, // #1002
  {15,  2}, // #1003
  {16,  1}, // #1004
  {17,  1}, // #1005
  {18,  1}, // #1006
  {19,  4}, // #1007
  {20,  3}, // #1008
  {21,  1}, // #1009
  {22,  4}, // #1010
  {23,  5}, // #1011
  { 3,  2}, // #1012
  { 4,  1}, // #1013
  { 8,  1}, // #1014
  {11,  3}, // #1015
  {12,  2}, // #1016
  {13,  3}, // #1017
  {14,  2}, // #1018
  {15,  2}, // #1019
  {16,  1}, // #1020
  {18,  1}, // #1021
  {19,  4}, // #1022
  {20,  3}, // #1023
  {22,  4}, // #1024
  {23,  4}, // #1025
  { 7,  1}, // #1026
  { 8,  1}, // #1027
  {12,  1}, // #1028
  {13,  1}, // #1029
  {15,  1}, // #1030
  {18,  1}, // #1031
  {19,  1}, // #1032
  {20,  1}, // #1033
  {21,  1}, // #1034
  {22,  1}, // #1035
  {23,  3}, // #1036
  { 3,  1}, // #1037
  { 8,  1}, // #1038
  {11,  1}, // #1039
  {12,  1}, // #1040
  {13,  2}, // #1041
  {14,  1}, // #1042
  {15,  1}, // #1043
  {18,  1}, // #1044
  {19,  2}, // #1045
  {20,  2}, // #1046
  {22,  2}, // #1047
  {23,  2}, // #1048
  {11,  8}, // #1049
  {15,  1}, // #1050
  {19, 30}, // #1051
  {22, 31}, // #1052
  {23, 31}, // #1053
  {11,  2}, // #1054
  {19,  2}, // #1055
  {22,  2}, // #1056
  {23,  2}, // #1057
  { 4,  1}, // #1058
  { 8,  2}, // #1059
  {11,  1}, // #1060
  {13,  2}, // #1061
  {15,  3}, // #1062
  {16,  1}, // #1063
  {17,  1}, // #1064
  {18,  2}, // #1065
  {19,  3}, // #1066
  {20,  2}, // #1067
  {21,  1}, // #1068
  {22,  3}, // #1069
  {23,  4}, // #1070
  { 4,  1}, // #1071
  { 8,  2}, // #1072
  {11,  1}, // #1073
  {13,  2}, // #1074
  {15,  3}, // #1075
  {16,  1}, // #1076
  {18,  2}, // #1077
  {19,  3}, // #1078
  {20,  2}, // #1079
  {22,  3}, // #1080
  {23,  3}, // #1081
  { 4,  1}, // #1082
  {11,  1}, // #1083
  {14,  1}, // #1084
  {15,  1}, // #1085
  {16,  1}, // #1086
  {17,  1}, // #1087
  {19,  1}, // #1088
  {20,  1}, // #1089
  {21,  1}, // #1090
  {22,  4}, // #1091
  {23,  5}, // #1092
  { 4,  1}, // #1093
  {11,  1}, // #1094
  {14,  1}, // #1095
  {15,  1}, // #1096
  {16,  1}, // #1097
  {19,  1}, // #1098
  {20,  1}, // #1099
  {22,  4}, // #1100
  {23,  4}, // #1101
  { 4,  1}, // #1102
  {11,  1}, // #1103
  {15,  1}, // #1104
  {16,  1}, // #1105
  {17,  1}, // #1106
  {19,  1}, // #1107
  {21,  1}, // #1108
  {22,  2}, // #1109
  {23,  3}, // #1110
  { 4,  1}, // #1111
  {11,  1}, // #1112
  {15,  1}, // #1113
  {16,  1}, // #1114
  {19,  1}, // #1115
  {22,  2}, // #1116
  {23,  2}, // #1117
  { 4,  1}, // #1118
  {11,  1}, // #1119
  {14,  1}, // #1120
  {15,  1}, // #1121
  {16,  1}, // #1122
  {17,  1}, // #1123
  {19,  1}, // #1124
  {20,  1}, // #1125
  {21,  1}, // #1126
  {22,  3}, // #1127
  {23,  4}, // #1128
  { 4,  1}, // #1129
  {11,  1}, // #1130
  {14,  1}, // #1131
  {15,  1}, // #1132
  {16,  1}, // #1133
  {19,  1}, // #1134
  {20,  1}, // #1135
  {22,  3}, // #1136
  {23,  3}, // #1137
  { 4,  1}, // #1138
  { 8,  1}, // #1139
  {11,  1}, // #1140
  {13,  1}, // #1141
  {15,  2}, // #1142
  {16,  1}, // #1143
  {17,  1}, // #1144
  {18,  1}, // #1145
  {19,  2}, // #1146
  {20,  1}, // #1147
  {21,  1}, // #1148
  {22,  2}, // #1149
  {23,  3}, // #1150
  { 4,  1}, // #1151
  { 8,  1}, // #1152
  {11,  1}, // #1153
  {13,  1}, // #1154
  {15,  2}, // #1155
  {16,  1}, // #1156
  {18,  1}, // #1157
  {19,  2}, // #1158
  {20,  1}, // #1159
  {22,  2}, // #1160
  {23,  2}, // #1161
  { 3,  1}, // #1162
  {11,  1}, // #1163
  {12,  1}, // #1164
  {13,  1}, // #1165
  {14,  1}, // #1166
  {17,  1}, // #1167
  {19,  1}, // #1168
  {20,  1}, // #1169
  {21,  1}, // #1170
  {22,  2}, // #1171
  {23,  3}, // #1172
  {11,  1}, // #1173
  {19,  1}, // #1174
  {22,  1}, // #1175
  {23,  1}, // #1176
  { 7,  1}, // #1177
  {12,  1}, // #1178
  {17,  1}, // #1179
  {21,  1}, // #1180
  {23,  2}, // #1181
  { 8,  2}, // #1182
  {13,  2}, // #1183
  {15,  3}, // #1184
  {17,  1}, // #1185
  {18,  2}, // #1186
  {19,  3}, // #1187
  {20,  2}, // #1188
  {21,  1}, // #1189
  {22,  3}, // #1190
  {23,  4}, // #1191
  { 8,  2}, // #1192
  {13,  2}, // #1193
  {15,  3}, // #1194
  {18,  2}, // #1195
  {19,  3}, // #1196
  {20,  2}, // #1197
  {22,  3}, // #1198
  {23,  3}, // #1199
  { 3,  1}, // #1200
  { 8,  2}, // #1201
  {11,  1}, // #1202
  {12,  1}, // #1203
  {13,  3}, // #1204
  {14,  1}, // #1205
  {15,  2}, // #1206
  {17,  1}, // #1207
  {18,  2}, // #1208
  {19,  3}, // #1209
  {20,  3}, // #1210
  {21,  1}, // #1211
  {22,  3}, // #1212
  {23,  4}, // #1213
  { 3,  1}, // #1214
  { 8,  2}, // #1215
  {11,  1}, // #1216
  {12,  1}, // #1217
  {13,  3}, // #1218
  {14,  1}, // #1219
  {15,  2}, // #1220
  {18,  2}, // #1221
  {19,  3}, // #1222
  {20,  3}, // #1223
  {22,  3}, // #1224
  {23,  3}, // #1225
  {11,  1}, // #1226
  {17,  1}, // #1227
  {19,  1}, // #1228
  {21,  1}, // #1229
  {22,  1}, // #1230
  {23,  2}, // #1231
  { 3,  4}, // #1232
  { 8,  3}, // #1233
  {11,  4}, // #1234
  {12,  4}, // #1235
  {13,  7}, // #1236
  {14,  4}, // #1237
  {15,  3}, // #1238
  {17,  1}, // #1239
  {18,  3}, // #1240
  {19,  7}, // #1241
  {20,  7}, // #1242
  {21,  1}, // #1243
  {22,  8}, // #1244
  {23,  9}, // #1245
  { 3,  4}, // #1246
  { 8,  3}, // #1247
  {11,  4}, // #1248
  {12,  4}, // #1249
  {13,  7}, // #1250
  {14,  4}, // #1251
  {15,  3}, // #1252
  {18,  3}, // #1253
  {19,  7}, // #1254
  {20,  7}, // #1255
  {22,  8}, // #1256
  {23,  8}, // #1257
  { 3,  4}, // #1258
  { 8,  3}, // #1259
  {11,  4}, // #1260
  {12,  4}, // #1261
  {13,  7}, // #1262
  {14,  4}, // #1263
  {15,  3}, // #1264
  {17,  1}, // #1265
  {18,  3}, // #1266
  {19,  8}, // #1267
  {20,  7}, // #1268
  {21,  1}, // #1269
  {22,  9}, // #1270
  {23, 10}, // #1271
  { 3,  4}, // #1272
  { 8,  3}, // #1273
  {11,  4}, // #1274
  {12,  4}, // #1275
  {13,  7}, // #1276
  {14,  4}, // #1277
  {15,  3}, // #1278
  {18,  3}, // #1279
  {19,  8}, // #1280
  {20,  7}, // #1281
  {22,  9}, // #1282
  {23,  9}, // #1283
  { 3,  3}, // #1284
  {11,  3}, // #1285
  {12,  3}, // #1286
  {13,  3}, // #1287
  {14,  3}, // #1288
  {17,  1}, // #1289
  {19,  3}, // #1290
  {20,  3}, // #1291
  {21,  1}, // #1292
  {22,  3}, // #1293
  {23,  4}, // #1294
  { 3,  3}, // #1295
  {11,  3}, // #1296
  {12,  3}, // #1297
  {13,  3}, // #1298
  {14,  3}, // #1299
  {19,  3}, // #1300
  {20,  3}, // #1301
  {22,  3}, // #1302
  {23,  3}, // #1303
  { 3,  2}, // #1304
  {11,  2}, // #1305
  {12,  2}, // #1306
  {13,  2}, // #1307
  {14,  2}, // #1308
  {17,  1}, // #1309
  {19,  2}, // #1310
  {20,  2}, // #1311
  {21,  1}, // #1312
  {22,  2}, // #1313
  {23,  3}, // #1314
  { 3,  2}, // #1315
  {11,  2}, // #1316
  {12,  2}, // #1317
  {13,  2}, // #1318
  {14,  2}, // #1319
  {19,  2}, // #1320
  {20,  2}, // #1321
  {22,  2}, // #1322
  {23,  2}, // #1323
  { 7,  1}, // #1324
  {12,  1}, // #1325
  {17,  1}, // #1326
  {21,  2}, // #1327
  {23,  3}, // #1328
  { 3,  1}, // #1329
  { 8,  1}, // #1330
  {11,  1}, // #1331
  {12,  1}, // #1332
  {13,  2}, // #1333
  {14,  1}, // #1334
  {15,  1}, // #1335
  {17,  1}, // #1336
  {18,  1}, // #1337
  {19,  2}, // #1338
  {20,  2}, // #1339
  {21,  1}, // #1340
  {22,  2}, // #1341
  {23,  3}, // #1342
  {14,  2}, // #1343
  {20,  2}, // #1344
  {22,  3}, // #1345
  {23,  3}, // #1346
  { 4,  2}, // #1347
  {11,  2}, // #1348
  {15,  2}, // #1349
  {16,  2}, // #1350
  {17,  1}, // #1351
  {19,  2}, // #1352
  {21,  1}, // #1353
  {22,  2}, // #1354
  {23,  3}, // #1355
  { 7,  1}, // #1356
  {12,  1}, // #1357
  {14,  1}, // #1358
  {20,  1}, // #1359
  {21,  1}, // #1360
  {22,  1}, // #1361
  {23,  3}, // #1362
  { 4,  1}, // #1363
  {11,  1}, // #1364
  {14,  1}, // #1365
  {15,  1}, // #1366
  {16,  1}, // #1367
  {17,  1}, // #1368
  {19,  1}, // #1369
  {20,  1}, // #1370
  {21,  2}, // #1371
  {22,  4}, // #1372
  {23,  6}, // #1373
  { 4,  1}, // #1374
  {11,  1}, // #1375
  {15,  1}, // #1376
  {16,  1}, // #1377
  {17,  1}, // #1378
  {19,  1}, // #1379
  {21,  2}, // #1380
  {22,  2}, // #1381
  {23,  4}, // #1382
  { 2, 14}, // #1383
  { 3,  1}, // #1384
  {11,  1}, // #1385
  {12,  1}, // #1386
  {13,  1}, // #1387
  {14,  1}, // #1388
  {17,  1}, // #1389
  {19,  1}, // #1390
  {20,  1}, // #1391
  {21,  1}, // #1392
  {22,  1}, // #1393
  {23,  2}, // #1394
  { 2, 14}, // #1395
  { 3,  1}, // #1396
  {11,  1}, // #1397
  {12,  1}, // #1398
  {13,  1}, // #1399
  {14,  1}, // #1400
  {19,  1}, // #1401
  {20,  1}, // #1402
  {22,  1}, // #1403
  {23,  1}, // #1404
  { 2,  7}, // #1405
  { 3,  1}, // #1406
  {11,  1}, // #1407
  {12,  1}, // #1408
  {13,  1}, // #1409
  {14,  1}, // #1410
  {17,  1}, // #1411
  {19,  1}, // #1412
  {20,  1}, // #1413
  {21,  1}, // #1414
  {22,  1}, // #1415
  {23,  2}, // #1416
  { 2,  7}, // #1417
  { 3,  1}, // #1418
  {11,  1}, // #1419
  {12,  1}, // #1420
  {13,  1}, // #1421
  {14,  1}, // #1422
  {19,  1}, // #1423
  {20,  1}, // #1424
  {22,  1}, // #1425
  {23,  1}, // #1426
  { 2,  9}, // #1427
  { 3,  1}, // #1428
  {11,  1}, // #1429
  {12,  1}, // #1430
  {13,  1}, // #1431
  {14,  1}, // #1432
  {19,  1}, // #1433
  {20,  1}, // #1434
  {22,  1}, // #1435
  {23,  1}, // #1436
  { 4,  1}, // #1437
  { 7,  1}, // #1438
  {11,  1}, // #1439
  {12,  1}, // #1440
  {15,  1}, // #1441
  {16,  1}, // #1442
  {19,  1}, // #1443
  {21,  1}, // #1444
  {22,  1}, // #1445
  {23,  3}, // #1446
  { 2, 16}, // #1447
  { 3,  2}, // #1448
  {11,  2}, // #1449
  {12,  2}, // #1450
  {13,  2}, // #1451
  {14,  2}, // #1452
  {17,  1}, // #1453
  {19,  3}, // #1454
  {20,  2}, // #1455
  {21,  1}, // #1456
  {22,  3}, // #1457
  {23,  4}, // #1458
  { 2, 16}, // #1459
  { 3,  2}, // #1460
  {11,  2}, // #1461
  {12,  2}, // #1462
  {13,  2}, // #1463
  {14,  2}, // #1464
  {19,  3}, // #1465
  {20,  2}, // #1466
  {22,  3}, // #1467
  {23,  3}, // #1468
  { 2, 10}, // #1469
  { 3,  2}, // #1470
  {11,  2}, // #1471
  {12,  2}, // #1472
  {13,  2}, // #1473
  {14,  2}, // #1474
  {17,  1}, // #1475
  {19,  3}, // #1476
  {20,  2}, // #1477
  {21,  1}, // #1478
  {22,  3}, // #1479
  {23,  4}, // #1480
  { 2, 10}, // #1481
  { 3,  2}, // #1482
  {11,  2}, // #1483
  {12,  2}, // #1484
  {13,  2}, // #1485
  {14,  2}, // #1486
  {19,  3}, // #1487
  {20,  2}, // #1488
  {22,  3}, // #1489
  {23,  3}, // #1490
  { 3,  1}, // #1491
  { 7,  1}, // #1492
  {11,  1}, // #1493
  {12,  2}, // #1494
  {13,  1}, // #1495
  {14,  1}, // #1496
  {15,  1}, // #1497
  {19,  2}, // #1498
  {20,  1}, // #1499
  {21,  1}, // #1500
  {22,  2}, // #1501
  {23,  4}, // #1502
  { 3,  2}, // #1503
  { 8,  1}, // #1504
  {11,  2}, // #1505
  {12,  2}, // #1506
  {13,  3}, // #1507
  {14,  2}, // #1508
  {15,  1}, // #1509
  {17,  1}, // #1510
  {18,  1}, // #1511
  {19,  3}, // #1512
  {20,  3}, // #1513
  {21,  1}, // #1514
  {22,  3}, // #1515
  {23,  4}, // #1516
  { 3,  2}, // #1517
  { 8,  1}, // #1518
  {11,  2}, // #1519
  {12,  2}, // #1520
  {13,  3}, // #1521
  {14,  2}, // #1522
  {15,  1}, // #1523
  {18,  1}, // #1524
  {19,  3}, // #1525
  {20,  3}, // #1526
  {22,  3}, // #1527
  {23,  3}, // #1528
  { 2, 28}, // #1529
  { 3,  2}, // #1530
  {11,  2}, // #1531
  {12,  2}, // #1532
  {13,  2}, // #1533
  {14,  2}, // #1534
  {17,  1}, // #1535
  {19,  3}, // #1536
  {20,  2}, // #1537
  {21,  1}, // #1538
  {22,  3}, // #1539
  {23,  4}, // #1540
  { 2, 28}, // #1541
  { 3,  2}, // #1542
  {11,  2}, // #1543
  {12,  2}, // #1544
  {13,  2}, // #1545
  {14,  2}, // #1546
  {19,  3}, // #1547
  {20,  2}, // #1548
  {22,  3}, // #1549
  {23,  3}, // #1550
  { 2, 14}, // #1551
  { 3,  2}, // #1552
  {11,  2}, // #1553
  {12,  2}, // #1554
  {13,  2}, // #1555
  {14,  2}, // #1556
  {17,  1}, // #1557
  {19,  3}, // #1558
  {20,  2}, // #1559
  {21,  1}, // #1560
  {22,  3}, // #1561
  {23,  4}, // #1562
  { 2, 14}, // #1563
  { 3,  2}, // #1564
  {11,  2}, // #1565
  {12,  2}, // #1566
  {13,  2}, // #1567
  {14,  2}, // #1568
  {19,  3}, // #1569
  {20,  2}, // #1570
  {22,  3}, // #1571
  {23,  3}, // #1572
  {14,  1}, // #1573
  {17,  1}, // #1574
  {20,  1}, // #1575
  {21,  2}, // #1576
  {22,  3}, // #1577
  {23,  5}, // #1578
  { 4,  2}, // #1579
  {11,  2}, // #1580
  {14,  3}, // #1581
  {15,  3}, // #1582
  {16,  2}, // #1583
  {17,  1}, // #1584
  {19,  3}, // #1585
  {20,  3}, // #1586
  {21,  2}, // #1587
  {22,  9}, // #1588
  {23, 11}, // #1589
  { 3,  2}, // #1590
  { 4,  1}, // #1591
  { 9,  4}, // #1592
  {11,  3}, // #1593
  {12,  2}, // #1594
  {13,  2}, // #1595
  {14,  6}, // #1596
  {15,  1}, // #1597
  {16,  5}, // #1598
  {18,  4}, // #1599
  {19,  3}, // #1600
  {20,  6}, // #1601
  {22, 12}, // #1602
  {23, 12}, // #1603
  {17,  1}, // #1604
  {21,  1}, // #1605
  {22,  2}, // #1606
  {23,  3}, // #1607
  { 9,  1}, // #1608
  {14,  1}, // #1609
  {16,  1}, // #1610
  {18,  1}, // #1611
  {20,  1}, // #1612
  {22,  3}, // #1613
  {23,  3}, // #1614
  { 7,  1}, // #1615
  {12,  1}, // #1616
  {17,  1}, // #1617
  {21,  2}, // #1618
  {22,  3}, // #1619
  {23,  6}, // #1620
  {14,  1}, // #1621
  {20,  1}, // #1622
  {22,  2}, // #1623
  {23,  2}, // #1624
  { 3,  1}, // #1625
  {11,  2}, // #1626
  {12,  1}, // #1627
  {13,  1}, // #1628
  {14,  1}, // #1629
  {17,  1}, // #1630
  {19,  2}, // #1631
  {20,  1}, // #1632
  {21,  1}, // #1633
  {22,  2}, // #1634
  {23,  3}, // #1635
  {14,  2}, // #1636
  {20,  2}, // #1637
  {22, 11}, // #1638
  {23, 11}, // #1639
  { 7,  1}, // #1640
  { 9,  1}, // #1641
  {12,  1}, // #1642
  {14,  1}, // #1643
  {16,  1}, // #1644
  {18,  1}, // #1645
  {20,  1}, // #1646
  {21,  1}, // #1647
  {22,  1}, // #1648
  {23,  3}, // #1649
  { 3,  1}, // #1650
  { 4,  1}, // #1651
  {11,  2}, // #1652
  {12,  1}, // #1653
  {13,  1}, // #1654
  {14,  1}, // #1655
  {15,  1}, // #1656
  {16,  1}, // #1657
  {19,  2}, // #1658
  {20,  1}, // #1659
  {22,  2}, // #1660
  {23,  2}, // #1661
  { 9,  1}, // #1662
  {14,  1}, // #1663
  {16,  1}, // #1664
  {18,  1}, // #1665
  {20,  1}, // #1666
  {22,  5}, // #1667
  {23,  5}, // #1668
  { 7,  1}, // #1669
  {12,  1}, // #1670
  {14,  4}, // #1671
  {15,  2}, // #1672
  {17,  1}, // #1673
  {19,  2}, // #1674
  {20,  4}, // #1675
  {21,  2}, // #1676
  {22, 11}, // #1677
  {23, 14}, // #1678
  { 9,  2}, // #1679
  {14,  4}, // #1680
  {15,  1}, // #1681
  {16,  2}, // #1682
  {18,  2}, // #1683
  {19,  1}, // #1684
  {20,  4}, // #1685
  {22,  7}, // #1686
  {23,  7}, // #1687
  { 9,  1}, // #1688
  {14,  1}, // #1689
  {16,  1}, // #1690
  {18,  1}, // #1691
  {20,  1}, // #1692
  {22,  6}, // #1693
  {23,  6}, // #1694
  { 3,  2}, // #1695
  { 7,  1}, // #1696
  { 8,  4}, // #1697
  {11,  2}, // #1698
  {12,  3}, // #1699
  {13,  6}, // #1700
  {14,  6}, // #1701
  {15,  4}, // #1702
  {17,  1}, // #1703
  {18,  4}, // #1704
  {19,  6}, // #1705
  {20, 10}, // #1706
  {21,  2}, // #1707
  {22, 16}, // #1708
  {23, 19}, // #1709
  { 8,  2}, // #1710
  {13,  2}, // #1711
  {15,  2}, // #1712
  {18,  2}, // #1713
  {19,  2}, // #1714
  {20,  2}, // #1715
  {22, 22}, // #1716
  {23, 22}, // #1717
  { 7,  1}, // #1718
  { 8,  1}, // #1719
  { 9,  1}, // #1720
  {12,  1}, // #1721
  {13,  1}, // #1722
  {14,  2}, // #1723
  {15,  1}, // #1724
  {16,  1}, // #1725
  {17,  1}, // #1726
  {18,  2}, // #1727
  {19,  1}, // #1728
  {20,  3}, // #1729
  {21,  2}, // #1730
  {22,  5}, // #1731
  {23,  8}, // #1732
  { 8,  6}, // #1733
  {11,  3}, // #1734
  {13,  6}, // #1735
  {15,  6}, // #1736
  {18,  6}, // #1737
  {19,  9}, // #1738
  {20,  6}, // #1739
  {22, 15}, // #1740
  {23, 15}, // #1741
  { 8,  1}, // #1742
  { 9,  5}, // #1743
  {13,  1}, // #1744
  {14,  9}, // #1745
  {15,  1}, // #1746
  {16,  5}, // #1747
  {17,  2}, // #1748
  {18,  6}, // #1749
  {19,  1}, // #1750
  {20, 10}, // #1751
  {21,  3}, // #1752
  {22, 20}, // #1753
  {23, 23}, // #1754
  { 8,  1}, // #1755
  { 9,  5}, // #1756
  {13,  1}, // #1757
  {14,  9}, // #1758
  {15,  1}, // #1759
  {16,  5}, // #1760
  {17,  3}, // #1761
  {18,  6}, // #1762
  {19,  1}, // #1763
  {20, 10}, // #1764
  {21,  3}, // #1765
  {22, 20}, // #1766
  {23, 23}, // #1767
  { 8,  1}, // #1768
  { 9,  1}, // #1769
  {13,  1}, // #1770
  {14,  2}, // #1771
  {15,  1}, // #1772
  {16,  1}, // #1773
  {18,  2}, // #1774
  {19,  1}, // #1775
  {20,  3}, // #1776
  {22,  8}, // #1777
  {23,  8}, // #1778
  { 3,  4}, // #1779
  { 9,  2}, // #1780
  {11,  4}, // #1781
  {12,  4}, // #1782
  {13,  5}, // #1783
  {14,  8}, // #1784
  {15,  1}, // #1785
  {16,  2}, // #1786
  {17, 33}, // #1787
  {18,  2}, // #1788
  {19,  6}, // #1789
  {20,  9}, // #1790
  {21, 33}, // #1791
  {22, 57}, // #1792
  {23, 90}, // #1793
  { 9,  1}, // #1794
  {14,  1}, // #1795
  {16,  1}, // #1796
  {17,  1}, // #1797
  {18,  1}, // #1798
  {20,  1}, // #1799
  {21,  1}, // #1800
  {22,  2}, // #1801
  {23,  3}, // #1802
  { 3,  1}, // #1803
  {11,  1}, // #1804
  {12,  1}, // #1805
  {13,  1}, // #1806
  {14,  1}, // #1807
  {19,  1}, // #1808
  {20,  1}, // #1809
  {22,  2}, // #1810
  {23,  2}, // #1811
  {11,  1}, // #1812
  {19,  2}, // #1813
  {22,  2}, // #1814
  {23,  2}, // #1815
  {14,  1}, // #1816
  {20,  1}, // #1817
  {22,  3}, // #1818
  {23,  3}, // #1819
  { 4,  2}, // #1820
  {11,  2}, // #1821
  {14,  3}, // #1822
  {15,  3}, // #1823
  {16,  2}, // #1824
  {19,  3}, // #1825
  {20,  3}, // #1826
  {22, 10}, // #1827
  {23, 10}, // #1828
  { 7,  1}, // #1829
  {12,  1}, // #1830
  {21,  1}, // #1831
  {22,  1}, // #1832
  {23,  3}, // #1833
  { 7,  1}, // #1834
  {12,  1}, // #1835
  {14,  1}, // #1836
  {20,  1}, // #1837
  {21,  1}, // #1838
  {22,  2}, // #1839
  {23,  4}, // #1840
  { 7,  1}, // #1841
  { 9,  1}, // #1842
  {12,  1}, // #1843
  {14,  1}, // #1844
  {16,  1}, // #1845
  {18,  1}, // #1846
  {20,  1}, // #1847
  {21,  1}, // #1848
  {22,  2}, // #1849
  {23,  4}, // #1850
  { 7,  1}, // #1851
  {12,  1}, // #1852
  {21,  1}, // #1853
  {22,  4}, // #1854
  {23,  6}, // #1855
  { 9,  1}, // #1856
  {14,  1}, // #1857
  {16,  1}, // #1858
  {18,  1}, // #1859
  {20,  1}, // #1860
  {22,  2}, // #1861
  {23,  2}, // #1862
  { 9,  1}, // #1863
  {14,  1}, // #1864
  {16,  1}, // #1865
  {17,  1}, // #1866
  {18,  1}, // #1867
  {20,  1}, // #1868
  {21,  1}, // #1869
  {22,  1}, // #1870
  {23,  2}, // #1871
  { 3,  1}, // #1872
  { 7,  1}, // #1873
  {11,  1}, // #1874
  {12,  2}, // #1875
  {13,  1}, // #1876
  {14,  1}, // #1877
  {19,  1}, // #1878
  {20,  1}, // #1879
  {21,  1}, // #1880
  {22,  1}, // #1881
  {23,  3}, // #1882
  { 4,  1}, // #1883
  { 9,  1}, // #1884
  {11,  1}, // #1885
  {14,  2}, // #1886
  {15,  1}, // #1887
  {16,  2}, // #1888
  {18,  1}, // #1889
  {19,  1}, // #1890
  {20,  2}, // #1891
  {22,  4}, // #1892
  {23,  4}, // #1893
  { 7,  1}, // #1894
  { 9,  1}, // #1895
  {12,  1}, // #1896
  {14,  1}, // #1897
  {16,  1}, // #1898
  {17,  1}, // #1899
  {18,  1}, // #1900
  {20,  1}, // #1901
  {21,  2}, // #1902
  {22,  2}, // #1903
  {23,  5}, // #1904
  { 7,  1}, // #1905
  {12,  1}, // #1906
  {14,  2}, // #1907
  {17,  1}, // #1908
  {20,  2}, // #1909
  {21,  2}, // #1910
  {22,  2}, // #1911
  {23,  5}, // #1912
  { 7,  1}, // #1913
  {12,  1}, // #1914
  {17,  1}, // #1915
  {21,  2}, // #1916
  {22,  2}, // #1917
  {23,  5}, // #1918
  { 3,  1}, // #1919
  { 4,  1}, // #1920
  {11,  2}, // #1921
  {12,  1}, // #1922
  {13,  1}, // #1923
  {14,  1}, // #1924
  {15,  1}, // #1925
  {16,  1}, // #1926
  {17,  1}, // #1927
  {19,  2}, // #1928
  {20,  1}, // #1929
  {21,  1}, // #1930
  {22,  2}, // #1931
  {23,  3}, // #1932
  { 8,  1}, // #1933
  { 9,  1}, // #1934
  {13,  1}, // #1935
  {14,  1}, // #1936
  {15,  1}, // #1937
  {16,  1}, // #1938
  {18,  2}, // #1939
  {19,  1}, // #1940
  {20,  2}, // #1941
  {22,  2}, // #1942
  {23,  2}, // #1943
  {14,  1}, // #1944
  {17,  1}, // #1945
  {20,  1}, // #1946
  {21,  1}, // #1947
  {22,  4}, // #1948
  {23,  5}, // #1949
  { 9,  1}, // #1950
  {14,  1}, // #1951
  {16,  1}, // #1952
  {18,  1}, // #1953
  {20,  1}, // #1954
  {22,  1}, // #1955
  {23,  1}, // #1956
  { 7,  1}, // #1957
  {12,  1}, // #1958
  {15,  1}, // #1959
  {19,  1}, // #1960
  {21,  1}, // #1961
  {22,  1}, // #1962
  {23,  3}, // #1963
  {14,  2}, // #1964
  {20,  2}, // #1965
  {22,  2}, // #1966
  {23,  2}, // #1967
  { 8,  2}, // #1968
  {13,  2}, // #1969
  {15,  2}, // #1970
  {18,  2}, // #1971
  {19,  2}, // #1972
  {20,  2}, // #1973
  {22,  3}, // #1974
  {23,  3}, // #1975
  { 8,  1}, // #1976
  {13,  1}, // #1977
  {15,  1}, // #1978
  {17,  1}, // #1979
  {18,  1}, // #1980
  {19,  2}, // #1981
  {20,  1}, // #1982
  {21,  1}, // #1983
  {22,  2}, // #1984
  {23,  3}, // #1985
  { 4,  2}, // #1986
  { 9,  2}, // #1987
  {11,  2}, // #1988
  {14,  2}, // #1989
  {15,  2}, // #1990
  {16,  4}, // #1991
  {17,  1}, // #1992
  {18,  2}, // #1993
  {19,  2}, // #1994
  {20,  2}, // #1995
  {21,  1}, // #1996
  {22,  7}, // #1997
  {23,  8}, // #1998
  { 4,  1}, // #1999
  { 9,  2}, // #2000
  {11,  1}, // #2001
  {14,  2}, // #2002
  {15,  1}, // #2003
  {16,  3}, // #2004
  {17,  1}, // #2005
  {18,  2}, // #2006
  {19,  1}, // #2007
  {20,  2}, // #2008
  {21,  1}, // #2009
  {22,  4}, // #2010
  {23,  5}, // #2011
  { 4,  1}, // #2012
  { 9,  1}, // #2013
  {11,  1}, // #2014
  {14,  2}, // #2015
  {15,  1}, // #2016
  {16,  2}, // #2017
  {18,  1}, // #2018
  {19,  1}, // #2019
  {20,  2}, // #2020
  {22,  3}, // #2021
  {23,  3}, // #2022
  {14,  1}, // #2023
  {20,  1}, // #2024
  {22,  5}, // #2025
  {23,  5}, // #2026
  { 4,  1}, // #2027
  {11,  1}, // #2028
  {14,  4}, // #2029
  {15,  2}, // #2030
  {16,  1}, // #2031
  {17,  1}, // #2032
  {19,  2}, // #2033
  {20,  4}, // #2034
  {21,  2}, // #2035
  {22,  8}, // #2036
  {23, 10}, // #2037
  { 4,  2}, // #2038
  {11,  2}, // #2039
  {14,  2}, // #2040
  {15,  2}, // #2041
  {16,  2}, // #2042
  {19,  2}, // #2043
  {20,  2}, // #2044
  {22,  7}, // #2045
  {23,  7}, // #2046
  { 4,  1}, // #2047
  {11,  1}, // #2048
  {14,  4}, // #2049
  {15,  2}, // #2050
  {16,  1}, // #2051
  {19,  2}, // #2052
  {20,  4}, // #2053
  {22,  9}, // #2054
  {23,  9}, // #2055
  { 9,  3}, // #2056
  {14,  3}, // #2057
  {16,  3}, // #2058
  {17,  1}, // #2059
  {18,  3}, // #2060
  {20,  3}, // #2061
  {21,  1}, // #2062
  {22, 18}, // #2063
  {23, 19}, // #2064
  { 7,  1}, // #2065
  { 9,  5}, // #2066
  {12,  1}, // #2067
  {14,  5}, // #2068
  {16,  5}, // #2069
  {17,  1}, // #2070
  {18,  5}, // #2071
  {20,  5}, // #2072
  {21,  2}, // #2073
  {22, 24}, // #2074
  {23, 27}, // #2075
  { 7,  1}, // #2076
  { 9,  6}, // #2077
  {12,  1}, // #2078
  {14,  6}, // #2079
  {16,  6}, // #2080
  {17,  1}, // #2081
  {18,  6}, // #2082
  {20,  6}, // #2083
  {21,  2}, // #2084
  {22, 25}, // #2085
  {23, 28}, // #2086
  { 3,  2}, // #2087
  {11,  4}, // #2088
  {12,  2}, // #2089
  {13,  3}, // #2090
  {14, 12}, // #2091
  {17,  8}, // #2092
  {19,  7}, // #2093
  {20, 13}, // #2094
  {21,  8}, // #2095
  {22, 56}, // #2096
  {23, 64}, // #2097
  { 3,  4}, // #2098
  { 9,  4}, // #2099
  {11,  4}, // #2100
  {12,  4}, // #2101
  {13,  5}, // #2102
  {14, 10}, // #2103
  {15,  1}, // #2104
  {16,  4}, // #2105
  {17, 31}, // #2106
  {18,  4}, // #2107
  {19,  6}, // #2108
  {20, 11}, // #2109
  {21, 31}, // #2110
  {22, 57}, // #2111
  {23, 88}, // #2112
  { 3,  9}, // #2113
  { 4,  9}, // #2114
  { 7, 11}, // #2115
  { 8,  8}, // #2116
  { 9,  1}, // #2117
  {11, 18}, // #2118
  {12, 20}, // #2119
  {13, 17}, // #2120
  {14, 31}, // #2121
  {15, 17}, // #2122
  {16, 10}, // #2123
  {18,  9}, // #2124
  {19, 26}, // #2125
  {20, 39}, // #2126
  {21, 11}, // #2127
  {22, 78}, // #2128
  {23, 100}, // #2129
  { 7,  1}, // #2130
  { 8,  5}, // #2131
  {12,  1}, // #2132
  {13,  5}, // #2133
  {15,  5}, // #2134
  {17,  2}, // #2135
  {18,  5}, // #2136
  {19,  5}, // #2137
  {20,  5}, // #2138
  {21,  2}, // #2139
  {22,  6}, // #2140
  {23,  9}, // #2141
  { 9,  1}, // #2142
  {14,  1}, // #2143
  {16,  1}, // #2144
  {17,  1}, // #2145
  {18,  1}, // #2146
  {20,  1}, // #2147
  {21,  1}, // #2148
  {22, 17}, // #2149
  {23, 18}, // #2150
  { 7,  1}, // #2151
  { 8,  3}, // #2152
  {12,  1}, // #2153
  {13,  3}, // #2154
  {15,  3}, // #2155
  {17,  2}, // #2156
  {18,  3}, // #2157
  {19,  3}, // #2158
  {20,  3}, // #2159
  {21,  2}, // #2160
  {22,  4}, // #2161
  {23,  7}, // #2162
  { 7,  1}, // #2163
  { 8,  3}, // #2164
  {12,  1}, // #2165
  {13,  3}, // #2166
  {15,  3}, // #2167
  {17,  4}, // #2168
  {18,  3}, // #2169
  {19,  3}, // #2170
  {20,  3}, // #2171
  {21,  4}, // #2172
  {22,  4}, // #2173
  {23,  9}, // #2174
  { 7,  1}, // #2175
  { 8,  4}, // #2176
  {12,  1}, // #2177
  {13,  4}, // #2178
  {15,  4}, // #2179
  {17,  8}, // #2180
  {18,  4}, // #2181
  {19,  4}, // #2182
  {20,  4}, // #2183
  {21,  8}, // #2184
  {22,  5}, // #2185
  {23, 14}, // #2186
  {14,  1}, // #2187
  {17,  1}, // #2188
  {20,  1}, // #2189
  {21,  1}, // #2190
  {22,  2}, // #2191
  {23,  3}, // #2192
  { 9,  1}, // #2193
  {16,  1}, // #2194
  { 3,  3}, // #2195
  {11,  1}, // #2196
  {12,  2}, // #2197
  {14,  1}, // #2198
  { 8,  1}, // #2199
  { 9,  1}, // #2200
  {12,  1}, // #2201
  {14,  1}, // #2202
  {15,  1}, // #2203
  { 8,  2}, // #2204
  { 9,  2}, // #2205
  {12,  2}, // #2206
  {14,  2}, // #2207
  {15,  2}, // #2208
  { 3,  2}, // #2209
  {11,  1}, // #2210
  {12,  2}, // #2211
  {14,  1}, // #2212
  { 3,  2}, // #2213
  {11,  1}, // #2214
  {12,  1}, // #2215
  { 3,  1}, // #2216
  {11,  1}, // #2217
  {12,  2}, // #2218
  {14,  1}, // #2219
  { 5,  1}, // #2220
  { 7,  1}, // #2221
  { 9,  1}, // #2222
  {10,  1}, // #2223
  {11,  1}, // #2224
  {12,  1}, // #2225
  { 7,  1}, // #2226
  { 9,  2}, // #2227
  {11,  1}, // #2228
  {12,  1}, // #2229
  {16,  1}, // #2230
  {19,  1}, // #2231
  { 7,  1}, // #2232
  { 9,  2}, // #2233
  {16,  1}, // #2234
  {19,  1}, // #2235
  { 7,  1}, // #2236
  { 9,  1}, // #2237
  {11,  1}, // #2238
  {12,  1}, // #2239
  {19,  1}, // #2240
  { 7,  1}, // #2241
  { 9,  1}, // #2242
  {19,  1}, // #2243
  { 9,  4}, // #2244
  {10,  4}, // #2245
  {11,  1}, // #2246
  {12,  1}, // #2247
  { 3,  8}, // #2248
  {11,  1}, // #2249
  {12,  1}, // #2250
  { 1,  1}, // #2251
  { 3,  1}, // #2252
  { 5,  1}, // #2253
  { 7,  1}, // #2254
  { 9,  1}, // #2255
  {10,  1}, // #2256
  {11,  1}, // #2257
  {12,  1}, // #2258
  { 3,  4}, // #2259
  {11,  1}, // #2260
  {12,  1}, // #2261
  { 8,  1}, // #2262
  { 9,  1}, // #2263
  {11,  1}, // #2264
  {12,  1}, // #2265
  {15,  1}, // #2266
  { 8,  1}, // #2267
  { 9,  1}, // #2268
  {15,  1}, // #2269
  { 1,  1}, // #2270
  { 3,  1}, // #2271
  { 5,  1}, // #2272
  { 7,  1}, // #2273
  { 8,  1}, // #2274
  { 9,  2}, // #2275
  {10,  1}, // #2276
  {11,  1}, // #2277
  {12,  1}, // #2278
  {15,  1}, // #2279
  { 1,  1}, // #2280
  { 3,  1}, // #2281
  { 5,  1}, // #2282
  { 7,  1}, // #2283
  { 8,  1}, // #2284
  { 9,  2}, // #2285
  {10,  1}, // #2286
  {15,  1}, // #2287
  { 8,  1}, // #2288
  { 9,  1}, // #2289
  {11,  1}, // #2290
  {12,  1}, // #2291
  {15,  2}, // #2292
  { 8,  1}, // #2293
  { 9,  1}, // #2294
  {15,  2}, // #2295
  { 2,  1}, // #2296
  { 3,  1}, // #2297
  { 4, 17}, // #2298
  {11,  1}, // #2299
  {12,  1}, // #2300
  { 2,  1}, // #2301
  { 3,  1}, // #2302
  { 4, 25}, // #2303
  {11,  1}, // #2304
  {12,  1}, // #2305
  { 2,  1}, // #2306
  { 3,  1}, // #2307
  { 4, 41}, // #2308
  {11,  1}, // #2309
  {12,  1}, // #2310
  { 2,  1}, // #2311
  { 3,  1}, // #2312
  { 4, 12}, // #2313
  {11,  1}, // #2314
  {12,  1}, // #2315
  { 6, 19}, // #2316
  { 8,  1}, // #2317
  { 9,  1}, // #2318
  {10, 19}, // #2319
  {11,  1}, // #2320
  {12,  1}, // #2321
  { 5,  3}, // #2322
  { 6,  3}, // #2323
  { 8,  1}, // #2324
  { 9,  1}, // #2325
  {10,  6}, // #2326
  {11,  1}, // #2327
  {12,  1}, // #2328
  { 9,  1}, // #2329
  {11,  1}, // #2330
  {12,  1}, // #2331
  {16,  1}, // #2332
  { 2,  1}, // #2333
  { 3,  1}, // #2334
  {11,  1}, // #2335
  {12,  1}, // #2336
  {13,  3}, // #2337
  { 2,  1}, // #2338
  { 3,  1}, // #2339
  {13,  3}, // #2340
  { 2,  1}, // #2341
  { 3,  1}, // #2342
  {11,  1}, // #2343
  {12,  1}, // #2344
  {13,  1}, // #2345
  { 2,  1}, // #2346
  { 3,  1}, // #2347
  {11,  1}, // #2348
  {12,  1}, // #2349
  {13,  2}, // #2350
  { 2,  1}, // #2351
  { 3,  1}, // #2352
  {13,  1}, // #2353
  { 2,  1}, // #2354
  { 3,  1}, // #2355
  {13,  2}, // #2356
  { 2,  1}, // #2357
  { 3,  1}, // #2358
  {11,  1}, // #2359
  {12,  1}, // #2360
  {13,  4}, // #2361
  { 2,  1}, // #2362
  { 3,  1}, // #2363
  {13,  4}, // #2364
  { 7,  1}, // #2365
  { 9,  1}, // #2366
  {11,  1}, // #2367
  {12,  1}, // #2368
  {19,  2}, // #2369
  { 7,  1}, // #2370
  { 9,  1}, // #2371
  {19,  2}, // #2372
  { 6,  2}, // #2373
  { 8,  1}, // #2374
  { 9,  1}, // #2375
  {10,  2}, // #2376
  {11,  1}, // #2377
  {12,  1}, // #2378
  { 6,  1}, // #2379
  { 8,  1}, // #2380
  { 9,  1}, // #2381
  {10,  1}, // #2382
  {11,  1}, // #2383
  {12,  1}, // #2384
  { 2,  5}, // #2385
  { 3,  5}, // #2386
  {11,  1}, // #2387
  {12,  1}, // #2388
  {13,  2}, // #2389
  { 2,  5}, // #2390
  { 3,  5}, // #2391
  {13,  2}, // #2392
  { 2,  5}, // #2393
  { 3,  5}, // #2394
  {11,  1}, // #2395
  {12,  1}, // #2396
  {13,  4}, // #2397
  { 2,  5}, // #2398
  { 3,  5}, // #2399
  {13,  4}, // #2400
  { 9,  4}, // #2401
  {11,  1}, // #2402
  {12,  1}, // #2403
  {16,  4}, // #2404
  { 9,  4}, // #2405
  {16,  4}, // #2406
  { 1,  1}, // #2407
  { 3,  1}, // #2408
  { 5,  1}, // #2409
  { 8,  1}, // #2410
  { 9,  1}, // #2411
  {10,  1}, // #2412
  {11,  3}, // #2413
  {12,  5}, // #2414
  {14,  2}, // #2415
  {16, 10}, // #2416
  {18,  4}, // #2417
  { 1,  1}, // #2418
  { 3,  1}, // #2419
  { 5,  1}, // #2420
  { 8,  1}, // #2421
  { 9,  1}, // #2422
  {10,  1}, // #2423
  {11,  2}, // #2424
  {12,  4}, // #2425
  {14,  2}, // #2426
  {16, 10}, // #2427
  {18,  4}, // #2428
  { 1,  1}, // #2429
  { 3,  1}, // #2430
  { 5,  1}, // #2431
  { 7,  1}, // #2432
  { 8,  2}, // #2433
  { 9,  3}, // #2434
  {10,  1}, // #2435
  {11,  1}, // #2436
  {12,  1}, // #2437
  {16,  2}, // #2438
  {18,  2}, // #2439
  { 1,  1}, // #2440
  { 3,  1}, // #2441
  { 5,  1}, // #2442
  { 7,  1}, // #2443
  { 8,  2}, // #2444
  { 9,  3}, // #2445
  {10,  1}, // #2446
  {16,  2}, // #2447
  {18,  2}, // #2448
  { 7,  2}, // #2449
  { 9,  3}, // #2450
  {11,  1}, // #2451
  {12,  1}, // #2452
  {16,  1}, // #2453
  {19,  2}, // #2454
  { 7,  2}, // #2455
  { 9,  3}, // #2456
  {16,  1}, // #2457
  {19,  2}, // #2458
  { 9,  1}, // #2459
  {11,  1}, // #2460
  {12,  1}, // #2461
  {16,  4}, // #2462
  { 9,  1}, // #2463
  {16,  4}, // #2464
  { 3,  1}, // #2465
  {12,  1}, // #2466
  {14,  1}, // #2467
  { 3, 22}, // #2468
  {11,  1}, // #2469
  {12,  1}, // #2470
  { 6, 27}, // #2471
  { 8,  1}, // #2472
  { 9,  1}, // #2473
  {10, 27}, // #2474
  {11,  1}, // #2475
  {12,  1}, // #2476
  { 6, 21}, // #2477
  { 8,  1}, // #2478
  { 9,  1}, // #2479
  {10, 21}, // #2480
  {11,  1}, // #2481
  {12,  1}, // #2482
  { 6, 35}, // #2483
  { 8,  1}, // #2484
  { 9,  1}, // #2485
  {10, 35}, // #2486
  { 5,  2}, // #2487
  { 7,  2}, // #2488
  { 9,  2}, // #2489
  {10,  2}, // #2490
  {11,  2}, // #2491
  {12,  2}, // #2492
  { 9,  6}, // #2493
  {10,  6}, // #2494
  {11,  2}, // #2495
  {12,  2}, // #2496
  { 9,  2}, // #2497
  {10,  2}, // #2498
  {11,  1}, // #2499
  {12,  1}, // #2500
  { 8,  2}, // #2501
  { 9,  2}, // #2502
  {11,  2}, // #2503
  {12,  2}, // #2504
  {15,  2}, // #2505
  { 8,  2}, // #2506
  { 9,  2}, // #2507
  {15,  2}, // #2508
  { 8,  2}, // #2509
  { 9,  2}, // #2510
  {10,  4}, // #2511
  {11,  2}, // #2512
  {12,  2}, // #2513
  {15,  2}, // #2514
  { 8,  2}, // #2515
  { 9,  2}, // #2516
  {10,  4}, // #2517
  {15,  2}, // #2518
  { 8,  2}, // #2519
  { 9,  2}, // #2520
  {10,  2}, // #2521
  {12,  1}, // #2522
  {14,  1}, // #2523
  {15,  2}, // #2524
  { 8,  2}, // #2525
  { 9,  2}, // #2526
  {10,  2}, // #2527
  {15,  2}, // #2528
  { 6, 38}, // #2529
  { 8,  2}, // #2530
  { 9,  2}, // #2531
  {10, 38}, // #2532
  {11,  2}, // #2533
  {12,  2}, // #2534
  { 5,  6}, // #2535
  { 6,  6}, // #2536
  { 8,  2}, // #2537
  { 9,  2}, // #2538
  {10, 12}, // #2539
  {11,  2}, // #2540
  {12,  2}, // #2541
  { 3,  4}, // #2542
  { 5,  1}, // #2543
  { 7,  1}, // #2544
  { 8,  4}, // #2545
  { 9,  5}, // #2546
  {10,  1}, // #2547
  {11,  4}, // #2548
  {12,  8}, // #2549
  {14,  4}, // #2550
  {15,  4}, // #2551
  { 9,  4}, // #2552
  {10,  4}, // #2553
  {11,  2}, // #2554
  {12,  2}, // #2555
  { 3,  2}, // #2556
  { 5,  1}, // #2557
  { 7,  1}, // #2558
  { 8,  2}, // #2559
  { 9,  3}, // #2560
  {10,  1}, // #2561
  {11,  2}, // #2562
  {12,  4}, // #2563
  {14,  2}, // #2564
  {15,  2}, // #2565
  { 3,  8}, // #2566
  { 5,  1}, // #2567
  { 7,  1}, // #2568
  { 8, 10}, // #2569
  { 9, 11}, // #2570
  {10,  1}, // #2571
  {11,  8}, // #2572
  {12, 16}, // #2573
  {14,  8}, // #2574
  {15, 10}, // #2575
  { 3,  4}, // #2576
  { 5,  1}, // #2577
  { 7,  1}, // #2578
  { 8,  5}, // #2579
  { 9,  6}, // #2580
  {10,  1}, // #2581
  {11,  4}, // #2582
  {12,  8}, // #2583
  {14,  4}, // #2584
  {15,  5}, // #2585
  { 9,  2}, // #2586
  {16,  2}, // #2587
  { 6,  4}, // #2588
  { 8,  2}, // #2589
  { 9,  2}, // #2590
  {10,  4}, // #2591
  {11,  2}, // #2592
  {12,  2}, // #2593
  { 6,  2}, // #2594
  { 8,  2}, // #2595
  { 9,  2}, // #2596
  {10,  2}, // #2597
  {11,  2}, // #2598
  {12,  2}, // #2599
  { 9,  2}, // #2600
  {10,  6}, // #2601
  {11,  2}, // #2602
  {12,  2}, // #2603
  { 9,  1}, // #2604
  {10,  4}, // #2605
  {11,  1}, // #2606
  {12,  1}, // #2607
  { 9,  2}, // #2608
  {12,  2}, // #2609
  {14,  2}, // #2610
  {16,  4}, // #2611
  { 9,  4}, // #2612
  {11,  2}, // #2613
  {12,  2}, // #2614
  {16,  4}, // #2615
  { 9,  1}, // #2616
  {12,  1}, // #2617
  {14,  1}, // #2618
  {16,  4}, // #2619
  { 9,  2}, // #2620
  {11,  1}, // #2621
  {12,  1}, // #2622
  {16,  2}, // #2623
  { 1,  1}, // #2624
  { 3,  1}, // #2625
  { 5,  2}, // #2626
  { 9,  2}, // #2627
  {10,  4}, // #2628
  {11,  2}, // #2629
  {12,  2}, // #2630
  { 6, 54}, // #2631
  { 8,  2}, // #2632
  { 9,  2}, // #2633
  {10, 54}, // #2634
  {11,  2}, // #2635
  {12,  2}, // #2636
  { 6, 42}, // #2637
  { 8,  2}, // #2638
  { 9,  2}, // #2639
  {10, 42}, // #2640
  {11,  2}, // #2641
  {12,  2}, // #2642
  { 3,  2}, // #2643
  {11, 16}, // #2644
  {12, 32}, // #2645
  {14, 16}, // #2646
  { 9,  2}, // #2647
  {10,  4}, // #2648
  {11,  1}, // #2649
  {12,  1}, // #2650
  { 3, 42}, // #2651
  { 5,  1}, // #2652
  { 7,  1}, // #2653
  { 8,  2}, // #2654
  { 9,  3}, // #2655
  {10,  1}, // #2656
  {11,  2}, // #2657
  {12, 18}, // #2658
  {14, 16}, // #2659
  {15,  2}, // #2660
  { 3,  3}, // #2661
  {11, 19}, // #2662
  {12, 38}, // #2663
  {14, 19}, // #2664
  { 3,  6}, // #2665
  {11, 38}, // #2666
  {12, 76}, // #2667
  {14, 38}, // #2668
  { 3,  3}, // #2669
  {11, 16}, // #2670
  {12, 32}, // #2671
  {14, 16}, // #2672
  { 3,  3}, // #2673
  {11, 17}, // #2674
  {12, 34}, // #2675
  {14, 17}, // #2676
  { 3,  6}, // #2677
  {11,  1}, // #2678
  {12,  2}, // #2679
  {14,  1}, // #2680
  { 3,  1}, // #2681
  {11, 19}, // #2682
  {12, 38}, // #2683
  {14, 19}, // #2684
  { 2,  1}, // #2685
  { 3,  1}, // #2686
  {12,  1}, // #2687
  {14,  1}, // #2688
  {13,  1}, // #2689
  {19,  1}, // #2690
  {20,  1}, // #2691
  {22,  1}, // #2692
  {23,  1}, // #2693
  { 3,  3}, // #2694
  { 8,  6}, // #2695
  {11,  3}, // #2696
  {12,  3}, // #2697
  {13,  9}, // #2698
  {14,  3}, // #2699
  {15,  6}, // #2700
  {17,  1}, // #2701
  {18,  6}, // #2702
  {19, 10}, // #2703
  {20,  9}, // #2704
  {21,  1}, // #2705
  {22, 10}, // #2706
  {23, 11}, // #2707
  { 3,  3}, // #2708
  { 8,  6}, // #2709
  {11,  3}, // #2710
  {12,  3}, // #2711
  {13,  9}, // #2712
  {14,  3}, // #2713
  {15,  6}, // #2714
  {18,  6}, // #2715
  {19, 11}, // #2716
  {20,  9}, // #2717
  {22, 11}, // #2718
  {23, 11}, // #2719
  {11,  2}, // #2720
  {17,  1}, // #2721
  {19,  2}, // #2722
  {21,  1}, // #2723
  {22,  2}, // #2724
  {23,  3}, // #2725
  { 1, 10}, // #2726
  { 3,  1}, // #2727
  {11,  1}, // #2728
  {12,  1}, // #2729
  {13,  1}, // #2730
  {14,  1}, // #2731
  {17,  1}, // #2732
  {19,  1}, // #2733
  {20,  1}, // #2734
  {21,  1}, // #2735
  {22,  1}, // #2736
  {23,  2}, // #2737
  { 3,  7}, // #2738
  { 4,  2}, // #2739
  { 8,  8}, // #2740
  { 9,  3}, // #2741
  {11,  9}, // #2742
  {12,  7}, // #2743
  {13, 16}, // #2744
  {14, 10}, // #2745
  {15, 10}, // #2746
  {16,  5}, // #2747
  {18, 11}, // #2748
  {19, 18}, // #2749
  {20, 19}, // #2750
  {22, 32}, // #2751
  {23, 32}, // #2752
  { 2,  4}, // #2753
  { 3,  1}, // #2754
  {11,  1}, // #2755
  {12,  1}, // #2756
  {13,  1}, // #2757
  {14,  1}, // #2758
  {17,  1}, // #2759
  {19,  1}, // #2760
  {20,  1}, // #2761
  {21,  1}, // #2762
  {22,  1}, // #2763
  {23,  2}, // #2764
  { 2,  3}, // #2765
  { 3,  1}, // #2766
  {11,  1}, // #2767
  {12,  1}, // #2768
  {13,  1}, // #2769
  {14,  1}, // #2770
  {17,  1}, // #2771
  {19,  1}, // #2772
  {20,  1}, // #2773
  {21,  1}, // #2774
  {22,  1}, // #2775
  {23,  2}, // #2776
  { 8,  1}, // #2777
  {13,  1}, // #2778
  {15,  1}, // #2779
  {17,  1}, // #2780
  {18,  1}, // #2781
  {19,  3}, // #2782
  {20,  1}, // #2783
  {21,  1}, // #2784
  {22,  3}, // #2785
  {23,  4}, // #2786
  { 8,  1}, // #2787
  {13,  1}, // #2788
  {15,  1}, // #2789
  {18,  1}, // #2790
  {19,  3}, // #2791
  {20,  1}, // #2792
  {22,  3}, // #2793
  {23,  3}, // #2794
  { 8,  1}, // #2795
  {13,  1}, // #2796
  {15,  1}, // #2797
  {17,  1}, // #2798
  {18,  1}, // #2799
  {19,  4}, // #2800
  {20,  1}, // #2801
  {21,  1}, // #2802
  {22,  4}, // #2803
  {23,  5}, // #2804
  { 8,  1}, // #2805
  {13,  1}, // #2806
  {15,  1}, // #2807
  {18,  1}, // #2808
  {19,  4}, // #2809
  {20,  1}, // #2810
  {22,  4}, // #2811
  {23,  4}, // #2812
  {13,  9}, // #2813
  {19,  9}, // #2814
  {20,  9}, // #2815
  {22, 10}, // #2816
  {23, 10}, // #2817
  {13,  2}, // #2818
  {19,  2}, // #2819
  {20,  2}, // #2820
  {22,  2}, // #2821
  {23,  2}, // #2822
  { 8,  2}, // #2823
  {13,  2}, // #2824
  {15,  2}, // #2825
  {17,  1}, // #2826
  {18,  2}, // #2827
  {19,  3}, // #2828
  {20,  2}, // #2829
  {21,  1}, // #2830
  {22,  3}, // #2831
  {23,  4}, // #2832
  { 8,  2}, // #2833
  {13,  2}, // #2834
  {15,  2}, // #2835
  {18,  2}, // #2836
  {19,  3}, // #2837
  {20,  2}, // #2838
  {22,  3}, // #2839
  {23,  3}, // #2840
  { 3,  2}, // #2841
  { 8,  4}, // #2842
  {11,  2}, // #2843
  {12,  2}, // #2844
  {13,  6}, // #2845
  {14,  2}, // #2846
  {15,  4}, // #2847
  {17,  1}, // #2848
  {18,  4}, // #2849
  {19,  6}, // #2850
  {20,  6}, // #2851
  {21,  1}, // #2852
  {22,  7}, // #2853
  {23,  8}, // #2854
  { 3,  4}, // #2855
  { 4,  2}, // #2856
  { 8,  4}, // #2857
  { 9,  8}, // #2858
  {11,  6}, // #2859
  {12,  4}, // #2860
  {13,  8}, // #2861
  {14, 26}, // #2862
  {15,  6}, // #2863
  {16, 10}, // #2864
  {18, 12}, // #2865
  {19, 10}, // #2866
  {20, 30}, // #2867
  {22, 66}, // #2868
  {23, 66}, // #2869
  {13,  1}, // #2870
  {17,  1}, // #2871
  {19,  1}, // #2872
  {20,  1}, // #2873
  {21,  1}, // #2874
  {22,  1}, // #2875
  {23,  2}, // #2876
  { 8,  2}, // #2877
  {13,  3}, // #2878
  {15,  2}, // #2879
  {17,  1}, // #2880
  {18,  2}, // #2881
  {19,  3}, // #2882
  {20,  3}, // #2883
  {21,  1}, // #2884
  {22,  3}, // #2885
  {23,  4}, // #2886
  { 8,  2}, // #2887
  {13,  3}, // #2888
  {15,  2}, // #2889
  {18,  2}, // #2890
  {19,  3}, // #2891
  {20,  3}, // #2892
  {22,  3}, // #2893
  {23,  3}, // #2894
  { 8,  1}, // #2895
  {11,  1}, // #2896
  {13,  1}, // #2897
  {15,  1}, // #2898
  {18,  1}, // #2899
  {19,  2}, // #2900
  {20,  1}, // #2901
  {22,  2}, // #2902
  {23,  2}, // #2903
  { 7,  1}, // #2904
  {12,  1}, // #2905
  {14,  3}, // #2906
  {17,  1}, // #2907
  {20,  3}, // #2908
  {21,  2}, // #2909
  {22,  3}, // #2910
  {23,  6}, // #2911
  {14,  3}, // #2912
  {20,  3}, // #2913
  {22,  3}, // #2914
  {23,  3}, // #2915
  { 4,  1}, // #2916
  {11,  1}, // #2917
  {14,  2}, // #2918
  {15,  1}, // #2919
  {16,  1}, // #2920
  {17,  1}, // #2921
  {19,  1}, // #2922
  {20,  2}, // #2923
  {21,  2}, // #2924
  {22,  4}, // #2925
  {23,  6}, // #2926
  { 4,  1}, // #2927
  {11,  1}, // #2928
  {14,  2}, // #2929
  {15,  1}, // #2930
  {16,  1}, // #2931
  {19,  1}, // #2932
  {20,  2}, // #2933
  {22,  4}, // #2934
  {23,  4}, // #2935
  { 2,  6}, // #2936
  { 3,  1}, // #2937
  {11,  1}, // #2938
  {12,  1}, // #2939
  {13,  1}, // #2940
  {14,  1}, // #2941
  {17,  1}, // #2942
  {19,  1}, // #2943
  {20,  1}, // #2944
  {21,  1}, // #2945
  {22,  1}, // #2946
  {23,  2}, // #2947
  { 2,  6}, // #2948
  { 3,  1}, // #2949
  {11,  1}, // #2950
  {12,  1}, // #2951
  {13,  1}, // #2952
  {14,  1}, // #2953
  {19,  1}, // #2954
  {20,  1}, // #2955
  {22,  1}, // #2956
  {23,  1}, // #2957
  { 8,  1}, // #2958
  {11,  1}, // #2959
  {13,  1}, // #2960
  {15,  1}, // #2961
  {17,  1}, // #2962
  {18,  1}, // #2963
  {19,  2}, // #2964
  {20,  1}, // #2965
  {21,  1}, // #2966
  {22,  2}, // #2967
  {23,  3}, // #2968
  {13,  2}, // #2969
  {17,  1}, // #2970
  {19,  2}, // #2971
  {20,  2}, // #2972
  {21,  1}, // #2973
  {22,  2}, // #2974
  {23,  3}, // #2975
  { 7,  1}, // #2976
  { 8,  1}, // #2977
  {11,  1}, // #2978
  {12,  1}, // #2979
  {13,  1}, // #2980
  {15,  1}, // #2981
  {18,  1}, // #2982
  {19,  2}, // #2983
  {20,  1}, // #2984
  {21,  1}, // #2985
  {22,  2}, // #2986
  {23,  4}, // #2987
  { 7,  1}, // #2988
  { 8,  1}, // #2989
  {12,  1}, // #2990
  {13,  2}, // #2991
  {15,  1}, // #2992
  {18,  1}, // #2993
  {19,  2}, // #2994
  {20,  2}, // #2995
  {21,  1}, // #2996
  {22,  2}, // #2997
  {23,  4}, // #2998
  { 8,  1}, // #2999
  {13,  2}, // #3000
  {15,  1}, // #3001
  {18,  1}, // #3002
  {19,  2}, // #3003
  {20,  2}, // #3004
  {22,  2}, // #3005
  {23,  2}, // #3006
  { 2, 16}, // #3007
  { 3,  2}, // #3008
  { 8,  1}, // #3009
  {11,  2}, // #3010
  {12,  2}, // #3011
  {13,  3}, // #3012
  {14,  2}, // #3013
  {15,  1}, // #3014
  {17,  1}, // #3015
  {18,  1}, // #3016
  {19,  3}, // #3017
  {20,  3}, // #3018
  {21,  1}, // #3019
  {22,  3}, // #3020
  {23,  4}, // #3021
  { 2, 16}, // #3022
  { 3,  2}, // #3023
  { 8,  1}, // #3024
  {11,  2}, // #3025
  {12,  2}, // #3026
  {13,  3}, // #3027
  {14,  2}, // #3028
  {15,  1}, // #3029
  {18,  1}, // #3030
  {19,  3}, // #3031
  {20,  3}, // #3032
  {22,  3}, // #3033
  {23,  3}, // #3034
  { 2, 10}, // #3035
  { 3,  2}, // #3036
  { 8,  1}, // #3037
  {11,  2}, // #3038
  {12,  2}, // #3039
  {13,  3}, // #3040
  {14,  2}, // #3041
  {15,  1}, // #3042
  {17,  1}, // #3043
  {18,  1}, // #3044
  {19,  3}, // #3045
  {20,  3}, // #3046
  {21,  1}, // #3047
  {22,  3}, // #3048
  {23,  4}, // #3049
  { 2, 10}, // #3050
  { 3,  2}, // #3051
  { 8,  1}, // #3052
  {11,  2}, // #3053
  {12,  2}, // #3054
  {13,  3}, // #3055
  {14,  2}, // #3056
  {15,  1}, // #3057
  {18,  1}, // #3058
  {19,  3}, // #3059
  {20,  3}, // #3060
  {22,  3}, // #3061
  {23,  3}, // #3062
  { 3,  1}, // #3063
  {11,  1}, // #3064
  {12,  1}, // #3065
  {13,  1}, // #3066
  {14,  1}, // #3067
  {19,  1}, // #3068
  {20,  1}, // #3069
  {21,  1}, // #3070
  {22,  1}, // #3071
  {23,  2}, // #3072
  { 2, 12}, // #3073
  { 3,  1}, // #3074
  {11,  1}, // #3075
  {12,  1}, // #3076
  {13,  1}, // #3077
  {14,  1}, // #3078
  {17,  1}, // #3079
  {19,  1}, // #3080
  {20,  1}, // #3081
  {21,  1}, // #3082
  {22,  1}, // #3083
  {23,  2}, // #3084
  { 2, 12}, // #3085
  { 3,  1}, // #3086
  {11,  1}, // #3087
  {12,  1}, // #3088
  {13,  1}, // #3089
  {14,  1}, // #3090
  {19,  1}, // #3091
  {20,  1}, // #3092
  {22,  1}, // #3093
  {23,  1}, // #3094
  { 2, 24}, // #3095
  { 3,  2}, // #3096
  { 8,  1}, // #3097
  {11,  2}, // #3098
  {12,  2}, // #3099
  {13,  3}, // #3100
  {14,  2}, // #3101
  {15,  1}, // #3102
  {17,  1}, // #3103
  {18,  1}, // #3104
  {19,  3}, // #3105
  {20,  3}, // #3106
  {21,  1}, // #3107
  {22,  3}, // #3108
  {23,  4}, // #3109
  { 2, 24}, // #3110
  { 3,  2}, // #3111
  { 8,  1}, // #3112
  {11,  2}, // #3113
  {12,  2}, // #3114
  {13,  3}, // #3115
  {14,  2}, // #3116
  {15,  1}, // #3117
  {18,  1}, // #3118
  {19,  3}, // #3119
  {20,  3}, // #3120
  {22,  3}, // #3121
  {23,  3}, // #3122
  { 2, 12}, // #3123
  { 3,  2}, // #3124
  { 8,  1}, // #3125
  {11,  2}, // #3126
  {12,  2}, // #3127
  {13,  3}, // #3128
  {14,  2}, // #3129
  {15,  1}, // #3130
  {17,  1}, // #3131
  {18,  1}, // #3132
  {19,  3}, // #3133
  {20,  3}, // #3134
  {21,  1}, // #3135
  {22,  3}, // #3136
  {23,  4}, // #3137
  { 2, 12}, // #3138
  { 3,  2}, // #3139
  { 8,  1}, // #3140
  {11,  2}, // #3141
  {12,  2}, // #3142
  {13,  3}, // #3143
  {14,  2}, // #3144
  {15,  1}, // #3145
  {18,  1}, // #3146
  {19,  3}, // #3147
  {20,  3}, // #3148
  {22,  3}, // #3149
  {23,  3}, // #3150
  { 4,  2}, // #3151
  {11,  2}, // #3152
  {14,  4}, // #3153
  {15,  3}, // #3154
  {16,  2}, // #3155
  {17,  1}, // #3156
  {19,  3}, // #3157
  {20,  4}, // #3158
  {21,  2}, // #3159
  {22,  9}, // #3160
  {23, 11}, // #3161
  { 8,  1}, // #3162
  {13,  1}, // #3163
  {15,  1}, // #3164
  {18,  1}, // #3165
  {19,  2}, // #3166
  {20,  1}, // #3167
  {22,  2}, // #3168
  {23,  2}, // #3169
  { 3,  2}, // #3170
  { 4,  1}, // #3171
  { 8,  2}, // #3172
  { 9,  4}, // #3173
  {11,  3}, // #3174
  {12,  2}, // #3175
  {13,  6}, // #3176
  {14,  6}, // #3177
  {15,  3}, // #3178
  {16,  5}, // #3179
  {18,  6}, // #3180
  {19,  7}, // #3181
  {20, 10}, // #3182
  {22, 15}, // #3183
  {23, 15}, // #3184
  { 7,  1}, // #3185
  { 9,  1}, // #3186
  {12,  1}, // #3187
  {14,  2}, // #3188
  {16,  1}, // #3189
  {17,  1}, // #3190
  {18,  1}, // #3191
  {20,  2}, // #3192
  {21,  2}, // #3193
  {22,  5}, // #3194
  {23,  8}, // #3195
  { 3,  1}, // #3196
  {11,  1}, // #3197
  {12,  1}, // #3198
  {13,  2}, // #3199
  {14,  1}, // #3200
  {17,  1}, // #3201
  {19,  2}, // #3202
  {20,  2}, // #3203
  {21,  1}, // #3204
  {22,  2}, // #3205
  {23,  3}, // #3206
  { 3,  1}, // #3207
  { 8,  1}, // #3208
  {11,  1}, // #3209
  {12,  1}, // #3210
  {13,  2}, // #3211
  {14,  1}, // #3212
  {15,  1}, // #3213
  {18,  1}, // #3214
  {19,  3}, // #3215
  {20,  2}, // #3216
  {22,  3}, // #3217
  {23,  3}, // #3218
  { 3,  1}, // #3219
  { 8,  1}, // #3220
  {11,  1}, // #3221
  {12,  1}, // #3222
  {13,  2}, // #3223
  {14,  1}, // #3224
  {15,  1}, // #3225
  {17,  1}, // #3226
  {18,  1}, // #3227
  {19,  3}, // #3228
  {20,  2}, // #3229
  {21,  1}, // #3230
  {22,  3}, // #3231
  {23,  4}, // #3232
  { 9,  1}, // #3233
  {14,  1}, // #3234
  {16,  1}, // #3235
  {18,  1}, // #3236
  {20,  1}, // #3237
  {22,  4}, // #3238
  {23,  4}, // #3239
  { 9,  1}, // #3240
  {14,  4}, // #3241
  {15,  1}, // #3242
  {16,  1}, // #3243
  {18,  1}, // #3244
  {19,  1}, // #3245
  {20,  4}, // #3246
  {22,  7}, // #3247
  {23,  7}, // #3248
  { 8,  1}, // #3249
  { 9,  2}, // #3250
  {13,  1}, // #3251
  {14,  2}, // #3252
  {15,  1}, // #3253
  {16,  2}, // #3254
  {18,  3}, // #3255
  {19,  1}, // #3256
  {20,  3}, // #3257
  {22, 10}, // #3258
  {23, 10}, // #3259
  { 8,  6}, // #3260
  {13,  9}, // #3261
  {15,  6}, // #3262
  {18,  6}, // #3263
  {19,  9}, // #3264
  {20,  9}, // #3265
  {22, 15}, // #3266
  {23, 15}, // #3267
  { 4,  2}, // #3268
  {11,  2}, // #3269
  {14,  4}, // #3270
  {15,  3}, // #3271
  {16,  2}, // #3272
  {19,  3}, // #3273
  {20,  4}, // #3274
  {22, 10}, // #3275
  {23, 10}, // #3276
  { 4,  1}, // #3277
  { 9,  5}, // #3278
  {11,  1}, // #3279
  {13,  4}, // #3280
  {14,  5}, // #3281
  {15,  1}, // #3282
  {16,  6}, // #3283
  {18,  5}, // #3284
  {19,  5}, // #3285
  {20,  9}, // #3286
  {22, 10}, // #3287
  {23, 10}, // #3288
  { 4,  1}, // #3289
  { 9,  1}, // #3290
  {11,  1}, // #3291
  {14,  1}, // #3292
  {15,  1}, // #3293
  {16,  2}, // #3294
  {18,  1}, // #3295
  {19,  1}, // #3296
  {20,  1}, // #3297
  {22,  4}, // #3298
  {23,  4}, // #3299
  { 4,  1}, // #3300
  {11,  1}, // #3301
  {14,  5}, // #3302
  {15,  2}, // #3303
  {16,  1}, // #3304
  {17,  1}, // #3305
  {19,  2}, // #3306
  {20,  5}, // #3307
  {21,  2}, // #3308
  {22,  8}, // #3309
  {23, 10}, // #3310
  { 4,  2}, // #3311
  {11,  2}, // #3312
  {14,  3}, // #3313
  {15,  2}, // #3314
  {16,  2}, // #3315
  {19,  2}, // #3316
  {20,  3}, // #3317
  {22,  7}, // #3318
  {23,  7}, // #3319
  { 4,  1}, // #3320
  {11,  1}, // #3321
  {14,  5}, // #3322
  {15,  2}, // #3323
  {16,  1}, // #3324
  {19,  2}, // #3325
  {20,  5}, // #3326
  {22,  9}, // #3327
  {23,  9}, // #3328
  { 4,  1}, // #3329
  { 9,  8}, // #3330
  {11,  1}, // #3331
  {14,  8}, // #3332
  {15,  1}, // #3333
  {16,  9}, // #3334
  {17,  1}, // #3335
  {18,  8}, // #3336
  {19,  1}, // #3337
  {20,  8}, // #3338
  {21,  1}, // #3339
  {22, 30}, // #3340
  {23, 31}, // #3341
  { 7,  1}, // #3342
  { 9, 10}, // #3343
  {12,  1}, // #3344
  {14, 10}, // #3345
  {16, 10}, // #3346
  {17,  1}, // #3347
  {18, 10}, // #3348
  {20, 10}, // #3349
  {21,  2}, // #3350
  {22, 36}, // #3351
  {23, 39}, // #3352
  { 7,  1}, // #3353
  { 9, 11}, // #3354
  {12,  1}, // #3355
  {14, 11}, // #3356
  {16, 11}, // #3357
  {17,  1}, // #3358
  {18, 11}, // #3359
  {20, 11}, // #3360
  {21,  2}, // #3361
  {22, 37}, // #3362
  {23, 40}, // #3363
  { 4,  1}, // #3364
  { 7,  1}, // #3365
  { 8,  2}, // #3366
  { 9,  3}, // #3367
  {11,  1}, // #3368
  {12,  1}, // #3369
  {13,  2}, // #3370
  {14,  3}, // #3371
  {15,  4}, // #3372
  {16,  4}, // #3373
  {17,  1}, // #3374
  {18,  5}, // #3375
  {19,  4}, // #3376
  {20,  5}, // #3377
  {21,  2}, // #3378
  {22, 15}, // #3379
  {23, 18}, // #3380
  { 3,  2}, // #3381
  {11,  2}, // #3382
  {12,  2}, // #3383
  {13,  7}, // #3384
  {14, 12}, // #3385
  {17,  8}, // #3386
  {19,  7}, // #3387
  {20, 17}, // #3388
  {21,  8}, // #3389
  {22, 56}, // #3390
  {23, 64}, // #3391
  { 3,  9}, // #3392
  { 4,  1}, // #3393
  { 7, 11}, // #3394
  { 8, 16}, // #3395
  { 9,  1}, // #3396
  {11, 10}, // #3397
  {12, 20}, // #3398
  {13, 25}, // #3399
  {14, 31}, // #3400
  {15, 17}, // #3401
  {16,  2}, // #3402
  {18, 17}, // #3403
  {19, 26}, // #3404
  {20, 47}, // #3405
  {21, 11}, // #3406
  {22, 78}, // #3407
  {23, 100}, // #3408
  { 3,  1}, // #3409
  { 8,  1}, // #3410
  {11,  1}, // #3411
  {12,  1}, // #3412
  {13,  2}, // #3413
  {14,  1}, // #3414
  {15,  1}, // #3415
  {17,  2}, // #3416
  {18,  1}, // #3417
  {19,  3}, // #3418
  {20,  2}, // #3419
  {21,  2}, // #3420
  {22,  3}, // #3421
  {23,  5}, // #3422
  { 8,  2}, // #3423
  {11,  1}, // #3424
  {13,  2}, // #3425
  {15,  2}, // #3426
  {18,  2}, // #3427
  {19,  3}, // #3428
  {20,  2}, // #3429
  {22,  3}, // #3430
  {23,  3}, // #3431
  { 8,  2}, // #3432
  {11,  1}, // #3433
  {13,  2}, // #3434
  {15,  2}, // #3435
  {17,  1}, // #3436
  {18,  2}, // #3437
  {19,  3}, // #3438
  {20,  2}, // #3439
  {21,  1}, // #3440
  {22,  3}, // #3441
  {23,  4}, // #3442
  { 7,  2}, // #3443
  {12,  2}, // #3444
  {15,  1}, // #3445
  {19,  1}, // #3446
  {21,  2}, // #3447
  {22,  1}, // #3448
  {23,  5}, // #3449
  { 7,  1}, // #3450
  {12,  1}, // #3451
  {19,  1}, // #3452
  {21,  1}, // #3453
  {22,  1}, // #3454
  {23,  3}, // #3455
  { 7,  1}, // #3456
  { 8,  2}, // #3457
  {12,  1}, // #3458
  {13,  2}, // #3459
  {15,  2}, // #3460
  {18,  2}, // #3461
  {19,  2}, // #3462
  {20,  2}, // #3463
  {21,  1}, // #3464
  {22,  2}, // #3465
  {23,  4}, // #3466
  { 8,  1}, // #3467
  {13,  1}, // #3468
  {15,  1}, // #3469
  {17,  1}, // #3470
  {18,  1}, // #3471
  {19,  1}, // #3472
  {20,  1}, // #3473
  {21,  1}, // #3474
  {22,  2}, // #3475
  {23,  3}, // #3476
  { 3,  1}, // #3477
  { 7,  2}, // #3478
  {11,  1}, // #3479
  {12,  3}, // #3480
  {13,  1}, // #3481
  {14,  1}, // #3482
  {19,  1}, // #3483
  {20,  1}, // #3484
  {21,  2}, // #3485
  {22,  3}, // #3486
  {23,  7}, // #3487
  { 3,  1}, // #3488
  { 7,  4}, // #3489
  {11,  1}, // #3490
  {12,  5}, // #3491
  {13,  1}, // #3492
  {14,  1}, // #3493
  {19,  1}, // #3494
  {20,  1}, // #3495
  {21,  4}, // #3496
  {22,  3}, // #3497
  {23, 11}, // #3498
  { 3,  1}, // #3499
  { 7,  8}, // #3500
  {11,  1}, // #3501
  {12,  9}, // #3502
  {13,  1}, // #3503
  {14,  1}, // #3504
  {19,  1}, // #3505
  {20,  1}, // #3506
  {21,  8}, // #3507
  {22,  3}, // #3508
  {23, 19}, // #3509
  { 3,  1}, // #3510
  { 7, 16}, // #3511
  { 8,  1}, // #3512
  {11,  1}, // #3513
  {12, 17}, // #3514
  {13,  2}, // #3515
  {14,  1}, // #3516
  {15,  1}, // #3517
  {18,  1}, // #3518
  {19,  2}, // #3519
  {20,  2}, // #3520
  {21, 16}, // #3521
  {22,  4}, // #3522
  {23, 36}, // #3523
  { 3,  1}, // #3524
  { 7,  2}, // #3525
  { 8,  1}, // #3526
  {11,  1}, // #3527
  {12,  3}, // #3528
  {13,  2}, // #3529
  {14,  1}, // #3530
  {15,  1}, // #3531
  {18,  1}, // #3532
  {19,  2}, // #3533
  {20,  2}, // #3534
  {21,  2}, // #3535
  {22,  4}, // #3536
  {23,  8}, // #3537
  { 3,  1}, // #3538
  { 7,  4}, // #3539
  { 8,  1}, // #3540
  {11,  1}, // #3541
  {12,  5}, // #3542
  {13,  2}, // #3543
  {14,  1}, // #3544
  {15,  1}, // #3545
  {18,  1}, // #3546
  {19,  2}, // #3547
  {20,  2}, // #3548
  {21,  4}, // #3549
  {22,  4}, // #3550
  {23, 12}, // #3551
  { 3,  1}, // #3552
  { 7,  8}, // #3553
  { 8,  1}, // #3554
  {11,  1}, // #3555
  {12,  9}, // #3556
  {13,  2}, // #3557
  {14,  1}, // #3558
  {15,  1}, // #3559
  {18,  1}, // #3560
  {19,  2}, // #3561
  {20,  2}, // #3562
  {21,  8}, // #3563
  {22,  4}, // #3564
  {23, 20}, // #3565
  {11,  3}, // #3566
  {19,  3}, // #3567
  {22,  3}, // #3568
  {23,  3}, // #3569
  {13,  3}, // #3570
  {19,  3}, // #3571
  {20,  3}, // #3572
  {22,  3}, // #3573
  {23,  3}, // #3574
  { 3,  1}, // #3575
  {11,  1}, // #3576
  {12,  1}, // #3577
  {13,  1}, // #3578
  {14,  1}, // #3579
  {17,  1}, // #3580
  {19,  2}, // #3581
  {20,  1}, // #3582
  {21,  1}, // #3583
  {22,  2}, // #3584
  {23,  3}, // #3585
  { 4,  1}, // #3586
  { 8,  2}, // #3587
  {11,  3}, // #3588
  {13,  2}, // #3589
  {15,  3}, // #3590
  {16,  1}, // #3591
  {17,  1}, // #3592
  {18,  2}, // #3593
  {19,  7}, // #3594
  {20,  2}, // #3595
  {21,  1}, // #3596
  {22,  7}, // #3597
  {23,  8}, // #3598
  {17,  1}, // #3599
  {19,  3}, // #3600
  {21,  1}, // #3601
  {22,  3}, // #3602
  {23,  4}, // #3603
  { 3,  1}, // #3604
  {11,  1}, // #3605
  {12,  1}, // #3606
  {13,  1}, // #3607
  {14,  1}, // #3608
  {17,  2}, // #3609
  {19,  2}, // #3610
  {20,  1}, // #3611
  {21,  2}, // #3612
  {22,  3}, // #3613
  {23,  5}, // #3614
  { 8,  5}, // #3615
  {11,  5}, // #3616
  {13,  5}, // #3617
  {15,  5}, // #3618
  {18,  5}, // #3619
  {19, 14}, // #3620
  {20,  5}, // #3621
  {22, 14}, // #3622
  {23, 14}, // #3623
  { 8,  5}, // #3624
  {11,  5}, // #3625
  {13,  5}, // #3626
  {15,  5}, // #3627
  {17,  1}, // #3628
  {18,  5}, // #3629
  {19, 14}, // #3630
  {20,  5}, // #3631
  {21,  1}, // #3632
  {22, 14}, // #3633
  {23, 15}, // #3634
  { 8,  9}, // #3635
  {11,  7}, // #3636
  {13,  9}, // #3637
  {15,  9}, // #3638
  {18,  9}, // #3639
  {19, 21}, // #3640
  {20,  9}, // #3641
  {22, 21}, // #3642
  {23, 21}, // #3643
  { 8,  9}, // #3644
  {11,  7}, // #3645
  {13,  9}, // #3646
  {15,  9}, // #3647
  {17,  1}, // #3648
  {18,  9}, // #3649
  {19, 21}, // #3650
  {20,  9}, // #3651
  {21,  1}, // #3652
  {22, 21}, // #3653
  {23, 22}, // #3654
  { 8, 17}, // #3655
  {11, 11}, // #3656
  {13, 17}, // #3657
  {15, 17}, // #3658
  {18, 17}, // #3659
  {19, 35}, // #3660
  {20, 17}, // #3661
  {22, 35}, // #3662
  {23, 35}, // #3663
  { 8, 17}, // #3664
  {11, 11}, // #3665
  {13, 17}, // #3666
  {15, 17}, // #3667
  {17,  1}, // #3668
  {18, 17}, // #3669
  {19, 35}, // #3670
  {20, 17}, // #3671
  {21,  1}, // #3672
  {22, 35}, // #3673
  {23, 36}, // #3674
  {14,  2}, // #3675
  {17,  1}, // #3676
  {20,  2}, // #3677
  {21,  1}, // #3678
  {22,  2}, // #3679
  {23,  3}, // #3680
  { 7,  1}, // #3681
  {12,  1}, // #3682
  {14,  2}, // #3683
  {20,  2}, // #3684
  {21,  1}, // #3685
  {22,  2}, // #3686
  {23,  4}, // #3687
  { 4,  1}, // #3688
  { 7,  1}, // #3689
  { 9,  1}, // #3690
  {11,  1}, // #3691
  {12,  1}, // #3692
  { 5,  1}, // #3693
  { 6,  2}, // #3694
  { 8,  2}, // #3695
  { 9,  2}, // #3696
  {10,  2}, // #3697
  {11,  3}, // #3698
  {12,  6}, // #3699
  { 6,  1}, // #3700
  { 8,  1}, // #3701
  { 9,  1}, // #3702
  {10,  1}, // #3703
  {11,  1}, // #3704
  {12,  2}, // #3705
  { 6,  1}, // #3706
  { 8,  1}, // #3707
  { 9,  1}, // #3708
  {11,  1}, // #3709
  {12,  1}, // #3710
  { 5,  1}, // #3711
  {10,  1}, // #3712
  {12,  2}, // #3713
  {10,  1}, // #3714
  {12,  1}, // #3715
  { 5,  1}, // #3716
  {10,  2}, // #3717
  {11,  3}, // #3718
  {12,  6}, // #3719
  { 8,  1}, // #3720
  {10,  1}, // #3721
  {11,  2}, // #3722
  {12,  3}, // #3723
  { 5,  1}, // #3724
  {10,  2}, // #3725
  {11,  1}, // #3726
  {12,  4}, // #3727
  { 4,  1}, // #3728
  { 7,  1}, // #3729
  { 9,  1}, // #3730
  {10,  1}, // #3731
  {11,  1}, // #3732
  {12,  2}, // #3733
  { 6,  1}, // #3734
  { 8,  1}, // #3735
  { 9,  1}, // #3736
  {10,  1}, // #3737
  {11,  2}, // #3738
  {12,  3}, // #3739
  { 6,  1}, // #3740
  { 8,  1}, // #3741
  { 9,  1}, // #3742
  {11,  2}, // #3743
  {12,  2}, // #3744
  { 6,  2}, // #3745
  { 8,  2}, // #3746
  { 9,  2}, // #3747
  {10,  1}, // #3748
  {11,  2}, // #3749
  {12,  3}, // #3750
  { 6,  2}, // #3751
  { 8,  2}, // #3752
  { 9,  2}, // #3753
  {11,  2}, // #3754
  {12,  2}, // #3755
  {10,  1}, // #3756
  {11, 10}, // #3757
  {12, 11}, // #3758
  {11, 11}, // #3759
  {12, 11}, // #3760
  { 4,  1}, // #3761
  { 7,  1}, // #3762
  { 8,  1}, // #3763
  { 9,  1}, // #3764
  {10,  1}, // #3765
  {11,  2}, // #3766
  {12,  3}, // #3767
  { 4,  1}, // #3768
  { 7,  1}, // #3769
  { 8,  1}, // #3770
  { 9,  1}, // #3771
  {11,  2}, // #3772
  {12,  2}, // #3773
  { 8,  1}, // #3774
  {10,  1}, // #3775
  {11,  1}, // #3776
  {12,  2}, // #3777
  { 8,  2}, // #3778
  {10,  1}, // #3779
  {11,  2}, // #3780
  {12,  3}, // #3781
  { 8,  2}, // #3782
  {11,  2}, // #3783
  {12,  2}, // #3784
  { 5,  1}, // #3785
  { 6,  1}, // #3786
  { 8,  2}, // #3787
  { 9,  1}, // #3788
  {10,  2}, // #3789
  {11,  3}, // #3790
  {12,  6}, // #3791
  { 5,  1}, // #3792
  { 8,  1}, // #3793
  {10,  2}, // #3794
  {11,  1}, // #3795
  {12,  4}, // #3796
  { 6,  2}, // #3797
  { 8,  3}, // #3798
  { 9,  2}, // #3799
  {11,  3}, // #3800
  {12,  3}, // #3801
  { 8,  1}, // #3802
  {11,  4}, // #3803
  {12,  4}, // #3804
  { 4,  1}, // #3805
  { 6,  1}, // #3806
  { 7,  1}, // #3807
  { 8,  1}, // #3808
  { 9,  2}, // #3809
  {10,  1}, // #3810
  {11,  2}, // #3811
  {12,  3}, // #3812
  { 4,  1}, // #3813
  { 6,  1}, // #3814
  { 7,  1}, // #3815
  { 8,  1}, // #3816
  { 9,  2}, // #3817
  {11,  2}, // #3818
  {12,  2}, // #3819
  { 3,  1}, // #3820
  { 7,  1}, // #3821
  { 8,  1}, // #3822
  {10,  1}, // #3823
  {11,  1}, // #3824
  {12,  2}, // #3825
  { 3,  1}, // #3826
  { 6,  1}, // #3827
  { 7,  1}, // #3828
  { 8,  2}, // #3829
  { 9,  1}, // #3830
  {11,  2}, // #3831
  {12,  2}, // #3832
  { 3,  1}, // #3833
  { 4,  1}, // #3834
  { 7,  2}, // #3835
  { 8,  1}, // #3836
  { 9,  1}, // #3837
  {10,  1}, // #3838
  {11,  2}, // #3839
  {12,  3}, // #3840
  { 3,  1}, // #3841
  { 4,  1}, // #3842
  { 7,  2}, // #3843
  { 8,  1}, // #3844
  { 9,  1}, // #3845
  {11,  2}, // #3846
  {12,  2}, // #3847
  { 4,  1}, // #3848
  { 6,  2}, // #3849
  { 7,  1}, // #3850
  { 8,  2}, // #3851
  { 9,  3}, // #3852
  {11,  3}, // #3853
  {12,  3}, // #3854
  { 3,  1}, // #3855
  { 7,  1}, // #3856
  { 8,  1}, // #3857
  {11,  1}, // #3858
  {12,  1}, // #3859
  { 1, 10}, // #3860
  { 3,  1}, // #3861
  { 7,  1}, // #3862
  { 8,  1}, // #3863
  {10,  1}, // #3864
  {11,  1}, // #3865
  {12,  2}, // #3866
  { 1, 10}, // #3867
  { 3,  1}, // #3868
  { 7,  1}, // #3869
  { 8,  1}, // #3870
  {11,  1}, // #3871
  {12,  1}, // #3872
  { 2, 22}, // #3873
  { 3,  1}, // #3874
  { 7,  1}, // #3875
  { 8,  1}, // #3876
  {10,  1}, // #3877
  {11,  1}, // #3878
  {12,  2}, // #3879
  { 2, 22}, // #3880
  { 3,  1}, // #3881
  { 7,  1}, // #3882
  { 8,  1}, // #3883
  {11,  1}, // #3884
  {12,  1}, // #3885
  { 2, 14}, // #3886
  { 3,  1}, // #3887
  { 7,  1}, // #3888
  { 8,  1}, // #3889
  {10,  1}, // #3890
  {11,  1}, // #3891
  {12,  2}, // #3892
  { 2, 14}, // #3893
  { 3,  1}, // #3894
  { 7,  1}, // #3895
  { 8,  1}, // #3896
  {11,  1}, // #3897
  {12,  1}, // #3898
  { 3,  1}, // #3899
  { 4,  1}, // #3900
  { 6,  1}, // #3901
  { 7,  2}, // #3902
  { 8,  2}, // #3903
  { 9,  2}, // #3904
  {10,  1}, // #3905
  {11,  3}, // #3906
  {12,  4}, // #3907
  { 3,  1}, // #3908
  { 4,  1}, // #3909
  { 6,  1}, // #3910
  { 7,  2}, // #3911
  { 8,  2}, // #3912
  { 9,  2}, // #3913
  {11,  3}, // #3914
  {12,  3}, // #3915
  { 3,  1}, // #3916
  { 4,  2}, // #3917
  { 6,  1}, // #3918
  { 7,  3}, // #3919
  { 8,  2}, // #3920
  { 9,  3}, // #3921
  {10,  1}, // #3922
  {11,  4}, // #3923
  {12,  5}, // #3924
  { 3,  1}, // #3925
  { 4,  2}, // #3926
  { 6,  1}, // #3927
  { 7,  3}, // #3928
  { 8,  2}, // #3929
  { 9,  3}, // #3930
  {11,  4}, // #3931
  {12,  4}, // #3932
  { 5,  1}, // #3933
  { 9,  1}, // #3934
  {10,  1}, // #3935
  {11,  1}, // #3936
  {12,  3}, // #3937
  { 3,  1}, // #3938
  { 7,  1}, // #3939
  { 8,  1}, // #3940
  { 9,  1}, // #3941
  {11,  2}, // #3942
  {12,  2}, // #3943
  {11, 31}, // #3944
  {12, 31}, // #3945
  { 4,  1}, // #3946
  { 6,  2}, // #3947
  { 7,  1}, // #3948
  { 8,  2}, // #3949
  { 9,  3}, // #3950
  {10,  1}, // #3951
  {11,  3}, // #3952
  {12,  4}, // #3953
  { 4,  1}, // #3954
  { 7,  1}, // #3955
  { 8,  1}, // #3956
  { 9,  1}, // #3957
  {10,  1}, // #3958
  {11,  4}, // #3959
  {12,  5}, // #3960
  { 4,  1}, // #3961
  { 7,  1}, // #3962
  { 8,  1}, // #3963
  { 9,  1}, // #3964
  {11,  4}, // #3965
  {12,  4}, // #3966
  { 4,  1}, // #3967
  { 7,  1}, // #3968
  { 9,  1}, // #3969
  {10,  1}, // #3970
  {11,  2}, // #3971
  {12,  3}, // #3972
  { 4,  1}, // #3973
  { 7,  1}, // #3974
  { 9,  1}, // #3975
  {11,  2}, // #3976
  {12,  2}, // #3977
  { 4,  1}, // #3978
  { 7,  1}, // #3979
  { 8,  1}, // #3980
  { 9,  1}, // #3981
  {10,  1}, // #3982
  {11,  3}, // #3983
  {12,  4}, // #3984
  { 4,  1}, // #3985
  { 7,  1}, // #3986
  { 8,  1}, // #3987
  { 9,  1}, // #3988
  {11,  3}, // #3989
  {12,  3}, // #3990
  { 3,  1}, // #3991
  { 5,  1}, // #3992
  { 6,  1}, // #3993
  { 7,  1}, // #3994
  { 8,  2}, // #3995
  { 9,  1}, // #3996
  {10,  1}, // #3997
  {11,  2}, // #3998
  {12,  4}, // #3999
  { 6,  1}, // #4000
  { 8,  1}, // #4001
  { 9,  2}, // #4002
  {11,  2}, // #4003
  {12,  2}, // #4004
  { 3,  1}, // #4005
  { 7,  1}, // #4006
  { 8,  1}, // #4007
  { 9,  2}, // #4008
  {10,  1}, // #4009
  {11,  3}, // #4010
  {12,  4}, // #4011
  { 3,  1}, // #4012
  { 7,  1}, // #4013
  { 8,  1}, // #4014
  { 9,  2}, // #4015
  {11,  3}, // #4016
  {12,  3}, // #4017
  {10,  1}, // #4018
  {11, 17}, // #4019
  {12, 18}, // #4020
  {11, 18}, // #4021
  {12, 18}, // #4022
  {10,  1}, // #4023
  {11,  7}, // #4024
  {12,  8}, // #4025
  {11,  8}, // #4026
  {12,  8}, // #4027
  { 3,  3}, // #4028
  { 7,  3}, // #4029
  { 8,  3}, // #4030
  {10,  1}, // #4031
  {11,  3}, // #4032
  {12,  4}, // #4033
  { 3,  3}, // #4034
  { 7,  3}, // #4035
  { 8,  3}, // #4036
  {11,  3}, // #4037
  {12,  3}, // #4038
  { 5,  1}, // #4039
  {10,  2}, // #4040
  {12,  3}, // #4041
  { 3,  1}, // #4042
  { 7,  1}, // #4043
  { 8,  1}, // #4044
  { 9,  1}, // #4045
  {10,  1}, // #4046
  {11,  2}, // #4047
  {12,  3}, // #4048
  { 3,  1}, // #4049
  { 6,  1}, // #4050
  { 7,  1}, // #4051
  { 8,  2}, // #4052
  { 9,  1}, // #4053
  {10,  1}, // #4054
  {11,  2}, // #4055
  {12,  3}, // #4056
  { 5,  1}, // #4057
  { 8,  2}, // #4058
  {10,  2}, // #4059
  {11,  2}, // #4060
  {12,  5}, // #4061
  { 5,  1}, // #4062
  { 8,  3}, // #4063
  {10,  2}, // #4064
  {11,  3}, // #4065
  {12,  6}, // #4066
  { 5,  1}, // #4067
  { 8,  1}, // #4068
  {10,  1}, // #4069
  {11,  1}, // #4070
  {12,  3}, // #4071
  { 5,  1}, // #4072
  { 8,  3}, // #4073
  {10,  2}, // #4074
  {11,  4}, // #4075
  {12,  7}, // #4076
  { 5,  1}, // #4077
  { 8,  1}, // #4078
  {10,  2}, // #4079
  {11,  2}, // #4080
  {12,  5}, // #4081
  { 2, 21}, // #4082
  { 3,  1}, // #4083
  { 7,  1}, // #4084
  { 8,  1}, // #4085
  {10,  1}, // #4086
  {11,  1}, // #4087
  {12,  2}, // #4088
  { 2, 21}, // #4089
  { 3,  1}, // #4090
  { 7,  1}, // #4091
  { 8,  1}, // #4092
  {11,  1}, // #4093
  {12,  1}, // #4094
  { 2, 24}, // #4095
  { 3,  1}, // #4096
  { 7,  1}, // #4097
  { 8,  1}, // #4098
  {11,  1}, // #4099
  {12,  1}, // #4100
  { 7,  1}, // #4101
  {10,  1}, // #4102
  {11,  1}, // #4103
  {12,  2}, // #4104
  { 4,  1}, // #4105
  { 5,  1}, // #4106
  { 7,  1}, // #4107
  { 9,  1}, // #4108
  {10,  1}, // #4109
  {11,  1}, // #4110
  {12,  3}, // #4111
  { 2, 44}, // #4112
  { 3,  2}, // #4113
  { 7,  2}, // #4114
  { 8,  3}, // #4115
  {10,  1}, // #4116
  {11,  3}, // #4117
  {12,  4}, // #4118
  { 2, 44}, // #4119
  { 3,  2}, // #4120
  { 7,  2}, // #4121
  { 8,  3}, // #4122
  {11,  3}, // #4123
  {12,  3}, // #4124
  { 2, 28}, // #4125
  { 3,  2}, // #4126
  { 7,  2}, // #4127
  { 8,  3}, // #4128
  {10,  1}, // #4129
  {11,  3}, // #4130
  {12,  4}, // #4131
  { 2, 28}, // #4132
  { 3,  2}, // #4133
  { 7,  2}, // #4134
  { 8,  3}, // #4135
  {11,  3}, // #4136
  {12,  3}, // #4137
  { 5,  1}, // #4138
  { 7,  1}, // #4139
  {10,  1}, // #4140
  {11,  1}, // #4141
  {12,  3}, // #4142
  { 8,  7}, // #4143
  {10,  4}, // #4144
  {11,  7}, // #4145
  {12, 11}, // #4146
  { 5,  1}, // #4147
  {10,  2}, // #4148
  {11,  2}, // #4149
  {12,  5}, // #4150
  { 6,  1}, // #4151
  { 7,  1}, // #4152
  { 8,  1}, // #4153
  { 9,  1}, // #4154
  {10,  1}, // #4155
  {11,  2}, // #4156
  {12,  3}, // #4157
  { 5,  1}, // #4158
  { 6,  2}, // #4159
  { 8,  2}, // #4160
  { 9,  2}, // #4161
  {10,  2}, // #4162
  {11,  2}, // #4163
  {12,  5}, // #4164
  { 4,  1}, // #4165
  { 5,  1}, // #4166
  { 7,  1}, // #4167
  { 9,  1}, // #4168
  {10,  2}, // #4169
  {11,  1}, // #4170
  {12,  4}, // #4171
  { 5,  1}, // #4172
  { 6,  1}, // #4173
  { 8,  1}, // #4174
  { 9,  1}, // #4175
  {10,  2}, // #4176
  {11,  1}, // #4177
  {12,  4}, // #4178
  { 6,  1}, // #4179
  { 8,  1}, // #4180
  { 9,  1}, // #4181
  {11,  4}, // #4182
  {12,  4}, // #4183
  { 5,  1}, // #4184
  { 6,  2}, // #4185
  { 7,  1}, // #4186
  { 8,  2}, // #4187
  { 9,  2}, // #4188
  {10,  1}, // #4189
  {11,  3}, // #4190
  {12,  5}, // #4191
  { 3,  1}, // #4192
  { 7,  1}, // #4193
  { 8,  1}, // #4194
  {11,  2}, // #4195
  {12,  2}, // #4196
  { 8,  8}, // #4197
  {11,  8}, // #4198
  {12,  8}, // #4199
  { 5,  1}, // #4200
  { 6,  1}, // #4201
  { 8,  1}, // #4202
  { 9,  1}, // #4203
  {10,  1}, // #4204
  {11,  1}, // #4205
  {12,  3}, // #4206
  { 5,  1}, // #4207
  {10,  1}, // #4208
  {11,  1}, // #4209
  {12,  3}, // #4210
  { 3,  1}, // #4211
  { 5,  1}, // #4212
  { 7,  1}, // #4213
  { 8,  1}, // #4214
  { 9,  1}, // #4215
  {10,  1}, // #4216
  {11,  2}, // #4217
  {12,  4}, // #4218
  { 5,  1}, // #4219
  { 6,  1}, // #4220
  { 7,  1}, // #4221
  { 8,  1}, // #4222
  { 9,  1}, // #4223
  {10,  1}, // #4224
  {11,  2}, // #4225
  {12,  4}, // #4226
  { 3,  1}, // #4227
  { 5,  1}, // #4228
  { 7,  1}, // #4229
  { 8,  1}, // #4230
  {10,  2}, // #4231
  {11,  1}, // #4232
  {12,  4}, // #4233
  { 4,  1}, // #4234
  { 6,  2}, // #4235
  { 7,  1}, // #4236
  { 8,  2}, // #4237
  { 9,  3}, // #4238
  {11,  4}, // #4239
  {12,  4}, // #4240
  {10,  2}, // #4241
  {11,  3}, // #4242
  {12,  5}, // #4243
  { 5,  1}, // #4244
  { 6,  1}, // #4245
  { 7,  1}, // #4246
  { 8,  1}, // #4247
  { 9,  1}, // #4248
  {10,  2}, // #4249
  {11,  2}, // #4250
  {12,  5}, // #4251
  { 5,  1}, // #4252
  { 8,  2}, // #4253
  {10,  2}, // #4254
  {11,  3}, // #4255
  {12,  6}, // #4256
  { 4,  2}, // #4257
  { 7,  2}, // #4258
  { 9,  2}, // #4259
  {10,  1}, // #4260
  {11,  2}, // #4261
  {12,  3}, // #4262
  { 8,  2}, // #4263
  {11,  3}, // #4264
  {12,  3}, // #4265
  { 8,  2}, // #4266
  {10,  1}, // #4267
  {11,  3}, // #4268
  {12,  4}, // #4269
  { 5,  1}, // #4270
  { 8,  2}, // #4271
  {10,  1}, // #4272
  {11,  2}, // #4273
  {12,  4}, // #4274
  { 3,  1}, // #4275
  { 4,  1}, // #4276
  { 8,  1}, // #4277
  { 9,  1}, // #4278
  {11,  2}, // #4279
  {12,  1}, // #4280
  {13,  2}, // #4281
  {14,  2}, // #4282
  {15,  2}, // #4283
  {16,  2}, // #4284
  {18,  2}, // #4285
  {19,  3}, // #4286
  {20,  3}, // #4287
  {22,  4}, // #4288
  {23,  4}, // #4289
  { 4,  1}, // #4290
  { 9,  1}, // #4291
  {11,  1}, // #4292
  {14,  1}, // #4293
  {15,  1}, // #4294
  {16,  2}, // #4295
  {17,  1}, // #4296
  {18,  1}, // #4297
  {19,  1}, // #4298
  {20,  1}, // #4299
  {21,  1}, // #4300
  {22,  2}, // #4301
  {23,  3}, // #4302
  { 4,  1}, // #4303
  { 9,  1}, // #4304
  {11,  1}, // #4305
  {14,  1}, // #4306
  {15,  1}, // #4307
  {16,  2}, // #4308
  {18,  1}, // #4309
  {19,  1}, // #4310
  {20,  1}, // #4311
  {22,  2}, // #4312
  {23,  2}, // #4313
  { 2, 17}, // #4314
  { 3,  1}, // #4315
  {11,  1}, // #4316
  {12,  1}, // #4317
  {13,  1}, // #4318
  {14,  1}, // #4319
  {19,  1}, // #4320
  {20,  1}, // #4321
  {22,  1}, // #4322
  {23,  1}, // #4323
  { 4,  1}, // #4324
  { 7,  1}, // #4325
  { 8,  1}, // #4326
  {11,  1}, // #4327
  {12,  1}, // #4328
  {13,  1}, // #4329
  {15,  2}, // #4330
  {16,  1}, // #4331
  {18,  1}, // #4332
  {19,  2}, // #4333
  {20,  1}, // #4334
  {21,  1}, // #4335
  {22,  2}, // #4336
  {23,  4}, // #4337
  { 2, 28}, // #4338
  { 3,  2}, // #4339
  {11,  2}, // #4340
  {12,  2}, // #4341
  {13,  2}, // #4342
  {14,  2}, // #4343
  {15,  1}, // #4344
  {17,  1}, // #4345
  {19,  3}, // #4346
  {20,  2}, // #4347
  {21,  1}, // #4348
  {22,  3}, // #4349
  {23,  4}, // #4350
  { 2, 28}, // #4351
  { 3,  2}, // #4352
  {11,  2}, // #4353
  {12,  2}, // #4354
  {13,  2}, // #4355
  {14,  2}, // #4356
  {15,  1}, // #4357
  {19,  3}, // #4358
  {20,  2}, // #4359
  {22,  3}, // #4360
  {23,  3}, // #4361
  { 2, 14}, // #4362
  { 3,  2}, // #4363
  {11,  2}, // #4364
  {12,  2}, // #4365
  {13,  2}, // #4366
  {14,  2}, // #4367
  {15,  1}, // #4368
  {17,  1}, // #4369
  {19,  3}, // #4370
  {20,  2}, // #4371
  {21,  1}, // #4372
  {22,  3}, // #4373
  {23,  4}, // #4374
  { 2, 14}, // #4375
  { 3,  2}, // #4376
  {11,  2}, // #4377
  {12,  2}, // #4378
  {13,  2}, // #4379
  {14,  2}, // #4380
  {15,  1}, // #4381
  {19,  3}, // #4382
  {20,  2}, // #4383
  {22,  3}, // #4384
  {23,  3}, // #4385
  { 4,  2}, // #4386
  {11,  2}, // #4387
  {15,  2}, // #4388
  {16,  2}, // #4389
  {19,  2}, // #4390
  {22,  2}, // #4391
  {23,  2}, // #4392
  { 3,  2}, // #4393
  { 4,  1}, // #4394
  { 8,  2}, // #4395
  { 9,  4}, // #4396
  {11,  5}, // #4397
  {12,  2}, // #4398
  {13,  4}, // #4399
  {14,  6}, // #4400
  {15,  3}, // #4401
  {16,  5}, // #4402
  {18,  6}, // #4403
  {19,  7}, // #4404
  {20,  8}, // #4405
  {22, 15}, // #4406
  {23, 15}, // #4407
  { 7,  1}, // #4408
  {12,  1}, // #4409
  {17,  2}, // #4410
  {21,  2}, // #4411
  {22,  2}, // #4412
  {23,  5}, // #4413
  {17,  1}, // #4414
  {21,  1}, // #4415
  {22, 14}, // #4416
  {23, 15}, // #4417
  {17,  2}, // #4418
  {21,  2}, // #4419
  {22,  3}, // #4420
  {23,  5}, // #4421
  { 9,  2}, // #4422
  {14,  2}, // #4423
  {16,  2}, // #4424
  {17,  1}, // #4425
  {18,  2}, // #4426
  {19,  1}, // #4427
  {20,  2}, // #4428
  {21,  1}, // #4429
  {22,  3}, // #4430
  {23,  4}, // #4431
  {17,  1}, // #4432
  {19, 16}, // #4433
  {21,  1}, // #4434
  {22, 16}, // #4435
  {23, 17}, // #4436
  { 3,  2}, // #4437
  { 8,  2}, // #4438
  {11,  2}, // #4439
  {12,  2}, // #4440
  {13,  4}, // #4441
  {14,  4}, // #4442
  {15,  3}, // #4443
  {17,  2}, // #4444
  {18,  2}, // #4445
  {19,  8}, // #4446
  {20,  6}, // #4447
  {21,  2}, // #4448
  {22, 10}, // #4449
  {23, 12}, // #4450
  { 3,  5}, // #4451
  { 8,  3}, // #4452
  {11,  5}, // #4453
  {12,  5}, // #4454
  {13,  8}, // #4455
  {14,  9}, // #4456
  {15,  4}, // #4457
  {17,  4}, // #4458
  {18,  3}, // #4459
  {19, 14}, // #4460
  {20, 12}, // #4461
  {21,  4}, // #4462
  {22, 18}, // #4463
  {23, 22}, // #4464
  { 3,  3}, // #4465
  { 8,  3}, // #4466
  {11,  3}, // #4467
  {12,  3}, // #4468
  {13,  6}, // #4469
  {14,  7}, // #4470
  {15,  4}, // #4471
  {17,  4}, // #4472
  {18,  3}, // #4473
  {19, 12}, // #4474
  {20, 10}, // #4475
  {21,  4}, // #4476
  {22, 16}, // #4477
  {23, 20}, // #4478
  { 3,  5}, // #4479
  { 8,  3}, // #4480
  {11,  5}, // #4481
  {12,  5}, // #4482
  {13,  8}, // #4483
  {14, 13}, // #4484
  {15,  4}, // #4485
  {17,  8}, // #4486
  {18,  3}, // #4487
  {19, 18}, // #4488
  {20, 16}, // #4489
  {21,  8}, // #4490
  {22, 26}, // #4491
  {23, 34}, // #4492
  { 3,  3}, // #4493
  { 8,  3}, // #4494
  {11,  3}, // #4495
  {12,  3}, // #4496
  {13,  6}, // #4497
  {14,  5}, // #4498
  {15,  4}, // #4499
  {17,  2}, // #4500
  {18,  3}, // #4501
  {19, 10}, // #4502
  {20,  8}, // #4503
  {21,  2}, // #4504
  {22, 12}, // #4505
  {23, 14}, // #4506
  { 3,  3}, // #4507
  { 8,  3}, // #4508
  {11,  3}, // #4509
  {12,  3}, // #4510
  {13,  6}, // #4511
  {14,  5}, // #4512
  {15,  4}, // #4513
  {17,  2}, // #4514
  {18,  3}, // #4515
  {19, 11}, // #4516
  {20,  8}, // #4517
  {21,  2}, // #4518
  {22, 13}, // #4519
  {23, 15}, // #4520
  {14,  1}, // #4521
  {17,  1}, // #4522
  {20,  1}, // #4523
  {21,  1}, // #4524
  {22,  3}, // #4525
  {23,  4}, // #4526
  { 5,  2}, // #4527
  { 6,  2}, // #4528
  {10,  1}, // #4529
  { 5,  1}, // #4530
  { 6,  1}, // #4531
  {10,  1}, // #4532
  { 4,  5}, // #4533
  { 6,  5}, // #4534
  {10,  1}, // #4535
  { 4,  1}, // #4536
  { 6,  1}, // #4537
  {10,  1}, // #4538
  { 4,  4}, // #4539
  { 6,  4}, // #4540
  {10,  1}, // #4541
  { 9, 20}, // #4542
  {10,  1}, // #4543
  { 1, 25}, // #4544
  { 9,  1}, // #4545
  {10,  1}, // #4546
  { 2, 69}, // #4547
  { 4,  1}, // #4548
  { 6,  1}, // #4549
  {10,  1}, // #4550
  { 2, 39}, // #4551
  { 4,  1}, // #4552
  { 6,  1}, // #4553
  {10,  1}, // #4554
  { 2, 17}, // #4555
  { 4,  1}, // #4556
  { 6,  1}, // #4557
  {10,  1}, // #4558
  { 2, 32}, // #4559
  { 4,  1}, // #4560
  { 6,  1}, // #4561
  {10,  1}, // #4562
  { 4,  1}, // #4563
  { 6,  1}, // #4564
  {10,  2}, // #4565
  { 6, 10}, // #4566
  { 6,  6}, // #4567
  {10,  1}, // #4568
  { 3,  4}, // #4569
  { 4,  1}, // #4570
  { 6,  1}, // #4571
  {10,  1}, // #4572
  { 3,  2}, // #4573
  { 4,  1}, // #4574
  { 6,  1}, // #4575
  {10,  1}, // #4576
  { 4,  1}, // #4577
  { 6,  1}, // #4578
  { 8,  1}, // #4579
  { 9,  1}, // #4580
  {10,  1}, // #4581
  { 4, 10}, // #4582
  { 6, 10}, // #4583
  {10,  1}, // #4584
  { 4, 21}, // #4585
  { 6, 21}, // #4586
  {10,  1}, // #4587
  { 4, 17}, // #4588
  { 6, 17}, // #4589
  {10,  1}, // #4590
  { 4, 13}, // #4591
  { 6, 13}, // #4592
  {10,  1}, // #4593
  { 2, 70}, // #4594
  { 4,  1}, // #4595
  { 6,  1}, // #4596
  {10,  1}, // #4597
  { 2, 40}, // #4598
  { 4,  1}, // #4599
  { 6,  1}, // #4600
  {10,  1}, // #4601
  { 2, 35}, // #4602
  { 4,  1}, // #4603
  { 6,  1}, // #4604
  {10,  1}, // #4605
  { 2, 20}, // #4606
  { 4,  1}, // #4607
  { 6,  1}, // #4608
  {10,  1}, // #4609
  { 8,  1}, // #4610
  {11,  2}, // #4611
  {13,  1}, // #4612
  {15,  1}, // #4613
  {17,  1}, // #4614
  {18,  1}, // #4615
  {19,  3}, // #4616
  {20,  1}, // #4617
  {21,  1}, // #4618
  {22,  3}, // #4619
  {23,  4}, // #4620
  { 8,  1}, // #4621
  {11,  2}, // #4622
  {13,  1}, // #4623
  {15,  1}, // #4624
  {18,  1}, // #4625
  {19,  3}, // #4626
  {20,  1}, // #4627
  {22,  3}, // #4628
  {23,  3}, // #4629
  { 8,  1}, // #4630
  {11,  3}, // #4631
  {13,  1}, // #4632
  {15,  1}, // #4633
  {17,  1}, // #4634
  {18,  1}, // #4635
  {19,  4}, // #4636
  {20,  1}, // #4637
  {21,  1}, // #4638
  {22,  4}, // #4639
  {23,  5}, // #4640
  { 8,  1}, // #4641
  {11,  3}, // #4642
  {13,  1}, // #4643
  {15,  1}, // #4644
  {18,  1}, // #4645
  {19,  4}, // #4646
  {20,  1}, // #4647
  {22,  4}, // #4648
  {23,  4}, // #4649
  { 3,  1}, // #4650
  { 8,  1}, // #4651
  {11,  2}, // #4652
  {12,  1}, // #4653
  {13,  2}, // #4654
  {14,  1}, // #4655
  {15,  1}, // #4656
  {18,  1}, // #4657
  {19,  3}, // #4658
  {20,  2}, // #4659
  {22,  3}, // #4660
  {23,  3}, // #4661
  { 3,  1}, // #4662
  { 8,  1}, // #4663
  {11,  2}, // #4664
  {12,  1}, // #4665
  {13,  2}, // #4666
  {14,  1}, // #4667
  {15,  1}, // #4668
  {17,  1}, // #4669
  {18,  1}, // #4670
  {19,  3}, // #4671
  {20,  2}, // #4672
  {21,  1}, // #4673
  {22,  3}, // #4674
  {23,  4}, // #4675
  {22, 16}, // #4676
  {23, 16}, // #4677
  { 3,  1}, // #4678
  {11,  2}, // #4679
  {12,  1}, // #4680
  {13,  1}, // #4681
  {14,  1}, // #4682
  {19,  2}, // #4683
  {20,  1}, // #4684
  {22,  2}, // #4685
  {23,  2}, // #4686
  { 7,  1}, // #4687
  { 9, 11}, // #4688
  {12,  1}, // #4689
  {14, 11}, // #4690
  {16, 11}, // #4691
  {17,  1}, // #4692
  {18, 11}, // #4693
  {20, 11}, // #4694
  {21,  2}, // #4695
  {22, 41}, // #4696
  {23, 44}, // #4697
  { 1,  1}, // #4698
  { 4,  1}, // #4699
  {11,  1}, // #4700
  {15,  1}, // #4701
  {18,  1}, // #4702
  {20,  1}, // #4703
  {21,  1}, // #4704
  {22,  1}, // #4705
  { 1,  2}, // #4706
  { 4,  1}, // #4707
  { 1,  1}, // #4708
  {11,  1}, // #4709
  {12,  1}, // #4710
  {16,  1}, // #4711
  {17,  1}, // #4712
  {18,  1}, // #4713
  {22,  1}, // #4714
  { 1,  1}, // #4715
  {11,  1}, // #4716
  {16,  1}, // #4717
  {22,  1}, // #4718
  { 1,  1}, // #4719
  {11,  1}, // #4720
  {15,  1}, // #4721
  {18,  1}, // #4722
  {20,  1}, // #4723
  {21,  1}, // #4724
  {22,  1}, // #4725
  { 1,  1}, // #4726
  {11,  2}, // #4727
  {18,  2}, // #4728
  {22,  2}, // #4729
  { 1,  1}, // #4730
  {11,  2}, // #4731
  {15,  2}, // #4732
  {18,  2}, // #4733
  {20,  2}, // #4734
  {21,  2}, // #4735
  {22,  2}, // #4736
  { 1,  1}, // #4737
  { 4,  1}, // #4738
  { 7,  1}, // #4739
  {10, 17}, // #4740
  { 1,  1}, // #4741
  { 4,  1}, // #4742
  { 7,  1}, // #4743
  {10, 25}, // #4744
  { 1,  1}, // #4745
  { 4,  1}, // #4746
  { 7,  1}, // #4747
  {10, 41}, // #4748
  { 1,  1}, // #4749
  { 4,  1}, // #4750
  { 7,  1}, // #4751
  {10, 15}, // #4752
  { 1,  1}, // #4753
  {11,  5}, // #4754
  {14,  3}, // #4755
  {17,  3}, // #4756
  {19,  5}, // #4757
  {21,  3}, // #4758
  {11,  3}, // #4759
  {14,  2}, // #4760
  {17,  2}, // #4761
  {19,  3}, // #4762
  {21,  2}, // #4763
  { 1,  1}, // #4764
  { 4,  1}, // #4765
  { 6,  1}, // #4766
  {23,  1}, // #4767
  { 1,  1}, // #4768
  {11,  1}, // #4769
  {19,  1}, // #4770
  { 1,  1}, // #4771
  {11,  1}, // #4772
  {20,  1}, // #4773
  {22,  1}, // #4774
  {11,  1}, // #4775
  {14,  1}, // #4776
  {17,  1}, // #4777
  {19,  1}, // #4778
  {21,  1}, // #4779
  { 1,  1}, // #4780
  {11,  1}, // #4781
  {14,  1}, // #4782
  {17,  1}, // #4783
  {19,  1}, // #4784
  {21,  1}, // #4785
  { 1,  1}, // #4786
  { 4,  2}, // #4787
  { 6,  2}, // #4788
  {23,  2}, // #4789
  { 1,  1}, // #4790
  {11,  2}, // #4791
  {19,  2}, // #4792
  { 1,  1}, // #4793
  {11,  2}, // #4794
  {17,  2}, // #4795
  { 1,  1}, // #4796
  {11, 20}, // #4797
  {15, 20}, // #4798
  {18, 20}, // #4799
  {20, 20}, // #4800
  {21, 20}, // #4801
  {22, 20}, // #4802
  { 1,  1}, // #4803
  {11,  1}, // #4804
  {18,  1}, // #4805
  {22,  1}, // #4806
  { 1,  1}, // #4807
  {11, 22}, // #4808
  {15, 22}, // #4809
  {18, 22}, // #4810
  {20, 22}, // #4811
  {21, 22}, // #4812
  {22, 22}, // #4813
  {11, 15}, // #4814
  {15, 15}, // #4815
  {18, 15}, // #4816
  {20, 15}, // #4817
  {21, 15}, // #4818
  {22, 15}, // #4819
  { 1,  1}, // #4820
  {11, 19}, // #4821
  {15, 19}, // #4822
  {18, 19}, // #4823
  {20, 19}, // #4824
  {21, 19}, // #4825
  {22, 19}, // #4826
  {11, 12}, // #4827
  {15, 12}, // #4828
  {18, 12}, // #4829
  {20, 12}, // #4830
  {21, 12}, // #4831
  {22, 12}, // #4832
  { 1,  1}, // #4833
  {11,  2}, // #4834
  {16,  2}, // #4835
  {22,  2}, // #4836
  { 1,  1}, // #4837
  {11,  3}, // #4838
  {16,  3}, // #4839
  {22,  3}, // #4840
  {11,  2}, // #4841
  {14,  2}, // #4842
  {17,  2}, // #4843
  {19,  2}, // #4844
  {21,  2}, // #4845
  { 1,  1}, // #4846
  {11,  2}, // #4847
  {12,  2}, // #4848
  {16,  2}, // #4849
  {17,  2}, // #4850
  {18,  2}, // #4851
  {22,  2}, // #4852
  { 1,  1}, // #4853
  {11, 40}, // #4854
  {15, 40}, // #4855
  {18, 40}, // #4856
  {20, 40}, // #4857
  {21, 40}, // #4858
  {22, 40}, // #4859
  { 1,  1}, // #4860
  {11, 28}, // #4861
  {15, 28}, // #4862
  {18, 28}, // #4863
  {20, 28}, // #4864
  {21, 28}, // #4865
  {22, 28}, // #4866
  {11,  1}, // #4867
  {21,  1}, // #4868
  { 1,  1}, // #4869
  {11,  1}, // #4870
  {21,  1}, // #4871
  {11,  2}, // #4872
  {15,  1}, // #4873
  {18,  1}, // #4874
  {19,  1}, // #4875
  {20,  1}, // #4876
  {21,  1}, // #4877
  {22,  1}, // #4878
  { 1,  1}, // #4879
  {11,  2}, // #4880
  {15,  1}, // #4881
  {18,  1}, // #4882
  {19,  1}, // #4883
  {20,  1}, // #4884
  {21,  1}, // #4885
  {22,  1}, // #4886
  { 1,  1}, // #4887
  {11,  1}, // #4888
  {17,  1}, // #4889
  { 1,  5}, // #4890
  {11,  3}, // #4891
  {14,  2}, // #4892
  {17,  2}, // #4893
  {19,  3}, // #4894
  {21,  2}, // #4895
  { 1,  1}, // #4896
  {11,  2}, // #4897
  {22,  2}, // #4898
  { 1,  1}, // #4899
  {11,  2}, // #4900
  {14,  1}, // #4901
  {15,  1}, // #4902
  {17,  1}, // #4903
  {18,  1}, // #4904
  {19,  1}, // #4905
  {20,  1}, // #4906
  {21,  2}, // #4907
  {22,  1}, // #4908
  { 1,  1}, // #4909
  {11,  3}, // #4910
  {18,  3}, // #4911
  {22,  3}, // #4912
  {11,  2}, // #4913
  {15,  1}, // #4914
  {18,  1}, // #4915
  {20,  1}, // #4916
  {21,  1}, // #4917
  {22,  2}, // #4918
  { 1,  1}, // #4919
  {11,  2}, // #4920
  {13,  2}, // #4921
  {16,  2}, // #4922
  {19,  2}, // #4923
  {20,  2}, // #4924
  {22,  2}, // #4925
  { 4,  1}, // #4926
  { 6,  1}, // #4927
  {23,  2}, // #4928
  { 1,  1}, // #4929
  { 4,  1}, // #4930
  { 9,  1}, // #4931
  {11,  1}, // #4932
  {22,  1}, // #4933
  { 1,  1}, // #4934
  {11,  1}, // #4935
  {22,  1}, // #4936
  {11,  2}, // #4937
  {14,  1}, // #4938
  {17,  1}, // #4939
  {19,  2}, // #4940
  {21,  1}, // #4941
  {11,  2}, // #4942
  {13,  1}, // #4943
  {16,  1}, // #4944
  {18,  1}, // #4945
  {19,  1}, // #4946
  {20,  1}, // #4947
  {22,  2}, // #4948
  {11,  1}, // #4949
  {13,  1}, // #4950
  {16,  1}, // #4951
  {19,  1}, // #4952
  {20,  1}, // #4953
  {22,  1}, // #4954
  { 1,  1}, // #4955
  {11,  1}, // #4956
  {13,  1}, // #4957
  {16,  1}, // #4958
  {19,  1}, // #4959
  {20,  1}, // #4960
  {22,  1}, // #4961
  {12,  1}, // #4962
  {16,  1}, // #4963
  {19,  1}, // #4964
  {21,  1}, // #4965
  {22,  1}, // #4966
  {23,  1}, // #4967
  { 1,  2}, // #4968
  { 5,  1}, // #4969
  { 1,  1}, // #4970
  {12,  1}, // #4971
  {13,  1}, // #4972
  {17,  1}, // #4973
  {18,  1}, // #4974
  {19,  1}, // #4975
  {23,  1}, // #4976
  { 1,  1}, // #4977
  {12,  1}, // #4978
  {17,  1}, // #4979
  {23,  1}, // #4980
  { 1,  1}, // #4981
  {12,  1}, // #4982
  {16,  1}, // #4983
  {19,  1}, // #4984
  {21,  1}, // #4985
  {22,  1}, // #4986
  {23,  1}, // #4987
  { 1,  1}, // #4988
  {12,  1}, // #4989
  {19,  1}, // #4990
  {23,  1}, // #4991
  { 1,  1}, // #4992
  {12,  2}, // #4993
  {16,  2}, // #4994
  {19,  2}, // #4995
  {21,  2}, // #4996
  {22,  2}, // #4997
  {23,  2}, // #4998
  { 1,  1}, // #4999
  { 5,  1}, // #5000
  { 8,  1}, // #5001
  {11, 17}, // #5002
  { 1,  1}, // #5003
  { 5,  1}, // #5004
  { 8,  1}, // #5005
  {11, 25}, // #5006
  { 1,  1}, // #5007
  { 5,  1}, // #5008
  { 8,  1}, // #5009
  {11, 41}, // #5010
  { 1,  1}, // #5011
  { 5,  1}, // #5012
  { 8,  1}, // #5013
  {11, 15}, // #5014
  { 1,  1}, // #5015
  {12,  5}, // #5016
  {15,  3}, // #5017
  {18,  3}, // #5018
  {20,  5}, // #5019
  {22,  3}, // #5020
  {12,  3}, // #5021
  {15,  2}, // #5022
  {18,  2}, // #5023
  {20,  3}, // #5024
  {22,  2}, // #5025
  { 1,  1}, // #5026
  { 5,  1}, // #5027
  { 7,  1}, // #5028
  {24,  1}, // #5029
  { 1,  1}, // #5030
  {12,  1}, // #5031
  {20,  1}, // #5032
  { 1,  1}, // #5033
  {12,  1}, // #5034
  {21,  1}, // #5035
  {23,  1}, // #5036
  {12,  1}, // #5037
  {15,  1}, // #5038
  {18,  1}, // #5039
  {20,  1}, // #5040
  {22,  1}, // #5041
  { 1,  1}, // #5042
  {12,  1}, // #5043
  {15,  1}, // #5044
  {18,  1}, // #5045
  {20,  1}, // #5046
  {22,  1}, // #5047
  { 1,  1}, // #5048
  { 5,  2}, // #5049
  { 7,  2}, // #5050
  {24,  2}, // #5051
  { 1,  1}, // #5052
  {12,  2}, // #5053
  {20,  2}, // #5054
  { 1,  1}, // #5055
  {12,  2}, // #5056
  {18,  2}, // #5057
  {12,  1}, // #5058
  {18,  1}, // #5059
  { 1,  1}, // #5060
  {12, 20}, // #5061
  {16, 20}, // #5062
  {19, 20}, // #5063
  {21, 20}, // #5064
  {22, 20}, // #5065
  {23, 20}, // #5066
  {12, 13}, // #5067
  {16, 13}, // #5068
  {19, 13}, // #5069
  {21, 13}, // #5070
  {22, 13}, // #5071
  {23, 13}, // #5072
  { 1,  1}, // #5073
  {12, 17}, // #5074
  {16, 17}, // #5075
  {19, 17}, // #5076
  {21, 17}, // #5077
  {22, 17}, // #5078
  {23, 17}, // #5079
  {12, 10}, // #5080
  {16, 10}, // #5081
  {19, 10}, // #5082
  {21, 10}, // #5083
  {22, 10}, // #5084
  {23, 10}, // #5085
  { 1,  1}, // #5086
  {12,  2}, // #5087
  {17,  2}, // #5088
  {23,  2}, // #5089
  {12,  2}, // #5090
  {15,  2}, // #5091
  {18,  2}, // #5092
  {20,  2}, // #5093
  {22,  2}, // #5094
  { 1,  1}, // #5095
  {12, 28}, // #5096
  {16, 28}, // #5097
  {19, 28}, // #5098
  {21, 28}, // #5099
  {22, 28}, // #5100
  {23, 28}, // #5101
  {12,  1}, // #5102
  {22,  1}, // #5103
  { 1,  1}, // #5104
  {12,  1}, // #5105
  {22,  1}, // #5106
  {12,  2}, // #5107
  {16,  1}, // #5108
  {19,  1}, // #5109
  {20,  1}, // #5110
  {21,  1}, // #5111
  {22,  1}, // #5112
  {23,  1}, // #5113
  { 1,  1}, // #5114
  {12,  2}, // #5115
  {16,  1}, // #5116
  {19,  1}, // #5117
  {20,  1}, // #5118
  {21,  1}, // #5119
  {22,  1}, // #5120
  {23,  1}, // #5121
  { 1,  1}, // #5122
  {12,  1}, // #5123
  {18,  1}, // #5124
  { 1,  5}, // #5125
  {12,  3}, // #5126
  {15,  2}, // #5127
  {18,  2}, // #5128
  {20,  3}, // #5129
  {22,  2}, // #5130
  { 1,  1}, // #5131
  {12,  1}, // #5132
  {23,  1}, // #5133
  { 1,  1}, // #5134
  {12,  2}, // #5135
  {15,  1}, // #5136
  {16,  1}, // #5137
  {18,  1}, // #5138
  {19,  1}, // #5139
  {20,  1}, // #5140
  {21,  1}, // #5141
  {22,  2}, // #5142
  {23,  1}, // #5143
  { 1,  1}, // #5144
  {12,  3}, // #5145
  {19,  3}, // #5146
  {23,  3}, // #5147
  { 1,  1}, // #5148
  {12,  3}, // #5149
  {17,  3}, // #5150
  {23,  3}, // #5151
  {12,  2}, // #5152
  {16,  1}, // #5153
  {19,  1}, // #5154
  {21,  1}, // #5155
  {22,  1}, // #5156
  {23,  2}, // #5157
  { 1,  1}, // #5158
  {12,  2}, // #5159
  {14,  2}, // #5160
  {17,  2}, // #5161
  {20,  2}, // #5162
  {21,  2}, // #5163
  {23,  2}, // #5164
  { 5,  1}, // #5165
  { 7,  1}, // #5166
  {24,  2}, // #5167
  { 1,  1}, // #5168
  { 5,  1}, // #5169
  {10,  1}, // #5170
  {12,  2}, // #5171
  {15,  1}, // #5172
  {18,  1}, // #5173
  {20,  2}, // #5174
  {22,  1}, // #5175
  {12,  2}, // #5176
  {14,  1}, // #5177
  {17,  1}, // #5178
  {19,  1}, // #5179
  {20,  1}, // #5180
  {21,  1}, // #5181
  {23,  2}, // #5182
  {12,  1}, // #5183
  {14,  1}, // #5184
  {17,  1}, // #5185
  {20,  1}, // #5186
  {21,  1}, // #5187
  {23,  1}, // #5188
  { 1,  1}, // #5189
  {12,  1}, // #5190
  {14,  1}, // #5191
  {17,  1}, // #5192
  {20,  1}, // #5193
  {21,  1}, // #5194
  {23,  1} // #5195
}; // X86WriteProcResTable

// {Cycles, WriteResourceID}
extern const llvm::MCWriteLatencyEntry X86WriteLatencyTable[] = {
  { 0,  0}, // Invalid
  { 1,  0}, // #1 WriteALU_WriteZero_WriteVecALU_WriteCMPXCHGRMW_WriteJumpLd_WriteMove_WriteFStoreX_WriteFLoadX_WriteFSign_WriteADC_AtomWrite0_1_WriteADCLd_WriteALULd_WriteFLogicLd_WriteBSWAP32_WriteBSWAP64_WriteBitTestImmLd_WriteBitTestSet_WriteLoad_WriteCMOVLd_WriteNop_WriteStore_WriteVecExtractSt_WriteVecALUX_WriteVecALUXLd_WriteFShuffleLd_WriteVecLogicX_WriteShuffle_WriteVecLoadX_WriteFLD0_WriteLEA_WriteFence_WriteVecStoreX_WriteVecMoveFromGpr_WriteVecMoveX_WriteVecStoreNT_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteVarShuffleLd_WriteVecShiftImm_WriteFMoveX_WriteVecLoadNT_WriteStoreNT_WriteFStoreNTX_WriteShuffleXLd_WriteVecLogicXLd_WriteVecShiftImmX_WriteVecTestLd_WriteRotate_WriteRotateCL_WriteRMW_WriteShiftLd_WriteShiftCL_WriteSETCC_WriteVecMaskedStore_WriteVecShiftImmXLd_WriteFTestLd_AtomWrite1_1_AtomWrite0_1_1_AtomWrite01_1_WriteFStoreY_WriteBZHI_WriteFCMOV_WriteFCom_WriteSETCCStore_WriteFSqrt80_WriteSTMXCSR_WriteShuffle256_WriteVarShuffle256_WriteVecStoreY_WriteVecTestY_WriteFTestY_WriteXCHG_PdWriteTST_F_UCOM_FPPr_PdWriteXADD_PdWriteADCSBB64ri32_PdWriteVMOVUPDYmrVMOVUPSYmr_PdWriteVMOVDQUYmr_PdWriteMOVDQArr_PdWriteSETGEmSETGmSETLEmSETLm_WriteFBlend_WriteBLS_WriteFLDC_WriteLAHFSAHF_WriteFLD1_WriteVecMoveToGpr_WriteMMXMOVMSK_WriteBlend_WriteVarShuffleX_WriteShuffleY_WriteFLogicY_WriteFBlendY_WriteVecALUY_WriteFMoveY_WriteFShuffleY_WriteVecMoveY_WriteVecStoreNTY_WriteFStoreNTY_WriteVecLogicY_WriteBlendY_WriteFVarShuffleY_WriteVecShiftImmY_WriteVarShuffleY_BWWriteResGroup10_BWWriteResGroup2_BWWriteResGroup5_BWWriteResGroup6_BWWriteResGroup3_BWWriteResGroup4_BWWriteResGroup7_BWWriteResGroup8_BWWriteResGroup9_WriteBEXTR_WriteLZCNT_WritePHAdd_WritePOPCNT_WriteFShuffle256_JWriteVecExtractF128_JWriteZeroIdiomYmm_WriteShuffleZ_WriteFLogicZ_WriteVecALUZ_WriteFShuffleZ_WriteVecLogicZ_WriteFVarShuffleZ_WriteVecShiftImmZ_WriteVarVecShift_WriteVarVecShiftY_WriteVarVecShiftZ_WriteVarShuffleZ_SKXWriteResGroup9_SKXWriteResGroup10_SKXWriteResGroup11_SKXWriteResGroup3_SKXWriteResGroup6_SKXWriteResGroup7_SKXWriteResGroup4_SKXWriteResGroup8_SKXWritePSUB_WriteCvtSS2SD_WriteFVarShuffle256_SBWriteResGroup2_SBWriteResGroup1_SBWriteResGroup4_SBWriteResGroup5_SBWriteResGroupVzeroupper_WriteBitTestRegLd_HWWriteBTRSCmr_HWWrite2P1_HWWriteP01_HWWrite2P01_HWWrite2P0156_P23_HWWriteResGroup10_HWWriteINTO_HWWritePushA_HWWritePopA_HWWriteP1_HWWriteBOUND_HWWriteResGroup3_HWWriteResGroup6_HWWriteResGroup7_HWWrite3P01_HWWriteP0156_P23_HWWriteRETI_HWWriteRDPMC_HWWriteRDRAND_HWWriteFNSAVE_HWWriteFRSTOR_HWWriteResGroup2_HWWriteResGroup4_HWWriteResGroup5_HWWriteResGroup8_HWWriteResGroup9_HWWriteADC0_WriteSHDrri_WriteVarBlend_WritePHAddX_WriteVecShiftX_WriteSHDrrcl_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WritePHAddY_WriteVecMaskedStoreY_WriteVecShiftY_SKLWriteResGroup9_SKLWriteResGroup10_SKLWriteResGroup11_SKLWriteResGroup3_SKLWriteResGroup6_SKLWriteResGroup7_SKLWriteResGroup4_SKLWriteResGroup8_SKLWritePSUB_WriteFVarBlend_WriteFMOVMSK_WriteVecMOVMSK_WriteFVarBlendY_WriteVarBlendY_ZnWriteFPU3Lat1_ZnWriteFLDr_ZnWriteFPU0Lat1_ZnWriteFXCH_ZnWritePShift_ZnWriteJCXZ_ZnWriteLD_F80m_ZnWriteLOOPE_ZnWriteCMPXCHG8B_ZnWriteRET_ZnWritePCMPGTQr_ZnWriteFPU01Y_ZnWriteFPU12m_ZnWriteCALLr_ZnXADD_ZnWriteFPU12Y_ZnWriteFPU013_ZnWriteSHA1MSG2r_ZnWriteSHA1NEXTEr_Zn2WriteFPU3Lat1_Zn2WriteFLDr_Zn2WriteFPU0Lat1_Zn2WriteFXCH_Zn2WritePShift_Zn2WriteJCXZ_Zn2WriteLD_F80m_Zn2WriteLOOPE_Zn2WriteCMPXCHG8B_Zn2WriteRET_Zn2WritePCMPGTQr_Zn2WriteFPU01Y_Zn2WriteFPU12m_Zn2WriteCALLr_Zn2XADD_Zn2WriteFPU12Y_Zn2WriteFPU013_Zn2WriteFPU013Y_Zn2WritePShiftY_Zn2WriteSHA1MSG2r_Zn2WriteSHA1NEXTEr_Zn2WriteXCHG
  {100,  0}, // #2 WriteSystem_WriteMicrocoded_ZnWriteMicrocoded_WriteFShuffle256_WriteFVarShuffle256_Zn2WriteMicrocoded
  { 2,  0}, // #3 WriteSHDrri_AtomWrite01_2_WriteLAHFSAHF_WriteVecShift_WriteStore_WriteVecShiftX_WriteSETCCStore_WriteSHDrrcl_WriteXCHG_WriteVecALU_WriteFLogic_WriteBEXTR_WriteFBlend_WriteFVarBlend_WriteBLS_WriteBitTestSet_WriteFCmp64X_WriteFCmpX_WriteCRC32_WriteVecALUX_WriteEMMS_WriteFShuffle_WriteVecLogicX_WriteShuffle_WriteLZCNT_WriteVecStore_WriteVecStoreNT_WriteVecMove_WriteVecInsert_WriteVecShiftImm_WriteFStore_WriteShuffleX_WriteVarBlend_WriteBlend_WritePHAddX_WriteVecShiftImmX_WriteTZCNT_WriteShuffleY_WriteFLogicY_WriteFVarBlendY_WriteFBlendY_WriteFShuffle256_WriteFCmp64Y_WriteFCmpY_WriteFMoveY_WriteFShuffleY_WriteVecMoveY_WriteVecStoreNTY_PdWriteLAHF_PdWriteVEXTRACTF128rr_PdWriteBMI1_PdWriteSAHF_PdWriteBEXTRI_PdWriteBEXTRIm_PdWriteMOVHPm_PdWriteVPPERM_WriteBSWAP64_WriteVecExtractSt_WriteVecTest_WriteSTMXCSR_WriteCvtPH2PSY_WriteVarBlendY_BWWriteResGroup14_BWWriteResGroup20_BWWriteResGroup22_BWWriteResGroup12_BWWriteResGroup17_BWWriteResGroup25_BWWriteResGroup16_BWWriteResGroup18_BWWriteResGroup24_BWWriteResGroup15_BWWriteResGroup87_1_BWWriteCMOVA_CMOVBErr_BWWriteSETA_SETBEr_WriteFSign_WriteAESIMC_WriteAESKeyGen_WriteCvtPS2PD_WriteVecIMul_WritePSADBW_WriteVarShuffle_WriteFMulX_WriteCLMul_WritePHMINPOS_WriteVecIMulX_WritePSADBWX_WriteVarShuffleX_WriteFRcpX_WriteRMW_WriteFRsqrtX_WriteCvtPS2PDY_WriteFMulY_WriteFRcpY_WriteFRsqrtY_JWriteXCHG8rr_XADDrr_JWriteINSERTQ_JWrite3OpsLEA_WriteFCom_WriteVecMoveToGpr_WriteMMXMOVMSK_WriteFMOVMSK_WriteVecMOVMSK_WriteFVarBlendZ_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVarBlendZ_WriteVecMaskedStoreY_WriteVecMOVMSKY_WriteFTestY_SKXWriteResGroup17_SKXWriteResGroup23_SKXWriteResGroup25_SKXWriteResGroup14_SKXWriteResGroup28_SKXWriteResGroup20_SKXWriteResGroup13_SKXWriteResGroup21_SKXWriteResGroup27_SKXWriteResGroup107_1_SKXWriteResGroup29_SKXWriteCMOVA_CMOVBErr_SKXWriteSETA_SETBEr_WriteADC_WriteRotate_WriteCvtPS2PDZ_WriteVecTestY_SBWriteResGroup18_SBWriteResGroup11_SBWriteResGroup12_SBWriteResGroup15_SBWriteResGroup23_SBWriteSETA_SETBEr_WriteCvtPH2PSZ_HWWriteResGroup30_HWWriteResGroup35_HWWriteResGroup21_HWWriteResGroup28_HWWriteResGroup33_HWWriteResGroup24_HWWriteResGroup32_HWWriteResGroup19_HWWriteResGroup23_HWWriteResGroup23_16_HWWriteResGroup31_HWWriteResGroup46_1_HWWriteSETA_SETBEr_SKLWriteResGroup17_SKLWriteResGroup23_SKLWriteResGroup25_SKLWriteResGroup14_SKLWriteResGroup28_SKLWriteResGroup20_SKLWriteResGroup13_SKLWriteResGroup21_SKLWriteResGroup27_SKLWriteResGroup100_1_SKLWriteCMOVA_CMOVBErr_SKLWriteSETA_SETBEr_ZnWriteALULat2_WriteShuffle256_WriteVarShuffle256_WriteVecShiftY_ZnWriteEXTRACTPSr_ZnWriteFPU013Y_ZnWritePShiftY_ZnWriteVINSERT128r_ZnWriteEXTRQ_ZnWriteSHA1MSG1r_Zn2WriteALULat2_Zn2WriteEXTRACTPSr_Zn2WriteVINSERT128r_Zn2WriteEXTRQ_Zn2WriteSHA1MSG1r_Zn2WriteBTRSC
  { 7,  0}, // #4 WriteFAdd64XLd_WriteFCmp64XLd_WriteCvtI2PD_WriteCvtI2PSLd_WriteCvtPD2I_WriteCvtPD2PS_WriteCvtPS2ILd_WriteCvtPS2PD_WriteCvtSD2SSLd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteIMul16_WriteIMul16RegLd_WriteIMul16ImmLd_WriteIMul32Ld_WriteIMul8Ld_WritePHAddX_WritePHAddY_AtomWrite01_7_WriteFLogicLd_WriteFBlendLd_WriteFVarBlendLd_WriteBSFLd_PdWriteBTSIm_PdWriteBTSRm_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteVecALUXLd_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteShuffleXLd_WriteVecLogicXLd_WriteVarBlendLd_WriteBlendLd_WritePCmpIStrM_WritePHAddXLd_WriteShuffleYLd_WriteFLogicYLd_WriteFVarBlendYLd_WriteFBlendYLd_WriteFShuffle256Ld_WriteFCmp64YLd_WriteFCmpYLd_WriteFShuffleYLd_WriteVecShiftImmXLd_PdWriteVBROADCASTF128_PdWriteVEXTRACTF128mr_PdWriteRCL3264rCL_PdWriteRCR3264rCL_PdWriteRCR32riRCR64ri_WriteRMW_WriteAESDecEnc_WriteBEXTRLd_WriteLDMXCSR_WriteMPSAD_WriteVecShiftXLd_WriteVecTestLd_WriteCvtPS2PHYSt_WriteVecALUYLd_WriteFMaskedLoad_WriteMPSADY_WriteVecLogicYLd_WriteBlendYLd_WriteFVarShuffleYLd_WriteVecMaskedLoad_WriteVecShiftImmYLd_WriteVarShuffleYLd_WriteVecShiftYLd_WriteFTestYLd_BWWriteResGroup80_BWWriteResGroup82_BWWriteResGroup90_BWWriteResGroup84_BWWriteResGroup89_BWWriteResGroup87_BWWriteResGroup88_BWWriteResGroup73_BWWriteResGroup77_BWWriteResGroup79_BWWriteResGroup74_BWWriteCMOVA_CMOVBErm_WriteAESIMCLd_WriteAESKeyGenLd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSS2I_WriteVecIMulLd_WritePSADBWLd_WriteVarShuffleLd_WriteFMulXLd_WriteFMulLd_WriteCLMulLd_WritePCmpIStrI_WritePHMINPOSLd_WriteVecIMulXLd_WritePSADBWXLd_WriteVarShuffleXLd_WriteFRcpXLd_WriteFRcpLd_WriteFRsqrtXLd_WriteFRsqrtLd_WriteCvtPS2PDYLd_WriteFMulYLd_WriteFRcpYLd_WriteFRsqrtYLd_WriteFLoadY_WriteFComLd_WriteCvtPH2PSY_WriteCvtPH2PSZ_WriteCvtPS2PHZ_WriteVecLoadY_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVarVecShiftLd_SKXWriteResGroup99_SKXWriteResGroup95_SKXWriteResGroup89_SKXWriteResGroup101_SKXWriteResGroup100_SKXWriteResGroup111_SKXWriteResGroup104_SKXWriteResGroup109_SKXWriteResGroup107_SKXWriteResGroup108_SKXWriteResGroup96_SKXWriteResGroup93_SKXWriteResGroup90_SKXWriteResGroup92_SKXWriteResGroup93z_SKXWriteResGroup97_SKXWriteResGroup103_SKXWriteResGroup106_SKXWriteResGroup110_SKXWriteResGroup112_SKXWriteResGroup113_SKXWriteResGroup114_SKXWriteCMOVA_CMOVBErm_WriteADCLd_WriteCMOVLd_WriteVecInsertLd_WriteCvtPS2PDZLd_WriteFRcpZ_WriteFRsqrtZ_WriteFTestLd_SBWriteResGroup69_SBWriteResGroup25_1_SBWriteResGroup63_SBWriteResGroup68_SBWriteResGroup54_SBWriteResGroup58_SBWriteResGroup59_SBWriteResGroup62_SBWriteResGroup64_SBWriteResGroup66_SBWriteResGroup67_WriteCvtPH2PSYLd_WriteCvtPH2PSZLd_WriteCvtPS2PHZSt_HWWriteResGroup25_HWWriteResGroup37_HWWriteResGroup26_HWWriteResGroup0_1_HWWriteResGroup39_HWWriteXLAT_HWWriteResGroup114_HWWriteResGroup41_HWWriteResGroup17_HWWriteResGroup11_1_HWWriteResGroup36_2_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteFMul64X_WritePMULLDLd_WriteFAdd64YLd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_WriteCvtPS2IYLd_WritePSADBWYLd_WriteVecIMulYLd_WriteFMul64Y_WritePMULLDYLd_SLMWriteResGroup1rm_SKLWriteResGroup94_SKLWriteResGroup91_SKLWriteResGroup85_SKLWriteResGroup96_SKLWriteResGroup95_SKLWriteResGroup103_SKLWriteResGroup98_SKLWriteResGroup102_SKLWriteResGroup100_SKLWriteResGroup101_SKLWriteResGroup92_SKLWriteResGroup89_SKLWriteResGroup86_SKLWriteCMOVA_CMOVBErm_WriteBSRLd_Zn2WriteMul16Ld_Zn2WriteMul32Ld_Zn2WriteMulX32Ld_Zn2WriteMulX64Ld
  { 6,  0}, // #5 WriteFAdd64X_WriteFCmp64X_WriteCvtI2PS_WriteCvtPS2I_WriteCvtSD2SS_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2SD_WriteIMul16Reg_WriteIMul16Imm_WriteIMul32_WriteFLD1_AtomWrite01_6_WriteRMW_PdWriteALURMW_WriteBEXTRLd_WriteBLSLd_WriteFComLd_WriteCRC32Ld_WriteIMul64_WriteIMul64Reg_WriteIMul64Imm_WriteLZCNTLd_WriteVecInsertLd_WriteStore_WriteVecTestLd_WriteTZCNTLd_WriteShuffle256Ld_WriteVarShuffle256Ld_WriteFMaskedStore64Y_WriteFMaskedLoadY_WriteFMaskedStore32Y_WriteVecMaskedStoreY_WriteVecMaskedLoadY_WriteVecTestYLd_WriteFTestYLd_WriteFTestLd_PdWriteXLAT_PdWriteVBROADCASTYLd_PdWriteXADDm_PdWriteMMX_CVTPD2PIirrMMX_CVTPI2PDirr_PdWriteFCOMPm_PdWriteLXADD_PdWriteBMI1m_PdWriteCRC32r32r32_PdWriteMMX_CVTTPD2PIirr_WriteJumpLd_WriteFLoadY_WriteADCLd_WriteALULd_WriteFLogicLd_WriteFBlendLd_WriteBitTestImmLd_WriteBitTestRegLd_WriteBZHILd_WriteCMOVLd_WriteVecALUXLd_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVarShuffleLd_WriteVecShiftLd_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WriteVarShuffleXLd_WriteShiftLd_WriteFRnd_WriteSHDrrcl_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteCvtPS2PHY_WriteFRndY_WriteVecLoadY_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVecShiftImmXLd_BWWriteResGroup69_BWWriteResGroup66_BWWriteResGroup70_BWWriteResGroup58_BWWriteResGroup71_BWWriteResGroup65_BWWriteResGroup62_BWWriteResGroup68_BWWriteResGroup59_BWWriteResGroup64_BWWriteResGroup60_WriteIMul16Ld_WriteIMul16RegLd_WriteIMul32Ld_WriteIMul32RegLd_WriteIMul32ImmLd_WriteIMul8Ld_WritePHAddLd_WriteFLogicYLd_WriteFBlendYLd_WriteFShuffle256Ld_WriteCvtPD2PSY_WriteCvtPD2IY_WriteFShuffleYLd_JWriteVBROADCASTYLd_WriteFLoadX_WriteCvtSD2I_WriteCvtSS2I_WriteFHAdd_WriteVecLoadX_WriteCLMul_WriteCvtPS2PHSt_WriteFHAddY_SKXWriteResGroup86_SKXWriteResGroup72_SKXWriteResGroup81_SKXWriteResGroup87_SKXWriteResGroup88_SKXWriteResGroup71_SKXWriteResGroup76_SKXWriteResGroup84_SKXWriteResGroup92a_SKXWriteResGroup79_SKXWriteResGroup82_SKXWriteResGroup73_SKXWriteResGroup80_SBWriteResGroup48_SBWriteResGroup53_SBWriteResGroup81_SBWriteResGroup49_SBWriteResGroup51_SBWriteResGroup52_WriteCvtPS2PHZ_WriteFRndZ_HWWriteResGroup18_HWWriteResGroup108_HWWriteResGroup0_HWWriteResGroup14_HWWriteResGroup107_HWWriteResGroup11_HWWriteResGroup13_HWWriteResGroup16_HWWriteResGroup102_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteDPPDLd_WriteDPPSLd_WriteIMul16ImmLd_WriteIMul64Ld_WriteIMul64RegLd_WriteIMul64ImmLd_WritePOPCNTLd_WriteFRndLd_WriteFAddYLd_WriteFCmp64YLd_WriteFCmpYLd_WriteDPPSYLd_WriteFRndYLd_SKLWriteResGroup82_SKLWriteResGroup68_SKLWriteResGroup76_SKLWriteResGroup83_SKLWriteResGroup84_SKLWriteResGroup67_SKLWriteResGroup72_SKLWriteResGroup80_SKLWriteResGroup88_SKLWriteResGroup75_SKLWriteResGroup70_SKLWriteResGroup78_SKLWriteResGroup69_ZnWriteALULat2Ld_ZnWriteBTRSCm_ZnWriteSHA1RNDS4r_Zn2WriteALULat2Ld_Zn2WriteBTRSCm_Zn2WriteSHA1RNDS4r
  { 5,  0}, // #6 WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteFComLd_WriteEMMS_WriteIMul32RegLd_WriteIMul32ImmLd_WriteLDMXCSR_WriteFMulXLd_WriteFMul64Ld_WriteVecIMulXLd_WritePSADBWXLd_WriteVarShuffleXLd_WriteFRndLd_AtomWrite1_5_AtomWrite0_1_5_AtomWrite01_5_WriteJumpLd_WriteFLoadX_WriteFLoadY_WriteADCLd_WriteALULd_WriteFAdd64X_WriteAESIMC_WriteAESKeyGen_WriteBitTestImmLd_WriteBitTestRegLd_WriteBZHILd_WriteLoad_WriteCMOVLd_WriteIMul16Imm_WriteVecLoadX_WritePHAdd_WriteVecLoadNT_WriteFMul64X_WritePMULLD_WriteFRcpX_WriteShiftLd_WriteFRsqrtX_WriteFAdd64Y_WriteFAddY_WriteFMAX_WriteFMAY_WriteVecLoadY_WriteVecLoadNTY_WriteFMul64Y_WriteFMulY_WriteFRcpY_WriteFRsqrtY_PdWriteX87Add_PdWriteX87Mul_PdWriteCRC32r32r16_PdWriteCMOVm_WriteCMPXCHG_WriteFHAdd_WriteCLMul_WritePHMINPOS_WriteCvtPS2PHSt_WritePSADBWY_WriteVecIMulY_WriteFHAddY_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVecMaskedStoreY_BWWriteResGroup49_BWWriteResGroup54_BWWriteResGroup57_BWWriteResGroup47_BWWriteResGroup50_BWWriteResGroup51_BWWriteResGroup55_BWWritePCMPGTQ_WriteBLSLd_WriteBSR_WriteTZCNTLd_WriteCvtPH2PS_SKXWriteResGroup61_SKXWriteResGroup58_SKXWriteResGroup69_SKXWriteResGroup63_SKXWriteResGroup67_SKXWriteResGroup62_SKXWriteResGroup65_SKXWriteResGroup66_WriteCvtSD2I_WriteCvtI2SS_WriteCvtSS2I_WriteVecExtractSt_WriteSTMXCSR_WritePSADBWZ_WriteFMAZ_WriteVecIMulZ_WriteFMul64Z_WriteFMulZ_WritePMULLDY_WritePMULLDZ_SBWriteResGroup33_SBWriteResGroup31_SBWriteResGroup41_SBWriteResGroup47_SBWriteResGroup76_SBWriteResGroup35_SBWriteResGroup35_2_SBWriteResGroup36_SBWriteResGroup40_SBWriteResGroup45_SBWriteResGroup46_SBWritePCMPGTQ_HWWriteResGroup0_2_HWWriteResGroup99_HWWriteResGroup88_HWWriteResGroup89_HWWriteResGroup93_HWWriteResGroup94_HWWriteResGroup100_HWWritePCMPGTQ_WriteRMW_SKLWriteResGroup60_SKLWriteResGroup58_SKLWriteResGroup65_SKLWriteResGroup59_SKLWriteResGroup61_SKLWriteResGroup63_WriteBEXTRLd_WriteCvtI2PD_WriteCvtI2PS_WriteCvtPD2I_WriteCvtPS2I_WriteCvtI2SD_WritePOPCNTLd_ZnWriteRSQRTSSr_WriteCvtI2PDY_WriteCvtI2PSY_ZnWriteCVTPD2PSYr_WriteCvtPD2IY_WriteCvtPS2IY_ZnWriteRSQRTPSYr_ZnWriteSTr_ZnWriteXCHGrm_ZnWriteST_FP80m_ZnWriteCVTPD2DQr_ZnWriteEXTRACTPSm_ZnWriteMOVBE_ZnWriteCVSTSI2SIr_ZnWriteCVTDQ2PDr_ZnWriteCVSTSI2SDr_ZnWritePop16r_WriteLZCNTLd_Zn2WriteRSQRTSSr_Zn2WriteRSQRTPSYr_Zn2WriteSTr_Zn2WriteXCHGrm_Zn2WriteST_FP80m_Zn2WriteEXTRACTPSm_Zn2WriteMOVBE_Zn2WritePop16r
  {16,  0}, // #7 WriteBSFLd_WriteBSRLd_WriteDiv8Ld_WriteFHAddLd_WriteIDiv8Ld_WritePCmpIStrILd_WriteFHAddYLd_WriteFDivXLd_BWWriteResGroup150_WritePCmpIStrMLd_WriteFSqrt64X_WriteFSqrtXLd_WriteFSqrtLd_WritePMULLDYLd_BWWriteResGroup153_WriteDPPSLd_WriteFMaskedStore64Y_WriteFMaskedStore32_JWriteLOCK_CMPXCHG8rm_WriteFDivLd_WritePMULLDLd_WriteFRsqrtZLd_SKXWriteResGroup199_HWWriteResGroup120_SKLWriteResGroup177_SKLWriteResGroup178
  { 9,  0}, // #8 WriteBitTestRegLd_WriteFCMOV_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteFHAddLd_WriteFMul64X_WriteFRcpX_WriteFRsqrtX_WriteFHAddYLd_AtomWrite01_9_WriteAESDecEnc_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtSD2SSLd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteFDiv64X_WriteFDivX_WriteIMul16ImmLd_WriteVecIMulLd_WritePSADBWLd_WriteMPSAD_WritePHMINPOSLd_WriteVecIMulXLd_WritePSADBWXLd_WriteFRndLd_WriteFSqrt64X_WriteFSqrtX_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteFDiv64Y_WriteFDivY_WriteFRndYLd_WriteFSqrt64Y_WriteFSqrtY_PdWriteX87Div_PdWriteRCR16rCL_WriteCvtI2PDLd_WriteDPPD_WriteIMul16Ld_WriteIMul32Ld_WriteIMul64Ld_WriteSHDmri_WriteFAdd64YLd_WriteFAddYLd_WriteShuffle256Ld_WriteFShuffle256Ld_WriteFCmp64YLd_WriteFCmpYLd_WriteVarShuffle256Ld_WriteCvtI2PDYLd_WriteFMul64YLd_WriteFMulYLd_WriteFVarShuffle256Ld_WritePHAddYLd_WriteVarVecShiftYLd_BWWriteResGroup101_BWWriteResGroup105_BWWriteResGroup112_BWWriteResGroup106_BWWriteResGroup107_BWWriteResGroup108_BWWriteResGroup113_WriteIMul64RegLd_WriteIMul64ImmLd_WriteFMul64XLd_WriteFMul64Ld_WritePMULLDLd_WriteSHDmrcl_WriteFVarShuffleYLd_WriteVecTestYLd_WriteFTestYLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64Ld_WriteFCmpLd_WriteFMulLd_WritePHAddXLd_WriteVecTestLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFVarBlendYLd_WriteFVarBlendZLd_WriteCvtI2PDZLd_WriteCvtI2PSZLd_WriteCvtPH2PSLd_WriteFRsqrtZ_SKXWriteResGroup135_SKXWriteResGroup137_SKXWriteResGroup136_SKXWriteResGroup146_SKXWriteResGroup143_SBWriteResGroup98_WriteFAdd64XLd_WriteFAddXLd_SBWriteResGroup100_WriteRMW_WriteFCmp64XLd_WriteFCmpXLd_WritePOPCNTLd_WriteFMaskedLoadY_WriteVarBlendYLd_WriteVarBlendZLd_WriteVecMaskedLoadY_SBWriteResGroup97_2_SBWriteResGroup95_SBWriteResGroup93_SBWriteResGroup99_SBWriteResGroupVzeroall_WriteCMPXCHGRMW_HWWriteResGroup69_WriteVarVecShiftLd_HWWriteResGroup66_HWWriteResGroup68_HWWriteResGroup76_HWWriteResGroup52_HWWriteResGroup53_1_HWWriteResGroup78_1_HWWriteResGroup80_HWWriteResGroup87_SKLWriteResGroup120_SKLWriteResGroup123_SKLWriteResGroup121_SKLWriteResGroup131_SKLWriteResGroup128_ZnWriteMul64Ld_WriteStore_WriteVecShiftYLd_ZnWriteFPU02_ZnWriteVINSERT128Ld_ZnWriteFPU01Op2Y_ZnWriteFPU013LdY_ZnWriteSHA1MSG1Ld_Zn2WriteFPU02_Zn2WriteVINSERT128Ld_Zn2WriteFPU01Op2Y_Zn2WriteSHA1MSG1Ld
  {11,  0}, // #9 AtomWrite01_11_WriteFHAdd_WriteVecMoveToGpr_WriteVecMoveFromGpr_WritePCmpIStrI_WriteFHAddY_PdWriteRCR8rCL_PdWriteRCL16ri_WriteFDivX_BWWriteResGroup122_1_WritePCmpIStrM_WriteFRndLd_WriteSHDmrcl_WriteFSqrtX_WritePSADBWYLd_WriteFMAYLd_WriteVecIMulYLd_WriteFHAddYLd_WriteFRcpY_WriteFRsqrtY_BWWriteResGroup133_BWWriteResGroup123_BWWriteResGroup128_BWWriteResGroup131_BWWriteResGroup132_WriteCMPXCHGRMW_WriteDPPS_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_JWriteCMPXCHG8B_JWriteCMPXCHG8rm_WriteCvtSD2ILd_WriteCvtSS2ILd_SKXWriteResGroup159_WriteFMAZLd_WriteFAdd64YLd_WriteFAdd64ZLd_WriteFAddYLd_WriteFAddZLd_WriteFCmp64YLd_WriteFCmpYLd_WriteFCmpZLd_WriteFDivY_WriteVecIMulZLd_WriteFCmp64ZLd_WriteMPSADYLd_WriteFMul64YLd_WriteFMul64ZLd_WriteFMulYLd_WriteFMulZLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_SKXWriteResGroup171_SKXWriteResGroup162_SKXWriteResGroup160_SKXWriteResGroup161_SKXWriteResGroup166_SKXWriteResGroup164_SKXWriteResGroup169_SKXWriteResGroup170_SKXWriteResGroup163_SKXWriteResGroup167_WriteFHAddLd_WriteFMul64XLd_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePCmpEStrMLd_WritePHMINPOSLd_WriteVecIMulXLd_WritePMULLDLd_WritePSADBWXLd_WriteFRcpXLd_WriteFRcpLd_WriteFRsqrtXLd_WriteFRsqrtLd_WriteCvtPD2PSZLd_WriteCvtPD2IZLd_WriteVecShiftYLd_WriteVecShiftZLd_SBWriteResGroup108_SBWriteResGroup104_SBWriteResGroup106_WriteCLMul_WriteFMAXLd_WriteVecTestYLd_WriteFRsqrtZ_HWWriteResGroup131_HWWriteFRNDINT_HWWriteResGroup91_2_HWWriteResGroup75_HWWriteResGroup129_HWWriteResGroup130_SKLWriteResGroup145_SKLWriteResGroup156_SKLWriteResGroup151_SKLWriteResGroup149_SKLWriteResGroup146_SKLWriteResGroup147_SKLWriteResGroup152_SKLWriteResGroup150_SKLWriteResGroup154_SKLWriteResGroup155_WriteAESDecEncLd_WriteAESIMCLd_WriteAESKeyGenLd_ZnWriteCVTPD2PSLd_ZnWriteCVTSS2SDLd_ZnWriteFPU3_WriteVecIMulLd_ZnWriteCVTPD2PSYLd_WriteFRndYLd_ZnWriteFILD_ZnWriteSHA256RNDS2Ld_Zn2WriteFPU3_Zn2WriteFILD_Zn2WriteCVSTSI2SILd_Zn2WriteSHA256RNDS2Ld
  {15,  0}, // #10 WriteCMPXCHG_WriteSTMXCSR_WriteDiv16_WriteDPPD_WriteIDiv16_WritePCmpEStrMLd_PdWriteVFRCZm_PdWriteVFRCZYm_WritePMULLDLd_BWWriteResGroup149_BWWriteResGroup147_WriteDiv8Ld_WriteIDiv8Ld_WriteDPPDLd_WriteFRndYLd_WriteFRndZLd_SKXWriteResGroup195_SKXWriteResGroup191_SKXWriteResGroup194_SBWriteResGroup119_HWWriteResGroup115_HWWriteFXTRACT_SKLWriteResGroup174_SKLWriteResGroup171_WriteFDiv64X_WriteFDivX_ZnWriteVDIVPDY
  { 8,  0}, // #11 WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSS2I_WriteFHAdd_WriteIMul16Ld_WritePHAddXLd_WriteFHAddY_WritePHAddYLd_AtomWrite01_8_WriteBSRLd_WriteIMul16RegLd_WriteIMul32Ld_WriteIMul32RegLd_WriteIMul32ImmLd_WriteIMul8Ld_WriteVarShuffleLd_WriteVecShiftLd_WritePOPCNTLd_WriteVarShuffleXLd_WriteVecShiftXLd_WriteCvtI2PDY_WriteCvtPD2PSY_WriteCvtPD2IY_WriteCvtPH2PSY_WriteCvtPS2PDY_WriteCvtPS2PHY_WriteFVarShuffleYLd_WriteFVarShuffleLd_WriteVarVecShiftLd_PdWriteVPERM2F128rm_PdWriteRCL3264ri_PdWriteVMPSADBW_WriteCMPXCHGRMW_BWWriteResGroup100_WriteFAdd64XLd_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteBSFLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteFComLd_WriteCRC32Ld_WriteCvtPS2ILd_WriteCvtSD2ILd_WriteCvtSD2SSLd_WriteCvtSS2SDLd_WriteCvtSS2ILd_WriteIMul16ImmLd_WriteIMul64RegLd_WriteIMul64ImmLd_WriteLZCNTLd_WritePHAddLd_WriteFMul64XLd_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WriteTZCNTLd_WriteFVarBlendYLd_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_WriteCvtPS2IYLd_WriteCvtPS2PDYLd_WriteFMaskedLoadY_WriteVarBlendYLd_WriteVecMaskedLoadY_BWWriteResGroup97_BWWriteResGroup91_BWWriteResGroup99_BWWriteResGroup154_BWWriteResGroup92_WriteAESDecEncLd_WriteCvtI2PSLd_WriteVecMoveFromGpr_WriteMPSADLd_WritePCmpIStrM_WriteVecTestLd_WriteFRndLd_WriteFAdd64YLd_WriteFAddYLd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteFRndYLd_WriteFTestLd_SKXWriteResGroup130_WriteAESIMC_WriteFVarBlendLd_WritePSADBWLd_WriteVarBlendLd_WriteShuffleYLd_WriteShuffleZLd_WriteFLogicYLd_WriteFLogicZLd_WriteFBlendYLd_WriteCvtPD2PSZLd_WriteCvtPD2IZLd_WriteCvtPS2IZLd_WriteCvtPS2PDZLd_WriteCvtPS2PHYSt_WriteCvtPS2PHZSt_WriteFRndZ_WriteVecALUYLd_WriteVecALUZLd_WriteFShuffleYLd_WriteFShuffleZLd_WriteVecLogicYLd_WriteVecLogicZLd_WriteBlendYLd_WriteVarBlendZLd_WriteFVarShuffleZLd_WriteVecShiftImmYLd_WriteVecShiftImmZLd_WriteVarVecShiftYLd_WriteVarVecShiftZLd_WriteVarShuffleYLd_WriteVarShuffleZLd_WriteVecShiftYLd_WriteVecShiftZLd_SKXWriteResGroup127_SKXWriteResGroup128_SKXWriteResGroup118_SKXWriteResGroup119_SKXWriteResGroup121_SKXWriteResGroup123_SKXWriteResGroup131_SKXWriteResGroup132_SKXWriteResGroup133_SKXWriteResGroup134_WriteAESKeyGenLd_WriteVecALULd_WriteSHDmri_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteCvtPH2PSZLd_WriteFVarShuffle256Ld_WriteFTestYLd_SBWriteResGroup86_SBWriteResGroup84_SBWriteResGroup77_SBWriteResGroup83_SBWriteResGroup85_SBWriteResGroup87_SBWriteCMOVA_CMOVBErm_HWWriteResGroup12_HWWriteResGroup48_HWWriteResGroup46_HWWriteResGroup47_HWWriteResGroup145_HWWriteResGroup11_2_HWWriteResGroup13_1_HWWriteResGroup17_2_HWWriteCMOVA_CMOVBErm_WriteAESIMCLd_WriteFRcpXLd_WriteFRcpLd_WriteFRsqrtXLd_WriteFRsqrtLd_WriteFMulYLd_WriteFRcpYLd_WriteFRsqrtYLd_SKLWriteResGroup119_SKLWriteResGroup116_SKLWriteResGroup117_SKLWriteResGroup107_SKLWriteResGroup108_SKLWriteResGroup110_SKLWriteResGroup112_WriteFLoadX_WriteFLoadY_WriteFLogicLd_WriteFBlendLd_WriteLoad_WriteVecALUXLd_ZnWriteMul16Ld_ZnWriteMul32Ld_WriteFShuffleLd_WriteVecLoadX_ZnWriteFPU13_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteVecLoadNT_WriteFStoreNT_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WriteVecLoadY_WriteVecLoadNTY_WriteVecShiftImmXLd_WriteVecTestYLd_ZnWriteLEAVE_ZnWritePushA_ZnWritePCMPGTQm_ZnWriteBROADCAST_ZnWriteFPU12Ym_ZnWriteFPU01Op2_ZnWriteVPBROADCAST256Ld_ZnWritePCMPGTQYm_ZnWriteFPU0Lat1Ld_ZnWriteMulX32Ld_ZnWriteMulX64Ld_ZnWriteFPU013Ld_ZnWriteVPBROADCAST128Ld_ZnWriteFPU013m_ZnWriteSHA1MSG2Ld_ZnWriteSHA1NEXTELd_Zn2WriteMul64Ld_Zn2WriteFPU13_Zn2WriteLEAVE_Zn2WritePushA_Zn2WritePCMPGTQm_Zn2WriteBROADCAST_Zn2WriteFPU12Ym_Zn2WriteFPU01Op2_Zn2WriteVPBROADCAST256Ld_Zn2WritePCMPGTQYm_Zn2WriteFPU0Lat1Ld_Zn2WriteFPU013Ld_Zn2WriteFPU013LdY_Zn2WriteVPBROADCAST128Ld_Zn2WriteFPU013m_Zn2WriteSHA1MSG2Ld_Zn2WriteSHA1NEXTELd
  {50,  0}, // #12 WriteDiv16Ld_WriteDiv32Ld_WriteDiv8
  {130,  0}, // #13 WriteDiv64Ld_WriteIDiv64Ld_AtomWrite01_130
  {68,  0}, // #14 WriteDiv8Ld_AtomWrite01_68
  {125,  0}, // #15 WriteFDiv64XLd_WriteFSqrt64XLd
  {70,  0}, // #16 WriteFDivXLd_WriteFSqrtXLd
  {34,  0}, // #17 WriteFDivLd_WriteFSqrtLd_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_BWWriteResGroup191_JWriteMASKMOVDQU_SBWriteResGroup131_WriteAESKeyGenLd_HWWriteResGroup166_WriteFDiv64
  {62,  0}, // #18 WriteFDiv64Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv8Ld_WriteFSqrt64Ld_SKXWriteResGroup258_SKLWriteResGroup217
  {10,  0}, // #19 AtomWrite01_10_WriteFMul64XLd_WriteFRcpXLd_WriteFRsqrtXLd_WriteFAdd64XLd_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteAESIMCLd_WriteAESKeyGenLd_WriteIMul64Ld_WriteIMul64RegLd_WriteIMul64ImmLd_WritePHAddLd_WriteMMXMOVMSK_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePCmpEStrM_WritePMULLDLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFAdd64YLd_WriteFAddYLd_WriteFMAXLd_WriteFMAYLd_WriteFMul64YLd_WriteFMulYLd_WriteFRcpYLd_WriteFRsqrtYLd_PdWriteCRC32r64r64_PdWriteRCL16rCL_PdWriteRCR16ri_PdWriteVFRCZP_PdWriteVFRCZS_PdWriteVFRCZY_WriteFHAddLd_WriteVecIMulLd_WritePSADBWLd_WriteCLMulLd_WritePHMINPOSLd_WriteVecIMulXLd_WritePSADBWXLd_WritePMULLDY_WriteVecTestYLd_BWWriteResGroup120_BWWriteResGroup115_BWWriteResGroup117_WriteAESDecEncLd_WriteFCmp64XLd_WriteFCmpXLd_WriteEMMS_WriteMPSADLd_WritePCmpIStrI_WritePCmpIStrM_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteCvtPH2PSYLd_WriteCvtPH2PSZLd_WritePSADBWYLd_WritePSADBWZLd_WriteFVarShuffle256Ld_WritePHAddYLd_WritePMULLDZ_SKXWriteResGroup148_SKXWriteResGroup157_SKXWriteResGroup149_SKXWriteResGroup153_SKXWriteResGroup154_SKXWriteResGroup151_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtSD2ILd_WriteCvtSD2SSLd_WriteCvtI2SSLd_WriteCvtSS2ILd_WriteSHDmrcl_WriteFMAZLd_WriteFAdd64ZLd_WriteFAddZLd_WriteFCmp64YLd_WriteFCmpYLd_WriteFCmpZLd_WriteCvtI2PDYLd_WriteCvtI2PDZLd_WriteCvtI2PSYLd_WriteCvtI2PSZLd_WriteCvtPS2IYLd_WriteCvtPS2IZLd_WriteFRndYLd_WriteFRndZLd_WriteFCmp64ZLd_SBWriteResGroup101_WriteSHDmri_WriteVarVecShiftYLd_WriteVarVecShiftZLd_HWWriteResGroup52_1_HWWriteResGroup97_HWWriteResGroup77_HWWriteResGroup78_WriteBSF_WriteBSR_WriteMPSADYLd_SKLWriteResGroup133_SKLWriteResGroup143_SKLWriteResGroup134_SKLWriteResGroup138_SKLWriteResGroup139_SKLWriteResGroup140_WriteFCmp64Ld_WriteFCmpLd_WriteFComLd_WriteCRC32Ld_ZnWriteCVTPS2PDLd_Zn2WriteCVTPD2PSLd_Zn2WriteCVTPS2PDLd_Zn2WriteCVTSS2SDLd_Zn2WriteCVTPD2PSYLd_Zn2WriteVDIVPSYr_WritePMULLDYLd_Zn2WriteCVTPD2DQLd
  {12,  0}, // #20 WriteIMul64Ld_WriteIMul64RegLd_WriteDiv8_WriteVecExtract_WriteIDiv8_WriteFMOVMSK_WriteCLMul_WritePCmpIStrMLd_WriteVecMOVMSK_PdWriteRCL8rCL_PdWriteRCR8ri_PdWriteVPCLMULQDQrr_WriteAESDecEncLd_WriteMPSADLd_WriteFRndYLd_BWWriteResGroup135_WriteCvtSD2ILd_WriteCvtSD2SSLd_WriteCvtSS2SDLd_WriteCvtSS2ILd_WritePCmpIStrILd_WriteDPPSY_WriteFHAddLd_WriteCLMulLd_WriteFSqrtX_WriteFSqrtY_SKXWriteResGroup179_SKXWriteResGroup200_SKXWriteResGroup174_SKXWriteResGroup174z_SKXWriteResGroup175_SKXWriteResGroup176_SKXWriteResGroup177_WriteAESIMC_WritePSADBWYLd_WritePSADBWZLd_WriteVecIMulYLd_WriteVecIMulZLd_WriteFHAddYLd_WriteFMul64YLd_WriteFMul64ZLd_WriteFMulYLd_WriteFMulZLd_WritePMULLDYLd_WritePMULLDZLd_SBWriteResGroup111_WriteFRndLd_WriteSHDmrcl_WriteFMAZLd_WriteFMAYLd_HWWriteResGroup91_3_HWWriteResGroup104_SKLWriteResGroup160_WriteCvtI2PDLd_WriteCvtI2PSLd_WriteCvtPD2ILd_WriteCvtPS2ILd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteFRcpXLd_WriteFRcpLd_WriteFRsqrtXLd_ZnWriteRSQRTSSLd_WriteFMALd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPD2IYLd_WriteCvtPS2IYLd_ZnWriteVDIVPSYr_WriteFMAXLd_WriteFRcpYLd_ZnWriteRSQRTPSYLd_ZnWriteFIST_ZnWriteCVTPD2DQLd_ZnWriteCVSTSI2SILd_ZnWriteFPU03_Zn2WriteRSQRTSSLd_Zn2WriteRSQRTPSYLd_Zn2WriteFIST_Zn2WriteFPU03
  {14,  0}, // #21 WriteIMul64ImmLd_AtomWrite01_14_WriteAESDecEncLd_WriteDiv32_WriteDiv64_WriteFDiv64XLd_WriteFDivXLd_WriteFDivLd_WriteFDiv64Ld_WriteIDiv32_WriteIDiv64_WriteMPSADLd_WritePCmpEStrI_WriteFSqrt64XLd_WriteFSqrtXLd_WriteFSqrt64Ld_WriteFSqrtLd_WriteFDiv64YLd_WriteFDivYLd_WriteFSqrt64YLd_WriteFSqrtYLd_WriteAESIMC_BWWriteResGroup139_1_WriteDPPDLd_WriteDPPS_WriteDPPSY_BWWriteResGroup146_BWWriteResGroup145_BWWriteResGroup141_BWWriteResGroup144_WritePCmpEStrM_WriteAESIMCLd_SKXWriteResGroup184_WriteFRndLd_SKXWriteResGroup184_1_SKXWriteResGroup190_SKXWriteResGroup187_SKXWriteResGroup188_SKXWriteResGroup189_WriteCLMulLd_WriteMPSADYLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_WriteFRsqrtZLd_HWWriteResGroup142_SKLWriteResGroup166_SKLWriteResGroup166_1_SKLWriteResGroup170_SKLWriteResGroup169
  { 3,  0}, // #22 WriteVecMoveToGpr_WritePHAdd_WriteMMXMOVMSK_WriteVecShiftLd_WriteFMOVMSK_WriteVecMOVMSK_WriteVecShiftXLd_AtomWrite01_3_WriteCMPXCHGRMW_WriteSHDrri_WriteBSF_WriteFLDC_WriteFLD0_WriteFLD1_WriteVarShuffle_WriteFStoreNTX_WriteVarShuffleX_WriteSHDrrcl_WriteFStoreNTY_WriteFVarShuffleY_WriteVarVecShift_PdWriteCMPXCHG8rm_PdWriteCMPXCHG8rr_PdWriteCMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm_PdWriteCMPXCHG8B_PdWriteCMPXCHG16B_PdWriteSHLD16rrCLSHLD32rrCLSHRD32rrCL_PdWriteEXTRQ_PdWriteINSERTQI_PdWriteSHLD32rri8SHRD16rri8_WriteFAdd64X_WriteFAddX_WriteBSR_WriteFCMOV_WriteFCmp64X_WriteFCmpX_WriteFCom_WriteCRC32_WriteCvtPD2I_WriteCvtPD2PS_WriteCvtPS2I_WriteCvtPS2PD_WriteCvtSD2I_WriteCvtSD2SS_WriteCvtSS2SD_WriteCvtSS2I_WriteIMul16Reg_WriteIMul32Reg_WriteIMul32Imm_WriteIMul64Reg_WriteIMul64Imm_WriteIMul8_WriteLZCNT_WriteFMul64X_WriteFMulX_WritePHAddX_WritePOPCNT_WriteRotateCL_WriteShiftCL_WriteTZCNT_WriteFAdd64Y_WriteFAddY_WriteShuffle256_WriteFShuffle256_WriteFCmp64Y_WriteFCmpY_WriteVarShuffle256_WriteCvtPD2PSY_WriteCvtPD2IY_WriteCvtPS2IY_WriteCvtPS2PDY_WriteFMul64Y_WriteFMulY_WriteFVarShuffle256_WritePHAddY_WriteVecMOVMSKY_WriteVarVecShiftY_BWWriteResGroup27_BWWriteResGroup34_BWWriteResGroup35_BWWriteResGroup38_BWWriteResGroup37_BWWriteResGroup28_BWWriteResGroup33_BWWriteSETA_SETBEm_WriteAESDecEnc_WriteLoad_WriteCvtI2PD_WriteCvtI2PS_WriteVecExtractSt_WriteLDMXCSR_WriteMPSAD_WriteVecTest_WriteFRnd_WriteFVarBlendY_WriteCvtI2PDY_WriteCvtI2PSY_WriteCvtPH2PSY_WriteCvtPS2PH_WriteFRndY_WriteFTest_JSlowLEA16r_JWriteCMPXCHG8rr_WritePSADBW_WritePSADBWX_WriteCvtPD2PSZ_WriteCvtPD2IZ_WriteCvtPS2IZ_WriteCvtPS2PDZ_WritePSADBWY_WritePSADBWZ_WriteVecTestY_SKXWriteResGroup42_SKXWriteResGroup34_SKXWriteResGroup44_SKXWriteResGroup48_SKXWriteResGroup47_SKXWriteResGroup45_SKXWriteResGroup43_SKXWriteResGroup31_SKXWriteResGroup32_SKXWriteResGroup41_SKXWriteResGroup37_SKXWriteResGroup38_SKXWriteResGroup30_SKXWritePCMPGTQ_SKXWriteSETA_SETBEm_WriteVecALU_WriteFAdd64Z_WriteFAddZ_WriteFCmpZ_WriteCvtI2PSZ_WriteCvtPH2PSZ_WriteCvtPS2PHY_WriteCvtPS2PHZ_WriteFRndZ_WriteFCmp64Z_SBWriteResGroup21_SBWriteResGroup22_SBWriteResGroup26_2_SBWriteCMOVA_CMOVBErr_SBWriteSETA_SETBEm_WriteVarVecShiftZ_HWWriteResGroup50_HWWriteResGroup58_HWWriteResGroup59_HWWriteResGroup45_HWWriteResGroup44_HWWriteResGroup51_HWWriteResGroup57_HWWriteCMOVA_CMOVBErr_HWWriteSETA_SETBEm_WriteFLoadX_WriteFLoadY_WriteDPPD_WriteDPPS_WriteIMul16Imm_WriteVecLoadX_WriteVecLoadNT_WriteDPPSY_WriteVecLoadY_WriteFMaskedLoadY_WriteVecLoadNTY_WriteVecMaskedLoadY_SKLWriteResGroup40_SKLWriteResGroup32_SKLWriteResGroup42_SKLWriteResGroup46_SKLWriteResGroup45_SKLWriteResGroup43_SKLWriteResGroup41_SKLWriteResGroup29_SKLWriteResGroup30_SKLWriteResGroup39_SKLWriteResGroup35_SKLWriteResGroup36_SKLWritePCMPGTQ_SKLWriteSETA_SETBEm_ZnWriteCVTPS2PDr_ZnWriteMul16_ZnWriteMul32_WriteVecMoveFromGpr_ZnWriteVCVTPS2PDY_ZnWriteMulX32_ZnWriteMulX64_Zn2WriteCVTPD2PSr_Zn2WriteCVTPS2PDr_Zn2WriteCVTSS2SDr_Zn2WriteMul16_Zn2WriteMul32_Zn2WriteCVTPD2PSYr_Zn2WriteVCVTPS2PDY_WritePMULLDY_Zn2WriteCVTPD2DQr_Zn2WriteCVTDQ2PDr_Zn2WriteMulX32_Zn2WriteMulX64
  { 4,  0}, // #23 WritePHAddLd_WriteVecIMulLd_WritePSADBWLd_WriteFMulLd_WriteVarShuffleX_WriteFRcpLd_WriteFRsqrtLd_WriteSHDmrcl_WriteSHDmri_AtomWrite01_4_WriteBSR_WriteCvtI2PS_WriteCvtPS2I_WriteCvtSD2SS_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2SD_WriteIMul16_WriteIMul16Reg_WriteIMul32_WriteIMul32Reg_WriteIMul32Imm_WriteIMul8_WritePHMINPOS_WriteVecIMulX_WritePOPCNT_WritePSADBWX_WriteFRnd_WriteCvtI2PSY_WriteCvtPS2IY_WriteCvtPS2PHYSt_WriteCvtPS2PHSt_WriteFRndY_PdWriteMMX_CVTPI2PSirr_PdWriteMOVQ2DQrr_PdWriteVPERM2F128rr_PdWriteVPMACS_WriteCvtI2PD_WriteIMul16Imm_WriteIMul64_WriteCvtI2PDY_WriteVecShiftY_WriteVecTestY_BWWriteResGroup42_BWWriteResGroup44_BWWriteResGroup39_BWWriteResGroup45_BWWriteResGroup41_BWWriteResGroup43_BWWriteResGroup40_WriteJumpLd_WriteADCLd_WriteALULd_WriteBEXTRLd_WriteBSF_WriteBitTestImmLd_WriteBitTestRegLd_WriteCMOVLd_WriteFHAdd_WriteLZCNTLd_WriteVecMoveToGpr_WriteVecInsertLd_WriteFMul64X_WritePMULLD_WriteStore_WritePOPCNTLd_WriteShiftLd_WriteSHDrrcl_WriteFHAddY_WriteFMul64Y_WriteFVarShuffleY_WriteFTestY_WriteFAdd64X_WriteFAddX_WriteAESDecEnc_WriteFCmp64X_WriteFCmpX_WriteMPSAD_WriteFMulX_WriteFRcpX_WriteFRsqrtX_WriteFAdd64Y_WriteFAdd64Z_WriteFAddY_WriteFAddZ_WriteFCmp64Y_WriteFCmpY_WriteFCmpZ_WriteCvtI2PDZ_WriteCvtI2PSZ_WriteFMAX_WriteFMAY_WriteFMAZ_WriteVecIMulY_WriteVecIMulZ_WriteFCmp64Z_WriteMPSADY_WriteFMul64Z_WriteFMulY_WriteFMulZ_WriteVecShiftZ_WriteFRcpY_WriteFRcpZ_WriteFRsqrtY_SKXWriteResGroup54_SKXWriteResGroup55_SKXWriteResGroup50_SKXWriteResGroup57_SKXWriteResGroup49_SKXWriteResGroup50z_SKXWriteResGroup51_WriteCvtPD2I_WriteCvtPD2PS_WritePCmpEStrILd_WriteCvtPD2PSY_WriteCvtPD2PSZ_WriteCvtPD2IY_WriteCvtPD2IZ_WriteCvtPS2PHZSt_SBWriteResGroup29_2_HWWriteResGroup73_HWWriteMOVS_HWWriteResGroup62_HWWriteResGroup70_HWWriteResGroup81_HWWriteResGroup72_HWWriteResGroup61_HWWriteCMPS_HWWriteResGroup71_HWWriteResGroup83_WriteCMPXCHGRMW_WriteFLogicLd_WriteFBlendLd_WriteFVarBlend_WriteRMW_WriteCvtPS2PD_WriteCvtSD2I_WriteCvtSS2I_WriteVecExtractSt_WriteVecALUXLd_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteMMXMOVMSK_WriteVarShuffleLd_WriteVecShiftLd_WriteFMOVMSK_WriteShuffleXLd_WriteVecLogicXLd_WriteVarBlendLd_WriteBlendLd_WritePHAddXLd_WriteVecMOVMSK_WriteVarShuffleXLd_WriteVecShiftXLd_WriteVecTestLd_WriteRotateLd_WriteRotateCLLd_WriteShiftCLLd_WriteShuffleYLd_WriteFLogicYLd_WriteCvtPS2PDY_WritePSADBWY_WriteVecALUYLd_WriteFShuffleYLd_WriteVecLogicYLd_WriteBlendYLd_WriteFVarShuffleYLd_WriteFVarShuffleLd_WritePHAddYLd_WriteVecMOVMSKY_WritePMULLDY_WriteVecShiftImmXLd_WriteVecShiftImmYLd_WriteVarVecShiftLd_WriteVarShuffleYLd_WriteVecShiftYLd_WriteVecTestYLd_WriteFTestYLd_WriteFTestLd_SLMWriteResGroup1rr_SKLWriteResGroup53_SKLWriteResGroup55_SKLWriteResGroup54_SKLWriteResGroup48_SKLWriteResGroup57_SKLWriteResGroup47_WriteAESIMC_WriteAESKeyGen_ZnWriteCVTPD2PSr_ZnWriteCVTSS2SDr_ZnWriteMul64_WriteIMulH_WriteFMaskedStore64_WriteFMaskedStore32_WriteVecMaskedStore_ZnWriteCVTPS2PIr_ZnWritePUSH_ZnWriteINSERTQ_ZnWriteSHA256RNDS2r_Zn2WriteMul64_Zn2WriteCVTPS2PIr_Zn2WriteCVSTSI2SIr_Zn2WriteCVSTSI2SDr_Zn2WritePUSH_Zn2WriteINSERTQ_Zn2WriteSHA256RNDS2r
  { 1,  0}, // #24 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd_WriteRMW
  { 1,  0}, // #25 WriteRMW
  {71,  0}, // #26 WriteFSqrt80_AtomWrite01_71_WriteFSqrt64X_WriteFSqrt64Y
  {13,  0}, // #27 AtomWrite01_13_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSS2I_WriteVecExtractSt_WriteCvtI2PDYLd_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteCvtPS2PDYLd_PdWriteRCL8ri_PdWriteCVTSI642SDrr_CVTSI642SSrr_CVTSI2SDr_CVTSI2SSrr_WriteMPSADYLd_WritePCmpIStrMLd_WriteFMaskedStore64_WriteDPPS_WriteDPPSY_WriteFHAddYLd_SKXWriteResGroup180_SKXWriteResGroup181_SKXWriteResGroup183_WriteAESDecEncLd_WriteMPSADLd_SBWriteResGroup114_WriteFDivX_WriteFRndYLd_WriteFRndZLd_HWWriteResGroup103_WriteBSFLd_WriteBSRLd_SKLWriteResGroup162_SKLWriteResGroup163_ZnWriteSHA1RNDS4Ld_Zn2WriteVDIVPDY_Zn2WriteSHA1RNDS4Ld
  {17,  0}, // #28 AtomWrite01_17_WriteCLMulLd_WriteFDivY_WriteFRcpYLd_WriteFRsqrtYLd_WriteDiv16_WriteIDiv16_WriteDPPSYLd_JWriteLOCK_CMPXCHGrm_SKXWriteResGroup201_WriteFSqrtLd_WritePMULLDYLd_WritePMULLDZLd_SKXWriteResGroup202_WritePCmpIStrILd_WritePCmpIStrMLd_WriteFSqrtXLd_HWWriteResGroup147_HWWriteResGroup132_WritePCmpEStrMLd_SKLWriteResGroup179_SKLWriteResGroup180_Zn2WriteVDIVPSYLd
  {18,  0}, // #29 AtomWrite01_18_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteDiv32Ld_WriteDiv64Ld_WriteIDiv32Ld_WriteIDiv64Ld_WritePCmpEStrI_BWWriteResGroup160_BWWriteResGroup159_WriteFSqrt64X_WriteFSqrtXLd_WriteFDivYLd_WriteFDivZ_WriteFSqrt64Y_SKXWriteResGroup208_SKXWriteResGroup207_SKXWriteResGroup205_WriteAESIMCLd_WriteDPPSLd_WriteFDivLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_WriteFRsqrtZLd_HWWriteResGroup149_SKLWriteResGroup185_SKLWriteResGroup184
  {20,  0}, // #30 AtomWrite01_20_WriteDPPDLd_WriteDPPSYLd_BWWriteResGroup167_BWWriteResGroup165_WriteDiv16Ld_WriteIDiv16Ld_WriteAESKeyGen_SKXWriteResGroup216_WriteFSqrtZ_SKXWriteResGroup220_SKXWriteResGroup219_SKXWriteResGroup215_SKXWriteResGroup214_SKXWriteResGroup218_WriteFDivXLd_WriteFDivLd_WriteFSqrtXLd_WriteFSqrtLd_WriteAESIMCLd_WriteFDiv64X_WriteDPPSLd_HWWriteResGroup156_HWWriteResGroup154_SKLWriteResGroup190_SKLWriteResGroup193_SKLWriteResGroup192_SKLWriteResGroup189_WriteFSqrt64X_WriteFSqrt80_Zn2WriteVDIVPDYLd_WriteFSqrt64Y
  {21,  0}, // #31 AtomWrite01_21_WriteFSqrt64XLd_WriteFSqrt64Ld_WriteFSqrtY_BWWriteResGroup171_BWWriteResGroup169_WriteFSqrtX_WriteFSqrt80_SKXWriteResGroup222_WriteFDivY_WriteFDivZ_WriteDPPSYLd_WriteFSqrtZ_HWWriteResGroup144_WritePCmpEStrILd_SKLWriteResGroup195_WriteDiv16Ld_WriteIDiv16Ld
  {22,  0}, // #32 AtomWrite01_22_BWWriteResGroup172_BWWriteResGroup183_1_WriteFMaskedStore32Y_SKXWriteResGroup223_SKXWriteResGroup224_2_SKXWriteResGroup225_WriteFDiv64X_WriteDiv8_WriteFSqrt64XLd_HWWriteResGroup146_WriteFDivLd_SKLWriteResGroup196_SKLWriteResGroup196_1_WriteFDiv64XLd_WriteFDivXLd_WriteFDiv64Ld_ZnWriteVDIVPDYLd
  {23,  0}, // #33 AtomWrite01_23_WritePCmpEStrILd_WriteFSqrt80_WriteFDiv64Y_WriteFDivYLd_BWWriteResGroup176_BWWriteResGroup183_2_WriteFSqrt64Ld_WriteFDiv64Z_SKXWriteResGroup228_WriteIDiv8_HWWriteResGroup151_HWWriteResGroup190_WriteFSqrtLd_SKLWriteResGroup198
  {25,  0}, // #34 AtomWrite01_25_WriteDPPS_WriteDiv8_WriteIDiv16_WriteIDiv32_WriteIDiv64_WriteIDiv8_BWWriteResGroup183_4_WriteDiv32_WriteAESKeyGenLd_WritePCmpEStrMLd_WriteFDivZLd_WriteFSqrt64YLd_SKXWriteResGroup233_SKXWriteResGroup224_3_SKXWriteResGroup234_WriteDiv16_WriteDiv64_WriteFDiv64Ld_HWWriteResGroup187_HWWriteResGroup192_SKLWriteResGroup202_SKLWriteResGroup196_2
  {26,  0}, // #35 AtomWrite01_26_BWWriteResGroup180_BWWriteResGroup183_5_BWWriteResGroup183_6_WriteFSqrtXLd_WriteFSqrtLd_SKXWriteResGroup238_WriteFDiv64XLd_HWWriteResGroup184
  {29,  0}, // #36 AtomWrite01_29_WriteAESKeyGen_WriteFDiv64YLd_WriteFSqrt64Y_BWWriteResGroup182_BWWriteResGroup185_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_SKXWriteResGroup242_WriteFDivY_WriteFDivZ_WriteFSqrtY_WriteFSqrtZ_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld
  {30,  0}, // #37 AtomWrite01_30_WriteDPPSLd_BWWriteResGroup186_WriteFDiv64ZLd_SKXWriteResGroup243_SKXWriteResGroup245_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_HWWriteResGroup161_HWWriteResGroup164_SKLWriteResGroup208
  {32,  0}, // #38 AtomWrite01_32_WriteDPPSYLd_WriteFSqrt64XLd_WriteFSqrt64Ld_JWriteCMPXCHG16B_WriteFSqrt64Z
  {45,  0}, // #39 AtomWrite01_45_WriteFDiv64Y_WriteFDiv64Z_WriteFSqrt64Y_WriteFSqrt64Z_WriteDiv64Ld_WriteIDiv64Ld
  {46,  0}, // #40 AtomWrite01_46_PdWriteVZEROUPPER_JWriteJVZEROUPPER_SKLWriteResGroup216
  {48,  0}, // #41 AtomWrite01_48
  {55,  0}, // #42 AtomWrite01_55
  {59,  0}, // #43 AtomWrite01_59_WriteFSqrt64YLd
  {63,  0}, // #44 AtomWrite01_63_BWWriteResGroup199_BWWriteResGroup198_SKXWriteResGroup260_SKXWriteResGroup259_SKLWriteResGroup219_SKLWriteResGroup218
  {72,  0}, // #45 AtomWrite01_72_WriteFDiv64XLd_WriteFDiv64YLd
  {74,  0}, // #46 AtomWrite01_74_SKXWriteResGroup262_WriteFSqrt64XLd_WriteFSqrt64YLd
  {77,  0}, // #47 AtomWrite01_77
  {78,  0}, // #48 AtomWrite01_78
  {79,  0}, // #49 AtomWrite01_79
  {92,  0}, // #50 AtomWrite01_92
  {94,  0}, // #51 AtomWrite01_94
  {99,  0}, // #52 AtomWrite01_99
  {121,  0}, // #53 AtomWrite01_121
  {127,  0}, // #54 AtomWrite01_127
  {140,  0}, // #55 AtomWrite01_140_SKXWriteResGroup267
  {141,  0}, // #56 AtomWrite01_141
  {146,  0}, // #57 AtomWrite01_146
  {147,  0}, // #58 AtomWrite01_147
  {168,  0}, // #59 AtomWrite01_168
  {174,  0}, // #60 AtomWrite01_174
  {183,  0}, // #61 AtomWrite01_183
  {202,  0}, // #62 AtomWrite01_202
  {19,  0}, // #63 WriteDiv16Ld_WriteIDiv16Ld_WritePCmpEStrILd_WriteAESIMCLd_WriteFDiv64XLd_BWWriteResGroup161_WriteDPPSLd_WritePCmpEStrM_WriteFDivX_WritePCmpEStrMLd_JWriteLOCK_CMPXCHG8B_JWriteLOCK_ALURMW_SKXWriteResGroup209_WriteFSqrtYLd_SKXWriteResGroup211_WriteDPPSYLd_WriteFDivXLd_HWWriteResGroup135_HWWriteResGroup143_HWWriteFPREM_SKLWriteResGroup186_WriteDiv8Ld_WriteIDiv8Ld_ZnWriteVDIVPSYLd
  { 5,  0}, // #64 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #65 WriteRMW
  {27,  0}, // #66 WriteDPPSY_PdWriteVDPPSrri_WriteFSqrtYLd_BWWriteResGroup183_7_WriteFSqrt64X_WriteFSqrtZLd_SKXWriteResGroup239_SKXWriteResGroup240_WriteFSqrt64XLd_WriteFSqrt64Ld_HWWriteFPREM1_HWWriteResGroup155_HWWriteResGroup188_HWWriteResGroup189_SKLWriteResGroup206_WriteFSqrtXLd_WriteFSqrtLd_WriteFSqrt64YLd
  {90,  0}, // #67 PdWriteVZEROALL_JWriteJVZEROALL
  {184,  0}, // #68 PdWriteLARrr
  {33,  0}, // #69 WriteAESKeyGenLd
  {80,  0}, // #70 WriteDiv16_WriteDiv32_WriteDiv64
  {31,  0}, // #71 WriteEMMS_SBWriteResGroup130_HWWriteResGroup163_HWWriteResGroup165
  {35,  0}, // #72 WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteFSqrt64YLd_BWWriteResGroup194_WriteFSqrt80_SKXWriteResGroup248_SKXWriteResGroup247_WriteFDiv64Y_WriteFDiv64Z_WriteFSqrt64Z_HWWriteResGroup170_SKLWriteResGroup210_SKLWriteResGroup209_WriteFSqrtYLd
  { 9,  0}, // #73 WriteIMul32Ld_WriteIMul64Ld
  { 3,  0}, // #74 WriteIMulH
  { 4,  0}, // #75 WriteIMul32_WriteIMul64
  { 3,  0}, // #76 WriteIMulH
  {24,  0}, // #77 WritePCmpEStrMLd_BWWriteResGroup177_BWWriteResGroup183_3_WriteFDiv64XLd_WriteFDivXLd_WriteFDivLd_WriteFDiv64Ld_WritePCmpEStrILd_WriteFSqrt64XLd_WriteFSqrt80_HWWriteResGroup162_HWWriteResGroup185
  { 6,  0}, // #78 WriteRotateLd_WriteShiftLd_WriteALULd_WriteIMul32Ld_WriteIMul64Ld
  { 1,  0}, // #79 WriteRMW_WriteIMulH
  { 8,  0}, // #80 WriteRotateCLLd_WriteShiftCLLd
  { 1,  0}, // #81 WriteRMW
  {42,  0}, // #82 BWWriteResGroup196_WriteFSqrtY_SKXWriteResGroup254_SKXWriteResGroup255_WriteFDiv64YLd_WriteFDiv64ZLd_WriteFSqrt64YLd_WriteFSqrt64ZLd_HWWriteResGroup176_WriteFDivXLd_WriteFDivYLd_SKLWriteResGroup214_SKLWriteResGroup215
  {75,  0}, // #83 BWWriteResGroup200_SKXWriteResGroup263_HWWriteResGroup180_HWWriteFSCALE_SKLWriteResGroup220
  {60,  0}, // #84 BWWriteResGroup197
  {115,  0}, // #85 BWWriteResGroup202_HWWriteResGroup183
  {28,  0}, // #86 WriteDiv32Ld_WriteIDiv32Ld_WriteIDiv16Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteFDiv64XLd_WriteFDiv64Ld_WriteFDivYLd_WriteFDivZLd_WriteFSqrtYLd_WriteFSqrtZLd_HWWriteResGroup186_HWWriteResGroup191
  {44,  0}, // #87 WriteDiv64Ld_WriteIDiv64Ld_SKXWriteResGroup256_WriteFSqrtXLd_WriteFSqrtYLd
  {41,  0}, // #88 WriteDiv64_WriteIDiv64_SKXWriteResGroup253_HWWriteResGroup175_WriteFSqrtX_WriteFSqrtY_SKLWriteResGroup213
  { 6,  0}, // #89 WriteIMul32Ld_WriteIMul64
  { 6,  0}, // #90 WriteIMulH
  { 3,  0}, // #91 WriteIMul32
  { 6,  0}, // #92 WriteIMulH
  { 9,  0}, // #93 WriteIMul64Ld
  { 6,  0}, // #94 WriteIMulH
  { 4,  0}, // #95 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 2,  0}, // #96 WriteRMW
  {43,  0}, // #97 WriteFDiv64YLd_WriteFDivYLd
  {38,  0}, // #98 WriteFDiv64Y_WriteFDivY_JWriteLOCK_CMPXCHG16B_WriteFSqrt64Ld
  {54,  0}, // #99 WriteFSqrt64Y
  {47,  0}, // #100 WriteFSqrtYLd_HWWriteFBLD_WriteFSqrt64YLd
  {11,  0}, // #101 JWriteXCHGrm_XCHG_Part_JWriteLOCK_XADDrm_XCHG_Part
  {16,  0}, // #102 JWriteXCHGrm_LdSt_Part
  { 3,  0}, // #103 JWriteXADDrm_XCHG_Part
  {11,  0}, // #104 JWriteXADDrm_LdSt_Part
  {76,  0}, // #105 WriteDiv16_WriteDiv32_WriteDiv64
  {102,  0}, // #106 WriteIDiv16_WriteIDiv32_WriteIDiv64
  {39,  0}, // #107 WriteFSqrt64ZLd_WriteFDivX_WriteFDivY
  {37,  0}, // #108 SKXWriteResGroup250_SKXWriteResGroup249_WriteFDiv64Ld_SKLWriteResGroup211
  {40,  0}, // #109 SKXWriteResGroup252_WriteFSqrt80_SKLWriteResGroup212_WriteFSqrt64Y
  {106,  0}, // #110 SKXWriteResGroup266_SKLWriteResGroup223
  {67,  0}, // #111 SKXWriteResGroup261
  { 7,  0}, // #112 WriteRotateLd
  { 1,  0}, // #113 WriteRMW
  {52,  0}, // #114 WriteFDiv64YLd_WriteFDiv64ZLd_WriteFSqrt64YLd_WriteFSqrt64ZLd
  {36,  0}, // #115 WriteFDivYLd_WriteFDivZLd_WriteFSqrtYLd_WriteFSqrtZLd_HWWriteResGroup171
  {98,  0}, // #116 WriteDiv16_WriteDiv32_WriteDiv64
  {112,  0}, // #117 WriteIDiv16_WriteIDiv32_WriteIDiv64
  {64,  0}, // #118 HWWriteResGroup179_HWWriteResGroup178
  {61,  0}, // #119 HWWriteResGroup177
  {69,  0}, // #120 WriteFDiv64X_WriteFDiv64Y
  { 3,  0}, // #121 WriteIMul32_WriteIMul64
  { 1,  0}, // #122 WriteIMulH
  { 8,  0}, // #123 ZnWriteMul32Ld_Zn2WriteMul64Ld
  { 4,  0}, // #124 WriteIMulH
  { 9,  0}, // #125 ZnWriteMul64Ld
  { 4,  0}, // #126 WriteIMulH_Zn2WriteMul64
  { 4,  0}, // #127 ZnWriteMul64_WriteIMulH
  { 4,  0}, // #128 WriteIMulH
  {107,  0}, // #129 WriteFShuffle256Ld_WriteFVarShuffle256Ld
  { 7,  0}, // #130 Zn2WriteMul32Ld
  { 4,  0} // #131 WriteIMulH
}; // X86WriteLatencyTable

// {UseIdx, WriteResourceID, Cycles}
extern const llvm::MCReadAdvanceEntry X86ReadAdvanceTable[] = {
  {0,  0,  0}, // Invalid
  {0,  0,  3}, // #1
  {5,  0,  3}, // #2
  {1,  0,  0}, // #3
  {5,  0,  3}, // #4
  {6,  0,  3}, // #5
  {0,  0,  3}, // #6
  {6,  0,  3}, // #7
  {0,  0,  3}, // #8
  {1,  0,  3}, // #9
  {0,  0,  4}, // #10
  {0,  0,  5}, // #11
  {5,  0,  4}, // #12
  {0,  0, -10}, // #13
  {1,  0, -10}, // #14
  {5,  0,  4}, // #15
  {6,  0,  4}, // #16
  {0,  0,  5}, // #17
  {6,  0,  5}, // #18
  {0,  0,  5}, // #19
  {1,  0,  5}, // #20
  {5,  0,  5}, // #21
  {5,  0,  5}, // #22
  {6,  0,  5}, // #23
  {0,  0,  6}, // #24
  {0,  0,  6}, // #25
  {6,  0,  6}, // #26
  {0,  0,  6}, // #27
  {1,  0,  6}, // #28
  {0,  0, -6}, // #29
  {1,  0, -6}, // #30
  {5,  0,  3}, // #31
  {6,  0,  3}, // #32
  {7,  0,  3}, // #33
  {8,  0,  3}, // #34
  {0,  0,  7}, // #35
  {0,  0,  7}, // #36
  {6,  0,  7}, // #37
  {0,  0,  7}, // #38
  {1,  0,  7}, // #39
  {0,  0,  8}, // #40
  {0,  0,  8}, // #41
  {6,  0,  8}, // #42
  {0,  0,  8}, // #43
  {1,  0,  8} // #44
}; // X86ReadAdvanceTable

// {Name, NumMicroOps, BeginGroup, EndGroup, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc AtomModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  16383, false, false,  0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false,  1, 1,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false,  1, 1,  1, 1,  0, 0}, // #3
  {DBGFIELD("WriteCMPXCHGRMW")    1, false, false,  2, 2,  1, 1,  0, 0}, // #4
  {DBGFIELD("WriteJumpLd")        1, false, false,  4, 2,  1, 1,  0, 0}, // #5
  {DBGFIELD("WriteMove")          1, false, false,  1, 1,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteJump")          1, false, false,  4, 2,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false,  1, 1,  2, 1,  0, 0}, // #8
  {DBGFIELD("WriteSHDrri")        1, false, false,  3, 1,  3, 1,  0, 0}, // #9
  {DBGFIELD("WriteFStoreX")       1, false, false,  6, 2,  1, 1,  0, 0}, // #10
  {DBGFIELD("WriteFLoadX")        1, false, false,  6, 2,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteFStoreY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #12
  {DBGFIELD("WriteFLoadY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #13
  {DBGFIELD("WriteMicrocoded")    1, false, false,  1, 1,  2, 1,  0, 0}, // #14
  {DBGFIELD("WriteFSign")         1, false, false,  4, 2,  1, 1,  0, 0}, // #15
  {DBGFIELD("WriteADC")           1, false, false,  1, 1,  1, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCRMW")        1, false, false,  6, 2,  1, 1,  0, 0}, // #17
  {DBGFIELD("WriteADCLd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #18
  {DBGFIELD("WriteALURMW")        1, false, false,  6, 2,  1, 1,  0, 0}, // #19
  {DBGFIELD("WriteALULd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #20
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 1, false, false,  8, 1,  4, 1,  1, 1}, // #21
  {DBGFIELD("WriteFAdd64X")       1, false, false,  9, 1,  5, 1,  0, 0}, // #22
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 1, false, false, 10, 2,  6, 1,  1, 1}, // #23
  {DBGFIELD("WriteFAddX")         1, false, false, 10, 2,  6, 1,  0, 0}, // #24
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 1, false, false, 10, 2,  6, 1,  1, 1}, // #25
  {DBGFIELD("WriteFAdd64")        1, false, false, 10, 2,  6, 1,  0, 0}, // #26
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 1, false, false, 10, 2,  6, 1,  1, 1}, // #27
  {DBGFIELD("WriteFAdd")          1, false, false, 10, 2,  6, 1,  0, 0}, // #28
  {DBGFIELD("WriteFAddLd")        1, false, false, 10, 2,  6, 1,  0, 0}, // #29
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #30
  {DBGFIELD("WriteAESDecEnc")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #31
  {DBGFIELD("WriteAESIMCLd")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #32
  {DBGFIELD("WriteAESIMC")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #33
  {DBGFIELD("WriteAESKeyGenLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #34
  {DBGFIELD("WriteAESKeyGen")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #35
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #36
  {DBGFIELD("WriteFLogic")        1, false, false,  1, 1,  1, 1,  0, 0}, // #37
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #38
  {DBGFIELD("WriteBEXTR")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #39
  {DBGFIELD("WriteBEXTRLd")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #40
  {DBGFIELD("WriteALULd")         1, false, false,  6, 2,  1, 1,  0, 0}, // #41
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #42
  {DBGFIELD("WriteFBlend")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #43
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #44
  {DBGFIELD("WriteFVarBlend")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #45
  {DBGFIELD("WriteBLSLd")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #46
  {DBGFIELD("WriteBLS")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #47
  {DBGFIELD("WriteBSFLd")         1, false, false, 12, 1,  7, 1,  0, 0}, // #48
  {DBGFIELD("WriteBSF")           1, false, false, 12, 1,  7, 1,  0, 0}, // #49
  {DBGFIELD("WriteBSRLd")         1, false, false, 12, 1,  7, 1,  0, 0}, // #50
  {DBGFIELD("WriteBSR")           1, false, false, 12, 1,  7, 1,  0, 0}, // #51
  {DBGFIELD("WriteBSWAP32")       1, false, false,  6, 2,  1, 1,  0, 0}, // #52
  {DBGFIELD("WriteBSWAP64")       1, false, false,  6, 2,  1, 1,  0, 0}, // #53
  {DBGFIELD("WriteBitTestImmLd")  1, false, false,  6, 2,  1, 1,  0, 0}, // #54
  {DBGFIELD("WriteBitTestRegLd")  1, false, false, 13, 1,  8, 1,  0, 0}, // #55
  {DBGFIELD("WriteBitTest")       1, false, false,  4, 2,  1, 1,  0, 0}, // #56
  {DBGFIELD("WriteBitTestSetImmRMW") 1, false, false,  3, 1,  3, 1,  0, 0}, // #57
  {DBGFIELD("WriteBitTestSetRegRMW") 1, false, false, 14, 1,  9, 1,  0, 0}, // #58
  {DBGFIELD("WriteBitTestSet")    1, false, false,  4, 2,  1, 1,  0, 0}, // #59
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #60
  {DBGFIELD("WriteBZHI")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #61
  {DBGFIELD("WriteLoad")          1, false, false,  6, 2,  1, 1,  0, 0}, // #62
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #63
  {DBGFIELD("WriteCMOV")          1, false, false,  1, 1,  1, 1,  0, 0}, // #64
  {DBGFIELD("WriteFCMOV")         1, false, false, 13, 1,  8, 1,  0, 0}, // #65
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  2, 1}, // #66
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 1, false, false,  8, 1,  4, 1,  1, 1}, // #67
  {DBGFIELD("WriteFCmp64X")       1, false, false,  9, 1,  5, 1,  0, 0}, // #68
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 1, false, false, 10, 2,  6, 1,  1, 1}, // #69
  {DBGFIELD("WriteFCmpX")         1, false, false, 10, 2,  6, 1,  0, 0}, // #70
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 1, false, false, 10, 2,  6, 1,  1, 1}, // #71
  {DBGFIELD("WriteFCmp64")        1, false, false, 10, 2,  6, 1,  0, 0}, // #72
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 1, false, false, 10, 2,  6, 1,  1, 1}, // #73
  {DBGFIELD("WriteFCmp")          1, false, false, 10, 2,  6, 1,  0, 0}, // #74
  {DBGFIELD("WriteCMPXCHG")       1, false, false, 15, 1, 10, 1,  0, 0}, // #75
  {DBGFIELD("WriteFComLd_ReadAfterVecLd") 1, false, false, 10, 2,  6, 1,  1, 1}, // #76
  {DBGFIELD("WriteFCom")          1, false, false, 10, 2,  6, 1,  0, 0}, // #77
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #78
  {DBGFIELD("WriteCRC32")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #79
  {DBGFIELD("WriteNop")           1, false, false,  1, 1,  1, 1,  0, 0}, // #80
  {DBGFIELD("WriteCvtI2PDLd")     1, false, false, 16, 1, 11, 1,  0, 0}, // #81
  {DBGFIELD("WriteCvtI2PD")       1, false, false,  8, 1,  4, 1,  0, 0}, // #82
  {DBGFIELD("WriteCvtI2PSLd")     1, false, false,  8, 1,  4, 1,  0, 0}, // #83
  {DBGFIELD("WriteCvtI2PS")       1, false, false,  9, 1,  5, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtPD2ILd")     1, false, false, 16, 1, 11, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtPD2I")       1, false, false,  8, 1,  4, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtPD2PSLd")    1, false, false, 16, 1, 11, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtPD2PS")      1, false, false,  8, 1,  4, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtPS2ILd")     1, false, false,  8, 1,  4, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtPS2I")       1, false, false,  9, 1,  5, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPS2PDLd")    1, false, false, 16, 1, 11, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPS2PD")      1, false, false,  8, 1,  4, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtSD2ILd")     1, false, false, 13, 1,  8, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtSD2I")       1, false, false, 16, 1, 11, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtSD2SSLd")    1, false, false,  8, 1,  4, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 1, false, false,  8, 1,  4, 1,  1, 1}, // #96
  {DBGFIELD("WriteCvtSD2SS")      1, false, false,  9, 1,  5, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtI2SDLd")     1, false, false,  8, 1,  4, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 1, false, false,  8, 1,  4, 1,  1, 1}, // #99
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 1, false, false,  9, 1,  5, 1,  0, 1}, // #100
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 1, false, false,  9, 1,  5, 1,  3, 1}, // #101
  {DBGFIELD("WriteCvtI2SSLd")     1, false, false,  8, 1,  4, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 1, false, false,  8, 1,  4, 1,  1, 1}, // #103
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 1, false, false,  9, 1,  5, 1,  0, 1}, // #104
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 1, false, false,  9, 1,  5, 1,  3, 1}, // #105
  {DBGFIELD("WriteCvtSS2SDLd")    1, false, false,  8, 1,  4, 1,  0, 0}, // #106
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 1, false, false,  8, 1,  4, 1,  1, 1}, // #107
  {DBGFIELD("WriteCvtSS2SD")      1, false, false,  9, 1,  5, 1,  0, 0}, // #108
  {DBGFIELD("WriteCvtSS2ILd")     1, false, false, 13, 1,  8, 1,  0, 0}, // #109
  {DBGFIELD("WriteCvtSS2I")       1, false, false, 16, 1, 11, 1,  0, 0}, // #110
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 1, false, false, 16, 1, 11, 1,  0, 0}, // #111
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 1, false, false, 16, 1, 11, 1,  0, 0}, // #112
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 17, 1, 12, 1,  4, 2}, // #113
  {DBGFIELD("WriteDiv16")         1, false, false, 17, 1, 12, 1,  0, 0}, // #114
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 17, 1, 12, 1,  4, 2}, // #115
  {DBGFIELD("WriteDiv32")         1, false, false, 17, 1, 12, 1,  0, 0}, // #116
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 18, 1, 13, 1,  4, 2}, // #117
  {DBGFIELD("WriteDiv64")         1, false, false, 18, 1, 13, 1,  0, 0}, // #118
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 19, 1, 14, 1,  4, 2}, // #119
  {DBGFIELD("WriteDiv8")          1, false, false, 17, 1, 12, 1,  0, 0}, // #120
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 1, false, false, 20, 1, 15, 1,  1, 1}, // #121
  {DBGFIELD("WriteFDiv64X")       1, false, false, 20, 1, 15, 1,  0, 0}, // #122
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 1, false, false, 21, 1, 16, 1,  1, 1}, // #123
  {DBGFIELD("WriteFDivX")         1, false, false, 21, 1, 16, 1,  0, 0}, // #124
  {DBGFIELD("WriteFDivLd")        1, false, false, 22, 1, 17, 1,  0, 0}, // #125
  {DBGFIELD("WriteFDiv")          1, false, false, 22, 1, 17, 1,  0, 0}, // #126
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 1, false, false, 23, 1, 18, 1,  1, 1}, // #127
  {DBGFIELD("WriteFDiv64")        1, false, false, 23, 1, 18, 1,  0, 0}, // #128
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 1, false, false, 22, 1, 17, 1,  1, 1}, // #129
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #130
  {DBGFIELD("WriteDPPD")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #131
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #132
  {DBGFIELD("WriteDPPS")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #133
  {DBGFIELD("WriteStore")         1, false, false,  6, 2,  1, 1,  0, 0}, // #134
  {DBGFIELD("WriteVecExtractSt")  1, false, false,  6, 2,  1, 1,  0, 0}, // #135
  {DBGFIELD("WriteVecExtract")    1, false, false,  6, 2,  1, 1,  0, 0}, // #136
  {DBGFIELD("WriteVecALUX")       1, false, false,  1, 1,  1, 1,  0, 0}, // #137
  {DBGFIELD("WriteFComLd")        1, false, false, 10, 2,  6, 1,  0, 0}, // #138
  {DBGFIELD("WriteEMMS")          1, false, false, 11, 1,  6, 1,  0, 0}, // #139
  {DBGFIELD("WriteFLDC")          1, false, false, 24, 1, 19, 1,  0, 0}, // #140
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #141
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 1, false, false, 13, 1,  8, 1,  1, 1}, // #142
  {DBGFIELD("WriteFHAdd")         1, false, false, 16, 1, 11, 1,  0, 0}, // #143
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 23, 1, 18, 1,  4, 2}, // #144
  {DBGFIELD("WriteIDiv16")        1, false, false, 23, 1, 18, 1,  0, 0}, // #145
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 23, 1, 18, 1,  4, 2}, // #146
  {DBGFIELD("WriteIDiv32")        1, false, false, 23, 1, 18, 1,  0, 0}, // #147
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 18, 1, 13, 1,  4, 2}, // #148
  {DBGFIELD("WriteIDiv64")        1, false, false, 18, 1, 13, 1,  0, 0}, // #149
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 23, 1, 18, 1,  4, 2}, // #150
  {DBGFIELD("WriteIDiv8")         1, false, false, 23, 1, 18, 1,  0, 0}, // #151
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 16, 1, 11, 1,  4, 2}, // #152
  {DBGFIELD("WriteIMul16")        1, false, false,  8, 1,  4, 1,  0, 0}, // #153
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 1, false, false,  8, 1,  4, 1,  1, 1}, // #154
  {DBGFIELD("WriteIMul16ImmLd")   1, false, false,  8, 1,  4, 1,  0, 0}, // #155
  {DBGFIELD("WriteIMul16Reg")     1, false, false,  9, 1,  5, 1,  0, 0}, // #156
  {DBGFIELD("WriteIMul16Imm")     1, false, false,  9, 1,  5, 1,  0, 0}, // #157
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false,  8, 1,  4, 1,  4, 2}, // #158
  {DBGFIELD("WriteIMul32")        1, false, false,  9, 1,  5, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 1, false, false, 10, 2,  6, 1,  1, 1}, // #160
  {DBGFIELD("WriteIMul32ImmLd")   1, false, false, 10, 2,  6, 1,  0, 0}, // #161
  {DBGFIELD("WriteIMul32Reg")     1, false, false, 10, 2,  6, 1,  0, 0}, // #162
  {DBGFIELD("WriteIMul32Imm")     1, false, false, 10, 2,  6, 1,  0, 0}, // #163
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 25, 1, 20, 1,  4, 2}, // #164
  {DBGFIELD("WriteIMul64")        1, false, false, 25, 1, 20, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 1, false, false, 25, 1, 20, 1,  1, 1}, // #166
  {DBGFIELD("WriteIMul64ImmLd")   1, false, false, 26, 1, 21, 1,  0, 0}, // #167
  {DBGFIELD("WriteIMul64Reg")     1, false, false, 25, 1, 20, 1,  0, 0}, // #168
  {DBGFIELD("WriteIMul64Imm")     1, false, false, 26, 1, 21, 1,  0, 0}, // #169
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false,  8, 1,  4, 1,  4, 2}, // #170
  {DBGFIELD("WriteIMul8")         1, false, false,  8, 1,  4, 1,  0, 0}, // #171
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #172
  {DBGFIELD("WriteFShuffle")      1, false, false,  6, 2,  1, 1,  0, 0}, // #173
  {DBGFIELD("WriteVecLogicX")     1, false, false,  1, 1,  1, 1,  0, 0}, // #174
  {DBGFIELD("WriteShuffle")       1, false, false,  6, 2,  1, 1,  0, 0}, // #175
  {DBGFIELD("WriteLAHFSAHF")      1, false, false,  3, 1,  3, 1,  0, 0}, // #176
  {DBGFIELD("WriteVecLoadX")      1, false, false,  6, 2,  1, 1,  0, 0}, // #177
  {DBGFIELD("WriteLDMXCSR")       1, false, false, 11, 1,  6, 1,  0, 0}, // #178
  {DBGFIELD("WriteFLD0")          1, false, false,  1, 1,  1, 1,  0, 0}, // #179
  {DBGFIELD("WriteFLD1")          1, false, false,  9, 1,  5, 1,  0, 0}, // #180
  {DBGFIELD("WriteLEA")           1, false, false,  4, 2,  1, 1,  0, 0}, // #181
  {DBGFIELD("WriteFence")         1, false, false,  6, 2,  1, 1,  0, 0}, // #182
  {DBGFIELD("WriteLZCNTLd")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #183
  {DBGFIELD("WriteLZCNT")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #184
  {DBGFIELD("WriteVecStoreX")     1, false, false,  6, 2,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteVecStore")      1, false, false,  6, 2,  1, 1,  0, 0}, // #186
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, 27, 2, 22, 1,  0, 0}, // #187
  {DBGFIELD("WriteVecLoad")       1, false, false,  6, 2,  1, 1,  0, 0}, // #188
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteVecMoveX")      1, false, false,  1, 1,  1, 1,  0, 0}, // #190
  {DBGFIELD("WriteVecStoreNT")    1, false, false,  6, 2,  1, 1,  0, 0}, // #191
  {DBGFIELD("WriteVecMove")       1, false, false,  6, 2,  1, 1,  0, 0}, // #192
  {DBGFIELD("WriteVecALULd")      1, false, false,  6, 2,  1, 1,  0, 0}, // #193
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #194
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #195
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #196
  {DBGFIELD("WriteVecLogic")      1, false, false,  1, 1,  1, 1,  0, 0}, // #197
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 1, false, false, 29, 1, 23, 1,  1, 1}, // #198
  {DBGFIELD("WritePHAdd")         1, false, false, 28, 1, 22, 1,  0, 0}, // #199
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #200
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 1, false, false,  6, 2,  1, 1,  3, 1}, // #201
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 1, false, false, 30, 2, 23, 1,  1, 1}, // #202
  {DBGFIELD("WriteVecIMul")       1, false, false, 30, 2, 23, 1,  0, 0}, // #203
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, 27, 2, 22, 1,  0, 0}, // #204
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 1, false, false, 29, 1, 23, 1,  1, 1}, // #205
  {DBGFIELD("WritePSADBW")        1, false, false, 29, 1, 23, 1,  0, 0}, // #206
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #207
  {DBGFIELD("WriteVarShuffle")    1, false, false,  6, 2,  1, 1,  0, 0}, // #208
  {DBGFIELD("WriteShuffleLd")     1, false, false,  6, 2,  1, 1,  0, 0}, // #209
  {DBGFIELD("WriteVecShiftImm")   1, false, false,  1, 1,  1, 1,  0, 0}, // #210
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 1, false, false, 28, 1, 22, 1,  1, 1}, // #211
  {DBGFIELD("WriteVecShift")      1, false, false,  3, 1,  3, 1,  0, 0}, // #212
  {DBGFIELD("WriteFMoveX")        1, false, false,  1, 1,  1, 1,  0, 0}, // #213
  {DBGFIELD("WriteFShuffleLd")    1, false, false,  6, 2,  1, 1,  0, 0}, // #214
  {DBGFIELD("WriteFStore")        1, false, false,  6, 2,  1, 1,  0, 0}, // #215
  {DBGFIELD("WriteFMOVMSK")       1, false, false, 27, 2, 22, 1,  0, 0}, // #216
  {DBGFIELD("WriteVecLoadNT")     1, false, false,  6, 2,  1, 1,  0, 0}, // #217
  {DBGFIELD("WriteStoreNT")       1, false, false,  6, 2,  1, 1,  0, 0}, // #218
  {DBGFIELD("WriteFStoreNTX")     1, false, false,  6, 2,  1, 1,  0, 0}, // #219
  {DBGFIELD("WriteFStoreNT")      1, false, false,  6, 2,  1, 1,  0, 0}, // #220
  {DBGFIELD("WriteFLoad")         1, false, false,  6, 2,  1, 1,  0, 0}, // #221
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #222
  {DBGFIELD("WriteMPSAD")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #223
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 1, false, false, 24, 1, 19, 1,  1, 1}, // #224
  {DBGFIELD("WriteFMul64X")       1, false, false, 13, 1,  8, 1,  0, 0}, // #225
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 1, false, false, 10, 2,  6, 1,  1, 1}, // #226
  {DBGFIELD("WriteFMulX")         1, false, false, 10, 2,  6, 1,  0, 0}, // #227
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 1, false, false, 10, 2,  6, 1,  1, 1}, // #228
  {DBGFIELD("WriteFMul64")        1, false, false, 10, 2,  6, 1,  0, 0}, // #229
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 1, false, false, 30, 2, 23, 1,  1, 1}, // #230
  {DBGFIELD("WriteFMul")          1, false, false, 30, 2, 23, 1,  0, 0}, // #231
  {DBGFIELD("WriteIMul32Ld_WriteIMulH") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #232
  {DBGFIELD("WriteIMul32_WriteIMulH") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #233
  {DBGFIELD("WriteIMul64Ld_WriteIMulH") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #234
  {DBGFIELD("WriteIMul64_WriteIMulH") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #235
  {DBGFIELD("WriteFMulLd")        1, false, false, 30, 2, 23, 1,  0, 0}, // #236
  {DBGFIELD("WriteVecALUXLd")     1, false, false,  6, 2,  1, 1,  0, 0}, // #237
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #238
  {DBGFIELD("WriteShuffleX")      1, false, false,  6, 2,  1, 1,  0, 0}, // #239
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #240
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #241
  {DBGFIELD("WriteVarBlend")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #242
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #243
  {DBGFIELD("WriteBlend")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #244
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #245
  {DBGFIELD("WriteCLMul")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #246
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #247
  {DBGFIELD("WritePCmpEStrI")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #248
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #249
  {DBGFIELD("WritePCmpEStrM")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #250
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #251
  {DBGFIELD("WritePCmpIStrI")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #252
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #253
  {DBGFIELD("WritePCmpIStrM")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #254
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 1, false, false,  8, 1,  4, 1,  1, 1}, // #255
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 1, false, false, 16, 1, 11, 1,  1, 1}, // #256
  {DBGFIELD("WritePHAddX")        1, false, false,  8, 1,  4, 1,  0, 0}, // #257
  {DBGFIELD("WritePHMINPOSLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #258
  {DBGFIELD("WritePHMINPOS")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #259
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 1, false, false,  8, 1,  4, 1,  1, 1}, // #260
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 1, false, false, 10, 2,  6, 1,  1, 1}, // #261
  {DBGFIELD("WriteVecIMulX")      1, false, false, 10, 2,  6, 1,  0, 0}, // #262
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, 27, 2, 22, 1,  0, 0}, // #263
  {DBGFIELD("WriteShuffleXLd")    1, false, false,  6, 2,  1, 1,  0, 0}, // #264
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #265
  {DBGFIELD("WritePMULLD")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #266
  {DBGFIELD("WriteCopy")          2, false, false, 32, 2,  3, 1,  0, 0}, // #267
  {DBGFIELD("WritePOPCNTLd")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #268
  {DBGFIELD("WritePOPCNT")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #269
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 1, false, false, 10, 2,  6, 1,  1, 1}, // #270
  {DBGFIELD("WritePSADBWX")       1, false, false, 10, 2,  6, 1,  0, 0}, // #271
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 1, false, false, 11, 1,  6, 1,  1, 1}, // #272
  {DBGFIELD("WriteVarShuffleX")   1, false, false, 29, 1, 23, 1,  0, 0}, // #273
  {DBGFIELD("WriteVecShiftImmX")  1, false, false,  1, 1,  1, 1,  0, 0}, // #274
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 1, false, false, 28, 1, 22, 1,  1, 1}, // #275
  {DBGFIELD("WriteVecShiftX")     1, false, false,  3, 1,  3, 1,  0, 0}, // #276
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #277
  {DBGFIELD("WriteVecTest")       1, false, false,  1, 1,  1, 1,  0, 0}, // #278
  {DBGFIELD("WriteRotateLd_WriteRMW") 2, false, false, 32, 2, 24, 2,  0, 0}, // #279
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 2, false, false, 32, 2, 24, 2,  0, 0}, // #280
  {DBGFIELD("WriteRotate")        1, false, false,  6, 2,  1, 1,  0, 0}, // #281
  {DBGFIELD("WriteRotateCL")      1, false, false,  6, 2,  1, 1,  0, 0}, // #282
  {DBGFIELD("WriteFRcpXLd")       1, false, false, 24, 1, 19, 1,  0, 0}, // #283
  {DBGFIELD("WriteFRcpX")         1, false, false, 13, 1,  8, 1,  0, 0}, // #284
  {DBGFIELD("WriteFRcpLd")        1, false, false, 30, 2, 23, 1,  0, 0}, // #285
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 1, false, false, 30, 2, 23, 1,  1, 1}, // #286
  {DBGFIELD("WriteFRcp")          1, false, false, 30, 2, 23, 1,  0, 0}, // #287
  {DBGFIELD("WriteRMW")           1, false, false,  6, 2,  1, 1,  0, 0}, // #288
  {DBGFIELD("WriteShiftLd")       1, false, false,  6, 2,  1, 1,  0, 0}, // #289
  {DBGFIELD("WriteShift")         1, false, false,  6, 2,  1, 1,  0, 0}, // #290
  {DBGFIELD("WriteFRndLd")        1, false, false, 10, 2,  6, 1,  0, 0}, // #291
  {DBGFIELD("WriteFRnd")          1, false, false, 10, 2,  6, 1,  0, 0}, // #292
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 1, false, false, 10, 2,  6, 1,  1, 1}, // #293
  {DBGFIELD("WriteFRsqrtXLd")     1, false, false, 24, 1, 19, 1,  0, 0}, // #294
  {DBGFIELD("WriteFRsqrtX")       1, false, false, 13, 1,  8, 1,  0, 0}, // #295
  {DBGFIELD("WriteFRsqrtLd")      1, false, false, 30, 2, 23, 1,  0, 0}, // #296
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 1, false, false, 30, 2, 23, 1,  1, 1}, // #297
  {DBGFIELD("WriteFRsqrt")        1, false, false, 30, 2, 23, 1,  0, 0}, // #298
  {DBGFIELD("WriteShiftLd_WriteRMW") 2, false, false, 32, 2, 24, 2,  0, 0}, // #299
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 2, false, false, 32, 2, 24, 2,  0, 0}, // #300
  {DBGFIELD("WriteShiftCL")       1, false, false,  6, 2,  1, 1,  0, 0}, // #301
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  2, 1}, // #302
  {DBGFIELD("WriteSETCCStore")    1, false, false,  3, 1,  3, 1,  0, 0}, // #303
  {DBGFIELD("WriteSETCC")         1, false, false,  1, 1,  1, 1,  0, 0}, // #304
  {DBGFIELD("WriteSHDmrcl")       1, false, false, 29, 1, 23, 1,  0, 0}, // #305
  {DBGFIELD("WriteSHDmri")        1, false, false, 29, 1, 23, 1,  0, 0}, // #306
  {DBGFIELD("WriteSHDrrcl")       1, false, false,  3, 1,  3, 1,  0, 0}, // #307
  {DBGFIELD("WriteFSqrt64XLd")    1, false, false, 20, 1, 15, 1,  0, 0}, // #308
  {DBGFIELD("WriteFSqrt64X")      1, false, false, 20, 1, 15, 1,  0, 0}, // #309
  {DBGFIELD("WriteFSqrtXLd")      1, false, false, 21, 1, 16, 1,  0, 0}, // #310
  {DBGFIELD("WriteFSqrtX")        1, false, false, 21, 1, 16, 1,  0, 0}, // #311
  {DBGFIELD("WriteFSqrt64Ld")     1, false, false, 23, 1, 18, 1,  0, 0}, // #312
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 1, false, false, 23, 1, 18, 1,  1, 1}, // #313
  {DBGFIELD("WriteFSqrt64")       1, false, false, 23, 1, 18, 1,  0, 0}, // #314
  {DBGFIELD("WriteFSqrtLd")       1, false, false, 22, 1, 17, 1,  0, 0}, // #315
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 1, false, false, 22, 1, 17, 1,  1, 1}, // #316
  {DBGFIELD("WriteFSqrt")         1, false, false, 22, 1, 17, 1,  0, 0}, // #317
  {DBGFIELD("WriteFSqrt80")       1, false, false, 34, 1, 26, 1,  0, 0}, // #318
  {DBGFIELD("WriteSTMXCSR")       1, false, false, 15, 1, 10, 1,  0, 0}, // #319
  {DBGFIELD("WriteTZCNTLd")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #320
  {DBGFIELD("WriteTZCNT")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #321
  {DBGFIELD("WriteFMAZLd")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #322
  {DBGFIELD("WriteFMALd")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #323
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #324
  {DBGFIELD("WriteFAdd64Y")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #325
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #326
  {DBGFIELD("WriteFAdd64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #327
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #328
  {DBGFIELD("WriteFAddY")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #329
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #330
  {DBGFIELD("WriteFAddZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #331
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #332
  {DBGFIELD("WriteShuffleY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #334
  {DBGFIELD("WriteShuffleZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #335
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #336
  {DBGFIELD("WriteFLogicY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #337
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("WriteFLogicZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #339
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #340
  {DBGFIELD("WriteFVarBlendY")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #341
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD("WriteFVarBlendZ")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #343
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #344
  {DBGFIELD("WriteFBlendY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #345
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #346
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #347
  {DBGFIELD("WriteShuffle256Ld")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #348
  {DBGFIELD("WriteShuffle256")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #349
  {DBGFIELD("WriteShuffleYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #350
  {DBGFIELD("WriteFShuffle256")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #351
  {DBGFIELD("WriteFShuffle256Ld") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #352
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #353
  {DBGFIELD("WriteFCmp64Y")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #354
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #355
  {DBGFIELD("WriteFCmpY")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #356
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #357
  {DBGFIELD("WriteFCmpZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #358
  {DBGFIELD("WriteVarShuffle256Ld") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #359
  {DBGFIELD("WriteVarShuffle256") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #360
  {DBGFIELD("WriteCvtI2PDYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #361
  {DBGFIELD("WriteCvtI2PDY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #362
  {DBGFIELD("WriteCvtI2PDZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #363
  {DBGFIELD("WriteCvtI2PDZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #364
  {DBGFIELD("WriteCvtI2PSYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD("WriteCvtI2PSY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #366
  {DBGFIELD("WriteCvtI2PSZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #367
  {DBGFIELD("WriteCvtI2PSZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #368
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 1, false, false, 16, 1, 11, 1,  1, 1}, // #369
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #370
  {DBGFIELD("WriteCvtPD2PSY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #371
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #372
  {DBGFIELD("WriteCvtPD2PSZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #373
  {DBGFIELD("WriteCvtPD2PSYLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #374
  {DBGFIELD("WriteCvtPD2PSZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("WriteCvtPD2IYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #376
  {DBGFIELD("WriteCvtPD2IY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #377
  {DBGFIELD("WriteCvtPD2IZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #378
  {DBGFIELD("WriteCvtPD2IZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteCvtPH2PSYLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteCvtPH2PSY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #381
  {DBGFIELD("WriteCvtPH2PSLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #382
  {DBGFIELD("WriteCvtPH2PS")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #383
  {DBGFIELD("WriteCvtPH2PSZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #384
  {DBGFIELD("WriteCvtPH2PSZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #385
  {DBGFIELD("WriteCvtPS2IYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #386
  {DBGFIELD("WriteCvtPS2IY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #387
  {DBGFIELD("WriteCvtPS2IZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #388
  {DBGFIELD("WriteCvtPS2IZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #389
  {DBGFIELD("WriteCvtPS2PDYLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #390
  {DBGFIELD("WriteCvtPS2PDY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #391
  {DBGFIELD("WriteCvtPS2PDZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #392
  {DBGFIELD("WriteCvtPS2PDZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2PHYSt")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteCvtPS2PHY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #395
  {DBGFIELD("WriteCvtPS2PHSt")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #396
  {DBGFIELD("WriteCvtPS2PH")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #397
  {DBGFIELD("WriteCvtPS2PHZSt")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #398
  {DBGFIELD("WriteCvtPS2PHZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 1, false, false, 13, 1,  8, 1,  1, 1}, // #400
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 1, false, false, 13, 1,  8, 1,  1, 1}, // #401
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #402
  {DBGFIELD("WritePSADBWY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #403
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #404
  {DBGFIELD("WritePSADBWZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #406
  {DBGFIELD("WriteFDiv64Y")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #407
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #408
  {DBGFIELD("WriteFDiv64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #409
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #410
  {DBGFIELD("WriteFDivY")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #411
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #412
  {DBGFIELD("WriteFDivZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #413
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #414
  {DBGFIELD("WriteFMAX")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #415
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #416
  {DBGFIELD("WriteFMAY")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #417
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #418
  {DBGFIELD("WriteFMAZ")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #419
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #420
  {DBGFIELD("WriteDPPSY")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #421
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #422
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #423
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #424
  {DBGFIELD("WriteFMALd_ReadAfterVecLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteFMA")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #426
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #427
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #428
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #429
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #430
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #431
  {DBGFIELD("WriteFRndY")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #432
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #433
  {DBGFIELD("WriteFRndZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #434
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #435
  {DBGFIELD("WriteVecIMulY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #436
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #437
  {DBGFIELD("WriteVecIMulZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #438
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #439
  {DBGFIELD("WriteVecALUY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #440
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteVecALUZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 1, false, false, 13, 1,  8, 1,  1, 1}, // #443
  {DBGFIELD("WriteFHAddY")        1, false, false, 16, 1, 11, 1,  0, 0}, // #444
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #445
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #446
  {DBGFIELD("WriteVecLoadY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #447
  {DBGFIELD("WriteFMaskedStore64Y") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #448
  {DBGFIELD("WriteFMaskedLoadY")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #449
  {DBGFIELD("WriteFMaskedStore64") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #450
  {DBGFIELD("WriteFMaskedLoad")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #451
  {DBGFIELD("WriteFMaskedStore32Y") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #452
  {DBGFIELD("WriteFMaskedStore32") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #453
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #454
  {DBGFIELD("WriteFCmp64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #455
  {DBGFIELD("WriteFMoveY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #456
  {DBGFIELD("WriteFShuffleYLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #457
  {DBGFIELD("WriteFShuffleY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #458
  {DBGFIELD("WriteFShuffleZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #459
  {DBGFIELD("WriteFShuffleZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #460
  {DBGFIELD("WriteVecStoreY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #461
  {DBGFIELD("WriteVecMoveY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #462
  {DBGFIELD("WriteVecLoadNTY")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #463
  {DBGFIELD("WriteVecStoreNTY")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #464
  {DBGFIELD("WriteFStoreNTY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #465
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #466
  {DBGFIELD("WriteMPSADY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #467
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteFMul64Y")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #469
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #470
  {DBGFIELD("WriteFMul64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #471
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #472
  {DBGFIELD("WriteFMulY")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #473
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #474
  {DBGFIELD("WriteFMulZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #475
  {DBGFIELD("WriteVecALUYLd")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #476
  {DBGFIELD("WriteVecALUZLd")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #477
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #478
  {DBGFIELD("WriteVecLogicY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #479
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteVecLogicZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #481
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #482
  {DBGFIELD("WriteBlendY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #483
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #484
  {DBGFIELD("WriteVarBlendY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #485
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #486
  {DBGFIELD("WriteVarBlendZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #488
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #489
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #491
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false,  6, 2,  1, 1,  6, 2}, // #492
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false,  6, 2,  1, 1,  8, 2}, // #493
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #494
  {DBGFIELD("WriteFVarShuffle256") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #495
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("WriteFVarShuffleY")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #498
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #499
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #500
  {DBGFIELD("WriteFVarShuffle")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #501
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #502
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #503
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #504
  {DBGFIELD("WriteFVarShuffleZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #505
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 1, false, false, 16, 1, 11, 1,  1, 1}, // #506
  {DBGFIELD("WritePHAddY")        1, false, false,  8, 1,  4, 1,  0, 0}, // #507
  {DBGFIELD("WriteVecInsert")     1, false, false,  6, 2,  1, 1,  0, 0}, // #508
  {DBGFIELD("WriteVecIMulXLd")    1, false, false, 10, 2,  6, 1,  0, 0}, // #509
  {DBGFIELD("WriteVecIMulYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #510
  {DBGFIELD("WriteVecIMulZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #511
  {DBGFIELD("WriteVecMaskedStoreY") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #512
  {DBGFIELD("WriteVecMaskedLoadY") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #513
  {DBGFIELD("WriteVecMaskedStore") 1, false, false,  6, 2,  1, 1,  0, 0}, // #514
  {DBGFIELD("WriteVecMaskedLoad") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #515
  {DBGFIELD("WriteVecMOVMSKY")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #516
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #517
  {DBGFIELD("WritePMULLDY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #518
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #519
  {DBGFIELD("WritePMULLDZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #520
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, 11, 1,  6, 1,  6, 2}, // #521
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, 11, 1,  6, 1,  8, 2}, // #522
  {DBGFIELD("WriteVecShiftImmXLd") 1, false, false,  1, 1,  1, 1,  0, 0}, // #523
  {DBGFIELD("WriteVecShiftImmYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #524
  {DBGFIELD("WriteVecShiftImmY")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #525
  {DBGFIELD("WriteVecShiftImmZLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #526
  {DBGFIELD("WriteVecShiftImmZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #527
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #528
  {DBGFIELD("WriteVarVecShift")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #529
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #530
  {DBGFIELD("WriteVarVecShiftY")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #531
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #532
  {DBGFIELD("WriteVarVecShiftZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 1, false, false,  1, 1,  1, 1,  1, 1}, // #534
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #535
  {DBGFIELD("WriteVarShuffleY")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #536
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #537
  {DBGFIELD("WriteVarShuffleZ")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #538
  {DBGFIELD("WriteShuffleZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #539
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #540
  {DBGFIELD("WriteVecShiftY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #541
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #542
  {DBGFIELD("WriteVecShiftZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #543
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #544
  {DBGFIELD("WriteVecTestY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #545
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 1, false, false, 24, 1, 19, 1,  1, 1}, // #546
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #547
  {DBGFIELD("WriteFRcpY")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #548
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #549
  {DBGFIELD("WriteFRcpZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #550
  {DBGFIELD("WriteFRcpYLd")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #551
  {DBGFIELD("WriteFRndYLd")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #552
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 1, false, false, 24, 1, 19, 1,  1, 1}, // #553
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #554
  {DBGFIELD("WriteFRsqrtY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #555
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #556
  {DBGFIELD("WriteFRsqrtZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #557
  {DBGFIELD("WriteFRsqrtYLd")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #558
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #559
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #560
  {DBGFIELD("WriteFSqrt64YLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #561
  {DBGFIELD("WriteFSqrt64Y")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #562
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 1, false, false, 20, 1, 15, 1,  1, 1}, // #563
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #564
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #565
  {DBGFIELD("WriteFSqrt64Z")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #566
  {DBGFIELD("WriteFSqrtYLd")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #567
  {DBGFIELD("WriteFSqrtY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #568
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 1, false, false, 21, 1, 16, 1,  1, 1}, // #569
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #570
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #571
  {DBGFIELD("WriteFSqrtZ")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #572
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #573
  {DBGFIELD("WriteFTestY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #574
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #575
  {DBGFIELD("WriteFTest")         1, false, false,  1, 1,  1, 1,  0, 0}, // #576
  {DBGFIELD("WriteALULd_WriteRMW") 2, false, false, 32, 2, 24, 2,  0, 0}, // #577
  {DBGFIELD("WriteXCHG")          1, false, false,  3, 1,  3, 1,  0, 0}, // #578
  {DBGFIELD("COPY")               1, false, false,  1, 1,  1, 1,  0, 0}, // #579
  {DBGFIELD("FXAM")               1, false, false,  6, 2,  1, 1,  0, 0}, // #580
  {DBGFIELD("LD_Frr")             1, false, false,  6, 2,  1, 1,  0, 0}, // #581
  {DBGFIELD("MOVSX64rr32")        1, false, false,  6, 2,  1, 1,  0, 0}, // #582
  {DBGFIELD("RCL16m1_RCL16mi_RCL32m1_RCL32mi_RCL64m1_RCL64mi_RCL8m1_RCL8mi_RCR16m1_RCR16mi_RCR32m1_RCR32mi_RCR64m1_RCR64mi_RCR8m1_RCR8mi_ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 1, false, false,  6, 2,  1, 1,  0, 0}, // #583
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL_RCR16mCL_RCR32mCL_RCR64mCL_RCR8mCL_ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 1, false, false,  6, 2,  1, 1,  0, 0}, // #584
  {DBGFIELD("SAR16m1_SAR16mi_SAR32m1_SAR32mi_SAR64m1_SAR64mi_SAR8m1_SAR8mi_SHL16m1_SHL16mi_SHL32m1_SHL32mi_SHL64m1_SHL64mi_SHL8m1_SHL8mi_SHR16m1_SHR16mi_SHR32m1_SHR32mi_SHR64m1_SHR64mi_SHR8m1_SHR8mi") 1, false, false,  6, 2,  1, 1,  0, 0}, // #585
  {DBGFIELD("SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 1, false, false,  6, 2,  1, 1,  0, 0}, // #586
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false,  6, 2,  1, 1,  0, 0}, // #587
  {DBGFIELD("FCOMPP")             1, false, false,  4, 2,  1, 1,  0, 0}, // #588
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false,  4, 2,  1, 1,  0, 0}, // #589
  {DBGFIELD("MMX_CVTPI2PSirr")    1, false, false, 35, 2,  6, 1,  0, 0}, // #590
  {DBGFIELD("MMX_CVTPI2PSirm")    1, false, false, 35, 2,  6, 1,  0, 0}, // #591
  {DBGFIELD("MMX_CVTPS2PIirr_MMX_CVTTPS2PIirr") 1, false, false, 35, 2,  6, 1,  0, 0}, // #592
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, 37, 3,  1, 1,  0, 0}, // #593
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, 37, 3,  1, 1,  0, 0}, // #594
  {DBGFIELD("XCH_F")              1, false, false, 37, 3,  1, 1,  0, 0}, // #595
  {DBGFIELD("RETIL_RETIQ_RETIW_IRET_IRET16_IRET32_IRET64") 1, false, false, 37, 3,  1, 1,  0, 0}, // #596
  {DBGFIELD("MMX_CVTPS2PIirm_MMX_CVTTPS2PIirm") 1, false, false, 40, 3,  6, 1,  0, 0}, // #597
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 1, false, false, 40, 3,  6, 1,  0, 0}, // #598
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 1, false, false,  1, 1,  1, 1,  0, 0}, // #599
  {DBGFIELD("LFENCE")             1, false, false,  1, 1,  1, 1,  0, 0}, // #600
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false,  1, 1,  1, 1,  0, 0}, // #601
  {DBGFIELD("PSLLDQri_PSRLDQri")  1, false, false,  1, 1,  1, 1,  0, 0}, // #602
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr_MMX_PUNPCKHBWirr_MMX_PUNPCKHDQirr_MMX_PUNPCKHWDirr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #603
  {DBGFIELD("LEAVE_LEAVE64")      1, false, false,  3, 1,  3, 1,  0, 0}, // #604
  {DBGFIELD("POP16r")             1, false, false,  3, 1,  3, 1,  0, 0}, // #605
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 1, false, false,  3, 1,  3, 1,  0, 0}, // #606
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false,  3, 1,  3, 1,  0, 0}, // #607
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false,  3, 1,  3, 1,  0, 0}, // #608
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false,  3, 1,  3, 1,  0, 0}, // #609
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false,  3, 1,  3, 1,  0, 0}, // #610
  {DBGFIELD("MMX_PADDQirr_MMX_PSUBQirr") 1, false, false,  3, 1,  3, 1,  0, 0}, // #611
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false,  3, 1,  3, 1,  0, 0}, // #612
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 1, false, false,  3, 1,  3, 1,  0, 0}, // #613
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  1, false, false,  3, 1,  3, 1,  0, 0}, // #614
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false,  3, 1,  3, 1,  0, 0}, // #615
  {DBGFIELD("CLD")                1, false, false, 28, 1, 22, 1,  0, 0}, // #616
  {DBGFIELD("LDDQUrm")            1, false, false, 28, 1, 22, 1,  0, 0}, // #617
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, 28, 1, 22, 1,  0, 0}, // #618
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 1, false, false, 28, 1, 22, 1,  0, 0}, // #619
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 1, false, false, 28, 1, 22, 1,  0, 0}, // #620
  {DBGFIELD("PHADDDrr_PHSUBDrr")  1, false, false, 28, 1, 22, 1,  0, 0}, // #621
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, 28, 1, 22, 1,  0, 0}, // #622
  {DBGFIELD("MMX_PADDQirm_MMX_PSUBQirm") 1, false, false, 28, 1, 22, 1,  0, 0}, // #623
  {DBGFIELD("MOVDQUrm")           1, false, false, 28, 1, 22, 1,  0, 0}, // #624
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, 28, 1, 22, 1,  0, 0}, // #625
  {DBGFIELD("PADDQrm_PSUBQrm")    1, false, false, 28, 1, 22, 1,  0, 0}, // #626
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, 29, 1, 23, 1,  0, 0}, // #627
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   1, false, false, 29, 1, 23, 1,  0, 0}, // #628
  {DBGFIELD("LD_F80m")            1, false, false, 29, 1, 23, 1,  0, 0}, // #629
  {DBGFIELD("PHADDDrm_PHSUBDrm")  1, false, false, 29, 1, 23, 1,  0, 0}, // #630
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 1, false, false, 29, 1, 23, 1,  0, 0}, // #631
  {DBGFIELD("FLDCW16m")           1, false, false, 11, 1,  6, 1,  0, 0}, // #632
  {DBGFIELD("ST_FP80m")           1, false, false, 11, 1,  6, 1,  0, 0}, // #633
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 1, false, false, 11, 1,  6, 1,  0, 0}, // #634
  {DBGFIELD("CMPXCHG8rm")         1, false, false,  9, 1,  5, 1,  0, 0}, // #635
  {DBGFIELD("INTO")               1, false, false,  9, 1,  5, 1,  0, 0}, // #636
  {DBGFIELD("XLAT")               1, false, false,  9, 1,  5, 1,  0, 0}, // #637
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 1, false, false,  9, 1,  5, 1,  0, 0}, // #638
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false,  9, 1,  5, 1,  0, 0}, // #639
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 1, false, false,  9, 1,  5, 1,  0, 0}, // #640
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 1, false, false,  9, 1,  5, 1,  0, 0}, // #641
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 1, false, false,  9, 1,  5, 1,  0, 0}, // #642
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 1, false, false,  9, 1,  5, 1,  0, 0}, // #643
  {DBGFIELD("AAD8i8")             1, false, false,  8, 1,  4, 1,  0, 0}, // #644
  {DBGFIELD("LOOPE")              1, false, false, 16, 1, 11, 1,  0, 0}, // #645
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, 16, 1, 11, 1,  0, 0}, // #646
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 1, false, false, 16, 1, 11, 1,  0, 0}, // #647
  {DBGFIELD("FNSTCW16m")          1, false, false, 16, 1, 11, 1,  0, 0}, // #648
  {DBGFIELD("POPA16_POPA32")      1, false, false, 13, 1,  8, 1,  0, 0}, // #649
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, 13, 1,  8, 1,  0, 0}, // #650
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 1, false, false, 13, 1,  8, 1,  0, 0}, // #651
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 1, false, false, 13, 1,  8, 1,  0, 0}, // #652
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, 13, 1,  8, 1,  0, 0}, // #653
  {DBGFIELD("CMPXCHG8rr")         1, false, false, 13, 1,  8, 1,  0, 0}, // #654
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80_COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 13, 1,  8, 1,  0, 0}, // #655
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 1, false, false, 13, 1,  8, 1,  0, 0}, // #656
  {DBGFIELD("CVTTSS2SI64rr")      1, false, false, 13, 1,  8, 1,  0, 0}, // #657
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int") 1, false, false, 24, 1, 19, 1,  0, 0}, // #658
  {DBGFIELD("CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 1, false, false, 24, 1, 19, 1,  0, 0}, // #659
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, 14, 1,  9, 1,  0, 0}, // #660
  {DBGFIELD("AAA_AAS")            1, false, false, 43, 1, 27, 1,  0, 0}, // #661
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 1, false, false, 26, 1, 21, 1,  0, 0}, // #662
  {DBGFIELD("LOOPNE")             1, false, false, 44, 1, 28, 1,  0, 0}, // #663
  {DBGFIELD("PAUSE")              1, false, false, 44, 1, 28, 1,  0, 0}, // #664
  {DBGFIELD("CMPXCHG8B")          1, false, false, 45, 1, 29, 1,  0, 0}, // #665
  {DBGFIELD("DAA")                1, false, false, 45, 1, 29, 1,  0, 0}, // #666
  {DBGFIELD("LOOP")               1, false, false, 45, 1, 29, 1,  0, 0}, // #667
  {DBGFIELD("DAS")                1, false, false, 46, 1, 30, 1,  0, 0}, // #668
  {DBGFIELD("AAM8i8")             1, false, false, 47, 1, 31, 1,  0, 0}, // #669
  {DBGFIELD("STD")                1, false, false, 47, 1, 31, 1,  0, 0}, // #670
  {DBGFIELD("CMPXCHG16B")         1, false, false, 48, 1, 32, 1,  0, 0}, // #671
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, 49, 1, 33, 1,  0, 0}, // #672
  {DBGFIELD("FNCLEX_FXTRACT")     1, false, false, 50, 1, 34, 1,  0, 0}, // #673
  {DBGFIELD("POPF32_POPF64")      1, false, false, 51, 1, 35, 1,  0, 0}, // #674
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, 52, 1, 36, 1,  0, 0}, // #675
  {DBGFIELD("RDTSC_RDTSCP")       1, false, false, 53, 1, 37, 1,  0, 0}, // #676
  {DBGFIELD("ENTER")              1, false, false, 54, 1, 38, 1,  0, 0}, // #677
  {DBGFIELD("POPF16")             1, false, false, 54, 1, 38, 1,  0, 0}, // #678
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false, 55, 1, 39, 1,  0, 0}, // #679
  {DBGFIELD("FRNDINT")            1, false, false, 56, 1, 40, 1,  0, 0}, // #680
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false, 56, 1, 40, 1,  0, 0}, // #681
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, 57, 1, 41, 1,  0, 0}, // #682
  {DBGFIELD("FPREM")              1, false, false, 58, 1, 42, 1,  0, 0}, // #683
  {DBGFIELD("INSB_INSL_INSW")     1, false, false, 59, 1, 43, 1,  0, 0}, // #684
  {DBGFIELD("FNINIT")             1, false, false, 60, 1, 44, 1,  0, 0}, // #685
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 1, false, false, 19, 1, 14, 1,  0, 0}, // #686
  {DBGFIELD("FPREM1")             1, false, false, 34, 1, 26, 1,  0, 0}, // #687
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, 34, 1, 26, 1,  0, 0}, // #688
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 1, false, false, 61, 1, 45, 1,  0, 0}, // #689
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, 62, 1, 46, 1,  0, 0}, // #690
  {DBGFIELD("FSCALE")             1, false, false, 63, 1, 47, 1,  0, 0}, // #691
  {DBGFIELD("RDMSR")              1, false, false, 64, 1, 48, 1,  0, 0}, // #692
  {DBGFIELD("RET_RETL_RETQ_RETW_LRETIL_LRETIQ_LRETIW_LRETL_LRETQ_LRETW") 1, false, false, 65, 1, 49, 1,  0, 0}, // #693
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 1, false, false, 66, 1, 50, 1,  0, 0}, // #694
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 1, false, false, 67, 1, 51, 1,  0, 0}, // #695
  {DBGFIELD("F2XM1")              1, false, false, 68, 1, 52, 1,  0, 0}, // #696
  {DBGFIELD("CPUID")              1, false, false, 69, 1, 53, 1,  0, 0}, // #697
  {DBGFIELD("INT")                1, false, false, 70, 1, 54, 1,  0, 0}, // #698
  {DBGFIELD("INT3")               1, false, false, 18, 1, 13, 1,  0, 0}, // #699
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, 71, 1, 55, 1,  0, 0}, // #700
  {DBGFIELD("FXRSTOR_FXRSTOR64")  1, false, false, 72, 1, 56, 1,  0, 0}, // #701
  {DBGFIELD("FYL2X")              1, false, false, 73, 1, 57, 1,  0, 0}, // #702
  {DBGFIELD("FYL2XP1")            1, false, false, 74, 1, 58, 1,  0, 0}, // #703
  {DBGFIELD("FPTAN")              1, false, false, 75, 1, 59, 1,  0, 0}, // #704
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false, 76, 1, 60, 1,  0, 0}, // #705
  {DBGFIELD("FPATAN")             1, false, false, 77, 1, 61, 1,  0, 0}, // #706
  {DBGFIELD("WRMSR")              1, false, false, 78, 1, 62, 1,  0, 0}, // #707
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, 10, 2,  6, 1,  0, 0}, // #708
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false,  4, 2,  1, 1,  0, 0}, // #709
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 1, false, false,  1, 1,  1, 1,  0, 0}, // #710
  {DBGFIELD("FNOP")               1, false, false,  1, 1,  1, 1,  0, 0}, // #711
  {DBGFIELD("RETQ")               1, false, false, 65, 1, 49, 1,  0, 0}, // #712
  {DBGFIELD("CDQ_CQO")            1, false, false, 29, 1, 23, 1,  0, 0}, // #713
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #714
  {DBGFIELD("MMX_PADDQirr")       1, false, false,  3, 1,  3, 1,  0, 0}, // #715
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false,  6, 2,  1, 1,  0, 0}, // #716
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 1, false, false,  3, 1,  3, 1,  0, 0}, // #717
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 13, 1,  8, 1,  0, 0}, // #718
  {DBGFIELD("VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 1, false, false, 10, 2,  6, 1,  0, 0}, // #719
  {DBGFIELD("CWD")                1, false, false, 29, 1, 23, 1,  0, 0}, // #720
  {DBGFIELD("FNSTSW16r")          1, false, false,  1, 1,  1, 1,  0, 0}, // #721
  {DBGFIELD("MMX_MOVDQ2Qrr")      1, false, false,  1, 1,  1, 1,  0, 0}, // #722
  {DBGFIELD("PUSHFS64")           1, false, false,  3, 1,  3, 1,  0, 0}, // #723
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #724
  {DBGFIELD("RCL16r1_RCL32r1_RCL64r1_RCL8r1_RCR16r1_RCR32r1_RCR64r1_RCR8r1") 1, false, false,  6, 2,  1, 1,  0, 0}, // #725
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, 13, 1,  8, 1,  0, 0}, // #726
  {DBGFIELD("MOV64sr")            1, false, false,  1, 1,  1, 1,  0, 0}, // #727
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVSX32rm16_MOVSX32rm32_MOVSX32rm8_MOVSX32rm8_NOREX_MOVSX64rm16_MOVSX64rm32_MOVSX64rm8_MOVZX16rm16_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX_MOVZX64rm16_MOVZX64rm8") 1, false, false,  6, 2,  1, 1,  0, 0}, // #728
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCL8rCL_RCR16rCL_RCR32rCL_RCR64rCL_RCR8rCL") 1, false, false,  6, 2,  1, 1,  0, 0}, // #729
  {DBGFIELD("RCL16ri_RCL32ri_RCL64ri_RCL8ri_RCR16ri_RCR32ri_RCR64ri_RCR8ri") 1, false, false,  6, 2,  1, 1,  0, 0}, // #730
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 1, false, false, 37, 3,  1, 1,  0, 0}, // #731
  {DBGFIELD("CLI")                1, false, false,  1, 1,  2, 1,  0, 0}, // #732
  {DBGFIELD("PUSHGS64")           1, false, false,  3, 1,  3, 1,  0, 0}, // #733
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 1, false, false,  3, 1,  3, 1,  0, 0}, // #734
  {DBGFIELD("CALL64pcrel32")      1, false, false,  4, 2,  1, 1,  0, 0}, // #735
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 1, false, false,  4, 2,  1, 1,  0, 0}, // #736
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #737
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 1, false, false,  1, 1,  1, 1,  0, 0}, // #738
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #739
  {DBGFIELD("PUSHF16_PUSHF64")    1, false, false, 13, 1,  8, 1,  0, 0}, // #740
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 1, false, false,  6, 2,  1, 1,  0, 0}, // #741
  {DBGFIELD("MMX_MOVD64from64rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #742
  {DBGFIELD("VBROADCASTSSrm")     1, false, false,  6, 2,  1, 1,  0, 0}, // #743
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #744
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #745
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false,  6, 2,  1, 1,  0, 0}, // #746
  {DBGFIELD("MOV16sm")            1, false, false,  1, 1,  1, 1,  0, 0}, // #747
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #748
  {DBGFIELD("MMX_PALIGNRrmi")     1, false, false,  6, 2,  1, 1,  1, 1}, // #749
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 1, false, false,  6, 2,  1, 1,  1, 1}, // #750
  {DBGFIELD("LODSL_LODSQ")        1, false, false,  3, 1,  3, 1,  0, 0}, // #751
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #752
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #753
  {DBGFIELD("VINSERTF128rm")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #754
  {DBGFIELD("MMX_PADDQirm")       1, false, false, 28, 1, 22, 1,  0, 0}, // #755
  {DBGFIELD("VERRm_VERWm")        1, false, false,  1, 1,  2, 1,  0, 0}, // #756
  {DBGFIELD("FARJMP64")           1, false, false,  4, 2,  1, 1,  0, 0}, // #757
  {DBGFIELD("FNSTSWm")            1, false, false,  1, 1,  2, 1,  0, 0}, // #758
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 1, false, false,  1, 1,  2, 1,  0, 0}, // #759
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 1, false, false,  4, 2,  1, 1,  0, 0}, // #760
  {DBGFIELD("CALL64m_CALL64m_NT") 1, false, false,  4, 2,  1, 1,  0, 0}, // #761
  {DBGFIELD("VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 1, false, false, 10, 2,  6, 1,  1, 1}, // #762
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, 28, 1, 22, 1,  0, 0}, // #763
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 1, false, false,  6, 2,  1, 1,  0, 0}, // #764
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 1, false, false, 28, 1, 22, 1,  0, 0}, // #765
  {DBGFIELD("FARCALL64")          1, false, false,  4, 2,  1, 1,  0, 0}, // #766
  {DBGFIELD("CVTSD2SI64rm_Int_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int") 1, false, false, 13, 1,  8, 1,  0, 0}, // #767
  {DBGFIELD("CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int") 1, false, false, 13, 1,  8, 1,  0, 0}, // #768
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false,  6, 2,  1, 1,  0, 0}, // #769
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 1, false, false,  6, 2,  1, 1,  0, 0}, // #770
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #771
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 1, false, false, 10, 2,  6, 1,  0, 0}, // #772
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 1, false, false,  6, 2,  1, 1,  1, 1}, // #773
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 1, false, false, 10, 2,  6, 1,  0, 0}, // #774
  {DBGFIELD("MUL_F32m_MUL_F64m")  1, false, false, 30, 2, 23, 1,  0, 0}, // #775
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 1, false, false, 10, 2,  6, 1,  0, 0}, // #776
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 1, false, false, 30, 2, 23, 1,  0, 0}, // #777
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 1, false, false, 22, 1, 17, 1,  0, 0}, // #778
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 1, false, false, 22, 1, 17, 1,  0, 0}, // #779
  {DBGFIELD("VZEROALL")           1, false, false,  1, 1,  2, 1,  0, 0}, // #780
  {DBGFIELD("VZEROUPPER")         1, false, false,  1, 1,  2, 1,  0, 0}, // #781
  {DBGFIELD("CLC")                1, false, false,  1, 1,  1, 1,  0, 0}, // #782
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #783
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #784
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #785
  {DBGFIELD("PXORrr_VPXORrr")     1, false, false,  1, 1,  1, 1,  0, 0}, // #786
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #787
  {DBGFIELD("PSUBQrr")            1, false, false,  3, 1,  3, 1,  0, 0}, // #788
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #789
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #790
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 1, false, false,  6, 2,  1, 1,  1, 1}, // #791
  {DBGFIELD("SETCCr")             1, false, false,  1, 1,  1, 1,  0, 0}, // #792
  {DBGFIELD("SETCCm")             1, false, false,  3, 1,  3, 1,  0, 0}, // #793
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 1, false, false,  6, 2,  1, 1,  1, 1}, // #794
  {DBGFIELD("RETIL_RETIQ_RETIW")  1, false, false, 37, 3,  1, 1,  0, 0}, // #795
  {DBGFIELD("LRETIL_LRETIQ_LRETIW") 1, false, false, 65, 1, 49, 1,  0, 0}, // #796
  {DBGFIELD("RDPMC")              1, false, false, 56, 1, 40, 1,  0, 0}, // #797
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false,  1, 1,  2, 1,  0, 0}, // #798
  {DBGFIELD("FBLDm")              1, false, false,  1, 1,  2, 1,  0, 0}, // #799
  {DBGFIELD("FFREE_FFREEP")       1, false, false,  1, 1,  1, 1,  0, 0}, // #800
  {DBGFIELD("FSAVEm")             1, false, false,  1, 1,  2, 1,  0, 0}, // #801
  {DBGFIELD("FRSTORm")            1, false, false,  1, 1,  2, 1,  0, 0}, // #802
  {DBGFIELD("FXTRACT")            1, false, false, 50, 1, 34, 1,  0, 0}, // #803
  {DBGFIELD("MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #804
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #805
  {DBGFIELD("VBROADCASTF128")     1, false, false,  6, 2,  1, 1,  0, 0}, // #806
  {DBGFIELD("VBROADCASTI128")     1, false, false,  6, 2,  1, 1,  0, 0}, // #807
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #808
  {DBGFIELD("FBSTPm")             1, false, false,  1, 1,  2, 1,  0, 0}, // #809
  {DBGFIELD("VMPTRSTm")           1, false, false,  1, 1,  2, 1,  0, 0}, // #810
  {DBGFIELD("ST_FP32m_ST_FP64m")  1, false, false,  3, 1,  3, 1,  0, 0}, // #811
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #812
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #813
  {DBGFIELD("MMX_MOVQ2DQrr")      1, false, false,  1, 1,  1, 1,  0, 0}, // #814
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false,  4, 2,  1, 1,  0, 0}, // #815
  {DBGFIELD("FINCSTP")            1, false, false,  1, 1,  1, 1,  0, 0}, // #816
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false,  1, 1,  1, 1,  0, 0}, // #817
  {DBGFIELD("VPBLENDDYrri")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #818
  {DBGFIELD("VPBLENDDrri")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #819
  {DBGFIELD("CMC_STC")            1, false, false,  1, 1,  1, 1,  0, 0}, // #820
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false,  1, 1,  2, 1,  0, 0}, // #821
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 1, false, false, 16, 1, 11, 1,  0, 0}, // #822
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #823
  {DBGFIELD("CVTSS2SDrm")         1, false, false,  8, 1,  4, 1,  0, 0}, // #824
  {DBGFIELD("CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 1, false, false,  8, 1,  4, 1,  1, 1}, // #825
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #826
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 1, false, false,  6, 2,  1, 1,  1, 1}, // #827
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #828
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #829
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 1, false, false,  4, 2,  1, 1,  0, 0}, // #830
  {DBGFIELD("ANDN32rm_ANDN64rm")  1, false, false,  6, 2,  1, 1,  1, 1}, // #831
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #832
  {DBGFIELD("VINSERTI128rm")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #833
  {DBGFIELD("VPBLENDDrmi")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #834
  {DBGFIELD("VPBLENDDYrmi")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #835
  {DBGFIELD("POP32r_POP64r")      1, false, false, 37, 3,  1, 1,  0, 0}, // #836
  {DBGFIELD("SFENCE")             1, false, false,  6, 2,  1, 1,  0, 0}, // #837
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #838
  {DBGFIELD("MOVBE16mr")          1, false, false,  6, 2,  1, 1,  0, 0}, // #839
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 1, false, false, 37, 3,  1, 1,  0, 0}, // #840
  {DBGFIELD("MFENCE")             1, false, false,  6, 2,  1, 1,  0, 0}, // #841
  {DBGFIELD("XGETBV")             1, false, false,  1, 1,  2, 1,  0, 0}, // #842
  {DBGFIELD("CVTPS2PDrr_VCVTPS2PDrr") 1, false, false,  8, 1,  4, 1,  0, 0}, // #843
  {DBGFIELD("CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 1, false, false,  9, 1,  5, 1,  0, 0}, // #844
  {DBGFIELD("MMX_PACKSSDWirm_MMX_PACKSSWBirm_MMX_PACKUSWBirm") 1, false, false,  6, 2,  1, 1,  1, 1}, // #845
  {DBGFIELD("LRETQ_RETL")         1, false, false, 65, 1, 49, 1,  0, 0}, // #846
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 1, false, false,  6, 2,  1, 1,  0, 0}, // #847
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #848
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false,  9, 1,  5, 1,  0, 0}, // #849
  {DBGFIELD("VCVTDQ2PSYrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #850
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #851
  {DBGFIELD("CVTPS2DQrm_VCVTPS2DQrm_CVTTPS2DQrm_VCVTTPS2DQrm") 1, false, false,  8, 1,  4, 1,  0, 0}, // #852
  {DBGFIELD("VCVTDQ2PSYrm")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #853
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #854
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #855
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #856
  {DBGFIELD("CLDEMOTE")           1, false, false,  6, 2,  1, 1,  0, 0}, // #857
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int") 1, false, false, 16, 1, 11, 1,  0, 0}, // #858
  {DBGFIELD("CVTTSD2SI64rr_CVTTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr") 1, false, false, 16, 1, 11, 1,  0, 0}, // #859
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int_CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 1, false, false, 16, 1, 11, 1,  0, 0}, // #860
  {DBGFIELD("CVTTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr") 1, false, false, 16, 1, 11, 1,  0, 0}, // #861
  {DBGFIELD("VCVTPS2PDYrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #862
  {DBGFIELD("MMX_CVTPI2PDirr")    1, false, false,  8, 1,  4, 1,  0, 0}, // #863
  {DBGFIELD("MMX_CVTPD2PIirr_MMX_CVTTPD2PIirr") 1, false, false,  8, 1,  4, 1,  0, 0}, // #864
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 1, false, false,  8, 1,  4, 1,  0, 0}, // #865
  {DBGFIELD("CVTPD2PSrr_VCVTPD2PSrr") 1, false, false,  8, 1,  4, 1,  0, 0}, // #866
  {DBGFIELD("CVTSD2SSrr_CVTSD2SSrr_Int_VCVTSD2SSrr_VCVTSD2SSrr_Int") 1, false, false,  9, 1,  5, 1,  0, 0}, // #867
  {DBGFIELD("CVTSI2SDrr_CVTSI642SDrr") 1, false, false,  9, 1,  5, 1,  0, 1}, // #868
  {DBGFIELD("CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 1, false, false,  9, 1,  5, 1,  3, 1}, // #869
  {DBGFIELD("CVTSI2SSrr")         1, false, false,  9, 1,  5, 1,  0, 1}, // #870
  {DBGFIELD("CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int") 1, false, false,  9, 1,  5, 1,  3, 1}, // #871
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 1, false, false,  8, 1,  4, 1,  0, 0}, // #872
  {DBGFIELD("VCVTSD2SI64rm_Int_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 1, false, false, 13, 1,  8, 1,  0, 0}, // #873
  {DBGFIELD("CVTSS2SI64rm_Int")   1, false, false, 24, 1, 19, 1,  0, 0}, // #874
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 1, false, false, 13, 1,  8, 1,  0, 0}, // #875
  {DBGFIELD("VCVTPS2PDYrm")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #876
  {DBGFIELD("CVTPD2PSrm")         1, false, false, 16, 1, 11, 1,  0, 0}, // #877
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_MMX_CVTPD2PIirm_MMX_CVTTPD2PIirm") 1, false, false, 16, 1, 11, 1,  0, 0}, // #878
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 1, false, false, 16, 1, 11, 1,  0, 0}, // #879
  {DBGFIELD("MMX_CVTPI2PDirm")    1, false, false, 16, 1, 11, 1,  0, 0}, // #880
  {DBGFIELD("CVTSD2SSrm")         1, false, false,  8, 1,  4, 1,  0, 0}, // #881
  {DBGFIELD("CVTSD2SSrm_Int_VCVTSD2SSrm_VCVTSD2SSrm_Int") 1, false, false,  8, 1,  4, 1,  1, 1}, // #882
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #883
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 1, false, false,  1, 1,  2, 1,  0, 0}, // #884
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 1, false, false,  1, 1,  2, 1,  0, 0}, // #885
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, 30, 2, 23, 1,  0, 0}, // #886
  {DBGFIELD("VPCMPGTQYrm")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #887
  {DBGFIELD("CVTSI642SSrr")       1, false, false,  9, 1,  5, 1,  0, 1}, // #888
  {DBGFIELD("CVTSI642SSrr_Int_VCVTSI642SSrr_VCVTSI642SSrr_Int") 1, false, false,  9, 1,  5, 1,  3, 1}, // #889
  {DBGFIELD("STR16r_STR32r_STR64r") 1, false, false,  1, 1,  2, 1,  0, 0}, // #890
  {DBGFIELD("XSETBV")             1, false, false,  1, 1,  2, 1,  0, 0}, // #891
  {DBGFIELD("VCVTDQ2PDYrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #892
  {DBGFIELD("VCVTPD2PSYrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #893
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #894
  {DBGFIELD("VCVTDQ2PDYrm")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #895
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 1, false, false,  6, 2,  1, 1,  0, 0}, // #896
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 1, false, false,  6, 2,  1, 1,  0, 0}, // #897
  {DBGFIELD("RCL8rCL")            1, false, false,  6, 2,  1, 1,  0, 0}, // #898
  {DBGFIELD("RDTSC")              1, false, false, 53, 1, 37, 1,  0, 0}, // #899
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 1, false, false,  1, 1,  2, 1,  0, 0}, // #900
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, 22, 1, 17, 1,  0, 0}, // #901
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 1, false, false, 22, 1, 17, 1,  0, 0}, // #902
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 1, false, false, 22, 1, 17, 1,  0, 0}, // #903
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, 22, 1, 17, 1,  0, 0}, // #904
  {DBGFIELD("XSAVE64")            1, false, false,  1, 1,  2, 1,  0, 0}, // #905
  {DBGFIELD("XSAVE")              1, false, false,  1, 1,  2, 1,  0, 0}, // #906
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 1, false, false,  1, 1,  2, 1,  0, 0}, // #907
  {DBGFIELD("VMCLEARm")           1, false, false,  1, 1,  2, 1,  0, 0}, // #908
  {DBGFIELD("FLDENVm")            1, false, false,  1, 1,  2, 1,  0, 0}, // #909
  {DBGFIELD("FXRSTOR64")          1, false, false, 72, 1, 56, 1,  0, 0}, // #910
  {DBGFIELD("FSTENVm")            1, false, false,  1, 1,  2, 1,  0, 0}, // #911
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm_VPGATHERDDrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #912
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #913
  {DBGFIELD("VPGATHERQDYrm")      1, false, false,  6, 2,  1, 1,  0, 0}, // #914
  {DBGFIELD("VPGATHERQDrm")       1, false, false,  6, 2,  1, 1,  0, 0}, // #915
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #916
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #917
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #918
  {DBGFIELD("VGATHERQPSYrm")      1, false, false,  6, 2,  1, 1,  0, 0}, // #919
  {DBGFIELD("VGATHERQPSrm_VGATHERDPSrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #920
  {DBGFIELD("VPXORYrr")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #921
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #922
  {DBGFIELD("VPCMPGTQYrr")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #923
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false,  1, 1,  1, 1,  0, 0}, // #924
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 1, false, false,  1, 1,  1, 1,  0, 0}, // #925
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 1, false, false, 10, 2,  6, 1,  0, 0}, // #926
  {DBGFIELD("LRETQ")              1, false, false, 65, 1, 49, 1,  0, 0}, // #927
  {DBGFIELD("CVTDQ2PSrm_VCVTDQ2PSrm") 1, false, false,  8, 1,  4, 1,  0, 0}, // #928
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 1, false, false, 16, 1, 11, 1,  0, 0}, // #929
  {DBGFIELD("POPF64")             1, false, false, 51, 1, 35, 1,  0, 0}, // #930
  {DBGFIELD("VGATHERQPDrm")       1, false, false,  6, 2,  1, 1,  0, 0}, // #931
  {DBGFIELD("VGATHERQPDYrm")      1, false, false,  6, 2,  1, 1,  0, 0}, // #932
  {DBGFIELD("VGATHERDPDrm")       1, false, false,  6, 2,  1, 1,  0, 0}, // #933
  {DBGFIELD("VGATHERDPSrm")       1, false, false,  6, 2,  1, 1,  0, 0}, // #934
  {DBGFIELD("VGATHERDPDYrm")      1, false, false,  6, 2,  1, 1,  0, 0}, // #935
  {DBGFIELD("VGATHERDPSYrm")      1, false, false,  6, 2,  1, 1,  0, 0}, // #936
  {DBGFIELD("PCMPEQQrr")          1, false, false,  1, 1,  1, 1,  0, 0}, // #937
  {DBGFIELD("PCMPEQQrm")          1, false, false,  6, 2,  1, 1,  1, 1}, // #938
  {DBGFIELD("MOV16rm")            1, false, false,  6, 2,  1, 1,  0, 0}, // #939
  {DBGFIELD("MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX") 1, false, false,  6, 2,  1, 1,  0, 0}, // #940
  {DBGFIELD("POP16rmm")           1, false, false, 28, 1, 22, 1,  0, 0}, // #941
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 1, false, false,  3, 1,  3, 1,  0, 0}, // #942
  {DBGFIELD("PUSHF16")            1, false, false, 13, 1,  8, 1,  0, 0}, // #943
  {DBGFIELD("LAHF")               1, false, false,  3, 1,  3, 1,  0, 0}, // #944
  {DBGFIELD("ADD16mi_ADD16mi8_ADD16mr_ADD32mi_ADD32mi8_ADD32mr_ADD64mi32_ADD64mi8_ADD64mr_ADD8mi_ADD8mi8_ADD8mr_SUB16mi_SUB16mi8_SUB16mr_SUB32mi_SUB32mi8_SUB32mr_SUB64mi32_SUB64mi8_SUB64mr_SUB8mi_SUB8mi8_SUB8mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #945
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 1, false, false,  6, 2,  1, 1,  0, 0}, // #946
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 1, false, false,  6, 2,  1, 1,  0, 0}, // #947
  {DBGFIELD("MULX32rr")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #948
  {DBGFIELD("MULX32rm")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #949
  {DBGFIELD("MULX64rr")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #950
  {DBGFIELD("MULX64rm")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #951
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 1, false, false,  4, 2,  1, 1,  0, 0}, // #952
  {DBGFIELD("RETW_LRETL_LRETW")   1, false, false, 65, 1, 49, 1,  0, 0}, // #953
  {DBGFIELD("IRET16_IRET32_IRET64") 1, false, false, 37, 3,  1, 1,  0, 0}, // #954
  {DBGFIELD("AND16mi_AND16mi8_AND16mr_AND32mi_AND32mi8_AND32mr_AND64mi32_AND64mi8_AND64mr_AND8mi_AND8mi8_AND8mr_OR16mi_OR16mi8_OR16mr_OR32mi_OR32mi8_OR32mi8Locked_OR32mr_OR64mi32_OR64mi8_OR64mr_OR8mi_OR8mi8_OR8mr_XOR16mi_XOR16mi8_XOR16mr_XOR32mi_XOR32mi8_XOR32mr_XOR64mi32_XOR64mi8_XOR64mr_XOR8mi_XOR8mi8_XOR8mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #955
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 1, false, false, 29, 1, 23, 1,  0, 0}, // #956
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 1, false, false,  3, 1,  3, 1,  0, 0}, // #957
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 1, false, false, 29, 1, 23, 1,  0, 0}, // #958
  {DBGFIELD("MOVSLDUPrm")         1, false, false,  6, 2,  1, 1,  0, 0}, // #959
  {DBGFIELD("MOVSLDUPrr")         1, false, false,  6, 2,  1, 1,  0, 0}, // #960
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 1, false, false,  3, 1,  3, 1,  0, 0}, // #961
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false,  4, 2,  1, 1,  0, 0}, // #962
  {DBGFIELD("VPMOVSXBDYrr_VPMOVSXBQYrr_VPMOVSXBWYrr_VPMOVSXDQYrr_VPMOVSXWDYrr_VPMOVSXWQYrr_VPMOVZXBDYrr_VPMOVZXBQYrr_VPMOVZXBWYrr_VPMOVZXDQYrr_VPMOVZXWDYrr_VPMOVZXWQYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #963
  {DBGFIELD("VPMOVZXBDYrm_VPMOVZXBQYrm_VPMOVZXBWYrm_VPMOVZXDQYrm_VPMOVZXWQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #964
  {DBGFIELD("PBLENDWrri_VPBLENDWrri") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #965
  {DBGFIELD("VPBLENDWYrri")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #966
  {DBGFIELD("PBLENDWrmi_VPBLENDWrmi") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #967
  {DBGFIELD("VPBLENDWYrmi")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #968
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false,  6, 2,  1, 1,  0, 0}, // #969
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 1, false, false,  3, 1,  3, 1,  0, 0}, // #970
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 1, false, false,  6, 2,  1, 1,  0, 0}, // #971
  {DBGFIELD("VPMASKMOVDYrm")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #972
  {DBGFIELD("VPMASKMOVDrm")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #973
  {DBGFIELD("VPMASKMOVDYmr_VPMASKMOVQYmr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #974
  {DBGFIELD("VPMASKMOVDmr_VPMASKMOVQmr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #975
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #976
  {DBGFIELD("VPSLLDQri_VPSRLDQri") 1, false, false,  6, 2,  1, 1,  0, 0}, // #977
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #978
  {DBGFIELD("VPERM2F128rr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #979
  {DBGFIELD("VPERM2F128rm")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #980
  {DBGFIELD("VEXTRACTF128rr")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #981
  {DBGFIELD("VEXTRACTF128mr")     1, false, false,  6, 2,  1, 1,  0, 0}, // #982
  {DBGFIELD("VINSERTF128rr")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #983
  {DBGFIELD("VCVTPD2DQrm_VCVTTPD2DQrm") 1, false, false, 16, 1, 11, 1,  0, 0}, // #984
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #985
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 1, false, false, 16, 1, 11, 1,  0, 0}, // #986
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 1, false, false, 13, 1,  8, 1,  0, 0}, // #987
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false,  1, 1,  1, 1,  0, 0}, // #988
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false,  1, 1,  1, 1,  0, 0}, // #989
  {DBGFIELD("SHA256MSG2rm")       1, false, false, 10, 2,  6, 1,  1, 1}, // #990
  {DBGFIELD("SHA256MSG2rr")       1, false, false, 10, 2,  6, 1,  0, 0}, // #991
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, 10, 2,  6, 1,  0, 0}, // #992
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 1, false, false, 10, 2,  6, 1,  1, 1}, // #993
  {DBGFIELD("SHA1MSG2rr")         1, false, false, 10, 2,  6, 1,  0, 0}, // #994
  {DBGFIELD("SHA1MSG2rm")         1, false, false, 10, 2,  6, 1,  1, 1}, // #995
  {DBGFIELD("SHA1NEXTErr")        1, false, false, 10, 2,  6, 1,  0, 0}, // #996
  {DBGFIELD("SHA1NEXTErm")        1, false, false, 10, 2,  6, 1,  1, 1}, // #997
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, 10, 2,  6, 1,  0, 0}, // #998
  {DBGFIELD("SHA1RNDS4rmi")       1, false, false, 10, 2,  6, 1,  1, 1}, // #999
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, 10, 2,  6, 1,  0, 0}, // #1000
  {DBGFIELD("SHA256RNDS2rm")      1, false, false, 10, 2,  6, 1,  1, 1}, // #1001
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 1, false, false,  3, 1,  3, 1,  0, 0}, // #1002
  {DBGFIELD("BT16mi8_BT32mi8_BT64mi8") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1003
  {DBGFIELD("BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 1, false, false,  4, 2,  1, 1,  0, 0}, // #1004
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 1, false, false,  1, 1,  2, 1,  0, 0}, // #1005
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1006
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1007
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1008
  {DBGFIELD("ADC64ri32_SBB64ri32") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1009
  {DBGFIELD("CRC32r32r16")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #1010
  {DBGFIELD("CRC32r32r32")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #1011
  {DBGFIELD("CRC32r64r64")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #1012
  {DBGFIELD("SAHF")               1, false, false,  3, 1,  3, 1,  0, 0}, // #1013
  {DBGFIELD("BEXTRI32ri_BEXTRI64ri") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1014
  {DBGFIELD("BEXTRI32mi_BEXTRI64mi") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1015
  {DBGFIELD("RCR8ri")             1, false, false,  6, 2,  1, 1,  0, 0}, // #1016
  {DBGFIELD("RCL16rCL")           1, false, false,  6, 2,  1, 1,  0, 0}, // #1017
  {DBGFIELD("RCR16ri")            1, false, false,  6, 2,  1, 1,  0, 0}, // #1018
  {DBGFIELD("RCL32rCL_RCL64rCL")  1, false, false,  6, 2,  1, 1,  0, 0}, // #1019
  {DBGFIELD("RCR32rCL_RCR64rCL")  1, false, false,  6, 2,  1, 1,  0, 0}, // #1020
  {DBGFIELD("RCR32ri_RCR64ri")    1, false, false,  6, 2,  1, 1,  0, 0}, // #1021
  {DBGFIELD("RCL16ri")            1, false, false,  6, 2,  1, 1,  0, 0}, // #1022
  {DBGFIELD("RCL32ri_RCL64ri")    1, false, false,  6, 2,  1, 1,  0, 0}, // #1023
  {DBGFIELD("SHLD32rri8")         1, false, false,  3, 1,  3, 1,  0, 0}, // #1024
  {DBGFIELD("SHRD16rri8")         1, false, false,  9, 1,  5, 1,  0, 0}, // #1025
  {DBGFIELD("SHLD16rrCL")         1, false, false,  9, 1,  5, 1,  0, 0}, // #1026
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1027
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1028
  {DBGFIELD("TST_F")              1, false, false, 13, 1,  8, 1,  0, 0}, // #1029
  {DBGFIELD("VDPPSrri")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #1030
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr") 1, false, false, 10, 2,  6, 1,  0, 0}, // #1031
  {DBGFIELD("VFRCZSDrr_VFRCZSSrr") 1, false, false, 10, 2,  6, 1,  0, 0}, // #1032
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 1, false, false, 10, 2,  6, 1,  1, 1}, // #1033
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1034
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1035
  {DBGFIELD("MMX_CVTTPD2PIirr")   1, false, false,  8, 1,  4, 1,  0, 0}, // #1036
  {DBGFIELD("VMOVDQUYmr")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #1037
  {DBGFIELD("MOVDQArr")           1, false, false,  1, 1,  1, 1,  0, 0}, // #1038
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1039
  {DBGFIELD("VMPSADBWrri")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #1040
  {DBGFIELD("VPPERMrrr_VPPERMrrr_REV") 1, false, false, 29, 1, 23, 1,  0, 0}, // #1041
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 1, false, false,  8, 1,  4, 1,  0, 0}, // #1042
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 1, false, false, 16, 1, 11, 1,  1, 1}, // #1043
  {DBGFIELD("VPCLMULQDQrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1044
  {DBGFIELD("INSERTQ")            1, false, false,  1, 1,  1, 1,  0, 0}, // #1045
  {DBGFIELD("ANDNPSrr_VANDNPSrr_ANDNPDrr_VANDNPDrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1046
  {DBGFIELD("MMX_PXORirr_MMX_PANDNirr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1047
  {DBGFIELD("PANDNrr_VPANDNrr")   1, false, false,  1, 1,  1, 1,  0, 0}, // #1048
  {DBGFIELD("MMX_PSUBBirr_MMX_PSUBDirr_MMX_PSUBWirr_MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1049
  {DBGFIELD("LCMPXCHG8_LCMPXCHG16_LCMPXCHG32_LCMPXCHG64") 1, false, false,  2, 2,  1, 1,  0, 0}, // #1050
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 1, false, false, 15, 1, 10, 1,  0, 0}, // #1051
  {DBGFIELD("LCMPXCHG8B_LCMPXCHG16B") 1, false, false,  2, 2,  1, 1,  0, 0}, // #1052
  {DBGFIELD("XCHG8rr")            1, false, false,  3, 1,  3, 1,  0, 0}, // #1053
  {DBGFIELD("VANDNPSYrr_VANDNPDYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1054
  {DBGFIELD("MMX_PSUBSBirr_MMX_PSUBSWirr_MMX_PSUBUSBirr_MMX_PSUBUSWirr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1055
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1056
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false,  4, 2,  1, 1,  0, 0}, // #1057
  {DBGFIELD("LEA16r")             1, false, false,  4, 2,  1, 1,  0, 0}, // #1058
  {DBGFIELD("MMX_PADDSBirr_MMX_PADDSWirr_MMX_PADDUSBirr_MMX_PADDUSWirr_MMX_PAVGBirr_MMX_PAVGWirr_MMX_PCMPEQBirr_MMX_PCMPEQDirr_MMX_PCMPEQWirr_MMX_PMAXSWirr_MMX_PMINSWirr_MMX_PMAXUBirr_MMX_PMINUBirr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1059
  {DBGFIELD("MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1060
  {DBGFIELD("CLAC_STAC")          1, false, false,  1, 1,  2, 1,  0, 0}, // #1061
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1062
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1063
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, 10, 2,  6, 1,  0, 0}, // #1064
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 1, false, false, 11, 1,  6, 1,  0, 0}, // #1065
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 1, false, false,  8, 1,  4, 1,  0, 0}, // #1066
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 1, false, false,  8, 1,  4, 1,  0, 0}, // #1067
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false,  9, 1,  5, 1,  0, 0}, // #1068
  {DBGFIELD("VCVTPS2DQYrr_VCVTTPS2DQYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1069
  {DBGFIELD("MMX_PADDSBirm_MMX_PADDSWirm_MMX_PADDUSBirm_MMX_PADDUSWirm_MMX_PAVGBirm_MMX_PAVGWirm_MMX_PCMPEQBirm_MMX_PCMPEQDirm_MMX_PCMPEQWirm_MMX_PCMPGTBirm_MMX_PCMPGTDirm_MMX_PCMPGTWirm_MMX_PMAXSWirm_MMX_PMAXUBirm_MMX_PMINSWirm_MMX_PMINUBirm_MMX_PSUBSBirm_MMX_PSUBSWirm_MMX_PSUBUSBirm_MMX_PSUBUSWirm") 1, false, false,  6, 2,  1, 1,  1, 1}, // #1070
  {DBGFIELD("CVTSS2SI64rr_Int")   1, false, false, 13, 1,  8, 1,  0, 0}, // #1071
  {DBGFIELD("CVTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int") 1, false, false, 16, 1, 11, 1,  0, 0}, // #1072
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 1, false, false,  6, 2,  1, 1,  1, 1}, // #1073
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1074
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 1, false, false,  9, 1,  5, 1,  0, 0}, // #1075
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 1, false, false, 16, 1, 11, 1,  1, 1}, // #1076
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 1, false, false, 16, 1, 11, 1,  1, 1}, // #1077
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 1, false, false,  1, 1,  2, 1,  0, 0}, // #1078
  {DBGFIELD("PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1079
  {DBGFIELD("VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1080
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1081
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1082
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1083
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1084
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1085
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1086
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1087
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1088
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1089
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1090
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1091
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1092
  {DBGFIELD("KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1093
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1094
  {DBGFIELD("VPSADBWZrr")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #1095
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_VPTESTMBZ128rr_VPTESTMBZ128rrk_VPTESTMDZ128rr_VPTESTMDZ128rrk_VPTESTMQZ128rr_VPTESTMQZ128rrk_VPTESTMWZ128rr_VPTESTMWZ128rrk_VPTESTNMBZ128rr_VPTESTNMBZ128rrk_VPTESTNMDZ128rr_VPTESTNMDZ128rrk_VPTESTNMQZ128rr_VPTESTNMQZ128rrk_VPTESTNMWZ128rr_VPTESTNMWZ128rrk") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1096
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri_KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1097
  {DBGFIELD("VALIGNDZ128rri_VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rri_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1098
  {DBGFIELD("VALIGNDZ256rri_VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rri_VALIGNQZ256rrik_VALIGNQZ256rrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1099
  {DBGFIELD("VALIGNDZrri_VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrri_VALIGNQZrrik_VALIGNQZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1100
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, 10, 2,  6, 1,  0, 0}, // #1101
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1102
  {DBGFIELD("VCMPPDZrri_VCMPPDZrrib_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrrib_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1103
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, 10, 2,  6, 1,  0, 0}, // #1104
  {DBGFIELD("VDBPSADBWZrri_VDBPSADBWZrrik_VDBPSADBWZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1105
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rrik_VPCMPDZ128rri_VPCMPDZ128rrik_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rrik_VPCMPUBZ128rri_VPCMPUBZ128rrik_VPCMPUDZ128rri_VPCMPUDZ128rrik_VPCMPUQZ128rri_VPCMPUQZ128rrik_VPCMPUWZ128rri_VPCMPUWZ128rrik_VPCMPWZ128rri_VPCMPWZ128rrik_VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1106
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rrik_VPCMPDZ256rri_VPCMPDZ256rrik_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rrik_VPCMPUBZ256rri_VPCMPUBZ256rrik_VPCMPUDZ256rri_VPCMPUDZ256rrik_VPCMPUQZ256rri_VPCMPUQZ256rrik_VPCMPUWZ256rri_VPCMPUWZ256rrik_VPCMPWZ256rri_VPCMPWZ256rrik_VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1107
  {DBGFIELD("VPCMPBZrri_VPCMPBZrrik_VPCMPDZrri_VPCMPDZrrik_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrrik_VPCMPUBZrri_VPCMPUBZrrik_VPCMPUDZrri_VPCMPUDZrrik_VPCMPUQZrri_VPCMPUQZrrik_VPCMPUWZrri_VPCMPUWZrrik_VPCMPWZrri_VPCMPWZrrik_VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1108
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1109
  {DBGFIELD("VPTESTMBZrr_VPTESTMBZrrk_VPTESTMDZrr_VPTESTMDZrrk_VPTESTMQZrr_VPTESTMQZrrk_VPTESTMWZrr_VPTESTMWZrrk_VPTESTNMBZrr_VPTESTNMBZrrk_VPTESTNMDZrr_VPTESTNMDZrrk_VPTESTNMQZrr_VPTESTNMQZrrk_VPTESTNMWZrr_VPTESTNMWZrrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1110
  {DBGFIELD("VCVTDQ2PSZ128rr_VCVTDQ2PSZ128rrk_VCVTDQ2PSZ128rrkz_VCVTUDQ2PSZ128rr_VCVTUDQ2PSZ128rrk_VCVTUDQ2PSZ128rrkz") 1, false, false,  9, 1,  5, 1,  0, 0}, // #1111
  {DBGFIELD("VCVTDQ2PSZ256rr_VCVTDQ2PSZ256rrk_VCVTDQ2PSZ256rrkz_VCVTUDQ2PSZ256rr_VCVTUDQ2PSZ256rrk_VCVTUDQ2PSZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1112
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 1, false, false,  8, 1,  4, 1,  0, 0}, // #1113
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1114
  {DBGFIELD("VCVTPS2DQYrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1115
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false,  9, 1,  5, 1,  0, 0}, // #1116
  {DBGFIELD("VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1117
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 1, false, false,  8, 1,  4, 1,  0, 0}, // #1118
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1119
  {DBGFIELD("VCVTDQ2PSZrr_VCVTUDQ2PSZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1120
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1121
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1122
  {DBGFIELD("VCVTQQ2PDZrr_VCVTUQQ2PDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1123
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1124
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1125
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1126
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 1, false, false,  8, 1,  4, 1,  0, 0}, // #1127
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 1, false, false,  8, 1,  4, 1,  0, 0}, // #1128
  {DBGFIELD("VCVTPD2PSZ128rr_VCVTPD2PSZ128rrk_VCVTPD2PSZ128rrkz") 1, false, false,  8, 1,  4, 1,  0, 0}, // #1129
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz") 1, false, false,  8, 1,  4, 1,  0, 0}, // #1130
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false,  9, 1,  5, 1,  0, 0}, // #1131
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false,  9, 1,  5, 1,  0, 0}, // #1132
  {DBGFIELD("VCVTSD2SSZrr_VCVTSD2SSZrr_Int_VCVTSD2SSZrr_Intk_VCVTSD2SSZrr_Intkz_VCVTSD2SSZrrb_Int_VCVTSD2SSZrrb_Intk_VCVTSD2SSZrrb_Intkz") 1, false, false,  9, 1,  5, 1,  0, 0}, // #1133
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 1, false, false,  9, 1,  5, 1,  3, 1}, // #1134
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 1, false, false,  9, 1,  5, 1,  3, 1}, // #1135
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz") 1, false, false,  9, 1,  5, 1,  0, 0}, // #1136
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1137
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1138
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1139
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1140
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1141
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1142
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1143
  {DBGFIELD("VMOVDI2PDIZrm")      1, false, false,  6, 2,  1, 1,  0, 0}, // #1144
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 1, false, false,  9, 1,  5, 1,  3, 1}, // #1145
  {DBGFIELD("VMOVSDZrm_VMOVSDZrm_alt_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrm_alt_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1146
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1147
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1148
  {DBGFIELD("VCVTPD2PSZ256rr_VCVTPD2PSZ256rrk_VCVTPD2PSZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1149
  {DBGFIELD("VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1150
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1151
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1152
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1153
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1154
  {DBGFIELD("VCVTPD2PSZrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1155
  {DBGFIELD("VCVTPS2PDZrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1156
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1157
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1158
  {DBGFIELD("VMOVNTDQAZ128rm")    1, false, false,  6, 2,  1, 1,  0, 0}, // #1159
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1160
  {DBGFIELD("VBROADCASTI32X2Z128m_VBROADCASTI32X2Z128mk_VBROADCASTI32X2Z128mkz_VPBROADCASTDZ128m_VPBROADCASTDZ128mk_VPBROADCASTDZ128mkz_VPBROADCASTQZ128m_VPBROADCASTQZ128mk_VPBROADCASTQZ128mkz") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1161
  {DBGFIELD("VBROADCASTSSZ128m_VBROADCASTSSZ128mk_VBROADCASTSSZ128mkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1162
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1163
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1164
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1165
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 1, false, false,  6, 2,  1, 1,  1, 1}, // #1166
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1167
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1168
  {DBGFIELD("VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 1, false, false, 16, 1, 11, 1,  0, 0}, // #1169
  {DBGFIELD("VCVTSS2SI64rr_Int")  1, false, false, 16, 1, 11, 1,  0, 0}, // #1170
  {DBGFIELD("VCVTTSS2SI64rr")     1, false, false, 16, 1, 11, 1,  0, 0}, // #1171
  {DBGFIELD("VCVTTSS2SI64rr_Int") 1, false, false, 16, 1, 11, 1,  0, 0}, // #1172
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1173
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1174
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1175
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1176
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1177
  {DBGFIELD("VSCATTERDPSZmr")     1, false, false,  6, 2,  1, 1,  0, 0}, // #1178
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk") 1, false, false, 10, 2,  6, 1,  1, 1}, // #1179
  {DBGFIELD("VPBROADCASTBZ256m_VPBROADCASTBZ256mk_VPBROADCASTBZ256mkz_VPBROADCASTBZm_VPBROADCASTBZmk_VPBROADCASTBZmkz_VPBROADCASTWZ256m_VPBROADCASTWZ256mk_VPBROADCASTWZ256mkz_VPBROADCASTWZm_VPBROADCASTWZmk_VPBROADCASTWZmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1180
  {DBGFIELD("VMOVNTDQAZ256rm")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #1181
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1182
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1183
  {DBGFIELD("VBROADCASTF32X2Z256m_VBROADCASTF32X2Z256mk_VBROADCASTF32X2Z256mkz_VBROADCASTF32X2Zm_VBROADCASTF32X2Zmk_VBROADCASTF32X2Zmkz_VBROADCASTI32X2Z256m_VBROADCASTI32X2Z256mk_VBROADCASTI32X2Z256mkz_VBROADCASTI32X2Zm_VBROADCASTI32X2Zmk_VBROADCASTI32X2Zmkz_VPBROADCASTDZ256m_VPBROADCASTDZ256mk_VPBROADCASTDZ256mkz_VPBROADCASTDZm_VPBROADCASTDZmk_VPBROADCASTDZmkz_VPBROADCASTQZ256m_VPBROADCASTQZ256mk_VPBROADCASTQZ256mkz_VPBROADCASTQZm_VPBROADCASTQZmk_VPBROADCASTQZmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1184
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1185
  {DBGFIELD("VBROADCASTSDZ256m_VBROADCASTSDZ256mk_VBROADCASTSDZ256mkz_VBROADCASTSDZm_VBROADCASTSDZmk_VBROADCASTSDZmkz_VBROADCASTSSZ256m_VBROADCASTSSZ256mk_VBROADCASTSSZ256mkz_VBROADCASTSSZm_VBROADCASTSSZmk_VBROADCASTSSZmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1186
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1187
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1188
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1189
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1190
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1191
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1192
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1193
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1194
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1195
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1196
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1197
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1198
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1199
  {DBGFIELD("VPSCATTERDDZmr")     1, false, false,  6, 2,  1, 1,  0, 0}, // #1200
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 1, false, false,  6, 2,  1, 1,  1, 1}, // #1201
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmik") 1, false, false, 10, 2,  6, 1,  1, 1}, // #1202
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 1, false, false, 10, 2,  6, 1,  1, 1}, // #1203
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmik_VPCMPDZ128rmi_VPCMPDZ128rmib_VPCMPDZ128rmibk_VPCMPDZ128rmik_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmib_VPCMPQZ128rmibk_VPCMPQZ128rmik_VPCMPUBZ128rmi_VPCMPUBZ128rmik_VPCMPUDZ128rmi_VPCMPUDZ128rmib_VPCMPUDZ128rmibk_VPCMPUDZ128rmik_VPCMPUQZ128rmi_VPCMPUQZ128rmib_VPCMPUQZ128rmibk_VPCMPUQZ128rmik_VPCMPUWZ128rmi_VPCMPUWZ128rmik_VPCMPWZ128rmi_VPCMPWZ128rmik_VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 1, false, false,  6, 2,  1, 1,  1, 1}, // #1204
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1205
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1206
  {DBGFIELD("VPMOVSXBDZ128rm_VPMOVSXBDZ128rmk_VPMOVSXBDZ128rmkz_VPMOVSXBQZ128rm_VPMOVSXBQZ128rmk_VPMOVSXBQZ128rmkz_VPMOVSXBWZ128rm_VPMOVSXBWZ128rmk_VPMOVSXBWZ128rmkz_VPMOVSXDQZ128rm_VPMOVSXDQZ128rmk_VPMOVSXDQZ128rmkz_VPMOVSXWDZ128rm_VPMOVSXWDZ128rmk_VPMOVSXWDZ128rmkz_VPMOVSXWQZ128rm_VPMOVSXWQZ128rmk_VPMOVSXWQZ128rmkz_VPMOVZXBDZ128rm_VPMOVZXBDZ128rmk_VPMOVZXBDZ128rmkz_VPMOVZXBQZ128rm_VPMOVZXBQZ128rmk_VPMOVZXBQZ128rmkz_VPMOVZXBWZ128rm_VPMOVZXBWZ128rmk_VPMOVZXBWZ128rmkz_VPMOVZXDQZ128rm_VPMOVZXDQZ128rmk_VPMOVZXDQZ128rmkz_VPMOVZXWDZ128rm_VPMOVZXWDZ128rmk_VPMOVZXWDZ128rmkz_VPMOVZXWQZ128rm_VPMOVZXWQZ128rmk_VPMOVZXWQZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1207
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 1, false, false,  6, 2,  1, 1,  1, 1}, // #1208
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1209
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1210
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmik") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1211
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmik") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1212
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmik_VPCMPDZ256rmi_VPCMPDZ256rmib_VPCMPDZ256rmibk_VPCMPDZ256rmik_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmib_VPCMPQZ256rmibk_VPCMPQZ256rmik_VPCMPUBZ256rmi_VPCMPUBZ256rmik_VPCMPUDZ256rmi_VPCMPUDZ256rmib_VPCMPUDZ256rmibk_VPCMPUDZ256rmik_VPCMPUQZ256rmi_VPCMPUQZ256rmib_VPCMPUQZ256rmibk_VPCMPUQZ256rmik_VPCMPUWZ256rmi_VPCMPUWZ256rmik_VPCMPWZ256rmi_VPCMPWZ256rmik_VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1213
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmik_VPCMPDZrmi_VPCMPDZrmib_VPCMPDZrmibk_VPCMPDZrmik_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmib_VPCMPQZrmibk_VPCMPQZrmik_VPCMPUBZrmi_VPCMPUBZrmik_VPCMPUDZrmi_VPCMPUDZrmib_VPCMPUDZrmibk_VPCMPUDZrmik_VPCMPUQZrmi_VPCMPUQZrmib_VPCMPUQZrmibk_VPCMPUQZrmik_VPCMPUWZrmi_VPCMPUWZrmik_VPCMPWZrmi_VPCMPWZrmik_VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1214
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1215
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1216
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 1, false, false, 16, 1, 11, 1,  0, 0}, // #1217
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 1, false, false,  8, 1,  4, 1,  0, 0}, // #1218
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 1, false, false, 16, 1, 11, 1,  0, 0}, // #1219
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1220
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 1, false, false,  8, 1,  4, 1,  0, 0}, // #1221
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 1, false, false, 16, 1, 11, 1,  0, 0}, // #1222
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz") 1, false, false,  8, 1,  4, 1,  1, 1}, // #1223
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1224
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1225
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1226
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1227
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1228
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1229
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1230
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1231
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1232
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1233
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1234
  {DBGFIELD("VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1235
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1236
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1237
  {DBGFIELD("VCVTSD2SSZrm_VCVTSD2SSZrm_Int_VCVTSD2SSZrm_Intk_VCVTSD2SSZrm_Intkz") 1, false, false,  8, 1,  4, 1,  1, 1}, // #1238
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1239
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, 10, 2,  6, 1,  0, 0}, // #1240
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1241
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1242
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1243
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 1, false, false, 13, 1,  8, 1,  1, 1}, // #1244
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 1, false, false, 13, 1,  8, 1,  1, 1}, // #1245
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1246
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1247
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1248
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1249
  {DBGFIELD("VCVTPD2PSZrm_VCVTPD2PSZrmb_VCVTPD2PSZrmbk_VCVTPD2PSZrmbkz_VCVTPD2PSZrmk_VCVTPD2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1250
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1251
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1252
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1253
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 1, false, false, 10, 2,  6, 1,  1, 1}, // #1254
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1255
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1256
  {DBGFIELD("VGATHERDPSZ128rm_VGATHERQPSZrm_VPGATHERDDZ128rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1257
  {DBGFIELD("VGATHERQPSZ128rm_VGATHERQPSZ256rm_VPGATHERQDZ128rm_VPGATHERQDZ256rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1258
  {DBGFIELD("VGATHERDPDZ128rm_VGATHERQPDZ128rm_VPGATHERDQZ128rm_VPGATHERQQZ128rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1259
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1260
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1261
  {DBGFIELD("VGATHERDPDZ256rm_VGATHERQPDZ256rm_VPGATHERDQZ256rm_VPGATHERQDZrm_VPGATHERQQZ256rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1262
  {DBGFIELD("VGATHERDPDZrm_VGATHERQPDZrm_VPGATHERDQZrm_VPGATHERQQZrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1263
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1264
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1265
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1266
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1267
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1268
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1269
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1270
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1271
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1272
  {DBGFIELD("VXORPSZ128rr_VXORPDZ128rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1273
  {DBGFIELD("VXORPSZ256rr_VXORPDZ256rr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1274
  {DBGFIELD("VXORPSZrr_VXORPDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1275
  {DBGFIELD("VPXORDZ128rr_VPXORQZ128rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1276
  {DBGFIELD("VPXORDZ256rr_VPXORQZ256rr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1277
  {DBGFIELD("VPXORDZrr_VPXORQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1278
  {DBGFIELD("VPSUBBZ128rr_VPSUBDZ128rr_VPSUBQZ128rr_VPSUBWZ128rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1279
  {DBGFIELD("VPSUBBZ256rr_VPSUBDZ256rr_VPSUBQZ256rr_VPSUBWZ256rr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1280
  {DBGFIELD("VPSUBBZrr_VPSUBDZrr_VPSUBQZrr_VPSUBWZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1281
  {DBGFIELD("PdWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1282
  {DBGFIELD("WriteVecALU")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1283
  {DBGFIELD("JWriteZeroLatency")  0, false, false,  0, 0,  0, 0,  0, 0}, // #1284
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1285
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1286
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1287
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1288
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1289
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1290
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1291
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1292
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1293
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1294
  {DBGFIELD("JWriteLOCK_CMPXCHG8B") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1295
  {DBGFIELD("JWriteLOCK_CMPXCHG16B") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1296
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1297
  {DBGFIELD("JWriteLOCK_CMPXCHGrm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1298
  {DBGFIELD("JWriteCMPXCHG8B")    0, false, false,  0, 0,  0, 0,  0, 0}, // #1299
  {DBGFIELD("JWriteCMPXCHG16B")   0, false, false,  0, 0,  0, 0,  0, 0}, // #1300
  {DBGFIELD("JWriteCMPXCHG8rm")   0, false, false,  0, 0,  0, 0,  0, 0}, // #1301
  {DBGFIELD("WriteCMPXCHGRMW")    0, false, false,  0, 0,  0, 0,  0, 0}, // #1302
  {DBGFIELD("JWriteCMPXCHG8rr")   0, false, false,  0, 0,  0, 0,  0, 0}, // #1303
  {DBGFIELD("WriteCMPXCHG")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1304
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1305
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1306
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1307
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1308
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1309
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1310
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1311
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1312
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1313
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1314
  {DBGFIELD("JWriteLOCK_XADDrm_XCHG_Part_JWriteXCHGrm_LdSt_Part_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1315
  {DBGFIELD("JWriteXADDrm_XCHG_Part_JWriteXADDrm_LdSt_Part_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1316
  {DBGFIELD("SBWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1317
  {DBGFIELD("WriteALU")           0, false, false,  0, 0,  0, 0,  0, 0}, // #1318
  {DBGFIELD("HWWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1319
  {DBGFIELD("BWWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1320
  {DBGFIELD("SKLWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1321
  {DBGFIELD("SKXWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1322
  {DBGFIELD("WriteFLogic")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1323
  {DBGFIELD("WriteFLogicY")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1324
  {DBGFIELD("JWriteZeroIdiomYmm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1325
  {DBGFIELD("WriteVecLogicX")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1326
  {DBGFIELD("WriteVecALUX")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1327
  {DBGFIELD("SKLWritePSUB")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1328
  {DBGFIELD("SKXWritePSUB")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1329
  {DBGFIELD("SBWritePCMPGTQ")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1330
  {DBGFIELD("HWWritePCMPGTQ")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1331
  {DBGFIELD("BWWritePCMPGTQ")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1332
  {DBGFIELD("SKLWritePCMPGTQ")    0, false, false,  0, 0,  0, 0,  0, 0}, // #1333
  {DBGFIELD("SKXWritePCMPGTQ")    0, false, false,  0, 0,  0, 0,  0, 0}, // #1334
  {DBGFIELD("SBWriteCMOVA_CMOVBErr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1335
  {DBGFIELD("WriteCMOV")          0, false, false,  0, 0,  0, 0,  0, 0}, // #1336
  {DBGFIELD("HWWriteCMOVA_CMOVBErr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1337
  {DBGFIELD("BWWriteCMOVA_CMOVBErr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1338
  {DBGFIELD("SKLWriteCMOVA_CMOVBErr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1339
  {DBGFIELD("SKXWriteCMOVA_CMOVBErr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1340
  {DBGFIELD("SBWriteCMOVA_CMOVBErm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1341
  {DBGFIELD("WriteCMOVLd")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1342
  {DBGFIELD("HWWriteCMOVA_CMOVBErm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1343
  {DBGFIELD("BWWriteCMOVA_CMOVBErm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1344
  {DBGFIELD("PdWriteCMOVm")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1345
  {DBGFIELD("SKLWriteCMOVA_CMOVBErm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1346
  {DBGFIELD("SKXWriteCMOVA_CMOVBErm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1347
  {DBGFIELD("SBWriteSETA_SETBEr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1348
  {DBGFIELD("WriteSETCC")         0, false, false,  0, 0,  0, 0,  0, 0}, // #1349
  {DBGFIELD("HWWriteSETA_SETBEr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1350
  {DBGFIELD("BWWriteSETA_SETBEr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1351
  {DBGFIELD("SKLWriteSETA_SETBEr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1352
  {DBGFIELD("SKXWriteSETA_SETBEr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1353
  {DBGFIELD("SBWriteSETA_SETBEm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1354
  {DBGFIELD("WriteSETCCStore")    0, false, false,  0, 0,  0, 0,  0, 0}, // #1355
  {DBGFIELD("HWWriteSETA_SETBEm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1356
  {DBGFIELD("BWWriteSETA_SETBEm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1357
  {DBGFIELD("PdWriteSETGEmSETGmSETLEmSETLm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1358
  {DBGFIELD("SKLWriteSETA_SETBEm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1359
  {DBGFIELD("SKXWriteSETA_SETBEm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1360
  {DBGFIELD("WriteVecLogicY")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1361
  {DBGFIELD("WriteVecALUY")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1362
  {DBGFIELD("HWWriteADC0")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1363
  {DBGFIELD("WriteADC")           0, false, false,  0, 0,  0, 0,  0, 0}, // #1364
  {DBGFIELD("JWriteLOCK_ALURMW")  0, false, false,  0, 0,  0, 0,  0, 0}, // #1365
  {DBGFIELD("WriteALURMW")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1366
  {DBGFIELD("WriteFShuffle256")   0, false, false,  0, 0,  0, 0,  0, 0}, // #1367
  {DBGFIELD("WriteVecLogic")      0, false, false,  0, 0,  0, 0,  0, 0}, // #1368
  {DBGFIELD("JWrite3OpsLEA")      0, false, false,  0, 0,  0, 0,  0, 0}, // #1369
  {DBGFIELD("WriteLEA")           0, false, false,  0, 0,  0, 0,  0, 0}, // #1370
  {DBGFIELD("WriteFLogicZ")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1371
  {DBGFIELD("WriteVecLogicZ")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1372
}; // AtomModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc BdVer2ModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  16383, false, false,  0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false, 79, 2,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false, 81, 3,  3, 1,  0, 0}, // #3
  {DBGFIELD("WriteCMPXCHGRMW")    2, false, false, 84, 6, 22, 1,  0, 0}, // #4
  {DBGFIELD("WriteJumpLd")        1, false, false, 90, 6,  6, 1,  0, 0}, // #5
  {DBGFIELD("WriteMove")          1, false, false, 79, 2,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteJump")          1, false, false, 91, 4,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, 96, 2,  2, 1,  0, 0}, // #8
  {DBGFIELD("WriteSHDrri")        6, false, false, 98, 2, 22, 1,  0, 0}, // #9
  {DBGFIELD("WriteFStoreX")       1, false, false, 100, 5,  1, 1,  0, 0}, // #10
  {DBGFIELD("WriteFLoadX")        1, false, false, 105, 5,  6, 1,  0, 0}, // #11
  {DBGFIELD("WriteFStoreY")       4, false, false, 110, 5,  1, 1,  0, 0}, // #12
  {DBGFIELD("WriteFLoadY")        2, false, false, 105, 5,  6, 1,  0, 0}, // #13
  {DBGFIELD("WriteMicrocoded")    1, false, false, 96, 2,  2, 1,  0, 0}, // #14
  {DBGFIELD("WriteFSign")         1, false, false, 115, 4,  1, 1,  0, 0}, // #15
  {DBGFIELD("WriteADC")           1, false, false, 79, 2,  1, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCRMW")        2, false, false, 119, 5,  5, 1,  0, 0}, // #17
  {DBGFIELD("WriteADCLd_ReadAfterLd") 1, false, false, 124, 4,  6, 1, 10, 1}, // #18
  {DBGFIELD("WriteALURMW")        1, false, false, 119, 5,  5, 1,  0, 0}, // #19
  {DBGFIELD("WriteALULd_ReadAfterLd") 1, false, false, 124, 4,  6, 1, 10, 1}, // #20
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 1, false, false, 128, 6, 19, 1, 11, 1}, // #21
  {DBGFIELD("WriteFAdd64X")       1, false, false, 129, 4,  6, 1,  0, 0}, // #22
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 1, false, false, 128, 6, 19, 1, 11, 1}, // #23
  {DBGFIELD("WriteFAddX")         1, false, false, 129, 4,  6, 1,  0, 0}, // #24
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 1, false, false, 128, 6, 19, 1, 11, 1}, // #25
  {DBGFIELD("WriteFAdd64")        1, false, false, 129, 4,  6, 1,  0, 0}, // #26
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 1, false, false, 128, 6, 19, 1, 11, 1}, // #27
  {DBGFIELD("WriteFAdd")          1, false, false, 129, 4,  6, 1,  0, 0}, // #28
  {DBGFIELD("WriteFAddLd")        1, false, false, 128, 6, 19, 1,  0, 0}, // #29
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 2, false, false, 134, 6, 21, 1, 11, 1}, // #30
  {DBGFIELD("WriteAESDecEnc")     2, false, false, 135, 4,  8, 1,  0, 0}, // #31
  {DBGFIELD("WriteAESIMCLd")      1, false, false, 134, 6, 19, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESIMC")        1, false, false, 135, 4,  6, 1,  0, 0}, // #33
  {DBGFIELD("WriteAESKeyGenLd")   1, false, false, 134, 6, 19, 1,  0, 0}, // #34
  {DBGFIELD("WriteAESKeyGen")     1, false, false, 135, 4,  6, 1,  0, 0}, // #35
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 1, false, false, 140, 5,  4, 1, 11, 1}, // #36
  {DBGFIELD("WriteFLogic")        1, false, false, 141, 3,  3, 1,  0, 0}, // #37
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 124, 4,  5, 1, 12, 1}, // #38
  {DBGFIELD("WriteBEXTR")         2, false, false, 79, 2,  3, 1,  0, 0}, // #39
  {DBGFIELD("WriteBEXTRLd")       2, false, false, 124, 4,  5, 1,  0, 0}, // #40
  {DBGFIELD("WriteALULd")         1, false, false, 124, 4,  6, 1,  0, 0}, // #41
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 1, false, false, 105, 5,  4, 1, 11, 1}, // #42
  {DBGFIELD("WriteFBlend")        1, false, false, 106, 3,  3, 1,  0, 0}, // #43
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 1, false, false, 105, 5,  4, 1, 11, 1}, // #44
  {DBGFIELD("WriteFVarBlend")     1, false, false, 106, 3,  3, 1,  0, 0}, // #45
  {DBGFIELD("WriteBLSLd")         2, false, false, 124, 4,  5, 1,  0, 0}, // #46
  {DBGFIELD("WriteBLS")           2, false, false, 79, 2,  3, 1,  0, 0}, // #47
  {DBGFIELD("WriteBSFLd")         8, false, false, 145, 4,  4, 1,  0, 0}, // #48
  {DBGFIELD("WriteBSF")           6, false, false, 98, 2, 22, 1,  0, 0}, // #49
  {DBGFIELD("WriteBSRLd")         9, false, false, 149, 4, 11, 1,  0, 0}, // #50
  {DBGFIELD("WriteBSR")           7, false, false, 150, 2, 23, 1,  0, 0}, // #51
  {DBGFIELD("WriteBSWAP32")       1, false, false, 96, 2,  1, 1,  0, 0}, // #52
  {DBGFIELD("WriteBSWAP64")       1, false, false, 96, 2,  1, 1,  0, 0}, // #53
  {DBGFIELD("WriteBitTestImmLd")  1, false, false, 124, 4,  6, 1,  0, 0}, // #54
  {DBGFIELD("WriteBitTestRegLd")  7, false, false, 153, 4,  6, 1,  0, 0}, // #55
  {DBGFIELD("WriteBitTest")       1, false, false, 79, 2,  1, 1,  0, 0}, // #56
  {DBGFIELD("WriteBitTestSetImmRMW") 4, false, false, 157, 4,  4, 1,  0, 0}, // #57
  {DBGFIELD("WriteBitTestSetRegRMW") 10, false, false, 161, 4,  4, 1,  0, 0}, // #58
  {DBGFIELD("WriteBitTestSet")    2, false, false, 79, 2,  3, 1,  0, 0}, // #59
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, 165, 4,  6, 1, 12, 1}, // #60
  {DBGFIELD("WriteBZHI")          1, false, false, 96, 2,  1, 1,  0, 0}, // #61
  {DBGFIELD("WriteLoad")          1, false, false, 169, 2,  6, 1,  0, 0}, // #62
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 1, false, false, 165, 4,  6, 1, 10, 1}, // #63
  {DBGFIELD("WriteCMOV")          1, false, false, 96, 2,  1, 1,  0, 0}, // #64
  {DBGFIELD("WriteFCMOV")         1, false, false, 129, 4,  1, 1,  0, 0}, // #65
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, 124, 4,  6, 1, 12, 1}, // #66
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 1, false, false, 128, 6,  4, 1, 11, 1}, // #67
  {DBGFIELD("WriteFCmp64X")       1, false, false, 129, 4,  3, 1,  0, 0}, // #68
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 1, false, false, 128, 6,  4, 1, 11, 1}, // #69
  {DBGFIELD("WriteFCmpX")         1, false, false, 129, 4,  3, 1,  0, 0}, // #70
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 1, false, false, 128, 6,  4, 1, 11, 1}, // #71
  {DBGFIELD("WriteFCmp64")        1, false, false, 129, 4,  3, 1,  0, 0}, // #72
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 1, false, false, 128, 6,  4, 1, 11, 1}, // #73
  {DBGFIELD("WriteFCmp")          1, false, false, 129, 4,  3, 1,  0, 0}, // #74
  {DBGFIELD("WriteCMPXCHG")       5, false, false, 171, 3, 22, 1,  0, 0}, // #75
  {DBGFIELD("WriteFComLd_ReadAfterVecLd") 2, false, false, 174, 9,  5, 1, 11, 1}, // #76
  {DBGFIELD("WriteFCom")          2, false, false, 175, 7,  1, 1,  0, 0}, // #77
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 3, false, false, 183, 4,  5, 1, 10, 1}, // #78
  {DBGFIELD("WriteCRC32")         3, false, false, 184, 2,  3, 1,  0, 0}, // #79
  {DBGFIELD("WriteNop")           1, false, false, 79, 2,  1, 1,  0, 0}, // #80
  {DBGFIELD("WriteCvtI2PDLd")     2, false, false, 187, 7, 27, 1,  0, 0}, // #81
  {DBGFIELD("WriteCvtI2PD")       2, false, false, 188, 5, 11, 1,  0, 0}, // #82
  {DBGFIELD("WriteCvtI2PSLd")     1, false, false, 187, 7,  8, 1,  0, 0}, // #83
  {DBGFIELD("WriteCvtI2PS")       1, false, false, 188, 5, 23, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtPD2ILd")     2, false, false, 187, 7, 27, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtPD2I")       2, false, false, 188, 5, 11, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtPD2PSLd")    2, false, false, 187, 7, 27, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtPD2PS")      2, false, false, 188, 5, 11, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtPS2ILd")     1, false, false, 187, 7,  8, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtPS2I")       1, false, false, 188, 5, 23, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPS2PDLd")    2, false, false, 187, 7, 27, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPS2PD")      2, false, false, 188, 5, 11, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtSD2ILd")     2, false, false, 194, 11, 29, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtSD2I")       2, false, false, 195, 9, 27, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtSD2SSLd")    1, false, false, 205, 7,  8, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 1, false, false, 205, 7,  8, 1, 11, 1}, // #96
  {DBGFIELD("WriteCvtSD2SS")      1, false, false, 206, 5, 23, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, 187, 7,  8, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 2, false, false, 187, 7,  8, 1, 11, 1}, // #99
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 2, false, false, 188, 5, 23, 1, 13, 1}, // #100
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 2, false, false, 188, 5, 23, 1, 14, 1}, // #101
  {DBGFIELD("WriteCvtI2SSLd")     2, false, false, 187, 7,  8, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 2, false, false, 187, 7,  8, 1, 11, 1}, // #103
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 2, false, false, 188, 5, 23, 1, 13, 1}, // #104
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 2, false, false, 188, 5, 23, 1, 14, 1}, // #105
  {DBGFIELD("WriteCvtSS2SDLd")    1, false, false, 205, 7,  8, 1,  0, 0}, // #106
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 1, false, false, 205, 7,  8, 1, 11, 1}, // #107
  {DBGFIELD("WriteCvtSS2SD")      1, false, false, 206, 5, 23, 1,  0, 0}, // #108
  {DBGFIELD("WriteCvtSS2ILd")     2, false, false, 194, 11, 29, 1,  0, 0}, // #109
  {DBGFIELD("WriteCvtSS2I")       2, false, false, 195, 9, 27, 1,  0, 0}, // #110
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 2, false, false, 195, 9, 27, 1,  0, 0}, // #111
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 2, false, false, 195, 9, 27, 1,  0, 0}, // #112
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 212, 6, 63, 1, 15, 2}, // #113
  {DBGFIELD("WriteDiv16")         2, false, false, 213, 4, 10, 1,  0, 0}, // #114
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 218, 6, 29, 1, 15, 2}, // #115
  {DBGFIELD("WriteDiv32")         2, false, false, 219, 4, 21, 1,  0, 0}, // #116
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 218, 6, 29, 1, 15, 2}, // #117
  {DBGFIELD("WriteDiv64")         2, false, false, 219, 4, 21, 1,  0, 0}, // #118
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 224, 6,  7, 1, 15, 2}, // #119
  {DBGFIELD("WriteDiv8")          1, false, false, 225, 4, 20, 1,  0, 0}, // #120
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 1, false, false, 230, 6, 21, 1, 11, 1}, // #121
  {DBGFIELD("WriteFDiv64X")       1, false, false, 231, 4,  8, 1,  0, 0}, // #122
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 1, false, false, 230, 6, 21, 1, 11, 1}, // #123
  {DBGFIELD("WriteFDivX")         1, false, false, 231, 4,  8, 1,  0, 0}, // #124
  {DBGFIELD("WriteFDivLd")        1, false, false, 230, 6, 21, 1,  0, 0}, // #125
  {DBGFIELD("WriteFDiv")          1, false, false, 231, 4,  8, 1,  0, 0}, // #126
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 1, false, false, 230, 6, 21, 1, 11, 1}, // #127
  {DBGFIELD("WriteFDiv64")        1, false, false, 231, 4,  8, 1,  0, 0}, // #128
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 1, false, false, 230, 6, 21, 1, 11, 1}, // #129
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 17, false, false, 236, 6, 30, 1, 11, 1}, // #130
  {DBGFIELD("WriteDPPD")          15, false, false, 237, 4, 10, 1,  0, 0}, // #131
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 18, false, false, 242, 6, 37, 1, 11, 1}, // #132
  {DBGFIELD("WriteDPPS")          16, false, false, 243, 4, 34, 1,  0, 0}, // #133
  {DBGFIELD("WriteStore")         1, false, false, 248, 2,  1, 1,  0, 0}, // #134
  {DBGFIELD("WriteVecExtractSt")  2, false, false, 250, 6, 27, 1,  0, 0}, // #135
  {DBGFIELD("WriteVecExtract")    2, false, false, 256, 7, 20, 1,  0, 0}, // #136
  {DBGFIELD("WriteVecALUX")       1, false, false, 263, 3,  3, 1,  0, 0}, // #137
  {DBGFIELD("WriteFComLd")        2, false, false, 174, 9,  5, 1,  0, 0}, // #138
  {DBGFIELD("WriteEMMS")          1, false, false, 266, 3,  3, 1,  0, 0}, // #139
  {DBGFIELD("WriteFLDC")          1, false, false, 269, 4, 22, 1,  0, 0}, // #140
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 1, false, false, 273, 5,  4, 1, 11, 1}, // #141
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 4, false, false, 278, 6,  7, 1, 11, 1}, // #142
  {DBGFIELD("WriteFHAdd")         3, false, false, 279, 4,  9, 1,  0, 0}, // #143
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 284, 6, 63, 1, 15, 2}, // #144
  {DBGFIELD("WriteIDiv16")        2, false, false, 285, 4, 10, 1,  0, 0}, // #145
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 290, 6, 29, 1, 15, 2}, // #146
  {DBGFIELD("WriteIDiv32")        2, false, false, 291, 4, 21, 1,  0, 0}, // #147
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 218, 6, 29, 1, 15, 2}, // #148
  {DBGFIELD("WriteIDiv64")        2, false, false, 219, 4, 21, 1,  0, 0}, // #149
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 224, 6,  7, 1, 15, 2}, // #150
  {DBGFIELD("WriteIDiv8")         1, false, false, 225, 4, 20, 1,  0, 0}, // #151
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 296, 6, 11, 1, 15, 2}, // #152
  {DBGFIELD("WriteIMul16")        2, false, false, 302, 4, 23, 1,  0, 0}, // #153
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 1, false, false, 306, 6, 11, 1, 10, 1}, // #154
  {DBGFIELD("WriteIMul16ImmLd")   2, false, false, 296, 6,  8, 1,  0, 0}, // #155
  {DBGFIELD("WriteIMul16Reg")     1, false, false, 312, 4, 23, 1,  0, 0}, // #156
  {DBGFIELD("WriteIMul16Imm")     2, false, false, 302, 4,  6, 1,  0, 0}, // #157
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 316, 6, 11, 1, 15, 2}, // #158
  {DBGFIELD("WriteIMul32")        1, false, false, 322, 4, 23, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 1, false, false, 306, 6, 11, 1, 10, 1}, // #160
  {DBGFIELD("WriteIMul32ImmLd")   2, false, false, 306, 6, 11, 1,  0, 0}, // #161
  {DBGFIELD("WriteIMul32Reg")     1, false, false, 312, 4, 23, 1,  0, 0}, // #162
  {DBGFIELD("WriteIMul32Imm")     1, false, false, 312, 4, 23, 1,  0, 0}, // #163
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 326, 6, 19, 1, 15, 2}, // #164
  {DBGFIELD("WriteIMul64")        1, false, false, 332, 4,  5, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 1, false, false, 316, 6, 19, 1, 10, 1}, // #166
  {DBGFIELD("WriteIMul64ImmLd")   2, false, false, 316, 6, 19, 1,  0, 0}, // #167
  {DBGFIELD("WriteIMul64Reg")     1, false, false, 322, 4,  5, 1,  0, 0}, // #168
  {DBGFIELD("WriteIMul64Imm")     1, false, false, 322, 4,  5, 1,  0, 0}, // #169
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 316, 6, 11, 1, 15, 2}, // #170
  {DBGFIELD("WriteIMul8")         1, false, false, 322, 4, 23, 1,  0, 0}, // #171
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 1, false, false, 140, 5,  4, 1, 11, 1}, // #172
  {DBGFIELD("WriteFShuffle")      1, false, false, 141, 3,  3, 1,  0, 0}, // #173
  {DBGFIELD("WriteVecLogicX")     1, false, false, 263, 3,  3, 1,  0, 0}, // #174
  {DBGFIELD("WriteShuffle")       1, false, false, 263, 3,  3, 1,  0, 0}, // #175
  {DBGFIELD("WriteLAHFSAHF")      2, false, false, 184, 2,  3, 1,  0, 0}, // #176
  {DBGFIELD("WriteVecLoadX")      1, false, false, 336, 5,  6, 1,  0, 0}, // #177
  {DBGFIELD("WriteLDMXCSR")       1, false, false, 341, 2,  6, 1,  0, 0}, // #178
  {DBGFIELD("WriteFLD0")          1, false, false, 269, 4, 22, 1,  0, 0}, // #179
  {DBGFIELD("WriteFLD1")          1, false, false, 269, 4, 22, 1,  0, 0}, // #180
  {DBGFIELD("WriteLEA")           2, false, false, 96, 2,  1, 1,  0, 0}, // #181
  {DBGFIELD("WriteFence")         1, false, false, 248, 2,  1, 1,  0, 0}, // #182
  {DBGFIELD("WriteLZCNTLd")       2, false, false, 343, 5,  5, 1,  0, 0}, // #183
  {DBGFIELD("WriteLZCNT")         2, false, false, 344, 3,  3, 1,  0, 0}, // #184
  {DBGFIELD("WriteVecStoreX")     1, false, false, 100, 5,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteVecStore")      1, false, false, 100, 5,  3, 1,  0, 0}, // #186
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, 175, 7,  9, 1,  0, 0}, // #187
  {DBGFIELD("WriteVecLoad")       1, false, false, 336, 5,  6, 1,  0, 0}, // #188
  {DBGFIELD("WriteVecMoveFromGpr") 2, false, false, 141, 3,  9, 1,  0, 0}, // #189
  {DBGFIELD("WriteVecMoveX")      1, false, false, 263, 3,  1, 1,  0, 0}, // #190
  {DBGFIELD("WriteVecStoreNT")    1, false, false, 348, 6,  3, 1,  0, 0}, // #191
  {DBGFIELD("WriteVecMove")       1, false, false, 81, 3,  3, 1,  0, 0}, // #192
  {DBGFIELD("WriteVecALULd")      1, false, false, 354, 5,  4, 1,  0, 0}, // #193
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 1, false, false, 273, 5,  4, 1, 11, 1}, // #194
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 1, false, false, 354, 5,  4, 1, 11, 1}, // #195
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 1, false, false, 354, 5,  4, 1, 11, 1}, // #196
  {DBGFIELD("WriteVecLogic")      1, false, false, 81, 3,  3, 1,  0, 0}, // #197
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, 359, 5, 19, 1, 11, 1}, // #198
  {DBGFIELD("WritePHAdd")         3, false, false, 360, 3,  6, 1,  0, 0}, // #199
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 2, false, false, 359, 5,  5, 1, 10, 1}, // #200
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 2, false, false, 337, 3,  3, 1, 14, 1}, // #201
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 1, false, false, 134, 6,  8, 1, 11, 1}, // #202
  {DBGFIELD("WriteVecIMul")       1, false, false, 135, 4, 23, 1,  0, 0}, // #203
  {DBGFIELD("WriteMMXMOVMSK")     2, false, false, 175, 7, 19, 1,  0, 0}, // #204
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 2, false, false, 273, 5,  8, 1, 11, 1}, // #205
  {DBGFIELD("WritePSADBW")        2, false, false, 263, 3, 23, 1,  0, 0}, // #206
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 1, false, false, 273, 5, 11, 1, 11, 1}, // #207
  {DBGFIELD("WriteVarShuffle")    1, false, false, 263, 3, 22, 1,  0, 0}, // #208
  {DBGFIELD("WriteShuffleLd")     1, false, false, 273, 5,  4, 1,  0, 0}, // #209
  {DBGFIELD("WriteVecShiftImm")   1, false, false, 263, 3,  3, 1,  0, 0}, // #210
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 1, false, false, 273, 5, 11, 1, 11, 1}, // #211
  {DBGFIELD("WriteVecShift")      1, false, false, 263, 3, 22, 1,  0, 0}, // #212
  {DBGFIELD("WriteFMoveX")        1, false, false, 141, 3,  1, 1,  0, 0}, // #213
  {DBGFIELD("WriteFShuffleLd")    1, false, false, 140, 5,  4, 1,  0, 0}, // #214
  {DBGFIELD("WriteFStore")        1, false, false, 100, 5,  3, 1,  0, 0}, // #215
  {DBGFIELD("WriteFMOVMSK")       2, false, false, 175, 7, 20, 1,  0, 0}, // #216
  {DBGFIELD("WriteVecLoadNT")     1, false, false, 359, 5,  6, 1,  0, 0}, // #217
  {DBGFIELD("WriteStoreNT")       1, false, false, 248, 2,  1, 1,  0, 0}, // #218
  {DBGFIELD("WriteFStoreNTX")     1, false, false, 348, 6, 22, 1,  0, 0}, // #219
  {DBGFIELD("WriteFStoreNT")      1, false, false, 348, 6, 22, 1,  0, 0}, // #220
  {DBGFIELD("WriteFLoad")         1, false, false, 105, 5,  6, 1,  0, 0}, // #221
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 8, false, false, 364, 6, 21, 1, 11, 1}, // #222
  {DBGFIELD("WriteMPSAD")         8, false, false, 365, 4,  8, 1,  0, 0}, // #223
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 1, false, false, 370, 6, 19, 1, 11, 1}, // #224
  {DBGFIELD("WriteFMul64X")       1, false, false, 371, 4,  6, 1,  0, 0}, // #225
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 1, false, false, 370, 6, 19, 1, 11, 1}, // #226
  {DBGFIELD("WriteFMulX")         1, false, false, 371, 4,  6, 1,  0, 0}, // #227
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 1, false, false, 370, 6, 19, 1, 11, 1}, // #228
  {DBGFIELD("WriteFMul64")        1, false, false, 371, 4,  6, 1,  0, 0}, // #229
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 1, false, false, 370, 6, 19, 1, 11, 1}, // #230
  {DBGFIELD("WriteFMul")          1, false, false, 371, 4,  6, 1,  0, 0}, // #231
  {DBGFIELD("WriteIMul32Ld_WriteIMulH") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #232
  {DBGFIELD("WriteIMul32_WriteIMulH") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #233
  {DBGFIELD("WriteIMul64Ld_WriteIMulH") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #234
  {DBGFIELD("WriteIMul64_WriteIMulH") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #235
  {DBGFIELD("WriteFMulLd")        1, false, false, 370, 6, 19, 1,  0, 0}, // #236
  {DBGFIELD("WriteVecALUXLd")     1, false, false, 273, 5,  4, 1,  0, 0}, // #237
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 1, false, false, 273, 5,  4, 1, 11, 1}, // #238
  {DBGFIELD("WriteShuffleX")      1, false, false, 263, 3,  3, 1,  0, 0}, // #239
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 1, false, false, 273, 5,  4, 1, 11, 1}, // #240
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 1, false, false, 273, 5,  4, 1, 11, 1}, // #241
  {DBGFIELD("WriteVarBlend")      1, false, false, 263, 3,  3, 1,  0, 0}, // #242
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 1, false, false, 354, 5,  4, 1, 11, 1}, // #243
  {DBGFIELD("WriteBlend")         1, false, false, 81, 3,  3, 1,  0, 0}, // #244
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 6, false, false, 376, 6, 28, 1, 11, 1}, // #245
  {DBGFIELD("WriteCLMul")         5, false, false, 377, 4, 20, 1,  0, 0}, // #246
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 28, false, false, 382, 11, 63, 1, 11, 1}, // #247
  {DBGFIELD("WritePCmpEStrI")     27, false, false, 393, 11, 21, 1,  0, 0}, // #248
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 28, false, false, 382, 11, 10, 1, 11, 1}, // #249
  {DBGFIELD("WritePCmpEStrM")     27, false, false, 393, 11, 19, 1,  0, 0}, // #250
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 8, false, false, 404, 9,  7, 1, 11, 1}, // #251
  {DBGFIELD("WritePCmpIStrI")     7, false, false, 405, 7,  9, 1,  0, 0}, // #252
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 9, false, false, 413, 9, 20, 1, 11, 1}, // #253
  {DBGFIELD("WritePCmpIStrM")     7, false, false, 414, 7,  4, 1,  0, 0}, // #254
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 1, false, false, 187, 7,  8, 1, 11, 1}, // #255
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 1, false, false, 273, 5,  4, 1, 11, 1}, // #256
  {DBGFIELD("WritePHAddX")        1, false, false, 263, 3,  3, 1,  0, 0}, // #257
  {DBGFIELD("WritePHMINPOSLd")    2, false, false, 422, 6,  8, 1,  0, 0}, // #258
  {DBGFIELD("WritePHMINPOS")      2, false, false, 423, 4, 23, 1,  0, 0}, // #259
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 1, false, false, 187, 7,  8, 1, 11, 1}, // #260
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 1, false, false, 134, 6,  8, 1, 11, 1}, // #261
  {DBGFIELD("WriteVecIMulX")      1, false, false, 135, 4, 23, 1,  0, 0}, // #262
  {DBGFIELD("WriteVecMOVMSK")     2, false, false, 175, 7, 20, 1,  0, 0}, // #263
  {DBGFIELD("WriteShuffleXLd")    1, false, false, 273, 5,  4, 1,  0, 0}, // #264
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 1, false, false, 428, 7, 19, 1, 11, 1}, // #265
  {DBGFIELD("WritePMULLD")        1, false, false, 429, 5,  6, 1,  0, 0}, // #266
  {DBGFIELD("WriteCopy")          2, false, false, 435, 3,  5, 1,  0, 0}, // #267
  {DBGFIELD("WritePOPCNTLd")      1, false, false, 183, 4, 11, 1,  0, 0}, // #268
  {DBGFIELD("WritePOPCNT")        1, false, false, 184, 2, 23, 1,  0, 0}, // #269
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 2, false, false, 273, 5,  8, 1, 11, 1}, // #270
  {DBGFIELD("WritePSADBWX")       2, false, false, 263, 3, 23, 1,  0, 0}, // #271
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 1, false, false, 336, 5, 11, 1, 11, 1}, // #272
  {DBGFIELD("WriteVarShuffleX")   1, false, false, 337, 3, 22, 1,  0, 0}, // #273
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, 263, 3,  3, 1,  0, 0}, // #274
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 1, false, false, 273, 5, 11, 1, 11, 1}, // #275
  {DBGFIELD("WriteVecShiftX")     1, false, false, 263, 3, 22, 1,  0, 0}, // #276
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 2, false, false, 174, 9,  5, 1, 11, 1}, // #277
  {DBGFIELD("WriteVecTest")       2, false, false, 175, 7,  1, 1,  0, 0}, // #278
  {DBGFIELD("WriteRotateLd_WriteRMW") 2, false, false, 119, 5, 64, 2,  0, 0}, // #279
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 2, false, false, 438, 5, 64, 2,  0, 0}, // #280
  {DBGFIELD("WriteRotate")        1, false, false, 79, 2,  1, 1,  0, 0}, // #281
  {DBGFIELD("WriteRotateCL")      1, false, false, 96, 2,  1, 1,  0, 0}, // #282
  {DBGFIELD("WriteFRcpXLd")       1, false, false, 370, 6, 19, 1,  0, 0}, // #283
  {DBGFIELD("WriteFRcpX")         1, false, false, 371, 4,  6, 1,  0, 0}, // #284
  {DBGFIELD("WriteFRcpLd")        1, false, false, 370, 6, 19, 1,  0, 0}, // #285
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 1, false, false, 370, 6, 19, 1, 11, 1}, // #286
  {DBGFIELD("WriteFRcp")          1, false, false, 371, 4,  6, 1,  0, 0}, // #287
  {DBGFIELD("WriteRMW")           1, false, false, 248, 2,  1, 1,  0, 0}, // #288
  {DBGFIELD("WriteShiftLd")       1, false, false, 124, 4,  6, 1,  0, 0}, // #289
  {DBGFIELD("WriteShift")         1, false, false, 79, 2,  1, 1,  0, 0}, // #290
  {DBGFIELD("WriteFRndLd")        1, false, false, 443, 6,  8, 1,  0, 0}, // #291
  {DBGFIELD("WriteFRnd")          1, false, false, 269, 4, 23, 1,  0, 0}, // #292
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 1, false, false, 443, 6,  8, 1, 11, 1}, // #293
  {DBGFIELD("WriteFRsqrtXLd")     1, false, false, 370, 6, 19, 1,  0, 0}, // #294
  {DBGFIELD("WriteFRsqrtX")       1, false, false, 371, 4,  6, 1,  0, 0}, // #295
  {DBGFIELD("WriteFRsqrtLd")      1, false, false, 449, 6, 19, 1,  0, 0}, // #296
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 1, false, false, 449, 6, 19, 1, 11, 1}, // #297
  {DBGFIELD("WriteFRsqrt")        1, false, false, 450, 4,  6, 1,  0, 0}, // #298
  {DBGFIELD("WriteShiftLd_WriteRMW") 2, false, false, 119, 5, 64, 2,  0, 0}, // #299
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 2, false, false, 438, 5, 64, 2,  0, 0}, // #300
  {DBGFIELD("WriteShiftCL")       1, false, false, 96, 2,  1, 1,  0, 0}, // #301
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, 124, 4,  6, 1, 12, 1}, // #302
  {DBGFIELD("WriteSETCCStore")    1, false, false, 455, 4,  1, 1,  0, 0}, // #303
  {DBGFIELD("WriteSETCC")         1, false, false, 96, 2,  1, 1,  0, 0}, // #304
  {DBGFIELD("WriteSHDmrcl")       8, false, false, 459, 4, 23, 1,  0, 0}, // #305
  {DBGFIELD("WriteSHDmri")        8, false, false, 459, 4, 23, 1,  0, 0}, // #306
  {DBGFIELD("WriteSHDrrcl")       7, false, false, 150, 2, 22, 1,  0, 0}, // #307
  {DBGFIELD("WriteFSqrt64XLd")    1, false, false, 230, 6, 21, 1,  0, 0}, // #308
  {DBGFIELD("WriteFSqrt64X")      1, false, false, 231, 4,  8, 1,  0, 0}, // #309
  {DBGFIELD("WriteFSqrtXLd")      1, false, false, 230, 6, 21, 1,  0, 0}, // #310
  {DBGFIELD("WriteFSqrtX")        1, false, false, 231, 4,  8, 1,  0, 0}, // #311
  {DBGFIELD("WriteFSqrt64Ld")     1, false, false, 230, 6, 21, 1,  0, 0}, // #312
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 1, false, false, 230, 6, 21, 1, 11, 1}, // #313
  {DBGFIELD("WriteFSqrt64")       1, false, false, 231, 4,  8, 1,  0, 0}, // #314
  {DBGFIELD("WriteFSqrtLd")       1, false, false, 230, 6, 21, 1,  0, 0}, // #315
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 1, false, false, 230, 6, 21, 1, 11, 1}, // #316
  {DBGFIELD("WriteFSqrt")         1, false, false, 231, 4,  8, 1,  0, 0}, // #317
  {DBGFIELD("WriteFSqrt80")       1, false, false, 463, 4,  1, 1,  0, 0}, // #318
  {DBGFIELD("WriteSTMXCSR")       2, false, false, 467, 2,  1, 1,  0, 0}, // #319
  {DBGFIELD("WriteTZCNTLd")       2, false, false, 343, 5,  5, 1,  0, 0}, // #320
  {DBGFIELD("WriteTZCNT")         2, false, false, 344, 3,  3, 1,  0, 0}, // #321
  {DBGFIELD("WriteFMAZLd")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #322
  {DBGFIELD("WriteFMALd")         1, false, false, 469, 4, 19, 1,  0, 0}, // #323
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 2, false, false, 473, 6, 19, 1, 11, 1}, // #324
  {DBGFIELD("WriteFAdd64Y")       2, false, false, 474, 4,  6, 1,  0, 0}, // #325
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #326
  {DBGFIELD("WriteFAdd64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #327
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 2, false, false, 473, 6, 19, 1, 11, 1}, // #328
  {DBGFIELD("WriteFAddY")         2, false, false, 474, 4,  6, 1,  0, 0}, // #329
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #330
  {DBGFIELD("WriteFAddZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #331
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 2, false, false, 359, 5,  4, 1, 11, 1}, // #332
  {DBGFIELD("WriteShuffleY")      2, false, false, 360, 3,  3, 1,  0, 0}, // #333
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #334
  {DBGFIELD("WriteShuffleZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #335
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 2, false, false, 479, 5,  4, 1, 11, 1}, // #336
  {DBGFIELD("WriteFLogicY")       2, false, false, 480, 3,  3, 1,  0, 0}, // #337
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("WriteFLogicZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #339
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 2, false, false, 484, 5,  4, 1, 11, 1}, // #340
  {DBGFIELD("WriteFVarBlendY")    2, false, false, 485, 3,  3, 1,  0, 0}, // #341
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD("WriteFVarBlendZ")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #343
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 2, false, false, 489, 5,  4, 1, 11, 1}, // #344
  {DBGFIELD("WriteFBlendY")       2, false, false, 490, 3,  3, 1,  0, 0}, // #345
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, 484, 5,  4, 1, 17, 2}, // #346
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, 105, 5,  4, 1, 17, 2}, // #347
  {DBGFIELD("WriteShuffle256Ld")  1, false, false, 354, 5,  5, 1,  0, 0}, // #348
  {DBGFIELD("WriteShuffle256")    1, false, false, 81, 3,  1, 1,  0, 0}, // #349
  {DBGFIELD("WriteShuffleYLd")    2, false, false, 359, 5,  4, 1,  0, 0}, // #350
  {DBGFIELD("WriteFShuffle256")   2, false, false, 106, 3,  3, 1,  0, 0}, // #351
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, 105, 5,  4, 1,  0, 0}, // #352
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 2, false, false, 473, 6,  4, 1, 11, 1}, // #353
  {DBGFIELD("WriteFCmp64Y")       2, false, false, 474, 4,  3, 1,  0, 0}, // #354
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 2, false, false, 473, 6,  4, 1, 11, 1}, // #355
  {DBGFIELD("WriteFCmpY")         2, false, false, 474, 4,  3, 1,  0, 0}, // #356
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #357
  {DBGFIELD("WriteFCmpZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #358
  {DBGFIELD("WriteVarShuffle256Ld") 1, false, false, 354, 5,  5, 1,  0, 0}, // #359
  {DBGFIELD("WriteVarShuffle256") 1, false, false, 81, 3,  1, 1,  0, 0}, // #360
  {DBGFIELD("WriteCvtI2PDYLd")    5, false, false, 205, 7, 27, 1,  0, 0}, // #361
  {DBGFIELD("WriteCvtI2PDY")      4, false, false, 206, 5, 11, 1,  0, 0}, // #362
  {DBGFIELD("WriteCvtI2PDZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #363
  {DBGFIELD("WriteCvtI2PDZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #364
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, 205, 7,  8, 1,  0, 0}, // #365
  {DBGFIELD("WriteCvtI2PSY")      2, false, false, 206, 5, 23, 1,  0, 0}, // #366
  {DBGFIELD("WriteCvtI2PSZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #367
  {DBGFIELD("WriteCvtI2PSZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #368
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 2, false, false, 187, 7, 27, 1, 11, 1}, // #369
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 4, false, false, 494, 8, 27, 1, 11, 1}, // #370
  {DBGFIELD("WriteCvtPD2PSY")     4, false, false, 495, 6, 11, 1,  0, 0}, // #371
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #372
  {DBGFIELD("WriteCvtPD2PSZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #373
  {DBGFIELD("WriteCvtPD2PSYLd")   4, false, false, 494, 8, 27, 1,  0, 0}, // #374
  {DBGFIELD("WriteCvtPD2PSZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("WriteCvtPD2IYLd")    4, false, false, 494, 8, 27, 1,  0, 0}, // #376
  {DBGFIELD("WriteCvtPD2IY")      4, false, false, 495, 6, 11, 1,  0, 0}, // #377
  {DBGFIELD("WriteCvtPD2IZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #378
  {DBGFIELD("WriteCvtPD2IZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteCvtPH2PSYLd")   7, false, false, 205, 7, 27, 1,  0, 0}, // #380
  {DBGFIELD("WriteCvtPH2PSY")     4, false, false, 206, 5, 11, 1,  0, 0}, // #381
  {DBGFIELD("WriteCvtPH2PSLd")    3, false, false, 205, 7, 27, 1,  0, 0}, // #382
  {DBGFIELD("WriteCvtPH2PS")      2, false, false, 206, 5, 11, 1,  0, 0}, // #383
  {DBGFIELD("WriteCvtPH2PSZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #384
  {DBGFIELD("WriteCvtPH2PSZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #385
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, 205, 7,  8, 1,  0, 0}, // #386
  {DBGFIELD("WriteCvtPS2IY")      2, false, false, 206, 5, 23, 1,  0, 0}, // #387
  {DBGFIELD("WriteCvtPS2IZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #388
  {DBGFIELD("WriteCvtPS2IZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #389
  {DBGFIELD("WriteCvtPS2PDYLd")   5, false, false, 205, 7, 27, 1,  0, 0}, // #390
  {DBGFIELD("WriteCvtPS2PDY")     4, false, false, 206, 5, 11, 1,  0, 0}, // #391
  {DBGFIELD("WriteCvtPS2PDZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #392
  {DBGFIELD("WriteCvtPS2PDZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2PHYSt")   4, false, false, 502, 8, 23, 1,  0, 0}, // #394
  {DBGFIELD("WriteCvtPS2PHY")     4, false, false, 495, 6, 11, 1,  0, 0}, // #395
  {DBGFIELD("WriteCvtPS2PHSt")    3, false, false, 510, 7, 23, 1,  0, 0}, // #396
  {DBGFIELD("WriteCvtPS2PH")      2, false, false, 206, 5, 11, 1,  0, 0}, // #397
  {DBGFIELD("WriteCvtPS2PHZSt")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #398
  {DBGFIELD("WriteCvtPS2PHZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 2, false, false, 194, 11, 29, 1, 11, 1}, // #400
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 2, false, false, 194, 11, 29, 1, 11, 1}, // #401
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #402
  {DBGFIELD("WritePSADBWY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #403
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #404
  {DBGFIELD("WritePSADBWZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 2, false, false, 517, 6, 21, 1, 11, 1}, // #406
  {DBGFIELD("WriteFDiv64Y")       2, false, false, 518, 4,  8, 1,  0, 0}, // #407
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #408
  {DBGFIELD("WriteFDiv64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #409
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 2, false, false, 517, 6, 21, 1, 11, 1}, // #410
  {DBGFIELD("WriteFDivY")         2, false, false, 518, 4,  8, 1,  0, 0}, // #411
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #412
  {DBGFIELD("WriteFDivZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #413
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 1, false, false, 469, 4, 19, 1, 11, 1}, // #414
  {DBGFIELD("WriteFMAX")          1, false, false, 106, 2,  6, 1,  0, 0}, // #415
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 2, false, false, 469, 4, 19, 1, 11, 1}, // #416
  {DBGFIELD("WriteFMAY")          2, false, false, 106, 2,  6, 1,  0, 0}, // #417
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #418
  {DBGFIELD("WriteFMAZ")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #419
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 29, false, false, 523, 6, 38, 1, 11, 1}, // #420
  {DBGFIELD("WriteDPPSY")         25, false, false, 524, 4, 66, 1,  0, 0}, // #421
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 1, false, false, 354, 5,  5, 1, 11, 1}, // #422
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, 469, 4, 19, 1, 19, 2}, // #423
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, 469, 4, 19, 1, 19, 2}, // #424
  {DBGFIELD("WriteFMALd_ReadAfterVecLd") 1, false, false, 469, 4, 19, 1, 11, 1}, // #425
  {DBGFIELD("WriteFMA")           1, false, false, 106, 2,  6, 1,  0, 0}, // #426
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 1, false, false, 469, 4, 19, 1, 19, 2}, // #427
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, 469, 4, 19, 1, 17, 2}, // #428
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, 469, 4, 19, 1, 17, 2}, // #429
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 1, false, false, 469, 4, 19, 1, 17, 2}, // #430
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 2, false, false, 529, 6,  8, 1, 11, 1}, // #431
  {DBGFIELD("WriteFRndY")         2, false, false, 251, 4, 23, 1,  0, 0}, // #432
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #433
  {DBGFIELD("WriteFRndZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #434
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #435
  {DBGFIELD("WriteVecIMulY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #436
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #437
  {DBGFIELD("WriteVecIMulZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #438
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #439
  {DBGFIELD("WriteVecALUY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #440
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteVecALUZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 10, false, false, 535, 6,  7, 1, 11, 1}, // #443
  {DBGFIELD("WriteFHAddY")        8, false, false, 536, 4,  9, 1,  0, 0}, // #444
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 2, false, false, 105, 5,  4, 1, 11, 1}, // #445
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 1, false, false, 354, 5,  5, 1, 11, 1}, // #446
  {DBGFIELD("WriteVecLoadY")      2, false, false, 541, 5,  6, 1,  0, 0}, // #447
  {DBGFIELD("WriteFMaskedStore64Y") 34, false, false, 546, 5,  5, 1,  0, 0}, // #448
  {DBGFIELD("WriteFMaskedLoadY")  2, false, false, 484, 5,  5, 1,  0, 0}, // #449
  {DBGFIELD("WriteFMaskedStore64") 18, false, false, 551, 5,  5, 1,  0, 0}, // #450
  {DBGFIELD("WriteFMaskedLoad")   1, false, false, 556, 5,  5, 1,  0, 0}, // #451
  {DBGFIELD("WriteFMaskedStore32Y") 34, false, false, 546, 5,  5, 1,  0, 0}, // #452
  {DBGFIELD("WriteFMaskedStore32") 18, false, false, 551, 5,  5, 1,  0, 0}, // #453
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #454
  {DBGFIELD("WriteFCmp64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #455
  {DBGFIELD("WriteFMoveY")        2, false, false, 480, 3,  3, 1,  0, 0}, // #456
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, 484, 5,  4, 1,  0, 0}, // #457
  {DBGFIELD("WriteFShuffleY")     2, false, false, 485, 3,  3, 1,  0, 0}, // #458
  {DBGFIELD("WriteFShuffleZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #459
  {DBGFIELD("WriteFShuffleZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #460
  {DBGFIELD("WriteVecStoreY")     4, false, false, 561, 5,  1, 1,  0, 0}, // #461
  {DBGFIELD("WriteVecMoveY")      2, false, false, 566, 3,  3, 1,  0, 0}, // #462
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, 569, 5,  6, 1,  0, 0}, // #463
  {DBGFIELD("WriteVecStoreNTY")   4, false, false, 574, 6,  3, 1,  0, 0}, // #464
  {DBGFIELD("WriteFStoreNTY")     4, false, false, 574, 6, 22, 1,  0, 0}, // #465
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #466
  {DBGFIELD("WriteMPSADY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #467
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 2, false, false, 449, 6, 19, 1, 11, 1}, // #468
  {DBGFIELD("WriteFMul64Y")       2, false, false, 450, 4,  6, 1,  0, 0}, // #469
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #470
  {DBGFIELD("WriteFMul64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #471
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 2, false, false, 449, 6, 19, 1, 11, 1}, // #472
  {DBGFIELD("WriteFMulY")         2, false, false, 450, 4,  6, 1,  0, 0}, // #473
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #474
  {DBGFIELD("WriteFMulZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #475
  {DBGFIELD("WriteVecALUYLd")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #476
  {DBGFIELD("WriteVecALUZLd")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #477
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #478
  {DBGFIELD("WriteVecLogicY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #479
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteVecLogicZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #481
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #482
  {DBGFIELD("WriteBlendY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #483
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #484
  {DBGFIELD("WriteVarBlendY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #485
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #486
  {DBGFIELD("WriteVarBlendZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #488
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, 273, 5,  4, 1, 17, 2}, // #489
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, 359, 5,  4, 1, 17, 2}, // #490
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, 359, 5,  4, 1, 19, 2}, // #491
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, 273, 5,  4, 1, 17, 2}, // #492
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, 273, 5,  4, 1, 19, 2}, // #493
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #494
  {DBGFIELD("WriteFVarShuffle256") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #495
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, 484, 5, 11, 1, 17, 2}, // #496
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, 484, 5, 11, 1, 19, 2}, // #497
  {DBGFIELD("WriteFVarShuffleY")  2, false, false, 485, 3, 22, 1,  0, 0}, // #498
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, 140, 5, 11, 1, 17, 2}, // #499
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, 140, 5, 11, 1, 19, 2}, // #500
  {DBGFIELD("WriteFVarShuffle")   1, false, false, 141, 3, 22, 1,  0, 0}, // #501
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 2, false, false, 484, 5, 11, 1, 11, 1}, // #502
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 1, false, false, 140, 5, 11, 1, 11, 1}, // #503
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #504
  {DBGFIELD("WriteFVarShuffleZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #505
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #506
  {DBGFIELD("WritePHAddY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #507
  {DBGFIELD("WriteVecInsert")     2, false, false, 337, 3,  3, 1,  0, 0}, // #508
  {DBGFIELD("WriteVecIMulXLd")    1, false, false, 134, 6,  8, 1,  0, 0}, // #509
  {DBGFIELD("WriteVecIMulYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #510
  {DBGFIELD("WriteVecIMulZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #511
  {DBGFIELD("WriteVecMaskedStoreY") 2, false, false, 580, 5,  5, 1,  0, 0}, // #512
  {DBGFIELD("WriteVecMaskedLoadY") 2, false, false, 569, 5,  5, 1,  0, 0}, // #513
  {DBGFIELD("WriteVecMaskedStore") 1, false, false, 585, 5,  5, 1,  0, 0}, // #514
  {DBGFIELD("WriteVecMaskedLoad") 1, false, false, 273, 5,  5, 1,  0, 0}, // #515
  {DBGFIELD("WriteVecMOVMSKY")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #516
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #517
  {DBGFIELD("WritePMULLDY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #518
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #519
  {DBGFIELD("WritePMULLDZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #520
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, 336, 5, 11, 1, 17, 2}, // #521
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, 336, 5, 11, 1, 19, 2}, // #522
  {DBGFIELD("WriteVecShiftImmXLd") 1, false, false, 273, 5,  4, 1,  0, 0}, // #523
  {DBGFIELD("WriteVecShiftImmYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #524
  {DBGFIELD("WriteVecShiftImmY")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #525
  {DBGFIELD("WriteVecShiftImmZLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #526
  {DBGFIELD("WriteVecShiftImmZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #527
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 1, false, false, 273, 5, 11, 1, 11, 1}, // #528
  {DBGFIELD("WriteVarVecShift")   1, false, false, 263, 3, 22, 1,  0, 0}, // #529
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #530
  {DBGFIELD("WriteVarVecShiftY")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #531
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #532
  {DBGFIELD("WriteVarVecShiftZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 1, false, false, 273, 5,  4, 1, 11, 1}, // #534
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #535
  {DBGFIELD("WriteVarShuffleY")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #536
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #537
  {DBGFIELD("WriteVarShuffleZ")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #538
  {DBGFIELD("WriteShuffleZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #539
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #540
  {DBGFIELD("WriteVecShiftY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #541
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #542
  {DBGFIELD("WriteVecShiftZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #543
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 6, false, false, 590, 8,  5, 1, 11, 1}, // #544
  {DBGFIELD("WriteVecTestY")      4, false, false, 591, 6,  1, 1,  0, 0}, // #545
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 1, false, false, 370, 6, 19, 1, 11, 1}, // #546
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 2, false, false, 598, 6, 19, 1, 11, 1}, // #547
  {DBGFIELD("WriteFRcpY")         2, false, false, 599, 4,  6, 1,  0, 0}, // #548
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #549
  {DBGFIELD("WriteFRcpZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #550
  {DBGFIELD("WriteFRcpYLd")       2, false, false, 598, 6, 19, 1,  0, 0}, // #551
  {DBGFIELD("WriteFRndYLd")       2, false, false, 529, 6,  8, 1,  0, 0}, // #552
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 1, false, false, 370, 6, 19, 1, 11, 1}, // #553
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 2, false, false, 604, 6, 19, 1, 11, 1}, // #554
  {DBGFIELD("WriteFRsqrtY")       2, false, false, 605, 4,  6, 1,  0, 0}, // #555
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #556
  {DBGFIELD("WriteFRsqrtZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #557
  {DBGFIELD("WriteFRsqrtYLd")     2, false, false, 604, 6, 19, 1,  0, 0}, // #558
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 2, false, false, 484, 5,  4, 1, 11, 1}, // #559
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #560
  {DBGFIELD("WriteFSqrt64YLd")    2, false, false, 517, 6, 21, 1,  0, 0}, // #561
  {DBGFIELD("WriteFSqrt64Y")      2, false, false, 518, 4,  8, 1,  0, 0}, // #562
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 1, false, false, 230, 6, 21, 1, 11, 1}, // #563
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 2, false, false, 517, 6, 21, 1, 11, 1}, // #564
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #565
  {DBGFIELD("WriteFSqrt64Z")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #566
  {DBGFIELD("WriteFSqrtYLd")      2, false, false, 517, 6, 21, 1,  0, 0}, // #567
  {DBGFIELD("WriteFSqrtY")        2, false, false, 518, 4,  8, 1,  0, 0}, // #568
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 1, false, false, 230, 6, 21, 1, 11, 1}, // #569
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 2, false, false, 517, 6, 21, 1, 11, 1}, // #570
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #571
  {DBGFIELD("WriteFSqrtZ")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #572
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 6, false, false, 610, 8,  5, 1, 11, 1}, // #573
  {DBGFIELD("WriteFTestY")        4, false, false, 611, 6,  1, 1,  0, 0}, // #574
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 2, false, false, 174, 9,  5, 1, 11, 1}, // #575
  {DBGFIELD("WriteFTest")         2, false, false, 175, 7,  1, 1,  0, 0}, // #576
  {DBGFIELD("WriteALULd_WriteRMW") 2, false, false, 119, 5, 64, 2,  0, 0}, // #577
  {DBGFIELD("WriteXCHG")          2, false, false, 92, 3,  1, 1,  0, 0}, // #578
  {DBGFIELD("COPY")               1, false, false, 79, 2,  1, 1,  0, 0}, // #579
  {DBGFIELD("FXAM")               1, false, false, 96, 2,  2, 1,  0, 0}, // #580
  {DBGFIELD("LD_Frr")             1, false, false, 79, 2,  1, 1,  0, 0}, // #581
  {DBGFIELD("MOVSX64rr32")        1, false, false, 79, 2,  1, 1,  0, 0}, // #582
  {DBGFIELD("RCL16m1_RCL16mi_RCL32m1_RCL32mi_RCL64m1_RCL64mi_RCL8m1_RCL8mi_RCR16m1_RCR16mi_RCR32m1_RCR32mi_RCR64m1_RCR64mi_RCR8m1_RCR8mi_ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 2, false, false, 119, 5, 64, 2,  0, 0}, // #583
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL_RCR16mCL_RCR32mCL_RCR64mCL_RCR8mCL_ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 2, false, false, 438, 5, 64, 2,  0, 0}, // #584
  {DBGFIELD("SAR16m1_SAR16mi_SAR32m1_SAR32mi_SAR64m1_SAR64mi_SAR8m1_SAR8mi_SHL16m1_SHL16mi_SHL32m1_SHL32mi_SHL64m1_SHL64mi_SHL8m1_SHL8mi_SHR16m1_SHR16mi_SHR32m1_SHR32mi_SHR64m1_SHR64mi_SHR8m1_SHR8mi") 2, false, false, 119, 5, 64, 2,  0, 0}, // #585
  {DBGFIELD("SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 2, false, false, 438, 5, 64, 2,  0, 0}, // #586
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, 79, 2,  1, 1,  0, 0}, // #587
  {DBGFIELD("FCOMPP")             1, false, false, 96, 2,  2, 1,  0, 0}, // #588
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, 371, 4,  1, 1,  0, 0}, // #589
  {DBGFIELD("MMX_CVTPI2PSirr")    2, false, false, 188, 5, 23, 1,  0, 0}, // #590
  {DBGFIELD("MMX_CVTPI2PSirm")    1, false, false, 187, 7,  8, 1,  0, 0}, // #591
  {DBGFIELD("MMX_CVTPS2PIirr_MMX_CVTTPS2PIirr") 1, false, false, 188, 5, 23, 1,  0, 0}, // #592
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, 169, 2,  6, 1,  0, 0}, // #593
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, 248, 2,  1, 1,  0, 0}, // #594
  {DBGFIELD("XCH_F")              1, false, false, 79, 2,  1, 1,  0, 0}, // #595
  {DBGFIELD("RETIL_RETIQ_RETIW_IRET_IRET16_IRET32_IRET64") 1, false, false, 90, 6,  6, 1,  0, 0}, // #596
  {DBGFIELD("MMX_CVTPS2PIirm_MMX_CVTTPS2PIirm") 1, false, false, 187, 7,  8, 1,  0, 0}, // #597
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 1, false, false, 169, 2,  6, 1,  0, 0}, // #598
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 1, false, false, 96, 2,  2, 1,  0, 0}, // #599
  {DBGFIELD("LFENCE")             1, false, false, 248, 2,  1, 1,  0, 0}, // #600
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, 141, 3,  3, 1,  0, 0}, // #601
  {DBGFIELD("PSLLDQri_PSRLDQri")  1, false, false, 263, 3,  3, 1,  0, 0}, // #602
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr_MMX_PUNPCKHBWirr_MMX_PUNPCKHDQirr_MMX_PUNPCKHWDirr") 1, false, false, 263, 3,  3, 1,  0, 0}, // #603
  {DBGFIELD("LEAVE_LEAVE64")      1, false, false, 79, 2,  1, 1,  0, 0}, // #604
  {DBGFIELD("POP16r")             1, false, false, 169, 2,  6, 1,  0, 0}, // #605
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 2, false, false, 435, 3,  5, 1,  0, 0}, // #606
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false, 96, 2,  2, 1,  0, 0}, // #607
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, 96, 2,  2, 1,  0, 0}, // #608
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, 248, 2,  1, 1,  0, 0}, // #609
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, 79, 2,  1, 1,  0, 0}, // #610
  {DBGFIELD("MMX_PADDQirr_MMX_PSUBQirr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #611
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, 79, 2,  1, 1,  0, 0}, // #612
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 1, false, false, 100, 5,  1, 1,  0, 0}, // #613
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  1, false, false, 100, 5,  1, 1,  0, 0}, // #614
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, 263, 3,  3, 1,  0, 0}, // #615
  {DBGFIELD("CLD")                1, false, false, 79, 2,  1, 1,  0, 0}, // #616
  {DBGFIELD("LDDQUrm")            1, false, false, 336, 5,  6, 1,  0, 0}, // #617
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, 96, 2,  2, 1,  0, 0}, // #618
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 2, false, false, 435, 3,  5, 1,  0, 0}, // #619
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 2, false, false, 119, 5, 64, 2,  0, 0}, // #620
  {DBGFIELD("PHADDDrr_PHSUBDrr")  3, false, false, 360, 3,  6, 1,  0, 0}, // #621
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, 124, 4,  6, 1,  0, 0}, // #622
  {DBGFIELD("MMX_PADDQirm_MMX_PSUBQirm") 1, false, false, 354, 5,  4, 1, 11, 1}, // #623
  {DBGFIELD("MOVDQUrm")           1, false, false, 336, 5,  6, 1,  0, 0}, // #624
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, 105, 5,  6, 1,  0, 0}, // #625
  {DBGFIELD("PADDQrm_PSUBQrm")    1, false, false, 273, 5,  4, 1, 11, 1}, // #626
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, 79, 2,  1, 1,  0, 0}, // #627
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   1, false, false, 91, 4,  1, 1,  0, 0}, // #628
  {DBGFIELD("LD_F80m")            1, false, false, 169, 2,  6, 1,  0, 0}, // #629
  {DBGFIELD("PHADDDrm_PHSUBDrm")  4, false, false, 359, 5, 19, 1,  0, 0}, // #630
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 2, false, false, 256, 7, 20, 1,  0, 0}, // #631
  {DBGFIELD("FLDCW16m")           1, false, false, 169, 2,  6, 1,  0, 0}, // #632
  {DBGFIELD("ST_FP80m")           1, false, false, 248, 2,  1, 1,  0, 0}, // #633
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 3, false, false, 360, 3,  6, 1,  0, 0}, // #634
  {DBGFIELD("CMPXCHG8rm")         5, false, false, 618, 3, 22, 1,  0, 0}, // #635
  {DBGFIELD("INTO")               1, false, false, 96, 2,  2, 1,  0, 0}, // #636
  {DBGFIELD("XLAT")               1, false, false, 96, 2,  5, 1,  0, 0}, // #637
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 7, false, false, 150, 2, 22, 1,  0, 0}, // #638
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 6, false, false, 98, 2, 22, 1,  0, 0}, // #639
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 8, false, false, 459, 4, 23, 1,  0, 0}, // #640
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 8, false, false, 459, 4, 23, 1,  0, 0}, // #641
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 1, false, false, 248, 2,  1, 1,  0, 0}, // #642
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 4, false, false, 359, 5, 19, 1, 11, 1}, // #643
  {DBGFIELD("AAD8i8")             1, false, false, 96, 2,  2, 1,  0, 0}, // #644
  {DBGFIELD("LOOPE")              1, false, false, 91, 4,  1, 1,  0, 0}, // #645
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, 248, 2,  1, 1,  0, 0}, // #646
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 7, false, false, 150, 2, 22, 1,  0, 0}, // #647
  {DBGFIELD("FNSTCW16m")          1, false, false, 79, 2,  1, 1,  0, 0}, // #648
  {DBGFIELD("POPA16_POPA32")      1, false, false, 169, 2,  6, 1,  0, 0}, // #649
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, 248, 2,  1, 1,  0, 0}, // #650
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 8, false, false, 459, 4, 23, 1,  0, 0}, // #651
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 8, false, false, 459, 4, 23, 1,  0, 0}, // #652
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 6, false, false, 98, 2, 22, 1,  0, 0}, // #653
  {DBGFIELD("CMPXCHG8rr")         3, false, false, 171, 3, 22, 1,  0, 0}, // #654
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80_COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 2, false, false, 175, 7,  1, 1,  0, 0}, // #655
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 2, false, false, 195, 9, 27, 1,  0, 0}, // #656
  {DBGFIELD("CVTTSS2SI64rr")      2, false, false, 195, 9, 27, 1,  0, 0}, // #657
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int") 2, false, false, 174, 9,  5, 1, 11, 1}, // #658
  {DBGFIELD("CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 2, false, false, 194, 11, 29, 1,  0, 0}, // #659
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, 96, 2,  2, 1,  0, 0}, // #660
  {DBGFIELD("AAA_AAS")            1, false, false, 96, 2,  2, 1,  0, 0}, // #661
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 6, false, false, 621, 3, 22, 1,  0, 0}, // #662
  {DBGFIELD("LOOPNE")             1, false, false, 91, 4,  1, 1,  0, 0}, // #663
  {DBGFIELD("PAUSE")              1, false, false, 79, 2,  1, 1,  0, 0}, // #664
  {DBGFIELD("CMPXCHG8B")          18, false, false, 624, 3, 22, 1,  0, 0}, // #665
  {DBGFIELD("DAA")                1, false, false, 96, 2,  2, 1,  0, 0}, // #666
  {DBGFIELD("LOOP")               1, false, false, 91, 4,  1, 1,  0, 0}, // #667
  {DBGFIELD("DAS")                1, false, false, 96, 2,  2, 1,  0, 0}, // #668
  {DBGFIELD("AAM8i8")             1, false, false, 96, 2,  2, 1,  0, 0}, // #669
  {DBGFIELD("STD")                1, false, false, 79, 2,  1, 1,  0, 0}, // #670
  {DBGFIELD("CMPXCHG16B")         22, false, false, 627, 3, 22, 1,  0, 0}, // #671
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, 96, 2,  2, 1,  0, 0}, // #672
  {DBGFIELD("FNCLEX_FXTRACT")     1, false, false, 96, 2,  2, 1,  0, 0}, // #673
  {DBGFIELD("POPF32_POPF64")      1, false, false, 169, 2,  6, 1,  0, 0}, // #674
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, 96, 2,  2, 1,  0, 0}, // #675
  {DBGFIELD("RDTSC_RDTSCP")       1, false, false, 96, 2,  2, 1,  0, 0}, // #676
  {DBGFIELD("ENTER")              1, false, false, 96, 2,  2, 1,  0, 0}, // #677
  {DBGFIELD("POPF16")             1, false, false, 169, 2,  6, 1,  0, 0}, // #678
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false, 96, 2,  2, 1,  0, 0}, // #679
  {DBGFIELD("FRNDINT")            1, false, false, 96, 2,  2, 1,  0, 0}, // #680
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false, 96, 2,  2, 1,  0, 0}, // #681
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, 96, 2,  2, 1,  0, 0}, // #682
  {DBGFIELD("FPREM")              1, false, false, 96, 2,  2, 1,  0, 0}, // #683
  {DBGFIELD("INSB_INSL_INSW")     1, false, false, 96, 2,  2, 1,  0, 0}, // #684
  {DBGFIELD("FNINIT")             1, false, false, 96, 2,  2, 1,  0, 0}, // #685
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 1, false, false, 96, 2,  2, 1,  0, 0}, // #686
  {DBGFIELD("FPREM1")             1, false, false, 96, 2,  2, 1,  0, 0}, // #687
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, 96, 2,  2, 1,  0, 0}, // #688
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 1, false, false, 96, 2,  2, 1,  0, 0}, // #689
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, 96, 2,  2, 1,  0, 0}, // #690
  {DBGFIELD("FSCALE")             1, false, false, 96, 2,  2, 1,  0, 0}, // #691
  {DBGFIELD("RDMSR")              1, false, false, 96, 2,  2, 1,  0, 0}, // #692
  {DBGFIELD("RET_RETL_RETQ_RETW_LRETIL_LRETIQ_LRETIW_LRETL_LRETQ_LRETW") 1, false, false, 90, 6,  6, 1,  0, 0}, // #693
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 1, false, false, 96, 2,  2, 1,  0, 0}, // #694
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 1, false, false, 96, 2,  2, 1,  0, 0}, // #695
  {DBGFIELD("F2XM1")              1, false, false, 96, 2,  2, 1,  0, 0}, // #696
  {DBGFIELD("CPUID")              1, false, false, 96, 2,  2, 1,  0, 0}, // #697
  {DBGFIELD("INT")                1, false, false, 96, 2,  2, 1,  0, 0}, // #698
  {DBGFIELD("INT3")               1, false, false, 96, 2,  2, 1,  0, 0}, // #699
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, 96, 2,  2, 1,  0, 0}, // #700
  {DBGFIELD("FXRSTOR_FXRSTOR64")  1, false, false, 96, 2,  2, 1,  0, 0}, // #701
  {DBGFIELD("FYL2X")              1, false, false, 96, 2,  2, 1,  0, 0}, // #702
  {DBGFIELD("FYL2XP1")            1, false, false, 96, 2,  2, 1,  0, 0}, // #703
  {DBGFIELD("FPTAN")              1, false, false, 96, 2,  2, 1,  0, 0}, // #704
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false, 96, 2,  2, 1,  0, 0}, // #705
  {DBGFIELD("FPATAN")             1, false, false, 96, 2,  2, 1,  0, 0}, // #706
  {DBGFIELD("WRMSR")              1, false, false, 96, 2,  2, 1,  0, 0}, // #707
  {DBGFIELD("COMP_FST0r_COM_FST0r") 2, false, false, 175, 7,  1, 1,  0, 0}, // #708
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   2, false, false, 175, 7,  1, 1,  0, 0}, // #709
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 1, false, false, 96, 2,  2, 1,  0, 0}, // #710
  {DBGFIELD("FNOP")               1, false, false, 79, 2,  1, 1,  0, 0}, // #711
  {DBGFIELD("RETQ")               1, false, false, 90, 6,  6, 1,  0, 0}, // #712
  {DBGFIELD("CDQ_CQO")            1, false, false, 79, 2,  1, 1,  0, 0}, // #713
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, 81, 3,  3, 1,  0, 0}, // #714
  {DBGFIELD("MMX_PADDQirr")       1, false, false, 81, 3,  3, 1,  0, 0}, // #715
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, 263, 3,  3, 1,  0, 0}, // #716
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 1, false, false, 96, 2,  2, 1,  0, 0}, // #717
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 2, false, false, 175, 7,  1, 1,  0, 0}, // #718
  {DBGFIELD("VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 2, false, false, 175, 7,  1, 1,  0, 0}, // #719
  {DBGFIELD("CWD")                1, false, false, 79, 2,  1, 1,  0, 0}, // #720
  {DBGFIELD("FNSTSW16r")          1, false, false, 79, 2,  1, 1,  0, 0}, // #721
  {DBGFIELD("MMX_MOVDQ2Qrr")      1, false, false, 263, 3,  1, 1,  0, 0}, // #722
  {DBGFIELD("PUSHFS64")           1, false, false, 96, 2,  2, 1,  0, 0}, // #723
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 2, false, false, 256, 7, 20, 1,  0, 0}, // #724
  {DBGFIELD("RCL16r1_RCL32r1_RCL64r1_RCL8r1_RCR16r1_RCR32r1_RCR64r1_RCR8r1") 1, false, false, 79, 2,  1, 1,  0, 0}, // #725
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 2, false, false, 175, 7,  1, 1,  0, 0}, // #726
  {DBGFIELD("MOV64sr")            1, false, false, 79, 2,  1, 1,  0, 0}, // #727
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVSX32rm16_MOVSX32rm32_MOVSX32rm8_MOVSX32rm8_NOREX_MOVSX64rm16_MOVSX64rm32_MOVSX64rm8_MOVZX16rm16_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX_MOVZX64rm16_MOVZX64rm8") 1, false, false, 124, 4,  6, 1,  0, 0}, // #728
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCL8rCL_RCR16rCL_RCR32rCL_RCR64rCL_RCR8rCL") 24, false, false, 460, 2,  9, 1,  0, 0}, // #729
  {DBGFIELD("RCL16ri_RCL32ri_RCL64ri_RCL8ri_RCR16ri_RCR32ri_RCR64ri_RCR8ri") 25, false, false, 630, 2, 27, 1,  0, 0}, // #730
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 1, false, false, 248, 2,  1, 1,  0, 0}, // #731
  {DBGFIELD("CLI")                1, false, false, 96, 2,  2, 1,  0, 0}, // #732
  {DBGFIELD("PUSHGS64")           1, false, false, 96, 2,  2, 1,  0, 0}, // #733
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 1, false, false, 248, 2,  1, 1,  0, 0}, // #734
  {DBGFIELD("CALL64pcrel32")      1, false, false, 91, 4,  1, 1,  0, 0}, // #735
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 1, false, false, 91, 4,  1, 1,  0, 0}, // #736
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 2, false, false, 250, 6, 27, 1,  0, 0}, // #737
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 1, false, false, 96, 2,  2, 1,  0, 0}, // #738
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 2, false, false, 250, 6, 27, 1,  0, 0}, // #739
  {DBGFIELD("PUSHF16_PUSHF64")    1, false, false, 248, 2,  1, 1,  0, 0}, // #740
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 1, false, false, 169, 2,  6, 1,  0, 0}, // #741
  {DBGFIELD("MMX_MOVD64from64rm") 1, false, false, 100, 5,  3, 1,  0, 0}, // #742
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, 140, 5,  4, 1,  0, 0}, // #743
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, 336, 5,  6, 1,  0, 0}, // #744
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 140, 5,  4, 1,  0, 0}, // #745
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false, 105, 5,  6, 1,  0, 0}, // #746
  {DBGFIELD("MOV16sm")            1, false, false, 79, 2,  1, 1,  0, 0}, // #747
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 1, false, false, 354, 5,  4, 1,  0, 0}, // #748
  {DBGFIELD("MMX_PALIGNRrmi")     1, false, false, 273, 5,  4, 1, 11, 1}, // #749
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 1, false, false, 354, 5,  4, 1, 11, 1}, // #750
  {DBGFIELD("LODSL_LODSQ")        1, false, false, 96, 2,  2, 1,  0, 0}, // #751
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 2, false, false, 632, 5,  5, 1, 10, 1}, // #752
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 2, false, false, 484, 5,  4, 1,  0, 0}, // #753
  {DBGFIELD("VINSERTF128rm")      2, false, false, 105, 5,  4, 1, 11, 1}, // #754
  {DBGFIELD("MMX_PADDQirm")       1, false, false, 354, 5,  4, 1, 11, 1}, // #755
  {DBGFIELD("VERRm_VERWm")        1, false, false, 96, 2,  2, 1,  0, 0}, // #756
  {DBGFIELD("FARJMP64")           1, false, false, 91, 4,  1, 1,  0, 0}, // #757
  {DBGFIELD("FNSTSWm")            1, false, false, 96, 2,  2, 1,  0, 0}, // #758
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 1, false, false, 96, 2,  2, 1,  0, 0}, // #759
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 1, false, false, 90, 6,  6, 1,  0, 0}, // #760
  {DBGFIELD("CALL64m_CALL64m_NT") 1, false, false, 91, 4,  1, 1,  0, 0}, // #761
  {DBGFIELD("VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 2, false, false, 174, 9,  5, 1, 11, 1}, // #762
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, 96, 2,  2, 1,  0, 0}, // #763
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 2, false, false, 119, 5, 64, 2,  0, 0}, // #764
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 4, false, false, 637, 3,  5, 1,  0, 0}, // #765
  {DBGFIELD("FARCALL64")          1, false, false, 91, 4,  1, 1,  0, 0}, // #766
  {DBGFIELD("CVTSD2SI64rm_Int_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int") 2, false, false, 194, 11, 29, 1,  0, 0}, // #767
  {DBGFIELD("CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int") 2, false, false, 194, 11, 29, 1,  0, 0}, // #768
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, 169, 2,  6, 1,  0, 0}, // #769
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 2, false, false, 438, 5, 64, 2,  0, 0}, // #770
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 2, false, false, 119, 5,  5, 1,  0, 0}, // #771
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 1, false, false, 640, 6,  6, 1,  0, 0}, // #772
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 1, false, false, 273, 5,  4, 1, 11, 1}, // #773
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 2, false, false, 174, 9,  5, 1,  0, 0}, // #774
  {DBGFIELD("MUL_F32m_MUL_F64m")  1, false, false, 236, 6,  6, 1,  0, 0}, // #775
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 1, false, false, 640, 6,  6, 1,  0, 0}, // #776
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 1, false, false, 236, 6,  6, 1,  0, 0}, // #777
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 1, false, false, 646, 6,  8, 1,  0, 0}, // #778
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 1, false, false, 646, 6,  8, 1,  0, 0}, // #779
  {DBGFIELD("VZEROALL")           32, false, false,  0, 0, 67, 1,  0, 0}, // #780
  {DBGFIELD("VZEROUPPER")         16, false, false,  0, 0, 40, 1,  0, 0}, // #781
  {DBGFIELD("CLC")                1, false, false, 79, 2,  1, 1,  0, 0}, // #782
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #783
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #784
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 2, false, false, 480, 3,  3, 1,  0, 0}, // #785
  {DBGFIELD("PXORrr_VPXORrr")     16382, false, false,  0, 0,  0, 0,  0, 0}, // #786
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #787
  {DBGFIELD("PSUBQrr")            16382, false, false,  0, 0,  0, 0,  0, 0}, // #788
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false, 263, 3,  3, 1,  0, 0}, // #789
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 1, false, false, 96, 2,  1, 1,  0, 0}, // #790
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #791
  {DBGFIELD("SETCCr")             1, false, false, 96, 2,  1, 1,  0, 0}, // #792
  {DBGFIELD("SETCCm")             16382, false, false,  0, 0,  0, 0,  0, 0}, // #793
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 1, false, false, 140, 5,  4, 1, 11, 1}, // #794
  {DBGFIELD("RETIL_RETIQ_RETIW")  1, false, false, 90, 6,  6, 1,  0, 0}, // #795
  {DBGFIELD("LRETIL_LRETIQ_LRETIW") 1, false, false, 90, 6,  6, 1,  0, 0}, // #796
  {DBGFIELD("RDPMC")              1, false, false, 96, 2,  2, 1,  0, 0}, // #797
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false, 96, 2,  2, 1,  0, 0}, // #798
  {DBGFIELD("FBLDm")              1, false, false, 96, 2,  2, 1,  0, 0}, // #799
  {DBGFIELD("FFREE_FFREEP")       1, false, false, 96, 2,  2, 1,  0, 0}, // #800
  {DBGFIELD("FSAVEm")             1, false, false, 96, 2,  2, 1,  0, 0}, // #801
  {DBGFIELD("FRSTORm")            1, false, false, 96, 2,  2, 1,  0, 0}, // #802
  {DBGFIELD("FXTRACT")            1, false, false, 96, 2,  2, 1,  0, 0}, // #803
  {DBGFIELD("MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 140, 5,  4, 1,  0, 0}, // #804
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, 273, 5,  4, 1,  0, 0}, // #805
  {DBGFIELD("VBROADCASTF128")     2, false, false, 106, 3,  4, 1,  0, 0}, // #806
  {DBGFIELD("VBROADCASTI128")     1, false, false, 273, 5,  4, 1,  0, 0}, // #807
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, 273, 5,  4, 1,  0, 0}, // #808
  {DBGFIELD("FBSTPm")             1, false, false, 96, 2,  2, 1,  0, 0}, // #809
  {DBGFIELD("VMPTRSTm")           1, false, false, 96, 2,  2, 1,  0, 0}, // #810
  {DBGFIELD("ST_FP32m_ST_FP64m")  1, false, false, 248, 2,  1, 1,  0, 0}, // #811
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #812
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 1, false, false, 263, 3, 22, 1,  0, 0}, // #813
  {DBGFIELD("MMX_MOVQ2DQrr")      1, false, false, 81, 3, 23, 1,  0, 0}, // #814
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false, 91, 4,  1, 1,  0, 0}, // #815
  {DBGFIELD("FINCSTP")            1, false, false, 96, 2,  2, 1,  0, 0}, // #816
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false, 79, 2,  1, 1,  0, 0}, // #817
  {DBGFIELD("VPBLENDDYrri")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #818
  {DBGFIELD("VPBLENDDrri")        1, false, false, 81, 3,  3, 1,  0, 0}, // #819
  {DBGFIELD("CMC_STC")            1, false, false, 79, 2,  1, 1,  0, 0}, // #820
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false, 96, 2,  2, 1,  0, 0}, // #821
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 2, false, false, 187, 7, 27, 1,  0, 0}, // #822
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 1, false, false, 273, 5, 11, 1, 11, 1}, // #823
  {DBGFIELD("CVTSS2SDrm")         1, false, false, 205, 7,  8, 1,  0, 0}, // #824
  {DBGFIELD("CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 1, false, false, 205, 7,  8, 1, 11, 1}, // #825
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #826
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 1, false, false, 124, 4,  6, 1, 10, 1}, // #827
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 1, false, false, 273, 5,  4, 1,  0, 0}, // #828
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 1, false, false, 354, 5,  5, 1,  0, 0}, // #829
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 1, false, false, 90, 6,  6, 1,  0, 0}, // #830
  {DBGFIELD("ANDN32rm_ANDN64rm")  1, false, false, 124, 4,  6, 1, 10, 1}, // #831
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 1, false, false, 124, 4,  6, 1,  0, 0}, // #832
  {DBGFIELD("VINSERTI128rm")      1, false, false, 354, 5,  5, 1, 11, 1}, // #833
  {DBGFIELD("VPBLENDDrmi")        1, false, false, 354, 5,  4, 1, 11, 1}, // #834
  {DBGFIELD("VPBLENDDYrmi")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #835
  {DBGFIELD("POP32r_POP64r")      1, false, false, 169, 2,  6, 1,  0, 0}, // #836
  {DBGFIELD("SFENCE")             1, false, false, 248, 2,  1, 1,  0, 0}, // #837
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 1, false, false, 248, 2,  1, 1,  0, 0}, // #838
  {DBGFIELD("MOVBE16mr")          1, false, false, 248, 2,  1, 1,  0, 0}, // #839
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 1, false, false, 248, 2,  1, 1,  0, 0}, // #840
  {DBGFIELD("MFENCE")             1, false, false, 248, 2,  1, 1,  0, 0}, // #841
  {DBGFIELD("XGETBV")             1, false, false, 96, 2,  2, 1,  0, 0}, // #842
  {DBGFIELD("CVTPS2PDrr_VCVTPS2PDrr") 2, false, false, 188, 5, 11, 1,  0, 0}, // #843
  {DBGFIELD("CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 1, false, false, 206, 5, 23, 1,  0, 0}, // #844
  {DBGFIELD("MMX_PACKSSDWirm_MMX_PACKSSWBirm_MMX_PACKUSWBirm") 1, false, false, 273, 5,  4, 1, 11, 1}, // #845
  {DBGFIELD("LRETQ_RETL")         1, false, false, 90, 6,  6, 1,  0, 0}, // #846
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 1, false, false, 79, 2,  1, 1,  0, 0}, // #847
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, 79, 2,  1, 1,  0, 0}, // #848
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, 188, 5, 23, 1,  0, 0}, // #849
  {DBGFIELD("VCVTDQ2PSYrr")       2, false, false, 206, 5, 23, 1,  0, 0}, // #850
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, 263, 3,  3, 1,  0, 0}, // #851
  {DBGFIELD("CVTPS2DQrm_VCVTPS2DQrm_CVTTPS2DQrm_VCVTTPS2DQrm") 1, false, false, 187, 7,  8, 1,  0, 0}, // #852
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, 205, 7,  8, 1,  0, 0}, // #853
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm") 2, false, false, 205, 7,  8, 1,  0, 0}, // #854
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 1, false, false, 354, 5,  5, 1,  0, 0}, // #855
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr") 1, false, false, 263, 3,  3, 1,  0, 0}, // #856
  {DBGFIELD("CLDEMOTE")           1, false, false, 169, 2,  6, 1,  0, 0}, // #857
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int") 2, false, false, 195, 9, 27, 1,  0, 0}, // #858
  {DBGFIELD("CVTTSD2SI64rr_CVTTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, 195, 9, 27, 1,  0, 0}, // #859
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int_CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, 195, 9, 27, 1,  0, 0}, // #860
  {DBGFIELD("CVTTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr") 2, false, false, 195, 9, 27, 1,  0, 0}, // #861
  {DBGFIELD("VCVTPS2PDYrr")       4, false, false, 206, 5, 11, 1,  0, 0}, // #862
  {DBGFIELD("MMX_CVTPI2PDirr")    2, false, false, 188, 5,  5, 1,  0, 0}, // #863
  {DBGFIELD("MMX_CVTPD2PIirr_MMX_CVTTPD2PIirr") 2, false, false, 188, 5,  5, 1,  0, 0}, // #864
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 2, false, false, 188, 5, 11, 1,  0, 0}, // #865
  {DBGFIELD("CVTPD2PSrr_VCVTPD2PSrr") 2, false, false, 188, 5, 11, 1,  0, 0}, // #866
  {DBGFIELD("CVTSD2SSrr_CVTSD2SSrr_Int_VCVTSD2SSrr_VCVTSD2SSrr_Int") 1, false, false, 206, 5, 23, 1,  0, 0}, // #867
  {DBGFIELD("CVTSI2SDrr_CVTSI642SDrr") 2, false, false, 652, 5, 27, 1,  0, 0}, // #868
  {DBGFIELD("CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, 188, 5, 23, 1, 14, 1}, // #869
  {DBGFIELD("CVTSI2SSrr")         2, false, false, 652, 5, 27, 1,  0, 0}, // #870
  {DBGFIELD("CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int") 2, false, false, 188, 5, 23, 1, 14, 1}, // #871
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, 188, 5, 11, 1,  0, 0}, // #872
  {DBGFIELD("VCVTSD2SI64rm_Int_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 2, false, false, 194, 11, 29, 1,  0, 0}, // #873
  {DBGFIELD("CVTSS2SI64rm_Int")   2, false, false, 194, 11, 29, 1,  0, 0}, // #874
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 2, false, false, 194, 11, 29, 1,  0, 0}, // #875
  {DBGFIELD("VCVTPS2PDYrm")       5, false, false, 205, 7, 27, 1,  0, 0}, // #876
  {DBGFIELD("CVTPD2PSrm")         2, false, false, 187, 7, 27, 1,  0, 0}, // #877
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_MMX_CVTPD2PIirm_MMX_CVTTPD2PIirm") 2, false, false, 187, 7, 27, 1,  0, 0}, // #878
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 2, false, false, 187, 7, 27, 1,  0, 0}, // #879
  {DBGFIELD("MMX_CVTPI2PDirm")    2, false, false, 187, 7, 27, 1,  0, 0}, // #880
  {DBGFIELD("CVTSD2SSrm")         1, false, false, 205, 7,  8, 1,  0, 0}, // #881
  {DBGFIELD("CVTSD2SSrm_Int_VCVTSD2SSrm_VCVTSD2SSrm_Int") 1, false, false, 205, 7,  8, 1, 11, 1}, // #882
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 1, false, false, 273, 5,  4, 1,  0, 0}, // #883
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 45, false, false, 657, 2, 68, 1,  0, 0}, // #884
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 1, false, false, 96, 2,  2, 1,  0, 0}, // #885
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, 371, 4,  6, 1,  0, 0}, // #886
  {DBGFIELD("VPCMPGTQYrm")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #887
  {DBGFIELD("CVTSI642SSrr")       2, false, false, 652, 5, 27, 1,  0, 0}, // #888
  {DBGFIELD("CVTSI642SSrr_Int_VCVTSI642SSrr_VCVTSI642SSrr_Int") 2, false, false, 188, 5, 23, 1, 14, 1}, // #889
  {DBGFIELD("STR16r_STR32r_STR64r") 1, false, false, 96, 2,  2, 1,  0, 0}, // #890
  {DBGFIELD("XSETBV")             1, false, false, 96, 2,  2, 1,  0, 0}, // #891
  {DBGFIELD("VCVTDQ2PDYrr")       4, false, false, 206, 5, 11, 1,  0, 0}, // #892
  {DBGFIELD("VCVTPD2PSYrr")       4, false, false, 495, 6, 11, 1,  0, 0}, // #893
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 4, false, false, 495, 6, 11, 1,  0, 0}, // #894
  {DBGFIELD("VCVTDQ2PDYrm")       5, false, false, 205, 7, 27, 1,  0, 0}, // #895
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 2, false, false, 438, 5, 64, 2,  0, 0}, // #896
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 20, false, false, 659, 2,  8, 1,  0, 0}, // #897
  {DBGFIELD("RCL8rCL")            26, false, false, 661, 2, 20, 1,  0, 0}, // #898
  {DBGFIELD("RDTSC")              1, false, false, 96, 2,  2, 1,  0, 0}, // #899
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 1, false, false, 96, 2,  2, 1,  0, 0}, // #900
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, 231, 4,  8, 1,  0, 0}, // #901
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 1, false, false, 646, 6,  8, 1,  0, 0}, // #902
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 1, false, false, 646, 6,  8, 1,  0, 0}, // #903
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, 231, 4,  8, 1,  0, 0}, // #904
  {DBGFIELD("XSAVE64")            1, false, false, 96, 2,  2, 1,  0, 0}, // #905
  {DBGFIELD("XSAVE")              1, false, false, 96, 2,  2, 1,  0, 0}, // #906
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 1, false, false, 96, 2,  2, 1,  0, 0}, // #907
  {DBGFIELD("VMCLEARm")           1, false, false, 96, 2,  2, 1,  0, 0}, // #908
  {DBGFIELD("FLDENVm")            1, false, false, 96, 2,  2, 1,  0, 0}, // #909
  {DBGFIELD("FXRSTOR64")          1, false, false, 96, 2,  2, 1,  0, 0}, // #910
  {DBGFIELD("FSTENVm")            1, false, false, 96, 2,  2, 1,  0, 0}, // #911
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm_VPGATHERDDrm") 1, false, false, 169, 2,  6, 1,  0, 0}, // #912
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 1, false, false, 169, 2,  6, 1,  0, 0}, // #913
  {DBGFIELD("VPGATHERQDYrm")      1, false, false, 169, 2,  6, 1,  0, 0}, // #914
  {DBGFIELD("VPGATHERQDrm")       1, false, false, 169, 2,  6, 1,  0, 0}, // #915
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 1, false, false, 169, 2,  6, 1,  0, 0}, // #916
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 1, false, false, 169, 2,  6, 1,  0, 0}, // #917
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 1, false, false, 169, 2,  6, 1,  0, 0}, // #918
  {DBGFIELD("VGATHERQPSYrm")      1, false, false, 169, 2,  6, 1,  0, 0}, // #919
  {DBGFIELD("VGATHERQPSrm_VGATHERDPSrm") 1, false, false, 169, 2,  6, 1,  0, 0}, // #920
  {DBGFIELD("VPXORYrr")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #921
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #922
  {DBGFIELD("VPCMPGTQYrr")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #923
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false, 79, 2,  1, 1,  0, 0}, // #924
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 1, false, false, 79, 2,  1, 1,  0, 0}, // #925
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 1, false, false, 371, 4,  5, 1,  0, 0}, // #926
  {DBGFIELD("LRETQ")              1, false, false, 90, 6,  6, 1,  0, 0}, // #927
  {DBGFIELD("CVTDQ2PSrm_VCVTDQ2PSrm") 1, false, false, 187, 7,  8, 1,  0, 0}, // #928
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 2, false, false, 187, 7, 27, 1,  0, 0}, // #929
  {DBGFIELD("POPF64")             1, false, false, 169, 2,  6, 1,  0, 0}, // #930
  {DBGFIELD("VGATHERQPDrm")       1, false, false, 169, 2,  6, 1,  0, 0}, // #931
  {DBGFIELD("VGATHERQPDYrm")      1, false, false, 169, 2,  6, 1,  0, 0}, // #932
  {DBGFIELD("VGATHERDPDrm")       1, false, false, 169, 2,  6, 1,  0, 0}, // #933
  {DBGFIELD("VGATHERDPSrm")       1, false, false, 169, 2,  6, 1,  0, 0}, // #934
  {DBGFIELD("VGATHERDPDYrm")      1, false, false, 169, 2,  6, 1,  0, 0}, // #935
  {DBGFIELD("VGATHERDPSYrm")      1, false, false, 169, 2,  6, 1,  0, 0}, // #936
  {DBGFIELD("PCMPEQQrr")          1, false, false, 263, 3,  3, 1,  0, 0}, // #937
  {DBGFIELD("PCMPEQQrm")          1, false, false, 273, 5,  4, 1, 11, 1}, // #938
  {DBGFIELD("MOV16rm")            1, false, false, 169, 2,  6, 1,  0, 0}, // #939
  {DBGFIELD("MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX") 1, false, false, 124, 4,  6, 1,  0, 0}, // #940
  {DBGFIELD("POP16rmm")           2, false, false, 435, 3,  5, 1,  0, 0}, // #941
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 2, false, false, 435, 3,  5, 1,  0, 0}, // #942
  {DBGFIELD("PUSHF16")            1, false, false, 248, 2,  1, 1,  0, 0}, // #943
  {DBGFIELD("LAHF")               4, false, false, 184, 2,  3, 1,  0, 0}, // #944
  {DBGFIELD("ADD16mi_ADD16mi8_ADD16mr_ADD32mi_ADD32mi8_ADD32mr_ADD64mi32_ADD64mi8_ADD64mr_ADD8mi_ADD8mi8_ADD8mr_SUB16mi_SUB16mi8_SUB16mr_SUB32mi_SUB32mi8_SUB32mr_SUB64mi32_SUB64mi8_SUB64mr_SUB8mi_SUB8mi8_SUB8mr") 1, false, false, 119, 5,  5, 1,  0, 0}, // #945
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 2, false, false, 119, 5,  5, 1,  0, 0}, // #946
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 1, false, false, 119, 5,  5, 1,  0, 0}, // #947
  {DBGFIELD("MULX32rr")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #948
  {DBGFIELD("MULX32rm")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #949
  {DBGFIELD("MULX64rr")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #950
  {DBGFIELD("MULX64rm")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #951
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 1, false, false, 91, 4,  1, 1,  0, 0}, // #952
  {DBGFIELD("RETW_LRETL_LRETW")   1, false, false, 90, 6,  6, 1,  0, 0}, // #953
  {DBGFIELD("IRET16_IRET32_IRET64") 1, false, false, 90, 6,  6, 1,  0, 0}, // #954
  {DBGFIELD("AND16mi_AND16mi8_AND16mr_AND32mi_AND32mi8_AND32mr_AND64mi32_AND64mi8_AND64mr_AND8mi_AND8mi8_AND8mr_OR16mi_OR16mi8_OR16mr_OR32mi_OR32mi8_OR32mi8Locked_OR32mr_OR64mi32_OR64mi8_OR64mr_OR8mi_OR8mi8_OR8mr_XOR16mi_XOR16mi8_XOR16mr_XOR32mi_XOR32mi8_XOR32mr_XOR64mi32_XOR64mi8_XOR64mr_XOR8mi_XOR8mi8_XOR8mr") 1, false, false, 119, 5,  5, 1,  0, 0}, // #955
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 8, false, false, 459, 4, 23, 1,  0, 0}, // #956
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 7, false, false, 98, 2, 22, 1,  0, 0}, // #957
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 8, false, false, 459, 4, 23, 1,  0, 0}, // #958
  {DBGFIELD("MOVSLDUPrm")         1, false, false, 140, 5,  4, 1,  0, 0}, // #959
  {DBGFIELD("MOVSLDUPrr")         1, false, false, 141, 3,  3, 1,  0, 0}, // #960
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 2, false, false, 92, 3,  1, 1,  0, 0}, // #961
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, 115, 4,  1, 1,  0, 0}, // #962
  {DBGFIELD("VPMOVSXBDYrr_VPMOVSXBQYrr_VPMOVSXBWYrr_VPMOVSXDQYrr_VPMOVSXWDYrr_VPMOVSXWQYrr_VPMOVZXBDYrr_VPMOVZXBQYrr_VPMOVZXBWYrr_VPMOVZXDQYrr_VPMOVZXWDYrr_VPMOVZXWQYrr") 1, false, false, 81, 3,  1, 1,  0, 0}, // #963
  {DBGFIELD("VPMOVZXBDYrm_VPMOVZXBQYrm_VPMOVZXBWYrm_VPMOVZXDQYrm_VPMOVZXWQYrm") 1, false, false, 354, 5,  5, 1,  0, 0}, // #964
  {DBGFIELD("PBLENDWrri_VPBLENDWrri") 1, false, false, 81, 3,  3, 1,  0, 0}, // #965
  {DBGFIELD("VPBLENDWYrri")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #966
  {DBGFIELD("PBLENDWrmi_VPBLENDWrmi") 1, false, false, 354, 5,  4, 1, 11, 1}, // #967
  {DBGFIELD("VPBLENDWYrmi")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #968
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, 263, 3,  3, 1,  0, 0}, // #969
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 1, false, false, 100, 5,  1, 1,  0, 0}, // #970
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 1, false, false, 100, 5,  1, 1,  0, 0}, // #971
  {DBGFIELD("VPMASKMOVDYrm")      2, false, false, 569, 5,  5, 1,  0, 0}, // #972
  {DBGFIELD("VPMASKMOVDrm")       1, false, false, 273, 5,  5, 1,  0, 0}, // #973
  {DBGFIELD("VPMASKMOVDYmr_VPMASKMOVQYmr") 2, false, false, 580, 5,  5, 1,  0, 0}, // #974
  {DBGFIELD("VPMASKMOVDmr_VPMASKMOVQmr") 1, false, false, 585, 5,  5, 1,  0, 0}, // #975
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 1, false, false, 273, 5,  4, 1,  0, 0}, // #976
  {DBGFIELD("VPSLLDQri_VPSRLDQri") 1, false, false, 263, 3,  3, 1,  0, 0}, // #977
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri") 2, false, false, 360, 3,  3, 1,  0, 0}, // #978
  {DBGFIELD("VPERM2F128rr")       8, false, false, 663, 3, 23, 1,  0, 0}, // #979
  {DBGFIELD("VPERM2F128rm")       10, false, false, 666, 3, 11, 1,  0, 0}, // #980
  {DBGFIELD("VEXTRACTF128rr")     1, false, false, 141, 3,  3, 1,  0, 0}, // #981
  {DBGFIELD("VEXTRACTF128mr")     2, false, false, 557, 3,  4, 1,  0, 0}, // #982
  {DBGFIELD("VINSERTF128rr")      2, false, false, 106, 3,  3, 1,  0, 0}, // #983
  {DBGFIELD("VCVTPD2DQrm_VCVTTPD2DQrm") 2, false, false, 187, 7, 27, 1,  0, 0}, // #984
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 4, false, false, 494, 8, 27, 1,  0, 0}, // #985
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, 195, 9, 27, 1,  0, 0}, // #986
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 2, false, false, 194, 11, 29, 1,  0, 0}, // #987
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, 337, 3, 22, 1,  0, 0}, // #988
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, 337, 3, 22, 1,  0, 0}, // #989
  {DBGFIELD("SHA256MSG2rm")       1, false, false, 134, 6,  8, 1, 11, 1}, // #990
  {DBGFIELD("SHA256MSG2rr")       1, false, false, 135, 4, 23, 1,  0, 0}, // #991
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, 135, 4, 23, 1,  0, 0}, // #992
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 1, false, false, 134, 6,  8, 1, 11, 1}, // #993
  {DBGFIELD("SHA1MSG2rr")         1, false, false, 135, 4, 23, 1,  0, 0}, // #994
  {DBGFIELD("SHA1MSG2rm")         1, false, false, 134, 6,  8, 1, 11, 1}, // #995
  {DBGFIELD("SHA1NEXTErr")        1, false, false, 135, 4, 23, 1,  0, 0}, // #996
  {DBGFIELD("SHA1NEXTErm")        1, false, false, 134, 6,  8, 1, 11, 1}, // #997
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, 135, 4, 23, 1,  0, 0}, // #998
  {DBGFIELD("SHA1RNDS4rmi")       1, false, false, 134, 6,  8, 1, 11, 1}, // #999
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, 135, 4, 23, 1,  0, 0}, // #1000
  {DBGFIELD("SHA256RNDS2rm")      1, false, false, 134, 6,  8, 1, 11, 1}, // #1001
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 2, false, false, 92, 3,  1, 1,  0, 0}, // #1002
  {DBGFIELD("BT16mi8_BT32mi8_BT64mi8") 1, false, false, 124, 4,  6, 1,  0, 0}, // #1003
  {DBGFIELD("BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 2, false, false, 79, 2,  3, 1,  0, 0}, // #1004
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 45, false, false, 657, 2, 68, 1,  0, 0}, // #1005
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 4, false, false, 669, 2,  5, 1,  0, 0}, // #1006
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 2, false, false, 79, 2,  3, 1,  0, 0}, // #1007
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 2, false, false, 671, 4,  5, 1,  0, 0}, // #1008
  {DBGFIELD("ADC64ri32_SBB64ri32") 1, false, false, 672, 2,  1, 1,  0, 0}, // #1009
  {DBGFIELD("CRC32r32r16")        5, false, false, 675, 2,  6, 1,  0, 0}, // #1010
  {DBGFIELD("CRC32r32r32")        7, false, false, 677, 2,  5, 1,  0, 0}, // #1011
  {DBGFIELD("CRC32r64r64")        11, false, false, 679, 2, 19, 1,  0, 0}, // #1012
  {DBGFIELD("SAHF")               2, false, false, 79, 2,  3, 1,  0, 0}, // #1013
  {DBGFIELD("BEXTRI32ri_BEXTRI64ri") 2, false, false, 184, 2,  3, 1,  0, 0}, // #1014
  {DBGFIELD("BEXTRI32mi_BEXTRI64mi") 2, false, false, 681, 2,  3, 1,  0, 0}, // #1015
  {DBGFIELD("RCR8ri")             23, false, false, 683, 2, 20, 1,  0, 0}, // #1016
  {DBGFIELD("RCL16rCL")           22, false, false, 685, 2, 19, 1,  0, 0}, // #1017
  {DBGFIELD("RCR16ri")            19, false, false, 687, 2, 19, 1,  0, 0}, // #1018
  {DBGFIELD("RCL32rCL_RCL64rCL")  17, false, false, 689, 2,  4, 1,  0, 0}, // #1019
  {DBGFIELD("RCR32rCL_RCR64rCL")  16, false, false, 691, 2,  4, 1,  0, 0}, // #1020
  {DBGFIELD("RCR32ri_RCR64ri")    15, false, false, 689, 2,  4, 1,  0, 0}, // #1021
  {DBGFIELD("RCL16ri")            21, false, false, 693, 2,  9, 1,  0, 0}, // #1022
  {DBGFIELD("RCL32ri_RCL64ri")    16, false, false, 695, 2, 11, 1,  0, 0}, // #1023
  {DBGFIELD("SHLD32rri8")         6, false, false, 98, 2, 22, 1,  0, 0}, // #1024
  {DBGFIELD("SHRD16rri8")         6, false, false, 98, 2, 22, 1,  0, 0}, // #1025
  {DBGFIELD("SHLD16rrCL")         7, false, false, 98, 2, 22, 1,  0, 0}, // #1026
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 2, false, false, 100, 5,  3, 1,  0, 0}, // #1027
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 8, false, false, 348, 6,  1, 1,  0, 0}, // #1028
  {DBGFIELD("TST_F")              1, false, false, 371, 4,  1, 1,  0, 0}, // #1029
  {DBGFIELD("VDPPSrri")           17, false, false, 243, 4, 66, 1,  0, 0}, // #1030
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr") 2, false, false, 251, 4, 19, 1,  0, 0}, // #1031
  {DBGFIELD("VFRCZSDrr_VFRCZSSrr") 2, false, false, 697, 4, 19, 1,  0, 0}, // #1032
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 3, false, false, 251, 4, 10, 1,  0, 0}, // #1033
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 4, false, false, 701, 4, 19, 1,  0, 0}, // #1034
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 8, false, false, 705, 4, 10, 1,  0, 0}, // #1035
  {DBGFIELD("MMX_CVTTPD2PIirr")   2, false, false, 188, 5,  5, 1,  0, 0}, // #1036
  {DBGFIELD("VMOVDQUYmr")         8, false, false, 348, 6,  1, 1,  0, 0}, // #1037
  {DBGFIELD("MOVDQArr")           1, false, false, 81, 3,  1, 1,  0, 0}, // #1038
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 1, false, false, 709, 5, 23, 1,  0, 0}, // #1039
  {DBGFIELD("VMPSADBWrri")        10, false, false, 365, 4, 11, 1,  0, 0}, // #1040
  {DBGFIELD("VPPERMrrr_VPPERMrrr_REV") 1, false, false, 337, 3,  3, 1,  0, 0}, // #1041
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 3, false, false, 360, 3,  6, 1,  0, 0}, // #1042
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 4, false, false, 359, 5, 19, 1,  0, 0}, // #1043
  {DBGFIELD("VPCLMULQDQrr")       6, false, false, 377, 4, 20, 1,  0, 0}, // #1044
  {DBGFIELD("INSERTQ")            1, false, false, 263, 3, 22, 1,  0, 0}, // #1045
  {DBGFIELD("ANDNPSrr_VANDNPSrr_ANDNPDrr_VANDNPDrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1046
  {DBGFIELD("MMX_PXORirr_MMX_PANDNirr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1047
  {DBGFIELD("PANDNrr_VPANDNrr")   16382, false, false,  0, 0,  0, 0,  0, 0}, // #1048
  {DBGFIELD("MMX_PSUBBirr_MMX_PSUBDirr_MMX_PSUBWirr_MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1049
  {DBGFIELD("LCMPXCHG8_LCMPXCHG16_LCMPXCHG32_LCMPXCHG64") 2, false, false, 84, 6, 22, 1,  0, 0}, // #1050
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 5, false, false, 171, 3, 22, 1,  0, 0}, // #1051
  {DBGFIELD("LCMPXCHG8B_LCMPXCHG16B") 2, false, false, 84, 6, 22, 1,  0, 0}, // #1052
  {DBGFIELD("XCHG8rr")            2, false, false, 92, 3,  1, 1,  0, 0}, // #1053
  {DBGFIELD("VANDNPSYrr_VANDNPDYrr") 2, false, false, 480, 3,  3, 1,  0, 0}, // #1054
  {DBGFIELD("MMX_PSUBSBirr_MMX_PSUBSWirr_MMX_PSUBUSBirr_MMX_PSUBUSWirr") 1, false, false, 81, 3,  3, 1,  0, 0}, // #1055
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false, 263, 3,  3, 1,  0, 0}, // #1056
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 2, false, false, 96, 2,  1, 1,  0, 0}, // #1057
  {DBGFIELD("LEA16r")             2, false, false, 96, 2,  1, 1,  0, 0}, // #1058
  {DBGFIELD("MMX_PADDSBirr_MMX_PADDSWirr_MMX_PADDUSBirr_MMX_PADDUSWirr_MMX_PAVGBirr_MMX_PAVGWirr_MMX_PCMPEQBirr_MMX_PCMPEQDirr_MMX_PCMPEQWirr_MMX_PMAXSWirr_MMX_PMINSWirr_MMX_PMAXUBirr_MMX_PMINUBirr") 1, false, false, 81, 3,  3, 1,  0, 0}, // #1059
  {DBGFIELD("MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1060
  {DBGFIELD("CLAC_STAC")          1, false, false, 96, 2,  2, 1,  0, 0}, // #1061
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, 263, 3,  3, 1,  0, 0}, // #1062
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1063
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, 129, 4,  6, 1,  0, 0}, // #1064
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 3, false, false, 360, 3,  6, 1,  0, 0}, // #1065
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, 360, 3,  6, 1,  0, 0}, // #1066
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1067
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, 188, 5, 23, 1,  0, 0}, // #1068
  {DBGFIELD("VCVTPS2DQYrr_VCVTTPS2DQYrr") 2, false, false, 206, 5, 23, 1,  0, 0}, // #1069
  {DBGFIELD("MMX_PADDSBirm_MMX_PADDSWirm_MMX_PADDUSBirm_MMX_PADDUSWirm_MMX_PAVGBirm_MMX_PAVGWirm_MMX_PCMPEQBirm_MMX_PCMPEQDirm_MMX_PCMPEQWirm_MMX_PCMPGTBirm_MMX_PCMPGTDirm_MMX_PCMPGTWirm_MMX_PMAXSWirm_MMX_PMAXUBirm_MMX_PMINSWirm_MMX_PMINUBirm_MMX_PSUBSBirm_MMX_PSUBSWirm_MMX_PSUBUSBirm_MMX_PSUBUSWirm") 1, false, false, 354, 5,  4, 1, 11, 1}, // #1070
  {DBGFIELD("CVTSS2SI64rr_Int")   2, false, false, 195, 9, 27, 1,  0, 0}, // #1071
  {DBGFIELD("CVTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int") 2, false, false, 195, 9, 27, 1,  0, 0}, // #1072
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 1, false, false, 273, 5,  4, 1, 11, 1}, // #1073
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1074
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 4, false, false, 359, 5, 19, 1, 11, 1}, // #1075
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, 359, 5, 19, 1,  0, 0}, // #1076
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1077
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 1, false, false, 96, 2,  2, 1,  0, 0}, // #1078
  {DBGFIELD("PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1079
  {DBGFIELD("VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1080
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, 263, 3,  3, 1,  0, 0}, // #1081
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, 79, 2,  1, 1,  0, 0}, // #1082
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, 79, 2,  1, 1,  0, 0}, // #1083
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 1, false, false, 106, 3,  3, 1,  0, 0}, // #1084
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 2, false, false, 485, 3,  3, 1,  0, 0}, // #1085
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, 263, 3,  3, 1,  0, 0}, // #1086
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1087
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1088
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 1, false, false, 263, 3,  3, 1,  0, 0}, // #1089
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1090
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false, 248, 2,  1, 1,  0, 0}, // #1091
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 4, false, false, 561, 5,  1, 1,  0, 0}, // #1092
  {DBGFIELD("KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, 79, 2,  1, 1,  0, 0}, // #1093
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, 263, 3,  3, 1,  0, 0}, // #1094
  {DBGFIELD("VPSADBWZrr")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #1095
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_VPTESTMBZ128rr_VPTESTMBZ128rrk_VPTESTMDZ128rr_VPTESTMDZ128rrk_VPTESTMQZ128rr_VPTESTMQZ128rrk_VPTESTMWZ128rr_VPTESTMWZ128rrk_VPTESTNMBZ128rr_VPTESTNMBZ128rrk_VPTESTNMDZ128rr_VPTESTNMDZ128rrk_VPTESTNMQZ128rr_VPTESTNMQZ128rrk_VPTESTNMWZ128rr_VPTESTNMWZ128rrk") 1, false, false, 263, 3,  3, 1,  0, 0}, // #1096
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri_KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, 263, 3,  3, 1,  0, 0}, // #1097
  {DBGFIELD("VALIGNDZ128rri_VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rri_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, 263, 3,  3, 1,  0, 0}, // #1098
  {DBGFIELD("VALIGNDZ256rri_VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rri_VALIGNQZ256rrik_VALIGNQZ256rrikz") 2, false, false, 360, 3,  3, 1,  0, 0}, // #1099
  {DBGFIELD("VALIGNDZrri_VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrri_VALIGNQZrrik_VALIGNQZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1100
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, 129, 4,  3, 1,  0, 0}, // #1101
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 2, false, false, 474, 4,  3, 1,  0, 0}, // #1102
  {DBGFIELD("VCMPPDZrri_VCMPPDZrrib_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrrib_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1103
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, 129, 4,  3, 1,  0, 0}, // #1104
  {DBGFIELD("VDBPSADBWZrri_VDBPSADBWZrrik_VDBPSADBWZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1105
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rrik_VPCMPDZ128rri_VPCMPDZ128rrik_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rrik_VPCMPUBZ128rri_VPCMPUBZ128rrik_VPCMPUDZ128rri_VPCMPUDZ128rrik_VPCMPUQZ128rri_VPCMPUQZ128rrik_VPCMPUWZ128rri_VPCMPUWZ128rrik_VPCMPWZ128rri_VPCMPWZ128rrik_VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, 263, 3,  3, 1,  0, 0}, // #1106
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rrik_VPCMPDZ256rri_VPCMPDZ256rrik_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rrik_VPCMPUBZ256rri_VPCMPUBZ256rrik_VPCMPUDZ256rri_VPCMPUDZ256rrik_VPCMPUQZ256rri_VPCMPUQZ256rrik_VPCMPUWZ256rri_VPCMPUWZ256rrik_VPCMPWZ256rri_VPCMPWZ256rrik_VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1107
  {DBGFIELD("VPCMPBZrri_VPCMPBZrrik_VPCMPDZrri_VPCMPDZrrik_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrrik_VPCMPUBZrri_VPCMPUBZrrik_VPCMPUDZrri_VPCMPUDZrrik_VPCMPUQZrri_VPCMPUQZrrik_VPCMPUWZrri_VPCMPUWZrrik_VPCMPWZrri_VPCMPWZrrik_VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1108
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1109
  {DBGFIELD("VPTESTMBZrr_VPTESTMBZrrk_VPTESTMDZrr_VPTESTMDZrrk_VPTESTMQZrr_VPTESTMQZrrk_VPTESTMWZrr_VPTESTMWZrrk_VPTESTNMBZrr_VPTESTNMBZrrk_VPTESTNMDZrr_VPTESTNMDZrrk_VPTESTNMQZrr_VPTESTNMQZrrk_VPTESTNMWZrr_VPTESTNMWZrrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1110
  {DBGFIELD("VCVTDQ2PSZ128rr_VCVTDQ2PSZ128rrk_VCVTDQ2PSZ128rrkz_VCVTUDQ2PSZ128rr_VCVTUDQ2PSZ128rrk_VCVTUDQ2PSZ128rrkz") 1, false, false, 188, 5, 23, 1,  0, 0}, // #1111
  {DBGFIELD("VCVTDQ2PSZ256rr_VCVTDQ2PSZ256rrk_VCVTDQ2PSZ256rrkz_VCVTUDQ2PSZ256rr_VCVTUDQ2PSZ256rrk_VCVTUDQ2PSZ256rrkz") 2, false, false, 206, 5, 23, 1,  0, 0}, // #1112
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 2, false, false, 188, 5, 11, 1,  0, 0}, // #1113
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 4, false, false, 495, 6, 11, 1,  0, 0}, // #1114
  {DBGFIELD("VCVTPS2DQYrr")       2, false, false, 206, 5, 23, 1,  0, 0}, // #1115
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, 188, 5, 23, 1,  0, 0}, // #1116
  {DBGFIELD("VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 2, false, false, 206, 5, 23, 1,  0, 0}, // #1117
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 2, false, false, 188, 5, 11, 1,  0, 0}, // #1118
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 4, false, false, 206, 5, 11, 1,  0, 0}, // #1119
  {DBGFIELD("VCVTDQ2PSZrr_VCVTUDQ2PSZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1120
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1121
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1122
  {DBGFIELD("VCVTQQ2PDZrr_VCVTUQQ2PDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1123
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 1, false, false, 81, 3,  1, 1,  0, 0}, // #1124
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 1, false, false, 81, 3,  1, 1,  0, 0}, // #1125
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 1, false, false, 354, 5,  5, 1,  0, 0}, // #1126
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 2, false, false, 188, 5, 11, 1,  0, 0}, // #1127
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 2, false, false, 188, 5, 11, 1,  0, 0}, // #1128
  {DBGFIELD("VCVTPD2PSZ128rr_VCVTPD2PSZ128rrk_VCVTPD2PSZ128rrkz") 2, false, false, 188, 5, 11, 1,  0, 0}, // #1129
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz") 2, false, false, 188, 5, 11, 1,  0, 0}, // #1130
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false, 188, 5, 23, 1,  0, 0}, // #1131
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false, 188, 5, 23, 1,  0, 0}, // #1132
  {DBGFIELD("VCVTSD2SSZrr_VCVTSD2SSZrr_Int_VCVTSD2SSZrr_Intk_VCVTSD2SSZrr_Intkz_VCVTSD2SSZrrb_Int_VCVTSD2SSZrrb_Intk_VCVTSD2SSZrrb_Intkz") 1, false, false, 206, 5, 23, 1,  0, 0}, // #1133
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 2, false, false, 188, 5, 23, 1, 14, 1}, // #1134
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 2, false, false, 188, 5, 23, 1, 14, 1}, // #1135
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz") 1, false, false, 206, 5, 23, 1,  0, 0}, // #1136
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, 263, 3,  3, 1,  0, 0}, // #1137
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 3, false, false, 510, 7, 23, 1,  0, 0}, // #1138
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 4, false, false, 502, 8, 23, 1,  0, 0}, // #1139
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1140
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 1, false, false, 354, 5,  5, 1,  0, 0}, // #1141
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 1, false, false, 81, 3,  1, 1,  0, 0}, // #1142
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 1, false, false, 336, 5,  6, 1,  0, 0}, // #1143
  {DBGFIELD("VMOVDI2PDIZrm")      1, false, false, 336, 5,  6, 1,  0, 0}, // #1144
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 2, false, false, 188, 5, 23, 1, 14, 1}, // #1145
  {DBGFIELD("VMOVSDZrm_VMOVSDZrm_alt_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrm_alt_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, 105, 5,  6, 1,  0, 0}, // #1146
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 4, false, false, 206, 5, 11, 1,  0, 0}, // #1147
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 4, false, false, 495, 6, 11, 1,  0, 0}, // #1148
  {DBGFIELD("VCVTPD2PSZ256rr_VCVTPD2PSZ256rrk_VCVTPD2PSZ256rrkz") 4, false, false, 495, 6, 11, 1,  0, 0}, // #1149
  {DBGFIELD("VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 4, false, false, 206, 5, 11, 1,  0, 0}, // #1150
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 2, false, false, 206, 5, 23, 1,  0, 0}, // #1151
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 2, false, false, 206, 5, 23, 1,  0, 0}, // #1152
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1153
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1154
  {DBGFIELD("VCVTPD2PSZrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1155
  {DBGFIELD("VCVTPS2PDZrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1156
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1157
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1158
  {DBGFIELD("VMOVNTDQAZ128rm")    1, false, false, 336, 5,  6, 1,  0, 0}, // #1159
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 1, false, false, 105, 5,  4, 1, 11, 1}, // #1160
  {DBGFIELD("VBROADCASTI32X2Z128m_VBROADCASTI32X2Z128mk_VBROADCASTI32X2Z128mkz_VPBROADCASTDZ128m_VPBROADCASTDZ128mk_VPBROADCASTDZ128mkz_VPBROADCASTQZ128m_VPBROADCASTQZ128mk_VPBROADCASTQZ128mkz") 1, false, false, 273, 5,  4, 1,  0, 0}, // #1161
  {DBGFIELD("VBROADCASTSSZ128m_VBROADCASTSSZ128mk_VBROADCASTSSZ128mkz") 2, false, false, 105, 5,  4, 1,  0, 0}, // #1162
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, 105, 5,  6, 1,  0, 0}, // #1163
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 1, false, false, 140, 5,  4, 1,  0, 0}, // #1164
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, 336, 5,  6, 1,  0, 0}, // #1165
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 1, false, false, 273, 5,  4, 1, 11, 1}, // #1166
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 1, false, false, 273, 5,  4, 1, 11, 1}, // #1167
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 1, false, false, 81, 3,  1, 1,  0, 0}, // #1168
  {DBGFIELD("VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 2, false, false, 195, 9, 27, 1,  0, 0}, // #1169
  {DBGFIELD("VCVTSS2SI64rr_Int")  2, false, false, 195, 9, 27, 1,  0, 0}, // #1170
  {DBGFIELD("VCVTTSS2SI64rr")     2, false, false, 195, 9, 27, 1,  0, 0}, // #1171
  {DBGFIELD("VCVTTSS2SI64rr_Int") 2, false, false, 195, 9, 27, 1,  0, 0}, // #1172
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, 169, 2,  6, 1,  0, 0}, // #1173
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 1, false, false, 354, 5,  5, 1,  0, 0}, // #1174
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 1, false, false, 248, 2,  1, 1,  0, 0}, // #1175
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 1, false, false, 248, 2,  1, 1,  0, 0}, // #1176
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 1, false, false, 248, 2,  1, 1,  0, 0}, // #1177
  {DBGFIELD("VSCATTERDPSZmr")     1, false, false, 248, 2,  1, 1,  0, 0}, // #1178
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk") 1, false, false, 128, 6,  4, 1, 11, 1}, // #1179
  {DBGFIELD("VPBROADCASTBZ256m_VPBROADCASTBZ256mk_VPBROADCASTBZ256mkz_VPBROADCASTBZm_VPBROADCASTBZmk_VPBROADCASTBZmkz_VPBROADCASTWZ256m_VPBROADCASTWZ256mk_VPBROADCASTWZ256mkz_VPBROADCASTWZm_VPBROADCASTWZmk_VPBROADCASTWZmkz") 1, false, false, 354, 5,  5, 1,  0, 0}, // #1180
  {DBGFIELD("VMOVNTDQAZ256rm")    2, false, false, 541, 5,  6, 1,  0, 0}, // #1181
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 2, false, false, 484, 5,  4, 1, 11, 1}, // #1182
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1183
  {DBGFIELD("VBROADCASTF32X2Z256m_VBROADCASTF32X2Z256mk_VBROADCASTF32X2Z256mkz_VBROADCASTF32X2Zm_VBROADCASTF32X2Zmk_VBROADCASTF32X2Zmkz_VBROADCASTI32X2Z256m_VBROADCASTI32X2Z256mk_VBROADCASTI32X2Z256mkz_VBROADCASTI32X2Zm_VBROADCASTI32X2Zmk_VBROADCASTI32X2Zmkz_VPBROADCASTDZ256m_VPBROADCASTDZ256mk_VPBROADCASTDZ256mkz_VPBROADCASTDZm_VPBROADCASTDZmk_VPBROADCASTDZmkz_VPBROADCASTQZ256m_VPBROADCASTQZ256mk_VPBROADCASTQZ256mkz_VPBROADCASTQZm_VPBROADCASTQZmk_VPBROADCASTQZmkz") 1, false, false, 354, 5,  5, 1,  0, 0}, // #1184
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 2, false, false, 359, 5,  4, 1,  0, 0}, // #1185
  {DBGFIELD("VBROADCASTSDZ256m_VBROADCASTSDZ256mk_VBROADCASTSDZ256mkz_VBROADCASTSDZm_VBROADCASTSDZmk_VBROADCASTSDZmkz_VBROADCASTSSZ256m_VBROADCASTSSZ256mk_VBROADCASTSSZ256mkz_VBROADCASTSSZm_VBROADCASTSSZmk_VBROADCASTSSZmkz") 2, false, false, 105, 5,  4, 1,  0, 0}, // #1186
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 2, false, false, 105, 5,  4, 1, 11, 1}, // #1187
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 1, false, false, 354, 5,  5, 1, 11, 1}, // #1188
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 2, false, false, 105, 5,  6, 1,  0, 0}, // #1189
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, 484, 5,  4, 1,  0, 0}, // #1190
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1191
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 2, false, false, 541, 5,  6, 1,  0, 0}, // #1192
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1193
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1194
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1195
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1196
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 1, false, false, 248, 2,  1, 1,  0, 0}, // #1197
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 1, false, false, 248, 2,  1, 1,  0, 0}, // #1198
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 1, false, false, 248, 2,  1, 1,  0, 0}, // #1199
  {DBGFIELD("VPSCATTERDDZmr")     1, false, false, 248, 2,  1, 1,  0, 0}, // #1200
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 1, false, false, 273, 5,  4, 1, 11, 1}, // #1201
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmik") 1, false, false, 128, 6,  4, 1, 11, 1}, // #1202
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 1, false, false, 128, 6,  4, 1, 11, 1}, // #1203
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmik_VPCMPDZ128rmi_VPCMPDZ128rmib_VPCMPDZ128rmibk_VPCMPDZ128rmik_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmib_VPCMPQZ128rmibk_VPCMPQZ128rmik_VPCMPUBZ128rmi_VPCMPUBZ128rmik_VPCMPUDZ128rmi_VPCMPUDZ128rmib_VPCMPUDZ128rmibk_VPCMPUDZ128rmik_VPCMPUQZ128rmi_VPCMPUQZ128rmib_VPCMPUQZ128rmibk_VPCMPUQZ128rmik_VPCMPUWZ128rmi_VPCMPUWZ128rmik_VPCMPWZ128rmi_VPCMPWZ128rmik_VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 1, false, false, 273, 5,  4, 1, 11, 1}, // #1204
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 1, false, false, 354, 5,  5, 1, 11, 1}, // #1205
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1206
  {DBGFIELD("VPMOVSXBDZ128rm_VPMOVSXBDZ128rmk_VPMOVSXBDZ128rmkz_VPMOVSXBQZ128rm_VPMOVSXBQZ128rmk_VPMOVSXBQZ128rmkz_VPMOVSXBWZ128rm_VPMOVSXBWZ128rmk_VPMOVSXBWZ128rmkz_VPMOVSXDQZ128rm_VPMOVSXDQZ128rmk_VPMOVSXDQZ128rmkz_VPMOVSXWDZ128rm_VPMOVSXWDZ128rmk_VPMOVSXWDZ128rmkz_VPMOVSXWQZ128rm_VPMOVSXWQZ128rmk_VPMOVSXWQZ128rmkz_VPMOVZXBDZ128rm_VPMOVZXBDZ128rmk_VPMOVZXBDZ128rmkz_VPMOVZXBQZ128rm_VPMOVZXBQZ128rmk_VPMOVZXBQZ128rmkz_VPMOVZXBWZ128rm_VPMOVZXBWZ128rmk_VPMOVZXBWZ128rmkz_VPMOVZXDQZ128rm_VPMOVZXDQZ128rmk_VPMOVZXDQZ128rmkz_VPMOVZXWDZ128rm_VPMOVZXWDZ128rmk_VPMOVZXWDZ128rmkz_VPMOVZXWQZ128rm_VPMOVZXWQZ128rmk_VPMOVZXWQZ128rmkz") 1, false, false, 354, 5,  5, 1,  0, 0}, // #1207
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 1, false, false, 273, 5,  4, 1, 11, 1}, // #1208
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 2, false, false, 359, 5,  4, 1, 11, 1}, // #1209
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1210
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmik") 2, false, false, 473, 6,  4, 1, 11, 1}, // #1211
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmik") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1212
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmik_VPCMPDZ256rmi_VPCMPDZ256rmib_VPCMPDZ256rmibk_VPCMPDZ256rmik_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmib_VPCMPQZ256rmibk_VPCMPQZ256rmik_VPCMPUBZ256rmi_VPCMPUBZ256rmik_VPCMPUDZ256rmi_VPCMPUDZ256rmib_VPCMPUDZ256rmibk_VPCMPUDZ256rmik_VPCMPUQZ256rmi_VPCMPUQZ256rmib_VPCMPUQZ256rmibk_VPCMPUQZ256rmik_VPCMPUWZ256rmi_VPCMPUWZ256rmik_VPCMPWZ256rmi_VPCMPWZ256rmik_VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1213
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmik_VPCMPDZrmi_VPCMPDZrmib_VPCMPDZrmibk_VPCMPDZrmik_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmib_VPCMPQZrmibk_VPCMPQZrmik_VPCMPUBZrmi_VPCMPUBZrmik_VPCMPUDZrmi_VPCMPUDZrmib_VPCMPUDZrmibk_VPCMPUDZrmik_VPCMPUQZrmi_VPCMPUQZrmib_VPCMPUQZrmibk_VPCMPUQZrmik_VPCMPUWZrmi_VPCMPUWZrmik_VPCMPWZrmi_VPCMPWZrmik_VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1214
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1215
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1216
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 2, false, false, 187, 7, 27, 1,  0, 0}, // #1217
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 1, false, false, 187, 7,  8, 1,  0, 0}, // #1218
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 2, false, false, 187, 7, 27, 1,  0, 0}, // #1219
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 3, false, false, 205, 7, 27, 1,  0, 0}, // #1220
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 1, false, false, 187, 7,  8, 1,  0, 0}, // #1221
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 2, false, false, 187, 7, 27, 1,  0, 0}, // #1222
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz") 1, false, false, 205, 7,  8, 1, 11, 1}, // #1223
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 1, false, false, 354, 5,  5, 1, 11, 1}, // #1224
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 5, false, false, 205, 7, 27, 1,  0, 0}, // #1225
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1226
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 2, false, false, 205, 7,  8, 1,  0, 0}, // #1227
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1228
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 7, false, false, 205, 7, 27, 1,  0, 0}, // #1229
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1230
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 5, false, false, 205, 7, 27, 1,  0, 0}, // #1231
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1232
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 4, false, false, 494, 8, 27, 1,  0, 0}, // #1233
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1234
  {DBGFIELD("VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 2, false, false, 205, 7,  8, 1,  0, 0}, // #1235
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1236
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 1, false, false, 354, 5,  5, 1, 11, 1}, // #1237
  {DBGFIELD("VCVTSD2SSZrm_VCVTSD2SSZrm_Int_VCVTSD2SSZrm_Intk_VCVTSD2SSZrm_Intkz") 1, false, false, 205, 7,  8, 1, 11, 1}, // #1238
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 1, false, false, 273, 5,  4, 1,  0, 0}, // #1239
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, 135, 4, 23, 1,  0, 0}, // #1240
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1241
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1242
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 1, false, false, 354, 5,  5, 1, 11, 1}, // #1243
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 2, false, false, 194, 11, 29, 1, 11, 1}, // #1244
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 2, false, false, 194, 11, 29, 1, 11, 1}, // #1245
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1246
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 1, false, false, 354, 5,  5, 1, 11, 1}, // #1247
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 1, false, false, 354, 5,  5, 1, 11, 1}, // #1248
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1249
  {DBGFIELD("VCVTPD2PSZrm_VCVTPD2PSZrmb_VCVTPD2PSZrmbk_VCVTPD2PSZrmbkz_VCVTPD2PSZrmk_VCVTPD2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1250
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1251
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 1, false, false, 354, 5,  5, 1, 11, 1}, // #1252
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 1, false, false, 273, 5,  4, 1,  0, 0}, // #1253
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 1, false, false, 134, 6,  8, 1, 11, 1}, // #1254
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1255
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1256
  {DBGFIELD("VGATHERDPSZ128rm_VGATHERQPSZrm_VPGATHERDDZ128rm") 1, false, false, 169, 2,  6, 1,  0, 0}, // #1257
  {DBGFIELD("VGATHERQPSZ128rm_VGATHERQPSZ256rm_VPGATHERQDZ128rm_VPGATHERQDZ256rm") 1, false, false, 169, 2,  6, 1,  0, 0}, // #1258
  {DBGFIELD("VGATHERDPDZ128rm_VGATHERQPDZ128rm_VPGATHERDQZ128rm_VPGATHERQQZ128rm") 1, false, false, 169, 2,  6, 1,  0, 0}, // #1259
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz") 1, false, false, 263, 3,  3, 1,  0, 0}, // #1260
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1261
  {DBGFIELD("VGATHERDPDZ256rm_VGATHERQPDZ256rm_VPGATHERDQZ256rm_VPGATHERQDZrm_VPGATHERQQZ256rm") 1, false, false, 169, 2,  6, 1,  0, 0}, // #1262
  {DBGFIELD("VGATHERDPDZrm_VGATHERQPDZrm_VPGATHERDQZrm_VPGATHERQQZrm") 1, false, false, 169, 2,  6, 1,  0, 0}, // #1263
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm") 1, false, false, 169, 2,  6, 1,  0, 0}, // #1264
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1265
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 1, false, false, 169, 2,  6, 1,  0, 0}, // #1266
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1267
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1268
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1269
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1270
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1271
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1272
  {DBGFIELD("VXORPSZ128rr_VXORPDZ128rr") 1, false, false, 141, 3,  3, 1,  0, 0}, // #1273
  {DBGFIELD("VXORPSZ256rr_VXORPDZ256rr") 2, false, false, 480, 3,  3, 1,  0, 0}, // #1274
  {DBGFIELD("VXORPSZrr_VXORPDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1275
  {DBGFIELD("VPXORDZ128rr_VPXORQZ128rr") 1, false, false, 263, 3,  3, 1,  0, 0}, // #1276
  {DBGFIELD("VPXORDZ256rr_VPXORQZ256rr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1277
  {DBGFIELD("VPXORDZrr_VPXORQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1278
  {DBGFIELD("VPSUBBZ128rr_VPSUBDZ128rr_VPSUBQZ128rr_VPSUBWZ128rr") 1, false, false, 263, 3,  3, 1,  0, 0}, // #1279
  {DBGFIELD("VPSUBBZ256rr_VPSUBDZ256rr_VPSUBQZ256rr_VPSUBWZ256rr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1280
  {DBGFIELD("VPSUBBZrr_VPSUBDZrr_VPSUBQZrr_VPSUBWZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1281
  {DBGFIELD("PdWriteZeroLatency") 1, false, false,  0, 0,  0, 1,  0, 0}, // #1282
  {DBGFIELD("WriteVecALU")        1, false, false, 81, 3,  3, 1,  0, 0}, // #1283
  {DBGFIELD("JWriteZeroLatency")  0, false, false,  0, 0,  0, 0,  0, 0}, // #1284
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1285
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1286
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1287
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1288
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1289
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1290
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1291
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1292
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1293
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1294
  {DBGFIELD("JWriteLOCK_CMPXCHG8B") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1295
  {DBGFIELD("JWriteLOCK_CMPXCHG16B") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1296
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1297
  {DBGFIELD("JWriteLOCK_CMPXCHGrm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1298
  {DBGFIELD("JWriteCMPXCHG8B")    0, false, false,  0, 0,  0, 0,  0, 0}, // #1299
  {DBGFIELD("JWriteCMPXCHG16B")   0, false, false,  0, 0,  0, 0,  0, 0}, // #1300
  {DBGFIELD("JWriteCMPXCHG8rm")   0, false, false,  0, 0,  0, 0,  0, 0}, // #1301
  {DBGFIELD("WriteCMPXCHGRMW")    0, false, false,  0, 0,  0, 0,  0, 0}, // #1302
  {DBGFIELD("JWriteCMPXCHG8rr")   0, false, false,  0, 0,  0, 0,  0, 0}, // #1303
  {DBGFIELD("WriteCMPXCHG")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1304
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1305
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1306
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1307
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1308
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1309
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1310
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1311
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1312
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1313
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1314
  {DBGFIELD("JWriteLOCK_XADDrm_XCHG_Part_JWriteXCHGrm_LdSt_Part_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1315
  {DBGFIELD("JWriteXADDrm_XCHG_Part_JWriteXADDrm_LdSt_Part_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1316
  {DBGFIELD("SBWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1317
  {DBGFIELD("WriteALU")           1, false, false, 79, 2,  1, 1,  0, 0}, // #1318
  {DBGFIELD("HWWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1319
  {DBGFIELD("BWWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1320
  {DBGFIELD("SKLWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1321
  {DBGFIELD("SKXWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1322
  {DBGFIELD("WriteFLogic")        1, false, false, 141, 3,  3, 1,  0, 0}, // #1323
  {DBGFIELD("WriteFLogicY")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1324
  {DBGFIELD("JWriteZeroIdiomYmm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1325
  {DBGFIELD("WriteVecLogicX")     1, false, false, 263, 3,  3, 1,  0, 0}, // #1326
  {DBGFIELD("WriteVecALUX")       1, false, false, 263, 3,  3, 1,  0, 0}, // #1327
  {DBGFIELD("SKLWritePSUB")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1328
  {DBGFIELD("SKXWritePSUB")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1329
  {DBGFIELD("SBWritePCMPGTQ")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1330
  {DBGFIELD("HWWritePCMPGTQ")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1331
  {DBGFIELD("BWWritePCMPGTQ")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1332
  {DBGFIELD("SKLWritePCMPGTQ")    0, false, false,  0, 0,  0, 0,  0, 0}, // #1333
  {DBGFIELD("SKXWritePCMPGTQ")    0, false, false,  0, 0,  0, 0,  0, 0}, // #1334
  {DBGFIELD("SBWriteCMOVA_CMOVBErr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1335
  {DBGFIELD("WriteCMOV")          0, false, false,  0, 0,  0, 0,  0, 0}, // #1336
  {DBGFIELD("HWWriteCMOVA_CMOVBErr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1337
  {DBGFIELD("BWWriteCMOVA_CMOVBErr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1338
  {DBGFIELD("SKLWriteCMOVA_CMOVBErr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1339
  {DBGFIELD("SKXWriteCMOVA_CMOVBErr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1340
  {DBGFIELD("SBWriteCMOVA_CMOVBErm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1341
  {DBGFIELD("WriteCMOVLd")        1, false, false, 165, 4,  6, 1,  0, 0}, // #1342
  {DBGFIELD("HWWriteCMOVA_CMOVBErm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1343
  {DBGFIELD("BWWriteCMOVA_CMOVBErm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1344
  {DBGFIELD("PdWriteCMOVm")       2, false, false, 671, 4,  6, 1,  0, 0}, // #1345
  {DBGFIELD("SKLWriteCMOVA_CMOVBErm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1346
  {DBGFIELD("SKXWriteCMOVA_CMOVBErm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1347
  {DBGFIELD("SBWriteSETA_SETBEr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1348
  {DBGFIELD("WriteSETCC")         0, false, false,  0, 0,  0, 0,  0, 0}, // #1349
  {DBGFIELD("HWWriteSETA_SETBEr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1350
  {DBGFIELD("BWWriteSETA_SETBEr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1351
  {DBGFIELD("SKLWriteSETA_SETBEr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1352
  {DBGFIELD("SKXWriteSETA_SETBEr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1353
  {DBGFIELD("SBWriteSETA_SETBEm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1354
  {DBGFIELD("WriteSETCCStore")    1, false, false, 455, 4,  1, 1,  0, 0}, // #1355
  {DBGFIELD("HWWriteSETA_SETBEm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1356
  {DBGFIELD("BWWriteSETA_SETBEm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1357
  {DBGFIELD("PdWriteSETGEmSETGmSETLEmSETLm") 2, false, false, 79, 2,  1, 1,  0, 0}, // #1358
  {DBGFIELD("SKLWriteSETA_SETBEm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1359
  {DBGFIELD("SKXWriteSETA_SETBEm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1360
  {DBGFIELD("WriteVecLogicY")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1361
  {DBGFIELD("WriteVecALUY")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1362
  {DBGFIELD("HWWriteADC0")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1363
  {DBGFIELD("WriteADC")           0, false, false,  0, 0,  0, 0,  0, 0}, // #1364
  {DBGFIELD("JWriteLOCK_ALURMW")  0, false, false,  0, 0,  0, 0,  0, 0}, // #1365
  {DBGFIELD("WriteALURMW")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1366
  {DBGFIELD("WriteFShuffle256")   0, false, false,  0, 0,  0, 0,  0, 0}, // #1367
  {DBGFIELD("WriteVecLogic")      1, false, false, 81, 3,  3, 1,  0, 0}, // #1368
  {DBGFIELD("JWrite3OpsLEA")      0, false, false,  0, 0,  0, 0,  0, 0}, // #1369
  {DBGFIELD("WriteLEA")           0, false, false,  0, 0,  0, 0,  0, 0}, // #1370
  {DBGFIELD("WriteFLogicZ")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1371
  {DBGFIELD("WriteVecLogicZ")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1372
}; // BdVer2ModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc BroadwellModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  16383, false, false,  0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false, 714, 2,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false, 712, 4,  1, 1,  0, 0}, // #3
  {DBGFIELD("WriteCMPXCHGRMW")    6, false, false, 716, 8, 11, 1,  0, 0}, // #4
  {DBGFIELD("WriteJumpLd")        2, false, false, 724, 6,  5, 1,  0, 0}, // #5
  {DBGFIELD("WriteMove")          1, false, false, 714, 2,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteJump")          1, false, false, 730, 4,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, 714, 2,  2, 1,  0, 0}, // #8
  {DBGFIELD("WriteSHDrri")        1, false, false, 734, 7, 22, 1,  0, 0}, // #9
  {DBGFIELD("WriteFStoreX")       2, false, false, 741, 4,  1, 1,  0, 0}, // #10
  {DBGFIELD("WriteFLoadX")        1, false, false, 745, 3,  6, 1,  0, 0}, // #11
  {DBGFIELD("WriteFStoreY")       2, false, false, 741, 4,  1, 1,  0, 0}, // #12
  {DBGFIELD("WriteFLoadY")        1, false, false, 745, 3,  5, 1,  0, 0}, // #13
  {DBGFIELD("WriteMicrocoded")    1, false, false, 714, 2,  2, 1,  0, 0}, // #14
  {DBGFIELD("WriteFSign")         1, false, false, 748, 8,  1, 1,  0, 0}, // #15
  {DBGFIELD("WriteADC")           1, false, false, 730, 4,  1, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCRMW")        6, false, false, 716, 8, 11, 1,  0, 0}, // #17
  {DBGFIELD("WriteADCLd_ReadAfterLd") 2, false, false, 724, 6,  5, 1, 11, 1}, // #18
  {DBGFIELD("WriteALURMW")        3, false, false, 756, 6,  4, 1,  0, 0}, // #19
  {DBGFIELD("WriteALULd_ReadAfterLd") 2, false, false, 762, 4,  5, 1, 11, 1}, // #20
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #21
  {DBGFIELD("WriteFAdd64X")       1, false, false, 734, 7, 22, 1,  0, 0}, // #22
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #23
  {DBGFIELD("WriteFAddX")         1, false, false, 734, 7, 22, 1,  0, 0}, // #24
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #25
  {DBGFIELD("WriteFAdd64")        1, false, false, 734, 7, 22, 1,  0, 0}, // #26
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #27
  {DBGFIELD("WriteFAdd")          1, false, false, 734, 7, 22, 1,  0, 0}, // #28
  {DBGFIELD("WriteFAddLd")        2, false, false, 766, 9, 11, 1,  0, 0}, // #29
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 2, false, false, 775, 10, 20, 1, 11, 1}, // #30
  {DBGFIELD("WriteAESDecEnc")     1, false, false, 748, 8,  4, 1,  0, 0}, // #31
  {DBGFIELD("WriteAESIMCLd")      3, false, false, 785, 10, 63, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESIMC")        2, false, false, 795, 8, 21, 1,  0, 0}, // #33
  {DBGFIELD("WriteAESKeyGenLd")   11, false, false, 803, 14, 69, 1,  0, 0}, // #34
  {DBGFIELD("WriteAESKeyGen")     11, false, false, 817, 12, 36, 1,  0, 0}, // #35
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 2, false, false, 775, 10,  5, 1, 11, 1}, // #36
  {DBGFIELD("WriteFLogic")        1, false, false, 748, 8,  1, 1,  0, 0}, // #37
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 829, 8,  4, 1, 21, 1}, // #38
  {DBGFIELD("WriteBEXTR")         2, false, false, 837, 6,  3, 1,  0, 0}, // #39
  {DBGFIELD("WriteBEXTRLd")       3, false, false, 829, 8,  4, 1,  0, 0}, // #40
  {DBGFIELD("WriteALULd")         2, false, false, 762, 4,  5, 1,  0, 0}, // #41
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 2, false, false, 770, 5,  5, 1, 11, 1}, // #42
  {DBGFIELD("WriteFBlend")        1, false, false, 713, 3,  1, 1,  0, 0}, // #43
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 3, false, false, 785, 10,  4, 1, 11, 1}, // #44
  {DBGFIELD("WriteFVarBlend")     2, false, false, 795, 8,  3, 1,  0, 0}, // #45
  {DBGFIELD("WriteBLSLd")         2, false, false, 843, 6,  5, 1,  0, 0}, // #46
  {DBGFIELD("WriteBLS")           1, false, false, 712, 4,  1, 1,  0, 0}, // #47
  {DBGFIELD("WriteBSFLd")         2, false, false, 766, 9, 11, 1,  0, 0}, // #48
  {DBGFIELD("WriteBSF")           1, false, false, 734, 7, 22, 1,  0, 0}, // #49
  {DBGFIELD("WriteBSRLd")         2, false, false, 766, 9, 11, 1,  0, 0}, // #50
  {DBGFIELD("WriteBSR")           1, false, false, 734, 7, 22, 1,  0, 0}, // #51
  {DBGFIELD("WriteBSWAP32")       1, false, false, 712, 4,  1, 1,  0, 0}, // #52
  {DBGFIELD("WriteBSWAP64")       2, false, false, 837, 6,  3, 1,  0, 0}, // #53
  {DBGFIELD("WriteBitTestImmLd")  2, false, false, 724, 6,  5, 1,  0, 0}, // #54
  {DBGFIELD("WriteBitTestRegLd")  2, false, false, 762, 4,  5, 1,  0, 0}, // #55
  {DBGFIELD("WriteBitTest")       1, false, false, 730, 4,  1, 1,  0, 0}, // #56
  {DBGFIELD("WriteBitTestSetImmRMW") 4, false, false, 849, 8,  5, 1,  0, 0}, // #57
  {DBGFIELD("WriteBitTestSetRegRMW") 3, false, false, 756, 6,  5, 1,  0, 0}, // #58
  {DBGFIELD("WriteBitTestSet")    1, false, false, 730, 4,  1, 1,  0, 0}, // #59
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 843, 6,  5, 1, 21, 1}, // #60
  {DBGFIELD("WriteBZHI")          1, false, false, 712, 4,  1, 1,  0, 0}, // #61
  {DBGFIELD("WriteLoad")          1, false, false, 745, 3,  6, 1,  0, 0}, // #62
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 2, false, false, 724, 6,  5, 1, 11, 1}, // #63
  {DBGFIELD("WriteCMOV")          1, false, false, 730, 4,  1, 1,  0, 0}, // #64
  {DBGFIELD("WriteFCMOV")         1, false, false, 734, 7, 22, 1,  0, 0}, // #65
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 762, 4,  5, 1, 21, 1}, // #66
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #67
  {DBGFIELD("WriteFCmp64X")       1, false, false, 734, 7, 22, 1,  0, 0}, // #68
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #69
  {DBGFIELD("WriteFCmpX")         1, false, false, 734, 7, 22, 1,  0, 0}, // #70
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #71
  {DBGFIELD("WriteFCmp64")        1, false, false, 734, 7, 22, 1,  0, 0}, // #72
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #73
  {DBGFIELD("WriteFCmp")          1, false, false, 734, 7, 22, 1,  0, 0}, // #74
  {DBGFIELD("WriteCMPXCHG")       5, false, false, 857, 4,  6, 1,  0, 0}, // #75
  {DBGFIELD("WriteFComLd_ReadAfterVecLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #76
  {DBGFIELD("WriteFCom")          1, false, false, 734, 7, 22, 1,  0, 0}, // #77
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #78
  {DBGFIELD("WriteCRC32")         1, false, false, 734, 7, 22, 1,  0, 0}, // #79
  {DBGFIELD("WriteNop")           1, false, false,  0, 0,  1, 1,  0, 0}, // #80
  {DBGFIELD("WriteCvtI2PDLd")     2, false, false, 766, 9,  8, 1,  0, 0}, // #81
  {DBGFIELD("WriteCvtI2PD")       1, false, false, 734, 7, 23, 1,  0, 0}, // #82
  {DBGFIELD("WriteCvtI2PSLd")     2, false, false, 766, 9,  8, 1,  0, 0}, // #83
  {DBGFIELD("WriteCvtI2PS")       1, false, false, 734, 7, 23, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtPD2ILd")     2, false, false, 766, 9, 11, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtPD2I")       1, false, false, 734, 7, 22, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtPD2PSLd")    2, false, false, 766, 9, 11, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtPD2PS")      1, false, false, 734, 7, 22, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtPS2ILd")     2, false, false, 766, 9, 11, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtPS2I")       1, false, false, 734, 7, 22, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPS2PDLd")    2, false, false, 766, 9, 11, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPS2PD")      1, false, false, 734, 7, 22, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtSD2ILd")     2, false, false, 766, 9, 11, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtSD2I")       1, false, false, 734, 7, 22, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtSD2SSLd")    2, false, false, 766, 9, 11, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #96
  {DBGFIELD("WriteCvtSD2SS")      1, false, false, 734, 7, 22, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, 766, 9,  8, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 2, false, false, 766, 9,  8, 1, 11, 1}, // #99
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 1, false, false, 734, 7, 23, 1,  0, 1}, // #100
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 1, false, false, 734, 7, 23, 1,  3, 1}, // #101
  {DBGFIELD("WriteCvtI2SSLd")     2, false, false, 766, 9,  8, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 2, false, false, 766, 9,  8, 1, 11, 1}, // #103
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 1, false, false, 734, 7, 23, 1,  0, 1}, // #104
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 1, false, false, 734, 7, 23, 1,  3, 1}, // #105
  {DBGFIELD("WriteCvtSS2SDLd")    2, false, false, 766, 9, 11, 1,  0, 0}, // #106
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #107
  {DBGFIELD("WriteCvtSS2SD")      1, false, false, 734, 7, 22, 1,  0, 0}, // #108
  {DBGFIELD("WriteCvtSS2ILd")     2, false, false, 766, 9, 11, 1,  0, 0}, // #109
  {DBGFIELD("WriteCvtSS2I")       1, false, false, 734, 7, 22, 1,  0, 0}, // #110
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 1, false, false, 734, 7, 22, 1,  0, 0}, // #111
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 1, false, false, 734, 7, 22, 1,  0, 0}, // #112
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 861, 16, 17, 1, 22, 2}, // #113
  {DBGFIELD("WriteDiv16")         32, false, false, 877, 15, 70, 1,  0, 0}, // #114
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 861, 16, 17, 1, 22, 2}, // #115
  {DBGFIELD("WriteDiv32")         32, false, false, 877, 15, 70, 1,  0, 0}, // #116
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 861, 16, 17, 1, 22, 2}, // #117
  {DBGFIELD("WriteDiv64")         32, false, false, 877, 15, 70, 1,  0, 0}, // #118
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 861, 16, 17, 1, 22, 2}, // #119
  {DBGFIELD("WriteDiv8")          1, false, false, 892, 10, 34, 1,  0, 0}, // #120
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 2, false, false, 902, 12, 63, 1, 11, 1}, // #121
  {DBGFIELD("WriteFDiv64X")       1, false, false, 914, 10, 21, 1,  0, 0}, // #122
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 2, false, false, 924, 12,  7, 1, 11, 1}, // #123
  {DBGFIELD("WriteFDivX")         1, false, false, 936, 10,  9, 1,  0, 0}, // #124
  {DBGFIELD("WriteFDivLd")        2, false, false, 924, 12,  7, 1,  0, 0}, // #125
  {DBGFIELD("WriteFDiv")          1, false, false, 946, 10,  9, 1,  0, 0}, // #126
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 2, false, false, 902, 12, 63, 1, 11, 1}, // #127
  {DBGFIELD("WriteFDiv64")        1, false, false, 956, 10, 21, 1,  0, 0}, // #128
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 2, false, false, 924, 12,  7, 1, 11, 1}, // #129
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 4, false, false, 966, 16, 21, 1, 11, 1}, // #130
  {DBGFIELD("WriteDPPD")          3, false, false, 982, 14,  8, 1,  0, 0}, // #131
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 5, false, false, 996, 16, 63, 1, 11, 1}, // #132
  {DBGFIELD("WriteDPPS")          4, false, false, 1012, 14, 21, 1,  0, 0}, // #133
  {DBGFIELD("WriteStore")         1, false, false, 741, 4,  1, 1,  0, 0}, // #134
  {DBGFIELD("WriteVecExtractSt")  3, false, false, 1026, 11,  3, 1,  0, 0}, // #135
  {DBGFIELD("WriteVecExtract")    2, false, false, 1037, 12,  3, 1,  0, 0}, // #136
  {DBGFIELD("WriteVecALUX")       1, false, false, 712, 4,  1, 1,  0, 0}, // #137
  {DBGFIELD("WriteFComLd")        2, false, false, 766, 9, 11, 1,  0, 0}, // #138
  {DBGFIELD("WriteEMMS")          31, false, false, 1049, 5, 71, 1,  0, 0}, // #139
  {DBGFIELD("WriteFLDC")          2, false, false, 1054, 4,  1, 1,  0, 0}, // #140
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 2, false, false, 843, 6,  5, 1, 11, 1}, // #141
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 4, false, false, 1058, 13, 19, 1, 11, 1}, // #142
  {DBGFIELD("WriteFHAdd")         3, false, false, 1071, 11,  6, 1,  0, 0}, // #143
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 861, 16, 72, 1, 22, 2}, // #144
  {DBGFIELD("WriteIDiv16")        1, false, false, 892, 10, 34, 1,  0, 0}, // #145
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 861, 16, 72, 1, 22, 2}, // #146
  {DBGFIELD("WriteIDiv32")        1, false, false, 892, 10, 34, 1,  0, 0}, // #147
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 861, 16, 72, 1, 22, 2}, // #148
  {DBGFIELD("WriteIDiv64")        1, false, false, 892, 10, 34, 1,  0, 0}, // #149
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 861, 16, 72, 1, 22, 2}, // #150
  {DBGFIELD("WriteIDiv8")         1, false, false, 892, 10, 34, 1,  0, 0}, // #151
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, 1082, 11,  8, 1, 22, 2}, // #152
  {DBGFIELD("WriteIMul16")        4, false, false, 1093, 9, 23, 1,  0, 0}, // #153
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #154
  {DBGFIELD("WriteIMul16ImmLd")   3, false, false, 1102, 9, 11, 1,  0, 0}, // #155
  {DBGFIELD("WriteIMul16Reg")     1, false, false, 734, 7, 22, 1,  0, 0}, // #156
  {DBGFIELD("WriteIMul16Imm")     2, false, false, 1111, 7, 23, 1,  0, 0}, // #157
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, 1118, 11,  8, 1, 22, 2}, // #158
  {DBGFIELD("WriteIMul32")        3, false, false, 1129, 9, 23, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #160
  {DBGFIELD("WriteIMul32ImmLd")   2, false, false, 766, 9, 11, 1,  0, 0}, // #161
  {DBGFIELD("WriteIMul32Reg")     1, false, false, 734, 7, 22, 1,  0, 0}, // #162
  {DBGFIELD("WriteIMul32Imm")     1, false, false, 734, 7, 22, 1,  0, 0}, // #163
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, 1138, 13,  8, 1, 22, 2}, // #164
  {DBGFIELD("WriteIMul64")        2, false, false, 1151, 11, 23, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #166
  {DBGFIELD("WriteIMul64ImmLd")   2, false, false, 766, 9, 11, 1,  0, 0}, // #167
  {DBGFIELD("WriteIMul64Reg")     1, false, false, 734, 7, 22, 1,  0, 0}, // #168
  {DBGFIELD("WriteIMul64Imm")     1, false, false, 734, 7, 22, 1,  0, 0}, // #169
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 766, 9, 11, 1, 22, 2}, // #170
  {DBGFIELD("WriteIMul8")         1, false, false, 734, 7, 22, 1,  0, 0}, // #171
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 2, false, false, 775, 10,  5, 1, 11, 1}, // #172
  {DBGFIELD("WriteFShuffle")      1, false, false, 748, 8,  1, 1,  0, 0}, // #173
  {DBGFIELD("WriteVecLogicX")     1, false, false, 713, 3,  1, 1,  0, 0}, // #174
  {DBGFIELD("WriteShuffle")       1, false, false, 748, 8,  1, 1,  0, 0}, // #175
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, 730, 4,  1, 1,  0, 0}, // #176
  {DBGFIELD("WriteVecLoadX")      1, false, false, 745, 3,  6, 1,  0, 0}, // #177
  {DBGFIELD("WriteLDMXCSR")       3, false, false, 1162, 11,  4, 1,  0, 0}, // #178
  {DBGFIELD("WriteFLD0")          1, false, false, 1173, 4,  1, 1,  0, 0}, // #179
  {DBGFIELD("WriteFLD1")          2, false, false, 1054, 4,  1, 1,  0, 0}, // #180
  {DBGFIELD("WriteLEA")           1, false, false, 712, 4,  1, 1,  0, 0}, // #181
  {DBGFIELD("WriteFence")         1, false, false, 1177, 5,  1, 1,  0, 0}, // #182
  {DBGFIELD("WriteLZCNTLd")       2, false, false, 766, 9, 11, 1,  0, 0}, // #183
  {DBGFIELD("WriteLZCNT")         1, false, false, 734, 7, 22, 1,  0, 0}, // #184
  {DBGFIELD("WriteVecStoreX")     2, false, false, 741, 4,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteVecStore")      2, false, false, 741, 4,  1, 1,  0, 0}, // #186
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, 893, 9,  1, 1,  0, 0}, // #187
  {DBGFIELD("WriteVecLoad")       1, false, false, 745, 3,  6, 1,  0, 0}, // #188
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, 748, 8,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteVecMoveX")      1, false, false, 713, 3,  1, 1,  0, 0}, // #190
  {DBGFIELD("WriteVecStoreNT")    2, false, false, 741, 4,  1, 1,  0, 0}, // #191
  {DBGFIELD("WriteVecMove")       1, false, false, 713, 3,  1, 1,  0, 0}, // #192
  {DBGFIELD("WriteVecALULd")      2, false, false, 843, 6,  5, 1,  0, 0}, // #193
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 2, false, false, 775, 10,  5, 1, 11, 1}, // #194
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 2, false, false, 843, 6,  5, 1, 11, 1}, // #195
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 2, false, false, 770, 5,  5, 1, 11, 1}, // #196
  {DBGFIELD("WriteVecLogic")      1, false, false, 713, 3,  1, 1,  0, 0}, // #197
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, 1182, 10, 11, 1, 11, 1}, // #198
  {DBGFIELD("WritePHAdd")         3, false, false, 1192, 8, 22, 1,  0, 0}, // #199
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 2, false, false, 775, 10,  5, 1, 11, 1}, // #200
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 2, false, false, 795, 8,  3, 1,  3, 1}, // #201
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 2, false, false, 903, 11, 19, 1, 11, 1}, // #202
  {DBGFIELD("WriteVecIMul")       1, false, false, 893, 9,  6, 1,  0, 0}, // #203
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, 893, 9,  1, 1,  0, 0}, // #204
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 2, false, false, 903, 11, 19, 1, 11, 1}, // #205
  {DBGFIELD("WritePSADBW")        1, false, false, 893, 9,  6, 1,  0, 0}, // #206
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 2, false, false, 775, 10,  5, 1, 11, 1}, // #207
  {DBGFIELD("WriteVarShuffle")    1, false, false, 748, 8,  1, 1,  0, 0}, // #208
  {DBGFIELD("WriteShuffleLd")     2, false, false, 775, 10,  5, 1,  0, 0}, // #209
  {DBGFIELD("WriteVecShiftImm")   1, false, false, 893, 9,  1, 1,  0, 0}, // #210
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 2, false, false, 903, 11,  5, 1, 11, 1}, // #211
  {DBGFIELD("WriteVecShift")      1, false, false, 893, 9,  1, 1,  0, 0}, // #212
  {DBGFIELD("WriteFMoveX")        1, false, false, 748, 8,  1, 1,  0, 0}, // #213
  {DBGFIELD("WriteFShuffleLd")    2, false, false, 775, 10,  5, 1,  0, 0}, // #214
  {DBGFIELD("WriteFStore")        2, false, false, 741, 4,  1, 1,  0, 0}, // #215
  {DBGFIELD("WriteFMOVMSK")       1, false, false, 893, 9, 22, 1,  0, 0}, // #216
  {DBGFIELD("WriteVecLoadNT")     1, false, false, 745, 3,  6, 1,  0, 0}, // #217
  {DBGFIELD("WriteStoreNT")       2, false, false, 741, 4,  1, 1,  0, 0}, // #218
  {DBGFIELD("WriteFStoreNTX")     2, false, false, 741, 4,  1, 1,  0, 0}, // #219
  {DBGFIELD("WriteFStoreNT")      2, false, false, 741, 4,  1, 1,  0, 0}, // #220
  {DBGFIELD("WriteFLoad")         1, false, false, 745, 3,  6, 1,  0, 0}, // #221
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 4, false, false, 1200, 14, 20, 1, 11, 1}, // #222
  {DBGFIELD("WriteMPSAD")         3, false, false, 1214, 12,  4, 1,  0, 0}, // #223
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 2, false, false, 1226, 6, 11, 1, 11, 1}, // #224
  {DBGFIELD("WriteFMul64X")       1, false, false, 1173, 4, 22, 1,  0, 0}, // #225
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 2, false, false, 1226, 6, 11, 1, 11, 1}, // #226
  {DBGFIELD("WriteFMulX")         1, false, false, 1173, 4, 22, 1,  0, 0}, // #227
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 2, false, false, 1226, 6, 11, 1, 11, 1}, // #228
  {DBGFIELD("WriteFMul64")        1, false, false, 1173, 4, 22, 1,  0, 0}, // #229
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 2, false, false, 1226, 6, 11, 1, 11, 1}, // #230
  {DBGFIELD("WriteFMul")          1, false, false, 1173, 4, 22, 1,  0, 0}, // #231
  {DBGFIELD("WriteIMul32Ld_WriteIMulH") 5, false, false, 1118, 11, 73, 2,  0, 0}, // #232
  {DBGFIELD("WriteIMul32_WriteIMulH") 4, false, false, 1129, 9, 75, 2,  0, 0}, // #233
  {DBGFIELD("WriteIMul64Ld_WriteIMulH") 4, false, false, 1138, 13, 73, 2,  0, 0}, // #234
  {DBGFIELD("WriteIMul64_WriteIMulH") 3, false, false, 1151, 11, 75, 2,  0, 0}, // #235
  {DBGFIELD("WriteFMulLd")        2, false, false, 1226, 6, 11, 1,  0, 0}, // #236
  {DBGFIELD("WriteVecALUXLd")     2, false, false, 843, 6,  5, 1,  0, 0}, // #237
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 2, false, false, 775, 10,  5, 1, 11, 1}, // #238
  {DBGFIELD("WriteShuffleX")      1, false, false, 748, 8,  1, 1,  0, 0}, // #239
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 2, false, false, 770, 5,  5, 1, 11, 1}, // #240
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 3, false, false, 785, 10,  4, 1, 11, 1}, // #241
  {DBGFIELD("WriteVarBlend")      2, false, false, 795, 8,  3, 1,  0, 0}, // #242
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 2, false, false, 775, 10,  5, 1, 11, 1}, // #243
  {DBGFIELD("WriteBlend")         1, false, false, 748, 8,  1, 1,  0, 0}, // #244
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 2, false, false, 903, 11, 19, 1, 11, 1}, // #245
  {DBGFIELD("WriteCLMul")         1, false, false, 893, 9,  6, 1,  0, 0}, // #246
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 9, false, false, 1232, 14, 33, 1, 11, 1}, // #247
  {DBGFIELD("WritePCmpEStrI")     8, false, false, 1246, 12, 29, 1,  0, 0}, // #248
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 10, false, false, 1258, 14, 77, 1, 11, 1}, // #249
  {DBGFIELD("WritePCmpEStrM")     9, false, false, 1272, 12, 63, 1,  0, 0}, // #250
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 4, false, false, 1284, 11,  7, 1, 11, 1}, // #251
  {DBGFIELD("WritePCmpIStrI")     3, false, false, 1295, 9,  9, 1,  0, 0}, // #252
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 4, false, false, 1284, 11,  7, 1, 11, 1}, // #253
  {DBGFIELD("WritePCmpIStrM")     3, false, false, 1295, 9,  9, 1,  0, 0}, // #254
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #255
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 4, false, false, 1182, 10, 11, 1, 11, 1}, // #256
  {DBGFIELD("WritePHAddX")        3, false, false, 1192, 8, 22, 1,  0, 0}, // #257
  {DBGFIELD("WritePHMINPOSLd")    2, false, false, 903, 11, 19, 1,  0, 0}, // #258
  {DBGFIELD("WritePHMINPOS")      1, false, false, 893, 9,  6, 1,  0, 0}, // #259
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 2, false, false, 766, 9,  8, 1, 11, 1}, // #260
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 2, false, false, 903, 11, 19, 1, 11, 1}, // #261
  {DBGFIELD("WriteVecIMulX")      1, false, false, 893, 9,  6, 1,  0, 0}, // #262
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, 893, 9, 22, 1,  0, 0}, // #263
  {DBGFIELD("WriteShuffleXLd")    2, false, false, 775, 10,  5, 1,  0, 0}, // #264
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 3, false, false, 1304, 11, 10, 1, 11, 1}, // #265
  {DBGFIELD("WritePMULLD")        2, false, false, 1315, 9, 19, 1,  0, 0}, // #266
  {DBGFIELD("WriteCopy")          2, false, false, 1324, 5,  5, 1,  0, 0}, // #267
  {DBGFIELD("WritePOPCNTLd")      2, false, false, 766, 9, 11, 1,  0, 0}, // #268
  {DBGFIELD("WritePOPCNT")        1, false, false, 734, 7, 22, 1,  0, 0}, // #269
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 2, false, false, 903, 11, 19, 1, 11, 1}, // #270
  {DBGFIELD("WritePSADBWX")       1, false, false, 893, 9,  6, 1,  0, 0}, // #271
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 2, false, false, 775, 10,  5, 1, 11, 1}, // #272
  {DBGFIELD("WriteVarShuffleX")   1, false, false, 748, 8,  1, 1,  0, 0}, // #273
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, 893, 9,  1, 1,  0, 0}, // #274
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 3, false, false, 1329, 14,  4, 1, 11, 1}, // #275
  {DBGFIELD("WriteVecShiftX")     2, false, false, 1037, 12,  3, 1,  0, 0}, // #276
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 3, false, false, 1329, 14,  4, 1, 11, 1}, // #277
  {DBGFIELD("WriteVecTest")       2, false, false, 1037, 12,  3, 1,  0, 0}, // #278
  {DBGFIELD("WriteRotateLd_WriteRMW") 3, false, false, 849, 8, 78, 2,  0, 0}, // #279
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 5, false, false, 716, 8, 80, 2,  0, 0}, // #280
  {DBGFIELD("WriteRotate")        1, false, false, 730, 4,  1, 1,  0, 0}, // #281
  {DBGFIELD("WriteRotateCL")      3, false, false, 1343, 4, 22, 1,  0, 0}, // #282
  {DBGFIELD("WriteFRcpXLd")       2, false, false, 903, 11, 19, 1,  0, 0}, // #283
  {DBGFIELD("WriteFRcpX")         1, false, false, 893, 9,  6, 1,  0, 0}, // #284
  {DBGFIELD("WriteFRcpLd")        2, false, false, 903, 11, 19, 1,  0, 0}, // #285
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 2, false, false, 903, 11, 19, 1, 11, 1}, // #286
  {DBGFIELD("WriteFRcp")          1, false, false, 893, 9,  6, 1,  0, 0}, // #287
  {DBGFIELD("WriteRMW")           1, false, false, 741, 4,  1, 1,  0, 0}, // #288
  {DBGFIELD("WriteShiftLd")       2, false, false, 724, 6,  5, 1,  0, 0}, // #289
  {DBGFIELD("WriteShift")         1, false, false, 730, 4,  1, 1,  0, 0}, // #290
  {DBGFIELD("WriteFRndLd")        3, false, false, 1347, 9,  9, 1,  0, 0}, // #291
  {DBGFIELD("WriteFRnd")          1, false, false, 745, 3,  5, 1,  0, 0}, // #292
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 3, false, false, 1347, 9,  9, 1, 11, 1}, // #293
  {DBGFIELD("WriteFRsqrtXLd")     2, false, false, 903, 11, 19, 1,  0, 0}, // #294
  {DBGFIELD("WriteFRsqrtX")       1, false, false, 893, 9,  6, 1,  0, 0}, // #295
  {DBGFIELD("WriteFRsqrtLd")      2, false, false, 903, 11, 19, 1,  0, 0}, // #296
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 2, false, false, 903, 11, 19, 1, 11, 1}, // #297
  {DBGFIELD("WriteFRsqrt")        1, false, false, 893, 9,  6, 1,  0, 0}, // #298
  {DBGFIELD("WriteShiftLd_WriteRMW") 3, false, false, 849, 8, 78, 2,  0, 0}, // #299
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 5, false, false, 716, 8, 80, 2,  0, 0}, // #300
  {DBGFIELD("WriteShiftCL")       3, false, false, 1343, 4, 22, 1,  0, 0}, // #301
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 724, 6,  5, 1, 21, 1}, // #302
  {DBGFIELD("WriteSETCCStore")    3, false, false, 1356, 7,  3, 1,  0, 0}, // #303
  {DBGFIELD("WriteSETCC")         1, false, false, 730, 4,  1, 1,  0, 0}, // #304
  {DBGFIELD("WriteSHDmrcl")       6, false, false, 1363, 11,  9, 1,  0, 0}, // #305
  {DBGFIELD("WriteSHDmri")        4, false, false, 1374, 9,  8, 1,  0, 0}, // #306
  {DBGFIELD("WriteSHDrrcl")       4, false, false, 1093, 9,  5, 1,  0, 0}, // #307
  {DBGFIELD("WriteFSqrt64XLd")    2, false, false, 1383, 12, 31, 1,  0, 0}, // #308
  {DBGFIELD("WriteFSqrt64X")      1, false, false, 1395, 10,  7, 1,  0, 0}, // #309
  {DBGFIELD("WriteFSqrtXLd")      2, false, false, 1405, 12,  7, 1,  0, 0}, // #310
  {DBGFIELD("WriteFSqrtX")        1, false, false, 1417, 10,  9, 1,  0, 0}, // #311
  {DBGFIELD("WriteFSqrt64Ld")     2, false, false, 1383, 12, 31, 1,  0, 0}, // #312
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 2, false, false, 1383, 12, 31, 1, 11, 1}, // #313
  {DBGFIELD("WriteFSqrt64")       1, false, false, 914, 10,  7, 1,  0, 0}, // #314
  {DBGFIELD("WriteFSqrtLd")       2, false, false, 1405, 12,  7, 1,  0, 0}, // #315
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 2, false, false, 1405, 12,  7, 1, 11, 1}, // #316
  {DBGFIELD("WriteFSqrt")         1, false, false, 956, 10,  9, 1,  0, 0}, // #317
  {DBGFIELD("WriteFSqrt80")       1, false, false, 1427, 10, 33, 1,  0, 0}, // #318
  {DBGFIELD("WriteSTMXCSR")       3, false, false, 1026, 11,  3, 1,  0, 0}, // #319
  {DBGFIELD("WriteTZCNTLd")       2, false, false, 766, 9, 11, 1,  0, 0}, // #320
  {DBGFIELD("WriteTZCNT")         1, false, false, 734, 7, 22, 1,  0, 0}, // #321
  {DBGFIELD("WriteFMAZLd")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #322
  {DBGFIELD("WriteFMALd")         2, false, false, 1226, 6, 19, 1,  0, 0}, // #323
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 2, false, false, 766, 9,  8, 1, 24, 1}, // #324
  {DBGFIELD("WriteFAdd64Y")       1, false, false, 734, 7, 22, 1,  0, 0}, // #325
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #326
  {DBGFIELD("WriteFAdd64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #327
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 2, false, false, 766, 9,  8, 1, 24, 1}, // #328
  {DBGFIELD("WriteFAddY")         1, false, false, 734, 7, 22, 1,  0, 0}, // #329
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #330
  {DBGFIELD("WriteFAddZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #331
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 2, false, false, 775, 10,  4, 1, 24, 1}, // #332
  {DBGFIELD("WriteShuffleY")      1, false, false, 748, 8,  1, 1,  0, 0}, // #333
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #334
  {DBGFIELD("WriteShuffleZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #335
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 2, false, false, 775, 10,  4, 1, 24, 1}, // #336
  {DBGFIELD("WriteFLogicY")       1, false, false, 748, 8,  1, 1,  0, 0}, // #337
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("WriteFLogicZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #339
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 3, false, false, 785, 10, 11, 1, 24, 1}, // #340
  {DBGFIELD("WriteFVarBlendY")    2, false, false, 795, 8,  3, 1,  0, 0}, // #341
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD("WriteFVarBlendZ")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #343
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 2, false, false, 770, 5,  4, 1, 24, 1}, // #344
  {DBGFIELD("WriteFBlendY")       1, false, false, 713, 3,  1, 1,  0, 0}, // #345
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 3, false, false, 785, 10, 11, 1, 25, 2}, // #346
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, 785, 10,  4, 1, 17, 2}, // #347
  {DBGFIELD("WriteShuffle256Ld")  2, false, false, 775, 10,  8, 1,  0, 0}, // #348
  {DBGFIELD("WriteShuffle256")    1, false, false, 748, 8, 22, 1,  0, 0}, // #349
  {DBGFIELD("WriteShuffleYLd")    2, false, false, 775, 10,  4, 1,  0, 0}, // #350
  {DBGFIELD("WriteFShuffle256")   1, false, false, 748, 8, 22, 1,  0, 0}, // #351
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, 775, 10,  8, 1,  0, 0}, // #352
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 2, false, false, 766, 9,  8, 1, 24, 1}, // #353
  {DBGFIELD("WriteFCmp64Y")       1, false, false, 734, 7, 22, 1,  0, 0}, // #354
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 2, false, false, 766, 9,  8, 1, 24, 1}, // #355
  {DBGFIELD("WriteFCmpY")         1, false, false, 734, 7, 22, 1,  0, 0}, // #356
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #357
  {DBGFIELD("WriteFCmpZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #358
  {DBGFIELD("WriteVarShuffle256Ld") 2, false, false, 775, 10,  8, 1,  0, 0}, // #359
  {DBGFIELD("WriteVarShuffle256") 1, false, false, 748, 8, 22, 1,  0, 0}, // #360
  {DBGFIELD("WriteCvtI2PDYLd")    2, false, false, 766, 9,  8, 1,  0, 0}, // #361
  {DBGFIELD("WriteCvtI2PDY")      1, false, false, 734, 7, 23, 1,  0, 0}, // #362
  {DBGFIELD("WriteCvtI2PDZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #363
  {DBGFIELD("WriteCvtI2PDZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #364
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, 766, 9,  8, 1,  0, 0}, // #365
  {DBGFIELD("WriteCvtI2PSY")      1, false, false, 734, 7, 23, 1,  0, 0}, // #366
  {DBGFIELD("WriteCvtI2PSZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #367
  {DBGFIELD("WriteCvtI2PSZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #368
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #369
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 2, false, false, 766, 9, 11, 1, 24, 1}, // #370
  {DBGFIELD("WriteCvtPD2PSY")     1, false, false, 734, 7, 22, 1,  0, 0}, // #371
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #372
  {DBGFIELD("WriteCvtPD2PSZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #373
  {DBGFIELD("WriteCvtPD2PSYLd")   2, false, false, 766, 9, 11, 1,  0, 0}, // #374
  {DBGFIELD("WriteCvtPD2PSZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("WriteCvtPD2IYLd")    2, false, false, 766, 9, 11, 1,  0, 0}, // #376
  {DBGFIELD("WriteCvtPD2IY")      1, false, false, 734, 7, 22, 1,  0, 0}, // #377
  {DBGFIELD("WriteCvtPD2IZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #378
  {DBGFIELD("WriteCvtPD2IZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteCvtPH2PSYLd")   2, false, false, 903, 11,  5, 1,  0, 0}, // #380
  {DBGFIELD("WriteCvtPH2PSY")     2, false, false, 1037, 12,  3, 1,  0, 0}, // #381
  {DBGFIELD("WriteCvtPH2PSLd")    2, false, false, 903, 11,  5, 1,  0, 0}, // #382
  {DBGFIELD("WriteCvtPH2PS")      2, false, false, 1037, 12,  3, 1,  0, 0}, // #383
  {DBGFIELD("WriteCvtPH2PSZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #384
  {DBGFIELD("WriteCvtPH2PSZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #385
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, 766, 9, 11, 1,  0, 0}, // #386
  {DBGFIELD("WriteCvtPS2IY")      1, false, false, 734, 7, 22, 1,  0, 0}, // #387
  {DBGFIELD("WriteCvtPS2IZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #388
  {DBGFIELD("WriteCvtPS2IZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #389
  {DBGFIELD("WriteCvtPS2PDYLd")   2, false, false, 766, 9, 11, 1,  0, 0}, // #390
  {DBGFIELD("WriteCvtPS2PDY")     1, false, false, 734, 7, 22, 1,  0, 0}, // #391
  {DBGFIELD("WriteCvtPS2PDZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #392
  {DBGFIELD("WriteCvtPS2PDZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2PHYSt")   3, false, false, 1437, 10,  4, 1,  0, 0}, // #394
  {DBGFIELD("WriteCvtPS2PHY")     2, false, false, 1151, 11,  5, 1,  0, 0}, // #395
  {DBGFIELD("WriteCvtPS2PHSt")    3, false, false, 1437, 10,  6, 1,  0, 0}, // #396
  {DBGFIELD("WriteCvtPS2PH")      2, false, false, 1151, 11, 23, 1,  0, 0}, // #397
  {DBGFIELD("WriteCvtPS2PHZSt")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #398
  {DBGFIELD("WriteCvtPS2PHZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #400
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #401
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 2, false, false, 903, 11,  9, 1, 24, 1}, // #402
  {DBGFIELD("WritePSADBWY")       1, false, false, 893, 9,  6, 1,  0, 0}, // #403
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #404
  {DBGFIELD("WritePSADBWZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 4, false, false, 1447, 12, 36, 1, 24, 1}, // #406
  {DBGFIELD("WriteFDiv64Y")       3, false, false, 1459, 10, 33, 1,  0, 0}, // #407
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #408
  {DBGFIELD("WriteFDiv64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #409
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 4, false, false, 1469, 12, 33, 1, 24, 1}, // #410
  {DBGFIELD("WriteFDivY")         3, false, false, 1481, 10, 28, 1,  0, 0}, // #411
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #412
  {DBGFIELD("WriteFDivZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #413
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 2, false, false, 1226, 6, 19, 1, 11, 1}, // #414
  {DBGFIELD("WriteFMAX")          1, false, false, 1173, 4,  6, 1,  0, 0}, // #415
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 2, false, false, 1226, 6,  9, 1, 24, 1}, // #416
  {DBGFIELD("WriteFMAY")          1, false, false, 1173, 4,  6, 1,  0, 0}, // #417
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #418
  {DBGFIELD("WriteFMAZ")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #419
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 5, false, false, 996, 16, 30, 1, 24, 1}, // #420
  {DBGFIELD("WriteDPPSY")         4, false, false, 1012, 14, 21, 1,  0, 0}, // #421
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, 775, 10,  8, 1, 24, 1}, // #422
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, 1226, 6,  9, 1, 27, 2}, // #423
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, 1226, 6, 19, 1, 19, 2}, // #424
  {DBGFIELD("WriteFMALd_ReadAfterVecLd") 2, false, false, 1226, 6, 19, 1, 11, 1}, // #425
  {DBGFIELD("WriteFMA")           1, false, false, 1173, 4,  6, 1,  0, 0}, // #426
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 2, false, false, 1226, 6, 19, 1, 19, 2}, // #427
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, 1226, 6,  9, 1, 25, 2}, // #428
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, 1226, 6, 19, 1, 17, 2}, // #429
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 2, false, false, 1226, 6, 19, 1, 17, 2}, // #430
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 3, false, false, 1347, 9, 20, 1, 24, 1}, // #431
  {DBGFIELD("WriteFRndY")         1, false, false, 745, 3,  5, 1,  0, 0}, // #432
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #433
  {DBGFIELD("WriteFRndZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #434
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 2, false, false, 903, 11,  9, 1, 24, 1}, // #435
  {DBGFIELD("WriteVecIMulY")      1, false, false, 893, 9,  6, 1,  0, 0}, // #436
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #437
  {DBGFIELD("WriteVecIMulZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #438
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 2, false, false, 843, 6,  4, 1, 24, 1}, // #439
  {DBGFIELD("WriteVecALUY")       1, false, false, 712, 4,  1, 1,  0, 0}, // #440
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteVecALUZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 4, false, false, 1058, 13,  9, 1, 24, 1}, // #443
  {DBGFIELD("WriteFHAddY")        3, false, false, 1071, 11,  6, 1,  0, 0}, // #444
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 2, false, false, 775, 10,  8, 1, 24, 1}, // #445
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 2, false, false, 775, 10,  8, 1, 24, 1}, // #446
  {DBGFIELD("WriteVecLoadY")      1, false, false, 745, 3,  5, 1,  0, 0}, // #447
  {DBGFIELD("WriteFMaskedStore64Y") 4, false, false, 1491, 12,  6, 1,  0, 0}, // #448
  {DBGFIELD("WriteFMaskedLoadY")  3, false, false, 785, 10, 11, 1,  0, 0}, // #449
  {DBGFIELD("WriteFMaskedStore64") 4, false, false, 1491, 12,  6, 1,  0, 0}, // #450
  {DBGFIELD("WriteFMaskedLoad")   3, false, false, 785, 10,  4, 1,  0, 0}, // #451
  {DBGFIELD("WriteFMaskedStore32Y") 4, false, false, 1491, 12,  6, 1,  0, 0}, // #452
  {DBGFIELD("WriteFMaskedStore32") 4, false, false, 1491, 12,  6, 1,  0, 0}, // #453
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #454
  {DBGFIELD("WriteFCmp64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #455
  {DBGFIELD("WriteFMoveY")        1, false, false, 748, 8,  1, 1,  0, 0}, // #456
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, 775, 10,  4, 1,  0, 0}, // #457
  {DBGFIELD("WriteFShuffleY")     1, false, false, 748, 8,  1, 1,  0, 0}, // #458
  {DBGFIELD("WriteFShuffleZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #459
  {DBGFIELD("WriteFShuffleZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #460
  {DBGFIELD("WriteVecStoreY")     2, false, false, 741, 4,  1, 1,  0, 0}, // #461
  {DBGFIELD("WriteVecMoveY")      1, false, false, 713, 3,  1, 1,  0, 0}, // #462
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, 745, 3,  5, 1,  0, 0}, // #463
  {DBGFIELD("WriteVecStoreNTY")   2, false, false, 741, 4,  1, 1,  0, 0}, // #464
  {DBGFIELD("WriteFStoreNTY")     2, false, false, 741, 4,  1, 1,  0, 0}, // #465
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 4, false, false, 1200, 14, 27, 1, 24, 1}, // #466
  {DBGFIELD("WriteMPSADY")        3, false, false, 1214, 12,  4, 1,  0, 0}, // #467
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 2, false, false, 1226, 6,  8, 1, 24, 1}, // #468
  {DBGFIELD("WriteFMul64Y")       1, false, false, 1173, 4, 22, 1,  0, 0}, // #469
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #470
  {DBGFIELD("WriteFMul64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #471
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 2, false, false, 1226, 6,  8, 1, 24, 1}, // #472
  {DBGFIELD("WriteFMulY")         1, false, false, 1173, 4, 22, 1,  0, 0}, // #473
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #474
  {DBGFIELD("WriteFMulZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #475
  {DBGFIELD("WriteVecALUYLd")     2, false, false, 843, 6,  4, 1,  0, 0}, // #476
  {DBGFIELD("WriteVecALUZLd")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #477
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 2, false, false, 770, 5,  4, 1, 24, 1}, // #478
  {DBGFIELD("WriteVecLogicY")     1, false, false, 713, 3,  1, 1,  0, 0}, // #479
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteVecLogicZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #481
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 2, false, false, 775, 10,  4, 1, 24, 1}, // #482
  {DBGFIELD("WriteBlendY")        1, false, false, 748, 8,  1, 1,  0, 0}, // #483
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 3, false, false, 785, 10, 11, 1, 24, 1}, // #484
  {DBGFIELD("WriteVarBlendY")     2, false, false, 795, 8,  3, 1,  0, 0}, // #485
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #486
  {DBGFIELD("WriteVarBlendZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 3, false, false, 785, 10, 11, 1, 25, 2}, // #488
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, 785, 10,  4, 1, 17, 2}, // #489
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, 775, 10,  4, 1, 25, 2}, // #490
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, 775, 10,  4, 1, 27, 2}, // #491
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, 775, 10,  5, 1, 17, 2}, // #492
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, 775, 10,  5, 1, 19, 2}, // #493
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, 775, 10,  8, 1, 24, 1}, // #494
  {DBGFIELD("WriteFVarShuffle256") 1, false, false, 748, 8, 22, 1,  0, 0}, // #495
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, 775, 10,  4, 1, 25, 2}, // #496
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, 775, 10,  4, 1, 27, 2}, // #497
  {DBGFIELD("WriteFVarShuffleY")  1, false, false, 748, 8,  1, 1,  0, 0}, // #498
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, 775, 10,  5, 1, 17, 2}, // #499
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, 775, 10,  5, 1, 19, 2}, // #500
  {DBGFIELD("WriteFVarShuffle")   1, false, false, 748, 8,  1, 1,  0, 0}, // #501
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 2, false, false, 775, 10,  4, 1, 24, 1}, // #502
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 2, false, false, 775, 10,  5, 1, 11, 1}, // #503
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #504
  {DBGFIELD("WriteFVarShuffleZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #505
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 4, false, false, 1182, 10,  8, 1, 24, 1}, // #506
  {DBGFIELD("WritePHAddY")        3, false, false, 1192, 8, 22, 1,  0, 0}, // #507
  {DBGFIELD("WriteVecInsert")     2, false, false, 795, 8,  3, 1,  0, 0}, // #508
  {DBGFIELD("WriteVecIMulXLd")    2, false, false, 903, 11, 19, 1,  0, 0}, // #509
  {DBGFIELD("WriteVecIMulYLd")    2, false, false, 903, 11,  9, 1,  0, 0}, // #510
  {DBGFIELD("WriteVecIMulZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #511
  {DBGFIELD("WriteVecMaskedStoreY") 4, false, false, 1491, 12,  6, 1,  0, 0}, // #512
  {DBGFIELD("WriteVecMaskedLoadY") 3, false, false, 785, 10, 11, 1,  0, 0}, // #513
  {DBGFIELD("WriteVecMaskedStore") 4, false, false, 1491, 12,  6, 1,  0, 0}, // #514
  {DBGFIELD("WriteVecMaskedLoad") 3, false, false, 785, 10,  4, 1,  0, 0}, // #515
  {DBGFIELD("WriteVecMOVMSKY")    1, false, false, 893, 9, 22, 1,  0, 0}, // #516
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 3, false, false, 1304, 11,  7, 1, 24, 1}, // #517
  {DBGFIELD("WritePMULLDY")       2, false, false, 1315, 9, 19, 1,  0, 0}, // #518
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #519
  {DBGFIELD("WritePMULLDZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #520
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, 775, 10,  5, 1, 17, 2}, // #521
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, 775, 10,  5, 1, 19, 2}, // #522
  {DBGFIELD("WriteVecShiftImmXLd") 2, false, false, 903, 11,  5, 1,  0, 0}, // #523
  {DBGFIELD("WriteVecShiftImmYLd") 2, false, false, 903, 11,  4, 1,  0, 0}, // #524
  {DBGFIELD("WriteVecShiftImmY")  1, false, false, 893, 9,  1, 1,  0, 0}, // #525
  {DBGFIELD("WriteVecShiftImmZLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #526
  {DBGFIELD("WriteVecShiftImmZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #527
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 4, false, false, 1503, 14, 11, 1, 11, 1}, // #528
  {DBGFIELD("WriteVarVecShift")   3, false, false, 1517, 12, 22, 1,  0, 0}, // #529
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 4, false, false, 1503, 14,  8, 1, 24, 1}, // #530
  {DBGFIELD("WriteVarVecShiftY")  3, false, false, 1517, 12, 22, 1,  0, 0}, // #531
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #532
  {DBGFIELD("WriteVarVecShiftZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 2, false, false, 903, 11,  5, 1, 11, 1}, // #534
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 2, false, false, 775, 10,  4, 1, 24, 1}, // #535
  {DBGFIELD("WriteVarShuffleY")   1, false, false, 748, 8,  1, 1,  0, 0}, // #536
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #537
  {DBGFIELD("WriteVarShuffleZ")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #538
  {DBGFIELD("WriteShuffleZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #539
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 2, false, false, 903, 11,  4, 1, 24, 1}, // #540
  {DBGFIELD("WriteVecShiftY")     2, false, false, 1037, 12, 23, 1,  0, 0}, // #541
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #542
  {DBGFIELD("WriteVecShiftZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #543
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 3, false, false, 1329, 14, 19, 1, 24, 1}, // #544
  {DBGFIELD("WriteVecTestY")      2, false, false, 1037, 12, 23, 1,  0, 0}, // #545
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 2, false, false, 903, 11, 19, 1, 11, 1}, // #546
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 4, false, false, 1448, 11, 28, 1, 24, 1}, // #547
  {DBGFIELD("WriteFRcpY")         3, false, false, 1460, 9,  9, 1,  0, 0}, // #548
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #549
  {DBGFIELD("WriteFRcpZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #550
  {DBGFIELD("WriteFRcpYLd")       4, false, false, 1448, 11, 28, 1,  0, 0}, // #551
  {DBGFIELD("WriteFRndYLd")       3, false, false, 1347, 9, 20, 1,  0, 0}, // #552
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 2, false, false, 903, 11, 19, 1, 11, 1}, // #553
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 4, false, false, 1448, 11, 28, 1, 24, 1}, // #554
  {DBGFIELD("WriteFRsqrtY")       3, false, false, 1460, 9,  9, 1,  0, 0}, // #555
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #556
  {DBGFIELD("WriteFRsqrtZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #557
  {DBGFIELD("WriteFRsqrtYLd")     4, false, false, 1448, 11, 28, 1,  0, 0}, // #558
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 2, false, false, 775, 10,  4, 1, 24, 1}, // #559
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #560
  {DBGFIELD("WriteFSqrt64YLd")    4, false, false, 1529, 12, 72, 1,  0, 0}, // #561
  {DBGFIELD("WriteFSqrt64Y")      3, false, false, 1541, 10, 36, 1,  0, 0}, // #562
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 2, false, false, 1383, 12, 31, 1, 11, 1}, // #563
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 4, false, false, 1529, 12, 72, 1, 24, 1}, // #564
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #565
  {DBGFIELD("WriteFSqrt64Z")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #566
  {DBGFIELD("WriteFSqrtYLd")      4, false, false, 1551, 12, 66, 1,  0, 0}, // #567
  {DBGFIELD("WriteFSqrtY")        3, false, false, 1563, 10, 31, 1,  0, 0}, // #568
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 2, false, false, 1405, 12,  7, 1, 11, 1}, // #569
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 4, false, false, 1551, 12, 66, 1, 24, 1}, // #570
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #571
  {DBGFIELD("WriteFSqrtZ")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #572
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 2, false, false, 903, 11,  4, 1, 24, 1}, // #573
  {DBGFIELD("WriteFTestY")        1, false, false, 893, 9,  1, 1,  0, 0}, // #574
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 2, false, false, 903, 11,  5, 1, 11, 1}, // #575
  {DBGFIELD("WriteFTest")         1, false, false, 893, 9,  1, 1,  0, 0}, // #576
  {DBGFIELD("WriteALULd_WriteRMW") 3, false, false, 756, 6, 78, 2,  0, 0}, // #577
  {DBGFIELD("WriteXCHG")          3, false, false, 994, 2,  3, 1,  0, 0}, // #578
  {DBGFIELD("COPY")               1, false, false, 714, 2,  1, 1,  0, 0}, // #579
  {DBGFIELD("FXAM")               1, false, false, 714, 2,  2, 1,  0, 0}, // #580
  {DBGFIELD("LD_Frr")             1, false, false, 714, 2,  1, 1,  0, 0}, // #581
  {DBGFIELD("MOVSX64rr32")        1, false, false, 714, 2,  1, 1,  0, 0}, // #582
  {DBGFIELD("RCL16m1_RCL16mi_RCL32m1_RCL32mi_RCL64m1_RCL64mi_RCL8m1_RCL8mi_RCR16m1_RCR16mi_RCR32m1_RCR32mi_RCR64m1_RCR64mi_RCR8m1_RCR8mi_ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 5, false, false, 1573, 6, 11, 1,  0, 0}, // #583
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL_RCR16mCL_RCR32mCL_RCR64mCL_RCR8mCL_ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 11, false, false, 1579, 11, 29, 1,  0, 0}, // #584
  {DBGFIELD("SAR16m1_SAR16mi_SAR32m1_SAR32mi_SAR64m1_SAR64mi_SAR8m1_SAR8mi_SHL16m1_SHL16mi_SHL32m1_SHL32mi_SHL64m1_SHL64mi_SHL8m1_SHL8mi_SHR16m1_SHR16mi_SHR32m1_SHR32mi_SHR64m1_SHR64mi_SHR8m1_SHR8mi") 4, false, false, 849, 8,  5, 1,  0, 0}, // #585
  {DBGFIELD("SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 6, false, false, 716, 8, 11, 1,  0, 0}, // #586
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, 714, 2,  1, 1,  0, 0}, // #587
  {DBGFIELD("FCOMPP")             1, false, false, 714, 2,  2, 1,  0, 0}, // #588
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, 734, 7, 22, 1,  0, 0}, // #589
  {DBGFIELD("MMX_CVTPI2PSirr")    1, false, false, 734, 7, 22, 1,  0, 0}, // #590
  {DBGFIELD("MMX_CVTPI2PSirm")    2, false, false, 766, 9, 11, 1,  0, 0}, // #591
  {DBGFIELD("MMX_CVTPS2PIirr_MMX_CVTTPS2PIirr") 2, false, false, 1151, 11, 23, 1,  0, 0}, // #592
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 2, false, false, 762, 4,  5, 1,  0, 0}, // #593
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, 741, 4,  1, 1,  0, 0}, // #594
  {DBGFIELD("XCH_F")              12, false, false, 1590, 14, 21, 1,  0, 0}, // #595
  {DBGFIELD("RETIL_RETIQ_RETIW_IRET_IRET16_IRET32_IRET64") 2, false, false, 724, 6,  5, 1,  0, 0}, // #596
  {DBGFIELD("MMX_CVTPS2PIirm_MMX_CVTTPS2PIirm") 2, false, false, 766, 9, 11, 1,  0, 0}, // #597
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 2, false, false, 766, 9,  8, 1,  0, 0}, // #598
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 2, false, false, 801, 2,  3, 1,  0, 0}, // #599
  {DBGFIELD("LFENCE")             2, false, false, 801, 2,  3, 1,  0, 0}, // #600
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, 748, 8,  1, 1,  0, 0}, // #601
  {DBGFIELD("PSLLDQri_PSRLDQri")  1, false, false, 748, 8,  1, 1,  0, 0}, // #602
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr_MMX_PUNPCKHBWirr_MMX_PUNPCKHDQirr_MMX_PUNPCKHWDirr") 1, false, false, 748, 8,  1, 1,  0, 0}, // #603
  {DBGFIELD("LEAVE_LEAVE64")      3, false, false, 1604, 4,  4, 1,  0, 0}, // #604
  {DBGFIELD("POP16r")             2, false, false, 762, 4,  5, 1,  0, 0}, // #605
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 4, false, false, 756, 6,  5, 1,  0, 0}, // #606
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false, 714, 2,  2, 1,  0, 0}, // #607
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, 714, 2,  2, 1,  0, 0}, // #608
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, 741, 4,  1, 1,  0, 0}, // #609
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, 714, 2,  1, 1,  0, 0}, // #610
  {DBGFIELD("MMX_PADDQirr_MMX_PSUBQirr") 1, false, false, 712, 4,  1, 1,  0, 0}, // #611
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, 714, 2,  1, 1,  0, 0}, // #612
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 2, false, false, 741, 4,  1, 1,  0, 0}, // #613
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  2, false, false, 741, 4,  1, 1,  0, 0}, // #614
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, 712, 4,  1, 1,  0, 0}, // #615
  {DBGFIELD("CLD")                3, false, false, 1608, 7, 22, 1,  0, 0}, // #616
  {DBGFIELD("LDDQUrm")            1, false, false, 745, 3,  6, 1,  0, 0}, // #617
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, 714, 2,  2, 1,  0, 0}, // #618
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 4, false, false, 756, 6,  5, 1,  0, 0}, // #619
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 6, false, false, 1615, 6, 11, 1,  0, 0}, // #620
  {DBGFIELD("PHADDDrr_PHSUBDrr")  3, false, false, 1192, 8, 22, 1,  0, 0}, // #621
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, 745, 3,  6, 1,  0, 0}, // #622
  {DBGFIELD("MMX_PADDQirm_MMX_PSUBQirm") 2, false, false, 843, 6,  5, 1, 11, 1}, // #623
  {DBGFIELD("MOVDQUrm")           1, false, false, 745, 3,  6, 1,  0, 0}, // #624
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, 745, 3,  6, 1,  0, 0}, // #625
  {DBGFIELD("PADDQrm_PSUBQrm")    2, false, false, 843, 6,  5, 1, 11, 1}, // #626
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, 714, 2,  1, 1,  0, 0}, // #627
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   2, false, false, 1621, 4,  3, 1,  0, 0}, // #628
  {DBGFIELD("LD_F80m")            1, false, false, 745, 3,  5, 1,  0, 0}, // #629
  {DBGFIELD("PHADDDrm_PHSUBDrm")  4, false, false, 1182, 10, 11, 1, 11, 1}, // #630
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 2, false, false, 1037, 12,  3, 1,  0, 0}, // #631
  {DBGFIELD("FLDCW16m")           3, false, false, 1625, 11,  4, 1,  0, 0}, // #632
  {DBGFIELD("ST_FP80m")           2, false, false, 741, 4,  1, 1,  0, 0}, // #633
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 3, false, false, 1192, 8, 22, 1,  0, 0}, // #634
  {DBGFIELD("CMPXCHG8rm")         6, false, false, 716, 8, 11, 1,  0, 0}, // #635
  {DBGFIELD("INTO")               1, false, false, 714, 2,  2, 1,  0, 0}, // #636
  {DBGFIELD("XLAT")               1, false, false, 745, 3,  6, 1,  0, 0}, // #637
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 4, false, false, 1093, 9,  5, 1,  0, 0}, // #638
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false, 734, 7, 22, 1,  0, 0}, // #639
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 6, false, false, 1363, 11,  9, 1,  0, 0}, // #640
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 4, false, false, 1374, 9,  8, 1,  0, 0}, // #641
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 3, false, false, 1437, 10, 23, 1,  0, 0}, // #642
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 4, false, false, 1182, 10, 11, 1, 11, 1}, // #643
  {DBGFIELD("AAD8i8")             1, false, false, 714, 2,  2, 1,  0, 0}, // #644
  {DBGFIELD("LOOPE")              11, false, false, 1636, 4,  9, 1,  0, 0}, // #645
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, 741, 4,  1, 1,  0, 0}, // #646
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 4, false, false, 1093, 9,  5, 1,  0, 0}, // #647
  {DBGFIELD("FNSTCW16m")          3, false, false, 1640, 10,  3, 1,  0, 0}, // #648
  {DBGFIELD("POPA16_POPA32")      1, false, false, 745, 3,  6, 1,  0, 0}, // #649
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, 741, 4,  1, 1,  0, 0}, // #650
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 6, false, false, 1363, 11,  9, 1,  0, 0}, // #651
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 4, false, false, 1374, 9,  8, 1,  0, 0}, // #652
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, 734, 7, 22, 1,  0, 0}, // #653
  {DBGFIELD("CMPXCHG8rr")         5, false, false, 857, 4,  6, 1,  0, 0}, // #654
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80_COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 734, 7, 22, 1,  0, 0}, // #655
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 2, false, false, 1650, 12, 23, 1,  0, 0}, // #656
  {DBGFIELD("CVTTSS2SI64rr")      2, false, false, 1650, 12, 23, 1,  0, 0}, // #657
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int") 2, false, false, 766, 9, 11, 1, 11, 1}, // #658
  {DBGFIELD("CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 4, false, false, 966, 16, 19, 1,  0, 0}, // #659
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, 714, 2,  2, 1,  0, 0}, // #660
  {DBGFIELD("AAA_AAS")            1, false, false, 714, 2,  2, 1,  0, 0}, // #661
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 6, false, false, 716, 8, 11, 1,  0, 0}, // #662
  {DBGFIELD("LOOPNE")             11, false, false, 1636, 4,  9, 1,  0, 0}, // #663
  {DBGFIELD("PAUSE")              5, false, false, 1662, 7,  6, 1,  0, 0}, // #664
  {DBGFIELD("CMPXCHG8B")          14, false, false, 1669, 10,  7, 1,  0, 0}, // #665
  {DBGFIELD("DAA")                1, false, false, 714, 2,  2, 1,  0, 0}, // #666
  {DBGFIELD("LOOP")               7, false, false, 1679, 9,  4, 1,  0, 0}, // #667
  {DBGFIELD("DAS")                1, false, false, 714, 2,  2, 1,  0, 0}, // #668
  {DBGFIELD("AAM8i8")             1, false, false, 714, 2,  2, 1,  0, 0}, // #669
  {DBGFIELD("STD")                6, false, false, 1688, 7,  5, 1,  0, 0}, // #670
  {DBGFIELD("CMPXCHG16B")         19, false, false, 1695, 15, 31, 1,  0, 0}, // #671
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, 714, 2,  2, 1,  0, 0}, // #672
  {DBGFIELD("FNCLEX_FXTRACT")     4, false, false, 1024, 2, 23, 1,  0, 0}, // #673
  {DBGFIELD("POPF32_POPF64")      1, false, false, 745, 3,  6, 1,  0, 0}, // #674
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, 714, 2,  2, 1,  0, 0}, // #675
  {DBGFIELD("RDTSC_RDTSCP")       22, false, false, 1710, 8, 82, 1,  0, 0}, // #676
  {DBGFIELD("ENTER")              1, false, false, 714, 2,  2, 1,  0, 0}, // #677
  {DBGFIELD("POPF16")             1, false, false, 745, 3,  6, 1,  0, 0}, // #678
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false, 714, 2,  2, 1,  0, 0}, // #679
  {DBGFIELD("FRNDINT")            1, false, false, 714, 2,  2, 1,  0, 0}, // #680
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false, 714, 2,  2, 1,  0, 0}, // #681
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, 714, 2,  2, 1,  0, 0}, // #682
  {DBGFIELD("FPREM")              1, false, false, 714, 2,  2, 1,  0, 0}, // #683
  {DBGFIELD("INSB_INSL_INSW")     8, false, false, 1718, 15, 30, 1,  0, 0}, // #684
  {DBGFIELD("FNINIT")             15, false, false, 1733, 9, 83, 1,  0, 0}, // #685
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 23, false, false, 1742, 13, 72, 1,  0, 0}, // #686
  {DBGFIELD("FPREM1")             1, false, false, 714, 2,  2, 1,  0, 0}, // #687
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, 714, 2,  2, 1,  0, 0}, // #688
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 23, false, false, 1742, 13, 72, 1,  0, 0}, // #689
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, 714, 2,  2, 1,  0, 0}, // #690
  {DBGFIELD("FSCALE")             1, false, false, 714, 2,  2, 1,  0, 0}, // #691
  {DBGFIELD("RDMSR")              1, false, false, 714, 2,  2, 1,  0, 0}, // #692
  {DBGFIELD("RET_RETL_RETQ_RETW_LRETIL_LRETIQ_LRETIW_LRETL_LRETQ_LRETW") 2, false, false, 724, 6,  5, 1,  0, 0}, // #693
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 23, false, false, 1755, 13, 17, 1,  0, 0}, // #694
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 23, false, false, 1755, 13, 17, 1,  0, 0}, // #695
  {DBGFIELD("F2XM1")              1, false, false, 714, 2,  2, 1,  0, 0}, // #696
  {DBGFIELD("CPUID")              8, false, false, 1768, 11, 29, 1,  0, 0}, // #697
  {DBGFIELD("INT")                1, false, false, 714, 2,  2, 1,  0, 0}, // #698
  {DBGFIELD("INT3")               1, false, false, 714, 2,  2, 1,  0, 0}, // #699
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, 714, 2,  2, 1,  0, 0}, // #700
  {DBGFIELD("FXRSTOR_FXRSTOR64")  90, false, false, 1779, 15, 44, 1,  0, 0}, // #701
  {DBGFIELD("FYL2X")              1, false, false, 714, 2,  2, 1,  0, 0}, // #702
  {DBGFIELD("FYL2XP1")            1, false, false, 714, 2,  2, 1,  0, 0}, // #703
  {DBGFIELD("FPTAN")              1, false, false, 714, 2,  2, 1,  0, 0}, // #704
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false, 714, 2,  2, 1,  0, 0}, // #705
  {DBGFIELD("FPATAN")             1, false, false, 714, 2,  2, 1,  0, 0}, // #706
  {DBGFIELD("WRMSR")              1, false, false, 714, 2,  2, 1,  0, 0}, // #707
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, 734, 7,  1, 1,  0, 0}, // #708
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, 734, 7,  1, 1,  0, 0}, // #709
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 2, false, false, 1054, 4,  3, 1,  0, 0}, // #710
  {DBGFIELD("FNOP")               1, false, false, 1173, 4,  1, 1,  0, 0}, // #711
  {DBGFIELD("RETQ")               3, false, false, 1794, 9,  4, 1,  0, 0}, // #712
  {DBGFIELD("CDQ_CQO")            1, false, false, 730, 4,  1, 1,  0, 0}, // #713
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, 712, 4,  1, 1,  0, 0}, // #714
  {DBGFIELD("MMX_PADDQirr")       1, false, false, 712, 4,  1, 1,  0, 0}, // #715
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, 748, 8,  1, 1,  0, 0}, // #716
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 3, false, false, 1604, 4,  4, 1,  0, 0}, // #717
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 734, 7, 22, 1,  0, 0}, // #718
  {DBGFIELD("VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 1, false, false, 734, 7, 22, 1,  0, 0}, // #719
  {DBGFIELD("CWD")                2, false, false, 1621, 4,  3, 1,  0, 0}, // #720
  {DBGFIELD("FNSTSW16r")          2, false, false, 1803, 9, 23, 1,  0, 0}, // #721
  {DBGFIELD("MMX_MOVDQ2Qrr")      2, false, false, 1812, 4,  3, 1,  0, 0}, // #722
  {DBGFIELD("PUSHFS64")           1, false, false, 714, 2,  2, 1,  0, 0}, // #723
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 2, false, false, 1037, 12,  3, 1,  0, 0}, // #724
  {DBGFIELD("RCL16r1_RCL32r1_RCL64r1_RCL8r1_RCR16r1_RCR32r1_RCR64r1_RCR8r1") 3, false, false, 1816, 4, 22, 1,  0, 0}, // #725
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, 734, 7, 22, 1,  0, 0}, // #726
  {DBGFIELD("MOV64sr")            1, false, false, 714, 2,  1, 1,  0, 0}, // #727
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVSX32rm16_MOVSX32rm32_MOVSX32rm8_MOVSX32rm8_NOREX_MOVSX64rm16_MOVSX64rm32_MOVSX64rm8_MOVZX16rm16_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX_MOVZX64rm16_MOVZX64rm8") 1, false, false, 745, 3,  6, 1,  0, 0}, // #728
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCL8rCL_RCR16rCL_RCR32rCL_RCR64rCL_RCR8rCL") 10, false, false, 1820, 9, 21, 1,  0, 0}, // #729
  {DBGFIELD("RCL16ri_RCL32ri_RCL64ri_RCL8ri_RCR16ri_RCR32ri_RCR64ri_RCR8ri") 3, false, false, 1816, 4, 22, 1,  0, 0}, // #730
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 3, false, false, 1829, 5,  3, 1,  0, 0}, // #731
  {DBGFIELD("CLI")                1, false, false, 714, 2,  2, 1,  0, 0}, // #732
  {DBGFIELD("PUSHGS64")           1, false, false, 714, 2,  2, 1,  0, 0}, // #733
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 3, false, false, 1437, 10, 23, 1,  0, 0}, // #734
  {DBGFIELD("CALL64pcrel32")      4, false, false, 1834, 7, 22, 1,  0, 0}, // #735
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 4, false, false, 1841, 10, 22, 1,  0, 0}, // #736
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 3, false, false, 1026, 11,  3, 1,  0, 0}, // #737
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 3, false, false, 1829, 5,  3, 1,  0, 0}, // #738
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 3, false, false, 1026, 11,  3, 1,  0, 0}, // #739
  {DBGFIELD("PUSHF16_PUSHF64")    6, false, false, 1851, 5,  6, 1,  0, 0}, // #740
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 2, false, false, 1856, 7,  3, 1,  0, 0}, // #741
  {DBGFIELD("MMX_MOVD64from64rm") 2, false, false, 741, 4,  1, 1,  0, 0}, // #742
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, 745, 3,  6, 1,  0, 0}, // #743
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, 745, 3,  6, 1,  0, 0}, // #744
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 745, 3,  6, 1,  0, 0}, // #745
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false, 745, 3,  6, 1,  0, 0}, // #746
  {DBGFIELD("MOV16sm")            1, false, false, 714, 2,  1, 1,  0, 0}, // #747
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 2, false, false, 843, 6,  5, 1,  0, 0}, // #748
  {DBGFIELD("MMX_PALIGNRrmi")     2, false, false, 775, 10,  5, 1, 11, 1}, // #749
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 2, false, false, 843, 6,  5, 1, 11, 1}, // #750
  {DBGFIELD("LODSL_LODSQ")        1, false, false, 714, 2,  2, 1,  0, 0}, // #751
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false, 745, 3,  5, 1,  0, 0}, // #752
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 1, false, false, 745, 3,  5, 1,  0, 0}, // #753
  {DBGFIELD("VINSERTF128rm")      2, false, false, 770, 5,  5, 1,  0, 0}, // #754
  {DBGFIELD("MMX_PADDQirm")       2, false, false, 843, 6,  5, 1, 11, 1}, // #755
  {DBGFIELD("VERRm_VERWm")        1, false, false, 714, 2,  2, 1,  0, 0}, // #756
  {DBGFIELD("FARJMP64")           2, false, false, 1863, 9,  5, 1,  0, 0}, // #757
  {DBGFIELD("FNSTSWm")            3, false, false, 1872, 11, 23, 1,  0, 0}, // #758
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 4, false, false, 1883, 11,  5, 1,  0, 0}, // #759
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 5, false, false, 1894, 11,  4, 1,  0, 0}, // #760
  {DBGFIELD("CALL64m_CALL64m_NT") 5, false, false, 1894, 11,  4, 1,  0, 0}, // #761
  {DBGFIELD("VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 2, false, false, 766, 9, 11, 1, 11, 1}, // #762
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, 714, 2,  2, 1,  0, 0}, // #763
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 5, false, false, 1905, 8,  4, 1,  0, 0}, // #764
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 5, false, false, 1913, 6,  4, 1,  0, 0}, // #765
  {DBGFIELD("FARCALL64")          5, false, false, 1894, 11,  4, 1,  0, 0}, // #766
  {DBGFIELD("CVTSD2SI64rm_Int_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int") 3, false, false, 1919, 14,  8, 1,  0, 0}, // #767
  {DBGFIELD("CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int") 3, false, false, 1919, 14,  8, 1,  0, 0}, // #768
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, 745, 3,  5, 1,  0, 0}, // #769
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 6, false, false, 716, 8, 11, 1,  0, 0}, // #770
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 6, false, false, 716, 8, 11, 1,  0, 0}, // #771
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 2, false, false, 766, 9,  8, 1,  0, 0}, // #772
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 2, false, false, 903, 11, 19, 1,  0, 0}, // #773
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 3, false, false, 1347, 9, 19, 1,  0, 0}, // #774
  {DBGFIELD("MUL_F32m_MUL_F64m")  2, false, false, 903, 11,  9, 1,  0, 0}, // #775
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 3, false, false, 1347, 9, 20, 1,  0, 0}, // #776
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 3, false, false, 1919, 14, 21, 1,  0, 0}, // #777
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 2, false, false, 903, 11, 31, 1,  0, 0}, // #778
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 3, false, false, 1919, 14, 77, 1,  0, 0}, // #779
  {DBGFIELD("VZEROALL")           20, false, false, 1933, 11, 11, 1,  0, 0}, // #780
  {DBGFIELD("VZEROUPPER")         4, false, false,  0, 0,  0, 1,  0, 0}, // #781
  {DBGFIELD("CLC")                1, false, false,  0, 0,  1, 1,  0, 0}, // #782
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #783
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #784
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #785
  {DBGFIELD("PXORrr_VPXORrr")     16382, false, false,  0, 0,  0, 0,  0, 0}, // #786
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #787
  {DBGFIELD("PSUBQrr")            16382, false, false,  0, 0,  0, 0,  0, 0}, // #788
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #789
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #790
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #791
  {DBGFIELD("SETCCr")             16382, false, false,  0, 0,  0, 0,  0, 0}, // #792
  {DBGFIELD("SETCCm")             16382, false, false,  0, 0,  0, 0,  0, 0}, // #793
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 2, false, false, 775, 10,  5, 1, 11, 1}, // #794
  {DBGFIELD("RETIL_RETIQ_RETIW")  2, false, false, 724, 6,  5, 1,  0, 0}, // #795
  {DBGFIELD("LRETIL_LRETIQ_LRETIW") 2, false, false, 724, 6,  5, 1,  0, 0}, // #796
  {DBGFIELD("RDPMC")              1, false, false, 714, 2,  2, 1,  0, 0}, // #797
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 5, false, false, 1944, 6,  8, 1,  0, 0}, // #798
  {DBGFIELD("FBLDm")              1, false, false, 714, 2,  2, 1,  0, 0}, // #799
  {DBGFIELD("FFREE_FFREEP")       1, false, false, 714, 2,  2, 1,  0, 0}, // #800
  {DBGFIELD("FSAVEm")             1, false, false, 714, 2,  2, 1,  0, 0}, // #801
  {DBGFIELD("FRSTORm")            1, false, false, 714, 2,  2, 1,  0, 0}, // #802
  {DBGFIELD("FXTRACT")            1, false, false, 714, 2,  2, 1,  0, 0}, // #803
  {DBGFIELD("MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 745, 3,  6, 1,  0, 0}, // #804
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, 745, 3,  6, 1,  0, 0}, // #805
  {DBGFIELD("VBROADCASTF128")     1, false, false, 745, 3,  5, 1,  0, 0}, // #806
  {DBGFIELD("VBROADCASTI128")     1, false, false, 745, 3,  5, 1,  0, 0}, // #807
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, 745, 3,  5, 1,  0, 0}, // #808
  {DBGFIELD("FBSTPm")             2, false, false, 741, 4,  1, 1,  0, 0}, // #809
  {DBGFIELD("VMPTRSTm")           1, false, false, 714, 2,  2, 1,  0, 0}, // #810
  {DBGFIELD("ST_FP32m_ST_FP64m")  2, false, false, 741, 4,  1, 1,  0, 0}, // #811
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 1, false, false, 893, 9,  1, 1,  0, 0}, // #812
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 1, false, false, 893, 9,  1, 1,  0, 0}, // #813
  {DBGFIELD("MMX_MOVQ2DQrr")      1, false, false, 748, 8,  1, 1,  0, 0}, // #814
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false, 1950, 7,  1, 1,  0, 0}, // #815
  {DBGFIELD("FINCSTP")            1, false, false, 1173, 4,  1, 1,  0, 0}, // #816
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false, 712, 4,  1, 1,  0, 0}, // #817
  {DBGFIELD("VPBLENDDYrri")       1, false, false, 713, 3,  1, 1,  0, 0}, // #818
  {DBGFIELD("VPBLENDDrri")        1, false, false, 713, 3,  1, 1,  0, 0}, // #819
  {DBGFIELD("CMC_STC")            1, false, false, 714, 2,  1, 1,  0, 0}, // #820
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false, 714, 2,  1, 1,  0, 0}, // #821
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 2, false, false, 903, 11,  5, 1,  0, 0}, // #822
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 2, false, false, 903, 11,  5, 1,  0, 0}, // #823
  {DBGFIELD("CVTSS2SDrm")         2, false, false, 903, 11,  5, 1,  0, 0}, // #824
  {DBGFIELD("CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 2, false, false, 903, 11,  5, 1,  0, 0}, // #825
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 2, false, false, 903, 11,  4, 1,  0, 0}, // #826
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 2, false, false, 766, 9, 11, 1,  0, 0}, // #827
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 2, false, false, 775, 10,  5, 1,  0, 0}, // #828
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 2, false, false, 775, 10, 11, 1,  0, 0}, // #829
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 2, false, false, 1863, 9,  5, 1,  0, 0}, // #830
  {DBGFIELD("ANDN32rm_ANDN64rm")  2, false, false, 843, 6,  5, 1,  0, 0}, // #831
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 2, false, false, 843, 6,  5, 1,  0, 0}, // #832
  {DBGFIELD("VINSERTI128rm")      2, false, false, 770, 5,  5, 1,  0, 0}, // #833
  {DBGFIELD("VPBLENDDrmi")        2, false, false, 770, 5,  5, 1,  0, 0}, // #834
  {DBGFIELD("VPBLENDDYrmi")       2, false, false, 770, 5,  4, 1,  0, 0}, // #835
  {DBGFIELD("POP32r_POP64r")      2, false, false, 762, 4,  5, 1,  0, 0}, // #836
  {DBGFIELD("SFENCE")             2, false, false, 727, 3,  3, 1,  0, 0}, // #837
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 3, false, false, 1957, 7,  3, 1,  0, 0}, // #838
  {DBGFIELD("MOVBE16mr")          3, false, false, 1957, 7,  3, 1,  0, 0}, // #839
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 3, false, false, 1829, 5,  3, 1,  0, 0}, // #840
  {DBGFIELD("MFENCE")             2, false, false, 801, 2,  3, 1,  0, 0}, // #841
  {DBGFIELD("XGETBV")             2, false, false, 801, 2,  3, 1,  0, 0}, // #842
  {DBGFIELD("CVTPS2PDrr_VCVTPS2PDrr") 2, false, false, 1037, 12,  3, 1,  0, 0}, // #843
  {DBGFIELD("CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 2, false, false, 1037, 12,  3, 1,  0, 0}, // #844
  {DBGFIELD("MMX_PACKSSDWirm_MMX_PACKSSWBirm_MMX_PACKUSWBirm") 3, false, false, 785, 10,  4, 1,  0, 0}, // #845
  {DBGFIELD("LRETQ_RETL")         2, false, false, 724, 6,  5, 1,  0, 0}, // #846
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 2, false, false, 1964, 4,  3, 1,  0, 0}, // #847
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, 734, 7, 22, 1,  0, 0}, // #848
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, 734, 7, 22, 1,  0, 0}, // #849
  {DBGFIELD("VCVTDQ2PSYrr")       1, false, false, 734, 7, 22, 1,  0, 0}, // #850
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, 748, 8, 22, 1,  0, 0}, // #851
  {DBGFIELD("CVTPS2DQrm_VCVTPS2DQrm_CVTTPS2DQrm_VCVTTPS2DQrm") 2, false, false, 766, 9, 11, 1,  0, 0}, // #852
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, 766, 9,  8, 1,  0, 0}, // #853
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm") 2, false, false, 766, 9,  8, 1,  0, 0}, // #854
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 2, false, false, 775, 10, 11, 1,  0, 0}, // #855
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr") 3, false, false, 1968, 8, 22, 1,  0, 0}, // #856
  {DBGFIELD("CLDEMOTE")           3, false, false, 1608, 7, 22, 1,  0, 0}, // #857
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int") 2, false, false, 1650, 12, 23, 1,  0, 0}, // #858
  {DBGFIELD("CVTTSD2SI64rr_CVTTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, 1650, 12, 23, 1,  0, 0}, // #859
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int_CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, 1650, 12, 23, 1,  0, 0}, // #860
  {DBGFIELD("CVTTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr") 2, false, false, 1650, 12, 23, 1,  0, 0}, // #861
  {DBGFIELD("VCVTPS2PDYrr")       2, false, false, 1037, 12, 23, 1,  0, 0}, // #862
  {DBGFIELD("MMX_CVTPI2PDirr")    2, false, false, 1151, 11, 23, 1,  0, 0}, // #863
  {DBGFIELD("MMX_CVTPD2PIirr_MMX_CVTTPD2PIirr") 2, false, false, 1151, 11, 23, 1,  0, 0}, // #864
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 2, false, false, 1151, 11, 23, 1,  0, 0}, // #865
  {DBGFIELD("CVTPD2PSrr_VCVTPD2PSrr") 2, false, false, 1151, 11, 23, 1,  0, 0}, // #866
  {DBGFIELD("CVTSD2SSrr_CVTSD2SSrr_Int_VCVTSD2SSrr_VCVTSD2SSrr_Int") 2, false, false, 1151, 11, 23, 1,  0, 0}, // #867
  {DBGFIELD("CVTSI2SDrr_CVTSI642SDrr") 2, false, false, 1151, 11, 23, 1,  0, 0}, // #868
  {DBGFIELD("CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, 1151, 11, 23, 1,  0, 0}, // #869
  {DBGFIELD("CVTSI2SSrr")         2, false, false, 1151, 11, 23, 1,  0, 0}, // #870
  {DBGFIELD("CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int") 2, false, false, 1151, 11, 23, 1,  0, 0}, // #871
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, 1151, 11, 23, 1,  0, 0}, // #872
  {DBGFIELD("VCVTSD2SI64rm_Int_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 3, false, false, 1919, 14,  8, 1,  0, 0}, // #873
  {DBGFIELD("CVTSS2SI64rm_Int")   3, false, false, 1919, 14,  8, 1,  0, 0}, // #874
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, 1919, 14,  8, 1,  0, 0}, // #875
  {DBGFIELD("VCVTPS2PDYrm")       3, false, false, 1329, 14,  8, 1,  0, 0}, // #876
  {DBGFIELD("CVTPD2PSrm")         3, false, false, 1138, 13,  8, 1,  0, 0}, // #877
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_MMX_CVTPD2PIirm_MMX_CVTTPD2PIirm") 3, false, false, 1138, 13,  8, 1,  0, 0}, // #878
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 3, false, false, 1138, 13,  8, 1,  0, 0}, // #879
  {DBGFIELD("MMX_CVTPI2PDirm")    3, false, false, 1138, 13,  8, 1,  0, 0}, // #880
  {DBGFIELD("CVTSD2SSrm")         3, false, false, 1138, 13,  8, 1,  0, 0}, // #881
  {DBGFIELD("CVTSD2SSrm_Int_VCVTSD2SSrm_VCVTSD2SSrm_Int") 3, false, false, 1138, 13,  8, 1,  0, 0}, // #882
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 3, false, false, 1976, 10,  8, 1,  0, 0}, // #883
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 8, false, false, 1986, 13, 21, 1,  0, 0}, // #884
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 5, false, false, 1999, 13,  8, 1,  0, 0}, // #885
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, 893, 9,  6, 1,  0, 0}, // #886
  {DBGFIELD("VPCMPGTQYrm")        2, false, false, 903, 11,  9, 1,  0, 0}, // #887
  {DBGFIELD("CVTSI642SSrr")       3, false, false, 1071, 11,  6, 1,  0, 0}, // #888
  {DBGFIELD("CVTSI642SSrr_Int_VCVTSI642SSrr_VCVTSI642SSrr_Int") 3, false, false, 1071, 11,  6, 1,  0, 0}, // #889
  {DBGFIELD("STR16r_STR32r_STR64r") 3, false, false, 2012, 11,  6, 1,  0, 0}, // #890
  {DBGFIELD("XSETBV")             5, false, false, 2023, 4,  6, 1,  0, 0}, // #891
  {DBGFIELD("VCVTDQ2PDYrr")       2, false, false, 1151, 11,  5, 1,  0, 0}, // #892
  {DBGFIELD("VCVTPD2PSYrr")       2, false, false, 1151, 11,  5, 1,  0, 0}, // #893
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 2, false, false, 1151, 11,  5, 1,  0, 0}, // #894
  {DBGFIELD("VCVTDQ2PDYrm")       3, false, false, 1138, 13,  9, 1,  0, 0}, // #895
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 10, false, false, 2027, 11, 10, 1,  0, 0}, // #896
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 7, false, false, 2038, 9,  9, 1,  0, 0}, // #897
  {DBGFIELD("RCL8rCL")            9, false, false, 2047, 9,  9, 1,  0, 0}, // #898
  {DBGFIELD("RDTSC")              8, false, false, 1768, 11, 29, 1,  0, 0}, // #899
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 19, false, false, 2056, 9, 33, 1,  0, 0}, // #900
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, 893, 9, 30, 1,  0, 0}, // #901
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 2, false, false, 903, 11, 35, 1,  0, 0}, // #902
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 3, false, false, 1919, 14, 36, 1,  0, 0}, // #903
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, 893, 9, 10, 1,  0, 0}, // #904
  {DBGFIELD("XSAVE64")            27, false, false, 2065, 11, 36, 1,  0, 0}, // #905
  {DBGFIELD("XSAVE")              28, false, false, 2076, 11, 37, 1,  0, 0}, // #906
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 28, false, false, 2076, 11, 37, 1,  0, 0}, // #907
  {DBGFIELD("VMCLEARm")           1, false, false, 714, 2,  2, 1,  0, 0}, // #908
  {DBGFIELD("FLDENVm")            64, false, false, 2087, 11, 84, 1,  0, 0}, // #909
  {DBGFIELD("FXRSTOR64")          88, false, false, 2098, 15, 44, 1,  0, 0}, // #910
  {DBGFIELD("FSTENVm")            100, false, false, 2113, 17, 85, 1,  0, 0}, // #911
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm_VPGATHERDDrm") 1, false, false, 745, 3,  6, 1,  0, 0}, // #912
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 1, false, false, 745, 3,  6, 1,  0, 0}, // #913
  {DBGFIELD("VPGATHERQDYrm")      1, false, false, 745, 3,  6, 1,  0, 0}, // #914
  {DBGFIELD("VPGATHERQDrm")       1, false, false, 745, 3,  6, 1,  0, 0}, // #915
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 1, false, false, 745, 3,  6, 1,  0, 0}, // #916
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 1, false, false, 745, 3,  6, 1,  0, 0}, // #917
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 1, false, false, 745, 3,  6, 1,  0, 0}, // #918
  {DBGFIELD("VGATHERQPSYrm")      9, false, false, 2130, 12, 77, 1,  0, 0}, // #919
  {DBGFIELD("VGATHERQPSrm_VGATHERDPSrm") 9, false, false, 2130, 12, 66, 1,  0, 0}, // #920
  {DBGFIELD("VPXORYrr")           16382, false, false,  0, 0,  0, 0,  0, 0}, // #921
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #922
  {DBGFIELD("VPCMPGTQYrr")        16382, false, false,  0, 0,  0, 0,  0, 0}, // #923
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false, 730, 4,  1, 1,  0, 0}, // #924
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 2, false, false, 1621, 4,  3, 1,  0, 0}, // #925
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 2, false, false, 766, 9,  4, 1,  0, 0}, // #926
  {DBGFIELD("LRETQ")              3, false, false, 1794, 9,  4, 1,  0, 0}, // #927
  {DBGFIELD("CVTDQ2PSrm_VCVTDQ2PSrm") 2, false, false, 766, 9, 11, 1,  0, 0}, // #928
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 3, false, false, 1138, 13,  8, 1,  0, 0}, // #929
  {DBGFIELD("POPF64")             18, false, false, 2142, 9, 32, 1,  0, 0}, // #930
  {DBGFIELD("VGATHERQPDrm")       7, false, false, 2151, 12, 32, 1,  0, 0}, // #931
  {DBGFIELD("VGATHERQPDYrm")      9, false, false, 2163, 12, 33, 1,  0, 0}, // #932
  {DBGFIELD("VGATHERDPDrm")       7, false, false, 2151, 12, 34, 1,  0, 0}, // #933
  {DBGFIELD("VGATHERDPSrm")       7, false, false, 2151, 12, 34, 1,  0, 0}, // #934
  {DBGFIELD("VGATHERDPDYrm")      9, false, false, 2130, 12, 35, 1,  0, 0}, // #935
  {DBGFIELD("VGATHERDPSYrm")      14, false, false, 2175, 12, 35, 1,  0, 0}, // #936
  {DBGFIELD("PCMPEQQrr")          1, false, false, 712, 4,  1, 1,  0, 0}, // #937
  {DBGFIELD("PCMPEQQrm")          2, false, false, 843, 6,  5, 1, 11, 1}, // #938
  {DBGFIELD("MOV16rm")            1, false, false, 745, 3,  6, 1,  0, 0}, // #939
  {DBGFIELD("MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX") 1, false, false, 745, 3,  6, 1,  0, 0}, // #940
  {DBGFIELD("POP16rmm")           4, false, false, 756, 6,  5, 1,  0, 0}, // #941
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 4, false, false, 756, 6,  5, 1,  0, 0}, // #942
  {DBGFIELD("PUSHF16")            6, false, false, 1851, 5,  6, 1,  0, 0}, // #943
  {DBGFIELD("LAHF")               1, false, false, 730, 4,  1, 1,  0, 0}, // #944
  {DBGFIELD("ADD16mi_ADD16mi8_ADD16mr_ADD32mi_ADD32mi8_ADD32mr_ADD64mi32_ADD64mi8_ADD64mr_ADD8mi_ADD8mi8_ADD8mr_SUB16mi_SUB16mi8_SUB16mr_SUB32mi_SUB32mi8_SUB32mr_SUB64mi32_SUB64mi8_SUB64mr_SUB8mi_SUB8mi8_SUB8mr") 3, false, false, 756, 6,  4, 1,  0, 0}, // #945
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 6, false, false, 716, 8, 11, 1,  0, 0}, // #946
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 3, false, false, 756, 6,  4, 1,  0, 0}, // #947
  {DBGFIELD("MULX32rr")           4, false, false, 1129, 9, 75, 2,  0, 0}, // #948
  {DBGFIELD("MULX32rm")           5, false, false, 1118, 11, 73, 2,  0, 0}, // #949
  {DBGFIELD("MULX64rr")           3, false, false, 1151, 11, 75, 2,  0, 0}, // #950
  {DBGFIELD("MULX64rm")           4, false, false, 1138, 13, 73, 2,  0, 0}, // #951
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 4, false, false, 1841, 10, 22, 1,  0, 0}, // #952
  {DBGFIELD("RETW_LRETL_LRETW")   2, false, false, 724, 6,  5, 1,  0, 0}, // #953
  {DBGFIELD("IRET16_IRET32_IRET64") 2, false, false, 724, 6,  5, 1,  0, 0}, // #954
  {DBGFIELD("AND16mi_AND16mi8_AND16mr_AND32mi_AND32mi8_AND32mr_AND64mi32_AND64mi8_AND64mr_AND8mi_AND8mi8_AND8mr_OR16mi_OR16mi8_OR16mr_OR32mi_OR32mi8_OR32mi8Locked_OR32mr_OR64mi32_OR64mi8_OR64mr_OR8mi_OR8mi8_OR8mr_XOR16mi_XOR16mi8_XOR16mr_XOR32mi_XOR32mi8_XOR32mr_XOR64mi32_XOR64mi8_XOR64mr_XOR8mi_XOR8mi8_XOR8mr") 3, false, false, 756, 6,  4, 1,  0, 0}, // #955
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 4, false, false, 1374, 9,  8, 1,  0, 0}, // #956
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 4, false, false, 1093, 9,  5, 1,  0, 0}, // #957
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 6, false, false, 1363, 11,  9, 1,  0, 0}, // #958
  {DBGFIELD("MOVSLDUPrm")         1, false, false, 745, 3,  6, 1,  0, 0}, // #959
  {DBGFIELD("MOVSLDUPrr")         1, false, false, 748, 8,  1, 1,  0, 0}, // #960
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 3, false, false, 994, 2,  3, 1,  0, 0}, // #961
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, 748, 8,  1, 1,  0, 0}, // #962
  {DBGFIELD("VPMOVSXBDYrr_VPMOVSXBQYrr_VPMOVSXBWYrr_VPMOVSXDQYrr_VPMOVSXWDYrr_VPMOVSXWQYrr_VPMOVZXBDYrr_VPMOVZXBQYrr_VPMOVZXBWYrr_VPMOVZXDQYrr_VPMOVZXWDYrr_VPMOVZXWQYrr") 1, false, false, 748, 8, 22, 1,  0, 0}, // #963
  {DBGFIELD("VPMOVZXBDYrm_VPMOVZXBQYrm_VPMOVZXBWYrm_VPMOVZXDQYrm_VPMOVZXWQYrm") 2, false, false, 775, 10,  8, 1,  0, 0}, // #964
  {DBGFIELD("PBLENDWrri_VPBLENDWrri") 1, false, false, 748, 8,  1, 1,  0, 0}, // #965
  {DBGFIELD("VPBLENDWYrri")       1, false, false, 748, 8,  1, 1,  0, 0}, // #966
  {DBGFIELD("PBLENDWrmi_VPBLENDWrmi") 2, false, false, 775, 10,  5, 1, 11, 1}, // #967
  {DBGFIELD("VPBLENDWYrmi")       2, false, false, 775, 10,  4, 1, 24, 1}, // #968
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, 748, 8,  1, 1,  0, 0}, // #969
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 2, false, false, 741, 4,  1, 1,  0, 0}, // #970
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 2, false, false, 741, 4,  1, 1,  0, 0}, // #971
  {DBGFIELD("VPMASKMOVDYrm")      3, false, false, 785, 10, 11, 1,  0, 0}, // #972
  {DBGFIELD("VPMASKMOVDrm")       3, false, false, 785, 10,  4, 1,  0, 0}, // #973
  {DBGFIELD("VPMASKMOVDYmr_VPMASKMOVQYmr") 4, false, false, 1491, 12,  6, 1,  0, 0}, // #974
  {DBGFIELD("VPMASKMOVDmr_VPMASKMOVQmr") 4, false, false, 1491, 12,  6, 1,  0, 0}, // #975
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 3, false, false, 1976, 10,  8, 1,  0, 0}, // #976
  {DBGFIELD("VPSLLDQri_VPSRLDQri") 1, false, false, 748, 8,  1, 1,  0, 0}, // #977
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri") 1, false, false, 748, 8,  1, 1,  0, 0}, // #978
  {DBGFIELD("VPERM2F128rr")       1, false, false, 748, 8, 22, 1,  0, 0}, // #979
  {DBGFIELD("VPERM2F128rm")       2, false, false, 775, 10,  8, 1, 24, 1}, // #980
  {DBGFIELD("VEXTRACTF128rr")     1, false, false, 748, 8, 22, 1,  0, 0}, // #981
  {DBGFIELD("VEXTRACTF128mr")     2, false, false, 741, 4,  1, 1,  0, 0}, // #982
  {DBGFIELD("VINSERTF128rr")      1, false, false, 748, 8, 22, 1,  0, 0}, // #983
  {DBGFIELD("VCVTPD2DQrm_VCVTTPD2DQrm") 2, false, false, 766, 9, 11, 1,  0, 0}, // #984
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 2, false, false, 766, 9, 11, 1,  0, 0}, // #985
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, 1650, 12, 23, 1,  0, 0}, // #986
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, 1919, 14,  8, 1,  0, 0}, // #987
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, 712, 4,  1, 1,  0, 0}, // #988
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, 712, 4,  1, 1,  0, 0}, // #989
  {DBGFIELD("SHA256MSG2rm")       2, false, false, 903, 11, 19, 1, 11, 1}, // #990
  {DBGFIELD("SHA256MSG2rr")       1, false, false, 893, 9,  6, 1,  0, 0}, // #991
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, 893, 9,  6, 1,  0, 0}, // #992
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 2, false, false, 903, 11, 19, 1, 11, 1}, // #993
  {DBGFIELD("SHA1MSG2rr")         1, false, false, 893, 9,  6, 1,  0, 0}, // #994
  {DBGFIELD("SHA1MSG2rm")         2, false, false, 903, 11, 19, 1, 11, 1}, // #995
  {DBGFIELD("SHA1NEXTErr")        1, false, false, 893, 9,  6, 1,  0, 0}, // #996
  {DBGFIELD("SHA1NEXTErm")        2, false, false, 903, 11, 19, 1, 11, 1}, // #997
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, 893, 9,  6, 1,  0, 0}, // #998
  {DBGFIELD("SHA1RNDS4rmi")       2, false, false, 903, 11, 19, 1, 11, 1}, // #999
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, 893, 9,  6, 1,  0, 0}, // #1000
  {DBGFIELD("SHA256RNDS2rm")      2, false, false, 903, 11, 19, 1, 11, 1}, // #1001
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 3, false, false, 994, 2,  3, 1,  0, 0}, // #1002
  {DBGFIELD("BT16mi8_BT32mi8_BT64mi8") 2, false, false, 724, 6,  5, 1,  0, 0}, // #1003
  {DBGFIELD("BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 1, false, false, 730, 4,  1, 1,  0, 0}, // #1004
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 1, false, false, 714, 2,  2, 1,  0, 0}, // #1005
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 3, false, false, 756, 6,  4, 1,  0, 0}, // #1006
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 1, false, false, 714, 2,  1, 1,  0, 0}, // #1007
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 2, false, false, 762, 4,  5, 1,  0, 0}, // #1008
  {DBGFIELD("ADC64ri32_SBB64ri32") 1, false, false, 730, 4,  1, 1,  0, 0}, // #1009
  {DBGFIELD("CRC32r32r16")        1, false, false, 734, 7, 22, 1,  0, 0}, // #1010
  {DBGFIELD("CRC32r32r32")        1, false, false, 734, 7, 22, 1,  0, 0}, // #1011
  {DBGFIELD("CRC32r64r64")        1, false, false, 734, 7, 22, 1,  0, 0}, // #1012
  {DBGFIELD("SAHF")               1, false, false, 730, 4,  1, 1,  0, 0}, // #1013
  {DBGFIELD("BEXTRI32ri_BEXTRI64ri") 2, false, false, 837, 6,  3, 1,  0, 0}, // #1014
  {DBGFIELD("BEXTRI32mi_BEXTRI64mi") 3, false, false, 829, 8,  4, 1,  0, 0}, // #1015
  {DBGFIELD("RCR8ri")             3, false, false, 1816, 4, 22, 1,  0, 0}, // #1016
  {DBGFIELD("RCL16rCL")           7, false, false, 2038, 9,  9, 1,  0, 0}, // #1017
  {DBGFIELD("RCR16ri")            3, false, false, 1816, 4, 22, 1,  0, 0}, // #1018
  {DBGFIELD("RCL32rCL_RCL64rCL")  7, false, false, 2038, 9,  9, 1,  0, 0}, // #1019
  {DBGFIELD("RCR32rCL_RCR64rCL")  7, false, false, 2038, 9,  9, 1,  0, 0}, // #1020
  {DBGFIELD("RCR32ri_RCR64ri")    3, false, false, 1816, 4, 22, 1,  0, 0}, // #1021
  {DBGFIELD("RCL16ri")            3, false, false, 1816, 4, 22, 1,  0, 0}, // #1022
  {DBGFIELD("RCL32ri_RCL64ri")    3, false, false, 1816, 4, 22, 1,  0, 0}, // #1023
  {DBGFIELD("SHLD32rri8")         1, false, false, 734, 7, 22, 1,  0, 0}, // #1024
  {DBGFIELD("SHRD16rri8")         1, false, false, 734, 7, 22, 1,  0, 0}, // #1025
  {DBGFIELD("SHLD16rrCL")         4, false, false, 1093, 9,  5, 1,  0, 0}, // #1026
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 2, false, false, 741, 4,  1, 1,  0, 0}, // #1027
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 2, false, false, 741, 4,  1, 1,  0, 0}, // #1028
  {DBGFIELD("TST_F")              1, false, false, 734, 7, 22, 1,  0, 0}, // #1029
  {DBGFIELD("VDPPSrri")           4, false, false, 1012, 14, 21, 1,  0, 0}, // #1030
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr") 1, false, false, 745, 3,  5, 1,  0, 0}, // #1031
  {DBGFIELD("VFRCZSDrr_VFRCZSSrr") 1, false, false, 745, 3,  5, 1,  0, 0}, // #1032
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 3, false, false, 1347, 9,  9, 1, 11, 1}, // #1033
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 1, false, false, 745, 3,  5, 1,  0, 0}, // #1034
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 3, false, false, 1347, 9, 20, 1, 24, 1}, // #1035
  {DBGFIELD("MMX_CVTTPD2PIirr")   2, false, false, 1151, 11, 23, 1,  0, 0}, // #1036
  {DBGFIELD("VMOVDQUYmr")         2, false, false, 741, 4,  1, 1,  0, 0}, // #1037
  {DBGFIELD("MOVDQArr")           1, false, false, 713, 3,  1, 1,  0, 0}, // #1038
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 2, false, false, 1315, 9, 19, 1,  0, 0}, // #1039
  {DBGFIELD("VMPSADBWrri")        3, false, false, 1214, 12,  4, 1,  0, 0}, // #1040
  {DBGFIELD("VPPERMrrr_VPPERMrrr_REV") 1, false, false, 748, 8,  1, 1,  0, 0}, // #1041
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 3, false, false, 1192, 8, 22, 1,  0, 0}, // #1042
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 4, false, false, 1182, 10, 11, 1, 11, 1}, // #1043
  {DBGFIELD("VPCLMULQDQrr")       1, false, false, 893, 9,  6, 1,  0, 0}, // #1044
  {DBGFIELD("INSERTQ")            1, false, false, 712, 4,  1, 1,  0, 0}, // #1045
  {DBGFIELD("ANDNPSrr_VANDNPSrr_ANDNPDrr_VANDNPDrr") 1, false, false, 748, 8,  1, 1,  0, 0}, // #1046
  {DBGFIELD("MMX_PXORirr_MMX_PANDNirr") 1, false, false, 713, 3,  1, 1,  0, 0}, // #1047
  {DBGFIELD("PANDNrr_VPANDNrr")   1, false, false, 713, 3,  1, 1,  0, 0}, // #1048
  {DBGFIELD("MMX_PSUBBirr_MMX_PSUBDirr_MMX_PSUBWirr_MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 1, false, false, 712, 4,  1, 1,  0, 0}, // #1049
  {DBGFIELD("LCMPXCHG8_LCMPXCHG16_LCMPXCHG32_LCMPXCHG64") 6, false, false, 716, 8, 11, 1,  0, 0}, // #1050
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 5, false, false, 857, 4,  6, 1,  0, 0}, // #1051
  {DBGFIELD("LCMPXCHG8B_LCMPXCHG16B") 6, false, false, 716, 8, 11, 1,  0, 0}, // #1052
  {DBGFIELD("XCHG8rr")            3, false, false, 994, 2,  3, 1,  0, 0}, // #1053
  {DBGFIELD("VANDNPSYrr_VANDNPDYrr") 1, false, false, 748, 8,  1, 1,  0, 0}, // #1054
  {DBGFIELD("MMX_PSUBSBirr_MMX_PSUBSWirr_MMX_PSUBUSBirr_MMX_PSUBUSWirr") 1, false, false, 712, 4,  1, 1,  0, 0}, // #1055
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false, 712, 4,  1, 1,  0, 0}, // #1056
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false, 712, 4,  1, 1,  0, 0}, // #1057
  {DBGFIELD("LEA16r")             1, false, false, 712, 4,  1, 1,  0, 0}, // #1058
  {DBGFIELD("MMX_PADDSBirr_MMX_PADDSWirr_MMX_PADDUSBirr_MMX_PADDUSWirr_MMX_PAVGBirr_MMX_PAVGWirr_MMX_PCMPEQBirr_MMX_PCMPEQDirr_MMX_PCMPEQWirr_MMX_PMAXSWirr_MMX_PMINSWirr_MMX_PMAXUBirr_MMX_PMINUBirr") 1, false, false, 712, 4,  1, 1,  0, 0}, // #1059
  {DBGFIELD("MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 1, false, false, 712, 4,  1, 1,  0, 0}, // #1060
  {DBGFIELD("CLAC_STAC")          1, false, false, 714, 2,  2, 1,  0, 0}, // #1061
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, 712, 4,  1, 1,  0, 0}, // #1062
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr") 1, false, false, 712, 4,  1, 1,  0, 0}, // #1063
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, 734, 7, 22, 1,  0, 0}, // #1064
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 3, false, false, 1192, 8, 22, 1,  0, 0}, // #1065
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, 1192, 8, 22, 1,  0, 0}, // #1066
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 3, false, false, 1192, 8, 22, 1,  0, 0}, // #1067
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, 734, 7, 22, 1,  0, 0}, // #1068
  {DBGFIELD("VCVTPS2DQYrr_VCVTTPS2DQYrr") 1, false, false, 734, 7, 22, 1,  0, 0}, // #1069
  {DBGFIELD("MMX_PADDSBirm_MMX_PADDSWirm_MMX_PADDUSBirm_MMX_PADDUSWirm_MMX_PAVGBirm_MMX_PAVGWirm_MMX_PCMPEQBirm_MMX_PCMPEQDirm_MMX_PCMPEQWirm_MMX_PCMPGTBirm_MMX_PCMPGTDirm_MMX_PCMPGTWirm_MMX_PMAXSWirm_MMX_PMAXUBirm_MMX_PMINSWirm_MMX_PMINUBirm_MMX_PSUBSBirm_MMX_PSUBSWirm_MMX_PSUBUSBirm_MMX_PSUBUSWirm") 2, false, false, 843, 6,  5, 1, 11, 1}, // #1070
  {DBGFIELD("CVTSS2SI64rr_Int")   2, false, false, 1650, 12, 23, 1,  0, 0}, // #1071
  {DBGFIELD("CVTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int") 2, false, false, 1650, 12, 23, 1,  0, 0}, // #1072
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 2, false, false, 843, 6,  5, 1, 11, 1}, // #1073
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 2, false, false, 843, 6,  4, 1, 24, 1}, // #1074
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 4, false, false, 1182, 10, 11, 1, 11, 1}, // #1075
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, 1182, 10, 11, 1, 11, 1}, // #1076
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 4, false, false, 1182, 10,  8, 1, 24, 1}, // #1077
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 28, false, false, 2076, 11, 37, 1,  0, 0}, // #1078
  {DBGFIELD("PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1079
  {DBGFIELD("VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1080
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, 713, 3,  1, 1,  0, 0}, // #1081
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, 714, 2,  1, 1,  0, 0}, // #1082
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, 714, 2,  1, 1,  0, 0}, // #1083
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 2, false, false, 795, 8,  3, 1,  0, 0}, // #1084
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 2, false, false, 795, 8,  3, 1,  0, 0}, // #1085
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, 712, 4,  1, 1,  0, 0}, // #1086
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 1, false, false, 712, 4,  1, 1,  0, 0}, // #1087
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1088
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 2, false, false, 795, 8,  3, 1,  0, 0}, // #1089
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 2, false, false, 795, 8,  3, 1,  0, 0}, // #1090
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false, 741, 4,  1, 1,  0, 0}, // #1091
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 2, false, false, 741, 4,  1, 1,  0, 0}, // #1092
  {DBGFIELD("KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, 714, 2,  1, 1,  0, 0}, // #1093
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, 713, 3,  1, 1,  0, 0}, // #1094
  {DBGFIELD("VPSADBWZrr")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #1095
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_VPTESTMBZ128rr_VPTESTMBZ128rrk_VPTESTMDZ128rr_VPTESTMDZ128rrk_VPTESTMQZ128rr_VPTESTMQZ128rrk_VPTESTMWZ128rr_VPTESTMWZ128rrk_VPTESTNMBZ128rr_VPTESTNMBZ128rrk_VPTESTNMDZ128rr_VPTESTNMDZ128rrk_VPTESTNMQZ128rr_VPTESTNMQZ128rrk_VPTESTNMWZ128rr_VPTESTNMWZ128rrk") 1, false, false, 713, 3,  1, 1,  0, 0}, // #1096
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri_KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, 748, 8,  1, 1,  0, 0}, // #1097
  {DBGFIELD("VALIGNDZ128rri_VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rri_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, 748, 8,  1, 1,  0, 0}, // #1098
  {DBGFIELD("VALIGNDZ256rri_VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rri_VALIGNQZ256rrik_VALIGNQZ256rrikz") 1, false, false, 748, 8,  1, 1,  0, 0}, // #1099
  {DBGFIELD("VALIGNDZrri_VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrri_VALIGNQZrrik_VALIGNQZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1100
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, 734, 7, 22, 1,  0, 0}, // #1101
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 1, false, false, 734, 7, 22, 1,  0, 0}, // #1102
  {DBGFIELD("VCMPPDZrri_VCMPPDZrrib_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrrib_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1103
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, 734, 7, 22, 1,  0, 0}, // #1104
  {DBGFIELD("VDBPSADBWZrri_VDBPSADBWZrrik_VDBPSADBWZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1105
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rrik_VPCMPDZ128rri_VPCMPDZ128rrik_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rrik_VPCMPUBZ128rri_VPCMPUBZ128rrik_VPCMPUDZ128rri_VPCMPUDZ128rrik_VPCMPUQZ128rri_VPCMPUQZ128rrik_VPCMPUWZ128rri_VPCMPUWZ128rrik_VPCMPWZ128rri_VPCMPWZ128rrik_VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, 712, 4,  1, 1,  0, 0}, // #1106
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rrik_VPCMPDZ256rri_VPCMPDZ256rrik_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rrik_VPCMPUBZ256rri_VPCMPUBZ256rrik_VPCMPUDZ256rri_VPCMPUDZ256rrik_VPCMPUQZ256rri_VPCMPUQZ256rrik_VPCMPUWZ256rri_VPCMPUWZ256rrik_VPCMPWZ256rri_VPCMPWZ256rrik_VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 1, false, false, 712, 4,  1, 1,  0, 0}, // #1107
  {DBGFIELD("VPCMPBZrri_VPCMPBZrrik_VPCMPDZrri_VPCMPDZrrik_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrrik_VPCMPUBZrri_VPCMPUBZrrik_VPCMPUDZrri_VPCMPUDZrrik_VPCMPUQZrri_VPCMPUQZrrik_VPCMPUWZrri_VPCMPUWZrrik_VPCMPWZrri_VPCMPWZrrik_VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1108
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 1, false, false, 713, 3,  1, 1,  0, 0}, // #1109
  {DBGFIELD("VPTESTMBZrr_VPTESTMBZrrk_VPTESTMDZrr_VPTESTMDZrrk_VPTESTMQZrr_VPTESTMQZrrk_VPTESTMWZrr_VPTESTMWZrrk_VPTESTNMBZrr_VPTESTNMBZrrk_VPTESTNMDZrr_VPTESTNMDZrrk_VPTESTNMQZrr_VPTESTNMQZrrk_VPTESTNMWZrr_VPTESTNMWZrrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1110
  {DBGFIELD("VCVTDQ2PSZ128rr_VCVTDQ2PSZ128rrk_VCVTDQ2PSZ128rrkz_VCVTUDQ2PSZ128rr_VCVTUDQ2PSZ128rrk_VCVTUDQ2PSZ128rrkz") 1, false, false, 734, 7, 23, 1,  0, 0}, // #1111
  {DBGFIELD("VCVTDQ2PSZ256rr_VCVTDQ2PSZ256rrk_VCVTDQ2PSZ256rrkz_VCVTUDQ2PSZ256rr_VCVTUDQ2PSZ256rrk_VCVTUDQ2PSZ256rrkz") 1, false, false, 734, 7, 23, 1,  0, 0}, // #1112
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 1, false, false, 734, 7, 22, 1,  0, 0}, // #1113
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 1, false, false, 734, 7, 22, 1,  0, 0}, // #1114
  {DBGFIELD("VCVTPS2DQYrr")       1, false, false, 734, 7, 22, 1,  0, 0}, // #1115
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, 734, 7, 22, 1,  0, 0}, // #1116
  {DBGFIELD("VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 1, false, false, 734, 7, 22, 1,  0, 0}, // #1117
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 1, false, false, 734, 7, 23, 1,  0, 0}, // #1118
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 1, false, false, 734, 7, 23, 1,  0, 0}, // #1119
  {DBGFIELD("VCVTDQ2PSZrr_VCVTUDQ2PSZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1120
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1121
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1122
  {DBGFIELD("VCVTQQ2PDZrr_VCVTUQQ2PDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1123
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 1, false, false, 748, 8, 22, 1,  0, 0}, // #1124
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 1, false, false, 748, 8, 22, 1,  0, 0}, // #1125
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 2, false, false, 775, 10,  8, 1,  0, 0}, // #1126
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 1, false, false, 734, 7, 23, 1,  0, 0}, // #1127
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 1, false, false, 734, 7, 22, 1,  0, 0}, // #1128
  {DBGFIELD("VCVTPD2PSZ128rr_VCVTPD2PSZ128rrk_VCVTPD2PSZ128rrkz") 1, false, false, 734, 7, 22, 1,  0, 0}, // #1129
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz") 1, false, false, 734, 7, 22, 1,  0, 0}, // #1130
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false, 734, 7, 22, 1,  0, 0}, // #1131
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false, 734, 7, 23, 1,  0, 0}, // #1132
  {DBGFIELD("VCVTSD2SSZrr_VCVTSD2SSZrr_Int_VCVTSD2SSZrr_Intk_VCVTSD2SSZrr_Intkz_VCVTSD2SSZrrb_Int_VCVTSD2SSZrrb_Intk_VCVTSD2SSZrrb_Intkz") 1, false, false, 734, 7, 22, 1,  0, 0}, // #1133
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 1, false, false, 734, 7, 23, 1,  3, 1}, // #1134
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 1, false, false, 734, 7, 23, 1,  3, 1}, // #1135
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz") 1, false, false, 734, 7, 22, 1,  0, 0}, // #1136
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, 712, 4,  1, 1,  0, 0}, // #1137
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 3, false, false, 1437, 10,  6, 1,  0, 0}, // #1138
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 3, false, false, 1437, 10,  4, 1,  0, 0}, // #1139
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1140
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 2, false, false, 775, 10,  8, 1,  0, 0}, // #1141
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 1, false, false, 748, 8, 22, 1,  0, 0}, // #1142
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 1, false, false, 745, 3,  6, 1,  0, 0}, // #1143
  {DBGFIELD("VMOVDI2PDIZrm")      1, false, false, 745, 3,  6, 1,  0, 0}, // #1144
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 1, false, false, 734, 7, 23, 1,  3, 1}, // #1145
  {DBGFIELD("VMOVSDZrm_VMOVSDZrm_alt_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrm_alt_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, 745, 3,  6, 1,  0, 0}, // #1146
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 1, false, false, 734, 7, 23, 1,  0, 0}, // #1147
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 1, false, false, 734, 7, 22, 1,  0, 0}, // #1148
  {DBGFIELD("VCVTPD2PSZ256rr_VCVTPD2PSZ256rrk_VCVTPD2PSZ256rrkz") 1, false, false, 734, 7, 22, 1,  0, 0}, // #1149
  {DBGFIELD("VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 1, false, false, 734, 7, 22, 1,  0, 0}, // #1150
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 1, false, false, 734, 7, 22, 1,  0, 0}, // #1151
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 1, false, false, 734, 7, 23, 1,  0, 0}, // #1152
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1153
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1154
  {DBGFIELD("VCVTPD2PSZrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1155
  {DBGFIELD("VCVTPS2PDZrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1156
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1157
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1158
  {DBGFIELD("VMOVNTDQAZ128rm")    1, false, false, 745, 3,  6, 1,  0, 0}, // #1159
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 3, false, false, 785, 10,  4, 1, 11, 1}, // #1160
  {DBGFIELD("VBROADCASTI32X2Z128m_VBROADCASTI32X2Z128mk_VBROADCASTI32X2Z128mkz_VPBROADCASTDZ128m_VPBROADCASTDZ128mk_VPBROADCASTDZ128mkz_VPBROADCASTQZ128m_VPBROADCASTQZ128mk_VPBROADCASTQZ128mkz") 2, false, false, 775, 10,  5, 1,  0, 0}, // #1161
  {DBGFIELD("VBROADCASTSSZ128m_VBROADCASTSSZ128mk_VBROADCASTSSZ128mkz") 2, false, false, 775, 10,  8, 1,  0, 0}, // #1162
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, 745, 3,  6, 1,  0, 0}, // #1163
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 2, false, false, 775, 10,  5, 1,  0, 0}, // #1164
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, 745, 3,  6, 1,  0, 0}, // #1165
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 2, false, false, 843, 6,  5, 1, 11, 1}, // #1166
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 3, false, false, 785, 10,  4, 1, 11, 1}, // #1167
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 1, false, false, 748, 8, 22, 1,  0, 0}, // #1168
  {DBGFIELD("VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 1, false, false, 734, 7, 22, 1,  0, 0}, // #1169
  {DBGFIELD("VCVTSS2SI64rr_Int")  2, false, false, 1650, 12, 23, 1,  0, 0}, // #1170
  {DBGFIELD("VCVTTSS2SI64rr")     2, false, false, 1650, 12, 23, 1,  0, 0}, // #1171
  {DBGFIELD("VCVTTSS2SI64rr_Int") 2, false, false, 1650, 12, 23, 1,  0, 0}, // #1172
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, 745, 3,  6, 1,  0, 0}, // #1173
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 2, false, false, 775, 10,  8, 1,  0, 0}, // #1174
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 1, false, false, 741, 4,  1, 1,  0, 0}, // #1175
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 1, false, false, 741, 4,  1, 1,  0, 0}, // #1176
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 1, false, false, 741, 4,  1, 1,  0, 0}, // #1177
  {DBGFIELD("VSCATTERDPSZmr")     1, false, false, 741, 4,  1, 1,  0, 0}, // #1178
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk") 2, false, false, 766, 9, 11, 1, 11, 1}, // #1179
  {DBGFIELD("VPBROADCASTBZ256m_VPBROADCASTBZ256mk_VPBROADCASTBZ256mkz_VPBROADCASTBZm_VPBROADCASTBZmk_VPBROADCASTBZmkz_VPBROADCASTWZ256m_VPBROADCASTWZ256mk_VPBROADCASTWZ256mkz_VPBROADCASTWZm_VPBROADCASTWZmk_VPBROADCASTWZmkz") 2, false, false, 775, 10,  8, 1,  0, 0}, // #1180
  {DBGFIELD("VMOVNTDQAZ256rm")    1, false, false, 745, 3,  5, 1,  0, 0}, // #1181
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 3, false, false, 785, 10, 11, 1, 24, 1}, // #1182
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1183
  {DBGFIELD("VBROADCASTF32X2Z256m_VBROADCASTF32X2Z256mk_VBROADCASTF32X2Z256mkz_VBROADCASTF32X2Zm_VBROADCASTF32X2Zmk_VBROADCASTF32X2Zmkz_VBROADCASTI32X2Z256m_VBROADCASTI32X2Z256mk_VBROADCASTI32X2Z256mkz_VBROADCASTI32X2Zm_VBROADCASTI32X2Zmk_VBROADCASTI32X2Zmkz_VPBROADCASTDZ256m_VPBROADCASTDZ256mk_VPBROADCASTDZ256mkz_VPBROADCASTDZm_VPBROADCASTDZmk_VPBROADCASTDZmkz_VPBROADCASTQZ256m_VPBROADCASTQZ256mk_VPBROADCASTQZ256mkz_VPBROADCASTQZm_VPBROADCASTQZmk_VPBROADCASTQZmkz") 2, false, false, 775, 10,  8, 1,  0, 0}, // #1184
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 2, false, false, 775, 10,  4, 1,  0, 0}, // #1185
  {DBGFIELD("VBROADCASTSDZ256m_VBROADCASTSDZ256mk_VBROADCASTSDZ256mkz_VBROADCASTSDZm_VBROADCASTSDZmk_VBROADCASTSDZmkz_VBROADCASTSSZ256m_VBROADCASTSSZ256mk_VBROADCASTSSZ256mkz_VBROADCASTSSZm_VBROADCASTSSZmk_VBROADCASTSSZmkz") 2, false, false, 775, 10,  8, 1,  0, 0}, // #1186
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 2, false, false, 775, 10,  8, 1, 24, 1}, // #1187
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 2, false, false, 775, 10,  8, 1, 24, 1}, // #1188
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 1, false, false, 745, 3,  5, 1,  0, 0}, // #1189
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, 775, 10,  4, 1,  0, 0}, // #1190
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1191
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 1, false, false, 745, 3,  5, 1,  0, 0}, // #1192
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 2, false, false, 843, 6,  4, 1, 24, 1}, // #1193
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1194
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 3, false, false, 785, 10, 11, 1, 24, 1}, // #1195
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1196
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 1, false, false, 741, 4,  1, 1,  0, 0}, // #1197
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 1, false, false, 741, 4,  1, 1,  0, 0}, // #1198
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 1, false, false, 741, 4,  1, 1,  0, 0}, // #1199
  {DBGFIELD("VPSCATTERDDZmr")     1, false, false, 741, 4,  1, 1,  0, 0}, // #1200
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 2, false, false, 775, 10,  5, 1, 11, 1}, // #1201
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmik") 2, false, false, 766, 9, 11, 1, 11, 1}, // #1202
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 2, false, false, 766, 9, 11, 1, 11, 1}, // #1203
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmik_VPCMPDZ128rmi_VPCMPDZ128rmib_VPCMPDZ128rmibk_VPCMPDZ128rmik_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmib_VPCMPQZ128rmibk_VPCMPQZ128rmik_VPCMPUBZ128rmi_VPCMPUBZ128rmik_VPCMPUDZ128rmi_VPCMPUDZ128rmib_VPCMPUDZ128rmibk_VPCMPUDZ128rmik_VPCMPUQZ128rmi_VPCMPUQZ128rmib_VPCMPUQZ128rmibk_VPCMPUQZ128rmik_VPCMPUWZ128rmi_VPCMPUWZ128rmik_VPCMPWZ128rmi_VPCMPWZ128rmik_VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 2, false, false, 843, 6,  5, 1, 11, 1}, // #1204
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 2, false, false, 775, 10,  8, 1, 24, 1}, // #1205
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 2, false, false, 775, 10,  8, 1, 24, 1}, // #1206
  {DBGFIELD("VPMOVSXBDZ128rm_VPMOVSXBDZ128rmk_VPMOVSXBDZ128rmkz_VPMOVSXBQZ128rm_VPMOVSXBQZ128rmk_VPMOVSXBQZ128rmkz_VPMOVSXBWZ128rm_VPMOVSXBWZ128rmk_VPMOVSXBWZ128rmkz_VPMOVSXDQZ128rm_VPMOVSXDQZ128rmk_VPMOVSXDQZ128rmkz_VPMOVSXWDZ128rm_VPMOVSXWDZ128rmk_VPMOVSXWDZ128rmkz_VPMOVSXWQZ128rm_VPMOVSXWQZ128rmk_VPMOVSXWQZ128rmkz_VPMOVZXBDZ128rm_VPMOVZXBDZ128rmk_VPMOVZXBDZ128rmkz_VPMOVZXBQZ128rm_VPMOVZXBQZ128rmk_VPMOVZXBQZ128rmkz_VPMOVZXBWZ128rm_VPMOVZXBWZ128rmk_VPMOVZXBWZ128rmkz_VPMOVZXDQZ128rm_VPMOVZXDQZ128rmk_VPMOVZXDQZ128rmkz_VPMOVZXWDZ128rm_VPMOVZXWDZ128rmk_VPMOVZXWDZ128rmkz_VPMOVZXWQZ128rm_VPMOVZXWQZ128rmk_VPMOVZXWQZ128rmkz") 2, false, false, 775, 10,  8, 1,  0, 0}, // #1207
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 2, false, false, 770, 5,  5, 1, 11, 1}, // #1208
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 2, false, false, 775, 10,  4, 1, 24, 1}, // #1209
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1210
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmik") 2, false, false, 766, 9,  8, 1, 24, 1}, // #1211
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmik") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1212
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmik_VPCMPDZ256rmi_VPCMPDZ256rmib_VPCMPDZ256rmibk_VPCMPDZ256rmik_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmib_VPCMPQZ256rmibk_VPCMPQZ256rmik_VPCMPUBZ256rmi_VPCMPUBZ256rmik_VPCMPUDZ256rmi_VPCMPUDZ256rmib_VPCMPUDZ256rmibk_VPCMPUDZ256rmik_VPCMPUQZ256rmi_VPCMPUQZ256rmib_VPCMPUQZ256rmibk_VPCMPUQZ256rmik_VPCMPUWZ256rmi_VPCMPUWZ256rmik_VPCMPWZ256rmi_VPCMPWZ256rmik_VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 2, false, false, 843, 6,  4, 1, 24, 1}, // #1213
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmik_VPCMPDZrmi_VPCMPDZrmib_VPCMPDZrmibk_VPCMPDZrmik_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmib_VPCMPQZrmibk_VPCMPQZrmik_VPCMPUBZrmi_VPCMPUBZrmik_VPCMPUDZrmi_VPCMPUDZrmib_VPCMPUDZrmibk_VPCMPUDZrmik_VPCMPUQZrmi_VPCMPUQZrmib_VPCMPUQZrmibk_VPCMPUQZrmik_VPCMPUWZrmi_VPCMPUWZrmik_VPCMPWZrmi_VPCMPWZrmik_VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1214
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 2, false, false, 770, 5,  4, 1, 24, 1}, // #1215
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1216
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 2, false, false, 766, 9,  8, 1,  0, 0}, // #1217
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 2, false, false, 766, 9,  8, 1,  0, 0}, // #1218
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 2, false, false, 766, 9, 11, 1,  0, 0}, // #1219
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 2, false, false, 903, 11,  5, 1,  0, 0}, // #1220
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 2, false, false, 766, 9, 11, 1,  0, 0}, // #1221
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 2, false, false, 766, 9, 11, 1,  0, 0}, // #1222
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz") 2, false, false, 766, 9, 11, 1, 11, 1}, // #1223
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 2, false, false, 775, 10,  8, 1, 24, 1}, // #1224
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 2, false, false, 766, 9,  8, 1,  0, 0}, // #1225
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1226
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 2, false, false, 766, 9,  8, 1,  0, 0}, // #1227
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1228
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 2, false, false, 903, 11,  5, 1,  0, 0}, // #1229
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1230
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 2, false, false, 766, 9, 11, 1,  0, 0}, // #1231
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1232
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 2, false, false, 766, 9, 11, 1,  0, 0}, // #1233
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1234
  {DBGFIELD("VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 2, false, false, 766, 9, 11, 1,  0, 0}, // #1235
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1236
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 2, false, false, 775, 10,  8, 1, 24, 1}, // #1237
  {DBGFIELD("VCVTSD2SSZrm_VCVTSD2SSZrm_Int_VCVTSD2SSZrm_Intk_VCVTSD2SSZrm_Intkz") 2, false, false, 766, 9, 11, 1, 11, 1}, // #1238
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 2, false, false, 843, 6,  5, 1,  0, 0}, // #1239
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, 893, 9,  6, 1,  0, 0}, // #1240
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 1, false, false, 893, 9,  6, 1,  0, 0}, // #1241
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1242
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 2, false, false, 775, 10,  8, 1, 24, 1}, // #1243
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 2, false, false, 766, 9, 11, 1, 11, 1}, // #1244
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 2, false, false, 766, 9, 11, 1, 11, 1}, // #1245
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1246
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 2, false, false, 775, 10,  8, 1, 24, 1}, // #1247
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 2, false, false, 775, 10,  8, 1, 24, 1}, // #1248
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1249
  {DBGFIELD("VCVTPD2PSZrm_VCVTPD2PSZrmb_VCVTPD2PSZrmbk_VCVTPD2PSZrmbkz_VCVTPD2PSZrmk_VCVTPD2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1250
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1251
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 2, false, false, 775, 10,  8, 1, 24, 1}, // #1252
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 2, false, false, 843, 6,  5, 1,  0, 0}, // #1253
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 2, false, false, 903, 11, 19, 1, 11, 1}, // #1254
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 2, false, false, 903, 11,  9, 1, 24, 1}, // #1255
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1256
  {DBGFIELD("VGATHERDPSZ128rm_VGATHERQPSZrm_VPGATHERDDZ128rm") 1, false, false, 745, 3,  6, 1,  0, 0}, // #1257
  {DBGFIELD("VGATHERQPSZ128rm_VGATHERQPSZ256rm_VPGATHERQDZ128rm_VPGATHERQDZ256rm") 1, false, false, 745, 3,  6, 1,  0, 0}, // #1258
  {DBGFIELD("VGATHERDPDZ128rm_VGATHERQPDZ128rm_VPGATHERDQZ128rm_VPGATHERQQZ128rm") 1, false, false, 745, 3,  6, 1,  0, 0}, // #1259
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz") 1, false, false, 712, 4,  1, 1,  0, 0}, // #1260
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 1, false, false, 712, 4,  1, 1,  0, 0}, // #1261
  {DBGFIELD("VGATHERDPDZ256rm_VGATHERQPDZ256rm_VPGATHERDQZ256rm_VPGATHERQDZrm_VPGATHERQQZ256rm") 1, false, false, 745, 3,  6, 1,  0, 0}, // #1262
  {DBGFIELD("VGATHERDPDZrm_VGATHERQPDZrm_VPGATHERDQZrm_VPGATHERQQZrm") 1, false, false, 745, 3,  6, 1,  0, 0}, // #1263
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm") 1, false, false, 745, 3,  6, 1,  0, 0}, // #1264
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 2, false, false, 843, 6,  4, 1,  0, 0}, // #1265
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 1, false, false, 745, 3,  6, 1,  0, 0}, // #1266
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz") 1, false, false, 712, 4,  1, 1,  0, 0}, // #1267
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1268
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 2, false, false, 843, 6,  4, 1,  0, 0}, // #1269
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1270
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1271
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1272
  {DBGFIELD("VXORPSZ128rr_VXORPDZ128rr") 1, false, false, 748, 8,  1, 1,  0, 0}, // #1273
  {DBGFIELD("VXORPSZ256rr_VXORPDZ256rr") 1, false, false, 748, 8,  1, 1,  0, 0}, // #1274
  {DBGFIELD("VXORPSZrr_VXORPDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1275
  {DBGFIELD("VPXORDZ128rr_VPXORQZ128rr") 1, false, false, 713, 3,  1, 1,  0, 0}, // #1276
  {DBGFIELD("VPXORDZ256rr_VPXORQZ256rr") 1, false, false, 713, 3,  1, 1,  0, 0}, // #1277
  {DBGFIELD("VPXORDZrr_VPXORQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1278
  {DBGFIELD("VPSUBBZ128rr_VPSUBDZ128rr_VPSUBQZ128rr_VPSUBWZ128rr") 1, false, false, 712, 4,  1, 1,  0, 0}, // #1279
  {DBGFIELD("VPSUBBZ256rr_VPSUBDZ256rr_VPSUBQZ256rr_VPSUBWZ256rr") 1, false, false, 712, 4,  1, 1,  0, 0}, // #1280
  {DBGFIELD("VPSUBBZrr_VPSUBDZrr_VPSUBQZrr_VPSUBWZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1281
  {DBGFIELD("PdWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1282
  {DBGFIELD("WriteVecALU")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1283
  {DBGFIELD("JWriteZeroLatency")  0, false, false,  0, 0,  0, 0,  0, 0}, // #1284
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1285
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1286
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1287
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1288
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1289
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1290
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1291
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1292
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1293
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1294
  {DBGFIELD("JWriteLOCK_CMPXCHG8B") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1295
  {DBGFIELD("JWriteLOCK_CMPXCHG16B") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1296
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1297
  {DBGFIELD("JWriteLOCK_CMPXCHGrm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1298
  {DBGFIELD("JWriteCMPXCHG8B")    0, false, false,  0, 0,  0, 0,  0, 0}, // #1299
  {DBGFIELD("JWriteCMPXCHG16B")   0, false, false,  0, 0,  0, 0,  0, 0}, // #1300
  {DBGFIELD("JWriteCMPXCHG8rm")   0, false, false,  0, 0,  0, 0,  0, 0}, // #1301
  {DBGFIELD("WriteCMPXCHGRMW")    0, false, false,  0, 0,  0, 0,  0, 0}, // #1302
  {DBGFIELD("JWriteCMPXCHG8rr")   0, false, false,  0, 0,  0, 0,  0, 0}, // #1303
  {DBGFIELD("WriteCMPXCHG")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1304
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1305
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1306
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1307
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1308
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1309
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1310
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1311
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1312
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1313
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1314
  {DBGFIELD("JWriteLOCK_XADDrm_XCHG_Part_JWriteXCHGrm_LdSt_Part_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1315
  {DBGFIELD("JWriteXADDrm_XCHG_Part_JWriteXADDrm_LdSt_Part_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1316
  {DBGFIELD("SBWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1317
  {DBGFIELD("WriteALU")           1, false, false, 714, 2,  1, 1,  0, 0}, // #1318
  {DBGFIELD("HWWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1319
  {DBGFIELD("BWWriteZeroLatency") 1, false, false,  0, 0,  0, 1,  0, 0}, // #1320
  {DBGFIELD("SKLWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1321
  {DBGFIELD("SKXWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1322
  {DBGFIELD("WriteFLogic")        1, false, false, 748, 8,  1, 1,  0, 0}, // #1323
  {DBGFIELD("WriteFLogicY")       1, false, false, 748, 8,  1, 1,  0, 0}, // #1324
  {DBGFIELD("JWriteZeroIdiomYmm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1325
  {DBGFIELD("WriteVecLogicX")     1, false, false, 713, 3,  1, 1,  0, 0}, // #1326
  {DBGFIELD("WriteVecALUX")       1, false, false, 712, 4,  1, 1,  0, 0}, // #1327
  {DBGFIELD("SKLWritePSUB")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1328
  {DBGFIELD("SKXWritePSUB")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1329
  {DBGFIELD("SBWritePCMPGTQ")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1330
  {DBGFIELD("HWWritePCMPGTQ")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1331
  {DBGFIELD("BWWritePCMPGTQ")     1, false, false, 893, 9,  6, 1,  0, 0}, // #1332
  {DBGFIELD("SKLWritePCMPGTQ")    0, false, false,  0, 0,  0, 0,  0, 0}, // #1333
  {DBGFIELD("SKXWritePCMPGTQ")    0, false, false,  0, 0,  0, 0,  0, 0}, // #1334
  {DBGFIELD("SBWriteCMOVA_CMOVBErr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1335
  {DBGFIELD("WriteCMOV")          1, false, false, 730, 4,  1, 1,  0, 0}, // #1336
  {DBGFIELD("HWWriteCMOVA_CMOVBErr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1337
  {DBGFIELD("BWWriteCMOVA_CMOVBErr") 2, false, false, 1621, 4,  3, 1,  0, 0}, // #1338
  {DBGFIELD("SKLWriteCMOVA_CMOVBErr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1339
  {DBGFIELD("SKXWriteCMOVA_CMOVBErr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1340
  {DBGFIELD("SBWriteCMOVA_CMOVBErm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1341
  {DBGFIELD("WriteCMOVLd")        2, false, false, 724, 6,  5, 1,  0, 0}, // #1342
  {DBGFIELD("HWWriteCMOVA_CMOVBErm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1343
  {DBGFIELD("BWWriteCMOVA_CMOVBErm") 3, false, false, 2187, 6,  4, 1,  0, 0}, // #1344
  {DBGFIELD("PdWriteCMOVm")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1345
  {DBGFIELD("SKLWriteCMOVA_CMOVBErm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1346
  {DBGFIELD("SKXWriteCMOVA_CMOVBErm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1347
  {DBGFIELD("SBWriteSETA_SETBEr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1348
  {DBGFIELD("WriteSETCC")         1, false, false, 730, 4,  1, 1,  0, 0}, // #1349
  {DBGFIELD("HWWriteSETA_SETBEr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1350
  {DBGFIELD("BWWriteSETA_SETBEr") 2, false, false, 1621, 4,  3, 1,  0, 0}, // #1351
  {DBGFIELD("SKLWriteSETA_SETBEr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1352
  {DBGFIELD("SKXWriteSETA_SETBEr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1353
  {DBGFIELD("SBWriteSETA_SETBEm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1354
  {DBGFIELD("WriteSETCCStore")    3, false, false, 1356, 7,  3, 1,  0, 0}, // #1355
  {DBGFIELD("HWWriteSETA_SETBEm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1356
  {DBGFIELD("BWWriteSETA_SETBEm") 4, false, false, 1834, 7, 22, 1,  0, 0}, // #1357
  {DBGFIELD("PdWriteSETGEmSETGmSETLEmSETLm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1358
  {DBGFIELD("SKLWriteSETA_SETBEm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1359
  {DBGFIELD("SKXWriteSETA_SETBEm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1360
  {DBGFIELD("WriteVecLogicY")     1, false, false, 713, 3,  1, 1,  0, 0}, // #1361
  {DBGFIELD("WriteVecALUY")       1, false, false, 712, 4,  1, 1,  0, 0}, // #1362
  {DBGFIELD("HWWriteADC0")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1363
  {DBGFIELD("WriteADC")           0, false, false,  0, 0,  0, 0,  0, 0}, // #1364
  {DBGFIELD("JWriteLOCK_ALURMW")  0, false, false,  0, 0,  0, 0,  0, 0}, // #1365
  {DBGFIELD("WriteALURMW")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1366
  {DBGFIELD("WriteFShuffle256")   0, false, false,  0, 0,  0, 0,  0, 0}, // #1367
  {DBGFIELD("WriteVecLogic")      0, false, false,  0, 0,  0, 0,  0, 0}, // #1368
  {DBGFIELD("JWrite3OpsLEA")      0, false, false,  0, 0,  0, 0,  0, 0}, // #1369
  {DBGFIELD("WriteLEA")           0, false, false,  0, 0,  0, 0,  0, 0}, // #1370
  {DBGFIELD("WriteFLogicZ")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1371
  {DBGFIELD("WriteVecLogicZ")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1372
}; // BroadwellModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc BtVer2ModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  16383, false, false,  0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false,  1, 1,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false, 2193, 2,  1, 1,  0, 0}, // #3
  {DBGFIELD("WriteCMPXCHGRMW")    6, false, false, 2195, 4,  9, 1,  0, 0}, // #4
  {DBGFIELD("WriteJumpLd")        1, false, false, 893, 3, 23, 1,  0, 0}, // #5
  {DBGFIELD("WriteMove")          1, false, false,  1, 1,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteJump")          1, false, false,  1, 1,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false,  1, 1,  2, 1,  0, 0}, // #8
  {DBGFIELD("WriteSHDrri")        6, false, false,  9, 1, 22, 1,  0, 0}, // #9
  {DBGFIELD("WriteFStoreX")       1, false, false, 2199, 5,  1, 1,  0, 0}, // #10
  {DBGFIELD("WriteFLoadX")        1, false, false, 709, 2,  6, 1,  0, 0}, // #11
  {DBGFIELD("WriteFStoreY")       2, false, false, 2204, 5,  1, 1,  0, 0}, // #12
  {DBGFIELD("WriteFLoadY")        2, false, false, 805, 2,  6, 1,  0, 0}, // #13
  {DBGFIELD("WriteMicrocoded")    1, false, false,  1, 1,  2, 1,  0, 0}, // #14
  {DBGFIELD("WriteFSign")         1, false, false, 196, 4,  3, 1,  0, 0}, // #15
  {DBGFIELD("WriteADC")           1, false, false,  3, 1,  1, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCRMW")        1, false, false, 2209, 4,  5, 1,  0, 0}, // #17
  {DBGFIELD("WriteADCLd_ReadAfterLd") 1, false, false, 2213, 3, 23, 1,  1, 1}, // #18
  {DBGFIELD("WriteALURMW")        1, false, false, 2216, 4,  5, 1,  0, 0}, // #19
  {DBGFIELD("WriteALULd_ReadAfterLd") 1, false, false, 893, 3, 23, 1,  1, 1}, // #20
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 1, false, false, 2220, 6, 11, 1, 11, 1}, // #21
  {DBGFIELD("WriteFAdd64X")       1, false, false, 2220, 4, 22, 1,  0, 0}, // #22
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 1, false, false, 2220, 6, 11, 1, 11, 1}, // #23
  {DBGFIELD("WriteFAddX")         1, false, false, 2220, 4, 22, 1,  0, 0}, // #24
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 1, false, false, 2220, 6, 11, 1, 11, 1}, // #25
  {DBGFIELD("WriteFAdd64")        1, false, false, 2220, 4, 22, 1,  0, 0}, // #26
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 1, false, false, 2220, 6, 11, 1, 11, 1}, // #27
  {DBGFIELD("WriteFAdd")          1, false, false, 2220, 4, 22, 1,  0, 0}, // #28
  {DBGFIELD("WriteFAddLd")        1, false, false, 2220, 6, 11, 1,  0, 0}, // #29
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 2, false, false, 2226, 6, 11, 1, 11, 1}, // #30
  {DBGFIELD("WriteAESDecEnc")     2, false, false, 2232, 4, 22, 1,  0, 0}, // #31
  {DBGFIELD("WriteAESIMCLd")      1, false, false, 2236, 5,  4, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESIMC")        1, false, false, 2241, 3,  3, 1,  0, 0}, // #33
  {DBGFIELD("WriteAESKeyGenLd")   1, false, false, 2236, 5,  4, 1,  0, 0}, // #34
  {DBGFIELD("WriteAESKeyGen")     1, false, false, 2241, 3,  3, 1,  0, 0}, // #35
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 1, false, false, 2222, 4,  5, 1, 11, 1}, // #36
  {DBGFIELD("WriteFLogic")        1, false, false, 198, 2,  1, 1,  0, 0}, // #37
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, 893, 3, 23, 1,  2, 1}, // #38
  {DBGFIELD("WriteBEXTR")         1, false, false,  1, 1,  1, 1,  0, 0}, // #39
  {DBGFIELD("WriteBEXTRLd")       1, false, false, 893, 3, 23, 1,  0, 0}, // #40
  {DBGFIELD("WriteALULd")         1, false, false, 893, 3, 23, 1,  0, 0}, // #41
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 1, false, false, 2222, 4,  5, 1, 11, 1}, // #42
  {DBGFIELD("WriteFBlend")        1, false, false, 198, 2,  1, 1,  0, 0}, // #43
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 3, false, false, 2244, 4,  4, 1, 11, 1}, // #44
  {DBGFIELD("WriteFVarBlend")     3, false, false, 2244, 2,  3, 1,  0, 0}, // #45
  {DBGFIELD("WriteBLSLd")         2, false, false, 2213, 3,  6, 1,  0, 0}, // #46
  {DBGFIELD("WriteBLS")           2, false, false,  3, 1,  3, 1,  0, 0}, // #47
  {DBGFIELD("WriteBSFLd")         7, false, false, 2248, 3,  4, 1,  0, 0}, // #48
  {DBGFIELD("WriteBSF")           7, false, false, 16, 1, 23, 1,  0, 0}, // #49
  {DBGFIELD("WriteBSRLd")         8, false, false, 2248, 3, 11, 1,  0, 0}, // #50
  {DBGFIELD("WriteBSR")           8, false, false, 16, 1,  6, 1,  0, 0}, // #51
  {DBGFIELD("WriteBSWAP32")       1, false, false,  1, 1,  1, 1,  0, 0}, // #52
  {DBGFIELD("WriteBSWAP64")       1, false, false,  1, 1,  1, 1,  0, 0}, // #53
  {DBGFIELD("WriteBitTestImmLd")  1, false, false, 893, 3, 23, 1,  0, 0}, // #54
  {DBGFIELD("WriteBitTestRegLd")  5, false, false, 893, 3, 23, 1,  0, 0}, // #55
  {DBGFIELD("WriteBitTest")       1, false, false,  1, 1,  1, 1,  0, 0}, // #56
  {DBGFIELD("WriteBitTestSetImmRMW") 4, false, false, 2216, 4,  5, 1,  0, 0}, // #57
  {DBGFIELD("WriteBitTestSetRegRMW") 8, false, false, 2216, 4,  5, 1,  0, 0}, // #58
  {DBGFIELD("WriteBitTestSet")    2, false, false,  1, 1,  1, 1,  0, 0}, // #59
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #60
  {DBGFIELD("WriteBZHI")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #61
  {DBGFIELD("WriteLoad")          1, false, false, 709, 2, 22, 1,  0, 0}, // #62
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 1, false, false, 893, 3, 23, 1,  1, 1}, // #63
  {DBGFIELD("WriteCMOV")          1, false, false,  1, 1,  1, 1,  0, 0}, // #64
  {DBGFIELD("WriteFCMOV")         1, false, false, 2220, 4, 22, 1,  0, 0}, // #65
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, 893, 3, 23, 1,  2, 1}, // #66
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 1, false, false, 2220, 6,  4, 1, 11, 1}, // #67
  {DBGFIELD("WriteFCmp64X")       1, false, false, 2220, 4,  3, 1,  0, 0}, // #68
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 1, false, false, 2220, 6,  4, 1, 11, 1}, // #69
  {DBGFIELD("WriteFCmpX")         1, false, false, 2220, 4,  3, 1,  0, 0}, // #70
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 1, false, false, 2220, 6,  4, 1, 11, 1}, // #71
  {DBGFIELD("WriteFCmp64")        1, false, false, 2220, 4,  3, 1,  0, 0}, // #72
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 1, false, false, 2220, 6,  4, 1, 11, 1}, // #73
  {DBGFIELD("WriteFCmp")          1, false, false, 2220, 4,  3, 1,  0, 0}, // #74
  {DBGFIELD("WriteCMPXCHG")       5, false, false, 28, 1, 22, 1,  0, 0}, // #75
  {DBGFIELD("WriteFComLd_ReadAfterVecLd") 1, false, false, 2251, 8, 11, 1, 11, 1}, // #76
  {DBGFIELD("WriteFCom")          1, false, false, 2251, 6, 22, 1,  0, 0}, // #77
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 3, false, false, 2259, 3,  5, 1,  1, 1}, // #78
  {DBGFIELD("WriteCRC32")         3, false, false, 29, 1, 22, 1,  0, 0}, // #79
  {DBGFIELD("WriteNop")           1, false, false,  1, 1,  1, 1,  0, 0}, // #80
  {DBGFIELD("WriteCvtI2PDLd")     1, false, false, 2262, 5, 11, 1,  0, 0}, // #81
  {DBGFIELD("WriteCvtI2PD")       1, false, false, 2267, 3, 22, 1,  0, 0}, // #82
  {DBGFIELD("WriteCvtI2PSLd")     1, false, false, 2262, 5, 11, 1,  0, 0}, // #83
  {DBGFIELD("WriteCvtI2PS")       1, false, false, 2267, 3, 22, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtPD2ILd")     1, false, false, 2262, 5, 11, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtPD2I")       1, false, false, 2267, 3, 22, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtPD2PSLd")    1, false, false, 2262, 5, 11, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtPD2PS")      1, false, false, 2267, 3, 22, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtPS2ILd")     1, false, false, 2262, 5, 11, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtPS2I")       1, false, false, 2267, 3, 22, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPS2PDLd")    1, false, false, 2262, 5,  4, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPS2PD")      1, false, false, 2267, 3,  3, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtSD2ILd")     2, false, false, 2270, 10, 20, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtSD2I")       2, false, false, 2280, 8,  4, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtSD2SSLd")    2, false, false, 2288, 5, 20, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 2, false, false, 2288, 5, 20, 1, 11, 1}, // #96
  {DBGFIELD("WriteCvtSD2SS")      2, false, false, 2293, 3,  4, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtI2SDLd")     1, false, false, 2262, 5,  8, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 1, false, false, 2262, 5,  8, 1, 11, 1}, // #99
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 2, false, false, 2267, 3, 23, 1, 29, 1}, // #100
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 2, false, false, 2267, 3, 23, 1, 30, 1}, // #101
  {DBGFIELD("WriteCvtI2SSLd")     1, false, false, 2262, 5,  8, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 1, false, false, 2262, 5,  8, 1, 11, 1}, // #103
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 2, false, false, 2267, 3, 23, 1, 29, 1}, // #104
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 2, false, false, 2267, 3, 23, 1, 30, 1}, // #105
  {DBGFIELD("WriteCvtSS2SDLd")    2, false, false, 2288, 5, 20, 1,  0, 0}, // #106
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 2, false, false, 2288, 5, 20, 1, 11, 1}, // #107
  {DBGFIELD("WriteCvtSS2SD")      2, false, false, 2293, 3,  4, 1,  0, 0}, // #108
  {DBGFIELD("WriteCvtSS2ILd")     2, false, false, 2270, 10, 20, 1,  0, 0}, // #109
  {DBGFIELD("WriteCvtSS2I")       2, false, false, 2280, 8,  4, 1,  0, 0}, // #110
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 2, false, false, 2280, 8,  4, 1,  0, 0}, // #111
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 2, false, false, 2280, 8,  4, 1,  0, 0}, // #112
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2296, 5, 30, 1,  4, 2}, // #113
  {DBGFIELD("WriteDiv16")         2, false, false, 2296, 3, 28, 1,  0, 0}, // #114
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2301, 5, 86, 1,  4, 2}, // #115
  {DBGFIELD("WriteDiv32")         2, false, false, 2301, 3, 34, 1,  0, 0}, // #116
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2306, 5, 87, 1,  4, 2}, // #117
  {DBGFIELD("WriteDiv64")         2, false, false, 2306, 3, 88, 1,  0, 0}, // #118
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 2311, 5, 10, 1,  4, 2}, // #119
  {DBGFIELD("WriteDiv8")          1, false, false, 2311, 3, 20, 1,  0, 0}, // #120
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 1, false, false, 2316, 6, 77, 1, 11, 1}, // #121
  {DBGFIELD("WriteFDiv64X")       1, false, false, 2316, 4, 63, 1,  0, 0}, // #122
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 1, false, false, 2316, 6, 77, 1, 11, 1}, // #123
  {DBGFIELD("WriteFDivX")         1, false, false, 2316, 4, 63, 1,  0, 0}, // #124
  {DBGFIELD("WriteFDivLd")        1, false, false, 2316, 6, 77, 1,  0, 0}, // #125
  {DBGFIELD("WriteFDiv")          1, false, false, 2316, 4, 63, 1,  0, 0}, // #126
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 1, false, false, 2316, 6, 77, 1, 11, 1}, // #127
  {DBGFIELD("WriteFDiv64")        1, false, false, 2316, 4, 63, 1,  0, 0}, // #128
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 1, false, false, 2316, 6, 77, 1, 11, 1}, // #129
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 3, false, false, 2322, 7, 21, 1, 11, 1}, // #130
  {DBGFIELD("WriteDPPD")          3, false, false, 2322, 5,  8, 1,  0, 0}, // #131
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 5, false, false, 2322, 7,  7, 1, 11, 1}, // #132
  {DBGFIELD("WriteDPPS")          5, false, false, 2322, 5,  9, 1,  0, 0}, // #133
  {DBGFIELD("WriteStore")         1, false, false, 135, 2,  1, 1,  0, 0}, // #134
  {DBGFIELD("WriteVecExtractSt")  1, false, false, 2199, 5, 22, 1,  0, 0}, // #135
  {DBGFIELD("WriteVecExtract")    1, false, false, 2251, 6, 22, 1,  0, 0}, // #136
  {DBGFIELD("WriteVecALUX")       1, false, false, 2193, 2,  1, 1,  0, 0}, // #137
  {DBGFIELD("WriteFComLd")        1, false, false, 2251, 8, 11, 1,  0, 0}, // #138
  {DBGFIELD("WriteEMMS")          1, false, false, 198, 2,  3, 1,  0, 0}, // #139
  {DBGFIELD("WriteFLDC")          1, false, false, 2267, 3, 22, 1,  0, 0}, // #140
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 1, false, false, 2329, 4,  5, 1, 11, 1}, // #141
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 1, false, false, 2220, 6,  8, 1, 11, 1}, // #142
  {DBGFIELD("WriteFHAdd")         1, false, false, 2220, 4, 23, 1,  0, 0}, // #143
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2296, 5, 30, 1,  4, 2}, // #144
  {DBGFIELD("WriteIDiv16")        2, false, false, 2296, 3, 28, 1,  0, 0}, // #145
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2301, 5, 86, 1,  4, 2}, // #146
  {DBGFIELD("WriteIDiv32")        2, false, false, 2301, 3, 34, 1,  0, 0}, // #147
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2306, 5, 87, 1,  4, 2}, // #148
  {DBGFIELD("WriteIDiv64")        2, false, false, 2306, 3, 88, 1,  0, 0}, // #149
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 2311, 5, 10, 1,  4, 2}, // #150
  {DBGFIELD("WriteIDiv8")         1, false, false, 2311, 3, 20, 1,  0, 0}, // #151
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, 2333, 5,  5, 1,  4, 2}, // #152
  {DBGFIELD("WriteIMul16")        3, false, false, 2338, 3, 22, 1,  0, 0}, // #153
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 1, false, false, 2341, 5,  5, 1,  1, 1}, // #154
  {DBGFIELD("WriteIMul16ImmLd")   2, false, false, 2346, 5,  4, 1,  0, 0}, // #155
  {DBGFIELD("WriteIMul16Reg")     1, false, false, 2351, 3, 22, 1,  0, 0}, // #156
  {DBGFIELD("WriteIMul16Imm")     2, false, false, 2354, 3, 23, 1,  0, 0}, // #157
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2346, 5,  5, 1,  4, 2}, // #158
  {DBGFIELD("WriteIMul32")        2, false, false, 2354, 3, 22, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 1, false, false, 2341, 5,  5, 1,  1, 1}, // #160
  {DBGFIELD("WriteIMul32ImmLd")   1, false, false, 2341, 5,  5, 1,  0, 0}, // #161
  {DBGFIELD("WriteIMul32Reg")     1, false, false, 2351, 3, 22, 1,  0, 0}, // #162
  {DBGFIELD("WriteIMul32Imm")     1, false, false, 2351, 3, 22, 1,  0, 0}, // #163
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2357, 5,  8, 1,  4, 2}, // #164
  {DBGFIELD("WriteIMul64")        2, false, false, 2362, 3,  5, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 1, false, false, 2357, 5,  8, 1,  1, 1}, // #166
  {DBGFIELD("WriteIMul64ImmLd")   1, false, false, 2357, 5,  8, 1,  0, 0}, // #167
  {DBGFIELD("WriteIMul64Reg")     1, false, false, 2362, 3,  5, 1,  0, 0}, // #168
  {DBGFIELD("WriteIMul64Imm")     1, false, false, 2362, 3,  5, 1,  0, 0}, // #169
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 2341, 5,  5, 1,  4, 2}, // #170
  {DBGFIELD("WriteIMul8")         1, false, false, 2351, 3, 22, 1,  0, 0}, // #171
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 1, false, false, 2222, 4,  5, 1, 11, 1}, // #172
  {DBGFIELD("WriteFShuffle")      1, false, false, 198, 2,  1, 1,  0, 0}, // #173
  {DBGFIELD("WriteVecLogicX")     1, false, false, 2193, 2,  1, 1,  0, 0}, // #174
  {DBGFIELD("WriteShuffle")       1, false, false, 2193, 2,  1, 1,  0, 0}, // #175
  {DBGFIELD("WriteLAHFSAHF")      1, false, false,  1, 1,  1, 1,  0, 0}, // #176
  {DBGFIELD("WriteVecLoadX")      1, false, false, 709, 2,  6, 1,  0, 0}, // #177
  {DBGFIELD("WriteLDMXCSR")       1, false, false, 709, 2, 22, 1,  0, 0}, // #178
  {DBGFIELD("WriteFLD0")          1, false, false, 2267, 3, 22, 1,  0, 0}, // #179
  {DBGFIELD("WriteFLD1")          1, false, false, 2267, 3, 22, 1,  0, 0}, // #180
  {DBGFIELD("WriteLEA")           1, false, false,  1, 1,  1, 1,  0, 0}, // #181
  {DBGFIELD("WriteFence")         1, false, false, 135, 2,  1, 1,  0, 0}, // #182
  {DBGFIELD("WriteLZCNTLd")       1, false, false, 893, 3, 23, 1,  0, 0}, // #183
  {DBGFIELD("WriteLZCNT")         1, false, false,  1, 1,  1, 1,  0, 0}, // #184
  {DBGFIELD("WriteVecStoreX")     1, false, false, 2199, 5,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteVecStore")      1, false, false, 2199, 5,  3, 1,  0, 0}, // #186
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, 2251, 6, 23, 1,  0, 0}, // #187
  {DBGFIELD("WriteVecLoad")       1, false, false, 2329, 4,  6, 1,  0, 0}, // #188
  {DBGFIELD("WriteVecMoveFromGpr") 2, false, false, 198, 2, 11, 1,  0, 0}, // #189
  {DBGFIELD("WriteVecMoveX")      1, false, false, 2193, 2,  1, 1,  0, 0}, // #190
  {DBGFIELD("WriteVecStoreNT")    1, false, false, 2199, 5,  3, 1,  0, 0}, // #191
  {DBGFIELD("WriteVecMove")       1, false, false, 2193, 2,  1, 1,  0, 0}, // #192
  {DBGFIELD("WriteVecALULd")      1, false, false, 2329, 4,  5, 1,  0, 0}, // #193
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 1, false, false, 2329, 4,  5, 1, 11, 1}, // #194
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 1, false, false, 2329, 4,  5, 1, 11, 1}, // #195
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 1, false, false, 2329, 4,  5, 1, 11, 1}, // #196
  {DBGFIELD("WriteVecLogic")      1, false, false, 2193, 2,  1, 1,  0, 0}, // #197
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 1, false, false, 2329, 4,  5, 1, 11, 1}, // #198
  {DBGFIELD("WritePHAdd")         1, false, false, 2193, 2,  1, 1,  0, 0}, // #199
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 1, false, false, 2329, 4, 23, 1,  1, 1}, // #200
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 2, false, false, 2193, 2,  1, 1, 30, 1}, // #201
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 1, false, false, 2236, 5,  4, 1, 11, 1}, // #202
  {DBGFIELD("WriteVecIMul")       1, false, false, 2241, 3,  3, 1,  0, 0}, // #203
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, 2251, 6, 22, 1,  0, 0}, // #204
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 1, false, false, 2329, 4,  4, 1, 11, 1}, // #205
  {DBGFIELD("WritePSADBW")        1, false, false, 2193, 2,  3, 1,  0, 0}, // #206
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 1, false, false, 2329, 4,  4, 1, 11, 1}, // #207
  {DBGFIELD("WriteVarShuffle")    1, false, false, 2193, 2,  3, 1,  0, 0}, // #208
  {DBGFIELD("WriteShuffleLd")     1, false, false, 2329, 4,  5, 1,  0, 0}, // #209
  {DBGFIELD("WriteVecShiftImm")   1, false, false, 2193, 2,  1, 1,  0, 0}, // #210
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 1, false, false, 2329, 4,  5, 1, 11, 1}, // #211
  {DBGFIELD("WriteVecShift")      1, false, false, 2193, 2,  1, 1,  0, 0}, // #212
  {DBGFIELD("WriteFMoveX")        1, false, false, 198, 2,  1, 1,  0, 0}, // #213
  {DBGFIELD("WriteFShuffleLd")    1, false, false, 2222, 4,  5, 1,  0, 0}, // #214
  {DBGFIELD("WriteFStore")        1, false, false, 2199, 5,  3, 1,  0, 0}, // #215
  {DBGFIELD("WriteFMOVMSK")       1, false, false, 2251, 6, 22, 1,  0, 0}, // #216
  {DBGFIELD("WriteVecLoadNT")     1, false, false, 2329, 4,  6, 1,  0, 0}, // #217
  {DBGFIELD("WriteStoreNT")       1, false, false, 135, 2,  1, 1,  0, 0}, // #218
  {DBGFIELD("WriteFStoreNTX")     1, false, false, 2199, 5, 22, 1,  0, 0}, // #219
  {DBGFIELD("WriteFStoreNT")      1, false, false, 2199, 5, 22, 1,  0, 0}, // #220
  {DBGFIELD("WriteFLoad")         1, false, false, 2222, 4,  6, 1,  0, 0}, // #221
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 3, false, false, 2365, 5, 11, 1, 11, 1}, // #222
  {DBGFIELD("WriteMPSAD")         3, false, false, 2370, 3, 22, 1,  0, 0}, // #223
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 1, false, false, 2373, 6,  8, 1, 11, 1}, // #224
  {DBGFIELD("WriteFMul64X")       1, false, false, 2373, 4, 23, 1,  0, 0}, // #225
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 1, false, false, 2379, 6,  4, 1, 11, 1}, // #226
  {DBGFIELD("WriteFMulX")         1, false, false, 196, 4,  3, 1,  0, 0}, // #227
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 1, false, false, 2373, 6,  8, 1, 11, 1}, // #228
  {DBGFIELD("WriteFMul64")        1, false, false, 2373, 4, 23, 1,  0, 0}, // #229
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 1, false, false, 2379, 6,  4, 1, 11, 1}, // #230
  {DBGFIELD("WriteFMul")          1, false, false, 196, 4,  3, 1,  0, 0}, // #231
  {DBGFIELD("WriteIMul32Ld_WriteIMulH") 3, false, false, 2385, 5, 89, 2,  0, 0}, // #232
  {DBGFIELD("WriteIMul32_WriteIMulH") 3, false, false, 2390, 3, 91, 2,  0, 0}, // #233
  {DBGFIELD("WriteIMul64Ld_WriteIMulH") 3, false, false, 2393, 5, 93, 2,  0, 0}, // #234
  {DBGFIELD("WriteIMul64_WriteIMulH") 3, false, false, 2398, 3, 89, 2,  0, 0}, // #235
  {DBGFIELD("WriteFMulLd")        1, false, false, 2379, 6,  4, 1,  0, 0}, // #236
  {DBGFIELD("WriteVecALUXLd")     1, false, false, 2329, 4,  5, 1,  0, 0}, // #237
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 1, false, false, 2329, 4,  5, 1, 11, 1}, // #238
  {DBGFIELD("WriteShuffleX")      1, false, false, 2193, 2,  1, 1,  0, 0}, // #239
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 1, false, false, 2329, 4,  5, 1, 11, 1}, // #240
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 3, false, false, 2401, 4,  4, 1, 11, 1}, // #241
  {DBGFIELD("WriteVarBlend")      3, false, false, 2405, 2,  3, 1,  0, 0}, // #242
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 1, false, false, 2329, 4,  5, 1, 11, 1}, // #243
  {DBGFIELD("WriteBlend")         1, false, false, 2193, 2,  1, 1,  0, 0}, // #244
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 1, false, false, 2236, 5,  4, 1, 11, 1}, // #245
  {DBGFIELD("WriteCLMul")         1, false, false, 2241, 3,  3, 1,  0, 0}, // #246
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 9, false, false, 2407, 11, 63, 1, 11, 1}, // #247
  {DBGFIELD("WritePCmpEStrI")     9, false, false, 2418, 11, 21, 1,  0, 0}, // #248
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 9, false, false, 2407, 11, 63, 1, 11, 1}, // #249
  {DBGFIELD("WritePCmpEStrM")     9, false, false, 2418, 11, 21, 1,  0, 0}, // #250
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 3, false, false, 2429, 11, 20, 1, 11, 1}, // #251
  {DBGFIELD("WritePCmpIStrI")     3, false, false, 2440, 9,  4, 1,  0, 0}, // #252
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 3, false, false, 2429, 11, 27, 1, 11, 1}, // #253
  {DBGFIELD("WritePCmpIStrM")     3, false, false, 2440, 9, 11, 1,  0, 0}, // #254
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 1, false, false, 2262, 5, 11, 1, 11, 1}, // #255
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 1, false, false, 2329, 4,  4, 1, 11, 1}, // #256
  {DBGFIELD("WritePHAddX")        1, false, false, 2193, 2,  3, 1,  0, 0}, // #257
  {DBGFIELD("WritePHMINPOSLd")    1, false, false, 2329, 4,  4, 1,  0, 0}, // #258
  {DBGFIELD("WritePHMINPOS")      1, false, false, 2193, 2,  3, 1,  0, 0}, // #259
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 1, false, false, 2262, 5, 11, 1, 11, 1}, // #260
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 1, false, false, 2236, 5,  4, 1, 11, 1}, // #261
  {DBGFIELD("WriteVecIMulX")      1, false, false, 2241, 3,  3, 1,  0, 0}, // #262
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, 2251, 6, 22, 1,  0, 0}, // #263
  {DBGFIELD("WriteShuffleXLd")    1, false, false, 2329, 4,  5, 1,  0, 0}, // #264
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 3, false, false, 2449, 6,  8, 1, 11, 1}, // #265
  {DBGFIELD("WritePMULLD")        3, false, false, 2455, 4, 23, 1,  0, 0}, // #266
  {DBGFIELD("WriteCopy")          2, false, false, 2196, 3, 23, 1,  0, 0}, // #267
  {DBGFIELD("WritePOPCNTLd")      1, false, false, 893, 3, 23, 1,  0, 0}, // #268
  {DBGFIELD("WritePOPCNT")        1, false, false,  1, 1,  1, 1,  0, 0}, // #269
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 1, false, false, 2329, 4,  4, 1, 11, 1}, // #270
  {DBGFIELD("WritePSADBWX")       1, false, false, 2193, 2,  3, 1,  0, 0}, // #271
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 3, false, false, 2459, 4,  4, 1, 11, 1}, // #272
  {DBGFIELD("WriteVarShuffleX")   3, false, false, 2463, 2,  3, 1,  0, 0}, // #273
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, 2193, 2,  3, 1,  0, 0}, // #274
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 1, false, false, 2329, 4,  4, 1, 11, 1}, // #275
  {DBGFIELD("WriteVecShiftX")     1, false, false, 2193, 2,  3, 1,  0, 0}, // #276
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 1, false, false, 2251, 8, 11, 1, 11, 1}, // #277
  {DBGFIELD("WriteVecTest")       1, false, false, 2251, 6, 22, 1,  0, 0}, // #278
  {DBGFIELD("WriteRotateLd_WriteRMW") 1, false, false, 2216, 4, 95, 2,  0, 0}, // #279
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 1, false, false, 2216, 4, 95, 2,  0, 0}, // #280
  {DBGFIELD("WriteRotate")        1, false, false,  1, 1,  1, 1,  0, 0}, // #281
  {DBGFIELD("WriteRotateCL")      1, false, false,  1, 1,  1, 1,  0, 0}, // #282
  {DBGFIELD("WriteFRcpXLd")       1, false, false, 2379, 6,  4, 1,  0, 0}, // #283
  {DBGFIELD("WriteFRcpX")         1, false, false, 196, 4,  3, 1,  0, 0}, // #284
  {DBGFIELD("WriteFRcpLd")        1, false, false, 2379, 6,  4, 1,  0, 0}, // #285
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 1, false, false, 2379, 6,  4, 1, 11, 1}, // #286
  {DBGFIELD("WriteFRcp")          1, false, false, 196, 4,  3, 1,  0, 0}, // #287
  {DBGFIELD("WriteRMW")           0, false, false, 135, 2,  3, 1,  0, 0}, // #288
  {DBGFIELD("WriteShiftLd")       1, false, false, 893, 3, 23, 1,  0, 0}, // #289
  {DBGFIELD("WriteShift")         1, false, false,  1, 1,  1, 1,  0, 0}, // #290
  {DBGFIELD("WriteFRndLd")        1, false, false, 2262, 5, 11, 1,  0, 0}, // #291
  {DBGFIELD("WriteFRnd")          1, false, false, 2267, 3, 22, 1,  0, 0}, // #292
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 1, false, false, 2262, 5, 11, 1, 11, 1}, // #293
  {DBGFIELD("WriteFRsqrtXLd")     1, false, false, 2379, 6,  4, 1,  0, 0}, // #294
  {DBGFIELD("WriteFRsqrtX")       1, false, false, 196, 4,  3, 1,  0, 0}, // #295
  {DBGFIELD("WriteFRsqrtLd")      1, false, false, 2379, 6,  4, 1,  0, 0}, // #296
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 1, false, false, 2379, 6,  4, 1, 11, 1}, // #297
  {DBGFIELD("WriteFRsqrt")        1, false, false, 196, 4,  3, 1,  0, 0}, // #298
  {DBGFIELD("WriteShiftLd_WriteRMW") 1, false, false, 2216, 4, 95, 2,  0, 0}, // #299
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 1, false, false, 2216, 4, 95, 2,  0, 0}, // #300
  {DBGFIELD("WriteShiftCL")       1, false, false,  1, 1,  1, 1,  0, 0}, // #301
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, 893, 3, 23, 1,  2, 1}, // #302
  {DBGFIELD("WriteSETCCStore")    1, false, false, 2465, 3,  1, 1,  0, 0}, // #303
  {DBGFIELD("WriteSETCC")         1, false, false,  1, 1,  1, 1,  0, 0}, // #304
  {DBGFIELD("WriteSHDmrcl")       8, false, false, 2468, 3,  8, 1,  0, 0}, // #305
  {DBGFIELD("WriteSHDmri")        8, false, false, 2468, 3,  8, 1,  0, 0}, // #306
  {DBGFIELD("WriteSHDrrcl")       7, false, false, 16, 1, 23, 1,  0, 0}, // #307
  {DBGFIELD("WriteFSqrt64XLd")    1, false, false, 2471, 6, 38, 1,  0, 0}, // #308
  {DBGFIELD("WriteFSqrt64X")      1, false, false, 2471, 4, 66, 1,  0, 0}, // #309
  {DBGFIELD("WriteFSqrtXLd")      1, false, false, 2477, 6, 35, 1,  0, 0}, // #310
  {DBGFIELD("WriteFSqrtX")        1, false, false, 2477, 4, 31, 1,  0, 0}, // #311
  {DBGFIELD("WriteFSqrt64Ld")     1, false, false, 2471, 6, 38, 1,  0, 0}, // #312
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 1, false, false, 2471, 6, 38, 1, 11, 1}, // #313
  {DBGFIELD("WriteFSqrt64")       1, false, false, 2471, 4, 66, 1,  0, 0}, // #314
  {DBGFIELD("WriteFSqrtLd")       1, false, false, 2477, 6, 35, 1,  0, 0}, // #315
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 1, false, false, 2477, 6, 35, 1, 11, 1}, // #316
  {DBGFIELD("WriteFSqrt")         1, false, false, 2477, 4, 31, 1,  0, 0}, // #317
  {DBGFIELD("WriteFSqrt80")       1, false, false, 2483, 4, 72, 1,  0, 0}, // #318
  {DBGFIELD("WriteSTMXCSR")       1, false, false, 135, 2,  1, 1,  0, 0}, // #319
  {DBGFIELD("WriteTZCNTLd")       2, false, false, 2213, 3,  6, 1,  0, 0}, // #320
  {DBGFIELD("WriteTZCNT")         2, false, false,  3, 1,  3, 1,  0, 0}, // #321
  {DBGFIELD("WriteFMAZLd")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #322
  {DBGFIELD("WriteFMALd")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #323
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 2, false, false, 2487, 6, 11, 1, 11, 1}, // #324
  {DBGFIELD("WriteFAdd64Y")       2, false, false, 2487, 4, 22, 1,  0, 0}, // #325
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #326
  {DBGFIELD("WriteFAdd64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #327
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 2, false, false, 2487, 6, 11, 1, 11, 1}, // #328
  {DBGFIELD("WriteFAddY")         2, false, false, 2487, 4, 22, 1,  0, 0}, // #329
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #330
  {DBGFIELD("WriteFAddZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #331
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #332
  {DBGFIELD("WriteShuffleY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #334
  {DBGFIELD("WriteShuffleZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #335
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 2, false, false, 2489, 4,  5, 1, 11, 1}, // #336
  {DBGFIELD("WriteFLogicY")       2, false, false, 2489, 2,  1, 1,  0, 0}, // #337
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("WriteFLogicZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #339
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 6, false, false, 2493, 4, 11, 1, 11, 1}, // #340
  {DBGFIELD("WriteFVarBlendY")    6, false, false, 2493, 2, 22, 1,  0, 0}, // #341
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD("WriteFVarBlendZ")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #343
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 2, false, false, 2489, 4,  5, 1, 11, 1}, // #344
  {DBGFIELD("WriteFBlendY")       2, false, false, 2489, 2,  1, 1,  0, 0}, // #345
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 6, false, false, 2493, 4, 11, 1, 17, 2}, // #346
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, 2244, 4,  4, 1, 17, 2}, // #347
  {DBGFIELD("WriteShuffle256Ld")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #348
  {DBGFIELD("WriteShuffle256")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #349
  {DBGFIELD("WriteShuffleYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #350
  {DBGFIELD("WriteFShuffle256")   2, false, false, 2489, 2,  1, 1,  0, 0}, // #351
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, 2497, 4,  5, 1,  0, 0}, // #352
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 2, false, false, 2487, 6,  4, 1, 11, 1}, // #353
  {DBGFIELD("WriteFCmp64Y")       2, false, false, 2487, 4,  3, 1,  0, 0}, // #354
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 2, false, false, 2487, 6,  4, 1, 11, 1}, // #355
  {DBGFIELD("WriteFCmpY")         2, false, false, 2487, 4,  3, 1,  0, 0}, // #356
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #357
  {DBGFIELD("WriteFCmpZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #358
  {DBGFIELD("WriteVarShuffle256Ld") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #359
  {DBGFIELD("WriteVarShuffle256") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #360
  {DBGFIELD("WriteCvtI2PDYLd")    2, false, false, 2501, 5, 11, 1,  0, 0}, // #361
  {DBGFIELD("WriteCvtI2PDY")      2, false, false, 2506, 3, 22, 1,  0, 0}, // #362
  {DBGFIELD("WriteCvtI2PDZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #363
  {DBGFIELD("WriteCvtI2PDZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #364
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, 2501, 5, 11, 1,  0, 0}, // #365
  {DBGFIELD("WriteCvtI2PSY")      2, false, false, 2506, 3, 22, 1,  0, 0}, // #366
  {DBGFIELD("WriteCvtI2PSZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #367
  {DBGFIELD("WriteCvtI2PSZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #368
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 1, false, false, 2262, 5, 11, 1, 11, 1}, // #369
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 3, false, false, 2509, 6,  9, 1, 11, 1}, // #370
  {DBGFIELD("WriteCvtPD2PSY")     3, false, false, 2515, 4,  5, 1,  0, 0}, // #371
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #372
  {DBGFIELD("WriteCvtPD2PSZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #373
  {DBGFIELD("WriteCvtPD2PSYLd")   3, false, false, 2509, 6,  9, 1,  0, 0}, // #374
  {DBGFIELD("WriteCvtPD2PSZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("WriteCvtPD2IYLd")    3, false, false, 2509, 6,  9, 1,  0, 0}, // #376
  {DBGFIELD("WriteCvtPD2IY")      3, false, false, 2515, 4,  5, 1,  0, 0}, // #377
  {DBGFIELD("WriteCvtPD2IZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #378
  {DBGFIELD("WriteCvtPD2IZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteCvtPH2PSYLd")   2, false, false, 2501, 5, 11, 1,  0, 0}, // #380
  {DBGFIELD("WriteCvtPH2PSY")     2, false, false, 2506, 3, 22, 1,  0, 0}, // #381
  {DBGFIELD("WriteCvtPH2PSLd")    1, false, false, 2262, 5, 11, 1,  0, 0}, // #382
  {DBGFIELD("WriteCvtPH2PS")      1, false, false, 2267, 3, 22, 1,  0, 0}, // #383
  {DBGFIELD("WriteCvtPH2PSZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #384
  {DBGFIELD("WriteCvtPH2PSZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #385
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, 2501, 5, 11, 1,  0, 0}, // #386
  {DBGFIELD("WriteCvtPS2IY")      2, false, false, 2506, 3, 22, 1,  0, 0}, // #387
  {DBGFIELD("WriteCvtPS2IZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #388
  {DBGFIELD("WriteCvtPS2IZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #389
  {DBGFIELD("WriteCvtPS2PDYLd")   2, false, false, 2501, 5,  4, 1,  0, 0}, // #390
  {DBGFIELD("WriteCvtPS2PDY")     2, false, false, 2506, 3,  3, 1,  0, 0}, // #391
  {DBGFIELD("WriteCvtPS2PDZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #392
  {DBGFIELD("WriteCvtPS2PDZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2PHYSt")   3, false, false, 2519, 6,  4, 1,  0, 0}, // #394
  {DBGFIELD("WriteCvtPS2PHY")     3, false, false, 2525, 4,  5, 1,  0, 0}, // #395
  {DBGFIELD("WriteCvtPS2PHSt")    1, false, false, 2199, 5, 23, 1,  0, 0}, // #396
  {DBGFIELD("WriteCvtPS2PH")      1, false, false, 2267, 3, 22, 1,  0, 0}, // #397
  {DBGFIELD("WriteCvtPS2PHZSt")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #398
  {DBGFIELD("WriteCvtPS2PHZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 2, false, false, 2270, 10, 20, 1, 11, 1}, // #400
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 2, false, false, 2270, 10, 20, 1, 11, 1}, // #401
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #402
  {DBGFIELD("WritePSADBWY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #403
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #404
  {DBGFIELD("WritePSADBWZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 2, false, false, 2529, 6, 97, 1, 11, 1}, // #406
  {DBGFIELD("WriteFDiv64Y")       2, false, false, 2529, 4, 98, 1,  0, 0}, // #407
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #408
  {DBGFIELD("WriteFDiv64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #409
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 2, false, false, 2529, 6, 97, 1, 11, 1}, // #410
  {DBGFIELD("WriteFDivY")         2, false, false, 2529, 4, 98, 1,  0, 0}, // #411
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #412
  {DBGFIELD("WriteFDivZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #413
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #414
  {DBGFIELD("WriteFMAX")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #415
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #416
  {DBGFIELD("WriteFMAY")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #417
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #418
  {DBGFIELD("WriteFMAZ")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #419
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 10, false, false, 2535, 7, 28, 1, 11, 1}, // #420
  {DBGFIELD("WriteDPPSY")         10, false, false, 2535, 5, 20, 1,  0, 0}, // #421
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #422
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #423
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #424
  {DBGFIELD("WriteFMALd_ReadAfterVecLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteFMA")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #426
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #427
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #428
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #429
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #430
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 2, false, false, 2501, 5, 11, 1, 11, 1}, // #431
  {DBGFIELD("WriteFRndY")         2, false, false, 2506, 3, 22, 1,  0, 0}, // #432
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #433
  {DBGFIELD("WriteFRndZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #434
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #435
  {DBGFIELD("WriteVecIMulY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #436
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #437
  {DBGFIELD("WriteVecIMulZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #438
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #439
  {DBGFIELD("WriteVecALUY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #440
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteVecALUZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 2, false, false, 2487, 6,  8, 1, 11, 1}, // #443
  {DBGFIELD("WriteFHAddY")        2, false, false, 2487, 4, 23, 1,  0, 0}, // #444
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 2, false, false, 2497, 4,  5, 1, 11, 1}, // #445
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #446
  {DBGFIELD("WriteVecLoadY")      2, false, false, 805, 2,  6, 1,  0, 0}, // #447
  {DBGFIELD("WriteFMaskedStore64Y") 18, false, false, 2542, 10,  7, 1,  0, 0}, // #448
  {DBGFIELD("WriteFMaskedLoadY")  2, false, false, 2552, 4,  5, 1,  0, 0}, // #449
  {DBGFIELD("WriteFMaskedStore64") 10, false, false, 2556, 10, 27, 1,  0, 0}, // #450
  {DBGFIELD("WriteFMaskedLoad")   1, false, false, 2497, 4,  5, 1,  0, 0}, // #451
  {DBGFIELD("WriteFMaskedStore32Y") 36, false, false, 2566, 10, 32, 1,  0, 0}, // #452
  {DBGFIELD("WriteFMaskedStore32") 19, false, false, 2576, 10,  7, 1,  0, 0}, // #453
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #454
  {DBGFIELD("WriteFCmp64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #455
  {DBGFIELD("WriteFMoveY")        2, false, false, 2489, 2,  1, 1,  0, 0}, // #456
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, 2489, 4,  5, 1,  0, 0}, // #457
  {DBGFIELD("WriteFShuffleY")     2, false, false, 2489, 2,  1, 1,  0, 0}, // #458
  {DBGFIELD("WriteFShuffleZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #459
  {DBGFIELD("WriteFShuffleZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #460
  {DBGFIELD("WriteVecStoreY")     2, false, false, 2204, 5,  1, 1,  0, 0}, // #461
  {DBGFIELD("WriteVecMoveY")      2, false, false, 2586, 2,  1, 1,  0, 0}, // #462
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, 2329, 4,  6, 1,  0, 0}, // #463
  {DBGFIELD("WriteVecStoreNTY")   1, false, false, 2204, 5,  3, 1,  0, 0}, // #464
  {DBGFIELD("WriteFStoreNTY")     1, false, false, 2204, 5, 22, 1,  0, 0}, // #465
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #466
  {DBGFIELD("WriteMPSADY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #467
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 2, false, false, 2588, 6,  8, 1, 11, 1}, // #468
  {DBGFIELD("WriteFMul64Y")       2, false, false, 2588, 4, 23, 1,  0, 0}, // #469
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #470
  {DBGFIELD("WriteFMul64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #471
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 2, false, false, 2594, 6,  4, 1, 11, 1}, // #472
  {DBGFIELD("WriteFMulY")         2, false, false, 2594, 4,  3, 1,  0, 0}, // #473
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #474
  {DBGFIELD("WriteFMulZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #475
  {DBGFIELD("WriteVecALUYLd")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #476
  {DBGFIELD("WriteVecALUZLd")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #477
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #478
  {DBGFIELD("WriteVecLogicY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #479
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteVecLogicZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #481
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #482
  {DBGFIELD("WriteBlendY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #483
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #484
  {DBGFIELD("WriteVarBlendY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #485
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #486
  {DBGFIELD("WriteVarBlendZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #488
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, 2401, 4,  4, 1, 17, 2}, // #489
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #491
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, 2329, 4,  5, 1, 17, 2}, // #492
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, 2329, 4,  5, 1, 19, 2}, // #493
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #494
  {DBGFIELD("WriteFVarShuffle256") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #495
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 6, false, false, 2600, 4,  8, 1, 17, 2}, // #496
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 6, false, false, 2600, 4,  8, 1, 19, 2}, // #497
  {DBGFIELD("WriteFVarShuffleY")  6, false, false, 2600, 2, 23, 1,  0, 0}, // #498
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, 2604, 4, 11, 1, 17, 2}, // #499
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 3, false, false, 2604, 4, 11, 1, 19, 2}, // #500
  {DBGFIELD("WriteFVarShuffle")   3, false, false, 2604, 2, 22, 1,  0, 0}, // #501
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 6, false, false, 2600, 4,  8, 1, 11, 1}, // #502
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 3, false, false, 2604, 4, 11, 1, 11, 1}, // #503
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #504
  {DBGFIELD("WriteFVarShuffleZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #505
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #506
  {DBGFIELD("WritePHAddY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #507
  {DBGFIELD("WriteVecInsert")     2, false, false, 2193, 2,  1, 1,  0, 0}, // #508
  {DBGFIELD("WriteVecIMulXLd")    1, false, false, 2236, 5,  4, 1,  0, 0}, // #509
  {DBGFIELD("WriteVecIMulYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #510
  {DBGFIELD("WriteVecIMulZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #511
  {DBGFIELD("WriteVecMaskedStoreY") 2, false, false, 2608, 4,  5, 1,  0, 0}, // #512
  {DBGFIELD("WriteVecMaskedLoadY") 2, false, false, 2612, 4,  5, 1,  0, 0}, // #513
  {DBGFIELD("WriteVecMaskedStore") 1, false, false, 2616, 4,  5, 1,  0, 0}, // #514
  {DBGFIELD("WriteVecMaskedLoad") 1, false, false, 2620, 4,  5, 1,  0, 0}, // #515
  {DBGFIELD("WriteVecMOVMSKY")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #516
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #517
  {DBGFIELD("WritePMULLDY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #518
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #519
  {DBGFIELD("WritePMULLDZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #520
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, 2459, 4,  4, 1, 17, 2}, // #521
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 3, false, false, 2459, 4,  4, 1, 19, 2}, // #522
  {DBGFIELD("WriteVecShiftImmXLd") 1, false, false, 2329, 4,  4, 1,  0, 0}, // #523
  {DBGFIELD("WriteVecShiftImmYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #524
  {DBGFIELD("WriteVecShiftImmY")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #525
  {DBGFIELD("WriteVecShiftImmZLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #526
  {DBGFIELD("WriteVecShiftImmZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #527
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #528
  {DBGFIELD("WriteVarVecShift")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #529
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #530
  {DBGFIELD("WriteVarVecShiftY")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #531
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #532
  {DBGFIELD("WriteVarVecShiftZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 1, false, false, 2329, 4,  4, 1, 11, 1}, // #534
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #535
  {DBGFIELD("WriteVarShuffleY")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #536
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #537
  {DBGFIELD("WriteVarShuffleZ")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #538
  {DBGFIELD("WriteShuffleZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #539
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #540
  {DBGFIELD("WriteVecShiftY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #541
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #542
  {DBGFIELD("WriteVecShiftZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #543
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 3, false, false, 2624, 7,  8, 1, 11, 1}, // #544
  {DBGFIELD("WriteVecTestY")      3, false, false, 2624, 5, 23, 1,  0, 0}, // #545
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 1, false, false, 2379, 6,  4, 1, 11, 1}, // #546
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 2, false, false, 2594, 6,  4, 1, 11, 1}, // #547
  {DBGFIELD("WriteFRcpY")         2, false, false, 2594, 4,  3, 1,  0, 0}, // #548
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #549
  {DBGFIELD("WriteFRcpZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #550
  {DBGFIELD("WriteFRcpYLd")       2, false, false, 2594, 6,  4, 1,  0, 0}, // #551
  {DBGFIELD("WriteFRndYLd")       2, false, false, 2501, 5, 11, 1,  0, 0}, // #552
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 1, false, false, 2379, 6,  4, 1, 11, 1}, // #553
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 2, false, false, 2594, 6,  4, 1, 11, 1}, // #554
  {DBGFIELD("WriteFRsqrtY")       2, false, false, 2594, 4,  3, 1,  0, 0}, // #555
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #556
  {DBGFIELD("WriteFRsqrtZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #557
  {DBGFIELD("WriteFRsqrtYLd")     2, false, false, 2594, 6,  4, 1,  0, 0}, // #558
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 2, false, false, 2489, 4,  5, 1, 11, 1}, // #559
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #560
  {DBGFIELD("WriteFSqrt64YLd")    2, false, false, 2631, 6, 43, 1,  0, 0}, // #561
  {DBGFIELD("WriteFSqrt64Y")      2, false, false, 2631, 4, 99, 1,  0, 0}, // #562
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 1, false, false, 2471, 6, 38, 1, 11, 1}, // #563
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 2, false, false, 2631, 6, 43, 1, 11, 1}, // #564
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #565
  {DBGFIELD("WriteFSqrt64Z")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #566
  {DBGFIELD("WriteFSqrtYLd")      2, false, false, 2637, 6, 100, 1,  0, 0}, // #567
  {DBGFIELD("WriteFSqrtY")        2, false, false, 2637, 4, 82, 1,  0, 0}, // #568
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 1, false, false, 2477, 6, 35, 1, 11, 1}, // #569
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 2, false, false, 2637, 6, 100, 1, 11, 1}, // #570
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #571
  {DBGFIELD("WriteFSqrtZ")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #572
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 3, false, false, 2624, 7,  8, 1, 11, 1}, // #573
  {DBGFIELD("WriteFTestY")        3, false, false, 2624, 5, 23, 1,  0, 0}, // #574
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 1, false, false, 2251, 8, 11, 1, 11, 1}, // #575
  {DBGFIELD("WriteFTest")         1, false, false, 2251, 6, 22, 1,  0, 0}, // #576
  {DBGFIELD("WriteALULd_WriteRMW") 1, false, false, 2216, 4, 95, 2,  0, 0}, // #577
  {DBGFIELD("WriteXCHG")          2, false, false,  3, 1,  1, 1,  0, 0}, // #578
  {DBGFIELD("COPY")               1, false, false,  1, 1,  1, 1,  0, 0}, // #579
  {DBGFIELD("FXAM")               1, false, false,  1, 1,  2, 1,  0, 0}, // #580
  {DBGFIELD("LD_Frr")             1, false, false,  1, 1,  1, 1,  0, 0}, // #581
  {DBGFIELD("MOVSX64rr32")        1, false, false,  1, 1,  1, 1,  0, 0}, // #582
  {DBGFIELD("RCL16m1_RCL16mi_RCL32m1_RCL32mi_RCL64m1_RCL64mi_RCL8m1_RCL8mi_RCR16m1_RCR16mi_RCR32m1_RCR32mi_RCR64m1_RCR64mi_RCR8m1_RCR8mi_ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 1, false, false, 2216, 4, 95, 2,  0, 0}, // #583
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL_RCR16mCL_RCR32mCL_RCR64mCL_RCR8mCL_ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 1, false, false, 2216, 4, 95, 2,  0, 0}, // #584
  {DBGFIELD("SAR16m1_SAR16mi_SAR32m1_SAR32mi_SAR64m1_SAR64mi_SAR8m1_SAR8mi_SHL16m1_SHL16mi_SHL32m1_SHL32mi_SHL64m1_SHL64mi_SHL8m1_SHL8mi_SHR16m1_SHR16mi_SHR32m1_SHR32mi_SHR64m1_SHR64mi_SHR8m1_SHR8mi") 1, false, false, 2216, 4, 95, 2,  0, 0}, // #585
  {DBGFIELD("SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 1, false, false, 2216, 4, 95, 2,  0, 0}, // #586
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false,  1, 1,  1, 1,  0, 0}, // #587
  {DBGFIELD("FCOMPP")             1, false, false,  1, 1,  2, 1,  0, 0}, // #588
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, 2251, 6, 22, 1,  0, 0}, // #589
  {DBGFIELD("MMX_CVTPI2PSirr")    1, false, false, 2267, 3, 22, 1,  0, 0}, // #590
  {DBGFIELD("MMX_CVTPI2PSirm")    1, false, false, 2262, 5, 11, 1,  0, 0}, // #591
  {DBGFIELD("MMX_CVTPS2PIirr_MMX_CVTTPS2PIirr") 1, false, false, 2267, 3, 22, 1,  0, 0}, // #592
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, 709, 2, 22, 1,  0, 0}, // #593
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, 135, 2,  1, 1,  0, 0}, // #594
  {DBGFIELD("XCH_F")              1, false, false,  1, 1,  1, 1,  0, 0}, // #595
  {DBGFIELD("RETIL_RETIQ_RETIW_IRET_IRET16_IRET32_IRET64") 1, false, false, 893, 3, 23, 1,  0, 0}, // #596
  {DBGFIELD("MMX_CVTPS2PIirm_MMX_CVTTPS2PIirm") 1, false, false, 2262, 5, 11, 1,  0, 0}, // #597
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 1, false, false, 709, 2, 22, 1,  0, 0}, // #598
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 1, false, false,  1, 1,  2, 1,  0, 0}, // #599
  {DBGFIELD("LFENCE")             1, false, false, 135, 2,  1, 1,  0, 0}, // #600
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, 198, 2,  1, 1,  0, 0}, // #601
  {DBGFIELD("PSLLDQri_PSRLDQri")  1, false, false, 2193, 2,  1, 1,  0, 0}, // #602
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr_MMX_PUNPCKHBWirr_MMX_PUNPCKHDQirr_MMX_PUNPCKHWDirr") 1, false, false, 2193, 2,  1, 1,  0, 0}, // #603
  {DBGFIELD("LEAVE_LEAVE64")      1, false, false,  1, 1,  1, 1,  0, 0}, // #604
  {DBGFIELD("POP16r")             1, false, false, 709, 2, 22, 1,  0, 0}, // #605
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 2, false, false, 2196, 3, 23, 1,  0, 0}, // #606
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false,  1, 1,  2, 1,  0, 0}, // #607
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false,  1, 1,  2, 1,  0, 0}, // #608
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, 135, 2,  1, 1,  0, 0}, // #609
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false,  1, 1,  1, 1,  0, 0}, // #610
  {DBGFIELD("MMX_PADDQirr_MMX_PSUBQirr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #611
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false,  1, 1,  1, 1,  0, 0}, // #612
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 1, false, false, 2199, 5,  1, 1,  0, 0}, // #613
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  1, false, false, 2199, 5,  1, 1,  0, 0}, // #614
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, 2193, 2,  1, 1,  0, 0}, // #615
  {DBGFIELD("CLD")                1, false, false,  1, 1,  1, 1,  0, 0}, // #616
  {DBGFIELD("LDDQUrm")            1, false, false, 709, 2,  6, 1,  0, 0}, // #617
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false,  1, 1,  2, 1,  0, 0}, // #618
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 2, false, false, 2196, 3, 23, 1,  0, 0}, // #619
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 3, false, false, 2643, 4, 101, 2,  1, 1}, // #620
  {DBGFIELD("PHADDDrr_PHSUBDrr")  1, false, false, 2193, 2,  3, 1,  0, 0}, // #621
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, 893, 3, 23, 1,  0, 0}, // #622
  {DBGFIELD("MMX_PADDQirm_MMX_PSUBQirm") 1, false, false, 2329, 4,  5, 1, 11, 1}, // #623
  {DBGFIELD("MOVDQUrm")           1, false, false, 709, 2,  6, 1,  0, 0}, // #624
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, 709, 2,  6, 1,  0, 0}, // #625
  {DBGFIELD("PADDQrm_PSUBQrm")    1, false, false, 2329, 4,  5, 1, 11, 1}, // #626
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false,  1, 1,  1, 1,  0, 0}, // #627
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   1, false, false,  1, 1,  1, 1,  0, 0}, // #628
  {DBGFIELD("LD_F80m")            1, false, false, 709, 2, 22, 1,  0, 0}, // #629
  {DBGFIELD("PHADDDrm_PHSUBDrm")  1, false, false, 2329, 4,  4, 1, 11, 1}, // #630
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 1, false, false, 2251, 6, 22, 1,  0, 0}, // #631
  {DBGFIELD("FLDCW16m")           1, false, false, 709, 2, 22, 1,  0, 0}, // #632
  {DBGFIELD("ST_FP80m")           1, false, false, 135, 2,  1, 1,  0, 0}, // #633
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 1, false, false, 2193, 2,  1, 1,  0, 0}, // #634
  {DBGFIELD("CMPXCHG8rm")         16382, false, false,  0, 0,  0, 0,  0, 0}, // #635
  {DBGFIELD("INTO")               1, false, false,  1, 1,  2, 1,  0, 0}, // #636
  {DBGFIELD("XLAT")               1, false, false, 709, 2, 22, 1,  0, 0}, // #637
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 7, false, false, 16, 1, 23, 1,  0, 0}, // #638
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 6, false, false,  9, 1, 22, 1,  0, 0}, // #639
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 8, false, false, 2468, 3,  8, 1,  0, 0}, // #640
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 8, false, false, 2468, 3,  8, 1,  0, 0}, // #641
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 1, false, false, 135, 2,  1, 1,  0, 0}, // #642
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 1, false, false, 2329, 4,  5, 1, 11, 1}, // #643
  {DBGFIELD("AAD8i8")             1, false, false,  1, 1,  2, 1,  0, 0}, // #644
  {DBGFIELD("LOOPE")              1, false, false,  1, 1,  1, 1,  0, 0}, // #645
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, 135, 2,  1, 1,  0, 0}, // #646
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 7, false, false, 16, 1, 23, 1,  0, 0}, // #647
  {DBGFIELD("FNSTCW16m")          1, false, false,  1, 1,  1, 1,  0, 0}, // #648
  {DBGFIELD("POPA16_POPA32")      1, false, false, 709, 2, 22, 1,  0, 0}, // #649
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, 135, 2,  1, 1,  0, 0}, // #650
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 8, false, false, 2468, 3,  8, 1,  0, 0}, // #651
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 8, false, false, 2468, 3,  8, 1,  0, 0}, // #652
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 6, false, false,  9, 1, 22, 1,  0, 0}, // #653
  {DBGFIELD("CMPXCHG8rr")         16382, false, false,  0, 0,  0, 0,  0, 0}, // #654
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80_COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 2251, 6, 22, 1,  0, 0}, // #655
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 2, false, false, 2280, 8,  4, 1,  0, 0}, // #656
  {DBGFIELD("CVTTSS2SI64rr")      2, false, false, 2280, 8,  4, 1,  0, 0}, // #657
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int") 1, false, false, 2251, 8, 11, 1, 11, 1}, // #658
  {DBGFIELD("CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 2, false, false, 2270, 10, 20, 1,  0, 0}, // #659
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false,  1, 1,  2, 1,  0, 0}, // #660
  {DBGFIELD("AAA_AAS")            1, false, false,  1, 1,  2, 1,  0, 0}, // #661
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #662
  {DBGFIELD("LOOPNE")             1, false, false,  1, 1,  1, 1,  0, 0}, // #663
  {DBGFIELD("PAUSE")              1, false, false,  1, 1,  1, 1,  0, 0}, // #664
  {DBGFIELD("CMPXCHG8B")          16382, false, false,  0, 0,  0, 0,  0, 0}, // #665
  {DBGFIELD("DAA")                1, false, false,  1, 1,  2, 1,  0, 0}, // #666
  {DBGFIELD("LOOP")               1, false, false,  1, 1,  1, 1,  0, 0}, // #667
  {DBGFIELD("DAS")                1, false, false,  1, 1,  2, 1,  0, 0}, // #668
  {DBGFIELD("AAM8i8")             1, false, false,  1, 1,  2, 1,  0, 0}, // #669
  {DBGFIELD("STD")                1, false, false,  1, 1,  1, 1,  0, 0}, // #670
  {DBGFIELD("CMPXCHG16B")         16382, false, false,  0, 0,  0, 0,  0, 0}, // #671
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false,  1, 1,  2, 1,  0, 0}, // #672
  {DBGFIELD("FNCLEX_FXTRACT")     1, false, false,  1, 1,  2, 1,  0, 0}, // #673
  {DBGFIELD("POPF32_POPF64")      1, false, false, 709, 2, 22, 1,  0, 0}, // #674
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false,  1, 1,  2, 1,  0, 0}, // #675
  {DBGFIELD("RDTSC_RDTSCP")       1, false, false,  1, 1,  2, 1,  0, 0}, // #676
  {DBGFIELD("ENTER")              1, false, false,  1, 1,  2, 1,  0, 0}, // #677
  {DBGFIELD("POPF16")             1, false, false, 709, 2, 22, 1,  0, 0}, // #678
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false,  1, 1,  2, 1,  0, 0}, // #679
  {DBGFIELD("FRNDINT")            1, false, false,  1, 1,  2, 1,  0, 0}, // #680
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false,  1, 1,  2, 1,  0, 0}, // #681
  {DBGFIELD("POPSS16_POPSS32")    1, false, false,  1, 1,  2, 1,  0, 0}, // #682
  {DBGFIELD("FPREM")              1, false, false,  1, 1,  2, 1,  0, 0}, // #683
  {DBGFIELD("INSB_INSL_INSW")     1, false, false,  1, 1,  2, 1,  0, 0}, // #684
  {DBGFIELD("FNINIT")             1, false, false,  1, 1,  2, 1,  0, 0}, // #685
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 1, false, false,  1, 1,  2, 1,  0, 0}, // #686
  {DBGFIELD("FPREM1")             1, false, false,  1, 1,  2, 1,  0, 0}, // #687
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false,  1, 1,  2, 1,  0, 0}, // #688
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 1, false, false,  1, 1,  2, 1,  0, 0}, // #689
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false,  1, 1,  2, 1,  0, 0}, // #690
  {DBGFIELD("FSCALE")             1, false, false,  1, 1,  2, 1,  0, 0}, // #691
  {DBGFIELD("RDMSR")              1, false, false,  1, 1,  2, 1,  0, 0}, // #692
  {DBGFIELD("RET_RETL_RETQ_RETW_LRETIL_LRETIQ_LRETIW_LRETL_LRETQ_LRETW") 1, false, false, 893, 3, 23, 1,  0, 0}, // #693
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 1, false, false,  1, 1,  2, 1,  0, 0}, // #694
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 1, false, false,  1, 1,  2, 1,  0, 0}, // #695
  {DBGFIELD("F2XM1")              1, false, false,  1, 1,  2, 1,  0, 0}, // #696
  {DBGFIELD("CPUID")              1, false, false,  1, 1,  2, 1,  0, 0}, // #697
  {DBGFIELD("INT")                1, false, false,  1, 1,  2, 1,  0, 0}, // #698
  {DBGFIELD("INT3")               1, false, false,  1, 1,  2, 1,  0, 0}, // #699
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false,  1, 1,  2, 1,  0, 0}, // #700
  {DBGFIELD("FXRSTOR_FXRSTOR64")  1, false, false,  1, 1,  2, 1,  0, 0}, // #701
  {DBGFIELD("FYL2X")              1, false, false,  1, 1,  2, 1,  0, 0}, // #702
  {DBGFIELD("FYL2XP1")            1, false, false,  1, 1,  2, 1,  0, 0}, // #703
  {DBGFIELD("FPTAN")              1, false, false,  1, 1,  2, 1,  0, 0}, // #704
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false,  1, 1,  2, 1,  0, 0}, // #705
  {DBGFIELD("FPATAN")             1, false, false,  1, 1,  2, 1,  0, 0}, // #706
  {DBGFIELD("WRMSR")              1, false, false,  1, 1,  2, 1,  0, 0}, // #707
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, 2251, 6, 22, 1,  0, 0}, // #708
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, 2251, 6, 22, 1,  0, 0}, // #709
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 1, false, false,  1, 1,  2, 1,  0, 0}, // #710
  {DBGFIELD("FNOP")               1, false, false,  1, 1,  1, 1,  0, 0}, // #711
  {DBGFIELD("RETQ")               1, false, false, 893, 3, 23, 1,  0, 0}, // #712
  {DBGFIELD("CDQ_CQO")            1, false, false,  1, 1,  1, 1,  0, 0}, // #713
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, 2193, 2,  1, 1,  0, 0}, // #714
  {DBGFIELD("MMX_PADDQirr")       1, false, false, 2193, 2,  1, 1,  0, 0}, // #715
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, 2193, 2,  1, 1,  0, 0}, // #716
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 1, false, false,  1, 1,  2, 1,  0, 0}, // #717
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 2251, 6, 22, 1,  0, 0}, // #718
  {DBGFIELD("VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 1, false, false, 2251, 6, 22, 1,  0, 0}, // #719
  {DBGFIELD("CWD")                1, false, false,  1, 1,  1, 1,  0, 0}, // #720
  {DBGFIELD("FNSTSW16r")          1, false, false,  1, 1,  1, 1,  0, 0}, // #721
  {DBGFIELD("MMX_MOVDQ2Qrr")      1, false, false, 2193, 2,  1, 1,  0, 0}, // #722
  {DBGFIELD("PUSHFS64")           1, false, false,  1, 1,  2, 1,  0, 0}, // #723
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 1, false, false, 2251, 6, 22, 1,  0, 0}, // #724
  {DBGFIELD("RCL16r1_RCL32r1_RCL64r1_RCL8r1_RCR16r1_RCR32r1_RCR64r1_RCR8r1") 1, false, false,  1, 1,  1, 1,  0, 0}, // #725
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, 2251, 6, 22, 1,  0, 0}, // #726
  {DBGFIELD("MOV64sr")            1, false, false,  1, 1,  1, 1,  0, 0}, // #727
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVSX32rm16_MOVSX32rm32_MOVSX32rm8_MOVSX32rm8_NOREX_MOVSX64rm16_MOVSX64rm32_MOVSX64rm8_MOVZX16rm16_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX_MOVZX64rm16_MOVZX64rm8") 1, false, false, 893, 3, 23, 1,  0, 0}, // #728
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCL8rCL_RCR16rCL_RCR32rCL_RCR64rCL_RCR8rCL") 1, false, false,  1, 1,  1, 1,  0, 0}, // #729
  {DBGFIELD("RCL16ri_RCL32ri_RCL64ri_RCL8ri_RCR16ri_RCR32ri_RCR64ri_RCR8ri") 1, false, false,  1, 1,  1, 1,  0, 0}, // #730
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 1, false, false, 135, 2,  1, 1,  0, 0}, // #731
  {DBGFIELD("CLI")                1, false, false,  1, 1,  2, 1,  0, 0}, // #732
  {DBGFIELD("PUSHGS64")           1, false, false,  1, 1,  2, 1,  0, 0}, // #733
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 1, false, false, 135, 2,  1, 1,  0, 0}, // #734
  {DBGFIELD("CALL64pcrel32")      1, false, false,  1, 1,  1, 1,  0, 0}, // #735
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 1, false, false,  1, 1,  1, 1,  0, 0}, // #736
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 1, false, false, 2199, 5, 22, 1,  0, 0}, // #737
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 1, false, false,  1, 1,  2, 1,  0, 0}, // #738
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 1, false, false, 2199, 5, 22, 1,  0, 0}, // #739
  {DBGFIELD("PUSHF16_PUSHF64")    1, false, false, 135, 2,  1, 1,  0, 0}, // #740
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 1, false, false, 709, 2, 22, 1,  0, 0}, // #741
  {DBGFIELD("MMX_MOVD64from64rm") 1, false, false, 2199, 5,  3, 1,  0, 0}, // #742
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, 2222, 4,  5, 1,  0, 0}, // #743
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, 2329, 4,  6, 1,  0, 0}, // #744
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 2222, 4,  5, 1,  0, 0}, // #745
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false, 2222, 4,  6, 1,  0, 0}, // #746
  {DBGFIELD("MOV16sm")            1, false, false,  1, 1,  1, 1,  0, 0}, // #747
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 1, false, false, 2329, 4,  5, 1,  0, 0}, // #748
  {DBGFIELD("MMX_PALIGNRrmi")     1, false, false, 2329, 4,  5, 1, 11, 1}, // #749
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 1, false, false, 2329, 4,  5, 1, 11, 1}, // #750
  {DBGFIELD("LODSL_LODSQ")        1, false, false,  1, 1,  2, 1,  0, 0}, // #751
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 2, false, false, 2647, 4,  5, 1,  0, 0}, // #752
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 2, false, false, 2489, 4,  5, 1,  0, 0}, // #753
  {DBGFIELD("VINSERTF128rm")      2, false, false, 2497, 4,  5, 1, 11, 1}, // #754
  {DBGFIELD("MMX_PADDQirm")       1, false, false, 2329, 4,  5, 1, 11, 1}, // #755
  {DBGFIELD("VERRm_VERWm")        1, false, false,  1, 1,  2, 1,  0, 0}, // #756
  {DBGFIELD("FARJMP64")           1, false, false,  1, 1,  1, 1,  0, 0}, // #757
  {DBGFIELD("FNSTSWm")            1, false, false,  1, 1,  2, 1,  0, 0}, // #758
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 1, false, false,  1, 1,  2, 1,  0, 0}, // #759
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 1, false, false, 893, 3, 23, 1,  0, 0}, // #760
  {DBGFIELD("CALL64m_CALL64m_NT") 1, false, false,  1, 1,  1, 1,  0, 0}, // #761
  {DBGFIELD("VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 1, false, false, 2251, 8, 11, 1, 11, 1}, // #762
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false,  1, 1,  2, 1,  0, 0}, // #763
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 1, false, false, 2216, 4, 95, 2,  0, 0}, // #764
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #765
  {DBGFIELD("FARCALL64")          1, false, false,  1, 1,  1, 1,  0, 0}, // #766
  {DBGFIELD("CVTSD2SI64rm_Int_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int") 2, false, false, 2270, 10, 20, 1,  0, 0}, // #767
  {DBGFIELD("CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int") 2, false, false, 2270, 10, 20, 1,  0, 0}, // #768
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, 709, 2, 22, 1,  0, 0}, // #769
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 1, false, false, 2216, 4, 95, 2,  0, 0}, // #770
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 1, false, false, 2209, 4,  5, 1,  0, 0}, // #771
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 1, false, false, 2220, 6, 11, 1,  0, 0}, // #772
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 1, false, false, 2329, 4,  5, 1, 11, 1}, // #773
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 1, false, false, 2251, 8, 11, 1,  0, 0}, // #774
  {DBGFIELD("MUL_F32m_MUL_F64m")  1, false, false, 2379, 6,  4, 1,  0, 0}, // #775
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 1, false, false, 2220, 6, 11, 1,  0, 0}, // #776
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 1, false, false, 2379, 6,  4, 1,  0, 0}, // #777
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 1, false, false, 2316, 6, 77, 1,  0, 0}, // #778
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 1, false, false, 2316, 6, 77, 1,  0, 0}, // #779
  {DBGFIELD("VZEROALL")           73, false, false,  0, 0, 67, 1,  0, 0}, // #780
  {DBGFIELD("VZEROUPPER")         37, false, false,  0, 0, 40, 1,  0, 0}, // #781
  {DBGFIELD("CLC")                1, false, false,  1, 1,  1, 1,  0, 0}, // #782
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #783
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #784
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #785
  {DBGFIELD("PXORrr_VPXORrr")     16382, false, false,  0, 0,  0, 0,  0, 0}, // #786
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #787
  {DBGFIELD("PSUBQrr")            16382, false, false,  0, 0,  0, 0,  0, 0}, // #788
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #789
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #790
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 1, false, false, 893, 3, 23, 1,  1, 1}, // #791
  {DBGFIELD("SETCCr")             1, false, false,  1, 1,  1, 1,  0, 0}, // #792
  {DBGFIELD("SETCCm")             1, false, false, 2465, 3,  1, 1,  0, 0}, // #793
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 1, false, false, 2222, 4,  5, 1, 11, 1}, // #794
  {DBGFIELD("RETIL_RETIQ_RETIW")  1, false, false, 893, 3, 23, 1,  0, 0}, // #795
  {DBGFIELD("LRETIL_LRETIQ_LRETIW") 1, false, false, 893, 3, 23, 1,  0, 0}, // #796
  {DBGFIELD("RDPMC")              1, false, false,  1, 1,  2, 1,  0, 0}, // #797
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false,  1, 1,  2, 1,  0, 0}, // #798
  {DBGFIELD("FBLDm")              1, false, false,  1, 1,  2, 1,  0, 0}, // #799
  {DBGFIELD("FFREE_FFREEP")       1, false, false,  1, 1,  2, 1,  0, 0}, // #800
  {DBGFIELD("FSAVEm")             1, false, false,  1, 1,  2, 1,  0, 0}, // #801
  {DBGFIELD("FRSTORm")            1, false, false,  1, 1,  2, 1,  0, 0}, // #802
  {DBGFIELD("FXTRACT")            1, false, false,  1, 1,  2, 1,  0, 0}, // #803
  {DBGFIELD("MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 2222, 4,  5, 1,  0, 0}, // #804
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, 2329, 4,  5, 1,  0, 0}, // #805
  {DBGFIELD("VBROADCASTF128")     2, false, false, 2647, 4,  5, 1,  0, 0}, // #806
  {DBGFIELD("VBROADCASTI128")     1, false, false, 2329, 4,  5, 1,  0, 0}, // #807
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, 2329, 4,  5, 1,  0, 0}, // #808
  {DBGFIELD("FBSTPm")             1, false, false,  1, 1,  2, 1,  0, 0}, // #809
  {DBGFIELD("VMPTRSTm")           1, false, false,  1, 1,  2, 1,  0, 0}, // #810
  {DBGFIELD("ST_FP32m_ST_FP64m")  1, false, false, 135, 2,  1, 1,  0, 0}, // #811
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #812
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #813
  {DBGFIELD("MMX_MOVQ2DQrr")      1, false, false, 2193, 2,  1, 1,  0, 0}, // #814
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false,  1, 1,  1, 1,  0, 0}, // #815
  {DBGFIELD("FINCSTP")            1, false, false,  1, 1,  2, 1,  0, 0}, // #816
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false,  1, 1,  1, 1,  0, 0}, // #817
  {DBGFIELD("VPBLENDDYrri")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #818
  {DBGFIELD("VPBLENDDrri")        1, false, false, 2193, 2,  1, 1,  0, 0}, // #819
  {DBGFIELD("CMC_STC")            1, false, false,  1, 1,  1, 1,  0, 0}, // #820
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false,  1, 1,  2, 1,  0, 0}, // #821
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 1, false, false, 2262, 5,  4, 1,  0, 0}, // #822
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #823
  {DBGFIELD("CVTSS2SDrm")         2, false, false, 2288, 5, 20, 1,  0, 0}, // #824
  {DBGFIELD("CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 2, false, false, 2288, 5, 20, 1, 11, 1}, // #825
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #826
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 1, false, false, 893, 3, 23, 1,  1, 1}, // #827
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 1, false, false, 2329, 4,  5, 1,  0, 0}, // #828
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #829
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 1, false, false, 893, 3, 23, 1,  0, 0}, // #830
  {DBGFIELD("ANDN32rm_ANDN64rm")  1, false, false, 893, 3, 23, 1,  1, 1}, // #831
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 1, false, false, 893, 3, 23, 1,  0, 0}, // #832
  {DBGFIELD("VINSERTI128rm")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #833
  {DBGFIELD("VPBLENDDrmi")        1, false, false, 2329, 4,  5, 1, 11, 1}, // #834
  {DBGFIELD("VPBLENDDYrmi")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #835
  {DBGFIELD("POP32r_POP64r")      1, false, false, 709, 2, 22, 1,  0, 0}, // #836
  {DBGFIELD("SFENCE")             1, false, false, 135, 2,  1, 1,  0, 0}, // #837
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 1, false, false, 135, 2,  1, 1,  0, 0}, // #838
  {DBGFIELD("MOVBE16mr")          1, false, false, 135, 2,  1, 1,  0, 0}, // #839
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 1, false, false, 135, 2,  1, 1,  0, 0}, // #840
  {DBGFIELD("MFENCE")             1, false, false, 135, 2,  1, 1,  0, 0}, // #841
  {DBGFIELD("XGETBV")             1, false, false,  1, 1,  2, 1,  0, 0}, // #842
  {DBGFIELD("CVTPS2PDrr_VCVTPS2PDrr") 1, false, false, 2267, 3,  3, 1,  0, 0}, // #843
  {DBGFIELD("CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 2, false, false, 2293, 3,  4, 1,  0, 0}, // #844
  {DBGFIELD("MMX_PACKSSDWirm_MMX_PACKSSWBirm_MMX_PACKUSWBirm") 1, false, false, 2329, 4,  5, 1, 11, 1}, // #845
  {DBGFIELD("LRETQ_RETL")         1, false, false, 893, 3, 23, 1,  0, 0}, // #846
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 1, false, false,  1, 1,  1, 1,  0, 0}, // #847
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #848
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, 2267, 3, 22, 1,  0, 0}, // #849
  {DBGFIELD("VCVTDQ2PSYrr")       2, false, false, 2506, 3, 22, 1,  0, 0}, // #850
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, 2193, 2,  1, 1,  0, 0}, // #851
  {DBGFIELD("CVTPS2DQrm_VCVTPS2DQrm_CVTTPS2DQrm_VCVTTPS2DQrm") 1, false, false, 2262, 5, 11, 1,  0, 0}, // #852
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, 2501, 5, 11, 1,  0, 0}, // #853
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm") 2, false, false, 2501, 5, 11, 1,  0, 0}, // #854
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #855
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr") 1, false, false, 2193, 2,  1, 1,  0, 0}, // #856
  {DBGFIELD("CLDEMOTE")           1, false, false, 709, 2, 22, 1,  0, 0}, // #857
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int") 2, false, false, 2280, 8,  4, 1,  0, 0}, // #858
  {DBGFIELD("CVTTSD2SI64rr_CVTTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, 2280, 8,  4, 1,  0, 0}, // #859
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int_CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, 2280, 8,  4, 1,  0, 0}, // #860
  {DBGFIELD("CVTTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr") 2, false, false, 2280, 8,  4, 1,  0, 0}, // #861
  {DBGFIELD("VCVTPS2PDYrr")       2, false, false, 2506, 3,  3, 1,  0, 0}, // #862
  {DBGFIELD("MMX_CVTPI2PDirr")    1, false, false, 2267, 3, 22, 1,  0, 0}, // #863
  {DBGFIELD("MMX_CVTPD2PIirr_MMX_CVTTPD2PIirr") 1, false, false, 2267, 3, 22, 1,  0, 0}, // #864
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 1, false, false, 2267, 3, 22, 1,  0, 0}, // #865
  {DBGFIELD("CVTPD2PSrr_VCVTPD2PSrr") 1, false, false, 2267, 3, 22, 1,  0, 0}, // #866
  {DBGFIELD("CVTSD2SSrr_CVTSD2SSrr_Int_VCVTSD2SSrr_VCVTSD2SSrr_Int") 2, false, false, 2293, 3,  4, 1,  0, 0}, // #867
  {DBGFIELD("CVTSI2SDrr_CVTSI642SDrr") 2, false, false, 2267, 3, 23, 1, 29, 1}, // #868
  {DBGFIELD("CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, 2267, 3, 23, 1, 30, 1}, // #869
  {DBGFIELD("CVTSI2SSrr")         2, false, false, 2267, 3, 23, 1, 29, 1}, // #870
  {DBGFIELD("CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int") 2, false, false, 2267, 3, 23, 1, 30, 1}, // #871
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 1, false, false, 2267, 3, 22, 1,  0, 0}, // #872
  {DBGFIELD("VCVTSD2SI64rm_Int_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 2, false, false, 2270, 10, 20, 1,  0, 0}, // #873
  {DBGFIELD("CVTSS2SI64rm_Int")   2, false, false, 2270, 10, 20, 1,  0, 0}, // #874
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 2, false, false, 2270, 10, 20, 1,  0, 0}, // #875
  {DBGFIELD("VCVTPS2PDYrm")       2, false, false, 2501, 5,  4, 1,  0, 0}, // #876
  {DBGFIELD("CVTPD2PSrm")         1, false, false, 2262, 5, 11, 1,  0, 0}, // #877
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_MMX_CVTPD2PIirm_MMX_CVTTPD2PIirm") 1, false, false, 2262, 5, 11, 1,  0, 0}, // #878
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 1, false, false, 2262, 5, 11, 1,  0, 0}, // #879
  {DBGFIELD("MMX_CVTPI2PDirm")    1, false, false, 2262, 5, 11, 1,  0, 0}, // #880
  {DBGFIELD("CVTSD2SSrm")         2, false, false, 2288, 5, 20, 1,  0, 0}, // #881
  {DBGFIELD("CVTSD2SSrm_Int_VCVTSD2SSrm_VCVTSD2SSrm_Int") 2, false, false, 2288, 5, 20, 1, 11, 1}, // #882
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 1, false, false, 2329, 4,  5, 1,  0, 0}, // #883
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 1, false, false,  1, 1,  2, 1,  0, 0}, // #884
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 1, false, false,  1, 1,  2, 1,  0, 0}, // #885
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, 196, 4,  3, 1,  0, 0}, // #886
  {DBGFIELD("VPCMPGTQYrm")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #887
  {DBGFIELD("CVTSI642SSrr")       2, false, false, 2267, 3, 23, 1, 29, 1}, // #888
  {DBGFIELD("CVTSI642SSrr_Int_VCVTSI642SSrr_VCVTSI642SSrr_Int") 2, false, false, 2267, 3, 23, 1, 30, 1}, // #889
  {DBGFIELD("STR16r_STR32r_STR64r") 1, false, false,  1, 1,  2, 1,  0, 0}, // #890
  {DBGFIELD("XSETBV")             1, false, false,  1, 1,  2, 1,  0, 0}, // #891
  {DBGFIELD("VCVTDQ2PDYrr")       2, false, false, 2506, 3, 22, 1,  0, 0}, // #892
  {DBGFIELD("VCVTPD2PSYrr")       3, false, false, 2515, 4,  5, 1,  0, 0}, // #893
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 3, false, false, 2515, 4,  5, 1,  0, 0}, // #894
  {DBGFIELD("VCVTDQ2PDYrm")       2, false, false, 2501, 5, 11, 1,  0, 0}, // #895
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 1, false, false, 2216, 4, 95, 2,  0, 0}, // #896
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 1, false, false,  1, 1,  1, 1,  0, 0}, // #897
  {DBGFIELD("RCL8rCL")            1, false, false,  1, 1,  1, 1,  0, 0}, // #898
  {DBGFIELD("RDTSC")              1, false, false,  1, 1,  2, 1,  0, 0}, // #899
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 1, false, false,  1, 1,  2, 1,  0, 0}, // #900
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, 2316, 4, 63, 1,  0, 0}, // #901
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 1, false, false, 2316, 6, 77, 1,  0, 0}, // #902
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 1, false, false, 2316, 6, 77, 1,  0, 0}, // #903
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, 2316, 4, 63, 1,  0, 0}, // #904
  {DBGFIELD("XSAVE64")            1, false, false,  1, 1,  2, 1,  0, 0}, // #905
  {DBGFIELD("XSAVE")              1, false, false,  1, 1,  2, 1,  0, 0}, // #906
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 1, false, false,  1, 1,  2, 1,  0, 0}, // #907
  {DBGFIELD("VMCLEARm")           1, false, false,  1, 1,  2, 1,  0, 0}, // #908
  {DBGFIELD("FLDENVm")            1, false, false,  1, 1,  2, 1,  0, 0}, // #909
  {DBGFIELD("FXRSTOR64")          1, false, false,  1, 1,  2, 1,  0, 0}, // #910
  {DBGFIELD("FSTENVm")            1, false, false,  1, 1,  2, 1,  0, 0}, // #911
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm_VPGATHERDDrm") 1, false, false, 709, 2, 22, 1,  0, 0}, // #912
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 1, false, false, 709, 2, 22, 1,  0, 0}, // #913
  {DBGFIELD("VPGATHERQDYrm")      1, false, false, 709, 2, 22, 1,  0, 0}, // #914
  {DBGFIELD("VPGATHERQDrm")       1, false, false, 709, 2, 22, 1,  0, 0}, // #915
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 1, false, false, 709, 2, 22, 1,  0, 0}, // #916
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 1, false, false, 709, 2, 22, 1,  0, 0}, // #917
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 1, false, false, 709, 2, 22, 1,  0, 0}, // #918
  {DBGFIELD("VGATHERQPSYrm")      1, false, false, 709, 2, 22, 1,  0, 0}, // #919
  {DBGFIELD("VGATHERQPSrm_VGATHERDPSrm") 1, false, false, 709, 2, 22, 1,  0, 0}, // #920
  {DBGFIELD("VPXORYrr")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #921
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #922
  {DBGFIELD("VPCMPGTQYrr")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #923
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false,  3, 1,  1, 1,  0, 0}, // #924
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 1, false, false,  3, 1,  1, 1,  0, 0}, // #925
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 1, false, false, 2251, 8, 11, 1,  0, 0}, // #926
  {DBGFIELD("LRETQ")              1, false, false, 893, 3, 23, 1,  0, 0}, // #927
  {DBGFIELD("CVTDQ2PSrm_VCVTDQ2PSrm") 1, false, false, 2262, 5, 11, 1,  0, 0}, // #928
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 1, false, false, 2262, 5, 11, 1,  0, 0}, // #929
  {DBGFIELD("POPF64")             1, false, false, 709, 2, 22, 1,  0, 0}, // #930
  {DBGFIELD("VGATHERQPDrm")       1, false, false, 709, 2, 22, 1,  0, 0}, // #931
  {DBGFIELD("VGATHERQPDYrm")      1, false, false, 709, 2, 22, 1,  0, 0}, // #932
  {DBGFIELD("VGATHERDPDrm")       1, false, false, 709, 2, 22, 1,  0, 0}, // #933
  {DBGFIELD("VGATHERDPSrm")       1, false, false, 709, 2, 22, 1,  0, 0}, // #934
  {DBGFIELD("VGATHERDPDYrm")      1, false, false, 709, 2, 22, 1,  0, 0}, // #935
  {DBGFIELD("VGATHERDPSYrm")      1, false, false, 709, 2, 22, 1,  0, 0}, // #936
  {DBGFIELD("PCMPEQQrr")          1, false, false, 2193, 2,  1, 1,  0, 0}, // #937
  {DBGFIELD("PCMPEQQrm")          1, false, false, 2329, 4,  5, 1, 11, 1}, // #938
  {DBGFIELD("MOV16rm")            1, false, false, 709, 2, 22, 1,  0, 0}, // #939
  {DBGFIELD("MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX") 1, false, false, 893, 3, 23, 1,  0, 0}, // #940
  {DBGFIELD("POP16rmm")           2, false, false, 2196, 3, 23, 1,  0, 0}, // #941
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 2, false, false, 2196, 3, 23, 1,  0, 0}, // #942
  {DBGFIELD("PUSHF16")            1, false, false, 135, 2,  1, 1,  0, 0}, // #943
  {DBGFIELD("LAHF")               1, false, false,  1, 1,  1, 1,  0, 0}, // #944
  {DBGFIELD("ADD16mi_ADD16mi8_ADD16mr_ADD32mi_ADD32mi8_ADD32mr_ADD64mi32_ADD64mi8_ADD64mr_ADD8mi_ADD8mi8_ADD8mr_SUB16mi_SUB16mi8_SUB16mr_SUB32mi_SUB32mi8_SUB32mr_SUB64mi32_SUB64mi8_SUB64mr_SUB8mi_SUB8mi8_SUB8mr") 1, false, false, 2216, 4,  5, 1,  0, 0}, // #945
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 1, false, false, 2209, 4,  5, 1,  0, 0}, // #946
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #947
  {DBGFIELD("MULX32rr")           3, false, false, 2390, 3, 91, 2,  0, 0}, // #948
  {DBGFIELD("MULX32rm")           3, false, false, 2385, 5, 89, 2,  0, 0}, // #949
  {DBGFIELD("MULX64rr")           3, false, false, 2398, 3, 89, 2,  0, 0}, // #950
  {DBGFIELD("MULX64rm")           3, false, false, 2393, 5, 93, 2,  0, 0}, // #951
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 1, false, false,  1, 1,  1, 1,  0, 0}, // #952
  {DBGFIELD("RETW_LRETL_LRETW")   1, false, false, 893, 3, 23, 1,  0, 0}, // #953
  {DBGFIELD("IRET16_IRET32_IRET64") 1, false, false, 893, 3, 23, 1,  0, 0}, // #954
  {DBGFIELD("AND16mi_AND16mi8_AND16mr_AND32mi_AND32mi8_AND32mr_AND64mi32_AND64mi8_AND64mr_AND8mi_AND8mi8_AND8mr_OR16mi_OR16mi8_OR16mr_OR32mi_OR32mi8_OR32mi8Locked_OR32mr_OR64mi32_OR64mi8_OR64mr_OR8mi_OR8mi8_OR8mr_XOR16mi_XOR16mi8_XOR16mr_XOR32mi_XOR32mi8_XOR32mr_XOR64mi32_XOR64mi8_XOR64mr_XOR8mi_XOR8mi8_XOR8mr") 1, false, false, 2216, 4,  5, 1,  0, 0}, // #955
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 8, false, false, 2468, 3,  8, 1,  0, 0}, // #956
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 7, false, false, 16, 1, 23, 1,  0, 0}, // #957
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 8, false, false, 2468, 3,  8, 1,  0, 0}, // #958
  {DBGFIELD("MOVSLDUPrm")         1, false, false, 2222, 4,  5, 1,  0, 0}, // #959
  {DBGFIELD("MOVSLDUPrr")         1, false, false, 198, 2,  1, 1,  0, 0}, // #960
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 3, false, false, 28, 1,  3, 1,  0, 0}, // #961
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, 196, 4,  3, 1,  0, 0}, // #962
  {DBGFIELD("VPMOVSXBDYrr_VPMOVSXBQYrr_VPMOVSXBWYrr_VPMOVSXDQYrr_VPMOVSXWDYrr_VPMOVSXWQYrr_VPMOVZXBDYrr_VPMOVZXBQYrr_VPMOVZXBWYrr_VPMOVZXDQYrr_VPMOVZXWDYrr_VPMOVZXWQYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #963
  {DBGFIELD("VPMOVZXBDYrm_VPMOVZXBQYrm_VPMOVZXBWYrm_VPMOVZXDQYrm_VPMOVZXWQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #964
  {DBGFIELD("PBLENDWrri_VPBLENDWrri") 1, false, false, 2193, 2,  1, 1,  0, 0}, // #965
  {DBGFIELD("VPBLENDWYrri")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #966
  {DBGFIELD("PBLENDWrmi_VPBLENDWrmi") 1, false, false, 2329, 4,  5, 1, 11, 1}, // #967
  {DBGFIELD("VPBLENDWYrmi")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #968
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, 2193, 2,  1, 1,  0, 0}, // #969
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 63, false, false, 2651, 10, 17, 1,  0, 0}, // #970
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 63, false, false, 2651, 10, 17, 1,  0, 0}, // #971
  {DBGFIELD("VPMASKMOVDYrm")      2, false, false, 2612, 4,  5, 1,  0, 0}, // #972
  {DBGFIELD("VPMASKMOVDrm")       1, false, false, 2620, 4,  5, 1,  0, 0}, // #973
  {DBGFIELD("VPMASKMOVDYmr_VPMASKMOVQYmr") 2, false, false, 2608, 4,  5, 1,  0, 0}, // #974
  {DBGFIELD("VPMASKMOVDmr_VPMASKMOVQmr") 1, false, false, 2616, 4,  5, 1,  0, 0}, // #975
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 1, false, false, 2329, 4,  5, 1,  0, 0}, // #976
  {DBGFIELD("VPSLLDQri_VPSRLDQri") 1, false, false, 2193, 2,  1, 1,  0, 0}, // #977
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #978
  {DBGFIELD("VPERM2F128rr")       16382, false, false,  0, 0,  0, 0,  0, 0}, // #979
  {DBGFIELD("VPERM2F128rm")       2, false, false, 2497, 4,  5, 1, 11, 1}, // #980
  {DBGFIELD("VEXTRACTF128rr")     1, false, false, 198, 2,  1, 1,  0, 0}, // #981
  {DBGFIELD("VEXTRACTF128mr")     1, false, false, 2199, 5,  1, 1,  0, 0}, // #982
  {DBGFIELD("VINSERTF128rr")      2, false, false, 2489, 2,  1, 1,  0, 0}, // #983
  {DBGFIELD("VCVTPD2DQrm_VCVTTPD2DQrm") 1, false, false, 2262, 5, 11, 1,  0, 0}, // #984
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 3, false, false, 2509, 6,  9, 1,  0, 0}, // #985
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, 2280, 8,  4, 1,  0, 0}, // #986
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 2, false, false, 2270, 10, 20, 1,  0, 0}, // #987
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, 2193, 2,  1, 1,  0, 0}, // #988
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, 2463, 2,  3, 1,  0, 0}, // #989
  {DBGFIELD("SHA256MSG2rm")       1, false, false, 2236, 5,  4, 1, 11, 1}, // #990
  {DBGFIELD("SHA256MSG2rr")       1, false, false, 2241, 3,  3, 1,  0, 0}, // #991
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, 2241, 3,  3, 1,  0, 0}, // #992
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 1, false, false, 2236, 5,  4, 1, 11, 1}, // #993
  {DBGFIELD("SHA1MSG2rr")         1, false, false, 2241, 3,  3, 1,  0, 0}, // #994
  {DBGFIELD("SHA1MSG2rm")         1, false, false, 2236, 5,  4, 1, 11, 1}, // #995
  {DBGFIELD("SHA1NEXTErr")        1, false, false, 2241, 3,  3, 1,  0, 0}, // #996
  {DBGFIELD("SHA1NEXTErm")        1, false, false, 2236, 5,  4, 1, 11, 1}, // #997
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, 2241, 3,  3, 1,  0, 0}, // #998
  {DBGFIELD("SHA1RNDS4rmi")       1, false, false, 2236, 5,  4, 1, 11, 1}, // #999
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, 2241, 3,  3, 1,  0, 0}, // #1000
  {DBGFIELD("SHA256RNDS2rm")      1, false, false, 2236, 5,  4, 1, 11, 1}, // #1001
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 2, false, false,  3, 1,  1, 1,  0, 0}, // #1002
  {DBGFIELD("BT16mi8_BT32mi8_BT64mi8") 1, false, false, 893, 3, 23, 1,  0, 0}, // #1003
  {DBGFIELD("BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 2, false, false,  1, 1,  1, 1,  0, 0}, // #1004
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 1, false, false,  1, 1,  2, 1,  0, 0}, // #1005
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1006
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1007
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 1, false, false, 893, 3, 23, 1,  0, 0}, // #1008
  {DBGFIELD("ADC64ri32_SBB64ri32") 1, false, false,  3, 1,  1, 1,  0, 0}, // #1009
  {DBGFIELD("CRC32r32r16")        3, false, false, 29, 1, 22, 1,  0, 0}, // #1010
  {DBGFIELD("CRC32r32r32")        3, false, false, 29, 1, 22, 1,  0, 0}, // #1011
  {DBGFIELD("CRC32r64r64")        3, false, false, 29, 1, 22, 1,  0, 0}, // #1012
  {DBGFIELD("SAHF")               1, false, false,  1, 1,  1, 1,  0, 0}, // #1013
  {DBGFIELD("BEXTRI32ri_BEXTRI64ri") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1014
  {DBGFIELD("BEXTRI32mi_BEXTRI64mi") 1, false, false, 893, 3, 23, 1,  0, 0}, // #1015
  {DBGFIELD("RCR8ri")             1, false, false,  1, 1,  1, 1,  0, 0}, // #1016
  {DBGFIELD("RCL16rCL")           1, false, false,  1, 1,  1, 1,  0, 0}, // #1017
  {DBGFIELD("RCR16ri")            1, false, false,  1, 1,  1, 1,  0, 0}, // #1018
  {DBGFIELD("RCL32rCL_RCL64rCL")  1, false, false,  1, 1,  1, 1,  0, 0}, // #1019
  {DBGFIELD("RCR32rCL_RCR64rCL")  1, false, false,  1, 1,  1, 1,  0, 0}, // #1020
  {DBGFIELD("RCR32ri_RCR64ri")    1, false, false,  1, 1,  1, 1,  0, 0}, // #1021
  {DBGFIELD("RCL16ri")            1, false, false,  1, 1,  1, 1,  0, 0}, // #1022
  {DBGFIELD("RCL32ri_RCL64ri")    1, false, false,  1, 1,  1, 1,  0, 0}, // #1023
  {DBGFIELD("SHLD32rri8")         6, false, false,  9, 1, 22, 1,  0, 0}, // #1024
  {DBGFIELD("SHRD16rri8")         6, false, false,  9, 1, 22, 1,  0, 0}, // #1025
  {DBGFIELD("SHLD16rrCL")         7, false, false, 16, 1, 23, 1,  0, 0}, // #1026
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 1, false, false, 2199, 5,  3, 1,  0, 0}, // #1027
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 2, false, false, 2204, 5,  1, 1,  0, 0}, // #1028
  {DBGFIELD("TST_F")              1, false, false, 2251, 6, 22, 1,  0, 0}, // #1029
  {DBGFIELD("VDPPSrri")           5, false, false, 2322, 5,  9, 1,  0, 0}, // #1030
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr") 1, false, false, 2267, 3, 22, 1,  0, 0}, // #1031
  {DBGFIELD("VFRCZSDrr_VFRCZSSrr") 1, false, false, 2267, 3, 22, 1,  0, 0}, // #1032
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 1, false, false, 2262, 5, 11, 1, 11, 1}, // #1033
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 2, false, false, 2506, 3, 22, 1,  0, 0}, // #1034
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 2, false, false, 2501, 5, 11, 1, 11, 1}, // #1035
  {DBGFIELD("MMX_CVTTPD2PIirr")   1, false, false, 2267, 3, 22, 1,  0, 0}, // #1036
  {DBGFIELD("VMOVDQUYmr")         2, false, false, 2204, 5,  1, 1,  0, 0}, // #1037
  {DBGFIELD("MOVDQArr")           1, false, false, 2193, 2,  1, 1,  0, 0}, // #1038
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 3, false, false, 2455, 4, 23, 1,  0, 0}, // #1039
  {DBGFIELD("VMPSADBWrri")        3, false, false, 2370, 3, 22, 1,  0, 0}, // #1040
  {DBGFIELD("VPPERMrrr_VPPERMrrr_REV") 3, false, false, 2463, 2,  3, 1,  0, 0}, // #1041
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 1, false, false, 2193, 2,  3, 1,  0, 0}, // #1042
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 1, false, false, 2329, 4,  4, 1, 11, 1}, // #1043
  {DBGFIELD("VPCLMULQDQrr")       1, false, false, 2241, 3,  3, 1,  0, 0}, // #1044
  {DBGFIELD("INSERTQ")            1, false, false, 2463, 2,  3, 1,  0, 0}, // #1045
  {DBGFIELD("ANDNPSrr_VANDNPSrr_ANDNPDrr_VANDNPDrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1046
  {DBGFIELD("MMX_PXORirr_MMX_PANDNirr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1047
  {DBGFIELD("PANDNrr_VPANDNrr")   16382, false, false,  0, 0,  0, 0,  0, 0}, // #1048
  {DBGFIELD("MMX_PSUBBirr_MMX_PSUBDirr_MMX_PSUBWirr_MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1049
  {DBGFIELD("LCMPXCHG8_LCMPXCHG16_LCMPXCHG32_LCMPXCHG64") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1050
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1051
  {DBGFIELD("LCMPXCHG8B_LCMPXCHG16B") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1052
  {DBGFIELD("XCHG8rr")            3, false, false, 28, 1,  3, 1,  0, 0}, // #1053
  {DBGFIELD("VANDNPSYrr_VANDNPDYrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1054
  {DBGFIELD("MMX_PSUBSBirr_MMX_PSUBSWirr_MMX_PSUBUSBirr_MMX_PSUBUSWirr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1055
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1056
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1057
  {DBGFIELD("LEA16r")             1, false, false, 29, 1, 22, 1,  0, 0}, // #1058
  {DBGFIELD("MMX_PADDSBirr_MMX_PADDSWirr_MMX_PADDUSBirr_MMX_PADDUSWirr_MMX_PAVGBirr_MMX_PAVGWirr_MMX_PCMPEQBirr_MMX_PCMPEQDirr_MMX_PCMPEQWirr_MMX_PMAXSWirr_MMX_PMINSWirr_MMX_PMAXUBirr_MMX_PMINUBirr") 1, false, false, 2193, 2,  1, 1,  0, 0}, // #1059
  {DBGFIELD("MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1060
  {DBGFIELD("CLAC_STAC")          1, false, false,  1, 1,  2, 1,  0, 0}, // #1061
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, 2193, 2,  1, 1,  0, 0}, // #1062
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1063
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, 2220, 4, 22, 1,  0, 0}, // #1064
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 1, false, false, 2193, 2,  1, 1,  0, 0}, // #1065
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 1, false, false, 2193, 2,  3, 1,  0, 0}, // #1066
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1067
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, 2267, 3, 22, 1,  0, 0}, // #1068
  {DBGFIELD("VCVTPS2DQYrr_VCVTTPS2DQYrr") 2, false, false, 2506, 3, 22, 1,  0, 0}, // #1069
  {DBGFIELD("MMX_PADDSBirm_MMX_PADDSWirm_MMX_PADDUSBirm_MMX_PADDUSWirm_MMX_PAVGBirm_MMX_PAVGWirm_MMX_PCMPEQBirm_MMX_PCMPEQDirm_MMX_PCMPEQWirm_MMX_PCMPGTBirm_MMX_PCMPGTDirm_MMX_PCMPGTWirm_MMX_PMAXSWirm_MMX_PMAXUBirm_MMX_PMINSWirm_MMX_PMINUBirm_MMX_PSUBSBirm_MMX_PSUBSWirm_MMX_PSUBUSBirm_MMX_PSUBUSWirm") 1, false, false, 2329, 4,  5, 1, 11, 1}, // #1070
  {DBGFIELD("CVTSS2SI64rr_Int")   2, false, false, 2280, 8,  4, 1,  0, 0}, // #1071
  {DBGFIELD("CVTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int") 2, false, false, 2280, 8,  4, 1,  0, 0}, // #1072
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 1, false, false, 2329, 4,  5, 1, 11, 1}, // #1073
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1074
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 1, false, false, 2329, 4,  5, 1, 11, 1}, // #1075
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 1, false, false, 2329, 4,  4, 1, 11, 1}, // #1076
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1077
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 1, false, false,  1, 1,  2, 1,  0, 0}, // #1078
  {DBGFIELD("PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1079
  {DBGFIELD("VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1080
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, 2193, 2,  1, 1,  0, 0}, // #1081
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1082
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1083
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 3, false, false, 2244, 2,  3, 1,  0, 0}, // #1084
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 6, false, false, 2493, 2, 22, 1,  0, 0}, // #1085
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, 2193, 2,  1, 1,  0, 0}, // #1086
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1087
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1088
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 3, false, false, 2405, 2,  3, 1,  0, 0}, // #1089
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1090
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false, 135, 2,  1, 1,  0, 0}, // #1091
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 2, false, false, 2204, 5,  1, 1,  0, 0}, // #1092
  {DBGFIELD("KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1093
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, 2193, 2,  1, 1,  0, 0}, // #1094
  {DBGFIELD("VPSADBWZrr")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #1095
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_VPTESTMBZ128rr_VPTESTMBZ128rrk_VPTESTMDZ128rr_VPTESTMDZ128rrk_VPTESTMQZ128rr_VPTESTMQZ128rrk_VPTESTMWZ128rr_VPTESTMWZ128rrk_VPTESTNMBZ128rr_VPTESTNMBZ128rrk_VPTESTNMDZ128rr_VPTESTNMDZ128rrk_VPTESTNMQZ128rr_VPTESTNMQZ128rrk_VPTESTNMWZ128rr_VPTESTNMWZ128rrk") 1, false, false, 2193, 2,  1, 1,  0, 0}, // #1096
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri_KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, 2193, 2,  1, 1,  0, 0}, // #1097
  {DBGFIELD("VALIGNDZ128rri_VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rri_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, 2193, 2,  1, 1,  0, 0}, // #1098
  {DBGFIELD("VALIGNDZ256rri_VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rri_VALIGNQZ256rrik_VALIGNQZ256rrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1099
  {DBGFIELD("VALIGNDZrri_VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrri_VALIGNQZrrik_VALIGNQZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1100
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, 2220, 4,  3, 1,  0, 0}, // #1101
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 2, false, false, 2487, 4,  3, 1,  0, 0}, // #1102
  {DBGFIELD("VCMPPDZrri_VCMPPDZrrib_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrrib_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1103
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, 2220, 4,  3, 1,  0, 0}, // #1104
  {DBGFIELD("VDBPSADBWZrri_VDBPSADBWZrrik_VDBPSADBWZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1105
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rrik_VPCMPDZ128rri_VPCMPDZ128rrik_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rrik_VPCMPUBZ128rri_VPCMPUBZ128rrik_VPCMPUDZ128rri_VPCMPUDZ128rrik_VPCMPUQZ128rri_VPCMPUQZ128rrik_VPCMPUWZ128rri_VPCMPUWZ128rrik_VPCMPWZ128rri_VPCMPWZ128rrik_VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, 2193, 2,  1, 1,  0, 0}, // #1106
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rrik_VPCMPDZ256rri_VPCMPDZ256rrik_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rrik_VPCMPUBZ256rri_VPCMPUBZ256rrik_VPCMPUDZ256rri_VPCMPUDZ256rrik_VPCMPUQZ256rri_VPCMPUQZ256rrik_VPCMPUWZ256rri_VPCMPUWZ256rrik_VPCMPWZ256rri_VPCMPWZ256rrik_VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1107
  {DBGFIELD("VPCMPBZrri_VPCMPBZrrik_VPCMPDZrri_VPCMPDZrrik_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrrik_VPCMPUBZrri_VPCMPUBZrrik_VPCMPUDZrri_VPCMPUDZrrik_VPCMPUQZrri_VPCMPUQZrrik_VPCMPUWZrri_VPCMPUWZrrik_VPCMPWZrri_VPCMPWZrrik_VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1108
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1109
  {DBGFIELD("VPTESTMBZrr_VPTESTMBZrrk_VPTESTMDZrr_VPTESTMDZrrk_VPTESTMQZrr_VPTESTMQZrrk_VPTESTMWZrr_VPTESTMWZrrk_VPTESTNMBZrr_VPTESTNMBZrrk_VPTESTNMDZrr_VPTESTNMDZrrk_VPTESTNMQZrr_VPTESTNMQZrrk_VPTESTNMWZrr_VPTESTNMWZrrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1110
  {DBGFIELD("VCVTDQ2PSZ128rr_VCVTDQ2PSZ128rrk_VCVTDQ2PSZ128rrkz_VCVTUDQ2PSZ128rr_VCVTUDQ2PSZ128rrk_VCVTUDQ2PSZ128rrkz") 1, false, false, 2267, 3, 22, 1,  0, 0}, // #1111
  {DBGFIELD("VCVTDQ2PSZ256rr_VCVTDQ2PSZ256rrk_VCVTDQ2PSZ256rrkz_VCVTUDQ2PSZ256rr_VCVTUDQ2PSZ256rrk_VCVTUDQ2PSZ256rrkz") 2, false, false, 2506, 3, 22, 1,  0, 0}, // #1112
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 1, false, false, 2267, 3, 22, 1,  0, 0}, // #1113
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 3, false, false, 2515, 4,  5, 1,  0, 0}, // #1114
  {DBGFIELD("VCVTPS2DQYrr")       2, false, false, 2506, 3, 22, 1,  0, 0}, // #1115
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, 2267, 3, 22, 1,  0, 0}, // #1116
  {DBGFIELD("VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 2, false, false, 2506, 3, 22, 1,  0, 0}, // #1117
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 1, false, false, 2267, 3, 22, 1,  0, 0}, // #1118
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 2, false, false, 2506, 3, 22, 1,  0, 0}, // #1119
  {DBGFIELD("VCVTDQ2PSZrr_VCVTUDQ2PSZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1120
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1121
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1122
  {DBGFIELD("VCVTQQ2PDZrr_VCVTUQQ2PDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1123
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1124
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1125
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1126
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 1, false, false, 2267, 3, 22, 1,  0, 0}, // #1127
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 1, false, false, 2267, 3, 22, 1,  0, 0}, // #1128
  {DBGFIELD("VCVTPD2PSZ128rr_VCVTPD2PSZ128rrk_VCVTPD2PSZ128rrkz") 1, false, false, 2267, 3, 22, 1,  0, 0}, // #1129
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz") 1, false, false, 2267, 3,  3, 1,  0, 0}, // #1130
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false, 2267, 3, 22, 1,  0, 0}, // #1131
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false, 2267, 3, 22, 1,  0, 0}, // #1132
  {DBGFIELD("VCVTSD2SSZrr_VCVTSD2SSZrr_Int_VCVTSD2SSZrr_Intk_VCVTSD2SSZrr_Intkz_VCVTSD2SSZrrb_Int_VCVTSD2SSZrrb_Intk_VCVTSD2SSZrrb_Intkz") 2, false, false, 2293, 3,  4, 1,  0, 0}, // #1133
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 2, false, false, 2267, 3, 23, 1, 30, 1}, // #1134
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 2, false, false, 2267, 3, 23, 1, 30, 1}, // #1135
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz") 2, false, false, 2293, 3,  4, 1,  0, 0}, // #1136
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, 2193, 2,  1, 1,  0, 0}, // #1137
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 1, false, false, 2199, 5, 23, 1,  0, 0}, // #1138
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 3, false, false, 2519, 6,  4, 1,  0, 0}, // #1139
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1140
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1141
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1142
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 1, false, false, 2329, 4,  6, 1,  0, 0}, // #1143
  {DBGFIELD("VMOVDI2PDIZrm")      1, false, false, 2329, 4,  6, 1,  0, 0}, // #1144
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 2, false, false, 2267, 3, 23, 1, 30, 1}, // #1145
  {DBGFIELD("VMOVSDZrm_VMOVSDZrm_alt_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrm_alt_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, 2222, 4,  6, 1,  0, 0}, // #1146
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 2, false, false, 2506, 3, 22, 1,  0, 0}, // #1147
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 3, false, false, 2515, 4,  5, 1,  0, 0}, // #1148
  {DBGFIELD("VCVTPD2PSZ256rr_VCVTPD2PSZ256rrk_VCVTPD2PSZ256rrkz") 3, false, false, 2515, 4,  5, 1,  0, 0}, // #1149
  {DBGFIELD("VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 2, false, false, 2506, 3,  3, 1,  0, 0}, // #1150
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 2, false, false, 2506, 3, 22, 1,  0, 0}, // #1151
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 2, false, false, 2506, 3, 22, 1,  0, 0}, // #1152
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1153
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1154
  {DBGFIELD("VCVTPD2PSZrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1155
  {DBGFIELD("VCVTPS2PDZrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1156
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1157
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1158
  {DBGFIELD("VMOVNTDQAZ128rm")    1, false, false, 709, 2,  6, 1,  0, 0}, // #1159
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 3, false, false, 2244, 4,  4, 1, 11, 1}, // #1160
  {DBGFIELD("VBROADCASTI32X2Z128m_VBROADCASTI32X2Z128mk_VBROADCASTI32X2Z128mkz_VPBROADCASTDZ128m_VPBROADCASTDZ128mk_VPBROADCASTDZ128mkz_VPBROADCASTQZ128m_VPBROADCASTQZ128mk_VPBROADCASTQZ128mkz") 1, false, false, 2329, 4,  5, 1,  0, 0}, // #1161
  {DBGFIELD("VBROADCASTSSZ128m_VBROADCASTSSZ128mk_VBROADCASTSSZ128mkz") 2, false, false, 2497, 4,  5, 1,  0, 0}, // #1162
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, 709, 2,  6, 1,  0, 0}, // #1163
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 1, false, false, 2222, 4,  5, 1,  0, 0}, // #1164
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, 709, 2,  6, 1,  0, 0}, // #1165
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 1, false, false, 2329, 4,  5, 1, 11, 1}, // #1166
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 3, false, false, 2401, 4,  4, 1, 11, 1}, // #1167
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1168
  {DBGFIELD("VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 2, false, false, 2280, 8,  4, 1,  0, 0}, // #1169
  {DBGFIELD("VCVTSS2SI64rr_Int")  2, false, false, 2280, 8,  4, 1,  0, 0}, // #1170
  {DBGFIELD("VCVTTSS2SI64rr")     2, false, false, 2280, 8,  4, 1,  0, 0}, // #1171
  {DBGFIELD("VCVTTSS2SI64rr_Int") 2, false, false, 2280, 8,  4, 1,  0, 0}, // #1172
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, 709, 2, 22, 1,  0, 0}, // #1173
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1174
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 1, false, false, 135, 2,  1, 1,  0, 0}, // #1175
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 1, false, false, 135, 2,  1, 1,  0, 0}, // #1176
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 1, false, false, 135, 2,  1, 1,  0, 0}, // #1177
  {DBGFIELD("VSCATTERDPSZmr")     1, false, false, 135, 2,  1, 1,  0, 0}, // #1178
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk") 1, false, false, 2220, 6,  4, 1, 11, 1}, // #1179
  {DBGFIELD("VPBROADCASTBZ256m_VPBROADCASTBZ256mk_VPBROADCASTBZ256mkz_VPBROADCASTBZm_VPBROADCASTBZmk_VPBROADCASTBZmkz_VPBROADCASTWZ256m_VPBROADCASTWZ256mk_VPBROADCASTWZ256mkz_VPBROADCASTWZm_VPBROADCASTWZmk_VPBROADCASTWZmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1180
  {DBGFIELD("VMOVNTDQAZ256rm")    2, false, false, 805, 2,  6, 1,  0, 0}, // #1181
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 6, false, false, 2493, 4, 11, 1, 11, 1}, // #1182
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1183
  {DBGFIELD("VBROADCASTF32X2Z256m_VBROADCASTF32X2Z256mk_VBROADCASTF32X2Z256mkz_VBROADCASTF32X2Zm_VBROADCASTF32X2Zmk_VBROADCASTF32X2Zmkz_VBROADCASTI32X2Z256m_VBROADCASTI32X2Z256mk_VBROADCASTI32X2Z256mkz_VBROADCASTI32X2Zm_VBROADCASTI32X2Zmk_VBROADCASTI32X2Zmkz_VPBROADCASTDZ256m_VPBROADCASTDZ256mk_VPBROADCASTDZ256mkz_VPBROADCASTDZm_VPBROADCASTDZmk_VPBROADCASTDZmkz_VPBROADCASTQZ256m_VPBROADCASTQZ256mk_VPBROADCASTQZ256mkz_VPBROADCASTQZm_VPBROADCASTQZmk_VPBROADCASTQZmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1184
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1185
  {DBGFIELD("VBROADCASTSDZ256m_VBROADCASTSDZ256mk_VBROADCASTSDZ256mkz_VBROADCASTSDZm_VBROADCASTSDZmk_VBROADCASTSDZmkz_VBROADCASTSSZ256m_VBROADCASTSSZ256mk_VBROADCASTSSZ256mkz_VBROADCASTSSZm_VBROADCASTSSZmk_VBROADCASTSSZmkz") 2, false, false, 2497, 4,  5, 1,  0, 0}, // #1186
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 2, false, false, 2497, 4,  5, 1, 11, 1}, // #1187
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1188
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 2, false, false, 805, 2,  6, 1,  0, 0}, // #1189
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, 2489, 4,  5, 1,  0, 0}, // #1190
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1191
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 2, false, false, 805, 2,  6, 1,  0, 0}, // #1192
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1193
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1194
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1195
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1196
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 1, false, false, 135, 2,  1, 1,  0, 0}, // #1197
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 1, false, false, 135, 2,  1, 1,  0, 0}, // #1198
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 1, false, false, 135, 2,  1, 1,  0, 0}, // #1199
  {DBGFIELD("VPSCATTERDDZmr")     1, false, false, 135, 2,  1, 1,  0, 0}, // #1200
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 1, false, false, 2329, 4,  5, 1, 11, 1}, // #1201
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmik") 1, false, false, 2220, 6,  4, 1, 11, 1}, // #1202
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 1, false, false, 2220, 6,  4, 1, 11, 1}, // #1203
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmik_VPCMPDZ128rmi_VPCMPDZ128rmib_VPCMPDZ128rmibk_VPCMPDZ128rmik_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmib_VPCMPQZ128rmibk_VPCMPQZ128rmik_VPCMPUBZ128rmi_VPCMPUBZ128rmik_VPCMPUDZ128rmi_VPCMPUDZ128rmib_VPCMPUDZ128rmibk_VPCMPUDZ128rmik_VPCMPUQZ128rmi_VPCMPUQZ128rmib_VPCMPUQZ128rmibk_VPCMPUQZ128rmik_VPCMPUWZ128rmi_VPCMPUWZ128rmik_VPCMPWZ128rmi_VPCMPWZ128rmik_VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 1, false, false, 2329, 4,  5, 1, 11, 1}, // #1204
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1205
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1206
  {DBGFIELD("VPMOVSXBDZ128rm_VPMOVSXBDZ128rmk_VPMOVSXBDZ128rmkz_VPMOVSXBQZ128rm_VPMOVSXBQZ128rmk_VPMOVSXBQZ128rmkz_VPMOVSXBWZ128rm_VPMOVSXBWZ128rmk_VPMOVSXBWZ128rmkz_VPMOVSXDQZ128rm_VPMOVSXDQZ128rmk_VPMOVSXDQZ128rmkz_VPMOVSXWDZ128rm_VPMOVSXWDZ128rmk_VPMOVSXWDZ128rmkz_VPMOVSXWQZ128rm_VPMOVSXWQZ128rmk_VPMOVSXWQZ128rmkz_VPMOVZXBDZ128rm_VPMOVZXBDZ128rmk_VPMOVZXBDZ128rmkz_VPMOVZXBQZ128rm_VPMOVZXBQZ128rmk_VPMOVZXBQZ128rmkz_VPMOVZXBWZ128rm_VPMOVZXBWZ128rmk_VPMOVZXBWZ128rmkz_VPMOVZXDQZ128rm_VPMOVZXDQZ128rmk_VPMOVZXDQZ128rmkz_VPMOVZXWDZ128rm_VPMOVZXWDZ128rmk_VPMOVZXWDZ128rmkz_VPMOVZXWQZ128rm_VPMOVZXWQZ128rmk_VPMOVZXWQZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1207
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 1, false, false, 2329, 4,  5, 1, 11, 1}, // #1208
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1209
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1210
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmik") 2, false, false, 2487, 6,  4, 1, 11, 1}, // #1211
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmik") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1212
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmik_VPCMPDZ256rmi_VPCMPDZ256rmib_VPCMPDZ256rmibk_VPCMPDZ256rmik_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmib_VPCMPQZ256rmibk_VPCMPQZ256rmik_VPCMPUBZ256rmi_VPCMPUBZ256rmik_VPCMPUDZ256rmi_VPCMPUDZ256rmib_VPCMPUDZ256rmibk_VPCMPUDZ256rmik_VPCMPUQZ256rmi_VPCMPUQZ256rmib_VPCMPUQZ256rmibk_VPCMPUQZ256rmik_VPCMPUWZ256rmi_VPCMPUWZ256rmik_VPCMPWZ256rmi_VPCMPWZ256rmik_VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1213
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmik_VPCMPDZrmi_VPCMPDZrmib_VPCMPDZrmibk_VPCMPDZrmik_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmib_VPCMPQZrmibk_VPCMPQZrmik_VPCMPUBZrmi_VPCMPUBZrmik_VPCMPUDZrmi_VPCMPUDZrmib_VPCMPUDZrmibk_VPCMPUDZrmik_VPCMPUQZrmi_VPCMPUQZrmib_VPCMPUQZrmibk_VPCMPUQZrmik_VPCMPUWZrmi_VPCMPUWZrmik_VPCMPWZrmi_VPCMPWZrmik_VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1214
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1215
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1216
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 1, false, false, 2262, 5, 11, 1,  0, 0}, // #1217
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 1, false, false, 2262, 5, 11, 1,  0, 0}, // #1218
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 1, false, false, 2262, 5, 11, 1,  0, 0}, // #1219
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 1, false, false, 2262, 5, 11, 1,  0, 0}, // #1220
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 1, false, false, 2262, 5, 11, 1,  0, 0}, // #1221
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 1, false, false, 2262, 5,  4, 1,  0, 0}, // #1222
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz") 2, false, false, 2288, 5, 20, 1, 11, 1}, // #1223
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1224
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 2, false, false, 2501, 5, 11, 1,  0, 0}, // #1225
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1226
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 2, false, false, 2501, 5, 11, 1,  0, 0}, // #1227
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1228
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 2, false, false, 2501, 5, 11, 1,  0, 0}, // #1229
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1230
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 2, false, false, 2501, 5,  4, 1,  0, 0}, // #1231
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1232
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 3, false, false, 2509, 6,  9, 1,  0, 0}, // #1233
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1234
  {DBGFIELD("VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 2, false, false, 2501, 5, 11, 1,  0, 0}, // #1235
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1236
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1237
  {DBGFIELD("VCVTSD2SSZrm_VCVTSD2SSZrm_Int_VCVTSD2SSZrm_Intk_VCVTSD2SSZrm_Intkz") 2, false, false, 2288, 5, 20, 1, 11, 1}, // #1238
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 1, false, false, 2329, 4,  5, 1,  0, 0}, // #1239
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, 2241, 3,  3, 1,  0, 0}, // #1240
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1241
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1242
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1243
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 2, false, false, 2270, 10, 20, 1, 11, 1}, // #1244
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 2, false, false, 2270, 10, 20, 1, 11, 1}, // #1245
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1246
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1247
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1248
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1249
  {DBGFIELD("VCVTPD2PSZrm_VCVTPD2PSZrmb_VCVTPD2PSZrmbk_VCVTPD2PSZrmbkz_VCVTPD2PSZrmk_VCVTPD2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1250
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1251
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1252
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 1, false, false, 2329, 4,  5, 1,  0, 0}, // #1253
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 1, false, false, 2236, 5,  4, 1, 11, 1}, // #1254
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1255
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1256
  {DBGFIELD("VGATHERDPSZ128rm_VGATHERQPSZrm_VPGATHERDDZ128rm") 1, false, false, 709, 2, 22, 1,  0, 0}, // #1257
  {DBGFIELD("VGATHERQPSZ128rm_VGATHERQPSZ256rm_VPGATHERQDZ128rm_VPGATHERQDZ256rm") 1, false, false, 709, 2, 22, 1,  0, 0}, // #1258
  {DBGFIELD("VGATHERDPDZ128rm_VGATHERQPDZ128rm_VPGATHERDQZ128rm_VPGATHERQQZ128rm") 1, false, false, 709, 2, 22, 1,  0, 0}, // #1259
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz") 1, false, false, 2193, 2,  1, 1,  0, 0}, // #1260
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1261
  {DBGFIELD("VGATHERDPDZ256rm_VGATHERQPDZ256rm_VPGATHERDQZ256rm_VPGATHERQDZrm_VPGATHERQQZ256rm") 1, false, false, 709, 2, 22, 1,  0, 0}, // #1262
  {DBGFIELD("VGATHERDPDZrm_VGATHERQPDZrm_VPGATHERDQZrm_VPGATHERQQZrm") 1, false, false, 709, 2, 22, 1,  0, 0}, // #1263
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm") 1, false, false, 709, 2, 22, 1,  0, 0}, // #1264
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1265
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 1, false, false, 709, 2, 22, 1,  0, 0}, // #1266
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1267
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1268
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1269
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1270
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1271
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1272
  {DBGFIELD("VXORPSZ128rr_VXORPDZ128rr") 1, false, false, 198, 2,  1, 1,  0, 0}, // #1273
  {DBGFIELD("VXORPSZ256rr_VXORPDZ256rr") 2, false, false, 2489, 2,  1, 1,  0, 0}, // #1274
  {DBGFIELD("VXORPSZrr_VXORPDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1275
  {DBGFIELD("VPXORDZ128rr_VPXORQZ128rr") 1, false, false, 2193, 2,  1, 1,  0, 0}, // #1276
  {DBGFIELD("VPXORDZ256rr_VPXORQZ256rr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1277
  {DBGFIELD("VPXORDZrr_VPXORQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1278
  {DBGFIELD("VPSUBBZ128rr_VPSUBDZ128rr_VPSUBQZ128rr_VPSUBWZ128rr") 1, false, false, 2193, 2,  1, 1,  0, 0}, // #1279
  {DBGFIELD("VPSUBBZ256rr_VPSUBDZ256rr_VPSUBQZ256rr_VPSUBWZ256rr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1280
  {DBGFIELD("VPSUBBZrr_VPSUBDZrr_VPSUBQZrr_VPSUBWZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1281
  {DBGFIELD("PdWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1282
  {DBGFIELD("WriteVecALU")        1, false, false, 2193, 2,  1, 1,  0, 0}, // #1283
  {DBGFIELD("JWriteZeroLatency")  1, false, false,  0, 0,  0, 1,  0, 0}, // #1284
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 18, false, false, 2661, 4, 63, 1,  4, 2}, // #1285
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 28, false, false, 2665, 4, 98, 1,  4, 2}, // #1286
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, 2669, 4,  7, 1,  4, 2}, // #1287
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 6, false, false, 2673, 4, 28, 1,  4, 2}, // #1288
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 18, false, false, 2195, 4,  9, 1,  4, 2}, // #1289
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 28, false, false, 2677, 4, 38, 1,  4, 2}, // #1290
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, 2195, 4,  9, 1,  4, 2}, // #1291
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 6, false, false, 2195, 4,  9, 1,  4, 2}, // #1292
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, 28, 1, 22, 1,  4, 2}, // #1293
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, 28, 1, 22, 1,  4, 2}, // #1294
  {DBGFIELD("JWriteLOCK_CMPXCHG8B") 18, false, false, 2661, 4, 63, 1,  0, 0}, // #1295
  {DBGFIELD("JWriteLOCK_CMPXCHG16B") 28, false, false, 2665, 4, 98, 1,  0, 0}, // #1296
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm") 5, false, false, 2669, 4,  7, 1,  0, 0}, // #1297
  {DBGFIELD("JWriteLOCK_CMPXCHGrm") 6, false, false, 2673, 4, 28, 1,  0, 0}, // #1298
  {DBGFIELD("JWriteCMPXCHG8B")    18, false, false, 2195, 4,  9, 1,  0, 0}, // #1299
  {DBGFIELD("JWriteCMPXCHG16B")   28, false, false, 2677, 4, 38, 1,  0, 0}, // #1300
  {DBGFIELD("JWriteCMPXCHG8rm")   5, false, false, 2195, 4,  9, 1,  0, 0}, // #1301
  {DBGFIELD("WriteCMPXCHGRMW")    6, false, false, 2195, 4,  9, 1,  0, 0}, // #1302
  {DBGFIELD("JWriteCMPXCHG8rr")   3, false, false, 28, 1, 22, 1,  0, 0}, // #1303
  {DBGFIELD("WriteCMPXCHG")       5, false, false, 28, 1, 22, 1,  0, 0}, // #1304
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 18, false, false, 2661, 4, 63, 1, 31, 4}, // #1305
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 28, false, false, 2665, 4, 98, 1, 31, 4}, // #1306
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 5, false, false, 2669, 4,  7, 1, 31, 4}, // #1307
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 6, false, false, 2673, 4, 28, 1, 31, 4}, // #1308
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 18, false, false, 2195, 4,  9, 1, 31, 4}, // #1309
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 28, false, false, 2677, 4, 38, 1, 31, 4}, // #1310
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 5, false, false, 2195, 4,  9, 1, 31, 4}, // #1311
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 6, false, false, 2195, 4,  9, 1, 31, 4}, // #1312
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 3, false, false, 28, 1, 22, 1, 31, 4}, // #1313
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 5, false, false, 28, 1, 22, 1, 31, 4}, // #1314
  {DBGFIELD("JWriteLOCK_XADDrm_XCHG_Part_JWriteXCHGrm_LdSt_Part_ReadAfterLd") 4, false, false, 2669, 4, 101, 2,  1, 1}, // #1315
  {DBGFIELD("JWriteXADDrm_XCHG_Part_JWriteXADDrm_LdSt_Part_ReadAfterLd") 4, false, false, 2195, 4, 103, 2,  1, 1}, // #1316
  {DBGFIELD("SBWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1317
  {DBGFIELD("WriteALU")           1, false, false,  1, 1,  1, 1,  0, 0}, // #1318
  {DBGFIELD("HWWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1319
  {DBGFIELD("BWWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1320
  {DBGFIELD("SKLWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1321
  {DBGFIELD("SKXWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1322
  {DBGFIELD("WriteFLogic")        1, false, false, 198, 2,  1, 1,  0, 0}, // #1323
  {DBGFIELD("WriteFLogicY")       2, false, false, 2489, 2,  1, 1,  0, 0}, // #1324
  {DBGFIELD("JWriteZeroIdiomYmm") 2, false, false, 198, 2,  1, 1,  0, 0}, // #1325
  {DBGFIELD("WriteVecLogicX")     1, false, false, 2193, 2,  1, 1,  0, 0}, // #1326
  {DBGFIELD("WriteVecALUX")       1, false, false, 2193, 2,  1, 1,  0, 0}, // #1327
  {DBGFIELD("SKLWritePSUB")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1328
  {DBGFIELD("SKXWritePSUB")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1329
  {DBGFIELD("SBWritePCMPGTQ")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1330
  {DBGFIELD("HWWritePCMPGTQ")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1331
  {DBGFIELD("BWWritePCMPGTQ")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1332
  {DBGFIELD("SKLWritePCMPGTQ")    0, false, false,  0, 0,  0, 0,  0, 0}, // #1333
  {DBGFIELD("SKXWritePCMPGTQ")    0, false, false,  0, 0,  0, 0,  0, 0}, // #1334
  {DBGFIELD("SBWriteCMOVA_CMOVBErr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1335
  {DBGFIELD("WriteCMOV")          0, false, false,  0, 0,  0, 0,  0, 0}, // #1336
  {DBGFIELD("HWWriteCMOVA_CMOVBErr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1337
  {DBGFIELD("BWWriteCMOVA_CMOVBErr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1338
  {DBGFIELD("SKLWriteCMOVA_CMOVBErr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1339
  {DBGFIELD("SKXWriteCMOVA_CMOVBErr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1340
  {DBGFIELD("SBWriteCMOVA_CMOVBErm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1341
  {DBGFIELD("WriteCMOVLd")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1342
  {DBGFIELD("HWWriteCMOVA_CMOVBErm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1343
  {DBGFIELD("BWWriteCMOVA_CMOVBErm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1344
  {DBGFIELD("PdWriteCMOVm")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1345
  {DBGFIELD("SKLWriteCMOVA_CMOVBErm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1346
  {DBGFIELD("SKXWriteCMOVA_CMOVBErm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1347
  {DBGFIELD("SBWriteSETA_SETBEr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1348
  {DBGFIELD("WriteSETCC")         0, false, false,  0, 0,  0, 0,  0, 0}, // #1349
  {DBGFIELD("HWWriteSETA_SETBEr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1350
  {DBGFIELD("BWWriteSETA_SETBEr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1351
  {DBGFIELD("SKLWriteSETA_SETBEr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1352
  {DBGFIELD("SKXWriteSETA_SETBEr") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1353
  {DBGFIELD("SBWriteSETA_SETBEm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1354
  {DBGFIELD("WriteSETCCStore")    0, false, false,  0, 0,  0, 0,  0, 0}, // #1355
  {DBGFIELD("HWWriteSETA_SETBEm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1356
  {DBGFIELD("BWWriteSETA_SETBEm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1357
  {DBGFIELD("PdWriteSETGEmSETGmSETLEmSETLm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1358
  {DBGFIELD("SKLWriteSETA_SETBEm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1359
  {DBGFIELD("SKXWriteSETA_SETBEm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1360
  {DBGFIELD("WriteVecLogicY")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1361
  {DBGFIELD("WriteVecALUY")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1362
  {DBGFIELD("HWWriteADC0")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1363
  {DBGFIELD("WriteADC")           0, false, false,  0, 0,  0, 0,  0, 0}, // #1364
  {DBGFIELD("JWriteLOCK_ALURMW")  1, false, false, 2681, 4, 63, 1,  0, 0}, // #1365
  {DBGFIELD("WriteALURMW")        1, false, false, 2216, 4,  5, 1,  0, 0}, // #1366
  {DBGFIELD("WriteFShuffle256")   2, false, false, 2489, 2,  1, 1,  0, 0}, // #1367
  {DBGFIELD("WriteVecLogic")      1, false, false, 2193, 2,  1, 1,  0, 0}, // #1368
  {DBGFIELD("JWrite3OpsLEA")      1, false, false, 2685, 4,  3, 1,  0, 0}, // #1369
  {DBGFIELD("WriteLEA")           1, false, false,  1, 1,  1, 1,  0, 0}, // #1370
  {DBGFIELD("WriteFLogicZ")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1371
  {DBGFIELD("WriteVecLogicZ")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1372
}; // BtVer2ModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc SkylakeServerModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  16383, false, false,  0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false, 714, 2,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false, 2689, 5,  1, 1,  0, 0}, // #3
  {DBGFIELD("WriteCMPXCHGRMW")    6, false, false, 716, 8, 11, 1,  0, 0}, // #4
  {DBGFIELD("WriteJumpLd")        2, false, false, 724, 6,  5, 1,  0, 0}, // #5
  {DBGFIELD("WriteMove")          1, false, false, 714, 2,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteJump")          1, false, false, 730, 4,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, 714, 2,  2, 1,  0, 0}, // #8
  {DBGFIELD("WriteSHDrri")        1, false, false, 734, 7, 22, 1,  0, 0}, // #9
  {DBGFIELD("WriteFStoreX")       2, false, false, 741, 4,  1, 1,  0, 0}, // #10
  {DBGFIELD("WriteFLoadX")        1, false, false, 745, 3,  5, 1,  0, 0}, // #11
  {DBGFIELD("WriteFStoreY")       2, false, false, 741, 4,  1, 1,  0, 0}, // #12
  {DBGFIELD("WriteFLoadY")        1, false, false, 745, 3,  4, 1,  0, 0}, // #13
  {DBGFIELD("WriteMicrocoded")    1, false, false, 714, 2,  2, 1,  0, 0}, // #14
  {DBGFIELD("WriteFSign")         1, false, false, 893, 9,  1, 1,  0, 0}, // #15
  {DBGFIELD("WriteADC")           1, false, false, 730, 4,  1, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCRMW")        6, false, false, 716, 8, 11, 1,  0, 0}, // #17
  {DBGFIELD("WriteADCLd_ReadAfterLd") 2, false, false, 724, 6,  5, 1, 11, 1}, // #18
  {DBGFIELD("WriteALURMW")        3, false, false, 756, 6,  4, 1,  0, 0}, // #19
  {DBGFIELD("WriteALULd_ReadAfterLd") 2, false, false, 762, 4,  5, 1, 11, 1}, // #20
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 2, false, false, 1226, 6, 19, 1, 24, 1}, // #21
  {DBGFIELD("WriteFAdd64X")       1, false, false, 1173, 4, 23, 1,  0, 0}, // #22
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 2, false, false, 1226, 6, 19, 1, 24, 1}, // #23
  {DBGFIELD("WriteFAddX")         1, false, false, 1173, 4, 23, 1,  0, 0}, // #24
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 2, false, false, 1226, 6,  8, 1, 11, 1}, // #25
  {DBGFIELD("WriteFAdd64")        1, false, false, 1173, 4, 23, 1,  0, 0}, // #26
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 2, false, false, 1226, 6,  8, 1, 11, 1}, // #27
  {DBGFIELD("WriteFAdd")          1, false, false, 1173, 4, 23, 1,  0, 0}, // #28
  {DBGFIELD("WriteFAddLd")        2, false, false, 1226, 6,  8, 1,  0, 0}, // #29
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 2, false, false, 903, 11, 19, 1, 24, 1}, // #30
  {DBGFIELD("WriteAESDecEnc")     1, false, false, 893, 9, 23, 1,  0, 0}, // #31
  {DBGFIELD("WriteAESIMCLd")      3, false, false, 1304, 11, 21, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESIMC")        2, false, false, 1315, 9, 11, 1,  0, 0}, // #33
  {DBGFIELD("WriteAESKeyGenLd")   11, false, false, 2694, 14, 34, 1,  0, 0}, // #34
  {DBGFIELD("WriteAESKeyGen")     11, false, false, 2708, 12, 30, 1,  0, 0}, // #35
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 2, false, false, 770, 5,  4, 1, 24, 1}, // #36
  {DBGFIELD("WriteFLogic")        1, false, false, 713, 3,  1, 1,  0, 0}, // #37
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 829, 8,  4, 1, 21, 1}, // #38
  {DBGFIELD("WriteBEXTR")         2, false, false, 837, 6,  3, 1,  0, 0}, // #39
  {DBGFIELD("WriteBEXTRLd")       3, false, false, 829, 8,  4, 1,  0, 0}, // #40
  {DBGFIELD("WriteALULd")         2, false, false, 762, 4,  5, 1,  0, 0}, // #41
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 2, false, false, 770, 5,  4, 1, 24, 1}, // #42
  {DBGFIELD("WriteFBlend")        1, false, false, 713, 3,  1, 1,  0, 0}, // #43
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 3, false, false, 1351, 5, 11, 1, 24, 1}, // #44
  {DBGFIELD("WriteFVarBlend")     2, false, false, 1055, 3,  3, 1,  0, 0}, // #45
  {DBGFIELD("WriteBLSLd")         2, false, false, 843, 6,  5, 1,  0, 0}, // #46
  {DBGFIELD("WriteBLS")           1, false, false, 712, 4,  1, 1,  0, 0}, // #47
  {DBGFIELD("WriteBSFLd")         2, false, false, 766, 9, 11, 1,  0, 0}, // #48
  {DBGFIELD("WriteBSF")           1, false, false, 734, 7, 22, 1,  0, 0}, // #49
  {DBGFIELD("WriteBSRLd")         2, false, false, 766, 9, 11, 1,  0, 0}, // #50
  {DBGFIELD("WriteBSR")           1, false, false, 734, 7, 22, 1,  0, 0}, // #51
  {DBGFIELD("WriteBSWAP32")       1, false, false, 712, 4,  1, 1,  0, 0}, // #52
  {DBGFIELD("WriteBSWAP64")       2, false, false, 837, 6,  3, 1,  0, 0}, // #53
  {DBGFIELD("WriteBitTestImmLd")  2, false, false, 724, 6,  5, 1,  0, 0}, // #54
  {DBGFIELD("WriteBitTestRegLd")  2, false, false, 762, 4,  5, 1,  0, 0}, // #55
  {DBGFIELD("WriteBitTest")       1, false, false, 730, 4,  1, 1,  0, 0}, // #56
  {DBGFIELD("WriteBitTestSetImmRMW") 4, false, false, 849, 8,  5, 1,  0, 0}, // #57
  {DBGFIELD("WriteBitTestSetRegRMW") 3, false, false, 756, 6,  5, 1,  0, 0}, // #58
  {DBGFIELD("WriteBitTestSet")    1, false, false, 730, 4,  1, 1,  0, 0}, // #59
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 843, 6,  5, 1, 21, 1}, // #60
  {DBGFIELD("WriteBZHI")          1, false, false, 712, 4,  1, 1,  0, 0}, // #61
  {DBGFIELD("WriteLoad")          1, false, false, 745, 3,  6, 1,  0, 0}, // #62
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 2, false, false, 724, 6,  5, 1, 11, 1}, // #63
  {DBGFIELD("WriteCMOV")          1, false, false, 730, 4,  1, 1,  0, 0}, // #64
  {DBGFIELD("WriteFCMOV")         1, false, false, 734, 7, 22, 1,  0, 0}, // #65
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 762, 4,  5, 1, 21, 1}, // #66
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 2, false, false, 1226, 6, 19, 1, 24, 1}, // #67
  {DBGFIELD("WriteFCmp64X")       1, false, false, 1173, 4, 23, 1,  0, 0}, // #68
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 2, false, false, 1226, 6, 19, 1, 24, 1}, // #69
  {DBGFIELD("WriteFCmpX")         1, false, false, 1173, 4, 23, 1,  0, 0}, // #70
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 2, false, false, 1226, 6,  8, 1, 11, 1}, // #71
  {DBGFIELD("WriteFCmp64")        1, false, false, 1173, 4, 23, 1,  0, 0}, // #72
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 2, false, false, 1226, 6,  8, 1, 11, 1}, // #73
  {DBGFIELD("WriteFCmp")          1, false, false, 1173, 4, 23, 1,  0, 0}, // #74
  {DBGFIELD("WriteCMPXCHG")       5, false, false, 857, 4,  6, 1,  0, 0}, // #75
  {DBGFIELD("WriteFComLd_ReadAfterVecLd") 2, false, false, 903, 11,  4, 1, 11, 1}, // #76
  {DBGFIELD("WriteFCom")          1, false, false, 893, 9,  3, 1,  0, 0}, // #77
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #78
  {DBGFIELD("WriteCRC32")         1, false, false, 734, 7, 22, 1,  0, 0}, // #79
  {DBGFIELD("WriteNop")           1, false, false,  0, 0,  1, 1,  0, 0}, // #80
  {DBGFIELD("WriteCvtI2PDLd")     2, false, false, 1226, 6,  8, 1,  0, 0}, // #81
  {DBGFIELD("WriteCvtI2PD")       1, false, false, 1173, 4, 23, 1,  0, 0}, // #82
  {DBGFIELD("WriteCvtI2PSLd")     2, false, false, 1226, 6,  8, 1,  0, 0}, // #83
  {DBGFIELD("WriteCvtI2PS")       1, false, false, 1173, 4, 23, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtPD2ILd")     2, false, false, 1226, 6, 11, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtPD2I")       1, false, false, 1173, 4, 22, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtPD2PSLd")    2, false, false, 766, 9, 11, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtPD2PS")      1, false, false, 734, 7, 22, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtPS2ILd")     2, false, false, 1226, 6, 11, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtPS2I")       1, false, false, 1173, 4, 22, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPS2PDLd")    2, false, false, 766, 9, 11, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPS2PD")      1, false, false, 734, 7, 22, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtSD2ILd")     3, false, false, 2720, 6,  9, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtSD2I")       2, false, false, 1054, 4,  5, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtSD2SSLd")    2, false, false, 766, 9, 11, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #96
  {DBGFIELD("WriteCvtSD2SS")      1, false, false, 734, 7, 22, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, 766, 9,  8, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 2, false, false, 766, 9,  8, 1, 11, 1}, // #99
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 1, false, false, 734, 7, 23, 1,  0, 1}, // #100
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 1, false, false, 734, 7, 23, 1,  3, 1}, // #101
  {DBGFIELD("WriteCvtI2SSLd")     2, false, false, 766, 9,  8, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 2, false, false, 766, 9,  8, 1, 11, 1}, // #103
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 1, false, false, 734, 7, 23, 1,  0, 1}, // #104
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 1, false, false, 734, 7, 23, 1,  3, 1}, // #105
  {DBGFIELD("WriteCvtSS2SDLd")    2, false, false, 766, 9, 11, 1,  0, 0}, // #106
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #107
  {DBGFIELD("WriteCvtSS2SD")      1, false, false, 734, 7, 22, 1,  0, 0}, // #108
  {DBGFIELD("WriteCvtSS2ILd")     3, false, false, 2720, 6,  9, 1,  0, 0}, // #109
  {DBGFIELD("WriteCvtSS2I")       2, false, false, 1054, 4,  5, 1,  0, 0}, // #110
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 2, false, false, 1054, 4,  5, 1,  0, 0}, // #111
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 2, false, false, 1054, 4,  5, 1,  0, 0}, // #112
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2726, 12, 36, 1, 22, 2}, // #113
  {DBGFIELD("WriteDiv16")         32, false, false, 2738, 15, 105, 1,  0, 0}, // #114
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2726, 12, 36, 1, 22, 2}, // #115
  {DBGFIELD("WriteDiv32")         32, false, false, 2738, 15, 105, 1,  0, 0}, // #116
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2726, 12, 36, 1, 22, 2}, // #117
  {DBGFIELD("WriteDiv64")         32, false, false, 2738, 15, 105, 1,  0, 0}, // #118
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2726, 12, 36, 1, 22, 2}, // #119
  {DBGFIELD("WriteDiv8")          1, false, false, 892, 10, 34, 1,  0, 0}, // #120
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 2, false, false, 2753, 12, 30, 1, 24, 1}, // #121
  {DBGFIELD("WriteFDiv64X")       1, false, false, 946, 10, 21, 1,  0, 0}, // #122
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 2, false, false, 924, 12, 28, 1, 24, 1}, // #123
  {DBGFIELD("WriteFDivX")         1, false, false, 946, 10,  9, 1,  0, 0}, // #124
  {DBGFIELD("WriteFDivLd")        2, false, false, 2765, 12,  7, 1,  0, 0}, // #125
  {DBGFIELD("WriteFDiv")          1, false, false, 946, 10,  9, 1,  0, 0}, // #126
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 2, false, false, 2753, 12, 63, 1, 11, 1}, // #127
  {DBGFIELD("WriteFDiv64")        1, false, false, 946, 10, 21, 1,  0, 0}, // #128
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 2, false, false, 2765, 12,  7, 1, 11, 1}, // #129
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 4, false, false, 2777, 10, 10, 1, 24, 1}, // #130
  {DBGFIELD("WriteDPPD")          3, false, false, 2787, 8,  8, 1,  0, 0}, // #131
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 5, false, false, 2795, 10, 63, 1, 24, 1}, // #132
  {DBGFIELD("WriteDPPS")          4, false, false, 2805, 8, 27, 1,  0, 0}, // #133
  {DBGFIELD("WriteStore")         1, false, false, 741, 4,  1, 1,  0, 0}, // #134
  {DBGFIELD("WriteVecExtractSt")  3, false, false, 1026, 11,  3, 1,  0, 0}, // #135
  {DBGFIELD("WriteVecExtract")    2, false, false, 1037, 12, 22, 1,  0, 0}, // #136
  {DBGFIELD("WriteVecALUX")       1, false, false, 1173, 4,  1, 1,  0, 0}, // #137
  {DBGFIELD("WriteFComLd")        2, false, false, 903, 11,  4, 1,  0, 0}, // #138
  {DBGFIELD("WriteEMMS")          10, false, false, 2813, 5, 19, 1,  0, 0}, // #139
  {DBGFIELD("WriteFLDC")          2, false, false, 2818, 5,  1, 1,  0, 0}, // #140
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 2, false, false, 1226, 6,  4, 1, 24, 1}, // #141
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 4, false, false, 2823, 10, 20, 1, 24, 1}, // #142
  {DBGFIELD("WriteFHAdd")         3, false, false, 2833, 8,  5, 1,  0, 0}, // #143
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 2841, 14, 86, 1, 22, 2}, // #144
  {DBGFIELD("WriteIDiv16")        66, false, false, 2855, 15, 106, 1,  0, 0}, // #145
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 2841, 14, 86, 1, 22, 2}, // #146
  {DBGFIELD("WriteIDiv32")        66, false, false, 2855, 15, 106, 1,  0, 0}, // #147
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 2841, 14, 86, 1, 22, 2}, // #148
  {DBGFIELD("WriteIDiv64")        66, false, false, 2855, 15, 106, 1,  0, 0}, // #149
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 2841, 14, 86, 1, 22, 2}, // #150
  {DBGFIELD("WriteIDiv8")         1, false, false, 892, 10, 34, 1,  0, 0}, // #151
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, 1082, 11,  8, 1, 22, 2}, // #152
  {DBGFIELD("WriteIMul16")        4, false, false, 1093, 9, 23, 1,  0, 0}, // #153
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 3, false, false, 1102, 9, 11, 1, 11, 1}, // #154
  {DBGFIELD("WriteIMul16ImmLd")   3, false, false, 1102, 9, 11, 1,  0, 0}, // #155
  {DBGFIELD("WriteIMul16Reg")     1, false, false, 734, 7, 22, 1,  0, 0}, // #156
  {DBGFIELD("WriteIMul16Imm")     2, false, false, 1111, 7, 23, 1,  0, 0}, // #157
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, 1118, 11,  8, 1, 22, 2}, // #158
  {DBGFIELD("WriteIMul32")        3, false, false, 1129, 9, 23, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #160
  {DBGFIELD("WriteIMul32ImmLd")   2, false, false, 766, 9, 11, 1,  0, 0}, // #161
  {DBGFIELD("WriteIMul32Reg")     1, false, false, 734, 7, 22, 1,  0, 0}, // #162
  {DBGFIELD("WriteIMul32Imm")     1, false, false, 734, 7, 22, 1,  0, 0}, // #163
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, 1138, 13,  8, 1, 22, 2}, // #164
  {DBGFIELD("WriteIMul64")        2, false, false, 1151, 11, 23, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 2, false, false, 766, 9, 11, 1, 11, 1}, // #166
  {DBGFIELD("WriteIMul64ImmLd")   2, false, false, 766, 9, 11, 1,  0, 0}, // #167
  {DBGFIELD("WriteIMul64Reg")     1, false, false, 734, 7, 22, 1,  0, 0}, // #168
  {DBGFIELD("WriteIMul64Imm")     1, false, false, 734, 7, 22, 1,  0, 0}, // #169
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 766, 9, 11, 1, 22, 2}, // #170
  {DBGFIELD("WriteIMul8")         1, false, false, 734, 7, 22, 1,  0, 0}, // #171
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 2, false, false, 775, 10,  4, 1, 24, 1}, // #172
  {DBGFIELD("WriteFShuffle")      1, false, false, 748, 8,  1, 1,  0, 0}, // #173
  {DBGFIELD("WriteVecLogicX")     1, false, false, 713, 3,  1, 1,  0, 0}, // #174
  {DBGFIELD("WriteShuffle")       1, false, false, 748, 8,  1, 1,  0, 0}, // #175
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, 730, 4,  1, 1,  0, 0}, // #176
  {DBGFIELD("WriteVecLoadX")      1, false, false, 745, 3,  5, 1,  0, 0}, // #177
  {DBGFIELD("WriteLDMXCSR")       3, false, false, 1162, 11,  4, 1,  0, 0}, // #178
  {DBGFIELD("WriteFLD0")          1, false, false, 2689, 5,  1, 1,  0, 0}, // #179
  {DBGFIELD("WriteFLD1")          2, false, false, 2818, 5,  1, 1,  0, 0}, // #180
  {DBGFIELD("WriteLEA")           1, false, false, 712, 4,  1, 1,  0, 0}, // #181
  {DBGFIELD("WriteFence")         1, false, false, 1177, 5,  1, 1,  0, 0}, // #182
  {DBGFIELD("WriteLZCNTLd")       2, false, false, 766, 9, 11, 1,  0, 0}, // #183
  {DBGFIELD("WriteLZCNT")         1, false, false, 734, 7, 22, 1,  0, 0}, // #184
  {DBGFIELD("WriteVecStoreX")     2, false, false, 741, 4,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteVecStore")      2, false, false, 741, 4,  1, 1,  0, 0}, // #186
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, 893, 9,  3, 1,  0, 0}, // #187
  {DBGFIELD("WriteVecLoad")       1, false, false, 745, 3,  6, 1,  0, 0}, // #188
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, 748, 8,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteVecMoveX")      1, false, false, 713, 3,  1, 1,  0, 0}, // #190
  {DBGFIELD("WriteVecStoreNT")    2, false, false, 741, 4,  1, 1,  0, 0}, // #191
  {DBGFIELD("WriteVecMove")       1, false, false, 2689, 5,  1, 1,  0, 0}, // #192
  {DBGFIELD("WriteVecALULd")      2, false, false, 2870, 7,  5, 1,  0, 0}, // #193
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 2, false, false, 775, 10,  5, 1, 11, 1}, // #194
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 2, false, false, 2870, 7,  5, 1, 11, 1}, // #195
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 2, false, false, 2870, 7,  5, 1, 11, 1}, // #196
  {DBGFIELD("WriteVecLogic")      1, false, false, 2689, 5,  1, 1,  0, 0}, // #197
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, 2877, 10, 11, 1, 11, 1}, // #198
  {DBGFIELD("WritePHAdd")         3, false, false, 2887, 8, 22, 1,  0, 0}, // #199
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 2, false, false, 775, 10,  5, 1, 11, 1}, // #200
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 2, false, false, 795, 8,  3, 1,  3, 1}, // #201
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 2, false, false, 903, 11,  8, 1, 11, 1}, // #202
  {DBGFIELD("WriteVecIMul")       1, false, false, 893, 9, 23, 1,  0, 0}, // #203
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, 893, 9,  3, 1,  0, 0}, // #204
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 2, false, false, 775, 10, 11, 1, 11, 1}, // #205
  {DBGFIELD("WritePSADBW")        1, false, false, 748, 8, 22, 1,  0, 0}, // #206
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 2, false, false, 775, 10,  5, 1, 11, 1}, // #207
  {DBGFIELD("WriteVarShuffle")    1, false, false, 748, 8,  1, 1,  0, 0}, // #208
  {DBGFIELD("WriteShuffleLd")     2, false, false, 775, 10,  5, 1,  0, 0}, // #209
  {DBGFIELD("WriteVecShiftImm")   1, false, false, 893, 9,  1, 1,  0, 0}, // #210
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 2, false, false, 903, 11,  5, 1, 11, 1}, // #211
  {DBGFIELD("WriteVecShift")      1, false, false, 893, 9,  1, 1,  0, 0}, // #212
  {DBGFIELD("WriteFMoveX")        1, false, false, 713, 3,  1, 1,  0, 0}, // #213
  {DBGFIELD("WriteFShuffleLd")    2, false, false, 775, 10,  4, 1,  0, 0}, // #214
  {DBGFIELD("WriteFStore")        2, false, false, 741, 4,  1, 1,  0, 0}, // #215
  {DBGFIELD("WriteFMOVMSK")       1, false, false, 893, 9,  3, 1,  0, 0}, // #216
  {DBGFIELD("WriteVecLoadNT")     1, false, false, 745, 3,  5, 1,  0, 0}, // #217
  {DBGFIELD("WriteStoreNT")       2, false, false, 741, 4,  1, 1,  0, 0}, // #218
  {DBGFIELD("WriteFStoreNTX")     2, false, false, 741, 4,  1, 1,  0, 0}, // #219
  {DBGFIELD("WriteFStoreNT")      2, false, false, 741, 4,  1, 1,  0, 0}, // #220
  {DBGFIELD("WriteFLoad")         1, false, false, 745, 3,  6, 1,  0, 0}, // #221
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 3, false, false, 785, 10, 19, 1, 24, 1}, // #222
  {DBGFIELD("WriteMPSAD")         2, false, false, 795, 8, 23, 1,  0, 0}, // #223
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 2, false, false, 1226, 6, 19, 1, 24, 1}, // #224
  {DBGFIELD("WriteFMul64X")       1, false, false, 1173, 4, 23, 1,  0, 0}, // #225
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 2, false, false, 1226, 6, 19, 1, 24, 1}, // #226
  {DBGFIELD("WriteFMulX")         1, false, false, 1173, 4, 23, 1,  0, 0}, // #227
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 2, false, false, 1226, 6,  8, 1, 11, 1}, // #228
  {DBGFIELD("WriteFMul64")        1, false, false, 1173, 4, 23, 1,  0, 0}, // #229
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 2, false, false, 1226, 6,  8, 1, 11, 1}, // #230
  {DBGFIELD("WriteFMul")          1, false, false, 1173, 4, 23, 1,  0, 0}, // #231
  {DBGFIELD("WriteIMul32Ld_WriteIMulH") 5, false, false, 1118, 11, 73, 2,  0, 0}, // #232
  {DBGFIELD("WriteIMul32_WriteIMulH") 4, false, false, 1129, 9, 75, 2,  0, 0}, // #233
  {DBGFIELD("WriteIMul64Ld_WriteIMulH") 4, false, false, 1138, 13, 73, 2,  0, 0}, // #234
  {DBGFIELD("WriteIMul64_WriteIMulH") 3, false, false, 1151, 11, 75, 2,  0, 0}, // #235
  {DBGFIELD("WriteFMulLd")        2, false, false, 1226, 6,  8, 1,  0, 0}, // #236
  {DBGFIELD("WriteVecALUXLd")     2, false, false, 1226, 6,  4, 1,  0, 0}, // #237
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 2, false, false, 775, 10,  4, 1, 24, 1}, // #238
  {DBGFIELD("WriteShuffleX")      1, false, false, 748, 8,  1, 1,  0, 0}, // #239
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 2, false, false, 770, 5,  4, 1, 24, 1}, // #240
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 3, false, false, 1351, 5, 11, 1, 24, 1}, // #241
  {DBGFIELD("WriteVarBlend")      2, false, false, 1055, 3,  3, 1,  0, 0}, // #242
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 2, false, false, 775, 10,  4, 1, 24, 1}, // #243
  {DBGFIELD("WriteBlend")         1, false, false, 748, 8,  1, 1,  0, 0}, // #244
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 2, false, false, 775, 10, 20, 1, 24, 1}, // #245
  {DBGFIELD("WriteCLMul")         1, false, false, 748, 8,  5, 1,  0, 0}, // #246
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 9, false, false, 1232, 14, 77, 1, 24, 1}, // #247
  {DBGFIELD("WritePCmpEStrI")     8, false, false, 1246, 12, 29, 1,  0, 0}, // #248
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 10, false, false, 1258, 14, 34, 1, 24, 1}, // #249
  {DBGFIELD("WritePCmpEStrM")     9, false, false, 1272, 12, 63, 1,  0, 0}, // #250
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 4, false, false, 1284, 11,  7, 1, 24, 1}, // #251
  {DBGFIELD("WritePCmpIStrI")     3, false, false, 1295, 9, 19, 1,  0, 0}, // #252
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 4, false, false, 1284, 11,  7, 1, 24, 1}, // #253
  {DBGFIELD("WritePCmpIStrM")     3, false, false, 1295, 9, 19, 1,  0, 0}, // #254
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 2, false, false, 1226, 6, 11, 1, 24, 1}, // #255
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 4, false, false, 2823, 10,  8, 1, 24, 1}, // #256
  {DBGFIELD("WritePHAddX")        3, false, false, 2833, 8, 22, 1,  0, 0}, // #257
  {DBGFIELD("WritePHMINPOSLd")    2, false, false, 903, 11, 19, 1,  0, 0}, // #258
  {DBGFIELD("WritePHMINPOS")      1, false, false, 893, 9, 23, 1,  0, 0}, // #259
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 2, false, false, 1226, 6,  8, 1, 24, 1}, // #260
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 2, false, false, 1226, 6, 19, 1, 24, 1}, // #261
  {DBGFIELD("WriteVecIMulX")      1, false, false, 1173, 4, 23, 1,  0, 0}, // #262
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, 893, 9,  3, 1,  0, 0}, // #263
  {DBGFIELD("WriteShuffleXLd")    2, false, false, 775, 10,  4, 1,  0, 0}, // #264
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 3, false, false, 2720, 6,  7, 1, 24, 1}, // #265
  {DBGFIELD("WritePMULLD")        2, false, false, 1054, 4, 19, 1,  0, 0}, // #266
  {DBGFIELD("WriteCopy")          2, false, false, 1324, 5,  5, 1,  0, 0}, // #267
  {DBGFIELD("WritePOPCNTLd")      2, false, false, 766, 9, 11, 1,  0, 0}, // #268
  {DBGFIELD("WritePOPCNT")        1, false, false, 734, 7, 22, 1,  0, 0}, // #269
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 2, false, false, 775, 10,  8, 1, 24, 1}, // #270
  {DBGFIELD("WritePSADBWX")       1, false, false, 748, 8, 22, 1,  0, 0}, // #271
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 2, false, false, 775, 10,  4, 1, 24, 1}, // #272
  {DBGFIELD("WriteVarShuffleX")   1, false, false, 748, 8,  1, 1,  0, 0}, // #273
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, 1173, 4,  1, 1,  0, 0}, // #274
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 2, false, false, 1226, 6,  4, 1, 24, 1}, // #275
  {DBGFIELD("WriteVecShiftX")     2, false, false, 2895, 9,  3, 1,  0, 0}, // #276
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 3, false, false, 1329, 14,  8, 1, 24, 1}, // #277
  {DBGFIELD("WriteVecTest")       2, false, false, 1037, 12, 22, 1,  0, 0}, // #278
  {DBGFIELD("WriteRotateLd_WriteRMW") 3, false, false, 849, 8, 78, 2,  0, 0}, // #279
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 5, false, false, 2904, 8, 80, 2,  0, 0}, // #280
  {DBGFIELD("WriteRotate")        1, false, false, 730, 4,  1, 1,  0, 0}, // #281
  {DBGFIELD("WriteRotateCL")      3, false, false, 2912, 4, 22, 1,  0, 0}, // #282
  {DBGFIELD("WriteFRcpXLd")       2, false, false, 903, 11, 19, 1,  0, 0}, // #283
  {DBGFIELD("WriteFRcpX")         1, false, false, 893, 9, 23, 1,  0, 0}, // #284
  {DBGFIELD("WriteFRcpLd")        2, false, false, 903, 11,  8, 1,  0, 0}, // #285
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 2, false, false, 903, 11,  8, 1, 11, 1}, // #286
  {DBGFIELD("WriteFRcp")          1, false, false, 893, 9, 23, 1,  0, 0}, // #287
  {DBGFIELD("WriteRMW")           1, false, false, 741, 4,  1, 1,  0, 0}, // #288
  {DBGFIELD("WriteShiftLd")       2, false, false, 724, 6,  5, 1,  0, 0}, // #289
  {DBGFIELD("WriteShift")         1, false, false, 730, 4,  1, 1,  0, 0}, // #290
  {DBGFIELD("WriteFRndLd")        3, false, false, 2720, 6, 21, 1,  0, 0}, // #291
  {DBGFIELD("WriteFRnd")          2, false, false, 1054, 4, 11, 1,  0, 0}, // #292
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 3, false, false, 2720, 6, 21, 1, 24, 1}, // #293
  {DBGFIELD("WriteFRsqrtXLd")     2, false, false, 903, 11, 19, 1,  0, 0}, // #294
  {DBGFIELD("WriteFRsqrtX")       1, false, false, 893, 9, 23, 1,  0, 0}, // #295
  {DBGFIELD("WriteFRsqrtLd")      2, false, false, 903, 11,  8, 1,  0, 0}, // #296
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 2, false, false, 903, 11,  8, 1, 11, 1}, // #297
  {DBGFIELD("WriteFRsqrt")        1, false, false, 893, 9, 23, 1,  0, 0}, // #298
  {DBGFIELD("WriteShiftLd_WriteRMW") 3, false, false, 849, 8, 78, 2,  0, 0}, // #299
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 5, false, false, 2904, 8, 80, 2,  0, 0}, // #300
  {DBGFIELD("WriteShiftCL")       3, false, false, 2912, 4, 22, 1,  0, 0}, // #301
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 724, 6,  5, 1, 21, 1}, // #302
  {DBGFIELD("WriteSETCCStore")    3, false, false, 1356, 7,  3, 1,  0, 0}, // #303
  {DBGFIELD("WriteSETCC")         1, false, false, 730, 4,  1, 1,  0, 0}, // #304
  {DBGFIELD("WriteSHDmrcl")       6, false, false, 2916, 11,  9, 1,  0, 0}, // #305
  {DBGFIELD("WriteSHDmri")        4, false, false, 1374, 9,  8, 1,  0, 0}, // #306
  {DBGFIELD("WriteSHDrrcl")       4, false, false, 2927, 9,  5, 1,  0, 0}, // #307
  {DBGFIELD("WriteFSqrt64XLd")    2, false, false, 2936, 12, 77, 1,  0, 0}, // #308
  {DBGFIELD("WriteFSqrt64X")      1, false, false, 2948, 10, 29, 1,  0, 0}, // #309
  {DBGFIELD("WriteFSqrtXLd")      2, false, false, 2765, 12, 29, 1,  0, 0}, // #310
  {DBGFIELD("WriteFSqrtX")        1, false, false, 946, 10, 20, 1,  0, 0}, // #311
  {DBGFIELD("WriteFSqrt64Ld")     2, false, false, 2936, 12, 33, 1,  0, 0}, // #312
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 2, false, false, 2936, 12, 33, 1, 11, 1}, // #313
  {DBGFIELD("WriteFSqrt64")       1, false, false, 2948, 10, 29, 1,  0, 0}, // #314
  {DBGFIELD("WriteFSqrtLd")       2, false, false, 2765, 12, 28, 1,  0, 0}, // #315
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 2, false, false, 2765, 12, 28, 1, 11, 1}, // #316
  {DBGFIELD("WriteFSqrt")         1, false, false, 946, 10, 20, 1,  0, 0}, // #317
  {DBGFIELD("WriteFSqrt80")       1, false, false, 1417, 10, 31, 1,  0, 0}, // #318
  {DBGFIELD("WriteSTMXCSR")       3, false, false, 1026, 11,  3, 1,  0, 0}, // #319
  {DBGFIELD("WriteTZCNTLd")       2, false, false, 766, 9, 11, 1,  0, 0}, // #320
  {DBGFIELD("WriteTZCNT")         1, false, false, 734, 7, 22, 1,  0, 0}, // #321
  {DBGFIELD("WriteFMAZLd")        2, false, false, 2870, 7,  9, 1,  0, 0}, // #322
  {DBGFIELD("WriteFMALd")         2, false, false, 1226, 6,  8, 1,  0, 0}, // #323
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 2, false, false, 1226, 6,  9, 1, 35, 1}, // #324
  {DBGFIELD("WriteFAdd64Y")       1, false, false, 1173, 4, 23, 1,  0, 0}, // #325
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 2, false, false, 2870, 7,  9, 1, 35, 1}, // #326
  {DBGFIELD("WriteFAdd64Z")       1, false, false, 2689, 5, 23, 1,  0, 0}, // #327
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 2, false, false, 1226, 6,  9, 1, 35, 1}, // #328
  {DBGFIELD("WriteFAddY")         1, false, false, 1173, 4, 23, 1,  0, 0}, // #329
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 2, false, false, 2870, 7,  9, 1, 35, 1}, // #330
  {DBGFIELD("WriteFAddZ")         1, false, false, 2689, 5, 23, 1,  0, 0}, // #331
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 2, false, false, 775, 10, 11, 1, 35, 1}, // #332
  {DBGFIELD("WriteShuffleY")      1, false, false, 748, 8,  1, 1,  0, 0}, // #333
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 2, false, false, 775, 10, 11, 1, 35, 1}, // #334
  {DBGFIELD("WriteShuffleZ")      1, false, false, 748, 8,  1, 1,  0, 0}, // #335
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 2, false, false, 770, 5, 11, 1, 35, 1}, // #336
  {DBGFIELD("WriteFLogicY")       1, false, false, 713, 3,  1, 1,  0, 0}, // #337
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 2, false, false, 2870, 7, 11, 1, 35, 1}, // #338
  {DBGFIELD("WriteFLogicZ")       1, false, false, 2689, 5,  1, 1,  0, 0}, // #339
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 3, false, false, 1351, 5,  8, 1, 35, 1}, // #340
  {DBGFIELD("WriteFVarBlendY")    2, false, false, 1055, 3,  3, 1,  0, 0}, // #341
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 3, false, false, 1351, 5,  8, 1, 35, 1}, // #342
  {DBGFIELD("WriteFVarBlendZ")    2, false, false, 1055, 3,  3, 1,  0, 0}, // #343
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 2, false, false, 770, 5, 11, 1, 35, 1}, // #344
  {DBGFIELD("WriteFBlendY")       1, false, false, 713, 3,  1, 1,  0, 0}, // #345
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 3, false, false, 1351, 5,  8, 1, 36, 2}, // #346
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, 1351, 5, 11, 1, 25, 2}, // #347
  {DBGFIELD("WriteShuffle256Ld")  2, false, false, 775, 10, 19, 1,  0, 0}, // #348
  {DBGFIELD("WriteShuffle256")    1, false, false, 748, 8, 22, 1,  0, 0}, // #349
  {DBGFIELD("WriteShuffleYLd")    2, false, false, 775, 10, 11, 1,  0, 0}, // #350
  {DBGFIELD("WriteFShuffle256")   1, false, false, 748, 8, 22, 1,  0, 0}, // #351
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, 775, 10, 19, 1,  0, 0}, // #352
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 2, false, false, 1226, 6,  9, 1, 35, 1}, // #353
  {DBGFIELD("WriteFCmp64Y")       1, false, false, 1173, 4, 23, 1,  0, 0}, // #354
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 2, false, false, 1226, 6,  9, 1, 35, 1}, // #355
  {DBGFIELD("WriteFCmpY")         1, false, false, 1173, 4, 23, 1,  0, 0}, // #356
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 2, false, false, 2870, 7,  9, 1, 35, 1}, // #357
  {DBGFIELD("WriteFCmpZ")         1, false, false, 2689, 5, 23, 1,  0, 0}, // #358
  {DBGFIELD("WriteVarShuffle256Ld") 2, false, false, 775, 10, 19, 1,  0, 0}, // #359
  {DBGFIELD("WriteVarShuffle256") 1, false, false, 748, 8, 22, 1,  0, 0}, // #360
  {DBGFIELD("WriteCvtI2PDYLd")    2, false, false, 1226, 6,  8, 1,  0, 0}, // #361
  {DBGFIELD("WriteCvtI2PDY")      1, false, false, 1173, 4, 23, 1,  0, 0}, // #362
  {DBGFIELD("WriteCvtI2PDZLd")    2, false, false, 2870, 7,  8, 1,  0, 0}, // #363
  {DBGFIELD("WriteCvtI2PDZ")      1, false, false, 2689, 5, 23, 1,  0, 0}, // #364
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, 1226, 6,  8, 1,  0, 0}, // #365
  {DBGFIELD("WriteCvtI2PSY")      1, false, false, 1173, 4, 23, 1,  0, 0}, // #366
  {DBGFIELD("WriteCvtI2PSZLd")    2, false, false, 2870, 7,  8, 1,  0, 0}, // #367
  {DBGFIELD("WriteCvtI2PSZ")      1, false, false, 2689, 5, 23, 1,  0, 0}, // #368
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 2, false, false, 766, 9, 11, 1, 24, 1}, // #369
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 3, false, false, 2958, 11, 11, 1, 35, 1}, // #370
  {DBGFIELD("WriteCvtPD2PSY")     2, false, false, 2895, 9, 22, 1,  0, 0}, // #371
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 3, false, false, 2969, 7, 11, 1, 35, 1}, // #372
  {DBGFIELD("WriteCvtPD2PSZ")     2, false, false, 2818, 5, 22, 1,  0, 0}, // #373
  {DBGFIELD("WriteCvtPD2PSYLd")   3, false, false, 2958, 11, 11, 1,  0, 0}, // #374
  {DBGFIELD("WriteCvtPD2PSZLd")   3, false, false, 2969, 7, 11, 1,  0, 0}, // #375
  {DBGFIELD("WriteCvtPD2IYLd")    2, false, false, 1226, 6, 11, 1,  0, 0}, // #376
  {DBGFIELD("WriteCvtPD2IY")      1, false, false, 1173, 4, 22, 1,  0, 0}, // #377
  {DBGFIELD("WriteCvtPD2IZLd")    2, false, false, 2870, 7, 11, 1,  0, 0}, // #378
  {DBGFIELD("WriteCvtPD2IZ")      1, false, false, 2689, 5, 22, 1,  0, 0}, // #379
  {DBGFIELD("WriteCvtPH2PSYLd")   2, false, false, 1226, 6, 19, 1,  0, 0}, // #380
  {DBGFIELD("WriteCvtPH2PSY")     2, false, false, 2895, 9,  4, 1,  0, 0}, // #381
  {DBGFIELD("WriteCvtPH2PSLd")    2, false, false, 1226, 6,  8, 1,  0, 0}, // #382
  {DBGFIELD("WriteCvtPH2PS")      2, false, false, 2895, 9,  6, 1,  0, 0}, // #383
  {DBGFIELD("WriteCvtPH2PSZLd")   2, false, false, 2870, 7, 19, 1,  0, 0}, // #384
  {DBGFIELD("WriteCvtPH2PSZ")     2, false, false, 1037, 12,  4, 1,  0, 0}, // #385
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, 1226, 6, 11, 1,  0, 0}, // #386
  {DBGFIELD("WriteCvtPS2IY")      1, false, false, 1173, 4, 22, 1,  0, 0}, // #387
  {DBGFIELD("WriteCvtPS2IZLd")    2, false, false, 2870, 7, 11, 1,  0, 0}, // #388
  {DBGFIELD("WriteCvtPS2IZ")      1, false, false, 2689, 5, 22, 1,  0, 0}, // #389
  {DBGFIELD("WriteCvtPS2PDYLd")   3, false, false, 2958, 11, 11, 1,  0, 0}, // #390
  {DBGFIELD("WriteCvtPS2PDY")     2, false, false, 2895, 9, 22, 1,  0, 0}, // #391
  {DBGFIELD("WriteCvtPS2PDZLd")   3, false, false, 2969, 7, 11, 1,  0, 0}, // #392
  {DBGFIELD("WriteCvtPS2PDZ")     2, false, false, 2818, 5, 22, 1,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2PHYSt")   4, false, false, 2976, 12, 11, 1,  0, 0}, // #394
  {DBGFIELD("WriteCvtPS2PHY")     2, false, false, 2895, 9,  4, 1,  0, 0}, // #395
  {DBGFIELD("WriteCvtPS2PHSt")    4, false, false, 2976, 12,  5, 1,  0, 0}, // #396
  {DBGFIELD("WriteCvtPS2PH")      2, false, false, 2895, 9,  6, 1,  0, 0}, // #397
  {DBGFIELD("WriteCvtPS2PHZSt")   4, false, false, 2988, 11, 11, 1,  0, 0}, // #398
  {DBGFIELD("WriteCvtPS2PHZ")     2, false, false, 2999, 8,  4, 1,  0, 0}, // #399
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 3, false, false, 2720, 6,  9, 1, 11, 1}, // #400
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 3, false, false, 2720, 6,  9, 1, 11, 1}, // #401
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 2, false, false, 775, 10, 19, 1, 35, 1}, // #402
  {DBGFIELD("WritePSADBWY")       1, false, false, 748, 8, 22, 1,  0, 0}, // #403
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 2, false, false, 775, 10, 19, 1, 35, 1}, // #404
  {DBGFIELD("WritePSADBWZ")       1, false, false, 748, 8, 22, 1,  0, 0}, // #405
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 2, false, false, 902, 12, 31, 1, 35, 1}, // #406
  {DBGFIELD("WriteFDiv64Y")       1, false, false, 936, 10, 21, 1,  0, 0}, // #407
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 4, false, false, 3007, 15, 37, 1, 35, 1}, // #408
  {DBGFIELD("WriteFDiv64Z")       3, false, false, 3022, 13, 33, 1,  0, 0}, // #409
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 2, false, false, 924, 12, 29, 1, 35, 1}, // #410
  {DBGFIELD("WriteFDivY")         1, false, false, 936, 10,  9, 1,  0, 0}, // #411
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 4, false, false, 3035, 15, 34, 1, 35, 1}, // #412
  {DBGFIELD("WriteFDivZ")         3, false, false, 3050, 13, 29, 1,  0, 0}, // #413
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 2, false, false, 1226, 6, 19, 1, 24, 1}, // #414
  {DBGFIELD("WriteFMAX")          1, false, false, 1173, 4, 23, 1,  0, 0}, // #415
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 2, false, false, 1226, 6,  9, 1, 35, 1}, // #416
  {DBGFIELD("WriteFMAY")          1, false, false, 1173, 4, 23, 1,  0, 0}, // #417
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 2, false, false, 2870, 7,  9, 1, 35, 1}, // #418
  {DBGFIELD("WriteFMAZ")          1, false, false, 2689, 5, 23, 1,  0, 0}, // #419
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 5, false, false, 2795, 10, 30, 1, 35, 1}, // #420
  {DBGFIELD("WriteDPPSY")         4, false, false, 2805, 8, 27, 1,  0, 0}, // #421
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, 775, 10, 19, 1, 35, 1}, // #422
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, 1226, 6,  9, 1, 38, 2}, // #423
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, 1226, 6, 19, 1, 27, 2}, // #424
  {DBGFIELD("WriteFMALd_ReadAfterVecLd") 2, false, false, 1226, 6,  8, 1, 11, 1}, // #425
  {DBGFIELD("WriteFMA")           1, false, false, 1173, 4, 23, 1,  0, 0}, // #426
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 2, false, false, 1226, 6,  8, 1, 19, 2}, // #427
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, 1226, 6,  9, 1, 36, 2}, // #428
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, 1226, 6, 19, 1, 25, 2}, // #429
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 2, false, false, 1226, 6,  8, 1, 17, 2}, // #430
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 3, false, false, 2720, 6, 10, 1, 35, 1}, // #431
  {DBGFIELD("WriteFRndY")         2, false, false, 1054, 4, 11, 1,  0, 0}, // #432
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 3, false, false, 2969, 7, 10, 1, 35, 1}, // #433
  {DBGFIELD("WriteFRndZ")         2, false, false, 2818, 5, 11, 1,  0, 0}, // #434
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 2, false, false, 1226, 6,  9, 1, 35, 1}, // #435
  {DBGFIELD("WriteVecIMulY")      1, false, false, 1173, 4, 23, 1,  0, 0}, // #436
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 2, false, false, 2870, 7,  9, 1, 35, 1}, // #437
  {DBGFIELD("WriteVecIMulZ")      1, false, false, 2689, 5, 23, 1,  0, 0}, // #438
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 2, false, false, 1226, 6, 11, 1, 35, 1}, // #439
  {DBGFIELD("WriteVecALUY")       1, false, false, 1173, 4,  1, 1,  0, 0}, // #440
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 2, false, false, 903, 11, 11, 1, 35, 1}, // #441
  {DBGFIELD("WriteVecALUZ")       1, false, false, 893, 9,  1, 1,  0, 0}, // #442
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 4, false, false, 2823, 10, 27, 1, 35, 1}, // #443
  {DBGFIELD("WriteFHAddY")        3, false, false, 2833, 8,  5, 1,  0, 0}, // #444
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 2, false, false, 775, 10, 19, 1, 35, 1}, // #445
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 2, false, false, 775, 10, 19, 1, 35, 1}, // #446
  {DBGFIELD("WriteVecLoadY")      1, false, false, 745, 3,  4, 1,  0, 0}, // #447
  {DBGFIELD("WriteFMaskedStore64Y") 2, false, false, 3063, 10,  3, 1,  0, 0}, // #448
  {DBGFIELD("WriteFMaskedLoadY")  2, false, false, 770, 5, 11, 1,  0, 0}, // #449
  {DBGFIELD("WriteFMaskedStore64") 2, false, false, 3063, 10,  3, 1,  0, 0}, // #450
  {DBGFIELD("WriteFMaskedLoad")   2, false, false, 770, 5,  4, 1,  0, 0}, // #451
  {DBGFIELD("WriteFMaskedStore32Y") 2, false, false, 3063, 10,  3, 1,  0, 0}, // #452
  {DBGFIELD("WriteFMaskedStore32") 2, false, false, 3063, 10,  3, 1,  0, 0}, // #453
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 2, false, false, 2870, 7,  9, 1, 35, 1}, // #454
  {DBGFIELD("WriteFCmp64Z")       1, false, false, 2689, 5, 23, 1,  0, 0}, // #455
  {DBGFIELD("WriteFMoveY")        1, false, false, 713, 3,  1, 1,  0, 0}, // #456
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, 775, 10, 11, 1,  0, 0}, // #457
  {DBGFIELD("WriteFShuffleY")     1, false, false, 748, 8,  1, 1,  0, 0}, // #458
  {DBGFIELD("WriteFShuffleZLd")   2, false, false, 775, 10, 11, 1,  0, 0}, // #459
  {DBGFIELD("WriteFShuffleZ")     1, false, false, 748, 8,  1, 1,  0, 0}, // #460
  {DBGFIELD("WriteVecStoreY")     2, false, false, 741, 4,  1, 1,  0, 0}, // #461
  {DBGFIELD("WriteVecMoveY")      1, false, false, 713, 3,  1, 1,  0, 0}, // #462
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, 745, 3,  4, 1,  0, 0}, // #463
  {DBGFIELD("WriteVecStoreNTY")   2, false, false, 741, 4,  1, 1,  0, 0}, // #464
  {DBGFIELD("WriteFStoreNTY")     2, false, false, 741, 4,  1, 1,  0, 0}, // #465
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 3, false, false, 785, 10,  9, 1, 35, 1}, // #466
  {DBGFIELD("WriteMPSADY")        2, false, false, 795, 8, 23, 1,  0, 0}, // #467
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 2, false, false, 1226, 6,  9, 1, 35, 1}, // #468
  {DBGFIELD("WriteFMul64Y")       1, false, false, 1173, 4, 23, 1,  0, 0}, // #469
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 2, false, false, 2870, 7,  9, 1, 35, 1}, // #470
  {DBGFIELD("WriteFMul64Z")       1, false, false, 2689, 5, 23, 1,  0, 0}, // #471
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 2, false, false, 1226, 6,  9, 1, 35, 1}, // #472
  {DBGFIELD("WriteFMulY")         1, false, false, 1173, 4, 23, 1,  0, 0}, // #473
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 2, false, false, 2870, 7,  9, 1, 35, 1}, // #474
  {DBGFIELD("WriteFMulZ")         1, false, false, 2689, 5, 23, 1,  0, 0}, // #475
  {DBGFIELD("WriteVecALUYLd")     2, false, false, 1226, 6, 11, 1,  0, 0}, // #476
  {DBGFIELD("WriteVecALUZLd")     2, false, false, 903, 11, 11, 1,  0, 0}, // #477
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 2, false, false, 770, 5, 11, 1, 35, 1}, // #478
  {DBGFIELD("WriteVecLogicY")     1, false, false, 713, 3,  1, 1,  0, 0}, // #479
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 2, false, false, 2870, 7, 11, 1, 35, 1}, // #480
  {DBGFIELD("WriteVecLogicZ")     1, false, false, 2689, 5,  1, 1,  0, 0}, // #481
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 2, false, false, 775, 10, 11, 1, 35, 1}, // #482
  {DBGFIELD("WriteBlendY")        1, false, false, 748, 8,  1, 1,  0, 0}, // #483
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 3, false, false, 1351, 5, 11, 1, 35, 1}, // #484
  {DBGFIELD("WriteVarBlendY")     2, false, false, 1055, 3,  3, 1,  0, 0}, // #485
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 2, false, false, 2870, 7, 11, 1, 35, 1}, // #486
  {DBGFIELD("WriteVarBlendZ")     1, false, false, 2689, 5,  3, 1,  0, 0}, // #487
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 3, false, false, 1351, 5, 11, 1, 36, 2}, // #488
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, 1351, 5, 11, 1, 25, 2}, // #489
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, 775, 10, 11, 1, 36, 2}, // #490
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, 775, 10, 11, 1, 38, 2}, // #491
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, 775, 10,  4, 1, 25, 2}, // #492
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, 775, 10,  4, 1, 27, 2}, // #493
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, 775, 10, 19, 1, 35, 1}, // #494
  {DBGFIELD("WriteFVarShuffle256") 1, false, false, 748, 8, 22, 1,  0, 0}, // #495
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, 775, 10, 11, 1, 36, 2}, // #496
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, 775, 10, 11, 1, 38, 2}, // #497
  {DBGFIELD("WriteFVarShuffleY")  1, false, false, 748, 8,  1, 1,  0, 0}, // #498
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, 775, 10,  4, 1, 25, 2}, // #499
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, 775, 10,  4, 1, 27, 2}, // #500
  {DBGFIELD("WriteFVarShuffle")   1, false, false, 748, 8,  1, 1,  0, 0}, // #501
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 2, false, false, 775, 10, 11, 1, 35, 1}, // #502
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 2, false, false, 775, 10,  4, 1, 24, 1}, // #503
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 2, false, false, 775, 10, 11, 1, 35, 1}, // #504
  {DBGFIELD("WriteFVarShuffleZ")  1, false, false, 748, 8,  1, 1,  0, 0}, // #505
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 4, false, false, 2823, 10, 19, 1, 35, 1}, // #506
  {DBGFIELD("WritePHAddY")        3, false, false, 2833, 8, 22, 1,  0, 0}, // #507
  {DBGFIELD("WriteVecInsert")     2, false, false, 795, 8,  3, 1,  0, 0}, // #508
  {DBGFIELD("WriteVecIMulXLd")    2, false, false, 1226, 6, 19, 1,  0, 0}, // #509
  {DBGFIELD("WriteVecIMulYLd")    2, false, false, 1226, 6,  9, 1,  0, 0}, // #510
  {DBGFIELD("WriteVecIMulZLd")    2, false, false, 2870, 7,  9, 1,  0, 0}, // #511
  {DBGFIELD("WriteVecMaskedStoreY") 2, false, false, 3063, 10,  3, 1,  0, 0}, // #512
  {DBGFIELD("WriteVecMaskedLoadY") 2, false, false, 770, 5, 11, 1,  0, 0}, // #513
  {DBGFIELD("WriteVecMaskedStore") 2, false, false, 3063, 10,  3, 1,  0, 0}, // #514
  {DBGFIELD("WriteVecMaskedLoad") 2, false, false, 770, 5,  4, 1,  0, 0}, // #515
  {DBGFIELD("WriteVecMOVMSKY")    1, false, false, 893, 9,  3, 1,  0, 0}, // #516
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 3, false, false, 2720, 6, 28, 1, 35, 1}, // #517
  {DBGFIELD("WritePMULLDY")       2, false, false, 1054, 4, 19, 1,  0, 0}, // #518
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 3, false, false, 2969, 7, 28, 1, 35, 1}, // #519
  {DBGFIELD("WritePMULLDZ")       2, false, false, 2818, 5, 19, 1,  0, 0}, // #520
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, 775, 10,  4, 1, 25, 2}, // #521
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, 775, 10,  4, 1, 27, 2}, // #522
  {DBGFIELD("WriteVecShiftImmXLd") 2, false, false, 1226, 6,  4, 1,  0, 0}, // #523
  {DBGFIELD("WriteVecShiftImmYLd") 2, false, false, 1226, 6, 11, 1,  0, 0}, // #524
  {DBGFIELD("WriteVecShiftImmY")  1, false, false, 1173, 4,  1, 1,  0, 0}, // #525
  {DBGFIELD("WriteVecShiftImmZLd") 2, false, false, 903, 11, 11, 1,  0, 0}, // #526
  {DBGFIELD("WriteVecShiftImmZ")  1, false, false, 893, 9,  1, 1,  0, 0}, // #527
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 2, false, false, 1226, 6,  4, 1, 24, 1}, // #528
  {DBGFIELD("WriteVarVecShift")   1, false, false, 1173, 4,  1, 1,  0, 0}, // #529
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 2, false, false, 1226, 6, 11, 1, 35, 1}, // #530
  {DBGFIELD("WriteVarVecShiftY")  1, false, false, 1173, 4,  1, 1,  0, 0}, // #531
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 2, false, false, 903, 11, 11, 1, 35, 1}, // #532
  {DBGFIELD("WriteVarVecShiftZ")  1, false, false, 893, 9,  1, 1,  0, 0}, // #533
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 2, false, false, 1226, 6,  4, 1, 24, 1}, // #534
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 2, false, false, 775, 10, 11, 1, 35, 1}, // #535
  {DBGFIELD("WriteVarShuffleY")   1, false, false, 748, 8,  1, 1,  0, 0}, // #536
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 2, false, false, 775, 10, 11, 1, 35, 1}, // #537
  {DBGFIELD("WriteVarShuffleZ")   1, false, false, 748, 8,  1, 1,  0, 0}, // #538
  {DBGFIELD("WriteShuffleZLd")    2, false, false, 775, 10, 11, 1,  0, 0}, // #539
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 2, false, false, 1226, 6, 11, 1, 35, 1}, // #540
  {DBGFIELD("WriteVecShiftY")     2, false, false, 2895, 9, 23, 1,  0, 0}, // #541
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 2, false, false, 903, 11, 11, 1, 35, 1}, // #542
  {DBGFIELD("WriteVecShiftZ")     2, false, false, 1037, 12, 23, 1,  0, 0}, // #543
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 3, false, false, 1329, 14, 19, 1, 35, 1}, // #544
  {DBGFIELD("WriteVecTestY")      2, false, false, 1037, 12, 22, 1,  0, 0}, // #545
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 2, false, false, 903, 11, 19, 1, 24, 1}, // #546
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 2, false, false, 903, 11,  9, 1, 35, 1}, // #547
  {DBGFIELD("WriteFRcpY")         1, false, false, 893, 9, 23, 1,  0, 0}, // #548
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 4, false, false, 1503, 14,  9, 1, 35, 1}, // #549
  {DBGFIELD("WriteFRcpZ")         3, false, false, 1517, 12, 23, 1,  0, 0}, // #550
  {DBGFIELD("WriteFRcpYLd")       2, false, false, 903, 11,  9, 1,  0, 0}, // #551
  {DBGFIELD("WriteFRndYLd")       3, false, false, 2720, 6, 10, 1,  0, 0}, // #552
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 2, false, false, 903, 11, 19, 1, 24, 1}, // #553
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 2, false, false, 903, 11,  9, 1, 35, 1}, // #554
  {DBGFIELD("WriteFRsqrtY")       1, false, false, 893, 9, 23, 1,  0, 0}, // #555
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 4, false, false, 1503, 14,  7, 1, 35, 1}, // #556
  {DBGFIELD("WriteFRsqrtZ")       3, false, false, 1517, 12,  8, 1,  0, 0}, // #557
  {DBGFIELD("WriteFRsqrtYLd")     2, false, false, 903, 11,  9, 1,  0, 0}, // #558
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 2, false, false, 775, 10, 11, 1, 35, 1}, // #559
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 2, false, false, 775, 10, 11, 1, 35, 1}, // #560
  {DBGFIELD("WriteFSqrt64YLd")    2, false, false, 3073, 12, 34, 1,  0, 0}, // #561
  {DBGFIELD("WriteFSqrt64Y")      1, false, false, 3085, 10, 29, 1,  0, 0}, // #562
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 2, false, false, 2936, 12, 77, 1, 24, 1}, // #563
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 2, false, false, 3073, 12, 34, 1, 35, 1}, // #564
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 4, false, false, 3095, 15, 107, 1, 35, 1}, // #565
  {DBGFIELD("WriteFSqrt64Z")      3, false, false, 3110, 13, 38, 1,  0, 0}, // #566
  {DBGFIELD("WriteFSqrtYLd")      2, false, false, 2936, 12, 63, 1,  0, 0}, // #567
  {DBGFIELD("WriteFSqrtY")        1, false, false, 2948, 10, 20, 1,  0, 0}, // #568
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 2, false, false, 2765, 12, 29, 1, 24, 1}, // #569
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 2, false, false, 2936, 12, 63, 1, 35, 1}, // #570
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 4, false, false, 3123, 15, 66, 1, 35, 1}, // #571
  {DBGFIELD("WriteFSqrtZ")        3, false, false, 3138, 13, 30, 1,  0, 0}, // #572
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 2, false, false, 903, 11,  8, 1, 35, 1}, // #573
  {DBGFIELD("WriteFTestY")        1, false, false, 893, 9,  3, 1,  0, 0}, // #574
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 2, false, false, 903, 11, 11, 1, 24, 1}, // #575
  {DBGFIELD("WriteFTest")         1, false, false, 893, 9,  3, 1,  0, 0}, // #576
  {DBGFIELD("WriteALULd_WriteRMW") 3, false, false, 756, 6, 78, 2,  0, 0}, // #577
  {DBGFIELD("WriteXCHG")          3, false, false, 994, 2,  3, 1,  0, 0}, // #578
  {DBGFIELD("COPY")               16383, false, false,  0, 0,  0, 0,  0, 0}, // #579
  {DBGFIELD("FXAM")               1, false, false, 714, 2,  2, 1,  0, 0}, // #580
  {DBGFIELD("LD_Frr")             1, false, false, 714, 2,  1, 1,  0, 0}, // #581
  {DBGFIELD("MOVSX64rr32")        1, false, false, 714, 2,  1, 1,  0, 0}, // #582
  {DBGFIELD("RCL16m1_RCL16mi_RCL32m1_RCL32mi_RCL64m1_RCL64mi_RCL8m1_RCL8mi_RCR16m1_RCR16mi_RCR32m1_RCR32mi_RCR64m1_RCR64mi_RCR8m1_RCR8mi_ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 5, false, false, 1573, 6, 11, 1,  0, 0}, // #583
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL_RCR16mCL_RCR32mCL_RCR64mCL_RCR8mCL_ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 11, false, false, 3151, 11, 29, 1,  0, 0}, // #584
  {DBGFIELD("SAR16m1_SAR16mi_SAR32m1_SAR32mi_SAR64m1_SAR64mi_SAR8m1_SAR8mi_SHL16m1_SHL16mi_SHL32m1_SHL32mi_SHL64m1_SHL64mi_SHL8m1_SHL8mi_SHR16m1_SHR16mi_SHR32m1_SHR32mi_SHR64m1_SHR64mi_SHR8m1_SHR8mi") 4, false, false, 849, 8,  5, 1,  0, 0}, // #585
  {DBGFIELD("SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 6, false, false, 2904, 8, 11, 1,  0, 0}, // #586
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, 714, 2,  1, 1,  0, 0}, // #587
  {DBGFIELD("FCOMPP")             1, false, false, 714, 2,  2, 1,  0, 0}, // #588
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, 893, 9,  3, 1,  0, 0}, // #589
  {DBGFIELD("MMX_CVTPI2PSirr")    2, false, false, 795, 8,  5, 1,  0, 0}, // #590
  {DBGFIELD("MMX_CVTPI2PSirm")    2, false, false, 903, 11,  8, 1,  0, 0}, // #591
  {DBGFIELD("MMX_CVTPS2PIirr_MMX_CVTTPS2PIirr") 2, false, false, 3162, 8,  6, 1,  0, 0}, // #592
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 2, false, false, 762, 4,  5, 1,  0, 0}, // #593
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, 741, 4,  1, 1,  0, 0}, // #594
  {DBGFIELD("XCH_F")              15, false, false, 3170, 15, 28, 1,  0, 0}, // #595
  {DBGFIELD("RETIL_RETIQ_RETIW_IRET_IRET16_IRET32_IRET64") 2, false, false, 724, 6,  5, 1,  0, 0}, // #596
  {DBGFIELD("MMX_CVTPS2PIirm_MMX_CVTTPS2PIirm") 2, false, false, 770, 5,  8, 1,  0, 0}, // #597
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 2, false, false, 775, 10, 19, 1,  0, 0}, // #598
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 2, false, false, 801, 2,  3, 1,  0, 0}, // #599
  {DBGFIELD("LFENCE")             2, false, false, 801, 2,  3, 1,  0, 0}, // #600
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, 748, 8,  1, 1,  0, 0}, // #601
  {DBGFIELD("PSLLDQri_PSRLDQri")  1, false, false, 748, 8,  1, 1,  0, 0}, // #602
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr_MMX_PUNPCKHBWirr_MMX_PUNPCKHDQirr_MMX_PUNPCKHWDirr") 1, false, false, 748, 8,  1, 1,  0, 0}, // #603
  {DBGFIELD("LEAVE_LEAVE64")      3, false, false, 1604, 4,  4, 1,  0, 0}, // #604
  {DBGFIELD("POP16r")             2, false, false, 762, 4,  5, 1,  0, 0}, // #605
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 4, false, false, 756, 6,  5, 1,  0, 0}, // #606
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false, 714, 2,  2, 1,  0, 0}, // #607
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, 714, 2,  2, 1,  0, 0}, // #608
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, 741, 4,  1, 1,  0, 0}, // #609
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, 714, 2,  1, 1,  0, 0}, // #610
  {DBGFIELD("MMX_PADDQirr_MMX_PSUBQirr") 1, false, false, 2689, 5,  1, 1,  0, 0}, // #611
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, 714, 2,  1, 1,  0, 0}, // #612
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 2, false, false, 741, 4,  1, 1,  0, 0}, // #613
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  2, false, false, 741, 4,  1, 1,  0, 0}, // #614
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, 713, 3,  1, 1,  0, 0}, // #615
  {DBGFIELD("CLD")                3, false, false, 1608, 7, 22, 1,  0, 0}, // #616
  {DBGFIELD("LDDQUrm")            1, false, false, 745, 3,  5, 1,  0, 0}, // #617
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, 714, 2,  2, 1,  0, 0}, // #618
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 4, false, false, 756, 6,  5, 1,  0, 0}, // #619
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 8, false, false, 3185, 11, 19, 1,  0, 0}, // #620
  {DBGFIELD("PHADDDrr_PHSUBDrr")  3, false, false, 2833, 8, 22, 1,  0, 0}, // #621
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, 745, 3,  6, 1,  0, 0}, // #622
  {DBGFIELD("MMX_PADDQirm_MMX_PSUBQirm") 2, false, false, 2870, 7,  5, 1, 11, 1}, // #623
  {DBGFIELD("MOVDQUrm")           1, false, false, 745, 3,  5, 1,  0, 0}, // #624
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, 745, 3,  5, 1,  0, 0}, // #625
  {DBGFIELD("PADDQrm_PSUBQrm")    2, false, false, 770, 5,  4, 1, 24, 1}, // #626
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, 714, 2,  1, 1,  0, 0}, // #627
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   2, false, false, 1621, 4,  3, 1,  0, 0}, // #628
  {DBGFIELD("LD_F80m")            1, false, false, 745, 3,  4, 1,  0, 0}, // #629
  {DBGFIELD("PHADDDrm_PHSUBDrm")  4, false, false, 2823, 10,  8, 1, 24, 1}, // #630
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 2, false, false, 1037, 12, 22, 1,  0, 0}, // #631
  {DBGFIELD("FLDCW16m")           3, false, false, 3196, 11,  4, 1,  0, 0}, // #632
  {DBGFIELD("ST_FP80m")           2, false, false, 741, 4,  1, 1,  0, 0}, // #633
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 3, false, false, 2887, 8, 22, 1,  0, 0}, // #634
  {DBGFIELD("CMPXCHG8rm")         6, false, false, 716, 8, 11, 1,  0, 0}, // #635
  {DBGFIELD("INTO")               1, false, false, 714, 2,  2, 1,  0, 0}, // #636
  {DBGFIELD("XLAT")               1, false, false, 745, 3,  6, 1,  0, 0}, // #637
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 4, false, false, 2927, 9,  5, 1,  0, 0}, // #638
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false, 734, 7, 22, 1,  0, 0}, // #639
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 6, false, false, 2916, 11,  9, 1,  0, 0}, // #640
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 4, false, false, 1374, 9,  8, 1,  0, 0}, // #641
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 3, false, false, 1026, 11, 23, 1,  0, 0}, // #642
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 4, false, false, 2877, 10, 11, 1, 11, 1}, // #643
  {DBGFIELD("AAD8i8")             1, false, false, 714, 2,  2, 1,  0, 0}, // #644
  {DBGFIELD("LOOPE")              11, false, false, 1636, 4,  9, 1,  0, 0}, // #645
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, 741, 4,  1, 1,  0, 0}, // #646
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 4, false, false, 2927, 9,  5, 1,  0, 0}, // #647
  {DBGFIELD("FNSTCW16m")          3, false, false, 1640, 10,  3, 1,  0, 0}, // #648
  {DBGFIELD("POPA16_POPA32")      1, false, false, 745, 3,  6, 1,  0, 0}, // #649
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, 741, 4,  1, 1,  0, 0}, // #650
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 6, false, false, 2916, 11,  9, 1,  0, 0}, // #651
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 4, false, false, 1374, 9,  8, 1,  0, 0}, // #652
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, 734, 7, 22, 1,  0, 0}, // #653
  {DBGFIELD("CMPXCHG8rr")         5, false, false, 857, 4,  6, 1,  0, 0}, // #654
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80_COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 893, 9,  3, 1,  0, 0}, // #655
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 3, false, false, 3207, 12,  4, 1,  0, 0}, // #656
  {DBGFIELD("CVTTSS2SI64rr")      3, false, false, 3207, 12,  4, 1,  0, 0}, // #657
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int") 2, false, false, 903, 11,  4, 1, 11, 1}, // #658
  {DBGFIELD("CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 4, false, false, 3219, 14, 20, 1,  0, 0}, // #659
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, 714, 2,  2, 1,  0, 0}, // #660
  {DBGFIELD("AAA_AAS")            1, false, false, 714, 2,  2, 1,  0, 0}, // #661
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 6, false, false, 716, 8, 11, 1,  0, 0}, // #662
  {DBGFIELD("LOOPNE")             11, false, false, 1636, 4,  9, 1,  0, 0}, // #663
  {DBGFIELD("PAUSE")              4, false, false, 3233, 7, 55, 1,  0, 0}, // #664
  {DBGFIELD("CMPXCHG8B")          14, false, false, 1669, 10,  7, 1,  0, 0}, // #665
  {DBGFIELD("DAA")                1, false, false, 714, 2,  2, 1,  0, 0}, // #666
  {DBGFIELD("LOOP")               7, false, false, 3240, 9,  4, 1,  0, 0}, // #667
  {DBGFIELD("DAS")                1, false, false, 714, 2,  2, 1,  0, 0}, // #668
  {DBGFIELD("AAM8i8")             1, false, false, 714, 2,  2, 1,  0, 0}, // #669
  {DBGFIELD("STD")                6, false, false, 1688, 7,  5, 1,  0, 0}, // #670
  {DBGFIELD("CMPXCHG16B")         19, false, false, 1695, 15, 33, 1,  0, 0}, // #671
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, 714, 2,  2, 1,  0, 0}, // #672
  {DBGFIELD("FNCLEX_FXTRACT")     4, false, false, 1024, 2, 23, 1,  0, 0}, // #673
  {DBGFIELD("POPF32_POPF64")      1, false, false, 745, 3,  6, 1,  0, 0}, // #674
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, 714, 2,  2, 1,  0, 0}, // #675
  {DBGFIELD("RDTSC_RDTSCP")       22, false, false, 1710, 8, 82, 1,  0, 0}, // #676
  {DBGFIELD("ENTER")              1, false, false, 714, 2,  2, 1,  0, 0}, // #677
  {DBGFIELD("POPF16")             1, false, false, 745, 3,  6, 1,  0, 0}, // #678
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false, 714, 2,  2, 1,  0, 0}, // #679
  {DBGFIELD("FRNDINT")            1, false, false, 714, 2,  2, 1,  0, 0}, // #680
  {DBGFIELD("MWAITrr_RDPMC")      10, false, false, 3249, 11, 30, 1,  0, 0}, // #681
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, 714, 2,  2, 1,  0, 0}, // #682
  {DBGFIELD("FPREM")              1, false, false, 714, 2,  2, 1,  0, 0}, // #683
  {DBGFIELD("INSB_INSL_INSW")     8, false, false, 1718, 15, 30, 1,  0, 0}, // #684
  {DBGFIELD("FNINIT")             15, false, false, 3260, 8, 83, 1,  0, 0}, // #685
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 23, false, false, 1742, 13, 72, 1,  0, 0}, // #686
  {DBGFIELD("FPREM1")             1, false, false, 714, 2,  2, 1,  0, 0}, // #687
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, 714, 2,  2, 1,  0, 0}, // #688
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 23, false, false, 1742, 13, 72, 1,  0, 0}, // #689
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, 714, 2,  2, 1,  0, 0}, // #690
  {DBGFIELD("FSCALE")             1, false, false, 714, 2,  2, 1,  0, 0}, // #691
  {DBGFIELD("RDMSR")              1, false, false, 714, 2,  2, 1,  0, 0}, // #692
  {DBGFIELD("RET_RETL_RETQ_RETW_LRETIL_LRETIQ_LRETIW_LRETL_LRETQ_LRETW") 2, false, false, 724, 6,  5, 1,  0, 0}, // #693
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 23, false, false, 1755, 13, 72, 1,  0, 0}, // #694
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 23, false, false, 1755, 13, 72, 1,  0, 0}, // #695
  {DBGFIELD("F2XM1")              1, false, false, 714, 2,  2, 1,  0, 0}, // #696
  {DBGFIELD("CPUID")              8, false, false, 1768, 11, 29, 1,  0, 0}, // #697
  {DBGFIELD("INT")                1, false, false, 714, 2,  2, 1,  0, 0}, // #698
  {DBGFIELD("INT3")               1, false, false, 714, 2,  2, 1,  0, 0}, // #699
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, 714, 2,  2, 1,  0, 0}, // #700
  {DBGFIELD("FXRSTOR_FXRSTOR64")  90, false, false, 1779, 15, 44, 1,  0, 0}, // #701
  {DBGFIELD("FYL2X")              1, false, false, 714, 2,  2, 1,  0, 0}, // #702
  {DBGFIELD("FYL2XP1")            1, false, false, 714, 2,  2, 1,  0, 0}, // #703
  {DBGFIELD("FPTAN")              1, false, false, 714, 2,  2, 1,  0, 0}, // #704
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false, 714, 2,  2, 1,  0, 0}, // #705
  {DBGFIELD("FPATAN")             1, false, false, 714, 2,  2, 1,  0, 0}, // #706
  {DBGFIELD("WRMSR")              1, false, false, 714, 2,  2, 1,  0, 0}, // #707
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, 748, 8,  1, 1,  0, 0}, // #708
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, 748, 8,  1, 1,  0, 0}, // #709
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 2, false, false, 2818, 5,  3, 1,  0, 0}, // #710
  {DBGFIELD("FNOP")               1, false, false, 2689, 5,  1, 1,  0, 0}, // #711
  {DBGFIELD("RETQ")               3, false, false, 1794, 9,  4, 1,  0, 0}, // #712
  {DBGFIELD("CDQ_CQO")            1, false, false, 730, 4,  1, 1,  0, 0}, // #713
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, 2689, 5,  1, 1,  0, 0}, // #714
  {DBGFIELD("MMX_PADDQirr")       1, false, false, 2689, 5,  1, 1,  0, 0}, // #715
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, 748, 8,  1, 1,  0, 0}, // #716
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 3, false, false, 1604, 4,  4, 1,  0, 0}, // #717
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 893, 9,  3, 1,  0, 0}, // #718
  {DBGFIELD("VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 1, false, false, 893, 9,  3, 1,  0, 0}, // #719
  {DBGFIELD("CWD")                2, false, false, 1621, 4,  3, 1,  0, 0}, // #720
  {DBGFIELD("FNSTSW16r")          2, false, false, 1803, 9, 22, 1,  0, 0}, // #721
  {DBGFIELD("MMX_MOVDQ2Qrr")      2, false, false, 2818, 5,  3, 1,  0, 0}, // #722
  {DBGFIELD("PUSHFS64")           1, false, false, 714, 2,  2, 1,  0, 0}, // #723
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 2, false, false, 1037, 12, 22, 1,  0, 0}, // #724
  {DBGFIELD("RCL16r1_RCL32r1_RCL64r1_RCL8r1_RCR16r1_RCR32r1_RCR64r1_RCR8r1") 3, false, false, 1816, 4, 22, 1,  0, 0}, // #725
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, 893, 9,  3, 1,  0, 0}, // #726
  {DBGFIELD("MOV64sr")            1, false, false, 714, 2,  1, 1,  0, 0}, // #727
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVSX32rm16_MOVSX32rm32_MOVSX32rm8_MOVSX32rm8_NOREX_MOVSX64rm16_MOVSX64rm32_MOVSX64rm8_MOVZX16rm16_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX_MOVZX64rm16_MOVZX64rm8") 1, false, false, 745, 3,  6, 1,  0, 0}, // #728
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCL8rCL_RCR16rCL_RCR32rCL_RCR64rCL_RCR8rCL") 10, false, false, 3268, 9, 21, 1,  0, 0}, // #729
  {DBGFIELD("RCL16ri_RCL32ri_RCL64ri_RCL8ri_RCR16ri_RCR32ri_RCR64ri_RCR8ri") 3, false, false, 1816, 4, 22, 1,  0, 0}, // #730
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 3, false, false, 1829, 5,  3, 1,  0, 0}, // #731
  {DBGFIELD("CLI")                1, false, false, 714, 2,  2, 1,  0, 0}, // #732
  {DBGFIELD("PUSHGS64")           1, false, false, 714, 2,  2, 1,  0, 0}, // #733
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 3, false, false, 1026, 11, 23, 1,  0, 0}, // #734
  {DBGFIELD("CALL64pcrel32")      4, false, false, 1834, 7, 22, 1,  0, 0}, // #735
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 4, false, false, 1841, 10, 22, 1,  0, 0}, // #736
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 3, false, false, 1026, 11,  3, 1,  0, 0}, // #737
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 3, false, false, 1829, 5,  3, 1,  0, 0}, // #738
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 3, false, false, 1026, 11,  3, 1,  0, 0}, // #739
  {DBGFIELD("PUSHF16_PUSHF64")    6, false, false, 1851, 5,  6, 1,  0, 0}, // #740
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 2, false, false, 1856, 7,  3, 1,  0, 0}, // #741
  {DBGFIELD("MMX_MOVD64from64rm") 2, false, false, 741, 4,  1, 1,  0, 0}, // #742
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, 745, 3,  5, 1,  0, 0}, // #743
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, 745, 3,  6, 1,  0, 0}, // #744
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 745, 3,  6, 1,  0, 0}, // #745
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false, 745, 3,  6, 1,  0, 0}, // #746
  {DBGFIELD("MOV16sm")            1, false, false, 714, 2,  1, 1,  0, 0}, // #747
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 2, false, false, 2870, 7,  5, 1,  0, 0}, // #748
  {DBGFIELD("MMX_PALIGNRrmi")     2, false, false, 775, 10,  5, 1, 11, 1}, // #749
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 2, false, false, 2870, 7,  5, 1, 11, 1}, // #750
  {DBGFIELD("LODSL_LODSQ")        1, false, false, 714, 2,  2, 1,  0, 0}, // #751
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false, 745, 3,  4, 1,  0, 0}, // #752
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 1, false, false, 745, 3,  4, 1,  0, 0}, // #753
  {DBGFIELD("VINSERTF128rm")      2, false, false, 770, 5,  4, 1, 24, 1}, // #754
  {DBGFIELD("MMX_PADDQirm")       2, false, false, 2870, 7,  5, 1, 11, 1}, // #755
  {DBGFIELD("VERRm_VERWm")        1, false, false, 714, 2,  2, 1,  0, 0}, // #756
  {DBGFIELD("FARJMP64")           2, false, false, 1863, 9,  5, 1,  0, 0}, // #757
  {DBGFIELD("FNSTSWm")            3, false, false, 1872, 11, 22, 1,  0, 0}, // #758
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 4, false, false, 1883, 11,  5, 1,  0, 0}, // #759
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 5, false, false, 1894, 11,  4, 1,  0, 0}, // #760
  {DBGFIELD("CALL64m_CALL64m_NT") 5, false, false, 1894, 11,  4, 1,  0, 0}, // #761
  {DBGFIELD("VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 2, false, false, 903, 11,  4, 1, 11, 1}, // #762
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, 714, 2,  2, 1,  0, 0}, // #763
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 5, false, false, 1905, 8,  4, 1,  0, 0}, // #764
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 5, false, false, 1913, 6,  4, 1,  0, 0}, // #765
  {DBGFIELD("FARCALL64")          5, false, false, 1894, 11,  4, 1,  0, 0}, // #766
  {DBGFIELD("CVTSD2SI64rm_Int_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int") 3, false, false, 2720, 6,  9, 1,  0, 0}, // #767
  {DBGFIELD("CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int") 3, false, false, 2720, 6,  9, 1,  0, 0}, // #768
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, 745, 3,  4, 1,  0, 0}, // #769
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 6, false, false, 2904, 8, 11, 1,  0, 0}, // #770
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 6, false, false, 716, 8, 11, 1,  0, 0}, // #771
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 2, false, false, 775, 10, 19, 1,  0, 0}, // #772
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 2, false, false, 775, 10,  8, 1,  0, 0}, // #773
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 3, false, false, 785, 10,  9, 1,  0, 0}, // #774
  {DBGFIELD("MUL_F32m_MUL_F64m")  2, false, false, 903, 11,  9, 1,  0, 0}, // #775
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 3, false, false, 785, 10, 27, 1,  0, 0}, // #776
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 3, false, false, 1329, 14, 21, 1,  0, 0}, // #777
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 2, false, false, 903, 11, 32, 1,  0, 0}, // #778
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 3, false, false, 1329, 14, 34, 1,  0, 0}, // #779
  {DBGFIELD("VZEROALL")           34, false, false, 3277, 12, 20, 1,  0, 0}, // #780
  {DBGFIELD("VZEROUPPER")         4, false, false,  0, 0,  0, 1,  0, 0}, // #781
  {DBGFIELD("CLC")                1, false, false,  0, 0,  1, 1,  0, 0}, // #782
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #783
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #784
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #785
  {DBGFIELD("PXORrr_VPXORrr")     16382, false, false,  0, 0,  0, 0,  0, 0}, // #786
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #787
  {DBGFIELD("PSUBQrr")            16382, false, false,  0, 0,  0, 0,  0, 0}, // #788
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #789
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #790
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #791
  {DBGFIELD("SETCCr")             16382, false, false,  0, 0,  0, 0,  0, 0}, // #792
  {DBGFIELD("SETCCm")             16382, false, false,  0, 0,  0, 0,  0, 0}, // #793
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 2, false, false, 775, 10,  5, 1,  0, 0}, // #794
  {DBGFIELD("RETIL_RETIQ_RETIW")  2, false, false, 724, 6,  5, 1,  0, 0}, // #795
  {DBGFIELD("LRETIL_LRETIQ_LRETIW") 2, false, false, 724, 6,  5, 1,  0, 0}, // #796
  {DBGFIELD("RDPMC")              1, false, false, 714, 2,  2, 1,  0, 0}, // #797
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false, 714, 2,  2, 1,  0, 0}, // #798
  {DBGFIELD("FBLDm")              1, false, false, 714, 2,  2, 1,  0, 0}, // #799
  {DBGFIELD("FFREE_FFREEP")       1, false, false, 714, 2,  2, 1,  0, 0}, // #800
  {DBGFIELD("FSAVEm")             1, false, false, 714, 2,  2, 1,  0, 0}, // #801
  {DBGFIELD("FRSTORm")            1, false, false, 714, 2,  2, 1,  0, 0}, // #802
  {DBGFIELD("FXTRACT")            1, false, false, 714, 2,  2, 1,  0, 0}, // #803
  {DBGFIELD("MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 745, 3,  5, 1,  0, 0}, // #804
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, 745, 3,  5, 1,  0, 0}, // #805
  {DBGFIELD("VBROADCASTF128")     1, false, false, 745, 3,  4, 1,  0, 0}, // #806
  {DBGFIELD("VBROADCASTI128")     1, false, false, 745, 3,  4, 1,  0, 0}, // #807
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, 745, 3,  4, 1,  0, 0}, // #808
  {DBGFIELD("FBSTPm")             2, false, false, 741, 4,  1, 1,  0, 0}, // #809
  {DBGFIELD("VMPTRSTm")           2, false, false, 741, 4,  1, 1,  0, 0}, // #810
  {DBGFIELD("ST_FP32m_ST_FP64m")  2, false, false, 741, 4,  1, 1,  0, 0}, // #811
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 1, false, false, 1173, 4,  1, 1,  0, 0}, // #812
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 1, false, false, 1173, 4,  1, 1,  0, 0}, // #813
  {DBGFIELD("MMX_MOVQ2DQrr")      2, false, false, 795, 8,  3, 1,  0, 0}, // #814
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false, 1950, 7,  1, 1,  0, 0}, // #815
  {DBGFIELD("FINCSTP")            1, false, false, 2689, 5,  1, 1,  0, 0}, // #816
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false, 712, 4,  1, 1,  0, 0}, // #817
  {DBGFIELD("VPBLENDDYrri")       1, false, false, 713, 3,  1, 1,  0, 0}, // #818
  {DBGFIELD("VPBLENDDrri")        1, false, false, 713, 3,  1, 1,  0, 0}, // #819
  {DBGFIELD("CMC_STC")            1, false, false, 714, 2,  1, 1,  0, 0}, // #820
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false, 714, 2,  1, 1,  0, 0}, // #821
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 2, false, false, 770, 5,  8, 1,  0, 0}, // #822
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 2, false, false, 1226, 6,  4, 1, 24, 1}, // #823
  {DBGFIELD("CVTSS2SDrm")         2, false, false, 770, 5, 19, 1,  0, 0}, // #824
  {DBGFIELD("CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 2, false, false, 770, 5, 19, 1,  0, 0}, // #825
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 2, false, false, 1226, 6, 11, 1, 35, 1}, // #826
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 2, false, false, 766, 9, 11, 1,  0, 0}, // #827
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 2, false, false, 775, 10,  5, 1,  0, 0}, // #828
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 2, false, false, 775, 10, 11, 1,  0, 0}, // #829
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 2, false, false, 1863, 9,  5, 1,  0, 0}, // #830
  {DBGFIELD("ANDN32rm_ANDN64rm")  2, false, false, 843, 6,  5, 1,  0, 0}, // #831
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 2, false, false, 843, 6,  5, 1,  0, 0}, // #832
  {DBGFIELD("VINSERTI128rm")      2, false, false, 770, 5,  4, 1, 24, 1}, // #833
  {DBGFIELD("VPBLENDDrmi")        2, false, false, 770, 5,  4, 1,  0, 0}, // #834
  {DBGFIELD("VPBLENDDYrmi")       2, false, false, 770, 5, 11, 1,  0, 0}, // #835
  {DBGFIELD("POP32r_POP64r")      2, false, false, 762, 4,  5, 1,  0, 0}, // #836
  {DBGFIELD("SFENCE")             2, false, false, 727, 3,  3, 1,  0, 0}, // #837
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 3, false, false, 1957, 7,  3, 1,  0, 0}, // #838
  {DBGFIELD("MOVBE16mr")          3, false, false, 1957, 7,  3, 1,  0, 0}, // #839
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 3, false, false, 1829, 5,  3, 1,  0, 0}, // #840
  {DBGFIELD("MFENCE")             3, false, false, 792, 3, 22, 1,  0, 0}, // #841
  {DBGFIELD("XGETBV")             2, false, false, 801, 2,  3, 1,  0, 0}, // #842
  {DBGFIELD("CVTPS2PDrr_VCVTPS2PDrr") 2, false, false, 3162, 8,  6, 1,  0, 0}, // #843
  {DBGFIELD("CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 2, false, false, 3162, 8,  6, 1,  0, 0}, // #844
  {DBGFIELD("MMX_PACKSSDWirm_MMX_PACKSSWBirm_MMX_PACKUSWBirm") 3, false, false, 785, 10,  4, 1,  0, 0}, // #845
  {DBGFIELD("LRETQ_RETL")         2, false, false, 724, 6,  5, 1,  0, 0}, // #846
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 2, false, false, 1964, 4,  3, 1,  0, 0}, // #847
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, 734, 7, 22, 1,  0, 0}, // #848
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, 1173, 4, 23, 1,  0, 0}, // #849
  {DBGFIELD("VCVTDQ2PSYrr")       1, false, false, 1173, 4, 23, 1,  0, 0}, // #850
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, 748, 8, 22, 1,  0, 0}, // #851
  {DBGFIELD("CVTPS2DQrm_VCVTPS2DQrm_CVTTPS2DQrm_VCVTTPS2DQrm") 2, false, false, 770, 5, 19, 1,  0, 0}, // #852
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, 770, 5,  9, 1,  0, 0}, // #853
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm") 2, false, false, 770, 5,  9, 1,  0, 0}, // #854
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 2, false, false, 775, 10,  8, 1,  0, 0}, // #855
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr") 3, false, false, 1968, 8, 22, 1,  0, 0}, // #856
  {DBGFIELD("CLDEMOTE")           3, false, false, 1608, 7, 22, 1,  0, 0}, // #857
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int") 2, false, false, 1054, 4,  5, 1,  0, 0}, // #858
  {DBGFIELD("CVTTSD2SI64rr_CVTTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, 1054, 4,  5, 1,  0, 0}, // #859
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int_CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, 1054, 4,  5, 1,  0, 0}, // #860
  {DBGFIELD("CVTTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr") 2, false, false, 1054, 4,  5, 1,  0, 0}, // #861
  {DBGFIELD("VCVTPS2PDYrr")       2, false, false, 3162, 8,  4, 1,  0, 0}, // #862
  {DBGFIELD("MMX_CVTPI2PDirr")    1, false, false, 1173, 4, 23, 1,  0, 0}, // #863
  {DBGFIELD("MMX_CVTPD2PIirr_MMX_CVTTPD2PIirr") 2, false, false, 3162, 8,  6, 1,  0, 0}, // #864
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 1, false, false, 1173, 4, 23, 1,  0, 0}, // #865
  {DBGFIELD("CVTPD2PSrr_VCVTPD2PSrr") 2, false, false, 3162, 8,  6, 1,  0, 0}, // #866
  {DBGFIELD("CVTSD2SSrr_CVTSD2SSrr_Int_VCVTSD2SSrr_VCVTSD2SSrr_Int") 2, false, false, 3162, 8,  6, 1,  0, 0}, // #867
  {DBGFIELD("CVTSI2SDrr_CVTSI642SDrr") 2, false, false, 3162, 8,  6, 1,  0, 0}, // #868
  {DBGFIELD("CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, 3162, 8,  6, 1,  0, 0}, // #869
  {DBGFIELD("CVTSI2SSrr")         2, false, false, 3162, 8,  6, 1,  0, 0}, // #870
  {DBGFIELD("CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int") 2, false, false, 3162, 8,  6, 1,  0, 0}, // #871
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, 3162, 8,  6, 1,  0, 0}, // #872
  {DBGFIELD("VCVTSD2SI64rm_Int_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 3, false, false, 2720, 6,  9, 1,  0, 0}, // #873
  {DBGFIELD("CVTSS2SI64rm_Int")   3, false, false, 2720, 6,  9, 1,  0, 0}, // #874
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, 2720, 6,  9, 1,  0, 0}, // #875
  {DBGFIELD("VCVTPS2PDYrm")       2, false, false, 770, 5,  9, 1,  0, 0}, // #876
  {DBGFIELD("CVTPD2PSrm")         3, false, false, 1976, 10,  9, 1,  0, 0}, // #877
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_MMX_CVTPD2PIirm_MMX_CVTTPD2PIirm") 3, false, false, 1976, 10,  9, 1,  0, 0}, // #878
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 3, false, false, 1329, 14,  9, 1,  0, 0}, // #879
  {DBGFIELD("MMX_CVTPI2PDirm")    2, false, false, 1226, 6,  8, 1,  0, 0}, // #880
  {DBGFIELD("CVTSD2SSrm")         3, false, false, 1976, 10, 19, 1,  0, 0}, // #881
  {DBGFIELD("CVTSD2SSrm_Int_VCVTSD2SSrm_VCVTSD2SSrm_Int") 3, false, false, 1976, 10, 19, 1,  0, 0}, // #882
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 2, false, false, 775, 10, 11, 1,  0, 0}, // #883
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 4, false, false, 3289, 11, 23, 1,  0, 0}, // #884
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 5, false, false, 1999, 13,  8, 1,  0, 0}, // #885
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, 893, 9, 23, 1,  0, 0}, // #886
  {DBGFIELD("VPCMPGTQYrm")        2, false, false, 775, 10, 19, 1,  0, 0}, // #887
  {DBGFIELD("CVTSI642SSrr")       3, false, false, 2833, 8,  5, 1,  0, 0}, // #888
  {DBGFIELD("CVTSI642SSrr_Int_VCVTSI642SSrr_VCVTSI642SSrr_Int") 3, false, false, 2833, 8,  5, 1,  0, 0}, // #889
  {DBGFIELD("STR16r_STR32r_STR64r") 3, false, false, 2012, 11,  6, 1,  0, 0}, // #890
  {DBGFIELD("XSETBV")             5, false, false, 2023, 4,  6, 1,  0, 0}, // #891
  {DBGFIELD("VCVTDQ2PDYrr")       2, false, false, 2895, 9,  4, 1,  0, 0}, // #892
  {DBGFIELD("VCVTPD2PSYrr")       2, false, false, 3162, 8,  4, 1,  0, 0}, // #893
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 2, false, false, 3162, 8,  4, 1,  0, 0}, // #894
  {DBGFIELD("VCVTDQ2PDYrm")       3, false, false, 1329, 14, 27, 1,  0, 0}, // #895
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 10, false, false, 3300, 11, 10, 1,  0, 0}, // #896
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 7, false, false, 3311, 9,  9, 1,  0, 0}, // #897
  {DBGFIELD("RCL8rCL")            9, false, false, 3320, 9,  9, 1,  0, 0}, // #898
  {DBGFIELD("RDTSC")              8, false, false, 1768, 11, 29, 1,  0, 0}, // #899
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 31, false, false, 3329, 13, 108, 1,  0, 0}, // #900
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, 893, 9, 30, 1,  0, 0}, // #901
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 2, false, false, 903, 11, 66, 1,  0, 0}, // #902
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 3, false, false, 1329, 14, 37, 1,  0, 0}, // #903
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, 893, 9, 10, 1,  0, 0}, // #904
  {DBGFIELD("XSAVE64")            39, false, false, 3342, 11, 88, 1,  0, 0}, // #905
  {DBGFIELD("XSAVE")              40, false, false, 3353, 11, 82, 1,  0, 0}, // #906
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 40, false, false, 3353, 11, 82, 1,  0, 0}, // #907
  {DBGFIELD("VMCLEARm")           18, false, false, 3364, 17, 109, 1,  0, 0}, // #908
  {DBGFIELD("FLDENVm")            64, false, false, 3381, 11, 18, 1,  0, 0}, // #909
  {DBGFIELD("FXRSTOR64")          88, false, false, 2098, 15, 44, 1,  0, 0}, // #910
  {DBGFIELD("FSTENVm")            100, false, false, 3392, 17, 110, 1,  0, 0}, // #911
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm_VPGATHERDDrm") 5, false, false, 3409, 14, 32, 1,  0, 0}, // #912
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 5, false, false, 3409, 14, 34, 1,  0, 0}, // #913
  {DBGFIELD("VPGATHERQDYrm")      5, false, false, 3409, 14, 34, 1,  0, 0}, // #914
  {DBGFIELD("VPGATHERQDrm")       5, false, false, 3409, 14, 32, 1,  0, 0}, // #915
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 5, false, false, 3409, 14, 34, 1,  0, 0}, // #916
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 5, false, false, 3409, 14, 34, 1,  0, 0}, // #917
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 5, false, false, 3409, 14, 32, 1,  0, 0}, // #918
  {DBGFIELD("VGATHERQPSYrm")      5, false, false, 3409, 14, 34, 1,  0, 0}, // #919
  {DBGFIELD("VGATHERQPSrm_VGATHERDPSrm") 5, false, false, 3409, 14, 32, 1,  0, 0}, // #920
  {DBGFIELD("VPXORYrr")           16382, false, false,  0, 0,  0, 0,  0, 0}, // #921
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #922
  {DBGFIELD("VPCMPGTQYrr")        16382, false, false,  0, 0,  0, 0,  0, 0}, // #923
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false, 730, 4,  1, 1,  0, 0}, // #924
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 2, false, false, 1621, 4,  3, 1,  0, 0}, // #925
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 2, false, false, 775, 10, 11, 1,  0, 0}, // #926
  {DBGFIELD("LRETQ")              3, false, false, 1794, 9,  4, 1,  0, 0}, // #927
  {DBGFIELD("CVTDQ2PSrm_VCVTDQ2PSrm") 2, false, false, 770, 5, 19, 1,  0, 0}, // #928
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 3, false, false, 1976, 10,  9, 1,  0, 0}, // #929
  {DBGFIELD("POPF64")             1, false, false, 745, 3,  6, 1,  0, 0}, // #930
  {DBGFIELD("VGATHERQPDrm")       5, false, false, 3409, 14, 32, 1,  0, 0}, // #931
  {DBGFIELD("VGATHERQPDYrm")      5, false, false, 3409, 14, 34, 1,  0, 0}, // #932
  {DBGFIELD("VGATHERDPDrm")       5, false, false, 3409, 14, 32, 1,  0, 0}, // #933
  {DBGFIELD("VGATHERDPSrm")       5, false, false, 3409, 14, 32, 1,  0, 0}, // #934
  {DBGFIELD("VGATHERDPDYrm")      5, false, false, 3409, 14, 34, 1,  0, 0}, // #935
  {DBGFIELD("VGATHERDPSYrm")      5, false, false, 3409, 14, 34, 1,  0, 0}, // #936
  {DBGFIELD("PCMPEQQrr")          1, false, false, 1173, 4,  1, 1,  0, 0}, // #937
  {DBGFIELD("PCMPEQQrm")          2, false, false, 1226, 6,  4, 1, 24, 1}, // #938
  {DBGFIELD("MOV16rm")            1, false, false, 745, 3,  6, 1,  0, 0}, // #939
  {DBGFIELD("MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX") 1, false, false, 745, 3,  6, 1,  0, 0}, // #940
  {DBGFIELD("POP16rmm")           4, false, false, 756, 6,  5, 1,  0, 0}, // #941
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 4, false, false, 756, 6,  5, 1,  0, 0}, // #942
  {DBGFIELD("PUSHF16")            6, false, false, 1851, 5,  6, 1,  0, 0}, // #943
  {DBGFIELD("LAHF")               1, false, false, 730, 4,  1, 1,  0, 0}, // #944
  {DBGFIELD("ADD16mi_ADD16mi8_ADD16mr_ADD32mi_ADD32mi8_ADD32mr_ADD64mi32_ADD64mi8_ADD64mr_ADD8mi_ADD8mi8_ADD8mr_SUB16mi_SUB16mi8_SUB16mr_SUB32mi_SUB32mi8_SUB32mr_SUB64mi32_SUB64mi8_SUB64mr_SUB8mi_SUB8mi8_SUB8mr") 3, false, false, 756, 6,  4, 1,  0, 0}, // #945
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 6, false, false, 716, 8, 11, 1,  0, 0}, // #946
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 3, false, false, 756, 6,  4, 1,  0, 0}, // #947
  {DBGFIELD("MULX32rr")           4, false, false, 1129, 9, 75, 2,  0, 0}, // #948
  {DBGFIELD("MULX32rm")           5, false, false, 1118, 11, 73, 2,  0, 0}, // #949
  {DBGFIELD("MULX64rr")           3, false, false, 1151, 11, 75, 2,  0, 0}, // #950
  {DBGFIELD("MULX64rm")           4, false, false, 1138, 13, 73, 2,  0, 0}, // #951
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 4, false, false, 1841, 10, 22, 1,  0, 0}, // #952
  {DBGFIELD("RETW_LRETL_LRETW")   2, false, false, 724, 6,  5, 1,  0, 0}, // #953
  {DBGFIELD("IRET16_IRET32_IRET64") 2, false, false, 724, 6,  5, 1,  0, 0}, // #954
  {DBGFIELD("AND16mi_AND16mi8_AND16mr_AND32mi_AND32mi8_AND32mr_AND64mi32_AND64mi8_AND64mr_AND8mi_AND8mi8_AND8mr_OR16mi_OR16mi8_OR16mr_OR32mi_OR32mi8_OR32mi8Locked_OR32mr_OR64mi32_OR64mi8_OR64mr_OR8mi_OR8mi8_OR8mr_XOR16mi_XOR16mi8_XOR16mr_XOR32mi_XOR32mi8_XOR32mr_XOR64mi32_XOR64mi8_XOR64mr_XOR8mi_XOR8mi8_XOR8mr") 3, false, false, 756, 6,  4, 1,  0, 0}, // #955
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 4, false, false, 1374, 9,  8, 1,  0, 0}, // #956
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 4, false, false, 2927, 9,  5, 1,  0, 0}, // #957
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 6, false, false, 2916, 11,  9, 1,  0, 0}, // #958
  {DBGFIELD("MOVSLDUPrm")         1, false, false, 745, 3,  5, 1,  0, 0}, // #959
  {DBGFIELD("MOVSLDUPrr")         1, false, false, 748, 8,  1, 1,  0, 0}, // #960
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 3, false, false, 994, 2,  3, 1,  0, 0}, // #961
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, 893, 9,  1, 1,  0, 0}, // #962
  {DBGFIELD("VPMOVSXBDYrr_VPMOVSXBQYrr_VPMOVSXBWYrr_VPMOVSXDQYrr_VPMOVSXWDYrr_VPMOVSXWQYrr_VPMOVZXBDYrr_VPMOVZXBQYrr_VPMOVZXBWYrr_VPMOVZXDQYrr_VPMOVZXWDYrr_VPMOVZXWQYrr") 1, false, false, 748, 8, 22, 1,  0, 0}, // #963
  {DBGFIELD("VPMOVZXBDYrm_VPMOVZXBQYrm_VPMOVZXBWYrm_VPMOVZXDQYrm_VPMOVZXWQYrm") 2, false, false, 775, 10, 19, 1,  0, 0}, // #964
  {DBGFIELD("PBLENDWrri_VPBLENDWrri") 1, false, false, 748, 8,  1, 1,  0, 0}, // #965
  {DBGFIELD("VPBLENDWYrri")       1, false, false, 748, 8,  1, 1,  0, 0}, // #966
  {DBGFIELD("PBLENDWrmi_VPBLENDWrmi") 2, false, false, 775, 10,  4, 1, 24, 1}, // #967
  {DBGFIELD("VPBLENDWYrmi")       2, false, false, 775, 10, 11, 1, 35, 1}, // #968
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, 748, 8,  1, 1,  0, 0}, // #969
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 2, false, false, 741, 4,  1, 1,  0, 0}, // #970
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 2, false, false, 741, 4,  1, 1,  0, 0}, // #971
  {DBGFIELD("VPMASKMOVDYrm")      2, false, false, 770, 5, 11, 1,  0, 0}, // #972
  {DBGFIELD("VPMASKMOVDrm")       2, false, false, 770, 5,  4, 1,  0, 0}, // #973
  {DBGFIELD("VPMASKMOVDYmr_VPMASKMOVQYmr") 2, false, false, 3063, 10,  3, 1,  0, 0}, // #974
  {DBGFIELD("VPMASKMOVDmr_VPMASKMOVQmr") 2, false, false, 3063, 10,  3, 1,  0, 0}, // #975
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 2, false, false, 775, 10,  4, 1,  0, 0}, // #976
  {DBGFIELD("VPSLLDQri_VPSRLDQri") 1, false, false, 748, 8,  1, 1,  0, 0}, // #977
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri") 1, false, false, 748, 8,  1, 1,  0, 0}, // #978
  {DBGFIELD("VPERM2F128rr")       1, false, false, 748, 8, 22, 1,  0, 0}, // #979
  {DBGFIELD("VPERM2F128rm")       2, false, false, 775, 10, 19, 1, 35, 1}, // #980
  {DBGFIELD("VEXTRACTF128rr")     1, false, false, 748, 8, 22, 1,  0, 0}, // #981
  {DBGFIELD("VEXTRACTF128mr")     2, false, false, 741, 4,  1, 1,  0, 0}, // #982
  {DBGFIELD("VINSERTF128rr")      1, false, false, 748, 8, 22, 1,  0, 0}, // #983
  {DBGFIELD("VCVTPD2DQrm_VCVTTPD2DQrm") 2, false, false, 1226, 6, 11, 1,  0, 0}, // #984
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 2, false, false, 1226, 6, 11, 1,  0, 0}, // #985
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, 1054, 4,  5, 1,  0, 0}, // #986
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, 2720, 6,  9, 1,  0, 0}, // #987
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, 1173, 4,  1, 1,  0, 0}, // #988
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, 1173, 4,  1, 1,  0, 0}, // #989
  {DBGFIELD("SHA256MSG2rm")       2, false, false, 1226, 6, 19, 1, 24, 1}, // #990
  {DBGFIELD("SHA256MSG2rr")       1, false, false, 1173, 4, 23, 1,  0, 0}, // #991
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, 1173, 4, 23, 1,  0, 0}, // #992
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 2, false, false, 1226, 6, 19, 1, 24, 1}, // #993
  {DBGFIELD("SHA1MSG2rr")         1, false, false, 1173, 4, 23, 1,  0, 0}, // #994
  {DBGFIELD("SHA1MSG2rm")         2, false, false, 1226, 6, 19, 1, 24, 1}, // #995
  {DBGFIELD("SHA1NEXTErr")        1, false, false, 1173, 4, 23, 1,  0, 0}, // #996
  {DBGFIELD("SHA1NEXTErm")        2, false, false, 1226, 6, 19, 1, 24, 1}, // #997
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, 1173, 4, 23, 1,  0, 0}, // #998
  {DBGFIELD("SHA1RNDS4rmi")       2, false, false, 1226, 6, 19, 1, 24, 1}, // #999
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, 1173, 4, 23, 1,  0, 0}, // #1000
  {DBGFIELD("SHA256RNDS2rm")      2, false, false, 1226, 6, 19, 1, 24, 1}, // #1001
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 3, false, false, 994, 2,  3, 1,  0, 0}, // #1002
  {DBGFIELD("BT16mi8_BT32mi8_BT64mi8") 2, false, false, 724, 6,  5, 1,  0, 0}, // #1003
  {DBGFIELD("BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 1, false, false, 730, 4,  1, 1,  0, 0}, // #1004
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 1, false, false, 714, 2,  2, 1,  0, 0}, // #1005
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 3, false, false, 756, 6,  4, 1,  0, 0}, // #1006
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 1, false, false, 714, 2,  1, 1,  0, 0}, // #1007
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 2, false, false, 762, 4,  5, 1,  0, 0}, // #1008
  {DBGFIELD("ADC64ri32_SBB64ri32") 1, false, false, 730, 4,  1, 1,  0, 0}, // #1009
  {DBGFIELD("CRC32r32r16")        1, false, false, 734, 7, 22, 1,  0, 0}, // #1010
  {DBGFIELD("CRC32r32r32")        1, false, false, 734, 7, 22, 1,  0, 0}, // #1011
  {DBGFIELD("CRC32r64r64")        1, false, false, 734, 7, 22, 1,  0, 0}, // #1012
  {DBGFIELD("SAHF")               1, false, false, 730, 4,  1, 1,  0, 0}, // #1013
  {DBGFIELD("BEXTRI32ri_BEXTRI64ri") 2, false, false, 837, 6,  3, 1,  0, 0}, // #1014
  {DBGFIELD("BEXTRI32mi_BEXTRI64mi") 3, false, false, 829, 8,  4, 1,  0, 0}, // #1015
  {DBGFIELD("RCR8ri")             3, false, false, 1816, 4, 22, 1,  0, 0}, // #1016
  {DBGFIELD("RCL16rCL")           7, false, false, 3311, 9,  9, 1,  0, 0}, // #1017
  {DBGFIELD("RCR16ri")            3, false, false, 1816, 4, 22, 1,  0, 0}, // #1018
  {DBGFIELD("RCL32rCL_RCL64rCL")  7, false, false, 3311, 9,  9, 1,  0, 0}, // #1019
  {DBGFIELD("RCR32rCL_RCR64rCL")  7, false, false, 3311, 9,  9, 1,  0, 0}, // #1020
  {DBGFIELD("RCR32ri_RCR64ri")    3, false, false, 1816, 4, 22, 1,  0, 0}, // #1021
  {DBGFIELD("RCL16ri")            3, false, false, 1816, 4, 22, 1,  0, 0}, // #1022
  {DBGFIELD("RCL32ri_RCL64ri")    3, false, false, 1816, 4, 22, 1,  0, 0}, // #1023
  {DBGFIELD("SHLD32rri8")         1, false, false, 734, 7, 22, 1,  0, 0}, // #1024
  {DBGFIELD("SHRD16rri8")         1, false, false, 734, 7, 22, 1,  0, 0}, // #1025
  {DBGFIELD("SHLD16rrCL")         4, false, false, 2927, 9,  5, 1,  0, 0}, // #1026
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 2, false, false, 741, 4,  1, 1,  0, 0}, // #1027
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 2, false, false, 741, 4,  1, 1,  0, 0}, // #1028
  {DBGFIELD("TST_F")              1, false, false, 893, 9,  3, 1,  0, 0}, // #1029
  {DBGFIELD("VDPPSrri")           4, false, false, 2805, 8, 27, 1,  0, 0}, // #1030
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr") 2, false, false, 1054, 4, 11, 1,  0, 0}, // #1031
  {DBGFIELD("VFRCZSDrr_VFRCZSSrr") 2, false, false, 1054, 4, 11, 1,  0, 0}, // #1032
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 3, false, false, 2720, 6, 21, 1, 24, 1}, // #1033
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 2, false, false, 1054, 4, 11, 1,  0, 0}, // #1034
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 3, false, false, 2720, 6, 10, 1, 35, 1}, // #1035
  {DBGFIELD("MMX_CVTTPD2PIirr")   2, false, false, 3162, 8,  6, 1,  0, 0}, // #1036
  {DBGFIELD("VMOVDQUYmr")         2, false, false, 741, 4,  1, 1,  0, 0}, // #1037
  {DBGFIELD("MOVDQArr")           1, false, false, 713, 3,  1, 1,  0, 0}, // #1038
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 2, false, false, 1054, 4, 19, 1,  0, 0}, // #1039
  {DBGFIELD("VMPSADBWrri")        2, false, false, 795, 8, 23, 1,  0, 0}, // #1040
  {DBGFIELD("VPPERMrrr_VPPERMrrr_REV") 1, false, false, 748, 8,  1, 1,  0, 0}, // #1041
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 3, false, false, 2833, 8, 22, 1,  0, 0}, // #1042
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 4, false, false, 2823, 10,  8, 1, 24, 1}, // #1043
  {DBGFIELD("VPCLMULQDQrr")       1, false, false, 748, 8,  5, 1,  0, 0}, // #1044
  {DBGFIELD("INSERTQ")            1, false, false, 1173, 4,  1, 1,  0, 0}, // #1045
  {DBGFIELD("ANDNPSrr_VANDNPSrr_ANDNPDrr_VANDNPDrr") 1, false, false, 713, 3,  1, 1,  0, 0}, // #1046
  {DBGFIELD("MMX_PXORirr_MMX_PANDNirr") 1, false, false, 2689, 5,  1, 1,  0, 0}, // #1047
  {DBGFIELD("PANDNrr_VPANDNrr")   1, false, false, 713, 3,  1, 1,  0, 0}, // #1048
  {DBGFIELD("MMX_PSUBBirr_MMX_PSUBDirr_MMX_PSUBWirr_MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 1, false, false, 2689, 5,  1, 1,  0, 0}, // #1049
  {DBGFIELD("LCMPXCHG8_LCMPXCHG16_LCMPXCHG32_LCMPXCHG64") 6, false, false, 716, 8, 11, 1,  0, 0}, // #1050
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 5, false, false, 857, 4,  6, 1,  0, 0}, // #1051
  {DBGFIELD("LCMPXCHG8B_LCMPXCHG16B") 6, false, false, 716, 8, 11, 1,  0, 0}, // #1052
  {DBGFIELD("XCHG8rr")            3, false, false, 994, 2,  3, 1,  0, 0}, // #1053
  {DBGFIELD("VANDNPSYrr_VANDNPDYrr") 1, false, false, 713, 3,  1, 1,  0, 0}, // #1054
  {DBGFIELD("MMX_PSUBSBirr_MMX_PSUBSWirr_MMX_PSUBUSBirr_MMX_PSUBUSWirr") 1, false, false, 893, 9,  1, 1,  0, 0}, // #1055
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false, 1173, 4,  1, 1,  0, 0}, // #1056
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false, 712, 4,  1, 1,  0, 0}, // #1057
  {DBGFIELD("LEA16r")             1, false, false, 712, 4,  1, 1,  0, 0}, // #1058
  {DBGFIELD("MMX_PADDSBirr_MMX_PADDSWirr_MMX_PADDUSBirr_MMX_PADDUSWirr_MMX_PAVGBirr_MMX_PAVGWirr_MMX_PCMPEQBirr_MMX_PCMPEQDirr_MMX_PCMPEQWirr_MMX_PMAXSWirr_MMX_PMINSWirr_MMX_PMAXUBirr_MMX_PMINUBirr") 1, false, false, 893, 9,  1, 1,  0, 0}, // #1059
  {DBGFIELD("MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 1, false, false, 893, 9,  1, 1,  0, 0}, // #1060
  {DBGFIELD("CLAC_STAC")          1, false, false, 730, 4,  1, 1,  0, 0}, // #1061
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, 713, 3,  1, 1,  0, 0}, // #1062
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr") 1, false, false, 713, 3,  1, 1,  0, 0}, // #1063
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, 748, 8, 22, 1,  0, 0}, // #1064
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 3, false, false, 1214, 12, 22, 1,  0, 0}, // #1065
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, 3423, 9, 22, 1,  0, 0}, // #1066
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 3, false, false, 3423, 9, 22, 1,  0, 0}, // #1067
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, 1173, 4, 23, 1,  0, 0}, // #1068
  {DBGFIELD("VCVTPS2DQYrr_VCVTTPS2DQYrr") 1, false, false, 1173, 4, 22, 1,  0, 0}, // #1069
  {DBGFIELD("MMX_PADDSBirm_MMX_PADDSWirm_MMX_PADDUSBirm_MMX_PADDUSWirm_MMX_PAVGBirm_MMX_PAVGWirm_MMX_PCMPEQBirm_MMX_PCMPEQDirm_MMX_PCMPEQWirm_MMX_PCMPGTBirm_MMX_PCMPGTDirm_MMX_PCMPGTWirm_MMX_PMAXSWirm_MMX_PMAXUBirm_MMX_PMINSWirm_MMX_PMINUBirm_MMX_PSUBSBirm_MMX_PSUBSWirm_MMX_PSUBUSBirm_MMX_PSUBUSWirm") 2, false, false, 903, 11,  5, 1,  0, 0}, // #1070
  {DBGFIELD("CVTSS2SI64rr_Int")   3, false, false, 3207, 12,  4, 1,  0, 0}, // #1071
  {DBGFIELD("CVTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int") 2, false, false, 1054, 4,  5, 1,  0, 0}, // #1072
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 2, false, false, 770, 5,  4, 1, 24, 1}, // #1073
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 2, false, false, 770, 5, 11, 1, 35, 1}, // #1074
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 4, false, false, 1200, 14, 11, 1,  0, 0}, // #1075
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, 3432, 11,  8, 1,  0, 0}, // #1076
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 4, false, false, 3432, 11, 19, 1,  0, 0}, // #1077
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 40, false, false, 3353, 11, 82, 1,  0, 0}, // #1078
  {DBGFIELD("PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1079
  {DBGFIELD("VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1080
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, 893, 9,  1, 1,  0, 0}, // #1081
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, 893, 9,  1, 1,  0, 0}, // #1082
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, 748, 8,  1, 1,  0, 0}, // #1083
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 1, false, false, 713, 3,  1, 1,  0, 0}, // #1084
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 1, false, false, 713, 3,  1, 1,  0, 0}, // #1085
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, 713, 3,  1, 1,  0, 0}, // #1086
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 1, false, false, 713, 3,  1, 1,  0, 0}, // #1087
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 1, false, false, 713, 3,  1, 1,  0, 0}, // #1088
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 1, false, false, 713, 3,  1, 1,  0, 0}, // #1089
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 1, false, false, 713, 3,  1, 1,  0, 0}, // #1090
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 2, false, false, 741, 4,  1, 1,  0, 0}, // #1091
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 5, false, false, 3443, 7,  3, 1,  0, 0}, // #1092
  {DBGFIELD("KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, 893, 9, 22, 1,  0, 0}, // #1093
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, 893, 9, 22, 1,  0, 0}, // #1094
  {DBGFIELD("VPSADBWZrr")         1, false, false, 748, 8, 22, 1,  0, 0}, // #1095
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_VPTESTMBZ128rr_VPTESTMBZ128rrk_VPTESTMDZ128rr_VPTESTMDZ128rrk_VPTESTMQZ128rr_VPTESTMQZ128rrk_VPTESTMWZ128rr_VPTESTMWZ128rrk_VPTESTNMBZ128rr_VPTESTNMBZ128rrk_VPTESTNMDZ128rr_VPTESTNMDZ128rrk_VPTESTNMQZ128rr_VPTESTNMQZ128rrk_VPTESTNMWZ128rr_VPTESTNMWZ128rrk") 1, false, false, 748, 8, 22, 1,  0, 0}, // #1096
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri_KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, 748, 8, 22, 1,  0, 0}, // #1097
  {DBGFIELD("VALIGNDZ128rri_VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rri_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, 748, 8, 22, 1,  0, 0}, // #1098
  {DBGFIELD("VALIGNDZ256rri_VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rri_VALIGNQZ256rrik_VALIGNQZ256rrikz") 1, false, false, 748, 8, 22, 1,  0, 0}, // #1099
  {DBGFIELD("VALIGNDZrri_VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrri_VALIGNQZrrik_VALIGNQZrrikz") 1, false, false, 748, 8, 22, 1,  0, 0}, // #1100
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, 748, 8, 22, 1,  0, 0}, // #1101
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 1, false, false, 748, 8, 22, 1,  0, 0}, // #1102
  {DBGFIELD("VCMPPDZrri_VCMPPDZrrib_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrrib_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 1, false, false, 748, 8, 22, 1,  0, 0}, // #1103
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, 748, 8, 22, 1,  0, 0}, // #1104
  {DBGFIELD("VDBPSADBWZrri_VDBPSADBWZrrik_VDBPSADBWZrrikz") 1, false, false, 748, 8, 22, 1,  0, 0}, // #1105
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rrik_VPCMPDZ128rri_VPCMPDZ128rrik_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rrik_VPCMPUBZ128rri_VPCMPUBZ128rrik_VPCMPUDZ128rri_VPCMPUDZ128rrik_VPCMPUQZ128rri_VPCMPUQZ128rrik_VPCMPUWZ128rri_VPCMPUWZ128rrik_VPCMPWZ128rri_VPCMPWZ128rrik_VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, 748, 8, 22, 1,  0, 0}, // #1106
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rrik_VPCMPDZ256rri_VPCMPDZ256rrik_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rrik_VPCMPUBZ256rri_VPCMPUBZ256rrik_VPCMPUDZ256rri_VPCMPUDZ256rrik_VPCMPUQZ256rri_VPCMPUQZ256rrik_VPCMPUWZ256rri_VPCMPUWZ256rrik_VPCMPWZ256rri_VPCMPWZ256rrik_VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 1, false, false, 748, 8, 22, 1,  0, 0}, // #1107
  {DBGFIELD("VPCMPBZrri_VPCMPBZrrik_VPCMPDZrri_VPCMPDZrrik_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrrik_VPCMPUBZrri_VPCMPUBZrrik_VPCMPUDZrri_VPCMPUDZrrik_VPCMPUQZrri_VPCMPUQZrrik_VPCMPUWZrri_VPCMPUWZrrik_VPCMPWZrri_VPCMPWZrrik_VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 1, false, false, 748, 8, 22, 1,  0, 0}, // #1108
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 1, false, false, 748, 8, 22, 1,  0, 0}, // #1109
  {DBGFIELD("VPTESTMBZrr_VPTESTMBZrrk_VPTESTMDZrr_VPTESTMDZrrk_VPTESTMQZrr_VPTESTMQZrrk_VPTESTMWZrr_VPTESTMWZrrk_VPTESTNMBZrr_VPTESTNMBZrrk_VPTESTNMDZrr_VPTESTNMDZrrk_VPTESTNMQZrr_VPTESTNMQZrrk_VPTESTNMWZrr_VPTESTNMWZrrk") 1, false, false, 748, 8, 22, 1,  0, 0}, // #1110
  {DBGFIELD("VCVTDQ2PSZ128rr_VCVTDQ2PSZ128rrk_VCVTDQ2PSZ128rrkz_VCVTUDQ2PSZ128rr_VCVTUDQ2PSZ128rrk_VCVTUDQ2PSZ128rrkz") 1, false, false, 1173, 4, 23, 1,  0, 0}, // #1111
  {DBGFIELD("VCVTDQ2PSZ256rr_VCVTDQ2PSZ256rrk_VCVTDQ2PSZ256rrkz_VCVTUDQ2PSZ256rr_VCVTUDQ2PSZ256rrk_VCVTUDQ2PSZ256rrkz") 1, false, false, 1173, 4, 23, 1,  0, 0}, // #1112
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 1, false, false, 1173, 4, 23, 1,  0, 0}, // #1113
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 1, false, false, 1173, 4, 23, 1,  0, 0}, // #1114
  {DBGFIELD("VCVTPS2DQYrr")       1, false, false, 1173, 4, 23, 1,  0, 0}, // #1115
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, 1173, 4, 23, 1,  0, 0}, // #1116
  {DBGFIELD("VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 1, false, false, 1173, 4, 23, 1,  0, 0}, // #1117
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 1, false, false, 1173, 4, 23, 1,  0, 0}, // #1118
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 1, false, false, 1173, 4, 23, 1,  0, 0}, // #1119
  {DBGFIELD("VCVTDQ2PSZrr_VCVTUDQ2PSZrr") 1, false, false, 2689, 5, 23, 1,  0, 0}, // #1120
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 1, false, false, 2689, 5, 23, 1,  0, 0}, // #1121
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 1, false, false, 2689, 5, 23, 1,  0, 0}, // #1122
  {DBGFIELD("VCVTQQ2PDZrr_VCVTUQQ2PDZrr") 1, false, false, 2689, 5, 23, 1,  0, 0}, // #1123
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 2, false, false, 795, 8, 23, 1,  0, 0}, // #1124
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 2, false, false, 795, 8, 23, 1,  0, 0}, // #1125
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 3, false, false, 1026, 11, 23, 1,  0, 0}, // #1126
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 2, false, false, 3162, 8,  6, 1,  0, 0}, // #1127
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 2, false, false, 3162, 8,  6, 1,  0, 0}, // #1128
  {DBGFIELD("VCVTPD2PSZ128rr_VCVTPD2PSZ128rrk_VCVTPD2PSZ128rrkz") 2, false, false, 3162, 8,  6, 1,  0, 0}, // #1129
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz") 2, false, false, 3162, 8,  6, 1,  0, 0}, // #1130
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 2, false, false, 3162, 8,  6, 1,  0, 0}, // #1131
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 2, false, false, 3162, 8,  6, 1,  0, 0}, // #1132
  {DBGFIELD("VCVTSD2SSZrr_VCVTSD2SSZrr_Int_VCVTSD2SSZrr_Intk_VCVTSD2SSZrr_Intkz_VCVTSD2SSZrrb_Int_VCVTSD2SSZrrb_Intk_VCVTSD2SSZrrb_Intkz") 2, false, false, 3162, 8,  6, 1,  0, 0}, // #1133
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 2, false, false, 3162, 8,  6, 1,  0, 0}, // #1134
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 2, false, false, 3162, 8,  6, 1,  0, 0}, // #1135
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz") 2, false, false, 3162, 8,  6, 1,  0, 0}, // #1136
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 3, false, false, 2833, 8,  6, 1,  0, 0}, // #1137
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 3, false, false, 3450, 6,  6, 1,  0, 0}, // #1138
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 3, false, false, 3450, 6,  6, 1,  0, 0}, // #1139
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 3, false, false, 3450, 6,  6, 1,  0, 0}, // #1140
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 4, false, false, 3456, 11,  6, 1,  0, 0}, // #1141
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 2, false, false, 795, 8,  5, 1,  0, 0}, // #1142
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 2, false, false, 770, 5,  5, 1,  0, 0}, // #1143
  {DBGFIELD("VMOVDI2PDIZrm")      2, false, false, 770, 5,  5, 1,  0, 0}, // #1144
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 3, false, false, 2833, 8,  5, 1,  0, 0}, // #1145
  {DBGFIELD("VMOVSDZrm_VMOVSDZrm_alt_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrm_alt_VMOVSSZrmk_VMOVSSZrmkz") 2, false, false, 775, 10,  4, 1,  0, 0}, // #1146
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 2, false, false, 3162, 8,  4, 1,  0, 0}, // #1147
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 2, false, false, 3162, 8,  4, 1,  0, 0}, // #1148
  {DBGFIELD("VCVTPD2PSZ256rr_VCVTPD2PSZ256rrk_VCVTPD2PSZ256rrkz") 2, false, false, 3162, 8,  4, 1,  0, 0}, // #1149
  {DBGFIELD("VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 2, false, false, 3162, 8,  4, 1,  0, 0}, // #1150
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 2, false, false, 3162, 8,  4, 1,  0, 0}, // #1151
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 2, false, false, 3162, 8,  4, 1,  0, 0}, // #1152
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 2, false, false, 2999, 8,  4, 1,  0, 0}, // #1153
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 2, false, false, 2999, 8,  4, 1,  0, 0}, // #1154
  {DBGFIELD("VCVTPD2PSZrr")       2, false, false, 2999, 8,  4, 1,  0, 0}, // #1155
  {DBGFIELD("VCVTPS2PDZrr")       2, false, false, 2999, 8,  4, 1,  0, 0}, // #1156
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 2, false, false, 2999, 8,  4, 1,  0, 0}, // #1157
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 2, false, false, 2999, 8,  4, 1,  0, 0}, // #1158
  {DBGFIELD("VMOVNTDQAZ128rm")    2, false, false, 770, 5,  4, 1,  0, 0}, // #1159
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 2, false, false, 770, 5,  4, 1, 24, 1}, // #1160
  {DBGFIELD("VBROADCASTI32X2Z128m_VBROADCASTI32X2Z128mk_VBROADCASTI32X2Z128mkz_VPBROADCASTDZ128m_VPBROADCASTDZ128mk_VPBROADCASTDZ128mkz_VPBROADCASTQZ128m_VPBROADCASTQZ128mk_VPBROADCASTQZ128mkz") 2, false, false, 770, 5,  4, 1, 24, 1}, // #1161
  {DBGFIELD("VBROADCASTSSZ128m_VBROADCASTSSZ128mk_VBROADCASTSSZ128mkz") 2, false, false, 770, 5,  4, 1, 24, 1}, // #1162
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 2, false, false, 770, 5,  4, 1, 24, 1}, // #1163
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 2, false, false, 770, 5,  4, 1, 24, 1}, // #1164
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 2, false, false, 770, 5,  4, 1, 24, 1}, // #1165
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 2, false, false, 770, 5,  4, 1, 24, 1}, // #1166
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 2, false, false, 770, 5,  4, 1, 24, 1}, // #1167
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 3, false, false, 2833, 8,  4, 1,  0, 0}, // #1168
  {DBGFIELD("VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 3, false, false, 3207, 12,  4, 1,  0, 0}, // #1169
  {DBGFIELD("VCVTSS2SI64rr_Int")  3, false, false, 3207, 12,  4, 1,  0, 0}, // #1170
  {DBGFIELD("VCVTTSS2SI64rr")     3, false, false, 3207, 12,  4, 1,  0, 0}, // #1171
  {DBGFIELD("VCVTTSS2SI64rr_Int") 3, false, false, 3207, 12,  4, 1,  0, 0}, // #1172
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 3, false, false, 3467, 10,  4, 1,  0, 0}, // #1173
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 4, false, false, 3456, 11,  4, 1,  0, 0}, // #1174
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 7, false, false, 3477, 11,  4, 1,  0, 0}, // #1175
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 11, false, false, 3488, 11,  4, 1,  0, 0}, // #1176
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 19, false, false, 3499, 11,  4, 1,  0, 0}, // #1177
  {DBGFIELD("VSCATTERDPSZmr")     36, false, false, 3510, 14,  4, 1,  0, 0}, // #1178
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk") 2, false, false, 775, 10, 11, 1,  0, 0}, // #1179
  {DBGFIELD("VPBROADCASTBZ256m_VPBROADCASTBZ256mk_VPBROADCASTBZ256mkz_VPBROADCASTBZm_VPBROADCASTBZmk_VPBROADCASTBZmkz_VPBROADCASTWZ256m_VPBROADCASTWZ256mk_VPBROADCASTWZ256mkz_VPBROADCASTWZm_VPBROADCASTWZmk_VPBROADCASTWZmkz") 2, false, false, 775, 10, 11, 1,  0, 0}, // #1180
  {DBGFIELD("VMOVNTDQAZ256rm")    2, false, false, 770, 5, 11, 1,  0, 0}, // #1181
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 2, false, false, 770, 5, 11, 1, 35, 1}, // #1182
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 2, false, false, 770, 5, 11, 1, 35, 1}, // #1183
  {DBGFIELD("VBROADCASTF32X2Z256m_VBROADCASTF32X2Z256mk_VBROADCASTF32X2Z256mkz_VBROADCASTF32X2Zm_VBROADCASTF32X2Zmk_VBROADCASTF32X2Zmkz_VBROADCASTI32X2Z256m_VBROADCASTI32X2Z256mk_VBROADCASTI32X2Z256mkz_VBROADCASTI32X2Zm_VBROADCASTI32X2Zmk_VBROADCASTI32X2Zmkz_VPBROADCASTDZ256m_VPBROADCASTDZ256mk_VPBROADCASTDZ256mkz_VPBROADCASTDZm_VPBROADCASTDZmk_VPBROADCASTDZmkz_VPBROADCASTQZ256m_VPBROADCASTQZ256mk_VPBROADCASTQZ256mkz_VPBROADCASTQZm_VPBROADCASTQZmk_VPBROADCASTQZmkz") 2, false, false, 770, 5, 11, 1, 35, 1}, // #1184
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 2, false, false, 770, 5, 11, 1, 35, 1}, // #1185
  {DBGFIELD("VBROADCASTSDZ256m_VBROADCASTSDZ256mk_VBROADCASTSDZ256mkz_VBROADCASTSDZm_VBROADCASTSDZmk_VBROADCASTSDZmkz_VBROADCASTSSZ256m_VBROADCASTSSZ256mk_VBROADCASTSSZ256mkz_VBROADCASTSSZm_VBROADCASTSSZmk_VBROADCASTSSZmkz") 2, false, false, 770, 5, 11, 1, 35, 1}, // #1186
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 2, false, false, 770, 5, 11, 1, 35, 1}, // #1187
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 2, false, false, 770, 5, 11, 1, 35, 1}, // #1188
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 2, false, false, 770, 5, 11, 1, 35, 1}, // #1189
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, 770, 5, 11, 1, 35, 1}, // #1190
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 2, false, false, 770, 5, 11, 1, 35, 1}, // #1191
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 2, false, false, 770, 5, 11, 1, 35, 1}, // #1192
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 2, false, false, 770, 5, 11, 1, 35, 1}, // #1193
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 2, false, false, 770, 5, 11, 1, 35, 1}, // #1194
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 2, false, false, 770, 5, 11, 1, 35, 1}, // #1195
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 2, false, false, 770, 5, 11, 1, 35, 1}, // #1196
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 8, false, false, 3524, 14, 11, 1,  0, 0}, // #1197
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 12, false, false, 3538, 14, 11, 1,  0, 0}, // #1198
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 20, false, false, 3552, 14, 11, 1,  0, 0}, // #1199
  {DBGFIELD("VPSCATTERDDZmr")     36, false, false, 3510, 14, 11, 1,  0, 0}, // #1200
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 2, false, false, 775, 10,  8, 1,  0, 0}, // #1201
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmik") 2, false, false, 775, 10,  8, 1,  0, 0}, // #1202
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 2, false, false, 775, 10,  8, 1,  0, 0}, // #1203
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmik_VPCMPDZ128rmi_VPCMPDZ128rmib_VPCMPDZ128rmibk_VPCMPDZ128rmik_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmib_VPCMPQZ128rmibk_VPCMPQZ128rmik_VPCMPUBZ128rmi_VPCMPUBZ128rmik_VPCMPUDZ128rmi_VPCMPUDZ128rmib_VPCMPUDZ128rmibk_VPCMPUDZ128rmik_VPCMPUQZ128rmi_VPCMPUQZ128rmib_VPCMPUQZ128rmibk_VPCMPUQZ128rmik_VPCMPUWZ128rmi_VPCMPUWZ128rmik_VPCMPWZ128rmi_VPCMPWZ128rmik_VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 2, false, false, 775, 10,  8, 1,  0, 0}, // #1204
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 2, false, false, 775, 10,  8, 1,  0, 0}, // #1205
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 2, false, false, 775, 10,  8, 1,  0, 0}, // #1206
  {DBGFIELD("VPMOVSXBDZ128rm_VPMOVSXBDZ128rmk_VPMOVSXBDZ128rmkz_VPMOVSXBQZ128rm_VPMOVSXBQZ128rmk_VPMOVSXBQZ128rmkz_VPMOVSXBWZ128rm_VPMOVSXBWZ128rmk_VPMOVSXBWZ128rmkz_VPMOVSXDQZ128rm_VPMOVSXDQZ128rmk_VPMOVSXDQZ128rmkz_VPMOVSXWDZ128rm_VPMOVSXWDZ128rmk_VPMOVSXWDZ128rmkz_VPMOVSXWQZ128rm_VPMOVSXWQZ128rmk_VPMOVSXWQZ128rmkz_VPMOVZXBDZ128rm_VPMOVZXBDZ128rmk_VPMOVZXBDZ128rmkz_VPMOVZXBQZ128rm_VPMOVZXBQZ128rmk_VPMOVZXBQZ128rmkz_VPMOVZXBWZ128rm_VPMOVZXBWZ128rmk_VPMOVZXBWZ128rmkz_VPMOVZXDQZ128rm_VPMOVZXDQZ128rmk_VPMOVZXDQZ128rmkz_VPMOVZXWDZ128rm_VPMOVZXWDZ128rmk_VPMOVZXWDZ128rmkz_VPMOVZXWQZ128rm_VPMOVZXWQZ128rmk_VPMOVZXWQZ128rmkz") 2, false, false, 775, 10,  8, 1,  0, 0}, // #1207
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 2, false, false, 775, 10,  8, 1,  0, 0}, // #1208
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 2, false, false, 775, 10, 19, 1,  0, 0}, // #1209
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 2, false, false, 775, 10, 19, 1,  0, 0}, // #1210
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmik") 2, false, false, 775, 10, 19, 1,  0, 0}, // #1211
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmik") 2, false, false, 775, 10, 19, 1,  0, 0}, // #1212
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmik_VPCMPDZ256rmi_VPCMPDZ256rmib_VPCMPDZ256rmibk_VPCMPDZ256rmik_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmib_VPCMPQZ256rmibk_VPCMPQZ256rmik_VPCMPUBZ256rmi_VPCMPUBZ256rmik_VPCMPUDZ256rmi_VPCMPUDZ256rmib_VPCMPUDZ256rmibk_VPCMPUDZ256rmik_VPCMPUQZ256rmi_VPCMPUQZ256rmib_VPCMPUQZ256rmibk_VPCMPUQZ256rmik_VPCMPUWZ256rmi_VPCMPUWZ256rmik_VPCMPWZ256rmi_VPCMPWZ256rmik_VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 2, false, false, 775, 10, 19, 1,  0, 0}, // #1213
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmik_VPCMPDZrmi_VPCMPDZrmib_VPCMPDZrmibk_VPCMPDZrmik_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmib_VPCMPQZrmibk_VPCMPQZrmik_VPCMPUBZrmi_VPCMPUBZrmik_VPCMPUDZrmi_VPCMPUDZrmib_VPCMPUDZrmibk_VPCMPUDZrmik_VPCMPUQZrmi_VPCMPUQZrmib_VPCMPUQZrmibk_VPCMPUQZrmik_VPCMPUWZrmi_VPCMPUWZrmik_VPCMPWZrmi_VPCMPWZrmik_VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 2, false, false, 775, 10, 19, 1,  0, 0}, // #1214
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 2, false, false, 775, 10, 19, 1,  0, 0}, // #1215
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 2, false, false, 775, 10, 19, 1,  0, 0}, // #1216
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 2, false, false, 770, 5, 19, 1,  0, 0}, // #1217
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 2, false, false, 770, 5, 19, 1,  0, 0}, // #1218
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 2, false, false, 770, 5, 19, 1,  0, 0}, // #1219
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 2, false, false, 770, 5, 19, 1,  0, 0}, // #1220
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 2, false, false, 770, 5, 19, 1,  0, 0}, // #1221
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 2, false, false, 770, 5, 19, 1,  0, 0}, // #1222
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz") 2, false, false, 770, 5, 19, 1,  0, 0}, // #1223
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 3, false, false, 785, 10, 19, 1,  0, 0}, // #1224
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 2, false, false, 770, 5,  9, 1,  0, 0}, // #1225
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 2, false, false, 770, 5,  9, 1,  0, 0}, // #1226
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 2, false, false, 770, 5,  9, 1,  0, 0}, // #1227
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 2, false, false, 770, 5,  9, 1,  0, 0}, // #1228
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 2, false, false, 770, 5,  9, 1,  0, 0}, // #1229
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 2, false, false, 770, 5,  9, 1,  0, 0}, // #1230
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 2, false, false, 770, 5,  9, 1,  0, 0}, // #1231
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 2, false, false, 770, 5,  9, 1,  0, 0}, // #1232
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 2, false, false, 770, 5,  9, 1,  0, 0}, // #1233
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 2, false, false, 770, 5,  9, 1,  0, 0}, // #1234
  {DBGFIELD("VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 2, false, false, 770, 5,  9, 1,  0, 0}, // #1235
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 2, false, false, 770, 5,  9, 1,  0, 0}, // #1236
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 3, false, false, 785, 10,  9, 1,  0, 0}, // #1237
  {DBGFIELD("VCVTSD2SSZrm_VCVTSD2SSZrm_Int_VCVTSD2SSZrm_Intk_VCVTSD2SSZrm_Intkz") 3, false, false, 1351, 5,  9, 1,  0, 0}, // #1238
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 4, false, false, 2823, 10,  9, 1,  0, 0}, // #1239
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 3, false, false, 3566, 4, 20, 1,  0, 0}, // #1240
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 3, false, false, 3566, 4, 20, 1,  0, 0}, // #1241
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 3, false, false, 3570, 5, 20, 1,  0, 0}, // #1242
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 3, false, false, 785, 10, 20, 1,  0, 0}, // #1243
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 3, false, false, 3575, 11, 20, 1,  0, 0}, // #1244
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 3, false, false, 3575, 11, 20, 1,  0, 0}, // #1245
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 3, false, false, 1976, 10, 20, 1,  0, 0}, // #1246
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 3, false, false, 785, 10, 27, 1,  0, 0}, // #1247
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 4, false, false, 2823, 10, 27, 1,  0, 0}, // #1248
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 3, false, false, 1976, 10, 21, 1,  0, 0}, // #1249
  {DBGFIELD("VCVTPD2PSZrm_VCVTPD2PSZrmb_VCVTPD2PSZrmbk_VCVTPD2PSZrmbkz_VCVTPD2PSZrmk_VCVTPD2PSZrmkz") 3, false, false, 1976, 10, 21, 1,  0, 0}, // #1250
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 3, false, false, 1976, 10, 21, 1,  0, 0}, // #1251
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 4, false, false, 2823, 10, 21, 1,  0, 0}, // #1252
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 8, false, false, 3586, 13, 10, 1,  0, 0}, // #1253
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 4, false, false, 3599, 5, 29, 1,  0, 0}, // #1254
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 4, false, false, 3599, 5, 63, 1,  0, 0}, // #1255
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 4, false, false, 3599, 5, 63, 1,  0, 0}, // #1256
  {DBGFIELD("VGATHERDPSZ128rm_VGATHERQPSZrm_VPGATHERDDZ128rm") 0, false, false,  0, 0, 30, 1,  0, 0}, // #1257
  {DBGFIELD("VGATHERQPSZ128rm_VGATHERQPSZ256rm_VPGATHERQDZ128rm_VPGATHERQDZ256rm") 5, false, false, 3604, 11, 30, 1,  0, 0}, // #1258
  {DBGFIELD("VGATHERDPDZ128rm_VGATHERQPDZ128rm_VPGATHERDQZ128rm_VPGATHERQQZ128rm") 5, false, false, 3604, 11, 32, 1,  0, 0}, // #1259
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz") 14, false, false, 3615, 9, 32, 1,  0, 0}, // #1260
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 14, false, false, 3615, 9, 32, 1,  0, 0}, // #1261
  {DBGFIELD("VGATHERDPDZ256rm_VGATHERQPDZ256rm_VPGATHERDQZ256rm_VPGATHERQDZrm_VPGATHERQQZ256rm") 5, false, false, 3604, 11, 34, 1,  0, 0}, // #1262
  {DBGFIELD("VGATHERDPDZrm_VGATHERQPDZrm_VPGATHERDQZrm_VPGATHERQQZrm") 5, false, false, 3604, 11, 35, 1,  0, 0}, // #1263
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm") 5, false, false, 3604, 11, 66, 1,  0, 0}, // #1264
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 15, false, false, 3624, 11, 36, 1,  0, 0}, // #1265
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 5, false, false, 3604, 11, 37, 1,  0, 0}, // #1266
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz") 21, false, false, 3635, 9, 108, 1,  0, 0}, // #1267
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 21, false, false, 3635, 9, 108, 1,  0, 0}, // #1268
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 22, false, false, 3644, 11, 87, 1,  0, 0}, // #1269
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 22, false, false, 3644, 11, 87, 1,  0, 0}, // #1270
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz") 35, false, false, 3655, 9, 111, 1,  0, 0}, // #1271
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 36, false, false, 3664, 11, 46, 1,  0, 0}, // #1272
  {DBGFIELD("VXORPSZ128rr_VXORPDZ128rr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1273
  {DBGFIELD("VXORPSZ256rr_VXORPDZ256rr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1274
  {DBGFIELD("VXORPSZrr_VXORPDZrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1275
  {DBGFIELD("VPXORDZ128rr_VPXORQZ128rr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1276
  {DBGFIELD("VPXORDZ256rr_VPXORQZ256rr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1277
  {DBGFIELD("VPXORDZrr_VPXORQZrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1278
  {DBGFIELD("VPSUBBZ128rr_VPSUBDZ128rr_VPSUBQZ128rr_VPSUBWZ128rr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1279
  {DBGFIELD("VPSUBBZ256rr_VPSUBDZ256rr_VPSUBQZ256rr_VPSUBWZ256rr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1280
  {DBGFIELD("VPSUBBZrr_VPSUBDZrr_VPSUBQZrr_VPSUBWZrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1281
  {DBGFIELD("PdWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1282
  {DBGFIELD("WriteVecALU")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1283
  {DBGFIELD("JWriteZeroLatency")  0, false, false,  0, 0,  0, 0,  0, 0}, // #1284
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1285
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1286
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1287
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1288
  