/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the ARM target                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 64;
using PredicateBitset = llvm::PredicateBitsetImpl<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(ARMInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(ARMInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr&) const;
  const ISelInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ISelInfo;
  static ARMInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static ARMInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const int64_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ISelInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_NoHonorSignDependentRoundingBit = 57,
  Feature_HasV4TBit = 6,
  Feature_NoV4TBit = 7,
  Feature_HasV5TBit = 8,
  Feature_HasV5TEBit = 12,
  Feature_HasV6Bit = 0,
  Feature_NoV6Bit = 10,
  Feature_HasV6MBit = 29,
  Feature_HasV8MBaselineBit = 33,
  Feature_HasV6T2Bit = 9,
  Feature_HasV6KBit = 19,
  Feature_HasV7Bit = 3,
  Feature_HasV8Bit = 15,
  Feature_PreV8Bit = 20,
  Feature_HasV8_1aBit = 59,
  Feature_NoVFPBit = 23,
  Feature_HasVFP2Bit = 22,
  Feature_HasVFP3Bit = 47,
  Feature_HasVFP4Bit = 45,
  Feature_HasDPVFPBit = 39,
  Feature_HasFPARMv8Bit = 41,
  Feature_HasNEONBit = 48,
  Feature_HasCryptoBit = 49,
  Feature_HasDotProdBit = 50,
  Feature_HasCRCBit = 14,
  Feature_HasFP16Bit = 54,
  Feature_HasFullFP16Bit = 38,
  Feature_HasDivideInThumbBit = 35,
  Feature_HasDivideInARMBit = 13,
  Feature_HasDSPBit = 34,
  Feature_HasDBBit = 16,
  Feature_HasV7ClrexBit = 18,
  Feature_HasAcquireReleaseBit = 17,
  Feature_HasMPBit = 2,
  Feature_HasZCZBit = 51,
  Feature_UseNEONForFPBit = 62,
  Feature_DontUseNEONForFPBit = 40,
  Feature_IsThumbBit = 27,
  Feature_IsThumb1OnlyBit = 28,
  Feature_IsThumb2Bit = 32,
  Feature_IsNotMClassBit = 36,
  Feature_IsARMBit = 1,
  Feature_IsWindowsBit = 30,
  Feature_IsNotWindowsBit = 31,
  Feature_IsReadTPHardBit = 55,
  Feature_IsReadTPSoftBit = 21,
  Feature_UseNaClTrapBit = 4,
  Feature_DontUseNaClTrapBit = 5,
  Feature_UseMovtBit = 37,
  Feature_DontUseMovtBit = 24,
  Feature_UseMovtInPicBit = 25,
  Feature_DontUseMovtInPicBit = 26,
  Feature_UseFPVMLxBit = 44,
  Feature_UseMulOpsBit = 11,
  Feature_UseFusedMACBit = 46,
  Feature_DontUseFusedMACBit = 43,
  Feature_HasFastVGETLNi32Bit = 52,
  Feature_HasSlowVGETLNi32Bit = 60,
  Feature_HasFastVDUP32Bit = 53,
  Feature_HasSlowVDUP32Bit = 61,
  Feature_UseVMOVSRBit = 42,
  Feature_DontUseVMOVSRBit = 63,
  Feature_IsLEBit = 56,
  Feature_IsBEBit = 58,
};

PredicateBitset ARMInstructionSelector::
computeAvailableModuleFeatures(const ARMSubtarget *Subtarget) const {
  PredicateBitset Features;
  if (!TM.Options.HonorSignDependentRoundingFPMath())
    Features[Feature_NoHonorSignDependentRoundingBit] = 1;
  if (Subtarget->hasV4TOps())
    Features[Feature_HasV4TBit] = 1;
  if (!Subtarget->hasV4TOps())
    Features[Feature_NoV4TBit] = 1;
  if (Subtarget->hasV5TOps())
    Features[Feature_HasV5TBit] = 1;
  if (Subtarget->hasV5TEOps())
    Features[Feature_HasV5TEBit] = 1;
  if (Subtarget->hasV6Ops())
    Features[Feature_HasV6Bit] = 1;
  if (!Subtarget->hasV6Ops())
    Features[Feature_NoV6Bit] = 1;
  if (Subtarget->hasV6MOps())
    Features[Feature_HasV6MBit] = 1;
  if (Subtarget->hasV8MBaselineOps())
    Features[Feature_HasV8MBaselineBit] = 1;
  if (Subtarget->hasV6T2Ops())
    Features[Feature_HasV6T2Bit] = 1;
  if (Subtarget->hasV6KOps())
    Features[Feature_HasV6KBit] = 1;
  if (Subtarget->hasV7Ops())
    Features[Feature_HasV7Bit] = 1;
  if (Subtarget->hasV8Ops())
    Features[Feature_HasV8Bit] = 1;
  if (!Subtarget->hasV8Ops())
    Features[Feature_PreV8Bit] = 1;
  if (Subtarget->hasV8_1aOps())
    Features[Feature_HasV8_1aBit] = 1;
  if (!Subtarget->hasVFP2())
    Features[Feature_NoVFPBit] = 1;
  if (Subtarget->hasVFP2())
    Features[Feature_HasVFP2Bit] = 1;
  if (Subtarget->hasVFP3())
    Features[Feature_HasVFP3Bit] = 1;
  if (Subtarget->hasVFP4())
    Features[Feature_HasVFP4Bit] = 1;
  if (!Subtarget->isFPOnlySP())
    Features[Feature_HasDPVFPBit] = 1;
  if (Subtarget->hasFPARMv8())
    Features[Feature_HasFPARMv8Bit] = 1;
  if (Subtarget->hasNEON())
    Features[Feature_HasNEONBit] = 1;
  if (Subtarget->hasCrypto())
    Features[Feature_HasCryptoBit] = 1;
  if (Subtarget->hasDotProd())
    Features[Feature_HasDotProdBit] = 1;
  if (Subtarget->hasCRC())
    Features[Feature_HasCRCBit] = 1;
  if (Subtarget->hasFP16())
    Features[Feature_HasFP16Bit] = 1;
  if (Subtarget->hasFullFP16())
    Features[Feature_HasFullFP16Bit] = 1;
  if (Subtarget->hasDivideInThumbMode())
    Features[Feature_HasDivideInThumbBit] = 1;
  if (Subtarget->hasDivideInARMMode())
    Features[Feature_HasDivideInARMBit] = 1;
  if (Subtarget->hasDSP())
    Features[Feature_HasDSPBit] = 1;
  if (Subtarget->hasDataBarrier())
    Features[Feature_HasDBBit] = 1;
  if (Subtarget->hasV7Clrex())
    Features[Feature_HasV7ClrexBit] = 1;
  if (Subtarget->hasAcquireRelease())
    Features[Feature_HasAcquireReleaseBit] = 1;
  if (Subtarget->hasMPExtension())
    Features[Feature_HasMPBit] = 1;
  if (Subtarget->hasZeroCycleZeroing())
    Features[Feature_HasZCZBit] = 1;
  if (Subtarget->useNEONForSinglePrecisionFP())
    Features[Feature_UseNEONForFPBit] = 1;
  if (!Subtarget->useNEONForSinglePrecisionFP())
    Features[Feature_DontUseNEONForFPBit] = 1;
  if (Subtarget->isThumb())
    Features[Feature_IsThumbBit] = 1;
  if (Subtarget->isThumb1Only())
    Features[Feature_IsThumb1OnlyBit] = 1;
  if (Subtarget->isThumb2())
    Features[Feature_IsThumb2Bit] = 1;
  if (!Subtarget->isMClass())
    Features[Feature_IsNotMClassBit] = 1;
  if (!Subtarget->isThumb())
    Features[Feature_IsARMBit] = 1;
  if (Subtarget->isTargetWindows())
    Features[Feature_IsWindowsBit] = 1;
  if (!Subtarget->isTargetWindows())
    Features[Feature_IsNotWindowsBit] = 1;
  if (Subtarget->isReadTPHard())
    Features[Feature_IsReadTPHardBit] = 1;
  if (!Subtarget->isReadTPHard())
    Features[Feature_IsReadTPSoftBit] = 1;
  if (Subtarget->useNaClTrap())
    Features[Feature_UseNaClTrapBit] = 1;
  if (!Subtarget->useNaClTrap())
    Features[Feature_DontUseNaClTrapBit] = 1;
  if (Subtarget->useFPVMLx())
    Features[Feature_UseFPVMLxBit] = 1;
  if (Subtarget->useMulOps())
    Features[Feature_UseMulOpsBit] = 1;
  if ((TM.Options.AllowFPOpFusion == FPOpFusion::Fast &&  Subtarget->hasVFP4()) && !Subtarget->isTargetDarwin())
    Features[Feature_UseFusedMACBit] = 1;
  if (!(TM.Options.AllowFPOpFusion == FPOpFusion::Fast && Subtarget->hasVFP4()) || Subtarget->isTargetDarwin())
    Features[Feature_DontUseFusedMACBit] = 1;
  if (!Subtarget->hasSlowVGETLNi32())
    Features[Feature_HasFastVGETLNi32Bit] = 1;
  if (Subtarget->hasSlowVGETLNi32())
    Features[Feature_HasSlowVGETLNi32Bit] = 1;
  if (!Subtarget->hasSlowVDUP32())
    Features[Feature_HasFastVDUP32Bit] = 1;
  if (Subtarget->hasSlowVDUP32())
    Features[Feature_HasSlowVDUP32Bit] = 1;
  if (Subtarget->preferVMOVSR() ||!Subtarget->useNEONForSinglePrecisionFP())
    Features[Feature_UseVMOVSRBit] = 1;
  if (!Subtarget->preferVMOVSR() &&Subtarget->useNEONForSinglePrecisionFP())
    Features[Feature_DontUseVMOVSRBit] = 1;
  return Features;
}

PredicateBitset ARMInstructionSelector::
computeAvailableFunctionFeatures(const ARMSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  if (Subtarget->useMovt(*MF))
    Features[Feature_UseMovtBit] = 1;
  if (!Subtarget->useMovt(*MF))
    Features[Feature_DontUseMovtBit] = 1;
  if (Subtarget->useMovt(*MF) && Subtarget->allowPositionIndependentMovt())
    Features[Feature_UseMovtInPicBit] = 1;
  if (!Subtarget->useMovt(*MF) || !Subtarget->allowPositionIndependentMovt())
    Features[Feature_DontUseMovtInPicBit] = 1;
  if (MF->getDataLayout().isLittleEndian())
    Features[Feature_IsLEBit] = 1;
  if (MF->getDataLayout().isBigEndian())
    Features[Feature_IsBEBit] = 1;
  return Features;
}

// LLT Objects.
enum {
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_v2s32,
  GILLT_v2s64,
  GILLT_v4s16,
  GILLT_v4s32,
  GILLT_v8s8,
  GILLT_v8s16,
  GILLT_v16s8,
};
const static size_t NumTypeObjects = 10;
const static LLT TypeObjects[] = {
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(2, 32),
  LLT::vector(2, 64),
  LLT::vector(4, 16),
  LLT::vector(4, 32),
  LLT::vector(8, 8),
  LLT::vector(8, 16),
  LLT::vector(16, 8),
};

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasDotProd,
  GIFBS_HasFPARMv8,
  GIFBS_HasFullFP16,
  GIFBS_HasNEON,
  GIFBS_HasVFP2,
  GIFBS_HasVFP4,
  GIFBS_IsARM,
  GIFBS_IsBE,
  GIFBS_IsLE,
  GIFBS_IsThumb,
  GIFBS_IsThumb2,
  GIFBS_NoHonorSignDependentRounding,
  GIFBS_DontUseNEONForFP_HasVFP2,
  GIFBS_HasCrypto_HasV8,
  GIFBS_HasDB_IsARM,
  GIFBS_HasDB_IsThumb,
  GIFBS_HasDPVFP_HasFPARMv8,
  GIFBS_HasDPVFP_HasVFP2,
  GIFBS_HasDPVFP_HasVFP4,
  GIFBS_HasDPVFP_NoHonorSignDependentRounding,
  GIFBS_HasDSP_IsThumb2,
  GIFBS_HasDivideInARM_IsARM,
  GIFBS_HasFP16_HasNEON,
  GIFBS_HasFullFP16_HasNEON,
  GIFBS_HasNEON_HasV8,
  GIFBS_HasNEON_HasV8_1a,
  GIFBS_HasV5T_IsARM,
  GIFBS_HasV5TE_IsARM,
  GIFBS_HasV6_IsARM,
  GIFBS_HasV6K_IsARM,
  GIFBS_HasV6M_IsThumb,
  GIFBS_HasV6T2_IsARM,
  GIFBS_HasV6T2_IsThumb2,
  GIFBS_HasV7_IsARM,
  GIFBS_HasV7Clrex_IsThumb,
  GIFBS_HasV8MBaseline_IsThumb,
  GIFBS_HasVFP2_UseVMOVSR,
  GIFBS_IsARM_NoV6,
  GIFBS_IsARM_PreV8,
  GIFBS_IsThumb_IsThumb1Only,
  GIFBS_IsThumb_IsWindows,
  GIFBS_IsThumb_UseMovt,
  GIFBS_IsThumb2_PreV8,
  GIFBS_IsThumb2_UseMulOps,
  GIFBS_HasCRC_HasV8_IsARM,
  GIFBS_HasCRC_HasV8_IsThumb2,
  GIFBS_HasDSP_IsThumb2_UseMulOps,
  GIFBS_HasDivideInThumb_HasV8MBaseline_IsThumb,
  GIFBS_HasFullFP16_HasNEON_HasV8,
  GIFBS_HasFullFP16_HasNEON_UseFusedMAC,
  GIFBS_HasV5TE_IsARM_UseMulOps,
  GIFBS_HasV6_IsARM_UseMulOps,
  GIFBS_HasV6_IsThumb_IsThumb1Only,
  GIFBS_HasV6T2_IsARM_UseMulOps,
  GIFBS_IsARM_NoV6_UseMulOps,
  GIFBS_DontUseFusedMAC_HasFullFP16_HasNEON_UseFPVMLx,
};
const static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasDotProdBit, },
  {Feature_HasFPARMv8Bit, },
  {Feature_HasFullFP16Bit, },
  {Feature_HasNEONBit, },
  {Feature_HasVFP2Bit, },
  {Feature_HasVFP4Bit, },
  {Feature_IsARMBit, },
  {Feature_IsBEBit, },
  {Feature_IsLEBit, },
  {Feature_IsThumbBit, },
  {Feature_IsThumb2Bit, },
  {Feature_NoHonorSignDependentRoundingBit, },
  {Feature_DontUseNEONForFPBit, Feature_HasVFP2Bit, },
  {Feature_HasCryptoBit, Feature_HasV8Bit, },
  {Feature_HasDBBit, Feature_IsARMBit, },
  {Feature_HasDBBit, Feature_IsThumbBit, },
  {Feature_HasDPVFPBit, Feature_HasFPARMv8Bit, },
  {Feature_HasDPVFPBit, Feature_HasVFP2Bit, },
  {Feature_HasDPVFPBit, Feature_HasVFP4Bit, },
  {Feature_HasDPVFPBit, Feature_NoHonorSignDependentRoundingBit, },
  {Feature_HasDSPBit, Feature_IsThumb2Bit, },
  {Feature_HasDivideInARMBit, Feature_IsARMBit, },
  {Feature_HasFP16Bit, Feature_HasNEONBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, },
  {Feature_HasNEONBit, Feature_HasV8Bit, },
  {Feature_HasNEONBit, Feature_HasV8_1aBit, },
  {Feature_HasV5TBit, Feature_IsARMBit, },
  {Feature_HasV5TEBit, Feature_IsARMBit, },
  {Feature_HasV6Bit, Feature_IsARMBit, },
  {Feature_HasV6KBit, Feature_IsARMBit, },
  {Feature_HasV6MBit, Feature_IsThumbBit, },
  {Feature_HasV6T2Bit, Feature_IsARMBit, },
  {Feature_HasV6T2Bit, Feature_IsThumb2Bit, },
  {Feature_HasV7Bit, Feature_IsARMBit, },
  {Feature_HasV7ClrexBit, Feature_IsThumbBit, },
  {Feature_HasV8MBaselineBit, Feature_IsThumbBit, },
  {Feature_HasVFP2Bit, Feature_UseVMOVSRBit, },
  {Feature_IsARMBit, Feature_NoV6Bit, },
  {Feature_IsARMBit, Feature_PreV8Bit, },
  {Feature_IsThumbBit, Feature_IsThumb1OnlyBit, },
  {Feature_IsThumbBit, Feature_IsWindowsBit, },
  {Feature_IsThumbBit, Feature_UseMovtBit, },
  {Feature_IsThumb2Bit, Feature_PreV8Bit, },
  {Feature_IsThumb2Bit, Feature_UseMulOpsBit, },
  {Feature_HasCRCBit, Feature_HasV8Bit, Feature_IsARMBit, },
  {Feature_HasCRCBit, Feature_HasV8Bit, Feature_IsThumb2Bit, },
  {Feature_HasDSPBit, Feature_IsThumb2Bit, Feature_UseMulOpsBit, },
  {Feature_HasDivideInThumbBit, Feature_HasV8MBaselineBit, Feature_IsThumbBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_HasV8Bit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_UseFusedMACBit, },
  {Feature_HasV5TEBit, Feature_IsARMBit, Feature_UseMulOpsBit, },
  {Feature_HasV6Bit, Feature_IsARMBit, Feature_UseMulOpsBit, },
  {Feature_HasV6Bit, Feature_IsThumbBit, Feature_IsThumb1OnlyBit, },
  {Feature_HasV6T2Bit, Feature_IsARMBit, Feature_UseMulOpsBit, },
  {Feature_IsARMBit, Feature_NoV6Bit, Feature_UseMulOpsBit, },
  {Feature_DontUseFusedMACBit, Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_UseFPVMLxBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

// PatFrag predicates.
enum {
  GIPFP_I64_Predicate_VectorIndex16 = GIPFP_I64_Invalid + 1,
  GIPFP_I64_Predicate_VectorIndex32,
  GIPFP_I64_Predicate_VectorIndex64,
  GIPFP_I64_Predicate_VectorIndex8,
  GIPFP_I64_Predicate_imm0_15,
  GIPFP_I64_Predicate_imm0_239,
  GIPFP_I64_Predicate_imm0_255,
  GIPFP_I64_Predicate_imm0_31,
  GIPFP_I64_Predicate_imm0_32,
  GIPFP_I64_Predicate_imm0_4095,
  GIPFP_I64_Predicate_imm0_63,
  GIPFP_I64_Predicate_imm0_65535,
  GIPFP_I64_Predicate_imm0_65535_neg,
  GIPFP_I64_Predicate_imm0_7,
  GIPFP_I64_Predicate_imm16,
  GIPFP_I64_Predicate_imm16_31,
  GIPFP_I64_Predicate_imm1_15,
  GIPFP_I64_Predicate_imm1_16,
  GIPFP_I64_Predicate_imm1_31,
  GIPFP_I64_Predicate_imm1_7,
  GIPFP_I64_Predicate_imm24b,
  GIPFP_I64_Predicate_imm256_510,
  GIPFP_I64_Predicate_imm32,
  GIPFP_I64_Predicate_imm8,
  GIPFP_I64_Predicate_imm8_255,
  GIPFP_I64_Predicate_imm8_or_16,
  GIPFP_I64_Predicate_mod_imm,
  GIPFP_I64_Predicate_pkh_asr_amt,
  GIPFP_I64_Predicate_pkh_lsl_amt,
  GIPFP_I64_Predicate_shr_imm16,
  GIPFP_I64_Predicate_shr_imm32,
  GIPFP_I64_Predicate_shr_imm64,
  GIPFP_I64_Predicate_shr_imm8,
  GIPFP_I64_Predicate_t2_so_imm,
  GIPFP_I64_Predicate_t2_so_imm_neg,
};
bool ARMInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GIPFP_I64_Predicate_VectorIndex16: {
    
  return ((uint64_t)Imm) < 4;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndex32: {
    
  return ((uint64_t)Imm) < 2;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndex64: {
    
  return ((uint64_t)Imm) < 1;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndex8: {
    
  return ((uint64_t)Imm) < 8;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_15: {
    
  return Imm >= 0 && Imm < 16;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_239: {
     return Imm >= 0 && Imm < 240; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_255: {
     return Imm >= 0 && Imm < 256; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_31: {
    
  return Imm >= 0 && Imm < 32;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_32: {
    
  return Imm >= 0 && Imm < 33;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_4095: {
    
  return Imm >= 0 && Imm < 4096;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_63: {
    
  return Imm >= 0 && Imm < 64;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_65535: {
    
  return Imm >= 0 && Imm < 65536;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_65535_neg: {
    
  return -Imm >= 0 && -Imm < 65536;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_7: {
    
  return Imm >= 0 && Imm < 8;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm16: {
     return Imm == 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm16_31: {
    
  return (int32_t)Imm >= 16 && (int32_t)Imm < 32;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm1_15: {
     return Imm > 0 && Imm < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm1_16: {
    
    return Imm > 0 && Imm <= 16;
  
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm1_31: {
     return Imm > 0 && Imm < 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm1_7: {
     return Imm > 0 && Imm < 8; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm24b: {
    
  return Imm >= 0 && Imm <= 0xffffff;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm256_510: {
    
  return Imm >= 256 && Imm < 511;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm32: {
     return Imm == 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm8: {
     return Imm == 8; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm8_255: {
    
  return Imm >= 8 && Imm < 256;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm8_or_16: {
     return Imm == 8 || Imm == 16;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_mod_imm: {
    
    return ARM_AM::getSOImmVal(Imm) != -1;
  
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_pkh_asr_amt: {
     return Imm > 0 && Imm <= 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_pkh_lsl_amt: {
     return Imm >= 0 && Imm < 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_shr_imm16: {
     return Imm > 0 && Imm <= 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_shr_imm32: {
     return Imm > 0 && Imm <= 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_shr_imm64: {
     return Imm > 0 && Imm <= 64; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_shr_imm8: {
     return Imm > 0 && Imm <= 8; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_t2_so_imm: {
    
    return ARM_AM::getT2SOImmVal(Imm) != -1;
  
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_t2_so_imm_neg: {
    
  return Imm && ARM_AM::getT2SOImmVal(-(uint32_t)Imm) != -1;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool ARMInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool ARMInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GIPFP_MI_Predicate_bf_inv_mask_imm = GIPFP_MI_Invalid + 1,
};
bool ARMInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  (void)MRI;
  switch (PredicateID) {
  case GIPFP_MI_Predicate_bf_inv_mask_imm: {
    
    // There's better methods of implementing this check. IntImmLeaf<> would be
    // equivalent and have less boilerplate but we need a test for C++
    // predicates and this one causes new rules to be imported into GlobalISel
    // without requiring additional features first.
    const auto &MO = MI.getOperand(1);
    if (!MO.isCImm())
      return false;
    return ARM::isBitFieldInvertedMask(MO.getCImm()->getZExtValue());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}

ARMInstructionSelector::ComplexMatcherMemFn
ARMInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// Custom renderers.
enum {
  GICR_Invalid,
};
ARMInstructionSelector::CustomRendererFn
ARMInstructionSelector::CustomRenderers[] = {
  nullptr, // GICP_Invalid
};

bool ARMInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  MachineFunction &MF = *I.getParent()->getParent();
  MachineRegisterInfo &MRI = MF.getRegInfo();
  // FIXME: This should be computed on a per-function basis rather than per-insn.
  AvailableFunctionFeatures = computeAvailableFunctionFeatures(&STI, &MF);
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  NewMIVector OutMIs;
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, OutMIs, State, ISelInfo, getMatchTable(), TII, MRI, TRI, RBI, AvailableFeatures, CoverageInfo)) {
    return true;
  }

  return false;
}

const int64_t *ARMInstructionSelector::getMatchTable() const {
  constexpr static int64_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/34, 124, /*)*//*default:*//*Label 33*/ 61035,
    /*TargetOpcode::G_ADD*//*Label 0*/ 95,
    /*TargetOpcode::G_SUB*//*Label 1*/ 6646,
    /*TargetOpcode::G_MUL*//*Label 2*/ 8636,
    /*TargetOpcode::G_SDIV*//*Label 3*/ 9270,
    /*TargetOpcode::G_UDIV*//*Label 4*/ 9370, 0, 0,
    /*TargetOpcode::G_AND*//*Label 5*/ 9470,
    /*TargetOpcode::G_OR*//*Label 6*/ 11183,
    /*TargetOpcode::G_XOR*//*Label 7*/ 15366, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_BITCAST*//*Label 8*/ 15865, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_INTRINSIC*//*Label 9*/ 20253,
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 10*/ 49624,
    /*TargetOpcode::G_ANYEXT*//*Label 11*/ 53953,
    /*TargetOpcode::G_TRUNC*//*Label 12*/ 54076,
    /*TargetOpcode::G_CONSTANT*//*Label 13*/ 54205, 0, 0, 0,
    /*TargetOpcode::G_SEXT*//*Label 14*/ 54370,
    /*TargetOpcode::G_ZEXT*//*Label 15*/ 54499,
    /*TargetOpcode::G_SHL*//*Label 16*/ 55009,
    /*TargetOpcode::G_LSHR*//*Label 17*/ 55114,
    /*TargetOpcode::G_ASHR*//*Label 18*/ 55172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FADD*//*Label 19*/ 55385,
    /*TargetOpcode::G_FSUB*//*Label 20*/ 56016,
    /*TargetOpcode::G_FMUL*//*Label 21*/ 56631,
    /*TargetOpcode::G_FMA*//*Label 22*/ 57214,
    /*TargetOpcode::G_FDIV*//*Label 23*/ 58107, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FNEG*//*Label 24*/ 58270,
    /*TargetOpcode::G_FPEXT*//*Label 25*/ 59187,
    /*TargetOpcode::G_FPTRUNC*//*Label 26*/ 59344,
    /*TargetOpcode::G_FPTOSI*//*Label 27*/ 59505,
    /*TargetOpcode::G_FPTOUI*//*Label 28*/ 59845,
    /*TargetOpcode::G_SITOFP*//*Label 29*/ 60185,
    /*TargetOpcode::G_UITOFP*//*Label 30*/ 60522, 0, 0, 0,
    /*TargetOpcode::G_BR*//*Label 31*/ 60859, 0, 0, 0,
    /*TargetOpcode::G_BSWAP*//*Label 32*/ 60921,
    // Label 0: @95
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 10, /*)*//*default:*//*Label 43*/ 6645,
    /*GILLT_s32*//*Label 34*/ 110,
    /*GILLT_s64*//*Label 35*/ 1788,
    /*GILLT_v2s32*//*Label 36*/ 1839,
    /*GILLT_v2s64*//*Label 37*/ 2299,
    /*GILLT_v4s16*//*Label 38*/ 3017,
    /*GILLT_v4s32*//*Label 39*/ 3477,
    /*GILLT_v8s8*//*Label 40*/ 4601,
    /*GILLT_v8s16*//*Label 41*/ 5061,
    /*GILLT_v16s8*//*Label 42*/ 6185,
    // Label 34: @110
    GIM_Try, /*On fail goto*//*Label 44*/ 1787,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 45*/ 186, // Rule ID 2738 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (UXTAB:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2738,
        GIR_Done,
      // Label 45: @186
      GIM_Try, /*On fail goto*//*Label 46*/ 252, // Rule ID 2739 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (UXTAH:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2739,
        GIR_Done,
      // Label 46: @252
      GIM_Try, /*On fail goto*//*Label 47*/ 318, // Rule ID 2768 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2UXTAB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2768,
        GIR_Done,
      // Label 47: @318
      GIM_Try, /*On fail goto*//*Label 48*/ 384, // Rule ID 2769 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2UXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2769,
        GIR_Done,
      // Label 48: @384
      GIM_Try, /*On fail goto*//*Label 49*/ 450, // Rule ID 1813 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }))  =>  (UXTAB:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1813,
        GIR_Done,
      // Label 49: @450
      GIM_Try, /*On fail goto*//*Label 50*/ 516, // Rule ID 1814 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }))  =>  (UXTAH:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1814,
        GIR_Done,
      // Label 50: @516
      GIM_Try, /*On fail goto*//*Label 51*/ 582, // Rule ID 1999 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }))  =>  (t2UXTAB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1999,
        GIR_Done,
      // Label 51: @582
      GIM_Try, /*On fail goto*//*Label 52*/ 648, // Rule ID 2000 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }))  =>  (t2UXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2000,
        GIR_Done,
      // Label 52: @648
      GIM_Try, /*On fail goto*//*Label 53*/ 757, // Rule ID 2523 //
        GIM_CheckFeatures, GIFBS_HasV5TE_IsARM_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i32] } (mul:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 16:{ *:[i32] })), GPR:{ *:[i32] }:$Ra)  =>  (SMLATT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SMLATT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2523,
        GIR_Done,
      // Label 53: @757
      GIM_Try, /*On fail goto*//*Label 54*/ 866, // Rule ID 2560 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i32] } (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] })), rGPR:{ *:[i32] }:$Ra)  =>  (t2SMLATT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SMLATT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2560,
        GIR_Done,
      // Label 54: @866
      GIM_Try, /*On fail goto*//*Label 55*/ 975, // Rule ID 194 //
        GIM_CheckFeatures, GIFBS_HasV5TE_IsARM_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 16:{ *:[i32] })))  =>  (SMLATT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SMLATT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 194,
        GIR_Done,
      // Label 55: @975
      GIM_Try, /*On fail goto*//*Label 56*/ 1084, // Rule ID 525 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] })))  =>  (t2SMLATT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SMLATT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 525,
        GIR_Done,
      // Label 56: @1084
      GIM_Try, /*On fail goto*//*Label 57*/ 1136, // Rule ID 74 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (ADDri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::ADDri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 74,
        GIR_Done,
      // Label 57: @1136
      GIM_Try, /*On fail goto*//*Label 58*/ 1188, // Rule ID 411 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2ADDri:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ADDri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 411,
        GIR_Done,
      // Label 58: @1188
      GIM_Try, /*On fail goto*//*Label 59*/ 1237, // Rule ID 412 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_imm0_4095,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_imm0_4095>>:$imm)  =>  (t2ADDri12:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ADDri12,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 412,
        GIR_Done,
      // Label 59: @1237
      GIM_Try, /*On fail goto*//*Label 60*/ 1307, // Rule ID 173 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm), GPRnopc:{ *:[i32] }:$Ra)  =>  (MLA:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 173,
        GIR_Done,
      // Label 60: @1307
      GIM_Try, /*On fail goto*//*Label 61*/ 1377, // Rule ID 174 //
        GIM_CheckFeatures, GIFBS_IsARM_NoV6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm), GPRnopc:{ *:[i32] }:$Ra)  =>  (MLAv5:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MLAv5,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 174,
        GIR_Done,
      // Label 61: @1377
      GIM_Try, /*On fail goto*//*Label 62*/ 1444, // Rule ID 507 //
        GIM_CheckFeatures, GIFBS_IsThumb2_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm), rGPR:{ *:[i32] }:$Ra)  =>  (t2MLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 507,
        GIR_Done,
      // Label 62: @1444
      GIM_Try, /*On fail goto*//*Label 63*/ 1514, // Rule ID 2517 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Ra, (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm))  =>  (MLA:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2517,
        GIR_Done,
      // Label 63: @1514
      GIM_Try, /*On fail goto*//*Label 64*/ 1584, // Rule ID 2518 //
        GIM_CheckFeatures, GIFBS_IsARM_NoV6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Ra, (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm))  =>  (MLAv5:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MLAv5,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2518,
        GIR_Done,
      // Label 64: @1584
      GIM_Try, /*On fail goto*//*Label 65*/ 1651, // Rule ID 2555 //
        GIM_CheckFeatures, GIFBS_IsThumb2_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm))  =>  (t2MLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2555,
        GIR_Done,
      // Label 65: @1651
      GIM_Try, /*On fail goto*//*Label 66*/ 1696, // Rule ID 75 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (ADDrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::ADDrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 75,
        GIR_Done,
      // Label 66: @1696
      GIM_Try, /*On fail goto*//*Label 67*/ 1741, // Rule ID 413 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2ADDrr:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ADDrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 413,
        GIR_Done,
      // Label 67: @1741
      GIM_Try, /*On fail goto*//*Label 68*/ 1786, // Rule ID 2537 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)  =>  (t2ADDrr:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ADDrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2537,
        GIR_Done,
      // Label 68: @1786
      GIM_Reject,
    // Label 44: @1787
    GIM_Reject,
    // Label 35: @1788
    GIM_Try, /*On fail goto*//*Label 69*/ 1838, // Rule ID 760 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (add:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)  =>  (VADDv1i64:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv1i64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 760,
      GIR_Done,
    // Label 69: @1838
    GIM_Reject,
    // Label 36: @1839
    GIM_Try, /*On fail goto*//*Label 70*/ 2298,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 71*/ 1923, // Rule ID 2675 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 1016:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm), DPR:{ *:[v2i32] }:$src1)  =>  (VABAsv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2675,
        GIR_Done,
      // Label 71: @1923
      GIM_Try, /*On fail goto*//*Label 72*/ 1993, // Rule ID 2681 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 1017:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm), DPR:{ *:[v2i32] }:$src1)  =>  (VABAuv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2681,
        GIR_Done,
      // Label 72: @1993
      GIM_Try, /*On fail goto*//*Label 73*/ 2063, // Rule ID 1152 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, (intrinsic_wo_chain:{ *:[v2i32] } 1016:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VABAsv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1152,
        GIR_Done,
      // Label 73: @2063
      GIM_Try, /*On fail goto*//*Label 74*/ 2133, // Rule ID 1158 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, (intrinsic_wo_chain:{ *:[v2i32] } 1017:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VABAuv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1158,
        GIR_Done,
      // Label 74: @2133
      GIM_Try, /*On fail goto*//*Label 75*/ 2196, // Rule ID 2605 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm), DPR:{ *:[v2i32] }:$src1)  =>  (VMLAv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2605,
        GIR_Done,
      // Label 75: @2196
      GIM_Try, /*On fail goto*//*Label 76*/ 2259, // Rule ID 875 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VMLAv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 875,
        GIR_Done,
      // Label 76: @2259
      GIM_Try, /*On fail goto*//*Label 77*/ 2297, // Rule ID 756 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (add:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VADDv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 756,
        GIR_Done,
      // Label 77: @2297
      GIM_Reject,
    // Label 70: @2298
    GIM_Reject,
    // Label 37: @2299
    GIM_Try, /*On fail goto*//*Label 78*/ 3016,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 79*/ 2396, // Rule ID 2687 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 1016:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)), QPR:{ *:[v2i64] }:$src1)  =>  (VABALsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2687,
        GIR_Done,
      // Label 79: @2396
      GIM_Try, /*On fail goto*//*Label 80*/ 2479, // Rule ID 2690 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 1017:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)), QPR:{ *:[v2i64] }:$src1)  =>  (VABALuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2690,
        GIR_Done,
      // Label 80: @2479
      GIM_Try, /*On fail goto*//*Label 81*/ 2562, // Rule ID 1164 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 1016:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)))  =>  (VABALsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1164,
        GIR_Done,
      // Label 81: @2562
      GIM_Try, /*On fail goto*//*Label 82*/ 2645, // Rule ID 1167 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 1017:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)))  =>  (VABALuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1167,
        GIR_Done,
      // Label 82: @2645
      GIM_Try, /*On fail goto*//*Label 83*/ 2709, // Rule ID 768 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLsv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 768,
        GIR_Done,
      // Label 83: @2709
      GIM_Try, /*On fail goto*//*Label 84*/ 2773, // Rule ID 771 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 771,
        GIR_Done,
      // Label 84: @2773
      GIM_Try, /*On fail goto*//*Label 85*/ 2824, // Rule ID 2581 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm), QPR:{ *:[v2i64] }:$Vn)  =>  (VADDWsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2581,
        GIR_Done,
      // Label 85: @2824
      GIM_Try, /*On fail goto*//*Label 86*/ 2875, // Rule ID 2584 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm), QPR:{ *:[v2i64] }:$Vn)  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2584,
        GIR_Done,
      // Label 86: @2875
      GIM_Try, /*On fail goto*//*Label 87*/ 2926, // Rule ID 774 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDWsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 774,
        GIR_Done,
      // Label 87: @2926
      GIM_Try, /*On fail goto*//*Label 88*/ 2977, // Rule ID 777 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 777,
        GIR_Done,
      // Label 88: @2977
      GIM_Try, /*On fail goto*//*Label 89*/ 3015, // Rule ID 761 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VADDv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 761,
        GIR_Done,
      // Label 89: @3015
      GIM_Reject,
    // Label 78: @3016
    GIM_Reject,
    // Label 38: @3017
    GIM_Try, /*On fail goto*//*Label 90*/ 3476,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 91*/ 3101, // Rule ID 2674 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 1016:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm), DPR:{ *:[v4i16] }:$src1)  =>  (VABAsv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2674,
        GIR_Done,
      // Label 91: @3101
      GIM_Try, /*On fail goto*//*Label 92*/ 3171, // Rule ID 2680 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 1017:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm), DPR:{ *:[v4i16] }:$src1)  =>  (VABAuv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2680,
        GIR_Done,
      // Label 92: @3171
      GIM_Try, /*On fail goto*//*Label 93*/ 3241, // Rule ID 1151 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, (intrinsic_wo_chain:{ *:[v4i16] } 1016:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VABAsv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1151,
        GIR_Done,
      // Label 93: @3241
      GIM_Try, /*On fail goto*//*Label 94*/ 3311, // Rule ID 1157 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, (intrinsic_wo_chain:{ *:[v4i16] } 1017:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VABAuv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1157,
        GIR_Done,
      // Label 94: @3311
      GIM_Try, /*On fail goto*//*Label 95*/ 3374, // Rule ID 2604 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm), DPR:{ *:[v4i16] }:$src1)  =>  (VMLAv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2604,
        GIR_Done,
      // Label 95: @3374
      GIM_Try, /*On fail goto*//*Label 96*/ 3437, // Rule ID 874 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VMLAv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 874,
        GIR_Done,
      // Label 96: @3437
      GIM_Try, /*On fail goto*//*Label 97*/ 3475, // Rule ID 755 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (add:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VADDv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 755,
        GIR_Done,
      // Label 97: @3475
      GIM_Reject,
    // Label 90: @3476
    GIM_Reject,
    // Label 39: @3477
    GIM_Try, /*On fail goto*//*Label 98*/ 4600,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 99*/ 3574, // Rule ID 2686 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 1016:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)), QPR:{ *:[v4i32] }:$src1)  =>  (VABALsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2686,
        GIR_Done,
      // Label 99: @3574
      GIM_Try, /*On fail goto*//*Label 100*/ 3657, // Rule ID 2689 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 1017:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)), QPR:{ *:[v4i32] }:$src1)  =>  (VABALuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2689,
        GIR_Done,
      // Label 100: @3657
      GIM_Try, /*On fail goto*//*Label 101*/ 3740, // Rule ID 1163 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 1016:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)))  =>  (VABALsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1163,
        GIR_Done,
      // Label 101: @3740
      GIM_Try, /*On fail goto*//*Label 102*/ 3823, // Rule ID 1166 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 1017:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)))  =>  (VABALuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1166,
        GIR_Done,
      // Label 102: @3823
      GIM_Try, /*On fail goto*//*Label 103*/ 3893, // Rule ID 2678 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 1016:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm), QPR:{ *:[v4i32] }:$src1)  =>  (VABAsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2678,
        GIR_Done,
      // Label 103: @3893
      GIM_Try, /*On fail goto*//*Label 104*/ 3963, // Rule ID 2684 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 1017:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm), QPR:{ *:[v4i32] }:$src1)  =>  (VABAuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2684,
        GIR_Done,
      // Label 104: @3963
      GIM_Try, /*On fail goto*//*Label 105*/ 4033, // Rule ID 1155 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (intrinsic_wo_chain:{ *:[v4i32] } 1016:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VABAsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1155,
        GIR_Done,
      // Label 105: @4033
      GIM_Try, /*On fail goto*//*Label 106*/ 4103, // Rule ID 1161 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (intrinsic_wo_chain:{ *:[v4i32] } 1017:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VABAuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1161,
        GIR_Done,
      // Label 106: @4103
      GIM_Try, /*On fail goto*//*Label 107*/ 4167, // Rule ID 767 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLsv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 767,
        GIR_Done,
      // Label 107: @4167
      GIM_Try, /*On fail goto*//*Label 108*/ 4231, // Rule ID 770 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 770,
        GIR_Done,
      // Label 108: @4231
      GIM_Try, /*On fail goto*//*Label 109*/ 4294, // Rule ID 2608 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm), QPR:{ *:[v4i32] }:$src1)  =>  (VMLAv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2608,
        GIR_Done,
      // Label 109: @4294
      GIM_Try, /*On fail goto*//*Label 110*/ 4345, // Rule ID 2580 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm), QPR:{ *:[v4i32] }:$Vn)  =>  (VADDWsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2580,
        GIR_Done,
      // Label 110: @4345
      GIM_Try, /*On fail goto*//*Label 111*/ 4396, // Rule ID 2583 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm), QPR:{ *:[v4i32] }:$Vn)  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2583,
        GIR_Done,
      // Label 111: @4396
      GIM_Try, /*On fail goto*//*Label 112*/ 4459, // Rule ID 878 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VMLAv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 878,
        GIR_Done,
      // Label 112: @4459
      GIM_Try, /*On fail goto*//*Label 113*/ 4510, // Rule ID 773 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDWsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 773,
        GIR_Done,
      // Label 113: @4510
      GIM_Try, /*On fail goto*//*Label 114*/ 4561, // Rule ID 776 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 776,
        GIR_Done,
      // Label 114: @4561
      GIM_Try, /*On fail goto*//*Label 115*/ 4599, // Rule ID 759 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VADDv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 759,
        GIR_Done,
      // Label 115: @4599
      GIM_Reject,
    // Label 98: @4600
    GIM_Reject,
    // Label 40: @4601
    GIM_Try, /*On fail goto*//*Label 116*/ 5060,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 117*/ 4685, // Rule ID 2673 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } (intrinsic_wo_chain:{ *:[v8i8] } 1016:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm), DPR:{ *:[v8i8] }:$src1)  =>  (VABAsv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2673,
        GIR_Done,
      // Label 117: @4685
      GIM_Try, /*On fail goto*//*Label 118*/ 4755, // Rule ID 2679 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } (intrinsic_wo_chain:{ *:[v8i8] } 1017:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm), DPR:{ *:[v8i8] }:$src1)  =>  (VABAuv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2679,
        GIR_Done,
      // Label 118: @4755
      GIM_Try, /*On fail goto*//*Label 119*/ 4825, // Rule ID 1150 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, (intrinsic_wo_chain:{ *:[v8i8] } 1016:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm))  =>  (VABAsv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1150,
        GIR_Done,
      // Label 119: @4825
      GIM_Try, /*On fail goto*//*Label 120*/ 4895, // Rule ID 1156 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, (intrinsic_wo_chain:{ *:[v8i8] } 1017:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm))  =>  (VABAuv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1156,
        GIR_Done,
      // Label 120: @4895
      GIM_Try, /*On fail goto*//*Label 121*/ 4958, // Rule ID 2603 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm), DPR:{ *:[v8i8] }:$src1)  =>  (VMLAv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2603,
        GIR_Done,
      // Label 121: @4958
      GIM_Try, /*On fail goto*//*Label 122*/ 5021, // Rule ID 873 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm))  =>  (VMLAv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 873,
        GIR_Done,
      // Label 122: @5021
      GIM_Try, /*On fail goto*//*Label 123*/ 5059, // Rule ID 754 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (add:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VADDv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 754,
        GIR_Done,
      // Label 123: @5059
      GIM_Reject,
    // Label 116: @5060
    GIM_Reject,
    // Label 41: @5061
    GIM_Try, /*On fail goto*//*Label 124*/ 6184,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 125*/ 5158, // Rule ID 2685 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 1016:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)), QPR:{ *:[v8i16] }:$src1)  =>  (VABALsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2685,
        GIR_Done,
      // Label 125: @5158
      GIM_Try, /*On fail goto*//*Label 126*/ 5241, // Rule ID 2688 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 1017:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)), QPR:{ *:[v8i16] }:$src1)  =>  (VABALuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2688,
        GIR_Done,
      // Label 126: @5241
      GIM_Try, /*On fail goto*//*Label 127*/ 5324, // Rule ID 1162 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 1016:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)))  =>  (VABALsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1162,
        GIR_Done,
      // Label 127: @5324
      GIM_Try, /*On fail goto*//*Label 128*/ 5407, // Rule ID 1165 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 1017:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)))  =>  (VABALuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1165,
        GIR_Done,
      // Label 128: @5407
      GIM_Try, /*On fail goto*//*Label 129*/ 5477, // Rule ID 2677 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 1016:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm), QPR:{ *:[v8i16] }:$src1)  =>  (VABAsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2677,
        GIR_Done,
      // Label 129: @5477
      GIM_Try, /*On fail goto*//*Label 130*/ 5547, // Rule ID 2683 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 1017:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm), QPR:{ *:[v8i16] }:$src1)  =>  (VABAuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2683,
        GIR_Done,
      // Label 130: @5547
      GIM_Try, /*On fail goto*//*Label 131*/ 5617, // Rule ID 1154 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (intrinsic_wo_chain:{ *:[v8i16] } 1016:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VABAsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1154,
        GIR_Done,
      // Label 131: @5617
      GIM_Try, /*On fail goto*//*Label 132*/ 5687, // Rule ID 1160 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (intrinsic_wo_chain:{ *:[v8i16] } 1017:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VABAuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1160,
        GIR_Done,
      // Label 132: @5687
      GIM_Try, /*On fail goto*//*Label 133*/ 5751, // Rule ID 766 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLsv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 766,
        GIR_Done,
      // Label 133: @5751
      GIM_Try, /*On fail goto*//*Label 134*/ 5815, // Rule ID 769 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 769,
        GIR_Done,
      // Label 134: @5815
      GIM_Try, /*On fail goto*//*Label 135*/ 5878, // Rule ID 2607 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm), QPR:{ *:[v8i16] }:$src1)  =>  (VMLAv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2607,
        GIR_Done,
      // Label 135: @5878
      GIM_Try, /*On fail goto*//*Label 136*/ 5929, // Rule ID 2579 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm), QPR:{ *:[v8i16] }:$Vn)  =>  (VADDWsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2579,
        GIR_Done,
      // Label 136: @5929
      GIM_Try, /*On fail goto*//*Label 137*/ 5980, // Rule ID 2582 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm), QPR:{ *:[v8i16] }:$Vn)  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2582,
        GIR_Done,
      // Label 137: @5980
      GIM_Try, /*On fail goto*//*Label 138*/ 6043, // Rule ID 877 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VMLAv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 877,
        GIR_Done,
      // Label 138: @6043
      GIM_Try, /*On fail goto*//*Label 139*/ 6094, // Rule ID 772 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDWsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 772,
        GIR_Done,
      // Label 139: @6094
      GIM_Try, /*On fail goto*//*Label 140*/ 6145, // Rule ID 775 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 775,
        GIR_Done,
      // Label 140: @6145
      GIM_Try, /*On fail goto*//*Label 141*/ 6183, // Rule ID 758 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VADDv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 758,
        GIR_Done,
      // Label 141: @6183
      GIM_Reject,
    // Label 124: @6184
    GIM_Reject,
    // Label 42: @6185
    GIM_Try, /*On fail goto*//*Label 142*/ 6644,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 143*/ 6269, // Rule ID 2676 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (intrinsic_wo_chain:{ *:[v16i8] } 1016:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm), QPR:{ *:[v16i8] }:$src1)  =>  (VABAsv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2676,
        GIR_Done,
      // Label 143: @6269
      GIM_Try, /*On fail goto*//*Label 144*/ 6339, // Rule ID 2682 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (intrinsic_wo_chain:{ *:[v16i8] } 1017:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm), QPR:{ *:[v16i8] }:$src1)  =>  (VABAuv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2682,
        GIR_Done,
      // Label 144: @6339
      GIM_Try, /*On fail goto*//*Label 145*/ 6409, // Rule ID 1153 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, (intrinsic_wo_chain:{ *:[v16i8] } 1016:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm))  =>  (VABAsv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1153,
        GIR_Done,
      // Label 145: @6409
      GIM_Try, /*On fail goto*//*Label 146*/ 6479, // Rule ID 1159 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, (intrinsic_wo_chain:{ *:[v16i8] } 1017:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm))  =>  (VABAuv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1159,
        GIR_Done,
      // Label 146: @6479
      GIM_Try, /*On fail goto*//*Label 147*/ 6542, // Rule ID 2606 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm), QPR:{ *:[v16i8] }:$src1)  =>  (VMLAv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2606,
        GIR_Done,
      // Label 147: @6542
      GIM_Try, /*On fail goto*//*Label 148*/ 6605, // Rule ID 876 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm))  =>  (VMLAv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 876,
        GIR_Done,
      // Label 148: @6605
      GIM_Try, /*On fail goto*//*Label 149*/ 6643, // Rule ID 757 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (add:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VADDv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 757,
        GIR_Done,
      // Label 149: @6643
      GIM_Reject,
    // Label 142: @6644
    GIM_Reject,
    // Label 43: @6645
    GIM_Reject,
    // Label 1: @6646
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 10, /*)*//*default:*//*Label 159*/ 8635,
    /*GILLT_s32*//*Label 150*/ 6661,
    /*GILLT_s64*//*Label 151*/ 7154,
    /*GILLT_v2s32*//*Label 152*/ 7205,
    /*GILLT_v2s64*//*Label 153*/ 7318,
    /*GILLT_v4s16*//*Label 154*/ 7602,
    /*GILLT_v4s32*//*Label 155*/ 7715,
    /*GILLT_v8s8*//*Label 156*/ 8062,
    /*GILLT_v8s16*//*Label 157*/ 8175,
    /*GILLT_v16s8*//*Label 158*/ 8522,
    // Label 150: @6661
    GIM_Try, /*On fail goto*//*Label 160*/ 7153,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 161*/ 6723, // Rule ID 98 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm, GPR:{ *:[i32] }:$Rn)  =>  (RSBri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::RSBri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 98,
        GIR_Done,
      // Label 161: @6723
      GIM_Try, /*On fail goto*//*Label 162*/ 6775, // Rule ID 431 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, rGPR:{ *:[i32] }:$Rn)  =>  (t2RSBri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2RSBri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 431,
        GIR_Done,
      // Label 162: @6775
      GIM_Try, /*On fail goto*//*Label 163*/ 6827, // Rule ID 78 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (SUBri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SUBri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 78,
        GIR_Done,
      // Label 163: @6827
      GIM_Try, /*On fail goto*//*Label 164*/ 6879, // Rule ID 415 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2SUBri:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SUBri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 415,
        GIR_Done,
      // Label 164: @6879
      GIM_Try, /*On fail goto*//*Label 165*/ 6928, // Rule ID 416 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_imm0_4095,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_imm0_4095>>:$imm)  =>  (t2SUBri12:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SUBri12,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 416,
        GIR_Done,
      // Label 165: @6928
      GIM_Try, /*On fail goto*//*Label 166*/ 6995, // Rule ID 175 //
        GIM_CheckFeatures, GIFBS_HasV6T2_IsARM_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm))  =>  (MLS:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MLS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 175,
        GIR_Done,
      // Label 166: @6995
      GIM_Try, /*On fail goto*//*Label 167*/ 7062, // Rule ID 508 //
        GIM_CheckFeatures, GIFBS_IsThumb2_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm))  =>  (t2MLS:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MLS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 508,
        GIR_Done,
      // Label 167: @7062
      GIM_Try, /*On fail goto*//*Label 168*/ 7107, // Rule ID 79 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (SUBrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SUBrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 79,
        GIR_Done,
      // Label 168: @7107
      GIM_Try, /*On fail goto*//*Label 169*/ 7152, // Rule ID 417 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (sub:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SUBrr:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SUBrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 417,
        GIR_Done,
      // Label 169: @7152
      GIM_Reject,
    // Label 160: @7153
    GIM_Reject,
    // Label 151: @7154
    GIM_Try, /*On fail goto*//*Label 170*/ 7204, // Rule ID 947 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (sub:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)  =>  (VSUBv1i64:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv1i64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 947,
      GIR_Done,
    // Label 170: @7204
    GIM_Reject,
    // Label 152: @7205
    GIM_Try, /*On fail goto*//*Label 171*/ 7317,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 172*/ 7282, // Rule ID 903 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VMLSv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLSv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 903,
        GIR_Done,
      // Label 172: @7282
      GIM_Try, /*On fail goto*//*Label 173*/ 7316, // Rule ID 943 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (sub:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VSUBv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 943,
        GIR_Done,
      // Label 173: @7316
      GIM_Reject,
    // Label 171: @7317
    GIM_Reject,
    // Label 153: @7318
    GIM_Try, /*On fail goto*//*Label 174*/ 7601,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 175*/ 7396, // Rule ID 955 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLsv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 955,
        GIR_Done,
      // Label 175: @7396
      GIM_Try, /*On fail goto*//*Label 176*/ 7460, // Rule ID 958 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 958,
        GIR_Done,
      // Label 176: @7460
      GIM_Try, /*On fail goto*//*Label 177*/ 7511, // Rule ID 961 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBWsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBWsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 961,
        GIR_Done,
      // Label 177: @7511
      GIM_Try, /*On fail goto*//*Label 178*/ 7562, // Rule ID 964 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBWuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 964,
        GIR_Done,
      // Label 178: @7562
      GIM_Try, /*On fail goto*//*Label 179*/ 7600, // Rule ID 948 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VSUBv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 948,
        GIR_Done,
      // Label 179: @7600
      GIM_Reject,
    // Label 174: @7601
    GIM_Reject,
    // Label 154: @7602
    GIM_Try, /*On fail goto*//*Label 180*/ 7714,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 181*/ 7679, // Rule ID 902 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VMLSv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLSv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 902,
        GIR_Done,
      // Label 181: @7679
      GIM_Try, /*On fail goto*//*Label 182*/ 7713, // Rule ID 942 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (sub:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VSUBv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 942,
        GIR_Done,
      // Label 182: @7713
      GIM_Reject,
    // Label 180: @7714
    GIM_Reject,
    // Label 155: @7715
    GIM_Try, /*On fail goto*//*Label 183*/ 8061,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 184*/ 7793, // Rule ID 954 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLsv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 954,
        GIR_Done,
      // Label 184: @7793
      GIM_Try, /*On fail goto*//*Label 185*/ 7857, // Rule ID 957 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 957,
        GIR_Done,
      // Label 185: @7857
      GIM_Try, /*On fail goto*//*Label 186*/ 7920, // Rule ID 906 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VMLSv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLSv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 906,
        GIR_Done,
      // Label 186: @7920
      GIM_Try, /*On fail goto*//*Label 187*/ 7971, // Rule ID 960 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBWsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBWsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 960,
        GIR_Done,
      // Label 187: @7971
      GIM_Try, /*On fail goto*//*Label 188*/ 8022, // Rule ID 963 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBWuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 963,
        GIR_Done,
      // Label 188: @8022
      GIM_Try, /*On fail goto*//*Label 189*/ 8060, // Rule ID 946 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VSUBv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 946,
        GIR_Done,
      // Label 189: @8060
      GIM_Reject,
    // Label 183: @8061
    GIM_Reject,
    // Label 156: @8062
    GIM_Try, /*On fail goto*//*Label 190*/ 8174,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 191*/ 8139, // Rule ID 901 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm))  =>  (VMLSv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLSv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 901,
        GIR_Done,
      // Label 191: @8139
      GIM_Try, /*On fail goto*//*Label 192*/ 8173, // Rule ID 941 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (sub:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VSUBv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 941,
        GIR_Done,
      // Label 192: @8173
      GIM_Reject,
    // Label 190: @8174
    GIM_Reject,
    // Label 157: @8175
    GIM_Try, /*On fail goto*//*Label 193*/ 8521,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 194*/ 8253, // Rule ID 953 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLsv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 953,
        GIR_Done,
      // Label 194: @8253
      GIM_Try, /*On fail goto*//*Label 195*/ 8317, // Rule ID 956 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 956,
        GIR_Done,
      // Label 195: @8317
      GIM_Try, /*On fail goto*//*Label 196*/ 8380, // Rule ID 905 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VMLSv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLSv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 905,
        GIR_Done,
      // Label 196: @8380
      GIM_Try, /*On fail goto*//*Label 197*/ 8431, // Rule ID 959 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBWsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBWsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 959,
        GIR_Done,
      // Label 197: @8431
      GIM_Try, /*On fail goto*//*Label 198*/ 8482, // Rule ID 962 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBWuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 962,
        GIR_Done,
      // Label 198: @8482
      GIM_Try, /*On fail goto*//*Label 199*/ 8520, // Rule ID 945 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VSUBv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 945,
        GIR_Done,
      // Label 199: @8520
      GIM_Reject,
    // Label 193: @8521
    GIM_Reject,
    // Label 158: @8522
    GIM_Try, /*On fail goto*//*Label 200*/ 8634,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 201*/ 8599, // Rule ID 904 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm))  =>  (VMLSv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLSv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 904,
        GIR_Done,
      // Label 201: @8599
      GIM_Try, /*On fail goto*//*Label 202*/ 8633, // Rule ID 944 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (sub:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VSUBv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 944,
        GIR_Done,
      // Label 202: @8633
      GIM_Reject,
    // Label 200: @8634
    GIM_Reject,
    // Label 159: @8635
    GIM_Reject,
    // Label 2: @8636
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 10, /*)*//*default:*//*Label 210*/ 9269,
    /*GILLT_s32*//*Label 203*/ 8651, 0,
    /*GILLT_v2s32*//*Label 204*/ 8963, 0,
    /*GILLT_v4s16*//*Label 205*/ 9014,
    /*GILLT_v4s32*//*Label 206*/ 9065,
    /*GILLT_v8s8*//*Label 207*/ 9116,
    /*GILLT_v8s16*//*Label 208*/ 9167,
    /*GILLT_v16s8*//*Label 209*/ 9218,
    // Label 203: @8651
    GIM_Try, /*On fail goto*//*Label 211*/ 8962,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 212*/ 8745, // Rule ID 188 //
        GIM_CheckFeatures, GIFBS_HasV5TE_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i32] } (sra:{ *:[i32] } GPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 16:{ *:[i32] }))  =>  (SMULTT:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SMULTT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 188,
        GIR_Done,
      // Label 212: @8745
      GIM_Try, /*On fail goto*//*Label 213*/ 8829, // Rule ID 519 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] }))  =>  (t2SMULTT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SMULTT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 519,
        GIR_Done,
      // Label 213: @8829
      GIM_Try, /*On fail goto*//*Label 214*/ 8874, // Rule ID 171 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        // (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (MUL:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MUL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 171,
        GIR_Done,
      // Label 214: @8874
      GIM_Try, /*On fail goto*//*Label 215*/ 8919, // Rule ID 172 //
        GIM_CheckFeatures, GIFBS_IsARM_NoV6_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        // (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (MULv5:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MULv5,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 172,
        GIR_Done,
      // Label 215: @8919
      GIM_Try, /*On fail goto*//*Label 216*/ 8961, // Rule ID 506 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2MUL:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MUL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 506,
        GIR_Done,
      // Label 216: @8961
      GIM_Reject,
    // Label 211: @8962
    GIM_Reject,
    // Label 204: @8963
    GIM_Try, /*On fail goto*//*Label 217*/ 9013, // Rule ID 823 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VMULv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULv2i32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 823,
      GIR_Done,
    // Label 217: @9013
    GIM_Reject,
    // Label 205: @9014
    GIM_Try, /*On fail goto*//*Label 218*/ 9064, // Rule ID 822 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VMULv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULv4i16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 822,
      GIR_Done,
    // Label 218: @9064
    GIM_Reject,
    // Label 206: @9065
    GIM_Try, /*On fail goto*//*Label 219*/ 9115, // Rule ID 826 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
      // (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VMULv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULv4i32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 826,
      GIR_Done,
    // Label 219: @9115
    GIM_Reject,
    // Label 207: @9116
    GIM_Try, /*On fail goto*//*Label 220*/ 9166, // Rule ID 821 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VMULv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULv8i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 821,
      GIR_Done,
    // Label 220: @9166
    GIM_Reject,
    // Label 208: @9167
    GIM_Try, /*On fail goto*//*Label 221*/ 9217, // Rule ID 825 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
      // (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VMULv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULv8i16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 825,
      GIR_Done,
    // Label 221: @9217
    GIM_Reject,
    // Label 209: @9218
    GIM_Try, /*On fail goto*//*Label 222*/ 9268, // Rule ID 824 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
      // (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VMULv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 824,
      GIR_Done,
    // Label 222: @9268
    GIM_Reject,
    // Label 210: @9269
    GIM_Reject,
    // Label 3: @9270
    GIM_Try, /*On fail goto*//*Label 223*/ 9369,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 224*/ 9326, // Rule ID 197 //
        GIM_CheckFeatures, GIFBS_HasDivideInARM_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (sdiv:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (SDIV:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SDIV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 197,
        GIR_Done,
      // Label 224: @9326
      GIM_Try, /*On fail goto*//*Label 225*/ 9368, // Rule ID 536 //
        GIM_CheckFeatures, GIFBS_HasDivideInThumb_HasV8MBaseline_IsThumb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (sdiv:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SDIV:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SDIV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 536,
        GIR_Done,
      // Label 225: @9368
      GIM_Reject,
    // Label 223: @9369
    GIM_Reject,
    // Label 4: @9370
    GIM_Try, /*On fail goto*//*Label 226*/ 9469,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 227*/ 9426, // Rule ID 198 //
        GIM_CheckFeatures, GIFBS_HasDivideInARM_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (udiv:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (UDIV:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UDIV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 198,
        GIR_Done,
      // Label 227: @9426
      GIM_Try, /*On fail goto*//*Label 228*/ 9468, // Rule ID 537 //
        GIM_CheckFeatures, GIFBS_HasDivideInThumb_HasV8MBaseline_IsThumb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (udiv:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UDIV:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UDIV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 537,
        GIR_Done,
      // Label 228: @9468
      GIM_Reject,
    // Label 226: @9469
    GIM_Reject,
    // Label 5: @9470
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 7, /*)*//*default:*//*Label 232*/ 11182,
    /*GILLT_s32*//*Label 229*/ 9482, 0,
    /*GILLT_v2s32*//*Label 230*/ 11080, 0, 0,
    /*GILLT_v4s32*//*Label 231*/ 11131,
    // Label 229: @9482
    GIM_Try, /*On fail goto*//*Label 233*/ 11079,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 234*/ 9554, // Rule ID 1707 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 16711935,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$Src, 8:{ *:[i32] }), 16711935:{ *:[i32] })  =>  (UXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Src
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1707,
        GIR_Done,
      // Label 234: @9554
      GIM_Try, /*On fail goto*//*Label 235*/ 9616, // Rule ID 1909 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 16711935,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Src, 8:{ *:[i32] }), 16711935:{ *:[i32] })  =>  (t2UXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Src, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Src
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1909,
        GIR_Done,
      // Label 235: @9616
      GIM_Try, /*On fail goto*//*Label 236*/ 9657, // Rule ID 1810 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 255,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Src, 255:{ *:[i32] })  =>  (UXTB:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Src
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1810,
        GIR_Done,
      // Label 236: @9657
      GIM_Try, /*On fail goto*//*Label 237*/ 9698, // Rule ID 1811 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Src, 65535:{ *:[i32] })  =>  (UXTH:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Src
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1811,
        GIR_Done,
      // Label 237: @9698
      GIM_Try, /*On fail goto*//*Label 238*/ 9739, // Rule ID 1812 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 16711935,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Src, 16711935:{ *:[i32] })  =>  (UXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Src
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1812,
        GIR_Done,
      // Label 238: @9739
      GIM_Try, /*On fail goto*//*Label 239*/ 9780, // Rule ID 1996 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 255,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] })  =>  (t2UXTB:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1996,
        GIR_Done,
      // Label 239: @9780
      GIM_Try, /*On fail goto*//*Label 240*/ 9821, // Rule ID 1997 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] })  =>  (t2UXTH:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1997,
        GIR_Done,
      // Label 240: @9821
      GIM_Try, /*On fail goto*//*Label 241*/ 9862, // Rule ID 1998 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 16711935,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16711935:{ *:[i32] })  =>  (t2UXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1998,
        GIR_Done,
      // Label 241: @9862
      GIM_Try, /*On fail goto*//*Label 242*/ 9935, // Rule ID 2513 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm), GPR:{ *:[i32] }:$Rn)  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2513,
        GIR_Done,
      // Label 242: @9935
      GIM_Try, /*On fail goto*//*Label 243*/ 10008, // Rule ID 2546 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm), rGPR:{ *:[i32] }:$Rn)  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2546,
        GIR_Done,
      // Label 243: @10008
      GIM_Try, /*On fail goto*//*Label 244*/ 10081, // Rule ID 2512 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm, -1:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2512,
        GIR_Done,
      // Label 244: @10081
      GIM_Try, /*On fail goto*//*Label 245*/ 10154, // Rule ID 2545 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2545,
        GIR_Done,
      // Label 245: @10154
      GIM_Try, /*On fail goto*//*Label 246*/ 10227, // Rule ID 2511 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm))  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2511,
        GIR_Done,
      // Label 246: @10227
      GIM_Try, /*On fail goto*//*Label 247*/ 10300, // Rule ID 2544 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm))  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2544,
        GIR_Done,
      // Label 247: @10300
      GIM_Try, /*On fail goto*//*Label 248*/ 10373, // Rule ID 161 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm, -1:{ *:[i32] }))  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 161,
        GIR_Done,
      // Label 248: @10373
      GIM_Try, /*On fail goto*//*Label 249*/ 10446, // Rule ID 494 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }))  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 494,
        GIR_Done,
      // Label 249: @10446
      GIM_Try, /*On fail goto*//*Label 250*/ 10512, // Rule ID 2514 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (BICrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::BICrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2514,
        GIR_Done,
      // Label 250: @10512
      GIM_Try, /*On fail goto*//*Label 251*/ 10578, // Rule ID 2547 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2BICrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2BICrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2547,
        GIR_Done,
      // Label 251: @10578
      GIM_Try, /*On fail goto*//*Label 252*/ 10644, // Rule ID 162 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (BICrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::BICrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 162,
        GIR_Done,
      // Label 252: @10644
      GIM_Try, /*On fail goto*//*Label 253*/ 10710, // Rule ID 495 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (t2BICrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2BICrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 495,
        GIR_Done,
      // Label 253: @10710
      GIM_Try, /*On fail goto*//*Label 254*/ 10748, // Rule ID 351 //
        GIM_CheckFeatures, GIFBS_HasV6_IsThumb_IsThumb1Only,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::tGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::tGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 255,
        // (and:{ *:[i32] } tGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] })  =>  (tUXTB:{ *:[i32] } tGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::tUXTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 351,
        GIR_Done,
      // Label 254: @10748
      GIM_Try, /*On fail goto*//*Label 255*/ 10786, // Rule ID 352 //
        GIM_CheckFeatures, GIFBS_HasV6_IsThumb_IsThumb1Only,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::tGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::tGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        // (and:{ *:[i32] } tGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] })  =>  (tUXTH:{ *:[i32] } tGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::tUXTH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 352,
        GIR_Done,
      // Label 255: @10786
      GIM_Try, /*On fail goto*//*Label 256*/ 10838, // Rule ID 149 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (ANDri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::ANDri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 149,
        GIR_Done,
      // Label 256: @10838
      GIM_Try, /*On fail goto*//*Label 257*/ 10890, // Rule ID 485 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2ANDri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ANDri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 485,
        GIR_Done,
      // Label 257: @10890
      GIM_Try, /*On fail goto*//*Label 258*/ 10939, // Rule ID 165 //
        GIM_CheckFeatures, GIFBS_HasV6T2_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_bf_inv_mask_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_bf_inv_mask_imm>>:$imm)  =>  (BFC:{ *:[i32] } GPR:{ *:[i32] }:$src, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::BFC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 165,
        GIR_Done,
      // Label 258: @10939
      GIM_Try, /*On fail goto*//*Label 259*/ 10988, // Rule ID 497 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_bf_inv_mask_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_bf_inv_mask_imm>>:$imm)  =>  (t2BFC:{ *:[i32] } rGPR:{ *:[i32] }:$src, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2BFC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 497,
        GIR_Done,
      // Label 259: @10988
      GIM_Try, /*On fail goto*//*Label 260*/ 11033, // Rule ID 150 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (ANDrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::ANDrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 150,
        GIR_Done,
      // Label 260: @11033
      GIM_Try, /*On fail goto*//*Label 261*/ 11078, // Rule ID 486 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2ANDrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ANDrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 486,
        GIR_Done,
      // Label 261: @11078
      GIM_Reject,
    // Label 233: @11079
    GIM_Reject,
    // Label 230: @11080
    GIM_Try, /*On fail goto*//*Label 262*/ 11130, // Rule ID 1102 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (and:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VANDd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VANDd,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1102,
      GIR_Done,
    // Label 262: @11130
    GIM_Reject,
    // Label 231: @11131
    GIM_Try, /*On fail goto*//*Label 263*/ 11181, // Rule ID 1103 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
      // (and:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VANDq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VANDq,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1103,
      GIR_Done,
    // Label 263: @11181
    GIM_Reject,
    // Label 232: @11182
    GIM_Reject,
    // Label 6: @11183
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 7, /*)*//*default:*//*Label 267*/ 15365,
    /*GILLT_s32*//*Label 264*/ 11195, 0,
    /*GILLT_v2s32*//*Label 265*/ 15263, 0, 0,
    /*GILLT_v4s32*//*Label 266*/ 15314,
    // Label 264: @11195
    GIM_Try, /*On fail goto*//*Label 268*/ 15262,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 269*/ 11324, // Rule ID 2727 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 24,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }), (sra:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }))  =>  (REVSH:{ *:[i32] } GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::REVSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2727,
        GIR_Done,
      // Label 269: @11324
      GIM_Try, /*On fail goto*//*Label 270*/ 11443, // Rule ID 2760 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 24,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }), (sra:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }))  =>  (t2REVSH:{ *:[i32] } rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2REVSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2760,
        GIR_Done,
      // Label 270: @11443
      GIM_Try, /*On fail goto*//*Label 271*/ 11562, // Rule ID 1743 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 24,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (sra:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }))  =>  (REVSH:{ *:[i32] } GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::REVSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1743,
        GIR_Done,
      // Label 271: @11562
      GIM_Try, /*On fail goto*//*Label 272*/ 11681, // Rule ID 1969 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 24,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (sra:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }))  =>  (t2REVSH:{ *:[i32] } rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2REVSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1969,
        GIR_Done,
      // Label 272: @11681
      GIM_Try, /*On fail goto*//*Label 273*/ 11797, // Rule ID 2527 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_pkh_asr_amt,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2527,
        GIR_Done,
      // Label 273: @11797
      GIM_Try, /*On fail goto*//*Label 274*/ 11913, // Rule ID 2564 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_pkh_asr_amt,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2564,
        GIR_Done,
      // Label 274: @11913
      GIM_Try, /*On fail goto*//*Label 275*/ 12029, // Rule ID 2732 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm1_15,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2732,
        GIR_Done,
      // Label 275: @12029
      GIM_Try, /*On fail goto*//*Label 276*/ 12145, // Rule ID 2765 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm1_15,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2765,
        GIR_Done,
      // Label 276: @12145
      GIM_Try, /*On fail goto*//*Label 277*/ 12261, // Rule ID 2526 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_pkh_lsl_amt,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2526,
        GIR_Done,
      // Label 277: @12261
      GIM_Try, /*On fail goto*//*Label 278*/ 12377, // Rule ID 2563 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_pkh_lsl_amt,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2563,
        GIR_Done,
      // Label 278: @12377
      GIM_Try, /*On fail goto*//*Label 279*/ 12493, // Rule ID 205 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_pkh_asr_amt,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 205,
        GIR_Done,
      // Label 279: @12493
      GIM_Try, /*On fail goto*//*Label 280*/ 12609, // Rule ID 544 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_pkh_asr_amt,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 544,
        GIR_Done,
      // Label 280: @12609
      GIM_Try, /*On fail goto*//*Label 281*/ 12725, // Rule ID 1748 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_imm1_15,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1748,
        GIR_Done,
      // Label 281: @12725
      GIM_Try, /*On fail goto*//*Label 282*/ 12841, // Rule ID 1974 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_imm1_15,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1974,
        GIR_Done,
      // Label 282: @12841
      GIM_Try, /*On fail goto*//*Label 283*/ 12957, // Rule ID 204 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_pkh_lsl_amt,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (and:{ *:[i32] } (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 204,
        GIR_Done,
      // Label 283: @12957
      GIM_Try, /*On fail goto*//*Label 284*/ 13073, // Rule ID 543 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_pkh_lsl_amt,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (and:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 543,
        GIR_Done,
      // Label 284: @13073
      GIM_Try, /*On fail goto*//*Label 285*/ 13160, // Rule ID 1744 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 4294901760:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1744,
        GIR_Done,
      // Label 285: @13160
      GIM_Try, /*On fail goto*//*Label 286*/ 13247, // Rule ID 1970 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src2, 4294901760:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1970,
        GIR_Done,
      // Label 286: @13247
      GIM_Try, /*On fail goto*//*Label 287*/ 13334, // Rule ID 2728 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 4294901760:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2728,
        GIR_Done,
      // Label 287: @13334
      GIM_Try, /*On fail goto*//*Label 288*/ 13421, // Rule ID 2761 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src2, 4294901760:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2761,
        GIR_Done,
      // Label 288: @13421
      GIM_Try, /*On fail goto*//*Label 289*/ 13516, // Rule ID 1747 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1747,
        GIR_Done,
      // Label 289: @13516
      GIM_Try, /*On fail goto*//*Label 290*/ 13611, // Rule ID 1973 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1973,
        GIR_Done,
      // Label 290: @13611
      GIM_Try, /*On fail goto*//*Label 291*/ 13706, // Rule ID 1746 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm16,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1746,
        GIR_Done,
      // Label 291: @13706
      GIM_Try, /*On fail goto*//*Label 292*/ 13801, // Rule ID 1972 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm16,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1972,
        GIR_Done,
      // Label 292: @13801
      GIM_Try, /*On fail goto*//*Label 293*/ 13896, // Rule ID 1745 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1745,
        GIR_Done,
      // Label 293: @13896
      GIM_Try, /*On fail goto*//*Label 294*/ 13991, // Rule ID 1971 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }), (shl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1971,
        GIR_Done,
      // Label 294: @13991
      GIM_Try, /*On fail goto*//*Label 295*/ 14086, // Rule ID 2731 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2731,
        GIR_Done,
      // Label 295: @14086
      GIM_Try, /*On fail goto*//*Label 296*/ 14181, // Rule ID 2764 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2764,
        GIR_Done,
      // Label 296: @14181
      GIM_Try, /*On fail goto*//*Label 297*/ 14276, // Rule ID 2730 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_imm16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2730,
        GIR_Done,
      // Label 297: @14276
      GIM_Try, /*On fail goto*//*Label 298*/ 14371, // Rule ID 2763 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_imm16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2763,
        GIR_Done,
      // Label 298: @14371
      GIM_Try, /*On fail goto*//*Label 299*/ 14466, // Rule ID 2729 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2729,
        GIR_Done,
      // Label 299: @14466
      GIM_Try, /*On fail goto*//*Label 300*/ 14561, // Rule ID 2762 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2762,
        GIR_Done,
      // Label 300: @14561
      GIM_Try, /*On fail goto*//*Label 301*/ 14634, // Rule ID 2551 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm), rGPR:{ *:[i32] }:$Rn)  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORNri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2551,
        GIR_Done,
      // Label 301: @14634
      GIM_Try, /*On fail goto*//*Label 302*/ 14707, // Rule ID 2550 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORNri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2550,
        GIR_Done,
      // Label 302: @14707
      GIM_Try, /*On fail goto*//*Label 303*/ 14780, // Rule ID 2549 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm))  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORNri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2549,
        GIR_Done,
      // Label 303: @14780
      GIM_Try, /*On fail goto*//*Label 304*/ 14853, // Rule ID 500 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }))  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORNri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 500,
        GIR_Done,
      // Label 304: @14853
      GIM_Try, /*On fail goto*//*Label 305*/ 14919, // Rule ID 2552 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2ORNrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORNrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2552,
        GIR_Done,
      // Label 305: @14919
      GIM_Try, /*On fail goto*//*Label 306*/ 14985, // Rule ID 501 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (t2ORNrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORNrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 501,
        GIR_Done,
      // Label 306: @14985
      GIM_Try, /*On fail goto*//*Label 307*/ 15026, // Rule ID 1702 //
        GIM_CheckFeatures, GIFBS_HasV6T2_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 4294901760,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$src, 4294901760:{ *:[i32] })  =>  (MOVTi16:{ *:[i32] } GPR:{ *:[i32] }:$src, 65535:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MOVTi16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm, /*InsnID*/0, /*Imm*/65535,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1702,
        GIR_Done,
      // Label 307: @15026
      GIM_Try, /*On fail goto*//*Label 308*/ 15067, // Rule ID 1894 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 4294901760,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$src, 4294901760:{ *:[i32] })  =>  (t2MOVTi16:{ *:[i32] } rGPR:{ *:[i32] }:$src, 65535:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MOVTi16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm, /*InsnID*/0, /*Imm*/65535,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1894,
        GIR_Done,
      // Label 308: @15067
      GIM_Try, /*On fail goto*//*Label 309*/ 15119, // Rule ID 153 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (ORRri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::ORRri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 153,
        GIR_Done,
      // Label 309: @15119
      GIM_Try, /*On fail goto*//*Label 310*/ 15171, // Rule ID 488 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2ORRri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORRri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 488,
        GIR_Done,
      // Label 310: @15171
      GIM_Try, /*On fail goto*//*Label 311*/ 15216, // Rule ID 154 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (ORRrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::ORRrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 154,
        GIR_Done,
      // Label 311: @15216
      GIM_Try, /*On fail goto*//*Label 312*/ 15261, // Rule ID 489 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2ORRrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORRrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 489,
        GIR_Done,
      // Label 312: @15261
      GIM_Reject,
    // Label 268: @15262
    GIM_Reject,
    // Label 265: @15263
    GIM_Try, /*On fail goto*//*Label 313*/ 15313, // Rule ID 1106 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (or:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VORRd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VORRd,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1106,
      GIR_Done,
    // Label 313: @15313
    GIM_Reject,
    // Label 266: @15314
    GIM_Try, /*On fail goto*//*Label 314*/ 15364, // Rule ID 1107 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
      // (or:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VORRq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VORRq,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1107,
      GIR_Done,
    // Label 314: @15364
    GIM_Reject,
    // Label 267: @15365
    GIM_Reject,
    // Label 7: @15366
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 7, /*)*//*default:*//*Label 318*/ 15864,
    /*GILLT_s32*//*Label 315*/ 15378, 0,
    /*GILLT_v2s32*//*Label 316*/ 15762, 0, 0,
    /*GILLT_v4s32*//*Label 317*/ 15813,
    // Label 315: @15378
    GIM_Try, /*On fail goto*//*Label 319*/ 15761,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 320*/ 15436, // Rule ID 2554 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, -1,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2MVNi:{ *:[i32] } (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MVNi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2554,
        GIR_Done,
      // Label 320: @15436
      GIM_Try, /*On fail goto*//*Label 321*/ 15484, // Rule ID 503 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] })  =>  (t2MVNi:{ *:[i32] } (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MVNi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 503,
        GIR_Done,
      // Label 321: @15484
      GIM_Try, /*On fail goto*//*Label 322*/ 15525, // Rule ID 504 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] })  =>  (t2MVNr:{ *:[i32] } rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MVNr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 504,
        GIR_Done,
      // Label 322: @15525
      GIM_Try, /*On fail goto*//*Label 323*/ 15566, // Rule ID 167 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rm, -1:{ *:[i32] })  =>  (MVNr:{ *:[i32] } GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVNr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 167,
        GIR_Done,
      // Label 323: @15566
      GIM_Try, /*On fail goto*//*Label 324*/ 15618, // Rule ID 157 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (EORri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::EORri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 157,
        GIR_Done,
      // Label 324: @15618
      GIM_Try, /*On fail goto*//*Label 325*/ 15670, // Rule ID 491 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2EORri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2EORri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 491,
        GIR_Done,
      // Label 325: @15670
      GIM_Try, /*On fail goto*//*Label 326*/ 15715, // Rule ID 158 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (EORrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::EORrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 158,
        GIR_Done,
      // Label 326: @15715
      GIM_Try, /*On fail goto*//*Label 327*/ 15760, // Rule ID 492 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2EORrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2EORrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 492,
        GIR_Done,
      // Label 327: @15760
      GIM_Reject,
    // Label 319: @15761
    GIM_Reject,
    // Label 316: @15762
    GIM_Try, /*On fail goto*//*Label 328*/ 15812, // Rule ID 1104 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (xor:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VEORd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VEORd,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1104,
      GIR_Done,
    // Label 328: @15812
    GIM_Reject,
    // Label 317: @15813
    GIM_Try, /*On fail goto*//*Label 329*/ 15863, // Rule ID 1105 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
      // (xor:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VEORq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VEORq,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1105,
      GIR_Done,
    // Label 329: @15863
    GIM_Reject,
    // Label 318: @15864
    GIM_Reject,
    // Label 8: @15865
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 10, /*)*//*default:*//*Label 339*/ 20252,
    /*GILLT_s32*//*Label 330*/ 15880,
    /*GILLT_s64*//*Label 331*/ 15956,
    /*GILLT_v2s32*//*Label 332*/ 16669,
    /*GILLT_v2s64*//*Label 333*/ 17310,
    /*GILLT_v4s16*//*Label 334*/ 18023,
    /*GILLT_v4s32*//*Label 335*/ 18418,
    /*GILLT_v8s8*//*Label 336*/ 19097,
    /*GILLT_v8s16*//*Label 337*/ 19458,
    /*GILLT_v16s8*//*Label 338*/ 19891,
    // Label 330: @15880
    GIM_Try, /*On fail goto*//*Label 340*/ 15955,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 341*/ 15920, // Rule ID 686 //
        GIM_CheckFeatures, GIFBS_HasVFP2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::SPRRegClassID,
        // (bitconvert:{ *:[i32] } SPR:{ *:[f32] }:$Sn)  =>  (VMOVRS:{ *:[i32] } SPR:{ *:[f32] }:$Sn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMOVRS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Sn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 686,
        GIR_Done,
      // Label 341: @15920
      GIM_Try, /*On fail goto*//*Label 342*/ 15954, // Rule ID 687 //
        GIM_CheckFeatures, GIFBS_HasVFP2_UseVMOVSR,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::SPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        // (bitconvert:{ *:[f32] } GPR:{ *:[i32] }:$Rt)  =>  (VMOVSR:{ *:[f32] } GPR:{ *:[i32] }:$Rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMOVSR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Sn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rt
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 687,
        GIR_Done,
      // Label 342: @15954
      GIM_Reject,
    // Label 340: @15955
    GIM_Reject,
    // Label 331: @15956
    GIM_Try, /*On fail goto*//*Label 343*/ 15990, // Rule ID 2321 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2321,
      GIR_Done,
    // Label 343: @15990
    GIM_Try, /*On fail goto*//*Label 344*/ 16024, // Rule ID 2322 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2322,
      GIR_Done,
    // Label 344: @16024
    GIM_Try, /*On fail goto*//*Label 345*/ 16058, // Rule ID 2323 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2323,
      GIR_Done,
    // Label 345: @16058
    GIM_Try, /*On fail goto*//*Label 346*/ 16090, // Rule ID 2324 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2324,
      GIR_Done,
    // Label 346: @16090
    GIM_Try, /*On fail goto*//*Label 347*/ 16124, // Rule ID 2325 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2325,
      GIR_Done,
    // Label 347: @16124
    GIM_Try, /*On fail goto*//*Label 348*/ 16156, // Rule ID 2341 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2341,
      GIR_Done,
    // Label 348: @16156
    GIM_Try, /*On fail goto*//*Label 349*/ 16190, // Rule ID 2342 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2342,
      GIR_Done,
    // Label 349: @16190
    GIM_Try, /*On fail goto*//*Label 350*/ 16224, // Rule ID 2343 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2343,
      GIR_Done,
    // Label 350: @16224
    GIM_Try, /*On fail goto*//*Label 351*/ 16258, // Rule ID 2344 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2344,
      GIR_Done,
    // Label 351: @16258
    GIM_Try, /*On fail goto*//*Label 352*/ 16292, // Rule ID 2345 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2345,
      GIR_Done,
    // Label 352: @16292
    GIM_Try, /*On fail goto*//*Label 353*/ 16326, // Rule ID 2346 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2346,
      GIR_Done,
    // Label 353: @16326
    GIM_Try, /*On fail goto*//*Label 354*/ 16364, // Rule ID 2385 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2i32] }:$src)  =>  (VREV64d32:{ *:[v1i64] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2385,
      GIR_Done,
    // Label 354: @16364
    GIM_Try, /*On fail goto*//*Label 355*/ 16402, // Rule ID 2386 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4i16] }:$src)  =>  (VREV64d16:{ *:[v1i64] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2386,
      GIR_Done,
    // Label 355: @16402
    GIM_Try, /*On fail goto*//*Label 356*/ 16440, // Rule ID 2387 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v8i8] }:$src)  =>  (VREV64d8:{ *:[v1i64] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2387,
      GIR_Done,
    // Label 356: @16440
    GIM_Try, /*On fail goto*//*Label 357*/ 16478, // Rule ID 2388 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2f32] }:$src)  =>  (VREV64d32:{ *:[v1i64] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2388,
      GIR_Done,
    // Label 357: @16478
    GIM_Try, /*On fail goto*//*Label 358*/ 16516, // Rule ID 2403 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2i32] }:$src)  =>  (VREV64d32:{ *:[f64] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2403,
      GIR_Done,
    // Label 358: @16516
    GIM_Try, /*On fail goto*//*Label 359*/ 16554, // Rule ID 2404 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4f16] }:$src)  =>  (VREV64d16:{ *:[f64] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2404,
      GIR_Done,
    // Label 359: @16554
    GIM_Try, /*On fail goto*//*Label 360*/ 16592, // Rule ID 2405 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4i16] }:$src)  =>  (VREV64d16:{ *:[f64] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2405,
      GIR_Done,
    // Label 360: @16592
    GIM_Try, /*On fail goto*//*Label 361*/ 16630, // Rule ID 2406 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v8i8] }:$src)  =>  (VREV64d8:{ *:[f64] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2406,
      GIR_Done,
    // Label 361: @16630
    GIM_Try, /*On fail goto*//*Label 362*/ 16668, // Rule ID 2407 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2f32] }:$src)  =>  (VREV64d32:{ *:[f64] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2407,
      GIR_Done,
    // Label 362: @16668
    GIM_Reject,
    // Label 332: @16669
    GIM_Try, /*On fail goto*//*Label 363*/ 16703, // Rule ID 2326 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2326,
      GIR_Done,
    // Label 363: @16703
    GIM_Try, /*On fail goto*//*Label 364*/ 16737, // Rule ID 2327 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2327,
      GIR_Done,
    // Label 364: @16737
    GIM_Try, /*On fail goto*//*Label 365*/ 16771, // Rule ID 2328 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2328,
      GIR_Done,
    // Label 365: @16771
    GIM_Try, /*On fail goto*//*Label 366*/ 16805, // Rule ID 2329 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2329,
      GIR_Done,
    // Label 366: @16805
    GIM_Try, /*On fail goto*//*Label 367*/ 16837, // Rule ID 2330 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2330,
      GIR_Done,
    // Label 367: @16837
    GIM_Try, /*On fail goto*//*Label 368*/ 16871, // Rule ID 2347 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2347,
      GIR_Done,
    // Label 368: @16871
    GIM_Try, /*On fail goto*//*Label 369*/ 16905, // Rule ID 2349 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2349,
      GIR_Done,
    // Label 369: @16905
    GIM_Try, /*On fail goto*//*Label 370*/ 16937, // Rule ID 2350 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2350,
      GIR_Done,
    // Label 370: @16937
    GIM_Try, /*On fail goto*//*Label 371*/ 16971, // Rule ID 2351 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2351,
      GIR_Done,
    // Label 371: @16971
    GIM_Try, /*On fail goto*//*Label 372*/ 17005, // Rule ID 2352 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2352,
      GIR_Done,
    // Label 372: @17005
    GIM_Try, /*On fail goto*//*Label 373*/ 17043, // Rule ID 2389 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d32:{ *:[v2i32] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2389,
      GIR_Done,
    // Label 373: @17043
    GIM_Try, /*On fail goto*//*Label 374*/ 17081, // Rule ID 2390 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4i16] }:$src)  =>  (VREV32d16:{ *:[v2i32] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2390,
      GIR_Done,
    // Label 374: @17081
    GIM_Try, /*On fail goto*//*Label 375*/ 17119, // Rule ID 2391 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v8i8] }:$src)  =>  (VREV32d8:{ *:[v2i32] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2391,
      GIR_Done,
    // Label 375: @17119
    GIM_Try, /*On fail goto*//*Label 376*/ 17157, // Rule ID 2392 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[f64] }:$src)  =>  (VREV64d32:{ *:[v2i32] } DPR:{ *:[f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2392,
      GIR_Done,
    // Label 376: @17157
    GIM_Try, /*On fail goto*//*Label 377*/ 17195, // Rule ID 2408 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[f64] }:$src)  =>  (VREV64d32:{ *:[v2f32] } DPR:{ *:[f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2408,
      GIR_Done,
    // Label 377: @17195
    GIM_Try, /*On fail goto*//*Label 378*/ 17233, // Rule ID 2409 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d32:{ *:[v2f32] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2409,
      GIR_Done,
    // Label 378: @17233
    GIM_Try, /*On fail goto*//*Label 379*/ 17271, // Rule ID 2410 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4i16] }:$src)  =>  (VREV32d16:{ *:[v2f32] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2410,
      GIR_Done,
    // Label 379: @17271
    GIM_Try, /*On fail goto*//*Label 380*/ 17309, // Rule ID 2411 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v8i8] }:$src)  =>  (VREV32d8:{ *:[v2f32] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2411,
      GIR_Done,
    // Label 380: @17309
    GIM_Reject,
    // Label 333: @17310
    GIM_Try, /*On fail goto*//*Label 381*/ 17344, // Rule ID 2353 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2353,
      GIR_Done,
    // Label 381: @17344
    GIM_Try, /*On fail goto*//*Label 382*/ 17378, // Rule ID 2354 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2354,
      GIR_Done,
    // Label 382: @17378
    GIM_Try, /*On fail goto*//*Label 383*/ 17412, // Rule ID 2355 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2355,
      GIR_Done,
    // Label 383: @17412
    GIM_Try, /*On fail goto*//*Label 384*/ 17444, // Rule ID 2356 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2356,
      GIR_Done,
    // Label 384: @17444
    GIM_Try, /*On fail goto*//*Label 385*/ 17478, // Rule ID 2357 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2357,
      GIR_Done,
    // Label 385: @17478
    GIM_Try, /*On fail goto*//*Label 386*/ 17510, // Rule ID 2379 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2379,
      GIR_Done,
    // Label 386: @17510
    GIM_Try, /*On fail goto*//*Label 387*/ 17544, // Rule ID 2380 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2380,
      GIR_Done,
    // Label 387: @17544
    GIM_Try, /*On fail goto*//*Label 388*/ 17578, // Rule ID 2381 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2381,
      GIR_Done,
    // Label 388: @17578
    GIM_Try, /*On fail goto*//*Label 389*/ 17612, // Rule ID 2382 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2382,
      GIR_Done,
    // Label 389: @17612
    GIM_Try, /*On fail goto*//*Label 390*/ 17646, // Rule ID 2383 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2383,
      GIR_Done,
    // Label 390: @17646
    GIM_Try, /*On fail goto*//*Label 391*/ 17680, // Rule ID 2384 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2384,
      GIR_Done,
    // Label 391: @17680
    GIM_Try, /*On fail goto*//*Label 392*/ 17718, // Rule ID 2412 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4i32] }:$src)  =>  (VREV64q32:{ *:[v2i64] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2412,
      GIR_Done,
    // Label 392: @17718
    GIM_Try, /*On fail goto*//*Label 393*/ 17756, // Rule ID 2413 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8i16] }:$src)  =>  (VREV64q16:{ *:[v2i64] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2413,
      GIR_Done,
    // Label 393: @17756
    GIM_Try, /*On fail goto*//*Label 394*/ 17794, // Rule ID 2414 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v16i8] }:$src)  =>  (VREV64q8:{ *:[v2i64] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2414,
      GIR_Done,
    // Label 394: @17794
    GIM_Try, /*On fail goto*//*Label 395*/ 17832, // Rule ID 2415 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4f32] }:$src)  =>  (VREV64q32:{ *:[v2i64] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2415,
      GIR_Done,
    // Label 395: @17832
    GIM_Try, /*On fail goto*//*Label 396*/ 17870, // Rule ID 2436 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4i32] }:$src)  =>  (VREV64q32:{ *:[v2f64] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2436,
      GIR_Done,
    // Label 396: @17870
    GIM_Try, /*On fail goto*//*Label 397*/ 17908, // Rule ID 2437 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8i16] }:$src)  =>  (VREV64q16:{ *:[v2f64] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2437,
      GIR_Done,
    // Label 397: @17908
    GIM_Try, /*On fail goto*//*Label 398*/ 17946, // Rule ID 2438 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8f16] }:$src)  =>  (VREV64q16:{ *:[v2f64] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2438,
      GIR_Done,
    // Label 398: @17946
    GIM_Try, /*On fail goto*//*Label 399*/ 17984, // Rule ID 2439 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v16i8] }:$src)  =>  (VREV64q8:{ *:[v2f64] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2439,
      GIR_Done,
    // Label 399: @17984
    GIM_Try, /*On fail goto*//*Label 400*/ 18022, // Rule ID 2440 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4f32] }:$src)  =>  (VREV64q32:{ *:[v2f64] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2440,
      GIR_Done,
    // Label 400: @18022
    GIM_Reject,
    // Label 334: @18023
    GIM_Try, /*On fail goto*//*Label 401*/ 18057, // Rule ID 2331 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2331,
      GIR_Done,
    // Label 401: @18057
    GIM_Try, /*On fail goto*//*Label 402*/ 18091, // Rule ID 2332 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2332,
      GIR_Done,
    // Label 402: @18091
    GIM_Try, /*On fail goto*//*Label 403*/ 18125, // Rule ID 2333 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2333,
      GIR_Done,
    // Label 403: @18125
    GIM_Try, /*On fail goto*//*Label 404*/ 18159, // Rule ID 2334 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2334,
      GIR_Done,
    // Label 404: @18159
    GIM_Try, /*On fail goto*//*Label 405*/ 18193, // Rule ID 2335 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2335,
      GIR_Done,
    // Label 405: @18193
    GIM_Try, /*On fail goto*//*Label 406*/ 18227, // Rule ID 2348 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2348,
      GIR_Done,
    // Label 406: @18227
    GIM_Try, /*On fail goto*//*Label 407*/ 18265, // Rule ID 2393 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d16:{ *:[v4i16] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2393,
      GIR_Done,
    // Label 407: @18265
    GIM_Try, /*On fail goto*//*Label 408*/ 18303, // Rule ID 2394 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2i32] }:$src)  =>  (VREV32d16:{ *:[v4i16] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2394,
      GIR_Done,
    // Label 408: @18303
    GIM_Try, /*On fail goto*//*Label 409*/ 18341, // Rule ID 2395 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v8i8] }:$src)  =>  (VREV16d8:{ *:[v4i16] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2395,
      GIR_Done,
    // Label 409: @18341
    GIM_Try, /*On fail goto*//*Label 410*/ 18379, // Rule ID 2396 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[f64] }:$src)  =>  (VREV64d16:{ *:[v4i16] } DPR:{ *:[f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2396,
      GIR_Done,
    // Label 410: @18379
    GIM_Try, /*On fail goto*//*Label 411*/ 18417, // Rule ID 2397 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2f32] }:$src)  =>  (VREV32d16:{ *:[v4i16] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2397,
      GIR_Done,
    // Label 411: @18417
    GIM_Reject,
    // Label 335: @18418
    GIM_Try, /*On fail goto*//*Label 412*/ 18452, // Rule ID 2358 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2358,
      GIR_Done,
    // Label 412: @18452
    GIM_Try, /*On fail goto*//*Label 413*/ 18486, // Rule ID 2359 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2359,
      GIR_Done,
    // Label 413: @18486
    GIM_Try, /*On fail goto*//*Label 414*/ 18520, // Rule ID 2360 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2360,
      GIR_Done,
    // Label 414: @18520
    GIM_Try, /*On fail goto*//*Label 415*/ 18554, // Rule ID 2361 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2361,
      GIR_Done,
    // Label 415: @18554
    GIM_Try, /*On fail goto*//*Label 416*/ 18586, // Rule ID 2362 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2362,
      GIR_Done,
    // Label 416: @18586
    GIM_Try, /*On fail goto*//*Label 417*/ 18620, // Rule ID 2374 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2374,
      GIR_Done,
    // Label 417: @18620
    GIM_Try, /*On fail goto*//*Label 418*/ 18652, // Rule ID 2375 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2375,
      GIR_Done,
    // Label 418: @18652
    GIM_Try, /*On fail goto*//*Label 419*/ 18686, // Rule ID 2376 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2376,
      GIR_Done,
    // Label 419: @18686
    GIM_Try, /*On fail goto*//*Label 420*/ 18720, // Rule ID 2377 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2377,
      GIR_Done,
    // Label 420: @18720
    GIM_Try, /*On fail goto*//*Label 421*/ 18754, // Rule ID 2378 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2378,
      GIR_Done,
    // Label 421: @18754
    GIM_Try, /*On fail goto*//*Label 422*/ 18792, // Rule ID 2416 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q32:{ *:[v4i32] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2416,
      GIR_Done,
    // Label 422: @18792
    GIM_Try, /*On fail goto*//*Label 423*/ 18830, // Rule ID 2417 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8i16] }:$src)  =>  (VREV32q16:{ *:[v4i32] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2417,
      GIR_Done,
    // Label 423: @18830
    GIM_Try, /*On fail goto*//*Label 424*/ 18868, // Rule ID 2418 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v16i8] }:$src)  =>  (VREV32q8:{ *:[v4i32] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2418,
      GIR_Done,
    // Label 424: @18868
    GIM_Try, /*On fail goto*//*Label 425*/ 18906, // Rule ID 2419 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q32:{ *:[v4i32] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2419,
      GIR_Done,
    // Label 425: @18906
    GIM_Try, /*On fail goto*//*Label 426*/ 18944, // Rule ID 2431 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q32:{ *:[v4f32] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2431,
      GIR_Done,
    // Label 426: @18944
    GIM_Try, /*On fail goto*//*Label 427*/ 18982, // Rule ID 2432 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8i16] }:$src)  =>  (VREV32q16:{ *:[v4f32] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2432,
      GIR_Done,
    // Label 427: @18982
    GIM_Try, /*On fail goto*//*Label 428*/ 19020, // Rule ID 2433 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8f16] }:$src)  =>  (VREV32q16:{ *:[v4f32] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2433,
      GIR_Done,
    // Label 428: @19020
    GIM_Try, /*On fail goto*//*Label 429*/ 19058, // Rule ID 2434 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v16i8] }:$src)  =>  (VREV32q8:{ *:[v4f32] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2434,
      GIR_Done,
    // Label 429: @19058
    GIM_Try, /*On fail goto*//*Label 430*/ 19096, // Rule ID 2435 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q32:{ *:[v4f32] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2435,
      GIR_Done,
    // Label 430: @19096
    GIM_Reject,
    // Label 336: @19097
    GIM_Try, /*On fail goto*//*Label 431*/ 19131, // Rule ID 2336 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2336,
      GIR_Done,
    // Label 431: @19131
    GIM_Try, /*On fail goto*//*Label 432*/ 19165, // Rule ID 2337 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2337,
      GIR_Done,
    // Label 432: @19165
    GIM_Try, /*On fail goto*//*Label 433*/ 19199, // Rule ID 2338 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2338,
      GIR_Done,
    // Label 433: @19199
    GIM_Try, /*On fail goto*//*Label 434*/ 19233, // Rule ID 2339 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2339,
      GIR_Done,
    // Label 434: @19233
    GIM_Try, /*On fail goto*//*Label 435*/ 19267, // Rule ID 2340 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/18,
      // GIR_Coverage, 2340,
      GIR_Done,
    // Label 435: @19267
    GIM_Try, /*On fail goto*//*Label 436*/ 19305, // Rule ID 2398 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d8:{ *:[v8i8] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2398,
      GIR_Done,
    // Label 436: @19305
    GIM_Try, /*On fail goto*//*Label 437*/ 19343, // Rule ID 2399 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2i32] }:$src)  =>  (VREV32d8:{ *:[v8i8] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2399,
      GIR_Done,
    // Label 437: @19343
    GIM_Try, /*On fail goto*//*Label 438*/ 19381, // Rule ID 2400 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4i16] }:$src)  =>  (VREV16d8:{ *:[v8i8] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2400,
      GIR_Done,
    // Label 438: @19381
    GIM_Try, /*On fail goto*//*Label 439*/ 19419, // Rule ID 2401 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[f64] }:$src)  =>  (VREV64d8:{ *:[v8i8] } DPR:{ *:[f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2401,
      GIR_Done,
    // Label 439: @19419
    GIM_Try, /*On fail goto*//*Label 440*/ 19457, // Rule ID 2402 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2f32] }:$src)  =>  (VREV32d8:{ *:[v8i8] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2402,
      GIR_Done,
    // Label 440: @19457
    GIM_Reject,
    // Label 337: @19458
    GIM_Try, /*On fail goto*//*Label 441*/ 19492, // Rule ID 2363 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2363,
      GIR_Done,
    // Label 441: @19492
    GIM_Try, /*On fail goto*//*Label 442*/ 19526, // Rule ID 2364 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2364,
      GIR_Done,
    // Label 442: @19526
    GIM_Try, /*On fail goto*//*Label 443*/ 19560, // Rule ID 2365 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2365,
      GIR_Done,
    // Label 443: @19560
    GIM_Try, /*On fail goto*//*Label 444*/ 19594, // Rule ID 2366 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2366,
      GIR_Done,
    // Label 444: @19594
    GIM_Try, /*On fail goto*//*Label 445*/ 19628, // Rule ID 2367 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2367,
      GIR_Done,
    // Label 445: @19628
    GIM_Try, /*On fail goto*//*Label 446*/ 19662, // Rule ID 2368 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2368,
      GIR_Done,
    // Label 446: @19662
    GIM_Try, /*On fail goto*//*Label 447*/ 19700, // Rule ID 2420 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q16:{ *:[v8i16] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2420,
      GIR_Done,
    // Label 447: @19700
    GIM_Try, /*On fail goto*//*Label 448*/ 19738, // Rule ID 2421 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4i32] }:$src)  =>  (VREV32q16:{ *:[v8i16] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2421,
      GIR_Done,
    // Label 448: @19738
    GIM_Try, /*On fail goto*//*Label 449*/ 19776, // Rule ID 2422 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v16i8] }:$src)  =>  (VREV16q8:{ *:[v8i16] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2422,
      GIR_Done,
    // Label 449: @19776
    GIM_Try, /*On fail goto*//*Label 450*/ 19814, // Rule ID 2423 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q16:{ *:[v8i16] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2423,
      GIR_Done,
    // Label 450: @19814
    GIM_Try, /*On fail goto*//*Label 451*/ 19852, // Rule ID 2424 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q16:{ *:[v8f16] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2424,
      GIR_Done,
    // Label 451: @19852
    GIM_Try, /*On fail goto*//*Label 452*/ 19890, // Rule ID 2425 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4f32] }:$src)  =>  (VREV32q16:{ *:[v8i16] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2425,
      GIR_Done,
    // Label 452: @19890
    GIM_Reject,
    // Label 338: @19891
    GIM_Try, /*On fail goto*//*Label 453*/ 19925, // Rule ID 2369 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2369,
      GIR_Done,
    // Label 453: @19925
    GIM_Try, /*On fail goto*//*Label 454*/ 19959, // Rule ID 2370 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2370,
      GIR_Done,
    // Label 454: @19959
    GIM_Try, /*On fail goto*//*Label 455*/ 19993, // Rule ID 2371 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2371,
      GIR_Done,
    // Label 455: @19993
    GIM_Try, /*On fail goto*//*Label 456*/ 20027, // Rule ID 2372 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2372,
      GIR_Done,
    // Label 456: @20027
    GIM_Try, /*On fail goto*//*Label 457*/ 20061, // Rule ID 2373 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/36,
      // GIR_Coverage, 2373,
      GIR_Done,
    // Label 457: @20061
    GIM_Try, /*On fail goto*//*Label 458*/ 20099, // Rule ID 2426 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q8:{ *:[v16i8] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2426,
      GIR_Done,
    // Label 458: @20099
    GIM_Try, /*On fail goto*//*Label 459*/ 20137, // Rule ID 2427 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4i32] }:$src)  =>  (VREV32q8:{ *:[v16i8] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2427,
      GIR_Done,
    // Label 459: @20137
    GIM_Try, /*On fail goto*//*Label 460*/ 20175, // Rule ID 2428 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8i16] }:$src)  =>  (VREV16q8:{ *:[v16i8] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2428,
      GIR_Done,
    // Label 460: @20175
    GIM_Try, /*On fail goto*//*Label 461*/ 20213, // Rule ID 2429 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q8:{ *:[v16i8] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2429,
      GIR_Done,
    // Label 461: @20213
    GIM_Try, /*On fail goto*//*Label 462*/ 20251, // Rule ID 2430 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4f32] }:$src)  =>  (VREV32q8:{ *:[v16i8] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2430,
      GIR_Done,
    // Label 462: @20251
    GIM_Reject,
    // Label 339: @20252
    GIM_Reject,
    // Label 9: @20253
    GIM_Try, /*On fail goto*//*Label 463*/ 25477,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 464*/ 20307, // Rule ID 1708 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uxtb16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1217:{ *:[iPTR] }, GPR:{ *:[i32] }:$Src)  =>  (UXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Src
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1708,
        GIR_Done,
      // Label 464: @20307
      GIM_Try, /*On fail goto*//*Label 465*/ 20356, // Rule ID 1908 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uxtb16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1217:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rm)  =>  (t2UXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1908,
        GIR_Done,
      // Label 465: @20356
      GIM_Try, /*On fail goto*//*Label 466*/ 20396, // Rule ID 678 //
        GIM_CheckFeatures, GIFBS_HasFPARMv8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::SPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::SPRRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 1103:{ *:[iPTR] }, SPR:{ *:[f32] }:$Sm)  =>  (VRINTNS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTNS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Sd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Sm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 678,
        GIR_Done,
      // Label 466: @20396
      GIM_Try, /*On fail goto*//*Label 467*/ 20436, // Rule ID 679 //
        GIM_CheckFeatures, GIFBS_HasDPVFP_HasFPARMv8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 1103:{ *:[iPTR] }, DPR:{ *:[f64] }:$Dm)  =>  (VRINTND:{ *:[f64] } DPR:{ *:[f64] }:$Dm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTND,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Dd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 679,
        GIR_Done,
      // Label 467: @20436
      GIM_Try, /*On fail goto*//*Label 468*/ 20482, // Rule ID 692 //
        GIM_CheckFeatures, GIFBS_HasDPVFP_HasVFP2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_vcvtr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::SPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 1218:{ *:[iPTR] }, DPR:{ *:[f64] }:$Dm)  =>  (VTOSIRD:{ *:[f32] } DPR:{ *:[f64] }:$Dm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VTOSIRD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Sd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 692,
        GIR_Done,
      // Label 468: @20482
      GIM_Try, /*On fail goto*//*Label 469*/ 20528, // Rule ID 693 //
        GIM_CheckFeatures, GIFBS_DontUseNEONForFP_HasVFP2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_vcvtr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::SPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::SPRRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 1218:{ *:[iPTR] }, SPR:{ *:[f32] }:$Sm)  =>  (VTOSIRS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VTOSIRS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Sd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Sm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 693,
        GIR_Done,
      // Label 469: @20528
      GIM_Try, /*On fail goto*//*Label 470*/ 20574, // Rule ID 694 //
        GIM_CheckFeatures, GIFBS_HasDPVFP_HasVFP2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_vcvtru,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::SPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 1219:{ *:[iPTR] }, DPR:{ *:[f64] }:$Dm)  =>  (VTOUIRD:{ *:[f32] } DPR:{ *:[f64] }:$Dm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VTOUIRD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Sd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 694,
        GIR_Done,
      // Label 470: @20574
      GIM_Try, /*On fail goto*//*Label 471*/ 20620, // Rule ID 695 //
        GIM_CheckFeatures, GIFBS_DontUseNEONForFP_HasVFP2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_vcvtru,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::SPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::SPRRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 1219:{ *:[iPTR] }, SPR:{ *:[f32] }:$Sm)  =>  (VTOUIRS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VTOUIRS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Sd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Sm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 695,
        GIR_Done,
      // Label 471: @20620
      GIM_Try, /*On fail goto*//*Label 472*/ 20666, // Rule ID 1213 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1067:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VPADDLsv8i8:{ *:[v4i16] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1213,
        GIR_Done,
      // Label 472: @20666
      GIM_Try, /*On fail goto*//*Label 473*/ 20712, // Rule ID 1214 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1067:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VPADDLsv4i16:{ *:[v2i32] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1214,
        GIR_Done,
      // Label 473: @20712
      GIM_Try, /*On fail goto*//*Label 474*/ 20758, // Rule ID 1215 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i64] } 1067:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VPADDLsv2i32:{ *:[v1i64] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1215,
        GIR_Done,
      // Label 474: @20758
      GIM_Try, /*On fail goto*//*Label 475*/ 20804, // Rule ID 1216 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1067:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VPADDLsv16i8:{ *:[v8i16] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLsv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1216,
        GIR_Done,
      // Label 475: @20804
      GIM_Try, /*On fail goto*//*Label 476*/ 20850, // Rule ID 1217 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1067:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VPADDLsv8i16:{ *:[v4i32] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1217,
        GIR_Done,
      // Label 476: @20850
      GIM_Try, /*On fail goto*//*Label 477*/ 20896, // Rule ID 1218 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1067:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VPADDLsv4i32:{ *:[v2i64] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1218,
        GIR_Done,
      // Label 477: @20896
      GIM_Try, /*On fail goto*//*Label 478*/ 20942, // Rule ID 1219 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddlu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1068:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VPADDLuv8i8:{ *:[v4i16] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1219,
        GIR_Done,
      // Label 478: @20942
      GIM_Try, /*On fail goto*//*Label 479*/ 20988, // Rule ID 1220 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddlu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1068:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VPADDLuv4i16:{ *:[v2i32] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1220,
        GIR_Done,
      // Label 479: @20988
      GIM_Try, /*On fail goto*//*Label 480*/ 21034, // Rule ID 1221 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddlu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i64] } 1068:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VPADDLuv2i32:{ *:[v1i64] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1221,
        GIR_Done,
      // Label 480: @21034
      GIM_Try, /*On fail goto*//*Label 481*/ 21080, // Rule ID 1222 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddlu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1068:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VPADDLuv16i8:{ *:[v8i16] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLuv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1222,
        GIR_Done,
      // Label 481: @21080
      GIM_Try, /*On fail goto*//*Label 482*/ 21126, // Rule ID 1223 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddlu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1068:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VPADDLuv8i16:{ *:[v4i32] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1223,
        GIR_Done,
      // Label 482: @21126
      GIM_Try, /*On fail goto*//*Label 483*/ 21172, // Rule ID 1224 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddlu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1068:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VPADDLuv4i32:{ *:[v2i64] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1224,
        GIR_Done,
      // Label 483: @21172
      GIM_Try, /*On fail goto*//*Label 484*/ 21218, // Rule ID 1253 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrecpe,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1097:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VRECPEd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRECPEd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1253,
        GIR_Done,
      // Label 484: @21218
      GIM_Try, /*On fail goto*//*Label 485*/ 21264, // Rule ID 1254 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrecpe,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1097:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VRECPEq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRECPEq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1254,
        GIR_Done,
      // Label 485: @21264
      GIM_Try, /*On fail goto*//*Label 486*/ 21310, // Rule ID 1255 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrecpe,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1097:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRECPEfd:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRECPEfd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1255,
        GIR_Done,
      // Label 486: @21310
      GIM_Try, /*On fail goto*//*Label 487*/ 21356, // Rule ID 1256 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrecpe,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1097:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRECPEfq:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRECPEfq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1256,
        GIR_Done,
      // Label 487: @21356
      GIM_Try, /*On fail goto*//*Label 488*/ 21402, // Rule ID 1257 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrecpe,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1097:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRECPEhd:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRECPEhd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1257,
        GIR_Done,
      // Label 488: @21402
      GIM_Try, /*On fail goto*//*Label 489*/ 21448, // Rule ID 1258 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrecpe,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1097:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRECPEhq:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRECPEhq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1258,
        GIR_Done,
      // Label 489: @21448
      GIM_Try, /*On fail goto*//*Label 490*/ 21494, // Rule ID 1263 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsqrte,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1110:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VRSQRTEd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSQRTEd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1263,
        GIR_Done,
      // Label 490: @21494
      GIM_Try, /*On fail goto*//*Label 491*/ 21540, // Rule ID 1264 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsqrte,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1110:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VRSQRTEq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSQRTEq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1264,
        GIR_Done,
      // Label 491: @21540
      GIM_Try, /*On fail goto*//*Label 492*/ 21586, // Rule ID 1265 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsqrte,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1110:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRSQRTEfd:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSQRTEfd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1265,
        GIR_Done,
      // Label 492: @21586
      GIM_Try, /*On fail goto*//*Label 493*/ 21632, // Rule ID 1266 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsqrte,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1110:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRSQRTEfq:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSQRTEfq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1266,
        GIR_Done,
      // Label 493: @21632
      GIM_Try, /*On fail goto*//*Label 494*/ 21678, // Rule ID 1267 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsqrte,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1110:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRSQRTEhd:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSQRTEhd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1267,
        GIR_Done,
      // Label 494: @21678
      GIM_Try, /*On fail goto*//*Label 495*/ 21724, // Rule ID 1268 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsqrte,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1110:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRSQRTEhq:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSQRTEhq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1268,
        GIR_Done,
      // Label 495: @21724
      GIM_Try, /*On fail goto*//*Label 496*/ 21770, // Rule ID 1489 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqabs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1073:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VQABSv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQABSv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1489,
        GIR_Done,
      // Label 496: @21770
      GIM_Try, /*On fail goto*//*Label 497*/ 21816, // Rule ID 1490 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqabs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1073:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VQABSv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQABSv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1490,
        GIR_Done,
      // Label 497: @21816
      GIM_Try, /*On fail goto*//*Label 498*/ 21862, // Rule ID 1491 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqabs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1073:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VQABSv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQABSv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1491,
        GIR_Done,
      // Label 498: @21862
      GIM_Try, /*On fail goto*//*Label 499*/ 21908, // Rule ID 1492 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqabs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1073:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VQABSv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQABSv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1492,
        GIR_Done,
      // Label 499: @21908
      GIM_Try, /*On fail goto*//*Label 500*/ 21954, // Rule ID 1493 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqabs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1073:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQABSv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQABSv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1493,
        GIR_Done,
      // Label 500: @21954
      GIM_Try, /*On fail goto*//*Label 501*/ 22000, // Rule ID 1494 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqabs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1073:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQABSv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQABSv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1494,
        GIR_Done,
      // Label 501: @22000
      GIM_Try, /*On fail goto*//*Label 502*/ 22046, // Rule ID 1505 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqneg,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1081:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VQNEGv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQNEGv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1505,
        GIR_Done,
      // Label 502: @22046
      GIM_Try, /*On fail goto*//*Label 503*/ 22092, // Rule ID 1506 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqneg,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1081:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VQNEGv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQNEGv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1506,
        GIR_Done,
      // Label 503: @22092
      GIM_Try, /*On fail goto*//*Label 504*/ 22138, // Rule ID 1507 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqneg,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1081:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VQNEGv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQNEGv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1507,
        GIR_Done,
      // Label 504: @22138
      GIM_Try, /*On fail goto*//*Label 505*/ 22184, // Rule ID 1508 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqneg,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1081:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VQNEGv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQNEGv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1508,
        GIR_Done,
      // Label 505: @22184
      GIM_Try, /*On fail goto*//*Label 506*/ 22230, // Rule ID 1509 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqneg,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1081:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQNEGv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQNEGv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1509,
        GIR_Done,
      // Label 506: @22230
      GIM_Try, /*On fail goto*//*Label 507*/ 22276, // Rule ID 1510 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqneg,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1081:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQNEGv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQNEGv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1510,
        GIR_Done,
      // Label 507: @22276
      GIM_Try, /*On fail goto*//*Label 508*/ 22322, // Rule ID 1511 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1022:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VCLSv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCLSv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1511,
        GIR_Done,
      // Label 508: @22322
      GIM_Try, /*On fail goto*//*Label 509*/ 22368, // Rule ID 1512 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1022:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VCLSv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCLSv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1512,
        GIR_Done,
      // Label 509: @22368
      GIM_Try, /*On fail goto*//*Label 510*/ 22414, // Rule ID 1513 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1022:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VCLSv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCLSv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1513,
        GIR_Done,
      // Label 510: @22414
      GIM_Try, /*On fail goto*//*Label 511*/ 22460, // Rule ID 1514 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1022:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VCLSv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCLSv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1514,
        GIR_Done,
      // Label 511: @22460
      GIM_Try, /*On fail goto*//*Label 512*/ 22506, // Rule ID 1515 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1022:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VCLSv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCLSv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1515,
        GIR_Done,
      // Label 512: @22506
      GIM_Try, /*On fail goto*//*Label 513*/ 22552, // Rule ID 1516 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1022:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VCLSv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCLSv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1516,
        GIR_Done,
      // Label 513: @22552
      GIM_Try, /*On fail goto*//*Label 514*/ 22598, // Rule ID 1560 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovns,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1078:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQMOVNsv8i8:{ *:[v8i8] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1560,
        GIR_Done,
      // Label 514: @22598
      GIM_Try, /*On fail goto*//*Label 515*/ 22644, // Rule ID 1561 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovns,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1078:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQMOVNsv4i16:{ *:[v4i16] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1561,
        GIR_Done,
      // Label 515: @22644
      GIM_Try, /*On fail goto*//*Label 516*/ 22690, // Rule ID 1562 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovns,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1078:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vm)  =>  (VQMOVNsv2i32:{ *:[v2i32] } QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1562,
        GIR_Done,
      // Label 516: @22690
      GIM_Try, /*On fail goto*//*Label 517*/ 22736, // Rule ID 1563 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovnu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1080:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQMOVNuv8i8:{ *:[v8i8] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1563,
        GIR_Done,
      // Label 517: @22736
      GIM_Try, /*On fail goto*//*Label 518*/ 22782, // Rule ID 1564 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovnu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1080:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQMOVNuv4i16:{ *:[v4i16] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1564,
        GIR_Done,
      // Label 518: @22782
      GIM_Try, /*On fail goto*//*Label 519*/ 22828, // Rule ID 1565 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovnu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1080:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vm)  =>  (VQMOVNuv2i32:{ *:[v2i32] } QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1565,
        GIR_Done,
      // Label 519: @22828
      GIM_Try, /*On fail goto*//*Label 520*/ 22874, // Rule ID 1566 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovnsu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1079:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQMOVNsuv8i8:{ *:[v8i8] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNsuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1566,
        GIR_Done,
      // Label 520: @22874
      GIM_Try, /*On fail goto*//*Label 521*/ 22920, // Rule ID 1567 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovnsu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1079:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQMOVNsuv4i16:{ *:[v4i16] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNsuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1567,
        GIR_Done,
      // Label 521: @22920
      GIM_Try, /*On fail goto*//*Label 522*/ 22966, // Rule ID 1568 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovnsu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1079:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vm)  =>  (VQMOVNsuv2i32:{ *:[v2i32] } QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNsuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1568,
        GIR_Done,
      // Label 522: @22966
      GIM_Try, /*On fail goto*//*Label 523*/ 23006, // Rule ID 1591 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtas,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1023:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTANSDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANSDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1591,
        GIR_Done,
      // Label 523: @23006
      GIM_Try, /*On fail goto*//*Label 524*/ 23046, // Rule ID 1592 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtas,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1023:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTANSQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANSQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1592,
        GIR_Done,
      // Label 524: @23046
      GIM_Try, /*On fail goto*//*Label 525*/ 23086, // Rule ID 1593 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtau,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1024:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTANUDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANUDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1593,
        GIR_Done,
      // Label 525: @23086
      GIM_Try, /*On fail goto*//*Label 526*/ 23126, // Rule ID 1594 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtau,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1024:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTANUQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANUQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1594,
        GIR_Done,
      // Label 526: @23126
      GIM_Try, /*On fail goto*//*Label 527*/ 23166, // Rule ID 1595 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtas,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1023:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTANSDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANSDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1595,
        GIR_Done,
      // Label 527: @23166
      GIM_Try, /*On fail goto*//*Label 528*/ 23206, // Rule ID 1596 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtas,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1023:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTANSQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANSQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1596,
        GIR_Done,
      // Label 528: @23206
      GIM_Try, /*On fail goto*//*Label 529*/ 23246, // Rule ID 1597 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtau,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1024:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTANUDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANUDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1597,
        GIR_Done,
      // Label 529: @23246
      GIM_Try, /*On fail goto*//*Label 530*/ 23286, // Rule ID 1598 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtau,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1024:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTANUQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANUQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1598,
        GIR_Done,
      // Label 530: @23286
      GIM_Try, /*On fail goto*//*Label 531*/ 23326, // Rule ID 1599 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtns,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1033:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTNNSDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNSDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1599,
        GIR_Done,
      // Label 531: @23326
      GIM_Try, /*On fail goto*//*Label 532*/ 23366, // Rule ID 1600 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtns,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1033:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTNNSQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNSQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1600,
        GIR_Done,
      // Label 532: @23366
      GIM_Try, /*On fail goto*//*Label 533*/ 23406, // Rule ID 1601 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtnu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1034:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTNNUDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNUDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1601,
        GIR_Done,
      // Label 533: @23406
      GIM_Try, /*On fail goto*//*Label 534*/ 23446, // Rule ID 1602 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtnu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1034:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTNNUQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNUQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1602,
        GIR_Done,
      // Label 534: @23446
      GIM_Try, /*On fail goto*//*Label 535*/ 23486, // Rule ID 1603 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtns,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1033:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTNNSDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNSDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1603,
        GIR_Done,
      // Label 535: @23486
      GIM_Try, /*On fail goto*//*Label 536*/ 23526, // Rule ID 1604 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtns,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1033:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTNNSQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNSQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1604,
        GIR_Done,
      // Label 536: @23526
      GIM_Try, /*On fail goto*//*Label 537*/ 23566, // Rule ID 1605 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtnu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1034:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTNNUDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNUDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1605,
        GIR_Done,
      // Label 537: @23566
      GIM_Try, /*On fail goto*//*Label 538*/ 23606, // Rule ID 1606 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtnu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1034:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTNNUQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNUQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1606,
        GIR_Done,
      // Label 538: @23606
      GIM_Try, /*On fail goto*//*Label 539*/ 23646, // Rule ID 1607 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtps,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1035:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTPNSDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNSDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1607,
        GIR_Done,
      // Label 539: @23646
      GIM_Try, /*On fail goto*//*Label 540*/ 23686, // Rule ID 1608 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtps,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1035:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTPNSQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNSQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1608,
        GIR_Done,
      // Label 540: @23686
      GIM_Try, /*On fail goto*//*Label 541*/ 23726, // Rule ID 1609 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtpu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1036:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTPNUDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNUDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1609,
        GIR_Done,
      // Label 541: @23726
      GIM_Try, /*On fail goto*//*Label 542*/ 23766, // Rule ID 1610 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtpu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1036:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTPNUQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNUQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1610,
        GIR_Done,
      // Label 542: @23766
      GIM_Try, /*On fail goto*//*Label 543*/ 23806, // Rule ID 1611 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtps,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1035:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTPNSDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNSDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1611,
        GIR_Done,
      // Label 543: @23806
      GIM_Try, /*On fail goto*//*Label 544*/ 23846, // Rule ID 1612 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtps,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1035:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTPNSQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNSQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1612,
        GIR_Done,
      // Label 544: @23846
      GIM_Try, /*On fail goto*//*Label 545*/ 23886, // Rule ID 1613 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtpu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1036:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTPNUDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNUDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1613,
        GIR_Done,
      // Label 545: @23886
      GIM_Try, /*On fail goto*//*Label 546*/ 23926, // Rule ID 1614 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtpu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1036:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTPNUQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNUQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1614,
        GIR_Done,
      // Label 546: @23926
      GIM_Try, /*On fail goto*//*Label 547*/ 23966, // Rule ID 1615 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtms,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1031:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTMNSDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNSDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1615,
        GIR_Done,
      // Label 547: @23966
      GIM_Try, /*On fail goto*//*Label 548*/ 24006, // Rule ID 1616 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtms,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1031:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTMNSQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNSQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1616,
        GIR_Done,
      // Label 548: @24006
      GIM_Try, /*On fail goto*//*Label 549*/ 24046, // Rule ID 1617 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtmu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1032:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTMNUDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNUDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1617,
        GIR_Done,
      // Label 549: @24046
      GIM_Try, /*On fail goto*//*Label 550*/ 24086, // Rule ID 1618 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtmu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1032:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTMNUQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNUQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1618,
        GIR_Done,
      // Label 550: @24086
      GIM_Try, /*On fail goto*//*Label 551*/ 24126, // Rule ID 1619 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtms,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1031:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTMNSDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNSDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1619,
        GIR_Done,
      // Label 551: @24126
      GIM_Try, /*On fail goto*//*Label 552*/ 24166, // Rule ID 1620 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtms,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1031:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTMNSQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNSQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1620,
        GIR_Done,
      // Label 552: @24166
      GIM_Try, /*On fail goto*//*Label 553*/ 24206, // Rule ID 1621 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtmu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1032:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTMNUDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNUDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1621,
        GIR_Done,
      // Label 553: @24206
      GIM_Try, /*On fail goto*//*Label 554*/ 24246, // Rule ID 1622 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtmu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1032:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTMNUQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNUQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1622,
        GIR_Done,
      // Label 554: @24246
      GIM_Try, /*On fail goto*//*Label 555*/ 24292, // Rule ID 1639 //
        GIM_CheckFeatures, GIFBS_HasFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfp2hf,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1027:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTf2h:{ *:[v4i16] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTf2h,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1639,
        GIR_Done,
      // Label 555: @24292
      GIM_Try, /*On fail goto*//*Label 556*/ 24338, // Rule ID 1640 //
        GIM_CheckFeatures, GIFBS_HasFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvthf2fp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1030:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VCVTh2f:{ *:[v4f32] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTh2f,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1640,
        GIR_Done,
      // Label 556: @24338
      GIM_Try, /*On fail goto*//*Label 557*/ 24378, // Rule ID 1662 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1103:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTNNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTNNDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1662,
        GIR_Done,
      // Label 557: @24378
      GIM_Try, /*On fail goto*//*Label 558*/ 24418, // Rule ID 1663 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1103:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTNNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTNNQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1663,
        GIR_Done,
      // Label 558: @24418
      GIM_Try, /*On fail goto*//*Label 559*/ 24458, // Rule ID 1664 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1103:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTNNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTNNDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1664,
        GIR_Done,
      // Label 559: @24458
      GIM_Try, /*On fail goto*//*Label 560*/ 24498, // Rule ID 1665 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1103:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTNNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTNNQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1665,
        GIR_Done,
      // Label 560: @24498
      GIM_Try, /*On fail goto*//*Label 561*/ 24538, // Rule ID 1666 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1105:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTXNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTXNDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1666,
        GIR_Done,
      // Label 561: @24538
      GIM_Try, /*On fail goto*//*Label 562*/ 24578, // Rule ID 1667 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1105:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTXNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTXNQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1667,
        GIR_Done,
      // Label 562: @24578
      GIM_Try, /*On fail goto*//*Label 563*/ 24618, // Rule ID 1668 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1105:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTXNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTXNDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1668,
        GIR_Done,
      // Label 563: @24618
      GIM_Try, /*On fail goto*//*Label 564*/ 24658, // Rule ID 1669 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1105:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTXNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTXNQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1669,
        GIR_Done,
      // Label 564: @24658
      GIM_Try, /*On fail goto*//*Label 565*/ 24698, // Rule ID 1670 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrinta,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1101:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTANDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTANDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1670,
        GIR_Done,
      // Label 565: @24698
      GIM_Try, /*On fail goto*//*Label 566*/ 24738, // Rule ID 1671 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrinta,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1101:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTANQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTANQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1671,
        GIR_Done,
      // Label 566: @24738
      GIM_Try, /*On fail goto*//*Label 567*/ 24778, // Rule ID 1672 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrinta,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1101:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTANDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTANDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1672,
        GIR_Done,
      // Label 567: @24778
      GIM_Try, /*On fail goto*//*Label 568*/ 24818, // Rule ID 1673 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrinta,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1101:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTANQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTANQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1673,
        GIR_Done,
      // Label 568: @24818
      GIM_Try, /*On fail goto*//*Label 569*/ 24858, // Rule ID 1674 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintz,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1106:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTZNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTZNDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1674,
        GIR_Done,
      // Label 569: @24858
      GIM_Try, /*On fail goto*//*Label 570*/ 24898, // Rule ID 1675 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintz,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1106:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTZNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTZNQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1675,
        GIR_Done,
      // Label 570: @24898
      GIM_Try, /*On fail goto*//*Label 571*/ 24938, // Rule ID 1676 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintz,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1106:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTZNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTZNDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1676,
        GIR_Done,
      // Label 571: @24938
      GIM_Try, /*On fail goto*//*Label 572*/ 24978, // Rule ID 1677 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintz,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1106:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTZNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTZNQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1677,
        GIR_Done,
      // Label 572: @24978
      GIM_Try, /*On fail goto*//*Label 573*/ 25018, // Rule ID 1678 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1102:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTMNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTMNDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1678,
        GIR_Done,
      // Label 573: @25018
      GIM_Try, /*On fail goto*//*Label 574*/ 25058, // Rule ID 1679 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1102:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTMNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTMNQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1679,
        GIR_Done,
      // Label 574: @25058
      GIM_Try, /*On fail goto*//*Label 575*/ 25098, // Rule ID 1680 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1102:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTMNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTMNDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1680,
        GIR_Done,
      // Label 575: @25098
      GIM_Try, /*On fail goto*//*Label 576*/ 25138, // Rule ID 1681 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1102:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTMNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTMNQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1681,
        GIR_Done,
      // Label 576: @25138
      GIM_Try, /*On fail goto*//*Label 577*/ 25178, // Rule ID 1682 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1104:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTPNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTPNDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1682,
        GIR_Done,
      // Label 577: @25178
      GIM_Try, /*On fail goto*//*Label 578*/ 25218, // Rule ID 1683 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1104:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTPNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTPNQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1683,
        GIR_Done,
      // Label 578: @25218
      GIM_Try, /*On fail goto*//*Label 579*/ 25258, // Rule ID 1684 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1104:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTPNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTPNDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1684,
        GIR_Done,
      // Label 579: @25258
      GIM_Try, /*On fail goto*//*Label 580*/ 25298, // Rule ID 1685 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1104:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTPNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTPNQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1685,
        GIR_Done,
      // Label 580: @25298
      GIM_Try, /*On fail goto*//*Label 581*/ 25338, // Rule ID 1688 //
        GIM_CheckFeatures, GIFBS_HasCrypto_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_aesimc,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1002:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (AESIMC:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::AESIMC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1688,
        GIR_Done,
      // Label 581: @25338
      GIM_Try, /*On fail goto*//*Label 582*/ 25378, // Rule ID 1689 //
        GIM_CheckFeatures, GIFBS_HasCrypto_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_aesmc,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1003:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (AESMC:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::AESMC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1689,
        GIR_Done,
      // Label 582: @25378
      GIM_Try, /*On fail goto*//*Label 583*/ 25427, // Rule ID 1705 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_sxtb16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1192:{ *:[iPTR] }, GPR:{ *:[i32] }:$Src)  =>  (SXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Src
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1705,
        GIR_Done,
      // Label 583: @25427
      GIM_Try, /*On fail goto*//*Label 584*/ 25476, // Rule ID 1899 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_sxtb16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1192:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn)  =>  (t2SXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1899,
        GIR_Done,
      // Label 584: @25476
      GIM_Reject,
    // Label 463: @25477
    GIM_Try, /*On fail goto*//*Label 585*/ 46795,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 586*/ 25543, // Rule ID 1914 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uxtab16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1216:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UXTAB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTAB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1914,
        GIR_Done,
      // Label 586: @25543
      GIM_Try, /*On fail goto*//*Label 587*/ 25633, // Rule ID 2794 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1074:{ *:[iPTR] }, (intrinsic_wo_chain:{ *:[v4i16] } 1082:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm), DPR:{ *:[v4i16] }:$src1)  =>  (VQRDMLAHv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLAHv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2794,
        GIR_Done,
      // Label 587: @25633
      GIM_Try, /*On fail goto*//*Label 588*/ 25723, // Rule ID 2795 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1074:{ *:[iPTR] }, (intrinsic_wo_chain:{ *:[v2i32] } 1082:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm), DPR:{ *:[v2i32] }:$src1)  =>  (VQRDMLAHv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLAHv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2795,
        GIR_Done,
      // Label 588: @25723
      GIM_Try, /*On fail goto*//*Label 589*/ 25813, // Rule ID 2796 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1074:{ *:[iPTR] }, (intrinsic_wo_chain:{ *:[v8i16] } 1082:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm), QPR:{ *:[v8i16] }:$src1)  =>  (VQRDMLAHv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLAHv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2796,
        GIR_Done,
      // Label 589: @25813
      GIM_Try, /*On fail goto*//*Label 590*/ 25903, // Rule ID 2797 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1074:{ *:[iPTR] }, (intrinsic_wo_chain:{ *:[v4i32] } 1082:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm), QPR:{ *:[v4i32] }:$src1)  =>  (VQRDMLAHv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLAHv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2797,
        GIR_Done,
      // Label 590: @25903
      GIM_Try, /*On fail goto*//*Label 591*/ 25991, // Rule ID 2814 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqdmull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1074:{ *:[iPTR] }, (intrinsic_wo_chain:{ *:[v4i32] } 1077:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm), QPR:{ *:[v4i32] }:$src1)  =>  (VQDMLALv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMLALv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2814,
        GIR_Done,
      // Label 591: @25991
      GIM_Try, /*On fail goto*//*Label 592*/ 26079, // Rule ID 2815 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqdmull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1074:{ *:[iPTR] }, (intrinsic_wo_chain:{ *:[v2i64] } 1077:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm), QPR:{ *:[v2i64] }:$src1)  =>  (VQDMLALv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMLALv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2815,
        GIR_Done,
      // Label 592: @26079
      GIM_Try, /*On fail goto*//*Label 593*/ 26162, // Rule ID 111 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        // MIs[1] Rm
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 1134:{ *:[iPTR] }, (intrinsic_wo_chain:{ *:[i32] } 1134:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rm), GPRnopc:{ *:[i32] }:$Rn)  =>  (QDADD:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QDADD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 111,
        GIR_Done,
      // Label 593: @26162
      GIM_Try, /*On fail goto*//*Label 594*/ 26245, // Rule ID 1927 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // MIs[1] Rm
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 1134:{ *:[iPTR] }, (intrinsic_wo_chain:{ *:[i32] } 1134:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rm), rGPR:{ *:[i32] }:$Rn)  =>  (t2QDADD:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2QDADD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1927,
        GIR_Done,
      // Label 594: @26245
      GIM_Try, /*On fail goto*//*Label 595*/ 26335, // Rule ID 2164 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1074:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$src1, (intrinsic_wo_chain:{ *:[v4i16] } 1082:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VQRDMLAHv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLAHv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2164,
        GIR_Done,
      // Label 595: @26335
      GIM_Try, /*On fail goto*//*Label 596*/ 26425, // Rule ID 2165 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1074:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$src1, (intrinsic_wo_chain:{ *:[v2i32] } 1082:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VQRDMLAHv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLAHv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2165,
        GIR_Done,
      // Label 596: @26425
      GIM_Try, /*On fail goto*//*Label 597*/ 26515, // Rule ID 2166 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1074:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$src1, (intrinsic_wo_chain:{ *:[v8i16] } 1082:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VQRDMLAHv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLAHv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2166,
        GIR_Done,
      // Label 597: @26515
      GIM_Try, /*On fail goto*//*Label 598*/ 26605, // Rule ID 2167 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1074:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$src1, (intrinsic_wo_chain:{ *:[v4i32] } 1082:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VQRDMLAHv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLAHv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2167,
        GIR_Done,
      // Label 598: @26605
      GIM_Try, /*On fail goto*//*Label 599*/ 26695, // Rule ID 2172 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1094:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$src1, (intrinsic_wo_chain:{ *:[v4i16] } 1082:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VQRDMLSHv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLSHv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2172,
        GIR_Done,
      // Label 599: @26695
      GIM_Try, /*On fail goto*//*Label 600*/ 26785, // Rule ID 2173 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1094:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$src1, (intrinsic_wo_chain:{ *:[v2i32] } 1082:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VQRDMLSHv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLSHv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2173,
        GIR_Done,
      // Label 600: @26785
      GIM_Try, /*On fail goto*//*Label 601*/ 26875, // Rule ID 2174 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1094:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$src1, (intrinsic_wo_chain:{ *:[v8i16] } 1082:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VQRDMLSHv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLSHv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2174,
        GIR_Done,
      // Label 601: @26875
      GIM_Try, /*On fail goto*//*Label 602*/ 26965, // Rule ID 2175 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1094:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$src1, (intrinsic_wo_chain:{ *:[v4i32] } 1082:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VQRDMLSHv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLSHv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2175,
        GIR_Done,
      // Label 602: @26965
      GIM_Try, /*On fail goto*//*Label 603*/ 27053, // Rule ID 2180 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqdmull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1074:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$src1, (intrinsic_wo_chain:{ *:[v4i32] } 1077:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VQDMLALv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMLALv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2180,
        GIR_Done,
      // Label 603: @27053
      GIM_Try, /*On fail goto*//*Label 604*/ 27141, // Rule ID 2181 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqdmull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1074:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$src1, (intrinsic_wo_chain:{ *:[v2i64] } 1077:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VQDMLALv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMLALv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2181,
        GIR_Done,
      // Label 604: @27141
      GIM_Try, /*On fail goto*//*Label 605*/ 27229, // Rule ID 2187 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqdmull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1094:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$src1, (intrinsic_wo_chain:{ *:[v4i32] } 1077:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VQDMLSLv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMLSLv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2187,
        GIR_Done,
      // Label 605: @27229
      GIM_Try, /*On fail goto*//*Label 606*/ 27317, // Rule ID 2188 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqdmull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1094:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$src1, (intrinsic_wo_chain:{ *:[v2i64] } 1077:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VQDMLSLv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMLSLv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2188,
        GIR_Done,
      // Label 606: @27317
      GIM_Try, /*On fail goto*//*Label 607*/ 27400, // Rule ID 112 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qsub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        // MIs[1] Rn
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 1139:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rm, (intrinsic_wo_chain:{ *:[i32] } 1134:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rn))  =>  (QDSUB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QDSUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 112,
        GIR_Done,
      // Label 607: @27400
      GIM_Try, /*On fail goto*//*Label 608*/ 27483, // Rule ID 1928 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qsub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // MIs[1] Rn
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 1139:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rm, (intrinsic_wo_chain:{ *:[i32] } 1134:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rn))  =>  (t2QDSUB:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2QDSUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1928,
        GIR_Done,
      // Label 608: @27483
      GIM_Try, /*On fail goto*//*Label 609*/ 27566, // Rule ID 2504 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        // MIs[1] Rm
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 1134:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, (intrinsic_wo_chain:{ *:[i32] } 1134:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rm))  =>  (QDADD:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QDADD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2504,
        GIR_Done,
      // Label 609: @27566
      GIM_Try, /*On fail goto*//*Label 610*/ 27649, // Rule ID 2755 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // MIs[1] Rm
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 1134:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, (intrinsic_wo_chain:{ *:[i32] } 1134:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rm))  =>  (t2QDADD:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2QDADD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2755,
        GIR_Done,
      // Label 610: @27649
      GIM_Try, /*On fail goto*//*Label 611*/ 27717, // Rule ID 1719 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_usat,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_imm0_31,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 1211:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$a, (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$pos)  =>  (USAT:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$pos, GPRnopc:{ *:[i32] }:$a, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::USAT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // pos
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1719,
        GIR_Done,
      // Label 611: @27717
      GIM_Try, /*On fail goto*//*Label 612*/ 27782, // Rule ID 1723 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_usat16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_imm0_15,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 1212:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$a, (imm:{ *:[i32] })<<P:Predicate_imm0_15>>:$pos)  =>  (USAT16:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_imm0_15>>:$pos, GPRnopc:{ *:[i32] }:$a)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::USAT16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // pos
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1723,
        GIR_Done,
      // Label 612: @27782
      GIM_Try, /*On fail goto*//*Label 613*/ 27850, // Rule ID 1932 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_usat,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_imm0_31,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 1211:{ *:[iPTR] }, GPR:{ *:[i32] }:$a, (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$pos)  =>  (t2USAT:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$pos, GPR:{ *:[i32] }:$a, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2USAT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // pos
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1932,
        GIR_Done,
      // Label 613: @27850
      GIM_Try, /*On fail goto*//*Label 614*/ 27915, // Rule ID 1934 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_usat16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_imm0_15,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 1212:{ *:[iPTR] }, GPR:{ *:[i32] }:$a, (imm:{ *:[i32] })<<P:Predicate_imm0_15>>:$pos)  =>  (t2USAT16:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_imm0_15>>:$pos, GPR:{ *:[i32] }:$a)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2USAT16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // pos
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1934,
        GIR_Done,
      // Label 614: @27915
      GIM_Try, /*On fail goto*//*Label 615*/ 27977, // Rule ID 1623 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfp2fxs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1025:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTf2xsd:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTf2xsd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1623,
        GIR_Done,
      // Label 615: @27977
      GIM_Try, /*On fail goto*//*Label 616*/ 28039, // Rule ID 1624 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfp2fxu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1026:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTf2xud:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTf2xud,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1624,
        GIR_Done,
      // Label 616: @28039
      GIM_Try, /*On fail goto*//*Label 617*/ 28101, // Rule ID 1625 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfxs2fp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1028:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTxs2fd:{ *:[v2f32] } DPR:{ *:[v2i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTxs2fd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1625,
        GIR_Done,
      // Label 617: @28101
      GIM_Try, /*On fail goto*//*Label 618*/ 28163, // Rule ID 1626 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfxu2fp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1029:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTxu2fd:{ *:[v2f32] } DPR:{ *:[v2i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTxu2fd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1626,
        GIR_Done,
      // Label 618: @28163
      GIM_Try, /*On fail goto*//*Label 619*/ 28225, // Rule ID 1627 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfp2fxs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1025:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTh2xsd:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTh2xsd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1627,
        GIR_Done,
      // Label 619: @28225
      GIM_Try, /*On fail goto*//*Label 620*/ 28287, // Rule ID 1628 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfp2fxu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1026:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTh2xud:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTh2xud,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1628,
        GIR_Done,
      // Label 620: @28287
      GIM_Try, /*On fail goto*//*Label 621*/ 28349, // Rule ID 1629 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfxs2fp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1028:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTxs2hd:{ *:[v4f16] } DPR:{ *:[v4i16] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTxs2hd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1629,
        GIR_Done,
      // Label 621: @28349
      GIM_Try, /*On fail goto*//*Label 622*/ 28411, // Rule ID 1630 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfxu2fp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1029:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTxu2hd:{ *:[v4f16] } DPR:{ *:[v4i16] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTxu2hd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1630,
        GIR_Done,
      // Label 622: @28411
      GIM_Try, /*On fail goto*//*Label 623*/ 28473, // Rule ID 1631 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfp2fxs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1025:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTf2xsq:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTf2xsq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1631,
        GIR_Done,
      // Label 623: @28473
      GIM_Try, /*On fail goto*//*Label 624*/ 28535, // Rule ID 1632 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfp2fxu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1026:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTf2xuq:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTf2xuq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1632,
        GIR_Done,
      // Label 624: @28535
      GIM_Try, /*On fail goto*//*Label 625*/ 28597, // Rule ID 1633 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfxs2fp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1028:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTxs2fq:{ *:[v4f32] } QPR:{ *:[v4i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTxs2fq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1633,
        GIR_Done,
      // Label 625: @28597
      GIM_Try, /*On fail goto*//*Label 626*/ 28659, // Rule ID 1634 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfxu2fp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1029:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTxu2fq:{ *:[v4f32] } QPR:{ *:[v4i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTxu2fq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1634,
        GIR_Done,
      // Label 626: @28659
      GIM_Try, /*On fail goto*//*Label 627*/ 28721, // Rule ID 1635 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfp2fxs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1025:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTh2xsq:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTh2xsq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1635,
        GIR_Done,
      // Label 627: @28721
      GIM_Try, /*On fail goto*//*Label 628*/ 28783, // Rule ID 1636 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfp2fxu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1026:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTh2xuq:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTh2xuq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1636,
        GIR_Done,
      // Label 628: @28783
      GIM_Try, /*On fail goto*//*Label 629*/ 28845, // Rule ID 1637 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfxs2fp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1028:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTxs2hq:{ *:[v8f16] } QPR:{ *:[v8i16] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTxs2hq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1637,
        GIR_Done,
      // Label 629: @28845
      GIM_Try, /*On fail goto*//*Label 630*/ 28907, // Rule ID 1638 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfxu2fp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1029:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTxu2hq:{ *:[v8f16] } QPR:{ *:[v8i16] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTxu2hq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1638,
        GIR_Done,
      // Label 630: @28907
      GIM_Try, /*On fail goto*//*Label 631*/ 28965, // Rule ID 107 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qadd8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1136:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (QADD8:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QADD8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 107,
        GIR_Done,
      // Label 631: @28965
      GIM_Try, /*On fail goto*//*Label 632*/ 29023, // Rule ID 108 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qadd16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1135:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (QADD16:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QADD16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 108,
        GIR_Done,
      // Label 632: @29023
      GIM_Try, /*On fail goto*//*Label 633*/ 29081, // Rule ID 109 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qsub16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1140:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (QSUB16:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QSUB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 109,
        GIR_Done,
      // Label 633: @29081
      GIM_Try, /*On fail goto*//*Label 634*/ 29139, // Rule ID 110 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qsub8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1141:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (QSUB8:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QSUB8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 110,
        GIR_Done,
      // Label 634: @29139
      GIM_Try, /*On fail goto*//*Label 635*/ 29197, // Rule ID 113 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qsub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1139:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)  =>  (QSUB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QSUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 113,
        GIR_Done,
      // Label 635: @29197
      GIM_Try, /*On fail goto*//*Label 636*/ 29255, // Rule ID 114 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1134:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)  =>  (QADD:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QADD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 114,
        GIR_Done,
      // Label 636: @29255
      GIM_Try, /*On fail goto*//*Label 637*/ 29313, // Rule ID 115 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqadd16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1203:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UQADD16:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UQADD16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 115,
        GIR_Done,
      // Label 637: @29313
      GIM_Try, /*On fail goto*//*Label 638*/ 29371, // Rule ID 116 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqadd8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1204:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UQADD8:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UQADD8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 116,
        GIR_Done,
      // Label 638: @29371
      GIM_Try, /*On fail goto*//*Label 639*/ 29429, // Rule ID 117 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqsub16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1207:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UQSUB16:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UQSUB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 117,
        GIR_Done,
      // Label 639: @29429
      GIM_Try, /*On fail goto*//*Label 640*/ 29487, // Rule ID 118 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqsub8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1208:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UQSUB8:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UQSUB8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 118,
        GIR_Done,
      // Label 640: @29487
      GIM_Try, /*On fail goto*//*Label 641*/ 29545, // Rule ID 119 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qasx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1137:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (QASX:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QASX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 119,
        GIR_Done,
      // Label 641: @29545
      GIM_Try, /*On fail goto*//*Label 642*/ 29603, // Rule ID 120 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qsax,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1138:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (QSAX:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QSAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 120,
        GIR_Done,
      // Label 642: @29603
      GIM_Try, /*On fail goto*//*Label 643*/ 29661, // Rule ID 121 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqasx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1205:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UQASX:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UQASX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 121,
        GIR_Done,
      // Label 643: @29661
      GIM_Try, /*On fail goto*//*Label 644*/ 29719, // Rule ID 122 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqsax,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1206:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UQSAX:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UQSAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 122,
        GIR_Done,
      // Label 644: @29719
      GIM_Try, /*On fail goto*//*Label 645*/ 29777, // Rule ID 135 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shasx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1149:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (SHASX:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SHASX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 135,
        GIR_Done,
      // Label 645: @29777
      GIM_Try, /*On fail goto*//*Label 646*/ 29835, // Rule ID 136 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shadd16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1147:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (SHADD16:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SHADD16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 136,
        GIR_Done,
      // Label 646: @29835
      GIM_Try, /*On fail goto*//*Label 647*/ 29893, // Rule ID 137 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shadd8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1148:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (SHADD8:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SHADD8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 137,
        GIR_Done,
      // Label 647: @29893
      GIM_Try, /*On fail goto*//*Label 648*/ 29951, // Rule ID 138 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shsax,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1150:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (SHSAX:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SHSAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 138,
        GIR_Done,
      // Label 648: @29951
      GIM_Try, /*On fail goto*//*Label 649*/ 30009, // Rule ID 139 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shsub16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1151:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (SHSUB16:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SHSUB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 139,
        GIR_Done,
      // Label 649: @30009
      GIM_Try, /*On fail goto*//*Label 650*/ 30067, // Rule ID 140 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shsub8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1152:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (SHSUB8:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SHSUB8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 140,
        GIR_Done,
      // Label 650: @30067
      GIM_Try, /*On fail goto*//*Label 651*/ 30125, // Rule ID 141 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhasx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1198:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UHASX:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UHASX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 141,
        GIR_Done,
      // Label 651: @30125
      GIM_Try, /*On fail goto*//*Label 652*/ 30183, // Rule ID 142 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhadd16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1196:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UHADD16:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UHADD16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 142,
        GIR_Done,
      // Label 652: @30183
      GIM_Try, /*On fail goto*//*Label 653*/ 30241, // Rule ID 143 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhadd8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1197:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UHADD8:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UHADD8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 143,
        GIR_Done,
      // Label 653: @30241
      GIM_Try, /*On fail goto*//*Label 654*/ 30299, // Rule ID 144 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhsax,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1199:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UHSAX:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UHSAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 144,
        GIR_Done,
      // Label 654: @30299
      GIM_Try, /*On fail goto*//*Label 655*/ 30357, // Rule ID 145 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhsub16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1200:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UHSUB16:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UHSUB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 145,
        GIR_Done,
      // Label 655: @30357
      GIM_Try, /*On fail goto*//*Label 656*/ 30415, // Rule ID 146 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhsub8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1201:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UHSUB8:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UHSUB8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 146,
        GIR_Done,
      // Label 656: @30415
      GIM_Try, /*On fail goto*//*Label 657*/ 30473, // Rule ID 147 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_usad8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1209:{ *:[iPTR] }, GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (USAD8:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::USAD8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 147,
        GIR_Done,
      // Label 657: @30473
      GIM_Try, /*On fail goto*//*Label 658*/ 30525, // Rule ID 206 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 972:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (CRC32B:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::CRC32B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 206,
        GIR_Done,
      // Label 658: @30525
      GIM_Try, /*On fail goto*//*Label 659*/ 30577, // Rule ID 207 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32cb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 973:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (CRC32CB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::CRC32CB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 207,
        GIR_Done,
      // Label 659: @30577
      GIM_Try, /*On fail goto*//*Label 660*/ 30629, // Rule ID 208 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 976:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (CRC32H:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::CRC32H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 208,
        GIR_Done,
      // Label 660: @30629
      GIM_Try, /*On fail goto*//*Label 661*/ 30681, // Rule ID 209 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32ch,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 974:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (CRC32CH:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::CRC32CH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 209,
        GIR_Done,
      // Label 661: @30681
      GIM_Try, /*On fail goto*//*Label 662*/ 30733, // Rule ID 210 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 977:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (CRC32W:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::CRC32W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 210,
        GIR_Done,
      // Label 662: @30733
      GIM_Try, /*On fail goto*//*Label 663*/ 30785, // Rule ID 211 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32cw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 975:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (CRC32CW:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::CRC32CW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 211,
        GIR_Done,
      // Label 663: @30785
      GIM_Try, /*On fail goto*//*Label 664*/ 30843, // Rule ID 436 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qadd16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1135:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2QADD16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2QADD16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 436,
        GIR_Done,
      // Label 664: @30843
      GIM_Try, /*On fail goto*//*Label 665*/ 30901, // Rule ID 437 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qadd8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1136:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2QADD8:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2QADD8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 437,
        GIR_Done,
      // Label 665: @30901
      GIM_Try, /*On fail goto*//*Label 666*/ 30959, // Rule ID 438 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qasx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1137:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2QASX:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2QASX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 438,
        GIR_Done,
      // Label 666: @30959
      GIM_Try, /*On fail goto*//*Label 667*/ 31017, // Rule ID 439 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqsub8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1208:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UQSUB8:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UQSUB8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 439,
        GIR_Done,
      // Label 667: @31017
      GIM_Try, /*On fail goto*//*Label 668*/ 31075, // Rule ID 440 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qsax,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1138:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2QSAX:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2QSAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 440,
        GIR_Done,
      // Label 668: @31075
      GIM_Try, /*On fail goto*//*Label 669*/ 31133, // Rule ID 441 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qsub16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1140:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2QSUB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2QSUB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 441,
        GIR_Done,
      // Label 669: @31133
      GIM_Try, /*On fail goto*//*Label 670*/ 31191, // Rule ID 442 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qsub8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1141:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2QSUB8:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2QSUB8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 442,
        GIR_Done,
      // Label 670: @31191
      GIM_Try, /*On fail goto*//*Label 671*/ 31249, // Rule ID 443 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqadd16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1203:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UQADD16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UQADD16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 443,
        GIR_Done,
      // Label 671: @31249
      GIM_Try, /*On fail goto*//*Label 672*/ 31307, // Rule ID 444 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqadd8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1204:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UQADD8:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UQADD8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 444,
        GIR_Done,
      // Label 672: @31307
      GIM_Try, /*On fail goto*//*Label 673*/ 31365, // Rule ID 445 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqasx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1205:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UQASX:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UQASX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 445,
        GIR_Done,
      // Label 673: @31365
      GIM_Try, /*On fail goto*//*Label 674*/ 31423, // Rule ID 446 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqsax,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1206:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UQSAX:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UQSAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 446,
        GIR_Done,
      // Label 674: @31423
      GIM_Try, /*On fail goto*//*Label 675*/ 31481, // Rule ID 447 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqsub16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1207:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UQSUB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UQSUB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 447,
        GIR_Done,
      // Label 675: @31481
      GIM_Try, /*On fail goto*//*Label 676*/ 31539, // Rule ID 460 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shasx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1149:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SHASX:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SHASX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 460,
        GIR_Done,
      // Label 676: @31539
      GIM_Try, /*On fail goto*//*Label 677*/ 31597, // Rule ID 461 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shadd16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1147:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SHADD16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SHADD16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 461,
        GIR_Done,
      // Label 677: @31597
      GIM_Try, /*On fail goto*//*Label 678*/ 31655, // Rule ID 462 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shadd8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1148:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SHADD8:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SHADD8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 462,
        GIR_Done,
      // Label 678: @31655
      GIM_Try, /*On fail goto*//*Label 679*/ 31713, // Rule ID 463 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shsax,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1150:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SHSAX:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SHSAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 463,
        GIR_Done,
      // Label 679: @31713
      GIM_Try, /*On fail goto*//*Label 680*/ 31771, // Rule ID 464 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shsub16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1151:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SHSUB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SHSUB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 464,
        GIR_Done,
      // Label 680: @31771
      GIM_Try, /*On fail goto*//*Label 681*/ 31829, // Rule ID 465 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shsub8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1152:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SHSUB8:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SHSUB8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 465,
        GIR_Done,
      // Label 681: @31829
      GIM_Try, /*On fail goto*//*Label 682*/ 31887, // Rule ID 466 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhasx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1198:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UHASX:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UHASX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 466,
        GIR_Done,
      // Label 682: @31887
      GIM_Try, /*On fail goto*//*Label 683*/ 31945, // Rule ID 467 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhadd16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1196:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UHADD16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UHADD16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 467,
        GIR_Done,
      // Label 683: @31945
      GIM_Try, /*On fail goto*//*Label 684*/ 32003, // Rule ID 468 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhadd8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1197:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UHADD8:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UHADD8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 468,
        GIR_Done,
      // Label 684: @32003
      GIM_Try, /*On fail goto*//*Label 685*/ 32061, // Rule ID 469 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhsax,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1199:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UHSAX:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UHSAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 469,
        GIR_Done,
      // Label 685: @32061
      GIM_Try, /*On fail goto*//*Label 686*/ 32119, // Rule ID 470 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhsub16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1200:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UHSUB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UHSUB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 470,
        GIR_Done,
      // Label 686: @32119
      GIM_Try, /*On fail goto*//*Label 687*/ 32177, // Rule ID 471 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhsub8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1201:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UHSUB8:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UHSUB8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 471,
        GIR_Done,
      // Label 687: @32177
      GIM_Try, /*On fail goto*//*Label 688*/ 32235, // Rule ID 472 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_usad8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1209:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2USAD8:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2USAD8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 472,
        GIR_Done,
      // Label 688: @32235
      GIM_Try, /*On fail goto*//*Label 689*/ 32293, // Rule ID 528 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_smuad,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1167:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SMUAD:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SMUAD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 528,
        GIR_Done,
      // Label 689: @32293
      GIM_Try, /*On fail goto*//*Label 690*/ 32351, // Rule ID 529 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_smuadx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1168:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SMUADX:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SMUADX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 529,
        GIR_Done,
      // Label 690: @32351
      GIM_Try, /*On fail goto*//*Label 691*/ 32409, // Rule ID 530 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_smusd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1175:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SMUSD:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SMUSD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 530,
        GIR_Done,
      // Label 691: @32409
      GIM_Try, /*On fail goto*//*Label 692*/ 32467, // Rule ID 531 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_smusdx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1176:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SMUSDX:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SMUSDX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 531,
        GIR_Done,
      // Label 692: @32467
      GIM_Try, /*On fail goto*//*Label 693*/ 32519, // Rule ID 545 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 972:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2CRC32B:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2CRC32B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 545,
        GIR_Done,
      // Label 693: @32519
      GIM_Try, /*On fail goto*//*Label 694*/ 32571, // Rule ID 546 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32cb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 973:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2CRC32CB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2CRC32CB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 546,
        GIR_Done,
      // Label 694: @32571
      GIM_Try, /*On fail goto*//*Label 695*/ 32623, // Rule ID 547 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 976:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2CRC32H:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2CRC32H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 547,
        GIR_Done,
      // Label 695: @32623
      GIM_Try, /*On fail goto*//*Label 696*/ 32675, // Rule ID 548 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32ch,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 974:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2CRC32CH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2CRC32CH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 548,
        GIR_Done,
      // Label 696: @32675
      GIM_Try, /*On fail goto*//*Label 697*/ 32727, // Rule ID 549 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 977:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2CRC32W:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2CRC32W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 549,
        GIR_Done,
      // Label 697: @32727
      GIM_Try, /*On fail goto*//*Label 698*/ 32779, // Rule ID 550 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32cw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 975:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2CRC32CW:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2CRC32CW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 550,
        GIR_Done,
      // Label 698: @32779
      GIM_Try, /*On fail goto*//*Label 699*/ 32837, // Rule ID 778 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1037:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VHADDsv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 778,
        GIR_Done,
      // Label 699: @32837
      GIM_Try, /*On fail goto*//*Label 700*/ 32895, // Rule ID 779 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1037:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VHADDsv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 779,
        GIR_Done,
      // Label 700: @32895
      GIM_Try, /*On fail goto*//*Label 701*/ 32953, // Rule ID 780 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1037:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VHADDsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 780,
        GIR_Done,
      // Label 701: @32953
      GIM_Try, /*On fail goto*//*Label 702*/ 33011, // Rule ID 781 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1037:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VHADDsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 781,
        GIR_Done,
      // Label 702: @33011
      GIM_Try, /*On fail goto*//*Label 703*/ 33069, // Rule ID 782 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1037:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VHADDsv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 782,
        GIR_Done,
      // Label 703: @33069
      GIM_Try, /*On fail goto*//*Label 704*/ 33127, // Rule ID 783 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1037:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VHADDsv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDsv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 783,
        GIR_Done,
      // Label 704: @33127
      GIM_Try, /*On fail goto*//*Label 705*/ 33185, // Rule ID 784 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1038:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VHADDuv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 784,
        GIR_Done,
      // Label 705: @33185
      GIM_Try, /*On fail goto*//*Label 706*/ 33243, // Rule ID 785 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1038:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VHADDuv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 785,
        GIR_Done,
      // Label 706: @33243
      GIM_Try, /*On fail goto*//*Label 707*/ 33301, // Rule ID 786 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1038:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VHADDuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 786,
        GIR_Done,
      // Label 707: @33301
      GIM_Try, /*On fail goto*//*Label 708*/ 33359, // Rule ID 787 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1038:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VHADDuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 787,
        GIR_Done,
      // Label 708: @33359
      GIM_Try, /*On fail goto*//*Label 709*/ 33417, // Rule ID 788 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1038:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VHADDuv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 788,
        GIR_Done,
      // Label 709: @33417
      GIM_Try, /*On fail goto*//*Label 710*/ 33475, // Rule ID 789 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1038:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VHADDuv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDuv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 789,
        GIR_Done,
      // Label 710: @33475
      GIM_Try, /*On fail goto*//*Label 711*/ 33533, // Rule ID 790 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1099:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VRHADDsv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 790,
        GIR_Done,
      // Label 711: @33533
      GIM_Try, /*On fail goto*//*Label 712*/ 33591, // Rule ID 791 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1099:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VRHADDsv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 791,
        GIR_Done,
      // Label 712: @33591
      GIM_Try, /*On fail goto*//*Label 713*/ 33649, // Rule ID 792 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1099:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VRHADDsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 792,
        GIR_Done,
      // Label 713: @33649
      GIM_Try, /*On fail goto*//*Label 714*/ 33707, // Rule ID 793 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1099:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VRHADDsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 793,
        GIR_Done,
      // Label 714: @33707
      GIM_Try, /*On fail goto*//*Label 715*/ 33765, // Rule ID 794 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1099:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VRHADDsv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 794,
        GIR_Done,
      // Label 715: @33765
      GIM_Try, /*On fail goto*//*Label 716*/ 33823, // Rule ID 795 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1099:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VRHADDsv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDsv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 795,
        GIR_Done,
      // Label 716: @33823
      GIM_Try, /*On fail goto*//*Label 717*/ 33881, // Rule ID 796 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1100:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VRHADDuv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 796,
        GIR_Done,
      // Label 717: @33881
      GIM_Try, /*On fail goto*//*Label 718*/ 33939, // Rule ID 797 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1100:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VRHADDuv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 797,
        GIR_Done,
      // Label 718: @33939
      GIM_Try, /*On fail goto*//*Label 719*/ 33997, // Rule ID 798 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1100:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VRHADDuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 798,
        GIR_Done,
      // Label 719: @33997
      GIM_Try, /*On fail goto*//*Label 720*/ 34055, // Rule ID 799 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1100:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VRHADDuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 799,
        GIR_Done,
      // Label 720: @34055
      GIM_Try, /*On fail goto*//*Label 721*/ 34113, // Rule ID 800 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1100:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VRHADDuv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 800,
        GIR_Done,
      // Label 721: @34113
      GIM_Try, /*On fail goto*//*Label 722*/ 34171, // Rule ID 801 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1100:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VRHADDuv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDuv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 801,
        GIR_Done,
      // Label 722: @34171
      GIM_Try, /*On fail goto*//*Label 723*/ 34229, // Rule ID 802 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1074:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VQADDsv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 802,
        GIR_Done,
      // Label 723: @34229
      GIM_Try, /*On fail goto*//*Label 724*/ 34287, // Rule ID 803 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1074:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VQADDsv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 803,
        GIR_Done,
      // Label 724: @34287
      GIM_Try, /*On fail goto*//*Label 725*/ 34345, // Rule ID 804 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1074:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VQADDsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 804,
        GIR_Done,
      // Label 725: @34345
      GIM_Try, /*On fail goto*//*Label 726*/ 34403, // Rule ID 805 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1074:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VQADDsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 805,
        GIR_Done,
      // Label 726: @34403
      GIM_Try, /*On fail goto*//*Label 727*/ 34461, // Rule ID 806 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1074:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VQADDsv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 806,
        GIR_Done,
      // Label 727: @34461
      GIM_Try, /*On fail goto*//*Label 728*/ 34519, // Rule ID 807 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1074:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VQADDsv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDsv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 807,
        GIR_Done,
      // Label 728: @34519
      GIM_Try, /*On fail goto*//*Label 729*/ 34577, // Rule ID 808 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i64] } 1074:{ *:[iPTR] }, DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)  =>  (VQADDsv1i64:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDsv1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 808,
        GIR_Done,
      // Label 729: @34577
      GIM_Try, /*On fail goto*//*Label 730*/ 34635, // Rule ID 809 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1074:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VQADDsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 809,
        GIR_Done,
      // Label 730: @34635
      GIM_Try, /*On fail goto*//*Label 731*/ 34693, // Rule ID 810 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1075:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VQADDuv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 810,
        GIR_Done,
      // Label 731: @34693
      GIM_Try, /*On fail goto*//*Label 732*/ 34751, // Rule ID 811 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1075:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VQADDuv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 811,
        GIR_Done,
      // Label 732: @34751
      GIM_Try, /*On fail goto*//*Label 733*/ 34809, // Rule ID 812 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1075:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VQADDuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 812,
        GIR_Done,
      // Label 733: @34809
      GIM_Try, /*On fail goto*//*Label 734*/ 34867, // Rule ID 813 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1075:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VQADDuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 813,
        GIR_Done,
      // Label 734: @34867
      GIM_Try, /*On fail goto*//*Label 735*/ 34925, // Rule ID 814 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1075:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VQADDuv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 814,
        GIR_Done,
      // Label 735: @34925
      GIM_Try, /*On fail goto*//*Label 736*/ 34983, // Rule ID 815 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1075:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VQADDuv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDuv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 815,
        GIR_Done,
      // Label 736: @34983
      GIM_Try, /*On fail goto*//*Label 737*/ 35041, // Rule ID 816 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i64] } 1075:{ *:[iPTR] }, DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)  =>  (VQADDuv1i64:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDuv1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 816,
        GIR_Done,
      // Label 737: @35041
      GIM_Try, /*On fail goto*//*Label 738*/ 35099, // Rule ID 817 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1075:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VQADDuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 817,
        GIR_Done,
      // Label 738: @35099
      GIM_Try, /*On fail goto*//*Label 739*/ 35157, // Rule ID 818 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vraddhn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1096:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VRADDHNv8i8:{ *:[v8i8] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRADDHNv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 818,
        GIR_Done,
      // Label 739: @35157
      GIM_Try, /*On fail goto*//*Label 740*/ 35215, // Rule ID 819 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vraddhn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1096:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VRADDHNv4i16:{ *:[v4i16] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRADDHNv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 819,
        GIR_Done,
      // Label 740: @35215
      GIM_Try, /*On fail goto*//*Label 741*/ 35273, // Rule ID 820 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vraddhn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1096:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VRADDHNv2i32:{ *:[v2i32] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRADDHNv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 820,
        GIR_Done,
      // Label 741: @35273
      GIM_Try, /*On fail goto*//*Label 742*/ 35331, // Rule ID 827 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vmulp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1063:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VMULpd:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULpd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 827,
        GIR_Done,
      // Label 742: @35331
      GIM_Try, /*On fail goto*//*Label 743*/ 35389, // Rule ID 828 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vmulp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1063:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VMULpq:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULpq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 828,
        GIR_Done,
      // Label 743: @35389
      GIM_Try, /*On fail goto*//*Label 744*/ 35447, // Rule ID 841 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqdmulh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1076:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VQDMULHv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMULHv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 841,
        GIR_Done,
      // Label 744: @35447
      GIM_Try, /*On fail goto*//*Label 745*/ 35505, // Rule ID 842 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqdmulh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1076:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VQDMULHv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMULHv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 842,
        GIR_Done,
      // Label 745: @35505
      GIM_Try, /*On fail goto*//*Label 746*/ 35563, // Rule ID 843 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqdmulh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1076:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VQDMULHv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMULHv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 843,
        GIR_Done,
      // Label 746: @35563
      GIM_Try, /*On fail goto*//*Label 747*/ 35621, // Rule ID 844 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqdmulh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1076:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VQDMULHv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMULHv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 844,
        GIR_Done,
      // Label 747: @35621
      GIM_Try, /*On fail goto*//*Label 748*/ 35679, // Rule ID 849 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1082:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VQRDMULHv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMULHv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 849,
        GIR_Done,
      // Label 748: @35679
      GIM_Try, /*On fail goto*//*Label 749*/ 35737, // Rule ID 850 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1082:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VQRDMULHv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMULHv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 850,
        GIR_Done,
      // Label 749: @35737
      GIM_Try, /*On fail goto*//*Label 750*/ 35795, // Rule ID 851 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1082:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VQRDMULHv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMULHv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 851,
        GIR_Done,
      // Label 750: @35795
      GIM_Try, /*On fail goto*//*Label 751*/ 35853, // Rule ID 852 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1082:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VQRDMULHv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMULHv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 852,
        GIR_Done,
      // Label 751: @35853
      GIM_Try, /*On fail goto*//*Label 752*/ 35911, // Rule ID 863 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vmullp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1060:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VMULLp8:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULLp8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 863,
        GIR_Done,
      // Label 752: @35911
      GIM_Try, /*On fail goto*//*Label 753*/ 35963, // Rule ID 864 //
        GIM_CheckFeatures, GIFBS_HasCrypto_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vmullp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1060:{ *:[iPTR] }, DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)  =>  (VMULLp64:{ *:[v2i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULLp64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 864,
        GIR_Done,
      // Label 753: @35963
      GIM_Try, /*On fail goto*//*Label 754*/ 36021, // Rule ID 869 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqdmull,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1077:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VQDMULLv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMULLv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 869,
        GIR_Done,
      // Label 754: @36021
      GIM_Try, /*On fail goto*//*Label 755*/ 36079, // Rule ID 870 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqdmull,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1077:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VQDMULLv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMULLv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 870,
        GIR_Done,
      // Label 755: @36079
      GIM_Try, /*On fail goto*//*Label 756*/ 36137, // Rule ID 965 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1039:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VHSUBsv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 965,
        GIR_Done,
      // Label 756: @36137
      GIM_Try, /*On fail goto*//*Label 757*/ 36195, // Rule ID 966 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1039:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VHSUBsv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 966,
        GIR_Done,
      // Label 757: @36195
      GIM_Try, /*On fail goto*//*Label 758*/ 36253, // Rule ID 967 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1039:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VHSUBsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 967,
        GIR_Done,
      // Label 758: @36253
      GIM_Try, /*On fail goto*//*Label 759*/ 36311, // Rule ID 968 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1039:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VHSUBsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 968,
        GIR_Done,
      // Label 759: @36311
      GIM_Try, /*On fail goto*//*Label 760*/ 36369, // Rule ID 969 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1039:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VHSUBsv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 969,
        GIR_Done,
      // Label 760: @36369
      GIM_Try, /*On fail goto*//*Label 761*/ 36427, // Rule ID 970 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1039:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VHSUBsv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBsv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 970,
        GIR_Done,
      // Label 761: @36427
      GIM_Try, /*On fail goto*//*Label 762*/ 36485, // Rule ID 971 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1040:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VHSUBuv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 971,
        GIR_Done,
      // Label 762: @36485
      GIM_Try, /*On fail goto*//*Label 763*/ 36543, // Rule ID 972 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1040:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VHSUBuv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 972,
        GIR_Done,
      // Label 763: @36543
      GIM_Try, /*On fail goto*//*Label 764*/ 36601, // Rule ID 973 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1040:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VHSUBuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 973,
        GIR_Done,
      // Label 764: @36601
      GIM_Try, /*On fail goto*//*Label 765*/ 36659, // Rule ID 974 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1040:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VHSUBuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 974,
        GIR_Done,
      // Label 765: @36659
      GIM_Try, /*On fail goto*//*Label 766*/ 36717, // Rule ID 975 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1040:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VHSUBuv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 975,
        GIR_Done,
      // Label 766: @36717
      GIM_Try, /*On fail goto*//*Label 767*/ 36775, // Rule ID 976 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1040:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VHSUBuv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBuv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 976,
        GIR_Done,
      // Label 767: @36775
      GIM_Try, /*On fail goto*//*Label 768*/ 36833, // Rule ID 977 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1094:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VQSUBsv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 977,
        GIR_Done,
      // Label 768: @36833
      GIM_Try, /*On fail goto*//*Label 769*/ 36891, // Rule ID 978 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1094:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VQSUBsv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 978,
        GIR_Done,
      // Label 769: @36891
      GIM_Try, /*On fail goto*//*Label 770*/ 36949, // Rule ID 979 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1094:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VQSUBsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 979,
        GIR_Done,
      // Label 770: @36949
      GIM_Try, /*On fail goto*//*Label 771*/ 37007, // Rule ID 980 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1094:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VQSUBsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 980,
        GIR_Done,
      // Label 771: @37007
      GIM_Try, /*On fail goto*//*Label 772*/ 37065, // Rule ID 981 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1094:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VQSUBsv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 981,
        GIR_Done,
      // Label 772: @37065
      GIM_Try, /*On fail goto*//*Label 773*/ 37123, // Rule ID 982 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1094:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VQSUBsv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBsv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 982,
        GIR_Done,
      // Label 773: @37123
      GIM_Try, /*On fail goto*//*Label 774*/ 37181, // Rule ID 983 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i64] } 1094:{ *:[iPTR] }, DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)  =>  (VQSUBsv1i64:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBsv1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 983,
        GIR_Done,
      // Label 774: @37181
      GIM_Try, /*On fail goto*//*Label 775*/ 37239, // Rule ID 984 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1094:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VQSUBsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 984,
        GIR_Done,
      // Label 775: @37239
      GIM_Try, /*On fail goto*//*Label 776*/ 37297, // Rule ID 985 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1095:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VQSUBuv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 985,
        GIR_Done,
      // Label 776: @37297
      GIM_Try, /*On fail goto*//*Label 777*/ 37355, // Rule ID 986 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1095:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VQSUBuv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 986,
        GIR_Done,
      // Label 777: @37355
      GIM_Try, /*On fail goto*//*Label 778*/ 37413, // Rule ID 987 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1095:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VQSUBuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 987,
        GIR_Done,
      // Label 778: @37413
      GIM_Try, /*On fail goto*//*Label 779*/ 37471, // Rule ID 988 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1095:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VQSUBuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 988,
        GIR_Done,
      // Label 779: @37471
      GIM_Try, /*On fail goto*//*Label 780*/ 37529, // Rule ID 989 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1095:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VQSUBuv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 989,
        GIR_Done,
      // Label 780: @37529
      GIM_Try, /*On fail goto*//*Label 781*/ 37587, // Rule ID 990 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1095:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VQSUBuv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBuv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 990,
        GIR_Done,
      // Label 781: @37587
      GIM_Try, /*On fail goto*//*Label 782*/ 37645, // Rule ID 991 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i64] } 1095:{ *:[iPTR] }, DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)  =>  (VQSUBuv1i64:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBuv1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 991,
        GIR_Done,
      // Label 782: @37645
      GIM_Try, /*On fail goto*//*Label 783*/ 37703, // Rule ID 992 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1095:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VQSUBuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 992,
        GIR_Done,
      // Label 783: @37703
      GIM_Try, /*On fail goto*//*Label 784*/ 37761, // Rule ID 993 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsubhn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1112:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VRSUBHNv8i8:{ *:[v8i8] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSUBHNv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 993,
        GIR_Done,
      // Label 784: @37761
      GIM_Try, /*On fail goto*//*Label 785*/ 37819, // Rule ID 994 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsubhn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1112:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VRSUBHNv4i16:{ *:[v4i16] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSUBHNv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 994,
        GIR_Done,
      // Label 785: @37819
      GIM_Try, /*On fail goto*//*Label 786*/ 37877, // Rule ID 995 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsubhn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1112:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VRSUBHNv2i32:{ *:[v2i32] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSUBHNv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 995,
        GIR_Done,
      // Label 786: @37877
      GIM_Try, /*On fail goto*//*Label 787*/ 37935, // Rule ID 1088 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vacge,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1019:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vn, DPR:{ *:[v2f32] }:$Vm)  =>  (VACGEfd:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vn, DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VACGEfd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1088,
        GIR_Done,
      // Label 787: @37935
      GIM_Try, /*On fail goto*//*Label 788*/ 37993, // Rule ID 1089 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vacge,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1019:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vn, QPR:{ *:[v4f32] }:$Vm)  =>  (VACGEfq:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vn, QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VACGEfq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1089,
        GIR_Done,
      // Label 788: @37993
      GIM_Try, /*On fail goto*//*Label 789*/ 38051, // Rule ID 1090 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vacge,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1019:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vn, DPR:{ *:[v4f16] }:$Vm)  =>  (VACGEhd:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vn, DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VACGEhd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1090,
        GIR_Done,
      // Label 789: @38051
      GIM_Try, /*On fail goto*//*Label 790*/ 38109, // Rule ID 1091 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vacge,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1019:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vn, QPR:{ *:[v8f16] }:$Vm)  =>  (VACGEhq:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vn, QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VACGEhq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1091,
        GIR_Done,
      // Label 790: @38109
      GIM_Try, /*On fail goto*//*Label 791*/ 38167, // Rule ID 1092 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vacgt,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1020:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vn, DPR:{ *:[v2f32] }:$Vm)  =>  (VACGTfd:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vn, DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VACGTfd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1092,
        GIR_Done,
      // Label 791: @38167
      GIM_Try, /*On fail goto*//*Label 792*/ 38225, // Rule ID 1093 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vacgt,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1020:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vn, QPR:{ *:[v4f32] }:$Vm)  =>  (VACGTfq:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vn, QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VACGTfq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1093,
        GIR_Done,
      // Label 792: @38225
      GIM_Try, /*On fail goto*//*Label 793*/ 38283, // Rule ID 1094 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vacgt,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1020:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vn, DPR:{ *:[v4f16] }:$Vm)  =>  (VACGThd:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vn, DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VACGThd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1094,
        GIR_Done,
      // Label 793: @38283
      GIM_Try, /*On fail goto*//*Label 794*/ 38341, // Rule ID 1095 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vacgt,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1020:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vn, QPR:{ *:[v8f16] }:$Vm)  =>  (VACGThq:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vn, QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VACGThq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1095,
        GIR_Done,
      // Label 794: @38341
      GIM_Try, /*On fail goto*//*Label 795*/ 38399, // Rule ID 1128 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1016:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VABDsv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABDsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1128,
        GIR_Done,
      // Label 795: @38399
      GIM_Try, /*On fail goto*//*Label 796*/ 38457, // Rule ID 1129 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1016:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VABDsv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABDsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1129,
        GIR_Done,
      // Label 796: @38457
      GIM_Try, /*On fail goto*//*Label 797*/ 38515, // Rule ID 1130 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1016:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VABDsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABDsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1130,
        GIR_Done,
      // Label 797: @38515
      GIM_Try, /*On fail goto*//*Label 798*/ 38573, // Rule ID 1131 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1016:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VABDsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABDsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1131,
        GIR_Done,
      // Label 798: @38573
      GIM_Try, /*On fail goto*//*Label 799*/ 38631, // Rule ID 1132 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1016:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VABDsv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABDsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1132,
        GIR_Done,
      // Label 799: @38631
      GIM_Try, /*On fail goto*//*Label 800*/ 38689, // Rule ID 1133 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1016:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VABDsv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABDsv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1133,
        GIR_Done,
      // Label 800: @38689
      GIM_Try, /*On fail goto*//*Label 801*/ 38747, // Rule ID 1134 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1017:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VABDuv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABDuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1134,
        GIR_Done,
      // Label 801: @38747
      GIM_Try, /*On fail goto*//*Label 802*/ 38805, // Rule ID 1135 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1017:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VABDuv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABDuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1135,
        GIR_Done,
      // Label 802: @38805
      GIM_Try, /*On fail goto*//*Label 803*/ 38863, // Rule ID 1136 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1017:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VABDuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABDuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1136,
        GIR_Done,
      // Label 803: @38863
      GIM_Try, /*On fail goto*//*Label 804*/ 38921, // Rule ID 1137 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1017:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VABDuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABDuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1137,
        GIR_Done,
      // Label 804: @38921
      GIM_Try, /*On fail goto*//*Label 805*/ 38979, // Rule ID 1138 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1017:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VABDuv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABDuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1138,
        GIR_Done,
      // Label 805: @38979
      GIM_Try, /*On fail goto*//*Label 806*/ 39037, // Rule ID 1139 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1017:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VABDuv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABDuv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1139,
        GIR_Done,
      // Label 806: @39037
      GIM_Try, /*On fail goto*//*Label 807*/ 39095, // Rule ID 1140 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1016:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vn, DPR:{ *:[v2f32] }:$Vm)  =>  (VABDfd:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vn, DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABDfd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1140,
        GIR_Done,
      // Label 807: @39095
      GIM_Try, /*On fail goto*//*Label 808*/ 39153, // Rule ID 1141 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1016:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vn, QPR:{ *:[v4f32] }:$Vm)  =>  (VABDfq:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vn, QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABDfq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1141,
        GIR_Done,
      // Label 808: @39153
      GIM_Try, /*On fail goto*//*Label 809*/ 39211, // Rule ID 1142 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1016:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vn, DPR:{ *:[v4f16] }:$Vm)  =>  (VABDhd:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vn, DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABDhd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1142,
        GIR_Done,
      // Label 809: @39211
      GIM_Try, /*On fail goto*//*Label 810*/ 39269, // Rule ID 1143 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1016:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vn, QPR:{ *:[v8f16] }:$Vm)  =>  (VABDhq:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vn, QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABDhq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1143,
        GIR_Done,
      // Label 810: @39269
      GIM_Try, /*On fail goto*//*Label 811*/ 39327, // Rule ID 1208 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpadd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1066:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VPADDi8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDi8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1208,
        GIR_Done,
      // Label 811: @39327
      GIM_Try, /*On fail goto*//*Label 812*/ 39385, // Rule ID 1209 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpadd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1066:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VPADDi16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDi16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1209,
        GIR_Done,
      // Label 812: @39385
      GIM_Try, /*On fail goto*//*Label 813*/ 39443, // Rule ID 1210 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpadd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1066:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VPADDi32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDi32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1210,
        GIR_Done,
      // Label 813: @39443
      GIM_Try, /*On fail goto*//*Label 814*/ 39501, // Rule ID 1211 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpadd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1066:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vn, DPR:{ *:[v2f32] }:$Vm)  =>  (VPADDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vn, DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1211,
        GIR_Done,
      // Label 814: @39501
      GIM_Try, /*On fail goto*//*Label 815*/ 39559, // Rule ID 1212 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpadd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1066:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vn, DPR:{ *:[v4f16] }:$Vm)  =>  (VPADDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vn, DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1212,
        GIR_Done,
      // Label 815: @39559
      GIM_Try, /*On fail goto*//*Label 816*/ 39617, // Rule ID 1225 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpadals,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1064:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v8i8] }:$Vm)  =>  (VPADALsv8i8:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADALsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1225,
        GIR_Done,
      // Label 816: @39617
      GIM_Try, /*On fail goto*//*Label 817*/ 39675, // Rule ID 1226 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpadals,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1064:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v4i16] }:$Vm)  =>  (VPADALsv4i16:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADALsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1226,
        GIR_Done,
      // Label 817: @39675
      GIM_Try, /*On fail goto*//*Label 818*/ 39733, // Rule ID 1227 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpadals,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i64] } 1064:{ *:[iPTR] }, DPR:{ *:[v1i64] }:$src1, DPR:{ *:[v2i32] }:$Vm)  =>  (VPADALsv2i32:{ *:[v1i64] } DPR:{ *:[v1i64] }:$src1, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADALsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1227,
        GIR_Done,
      // Label 818: @39733
      GIM_Try, /*On fail goto*//*Label 819*/ 39791, // Rule ID 1228 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpadals,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1064:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v16i8] }:$Vm)  =>  (VPADALsv16i8:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADALsv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1228,
        GIR_Done,
      // Label 819: @39791
      GIM_Try, /*On fail goto*//*Label 820*/ 39849, // Rule ID 1229 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpadals,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1064:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v8i16] }:$Vm)  =>  (VPADALsv8i16:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADALsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1229,
        GIR_Done,
      // Label 820: @39849
      GIM_Try, /*On fail goto*//*Label 821*/ 39907, // Rule ID 1230 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpadals,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1064:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$src1, QPR:{ *:[v4i32] }:$Vm)  =>  (VPADALsv4i32:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADALsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1230,
        GIR_Done,
      // Label 821: @39907
      GIM_Try, /*On fail goto*//*Label 822*/ 39965, // Rule ID 1231 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpadalu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1065:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v8i8] }:$Vm)  =>  (VPADALuv8i8:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADALuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1231,
        GIR_Done,
      // Label 822: @39965
      GIM_Try, /*On fail goto*//*Label 823*/ 40023, // Rule ID 1232 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpadalu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1065:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v4i16] }:$Vm)  =>  (VPADALuv4i16:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADALuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1232,
        GIR_Done,
      // Label 823: @40023
      GIM_Try, /*On fail goto*//*Label 824*/ 40081, // Rule ID 1233 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpadalu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i64] } 1065:{ *:[iPTR] }, DPR:{ *:[v1i64] }:$src1, DPR:{ *:[v2i32] }:$Vm)  =>  (VPADALuv2i32:{ *:[v1i64] } DPR:{ *:[v1i64] }:$src1, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADALuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1233,
        GIR_Done,
      // Label 824: @40081
      GIM_Try, /*On fail goto*//*Label 825*/ 40139, // Rule ID 1234 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpadalu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1065:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v16i8] }:$Vm)  =>  (VPADALuv16i8:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADALuv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1234,
        GIR_Done,
      // Label 825: @40139
      GIM_Try, /*On fail goto*//*Label 826*/ 40197, // Rule ID 1235 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpadalu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1065:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v8i16] }:$Vm)  =>  (VPADALuv8i16:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADALuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1235,
        GIR_Done,
      // Label 826: @40197
      GIM_Try, /*On fail goto*//*Label 827*/ 40255, // Rule ID 1236 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpadalu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1065:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$src1, QPR:{ *:[v4i32] }:$Vm)  =>  (VPADALuv4i32:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADALuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1236,
        GIR_Done,
      // Label 827: @40255
      GIM_Try, /*On fail goto*//*Label 828*/ 40313, // Rule ID 1237 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpmaxs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1069:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VPMAXs8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPMAXs8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1237,
        GIR_Done,
      // Label 828: @40313
      GIM_Try, /*On fail goto*//*Label 829*/ 40371, // Rule ID 1238 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpmaxs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1069:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VPMAXs16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPMAXs16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1238,
        GIR_Done,
      // Label 829: @40371
      GIM_Try, /*On fail goto*//*Label 830*/ 40429, // Rule ID 1239 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpmaxs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1069:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VPMAXs32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPMAXs32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1239,
        GIR_Done,
      // Label 830: @40429
      GIM_Try, /*On fail goto*//*Label 831*/ 40487, // Rule ID 1240 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpmaxu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1070:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VPMAXu8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPMAXu8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1240,
        GIR_Done,
      // Label 831: @40487
      GIM_Try, /*On fail goto*//*Label 832*/ 40545, // Rule ID 1241 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpmaxu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1070:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VPMAXu16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPMAXu16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1241,
        GIR_Done,
      // Label 832: @40545
      GIM_Try, /*On fail goto*//*Label 833*/ 40603, // Rule ID 1242 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpmaxu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1070:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VPMAXu32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPMAXu32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1242,
        GIR_Done,
      // Label 833: @40603
      GIM_Try, /*On fail goto*//*Label 834*/ 40661, // Rule ID 1243 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpmaxs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1069:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vn, DPR:{ *:[v2f32] }:$Vm)  =>  (VPMAXf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vn, DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPMAXf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1243,
        GIR_Done,
      // Label 834: @40661
      GIM_Try, /*On fail goto*//*Label 835*/ 40719, // Rule ID 1244 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpmaxs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1069:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vn, DPR:{ *:[v4f16] }:$Vm)  =>  (VPMAXh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vn, DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPMAXh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1244,
        GIR_Done,
      // Label 835: @40719
      GIM_Try, /*On fail goto*//*Label 836*/ 40777, // Rule ID 1245 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpmins,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1071:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VPMINs8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPMINs8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1245,
        GIR_Done,
      // Label 836: @40777
      GIM_Try, /*On fail goto*//*Label 837*/ 40835, // Rule ID 1246 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpmins,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1071:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VPMINs16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPMINs16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1246,
        GIR_Done,
      // Label 837: @40835
      GIM_Try, /*On fail goto*//*Label 838*/ 40893, // Rule ID 1247 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpmins,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1071:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VPMINs32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPMINs32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1247,
        GIR_Done,
      // Label 838: @40893
      GIM_Try, /*On fail goto*//*Label 839*/ 40951, // Rule ID 1248 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpminu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1072:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VPMINu8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPMINu8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1248,
        GIR_Done,
      // Label 839: @40951
      GIM_Try, /*On fail goto*//*Label 840*/ 41009, // Rule ID 1249 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpminu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1072:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VPMINu16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPMINu16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1249,
        GIR_Done,
      // Label 840: @41009
      GIM_Try, /*On fail goto*//*Label 841*/ 41067, // Rule ID 1250 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpminu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1072:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VPMINu32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPMINu32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1250,
        GIR_Done,
      // Label 841: @41067
      GIM_Try, /*On fail goto*//*Label 842*/ 41125, // Rule ID 1251 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpmins,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1071:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vn, DPR:{ *:[v2f32] }:$Vm)  =>  (VPMINf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vn, DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPMINf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1251,
        GIR_Done,
      // Label 842: @41125
      GIM_Try, /*On fail goto*//*Label 843*/ 41183, // Rule ID 1252 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpmins,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1071:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vn, DPR:{ *:[v4f16] }:$Vm)  =>  (VPMINh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vn, DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPMINh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1252,
        GIR_Done,
      // Label 843: @41183
      GIM_Try, /*On fail goto*//*Label 844*/ 41241, // Rule ID 1259 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrecps,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1098:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vn, DPR:{ *:[v2f32] }:$Vm)  =>  (VRECPSfd:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vn, DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRECPSfd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1259,
        GIR_Done,
      // Label 844: @41241
      GIM_Try, /*On fail goto*//*Label 845*/ 41299, // Rule ID 1260 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrecps,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1098:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vn, QPR:{ *:[v4f32] }:$Vm)  =>  (VRECPSfq:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vn, QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRECPSfq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1260,
        GIR_Done,
      // Label 845: @41299
      GIM_Try, /*On fail goto*//*Label 846*/ 41357, // Rule ID 1261 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrecps,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1098:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vn, DPR:{ *:[v4f16] }:$Vm)  =>  (VRECPShd:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vn, DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRECPShd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1261,
        GIR_Done,
      // Label 846: @41357
      GIM_Try, /*On fail goto*//*Label 847*/ 41415, // Rule ID 1262 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrecps,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1098:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vn, QPR:{ *:[v8f16] }:$Vm)  =>  (VRECPShq:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vn, QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRECPShq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1262,
        GIR_Done,
      // Label 847: @41415
      GIM_Try, /*On fail goto*//*Label 848*/ 41473, // Rule ID 1269 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsqrts,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1111:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vn, DPR:{ *:[v2f32] }:$Vm)  =>  (VRSQRTSfd:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vn, DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSQRTSfd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1269,
        GIR_Done,
      // Label 848: @41473
      GIM_Try, /*On fail goto*//*Label 849*/ 41531, // Rule ID 1270 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsqrts,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1111:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vn, QPR:{ *:[v4f32] }:$Vm)  =>  (VRSQRTSfq:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vn, QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSQRTSfq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1270,
        GIR_Done,
      // Label 849: @41531
      GIM_Try, /*On fail goto*//*Label 850*/ 41589, // Rule ID 1271 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsqrts,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1111:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vn, DPR:{ *:[v4f16] }:$Vm)  =>  (VRSQRTShd:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vn, DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSQRTShd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1271,
        GIR_Done,
      // Label 850: @41589
      GIM_Try, /*On fail goto*//*Label 851*/ 41647, // Rule ID 1272 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsqrts,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1111:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vn, QPR:{ *:[v8f16] }:$Vm)  =>  (VRSQRTShq:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vn, QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSQRTShq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1272,
        GIR_Done,
      // Label 851: @41647
      GIM_Try, /*On fail goto*//*Label 852*/ 41705, // Rule ID 1273 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vshifts,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1114:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm, DPR:{ *:[v4i16] }:$Vn)  =>  (VSHLsv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vm, DPR:{ *:[v4i16] }:$Vn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSHLsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1273,
        GIR_Done,
      // Label 852: @41705
      GIM_Try, /*On fail goto*//*Label 853*/ 41763, // Rule ID 1274 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vshifts,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1114:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm, DPR:{ *:[v2i32] }:$Vn)  =>  (VSHLsv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm, DPR:{ *:[v2i32] }:$Vn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSHLsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1274,
        GIR_Done,
      // Label 853: @41763
      GIM_Try, /*On fail goto*//*Label 854*/ 41821, // Rule ID 1275 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vshifts,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1114:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm, QPR:{ *:[v8i16] }:$Vn)  =>  (VSHLsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vm, QPR:{ *:[v8i16] }:$Vn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSHLsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1275,
        GIR_Done,
      // Label 854: @41821
      GIM_Try, /*On fail goto*//*Label 855*/ 41879, // Rule ID 1276 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vshifts,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1114:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm, QPR:{ *:[v4i32] }:$Vn)  =>  (VSHLsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm, QPR:{ *:[v4i32] }:$Vn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSHLsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1276,
        GIR_Done,
      // Label 855: @41879
      GIM_Try, /*On fail goto*//*Label 856*/ 41937, // Rule ID 1277 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vshifts,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1114:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm, DPR:{ *:[v8i8] }:$Vn)  =>  (VSHLsv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vm, DPR:{ *:[v8i8] }:$Vn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSHLsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1277,
        GIR_Done,
      // Label 856: @41937
      GIM_Try, /*On fail goto*//*Label 857*/ 41995, // Rule ID 1278 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vshifts,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1114:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm, QPR:{ *:[v16i8] }:$Vn)  =>  (VSHLsv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm, QPR:{ *:[v16i8] }:$Vn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSHLsv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1278,
        GIR_Done,
      // Label 857: @41995
      GIM_Try, /*On fail goto*//*Label 858*/ 42053, // Rule ID 1279 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vshifts,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i64] } 1114:{ *:[iPTR] }, DPR:{ *:[v1i64] }:$Vm, DPR:{ *:[v1i64] }:$Vn)  =>  (VSHLsv1i64:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vm, DPR:{ *:[v1i64] }:$Vn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSHLsv1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1279,
        GIR_Done,
      // Label 858: @42053
      GIM_Try, /*On fail goto*//*Label 859*/ 42111, // Rule ID 1280 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vshifts,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1114:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vm, QPR:{ *:[v2i64] }:$Vn)  =>  (VSHLsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vm, QPR:{ *:[v2i64] }:$Vn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSHLsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1280,
        GIR_Done,
      // Label 859: @42111
      GIM_Try, /*On fail goto*//*Label 860*/ 42169, // Rule ID 1281 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vshiftu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1115:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm, DPR:{ *:[v4i16] }:$Vn)  =>  (VSHLuv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vm, DPR:{ *:[v4i16] }:$Vn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSHLuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1281,
        GIR_Done,
      // Label 860: @42169
      GIM_Try, /*On fail goto*//*Label 861*/ 42227, // Rule ID 1282 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vshiftu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1115:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm, DPR:{ *:[v2i32] }:$Vn)  =>  (VSHLuv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm, DPR:{ *:[v2i32] }:$Vn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSHLuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1282,
        GIR_Done,
      // Label 861: @42227
      GIM_Try, /*On fail goto*//*Label 862*/ 42285, // Rule ID 1283 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vshiftu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1115:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm, QPR:{ *:[v8i16] }:$Vn)  =>  (VSHLuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vm, QPR:{ *:[v8i16] }:$Vn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSHLuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_A