// Copyright 2016 The SwiftShader Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef Vertex_hpp
#define Vertex_hpp

#include "Color.hpp"
#include "System/Types.hpp"
#include "Device/Config.hpp"

namespace sw
{
	ALIGN(16, struct Vertex
	{
		float v[MAX_INTERFACE_COMPONENTS];

		struct
		{
			float4 position;
			float pointSize;
		} builtins;
		struct
		{
			int x;
			int y;
			float z;
			float w;
		} projected;

		int clipFlags;
		int padding[2];
	});

	static_assert((sizeof(Vertex) & 0x0000000F) == 0, "Vertex size not a multiple of 16 bytes (alignment requirement)");
}

#endif   // Vertex_hpp
