/*---------------------------------------------------------------------------*
 *  log_tabl.c  *
 *                                                                           *
 *  Copyright 2007, 2008 Nuance Communciations, Inc.                               *
 *                                                                           *
 *  Licensed under the Apache License, Version 2.0 (the 'License');          *
 *  you may not use this file except in compliance with the License.         *
 *                                                                           *
 *  You may obtain a copy of the License at                                  *
 *      http://www.apache.org/licenses/LICENSE-2.0                           *
 *                                                                           *
 *  Unless required by applicable law or agreed to in writing, software      *
 *  distributed under the License is distributed on an 'AS IS' BASIS,        *
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. *
 *  See the License for the specific language governing permissions and      *
 *  limitations under the License.                                           *
 *                                                                           *
 *---------------------------------------------------------------------------*/



#include <stdlib.h>
#ifndef _RTT
#include <stdio.h>
#endif
#include <string.h>
#include <math.h>
#include <limits.h>
#include <assert.h>

#include "hmm_desc.h"
#include "front.h"
#include "portable.h"

#include "sh_down.h"

/* #define PRINT_SOME_CODE(fMt,aRg1) printf(fMt,aRg1) */
#define PRINT_SOME_CODE(fMt,aRg1)

/* values for default case, num_bits 12 */
#define DO_USE_LOGTAB__TABLE ( logtab->size == 4096 && LOG_SCALE == 1024)
static const int logtab__table[4097] = {
        0, 0, 710, 1125, 1420, 1648, 1835, 1993, 2129, 2250, 2358, 2455, 2545, 2627, 2702, 2773, 2839, 2901, 2960, 3015, 3068, 3118, 3165, 3211, 3254, 3296, 3336, 3375, 3412, 3448, 3483, 3516, 3549, 3580, 3611, 3641, 3670, 3698, 3725, 3751, 3777, 3803, 3827, 3851, 3875, 3898, 3921, 3943, 3964, 3985, 4006, 4026, 4046, 4066, 4085, 4104, 4122, 4140, 4158, 4175, 4193, 4210, 4226, 4243, 4259, 4275, 4290, 4306, 4321, 4336, 4350, 4365, 4379, 4393, 4407, 4421, 4435, 4448, 4461, 4474, 4487, 4500, 4512, 4525, 4537, 4549, 4561, 4573, 4585, 4596, 4608, 4619, 4630, 4641, 4652, 4663, 4674, 4685, 4695, 4705, 4716, 4726, 4736, 4746, 4756, 4766, 4775, 4785, 4795, 4804, 4813, 4823, 4832, 4841, 4850, 4859, 4868, 4876, 4885, 4894, 4902, 4911, 4919, 4928, 4936, 4944, 4952, 4960, 4968, 4976, 4984, 4992, 5000, 5008, 5015, 5023, 5031, 5038, 5046, 5053, 5060, 5068, 5075, 5082, 5089, 5096, 5103, 5110, 5117, 5124, 5131, 5138, 5144, 5151, 5158, 5164, 5171, 5178, 5184, 5191, 5197, 5203, 5210, 5216, 5222, 5228, 5235, 5241, 5247, 5253, 5259, 5265, 5271, 5277, 5283, 5289, 5295, 5300, 5306, 5312, 5318, 5323, 5329, 5335, 5340, 5346, 5351, 5357, 5362, 5368, 5373, 5378, 5384, 5389, 5394, 5400, 5405, 5410, 5415, 5420, 5425, 5431, 5436, 5441, 5446, 5451, 5456, 5461, 5466, 5471, 5475, 5480, 5485, 5490, 5495, 5500, 5504, 5509, 5514, 5518, 5523, 5528, 5532, 5537, 5542, 5546, 5551, 5555, 5560, 5564, 5569, 5573, 5577, 5582, 5586, 5591, 5595, 5599, 5604, 5608, 5612, 5616, 5621, 5625, 5629, 5633, 5637, 5642, 5646, 5650, 5654, 5658, 5662, 5666, 5670, 5674, 5678, 5682, 5686, 5690, 5694, 5698, 5702, 5706, 5710, 5714, 5718, 5721, 5725, 5729, 5733, 5737, 5740, 5744, 5748, 5752, 5755, 5759, 5763, 5766, 5770, 5774, 5777, 5781, 5785, 5788, 5792, 5795, 5799, 5802, 5806, 5809, 5813, 5816, 5820, 5823, 5827, 5830, 5834, 5837, 5841, 5844, 5847, 5851, 5854, 5858, 5861, 5864, 5868, 5871, 5874, 5878, 5881, 5884, 5887, 5891, 5894, 5897, 5900, 5904, 5907, 5910, 5913, 5916, 5919, 5923, 5926, 5929, 5932, 5935, 5938, 5941, 5944, 5948, 5951, 5954, 5957, 5960, 5963, 5966, 5969, 5972, 5975, 5978, 5981, 5984, 5987, 5990, 5993, 5996, 5999, 6001, 6004, 6007, 6010, 6013, 6016, 6019, 6022, 6025, 6027, 6030, 6033, 6036, 6039, 6041, 6044, 6047, 6050, 6053, 6055, 6058, 6061, 6064, 6066, 6069, 6072, 6075, 6077, 6080, 6083, 6085, 6088, 6091, 6093, 6096, 6099, 6101, 6104, 6107, 6109, 6112, 6115, 6117, 6120, 6122, 6125, 6128, 6130, 6133, 6135, 6138, 6140, 6143, 6145, 6148, 6151, 6153, 6156, 6158, 6161, 6163, 6166, 6168, 6170, 6173, 6175, 6178, 6180, 6183, 6185, 6188, 6190, 6193, 6195, 6197, 6200, 6202, 6205, 6207, 6209, 6212, 6214, 6216, 6219, 6221, 6224, 6226, 6228, 6231, 6233, 6235, 6238, 6240, 6242, 6244, 6247, 6249, 6251, 6254, 6256, 6258, 6260, 6263, 6265, 6267, 6269, 6272, 6274, 6276, 6278, 6281, 6283, 6285, 6287, 6289, 6292, 6294, 6296, 6298, 6300, 6303, 6305, 6307, 6309, 6311, 6313, 6316, 6318, 6320, 6322, 6324, 6326, 6328, 6330, 6333, 6335, 6337, 6339, 6341, 6343, 6345, 6347, 6349, 6351, 6353, 6356, 6358, 6360, 6362, 6364, 6366, 6368, 6370, 6372, 6374, 6376, 6378, 6380, 6382, 6384, 6386, 6388, 6390, 6392, 6394, 6396, 6398, 6400, 6402, 6404, 6406, 6408, 6410, 6412, 6414, 6416, 6418, 6420, 6421, 6423, 6425, 6427, 6429, 6431, 6433, 6435, 6437, 6439, 6441, 6443, 6444, 6446, 6448, 6450, 6452, 6454, 6456, 6458, 6459, 6461, 6463, 6465, 6467, 6469, 6471, 6472, 6474, 6476, 6478, 6480, 6482, 6483, 6485, 6487, 6489, 6491, 6493, 6494, 6496, 6498, 6500, 6502, 6503, 6505, 6507, 6509, 6510, 6512, 6514, 6516, 6518, 6519, 6521, 6523, 6525, 6526, 6528, 6530, 6532, 6533, 6535, 6537, 6538, 6540, 6542, 6544, 6545, 6547, 6549, 6550, 6552, 6554, 6556, 6557, 6559, 6561, 6562, 6564, 6566, 6567, 6569, 6571, 6572, 6574, 6576, 6577, 6579, 6581, 6582, 6584, 6586, 6587, 6589, 6591, 6592, 6594, 6596, 6597, 6599, 6600, 6602, 6604, 6605, 6607, 6609, 6610, 6612, 6613, 6615, 6617, 6618, 6620, 6621, 6623, 6625, 6626, 6628, 6629, 6631, 6632, 6634, 6636, 6637, 6639, 6640, 6642, 6643, 6645, 6647, 6648, 6650, 6651, 6653, 6654, 6656, 6657, 6659, 6660, 6662, 6663, 6665, 6667, 6668, 6670, 6671, 6673, 6674, 6676, 6677, 6679, 6680, 6682, 6683, 6685, 6686, 6688, 6689, 6691, 6692, 6694, 6695, 6697, 6698, 6699, 6701, 6702, 6704, 6705, 6707, 6708, 6710, 6711, 6713, 6714, 6716, 6717, 6718, 6720, 6721, 6723, 6724, 6726, 6727, 6729, 6730, 6731, 6733, 6734, 6736, 6737, 6739, 6740, 6741, 6743, 6744, 6746, 6747, 6748, 6750, 6751, 6753, 6754, 6755, 6757, 6758, 6760, 6761, 6762, 6764, 6765, 6767, 6768, 6769, 6771, 6772, 6773, 6775, 6776, 6778, 6779, 6780, 6782, 6783, 6784, 6786, 6787, 6788, 6790, 6791, 6793, 6794, 6795, 6797, 6798, 6799, 6801, 6802, 6803, 6805, 6806, 6807, 6809, 6810, 6811, 6813, 6814, 6815, 6816, 6818, 6819, 6820, 6822, 6823, 6824, 6826, 6827, 6828, 6830, 6831, 6832, 6833, 6835, 6836, 6837, 6839, 6840, 6841, 6842, 6844, 6845, 6846, 6848, 6849, 6850, 6851, 6853, 6854, 6855, 6856, 6858, 6859, 6860, 6862, 6863, 6864, 6865, 6867, 6868, 6869, 6870, 6872, 6873, 6874, 6875, 6877, 6878, 6879, 6880, 6882, 6883, 6884, 6885, 6886, 6888, 6889, 6890, 6891, 6893, 6894, 6895, 6896, 6897, 6899, 6900, 6901, 6902, 6904, 6905, 6906, 6907, 6908, 6910, 6911, 6912, 6913, 6914, 6916, 6917, 6918, 6919, 6920, 6921, 6923, 6924, 6925, 6926, 6927, 6929, 6930, 6931, 6932, 6933, 6934, 6936, 6937, 6938, 6939, 6940, 6941, 6943, 6944, 6945, 6946, 6947, 6948, 6950, 6951, 6952, 6953, 6954, 6955, 6957, 6958, 6959, 6960, 6961, 6962, 6963, 6965, 6966, 6967, 6968, 6969, 6970, 6971, 6972, 6974, 6975, 6976, 6977, 6978, 6979, 6980, 6981, 6983, 6984, 6985, 6986, 6987, 6988, 6989, 6990, 6991, 6993, 6994, 6995, 6996, 6997, 6998, 6999, 7000, 7001, 7003, 7004, 7005, 7006, 7007, 7008, 7009, 7010, 7011, 7012, 7013, 7015, 7016, 7017, 7018, 7019, 7020, 7021, 7022, 7023, 7024, 7025, 7026, 7027, 7029, 7030, 7031, 7032, 7033, 7034, 7035, 7036, 7037, 7038, 7039, 7040, 7041, 7042, 7043, 7044, 7046, 7047, 7048, 7049, 7050, 7051, 7052, 7053, 7054, 7055, 7056, 7057, 7058, 7059, 7060, 7061, 7062, 7063, 7064, 7065, 7066, 7067, 7068, 7069, 7070, 7071, 7073, 7074, 7075, 7076, 7077, 7078, 7079, 7080, 7081, 7082, 7083, 7084, 7085, 7086, 7087, 7088, 7089, 7090, 7091, 7092, 7093, 7094, 7095, 7096, 7097, 7098, 7099, 7100, 7101, 7102, 7103, 7104, 7105, 7106, 7107, 7108, 7109, 7110, 7111, 7112, 7113, 7114, 7115, 7116, 7117, 7118, 7119, 7120, 7121, 7122, 7123, 7124, 7124, 7125, 7126, 7127, 7128, 7129, 7130, 7131, 7132, 7133, 7134, 7135, 7136, 7137, 7138, 7139, 7140, 7141, 7142, 7143, 7144, 7145, 7146, 7147, 7148, 7149, 7150, 7150, 7151, 7152, 7153, 7154, 7155, 7156, 7157, 7158, 7159, 7160, 7161, 7162, 7163, 7164, 7165, 7166, 7166, 7167, 7168, 7169, 7170, 7171, 7172, 7173, 7174, 7175, 7176, 7177, 7178, 7179, 7179, 7180, 7181, 7182, 7183, 7184, 7185, 7186, 7187, 7188, 7189, 7190, 7191, 7191, 7192, 7193, 7194, 7195, 7196, 7197, 7198, 7199, 7200, 7201, 7201, 7202, 7203, 7204, 7205, 7206, 7207, 7208, 7209, 7210, 7210, 7211, 7212, 7213, 7214, 7215, 7216, 7217, 7218, 7218, 7219, 7220, 7221, 7222, 7223, 7224, 7225, 7226, 7226, 7227, 7228, 7229, 7230, 7231, 7232, 7233, 7233, 7234, 7235, 7236, 7237, 7238, 7239, 7240, 7240, 7241, 7242, 7243, 7244, 7245, 7246, 7246, 7247, 7248, 7249, 7250, 7251, 7252, 7253, 7253, 7254, 7255, 7256, 7257, 7258, 7259, 7259, 7260, 7261, 7262, 7263, 7264, 7264, 7265, 7266, 7267, 7268, 7269, 7270, 7270, 7271, 7272, 7273, 7274, 7275, 7275, 7276, 7277, 7278, 7279, 7280, 7281, 7281, 7282, 7283, 7284, 7285, 7286, 7286, 7287, 7288, 7289, 7290, 7291, 7291, 7292, 7293, 7294, 7295, 7295, 7296, 7297, 7298, 7299, 7300, 7300, 7301, 7302, 7303, 7304, 7304, 7305, 7306, 7307, 7308, 7309, 7309, 7310, 7311, 7312, 7313, 7313, 7314, 7315, 7316, 7317, 7317, 7318, 7319, 7320, 7321, 7322, 7322, 7323, 7324, 7325, 7326, 7326, 7327, 7328, 7329, 7330, 7330, 7331, 7332, 7333, 7334, 7334, 7335, 7336, 7337, 7337, 7338, 7339, 7340, 7341, 7341, 7342, 7343, 7344, 7345, 7345, 7346, 7347, 7348, 7348, 7349, 7350, 7351, 7352, 7352, 7353, 7354, 7355, 7356, 7356, 7357, 7358, 7359, 7359, 7360, 7361, 7362, 7362, 7363, 7364, 7365, 7366, 7366, 7367, 7368, 7369, 7369, 7370, 7371, 7372, 7372, 7373, 7374, 7375, 7376, 7376, 7377, 7378, 7379, 7379, 7380, 7381, 7382, 7382, 7383, 7384, 7385, 7385, 7386, 7387, 7388, 7388, 7389, 7390, 7391, 7391, 7392, 7393, 7394, 7394, 7395, 7396, 7397, 7397, 7398, 7399, 7400, 7400, 7401, 7402, 7403, 7403, 7404, 7405, 7406, 7406, 7407, 7408, 7409, 7409, 7410, 7411, 7411, 7412, 7413, 7414, 7414, 7415, 7416, 7417, 7417, 7418, 7419, 7420, 7420, 7421, 7422, 7422, 7423, 7424, 7425, 7425, 7426, 7427, 7428, 7428, 7429, 7430, 7430, 7431, 7432, 7433, 7433, 7434, 7435, 7435, 7436, 7437, 7438, 7438, 7439, 7440, 7441, 7441, 7442, 7443, 7443, 7444, 7445, 7446, 7446, 7447, 7448, 7448, 7449, 7450, 7450, 7451, 7452, 7453, 7453, 7454, 7455, 7455, 7456, 7457, 7458, 7458, 7459, 7460, 7460, 7461, 7462, 7462, 7463, 7464, 7465, 7465, 7466, 7467, 7467, 7468, 7469, 7469, 7470, 7471, 7472, 7472, 7473, 7474, 7474, 7475, 7476, 7476, 7477, 7478, 7478, 7479, 7480, 7481, 7481, 7482, 7483, 7483, 7484, 7485, 7485, 7486, 7487, 7487, 7488, 7489, 7489, 7490, 7491, 7491, 7492, 7493, 7494, 7494, 7495, 7496, 7496, 7497, 7498, 7498, 7499, 7500, 7500, 7501, 7502, 7502, 7503, 7504, 7504, 7505, 7506, 7506, 7507, 7508, 7508, 7509, 7510, 7510, 7511, 7512, 7512, 7513, 7514, 7514, 7515, 7516, 7516, 7517, 7518, 7518, 7519, 7520, 7520, 7521, 7522, 7522, 7523, 7524, 7524, 7525, 7526, 7526, 7527, 7528, 7528, 7529, 7530, 7530, 7531, 7532, 7532, 7533, 7533, 7534, 7535, 7535, 7536, 7537, 7537, 7538, 7539, 7539, 7540, 7541, 7541, 7542, 7543, 7543, 7544, 7545, 7545, 7546, 7546, 7547, 7548, 7548, 7549, 7550, 7550, 7551, 7552, 7552, 7553, 7554, 7554, 7555, 7555, 7556, 7557, 7557, 7558, 7559, 7559, 7560, 7561, 7561, 7562, 7562, 7563, 7564, 7564, 7565, 7566, 7566, 7567, 7568, 7568, 7569, 7569, 7570, 7571, 7571, 7572, 7573, 7573, 7574, 7574, 7575, 7576, 7576, 7577, 7578, 7578, 7579, 7579, 7580, 7581, 7581, 7582, 7583, 7583, 7584, 7584, 7585, 7586, 7586, 7587, 7588, 7588, 7589, 7589, 7590, 7591, 7591, 7592, 7593, 7593, 7594, 7594, 7595, 7596, 7596, 7597, 7597, 7598, 7599, 7599, 7600, 7601, 7601, 7602, 7602, 7603, 7604, 7604, 7605, 7605, 7606, 7607, 7607, 7608, 7608, 7609, 7610, 7610, 7611, 7611, 7612, 7613, 7613, 7614, 7614, 7615, 7616, 7616, 7617, 7618, 7618, 7619, 7619, 7620, 7621, 7621, 7622, 7622, 7623, 7624, 7624, 7625, 7625, 7626, 7626, 7627, 7628, 7628, 7629, 7629, 7630, 7631, 7631, 7632, 7632, 7633, 7634, 7634, 7635, 7635, 7636, 7637, 7637, 7638, 7638, 7639, 7640, 7640, 7641, 7641, 7642, 7642, 7643, 7644, 7644, 7645, 7645, 7646, 7647, 7647, 7648, 7648, 7649, 7650, 7650, 7651, 7651, 7652, 7652, 7653, 7654, 7654, 7655, 7655, 7656, 7656, 7657, 7658, 7658, 7659, 7659, 7660, 7661, 7661, 7662, 7662, 7663, 7663, 7664, 7665, 7665, 7666, 7666, 7667, 7667, 7668, 7669, 7669, 7670, 7670, 7671, 7671, 7672, 7673, 7673, 7674, 7674, 7675, 7675, 7676, 7677, 7677, 7678, 7678, 7679, 7679, 7680, 7681, 7681, 7682, 7682, 7683, 7683, 7684, 7684, 7685, 7686, 7686, 7687, 7687, 7688, 7688, 7689, 7690, 7690, 7691, 7691, 7692, 7692, 7693, 7693, 7694, 7695, 7695, 7696, 7696, 7697, 7697, 7698, 7698, 7699, 7700, 7700, 7701, 7701, 7702, 7702, 7703, 7703, 7704, 7705, 7705, 7706, 7706, 7707, 7707, 7708, 7708, 7709, 7710, 7710, 7711, 7711, 7712, 7712, 7713, 7713, 7714, 7715, 7715, 7716, 7716, 7717, 7717, 7718, 7718, 7719, 7719, 7720, 7721, 7721, 7722, 7722, 7723, 7723, 7724, 7724, 7725, 7725, 7726, 7726, 7727, 7728, 7728, 7729, 7729, 7730, 7730, 7731, 7731, 7732, 7732, 7733, 7733, 7734, 7735, 7735, 7736, 7736, 7737, 7737, 7738, 7738, 7739, 7739, 7740, 7740, 7741, 7742, 7742, 7743, 7743, 7744, 7744, 7745, 7745, 7746, 7746, 7747, 7747, 7748, 7748, 7749, 7749, 7750, 7751, 7751, 7752, 7752, 7753, 7753, 7754, 7754, 7755, 7755, 7756, 7756, 7757, 7757, 7758, 7758, 7759, 7759, 7760, 7761, 7761, 7762, 7762, 7763, 7763, 7764, 7764, 7765, 7765, 7766, 7766, 7767, 7767, 7768, 7768, 7769, 7769, 7770, 7770, 7771, 7771, 7772, 7773, 7773, 7774, 7774, 7775, 7775, 7776, 7776, 7777, 7777, 7778, 7778, 7779, 7779, 7780, 7780, 7781, 7781, 7782, 7782, 7783, 7783, 7784, 7784, 7785, 7785, 7786, 7786, 7787, 7787, 7788, 7788, 7789, 7789, 7790, 7790, 7791, 7791, 7792, 7792, 7793, 7794, 7794, 7795, 7795, 7796, 7796, 7797, 7797, 7798, 7798, 7799, 7799, 7800, 7800, 7801, 7801, 7802, 7802, 7803, 7803, 7804, 7804, 7805, 7805, 7806, 7806, 7807, 7807, 7808, 7808, 7809, 7809, 7810, 7810, 7811, 7811, 7812, 7812, 7813, 7813, 7814, 7814, 7815, 7815, 7816, 7816, 7817, 7817, 7818, 7818, 7819, 7819, 7820, 7820, 7821, 7821, 7822, 7822, 7823, 7823, 7823, 7824, 7824, 7825, 7825, 7826, 7826, 7827, 7827, 7828, 7828, 7829, 7829, 7830, 7830, 7831, 7831, 7832, 7832, 7833, 7833, 7834, 7834, 7835, 7835, 7836, 7836, 7837, 7837, 7838, 7838, 7839, 7839, 7840, 7840, 7841, 7841, 7842, 7842, 7843, 7843, 7843, 7844, 7844, 7845, 7845, 7846, 7846, 7847, 7847, 7848, 7848, 7849, 7849, 7850, 7850, 7851, 7851, 7852, 7852, 7853, 7853, 7854, 7854, 7855, 7855, 7855, 7856, 7856, 7857, 7857, 7858, 7858, 7859, 7859, 7860, 7860, 7861, 7861, 7862, 7862, 7863, 7863, 7864, 7864, 7864, 7865, 7865, 7866, 7866, 7867, 7867, 7868, 7868, 7869, 7869, 7870, 7870, 7871, 7871, 7872, 7872, 7873, 7873, 7873, 7874, 7874, 7875, 7875, 7876, 7876, 7877, 7877, 7878, 7878, 7879, 7879, 7880, 7880, 7880, 7881, 7881, 7882, 7882, 7883, 7883, 7884, 7884, 7885, 7885, 7886, 7886, 7886, 7887, 7887, 7888, 7888, 7889, 7889, 7890, 7890, 7891, 7891, 7892, 7892, 7892, 7893, 7893, 7894, 7894, 7895, 7895, 7896, 7896, 7897, 7897, 7898, 7898, 7898, 7899, 7899, 7900, 7900, 7901, 7901, 7902, 7902, 7903, 7903, 7903, 7904, 7904, 7905, 7905, 7906, 7906, 7907, 7907, 7908, 7908, 7908, 7909, 7909, 7910, 7910, 7911, 7911, 7912, 7912, 7913, 7913, 7913, 7914, 7914, 7915, 7915, 7916, 7916, 7917, 7917, 7917, 7918, 7918, 7919, 7919, 7920, 7920, 7921, 7921, 7922, 7922, 7922, 7923, 7923, 7924, 7924, 7925, 7925, 7926, 7926, 7926, 7927, 7927, 7928, 7928, 7929, 7929, 7930, 7930, 7930, 7931, 7931, 7932, 7932, 7933, 7933, 7934, 7934, 7934, 7935, 7935, 7936, 7936, 7937, 7937, 7938, 7938, 7938, 7939, 7939, 7940, 7940, 7941, 7941, 7941, 7942, 7942, 7943, 7943, 7944, 7944, 7945, 7945, 7945, 7946, 7946, 7947, 7947, 7948, 7948, 7948, 7949, 7949, 7950, 7950, 7951, 7951, 7952, 7952, 7952, 7953, 7953, 7954, 7954, 7955, 7955, 7955, 7956, 7956, 7957, 7957, 7958, 7958, 7958, 7959, 7959, 7960, 7960, 7961, 7961, 7961, 7962, 7962, 7963, 7963, 7964, 7964, 7964, 7965, 7965, 7966, 7966, 7967, 7967, 7967, 7968, 7968, 7969, 7969, 7970, 7970, 7970, 7971, 7971, 7972, 7972, 7973, 7973, 7973, 7974, 7974, 7975, 7975, 7976, 7976, 7976, 7977, 7977, 7978, 7978, 7979, 7979, 7979, 7980, 7980, 7981, 7981, 7981, 7982, 7982, 7983, 7983, 7984, 7984, 7984, 7985, 7985, 7986, 7986, 7987, 7987, 7987, 7988, 7988, 7989, 7989, 7989, 7990, 7990, 7991, 7991, 7992, 7992, 7992, 7993, 7993, 7994, 7994, 7994, 7995, 7995, 7996, 7996, 7997, 7997, 7997, 7998, 7998, 7999, 7999, 7999, 8000, 8000, 8001, 8001, 8002, 8002, 8002, 8003, 8003, 8004, 8004, 8004, 8005, 8005, 8006, 8006, 8006, 8007, 8007, 8008, 8008, 8009, 8009, 8009, 8010, 8010, 8011, 8011, 8011, 8012, 8012, 8013, 8013, 8013, 8014, 8014, 8015, 8015, 8016, 8016, 8016, 8017, 8017, 8018, 8018, 8018, 8019, 8019, 8020, 8020, 8020, 8021, 8021, 8022, 8022, 8022, 8023, 8023, 8024, 8024, 8024, 8025, 8025, 8026, 8026, 8026, 8027, 8027, 8028, 8028, 8028, 8029, 8029, 8030, 8030, 8030, 8031, 8031, 8032, 8032, 8033, 8033, 8033, 8034, 8034, 8035, 8035, 8035, 8036, 8036, 8037, 8037, 8037, 8038, 8038, 8039, 8039, 8039, 8040, 8040, 8040, 8041, 8041, 8042, 8042, 8042, 8043, 8043, 8044, 8044, 8044, 8045, 8045, 8046, 8046, 8046, 8047, 8047, 8048, 8048, 8048, 8049, 8049, 8050, 8050, 8050, 8051, 8051, 8052, 8052, 8052, 8053, 8053, 8054, 8054, 8054, 8055, 8055, 8056, 8056, 8056, 8057, 8057, 8057, 8058, 8058, 8059, 8059, 8059, 8060, 8060, 8061, 8061, 8061, 8062, 8062, 8063, 8063, 8063, 8064, 8064, 8065, 8065, 8065, 8066, 8066, 8066, 8067, 8067, 8068, 8068, 8068, 8069, 8069, 8070, 8070, 8070, 8071, 8071, 8071, 8072, 8072, 8073, 8073, 8073, 8074, 8074, 8075, 8075, 8075, 8076, 8076, 8077, 8077, 8077, 8078, 8078, 8078, 8079, 8079, 8080, 8080, 8080, 8081, 8081, 8081, 8082, 8082, 8083, 8083, 8083, 8084, 8084, 8085, 8085, 8085, 8086, 8086, 8086, 8087, 8087, 8088, 8088, 8088, 8089, 8089, 8089, 8090, 8090, 8091, 8091, 8091, 8092, 8092, 8093, 8093, 8093, 8094, 8094, 8094, 8095, 8095, 8096, 8096, 8096, 8097, 8097, 8097, 8098, 8098, 8099, 8099, 8099, 8100, 8100, 8100, 8101, 8101, 8102, 8102, 8102, 8103, 8103, 8103, 8104, 8104, 8105, 8105, 8105, 8106, 8106, 8106, 8107, 8107, 8108, 8108, 8108, 8109, 8109, 8109, 8110, 8110, 8111, 8111, 8111, 8112, 8112, 8112, 8113, 8113, 8114, 8114, 8114, 8115, 8115, 8115, 8116, 8116, 8116, 8117, 8117, 8118, 8118, 8118, 8119, 8119, 8119, 8120, 8120, 8121, 8121, 8121, 8122, 8122, 8122, 8123, 8123, 8123, 8124, 8124, 8125, 8125, 8125, 8126, 8126, 8126, 8127, 8127, 8128, 8128, 8128, 8129, 8129, 8129, 8130, 8130, 8130, 8131, 8131, 8132, 8132, 8132, 8133, 8133, 8133, 8134, 8134, 8134, 8135, 8135, 8136, 8136, 8136, 8137, 8137, 8137, 8138, 8138, 8138, 8139, 8139, 8140, 8140, 8140, 8141, 8141, 8141, 8142, 8142, 8142, 8143, 8143, 8143, 8144, 8144, 8145, 8145, 8145, 8146, 8146, 8146, 8147, 8147, 8147, 8148, 8148, 8149, 8149, 8149, 8150, 8150, 8150, 8151, 8151, 8151, 8152, 8152, 8152, 8153, 8153, 8154, 8154, 8154, 8155, 8155, 8155, 8156, 8156, 8156, 8157, 8157, 8157, 8158, 8158, 8158, 8159, 8159, 8160, 8160, 8160, 8161, 8161, 8161, 8162, 8162, 8162, 8163, 8163, 8163, 8164, 8164, 8165, 8165, 8165, 8166, 8166, 8166, 8167, 8167, 8167, 8168, 8168, 8168, 8169, 8169, 8169, 8170, 8170, 8170, 8171, 8171, 8172, 8172, 8172, 8173, 8173, 8173, 8174, 8174, 8174, 8175, 8175, 8175, 8176, 8176, 8176, 8177, 8177, 8177, 8178, 8178, 8179, 8179, 8179, 8180, 8180, 8180, 8181, 8181, 8181, 8182, 8182, 8182, 8183, 8183, 8183, 8184, 8184, 8184, 8185, 8185, 8185, 8186, 8186, 8187, 8187, 8187, 8188, 8188, 8188, 8189, 8189, 8189, 8190, 8190, 8190, 8191, 8191, 8191, 8192, 8192, 8192, 8193, 8193, 8193, 8194, 8194, 8194, 8195, 8195, 8195, 8196, 8196, 8196, 8197, 8197, 8197, 8198, 8198, 8199, 8199, 8199, 8200, 8200, 8200, 8201, 8201, 8201, 8202, 8202, 8202, 8203, 8203, 8203, 8204, 8204, 8204, 8205, 8205, 8205, 8206, 8206, 8206, 8207, 8207, 8207, 8208, 8208, 8208, 8209, 8209, 8209, 8210, 8210, 8210, 8211, 8211, 8211, 8212, 8212, 8212, 8213, 8213, 8213, 8214, 8214, 8214, 8215, 8215, 8215, 8216, 8216, 8216, 8217, 8217, 8217, 8218, 8218, 8218, 8219, 8219, 8219, 8220, 8220, 8220, 8221, 8221, 8221, 8222, 8222, 8222, 8223, 8223, 8223, 8224, 8224, 8224, 8225, 8225, 8225, 8226, 8226, 8226, 8227, 8227, 8227, 8228, 8228, 8228, 8229, 8229, 8229, 8230, 8230, 8230, 8231, 8231, 8231, 8232, 8232, 8232, 8233, 8233, 8233, 8234, 8234, 8234, 8235, 8235, 8235, 8236, 8236, 8236, 8237, 8237, 8237, 8238, 8238, 8238, 8239, 8239, 8239, 8240, 8240, 8240, 8241, 8241, 8241, 8242, 8242, 8242, 8243, 8243, 8243, 8244, 8244, 8244, 8245, 8245, 8245, 8246, 8246, 8246, 8247, 8247, 8247, 8248, 8248, 8248, 8248, 8249, 8249, 8249, 8250, 8250, 8250, 8251, 8251, 8251, 8252, 8252, 8252, 8253, 8253, 8253, 8254, 8254, 8254, 8255, 8255, 8255, 8256, 8256, 8256, 8257, 8257, 8257, 8258, 8258, 8258, 8259, 8259, 8259, 8259, 8260, 8260, 8260, 8261, 8261, 8261, 8262, 8262, 8262, 8263, 8263, 8263, 8264, 8264, 8264, 8265, 8265, 8265, 8266, 8266, 8266, 8267, 8267, 8267, 8267, 8268, 8268, 8268, 8269, 8269, 8269, 8270, 8270, 8270, 8271, 8271, 8271, 8272, 8272, 8272, 8273, 8273, 8273, 8274, 8274, 8274, 8274, 8275, 8275, 8275, 8276, 8276, 8276, 8277, 8277, 8277, 8278, 8278, 8278, 8279, 8279, 8279, 8280, 8280, 8280, 8280, 8281, 8281, 8281, 8282, 8282, 8282, 8283, 8283, 8283, 8284, 8284, 8284, 8285, 8285, 8285, 8286, 8286, 8286, 8286, 8287, 8287, 8287, 8288, 8288, 8288, 8289, 8289, 8289, 8290, 8290, 8290, 8291, 8291, 8291, 8291, 8292, 8292, 8292, 8293, 8293, 8293, 8294, 8294, 8294, 8295, 8295, 8295, 8295, 8296, 8296, 8296, 8297, 8297, 8297, 8298, 8298, 8298, 8299, 8299, 8299, 8300, 8300, 8300, 8300, 8301, 8301, 8301, 8302, 8302, 8302, 8303, 8303, 8303, 8304, 8304, 8304, 8304, 8305, 8305, 8305, 8306, 8306, 8306, 8307, 8307, 8307, 8308, 8308, 8308, 8308, 8309, 8309, 8309, 8310, 8310, 8310, 8311, 8311, 8311, 8312, 8312, 8312, 8312, 8313, 8313, 8313, 8314, 8314, 8314, 8315, 8315, 8315, 8315, 8316, 8316, 8316, 8317, 8317, 8317, 8318, 8318, 8318, 8319, 8319, 8319, 8319, 8320, 8320, 8320, 8321, 8321, 8321, 8322, 8322, 8322, 8322, 8323, 8323, 8323, 8324, 8324, 8324, 8325, 8325, 8325, 8325, 8326, 8326, 8326, 8327, 8327, 8327, 8328, 8328, 8328, 8328, 8329, 8329, 8329, 8330, 8330, 8330, 8331, 8331, 8331, 8331, 8332, 8332, 8332, 8333, 8333, 8333, 8334, 8334, 8334, 8334, 8335, 8335, 8335, 8336, 8336, 8336, 8337, 8337, 8337, 8337, 8338, 8338, 8338, 8339, 8339, 8339, 8340, 8340, 8340, 8340, 8341, 8341, 8341, 8342, 8342, 8342, 8343, 8343, 8343, 8343, 8344, 8344, 8344, 8345, 8345, 8345, 8345, 8346, 8346, 8346, 8347, 8347, 8347, 8348, 8348, 8348, 8348, 8349, 8349, 8349, 8350, 8350, 8350, 8351, 8351, 8351, 8351, 8352, 8352, 8352, 8353, 8353, 8353, 8353, 8354, 8354, 8354, 8355, 8355, 8355, 8355, 8356, 8356, 8356, 8357, 8357, 8357, 8358, 8358, 8358, 8358, 8359, 8359, 8359, 8360, 8360, 8360, 8360, 8361, 8361, 8361, 8362, 8362, 8362, 8362, 8363, 8363, 8363, 8364, 8364, 8364, 8365, 8365, 8365, 8365, 8366, 8366, 8366, 8367, 8367, 8367, 8367, 8368, 8368, 8368, 8369, 8369, 8369, 8369, 8370, 8370, 8370, 8371, 8371, 8371, 8371, 8372, 8372, 8372, 8373, 8373, 8373, 8373, 8374, 8374, 8374, 8375, 8375, 8375, 8376, 8376, 8376, 8376, 8377, 8377, 8377, 8378, 8378, 8378, 8378, 8379, 8379, 8379, 8380, 8380, 8380, 8380, 8381, 8381, 8381, 8382, 8382, 8382, 8382, 8383, 8383, 8383, 8384, 8384, 8384, 8384, 8385, 8385, 8385, 8386, 8386, 8386, 8386, 8387, 8387, 8387, 8387, 8388, 8388, 8388, 8389, 8389, 8389, 8389, 8390, 8390, 8390, 8391, 8391, 8391, 8391, 8392, 8392, 8392, 8393, 8393, 8393, 8393, 8394, 8394, 8394, 8395, 8395, 8395, 8395, 8396, 8396, 8396, 8397, 8397, 8397, 8397, 8398, 8398, 8398, 8399, 8399, 8399, 8399, 8400, 8400, 8400, 8400, 8401, 8401, 8401, 8402, 8402, 8402, 8402, 8403, 8403, 8403, 8404, 8404, 8404, 8404, 8405, 8405, 8405, 8405, 8406, 8406, 8406, 8407, 8407, 8407, 8407, 8408, 8408, 8408, 8409, 8409, 8409, 8409, 8410, 8410, 8410, 8411, 8411, 8411, 8411, 8412, 8412, 8412, 8412, 8413, 8413, 8413, 8414, 8414, 8414, 8414, 8415, 8415, 8415, 8415, 8416, 8416, 8416, 8417, 8417, 8417, 8417, 8418, 8418, 8418, 8419, 8419, 8419, 8419, 8420, 8420, 8420, 8420, 8421, 8421, 8421, 8422, 8422, 8422, 8422, 8423, 8423, 8423, 8423, 8424, 8424, 8424, 8425, 8425, 8425, 8425, 8426, 8426, 8426, 8426, 8427, 8427, 8427, 8428, 8428, 8428, 8428, 8429, 8429, 8429, 8429, 8430, 8430, 8430, 8431, 8431, 8431, 8431, 8432, 8432, 8432, 8432, 8433, 8433, 8433, 8434, 8434, 8434, 8434, 8435, 8435, 8435, 8435, 8436, 8436, 8436, 8437, 8437, 8437, 8437, 8438, 8438, 8438, 8438, 8439, 8439, 8439, 8440, 8440, 8440, 8440, 8441, 8441, 8441, 8441, 8442, 8442, 8442, 8442, 8443, 8443, 8443, 8444, 8444, 8444, 8444, 8445, 8445, 8445, 8445, 8446, 8446, 8446, 8446, 8447, 8447, 8447, 8448, 8448, 8448, 8448, 8449, 8449, 8449, 8449, 8450, 8450, 8450, 8451, 8451, 8451, 8451, 8452, 8452, 8452, 8452, 8453, 8453, 8453, 8453, 8454, 8454, 8454, 8455, 8455, 8455, 8455, 8456, 8456, 8456, 8456, 8457, 8457, 8457, 8457, 8458, 8458, 8458, 8458, 8459, 8459, 8459, 8460, 8460, 8460, 8460, 8461, 8461, 8461, 8461, 8462, 8462, 8462, 8462, 8463, 8463, 8463, 8463, 8464, 8464, 8464, 8465, 8465, 8465, 8465, 8466, 8466, 8466, 8466, 8467, 8467, 8467, 8467, 8468, 8468, 8468, 8468, 8469, 8469, 8469, 8470, 8470, 8470, 8470, 8471, 8471, 8471, 8471, 8472, 8472, 8472, 8472, 8473, 8473, 8473, 8473, 8474, 8474, 8474, 8475, 8475, 8475, 8475, 8476, 8476, 8476, 8476, 8477, 8477, 8477, 8477, 8478, 8478, 8478, 8478, 8479, 8479, 8479, 8479, 8480, 8480, 8480, 8480, 8481, 8481, 8481, 8482, 8482, 8482, 8482, 8483, 8483, 8483, 8483, 8484, 8484, 8484, 8484, 8485, 8485, 8485, 8485, 8486, 8486, 8486, 8486, 8487, 8487, 8487, 8487, 8488, 8488, 8488, 8488, 8489, 8489, 8489, 8490, 8490, 8490, 8490, 8491, 8491, 8491, 8491, 8492, 8492, 8492, 8492, 8493, 8493, 8493, 8493, 8494, 8494, 8494, 8494, 8495, 8495, 8495, 8495, 8496, 8496, 8496, 8496, 8497, 8497, 8497, 8497, 8498, 8498, 8498, 8498, 8499, 8499, 8499, 8499, 8500, 8500, 8500, 8501, 8501, 8501, 8501, 8502, 8502, 8502, 8502, 8503, 8503, 8503, 8503, 8504, 8504, 8504, 8504, 8505, 8505, 8505, 8505, 8506, 8506, 8506, 8506, 8507, 8507, 8507, 8507, 8508, 8508, 8508, 8508, 8509, 8509, 8509, 8509, 8510, 8510, 8510, 8510, 8511, 8511, 8511, 8511, 8512, 8512, 8512, 8512, 8513, 8513, 8513, 8513, 8514, 8514, 8514, 8514, 8515, 8515, 8515, 8515, 8516, 8516, 8516, 8516, 8517, 8517, 8517, 8517 }; /*0*/

void create_lookup_log(log_table_info *logtab, int num_bits)
{
  int     ii;
  double  val;

  ASSERT(logtab);

  logtab->size = 0x01 << num_bits;
  logtab->mask = 0x01;
  for (ii = 0; ii < num_bits; ii++) /* one less than the table size in
            order to do rounding off */
    logtab->mask = (logtab->mask << 1) | 0x01;
  logtab->mask = ~logtab->mask;

  logtab->scale = LOG_SCALE;
  val = LOG_SCALE * log((double)2.0);
  logtab->shift = (int)(val + 0.5);
  if( DO_USE_LOGTAB__TABLE  ) {
	logtab->table = logtab__table;
  } else {
    int* table = (int *) CALLOC(logtab->size + 1, sizeof(int), "cfront.logtable");
    logtab->table = table;
	PRINT_SOME_CODE("#define DO_USE_LOGTAB__TABLE ( (logtab->size == %d) \\\n", logtab->size);
	PRINT_SOME_CODE("  && LOG_SCALE == %d ) \n", LOG_SCALE);
	PRINT_SOME_CODE("int logtab__table[%d] = { 0, ", logtab->size); /* filler for pos 0 */
	for (ii = 1; ii <= logtab->size; ii++)
	{
		val = LOG_SCALE * log((double) ii);
		table[ii] = (int)(val + 0.5);
	#if DEBUG
		log_report("log table: %d %d\n", ii, table[ii]);
	#endif
		PRINT_SOME_CODE(" %i,", table[ii]);
	}
	PRINT_SOME_CODE(" }; /*%i*/\n", 0);
  }
  return;
}

int log_lookup(log_table_info *logtab, int operand, int shift)
/*
**  Log functioin, value scaled up LOG_SCALE */
{
  ASSERT(logtab);
  if (operand <= 0)
    operand = 1;
  while ((operand & logtab->mask))
  {
    operand >>= 1;
    shift++;
  }
  if (operand >= logtab->size)
  {     /* rounding off */
    shift++;
    operand = (operand + 1) >> 1;
  }
#if DEBUG
  log_report("tab: %d %d -> %d\n", operand, shift,
             (int)((shift) *(logtab->shift) + logtab->table[operand]));
#endif
  return ((int)((shift) *(logtab->shift) + logtab->table[operand]));
}

void destroy_lookup_log(log_table_info *logtab)
{
  ASSERT(logtab);
  ASSERT(logtab->table);
  if( !DO_USE_LOGTAB__TABLE ) {
	  FREE((char *)logtab->table);
  }
  return;
}

int integer_square_root(int operand)
/*
**  based on algorithm by Tony barrera amd Pelle Olsson */
{
  int ii, aa, bb, cc, value, shift;

  if (operand <= 0)
    return (0); /* TODO: is this a legal value for negatives */
  value = 0x02;
  shift = 0;
  while (value < operand)
  {
    shift++;
    value <<= 1;
  }
  shift >>= 1;

  value = 0x01 << (2 * shift);
  aa = value;
  bb = value;
  cc = value >> 2;
  value = aa + bb + cc;

  for (ii = 0; ii < shift; ii++)
  {
    bb = (bb >> 1);
    if (value <= operand)
    {
      aa = value;
      bb += cc;
    }
    cc >>= 2;
    value = aa + bb + cc;
  }
  return (bb);
}
