/* ------------------------------------------------------------------
 * Copyright (C) 1998-2009 PacketVideo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 * -------------------------------------------------------------------
 */
/*

 Filename: s_ch_info.h

------------------------------------------------------------------------------
 INCLUDE DESCRIPTION

 This include file defines the structure, Ch_Info

------------------------------------------------------------------------------
*/

/*----------------------------------------------------------------------------
; CONTINUE ONLY IF NOT ALREADY DEFINED
----------------------------------------------------------------------------*/
#ifndef S_CH_INFO_H
#define S_CH_INFO_H

/*----------------------------------------------------------------------------
; INCLUDES
----------------------------------------------------------------------------*/
#include "pv_audio_type_defs.h"

/*----------------------------------------------------------------------------
; MACROS
; Define module specific macros here
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
; DEFINES
; Include all pre-processor statements here.
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
; EXTERNAL VARIABLES REFERENCES
; Declare variables used in this module but defined elsewhere
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
; SIMPLE TYPEDEF'S
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
; ENUMERATED TYPEDEF'S
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
; STRUCTURES TYPEDEF'S
----------------------------------------------------------------------------*/

typedef struct
{
//    Int present;    /* channel present */
    Int tag;        /* element tag */
    Int cpe;        /* 0 if single channel, 1 if channel pair */
//    Int common_window;  /* 1 if common window for cpe */
//    Int ch_is_left; /* 1 if left channel of cpe */
//    Int paired_ch;  /* index of paired channel in cpe */
//    Int widx;       /* window element index for this channel */
    Int is_present; /* intensity stereo is used */
    Int ncch;       /* number of coupling channels for this ch */
    /* #if (CChans > 0) */
    /*    int cch[CChans];*/    /* coupling channel idx */
    /*    int cc_dom[CChans];*/ /* coupling channel domain */
    /*    int cc_ind[CChans];*/ /* independently switched coupling channel flag */
    /* #endif */
    Char *fext;     /* filename extension */

} Ch_Info;

/*----------------------------------------------------------------------------
; GLOBAL FUNCTION DEFINITIONS
; Function Prototype declaration
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
; END
----------------------------------------------------------------------------*/
#endif

