/* ------------------------------------------------------------------
 * Copyright (C) 1998-2009 PacketVideo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 * -------------------------------------------------------------------
 */
// ============================================================(Auto)=
// FILE: h245_encoder.h
//
// DESC: PER Encode routines for H.245
// -------------------------------------------------------------------
//  Copyright (c) 1998- 2000, PacketVideo Corporation.
//                   All Rights Reserved.
// ===================================================================

#ifndef PER_ENCODER
#define PER_ENCODER

void Encode_MultimediaSystemControlMessage(PS_MultimediaSystemControlMessage x, PS_OutStream stream);
void Encode_RequestMessage(PS_RequestMessage x, PS_OutStream stream);
void Encode_ResponseMessage(PS_ResponseMessage x, PS_OutStream stream);
void Encode_CommandMessage(PS_CommandMessage x, PS_OutStream stream);
void Encode_IndicationMessage(PS_IndicationMessage x, PS_OutStream stream);
void Encode_GenericInformation(PS_GenericInformation x, PS_OutStream stream);
void Encode_NonStandardMessage(PS_NonStandardMessage x, PS_OutStream stream);
void Encode_NonStandardParameter(PS_NonStandardParameter x, PS_OutStream stream);
void Encode_NonStandardIdentifier(PS_NonStandardIdentifier x, PS_OutStream stream);
void Encode_H221NonStandard(PS_H221NonStandard x, PS_OutStream stream);
void Encode_MasterSlaveDetermination(PS_MasterSlaveDetermination x, PS_OutStream stream);
void Encode_MasterSlaveDeterminationAck(PS_MasterSlaveDeterminationAck x, PS_OutStream stream);
void Encode_Decision(PS_Decision x, PS_OutStream stream);
void Encode_MasterSlaveDeterminationReject(PS_MasterSlaveDeterminationReject x, PS_OutStream stream);
void Encode_MsdRejectCause(PS_MsdRejectCause x, PS_OutStream stream);
void Encode_MasterSlaveDeterminationRelease(PS_MasterSlaveDeterminationRelease x, PS_OutStream stream);
void Encode_TerminalCapabilitySet(PS_TerminalCapabilitySet x, PS_OutStream stream);
void Encode_CapabilityTableEntry(PS_CapabilityTableEntry x, PS_OutStream stream);
void Encode_CapabilityDescriptor(PS_CapabilityDescriptor x, PS_OutStream stream);
void Encode_AlternativeCapabilitySet(PS_AlternativeCapabilitySet x, PS_OutStream stream);
void Encode_TerminalCapabilitySetAck(PS_TerminalCapabilitySetAck x, PS_OutStream stream);
void Encode_TerminalCapabilitySetReject(PS_TerminalCapabilitySetReject x, PS_OutStream stream);
void Encode_TcsRejectCause(PS_TcsRejectCause x, PS_OutStream stream);
void Encode_TableEntryCapacityExceeded(PS_TableEntryCapacityExceeded x, PS_OutStream stream);
void Encode_TerminalCapabilitySetRelease(PS_TerminalCapabilitySetRelease x, PS_OutStream stream);
void Encode_Capability(PS_Capability x, PS_OutStream stream);
void Encode_H233EncryptionReceiveCapability(PS_H233EncryptionReceiveCapability x, PS_OutStream stream);
void Encode_H235SecurityCapability(PS_H235SecurityCapability x, PS_OutStream stream);
void Encode_MultiplexCapability(PS_MultiplexCapability x, PS_OutStream stream);
void Encode_H222Capability(PS_H222Capability x, PS_OutStream stream);
void Encode_VCCapability(PS_VCCapability x, PS_OutStream stream);
void Encode_Aal1ViaGateway(PS_Aal1ViaGateway x, PS_OutStream stream);
void Encode_AvailableBitRates(PS_AvailableBitRates x, PS_OutStream stream);
void Encode_VccAal5Type(PS_VccAal5Type x, PS_OutStream stream);
void Encode_RangeOfBitRates(PS_RangeOfBitRates x, PS_OutStream stream);
void Encode_VccAal5(PS_VccAal5 x, PS_OutStream stream);
void Encode_VccAal1(PS_VccAal1 x, PS_OutStream stream);
void Encode_H223Capability(PS_H223Capability x, PS_OutStream stream);
void Encode_MobileOperationTransmitCapability(PS_MobileOperationTransmitCapability x, PS_OutStream stream);
void Encode_H223MultiplexTableCapability(PS_H223MultiplexTableCapability x, PS_OutStream stream);
void Encode_Enhanced(PS_Enhanced x, PS_OutStream stream);
void Encode_H223AnnexCCapability(PS_H223AnnexCCapability x, PS_OutStream stream);
void Encode_V76Capability(PS_V76Capability x, PS_OutStream stream);
void Encode_V75Capability(PS_V75Capability x, PS_OutStream stream);
void Encode_H2250Capability(PS_H2250Capability x, PS_OutStream stream);
void Encode_McCapability(PS_McCapability x, PS_OutStream stream);
void Encode_MediaPacketizationCapability(PS_MediaPacketizationCapability x, PS_OutStream stream);
void Encode_RSVPParameters(PS_RSVPParameters x, PS_OutStream stream);
void Encode_QOSMode(PS_QOSMode x, PS_OutStream stream);
void Encode_ATMParameters(PS_ATMParameters x, PS_OutStream stream);
void Encode_QOSCapability(PS_QOSCapability x, PS_OutStream stream);
void Encode_MediaTransportType(PS_MediaTransportType x, PS_OutStream stream);
void Encode_Atm_AAL5_compressed(PS_Atm_AAL5_compressed x, PS_OutStream stream);
void Encode_MediaChannelCapability(PS_MediaChannelCapability x, PS_OutStream stream);
void Encode_TransportCapability(PS_TransportCapability x, PS_OutStream stream);
void Encode_RedundancyEncodingCapability(PS_RedundancyEncodingCapability x, PS_OutStream stream);
void Encode_RedundancyEncodingMethod(PS_RedundancyEncodingMethod x, PS_OutStream stream);
void Encode_RTPH263VideoRedundancyEncoding(PS_RTPH263VideoRedundancyEncoding x, PS_OutStream stream);
void Encode_FrameToThreadMapping(PS_FrameToThreadMapping x, PS_OutStream stream);
void Encode_RTPH263VideoRedundancyFrameMapping(PS_RTPH263VideoRedundancyFrameMapping x, PS_OutStream stream);
void Encode_MultipointCapability(PS_MultipointCapability x, PS_OutStream stream);
void Encode_MediaDistributionCapability(PS_MediaDistributionCapability x, PS_OutStream stream);
void Encode_VideoCapability(PS_VideoCapability x, PS_OutStream stream);
void Encode_H261VideoCapability(PS_H261VideoCapability x, PS_OutStream stream);
void Encode_H262VideoCapability(PS_H262VideoCapability x, PS_OutStream stream);
void Encode_H263VideoCapability(PS_H263VideoCapability x, PS_OutStream stream);
void Encode_EnhancementLayerInfo(PS_EnhancementLayerInfo x, PS_OutStream stream);
void Encode_BEnhancementParameters(PS_BEnhancementParameters x, PS_OutStream stream);
void Encode_EnhancementOptions(PS_EnhancementOptions x, PS_OutStream stream);
void Encode_H263Options(PS_H263Options x, PS_OutStream stream);
void Encode_TransparencyParameters(PS_TransparencyParameters x, PS_OutStream stream);
void Encode_RefPictureSelection(PS_RefPictureSelection x, PS_OutStream stream);
void Encode_VideoBackChannelSend(PS_VideoBackChannelSend x, PS_OutStream stream);
void Encode_AdditionalPictureMemory(PS_AdditionalPictureMemory x, PS_OutStream stream);
void Encode_CustomPictureClockFrequency(PS_CustomPictureClockFrequency x, PS_OutStream stream);
void Encode_CustomPictureFormat(PS_CustomPictureFormat x, PS_OutStream stream);
void Encode_PixelAspectInformation(PS_PixelAspectInformation x, PS_OutStream stream);
void Encode_ExtendedPARItem(PS_ExtendedPARItem x, PS_OutStream stream);
void Encode_MPI(PS_MPI x, PS_OutStream stream);
void Encode_CustomPCFItem(PS_CustomPCFItem x, PS_OutStream stream);
void Encode_H263VideoModeCombos(PS_H263VideoModeCombos x, PS_OutStream stream);
void Encode_H263ModeComboFlags(PS_H263ModeComboFlags x, PS_OutStream stream);
void Encode_IS11172VideoCapability(PS_IS11172VideoCapability x, PS_OutStream stream);
void Encode_AudioCapability(PS_AudioCapability x, PS_OutStream stream);
void Encode_G7231(PS_G7231 x, PS_OutStream stream);
void Encode_G729Extensions(PS_G729Extensions x, PS_OutStream stream);
void Encode_G7231AnnexCCapability(PS_G7231AnnexCCapability x, PS_OutStream stream);
void Encode_G723AnnexCAudioMode(PS_G723AnnexCAudioMode x, PS_OutStream stream);
void Encode_IS11172AudioCapability(PS_IS11172AudioCapability x, PS_OutStream stream);
void Encode_IS13818AudioCapability(PS_IS13818AudioCapability x, PS_OutStream stream);
void Encode_GSMAudioCapability(PS_GSMAudioCapability x, PS_OutStream stream);
void Encode_DataApplicationCapability(PS_DataApplicationCapability x, PS_OutStream stream);
void Encode_Application(PS_Application x, PS_OutStream stream);
void Encode_T38fax(PS_T38fax x, PS_OutStream stream);
void Encode_Nlpid(PS_Nlpid x, PS_OutStream stream);
void Encode_T84(PS_T84 x, PS_OutStream stream);
void Encode_DataProtocolCapability(PS_DataProtocolCapability x, PS_OutStream stream);
void Encode_V76wCompression(PS_V76wCompression x, PS_OutStream stream);
void Encode_CompressionType(PS_CompressionType x, PS_OutStream stream);
void Encode_V42bis(PS_V42bis x, PS_OutStream stream);
void Encode_T84Profile(PS_T84Profile x, PS_OutStream stream);
void Encode_T84Restricted(PS_T84Restricted x, PS_OutStream stream);
void Encode_T38FaxProfile(PS_T38FaxProfile x, PS_OutStream stream);
void Encode_T38FaxRateManagement(PS_T38FaxRateManagement x, PS_OutStream stream);
void Encode_T38FaxUdpOptions(PS_T38FaxUdpOptions x, PS_OutStream stream);
void Encode_T38FaxUdpEC(PS_T38FaxUdpEC x, PS_OutStream stream);
void Encode_EncryptionAuthenticationAndIntegrity(PS_EncryptionAuthenticationAndIntegrity x, PS_OutStream stream);
void Encode_EncryptionCapability(PS_EncryptionCapability x, PS_OutStream stream);
void Encode_MediaEncryptionAlgorithm(PS_MediaEncryptionAlgorithm x, PS_OutStream stream);
void Encode_AuthenticationCapability(PS_AuthenticationCapability x, PS_OutStream stream);
void Encode_IntegrityCapability(PS_IntegrityCapability x, PS_OutStream stream);
void Encode_UserInputCapability(PS_UserInputCapability x, PS_OutStream stream);
void Encode_ConferenceCapability(PS_ConferenceCapability x, PS_OutStream stream);
void Encode_GenericCapability(PS_GenericCapability x, PS_OutStream stream);
void Encode_CapabilityIdentifier(PS_CapabilityIdentifier x, PS_OutStream stream);
void Encode_GenericParameter(PS_GenericParameter x, PS_OutStream stream);
void Encode_ParameterIdentifier(PS_ParameterIdentifier x, PS_OutStream stream);
void Encode_ParameterValue(PS_ParameterValue x, PS_OutStream stream);
void Encode_OpenLogicalChannel(PS_OpenLogicalChannel x, PS_OutStream stream);
void Encode_ReverseLogicalChannelParameters(PS_ReverseLogicalChannelParameters x, PS_OutStream stream);
void Encode_RlcMultiplexParameters(PS_RlcMultiplexParameters x, PS_OutStream stream);
void Encode_ForwardLogicalChannelParameters(PS_ForwardLogicalChannelParameters x, PS_OutStream stream);
void Encode_MultiplexParameters(PS_MultiplexParameters x, PS_OutStream stream);
void Encode_NetworkAccessParameters(PS_NetworkAccessParameters x, PS_OutStream stream);
void Encode_T120SetupProcedure(PS_T120SetupProcedure x, PS_OutStream stream);
void Encode_NetworkAddress(PS_NetworkAddress x, PS_OutStream stream);
void Encode_Distribution(PS_Distribution x, PS_OutStream stream);
void Encode_Q2931Address(PS_Q2931Address x, PS_OutStream stream);
void Encode_Address(PS_Address x, PS_OutStream stream);
void Encode_V75Parameters(PS_V75Parameters x, PS_OutStream stream);
void Encode_DataType(PS_DataType x, PS_OutStream stream);
void Encode_H235Media(PS_H235Media x, PS_OutStream stream);
void Encode_MediaType(PS_MediaType x, PS_OutStream stream);
void Encode_H222LogicalChannelParameters(PS_H222LogicalChannelParameters x, PS_OutStream stream);
void Encode_H223LogicalChannelParameters(PS_H223LogicalChannelParameters x, PS_OutStream stream);
void Encode_AdaptationLayerType(PS_AdaptationLayerType x, PS_OutStream stream);
void Encode_Al3(PS_Al3 x, PS_OutStream stream);
void Encode_H223AL1MParameters(PS_H223AL1MParameters x, PS_OutStream stream);
void Encode_ArqType(PS_ArqType x, PS_OutStream stream);
void Encode_CrcLength(PS_CrcLength x, PS_OutStream stream);
void Encode_HeaderFEC(PS_HeaderFEC x, PS_OutStream stream);
void Encode_TransferMode(PS_TransferMode x, PS_OutStream stream);
void Encode_H223AL2MParameters(PS_H223AL2MParameters x, PS_OutStream stream);
void Encode_Al2HeaderFEC(PS_Al2HeaderFEC x, PS_OutStream stream);
void Encode_H223AL3MParameters(PS_H223AL3MParameters x, PS_OutStream stream);
void Encode_Al3ArqType(PS_Al3ArqType x, PS_OutStream stream);
void Encode_Al3CrcLength(PS_Al3CrcLength x, PS_OutStream stream);
void Encode_HeaderFormat(PS_HeaderFormat x, PS_OutStream stream);
void Encode_H223AnnexCArqParameters(PS_H223AnnexCArqParameters x, PS_OutStream stream);
void Encode_NumberOfRetransmissions(PS_NumberOfRetransmissions x, PS_OutStream stream);
void Encode_V76LogicalChannelParameters(PS_V76LogicalChannelParameters x, PS_OutStream stream);
void Encode_Mode(PS_Mode x, PS_OutStream stream);
void Encode_ERM(PS_ERM x, PS_OutStream stream);
void Encode_Recovery(PS_Recovery x, PS_OutStream stream);
void Encode_SuspendResume(PS_SuspendResume x, PS_OutStream stream);
void Encode_V76HDLCParameters(PS_V76HDLCParameters x, PS_OutStream stream);
void Encode_CRCLength(PS_CRCLength x, PS_OutStream stream);
void Encode_H2250LogicalChannelParameters(PS_H2250LogicalChannelParameters x, PS_OutStream stream);
void Encode_MediaPacketization(PS_MediaPacketization x, PS_OutStream stream);
void Encode_RTPPayloadType(PS_RTPPayloadType x, PS_OutStream stream);
void Encode_PayloadDescriptor(PS_PayloadDescriptor x, PS_OutStream stream);
void Encode_RedundancyEncoding(PS_RedundancyEncoding x, PS_OutStream stream);
void Encode_TransportAddress(PS_TransportAddress x, PS_OutStream stream);
void Encode_UnicastAddress(PS_UnicastAddress x, PS_OutStream stream);
void Encode_IPSourceRouteAddress(PS_IPSourceRouteAddress x, PS_OutStream stream);
void Encode_Routing(PS_Routing x, PS_OutStream stream);
void Encode_IP6Address(PS_IP6Address x, PS_OutStream stream);
void Encode_IPXAddress(PS_IPXAddress x, PS_OutStream stream);
void Encode_IPAddress(PS_IPAddress x, PS_OutStream stream);
void Encode_MulticastAddress(PS_MulticastAddress x, PS_OutStream stream);
void Encode_MaIp6Address(PS_MaIp6Address x, PS_OutStream stream);
void Encode_MaIpAddress(PS_MaIpAddress x, PS_OutStream stream);
void Encode_EncryptionSync(PS_EncryptionSync x, PS_OutStream stream);
void Encode_EscrowData(PS_EscrowData x, PS_OutStream stream);
void Encode_OpenLogicalChannelAck(PS_OpenLogicalChannelAck x, PS_OutStream stream);
void Encode_ForwardMultiplexAckParameters(PS_ForwardMultiplexAckParameters x, PS_OutStream stream);
void Encode_AckReverseLogicalChannelParameters(PS_AckReverseLogicalChannelParameters x, PS_OutStream stream);
void Encode_AckMultiplexParameters(PS_AckMultiplexParameters x, PS_OutStream stream);
void Encode_OpenLogicalChannelReject(PS_OpenLogicalChannelReject x, PS_OutStream stream);
void Encode_OlcRejectCause(PS_OlcRejectCause x, PS_OutStream stream);
void Encode_OpenLogicalChannelConfirm(PS_OpenLogicalChannelConfirm x, PS_OutStream stream);
void Encode_H2250LogicalChannelAckParameters(PS_H2250LogicalChannelAckParameters x, PS_OutStream stream);
void Encode_CloseLogicalChannel(PS_CloseLogicalChannel x, PS_OutStream stream);
void Encode_Reason(PS_Reason x, PS_OutStream stream);
void Encode_Source(PS_Source x, PS_OutStream stream);
void Encode_CloseLogicalChannelAck(PS_CloseLogicalChannelAck x, PS_OutStream stream);
void Encode_RequestChannelClose(PS_RequestChannelClose x, PS_OutStream stream);
void Encode_RccReason(PS_RccReason x, PS_OutStream stream);
void Encode_RequestChannelCloseAck(PS_RequestChannelCloseAck x, PS_OutStream stream);
void Encode_RequestChannelCloseReject(PS_RequestChannelCloseReject x, PS_OutStream stream);
void Encode_RccRejectCause(PS_RccRejectCause x, PS_OutStream stream);
void Encode_RequestChannelCloseRelease(PS_RequestChannelCloseRelease x, PS_OutStream stream);
void Encode_MultiplexEntrySend(PS_MultiplexEntrySend x, PS_OutStream stream);
void Encode_MultiplexEntryDescriptor(PS_MultiplexEntryDescriptor x, PS_OutStream stream);
void Encode_MultiplexElement(PS_MultiplexElement x, PS_OutStream stream);
void Encode_RepeatCount(PS_RepeatCount x, PS_OutStream stream);
void Encode_MuxType(PS_MuxType x, PS_OutStream stream);
void Encode_MultiplexEntrySendAck(PS_MultiplexEntrySendAck x, PS_OutStream stream);
void Encode_MultiplexEntrySendReject(PS_MultiplexEntrySendReject x, PS_OutStream stream);
void Encode_MultiplexEntryRejectionDescriptions(PS_MultiplexEntryRejectionDescriptions x, PS_OutStream stream);
void Encode_MeRejectCause(PS_MeRejectCause x, PS_OutStream stream);
void Encode_MultiplexEntrySendRelease(PS_MultiplexEntrySendRelease x, PS_OutStream stream);
void Encode_RequestMultiplexEntry(PS_RequestMultiplexEntry x, PS_OutStream stream);
void Encode_RequestMultiplexEntryAck(PS_RequestMultiplexEntryAck x, PS_OutStream stream);
void Encode_RequestMultiplexEntryReject(PS_RequestMultiplexEntryReject x, PS_OutStream stream);
void Encode_RequestMultiplexEntryRejectionDescriptions(PS_RequestMultiplexEntryRejectionDescriptions x, PS_OutStream stream);
void Encode_RmeRejectCause(PS_RmeRejectCause x, PS_OutStream stream);
void Encode_RequestMultiplexEntryRelease(PS_RequestMultiplexEntryRelease x, PS_OutStream stream);
void Encode_RequestMode(PS_RequestMode x, PS_OutStream stream);
void Encode_RequestModeAck(PS_RequestModeAck x, PS_OutStream stream);
void Encode_Response(PS_Response x, PS_OutStream stream);
void Encode_RequestModeReject(PS_RequestModeReject x, PS_OutStream stream);
void Encode_RmRejectCause(PS_RmRejectCause x, PS_OutStream stream);
void Encode_RequestModeRelease(PS_RequestModeRelease x, PS_OutStream stream);
void Encode_ModeDescription(PS_ModeDescription x, PS_OutStream stream);
void Encode_ModeElement(PS_ModeElement x, PS_OutStream stream);
void Encode_ModeType(PS_ModeType x, PS_OutStream stream);
void Encode_H235Mode(PS_H235Mode x, PS_OutStream stream);
void Encode_MediaMode(PS_MediaMode x, PS_OutStream stream);
void Encode_H223ModeParameters(PS_H223ModeParameters x, PS_OutStream stream);
void Encode_ModeAdaptationLayerType(PS_ModeAdaptationLayerType x, PS_OutStream stream);
void Encode_ModeAl3(PS_ModeAl3 x, PS_OutStream stream);
void Encode_V76ModeParameters(PS_V76ModeParameters x, PS_OutStream stream);
void Encode_H2250ModeParameters(PS_H2250ModeParameters x, PS_OutStream stream);
void Encode_RedundancyEncodingMode(PS_RedundancyEncodingMode x, PS_OutStream stream);
void Encode_SecondaryEncoding(PS_SecondaryEncoding x, PS_OutStream stream);
void Encode_VideoMode(PS_VideoMode x, PS_OutStream stream);
void Encode_H261VideoMode(PS_H261VideoMode x, PS_OutStream stream);
void Encode_Resolution(PS_Resolution x, PS_OutStream stream);
void Encode_H262VideoMode(PS_H262VideoMode x, PS_OutStream stream);
void Encode_ProfileAndLevel(PS_ProfileAndLevel x, PS_OutStream stream);
void Encode_H263VideoMode(PS_H263VideoMode x, PS_OutStream stream);
void Encode_H263Resolution(PS_H263Resolution x, PS_OutStream stream);
void Encode_IS11172VideoMode(PS_IS11172VideoMode x, PS_OutStream stream);
void Encode_AudioMode(PS_AudioMode x, PS_OutStream stream);
void Encode_ModeG7231(PS_ModeG7231 x, PS_OutStream stream);
void Encode_IS11172AudioMode(PS_IS11172AudioMode x, PS_OutStream stream);
void Encode_MultichannelType(PS_MultichannelType x, PS_OutStream stream);
void Encode_AudioSampling(PS_AudioSampling x, PS_OutStream stream);
void Encode_AudioLayer(PS_AudioLayer x, PS_OutStream stream);
void Encode_IS13818AudioMode(PS_IS13818AudioMode x, PS_OutStream stream);
void Encode_Is13818MultichannelType(PS_Is13818MultichannelType x, PS_OutStream stream);
void Encode_Is13818AudioSampling(PS_Is13818AudioSampling x, PS_OutStream stream);
void Encode_Is13818AudioLayer(PS_Is13818AudioLayer x, PS_OutStream stream);
void Encode_G7231AnnexCMode(PS_G7231AnnexCMode x, PS_OutStream stream);
void Encode_ModeG723AnnexCAudioMode(PS_ModeG723AnnexCAudioMode x, PS_OutStream stream);
void Encode_DataMode(PS_DataMode x, PS_OutStream stream);
void Encode_DmApplication(PS_DmApplication x, PS_OutStream stream);
void Encode_DmT38fax(PS_DmT38fax x, PS_OutStream stream);
void Encode_DmNlpid(PS_DmNlpid x, PS_OutStream stream);
void Encode_EncryptionMode(PS_EncryptionMode x, PS_OutStream stream);
void Encode_RoundTripDelayRequest(PS_RoundTripDelayRequest x, PS_OutStream stream);
void Encode_RoundTripDelayResponse(PS_RoundTripDelayResponse x, PS_OutStream stream);
void Encode_MaintenanceLoopRequest(PS_MaintenanceLoopRequest x, PS_OutStream stream);
void Encode_MlRequestType(PS_MlRequestType x, PS_OutStream stream);
void Encode_MaintenanceLoopAck(PS_MaintenanceLoopAck x, PS_OutStream stream);
void Encode_MlAckType(PS_MlAckType x, PS_OutStream stream);
void Encode_MaintenanceLoopReject(PS_MaintenanceLoopReject x, PS_OutStream stream);
void Encode_MlRejectCause(PS_MlRejectCause x, PS_OutStream stream);
void Encode_MlRejectType(PS_MlRejectType x, PS_OutStream stream);
void Encode_MaintenanceLoopOffCommand(PS_MaintenanceLoopOffCommand x, PS_OutStream stream);
void Encode_CommunicationModeCommand(PS_CommunicationModeCommand x, PS_OutStream stream);
void Encode_CommunicationModeRequest(PS_CommunicationModeRequest x, PS_OutStream stream);
void Encode_CommunicationModeResponse(PS_CommunicationModeResponse x, PS_OutStream stream);
void Encode_CommunicationModeTableEntry(PS_CommunicationModeTableEntry x, PS_OutStream stream);
void Encode_CmtDataType(PS_CmtDataType x, PS_OutStream stream);
void Encode_ConferenceRequest(PS_ConferenceRequest x, PS_OutStream stream);
void Encode_RequestTerminalCertificate(PS_RequestTerminalCertificate x, PS_OutStream stream);
void Encode_CertSelectionCriteria(PS_CertSelectionCriteria x, PS_OutStream stream);
void Encode_Criteria(PS_Criteria x, PS_OutStream stream);
void Encode_TerminalLabel(PS_TerminalLabel x, PS_OutStream stream);
void Encode_ConferenceResponse(PS_ConferenceResponse x, PS_OutStream stream);
void Encode_SendThisSourceResponse(PS_SendThisSourceResponse x, PS_OutStream stream);
void Encode_MakeTerminalBroadcasterResponse(PS_MakeTerminalBroadcasterResponse x, PS_OutStream stream);
void Encode_BroadcastMyLogicalChannelResponse(PS_BroadcastMyLogicalChannelResponse x, PS_OutStream stream);
void Encode_TerminalCertificateResponse(PS_TerminalCertificateResponse x, PS_OutStream stream);
void Encode_ChairTokenOwnerResponse(PS_ChairTokenOwnerResponse x, PS_OutStream stream);
void Encode_ExtensionAddressResponse(PS_ExtensionAddressResponse x, PS_OutStream stream);
void Encode_MakeMeChairResponse(PS_MakeMeChairResponse x, PS_OutStream stream);
void Encode_PasswordResponse(PS_PasswordResponse x, PS_OutStream stream);
void Encode_ConferenceIDResponse(PS_ConferenceIDResponse x, PS_OutStream stream);
void Encode_TerminalIDResponse(PS_TerminalIDResponse x, PS_OutStream stream);
void Encode_MCTerminalIDResponse(PS_MCTerminalIDResponse x, PS_OutStream stream);
void Encode_RequestAllTerminalIDsResponse(PS_RequestAllTerminalIDsResponse x, PS_OutStream stream);
void Encode_TerminalInformation(PS_TerminalInformation x, PS_OutStream stream);
void Encode_RemoteMCRequest(PS_RemoteMCRequest x, PS_OutStream stream);
void Encode_RemoteMCResponse(PS_RemoteMCResponse x, PS_OutStream stream);
void Encode_Reject(PS_Reject x, PS_OutStream stream);
void Encode_MultilinkRequest(PS_MultilinkRequest x, PS_OutStream stream);
void Encode_MaximumHeaderInterval(PS_MaximumHeaderInterval x, PS_OutStream stream);
void Encode_RequestType(PS_RequestType x, PS_OutStream stream);
void Encode_RemoveConnection(PS_RemoveConnection x, PS_OutStream stream);
void Encode_AddConnection(PS_AddConnection x, PS_OutStream stream);
void Encode_CallInformation(PS_CallInformation x, PS_OutStream stream);
void Encode_MultilinkResponse(PS_MultilinkResponse x, PS_OutStream stream);
void Encode_RespMaximumHeaderInterval(PS_RespMaximumHeaderInterval x, PS_OutStream stream);
void Encode_RespRemoveConnection(PS_RespRemoveConnection x, PS_OutStream stream);
void Encode_RespAddConnection(PS_RespAddConnection x, PS_OutStream stream);
void Encode_ResponseCode(PS_ResponseCode x, PS_OutStream stream);
void Encode_Rejected(PS_Rejected x, PS_OutStream stream);
void Encode_RespCallInformation(PS_RespCallInformation x, PS_OutStream stream);
void Encode_MultilinkIndication(PS_MultilinkIndication x, PS_OutStream stream);
void Encode_ExcessiveError(PS_ExcessiveError x, PS_OutStream stream);
void Encode_CrcDesired(PS_CrcDesired x, PS_OutStream stream);
void Encode_DialingInformation(PS_DialingInformation x, PS_OutStream stream);
void Encode_DialingInformationNumber(PS_DialingInformationNumber x, PS_OutStream stream);
void Encode_DialingInformationNetworkType(PS_DialingInformationNetworkType x, PS_OutStream stream);
void Encode_ConnectionIdentifier(PS_ConnectionIdentifier x, PS_OutStream stream);
void Encode_LogicalChannelRateRequest(PS_LogicalChannelRateRequest x, PS_OutStream stream);
void Encode_LogicalChannelRateAcknowledge(PS_LogicalChannelRateAcknowledge x, PS_OutStream stream);
void Encode_LogicalChannelRateReject(PS_LogicalChannelRateReject x, PS_OutStream stream);
void Encode_LogicalChannelRateRejectReason(PS_LogicalChannelRateRejectReason x, PS_OutStream stream);
void Encode_LogicalChannelRateRelease(PS_LogicalChannelRateRelease x, PS_OutStream stream);
void Encode_SendTerminalCapabilitySet(PS_SendTerminalCapabilitySet x, PS_OutStream stream);
void Encode_SpecificRequest(PS_SpecificRequest x, PS_OutStream stream);
void Encode_EncryptionCommand(PS_EncryptionCommand x, PS_OutStream stream);
void Encode_EncryptionAlgorithmID(PS_EncryptionAlgorithmID x, PS_OutStream stream);
void Encode_FlowControlCommand(PS_FlowControlCommand x, PS_OutStream stream);
void Encode_FccRestriction(PS_FccRestriction x, PS_OutStream stream);
void Encode_FccScope(PS_FccScope x, PS_OutStream stream);
void Encode_EndSessionCommand(PS_EndSessionCommand x, PS_OutStream stream);
void Encode_IsdnOptions(PS_IsdnOptions x, PS_OutStream stream);
void Encode_GstnOptions(PS_GstnOptions x, PS_OutStream stream);
void Encode_ConferenceCommand(PS_ConferenceCommand x, PS_OutStream stream);
void Encode_SubstituteConferenceIDCommand(PS_SubstituteConferenceIDCommand x, PS_OutStream stream);
void Encode_MiscellaneousCommand(PS_MiscellaneousCommand x, PS_OutStream stream);
void Encode_McType(PS_McType x, PS_OutStream stream);
void Encode_ProgressiveRefinementStart(PS_ProgressiveRefinementStart x, PS_OutStream stream);
void Encode_PrsRepeatCount(PS_PrsRepeatCount x, PS_OutStream stream);
void Encode_VideoFastUpdateMB(PS_VideoFastUpdateMB x, PS_OutStream stream);
void Encode_VideoFastUpdateGOB(PS_VideoFastUpdateGOB x, PS_OutStream stream);
void Encode_KeyProtectionMethod(PS_KeyProtectionMethod x, PS_OutStream stream);
void Encode_EncryptionUpdateRequest(PS_EncryptionUpdateRequest x, PS_OutStream stream);
void Encode_H223MultiplexReconfiguration(PS_H223MultiplexReconfiguration x, PS_OutStream stream);
void Encode_H223AnnexADoubleFlag(PS_H223AnnexADoubleFlag x, PS_OutStream stream);
void Encode_H223ModeChange(PS_H223ModeChange x, PS_OutStream stream);
void Encode_NewATMVCCommand(PS_NewATMVCCommand x, PS_OutStream stream);
void Encode_CmdReverseParameters(PS_CmdReverseParameters x, PS_OutStream stream);
void Encode_Multiplex(PS_Multiplex x, PS_OutStream stream);
void Encode_CmdMultiplex(PS_CmdMultiplex x, PS_OutStream stream);
void Encode_CmdAal(PS_CmdAal x, PS_OutStream stream);
void Encode_CmdAal5(PS_CmdAal5 x, PS_OutStream stream);
void Encode_CmdAal1(PS_CmdAal1 x, PS_OutStream stream);
void Encode_CmdErrorCorrection(PS_CmdErrorCorrection x, PS_OutStream stream);
void Encode_CmdClockRecovery(PS_CmdClockRecovery x, PS_OutStream stream);
void Encode_FunctionNotUnderstood(PS_FunctionNotUnderstood x, PS_OutStream stream);
void Encode_FunctionNotSupported(PS_FunctionNotSupported x, PS_OutStream stream);
void Encode_FnsCause(PS_FnsCause x, PS_OutStream stream);
void Encode_ConferenceIndication(PS_ConferenceIndication x, PS_OutStream stream);
void Encode_TerminalYouAreSeeingInSubPictureNumber(PS_TerminalYouAreSeeingInSubPictureNumber x, PS_OutStream stream);
void Encode_VideoIndicateCompose(PS_VideoIndicateCompose x, PS_OutStream stream);
void Encode_MiscellaneousIndication(PS_MiscellaneousIndication x, PS_OutStream stream);
void Encode_MiType(PS_MiType x, PS_OutStream stream);
void Encode_VideoNotDecodedMBs(PS_VideoNotDecodedMBs x, PS_OutStream stream);
void Encode_JitterIndication(PS_JitterIndication x, PS_OutStream stream);
void Encode_JiScope(PS_JiScope x, PS_OutStream stream);
void Encode_H223SkewIndication(PS_H223SkewIndication x, PS_OutStream stream);
void Encode_H2250MaximumSkewIndication(PS_H2250MaximumSkewIndication x, PS_OutStream stream);
void Encode_MCLocationIndication(PS_MCLocationIndication x, PS_OutStream stream);
void Encode_VendorIdentification(PS_VendorIdentification x, PS_OutStream stream);
void Encode_NewATMVCIndication(PS_NewATMVCIndication x, PS_OutStream stream);
void Encode_IndReverseParameters(PS_IndReverseParameters x, PS_OutStream stream);
void Encode_IrpMultiplex(PS_IrpMultiplex x, PS_OutStream stream);
void Encode_IndMultiplex(PS_IndMultiplex x, PS_OutStream stream);
void Encode_IndAal(PS_IndAal x, PS_OutStream stream);
void Encode_IndAal5(PS_IndAal5 x, PS_OutStream stream);
void Encode_IndAal1(PS_IndAal1 x, PS_OutStream stream);
void Encode_IndErrorCorrection(PS_IndErrorCorrection x, PS_OutStream stream);
void Encode_IndClockRecovery(PS_IndClockRecovery x, PS_OutStream stream);
void Encode_UserInputIndication(PS_UserInputIndication x, PS_OutStream stream);
void Encode_SignalUpdate(PS_SignalUpdate x, PS_OutStream stream);
void Encode_Rtp(PS_Rtp x, PS_OutStream stream);
void Encode_Signal(PS_Signal x, PS_OutStream stream);
void Encode_SignalRtp(PS_SignalRtp x, PS_OutStream stream);
void Encode_UserInputSupportIndication(PS_UserInputSupportIndication x, PS_OutStream stream);
void Encode_FlowControlIndication(PS_FlowControlIndication x, PS_OutStream stream);
void Encode_FciRestriction(PS_FciRestriction x, PS_OutStream stream);
void Encode_FciScope(PS_FciScope x, PS_OutStream stream);

#endif
