/**
 * Copyright (C) 2010 Jorge Jimenez (jorge@iryoku.com)
 * Copyright (C) 2010 Belen Masia (bmasia@unizar.es)
 * Copyright (C) 2010 Jose I. Echevarria (joseignacioechevarria@gmail.com)
 * Copyright (C) 2010 Fernando Navarro (fernandn@microsoft.com)
 * Copyright (C) 2010 Diego Gutierrez (diegog@unizar.es)
 * Copyright (C) 2011 Lauri Kasanen (cand@gmx.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the following statement:
 *
 *       "Uses Jimenez's MLAA. Copyright (C) 2010 by Jorge Jimenez, Belen Masia,
 *        Jose I. Echevarria, Fernando Navarro and Diego Gutierrez."
 *
 *       Only for use in the Mesa project, this point 2 is filled by naming the
 *       technique Jimenez's MLAA in the Mesa config options.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the copyright holders.
 */

#ifndef PP_MLAA_H
#define PP_MLAA_H

#include "postprocess/pp_mlaa_areamap.h"

static const char depth1fs[] = "FRAG\n"
   "PROPERTY FS_COLOR0_WRITES_ALL_CBUFS 1\n"
   "DCL IN[0], GENERIC[0], PERSPECTIVE\n"
   "DCL IN[1], GENERIC[10], PERSPECTIVE\n"
   "DCL IN[2], GENERIC[11], PERSPECTIVE\n"
   "DCL OUT[0], COLOR\n"
   "DCL SAMP[0]\n"
   "DCL SVIEW[0], 2D, FLOAT\n"
   "DCL TEMP[0..2]\n"
   "IMM FLT32 {    0.0030,     0.0000,     1.0000,     0.0000}\n"
   "  0: TEX TEMP[0].x, IN[1].xyyy, SAMP[0], 2D\n"
   "  1: MOV TEMP[1].x, TEMP[0].xxxx\n"
   "  2: TEX TEMP[0].x, IN[1].zwww, SAMP[0], 2D\n"
   "  3: MOV TEMP[1].y, TEMP[0].xxxx\n"
   "  4: TEX TEMP[0].x, IN[2].xyyy, SAMP[0], 2D\n"
   "  5: MOV TEMP[1].z, TEMP[0].xxxx\n"
   "  6: TEX TEMP[0].x, IN[2].zwww, SAMP[0], 2D\n"
   "  7: MOV TEMP[1].w, TEMP[0].xxxx\n"
   "  8: TEX TEMP[0].x, IN[0].xyyy, SAMP[0], 2D\n"
   "  9: ADD TEMP[2], TEMP[0].xxxx, -TEMP[1]\n"
   " 10: ABS TEMP[0], TEMP[2]\n"
   " 11: SGE TEMP[2], TEMP[0], IMM[0].xxxx\n"
   " 12: DP4 TEMP[0].x, TEMP[2], IMM[0].zzzz\n"
   " 13: SEQ TEMP[1].x, TEMP[0].xxxx, IMM[0].yyyy\n"
   " 14: IF TEMP[1].xxxx :16\n"
   " 15:   KILL\n"
   " 16: ENDIF\n"
   " 17: MOV OUT[0], TEMP[2]\n"
   " 18: END\n";


static const char color1fs[] = "FRAG\n"
   "PROPERTY FS_COLOR0_WRITES_ALL_CBUFS 1\n"
   "DCL IN[0], GENERIC[0], PERSPECTIVE\n"
   "DCL IN[1], GENERIC[10], PERSPECTIVE\n"
   "DCL IN[2], GENERIC[11], PERSPECTIVE\n"
   "DCL OUT[0], COLOR\n"
   "DCL SAMP[0]\n"
   "DCL SVIEW[0], 2D, FLOAT\n"
   "DCL TEMP[0..2]\n"
   "IMM FLT32 {    0.2126,     0.7152,     0.0722,     0.1000}\n"
   "IMM FLT32 {    1.0000,     0.0000,     0.0000,     0.0000}\n"
   "  0: TEX TEMP[1].xyz, IN[1].xyyy, SAMP[0], 2D\n"
   "  1: DP3 TEMP[0].x, TEMP[1].xyzz, IMM[0]\n"
   "  2: TEX TEMP[1].xyz, IN[1].zwww, SAMP[0], 2D\n"
   "  3: DP3 TEMP[0].y, TEMP[1].xyzz, IMM[0].xyzz\n"
   "  4: TEX TEMP[1].xyz, IN[2].xyyy, SAMP[0], 2D\n"
   "  5: DP3 TEMP[0].z, TEMP[1].xyzz, IMM[0].xyzz\n"
   "  6: TEX TEMP[1].xyz, IN[2].zwww, SAMP[0], 2D\n"
   "  7: DP3 TEMP[0].w, TEMP[1].xyzz, IMM[0].xyzz\n"
   "  8: TEX TEMP[1].xyz, IN[0].xyyy, SAMP[0], 2D\n"
   "  9: DP3 TEMP[2].x, TEMP[1].xyzz, IMM[0].xyzz\n"
   " 10: ADD TEMP[1], TEMP[2].xxxx, -TEMP[0]\n"
   " 11: ABS TEMP[0], TEMP[1]\n"
   " 12: SGE TEMP[2], TEMP[0], IMM[0].wwww\n"
   " 13: DP4 TEMP[0].x, TEMP[2], IMM[1].xxxx\n"
   " 14: SEQ TEMP[1].x, TEMP[0].xxxx, IMM[1].yyyy\n"
   " 15: IF TEMP[1].xxxx :17\n"
   " 16:   KILL\n"
   " 17: ENDIF\n"
   " 18: MOV OUT[0], TEMP[2]\n"
   " 19: END\n";


static const char neigh3fs[] = "FRAG\n"
   "PROPERTY FS_COLOR0_WRITES_ALL_CBUFS 1\n"
   "DCL IN[0], GENERIC[0], PERSPECTIVE\n"
   "DCL IN[1], GENERIC[10], PERSPECTIVE\n"
   "DCL IN[2], GENERIC[11], PERSPECTIVE\n"
   "DCL OUT[0], COLOR\n"
   "DCL SAMP[0]\n"
   "DCL SVIEW[0], 2D, FLOAT\n"
   "DCL SAMP[1]\n"
   "DCL TEMP[0..8]\n"
   "IMM FLT32 {    1.0000,     0.00001,     0.0000,     0.0000}\n"
   "  0: TEX TEMP[0], IN[0].xyyy, SAMP[1], 2D\n"
   "  1: MOV TEMP[1].x, TEMP[0].xxxx\n"
   "  2: TEX TEMP[2].y, IN[2].zwww, SAMP[1], 2D\n"
   "  3: MOV TEMP[1].y, TEMP[2].yyyy\n"
   "  4: MOV TEMP[1].z, TEMP[0].zzzz\n"
   "  5: TEX TEMP[1].w, IN[2].xyyy, SAMP[1], 2D\n"
   "  6: MUL TEMP[4], TEMP[1], TEMP[1]\n"
   "  7: MUL TEMP[5], TEMP[4], TEMP[1]\n"
   "  8: DP4 TEMP[1].x, TEMP[5], IMM[0].xxxx\n"
   "  9: SLT TEMP[4].x, TEMP[1].xxxx, IMM[0].yyyy\n"
   " 10: IF TEMP[4].xxxx :12\n"
   " 11:   KILL\n"
   " 12: ENDIF\n"
   " 13: TEX TEMP[4], IN[0].xyyy, SAMP[0], 2D\n"
   " 14: TEX TEMP[6], IN[1].zwww, SAMP[0], 2D\n"
   " 15: ADD TEMP[7].x, IMM[0].xxxx, -TEMP[0].xxxx\n"
   " 16: MUL TEMP[8], TEMP[4], TEMP[7].xxxx\n"
   " 17: MAD TEMP[7], TEMP[6], TEMP[0].xxxx, TEMP[8]\n"
   " 18: MUL TEMP[6], TEMP[7], TEMP[5].xxxx\n"
   " 19: TEX TEMP[7], IN[2].zwww, SAMP[0], 2D\n"
   " 20: ADD TEMP[8].x, IMM[0].xxxx, -TEMP[2].yyyy\n"
   " 21: MUL TEMP[3], TEMP[4], TEMP[8].xxxx\n"
   " 22: MAD TEMP[8], TEMP[7], TEMP[2].yyyy, TEMP[3]\n"
   " 23: MAD TEMP[2], TEMP[8], TEMP[5].yyyy, TEMP[6]\n"
   " 24: TEX TEMP[6], IN[1].xyyy, SAMP[0], 2D\n"
   " 25: ADD TEMP[7].x, IMM[0].xxxx, -TEMP[0].zzzz\n"
   " 26: MUL TEMP[8], TEMP[4], TEMP[7].xxxx\n"
   " 27: MAD TEMP[7], TEMP[6], TEMP[0].zzzz, TEMP[8]\n"
   " 28: MAD TEMP[0], TEMP[7], TEMP[5].zzzz, TEMP[2]\n"
   " 29: TEX TEMP[2], IN[2].xyyy, SAMP[0], 2D\n"
   " 30: ADD TEMP[6].x, IMM[0].xxxx, -TEMP[1].wwww\n"
   " 31: MUL TEMP[7], TEMP[4], TEMP[6].xxxx\n"
   " 32: MAD TEMP[4], TEMP[2], TEMP[1].wwww, TEMP[7]\n"
   " 33: MAD TEMP[2], TEMP[4], TEMP[5].wwww, TEMP[0]\n"
   " 34: RCP TEMP[0].x, TEMP[1].xxxx\n"
   " 35: MUL OUT[0], TEMP[2], TEMP[0].xxxx\n"
   " 36: END\n";


static const char offsetvs[] = "VERT\n"
   "DCL IN[0]\n"
   "DCL IN[1]\n"
   "DCL OUT[0], POSITION\n"
   "DCL OUT[1], GENERIC[0]\n"
   "DCL OUT[2], GENERIC[10]\n"
   "DCL OUT[3], GENERIC[11]\n"
   "DCL CONST[0]\n"
   "IMM FLT32 {    1.0000,     0.0000,    -1.0000,     0.0000}\n"
   "  0: MOV OUT[0], IN[0]\n"
   "  1: MOV OUT[1], IN[1]\n"
   "  2: MAD OUT[2], CONST[0].xyxy, IMM[0].zyyz, IN[1].xyxy\n"
   "  3: MAD OUT[3], CONST[0].xyxy, IMM[0].xyyx, IN[1].xyxy\n"
   "  4: END\n";


static const char blend2fs_1[] = "FRAG\n"
   "PROPERTY FS_COLOR0_WRITES_ALL_CBUFS 1\n"
   "DCL IN[0], GENERIC[0], PERSPECTIVE\n"
   "DCL OUT[0], COLOR\n"
   "DCL SAMP[0]\n"
   "DCL SVIEW[0], 2D, FLOAT\n"
   "DCL SAMP[1]\n"
   "DCL SVIEW[1], 2D, FLOAT\n"
   "DCL SAMP[2]\n"
   "DCL SVIEW[2], 2D, FLOAT\n"
   "DCL CONST[0]\n"
   "DCL TEMP[0..6]\n"
   "IMM FLT32 {    0.0000,    -0.2500,     0.00609756,     0.5000}\n"
   "IMM FLT32 {   -1.5000,    -2.0000,     0.9000,     1.5000}\n"
   "IMM FLT32 {    2.0000,     1.0000,     4.0000,    33.0000}\n";

static const char blend2fs_2[] =
   "  0: MOV TEMP[0], IMM[0].xxxx\n"
   "  1: TEX TEMP[1], IN[0].xyyy, SAMP[1], 2D\n"
   "  2: MOV TEMP[2].x, TEMP[1]\n"
   "  3: SNE TEMP[3].x, TEMP[1].yyyy, IMM[0].xxxx\n"
   "  4: IF TEMP[3].xxxx :76\n"
   "  5:   MOV TEMP[1].xy, IN[0].xyxx\n"
   "  6:   MOV TEMP[4].x, IMM[1].xxxx\n"
   "  7:   BGNLOOP :24\n"
   "  8:     MUL TEMP[5].x, IMM[1].yyyy, IMM[3].xxxx\n"
   "  9:     SLE TEMP[6].x, TEMP[4].xxxx, TEMP[5].xxxx\n"
   " 10:     IF TEMP[6].xxxx :12\n"
   " 11:       BRK\n"
   " 12:     ENDIF\n"
   " 13:     MOV TEMP[4].y, IMM[0].xxxx\n"
   " 14:     MAD TEMP[3].xyz, CONST[0].xyyy, TEMP[4].xyyy, TEMP[1].xyyy\n"
   " 15:     MOV TEMP[3].w, IMM[0].xxxx\n"
   " 16:     TXL TEMP[5], TEMP[3], SAMP[2], 2D\n"
   " 17:     MOV TEMP[3].x, TEMP[5].yyyy\n"
   " 18:     SLT TEMP[6].x, TEMP[5].yyyy, IMM[1].zzzz\n"
   " 19:     IF TEMP[6].xxxx :21\n"
   " 20:       BRK\n"
   " 21:     ENDIF\n"
   " 22:     ADD TEMP[6].x, TEMP[4].xxxx, IMM[1].yyyy\n"
   " 23:     MOV TEMP[4].x, TEMP[6].xxxx\n"
   " 24:   ENDLOOP :7\n"
   " 25:   ADD TEMP[1].x, TEMP[4].xxxx, IMM[1].wwww\n"
   " 26:   MAD TEMP[6].x, -IMM[2].xxxx, TEMP[3].xxxx, TEMP[1].xxxx\n"
   " 27:   MUL TEMP[1].x, IMM[1].yyyy, IMM[3].xxxx\n"
   " 28:   MAX TEMP[4].x, TEMP[6].xxxx, TEMP[1].xxxx\n"
   " 29:   MOV TEMP[1].x, TEMP[4].xxxx\n"
   " 30:   MOV TEMP[3].xy, IN[0].xyxx\n"
   " 31:   MOV TEMP[5].x, IMM[1].wwww\n"
   " 32:   BGNLOOP :49\n"
   " 33:     MUL TEMP[6].x, IMM[2].xxxx, IMM[3].xxxx\n"
   " 34:     SGE TEMP[4].x, TEMP[5].xxxx, TEMP[6].xxxx\n"
   " 35:     IF TEMP[4].xxxx :37\n"
   " 36:       BRK\n"
   " 37:     ENDIF\n"
   " 38:     MOV TEMP[5].y, IMM[0].xxxx\n"
   " 39:     MAD TEMP[4].xyz, CONST[0].xyyy, TEMP[5].xyyy, TEMP[3].xyyy\n"
   " 40:     MOV TEMP[4].w, IMM[0].xxxx\n"
   " 41:     TXL TEMP[6].xy, TEMP[4], SAMP[2], 2D\n"
   " 42:     MOV TEMP[4].x, TEMP[6].yyyy\n"
   " 43:     SLT TEMP[0].x, TEMP[6].yyyy, IMM[1].zzzz\n"
   " 44:     IF TEMP[0].xxxx :46\n"
   " 45:       BRK\n"
   " 46:     ENDIF\n"
   " 47:     ADD TEMP[6].x, TEMP[5].xxxx, IMM[2].xxxx\n"
   " 48:     MOV TEMP[5].x, TEMP[6].xxxx\n"
   " 49:   ENDLOOP :32\n"
   " 50:   ADD TEMP[3].x, TEMP[5].xxxx, IMM[1].xxxx\n"
   " 51:   MAD TEMP[5].x, IMM[2].xxxx, TEMP[4].xxxx, TEMP[3].xxxx\n"
   " 52:   MUL TEMP[3].x, IMM[2].xxxx, IMM[3].xxxx\n"
   " 53:   MIN TEMP[4].x, TEMP[5].xxxx, TEMP[3].xxxx\n"
   " 54:   MOV TEMP[3].x, TEMP[1].xxxx\n"
   " 55:   MOV TEMP[3].y, TEMP[4].xxxx\n"
   " 56:   MOV TEMP[5].yw, IMM[0].yyyy\n"
   " 57:   MOV TEMP[5].x, TEMP[1].xxxx\n"
   " 58:   ADD TEMP[1].x, TEMP[4].xxxx, IMM[2].yyyy\n"
   " 59:   MOV TEMP[5].z, TEMP[1].xxxx\n"
   " 60:   MAD TEMP[1], TEMP[5], CONST[0].xyxy, IN[0].xyxy\n"
   " 61:   MOV TEMP[4], TEMP[1].xyyy\n"
   " 62:   MOV TEMP[4].w, IMM[0].xxxx\n"
   " 63:   TXL TEMP[5].x, TEMP[4], SAMP[2], 2D\n"
   " 64:   MOV TEMP[4].x, TEMP[5].xxxx\n"
   " 65:   MOV TEMP[5], TEMP[1].zwww\n"
   " 66:   MOV TEMP[5].w, IMM[0].xxxx\n"
   " 67:   TXL TEMP[1].x, TEMP[5], SAMP[2], 2D\n"
   " 68:   MOV TEMP[4].y, TEMP[1].xxxx\n"
   " 69:   MUL TEMP[5].xy, IMM[2].zzzz, TEMP[4].xyyy\n"
   " 70:   ROUND TEMP[1].xy, TEMP[5].xyyy\n"
   " 71:   ABS TEMP[4].xy, TEMP[3].xyyy\n"
   " 72:   MAD TEMP[3].xy, IMM[2].wwww, TEMP[1].xyyy, TEMP[4].xyyy\n"
   " 73:   MUL TEMP[5].xyz, TEMP[3].xyyy, IMM[0].zzzz\n"
   " 74:   MOV TEMP[5].w, IMM[0].xxxx\n"
   " 75:   TXL TEMP[0].xy, TEMP[5], SAMP[0], 2D\n"
   " 76: ENDIF\n"
   " 77: SNE TEMP[1].x, TEMP[2].xxxx, IMM[0].xxxx\n"
   " 78: IF TEMP[1].xxxx :151\n"
   " 79:   MOV TEMP[1].xy, IN[0].xyxx\n"
   " 80:   MOV TEMP[3].x, IMM[1].xxxx\n"
   " 81:   BGNLOOP :98\n"
   " 82:     MUL TEMP[4].x, IMM[1].yyyy, IMM[3].xxxx\n"
   " 83:     SLE TEMP[5].x, TEMP[3].xxxx, TEMP[4].xxxx\n"
   " 84:     IF TEMP[5].xxxx :86\n"
   " 85:       BRK\n"
   " 86:     ENDIF\n"
   " 87:     MOV TEMP[3].y, IMM[0].xxxx\n"
   " 88:     MAD TEMP[5].xyz, CONST[0].xyyy, TEMP[3].yxxx, TEMP[1].xyyy\n"
   " 89:     MOV TEMP[5].w, IMM[0].xxxx\n"
   " 90:     TXL TEMP[4], TEMP[5], SAMP[2], 2D\n"
   " 91:     MOV TEMP[2].x, TEMP[4].xxxx\n"
   " 92:     SLT TEMP[5].x, TEMP[4].xxxx, IMM[1].zzzz\n"
   " 93:     IF TEMP[5].xxxx :95\n"
   " 94:       BRK\n"
   " 95:     ENDIF\n"
   " 96:     ADD TEMP[4].x, TEMP[3].xxxx, IMM[1].yyyy\n"
   " 97:     MOV TEMP[3].x, TEMP[4].xxxx\n"
   " 98:   ENDLOOP :81\n"
   " 99:   ADD TEMP[1].x, TEMP[3].xxxx, IMM[1].wwww\n"
   "100:   MAD TEMP[6].x, -IMM[2].xxxx, TEMP[2].xxxx, TEMP[1].xxxx\n"
   "101:   MUL TEMP[1].x, IMM[1].yyyy, IMM[3].xxxx\n"
   "102:   MAX TEMP[3].x, TEMP[6].xxxx, TEMP[1].xxxx\n"
   "103:   MOV TEMP[1].x, TEMP[3].xxxx\n"
   "104:   MOV TEMP[2].xy, IN[0].xyxx\n"
   "105:   MOV TEMP[4].x, IMM[1].wwww\n"
   "106:   BGNLOOP :123\n"
   "107:     MUL TEMP[5].x, IMM[2].xxxx, IMM[3].xxxx\n"
   "108:     SGE TEMP[6].x, TEMP[4].xxxx, TEMP[5].xxxx\n"
   "109:     IF TEMP[6].xxxx :111\n"
   "110:       BRK\n"
   "111:     ENDIF\n"
   "112:     MOV TEMP[4].y, IMM[0].xxxx\n"
   "113:     MAD TEMP[5].xyz, CONST[0].xyyy, TEMP[4].yxxx, TEMP[2].xyyy\n"
   "114:     MOV TEMP[5].w, IMM[0].xxxx\n"
   "115:     TXL TEMP[6], TEMP[5], SAMP[2], 2D\n"
   "116:     MOV TEMP[3].x, TEMP[6].xxxx\n"
   "117:     SLT TEMP[5].x, TEMP[6].xxxx, IMM[1].zzzz\n"
   "118:     IF TEMP[5].xxxx :120\n"
   "119:       BRK\n"
   "120:     ENDIF\n"
   "121:     ADD TEMP[6].x, TEMP[4].xxxx, IMM[2].xxxx\n"
   "122:     MOV TEMP[4].x, TEMP[6].xxxx\n"
   "123:   ENDLOOP :106\n"
   "124:   ADD TEMP[2].x, TEMP[4].xxxx, IMM[1].xxxx\n"
   "125:   MAD TEMP[4].x, IMM[2].xxxx, TEMP[3].xxxx, TEMP[2].xxxx\n"
   "126:   MUL TEMP[2].x, IMM[2].xxxx, IMM[3].xxxx\n"
   "127:   MIN TEMP[3].x, TEMP[4].xxxx, TEMP[2].xxxx\n"
   "128:   MOV TEMP[2].x, TEMP[1].xxxx\n"
   "129:   MOV TEMP[2].y, TEMP[3].xxxx\n"
   "130:   MOV TEMP[4].xz, IMM[0].yyyy\n"
   "131:   MOV TEMP[4].y, TEMP[1].xxxx\n"
   "132:   ADD TEMP[1].x, TEMP[3].xxxx, IMM[2].yyyy\n"
   "133:   MOV TEMP[4].w, TEMP[1].xxxx\n"
   "134:   MAD TEMP[1], TEMP[4], CONST[0].xyxy, IN[0].xyxy\n"
   "135:   MOV TEMP[3], TEMP[1].xyyy\n"
   "136:   MOV TEMP[3].w, IMM[0].xxxx\n"
   "137:   TXL TEMP[4].y, TEMP[3], SAMP[2], 2D\n"
   "138:   MOV TEMP[3].x, TEMP[4].yyyy\n"
   "139:   MOV TEMP[4], TEMP[1].zwww\n"
   "140:   MOV TEMP[4].w, IMM[0].xxxx\n"
   "141:   TXL TEMP[1].y, TEMP[4], SAMP[2], 2D\n"
   "142:   MOV TEMP[3].y, TEMP[1].yyyy\n"
   "143:   MUL TEMP[4].xy, IMM[2].zzzz, TEMP[3].xyyy\n"
   "144:   ROUND TEMP[1].xy, TEMP[4].xyyy\n"
   "145:   ABS TEMP[3].xy, TEMP[2].xyyy\n"
   "146:   MAD TEMP[2].xy, IMM[2].wwww, TEMP[1].xyyy, TEMP[3].xyyy\n"
   "147:   MUL TEMP[3].xyz, TEMP[2].xyyy, IMM[0].zzzz\n"
   "148:   MOV TEMP[3].w, IMM[0].xxxx\n"
   "149:   TXL TEMP[1].xy, TEMP[3], SAMP[0], 2D\n"
   "150:   MOV TEMP[0].zw, TEMP[1].yyxy\n"
   "151: ENDIF\n"
   "152: MOV OUT[0], TEMP[0]\n"
   "153: END\n";

#endif
