/**************************************************************************
 * 
 * Copyright 2008 Tungsten Graphics, Inc., Cedar Park, Texas.
 * Copyright (c) 2008 VMware, Inc.
 * All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL TUNGSTEN GRAPHICS AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 **************************************************************************/

/* 
 * XXX: SWIG can't parse p_format.h, so we need to duplicate the relevant 
 * declarations here 
 */

%{
#include "pipe/p_format.h" 
%}

enum pipe_format {
   PIPE_FORMAT_NONE,
   PIPE_FORMAT_A8R8G8B8_UNORM,
   PIPE_FORMAT_X8R8G8B8_UNORM,
   PIPE_FORMAT_B8G8R8A8_UNORM,
   PIPE_FORMAT_B8G8R8X8_UNORM,
   PIPE_FORMAT_A1R5G5B5_UNORM,
   PIPE_FORMAT_A4R4G4B4_UNORM,
   PIPE_FORMAT_R5G6B5_UNORM,
   PIPE_FORMAT_A2B10G10R10_UNORM,
   PIPE_FORMAT_L8_UNORM,
   PIPE_FORMAT_A8_UNORM,
   PIPE_FORMAT_I8_UNORM,
   PIPE_FORMAT_A8L8_UNORM,
   PIPE_FORMAT_L16_UNORM,
   PIPE_FORMAT_YCBCR,
   PIPE_FORMAT_YCBCR_REV,
   PIPE_FORMAT_Z16_UNORM,
   PIPE_FORMAT_Z32_UNORM,
   PIPE_FORMAT_Z32_FLOAT,
   PIPE_FORMAT_S8Z24_UNORM,
   PIPE_FORMAT_Z24S8_UNORM,
   PIPE_FORMAT_X8Z24_UNORM,
   PIPE_FORMAT_Z24X8_UNORM,
   PIPE_FORMAT_S8_UNORM,
   PIPE_FORMAT_R64_FLOAT,
   PIPE_FORMAT_R64G64_FLOAT,
   PIPE_FORMAT_R64G64B64_FLOAT,
   PIPE_FORMAT_R64G64B64A64_FLOAT,
   PIPE_FORMAT_R32_FLOAT,
   PIPE_FORMAT_R32G32_FLOAT,
   PIPE_FORMAT_R32G32B32_FLOAT,
   PIPE_FORMAT_R32G32B32A32_FLOAT,
   PIPE_FORMAT_R32_UNORM,
   PIPE_FORMAT_R32G32_UNORM,
   PIPE_FORMAT_R32G32B32_UNORM,
   PIPE_FORMAT_R32G32B32A32_UNORM,
   PIPE_FORMAT_R32_USCALED,
   PIPE_FORMAT_R32G32_USCALED,
   PIPE_FORMAT_R32G32B32_USCALED,
   PIPE_FORMAT_R32G32B32A32_USCALED,
   PIPE_FORMAT_R32_SNORM,
   PIPE_FORMAT_R32G32_SNORM,
   PIPE_FORMAT_R32G32B32_SNORM,
   PIPE_FORMAT_R32G32B32A32_SNORM,
   PIPE_FORMAT_R32_SSCALED,
   PIPE_FORMAT_R32G32_SSCALED,
   PIPE_FORMAT_R32G32B32_SSCALED,
   PIPE_FORMAT_R32G32B32A32_SSCALED,
   PIPE_FORMAT_R16_UNORM,
   PIPE_FORMAT_R16G16_UNORM,
   PIPE_FORMAT_R16G16B16_UNORM,
   PIPE_FORMAT_R16G16B16A16_UNORM,
   PIPE_FORMAT_R16_USCALED,
   PIPE_FORMAT_R16G16_USCALED,
   PIPE_FORMAT_R16G16B16_USCALED,
   PIPE_FORMAT_R16G16B16A16_USCALED,
   PIPE_FORMAT_R16_SNORM,
   PIPE_FORMAT_R16G16_SNORM,
   PIPE_FORMAT_R16G16B16_SNORM,
   PIPE_FORMAT_R16G16B16A16_SNORM,
   PIPE_FORMAT_R16_SSCALED,
   PIPE_FORMAT_R16G16_SSCALED,
   PIPE_FORMAT_R16G16B16_SSCALED,
   PIPE_FORMAT_R16G16B16A16_SSCALED,
   PIPE_FORMAT_R8_UNORM,
   PIPE_FORMAT_R8G8_UNORM,
   PIPE_FORMAT_R8G8B8_UNORM,
   PIPE_FORMAT_R8G8B8A8_UNORM,
   PIPE_FORMAT_R8G8B8X8_UNORM,
   PIPE_FORMAT_R8_USCALED,
   PIPE_FORMAT_R8G8_USCALED,
   PIPE_FORMAT_R8G8B8_USCALED,
   PIPE_FORMAT_R8G8B8A8_USCALED,
   PIPE_FORMAT_R8G8B8X8_USCALED,
   PIPE_FORMAT_R8_SNORM,
   PIPE_FORMAT_R8G8_SNORM,
   PIPE_FORMAT_R8G8B8_SNORM,
   PIPE_FORMAT_R8G8B8A8_SNORM,
   PIPE_FORMAT_R8G8B8X8_SNORM,
   PIPE_FORMAT_B6G5R5_SNORM,
   PIPE_FORMAT_A8B8G8R8_SNORM,
   PIPE_FORMAT_X8B8G8R8_SNORM,
   PIPE_FORMAT_R8_SSCALED,
   PIPE_FORMAT_R8G8_SSCALED,
   PIPE_FORMAT_R8G8B8_SSCALED,
   PIPE_FORMAT_R8G8B8A8_SSCALED,
   PIPE_FORMAT_R8G8B8X8_SSCALED,
   PIPE_FORMAT_R32_FIXED,
   PIPE_FORMAT_R32G32_FIXED,
   PIPE_FORMAT_R32G32B32_FIXED,
   PIPE_FORMAT_R32G32B32A32_FIXED,

   PIPE_FORMAT_L8_SRGB,
   PIPE_FORMAT_A8L8_SRGB,
   PIPE_FORMAT_R8G8B8_SRGB,
   PIPE_FORMAT_R8G8B8A8_SRGB,
   PIPE_FORMAT_R8G8B8X8_SRGB,
   PIPE_FORMAT_A8R8G8B8_SRGB,
   PIPE_FORMAT_X8R8G8B8_SRGB,
   PIPE_FORMAT_B8G8R8A8_SRGB,
   PIPE_FORMAT_B8G8R8X8_SRGB,

   PIPE_FORMAT_X8UB8UG8SR8S_NORM,
   PIPE_FORMAT_B6UG5SR5S_NORM,

   PIPE_FORMAT_DXT1_RGB,
   PIPE_FORMAT_DXT1_RGBA,
   PIPE_FORMAT_DXT3_RGBA,
   PIPE_FORMAT_DXT5_RGBA,

   PIPE_FORMAT_DXT1_SRGB,
   PIPE_FORMAT_DXT1_SRGBA,
   PIPE_FORMAT_DXT3_SRGBA,
   PIPE_FORMAT_DXT5_SRGBA,
};


struct pipe_format_block
{
   unsigned size;
   unsigned width;
   unsigned height;
};

