; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512f --show-mc-encoding | FileCheck %s --check-prefixes=CHECK,X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f --show-mc-encoding | FileCheck %s --check-prefixes=CHECK,X64

declare <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float>, <16 x float>, <16 x float>, i32)
declare <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double>, <8 x double>, <8 x double>, i32)

define <16 x float> @test_x86_vfnmadd_ps_z(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2) {
; CHECK-LABEL: test_x86_vfnmadd_ps_z:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfnmadd213ps %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf2,0x75,0x48,0xac,0xc2]
; CHECK-NEXT:    # zmm0 = -(zmm1 * zmm0) + zmm2
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.mask.vfnmadd.ps.512(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2, i16 -1, i32 4) nounwind
  ret <16 x float> %res
}
declare <16 x float> @llvm.x86.avx512.mask.vfnmadd.ps.512(<16 x float>, <16 x float>, <16 x float>, i16, i32) nounwind readnone

define <16 x float> @test_mask_vfnmadd_ps(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2, i16 %mask) {
; X86-LABEL: test_mask_vfnmadd_ps:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfnmadd132ps %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0x6d,0x49,0x9c,0xc1]
; X86-NEXT:    # zmm0 = -(zmm0 * zmm1) + zmm2
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mask_vfnmadd_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vfnmadd132ps %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0x6d,0x49,0x9c,0xc1]
; X64-NEXT:    # zmm0 = -(zmm0 * zmm1) + zmm2
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.mask.vfnmadd.ps.512(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2, i16 %mask, i32 4) nounwind
  ret <16 x float> %res
}

define <8 x double> @test_x86_vfnmadd_pd_z(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2) {
; CHECK-LABEL: test_x86_vfnmadd_pd_z:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfnmadd213pd %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf2,0xf5,0x48,0xac,0xc2]
; CHECK-NEXT:    # zmm0 = -(zmm1 * zmm0) + zmm2
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.mask.vfnmadd.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 -1, i32 4) nounwind
  ret <8 x double> %res
}
declare <8 x double> @llvm.x86.avx512.mask.vfnmadd.pd.512(<8 x double>, <8 x double>, <8 x double>, i8, i32) nounwind readnone

define <8 x double> @test_mask_vfnmadd_pd(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 %mask) {
; X86-LABEL: test_mask_vfnmadd_pd:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vfnmadd132pd %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x49,0x9c,0xc1]
; X86-NEXT:    # zmm0 = -(zmm0 * zmm1) + zmm2
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mask_vfnmadd_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vfnmadd132pd %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x49,0x9c,0xc1]
; X64-NEXT:    # zmm0 = -(zmm0 * zmm1) + zmm2
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.mask.vfnmadd.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 %mask, i32 4) nounwind
  ret <8 x double> %res
}

define <16 x float> @test_x86_vfnmsubps_z(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2) {
; CHECK-LABEL: test_x86_vfnmsubps_z:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfnmsub213ps %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf2,0x75,0x48,0xae,0xc2]
; CHECK-NEXT:    # zmm0 = -(zmm1 * zmm0) - zmm2
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.mask.vfnmsub.ps.512(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2, i16 -1, i32 4) nounwind
  ret <16 x float> %res
}
declare <16 x float> @llvm.x86.avx512.mask.vfnmsub.ps.512(<16 x float>, <16 x float>, <16 x float>, i16, i32) nounwind readnone

define <16 x float> @test_mask_vfnmsub_ps(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2, i16 %mask) {
; X86-LABEL: test_mask_vfnmsub_ps:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfnmsub132ps %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0x6d,0x49,0x9e,0xc1]
; X86-NEXT:    # zmm0 = -(zmm0 * zmm1) - zmm2
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mask_vfnmsub_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vfnmsub132ps %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0x6d,0x49,0x9e,0xc1]
; X64-NEXT:    # zmm0 = -(zmm0 * zmm1) - zmm2
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.mask.vfnmsub.ps.512(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2, i16 %mask, i32 4) nounwind
  ret <16 x float> %res
}

define <8 x double> @test_x86_vfnmsubpd_z(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2) {
; CHECK-LABEL: test_x86_vfnmsubpd_z:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfnmsub213pd %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf2,0xf5,0x48,0xae,0xc2]
; CHECK-NEXT:    # zmm0 = -(zmm1 * zmm0) - zmm2
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.mask.vfnmsub.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 -1, i32 4) nounwind
  ret <8 x double> %res
}
declare <8 x double> @llvm.x86.avx512.mask.vfnmsub.pd.512(<8 x double>, <8 x double>, <8 x double>, i8, i32) nounwind readnone

define <8 x double> @test_mask_vfnmsub_pd(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 %mask) {
; X86-LABEL: test_mask_vfnmsub_pd:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vfnmsub132pd %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x49,0x9e,0xc1]
; X86-NEXT:    # zmm0 = -(zmm0 * zmm1) - zmm2
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mask_vfnmsub_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vfnmsub132pd %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x49,0x9e,0xc1]
; X64-NEXT:    # zmm0 = -(zmm0 * zmm1) - zmm2
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.mask.vfnmsub.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 %mask, i32 4) nounwind
  ret <8 x double> %res
}

define <16 x float> @test_x86_vfmaddsubps_z(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2) {
; CHECK-LABEL: test_x86_vfmaddsubps_z:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmaddsub213ps %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf2,0x75,0x48,0xa6,0xc2]
; CHECK-NEXT:    # zmm0 = (zmm1 * zmm0) +/- zmm2
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.vfmaddsub.ps.512(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2, i32 4) nounwind
  ret <16 x float> %res
}

define <16 x float> @test_mask_fmaddsub_ps(<16 x float> %a, <16 x float> %b, <16 x float> %c, i16 %mask) {
; X86-LABEL: test_mask_fmaddsub_ps:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmaddsub132ps %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0x6d,0x49,0x96,0xc1]
; X86-NEXT:    # zmm0 = (zmm0 * zmm1) +/- zmm2
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mask_fmaddsub_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vfmaddsub132ps %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0x6d,0x49,0x96,0xc1]
; X64-NEXT:    # zmm0 = (zmm0 * zmm1) +/- zmm2
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.vfmaddsub.ps.512(<16 x float> %a, <16 x float> %b, <16 x float> %c, i32 4)
  %bc = bitcast i16 %mask to <16 x i1>
  %sel = select <16 x i1> %bc, <16 x float> %res, <16 x float> %a
  ret <16 x float> %sel
}

declare <16 x float> @llvm.x86.avx512.vfmaddsub.ps.512(<16 x float>, <16 x float>, <16 x float>, i32) nounwind readnone

define <8 x double> @test_x86_vfmaddsubpd_z(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2) {
; CHECK-LABEL: test_x86_vfmaddsubpd_z:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmaddsub213pd %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf2,0xf5,0x48,0xa6,0xc2]
; CHECK-NEXT:    # zmm0 = (zmm1 * zmm0) +/- zmm2
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.vfmaddsub.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i32 4) nounwind
  ret <8 x double> %res
}
declare <8 x double> @llvm.x86.avx512.vfmaddsub.pd.512(<8 x double>, <8 x double>, <8 x double>, i32) nounwind readnone

define <8 x double> @test_mask_vfmaddsub_pd(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 %mask) {
; X86-LABEL: test_mask_vfmaddsub_pd:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vfmaddsub132pd %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x49,0x96,0xc1]
; X86-NEXT:    # zmm0 = (zmm0 * zmm1) +/- zmm2
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mask_vfmaddsub_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vfmaddsub132pd %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x49,0x96,0xc1]
; X64-NEXT:    # zmm0 = (zmm0 * zmm1) +/- zmm2
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.vfmaddsub.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i32 4) nounwind
  %bc = bitcast i8 %mask to <8 x i1>
  %sel = select <8 x i1> %bc, <8 x double> %res, <8 x double> %a0
  ret <8 x double> %sel
}

define <8 x double>@test_int_x86_avx512_mask_vfmaddsub_pd_512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 %x3){
; X86-LABEL: test_int_x86_avx512_mask_vfmaddsub_pd_512:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vmovapd %zmm0, %zmm3 # encoding: [0x62,0xf1,0xfd,0x48,0x28,0xd8]
; X86-NEXT:    vfmaddsub132pd %zmm1, %zmm2, %zmm3 {%k1} # encoding: [0x62,0xf2,0xed,0x49,0x96,0xd9]
; X86-NEXT:    # zmm3 = (zmm3 * zmm1) +/- zmm2
; X86-NEXT:    vfmaddsub213pd {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0xfd,0x18,0xa6,0xca]
; X86-NEXT:    vaddpd %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0xe5,0x48,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_avx512_mask_vfmaddsub_pd_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vmovapd %zmm0, %zmm3 # encoding: [0x62,0xf1,0xfd,0x48,0x28,0xd8]
; X64-NEXT:    vfmaddsub132pd %zmm1, %zmm2, %zmm3 {%k1} # encoding: [0x62,0xf2,0xed,0x49,0x96,0xd9]
; X64-NEXT:    # zmm3 = (zmm3 * zmm1) +/- zmm2
; X64-NEXT:    vfmaddsub213pd {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0xfd,0x18,0xa6,0xca]
; X64-NEXT:    vaddpd %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0xe5,0x48,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.vfmaddsub.pd.512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i32 4)
  %bc = bitcast i8 %x3 to <8 x i1>
  %sel = select <8 x i1> %bc, <8 x double> %res, <8 x double> %x0
  %res1 = call <8 x double> @llvm.x86.avx512.vfmaddsub.pd.512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i32 0)
  %res2 = fadd <8 x double> %sel, %res1
  ret <8 x double> %res2
}

declare <8 x double> @llvm.x86.avx512.mask3.vfmaddsub.pd.512(<8 x double>, <8 x double>, <8 x double>, i8, i32)

define <8 x double>@test_int_x86_avx512_mask3_vfmaddsub_pd_512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 %x3){
; X86-LABEL: test_int_x86_avx512_mask3_vfmaddsub_pd_512:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vmovapd %zmm2, %zmm3 # encoding: [0x62,0xf1,0xfd,0x48,0x28,0xda]
; X86-NEXT:    vfmaddsub231pd %zmm1, %zmm0, %zmm3 {%k1} # encoding: [0x62,0xf2,0xfd,0x49,0xb6,0xd9]
; X86-NEXT:    # zmm3 = (zmm0 * zmm1) +/- zmm3
; X86-NEXT:    vfmaddsub213pd {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0xfd,0x18,0xa6,0xca]
; X86-NEXT:    vaddpd %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0xe5,0x48,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_avx512_mask3_vfmaddsub_pd_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vmovapd %zmm2, %zmm3 # encoding: [0x62,0xf1,0xfd,0x48,0x28,0xda]
; X64-NEXT:    vfmaddsub231pd %zmm1, %zmm0, %zmm3 {%k1} # encoding: [0x62,0xf2,0xfd,0x49,0xb6,0xd9]
; X64-NEXT:    # zmm3 = (zmm0 * zmm1) +/- zmm3
; X64-NEXT:    vfmaddsub213pd {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0xfd,0x18,0xa6,0xca]
; X64-NEXT:    vaddpd %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0xe5,0x48,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.mask3.vfmaddsub.pd.512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 %x3, i32 4)
  %res1 = call <8 x double> @llvm.x86.avx512.mask3.vfmaddsub.pd.512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 -1, i32 0)
  %res2 = fadd <8 x double> %res, %res1
  ret <8 x double> %res2
}

declare <8 x double> @llvm.x86.avx512.maskz.vfmaddsub.pd.512(<8 x double>, <8 x double>, <8 x double>, i8, i32)

define <8 x double>@test_int_x86_avx512_maskz_vfmaddsub_pd_512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 %x3){
; X86-LABEL: test_int_x86_avx512_maskz_vfmaddsub_pd_512:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vmovapd %zmm1, %zmm3 # encoding: [0x62,0xf1,0xfd,0x48,0x28,0xd9]
; X86-NEXT:    vfmaddsub213pd %zmm2, %zmm0, %zmm3 {%k1} {z} # encoding: [0x62,0xf2,0xfd,0xc9,0xa6,0xda]
; X86-NEXT:    # zmm3 = (zmm0 * zmm3) +/- zmm2
; X86-NEXT:    vfmaddsub213pd {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0xfd,0x18,0xa6,0xca]
; X86-NEXT:    vaddpd %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0xe5,0x48,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_avx512_maskz_vfmaddsub_pd_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vmovapd %zmm1, %zmm3 # encoding: [0x62,0xf1,0xfd,0x48,0x28,0xd9]
; X64-NEXT:    vfmaddsub213pd %zmm2, %zmm0, %zmm3 {%k1} {z} # encoding: [0x62,0xf2,0xfd,0xc9,0xa6,0xda]
; X64-NEXT:    # zmm3 = (zmm0 * zmm3) +/- zmm2
; X64-NEXT:    vfmaddsub213pd {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0xfd,0x18,0xa6,0xca]
; X64-NEXT:    vaddpd %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0xe5,0x48,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.maskz.vfmaddsub.pd.512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 %x3, i32 4)
  %res1 = call <8 x double> @llvm.x86.avx512.maskz.vfmaddsub.pd.512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 -1, i32 0)
  %res2 = fadd <8 x double> %res, %res1
  ret <8 x double> %res2
}

define <16 x float>@test_int_x86_avx512_mask_vfmaddsub_ps_512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 %x3){
; X86-LABEL: test_int_x86_avx512_mask_vfmaddsub_ps_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmovaps %zmm0, %zmm3 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xd8]
; X86-NEXT:    vfmaddsub132ps %zmm1, %zmm2, %zmm3 {%k1} # encoding: [0x62,0xf2,0x6d,0x49,0x96,0xd9]
; X86-NEXT:    # zmm3 = (zmm3 * zmm1) +/- zmm2
; X86-NEXT:    vfmaddsub213ps {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0x7d,0x18,0xa6,0xca]
; X86-NEXT:    vaddps %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0x64,0x48,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_avx512_mask_vfmaddsub_ps_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vmovaps %zmm0, %zmm3 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xd8]
; X64-NEXT:    vfmaddsub132ps %zmm1, %zmm2, %zmm3 {%k1} # encoding: [0x62,0xf2,0x6d,0x49,0x96,0xd9]
; X64-NEXT:    # zmm3 = (zmm3 * zmm1) +/- zmm2
; X64-NEXT:    vfmaddsub213ps {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0x7d,0x18,0xa6,0xca]
; X64-NEXT:    vaddps %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0x64,0x48,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.vfmaddsub.ps.512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i32 4)
  %bc = bitcast i16 %x3 to <16 x i1>
  %sel = select <16 x i1> %bc, <16 x float> %res, <16 x float> %x0
  %res1 = call <16 x float> @llvm.x86.avx512.vfmaddsub.ps.512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i32 0)
  %res2 = fadd <16 x float> %sel, %res1
  ret <16 x float> %res2
}

declare <16 x float> @llvm.x86.avx512.mask3.vfmaddsub.ps.512(<16 x float>, <16 x float>, <16 x float>, i16, i32)

define <16 x float>@test_int_x86_avx512_mask3_vfmaddsub_ps_512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 %x3){
; X86-LABEL: test_int_x86_avx512_mask3_vfmaddsub_ps_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmovaps %zmm2, %zmm3 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xda]
; X86-NEXT:    vfmaddsub231ps %zmm1, %zmm0, %zmm3 {%k1} # encoding: [0x62,0xf2,0x7d,0x49,0xb6,0xd9]
; X86-NEXT:    # zmm3 = (zmm0 * zmm1) +/- zmm3
; X86-NEXT:    vfmaddsub213ps {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0x7d,0x18,0xa6,0xca]
; X86-NEXT:    vaddps %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0x64,0x48,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_avx512_mask3_vfmaddsub_ps_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vmovaps %zmm2, %zmm3 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xda]
; X64-NEXT:    vfmaddsub231ps %zmm1, %zmm0, %zmm3 {%k1} # encoding: [0x62,0xf2,0x7d,0x49,0xb6,0xd9]
; X64-NEXT:    # zmm3 = (zmm0 * zmm1) +/- zmm3
; X64-NEXT:    vfmaddsub213ps {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0x7d,0x18,0xa6,0xca]
; X64-NEXT:    vaddps %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0x64,0x48,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.mask3.vfmaddsub.ps.512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 %x3, i32 4)
  %res1 = call <16 x float> @llvm.x86.avx512.mask3.vfmaddsub.ps.512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 -1, i32 0)
  %res2 = fadd <16 x float> %res, %res1
  ret <16 x float> %res2
}

declare <16 x float> @llvm.x86.avx512.maskz.vfmaddsub.ps.512(<16 x float>, <16 x float>, <16 x float>, i16, i32)

define <16 x float>@test_int_x86_avx512_maskz_vfmaddsub_ps_512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 %x3){
; X86-LABEL: test_int_x86_avx512_maskz_vfmaddsub_ps_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmovaps %zmm1, %zmm3 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xd9]
; X86-NEXT:    vfmaddsub213ps %zmm2, %zmm0, %zmm3 {%k1} {z} # encoding: [0x62,0xf2,0x7d,0xc9,0xa6,0xda]
; X86-NEXT:    # zmm3 = (zmm0 * zmm3) +/- zmm2
; X86-NEXT:    vfmaddsub213ps {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0x7d,0x18,0xa6,0xca]
; X86-NEXT:    vaddps %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0x64,0x48,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_avx512_maskz_vfmaddsub_ps_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vmovaps %zmm1, %zmm3 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xd9]
; X64-NEXT:    vfmaddsub213ps %zmm2, %zmm0, %zmm3 {%k1} {z} # encoding: [0x62,0xf2,0x7d,0xc9,0xa6,0xda]
; X64-NEXT:    # zmm3 = (zmm0 * zmm3) +/- zmm2
; X64-NEXT:    vfmaddsub213ps {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0x7d,0x18,0xa6,0xca]
; X64-NEXT:    vaddps %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0x64,0x48,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.maskz.vfmaddsub.ps.512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 %x3, i32 4)
  %res1 = call <16 x float> @llvm.x86.avx512.maskz.vfmaddsub.ps.512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 -1, i32 0)
  %res2 = fadd <16 x float> %res, %res1
  ret <16 x float> %res2
}

declare <8 x double> @llvm.x86.avx512.mask3.vfmsubadd.pd.512(<8 x double>, <8 x double>, <8 x double>, i8, i32)

define <8 x double>@test_int_x86_avx512_mask3_vfmsubadd_pd_512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 %x3){
; X86-LABEL: test_int_x86_avx512_mask3_vfmsubadd_pd_512:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vmovapd %zmm2, %zmm3 # encoding: [0x62,0xf1,0xfd,0x48,0x28,0xda]
; X86-NEXT:    vfmsubadd231pd %zmm1, %zmm0, %zmm3 {%k1} # encoding: [0x62,0xf2,0xfd,0x49,0xb7,0xd9]
; X86-NEXT:    # zmm3 = (zmm0 * zmm1) -/+ zmm3
; X86-NEXT:    vfmsubadd213pd {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0xfd,0x18,0xa7,0xca]
; X86-NEXT:    vaddpd %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0xe5,0x48,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_avx512_mask3_vfmsubadd_pd_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vmovapd %zmm2, %zmm3 # encoding: [0x62,0xf1,0xfd,0x48,0x28,0xda]
; X64-NEXT:    vfmsubadd231pd %zmm1, %zmm0, %zmm3 {%k1} # encoding: [0x62,0xf2,0xfd,0x49,0xb7,0xd9]
; X64-NEXT:    # zmm3 = (zmm0 * zmm1) -/+ zmm3
; X64-NEXT:    vfmsubadd213pd {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0xfd,0x18,0xa7,0xca]
; X64-NEXT:    vaddpd %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0xe5,0x48,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.mask3.vfmsubadd.pd.512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 %x3, i32 4)
  %res1 = call <8 x double> @llvm.x86.avx512.mask3.vfmsubadd.pd.512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 -1, i32 0)
  %res2 = fadd <8 x double> %res, %res1
  ret <8 x double> %res2
}

declare <16 x float> @llvm.x86.avx512.mask3.vfmsubadd.ps.512(<16 x float>, <16 x float>, <16 x float>, i16, i32)

define <16 x float>@test_int_x86_avx512_mask3_vfmsubadd_ps_512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 %x3){
; X86-LABEL: test_int_x86_avx512_mask3_vfmsubadd_ps_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmovaps %zmm2, %zmm3 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xda]
; X86-NEXT:    vfmsubadd231ps %zmm1, %zmm0, %zmm3 {%k1} # encoding: [0x62,0xf2,0x7d,0x49,0xb7,0xd9]
; X86-NEXT:    # zmm3 = (zmm0 * zmm1) -/+ zmm3
; X86-NEXT:    vfmsubadd213ps {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0x7d,0x18,0xa7,0xca]
; X86-NEXT:    vaddps %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0x64,0x48,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_avx512_mask3_vfmsubadd_ps_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vmovaps %zmm2, %zmm3 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xda]
; X64-NEXT:    vfmsubadd231ps %zmm1, %zmm0, %zmm3 {%k1} # encoding: [0x62,0xf2,0x7d,0x49,0xb7,0xd9]
; X64-NEXT:    # zmm3 = (zmm0 * zmm1) -/+ zmm3
; X64-NEXT:    vfmsubadd213ps {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0x7d,0x18,0xa7,0xca]
; X64-NEXT:    vaddps %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0x64,0x48,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.mask3.vfmsubadd.ps.512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 %x3, i32 4)
  %res1 = call <16 x float> @llvm.x86.avx512.mask3.vfmsubadd.ps.512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 -1, i32 0)
  %res2 = fadd <16 x float> %res, %res1
  ret <16 x float> %res2
}

define <16 x float> @test_mask_round_vfmadd512_ps_rrb_rne(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2, i16 %mask) {
; X86-LABEL: test_mask_round_vfmadd512_ps_rrb_rne:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmadd132ps {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0x6d,0x19,0x98,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mask_round_vfmadd512_ps_rrb_rne:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vfmadd132ps {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0x6d,0x19,0x98,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2, i32 0) nounwind
  %bc = bitcast i16 %mask to <16 x i1>
  %sel = select <16 x i1> %bc, <16 x float> %res, <16 x float> %a0
  ret <16 x float> %sel
}

define <16 x float> @test_mask_round_vfmadd512_ps_rrb_rtn(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2, i16 %mask) {
; X86-LABEL: test_mask_round_vfmadd512_ps_rrb_rtn:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmadd132ps {rd-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0x6d,0x39,0x98,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mask_round_vfmadd512_ps_rrb_rtn:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vfmadd132ps {rd-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0x6d,0x39,0x98,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2, i32 1) nounwind
  %bc = bitcast i16 %mask to <16 x i1>
  %sel = select <16 x i1> %bc, <16 x float> %res, <16 x float> %a0
  ret <16 x float> %sel
}

define <16 x float> @test_mask_round_vfmadd512_ps_rrb_rtp(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2, i16 %mask) {
; X86-LABEL: test_mask_round_vfmadd512_ps_rrb_rtp:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmadd132ps {ru-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0x6d,0x59,0x98,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mask_round_vfmadd512_ps_rrb_rtp:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vfmadd132ps {ru-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0x6d,0x59,0x98,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2, i32 2) nounwind
  %bc = bitcast i16 %mask to <16 x i1>
  %sel = select <16 x i1> %bc, <16 x float> %res, <16 x float> %a0
  ret <16 x float> %sel
}

define <16 x float> @test_mask_round_vfmadd512_ps_rrb_rtz(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2, i16 %mask) {
; X86-LABEL: test_mask_round_vfmadd512_ps_rrb_rtz:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmadd132ps {rz-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0x6d,0x79,0x98,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mask_round_vfmadd512_ps_rrb_rtz:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vfmadd132ps {rz-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0x6d,0x79,0x98,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2, i32 3) nounwind
  %bc = bitcast i16 %mask to <16 x i1>
  %sel = select <16 x i1> %bc, <16 x float> %res, <16 x float> %a0
  ret <16 x float> %sel
}

define <16 x float> @test_mask_round_vfmadd512_ps_rrb_current(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2, i16 %mask) {
; X86-LABEL: test_mask_round_vfmadd512_ps_rrb_current:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmadd132ps %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0x6d,0x49,0x98,0xc1]
; X86-NEXT:    # zmm0 = (zmm0 * zmm1) + zmm2
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mask_round_vfmadd512_ps_rrb_current:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vfmadd132ps %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0x6d,0x49,0x98,0xc1]
; X64-NEXT:    # zmm0 = (zmm0 * zmm1) + zmm2
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2, i32 4) nounwind
  %bc = bitcast i16 %mask to <16 x i1>
  %sel = select <16 x i1> %bc, <16 x float> %res, <16 x float> %a0
  ret <16 x float> %sel
}

define <16 x float> @test_mask_round_vfmadd512_ps_rrbz_rne(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2) {
; CHECK-LABEL: test_mask_round_vfmadd512_ps_rrbz_rne:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmadd213ps {rn-sae}, %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf2,0x75,0x18,0xa8,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2, i32 0) nounwind
  ret <16 x float> %res
}

define <16 x float> @test_mask_round_vfmadd512_ps_rrbz_rtn(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2) {
; CHECK-LABEL: test_mask_round_vfmadd512_ps_rrbz_rtn:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmadd213ps {rd-sae}, %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf2,0x75,0x38,0xa8,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2, i32 1) nounwind
  ret <16 x float> %res
}

define <16 x float> @test_mask_round_vfmadd512_ps_rrbz_rtp(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2) {
; CHECK-LABEL: test_mask_round_vfmadd512_ps_rrbz_rtp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmadd213ps {ru-sae}, %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf2,0x75,0x58,0xa8,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2, i32 2) nounwind
  ret <16 x float> %res
}

define <16 x float> @test_mask_round_vfmadd512_ps_rrbz_rtz(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2) {
; CHECK-LABEL: test_mask_round_vfmadd512_ps_rrbz_rtz:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmadd213ps {rz-sae}, %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf2,0x75,0x78,0xa8,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2, i32 3) nounwind
  ret <16 x float> %res
}

define <16 x float> @test_mask_round_vfmadd512_ps_rrbz_current(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2) {
; CHECK-LABEL: test_mask_round_vfmadd512_ps_rrbz_current:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmadd213ps %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf2,0x75,0x48,0xa8,0xc2]
; CHECK-NEXT:    # zmm0 = (zmm1 * zmm0) + zmm2
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %a0, <16 x float> %a1, <16 x float> %a2, i32 4) nounwind
  ret <16 x float> %res
}

declare <8 x double> @llvm.x86.avx512.mask3.vfmsub.pd.512(<8 x double>, <8 x double>, <8 x double>, i8, i32)

define <8 x double>@test_int_x86_avx512_mask3_vfmsub_pd_512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 %x3){
; X86-LABEL: test_int_x86_avx512_mask3_vfmsub_pd_512:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vmovapd %zmm2, %zmm3 # encoding: [0x62,0xf1,0xfd,0x48,0x28,0xda]
; X86-NEXT:    vfmsub231pd %zmm1, %zmm0, %zmm3 {%k1} # encoding: [0x62,0xf2,0xfd,0x49,0xba,0xd9]
; X86-NEXT:    # zmm3 = (zmm0 * zmm1) - zmm3
; X86-NEXT:    vfmsub213pd {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0xfd,0x18,0xaa,0xca]
; X86-NEXT:    vaddpd %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0xe5,0x48,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_avx512_mask3_vfmsub_pd_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vmovapd %zmm2, %zmm3 # encoding: [0x62,0xf1,0xfd,0x48,0x28,0xda]
; X64-NEXT:    vfmsub231pd %zmm1, %zmm0, %zmm3 {%k1} # encoding: [0x62,0xf2,0xfd,0x49,0xba,0xd9]
; X64-NEXT:    # zmm3 = (zmm0 * zmm1) - zmm3
; X64-NEXT:    vfmsub213pd {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0xfd,0x18,0xaa,0xca]
; X64-NEXT:    vaddpd %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0xe5,0x48,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.mask3.vfmsub.pd.512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 %x3, i32 4)
  %res1 = call <8 x double> @llvm.x86.avx512.mask3.vfmsub.pd.512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 -1, i32 0)
  %res2 = fadd <8 x double> %res, %res1
  ret <8 x double> %res2
}

declare <16 x float> @llvm.x86.avx512.mask3.vfmsub.ps.512(<16 x float>, <16 x float>, <16 x float>, i16, i32)

define <16 x float>@test_int_x86_avx512_mask3_vfmsub_ps_512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 %x3){
; X86-LABEL: test_int_x86_avx512_mask3_vfmsub_ps_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmovaps %zmm2, %zmm3 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xda]
; X86-NEXT:    vfmsub231ps %zmm1, %zmm0, %zmm3 {%k1} # encoding: [0x62,0xf2,0x7d,0x49,0xba,0xd9]
; X86-NEXT:    # zmm3 = (zmm0 * zmm1) - zmm3
; X86-NEXT:    vfmsub213ps {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0x7d,0x18,0xaa,0xca]
; X86-NEXT:    vaddps %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0x64,0x48,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_avx512_mask3_vfmsub_ps_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vmovaps %zmm2, %zmm3 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xda]
; X64-NEXT:    vfmsub231ps %zmm1, %zmm0, %zmm3 {%k1} # encoding: [0x62,0xf2,0x7d,0x49,0xba,0xd9]
; X64-NEXT:    # zmm3 = (zmm0 * zmm1) - zmm3
; X64-NEXT:    vfmsub213ps {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0x7d,0x18,0xaa,0xca]
; X64-NEXT:    vaddps %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0x64,0x48,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.mask3.vfmsub.ps.512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 %x3, i32 4)
  %res1 = call <16 x float> @llvm.x86.avx512.mask3.vfmsub.ps.512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 -1, i32 0)
  %res2 = fadd <16 x float> %res, %res1
  ret <16 x float> %res2
}

define <8 x double> @test_mask_round_vfmadd512_pd_rrb_rne(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 %mask) {
; X86-LABEL: test_mask_round_vfmadd512_pd_rrb_rne:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vfmadd132pd {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x19,0x98,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mask_round_vfmadd512_pd_rrb_rne:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vfmadd132pd {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x19,0x98,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i32 0) nounwind
  %bc = bitcast i8 %mask to <8 x i1>
  %sel = select <8 x i1> %bc, <8 x double> %res, <8 x double> %a0
  ret <8 x double> %sel
}

define <8 x double> @test_mask_round_vfmadd512_pd_rrb_rtn(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 %mask) {
; X86-LABEL: test_mask_round_vfmadd512_pd_rrb_rtn:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vfmadd132pd {rd-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x39,0x98,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mask_round_vfmadd512_pd_rrb_rtn:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vfmadd132pd {rd-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x39,0x98,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i32 1) nounwind
  %bc = bitcast i8 %mask to <8 x i1>
  %sel = select <8 x i1> %bc, <8 x double> %res, <8 x double> %a0
  ret <8 x double> %sel
}

define <8 x double> @test_mask_round_vfmadd512_pd_rrb_rtp(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 %mask) {
; X86-LABEL: test_mask_round_vfmadd512_pd_rrb_rtp:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vfmadd132pd {ru-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x59,0x98,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mask_round_vfmadd512_pd_rrb_rtp:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vfmadd132pd {ru-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x59,0x98,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i32 2) nounwind
  %bc = bitcast i8 %mask to <8 x i1>
  %sel = select <8 x i1> %bc, <8 x double> %res, <8 x double> %a0
  ret <8 x double> %sel
}

define <8 x double> @test_mask_round_vfmadd512_pd_rrb_rtz(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 %mask) {
; X86-LABEL: test_mask_round_vfmadd512_pd_rrb_rtz:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vfmadd132pd {rz-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x79,0x98,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mask_round_vfmadd512_pd_rrb_rtz:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vfmadd132pd {rz-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x79,0x98,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i32 3) nounwind
  %bc = bitcast i8 %mask to <8 x i1>
  %sel = select <8 x i1> %bc, <8 x double> %res, <8 x double> %a0
  ret <8 x double> %sel
}

define <8 x double> @test_mask_round_vfmadd512_pd_rrb_current(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 %mask) {
; X86-LABEL: test_mask_round_vfmadd512_pd_rrb_current:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vfmadd132pd %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x49,0x98,0xc1]
; X86-NEXT:    # zmm0 = (zmm0 * zmm1) + zmm2
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mask_round_vfmadd512_pd_rrb_current:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vfmadd132pd %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x49,0x98,0xc1]
; X64-NEXT:    # zmm0 = (zmm0 * zmm1) + zmm2
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i32 4) nounwind
  %bc = bitcast i8 %mask to <8 x i1>
  %sel = select <8 x i1> %bc, <8 x double> %res, <8 x double> %a0
  ret <8 x double> %sel
}

define <8 x double> @test_mask_round_vfmadd512_pd_rrbz_rne(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2) {
; CHECK-LABEL: test_mask_round_vfmadd512_pd_rrbz_rne:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmadd213pd {rn-sae}, %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf2,0xf5,0x18,0xa8,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i32 0) nounwind
  ret <8 x double> %res
}

define <8 x double> @test_mask_round_vfmadd512_pd_rrbz_rtn(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2) {
; CHECK-LABEL: test_mask_round_vfmadd512_pd_rrbz_rtn:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmadd213pd {rd-sae}, %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf2,0xf5,0x38,0xa8,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i32 1) nounwind
  ret <8 x double> %res
}

define <8 x double> @test_mask_round_vfmadd512_pd_rrbz_rtp(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2) {
; CHECK-LABEL: test_mask_round_vfmadd512_pd_rrbz_rtp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmadd213pd {ru-sae}, %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf2,0xf5,0x58,0xa8,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i32 2) nounwind
  ret <8 x double> %res
}

define <8 x double> @test_mask_round_vfmadd512_pd_rrbz_rtz(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2) {
; CHECK-LABEL: test_mask_round_vfmadd512_pd_rrbz_rtz:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmadd213pd {rz-sae}, %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf2,0xf5,0x78,0xa8,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i32 3) nounwind
  ret <8 x double> %res
}

define <8 x double> @test_mask_round_vfmadd512_pd_rrbz_current(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2) {
; CHECK-LABEL: test_mask_round_vfmadd512_pd_rrbz_current:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmadd213pd %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf2,0xf5,0x48,0xa8,0xc2]
; CHECK-NEXT:    # zmm0 = (zmm1 * zmm0) + zmm2
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i32 4) nounwind
  ret <8 x double> %res
}

define <8 x double>@test_int_x86_avx512_mask_vfmadd_pd_512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 %x3){
; X86-LABEL: test_int_x86_avx512_mask_vfmadd_pd_512:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vmovapd %zmm0, %zmm3 # encoding: [0x62,0xf1,0xfd,0x48,0x28,0xd8]
; X86-NEXT:    vfmadd132pd %zmm1, %zmm2, %zmm3 {%k1} # encoding: [0x62,0xf2,0xed,0x49,0x98,0xd9]
; X86-NEXT:    # zmm3 = (zmm3 * zmm1) + zmm2
; X86-NEXT:    vfmadd213pd {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0xfd,0x18,0xa8,0xca]
; X86-NEXT:    vaddpd %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0xe5,0x48,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_avx512_mask_vfmadd_pd_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vmovapd %zmm0, %zmm3 # encoding: [0x62,0xf1,0xfd,0x48,0x28,0xd8]
; X64-NEXT:    vfmadd132pd %zmm1, %zmm2, %zmm3 {%k1} # encoding: [0x62,0xf2,0xed,0x49,0x98,0xd9]
; X64-NEXT:    # zmm3 = (zmm3 * zmm1) + zmm2
; X64-NEXT:    vfmadd213pd {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0xfd,0x18,0xa8,0xca]
; X64-NEXT:    vaddpd %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0xe5,0x48,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i32 4)
  %bc = bitcast i8 %x3 to <8 x i1>
  %sel = select <8 x i1> %bc, <8 x double> %res, <8 x double> %x0
  %res1 = call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i32 0)
  %res2 = fadd <8 x double> %sel, %res1
  ret <8 x double> %res2
}

declare <8 x double> @llvm.x86.avx512.mask3.vfmadd.pd.512(<8 x double>, <8 x double>, <8 x double>, i8, i32)

define <8 x double>@test_int_x86_avx512_mask3_vfmadd_pd_512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 %x3){
; X86-LABEL: test_int_x86_avx512_mask3_vfmadd_pd_512:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vmovapd %zmm2, %zmm3 # encoding: [0x62,0xf1,0xfd,0x48,0x28,0xda]
; X86-NEXT:    vfmadd231pd %zmm1, %zmm0, %zmm3 {%k1} # encoding: [0x62,0xf2,0xfd,0x49,0xb8,0xd9]
; X86-NEXT:    # zmm3 = (zmm0 * zmm1) + zmm3
; X86-NEXT:    vfmadd213pd {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0xfd,0x18,0xa8,0xca]
; X86-NEXT:    vaddpd %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0xe5,0x48,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_avx512_mask3_vfmadd_pd_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vmovapd %zmm2, %zmm3 # encoding: [0x62,0xf1,0xfd,0x48,0x28,0xda]
; X64-NEXT:    vfmadd231pd %zmm1, %zmm0, %zmm3 {%k1} # encoding: [0x62,0xf2,0xfd,0x49,0xb8,0xd9]
; X64-NEXT:    # zmm3 = (zmm0 * zmm1) + zmm3
; X64-NEXT:    vfmadd213pd {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0xfd,0x18,0xa8,0xca]
; X64-NEXT:    vaddpd %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0xe5,0x48,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.mask3.vfmadd.pd.512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 %x3, i32 4)
  %res1 = call <8 x double> @llvm.x86.avx512.mask3.vfmadd.pd.512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 -1, i32 0)
  %res2 = fadd <8 x double> %res, %res1
  ret <8 x double> %res2
}

declare <8 x double> @llvm.x86.avx512.maskz.vfmadd.pd.512(<8 x double>, <8 x double>, <8 x double>, i8, i32)

define <8 x double>@test_int_x86_avx512_maskz_vfmadd_pd_512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 %x3){
; X86-LABEL: test_int_x86_avx512_maskz_vfmadd_pd_512:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vmovapd %zmm1, %zmm3 # encoding: [0x62,0xf1,0xfd,0x48,0x28,0xd9]
; X86-NEXT:    vfmadd213pd %zmm2, %zmm0, %zmm3 {%k1} {z} # encoding: [0x62,0xf2,0xfd,0xc9,0xa8,0xda]
; X86-NEXT:    # zmm3 = (zmm0 * zmm3) + zmm2
; X86-NEXT:    vfmadd213pd {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0xfd,0x18,0xa8,0xca]
; X86-NEXT:    vaddpd %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0xe5,0x48,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_avx512_maskz_vfmadd_pd_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vmovapd %zmm1, %zmm3 # encoding: [0x62,0xf1,0xfd,0x48,0x28,0xd9]
; X64-NEXT:    vfmadd213pd %zmm2, %zmm0, %zmm3 {%k1} {z} # encoding: [0x62,0xf2,0xfd,0xc9,0xa8,0xda]
; X64-NEXT:    # zmm3 = (zmm0 * zmm3) + zmm2
; X64-NEXT:    vfmadd213pd {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0xfd,0x18,0xa8,0xca]
; X64-NEXT:    vaddpd %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0xe5,0x48,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.maskz.vfmadd.pd.512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 %x3, i32 4)
  %res1 = call <8 x double> @llvm.x86.avx512.maskz.vfmadd.pd.512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 -1, i32 0)
  %res2 = fadd <8 x double> %res, %res1
  ret <8 x double> %res2
}

define <16 x float>@test_int_x86_avx512_mask_vfmadd_ps_512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 %x3){
; X86-LABEL: test_int_x86_avx512_mask_vfmadd_ps_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmovaps %zmm0, %zmm3 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xd8]
; X86-NEXT:    vfmadd132ps %zmm1, %zmm2, %zmm3 {%k1} # encoding: [0x62,0xf2,0x6d,0x49,0x98,0xd9]
; X86-NEXT:    # zmm3 = (zmm3 * zmm1) + zmm2
; X86-NEXT:    vfmadd213ps {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0x7d,0x18,0xa8,0xca]
; X86-NEXT:    vaddps %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0x64,0x48,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_avx512_mask_vfmadd_ps_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vmovaps %zmm0, %zmm3 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xd8]
; X64-NEXT:    vfmadd132ps %zmm1, %zmm2, %zmm3 {%k1} # encoding: [0x62,0xf2,0x6d,0x49,0x98,0xd9]
; X64-NEXT:    # zmm3 = (zmm3 * zmm1) + zmm2
; X64-NEXT:    vfmadd213ps {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0x7d,0x18,0xa8,0xca]
; X64-NEXT:    vaddps %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0x64,0x48,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i32 4)
  %bc = bitcast i16 %x3 to <16 x i1>
  %sel = select <16 x i1> %bc, <16 x float> %res, <16 x float> %x0
  %res1 = call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i32 0)
  %res2 = fadd <16 x float> %sel, %res1
  ret <16 x float> %res2
}

declare <16 x float> @llvm.x86.avx512.mask3.vfmadd.ps.512(<16 x float>, <16 x float>, <16 x float>, i16, i32)

define <16 x float>@test_int_x86_avx512_mask3_vfmadd_ps_512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 %x3){
; X86-LABEL: test_int_x86_avx512_mask3_vfmadd_ps_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmovaps %zmm2, %zmm3 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xda]
; X86-NEXT:    vfmadd231ps %zmm1, %zmm0, %zmm3 {%k1} # encoding: [0x62,0xf2,0x7d,0x49,0xb8,0xd9]
; X86-NEXT:    # zmm3 = (zmm0 * zmm1) + zmm3
; X86-NEXT:    vfmadd213ps {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0x7d,0x18,0xa8,0xca]
; X86-NEXT:    vaddps %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0x64,0x48,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_avx512_mask3_vfmadd_ps_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vmovaps %zmm2, %zmm3 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xda]
; X64-NEXT:    vfmadd231ps %zmm1, %zmm0, %zmm3 {%k1} # encoding: [0x62,0xf2,0x7d,0x49,0xb8,0xd9]
; X64-NEXT:    # zmm3 = (zmm0 * zmm1) + zmm3
; X64-NEXT:    vfmadd213ps {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0x7d,0x18,0xa8,0xca]
; X64-NEXT:    vaddps %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0x64,0x48,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.mask3.vfmadd.ps.512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 %x3, i32 4)
  %res1 = call <16 x float> @llvm.x86.avx512.mask3.vfmadd.ps.512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 -1, i32 0)
  %res2 = fadd <16 x float> %res, %res1
  ret <16 x float> %res2
}

declare <16 x float> @llvm.x86.avx512.maskz.vfmadd.ps.512(<16 x float>, <16 x float>, <16 x float>, i16, i32)

define <16 x float>@test_int_x86_avx512_maskz_vfmadd_ps_512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 %x3){
; X86-LABEL: test_int_x86_avx512_maskz_vfmadd_ps_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmovaps %zmm1, %zmm3 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xd9]
; X86-NEXT:    vfmadd213ps %zmm2, %zmm0, %zmm3 {%k1} {z} # encoding: [0x62,0xf2,0x7d,0xc9,0xa8,0xda]
; X86-NEXT:    # zmm3 = (zmm0 * zmm3) + zmm2
; X86-NEXT:    vfmadd213ps {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0x7d,0x18,0xa8,0xca]
; X86-NEXT:    vaddps %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0x64,0x48,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_avx512_maskz_vfmadd_ps_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vmovaps %zmm1, %zmm3 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xd9]
; X64-NEXT:    vfmadd213ps %zmm2, %zmm0, %zmm3 {%k1} {z} # encoding: [0x62,0xf2,0x7d,0xc9,0xa8,0xda]
; X64-NEXT:    # zmm3 = (zmm0 * zmm3) + zmm2
; X64-NEXT:    vfmadd213ps {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0x7d,0x18,0xa8,0xca]
; X64-NEXT:    vaddps %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0x64,0x48,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.maskz.vfmadd.ps.512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 %x3, i32 4)
  %res1 = call <16 x float> @llvm.x86.avx512.maskz.vfmadd.ps.512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 -1, i32 0)
  %res2 = fadd <16 x float> %res, %res1
  ret <16 x float> %res2
}


define <8 x double> @test_mask_round_vfnmsub512_pd_rrb_rne(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 %mask) {
; X86-LABEL: test_mask_round_vfnmsub512_pd_rrb_rne:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vfnmsub132pd {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x19,0x9e,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mask_round_vfnmsub512_pd_rrb_rne:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vfnmsub132pd {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x19,0x9e,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.mask.vfnmsub.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 %mask, i32 0) nounwind
  ret <8 x double> %res
}

define <8 x double> @test_mask_round_vfnmsub512_pd_rrb_rtn(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 %mask) {
; X86-LABEL: test_mask_round_vfnmsub512_pd_rrb_rtn:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vfnmsub132pd {rd-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x39,0x9e,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mask_round_vfnmsub512_pd_rrb_rtn:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vfnmsub132pd {rd-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x39,0x9e,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.mask.vfnmsub.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 %mask, i32 1) nounwind
  ret <8 x double> %res
}

define <8 x double> @test_mask_round_vfnmsub512_pd_rrb_rtp(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 %mask) {
; X86-LABEL: test_mask_round_vfnmsub512_pd_rrb_rtp:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vfnmsub132pd {ru-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x59,0x9e,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mask_round_vfnmsub512_pd_rrb_rtp:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vfnmsub132pd {ru-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x59,0x9e,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.mask.vfnmsub.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 %mask, i32 2) nounwind
  ret <8 x double> %res
}

define <8 x double> @test_mask_round_vfnmsub512_pd_rrb_rtz(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 %mask) {
; X86-LABEL: test_mask_round_vfnmsub512_pd_rrb_rtz:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vfnmsub132pd {rz-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x79,0x9e,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mask_round_vfnmsub512_pd_rrb_rtz:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vfnmsub132pd {rz-sae}, %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x79,0x9e,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.mask.vfnmsub.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 %mask, i32 3) nounwind
  ret <8 x double> %res
}

define <8 x double> @test_mask_round_vfnmsub512_pd_rrb_current(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 %mask) {
; X86-LABEL: test_mask_round_vfnmsub512_pd_rrb_current:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vfnmsub132pd %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x49,0x9e,0xc1]
; X86-NEXT:    # zmm0 = -(zmm0 * zmm1) - zmm2
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mask_round_vfnmsub512_pd_rrb_current:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vfnmsub132pd %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf2,0xed,0x49,0x9e,0xc1]
; X64-NEXT:    # zmm0 = -(zmm0 * zmm1) - zmm2
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.mask.vfnmsub.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 %mask, i32 4) nounwind
  ret <8 x double> %res
}

define <8 x double> @test_mask_round_vfnmsub512_pd_rrbz_rne(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2) {
; CHECK-LABEL: test_mask_round_vfnmsub512_pd_rrbz_rne:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfnmsub213pd {rn-sae}, %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf2,0xf5,0x18,0xae,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.mask.vfnmsub.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 -1, i32 0) nounwind
  ret <8 x double> %res
}

define <8 x double> @test_mask_round_vfnmsub512_pd_rrbz_rtn(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2) {
; CHECK-LABEL: test_mask_round_vfnmsub512_pd_rrbz_rtn:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfnmsub213pd {rd-sae}, %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf2,0xf5,0x38,0xae,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.mask.vfnmsub.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 -1, i32 1) nounwind
  ret <8 x double> %res
}

define <8 x double> @test_mask_round_vfnmsub512_pd_rrbz_rtp(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2) {
; CHECK-LABEL: test_mask_round_vfnmsub512_pd_rrbz_rtp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfnmsub213pd {ru-sae}, %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf2,0xf5,0x58,0xae,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.mask.vfnmsub.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 -1, i32 2) nounwind
  ret <8 x double> %res
}

define <8 x double> @test_mask_round_vfnmsub512_pd_rrbz_rtz(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2) {
; CHECK-LABEL: test_mask_round_vfnmsub512_pd_rrbz_rtz:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfnmsub213pd {rz-sae}, %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf2,0xf5,0x78,0xae,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.mask.vfnmsub.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 -1, i32 3) nounwind
  ret <8 x double> %res
}

define <8 x double> @test_mask_round_vfnmsub512_pd_rrbz_current(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2) {
; CHECK-LABEL: test_mask_round_vfnmsub512_pd_rrbz_current:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfnmsub213pd %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf2,0xf5,0x48,0xae,0xc2]
; CHECK-NEXT:    # zmm0 = -(zmm1 * zmm0) - zmm2
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.mask.vfnmsub.pd.512(<8 x double> %a0, <8 x double> %a1, <8 x double> %a2, i8 -1, i32 4) nounwind
  ret <8 x double> %res
}

define <8 x double>@test_int_x86_avx512_mask_vfnmsub_pd_512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 %x3){
; X86-LABEL: test_int_x86_avx512_mask_vfnmsub_pd_512:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vmovapd %zmm0, %zmm3 # encoding: [0x62,0xf1,0xfd,0x48,0x28,0xd8]
; X86-NEXT:    vfnmsub132pd %zmm1, %zmm2, %zmm3 {%k1} # encoding: [0x62,0xf2,0xed,0x49,0x9e,0xd9]
; X86-NEXT:    # zmm3 = -(zmm3 * zmm1) - zmm2
; X86-NEXT:    vfnmsub213pd {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0xfd,0x18,0xae,0xca]
; X86-NEXT:    vaddpd %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0xe5,0x48,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_avx512_mask_vfnmsub_pd_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vmovapd %zmm0, %zmm3 # encoding: [0x62,0xf1,0xfd,0x48,0x28,0xd8]
; X64-NEXT:    vfnmsub132pd %zmm1, %zmm2, %zmm3 {%k1} # encoding: [0x62,0xf2,0xed,0x49,0x9e,0xd9]
; X64-NEXT:    # zmm3 = -(zmm3 * zmm1) - zmm2
; X64-NEXT:    vfnmsub213pd {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0xfd,0x18,0xae,0xca]
; X64-NEXT:    vaddpd %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0xe5,0x48,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.mask.vfnmsub.pd.512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 %x3, i32 4)
  %res1 = call <8 x double> @llvm.x86.avx512.mask.vfnmsub.pd.512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 -1, i32 0)
  %res2 = fadd <8 x double> %res, %res1
  ret <8 x double> %res2
}

declare <8 x double> @llvm.x86.avx512.mask3.vfnmsub.pd.512(<8 x double>, <8 x double>, <8 x double>, i8, i32)

define <8 x double>@test_int_x86_avx512_mask3_vfnmsub_pd_512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 %x3){
; X86-LABEL: test_int_x86_avx512_mask3_vfnmsub_pd_512:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vmovapd %zmm2, %zmm3 # encoding: [0x62,0xf1,0xfd,0x48,0x28,0xda]
; X86-NEXT:    vfnmsub231pd %zmm1, %zmm0, %zmm3 {%k1} # encoding: [0x62,0xf2,0xfd,0x49,0xbe,0xd9]
; X86-NEXT:    # zmm3 = -(zmm0 * zmm1) - zmm3
; X86-NEXT:    vfnmsub213pd {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0xfd,0x18,0xae,0xca]
; X86-NEXT:    vaddpd %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0xe5,0x48,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_avx512_mask3_vfnmsub_pd_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vmovapd %zmm2, %zmm3 # encoding: [0x62,0xf1,0xfd,0x48,0x28,0xda]
; X64-NEXT:    vfnmsub231pd %zmm1, %zmm0, %zmm3 {%k1} # encoding: [0x62,0xf2,0xfd,0x49,0xbe,0xd9]
; X64-NEXT:    # zmm3 = -(zmm0 * zmm1) - zmm3
; X64-NEXT:    vfnmsub213pd {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0xfd,0x18,0xae,0xca]
; X64-NEXT:    vaddpd %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0xe5,0x48,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.mask3.vfnmsub.pd.512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 %x3, i32 4)
  %res1 = call <8 x double> @llvm.x86.avx512.mask3.vfnmsub.pd.512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 -1, i32 0)
  %res2 = fadd <8 x double> %res, %res1
  ret <8 x double> %res2
}

define <16 x float>@test_int_x86_avx512_mask_vfnmsub_ps_512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 %x3){
; X86-LABEL: test_int_x86_avx512_mask_vfnmsub_ps_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmovaps %zmm0, %zmm3 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xd8]
; X86-NEXT:    vfnmsub132ps %zmm1, %zmm2, %zmm3 {%k1} # encoding: [0x62,0xf2,0x6d,0x49,0x9e,0xd9]
; X86-NEXT:    # zmm3 = -(zmm3 * zmm1) - zmm2
; X86-NEXT:    vfnmsub213ps {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0x7d,0x18,0xae,0xca]
; X86-NEXT:    vaddps %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0x64,0x48,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_avx512_mask_vfnmsub_ps_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vmovaps %zmm0, %zmm3 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xd8]
; X64-NEXT:    vfnmsub132ps %zmm1, %zmm2, %zmm3 {%k1} # encoding: [0x62,0xf2,0x6d,0x49,0x9e,0xd9]
; X64-NEXT:    # zmm3 = -(zmm3 * zmm1) - zmm2
; X64-NEXT:    vfnmsub213ps {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0x7d,0x18,0xae,0xca]
; X64-NEXT:    vaddps %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0x64,0x48,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.mask.vfnmsub.ps.512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 %x3, i32 4)
  %res1 = call <16 x float> @llvm.x86.avx512.mask.vfnmsub.ps.512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 -1, i32 0)
  %res2 = fadd <16 x float> %res, %res1
  ret <16 x float> %res2
}

declare <16 x float> @llvm.x86.avx512.mask3.vfnmsub.ps.512(<16 x float>, <16 x float>, <16 x float>, i16, i32)

define <16 x float>@test_int_x86_avx512_mask3_vfnmsub_ps_512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 %x3){
; X86-LABEL: test_int_x86_avx512_mask3_vfnmsub_ps_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmovaps %zmm2, %zmm3 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xda]
; X86-NEXT:    vfnmsub231ps %zmm1, %zmm0, %zmm3 {%k1} # encoding: [0x62,0xf2,0x7d,0x49,0xbe,0xd9]
; X86-NEXT:    # zmm3 = -(zmm0 * zmm1) - zmm3
; X86-NEXT:    vfnmsub213ps {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0x7d,0x18,0xae,0xca]
; X86-NEXT:    vaddps %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0x64,0x48,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_avx512_mask3_vfnmsub_ps_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vmovaps %zmm2, %zmm3 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xda]
; X64-NEXT:    vfnmsub231ps %zmm1, %zmm0, %zmm3 {%k1} # encoding: [0x62,0xf2,0x7d,0x49,0xbe,0xd9]
; X64-NEXT:    # zmm3 = -(zmm0 * zmm1) - zmm3
; X64-NEXT:    vfnmsub213ps {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0x7d,0x18,0xae,0xca]
; X64-NEXT:    vaddps %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0x64,0x48,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.mask3.vfnmsub.ps.512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 %x3, i32 4)
  %res1 = call <16 x float> @llvm.x86.avx512.mask3.vfnmsub.ps.512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 -1, i32 0)
  %res2 = fadd <16 x float> %res, %res1
  ret <16 x float> %res2
}

define <8 x double>@test_int_x86_avx512_mask_vfnmadd_pd_512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 %x3){
; X86-LABEL: test_int_x86_avx512_mask_vfnmadd_pd_512:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax # encoding: [0x0f,0xb6,0x44,0x24,0x04]
; X86-NEXT:    kmovw %eax, %k1 # encoding: [0xc5,0xf8,0x92,0xc8]
; X86-NEXT:    vmovapd %zmm0, %zmm3 # encoding: [0x62,0xf1,0xfd,0x48,0x28,0xd8]
; X86-NEXT:    vfnmadd132pd %zmm1, %zmm2, %zmm3 {%k1} # encoding: [0x62,0xf2,0xed,0x49,0x9c,0xd9]
; X86-NEXT:    # zmm3 = -(zmm3 * zmm1) + zmm2
; X86-NEXT:    vfnmadd213pd {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0xfd,0x18,0xac,0xca]
; X86-NEXT:    vaddpd %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0xe5,0x48,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_avx512_mask_vfnmadd_pd_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vmovapd %zmm0, %zmm3 # encoding: [0x62,0xf1,0xfd,0x48,0x28,0xd8]
; X64-NEXT:    vfnmadd132pd %zmm1, %zmm2, %zmm3 {%k1} # encoding: [0x62,0xf2,0xed,0x49,0x9c,0xd9]
; X64-NEXT:    # zmm3 = -(zmm3 * zmm1) + zmm2
; X64-NEXT:    vfnmadd213pd {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0xfd,0x18,0xac,0xca]
; X64-NEXT:    vaddpd %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0xe5,0x48,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <8 x double> @llvm.x86.avx512.mask.vfnmadd.pd.512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 %x3, i32 4)
  %res1 = call <8 x double> @llvm.x86.avx512.mask.vfnmadd.pd.512(<8 x double> %x0, <8 x double> %x1, <8 x double> %x2, i8 -1, i32 0)
  %res2 = fadd <8 x double> %res, %res1
  ret <8 x double> %res2
}

define <16 x float>@test_int_x86_avx512_mask_vfnmadd_ps_512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 %x3){
; X86-LABEL: test_int_x86_avx512_mask_vfnmadd_ps_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmovaps %zmm0, %zmm3 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xd8]
; X86-NEXT:    vfnmadd132ps %zmm1, %zmm2, %zmm3 {%k1} # encoding: [0x62,0xf2,0x6d,0x49,0x9c,0xd9]
; X86-NEXT:    # zmm3 = -(zmm3 * zmm1) + zmm2
; X86-NEXT:    vfnmadd213ps {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0x7d,0x18,0xac,0xca]
; X86-NEXT:    vaddps %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0x64,0x48,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_avx512_mask_vfnmadd_ps_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1 # encoding: [0xc5,0xf8,0x92,0xcf]
; X64-NEXT:    vmovaps %zmm0, %zmm3 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xd8]
; X64-NEXT:    vfnmadd132ps %zmm1, %zmm2, %zmm3 {%k1} # encoding: [0x62,0xf2,0x6d,0x49,0x9c,0xd9]
; X64-NEXT:    # zmm3 = -(zmm3 * zmm1) + zmm2
; X64-NEXT:    vfnmadd213ps {rn-sae}, %zmm2, %zmm0, %zmm1 # encoding: [0x62,0xf2,0x7d,0x18,0xac,0xca]
; X64-NEXT:    vaddps %zmm1, %zmm3, %zmm0 # encoding: [0x62,0xf1,0x64,0x48,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %res = call <16 x float> @llvm.x86.avx512.mask.vfnmadd.ps.512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 %x3, i32 4)
  %res1 = call <16 x float> @llvm.x86.avx512.mask.vfnmadd.ps.512(<16 x float> %x0, <16 x float> %x1, <16 x float> %x2, i16 -1, i32 0)
  %res2 = fadd <16 x float> %res, %res1
  ret <16 x float> %res2
}
