; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mcpu=pwr9 -mtriple=powerpc64le-unknown-unknown \
; RUN:   -verify-machineinstrs -enable-ppc-quad-precision < %s | FileCheck %s
; RUN: llc -mcpu=pwr9 -mtriple=powerpc64-unknown-unknown \
; RUN:   -verify-machineinstrs -enable-ppc-quad-precision < %s | \
; RUN:   FileCheck %s -check-prefix=CHECK-BE

; Vector extract DWord and convert to quad precision.

@sdwVecMem = global <2 x i64> <i64 88, i64 99>, align 16
@udwVecMem = global <2 x i64> <i64 88, i64 99>, align 16

; Function Attrs: norecurse nounwind
define void @sdwVecConv2qp(fp128* nocapture %a, <2 x i64> %b) {
; CHECK-LABEL: sdwVecConv2qp:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltd 34, 34, 1
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr

; CHECK-BE-LABEL: sdwVecConv2qp:
; CHECK-BE:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <2 x i64> %b, i32 0
  %conv = sitofp i64 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @sdwVecConv2qp1(fp128* nocapture %a, <2 x i64> %b) {
; CHECK-LABEL: sdwVecConv2qp1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr

; CHECK-BE-LABEL: sdwVecConv2qp1:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    xxspltd 34, 34, 1
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <2 x i64> %b, i32 1
  %conv = sitofp i64 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @sdwVecConv2qp_02(fp128* nocapture %a) {
; CHECK-LABEL: sdwVecConv2qp_02:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 4, 2, .LC0@toc@ha
; CHECK-NEXT:    ld 4, .LC0@toc@l(4)
; CHECK-NEXT:    lxsd 2, 0(4)
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
entry:
  %0 = load <2 x i64>, <2 x i64>* @sdwVecMem, align 16
  %vecext = extractelement <2 x i64> %0, i32 0
  %conv = sitofp i64 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @sdwVecConv2qp1_03(fp128* nocapture %a, <2 x i64>* nocapture readonly %b) {
; CHECK-LABEL: sdwVecConv2qp1_03:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lxsd 2, 8(4)
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
entry:
  %0 = load <2 x i64>, <2 x i64>* %b, align 16
  %vecext = extractelement <2 x i64> %0, i32 1
  %conv = sitofp i64 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @udwVecConv2qp(fp128* nocapture %a, <2 x i64> %b) {
; CHECK-LABEL: udwVecConv2qp:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltd 34, 34, 1
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr

; CHECK-BE-LABEL: udwVecConv2qp:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <2 x i64> %b, i32 0
  %conv = uitofp i64 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @udwVecConv2qp1(fp128* nocapture %a, <2 x i64> %b) {
; CHECK-LABEL: udwVecConv2qp1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr

; CHECK-BE-LABEL: udwVecConv2qp1:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    xxspltd 34, 34, 1
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <2 x i64> %b, i32 1
  %conv = uitofp i64 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @udwVecConv2qp1_02(fp128* nocapture %a) {
; CHECK-LABEL: udwVecConv2qp1_02:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 4, 2, .LC1@toc@ha
; CHECK-NEXT:    ld 4, .LC1@toc@l(4)
; CHECK-NEXT:    lxsd 2, 8(4)
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
entry:
  %0 = load <2 x i64>, <2 x i64>* @udwVecMem, align 16
  %vecext = extractelement <2 x i64> %0, i32 1
  %conv = uitofp i64 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @udwVecConv2qp_03(fp128* nocapture %a, <2 x i64>* nocapture readonly %b) {
; CHECK-LABEL: udwVecConv2qp_03:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lxsd 2, 0(4)
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
entry:
  %0 = load <2 x i64>, <2 x i64>* %b, align 16
  %vecext = extractelement <2 x i64> %0, i32 0
  %conv = uitofp i64 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Vector extract Word and convert to quad precision.

; Function Attrs: norecurse nounwind
define void @swVecConv2qp(fp128* nocapture %a, <4 x i32> %b) {
; CHECK-LABEL: swVecConv2qp:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vspltw 2, 2, 3
; CHECK-NEXT:    vextsw2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr

; CHECK-BE-LABEL: swVecConv2qp:
; CHECK-BE:    vspltw 2, 2, 0
; CHECK-BE-NEXT:    vextsw2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %b, i32 0
  %conv = sitofp i32 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @swVecConv2qp1(fp128* nocapture %a, <4 x i32> %b) {
; CHECK-LABEL: swVecConv2qp1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vspltw 2, 2, 2
; CHECK-NEXT:    vextsw2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr

; CHECK-BE-LABEL: swVecConv2qp1:
; CHECK-BE:    vextsw2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %b, i32 1
  %conv = sitofp i32 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @swVecConv2qp2(fp128* nocapture %a, <4 x i32> %b) {
; CHECK-LABEL: swVecConv2qp2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextsw2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr

; CHECK-BE-LABEL: swVecConv2qp2:
; CHECK-BE:    vspltw 2, 2, 2
; CHECK-BE-NEXT:    vextsw2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %b, i32 2
  %conv = sitofp i32 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @swVecConv2qp3(fp128* nocapture %a, <4 x i32> %b) {
; CHECK-LABEL: swVecConv2qp3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vspltw 2, 2, 0
; CHECK-NEXT:    vextsw2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr

; CHECK-BE-LABEL: swVecConv2qp3:
; CHECK-BE:    vspltw 2, 2, 3
; CHECK-BE-NEXT:    vextsw2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %b, i32 3
  %conv = sitofp i32 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @uwVecConv2qp(fp128* nocapture %a, <4 x i32> %b) {
; CHECK-LABEL: uwVecConv2qp:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxextractuw 34, 34, 12
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr

; CHECK-BE-LABEL: uwVecConv2qp:
; CHECK-BE:    xxextractuw 34, 34, 0
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %b, i32 0
  %conv = uitofp i32 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @uwVecConv2qp1(fp128* nocapture %a, <4 x i32> %b) {
; CHECK-LABEL: uwVecConv2qp1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxextractuw 34, 34, 8
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr

; CHECK-BE-LABEL: uwVecConv2qp1:
; CHECK-BE:    xxextractuw 34, 34, 4
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %b, i32 1
  %conv = uitofp i32 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @uwVecConv2qp2(fp128* nocapture %a, <4 x i32> %b) {
; CHECK-LABEL: uwVecConv2qp2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxextractuw 34, 34, 4
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr

; CHECK-BE-LABEL: uwVecConv2qp2:
; CHECK-BE:    xxextractuw 34, 34, 8
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %b, i32 2
  %conv = uitofp i32 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @uwVecConv2qp3(fp128* nocapture %a, <4 x i32> %b) {
; CHECK-LABEL: uwVecConv2qp3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxextractuw 34, 34, 0
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr

; CHECK-BE-LABEL: uwVecConv2qp3:
; CHECK-BE:    xxextractuw 34, 34, 12
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %b, i32 3
  %conv = uitofp i32 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Vector extract HWord and convert to quad precision.

; Function Attrs: norecurse nounwind
define void @shwVecConv2qp(fp128* nocapture %a, <8 x i16> %b) {
; CHECK-LABEL: shwVecConv2qp:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractuh 2, 2, 14
; CHECK-NEXT:    vextsh2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: shwVecConv2qp:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractuh 2, 2, 0
; CHECK-BE-NEXT:    vextsh2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %b, i32 0
  %conv = sitofp i16 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @shwVecConv2qp1(fp128* nocapture %a, <8 x i16> %b) {
; CHECK-LABEL: shwVecConv2qp1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractuh 2, 2, 12
; CHECK-NEXT:    vextsh2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: shwVecConv2qp1:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractuh 2, 2, 2
; CHECK-BE-NEXT:    vextsh2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %b, i32 1
  %conv = sitofp i16 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @shwVecConv2qp2(fp128* nocapture %a, <8 x i16> %b) {
; CHECK-LABEL: shwVecConv2qp2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractuh 2, 2, 10
; CHECK-NEXT:    vextsh2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: shwVecConv2qp2:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractuh 2, 2, 4
; CHECK-BE-NEXT:    vextsh2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %b, i32 2
  %conv = sitofp i16 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @shwVecConv2qp3(fp128* nocapture %a, <8 x i16> %b) {
; CHECK-LABEL: shwVecConv2qp3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractuh 2, 2, 8
; CHECK-NEXT:    vextsh2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: shwVecConv2qp3:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractuh 2, 2, 6
; CHECK-BE-NEXT:    vextsh2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %b, i32 3
  %conv = sitofp i16 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @shwVecConv2qp4(fp128* nocapture %a, <8 x i16> %b) {
; CHECK-LABEL: shwVecConv2qp4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractuh 2, 2, 6
; CHECK-NEXT:    vextsh2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: shwVecConv2qp4:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractuh 2, 2, 8
; CHECK-BE-NEXT:    vextsh2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %b, i32 4
  %conv = sitofp i16 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @shwVecConv2qp5(fp128* nocapture %a, <8 x i16> %b) {
; CHECK-LABEL: shwVecConv2qp5:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractuh 2, 2, 4
; CHECK-NEXT:    vextsh2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: shwVecConv2qp5:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractuh 2, 2, 10
; CHECK-BE-NEXT:    vextsh2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %b, i32 5
  %conv = sitofp i16 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @shwVecConv2qp6(fp128* nocapture %a, <8 x i16> %b) {
; CHECK-LABEL: shwVecConv2qp6:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractuh 2, 2, 2
; CHECK-NEXT:    vextsh2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: shwVecConv2qp6:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractuh 2, 2, 12
; CHECK-BE-NEXT:    vextsh2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %b, i32 6
  %conv = sitofp i16 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @shwVecConv2qp7(fp128* nocapture %a, <8 x i16> %b) {
; CHECK-LABEL: shwVecConv2qp7:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractuh 2, 2, 0
; CHECK-NEXT:    vextsh2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: shwVecConv2qp7:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractuh 2, 2, 14
; CHECK-BE-NEXT:    vextsh2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %b, i32 7
  %conv = sitofp i16 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @uhwVecConv2qp(fp128* nocapture %a, <8 x i16> %b) {
; CHECK-LABEL: uhwVecConv2qp:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractuh 2, 2, 14
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: uhwVecConv2qp:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractuh 2, 2, 0
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %b, i32 0
  %conv = uitofp i16 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @uhwVecConv2qp1(fp128* nocapture %a, <8 x i16> %b) {
; CHECK-LABEL: uhwVecConv2qp1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractuh 2, 2, 12
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: uhwVecConv2qp1:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractuh 2, 2, 2
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %b, i32 1
  %conv = uitofp i16 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @uhwVecConv2qp2(fp128* nocapture %a, <8 x i16> %b) {
; CHECK-LABEL: uhwVecConv2qp2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractuh 2, 2, 10
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: uhwVecConv2qp2:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractuh 2, 2, 4
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %b, i32 2
  %conv = uitofp i16 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @uhwVecConv2qp3(fp128* nocapture %a, <8 x i16> %b) {
; CHECK-LABEL: uhwVecConv2qp3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractuh 2, 2, 8
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: uhwVecConv2qp3:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractuh 2, 2, 6
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %b, i32 3
  %conv = uitofp i16 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @uhwVecConv2qp4(fp128* nocapture %a, <8 x i16> %b) {
; CHECK-LABEL: uhwVecConv2qp4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractuh 2, 2, 6
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: uhwVecConv2qp4:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractuh 2, 2, 8
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %b, i32 4
  %conv = uitofp i16 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @uhwVecConv2qp5(fp128* nocapture %a, <8 x i16> %b) {
; CHECK-LABEL: uhwVecConv2qp5:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractuh 2, 2, 4
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: uhwVecConv2qp5:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractuh 2, 2, 10
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %b, i32 5
  %conv = uitofp i16 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @uhwVecConv2qp6(fp128* nocapture %a, <8 x i16> %b) {
; CHECK-LABEL: uhwVecConv2qp6:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractuh 2, 2, 2
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: uhwVecConv2qp6:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractuh 2, 2, 12
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %b, i32 6
  %conv = uitofp i16 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @uhwVecConv2qp7(fp128* nocapture %a, <8 x i16> %b) {
; CHECK-LABEL: uhwVecConv2qp7:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractuh 2, 2, 0
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: uhwVecConv2qp7:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractuh 2, 2, 14
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %b, i32 7
  %conv = uitofp i16 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Vector extract Byte and convert to quad precision.

; Function Attrs: norecurse nounwind
define void @sbVecConv2qp(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: sbVecConv2qp:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 15
; CHECK-NEXT:    vextsb2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: sbVecConv2qp:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 0
; CHECK-BE-NEXT:    vextsb2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 0
  %conv = sitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @sbVecConv2qp1(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: sbVecConv2qp1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 14
; CHECK-NEXT:    vextsb2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: sbVecConv2qp1:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 1
; CHECK-BE-NEXT:    vextsb2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 1
  %conv = sitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @sbVecConv2qp2(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: sbVecConv2qp2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 13
; CHECK-NEXT:    vextsb2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: sbVecConv2qp2:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 2
; CHECK-BE-NEXT:    vextsb2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 2
  %conv = sitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @sbVecConv2qp3(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: sbVecConv2qp3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 12
; CHECK-NEXT:    vextsb2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: sbVecConv2qp3:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 3
; CHECK-BE-NEXT:    vextsb2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 3
  %conv = sitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @sbVecConv2qp4(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: sbVecConv2qp4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 11
; CHECK-NEXT:    vextsb2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: sbVecConv2qp4:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 4
; CHECK-BE-NEXT:    vextsb2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 4
  %conv = sitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @sbVecConv2qp5(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: sbVecConv2qp5:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 10
; CHECK-NEXT:    vextsb2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: sbVecConv2qp5:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 5
; CHECK-BE-NEXT:    vextsb2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 5
  %conv = sitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @sbVecConv2qp6(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: sbVecConv2qp6:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 9
; CHECK-NEXT:    vextsb2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: sbVecConv2qp6:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 6
; CHECK-BE-NEXT:    vextsb2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 6
  %conv = sitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @sbVecConv2qp7(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: sbVecConv2qp7:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 8
; CHECK-NEXT:    vextsb2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: sbVecConv2qp7:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 7
; CHECK-BE-NEXT:    vextsb2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 7
  %conv = sitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @sbVecConv2qp8(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: sbVecConv2qp8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 7
; CHECK-NEXT:    vextsb2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: sbVecConv2qp8:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 8
; CHECK-BE-NEXT:    vextsb2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 8
  %conv = sitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @sbVecConv2qp9(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: sbVecConv2qp9:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 6
; CHECK-NEXT:    vextsb2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: sbVecConv2qp9:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 9
; CHECK-BE-NEXT:    vextsb2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 9
  %conv = sitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @sbVecConv2qp10(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: sbVecConv2qp10:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 5
; CHECK-NEXT:    vextsb2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: sbVecConv2qp10:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 10
; CHECK-BE-NEXT:    vextsb2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 10
  %conv = sitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @sbVecConv2qp11(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: sbVecConv2qp11:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 4
; CHECK-NEXT:    vextsb2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: sbVecConv2qp11:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 11
; CHECK-BE-NEXT:    vextsb2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 11
  %conv = sitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @sbVecConv2qp12(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: sbVecConv2qp12:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 3
; CHECK-NEXT:    vextsb2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: sbVecConv2qp12:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 12
; CHECK-BE-NEXT:    vextsb2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 12
  %conv = sitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @sbVecConv2qp13(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: sbVecConv2qp13:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 2
; CHECK-NEXT:    vextsb2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: sbVecConv2qp13:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 13
; CHECK-BE-NEXT:    vextsb2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 13
  %conv = sitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @sbVecConv2qp14(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: sbVecConv2qp14:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 1
; CHECK-NEXT:    vextsb2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: sbVecConv2qp14:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 14
; CHECK-BE-NEXT:    vextsb2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 14
  %conv = sitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @sbVecConv2qp15(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: sbVecConv2qp15:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 0
; CHECK-NEXT:    vextsb2d 2, 2
; CHECK-NEXT:    xscvsdqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: sbVecConv2qp15:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 15
; CHECK-BE-NEXT:    vextsb2d 2, 2
; CHECK-BE-NEXT:    xscvsdqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 15
  %conv = sitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @ubVecConv2qp(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: ubVecConv2qp:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 15
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: ubVecConv2qp:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 0
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 0
  %conv = uitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @ubVecConv2qp1(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: ubVecConv2qp1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 14
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: ubVecConv2qp1:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 1
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 1
  %conv = uitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @ubVecConv2qp2(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: ubVecConv2qp2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 13
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: ubVecConv2qp2:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 2
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 2
  %conv = uitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @ubVecConv2qp3(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: ubVecConv2qp3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 12
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: ubVecConv2qp3:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 3
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 3
  %conv = uitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @ubVecConv2qp4(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: ubVecConv2qp4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 11
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: ubVecConv2qp4:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 4
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 4
  %conv = uitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @ubVecConv2qp5(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: ubVecConv2qp5:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 10
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: ubVecConv2qp5:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 5
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 5
  %conv = uitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @ubVecConv2qp6(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: ubVecConv2qp6:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 9
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: ubVecConv2qp6:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 6
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 6
  %conv = uitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @ubVecConv2qp7(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: ubVecConv2qp7:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 8
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: ubVecConv2qp7:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 7
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 7
  %conv = uitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @ubVecConv2qp8(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: ubVecConv2qp8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 7
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: ubVecConv2qp8:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 8
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 8
  %conv = uitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @ubVecConv2qp9(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: ubVecConv2qp9:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 6
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: ubVecConv2qp9:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 9
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 9
  %conv = uitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @ubVecConv2qp10(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: ubVecConv2qp10:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 5
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: ubVecConv2qp10:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 10
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 10
  %conv = uitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @ubVecConv2qp11(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: ubVecConv2qp11:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 4
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: ubVecConv2qp11:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 11
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 11
  %conv = uitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @ubVecConv2qp12(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: ubVecConv2qp12:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 3
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: ubVecConv2qp12:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 12
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 12
  %conv = uitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @ubVecConv2qp13(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: ubVecConv2qp13:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 2
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: ubVecConv2qp13:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 13
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 13
  %conv = uitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @ubVecConv2qp14(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: ubVecConv2qp14:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 1
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: ubVecConv2qp14:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 14
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 14
  %conv = uitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}

; Function Attrs: norecurse nounwind
define void @ubVecConv2qp15(fp128* nocapture %a, <16 x i8> %b) {
; CHECK-LABEL: ubVecConv2qp15:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub 2, 2, 0
; CHECK-NEXT:    xscvudqp 2, 2
; CHECK-NEXT:    stxv 34, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: ubVecConv2qp15:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub 2, 2, 15
; CHECK-BE-NEXT:    xscvudqp 2, 2
; CHECK-BE-NEXT:    stxv 34, 0(3)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %b, i32 15
  %conv = uitofp i8 %vecext to fp128
  store fp128 %conv, fp128* %a, align 16
  ret void
}
