/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import com.google.analytics.containertag.common.FunctionType;
import com.google.analytics.containertag.common.Key;
import com.google.analytics.midtier.proto.containertag.TypeSystem;
import com.google.tagmanager.Base16;
import com.google.tagmanager.Base64Encoder;
import com.google.tagmanager.FunctionCallImplementation;
import com.google.tagmanager.Log;
import com.google.tagmanager.Types;
import java.util.Map;

class EncodeMacro
extends FunctionCallImplementation {
    private static final String ID = FunctionType.ENCODE.toString();
    private static final String ARG0 = Key.ARG0.toString();
    private static final String NO_PADDING = Key.NO_PADDING.toString();
    private static final String INPUT_FORMAT = Key.INPUT_FORMAT.toString();
    private static final String OUTPUT_FORMAT = Key.OUTPUT_FORMAT.toString();
    private static final String DEFAULT_INPUT_FORMAT = "text";
    private static final String DEFAULT_OUTPUT_FORMAT = "base16";

    public static String getFunctionId() {
        return ID;
    }

    public EncodeMacro() {
        super(ID, ARG0);
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public TypeSystem.Value evaluate(Map<String, TypeSystem.Value> parameters) {
        byte[] inputBytes;
        int flags;
        String outputFormat;
        block14: {
            TypeSystem.Value argumentParameter = parameters.get(ARG0);
            if (argumentParameter == null || argumentParameter == Types.getDefaultValue()) {
                return Types.getDefaultValue();
            }
            String argument = Types.valueToString(argumentParameter);
            TypeSystem.Value inputFormatParameter = parameters.get(INPUT_FORMAT);
            String inputFormat = inputFormatParameter == null ? DEFAULT_INPUT_FORMAT : Types.valueToString(inputFormatParameter);
            TypeSystem.Value outputFormatParameter = parameters.get(OUTPUT_FORMAT);
            outputFormat = outputFormatParameter == null ? DEFAULT_OUTPUT_FORMAT : Types.valueToString(outputFormatParameter);
            TypeSystem.Value inputFormatValue = parameters.get(INPUT_FORMAT);
            flags = 0;
            TypeSystem.Value noPaddingParameter = parameters.get(NO_PADDING);
            if (noPaddingParameter != null && Types.valueToBoolean(noPaddingParameter).booleanValue()) {
                flags |= 1;
            }
            inputBytes = null;
            try {
                if (DEFAULT_INPUT_FORMAT.equals(inputFormat)) {
                    inputBytes = argument.getBytes();
                    break block14;
                }
                if (DEFAULT_OUTPUT_FORMAT.equals(inputFormat)) {
                    inputBytes = Base16.decode(argument);
                    break block14;
                }
                if ("base64".equals(inputFormat)) {
                    inputBytes = Base64Encoder.decode(argument, flags);
                    break block14;
                }
                if ("base64url".equals(inputFormat)) {
                    inputBytes = Base64Encoder.decode(argument, flags | 2);
                    break block14;
                }
                Log.e("Encode: unknown input format: " + inputFormat);
                return Types.getDefaultValue();
            }
            catch (IllegalArgumentException e) {
                Log.e("Encode: invalid input:");
                return Types.getDefaultValue();
            }
        }
        String encoded = null;
        if (DEFAULT_OUTPUT_FORMAT.equals(outputFormat)) {
            encoded = Base16.encode(inputBytes);
        } else if ("base64".equals(outputFormat)) {
            encoded = Base64Encoder.encodeToString(inputBytes, flags);
        } else if ("base64url".equals(outputFormat)) {
            encoded = Base64Encoder.encodeToString(inputBytes, flags | 2);
        } else {
            Log.e("Encode: unknown output format: " + outputFormat);
            return Types.getDefaultValue();
        }
        return Types.objectToValue(encoded);
    }
}

