/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import com.google.android.gms.common.util.VisibleForTesting;
import com.google.tagmanager.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataLayer {
    public static final Object OBJECT_NOT_PRESENT = new Object();
    static final int MAX_QUEUE_DEPTH = 500;
    static final String LIFETIME_KEY = "gtm.lifetime";
    static final String[] LIFETIME_KEY_COMPONENTS = "gtm.lifetime".toString().split("\\.");
    private static final Pattern LIFETIME_PATTERN = Pattern.compile("(\\d+)\\s*([smhd]?)");
    private final ConcurrentHashMap<Listener, Integer> mListeners;
    private final Map<Object, Object> mModel;
    private final ReentrantLock mPushLock;
    private final LinkedList<Map<Object, Object>> mUpdateQueue;
    private final PersistentStore mPersistentStore;
    private final CountDownLatch mPersistentStoreLoaded;

    @VisibleForTesting
    DataLayer() {
        this(new PersistentStore(){

            @Override
            public void saveKeyValues(List<KeyValue> keysAndValues, long lifetimeInMillis) {
            }

            @Override
            public void loadSaved(PersistentStore.Callback callback) {
                callback.onKeyValuesLoaded(new ArrayList<KeyValue>());
            }

            @Override
            public void clearKeysWithPrefix(String keyPrefix) {
            }
        });
    }

    DataLayer(PersistentStore persistentStore) {
        this.mPersistentStore = persistentStore;
        this.mListeners = new ConcurrentHashMap();
        this.mModel = new HashMap<Object, Object>();
        this.mPushLock = new ReentrantLock();
        this.mUpdateQueue = new LinkedList();
        this.mPersistentStoreLoaded = new CountDownLatch(1);
        this.loadSavedMaps();
    }

    public void push(Object key, Object value) {
        Map<Object, Object> expanded = this.expandKeyValue(key, value);
        this.push(expanded);
    }

    public void push(Map<Object, Object> update) {
        try {
            this.mPersistentStoreLoaded.await();
        }
        catch (InterruptedException e) {
            Log.w("DataLayer.push: unexpected InterruptedException");
        }
        this.pushWithoutWaitingForSaved(update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushWithoutWaitingForSaved(Map<Object, Object> update) {
        this.mPushLock.lock();
        try {
            this.mUpdateQueue.offer(update);
            if (this.mPushLock.getHoldCount() == 1) {
                this.processQueuedUpdates();
            }
            this.savePersistentlyIfNeeded(update);
        }
        finally {
            this.mPushLock.unlock();
        }
    }

    private void loadSavedMaps() {
        this.mPersistentStore.loadSaved(new PersistentStore.Callback(){

            @Override
            public void onKeyValuesLoaded(List<KeyValue> keyValues) {
                for (KeyValue keyValue : keyValues) {
                    DataLayer.this.pushWithoutWaitingForSaved(DataLayer.this.expandKeyValue(keyValue.mKey, keyValue.mValue));
                }
                DataLayer.this.mPersistentStoreLoaded.countDown();
            }
        });
    }

    private void savePersistentlyIfNeeded(Map<Object, Object> update) {
        Long lifetime = this.getLifetimeValue(update);
        if (lifetime == null) {
            return;
        }
        List<KeyValue> flattenedMap = this.flattenMap(update);
        flattenedMap.remove(LIFETIME_KEY);
        this.mPersistentStore.saveKeyValues(flattenedMap, lifetime);
    }

    private Long getLifetimeValue(Map<Object, Object> update) {
        Object lifetimeObject = this.getLifetimeObject(update);
        if (lifetimeObject == null) {
            return null;
        }
        return DataLayer.parseLifetime(lifetimeObject.toString());
    }

    private Object getLifetimeObject(Map<Object, Object> update) {
        Object current = update;
        for (String component : LIFETIME_KEY_COMPONENTS) {
            if (!(current instanceof Map)) {
                return null;
            }
            Map<Object, Object> currentAsMap = current;
            current = currentAsMap.get(component);
        }
        return current;
    }

    void clearPersistentKeysWithPrefix(String prefix) {
        this.push(prefix, null);
        this.mPersistentStore.clearKeysWithPrefix(prefix);
    }

    private List<KeyValue> flattenMap(Map<Object, Object> map) {
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        this.flattenMapHelper(map, "", result);
        return result;
    }

    private void flattenMapHelper(Map<Object, Object> map, String keyPrefix, Collection<KeyValue> accum) {
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            String fullKey = keyPrefix + (keyPrefix.length() == 0 ? "" : ".") + entry.getKey();
            if (entry.getValue() instanceof Map) {
                Map subMap = (Map)entry.getValue();
                this.flattenMapHelper(subMap, fullKey, accum);
                continue;
            }
            if (fullKey.equals(LIFETIME_KEY)) continue;
            accum.add(new KeyValue(fullKey, entry.getValue()));
        }
    }

    @VisibleForTesting
    static Long parseLifetime(String lifetimeString) {
        Matcher m = LIFETIME_PATTERN.matcher(lifetimeString);
        if (!m.matches()) {
            Log.i("unknown _lifetime: " + lifetimeString);
            return null;
        }
        long number = 0L;
        try {
            number = Long.parseLong(m.group(1));
        }
        catch (NumberFormatException e) {
            Log.w("illegal number in _lifetime value: " + lifetimeString);
        }
        if (number <= 0L) {
            Log.i("non-positive _lifetime: " + lifetimeString);
            return null;
        }
        String unitString = m.group(2);
        if (unitString.length() == 0) {
            return number;
        }
        switch (unitString.charAt(0)) {
            case 's': {
                return number * 1000L;
            }
            case 'm': {
                return number * 1000L * 60L;
            }
            case 'h': {
                return number * 1000L * 60L * 60L;
            }
            case 'd': {
                return number * 1000L * 60L * 60L * 24L;
            }
        }
        Log.w("unknown units in _lifetime: " + lifetimeString);
        return null;
    }

    private void processQueuedUpdates() {
        Map<Object, Object> update;
        int numUpdatesProcessed = 0;
        while ((update = this.mUpdateQueue.poll()) != null) {
            this.processUpdate(update);
            if (++numUpdatesProcessed <= 500) continue;
            this.mUpdateQueue.clear();
            throw new RuntimeException("Seems like an infinite loop of pushing to the data layer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUpdate(Map<Object, Object> update) {
        Map<Object, Object> map = this.mModel;
        synchronized (map) {
            for (Object key : update.keySet()) {
                this.mergeMap(this.expandKeyValue(key, update.get(key)), this.mModel);
            }
        }
        this.notifyListeners(update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        Map<Object, Object> map = this.mModel;
        synchronized (map) {
            String[] split;
            Object target = this.mModel;
            for (String s : split = key.split("\\.")) {
                if (!(target instanceof Map)) {
                    return null;
                }
                Object map2 = target;
                Object value = map2.get(s);
                if (value == null) {
                    return null;
                }
                target = value;
            }
            return target;
        }
    }

    public static Map<Object, Object> mapOf(Object ... objects) {
        if (objects.length % 2 != 0) {
            throw new IllegalArgumentException("expected even number of key-value pairs");
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < objects.length; i += 2) {
            map.put(objects[i], objects[i + 1]);
        }
        return map;
    }

    public static List<Object> listOf(Object ... objects) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < objects.length; ++i) {
            list.add(objects[i]);
        }
        return list;
    }

    void registerListener(Listener listener) {
        this.mListeners.put(listener, 0);
    }

    void unregisterListener(Listener listener) {
        this.mListeners.remove(listener);
    }

    private void notifyListeners(Map<Object, Object> update) {
        for (Listener listener : this.mListeners.keySet()) {
            listener.changed(update);
        }
    }

    Map<Object, Object> expandKeyValue(Object key, Object value) {
        HashMap<Object, Object> result;
        HashMap<Object, Object> target = result = new HashMap<Object, Object>();
        String[] split = key.toString().split("\\.");
        for (int i = 0; i < split.length - 1; ++i) {
            HashMap map = new HashMap();
            target.put(split[i], map);
            target = map;
        }
        target.put(split[split.length - 1], value);
        return result;
    }

    @VisibleForTesting
    void mergeMap(Map<Object, Object> from, Map<Object, Object> to) {
        for (Object key : from.keySet()) {
            Object mergeTo;
            Object mergeFrom;
            Object fromValue = from.get(key);
            if (fromValue instanceof List) {
                if (!(to.get(key) instanceof List)) {
                    to.put(key, new ArrayList());
                }
                mergeFrom = (List)fromValue;
                mergeTo = (List)to.get(key);
                this.mergeList((List<Object>)mergeFrom, (List<Object>)mergeTo);
                continue;
            }
            if (fromValue instanceof Map) {
                if (!(to.get(key) instanceof Map)) {
                    to.put(key, new HashMap());
                }
                mergeFrom = (Map)fromValue;
                mergeTo = (Map)to.get(key);
                this.mergeMap((Map<Object, Object>)mergeFrom, (Map<Object, Object>)mergeTo);
                continue;
            }
            to.put(key, fromValue);
        }
    }

    @VisibleForTesting
    void mergeList(List<Object> from, List<Object> to) {
        while (to.size() < from.size()) {
            to.add(null);
        }
        for (int index = 0; index < from.size(); ++index) {
            Object mergeTo;
            Object mergeFrom;
            Object fromValue = from.get(index);
            if (fromValue instanceof List) {
                if (!(to.get(index) instanceof List)) {
                    to.set(index, new ArrayList());
                }
                mergeFrom = (List)fromValue;
                mergeTo = (List)to.get(index);
                this.mergeList((List<Object>)mergeFrom, (List<Object>)mergeTo);
                continue;
            }
            if (fromValue instanceof Map) {
                if (!(to.get(index) instanceof Map)) {
                    to.set(index, new HashMap());
                }
                mergeFrom = (Map)fromValue;
                mergeTo = (Map)to.get(index);
                this.mergeMap((Map<Object, Object>)mergeFrom, (Map<Object, Object>)mergeTo);
                continue;
            }
            if (fromValue == OBJECT_NOT_PRESENT) continue;
            to.set(index, fromValue);
        }
    }

    static interface PersistentStore {
        public void saveKeyValues(List<KeyValue> var1, long var2);

        public void loadSaved(Callback var1);

        public void clearKeysWithPrefix(String var1);

        public static interface Callback {
            public void onKeyValuesLoaded(List<KeyValue> var1);
        }
    }

    static final class KeyValue {
        public final String mKey;
        public final Object mValue;

        KeyValue(String key, Object value) {
            this.mKey = key;
            this.mValue = value;
        }

        public String toString() {
            return "Key: " + this.mKey + " value: " + this.mValue.toString();
        }

        public int hashCode() {
            return Arrays.hashCode((Object[])new Integer[]{this.mKey.hashCode(), this.mValue.hashCode()});
        }

        public boolean equals(Object o) {
            if (!(o instanceof KeyValue)) {
                return false;
            }
            KeyValue other = (KeyValue)o;
            return this.mKey.equals(other.mKey) && this.mValue.equals(other.mValue);
        }
    }

    static interface Listener {
        public void changed(Map<Object, Object> var1);
    }
}

