/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import com.google.tagmanager.Clock;
import com.google.tagmanager.Container;
import com.google.tagmanager.Log;
import com.google.tagmanager.TagManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;

public class ContainerOpener {
    public static final long DEFAULT_TIMEOUT_IN_MILLIS = 2000L;
    private static final Map<String, List<Notifier>> mContainerIdNotifiersMap = new HashMap<String, List<Notifier>>();
    private final TagManager mTagManager;
    private final String mContainerId;
    private final long mTimeoutInMillis;
    private Notifier mNotifier;
    private volatile Container mContainer;
    private boolean mHaveNotified;
    private Clock mClock = new Clock(){

        @Override
        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }
    };

    private ContainerOpener(TagManager tagManager, String containerId, Long timeoutInMillis, Notifier notifier) {
        this.mTagManager = tagManager;
        this.mContainerId = containerId;
        this.mTimeoutInMillis = timeoutInMillis != null ? Math.max(1L, timeoutInMillis) : 2000L;
        this.mNotifier = notifier;
    }

    public static void openContainer(TagManager tagManager, String containerId, OpenType openType, Long timeoutInMillis, Notifier notifier) {
        if (tagManager == null) {
            throw new NullPointerException("TagManager cannot be null.");
        }
        if (containerId == null) {
            throw new NullPointerException("ContainerId cannot be null.");
        }
        if (openType == null) {
            throw new NullPointerException("OpenType cannot be null.");
        }
        if (notifier == null) {
            throw new NullPointerException("Notifier cannot be null.");
        }
        ContainerOpener containerLoader = new ContainerOpener(tagManager, containerId, timeoutInMillis, notifier);
        containerLoader.open(openType == OpenType.PREFER_FRESH ? Container.RefreshType.NETWORK : Container.RefreshType.SAVED);
    }

    public static ContainerFuture openContainer(TagManager tagManager, String containerId, OpenType openType, Long timeoutInMillis) {
        final ContainerFutureImpl future = new ContainerFutureImpl();
        ContainerOpener.openContainer(tagManager, containerId, openType, timeoutInMillis, new Notifier(){

            @Override
            public void containerAvailable(Container container) {
                future.setContainer(container);
            }
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(Container.RefreshType refreshType) {
        long loadStartTime = this.mClock.currentTimeMillis();
        boolean callNotifierImmediately = false;
        Class<ContainerOpener> clazz = ContainerOpener.class;
        synchronized (ContainerOpener.class) {
            this.mContainer = this.mTagManager.getContainer(this.mContainerId);
            if (this.mContainer == null) {
                ArrayList<Notifier> notifiers = new ArrayList<Notifier>();
                notifiers.add(this.mNotifier);
                this.mNotifier = null;
                mContainerIdNotifiersMap.put(this.mContainerId, notifiers);
                this.mContainer = this.mTagManager.openContainer(this.mContainerId, refreshType == Container.RefreshType.SAVED ? new WaitForNonDefaultRefresh() : new WaitForFresh(loadStartTime - 43200000L));
            } else {
                List<Notifier> notifiers = mContainerIdNotifiersMap.get(this.mContainerId);
                if (notifiers == null) {
                    callNotifierImmediately = true;
                } else {
                    notifiers.add(this.mNotifier);
                    this.mNotifier = null;
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    return;
                }
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (callNotifierImmediately) {
                this.mNotifier.containerAvailable(this.mContainer);
                this.mNotifier = null;
                return;
            }
            long remainingTimeout = this.mTimeoutInMillis - (this.mClock.currentTimeMillis() - loadStartTime);
            this.setTimer(Math.max(1L, remainingTimeout));
            return;
        }
    }

    private void setTimer(long timeoutInMillis) {
        TimerTask timerExpires = new TimerTask(){

            @Override
            public void run() {
                Log.i("Timer expired.");
                ContainerOpener.this.callNotifiers(ContainerOpener.this.mContainer);
            }
        };
        new Timer("ContainerOpener").schedule(timerExpires, timeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void callNotifiers(Container container) {
        if (this.mHaveNotified) return;
        List<Notifier> notifiers = null;
        Class<ContainerOpener> clazz = ContainerOpener.class;
        synchronized (ContainerOpener.class) {
            notifiers = mContainerIdNotifiersMap.remove(this.mContainerId);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (notifiers != null) {
                for (Notifier notifier : notifiers) {
                    notifier.containerAvailable(container);
                }
            }
            this.mHaveNotified = true;
            return;
        }
    }

    private static class ContainerFutureImpl
    implements ContainerFuture {
        private volatile boolean mHaveGotten;
        private volatile Container mContainer;
        private Semaphore mContainerIsReady = new Semaphore(0);

        private ContainerFutureImpl() {
        }

        @Override
        public Container get() {
            if (this.mHaveGotten) {
                return this.mContainer;
            }
            try {
                this.mContainerIsReady.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mHaveGotten = true;
            return this.mContainer;
        }

        public void setContainer(Container container) {
            this.mContainer = container;
            this.mContainerIsReady.release();
        }

        @Override
        public boolean isDone() {
            return this.mHaveGotten || this.mContainerIsReady.availablePermits() > 0;
        }
    }

    private class WaitForFresh
    implements Container.Callback {
        private final long mOldestTimeToBeFresh;

        public WaitForFresh(long oldestTimeToBeFresh) {
            this.mOldestTimeToBeFresh = oldestTimeToBeFresh;
        }

        @Override
        public void containerRefreshBegin(Container container, Container.RefreshType refreshType) {
        }

        @Override
        public void containerRefreshSuccess(Container container, Container.RefreshType refreshType) {
            if (refreshType == Container.RefreshType.NETWORK || this.isFresh()) {
                ContainerOpener.this.callNotifiers(container);
            }
        }

        @Override
        public void containerRefreshFailure(Container container, Container.RefreshType refreshType, Container.RefreshFailure refreshFailure) {
            if (refreshType == Container.RefreshType.NETWORK) {
                ContainerOpener.this.callNotifiers(container);
            }
        }

        private boolean isFresh() {
            return this.mOldestTimeToBeFresh < ContainerOpener.this.mContainer.getLastRefreshTime();
        }
    }

    private class WaitForNonDefaultRefresh
    implements Container.Callback {
        @Override
        public void containerRefreshBegin(Container container, Container.RefreshType refreshType) {
        }

        @Override
        public void containerRefreshSuccess(Container container, Container.RefreshType refreshType) {
            ContainerOpener.this.callNotifiers(container);
        }

        @Override
        public void containerRefreshFailure(Container container, Container.RefreshType refreshType, Container.RefreshFailure refreshFailure) {
            if (refreshType == Container.RefreshType.NETWORK) {
                ContainerOpener.this.callNotifiers(container);
            }
        }
    }

    public static interface Notifier {
        public void containerAvailable(Container var1);
    }

    public static interface ContainerFuture {
        public Container get();

        public boolean isDone();
    }

    public static enum OpenType {
        PREFER_NON_DEFAULT,
        PREFER_FRESH;

    }
}

