/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import android.text.TextUtils;
import com.google.analytics.tracking.android.AppFieldsDefaultProvider;
import com.google.analytics.tracking.android.ClientIdDefaultProvider;
import com.google.analytics.tracking.android.GAUsage;
import com.google.analytics.tracking.android.Log;
import com.google.analytics.tracking.android.RateLimiter;
import com.google.analytics.tracking.android.ScreenResolutionDefaultProvider;
import com.google.analytics.tracking.android.SendHitRateLimiter;
import com.google.analytics.tracking.android.TrackerHandler;
import com.google.analytics.tracking.android.Utils;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Tracker {
    private final String mName;
    private final TrackerHandler mHandler;
    private final Map<String, String> mParams = new HashMap<String, String>();
    private RateLimiter mRateLimiter;
    private final ClientIdDefaultProvider mClientIdDefaultProvider;
    private final ScreenResolutionDefaultProvider mScreenResolutionDefaultProvider;
    private final AppFieldsDefaultProvider mAppFieldsDefaultProvider;

    Tracker(String name, String trackingId, TrackerHandler handler) {
        this(name, trackingId, handler, ClientIdDefaultProvider.getProvider(), ScreenResolutionDefaultProvider.getProvider(), AppFieldsDefaultProvider.getProvider(), new SendHitRateLimiter());
    }

    @VisibleForTesting
    Tracker(String name, String trackingId, TrackerHandler handler, ClientIdDefaultProvider clientIdDefaultProvider, ScreenResolutionDefaultProvider screenResolutionDefaultProvider, AppFieldsDefaultProvider appFieldsDefaultProvider, RateLimiter rateLimiter) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Tracker name cannot be empty.");
        }
        this.mName = name;
        this.mHandler = handler;
        this.mParams.put("&tid", trackingId);
        this.mParams.put("useSecure", "1");
        this.mClientIdDefaultProvider = clientIdDefaultProvider;
        this.mScreenResolutionDefaultProvider = screenResolutionDefaultProvider;
        this.mAppFieldsDefaultProvider = appFieldsDefaultProvider;
        this.mRateLimiter = rateLimiter;
    }

    public String getName() {
        GAUsage.getInstance().setUsage(GAUsage.Field.GET_TRACKER_NAME);
        return this.mName;
    }

    @VisibleForTesting
    RateLimiter getRateLimiter() {
        return this.mRateLimiter;
    }

    public void send(Map<String, String> params) {
        String hitType;
        GAUsage.getInstance().setUsage(GAUsage.Field.SEND);
        HashMap<String, String> paramsToSend = new HashMap<String, String>();
        paramsToSend.putAll(this.mParams);
        if (params != null) {
            paramsToSend.putAll(params);
        }
        if (TextUtils.isEmpty((CharSequence)((CharSequence)paramsToSend.get("&tid")))) {
            Log.w(String.format("Missing tracking id (%s) parameter.", "&tid"));
        }
        if (TextUtils.isEmpty((CharSequence)(hitType = (String)paramsToSend.get("&t")))) {
            Log.w(String.format("Missing hit type (%s) parameter.", "&t"));
            hitType = "";
        }
        if (!(hitType.equals("transaction") || hitType.equals("item") || this.mRateLimiter.tokenAvailable())) {
            Log.w("Too many hits sent too quickly, rate limiting invoked.");
        } else {
            this.mHandler.sendHit(paramsToSend);
        }
    }

    public String get(String key) {
        GAUsage.getInstance().setUsage(GAUsage.Field.GET);
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        if (this.mParams.containsKey(key)) {
            return this.mParams.get(key);
        }
        if (key.equals("&ul")) {
            return Utils.getLanguage(Locale.getDefault());
        }
        if (this.mClientIdDefaultProvider != null && this.mClientIdDefaultProvider.providesField(key)) {
            return this.mClientIdDefaultProvider.getValue(key);
        }
        if (this.mScreenResolutionDefaultProvider != null && this.mScreenResolutionDefaultProvider.providesField(key)) {
            return this.mScreenResolutionDefaultProvider.getValue(key);
        }
        if (this.mAppFieldsDefaultProvider != null && this.mAppFieldsDefaultProvider.providesField(key)) {
            return this.mAppFieldsDefaultProvider.getValue(key);
        }
        return null;
    }

    public void set(String key, String value) {
        GAUsage.getInstance().setUsage(GAUsage.Field.SET);
        if (value == null) {
            this.mParams.remove(key);
        } else {
            this.mParams.put(key, value);
        }
    }
}

