/*
 This Java source file was generated by test-to-java.xsl
 and is a derived work from the source document.
 The source document contained the following notice:



 Copyright (c) 2001 World Wide Web Consortium, 
 (Massachusetts Institute of Technology, Institut National de
 Recherche en Informatique et en Automatique, Keio University).  All 
 Rights Reserved.  This program is distributed under the W3C's Software
 Intellectual Property License.  This program is distributed in the 
 hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  

 See W3C License http://www.w3.org/Consortium/Legal/ for more details.


 */

package tests.org.w3c.dom;

import dalvik.annotation.TestTargets;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargetClass;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;

import javax.xml.parsers.DocumentBuilder;

/**
 * The "removeNamedItemNS(namespaceURI,localName)" method for a NamedNodeMap
 * should remove a node specified by localName and namespaceURI.
 * 
 * Retrieve a list of elements with tag name "address". Access the second
 * element from the list and get its attributes. Try to remove the attribute
 * node with local name "domestic" and namespace uri "http://www.usa.com" with
 * method removeNamedItemNS(namespaceURI,localName). Check to see if the node
 * has been removed.
 * 
 * @author NIST
 * @author Mary Brady
 * @see <a
 *      href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-1074577549">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-1074577549</a>
 */
@TestTargetClass(NamedNodeMap.class) 
public final class RemoveNamedItemNS extends DOMTestCase {

    DOMDocumentBuilderFactory factory;

    DocumentBuilder builder;

    protected void setUp() throws Exception {
        super.setUp();
        try {
            factory = new DOMDocumentBuilderFactory(DOMDocumentBuilderFactory
                    .getConfiguration2());
            builder = factory.getBuilder();
        } catch (Exception e) {
            fail("Unexpected exception" + e.getMessage());
        }
    }

    protected void tearDown() throws Exception {
        factory = null;
        builder = null;
        super.tearDown();
    }

    /**
     * Runs the test case.
     * 
     * @throws Throwable
     *             Any uncaught exception causes test to fail
     */
    @TestTargetNew(
        level = TestLevel.PARTIAL,
        notes = "Doesn't verify DOMException exception.",
        method = "removeNamedItemNS",
        args = {java.lang.String.class, java.lang.String.class}
    )
    public void testRemoveNamedItemNS1() throws Throwable {
        Document doc;
        NodeList elementList;
        Node testAddress;
        NamedNodeMap attributes;
        Attr newAttr;
        Node removedNode;
        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagName("address");
        testAddress = elementList.item(1);
        attributes = testAddress.getAttributes();
        removedNode = attributes.removeNamedItemNS("http://www.usa.com",
                "domestic");
        assertNotNull("retval", removedNode);
        newAttr = (Attr) attributes.getNamedItem("dmstc:domestic");
        assertNull("nodeRemoved", newAttr);
    }
    @TestTargetNew(
        level = TestLevel.PARTIAL,
        notes = "Verifies DOMException with NOT_FOUND_ERR code.",
        method = "removeNamedItemNS",
        args = {java.lang.String.class, java.lang.String.class}
    )
    public void testRemoveNamedItemNS2() throws Throwable {
        String namespaceURI = "http://www.usa.com";
        String localName = "domest";
        Document doc;
        NodeList elementList;
        Node testAddress;
        NamedNodeMap attributes;
        
        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagName("address");
        testAddress = elementList.item(1);
        attributes = testAddress.getAttributes();

        {
            boolean success = false;
            try {
                attributes.removeNamedItemNS(namespaceURI,
                        localName);
            } catch (DOMException ex) {
                success = (ex.code == DOMException.NOT_FOUND_ERR);
            }
            assertTrue("throw_NOT_FOUND_ERR", success);
        }
    }

// Assumes validation.
//    public void testRemoveNamedItemNS3() throws Throwable {
//        String namespaceURI = "http://www.w3.org/2000/xmlns/";
//        String localName = "local1";
//        Document doc;
//        NodeList elementList;
//        Node testAddress;
//        NodeList nList;
//        Node child;
//        NodeList n2List;
//        Node child2;
//        NamedNodeMap attributes;
//        
//        int nodeType;
//        doc = (Document) load("staffNS", builder);
//        elementList = doc.getElementsByTagName("gender");
//        testAddress = elementList.item(2);
//        nList = testAddress.getChildNodes();
//        child = nList.item(0);
//        nodeType = (int) child.getNodeType();
//
//        if (1 == nodeType) {
//            child = doc.createEntityReference("ent4");
//            assertNotNull("createdEntRefNotNull", child);
//        }
//        n2List = child.getChildNodes();
//        child2 = n2List.item(0);
//        assertNotNull("notnull", child2);
//        attributes = child2.getAttributes();
//
//        {
//            boolean success = false;
//            try {
//                attributes.removeNamedItemNS(namespaceURI,
//                        localName);
//            } catch (DOMException ex) {
//                success = (ex.code == DOMException.NO_MODIFICATION_ALLOWED_ERR);
//            }
//            assertTrue("throw_NO_MODIFICATION_ALLOWED_ERR", success);
//        }
//    }
}
