/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.AsciiCP;
import jas.CP;
import jas.ClassEnv;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class GenericAttr {
    CP attr_name;
    byte[] data;

    public GenericAttr(String name, byte[] data) {
        this.attr_name = new AsciiCP(name);
        this.data = data;
    }

    public GenericAttr(CP name, byte[] data) {
        this.attr_name = name;
        this.data = data;
    }

    public GenericAttr(String name, String file) throws IOException, jasError {
        FileInputStream inp;
        try {
            inp = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new jasError("Generic atribute file " + file + " not found");
        }
        this.data = new byte[inp.available()];
        inp.read(this.data);
        inp.close();
        this.attr_name = new AsciiCP(name);
    }

    void resolve(ClassEnv e) {
        e.addCPItem(this.attr_name);
    }

    int size() {
        return 6 + this.data.length;
    }

    void write(ClassEnv e, DataOutputStream out) throws IOException, jasError {
        out.writeShort(e.getCPIndex(this.attr_name));
        out.writeInt(this.data.length);
        out.write(this.data);
    }
}

