/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package java.lang;

/**
 * Thrown when a method is invoked with an argument which it can not reasonably
 * deal with.
 */
public class IllegalArgumentException extends RuntimeException {

    private static final long serialVersionUID = -5365630128856068164L;

    /**
     * Constructs a new {@code IllegalArgumentException} that includes the
     * current stack trace.
     */
    public IllegalArgumentException() {
        super();
    }

    /**
     * Constructs a new {@code IllegalArgumentException} with the current stack
     * trace and the specified detail message.
     * 
     * @param detailMessage
     *            the detail message for this exception.
     */
    public IllegalArgumentException(String detailMessage) {
        super(detailMessage);
    }
    
    /**
     * Constructs a new {@code IllegalArgumentException} with the current stack
     * trace, the specified detail message and the specified cause.
     * 
     * @param message
     *            the detail message for this exception.
     * @param cause
     *            the cause of this exception, may be {@code null}.
     * @since 1.5
     */
    public IllegalArgumentException(String message, Throwable cause) {
        super(message, cause);
    }
    
    /**
     * Constructs a new {@code IllegalArgumentException} with the current stack
     * trace and the specified cause.
     * 
     * @param cause
     *            the cause of this exception, may be {@code null}.
     * @since 1.5
     */
    public IllegalArgumentException(Throwable cause) {
        super((cause == null ? null : cause.toString()), cause);
    }
}
