/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

static data_1_2_t<float, float, int> g_scalbnf_intel_data[] = {
  { // Entry 0
    -0.0f,
    -0x1.p-149,
    (int)-10
  },
  { // Entry 1
    -0x1.555554p-128,
    -0x1.555554p-2,
    (int)-126
  },
  { // Entry 2
    -0x1.6db6dcp-128,
    -0x1.6db6dcp-1,
    (int)-127
  },
  { // Entry 3
    -0x1.8e38e4p-128,
    -0x1.8e38e4p-1,
    (int)-127
  },
  { // Entry 4
    0.0f,
    0x1.p-149,
    (int)-1
  },
  { // Entry 5
    0.0f,
    0x1.p-149,
    (int)-10
  },
  { // Entry 6
    0x1.29e412p-127,
    0x1.29e412p-7,
    (int)-120
  },
  { // Entry 7
    0.0f,
    0x1.dddddep-2,
    (int)-148
  },
  { // Entry 8
    0.0f,
    0x1.ffff60p-127,
    (int)-23
  },
  { // Entry 9
    0.0f,
    0x1.ffff84p-127,
    (int)-23
  },
  { // Entry 10
    0x1.fffff8p-137,
    0x1.fffff8p-127,
    (int)-10
  },
  { // Entry 11
    0.0f,
    0x1.fffffep127,
    (int)(-2147483647-1)
  },
  { // Entry 12
    HUGE_VALF,
    0x1.fffffep127,
    (int)2147483647
  },
  { // Entry 13
    -0x1.p-10,
    -0x1.p0,
    (int)-10
  },
  { // Entry 14
    -0x1.p-9,
    -0x1.p0,
    (int)-9
  },
  { // Entry 15
    -0x1.p-8,
    -0x1.p0,
    (int)-8
  },
  { // Entry 16
    -0x1.p-7,
    -0x1.p0,
    (int)-7
  },
  { // Entry 17
    -0x1.p-6,
    -0x1.p0,
    (int)-6
  },
  { // Entry 18
    -0x1.p-5,
    -0x1.p0,
    (int)-5
  },
  { // Entry 19
    -0x1.p-4,
    -0x1.p0,
    (int)-4
  },
  { // Entry 20
    -0x1.p-3,
    -0x1.p0,
    (int)-3
  },
  { // Entry 21
    -0x1.p-2,
    -0x1.p0,
    (int)-2
  },
  { // Entry 22
    -0x1.p-1,
    -0x1.p0,
    (int)-1
  },
  { // Entry 23
    -0x1.p0,
    -0x1.p0,
    (int)0
  },
  { // Entry 24
    -0x1.p1,
    -0x1.p0,
    (int)1
  },
  { // Entry 25
    -0x1.p2,
    -0x1.p0,
    (int)2
  },
  { // Entry 26
    -0x1.p3,
    -0x1.p0,
    (int)3
  },
  { // Entry 27
    -0x1.p4,
    -0x1.p0,
    (int)4
  },
  { // Entry 28
    -0x1.p5,
    -0x1.p0,
    (int)5
  },
  { // Entry 29
    -0x1.p6,
    -0x1.p0,
    (int)6
  },
  { // Entry 30
    -0x1.p7,
    -0x1.p0,
    (int)7
  },
  { // Entry 31
    -0x1.p8,
    -0x1.p0,
    (int)8
  },
  { // Entry 32
    -0x1.p9,
    -0x1.p0,
    (int)9
  },
  { // Entry 33
    -0x1.p10,
    -0x1.p0,
    (int)10
  },
  { // Entry 34
    -0x1.d1745cp-11,
    -0x1.d1745cp-1,
    (int)-10
  },
  { // Entry 35
    -0x1.d1745cp-10,
    -0x1.d1745cp-1,
    (int)-9
  },
  { // Entry 36
    -0x1.d1745cp-9,
    -0x1.d1745cp-1,
    (int)-8
  },
  { // Entry 37
    -0x1.d1745cp-8,
    -0x1.d1745cp-1,
    (int)-7
  },
  { // Entry 38
    -0x1.d1745cp-7,
    -0x1.d1745cp-1,
    (int)-6
  },
  { // Entry 39
    -0x1.d1745cp-6,
    -0x1.d1745cp-1,
    (int)-5
  },
  { // Entry 40
    -0x1.d1745cp-5,
    -0x1.d1745cp-1,
    (int)-4
  },
  { // Entry 41
    -0x1.d1745cp-4,
    -0x1.d1745cp-1,
    (int)-3
  },
  { // Entry 42
    -0x1.d1745cp-3,
    -0x1.d1745cp-1,
    (int)-2
  },
  { // Entry 43
    -0x1.d1745cp-2,
    -0x1.d1745cp-1,
    (int)-1
  },
  { // Entry 44
    -0x1.d1745cp-1,
    -0x1.d1745cp-1,
    (int)0
  },
  { // Entry 45
    -0x1.d1745cp0,
    -0x1.d1745cp-1,
    (int)1
  },
  { // Entry 46
    -0x1.d1745cp1,
    -0x1.d1745cp-1,
    (int)2
  },
  { // Entry 47
    -0x1.d1745cp2,
    -0x1.d1745cp-1,
    (int)3
  },
  { // Entry 48
    -0x1.d1745cp3,
    -0x1.d1745cp-1,
    (int)4
  },
  { // Entry 49
    -0x1.d1745cp4,
    -0x1.d1745cp-1,
    (int)5
  },
  { // Entry 50
    -0x1.d1745cp5,
    -0x1.d1745cp-1,
    (int)6
  },
  { // Entry 51
    -0x1.d1745cp6,
    -0x1.d1745cp-1,
    (int)7
  },
  { // Entry 52
    -0x1.d1745cp7,
    -0x1.d1745cp-1,
    (int)8
  },
  { // Entry 53
    -0x1.d1745cp8,
    -0x1.d1745cp-1,
    (int)9
  },
  { // Entry 54
    -0x1.d1745cp9,
    -0x1.d1745cp-1,
    (int)10
  },
  { // Entry 55
    -0x1.a2e8b8p-11,
    -0x1.a2e8b8p-1,
    (int)-10
  },
  { // Entry 56
    -0x1.a2e8b8p-10,
    -0x1.a2e8b8p-1,
    (int)-9
  },
  { // Entry 57
    -0x1.a2e8b8p-9,
    -0x1.a2e8b8p-1,
    (int)-8
  },
  { // Entry 58
    -0x1.a2e8b8p-8,
    -0x1.a2e8b8p-1,
    (int)-7
  },
  { // Entry 59
    -0x1.a2e8b8p-7,
    -0x1.a2e8b8p-1,
    (int)-6
  },
  { // Entry 60
    -0x1.a2e8b8p-6,
    -0x1.a2e8b8p-1,
    (int)-5
  },
  { // Entry 61
    -0x1.a2e8b8p-5,
    -0x1.a2e8b8p-1,
    (int)-4
  },
  { // Entry 62
    -0x1.a2e8b8p-4,
    -0x1.a2e8b8p-1,
    (int)-3
  },
  { // Entry 63
    -0x1.a2e8b8p-3,
    -0x1.a2e8b8p-1,
    (int)-2
  },
  { // Entry 64
    -0x1.a2e8b8p-2,
    -0x1.a2e8b8p-1,
    (int)-1
  },
  { // Entry 65
    -0x1.a2e8b8p-1,
    -0x1.a2e8b8p-1,
    (int)0
  },
  { // Entry 66
    -0x1.a2e8b8p0,
    -0x1.a2e8b8p-1,
    (int)1
  },
  { // Entry 67
    -0x1.a2e8b8p1,
    -0x1.a2e8b8p-1,
    (int)2
  },
  { // Entry 68
    -0x1.a2e8b8p2,
    -0x1.a2e8b8p-1,
    (int)3
  },
  { // Entry 69
    -0x1.a2e8b8p3,
    -0x1.a2e8b8p-1,
    (int)4
  },
  { // Entry 70
    -0x1.a2e8b8p4,
    -0x1.a2e8b8p-1,
    (int)5
  },
  { // Entry 71
    -0x1.a2e8b8p5,
    -0x1.a2e8b8p-1,
    (int)6
  },
  { // Entry 72
    -0x1.a2e8b8p6,
    -0x1.a2e8b8p-1,
    (int)7
  },
  { // Entry 73
    -0x1.a2e8b8p7,
    -0x1.a2e8b8p-1,
    (int)8
  },
  { // Entry 74
    -0x1.a2e8b8p8,
    -0x1.a2e8b8p-1,
    (int)9
  },
  { // Entry 75
    -0x1.a2e8b8p9,
    -0x1.a2e8b8p-1,
    (int)10
  },
  { // Entry 76
    -0x1.745d14p-11,
    -0x1.745d14p-1,
    (int)-10
  },
  { // Entry 77
    -0x1.745d14p-10,
    -0x1.745d14p-1,
    (int)-9
  },
  { // Entry 78
    -0x1.745d14p-9,
    -0x1.745d14p-1,
    (int)-8
  },
  { // Entry 79
    -0x1.745d14p-8,
    -0x1.745d14p-1,
    (int)-7
  },
  { // Entry 80
    -0x1.745d14p-7,
    -0x1.745d14p-1,
    (int)-6
  },
  { // Entry 81
    -0x1.745d14p-6,
    -0x1.745d14p-1,
    (int)-5
  },
  { // Entry 82
    -0x1.745d14p-5,
    -0x1.745d14p-1,
    (int)-4
  },
  { // Entry 83
    -0x1.745d14p-4,
    -0x1.745d14p-1,
    (int)-3
  },
  { // Entry 84
    -0x1.745d14p-3,
    -0x1.745d14p-1,
    (int)-2
  },
  { // Entry 85
    -0x1.745d14p-2,
    -0x1.745d14p-1,
    (int)-1
  },
  { // Entry 86
    -0x1.745d14p-1,
    -0x1.745d14p-1,
    (int)0
  },
  { // Entry 87
    -0x1.745d14p0,
    -0x1.745d14p-1,
    (int)1
  },
  { // Entry 88
    -0x1.745d14p1,
    -0x1.745d14p-1,
    (int)2
  },
  { // Entry 89
    -0x1.745d14p2,
    -0x1.745d14p-1,
    (int)3
  },
  { // Entry 90
    -0x1.745d14p3,
    -0x1.745d14p-1,
    (int)4
  },
  { // Entry 91
    -0x1.745d14p4,
    -0x1.745d14p-1,
    (int)5
  },
  { // Entry 92
    -0x1.745d14p5,
    -0x1.745d14p-1,
    (int)6
  },
  { // Entry 93
    -0x1.745d14p6,
    -0x1.745d14p-1,
    (int)7
  },
  { // Entry 94
    -0x1.745d14p7,
    -0x1.745d14p-1,
    (int)8
  },
  { // Entry 95
    -0x1.745d14p8,
    -0x1.745d14p-1,
    (int)9
  },
  { // Entry 96
    -0x1.745d14p9,
    -0x1.745d14p-1,
    (int)10
  },
  { // Entry 97
    -0x1.45d170p-11,
    -0x1.45d170p-1,
    (int)-10
  },
  { // Entry 98
    -0x1.45d170p-10,
    -0x1.45d170p-1,
    (int)-9
  },
  { // Entry 99
    -0x1.45d170p-9,
    -0x1.45d170p-1,
    (int)-8
  },
  { // Entry 100
    -0x1.45d170p-8,
    -0x1.45d170p-1,
    (int)-7
  },
  { // Entry 101
    -0x1.45d170p-7,
    -0x1.45d170p-1,
    (int)-6
  },
  { // Entry 102
    -0x1.45d170p-6,
    -0x1.45d170p-1,
    (int)-5
  },
  { // Entry 103
    -0x1.45d170p-5,
    -0x1.45d170p-1,
    (int)-4
  },
  { // Entry 104
    -0x1.45d170p-4,
    -0x1.45d170p-1,
    (int)-3
  },
  { // Entry 105
    -0x1.45d170p-3,
    -0x1.45d170p-1,
    (int)-2
  },
  { // Entry 106
    -0x1.45d170p-2,
    -0x1.45d170p-1,
    (int)-1
  },
  { // Entry 107
    -0x1.45d170p-1,
    -0x1.45d170p-1,
    (int)0
  },
  { // Entry 108
    -0x1.45d170p0,
    -0x1.45d170p-1,
    (int)1
  },
  { // Entry 109
    -0x1.45d170p1,
    -0x1.45d170p-1,
    (int)2
  },
  { // Entry 110
    -0x1.45d170p2,
    -0x1.45d170p-1,
    (int)3
  },
  { // Entry 111
    -0x1.45d170p3,
    -0x1.45d170p-1,
    (int)4
  },
  { // Entry 112
    -0x1.45d170p4,
    -0x1.45d170p-1,
    (int)5
  },
  { // Entry 113
    -0x1.45d170p5,
    -0x1.45d170p-1,
    (int)6
  },
  { // Entry 114
    -0x1.45d170p6,
    -0x1.45d170p-1,
    (int)7
  },
  { // Entry 115
    -0x1.45d170p7,
    -0x1.45d170p-1,
    (int)8
  },
  { // Entry 116
    -0x1.45d170p8,
    -0x1.45d170p-1,
    (int)9
  },
  { // Entry 117
    -0x1.45d170p9,
    -0x1.45d170p-1,
    (int)10
  },
  { // Entry 118
    -0x1.1745ccp-11,
    -0x1.1745ccp-1,
    (int)-10
  },
  { // Entry 119
    -0x1.1745ccp-10,
    -0x1.1745ccp-1,
    (int)-9
  },
  { // Entry 120
    -0x1.1745ccp-9,
    -0x1.1745ccp-1,
    (int)-8
  },
  { // Entry 121
    -0x1.1745ccp-8,
    -0x1.1745ccp-1,
    (int)-7
  },
  { // Entry 122
    -0x1.1745ccp-7,
    -0x1.1745ccp-1,
    (int)-6
  },
  { // Entry 123
    -0x1.1745ccp-6,
    -0x1.1745ccp-1,
    (int)-5
  },
  { // Entry 124
    -0x1.1745ccp-5,
    -0x1.1745ccp-1,
    (int)-4
  },
  { // Entry 125
    -0x1.1745ccp-4,
    -0x1.1745ccp-1,
    (int)-3
  },
  { // Entry 126
    -0x1.1745ccp-3,
    -0x1.1745ccp-1,
    (int)-2
  },
  { // Entry 127
    -0x1.1745ccp-2,
    -0x1.1745ccp-1,
    (int)-1
  },
  { // Entry 128
    -0x1.1745ccp-1,
    -0x1.1745ccp-1,
    (int)0
  },
  { // Entry 129
    -0x1.1745ccp0,
    -0x1.1745ccp-1,
    (int)1
  },
  { // Entry 130
    -0x1.1745ccp1,
    -0x1.1745ccp-1,
    (int)2
  },
  { // Entry 131
    -0x1.1745ccp2,
    -0x1.1745ccp-1,
    (int)3
  },
  { // Entry 132
    -0x1.1745ccp3,
    -0x1.1745ccp-1,
    (int)4
  },
  { // Entry 133
    -0x1.1745ccp4,
    -0x1.1745ccp-1,
    (int)5
  },
  { // Entry 134
    -0x1.1745ccp5,
    -0x1.1745ccp-1,
    (int)6
  },
  { // Entry 135
    -0x1.1745ccp6,
    -0x1.1745ccp-1,
    (int)7
  },
  { // Entry 136
    -0x1.1745ccp7,
    -0x1.1745ccp-1,
    (int)8
  },
  { // Entry 137
    -0x1.1745ccp8,
    -0x1.1745ccp-1,
    (int)9
  },
  { // Entry 138
    -0x1.1745ccp9,
    -0x1.1745ccp-1,
    (int)10
  },
  { // Entry 139
    -0x1.d17452p-12,
    -0x1.d17452p-2,
    (int)-10
  },
  { // Entry 140
    -0x1.d17452p-11,
    -0x1.d17452p-2,
    (int)-9
  },
  { // Entry 141
    -0x1.d17452p-10,
    -0x1.d17452p-2,
    (int)-8
  },
  { // Entry 142
    -0x1.d17452p-9,
    -0x1.d17452p-2,
    (int)-7
  },
  { // Entry 143
    -0x1.d17452p-8,
    -0x1.d17452p-2,
    (int)-6
  },
  { // Entry 144
    -0x1.d17452p-7,
    -0x1.d17452p-2,
    (int)-5
  },
  { // Entry 145
    -0x1.d17452p-6,
    -0x1.d17452p-2,
    (int)-4
  },
  { // Entry 146
    -0x1.d17452p-5,
    -0x1.d17452p-2,
    (int)-3
  },
  { // Entry 147
    -0x1.d17452p-4,
    -0x1.d17452p-2,
    (int)-2
  },
  { // Entry 148
    -0x1.d17452p-3,
    -0x1.d17452p-2,
    (int)-1
  },
  { // Entry 149
    -0x1.d17452p-2,
    -0x1.d17452p-2,
    (int)0
  },
  { // Entry 150
    -0x1.d17452p-1,
    -0x1.d17452p-2,
    (int)1
  },
  { // Entry 151
    -0x1.d17452p0,
    -0x1.d17452p-2,
    (int)2
  },
  { // Entry 152
    -0x1.d17452p1,
    -0x1.d17452p-2,
    (int)3
  },
  { // Entry 153
    -0x1.d17452p2,
    -0x1.d17452p-2,
    (int)4
  },
  { // Entry 154
    -0x1.d17452p3,
    -0x1.d17452p-2,
    (int)5
  },
  { // Entry 155
    -0x1.d17452p4,
    -0x1.d17452p-2,
    (int)6
  },
  { // Entry 156
    -0x1.d17452p5,
    -0x1.d17452p-2,
    (int)7
  },
  { // Entry 157
    -0x1.d17452p6,
    -0x1.d17452p-2,
    (int)8
  },
  { // Entry 158
    -0x1.d17452p7,
    -0x1.d17452p-2,
    (int)9
  },
  { // Entry 159
    -0x1.d17452p8,
    -0x1.d17452p-2,
    (int)10
  },
  { // Entry 160
    -0x1.745d0cp-12,
    -0x1.745d0cp-2,
    (int)-10
  },
  { // Entry 161
    -0x1.745d0cp-11,
    -0x1.745d0cp-2,
    (int)-9
  },
  { // Entry 162
    -0x1.745d0cp-10,
    -0x1.745d0cp-2,
    (int)-8
  },
  { // Entry 163
    -0x1.745d0cp-9,
    -0x1.745d0cp-2,
    (int)-7
  },
  { // Entry 164
    -0x1.745d0cp-8,
    -0x1.745d0cp-2,
    (int)-6
  },
  { // Entry 165
    -0x1.745d0cp-7,
    -0x1.745d0cp-2,
    (int)-5
  },
  { // Entry 166
    -0x1.745d0cp-6,
    -0x1.745d0cp-2,
    (int)-4
  },
  { // Entry 167
    -0x1.745d0cp-5,
    -0x1.745d0cp-2,
    (int)-3
  },
  { // Entry 168
    -0x1.745d0cp-4,
    -0x1.745d0cp-2,
    (int)-2
  },
  { // Entry 169
    -0x1.745d0cp-3,
    -0x1.745d0cp-2,
    (int)-1
  },
  { // Entry 170
    -0x1.745d0cp-2,
    -0x1.745d0cp-2,
    (int)0
  },
  { // Entry 171
    -0x1.745d0cp-1,
    -0x1.745d0cp-2,
    (int)1
  },
  { // Entry 172
    -0x1.745d0cp0,
    -0x1.745d0cp-2,
    (int)2
  },
  { // Entry 173
    -0x1.745d0cp1,
    -0x1.745d0cp-2,
    (int)3
  },
  { // Entry 174
    -0x1.745d0cp2,
    -0x1.745d0cp-2,
    (int)4
  },
  { // Entry 175
    -0x1.745d0cp3,
    -0x1.745d0cp-2,
    (int)5
  },
  { // Entry 176
    -0x1.745d0cp4,
    -0x1.745d0cp-2,
    (int)6
  },
  { // Entry 177
    -0x1.745d0cp5,
    -0x1.745d0cp-2,
    (int)7
  },
  { // Entry 178
    -0x1.745d0cp6,
    -0x1.745d0cp-2,
    (int)8
  },
  { // Entry 179
    -0x1.745d0cp7,
    -0x1.745d0cp-2,
    (int)9
  },
  { // Entry 180
    -0x1.745d0cp8,
    -0x1.745d0cp-2,
    (int)10
  },
  { // Entry 181
    -0x1.1745c6p-12,
    -0x1.1745c6p-2,
    (int)-10
  },
  { // Entry 182
    -0x1.1745c6p-11,
    -0x1.1745c6p-2,
    (int)-9
  },
  { // Entry 183
    -0x1.1745c6p-10,
    -0x1.1745c6p-2,
    (int)-8
  },
  { // Entry 184
    -0x1.1745c6p-9,
    -0x1.1745c6p-2,
    (int)-7
  },
  { // Entry 185
    -0x1.1745c6p-8,
    -0x1.1745c6p-2,
    (int)-6
  },
  { // Entry 186
    -0x1.1745c6p-7,
    -0x1.1745c6p-2,
    (int)-5
  },
  { // Entry 187
    -0x1.1745c6p-6,
    -0x1.1745c6p-2,
    (int)-4
  },
  { // Entry 188
    -0x1.1745c6p-5,
    -0x1.1745c6p-2,
    (int)-3
  },
  { // Entry 189
    -0x1.1745c6p-4,
    -0x1.1745c6p-2,
    (int)-2
  },
  { // Entry 190
    -0x1.1745c6p-3,
    -0x1.1745c6p-2,
    (int)-1
  },
  { // Entry 191
    -0x1.1745c6p-2,
    -0x1.1745c6p-2,
    (int)0
  },
  { // Entry 192
    -0x1.1745c6p-1,
    -0x1.1745c6p-2,
    (int)1
  },
  { // Entry 193
    -0x1.1745c6p0,
    -0x1.1745c6p-2,
    (int)2
  },
  { // Entry 194
    -0x1.1745c6p1,
    -0x1.1745c6p-2,
    (int)3
  },
  { // Entry 195
    -0x1.1745c6p2,
    -0x1.1745c6p-2,
    (int)4
  },
  { // Entry 196
    -0x1.1745c6p3,
    -0x1.1745c6p-2,
    (int)5
  },
  { // Entry 197
    -0x1.1745c6p4,
    -0x1.1745c6p-2,
    (int)6
  },
  { // Entry 198
    -0x1.1745c6p5,
    -0x1.1745c6p-2,
    (int)7
  },
  { // Entry 199
    -0x1.1745c6p6,
    -0x1.1745c6p-2,
    (int)8
  },
  { // Entry 200
    -0x1.1745c6p7,
    -0x1.1745c6p-2,
    (int)9
  },
  { // Entry 201
    -0x1.1745c6p8,
    -0x1.1745c6p-2,
    (int)10
  },
  { // Entry 202
    -0x1.745dp-13,
    -0x1.745dp-3,
    (int)-10
  },
  { // Entry 203
    -0x1.745dp-12,
    -0x1.745dp-3,
    (int)-9
  },
  { // Entry 204
    -0x1.745dp-11,
    -0x1.745dp-3,
    (int)-8
  },
  { // Entry 205
    -0x1.745dp-10,
    -0x1.745dp-3,
    (int)-7
  },
  { // Entry 206
    -0x1.745dp-9,
    -0x1.745dp-3,
    (int)-6
  },
  { // Entry 207
    -0x1.745dp-8,
    -0x1.745dp-3,
    (int)-5
  },
  { // Entry 208
    -0x1.745dp-7,
    -0x1.745dp-3,
    (int)-4
  },
  { // Entry 209
    -0x1.745dp-6,
    -0x1.745dp-3,
    (int)-3
  },
  { // Entry 210
    -0x1.745dp-5,
    -0x1.745dp-3,
    (int)-2
  },
  { // Entry 211
    -0x1.745dp-4,
    -0x1.745dp-3,
    (int)-1
  },
  { // Entry 212
    -0x1.745dp-3,
    -0x1.745dp-3,
    (int)0
  },
  { // Entry 213
    -0x1.745dp-2,
    -0x1.745dp-3,
    (int)1
  },
  { // Entry 214
    -0x1.745dp-1,
    -0x1.745dp-3,
    (int)2
  },
  { // Entry 215
    -0x1.745dp0,
    -0x1.745dp-3,
    (int)3
  },
  { // Entry 216
    -0x1.745dp1,
    -0x1.745dp-3,
    (int)4
  },
  { // Entry 217
    -0x1.745dp2,
    -0x1.745dp-3,
    (int)5
  },
  { // Entry 218
    -0x1.745dp3,
    -0x1.745dp-3,
    (int)6
  },
  { // Entry 219
    -0x1.745dp4,
    -0x1.745dp-3,
    (int)7
  },
  { // Entry 220
    -0x1.745dp5,
    -0x1.745dp-3,
    (int)8
  },
  { // Entry 221
    -0x1.745dp6,
    -0x1.745dp-3,
    (int)9
  },
  { // Entry 222
    -0x1.745dp7,
    -0x1.745dp-3,
    (int)10
  },
  { // Entry 223
    -0x1.745ce8p-14,
    -0x1.745ce8p-4,
    (int)-10
  },
  { // Entry 224
    -0x1.745ce8p-13,
    -0x1.745ce8p-4,
    (int)-9
  },
  { // Entry 225
    -0x1.745ce8p-12,
    -0x1.745ce8p-4,
    (int)-8
  },
  { // Entry 226
    -0x1.745ce8p-11,
    -0x1.745ce8p-4,
    (int)-7
  },
  { // Entry 227
    -0x1.745ce8p-10,
    -0x1.745ce8p-4,
    (int)-6
  },
  { // Entry 228
    -0x1.745ce8p-9,
    -0x1.745ce8p-4,
    (int)-5
  },
  { // Entry 229
    -0x1.745ce8p-8,
    -0x1.745ce8p-4,
    (int)-4
  },
  { // Entry 230
    -0x1.745ce8p-7,
    -0x1.745ce8p-4,
    (int)-3
  },
  { // Entry 231
    -0x1.745ce8p-6,
    -0x1.745ce8p-4,
    (int)-2
  },
  { // Entry 232
    -0x1.745ce8p-5,
    -0x1.745ce8p-4,
    (int)-1
  },
  { // Entry 233
    -0x1.745ce8p-4,
    -0x1.745ce8p-4,
    (int)0
  },
  { // Entry 234
    -0x1.745ce8p-3,
    -0x1.745ce8p-4,
    (int)1
  },
  { // Entry 235
    -0x1.745ce8p-2,
    -0x1.745ce8p-4,
    (int)2
  },
  { // Entry 236
    -0x1.745ce8p-1,
    -0x1.745ce8p-4,
    (int)3
  },
  { // Entry 237
    -0x1.745ce8p0,
    -0x1.745ce8p-4,
    (int)4
  },
  { // Entry 238
    -0x1.745ce8p1,
    -0x1.745ce8p-4,
    (int)5
  },
  { // Entry 239
    -0x1.745ce8p2,
    -0x1.745ce8p-4,
    (int)6
  },
  { // Entry 240
    -0x1.745ce8p3,
    -0x1.745ce8p-4,
    (int)7
  },
  { // Entry 241
    -0x1.745ce8p4,
    -0x1.745ce8p-4,
    (int)8
  },
  { // Entry 242
    -0x1.745ce8p5,
    -0x1.745ce8p-4,
    (int)9
  },
  { // Entry 243
    -0x1.745ce8p6,
    -0x1.745ce8p-4,
    (int)10
  },
  { // Entry 244
    0x1.80p-33,
    0x1.80p-23,
    (int)-10
  },
  { // Entry 245
    0x1.80p-32,
    0x1.80p-23,
    (int)-9
  },
  { // Entry 246
    0x1.80p-31,
    0x1.80p-23,
    (int)-8
  },
  { // Entry 247
    0x1.80p-30,
    0x1.80p-23,
    (int)-7
  },
  { // Entry 248
    0x1.80p-29,
    0x1.80p-23,
    (int)-6
  },
  { // Entry 249
    0x1.80p-28,
    0x1.80p-23,
    (int)-5
  },
  { // Entry 250
    0x1.80p-27,
    0x1.80p-23,
    (int)-4
  },
  { // Entry 251
    0x1.80p-26,
    0x1.80p-23,
    (int)-3
  },
  { // Entry 252
    0x1.80p-25,
    0x1.80p-23,
    (int)-2
  },
  { // Entry 253
    0x1.80p-24,
    0x1.80p-23,
    (int)-1
  },
  { // Entry 254
    0x1.80p-23,
    0x1.80p-23,
    (int)0
  },
  { // Entry 255
    0x1.80p-22,
    0x1.80p-23,
    (int)1
  },
  { // Entry 256
    0x1.80p-21,
    0x1.80p-23,
    (int)2
  },
  { // Entry 257
    0x1.80p-20,
    0x1.80p-23,
    (int)3
  },
  { // Entry 258
    0x1.80p-19,
    0x1.80p-23,
    (int)4
  },
  { // Entry 259
    0x1.80p-18,
    0x1.80p-23,
    (int)5
  },
  { // Entry 260
    0x1.80p-17,
    0x1.80p-23,
    (int)6
  },
  { // Entry 261
    0x1.80p-16,
    0x1.80p-23,
    (int)7
  },
  { // Entry 262
    0x1.80p-15,
    0x1.80p-23,
    (int)8
  },
  { // Entry 263
    0x1.80p-14,
    0x1.80p-23,
    (int)9
  },
  { // Entry 264
    0x1.80p-13,
    0x1.80p-23,
    (int)10
  },
  { // Entry 265
    0x1.745d48p-14,
    0x1.745d48p-4,
    (int)-10
  },
  { // Entry 266
    0x1.745d48p-13,
    0x1.745d48p-4,
    (int)-9
  },
  { // Entry 267
    0x1.745d48p-12,
    0x1.745d48p-4,
    (int)-8
  },
  { // Entry 268
    0x1.745d48p-11,
    0x1.745d48p-4,
    (int)-7
  },
  { // Entry 269
    0x1.745d48p-10,
    0x1.745d48p-4,
    (int)-6
  },
  { // Entry 270
    0x1.745d48p-9,
    0x1.745d48p-4,
    (int)-5
  },
  { // Entry 271
    0x1.745d48p-8,
    0x1.745d48p-4,
    (int)-4
  },
  { // Entry 272
    0x1.745d48p-7,
    0x1.745d48p-4,
    (int)-3
  },
  { // Entry 273
    0x1.745d48p-6,
    0x1.745d48p-4,
    (int)-2
  },
  { // Entry 274
    0x1.745d48p-5,
    0x1.745d48p-4,
    (int)-1
  },
  { // Entry 275
    0x1.745d48p-4,
    0x1.745d48p-4,
    (int)0
  },
  { // Entry 276
    0x1.745d48p-3,
    0x1.745d48p-4,
    (int)1
  },
  { // Entry 277
    0x1.745d48p-2,
    0x1.745d48p-4,
    (int)2
  },
  { // Entry 278
    0x1.745d48p-1,
    0x1.745d48p-4,
    (int)3
  },
  { // Entry 279
    0x1.745d48p0,
    0x1.745d48p-4,
    (int)4
  },
  { // Entry 280
    0x1.745d48p1,
    0x1.745d48p-4,
    (int)5
  },
  { // Entry 281
    0x1.745d48p2,
    0x1.745d48p-4,
    (int)6
  },
  { // Entry 282
    0x1.745d48p3,
    0x1.745d48p-4,
    (int)7
  },
  { // Entry 283
    0x1.745d48p4,
    0x1.745d48p-4,
    (int)8
  },
  { // Entry 284
    0x1.745d48p5,
    0x1.745d48p-4,
    (int)9
  },
  { // Entry 285
    0x1.745d48p6,
    0x1.745d48p-4,
    (int)10
  },
  { // Entry 286
    0x1.745d30p-13,
    0x1.745d30p-3,
    (int)-10
  },
  { // Entry 287
    0x1.745d30p-12,
    0x1.745d30p-3,
    (int)-9
  },
  { // Entry 288
    0x1.745d30p-11,
    0x1.745d30p-3,
    (int)-8
  },
  { // Entry 289
    0x1.745d30p-10,
    0x1.745d30p-3,
    (int)-7
  },
  { // Entry 290
    0x1.745d30p-9,
    0x1.745d30p-3,
    (int)-6
  },
  { // Entry 291
    0x1.745d30p-8,
    0x1.745d30p-3,
    (int)-5
  },
  { // Entry 292
    0x1.745d30p-7,
    0x1.745d30p-3,
    (int)-4
  },
  { // Entry 293
    0x1.745d30p-6,
    0x1.745d30p-3,
    (int)-3
  },
  { // Entry 294
    0x1.745d30p-5,
    0x1.745d30p-3,
    (int)-2
  },
  { // Entry 295
    0x1.745d30p-4,
    0x1.745d30p-3,
    (int)-1
  },
  { // Entry 296
    0x1.745d30p-3,
    0x1.745d30p-3,
    (int)0
  },
  { // Entry 297
    0x1.745d30p-2,
    0x1.745d30p-3,
    (int)1
  },
  { // Entry 298
    0x1.745d30p-1,
    0x1.745d30p-3,
    (int)2
  },
  { // Entry 299
    0x1.745d30p0,
    0x1.745d30p-3,
    (int)3
  },
  { // Entry 300
    0x1.745d30p1,
    0x1.745d30p-3,
    (int)4
  },
  { // Entry 301
    0x1.745d30p2,
    0x1.745d30p-3,
    (int)5
  },
  { // Entry 302
    0x1.745d30p3,
    0x1.745d30p-3,
    (int)6
  },
  { // Entry 303
    0x1.745d30p4,
    0x1.745d30p-3,
    (int)7
  },
  { // Entry 304
    0x1.745d30p5,
    0x1.745d30p-3,
    (int)8
  },
  { // Entry 305
    0x1.745d30p6,
    0x1.745d30p-3,
    (int)9
  },
  { // Entry 306
    0x1.745d30p7,
    0x1.745d30p-3,
    (int)10
  },
  { // Entry 307
    0x1.1745dep-12,
    0x1.1745dep-2,
    (int)-10
  },
  { // Entry 308
    0x1.1745dep-11,
    0x1.1745dep-2,
    (int)-9
  },
  { // Entry 309
    0x1.1745dep-10,
    0x1.1745dep-2,
    (int)-8
  },
  { // Entry 310
    0x1.1745dep-9,
    0x1.1745dep-2,
    (int)-7
  },
  { // Entry 311
    0x1.1745dep-8,
    0x1.1745dep-2,
    (int)-6
  },
  { // Entry 312
    0x1.1745dep-7,
    0x1.1745dep-2,
    (int)-5
  },
  { // Entry 313
    0x1.1745dep-6,
    0x1.1745dep-2,
    (int)-4
  },
  { // Entry 314
    0x1.1745dep-5,
    0x1.1745dep-2,
    (int)-3
  },
  { // Entry 315
    0x1.1745dep-4,
    0x1.1745dep-2,
    (int)-2
  },
  { // Entry 316
    0x1.1745dep-3,
    0x1.1745dep-2,
    (int)-1
  },
  { // Entry 317
    0x1.1745dep-2,
    0x1.1745dep-2,
    (int)0
  },
  { // Entry 318
    0x1.1745dep-1,
    0x1.1745dep-2,
    (int)1
  },
  { // Entry 319
    0x1.1745dep0,
    0x1.1745dep-2,
    (int)2
  },
  { // Entry 320
    0x1.1745dep1,
    0x1.1745dep-2,
    (int)3
  },
  { // Entry 321
    0x1.1745dep2,
    0x1.1745dep-2,
    (int)4
  },
  { // Entry 322
    0x1.1745dep3,
    0x1.1745dep-2,
    (int)5
  },
  { // Entry 323
    0x1.1745dep4,
    0x1.1745dep-2,
    (int)6
  },
  { // Entry 324
    0x1.1745dep5,
    0x1.1745dep-2,
    (int)7
  },
  { // Entry 325
    0x1.1745dep6,
    0x1.1745dep-2,
    (int)8
  },
  { // Entry 326
    0x1.1745dep7,
    0x1.1745dep-2,
    (int)9
  },
  { // Entry 327
    0x1.1745dep8,
    0x1.1745dep-2,
    (int)10
  },
  { // Entry 328
    0x1.745d24p-12,
    0x1.745d24p-2,
    (int)-10
  },
  { // Entry 329
    0x1.745d24p-11,
    0x1.745d24p-2,
    (int)-9
  },
  { // Entry 330
    0x1.745d24p-10,
    0x1.745d24p-2,
    (int)-8
  },
  { // Entry 331
    0x1.745d24p-9,
    0x1.745d24p-2,
    (int)-7
  },
  { // Entry 332
    0x1.745d24p-8,
    0x1.745d24p-2,
    (int)-6
  },
  { // Entry 333
    0x1.745d24p-7,
    0x1.745d24p-2,
    (int)-5
  },
  { // Entry 334
    0x1.745d24p-6,
    0x1.745d24p-2,
    (int)-4
  },
  { // Entry 335
    0x1.745d24p-5,
    0x1.745d24p-2,
    (int)-3
  },
  { // Entry 336
    0x1.745d24p-4,
    0x1.745d24p-2,
    (int)-2
  },
  { // Entry 337
    0x1.745d24p-3,
    0x1.745d24p-2,
    (int)-1
  },
  { // Entry 338
    0x1.745d24p-2,
    0x1.745d24p-2,
    (int)0
  },
  { // Entry 339
    0x1.745d24p-1,
    0x1.745d24p-2,
    (int)1
  },
  { // Entry 340
    0x1.745d24p0,
    0x1.745d24p-2,
    (int)2
  },
  { // Entry 341
    0x1.745d24p1,
    0x1.745d24p-2,
    (int)3
  },
  { // Entry 342
    0x1.745d24p2,
    0x1.745d24p-2,
    (int)4
  },
  { // Entry 343
    0x1.745d24p3,
    0x1.745d24p-2,
    (int)5
  },
  { // Entry 344
    0x1.745d24p4,
    0x1.745d24p-2,
    (int)6
  },
  { // Entry 345
    0x1.745d24p5,
    0x1.745d24p-2,
    (int)7
  },
  { // Entry 346
    0x1.745d24p6,
    0x1.745d24p-2,
    (int)8
  },
  { // Entry 347
    0x1.745d24p7,
    0x1.745d24p-2,
    (int)9
  },
  { // Entry 348
    0x1.745d24p8,
    0x1.745d24p-2,
    (int)10
  },
  { // Entry 349
    0x1.d1746ap-12,
    0x1.d1746ap-2,
    (int)-10
  },
  { // Entry 350
    0x1.d1746ap-11,
    0x1.d1746ap-2,
    (int)-9
  },
  { // Entry 351
    0x1.d1746ap-10,
    0x1.d1746ap-2,
    (int)-8
  },
  { // Entry 352
    0x1.d1746ap-9,
    0x1.d1746ap-2,
    (int)-7
  },
  { // Entry 353
    0x1.d1746ap-8,
    0x1.d1746ap-2,
    (int)-6
  },
  { // Entry 354
    0x1.d1746ap-7,
    0x1.d1746ap-2,
    (int)-5
  },
  { // Entry 355
    0x1.d1746ap-6,
    0x1.d1746ap-2,
    (int)-4
  },
  { // Entry 356
    0x1.d1746ap-5,
    0x1.d1746ap-2,
    (int)-3
  },
  { // Entry 357
    0x1.d1746ap-4,
    0x1.d1746ap-2,
    (int)-2
  },
  { // Entry 358
    0x1.d1746ap-3,
    0x1.d1746ap-2,
    (int)-1
  },
  { // Entry 359
    0x1.d1746ap-2,
    0x1.d1746ap-2,
    (int)0
  },
  { // Entry 360
    0x1.d1746ap-1,
    0x1.d1746ap-2,
    (int)1
  },
  { // Entry 361
    0x1.d1746ap0,
    0x1.d1746ap-2,
    (int)2
  },
  { // Entry 362
    0x1.d1746ap1,
    0x1.d1746ap-2,
    (int)3
  },
  { // Entry 363
    0x1.d1746ap2,
    0x1.d1746ap-2,
    (int)4
  },
  { // Entry 364
    0x1.d1746ap3,
    0x1.d1746ap-2,
    (int)5
  },
  { // Entry 365
    0x1.d1746ap4,
    0x1.d1746ap-2,
    (int)6
  },
  { // Entry 366
    0x1.d1746ap5,
    0x1.d1746ap-2,
    (int)7
  },
  { // Entry 367
    0x1.d1746ap6,
    0x1.d1746ap-2,
    (int)8
  },
  { // Entry 368
    0x1.d1746ap7,
    0x1.d1746ap-2,
    (int)9
  },
  { // Entry 369
    0x1.d1746ap8,
    0x1.d1746ap-2,
    (int)10
  },
  { // Entry 370
    0x1.1745d8p-11,
    0x1.1745d8p-1,
    (int)-10
  },
  { // Entry 371
    0x1.1745d8p-10,
    0x1.1745d8p-1,
    (int)-9
  },
  { // Entry 372
    0x1.1745d8p-9,
    0x1.1745d8p-1,
    (int)-8
  },
  { // Entry 373
    0x1.1745d8p-8,
    0x1.1745d8p-1,
    (int)-7
  },
  { // Entry 374
    0x1.1745d8p-7,
    0x1.1745d8p-1,
    (int)-6
  },
  { // Entry 375
    0x1.1745d8p-6,
    0x1.1745d8p-1,
    (int)-5
  },
  { // Entry 376
    0x1.1745d8p-5,
    0x1.1745d8p-1,
    (int)-4
  },
  { // Entry 377
    0x1.1745d8p-4,
    0x1.1745d8p-1,
    (int)-3
  },
  { // Entry 378
    0x1.1745d8p-3,
    0x1.1745d8p-1,
    (int)-2
  },
  { // Entry 379
    0x1.1745d8p-2,
    0x1.1745d8p-1,
    (int)-1
  },
  { // Entry 380
    0x1.1745d8p-1,
    0x1.1745d8p-1,
    (int)0
  },
  { // Entry 381
    0x1.1745d8p0,
    0x1.1745d8p-1,
    (int)1
  },
  { // Entry 382
    0x1.1745d8p1,
    0x1.1745d8p-1,
    (int)2
  },
  { // Entry 383
    0x1.1745d8p2,
    0x1.1745d8p-1,
    (int)3
  },
  { // Entry 384
    0x1.1745d8p3,
    0x1.1745d8p-1,
    (int)4
  },
  { // Entry 385
    0x1.1745d8p4,
    0x1.1745d8p-1,
    (int)5
  },
  { // Entry 386
    0x1.1745d8p5,
    0x1.1745d8p-1,
    (int)6
  },
  { // Entry 387
    0x1.1745d8p6,
    0x1.1745d8p-1,
    (int)7
  },
  { // Entry 388
    0x1.1745d8p7,
    0x1.1745d8p-1,
    (int)8
  },
  { // Entry 389
    0x1.1745d8p8,
    0x1.1745d8p-1,
    (int)9
  },
  { // Entry 390
    0x1.1745d8p9,
    0x1.1745d8p-1,
    (int)10
  },
  { // Entry 391
    0x1.45d17cp-11,
    0x1.45d17cp-1,
    (int)-10
  },
  { // Entry 392
    0x1.45d17cp-10,
    0x1.45d17cp-1,
    (int)-9
  },
  { // Entry 393
    0x1.45d17cp-9,
    0x1.45d17cp-1,
    (int)-8
  },
  { // Entry 394
    0x1.45d17cp-8,
    0x1.45d17cp-1,
    (int)-7
  },
  { // Entry 395
    0x1.45d17cp-7,
    0x1.45d17cp-1,
    (int)-6
  },
  { // Entry 396
    0x1.45d17cp-6,
    0x1.45d17cp-1,
    (int)-5
  },
  { // Entry 397
    0x1.45d17cp-5,
    0x1.45d17cp-1,
    (int)-4
  },
  { // Entry 398
    0x1.45d17cp-4,
    0x1.45d17cp-1,
    (int)-3
  },
  { // Entry 399
    0x1.45d17cp-3,
    0x1.45d17cp-1,
    (int)-2
  },
  { // Entry 400
    0x1.45d17cp-2,
    0x1.45d17cp-1,
    (int)-1
  },
  { // Entry 401
    0x1.45d17cp-1,
    0x1.45d17cp-1,
    (int)0
  },
  { // Entry 402
    0x1.45d17cp0,
    0x1.45d17cp-1,
    (int)1
  },
  { // Entry 403
    0x1.45d17cp1,
    0x1.45d17cp-1,
    (int)2
  },
  { // Entry 404
    0x1.45d17cp2,
    0x1.45d17cp-1,
    (int)3
  },
  { // Entry 405
    0x1.45d17cp3,
    0x1.45d17cp-1,
    (int)4
  },
  { // Entry 406
    0x1.45d17cp4,
    0x1.45d17cp-1,
    (int)5
  },
  { // Entry 407
    0x1.45d17cp5,
    0x1.45d17cp-1,
    (int)6
  },
  { // Entry 408
    0x1.45d17cp6,
    0x1.45d17cp-1,
    (int)7
  },
  { // Entry 409
    0x1.45d17cp7,
    0x1.45d17cp-1,
    (int)8
  },
  { // Entry 410
    0x1.45d17cp8,
    0x1.45d17cp-1,
    (int)9
  },
  { // Entry 411
    0x1.45d17cp9,
    0x1.45d17cp-1,
    (int)10
  },
  { // Entry 412
    0x1.745d20p-11,
    0x1.745d20p-1,
    (int)-10
  },
  { // Entry 413
    0x1.745d20p-10,
    0x1.745d20p-1,
    (int)-9
  },
  { // Entry 414
    0x1.745d20p-9,
    0x1.745d20p-1,
    (int)-8
  },
  { // Entry 415
    0x1.745d20p-8,
    0x1.745d20p-1,
    (int)-7
  },
  { // Entry 416
    0x1.745d20p-7,
    0x1.745d20p-1,
    (int)-6
  },
  { // Entry 417
    0x1.745d20p-6,
    0x1.745d20p-1,
    (int)-5
  },
  { // Entry 418
    0x1.745d20p-5,
    0x1.745d20p-1,
    (int)-4
  },
  { // Entry 419
    0x1.745d20p-4,
    0x1.745d20p-1,
    (int)-3
  },
  { // Entry 420
    0x1.745d20p-3,
    0x1.745d20p-1,
    (int)-2
  },
  { // Entry 421
    0x1.745d20p-2,
    0x1.745d20p-1,
    (int)-1
  },
  { // Entry 422
    0x1.745d20p-1,
    0x1.745d20p-1,
    (int)0
  },
  { // Entry 423
    0x1.745d20p0,
    0x1.745d20p-1,
    (int)1
  },
  { // Entry 424
    0x1.745d20p1,
    0x1.745d20p-1,
    (int)2
  },
  { // Entry 425
    0x1.745d20p2,
    0x1.745d20p-1,
    (int)3
  },
  { // Entry 426
    0x1.745d20p3,
    0x1.745d20p-1,
    (int)4
  },
  { // Entry 427
    0x1.745d20p4,
    0x1.745d20p-1,
    (int)5
  },
  { // Entry 428
    0x1.745d20p5,
    0x1.745d20p-1,
    (int)6
  },
  { // Entry 429
    0x1.745d20p6,
    0x1.745d20p-1,
    (int)7
  },
  { // Entry 430
    0x1.745d20p7,
    0x1.745d20p-1,
    (int)8
  },
  { // Entry 431
    0x1.745d20p8,
    0x1.745d20p-1,
    (int)9
  },
  { // Entry 432
    0x1.745d20p9,
    0x1.745d20p-1,
    (int)10
  },
  { // Entry 433
    0x1.a2e8c4p-11,
    0x1.a2e8c4p-1,
    (int)-10
  },
  { // Entry 434
    0x1.a2e8c4p-10,
    0x1.a2e8c4p-1,
    (int)-9
  },
  { // Entry 435
    0x1.a2e8c4p-9,
    0x1.a2e8c4p-1,
    (int)-8
  },
  { // Entry 436
    0x1.a2e8c4p-8,
    0x1.a2e8c4p-1,
    (int)-7
  },
  { // Entry 437
    0x1.a2e8c4p-7,
    0x1.a2e8c4p-1,
    (int)-6
  },
  { // Entry 438
    0x1.a2e8c4p-6,
    0x1.a2e8c4p-1,
    (int)-5
  },
  { // Entry 439
    0x1.a2e8c4p-5,
    0x1.a2e8c4p-1,
    (int)-4
  },
  { // Entry 440
    0x1.a2e8c4p-4,
    0x1.a2e8c4p-1,
    (int)-3
  },
  { // Entry 441
    0x1.a2e8c4p-3,
    0x1.a2e8c4p-1,
    (int)-2
  },
  { // Entry 442
    0x1.a2e8c4p-2,
    0x1.a2e8c4p-1,
    (int)-1
  },
  { // Entry 443
    0x1.a2e8c4p-1,
    0x1.a2e8c4p-1,
    (int)0
  },
  { // Entry 444
    0x1.a2e8c4p0,
    0x1.a2e8c4p-1,
    (int)1
  },
  { // Entry 445
    0x1.a2e8c4p1,
    0x1.a2e8c4p-1,
    (int)2
  },
  { // Entry 446
    0x1.a2e8c4p2,
    0x1.a2e8c4p-1,
    (int)3
  },
  { // Entry 447
    0x1.a2e8c4p3,
    0x1.a2e8c4p-1,
    (int)4
  },
  { // Entry 448
    0x1.a2e8c4p4,
    0x1.a2e8c4p-1,
    (int)5
  },
  { // Entry 449
    0x1.a2e8c4p5,
    0x1.a2e8c4p-1,
    (int)6
  },
  { // Entry 450
    0x1.a2e8c4p6,
    0x1.a2e8c4p-1,
    (int)7
  },
  { // Entry 451
    0x1.a2e8c4p7,
    0x1.a2e8c4p-1,
    (int)8
  },
  { // Entry 452
    0x1.a2e8c4p8,
    0x1.a2e8c4p-1,
    (int)9
  },
  { // Entry 453
    0x1.a2e8c4p9,
    0x1.a2e8c4p-1,
    (int)10
  },
  { // Entry 454
    0x1.d17468p-11,
    0x1.d17468p-1,
    (int)-10
  },
  { // Entry 455
    0x1.d17468p-10,
    0x1.d17468p-1,
    (int)-9
  },
  { // Entry 456
    0x1.d17468p-9,
    0x1.d17468p-1,
    (int)-8
  },
  { // Entry 457
    0x1.d17468p-8,
    0x1.d17468p-1,
    (int)-7
  },
  { // Entry 458
    0x1.d17468p-7,
    0x1.d17468p-1,
    (int)-6
  },
  { // Entry 459
    0x1.d17468p-6,
    0x1.d17468p-1,
    (int)-5
  },
  { // Entry 460
    0x1.d17468p-5,
    0x1.d17468p-1,
    (int)-4
  },
  { // Entry 461
    0x1.d17468p-4,
    0x1.d17468p-1,
    (int)-3
  },
  { // Entry 462
    0x1.d17468p-3,
    0x1.d17468p-1,
    (int)-2
  },
  { // Entry 463
    0x1.d17468p-2,
    0x1.d17468p-1,
    (int)-1
  },
  { // Entry 464
    0x1.d17468p-1,
    0x1.d17468p-1,
    (int)0
  },
  { // Entry 465
    0x1.d17468p0,
    0x1.d17468p-1,
    (int)1
  },
  { // Entry 466
    0x1.d17468p1,
    0x1.d17468p-1,
    (int)2
  },
  { // Entry 467
    0x1.d17468p2,
    0x1.d17468p-1,
    (int)3
  },
  { // Entry 468
    0x1.d17468p3,
    0x1.d17468p-1,
    (int)4
  },
  { // Entry 469
    0x1.d17468p4,
    0x1.d17468p-1,
    (int)5
  },
  { // Entry 470
    0x1.d17468p5,
    0x1.d17468p-1,
    (int)6
  },
  { // Entry 471
    0x1.d17468p6,
    0x1.d17468p-1,
    (int)7
  },
  { // Entry 472
    0x1.d17468p7,
    0x1.d17468p-1,
    (int)8
  },
  { // Entry 473
    0x1.d17468p8,
    0x1.d17468p-1,
    (int)9
  },
  { // Entry 474
    0x1.d17468p9,
    0x1.d17468p-1,
    (int)10
  },
  { // Entry 475
    0x1.p-10,
    0x1.p0,
    (int)-10
  },
  { // Entry 476
    0x1.p-9,
    0x1.p0,
    (int)-9
  },
  { // Entry 477
    0x1.p-8,
    0x1.p0,
    (int)-8
  },
  { // Entry 478
    0x1.p-7,
    0x1.p0,
    (int)-7
  },
  { // Entry 479
    0x1.p-6,
    0x1.p0,
    (int)-6
  },
  { // Entry 480
    0x1.p-5,
    0x1.p0,
    (int)-5
  },
  { // Entry 481
    0x1.p-4,
    0x1.p0,
    (int)-4
  },
  { // Entry 482
    0x1.p-3,
    0x1.p0,
    (int)-3
  },
  { // Entry 483
    0x1.p-2,
    0x1.p0,
    (int)-2
  },
  { // Entry 484
    0x1.p-1,
    0x1.p0,
    (int)-1
  },
  { // Entry 485
    0x1.p0,
    0x1.p0,
    (int)0
  },
  { // Entry 486
    0x1.p1,
    0x1.p0,
    (int)1
  },
  { // Entry 487
    0x1.p2,
    0x1.p0,
    (int)2
  },
  { // Entry 488
    0x1.p3,
    0x1.p0,
    (int)3
  },
  { // Entry 489
    0x1.p4,
    0x1.p0,
    (int)4
  },
  { // Entry 490
    0x1.p5,
    0x1.p0,
    (int)5
  },
  { // Entry 491
    0x1.p6,
    0x1.p0,
    (int)6
  },
  { // Entry 492
    0x1.p7,
    0x1.p0,
    (int)7
  },
  { // Entry 493
    0x1.p8,
    0x1.p0,
    (int)8
  },
  { // Entry 494
    0x1.p9,
    0x1.p0,
    (int)9
  },
  { // Entry 495
    0x1.p10,
    0x1.p0,
    (int)10
  },
  { // Entry 496
    0x1.fffffep0,
    0x1.fffffep127,
    (int)-127
  },
  { // Entry 497
    0x1.fffffep1,
    0x1.fffffep127,
    (int)-126
  },
  { // Entry 498
    0x1.fffffep117,
    0x1.fffffep127,
    (int)-10
  },
  { // Entry 499
    0x1.fffffep118,
    0x1.fffffep127,
    (int)-9
  },
  { // Entry 500
    0x1.fffffep119,
    0x1.fffffep127,
    (int)-8
  },
  { // Entry 501
    0x1.fffffep120,
    0x1.fffffep127,
    (int)-7
  },
  { // Entry 502
    0x1.fffffep121,
    0x1.fffffep127,
    (int)-6
  },
  { // Entry 503
    0x1.fffffep122,
    0x1.fffffep127,
    (int)-5
  },
  { // Entry 504
    0x1.fffffep123,
    0x1.fffffep127,
    (int)-4
  },
  { // Entry 505
    0x1.fffffep124,
    0x1.fffffep127,
    (int)-3
  },
  { // Entry 506
    0x1.fffffep125,
    0x1.fffffep127,
    (int)-2
  },
  { // Entry 507
    0x1.fffffep126,
    0x1.fffffep127,
    (int)-1
  },
  { // Entry 508
    0x1.fffffep127,
    0x1.fffffep127,
    (int)0
  },
  { // Entry 509
    0x1.p-22,
    0x1.p-149,
    (int)127
  },
  { // Entry 510
    0x1.p-23,
    0x1.p-149,
    (int)126
  },
  { // Entry 511
    0x1.p-149,
    0x1.p-149,
    (int)0
  },
  { // Entry 512
    0x1.p-148,
    0x1.p-149,
    (int)1
  },
  { // Entry 513
    0x1.p-147,
    0x1.p-149,
    (int)2
  },
  { // Entry 514
    0x1.p-146,
    0x1.p-149,
    (int)3
  },
  { // Entry 515
    0x1.p-145,
    0x1.p-149,
    (int)4
  },
  { // Entry 516
    0x1.p-144,
    0x1.p-149,
    (int)5
  },
  { // Entry 517
    0x1.p-143,
    0x1.p-149,
    (int)6
  },
  { // Entry 518
    0x1.p-142,
    0x1.p-149,
    (int)7
  },
  { // Entry 519
    0x1.p-141,
    0x1.p-149,
    (int)8
  },
  { // Entry 520
    0x1.p-140,
    0x1.p-149,
    (int)9
  },
  { // Entry 521
    0x1.p-139,
    0x1.p-149,
    (int)10
  },
  { // Entry 522
    0x1.p-129,
    0x1.p-2,
    (int)-127
  },
  { // Entry 523
    0x1.p-128,
    0x1.p-2,
    (int)-126
  },
  { // Entry 524
    0x1.p-128,
    0x1.p-1,
    (int)-127
  },
  { // Entry 525
    0x1.p-127,
    0x1.p-1,
    (int)-126
  },
  { // Entry 526
    0x1.80p-128,
    0x1.80p-1,
    (int)-127
  },
  { // Entry 527
    0x1.80p-127,
    0x1.80p-1,
    (int)-126
  },
  { // Entry 528
    0.0f,
    0x1.p-2,
    (int)-149
  },
  { // Entry 529
    0.0f,
    0x1.p-2,
    (int)-148
  },
  { // Entry 530
    0.0f,
    0x1.p-1,
    (int)-149
  },
  { // Entry 531
    0x1.p-149,
    0x1.p-1,
    (int)-148
  },
  { // Entry 532
    0.0f,
    0x1.80p-1,
    (int)-149
  },
  { // Entry 533
    0x1.80p-149,
    0x1.80p-1,
    (int)-148
  },
  { // Entry 534
    0x1.p127,
    0x1.p0,
    (int)127
  },
  { // Entry 535
    0x1.p126,
    0x1.p0,
    (int)126
  },
  { // Entry 536
    0x1.p-149,
    0x1.p-149,
    (int)0
  },
  { // Entry 537
    0x1.p-148,
    0x1.p-149,
    (int)1
  },
  { // Entry 538
    0x1.p-147,
    0x1.p-149,
    (int)2
  },
  { // Entry 539
    0x1.p-146,
    0x1.p-149,
    (int)3
  },
  { // Entry 540
    0x1.p-145,
    0x1.p-149,
    (int)4
  },
  { // Entry 541
    0x1.p-144,
    0x1.p-149,
    (int)5
  },
  { // Entry 542
    0x1.p-143,
    0x1.p-149,
    (int)6
  },
  { // Entry 543
    0x1.p-142,
    0x1.p-149,
    (int)7
  },
  { // Entry 544
    0x1.p-141,
    0x1.p-149,
    (int)8
  },
  { // Entry 545
    0x1.p-140,
    0x1.p-149,
    (int)9
  },
  { // Entry 546
    0x1.p-139,
    0x1.p-149,
    (int)10
  },
  { // Entry 547
    0x1.p-138,
    0x1.p-149,
    (int)11
  },
  { // Entry 548
    0x1.p-137,
    0x1.p-149,
    (int)12
  },
  { // Entry 549
    0x1.p-136,
    0x1.p-149,
    (int)13
  },
  { // Entry 550
    0x1.p-135,
    0x1.p-149,
    (int)14
  },
  { // Entry 551
    0x1.p-134,
    0x1.p-149,
    (int)15
  },
  { // Entry 552
    0x1.p-133,
    0x1.p-149,
    (int)16
  },
  { // Entry 553
    0x1.p-132,
    0x1.p-149,
    (int)17
  },
  { // Entry 554
    0x1.p-131,
    0x1.p-149,
    (int)18
  },
  { // Entry 555
    0x1.p-130,
    0x1.p-149,
    (int)19
  },
  { // Entry 556
    0x1.p-129,
    0x1.p-149,
    (int)20
  },
  { // Entry 557
    0x1.p-128,
    0x1.p-149,
    (int)21
  },
  { // Entry 558
    0x1.p-127,
    0x1.p-149,
    (int)22
  },
  { // Entry 559
    0x1.p-126,
    0x1.p-149,
    (int)23
  },
  { // Entry 560
    0x1.p-125,
    0x1.p-149,
    (int)24
  },
  { // Entry 561
    0x1.p-124,
    0x1.p-149,
    (int)25
  },
  { // Entry 562
    0x1.p-123,
    0x1.p-149,
    (int)26
  },
  { // Entry 563
    0x1.p-122,
    0x1.p-149,
    (int)27
  },
  { // Entry 564
    0x1.p-121,
    0x1.p-149,
    (int)28
  },
  { // Entry 565
    0x1.p-120,
    0x1.p-149,
    (int)29
  },
  { // Entry 566
    0x1.p-119,
    0x1.p-149,
    (int)30
  },
  { // Entry 567
    0x1.p-118,
    0x1.p-149,
    (int)31
  },
  { // Entry 568
    0x1.p-117,
    0x1.p-149,
    (int)32
  },
  { // Entry 569
    0x1.p-116,
    0x1.p-149,
    (int)33
  },
  { // Entry 570
    0x1.p-115,
    0x1.p-149,
    (int)34
  },
  { // Entry 571
    0x1.p-114,
    0x1.p-149,
    (int)35
  },
  { // Entry 572
    0x1.p-113,
    0x1.p-149,
    (int)36
  },
  { // Entry 573
    0x1.p-112,
    0x1.p-149,
    (int)37
  },
  { // Entry 574
    0x1.p-111,
    0x1.p-149,
    (int)38
  },
  { // Entry 575
    0x1.p-110,
    0x1.p-149,
    (int)39
  },
  { // Entry 576
    0x1.p-109,
    0x1.p-149,
    (int)40
  },
  { // Entry 577
    0x1.p-108,
    0x1.p-149,
    (int)41
  },
  { // Entry 578
    0x1.p-107,
    0x1.p-149,
    (int)42
  },
  { // Entry 579
    0x1.p-106,
    0x1.p-149,
    (int)43
  },
  { // Entry 580
    0x1.p-105,
    0x1.p-149,
    (int)44
  },
  { // Entry 581
    0x1.p-104,
    0x1.p-149,
    (int)45
  },
  { // Entry 582
    0x1.p-103,
    0x1.p-149,
    (int)46
  },
  { // Entry 583
    0x1.p-102,
    0x1.p-149,
    (int)47
  },
  { // Entry 584
    0x1.p-101,
    0x1.p-149,
    (int)48
  },
  { // Entry 585
    0x1.p-100,
    0x1.p-149,
    (int)49
  },
  { // Entry 586
    0x1.p-99,
    0x1.p-149,
    (int)50
  },
  { // Entry 587
    0x1.p-98,
    0x1.p-149,
    (int)51
  },
  { // Entry 588
    0x1.p-97,
    0x1.p-149,
    (int)52
  },
  { // Entry 589
    0x1.p-96,
    0x1.p-149,
    (int)53
  },
  { // Entry 590
    0x1.p-95,
    0x1.p-149,
    (int)54
  },
  { // Entry 591
    0x1.p-94,
    0x1.p-149,
    (int)55
  },
  { // Entry 592
    0x1.p-93,
    0x1.p-149,
    (int)56
  },
  { // Entry 593
    0x1.p-92,
    0x1.p-149,
    (int)57
  },
  { // Entry 594
    0x1.p-91,
    0x1.p-149,
    (int)58
  },
  { // Entry 595
    0x1.p-90,
    0x1.p-149,
    (int)59
  },
  { // Entry 596
    0x1.p-89,
    0x1.p-149,
    (int)60
  },
  { // Entry 597
    0x1.p-88,
    0x1.p-149,
    (int)61
  },
  { // Entry 598
    0x1.p-87,
    0x1.p-149,
    (int)62
  },
  { // Entry 599
    0x1.p-86,
    0x1.p-149,
    (int)63
  },
  { // Entry 600
    0x1.p-85,
    0x1.p-149,
    (int)64
  },
  { // Entry 601
    0x1.p-84,
    0x1.p-149,
    (int)65
  },
  { // Entry 602
    0x1.p-83,
    0x1.p-149,
    (int)66
  },
  { // Entry 603
    0x1.p-82,
    0x1.p-149,
    (int)67
  },
  { // Entry 604
    0x1.p-81,
    0x1.p-149,
    (int)68
  },
  { // Entry 605
    0x1.p-80,
    0x1.p-149,
    (int)69
  },
  { // Entry 606
    0x1.p-79,
    0x1.p-149,
    (int)70
  },
  { // Entry 607
    0x1.p-78,
    0x1.p-149,
    (int)71
  },
  { // Entry 608
    0x1.p-77,
    0x1.p-149,
    (int)72
  },
  { // Entry 609
    0x1.p-76,
    0x1.p-149,
    (int)73
  },
  { // Entry 610
    0x1.p-75,
    0x1.p-149,
    (int)74
  },
  { // Entry 611
    0x1.p-74,
    0x1.p-149,
    (int)75
  },
  { // Entry 612
    0x1.p-73,
    0x1.p-149,
    (int)76
  },
  { // Entry 613
    0x1.p-72,
    0x1.p-149,
    (int)77
  },
  { // Entry 614
    0x1.p-71,
    0x1.p-149,
    (int)78
  },
  { // Entry 615
    0x1.p-70,
    0x1.p-149,
    (int)79
  },
  { // Entry 616
    0x1.p-69,
    0x1.p-149,
    (int)80
  },
  { // Entry 617
    0x1.p-68,
    0x1.p-149,
    (int)81
  },
  { // Entry 618
    0x1.p-67,
    0x1.p-149,
    (int)82
  },
  { // Entry 619
    0x1.p-66,
    0x1.p-149,
    (int)83
  },
  { // Entry 620
    0x1.p-65,
    0x1.p-149,
    (int)84
  },
  { // Entry 621
    0x1.p-64,
    0x1.p-149,
    (int)85
  },
  { // Entry 622
    0x1.p-63,
    0x1.p-149,
    (int)86
  },
  { // Entry 623
    0x1.p-62,
    0x1.p-149,
    (int)87
  },
  { // Entry 624
    0x1.p-61,
    0x1.p-149,
    (int)88
  },
  { // Entry 625
    0x1.p-60,
    0x1.p-149,
    (int)89
  },
  { // Entry 626
    0x1.p-59,
    0x1.p-149,
    (int)90
  },
  { // Entry 627
    0x1.p-58,
    0x1.p-149,
    (int)91
  },
  { // Entry 628
    0x1.p-57,
    0x1.p-149,
    (int)92
  },
  { // Entry 629
    0x1.p-56,
    0x1.p-149,
    (int)93
  },
  { // Entry 630
    0x1.p-55,
    0x1.p-149,
    (int)94
  },
  { // Entry 631
    0x1.p-54,
    0x1.p-149,
    (int)95
  },
  { // Entry 632
    0x1.p-53,
    0x1.p-149,
    (int)96
  },
  { // Entry 633
    0x1.p-52,
    0x1.p-149,
    (int)97
  },
  { // Entry 634
    0x1.p-51,
    0x1.p-149,
    (int)98
  },
  { // Entry 635
    0x1.p-50,
    0x1.p-149,
    (int)99
  },
  { // Entry 636
    0x1.p-49,
    0x1.p-149,
    (int)100
  },
  { // Entry 637
    0x1.p-48,
    0x1.p-149,
    (int)101
  },
  { // Entry 638
    0x1.p-47,
    0x1.p-149,
    (int)102
  },
  { // Entry 639
    0x1.p-46,
    0x1.p-149,
    (int)103
  },
  { // Entry 640
    0x1.p-45,
    0x1.p-149,
    (int)104
  },
  { // Entry 641
    0x1.p-44,
    0x1.p-149,
    (int)105
  },
  { // Entry 642
    0x1.p-43,
    0x1.p-149,
    (int)106
  },
  { // Entry 643
    0x1.p-42,
    0x1.p-149,
    (int)107
  },
  { // Entry 644
    0x1.p-41,
    0x1.p-149,
    (int)108
  },
  { // Entry 645
    0x1.p-40,
    0x1.p-149,
    (int)109
  },
  { // Entry 646
    0x1.p-39,
    0x1.p-149,
    (int)110
  },
  { // Entry 647
    0x1.p-38,
    0x1.p-149,
    (int)111
  },
  { // Entry 648
    0x1.p-37,
    0x1.p-149,
    (int)112
  },
  { // Entry 649
    0x1.p-36,
    0x1.p-149,
    (int)113
  },
  { // Entry 650
    0x1.p-35,
    0x1.p-149,
    (int)114
  },
  { // Entry 651
    0x1.p-34,
    0x1.p-149,
    (int)115
  },
  { // Entry 652
    0x1.p-33,
    0x1.p-149,
    (int)116
  },
  { // Entry 653
    0x1.p-32,
    0x1.p-149,
    (int)117
  },
  { // Entry 654
    0x1.p-31,
    0x1.p-149,
    (int)118
  },
  { // Entry 655
    0x1.p-30,
    0x1.p-149,
    (int)119
  },
  { // Entry 656
    0x1.p-29,
    0x1.p-149,
    (int)120
  },
  { // Entry 657
    0x1.p-28,
    0x1.p-149,
    (int)121
  },
  { // Entry 658
    0x1.p-27,
    0x1.p-149,
    (int)122
  },
  { // Entry 659
    0x1.p-26,
    0x1.p-149,
    (int)123
  },
  { // Entry 660
    0x1.p-25,
    0x1.p-149,
    (int)124
  },
  { // Entry 661
    0x1.p-24,
    0x1.p-149,
    (int)125
  },
  { // Entry 662
    0x1.p-23,
    0x1.p-149,
    (int)126
  },
  { // Entry 663
    0x1.p-22,
    0x1.p-149,
    (int)127
  },
  { // Entry 664
    0x1.p-21,
    0x1.p-149,
    (int)128
  },
  { // Entry 665
    0x1.p-20,
    0x1.p-149,
    (int)129
  },
  { // Entry 666
    0x1.p-19,
    0x1.p-149,
    (int)130
  },
  { // Entry 667
    0x1.fffffcp-127,
    0x1.fffffcp-127,
    (int)0
  },
  { // Entry 668
    0x1.fffffcp-126,
    0x1.fffffcp-127,
    (int)1
  },
  { // Entry 669
    0x1.fffffcp-125,
    0x1.fffffcp-127,
    (int)2
  },
  { // Entry 670
    0x1.fffffcp-124,
    0x1.fffffcp-127,
    (int)3
  },
  { // Entry 671
    0x1.fffffcp-123,
    0x1.fffffcp-127,
    (int)4
  },
  { // Entry 672
    0x1.fffffcp-122,
    0x1.fffffcp-127,
    (int)5
  },
  { // Entry 673
    0x1.fffffcp-121,
    0x1.fffffcp-127,
    (int)6
  },
  { // Entry 674
    0x1.fffffcp-120,
    0x1.fffffcp-127,
    (int)7
  },
  { // Entry 675
    0x1.fffffcp-119,
    0x1.fffffcp-127,
    (int)8
  },
  { // Entry 676
    0x1.fffffcp-118,
    0x1.fffffcp-127,
    (int)9
  },
  { // Entry 677
    0x1.fffffcp-117,
    0x1.fffffcp-127,
    (int)10
  },
  { // Entry 678
    0x1.fffffcp-116,
    0x1.fffffcp-127,
    (int)11
  },
  { // Entry 679
    0x1.fffffcp-115,
    0x1.fffffcp-127,
    (int)12
  },
  { // Entry 680
    0x1.fffffcp-114,
    0x1.fffffcp-127,
    (int)13
  },
  { // Entry 681
    0x1.fffffcp-113,
    0x1.fffffcp-127,
    (int)14
  },
  { // Entry 682
    0x1.fffffcp-112,
    0x1.fffffcp-127,
    (int)15
  },
  { // Entry 683
    0x1.fffffcp-111,
    0x1.fffffcp-127,
    (int)16
  },
  { // Entry 684
    0x1.fffffcp-110,
    0x1.fffffcp-127,
    (int)17
  },
  { // Entry 685
    0x1.fffffcp-109,
    0x1.fffffcp-127,
    (int)18
  },
  { // Entry 686
    0x1.fffffcp-108,
    0x1.fffffcp-127,
    (int)19
  },
  { // Entry 687
    0x1.fffffcp-107,
    0x1.fffffcp-127,
    (int)20
  },
  { // Entry 688
    0x1.fffffcp-106,
    0x1.fffffcp-127,
    (int)21
  },
  { // Entry 689
    0x1.fffffcp-105,
    0x1.fffffcp-127,
    (int)22
  },
  { // Entry 690
    0x1.fffffcp-104,
    0x1.fffffcp-127,
    (int)23
  },
  { // Entry 691
    0x1.fffffcp-103,
    0x1.fffffcp-127,
    (int)24
  },
  { // Entry 692
    0x1.fffffcp-102,
    0x1.fffffcp-127,
    (int)25
  },
  { // Entry 693
    0x1.fffffcp-101,
    0x1.fffffcp-127,
    (int)26
  },
  { // Entry 694
    0x1.fffffcp-100,
    0x1.fffffcp-127,
    (int)27
  },
  { // Entry 695
    0x1.fffffcp-99,
    0x1.fffffcp-127,
    (int)28
  },
  { // Entry 696
    0x1.fffffcp-98,
    0x1.fffffcp-127,
    (int)29
  },
  { // Entry 697
    0x1.fffffcp-97,
    0x1.fffffcp-127,
    (int)30
  },
  { // Entry 698
    0x1.fffffcp-96,
    0x1.fffffcp-127,
    (int)31
  },
  { // Entry 699
    0x1.fffffcp-95,
    0x1.fffffcp-127,
    (int)32
  },
  { // Entry 700
    0x1.fffffcp-94,
    0x1.fffffcp-127,
    (int)33
  },
  { // Entry 701
    0x1.fffffcp-93,
    0x1.fffffcp-127,
    (int)34
  },
  { // Entry 702
    0x1.fffffcp-92,
    0x1.fffffcp-127,
    (int)35
  },
  { // Entry 703
    0x1.fffffcp-91,
    0x1.fffffcp-127,
    (int)36
  },
  { // Entry 704
    0x1.fffffcp-90,
    0x1.fffffcp-127,
    (int)37
  },
  { // Entry 705
    0x1.fffffcp-89,
    0x1.fffffcp-127,
    (int)38
  },
  { // Entry 706
    0x1.fffffcp-88,
    0x1.fffffcp-127,
    (int)39
  },
  { // Entry 707
    0x1.fffffcp-87,
    0x1.fffffcp-127,
    (int)40
  },
  { // Entry 708
    0x1.fffffcp-86,
    0x1.fffffcp-127,
    (int)41
  },
  { // Entry 709
    0x1.fffffcp-85,
    0x1.fffffcp-127,
    (int)42
  },
  { // Entry 710
    0x1.fffffcp-84,
    0x1.fffffcp-127,
    (int)43
  },
  { // Entry 711
    0x1.fffffcp-83,
    0x1.fffffcp-127,
    (int)44
  },
  { // Entry 712
    0x1.fffffcp-82,
    0x1.fffffcp-127,
    (int)45
  },
  { // Entry 713
    0x1.fffffcp-81,
    0x1.fffffcp-127,
    (int)46
  },
  { // Entry 714
    0x1.fffffcp-80,
    0x1.fffffcp-127,
    (int)47
  },
  { // Entry 715
    0x1.fffffcp-79,
    0x1.fffffcp-127,
    (int)48
  },
  { // Entry 716
    0x1.fffffcp-78,
    0x1.fffffcp-127,
    (int)49
  },
  { // Entry 717
    0x1.fffffcp-77,
    0x1.fffffcp-127,
    (int)50
  },
  { // Entry 718
    0x1.fffffcp-76,
    0x1.fffffcp-127,
    (int)51
  },
  { // Entry 719
    0x1.fffffcp-75,
    0x1.fffffcp-127,
    (int)52
  },
  { // Entry 720
    0x1.fffffcp-74,
    0x1.fffffcp-127,
    (int)53
  },
  { // Entry 721
    0x1.fffffcp-73,
    0x1.fffffcp-127,
    (int)54
  },
  { // Entry 722
    0x1.fffffcp-72,
    0x1.fffffcp-127,
    (int)55
  },
  { // Entry 723
    0x1.fffffcp-71,
    0x1.fffffcp-127,
    (int)56
  },
  { // Entry 724
    0x1.fffffcp-70,
    0x1.fffffcp-127,
    (int)57
  },
  { // Entry 725
    0x1.fffffcp-69,
    0x1.fffffcp-127,
    (int)58
  },
  { // Entry 726
    0x1.fffffcp-68,
    0x1.fffffcp-127,
    (int)59
  },
  { // Entry 727
    0x1.fffffcp-67,
    0x1.fffffcp-127,
    (int)60
  },
  { // Entry 728
    0x1.fffffcp-66,
    0x1.fffffcp-127,
    (int)61
  },
  { // Entry 729
    0x1.fffffcp-65,
    0x1.fffffcp-127,
    (int)62
  },
  { // Entry 730
    0x1.fffffcp-64,
    0x1.fffffcp-127,
    (int)63
  },
  { // Entry 731
    0x1.fffffcp-63,
    0x1.fffffcp-127,
    (int)64
  },
  { // Entry 732
    0x1.fffffcp-62,
    0x1.fffffcp-127,
    (int)65
  },
  { // Entry 733
    0x1.fffffcp-61,
    0x1.fffffcp-127,
    (int)66
  },
  { // Entry 734
    0x1.fffffcp-60,
    0x1.fffffcp-127,
    (int)67
  },
  { // Entry 735
    0x1.fffffcp-59,
    0x1.fffffcp-127,
    (int)68
  },
  { // Entry 736
    0x1.fffffcp-58,
    0x1.fffffcp-127,
    (int)69
  },
  { // Entry 737
    0x1.fffffcp-57,
    0x1.fffffcp-127,
    (int)70
  },
  { // Entry 738
    0x1.fffffcp-56,
    0x1.fffffcp-127,
    (int)71
  },
  { // Entry 739
    0x1.fffffcp-55,
    0x1.fffffcp-127,
    (int)72
  },
  { // Entry 740
    0x1.fffffcp-54,
    0x1.fffffcp-127,
    (int)73
  },
  { // Entry 741
    0x1.fffffcp-53,
    0x1.fffffcp-127,
    (int)74
  },
  { // Entry 742
    0x1.fffffcp-52,
    0x1.fffffcp-127,
    (int)75
  },
  { // Entry 743
    0x1.fffffcp-51,
    0x1.fffffcp-127,
    (int)76
  },
  { // Entry 744
    0x1.fffffcp-50,
    0x1.fffffcp-127,
    (int)77
  },
  { // Entry 745
    0x1.fffffcp-49,
    0x1.fffffcp-127,
    (int)78
  },
  { // Entry 746
    0x1.fffffcp-48,
    0x1.fffffcp-127,
    (int)79
  },
  { // Entry 747
    0x1.fffffcp-47,
    0x1.fffffcp-127,
    (int)80
  },
  { // Entry 748
    0x1.fffffcp-46,
    0x1.fffffcp-127,
    (int)81
  },
  { // Entry 749
    0x1.fffffcp-45,
    0x1.fffffcp-127,
    (int)82
  },
  { // Entry 750
    0x1.fffffcp-44,
    0x1.fffffcp-127,
    (int)83
  },
  { // Entry 751
    0x1.fffffcp-43,
    0x1.fffffcp-127,
    (int)84
  },
  { // Entry 752
    0x1.fffffcp-42,
    0x1.fffffcp-127,
    (int)85
  },
  { // Entry 753
    0x1.fffffcp-41,
    0x1.fffffcp-127,
    (int)86
  },
  { // Entry 754
    0x1.fffffcp-40,
    0x1.fffffcp-127,
    (int)87
  },
  { // Entry 755
    0x1.fffffcp-39,
    0x1.fffffcp-127,
    (int)88
  },
  { // Entry 756
    0x1.fffffcp-38,
    0x1.fffffcp-127,
    (int)89
  },
  { // Entry 757
    0x1.fffffcp-37,
    0x1.fffffcp-127,
    (int)90
  },
  { // Entry 758
    0x1.fffffcp-36,
    0x1.fffffcp-127,
    (int)91
  },
  { // Entry 759
    0x1.fffffcp-35,
    0x1.fffffcp-127,
    (int)92
  },
  { // Entry 760
    0x1.fffffcp-34,
    0x1.fffffcp-127,
    (int)93
  },
  { // Entry 761
    0x1.fffffcp-33,
    0x1.fffffcp-127,
    (int)94
  },
  { // Entry 762
    0x1.fffffcp-32,
    0x1.fffffcp-127,
    (int)95
  },
  { // Entry 763
    0x1.fffffcp-31,
    0x1.fffffcp-127,
    (int)96
  },
  { // Entry 764
    0x1.fffffcp-30,
    0x1.fffffcp-127,
    (int)97
  },
  { // Entry 765
    0x1.fffffcp-29,
    0x1.fffffcp-127,
    (int)98
  },
  { // Entry 766
    0x1.fffffcp-28,
    0x1.fffffcp-127,
    (int)99
  },
  { // Entry 767
    0x1.fffffcp-27,
    0x1.fffffcp-127,
    (int)100
  },
  { // Entry 768
    0x1.fffffcp-26,
    0x1.fffffcp-127,
    (int)101
  },
  { // Entry 769
    0x1.fffffcp-25,
    0x1.fffffcp-127,
    (int)102
  },
  { // Entry 770
    0x1.fffffcp-24,
    0x1.fffffcp-127,
    (int)103
  },
  { // Entry 771
    0x1.fffffcp-23,
    0x1.fffffcp-127,
    (int)104
  },
  { // Entry 772
    0x1.fffffcp-22,
    0x1.fffffcp-127,
    (int)105
  },
  { // Entry 773
    0x1.fffffcp-21,
    0x1.fffffcp-127,
    (int)106
  },
  { // Entry 774
    0x1.fffffcp-20,
    0x1.fffffcp-127,
    (int)107
  },
  { // Entry 775
    0x1.fffffcp-19,
    0x1.fffffcp-127,
    (int)108
  },
  { // Entry 776
    0x1.fffffcp-18,
    0x1.fffffcp-127,
    (int)109
  },
  { // Entry 777
    0x1.fffffcp-17,
    0x1.fffffcp-127,
    (int)110
  },
  { // Entry 778
    0x1.fffffcp-16,
    0x1.fffffcp-127,
    (int)111
  },
  { // Entry 779
    0x1.fffffcp-15,
    0x1.fffffcp-127,
    (int)112
  },
  { // Entry 780
    0x1.fffffcp-14,
    0x1.fffffcp-127,
    (int)113
  },
  { // Entry 781
    0x1.fffffcp-13,
    0x1.fffffcp-127,
    (int)114
  },
  { // Entry 782
    0x1.fffffcp-12,
    0x1.fffffcp-127,
    (int)115
  },
  { // Entry 783
    0x1.fffffcp-11,
    0x1.fffffcp-127,
    (int)116
  },
  { // Entry 784
    0x1.fffffcp-10,
    0x1.fffffcp-127,
    (int)117
  },
  { // Entry 785
    0x1.fffffcp-9,
    0x1.fffffcp-127,
    (int)118
  },
  { // Entry 786
    0x1.fffffcp-8,
    0x1.fffffcp-127,
    (int)119
  },
  { // Entry 787
    0x1.fffffcp-7,
    0x1.fffffcp-127,
    (int)120
  },
  { // Entry 788
    0x1.fffffcp-6,
    0x1.fffffcp-127,
    (int)121
  },
  { // Entry 789
    0x1.fffffcp-5,
    0x1.fffffcp-127,
    (int)122
  },
  { // Entry 790
    0x1.fffffcp-4,
    0x1.fffffcp-127,
    (int)123
  },
  { // Entry 791
    0x1.fffffcp-3,
    0x1.fffffcp-127,
    (int)124
  },
  { // Entry 792
    0x1.fffffcp-2,
    0x1.fffffcp-127,
    (int)125
  },
  { // Entry 793
    0x1.fffffcp-1,
    0x1.fffffcp-127,
    (int)126
  },
  { // Entry 794
    0x1.fffffcp0,
    0x1.fffffcp-127,
    (int)127
  },
  { // Entry 795
    0x1.fffffcp1,
    0x1.fffffcp-127,
    (int)128
  },
  { // Entry 796
    0x1.fffffcp2,
    0x1.fffffcp-127,
    (int)129
  },
  { // Entry 797
    0x1.fffffcp3,
    0x1.fffffcp-127,
    (int)130
  },
  { // Entry 798
    0x1.p0,
    0x1.p-149,
    (int)149
  },
  { // Entry 799
    0x1.p-1,
    0x1.p-149,
    (int)148
  },
  { // Entry 800
    0x1.fffffcp22,
    0x1.fffffcp-127,
    (int)149
  },
  { // Entry 801
    0x1.fffffcp21,
    0x1.fffffcp-127,
    (int)148
  },
  { // Entry 802
    0x1.p-126,
    0x1.p-149,
    (int)23
  },
  { // Entry 803
    0x1.p-127,
    0x1.p-149,
    (int)22
  },
  { // Entry 804
    0x1.fffffcp-104,
    0x1.fffffcp-127,
    (int)23
  },
  { // Entry 805
    0x1.fffffcp-105,
    0x1.fffffcp-127,
    (int)22
  },
  { // Entry 806
    0x1.p-149,
    0x1.p-149,
    (int)0
  },
  { // Entry 807
    0x1.p-148,
    0x1.p-149,
    (int)1
  },
  { // Entry 808
    0x1.fffffcp-127,
    0x1.fffffcp-127,
    (int)0
  },
  { // Entry 809
    0x1.fffffcp-126,
    0x1.fffffcp-127,
    (int)1
  },
  { // Entry 810
    0.0,
    0.0f,
    (int)0
  },
  { // Entry 811
    -0.0,
    -0.0f,
    (int)0
  },
  { // Entry 812
    0.0,
    0.0f,
    (int)1
  },
  { // Entry 813
    -0.0,
    -0.0f,
    (int)1
  },
  { // Entry 814
    0.0,
    0.0f,
    (int)-1
  },
  { // Entry 815
    -0.0,
    -0.0f,
    (int)-1
  },
  { // Entry 816
    0.0,
    0.0f,
    (int)127
  },
  { // Entry 817
    -0.0,
    -0.0f,
    (int)127
  },
  { // Entry 818
    0.0,
    0.0f,
    (int)-127
  },
  { // Entry 819
    -0.0,
    -0.0f,
    (int)-127
  },
  { // Entry 820
    HUGE_VALF,
    HUGE_VALF,
    (int)0
  },
  { // Entry 821
    0x1.fffffep127,
    0x1.fffffep127,
    (int)0
  },
  { // Entry 822
    0x1.p-126,
    0x1.p-126,
    (int)0
  },
  { // Entry 823
    0x1.fffffcp-127,
    0x1.fffffcp-127,
    (int)0
  },
  { // Entry 824
    0x1.p-149,
    0x1.p-149,
    (int)0
  },
  { // Entry 825
    -0x1.p-149,
    -0x1.p-149,
    (int)0
  },
  { // Entry 826
    -0x1.fffffcp-127,
    -0x1.fffffcp-127,
    (int)0
  },
  { // Entry 827
    -0x1.p-126,
    -0x1.p-126,
    (int)0
  },
  { // Entry 828
    -0x1.fffffep127,
    -0x1.fffffep127,
    (int)0
  },
  { // Entry 829
    -HUGE_VALF,
    -HUGE_VALF,
    (int)0
  },
  { // Entry 830
    HUGE_VALF,
    HUGE_VALF,
    (int)1
  },
  { // Entry 831
    -HUGE_VALF,
    -HUGE_VALF,
    (int)1
  },
  { // Entry 832
    HUGE_VALF,
    HUGE_VALF,
    (int)-1
  },
  { // Entry 833
    -HUGE_VALF,
    -HUGE_VALF,
    (int)-1
  },
  { // Entry 834
    HUGE_VALF,
    HUGE_VALF,
    (int)127
  },
  { // Entry 835
    -HUGE_VALF,
    -HUGE_VALF,
    (int)127
  },
  { // Entry 836
    HUGE_VALF,
    HUGE_VALF,
    (int)-127
  },
  { // Entry 837
    -HUGE_VALF,
    -HUGE_VALF,
    (int)-127
  },
  { // Entry 838
    HUGE_VALF,
    0x1.fffffep127,
    (int)1
  },
  { // Entry 839
    HUGE_VALF,
    0x1.fffffep127,
    (int)127
  },
  { // Entry 840
    -HUGE_VALF,
    -0x1.fffffep127,
    (int)1
  },
  { // Entry 841
    -HUGE_VALF,
    -0x1.fffffep127,
    (int)127
  },
  { // Entry 842
    HUGE_VALF,
    0x1.p-126,
    (int)40000
  },
  { // Entry 843
    HUGE_VALF,
    0x1.p-149,
    (int)40000
  },
  { // Entry 844
    -HUGE_VALF,
    -0x1.p-126,
    (int)40000
  },
  { // Entry 845
    -HUGE_VALF,
    -0x1.p-149,
    (int)40000
  },
  { // Entry 846
    0x1.p-127,
    0x1.p-126,
    (int)-1
  },
  { // Entry 847
    0x1.fffffcp-128,
    0x1.fffffcp-127,
    (int)-1
  },
  { // Entry 848
    0.0f,
    0x1.p-149,
    (int)-1
  },
  { // Entry 849
    -0.0f,
    -0x1.p-149,
    (int)-1
  },
  { // Entry 850
    -0x1.fffffcp-128,
    -0x1.fffffcp-127,
    (int)-1
  },
  { // Entry 851
    -0x1.p-127,
    -0x1.p-126,
    (int)-1
  },
  { // Entry 852
    0.0f,
    0x1.fffffep127,
    (int)-40000
  },
  { // Entry 853
    -0.0f,
    -0x1.fffffep127,
    (int)-40000
  }
};
