static constexpr uint8_t expected_asm_kThumb2[] = {
    0x60, 0xB5, 0x2D, 0xED, 0x02, 0x8A, 0x8B, 0xB0, 0x0B, 0xB0,
    0xBD, 0xEC, 0x02, 0x8A, 0x60, 0xBD,
};
static constexpr uint8_t expected_cfi_kThumb2[] = {
    0x42, 0x0E, 0x0C, 0x85, 0x03, 0x86, 0x02, 0x8E, 0x01, 0x44, 0x0E, 0x14,
    0x05, 0x50, 0x05, 0x05, 0x51, 0x04, 0x42, 0x0E, 0x40, 0x0A, 0x42,
    0x0E, 0x14, 0x44, 0x0E, 0x0C, 0x06, 0x50, 0x06, 0x51, 0x42, 0x0B, 0x0E,
    0x40,
};
// 0x00000000: push {r5, r6, lr}
// 0x00000002: .cfi_def_cfa_offset: 12
// 0x00000002: .cfi_offset: r5 at cfa-12
// 0x00000002: .cfi_offset: r6 at cfa-8
// 0x00000002: .cfi_offset: r14 at cfa-4
// 0x00000002: vpush.f32 {s16-s17}
// 0x00000006: .cfi_def_cfa_offset: 20
// 0x00000006: .cfi_offset_extended: r80 at cfa-20
// 0x00000006: .cfi_offset_extended: r81 at cfa-16
// 0x00000006: sub sp, sp, #44
// 0x00000008: .cfi_def_cfa_offset: 64
// 0x00000008: .cfi_remember_state
// 0x00000008: add sp, sp, #44
// 0x0000000a: .cfi_def_cfa_offset: 20
// 0x0000000a: vpop.f32 {s16-s17}
// 0x0000000e: .cfi_def_cfa_offset: 12
// 0x0000000e: .cfi_restore_extended: r80
// 0x0000000e: .cfi_restore_extended: r81
// 0x0000000e: pop {r5, r6, pc}
// 0x00000010: .cfi_restore_state
// 0x00000010: .cfi_def_cfa_offset: 64

static constexpr uint8_t expected_asm_kArm64[] = {
    0xFF, 0x03, 0x01, 0xD1, 0xF4, 0x17, 0x00, 0xF9, 0xF5, 0x7B, 0x03, 0xA9,
    0xE8, 0xA7, 0x01, 0x6D, 0xE8, 0xA7, 0x41, 0x6D, 0xF4, 0x17, 0x40, 0xF9,
    0xF5, 0x7B, 0x43, 0xA9, 0xFF, 0x03, 0x01, 0x91, 0xC0, 0x03, 0x5F, 0xD6,
};
static constexpr uint8_t expected_cfi_kArm64[] = {
    0x44, 0x0E, 0x40, 0x44, 0x94, 0x06, 0x44, 0x95, 0x04, 0x9E, 0x02, 0x44,
    0x05, 0x48, 0x0A, 0x05, 0x49, 0x08, 0x0A, 0x44, 0x06, 0x48, 0x06, 0x49,
    0x44, 0xD4, 0x44, 0xD5, 0xDE, 0x44, 0x0E, 0x00, 0x44, 0x0B, 0x0E, 0x40,
};
// 0x00000000: sub sp, sp, #0x40 (64)
// 0x00000004: .cfi_def_cfa_offset: 64
// 0x00000004: str x20, [sp, #40]
// 0x00000008: .cfi_offset: r20 at cfa-24
// 0x00000008: stp x21, lr, [sp, #48]
// 0x0000000c: .cfi_offset: r21 at cfa-16
// 0x0000000c: .cfi_offset: r30 at cfa-8
// 0x0000000c: stp d8, d9, [sp, #24]
// 0x00000010: .cfi_offset_extended: r72 at cfa-40
// 0x00000010: .cfi_offset_extended: r73 at cfa-32
// 0x00000010: .cfi_remember_state
// 0x00000010: ldp d8, d9, [sp, #24]
// 0x00000014: .cfi_restore_extended: r72
// 0x00000014: .cfi_restore_extended: r73
// 0x00000014: ldr x20, [sp, #40]
// 0x00000018: .cfi_restore: r20
// 0x00000018: ldp x21, lr, [sp, #48]
// 0x0000001c: .cfi_restore: r21
// 0x0000001c: .cfi_restore: r30
// 0x0000001c: add sp, sp, #0x40 (64)
// 0x00000020: .cfi_def_cfa_offset: 0
// 0x00000020: ret
// 0x00000024: .cfi_restore_state
// 0x00000024: .cfi_def_cfa_offset: 64

static constexpr uint8_t expected_asm_kX86[] = {
    0x56, 0x55, 0x83, 0xEC, 0x34, 0x83, 0xC4, 0x34, 0x5D,
    0x5E, 0xC3,
};
static constexpr uint8_t expected_cfi_kX86[] = {
    0x41, 0x0E, 0x08, 0x86, 0x02, 0x41, 0x0E, 0x0C, 0x85, 0x03, 0x43, 0x0E,
    0x40, 0x0A, 0x43, 0x0E, 0x0C, 0x41, 0x0E, 0x08, 0xC5, 0x41, 0x0E,
    0x04, 0xC6, 0x41, 0x0B, 0x0E, 0x40,
};
// 0x00000000: push esi
// 0x00000001: .cfi_def_cfa_offset: 8
// 0x00000001: .cfi_offset: r6 at cfa-8
// 0x00000001: push ebp
// 0x00000002: .cfi_def_cfa_offset: 12
// 0x00000002: .cfi_offset: r5 at cfa-12
// 0x00000002: sub esp, 52
// 0x00000005: .cfi_def_cfa_offset: 64
// 0x00000005: .cfi_remember_state
// 0x00000005: add esp, 52
// 0x00000008: .cfi_def_cfa_offset: 12
// 0x00000008: pop ebp
// 0x0000000a: .cfi_def_cfa_offset: 8
// 0x0000000a: .cfi_restore: r5
// 0x0000000a: pop esi
// 0x0000000b: .cfi_def_cfa_offset: 4
// 0x0000000b: .cfi_restore: r6
// 0x0000000b: ret
// 0x0000000c: .cfi_restore_state
// 0x0000000c: .cfi_def_cfa_offset: 64

static constexpr uint8_t expected_asm_kX86_64[] = {
    0x55, 0x53, 0x48, 0x83, 0xEC, 0x28, 0xF2, 0x44, 0x0F, 0x11, 0x6C, 0x24,
    0x20, 0xF2, 0x44, 0x0F, 0x11, 0x64, 0x24, 0x18,
    0xF2, 0x44, 0x0F, 0x10, 0x64, 0x24, 0x18, 0xF2, 0x44, 0x0F, 0x10, 0x6C,
    0x24, 0x20, 0x48, 0x83, 0xC4, 0x28, 0x5B, 0x5D, 0xC3,
};
static constexpr uint8_t expected_cfi_kX86_64[] = {
    0x41, 0x0E, 0x10, 0x86, 0x04, 0x41, 0x0E, 0x18, 0x83, 0x06, 0x44, 0x0E,
    0x40, 0x47, 0x9E, 0x08, 0x47, 0x9D, 0x0A, 0x0A, 0x47, 0xDD, 0x47,
    0xDE, 0x44, 0x0E, 0x18, 0x41, 0x0E, 0x10, 0xC3, 0x41, 0x0E, 0x08, 0xC6,
    0x41, 0x0B, 0x0E, 0x40,
};
// 0x00000000: push rbp
// 0x00000001: .cfi_def_cfa_offset: 16
// 0x00000001: .cfi_offset: r6 at cfa-16
// 0x00000001: push rbx
// 0x00000002: .cfi_def_cfa_offset: 24
// 0x00000002: .cfi_offset: r3 at cfa-24
// 0x00000002: subq rsp, 40
// 0x00000006: .cfi_def_cfa_offset: 64
// 0x00000006: movsd [rsp + 32], xmm13
// 0x0000000d: .cfi_offset: r30 at cfa-32
// 0x0000000d: movsd [rsp + 24], xmm12
// 0x00000014: .cfi_offset: r29 at cfa-40
// 0x00000014: .cfi_remember_state
// 0x00000014: movsd xmm12, [rsp + 24]
// 0x0000001c: .cfi_restore: r29
// 0x0000001c: movsd xmm13, [rsp + 32]
// 0x00000022: .cfi_restore: r30
// 0x00000022: addq rsp, 40
// 0x00000026: .cfi_def_cfa_offset: 24
// 0x00000026: pop rbx
// 0x00000027: .cfi_def_cfa_offset: 16
// 0x00000027: .cfi_restore: r3
// 0x00000027: pop rbp
// 0x00000028: .cfi_def_cfa_offset: 8
// 0x00000028: .cfi_restore: r6
// 0x00000028: ret
// 0x00000029: .cfi_restore_state
// 0x00000029: .cfi_def_cfa_offset: 64

static constexpr uint8_t expected_asm_kMips[] = {
    0xC0, 0xFF, 0xBD, 0x27, 0x3C, 0x00, 0xBF, 0xAF, 0x38, 0x00, 0xB1, 0xAF,
    0x34, 0x00, 0xB0, 0xAF, 0x28, 0x00, 0xB6, 0xF7, 0x20, 0x00, 0xB4, 0xF7,
    0x3C, 0x00, 0xBF, 0x8F, 0x38, 0x00, 0xB1, 0x8F,
    0x34, 0x00, 0xB0, 0x8F, 0x28, 0x00, 0xB6, 0xD7, 0x20, 0x00, 0xB4, 0xD7,
    0x09, 0x00, 0xE0, 0x03, 0x40, 0x00, 0xBD, 0x27,
};
static constexpr uint8_t expected_cfi_kMips[] = {
    0x44, 0x0E, 0x40, 0x44, 0x9F, 0x01, 0x44, 0x91, 0x02, 0x44, 0x90, 0x03,
    0x48, 0x0A, 0x44, 0xDF, 0x44, 0xD1, 0x44, 0xD0, 0x50, 0x0E, 0x00, 0x0B,
    0x0E, 0x40,
};
// 0x00000000: addiu r29, r29, -64
// 0x00000004: .cfi_def_cfa_offset: 64
// 0x00000004: sw r31, +60(r29)
// 0x00000008: .cfi_offset: r31 at cfa-4
// 0x00000008: sw r17, +56(r29)
// 0x0000000c: .cfi_offset: r17 at cfa-8
// 0x0000000c: sw r16, +52(r29)
// 0x00000010: .cfi_offset: r16 at cfa-12
// 0x00000010: sdc1 f22, +40(r29)
// 0x00000014: sdc1 f20, +32(r29)
// 0x00000018: .cfi_remember_state
// 0x00000018: lw r31, +60(r29)
// 0x0000001c: .cfi_restore: r31
// 0x0000001c: lw r17, +56(r29)
// 0x00000020: .cfi_restore: r17
// 0x00000020: lw r16, +52(r29)
// 0x00000024: .cfi_restore: r16
// 0x00000024: ldc1 f22, +40(r29)
// 0x00000028: ldc1 f20, +32(r29)
// 0x0000002c: jr r31
// 0x00000030: addiu r29, r29, 64
// 0x00000034: .cfi_def_cfa_offset: 0
// 0x00000034: .cfi_restore_state
// 0x00000034: .cfi_def_cfa_offset: 64

static constexpr uint8_t expected_asm_kMips64[] = {
    0xC0, 0xFF, 0xBD, 0x67, 0x38, 0x00, 0xBF, 0xFF, 0x30, 0x00, 0xB1, 0xFF,
    0x28, 0x00, 0xB0, 0xFF, 0x20, 0x00, 0xB9, 0xF7, 0x18, 0x00, 0xB8, 0xF7,
    0x38, 0x00, 0xBF, 0xDF, 0x30, 0x00, 0xB1, 0xDF, 0x28, 0x00, 0xB0, 0xDF,
    0x20, 0x00, 0xB9, 0xD7, 0x18, 0x00, 0xB8, 0xD7, 0x40, 0x00, 0xBD, 0x67,
    0x00, 0x00, 0x1F, 0xD8,
};
static constexpr uint8_t expected_cfi_kMips64[] = {
    0x44, 0x0E, 0x40, 0x44, 0x9F, 0x02, 0x44, 0x91, 0x04, 0x44, 0x90, 0x06,
    0x44, 0xB9, 0x08, 0x44, 0xB8, 0x0A, 0x0A, 0x44, 0xDF, 0x44, 0xD1, 0x44,
    0xD0, 0x44, 0xF9, 0x44, 0xF8, 0x44, 0x0E, 0x00, 0x44, 0x0B, 0x0E, 0x40,
};
// 0x00000000: daddiu r29, r29, -64
// 0x00000004: .cfi_def_cfa_offset: 64
// 0x00000004: sd r31, +56(r29)
// 0x00000008: .cfi_offset: r31 at cfa-8
// 0x00000008: sd r17, +48(r29)
// 0x0000000c: .cfi_offset: r17 at cfa-16
// 0x0000000c: sd r16, +40(r29)
// 0x00000010: .cfi_offset: r16 at cfa-24
// 0x00000010: sdc1 f25, +32(r29)
// 0x00000014: .cfi_offset: r57 at cfa-32
// 0x00000014: sdc1 f24, +24(r29)
// 0x00000018: .cfi_offset: r56 at cfa-40
// 0x00000018: .cfi_remember_state
// 0x00000018: ld r31, +56(r29)
// 0x0000001c: .cfi_restore: r31
// 0x0000001c: ld r17, +48(r29)
// 0x00000020: .cfi_restore: r17
// 0x00000020: ld r16, +40(r29)
// 0x00000024: .cfi_restore: r16
// 0x00000024: ldc1 f25, +32(r29)
// 0x00000028: .cfi_restore: r57
// 0x00000028: ldc1 f24, +24(r29)
// 0x0000002c: .cfi_restore: r56
// 0x0000002c: daddiu r29, r29, 64
// 0x00000030: .cfi_def_cfa_offset: 0
// 0x00000030: jic r31, 0
// 0x00000034: .cfi_restore_state
// 0x00000034: .cfi_def_cfa_offset: 64

static constexpr uint8_t expected_asm_kThumb2_adjust[] = {
#ifdef ART_USE_OLD_ARM_BACKEND
    0x60, 0xB5, 0x2D, 0xED, 0x02, 0x8A, 0x8B, 0xB0, 0x00, 0x28,
    0x40, 0xD0, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68,
#else
    // VIXL emits an extra 2 bytes here for a 32-bit beq as there is no
    // optimistic 16-bit emit and subsequent fixup for out of reach targets
    // as with the old assembler.
    0x60, 0xB5, 0x2D, 0xED, 0x02, 0x8A, 0x8B, 0xB0, 0x00, 0x28, 0x00, 0xF0,
    0x41, 0x80, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68,
#endif
    0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68,
    0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68,
    0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68,
    0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68,
    0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68,
    0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68,
    0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68,
    0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68,
    0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68,
    0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68, 0x00, 0x68,
    0x0B, 0xB0, 0xBD, 0xEC, 0x02, 0x8A, 0x60, 0xBD,
};
static constexpr uint8_t expected_cfi_kThumb2_adjust[] = {
    0x42, 0x0E, 0x0C, 0x85, 0x03, 0x86, 0x02, 0x8E, 0x01, 0x44, 0x0E, 0x14,
#ifdef ART_USE_OLD_ARM_BACKEND
    0x05, 0x50, 0x05, 0x05, 0x51, 0x04, 0x42, 0x0E, 0x40, 0x02, 0x86, 0x0A,
#else
    0x05, 0x50, 0x05, 0x05, 0x51, 0x04, 0x42, 0x0E, 0x40, 0x02, 0x88, 0x0A,
#endif
    0x42, 0x0E, 0x14, 0x44, 0x0E, 0x0C, 0x06, 0x50, 0x06, 0x51, 0x42, 0x0B,
    0x0E, 0x40,
};
// 0x00000000: push {r5, r6, lr}
// 0x00000002: .cfi_def_cfa_offset: 12
// 0x00000002: .cfi_offset: r5 at cfa-12
// 0x00000002: .cfi_offset: r6 at cfa-8
// 0x00000002: .cfi_offset: r14 at cfa-4
// 0x00000002: vpush.f32 {s16-s17}
// 0x00000006: .cfi_def_cfa_offset: 20
// 0x00000006: .cfi_offset_extended: r80 at cfa-20
// 0x00000006: .cfi_offset_extended: r81 at cfa-16
// 0x00000006: sub sp, sp, #44
// 0x00000008: .cfi_def_cfa_offset: 64
// 0x00000008: cmp r0, #0
// 0x0000000a: beq +128 (0x00000090)
// 0x0000000c: ldr r0, [r0, #0]
// 0x0000000e: ldr r0, [r0, #0]
// 0x00000010: ldr r0, [r0, #0]
// 0x00000012: ldr r0, [r0, #0]
// 0x00000014: ldr r0, [r0, #0]
// 0x00000016: ldr r0, [r0, #0]
// 0x00000018: ldr r0, [r0, #0]
// 0x0000001a: ldr r0, [r0, #0]
// 0x0000001c: ldr r0, [r0, #0]
// 0x0000001e: ldr r0, [r0, #0]
// 0x00000020: ldr r0, [r0, #0]
// 0x00000022: ldr r0, [r0, #0]
// 0x00000024: ldr r0, [r0, #0]
// 0x00000026: ldr r0, [r0, #0]
// 0x00000028: ldr r0, [r0, #0]
// 0x0000002a: ldr r0, [r0, #0]
// 0x0000002c: ldr r0, [r0, #0]
// 0x0000002e: ldr r0, [r0, #0]
// 0x00000030: ldr r0, [r0, #0]
// 0x00000032: ldr r0, [r0, #0]
// 0x00000034: ldr r0, [r0, #0]
// 0x00000036: ldr r0, [r0, #0]
// 0x00000038: ldr r0, [r0, #0]
// 0x0000003a: ldr r0, [r0, #0]
// 0x0000003c: ldr r0, [r0, #0]
// 0x0000003e: ldr r0, [r0, #0]
// 0x00000040: ldr r0, [r0, #0]
// 0x00000042: ldr r0, [r0, #0]
// 0x00000044: ldr r0, [r0, #0]
// 0x00000046: ldr r0, [r0, #0]
// 0x00000048: ldr r0, [r0, #0]
// 0x0000004a: ldr r0, [r0, #0]
// 0x0000004c: ldr r0, [r0, #0]
// 0x0000004e: ldr r0, [r0, #0]
// 0x00000050: ldr r0, [r0, #0]
// 0x00000052: ldr r0, [r0, #0]
// 0x00000054: ldr r0, [r0, #0]
// 0x00000056: ldr r0, [r0, #0]
// 0x00000058: ldr r0, [r0, #0]
// 0x0000005a: ldr r0, [r0, #0]
// 0x0000005c: ldr r0, [r0, #0]
// 0x0000005e: ldr r0, [r0, #0]
// 0x00000060: ldr r0, [r0, #0]
// 0x00000062: ldr r0, [r0, #0]
// 0x00000064: ldr r0, [r0, #0]
// 0x00000066: ldr r0, [r0, #0]
// 0x00000068: ldr r0, [r0, #0]
// 0x0000006a: ldr r0, [r0, #0]
// 0x0000006c: ldr r0, [r0, #0]
// 0x0000006e: ldr r0, [r0, #0]
// 0x00000070: ldr r0, [r0, #0]
// 0x00000072: ldr r0, [r0, #0]
// 0x00000074: ldr r0, [r0, #0]
// 0x00000076: ldr r0, [r0, #0]
// 0x00000078: ldr r0, [r0, #0]
// 0x0000007a: ldr r0, [r0, #0]
// 0x0000007c: ldr r0, [r0, #0]
// 0x0000007e: ldr r0, [r0, #0]
// 0x00000080: ldr r0, [r0, #0]
// 0x00000082: ldr r0, [r0, #0]
// 0x00000084: ldr r0, [r0, #0]
// 0x00000086: ldr r0, [r0, #0]
// 0x00000088: ldr r0, [r0, #0]
// 0x0000008a: ldr r0, [r0, #0]
// 0x0000008c: ldr r0, [r0, #0]
// 0x0000008e: .cfi_remember_state
// 0x0000008e: add sp, sp, #44
// 0x00000090: .cfi_def_cfa_offset: 20
// 0x00000090: vpop.f32 {s16-s17}
// 0x00000094: .cfi_def_cfa_offset: 12
// 0x00000094: .cfi_restore_extended: r80
// 0x00000094: .cfi_restore_extended: r81
// 0x00000094: pop {r5, r6, pc}
// 0x00000096: .cfi_restore_state
// 0x00000096: .cfi_def_cfa_offset: 64

static constexpr uint8_t expected_asm_kMips_adjust_head[] = {
    0xC0, 0xFF, 0xBD, 0x27, 0x3C, 0x00, 0xBF, 0xAF, 0x38, 0x00, 0xB1, 0xAF,
    0x34, 0x00, 0xB0, 0xAF, 0x28, 0x00, 0xB6, 0xF7, 0x20, 0x00, 0xB4, 0xF7,
    0x08, 0x00, 0x04, 0x14, 0xFC, 0xFF, 0xBD, 0x27,
    0x00, 0x00, 0xBF, 0xAF, 0x00, 0x00, 0x10, 0x04, 0x02, 0x00, 0x01, 0x3C,
    0x18, 0x00, 0x21, 0x34, 0x21, 0x08, 0x3F, 0x00, 0x00, 0x00, 0xBF, 0x8F,
    0x09, 0x00, 0x20, 0x00, 0x04, 0x00, 0xBD, 0x27,
};
static constexpr uint8_t expected_asm_kMips_adjust_tail[] = {
    0x3C, 0x00, 0xBF, 0x8F, 0x38, 0x00, 0xB1, 0x8F, 0x34, 0x00, 0xB0, 0x8F,
    0x28, 0x00, 0xB6, 0xD7, 0x20, 0x00, 0xB4, 0xD7, 0x09, 0x00, 0xE0, 0x03,
    0x40, 0x00, 0xBD, 0x27,
};
static constexpr uint8_t expected_cfi_kMips_adjust[] = {
    0x44, 0x0E, 0x40, 0x44, 0x9F, 0x01, 0x44, 0x91, 0x02, 0x44, 0x90, 0x03,
    0x50, 0x0E, 0x44, 0x60, 0x0E, 0x40, 0x04, 0x04, 0x00, 0x02, 0x00, 0x0A,
    0x44, 0xDF, 0x44, 0xD1, 0x44, 0xD0, 0x50, 0x0E, 0x00, 0x0B, 0x0E, 0x40,
};
// 0x00000000: addiu r29, r29, -64
// 0x00000004: .cfi_def_cfa_offset: 64
// 0x00000004: sw r31, +60(r29)
// 0x00000008: .cfi_offset: r31 at cfa-4
// 0x00000008: sw r17, +56(r29)
// 0x0000000c: .cfi_offset: r17 at cfa-8
// 0x0000000c: sw r16, +52(r29)
// 0x00000010: .cfi_offset: r16 at cfa-12
// 0x00000010: sdc1 f22, +40(r29)
// 0x00000014: sdc1 f20, +32(r29)
// 0x00000018: bne r0, r4, 0x00000040 ; +36
// 0x0000001c: addiu r29, r29, -4
// 0x00000020: .cfi_def_cfa_offset: 68
// 0x00000020: sw r31, +0(r29)
// 0x00000024: bltzal r0, 0x0000002c ; +4
// 0x00000028: lui r1, 0x20000
// 0x0000002c: ori r1, r1, 24
// 0x00000030: addu r1, r1, r31
// 0x00000034: lw r31, +0(r29)
// 0x00000038: jr r1
// 0x0000003c: addiu r29, r29, 4
// 0x00000040: .cfi_def_cfa_offset: 64
// 0x00000040: nop
//             ...
// 0x00020040: nop
// 0x00020044: .cfi_remember_state
// 0x00020044: lw r31, +60(r29)
// 0x00020048: .cfi_restore: r31
// 0x00020048: lw r17, +56(r29)
// 0x0002004c: .cfi_restore: r17
// 0x0002004c: lw r16, +52(r29)
// 0x00020050: .cfi_restore: r16
// 0x00020050: ldc1 f22, +40(r29)
// 0x00020054: ldc1 f20, +32(r29)
// 0x00020058: jr r31
// 0x0002005c: addiu r29, r29, 64
// 0x00020060: .cfi_def_cfa_offset: 0
// 0x00020060: .cfi_restore_state
// 0x00020060: .cfi_def_cfa_offset: 64

static constexpr uint8_t expected_asm_kMips64_adjust_head[] = {
    0xC0, 0xFF, 0xBD, 0x67, 0x38, 0x00, 0xBF, 0xFF, 0x30, 0x00, 0xB1, 0xFF,
    0x28, 0x00, 0xB0, 0xFF, 0x20, 0x00, 0xB9, 0xF7, 0x18, 0x00, 0xB8, 0xF7,
    0x02, 0x00, 0xA6, 0x60, 0x02, 0x00, 0x3E, 0xEC, 0x0C, 0x00, 0x01, 0xD8,
};
static constexpr uint8_t expected_asm_kMips64_adjust_tail[] = {
    0x38, 0x00, 0xBF, 0xDF, 0x30, 0x00, 0xB1, 0xDF, 0x28, 0x00, 0xB0, 0xDF,
    0x20, 0x00, 0xB9, 0xD7, 0x18, 0x00, 0xB8, 0xD7, 0x40, 0x00, 0xBD, 0x67,
    0x00, 0x00, 0x1F, 0xD8,
};
static constexpr uint8_t expected_cfi_kMips64_adjust[] = {
    0x44, 0x0E, 0x40, 0x44, 0x9F, 0x02, 0x44, 0x91, 0x04, 0x44, 0x90, 0x06,
    0x44, 0xB9, 0x08, 0x44, 0xB8, 0x0A, 0x04, 0x10, 0x00, 0x02, 0x00, 0x0A,
    0x44, 0xDF, 0x44, 0xD1, 0x44, 0xD0, 0x44, 0xF9, 0x44, 0xF8, 0x44, 0x0E,
    0x00, 0x44, 0x0B, 0x0E, 0x40,
};
// 0x00000000: daddiu r29, r29, -64
// 0x00000004: .cfi_def_cfa_offset: 64
// 0x00000004: sd r31, +56(r29)
// 0x00000008: .cfi_offset: r31 at cfa-8
// 0x00000008: sd r17, +48(r29)
// 0x0000000c: .cfi_offset: r17 at cfa-16
// 0x0000000c: sd r16, +40(r29)
// 0x00000010: .cfi_offset: r16 at cfa-24
// 0x00000010: sdc1 f25, +32(r29)
// 0x00000014: .cfi_offset: r57 at cfa-32
// 0x00000014: sdc1 f24, +24(r29)
// 0x00000018: .cfi_offset: r56 at cfa-40
// 0x00000018: bnec r5, r6, 0x00000024 ; +12
// 0x0000001c: auipc r1, 2
// 0x00000020: jic r1, 12 ; bc 0x00020028 ; +131080
// 0x00000024: nop
//             ...
// 0x00020024: nop
// 0x00020028: .cfi_remember_state
// 0x00020028: ld r31, +56(r29)
// 0x0002002c: .cfi_restore: r31
// 0x0002002c: ld r17, +48(r29)
// 0x00020030: .cfi_restore: r17
// 0x00020030: ld r16, +40(r29)
// 0x00020034: .cfi_restore: r16
// 0x00020034: ldc1 f25, +32(r29)
// 0x00020038: .cfi_restore: r57
// 0x00020038: ldc1 f24, +24(r29)
// 0x0002003c: .cfi_restore: r56
// 0x0002003c: daddiu r29, r29, 64
// 0x00020040: .cfi_def_cfa_offset: 0
// 0x00020040: jic r31, 0
// 0x00020044: .cfi_restore_state
// 0x00020044: .cfi_def_cfa_offset: 64
