/*
 * Created on 2004/06/15
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.util.ArrayList;

import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;


/**
 * @author kuromaru
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public abstract class SGSignificantDifferenceSymbol extends SGDrawingElement
	implements SGISignificantDifferenceSymbolConstants, SGIDrawingElementConstants
{



	/**
	 * 
	 */
	protected float mX;


	/**
	 * 
	 */
	protected float mY;


	/**
	 * 
	 */
	protected float mWidth;


	/**
	 * 
	 */
	protected float mPerpendicularHeight1;


	/**
	 * 
	 */
	protected float mPerpendicularHeight2;


	/**
	 * 
	 */
	protected float mSpace;


	/**
	 * 
	 */
	protected float mLineWidth;


	/**
	 * 
	 */
	protected boolean mLineVisibleFlag = true;

	
	
	/**
	 * @return mLineVisibleFlag
	 */
	public boolean isLineVisible()
	{
		return mLineVisibleFlag;
	}

	/**
	 * @param lineVisibleFlag mLineVisibleFlag ݒ肵܂B
	 */
	public void setLineVisible( final boolean b )
	{
		mLineVisibleFlag = b;
	}

	
	/**
	 * 
	 */
	public SGSignificantDifferenceSymbol()
	{
		super();
	}


	/**
	 * 
	 */
	public SGSignificantDifferenceSymbol(
		final float x,
		final float y,
		final float w,
		final float hl,
		final float hr )
	{
		super();
		this.setLocation(x,y);
		this.setSize(w,hl,hr);
	}



	/**
	 * 
	 */
	public float getX()
	{
		return this.mX;
	}


	/**
	 * 
	 */
	public float getY()
	{
		return this.mY;
	}

	
	
	/**
	 * 
	 * @return
	 */
	public float getX1()
	{
		return this.getX();
	}
	
	
	/**
	 * 
	 * @return
	 */
	public float getX2()
	{
		return this.getX1() + this.getWidth();
	}
	

	/**
	 * 
	 * @return
	 */
	public float getY1()
	{
		return this.getY() + this.getPerpendicularHeight1();
	}
	

	
	/**
	 * 
	 * @return
	 */
	public float getY2()
	{
		return this.getY() + this.getPerpendicularHeight2();
	}

	

	/**
	 * 
	 */
	public float getWidth()
	{
		return this.mWidth*this.mMagnification;
	}


	/**
	 * 
	 */
	public float getPerpendicularHeight1()
	{
		return this.mPerpendicularHeight1*this.mMagnification;
	}


	/**
	 * 
	 */
	public float getPerpendicularHeight2()
	{
		return this.mPerpendicularHeight2*this.mMagnification;
	}


	/**
	 * 
	 */
	public float getSpace()
	{
		return this.mSpace*this.mMagnification;
	}


	/**
	 * 
	 */
	public abstract SGDrawingElementString getStringElement();


	/**
	 * 
	 */
	public String getText()
	{
		return this.getStringElement().getString();
	}


	/**
	 * 
	 */
	public float getFontSize()
	{
		return this.getStringElement().getFontSize();
	}


	/**
	 * 
	 */
	public int getFontStyle()
	{
		return this.getStringElement().getFontStyle();
	}


	/**
	 * 
	 */
	public String getFontName()
	{
		return this.getStringElement().getFontName();
	}


	/**
	 * 
	 */
	public float getLineWidth()
	{
		return this.mLineWidth;
	}


	/**
	 * 
	 */
	public Color getColor()
	{
		return this.getColor(0);
	}




	/**
	 * 
	 */
	public boolean setColorList( final ArrayList colorList )
	{
		super.setColorList( colorList );
		this.getStringElement().setColorList( colorList );
		return true;
	}


	/**
	 * 
	 */
	public boolean setColor( final Color color )
	{
		super.setColor( color );
		this.getStringElement().setColor( color );
		return true;
	}


	/**
	 * 
	 * @return
	 */
	public boolean addColor( final Color color )
	{
		super.addColor( color );
		this.getStringElement().addColor( color );
		return true;
	}




	/**
	 * 
	 */
	public boolean setLocation( final float x, final float y )
	{
		this.setX(x);
		this.setY(y);
		return true;
	}



	/**
	 * 
	 * @param x
	 * @return
	 */
	public boolean setX( final float x )
	{
		this.mX = x;
		return true;
	}



	/**
	 * 
	 * @param y
	 * @return
	 */
	public boolean setY( final float y )
	{
		this.mY = y;
		return true;
	}



	/**
	 * 
	 */
	public boolean setSize( final float w, final float h1, final float h2 )
	{
		this.setWidth(w);
		this.setPerpendicularHeight1(h1);
		this.setPerpendicularHeight2(h2);
		return true;
	}


	/**
	 * 
	 */
	public boolean setWidth( final float w )
	{
		this.mWidth = w/this.mMagnification;
		return true;
	}


	/**
	 * 
	 */
	public boolean setPerpendicularHeight1( final float h )
	{
		this.mPerpendicularHeight1 = h/this.mMagnification;
		return true;
	}


	/**
	 * 
	 */
	public boolean setPerpendicularHeight2( final float h )
	{
		this.mPerpendicularHeight2 = h/this.mMagnification;
		return true;
	}


	/**
	 * 
	 */
	public boolean setSpace( final float space )
	{
		if( space < 0.0 )
		{
			throw new IllegalArgumentException("space < 0.0");
		}

		this.mSpace = space/this.mMagnification;

		return true;
	}



	/**
	 * 
	 */
	public boolean setText( final String text )
	{
		if( text==null )
		{
			throw new IllegalArgumentException("text==null");
		}
		this.getStringElement().setString( text );
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineWidth( final float lineWidth )
	{
		if( lineWidth < Float.MIN_VALUE )
		{
			throw new IllegalArgumentException("lineWidth < Float.MIN_VALUE");
		}
		this.mLineWidth = lineWidth;
		return true;
	}



	/**
	 * 
	 * @param name
	 * @param style
	 * @param size
	 * @return
	 */
	public boolean setFont( final String name, final int style, final float size )
	{
		if( size < Float.MIN_VALUE )
		{
			throw new IllegalArgumentException("size < Float.MIN_VALUE");
		}
		this.getStringElement().setFont( name, style, size );
		return true;
	}

	
	
	/**
	 * 
	 * @return
	 */
	public boolean isFlippingHorizontal()
	{
		return ( this.mWidth < 0.0f );
	}


	/**
	 * 
	 * @return
	 */
	public boolean isFlippingVertical()
	{
		return ( this.isFlippingVertical1() && this.isFlippingVertical2() );
	}


	/**
	 * 
	 * @return
	 */
	public boolean isFlippingVertical1()
	{
		return ( this.mPerpendicularHeight1 < 0.0f );
	}


	/**
	 * 
	 * @return
	 */
	public boolean isFlippingVertical2()
	{
		return ( this.mPerpendicularHeight2 < 0.0f );
	}


	/**
	 * 
	 * @return
	 */
	public boolean isFlippingVerticalLeft()
	{
		return ( !this.isFlippingHorizontal() ? this.isFlippingVertical1() : this.isFlippingVertical2() );
	}


	/**
	 * 
	 * @return
	 */
	public boolean isFlippingVerticalRight()
	{
		return ( !this.isFlippingHorizontal() ? this.isFlippingVertical2() : this.isFlippingVertical1() );
	}



	/**
	 * 
	 * @return
	 */
	public float getLeftHeight()
	{
		if( !this.isFlippingHorizontal() )
		{
			return this.getPerpendicularHeight1();
		}
		else
		{
			return this.getPerpendicularHeight2();
		}
	}


	/**
	 * 
	 * @return
	 */
	public float getRightHeight()
	{
		if( !this.isFlippingHorizontal() )
		{
			return this.getPerpendicularHeight2();
		}
		else
		{
			return this.getPerpendicularHeight1();
		}
	}



	/**
	 * 
	 * @param h
	 * @return
	 */
	public boolean setLeftHeight( final float h )
	{
		if( !this.isFlippingHorizontal() )
		{
			this.setPerpendicularHeight1( h );
		}
		else
		{
			this.setPerpendicularHeight2( h );
		}
		return true;
	}



	/**
	 * 
	 * @param h
	 * @return
	 */
	public boolean setRightHeight( final float h )
	{
		if( !this.isFlippingHorizontal() )
		{
			this.setPerpendicularHeight2( h );
		}
		else
		{
			this.setPerpendicularHeight1( h );
		}
		return true;
	}


	
	/**
	 * 
	 * @param x
	 * @return
	 */
	public boolean setNodePointLocation(
		final float x1, final float y1, final float x2, final float y2, final float y )
	{
		// x
		final float w = x2 - x1;
		this.setX(x1);
		this.setWidth(w);

		// y
		this.setY(y);
		final float h1 = y1 - y;
		final float h2 = y2 - y;
		this.setPerpendicularHeight1(h1);
		this.setPerpendicularHeight2(h2);
		
		return true;
	}
	


	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		SigDiffProperties p = new SigDiffProperties();

		if( this.getProperties(p) == false ) return null;

		return p;
	}



	/**
	 * 
	 */
	public boolean getProperties( SGProperties p )
	{
		if( ( p instanceof SigDiffProperties ) == false ) return false;

		if( super.getProperties(p) == false ) return false;

		SigDiffProperties sp = (SigDiffProperties)p;
		
		sp.space = this.mSpace;
		sp.lineVisible = this.mLineVisibleFlag;
		sp.lineWidth = this.mLineWidth;
		sp.text = this.getText();
		sp.fontName = this.getFontName();
		sp.fontSize = this.getFontSize();
		sp.fontStyle = this.getFontStyle();
		
		return true;
	}
	
	

	/**
	 * 
	 */
	public boolean setProperties( final SGProperties p )
	{
		if( ( p instanceof SigDiffProperties ) == false ) return false;
		
		if( super.setProperties(p) == false ) return false;

		SigDiffProperties sp = (SigDiffProperties)p;

		this.mSpace = sp.space;
		this.setText( sp.text );
		this.setFont( sp.fontName, sp.fontStyle, sp.fontSize );
		this.setLineVisible( sp.lineVisible );
		this.setLineWidth( sp.lineWidth );

		return true;
	}



	/**
	 * 
	 */
	public static class SigDiffProperties extends SGDrawingElement.DrawingElementProperties
	{
		public float space;
		public float lineWidth;
		public String text;
		public String fontName;
		public float fontSize;
		public int fontStyle;
		public boolean lineVisible;

		public SigDiffProperties()
		{
			super();
		}


		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{
			if( ( obj instanceof SigDiffProperties ) == false ) return false;

			SigDiffProperties p = (SigDiffProperties)obj;

			if( p.space != this.space ) return false;
			if( p.lineWidth != this.lineWidth ) return false;
			if( p.text.equals(this.text) == false ) return false;
			if( p.fontName.equals(this.fontName) == false ) return false;
			if( p.fontSize != this.fontSize ) return false;
			if( p.fontStyle != this.fontStyle ) return false;
			if( p.lineVisible != this.lineVisible ) return false;

			return true;
		}

	}



}

