/*
 * SGUpgradeDialog.java
 *
 * Created on 2004/10/28, 10:20
 */

package jp.riken.brain.ni.samuraigraph.application;

import java.awt.event.ActionEvent;
import jp.riken.brain.ni.samuraigraph.base.SGDialog;


/**
 *
 * @author  kuromaru
 */
public class SGUpgradeDialog extends SGDialog
{

	public static final String TITLE = "Auto Upgrade Settings";


	/**
	 * 
	 */
	public SGUpgradeDialog()
	{
		super();
		this.initComponents();
		this.initProperty();
	}

    
    /** Creates new form SGUpgradeDialog */
    public SGUpgradeDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
		this.initProperty();
    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mPanel = new javax.swing.JPanel();
        mUpgradeCycleComboBox = new javax.swing.JComboBox();
        mUpgradeButton = new javax.swing.JButton();
        mUpgradeCycleLabel = new javax.swing.JLabel();
        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        mPanel.setLayout(new java.awt.GridBagLayout());

        mPanel.setBorder(new javax.swing.border.TitledBorder(null, "Configure Auto Upgrade", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 12)));
        mUpgradeCycleComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mUpgradeCycleComboBox.setPreferredSize(new java.awt.Dimension(111, 25));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 0, 10);
        mPanel.add(mUpgradeCycleComboBox, gridBagConstraints);

        mUpgradeButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mUpgradeButton.setText("Check for Update Now");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.insets = new java.awt.Insets(13, 10, 10, 10);
        mPanel.add(mUpgradeButton, gridBagConstraints);

        mUpgradeCycleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mUpgradeCycleLabel.setText("Update Check Cycle");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 5);
        mPanel.add(mUpgradeCycleLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 10);
        getContentPane().add(mPanel, gridBagConstraints);

        mButtonPanel.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(1, 1, 1, 1)));
        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mButtonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents


    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JButton mOKButton;
    private javax.swing.JPanel mPanel;
    private javax.swing.JButton mUpgradeButton;
    private javax.swing.JComboBox mUpgradeCycleComboBox;
    private javax.swing.JLabel mUpgradeCycleLabel;
    // ϐ錾̏I//GEN-END:variables



	//
	public static final String NO_UPGRADE = "No Upgrade";
	public static final String EVERY_TIME = "Every Time";
	public static final String EVERY_DAY = "Every Day";
	public static final String EVERY_WEEK = "Every Week";
	public static final String EVERY_MONTH = "Every Month";

	public static final String UPGRADE_NOW = "Check for Update Now";


	private String mUpgrade = null;



	/**
	 * 
	 */
	private boolean initProperty()
	{
		//
		this.setTitle( TITLE );

		//
		final String[] styleNameArray = {
			NO_UPGRADE,
			EVERY_TIME,
			EVERY_DAY,
			EVERY_WEEK,
			EVERY_MONTH
		};
		for( int ii=0; ii<styleNameArray.length; ii++ )
		{
			this.mUpgradeCycleComboBox.addItem( styleNameArray[ii] );
		}

		this.pack();


{
	this.mOKButton.addActionListener(this);
	this.mCancelButton.addActionListener(this);
}

		this.mUpgradeButton.addActionListener(this);

		return true;
	}



	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{
		Object source = e.getSource();
		String command = e.getActionCommand();
		
		if( command.equals( SGDialog.OK_BUTTON_TEXT ) )
		{
			this.onOK();
		}
		else if( command.equals( SGDialog.CANCEL_BUTTON_TEXT ) )
		{
			this.onCanceled();
		}
		else if( command.equals( SGUpgradeDialog.UPGRADE_NOW ) )
		{
			this.notifyToListener( command );
		}

	}


	/**
	 * 
	 * @return
	 */
	public String getUpgradeCycle()
	{
		return this.mUpgrade;
	}


	/**
	 * 
	 * @param cycle
	 */
	public void setUpgradeCycle( final String cycle )
	{
		this.mUpgrade = cycle;
	}


	/**
	 * 
	 */
	public void setVisible( final boolean b )
	{
		this.mUpgradeCycleComboBox.setSelectedItem( this.mUpgrade );
		super.setVisible(b);
	}


	/**
	 * 
	 */
	protected boolean onOK()
	{
		this.mUpgrade = (String)this.mUpgradeCycleComboBox.getSelectedItem();

		this.setVisible(false);
		this.notifyToListener( OK_BUTTON_TEXT );
		return true;
	}


	/**
	 * 
	 */
	protected boolean onCanceled()
	{
		this.setVisible(false);
		this.notifyToListener( CANCEL_BUTTON_TEXT );
		return true;
	}


}

