
package jp.riken.brain.ni.helper;

import java.io.File;
import java.io.IOException;

import javax.swing.JOptionPane;


/**
 * A helper application of Samurai Graph application.
 * This application uninstall the old version and install the new version
 * in automatic upgrade of Samurai Graph.
 */
public class UpgradeHelper
{

	/**
	 * The main method.
	 * @param args parameters from a command line
	 */
	public static void main( String[] args )
	{
		if( args.length!=3 )
		{
			JOptionPane.showMessageDialog(
				null,
				"Wrong parameters!"
			);
			return;
		}
		execute( args[0], args[1], args[2] );
		System.exit(0);
	}



	/**
	 * Execute uninstaller and installer.
	 * @param pathOld A pathname string of the old version
	 * @param pathInst A pathname string of the installer
	 * @param pathNew A pathname string of the new version
	 * @return true:success, false:failure
	 */
	private static boolean execute(
		final String pathOld,
		final String pathInst,
		final String pathNew )
	{
		final String failed = "Upgrade is failed for some reason.";
		final String separator = System.getProperty("file.separator");

		// check whether installer exists
		File inst = new File( pathInst );
		if( inst.exists() == false )
		{
			JOptionPane.showMessageDialog(
				null,
//				"Installer not found.\n"
//				+ "Failed to install the latest version."
				failed
			);
			return false;
		}
		inst.deleteOnExit();	// set to be deleted on exit


		// check whether uninstaller exists
		String uninstPath = pathOld + separator + "Uninstall.exe";
		File uninst = new File( uninstPath );
		if( uninst.exists() == false )
		{
			JOptionPane.showMessageDialog(
				null,
//				"Uninstaller not found.\n"
//				+ "Failed to uninstall the old version."
				failed
			);
			return false;
		}


		// execute the uninstaller
		try
		{
			String[] cmdArray = new String[2];
			cmdArray[0] = uninstPath;
			cmdArray[1] = "/S";
			Process p = Runtime.getRuntime().exec( cmdArray );
			try
			{
				p.waitFor();
			}
			catch( InterruptedException ex )
			{
			}
		}
		catch( IOException ex )
		{
			JOptionPane.showMessageDialog(
				null,
//				"Failed to uninstall the old version."
				failed
			);
			return false;
		}


		// show a message dialog
		JOptionPane.showMessageDialog(
			null,
			"Successfully uninstalled the old version."
		);

		
		// execute installer
		String option = "/D=" + pathNew;
		try
		{
			String[] cmdArray = new String[3];
			cmdArray[0] = pathInst;
			cmdArray[1] = "/S";
			cmdArray[2] = option;

//JOptionPane.showMessageDialog( null, "pathInst@"+pathInst );
//JOptionPane.showMessageDialog( null, "option@"+option );

			Process p = Runtime.getRuntime().exec( cmdArray );
			try
			{
				p.waitFor();
			}
			catch( InterruptedException ex )
			{
			}
		}
		catch( IOException ex )
		{
			JOptionPane.showMessageDialog(
				null,
//				"Failed to install the latest version."
				failed
			);
			return false;
		}


		// show a message dialog
		JOptionPane.showMessageDialog(
			null,
			"Successfully installed the latest version."
		);

		// execute the new version
		String javaw = System.getProperty("java.home")
			+ separator + "bin" + separator + "javaw.exe";
		String newVersion = pathNew + separator + "samurai-graph.jar";

//JOptionPane.showMessageDialog( null, "newVersion@"+newVersion );

		try
		{
			String[] cmdArray = new String[4];
			cmdArray[0] = javaw;
			cmdArray[1] = "-Xmx128M";
			cmdArray[2] = "-jar";
			cmdArray[3] = newVersion;
			Runtime.getRuntime().exec( cmdArray, null, new File( pathNew ) );
		}
		catch( IOException ex )
		{
			JOptionPane.showMessageDialog(
				null,
				"Failed to start the latest version."
//				failed
			);
			return false;
		}

		return true;
	}

}
