/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import java.util.ArrayList;
import java.util.Collections;
import jp.robotbrain.signal.JudgmentResult;
import jp.robotbrain.signal.NmSignal;
import jp.robotbrain.signal.SignalComparator;
import jp.robotbrain.signal.SimpleSignal;
import jp.robotbrain.signal.Tag;

public class SummaryPriority {
    private int m_long;
    private int m_short;
    private int m_rest;
    private int m_neutral;

    public void addLong(int p_long) {
        this.m_long += p_long;
    }

    public int getLong() {
        return this.m_long;
    }

    public void addShort(int p_short) {
        this.m_short += p_short;
    }

    public int getShort() {
        return this.m_short;
    }

    public void addRest(int p_rest) {
        this.m_rest += p_rest;
    }

    public int getRest() {
        return this.m_rest;
    }

    public void addNeutral(int p_neutral) {
        this.m_neutral += p_neutral;
    }

    public int getNeutral() {
        return this.m_neutral;
    }

    public SimpleSignal getMaxSignal(Tag p_tag) {
        SimpleSignal longSum = new SimpleSignal("long", this.getLong());
        longSum.setJudgmentResult(new JudgmentResult(p_tag, NmSignal.LONG));
        SimpleSignal shortSum = new SimpleSignal("short", this.getShort());
        shortSum.setJudgmentResult(new JudgmentResult(p_tag, NmSignal.SHORT));
        SimpleSignal restSum = new SimpleSignal("rest", this.getRest());
        restSum.setJudgmentResult(new JudgmentResult(p_tag, NmSignal.REST));
        ArrayList<SimpleSignal> sumList = new ArrayList<SimpleSignal>();
        sumList.add(longSum);
        sumList.add(shortSum);
        sumList.add(restSum);
        return this.getMax(sumList);
    }

    private SimpleSignal getMax(ArrayList<SimpleSignal> p_signalList) {
        int count = 0;
        SimpleSignal returnValue = null;
        SimpleSignal max = (SimpleSignal)Collections.max(p_signalList, new SignalComparator());
        for (SimpleSignal s : p_signalList) {
            if (s.getPriority() < max.getPriority()) continue;
            ++count;
        }
        if (count == 1) {
            returnValue = max;
        }
        return returnValue;
    }
}

