/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.html;

import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import jp.robotbrain.html.HtmlFormException;
import jp.robotbrain.html.HtmlSelect;

public class HtmlSelectList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<HtmlSelect> m_htmlSelectList = new ArrayList();

    protected void add(HtmlSelect p_htmlSelect) {
        this.m_htmlSelectList.add(p_htmlSelect);
    }

    public HtmlSelect getHtmlSelectByName(String p_name) throws HtmlFormException {
        int i = 0;
        while (i < this.m_htmlSelectList.size()) {
            HtmlSelect htmlSelect = this.m_htmlSelectList.get(i);
            if (htmlSelect.getName().equals(p_name)) {
                return htmlSelect;
            }
            ++i;
        }
        throw new HtmlFormException("method:HtmlSelectList.getHtmlSelectByName p_name=" + p_name);
    }

    public void print(PrintStream p_out) {
        int i = 0;
        while (i < this.m_htmlSelectList.size()) {
            HtmlSelect htmlSelect = this.m_htmlSelectList.get(i);
            p_out.println("-- HtmlSelect(" + i + ") --");
            p_out.println(String.valueOf(htmlSelect.getId()) + "\t" + htmlSelect.getName());
            p_out.println("id\tvalue\ttitle\tselected");
            htmlSelect.print(p_out);
            ++i;
        }
    }

    public String createQueryString(String p_charset) throws HtmlFormException, UnsupportedEncodingException {
        String returnValue = "";
        int i = 0;
        while (i < this.m_htmlSelectList.size()) {
            HtmlSelect htmlSelect = this.m_htmlSelectList.get(i);
            String name = htmlSelect.getName();
            if (htmlSelect.getHtmlOptionList().getSelectedItem() == null) {
                throw new HtmlFormException("Not Select Item: " + name);
            }
            String selectedItem = htmlSelect.getHtmlOptionList().getSelectedItem().getValue();
            returnValue = String.valueOf(returnValue) + "&" + name + "=" + URLEncoder.encode(selectedItem, p_charset);
            ++i;
        }
        return returnValue;
    }

    public boolean equalsFormat(HtmlSelectList p_other) {
        if (this.m_htmlSelectList.size() != p_other.m_htmlSelectList.size()) {
            return false;
        }
        int i = 0;
        while (i < this.m_htmlSelectList.size()) {
            HtmlSelect other;
            HtmlSelect me = this.m_htmlSelectList.get(i);
            if (!me.equalsFormat(other = p_other.m_htmlSelectList.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

