/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.framework;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import jp.robotbrain.common.DoubleEx;
import jp.robotbrain.common.UtilCalc;
import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneListException;

public final class GeneList
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<Gene> m_geneList = new ArrayList();

    public Object clone() {
        GeneList newGeneList = new GeneList();
        for (Gene srcg : this.m_geneList) {
            try {
                newGeneList.add((Gene)srcg.clone());
            }
            catch (GeneListException e) {
                e.printStackTrace();
                throw new RuntimeException();
            }
        }
        return newGeneList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isEquals(GeneList p_other) {
        if (this.m_geneList.size() != p_other.size()) {
            return false;
        }
        try {
            int i = 0;
            while (true) {
                if (i >= this.m_geneList.size()) {
                    return true;
                }
                Gene me = this.m_geneList.get(i);
                Gene other = p_other.getGene(i);
                if (me.getDoubleValue() != other.getDoubleValue()) {
                    return false;
                }
                ++i;
            }
        }
        catch (GeneListException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    public GeneList createMutant() {
        try {
            GeneList mutant = (GeneList)this.clone();
            int no = UtilCalc.random(this.size() - 1);
            mutant.getGene(no).initRandom();
            return mutant;
        }
        catch (GeneListException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    public GeneList createChild(GeneList p_other, double p_heredityRate) {
        try {
            GeneList child = new GeneList();
            int i = 0;
            while (i < this.size()) {
                child.add(UtilCalc.probability(p_heredityRate) ? p_other.getGene(i) : this.getGene(i));
                ++i;
            }
            return child;
        }
        catch (GeneListException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    public void initRandom() {
        for (Gene g : this.m_geneList) {
            g.initRandom();
        }
    }

    public void add(Gene p_gene) throws GeneListException {
        if (this.m_geneList.indexOf(p_gene) >= 0) {
            throw new GeneListException("It already exists Label " + p_gene.getLabel());
        }
        this.m_geneList.add(p_gene);
    }

    public void clear() {
        this.m_geneList.clear();
    }

    public int size() {
        return this.m_geneList.size();
    }

    public Gene getGene(String p_label) throws GeneListException {
        for (Gene g : this.m_geneList) {
            if (!g.getLabel().equals(p_label)) continue;
            return g;
        }
        throw new GeneListException("Error NotFound Gene Label =" + p_label);
    }

    public Gene getGene(int p_index) throws GeneListException {
        if (p_index < 0 || p_index >= this.size()) {
            throw new GeneListException("Error NotFound Gene Index =" + p_index);
        }
        return this.m_geneList.get(p_index);
    }

    public void print(PrintStream p_out) {
        for (Gene g : this.m_geneList) {
            p_out.println(g.getStatus());
        }
    }

    public String getValuesString() {
        String returnValue = "";
        int i = 0;
        while (i < this.m_geneList.size()) {
            Gene g = this.m_geneList.get(i);
            returnValue = String.valueOf(returnValue) + (i == 0 ? "" : ",") + DoubleEx.format(g.getDoubleValue(), g.getScale());
            ++i;
        }
        return returnValue;
    }

    public String getLabelsString() {
        String returnValue = "";
        int i = 0;
        while (i < this.m_geneList.size()) {
            Gene g = this.m_geneList.get(i);
            returnValue = String.valueOf(returnValue) + (i == 0 ? "" : ",") + g.getLabel();
            ++i;
        }
        return returnValue;
    }

    public void copyDesign(GeneList p_src) {
        try {
            int i = 0;
            while (i < this.m_geneList.size()) {
                Gene me = this.getGene(i);
                me.copyDesign(p_src.getGene(i));
                ++i;
            }
        }
        catch (GeneListException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    public void setValue(Gene p_src) {
        for (Gene g : this.m_geneList) {
            if (!g.getLabel().equals(p_src.getLabel())) continue;
            g.setDoubleValue(p_src.getDoubleValue());
        }
    }

    public void setValues(GeneList p_src) {
        for (Gene g : p_src.m_geneList) {
            this.setValue(g);
        }
    }

    public GeneList createOptimizeGeneList() {
        GeneList returnValue = new GeneList();
        for (Gene g : this.m_geneList) {
            if (!g.isOptimize()) continue;
            try {
                returnValue.add(g);
            }
            catch (GeneListException e) {
                e.printStackTrace();
                throw new RuntimeException();
            }
        }
        return returnValue;
    }
}

