<?php
/* ========================================================================
 - [database/database.php]
 - 内容：データベース
 - 作成：高橋 裕志郎
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://study.rakuto.net/
 -      Copyright (C) 2005-2006 `rakuto.net'. All Rights Reserved.
 - 更新履歴：
 -      [2006/03/05] PDO1.0以降に対応
 -      [2005/01/08] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'rsl_webapp.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends RSL_webapp
{
    /**
     * パス
     * @var string
     */
    private $dbdir = "";

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    public function execute()
    {
        $this->template_file = 'database/database.tpl';
        $this->addCss('common.css');
        $this->addJavas('common.js');

        if (!empty($_REQUEST['set_dbinfo'])){
            $this->dbinfo->setRequestValue();
            header("Location: ".$_SERVER['PHP_SELF']."?m=browse");
            exit();
        }
        $this->dbdir = empty($_GET['dbdir']) ? DEFAULT_DB_DIR:$_GET['dbdir'];

        $this->set_sqlite_version();
        $this->set_dirinfo();
        $this->set_list();

        $this->Assign('dbname',$this->dbinfo->getDbName());
        $this->set_encode();
        $this->set_auto_query();

        $this->Assign('separator',DIRECTORY_SEPARATOR);
    }

    /**
     * ディレクトリ情報の設定
     *
     * @access private
     * @return void
     **/
    private function set_dirinfo()
    {
        $this->Assign('dbdir', $this->dbdir);

        /* 一つ上のディレクトリ */
        $dirup = substr($this->dbdir, 0, -1);
        $dirup = substr($this->dbdir, 0, strrpos($dirup, DIRECTORY_SEPARATOR)+1);
        if (DEFAULT_DB_DIR == $this->dbdir){
            $dirup = DEFAULT_DB_DIR;
        }
        $this->Assign('dirup', $dirup);


        /* カレントのサイズ */
        $size = exec('du -s -k '.$this->dbdir);
        $size = substr($size, 0, strpos($size, DIRECTORY_SEPARATOR));
        $this->Assign('cur_size', number_format($size));
    }

    /**
     * sqliteのバージョンを設定
     *
     * @access private
     * @return void
     **/
    private function set_sqlite_version()
    {
        /* データの取得 */
        $stmt = $this->objdb->prepare('SELECT sqlite_version(*) as ver'); 
        $stmt->execute();
        $version = $stmt->fetch(PDO::FETCH_ASSOC);
        $stmt = null;
 
        $this->Assign('version', $version['ver']);
    }

    /**
     * ディレクトリファイルリストの設定
     *
     * @access private
     * @return void
     **/
    private function set_list()
    {
        if (!is_dir($this->dbdir)){
            return false;
        }
    
        $files = array();
        $dh  = opendir($this->dbdir);
        if (!$dh){
            return false;
        }

        while (false !== ($file = readdir($dh))) {
            if ($file != "." && $file != "..") {
                $files[] = $file;
            }
        } // while (false !== ($filename = readdir($dh)))
        closedir($dh);

        sort($files);
    
        $dblist = array();
        $infos = array();
        $row = 0;
        $list = array();
        $isdir = false;
        $isfile = false;
        foreach ($files as $row=>$file){
            $infos = stat($this->dbdir.$file);
            if (is_dir($this->dbdir.$file)){
                $isdir = true;
                $isfile = false;
                $size = exec('du -s -k '.$this->dbdir.$file."/");
                $size = substr($size, 0, strpos($size, "/"));
            } else {
                $isdir = false;
                $isfile = true;
                $size = $infos[7]/1000;
                
                /* DBリストの取得 */
                $dblist[]['name'] = $file;
            }
        
            $list[$row]['name'] = $file;
            $list[$row]['isdir'] = $isdir;
            $list[$row]['isfile'] = $isfile;
            $list[$row]['mode'] = substr(decoct($infos[2]),-4);
            $list[$row]['uid'] = $infos[4];
            $list[$row]['gid'] = $infos[5];
            $list[$row]['size'] = number_format($size);
            $list[$row]['mtime'] = date("Y/m/d H:i:s",$infos[9]);
        }

        $this->Assign('dblist', $dblist);
        $this->Assign('list', $list);
        
        $nolist = (count($list)<=0)?true:false;
        $this->Assign('nolist', $nolist);
    }

    /**
     * encodeの設定
     *
     * @access private
     * @return void
     **/
    private function set_encode()
    {
        $keys = array(
            'ASCII'=> 'ASCII',
            'JIS'=>   'JIS',
            'UTF-8'=> 'UTF-8',
            'EUC-JP'=>'EUC-JP',
            'SJIS'=>  'SJIS'
        );
        $selected = $this->dbinfo->getEncode();
        $list = $this->getSelectList($keys,$selected);
        $this->Assign('encode',$list);
    }

    /**
     * auto_queryの設定
     *
     * @access private
     * @return void
     **/
    private function set_auto_query()
    {
        $keys = array(
            '1'=> '確認しない',
            '0'=>   '確認する'
        );
        $checked = $this->dbinfo->getAutoQuery();
        $list = $this->getRadioList('auto_query',$keys,$checked);
        $this->Assign('auto_query',$list);
    }
} // webapp
?>
