<?php
/* ========================================================================
 - [rsl_db_info.php]
 - 内容：データベース情報管理クラス
 - 作成：高橋 裕志郎
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://study.rakuto.net/
 -      Copyright (C) 2005-2006 `rakuto.net'. All Rights Reserved.
 - 更新履歴：
 -      [2006/03/05] PDO1.0以降に対応
 -      [2005/01/04] 作成
 - ======================================================================== */

/**
 * データベース情報管理クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RSL_db_info
 * @access public
 * @version 0.1
 */
class RSL_db_info
{
    /**
     * database名
     * @var string
     */
    var $dbname = 'rktSQLite.db';

    /**
     * table名
     * @var string
     */
    var $tblname = '';

    /**
     * 文字コード
     * @var string
     */
    var $encode = 'UTF-8';

    /**
     * データベースディレクトリパス
     * @var string
     */
    var $dbdir = DEFAULT_DB_DIR;

    /**
     * 自動クエリ（クエリ内容確認）
     * @var integer
     */
    var $auto_query = 0;

    /**
     * クエリ（SQL文）
     * @var string
     */
    var $query = "";
    
    /**
     * インスタンス生成
     *
     * @access public
     * @return string
     */
    function &Instance($id=DEF_SESSION_ID)
    {
        session_save_path(SESSION_DIR);
        $session_id = empty($id) ? session_id():session_id($id);

        if (!$session_id){
            session_start();
        }
        if (!isSet($_SESSION['db_info'])) {
            $_SESSION['db_info'] = new RSL_db_info();
        }
        return $_SESSION['db_info'];
    }

    /**
     * コンストラクタ
     *
     * @access public
     * @return void
     */
    public function __construct()
    {
        // database名
        $this->dbname = 'rktSQLite.db';

        // 文字コード
        $this->encode = 'UTF-8';

        // データベースディレクトリパス
        $this->dbdir = DEFAULT_DB_DIR;

        // 自動クエリ（クエリ内容確認）
        $this->auto_query = false;
    }

    /**
     * アカウント削除
     *
     * @access public
     * @return void
     */
    public function accountDestroy()
    {
        unset($_SESSION['account']);

        /* セッションファイルの削除 */
        $path = session_save_path();
        $filename = $path."sess_".session_id();
        session_unset();

        if (is_file($filename)){
            @unlink($filename);
        }
    }

    /**
     * セッションIDの取得
     *
     * @access public
     * @return string セッションID
     */
    public function getSessionID()
    {
        return session_id();
    }

    /**
     * ユーザー情報の取得
     *
     * @access public
     * @return void
     */
    public function setRequestValue()
    {
        // database名
        $dbname = empty($_REQUEST['dblist'])?'rktSQLite.db':$_REQUEST['dblist'];
        $this->dbname = empty($_REQUEST['dbname'])?$dbname:$_REQUEST['dbname'];

        // 文字コード
        $encodes = array('ASCII'=>true, 'JIS'=>true, 'UTF-8'=>true, 'EUC-JP'=>true, 'SJIS'=>true);
        $encode = empty($_REQUEST['encode'])?'EUC-JP':$_REQUEST['encode'];
        $this->encode = isSet($encodes[$encode])?$encode:'EUC-JP';

        // データベースディレクトリパス
        $dbdir = empty($_REQUEST['dbdir'])?DEFAULT_DB_DIR:$_REQUEST['dbdir'];
        $this->dbdir = file_exists($dbdir)?$dbdir:DEFAULT_DB_DIR;

        // 自動クエリ（クエリ内容確認）
        $this->auto_query = empty($_REQUEST['auto_query'])?0:1;
    }

    /**
     * セッションIDの取得
     *
     * @access public
     * @return string
     */
    public function getDbFile()
    {
        return $this->dbdir.$this->dbname;
    }

    /**
     * database名の取得
     *
     * @access public
     * @return string
     */
    public function getDbName()
    {
        return $this->dbname;
    }

    /**
     * table名の設定
     *
     * @access public
     * @param string $tblname
     * @return void
     */
    public function setTableName($tblname)
    {
        $this->tblname = $tblname;
    }

    /**
     * table名の取得
     *
     * @access public
     * @return string
     */
    public function getTableName()
    {
        return $this->tblname;
    }

    /**
     * encodeの取得
     *
     * @access public
     * @return string
     */
    public function getEncode()
    {
        return $this->encode;
    }

    /**
     * auto_queryの取得
     *
     * @access public
     * @return integer
     */
    public function getAutoQuery()
    {
        return $this->auto_query;
    }

    /**
     * クエリの設定
     *
     * @access public
     * @param string
     * @return void
     */
    public function setQuery($query)
    {
        $this->query = $query;
    }

    /**
     * クエリの取得
     *
     * @access public
     * @return string
     */
    public function getQuery()
    {
        return $this->query;
    }
} // RSL_db_infoの終了
?>
