
class Star_Dust_Sprites
  
  # oIuWFNgpXvCg
  class Sprite_Dust < Sprite
    
    attr_accessor :x_start
    attr_accessor :y_start
    
    # 
    def initialize(x,y,viewport=nil)
      super(viewport)
      #            self.bitmap = Bitmap.new(2,2)
      #            self.bitmap.fill_rect(self.bitmap.rect,Color.new(255,255,255,255))
      self.bitmap = RPG::Cache.picture('star')
      @sprites = []
      0.upto(5 + rand(5)) do |i|
        @sprites.push Sprite.new(@viewport)
      end
      
      @x_range_default = -500 .. 500
      @y_range_default = -500 .. 500
      @x_start = x
      @y_start = y
      @x_center = 0
      @y_center = 0
      self.z = 200
      self.blend_type = 1
      self.zoom_y = self.zoom_x = 0.5 + 0.5 * rand()
      
      refresh()
      @sprites.each_index do |i|
        s = @sprites[i]
        s.bitmap = self.bitmap
        s.x = -640
        s.y = -640
        s.z = self.z
        s.blend_type = self.blend_type
        s.zoom_x = self.zoom_x / 10.0 * (10.0 - i)
        s.zoom_y = self.zoom_y / 10.0 * (10.0 - i)
      end
    end
    
    def refresh()
      @x_range = (@x_start + @x_range_default.first) .. (@x_start + @x_range_default.last)
      @y_range = (@y_start + @y_range_default.first) .. (@y_start + @y_range_default.last)
      @_x = 20.0 * rand()
      @_speed = (0.10 + rand()) * -1
      @_velocity = (0.01 * rand()) * -1
      @_a = 0.01 + 0.05 * rand()
      
      @_y = @_a * @_x * @_x
      
      @x_center = @x_start - @_x + rand(8) - 4
      @y_center = @y_start - @_y + rand(8) - 4
      
      self.opacity = 255
    end
    
    # j
    def dispose()
      self.bitmap.dispose() unless self.bitmap.nil?
      @sprites.each do |s|
        s.dispose()
      end
    end
    
    # XV
    def update()
      super()
       (@sprites.size() - 1).downto(0) do |i|
        if i == 0
          @sprites[i].x = self.x if self.x != 0
          @sprites[i].y = self.y if self.y != 0
          @sprites[i].opacity = self.opacity
        else
          @sprites[i].x = @sprites[i-1].x
          @sprites[i].y = @sprites[i-1].y
          @sprites[i].opacity = @sprites[i-1].opacity - i * 5
        end
      end
      @_y = @_a * @_x * @_x
      self.x = @x_center + @_x.to_i
      self.y = @y_center + @_y.to_i
      @_x += @_speed
      @_speed += @_velocity
      self.opacity += -2
      if (not @x_range.include?(self.x)) or (not @y_range.include?(self.y))
        refresh()
      end
    end
    
  end
  
  attr_accessor :x
  attr_accessor :y
  attr_accessor :star_total
  
  # 
  def initialize(viewport=nil)
    @viewport = nil
    @x = 0
    @y = 0
    
    @star_total = 10
    
    @sprites = []
    
    @create_count = 0
    
  end
  
  # X
  def x=(n)
    return if @x == n
    @x = n
    @sprites.each {|s| s.x_start = n}
  end
  
  # Y
  def y=(n)
    return if @y == n
    @y = n
    @sprites.each {|s| s.y_start = n}
  end
  
  # j
  def dispose()
    @sprites.each {|s| s.dispose()}
  end
  
  # XV
  def update()
    if @sprites.size < @star_total
      if @create_count > 4
        sprite = Sprite_Dust.new(@x,@y,@viewport)
        @sprites.push(sprite)
        @create_count = 0
      end
      @create_count += 1
    elsif @sprites.size > @star_total
      @sprites.pop.dispose()
    end
    @sprites.each {|s| s.update}
  end
  
end
